
module ol_colourmatrix_ppaaaj2_uuxaaag_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,1), KL(0,1), KL2(23,1), KL2ct(23,1), KL2ct2(23,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  12]
  KL2( 2,:) = [  16]
  KL2( 3,:) = [   2]
  KL2( 4,:) = [  16]
  KL2( 5,:) = [   0]
  KL2( 6,:) = [   0]
  KL2( 7,:) = [   0]
  KL2( 8,:) = [   0]
  KL2( 9,:) = [   0]
  KL2(10,:) = [   0]
  KL2(11,:) = [   0]
  KL2(12,:) = [   0]
  KL2(13,:) = [   0]
  KL2(14,:) = [   0]
  KL2(15,:) = [   0]
  KL2(16,:) = [   0]
  KL2(17,:) = [ -18]
  KL2(18,:) = [ -18]
  KL2(19,:) = [   0]
  KL2(20,:) = [   0]
  KL2(21,:) = [   0]
  KL2(22,:) = [  36]
  KL2(23,:) = [   0]
  KL2 = (1._/**/REALKIND / 3) * KL2

  KL2ct( 1,:) = [  12]
  KL2ct( 2,:) = [  16]
  KL2ct( 3,:) = [   2]
  KL2ct( 4,:) = [  16]
  KL2ct( 5,:) = [   0]
  KL2ct( 6,:) = [   0]
  KL2ct( 7,:) = [   0]
  KL2ct( 8,:) = [   0]
  KL2ct( 9,:) = [   0]
  KL2ct(10,:) = [   0]
  KL2ct(11,:) = [   0]
  KL2ct(12,:) = [   0]
  KL2ct(13,:) = [   0]
  KL2ct(14,:) = [   0]
  KL2ct(15,:) = [   0]
  KL2ct(16,:) = [   0]
  KL2ct(17,:) = [ -18]
  KL2ct(18,:) = [ -18]
  KL2ct(19,:) = [   0]
  KL2ct(20,:) = [   0]
  KL2ct(21,:) = [   0]
  KL2ct(22,:) = [  36]
  KL2ct(23,:) = [   0]
  KL2ct = (1._/**/REALKIND / 3) * KL2ct

  KL2ct2( 1,:) = [  12]
  KL2ct2( 2,:) = [  16]
  KL2ct2( 3,:) = [   2]
  KL2ct2( 4,:) = [  16]
  KL2ct2( 5,:) = [   0]
  KL2ct2( 6,:) = [   0]
  KL2ct2( 7,:) = [   0]
  KL2ct2( 8,:) = [   0]
  KL2ct2( 9,:) = [   0]
  KL2ct2(10,:) = [   0]
  KL2ct2(11,:) = [   0]
  KL2ct2(12,:) = [   0]
  KL2ct2(13,:) = [   0]
  KL2ct2(14,:) = [   0]
  KL2ct2(15,:) = [   0]
  KL2ct2(16,:) = [   0]
  KL2ct2(17,:) = [ -18]
  KL2ct2(18,:) = [ -18]
  KL2ct2(19,:) = [   0]
  KL2ct2(20,:) = [   0]
  KL2ct2(21,:) = [   0]
  KL2ct2(22,:) = [  36]
  KL2ct2(23,:) = [   0]
  KL2ct2 = (1._/**/REALKIND / 3) * KL2ct2


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppaaaj2_uuxaaag_2_/**/REALKIND



module ol_forced_parameters_ppaaaj2_uuxaaag_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (nf /= 5) write(*,101) 'nf = 5'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppaaaj2_uuxaaag_2_/**/REALKIND

module ol_loop_ppaaaj2_uuxaaag_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(5), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:64)
  ! denominators
  complex(REALKIND), save :: den(70)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,64), Mct(1,64), Mcol_loop(1,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = (2*CI*countertermnorm*ctAAGG*eQED**3*gQCD**3)/3._/**/REALKIND
    f(2) = (eQED**3*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(3) = (2*eQED**3*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(4) = (4*eQED**3*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(5) = (16*eQED**3*gQCD**3*integralnorm*SwF)/27._/**/REALKIND


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(0), M2(1)
  complex(REALKIND) :: A(6)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_VQ_A(wf(:,-2),wf(:,0),wf(:,1))
  call counter_VVG_G(wf(:,-3),wf(:,-4),wf(:,-5),wf(:,2))
  call prop_Q_A(wf(:,1),Q(:,5),ZERO,0_intkind1,wf(:,3))
  call vert_QA_V(wf(:,3),wf(:,-1),wf(:,4))
  call vert_AV_Q(wf(:,-1),wf(:,-2),wf(:,5))
  call prop_A_Q(wf(:,5),Q(:,6),ZERO,0_intkind1,wf(:,6))
  call vert_QA_V(wf(:,0),wf(:,6),wf(:,7))
  call vert_VQ_A(wf(:,-3),wf(:,0),wf(:,8))
  call counter_VVG_G(wf(:,-2),wf(:,-4),wf(:,-5),wf(:,9))
  call prop_Q_A(wf(:,8),Q(:,9),ZERO,0_intkind1,wf(:,10))
  call vert_QA_V(wf(:,10),wf(:,-1),wf(:,11))
  call vert_AV_Q(wf(:,-1),wf(:,-3),wf(:,12))
  call prop_A_Q(wf(:,12),Q(:,10),ZERO,0_intkind1,wf(:,13))
  call vert_QA_V(wf(:,0),wf(:,13),wf(:,14))
  call vert_VQ_A(wf(:,-4),wf(:,0),wf(:,15))
  call counter_VVG_G(wf(:,-2),wf(:,-3),wf(:,-5),wf(:,16))
  call prop_Q_A(wf(:,15),Q(:,17),ZERO,0_intkind1,wf(:,17))
  call vert_QA_V(wf(:,17),wf(:,-1),wf(:,18))
  call vert_AV_Q(wf(:,-1),wf(:,-4),wf(:,19))
  call prop_A_Q(wf(:,19),Q(:,18),ZERO,0_intkind1,wf(:,20))
  call vert_QA_V(wf(:,0),wf(:,20),wf(:,21))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,22))
  call vert_QA_V(wf(:,3),wf(:,13),wf(:,23))
  call vert_QA_V(wf(:,3),wf(:,20),wf(:,24))
  call vert_VQ_A(wf(:,-3),wf(:,3),wf(:,25))
  call prop_Q_A(wf(:,25),Q(:,13),ZERO,0_intkind1,wf(:,26))
  call vert_QA_V(wf(:,26),wf(:,-1),wf(:,27))
  call vert_VQ_A(wf(:,-4),wf(:,3),wf(:,28))
  call prop_Q_A(wf(:,28),Q(:,21),ZERO,0_intkind1,wf(:,29))
  call vert_QA_V(wf(:,29),wf(:,-1),wf(:,30))
  call vert_QA_V(wf(:,10),wf(:,6),wf(:,31))
  call vert_QA_V(wf(:,17),wf(:,6),wf(:,32))
  call vert_AV_Q(wf(:,6),wf(:,-3),wf(:,33))
  call prop_A_Q(wf(:,33),Q(:,14),ZERO,0_intkind1,wf(:,34))
  call vert_QA_V(wf(:,0),wf(:,34),wf(:,35))
  call vert_AV_Q(wf(:,6),wf(:,-4),wf(:,36))
  call prop_A_Q(wf(:,36),Q(:,22),ZERO,0_intkind1,wf(:,37))
  call vert_QA_V(wf(:,0),wf(:,37),wf(:,38))
  call vert_QA_V(wf(:,10),wf(:,20),wf(:,39))
  call vert_VQ_A(wf(:,-2),wf(:,10),wf(:,40))
  call prop_Q_A(wf(:,40),Q(:,13),ZERO,0_intkind1,wf(:,41))
  call vert_QA_V(wf(:,41),wf(:,-1),wf(:,42))
  call vert_VQ_A(wf(:,-4),wf(:,10),wf(:,43))
  call prop_Q_A(wf(:,43),Q(:,25),ZERO,0_intkind1,wf(:,44))
  call vert_QA_V(wf(:,44),wf(:,-1),wf(:,45))
  call vert_QA_V(wf(:,17),wf(:,13),wf(:,46))
  call vert_AV_Q(wf(:,13),wf(:,-2),wf(:,47))
  call prop_A_Q(wf(:,47),Q(:,14),ZERO,0_intkind1,wf(:,48))
  call vert_QA_V(wf(:,0),wf(:,48),wf(:,49))
  call vert_AV_Q(wf(:,13),wf(:,-4),wf(:,50))
  call prop_A_Q(wf(:,50),Q(:,26),ZERO,0_intkind1,wf(:,51))
  call vert_QA_V(wf(:,0),wf(:,51),wf(:,52))
  call vert_VQ_A(wf(:,-2),wf(:,17),wf(:,53))
  call prop_Q_A(wf(:,53),Q(:,21),ZERO,0_intkind1,wf(:,54))
  call vert_QA_V(wf(:,54),wf(:,-1),wf(:,55))
  call vert_VQ_A(wf(:,-3),wf(:,17),wf(:,56))
  call prop_Q_A(wf(:,56),Q(:,25),ZERO,0_intkind1,wf(:,57))
  call vert_QA_V(wf(:,57),wf(:,-1),wf(:,58))
  call vert_AV_Q(wf(:,20),wf(:,-2),wf(:,59))
  call prop_A_Q(wf(:,59),Q(:,22),ZERO,0_intkind1,wf(:,60))
  call vert_QA_V(wf(:,0),wf(:,60),wf(:,61))
  call vert_AV_Q(wf(:,20),wf(:,-3),wf(:,62))
  call prop_A_Q(wf(:,62),Q(:,26),ZERO,0_intkind1,wf(:,63))
  call vert_QA_V(wf(:,0),wf(:,63),wf(:,64))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,56))
  den(4) = 1 / (Q(5,6))
  den(6) = 1 / (Q(5,9))
  den(7) = 1 / (Q(5,52))
  den(9) = 1 / (Q(5,10))
  den(11) = 1 / (Q(5,17))
  den(12) = 1 / (Q(5,44))
  den(14) = 1 / (Q(5,18))
  den(16) = 1 / (Q(5,3))
  den(18) = 1 / (Q(5,15))
  den(21) = 1 / (Q(5,23))
  den(23) = 1 / (Q(5,7))
  den(25) = 1 / (Q(5,13))
  den(28) = 1 / (Q(5,21))
  den(36) = 1 / (Q(5,14))
  den(39) = 1 / (Q(5,22))
  den(43) = 1 / (Q(5,27))
  den(45) = 1 / (Q(5,11))
  den(49) = 1 / (Q(5,25))
  den(57) = 1 / (Q(5,26))
  den(60) = 1 / (Q(5,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(8) = den(6)*den(7)
  den(10) = den(7)*den(9)
  den(13) = den(11)*den(12)
  den(15) = den(12)*den(14)
  den(17) = den(1)*den(9)
  den(19) = den(17)*den(18)
  den(20) = den(1)*den(14)
  den(22) = den(20)*den(21)
  den(24) = den(1)*den(23)
  den(26) = den(1)*den(25)
  den(27) = den(18)*den(26)
  den(29) = den(1)*den(28)
  den(30) = den(21)*den(29)
  den(31) = den(4)*den(6)
  den(32) = den(18)*den(31)
  den(33) = den(4)*den(11)
  den(34) = den(21)*den(33)
  den(35) = den(4)*den(23)
  den(37) = den(4)*den(36)
  den(38) = den(18)*den(37)
  den(40) = den(4)*den(39)
  den(41) = den(21)*den(40)
  den(42) = den(6)*den(14)
  den(44) = den(42)*den(43)
  den(46) = den(6)*den(45)
  den(47) = den(6)*den(25)
  den(48) = den(18)*den(47)
  den(50) = den(6)*den(49)
  den(51) = den(43)*den(50)
  den(52) = den(9)*den(11)
  den(53) = den(43)*den(52)
  den(54) = den(9)*den(45)
  den(55) = den(9)*den(36)
  den(56) = den(18)*den(55)
  den(58) = den(9)*den(57)
  den(59) = den(43)*den(58)
  den(61) = den(11)*den(60)
  den(62) = den(11)*den(28)
  den(63) = den(21)*den(62)
  den(64) = den(11)*den(49)
  den(65) = den(43)*den(64)
  den(66) = den(14)*den(60)
  den(67) = den(14)*den(39)
  den(68) = den(21)*den(67)
  den(69) = den(14)*den(57)
  den(70) = den(43)*den(69)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(6)


  A(1) = cont_VV(wf(:,2),wf(:,4)) * den(3)
  A(2) = cont_VV(wf(:,2),wf(:,7)) * den(5)
  A(3) = cont_VV(wf(:,9),wf(:,11)) * den(8)
  A(4) = cont_VV(wf(:,9),wf(:,14)) * den(10)
  A(5) = cont_VV(wf(:,16),wf(:,18)) * den(13)
  A(6) = cont_VV(wf(:,16),wf(:,21)) * den(15)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(6)
  complex(REALKIND), intent(out) :: M1(0), M2(1)


  M2(1) = (A(1)+A(2)+A(3)+A(4)+A(5)+A(6))*f(1)

end subroutine colourvectors

end module ol_loop_ppaaaj2_uuxaaag_2_/**/REALKIND
