
module ol_vamp_1_heftpphj_hggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphj_hggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphj_hggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphj_hggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphj_hggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,55) :: G0
  complex(REALKIND), dimension(4,5,4,76) :: G1
  complex(REALKIND), dimension(4,15,4,65) :: G2
  complex(REALKIND), dimension(4,35,4,15) :: G3
  complex(REALKIND), dimension(5,45) :: G1tensor
  complex(REALKIND), dimension(15,27) :: G2tensor
  complex(REALKIND), dimension(35,39) :: G3tensor
  complex(REALKIND), dimension(70,9) :: G4tensor
  complex(REALKIND), dimension(126,3) :: G5tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-1),Q(:,2),G1(:,:,:,1))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-3),wf(:,-2),G1(:,:,:,2))
  call check_last_GH_G(l_switch,G1(:,:,:,2),Q(:,14),wf(:,0),G3tensor(:,1), Q(:,15))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-2),wf(:,-3),G1(:,:,:,3))
  call check_last_GH_G(l_switch,G1(:,:,:,3),Q(:,14),wf(:,0),G3tensor(:,2), Q(:,15))
  call loop_GGG_G_23(G1(:,:,:,1),wf(:,-3),wf(:,-2),G1(:,:,:,4))
  call check_last_GH_G(l_switch,G1(:,:,:,4),Q(:,14),wf(:,0),G3tensor(:,3), Q(:,15))
  call loop_UV_W(G1(:,:,:,1),Q(:,2),wf(:,3),Q(:,12),G2(:,:,:,1))
  call check_last_GH_G(l_switch,G2(:,:,:,1),Q(:,14),wf(:,0),G4tensor(:,1), Q(:,15))
  call loop_UV_W(G1(:,:,:,1),Q(:,2),wf(:,-3),Q(:,8),G2(:,:,:,2))
  call loop_UV_W(G2(:,:,:,2),Q(:,10),wf(:,-2),Q(:,4),G3(:,:,:,1))
  call check_last_GH_G(l_switch,G3(:,:,:,1),Q(:,14),wf(:,0),G5tensor(:,1), Q(:,15))
  call loop_UV_W(G1(:,:,:,1),Q(:,2),wf(:,-2),Q(:,4),G2(:,:,:,3))
  call loop_UV_W(G2(:,:,:,3),Q(:,6),wf(:,-3),Q(:,8),G3(:,:,:,2))
  call check_last_GH_G(l_switch,G3(:,:,:,2),Q(:,14),wf(:,0),G5tensor(:,2), Q(:,15))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-2),Q(:,4),G1(:,:,:,5))
  call loop_GGG_G_12(G1(:,:,:,5),wf(:,-3),wf(:,-1),G1(:,:,:,6))
  call check_last_GH_G(l_switch,G1(:,:,:,6),Q(:,14),wf(:,0),G3tensor(:,4), Q(:,15))
  call loop_GGG_G_12(G1(:,:,:,5),wf(:,-1),wf(:,-3),G1(:,:,:,7))
  call check_last_GH_G(l_switch,G1(:,:,:,7),Q(:,14),wf(:,0),G3tensor(:,5), Q(:,15))
  call loop_GGG_G_23(G1(:,:,:,5),wf(:,-3),wf(:,-1),G1(:,:,:,8))
  call check_last_GH_G(l_switch,G1(:,:,:,8),Q(:,14),wf(:,0),G3tensor(:,6), Q(:,15))
  call loop_GHG_G(G1(:,:,:,5),Q(:,4),wf(:,0),wf(:,-3),Q(:,8),G2(:,:,:,4), Q(:,13))
  call check_last_UV_W(l_switch,G2(:,:,:,4),Q(:,13),wf(:,-1),Q(:,2),G3tensor(:,7))
  call loop_UV_W(G1(:,:,:,5),Q(:,4),wf(:,-3),Q(:,8),G2(:,:,:,5))
  call check_last_GHG_G(l_switch,G2(:,:,:,5),Q(:,12),wf(:,0),wf(:,-1),Q(:,2),G3tensor(:,8), Q(:,15))
  call check_last_UV_W(l_switch,G2(:,:,:,5),Q(:,12),wf(:,2),Q(:,3),G3tensor(:,9))
  call loop_UV_W(G1(:,:,:,5),Q(:,4),wf(:,6),Q(:,9),G2(:,:,:,6))
  call check_last_UV_W(l_switch,G2(:,:,:,6),Q(:,13),wf(:,-1),Q(:,2),G3tensor(:,10))
  call loop_UV_W(G1(:,:,:,5),Q(:,4),wf(:,5),Q(:,10),G2(:,:,:,7))
  call check_last_GH_G(l_switch,G2(:,:,:,7),Q(:,14),wf(:,0),G4tensor(:,2), Q(:,15))
  call loop_UV_W(G1(:,:,:,5),Q(:,4),wf(:,-1),Q(:,2),G2(:,:,:,8))
  call loop_UV_W(G2(:,:,:,8),Q(:,6),wf(:,-3),Q(:,8),G3(:,:,:,3))
  call check_last_GH_G(l_switch,G3(:,:,:,3),Q(:,14),wf(:,0),G5tensor(:,3), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,-1),G0(:,:,:,2))
  call loop_UV_W(G0(:,:,:,2),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,9))
  call check_last_GH_G(l_switch,G1(:,:,:,9),Q(:,14),wf(:,0),G3tensor(:,11), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,-2),G0(:,:,:,3))
  call loop_UV_W(G0(:,:,:,3),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,10))
  call check_last_GH_G(l_switch,G1(:,:,:,10),Q(:,14),wf(:,0),G3tensor(:,12), Q(:,15))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,-1),G0(:,:,:,4))
  call loop_UV_W(G0(:,:,:,4),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,11))
  call check_last_GH_G(l_switch,G1(:,:,:,11),Q(:,14),wf(:,0),G3tensor(:,13), Q(:,15))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,0),wf(:,-2),Q(:,4),G1(:,:,:,12), Q(:,5))
  call loop_UV_W(G1(:,:,:,12),Q(:,5),wf(:,-3),Q(:,8),G2(:,:,:,9))
  call check_last_UV_W(l_switch,G2(:,:,:,9),Q(:,13),wf(:,-1),Q(:,2),G3tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,4),ZERO,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-3),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,12),ZERO,G2(:,:,:,10))
  call loop_AV_Q(G2(:,:,:,10),wf(:,2),G2(:,:,:,11))
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,15),ZERO,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,13),wf(:,6),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,13),ZERO,G2(:,:,:,12))
  call loop_AV_Q(G2(:,:,:,12),wf(:,-1),G2(:,:,:,13))
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,15),ZERO,G3tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,4),ZERO,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,-3),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,12),ZERO,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,2),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,15),ZERO,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,16),wf(:,6),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,13),ZERO,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,-1),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,15),ZERO,G3tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,4),MB,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-3),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,12),MB,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,2),G2(:,:,:,19))
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,15),MB,G3tensor(:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,6),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,13),MB,G2(:,:,:,20))
  call loop_AV_Q(G2(:,:,:,20),wf(:,-1),G2(:,:,:,21))
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,15),MB,G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,19),wf(:,5),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,14),MB,G2(:,:,:,22))
  call loop_AS_Q(G2(:,:,:,22),wf(:,0),G2(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,15),MB,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-1),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,6),MB,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-3),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,14),MB,G3(:,:,:,4))
  call loop_AS_Q(G3(:,:,:,4),wf(:,0),G3(:,:,:,5),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,5),Q(:,15),MB,G4tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,4),MB,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,-3),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,12),MB,G2(:,:,:,26))
  call loop_QV_A(G2(:,:,:,26),wf(:,2),G2(:,:,:,27))
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,15),MB,G3tensor(:,22))
  call loop_QV_A(G1(:,:,:,24),wf(:,6),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,13),MB,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-1),G2(:,:,:,29))
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,15),MB,G3tensor(:,23))
  call loop_QV_A(G1(:,:,:,24),wf(:,5),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,14),MB,G2(:,:,:,30))
  call loop_QS_A(G2(:,:,:,30),wf(:,0),G2(:,:,:,31),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,15),MB,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,-1),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,6),MB,G2(:,:,:,32))
  call loop_QV_A(G2(:,:,:,32),wf(:,-3),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,14),MB,G3(:,:,:,6))
  call loop_QS_A(G3(:,:,:,6),wf(:,0),G3(:,:,:,7),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,7),Q(:,15),MB,G4tensor(:,4))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-2),G1(:,:,:,29))
  call loop_DV_C(G1(:,:,:,29),Q(:,4),wf(:,-3),G2(:,:,:,34))
  call check_last_DV_C(l_switch,G2(:,:,:,34),Q(:,12),wf(:,2),G3tensor(:,25))
  call loop_DV_C(G1(:,:,:,29),Q(:,4),wf(:,6),G2(:,:,:,35))
  call check_last_DV_C(l_switch,G2(:,:,:,35),Q(:,13),wf(:,-1),G3tensor(:,26))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-2),Q(:,4),G1(:,:,:,30))
  call loop_CV_D(G1(:,:,:,30),Q(:,4),wf(:,-3),Q(:,8),G2(:,:,:,36))
  call check_last_CV_D(l_switch,G2(:,:,:,36),Q(:,12),wf(:,2),Q(:,3),G3tensor(:,27))
  call loop_CV_D(G1(:,:,:,30),Q(:,4),wf(:,6),Q(:,9),G2(:,:,:,37))
  call check_last_CV_D(l_switch,G2(:,:,:,37),Q(:,13),wf(:,-1),Q(:,2),G3tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,5),ZERO,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,-3),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,13),ZERO,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,-1),G2(:,:,:,39))
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,15),ZERO,G3tensor(:,29))
  call loop_AV_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,5),ZERO,G1(:,:,:,33))
  call loop_AV_Q(G1(:,:,:,33),wf(:,-3),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,13),ZERO,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-1),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,15),ZERO,G3tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,5),MB,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,-3),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,13),MB,G2(:,:,:,42))
  call loop_QV_A(G2(:,:,:,42),wf(:,-1),G2(:,:,:,43))
  call check_last_Q_A(l_switch,G2(:,:,:,43),Q(:,15),MB,G3tensor(:,31))
  call loop_AV_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,5),MB,G1(:,:,:,37))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-3),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,13),MB,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,-1),G2(:,:,:,45))
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,15),MB,G3tensor(:,32))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,5),G1(:,:,:,39))
  call loop_CV_D(G1(:,:,:,39),Q(:,5),wf(:,-3),Q(:,8),G2(:,:,:,46))
  call check_last_CV_D(l_switch,G2(:,:,:,46),Q(:,13),wf(:,-1),Q(:,2),G3tensor(:,33))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,4),G1(:,:,:,40))
  call loop_DV_C(G1(:,:,:,40),Q(:,5),wf(:,-3),G2(:,:,:,47))
  call check_last_DV_C(l_switch,G2(:,:,:,47),Q(:,13),wf(:,-1),G3tensor(:,34))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,5),G1(:,:,:,41))
  call loop_UV_W(G1(:,:,:,41),Q(:,5),wf(:,-3),Q(:,8),G2(:,:,:,48))
  call check_last_UV_W(l_switch,G2(:,:,:,48),Q(:,13),wf(:,-1),Q(:,2),G3tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,6),MB,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,-3),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,14),MB,G2(:,:,:,49))
  call loop_QS_A(G2(:,:,:,49),wf(:,0),G2(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,15),MB,G3tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,6),MB,G1(:,:,:,44))
  call loop_AV_Q(G1(:,:,:,44),wf(:,-3),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,14),MB,G2(:,:,:,51))
  call loop_AS_Q(G2(:,:,:,51),wf(:,0),G2(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,15),MB,G3tensor(:,37))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,6),G1(:,:,:,46))
  call loop_UV_W(G1(:,:,:,46),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,53))
  call check_last_GH_G(l_switch,G2(:,:,:,53),Q(:,14),wf(:,0),G4tensor(:,5), Q(:,15))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,2),MB,G1(:,:,:,47))
  call loop_AV_Q(G1(:,:,:,47),wf(:,3),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,14),MB,G2(:,:,:,54))
  call loop_AS_Q(G2(:,:,:,54),wf(:,0),G2(:,:,:,55),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,15),MB,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-3),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,10),MB,G2(:,:,:,56))
  call loop_AV_Q(G2(:,:,:,56),wf(:,-2),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,14),MB,G3(:,:,:,8))
  call loop_AS_Q(G3(:,:,:,8),wf(:,0),G3(:,:,:,9),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,15),MB,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-2),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,6),MB,G2(:,:,:,58))
  call loop_AV_Q(G2(:,:,:,58),wf(:,-3),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,14),MB,G3(:,:,:,10))
  call loop_AS_Q(G3(:,:,:,10),wf(:,0),G3(:,:,:,11),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,15),MB,G4tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,2),MB,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,3),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,14),MB,G2(:,:,:,60))
  call loop_QS_A(G2(:,:,:,60),wf(:,0),G2(:,:,:,61),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,15),MB,G3tensor(:,39))
  call loop_QV_A(G1(:,:,:,51),wf(:,-3),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,10),MB,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,-2),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,14),MB,G3(:,:,:,12))
  call loop_QS_A(G3(:,:,:,12),wf(:,0),G3(:,:,:,13),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,13),Q(:,15),MB,G4tensor(:,8))
  call loop_QV_A(G1(:,:,:,51),wf(:,-2),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,6),MB,G2(:,:,:,64))
  call loop_QV_A(G2(:,:,:,64),wf(:,-3),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,14),MB,G3(:,:,:,14))
  call loop_QS_A(G3(:,:,:,14),wf(:,0),G3(:,:,:,15),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,15),MB,G4tensor(:,9))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-2),G0(:,:,:,17))
  call check_last_GHG_G(l_switch,G0(:,:,:,17),Q(:,12),wf(:,0),wf(:,-1),Q(:,2),G1tensor(:,1), Q(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,12),wf(:,2),Q(:,3),G1tensor(:,2))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,-3),G0(:,:,:,18))
  call check_last_GHG_G(l_switch,G0(:,:,:,18),Q(:,12),wf(:,0),wf(:,-1),Q(:,2),G1tensor(:,3), Q(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,12),wf(:,2),Q(:,3),G1tensor(:,4))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,-2),G0(:,:,:,19))
  call check_last_GHG_G(l_switch,G0(:,:,:,19),Q(:,12),wf(:,0),wf(:,-1),Q(:,2),G1tensor(:,5), Q(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,12),wf(:,2),Q(:,3),G1tensor(:,6))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-1),G0(:,:,:,20))
  call check_last_GHG_G(l_switch,G0(:,:,:,20),Q(:,10),wf(:,0),wf(:,-2),Q(:,4),G1tensor(:,7), Q(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,10),wf(:,4),Q(:,5),G1tensor(:,8))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,-3),G0(:,:,:,21))
  call check_last_GHG_G(l_switch,G0(:,:,:,21),Q(:,10),wf(:,0),wf(:,-2),Q(:,4),G1tensor(:,9), Q(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,10),wf(:,4),Q(:,5),G1tensor(:,10))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,-1),G0(:,:,:,22))
  call check_last_GHG_G(l_switch,G0(:,:,:,22),Q(:,10),wf(:,0),wf(:,-2),Q(:,4),G1tensor(:,11), Q(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,10),wf(:,4),Q(:,5),G1tensor(:,12))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,0),wf(:,-3),Q(:,8),G1(:,:,:,55), Q(:,9))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,55),wf(:,-2),wf(:,-1),G1tensor(:,13))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,55),wf(:,-1),wf(:,-2),G1tensor(:,14))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,55),wf(:,-2),wf(:,-1),G1tensor(:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,55),Q(:,9),wf(:,7),Q(:,6),G2tensor(:,1))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,-3),wf(:,-2),G0(:,:,:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,16))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,-2),wf(:,-3),G0(:,:,:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,17))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,-3),wf(:,-2),G0(:,:,:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,18))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,-3),wf(:,-1),G0(:,:,:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,19))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,-1),wf(:,-3),G0(:,:,:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,20))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,-3),wf(:,-1),G0(:,:,:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,21))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-3),Q(:,8),G1(:,:,:,56))
  call check_last_GHGG_G_12(l_switch,G1(:,:,:,56),wf(:,0),wf(:,-2),wf(:,-1),G1tensor(:,22))
  call check_last_GHGG_G_12(l_switch,G1(:,:,:,56),wf(:,0),wf(:,-1),wf(:,-2),G1tensor(:,23))
  call check_last_GHGG_G_23(l_switch,G1(:,:,:,56),wf(:,0),wf(:,-2),wf(:,-1),G1tensor(:,24))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,56),wf(:,-2),wf(:,2),G1tensor(:,25))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,56),wf(:,2),wf(:,-2),G1tensor(:,26))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,56),wf(:,-2),wf(:,2),G1tensor(:,27))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,56),wf(:,-1),wf(:,4),G1tensor(:,28))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,56),wf(:,4),wf(:,-1),G1tensor(:,29))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,56),wf(:,-1),wf(:,4),G1tensor(:,30))
  call check_last_GHG_G(l_switch,G1(:,:,:,56),Q(:,8),wf(:,0),wf(:,7),Q(:,6),G2tensor(:,2), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,2),G0(:,:,:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,31))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,2),wf(:,-3),G0(:,:,:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,32))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,2),G0(:,:,:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,33))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,4),G0(:,:,:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,34))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-3),G0(:,:,:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,35))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,4),G0(:,:,:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,36))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,7),G0(:,:,:,35))
  call check_last_GH_G(l_switch,G0(:,:,:,35),Q(:,14),wf(:,0),G2tensor(:,3), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,-3),G0(:,:,:,36))
  call check_last_GH_G(l_switch,G0(:,:,:,36),Q(:,14),wf(:,0),G2tensor(:,4), Q(:,15))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,7),G0(:,:,:,37))
  call check_last_GH_G(l_switch,G0(:,:,:,37),Q(:,14),wf(:,0),G2tensor(:,5), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,6),G0(:,:,:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,37))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,-2),G0(:,:,:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,38))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,6),G0(:,:,:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,13),wf(:,-1),Q(:,2),G1tensor(:,39))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,5),G0(:,:,:,41))
  call check_last_GH_G(l_switch,G0(:,:,:,41),Q(:,14),wf(:,0),G2tensor(:,6), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,5),wf(:,-2),G0(:,:,:,42))
  call check_last_GH_G(l_switch,G0(:,:,:,42),Q(:,14),wf(:,0),G2tensor(:,7), Q(:,15))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,5),G0(:,:,:,43))
  call check_last_GH_G(l_switch,G0(:,:,:,43),Q(:,14),wf(:,0),G2tensor(:,8), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,6),G0(:,:,:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,40))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,-1),G0(:,:,:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,41))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,6),G0(:,:,:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,42))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,3),G0(:,:,:,47))
  call check_last_GH_G(l_switch,G0(:,:,:,47),Q(:,14),wf(:,0),G2tensor(:,9), Q(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,-1),G0(:,:,:,48))
  call check_last_GH_G(l_switch,G0(:,:,:,48),Q(:,14),wf(:,0),G2tensor(:,10), Q(:,15))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,3),G0(:,:,:,49))
  call check_last_GH_G(l_switch,G0(:,:,:,49),Q(:,14),wf(:,0),G2tensor(:,11), Q(:,15))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,9),G1(:,:,:,57))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,57),wf(:,-2),wf(:,-1),G1tensor(:,43))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,57),wf(:,-1),wf(:,-2),G1tensor(:,44))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,57),wf(:,-2),wf(:,-1),G1tensor(:,45))
  call check_last_UV_W(l_switch,G1(:,:,:,57),Q(:,9),wf(:,7),Q(:,6),G2tensor(:,12))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,0),wf(:,5),Q(:,10),G1(:,:,:,58), Q(:,11))
  call check_last_UV_W(l_switch,G1(:,:,:,58),Q(:,11),wf(:,-2),Q(:,4),G2tensor(:,13))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,0),wf(:,3),Q(:,12),G1(:,:,:,59), Q(:,13))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,13),wf(:,-1),Q(:,2),G2tensor(:,14))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,10),G1(:,:,:,60))
  call check_last_GHG_G(l_switch,G1(:,:,:,60),Q(:,10),wf(:,0),wf(:,-2),Q(:,4),G2tensor(:,15), Q(:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,60),Q(:,10),wf(:,4),Q(:,5),G2tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,12),G1(:,:,:,61))
  call check_last_GHG_G(l_switch,G1(:,:,:,61),Q(:,12),wf(:,0),wf(:,-1),Q(:,2),G2tensor(:,17), Q(:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,12),wf(:,2),Q(:,3),G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,12),ZERO,G1(:,:,:,62))
  call loop_QV_A(G1(:,:,:,62),wf(:,2),G1(:,:,:,63))
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,15),ZERO,G2tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,12),MB,G1(:,:,:,64))
  call loop_QV_A(G1(:,:,:,64),wf(:,2),G1(:,:,:,65))
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,15),MB,G2tensor(:,20))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,12),G1(:,:,:,66))
  call check_last_CV_D(l_switch,G1(:,:,:,66),Q(:,12),wf(:,2),Q(:,3),G2tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,10),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,4),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,15),ZERO,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,10),MB,G1(:,:,:,69))
  call loop_QV_A(G1(:,:,:,69),wf(:,4),G1(:,:,:,70))
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,15),MB,G2tensor(:,23))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,10),G1(:,:,:,71))
  call check_last_CV_D(l_switch,G1(:,:,:,71),Q(:,10),wf(:,4),Q(:,5),G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,9),ZERO,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,7),G1(:,:,:,73))
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,15),ZERO,G2tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,9),MB,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,7),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,15),MB,G2tensor(:,26))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,9),G1(:,:,:,76))
  call check_last_CV_D(l_switch,G1(:,:,:,76),Q(:,9),wf(:,7),Q(:,6),G2tensor(:,27))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(3)*(-M(1)+M(2)))
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(3)*(M(1)-M(2)))
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(4)*(M(1)-M(2)))
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(3)*(M(1)-M(2)))
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(3)*(-M(1)+M(2)))
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(4)*(-M(1)+M(2)))
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(3)*(-M(1)+M(2)))
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(3)*(M(1)-M(2)))
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(4)*(M(1)-M(2)))
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(3)*(M(1)-M(2)))
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(3)*(M(1)-M(2)))
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(3)*(M(1)-M(2)))
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(10)*M(1)) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(10)*M(2)) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(10)*M(1)) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(9)*M(1)) * den(1)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(10)*M(2)) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(9)*M(2)) * den(1)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(3)*(-M(1)+M(2))) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(10)*M(2)) * den(2)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(10)*M(1)) * den(2)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(10)*M(2)) * den(2)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(9)*M(2)) * den(2)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(10)*M(1)) * den(2)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(9)*M(1)) * den(2)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(2)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(3)*(-M(1)+M(2))) * den(2)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(2)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(4)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(4)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(4)*(M(1)-M(2))) * den(4)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(10)*M(1)) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(10)*M(2)) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(10)*M(1)) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(9)*M(1)) * den(3)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(10)*M(2)) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(9)*M(2)) * den(3)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(3)*(-M(1)+M(2))) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(5)*(-M(1)+M(2))) * den(5)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(5)*(-M(1)+M(2))) * den(5)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(4)*(-M(1)+M(2))) * den(5)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(6)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(6)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(4)*(M(1)-M(2))) * den(6)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(6)*M(2)))
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(6)*M(1)))
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(3)*(-M(1)+M(2)))
  T5sum(1:126,1) = T5sum(1:126,1) + Gcoeff * G5tensor(:,1)
  Gcoeff = (-(c(6)*M(1)))
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,7)
  Gcoeff = (-(c(6)*M(2)))
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(3)*(M(1)-M(2)))
  T5sum(1:126,2) = T5sum(1:126,2) + Gcoeff * G5tensor(:,2)
  Gcoeff = (-(c(6)*M(2)))
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(6)*M(1)))
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(3)*(-M(1)+M(2)))
  T5sum(1:126,3) = T5sum(1:126,3) + Gcoeff * G5tensor(:,3)
  Gcoeff = (c(1)*(-M(1)+M(2)))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(1)*(M(1)-M(2)))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(2)*(M(1)-M(2)))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(1)*(M(1)-M(2)))
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(1)*(-M(1)+M(2)))
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(2)*(-M(1)+M(2)))
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(1)*(-M(1)+M(2)))
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(1)*(M(1)-M(2)))
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(2)*(M(1)-M(2)))
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(1)*(-M(1)+M(2)))
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(1)*(M(1)-M(2)))
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(2)*(M(1)-M(2)))
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(1)*(M(1)-M(2)))
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(1)*(-M(1)+M(2)))
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(2)*(-M(1)+M(2)))
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(1)*(-M(1)+M(2)))
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(1)*(M(1)-M(2)))
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(2)*(M(1)-M(2)))
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(1)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(1)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(2)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(2)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(2)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(4)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(4)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,4)
  Gcoeff = (0) * den(4)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(3)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,7)
  Gcoeff = (0) * den(5)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(2)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(2)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(2)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(2)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(2)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(2)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(3)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(3)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(6)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(6)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,10)
  Gcoeff = (0) * den(6)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(3)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(3)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(4)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(4)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(6)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(8)*(-M(1)+M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(8)*(-M(1)+M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(7)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(4)*(-M(1)+M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(8)*(M(1)-M(2))) * den(8)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(8)*(M(1)-M(2))) * den(8)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(8)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(4)*(M(1)-M(2))) * den(8)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(8)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(8)*(-M(1)+M(2))) * den(9)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(8)*(-M(1)+M(2))) * den(9)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(9)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(4)*(-M(1)+M(2))) * den(9)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(9)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,12)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_heftpphj_hggg_1_/**/REALKIND
