
module ol_vamp_7_heftpphhjj_hhgggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_7(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_hhgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_hhgggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_hhgggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_hhgggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(9)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,156) :: G0
  complex(REALKIND), dimension(4,5,4,221) :: G1
  complex(REALKIND), dimension(5,165) :: G1tensor
  complex(REALKIND), dimension(15,255) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,453),Q(:,43),G1(:,:,:,1))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-4),wf(:,-2),G1tensor(:,1))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,-4),G1tensor(:,2))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-4),wf(:,-2),G1tensor(:,3))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,1))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,454),Q(:,43),G1(:,:,:,2))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-4),wf(:,-2),G1tensor(:,4))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-2),wf(:,-4),G1tensor(:,5))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,-4),wf(:,-2),G1tensor(:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,2))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,459),G0(:,:,:,2))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,7))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,459),wf(:,-2),G0(:,:,:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,3),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,8))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,459),G0(:,:,:,4))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,9))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,459),Q(:,43),G1(:,:,:,3))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-4),wf(:,-2),G1tensor(:,10))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-2),wf(:,-4),G1tensor(:,11))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,3),wf(:,-4),wf(:,-2),G1tensor(:,12))
  call check_last_UV_W(l_switch,G1(:,:,:,3),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,52),ZERO,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,12),G1(:,:,:,5))
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,63),ZERO,G2tensor(:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,42),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,63),ZERO,G2tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,52),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,12),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),ZERO,G2tensor(:,6))
  call loop_QV_A(G1(:,:,:,7),wf(:,42),G1(:,:,:,9))
  call check_last_Q_A(l_switch,G1(:,:,:,9),Q(:,63),ZERO,G2tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,52),ZERO,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,12),G1(:,:,:,11))
  call check_last_Q_A(l_switch,G1(:,:,:,11),Q(:,63),ZERO,G2tensor(:,8))
  call loop_QV_A(G1(:,:,:,10),wf(:,42),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),ZERO,G2tensor(:,9))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,13),Q(:,52),G1(:,:,:,13))
  call check_last_CV_D(l_switch,G1(:,:,:,13),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,10))
  call check_last_CV_D(l_switch,G1(:,:,:,13),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,11))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,52),G1(:,:,:,14))
  call check_last_CV_D(l_switch,G1(:,:,:,14),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,12))
  call check_last_CV_D(l_switch,G1(:,:,:,14),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,13))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,15),Q(:,52),G1(:,:,:,15))
  call check_last_CV_D(l_switch,G1(:,:,:,15),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,14))
  call check_last_CV_D(l_switch,G1(:,:,:,15),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,15))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,450),Q(:,51),G1(:,:,:,16))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,16),wf(:,-3),wf(:,-2),G1tensor(:,13))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,16),wf(:,-2),wf(:,-3),G1tensor(:,14))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,16),wf(:,-3),wf(:,-2),G1tensor(:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,16),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,451),Q(:,51),G1(:,:,:,17))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,17),wf(:,-3),wf(:,-2),G1tensor(:,16))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,17),wf(:,-2),wf(:,-3),G1tensor(:,17))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,17),wf(:,-3),wf(:,-2),G1tensor(:,18))
  call check_last_UV_W(l_switch,G1(:,:,:,17),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,17))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,452),Q(:,51),G1(:,:,:,18))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,-3),wf(:,-2),G1tensor(:,19))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,-2),wf(:,-3),G1tensor(:,20))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,18),wf(:,-3),wf(:,-2),G1tensor(:,21))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,17),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,44),ZERO,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,16),G1(:,:,:,20))
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,63),ZERO,G2tensor(:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,44),G1(:,:,:,21))
  call check_last_Q_A(l_switch,G1(:,:,:,21),Q(:,63),ZERO,G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,44),ZERO,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,16),G1(:,:,:,23))
  call check_last_Q_A(l_switch,G1(:,:,:,23),Q(:,63),ZERO,G2tensor(:,21))
  call loop_QV_A(G1(:,:,:,22),wf(:,44),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),ZERO,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,44),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,16),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,63),ZERO,G2tensor(:,23))
  call loop_QV_A(G1(:,:,:,25),wf(:,44),G1(:,:,:,27))
  call check_last_Q_A(l_switch,G1(:,:,:,27),Q(:,63),ZERO,G2tensor(:,24))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,17),Q(:,44),G1(:,:,:,28))
  call check_last_CV_D(l_switch,G1(:,:,:,28),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,25))
  call check_last_CV_D(l_switch,G1(:,:,:,28),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,26))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,18),Q(:,44),G1(:,:,:,29))
  call check_last_CV_D(l_switch,G1(:,:,:,29),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,27))
  call check_last_CV_D(l_switch,G1(:,:,:,29),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,28))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,44),G1(:,:,:,30))
  call check_last_CV_D(l_switch,G1(:,:,:,30),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,29))
  call check_last_CV_D(l_switch,G1(:,:,:,30),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,35),ZERO,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,21),G1(:,:,:,32))
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,63),ZERO,G2tensor(:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,22),G1(:,:,:,33))
  call check_last_Q_A(l_switch,G1(:,:,:,33),Q(:,63),ZERO,G2tensor(:,32))
  call loop_QV_A(G1(:,:,:,31),wf(:,23),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,63),ZERO,G2tensor(:,33))
  call loop_QV_A(G1(:,:,:,31),wf(:,47),G1(:,:,:,35))
  call check_last_Q_A(l_switch,G1(:,:,:,35),Q(:,63),ZERO,G2tensor(:,34))
  call loop_QV_A(G1(:,:,:,31),wf(:,50),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,63),ZERO,G2tensor(:,35))
  call loop_QV_A(G1(:,:,:,31),wf(:,52),G1(:,:,:,37))
  call check_last_Q_A(l_switch,G1(:,:,:,37),Q(:,63),ZERO,G2tensor(:,36))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,20),Q(:,35),G1(:,:,:,38))
  call check_last_CV_D(l_switch,G1(:,:,:,38),Q(:,35),wf(:,21),Q(:,28),G2tensor(:,37))
  call check_last_CV_D(l_switch,G1(:,:,:,38),Q(:,35),wf(:,22),Q(:,28),G2tensor(:,38))
  call check_last_CV_D(l_switch,G1(:,:,:,38),Q(:,35),wf(:,23),Q(:,28),G2tensor(:,39))
  call check_last_CV_D(l_switch,G1(:,:,:,38),Q(:,35),wf(:,47),Q(:,28),G2tensor(:,40))
  call check_last_CV_D(l_switch,G1(:,:,:,38),Q(:,35),wf(:,50),Q(:,28),G2tensor(:,41))
  call check_last_CV_D(l_switch,G1(:,:,:,38),Q(:,35),wf(:,52),Q(:,28),G2tensor(:,42))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,48),Q(:,44),G1(:,:,:,39), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,39),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,43))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,48),Q(:,44),G1(:,:,:,40))
  call check_last_GHHG_G(l_switch,G1(:,:,:,40),Q(:,44),wf(:,-1),wf(:,0),wf(:,-4),Q(:,16),G2tensor(:,44), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,40),Q(:,44),wf(:,4),wf(:,-4),Q(:,16),G2tensor(:,45), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,40),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,46))
  call check_last_UV_W(l_switch,G1(:,:,:,40),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,47))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,51),ZERO,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,24),G1(:,:,:,42))
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,63),ZERO,G2tensor(:,48))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,51),G1(:,:,:,43))
  call check_last_CV_D(l_switch,G1(:,:,:,43),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,49))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,55),Q(:,52),G1(:,:,:,44), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,50))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,58),Q(:,56),G1(:,:,:,45), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,51))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,53),Q(:,44),G1(:,:,:,46), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,46),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,52))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,56),Q(:,52),G1(:,:,:,47), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,53))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,54),Q(:,44),G1(:,:,:,48), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,48),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,54))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,59),Q(:,56),G1(:,:,:,49), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,49),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,55))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,57),Q(:,52),G1(:,:,:,50), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,50),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,56))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-1),wf(:,0),wf(:,60),Q(:,56),G1(:,:,:,51), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,51),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,57))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,53),Q(:,44),G1(:,:,:,52))
  call check_last_GHHG_G(l_switch,G1(:,:,:,52),Q(:,44),wf(:,-1),wf(:,0),wf(:,-4),Q(:,16),G2tensor(:,58), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,52),Q(:,44),wf(:,4),wf(:,-4),Q(:,16),G2tensor(:,59), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,52),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,60))
  call check_last_UV_W(l_switch,G1(:,:,:,52),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,61))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,44),G1(:,:,:,53))
  call check_last_GHHG_G(l_switch,G1(:,:,:,53),Q(:,44),wf(:,-1),wf(:,0),wf(:,-4),Q(:,16),G2tensor(:,62), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,53),Q(:,44),wf(:,4),wf(:,-4),Q(:,16),G2tensor(:,63), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,53),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,64))
  call check_last_UV_W(l_switch,G1(:,:,:,53),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,65))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,55),Q(:,52),G1(:,:,:,54))
  call check_last_GHHG_G(l_switch,G1(:,:,:,54),Q(:,52),wf(:,-1),wf(:,0),wf(:,-3),Q(:,8),G2tensor(:,66), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,54),Q(:,52),wf(:,4),wf(:,-3),Q(:,8),G2tensor(:,67), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,54),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,68))
  call check_last_UV_W(l_switch,G1(:,:,:,54),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,27),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,43),ZERO,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,26),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,63),ZERO,G2tensor(:,70))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,27),Q(:,43),G1(:,:,:,57))
  call check_last_CV_D(l_switch,G1(:,:,:,57),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,71))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,56),Q(:,52),G1(:,:,:,58))
  call check_last_GHHG_G(l_switch,G1(:,:,:,58),Q(:,52),wf(:,-1),wf(:,0),wf(:,-3),Q(:,8),G2tensor(:,72), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,58),Q(:,52),wf(:,4),wf(:,-3),Q(:,8),G2tensor(:,73), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,58),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,74))
  call check_last_UV_W(l_switch,G1(:,:,:,58),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,75))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,57),Q(:,52),G1(:,:,:,59))
  call check_last_GHHG_G(l_switch,G1(:,:,:,59),Q(:,52),wf(:,-1),wf(:,0),wf(:,-3),Q(:,8),G2tensor(:,76), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,59),Q(:,52),wf(:,4),wf(:,-3),Q(:,8),G2tensor(:,77), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,78))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,28),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,36),ZERO,G1(:,:,:,60))
  call loop_QV_A(G1(:,:,:,60),wf(:,29),G1(:,:,:,61))
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,63),ZERO,G2tensor(:,80))
  call loop_QV_A(G1(:,:,:,60),wf(:,38),G1(:,:,:,62))
  call check_last_Q_A(l_switch,G1(:,:,:,62),Q(:,63),ZERO,G2tensor(:,81))
  call loop_QV_A(G1(:,:,:,60),wf(:,455),G1(:,:,:,63))
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,63),ZERO,G2tensor(:,82))
  call loop_QV_A(G1(:,:,:,60),wf(:,457),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,63),ZERO,G2tensor(:,83))
  call loop_QV_A(G1(:,:,:,60),wf(:,460),G1(:,:,:,65))
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,63),ZERO,G2tensor(:,84))
  call loop_QV_A(G1(:,:,:,60),wf(:,487),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),ZERO,G2tensor(:,85))
  call loop_QV_A(G1(:,:,:,60),wf(:,505),G1(:,:,:,67))
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,63),ZERO,G2tensor(:,86))
  call loop_QV_A(G1(:,:,:,60),wf(:,508),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,63),ZERO,G2tensor(:,87))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,28),Q(:,36),G1(:,:,:,69))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,29),Q(:,27),G2tensor(:,88))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,38),Q(:,27),G2tensor(:,89))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,455),Q(:,27),G2tensor(:,90))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,457),Q(:,27),G2tensor(:,91))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,460),Q(:,27),G2tensor(:,92))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,487),Q(:,27),G2tensor(:,93))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,505),Q(:,27),G2tensor(:,94))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,36),wf(:,508),Q(:,27),G2tensor(:,95))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,58),Q(:,56),G1(:,:,:,70))
  call check_last_GHHG_G(l_switch,G1(:,:,:,70),Q(:,56),wf(:,-1),wf(:,0),wf(:,-2),Q(:,4),G2tensor(:,96), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,70),Q(:,56),wf(:,4),wf(:,-2),Q(:,4),G2tensor(:,97), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,70),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,98))
  call check_last_UV_W(l_switch,G1(:,:,:,70),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,99))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,39),ZERO,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,30),G1(:,:,:,72))
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,63),ZERO,G2tensor(:,100))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,31),Q(:,39),G1(:,:,:,73))
  call check_last_CV_D(l_switch,G1(:,:,:,73),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,101))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,59),Q(:,56),G1(:,:,:,74))
  call check_last_GHHG_G(l_switch,G1(:,:,:,74),Q(:,56),wf(:,-1),wf(:,0),wf(:,-2),Q(:,4),G2tensor(:,102), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,74),Q(:,56),wf(:,4),wf(:,-2),Q(:,4),G2tensor(:,103), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,74),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,104))
  call check_last_UV_W(l_switch,G1(:,:,:,74),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,105))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,60),Q(:,56),G1(:,:,:,75))
  call check_last_GHHG_G(l_switch,G1(:,:,:,75),Q(:,56),wf(:,-1),wf(:,0),wf(:,-2),Q(:,4),G2tensor(:,106), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,75),Q(:,56),wf(:,4),wf(:,-2),Q(:,4),G2tensor(:,107), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,75),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,108))
  call check_last_UV_W(l_switch,G1(:,:,:,75),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,109))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,40),ZERO,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,33),G1(:,:,:,77))
  call check_last_Q_A(l_switch,G1(:,:,:,77),Q(:,63),ZERO,G2tensor(:,110))
  call loop_QV_A(G1(:,:,:,76),wf(:,41),G1(:,:,:,78))
  call check_last_Q_A(l_switch,G1(:,:,:,78),Q(:,63),ZERO,G2tensor(:,111))
  call loop_QV_A(G1(:,:,:,76),wf(:,49),G1(:,:,:,79))
  call check_last_Q_A(l_switch,G1(:,:,:,79),Q(:,63),ZERO,G2tensor(:,112))
  call loop_QV_A(G1(:,:,:,76),wf(:,458),G1(:,:,:,80))
  call check_last_Q_A(l_switch,G1(:,:,:,80),Q(:,63),ZERO,G2tensor(:,113))
  call loop_QV_A(G1(:,:,:,76),wf(:,463),G1(:,:,:,81))
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,63),ZERO,G2tensor(:,114))
  call loop_QV_A(G1(:,:,:,76),wf(:,62),G1(:,:,:,82))
  call check_last_Q_A(l_switch,G1(:,:,:,82),Q(:,63),ZERO,G2tensor(:,115))
  call loop_QV_A(G1(:,:,:,76),wf(:,502),G1(:,:,:,83))
  call check_last_Q_A(l_switch,G1(:,:,:,83),Q(:,63),ZERO,G2tensor(:,116))
  call loop_QV_A(G1(:,:,:,76),wf(:,507),G1(:,:,:,84))
  call check_last_Q_A(l_switch,G1(:,:,:,84),Q(:,63),ZERO,G2tensor(:,117))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,32),Q(:,40),G1(:,:,:,85))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,33),Q(:,23),G2tensor(:,118))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,41),Q(:,23),G2tensor(:,119))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,49),Q(:,23),G2tensor(:,120))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,458),Q(:,23),G2tensor(:,121))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,463),Q(:,23),G2tensor(:,122))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,62),Q(:,23),G2tensor(:,123))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,502),Q(:,23),G2tensor(:,124))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,40),wf(:,507),Q(:,23),G2tensor(:,125))
  call loop_QV_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,48),ZERO,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,35),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,63),ZERO,G2tensor(:,126))
  call loop_QV_A(G1(:,:,:,86),wf(:,43),G1(:,:,:,88))
  call check_last_Q_A(l_switch,G1(:,:,:,88),Q(:,63),ZERO,G2tensor(:,127))
  call loop_QV_A(G1(:,:,:,86),wf(:,46),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,63),ZERO,G2tensor(:,128))
  call loop_QV_A(G1(:,:,:,86),wf(:,461),G1(:,:,:,90))
  call check_last_Q_A(l_switch,G1(:,:,:,90),Q(:,63),ZERO,G2tensor(:,129))
  call loop_QV_A(G1(:,:,:,86),wf(:,464),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,63),ZERO,G2tensor(:,130))
  call loop_QV_A(G1(:,:,:,86),wf(:,61),G1(:,:,:,92))
  call check_last_Q_A(l_switch,G1(:,:,:,92),Q(:,63),ZERO,G2tensor(:,131))
  call loop_QV_A(G1(:,:,:,86),wf(:,501),G1(:,:,:,93))
  call check_last_Q_A(l_switch,G1(:,:,:,93),Q(:,63),ZERO,G2tensor(:,132))
  call loop_QV_A(G1(:,:,:,86),wf(:,504),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),ZERO,G2tensor(:,133))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,48),G1(:,:,:,95))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,35),Q(:,15),G2tensor(:,134))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,43),Q(:,15),G2tensor(:,135))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,46),Q(:,15),G2tensor(:,136))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,461),Q(:,15),G2tensor(:,137))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,464),Q(:,15),G2tensor(:,138))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,61),Q(:,15),G2tensor(:,139))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,501),Q(:,15),G2tensor(:,140))
  call check_last_CV_D(l_switch,G1(:,:,:,95),Q(:,48),wf(:,504),Q(:,15),G2tensor(:,141))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,24),wf(:,45),G0(:,:,:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,22))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,24),G0(:,:,:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,23))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,24),wf(:,45),G0(:,:,:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,24))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,48),Q(:,44),G1(:,:,:,96), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,96),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,142))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,61),G0(:,:,:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,25))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,61),wf(:,-5),G0(:,:,:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,26))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,61),G0(:,:,:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,27))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,45),Q(:,35),G1(:,:,:,97))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,-4),wf(:,24),G1tensor(:,28))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,24),wf(:,-4),G1tensor(:,29))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,97),wf(:,-4),wf(:,24),G1tensor(:,30))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,-3),wf(:,26),G1tensor(:,31))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,26),wf(:,-3),G1tensor(:,32))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,97),wf(:,-3),wf(:,26),G1tensor(:,33))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,-2),wf(:,30),G1tensor(:,34))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,30),wf(:,-2),G1tensor(:,35))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,97),wf(:,-2),wf(:,30),G1tensor(:,36))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,35),wf(:,21),Q(:,28),G2tensor(:,143))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,35),wf(:,22),Q(:,28),G2tensor(:,144))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,35),wf(:,23),Q(:,28),G2tensor(:,145))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,35),wf(:,47),Q(:,28),G2tensor(:,146))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,35),wf(:,50),Q(:,28),G2tensor(:,147))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,35),wf(:,52),Q(:,28),G2tensor(:,148))
  call loop_QV_A(G0(:,:,:,1),wf(:,36),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,51),ZERO,G1(:,:,:,98))
  call loop_QV_A(G1(:,:,:,98),wf(:,24),G1(:,:,:,99))
  call check_last_Q_A(l_switch,G1(:,:,:,99),Q(:,63),ZERO,G2tensor(:,149))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,36),Q(:,51),G1(:,:,:,100))
  call check_last_CV_D(l_switch,G1(:,:,:,100),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,150))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,26),wf(:,45),G0(:,:,:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,37))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,26),G0(:,:,:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,38))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,26),wf(:,45),G0(:,:,:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,39))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,55),Q(:,52),G1(:,:,:,101), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,101),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,151))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,62),G0(:,:,:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,40))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,62),wf(:,-5),G0(:,:,:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,41))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,62),G0(:,:,:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,42))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,30),wf(:,45),G0(:,:,:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,43))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,30),G0(:,:,:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,44))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,30),wf(:,45),G0(:,:,:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,45))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,58),Q(:,56),G1(:,:,:,102), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,102),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,152))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,487),G0(:,:,:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,46))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,487),wf(:,-5),G0(:,:,:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,47))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,487),G0(:,:,:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,48))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,28),wf(:,42),G0(:,:,:,37))
  call check_last_UV_W(l_switch,G0(:,:,:,37),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,49))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,42),wf(:,28),G0(:,:,:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,50))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,28),wf(:,42),G0(:,:,:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,51))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,28),wf(:,44),G0(:,:,:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,52))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,28),G0(:,:,:,41))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,53))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,28),wf(:,44),G0(:,:,:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,54))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,53),Q(:,44),G1(:,:,:,103), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,153))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,56),Q(:,52),G1(:,:,:,104), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,104),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,154))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,32),wf(:,39),G0(:,:,:,43))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,55))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,39),wf(:,32),G0(:,:,:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,56))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,32),wf(:,39),G0(:,:,:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,57))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,32),wf(:,44),G0(:,:,:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,58))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,32),G0(:,:,:,47))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,59))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,32),wf(:,44),G0(:,:,:,48))
  call check_last_UV_W(l_switch,G0(:,:,:,48),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,60))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,54),Q(:,44),G1(:,:,:,105), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,105),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,155))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,59),Q(:,56),G1(:,:,:,106), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,106),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,156))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,34),wf(:,39),G0(:,:,:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,49),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,61))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,39),wf(:,34),G0(:,:,:,50))
  call check_last_UV_W(l_switch,G0(:,:,:,50),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,62))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,34),wf(:,39),G0(:,:,:,51))
  call check_last_UV_W(l_switch,G0(:,:,:,51),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,34),wf(:,42),G0(:,:,:,52))
  call check_last_UV_W(l_switch,G0(:,:,:,52),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,64))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,42),wf(:,34),G0(:,:,:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,53),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,65))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,34),wf(:,42),G0(:,:,:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,54),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,66))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,57),Q(:,52),G1(:,:,:,107), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,107),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,157))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,60),Q(:,56),G1(:,:,:,108), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,108),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,158))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,501),G0(:,:,:,55))
  call check_last_UV_W(l_switch,G0(:,:,:,55),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,67))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,501),wf(:,-5),G0(:,:,:,56))
  call check_last_UV_W(l_switch,G0(:,:,:,56),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,68))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,501),G0(:,:,:,57))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,69))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,502),G0(:,:,:,58))
  call check_last_UV_W(l_switch,G0(:,:,:,58),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,70))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,502),wf(:,-5),G0(:,:,:,59))
  call check_last_UV_W(l_switch,G0(:,:,:,59),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,71))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,502),G0(:,:,:,60))
  call check_last_UV_W(l_switch,G0(:,:,:,60),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,72))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,504),G0(:,:,:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,73))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,504),wf(:,-5),G0(:,:,:,62))
  call check_last_UV_W(l_switch,G0(:,:,:,62),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,74))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,504),G0(:,:,:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,75))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,505),G0(:,:,:,64))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,76))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,505),wf(:,-5),G0(:,:,:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,77))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,505),G0(:,:,:,66))
  call check_last_UV_W(l_switch,G0(:,:,:,66),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,78))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,507),G0(:,:,:,67))
  call check_last_UV_W(l_switch,G0(:,:,:,67),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,79))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,507),wf(:,-5),G0(:,:,:,68))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,80))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,507),G0(:,:,:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,81))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,508),G0(:,:,:,70))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,82))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,508),wf(:,-5),G0(:,:,:,71))
  call check_last_UV_W(l_switch,G0(:,:,:,71),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,83))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,508),G0(:,:,:,72))
  call check_last_UV_W(l_switch,G0(:,:,:,72),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,84))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,63),G0(:,:,:,73))
  call check_last_UV_W(l_switch,G0(:,:,:,73),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,85))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,63),wf(:,-4),G0(:,:,:,74))
  call check_last_UV_W(l_switch,G0(:,:,:,74),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,86))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,63),G0(:,:,:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,75),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,87))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,482),G0(:,:,:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,88))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,482),wf(:,-4),G0(:,:,:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,89))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,482),G0(:,:,:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,78),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,90))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,503),G0(:,:,:,79))
  call check_last_UV_W(l_switch,G0(:,:,:,79),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,91))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,503),wf(:,-4),G0(:,:,:,80))
  call check_last_UV_W(l_switch,G0(:,:,:,80),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,92))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,503),G0(:,:,:,81))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,93))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,506),G0(:,:,:,82))
  call check_last_UV_W(l_switch,G0(:,:,:,82),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,94))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,506),wf(:,-4),G0(:,:,:,83))
  call check_last_UV_W(l_switch,G0(:,:,:,83),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,95))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,506),G0(:,:,:,84))
  call check_last_UV_W(l_switch,G0(:,:,:,84),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,96))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,510),G0(:,:,:,85))
  call check_last_UV_W(l_switch,G0(:,:,:,85),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,97))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,510),wf(:,-4),G0(:,:,:,86))
  call check_last_UV_W(l_switch,G0(:,:,:,86),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,98))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,510),G0(:,:,:,87))
  call check_last_UV_W(l_switch,G0(:,:,:,87),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,99))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,511),G0(:,:,:,88))
  call check_last_UV_W(l_switch,G0(:,:,:,88),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,100))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,511),wf(:,-4),G0(:,:,:,89))
  call check_last_UV_W(l_switch,G0(:,:,:,89),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,101))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,511),G0(:,:,:,90))
  call check_last_UV_W(l_switch,G0(:,:,:,90),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,102))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,91))
  call loop_Q_A(G0(:,:,:,91),Q(:,43),ZERO,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,26),G1(:,:,:,110))
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,63),ZERO,G2tensor(:,159))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,43),G1(:,:,:,111))
  call check_last_CV_D(l_switch,G1(:,:,:,111),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,160))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,63),G0(:,:,:,92))
  call check_last_UV_W(l_switch,G0(:,:,:,92),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,103))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,63),wf(:,-3),G0(:,:,:,93))
  call check_last_UV_W(l_switch,G0(:,:,:,93),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,104))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,63),G0(:,:,:,94))
  call check_last_UV_W(l_switch,G0(:,:,:,94),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,105))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,477),G0(:,:,:,95))
  call check_last_UV_W(l_switch,G0(:,:,:,95),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,106))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,477),wf(:,-3),G0(:,:,:,96))
  call check_last_UV_W(l_switch,G0(:,:,:,96),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,107))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,477),G0(:,:,:,97))
  call check_last_UV_W(l_switch,G0(:,:,:,97),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,108))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,503),G0(:,:,:,98))
  call check_last_UV_W(l_switch,G0(:,:,:,98),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,109))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,503),wf(:,-3),G0(:,:,:,99))
  call check_last_UV_W(l_switch,G0(:,:,:,99),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,110))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,503),G0(:,:,:,100))
  call check_last_UV_W(l_switch,G0(:,:,:,100),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,111))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,509),G0(:,:,:,101))
  call check_last_UV_W(l_switch,G0(:,:,:,101),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,112))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,509),wf(:,-3),G0(:,:,:,102))
  call check_last_UV_W(l_switch,G0(:,:,:,102),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,113))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,509),G0(:,:,:,103))
  call check_last_UV_W(l_switch,G0(:,:,:,103),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,114))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,510),G0(:,:,:,104))
  call check_last_UV_W(l_switch,G0(:,:,:,104),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,115))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,510),wf(:,-3),G0(:,:,:,105))
  call check_last_UV_W(l_switch,G0(:,:,:,105),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,116))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,510),G0(:,:,:,106))
  call check_last_UV_W(l_switch,G0(:,:,:,106),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,117))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,512),G0(:,:,:,107))
  call check_last_UV_W(l_switch,G0(:,:,:,107),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,118))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,512),wf(:,-3),G0(:,:,:,108))
  call check_last_UV_W(l_switch,G0(:,:,:,108),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,119))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,512),G0(:,:,:,109))
  call check_last_UV_W(l_switch,G0(:,:,:,109),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,120))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,63),Q(:,39),G1(:,:,:,112))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,112),wf(:,-4),wf(:,-3),G1tensor(:,121))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,112),wf(:,-3),wf(:,-4),G1tensor(:,122))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,112),wf(:,-4),wf(:,-3),G1tensor(:,123))
  call check_last_UV_W(l_switch,G1(:,:,:,112),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,161))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,503),Q(:,39),G1(:,:,:,113))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,113),wf(:,-4),wf(:,-3),G1tensor(:,124))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,113),wf(:,-3),wf(:,-4),G1tensor(:,125))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,113),wf(:,-4),wf(:,-3),G1tensor(:,126))
  call check_last_UV_W(l_switch,G1(:,:,:,113),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,162))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,510),Q(:,39),G1(:,:,:,114))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,114),wf(:,-4),wf(:,-3),G1tensor(:,127))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,114),wf(:,-3),wf(:,-4),G1tensor(:,128))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,114),wf(:,-4),wf(:,-3),G1tensor(:,129))
  call check_last_UV_W(l_switch,G1(:,:,:,114),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,163))
  call loop_QV_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,110))
  call loop_Q_A(G0(:,:,:,110),Q(:,39),ZERO,G1(:,:,:,115))
  call loop_QV_A(G1(:,:,:,115),wf(:,30),G1(:,:,:,116))
  call check_last_Q_A(l_switch,G1(:,:,:,116),Q(:,63),ZERO,G2tensor(:,164))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,40),Q(:,39),G1(:,:,:,117))
  call check_last_CV_D(l_switch,G1(:,:,:,117),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,165))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,482),G0(:,:,:,111))
  call check_last_UV_W(l_switch,G0(:,:,:,111),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,130))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,482),wf(:,-2),G0(:,:,:,112))
  call check_last_UV_W(l_switch,G0(:,:,:,112),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,131))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,482),G0(:,:,:,113))
  call check_last_UV_W(l_switch,G0(:,:,:,113),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,132))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,477),G0(:,:,:,114))
  call check_last_UV_W(l_switch,G0(:,:,:,114),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,133))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,477),wf(:,-2),G0(:,:,:,115))
  call check_last_UV_W(l_switch,G0(:,:,:,115),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,134))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,477),G0(:,:,:,116))
  call check_last_UV_W(l_switch,G0(:,:,:,116),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,135))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,506),G0(:,:,:,117))
  call check_last_UV_W(l_switch,G0(:,:,:,117),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,136))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,506),wf(:,-2),G0(:,:,:,118))
  call check_last_UV_W(l_switch,G0(:,:,:,118),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,137))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,506),G0(:,:,:,119))
  call check_last_UV_W(l_switch,G0(:,:,:,119),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,138))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,509),G0(:,:,:,120))
  call check_last_UV_W(l_switch,G0(:,:,:,120),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,139))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,509),wf(:,-2),G0(:,:,:,121))
  call check_last_UV_W(l_switch,G0(:,:,:,121),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,140))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,509),G0(:,:,:,122))
  call check_last_UV_W(l_switch,G0(:,:,:,122),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,141))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,511),G0(:,:,:,123))
  call check_last_UV_W(l_switch,G0(:,:,:,123),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,142))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,511),wf(:,-2),G0(:,:,:,124))
  call check_last_UV_W(l_switch,G0(:,:,:,124),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,143))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,511),G0(:,:,:,125))
  call check_last_UV_W(l_switch,G0(:,:,:,125),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,144))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,512),G0(:,:,:,126))
  call check_last_UV_W(l_switch,G0(:,:,:,126),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,145))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,512),wf(:,-2),G0(:,:,:,127))
  call check_last_UV_W(l_switch,G0(:,:,:,127),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,146))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,512),G0(:,:,:,128))
  call check_last_UV_W(l_switch,G0(:,:,:,128),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,147))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,482),Q(:,43),G1(:,:,:,118))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,118),wf(:,-4),wf(:,-2),G1tensor(:,148))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,118),wf(:,-2),wf(:,-4),G1tensor(:,149))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,118),wf(:,-4),wf(:,-2),G1tensor(:,150))
  call check_last_UV_W(l_switch,G1(:,:,:,118),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,166))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,506),Q(:,43),G1(:,:,:,119))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,119),wf(:,-4),wf(:,-2),G1tensor(:,151))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,119),wf(:,-2),wf(:,-4),G1tensor(:,152))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,119),wf(:,-4),wf(:,-2),G1tensor(:,153))
  call check_last_UV_W(l_switch,G1(:,:,:,119),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,167))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,511),Q(:,43),G1(:,:,:,120))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,120),wf(:,-4),wf(:,-2),G1tensor(:,154))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,120),wf(:,-2),wf(:,-4),G1tensor(:,155))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,120),wf(:,-4),wf(:,-2),G1tensor(:,156))
  call check_last_UV_W(l_switch,G1(:,:,:,120),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,168))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,477),Q(:,51),G1(:,:,:,121))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,121),wf(:,-3),wf(:,-2),G1tensor(:,157))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,121),wf(:,-2),wf(:,-3),G1tensor(:,158))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,121),wf(:,-3),wf(:,-2),G1tensor(:,159))
  call check_last_UV_W(l_switch,G1(:,:,:,121),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,169))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,509),Q(:,51),G1(:,:,:,122))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,122),wf(:,-3),wf(:,-2),G1tensor(:,160))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,122),wf(:,-2),wf(:,-3),G1tensor(:,161))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,122),wf(:,-3),wf(:,-2),G1tensor(:,162))
  call check_last_UV_W(l_switch,G1(:,:,:,122),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,170))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,512),Q(:,51),G1(:,:,:,123))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,123),wf(:,-3),wf(:,-2),G1tensor(:,163))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,123),wf(:,-2),wf(:,-3),G1tensor(:,164))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,123),wf(:,-3),wf(:,-2),G1tensor(:,165))
  call check_last_UV_W(l_switch,G1(:,:,:,123),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,171))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,129))
  call loop_Q_A(G0(:,:,:,129),Q(:,35),ZERO,G1(:,:,:,124))
  call loop_QV_A(G1(:,:,:,124),wf(:,21),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,63),ZERO,G2tensor(:,172))
  call loop_QV_A(G1(:,:,:,124),wf(:,22),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,63),ZERO,G2tensor(:,173))
  call loop_QV_A(G1(:,:,:,124),wf(:,23),G1(:,:,:,127))
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,63),ZERO,G2tensor(:,174))
  call loop_QV_A(G1(:,:,:,124),wf(:,47),G1(:,:,:,128))
  call check_last_Q_A(l_switch,G1(:,:,:,128),Q(:,63),ZERO,G2tensor(:,175))
  call loop_QV_A(G1(:,:,:,124),wf(:,50),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),ZERO,G2tensor(:,176))
  call loop_QV_A(G1(:,:,:,124),wf(:,52),G1(:,:,:,130))
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),ZERO,G2tensor(:,177))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,45),Q(:,35),G1(:,:,:,131))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,35),wf(:,21),Q(:,28),G2tensor(:,178))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,35),wf(:,22),Q(:,28),G2tensor(:,179))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,35),wf(:,23),Q(:,28),G2tensor(:,180))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,35),wf(:,47),Q(:,28),G2tensor(:,181))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,35),wf(:,50),Q(:,28),G2tensor(:,182))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,35),wf(:,52),Q(:,28),G2tensor(:,183))
  call loop_QV_A(G0(:,:,:,1),wf(:,450),G0(:,:,:,130))
  call loop_Q_A(G0(:,:,:,130),Q(:,51),ZERO,G1(:,:,:,132))
  call loop_QV_A(G1(:,:,:,132),wf(:,24),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,63),ZERO,G2tensor(:,184))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,450),Q(:,51),G1(:,:,:,134))
  call check_last_CV_D(l_switch,G1(:,:,:,134),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,185))
  call loop_QV_A(G0(:,:,:,1),wf(:,451),G0(:,:,:,131))
  call loop_Q_A(G0(:,:,:,131),Q(:,51),ZERO,G1(:,:,:,135))
  call loop_QV_A(G1(:,:,:,135),wf(:,24),G1(:,:,:,136))
  call check_last_Q_A(l_switch,G1(:,:,:,136),Q(:,63),ZERO,G2tensor(:,186))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,451),Q(:,51),G1(:,:,:,137))
  call check_last_CV_D(l_switch,G1(:,:,:,137),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,187))
  call loop_QV_A(G0(:,:,:,1),wf(:,48),G0(:,:,:,132))
  call loop_Q_A(G0(:,:,:,132),Q(:,44),ZERO,G1(:,:,:,138))
  call loop_QV_A(G1(:,:,:,138),wf(:,16),G1(:,:,:,139))
  call check_last_Q_A(l_switch,G1(:,:,:,139),Q(:,63),ZERO,G2tensor(:,188))
  call loop_QV_A(G1(:,:,:,138),wf(:,44),G1(:,:,:,140))
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,63),ZERO,G2tensor(:,189))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,48),Q(:,44),G1(:,:,:,141))
  call check_last_CV_D(l_switch,G1(:,:,:,141),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,190))
  call check_last_CV_D(l_switch,G1(:,:,:,141),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,191))
  call loop_QV_A(G0(:,:,:,1),wf(:,452),G0(:,:,:,133))
  call loop_Q_A(G0(:,:,:,133),Q(:,51),ZERO,G1(:,:,:,142))
  call loop_QV_A(G1(:,:,:,142),wf(:,24),G1(:,:,:,143))
  call check_last_Q_A(l_switch,G1(:,:,:,143),Q(:,63),ZERO,G2tensor(:,192))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,452),Q(:,51),G1(:,:,:,144))
  call check_last_CV_D(l_switch,G1(:,:,:,144),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,193))
  call loop_QV_A(G0(:,:,:,1),wf(:,453),G0(:,:,:,134))
  call loop_Q_A(G0(:,:,:,134),Q(:,43),ZERO,G1(:,:,:,145))
  call loop_QV_A(G1(:,:,:,145),wf(:,26),G1(:,:,:,146))
  call check_last_Q_A(l_switch,G1(:,:,:,146),Q(:,63),ZERO,G2tensor(:,194))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,453),Q(:,43),G1(:,:,:,147))
  call check_last_CV_D(l_switch,G1(:,:,:,147),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,195))
  call loop_QV_A(G0(:,:,:,1),wf(:,454),G0(:,:,:,135))
  call loop_Q_A(G0(:,:,:,135),Q(:,43),ZERO,G1(:,:,:,148))
  call loop_QV_A(G1(:,:,:,148),wf(:,26),G1(:,:,:,149))
  call check_last_Q_A(l_switch,G1(:,:,:,149),Q(:,63),ZERO,G2tensor(:,196))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,454),Q(:,43),G1(:,:,:,150))
  call check_last_CV_D(l_switch,G1(:,:,:,150),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,197))
  call loop_QV_A(G0(:,:,:,1),wf(:,51),G0(:,:,:,136))
  call loop_Q_A(G0(:,:,:,136),Q(:,39),ZERO,G1(:,:,:,151))
  call loop_QV_A(G1(:,:,:,151),wf(:,30),G1(:,:,:,152))
  call check_last_Q_A(l_switch,G1(:,:,:,152),Q(:,63),ZERO,G2tensor(:,198))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,51),Q(:,39),G1(:,:,:,153))
  call check_last_CV_D(l_switch,G1(:,:,:,153),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,199))
  call loop_QV_A(G0(:,:,:,1),wf(:,456),G0(:,:,:,137))
  call loop_Q_A(G0(:,:,:,137),Q(:,39),ZERO,G1(:,:,:,154))
  call loop_QV_A(G1(:,:,:,154),wf(:,30),G1(:,:,:,155))
  call check_last_Q_A(l_switch,G1(:,:,:,155),Q(:,63),ZERO,G2tensor(:,200))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,456),Q(:,39),G1(:,:,:,156))
  call check_last_CV_D(l_switch,G1(:,:,:,156),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,201))
  call loop_QV_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,138))
  call loop_Q_A(G0(:,:,:,138),Q(:,44),ZERO,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,16),G1(:,:,:,158))
  call check_last_Q_A(l_switch,G1(:,:,:,158),Q(:,63),ZERO,G2tensor(:,202))
  call loop_QV_A(G1(:,:,:,157),wf(:,44),G1(:,:,:,159))
  call check_last_Q_A(l_switch,G1(:,:,:,159),Q(:,63),ZERO,G2tensor(:,203))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,53),Q(:,44),G1(:,:,:,160))
  call check_last_CV_D(l_switch,G1(:,:,:,160),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,204))
  call check_last_CV_D(l_switch,G1(:,:,:,160),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,205))
  call loop_QV_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,139))
  call loop_Q_A(G0(:,:,:,139),Q(:,44),ZERO,G1(:,:,:,161))
  call loop_QV_A(G1(:,:,:,161),wf(:,16),G1(:,:,:,162))
  call check_last_Q_A(l_switch,G1(:,:,:,162),Q(:,63),ZERO,G2tensor(:,206))
  call loop_QV_A(G1(:,:,:,161),wf(:,44),G1(:,:,:,163))
  call check_last_Q_A(l_switch,G1(:,:,:,163),Q(:,63),ZERO,G2tensor(:,207))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,44),G1(:,:,:,164))
  call check_last_CV_D(l_switch,G1(:,:,:,164),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,208))
  call check_last_CV_D(l_switch,G1(:,:,:,164),Q(:,44),wf(:,44),Q(:,19),G2tensor(:,209))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,140))
  call loop_Q_A(G0(:,:,:,140),Q(:,52),ZERO,G1(:,:,:,165))
  call loop_QV_A(G1(:,:,:,165),wf(:,12),G1(:,:,:,166))
  call check_last_Q_A(l_switch,G1(:,:,:,166),Q(:,63),ZERO,G2tensor(:,210))
  call loop_QV_A(G1(:,:,:,165),wf(:,42),G1(:,:,:,167))
  call check_last_Q_A(l_switch,G1(:,:,:,167),Q(:,63),ZERO,G2tensor(:,211))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,55),Q(:,52),G1(:,:,:,168))
  call check_last_CV_D(l_switch,G1(:,:,:,168),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,212))
  call check_last_CV_D(l_switch,G1(:,:,:,168),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,213))
  call loop_QV_A(G0(:,:,:,1),wf(:,459),G0(:,:,:,141))
  call loop_Q_A(G0(:,:,:,141),Q(:,43),ZERO,G1(:,:,:,169))
  call loop_QV_A(G1(:,:,:,169),wf(:,26),G1(:,:,:,170))
  call check_last_Q_A(l_switch,G1(:,:,:,170),Q(:,63),ZERO,G2tensor(:,214))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,459),Q(:,43),G1(:,:,:,171))
  call check_last_CV_D(l_switch,G1(:,:,:,171),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,215))
  call loop_QV_A(G0(:,:,:,1),wf(:,56),G0(:,:,:,142))
  call loop_Q_A(G0(:,:,:,142),Q(:,52),ZERO,G1(:,:,:,172))
  call loop_QV_A(G1(:,:,:,172),wf(:,12),G1(:,:,:,173))
  call check_last_Q_A(l_switch,G1(:,:,:,173),Q(:,63),ZERO,G2tensor(:,216))
  call loop_QV_A(G1(:,:,:,172),wf(:,42),G1(:,:,:,174))
  call check_last_Q_A(l_switch,G1(:,:,:,174),Q(:,63),ZERO,G2tensor(:,217))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,56),Q(:,52),G1(:,:,:,175))
  call check_last_CV_D(l_switch,G1(:,:,:,175),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,218))
  call check_last_CV_D(l_switch,G1(:,:,:,175),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,219))
  call loop_QV_A(G0(:,:,:,1),wf(:,57),G0(:,:,:,143))
  call loop_Q_A(G0(:,:,:,143),Q(:,52),ZERO,G1(:,:,:,176))
  call loop_QV_A(G1(:,:,:,176),wf(:,12),G1(:,:,:,177))
  call check_last_Q_A(l_switch,G1(:,:,:,177),Q(:,63),ZERO,G2tensor(:,220))
  call loop_QV_A(G1(:,:,:,176),wf(:,42),G1(:,:,:,178))
  call check_last_Q_A(l_switch,G1(:,:,:,178),Q(:,63),ZERO,G2tensor(:,221))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,57),Q(:,52),G1(:,:,:,179))
  call check_last_CV_D(l_switch,G1(:,:,:,179),Q(:,52),wf(:,12),Q(:,11),G2tensor(:,222))
  call check_last_CV_D(l_switch,G1(:,:,:,179),Q(:,52),wf(:,42),Q(:,11),G2tensor(:,223))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,144))
  call loop_Q_A(G0(:,:,:,144),Q(:,56),ZERO,G1(:,:,:,180))
  call loop_QV_A(G1(:,:,:,180),wf(:,8),G1(:,:,:,181))
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,63),ZERO,G2tensor(:,224))
  call loop_QV_A(G1(:,:,:,180),wf(:,39),G1(:,:,:,182))
  call check_last_Q_A(l_switch,G1(:,:,:,182),Q(:,63),ZERO,G2tensor(:,225))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,58),Q(:,56),G1(:,:,:,183))
  call check_last_CV_D(l_switch,G1(:,:,:,183),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,226))
  call check_last_CV_D(l_switch,G1(:,:,:,183),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,227))
  call loop_QV_A(G0(:,:,:,1),wf(:,462),G0(:,:,:,145))
  call loop_Q_A(G0(:,:,:,145),Q(:,39),ZERO,G1(:,:,:,184))
  call loop_QV_A(G1(:,:,:,184),wf(:,30),G1(:,:,:,185))
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,63),ZERO,G2tensor(:,228))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,462),Q(:,39),G1(:,:,:,186))
  call check_last_CV_D(l_switch,G1(:,:,:,186),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,229))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,146))
  call loop_Q_A(G0(:,:,:,146),Q(:,56),ZERO,G1(:,:,:,187))
  call loop_QV_A(G1(:,:,:,187),wf(:,8),G1(:,:,:,188))
  call check_last_Q_A(l_switch,G1(:,:,:,188),Q(:,63),ZERO,G2tensor(:,230))
  call loop_QV_A(G1(:,:,:,187),wf(:,39),G1(:,:,:,189))
  call check_last_Q_A(l_switch,G1(:,:,:,189),Q(:,63),ZERO,G2tensor(:,231))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,59),Q(:,56),G1(:,:,:,190))
  call check_last_CV_D(l_switch,G1(:,:,:,190),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,232))
  call check_last_CV_D(l_switch,G1(:,:,:,190),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,233))
  call loop_QV_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,147))
  call loop_Q_A(G0(:,:,:,147),Q(:,56),ZERO,G1(:,:,:,191))
  call loop_QV_A(G1(:,:,:,191),wf(:,8),G1(:,:,:,192))
  call check_last_Q_A(l_switch,G1(:,:,:,192),Q(:,63),ZERO,G2tensor(:,234))
  call loop_QV_A(G1(:,:,:,191),wf(:,39),G1(:,:,:,193))
  call check_last_Q_A(l_switch,G1(:,:,:,193),Q(:,63),ZERO,G2tensor(:,235))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,60),Q(:,56),G1(:,:,:,194))
  call check_last_CV_D(l_switch,G1(:,:,:,194),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,236))
  call check_last_CV_D(l_switch,G1(:,:,:,194),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,237))
  call loop_QV_A(G0(:,:,:,1),wf(:,477),G0(:,:,:,148))
  call loop_Q_A(G0(:,:,:,148),Q(:,51),ZERO,G1(:,:,:,195))
  call loop_QV_A(G1(:,:,:,195),wf(:,24),G1(:,:,:,196))
  call check_last_Q_A(l_switch,G1(:,:,:,196),Q(:,63),ZERO,G2tensor(:,238))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,477),Q(:,51),G1(:,:,:,197))
  call check_last_CV_D(l_switch,G1(:,:,:,197),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,239))
  call loop_QV_A(G0(:,:,:,1),wf(:,509),G0(:,:,:,149))
  call loop_Q_A(G0(:,:,:,149),Q(:,51),ZERO,G1(:,:,:,198))
  call loop_QV_A(G1(:,:,:,198),wf(:,24),G1(:,:,:,199))
  call check_last_Q_A(l_switch,G1(:,:,:,199),Q(:,63),ZERO,G2tensor(:,240))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,509),Q(:,51),G1(:,:,:,200))
  call check_last_CV_D(l_switch,G1(:,:,:,200),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,241))
  call loop_QV_A(G0(:,:,:,1),wf(:,512),G0(:,:,:,150))
  call loop_Q_A(G0(:,:,:,150),Q(:,51),ZERO,G1(:,:,:,201))
  call loop_QV_A(G1(:,:,:,201),wf(:,24),G1(:,:,:,202))
  call check_last_Q_A(l_switch,G1(:,:,:,202),Q(:,63),ZERO,G2tensor(:,242))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,512),Q(:,51),G1(:,:,:,203))
  call check_last_CV_D(l_switch,G1(:,:,:,203),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,243))
  call loop_QV_A(G0(:,:,:,1),wf(:,482),G0(:,:,:,151))
  call loop_Q_A(G0(:,:,:,151),Q(:,43),ZERO,G1(:,:,:,204))
  call loop_QV_A(G1(:,:,:,204),wf(:,26),G1(:,:,:,205))
  call check_last_Q_A(l_switch,G1(:,:,:,205),Q(:,63),ZERO,G2tensor(:,244))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,482),Q(:,43),G1(:,:,:,206))
  call check_last_CV_D(l_switch,G1(:,:,:,206),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,245))
  call loop_QV_A(G0(:,:,:,1),wf(:,506),G0(:,:,:,152))
  call loop_Q_A(G0(:,:,:,152),Q(:,43),ZERO,G1(:,:,:,207))
  call loop_QV_A(G1(:,:,:,207),wf(:,26),G1(:,:,:,208))
  call check_last_Q_A(l_switch,G1(:,:,:,208),Q(:,63),ZERO,G2tensor(:,246))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,506),Q(:,43),G1(:,:,:,209))
  call check_last_CV_D(l_switch,G1(:,:,:,209),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,247))
  call loop_QV_A(G0(:,:,:,1),wf(:,511),G0(:,:,:,153))
  call loop_Q_A(G0(:,:,:,153),Q(:,43),ZERO,G1(:,:,:,210))
  call loop_QV_A(G1(:,:,:,210),wf(:,26),G1(:,:,:,211))
  call check_last_Q_A(l_switch,G1(:,:,:,211),Q(:,63),ZERO,G2tensor(:,248))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,511),Q(:,43),G1(:,:,:,212))
  call check_last_CV_D(l_switch,G1(:,:,:,212),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,249))
  call loop_QV_A(G0(:,:,:,1),wf(:,63),G0(:,:,:,154))
  call loop_Q_A(G0(:,:,:,154),Q(:,39),ZERO,G1(:,:,:,213))
  call loop_QV_A(G1(:,:,:,213),wf(:,30),G1(:,:,:,214))
  call check_last_Q_A(l_switch,G1(:,:,:,214),Q(:,63),ZERO,G2tensor(:,250))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,63),Q(:,39),G1(:,:,:,215))
  call check_last_CV_D(l_switch,G1(:,:,:,215),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,251))
  call loop_QV_A(G0(:,:,:,1),wf(:,503),G0(:,:,:,155))
  call loop_Q_A(G0(:,:,:,155),Q(:,39),ZERO,G1(:,:,:,216))
  call loop_QV_A(G1(:,:,:,216),wf(:,30),G1(:,:,:,217))
  call check_last_Q_A(l_switch,G1(:,:,:,217),Q(:,63),ZERO,G2tensor(:,252))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,503),Q(:,39),G1(:,:,:,218))
  call check_last_CV_D(l_switch,G1(:,:,:,218),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,253))
  call loop_QV_A(G0(:,:,:,1),wf(:,510),G0(:,:,:,156))
  call loop_Q_A(G0(:,:,:,156),Q(:,39),ZERO,G1(:,:,:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,30),G1(:,:,:,220))
  call check_last_Q_A(l_switch,G1(:,:,:,220),Q(:,63),ZERO,G2tensor(:,254))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,510),Q(:,39),G1(:,:,:,221))
  call check_last_CV_D(l_switch,G1(:,:,:,221),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,255))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(354)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(354)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(354)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(358)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(358)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(358)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(374)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(374)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(374)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(374)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(374)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(374)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(15)*(-M(5)+M(6)-M(7)+M(8))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(16)*(-M(5)+M(6)-M(7)+M(8))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(6)*(-M(5)+M(6)-M(7)+M(8))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(150)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(344)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(344)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(344)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(348)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(348)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(348)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(351)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(351)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(351)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(15)*(M(4)-M(5)-M(7)+M(9))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(15)*(-M(4)+M(6)+M(8)-M(9))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(16)*(M(4)-M(5)-M(7)+M(9))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(16)*(-M(4)+M(6)+M(8)-M(9))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(6)*(M(4)-M(5)-M(7)+M(9))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(6)*(-M(4)+M(6)+M(8)-M(9))) * den(151)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(15)*(-M(5)+M(6)-M(7)+M(8))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(16)*(-M(5)+M(6)-M(7)+M(8))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(6)*(-M(5)+M(6)-M(7)+M(8))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(193)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(193)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(183)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(183)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(183)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(201)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(216)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(57)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(204)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(60)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(219)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(63)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(222)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(57)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(60)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(201)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(184)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(184)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(184)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(204)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(63)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(185)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(185)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(185)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(216)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(186)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(186)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(186)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(219)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(222)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,106)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(187)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,110)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(187)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,110)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(187)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(188)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(188)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(188)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,134)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(192)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(192)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(192)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(194)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(462)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(462)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(462)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(192)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(192)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(192)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(194)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(190)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,149)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(190)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,149)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(190)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,150)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(200)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(200)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(200)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(202)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,151)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(471)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(471)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(471)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(215)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(215)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(215)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(217)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,152)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(478)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(478)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(478)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(56)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(56)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(56)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(203)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(203)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(203)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(58)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,153)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(205)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,154)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(59)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(59)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(59)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(218)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(218)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(218)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(61)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,155)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(220)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,156)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(62)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(62)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(62)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(221)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(221)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(221)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(64)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,157)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(223)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,158)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(502)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(502)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(502)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(503)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(503)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(503)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(505)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(505)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(505)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(506)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(506)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(506)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(508)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,79)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(508)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(508)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,81)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(509)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(509)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(509)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(480)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,85)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(480)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,86)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(480)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(58)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(469)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(469)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(469)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,90)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(61)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(504)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(504)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(504)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(507)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(507)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,95)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(507)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(511)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(511)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(511)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(512)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,100)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(512)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(512)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(200)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(200)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(200)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(202)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(196)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,159)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(196)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,159)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(196)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,160)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(480)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(480)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(480)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,105)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(205)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(460)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,106)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(460)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,107)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(460)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,108)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(64)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(504)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,109)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(504)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,110)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(504)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,111)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(510)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,112)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(510)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,113)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(510)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,114)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(511)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,115)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(511)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,116)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(511)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,117)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(513)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,118)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(513)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,119)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(513)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,120)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(480)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,121)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(480)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,122)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(480)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,123)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(198)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(198)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(198)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(504)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,124)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(504)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,125)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(504)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,126)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(511)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,127)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(511)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,128)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(511)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,129)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(215)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(215)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(215)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(217)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(207)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,164)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(207)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,164)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(207)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,165)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(469)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,130)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(469)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,131)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(469)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,132)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(220)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(460)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,133)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(460)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,134)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(460)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,135)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(223)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(507)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,136)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(507)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,137)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(507)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,138)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(510)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,139)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(510)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,140)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(510)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,141)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(512)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,142)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(512)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,143)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(512)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,144)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(513)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,145)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(513)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,146)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(513)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,147)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(469)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,148)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(469)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,149)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(469)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,150)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(209)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(209)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(209)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(507)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,151)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(507)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,152)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(507)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,153)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(512)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,154)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(512)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,155)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(512)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,156)
  Gcoeff = (c(19)*(M(5)-M(6)+M(7)-M(8))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(20)*(M(5)-M(6)+M(7)-M(8))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(12)*(M(5)-M(6)+M(7)-M(8))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(210)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(460)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,157)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(460)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,158)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(460)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,159)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(212)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(212)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(212)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,135)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(510)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,160)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(510)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,161)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(510)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,162)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(513)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,163)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(513)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,164)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(513)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,165)
  Gcoeff = (c(19)*(-M(4)+M(5)+M(7)-M(9))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(19)*(M(4)-M(6)-M(8)+M(9))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(20)*(-M(4)+M(5)+M(7)-M(9))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(20)*(M(4)-M(6)-M(8)+M(9))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(12)*(-M(4)+M(5)+M(7)-M(9))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(12)*(M(4)-M(6)-M(8)+M(9))) * den(213)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,172)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,173)
  Gcoeff = (c(19)*(M(5)-M(6)+M(7)-M(8))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,174)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,172)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,173)
  Gcoeff = (c(20)*(M(5)-M(6)+M(7)-M(8))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,174)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,178)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,179)
  Gcoeff = (c(12)*(M(5)-M(6)+M(7)-M(8))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,180)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,143)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,144)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(214)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,145)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(345)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,184)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(345)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,184)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(345)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,185)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(345)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(347)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(347)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(347)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(350)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(350)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(350)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(349)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,186)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(349)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,186)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(349)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,187)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(349)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(15)*(M(4)-M(5)-M(7)+M(9))) * den(353)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,188)
  Gcoeff = (c(16)*(M(4)-M(5)-M(7)+M(9))) * den(353)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,188)
  Gcoeff = (c(6)*(M(4)-M(5)-M(7)+M(9))) * den(353)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,190)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(353)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(352)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,192)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(352)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,192)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(352)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,193)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(352)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(355)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,194)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(355)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,194)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(355)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,195)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(355)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(357)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(357)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(357)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,120)
  Gcoeff = (c(15)*(-M(5)+M(6)-M(7)+M(8))) * den(360)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(16)*(-M(5)+M(6)-M(7)+M(8))) * den(360)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(6)*(-M(5)+M(6)-M(7)+M(8))) * den(360)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(359)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,196)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(359)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,196)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(359)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,197)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(359)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(362)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(362)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(362)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(364)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,198)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(364)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,198)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(364)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,199)
  Gcoeff = (c(15)*(-M(4)+M(6)+M(8)-M(9))) * den(367)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(16)*(-M(4)+M(6)+M(8)-M(9))) * den(367)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(6)*(-M(4)+M(6)+M(8)-M(9))) * den(367)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(366)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,200)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(366)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,200)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(366)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,201)
  Gcoeff = (c(15)*(-M(4)+M(6)+M(8)-M(9))) * den(370)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,202)
  Gcoeff = (c(16)*(-M(4)+M(6)+M(8)-M(9))) * den(370)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,202)
  Gcoeff = (c(6)*(-M(4)+M(6)+M(8)-M(9))) * den(370)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,204)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(370)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(369)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(369)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(369)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(15)*(-M(5)+M(6)-M(7)+M(8))) * den(373)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,206)
  Gcoeff = (c(16)*(-M(5)+M(6)-M(7)+M(8))) * den(373)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,206)
  Gcoeff = (c(6)*(-M(5)+M(6)-M(7)+M(8))) * den(373)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,208)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(373)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(372)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(372)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(372)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(15)*(-M(5)+M(6)-M(7)+M(8))) * den(376)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,210)
  Gcoeff = (c(16)*(-M(5)+M(6)-M(7)+M(8))) * den(376)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,210)
  Gcoeff = (c(6)*(-M(5)+M(6)-M(7)+M(8))) * den(376)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,212)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(376)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(375)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,214)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(375)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,214)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(375)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,215)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(375)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(379)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,216)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(379)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,216)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(379)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,218)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(379)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(378)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(378)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(378)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(15)*(M(4)-M(5)-M(7)+M(9))) * den(382)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,220)
  Gcoeff = (c(16)*(M(4)-M(5)-M(7)+M(9))) * den(382)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,220)
  Gcoeff = (c(6)*(M(4)-M(5)-M(7)+M(9))) * den(382)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,222)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(382)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(381)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(381)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(381)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(15)*(-M(4)+M(6)+M(8)-M(9))) * den(385)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,224)
  Gcoeff = (c(16)*(-M(4)+M(6)+M(8)-M(9))) * den(385)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,224)
  Gcoeff = (c(6)*(-M(4)+M(6)+M(8)-M(9))) * den(385)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,226)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(385)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(15)*(M(4)-M(6)-M(8)+M(9))) * den(384)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,228)
  Gcoeff = (c(16)*(M(4)-M(6)-M(8)+M(9))) * den(384)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,228)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(384)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,229)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(388)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,230)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(388)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,230)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(388)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,232)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(388)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(387)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(387)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(387)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,122)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(391)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,234)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(391)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,234)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(391)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,236)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(391)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(15)*(-M(4)+M(5)+M(7)-M(9))) * den(390)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(16)*(-M(4)+M(5)+M(7)-M(9))) * den(390)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(6)*(-M(4)+M(5)+M(7)-M(9))) * den(390)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,138)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(463)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,131)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(463)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,131)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(463)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,139)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(461)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,238)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(461)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,238)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(461)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,239)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(461)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,169)
  Gcoeff = (c(19)*(-M(4)+M(5)+M(7)-M(9))) * den(467)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,189)
  Gcoeff = (c(20)*(-M(4)+M(5)+M(7)-M(9))) * den(467)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,189)
  Gcoeff = (c(12)*(-M(4)+M(5)+M(7)-M(9))) * den(467)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,191)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(467)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(523)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,240)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(523)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,240)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(523)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,241)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(523)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,170)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(468)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,175)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(468)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,175)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(468)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,181)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(468)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,146)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(524)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,242)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(524)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,242)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(524)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,243)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(524)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,171)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(472)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(472)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(472)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(470)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,244)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(470)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,244)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(470)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,245)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(470)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,166)
  Gcoeff = (c(19)*(M(5)-M(6)+M(7)-M(8))) * den(476)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,211)
  Gcoeff = (c(20)*(M(5)-M(6)+M(7)-M(8))) * den(476)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,211)
  Gcoeff = (c(12)*(M(5)-M(6)+M(7)-M(8))) * den(476)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,213)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(476)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(525)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,246)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(525)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,246)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(525)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,247)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(525)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,167)
  Gcoeff = (c(19)*(M(5)-M(6)+M(7)-M(8))) * den(477)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,176)
  Gcoeff = (c(20)*(M(5)-M(6)+M(7)-M(8))) * den(477)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,176)
  Gcoeff = (c(12)*(M(5)-M(6)+M(7)-M(8))) * den(477)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,182)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(477)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,147)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(526)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,248)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(526)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,248)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(526)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,249)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(526)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,168)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(481)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,250)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(481)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,250)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(481)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,251)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(481)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,161)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(479)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(479)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(479)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(527)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,252)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(527)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,252)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(527)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,253)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(527)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,162)
  Gcoeff = (c(19)*(M(4)-M(6)-M(8)+M(9))) * den(484)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,225)
  Gcoeff = (c(20)*(M(4)-M(6)-M(8)+M(9))) * den(484)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,225)
  Gcoeff = (c(12)*(M(4)-M(6)-M(8)+M(9))) * den(484)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,227)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(484)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(19)*(M(4)-M(6)-M(8)+M(9))) * den(485)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,177)
  Gcoeff = (c(20)*(M(4)-M(6)-M(8)+M(9))) * den(485)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,177)
  Gcoeff = (c(12)*(M(4)-M(6)-M(8)+M(9))) * den(485)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,183)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(485)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,148)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(528)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,254)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(528)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,254)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(528)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,255)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(528)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,163)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(490)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,217)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(490)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,217)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(490)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,219)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(490)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(529)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(529)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(529)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(19)*(M(4)-M(6)-M(8)+M(9))) * den(491)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,203)
  Gcoeff = (c(20)*(M(4)-M(6)-M(8)+M(9))) * den(491)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,203)
  Gcoeff = (c(12)*(M(4)-M(6)-M(8)+M(9))) * den(491)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,205)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(491)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(19)*(-M(4)+M(6)+M(8)-M(9))) * den(530)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(20)*(-M(4)+M(6)+M(8)-M(9))) * den(530)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(530)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(531)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(531)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(531)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(494)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,231)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(494)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,231)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(494)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,233)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(494)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(19)*(M(5)-M(6)+M(7)-M(8))) * den(495)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,207)
  Gcoeff = (c(20)*(M(5)-M(6)+M(7)-M(8))) * den(495)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,207)
  Gcoeff = (c(12)*(M(5)-M(6)+M(7)-M(8))) * den(495)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,209)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(495)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(532)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(532)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(532)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,125)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(533)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(533)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(533)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(497)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,235)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(497)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,235)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(497)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,237)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(497)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(19)*(M(4)-M(5)-M(7)+M(9))) * den(534)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(20)*(M(4)-M(5)-M(7)+M(9))) * den(534)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(12)*(M(4)-M(5)-M(7)+M(9))) * den(534)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,141)
  Gcoeff = (c(19)*(-M(4)+M(5)+M(7)-M(9))) * den(498)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,221)
  Gcoeff = (c(20)*(-M(4)+M(5)+M(7)-M(9))) * den(498)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,221)
  Gcoeff = (c(12)*(-M(4)+M(5)+M(7)-M(9))) * den(498)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,223)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(498)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,79)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_7

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_7_heftpphhjj_hhgggg_1_/**/REALKIND
