
module ol_vamp_6_heftpphhjj_hhgggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_6(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_hhgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_hhgggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_hhgggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_hhgggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(9)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,226) :: G0
  complex(REALKIND), dimension(4,5,4,33) :: G1
  complex(REALKIND), dimension(1,54) :: G0tensor
  complex(REALKIND), dimension(5,240) :: G1tensor
  complex(REALKIND), dimension(15,142) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,48),G1(:,:,:,1))
  call check_last_GHHGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G1tensor(:,1))
  call check_last_GHHGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-3),G1tensor(:,2))
  call check_last_GHHGG_G_23(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G1tensor(:,3))
  call check_last_GHGG_G_12(l_switch,G1(:,:,:,1),wf(:,4),wf(:,-3),wf(:,-2),G1tensor(:,4))
  call check_last_GHGG_G_12(l_switch,G1(:,:,:,1),wf(:,4),wf(:,-2),wf(:,-3),G1tensor(:,5))
  call check_last_GHGG_G_23(l_switch,G1(:,:,:,1),wf(:,4),wf(:,-3),wf(:,-2),G1tensor(:,6))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,8),G1tensor(:,7))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,8),wf(:,-3),G1tensor(:,8))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,8),G1tensor(:,9))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,12),G1tensor(:,10))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,12),wf(:,-2),G1tensor(:,11))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,12),G1tensor(:,12))
  call check_last_GHHG_G(l_switch,G1(:,:,:,1),Q(:,48),wf(:,-1),wf(:,0),wf(:,24),Q(:,12),G2tensor(:,1), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,35),Q(:,15),G2tensor(:,2))
  call check_last_GHG_G(l_switch,G1(:,:,:,1),Q(:,48),wf(:,4),wf(:,24),Q(:,12),G2tensor(:,3), Q(:,63))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,39),G1tensor(:,13))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,39),wf(:,-3),G1tensor(:,14))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,39),G1tensor(:,15))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,42),G1tensor(:,16))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,42),wf(:,-2),G1tensor(:,17))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,42),G1tensor(:,18))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,43),Q(:,15),G2tensor(:,4))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,46),Q(:,15),G2tensor(:,5))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,461),Q(:,15),G2tensor(:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,464),Q(:,15),G2tensor(:,7))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,61),Q(:,15),G2tensor(:,8))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,501),Q(:,15),G2tensor(:,9))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,504),Q(:,15),G2tensor(:,10))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,24),G0(:,:,:,2))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,19))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,24),wf(:,-5),G0(:,:,:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,3),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,20))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,24),G0(:,:,:,4))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,21))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,-5),Q(:,32),G1(:,:,:,2), Q(:,35))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-4),wf(:,24),G1tensor(:,22))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,24),wf(:,-4),G1tensor(:,23))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,-4),wf(:,24),G1tensor(:,24))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-3),wf(:,26),G1tensor(:,25))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,26),wf(:,-3),G1tensor(:,26))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,-3),wf(:,26),G1tensor(:,27))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-2),wf(:,30),G1tensor(:,28))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,30),wf(:,-2),G1tensor(:,29))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,-2),wf(:,30),G1tensor(:,30))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,21),Q(:,28),G2tensor(:,11))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,22),Q(:,28),G2tensor(:,12))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,23),Q(:,28),G2tensor(:,13))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,47),Q(:,28),G2tensor(:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,50),Q(:,28),G2tensor(:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,52),Q(:,28),G2tensor(:,16))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,26),G0(:,:,:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,31))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,26),wf(:,-5),G0(:,:,:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,32))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,26),G0(:,:,:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,33))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,30),G0(:,:,:,8))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,34))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,30),wf(:,-5),G0(:,:,:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,35))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,30),G0(:,:,:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,36))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-4),wf(:,28),G0(:,:,:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,11),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,37))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,28),wf(:,-4),G0(:,:,:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,38))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-4),wf(:,28),G0(:,:,:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,13),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,39))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-4),wf(:,32),G0(:,:,:,14))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,40))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,32),wf(:,-4),G0(:,:,:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,41))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-4),wf(:,32),G0(:,:,:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,42))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,28),Q(:,36),G1(:,:,:,3), Q(:,39))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-4),wf(:,-3),G1tensor(:,43))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-3),wf(:,-4),G1tensor(:,44))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,3),wf(:,-4),wf(:,-3),G1tensor(:,45))
  call check_last_UV_W(l_switch,G1(:,:,:,3),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,17))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,9),Q(:,56),G1(:,:,:,4), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,4),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,18))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,10),Q(:,56),G1(:,:,:,5), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,5),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,19))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,11),Q(:,56),G1(:,:,:,6), Q(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,20))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,39),G0(:,:,:,17))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,17),wf(:,-4),wf(:,-3),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,17),wf(:,-3),wf(:,-4),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,17),wf(:,-4),wf(:,-3),G0tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,46))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,39),wf(:,-5),G0(:,:,:,18))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-4),wf(:,-3),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-3),wf(:,-4),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,18),wf(:,-4),wf(:,-3),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,47))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,39),G0(:,:,:,19))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-4),wf(:,-3),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-3),wf(:,-4),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,19),wf(:,-4),wf(:,-3),G0tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,48))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,38),G0(:,:,:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,49))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,38),wf(:,-5),G0(:,:,:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,50))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,38),G0(:,:,:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,51))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,37),G0(:,:,:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,52))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,-4),G0(:,:,:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,53))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,37),G0(:,:,:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,54))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,36),G0(:,:,:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,55))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,36),wf(:,-3),G0(:,:,:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,56))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,36),G0(:,:,:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,57))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-3),wf(:,28),G0(:,:,:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,58))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,28),wf(:,-3),G0(:,:,:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,59))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-3),wf(:,28),G0(:,:,:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,60))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-3),wf(:,34),G0(:,:,:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,61))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,34),wf(:,-3),G0(:,:,:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,62))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-3),wf(:,34),G0(:,:,:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,63))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,32),Q(:,40),G1(:,:,:,7), Q(:,43))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,7),wf(:,-4),wf(:,-2),G1tensor(:,64))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,7),wf(:,-2),wf(:,-4),G1tensor(:,65))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,7),wf(:,-4),wf(:,-2),G1tensor(:,66))
  call check_last_UV_W(l_switch,G1(:,:,:,7),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,21))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,13),Q(:,52),G1(:,:,:,8), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,8),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,22))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,14),Q(:,52),G1(:,:,:,9), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,9),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,23))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,15),Q(:,52),G1(:,:,:,10), Q(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,10),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,24))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,42),G0(:,:,:,35))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,35),wf(:,-4),wf(:,-2),G0tensor(:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,35),wf(:,-2),wf(:,-4),G0tensor(:,11))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,35),wf(:,-4),wf(:,-2),G0tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,67))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,42),wf(:,-5),G0(:,:,:,36))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,36),wf(:,-4),wf(:,-2),G0tensor(:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,36),wf(:,-2),wf(:,-4),G0tensor(:,14))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,36),wf(:,-4),wf(:,-2),G0tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,68))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,42),G0(:,:,:,37))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,37),wf(:,-4),wf(:,-2),G0tensor(:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,37),wf(:,-2),wf(:,-4),G0tensor(:,17))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,37),wf(:,-4),wf(:,-2),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,37),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,69))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,41),G0(:,:,:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,70))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,41),wf(:,-5),G0(:,:,:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,71))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,41),G0(:,:,:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,72))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,40),G0(:,:,:,41))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,73))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,40),wf(:,-4),G0(:,:,:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,74))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,40),G0(:,:,:,43))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,75))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,36),G0(:,:,:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,76))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,36),wf(:,-2),G0(:,:,:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,77))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,36),G0(:,:,:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,78))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,34),Q(:,48),G1(:,:,:,11), Q(:,51))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,11),wf(:,-3),wf(:,-2),G1tensor(:,79))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,11),wf(:,-2),wf(:,-3),G1tensor(:,80))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,11),wf(:,-3),wf(:,-2),G1tensor(:,81))
  call check_last_UV_W(l_switch,G1(:,:,:,11),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,25))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,17),Q(:,44),G1(:,:,:,12), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,12),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,26))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,18),Q(:,44),G1(:,:,:,13), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,13),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,27))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,19),Q(:,44),G1(:,:,:,14), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,14),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,28))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,44),G0(:,:,:,47))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,47),wf(:,-3),wf(:,-2),G0tensor(:,19))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,47),wf(:,-2),wf(:,-3),G0tensor(:,20))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,47),wf(:,-3),wf(:,-2),G0tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,82))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,-5),G0(:,:,:,48))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,48),wf(:,-3),wf(:,-2),G0tensor(:,22))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,48),wf(:,-2),wf(:,-3),G0tensor(:,23))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,48),wf(:,-3),wf(:,-2),G0tensor(:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,48),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,83))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,44),G0(:,:,:,49))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,49),wf(:,-3),wf(:,-2),G0tensor(:,25))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,49),wf(:,-2),wf(:,-3),G0tensor(:,26))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,49),wf(:,-3),wf(:,-2),G0tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,49),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,84))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,43),G0(:,:,:,50))
  call check_last_UV_W(l_switch,G0(:,:,:,50),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,85))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,43),wf(:,-5),G0(:,:,:,51))
  call check_last_UV_W(l_switch,G0(:,:,:,51),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,86))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,43),G0(:,:,:,52))
  call check_last_UV_W(l_switch,G0(:,:,:,52),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,87))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,45),G0(:,:,:,53))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,53),wf(:,-3),wf(:,-2),G0tensor(:,28))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,53),wf(:,-2),wf(:,-3),G0tensor(:,29))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,53),wf(:,-3),wf(:,-2),G0tensor(:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,53),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,88))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,-4),G0(:,:,:,54))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,54),wf(:,-3),wf(:,-2),G0tensor(:,31))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,54),wf(:,-2),wf(:,-3),G0tensor(:,32))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,54),wf(:,-3),wf(:,-2),G0tensor(:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,54),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,89))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,45),G0(:,:,:,55))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,55),wf(:,-3),wf(:,-2),G0tensor(:,34))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,55),wf(:,-2),wf(:,-3),G0tensor(:,35))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,55),wf(:,-3),wf(:,-2),G0tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,55),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,90))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,36),Q(:,51),G1(:,:,:,15))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,15),wf(:,-3),wf(:,-2),G1tensor(:,91))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,15),wf(:,-2),wf(:,-3),G1tensor(:,92))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,15),wf(:,-3),wf(:,-2),G1tensor(:,93))
  call check_last_UV_W(l_switch,G1(:,:,:,15),Q(:,51),wf(:,24),Q(:,12),G2tensor(:,29))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,40),G0(:,:,:,56))
  call check_last_UV_W(l_switch,G0(:,:,:,56),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,94))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,40),wf(:,-3),G0(:,:,:,57))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,95))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,40),G0(:,:,:,58))
  call check_last_UV_W(l_switch,G0(:,:,:,58),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,96))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,37),G0(:,:,:,59))
  call check_last_UV_W(l_switch,G0(:,:,:,59),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,97))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,-2),G0(:,:,:,60))
  call check_last_UV_W(l_switch,G0(:,:,:,60),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,98))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,37),G0(:,:,:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,99))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,45),G0(:,:,:,62))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,62),wf(:,-4),wf(:,-2),G0tensor(:,37))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,62),wf(:,-2),wf(:,-4),G0tensor(:,38))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,62),wf(:,-4),wf(:,-2),G0tensor(:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,62),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,100))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,-3),G0(:,:,:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,63),wf(:,-4),wf(:,-2),G0tensor(:,40))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,63),wf(:,-2),wf(:,-4),G0tensor(:,41))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,63),wf(:,-4),wf(:,-2),G0tensor(:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,101))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,45),G0(:,:,:,64))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,64),wf(:,-4),wf(:,-2),G0tensor(:,43))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,64),wf(:,-2),wf(:,-4),G0tensor(:,44))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,64),wf(:,-4),wf(:,-2),G0tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,102))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,43),G1(:,:,:,16))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,16),wf(:,-4),wf(:,-2),G1tensor(:,103))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,16),wf(:,-2),wf(:,-4),G1tensor(:,104))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,16),wf(:,-4),wf(:,-2),G1tensor(:,105))
  call check_last_UV_W(l_switch,G1(:,:,:,16),Q(:,43),wf(:,26),Q(:,20),G2tensor(:,30))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,45),G0(:,:,:,65))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,65),wf(:,-4),wf(:,-3),G0tensor(:,46))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,65),wf(:,-3),wf(:,-4),G0tensor(:,47))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,65),wf(:,-4),wf(:,-3),G0tensor(:,48))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,106))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,-2),G0(:,:,:,66))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,66),wf(:,-4),wf(:,-3),G0tensor(:,49))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,66),wf(:,-3),wf(:,-4),G0tensor(:,50))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,66),wf(:,-4),wf(:,-3),G0tensor(:,51))
  call check_last_UV_W(l_switch,G0(:,:,:,66),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,107))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,45),G0(:,:,:,67))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,67),wf(:,-4),wf(:,-3),G0tensor(:,52))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,67),wf(:,-3),wf(:,-4),G0tensor(:,53))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,67),wf(:,-4),wf(:,-3),G0tensor(:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,67),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,108))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,40),Q(:,39),G1(:,:,:,17))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,17),wf(:,-4),wf(:,-3),G1tensor(:,109))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,17),wf(:,-3),wf(:,-4),G1tensor(:,110))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,17),wf(:,-4),wf(:,-3),G1tensor(:,111))
  call check_last_UV_W(l_switch,G1(:,:,:,17),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,31))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-2),wf(:,32),G0(:,:,:,68))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,112))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,32),wf(:,-2),G0(:,:,:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,113))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-2),wf(:,32),G0(:,:,:,70))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,114))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-2),wf(:,34),G0(:,:,:,71))
  call check_last_UV_W(l_switch,G0(:,:,:,71),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,115))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,34),wf(:,-2),G0(:,:,:,72))
  call check_last_UV_W(l_switch,G0(:,:,:,72),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,116))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-2),wf(:,34),G0(:,:,:,73))
  call check_last_UV_W(l_switch,G0(:,:,:,73),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,117))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,24),wf(:,34),G0(:,:,:,74))
  call check_last_GHH_G(l_switch,G0(:,:,:,74),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,32), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,74),Q(:,60),wf(:,4),G2tensor(:,33), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,34),wf(:,24),G0(:,:,:,75))
  call check_last_GHH_G(l_switch,G0(:,:,:,75),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,34), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,75),Q(:,60),wf(:,4),G2tensor(:,35), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,24),wf(:,34),G0(:,:,:,76))
  call check_last_GHH_G(l_switch,G0(:,:,:,76),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,36), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,76),Q(:,60),wf(:,4),G2tensor(:,37), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,24),G0(:,:,:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,118))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,24),wf(:,20),G0(:,:,:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,78),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,119))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,20),wf(:,24),G0(:,:,:,79))
  call check_last_UV_W(l_switch,G0(:,:,:,79),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,120))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,47),G0(:,:,:,80))
  call check_last_GHH_G(l_switch,G0(:,:,:,80),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,38), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,80),Q(:,60),wf(:,4),G2tensor(:,39), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,47),wf(:,-5),G0(:,:,:,81))
  call check_last_GHH_G(l_switch,G0(:,:,:,81),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,40), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,81),Q(:,60),wf(:,4),G2tensor(:,41), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,47),G0(:,:,:,82))
  call check_last_GHH_G(l_switch,G0(:,:,:,82),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,42), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,82),Q(:,60),wf(:,4),G2tensor(:,43), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,46),G0(:,:,:,83))
  call check_last_UV_W(l_switch,G0(:,:,:,83),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,121))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,46),wf(:,-5),G0(:,:,:,84))
  call check_last_UV_W(l_switch,G0(:,:,:,84),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,122))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,46),G0(:,:,:,85))
  call check_last_UV_W(l_switch,G0(:,:,:,85),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,123))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,48),G0(:,:,:,86))
  call check_last_GHH_G(l_switch,G0(:,:,:,86),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,44), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,86),Q(:,60),wf(:,4),G2tensor(:,45), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,48),wf(:,-4),G0(:,:,:,87))
  call check_last_GHH_G(l_switch,G0(:,:,:,87),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,46), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,87),Q(:,60),wf(:,4),G2tensor(:,47), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,48),G0(:,:,:,88))
  call check_last_GHH_G(l_switch,G0(:,:,:,88),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,48), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,88),Q(:,60),wf(:,4),G2tensor(:,49), Q(:,63))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,20),Q(:,35),G1(:,:,:,18))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,-4),wf(:,24),G1tensor(:,124))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,24),wf(:,-4),G1tensor(:,125))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,18),wf(:,-4),wf(:,24),G1tensor(:,126))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,-3),wf(:,26),G1tensor(:,127))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,26),wf(:,-3),G1tensor(:,128))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,18),wf(:,-3),wf(:,26),G1tensor(:,129))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,-2),wf(:,30),G1tensor(:,130))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,30),wf(:,-2),G1tensor(:,131))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,18),wf(:,-2),wf(:,30),G1tensor(:,132))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,35),wf(:,21),Q(:,28),G2tensor(:,50))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,35),wf(:,22),Q(:,28),G2tensor(:,51))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,35),wf(:,23),Q(:,28),G2tensor(:,52))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,35),wf(:,47),Q(:,28),G2tensor(:,53))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,35),wf(:,50),Q(:,28),G2tensor(:,54))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,35),wf(:,52),Q(:,28),G2tensor(:,55))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,26),wf(:,32),G0(:,:,:,89))
  call check_last_GHH_G(l_switch,G0(:,:,:,89),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,56), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,89),Q(:,60),wf(:,4),G2tensor(:,57), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,32),wf(:,26),G0(:,:,:,90))
  call check_last_GHH_G(l_switch,G0(:,:,:,90),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,58), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,90),Q(:,60),wf(:,4),G2tensor(:,59), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,26),wf(:,32),G0(:,:,:,91))
  call check_last_GHH_G(l_switch,G0(:,:,:,91),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,60), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,91),Q(:,60),wf(:,4),G2tensor(:,61), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,26),G0(:,:,:,92))
  call check_last_UV_W(l_switch,G0(:,:,:,92),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,133))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,26),wf(:,20),G0(:,:,:,93))
  call check_last_UV_W(l_switch,G0(:,:,:,93),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,134))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,20),wf(:,26),G0(:,:,:,94))
  call check_last_UV_W(l_switch,G0(:,:,:,94),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,135))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,50),G0(:,:,:,95))
  call check_last_GHH_G(l_switch,G0(:,:,:,95),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,62), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,95),Q(:,60),wf(:,4),G2tensor(:,63), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,50),wf(:,-5),G0(:,:,:,96))
  call check_last_GHH_G(l_switch,G0(:,:,:,96),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,64), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,96),Q(:,60),wf(:,4),G2tensor(:,65), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,50),G0(:,:,:,97))
  call check_last_GHH_G(l_switch,G0(:,:,:,97),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,66), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,97),Q(:,60),wf(:,4),G2tensor(:,67), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,49),G0(:,:,:,98))
  call check_last_UV_W(l_switch,G0(:,:,:,98),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,136))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,49),wf(:,-5),G0(:,:,:,99))
  call check_last_UV_W(l_switch,G0(:,:,:,99),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,137))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,49),G0(:,:,:,100))
  call check_last_UV_W(l_switch,G0(:,:,:,100),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,138))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,28),wf(:,30),G0(:,:,:,101))
  call check_last_GHH_G(l_switch,G0(:,:,:,101),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,68), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,101),Q(:,60),wf(:,4),G2tensor(:,69), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,30),wf(:,28),G0(:,:,:,102))
  call check_last_GHH_G(l_switch,G0(:,:,:,102),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,70), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,102),Q(:,60),wf(:,4),G2tensor(:,71), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,28),wf(:,30),G0(:,:,:,103))
  call check_last_GHH_G(l_switch,G0(:,:,:,103),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,72), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,103),Q(:,60),wf(:,4),G2tensor(:,73), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,30),G0(:,:,:,104))
  call check_last_UV_W(l_switch,G0(:,:,:,104),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,139))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,30),wf(:,20),G0(:,:,:,105))
  call check_last_UV_W(l_switch,G0(:,:,:,105),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,140))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,20),wf(:,30),G0(:,:,:,106))
  call check_last_UV_W(l_switch,G0(:,:,:,106),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,141))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,52),G0(:,:,:,107))
  call check_last_GHH_G(l_switch,G0(:,:,:,107),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,74), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,107),Q(:,60),wf(:,4),G2tensor(:,75), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,52),wf(:,-5),G0(:,:,:,108))
  call check_last_GHH_G(l_switch,G0(:,:,:,108),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,76), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,108),Q(:,60),wf(:,4),G2tensor(:,77), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,52),G0(:,:,:,109))
  call check_last_GHH_G(l_switch,G0(:,:,:,109),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,78), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,109),Q(:,60),wf(:,4),G2tensor(:,79), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,455),G0(:,:,:,110))
  call check_last_UV_W(l_switch,G0(:,:,:,110),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,142))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,455),wf(:,-5),G0(:,:,:,111))
  call check_last_UV_W(l_switch,G0(:,:,:,111),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,143))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,455),G0(:,:,:,112))
  call check_last_UV_W(l_switch,G0(:,:,:,112),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,144))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,16),wf(:,28),G0(:,:,:,113))
  call check_last_UV_W(l_switch,G0(:,:,:,113),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,145))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,28),wf(:,16),G0(:,:,:,114))
  call check_last_UV_W(l_switch,G0(:,:,:,114),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,146))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,16),wf(:,28),G0(:,:,:,115))
  call check_last_UV_W(l_switch,G0(:,:,:,115),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,147))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,16),wf(:,32),G0(:,:,:,116))
  call check_last_UV_W(l_switch,G0(:,:,:,116),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,148))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,32),wf(:,16),G0(:,:,:,117))
  call check_last_UV_W(l_switch,G0(:,:,:,117),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,149))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,16),wf(:,32),G0(:,:,:,118))
  call check_last_UV_W(l_switch,G0(:,:,:,118),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,150))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,458),G0(:,:,:,119))
  call check_last_UV_W(l_switch,G0(:,:,:,119),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,151))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,458),wf(:,-5),G0(:,:,:,120))
  call check_last_UV_W(l_switch,G0(:,:,:,120),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,152))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,458),G0(:,:,:,121))
  call check_last_UV_W(l_switch,G0(:,:,:,121),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,153))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,457),G0(:,:,:,122))
  call check_last_UV_W(l_switch,G0(:,:,:,122),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,154))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,457),wf(:,-5),G0(:,:,:,123))
  call check_last_UV_W(l_switch,G0(:,:,:,123),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,155))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,457),G0(:,:,:,124))
  call check_last_UV_W(l_switch,G0(:,:,:,124),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,156))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,53),G0(:,:,:,125))
  call check_last_GHH_G(l_switch,G0(:,:,:,125),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,80), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,125),Q(:,60),wf(:,4),G2tensor(:,81), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,53),wf(:,-4),G0(:,:,:,126))
  call check_last_GHH_G(l_switch,G0(:,:,:,126),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,82), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,126),Q(:,60),wf(:,4),G2tensor(:,83), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,53),G0(:,:,:,127))
  call check_last_GHH_G(l_switch,G0(:,:,:,127),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,84), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,127),Q(:,60),wf(:,4),G2tensor(:,85), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,51),G0(:,:,:,128))
  call check_last_UV_W(l_switch,G0(:,:,:,128),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,157))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,51),wf(:,-4),G0(:,:,:,129))
  call check_last_UV_W(l_switch,G0(:,:,:,129),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,158))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,51),G0(:,:,:,130))
  call check_last_UV_W(l_switch,G0(:,:,:,130),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,159))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,54),G0(:,:,:,131))
  call check_last_GHH_G(l_switch,G0(:,:,:,131),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,86), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,131),Q(:,60),wf(:,4),G2tensor(:,87), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,54),wf(:,-4),G0(:,:,:,132))
  call check_last_GHH_G(l_switch,G0(:,:,:,132),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,88), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,132),Q(:,60),wf(:,4),G2tensor(:,89), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,54),G0(:,:,:,133))
  call check_last_GHH_G(l_switch,G0(:,:,:,133),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,90), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,133),Q(:,60),wf(:,4),G2tensor(:,91), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,453),G0(:,:,:,134))
  call check_last_UV_W(l_switch,G0(:,:,:,134),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,160))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,453),wf(:,-4),G0(:,:,:,135))
  call check_last_UV_W(l_switch,G0(:,:,:,135),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,161))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,453),G0(:,:,:,136))
  call check_last_UV_W(l_switch,G0(:,:,:,136),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,162))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,456),G0(:,:,:,137))
  call check_last_UV_W(l_switch,G0(:,:,:,137),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,163))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,456),wf(:,-4),G0(:,:,:,138))
  call check_last_UV_W(l_switch,G0(:,:,:,138),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,164))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,456),G0(:,:,:,139))
  call check_last_UV_W(l_switch,G0(:,:,:,139),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,165))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,454),G0(:,:,:,140))
  call check_last_UV_W(l_switch,G0(:,:,:,140),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,166))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,454),wf(:,-4),G0(:,:,:,141))
  call check_last_UV_W(l_switch,G0(:,:,:,141),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,167))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,454),G0(:,:,:,142))
  call check_last_UV_W(l_switch,G0(:,:,:,142),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,168))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,12),wf(:,28),G0(:,:,:,143))
  call check_last_UV_W(l_switch,G0(:,:,:,143),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,169))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,28),wf(:,12),G0(:,:,:,144))
  call check_last_UV_W(l_switch,G0(:,:,:,144),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,170))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,12),wf(:,28),G0(:,:,:,145))
  call check_last_UV_W(l_switch,G0(:,:,:,145),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,171))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,12),wf(:,34),G0(:,:,:,146))
  call check_last_UV_W(l_switch,G0(:,:,:,146),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,172))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,34),wf(:,12),G0(:,:,:,147))
  call check_last_UV_W(l_switch,G0(:,:,:,147),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,173))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,12),wf(:,34),G0(:,:,:,148))
  call check_last_UV_W(l_switch,G0(:,:,:,148),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,174))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,461),G0(:,:,:,149))
  call check_last_UV_W(l_switch,G0(:,:,:,149),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,175))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,461),wf(:,-5),G0(:,:,:,150))
  call check_last_UV_W(l_switch,G0(:,:,:,150),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,176))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,461),G0(:,:,:,151))
  call check_last_UV_W(l_switch,G0(:,:,:,151),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,177))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,460),G0(:,:,:,152))
  call check_last_UV_W(l_switch,G0(:,:,:,152),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,178))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,460),wf(:,-5),G0(:,:,:,153))
  call check_last_UV_W(l_switch,G0(:,:,:,153),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,179))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,460),G0(:,:,:,154))
  call check_last_UV_W(l_switch,G0(:,:,:,154),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,180))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,459),G0(:,:,:,155))
  call check_last_UV_W(l_switch,G0(:,:,:,155),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,181))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,459),wf(:,-4),G0(:,:,:,156))
  call check_last_UV_W(l_switch,G0(:,:,:,156),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,182))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,459),G0(:,:,:,157))
  call check_last_UV_W(l_switch,G0(:,:,:,157),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,183))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,55),G0(:,:,:,158))
  call check_last_GHH_G(l_switch,G0(:,:,:,158),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,92), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,158),Q(:,60),wf(:,4),G2tensor(:,93), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,55),wf(:,-3),G0(:,:,:,159))
  call check_last_GHH_G(l_switch,G0(:,:,:,159),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,94), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,159),Q(:,60),wf(:,4),G2tensor(:,95), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,55),G0(:,:,:,160))
  call check_last_GHH_G(l_switch,G0(:,:,:,160),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,96), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,160),Q(:,60),wf(:,4),G2tensor(:,97), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,56),G0(:,:,:,161))
  call check_last_GHH_G(l_switch,G0(:,:,:,161),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,98), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,161),Q(:,60),wf(:,4),G2tensor(:,99), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,56),wf(:,-3),G0(:,:,:,162))
  call check_last_GHH_G(l_switch,G0(:,:,:,162),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,100), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,162),Q(:,60),wf(:,4),G2tensor(:,101), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,56),G0(:,:,:,163))
  call check_last_GHH_G(l_switch,G0(:,:,:,163),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,102), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,163),Q(:,60),wf(:,4),G2tensor(:,103), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,51),G0(:,:,:,164))
  call check_last_UV_W(l_switch,G0(:,:,:,164),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,184))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,51),wf(:,-3),G0(:,:,:,165))
  call check_last_UV_W(l_switch,G0(:,:,:,165),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,185))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,51),G0(:,:,:,166))
  call check_last_UV_W(l_switch,G0(:,:,:,166),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,186))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,57),G0(:,:,:,167))
  call check_last_GHH_G(l_switch,G0(:,:,:,167),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,104), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,167),Q(:,60),wf(:,4),G2tensor(:,105), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,57),wf(:,-3),G0(:,:,:,168))
  call check_last_GHH_G(l_switch,G0(:,:,:,168),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,106), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,168),Q(:,60),wf(:,4),G2tensor(:,107), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,57),G0(:,:,:,169))
  call check_last_GHH_G(l_switch,G0(:,:,:,169),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,108), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,169),Q(:,60),wf(:,4),G2tensor(:,109), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,450),G0(:,:,:,170))
  call check_last_UV_W(l_switch,G0(:,:,:,170),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,187))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,450),wf(:,-3),G0(:,:,:,171))
  call check_last_UV_W(l_switch,G0(:,:,:,171),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,188))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,450),G0(:,:,:,172))
  call check_last_UV_W(l_switch,G0(:,:,:,172),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,189))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,456),G0(:,:,:,173))
  call check_last_UV_W(l_switch,G0(:,:,:,173),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,190))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,456),wf(:,-3),G0(:,:,:,174))
  call check_last_UV_W(l_switch,G0(:,:,:,174),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,191))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,456),G0(:,:,:,175))
  call check_last_UV_W(l_switch,G0(:,:,:,175),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,192))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,451),G0(:,:,:,176))
  call check_last_UV_W(l_switch,G0(:,:,:,176),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,193))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,451),wf(:,-3),G0(:,:,:,177))
  call check_last_UV_W(l_switch,G0(:,:,:,177),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,194))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,451),G0(:,:,:,178))
  call check_last_UV_W(l_switch,G0(:,:,:,178),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,195))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,452),G0(:,:,:,179))
  call check_last_UV_W(l_switch,G0(:,:,:,179),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,196))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,452),wf(:,-3),G0(:,:,:,180))
  call check_last_UV_W(l_switch,G0(:,:,:,180),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,197))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,452),G0(:,:,:,181))
  call check_last_UV_W(l_switch,G0(:,:,:,181),Q(:,59),wf(:,-2),Q(:,4),G1tensor(:,198))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,51),Q(:,39),G1(:,:,:,19))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,19),wf(:,-4),wf(:,-3),G1tensor(:,199))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,19),wf(:,-3),wf(:,-4),G1tensor(:,200))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,19),wf(:,-4),wf(:,-3),G1tensor(:,201))
  call check_last_UV_W(l_switch,G1(:,:,:,19),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,110))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,456),Q(:,39),G1(:,:,:,20))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,-4),wf(:,-3),G1tensor(:,202))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,-3),wf(:,-4),G1tensor(:,203))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,20),wf(:,-4),wf(:,-3),G1tensor(:,204))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,111))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,8),wf(:,32),G0(:,:,:,182))
  call check_last_UV_W(l_switch,G0(:,:,:,182),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,205))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,32),wf(:,8),G0(:,:,:,183))
  call check_last_UV_W(l_switch,G0(:,:,:,183),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,206))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,8),wf(:,32),G0(:,:,:,184))
  call check_last_UV_W(l_switch,G0(:,:,:,184),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,207))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,8),wf(:,34),G0(:,:,:,185))
  call check_last_UV_W(l_switch,G0(:,:,:,185),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,208))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,34),wf(:,8),G0(:,:,:,186))
  call check_last_UV_W(l_switch,G0(:,:,:,186),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,209))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,8),wf(:,34),G0(:,:,:,187))
  call check_last_UV_W(l_switch,G0(:,:,:,187),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,210))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,464),G0(:,:,:,188))
  call check_last_UV_W(l_switch,G0(:,:,:,188),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,211))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,464),wf(:,-5),G0(:,:,:,189))
  call check_last_UV_W(l_switch,G0(:,:,:,189),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,212))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,464),G0(:,:,:,190))
  call check_last_UV_W(l_switch,G0(:,:,:,190),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,213))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,463),G0(:,:,:,191))
  call check_last_UV_W(l_switch,G0(:,:,:,191),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,214))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,463),wf(:,-5),G0(:,:,:,192))
  call check_last_UV_W(l_switch,G0(:,:,:,192),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,215))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,463),G0(:,:,:,193))
  call check_last_UV_W(l_switch,G0(:,:,:,193),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,216))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,462),G0(:,:,:,194))
  call check_last_UV_W(l_switch,G0(:,:,:,194),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,217))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,462),wf(:,-4),G0(:,:,:,195))
  call check_last_UV_W(l_switch,G0(:,:,:,195),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,218))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,462),G0(:,:,:,196))
  call check_last_UV_W(l_switch,G0(:,:,:,196),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,219))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,462),G0(:,:,:,197))
  call check_last_UV_W(l_switch,G0(:,:,:,197),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,220))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,462),wf(:,-3),G0(:,:,:,198))
  call check_last_UV_W(l_switch,G0(:,:,:,198),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,221))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,462),G0(:,:,:,199))
  call check_last_UV_W(l_switch,G0(:,:,:,199),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,222))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,462),Q(:,39),G1(:,:,:,21))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,-4),wf(:,-3),G1tensor(:,223))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,-3),wf(:,-4),G1tensor(:,224))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,21),wf(:,-4),wf(:,-3),G1tensor(:,225))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,39),wf(:,30),Q(:,24),G2tensor(:,112))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,200))
  call loop_Q_A(G0(:,:,:,200),Q(:,56),ZERO,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,8),G1(:,:,:,23))
  call check_last_Q_A(l_switch,G1(:,:,:,23),Q(:,63),ZERO,G2tensor(:,113))
  call loop_QV_A(G1(:,:,:,22),wf(:,39),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),ZERO,G2tensor(:,114))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,201))
  call loop_Q_A(G0(:,:,:,201),Q(:,56),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,8),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,63),ZERO,G2tensor(:,115))
  call loop_QV_A(G1(:,:,:,25),wf(:,39),G1(:,:,:,27))
  call check_last_Q_A(l_switch,G1(:,:,:,27),Q(:,63),ZERO,G2tensor(:,116))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,202))
  call loop_Q_A(G0(:,:,:,202),Q(:,56),ZERO,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,8),G1(:,:,:,29))
  call check_last_Q_A(l_switch,G1(:,:,:,29),Q(:,63),ZERO,G2tensor(:,117))
  call loop_QV_A(G1(:,:,:,28),wf(:,39),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,63),ZERO,G2tensor(:,118))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,9),Q(:,56),G1(:,:,:,31))
  call check_last_CV_D(l_switch,G1(:,:,:,31),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,119))
  call check_last_CV_D(l_switch,G1(:,:,:,31),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,120))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,56),G1(:,:,:,32))
  call check_last_CV_D(l_switch,G1(:,:,:,32),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,121))
  call check_last_CV_D(l_switch,G1(:,:,:,32),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,122))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,56),G1(:,:,:,33))
  call check_last_CV_D(l_switch,G1(:,:,:,33),Q(:,56),wf(:,8),Q(:,7),G2tensor(:,123))
  call check_last_CV_D(l_switch,G1(:,:,:,33),Q(:,56),wf(:,39),Q(:,7),G2tensor(:,124))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,58),G0(:,:,:,203))
  call check_last_GHH_G(l_switch,G0(:,:,:,203),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,125), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,203),Q(:,60),wf(:,4),G2tensor(:,126), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,58),wf(:,-2),G0(:,:,:,204))
  call check_last_GHH_G(l_switch,G0(:,:,:,204),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,127), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,204),Q(:,60),wf(:,4),G2tensor(:,128), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,58),G0(:,:,:,205))
  call check_last_GHH_G(l_switch,G0(:,:,:,205),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,129), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,205),Q(:,60),wf(:,4),G2tensor(:,130), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,59),G0(:,:,:,206))
  call check_last_GHH_G(l_switch,G0(:,:,:,206),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,131), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,206),Q(:,60),wf(:,4),G2tensor(:,132), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,59),wf(:,-2),G0(:,:,:,207))
  call check_last_GHH_G(l_switch,G0(:,:,:,207),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,133), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,207),Q(:,60),wf(:,4),G2tensor(:,134), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,59),G0(:,:,:,208))
  call check_last_GHH_G(l_switch,G0(:,:,:,208),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,135), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,208),Q(:,60),wf(:,4),G2tensor(:,136), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,453),G0(:,:,:,209))
  call check_last_UV_W(l_switch,G0(:,:,:,209),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,226))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,453),wf(:,-2),G0(:,:,:,210))
  call check_last_UV_W(l_switch,G0(:,:,:,210),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,227))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,453),G0(:,:,:,211))
  call check_last_UV_W(l_switch,G0(:,:,:,211),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,228))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,60),G0(:,:,:,212))
  call check_last_GHH_G(l_switch,G0(:,:,:,212),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,137), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,212),Q(:,60),wf(:,4),G2tensor(:,138), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,60),wf(:,-2),G0(:,:,:,213))
  call check_last_GHH_G(l_switch,G0(:,:,:,213),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,139), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,213),Q(:,60),wf(:,4),G2tensor(:,140), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,60),G0(:,:,:,214))
  call check_last_GHH_G(l_switch,G0(:,:,:,214),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,141), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,214),Q(:,60),wf(:,4),G2tensor(:,142), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,450),G0(:,:,:,215))
  call check_last_UV_W(l_switch,G0(:,:,:,215),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,229))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,450),wf(:,-2),G0(:,:,:,216))
  call check_last_UV_W(l_switch,G0(:,:,:,216),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,230))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,450),G0(:,:,:,217))
  call check_last_UV_W(l_switch,G0(:,:,:,217),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,231))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,454),G0(:,:,:,218))
  call check_last_UV_W(l_switch,G0(:,:,:,218),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,232))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,454),wf(:,-2),G0(:,:,:,219))
  call check_last_UV_W(l_switch,G0(:,:,:,219),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,233))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,454),G0(:,:,:,220))
  call check_last_UV_W(l_switch,G0(:,:,:,220),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,234))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,451),G0(:,:,:,221))
  call check_last_UV_W(l_switch,G0(:,:,:,221),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,235))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,451),wf(:,-2),G0(:,:,:,222))
  call check_last_UV_W(l_switch,G0(:,:,:,222),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,236))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,451),G0(:,:,:,223))
  call check_last_UV_W(l_switch,G0(:,:,:,223),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,237))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,452),G0(:,:,:,224))
  call check_last_UV_W(l_switch,G0(:,:,:,224),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,238))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,452),wf(:,-2),G0(:,:,:,225))
  call check_last_UV_W(l_switch,G0(:,:,:,225),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,239))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,452),G0(:,:,:,226))
  call check_last_UV_W(l_switch,G0(:,:,:,226),Q(:,55),wf(:,-3),Q(:,8),G1tensor(:,240))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(11)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(11)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(11)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(12)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(12)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(12)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(12)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(12)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(12)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(13)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(13)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(13)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(17)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(17)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(17)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(14)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(14)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(14)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(18)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(18)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(18)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(13)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(13)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(13)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(14)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(14)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(14)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(16)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(16)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(16)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(52)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(197)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(197)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(197)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(195)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(195)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(195)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(189)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(189)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(189)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(14)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(14)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(14)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(21)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(21)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(21)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(17)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(17)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(17)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(18)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(18)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(18)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(20)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(20)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(20)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,10)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,11)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,13)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,15)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,16)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,17)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(47)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(208)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(208)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(208)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(206)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(206)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(206)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(189)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(189)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(189)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(21)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,79)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(21)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(21)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,81)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(23)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(23)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(23)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,19)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,20)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,21)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,22)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,23)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,24)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,25)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,26)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(42)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,27)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(211)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,85)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(211)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,86)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(211)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(25)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(25)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(25)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,28)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,29)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,30)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,31)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,32)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,33)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,34)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,35)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(191)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,36)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(189)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(189)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(189)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(206)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(206)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,95)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(206)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(195)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(195)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(195)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,37)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,38)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,39)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,40)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,41)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,42)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,43)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,44)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(191)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,45)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(195)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(195)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(195)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,105)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,46)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,49)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,52)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,47)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,50)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,53)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,48)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,51)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(191)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,54)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(206)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,109)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(206)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,110)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(206)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,111)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(18)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,112)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(18)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,113)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(18)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,114)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(21)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,115)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(21)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,116)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(21)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,117)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(21)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(21)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(21)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(26)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(26)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,34)
  Gcoeff = (0) * den(26)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(27)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,118)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(27)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,119)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(27)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,120)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(44)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(44)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,40)
  Gcoeff = (0) * den(44)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(346)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,121)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(346)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,122)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(346)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,123)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(193)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(193)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,46)
  Gcoeff = (0) * den(193)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(27)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,124)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(27)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,125)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(27)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,126)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(29)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(29)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,58)
  Gcoeff = (0) * den(29)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(30)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,133)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(30)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,134)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(30)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,135)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(49)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(49)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,64)
  Gcoeff = (0) * den(49)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(356)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,136)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(356)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,137)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(356)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,138)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(31)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(31)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,70)
  Gcoeff = (0) * den(31)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(32)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,139)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(32)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,140)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(32)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,141)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(54)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(54)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,76)
  Gcoeff = (0) * den(54)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(361)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,142)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(361)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,143)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(361)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,144)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(33)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,145)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(33)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,146)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(33)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,147)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(34)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,148)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(34)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,149)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(34)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,150)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(371)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,151)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(371)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,152)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(371)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,153)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(368)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,154)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(368)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,155)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(368)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,156)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(57)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(57)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,82)
  Gcoeff = (0) * den(57)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(363)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,157)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(363)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,158)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(363)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,159)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(60)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(60)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,88)
  Gcoeff = (0) * den(60)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(354)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,160)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(354)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,161)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(354)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,162)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(365)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,163)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(365)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,164)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(365)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,165)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(358)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,166)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(358)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,167)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(358)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,168)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(36)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,169)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(36)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,170)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(36)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,171)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(37)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,172)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(37)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,173)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(37)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,174)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(380)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,175)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(380)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,176)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(380)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,177)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(377)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,178)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(377)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,179)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(377)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,180)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(374)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,181)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(374)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,182)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(374)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,183)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(201)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(201)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,94)
  Gcoeff = (0) * den(201)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(30)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,127)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(30)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,128)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(30)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,129)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(204)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(204)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,100)
  Gcoeff = (0) * den(204)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(363)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,184)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(363)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,185)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(363)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,186)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(63)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(63)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,106)
  Gcoeff = (0) * den(63)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(344)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,187)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(344)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,188)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(344)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,189)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(365)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,190)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(365)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,191)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(365)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,192)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(348)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,193)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(348)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,194)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(348)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,195)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(351)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,196)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(351)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,197)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(351)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,198)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(363)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,199)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(363)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,200)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(363)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,201)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(365)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,202)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(365)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,203)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(365)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,204)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(39)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,205)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(39)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,206)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(39)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,207)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(40)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,208)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(40)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,209)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(40)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,210)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(389)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,211)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(389)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,212)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(389)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,213)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(386)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,214)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(386)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,215)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(386)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,216)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(383)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,217)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(383)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,218)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(383)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,219)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(40)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(40)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(40)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(383)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,220)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(383)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,221)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(383)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,222)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(383)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,223)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(383)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,224)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(383)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,225)
  Gcoeff = (c(15)*(-M(4)+M(6)+M(8)-M(9))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(15)*(M(4)-M(5)-M(7)+M(9))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(15)*(M(5)-M(6)+M(7)-M(8))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(16)*(-M(4)+M(6)+M(8)-M(9))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(16)*(M(4)-M(5)-M(7)+M(9))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(16)*(M(5)-M(6)+M(7)-M(8))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(6)*(-M(4)+M(6)+M(8)-M(9))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(6)*(M(4)-M(5)-M(7)+M(9))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(149)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(216)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,125)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(216)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,127)
  Gcoeff = (0) * den(216)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,130)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,131)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,132)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(219)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,131)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(219)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,133)
  Gcoeff = (0) * den(219)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,135)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(354)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,226)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(354)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,227)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(354)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,228)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(222)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(222)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,139)
  Gcoeff = (0) * den(222)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,141)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(344)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,229)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(344)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,230)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(344)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,231)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(358)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,232)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(358)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,233)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(358)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,234)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(348)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,235)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(348)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,236)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(348)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,237)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(351)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,238)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(351)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,239)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(351)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,240)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(37)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(37)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(37)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(152)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(26)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(188)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(517)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(517)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,35)
  Gcoeff = (0) * den(517)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(518)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(41)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(43)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(43)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(43)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,41)
  Gcoeff = (0) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(45)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(192)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(192)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(192)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,90)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(194)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(194)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,47)
  Gcoeff = (0) * den(194)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(190)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(519)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(519)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,59)
  Gcoeff = (0) * den(519)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(520)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(48)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(48)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(48)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(50)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(50)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,65)
  Gcoeff = (0) * den(50)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(50)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(521)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(521)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,71)
  Gcoeff = (0) * den(521)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(51)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(53)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(53)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(53)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(55)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(55)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,77)
  Gcoeff = (0) * den(55)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(55)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(58)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(58)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,83)
  Gcoeff = (0) * den(58)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(61)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(61)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,89)
  Gcoeff = (0) * den(61)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(200)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,100)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(200)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(200)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(202)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(202)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,95)
  Gcoeff = (0) * den(202)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(196)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(205)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(205)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,101)
  Gcoeff = (0) * den(205)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(62)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(62)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(62)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(64)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(64)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,107)
  Gcoeff = (0) * den(64)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(19)*(M(4)-M(6)-M(8)+M(9))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(19)*(-M(4)+M(5)+M(7)-M(9))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(19)*(-M(5)+M(6)-M(7)+M(8))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(20)*(M(4)-M(6)-M(8)+M(9))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(20)*(-M(4)+M(5)+M(7)-M(9))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(20)*(-M(5)+M(6)-M(7)+M(8))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(12)*(M(4)-M(6)-M(8)+M(9))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,120)
  Gcoeff = (c(12)*(-M(4)+M(5)+M(7)-M(9))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,122)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(199)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(215)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,106)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(215)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,107)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(215)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,108)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(217)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(217)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,128)
  Gcoeff = (0) * den(217)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(207)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(220)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(220)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,134)
  Gcoeff = (0) * den(220)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(221)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(221)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(221)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(223)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,138)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(223)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,140)
  Gcoeff = (0) * den(223)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(212)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(347)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(350)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(360)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(364)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,110)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(367)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(366)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(381)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(384)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(390)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(463)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(533)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(534)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,10)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_6

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_6_heftpphhjj_hhgggg_1_/**/REALKIND
