
module ol_vamp_4_heftpphhjj_hhgggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_4(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_hhgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_hhgggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_hhgggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_hhgggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(9)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,76) :: G0
  complex(REALKIND), dimension(4,5,4,41) :: G1
  complex(REALKIND), dimension(4,15,4,49) :: G2
  complex(REALKIND), dimension(4,35,4,12) :: G3
  complex(REALKIND), dimension(1,261) :: G0tensor
  complex(REALKIND), dimension(5,123) :: G1tensor
  complex(REALKIND), dimension(15,46) :: G2tensor
  complex(REALKIND), dimension(35,27) :: G3tensor
  complex(REALKIND), dimension(70,8) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,487),Q(:,27),G1(:,:,:,1))
  call loop_CV_D(G1(:,:,:,1),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,1))
  call check_last_CV_D(l_switch,G2(:,:,:,1),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,1))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,487),G1(:,:,:,2))
  call loop_DV_C(G1(:,:,:,2),Q(:,27),wf(:,-5),G2(:,:,:,2))
  call check_last_DV_C(l_switch,G2(:,:,:,2),Q(:,59),wf(:,-2),G3tensor(:,2))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,487),Q(:,27),G1(:,:,:,3))
  call loop_UV_W(G1(:,:,:,3),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,3))
  call check_last_UV_W(l_switch,G2(:,:,:,3),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,42),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,11),ZERO,G1(:,:,:,4))
  call loop_AV_Q(G1(:,:,:,4),wf(:,34),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,59),ZERO,G2(:,:,:,4))
  call loop_AV_Q(G2(:,:,:,4),wf(:,-2),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),ZERO,G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-5),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,43),ZERO,G2(:,:,:,6))
  call loop_AV_Q(G2(:,:,:,6),wf(:,-4),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,59),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,-2),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),ZERO,G4tensor(:,1))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-4),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,27),ZERO,G2(:,:,:,8))
  call loop_AV_Q(G2(:,:,:,8),wf(:,-5),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,59),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-2),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),ZERO,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,11),ZERO,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,34),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,59),ZERO,G2(:,:,:,10))
  call loop_QV_A(G2(:,:,:,10),wf(:,-2),G2(:,:,:,11))
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,8),wf(:,-5),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,43),ZERO,G2(:,:,:,12))
  call loop_QV_A(G2(:,:,:,12),wf(:,-4),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,59),ZERO,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,8),wf(:,-4),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,27),ZERO,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,-5),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,59),ZERO,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,-2),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),ZERO,G4tensor(:,4))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,42),G1(:,:,:,12))
  call loop_DV_C(G1(:,:,:,12),Q(:,11),wf(:,34),G2(:,:,:,16))
  call check_last_DV_C(l_switch,G2(:,:,:,16),Q(:,59),wf(:,-2),G3tensor(:,6))
  call loop_DV_C(G1(:,:,:,12),Q(:,11),wf(:,-5),G2(:,:,:,17))
  call loop_DV_C(G2(:,:,:,17),Q(:,43),wf(:,-4),G3(:,:,:,9))
  call check_last_DV_C(l_switch,G3(:,:,:,9),Q(:,59),wf(:,-2),G4tensor(:,5))
  call loop_DV_C(G1(:,:,:,12),Q(:,11),wf(:,-4),G2(:,:,:,18))
  call loop_DV_C(G2(:,:,:,18),Q(:,27),wf(:,-5),G3(:,:,:,10))
  call check_last_DV_C(l_switch,G3(:,:,:,10),Q(:,59),wf(:,-2),G4tensor(:,6))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,11),G1(:,:,:,13))
  call loop_CV_D(G1(:,:,:,13),Q(:,11),wf(:,34),Q(:,48),G2(:,:,:,19))
  call check_last_CV_D(l_switch,G2(:,:,:,19),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,7))
  call loop_CV_D(G1(:,:,:,13),Q(:,11),wf(:,-5),Q(:,32),G2(:,:,:,20))
  call loop_CV_D(G2(:,:,:,20),Q(:,43),wf(:,-4),Q(:,16),G3(:,:,:,11))
  call check_last_CV_D(l_switch,G3(:,:,:,11),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,7))
  call loop_CV_D(G1(:,:,:,13),Q(:,11),wf(:,-4),Q(:,16),G2(:,:,:,21))
  call loop_CV_D(G2(:,:,:,21),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,12))
  call check_last_CV_D(l_switch,G3(:,:,:,12),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,502),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,23),ZERO,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,-5),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,55),ZERO,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,-3),G2(:,:,:,23))
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,63),ZERO,G3tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,502),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,23),ZERO,G1(:,:,:,16))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-5),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,55),ZERO,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-3),G2(:,:,:,25))
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,63),ZERO,G3tensor(:,9))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,502),Q(:,23),G1(:,:,:,18))
  call loop_CV_D(G1(:,:,:,18),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,26))
  call check_last_CV_D(l_switch,G2(:,:,:,26),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,10))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,502),G1(:,:,:,19))
  call loop_DV_C(G1(:,:,:,19),Q(:,23),wf(:,-5),G2(:,:,:,27))
  call check_last_DV_C(l_switch,G2(:,:,:,27),Q(:,55),wf(:,-3),G3tensor(:,11))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,502),Q(:,23),G1(:,:,:,20))
  call loop_UV_W(G1(:,:,:,20),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,28))
  call check_last_UV_W(l_switch,G2(:,:,:,28),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,505),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,27),ZERO,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,59),ZERO,G2(:,:,:,29))
  call loop_QV_A(G2(:,:,:,29),wf(:,-2),G2(:,:,:,30))
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,63),ZERO,G3tensor(:,13))
  call loop_AV_Q(G0(:,:,:,1),wf(:,505),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,27),ZERO,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-5),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,59),ZERO,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),ZERO,G3tensor(:,14))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,505),Q(:,27),G1(:,:,:,25))
  call loop_CV_D(G1(:,:,:,25),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,33))
  call check_last_CV_D(l_switch,G2(:,:,:,33),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,15))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,505),G1(:,:,:,26))
  call loop_DV_C(G1(:,:,:,26),Q(:,27),wf(:,-5),G2(:,:,:,34))
  call check_last_DV_C(l_switch,G2(:,:,:,34),Q(:,59),wf(:,-2),G3tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,505),Q(:,27),G1(:,:,:,27))
  call loop_UV_W(G1(:,:,:,27),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,35))
  call check_last_UV_W(l_switch,G2(:,:,:,35),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,507),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,23),ZERO,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,-5),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,55),ZERO,G2(:,:,:,36))
  call loop_QV_A(G2(:,:,:,36),wf(:,-3),G2(:,:,:,37))
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,63),ZERO,G3tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,507),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,23),ZERO,G1(:,:,:,30))
  call loop_AV_Q(G1(:,:,:,30),wf(:,-5),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,55),ZERO,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,-3),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,63),ZERO,G3tensor(:,19))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,507),Q(:,23),G1(:,:,:,32))
  call loop_CV_D(G1(:,:,:,32),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,40))
  call check_last_CV_D(l_switch,G2(:,:,:,40),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,20))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,507),G1(:,:,:,33))
  call loop_DV_C(G1(:,:,:,33),Q(:,23),wf(:,-5),G2(:,:,:,41))
  call check_last_DV_C(l_switch,G2(:,:,:,41),Q(:,55),wf(:,-3),G3tensor(:,21))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,507),Q(:,23),G1(:,:,:,34))
  call loop_UV_W(G1(:,:,:,34),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,42))
  call check_last_UV_W(l_switch,G2(:,:,:,42),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,508),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,27),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,-5),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,59),ZERO,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-2),G2(:,:,:,44))
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),ZERO,G3tensor(:,23))
  call loop_AV_Q(G0(:,:,:,1),wf(:,508),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,27),ZERO,G1(:,:,:,37))
  call loop_AV_Q(G1(:,:,:,37),wf(:,-5),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,59),ZERO,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,-2),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),ZERO,G3tensor(:,24))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,508),Q(:,27),G1(:,:,:,39))
  call loop_CV_D(G1(:,:,:,39),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,47))
  call check_last_CV_D(l_switch,G2(:,:,:,47),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,25))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,508),G1(:,:,:,40))
  call loop_DV_C(G1(:,:,:,40),Q(:,27),wf(:,-5),G2(:,:,:,48))
  call check_last_DV_C(l_switch,G2(:,:,:,48),Q(:,59),wf(:,-2),G3tensor(:,26))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,508),Q(:,27),G1(:,:,:,41))
  call loop_UV_W(G1(:,:,:,41),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,49))
  call check_last_UV_W(l_switch,G2(:,:,:,49),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,27))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-5),wf(:,-4),G0(:,:,:,12))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,-3),wf(:,-2),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,-2),wf(:,-3),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,12),wf(:,-3),wf(:,-2),G0tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,1))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-5),G0(:,:,:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,13),wf(:,-3),wf(:,-2),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,13),wf(:,-2),wf(:,-3),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,13),wf(:,-3),wf(:,-2),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,13),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,2))
  call loop_GHHGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-5),wf(:,-4),G0(:,:,:,14))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,-3),wf(:,-2),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,-2),wf(:,-3),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,14),wf(:,-3),wf(:,-2),G0tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,3))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-5),wf(:,-3),G0(:,:,:,15))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,-4),wf(:,-2),G0tensor(:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,-2),wf(:,-4),G0tensor(:,11))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,15),wf(:,-4),wf(:,-2),G0tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,4))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-5),G0(:,:,:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,-4),wf(:,-2),G0tensor(:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,-2),wf(:,-4),G0tensor(:,14))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,16),wf(:,-4),wf(:,-2),G0tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,5))
  call loop_GHHGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-5),wf(:,-3),G0(:,:,:,17))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,17),wf(:,-4),wf(:,-2),G0tensor(:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,17),wf(:,-2),wf(:,-4),G0tensor(:,17))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,17),wf(:,-4),wf(:,-2),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,6))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-2),G0(:,:,:,18))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,18),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-3),G0tensor(:,19))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,18),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-4),G0tensor(:,20))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,18),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-3),G0tensor(:,21))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,18),wf(:,4),wf(:,-4),wf(:,-3),G0tensor(:,22))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,18),wf(:,4),wf(:,-3),wf(:,-4),G0tensor(:,23))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,18),wf(:,4),wf(:,-4),wf(:,-3),G0tensor(:,24))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-4),wf(:,12),G0tensor(:,25))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,12),wf(:,-4),G0tensor(:,26))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,18),wf(:,-4),wf(:,12),G0tensor(:,27))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-3),wf(:,16),G0tensor(:,28))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,16),wf(:,-3),G0tensor(:,29))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,18),wf(:,-3),wf(:,16),G0tensor(:,30))
  call check_last_GHHG_G(l_switch,G0(:,:,:,18),Q(:,36),wf(:,-1),wf(:,0),wf(:,30),Q(:,24),G1tensor(:,7), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,29),Q(:,27),G1tensor(:,8))
  call check_last_GHG_G(l_switch,G0(:,:,:,18),Q(:,36),wf(:,4),wf(:,30),Q(:,24),G1tensor(:,9), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-4),wf(:,42),G0tensor(:,31))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,42),wf(:,-4),G0tensor(:,32))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,18),wf(:,-4),wf(:,42),G0tensor(:,33))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-3),wf(:,44),G0tensor(:,34))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,44),wf(:,-3),G0tensor(:,35))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,18),wf(:,-3),wf(:,44),G0tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,38),Q(:,27),G1tensor(:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,455),Q(:,27),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,457),Q(:,27),G1tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,460),Q(:,27),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,487),Q(:,27),G1tensor(:,14))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,505),Q(:,27),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,36),wf(:,508),Q(:,27),G1tensor(:,16))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,-5),G0(:,:,:,19))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,19),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-3),G0tensor(:,37))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,19),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-4),G0tensor(:,38))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,19),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-3),G0tensor(:,39))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,19),wf(:,4),wf(:,-4),wf(:,-3),G0tensor(:,40))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,19),wf(:,4),wf(:,-3),wf(:,-4),G0tensor(:,41))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,19),wf(:,4),wf(:,-4),wf(:,-3),G0tensor(:,42))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-4),wf(:,12),G0tensor(:,43))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,12),wf(:,-4),G0tensor(:,44))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,19),wf(:,-4),wf(:,12),G0tensor(:,45))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-3),wf(:,16),G0tensor(:,46))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,16),wf(:,-3),G0tensor(:,47))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,19),wf(:,-3),wf(:,16),G0tensor(:,48))
  call check_last_GHHG_G(l_switch,G0(:,:,:,19),Q(:,36),wf(:,-1),wf(:,0),wf(:,30),Q(:,24),G1tensor(:,17), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,29),Q(:,27),G1tensor(:,18))
  call check_last_GHG_G(l_switch,G0(:,:,:,19),Q(:,36),wf(:,4),wf(:,30),Q(:,24),G1tensor(:,19), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-4),wf(:,42),G0tensor(:,49))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,42),wf(:,-4),G0tensor(:,50))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,19),wf(:,-4),wf(:,42),G0tensor(:,51))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-3),wf(:,44),G0tensor(:,52))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,44),wf(:,-3),G0tensor(:,53))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,19),wf(:,-3),wf(:,44),G0tensor(:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,38),Q(:,27),G1tensor(:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,455),Q(:,27),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,457),Q(:,27),G1tensor(:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,460),Q(:,27),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,487),Q(:,27),G1tensor(:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,505),Q(:,27),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,36),wf(:,508),Q(:,27),G1tensor(:,26))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-2),G0(:,:,:,20))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,20),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-3),G0tensor(:,55))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,20),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-4),G0tensor(:,56))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,20),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-3),G0tensor(:,57))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,20),wf(:,4),wf(:,-4),wf(:,-3),G0tensor(:,58))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,20),wf(:,4),wf(:,-3),wf(:,-4),G0tensor(:,59))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,20),wf(:,4),wf(:,-4),wf(:,-3),G0tensor(:,60))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,-4),wf(:,12),G0tensor(:,61))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,12),wf(:,-4),G0tensor(:,62))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,20),wf(:,-4),wf(:,12),G0tensor(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,-3),wf(:,16),G0tensor(:,64))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,16),wf(:,-3),G0tensor(:,65))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,20),wf(:,-3),wf(:,16),G0tensor(:,66))
  call check_last_GHHG_G(l_switch,G0(:,:,:,20),Q(:,36),wf(:,-1),wf(:,0),wf(:,30),Q(:,24),G1tensor(:,27), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,29),Q(:,27),G1tensor(:,28))
  call check_last_GHG_G(l_switch,G0(:,:,:,20),Q(:,36),wf(:,4),wf(:,30),Q(:,24),G1tensor(:,29), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,-4),wf(:,42),G0tensor(:,67))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,42),wf(:,-4),G0tensor(:,68))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,20),wf(:,-4),wf(:,42),G0tensor(:,69))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,-3),wf(:,44),G0tensor(:,70))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,20),wf(:,44),wf(:,-3),G0tensor(:,71))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,20),wf(:,-3),wf(:,44),G0tensor(:,72))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,38),Q(:,27),G1tensor(:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,455),Q(:,27),G1tensor(:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,457),Q(:,27),G1tensor(:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,460),Q(:,27),G1tensor(:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,487),Q(:,27),G1tensor(:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,505),Q(:,27),G1tensor(:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,36),wf(:,508),Q(:,27),G1tensor(:,36))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-5),wf(:,-2),G0(:,:,:,21))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,21),wf(:,-4),wf(:,-3),G0tensor(:,73))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,21),wf(:,-3),wf(:,-4),G0tensor(:,74))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,21),wf(:,-4),wf(:,-3),G0tensor(:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,37))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-5),G0(:,:,:,22))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,22),wf(:,-4),wf(:,-3),G0tensor(:,76))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,22),wf(:,-3),wf(:,-4),G0tensor(:,77))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,22),wf(:,-4),wf(:,-3),G0tensor(:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,38))
  call loop_GHHGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,0),wf(:,-5),wf(:,-2),G0(:,:,:,23))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,23),wf(:,-4),wf(:,-3),G0tensor(:,79))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,23),wf(:,-3),wf(:,-4),G0tensor(:,80))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,23),wf(:,-4),wf(:,-3),G0tensor(:,81))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,39))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-3),G0(:,:,:,24))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,24),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-2),G0tensor(:,82))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,24),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-4),G0tensor(:,83))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,24),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-2),G0tensor(:,84))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,24),wf(:,4),wf(:,-4),wf(:,-2),G0tensor(:,85))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,24),wf(:,4),wf(:,-2),wf(:,-4),G0tensor(:,86))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,24),wf(:,4),wf(:,-4),wf(:,-2),G0tensor(:,87))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,-4),wf(:,8),G0tensor(:,88))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,8),wf(:,-4),G0tensor(:,89))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,24),wf(:,-4),wf(:,8),G0tensor(:,90))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,-2),wf(:,16),G0tensor(:,91))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,16),wf(:,-2),G0tensor(:,92))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,24),wf(:,-2),wf(:,16),G0tensor(:,93))
  call check_last_GHHG_G(l_switch,G0(:,:,:,24),Q(:,40),wf(:,-1),wf(:,0),wf(:,26),Q(:,20),G1tensor(:,40), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,33),Q(:,23),G1tensor(:,41))
  call check_last_GHG_G(l_switch,G0(:,:,:,24),Q(:,40),wf(:,4),wf(:,26),Q(:,20),G1tensor(:,42), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,-4),wf(:,39),G0tensor(:,94))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,39),wf(:,-4),G0tensor(:,95))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,24),wf(:,-4),wf(:,39),G0tensor(:,96))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,-2),wf(:,44),G0tensor(:,97))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,24),wf(:,44),wf(:,-2),G0tensor(:,98))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,24),wf(:,-2),wf(:,44),G0tensor(:,99))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,41),Q(:,23),G1tensor(:,43))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,49),Q(:,23),G1tensor(:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,458),Q(:,23),G1tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,463),Q(:,23),G1tensor(:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,62),Q(:,23),G1tensor(:,47))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,502),Q(:,23),G1tensor(:,48))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,40),wf(:,507),Q(:,23),G1tensor(:,49))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-5),G0(:,:,:,25))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,25),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-2),G0tensor(:,100))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,25),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-4),G0tensor(:,101))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,25),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-2),G0tensor(:,102))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,25),wf(:,4),wf(:,-4),wf(:,-2),G0tensor(:,103))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,25),wf(:,4),wf(:,-2),wf(:,-4),G0tensor(:,104))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,25),wf(:,4),wf(:,-4),wf(:,-2),G0tensor(:,105))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,-4),wf(:,8),G0tensor(:,106))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,8),wf(:,-4),G0tensor(:,107))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,25),wf(:,-4),wf(:,8),G0tensor(:,108))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,-2),wf(:,16),G0tensor(:,109))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,16),wf(:,-2),G0tensor(:,110))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,25),wf(:,-2),wf(:,16),G0tensor(:,111))
  call check_last_GHHG_G(l_switch,G0(:,:,:,25),Q(:,40),wf(:,-1),wf(:,0),wf(:,26),Q(:,20),G1tensor(:,50), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,33),Q(:,23),G1tensor(:,51))
  call check_last_GHG_G(l_switch,G0(:,:,:,25),Q(:,40),wf(:,4),wf(:,26),Q(:,20),G1tensor(:,52), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,-4),wf(:,39),G0tensor(:,112))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,39),wf(:,-4),G0tensor(:,113))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,25),wf(:,-4),wf(:,39),G0tensor(:,114))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,-2),wf(:,44),G0tensor(:,115))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,25),wf(:,44),wf(:,-2),G0tensor(:,116))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,25),wf(:,-2),wf(:,44),G0tensor(:,117))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,41),Q(:,23),G1tensor(:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,49),Q(:,23),G1tensor(:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,458),Q(:,23),G1tensor(:,55))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,463),Q(:,23),G1tensor(:,56))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,62),Q(:,23),G1tensor(:,57))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,502),Q(:,23),G1tensor(:,58))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,40),wf(:,507),Q(:,23),G1tensor(:,59))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-3),G0(:,:,:,26))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,26),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-2),G0tensor(:,118))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,26),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-4),G0tensor(:,119))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,26),wf(:,-1),wf(:,0),wf(:,-4),wf(:,-2),G0tensor(:,120))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,26),wf(:,4),wf(:,-4),wf(:,-2),G0tensor(:,121))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,26),wf(:,4),wf(:,-2),wf(:,-4),G0tensor(:,122))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,26),wf(:,4),wf(:,-4),wf(:,-2),G0tensor(:,123))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,8),G0tensor(:,124))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,8),wf(:,-4),G0tensor(:,125))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,8),G0tensor(:,126))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-2),wf(:,16),G0tensor(:,127))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,16),wf(:,-2),G0tensor(:,128))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,26),wf(:,-2),wf(:,16),G0tensor(:,129))
  call check_last_GHHG_G(l_switch,G0(:,:,:,26),Q(:,40),wf(:,-1),wf(:,0),wf(:,26),Q(:,20),G1tensor(:,60), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,33),Q(:,23),G1tensor(:,61))
  call check_last_GHG_G(l_switch,G0(:,:,:,26),Q(:,40),wf(:,4),wf(:,26),Q(:,20),G1tensor(:,62), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,39),G0tensor(:,130))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,39),wf(:,-4),G0tensor(:,131))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,39),G0tensor(:,132))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-2),wf(:,44),G0tensor(:,133))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,44),wf(:,-2),G0tensor(:,134))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,26),wf(:,-2),wf(:,44),G0tensor(:,135))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,41),Q(:,23),G1tensor(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,49),Q(:,23),G1tensor(:,64))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,458),Q(:,23),G1tensor(:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,463),Q(:,23),G1tensor(:,66))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,62),Q(:,23),G1tensor(:,67))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,502),Q(:,23),G1tensor(:,68))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,40),wf(:,507),Q(:,23),G1tensor(:,69))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,27))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,27),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G0tensor(:,136))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,27),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-3),G0tensor(:,137))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,27),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G0tensor(:,138))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,27),wf(:,4),wf(:,-3),wf(:,-2),G0tensor(:,139))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,27),wf(:,4),wf(:,-2),wf(:,-3),G0tensor(:,140))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,27),wf(:,4),wf(:,-3),wf(:,-2),G0tensor(:,141))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,-3),wf(:,8),G0tensor(:,142))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,8),wf(:,-3),G0tensor(:,143))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,27),wf(:,-3),wf(:,8),G0tensor(:,144))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,-2),wf(:,12),G0tensor(:,145))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,12),wf(:,-2),G0tensor(:,146))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,27),wf(:,-2),wf(:,12),G0tensor(:,147))
  call check_last_GHHG_G(l_switch,G0(:,:,:,27),Q(:,48),wf(:,-1),wf(:,0),wf(:,24),Q(:,12),G1tensor(:,70), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,35),Q(:,15),G1tensor(:,71))
  call check_last_GHG_G(l_switch,G0(:,:,:,27),Q(:,48),wf(:,4),wf(:,24),Q(:,12),G1tensor(:,72), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,-3),wf(:,39),G0tensor(:,148))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,39),wf(:,-3),G0tensor(:,149))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,27),wf(:,-3),wf(:,39),G0tensor(:,150))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,-2),wf(:,42),G0tensor(:,151))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,42),wf(:,-2),G0tensor(:,152))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,27),wf(:,-2),wf(:,42),G0tensor(:,153))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,43),Q(:,15),G1tensor(:,73))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,46),Q(:,15),G1tensor(:,74))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,461),Q(:,15),G1tensor(:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,464),Q(:,15),G1tensor(:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,61),Q(:,15),G1tensor(:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,501),Q(:,15),G1tensor(:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,48),wf(:,504),Q(:,15),G1tensor(:,79))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-5),G0(:,:,:,28))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,28),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G0tensor(:,154))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,28),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-3),G0tensor(:,155))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,28),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G0tensor(:,156))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,28),wf(:,4),wf(:,-3),wf(:,-2),G0tensor(:,157))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,28),wf(:,4),wf(:,-2),wf(:,-3),G0tensor(:,158))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,28),wf(:,4),wf(:,-3),wf(:,-2),G0tensor(:,159))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,-3),wf(:,8),G0tensor(:,160))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,8),wf(:,-3),G0tensor(:,161))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,28),wf(:,-3),wf(:,8),G0tensor(:,162))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,-2),wf(:,12),G0tensor(:,163))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,12),wf(:,-2),G0tensor(:,164))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,28),wf(:,-2),wf(:,12),G0tensor(:,165))
  call check_last_GHHG_G(l_switch,G0(:,:,:,28),Q(:,48),wf(:,-1),wf(:,0),wf(:,24),Q(:,12),G1tensor(:,80), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,35),Q(:,15),G1tensor(:,81))
  call check_last_GHG_G(l_switch,G0(:,:,:,28),Q(:,48),wf(:,4),wf(:,24),Q(:,12),G1tensor(:,82), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,-3),wf(:,39),G0tensor(:,166))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,39),wf(:,-3),G0tensor(:,167))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,28),wf(:,-3),wf(:,39),G0tensor(:,168))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,-2),wf(:,42),G0tensor(:,169))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,42),wf(:,-2),G0tensor(:,170))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,28),wf(:,-2),wf(:,42),G0tensor(:,171))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,43),Q(:,15),G1tensor(:,83))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,46),Q(:,15),G1tensor(:,84))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,461),Q(:,15),G1tensor(:,85))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,464),Q(:,15),G1tensor(:,86))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,61),Q(:,15),G1tensor(:,87))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,501),Q(:,15),G1tensor(:,88))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,48),wf(:,504),Q(:,15),G1tensor(:,89))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,29))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,29),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G0tensor(:,172))
  call check_last_GHHGG_G_12(l_switch,G0(:,:,:,29),wf(:,-1),wf(:,0),wf(:,-2),wf(:,-3),G0tensor(:,173))
  call check_last_GHHGG_G_23(l_switch,G0(:,:,:,29),wf(:,-1),wf(:,0),wf(:,-3),wf(:,-2),G0tensor(:,174))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,29),wf(:,4),wf(:,-3),wf(:,-2),G0tensor(:,175))
  call check_last_GHGG_G_12(l_switch,G0(:,:,:,29),wf(:,4),wf(:,-2),wf(:,-3),G0tensor(:,176))
  call check_last_GHGG_G_23(l_switch,G0(:,:,:,29),wf(:,4),wf(:,-3),wf(:,-2),G0tensor(:,177))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,-3),wf(:,8),G0tensor(:,178))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,8),wf(:,-3),G0tensor(:,179))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,29),wf(:,-3),wf(:,8),G0tensor(:,180))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,-2),wf(:,12),G0tensor(:,181))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,12),wf(:,-2),G0tensor(:,182))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,29),wf(:,-2),wf(:,12),G0tensor(:,183))
  call check_last_GHHG_G(l_switch,G0(:,:,:,29),Q(:,48),wf(:,-1),wf(:,0),wf(:,24),Q(:,12),G1tensor(:,90), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,35),Q(:,15),G1tensor(:,91))
  call check_last_GHG_G(l_switch,G0(:,:,:,29),Q(:,48),wf(:,4),wf(:,24),Q(:,12),G1tensor(:,92), Q(:,63))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,-3),wf(:,39),G0tensor(:,184))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,39),wf(:,-3),G0tensor(:,185))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,29),wf(:,-3),wf(:,39),G0tensor(:,186))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,-2),wf(:,42),G0tensor(:,187))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,42),wf(:,-2),G0tensor(:,188))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,29),wf(:,-2),wf(:,42),G0tensor(:,189))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,43),Q(:,15),G1tensor(:,93))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,46),Q(:,15),G1tensor(:,94))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,461),Q(:,15),G1tensor(:,95))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,464),Q(:,15),G1tensor(:,96))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,61),Q(:,15),G1tensor(:,97))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,501),Q(:,15),G1tensor(:,98))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,504),Q(:,15),G1tensor(:,99))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,-4),G0(:,:,:,30))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,-3),wf(:,-2),G0tensor(:,190))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,-2),wf(:,-3),G0tensor(:,191))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,30),wf(:,-3),wf(:,-2),G0tensor(:,192))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,100))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-4),wf(:,-5),G0(:,:,:,31))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,31),wf(:,-3),wf(:,-2),G0tensor(:,193))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,31),wf(:,-2),wf(:,-3),G0tensor(:,194))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,31),wf(:,-3),wf(:,-2),G0tensor(:,195))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,101))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,-4),G0(:,:,:,32))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,32),wf(:,-3),wf(:,-2),G0tensor(:,196))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,32),wf(:,-2),wf(:,-3),G0tensor(:,197))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,32),wf(:,-3),wf(:,-2),G0tensor(:,198))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,102))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,-3),G0(:,:,:,33))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,33),wf(:,-4),wf(:,-2),G0tensor(:,199))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,33),wf(:,-2),wf(:,-4),G0tensor(:,200))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,33),wf(:,-4),wf(:,-2),G0tensor(:,201))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,103))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-3),wf(:,-5),G0(:,:,:,34))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,34),wf(:,-4),wf(:,-2),G0tensor(:,202))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,34),wf(:,-2),wf(:,-4),G0tensor(:,203))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,34),wf(:,-4),wf(:,-2),G0tensor(:,204))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,104))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,-3),G0(:,:,:,35))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,35),wf(:,-4),wf(:,-2),G0tensor(:,205))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,35),wf(:,-2),wf(:,-4),G0tensor(:,206))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,35),wf(:,-4),wf(:,-2),G0tensor(:,207))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,105))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,-2),G0(:,:,:,36))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,36),wf(:,-4),wf(:,-3),G0tensor(:,208))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,36),wf(:,-3),wf(:,-4),G0tensor(:,209))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,36),wf(:,-4),wf(:,-3),G0tensor(:,210))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,106))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-2),wf(:,-5),G0(:,:,:,37))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,37),wf(:,-4),wf(:,-3),G0tensor(:,211))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,37),wf(:,-3),wf(:,-4),G0tensor(:,212))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,37),wf(:,-4),wf(:,-3),G0tensor(:,213))
  call check_last_UV_W(l_switch,G0(:,:,:,37),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,107))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,4),wf(:,-5),wf(:,-2),G0(:,:,:,38))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,38),wf(:,-4),wf(:,-3),G0tensor(:,214))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,38),wf(:,-3),wf(:,-4),G0tensor(:,215))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,38),wf(:,-4),wf(:,-3),G0tensor(:,216))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,108))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,8),G0(:,:,:,39))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,39),wf(:,-4),wf(:,-3),G0tensor(:,217))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,39),wf(:,-3),wf(:,-4),G0tensor(:,218))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,39),wf(:,-4),wf(:,-3),G0tensor(:,219))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,109))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,8),wf(:,-5),G0(:,:,:,40))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,40),wf(:,-4),wf(:,-3),G0tensor(:,220))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,40),wf(:,-3),wf(:,-4),G0tensor(:,221))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,40),wf(:,-4),wf(:,-3),G0tensor(:,222))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,110))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,8),G0(:,:,:,41))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,41),wf(:,-4),wf(:,-3),G0tensor(:,223))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,41),wf(:,-3),wf(:,-4),G0tensor(:,224))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,41),wf(:,-4),wf(:,-3),G0tensor(:,225))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,39),wf(:,30),Q(:,24),G1tensor(:,111))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,12),G0(:,:,:,42))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,42),wf(:,-4),wf(:,-2),G0tensor(:,226))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,42),wf(:,-2),wf(:,-4),G0tensor(:,227))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,42),wf(:,-4),wf(:,-2),G0tensor(:,228))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,112))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,12),wf(:,-5),G0(:,:,:,43))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,43),wf(:,-4),wf(:,-2),G0tensor(:,229))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,43),wf(:,-2),wf(:,-4),G0tensor(:,230))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,43),wf(:,-4),wf(:,-2),G0tensor(:,231))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,113))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,12),G0(:,:,:,44))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,44),wf(:,-4),wf(:,-2),G0tensor(:,232))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,44),wf(:,-2),wf(:,-4),G0tensor(:,233))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,44),wf(:,-4),wf(:,-2),G0tensor(:,234))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,114))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,16),G0(:,:,:,45))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,45),wf(:,-3),wf(:,-2),G0tensor(:,235))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,45),wf(:,-2),wf(:,-3),G0tensor(:,236))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,45),wf(:,-3),wf(:,-2),G0tensor(:,237))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,115))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,16),wf(:,-5),G0(:,:,:,46))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,46),wf(:,-3),wf(:,-2),G0tensor(:,238))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,46),wf(:,-2),wf(:,-3),G0tensor(:,239))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,46),wf(:,-3),wf(:,-2),G0tensor(:,240))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,116))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,16),G0(:,:,:,47))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,47),wf(:,-3),wf(:,-2),G0tensor(:,241))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,47),wf(:,-2),wf(:,-3),G0tensor(:,242))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,47),wf(:,-3),wf(:,-2),G0tensor(:,243))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,117))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,21),G0(:,:,:,48))
  call check_last_GHH_G(l_switch,G0(:,:,:,48),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,1), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,48),Q(:,60),wf(:,4),G2tensor(:,2), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,22),G0(:,:,:,49))
  call check_last_GHH_G(l_switch,G0(:,:,:,49),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,3), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,49),Q(:,60),wf(:,4),G2tensor(:,4), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,23),G0(:,:,:,50))
  call check_last_GHH_G(l_switch,G0(:,:,:,50),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,5), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,50),Q(:,60),wf(:,4),G2tensor(:,6), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,21),wf(:,-5),G0(:,:,:,51))
  call check_last_GHH_G(l_switch,G0(:,:,:,51),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,7), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,51),Q(:,60),wf(:,4),G2tensor(:,8), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,22),wf(:,-5),G0(:,:,:,52))
  call check_last_GHH_G(l_switch,G0(:,:,:,52),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,9), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,52),Q(:,60),wf(:,4),G2tensor(:,10), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,23),wf(:,-5),G0(:,:,:,53))
  call check_last_GHH_G(l_switch,G0(:,:,:,53),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,11), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,53),Q(:,60),wf(:,4),G2tensor(:,12), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,21),G0(:,:,:,54))
  call check_last_GHH_G(l_switch,G0(:,:,:,54),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,13), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,54),Q(:,60),wf(:,4),G2tensor(:,14), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,22),G0(:,:,:,55))
  call check_last_GHH_G(l_switch,G0(:,:,:,55),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,15), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,55),Q(:,60),wf(:,4),G2tensor(:,16), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,23),G0(:,:,:,56))
  call check_last_GHH_G(l_switch,G0(:,:,:,56),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,17), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,56),Q(:,60),wf(:,4),G2tensor(:,18), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,20),G0(:,:,:,57))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,57),wf(:,-3),wf(:,-2),G0tensor(:,244))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,57),wf(:,-2),wf(:,-3),G0tensor(:,245))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,57),wf(:,-3),wf(:,-2),G0tensor(:,246))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,118))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,-4),G0(:,:,:,58))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,58),wf(:,-3),wf(:,-2),G0tensor(:,247))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,58),wf(:,-2),wf(:,-3),G0tensor(:,248))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,58),wf(:,-3),wf(:,-2),G0tensor(:,249))
  call check_last_UV_W(l_switch,G0(:,:,:,58),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,119))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,20),G0(:,:,:,59))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,59),wf(:,-3),wf(:,-2),G0tensor(:,250))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,59),wf(:,-2),wf(:,-3),G0tensor(:,251))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,59),wf(:,-3),wf(:,-2),G0tensor(:,252))
  call check_last_UV_W(l_switch,G0(:,:,:,59),Q(:,51),wf(:,24),Q(:,12),G1tensor(:,120))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,17),G0(:,:,:,60))
  call check_last_GHH_G(l_switch,G0(:,:,:,60),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,19), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,60),Q(:,60),wf(:,4),G2tensor(:,20), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,18),G0(:,:,:,61))
  call check_last_GHH_G(l_switch,G0(:,:,:,61),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,21), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,61),Q(:,60),wf(:,4),G2tensor(:,22), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,19),G0(:,:,:,62))
  call check_last_GHH_G(l_switch,G0(:,:,:,62),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,23), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,62),Q(:,60),wf(:,4),G2tensor(:,24), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,17),wf(:,-4),G0(:,:,:,63))
  call check_last_GHH_G(l_switch,G0(:,:,:,63),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,25), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,63),Q(:,60),wf(:,4),G2tensor(:,26), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,18),wf(:,-4),G0(:,:,:,64))
  call check_last_GHH_G(l_switch,G0(:,:,:,64),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,27), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,64),Q(:,60),wf(:,4),G2tensor(:,28), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,19),wf(:,-4),G0(:,:,:,65))
  call check_last_GHH_G(l_switch,G0(:,:,:,65),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,29), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,65),Q(:,60),wf(:,4),G2tensor(:,30), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,17),G0(:,:,:,66))
  call check_last_GHH_G(l_switch,G0(:,:,:,66),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,31), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,66),Q(:,60),wf(:,4),G2tensor(:,32), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,18),G0(:,:,:,67))
  call check_last_GHH_G(l_switch,G0(:,:,:,67),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,33), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,67),Q(:,60),wf(:,4),G2tensor(:,34), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,19),G0(:,:,:,68))
  call check_last_GHH_G(l_switch,G0(:,:,:,68),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,35), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,68),Q(:,60),wf(:,4),G2tensor(:,36), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,20),G0(:,:,:,69))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,-4),wf(:,-2),G0tensor(:,253))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,-2),wf(:,-4),G0tensor(:,254))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,69),wf(:,-4),wf(:,-2),G0tensor(:,255))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,121))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,-3),G0(:,:,:,70))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,-4),wf(:,-2),G0tensor(:,256))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,-2),wf(:,-4),G0tensor(:,257))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,70),wf(:,-4),wf(:,-2),G0tensor(:,258))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,122))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,20),G0(:,:,:,71))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,71),wf(:,-4),wf(:,-2),G0tensor(:,259))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,71),wf(:,-2),wf(:,-4),G0tensor(:,260))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,71),wf(:,-4),wf(:,-2),G0tensor(:,261))
  call check_last_UV_W(l_switch,G0(:,:,:,71),Q(:,43),wf(:,26),Q(:,20),G1tensor(:,123))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,13),G0(:,:,:,72))
  call check_last_GHH_G(l_switch,G0(:,:,:,72),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,37), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,72),Q(:,60),wf(:,4),G2tensor(:,38), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,14),G0(:,:,:,73))
  call check_last_GHH_G(l_switch,G0(:,:,:,73),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,39), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,73),Q(:,60),wf(:,4),G2tensor(:,40), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,15),G0(:,:,:,74))
  call check_last_GHH_G(l_switch,G0(:,:,:,74),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,41), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,74),Q(:,60),wf(:,4),G2tensor(:,42), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,-3),G0(:,:,:,75))
  call check_last_GHH_G(l_switch,G0(:,:,:,75),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,43), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,75),Q(:,60),wf(:,4),G2tensor(:,44), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,14),wf(:,-3),G0(:,:,:,76))
  call check_last_GHH_G(l_switch,G0(:,:,:,76),Q(:,60),wf(:,-1),wf(:,0),G2tensor(:,45), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,76),Q(:,60),wf(:,4),G2tensor(:,46), Q(:,63))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(478)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(478)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(478)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(17)*(-M(4)+M(5))) * den(221)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(17)*(-M(7)+M(9))) * den(221)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(18)*(-M(4)+M(5))) * den(221)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(18)*(-M(7)+M(9))) * den(221)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(221)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(221)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(17)*(M(5)-M(6))) * den(503)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(17)*(-M(7)+M(8))) * den(503)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(18)*(M(5)-M(6))) * den(503)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(18)*(-M(7)+M(8))) * den(503)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(503)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(503)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(503)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(17)*(-M(8)+M(9))) * den(506)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(17)*(-M(4)+M(6))) * den(506)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(18)*(-M(8)+M(9))) * den(506)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(18)*(-M(4)+M(6))) * den(506)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(506)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(506)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(506)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(19)*M(7)) * den(47)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(19)*M(5)) * den(47)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(20)*M(7)) * den(47)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(20)*M(5)) * den(47)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(47)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(47)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(19)*M(9)) * den(47)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(19)*M(4)) * den(47)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(20)*M(9)) * den(47)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(20)*M(4)) * den(47)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(47)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(47)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(17)*(M(5)-M(6))) * den(508)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(17)*(-M(7)+M(8))) * den(508)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(18)*(M(5)-M(6))) * den(508)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(18)*(-M(7)+M(8))) * den(508)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(508)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(508)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(508)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(17)*(-M(8)+M(9))) * den(509)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(17)*(-M(4)+M(6))) * den(509)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(18)*(-M(8)+M(9))) * den(509)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(18)*(-M(4)+M(6))) * den(509)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(509)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(509)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(509)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9)))
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,10)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,11)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,13)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,15)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,16)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,17)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8)))
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,19)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,37)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,55)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,20)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,38)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,56)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,21)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,39)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9)))
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,57)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,73)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,74)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,75)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,76)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,77)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,78)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,79)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,80)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9)))
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,81)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,82)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,100)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,118)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,83)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,101)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,119)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,84)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,102)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8)))
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,120)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,136)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,154)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,172)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,137)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,155)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,173)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,138)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,156)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9)))
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,174)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,190)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,191)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,192)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,193)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,194)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,195)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,196)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,197)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,198)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,199)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,200)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,201)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,202)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,203)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,204)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,205)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,206)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,207)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,22)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,40)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,58)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,23)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,41)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,59)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,24)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,42)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,60)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,208)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,209)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,210)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,211)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,212)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,213)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,214)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,215)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(1)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,216)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,85)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,103)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,121)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,86)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,104)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,122)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,87)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,105)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(1)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,123)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,139)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,157)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,175)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,140)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,158)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,176)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,141)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,159)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(1)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,177)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,217)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,218)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,219)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,220)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,221)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,222)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,223)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,224)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,225)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,88)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,106)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,124)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,89)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,107)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,125)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,90)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,108)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,126)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,142)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,143)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,144)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,160)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,161)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,162)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,178)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,179)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(2)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,180)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,226)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,227)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,228)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,229)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,230)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,231)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,232)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,233)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,234)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,25)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,43)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,61)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,26)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,44)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,62)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,27)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,45)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,63)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,145)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,146)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,147)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,163)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,164)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,165)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,181)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,182)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,183)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,235)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,236)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,237)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,238)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,239)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,240)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,241)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,242)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,243)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,11)
  Gcoeff = (0) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,13)
  Gcoeff = (0) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,15)
  Gcoeff = (0) * den(24)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,244)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,245)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,246)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,247)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,248)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,249)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,250)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,251)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(5)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,252)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,29)
  Gcoeff = (0) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,31)
  Gcoeff = (0) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,33)
  Gcoeff = (0) * den(22)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,28)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,46)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,64)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,29)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(4)+M(9))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,47)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,65)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,30)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,48)
  Gcoeff = (c(3)*(M(4)-M(6)-M(8)+M(9))) * den(4)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,66)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,91)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,92)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,93)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,109)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,110)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,111)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,127)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,128)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(4)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,129)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,253)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,254)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,255)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(6)+M(8))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,256)
  Gcoeff = (c(1)*(M(1)+M(2)+M(3))+c(2)*(M(5)+M(7))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,257)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,258)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,259)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,260)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(5)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,261)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(19)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(19)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(19)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(19)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(19)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(6)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(6)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(6)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,90)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(7)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(7)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(7)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(9)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(9)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(9)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(74)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(74)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(74)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(72)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(72)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(72)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(71)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(71)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,81)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(71)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(6)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(6)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(6)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(7)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(7)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(7)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(9)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(9)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(9)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(12)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(12)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(12)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(12)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,100)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(12)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(12)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(13)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(13)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(13)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,94)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,112)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,130)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,95)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,113)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,131)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,96)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,114)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(52)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,132)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,148)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,149)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,150)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,166)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,167)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,168)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,184)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,185)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(52)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,186)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(13)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(13)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(13)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,105)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(17)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(17)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(17)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,31)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,49)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,67)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,32)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,50)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,68)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,33)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,51)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(47)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,69)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,151)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,152)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,153)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,169)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,170)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,171)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,187)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,188)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(47)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,189)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,12)
  Gcoeff = (0) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,14)
  Gcoeff = (0) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,16)
  Gcoeff = (0) * den(25)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(9)*(M(4)-M(5)-M(7)+M(9))) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,30)
  Gcoeff = (0) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,32)
  Gcoeff = (0) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,34)
  Gcoeff = (0) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(211)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(211)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(211)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,34)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,52)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,70)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,35)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(4)-M(9))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,53)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,71)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,36)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,54)
  Gcoeff = (c(9)*(-M(4)+M(6)+M(8)-M(9))) * den(42)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,72)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,97)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,98)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,99)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(6)-M(8))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,115)
  Gcoeff = (c(7)*(-M(1)-M(2)-M(3))+c(8)*(-M(5)-M(7))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,116)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,117)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,133)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,134)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(42)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,135)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(20)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(20)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(20)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(9)*(-M(5)+M(6)-M(7)+M(8))) * den(20)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(20)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(208)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(208)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(208)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(197)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(197)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(197)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(17)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,106)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(17)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,107)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(17)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,108)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,115)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,116)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,117)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(27)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,118)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(27)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,119)
  Gcoeff = (c(3)*(-M(4)+M(5)+M(7)-M(9))) * den(27)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,120)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(346)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(346)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(346)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(35)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,112)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(35)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,113)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(35)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,114)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(380)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(380)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,85)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(380)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,95)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(30)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,121)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(30)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,122)
  Gcoeff = (c(3)*(M(5)-M(6)+M(7)-M(8))) * den(30)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,123)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(356)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(356)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(356)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(371)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(371)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(371)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(38)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,109)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(38)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,110)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(38)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,111)
  Gcoeff = (c(2)*(-M(4)+M(5)+M(7)-M(9))) * den(389)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(2)*(M(4)-M(5)-M(7)+M(9))) * den(389)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,86)
  Gcoeff = (c(3)*(M(4)-M(5)-M(7)+M(9))) * den(389)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(2)*(M(5)-M(6)+M(7)-M(8))) * den(386)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(2)*(-M(5)+M(6)-M(7)+M(8))) * den(386)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(3)*(-M(5)+M(6)-M(7)+M(8))) * den(386)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(361)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(361)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(361)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(368)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(368)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(368)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(2)*(M(4)-M(6)-M(8)+M(9))) * den(377)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(2)*(-M(4)+M(6)+M(8)-M(9))) * den(377)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(3)*(-M(4)+M(6)+M(8)-M(9))) * den(377)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(462)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(462)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(462)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(502)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(502)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(502)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(8)*(M(4)-M(5)-M(7)+M(9))) * den(505)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,79)
  Gcoeff = (c(8)*(-M(4)+M(5)+M(7)-M(9))) * den(505)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(9)*(-M(4)+M(5)+M(7)-M(9))) * den(505)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(471)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(471)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(471)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(503)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(503)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(503)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(8)*(-M(5)+M(6)-M(7)+M(8))) * den(508)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(8)*(M(5)-M(6)+M(7)-M(8))) * den(508)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(9)*(M(5)-M(6)+M(7)-M(8))) * den(508)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(478)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(478)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(478)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(506)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(506)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(506)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(8)*(-M(4)+M(6)+M(8)-M(9))) * den(509)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(8)*(M(4)-M(6)-M(8)+M(9))) * den(509)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(9)*(M(4)-M(6)-M(8)+M(9))) * den(509)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,36)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_4

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_4_heftpphhjj_hhgggg_1_/**/REALKIND
