
module ol_vamp_3_heftpphhjj_hhgggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_hhgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_hhgggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_hhgggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_hhgggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(9)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,50) :: G0
  complex(REALKIND), dimension(4,5,4,233) :: G1
  complex(REALKIND), dimension(4,15,4,430) :: G2
  complex(REALKIND), dimension(4,35,4,101) :: G3
  complex(REALKIND), dimension(15,24) :: G2tensor
  complex(REALKIND), dimension(35,273) :: G3tensor
  complex(REALKIND), dimension(70,85) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,8),ZERO,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,25),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,59),ZERO,G2(:,:,:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2))
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,36),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,59),ZERO,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,-2),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),ZERO,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,450),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,59),ZERO,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,-2),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),ZERO,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,451),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,59),ZERO,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),ZERO,G3tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,20),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,43),ZERO,G2(:,:,:,9))
  call loop_QV_A(G2(:,:,:,9),wf(:,-4),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,59),ZERO,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,-2),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),ZERO,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,24),ZERO,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,20),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,59),ZERO,G3(:,:,:,3))
  call loop_QV_A(G3(:,:,:,3),wf(:,-2),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),ZERO,G4tensor(:,2))
  call loop_QV_A(G2(:,:,:,11),wf(:,-5),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,56),ZERO,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,8),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,3))
  call loop_QV_A(G3(:,:,:,5),wf(:,39),G3(:,:,:,7))
  call check_last_Q_A(l_switch,G3(:,:,:,7),Q(:,63),ZERO,G4tensor(:,4))
  call loop_QV_A(G2(:,:,:,11),wf(:,45),G2(:,:,:,14))
  call loop_Q_A(G2(:,:,:,14),Q(:,59),ZERO,G3(:,:,:,8))
  call loop_QV_A(G3(:,:,:,8),wf(:,-2),G3(:,:,:,9))
  call check_last_Q_A(l_switch,G3(:,:,:,9),Q(:,63),ZERO,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,1),wf(:,452),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,59),ZERO,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,-2),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,1),wf(:,16),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,27),ZERO,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,-5),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,59),ZERO,G3(:,:,:,10))
  call loop_QV_A(G3(:,:,:,10),wf(:,-2),G3(:,:,:,11))
  call check_last_Q_A(l_switch,G3(:,:,:,11),Q(:,63),ZERO,G4tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,40),ZERO,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,16),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,59),ZERO,G3(:,:,:,12))
  call loop_QV_A(G3(:,:,:,12),wf(:,-2),G3(:,:,:,13))
  call check_last_Q_A(l_switch,G3(:,:,:,13),Q(:,63),ZERO,G4tensor(:,7))
  call loop_QV_A(G2(:,:,:,19),wf(:,-4),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,56),ZERO,G3(:,:,:,14))
  call loop_QV_A(G3(:,:,:,14),wf(:,8),G3(:,:,:,15))
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,63),ZERO,G4tensor(:,8))
  call loop_QV_A(G3(:,:,:,14),wf(:,39),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),ZERO,G4tensor(:,9))
  call loop_QV_A(G2(:,:,:,19),wf(:,44),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,59),ZERO,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,-2),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,34),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,56),ZERO,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,8),G2(:,:,:,24))
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),ZERO,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,23),wf(:,39),G2(:,:,:,25))
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,63),ZERO,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,477),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,59),ZERO,G2(:,:,:,26))
  call loop_QV_A(G2(:,:,:,26),wf(:,-2),G2(:,:,:,27))
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,63),ZERO,G3tensor(:,8))
  call loop_QV_A(G1(:,:,:,1),wf(:,509),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,59),ZERO,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-2),G2(:,:,:,29))
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,63),ZERO,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,44),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,27),ZERO,G2(:,:,:,30))
  call loop_QV_A(G2(:,:,:,30),wf(:,-5),G2(:,:,:,31))
  call loop_Q_A(G2(:,:,:,31),Q(:,59),ZERO,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,-2),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,1),wf(:,512),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,59),ZERO,G2(:,:,:,32))
  call loop_QV_A(G2(:,:,:,32),wf(:,-2),G2(:,:,:,33))
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,63),ZERO,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,1),wf(:,45),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,43),ZERO,G2(:,:,:,34))
  call loop_QV_A(G2(:,:,:,34),wf(:,-4),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,59),ZERO,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,-2),G3(:,:,:,22))
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),ZERO,G4tensor(:,12))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-3),G1(:,:,:,17))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,25),G2(:,:,:,36))
  call check_last_DV_C(l_switch,G2(:,:,:,36),Q(:,59),wf(:,-2),G3tensor(:,11))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,36),G2(:,:,:,37))
  call check_last_DV_C(l_switch,G2(:,:,:,37),Q(:,59),wf(:,-2),G3tensor(:,12))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,450),G2(:,:,:,38))
  call check_last_DV_C(l_switch,G2(:,:,:,38),Q(:,59),wf(:,-2),G3tensor(:,13))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,451),G2(:,:,:,39))
  call check_last_DV_C(l_switch,G2(:,:,:,39),Q(:,59),wf(:,-2),G3tensor(:,14))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,20),G2(:,:,:,40))
  call loop_DV_C(G2(:,:,:,40),Q(:,43),wf(:,-4),G3(:,:,:,23))
  call check_last_DV_C(l_switch,G3(:,:,:,23),Q(:,59),wf(:,-2),G4tensor(:,13))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,-4),G2(:,:,:,41))
  call loop_DV_C(G2(:,:,:,41),Q(:,24),wf(:,20),G3(:,:,:,24))
  call check_last_DV_C(l_switch,G3(:,:,:,24),Q(:,59),wf(:,-2),G4tensor(:,14))
  call loop_DV_C(G2(:,:,:,41),Q(:,24),wf(:,-5),G3(:,:,:,25))
  call check_last_DV_C(l_switch,G3(:,:,:,25),Q(:,56),wf(:,8),G4tensor(:,15))
  call check_last_DV_C(l_switch,G3(:,:,:,25),Q(:,56),wf(:,39),G4tensor(:,16))
  call loop_DV_C(G2(:,:,:,41),Q(:,24),wf(:,45),G3(:,:,:,26))
  call check_last_DV_C(l_switch,G3(:,:,:,26),Q(:,59),wf(:,-2),G4tensor(:,17))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,452),G2(:,:,:,42))
  call check_last_DV_C(l_switch,G2(:,:,:,42),Q(:,59),wf(:,-2),G3tensor(:,15))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,16),G2(:,:,:,43))
  call loop_DV_C(G2(:,:,:,43),Q(:,27),wf(:,-5),G3(:,:,:,27))
  call check_last_DV_C(l_switch,G3(:,:,:,27),Q(:,59),wf(:,-2),G4tensor(:,18))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,-5),G2(:,:,:,44))
  call loop_DV_C(G2(:,:,:,44),Q(:,40),wf(:,16),G3(:,:,:,28))
  call check_last_DV_C(l_switch,G3(:,:,:,28),Q(:,59),wf(:,-2),G4tensor(:,19))
  call loop_DV_C(G2(:,:,:,44),Q(:,40),wf(:,-4),G3(:,:,:,29))
  call check_last_DV_C(l_switch,G3(:,:,:,29),Q(:,56),wf(:,8),G4tensor(:,20))
  call check_last_DV_C(l_switch,G3(:,:,:,29),Q(:,56),wf(:,39),G4tensor(:,21))
  call loop_DV_C(G2(:,:,:,44),Q(:,40),wf(:,44),G3(:,:,:,30))
  call check_last_DV_C(l_switch,G3(:,:,:,30),Q(:,59),wf(:,-2),G4tensor(:,22))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,34),G2(:,:,:,45))
  call check_last_DV_C(l_switch,G2(:,:,:,45),Q(:,56),wf(:,8),G3tensor(:,16))
  call check_last_DV_C(l_switch,G2(:,:,:,45),Q(:,56),wf(:,39),G3tensor(:,17))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,477),G2(:,:,:,46))
  call check_last_DV_C(l_switch,G2(:,:,:,46),Q(:,59),wf(:,-2),G3tensor(:,18))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,509),G2(:,:,:,47))
  call check_last_DV_C(l_switch,G2(:,:,:,47),Q(:,59),wf(:,-2),G3tensor(:,19))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,44),G2(:,:,:,48))
  call loop_DV_C(G2(:,:,:,48),Q(:,27),wf(:,-5),G3(:,:,:,31))
  call check_last_DV_C(l_switch,G3(:,:,:,31),Q(:,59),wf(:,-2),G4tensor(:,23))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,512),G2(:,:,:,49))
  call check_last_DV_C(l_switch,G2(:,:,:,49),Q(:,59),wf(:,-2),G3tensor(:,20))
  call loop_DV_C(G1(:,:,:,17),Q(:,8),wf(:,45),G2(:,:,:,50))
  call loop_DV_C(G2(:,:,:,50),Q(:,43),wf(:,-4),G3(:,:,:,32))
  call check_last_DV_C(l_switch,G3(:,:,:,32),Q(:,59),wf(:,-2),G4tensor(:,24))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-3),Q(:,8),G1(:,:,:,18))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,25),Q(:,51),G2(:,:,:,51))
  call check_last_CV_D(l_switch,G2(:,:,:,51),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,21))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,36),Q(:,51),G2(:,:,:,52))
  call check_last_CV_D(l_switch,G2(:,:,:,52),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,22))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,450),Q(:,51),G2(:,:,:,53))
  call check_last_CV_D(l_switch,G2(:,:,:,53),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,23))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,451),Q(:,51),G2(:,:,:,54))
  call check_last_CV_D(l_switch,G2(:,:,:,54),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,24))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,20),Q(:,35),G2(:,:,:,55))
  call loop_CV_D(G2(:,:,:,55),Q(:,43),wf(:,-4),Q(:,16),G3(:,:,:,33))
  call check_last_CV_D(l_switch,G3(:,:,:,33),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,25))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,-4),Q(:,16),G2(:,:,:,56))
  call loop_CV_D(G2(:,:,:,56),Q(:,24),wf(:,20),Q(:,35),G3(:,:,:,34))
  call check_last_CV_D(l_switch,G3(:,:,:,34),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,26))
  call loop_CV_D(G2(:,:,:,56),Q(:,24),wf(:,-5),Q(:,32),G3(:,:,:,35))
  call check_last_CV_D(l_switch,G3(:,:,:,35),Q(:,56),wf(:,8),Q(:,7),G4tensor(:,27))
  call check_last_CV_D(l_switch,G3(:,:,:,35),Q(:,56),wf(:,39),Q(:,7),G4tensor(:,28))
  call loop_CV_D(G2(:,:,:,56),Q(:,24),wf(:,45),Q(:,35),G3(:,:,:,36))
  call check_last_CV_D(l_switch,G3(:,:,:,36),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,29))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,452),Q(:,51),G2(:,:,:,57))
  call check_last_CV_D(l_switch,G2(:,:,:,57),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,25))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,16),Q(:,19),G2(:,:,:,58))
  call loop_CV_D(G2(:,:,:,58),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,37))
  call check_last_CV_D(l_switch,G3(:,:,:,37),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,30))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,-5),Q(:,32),G2(:,:,:,59))
  call loop_CV_D(G2(:,:,:,59),Q(:,40),wf(:,16),Q(:,19),G3(:,:,:,38))
  call check_last_CV_D(l_switch,G3(:,:,:,38),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,31))
  call loop_CV_D(G2(:,:,:,59),Q(:,40),wf(:,-4),Q(:,16),G3(:,:,:,39))
  call check_last_CV_D(l_switch,G3(:,:,:,39),Q(:,56),wf(:,8),Q(:,7),G4tensor(:,32))
  call check_last_CV_D(l_switch,G3(:,:,:,39),Q(:,56),wf(:,39),Q(:,7),G4tensor(:,33))
  call loop_CV_D(G2(:,:,:,59),Q(:,40),wf(:,44),Q(:,19),G3(:,:,:,40))
  call check_last_CV_D(l_switch,G3(:,:,:,40),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,34))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,34),Q(:,48),G2(:,:,:,60))
  call check_last_CV_D(l_switch,G2(:,:,:,60),Q(:,56),wf(:,8),Q(:,7),G3tensor(:,26))
  call check_last_CV_D(l_switch,G2(:,:,:,60),Q(:,56),wf(:,39),Q(:,7),G3tensor(:,27))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,477),Q(:,51),G2(:,:,:,61))
  call check_last_CV_D(l_switch,G2(:,:,:,61),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,28))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,509),Q(:,51),G2(:,:,:,62))
  call check_last_CV_D(l_switch,G2(:,:,:,62),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,29))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,44),Q(:,19),G2(:,:,:,63))
  call loop_CV_D(G2(:,:,:,63),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,41))
  call check_last_CV_D(l_switch,G3(:,:,:,41),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,35))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,512),Q(:,51),G2(:,:,:,64))
  call check_last_CV_D(l_switch,G2(:,:,:,64),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,30))
  call loop_CV_D(G1(:,:,:,18),Q(:,8),wf(:,45),Q(:,35),G2(:,:,:,65))
  call loop_CV_D(G2(:,:,:,65),Q(:,43),wf(:,-4),Q(:,16),G3(:,:,:,42))
  call check_last_CV_D(l_switch,G3(:,:,:,42),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,16),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,27),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,59),ZERO,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-2),G2(:,:,:,67))
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,63),ZERO,G3tensor(:,31))
  call loop_AV_Q(G1(:,:,:,19),wf(:,31),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,55),ZERO,G2(:,:,:,68))
  call loop_AV_Q(G2(:,:,:,68),wf(:,-3),G2(:,:,:,69))
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,63),ZERO,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-5),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,48),ZERO,G2(:,:,:,70))
  call loop_AV_Q(G2(:,:,:,70),wf(:,35),G2(:,:,:,71))
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,63),ZERO,G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,70),wf(:,43),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),ZERO,G3tensor(:,34))
  call loop_AV_Q(G2(:,:,:,70),wf(:,46),G2(:,:,:,73))
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,63),ZERO,G3tensor(:,35))
  call loop_AV_Q(G2(:,:,:,70),wf(:,461),G2(:,:,:,74))
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),ZERO,G3tensor(:,36))
  call loop_AV_Q(G2(:,:,:,70),wf(:,464),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,63),ZERO,G3tensor(:,37))
  call loop_AV_Q(G2(:,:,:,70),wf(:,61),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,63),ZERO,G3tensor(:,38))
  call loop_AV_Q(G2(:,:,:,70),wf(:,501),G2(:,:,:,77))
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,63),ZERO,G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,70),wf(:,504),G2(:,:,:,78))
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,63),ZERO,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,19),wf(:,37),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,59),ZERO,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-2),G2(:,:,:,80))
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,63),ZERO,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,19),wf(:,40),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,55),ZERO,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-3),G2(:,:,:,82))
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,63),ZERO,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,19),wf(:,20),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,51),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,24),G2(:,:,:,84))
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,63),ZERO,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,19),wf(:,51),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,55),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-3),G2(:,:,:,86))
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),ZERO,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,19),wf(:,453),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,59),ZERO,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-2),G2(:,:,:,88))
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),ZERO,G3tensor(:,45))
  call loop_AV_Q(G1(:,:,:,19),wf(:,456),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,55),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-3),G2(:,:,:,90))
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),ZERO,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,19),wf(:,454),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,59),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-2),G2(:,:,:,92))
  call check_last_A_Q(l_switch,G2(:,:,:,92),Q(:,63),ZERO,G3tensor(:,47))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-3),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,24),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,20),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,59),ZERO,G3(:,:,:,43))
  call loop_AV_Q(G3(:,:,:,43),wf(:,-2),G3(:,:,:,44))
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),ZERO,G4tensor(:,37))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-5),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,56),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,8),G3(:,:,:,46))
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,63),ZERO,G4tensor(:,38))
  call loop_AV_Q(G3(:,:,:,45),wf(:,39),G3(:,:,:,47))
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,63),ZERO,G4tensor(:,39))
  call loop_AV_Q(G2(:,:,:,93),wf(:,45),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,59),ZERO,G3(:,:,:,48))
  call loop_AV_Q(G3(:,:,:,48),wf(:,-2),G3(:,:,:,49))
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,63),ZERO,G4tensor(:,40))
  call loop_AV_Q(G1(:,:,:,19),wf(:,28),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,52),ZERO,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,12),G2(:,:,:,98))
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,63),ZERO,G3tensor(:,48))
  call loop_AV_Q(G2(:,:,:,97),wf(:,42),G2(:,:,:,99))
  call check_last_A_Q(l_switch,G2(:,:,:,99),Q(:,63),ZERO,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,19),wf(:,459),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,59),ZERO,G2(:,:,:,100))
  call loop_AV_Q(G2(:,:,:,100),wf(:,-2),G2(:,:,:,101))
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,63),ZERO,G3tensor(:,50))
  call loop_AV_Q(G1(:,:,:,19),wf(:,12),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,27),ZERO,G2(:,:,:,102))
  call loop_AV_Q(G2(:,:,:,102),wf(:,-5),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,59),ZERO,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,-2),G3(:,:,:,51))
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,63),ZERO,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,19),wf(:,32),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,56),ZERO,G2(:,:,:,104))
  call loop_AV_Q(G2(:,:,:,104),wf(:,8),G2(:,:,:,105))
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,63),ZERO,G3tensor(:,51))
  call loop_AV_Q(G2(:,:,:,104),wf(:,39),G2(:,:,:,106))
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,63),ZERO,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,19),wf(:,462),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,55),ZERO,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-3),G2(:,:,:,108))
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,63),ZERO,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,19),wf(:,45),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,51),ZERO,G2(:,:,:,109))
  call loop_AV_Q(G2(:,:,:,109),wf(:,24),G2(:,:,:,110))
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,63),ZERO,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,19),wf(:,63),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,55),ZERO,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-3),G2(:,:,:,112))
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,63),ZERO,G3tensor(:,55))
  call loop_AV_Q(G1(:,:,:,19),wf(:,482),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,59),ZERO,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,-2),G2(:,:,:,114))
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,63),ZERO,G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,19),wf(:,503),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,55),ZERO,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-3),G2(:,:,:,116))
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,63),ZERO,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,19),wf(:,506),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,59),ZERO,G2(:,:,:,117))
  call loop_AV_Q(G2(:,:,:,117),wf(:,-2),G2(:,:,:,118))
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,63),ZERO,G3tensor(:,58))
  call loop_AV_Q(G1(:,:,:,19),wf(:,42),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,27),ZERO,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,59),ZERO,G3(:,:,:,52))
  call loop_AV_Q(G3(:,:,:,52),wf(:,-2),G3(:,:,:,53))
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,63),ZERO,G4tensor(:,42))
  call loop_AV_Q(G1(:,:,:,19),wf(:,510),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,55),ZERO,G2(:,:,:,121))
  call loop_AV_Q(G2(:,:,:,121),wf(:,-3),G2(:,:,:,122))
  call check_last_A_Q(l_switch,G2(:,:,:,122),Q(:,63),ZERO,G3tensor(:,59))
  call loop_AV_Q(G1(:,:,:,19),wf(:,511),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,59),ZERO,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-2),G2(:,:,:,124))
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,63),ZERO,G3tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,16),ZERO,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,27),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,59),ZERO,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-2),G2(:,:,:,126))
  call check_last_Q_A(l_switch,G2(:,:,:,126),Q(:,63),ZERO,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,44),wf(:,31),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,55),ZERO,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,-3),G2(:,:,:,128))
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,63),ZERO,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,44),wf(:,-5),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,48),ZERO,G2(:,:,:,129))
  call loop_QV_A(G2(:,:,:,129),wf(:,35),G2(:,:,:,130))
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,63),ZERO,G3tensor(:,63))
  call loop_QV_A(G2(:,:,:,129),wf(:,43),G2(:,:,:,131))
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,63),ZERO,G3tensor(:,64))
  call loop_QV_A(G2(:,:,:,129),wf(:,46),G2(:,:,:,132))
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,63),ZERO,G3tensor(:,65))
  call loop_QV_A(G2(:,:,:,129),wf(:,461),G2(:,:,:,133))
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,63),ZERO,G3tensor(:,66))
  call loop_QV_A(G2(:,:,:,129),wf(:,464),G2(:,:,:,134))
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,63),ZERO,G3tensor(:,67))
  call loop_QV_A(G2(:,:,:,129),wf(:,61),G2(:,:,:,135))
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,63),ZERO,G3tensor(:,68))
  call loop_QV_A(G2(:,:,:,129),wf(:,501),G2(:,:,:,136))
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,63),ZERO,G3tensor(:,69))
  call loop_QV_A(G2(:,:,:,129),wf(:,504),G2(:,:,:,137))
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,63),ZERO,G3tensor(:,70))
  call loop_QV_A(G1(:,:,:,44),wf(:,37),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,59),ZERO,G2(:,:,:,138))
  call loop_QV_A(G2(:,:,:,138),wf(:,-2),G2(:,:,:,139))
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,63),ZERO,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,44),wf(:,40),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,55),ZERO,G2(:,:,:,140))
  call loop_QV_A(G2(:,:,:,140),wf(:,-3),G2(:,:,:,141))
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,63),ZERO,G3tensor(:,72))
  call loop_QV_A(G1(:,:,:,44),wf(:,20),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,51),ZERO,G2(:,:,:,142))
  call loop_QV_A(G2(:,:,:,142),wf(:,24),G2(:,:,:,143))
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,63),ZERO,G3tensor(:,73))
  call loop_QV_A(G1(:,:,:,44),wf(:,51),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,55),ZERO,G2(:,:,:,144))
  call loop_QV_A(G2(:,:,:,144),wf(:,-3),G2(:,:,:,145))
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,63),ZERO,G3tensor(:,74))
  call loop_QV_A(G1(:,:,:,44),wf(:,453),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,59),ZERO,G2(:,:,:,146))
  call loop_QV_A(G2(:,:,:,146),wf(:,-2),G2(:,:,:,147))
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,63),ZERO,G3tensor(:,75))
  call loop_QV_A(G1(:,:,:,44),wf(:,456),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,55),ZERO,G2(:,:,:,148))
  call loop_QV_A(G2(:,:,:,148),wf(:,-3),G2(:,:,:,149))
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,63),ZERO,G3tensor(:,76))
  call loop_QV_A(G1(:,:,:,44),wf(:,454),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,59),ZERO,G2(:,:,:,150))
  call loop_QV_A(G2(:,:,:,150),wf(:,-2),G2(:,:,:,151))
  call check_last_Q_A(l_switch,G2(:,:,:,151),Q(:,63),ZERO,G3tensor(:,77))
  call loop_QV_A(G1(:,:,:,44),wf(:,-3),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,24),ZERO,G2(:,:,:,152))
  call loop_QV_A(G2(:,:,:,152),wf(:,20),G2(:,:,:,153))
  call loop_Q_A(G2(:,:,:,153),Q(:,59),ZERO,G3(:,:,:,54))
  call loop_QV_A(G3(:,:,:,54),wf(:,-2),G3(:,:,:,55))
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,63),ZERO,G4tensor(:,43))
  call loop_QV_A(G2(:,:,:,152),wf(:,-5),G2(:,:,:,154))
  call loop_Q_A(G2(:,:,:,154),Q(:,56),ZERO,G3(:,:,:,56))
  call loop_QV_A(G3(:,:,:,56),wf(:,8),G3(:,:,:,57))
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,63),ZERO,G4tensor(:,44))
  call loop_QV_A(G3(:,:,:,56),wf(:,39),G3(:,:,:,58))
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),ZERO,G4tensor(:,45))
  call loop_QV_A(G2(:,:,:,152),wf(:,45),G2(:,:,:,155))
  call loop_Q_A(G2(:,:,:,155),Q(:,59),ZERO,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,-2),G3(:,:,:,60))
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,63),ZERO,G4tensor(:,46))
  call loop_QV_A(G1(:,:,:,44),wf(:,28),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,52),ZERO,G2(:,:,:,156))
  call loop_QV_A(G2(:,:,:,156),wf(:,12),G2(:,:,:,157))
  call check_last_Q_A(l_switch,G2(:,:,:,157),Q(:,63),ZERO,G3tensor(:,78))
  call loop_QV_A(G2(:,:,:,156),wf(:,42),G2(:,:,:,158))
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,63),ZERO,G3tensor(:,79))
  call loop_QV_A(G1(:,:,:,44),wf(:,459),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,59),ZERO,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,-2),G2(:,:,:,160))
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,63),ZERO,G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,44),wf(:,12),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,27),ZERO,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,-5),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,59),ZERO,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62))
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),ZERO,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,44),wf(:,32),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,56),ZERO,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,8),G2(:,:,:,164))
  call check_last_Q_A(l_switch,G2(:,:,:,164),Q(:,63),ZERO,G3tensor(:,81))
  call loop_QV_A(G2(:,:,:,163),wf(:,39),G2(:,:,:,165))
  call check_last_Q_A(l_switch,G2(:,:,:,165),Q(:,63),ZERO,G3tensor(:,82))
  call loop_QV_A(G1(:,:,:,44),wf(:,462),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,55),ZERO,G2(:,:,:,166))
  call loop_QV_A(G2(:,:,:,166),wf(:,-3),G2(:,:,:,167))
  call check_last_Q_A(l_switch,G2(:,:,:,167),Q(:,63),ZERO,G3tensor(:,83))
  call loop_QV_A(G1(:,:,:,44),wf(:,45),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,51),ZERO,G2(:,:,:,168))
  call loop_QV_A(G2(:,:,:,168),wf(:,24),G2(:,:,:,169))
  call check_last_Q_A(l_switch,G2(:,:,:,169),Q(:,63),ZERO,G3tensor(:,84))
  call loop_QV_A(G1(:,:,:,44),wf(:,63),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,55),ZERO,G2(:,:,:,170))
  call loop_QV_A(G2(:,:,:,170),wf(:,-3),G2(:,:,:,171))
  call check_last_Q_A(l_switch,G2(:,:,:,171),Q(:,63),ZERO,G3tensor(:,85))
  call loop_QV_A(G1(:,:,:,44),wf(:,482),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,59),ZERO,G2(:,:,:,172))
  call loop_QV_A(G2(:,:,:,172),wf(:,-2),G2(:,:,:,173))
  call check_last_Q_A(l_switch,G2(:,:,:,173),Q(:,63),ZERO,G3tensor(:,86))
  call loop_QV_A(G1(:,:,:,44),wf(:,503),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,55),ZERO,G2(:,:,:,174))
  call loop_QV_A(G2(:,:,:,174),wf(:,-3),G2(:,:,:,175))
  call check_last_Q_A(l_switch,G2(:,:,:,175),Q(:,63),ZERO,G3tensor(:,87))
  call loop_QV_A(G1(:,:,:,44),wf(:,506),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,59),ZERO,G2(:,:,:,176))
  call loop_QV_A(G2(:,:,:,176),wf(:,-2),G2(:,:,:,177))
  call check_last_Q_A(l_switch,G2(:,:,:,177),Q(:,63),ZERO,G3tensor(:,88))
  call loop_QV_A(G1(:,:,:,44),wf(:,42),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,27),ZERO,G2(:,:,:,178))
  call loop_QV_A(G2(:,:,:,178),wf(:,-5),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,59),ZERO,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-2),G3(:,:,:,64))
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),ZERO,G4tensor(:,48))
  call loop_QV_A(G1(:,:,:,44),wf(:,510),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,55),ZERO,G2(:,:,:,180))
  call loop_QV_A(G2(:,:,:,180),wf(:,-3),G2(:,:,:,181))
  call check_last_Q_A(l_switch,G2(:,:,:,181),Q(:,63),ZERO,G3tensor(:,89))
  call loop_QV_A(G1(:,:,:,44),wf(:,511),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,59),ZERO,G2(:,:,:,182))
  call loop_QV_A(G2(:,:,:,182),wf(:,-2),G2(:,:,:,183))
  call check_last_Q_A(l_switch,G2(:,:,:,183),Q(:,63),ZERO,G3tensor(:,90))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-4),G1(:,:,:,69))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,27),G2(:,:,:,184))
  call check_last_DV_C(l_switch,G2(:,:,:,184),Q(:,59),wf(:,-2),G3tensor(:,91))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,31),G2(:,:,:,185))
  call check_last_DV_C(l_switch,G2(:,:,:,185),Q(:,55),wf(:,-3),G3tensor(:,92))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,-5),G2(:,:,:,186))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,35),G3tensor(:,93))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,43),G3tensor(:,94))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,46),G3tensor(:,95))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,461),G3tensor(:,96))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,464),G3tensor(:,97))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,61),G3tensor(:,98))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,501),G3tensor(:,99))
  call check_last_DV_C(l_switch,G2(:,:,:,186),Q(:,48),wf(:,504),G3tensor(:,100))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,37),G2(:,:,:,187))
  call check_last_DV_C(l_switch,G2(:,:,:,187),Q(:,59),wf(:,-2),G3tensor(:,101))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,40),G2(:,:,:,188))
  call check_last_DV_C(l_switch,G2(:,:,:,188),Q(:,55),wf(:,-3),G3tensor(:,102))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,20),G2(:,:,:,189))
  call check_last_DV_C(l_switch,G2(:,:,:,189),Q(:,51),wf(:,24),G3tensor(:,103))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,51),G2(:,:,:,190))
  call check_last_DV_C(l_switch,G2(:,:,:,190),Q(:,55),wf(:,-3),G3tensor(:,104))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,453),G2(:,:,:,191))
  call check_last_DV_C(l_switch,G2(:,:,:,191),Q(:,59),wf(:,-2),G3tensor(:,105))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,456),G2(:,:,:,192))
  call check_last_DV_C(l_switch,G2(:,:,:,192),Q(:,55),wf(:,-3),G3tensor(:,106))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,454),G2(:,:,:,193))
  call check_last_DV_C(l_switch,G2(:,:,:,193),Q(:,59),wf(:,-2),G3tensor(:,107))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,-3),G2(:,:,:,194))
  call loop_DV_C(G2(:,:,:,194),Q(:,24),wf(:,20),G3(:,:,:,65))
  call check_last_DV_C(l_switch,G3(:,:,:,65),Q(:,59),wf(:,-2),G4tensor(:,49))
  call loop_DV_C(G2(:,:,:,194),Q(:,24),wf(:,-5),G3(:,:,:,66))
  call check_last_DV_C(l_switch,G3(:,:,:,66),Q(:,56),wf(:,8),G4tensor(:,50))
  call check_last_DV_C(l_switch,G3(:,:,:,66),Q(:,56),wf(:,39),G4tensor(:,51))
  call loop_DV_C(G2(:,:,:,194),Q(:,24),wf(:,45),G3(:,:,:,67))
  call check_last_DV_C(l_switch,G3(:,:,:,67),Q(:,59),wf(:,-2),G4tensor(:,52))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,28),G2(:,:,:,195))
  call check_last_DV_C(l_switch,G2(:,:,:,195),Q(:,52),wf(:,12),G3tensor(:,108))
  call check_last_DV_C(l_switch,G2(:,:,:,195),Q(:,52),wf(:,42),G3tensor(:,109))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,459),G2(:,:,:,196))
  call check_last_DV_C(l_switch,G2(:,:,:,196),Q(:,59),wf(:,-2),G3tensor(:,110))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,12),G2(:,:,:,197))
  call loop_DV_C(G2(:,:,:,197),Q(:,27),wf(:,-5),G3(:,:,:,68))
  call check_last_DV_C(l_switch,G3(:,:,:,68),Q(:,59),wf(:,-2),G4tensor(:,53))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,32),G2(:,:,:,198))
  call check_last_DV_C(l_switch,G2(:,:,:,198),Q(:,56),wf(:,8),G3tensor(:,111))
  call check_last_DV_C(l_switch,G2(:,:,:,198),Q(:,56),wf(:,39),G3tensor(:,112))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,462),G2(:,:,:,199))
  call check_last_DV_C(l_switch,G2(:,:,:,199),Q(:,55),wf(:,-3),G3tensor(:,113))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,45),G2(:,:,:,200))
  call check_last_DV_C(l_switch,G2(:,:,:,200),Q(:,51),wf(:,24),G3tensor(:,114))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,63),G2(:,:,:,201))
  call check_last_DV_C(l_switch,G2(:,:,:,201),Q(:,55),wf(:,-3),G3tensor(:,115))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,482),G2(:,:,:,202))
  call check_last_DV_C(l_switch,G2(:,:,:,202),Q(:,59),wf(:,-2),G3tensor(:,116))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,503),G2(:,:,:,203))
  call check_last_DV_C(l_switch,G2(:,:,:,203),Q(:,55),wf(:,-3),G3tensor(:,117))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,506),G2(:,:,:,204))
  call check_last_DV_C(l_switch,G2(:,:,:,204),Q(:,59),wf(:,-2),G3tensor(:,118))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,42),G2(:,:,:,205))
  call loop_DV_C(G2(:,:,:,205),Q(:,27),wf(:,-5),G3(:,:,:,69))
  call check_last_DV_C(l_switch,G3(:,:,:,69),Q(:,59),wf(:,-2),G4tensor(:,54))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,510),G2(:,:,:,206))
  call check_last_DV_C(l_switch,G2(:,:,:,206),Q(:,55),wf(:,-3),G3tensor(:,119))
  call loop_DV_C(G1(:,:,:,69),Q(:,16),wf(:,511),G2(:,:,:,207))
  call check_last_DV_C(l_switch,G2(:,:,:,207),Q(:,59),wf(:,-2),G3tensor(:,120))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,70))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,27),Q(:,43),G2(:,:,:,208))
  call check_last_CV_D(l_switch,G2(:,:,:,208),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,121))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,31),Q(:,39),G2(:,:,:,209))
  call check_last_CV_D(l_switch,G2(:,:,:,209),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,122))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,210))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,35),Q(:,15),G3tensor(:,123))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,43),Q(:,15),G3tensor(:,124))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,46),Q(:,15),G3tensor(:,125))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,461),Q(:,15),G3tensor(:,126))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,464),Q(:,15),G3tensor(:,127))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,61),Q(:,15),G3tensor(:,128))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,501),Q(:,15),G3tensor(:,129))
  call check_last_CV_D(l_switch,G2(:,:,:,210),Q(:,48),wf(:,504),Q(:,15),G3tensor(:,130))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,37),Q(:,43),G2(:,:,:,211))
  call check_last_CV_D(l_switch,G2(:,:,:,211),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,131))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,40),Q(:,39),G2(:,:,:,212))
  call check_last_CV_D(l_switch,G2(:,:,:,212),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,132))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,20),Q(:,35),G2(:,:,:,213))
  call check_last_CV_D(l_switch,G2(:,:,:,213),Q(:,51),wf(:,24),Q(:,12),G3tensor(:,133))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,51),Q(:,39),G2(:,:,:,214))
  call check_last_CV_D(l_switch,G2(:,:,:,214),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,134))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,453),Q(:,43),G2(:,:,:,215))
  call check_last_CV_D(l_switch,G2(:,:,:,215),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,135))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,456),Q(:,39),G2(:,:,:,216))
  call check_last_CV_D(l_switch,G2(:,:,:,216),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,136))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,454),Q(:,43),G2(:,:,:,217))
  call check_last_CV_D(l_switch,G2(:,:,:,217),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,137))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,-3),Q(:,8),G2(:,:,:,218))
  call loop_CV_D(G2(:,:,:,218),Q(:,24),wf(:,20),Q(:,35),G3(:,:,:,70))
  call check_last_CV_D(l_switch,G3(:,:,:,70),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,55))
  call loop_CV_D(G2(:,:,:,218),Q(:,24),wf(:,-5),Q(:,32),G3(:,:,:,71))
  call check_last_CV_D(l_switch,G3(:,:,:,71),Q(:,56),wf(:,8),Q(:,7),G4tensor(:,56))
  call check_last_CV_D(l_switch,G3(:,:,:,71),Q(:,56),wf(:,39),Q(:,7),G4tensor(:,57))
  call loop_CV_D(G2(:,:,:,218),Q(:,24),wf(:,45),Q(:,35),G3(:,:,:,72))
  call check_last_CV_D(l_switch,G3(:,:,:,72),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,58))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,28),Q(:,36),G2(:,:,:,219))
  call check_last_CV_D(l_switch,G2(:,:,:,219),Q(:,52),wf(:,12),Q(:,11),G3tensor(:,138))
  call check_last_CV_D(l_switch,G2(:,:,:,219),Q(:,52),wf(:,42),Q(:,11),G3tensor(:,139))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,459),Q(:,43),G2(:,:,:,220))
  call check_last_CV_D(l_switch,G2(:,:,:,220),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,140))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,12),Q(:,11),G2(:,:,:,221))
  call loop_CV_D(G2(:,:,:,221),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,73))
  call check_last_CV_D(l_switch,G3(:,:,:,73),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,59))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,32),Q(:,40),G2(:,:,:,222))
  call check_last_CV_D(l_switch,G2(:,:,:,222),Q(:,56),wf(:,8),Q(:,7),G3tensor(:,141))
  call check_last_CV_D(l_switch,G2(:,:,:,222),Q(:,56),wf(:,39),Q(:,7),G3tensor(:,142))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,462),Q(:,39),G2(:,:,:,223))
  call check_last_CV_D(l_switch,G2(:,:,:,223),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,143))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,45),Q(:,35),G2(:,:,:,224))
  call check_last_CV_D(l_switch,G2(:,:,:,224),Q(:,51),wf(:,24),Q(:,12),G3tensor(:,144))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,63),Q(:,39),G2(:,:,:,225))
  call check_last_CV_D(l_switch,G2(:,:,:,225),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,145))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,482),Q(:,43),G2(:,:,:,226))
  call check_last_CV_D(l_switch,G2(:,:,:,226),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,146))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,503),Q(:,39),G2(:,:,:,227))
  call check_last_CV_D(l_switch,G2(:,:,:,227),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,147))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,506),Q(:,43),G2(:,:,:,228))
  call check_last_CV_D(l_switch,G2(:,:,:,228),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,148))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,42),Q(:,11),G2(:,:,:,229))
  call loop_CV_D(G2(:,:,:,229),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,74))
  call check_last_CV_D(l_switch,G3(:,:,:,74),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,60))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,510),Q(:,39),G2(:,:,:,230))
  call check_last_CV_D(l_switch,G2(:,:,:,230),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,149))
  call loop_CV_D(G1(:,:,:,70),Q(:,16),wf(:,511),Q(:,43),G2(:,:,:,231))
  call check_last_CV_D(l_switch,G2(:,:,:,231),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,150))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,27),ZERO,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,-5),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,59),ZERO,G2(:,:,:,232))
  call loop_QV_A(G2(:,:,:,232),wf(:,-2),G2(:,:,:,233))
  call check_last_Q_A(l_switch,G2(:,:,:,233),Q(:,63),ZERO,G3tensor(:,151))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,27),ZERO,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-5),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,59),ZERO,G2(:,:,:,234))
  call loop_AV_Q(G2(:,:,:,234),wf(:,-2),G2(:,:,:,235))
  call check_last_A_Q(l_switch,G2(:,:,:,235),Q(:,63),ZERO,G3tensor(:,152))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,29),Q(:,27),G1(:,:,:,75))
  call loop_CV_D(G1(:,:,:,75),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,236))
  call check_last_CV_D(l_switch,G2(:,:,:,236),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,153))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,29),G1(:,:,:,76))
  call loop_DV_C(G1(:,:,:,76),Q(:,27),wf(:,-5),G2(:,:,:,237))
  call check_last_DV_C(l_switch,G2(:,:,:,237),Q(:,59),wf(:,-2),G3tensor(:,154))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,29),Q(:,27),G1(:,:,:,77))
  call loop_UV_W(G1(:,:,:,77),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,238))
  call check_last_UV_W(l_switch,G2(:,:,:,238),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,155))
  call loop_QV_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,23),ZERO,G1(:,:,:,78))
  call loop_QV_A(G1(:,:,:,78),wf(:,-5),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,55),ZERO,G2(:,:,:,239))
  call loop_QV_A(G2(:,:,:,239),wf(:,-3),G2(:,:,:,240))
  call check_last_Q_A(l_switch,G2(:,:,:,240),Q(:,63),ZERO,G3tensor(:,156))
  call loop_AV_Q(G0(:,:,:,1),wf(:,33),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,23),ZERO,G1(:,:,:,80))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-5),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,55),ZERO,G2(:,:,:,241))
  call loop_AV_Q(G2(:,:,:,241),wf(:,-3),G2(:,:,:,242))
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,63),ZERO,G3tensor(:,157))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,33),Q(:,23),G1(:,:,:,82))
  call loop_CV_D(G1(:,:,:,82),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,243))
  call check_last_CV_D(l_switch,G2(:,:,:,243),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,158))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,33),G1(:,:,:,83))
  call loop_DV_C(G1(:,:,:,83),Q(:,23),wf(:,-5),G2(:,:,:,244))
  call check_last_DV_C(l_switch,G2(:,:,:,244),Q(:,55),wf(:,-3),G3tensor(:,159))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,33),Q(:,23),G1(:,:,:,84))
  call loop_UV_W(G1(:,:,:,84),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,245))
  call check_last_UV_W(l_switch,G2(:,:,:,245),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,160))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,26),Q(:,20),G1(:,:,:,85), Q(:,23))
  call loop_UV_W(G1(:,:,:,85),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,246))
  call check_last_UV_W(l_switch,G2(:,:,:,246),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,161))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,30),Q(:,24),G1(:,:,:,86), Q(:,27))
  call loop_UV_W(G1(:,:,:,86),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,247))
  call check_last_UV_W(l_switch,G2(:,:,:,247),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,162))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,39),G0(:,:,:,9))
  call loop_UV_W(G0(:,:,:,9),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,87))
  call check_last_UV_W(l_switch,G1(:,:,:,87),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,1))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,39),wf(:,-4),G0(:,:,:,10))
  call loop_UV_W(G0(:,:,:,10),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,88))
  call check_last_UV_W(l_switch,G1(:,:,:,88),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,2))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,39),G0(:,:,:,11))
  call loop_UV_W(G0(:,:,:,11),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,89))
  call check_last_UV_W(l_switch,G1(:,:,:,89),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,3))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,42),G0(:,:,:,12))
  call loop_UV_W(G0(:,:,:,12),Q(:,27),wf(:,-5),Q(:,32),G1(:,:,:,90))
  call check_last_UV_W(l_switch,G1(:,:,:,90),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,4))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,42),wf(:,-4),G0(:,:,:,13))
  call loop_UV_W(G0(:,:,:,13),Q(:,27),wf(:,-5),Q(:,32),G1(:,:,:,91))
  call check_last_UV_W(l_switch,G1(:,:,:,91),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,5))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,42),G0(:,:,:,14))
  call loop_UV_W(G0(:,:,:,14),Q(:,27),wf(:,-5),Q(:,32),G1(:,:,:,92))
  call check_last_UV_W(l_switch,G1(:,:,:,92),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,6))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,11),G1(:,:,:,93))
  call loop_GGG_G_12(G1(:,:,:,93),wf(:,-5),wf(:,-4),G1(:,:,:,94))
  call check_last_UV_W(l_switch,G1(:,:,:,94),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,7))
  call loop_GGG_G_12(G1(:,:,:,93),wf(:,-4),wf(:,-5),G1(:,:,:,95))
  call check_last_UV_W(l_switch,G1(:,:,:,95),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,8))
  call loop_GGG_G_23(G1(:,:,:,93),wf(:,-5),wf(:,-4),G1(:,:,:,96))
  call check_last_UV_W(l_switch,G1(:,:,:,96),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,9))
  call loop_UV_W(G1(:,:,:,93),Q(:,11),wf(:,34),Q(:,48),G2(:,:,:,248))
  call check_last_UV_W(l_switch,G2(:,:,:,248),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,163))
  call loop_UV_W(G1(:,:,:,93),Q(:,11),wf(:,-5),Q(:,32),G2(:,:,:,249))
  call loop_UV_W(G2(:,:,:,249),Q(:,43),wf(:,-4),Q(:,16),G3(:,:,:,75))
  call check_last_UV_W(l_switch,G3(:,:,:,75),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,61))
  call loop_UV_W(G1(:,:,:,93),Q(:,11),wf(:,-4),Q(:,16),G2(:,:,:,250))
  call loop_UV_W(G2(:,:,:,250),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,76))
  call check_last_UV_W(l_switch,G3(:,:,:,76),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,62))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,44),G0(:,:,:,15))
  call loop_UV_W(G0(:,:,:,15),Q(:,27),wf(:,-5),Q(:,32),G1(:,:,:,97))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,10))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,-3),G0(:,:,:,16))
  call loop_UV_W(G0(:,:,:,16),Q(:,27),wf(:,-5),Q(:,32),G1(:,:,:,98))
  call check_last_UV_W(l_switch,G1(:,:,:,98),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,11))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,44),G0(:,:,:,17))
  call loop_UV_W(G0(:,:,:,17),Q(:,27),wf(:,-5),Q(:,32),G1(:,:,:,99))
  call check_last_UV_W(l_switch,G1(:,:,:,99),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,12))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,19),G1(:,:,:,100))
  call loop_GGG_G_12(G1(:,:,:,100),wf(:,-5),wf(:,-3),G1(:,:,:,101))
  call check_last_UV_W(l_switch,G1(:,:,:,101),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,13))
  call loop_GGG_G_12(G1(:,:,:,100),wf(:,-3),wf(:,-5),G1(:,:,:,102))
  call check_last_UV_W(l_switch,G1(:,:,:,102),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,14))
  call loop_GGG_G_23(G1(:,:,:,100),wf(:,-5),wf(:,-3),G1(:,:,:,103))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,59),wf(:,-2),Q(:,4),G2tensor(:,15))
  call loop_GGG_G_12(G1(:,:,:,100),wf(:,-5),wf(:,-2),G1(:,:,:,104))
  call check_last_UV_W(l_switch,G1(:,:,:,104),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,16))
  call loop_GGG_G_12(G1(:,:,:,100),wf(:,-2),wf(:,-5),G1(:,:,:,105))
  call check_last_UV_W(l_switch,G1(:,:,:,105),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,17))
  call loop_GGG_G_23(G1(:,:,:,100),wf(:,-5),wf(:,-2),G1(:,:,:,106))
  call check_last_UV_W(l_switch,G1(:,:,:,106),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,18))
  call loop_UV_W(G1(:,:,:,100),Q(:,19),wf(:,-5),Q(:,32),G2(:,:,:,251))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,251),wf(:,-3),wf(:,-2),G2tensor(:,19))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,251),wf(:,-2),wf(:,-3),G2tensor(:,20))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,251),wf(:,-3),wf(:,-2),G2tensor(:,21))
  call check_last_UV_W(l_switch,G2(:,:,:,251),Q(:,51),wf(:,24),Q(:,12),G3tensor(:,164))
  call loop_UV_W(G1(:,:,:,100),Q(:,19),wf(:,28),Q(:,36),G2(:,:,:,252))
  call check_last_UV_W(l_switch,G2(:,:,:,252),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,165))
  call loop_UV_W(G1(:,:,:,100),Q(:,19),wf(:,32),Q(:,40),G2(:,:,:,253))
  call check_last_UV_W(l_switch,G2(:,:,:,253),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,166))
  call loop_UV_W(G1(:,:,:,100),Q(:,19),wf(:,-3),Q(:,8),G2(:,:,:,254))
  call loop_UV_W(G2(:,:,:,254),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,77))
  call check_last_UV_W(l_switch,G3(:,:,:,77),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,27),ZERO,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,59),ZERO,G2(:,:,:,255))
  call loop_QV_A(G2(:,:,:,255),wf(:,-2),G2(:,:,:,256))
  call check_last_Q_A(l_switch,G2(:,:,:,256),Q(:,63),ZERO,G3tensor(:,167))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,27),ZERO,G1(:,:,:,109))
  call loop_AV_Q(G1(:,:,:,109),wf(:,-5),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,59),ZERO,G2(:,:,:,257))
  call loop_AV_Q(G2(:,:,:,257),wf(:,-2),G2(:,:,:,258))
  call check_last_A_Q(l_switch,G2(:,:,:,258),Q(:,63),ZERO,G3tensor(:,168))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,38),Q(:,27),G1(:,:,:,111))
  call loop_CV_D(G1(:,:,:,111),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,259))
  call check_last_CV_D(l_switch,G2(:,:,:,259),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,169))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,38),G1(:,:,:,112))
  call loop_DV_C(G1(:,:,:,112),Q(:,27),wf(:,-5),G2(:,:,:,260))
  call check_last_DV_C(l_switch,G2(:,:,:,260),Q(:,59),wf(:,-2),G3tensor(:,170))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,38),Q(:,27),G1(:,:,:,113))
  call loop_UV_W(G1(:,:,:,113),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,261))
  call check_last_UV_W(l_switch,G2(:,:,:,261),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,171))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,44),G0(:,:,:,20))
  call loop_UV_W(G0(:,:,:,20),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,114))
  call check_last_UV_W(l_switch,G1(:,:,:,114),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,22))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,-2),G0(:,:,:,21))
  call loop_UV_W(G0(:,:,:,21),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,115))
  call check_last_UV_W(l_switch,G1(:,:,:,115),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,23))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,44),G0(:,:,:,22))
  call loop_UV_W(G0(:,:,:,22),Q(:,23),wf(:,-5),Q(:,32),G1(:,:,:,116))
  call check_last_UV_W(l_switch,G1(:,:,:,116),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,23),ZERO,G1(:,:,:,117))
  call loop_QV_A(G1(:,:,:,117),wf(:,-5),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,55),ZERO,G2(:,:,:,262))
  call loop_QV_A(G2(:,:,:,262),wf(:,-3),G2(:,:,:,263))
  call check_last_Q_A(l_switch,G2(:,:,:,263),Q(:,63),ZERO,G3tensor(:,172))
  call loop_AV_Q(G0(:,:,:,1),wf(:,41),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,23),ZERO,G1(:,:,:,119))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-5),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,55),ZERO,G2(:,:,:,264))
  call loop_AV_Q(G2(:,:,:,264),wf(:,-3),G2(:,:,:,265))
  call check_last_A_Q(l_switch,G2(:,:,:,265),Q(:,63),ZERO,G3tensor(:,173))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,41),Q(:,23),G1(:,:,:,121))
  call loop_CV_D(G1(:,:,:,121),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,266))
  call check_last_CV_D(l_switch,G2(:,:,:,266),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,174))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,41),G1(:,:,:,122))
  call loop_DV_C(G1(:,:,:,122),Q(:,23),wf(:,-5),G2(:,:,:,267))
  call check_last_DV_C(l_switch,G2(:,:,:,267),Q(:,55),wf(:,-3),G3tensor(:,175))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,41),Q(:,23),G1(:,:,:,123))
  call loop_UV_W(G1(:,:,:,123),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,268))
  call check_last_UV_W(l_switch,G2(:,:,:,268),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,176))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,47),Q(:,28),G1(:,:,:,124))
  call loop_UV_W(G1(:,:,:,124),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,269))
  call check_last_GHH_G(l_switch,G2(:,:,:,269),Q(:,60),wf(:,-1),wf(:,0),G4tensor(:,64), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,269),Q(:,60),wf(:,4),G4tensor(:,65), Q(:,63))
  call loop_AV_Q(G0(:,:,:,1),wf(:,16),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,19),ZERO,G1(:,:,:,125))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-5),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,51),ZERO,G2(:,:,:,270))
  call loop_AV_Q(G2(:,:,:,270),wf(:,24),G2(:,:,:,271))
  call check_last_A_Q(l_switch,G2(:,:,:,271),Q(:,63),ZERO,G3tensor(:,177))
  call loop_AV_Q(G1(:,:,:,125),wf(:,28),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,55),ZERO,G2(:,:,:,272))
  call loop_AV_Q(G2(:,:,:,272),wf(:,-3),G2(:,:,:,273))
  call check_last_A_Q(l_switch,G2(:,:,:,273),Q(:,63),ZERO,G3tensor(:,178))
  call loop_AV_Q(G1(:,:,:,125),wf(:,32),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,59),ZERO,G2(:,:,:,274))
  call loop_AV_Q(G2(:,:,:,274),wf(:,-2),G2(:,:,:,275))
  call check_last_A_Q(l_switch,G2(:,:,:,275),Q(:,63),ZERO,G3tensor(:,179))
  call loop_AV_Q(G1(:,:,:,125),wf(:,-3),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,27),ZERO,G2(:,:,:,276))
  call loop_AV_Q(G2(:,:,:,276),wf(:,-5),G2(:,:,:,277))
  call loop_A_Q(G2(:,:,:,277),Q(:,59),ZERO,G3(:,:,:,78))
  call loop_AV_Q(G3(:,:,:,78),wf(:,-2),G3(:,:,:,79))
  call check_last_A_Q(l_switch,G3(:,:,:,79),Q(:,63),ZERO,G4tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,19),ZERO,G1(:,:,:,130))
  call loop_QV_A(G1(:,:,:,130),wf(:,-5),G1(:,:,:,131))
  call loop_Q_A(G1(:,:,:,131),Q(:,51),ZERO,G2(:,:,:,278))
  call loop_QV_A(G2(:,:,:,278),wf(:,24),G2(:,:,:,279))
  call check_last_Q_A(l_switch,G2(:,:,:,279),Q(:,63),ZERO,G3tensor(:,180))
  call loop_QV_A(G1(:,:,:,130),wf(:,28),G1(:,:,:,132))
  call loop_Q_A(G1(:,:,:,132),Q(:,55),ZERO,G2(:,:,:,280))
  call loop_QV_A(G2(:,:,:,280),wf(:,-3),G2(:,:,:,281))
  call check_last_Q_A(l_switch,G2(:,:,:,281),Q(:,63),ZERO,G3tensor(:,181))
  call loop_QV_A(G1(:,:,:,130),wf(:,32),G1(:,:,:,133))
  call loop_Q_A(G1(:,:,:,133),Q(:,59),ZERO,G2(:,:,:,282))
  call loop_QV_A(G2(:,:,:,282),wf(:,-2),G2(:,:,:,283))
  call check_last_Q_A(l_switch,G2(:,:,:,283),Q(:,63),ZERO,G3tensor(:,182))
  call loop_QV_A(G1(:,:,:,130),wf(:,-3),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,27),ZERO,G2(:,:,:,284))
  call loop_QV_A(G2(:,:,:,284),wf(:,-5),G2(:,:,:,285))
  call loop_Q_A(G2(:,:,:,285),Q(:,59),ZERO,G3(:,:,:,80))
  call loop_QV_A(G3(:,:,:,80),wf(:,-2),G3(:,:,:,81))
  call check_last_Q_A(l_switch,G3(:,:,:,81),Q(:,63),ZERO,G4tensor(:,67))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,16),G1(:,:,:,135))
  call loop_DV_C(G1(:,:,:,135),Q(:,19),wf(:,-5),G2(:,:,:,286))
  call check_last_DV_C(l_switch,G2(:,:,:,286),Q(:,51),wf(:,24),G3tensor(:,183))
  call loop_DV_C(G1(:,:,:,135),Q(:,19),wf(:,28),G2(:,:,:,287))
  call check_last_DV_C(l_switch,G2(:,:,:,287),Q(:,55),wf(:,-3),G3tensor(:,184))
  call loop_DV_C(G1(:,:,:,135),Q(:,19),wf(:,32),G2(:,:,:,288))
  call check_last_DV_C(l_switch,G2(:,:,:,288),Q(:,59),wf(:,-2),G3tensor(:,185))
  call loop_DV_C(G1(:,:,:,135),Q(:,19),wf(:,-3),G2(:,:,:,289))
  call loop_DV_C(G2(:,:,:,289),Q(:,27),wf(:,-5),G3(:,:,:,82))
  call check_last_DV_C(l_switch,G3(:,:,:,82),Q(:,59),wf(:,-2),G4tensor(:,68))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,19),G1(:,:,:,136))
  call loop_CV_D(G1(:,:,:,136),Q(:,19),wf(:,-5),Q(:,32),G2(:,:,:,290))
  call check_last_CV_D(l_switch,G2(:,:,:,290),Q(:,51),wf(:,24),Q(:,12),G3tensor(:,186))
  call loop_CV_D(G1(:,:,:,136),Q(:,19),wf(:,28),Q(:,36),G2(:,:,:,291))
  call check_last_CV_D(l_switch,G2(:,:,:,291),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,187))
  call loop_CV_D(G1(:,:,:,136),Q(:,19),wf(:,32),Q(:,40),G2(:,:,:,292))
  call check_last_CV_D(l_switch,G2(:,:,:,292),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,188))
  call loop_CV_D(G1(:,:,:,136),Q(:,19),wf(:,-3),Q(:,8),G2(:,:,:,293))
  call loop_CV_D(G2(:,:,:,293),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,83))
  call check_last_CV_D(l_switch,G3(:,:,:,83),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,69))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,50),Q(:,28),G1(:,:,:,137))
  call loop_UV_W(G1(:,:,:,137),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,294))
  call check_last_GHH_G(l_switch,G2(:,:,:,294),Q(:,60),wf(:,-1),wf(:,0),G4tensor(:,70), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,294),Q(:,60),wf(:,4),G4tensor(:,71), Q(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,23),ZERO,G1(:,:,:,138))
  call loop_QV_A(G1(:,:,:,138),wf(:,-5),G1(:,:,:,139))
  call loop_Q_A(G1(:,:,:,139),Q(:,55),ZERO,G2(:,:,:,295))
  call loop_QV_A(G2(:,:,:,295),wf(:,-3),G2(:,:,:,296))
  call check_last_Q_A(l_switch,G2(:,:,:,296),Q(:,63),ZERO,G3tensor(:,189))
  call loop_AV_Q(G0(:,:,:,1),wf(:,49),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,23),ZERO,G1(:,:,:,140))
  call loop_AV_Q(G1(:,:,:,140),wf(:,-5),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,55),ZERO,G2(:,:,:,297))
  call loop_AV_Q(G2(:,:,:,297),wf(:,-3),G2(:,:,:,298))
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,63),ZERO,G3tensor(:,190))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,49),Q(:,23),G1(:,:,:,142))
  call loop_CV_D(G1(:,:,:,142),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,299))
  call check_last_CV_D(l_switch,G2(:,:,:,299),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,191))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,49),G1(:,:,:,143))
  call loop_DV_C(G1(:,:,:,143),Q(:,23),wf(:,-5),G2(:,:,:,300))
  call check_last_DV_C(l_switch,G2(:,:,:,300),Q(:,55),wf(:,-3),G3tensor(:,192))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,49),Q(:,23),G1(:,:,:,144))
  call loop_UV_W(G1(:,:,:,144),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,301))
  call check_last_UV_W(l_switch,G2(:,:,:,301),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,193))
  call loop_AV_Q(G0(:,:,:,1),wf(:,26),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,20),ZERO,G1(:,:,:,145))
  call loop_AV_Q(G1(:,:,:,145),wf(:,20),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,55),ZERO,G2(:,:,:,302))
  call loop_AV_Q(G2(:,:,:,302),wf(:,-3),G2(:,:,:,303))
  call check_last_A_Q(l_switch,G2(:,:,:,303),Q(:,63),ZERO,G3tensor(:,194))
  call loop_AV_Q(G1(:,:,:,145),wf(:,-5),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,52),ZERO,G2(:,:,:,304))
  call loop_AV_Q(G2(:,:,:,304),wf(:,12),G2(:,:,:,305))
  call check_last_A_Q(l_switch,G2(:,:,:,305),Q(:,63),ZERO,G3tensor(:,195))
  call loop_AV_Q(G2(:,:,:,304),wf(:,42),G2(:,:,:,306))
  call check_last_A_Q(l_switch,G2(:,:,:,306),Q(:,63),ZERO,G3tensor(:,196))
  call loop_AV_Q(G1(:,:,:,145),wf(:,45),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,55),ZERO,G2(:,:,:,307))
  call loop_AV_Q(G2(:,:,:,307),wf(:,-3),G2(:,:,:,308))
  call check_last_A_Q(l_switch,G2(:,:,:,308),Q(:,63),ZERO,G3tensor(:,197))
  call loop_QV_A(G0(:,:,:,1),wf(:,26),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,20),ZERO,G1(:,:,:,149))
  call loop_QV_A(G1(:,:,:,149),wf(:,20),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,55),ZERO,G2(:,:,:,309))
  call loop_QV_A(G2(:,:,:,309),wf(:,-3),G2(:,:,:,310))
  call check_last_Q_A(l_switch,G2(:,:,:,310),Q(:,63),ZERO,G3tensor(:,198))
  call loop_QV_A(G1(:,:,:,149),wf(:,-5),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,52),ZERO,G2(:,:,:,311))
  call loop_QV_A(G2(:,:,:,311),wf(:,12),G2(:,:,:,312))
  call check_last_Q_A(l_switch,G2(:,:,:,312),Q(:,63),ZERO,G3tensor(:,199))
  call loop_QV_A(G2(:,:,:,311),wf(:,42),G2(:,:,:,313))
  call check_last_Q_A(l_switch,G2(:,:,:,313),Q(:,63),ZERO,G3tensor(:,200))
  call loop_QV_A(G1(:,:,:,149),wf(:,45),G1(:,:,:,152))
  call loop_Q_A(G1(:,:,:,152),Q(:,55),ZERO,G2(:,:,:,314))
  call loop_QV_A(G2(:,:,:,314),wf(:,-3),G2(:,:,:,315))
  call check_last_Q_A(l_switch,G2(:,:,:,315),Q(:,63),ZERO,G3tensor(:,201))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,26),G1(:,:,:,153))
  call loop_DV_C(G1(:,:,:,153),Q(:,20),wf(:,20),G2(:,:,:,316))
  call check_last_DV_C(l_switch,G2(:,:,:,316),Q(:,55),wf(:,-3),G3tensor(:,202))
  call loop_DV_C(G1(:,:,:,153),Q(:,20),wf(:,-5),G2(:,:,:,317))
  call check_last_DV_C(l_switch,G2(:,:,:,317),Q(:,52),wf(:,12),G3tensor(:,203))
  call check_last_DV_C(l_switch,G2(:,:,:,317),Q(:,52),wf(:,42),G3tensor(:,204))
  call loop_DV_C(G1(:,:,:,153),Q(:,20),wf(:,45),G2(:,:,:,318))
  call check_last_DV_C(l_switch,G2(:,:,:,318),Q(:,55),wf(:,-3),G3tensor(:,205))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,26),Q(:,20),G1(:,:,:,154))
  call loop_CV_D(G1(:,:,:,154),Q(:,20),wf(:,20),Q(:,35),G2(:,:,:,319))
  call check_last_CV_D(l_switch,G2(:,:,:,319),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,206))
  call loop_CV_D(G1(:,:,:,154),Q(:,20),wf(:,-5),Q(:,32),G2(:,:,:,320))
  call check_last_CV_D(l_switch,G2(:,:,:,320),Q(:,52),wf(:,12),Q(:,11),G3tensor(:,207))
  call check_last_CV_D(l_switch,G2(:,:,:,320),Q(:,52),wf(:,42),Q(:,11),G3tensor(:,208))
  call loop_CV_D(G1(:,:,:,154),Q(:,20),wf(:,45),Q(:,35),G2(:,:,:,321))
  call check_last_CV_D(l_switch,G2(:,:,:,321),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,209))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,28),G1(:,:,:,155))
  call loop_UV_W(G1(:,:,:,155),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,322))
  call check_last_GHH_G(l_switch,G2(:,:,:,322),Q(:,60),wf(:,-1),wf(:,0),G4tensor(:,72), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,322),Q(:,60),wf(:,4),G4tensor(:,73), Q(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,455),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,27),ZERO,G1(:,:,:,156))
  call loop_QV_A(G1(:,:,:,156),wf(:,-5),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,59),ZERO,G2(:,:,:,323))
  call loop_QV_A(G2(:,:,:,323),wf(:,-2),G2(:,:,:,324))
  call check_last_Q_A(l_switch,G2(:,:,:,324),Q(:,63),ZERO,G3tensor(:,210))
  call loop_AV_Q(G0(:,:,:,1),wf(:,455),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,27),ZERO,G1(:,:,:,158))
  call loop_AV_Q(G1(:,:,:,158),wf(:,-5),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,59),ZERO,G2(:,:,:,325))
  call loop_AV_Q(G2(:,:,:,325),wf(:,-2),G2(:,:,:,326))
  call check_last_A_Q(l_switch,G2(:,:,:,326),Q(:,63),ZERO,G3tensor(:,211))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,455),Q(:,27),G1(:,:,:,160))
  call loop_CV_D(G1(:,:,:,160),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,327))
  call check_last_CV_D(l_switch,G2(:,:,:,327),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,212))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,455),G1(:,:,:,161))
  call loop_DV_C(G1(:,:,:,161),Q(:,27),wf(:,-5),G2(:,:,:,328))
  call check_last_DV_C(l_switch,G2(:,:,:,328),Q(:,59),wf(:,-2),G3tensor(:,213))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,455),Q(:,27),G1(:,:,:,162))
  call loop_UV_W(G1(:,:,:,162),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,329))
  call check_last_UV_W(l_switch,G2(:,:,:,329),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,214))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,24),ZERO,G1(:,:,:,163))
  call loop_AV_Q(G1(:,:,:,163),wf(:,20),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,59),ZERO,G2(:,:,:,330))
  call loop_AV_Q(G2(:,:,:,330),wf(:,-2),G2(:,:,:,331))
  call check_last_A_Q(l_switch,G2(:,:,:,331),Q(:,63),ZERO,G3tensor(:,215))
  call loop_AV_Q(G1(:,:,:,163),wf(:,-5),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,56),ZERO,G2(:,:,:,332))
  call loop_AV_Q(G2(:,:,:,332),wf(:,8),G2(:,:,:,333))
  call check_last_A_Q(l_switch,G2(:,:,:,333),Q(:,63),ZERO,G3tensor(:,216))
  call loop_AV_Q(G2(:,:,:,332),wf(:,39),G2(:,:,:,334))
  call check_last_A_Q(l_switch,G2(:,:,:,334),Q(:,63),ZERO,G3tensor(:,217))
  call loop_AV_Q(G1(:,:,:,163),wf(:,45),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,59),ZERO,G2(:,:,:,335))
  call loop_AV_Q(G2(:,:,:,335),wf(:,-2),G2(:,:,:,336))
  call check_last_A_Q(l_switch,G2(:,:,:,336),Q(:,63),ZERO,G3tensor(:,218))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,24),ZERO,G1(:,:,:,167))
  call loop_QV_A(G1(:,:,:,167),wf(:,20),G1(:,:,:,168))
  call loop_Q_A(G1(:,:,:,168),Q(:,59),ZERO,G2(:,:,:,337))
  call loop_QV_A(G2(:,:,:,337),wf(:,-2),G2(:,:,:,338))
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,63),ZERO,G3tensor(:,219))
  call loop_QV_A(G1(:,:,:,167),wf(:,-5),G1(:,:,:,169))
  call loop_Q_A(G1(:,:,:,169),Q(:,56),ZERO,G2(:,:,:,339))
  call loop_QV_A(G2(:,:,:,339),wf(:,8),G2(:,:,:,340))
  call check_last_Q_A(l_switch,G2(:,:,:,340),Q(:,63),ZERO,G3tensor(:,220))
  call loop_QV_A(G2(:,:,:,339),wf(:,39),G2(:,:,:,341))
  call check_last_Q_A(l_switch,G2(:,:,:,341),Q(:,63),ZERO,G3tensor(:,221))
  call loop_QV_A(G1(:,:,:,167),wf(:,45),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,59),ZERO,G2(:,:,:,342))
  call loop_QV_A(G2(:,:,:,342),wf(:,-2),G2(:,:,:,343))
  call check_last_Q_A(l_switch,G2(:,:,:,343),Q(:,63),ZERO,G3tensor(:,222))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,30),G1(:,:,:,171))
  call loop_DV_C(G1(:,:,:,171),Q(:,24),wf(:,20),G2(:,:,:,344))
  call check_last_DV_C(l_switch,G2(:,:,:,344),Q(:,59),wf(:,-2),G3tensor(:,223))
  call loop_DV_C(G1(:,:,:,171),Q(:,24),wf(:,-5),G2(:,:,:,345))
  call check_last_DV_C(l_switch,G2(:,:,:,345),Q(:,56),wf(:,8),G3tensor(:,224))
  call check_last_DV_C(l_switch,G2(:,:,:,345),Q(:,56),wf(:,39),G3tensor(:,225))
  call loop_DV_C(G1(:,:,:,171),Q(:,24),wf(:,45),G2(:,:,:,346))
  call check_last_DV_C(l_switch,G2(:,:,:,346),Q(:,59),wf(:,-2),G3tensor(:,226))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,30),Q(:,24),G1(:,:,:,172))
  call loop_CV_D(G1(:,:,:,172),Q(:,24),wf(:,20),Q(:,35),G2(:,:,:,347))
  call check_last_CV_D(l_switch,G2(:,:,:,347),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,227))
  call loop_CV_D(G1(:,:,:,172),Q(:,24),wf(:,-5),Q(:,32),G2(:,:,:,348))
  call check_last_CV_D(l_switch,G2(:,:,:,348),Q(:,56),wf(:,8),Q(:,7),G3tensor(:,228))
  call check_last_CV_D(l_switch,G2(:,:,:,348),Q(:,56),wf(:,39),Q(:,7),G3tensor(:,229))
  call loop_CV_D(G1(:,:,:,172),Q(:,24),wf(:,45),Q(:,35),G2(:,:,:,349))
  call check_last_CV_D(l_switch,G2(:,:,:,349),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,230))
  call loop_QV_A(G0(:,:,:,1),wf(:,458),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,23),ZERO,G1(:,:,:,173))
  call loop_QV_A(G1(:,:,:,173),wf(:,-5),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,55),ZERO,G2(:,:,:,350))
  call loop_QV_A(G2(:,:,:,350),wf(:,-3),G2(:,:,:,351))
  call check_last_Q_A(l_switch,G2(:,:,:,351),Q(:,63),ZERO,G3tensor(:,231))
  call loop_AV_Q(G0(:,:,:,1),wf(:,458),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,23),ZERO,G1(:,:,:,175))
  call loop_AV_Q(G1(:,:,:,175),wf(:,-5),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,55),ZERO,G2(:,:,:,352))
  call loop_AV_Q(G2(:,:,:,352),wf(:,-3),G2(:,:,:,353))
  call check_last_A_Q(l_switch,G2(:,:,:,353),Q(:,63),ZERO,G3tensor(:,232))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,458),Q(:,23),G1(:,:,:,177))
  call loop_CV_D(G1(:,:,:,177),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,354))
  call check_last_CV_D(l_switch,G2(:,:,:,354),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,233))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,458),G1(:,:,:,178))
  call loop_DV_C(G1(:,:,:,178),Q(:,23),wf(:,-5),G2(:,:,:,355))
  call check_last_DV_C(l_switch,G2(:,:,:,355),Q(:,55),wf(:,-3),G3tensor(:,234))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,458),Q(:,23),G1(:,:,:,179))
  call loop_UV_W(G1(:,:,:,179),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,356))
  call check_last_UV_W(l_switch,G2(:,:,:,356),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,235))
  call loop_QV_A(G0(:,:,:,1),wf(:,457),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,27),ZERO,G1(:,:,:,180))
  call loop_QV_A(G1(:,:,:,180),wf(:,-5),G1(:,:,:,181))
  call loop_Q_A(G1(:,:,:,181),Q(:,59),ZERO,G2(:,:,:,357))
  call loop_QV_A(G2(:,:,:,357),wf(:,-2),G2(:,:,:,358))
  call check_last_Q_A(l_switch,G2(:,:,:,358),Q(:,63),ZERO,G3tensor(:,236))
  call loop_AV_Q(G0(:,:,:,1),wf(:,457),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,27),ZERO,G1(:,:,:,182))
  call loop_AV_Q(G1(:,:,:,182),wf(:,-5),G1(:,:,:,183))
  call loop_A_Q(G1(:,:,:,183),Q(:,59),ZERO,G2(:,:,:,359))
  call loop_AV_Q(G2(:,:,:,359),wf(:,-2),G2(:,:,:,360))
  call check_last_A_Q(l_switch,G2(:,:,:,360),Q(:,63),ZERO,G3tensor(:,237))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,457),Q(:,27),G1(:,:,:,184))
  call loop_CV_D(G1(:,:,:,184),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,361))
  call check_last_CV_D(l_switch,G2(:,:,:,361),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,238))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,457),G1(:,:,:,185))
  call loop_DV_C(G1(:,:,:,185),Q(:,27),wf(:,-5),G2(:,:,:,362))
  call check_last_DV_C(l_switch,G2(:,:,:,362),Q(:,59),wf(:,-2),G3tensor(:,239))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,457),Q(:,27),G1(:,:,:,186))
  call loop_UV_W(G1(:,:,:,186),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,363))
  call check_last_UV_W(l_switch,G2(:,:,:,363),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,240))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,11),ZERO,G1(:,:,:,187))
  call loop_QV_A(G1(:,:,:,187),wf(:,34),G1(:,:,:,188))
  call loop_Q_A(G1(:,:,:,188),Q(:,59),ZERO,G2(:,:,:,364))
  call loop_QV_A(G2(:,:,:,364),wf(:,-2),G2(:,:,:,365))
  call check_last_Q_A(l_switch,G2(:,:,:,365),Q(:,63),ZERO,G3tensor(:,241))
  call loop_QV_A(G1(:,:,:,187),wf(:,-5),G1(:,:,:,189))
  call loop_Q_A(G1(:,:,:,189),Q(:,43),ZERO,G2(:,:,:,366))
  call loop_QV_A(G2(:,:,:,366),wf(:,-4),G2(:,:,:,367))
  call loop_Q_A(G2(:,:,:,367),Q(:,59),ZERO,G3(:,:,:,84))
  call loop_QV_A(G3(:,:,:,84),wf(:,-2),G3(:,:,:,85))
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,63),ZERO,G4tensor(:,74))
  call loop_QV_A(G1(:,:,:,187),wf(:,-4),G1(:,:,:,190))
  call loop_Q_A(G1(:,:,:,190),Q(:,27),ZERO,G2(:,:,:,368))
  call loop_QV_A(G2(:,:,:,368),wf(:,-5),G2(:,:,:,369))
  call loop_Q_A(G2(:,:,:,369),Q(:,59),ZERO,G3(:,:,:,86))
  call loop_QV_A(G3(:,:,:,86),wf(:,-2),G3(:,:,:,87))
  call check_last_Q_A(l_switch,G3(:,:,:,87),Q(:,63),ZERO,G4tensor(:,75))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,11),ZERO,G1(:,:,:,191))
  call loop_AV_Q(G1(:,:,:,191),wf(:,34),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,59),ZERO,G2(:,:,:,370))
  call loop_AV_Q(G2(:,:,:,370),wf(:,-2),G2(:,:,:,371))
  call check_last_A_Q(l_switch,G2(:,:,:,371),Q(:,63),ZERO,G3tensor(:,242))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-5),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,43),ZERO,G2(:,:,:,372))
  call loop_AV_Q(G2(:,:,:,372),wf(:,-4),G2(:,:,:,373))
  call loop_A_Q(G2(:,:,:,373),Q(:,59),ZERO,G3(:,:,:,88))
  call loop_AV_Q(G3(:,:,:,88),wf(:,-2),G3(:,:,:,89))
  call check_last_A_Q(l_switch,G3(:,:,:,89),Q(:,63),ZERO,G4tensor(:,76))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-4),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,27),ZERO,G2(:,:,:,374))
  call loop_AV_Q(G2(:,:,:,374),wf(:,-5),G2(:,:,:,375))
  call loop_A_Q(G2(:,:,:,375),Q(:,59),ZERO,G3(:,:,:,90))
  call loop_AV_Q(G3(:,:,:,90),wf(:,-2),G3(:,:,:,91))
  call check_last_A_Q(l_switch,G3(:,:,:,91),Q(:,63),ZERO,G4tensor(:,77))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,11),G1(:,:,:,195))
  call loop_CV_D(G1(:,:,:,195),Q(:,11),wf(:,34),Q(:,48),G2(:,:,:,376))
  call check_last_CV_D(l_switch,G2(:,:,:,376),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,243))
  call loop_CV_D(G1(:,:,:,195),Q(:,11),wf(:,-5),Q(:,32),G2(:,:,:,377))
  call loop_CV_D(G2(:,:,:,377),Q(:,43),wf(:,-4),Q(:,16),G3(:,:,:,92))
  call check_last_CV_D(l_switch,G3(:,:,:,92),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,78))
  call loop_CV_D(G1(:,:,:,195),Q(:,11),wf(:,-4),Q(:,16),G2(:,:,:,378))
  call loop_CV_D(G2(:,:,:,378),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,93))
  call check_last_CV_D(l_switch,G3(:,:,:,93),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,79))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,12),G1(:,:,:,196))
  call loop_DV_C(G1(:,:,:,196),Q(:,11),wf(:,34),G2(:,:,:,379))
  call check_last_DV_C(l_switch,G2(:,:,:,379),Q(:,59),wf(:,-2),G3tensor(:,244))
  call loop_DV_C(G1(:,:,:,196),Q(:,11),wf(:,-5),G2(:,:,:,380))
  call loop_DV_C(G2(:,:,:,380),Q(:,43),wf(:,-4),G3(:,:,:,94))
  call check_last_DV_C(l_switch,G3(:,:,:,94),Q(:,59),wf(:,-2),G4tensor(:,80))
  call loop_DV_C(G1(:,:,:,196),Q(:,11),wf(:,-4),G2(:,:,:,381))
  call loop_DV_C(G2(:,:,:,381),Q(:,27),wf(:,-5),G3(:,:,:,95))
  call check_last_DV_C(l_switch,G3(:,:,:,95),Q(:,59),wf(:,-2),G4tensor(:,81))
  call loop_QV_A(G0(:,:,:,1),wf(:,460),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,27),ZERO,G1(:,:,:,197))
  call loop_QV_A(G1(:,:,:,197),wf(:,-5),G1(:,:,:,198))
  call loop_Q_A(G1(:,:,:,198),Q(:,59),ZERO,G2(:,:,:,382))
  call loop_QV_A(G2(:,:,:,382),wf(:,-2),G2(:,:,:,383))
  call check_last_Q_A(l_switch,G2(:,:,:,383),Q(:,63),ZERO,G3tensor(:,245))
  call loop_AV_Q(G0(:,:,:,1),wf(:,460),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,27),ZERO,G1(:,:,:,199))
  call loop_AV_Q(G1(:,:,:,199),wf(:,-5),G1(:,:,:,200))
  call loop_A_Q(G1(:,:,:,200),Q(:,59),ZERO,G2(:,:,:,384))
  call loop_AV_Q(G2(:,:,:,384),wf(:,-2),G2(:,:,:,385))
  call check_last_A_Q(l_switch,G2(:,:,:,385),Q(:,63),ZERO,G3tensor(:,246))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,460),Q(:,27),G1(:,:,:,201))
  call loop_CV_D(G1(:,:,:,201),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,386))
  call check_last_CV_D(l_switch,G2(:,:,:,386),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,247))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,460),G1(:,:,:,202))
  call loop_DV_C(G1(:,:,:,202),Q(:,27),wf(:,-5),G2(:,:,:,387))
  call check_last_DV_C(l_switch,G2(:,:,:,387),Q(:,59),wf(:,-2),G3tensor(:,248))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,460),Q(:,27),G1(:,:,:,203))
  call loop_UV_W(G1(:,:,:,203),Q(:,27),wf(:,-5),Q(:,32),G2(:,:,:,388))
  call check_last_UV_W(l_switch,G2(:,:,:,388),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,249))
  call loop_QV_A(G0(:,:,:,1),wf(:,463),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,23),ZERO,G1(:,:,:,204))
  call loop_QV_A(G1(:,:,:,204),wf(:,-5),G1(:,:,:,205))
  call loop_Q_A(G1(:,:,:,205),Q(:,55),ZERO,G2(:,:,:,389))
  call loop_QV_A(G2(:,:,:,389),wf(:,-3),G2(:,:,:,390))
  call check_last_Q_A(l_switch,G2(:,:,:,390),Q(:,63),ZERO,G3tensor(:,250))
  call loop_AV_Q(G0(:,:,:,1),wf(:,463),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,23),ZERO,G1(:,:,:,206))
  call loop_AV_Q(G1(:,:,:,206),wf(:,-5),G1(:,:,:,207))
  call loop_A_Q(G1(:,:,:,207),Q(:,55),ZERO,G2(:,:,:,391))
  call loop_AV_Q(G2(:,:,:,391),wf(:,-3),G2(:,:,:,392))
  call check_last_A_Q(l_switch,G2(:,:,:,392),Q(:,63),ZERO,G3tensor(:,251))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,463),Q(:,23),G1(:,:,:,208))
  call loop_CV_D(G1(:,:,:,208),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,393))
  call check_last_CV_D(l_switch,G2(:,:,:,393),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,252))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,463),G1(:,:,:,209))
  call loop_DV_C(G1(:,:,:,209),Q(:,23),wf(:,-5),G2(:,:,:,394))
  call check_last_DV_C(l_switch,G2(:,:,:,394),Q(:,55),wf(:,-3),G3tensor(:,253))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,463),Q(:,23),G1(:,:,:,210))
  call loop_UV_W(G1(:,:,:,210),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,395))
  call check_last_UV_W(l_switch,G2(:,:,:,395),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,254))
  call loop_AV_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,19),ZERO,G1(:,:,:,211))
  call loop_AV_Q(G1(:,:,:,211),wf(:,-5),G1(:,:,:,212))
  call loop_A_Q(G1(:,:,:,212),Q(:,51),ZERO,G2(:,:,:,396))
  call loop_AV_Q(G2(:,:,:,396),wf(:,24),G2(:,:,:,397))
  call check_last_A_Q(l_switch,G2(:,:,:,397),Q(:,63),ZERO,G3tensor(:,255))
  call loop_AV_Q(G1(:,:,:,211),wf(:,28),G1(:,:,:,213))
  call loop_A_Q(G1(:,:,:,213),Q(:,55),ZERO,G2(:,:,:,398))
  call loop_AV_Q(G2(:,:,:,398),wf(:,-3),G2(:,:,:,399))
  call check_last_A_Q(l_switch,G2(:,:,:,399),Q(:,63),ZERO,G3tensor(:,256))
  call loop_AV_Q(G1(:,:,:,211),wf(:,32),G1(:,:,:,214))
  call loop_A_Q(G1(:,:,:,214),Q(:,59),ZERO,G2(:,:,:,400))
  call loop_AV_Q(G2(:,:,:,400),wf(:,-2),G2(:,:,:,401))
  call check_last_A_Q(l_switch,G2(:,:,:,401),Q(:,63),ZERO,G3tensor(:,257))
  call loop_AV_Q(G1(:,:,:,211),wf(:,-3),G1(:,:,:,215))
  call loop_A_Q(G1(:,:,:,215),Q(:,27),ZERO,G2(:,:,:,402))
  call loop_AV_Q(G2(:,:,:,402),wf(:,-5),G2(:,:,:,403))
  call loop_A_Q(G2(:,:,:,403),Q(:,59),ZERO,G3(:,:,:,96))
  call loop_AV_Q(G3(:,:,:,96),wf(:,-2),G3(:,:,:,97))
  call check_last_A_Q(l_switch,G3(:,:,:,97),Q(:,63),ZERO,G4tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,19),ZERO,G1(:,:,:,216))
  call loop_QV_A(G1(:,:,:,216),wf(:,-5),G1(:,:,:,217))
  call loop_Q_A(G1(:,:,:,217),Q(:,51),ZERO,G2(:,:,:,404))
  call loop_QV_A(G2(:,:,:,404),wf(:,24),G2(:,:,:,405))
  call check_last_Q_A(l_switch,G2(:,:,:,405),Q(:,63),ZERO,G3tensor(:,258))
  call loop_QV_A(G1(:,:,:,216),wf(:,28),G1(:,:,:,218))
  call loop_Q_A(G1(:,:,:,218),Q(:,55),ZERO,G2(:,:,:,406))
  call loop_QV_A(G2(:,:,:,406),wf(:,-3),G2(:,:,:,407))
  call check_last_Q_A(l_switch,G2(:,:,:,407),Q(:,63),ZERO,G3tensor(:,259))
  call loop_QV_A(G1(:,:,:,216),wf(:,32),G1(:,:,:,219))
  call loop_Q_A(G1(:,:,:,219),Q(:,59),ZERO,G2(:,:,:,408))
  call loop_QV_A(G2(:,:,:,408),wf(:,-2),G2(:,:,:,409))
  call check_last_Q_A(l_switch,G2(:,:,:,409),Q(:,63),ZERO,G3tensor(:,260))
  call loop_QV_A(G1(:,:,:,216),wf(:,-3),G1(:,:,:,220))
  call loop_Q_A(G1(:,:,:,220),Q(:,27),ZERO,G2(:,:,:,410))
  call loop_QV_A(G2(:,:,:,410),wf(:,-5),G2(:,:,:,411))
  call loop_Q_A(G2(:,:,:,411),Q(:,59),ZERO,G3(:,:,:,98))
  call loop_QV_A(G3(:,:,:,98),wf(:,-2),G3(:,:,:,99))
  call check_last_Q_A(l_switch,G3(:,:,:,99),Q(:,63),ZERO,G4tensor(:,83))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,44),G1(:,:,:,221))
  call loop_DV_C(G1(:,:,:,221),Q(:,19),wf(:,-5),G2(:,:,:,412))
  call check_last_DV_C(l_switch,G2(:,:,:,412),Q(:,51),wf(:,24),G3tensor(:,261))
  call loop_DV_C(G1(:,:,:,221),Q(:,19),wf(:,28),G2(:,:,:,413))
  call check_last_DV_C(l_switch,G2(:,:,:,413),Q(:,55),wf(:,-3),G3tensor(:,262))
  call loop_DV_C(G1(:,:,:,221),Q(:,19),wf(:,32),G2(:,:,:,414))
  call check_last_DV_C(l_switch,G2(:,:,:,414),Q(:,59),wf(:,-2),G3tensor(:,263))
  call loop_DV_C(G1(:,:,:,221),Q(:,19),wf(:,-3),G2(:,:,:,415))
  call loop_DV_C(G2(:,:,:,415),Q(:,27),wf(:,-5),G3(:,:,:,100))
  call check_last_DV_C(l_switch,G3(:,:,:,100),Q(:,59),wf(:,-2),G4tensor(:,84))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,19),G1(:,:,:,222))
  call loop_CV_D(G1(:,:,:,222),Q(:,19),wf(:,-5),Q(:,32),G2(:,:,:,416))
  call check_last_CV_D(l_switch,G2(:,:,:,416),Q(:,51),wf(:,24),Q(:,12),G3tensor(:,264))
  call loop_CV_D(G1(:,:,:,222),Q(:,19),wf(:,28),Q(:,36),G2(:,:,:,417))
  call check_last_CV_D(l_switch,G2(:,:,:,417),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,265))
  call loop_CV_D(G1(:,:,:,222),Q(:,19),wf(:,32),Q(:,40),G2(:,:,:,418))
  call check_last_CV_D(l_switch,G2(:,:,:,418),Q(:,59),wf(:,-2),Q(:,4),G3tensor(:,266))
  call loop_CV_D(G1(:,:,:,222),Q(:,19),wf(:,-3),Q(:,8),G2(:,:,:,419))
  call loop_CV_D(G2(:,:,:,419),Q(:,27),wf(:,-5),Q(:,32),G3(:,:,:,101))
  call check_last_CV_D(l_switch,G3(:,:,:,101),Q(:,59),wf(:,-2),Q(:,4),G4tensor(:,85))
  call loop_QV_A(G0(:,:,:,1),wf(:,62),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,23),ZERO,G1(:,:,:,223))
  call loop_QV_A(G1(:,:,:,223),wf(:,-5),G1(:,:,:,224))
  call loop_Q_A(G1(:,:,:,224),Q(:,55),ZERO,G2(:,:,:,420))
  call loop_QV_A(G2(:,:,:,420),wf(:,-3),G2(:,:,:,421))
  call check_last_Q_A(l_switch,G2(:,:,:,421),Q(:,63),ZERO,G3tensor(:,267))
  call loop_AV_Q(G0(:,:,:,1),wf(:,62),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,23),ZERO,G1(:,:,:,225))
  call loop_AV_Q(G1(:,:,:,225),wf(:,-5),G1(:,:,:,226))
  call loop_A_Q(G1(:,:,:,226),Q(:,55),ZERO,G2(:,:,:,422))
  call loop_AV_Q(G2(:,:,:,422),wf(:,-3),G2(:,:,:,423))
  call check_last_A_Q(l_switch,G2(:,:,:,423),Q(:,63),ZERO,G3tensor(:,268))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,62),Q(:,23),G1(:,:,:,227))
  call loop_CV_D(G1(:,:,:,227),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,424))
  call check_last_CV_D(l_switch,G2(:,:,:,424),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,269))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,62),G1(:,:,:,228))
  call loop_DV_C(G1(:,:,:,228),Q(:,23),wf(:,-5),G2(:,:,:,425))
  call check_last_DV_C(l_switch,G2(:,:,:,425),Q(:,55),wf(:,-3),G3tensor(:,270))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,62),Q(:,23),G1(:,:,:,229))
  call loop_UV_W(G1(:,:,:,229),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,426))
  call check_last_UV_W(l_switch,G2(:,:,:,426),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,271))
  call loop_QV_A(G0(:,:,:,1),wf(:,487),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,27),ZERO,G1(:,:,:,230))
  call loop_QV_A(G1(:,:,:,230),wf(:,-5),G1(:,:,:,231))
  call loop_Q_A(G1(:,:,:,231),Q(:,59),ZERO,G2(:,:,:,427))
  call loop_QV_A(G2(:,:,:,427),wf(:,-2),G2(:,:,:,428))
  call check_last_Q_A(l_switch,G2(:,:,:,428),Q(:,63),ZERO,G3tensor(:,272))
  call loop_AV_Q(G0(:,:,:,1),wf(:,487),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,27),ZERO,G1(:,:,:,232))
  call loop_AV_Q(G1(:,:,:,232),wf(:,-5),G1(:,:,:,233))
  call loop_A_Q(G1(:,:,:,233),Q(:,59),ZERO,G2(:,:,:,429))
  call loop_AV_Q(G2(:,:,:,429),wf(:,-2),G2(:,:,:,430))
  call check_last_A_Q(l_switch,G2(:,:,:,430),Q(:,63),ZERO,G3tensor(:,273))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(13)*(M(7)-M(9))) * den(76)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(14)*(M(7)-M(9))) * den(76)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(76)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(76)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(13)*(M(6)-M(7))) * den(75)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(13)*(M(5)-M(8))) * den(75)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(14)*(M(6)-M(7))) * den(75)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(14)*(M(5)-M(8))) * den(75)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(75)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(75)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,121)
  Gcoeff = (c(13)*(M(8)-M(9))) * den(74)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,151)
  Gcoeff = (c(13)*(M(4)-M(6))) * den(74)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,152)
  Gcoeff = (c(14)*(M(8)-M(9))) * den(74)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,151)
  Gcoeff = (c(14)*(M(4)-M(6))) * den(74)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,152)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(74)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,153)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(74)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,154)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(74)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,155)
  Gcoeff = (c(13)*(-M(4)+M(8))) * den(73)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(13)*(-M(6)+M(9))) * den(73)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(14)*(-M(4)+M(8))) * den(73)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(14)*(-M(6)+M(9))) * den(73)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(73)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,92)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(73)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(13)*(-M(5)+M(6))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,156)
  Gcoeff = (c(13)*(M(7)-M(8))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,157)
  Gcoeff = (c(14)*(-M(5)+M(6))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,156)
  Gcoeff = (c(14)*(M(7)-M(8))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,157)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,158)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,159)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,160)
  Gcoeff = (c(13)*(M(4)-M(7))) * den(71)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(13)*(M(5)-M(9))) * den(71)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(14)*(M(4)-M(7))) * den(71)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(14)*(M(5)-M(9))) * den(71)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(71)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(71)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(13)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,161)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(17)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,162)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(6)-M(8))) * den(52)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(5)-M(7))) * den(52)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(52)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(6)-M(8))) * den(47)
  T3sum(1:15,15) = T3sum(1:15,15) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(4)-M(9))) * den(47)
  T3sum(1:15,15) = T3sum(1:15,15) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(47)
  T3sum(1:15,15) = T3sum(1:15,15) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(5)-M(7))) * den(47)
  T3sum(1:15,3) = T3sum(1:15,3) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(4)-M(9))) * den(47)
  T3sum(1:15,3) = T3sum(1:15,3) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(47)
  T3sum(1:15,3) = T3sum(1:15,3) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(17)*(-M(7)+M(9))) * den(189)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(18)*(-M(7)+M(9))) * den(189)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(189)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(189)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(4)-M(9))) * den(42)
  T3sum(1:15,15) = T3sum(1:15,15) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(6)-M(8))) * den(42)
  T3sum(1:15,15) = T3sum(1:15,15) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(42)
  T3sum(1:15,15) = T3sum(1:15,15) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(5)-M(7))) * den(42)
  T3sum(1:15,2) = T3sum(1:15,2) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(6)-M(8))) * den(42)
  T3sum(1:15,2) = T3sum(1:15,2) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(42)
  T3sum(1:15,2) = T3sum(1:15,2) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(17)*(-M(6)+M(7))) * den(195)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(17)*(-M(5)+M(8))) * den(195)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(18)*(-M(6)+M(7))) * den(195)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(18)*(-M(5)+M(8))) * den(195)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(195)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,101)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(195)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,131)
  Gcoeff = (c(17)*(-M(8)+M(9))) * den(197)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,167)
  Gcoeff = (c(17)*(-M(4)+M(6))) * den(197)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,168)
  Gcoeff = (c(18)*(-M(8)+M(9))) * den(197)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,167)
  Gcoeff = (c(18)*(-M(4)+M(6))) * den(197)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,168)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(197)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,169)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(197)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,170)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(197)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,171)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(5)-M(7))) * den(42)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(6)-M(8))) * den(42)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(42)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(4)-M(9))) * den(42)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(6)-M(8))) * den(42)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(42)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(17)*(M(4)-M(8))) * den(206)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(17)*(M(6)-M(9))) * den(206)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(18)*(M(4)-M(8))) * den(206)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(18)*(M(6)-M(9))) * den(206)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(206)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(206)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,132)
  Gcoeff = (c(17)*(M(5)-M(6))) * den(208)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,172)
  Gcoeff = (c(17)*(-M(7)+M(8))) * den(208)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,173)
  Gcoeff = (c(18)*(M(5)-M(6))) * den(208)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,172)
  Gcoeff = (c(18)*(-M(7)+M(8))) * den(208)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,173)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(208)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,174)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(208)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,175)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(208)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,176)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(5)-M(7))) * den(42)
  T3sum(1:15,7) = T3sum(1:15,7) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(4)-M(9))) * den(42)
  T3sum(1:15,7) = T3sum(1:15,7) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(42)
  T3sum(1:15,7) = T3sum(1:15,7) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(17)*(-M(4)+M(7))) * den(211)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(17)*(-M(5)+M(9))) * den(211)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(18)*(-M(4)+M(7))) * den(211)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(18)*(-M(5)+M(9))) * den(211)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(211)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(211)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,124)
  Gcoeff = (c(6)*(M(4)-M(5)-M(7)+M(9))) * den(44)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,64)
  Gcoeff = (c(13)*(M(4)-M(7))) * den(346)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(13)*(M(5)-M(9))) * den(346)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(14)*(M(4)-M(7))) * den(346)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(14)*(M(5)-M(9))) * den(346)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(346)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(346)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,125)
  Gcoeff = (c(13)*(M(5)-M(9))) * den(27)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(13)*(M(4)-M(7))) * den(27)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(14)*(M(5)-M(9))) * den(27)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(14)*(M(4)-M(7))) * den(27)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(27)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,133)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(27)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,103)
  Gcoeff = (c(13)*(M(4)-M(7))) * den(28)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,177)
  Gcoeff = (c(13)*(M(5)-M(9))) * den(28)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,180)
  Gcoeff = (c(14)*(M(4)-M(7))) * den(28)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,177)
  Gcoeff = (c(14)*(M(5)-M(9))) * den(28)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,180)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(28)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,183)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(28)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,186)
  Gcoeff = (c(6)*(M(5)-M(6)+M(7)-M(8))) * den(49)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,70)
  Gcoeff = (c(13)*(-M(5)+M(6))) * den(356)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,189)
  Gcoeff = (c(13)*(M(7)-M(8))) * den(356)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,190)
  Gcoeff = (c(14)*(-M(5)+M(6))) * den(356)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,189)
  Gcoeff = (c(14)*(M(7)-M(8))) * den(356)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,190)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(356)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,191)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(356)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,192)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(356)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,193)
  Gcoeff = (c(13)*(M(7)-M(8))) * den(30)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,194)
  Gcoeff = (c(13)*(-M(5)+M(6))) * den(30)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,198)
  Gcoeff = (c(14)*(M(7)-M(8))) * den(30)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,194)
  Gcoeff = (c(14)*(-M(5)+M(6))) * den(30)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,198)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(30)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,202)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(30)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,206)
  Gcoeff = (c(6)*(M(4)-M(6)-M(8)+M(9))) * den(54)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,72)
  Gcoeff = (c(13)*(M(8)-M(9))) * den(361)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,210)
  Gcoeff = (c(13)*(M(4)-M(6))) * den(361)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,211)
  Gcoeff = (c(14)*(M(8)-M(9))) * den(361)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,210)
  Gcoeff = (c(14)*(M(4)-M(6))) * den(361)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,211)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(361)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,212)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(361)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,213)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(361)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,214)
  Gcoeff = (c(13)*(M(4)-M(6))) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,215)
  Gcoeff = (c(13)*(M(8)-M(9))) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,219)
  Gcoeff = (c(14)*(M(4)-M(6))) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,215)
  Gcoeff = (c(14)*(M(8)-M(9))) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,219)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,223)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,227)
  Gcoeff = (c(13)*(-M(4)+M(8))) * den(363)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(13)*(-M(6)+M(9))) * den(363)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(14)*(-M(4)+M(8))) * den(363)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(14)*(-M(6)+M(9))) * den(363)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(363)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(363)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,134)
  Gcoeff = (c(13)*(M(6)-M(7))) * den(354)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,45)
  Gcoeff = (c(13)*(M(5)-M(8))) * den(354)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(14)*(M(6)-M(7))) * den(354)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,45)
  Gcoeff = (c(14)*(M(5)-M(8))) * den(354)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(354)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,105)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(354)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,135)
  Gcoeff = (c(13)*(M(7)-M(9))) * den(344)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(14)*(M(7)-M(9))) * den(344)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(344)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(344)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(13)*(-M(4)+M(8))) * den(365)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,46)
  Gcoeff = (c(13)*(-M(6)+M(9))) * den(365)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(14)*(-M(4)+M(8))) * den(365)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,46)
  Gcoeff = (c(14)*(-M(6)+M(9))) * den(365)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(365)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,106)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(365)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,136)
  Gcoeff = (c(13)*(M(6)-M(7))) * den(358)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(13)*(M(5)-M(8))) * den(358)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(14)*(M(6)-M(7))) * den(358)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(14)*(M(5)-M(8))) * den(358)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(358)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,107)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(358)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,137)
  Gcoeff = (c(13)*(M(7)-M(9))) * den(348)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(14)*(M(7)-M(9))) * den(348)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(348)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(348)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,24)
  Gcoeff = (-(c(15)*M(7))) * den(5)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(16)*M(7))) * den(5)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(5)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(5)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,25)
  Gcoeff = (-(c(15)*M(9))) * den(5)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(16)*M(9))) * den(5)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(5)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,14)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(5)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,26)
  Gcoeff = (-(c(15)*M(6))) * den(5)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,37)
  Gcoeff = (-(c(15)*M(8))) * den(5)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,43)
  Gcoeff = (-(c(16)*M(6))) * den(5)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,37)
  Gcoeff = (-(c(16)*M(8))) * den(5)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,43)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(5)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,49)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(5)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,55)
  Gcoeff = (c(13)*(-M(6)+M(9))) * den(33)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,181)
  Gcoeff = (c(13)*(-M(4)+M(8))) * den(33)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,178)
  Gcoeff = (c(14)*(-M(6)+M(9))) * den(33)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,181)
  Gcoeff = (c(14)*(-M(4)+M(8))) * den(33)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,178)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(33)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,187)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(33)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,184)
  Gcoeff = (c(13)*(M(5)-M(8))) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,182)
  Gcoeff = (c(13)*(M(6)-M(7))) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,179)
  Gcoeff = (c(14)*(M(5)-M(8))) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,182)
  Gcoeff = (c(14)*(M(6)-M(7))) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,179)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,188)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,185)
  Gcoeff = (c(13)*(-M(5)+M(6))) * den(371)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,231)
  Gcoeff = (c(13)*(M(7)-M(8))) * den(371)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,232)
  Gcoeff = (c(14)*(-M(5)+M(6))) * den(371)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,231)
  Gcoeff = (c(14)*(M(7)-M(8))) * den(371)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,232)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(371)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,233)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(371)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,234)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(371)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,235)
  Gcoeff = (c(13)*(M(8)-M(9))) * den(368)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,236)
  Gcoeff = (c(13)*(M(4)-M(6))) * den(368)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,237)
  Gcoeff = (c(14)*(M(8)-M(9))) * den(368)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,236)
  Gcoeff = (c(14)*(M(4)-M(6))) * den(368)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,237)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(368)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,238)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(368)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,239)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(368)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,240)
  Gcoeff = (c(13)*(M(7)-M(9))) * den(351)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(14)*(M(7)-M(9))) * den(351)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(351)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(351)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(15)*M(9))) * den(4)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(16)*M(9))) * den(4)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(4)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(4)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,30)
  Gcoeff = (-(c(15)*M(7))) * den(4)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,7)
  Gcoeff = (-(c(16)*M(7))) * den(4)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(4)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,19)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(4)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,31)
  Gcoeff = (-(c(15)*M(8))) * den(4)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,67)
  Gcoeff = (-(c(15)*M(6))) * den(4)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,66)
  Gcoeff = (-(c(16)*M(8))) * den(4)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,67)
  Gcoeff = (-(c(16)*M(6))) * den(4)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,66)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(4)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,69)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(4)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,68)
  Gcoeff = (c(13)*(-M(5)+M(6))) * den(35)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,199)
  Gcoeff = (c(13)*(M(7)-M(8))) * den(35)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,195)
  Gcoeff = (c(14)*(-M(5)+M(6))) * den(35)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,199)
  Gcoeff = (c(14)*(M(7)-M(8))) * den(35)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,195)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(35)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,207)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(35)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,203)
  Gcoeff = (c(13)*(-M(4)+M(8))) * den(36)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,48)
  Gcoeff = (c(13)*(-M(6)+M(9))) * den(36)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(14)*(-M(4)+M(8))) * den(36)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,48)
  Gcoeff = (c(14)*(-M(6)+M(9))) * den(36)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(36)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,108)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(36)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,138)
  Gcoeff = (c(13)*(M(7)-M(9))) * den(37)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,241)
  Gcoeff = (c(13)*(M(4)-M(5))) * den(37)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,242)
  Gcoeff = (c(14)*(M(7)-M(9))) * den(37)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,241)
  Gcoeff = (c(14)*(M(4)-M(5))) * den(37)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,242)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(37)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,243)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(37)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,244)
  Gcoeff = (c(13)*(M(4)-M(7))) * den(380)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(13)*(M(5)-M(9))) * den(380)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(14)*(M(4)-M(7))) * den(380)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(14)*(M(5)-M(9))) * den(380)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(380)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(380)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,126)
  Gcoeff = (c(13)*(M(8)-M(9))) * den(377)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,245)
  Gcoeff = (c(13)*(M(4)-M(6))) * den(377)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,246)
  Gcoeff = (c(14)*(M(8)-M(9))) * den(377)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,245)
  Gcoeff = (c(14)*(M(4)-M(6))) * den(377)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,246)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(377)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,247)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(377)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,248)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(377)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,249)
  Gcoeff = (c(13)*(M(6)-M(7))) * den(374)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(13)*(M(5)-M(8))) * den(374)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(14)*(M(6)-M(7))) * den(374)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(14)*(M(5)-M(8))) * den(374)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(374)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,110)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(374)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,140)
  Gcoeff = (-(c(15)*M(6))) * den(3)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,41)
  Gcoeff = (-(c(15)*M(8))) * den(3)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,47)
  Gcoeff = (-(c(16)*M(6))) * den(3)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,41)
  Gcoeff = (-(c(16)*M(8))) * den(3)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,47)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(3)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,53)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(3)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,59)
  Gcoeff = (-(c(15)*M(7))) * den(3)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,74)
  Gcoeff = (-(c(15)*M(5))) * den(3)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,76)
  Gcoeff = (-(c(16)*M(7))) * den(3)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,74)
  Gcoeff = (-(c(16)*M(5))) * den(3)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,76)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(3)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,78)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(3)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,80)
  Gcoeff = (-(c(15)*M(9))) * den(3)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,75)
  Gcoeff = (-(c(15)*M(4))) * den(3)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,77)
  Gcoeff = (-(c(16)*M(9))) * den(3)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,75)
  Gcoeff = (-(c(16)*M(4))) * den(3)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,77)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(3)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,79)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(3)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,81)
  Gcoeff = (c(13)*(M(8)-M(9))) * den(38)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,220)
  Gcoeff = (c(13)*(M(4)-M(6))) * den(38)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,216)
  Gcoeff = (c(14)*(M(8)-M(9))) * den(38)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,220)
  Gcoeff = (c(14)*(M(4)-M(6))) * den(38)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,216)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(38)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,228)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(38)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,224)
  Gcoeff = (c(13)*(M(6)-M(7))) * den(39)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(13)*(M(5)-M(8))) * den(39)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,81)
  Gcoeff = (c(14)*(M(6)-M(7))) * den(39)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(14)*(M(5)-M(8))) * den(39)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,81)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(39)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(39)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,141)
  Gcoeff = (c(13)*(M(7)-M(9))) * den(40)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(14)*(M(7)-M(9))) * den(40)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(40)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(40)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(13)*(M(4)-M(7))) * den(389)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(13)*(M(5)-M(9))) * den(389)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(14)*(M(4)-M(7))) * den(389)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(14)*(M(5)-M(9))) * den(389)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(5)*(-M(4)+M(5)+M(7)-M(9))) * den(389)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(5)*(M(4)-M(5)-M(7)+M(9))) * den(389)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,127)
  Gcoeff = (c(13)*(-M(5)+M(6))) * den(386)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,250)
  Gcoeff = (c(13)*(M(7)-M(8))) * den(386)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,251)
  Gcoeff = (c(14)*(-M(5)+M(6))) * den(386)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,250)
  Gcoeff = (c(14)*(M(7)-M(8))) * den(386)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,251)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(386)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,252)
  Gcoeff = (c(5)*(-M(5)+M(6)-M(7)+M(8))) * den(386)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,253)
  Gcoeff = (c(5)*(M(5)-M(6)+M(7)-M(8))) * den(386)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,254)
  Gcoeff = (c(13)*(-M(4)+M(8))) * den(383)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(13)*(-M(6)+M(9))) * den(383)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(14)*(-M(4)+M(8))) * den(383)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(14)*(-M(6)+M(9))) * den(383)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(5)*(M(4)-M(6)-M(8)+M(9))) * den(383)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,113)
  Gcoeff = (c(5)*(-M(4)+M(6)+M(8)-M(9))) * den(383)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,143)
  Gcoeff = (-(c(15)*M(8))) * den(2)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,44)
  Gcoeff = (-(c(15)*M(6))) * den(2)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,38)
  Gcoeff = (-(c(16)*M(8))) * den(2)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,44)
  Gcoeff = (-(c(16)*M(6))) * den(2)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,38)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(2)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,56)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(6)-M(8))) * den(2)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,50)
  Gcoeff = (-(c(15)*M(9))) * den(2)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(16)*M(9))) * den(2)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(2)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,15)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(4)-M(9))) * den(2)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,27)
  Gcoeff = (-(c(15)*M(7))) * den(2)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,8)
  Gcoeff = (-(c(16)*M(7))) * den(2)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(2)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(4)*(-M(1)-M(2)-M(3))+c(5)*(-M(5)-M(7))) * den(2)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,32)
  Gcoeff = (c(17)*(-M(4)+M(7))) * den(43)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,255)
  Gcoeff = (c(17)*(-M(5)+M(9))) * den(43)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,258)
  Gcoeff = (c(18)*(-M(4)+M(7))) * den(43)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,255)
  Gcoeff = (c(18)*(-M(5)+M(9))) * den(43)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,258)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(43)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,261)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(43)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,264)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(43)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,164)
  Gcoeff = (c(17)*(-M(5)+M(9))) * den(192)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(17)*(-M(4)+M(7))) * den(192)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(18)*(-M(5)+M(9))) * den(192)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(18)*(-M(4)+M(7))) * den(192)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(192)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,144)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(192)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(12)*(-M(4)+M(5)+M(7)-M(9))) * den(45)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,65)
  Gcoeff = (c(17)*(-M(4)+M(7))) * den(462)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(17)*(-M(5)+M(9))) * den(462)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,68)
  Gcoeff = (c(18)*(-M(4)+M(7))) * den(462)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(18)*(-M(5)+M(9))) * den(462)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,68)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(462)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(462)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,128)
  Gcoeff = (c(17)*(M(5)-M(6))) * den(48)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,200)
  Gcoeff = (c(17)*(-M(7)+M(8))) * den(48)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,196)
  Gcoeff = (c(18)*(M(5)-M(6))) * den(48)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,200)
  Gcoeff = (c(18)*(-M(7)+M(8))) * den(48)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,196)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(48)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,208)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(48)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,204)
  Gcoeff = (c(17)*(-M(7)+M(8))) * den(200)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,197)
  Gcoeff = (c(17)*(M(5)-M(6))) * den(200)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,201)
  Gcoeff = (c(18)*(-M(7)+M(8))) * den(200)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,197)
  Gcoeff = (c(18)*(M(5)-M(6))) * den(200)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,201)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(200)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,205)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(200)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,209)
  Gcoeff = (c(12)*(-M(5)+M(6)-M(7)+M(8))) * den(50)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,71)
  Gcoeff = (c(17)*(M(5)-M(6))) * den(471)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,267)
  Gcoeff = (c(17)*(-M(7)+M(8))) * den(471)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,268)
  Gcoeff = (c(18)*(M(5)-M(6))) * den(471)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,267)
  Gcoeff = (c(18)*(-M(7)+M(8))) * den(471)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,268)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(471)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,269)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(471)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,270)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(471)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,271)
  Gcoeff = (c(17)*(-M(4)+M(6))) * den(53)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,217)
  Gcoeff = (c(17)*(-M(8)+M(9))) * den(53)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,221)
  Gcoeff = (c(18)*(-M(4)+M(6))) * den(53)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,217)
  Gcoeff = (c(18)*(-M(8)+M(9))) * den(53)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,221)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(53)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,225)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(53)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,229)
  Gcoeff = (c(17)*(-M(4)+M(6))) * den(215)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,218)
  Gcoeff = (c(17)*(-M(8)+M(9))) * den(215)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,222)
  Gcoeff = (c(18)*(-M(4)+M(6))) * den(215)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,218)
  Gcoeff = (c(18)*(-M(8)+M(9))) * den(215)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,222)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(215)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,226)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(215)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,230)
  Gcoeff = (c(12)*(-M(4)+M(6)+M(8)-M(9))) * den(55)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,73)
  Gcoeff = (c(17)*(-M(8)+M(9))) * den(478)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,272)
  Gcoeff = (c(17)*(-M(4)+M(6))) * den(478)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,273)
  Gcoeff = (c(18)*(-M(8)+M(9))) * den(478)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,272)
  Gcoeff = (c(18)*(-M(4)+M(6))) * den(478)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,273)
  Gcoeff = (c(17)*(M(4)-M(8))) * den(56)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(17)*(M(6)-M(9))) * den(56)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,79)
  Gcoeff = (c(18)*(M(4)-M(8))) * den(56)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(18)*(M(6)-M(9))) * den(56)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,79)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(56)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,109)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(56)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,139)
  Gcoeff = (c(17)*(M(6)-M(9))) * den(203)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,259)
  Gcoeff = (c(17)*(M(4)-M(8))) * den(203)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,256)
  Gcoeff = (c(18)*(M(6)-M(9))) * den(203)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,259)
  Gcoeff = (c(18)*(M(4)-M(8))) * den(203)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,256)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(203)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,265)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(203)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,262)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(203)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,165)
  Gcoeff = (c(17)*(M(4)-M(8))) * den(480)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(17)*(M(6)-M(9))) * den(480)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(18)*(M(4)-M(8))) * den(480)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(18)*(M(6)-M(9))) * den(480)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(480)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(480)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,145)
  Gcoeff = (c(17)*(-M(5)+M(8))) * den(59)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(17)*(-M(6)+M(7))) * den(59)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(18)*(-M(5)+M(8))) * den(59)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(18)*(-M(6)+M(7))) * den(59)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(59)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,142)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(59)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,112)
  Gcoeff = (c(17)*(-M(5)+M(8))) * den(218)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,260)
  Gcoeff = (c(17)*(-M(6)+M(7))) * den(218)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,257)
  Gcoeff = (c(18)*(-M(5)+M(8))) * den(218)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,260)
  Gcoeff = (c(18)*(-M(6)+M(7))) * den(218)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,257)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(218)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,266)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(218)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,263)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(218)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,166)
  Gcoeff = (c(17)*(-M(6)+M(7))) * den(469)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(17)*(-M(5)+M(8))) * den(469)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,86)
  Gcoeff = (c(18)*(-M(6)+M(7))) * den(469)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(18)*(-M(5)+M(8))) * den(469)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,86)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(469)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,116)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(469)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,146)
  Gcoeff = (c(17)*(-M(7)+M(9))) * den(62)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(18)*(-M(7)+M(9))) * den(62)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(62)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(62)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(221)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,163)
  Gcoeff = (c(17)*(-M(7)+M(9))) * den(460)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(18)*(-M(7)+M(9))) * den(460)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(460)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(460)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(17)*(-M(4)+M(7))) * den(502)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(17)*(-M(5)+M(9))) * den(502)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(18)*(-M(4)+M(7))) * den(502)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(18)*(-M(5)+M(9))) * den(502)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(502)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(502)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,129)
  Gcoeff = (c(17)*(M(4)-M(8))) * den(504)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(17)*(M(6)-M(9))) * den(504)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(18)*(M(4)-M(8))) * den(504)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(18)*(M(6)-M(9))) * den(504)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(504)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,117)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(504)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,147)
  Gcoeff = (c(19)*M(8)) * den(52)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,45)
  Gcoeff = (c(19)*M(6)) * den(52)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,39)
  Gcoeff = (c(20)*M(8)) * den(52)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,45)
  Gcoeff = (c(20)*M(6)) * den(52)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,39)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(52)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,57)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(52)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,51)
  Gcoeff = (c(19)*M(9)) * den(52)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(20)*M(9)) * den(52)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(52)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(52)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,28)
  Gcoeff = (c(19)*M(7)) * den(52)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(20)*M(7)) * den(52)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(52)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,21)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(52)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,33)
  Gcoeff = (c(17)*(-M(4)+M(7))) * den(505)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(17)*(-M(5)+M(9))) * den(505)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(18)*(-M(4)+M(7))) * den(505)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(18)*(-M(5)+M(9))) * den(505)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(505)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(505)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,130)
  Gcoeff = (c(17)*(-M(6)+M(7))) * den(507)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,58)
  Gcoeff = (c(17)*(-M(5)+M(8))) * den(507)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(18)*(-M(6)+M(7))) * den(507)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,58)
  Gcoeff = (c(18)*(-M(5)+M(8))) * den(507)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(507)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(507)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,148)
  Gcoeff = (c(19)*M(6)) * den(47)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,42)
  Gcoeff = (c(19)*M(8)) * den(47)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,48)
  Gcoeff = (c(20)*M(6)) * den(47)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,42)
  Gcoeff = (c(20)*M(8)) * den(47)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,48)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(47)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,54)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(47)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,60)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(5)-M(7))) * den(47)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,61)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(4)-M(9))) * den(47)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,62)
  Gcoeff = (c(17)*(-M(7)+M(9))) * den(510)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(18)*(-M(7)+M(9))) * den(510)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(510)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(510)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(19)*M(9)) * den(42)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(20)*M(9)) * den(42)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(42)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,23)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(42)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,35)
  Gcoeff = (c(19)*M(7)) * den(42)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(20)*M(7)) * den(42)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(42)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,22)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(42)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,34)
  Gcoeff = (c(19)*M(8)) * den(42)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,83)
  Gcoeff = (c(19)*M(6)) * den(42)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,82)
  Gcoeff = (c(20)*M(8)) * den(42)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,83)
  Gcoeff = (c(20)*M(6)) * den(42)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,82)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(42)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,85)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(42)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,84)
  Gcoeff = (c(10)*(-M(1)-M(2)-M(3))+c(11)*(-M(6)-M(8))) * den(42)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,63)
  Gcoeff = (c(17)*(M(4)-M(8))) * den(511)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(17)*(M(6)-M(9))) * den(511)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(18)*(M(4)-M(8))) * den(511)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(18)*(M(6)-M(9))) * den(511)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(11)*(-M(4)+M(6)+M(8)-M(9))) * den(511)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,119)
  Gcoeff = (c(11)*(M(4)-M(6)-M(8)+M(9))) * den(511)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,149)
  Gcoeff = (c(17)*(-M(6)+M(7))) * den(512)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(17)*(-M(5)+M(8))) * den(512)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(18)*(-M(6)+M(7))) * den(512)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(18)*(-M(5)+M(8))) * den(512)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(11)*(-M(5)+M(6)-M(7)+M(8))) * den(512)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,120)
  Gcoeff = (c(11)*(M(5)-M(6)+M(7)-M(8))) * den(512)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,150)
  Gcoeff = (c(17)*(-M(7)+M(9))) * den(513)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(18)*(-M(7)+M(9))) * den(513)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(11)*(M(4)-M(5)-M(7)+M(9))) * den(513)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(11)*(-M(4)+M(5)+M(7)-M(9))) * den(513)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(19)*M(7)) * den(191)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(20)*M(7)) * den(191)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(191)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,24)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(5)+M(7))) * den(191)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,36)
  Gcoeff = (c(19)*M(9)) * den(191)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(20)*M(9)) * den(191)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(191)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,17)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(4)+M(9))) * den(191)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(19)*M(6)) * den(191)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,40)
  Gcoeff = (c(19)*M(8)) * den(191)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,46)
  Gcoeff = (c(20)*M(6)) * den(191)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,40)
  Gcoeff = (c(20)*M(8)) * den(191)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,46)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(191)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,52)
  Gcoeff = (c(10)*(M(1)+M(2)+M(3))+c(11)*(M(6)+M(8))) * den(191)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,58)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_3_heftpphhjj_hhgggg_1_/**/REALKIND
