
module ol_vamp_2_heftpphhjj_ddxhhgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_ddxhhgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_ddxhhgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_ddxhhgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_ddxhhgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,41) :: G0
  complex(REALKIND), dimension(4,5,4,59) :: G1
  complex(REALKIND), dimension(5,9) :: G1tensor
  complex(REALKIND), dimension(15,96) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,8),wf(:,-5),G0(:,:,:,2))
  call check_last_GHH_G(l_switch,G0(:,:,:,2),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,1), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,2),Q(:,51),wf(:,3),G2tensor(:,2), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,8),G0(:,:,:,3))
  call check_last_GHH_G(l_switch,G0(:,:,:,3),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,3), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,3),Q(:,51),wf(:,3),G2tensor(:,4), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,6),G0(:,:,:,4))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,1))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,-5),G0(:,:,:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,2))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,6),G0(:,:,:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,3))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,10),G0(:,:,:,7))
  call check_last_GHH_G(l_switch,G0(:,:,:,7),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,5), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,7),Q(:,51),wf(:,3),G2tensor(:,6), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,10),wf(:,-4),G0(:,:,:,8))
  call check_last_GHH_G(l_switch,G0(:,:,:,8),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,7), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,8),Q(:,51),wf(:,3),G2tensor(:,8), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,10),G0(:,:,:,9))
  call check_last_GHH_G(l_switch,G0(:,:,:,9),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,9), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,9),Q(:,51),wf(:,3),G2tensor(:,10), Q(:,63))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-3),wf(:,-2),wf(:,10),Q(:,35),G1(:,:,:,1), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,11))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,35),G1(:,:,:,2))
  call check_last_GHHG_G(l_switch,G1(:,:,:,2),Q(:,35),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G2tensor(:,12), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,2),Q(:,35),wf(:,3),wf(:,-4),Q(:,16),G2tensor(:,13), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,9),Q(:,28),G2tensor(:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,35),wf(:,25),Q(:,28),G2tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,60),ZERO,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,1),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),ZERO,G2tensor(:,16))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,60),G1(:,:,:,5))
  call check_last_CV_D(l_switch,G1(:,:,:,5),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,17))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,13),G0(:,:,:,11))
  call check_last_GHH_G(l_switch,G0(:,:,:,11),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,18), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,11),Q(:,51),wf(:,3),G2tensor(:,19), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,-5),G0(:,:,:,12))
  call check_last_GHH_G(l_switch,G0(:,:,:,12),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,20), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,12),Q(:,51),wf(:,3),G2tensor(:,21), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,13),G0(:,:,:,13))
  call check_last_GHH_G(l_switch,G0(:,:,:,13),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,22), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,13),Q(:,51),wf(:,3),G2tensor(:,23), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,16),G0(:,:,:,14))
  call check_last_GHH_G(l_switch,G0(:,:,:,14),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,24), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,14),Q(:,51),wf(:,3),G2tensor(:,25), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,16),wf(:,-5),G0(:,:,:,15))
  call check_last_GHH_G(l_switch,G0(:,:,:,15),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,26), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,15),Q(:,51),wf(:,3),G2tensor(:,27), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,16),G0(:,:,:,16))
  call check_last_GHH_G(l_switch,G0(:,:,:,16),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,28), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,16),Q(:,51),wf(:,3),G2tensor(:,29), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,19),G0(:,:,:,17))
  call check_last_GHH_G(l_switch,G0(:,:,:,17),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,30), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,17),Q(:,51),wf(:,3),G2tensor(:,31), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,19),wf(:,-4),G0(:,:,:,18))
  call check_last_GHH_G(l_switch,G0(:,:,:,18),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,32), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,18),Q(:,51),wf(:,3),G2tensor(:,33), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,19),G0(:,:,:,19))
  call check_last_GHH_G(l_switch,G0(:,:,:,19),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,34), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,19),Q(:,51),wf(:,3),G2tensor(:,35), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,22),G0(:,:,:,20))
  call check_last_GHH_G(l_switch,G0(:,:,:,20),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,36), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,20),Q(:,51),wf(:,3),G2tensor(:,37), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,22),wf(:,-4),G0(:,:,:,21))
  call check_last_GHH_G(l_switch,G0(:,:,:,21),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,38), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,21),Q(:,51),wf(:,3),G2tensor(:,39), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,22),G0(:,:,:,22))
  call check_last_GHH_G(l_switch,G0(:,:,:,22),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,40), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,22),Q(:,51),wf(:,3),G2tensor(:,41), Q(:,63))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-3),wf(:,-2),wf(:,19),Q(:,35),G1(:,:,:,6), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,42))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-3),wf(:,-2),wf(:,22),Q(:,35),G1(:,:,:,7), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,7),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,43))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,35),G1(:,:,:,8))
  call check_last_GHHG_G(l_switch,G1(:,:,:,8),Q(:,35),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G2tensor(:,44), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,8),Q(:,35),wf(:,3),wf(:,-4),Q(:,16),G2tensor(:,45), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,8),Q(:,35),wf(:,9),Q(:,28),G2tensor(:,46))
  call check_last_UV_W(l_switch,G1(:,:,:,8),Q(:,35),wf(:,25),Q(:,28),G2tensor(:,47))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,22),Q(:,35),G1(:,:,:,9))
  call check_last_GHHG_G(l_switch,G1(:,:,:,9),Q(:,35),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G2tensor(:,48), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,9),Q(:,35),wf(:,3),wf(:,-4),Q(:,16),G2tensor(:,49), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,9),Q(:,35),wf(:,9),Q(:,28),G2tensor(:,50))
  call check_last_UV_W(l_switch,G1(:,:,:,9),Q(:,35),wf(:,25),Q(:,28),G2tensor(:,51))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,3),wf(:,10),Q(:,35),G1(:,:,:,10), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,10),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,52))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,24),G0(:,:,:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,4))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,24),wf(:,1),G0(:,:,:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,5))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,24),G0(:,:,:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,6))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,23),G0(:,:,:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,7))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,23),wf(:,-5),G0(:,:,:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,8))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,23),G0(:,:,:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,92),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,60),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,1),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),ZERO,G2tensor(:,53))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,92),Q(:,60),G1(:,:,:,13))
  call check_last_CV_D(l_switch,G1(:,:,:,13),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,106),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,60),ZERO,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,1),G1(:,:,:,15))
  call check_last_Q_A(l_switch,G1(:,:,:,15),Q(:,63),ZERO,G2tensor(:,55))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,106),Q(:,60),G1(:,:,:,16))
  call check_last_CV_D(l_switch,G1(:,:,:,16),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,48),ZERO,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,6),G1(:,:,:,18))
  call check_last_Q_A(l_switch,G1(:,:,:,18),Q(:,63),ZERO,G2tensor(:,57))
  call loop_QV_A(G1(:,:,:,17),wf(:,23),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,63),ZERO,G2tensor(:,58))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,48),G1(:,:,:,20))
  call check_last_CV_D(l_switch,G1(:,:,:,20),Q(:,48),wf(:,6),Q(:,15),G2tensor(:,59))
  call check_last_CV_D(l_switch,G1(:,:,:,20),Q(:,48),wf(:,23),Q(:,15),G2tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,44),ZERO,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,8),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,63),ZERO,G2tensor(:,61))
  call loop_QV_A(G1(:,:,:,21),wf(:,13),G1(:,:,:,23))
  call check_last_Q_A(l_switch,G1(:,:,:,23),Q(:,63),ZERO,G2tensor(:,62))
  call loop_QV_A(G1(:,:,:,21),wf(:,16),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),ZERO,G2tensor(:,63))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,44),G1(:,:,:,25))
  call check_last_CV_D(l_switch,G1(:,:,:,25),Q(:,44),wf(:,8),Q(:,19),G2tensor(:,64))
  call check_last_CV_D(l_switch,G1(:,:,:,25),Q(:,44),wf(:,13),Q(:,19),G2tensor(:,65))
  call check_last_CV_D(l_switch,G1(:,:,:,25),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,108),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,60),ZERO,G1(:,:,:,26))
  call loop_QV_A(G1(:,:,:,26),wf(:,1),G1(:,:,:,27))
  call check_last_Q_A(l_switch,G1(:,:,:,27),Q(:,63),ZERO,G2tensor(:,67))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,108),Q(:,60),G1(:,:,:,28))
  call check_last_CV_D(l_switch,G1(:,:,:,28),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,35),ZERO,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,9),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,63),ZERO,G2tensor(:,69))
  call loop_QV_A(G1(:,:,:,29),wf(:,25),G1(:,:,:,31))
  call check_last_Q_A(l_switch,G1(:,:,:,31),Q(:,63),ZERO,G2tensor(:,70))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,35),G1(:,:,:,32))
  call check_last_CV_D(l_switch,G1(:,:,:,32),Q(:,35),wf(:,9),Q(:,28),G2tensor(:,71))
  call check_last_CV_D(l_switch,G1(:,:,:,32),Q(:,35),wf(:,25),Q(:,28),G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,110),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,60),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,1),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,63),ZERO,G2tensor(:,73))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,110),Q(:,60),G1(:,:,:,35))
  call check_last_CV_D(l_switch,G1(:,:,:,35),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,74))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,3),wf(:,19),Q(:,35),G1(:,:,:,36), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,36),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,75))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,3),wf(:,22),Q(:,35),G1(:,:,:,37), Q(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,37),Q(:,47),wf(:,-4),Q(:,16),G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,35),ZERO,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,9),G1(:,:,:,39))
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,63),ZERO,G2tensor(:,77))
  call loop_QV_A(G1(:,:,:,38),wf(:,25),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,63),ZERO,G2tensor(:,78))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,35),G1(:,:,:,41))
  call check_last_CV_D(l_switch,G1(:,:,:,41),Q(:,35),wf(:,9),Q(:,28),G2tensor(:,79))
  call check_last_CV_D(l_switch,G1(:,:,:,41),Q(:,35),wf(:,25),Q(:,28),G2tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,22),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,35),ZERO,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,9),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,63),ZERO,G2tensor(:,81))
  call loop_QV_A(G1(:,:,:,42),wf(:,25),G1(:,:,:,44))
  call check_last_Q_A(l_switch,G1(:,:,:,44),Q(:,63),ZERO,G2tensor(:,82))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,22),Q(:,35),G1(:,:,:,45))
  call check_last_CV_D(l_switch,G1(:,:,:,45),Q(:,35),wf(:,9),Q(:,28),G2tensor(:,83))
  call check_last_CV_D(l_switch,G1(:,:,:,45),Q(:,35),wf(:,25),Q(:,28),G2tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,177),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,60),ZERO,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,1),G1(:,:,:,47))
  call check_last_Q_A(l_switch,G1(:,:,:,47),Q(:,63),ZERO,G2tensor(:,85))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,177),Q(:,60),G1(:,:,:,48))
  call check_last_CV_D(l_switch,G1(:,:,:,48),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,86))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,44),ZERO,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,8),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,63),ZERO,G2tensor(:,87))
  call loop_QV_A(G1(:,:,:,49),wf(:,13),G1(:,:,:,51))
  call check_last_Q_A(l_switch,G1(:,:,:,51),Q(:,63),ZERO,G2tensor(:,88))
  call loop_QV_A(G1(:,:,:,49),wf(:,16),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),ZERO,G2tensor(:,89))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,24),Q(:,44),G1(:,:,:,53))
  call check_last_CV_D(l_switch,G1(:,:,:,53),Q(:,44),wf(:,8),Q(:,19),G2tensor(:,90))
  call check_last_CV_D(l_switch,G1(:,:,:,53),Q(:,44),wf(:,13),Q(:,19),G2tensor(:,91))
  call check_last_CV_D(l_switch,G1(:,:,:,53),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,202),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,60),ZERO,G1(:,:,:,54))
  call loop_QV_A(G1(:,:,:,54),wf(:,1),G1(:,:,:,55))
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,63),ZERO,G2tensor(:,93))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,202),Q(:,60),G1(:,:,:,56))
  call check_last_CV_D(l_switch,G1(:,:,:,56),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,203),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,60),ZERO,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,1),G1(:,:,:,58))
  call check_last_Q_A(l_switch,G1(:,:,:,58),Q(:,63),ZERO,G2tensor(:,95))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,203),Q(:,60),G1(:,:,:,59))
  call check_last_CV_D(l_switch,G1(:,:,:,59),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(20)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,1)
  Gcoeff = (0) * den(20)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(80)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(80)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(80)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(54)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(54)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,7)
  Gcoeff = (0) * den(54)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(54)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(54)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(27)*(M(1)-M(2))) * den(46)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(28)*(M(1)-M(2))) * den(46)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(46)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(8)*M(2)) * den(24)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(8)*M(2)) * den(24)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,20)
  Gcoeff = (0) * den(24)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(8)*M(1)) * den(26)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(8)*M(1)) * den(26)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,26)
  Gcoeff = (0) * den(26)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(8)*M(1)) * den(29)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(8)*M(1)) * den(29)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,32)
  Gcoeff = (0) * den(29)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(8)*M(2)) * den(31)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(8)*M(2)) * den(31)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,38)
  Gcoeff = (0) * den(31)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(8)*M(1)) * den(29)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(8)*M(2)) * den(31)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(8)*M(1)) * den(29)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(8)*M(2)) * den(31)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(55)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(57)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(57)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(57)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(21)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,2)
  Gcoeff = (0) * den(21)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(165)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(165)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(165)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(55)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(55)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,8)
  Gcoeff = (0) * den(55)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(55)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(33)*(-M(1)+M(2))) * den(53)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(34)*(-M(1)+M(2))) * den(53)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(53)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(27)*(M(1)-M(2))) * den(78)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(28)*(M(1)-M(2))) * den(78)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(78)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(27)*(M(1)-M(2))) * den(81)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(28)*(M(1)-M(2))) * den(81)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(81)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(27)*(M(1)-M(2))) * den(84)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(28)*(M(1)-M(2))) * den(84)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(84)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(27)*(M(1)-M(2))) * den(83)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(28)*(M(1)-M(2))) * den(83)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(83)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(27)*(-M(1)+M(2))) * den(87)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(28)*(-M(1)+M(2))) * den(87)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(87)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(87)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(27)*(M(1)-M(2))) * den(86)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(28)*(M(1)-M(2))) * den(86)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(86)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(21)*M(2))) * den(25)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(21)*M(2))) * den(25)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,21)
  Gcoeff = (0) * den(25)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(21)*M(1))) * den(27)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(21)*M(1))) * den(27)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,27)
  Gcoeff = (0) * den(27)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(21)*M(1))) * den(30)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(21)*M(2))) * den(32)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(21)*M(1))) * den(30)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(21)*M(1))) * den(30)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(21)*M(1))) * den(30)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,33)
  Gcoeff = (0) * den(30)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(21)*M(2))) * den(32)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(21)*M(2))) * den(32)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(21)*M(2))) * den(32)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,39)
  Gcoeff = (0) * den(32)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(30)*M(2))) * den(132)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(32)*M(2))) * den(132)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(13)*M(2))) * den(132)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(30)*M(1))) * den(136)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(32)*M(1))) * den(136)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(13)*M(1))) * den(136)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(30)*M(1))) * den(140)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(32)*M(1))) * den(140)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(13)*M(1))) * den(140)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(8)*M(1)) * den(140)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(30)*M(2))) * den(144)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(32)*M(2))) * den(144)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(13)*M(2))) * den(144)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(8)*M(2)) * den(144)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(33)*(-M(1)+M(2))) * den(166)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(34)*(-M(1)+M(2))) * den(166)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(166)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(33)*(-M(1)+M(2))) * den(164)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(34)*(-M(1)+M(2))) * den(164)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(164)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(33)*(-M(1)+M(2))) * den(170)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(34)*(-M(1)+M(2))) * den(170)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(170)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(33)*(M(1)-M(2))) * den(171)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(34)*(M(1)-M(2))) * den(171)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(20)*(M(1)-M(2))) * den(171)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(171)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(33)*(-M(1)+M(2))) * den(195)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(34)*(-M(1)+M(2))) * den(195)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(195)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(33)*(-M(1)+M(2))) * den(196)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(34)*(-M(1)+M(2))) * den(196)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(196)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(36)*M(2)) * den(174)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(38)*M(2)) * den(174)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(26)*M(2)) * den(174)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(36)*M(1)) * den(177)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(38)*M(1)) * den(177)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(26)*M(1)) * den(177)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(36)*M(1)) * den(180)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(38)*M(1)) * den(180)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(26)*M(1)) * den(180)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(21)*M(1))) * den(180)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(36)*M(2)) * den(183)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(38)*M(2)) * den(183)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(26)*M(2)) * den(183)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(21)*M(2))) * den(183)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,51)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_2_heftpphhjj_ddxhhgg_1_/**/REALKIND
