
module ol_vamp_1_heftpphhjj_uuxddxhh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_uuxddxhh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_uuxddxhh_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_uuxddxhh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_uuxddxhh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,8) :: G0
  complex(REALKIND), dimension(4,5,4,38) :: G1
  complex(REALKIND), dimension(4,15,4,26) :: G2
  complex(REALKIND), dimension(4,35,4,40) :: G3
  complex(REALKIND), dimension(4,70,4,16) :: G4
  complex(REALKIND), dimension(15,34) :: G2tensor
  complex(REALKIND), dimension(35,8) :: G3tensor
  complex(REALKIND), dimension(70,22) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),wf(:,1),Q(:,3),G1(:,:,:,1), Q(:,51))
  call loop_VA_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,59),ZERO,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-2),G2tensor(:,1))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,2))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),wf(:,2),Q(:,12),G1(:,:,:,3), Q(:,60))
  call loop_VA_Q(G1(:,:,:,3),wf(:,-1),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,62),ZERO,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,3))
  call check_last_UV_W(l_switch,G1(:,:,:,3),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,4))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,5))
  call loop_GHH_G(G1(:,:,:,5),Q(:,12),wf(:,-5),wf(:,-4),G3(:,:,:,1), Q(:,60))
  call check_last_UV_W(l_switch,G3(:,:,:,1),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,1))
  call loop_VA_Q(G3(:,:,:,1),wf(:,-1),G3(:,:,:,2))
  call loop_A_Q(G3(:,:,:,2),Q(:,62),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,2))
  call loop_GH_G(G1(:,:,:,5),Q(:,12),wf(:,4),G3(:,:,:,3), Q(:,60))
  call check_last_UV_W(l_switch,G3(:,:,:,3),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,3))
  call loop_VA_Q(G3(:,:,:,3),wf(:,-1),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,62),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,4))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,1),Q(:,3),G1(:,:,:,6), Q(:,51))
  call loop_VA_Q(G1(:,:,:,6),wf(:,-3),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,59),ZERO,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,-2),G2tensor(:,5))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,6))
  call loop_GHH_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),G2(:,:,:,4), Q(:,48))
  call loop_VA_Q(G2(:,:,:,4),wf(:,-3),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,56),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,34),G3tensor(:,1))
  call loop_AV_Q(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,59),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,-2),G4tensor(:,5))
  call loop_AQ_V(G3(:,:,:,5),wf(:,-2),G3(:,:,:,7))
  call loop_VA_Q(G3(:,:,:,7),wf(:,-1),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,62),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,6))
  call loop_VA_Q(G2(:,:,:,4),wf(:,37),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,59),ZERO,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,-2),G3tensor(:,2))
  call loop_VQ_A(G2(:,:,:,4),wf(:,40),G2(:,:,:,7))
  call loop_Q_A(G2(:,:,:,7),Q(:,61),ZERO,G3(:,:,:,10))
  call check_last_QA_V(l_switch,G3(:,:,:,10),wf(:,-1),G3tensor(:,3))
  call loop_VA_Q(G2(:,:,:,4),wf(:,42),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,62),ZERO,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,0),G3tensor(:,4))
  call loop_UV_W(G2(:,:,:,4),Q(:,48),wf(:,2),Q(:,12),G3(:,:,:,12))
  call loop_VA_Q(G3(:,:,:,12),wf(:,-1),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,62),ZERO,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,7))
  call loop_VA_Q(G2(:,:,:,4),wf(:,-1),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,50),ZERO,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,2),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,62),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,8))
  call loop_VQ_A(G2(:,:,:,4),wf(:,-2),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,52),ZERO,G3(:,:,:,16))
  call loop_QA_V(G3(:,:,:,16),wf(:,-3),G3(:,:,:,17))
  call loop_VA_Q(G3(:,:,:,17),wf(:,-1),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,62),ZERO,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,0),G4tensor(:,9))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,4),wf(:,1),wf(:,2),G2tensor(:,7))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,4),wf(:,2),wf(:,1),G2tensor(:,8))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,4),wf(:,1),wf(:,2),G2tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,4),ZERO,G1(:,:,:,8))
  call loop_QA_V(G1(:,:,:,8),wf(:,-3),G1(:,:,:,9))
  call loop_GHH_G(G1(:,:,:,9),Q(:,12),wf(:,-5),wf(:,-4),G3(:,:,:,19), Q(:,60))
  call check_last_UV_W(l_switch,G3(:,:,:,19),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,10))
  call loop_VA_Q(G3(:,:,:,19),wf(:,-1),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,62),ZERO,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,11))
  call loop_GH_G(G1(:,:,:,9),Q(:,12),wf(:,4),G3(:,:,:,21), Q(:,60))
  call check_last_UV_W(l_switch,G3(:,:,:,21),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,12))
  call loop_VA_Q(G3(:,:,:,21),wf(:,-1),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,62),ZERO,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,13))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,8),ZERO,G1(:,:,:,10))
  call loop_AQ_V(G1(:,:,:,10),wf(:,-2),G1(:,:,:,11))
  call loop_GHH_G(G1(:,:,:,11),Q(:,12),wf(:,-5),wf(:,-4),G3(:,:,:,23), Q(:,60))
  call check_last_UV_W(l_switch,G3(:,:,:,23),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,14))
  call loop_VA_Q(G3(:,:,:,23),wf(:,-1),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,62),ZERO,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,0),G4tensor(:,15))
  call loop_GH_G(G1(:,:,:,11),Q(:,12),wf(:,4),G3(:,:,:,25), Q(:,60))
  call check_last_UV_W(l_switch,G3(:,:,:,25),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,16))
  call loop_VA_Q(G3(:,:,:,25),wf(:,-1),G3(:,:,:,26))
  call loop_A_Q(G3(:,:,:,26),Q(:,62),ZERO,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,10),wf(:,3),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,59),ZERO,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,-2),G2tensor(:,10))
  call loop_AV_Q(G1(:,:,:,10),wf(:,45),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,59),ZERO,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,-2),G2tensor(:,11))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,51),G1(:,:,:,14))
  call loop_VA_Q(G1(:,:,:,14),wf(:,-3),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,59),ZERO,G2(:,:,:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,-2),G2tensor(:,12))
  call check_last_UV_W(l_switch,G1(:,:,:,14),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,13))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,4),wf(:,2),Q(:,12),G1(:,:,:,16), Q(:,60))
  call loop_VA_Q(G1(:,:,:,16),wf(:,-1),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),ZERO,G2(:,:,:,14))
  call check_last_AQ_V(l_switch,G2(:,:,:,14),wf(:,0),G2tensor(:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,16),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,15))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,2),ZERO,G1(:,:,:,18))
  call loop_AV_Q(G1(:,:,:,18),wf(:,25),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,62),ZERO,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,0),G2tensor(:,16))
  call loop_AV_Q(G1(:,:,:,18),wf(:,44),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,62),ZERO,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,0),G2tensor(:,17))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,60),G1(:,:,:,21))
  call loop_VA_Q(G1(:,:,:,21),wf(:,-1),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,62),ZERO,G2(:,:,:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,0),G2tensor(:,18))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,19))
  call loop_GH_G(G0(:,:,:,1),Q(:,0),wf(:,4),G2(:,:,:,18), Q(:,48))
  call loop_VA_Q(G2(:,:,:,18),wf(:,-3),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,56),ZERO,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,34),G3tensor(:,5))
  call loop_AV_Q(G3(:,:,:,27),wf(:,1),G3(:,:,:,28))
  call loop_A_Q(G3(:,:,:,28),Q(:,59),ZERO,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,-2),G4tensor(:,18))
  call loop_AQ_V(G3(:,:,:,27),wf(:,-2),G3(:,:,:,29))
  call loop_VA_Q(G3(:,:,:,29),wf(:,-1),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,62),ZERO,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,0),G4tensor(:,19))
  call loop_VA_Q(G2(:,:,:,18),wf(:,37),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,59),ZERO,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,-2),G3tensor(:,6))
  call loop_VQ_A(G2(:,:,:,18),wf(:,40),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,61),ZERO,G3(:,:,:,32))
  call check_last_QA_V(l_switch,G3(:,:,:,32),wf(:,-1),G3tensor(:,7))
  call loop_VA_Q(G2(:,:,:,18),wf(:,42),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,62),ZERO,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,0),G3tensor(:,8))
  call loop_UV_W(G2(:,:,:,18),Q(:,48),wf(:,2),Q(:,12),G3(:,:,:,34))
  call loop_VA_Q(G3(:,:,:,34),wf(:,-1),G3(:,:,:,35))
  call loop_A_Q(G3(:,:,:,35),Q(:,62),ZERO,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,0),G4tensor(:,20))
  call loop_VA_Q(G2(:,:,:,18),wf(:,-1),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,50),ZERO,G3(:,:,:,36))
  call loop_AV_Q(G3(:,:,:,36),wf(:,2),G3(:,:,:,37))
  call loop_A_Q(G3(:,:,:,37),Q(:,62),ZERO,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,0),G4tensor(:,21))
  call loop_VQ_A(G2(:,:,:,18),wf(:,-2),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,52),ZERO,G3(:,:,:,38))
  call loop_QA_V(G3(:,:,:,38),wf(:,-3),G3(:,:,:,39))
  call loop_VA_Q(G3(:,:,:,39),wf(:,-1),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,62),ZERO,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,0),G4tensor(:,22))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,18),wf(:,1),wf(:,2),G2tensor(:,20))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,18),wf(:,2),wf(:,1),G2tensor(:,21))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,18),wf(:,1),wf(:,2),G2tensor(:,22))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,45),Q(:,51),G1(:,:,:,23))
  call loop_VA_Q(G1(:,:,:,23),wf(:,-3),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,59),ZERO,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,-2),G2tensor(:,23))
  call check_last_UV_W(l_switch,G1(:,:,:,23),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,24))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,60),G1(:,:,:,25))
  call loop_VA_Q(G1(:,:,:,25),wf(:,-1),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,62),ZERO,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,0),G2tensor(:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,25),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,60),ZERO,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,1),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,63),ZERO,G2tensor(:,27))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,60),G1(:,:,:,29))
  call check_last_CV_D(l_switch,G1(:,:,:,29),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,51),ZERO,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,2),G1(:,:,:,31))
  call check_last_Q_A(l_switch,G1(:,:,:,31),Q(:,63),ZERO,G2tensor(:,29))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,51),G1(:,:,:,32))
  call check_last_CV_D(l_switch,G1(:,:,:,32),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,51),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,2),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,63),ZERO,G2tensor(:,31))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,45),Q(:,51),G1(:,:,:,35))
  call check_last_CV_D(l_switch,G1(:,:,:,35),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,60),ZERO,G1(:,:,:,36))
  call loop_QV_A(G1(:,:,:,36),wf(:,1),G1(:,:,:,37))
  call check_last_Q_A(l_switch,G1(:,:,:,37),Q(:,63),ZERO,G2tensor(:,33))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,60),G1(:,:,:,38))
  call check_last_CV_D(l_switch,G1(:,:,:,38),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,34))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(1)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(2)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(13)*M(1)-c(10)*M(2)) * den(3)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(31)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(1)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(1)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,14)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(1)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,5)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(22)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(22)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(11)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(37)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(40)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(2)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(2)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,7)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(2)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,8)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(19)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(19)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2))
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(11)*M(1)+c(5)*M(2))
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,15)
  Gcoeff = (c(11)*M(1)+c(5)*M(2))
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2))
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,9)
  Gcoeff = (-(c(26)*M(1))+c(23)*M(2)) * den(46)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(25)*M(1))+c(21)*M(2)) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(25)*M(1))+c(21)*M(2)) * den(35)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(44)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(44)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(6)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,12)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(6)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(6)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,18)
  Gcoeff = (-(c(25)*M(1))+c(21)*M(2)) * den(38)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(25)*M(1))+c(21)*M(2)) * den(41)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(42)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(42)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(11)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(11)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(11)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,21)
  Gcoeff = (c(20)*M(1)-c(22)*M(2)) * den(4)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,13)
  Gcoeff = (-(c(24)*M(1))-c(18)*M(2)) * den(4)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,17)
  Gcoeff = (-(c(24)*M(1))-c(18)*M(2)) * den(4)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,19)
  Gcoeff = (c(20)*M(1)-c(22)*M(2)) * den(4)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,22)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,8)
  Gcoeff = (0) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(3)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(3)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(47)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(48)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(5)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(5)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,21)
  Gcoeff = (0) * den(5)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(20)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(2)) * den(20)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(13)*M(1))+c(10)*M(2)) * den(20)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(20)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(2)) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(13)*M(1))+c(10)*M(2)) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(23)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(32)*M(1)-c(31)*M(2)) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(34)*M(1)-c(33)*M(2)) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(26)*M(1)-c(23)*M(2)) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(32)*M(1)-c(31)*M(2)) * den(43)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(34)*M(1)-c(33)*M(2)) * den(43)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(26)*M(1)-c(23)*M(2)) * den(43)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(43)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,26)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_heftpphhjj_uuxddxhh_1_/**/REALKIND
