
module ol_vamp_1_heftpphhjj_ddxhhgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_ddxhhgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_ddxhhgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_ddxhhgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_ddxhhgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,78) :: G0
  complex(REALKIND), dimension(4,5,4,159) :: G1
  complex(REALKIND), dimension(4,15,4,214) :: G2
  complex(REALKIND), dimension(4,35,4,124) :: G3
  complex(REALKIND), dimension(4,70,4,78) :: G4
  complex(REALKIND), dimension(4,126,4,24) :: G5
  complex(REALKIND), dimension(5,107) :: G1tensor
  complex(REALKIND), dimension(15,98) :: G2tensor
  complex(REALKIND), dimension(35,118) :: G3tensor
  complex(REALKIND), dimension(70,44) :: G4tensor
  complex(REALKIND), dimension(126,30) :: G5tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-2),wf(:,-5),wf(:,-4),G0(:,:,:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-1),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,62),ZERO,G1(:,:,:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,1),wf(:,0),G1tensor(:,1))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,2))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-2),wf(:,-4),wf(:,-5),G0(:,:,:,4))
  call loop_VA_Q(G0(:,:,:,4),wf(:,-1),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,62),ZERO,G1(:,:,:,2))
  call check_last_AQ_V(l_switch,G1(:,:,:,2),wf(:,0),G1tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,4))
  call loop_GHHGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,-2),wf(:,-5),wf(:,-4),G0(:,:,:,6))
  call loop_VA_Q(G0(:,:,:,6),wf(:,-1),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,62),ZERO,G1(:,:,:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,3),wf(:,0),G1tensor(:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,6))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,4))
  call loop_GGG_G_12(G1(:,:,:,4),wf(:,-5),wf(:,1),G1(:,:,:,5))
  call check_last_GHH_G(l_switch,G1(:,:,:,5),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,1), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,5),Q(:,51),wf(:,3),G3tensor(:,2), Q(:,63))
  call loop_GGG_G_12(G1(:,:,:,4),wf(:,1),wf(:,-5),G1(:,:,:,6))
  call check_last_GHH_G(l_switch,G1(:,:,:,6),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,3), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,6),Q(:,51),wf(:,3),G3tensor(:,4), Q(:,63))
  call loop_GGG_G_23(G1(:,:,:,4),wf(:,-5),wf(:,1),G1(:,:,:,7))
  call check_last_GHH_G(l_switch,G1(:,:,:,7),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,5), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,7),Q(:,51),wf(:,3),G3tensor(:,6), Q(:,63))
  call loop_UV_W(G1(:,:,:,4),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,1))
  call check_last_GHHG_G(l_switch,G2(:,:,:,1),Q(:,48),wf(:,-3),wf(:,-2),wf(:,1),Q(:,3),G3tensor(:,7), Q(:,63))
  call check_last_GHG_G(l_switch,G2(:,:,:,1),Q(:,48),wf(:,3),wf(:,1),Q(:,3),G3tensor(:,8), Q(:,63))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,6),Q(:,15),G3tensor(:,9))
  call loop_GHH_G(G2(:,:,:,1),Q(:,48),wf(:,-3),wf(:,-2),G4(:,:,:,1), Q(:,60))
  call loop_VA_Q(G4(:,:,:,1),wf(:,-1),G4(:,:,:,2))
  call loop_A_Q(G4(:,:,:,2),Q(:,62),ZERO,G5(:,:,:,1))
  call check_last_AQ_V(l_switch,G5(:,:,:,1),wf(:,0),G5tensor(:,1))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,23),Q(:,15),G3tensor(:,10))
  call loop_GH_G(G2(:,:,:,1),Q(:,48),wf(:,3),G4(:,:,:,3), Q(:,60))
  call loop_VA_Q(G4(:,:,:,3),wf(:,-1),G4(:,:,:,4))
  call loop_A_Q(G4(:,:,:,4),Q(:,62),ZERO,G5(:,:,:,2))
  call check_last_AQ_V(l_switch,G5(:,:,:,2),wf(:,0),G5tensor(:,2))
  call loop_GHHG_G(G1(:,:,:,4),Q(:,16),wf(:,-3),wf(:,-2),wf(:,-5),Q(:,32),G2(:,:,:,2), Q(:,60))
  call check_last_UV_W(l_switch,G2(:,:,:,2),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,11))
  call loop_VA_Q(G2(:,:,:,2),wf(:,-1),G2(:,:,:,3))
  call loop_A_Q(G2(:,:,:,3),Q(:,62),ZERO,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,12))
  call loop_GHG_G(G1(:,:,:,4),Q(:,16),wf(:,3),wf(:,-5),Q(:,32),G2(:,:,:,4), Q(:,60))
  call check_last_UV_W(l_switch,G2(:,:,:,4),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,13))
  call loop_VA_Q(G2(:,:,:,4),wf(:,-1),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,62),ZERO,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,14))
  call loop_UV_W(G1(:,:,:,4),Q(:,16),wf(:,10),Q(:,35),G2(:,:,:,6))
  call check_last_GHH_G(l_switch,G2(:,:,:,6),Q(:,51),wf(:,-3),wf(:,-2),G4tensor(:,1), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,6),Q(:,51),wf(:,3),G4tensor(:,2), Q(:,63))
  call loop_GHH_G(G1(:,:,:,4),Q(:,16),wf(:,-3),wf(:,-2),G3(:,:,:,3), Q(:,28))
  call loop_UV_W(G3(:,:,:,3),Q(:,28),wf(:,-5),Q(:,32),G4(:,:,:,5))
  call check_last_UV_W(l_switch,G4(:,:,:,5),Q(:,60),wf(:,1),Q(:,3),G5tensor(:,3))
  call loop_VA_Q(G4(:,:,:,5),wf(:,-1),G4(:,:,:,6))
  call loop_A_Q(G4(:,:,:,6),Q(:,62),ZERO,G5(:,:,:,3))
  call check_last_AQ_V(l_switch,G5(:,:,:,3),wf(:,0),G5tensor(:,4))
  call loop_VQ_A(G3(:,:,:,3),wf(:,18),G3(:,:,:,4))
  call loop_Q_A(G3(:,:,:,4),Q(:,61),ZERO,G4(:,:,:,7))
  call check_last_QA_V(l_switch,G4(:,:,:,7),wf(:,-1),G4tensor(:,3))
  call loop_VA_Q(G3(:,:,:,3),wf(:,21),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,62),ZERO,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,4))
  call loop_VA_Q(G3(:,:,:,3),wf(:,-1),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,-5),G4(:,:,:,10))
  call loop_A_Q(G4(:,:,:,10),Q(:,62),ZERO,G5(:,:,:,4))
  call check_last_AQ_V(l_switch,G5(:,:,:,4),wf(:,0),G5tensor(:,5))
  call loop_UV_W(G1(:,:,:,4),Q(:,16),wf(:,7),Q(:,44),G2(:,:,:,7))
  call check_last_UV_W(l_switch,G2(:,:,:,7),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,15))
  call loop_VA_Q(G2(:,:,:,7),wf(:,-1),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,62),ZERO,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,16))
  call loop_UV_W(G1(:,:,:,4),Q(:,16),wf(:,19),Q(:,35),G2(:,:,:,9))
  call check_last_GHH_G(l_switch,G2(:,:,:,9),Q(:,51),wf(:,-3),wf(:,-2),G4tensor(:,5), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,9),Q(:,51),wf(:,3),G4tensor(:,6), Q(:,63))
  call loop_UV_W(G1(:,:,:,4),Q(:,16),wf(:,22),Q(:,35),G2(:,:,:,10))
  call check_last_GHH_G(l_switch,G2(:,:,:,10),Q(:,51),wf(:,-3),wf(:,-2),G4tensor(:,7), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,10),Q(:,51),wf(:,3),G4tensor(:,8), Q(:,63))
  call loop_VQ_A(G1(:,:,:,4),wf(:,143),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,61),ZERO,G2(:,:,:,11))
  call check_last_QA_V(l_switch,G2(:,:,:,11),wf(:,-1),G2tensor(:,1))
  call loop_VA_Q(G1(:,:,:,4),wf(:,140),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,62),ZERO,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,0),G2tensor(:,2))
  call loop_VA_Q(G1(:,:,:,4),wf(:,-1),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,18),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,7),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,62),ZERO,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,13),wf(:,24),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,62),ZERO,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,18))
  call loop_UV_W(G1(:,:,:,4),Q(:,16),wf(:,24),Q(:,44),G2(:,:,:,16))
  call check_last_UV_W(l_switch,G2(:,:,:,16),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,19))
  call loop_VA_Q(G2(:,:,:,16),wf(:,-1),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,62),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,20))
  call loop_GH_G(G1(:,:,:,4),Q(:,16),wf(:,3),G3(:,:,:,11), Q(:,28))
  call loop_UV_W(G3(:,:,:,11),Q(:,28),wf(:,-5),Q(:,32),G4(:,:,:,11))
  call check_last_UV_W(l_switch,G4(:,:,:,11),Q(:,60),wf(:,1),Q(:,3),G5tensor(:,6))
  call loop_VA_Q(G4(:,:,:,11),wf(:,-1),G4(:,:,:,12))
  call loop_A_Q(G4(:,:,:,12),Q(:,62),ZERO,G5(:,:,:,5))
  call check_last_AQ_V(l_switch,G5(:,:,:,5),wf(:,0),G5tensor(:,7))
  call loop_VQ_A(G3(:,:,:,11),wf(:,18),G3(:,:,:,12))
  call loop_Q_A(G3(:,:,:,12),Q(:,61),ZERO,G4(:,:,:,13))
  call check_last_QA_V(l_switch,G4(:,:,:,13),wf(:,-1),G4tensor(:,9))
  call loop_VA_Q(G3(:,:,:,11),wf(:,21),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,62),ZERO,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,0),G4tensor(:,10))
  call loop_VA_Q(G3(:,:,:,11),wf(:,-1),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,30),ZERO,G4(:,:,:,15))
  call loop_AV_Q(G4(:,:,:,15),wf(:,-5),G4(:,:,:,16))
  call loop_A_Q(G4(:,:,:,16),Q(:,62),ZERO,G5(:,:,:,6))
  call check_last_AQ_V(l_switch,G5(:,:,:,6),wf(:,0),G5tensor(:,8))
  call loop_VQ_A(G1(:,:,:,4),wf(:,197),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,61),ZERO,G2(:,:,:,18))
  call check_last_QA_V(l_switch,G2(:,:,:,18),wf(:,-1),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,4),wf(:,201),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,62),ZERO,G2(:,:,:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,19),wf(:,0),G2tensor(:,4))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,8))
  call loop_UV_W(G0(:,:,:,8),Q(:,19),wf(:,-5),Q(:,32),G1(:,:,:,13))
  call check_last_GHH_G(l_switch,G1(:,:,:,13),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,21), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,13),Q(:,51),wf(:,3),G3tensor(:,22), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,9))
  call loop_UV_W(G0(:,:,:,9),Q(:,19),wf(:,-5),Q(:,32),G1(:,:,:,14))
  call check_last_GHH_G(l_switch,G1(:,:,:,14),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,23), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,14),Q(:,51),wf(:,3),G3tensor(:,24), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,10))
  call loop_UV_W(G0(:,:,:,10),Q(:,19),wf(:,-5),Q(:,32),G1(:,:,:,15))
  call check_last_GHH_G(l_switch,G1(:,:,:,15),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,25), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,15),Q(:,51),wf(:,3),G3tensor(:,26), Q(:,63))
  call loop_GHH_G(G0(:,:,:,1),Q(:,0),wf(:,-3),wf(:,-2),G2(:,:,:,20), Q(:,12))
  call loop_GGG_G_12(G2(:,:,:,20),wf(:,-5),wf(:,-4),G2(:,:,:,21))
  call check_last_UV_W(l_switch,G2(:,:,:,21),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,27))
  call loop_VA_Q(G2(:,:,:,21),wf(:,-1),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,62),ZERO,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,0),G3tensor(:,28))
  call loop_GGG_G_12(G2(:,:,:,20),wf(:,-4),wf(:,-5),G2(:,:,:,23))
  call check_last_UV_W(l_switch,G2(:,:,:,23),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,29))
  call loop_VA_Q(G2(:,:,:,23),wf(:,-1),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,62),ZERO,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,0),G3tensor(:,30))
  call loop_GGG_G_23(G2(:,:,:,20),wf(:,-5),wf(:,-4),G2(:,:,:,25))
  call check_last_UV_W(l_switch,G2(:,:,:,25),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,31))
  call loop_VA_Q(G2(:,:,:,25),wf(:,-1),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,62),ZERO,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,0),G3tensor(:,32))
  call loop_UV_W(G2(:,:,:,20),Q(:,12),wf(:,5),Q(:,48),G3(:,:,:,18))
  call check_last_UV_W(l_switch,G3(:,:,:,18),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,11))
  call loop_VA_Q(G3(:,:,:,18),wf(:,-1),G3(:,:,:,19))
  call loop_A_Q(G3(:,:,:,19),Q(:,62),ZERO,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,0),G4tensor(:,12))
  call loop_UV_W(G2(:,:,:,20),Q(:,12),wf(:,-5),Q(:,32),G3(:,:,:,20))
  call loop_UV_W(G3(:,:,:,20),Q(:,44),wf(:,-4),Q(:,16),G4(:,:,:,18))
  call check_last_UV_W(l_switch,G4(:,:,:,18),Q(:,60),wf(:,1),Q(:,3),G5tensor(:,9))
  call loop_VA_Q(G4(:,:,:,18),wf(:,-1),G4(:,:,:,19))
  call loop_A_Q(G4(:,:,:,19),Q(:,62),ZERO,G5(:,:,:,7))
  call check_last_AQ_V(l_switch,G5(:,:,:,7),wf(:,0),G5tensor(:,10))
  call loop_VQ_A(G3(:,:,:,20),wf(:,12),G3(:,:,:,21))
  call loop_Q_A(G3(:,:,:,21),Q(:,61),ZERO,G4(:,:,:,20))
  call check_last_QA_V(l_switch,G4(:,:,:,20),wf(:,-1),G4tensor(:,13))
  call loop_VA_Q(G3(:,:,:,20),wf(:,15),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,62),ZERO,G4(:,:,:,21))
  call check_last_AQ_V(l_switch,G4(:,:,:,21),wf(:,0),G4tensor(:,14))
  call loop_VA_Q(G3(:,:,:,20),wf(:,-1),G3(:,:,:,23))
  call loop_A_Q(G3(:,:,:,23),Q(:,46),ZERO,G4(:,:,:,22))
  call loop_AV_Q(G4(:,:,:,22),wf(:,-4),G4(:,:,:,23))
  call loop_A_Q(G4(:,:,:,23),Q(:,62),ZERO,G5(:,:,:,8))
  call check_last_AQ_V(l_switch,G5(:,:,:,8),wf(:,0),G5tensor(:,11))
  call loop_UV_W(G2(:,:,:,20),Q(:,12),wf(:,-4),Q(:,16),G3(:,:,:,24))
  call loop_UV_W(G3(:,:,:,24),Q(:,28),wf(:,-5),Q(:,32),G4(:,:,:,24))
  call check_last_UV_W(l_switch,G4(:,:,:,24),Q(:,60),wf(:,1),Q(:,3),G5tensor(:,12))
  call loop_VA_Q(G4(:,:,:,24),wf(:,-1),G4(:,:,:,25))
  call loop_A_Q(G4(:,:,:,25),Q(:,62),ZERO,G5(:,:,:,9))
  call check_last_AQ_V(l_switch,G5(:,:,:,9),wf(:,0),G5tensor(:,13))
  call loop_VQ_A(G3(:,:,:,24),wf(:,18),G3(:,:,:,25))
  call loop_Q_A(G3(:,:,:,25),Q(:,61),ZERO,G4(:,:,:,26))
  call check_last_QA_V(l_switch,G4(:,:,:,26),wf(:,-1),G4tensor(:,15))
  call loop_VA_Q(G3(:,:,:,24),wf(:,21),G3(:,:,:,26))
  call loop_A_Q(G3(:,:,:,26),Q(:,62),ZERO,G4(:,:,:,27))
  call check_last_AQ_V(l_switch,G4(:,:,:,27),wf(:,0),G4tensor(:,16))
  call loop_VA_Q(G3(:,:,:,24),wf(:,-1),G3(:,:,:,27))
  call loop_A_Q(G3(:,:,:,27),Q(:,30),ZERO,G4(:,:,:,28))
  call loop_AV_Q(G4(:,:,:,28),wf(:,-5),G4(:,:,:,29))
  call loop_A_Q(G4(:,:,:,29),Q(:,62),ZERO,G5(:,:,:,10))
  call check_last_AQ_V(l_switch,G5(:,:,:,10),wf(:,0),G5tensor(:,14))
  call loop_VQ_A(G2(:,:,:,20),wf(:,164),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,61),ZERO,G3(:,:,:,28))
  call check_last_QA_V(l_switch,G3(:,:,:,28),wf(:,-1),G3tensor(:,33))
  call loop_VQ_A(G2(:,:,:,20),wf(:,12),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,29),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-5),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,61),ZERO,G4(:,:,:,30))
  call check_last_QA_V(l_switch,G4(:,:,:,30),wf(:,-1),G4tensor(:,17))
  call loop_VA_Q(G2(:,:,:,20),wf(:,171),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,62),ZERO,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,34))
  call loop_VA_Q(G2(:,:,:,20),wf(:,15),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,30),ZERO,G3(:,:,:,32))
  call loop_AV_Q(G3(:,:,:,32),wf(:,-5),G3(:,:,:,33))
  call loop_A_Q(G3(:,:,:,33),Q(:,62),ZERO,G4(:,:,:,31))
  call check_last_AQ_V(l_switch,G4(:,:,:,31),wf(:,0),G4tensor(:,18))
  call loop_VQ_A(G2(:,:,:,20),wf(:,166),G2(:,:,:,31))
  call loop_Q_A(G2(:,:,:,31),Q(:,61),ZERO,G3(:,:,:,34))
  call check_last_QA_V(l_switch,G3(:,:,:,34),wf(:,-1),G3tensor(:,35))
  call loop_VQ_A(G2(:,:,:,20),wf(:,18),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,45),ZERO,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,-4),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,61),ZERO,G4(:,:,:,32))
  call check_last_QA_V(l_switch,G4(:,:,:,32),wf(:,-1),G4tensor(:,19))
  call loop_VA_Q(G2(:,:,:,20),wf(:,173),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,62),ZERO,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,0),G3tensor(:,36))
  call loop_VA_Q(G2(:,:,:,20),wf(:,21),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,46),ZERO,G3(:,:,:,38))
  call loop_AV_Q(G3(:,:,:,38),wf(:,-4),G3(:,:,:,39))
  call loop_A_Q(G3(:,:,:,39),Q(:,62),ZERO,G4(:,:,:,33))
  call check_last_AQ_V(l_switch,G4(:,:,:,33),wf(:,0),G4tensor(:,20))
  call loop_VQ_A(G2(:,:,:,20),wf(:,168),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,61),ZERO,G3(:,:,:,40))
  call check_last_QA_V(l_switch,G3(:,:,:,40),wf(:,-1),G3tensor(:,37))
  call loop_VA_Q(G2(:,:,:,20),wf(:,175),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,62),ZERO,G3(:,:,:,41))
  call check_last_AQ_V(l_switch,G3(:,:,:,41),wf(:,0),G3tensor(:,38))
  call loop_VA_Q(G2(:,:,:,20),wf(:,-1),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,14),ZERO,G3(:,:,:,42))
  call loop_AV_Q(G3(:,:,:,42),wf(:,5),G3(:,:,:,43))
  call loop_A_Q(G3(:,:,:,43),Q(:,62),ZERO,G4(:,:,:,34))
  call check_last_AQ_V(l_switch,G4(:,:,:,34),wf(:,0),G4tensor(:,21))
  call loop_AV_Q(G3(:,:,:,42),wf(:,-5),G3(:,:,:,44))
  call loop_A_Q(G3(:,:,:,44),Q(:,46),ZERO,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,-4),G4(:,:,:,36))
  call loop_A_Q(G4(:,:,:,36),Q(:,62),ZERO,G5(:,:,:,11))
  call check_last_AQ_V(l_switch,G5(:,:,:,11),wf(:,0),G5tensor(:,15))
  call loop_AV_Q(G3(:,:,:,42),wf(:,-4),G3(:,:,:,45))
  call loop_A_Q(G3(:,:,:,45),Q(:,30),ZERO,G4(:,:,:,37))
  call loop_AV_Q(G4(:,:,:,37),wf(:,-5),G4(:,:,:,38))
  call loop_A_Q(G4(:,:,:,38),Q(:,62),ZERO,G5(:,:,:,12))
  call check_last_AQ_V(l_switch,G5(:,:,:,12),wf(:,0),G5tensor(:,16))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G1(:,:,:,16), Q(:,28))
  call loop_UV_W(G1(:,:,:,16),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,38))
  call check_last_UV_W(l_switch,G2(:,:,:,38),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,39))
  call loop_VA_Q(G2(:,:,:,38),wf(:,-1),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,62),ZERO,G3(:,:,:,46))
  call check_last_AQ_V(l_switch,G3(:,:,:,46),wf(:,0),G3tensor(:,40))
  call loop_VQ_A(G1(:,:,:,16),wf(:,18),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,61),ZERO,G2(:,:,:,40))
  call check_last_QA_V(l_switch,G2(:,:,:,40),wf(:,-1),G2tensor(:,5))
  call loop_VA_Q(G1(:,:,:,16),wf(:,21),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,62),ZERO,G2(:,:,:,41))
  call check_last_AQ_V(l_switch,G2(:,:,:,41),wf(:,0),G2tensor(:,6))
  call loop_VA_Q(G1(:,:,:,16),wf(:,-1),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,30),ZERO,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-5),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,62),ZERO,G3(:,:,:,47))
  call check_last_AQ_V(l_switch,G3(:,:,:,47),wf(:,0),G3tensor(:,41))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,-5),wf(:,-4),G0(:,:,:,11))
  call loop_VA_Q(G0(:,:,:,11),wf(:,-1),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,62),ZERO,G1(:,:,:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,20),wf(:,0),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,11),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,8))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,-4),wf(:,-5),G0(:,:,:,13))
  call loop_VA_Q(G0(:,:,:,13),wf(:,-1),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,62),ZERO,G1(:,:,:,21))
  call check_last_AQ_V(l_switch,G1(:,:,:,21),wf(:,0),G1tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,13),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,10))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,3),wf(:,-5),wf(:,-4),G0(:,:,:,15))
  call loop_VA_Q(G0(:,:,:,15),wf(:,-1),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,62),ZERO,G1(:,:,:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,22),wf(:,0),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,9),G0(:,:,:,17))
  call loop_VA_Q(G0(:,:,:,17),wf(:,-1),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,62),ZERO,G1(:,:,:,23))
  call check_last_AQ_V(l_switch,G1(:,:,:,23),wf(:,0),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,14))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,9),wf(:,-5),G0(:,:,:,19))
  call loop_VA_Q(G0(:,:,:,19),wf(:,-1),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,62),ZERO,G1(:,:,:,24))
  call check_last_AQ_V(l_switch,G1(:,:,:,24),wf(:,0),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,16))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,9),G0(:,:,:,21))
  call loop_VA_Q(G0(:,:,:,21),wf(:,-1),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,62),ZERO,G1(:,:,:,25))
  call check_last_AQ_V(l_switch,G1(:,:,:,25),wf(:,0),G1tensor(:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,18))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,7),G0(:,:,:,23))
  call loop_VA_Q(G0(:,:,:,23),wf(:,-1),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,62),ZERO,G1(:,:,:,26))
  call check_last_AQ_V(l_switch,G1(:,:,:,26),wf(:,0),G1tensor(:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,20))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,-4),G0(:,:,:,25))
  call loop_VA_Q(G0(:,:,:,25),wf(:,-1),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,62),ZERO,G1(:,:,:,27))
  call check_last_AQ_V(l_switch,G1(:,:,:,27),wf(:,0),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,22))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,7),G0(:,:,:,27))
  call loop_VA_Q(G0(:,:,:,27),wf(:,-1),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,62),ZERO,G1(:,:,:,28))
  call check_last_AQ_V(l_switch,G1(:,:,:,28),wf(:,0),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,24))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,29))
  call loop_GHH_G(G0(:,:,:,29),Q(:,48),wf(:,-3),wf(:,-2),G2(:,:,:,44), Q(:,60))
  call loop_VA_Q(G2(:,:,:,44),wf(:,-1),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,62),ZERO,G3(:,:,:,48))
  call check_last_AQ_V(l_switch,G3(:,:,:,48),wf(:,0),G3tensor(:,42))
  call loop_GH_G(G0(:,:,:,29),Q(:,48),wf(:,3),G2(:,:,:,46), Q(:,60))
  call loop_VA_Q(G2(:,:,:,46),wf(:,-1),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,62),ZERO,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,0),G3tensor(:,43))
  call check_last_GHHG_G(l_switch,G0(:,:,:,29),Q(:,48),wf(:,-3),wf(:,-2),wf(:,1),Q(:,3),G1tensor(:,25), Q(:,63))
  call check_last_GHG_G(l_switch,G0(:,:,:,29),Q(:,48),wf(:,3),wf(:,1),Q(:,3),G1tensor(:,26), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,6),Q(:,15),G1tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,48),wf(:,23),Q(:,15),G1tensor(:,28))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-5),G0(:,:,:,30))
  call loop_GHH_G(G0(:,:,:,30),Q(:,48),wf(:,-3),wf(:,-2),G2(:,:,:,48), Q(:,60))
  call loop_VA_Q(G2(:,:,:,48),wf(:,-1),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,62),ZERO,G3(:,:,:,50))
  call check_last_AQ_V(l_switch,G3(:,:,:,50),wf(:,0),G3tensor(:,44))
  call loop_GH_G(G0(:,:,:,30),Q(:,48),wf(:,3),G2(:,:,:,50), Q(:,60))
  call loop_VA_Q(G2(:,:,:,50),wf(:,-1),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,62),ZERO,G3(:,:,:,51))
  call check_last_AQ_V(l_switch,G3(:,:,:,51),wf(:,0),G3tensor(:,45))
  call check_last_GHHG_G(l_switch,G0(:,:,:,30),Q(:,48),wf(:,-3),wf(:,-2),wf(:,1),Q(:,3),G1tensor(:,29), Q(:,63))
  call check_last_GHG_G(l_switch,G0(:,:,:,30),Q(:,48),wf(:,3),wf(:,1),Q(:,3),G1tensor(:,30), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,48),wf(:,6),Q(:,15),G1tensor(:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,48),wf(:,23),Q(:,15),G1tensor(:,32))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,-4),G0(:,:,:,31))
  call loop_GHH_G(G0(:,:,:,31),Q(:,48),wf(:,-3),wf(:,-2),G2(:,:,:,52), Q(:,60))
  call loop_VA_Q(G2(:,:,:,52),wf(:,-1),G2(:,:,:,53))
  call loop_A_Q(G2(:,:,:,53),Q(:,62),ZERO,G3(:,:,:,52))
  call check_last_AQ_V(l_switch,G3(:,:,:,52),wf(:,0),G3tensor(:,46))
  call loop_GH_G(G0(:,:,:,31),Q(:,48),wf(:,3),G2(:,:,:,54), Q(:,60))
  call loop_VA_Q(G2(:,:,:,54),wf(:,-1),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,62),ZERO,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,0),G3tensor(:,47))
  call check_last_GHHG_G(l_switch,G0(:,:,:,31),Q(:,48),wf(:,-3),wf(:,-2),wf(:,1),Q(:,3),G1tensor(:,33), Q(:,63))
  call check_last_GHG_G(l_switch,G0(:,:,:,31),Q(:,48),wf(:,3),wf(:,1),Q(:,3),G1tensor(:,34), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,48),wf(:,6),Q(:,15),G1tensor(:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,48),wf(:,23),Q(:,15),G1tensor(:,36))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-3),wf(:,-2),wf(:,-5),Q(:,32),G1(:,:,:,29), Q(:,44))
  call loop_VQ_A(G1(:,:,:,29),wf(:,12),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,61),ZERO,G2(:,:,:,56))
  call check_last_QA_V(l_switch,G2(:,:,:,56),wf(:,-1),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,29),wf(:,15),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,62),ZERO,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,0),G2tensor(:,8))
  call loop_UV_W(G1(:,:,:,29),Q(:,44),wf(:,-4),Q(:,16),G2(:,:,:,58))
  call loop_VA_Q(G2(:,:,:,58),wf(:,-1),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,62),ZERO,G3(:,:,:,54))
  call check_last_AQ_V(l_switch,G3(:,:,:,54),wf(:,0),G3tensor(:,48))
  call loop_VA_Q(G1(:,:,:,29),wf(:,-1),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,46),ZERO,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-4),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,62),ZERO,G3(:,:,:,55))
  call check_last_AQ_V(l_switch,G3(:,:,:,55),wf(:,0),G3tensor(:,49))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,29),wf(:,-4),wf(:,1),G1tensor(:,37))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,29),wf(:,1),wf(:,-4),G1tensor(:,38))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,29),wf(:,-4),wf(:,1),G1tensor(:,39))
  call check_last_UV_W(l_switch,G1(:,:,:,29),Q(:,44),wf(:,8),Q(:,19),G2tensor(:,9))
  call check_last_UV_W(l_switch,G1(:,:,:,29),Q(:,44),wf(:,13),Q(:,19),G2tensor(:,10))
  call check_last_UV_W(l_switch,G1(:,:,:,29),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,11))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-3),wf(:,-2),wf(:,5),Q(:,48),G1(:,:,:,33), Q(:,60))
  call loop_VA_Q(G1(:,:,:,33),wf(:,-1),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,62),ZERO,G2(:,:,:,62))
  call check_last_AQ_V(l_switch,G2(:,:,:,62),wf(:,0),G2tensor(:,12))
  call check_last_UV_W(l_switch,G1(:,:,:,33),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,13))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-5),Q(:,32),G1(:,:,:,35))
  call loop_GHHG_G(G1(:,:,:,35),Q(:,32),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G2(:,:,:,63), Q(:,60))
  call loop_VA_Q(G2(:,:,:,63),wf(:,-1),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,62),ZERO,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,0),G3tensor(:,50))
  call loop_GHG_G(G1(:,:,:,35),Q(:,32),wf(:,3),wf(:,-4),Q(:,16),G2(:,:,:,65), Q(:,60))
  call loop_VA_Q(G2(:,:,:,65),wf(:,-1),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,62),ZERO,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,0),G3tensor(:,51))
  call loop_GHH_G(G1(:,:,:,35),Q(:,32),wf(:,-3),wf(:,-2),G3(:,:,:,58), Q(:,44))
  call loop_VQ_A(G3(:,:,:,58),wf(:,12),G3(:,:,:,59))
  call loop_Q_A(G3(:,:,:,59),Q(:,61),ZERO,G4(:,:,:,39))
  call check_last_QA_V(l_switch,G4(:,:,:,39),wf(:,-1),G4tensor(:,22))
  call loop_VA_Q(G3(:,:,:,58),wf(:,15),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,62),ZERO,G4(:,:,:,40))
  call check_last_AQ_V(l_switch,G4(:,:,:,40),wf(:,0),G4tensor(:,23))
  call loop_UV_W(G3(:,:,:,58),Q(:,44),wf(:,-4),Q(:,16),G4(:,:,:,41))
  call loop_VA_Q(G4(:,:,:,41),wf(:,-1),G4(:,:,:,42))
  call loop_A_Q(G4(:,:,:,42),Q(:,62),ZERO,G5(:,:,:,13))
  call check_last_AQ_V(l_switch,G5(:,:,:,13),wf(:,0),G5tensor(:,17))
  call loop_VA_Q(G3(:,:,:,58),wf(:,-1),G3(:,:,:,61))
  call loop_A_Q(G3(:,:,:,61),Q(:,46),ZERO,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,-4),G4(:,:,:,44))
  call loop_A_Q(G4(:,:,:,44),Q(:,62),ZERO,G5(:,:,:,14))
  call check_last_AQ_V(l_switch,G5(:,:,:,14),wf(:,0),G5tensor(:,18))
  call loop_UV_W(G1(:,:,:,35),Q(:,32),wf(:,-4),Q(:,16),G2(:,:,:,67))
  call loop_GHH_G(G2(:,:,:,67),Q(:,48),wf(:,-3),wf(:,-2),G4(:,:,:,45), Q(:,60))
  call loop_VA_Q(G4(:,:,:,45),wf(:,-1),G4(:,:,:,46))
  call loop_A_Q(G4(:,:,:,46),Q(:,62),ZERO,G5(:,:,:,15))
  call check_last_AQ_V(l_switch,G5(:,:,:,15),wf(:,0),G5tensor(:,19))
  call loop_GH_G(G2(:,:,:,67),Q(:,48),wf(:,3),G4(:,:,:,47), Q(:,60))
  call loop_VA_Q(G4(:,:,:,47),wf(:,-1),G4(:,:,:,48))
  call loop_A_Q(G4(:,:,:,48),Q(:,62),ZERO,G5(:,:,:,16))
  call check_last_AQ_V(l_switch,G5(:,:,:,16),wf(:,0),G5tensor(:,20))
  call loop_VQ_A(G1(:,:,:,35),wf(:,149),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,61),ZERO,G2(:,:,:,68))
  call check_last_QA_V(l_switch,G2(:,:,:,68),wf(:,-1),G2tensor(:,14))
  call loop_VA_Q(G1(:,:,:,35),wf(:,146),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,62),ZERO,G2(:,:,:,69))
  call check_last_AQ_V(l_switch,G2(:,:,:,69),wf(:,0),G2tensor(:,15))
  call loop_UV_W(G1(:,:,:,35),Q(:,32),wf(:,9),Q(:,28),G2(:,:,:,70))
  call loop_VA_Q(G2(:,:,:,70),wf(:,-1),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,62),ZERO,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,0),G3tensor(:,52))
  call loop_VA_Q(G1(:,:,:,35),wf(:,-1),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,34),ZERO,G2(:,:,:,72))
  call loop_AV_Q(G2(:,:,:,72),wf(:,9),G2(:,:,:,73))
  call loop_A_Q(G2(:,:,:,73),Q(:,62),ZERO,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,0),G3tensor(:,53))
  call loop_AV_Q(G2(:,:,:,72),wf(:,25),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,62),ZERO,G3(:,:,:,64))
  call check_last_AQ_V(l_switch,G3(:,:,:,64),wf(:,0),G3tensor(:,54))
  call loop_GH_G(G1(:,:,:,35),Q(:,32),wf(:,3),G3(:,:,:,65), Q(:,44))
  call loop_VQ_A(G3(:,:,:,65),wf(:,12),G3(:,:,:,66))
  call loop_Q_A(G3(:,:,:,66),Q(:,61),ZERO,G4(:,:,:,49))
  call check_last_QA_V(l_switch,G4(:,:,:,49),wf(:,-1),G4tensor(:,24))
  call loop_VA_Q(G3(:,:,:,65),wf(:,15),G3(:,:,:,67))
  call loop_A_Q(G3(:,:,:,67),Q(:,62),ZERO,G4(:,:,:,50))
  call check_last_AQ_V(l_switch,G4(:,:,:,50),wf(:,0),G4tensor(:,25))
  call loop_UV_W(G3(:,:,:,65),Q(:,44),wf(:,-4),Q(:,16),G4(:,:,:,51))
  call loop_VA_Q(G4(:,:,:,51),wf(:,-1),G4(:,:,:,52))
  call loop_A_Q(G4(:,:,:,52),Q(:,62),ZERO,G5(:,:,:,17))
  call check_last_AQ_V(l_switch,G5(:,:,:,17),wf(:,0),G5tensor(:,21))
  call loop_VA_Q(G3(:,:,:,65),wf(:,-1),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,46),ZERO,G4(:,:,:,53))
  call loop_AV_Q(G4(:,:,:,53),wf(:,-4),G4(:,:,:,54))
  call loop_A_Q(G4(:,:,:,54),Q(:,62),ZERO,G5(:,:,:,18))
  call check_last_AQ_V(l_switch,G5(:,:,:,18),wf(:,0),G5tensor(:,22))
  call loop_VQ_A(G1(:,:,:,35),wf(:,195),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,61),ZERO,G2(:,:,:,75))
  call check_last_QA_V(l_switch,G2(:,:,:,75),wf(:,-1),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,35),wf(:,199),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,62),ZERO,G2(:,:,:,76))
  call check_last_AQ_V(l_switch,G2(:,:,:,76),wf(:,0),G2tensor(:,17))
  call loop_UV_W(G1(:,:,:,35),Q(:,32),wf(:,25),Q(:,28),G2(:,:,:,77))
  call loop_VA_Q(G2(:,:,:,77),wf(:,-1),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,62),ZERO,G3(:,:,:,69))
  call check_last_AQ_V(l_switch,G3(:,:,:,69),wf(:,0),G3tensor(:,55))
  call check_last_GHHGG_G_12(l_switch,G1(:,:,:,35),wf(:,-3),wf(:,-2),wf(:,-4),wf(:,1),G1tensor(:,40))
  call check_last_GHHGG_G_12(l_switch,G1(:,:,:,35),wf(:,-3),wf(:,-2),wf(:,1),wf(:,-4),G1tensor(:,41))
  call check_last_GHHGG_G_23(l_switch,G1(:,:,:,35),wf(:,-3),wf(:,-2),wf(:,-4),wf(:,1),G1tensor(:,42))
  call check_last_GHGG_G_12(l_switch,G1(:,:,:,35),wf(:,3),wf(:,-4),wf(:,1),G1tensor(:,43))
  call check_last_GHGG_G_12(l_switch,G1(:,:,:,35),wf(:,3),wf(:,1),wf(:,-4),G1tensor(:,44))
  call check_last_GHGG_G_23(l_switch,G1(:,:,:,35),wf(:,3),wf(:,-4),wf(:,1),G1tensor(:,45))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,1),wf(:,9),G1tensor(:,46))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,9),wf(:,1),G1tensor(:,47))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,35),wf(:,1),wf(:,9),G1tensor(:,48))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,-4),wf(:,6),G1tensor(:,49))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,6),wf(:,-4),G1tensor(:,50))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,35),wf(:,-4),wf(:,6),G1tensor(:,51))
  call check_last_GHHG_G(l_switch,G1(:,:,:,35),Q(:,32),wf(:,-3),wf(:,-2),wf(:,8),Q(:,19),G2tensor(:,18), Q(:,63))
  call check_last_GHHG_G(l_switch,G1(:,:,:,35),Q(:,32),wf(:,-3),wf(:,-2),wf(:,13),Q(:,19),G2tensor(:,19), Q(:,63))
  call check_last_GHHG_G(l_switch,G1(:,:,:,35),Q(:,32),wf(:,-3),wf(:,-2),wf(:,16),Q(:,19),G2tensor(:,20), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,35),Q(:,32),wf(:,3),wf(:,8),Q(:,19),G2tensor(:,21), Q(:,63))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,1),wf(:,25),G1tensor(:,52))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,25),wf(:,1),G1tensor(:,53))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,35),wf(:,1),wf(:,25),G1tensor(:,54))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,-4),wf(:,23),G1tensor(:,55))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,35),wf(:,23),wf(:,-4),G1tensor(:,56))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,35),wf(:,-4),wf(:,23),G1tensor(:,57))
  call check_last_GHG_G(l_switch,G1(:,:,:,35),Q(:,32),wf(:,3),wf(:,13),Q(:,19),G2tensor(:,22), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,35),Q(:,32),wf(:,3),wf(:,16),Q(:,19),G2tensor(:,23), Q(:,63))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,2),ZERO,G1(:,:,:,41))
  call loop_AV_Q(G1(:,:,:,41),wf(:,2),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,62),ZERO,G2(:,:,:,79))
  call check_last_AQ_V(l_switch,G2(:,:,:,79),wf(:,0),G2tensor(:,24))
  call loop_AV_Q(G1(:,:,:,41),wf(:,92),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,62),ZERO,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,0),G2tensor(:,25))
  call loop_AV_Q(G1(:,:,:,41),wf(:,106),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,62),ZERO,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,0),G2tensor(:,26))
  call loop_AV_Q(G1(:,:,:,41),wf(:,108),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,62),ZERO,G2(:,:,:,82))
  call check_last_AQ_V(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,27))
  call loop_AV_Q(G1(:,:,:,41),wf(:,7),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,46),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-4),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,62),ZERO,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,0),G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-4),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,18),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,7),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,62),ZERO,G3(:,:,:,71))
  call check_last_AQ_V(l_switch,G3(:,:,:,71),wf(:,0),G3tensor(:,57))
  call loop_AV_Q(G2(:,:,:,85),wf(:,24),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,62),ZERO,G3(:,:,:,72))
  call check_last_AQ_V(l_switch,G3(:,:,:,72),wf(:,0),G3tensor(:,58))
  call loop_AV_Q(G1(:,:,:,41),wf(:,110),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,62),ZERO,G2(:,:,:,88))
  call check_last_AQ_V(l_switch,G2(:,:,:,88),wf(:,0),G2tensor(:,28))
  call loop_AV_Q(G1(:,:,:,41),wf(:,9),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,30),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-5),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,62),ZERO,G3(:,:,:,73))
  call check_last_AQ_V(l_switch,G3(:,:,:,73),wf(:,0),G3tensor(:,59))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-5),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,34),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,9),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,62),ZERO,G3(:,:,:,74))
  call check_last_AQ_V(l_switch,G3(:,:,:,74),wf(:,0),G3tensor(:,60))
  call loop_AV_Q(G2(:,:,:,91),wf(:,25),G2(:,:,:,93))
  call loop_A_Q(G2(:,:,:,93),Q(:,62),ZERO,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,0),G3tensor(:,61))
  call loop_AV_Q(G1(:,:,:,41),wf(:,177),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,62),ZERO,G2(:,:,:,94))
  call check_last_AQ_V(l_switch,G2(:,:,:,94),wf(:,0),G2tensor(:,29))
  call loop_AV_Q(G1(:,:,:,41),wf(:,202),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,62),ZERO,G2(:,:,:,95))
  call check_last_AQ_V(l_switch,G2(:,:,:,95),wf(:,0),G2tensor(:,30))
  call loop_AV_Q(G1(:,:,:,41),wf(:,25),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,30),ZERO,G2(:,:,:,96))
  call loop_AV_Q(G2(:,:,:,96),wf(:,-5),G2(:,:,:,97))
  call loop_A_Q(G2(:,:,:,97),Q(:,62),ZERO,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,0),G3tensor(:,62))
  call loop_AV_Q(G1(:,:,:,41),wf(:,203),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,62),ZERO,G2(:,:,:,98))
  call check_last_AQ_V(l_switch,G2(:,:,:,98),wf(:,0),G2tensor(:,31))
  call loop_AV_Q(G1(:,:,:,41),wf(:,24),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,46),ZERO,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-4),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,62),ZERO,G3(:,:,:,77))
  call check_last_AQ_V(l_switch,G3(:,:,:,77),wf(:,0),G3tensor(:,63))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,60),G1(:,:,:,56))
  call loop_VA_Q(G1(:,:,:,56),wf(:,-1),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,62),ZERO,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,0),G2tensor(:,32))
  call check_last_UV_W(l_switch,G1(:,:,:,56),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,33))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,3),wf(:,-4),Q(:,16),G1(:,:,:,58), Q(:,28))
  call loop_UV_W(G1(:,:,:,58),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,102))
  call check_last_UV_W(l_switch,G2(:,:,:,102),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,64))
  call loop_VA_Q(G2(:,:,:,102),wf(:,-1),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,62),ZERO,G3(:,:,:,78))
  call check_last_AQ_V(l_switch,G3(:,:,:,78),wf(:,0),G3tensor(:,65))
  call loop_VQ_A(G1(:,:,:,58),wf(:,18),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,61),ZERO,G2(:,:,:,104))
  call check_last_QA_V(l_switch,G2(:,:,:,104),wf(:,-1),G2tensor(:,34))
  call loop_VA_Q(G1(:,:,:,58),wf(:,21),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,62),ZERO,G2(:,:,:,105))
  call check_last_AQ_V(l_switch,G2(:,:,:,105),wf(:,0),G2tensor(:,35))
  call loop_VA_Q(G1(:,:,:,58),wf(:,-1),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,30),ZERO,G2(:,:,:,106))
  call loop_AV_Q(G2(:,:,:,106),wf(:,-5),G2(:,:,:,107))
  call loop_A_Q(G2(:,:,:,107),Q(:,62),ZERO,G3(:,:,:,79))
  call check_last_AQ_V(l_switch,G3(:,:,:,79),wf(:,0),G3tensor(:,66))
  call loop_GH_G(G0(:,:,:,1),Q(:,0),wf(:,3),G2(:,:,:,108), Q(:,12))
  call loop_GGG_G_12(G2(:,:,:,108),wf(:,-5),wf(:,-4),G2(:,:,:,109))
  call check_last_UV_W(l_switch,G2(:,:,:,109),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,67))
  call loop_VA_Q(G2(:,:,:,109),wf(:,-1),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,62),ZERO,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,0),G3tensor(:,68))
  call loop_GGG_G_12(G2(:,:,:,108),wf(:,-4),wf(:,-5),G2(:,:,:,111))
  call check_last_UV_W(l_switch,G2(:,:,:,111),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,69))
  call loop_VA_Q(G2(:,:,:,111),wf(:,-1),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,62),ZERO,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,0),G3tensor(:,70))
  call loop_GGG_G_23(G2(:,:,:,108),wf(:,-5),wf(:,-4),G2(:,:,:,113))
  call check_last_UV_W(l_switch,G2(:,:,:,113),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,71))
  call loop_VA_Q(G2(:,:,:,113),wf(:,-1),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,62),ZERO,G3(:,:,:,82))
  call check_last_AQ_V(l_switch,G3(:,:,:,82),wf(:,0),G3tensor(:,72))
  call loop_UV_W(G2(:,:,:,108),Q(:,12),wf(:,5),Q(:,48),G3(:,:,:,83))
  call check_last_UV_W(l_switch,G3(:,:,:,83),Q(:,60),wf(:,1),Q(:,3),G4tensor(:,26))
  call loop_VA_Q(G3(:,:,:,83),wf(:,-1),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,62),ZERO,G4(:,:,:,55))
  call check_last_AQ_V(l_switch,G4(:,:,:,55),wf(:,0),G4tensor(:,27))
  call loop_UV_W(G2(:,:,:,108),Q(:,12),wf(:,-5),Q(:,32),G3(:,:,:,85))
  call loop_UV_W(G3(:,:,:,85),Q(:,44),wf(:,-4),Q(:,16),G4(:,:,:,56))
  call check_last_UV_W(l_switch,G4(:,:,:,56),Q(:,60),wf(:,1),Q(:,3),G5tensor(:,23))
  call loop_VA_Q(G4(:,:,:,56),wf(:,-1),G4(:,:,:,57))
  call loop_A_Q(G4(:,:,:,57),Q(:,62),ZERO,G5(:,:,:,19))
  call check_last_AQ_V(l_switch,G5(:,:,:,19),wf(:,0),G5tensor(:,24))
  call loop_VQ_A(G3(:,:,:,85),wf(:,12),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,61),ZERO,G4(:,:,:,58))
  call check_last_QA_V(l_switch,G4(:,:,:,58),wf(:,-1),G4tensor(:,28))
  call loop_VA_Q(G3(:,:,:,85),wf(:,15),G3(:,:,:,87))
  call loop_A_Q(G3(:,:,:,87),Q(:,62),ZERO,G4(:,:,:,59))
  call check_last_AQ_V(l_switch,G4(:,:,:,59),wf(:,0),G4tensor(:,29))
  call loop_VA_Q(G3(:,:,:,85),wf(:,-1),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,46),ZERO,G4(:,:,:,60))
  call loop_AV_Q(G4(:,:,:,60),wf(:,-4),G4(:,:,:,61))
  call loop_A_Q(G4(:,:,:,61),Q(:,62),ZERO,G5(:,:,:,20))
  call check_last_AQ_V(l_switch,G5(:,:,:,20),wf(:,0),G5tensor(:,25))
  call loop_UV_W(G2(:,:,:,108),Q(:,12),wf(:,-4),Q(:,16),G3(:,:,:,89))
  call loop_UV_W(G3(:,:,:,89),Q(:,28),wf(:,-5),Q(:,32),G4(:,:,:,62))
  call check_last_UV_W(l_switch,G4(:,:,:,62),Q(:,60),wf(:,1),Q(:,3),G5tensor(:,26))
  call loop_VA_Q(G4(:,:,:,62),wf(:,-1),G4(:,:,:,63))
  call loop_A_Q(G4(:,:,:,63),Q(:,62),ZERO,G5(:,:,:,21))
  call check_last_AQ_V(l_switch,G5(:,:,:,21),wf(:,0),G5tensor(:,27))
  call loop_VQ_A(G3(:,:,:,89),wf(:,18),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,61),ZERO,G4(:,:,:,64))
  call check_last_QA_V(l_switch,G4(:,:,:,64),wf(:,-1),G4tensor(:,30))
  call loop_VA_Q(G3(:,:,:,89),wf(:,21),G3(:,:,:,91))
  call loop_A_Q(G3(:,:,:,91),Q(:,62),ZERO,G4(:,:,:,65))
  call check_last_AQ_V(l_switch,G4(:,:,:,65),wf(:,0),G4tensor(:,31))
  call loop_VA_Q(G3(:,:,:,89),wf(:,-1),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,30),ZERO,G4(:,:,:,66))
  call loop_AV_Q(G4(:,:,:,66),wf(:,-5),G4(:,:,:,67))
  call loop_A_Q(G4(:,:,:,67),Q(:,62),ZERO,G5(:,:,:,22))
  call check_last_AQ_V(l_switch,G5(:,:,:,22),wf(:,0),G5tensor(:,28))
  call loop_VQ_A(G2(:,:,:,108),wf(:,164),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,61),ZERO,G3(:,:,:,93))
  call check_last_QA_V(l_switch,G3(:,:,:,93),wf(:,-1),G3tensor(:,73))
  call loop_VQ_A(G2(:,:,:,108),wf(:,12),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,29),ZERO,G3(:,:,:,94))
  call loop_QV_A(G3(:,:,:,94),wf(:,-5),G3(:,:,:,95))
  call loop_Q_A(G3(:,:,:,95),Q(:,61),ZERO,G4(:,:,:,68))
  call check_last_QA_V(l_switch,G4(:,:,:,68),wf(:,-1),G4tensor(:,32))
  call loop_VA_Q(G2(:,:,:,108),wf(:,171),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,62),ZERO,G3(:,:,:,96))
  call check_last_AQ_V(l_switch,G3(:,:,:,96),wf(:,0),G3tensor(:,74))
  call loop_VA_Q(G2(:,:,:,108),wf(:,15),G2(:,:,:,118))
  call loop_A_Q(G2(:,:,:,118),Q(:,30),ZERO,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-5),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,62),ZERO,G4(:,:,:,69))
  call check_last_AQ_V(l_switch,G4(:,:,:,69),wf(:,0),G4tensor(:,33))
  call loop_VQ_A(G2(:,:,:,108),wf(:,166),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,61),ZERO,G3(:,:,:,99))
  call check_last_QA_V(l_switch,G3(:,:,:,99),wf(:,-1),G3tensor(:,75))
  call loop_VQ_A(G2(:,:,:,108),wf(:,18),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,45),ZERO,G3(:,:,:,100))
  call loop_QV_A(G3(:,:,:,100),wf(:,-4),G3(:,:,:,101))
  call loop_Q_A(G3(:,:,:,101),Q(:,61),ZERO,G4(:,:,:,70))
  call check_last_QA_V(l_switch,G4(:,:,:,70),wf(:,-1),G4tensor(:,34))
  call loop_VA_Q(G2(:,:,:,108),wf(:,173),G2(:,:,:,121))
  call loop_A_Q(G2(:,:,:,121),Q(:,62),ZERO,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,0),G3tensor(:,76))
  call loop_VA_Q(G2(:,:,:,108),wf(:,21),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,46),ZERO,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-4),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,62),ZERO,G4(:,:,:,71))
  call check_last_AQ_V(l_switch,G4(:,:,:,71),wf(:,0),G4tensor(:,35))
  call loop_VQ_A(G2(:,:,:,108),wf(:,168),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,61),ZERO,G3(:,:,:,105))
  call check_last_QA_V(l_switch,G3(:,:,:,105),wf(:,-1),G3tensor(:,77))
  call loop_VA_Q(G2(:,:,:,108),wf(:,175),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,62),ZERO,G3(:,:,:,106))
  call check_last_AQ_V(l_switch,G3(:,:,:,106),wf(:,0),G3tensor(:,78))
  call loop_VA_Q(G2(:,:,:,108),wf(:,-1),G2(:,:,:,125))
  call loop_A_Q(G2(:,:,:,125),Q(:,14),ZERO,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,5),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,62),ZERO,G4(:,:,:,72))
  call check_last_AQ_V(l_switch,G4(:,:,:,72),wf(:,0),G4tensor(:,36))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-5),G3(:,:,:,109))
  call loop_A_Q(G3(:,:,:,109),Q(:,46),ZERO,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,-4),G4(:,:,:,74))
  call loop_A_Q(G4(:,:,:,74),Q(:,62),ZERO,G5(:,:,:,23))
  call check_last_AQ_V(l_switch,G5(:,:,:,23),wf(:,0),G5tensor(:,29))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-4),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,30),ZERO,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,-5),G4(:,:,:,76))
  call loop_A_Q(G4(:,:,:,76),Q(:,62),ZERO,G5(:,:,:,24))
  call check_last_AQ_V(l_switch,G5(:,:,:,24),wf(:,0),G5tensor(:,30))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,8),Q(:,19),G1(:,:,:,62))
  call loop_UV_W(G1(:,:,:,62),Q(:,19),wf(:,-5),Q(:,32),G2(:,:,:,126))
  call check_last_GHH_G(l_switch,G2(:,:,:,126),Q(:,51),wf(:,-3),wf(:,-2),G4tensor(:,37), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,126),Q(:,51),wf(:,3),G4tensor(:,38), Q(:,63))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,16),ZERO,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-5),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,48),ZERO,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,6),G2(:,:,:,128))
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,63),ZERO,G3tensor(:,79))
  call loop_AV_Q(G2(:,:,:,127),wf(:,23),G2(:,:,:,129))
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,63),ZERO,G3tensor(:,80))
  call loop_AV_Q(G1(:,:,:,63),wf(:,7),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,60),ZERO,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,1),G2(:,:,:,131))
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,63),ZERO,G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,63),wf(:,24),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,60),ZERO,G2(:,:,:,132))
  call loop_AV_Q(G2(:,:,:,132),wf(:,1),G2(:,:,:,133))
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,63),ZERO,G3tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,16),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,48),ZERO,G2(:,:,:,134))
  call loop_QV_A(G2(:,:,:,134),wf(:,6),G2(:,:,:,135))
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,63),ZERO,G3tensor(:,83))
  call loop_QV_A(G2(:,:,:,134),wf(:,23),G2(:,:,:,136))
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,63),ZERO,G3tensor(:,84))
  call loop_QV_A(G1(:,:,:,67),wf(:,7),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,60),ZERO,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,1),G2(:,:,:,138))
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,63),ZERO,G3tensor(:,85))
  call loop_QV_A(G1(:,:,:,67),wf(:,24),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,60),ZERO,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,1),G2(:,:,:,140))
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,63),ZERO,G3tensor(:,86))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-4),G1(:,:,:,71))
  call loop_DV_C(G1(:,:,:,71),Q(:,16),wf(:,-5),G2(:,:,:,141))
  call check_last_DV_C(l_switch,G2(:,:,:,141),Q(:,48),wf(:,6),G3tensor(:,87))
  call check_last_DV_C(l_switch,G2(:,:,:,141),Q(:,48),wf(:,23),G3tensor(:,88))
  call loop_DV_C(G1(:,:,:,71),Q(:,16),wf(:,7),G2(:,:,:,142))
  call check_last_DV_C(l_switch,G2(:,:,:,142),Q(:,60),wf(:,1),G3tensor(:,89))
  call loop_DV_C(G1(:,:,:,71),Q(:,16),wf(:,24),G2(:,:,:,143))
  call check_last_DV_C(l_switch,G2(:,:,:,143),Q(:,60),wf(:,1),G3tensor(:,90))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,72))
  call loop_CV_D(G1(:,:,:,72),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,144))
  call check_last_CV_D(l_switch,G2(:,:,:,144),Q(:,48),wf(:,6),Q(:,15),G3tensor(:,91))
  call check_last_CV_D(l_switch,G2(:,:,:,144),Q(:,48),wf(:,23),Q(:,15),G3tensor(:,92))
  call loop_CV_D(G1(:,:,:,72),Q(:,16),wf(:,7),Q(:,44),G2(:,:,:,145))
  call check_last_CV_D(l_switch,G2(:,:,:,145),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,93))
  call loop_CV_D(G1(:,:,:,72),Q(:,16),wf(:,24),Q(:,44),G2(:,:,:,146))
  call check_last_CV_D(l_switch,G2(:,:,:,146),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,94))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,28),ZERO,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-5),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,60),ZERO,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,1),G2(:,:,:,148))
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,63),ZERO,G3tensor(:,95))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,28),ZERO,G1(:,:,:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,-5),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,60),ZERO,G2(:,:,:,149))
  call loop_QV_A(G2(:,:,:,149),wf(:,1),G2(:,:,:,150))
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,63),ZERO,G3tensor(:,96))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,9),G1(:,:,:,77))
  call loop_DV_C(G1(:,:,:,77),Q(:,28),wf(:,-5),G2(:,:,:,151))
  call check_last_DV_C(l_switch,G2(:,:,:,151),Q(:,60),wf(:,1),G3tensor(:,97))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,9),Q(:,28),G1(:,:,:,78))
  call loop_CV_D(G1(:,:,:,78),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,152))
  call check_last_CV_D(l_switch,G2(:,:,:,152),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,98))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,9),Q(:,28),G1(:,:,:,79))
  call loop_UV_W(G1(:,:,:,79),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,153))
  call check_last_UV_W(l_switch,G2(:,:,:,153),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,99))
  call loop_VA_Q(G2(:,:,:,153),wf(:,-1),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,62),ZERO,G3(:,:,:,111))
  call check_last_AQ_V(l_switch,G3(:,:,:,111),wf(:,0),G3tensor(:,100))
  call loop_VQ_A(G1(:,:,:,79),wf(:,18),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,61),ZERO,G2(:,:,:,155))
  call check_last_QA_V(l_switch,G2(:,:,:,155),wf(:,-1),G2tensor(:,36))
  call loop_VA_Q(G1(:,:,:,79),wf(:,21),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,62),ZERO,G2(:,:,:,156))
  call check_last_AQ_V(l_switch,G2(:,:,:,156),wf(:,0),G2tensor(:,37))
  call loop_VA_Q(G1(:,:,:,79),wf(:,-1),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,30),ZERO,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-5),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,62),ZERO,G3(:,:,:,112))
  call check_last_AQ_V(l_switch,G3(:,:,:,112),wf(:,0),G3tensor(:,101))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,3),wf(:,-5),Q(:,32),G1(:,:,:,83), Q(:,44))
  call loop_VQ_A(G1(:,:,:,83),wf(:,12),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,61),ZERO,G2(:,:,:,159))
  call check_last_QA_V(l_switch,G2(:,:,:,159),wf(:,-1),G2tensor(:,38))
  call loop_VA_Q(G1(:,:,:,83),wf(:,15),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,62),ZERO,G2(:,:,:,160))
  call check_last_AQ_V(l_switch,G2(:,:,:,160),wf(:,0),G2tensor(:,39))
  call loop_UV_W(G1(:,:,:,83),Q(:,44),wf(:,-4),Q(:,16),G2(:,:,:,161))
  call loop_VA_Q(G2(:,:,:,161),wf(:,-1),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,62),ZERO,G3(:,:,:,113))
  call check_last_AQ_V(l_switch,G3(:,:,:,113),wf(:,0),G3tensor(:,102))
  call loop_VA_Q(G1(:,:,:,83),wf(:,-1),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,46),ZERO,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-4),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,62),ZERO,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,0),G3tensor(:,103))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,83),wf(:,-4),wf(:,1),G1tensor(:,58))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,83),wf(:,1),wf(:,-4),G1tensor(:,59))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,83),wf(:,-4),wf(:,1),G1tensor(:,60))
  call check_last_UV_W(l_switch,G1(:,:,:,83),Q(:,44),wf(:,8),Q(:,19),G2tensor(:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,83),Q(:,44),wf(:,13),Q(:,19),G2tensor(:,41))
  call check_last_UV_W(l_switch,G1(:,:,:,83),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,42))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,3),wf(:,5),Q(:,48),G1(:,:,:,87), Q(:,60))
  call loop_VA_Q(G1(:,:,:,87),wf(:,-1),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,62),ZERO,G2(:,:,:,165))
  call check_last_AQ_V(l_switch,G2(:,:,:,165),wf(:,0),G2tensor(:,43))
  call check_last_UV_W(l_switch,G1(:,:,:,87),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,44))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,25),G0(:,:,:,37))
  call loop_VA_Q(G0(:,:,:,37),wf(:,-1),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,62),ZERO,G1(:,:,:,89))
  call check_last_AQ_V(l_switch,G1(:,:,:,89),wf(:,0),G1tensor(:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,37),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,62))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,25),wf(:,-5),G0(:,:,:,39))
  call loop_VA_Q(G0(:,:,:,39),wf(:,-1),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,62),ZERO,G1(:,:,:,90))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,0),G1tensor(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,64))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,25),G0(:,:,:,41))
  call loop_VA_Q(G0(:,:,:,41),wf(:,-1),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,62),ZERO,G1(:,:,:,91))
  call check_last_AQ_V(l_switch,G1(:,:,:,91),wf(:,0),G1tensor(:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,66))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,24),G0(:,:,:,43))
  call loop_VA_Q(G0(:,:,:,43),wf(:,-1),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,62),ZERO,G1(:,:,:,92))
  call check_last_AQ_V(l_switch,G1(:,:,:,92),wf(:,0),G1tensor(:,67))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,68))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,24),wf(:,-4),G0(:,:,:,45))
  call loop_VA_Q(G0(:,:,:,45),wf(:,-1),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,62),ZERO,G1(:,:,:,93))
  call check_last_AQ_V(l_switch,G1(:,:,:,93),wf(:,0),G1tensor(:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,70))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,24),G0(:,:,:,47))
  call loop_VA_Q(G0(:,:,:,47),wf(:,-1),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,62),ZERO,G1(:,:,:,94))
  call check_last_AQ_V(l_switch,G1(:,:,:,94),wf(:,0),G1tensor(:,71))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,72))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,92),Q(:,60),G1(:,:,:,95))
  call loop_VA_Q(G1(:,:,:,95),wf(:,-1),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,62),ZERO,G2(:,:,:,166))
  call check_last_AQ_V(l_switch,G2(:,:,:,166),wf(:,0),G2tensor(:,45))
  call check_last_UV_W(l_switch,G1(:,:,:,95),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,46))
  call loop_VQ_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,17),ZERO,G1(:,:,:,97))
  call loop_QA_V(G1(:,:,:,97),wf(:,21),G1(:,:,:,98))
  call check_last_GHH_G(l_switch,G1(:,:,:,98),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,104), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,98),Q(:,51),wf(:,3),G3tensor(:,105), Q(:,63))
  call loop_QV_A(G1(:,:,:,97),wf(:,7),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,61),ZERO,G2(:,:,:,167))
  call check_last_QA_V(l_switch,G2(:,:,:,167),wf(:,-1),G2tensor(:,47))
  call loop_QV_A(G1(:,:,:,97),wf(:,24),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,61),ZERO,G2(:,:,:,168))
  call check_last_QA_V(l_switch,G2(:,:,:,168),wf(:,-1),G2tensor(:,48))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,13),Q(:,19),G1(:,:,:,101))
  call loop_UV_W(G1(:,:,:,101),Q(:,19),wf(:,-5),Q(:,32),G2(:,:,:,169))
  call check_last_GHH_G(l_switch,G2(:,:,:,169),Q(:,51),wf(:,-3),wf(:,-2),G4tensor(:,39), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,169),Q(:,51),wf(:,3),G4tensor(:,40), Q(:,63))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,44),G1(:,:,:,102))
  call loop_VQ_A(G1(:,:,:,102),wf(:,12),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,61),ZERO,G2(:,:,:,170))
  call check_last_QA_V(l_switch,G2(:,:,:,170),wf(:,-1),G2tensor(:,49))
  call loop_VA_Q(G1(:,:,:,102),wf(:,15),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,62),ZERO,G2(:,:,:,171))
  call check_last_AQ_V(l_switch,G2(:,:,:,171),wf(:,0),G2tensor(:,50))
  call loop_UV_W(G1(:,:,:,102),Q(:,44),wf(:,-4),Q(:,16),G2(:,:,:,172))
  call loop_VA_Q(G2(:,:,:,172),wf(:,-1),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,62),ZERO,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,0),G3tensor(:,106))
  call loop_VA_Q(G1(:,:,:,102),wf(:,-1),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,46),ZERO,G2(:,:,:,174))
  call loop_AV_Q(G2(:,:,:,174),wf(:,-4),G2(:,:,:,175))
  call loop_A_Q(G2(:,:,:,175),Q(:,62),ZERO,G3(:,:,:,116))
  call check_last_AQ_V(l_switch,G3(:,:,:,116),wf(:,0),G3tensor(:,107))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,102),wf(:,-4),wf(:,1),G1tensor(:,73))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,102),wf(:,1),wf(:,-4),G1tensor(:,74))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,102),wf(:,-4),wf(:,1),G1tensor(:,75))
  call check_last_UV_W(l_switch,G1(:,:,:,102),Q(:,44),wf(:,8),Q(:,19),G2tensor(:,51))
  call check_last_UV_W(l_switch,G1(:,:,:,102),Q(:,44),wf(:,13),Q(:,19),G2tensor(:,52))
  call check_last_UV_W(l_switch,G1(:,:,:,102),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,53))
  call loop_VA_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,18),ZERO,G1(:,:,:,106))
  call loop_AQ_V(G1(:,:,:,106),wf(:,18),G1(:,:,:,107))
  call check_last_GHH_G(l_switch,G1(:,:,:,107),Q(:,51),wf(:,-3),wf(:,-2),G3tensor(:,108), Q(:,63))
  call check_last_GH_G(l_switch,G1(:,:,:,107),Q(:,51),wf(:,3),G3tensor(:,109), Q(:,63))
  call loop_AV_Q(G1(:,:,:,106),wf(:,7),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,62),ZERO,G2(:,:,:,176))
  call check_last_AQ_V(l_switch,G2(:,:,:,176),wf(:,0),G2tensor(:,54))
  call loop_AV_Q(G1(:,:,:,106),wf(:,24),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,62),ZERO,G2(:,:,:,177))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,0),G2tensor(:,55))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,19),G1(:,:,:,110))
  call loop_UV_W(G1(:,:,:,110),Q(:,19),wf(:,-5),Q(:,32),G2(:,:,:,178))
  call check_last_GHH_G(l_switch,G2(:,:,:,178),Q(:,51),wf(:,-3),wf(:,-2),G4tensor(:,41), Q(:,63))
  call check_last_GH_G(l_switch,G2(:,:,:,178),Q(:,51),wf(:,3),G4tensor(:,42), Q(:,63))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,48),G1(:,:,:,111))
  call loop_GHH_G(G1(:,:,:,111),Q(:,48),wf(:,-3),wf(:,-2),G3(:,:,:,117), Q(:,60))
  call loop_VA_Q(G3(:,:,:,117),wf(:,-1),G3(:,:,:,118))
  call loop_A_Q(G3(:,:,:,118),Q(:,62),ZERO,G4(:,:,:,77))
  call check_last_AQ_V(l_switch,G4(:,:,:,77),wf(:,0),G4tensor(:,43))
  call loop_GH_G(G1(:,:,:,111),Q(:,48),wf(:,3),G3(:,:,:,119), Q(:,60))
  call loop_VA_Q(G3(:,:,:,119),wf(:,-1),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,62),ZERO,G4(:,:,:,78))
  call check_last_AQ_V(l_switch,G4(:,:,:,78),wf(:,0),G4tensor(:,44))
  call check_last_GHHG_G(l_switch,G1(:,:,:,111),Q(:,48),wf(:,-3),wf(:,-2),wf(:,1),Q(:,3),G2tensor(:,56), Q(:,63))
  call check_last_GHG_G(l_switch,G1(:,:,:,111),Q(:,48),wf(:,3),wf(:,1),Q(:,3),G2tensor(:,57), Q(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,111),Q(:,48),wf(:,6),Q(:,15),G2tensor(:,58))
  call check_last_UV_W(l_switch,G1(:,:,:,111),Q(:,48),wf(:,23),Q(:,15),G2tensor(:,59))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,106),Q(:,60),G1(:,:,:,112))
  call loop_VA_Q(G1(:,:,:,112),wf(:,-1),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,62),ZERO,G2(:,:,:,179))
  call check_last_AQ_V(l_switch,G2(:,:,:,179),wf(:,0),G2tensor(:,60))
  call check_last_UV_W(l_switch,G1(:,:,:,112),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,61))
  call loop_VQ_A(G0(:,:,:,1),wf(:,143),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,45),ZERO,G1(:,:,:,114))
  call loop_QV_A(G1(:,:,:,114),wf(:,-4),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,61),ZERO,G2(:,:,:,180))
  call check_last_QA_V(l_switch,G2(:,:,:,180),wf(:,-1),G2tensor(:,62))
  call check_last_QA_V(l_switch,G1(:,:,:,114),wf(:,15),G1tensor(:,76))
  call loop_VA_Q(G0(:,:,:,1),wf(:,140),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,46),ZERO,G1(:,:,:,116))
  call loop_AV_Q(G1(:,:,:,116),wf(:,-4),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,62),ZERO,G2(:,:,:,181))
  call check_last_AQ_V(l_switch,G2(:,:,:,181),wf(:,0),G2tensor(:,63))
  call check_last_AQ_V(l_switch,G1(:,:,:,116),wf(:,12),G1tensor(:,77))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,108),Q(:,60),G1(:,:,:,118))
  call loop_VA_Q(G1(:,:,:,118),wf(:,-1),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),ZERO,G2(:,:,:,182))
  call check_last_AQ_V(l_switch,G2(:,:,:,182),wf(:,0),G2tensor(:,64))
  call check_last_UV_W(l_switch,G1(:,:,:,118),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,65))
  call loop_VQ_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,33),ZERO,G1(:,:,:,120))
  call loop_QV_A(G1(:,:,:,120),wf(:,9),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,61),ZERO,G2(:,:,:,183))
  call check_last_QA_V(l_switch,G2(:,:,:,183),wf(:,-1),G2tensor(:,66))
  call loop_QV_A(G1(:,:,:,120),wf(:,25),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,61),ZERO,G2(:,:,:,184))
  call check_last_QA_V(l_switch,G2(:,:,:,184),wf(:,-1),G2tensor(:,67))
  call check_last_QA_V(l_switch,G1(:,:,:,120),wf(:,146),G1tensor(:,78))
  call check_last_QA_V(l_switch,G1(:,:,:,120),wf(:,199),G1tensor(:,79))
  call loop_VA_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,34),ZERO,G1(:,:,:,123))
  call loop_AV_Q(G1(:,:,:,123),wf(:,9),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),ZERO,G2(:,:,:,185))
  call check_last_AQ_V(l_switch,G2(:,:,:,185),wf(:,0),G2tensor(:,68))
  call loop_AV_Q(G1(:,:,:,123),wf(:,25),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,62),ZERO,G2(:,:,:,186))
  call check_last_AQ_V(l_switch,G2(:,:,:,186),wf(:,0),G2tensor(:,69))
  call check_last_AQ_V(l_switch,G1(:,:,:,123),wf(:,149),G1tensor(:,80))
  call check_last_AQ_V(l_switch,G1(:,:,:,123),wf(:,195),G1tensor(:,81))
  call loop_VQ_A(G0(:,:,:,1),wf(:,149),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,29),ZERO,G1(:,:,:,126))
  call loop_QV_A(G1(:,:,:,126),wf(:,-5),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,61),ZERO,G2(:,:,:,187))
  call check_last_QA_V(l_switch,G2(:,:,:,187),wf(:,-1),G2tensor(:,70))
  call loop_VA_Q(G0(:,:,:,1),wf(:,146),G0(:,:,:,56))
  call loop_A_Q(G0(:,:,:,56),Q(:,30),ZERO,G1(:,:,:,128))
  call loop_AV_Q(G1(:,:,:,128),wf(:,-5),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,62),ZERO,G2(:,:,:,188))
  call check_last_AQ_V(l_switch,G2(:,:,:,188),wf(:,0),G2tensor(:,71))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,110),Q(:,60),G1(:,:,:,130))
  call loop_VA_Q(G1(:,:,:,130),wf(:,-1),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,62),ZERO,G2(:,:,:,189))
  call check_last_AQ_V(l_switch,G2(:,:,:,189),wf(:,0),G2tensor(:,72))
  call check_last_UV_W(l_switch,G1(:,:,:,130),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,73))
  call loop_AV_Q(G0(:,:,:,1),wf(:,25),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,28),ZERO,G1(:,:,:,132))
  call loop_AV_Q(G1(:,:,:,132),wf(:,-5),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,60),ZERO,G2(:,:,:,190))
  call loop_AV_Q(G2(:,:,:,190),wf(:,1),G2(:,:,:,191))
  call check_last_A_Q(l_switch,G2(:,:,:,191),Q(:,63),ZERO,G3tensor(:,110))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,28),ZERO,G1(:,:,:,134))
  call loop_QV_A(G1(:,:,:,134),wf(:,-5),G1(:,:,:,135))
  call loop_Q_A(G1(:,:,:,135),Q(:,60),ZERO,G2(:,:,:,192))
  call loop_QV_A(G2(:,:,:,192),wf(:,1),G2(:,:,:,193))
  call check_last_Q_A(l_switch,G2(:,:,:,193),Q(:,63),ZERO,G3tensor(:,111))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,25),G1(:,:,:,136))
  call loop_DV_C(G1(:,:,:,136),Q(:,28),wf(:,-5),G2(:,:,:,194))
  call check_last_DV_C(l_switch,G2(:,:,:,194),Q(:,60),wf(:,1),G3tensor(:,112))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,28),G1(:,:,:,137))
  call loop_CV_D(G1(:,:,:,137),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,195))
  call check_last_CV_D(l_switch,G2(:,:,:,195),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,113))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,28),G1(:,:,:,138))
  call loop_UV_W(G1(:,:,:,138),Q(:,28),wf(:,-5),Q(:,32),G2(:,:,:,196))
  call check_last_UV_W(l_switch,G2(:,:,:,196),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,114))
  call loop_VA_Q(G2(:,:,:,196),wf(:,-1),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,62),ZERO,G3(:,:,:,121))
  call check_last_AQ_V(l_switch,G3(:,:,:,121),wf(:,0),G3tensor(:,115))
  call loop_VQ_A(G1(:,:,:,138),wf(:,18),G1(:,:,:,139))
  call loop_Q_A(G1(:,:,:,139),Q(:,61),ZERO,G2(:,:,:,198))
  call check_last_QA_V(l_switch,G2(:,:,:,198),wf(:,-1),G2tensor(:,74))
  call loop_VA_Q(G1(:,:,:,138),wf(:,21),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,62),ZERO,G2(:,:,:,199))
  call check_last_AQ_V(l_switch,G2(:,:,:,199),wf(:,0),G2tensor(:,75))
  call loop_VA_Q(G1(:,:,:,138),wf(:,-1),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,30),ZERO,G2(:,:,:,200))
  call loop_AV_Q(G2(:,:,:,200),wf(:,-5),G2(:,:,:,201))
  call loop_A_Q(G2(:,:,:,201),Q(:,62),ZERO,G3(:,:,:,122))
  call check_last_AQ_V(l_switch,G3(:,:,:,122),wf(:,0),G3tensor(:,116))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,24),Q(:,44),G1(:,:,:,142))
  call loop_VQ_A(G1(:,:,:,142),wf(:,12),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,61),ZERO,G2(:,:,:,202))
  call check_last_QA_V(l_switch,G2(:,:,:,202),wf(:,-1),G2tensor(:,76))
  call loop_VA_Q(G1(:,:,:,142),wf(:,15),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,62),ZERO,G2(:,:,:,203))
  call check_last_AQ_V(l_switch,G2(:,:,:,203),wf(:,0),G2tensor(:,77))
  call loop_UV_W(G1(:,:,:,142),Q(:,44),wf(:,-4),Q(:,16),G2(:,:,:,204))
  call loop_VA_Q(G2(:,:,:,204),wf(:,-1),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,62),ZERO,G3(:,:,:,123))
  call check_last_AQ_V(l_switch,G3(:,:,:,123),wf(:,0),G3tensor(:,117))
  call loop_VA_Q(G1(:,:,:,142),wf(:,-1),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,46),ZERO,G2(:,:,:,206))
  call loop_AV_Q(G2(:,:,:,206),wf(:,-4),G2(:,:,:,207))
  call loop_A_Q(G2(:,:,:,207),Q(:,62),ZERO,G3(:,:,:,124))
  call check_last_AQ_V(l_switch,G3(:,:,:,124),wf(:,0),G3tensor(:,118))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,142),wf(:,-4),wf(:,1),G1tensor(:,82))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,142),wf(:,1),wf(:,-4),G1tensor(:,83))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,142),wf(:,-4),wf(:,1),G1tensor(:,84))
  call check_last_UV_W(l_switch,G1(:,:,:,142),Q(:,44),wf(:,8),Q(:,19),G2tensor(:,78))
  call check_last_UV_W(l_switch,G1(:,:,:,142),Q(:,44),wf(:,13),Q(:,19),G2tensor(:,79))
  call check_last_UV_W(l_switch,G1(:,:,:,142),Q(:,44),wf(:,16),Q(:,19),G2tensor(:,80))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,177),Q(:,60),G1(:,:,:,146))
  call loop_VA_Q(G1(:,:,:,146),wf(:,-1),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,62),ZERO,G2(:,:,:,208))
  call check_last_AQ_V(l_switch,G2(:,:,:,208),wf(:,0),G2tensor(:,81))
  call check_last_UV_W(l_switch,G1(:,:,:,146),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,82))
  call loop_VQ_A(G0(:,:,:,1),wf(:,195),G0(:,:,:,59))
  call loop_Q_A(G0(:,:,:,59),Q(:,29),ZERO,G1(:,:,:,148))
  call loop_QV_A(G1(:,:,:,148),wf(:,-5),G1(:,:,:,149))
  call loop_Q_A(G1(:,:,:,149),Q(:,61),ZERO,G2(:,:,:,209))
  call check_last_QA_V(l_switch,G2(:,:,:,209),wf(:,-1),G2tensor(:,83))
  call loop_VQ_A(G0(:,:,:,1),wf(:,197),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,45),ZERO,G1(:,:,:,150))
  call loop_QV_A(G1(:,:,:,150),wf(:,-4),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,61),ZERO,G2(:,:,:,210))
  call check_last_QA_V(l_switch,G2(:,:,:,210),wf(:,-1),G2tensor(:,84))
  call check_last_QA_V(l_switch,G1(:,:,:,150),wf(:,15),G1tensor(:,85))
  call loop_VA_Q(G0(:,:,:,1),wf(:,199),G0(:,:,:,61))
  call loop_A_Q(G0(:,:,:,61),Q(:,30),ZERO,G1(:,:,:,152))
  call loop_AV_Q(G1(:,:,:,152),wf(:,-5),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,62),ZERO,G2(:,:,:,211))
  call check_last_AQ_V(l_switch,G2(:,:,:,211),wf(:,0),G2tensor(:,85))
  call loop_VA_Q(G0(:,:,:,1),wf(:,201),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,46),ZERO,G1(:,:,:,154))
  call loop_AV_Q(G1(:,:,:,154),wf(:,-4),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,62),ZERO,G2(:,:,:,212))
  call check_last_AQ_V(l_switch,G2(:,:,:,212),wf(:,0),G2tensor(:,86))
  call check_last_AQ_V(l_switch,G1(:,:,:,154),wf(:,12),G1tensor(:,86))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,202),Q(:,60),G1(:,:,:,156))
  call loop_VA_Q(G1(:,:,:,156),wf(:,-1),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,62),ZERO,G2(:,:,:,213))
  call check_last_AQ_V(l_switch,G2(:,:,:,213),wf(:,0),G2tensor(:,87))
  call check_last_UV_W(l_switch,G1(:,:,:,156),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,88))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,203),Q(:,60),G1(:,:,:,158))
  call loop_VA_Q(G1(:,:,:,158),wf(:,-1),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,62),ZERO,G2(:,:,:,214))
  call check_last_AQ_V(l_switch,G2(:,:,:,214),wf(:,0),G2tensor(:,89))
  call check_last_UV_W(l_switch,G1(:,:,:,158),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,90))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,63))
  call check_last_GHHG_G(l_switch,G0(:,:,:,63),Q(:,35),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G1tensor(:,87), Q(:,63))
  call check_last_GHG_G(l_switch,G0(:,:,:,63),Q(:,35),wf(:,3),wf(:,-4),Q(:,16),G1tensor(:,88), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,35),wf(:,9),Q(:,28),G1tensor(:,89))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,35),wf(:,25),Q(:,28),G1tensor(:,90))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-5),G0(:,:,:,64))
  call check_last_GHHG_G(l_switch,G0(:,:,:,64),Q(:,35),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G1tensor(:,91), Q(:,63))
  call check_last_GHG_G(l_switch,G0(:,:,:,64),Q(:,35),wf(:,3),wf(:,-4),Q(:,16),G1tensor(:,92), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,35),wf(:,9),Q(:,28),G1tensor(:,93))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,35),wf(:,25),Q(:,28),G1tensor(:,94))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,65))
  call check_last_GHHG_G(l_switch,G0(:,:,:,65),Q(:,35),wf(:,-3),wf(:,-2),wf(:,-4),Q(:,16),G1tensor(:,95), Q(:,63))
  call check_last_GHG_G(l_switch,G0(:,:,:,65),Q(:,35),wf(:,3),wf(:,-4),Q(:,16),G1tensor(:,96), Q(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,35),wf(:,9),Q(:,28),G1tensor(:,97))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,35),wf(:,25),Q(:,28),G1tensor(:,98))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-2),wf(:,-5),wf(:,1),G0(:,:,:,66))
  call check_last_UV_W(l_switch,G0(:,:,:,66),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,99))
  call loop_GHHGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-2),wf(:,1),wf(:,-5),G0(:,:,:,67))
  call check_last_UV_W(l_switch,G0(:,:,:,67),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,100))
  call loop_GHHGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,-2),wf(:,-5),wf(:,1),G0(:,:,:,68))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,101))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,-5),wf(:,1),G0(:,:,:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,102))
  call loop_GHGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,1),wf(:,-5),G0(:,:,:,70))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,103))
  call loop_GHGG_G_23(G0(:,:,:,1),wf(:,3),wf(:,-5),wf(:,1),G0(:,:,:,71))
  call check_last_UV_W(l_switch,G0(:,:,:,71),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,104))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,5),G0(:,:,:,72))
  call check_last_GHH_G(l_switch,G0(:,:,:,72),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,91), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,72),Q(:,51),wf(:,3),G2tensor(:,92), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,5),wf(:,1),G0(:,:,:,73))
  call check_last_GHH_G(l_switch,G0(:,:,:,73),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,93), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,73),Q(:,51),wf(:,3),G2tensor(:,94), Q(:,63))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,5),G0(:,:,:,74))
  call check_last_GHH_G(l_switch,G0(:,:,:,74),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,95), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,74),Q(:,51),wf(:,3),G2tensor(:,96), Q(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,7),G0(:,:,:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,75),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,105))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,1),G0(:,:,:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,106))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,7),G0(:,:,:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,107))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,8),G0(:,:,:,78))
  call check_last_GHH_G(l_switch,G0(:,:,:,78),Q(:,51),wf(:,-3),wf(:,-2),G2tensor(:,97), Q(:,63))
  call check_last_GH_G(l_switch,G0(:,:,:,78),Q(:,51),wf(:,3),G2tensor(:,98), Q(:,63))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(12)*(-M(1)+M(2)))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(1)
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(1)
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(1)
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(1)
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(1)
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(1)
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,39)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(2)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(12)*M(1)+c(10)*M(3)) * den(8)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(12)*M(2)+c(10)*M(3)) * den(8)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(8)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(12)*M(2)+c(10)*M(3)) * den(6)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(12)*M(1)+c(10)*M(3)) * den(6)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(12)*(M(1)-M(2))) * den(6)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T4sum(1:35,4) = T4sum(1:35,4) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T4sum(1:35,4) = T4sum(1:35,4) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(12)*(-M(1)+M(2)))
  T4sum(1:35,4) = T4sum(1:35,4) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T4sum(1:35,5) = T4sum(1:35,5) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T4sum(1:35,5) = T4sum(1:35,5) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(12)*(-M(1)+M(2)))
  T4sum(1:35,5) = T4sum(1:35,5) + Gcoeff * G3tensor(:,46)
  Gcoeff = (-(c(6)*M(2))) * den(10)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(6)*M(1)) * den(12)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(4)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,48)
  Gcoeff = (-(c(4)*M(3)))
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,49)
  Gcoeff = (-(c(6)*M(1))) * den(14)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(6)*M(2)) * den(16)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(4)*M(3)))
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(33)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(33)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(19)*(-M(1)+M(2))) * den(3)
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(3)
  T4sum(1:35,1) = T4sum(1:35,1) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(19)*(-M(1)+M(2))) * den(3)
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(20)*(M(1)-M(2))) * den(3)
  T4sum(1:35,2) = T4sum(1:35,2) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(19)*(-M(1)+M(2))) * den(3)
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(20)*(M(1)-M(2))) * den(3)
  T4sum(1:35,3) = T4sum(1:35,3) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(5)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(20)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,37)
  Gcoeff = (c(7)*(M(1)-M(2))) * den(54)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(1)
  T5sum(1:126,1) = T5sum(1:126,1) + Gcoeff * G5tensor(:,9)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T5sum(1:126,2) = T5sum(1:126,2) + Gcoeff * G5tensor(:,12)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(1)
  T5sum(1:126,3) = T5sum(1:126,3) + Gcoeff * G5tensor(:,3)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(3)) * den(80)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,79)
  Gcoeff = (-(c(30)*M(2))+c(29)*M(3)) * den(80)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,83)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(3)) * den(80)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,79)
  Gcoeff = (-(c(32)*M(2))+c(31)*M(3)) * den(80)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(80)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(80)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(80)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(30)*M(2))+c(29)*M(3)) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,85)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(3)) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,81)
  Gcoeff = (-(c(32)*M(2))+c(31)*M(3)) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,85)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(3)) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,81)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(3)) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,95)
  Gcoeff = (-(c(30)*M(2))+c(29)*M(3)) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,96)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(3)) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,95)
  Gcoeff = (-(c(32)*M(2))+c(31)*M(3)) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(19)*M(2)) * den(47)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(19)*M(1))) * den(49)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(51)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(22)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,61)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(22)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(22)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,65)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(17)*M(3)) * den(2)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,103)
  Gcoeff = (c(19)*M(1)) * den(48)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(19)*M(2))) * den(50)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(56)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,67)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(56)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(25)*(-M(1)+M(2))) * den(56)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,71)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,51)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(17)*M(3)) * den(2)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,66)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T4sum(1:35,4) = T4sum(1:35,4) + Gcoeff * G3tensor(:,68)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T4sum(1:35,4) = T4sum(1:35,4) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(2)
  T4sum(1:35,4) = T4sum(1:35,4) + Gcoeff * G3tensor(:,72)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T4sum(1:35,5) = T4sum(1:35,5) + Gcoeff * G3tensor(:,43)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T4sum(1:35,5) = T4sum(1:35,5) + Gcoeff * G3tensor(:,45)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(2)
  T4sum(1:35,5) = T4sum(1:35,5) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(16)*(-M(1)+M(2))) * den(52)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(52)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(11)*M(2)) * den(105)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(13)*M(2)) * den(24)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,39)
  Gcoeff = (c(11)*M(2)) * den(146)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(6)*M(2))) * den(10)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,22)
  Gcoeff = (-(c(9)*M(2))) * den(10)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,17)
  Gcoeff = (-(c(6)*M(2))) * den(10)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,13)
  Gcoeff = (-(c(9)*M(2))) * den(11)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(6)*M(2))) * den(11)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(11)*M(1)) * den(107)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,108)
  Gcoeff = (c(13)*M(1)) * den(26)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,41)
  Gcoeff = (c(11)*M(1)) * den(156)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(6)*M(1)) * den(12)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,23)
  Gcoeff = (-(c(9)*M(1))) * den(12)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(6)*M(1)) * den(12)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,14)
  Gcoeff = (-(c(9)*M(1))) * den(13)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(6)*M(1)) * den(13)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(13)*M(1)) * den(29)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(11)*M(1)) * den(149)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,35)
  Gcoeff = (-(c(6)*M(1))) * den(14)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(9)*M(1))) * den(14)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,19)
  Gcoeff = (-(c(6)*M(1))) * den(14)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,15)
  Gcoeff = (c(13)*M(2)) * den(31)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(11)*M(2)) * den(159)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(6)*M(2)) * den(16)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(9)*M(2))) * den(16)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(6)*M(2)) * den(16)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(5)*(-M(1)+M(2))) * den(152)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(5)*(-M(1)+M(2))) * den(161)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(4)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,43)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(4)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(4)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,21)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(77)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(77)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T5sum(1:126,4) = T5sum(1:126,4) + Gcoeff * G5tensor(:,4)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T5sum(1:126,5) = T5sum(1:126,5) + Gcoeff * G5tensor(:,1)
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T5sum(1:126,6) = T5sum(1:126,6) + Gcoeff * G5tensor(:,17)
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T5sum(1:126,7) = T5sum(1:126,7) + Gcoeff * G5tensor(:,19)
  Gcoeff = (c(12)*M(1)+c(10)*M(3))
  T5sum(1:126,8) = T5sum(1:126,8) + Gcoeff * G5tensor(:,10)
  Gcoeff = (c(12)*M(2)+c(10)*M(3))
  T5sum(1:126,9) = T5sum(1:126,9) + Gcoeff * G5tensor(:,13)
  Gcoeff = (-(c(4)*M(3)))
  T5sum(1:126,10) = T5sum(1:126,10) + Gcoeff * G5tensor(:,18)
  Gcoeff = (-(c(4)*M(3)))
  T5sum(1:126,11) = T5sum(1:126,11) + Gcoeff * G5tensor(:,5)
  Gcoeff = (-(c(4)*M(3)))
  T5sum(1:126,12) = T5sum(1:126,12) + Gcoeff * G5tensor(:,11)
  Gcoeff = (-(c(9)*M(2))+c(10)*M(3))
  T5sum(1:126,13) = T5sum(1:126,13) + Gcoeff * G5tensor(:,15)
  Gcoeff = (-(c(4)*M(3)))
  T5sum(1:126,14) = T5sum(1:126,14) + Gcoeff * G5tensor(:,14)
  Gcoeff = (-(c(9)*M(1))+c(10)*M(3))
  T5sum(1:126,15) = T5sum(1:126,15) + Gcoeff * G5tensor(:,16)
  Gcoeff = (-(c(9)*M(1))) * den(134)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(6)*M(1))) * den(134)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(9)*M(2))) * den(130)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(6)*M(2)) * den(130)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(82)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(82)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,64)
  Gcoeff = (-(c(9)*M(2))+c(10)*M(3)) * den(6)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(12)*M(2)+c(10)*M(3)) * den(6)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,16)
  Gcoeff = (-(c(9)*M(1))+c(10)*M(3)) * den(6)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(12)*M(1)+c(10)*M(3)) * den(6)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,106)
  Gcoeff = (-(c(4)*M(3))) * den(6)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,107)
  Gcoeff = (-(c(4)*M(3))) * den(6)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(9)*M(1))) * den(15)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(6)*M(1))) * den(15)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(9)*M(2))) * den(17)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(6)*M(2)) * den(17)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(9)*M(2))) * den(142)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(6)*M(2))) * den(142)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(9)*M(1))) * den(138)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(6)*M(1)) * den(138)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(3)*(M(1)-M(2))) * den(85)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(85)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(9)*M(1))+c(10)*M(3)) * den(8)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(12)*M(1)+c(10)*M(3)) * den(8)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,52)
  Gcoeff = (-(c(9)*M(2))+c(10)*M(3)) * den(8)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(12)*M(2)+c(10)*M(3)) * den(8)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,100)
  Gcoeff = (-(c(4)*M(3))) * den(8)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,101)
  Gcoeff = (-(c(4)*M(3))) * den(8)
  T3sum(1:35,19) = T3sum(1:35,19) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(20)*(M(1)-M(2))) * den(190)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,26)
  Gcoeff = (c(20)*(M(1)-M(2))) * den(21)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,38)
  Gcoeff = (c(20)*(-M(1)+M(2))) * den(55)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(36)*M(1)-c(35)*M(3)) * den(23)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,110)
  Gcoeff = (c(36)*M(2)-c(35)*M(3)) * den(23)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(38)*M(1)-c(37)*M(3)) * den(23)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,110)
  Gcoeff = (c(38)*M(2)-c(37)*M(3)) * den(23)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(19)*(-M(1)+M(2))) * den(23)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,112)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(23)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,113)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(23)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(36)*M(2)-c(35)*M(3)) * den(57)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,86)
  Gcoeff = (c(36)*M(1)-c(35)*M(3)) * den(57)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(38)*M(2)-c(37)*M(3)) * den(57)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,86)
  Gcoeff = (c(38)*M(1)-c(37)*M(3)) * den(57)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(57)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(19)*(-M(1)+M(2))) * den(57)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(57)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(36)*M(1)-c(35)*M(3)) * den(165)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(36)*M(2)-c(35)*M(3)) * den(165)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(38)*M(1)-c(37)*M(3)) * den(165)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(38)*M(2)-c(37)*M(3)) * den(165)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(19)*(-M(1)+M(2))) * den(165)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(165)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,92)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(165)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(19)*(-M(1)+M(2))) * den(3)
  T5sum(1:126,1) = T5sum(1:126,1) + Gcoeff * G5tensor(:,23)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T5sum(1:126,2) = T5sum(1:126,2) + Gcoeff * G5tensor(:,26)
  Gcoeff = (c(19)*(M(1)-M(2))) * den(3)
  T5sum(1:126,3) = T5sum(1:126,3) + Gcoeff * G5tensor(:,6)
  Gcoeff = (-(c(24)*M(2))) * den(191)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,105)
  Gcoeff = (-(c(26)*M(2))) * den(25)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,40)
  Gcoeff = (-(c(24)*M(2))) * den(147)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(22)*M(2)) * den(148)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(19)*M(2)) * den(148)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(19)*M(2)) * den(47)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,24)
  Gcoeff = (c(22)*M(2)) * den(47)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,32)
  Gcoeff = (c(19)*M(2)) * den(47)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,28)
  Gcoeff = (-(c(24)*M(1))) * den(192)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,109)
  Gcoeff = (-(c(26)*M(1))) * den(27)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,42)
  Gcoeff = (-(c(24)*M(1))) * den(157)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(22)*M(1)) * den(154)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(19)*M(1))) * den(154)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(19)*M(1))) * den(49)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,25)
  Gcoeff = (c(22)*M(1)) * den(49)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,33)
  Gcoeff = (-(c(19)*M(1))) * den(49)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,29)
  Gcoeff = (-(c(26)*M(1))) * den(30)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(24)*M(1))) * den(150)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(22)*M(1)) * den(151)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(19)*M(1)) * den(151)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(19)*M(1)) * den(48)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(22)*M(1)) * den(48)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,34)
  Gcoeff = (c(19)*M(1)) * den(48)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,30)
  Gcoeff = (-(c(26)*M(2))) * den(32)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,8)
  Gcoeff = (-(c(24)*M(2))) * den(160)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(22)*M(2)) * den(158)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(19)*M(2))) * den(158)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(19)*M(2))) * den(50)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(22)*M(2)) * den(50)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,35)
  Gcoeff = (-(c(19)*M(2))) * den(50)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,31)
  Gcoeff = (c(18)*(M(1)-M(2))) * den(153)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(18)*(M(1)-M(2))) * den(162)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(16)*(-M(1)+M(2))) * den(163)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(163)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(51)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,27)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(51)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,44)
  Gcoeff = (c(16)*(-M(1)+M(2))) * den(51)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,36)
  Gcoeff = (c(22)*M(2)) * den(184)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(19)*M(2)) * den(184)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(22)*M(1)) * den(185)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(19)*M(1)) * den(185)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(22)*M(1)) * den(186)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(19)*M(1))) * den(186)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(22)*M(2)) * den(187)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,86)
  Gcoeff = (-(c(19)*M(2))) * den(187)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(16)*(-M(1)+M(2))) * den(188)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(188)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(22)*M(1)-c(23)*M(3)) * den(22)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,62)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(22)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(22)*M(2)-c(23)*M(3)) * den(22)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,61)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(22)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(17)*M(3)) * den(22)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,116)
  Gcoeff = (c(17)*M(3)) * den(22)
  T3sum(1:35,19) = T3sum(1:35,19) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(16)*(-M(1)+M(2))) * den(189)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(25)*(M(1)-M(2))) * den(189)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(22)*M(2)-c(23)*M(3)) * den(56)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,63)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(56)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(22)*M(1)-c(23)*M(3)) * den(56)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,58)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(56)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,117)
  Gcoeff = (c(17)*M(3)) * den(56)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(17)*M(3)) * den(56)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,18)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T5sum(1:126,4) = T5sum(1:126,4) + Gcoeff * G5tensor(:,7)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T5sum(1:126,5) = T5sum(1:126,5) + Gcoeff * G5tensor(:,2)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T5sum(1:126,6) = T5sum(1:126,6) + Gcoeff * G5tensor(:,21)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T5sum(1:126,7) = T5sum(1:126,7) + Gcoeff * G5tensor(:,20)
  Gcoeff = (-(c(25)*M(1))-c(23)*M(3)) * den(2)
  T5sum(1:126,8) = T5sum(1:126,8) + Gcoeff * G5tensor(:,24)
  Gcoeff = (-(c(25)*M(2))-c(23)*M(3)) * den(2)
  T5sum(1:126,9) = T5sum(1:126,9) + Gcoeff * G5tensor(:,27)
  Gcoeff = (c(17)*M(3)) * den(2)
  T5sum(1:126,10) = T5sum(1:126,10) + Gcoeff * G5tensor(:,22)
  Gcoeff = (c(17)*M(3)) * den(2)
  T5sum(1:126,11) = T5sum(1:126,11) + Gcoeff * G5tensor(:,8)
  Gcoeff = (c(17)*M(3)) * den(2)
  T5sum(1:126,12) = T5sum(1:126,12) + Gcoeff * G5tensor(:,25)
  Gcoeff = (c(22)*M(2)-c(23)*M(3)) * den(2)
  T5sum(1:126,13) = T5sum(1:126,13) + Gcoeff * G5tensor(:,29)
  Gcoeff = (c(17)*M(3)) * den(2)
  T5sum(1:126,14) = T5sum(1:126,14) + Gcoeff * G5tensor(:,28)
  Gcoeff = (c(22)*M(1)-c(23)*M(3)) * den(2)
  T5sum(1:126,15) = T5sum(1:126,15) + Gcoeff * G5tensor(:,30)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(1)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,95)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,100)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(1)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(1)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(1)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(3)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(3)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(3)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(3)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(3)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(3)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(3)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(3)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(3)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(3)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(3)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,93)
  Gcoeff = (0) * den(5)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(7)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,105)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(7)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,106)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(7)
  T2sum(1:5,22) = T2sum(1:5,22) + Gcoeff * G1tensor(:,107)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(20)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(9)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(9)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(9)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(9)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(9)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(9)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(9)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(9)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(9)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(80)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(80)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(80)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(7)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(7)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(7)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(7)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(7)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(7)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(80)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(80)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(80)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(5)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(20)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(20)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(46)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(8)*M(2)) * den(24)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(8)*M(2)) * den(24)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(8)*M(1)) * den(26)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(8)*M(1)) * den(26)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(193)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(194)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(194)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,94)
  Gcoeff = (0) * den(194)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(18)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(21)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(23)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(23)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(23)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(21)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(21)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(23)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(23)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(23)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(23)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,90)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(23)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(23)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(57)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(57)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(15)*(-M(1)+M(2))) * den(57)
  T2sum(1:5,24) = T2sum(1:5,24) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(165)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(165)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(165)
  T2sum(1:5,23) = T2sum(1:5,23) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(57)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(57)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(57)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(14)*(-M(1)+M(2))) * den(165)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(14)*(M(1)-M(2))) * den(165)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(165)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(53)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(78)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(81)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(84)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(83)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(86)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(21)*M(2))) * den(25)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(21)*M(2))) * den(25)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(21)*M(1))) * den(27)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(21)*M(1))) * den(27)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(8)*M(2)) * den(132)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(11)*M(2)) * den(131)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(8)*M(1)) * den(136)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(11)*M(1)) * den(135)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(11)*M(1)) * den(139)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(11)*M(2)) * den(143)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(166)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(164)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(170)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(195)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(15)*(M(1)-M(2))) * den(196)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(21)*M(2))) * den(174)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(24)*M(2))) * den(197)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,86)
  Gcoeff = (-(c(21)*M(1))) * den(177)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(24)*M(1))) * den(198)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,85)
  Gcoeff = (-(c(24)*M(1))) * den(199)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,79)
  Gcoeff = (-(c(24)*M(2))) * den(200)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,81)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_heftpphhjj_ddxhhgg_1_/**/REALKIND
