
module ol_vamp_1_heftpphhjj_dddxdxhh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpphhjj_dddxdxhh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpphhjj_dddxdxhh_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpphhjj_dddxdxhh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpphhjj_dddxdxhh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,12) :: G0
  complex(REALKIND), dimension(4,5,4,75) :: G1
  complex(REALKIND), dimension(4,15,4,44) :: G2
  complex(REALKIND), dimension(4,35,4,90) :: G3
  complex(REALKIND), dimension(4,70,4,40) :: G4
  complex(REALKIND), dimension(15,68) :: G2tensor
  complex(REALKIND), dimension(35,16) :: G3tensor
  complex(REALKIND), dimension(70,44) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),wf(:,1),Q(:,5),G1(:,:,:,1), Q(:,53))
  call loop_VA_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,61),ZERO,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-1),G2tensor(:,1))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,2))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),wf(:,5),Q(:,6),G1(:,:,:,3), Q(:,54))
  call loop_VA_Q(G1(:,:,:,3),wf(:,-3),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,62),ZERO,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,3))
  call check_last_UV_W(l_switch,G1(:,:,:,3),Q(:,54),wf(:,4),Q(:,9),G2tensor(:,4))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),wf(:,4),Q(:,9),G1(:,:,:,5), Q(:,57))
  call loop_VA_Q(G1(:,:,:,5),wf(:,-2),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,61),ZERO,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,-1),G2tensor(:,5))
  call check_last_UV_W(l_switch,G1(:,:,:,5),Q(:,57),wf(:,5),Q(:,6),G2tensor(:,6))
  call loop_GHHG_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),wf(:,2),Q(:,10),G1(:,:,:,7), Q(:,58))
  call loop_VA_Q(G1(:,:,:,7),wf(:,-2),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,62),ZERO,G2(:,:,:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,7))
  call check_last_UV_W(l_switch,G1(:,:,:,7),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,8))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,9))
  call loop_GHH_G(G1(:,:,:,9),Q(:,10),wf(:,-5),wf(:,-4),G3(:,:,:,1), Q(:,58))
  call check_last_UV_W(l_switch,G3(:,:,:,1),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,1))
  call loop_VA_Q(G3(:,:,:,1),wf(:,-2),G3(:,:,:,2))
  call loop_A_Q(G3(:,:,:,2),Q(:,62),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,2))
  call loop_GH_G(G1(:,:,:,9),Q(:,10),wf(:,7),G3(:,:,:,3), Q(:,58))
  call check_last_UV_W(l_switch,G3(:,:,:,3),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,3))
  call loop_VA_Q(G3(:,:,:,3),wf(:,-2),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,62),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,4))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,7),wf(:,1),Q(:,5),G1(:,:,:,10), Q(:,53))
  call loop_VA_Q(G1(:,:,:,10),wf(:,-3),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,61),ZERO,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,-1),G2tensor(:,9))
  call check_last_UV_W(l_switch,G1(:,:,:,10),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,10))
  call loop_GHH_G(G0(:,:,:,1),Q(:,0),wf(:,-5),wf(:,-4),G2(:,:,:,6), Q(:,48))
  call loop_VA_Q(G2(:,:,:,6),wf(:,-3),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,56),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,40),G3tensor(:,1))
  call loop_AV_Q(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,61),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,-1),G4tensor(:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,54),G3tensor(:,2))
  call loop_AV_Q(G3(:,:,:,5),wf(:,5),G3(:,:,:,7))
  call loop_A_Q(G3(:,:,:,7),Q(:,62),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,6))
  call loop_AQ_V(G3(:,:,:,5),wf(:,-1),G3(:,:,:,8))
  call loop_VA_Q(G3(:,:,:,8),wf(:,-2),G3(:,:,:,9))
  call loop_A_Q(G3(:,:,:,9),Q(:,62),ZERO,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,7))
  call loop_VA_Q(G2(:,:,:,6),wf(:,62),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,61),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-1),G3tensor(:,3))
  call loop_UV_W(G2(:,:,:,6),Q(:,48),wf(:,1),Q(:,5),G3(:,:,:,11))
  call loop_VA_Q(G3(:,:,:,11),wf(:,-3),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,61),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,-1),G4tensor(:,8))
  call loop_VA_Q(G2(:,:,:,6),wf(:,69),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,62),ZERO,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,4))
  call loop_UV_W(G2(:,:,:,6),Q(:,48),wf(:,5),Q(:,6),G3(:,:,:,14))
  call loop_VA_Q(G3(:,:,:,14),wf(:,-3),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,62),ZERO,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,0),G4tensor(:,9))
  call loop_VQ_A(G2(:,:,:,6),wf(:,57),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,59),ZERO,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,-2),G3tensor(:,5))
  call loop_VA_Q(G2(:,:,:,6),wf(:,65),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,61),ZERO,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,-1),G3tensor(:,6))
  call loop_UV_W(G2(:,:,:,6),Q(:,48),wf(:,4),Q(:,9),G3(:,:,:,18))
  call loop_VA_Q(G3(:,:,:,18),wf(:,-2),G3(:,:,:,19))
  call loop_A_Q(G3(:,:,:,19),Q(:,61),ZERO,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,-1),G4tensor(:,10))
  call loop_VA_Q(G2(:,:,:,6),wf(:,-2),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,52),ZERO,G3(:,:,:,20))
  call loop_AV_Q(G3(:,:,:,20),wf(:,4),G3(:,:,:,21))
  call loop_A_Q(G3(:,:,:,21),Q(:,61),ZERO,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,-1),G4tensor(:,11))
  call loop_AV_Q(G3(:,:,:,20),wf(:,2),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,62),ZERO,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,0),G4tensor(:,12))
  call loop_AQ_V(G3(:,:,:,20),wf(:,-1),G3(:,:,:,23))
  call loop_VA_Q(G3(:,:,:,23),wf(:,-3),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,62),ZERO,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,13))
  call loop_VQ_A(G2(:,:,:,6),wf(:,59),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,59),ZERO,G3(:,:,:,25))
  call check_last_QA_V(l_switch,G3(:,:,:,25),wf(:,-2),G3tensor(:,7))
  call loop_VA_Q(G2(:,:,:,6),wf(:,72),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,62),ZERO,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,0),G3tensor(:,8))
  call loop_UV_W(G2(:,:,:,6),Q(:,48),wf(:,2),Q(:,10),G3(:,:,:,27))
  call loop_VA_Q(G3(:,:,:,27),wf(:,-2),G3(:,:,:,28))
  call loop_A_Q(G3(:,:,:,28),Q(:,62),ZERO,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,0),G4tensor(:,14))
  call loop_VQ_A(G2(:,:,:,6),wf(:,-1),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,50),ZERO,G3(:,:,:,29))
  call loop_QA_V(G3(:,:,:,29),wf(:,-3),G3(:,:,:,30))
  call loop_VA_Q(G3(:,:,:,30),wf(:,-2),G3(:,:,:,31))
  call loop_A_Q(G3(:,:,:,31),Q(:,62),ZERO,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,0),G4tensor(:,15))
  call loop_QA_V(G3(:,:,:,29),wf(:,-2),G3(:,:,:,32))
  call loop_VA_Q(G3(:,:,:,32),wf(:,-3),G3(:,:,:,33))
  call loop_A_Q(G3(:,:,:,33),Q(:,62),ZERO,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,0),G4tensor(:,16))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,6),wf(:,1),wf(:,2),G2tensor(:,11))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,6),wf(:,2),wf(:,1),G2tensor(:,12))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,6),wf(:,1),wf(:,2),G2tensor(:,13))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,6),wf(:,4),wf(:,5),G2tensor(:,14))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,6),wf(:,5),wf(:,4),G2tensor(:,15))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,6),wf(:,4),wf(:,5),G2tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,1),Q(:,5),G1(:,:,:,12))
  call loop_GHH_G(G1(:,:,:,12),Q(:,5),wf(:,-5),wf(:,-4),G3(:,:,:,34), Q(:,53))
  call loop_VA_Q(G3(:,:,:,34),wf(:,-3),G3(:,:,:,35))
  call loop_A_Q(G3(:,:,:,35),Q(:,61),ZERO,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,-1),G4tensor(:,17))
  call loop_GH_G(G1(:,:,:,12),Q(:,5),wf(:,7),G3(:,:,:,36), Q(:,53))
  call loop_VA_Q(G3(:,:,:,36),wf(:,-3),G3(:,:,:,37))
  call loop_A_Q(G3(:,:,:,37),Q(:,61),ZERO,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,-1),G4tensor(:,18))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),ZERO,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,3),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,61),ZERO,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,-1),G2tensor(:,17))
  call loop_AV_Q(G1(:,:,:,13),wf(:,46),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),ZERO,G2(:,:,:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,0),G2tensor(:,18))
  call loop_AQ_V(G1(:,:,:,13),wf(:,-1),G1(:,:,:,16))
  call loop_GHH_G(G1(:,:,:,16),Q(:,10),wf(:,-5),wf(:,-4),G3(:,:,:,38), Q(:,58))
  call loop_VA_Q(G3(:,:,:,38),wf(:,-2),G3(:,:,:,39))
  call loop_A_Q(G3(:,:,:,39),Q(:,62),ZERO,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,0),G4tensor(:,19))
  call loop_GH_G(G1(:,:,:,16),Q(:,10),wf(:,7),G3(:,:,:,40), Q(:,58))
  call loop_VA_Q(G3(:,:,:,40),wf(:,-2),G3(:,:,:,41))
  call loop_A_Q(G3(:,:,:,41),Q(:,62),ZERO,G4(:,:,:,18))
  call check_last_AQ_V(l_switch,G4(:,:,:,18),wf(:,0),G4tensor(:,20))
  call loop_AV_Q(G1(:,:,:,13),wf(:,75),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,61),ZERO,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,-1),G2tensor(:,19))
  call loop_AV_Q(G1(:,:,:,13),wf(:,76),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,62),ZERO,G2(:,:,:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,19),wf(:,0),G2tensor(:,20))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,53),G1(:,:,:,19))
  call loop_VA_Q(G1(:,:,:,19),wf(:,-3),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,61),ZERO,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,-1),G2tensor(:,21))
  call check_last_UV_W(l_switch,G1(:,:,:,19),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,22))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,9),G1(:,:,:,21))
  call loop_GHH_G(G1(:,:,:,21),Q(:,9),wf(:,-5),wf(:,-4),G3(:,:,:,42), Q(:,57))
  call check_last_UV_W(l_switch,G3(:,:,:,42),Q(:,57),wf(:,5),Q(:,6),G4tensor(:,21))
  call loop_VA_Q(G3(:,:,:,42),wf(:,-2),G3(:,:,:,43))
  call loop_A_Q(G3(:,:,:,43),Q(:,61),ZERO,G4(:,:,:,19))
  call check_last_AQ_V(l_switch,G4(:,:,:,19),wf(:,-1),G4tensor(:,22))
  call loop_GH_G(G1(:,:,:,21),Q(:,9),wf(:,7),G3(:,:,:,44), Q(:,57))
  call check_last_UV_W(l_switch,G3(:,:,:,44),Q(:,57),wf(:,5),Q(:,6),G4tensor(:,23))
  call loop_VA_Q(G3(:,:,:,44),wf(:,-2),G3(:,:,:,45))
  call loop_A_Q(G3(:,:,:,45),Q(:,61),ZERO,G4(:,:,:,20))
  call check_last_AQ_V(l_switch,G4(:,:,:,20),wf(:,-1),G4tensor(:,24))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,7),wf(:,5),Q(:,6),G1(:,:,:,22), Q(:,54))
  call loop_VA_Q(G1(:,:,:,22),wf(:,-3),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,62),ZERO,G2(:,:,:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,21),wf(:,0),G2tensor(:,23))
  call check_last_UV_W(l_switch,G1(:,:,:,22),Q(:,54),wf(:,4),Q(:,9),G2tensor(:,24))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,6),G1(:,:,:,24))
  call loop_GHH_G(G1(:,:,:,24),Q(:,6),wf(:,-5),wf(:,-4),G3(:,:,:,46), Q(:,54))
  call loop_VA_Q(G3(:,:,:,46),wf(:,-3),G3(:,:,:,47))
  call loop_A_Q(G3(:,:,:,47),Q(:,62),ZERO,G4(:,:,:,21))
  call check_last_AQ_V(l_switch,G4(:,:,:,21),wf(:,0),G4tensor(:,25))
  call loop_GH_G(G1(:,:,:,24),Q(:,6),wf(:,7),G3(:,:,:,48), Q(:,54))
  call loop_VA_Q(G3(:,:,:,48),wf(:,-3),G3(:,:,:,49))
  call loop_A_Q(G3(:,:,:,49),Q(:,62),ZERO,G4(:,:,:,22))
  call check_last_AQ_V(l_switch,G4(:,:,:,22),wf(:,0),G4tensor(:,26))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,46),Q(:,54),G1(:,:,:,25))
  call loop_VA_Q(G1(:,:,:,25),wf(:,-3),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,62),ZERO,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,0),G2tensor(:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,25),Q(:,54),wf(:,4),Q(:,9),G2tensor(:,26))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,7),wf(:,4),Q(:,9),G1(:,:,:,27), Q(:,57))
  call loop_VA_Q(G1(:,:,:,27),wf(:,-2),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,61),ZERO,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,-1),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,27),Q(:,57),wf(:,5),Q(:,6),G2tensor(:,28))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,4),ZERO,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,6),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,61),ZERO,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,-1),G2tensor(:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,31),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,62),ZERO,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,0),G2tensor(:,30))
  call loop_AQ_V(G1(:,:,:,29),wf(:,-1),G1(:,:,:,32))
  call loop_GHH_G(G1(:,:,:,32),Q(:,6),wf(:,-5),wf(:,-4),G3(:,:,:,50), Q(:,54))
  call loop_VA_Q(G3(:,:,:,50),wf(:,-3),G3(:,:,:,51))
  call loop_A_Q(G3(:,:,:,51),Q(:,62),ZERO,G4(:,:,:,23))
  call check_last_AQ_V(l_switch,G4(:,:,:,23),wf(:,0),G4tensor(:,27))
  call loop_GH_G(G1(:,:,:,32),Q(:,6),wf(:,7),G3(:,:,:,52), Q(:,54))
  call loop_VA_Q(G3(:,:,:,52),wf(:,-3),G3(:,:,:,53))
  call loop_A_Q(G3(:,:,:,53),Q(:,62),ZERO,G4(:,:,:,24))
  call check_last_AQ_V(l_switch,G4(:,:,:,24),wf(:,0),G4tensor(:,28))
  call loop_AV_Q(G1(:,:,:,29),wf(:,77),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,61),ZERO,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,-1),G2tensor(:,31))
  call loop_AV_Q(G1(:,:,:,29),wf(:,74),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,62),ZERO,G2(:,:,:,27))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,0),G2tensor(:,32))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,57),G1(:,:,:,35))
  call loop_VA_Q(G1(:,:,:,35),wf(:,-2),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,61),ZERO,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,-1),G2tensor(:,33))
  call check_last_UV_W(l_switch,G1(:,:,:,35),Q(:,57),wf(:,5),Q(:,6),G2tensor(:,34))
  call loop_GHG_G(G0(:,:,:,1),Q(:,0),wf(:,7),wf(:,2),Q(:,10),G1(:,:,:,37), Q(:,58))
  call loop_VA_Q(G1(:,:,:,37),wf(:,-2),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,62),ZERO,G2(:,:,:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,29),wf(:,0),G2tensor(:,35))
  call check_last_UV_W(l_switch,G1(:,:,:,37),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,36))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,31),Q(:,58),G1(:,:,:,39))
  call loop_VA_Q(G1(:,:,:,39),wf(:,-2),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,62),ZERO,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,0),G2tensor(:,37))
  call check_last_UV_W(l_switch,G1(:,:,:,39),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,38))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,2),ZERO,G1(:,:,:,41))
  call loop_QA_V(G1(:,:,:,41),wf(:,-3),G1(:,:,:,42))
  call loop_GHH_G(G1(:,:,:,42),Q(:,10),wf(:,-5),wf(:,-4),G3(:,:,:,54), Q(:,58))
  call loop_VA_Q(G3(:,:,:,54),wf(:,-2),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,62),ZERO,G4(:,:,:,25))
  call check_last_AQ_V(l_switch,G4(:,:,:,25),wf(:,0),G4tensor(:,29))
  call loop_GH_G(G1(:,:,:,42),Q(:,10),wf(:,7),G3(:,:,:,56), Q(:,58))
  call loop_VA_Q(G3(:,:,:,56),wf(:,-2),G3(:,:,:,57))
  call loop_A_Q(G3(:,:,:,57),Q(:,62),ZERO,G4(:,:,:,26))
  call check_last_AQ_V(l_switch,G4(:,:,:,26),wf(:,0),G4tensor(:,30))
  call loop_QA_V(G1(:,:,:,41),wf(:,-2),G1(:,:,:,43))
  call loop_GHH_G(G1(:,:,:,43),Q(:,6),wf(:,-5),wf(:,-4),G3(:,:,:,58), Q(:,54))
  call loop_VA_Q(G3(:,:,:,58),wf(:,-3),G3(:,:,:,59))
  call loop_A_Q(G3(:,:,:,59),Q(:,62),ZERO,G4(:,:,:,27))
  call check_last_AQ_V(l_switch,G4(:,:,:,27),wf(:,0),G4tensor(:,31))
  call loop_GH_G(G1(:,:,:,43),Q(:,6),wf(:,7),G3(:,:,:,60), Q(:,54))
  call loop_VA_Q(G3(:,:,:,60),wf(:,-3),G3(:,:,:,61))
  call loop_A_Q(G3(:,:,:,61),Q(:,62),ZERO,G4(:,:,:,28))
  call check_last_AQ_V(l_switch,G4(:,:,:,28),wf(:,0),G4tensor(:,32))
  call loop_GH_G(G0(:,:,:,1),Q(:,0),wf(:,7),G2(:,:,:,31), Q(:,48))
  call loop_VA_Q(G2(:,:,:,31),wf(:,-3),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,56),ZERO,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,40),G3tensor(:,9))
  call loop_AV_Q(G3(:,:,:,62),wf(:,1),G3(:,:,:,63))
  call loop_A_Q(G3(:,:,:,63),Q(:,61),ZERO,G4(:,:,:,29))
  call check_last_AQ_V(l_switch,G4(:,:,:,29),wf(:,-1),G4tensor(:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,54),G3tensor(:,10))
  call loop_AV_Q(G3(:,:,:,62),wf(:,5),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,62),ZERO,G4(:,:,:,30))
  call check_last_AQ_V(l_switch,G4(:,:,:,30),wf(:,0),G4tensor(:,34))
  call loop_AQ_V(G3(:,:,:,62),wf(:,-1),G3(:,:,:,65))
  call loop_VA_Q(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66))
  call loop_A_Q(G3(:,:,:,66),Q(:,62),ZERO,G4(:,:,:,31))
  call check_last_AQ_V(l_switch,G4(:,:,:,31),wf(:,0),G4tensor(:,35))
  call loop_VA_Q(G2(:,:,:,31),wf(:,62),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,61),ZERO,G3(:,:,:,67))
  call check_last_AQ_V(l_switch,G3(:,:,:,67),wf(:,-1),G3tensor(:,11))
  call loop_UV_W(G2(:,:,:,31),Q(:,48),wf(:,1),Q(:,5),G3(:,:,:,68))
  call loop_VA_Q(G3(:,:,:,68),wf(:,-3),G3(:,:,:,69))
  call loop_A_Q(G3(:,:,:,69),Q(:,61),ZERO,G4(:,:,:,32))
  call check_last_AQ_V(l_switch,G4(:,:,:,32),wf(:,-1),G4tensor(:,36))
  call loop_VA_Q(G2(:,:,:,31),wf(:,69),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,62),ZERO,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,0),G3tensor(:,12))
  call loop_UV_W(G2(:,:,:,31),Q(:,48),wf(:,5),Q(:,6),G3(:,:,:,71))
  call loop_VA_Q(G3(:,:,:,71),wf(:,-3),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,62),ZERO,G4(:,:,:,33))
  call check_last_AQ_V(l_switch,G4(:,:,:,33),wf(:,0),G4tensor(:,37))
  call loop_VQ_A(G2(:,:,:,31),wf(:,57),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,59),ZERO,G3(:,:,:,73))
  call check_last_QA_V(l_switch,G3(:,:,:,73),wf(:,-2),G3tensor(:,13))
  call loop_VA_Q(G2(:,:,:,31),wf(:,65),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,61),ZERO,G3(:,:,:,74))
  call check_last_AQ_V(l_switch,G3(:,:,:,74),wf(:,-1),G3tensor(:,14))
  call loop_UV_W(G2(:,:,:,31),Q(:,48),wf(:,4),Q(:,9),G3(:,:,:,75))
  call loop_VA_Q(G3(:,:,:,75),wf(:,-2),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,61),ZERO,G4(:,:,:,34))
  call check_last_AQ_V(l_switch,G4(:,:,:,34),wf(:,-1),G4tensor(:,38))
  call loop_VA_Q(G2(:,:,:,31),wf(:,-2),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,52),ZERO,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,4),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,61),ZERO,G4(:,:,:,35))
  call check_last_AQ_V(l_switch,G4(:,:,:,35),wf(:,-1),G4tensor(:,39))
  call loop_AV_Q(G3(:,:,:,77),wf(:,2),G3(:,:,:,79))
  call loop_A_Q(G3(:,:,:,79),Q(:,62),ZERO,G4(:,:,:,36))
  call check_last_AQ_V(l_switch,G4(:,:,:,36),wf(:,0),G4tensor(:,40))
  call loop_AQ_V(G3(:,:,:,77),wf(:,-1),G3(:,:,:,80))
  call loop_VA_Q(G3(:,:,:,80),wf(:,-3),G3(:,:,:,81))
  call loop_A_Q(G3(:,:,:,81),Q(:,62),ZERO,G4(:,:,:,37))
  call check_last_AQ_V(l_switch,G4(:,:,:,37),wf(:,0),G4tensor(:,41))
  call loop_VQ_A(G2(:,:,:,31),wf(:,59),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,59),ZERO,G3(:,:,:,82))
  call check_last_QA_V(l_switch,G3(:,:,:,82),wf(:,-2),G3tensor(:,15))
  call loop_VA_Q(G2(:,:,:,31),wf(:,72),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,62),ZERO,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,0),G3tensor(:,16))
  call loop_UV_W(G2(:,:,:,31),Q(:,48),wf(:,2),Q(:,10),G3(:,:,:,84))
  call loop_VA_Q(G3(:,:,:,84),wf(:,-2),G3(:,:,:,85))
  call loop_A_Q(G3(:,:,:,85),Q(:,62),ZERO,G4(:,:,:,38))
  call check_last_AQ_V(l_switch,G4(:,:,:,38),wf(:,0),G4tensor(:,42))
  call loop_VQ_A(G2(:,:,:,31),wf(:,-1),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,50),ZERO,G3(:,:,:,86))
  call loop_QA_V(G3(:,:,:,86),wf(:,-3),G3(:,:,:,87))
  call loop_VA_Q(G3(:,:,:,87),wf(:,-2),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,62),ZERO,G4(:,:,:,39))
  call check_last_AQ_V(l_switch,G4(:,:,:,39),wf(:,0),G4tensor(:,43))
  call loop_QA_V(G3(:,:,:,86),wf(:,-2),G3(:,:,:,89))
  call loop_VA_Q(G3(:,:,:,89),wf(:,-3),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,62),ZERO,G4(:,:,:,40))
  call check_last_AQ_V(l_switch,G4(:,:,:,40),wf(:,0),G4tensor(:,44))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,31),wf(:,1),wf(:,2),G2tensor(:,39))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,31),wf(:,2),wf(:,1),G2tensor(:,40))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,31),wf(:,1),wf(:,2),G2tensor(:,41))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,31),wf(:,4),wf(:,5),G2tensor(:,42))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,31),wf(:,5),wf(:,4),G2tensor(:,43))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,31),wf(:,4),wf(:,5),G2tensor(:,44))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,75),Q(:,53),G1(:,:,:,44))
  call loop_VA_Q(G1(:,:,:,44),wf(:,-3),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,61),ZERO,G2(:,:,:,41))
  call check_last_AQ_V(l_switch,G2(:,:,:,41),wf(:,-1),G2tensor(:,45))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,46))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,76),Q(:,54),G1(:,:,:,46))
  call loop_VA_Q(G1(:,:,:,46),wf(:,-3),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,62),ZERO,G2(:,:,:,42))
  call check_last_AQ_V(l_switch,G2(:,:,:,42),wf(:,0),G2tensor(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,46),Q(:,54),wf(:,4),Q(:,9),G2tensor(:,48))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,77),Q(:,57),G1(:,:,:,48))
  call loop_VA_Q(G1(:,:,:,48),wf(:,-2),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,61),ZERO,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,-1),G2tensor(:,49))
  call check_last_UV_W(l_switch,G1(:,:,:,48),Q(:,57),wf(:,5),Q(:,6),G2tensor(:,50))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,74),Q(:,58),G1(:,:,:,50))
  call loop_VA_Q(G1(:,:,:,50),wf(:,-2),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,62),ZERO,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,51))
  call check_last_UV_W(l_switch,G1(:,:,:,50),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,58),ZERO,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,1),G1(:,:,:,53))
  call check_last_Q_A(l_switch,G1(:,:,:,53),Q(:,63),ZERO,G2tensor(:,53))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,31),Q(:,58),G1(:,:,:,54))
  call check_last_CV_D(l_switch,G1(:,:,:,54),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,53),ZERO,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,2),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,63),ZERO,G2tensor(:,55))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,53),G1(:,:,:,57))
  call check_last_CV_D(l_switch,G1(:,:,:,57),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,54),ZERO,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,4),G1(:,:,:,59))
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,63),ZERO,G2tensor(:,57))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,46),Q(:,54),G1(:,:,:,60))
  call check_last_CV_D(l_switch,G1(:,:,:,60),Q(:,54),wf(:,4),Q(:,9),G2tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,57),ZERO,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,5),G1(:,:,:,62))
  call check_last_Q_A(l_switch,G1(:,:,:,62),Q(:,63),ZERO,G2tensor(:,59))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,57),G1(:,:,:,63))
  call check_last_CV_D(l_switch,G1(:,:,:,63),Q(:,57),wf(:,5),Q(:,6),G2tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,75),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,53),ZERO,G1(:,:,:,64))
  call loop_QV_A(G1(:,:,:,64),wf(:,2),G1(:,:,:,65))
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,63),ZERO,G2tensor(:,61))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,75),Q(:,53),G1(:,:,:,66))
  call check_last_CV_D(l_switch,G1(:,:,:,66),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,62))
  call loop_QV_A(G0(:,:,:,1),wf(:,74),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,58),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,1),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,63),ZERO,G2tensor(:,63))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,74),Q(:,58),G1(:,:,:,69))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,77),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,57),ZERO,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,5),G1(:,:,:,71))
  call check_last_Q_A(l_switch,G1(:,:,:,71),Q(:,63),ZERO,G2tensor(:,65))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,77),Q(:,57),G1(:,:,:,72))
  call check_last_CV_D(l_switch,G1(:,:,:,72),Q(:,57),wf(:,5),Q(:,6),G2tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,76),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,54),ZERO,G1(:,:,:,73))
  call loop_QV_A(G1(:,:,:,73),wf(:,4),G1(:,:,:,74))
  call check_last_Q_A(l_switch,G1(:,:,:,74),Q(:,63),ZERO,G2tensor(:,67))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,76),Q(:,54),G1(:,:,:,75))
  call check_last_CV_D(l_switch,G1(:,:,:,75),Q(:,54),wf(:,4),Q(:,9),G2tensor(:,68))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(1)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(5)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(4)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(2)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(13)*M(1))+c(10)*M(2)) * den(3)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(10)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(33)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(61)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(1)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,17)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(1)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(1)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(24)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(24)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(10)*M(1))+c(13)*M(2)) * den(6)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,21)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(12)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(8)*M(1))+c(12)*M(2)) * den(53)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(8)*M(1))+c(12)*M(2)) * den(66)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(5)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,25)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(5)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(5)*M(1)-c(6)*M(2)) * den(5)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(5)*M(1)-c(6)*M(2)) * den(42)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(42)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(11)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(8)*M(1))+c(12)*M(2)) * den(56)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(8)*M(1))+c(12)*M(2)) * den(63)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(4)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,22)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(4)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(5)*M(1)-c(6)*M(2)) * den(4)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(5)*M(1)-c(6)*M(2)) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(1)*M(1))+c(2)*M(2)) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(13)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(58)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(68)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(2)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(2)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,14)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(2)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(21)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(21)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(7)*M(1)-c(9)*M(2))
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(9)*M(1)-c(7)*M(2))
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,31)
  Gcoeff = (c(5)*M(1)+c(11)*M(2))
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,27)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2))
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,19)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2))
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(7)*M(1)-c(9)*M(2))
  T4sum(1:70,20) = T4sum(1:70,20) + Gcoeff * G4tensor(:,15)
  Gcoeff = (c(5)*M(1)+c(11)*M(2))
  T4sum(1:70,21) = T4sum(1:70,21) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(9)*M(1)-c(7)*M(2))
  T4sum(1:70,22) = T4sum(1:70,22) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(26)*M(1)-c(23)*M(2)) * den(78)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(34)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(62)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(72)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(72)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(10)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(10)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,36)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(10)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,33)
  Gcoeff = (c(23)*M(1)-c(26)*M(2)) * den(79)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,23)
  Gcoeff = (c(21)*M(1)-c(25)*M(2)) * den(54)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(21)*M(1)-c(25)*M(2)) * den(67)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(18)*M(1))+c(19)*M(2)) * den(74)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(74)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(12)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,26)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(12)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,37)
  Gcoeff = (-(c(18)*M(1))+c(19)*M(2)) * den(12)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,34)
  Gcoeff = (c(21)*M(1)-c(25)*M(2)) * den(57)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(21)*M(1)-c(25)*M(2)) * den(64)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(18)*M(1))+c(19)*M(2)) * den(76)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(76)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(11)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,24)
  Gcoeff = (c(14)*M(1)-c(15)*M(2)) * den(11)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,38)
  Gcoeff = (-(c(18)*M(1))+c(19)*M(2)) * den(11)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,39)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(59)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(69)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,16)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(70)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(70)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(13)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(13)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,42)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(13)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,40)
  Gcoeff = (-(c(20)*M(1))+c(22)*M(2)) * den(7)
  T4sum(1:70,15) = T4sum(1:70,15) + Gcoeff * G4tensor(:,30)
  Gcoeff = (-(c(22)*M(1))+c(20)*M(2)) * den(7)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,32)
  Gcoeff = (-(c(18)*M(1))-c(24)*M(2)) * den(7)
  T4sum(1:70,17) = T4sum(1:70,17) + Gcoeff * G4tensor(:,28)
  Gcoeff = (c(24)*M(1)+c(18)*M(2)) * den(7)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(24)*M(1)+c(18)*M(2)) * den(7)
  T4sum(1:70,19) = T4sum(1:70,19) + Gcoeff * G4tensor(:,35)
  Gcoeff = (-(c(20)*M(1))+c(22)*M(2)) * den(7)
  T4sum(1:70,20) = T4sum(1:70,20) + Gcoeff * G4tensor(:,43)
  Gcoeff = (-(c(18)*M(1))-c(24)*M(2)) * den(7)
  T4sum(1:70,21) = T4sum(1:70,21) + Gcoeff * G4tensor(:,41)
  Gcoeff = (-(c(22)*M(1))+c(20)*M(2)) * den(7)
  T4sum(1:70,22) = T4sum(1:70,22) + Gcoeff * G4tensor(:,44)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(3)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(3)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,12)
  Gcoeff = (0) * den(3)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(3)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(3)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(3)*M(1))+c(4)*M(2)) * den(6)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(3)*M(1))+c(4)*M(2)) * den(6)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,15)
  Gcoeff = (0) * den(6)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(3)*M(1))+c(4)*M(2)) * den(6)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(3)*M(1))+c(4)*M(2)) * den(6)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(80)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(81)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(8)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(8)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,40)
  Gcoeff = (0) * den(8)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(28)*M(1)-c(27)*M(2)) * den(22)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(30)*M(1)-c(29)*M(2)) * den(22)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(13)*M(1)-c(10)*M(2)) * den(22)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(22)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(28)*M(1)-c(27)*M(2)) * den(25)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(30)*M(1)-c(29)*M(2)) * den(25)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(13)*M(1)-c(10)*M(2)) * den(25)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(25)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(82)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(83)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(9)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(9)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,43)
  Gcoeff = (0) * den(9)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(27)*M(1)-c(28)*M(2)) * den(43)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(29)*M(1)-c(30)*M(2)) * den(43)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(10)*M(1)-c(13)*M(2)) * den(43)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(3)*M(1))+c(4)*M(2)) * den(43)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(27)*M(1)-c(28)*M(2)) * den(46)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(29)*M(1)-c(30)*M(2)) * den(46)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(10)*M(1)-c(13)*M(2)) * den(46)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(3)*M(1))+c(4)*M(2)) * den(46)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(73)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(34)*M(1))+c(33)*M(2)) * den(73)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(26)*M(1))+c(23)*M(2)) * den(73)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(73)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(71)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(34)*M(1))+c(33)*M(2)) * den(71)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(26)*M(1))+c(23)*M(2)) * den(71)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(71)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(31)*M(1))+c(32)*M(2)) * den(77)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(33)*M(1))+c(34)*M(2)) * den(77)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(23)*M(1))+c(26)*M(2)) * den(77)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(77)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(31)*M(1))+c(32)*M(2)) * den(75)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(33)*M(1))+c(34)*M(2)) * den(75)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(23)*M(1))+c(26)*M(2)) * den(75)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(75)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,48)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_heftpphhjj_dddxdxhh_1_/**/REALKIND
