
module ol_external_heftpphhjj_hhggggg_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_heftpphhjj_hhggggg_1(7) = &
                     [ (dummy_counter, dummy_counter = 1, 7) ]
  integer, save :: external_perm_inv_heftpphhjj_hhggggg_1(7) = &
                     [ (dummy_counter, dummy_counter = 1, 7) ]
  integer, save :: extcomb_perm_heftpphhjj_hhggggg_1(0:29) = &
                     [ (dummy_counter, dummy_counter = 0, 29) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_heftpphhjj_hhggggg_1(7) = &
                     [ 1, 1, 2, 2, 2, 2, 2 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_heftpphhjj_hhggggg_1(7) = &
                     [ 1, 1, 16, 16, 16, 16, 16 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_heftpphhjj_hhggggg_1 = &
                     120
  integer, save :: channel_number_heftpphhjj_hhggggg_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(7,32) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(32,7)
  integer, save :: POLSEL(7) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_heftpphhjj_hhggggg_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 7
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_heftpphhjj_hhggggg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 7
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_heftpphhjj_hhggggg_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(7)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_heftpphhjj_hhggggg_1(7)
    external_perm_heftpphhjj_hhggggg_1 = perm
    do i = 1, 7
      external_perm_inv_heftpphhjj_hhggggg_1( &
        external_perm_heftpphhjj_hhggggg_1(i)) = i
      particle_types_perm_heftpphhjj_hhggggg_1(i) = &
        particle_types_heftpphhjj_hhggggg_1( &
        external_perm_heftpphhjj_hhggggg_1(i))
    end do
    do i = 1, 7
      do j = 1, i
        if (external_perm_heftpphhjj_hhggggg_1(i) >= &
          external_perm_heftpphhjj_hhggggg_1(j)) then
          ii = external_perm_heftpphhjj_hhggggg_1(i)
          jj = external_perm_heftpphhjj_hhggggg_1(j)
        else
          ii = external_perm_heftpphhjj_hhggggg_1(j)
          jj = external_perm_heftpphhjj_hhggggg_1(i)
        end if
        extcomb_perm_heftpphhjj_hhggggg_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_heftpphhjj_hhggggg_1 = 1
    do i = 1, n_scatt
      average_factor_heftpphhjj_hhggggg_1 = &
        average_factor_heftpphhjj_hhggggg_1 &
        * average_factors_heftpphhjj_hhggggg_1( &
        external_perm_heftpphhjj_hhggggg_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 7
        average_factor_heftpphhjj_hhggggg_1 = &
          average_factor_heftpphhjj_hhggggg_1 &
          * factorial(count(particle_types_perm_heftpphhjj_hhggggg_1(n_scatt+1:7) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_heftpphhjj_hhggggg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(7)
    integer :: f_perm(7)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_heftpphhjj_hhggggg_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(7)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(7)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rMH_unscaled, rMH_unscaled, rZERO, rZERO, rZERO, rZERO, rZERO ]
    do i = 1, 7
      m_ex(i) = m_ex_orig(external_perm_heftpphhjj_hhggggg_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_heftpphhjj_hhggggg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(7)
    real(DREALKIND) :: f_m_ex(7)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_heftpphhjj_hhggggg_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,7)
    real(DREALKIND) :: m_ex(7)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_heftpphhjj_hhggggg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,7)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,7)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:, 1) = [  0,  0, -1, -1, -1, -1, -1 ]
  H(:, 2) = [  0,  0, -1, -1, -1, -1,  1 ]
  H(:, 3) = [  0,  0, -1, -1, -1,  1, -1 ]
  H(:, 4) = [  0,  0, -1, -1, -1,  1,  1 ]
  H(:, 5) = [  0,  0, -1, -1,  1, -1, -1 ]
  H(:, 6) = [  0,  0, -1, -1,  1, -1,  1 ]
  H(:, 7) = [  0,  0, -1, -1,  1,  1, -1 ]
  H(:, 8) = [  0,  0, -1, -1,  1,  1,  1 ]
  H(:, 9) = [  0,  0, -1,  1, -1, -1, -1 ]
  H(:,10) = [  0,  0, -1,  1, -1, -1,  1 ]
  H(:,11) = [  0,  0, -1,  1, -1,  1, -1 ]
  H(:,12) = [  0,  0, -1,  1, -1,  1,  1 ]
  H(:,13) = [  0,  0, -1,  1,  1, -1, -1 ]
  H(:,14) = [  0,  0, -1,  1,  1, -1,  1 ]
  H(:,15) = [  0,  0, -1,  1,  1,  1, -1 ]
  H(:,16) = [  0,  0, -1,  1,  1,  1,  1 ]
  H(:,17) = [  0,  0,  1, -1, -1, -1, -1 ]
  H(:,18) = [  0,  0,  1, -1, -1, -1,  1 ]
  H(:,19) = [  0,  0,  1, -1, -1,  1, -1 ]
  H(:,20) = [  0,  0,  1, -1, -1,  1,  1 ]
  H(:,21) = [  0,  0,  1, -1,  1, -1, -1 ]
  H(:,22) = [  0,  0,  1, -1,  1, -1,  1 ]
  H(:,23) = [  0,  0,  1, -1,  1,  1, -1 ]
  H(:,24) = [  0,  0,  1, -1,  1,  1,  1 ]
  H(:,25) = [  0,  0,  1,  1, -1, -1, -1 ]
  H(:,26) = [  0,  0,  1,  1, -1, -1,  1 ]
  H(:,27) = [  0,  0,  1,  1, -1,  1, -1 ]
  H(:,28) = [  0,  0,  1,  1, -1,  1,  1 ]
  H(:,29) = [  0,  0,  1,  1,  1, -1, -1 ]
  H(:,30) = [  0,  0,  1,  1,  1, -1,  1 ]
  H(:,31) = [  0,  0,  1,  1,  1,  1, -1 ]
  H(:,32) = [  0,  0,  1,  1,  1,  1,  1 ]

  H_HC(:,3) = [ ((((2*(binco-1)+flip)*16+binpos, flip = 0, 1), binpos = 1, 16), binco = 1, 32/16/2) ]
  H_HC(:,4) = [ ((((2*(binco-1)+flip)*8+binpos, flip = 0, 1), binpos = 1, 8), binco = 1, 32/8/2) ]
  H_HC(:,5) = [ ((((2*(binco-1)+flip)*4+binpos, flip = 0, 1), binpos = 1, 4), binco = 1, 32/4/2) ]
  H_HC(:,6) = [ ((((2*(binco-1)+flip)*2+binpos, flip = 0, 1), binpos = 1, 2), binco = 1, 32/2/2) ]
  H_HC(:,7) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 32/1/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_heftpphhjj_hhggggg_1")
    implicit none
    integer, intent(in) :: pol(7)
    POLSEL = pol
  end subroutine pol_init

end module ol_external_heftpphhjj_hhggggg_1


module colour_basis_heftpphhjj_hhggggg_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(7) = [0,0,2,2,2,2,2]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_heftpphhjj_hhggggg_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(7)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 24
    ncoupl = 1
    maxpows = 1
    nhel = 32
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_heftpphhjj_hhggggg_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,24)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([4], [1,1])
#endif
#if 24 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [2,1,2,2,2,2,2,3,2,2,4,2,2,5,2,2,6,2,2,7,2,2,8,2,2,9,2,2,10,2,2,11,2,2,12,2,2,13,2,2,14,2,2,15,2,2,16,2,2,17,2,2,18,2,2 &
      ,19,2,2,20,2,2,21,2,2,22,2,2,23,2,2,24,2], &
      [3,24])
#endif
  end subroutine tree_colbasis

end module colour_basis_heftpphhjj_hhggggg_1

! **********************************************************************
module ol_heltables_heftpphhjj_hhggggg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(1) = [0], &
    H2(1) = [0], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n3(3,976), n4(4,160), n5(5,55), n6(6,30)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x1(2,1,1), t3x2(2,2,5), t3x8(2,8,30), t3x4(2,4,55), t3x16(2,16,105), t3x32(2,32,780), t4x2(3,2,5), &
    t4x4(3,4,20), t4x8(3,8,45), t4x16(3,16,90), t5x4(4,4,10), t5x8(4,8,45), t6x8(5,8,30)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(32,7)
  integer,           save :: exthel(32,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,2,8], n4(:,1), t4x8(:,:,1))
  call heltable([1,1,2,2,4], n5(:,1), t5x4(:,:,1))
  call heltable([2,2,2,8], n4(:,2), t4x8(:,:,2))
  call heltable([2,2,2,8], n4(:,3), t4x8(:,:,3))
  call heltable([2,2,2,8], n4(:,4), t4x8(:,:,4))
  call heltable([1,1,2,2,4], n5(:,2), t5x4(:,:,2))
  call heltable([2,2,2,8], n4(:,5), t4x8(:,:,5))
  call heltable([2,2,2,8], n4(:,6), t4x8(:,:,6))
  call heltable([2,2,2,8], n4(:,7), t4x8(:,:,7))
  call heltable([1,1,2,2,4], n5(:,3), t5x4(:,:,3))
  call heltable([2,2,2,8], n4(:,8), t4x8(:,:,8))
  call heltable([2,2,2,8], n4(:,9), t4x8(:,:,9))
  call heltable([2,2,2,8], n4(:,10), t4x8(:,:,10))
  call heltable([1,1,2,2,4], n5(:,4), t5x4(:,:,4))
  call heltable([2,2,2,8], n4(:,11), t4x8(:,:,11))
  call heltable([2,2,2,8], n4(:,12), t4x8(:,:,12))
  call heltable([2,2,2,8], n4(:,13), t4x8(:,:,13))
  call heltable([1,1,2,2,4], n5(:,5), t5x4(:,:,5))
  call heltable([2,2,2,8], n4(:,14), t4x8(:,:,14))
  call heltable([2,2,2,8], n4(:,15), t4x8(:,:,15))
  call heltable([2,2,2,8], n4(:,16), t4x8(:,:,16))
  call heltable([1,1,2,2,4], n5(:,6), t5x4(:,:,6))
  call heltable([2,2,2,8], n4(:,17), t4x8(:,:,17))
  call heltable([2,2,2,8], n4(:,18), t4x8(:,:,18))
  call heltable([2,2,2,8], n4(:,19), t4x8(:,:,19))
  call heltable([1,1,2,2,4], n5(:,7), t5x4(:,:,7))
  call heltable([2,2,2,8], n4(:,20), t4x8(:,:,20))
  call heltable([2,2,2,8], n4(:,21), t4x8(:,:,21))
  call heltable([2,2,2,8], n4(:,22), t4x8(:,:,22))
  call heltable([1,1,2,2,4], n5(:,8), t5x4(:,:,8))
  call heltable([2,2,2,8], n4(:,23), t4x8(:,:,23))
  call heltable([2,2,2,8], n4(:,24), t4x8(:,:,24))
  call heltable([2,2,2,8], n4(:,25), t4x8(:,:,25))
  call heltable([1,1,2,2,4], n5(:,9), t5x4(:,:,9))
  call heltable([2,2,2,8], n4(:,26), t4x8(:,:,26))
  call heltable([2,2,2,8], n4(:,27), t4x8(:,:,27))
  call heltable([2,2,2,8], n4(:,28), t4x8(:,:,28))
  call heltable([1,1,2,2,4], n5(:,10), t5x4(:,:,10))
  call heltable([2,2,2,8], n4(:,29), t4x8(:,:,29))
  call heltable([2,2,2,8], n4(:,30), t4x8(:,:,30))
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([1,1,2,2,2,8], n6(:,1), t6x8(:,:,1))
  call heltable([1,1,2,2,2,8], n6(:,2), t6x8(:,:,2))
  call heltable([1,1,2,2,2,8], n6(:,3), t6x8(:,:,3))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([1,1,2,2,2,8], n6(:,4), t6x8(:,:,4))
  call heltable([1,1,2,2,2,8], n6(:,5), t6x8(:,:,5))
  call heltable([1,1,2,2,2,8], n6(:,6), t6x8(:,:,6))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  call heltable([1,1,2,2,2,8], n6(:,7), t6x8(:,:,7))
  call heltable([1,1,2,2,2,8], n6(:,8), t6x8(:,:,8))
  call heltable([1,1,2,2,2,8], n6(:,9), t6x8(:,:,9))
  call heltable([2,2,4], n3(:,4), t3x4(:,:,4))
  call heltable([1,1,2,2,2,8], n6(:,10), t6x8(:,:,10))
  call heltable([1,1,2,2,2,8], n6(:,11), t6x8(:,:,11))
  call heltable([1,1,2,2,2,8], n6(:,12), t6x8(:,:,12))
  call heltable([2,2,4], n3(:,5), t3x4(:,:,5))
  call heltable([1,1,2,2,2,8], n6(:,13), t6x8(:,:,13))
  call heltable([1,1,2,2,2,8], n6(:,14), t6x8(:,:,14))
  call heltable([1,1,2,2,2,8], n6(:,15), t6x8(:,:,15))
  call heltable([2,2,4], n3(:,6), t3x4(:,:,6))
  call heltable([1,1,2,2,2,8], n6(:,16), t6x8(:,:,16))
  call heltable([1,1,2,2,2,8], n6(:,17), t6x8(:,:,17))
  call heltable([1,1,2,2,2,8], n6(:,18), t6x8(:,:,18))
  call heltable([2,2,4], n3(:,7), t3x4(:,:,7))
  call heltable([1,1,2,2,2,8], n6(:,19), t6x8(:,:,19))
  call heltable([1,1,2,2,2,8], n6(:,20), t6x8(:,:,20))
  call heltable([1,1,2,2,2,8], n6(:,21), t6x8(:,:,21))
  call heltable([2,2,4], n3(:,8), t3x4(:,:,8))
  call heltable([1,1,2,2,2,8], n6(:,22), t6x8(:,:,22))
  call heltable([1,1,2,2,2,8], n6(:,23), t6x8(:,:,23))
  call heltable([1,1,2,2,2,8], n6(:,24), t6x8(:,:,24))
  call heltable([2,2,4], n3(:,9), t3x4(:,:,9))
  call heltable([1,1,2,2,2,8], n6(:,25), t6x8(:,:,25))
  call heltable([1,1,2,2,2,8], n6(:,26), t6x8(:,:,26))
  call heltable([1,1,2,2,2,8], n6(:,27), t6x8(:,:,27))
  call heltable([2,2,4], n3(:,10), t3x4(:,:,10))
  call heltable([1,1,2,2,2,8], n6(:,28), t6x8(:,:,28))
  call heltable([1,1,2,2,2,8], n6(:,29), t6x8(:,:,29))
  call heltable([1,1,2,2,2,8], n6(:,30), t6x8(:,:,30))
  call heltable([1,1,1], n3(:,11), t3x1(:,:,1))
  call heltable([1,2,2,2,8], n5(:,11), t5x8(:,:,1))
  call heltable([1,2,2,2,8], n5(:,12), t5x8(:,:,2))
  call heltable([1,2,2,2,8], n5(:,13), t5x8(:,:,3))
  call heltable([1,2,2,2,8], n5(:,14), t5x8(:,:,4))
  call heltable([1,2,2,2,8], n5(:,15), t5x8(:,:,5))
  call heltable([1,2,2,2,8], n5(:,16), t5x8(:,:,6))
  call heltable([1,2,2,2,8], n5(:,17), t5x8(:,:,7))
  call heltable([1,2,2,2,8], n5(:,18), t5x8(:,:,8))
  call heltable([1,2,2,2,8], n5(:,19), t5x8(:,:,9))
  call heltable([1,2,2,2,8], n5(:,20), t5x8(:,:,10))
  call heltable([1,2,2,2,8], n5(:,21), t5x8(:,:,11))
  call heltable([1,2,2,2,8], n5(:,22), t5x8(:,:,12))
  call heltable([1,2,2,4], n4(:,31), t4x4(:,:,1))
  call heltable([1,2,2,4], n4(:,32), t4x4(:,:,2))
  call heltable([1,2,2,4], n4(:,33), t4x4(:,:,3))
  call heltable([1,2,2,4], n4(:,34), t4x4(:,:,4))
  call heltable([1,2,2,4], n4(:,35), t4x4(:,:,5))
  call heltable([1,2,2,4], n4(:,36), t4x4(:,:,6))
  call heltable([1,2,2,4], n4(:,37), t4x4(:,:,7))
  call heltable([1,2,2,4], n4(:,38), t4x4(:,:,8))
  call heltable([1,2,2,4], n4(:,39), t4x4(:,:,9))
  call heltable([1,2,2,4], n4(:,40), t4x4(:,:,10))
  call heltable([1,2,2,2,8], n5(:,23), t5x8(:,:,13))
  call heltable([1,2,2,2,8], n5(:,24), t5x8(:,:,14))
  call heltable([1,2,2,2,8], n5(:,25), t5x8(:,:,15))
  call heltable([1,2,2,2,8], n5(:,26), t5x8(:,:,16))
  call heltable([1,2,2,2,8], n5(:,27), t5x8(:,:,17))
  call heltable([1,2,2,2,8], n5(:,28), t5x8(:,:,18))
  call heltable([1,2,2,2,8], n5(:,29), t5x8(:,:,19))
  call heltable([1,2,2,2,8], n5(:,30), t5x8(:,:,20))
  call heltable([1,2,2,2,8], n5(:,31), t5x8(:,:,21))
  call heltable([1,2,2,2,8], n5(:,32), t5x8(:,:,22))
  call heltable([1,2,2,2,8], n5(:,33), t5x8(:,:,23))
  call heltable([1,2,2,2,8], n5(:,34), t5x8(:,:,24))
  call heltable([1,2,2,2,8], n5(:,35), t5x8(:,:,25))
  call heltable([1,2,2,2,8], n5(:,36), t5x8(:,:,26))
  call heltable([1,2,2,2,8], n5(:,37), t5x8(:,:,27))
  call heltable([1,2,2,2,8], n5(:,38), t5x8(:,:,28))
  call heltable([1,2,2,2,8], n5(:,39), t5x8(:,:,29))
  call heltable([1,2,2,2,8], n5(:,40), t5x8(:,:,30))
  call heltable([1,1,2,2], n4(:,41), t4x2(:,:,1))
  call heltable([4,2,2,16], n4(:,42), t4x16(:,:,1))
  call heltable([2,2,4,16], n4(:,43), t4x16(:,:,2))
  call heltable([2,4,2,16], n4(:,44), t4x16(:,:,3))
  call heltable([1,1,2,2], n4(:,45), t4x2(:,:,2))
  call heltable([4,2,2,16], n4(:,46), t4x16(:,:,4))
  call heltable([2,2,4,16], n4(:,47), t4x16(:,:,5))
  call heltable([2,4,2,16], n4(:,48), t4x16(:,:,6))
  call heltable([1,1,2,2], n4(:,49), t4x2(:,:,3))
  call heltable([4,2,2,16], n4(:,50), t4x16(:,:,7))
  call heltable([2,2,4,16], n4(:,51), t4x16(:,:,8))
  call heltable([2,4,2,16], n4(:,52), t4x16(:,:,9))
  call heltable([1,1,4,4], n4(:,53), t4x4(:,:,11))
  call heltable([1,1,2,2], n4(:,54), t4x2(:,:,4))
  call heltable([4,2,2,16], n4(:,55), t4x16(:,:,10))
  call heltable([2,2,4,16], n4(:,56), t4x16(:,:,11))
  call heltable([2,4,2,16], n4(:,57), t4x16(:,:,12))
  call heltable([2,4,2,16], n4(:,58), t4x16(:,:,13))
  call heltable([4,2,2,16], n4(:,59), t4x16(:,:,14))
  call heltable([2,2,4,16], n4(:,60), t4x16(:,:,15))
  call heltable([2,2,4,16], n4(:,61), t4x16(:,:,16))
  call heltable([2,4,2,16], n4(:,62), t4x16(:,:,17))
  call heltable([4,2,2,16], n4(:,63), t4x16(:,:,18))
  call heltable([2,2,4], n3(:,12), t3x4(:,:,11))
  call heltable([2,4,2,16], n4(:,64), t4x16(:,:,19))
  call heltable([4,2,2,16], n4(:,65), t4x16(:,:,20))
  call heltable([2,2,4,16], n4(:,66), t4x16(:,:,21))
  call heltable([2,4,2,16], n4(:,67), t4x16(:,:,22))
  call heltable([4,2,2,16], n4(:,68), t4x16(:,:,23))
  call heltable([2,2,4,16], n4(:,69), t4x16(:,:,24))
  call heltable([1,1,4,4], n4(:,70), t4x4(:,:,12))
  call heltable([2,4,2,16], n4(:,71), t4x16(:,:,25))
  call heltable([4,2,2,16], n4(:,72), t4x16(:,:,26))
  call heltable([2,2,4,16], n4(:,73), t4x16(:,:,27))
  call heltable([2,2,4,16], n4(:,74), t4x16(:,:,28))
  call heltable([2,4,2,16], n4(:,75), t4x16(:,:,29))
  call heltable([4,2,2,16], n4(:,76), t4x16(:,:,30))
  call heltable([2,2,4], n3(:,13), t3x4(:,:,12))
  call heltable([2,2,4,16], n4(:,77), t4x16(:,:,31))
  call heltable([2,4,2,16], n4(:,78), t4x16(:,:,32))
  call heltable([4,2,2,16], n4(:,79), t4x16(:,:,33))
  call heltable([1,1,4,4], n4(:,80), t4x4(:,:,13))
  call heltable([2,2,4,16], n4(:,81), t4x16(:,:,34))
  call heltable([2,4,2,16], n4(:,82), t4x16(:,:,35))
  call heltable([4,2,2,16], n4(:,83), t4x16(:,:,36))
  call heltable([2,2,4], n3(:,14), t3x4(:,:,13))
  call heltable([1,1,4,4], n4(:,84), t4x4(:,:,14))
  call heltable([2,2,4], n3(:,15), t3x4(:,:,14))
  call heltable([1,1,2,2], n4(:,85), t4x2(:,:,5))
  call heltable([4,2,2,16], n4(:,86), t4x16(:,:,37))
  call heltable([2,2,4,16], n4(:,87), t4x16(:,:,38))
  call heltable([2,4,2,16], n4(:,88), t4x16(:,:,39))
  call heltable([2,4,2,16], n4(:,89), t4x16(:,:,40))
  call heltable([4,2,2,16], n4(:,90), t4x16(:,:,41))
  call heltable([2,2,4,16], n4(:,91), t4x16(:,:,42))
  call heltable([2,2,4,16], n4(:,92), t4x16(:,:,43))
  call heltable([2,4,2,16], n4(:,93), t4x16(:,:,44))
  call heltable([4,2,2,16], n4(:,94), t4x16(:,:,45))
  call heltable([2,2,4], n3(:,16), t3x4(:,:,15))
  call heltable([2,4,2,16], n4(:,95), t4x16(:,:,46))
  call heltable([4,2,2,16], n4(:,96), t4x16(:,:,47))
  call heltable([2,2,4,16], n4(:,97), t4x16(:,:,48))
  call heltable([2,2,4,16], n4(:,98), t4x16(:,:,49))
  call heltable([2,4,2,16], n4(:,99), t4x16(:,:,50))
  call heltable([4,2,2,16], n4(:,100), t4x16(:,:,51))
  call heltable([2,2,4], n3(:,17), t3x4(:,:,16))
  call heltable([2,2,4,16], n4(:,101), t4x16(:,:,52))
  call heltable([2,4,2,16], n4(:,102), t4x16(:,:,53))
  call heltable([4,2,2,16], n4(:,103), t4x16(:,:,54))
  call heltable([2,2,4], n3(:,18), t3x4(:,:,17))
  call heltable([2,2,4], n3(:,19), t3x4(:,:,18))
  call heltable([2,4,2,16], n4(:,104), t4x16(:,:,55))
  call heltable([4,2,2,16], n4(:,105), t4x16(:,:,56))
  call heltable([2,2,4,16], n4(:,106), t4x16(:,:,57))
  call heltable([2,4,2,16], n4(:,107), t4x16(:,:,58))
  call heltable([4,2,2,16], n4(:,108), t4x16(:,:,59))
  call heltable([2,2,4,16], n4(:,109), t4x16(:,:,60))
  call heltable([1,1,4,4], n4(:,110), t4x4(:,:,15))
  call heltable([2,4,2,16], n4(:,111), t4x16(:,:,61))
  call heltable([4,2,2,16], n4(:,112), t4x16(:,:,62))
  call heltable([2,2,4,16], n4(:,113), t4x16(:,:,63))
  call heltable([2,2,4,16], n4(:,114), t4x16(:,:,64))
  call heltable([2,4,2,16], n4(:,115), t4x16(:,:,65))
  call heltable([4,2,2,16], n4(:,116), t4x16(:,:,66))
  call heltable([2,2,4], n3(:,20), t3x4(:,:,19))
  call heltable([2,2,4,16], n4(:,117), t4x16(:,:,67))
  call heltable([2,4,2,16], n4(:,118), t4x16(:,:,68))
  call heltable([4,2,2,16], n4(:,119), t4x16(:,:,69))
  call heltable([1,1,4,4], n4(:,120), t4x4(:,:,16))
  call heltable([2,2,4,16], n4(:,121), t4x16(:,:,70))
  call heltable([2,4,2,16], n4(:,122), t4x16(:,:,71))
  call heltable([4,2,2,16], n4(:,123), t4x16(:,:,72))
  call heltable([2,2,4], n3(:,21), t3x4(:,:,20))
  call heltable([1,1,4,4], n4(:,124), t4x4(:,:,17))
  call heltable([2,2,4], n3(:,22), t3x4(:,:,21))
  call heltable([2,4,2,16], n4(:,125), t4x16(:,:,73))
  call heltable([4,2,2,16], n4(:,126), t4x16(:,:,74))
  call heltable([2,2,4,16], n4(:,127), t4x16(:,:,75))
  call heltable([2,2,4,16], n4(:,128), t4x16(:,:,76))
  call heltable([2,4,2,16], n4(:,129), t4x16(:,:,77))
  call heltable([4,2,2,16], n4(:,130), t4x16(:,:,78))
  call heltable([2,2,4], n3(:,23), t3x4(:,:,22))
  call heltable([2,2,4,16], n4(:,131), t4x16(:,:,79))
  call heltable([2,4,2,16], n4(:,132), t4x16(:,:,80))
  call heltable([4,2,2,16], n4(:,133), t4x16(:,:,81))
  call heltable([2,2,4], n3(:,24), t3x4(:,:,23))
  call heltable([2,2,4], n3(:,25), t3x4(:,:,24))
  call heltable([2,2,4,16], n4(:,134), t4x16(:,:,82))
  call heltable([2,4,2,16], n4(:,135), t4x16(:,:,83))
  call heltable([4,2,2,16], n4(:,136), t4x16(:,:,84))
  call heltable([1,1,4,4], n4(:,137), t4x4(:,:,18))
  call heltable([2,2,4,16], n4(:,138), t4x16(:,:,85))
  call heltable([2,4,2,16], n4(:,139), t4x16(:,:,86))
  call heltable([4,2,2,16], n4(:,140), t4x16(:,:,87))
  call heltable([2,2,4], n3(:,26), t3x4(:,:,25))
  call heltable([1,1,4,4], n4(:,141), t4x4(:,:,19))
  call heltable([2,2,4], n3(:,27), t3x4(:,:,26))
  call heltable([2,2,4,16], n4(:,142), t4x16(:,:,88))
  call heltable([2,4,2,16], n4(:,143), t4x16(:,:,89))
  call heltable([4,2,2,16], n4(:,144), t4x16(:,:,90))
  call heltable([2,2,4], n3(:,28), t3x4(:,:,27))
  call heltable([2,2,4], n3(:,29), t3x4(:,:,28))
  call heltable([1,1,4,4], n4(:,145), t4x4(:,:,20))
  call heltable([2,2,4], n3(:,30), t3x4(:,:,29))
  call heltable([2,2,4], n3(:,31), t3x4(:,:,30))
  call heltable([1,1,4,2,8], n5(:,41), t5x8(:,:,31))
  call heltable([1,1,4,2,8], n5(:,42), t5x8(:,:,32))
  call heltable([4,2,8], n3(:,32), t3x8(:,:,1))
  call heltable([1,1,4,2,8], n5(:,43), t5x8(:,:,33))
  call heltable([4,2,8], n3(:,33), t3x8(:,:,2))
  call heltable([4,2,8], n3(:,34), t3x8(:,:,3))
  call heltable([1,1,4,2,8], n5(:,44), t5x8(:,:,34))
  call heltable([1,1,4,2,8], n5(:,45), t5x8(:,:,35))
  call heltable([2,4,8], n3(:,35), t3x8(:,:,4))
  call heltable([1,1,4,2,8], n5(:,46), t5x8(:,:,36))
  call heltable([1,1,2,4,8], n5(:,47), t5x8(:,:,37))
  call heltable([2,4,8], n3(:,36), t3x8(:,:,5))
  call heltable([1,1,2,4,8], n5(:,48), t5x8(:,:,38))
  call heltable([2,4,8], n3(:,37), t3x8(:,:,6))
  call heltable([1,1,2,4,8], n5(:,49), t5x8(:,:,39))
  call heltable([2,4,8], n3(:,38), t3x8(:,:,7))
  call heltable([2,4,8], n3(:,39), t3x8(:,:,8))
  call heltable([2,4,8], n3(:,40), t3x8(:,:,9))
  call heltable([1,1,2,4,8], n5(:,50), t5x8(:,:,40))
  call heltable([4,2,8], n3(:,41), t3x8(:,:,10))
  call heltable([4,2,8], n3(:,42), t3x8(:,:,11))
  call heltable([1,1,2,4,8], n5(:,51), t5x8(:,:,41))
  call heltable([2,4,8], n3(:,43), t3x8(:,:,12))
  call heltable([1,1,2,4,8], n5(:,52), t5x8(:,:,42))
  call heltable([2,4,8], n3(:,44), t3x8(:,:,13))
  call heltable([2,4,8], n3(:,45), t3x8(:,:,14))
  call heltable([2,4,8], n3(:,46), t3x8(:,:,15))
  call heltable([4,2,8], n3(:,47), t3x8(:,:,16))
  call heltable([2,4,8], n3(:,48), t3x8(:,:,17))
  call heltable([2,4,8], n3(:,49), t3x8(:,:,18))
  call heltable([1,1,2,4,8], n5(:,53), t5x8(:,:,43))
  call heltable([4,2,8], n3(:,50), t3x8(:,:,19))
  call heltable([4,2,8], n3(:,51), t3x8(:,:,20))
  call heltable([1,1,2,4,8], n5(:,54), t5x8(:,:,44))
  call heltable([2,4,8], n3(:,52), t3x8(:,:,21))
  call heltable([1,1,2,4,8], n5(:,55), t5x8(:,:,45))
  call heltable([2,4,8], n3(:,53), t3x8(:,:,22))
  call heltable([2,4,8], n3(:,54), t3x8(:,:,23))
  call heltable([2,4,8], n3(:,55), t3x8(:,:,24))
  call heltable([4,2,8], n3(:,56), t3x8(:,:,25))
  call heltable([2,4,8], n3(:,57), t3x8(:,:,26))
  call heltable([2,4,8], n3(:,58), t3x8(:,:,27))
  call heltable([4,2,8], n3(:,59), t3x8(:,:,28))
  call heltable([2,4,8], n3(:,60), t3x8(:,:,29))
  call heltable([2,4,8], n3(:,61), t3x8(:,:,30))
  call heltable([1,4,2,8], n4(:,146), t4x8(:,:,31))
  call heltable([1,4,2,8], n4(:,147), t4x8(:,:,32))
  call heltable([1,2,2], n3(:,62), t3x2(:,:,1))
  call heltable([1,4,2,8], n4(:,148), t4x8(:,:,33))
  call heltable([1,2,2], n3(:,63), t3x2(:,:,2))
  call heltable([1,2,2], n3(:,64), t3x2(:,:,3))
  call heltable([1,4,4], n3(:,65), t3x4(:,:,31))
  call heltable([1,4,2,8], n4(:,149), t4x8(:,:,34))
  call heltable([1,4,2,8], n4(:,150), t4x8(:,:,35))
  call heltable([1,2,2], n3(:,66), t3x2(:,:,4))
  call heltable([1,4,2,8], n4(:,151), t4x8(:,:,36))
  call heltable([1,2,4,8], n4(:,152), t4x8(:,:,37))
  call heltable([1,2,2], n3(:,67), t3x2(:,:,5))
  call heltable([1,2,4,8], n4(:,153), t4x8(:,:,38))
  call heltable([1,2,4,8], n4(:,154), t4x8(:,:,39))
  call heltable([2,8,16], n3(:,68), t3x16(:,:,1))
  call heltable([2,8,16], n3(:,69), t3x16(:,:,2))
  call heltable([2,8,16], n3(:,70), t3x16(:,:,3))
  call heltable([2,8,16], n3(:,71), t3x16(:,:,4))
  call heltable([2,8,16], n3(:,72), t3x16(:,:,5))
  call heltable([2,8,16], n3(:,73), t3x16(:,:,6))
  call heltable([1,2,4,8], n4(:,155), t4x8(:,:,40))
  call heltable([1,4,4], n3(:,74), t3x4(:,:,32))
  call heltable([1,2,4,8], n4(:,156), t4x8(:,:,41))
  call heltable([1,2,4,8], n4(:,157), t4x8(:,:,42))
  call heltable([2,8,16], n3(:,75), t3x16(:,:,7))
  call heltable([2,8,16], n3(:,76), t3x16(:,:,8))
  call heltable([2,8,16], n3(:,77), t3x16(:,:,9))
  call heltable([2,8,16], n3(:,78), t3x16(:,:,10))
  call heltable([2,8,16], n3(:,79), t3x16(:,:,11))
  call heltable([2,8,16], n3(:,80), t3x16(:,:,12))
  call heltable([1,4,4], n3(:,81), t3x4(:,:,33))
  call heltable([2,8,16], n3(:,82), t3x16(:,:,13))
  call heltable([2,8,16], n3(:,83), t3x16(:,:,14))
  call heltable([2,8,16], n3(:,84), t3x16(:,:,15))
  call heltable([2,8,16], n3(:,85), t3x16(:,:,16))
  call heltable([2,8,16], n3(:,86), t3x16(:,:,17))
  call heltable([2,8,16], n3(:,87), t3x16(:,:,18))
  call heltable([1,4,4], n3(:,88), t3x4(:,:,34))
  call heltable([8,2,16], n3(:,89), t3x16(:,:,19))
  call heltable([8,2,16], n3(:,90), t3x16(:,:,20))
  call heltable([8,2,16], n3(:,91), t3x16(:,:,21))
  call heltable([2,8,16], n3(:,92), t3x16(:,:,22))
  call heltable([2,8,16], n3(:,93), t3x16(:,:,23))
  call heltable([2,8,16], n3(:,94), t3x16(:,:,24))
  call heltable([1,2,4,8], n4(:,158), t4x8(:,:,43))
  call heltable([1,4,4], n3(:,95), t3x4(:,:,35))
  call heltable([1,2,4,8], n4(:,159), t4x8(:,:,44))
  call heltable([1,2,4,8], n4(:,160), t4x8(:,:,45))
  call heltable([2,8,16], n3(:,96), t3x16(:,:,25))
  call heltable([2,8,16], n3(:,97), t3x16(:,:,26))
  call heltable([2,8,16], n3(:,98), t3x16(:,:,27))
  call heltable([2,8,16], n3(:,99), t3x16(:,:,28))
  call heltable([2,8,16], n3(:,100), t3x16(:,:,29))
  call heltable([2,8,16], n3(:,101), t3x16(:,:,30))
  call heltable([1,4,4], n3(:,102), t3x4(:,:,36))
  call heltable([2,8,16], n3(:,103), t3x16(:,:,31))
  call heltable([2,8,16], n3(:,104), t3x16(:,:,32))
  call heltable([2,8,16], n3(:,105), t3x16(:,:,33))
  call heltable([2,8,16], n3(:,106), t3x16(:,:,34))
  call heltable([2,8,16], n3(:,107), t3x16(:,:,35))
  call heltable([2,8,16], n3(:,108), t3x16(:,:,36))
  call heltable([1,4,4], n3(:,109), t3x4(:,:,37))
  call heltable([8,2,16], n3(:,110), t3x16(:,:,37))
  call heltable([8,2,16], n3(:,111), t3x16(:,:,38))
  call heltable([8,2,16], n3(:,112), t3x16(:,:,39))
  call heltable([2,8,16], n3(:,113), t3x16(:,:,40))
  call heltable([2,8,16], n3(:,114), t3x16(:,:,41))
  call heltable([2,8,16], n3(:,115), t3x16(:,:,42))
  call heltable([1,4,4], n3(:,116), t3x4(:,:,38))
  call heltable([2,8,16], n3(:,117), t3x16(:,:,43))
  call heltable([2,8,16], n3(:,118), t3x16(:,:,44))
  call heltable([2,8,16], n3(:,119), t3x16(:,:,45))
  call heltable([2,8,16], n3(:,120), t3x16(:,:,46))
  call heltable([2,8,16], n3(:,121), t3x16(:,:,47))
  call heltable([2,8,16], n3(:,122), t3x16(:,:,48))
  call heltable([1,4,4], n3(:,123), t3x4(:,:,39))
  call heltable([8,2,16], n3(:,124), t3x16(:,:,49))
  call heltable([8,2,16], n3(:,125), t3x16(:,:,50))
  call heltable([8,2,16], n3(:,126), t3x16(:,:,51))
  call heltable([2,8,16], n3(:,127), t3x16(:,:,52))
  call heltable([2,8,16], n3(:,128), t3x16(:,:,53))
  call heltable([2,8,16], n3(:,129), t3x16(:,:,54))
  call heltable([1,4,4], n3(:,130), t3x4(:,:,40))
  call heltable([8,2,16], n3(:,131), t3x16(:,:,55))
  call heltable([8,2,16], n3(:,132), t3x16(:,:,56))
  call heltable([8,2,16], n3(:,133), t3x16(:,:,57))
  call heltable([8,2,16], n3(:,134), t3x16(:,:,58))
  call heltable([8,2,16], n3(:,135), t3x16(:,:,59))
  call heltable([8,2,16], n3(:,136), t3x16(:,:,60))
  call heltable([4,4,16], n3(:,137), t3x16(:,:,61))
  call heltable([4,4,16], n3(:,138), t3x16(:,:,62))
  call heltable([4,4,16], n3(:,139), t3x16(:,:,63))
  call heltable([4,4,16], n3(:,140), t3x16(:,:,64))
  call heltable([4,4,16], n3(:,141), t3x16(:,:,65))
  call heltable([4,4,16], n3(:,142), t3x16(:,:,66))
  call heltable([4,4,16], n3(:,143), t3x16(:,:,67))
  call heltable([4,4,16], n3(:,144), t3x16(:,:,68))
  call heltable([4,4,16], n3(:,145), t3x16(:,:,69))
  call heltable([4,4,16], n3(:,146), t3x16(:,:,70))
  call heltable([4,4,16], n3(:,147), t3x16(:,:,71))
  call heltable([4,4,16], n3(:,148), t3x16(:,:,72))
  call heltable([4,4,16], n3(:,149), t3x16(:,:,73))
  call heltable([4,4,16], n3(:,150), t3x16(:,:,74))
  call heltable([4,4,16], n3(:,151), t3x16(:,:,75))
  call heltable([2,2,4], n3(:,152), t3x4(:,:,41))
  call heltable([2,2,4], n3(:,153), t3x4(:,:,42))
  call heltable([8,2,16], n3(:,154), t3x16(:,:,76))
  call heltable([2,2,4], n3(:,155), t3x4(:,:,43))
  call heltable([8,2,16], n3(:,156), t3x16(:,:,77))
  call heltable([2,8,16], n3(:,157), t3x16(:,:,78))
  call heltable([2,2,4], n3(:,158), t3x4(:,:,44))
  call heltable([2,2,4], n3(:,159), t3x4(:,:,45))
  call heltable([8,2,16], n3(:,160), t3x16(:,:,79))
  call heltable([2,2,4], n3(:,161), t3x4(:,:,46))
  call heltable([8,2,16], n3(:,162), t3x16(:,:,80))
  call heltable([2,8,16], n3(:,163), t3x16(:,:,81))
  call heltable([2,2,4], n3(:,164), t3x4(:,:,47))
  call heltable([2,2,4], n3(:,165), t3x4(:,:,48))
  call heltable([8,2,16], n3(:,166), t3x16(:,:,82))
  call heltable([2,2,4], n3(:,167), t3x4(:,:,49))
  call heltable([8,2,16], n3(:,168), t3x16(:,:,83))
  call heltable([2,8,16], n3(:,169), t3x16(:,:,84))
  call heltable([2,2,4], n3(:,170), t3x4(:,:,50))
  call heltable([8,2,16], n3(:,171), t3x16(:,:,85))
  call heltable([2,2,4], n3(:,172), t3x4(:,:,51))
  call heltable([2,8,16], n3(:,173), t3x16(:,:,86))
  call heltable([2,8,16], n3(:,174), t3x16(:,:,87))
  call heltable([2,2,4], n3(:,175), t3x4(:,:,52))
  call heltable([8,2,16], n3(:,176), t3x16(:,:,88))
  call heltable([2,2,4], n3(:,177), t3x4(:,:,53))
  call heltable([2,8,16], n3(:,178), t3x16(:,:,89))
  call heltable([2,8,16], n3(:,179), t3x16(:,:,90))
  call heltable([2,2,4], n3(:,180), t3x4(:,:,54))
  call heltable([2,2,4], n3(:,181), t3x4(:,:,55))
  call heltable([8,2,16], n3(:,182), t3x16(:,:,91))
  call heltable([2,8,16], n3(:,183), t3x16(:,:,92))
  call heltable([2,8,16], n3(:,184), t3x16(:,:,93))
  call heltable([2,8,16], n3(:,185), t3x16(:,:,94))
  call heltable([2,8,16], n3(:,186), t3x16(:,:,95))
  call heltable([2,8,16], n3(:,187), t3x16(:,:,96))
  call heltable([2,8,16], n3(:,188), t3x16(:,:,97))
  call heltable([2,8,16], n3(:,189), t3x16(:,:,98))
  call heltable([2,8,16], n3(:,190), t3x16(:,:,99))
  call heltable([2,8,16], n3(:,191), t3x16(:,:,100))
  call heltable([2,8,16], n3(:,192), t3x16(:,:,101))
  call heltable([2,8,16], n3(:,193), t3x16(:,:,102))
  call heltable([2,8,16], n3(:,194), t3x16(:,:,103))
  call heltable([2,8,16], n3(:,195), t3x16(:,:,104))
  call heltable([2,8,16], n3(:,196), t3x16(:,:,105))
  call heltable([8,4,32], n3(:,197), t3x32(:,:,1))
  call heltable([4,8,32], n3(:,198), t3x32(:,:,2))
  call heltable([4,8,32], n3(:,199), t3x32(:,:,3))
  call heltable([8,4,32], n3(:,200), t3x32(:,:,4))
  call heltable([4,8,32], n3(:,201), t3x32(:,:,5))
  call heltable([4,8,32], n3(:,202), t3x32(:,:,6))
  call heltable([8,4,32], n3(:,203), t3x32(:,:,7))
  call heltable([4,8,32], n3(:,204), t3x32(:,:,8))
  call heltable([4,8,32], n3(:,205), t3x32(:,:,9))
  call heltable([8,4,32], n3(:,206), t3x32(:,:,10))
  call heltable([4,8,32], n3(:,207), t3x32(:,:,11))
  call heltable([4,8,32], n3(:,208), t3x32(:,:,12))
  call heltable([8,4,32], n3(:,209), t3x32(:,:,13))
  call heltable([4,8,32], n3(:,210), t3x32(:,:,14))
  call heltable([4,8,32], n3(:,211), t3x32(:,:,15))
  call heltable([8,4,32], n3(:,212), t3x32(:,:,16))
  call heltable([4,8,32], n3(:,213), t3x32(:,:,17))
  call heltable([4,8,32], n3(:,214), t3x32(:,:,18))
  call heltable([8,4,32], n3(:,215), t3x32(:,:,19))
  call heltable([4,8,32], n3(:,216), t3x32(:,:,20))
  call heltable([4,8,32], n3(:,217), t3x32(:,:,21))
  call heltable([8,4,32], n3(:,218), t3x32(:,:,22))
  call heltable([4,8,32], n3(:,219), t3x32(:,:,23))
  call heltable([4,8,32], n3(:,220), t3x32(:,:,24))
  call heltable([8,4,32], n3(:,221), t3x32(:,:,25))
  call heltable([4,8,32], n3(:,222), t3x32(:,:,26))
  call heltable([4,8,32], n3(:,223), t3x32(:,:,27))
  call heltable([8,4,32], n3(:,224), t3x32(:,:,28))
  call heltable([4,8,32], n3(:,225), t3x32(:,:,29))
  call heltable([4,8,32], n3(:,226), t3x32(:,:,30))
  call heltable([4,8,32], n3(:,227), t3x32(:,:,31))
  call heltable([4,8,32], n3(:,228), t3x32(:,:,32))
  call heltable([4,8,32], n3(:,229), t3x32(:,:,33))
  call heltable([4,8,32], n3(:,230), t3x32(:,:,34))
  call heltable([4,8,32], n3(:,231), t3x32(:,:,35))
  call heltable([4,8,32], n3(:,232), t3x32(:,:,36))
  call heltable([4,8,32], n3(:,233), t3x32(:,:,37))
  call heltable([4,8,32], n3(:,234), t3x32(:,:,38))
  call heltable([4,8,32], n3(:,235), t3x32(:,:,39))
  call heltable([4,8,32], n3(:,236), t3x32(:,:,40))
  call heltable([4,8,32], n3(:,237), t3x32(:,:,41))
  call heltable([4,8,32], n3(:,238), t3x32(:,:,42))
  call heltable([4,8,32], n3(:,239), t3x32(:,:,43))
  call heltable([4,8,32], n3(:,240), t3x32(:,:,44))
  call heltable([4,8,32], n3(:,241), t3x32(:,:,45))
  call heltable([4,8,32], n3(:,242), t3x32(:,:,46))
  call heltable([4,8,32], n3(:,243), t3x32(:,:,47))
  call heltable([4,8,32], n3(:,244), t3x32(:,:,48))
  call heltable([4,8,32], n3(:,245), t3x32(:,:,49))
  call heltable([4,8,32], n3(:,246), t3x32(:,:,50))
  call heltable([4,8,32], n3(:,247), t3x32(:,:,51))
  call heltable([4,8,32], n3(:,248), t3x32(:,:,52))
  call heltable([4,8,32], n3(:,249), t3x32(:,:,53))
  call heltable([4,8,32], n3(:,250), t3x32(:,:,54))
  call heltable([4,8,32], n3(:,251), t3x32(:,:,55))
  call heltable([4,8,32], n3(:,252), t3x32(:,:,56))
  call heltable([4,8,32], n3(:,253), t3x32(:,:,57))
  call heltable([4,8,32], n3(:,254), t3x32(:,:,58))
  call heltable([4,8,32], n3(:,255), t3x32(:,:,59))
  call heltable([4,8,32], n3(:,256), t3x32(:,:,60))
  call heltable([4,8,32], n3(:,257), t3x32(:,:,61))
  call heltable([4,8,32], n3(:,258), t3x32(:,:,62))
  call heltable([4,8,32], n3(:,259), t3x32(:,:,63))
  call heltable([4,8,32], n3(:,260), t3x32(:,:,64))
  call heltable([4,8,32], n3(:,261), t3x32(:,:,65))
  call heltable([4,8,32], n3(:,262), t3x32(:,:,66))
  call heltable([4,8,32], n3(:,263), t3x32(:,:,67))
  call heltable([4,8,32], n3(:,264), t3x32(:,:,68))
  call heltable([4,8,32], n3(:,265), t3x32(:,:,69))
  call heltable([4,8,32], n3(:,266), t3x32(:,:,70))
  call heltable([4,8,32], n3(:,267), t3x32(:,:,71))
  call heltable([4,8,32], n3(:,268), t3x32(:,:,72))
  call heltable([8,4,32], n3(:,269), t3x32(:,:,73))
  call heltable([8,4,32], n3(:,270), t3x32(:,:,74))
  call heltable([8,4,32], n3(:,271), t3x32(:,:,75))
  call heltable([8,4,32], n3(:,272), t3x32(:,:,76))
  call heltable([8,4,32], n3(:,273), t3x32(:,:,77))
  call heltable([8,4,32], n3(:,274), t3x32(:,:,78))
  call heltable([8,4,32], n3(:,275), t3x32(:,:,79))
  call heltable([8,4,32], n3(:,276), t3x32(:,:,80))
  call heltable([8,4,32], n3(:,277), t3x32(:,:,81))
  call heltable([8,4,32], n3(:,278), t3x32(:,:,82))
  call heltable([8,4,32], n3(:,279), t3x32(:,:,83))
  call heltable([8,4,32], n3(:,280), t3x32(:,:,84))
  call heltable([8,4,32], n3(:,281), t3x32(:,:,85))
  call heltable([8,4,32], n3(:,282), t3x32(:,:,86))
  call heltable([8,4,32], n3(:,283), t3x32(:,:,87))
  call heltable([8,4,32], n3(:,284), t3x32(:,:,88))
  call heltable([8,4,32], n3(:,285), t3x32(:,:,89))
  call heltable([8,4,32], n3(:,286), t3x32(:,:,90))
  call heltable([8,4,32], n3(:,287), t3x32(:,:,91))
  call heltable([8,4,32], n3(:,288), t3x32(:,:,92))
  call heltable([8,4,32], n3(:,289), t3x32(:,:,93))
  call heltable([8,4,32], n3(:,290), t3x32(:,:,94))
  call heltable([8,4,32], n3(:,291), t3x32(:,:,95))
  call heltable([8,4,32], n3(:,292), t3x32(:,:,96))
  call heltable([8,4,32], n3(:,293), t3x32(:,:,97))
  call heltable([8,4,32], n3(:,294), t3x32(:,:,98))
  call heltable([8,4,32], n3(:,295), t3x32(:,:,99))
  call heltable([8,4,32], n3(:,296), t3x32(:,:,100))
  call heltable([8,4,32], n3(:,297), t3x32(:,:,101))
  call heltable([8,4,32], n3(:,298), t3x32(:,:,102))
  call heltable([4,8,32], n3(:,299), t3x32(:,:,103))
  call heltable([4,8,32], n3(:,300), t3x32(:,:,104))
  call heltable([4,8,32], n3(:,301), t3x32(:,:,105))
  call heltable([4,8,32], n3(:,302), t3x32(:,:,106))
  call heltable([4,8,32], n3(:,303), t3x32(:,:,107))
  call heltable([4,8,32], n3(:,304), t3x32(:,:,108))
  call heltable([4,8,32], n3(:,305), t3x32(:,:,109))
  call heltable([4,8,32], n3(:,306), t3x32(:,:,110))
  call heltable([4,8,32], n3(:,307), t3x32(:,:,111))
  call heltable([4,8,32], n3(:,308), t3x32(:,:,112))
  call heltable([4,8,32], n3(:,309), t3x32(:,:,113))
  call heltable([4,8,32], n3(:,310), t3x32(:,:,114))
  call heltable([4,8,32], n3(:,311), t3x32(:,:,115))
  call heltable([4,8,32], n3(:,312), t3x32(:,:,116))
  call heltable([4,8,32], n3(:,313), t3x32(:,:,117))
  call heltable([4,8,32], n3(:,314), t3x32(:,:,118))
  call heltable([4,8,32], n3(:,315), t3x32(:,:,119))
  call heltable([4,8,32], n3(:,316), t3x32(:,:,120))
  call heltable([2,16,32], n3(:,317), t3x32(:,:,121))
  call heltable([2,16,32], n3(:,318), t3x32(:,:,122))
  call heltable([2,16,32], n3(:,319), t3x32(:,:,123))
  call heltable([2,16,32], n3(:,320), t3x32(:,:,124))
  call heltable([2,16,32], n3(:,321), t3x32(:,:,125))
  call heltable([2,16,32], n3(:,322), t3x32(:,:,126))
  call heltable([2,16,32], n3(:,323), t3x32(:,:,127))
  call heltable([2,16,32], n3(:,324), t3x32(:,:,128))
  call heltable([2,16,32], n3(:,325), t3x32(:,:,129))
  call heltable([8,4,32], n3(:,326), t3x32(:,:,130))
  call heltable([8,4,32], n3(:,327), t3x32(:,:,131))
  call heltable([8,4,32], n3(:,328), t3x32(:,:,132))
  call heltable([2,16,32], n3(:,329), t3x32(:,:,133))
  call heltable([2,16,32], n3(:,330), t3x32(:,:,134))
  call heltable([2,16,32], n3(:,331), t3x32(:,:,135))
  call heltable([2,16,32], n3(:,332), t3x32(:,:,136))
  call heltable([2,16,32], n3(:,333), t3x32(:,:,137))
  call heltable([2,16,32], n3(:,334), t3x32(:,:,138))
  call heltable([2,16,32], n3(:,335), t3x32(:,:,139))
  call heltable([2,16,32], n3(:,336), t3x32(:,:,140))
  call heltable([2,16,32], n3(:,337), t3x32(:,:,141))
  call heltable([8,4,32], n3(:,338), t3x32(:,:,142))
  call heltable([8,4,32], n3(:,339), t3x32(:,:,143))
  call heltable([8,4,32], n3(:,340), t3x32(:,:,144))
  call heltable([2,16,32], n3(:,341), t3x32(:,:,145))
  call heltable([2,16,32], n3(:,342), t3x32(:,:,146))
  call heltable([2,16,32], n3(:,343), t3x32(:,:,147))
  call heltable([2,16,32], n3(:,344), t3x32(:,:,148))
  call heltable([2,16,32], n3(:,345), t3x32(:,:,149))
  call heltable([2,16,32], n3(:,346), t3x32(:,:,150))
  call heltable([8,4,32], n3(:,347), t3x32(:,:,151))
  call heltable([8,4,32], n3(:,348), t3x32(:,:,152))
  call heltable([8,4,32], n3(:,349), t3x32(:,:,153))
  call heltable([2,16,32], n3(:,350), t3x32(:,:,154))
  call heltable([2,16,32], n3(:,351), t3x32(:,:,155))
  call heltable([2,16,32], n3(:,352), t3x32(:,:,156))
  call heltable([2,16,32], n3(:,353), t3x32(:,:,157))
  call heltable([2,16,32], n3(:,354), t3x32(:,:,158))
  call heltable([2,16,32], n3(:,355), t3x32(:,:,159))
  call heltable([8,4,32], n3(:,356), t3x32(:,:,160))
  call heltable([8,4,32], n3(:,357), t3x32(:,:,161))
  call heltable([8,4,32], n3(:,358), t3x32(:,:,162))
  call heltable([2,16,32], n3(:,359), t3x32(:,:,163))
  call heltable([2,16,32], n3(:,360), t3x32(:,:,164))
  call heltable([2,16,32], n3(:,361), t3x32(:,:,165))
  call heltable([8,4,32], n3(:,362), t3x32(:,:,166))
  call heltable([8,4,32], n3(:,363), t3x32(:,:,167))
  call heltable([8,4,32], n3(:,364), t3x32(:,:,168))
  call heltable([2,16,32], n3(:,365), t3x32(:,:,169))
  call heltable([2,16,32], n3(:,366), t3x32(:,:,170))
  call heltable([2,16,32], n3(:,367), t3x32(:,:,171))
  call heltable([8,4,32], n3(:,368), t3x32(:,:,172))
  call heltable([8,4,32], n3(:,369), t3x32(:,:,173))
  call heltable([8,4,32], n3(:,370), t3x32(:,:,174))
  call heltable([8,4,32], n3(:,371), t3x32(:,:,175))
  call heltable([8,4,32], n3(:,372), t3x32(:,:,176))
  call heltable([8,4,32], n3(:,373), t3x32(:,:,177))
  call heltable([8,4,32], n3(:,374), t3x32(:,:,178))
  call heltable([8,4,32], n3(:,375), t3x32(:,:,179))
  call heltable([8,4,32], n3(:,376), t3x32(:,:,180))
  call heltable([2,16,32], n3(:,377), t3x32(:,:,181))
  call heltable([2,16,32], n3(:,378), t3x32(:,:,182))
  call heltable([2,16,32], n3(:,379), t3x32(:,:,183))
  call heltable([2,16,32], n3(:,380), t3x32(:,:,184))
  call heltable([2,16,32], n3(:,381), t3x32(:,:,185))
  call heltable([2,16,32], n3(:,382), t3x32(:,:,186))
  call heltable([2,16,32], n3(:,383), t3x32(:,:,187))
  call heltable([2,16,32], n3(:,384), t3x32(:,:,188))
  call heltable([2,16,32], n3(:,385), t3x32(:,:,189))
  call heltable([8,4,32], n3(:,386), t3x32(:,:,190))
  call heltable([8,4,32], n3(:,387), t3x32(:,:,191))
  call heltable([8,4,32], n3(:,388), t3x32(:,:,192))
  call heltable([2,16,32], n3(:,389), t3x32(:,:,193))
  call heltable([2,16,32], n3(:,390), t3x32(:,:,194))
  call heltable([2,16,32], n3(:,391), t3x32(:,:,195))
  call heltable([2,16,32], n3(:,392), t3x32(:,:,196))
  call heltable([2,16,32], n3(:,393), t3x32(:,:,197))
  call heltable([2,16,32], n3(:,394), t3x32(:,:,198))
  call heltable([8,4,32], n3(:,395), t3x32(:,:,199))
  call heltable([8,4,32], n3(:,396), t3x32(:,:,200))
  call heltable([8,4,32], n3(:,397), t3x32(:,:,201))
  call heltable([2,16,32], n3(:,398), t3x32(:,:,202))
  call heltable([2,16,32], n3(:,399), t3x32(:,:,203))
  call heltable([2,16,32], n3(:,400), t3x32(:,:,204))
  call heltable([8,4,32], n3(:,401), t3x32(:,:,205))
  call heltable([8,4,32], n3(:,402), t3x32(:,:,206))
  call heltable([8,4,32], n3(:,403), t3x32(:,:,207))
  call heltable([8,4,32], n3(:,404), t3x32(:,:,208))
  call heltable([8,4,32], n3(:,405), t3x32(:,:,209))
  call heltable([8,4,32], n3(:,406), t3x32(:,:,210))
  call heltable([2,16,32], n3(:,407), t3x32(:,:,211))
  call heltable([2,16,32], n3(:,408), t3x32(:,:,212))
  call heltable([2,16,32], n3(:,409), t3x32(:,:,213))
  call heltable([2,16,32], n3(:,410), t3x32(:,:,214))
  call heltable([2,16,32], n3(:,411), t3x32(:,:,215))
  call heltable([2,16,32], n3(:,412), t3x32(:,:,216))
  call heltable([8,4,32], n3(:,413), t3x32(:,:,217))
  call heltable([8,4,32], n3(:,414), t3x32(:,:,218))
  call heltable([8,4,32], n3(:,415), t3x32(:,:,219))
  call heltable([2,16,32], n3(:,416), t3x32(:,:,220))
  call heltable([2,16,32], n3(:,417), t3x32(:,:,221))
  call heltable([2,16,32], n3(:,418), t3x32(:,:,222))
  call heltable([2,16,32], n3(:,419), t3x32(:,:,223))
  call heltable([2,16,32], n3(:,420), t3x32(:,:,224))
  call heltable([2,16,32], n3(:,421), t3x32(:,:,225))
  call heltable([8,4,32], n3(:,422), t3x32(:,:,226))
  call heltable([8,4,32], n3(:,423), t3x32(:,:,227))
  call heltable([8,4,32], n3(:,424), t3x32(:,:,228))
  call heltable([2,16,32], n3(:,425), t3x32(:,:,229))
  call heltable([2,16,32], n3(:,426), t3x32(:,:,230))
  call heltable([2,16,32], n3(:,427), t3x32(:,:,231))
  call heltable([8,4,32], n3(:,428), t3x32(:,:,232))
  call heltable([8,4,32], n3(:,429), t3x32(:,:,233))
  call heltable([8,4,32], n3(:,430), t3x32(:,:,234))
  call heltable([2,16,32], n3(:,431), t3x32(:,:,235))
  call heltable([2,16,32], n3(:,432), t3x32(:,:,236))
  call heltable([2,16,32], n3(:,433), t3x32(:,:,237))
  call heltable([8,4,32], n3(:,434), t3x32(:,:,238))
  call heltable([8,4,32], n3(:,435), t3x32(:,:,239))
  call heltable([8,4,32], n3(:,436), t3x32(:,:,240))
  call heltable([8,4,32], n3(:,437), t3x32(:,:,241))
  call heltable([8,4,32], n3(:,438), t3x32(:,:,242))
  call heltable([8,4,32], n3(:,439), t3x32(:,:,243))
  call heltable([8,4,32], n3(:,440), t3x32(:,:,244))
  call heltable([8,4,32], n3(:,441), t3x32(:,:,245))
  call heltable([8,4,32], n3(:,442), t3x32(:,:,246))
  call heltable([2,16,32], n3(:,443), t3x32(:,:,247))
  call heltable([2,16,32], n3(:,444), t3x32(:,:,248))
  call heltable([2,16,32], n3(:,445), t3x32(:,:,249))
  call heltable([2,16,32], n3(:,446), t3x32(:,:,250))
  call heltable([2,16,32], n3(:,447), t3x32(:,:,251))
  call heltable([2,16,32], n3(:,448), t3x32(:,:,252))
  call heltable([8,4,32], n3(:,449), t3x32(:,:,253))
  call heltable([8,4,32], n3(:,450), t3x32(:,:,254))
  call heltable([8,4,32], n3(:,451), t3x32(:,:,255))
  call heltable([2,16,32], n3(:,452), t3x32(:,:,256))
  call heltable([2,16,32], n3(:,453), t3x32(:,:,257))
  call heltable([2,16,32], n3(:,454), t3x32(:,:,258))
  call heltable([8,4,32], n3(:,455), t3x32(:,:,259))
  call heltable([8,4,32], n3(:,456), t3x32(:,:,260))
  call heltable([8,4,32], n3(:,457), t3x32(:,:,261))
  call heltable([8,4,32], n3(:,458), t3x32(:,:,262))
  call heltable([8,4,32], n3(:,459), t3x32(:,:,263))
  call heltable([8,4,32], n3(:,460), t3x32(:,:,264))
  call heltable([2,16,32], n3(:,461), t3x32(:,:,265))
  call heltable([2,16,32], n3(:,462), t3x32(:,:,266))
  call heltable([2,16,32], n3(:,463), t3x32(:,:,267))
  call heltable([8,4,32], n3(:,464), t3x32(:,:,268))
  call heltable([8,4,32], n3(:,465), t3x32(:,:,269))
  call heltable([8,4,32], n3(:,466), t3x32(:,:,270))
  call heltable([2,16,32], n3(:,467), t3x32(:,:,271))
  call heltable([2,16,32], n3(:,468), t3x32(:,:,272))
  call heltable([2,16,32], n3(:,469), t3x32(:,:,273))
  call heltable([8,4,32], n3(:,470), t3x32(:,:,274))
  call heltable([8,4,32], n3(:,471), t3x32(:,:,275))
  call heltable([8,4,32], n3(:,472), t3x32(:,:,276))
  call heltable([8,4,32], n3(:,473), t3x32(:,:,277))
  call heltable([8,4,32], n3(:,474), t3x32(:,:,278))
  call heltable([8,4,32], n3(:,475), t3x32(:,:,279))
  call heltable([8,4,32], n3(:,476), t3x32(:,:,280))
  call heltable([8,4,32], n3(:,477), t3x32(:,:,281))
  call heltable([8,4,32], n3(:,478), t3x32(:,:,282))
  call heltable([2,16,32], n3(:,479), t3x32(:,:,283))
  call heltable([2,16,32], n3(:,480), t3x32(:,:,284))
  call heltable([2,16,32], n3(:,481), t3x32(:,:,285))
  call heltable([8,4,32], n3(:,482), t3x32(:,:,286))
  call heltable([8,4,32], n3(:,483), t3x32(:,:,287))
  call heltable([8,4,32], n3(:,484), t3x32(:,:,288))
  call heltable([8,4,32], n3(:,485), t3x32(:,:,289))
  call heltable([8,4,32], n3(:,486), t3x32(:,:,290))
  call heltable([8,4,32], n3(:,487), t3x32(:,:,291))
  call heltable([8,4,32], n3(:,488), t3x32(:,:,292))
  call heltable([8,4,32], n3(:,489), t3x32(:,:,293))
  call heltable([8,4,32], n3(:,490), t3x32(:,:,294))
  call heltable([8,4,32], n3(:,491), t3x32(:,:,295))
  call heltable([8,4,32], n3(:,492), t3x32(:,:,296))
  call heltable([8,4,32], n3(:,493), t3x32(:,:,297))
  call heltable([8,4,32], n3(:,494), t3x32(:,:,298))
  call heltable([8,4,32], n3(:,495), t3x32(:,:,299))
  call heltable([8,4,32], n3(:,496), t3x32(:,:,300))
  call heltable([4,8,32], n3(:,497), t3x32(:,:,301))
  call heltable([4,8,32], n3(:,498), t3x32(:,:,302))
  call heltable([4,8,32], n3(:,499), t3x32(:,:,303))
  call heltable([4,8,32], n3(:,500), t3x32(:,:,304))
  call heltable([4,8,32], n3(:,501), t3x32(:,:,305))
  call heltable([4,8,32], n3(:,502), t3x32(:,:,306))
  call heltable([4,8,32], n3(:,503), t3x32(:,:,307))
  call heltable([4,8,32], n3(:,504), t3x32(:,:,308))
  call heltable([4,8,32], n3(:,505), t3x32(:,:,309))
  call heltable([4,8,32], n3(:,506), t3x32(:,:,310))
  call heltable([4,8,32], n3(:,507), t3x32(:,:,311))
  call heltable([4,8,32], n3(:,508), t3x32(:,:,312))
  call heltable([4,8,32], n3(:,509), t3x32(:,:,313))
  call heltable([4,8,32], n3(:,510), t3x32(:,:,314))
  call heltable([4,8,32], n3(:,511), t3x32(:,:,315))
  call heltable([4,8,32], n3(:,512), t3x32(:,:,316))
  call heltable([4,8,32], n3(:,513), t3x32(:,:,317))
  call heltable([4,8,32], n3(:,514), t3x32(:,:,318))
  call heltable([4,8,32], n3(:,515), t3x32(:,:,319))
  call heltable([4,8,32], n3(:,516), t3x32(:,:,320))
  call heltable([4,8,32], n3(:,517), t3x32(:,:,321))
  call heltable([4,8,32], n3(:,518), t3x32(:,:,322))
  call heltable([4,8,32], n3(:,519), t3x32(:,:,323))
  call heltable([4,8,32], n3(:,520), t3x32(:,:,324))
  call heltable([4,8,32], n3(:,521), t3x32(:,:,325))
  call heltable([4,8,32], n3(:,522), t3x32(:,:,326))
  call heltable([4,8,32], n3(:,523), t3x32(:,:,327))
  call heltable([4,8,32], n3(:,524), t3x32(:,:,328))
  call heltable([4,8,32], n3(:,525), t3x32(:,:,329))
  call heltable([4,8,32], n3(:,526), t3x32(:,:,330))
  call heltable([4,8,32], n3(:,527), t3x32(:,:,331))
  call heltable([4,8,32], n3(:,528), t3x32(:,:,332))
  call heltable([4,8,32], n3(:,529), t3x32(:,:,333))
  call heltable([4,8,32], n3(:,530), t3x32(:,:,334))
  call heltable([4,8,32], n3(:,531), t3x32(:,:,335))
  call heltable([4,8,32], n3(:,532), t3x32(:,:,336))
  call heltable([4,8,32], n3(:,533), t3x32(:,:,337))
  call heltable([4,8,32], n3(:,534), t3x32(:,:,338))
  call heltable([4,8,32], n3(:,535), t3x32(:,:,339))
  call heltable([4,8,32], n3(:,536), t3x32(:,:,340))
  call heltable([4,8,32], n3(:,537), t3x32(:,:,341))
  call heltable([4,8,32], n3(:,538), t3x32(:,:,342))
  call heltable([4,8,32], n3(:,539), t3x32(:,:,343))
  call heltable([4,8,32], n3(:,540), t3x32(:,:,344))
  call heltable([4,8,32], n3(:,541), t3x32(:,:,345))
  call heltable([4,8,32], n3(:,542), t3x32(:,:,346))
  call heltable([4,8,32], n3(:,543), t3x32(:,:,347))
  call heltable([16,2,32], n3(:,544), t3x32(:,:,348))
  call heltable([16,2,32], n3(:,545), t3x32(:,:,349))
  call heltable([16,2,32], n3(:,546), t3x32(:,:,350))
  call heltable([4,8,32], n3(:,547), t3x32(:,:,351))
  call heltable([4,8,32], n3(:,548), t3x32(:,:,352))
  call heltable([16,2,32], n3(:,549), t3x32(:,:,353))
  call heltable([16,2,32], n3(:,550), t3x32(:,:,354))
  call heltable([16,2,32], n3(:,551), t3x32(:,:,355))
  call heltable([4,8,32], n3(:,552), t3x32(:,:,356))
  call heltable([16,2,32], n3(:,553), t3x32(:,:,357))
  call heltable([16,2,32], n3(:,554), t3x32(:,:,358))
  call heltable([16,2,32], n3(:,555), t3x32(:,:,359))
  call heltable([4,8,32], n3(:,556), t3x32(:,:,360))
  call heltable([8,4,32], n3(:,557), t3x32(:,:,361))
  call heltable([8,4,32], n3(:,558), t3x32(:,:,362))
  call heltable([8,4,32], n3(:,559), t3x32(:,:,363))
  call heltable([4,8,32], n3(:,560), t3x32(:,:,364))
  call heltable([4,8,32], n3(:,561), t3x32(:,:,365))
  call heltable([16,2,32], n3(:,562), t3x32(:,:,366))
  call heltable([16,2,32], n3(:,563), t3x32(:,:,367))
  call heltable([16,2,32], n3(:,564), t3x32(:,:,368))
  call heltable([4,8,32], n3(:,565), t3x32(:,:,369))
  call heltable([4,8,32], n3(:,566), t3x32(:,:,370))
  call heltable([4,8,32], n3(:,567), t3x32(:,:,371))
  call heltable([16,2,32], n3(:,568), t3x32(:,:,372))
  call heltable([16,2,32], n3(:,569), t3x32(:,:,373))
  call heltable([16,2,32], n3(:,570), t3x32(:,:,374))
  call heltable([4,8,32], n3(:,571), t3x32(:,:,375))
  call heltable([4,8,32], n3(:,572), t3x32(:,:,376))
  call heltable([16,2,32], n3(:,573), t3x32(:,:,377))
  call heltable([16,2,32], n3(:,574), t3x32(:,:,378))
  call heltable([16,2,32], n3(:,575), t3x32(:,:,379))
  call heltable([4,8,32], n3(:,576), t3x32(:,:,380))
  call heltable([4,8,32], n3(:,577), t3x32(:,:,381))
  call heltable([16,2,32], n3(:,578), t3x32(:,:,382))
  call heltable([16,2,32], n3(:,579), t3x32(:,:,383))
  call heltable([16,2,32], n3(:,580), t3x32(:,:,384))
  call heltable([4,8,32], n3(:,581), t3x32(:,:,385))
  call heltable([16,2,32], n3(:,582), t3x32(:,:,386))
  call heltable([16,2,32], n3(:,583), t3x32(:,:,387))
  call heltable([16,2,32], n3(:,584), t3x32(:,:,388))
  call heltable([4,8,32], n3(:,585), t3x32(:,:,389))
  call heltable([16,2,32], n3(:,586), t3x32(:,:,390))
  call heltable([16,2,32], n3(:,587), t3x32(:,:,391))
  call heltable([16,2,32], n3(:,588), t3x32(:,:,392))
  call heltable([4,8,32], n3(:,589), t3x32(:,:,393))
  call heltable([2,16,32], n3(:,590), t3x32(:,:,394))
  call heltable([2,16,32], n3(:,591), t3x32(:,:,395))
  call heltable([2,16,32], n3(:,592), t3x32(:,:,396))
  call heltable([2,16,32], n3(:,593), t3x32(:,:,397))
  call heltable([2,16,32], n3(:,594), t3x32(:,:,398))
  call heltable([2,16,32], n3(:,595), t3x32(:,:,399))
  call heltable([4,8,32], n3(:,596), t3x32(:,:,400))
  call heltable([16,2,32], n3(:,597), t3x32(:,:,401))
  call heltable([16,2,32], n3(:,598), t3x32(:,:,402))
  call heltable([16,2,32], n3(:,599), t3x32(:,:,403))
  call heltable([4,8,32], n3(:,600), t3x32(:,:,404))
  call heltable([16,2,32], n3(:,601), t3x32(:,:,405))
  call heltable([16,2,32], n3(:,602), t3x32(:,:,406))
  call heltable([16,2,32], n3(:,603), t3x32(:,:,407))
  call heltable([4,8,32], n3(:,604), t3x32(:,:,408))
  call heltable([8,4,32], n3(:,605), t3x32(:,:,409))
  call heltable([8,4,32], n3(:,606), t3x32(:,:,410))
  call heltable([8,4,32], n3(:,607), t3x32(:,:,411))
  call heltable([4,8,32], n3(:,608), t3x32(:,:,412))
  call heltable([16,2,32], n3(:,609), t3x32(:,:,413))
  call heltable([16,2,32], n3(:,610), t3x32(:,:,414))
  call heltable([16,2,32], n3(:,611), t3x32(:,:,415))
  call heltable([4,8,32], n3(:,612), t3x32(:,:,416))
  call heltable([4,8,32], n3(:,613), t3x32(:,:,417))
  call heltable([16,2,32], n3(:,614), t3x32(:,:,418))
  call heltable([16,2,32], n3(:,615), t3x32(:,:,419))
  call heltable([16,2,32], n3(:,616), t3x32(:,:,420))
  call heltable([4,8,32], n3(:,617), t3x32(:,:,421))
  call heltable([16,2,32], n3(:,618), t3x32(:,:,422))
  call heltable([16,2,32], n3(:,619), t3x32(:,:,423))
  call heltable([16,2,32], n3(:,620), t3x32(:,:,424))
  call heltable([4,8,32], n3(:,621), t3x32(:,:,425))
  call heltable([16,2,32], n3(:,622), t3x32(:,:,426))
  call heltable([16,2,32], n3(:,623), t3x32(:,:,427))
  call heltable([16,2,32], n3(:,624), t3x32(:,:,428))
  call heltable([4,8,32], n3(:,625), t3x32(:,:,429))
  call heltable([2,16,32], n3(:,626), t3x32(:,:,430))
  call heltable([2,16,32], n3(:,627), t3x32(:,:,431))
  call heltable([2,16,32], n3(:,628), t3x32(:,:,432))
  call heltable([2,16,32], n3(:,629), t3x32(:,:,433))
  call heltable([2,16,32], n3(:,630), t3x32(:,:,434))
  call heltable([2,16,32], n3(:,631), t3x32(:,:,435))
  call heltable([16,2,32], n3(:,632), t3x32(:,:,436))
  call heltable([16,2,32], n3(:,633), t3x32(:,:,437))
  call heltable([16,2,32], n3(:,634), t3x32(:,:,438))
  call heltable([4,8,32], n3(:,635), t3x32(:,:,439))
  call heltable([8,4,32], n3(:,636), t3x32(:,:,440))
  call heltable([8,4,32], n3(:,637), t3x32(:,:,441))
  call heltable([8,4,32], n3(:,638), t3x32(:,:,442))
  call heltable([16,2,32], n3(:,639), t3x32(:,:,443))
  call heltable([16,2,32], n3(:,640), t3x32(:,:,444))
  call heltable([16,2,32], n3(:,641), t3x32(:,:,445))
  call heltable([4,8,32], n3(:,642), t3x32(:,:,446))
  call heltable([16,2,32], n3(:,643), t3x32(:,:,447))
  call heltable([16,2,32], n3(:,644), t3x32(:,:,448))
  call heltable([16,2,32], n3(:,645), t3x32(:,:,449))
  call heltable([4,8,32], n3(:,646), t3x32(:,:,450))
  call heltable([2,16,32], n3(:,647), t3x32(:,:,451))
  call heltable([2,16,32], n3(:,648), t3x32(:,:,452))
  call heltable([2,16,32], n3(:,649), t3x32(:,:,453))
  call heltable([2,16,32], n3(:,650), t3x32(:,:,454))
  call heltable([2,16,32], n3(:,651), t3x32(:,:,455))
  call heltable([2,16,32], n3(:,652), t3x32(:,:,456))
  call heltable([8,4,32], n3(:,653), t3x32(:,:,457))
  call heltable([8,4,32], n3(:,654), t3x32(:,:,458))
  call heltable([8,4,32], n3(:,655), t3x32(:,:,459))
  call heltable([2,16,32], n3(:,656), t3x32(:,:,460))
  call heltable([2,16,32], n3(:,657), t3x32(:,:,461))
  call heltable([2,16,32], n3(:,658), t3x32(:,:,462))
  call heltable([2,16,32], n3(:,659), t3x32(:,:,463))
  call heltable([2,16,32], n3(:,660), t3x32(:,:,464))
  call heltable([2,16,32], n3(:,661), t3x32(:,:,465))
  call heltable([4,8,32], n3(:,662), t3x32(:,:,466))
  call heltable([16,2,32], n3(:,663), t3x32(:,:,467))
  call heltable([16,2,32], n3(:,664), t3x32(:,:,468))
  call heltable([16,2,32], n3(:,665), t3x32(:,:,469))
  call heltable([4,8,32], n3(:,666), t3x32(:,:,470))
  call heltable([16,2,32], n3(:,667), t3x32(:,:,471))
  call heltable([16,2,32], n3(:,668), t3x32(:,:,472))
  call heltable([16,2,32], n3(:,669), t3x32(:,:,473))
  call heltable([4,8,32], n3(:,670), t3x32(:,:,474))
  call heltable([8,4,32], n3(:,671), t3x32(:,:,475))
  call heltable([8,4,32], n3(:,672), t3x32(:,:,476))
  call heltable([8,4,32], n3(:,673), t3x32(:,:,477))
  call heltable([4,8,32], n3(:,674), t3x32(:,:,478))
  call heltable([16,2,32], n3(:,675), t3x32(:,:,479))
  call heltable([16,2,32], n3(:,676), t3x32(:,:,480))
  call heltable([16,2,32], n3(:,677), t3x32(:,:,481))
  call heltable([4,8,32], n3(:,678), t3x32(:,:,482))
  call heltable([4,8,32], n3(:,679), t3x32(:,:,483))
  call heltable([16,2,32], n3(:,680), t3x32(:,:,484))
  call heltable([16,2,32], n3(:,681), t3x32(:,:,485))
  call heltable([16,2,32], n3(:,682), t3x32(:,:,486))
  call heltable([4,8,32], n3(:,683), t3x32(:,:,487))
  call heltable([16,2,32], n3(:,684), t3x32(:,:,488))
  call heltable([16,2,32], n3(:,685), t3x32(:,:,489))
  call heltable([16,2,32], n3(:,686), t3x32(:,:,490))
  call heltable([4,8,32], n3(:,687), t3x32(:,:,491))
  call heltable([16,2,32], n3(:,688), t3x32(:,:,492))
  call heltable([16,2,32], n3(:,689), t3x32(:,:,493))
  call heltable([16,2,32], n3(:,690), t3x32(:,:,494))
  call heltable([4,8,32], n3(:,691), t3x32(:,:,495))
  call heltable([2,16,32], n3(:,692), t3x32(:,:,496))
  call heltable([2,16,32], n3(:,693), t3x32(:,:,497))
  call heltable([2,16,32], n3(:,694), t3x32(:,:,498))
  call heltable([2,16,32], n3(:,695), t3x32(:,:,499))
  call heltable([2,16,32], n3(:,696), t3x32(:,:,500))
  call heltable([2,16,32], n3(:,697), t3x32(:,:,501))
  call heltable([16,2,32], n3(:,698), t3x32(:,:,502))
  call heltable([16,2,32], n3(:,699), t3x32(:,:,503))
  call heltable([16,2,32], n3(:,700), t3x32(:,:,504))
  call heltable([4,8,32], n3(:,701), t3x32(:,:,505))
  call heltable([8,4,32], n3(:,702), t3x32(:,:,506))
  call heltable([8,4,32], n3(:,703), t3x32(:,:,507))
  call heltable([8,4,32], n3(:,704), t3x32(:,:,508))
  call heltable([16,2,32], n3(:,705), t3x32(:,:,509))
  call heltable([16,2,32], n3(:,706), t3x32(:,:,510))
  call heltable([16,2,32], n3(:,707), t3x32(:,:,511))
  call heltable([4,8,32], n3(:,708), t3x32(:,:,512))
  call heltable([16,2,32], n3(:,709), t3x32(:,:,513))
  call heltable([16,2,32], n3(:,710), t3x32(:,:,514))
  call heltable([16,2,32], n3(:,711), t3x32(:,:,515))
  call heltable([4,8,32], n3(:,712), t3x32(:,:,516))
  call heltable([2,16,32], n3(:,713), t3x32(:,:,517))
  call heltable([2,16,32], n3(:,714), t3x32(:,:,518))
  call heltable([2,16,32], n3(:,715), t3x32(:,:,519))
  call heltable([2,16,32], n3(:,716), t3x32(:,:,520))
  call heltable([2,16,32], n3(:,717), t3x32(:,:,521))
  call heltable([2,16,32], n3(:,718), t3x32(:,:,522))
  call heltable([8,4,32], n3(:,719), t3x32(:,:,523))
  call heltable([8,4,32], n3(:,720), t3x32(:,:,524))
  call heltable([8,4,32], n3(:,721), t3x32(:,:,525))
  call heltable([2,16,32], n3(:,722), t3x32(:,:,526))
  call heltable([2,16,32], n3(:,723), t3x32(:,:,527))
  call heltable([2,16,32], n3(:,724), t3x32(:,:,528))
  call heltable([2,16,32], n3(:,725), t3x32(:,:,529))
  call heltable([2,16,32], n3(:,726), t3x32(:,:,530))
  call heltable([2,16,32], n3(:,727), t3x32(:,:,531))
  call heltable([16,2,32], n3(:,728), t3x32(:,:,532))
  call heltable([16,2,32], n3(:,729), t3x32(:,:,533))
  call heltable([16,2,32], n3(:,730), t3x32(:,:,534))
  call heltable([4,8,32], n3(:,731), t3x32(:,:,535))
  call heltable([8,4,32], n3(:,732), t3x32(:,:,536))
  call heltable([8,4,32], n3(:,733), t3x32(:,:,537))
  call heltable([8,4,32], n3(:,734), t3x32(:,:,538))
  call heltable([16,2,32], n3(:,735), t3x32(:,:,539))
  call heltable([16,2,32], n3(:,736), t3x32(:,:,540))
  call heltable([16,2,32], n3(:,737), t3x32(:,:,541))
  call heltable([4,8,32], n3(:,738), t3x32(:,:,542))
  call heltable([16,2,32], n3(:,739), t3x32(:,:,543))
  call heltable([16,2,32], n3(:,740), t3x32(:,:,544))
  call heltable([16,2,32], n3(:,741), t3x32(:,:,545))
  call heltable([4,8,32], n3(:,742), t3x32(:,:,546))
  call heltable([2,16,32], n3(:,743), t3x32(:,:,547))
  call heltable([2,16,32], n3(:,744), t3x32(:,:,548))
  call heltable([2,16,32], n3(:,745), t3x32(:,:,549))
  call heltable([2,16,32], n3(:,746), t3x32(:,:,550))
  call heltable([2,16,32], n3(:,747), t3x32(:,:,551))
  call heltable([2,16,32], n3(:,748), t3x32(:,:,552))
  call heltable([8,4,32], n3(:,749), t3x32(:,:,553))
  call heltable([8,4,32], n3(:,750), t3x32(:,:,554))
  call heltable([8,4,32], n3(:,751), t3x32(:,:,555))
  call heltable([2,16,32], n3(:,752), t3x32(:,:,556))
  call heltable([2,16,32], n3(:,753), t3x32(:,:,557))
  call heltable([2,16,32], n3(:,754), t3x32(:,:,558))
  call heltable([2,16,32], n3(:,755), t3x32(:,:,559))
  call heltable([2,16,32], n3(:,756), t3x32(:,:,560))
  call heltable([2,16,32], n3(:,757), t3x32(:,:,561))
  call heltable([8,4,32], n3(:,758), t3x32(:,:,562))
  call heltable([8,4,32], n3(:,759), t3x32(:,:,563))
  call heltable([8,4,32], n3(:,760), t3x32(:,:,564))
  call heltable([2,16,32], n3(:,761), t3x32(:,:,565))
  call heltable([2,16,32], n3(:,762), t3x32(:,:,566))
  call heltable([2,16,32], n3(:,763), t3x32(:,:,567))
  call heltable([2,16,32], n3(:,764), t3x32(:,:,568))
  call heltable([2,16,32], n3(:,765), t3x32(:,:,569))
  call heltable([2,16,32], n3(:,766), t3x32(:,:,570))
  call heltable([4,8,32], n3(:,767), t3x32(:,:,571))
  call heltable([4,8,32], n3(:,768), t3x32(:,:,572))
  call heltable([2,16,32], n3(:,769), t3x32(:,:,573))
  call heltable([4,8,32], n3(:,770), t3x32(:,:,574))
  call heltable([4,8,32], n3(:,771), t3x32(:,:,575))
  call heltable([4,8,32], n3(:,772), t3x32(:,:,576))
  call heltable([4,8,32], n3(:,773), t3x32(:,:,577))
  call heltable([4,8,32], n3(:,774), t3x32(:,:,578))
  call heltable([4,8,32], n3(:,775), t3x32(:,:,579))
  call heltable([2,16,32], n3(:,776), t3x32(:,:,580))
  call heltable([4,8,32], n3(:,777), t3x32(:,:,581))
  call heltable([4,8,32], n3(:,778), t3x32(:,:,582))
  call heltable([2,16,32], n3(:,779), t3x32(:,:,583))
  call heltable([4,8,32], n3(:,780), t3x32(:,:,584))
  call heltable([4,8,32], n3(:,781), t3x32(:,:,585))
  call heltable([4,8,32], n3(:,782), t3x32(:,:,586))
  call heltable([4,8,32], n3(:,783), t3x32(:,:,587))
  call heltable([2,16,32], n3(:,784), t3x32(:,:,588))
  call heltable([4,8,32], n3(:,785), t3x32(:,:,589))
  call heltable([4,8,32], n3(:,786), t3x32(:,:,590))
  call heltable([4,8,32], n3(:,787), t3x32(:,:,591))
  call heltable([4,8,32], n3(:,788), t3x32(:,:,592))
  call heltable([4,8,32], n3(:,789), t3x32(:,:,593))
  call heltable([4,8,32], n3(:,790), t3x32(:,:,594))
  call heltable([2,16,32], n3(:,791), t3x32(:,:,595))
  call heltable([4,8,32], n3(:,792), t3x32(:,:,596))
  call heltable([4,8,32], n3(:,793), t3x32(:,:,597))
  call heltable([4,8,32], n3(:,794), t3x32(:,:,598))
  call heltable([4,8,32], n3(:,795), t3x32(:,:,599))
  call heltable([2,16,32], n3(:,796), t3x32(:,:,600))
  call heltable([4,8,32], n3(:,797), t3x32(:,:,601))
  call heltable([4,8,32], n3(:,798), t3x32(:,:,602))
  call heltable([4,8,32], n3(:,799), t3x32(:,:,603))
  call heltable([4,8,32], n3(:,800), t3x32(:,:,604))
  call heltable([4,8,32], n3(:,801), t3x32(:,:,605))
  call heltable([4,8,32], n3(:,802), t3x32(:,:,606))
  call heltable([2,16,32], n3(:,803), t3x32(:,:,607))
  call heltable([4,8,32], n3(:,804), t3x32(:,:,608))
  call heltable([4,8,32], n3(:,805), t3x32(:,:,609))
  call heltable([4,8,32], n3(:,806), t3x32(:,:,610))
  call heltable([4,8,32], n3(:,807), t3x32(:,:,611))
  call heltable([4,8,32], n3(:,808), t3x32(:,:,612))
  call heltable([4,8,32], n3(:,809), t3x32(:,:,613))
  call heltable([4,8,32], n3(:,810), t3x32(:,:,614))
  call heltable([4,8,32], n3(:,811), t3x32(:,:,615))
  call heltable([4,8,32], n3(:,812), t3x32(:,:,616))
  call heltable([4,8,32], n3(:,813), t3x32(:,:,617))
  call heltable([4,8,32], n3(:,814), t3x32(:,:,618))
  call heltable([4,8,32], n3(:,815), t3x32(:,:,619))
  call heltable([4,8,32], n3(:,816), t3x32(:,:,620))
  call heltable([4,8,32], n3(:,817), t3x32(:,:,621))
  call heltable([4,8,32], n3(:,818), t3x32(:,:,622))
  call heltable([4,8,32], n3(:,819), t3x32(:,:,623))
  call heltable([4,8,32], n3(:,820), t3x32(:,:,624))
  call heltable([4,8,32], n3(:,821), t3x32(:,:,625))
  call heltable([4,8,32], n3(:,822), t3x32(:,:,626))
  call heltable([4,8,32], n3(:,823), t3x32(:,:,627))
  call heltable([4,8,32], n3(:,824), t3x32(:,:,628))
  call heltable([4,8,32], n3(:,825), t3x32(:,:,629))
  call heltable([4,8,32], n3(:,826), t3x32(:,:,630))
  call heltable([4,8,32], n3(:,827), t3x32(:,:,631))
  call heltable([4,8,32], n3(:,828), t3x32(:,:,632))
  call heltable([4,8,32], n3(:,829), t3x32(:,:,633))
  call heltable([2,16,32], n3(:,830), t3x32(:,:,634))
  call heltable([4,8,32], n3(:,831), t3x32(:,:,635))
  call heltable([4,8,32], n3(:,832), t3x32(:,:,636))
  call heltable([2,16,32], n3(:,833), t3x32(:,:,637))
  call heltable([4,8,32], n3(:,834), t3x32(:,:,638))
  call heltable([4,8,32], n3(:,835), t3x32(:,:,639))
  call heltable([4,8,32], n3(:,836), t3x32(:,:,640))
  call heltable([4,8,32], n3(:,837), t3x32(:,:,641))
  call heltable([4,8,32], n3(:,838), t3x32(:,:,642))
  call heltable([4,8,32], n3(:,839), t3x32(:,:,643))
  call heltable([4,8,32], n3(:,840), t3x32(:,:,644))
  call heltable([4,8,32], n3(:,841), t3x32(:,:,645))
  call heltable([2,16,32], n3(:,842), t3x32(:,:,646))
  call heltable([4,8,32], n3(:,843), t3x32(:,:,647))
  call heltable([4,8,32], n3(:,844), t3x32(:,:,648))
  call heltable([2,16,32], n3(:,845), t3x32(:,:,649))
  call heltable([4,8,32], n3(:,846), t3x32(:,:,650))
  call heltable([4,8,32], n3(:,847), t3x32(:,:,651))
  call heltable([2,16,32], n3(:,848), t3x32(:,:,652))
  call heltable([4,8,32], n3(:,849), t3x32(:,:,653))
  call heltable([4,8,32], n3(:,850), t3x32(:,:,654))
  call heltable([4,8,32], n3(:,851), t3x32(:,:,655))
  call heltable([4,8,32], n3(:,852), t3x32(:,:,656))
  call heltable([4,8,32], n3(:,853), t3x32(:,:,657))
  call heltable([4,8,32], n3(:,854), t3x32(:,:,658))
  call heltable([4,8,32], n3(:,855), t3x32(:,:,659))
  call heltable([4,8,32], n3(:,856), t3x32(:,:,660))
  call heltable([2,16,32], n3(:,857), t3x32(:,:,661))
  call heltable([4,8,32], n3(:,858), t3x32(:,:,662))
  call heltable([4,8,32], n3(:,859), t3x32(:,:,663))
  call heltable([2,16,32], n3(:,860), t3x32(:,:,664))
  call heltable([4,8,32], n3(:,861), t3x32(:,:,665))
  call heltable([4,8,32], n3(:,862), t3x32(:,:,666))
  call heltable([2,16,32], n3(:,863), t3x32(:,:,667))
  call heltable([4,8,32], n3(:,864), t3x32(:,:,668))
  call heltable([4,8,32], n3(:,865), t3x32(:,:,669))
  call heltable([4,8,32], n3(:,866), t3x32(:,:,670))
  call heltable([4,8,32], n3(:,867), t3x32(:,:,671))
  call heltable([4,8,32], n3(:,868), t3x32(:,:,672))
  call heltable([4,8,32], n3(:,869), t3x32(:,:,673))
  call heltable([4,8,32], n3(:,870), t3x32(:,:,674))
  call heltable([4,8,32], n3(:,871), t3x32(:,:,675))
  call heltable([2,16,32], n3(:,872), t3x32(:,:,676))
  call heltable([8,4,32], n3(:,873), t3x32(:,:,677))
  call heltable([8,4,32], n3(:,874), t3x32(:,:,678))
  call heltable([2,16,32], n3(:,875), t3x32(:,:,679))
  call heltable([8,4,32], n3(:,876), t3x32(:,:,680))
  call heltable([8,4,32], n3(:,877), t3x32(:,:,681))
  call heltable([2,16,32], n3(:,878), t3x32(:,:,682))
  call heltable([8,4,32], n3(:,879), t3x32(:,:,683))
  call heltable([8,4,32], n3(:,880), t3x32(:,:,684))
  call heltable([8,4,32], n3(:,881), t3x32(:,:,685))
  call heltable([8,4,32], n3(:,882), t3x32(:,:,686))
  call heltable([2,16,32], n3(:,883), t3x32(:,:,687))
  call heltable([8,4,32], n3(:,884), t3x32(:,:,688))
  call heltable([2,16,32], n3(:,885), t3x32(:,:,689))
  call heltable([2,16,32], n3(:,886), t3x32(:,:,690))
  call heltable([2,16,32], n3(:,887), t3x32(:,:,691))
  call heltable([8,4,32], n3(:,888), t3x32(:,:,692))
  call heltable([8,4,32], n3(:,889), t3x32(:,:,693))
  call heltable([2,16,32], n3(:,890), t3x32(:,:,694))
  call heltable([8,4,32], n3(:,891), t3x32(:,:,695))
  call heltable([8,4,32], n3(:,892), t3x32(:,:,696))
  call heltable([2,16,32], n3(:,893), t3x32(:,:,697))
  call heltable([8,4,32], n3(:,894), t3x32(:,:,698))
  call heltable([8,4,32], n3(:,895), t3x32(:,:,699))
  call heltable([8,4,32], n3(:,896), t3x32(:,:,700))
  call heltable([8,4,32], n3(:,897), t3x32(:,:,701))
  call heltable([2,16,32], n3(:,898), t3x32(:,:,702))
  call heltable([8,4,32], n3(:,899), t3x32(:,:,703))
  call heltable([2,16,32], n3(:,900), t3x32(:,:,704))
  call heltable([2,16,32], n3(:,901), t3x32(:,:,705))
  call heltable([2,16,32], n3(:,902), t3x32(:,:,706))
  call heltable([8,4,32], n3(:,903), t3x32(:,:,707))
  call heltable([8,4,32], n3(:,904), t3x32(:,:,708))
  call heltable([2,16,32], n3(:,905), t3x32(:,:,709))
  call heltable([8,4,32], n3(:,906), t3x32(:,:,710))
  call heltable([8,4,32], n3(:,907), t3x32(:,:,711))
  call heltable([2,16,32], n3(:,908), t3x32(:,:,712))
  call heltable([8,4,32], n3(:,909), t3x32(:,:,713))
  call heltable([8,4,32], n3(:,910), t3x32(:,:,714))
  call heltable([8,4,32], n3(:,911), t3x32(:,:,715))
  call heltable([8,4,32], n3(:,912), t3x32(:,:,716))
  call heltable([2,16,32], n3(:,913), t3x32(:,:,717))
  call heltable([8,4,32], n3(:,914), t3x32(:,:,718))
  call heltable([2,16,32], n3(:,915), t3x32(:,:,719))
  call heltable([2,16,32], n3(:,916), t3x32(:,:,720))
  call heltable([2,16,32], n3(:,917), t3x32(:,:,721))
  call heltable([8,4,32], n3(:,918), t3x32(:,:,722))
  call heltable([8,4,32], n3(:,919), t3x32(:,:,723))
  call heltable([2,16,32], n3(:,920), t3x32(:,:,724))
  call heltable([8,4,32], n3(:,921), t3x32(:,:,725))
  call heltable([8,4,32], n3(:,922), t3x32(:,:,726))
  call heltable([8,4,32], n3(:,923), t3x32(:,:,727))
  call heltable([8,4,32], n3(:,924), t3x32(:,:,728))
  call heltable([2,16,32], n3(:,925), t3x32(:,:,729))
  call heltable([8,4,32], n3(:,926), t3x32(:,:,730))
  call heltable([2,16,32], n3(:,927), t3x32(:,:,731))
  call heltable([2,16,32], n3(:,928), t3x32(:,:,732))
  call heltable([2,16,32], n3(:,929), t3x32(:,:,733))
  call heltable([8,4,32], n3(:,930), t3x32(:,:,734))
  call heltable([8,4,32], n3(:,931), t3x32(:,:,735))
  call heltable([2,16,32], n3(:,932), t3x32(:,:,736))
  call heltable([8,4,32], n3(:,933), t3x32(:,:,737))
  call heltable([8,4,32], n3(:,934), t3x32(:,:,738))
  call heltable([8,4,32], n3(:,935), t3x32(:,:,739))
  call heltable([8,4,32], n3(:,936), t3x32(:,:,740))
  call heltable([2,16,32], n3(:,937), t3x32(:,:,741))
  call heltable([8,4,32], n3(:,938), t3x32(:,:,742))
  call heltable([2,16,32], n3(:,939), t3x32(:,:,743))
  call heltable([2,16,32], n3(:,940), t3x32(:,:,744))
  call heltable([2,16,32], n3(:,941), t3x32(:,:,745))
  call heltable([8,4,32], n3(:,942), t3x32(:,:,746))
  call heltable([8,4,32], n3(:,943), t3x32(:,:,747))
  call heltable([2,16,32], n3(:,944), t3x32(:,:,748))
  call heltable([8,4,32], n3(:,945), t3x32(:,:,749))
  call heltable([8,4,32], n3(:,946), t3x32(:,:,750))
  call heltable([8,4,32], n3(:,947), t3x32(:,:,751))
  call heltable([8,4,32], n3(:,948), t3x32(:,:,752))
  call heltable([8,4,32], n3(:,949), t3x32(:,:,753))
  call heltable([2,16,32], n3(:,950), t3x32(:,:,754))
  call heltable([2,16,32], n3(:,951), t3x32(:,:,755))
  call heltable([2,16,32], n3(:,952), t3x32(:,:,756))
  call heltable([8,4,32], n3(:,953), t3x32(:,:,757))
  call heltable([8,4,32], n3(:,954), t3x32(:,:,758))
  call heltable([2,16,32], n3(:,955), t3x32(:,:,759))
  call heltable([8,4,32], n3(:,956), t3x32(:,:,760))
  call heltable([2,16,32], n3(:,957), t3x32(:,:,761))
  call heltable([2,16,32], n3(:,958), t3x32(:,:,762))
  call heltable([8,4,32], n3(:,959), t3x32(:,:,763))
  call heltable([8,4,32], n3(:,960), t3x32(:,:,764))
  call heltable([2,16,32], n3(:,961), t3x32(:,:,765))
  call heltable([8,4,32], n3(:,962), t3x32(:,:,766))
  call heltable([2,16,32], n3(:,963), t3x32(:,:,767))
  call heltable([2,16,32], n3(:,964), t3x32(:,:,768))
  call heltable([8,4,32], n3(:,965), t3x32(:,:,769))
  call heltable([8,4,32], n3(:,966), t3x32(:,:,770))
  call heltable([8,4,32], n3(:,967), t3x32(:,:,771))
  call heltable([2,16,32], n3(:,968), t3x32(:,:,772))
  call heltable([2,16,32], n3(:,969), t3x32(:,:,773))
  call heltable([2,16,32], n3(:,970), t3x32(:,:,774))
  call heltable([8,4,32], n3(:,971), t3x32(:,:,775))
  call heltable([8,4,32], n3(:,972), t3x32(:,:,776))
  call heltable([8,4,32], n3(:,973), t3x32(:,:,777))
  call heltable([2,16,32], n3(:,974), t3x32(:,:,778))
  call heltable([2,16,32], n3(:,975), t3x32(:,:,779))
  call heltable([2,16,32], n3(:,976), t3x32(:,:,780))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_heftpphhjj_hhggggg_1
