
module ol_vamp_2_heftpph_ew_eeexexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpph_ew_eeexexgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpph_ew_eeexexgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpph_ew_eeexexgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpph_ew_eeexexgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,48) :: G0
  complex(REALKIND), dimension(4,5,4,177) :: G1
  complex(REALKIND), dimension(1,12) :: G0tensor
  complex(REALKIND), dimension(5,85) :: G1tensor
  complex(REALKIND), dimension(15,148) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,53),G1(:,:,:,1))
  call check_last_SV_V(l_switch,G1(:,:,:,1),wf(:,9),G1tensor(:,1))
  call check_last_SV_V(l_switch,G1(:,:,:,1),wf(:,2),G1tensor(:,2))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,53),G1(:,:,:,2))
  call check_last_SV_V(l_switch,G1(:,:,:,2),wf(:,2),G1tensor(:,3))
  call loop_QZ_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,2),gZl)
  call loop_Q_A(G0(:,:,:,2),Q(:,53),ZERO,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,9),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),ZERO,G2tensor(:,1))
  call loop_QZ_A(G1(:,:,:,3),wf(:,2),G1(:,:,:,5),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,63),ZERO,G2tensor(:,2))
  call loop_QZ_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,3),gZl)
  call loop_Q_A(G0(:,:,:,3),Q(:,53),ML,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,9),G1(:,:,:,7))
  call check_last_Q_A(l_switch,G1(:,:,:,7),Q(:,63),ML,G2tensor(:,3))
  call loop_QZ_A(G1(:,:,:,6),wf(:,2),G1(:,:,:,8),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),ML,G2tensor(:,4))
  call loop_QZ_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,4),gZu)
  call loop_Q_A(G0(:,:,:,4),Q(:,53),ZERO,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,9),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),ZERO,G2tensor(:,5))
  call loop_QZ_A(G1(:,:,:,9),wf(:,2),G1(:,:,:,11),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,11),Q(:,63),ZERO,G2tensor(:,6))
  call loop_QZ_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,5),gZu)
  call loop_Q_A(G0(:,:,:,5),Q(:,53),MT,G1(:,:,:,12))
  call loop_QV_A(G1(:,:,:,12),wf(:,9),G1(:,:,:,13))
  call check_last_Q_A(l_switch,G1(:,:,:,13),Q(:,63),MT,G2tensor(:,7))
  call loop_QZ_A(G1(:,:,:,12),wf(:,2),G1(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,63),MT,G2tensor(:,8))
  call loop_QZ_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,6),gZd)
  call loop_Q_A(G0(:,:,:,6),Q(:,53),ZERO,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,9),G1(:,:,:,16))
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,63),ZERO,G2tensor(:,9))
  call loop_QZ_A(G1(:,:,:,15),wf(:,2),G1(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,17),Q(:,63),ZERO,G2tensor(:,10))
  call loop_QZ_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,7),gZn)
  call loop_Q_A(G0(:,:,:,7),Q(:,53),ZERO,G1(:,:,:,18))
  call loop_QZ_A(G1(:,:,:,18),wf(:,2),G1(:,:,:,19),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,63),ZERO,G2tensor(:,11))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,40),Q(:,53),G1(:,:,:,20))
  call check_last_TV_S(l_switch,G1(:,:,:,20),Q(:,53),wf(:,9),Q(:,10),G2tensor(:,12))
  call check_last_TV_S(l_switch,G1(:,:,:,20),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,13))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,40),Q(:,53),G1(:,:,:,21))
  call check_last_TV_S(l_switch,G1(:,:,:,21),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,14))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,40),Q(:,53),G1(:,:,:,22))
  call check_last_CV_D(l_switch,G1(:,:,:,22),Q(:,53),wf(:,9),Q(:,10),G2tensor(:,15))
  call check_last_CV_D(l_switch,G1(:,:,:,22),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,40),Q(:,53),G1(:,:,:,23))
  call check_last_UV_W(l_switch,G1(:,:,:,23),Q(:,53),wf(:,9),Q(:,10),G2tensor(:,17))
  call check_last_UV_W(l_switch,G1(:,:,:,23),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,18))
  call loop_VV_S(G0(:,:,:,1),wf(:,40),G0(:,:,:,8))
  call check_last_SV_V(l_switch,G0(:,:,:,8),wf(:,9),G0tensor(:,1))
  call check_last_SV_V(l_switch,G0(:,:,:,8),wf(:,2),G0tensor(:,2))
  call loop_VV_S(G0(:,:,:,1),wf(:,40),G0(:,:,:,9))
  call check_last_SV_V(l_switch,G0(:,:,:,9),wf(:,2),G0tensor(:,3))
  call loop_QS_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,10),gX)
  call loop_Q_A(G0(:,:,:,10),Q(:,58),ML,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,8),G1(:,:,:,25))
  call check_last_Q_A(l_switch,G1(:,:,:,25),Q(:,63),ML,G2tensor(:,19))
  call loop_QZ_A(G1(:,:,:,24),wf(:,1),G1(:,:,:,26),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,63),ML,G2tensor(:,20))
  call loop_QS_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,11),gX)
  call loop_Q_A(G0(:,:,:,11),Q(:,58),MT,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,8),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,63),MT,G2tensor(:,21))
  call loop_QZ_A(G1(:,:,:,27),wf(:,1),G1(:,:,:,29),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,29),Q(:,63),MT,G2tensor(:,22))
  call loop_SS_S(G0(:,:,:,1),wf(:,31),G0(:,:,:,12))
  call check_last_TV_S(l_switch,G0(:,:,:,12),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,4))
  call loop_SS_S(G0(:,:,:,1),wf(:,31),G0(:,:,:,13))
  call check_last_CV_D(l_switch,G0(:,:,:,13),Q(:,58),wf(:,8),Q(:,5),G1tensor(:,5))
  call check_last_CV_D(l_switch,G0(:,:,:,13),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,6))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,31),Q(:,58),G1(:,:,:,30))
  call check_last_SV_V(l_switch,G1(:,:,:,30),wf(:,8),G1tensor(:,7))
  call check_last_SV_V(l_switch,G1(:,:,:,30),wf(:,1),G1tensor(:,8))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,31),Q(:,58),G1(:,:,:,31))
  call check_last_SV_V(l_switch,G1(:,:,:,31),wf(:,1),G1tensor(:,9))
  call loop_QZ_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,14),gZl)
  call loop_Q_A(G0(:,:,:,14),Q(:,58),ZERO,G1(:,:,:,32))
  call loop_QV_A(G1(:,:,:,32),wf(:,8),G1(:,:,:,33))
  call check_last_Q_A(l_switch,G1(:,:,:,33),Q(:,63),ZERO,G2tensor(:,23))
  call loop_QZ_A(G1(:,:,:,32),wf(:,1),G1(:,:,:,34),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,63),ZERO,G2tensor(:,24))
  call loop_QZ_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,15),gZl)
  call loop_Q_A(G0(:,:,:,15),Q(:,58),ML,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,8),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,63),ML,G2tensor(:,25))
  call loop_QZ_A(G1(:,:,:,35),wf(:,1),G1(:,:,:,37),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,37),Q(:,63),ML,G2tensor(:,26))
  call loop_QZ_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,58),ZERO,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,8),G1(:,:,:,39))
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,63),ZERO,G2tensor(:,27))
  call loop_QZ_A(G1(:,:,:,38),wf(:,1),G1(:,:,:,40),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,63),ZERO,G2tensor(:,28))
  call loop_QZ_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,58),MT,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,8),G1(:,:,:,42))
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,63),MT,G2tensor(:,29))
  call loop_QZ_A(G1(:,:,:,41),wf(:,1),G1(:,:,:,43),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,63),MT,G2tensor(:,30))
  call loop_QZ_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,18),gZd)
  call loop_Q_A(G0(:,:,:,18),Q(:,58),ZERO,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,8),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,63),ZERO,G2tensor(:,31))
  call loop_QZ_A(G1(:,:,:,44),wf(:,1),G1(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,63),ZERO,G2tensor(:,32))
  call loop_QZ_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,19),gZn)
  call loop_Q_A(G0(:,:,:,19),Q(:,58),ZERO,G1(:,:,:,47))
  call loop_QZ_A(G1(:,:,:,47),wf(:,1),G1(:,:,:,48),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,48),Q(:,63),ZERO,G2tensor(:,33))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,58),G1(:,:,:,49))
  call check_last_TV_S(l_switch,G1(:,:,:,49),Q(:,58),wf(:,8),Q(:,5),G2tensor(:,34))
  call check_last_TV_S(l_switch,G1(:,:,:,49),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,35))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,58),G1(:,:,:,50))
  call check_last_TV_S(l_switch,G1(:,:,:,50),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,36))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,58),G1(:,:,:,51))
  call check_last_CV_D(l_switch,G1(:,:,:,51),Q(:,58),wf(:,8),Q(:,5),G2tensor(:,37))
  call check_last_CV_D(l_switch,G1(:,:,:,51),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,38))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,58),G1(:,:,:,52))
  call check_last_UV_W(l_switch,G1(:,:,:,52),Q(:,58),wf(:,8),Q(:,5),G2tensor(:,39))
  call check_last_UV_W(l_switch,G1(:,:,:,52),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,40))
  call loop_VV_S(G0(:,:,:,1),wf(:,34),G0(:,:,:,20))
  call check_last_SV_V(l_switch,G0(:,:,:,20),wf(:,8),G0tensor(:,4))
  call check_last_SV_V(l_switch,G0(:,:,:,20),wf(:,1),G0tensor(:,5))
  call loop_VV_S(G0(:,:,:,1),wf(:,34),G0(:,:,:,21))
  call check_last_SV_V(l_switch,G0(:,:,:,21),wf(:,1),G0tensor(:,6))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,22),gH)
  call loop_Q_A(G0(:,:,:,22),Q(:,48),ML,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,87),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,63),ML,G2tensor(:,41))
  call loop_QZ_A(G1(:,:,:,53),wf(:,88),G1(:,:,:,55),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,63),ML,G2tensor(:,42))
  call loop_QV_A(G1(:,:,:,53),wf(:,89),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,63),ML,G2tensor(:,43))
  call loop_QZ_A(G1(:,:,:,53),wf(:,90),G1(:,:,:,57),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,63),ML,G2tensor(:,44))
  call loop_QV_A(G1(:,:,:,53),wf(:,91),G1(:,:,:,58))
  call check_last_Q_A(l_switch,G1(:,:,:,58),Q(:,63),ML,G2tensor(:,45))
  call loop_QZ_A(G1(:,:,:,53),wf(:,92),G1(:,:,:,59),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,63),ML,G2tensor(:,46))
  call loop_QV_A(G1(:,:,:,53),wf(:,93),G1(:,:,:,60))
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,63),ML,G2tensor(:,47))
  call loop_QZ_A(G1(:,:,:,53),wf(:,94),G1(:,:,:,61),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,63),ML,G2tensor(:,48))
  call loop_QV_A(G1(:,:,:,53),wf(:,95),G1(:,:,:,62))
  call check_last_Q_A(l_switch,G1(:,:,:,62),Q(:,63),ML,G2tensor(:,49))
  call loop_QZ_A(G1(:,:,:,53),wf(:,96),G1(:,:,:,63),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,63),ML,G2tensor(:,50))
  call loop_QV_A(G1(:,:,:,53),wf(:,97),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,63),ML,G2tensor(:,51))
  call loop_QZ_A(G1(:,:,:,53),wf(:,98),G1(:,:,:,65),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,63),ML,G2tensor(:,52))
  call loop_QV_A(G1(:,:,:,53),wf(:,99),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),ML,G2tensor(:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,100),G1(:,:,:,67))
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,63),ML,G2tensor(:,54))
  call loop_QZ_A(G1(:,:,:,53),wf(:,101),G1(:,:,:,68),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,63),ML,G2tensor(:,55))
  call loop_QZ_A(G1(:,:,:,53),wf(:,102),G1(:,:,:,69),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,63),ML,G2tensor(:,56))
  call loop_QV_A(G1(:,:,:,53),wf(:,103),G1(:,:,:,70))
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,63),ML,G2tensor(:,57))
  call loop_QZ_A(G1(:,:,:,53),wf(:,104),G1(:,:,:,71),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,71),Q(:,63),ML,G2tensor(:,58))
  call loop_QV_A(G1(:,:,:,53),wf(:,105),G1(:,:,:,72))
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,63),ML,G2tensor(:,59))
  call loop_QZ_A(G1(:,:,:,53),wf(:,106),G1(:,:,:,73),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,63),ML,G2tensor(:,60))
  call loop_QV_A(G1(:,:,:,53),wf(:,107),G1(:,:,:,74))
  call check_last_Q_A(l_switch,G1(:,:,:,74),Q(:,63),ML,G2tensor(:,61))
  call loop_QZ_A(G1(:,:,:,53),wf(:,108),G1(:,:,:,75),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,63),ML,G2tensor(:,62))
  call loop_QV_A(G1(:,:,:,53),wf(:,109),G1(:,:,:,76))
  call check_last_Q_A(l_switch,G1(:,:,:,76),Q(:,63),ML,G2tensor(:,63))
  call loop_QZ_A(G1(:,:,:,53),wf(:,110),G1(:,:,:,77),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,77),Q(:,63),ML,G2tensor(:,64))
  call loop_QV_A(G1(:,:,:,53),wf(:,111),G1(:,:,:,78))
  call check_last_Q_A(l_switch,G1(:,:,:,78),Q(:,63),ML,G2tensor(:,65))
  call loop_QZ_A(G1(:,:,:,53),wf(:,112),G1(:,:,:,79),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,79),Q(:,63),ML,G2tensor(:,66))
  call loop_QV_A(G1(:,:,:,53),wf(:,113),G1(:,:,:,80))
  call check_last_Q_A(l_switch,G1(:,:,:,80),Q(:,63),ML,G2tensor(:,67))
  call loop_QZ_A(G1(:,:,:,53),wf(:,114),G1(:,:,:,81),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,63),ML,G2tensor(:,68))
  call loop_QV_A(G1(:,:,:,53),wf(:,115),G1(:,:,:,82))
  call check_last_Q_A(l_switch,G1(:,:,:,82),Q(:,63),ML,G2tensor(:,69))
  call loop_QV_A(G1(:,:,:,53),wf(:,116),G1(:,:,:,83))
  call check_last_Q_A(l_switch,G1(:,:,:,83),Q(:,63),ML,G2tensor(:,70))
  call loop_QZ_A(G1(:,:,:,53),wf(:,117),G1(:,:,:,84),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,84),Q(:,63),ML,G2tensor(:,71))
  call loop_QZ_A(G1(:,:,:,53),wf(:,118),G1(:,:,:,85),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,63),ML,G2tensor(:,72))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,23),gH)
  call loop_Q_A(G0(:,:,:,23),Q(:,48),MT,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,87),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,63),MT,G2tensor(:,73))
  call loop_QZ_A(G1(:,:,:,86),wf(:,88),G1(:,:,:,88),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,88),Q(:,63),MT,G2tensor(:,74))
  call loop_QV_A(G1(:,:,:,86),wf(:,89),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,63),MT,G2tensor(:,75))
  call loop_QZ_A(G1(:,:,:,86),wf(:,90),G1(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,90),Q(:,63),MT,G2tensor(:,76))
  call loop_QV_A(G1(:,:,:,86),wf(:,91),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,63),MT,G2tensor(:,77))
  call loop_QZ_A(G1(:,:,:,86),wf(:,92),G1(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,92),Q(:,63),MT,G2tensor(:,78))
  call loop_QV_A(G1(:,:,:,86),wf(:,93),G1(:,:,:,93))
  call check_last_Q_A(l_switch,G1(:,:,:,93),Q(:,63),MT,G2tensor(:,79))
  call loop_QZ_A(G1(:,:,:,86),wf(:,94),G1(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),MT,G2tensor(:,80))
  call loop_QV_A(G1(:,:,:,86),wf(:,95),G1(:,:,:,95))
  call check_last_Q_A(l_switch,G1(:,:,:,95),Q(:,63),MT,G2tensor(:,81))
  call loop_QZ_A(G1(:,:,:,86),wf(:,96),G1(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,63),MT,G2tensor(:,82))
  call loop_QV_A(G1(:,:,:,86),wf(:,97),G1(:,:,:,97))
  call check_last_Q_A(l_switch,G1(:,:,:,97),Q(:,63),MT,G2tensor(:,83))
  call loop_QZ_A(G1(:,:,:,86),wf(:,98),G1(:,:,:,98),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,63),MT,G2tensor(:,84))
  call loop_QV_A(G1(:,:,:,86),wf(:,99),G1(:,:,:,99))
  call check_last_Q_A(l_switch,G1(:,:,:,99),Q(:,63),MT,G2tensor(:,85))
  call loop_QV_A(G1(:,:,:,86),wf(:,100),G1(:,:,:,100))
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,63),MT,G2tensor(:,86))
  call loop_QZ_A(G1(:,:,:,86),wf(:,101),G1(:,:,:,101),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,101),Q(:,63),MT,G2tensor(:,87))
  call loop_QZ_A(G1(:,:,:,86),wf(:,102),G1(:,:,:,102),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,102),Q(:,63),MT,G2tensor(:,88))
  call loop_QV_A(G1(:,:,:,86),wf(:,103),G1(:,:,:,103))
  call check_last_Q_A(l_switch,G1(:,:,:,103),Q(:,63),MT,G2tensor(:,89))
  call loop_QZ_A(G1(:,:,:,86),wf(:,104),G1(:,:,:,104),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,104),Q(:,63),MT,G2tensor(:,90))
  call loop_QV_A(G1(:,:,:,86),wf(:,105),G1(:,:,:,105))
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,63),MT,G2tensor(:,91))
  call loop_QZ_A(G1(:,:,:,86),wf(:,106),G1(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),MT,G2tensor(:,92))
  call loop_QV_A(G1(:,:,:,86),wf(:,107),G1(:,:,:,107))
  call check_last_Q_A(l_switch,G1(:,:,:,107),Q(:,63),MT,G2tensor(:,93))
  call loop_QZ_A(G1(:,:,:,86),wf(:,108),G1(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,108),Q(:,63),MT,G2tensor(:,94))
  call loop_QV_A(G1(:,:,:,86),wf(:,109),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,63),MT,G2tensor(:,95))
  call loop_QZ_A(G1(:,:,:,86),wf(:,110),G1(:,:,:,110),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,63),MT,G2tensor(:,96))
  call loop_QV_A(G1(:,:,:,86),wf(:,111),G1(:,:,:,111))
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,63),MT,G2tensor(:,97))
  call loop_QZ_A(G1(:,:,:,86),wf(:,112),G1(:,:,:,112),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,63),MT,G2tensor(:,98))
  call loop_QV_A(G1(:,:,:,86),wf(:,113),G1(:,:,:,113))
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,63),MT,G2tensor(:,99))
  call loop_QZ_A(G1(:,:,:,86),wf(:,114),G1(:,:,:,114),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,114),Q(:,63),MT,G2tensor(:,100))
  call loop_QV_A(G1(:,:,:,86),wf(:,115),G1(:,:,:,115))
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,63),MT,G2tensor(:,101))
  call loop_QV_A(G1(:,:,:,86),wf(:,116),G1(:,:,:,116))
  call check_last_Q_A(l_switch,G1(:,:,:,116),Q(:,63),MT,G2tensor(:,102))
  call loop_QZ_A(G1(:,:,:,86),wf(:,117),G1(:,:,:,117),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,117),Q(:,63),MT,G2tensor(:,103))
  call loop_QZ_A(G1(:,:,:,86),wf(:,118),G1(:,:,:,118),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,118),Q(:,63),MT,G2tensor(:,104))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,24))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,87),Q(:,15),G1tensor(:,10))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,88),Q(:,15),G1tensor(:,11))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,89),Q(:,15),G1tensor(:,12))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,90),Q(:,15),G1tensor(:,13))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,91),Q(:,15),G1tensor(:,14))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,92),Q(:,15),G1tensor(:,15))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,93),Q(:,15),G1tensor(:,16))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,94),Q(:,15),G1tensor(:,17))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,95),Q(:,15),G1tensor(:,18))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,96),Q(:,15),G1tensor(:,19))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,97),Q(:,15),G1tensor(:,20))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,98),Q(:,15),G1tensor(:,21))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,99),Q(:,15),G1tensor(:,22))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,100),Q(:,15),G1tensor(:,23))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,101),Q(:,15),G1tensor(:,24))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,102),Q(:,15),G1tensor(:,25))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,103),Q(:,15),G1tensor(:,26))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,104),Q(:,15),G1tensor(:,27))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,105),Q(:,15),G1tensor(:,28))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,106),Q(:,15),G1tensor(:,29))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,107),Q(:,15),G1tensor(:,30))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,108),Q(:,15),G1tensor(:,31))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,109),Q(:,15),G1tensor(:,32))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,110),Q(:,15),G1tensor(:,33))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,111),Q(:,15),G1tensor(:,34))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,112),Q(:,15),G1tensor(:,35))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,113),Q(:,15),G1tensor(:,36))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,114),Q(:,15),G1tensor(:,37))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,115),Q(:,15),G1tensor(:,38))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,116),Q(:,15),G1tensor(:,39))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,117),Q(:,15),G1tensor(:,40))
  call check_last_CV_D(l_switch,G0(:,:,:,24),Q(:,48),wf(:,118),Q(:,15),G1tensor(:,41))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,48),G1(:,:,:,119))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,87),G1tensor(:,42))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,88),G1tensor(:,43))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,89),G1tensor(:,44))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,90),G1tensor(:,45))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,91),G1tensor(:,46))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,92),G1tensor(:,47))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,93),G1tensor(:,48))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,94),G1tensor(:,49))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,95),G1tensor(:,50))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,96),G1tensor(:,51))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,97),G1tensor(:,52))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,98),G1tensor(:,53))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,99),G1tensor(:,54))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,100),G1tensor(:,55))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,101),G1tensor(:,56))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,102),G1tensor(:,57))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,103),G1tensor(:,58))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,104),G1tensor(:,59))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,105),G1tensor(:,60))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,106),G1tensor(:,61))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,107),G1tensor(:,62))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,108),G1tensor(:,63))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,109),G1tensor(:,64))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,110),G1tensor(:,65))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,111),G1tensor(:,66))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,112),G1tensor(:,67))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,113),G1tensor(:,68))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,114),G1tensor(:,69))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,115),G1tensor(:,70))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,116),G1tensor(:,71))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,117),G1tensor(:,72))
  call check_last_SV_V(l_switch,G1(:,:,:,119),wf(:,118),G1tensor(:,73))
  call loop_QS_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,25),gX)
  call loop_Q_A(G0(:,:,:,25),Q(:,57),ML,G1(:,:,:,120))
  call loop_QV_A(G1(:,:,:,120),wf(:,17),G1(:,:,:,121))
  call check_last_Q_A(l_switch,G1(:,:,:,121),Q(:,63),ML,G2tensor(:,105))
  call loop_QZ_A(G1(:,:,:,120),wf(:,6),G1(:,:,:,122),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,63),ML,G2tensor(:,106))
  call loop_QS_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,26),gX)
  call loop_Q_A(G0(:,:,:,26),Q(:,57),MT,G1(:,:,:,123))
  call loop_QV_A(G1(:,:,:,123),wf(:,17),G1(:,:,:,124))
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,63),MT,G2tensor(:,107))
  call loop_QZ_A(G1(:,:,:,123),wf(:,6),G1(:,:,:,125),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,63),MT,G2tensor(:,108))
  call loop_SS_S(G0(:,:,:,1),wf(:,49),G0(:,:,:,27))
  call check_last_TV_S(l_switch,G0(:,:,:,27),Q(:,57),wf(:,6),Q(:,6),G1tensor(:,74))
  call loop_SS_S(G0(:,:,:,1),wf(:,49),G0(:,:,:,28))
  call check_last_CV_D(l_switch,G0(:,:,:,28),Q(:,57),wf(:,17),Q(:,6),G1tensor(:,75))
  call check_last_CV_D(l_switch,G0(:,:,:,28),Q(:,57),wf(:,6),Q(:,6),G1tensor(:,76))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,49),Q(:,57),G1(:,:,:,126))
  call check_last_SV_V(l_switch,G1(:,:,:,126),wf(:,17),G1tensor(:,77))
  call check_last_SV_V(l_switch,G1(:,:,:,126),wf(:,6),G1tensor(:,78))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,49),Q(:,57),G1(:,:,:,127))
  call check_last_SV_V(l_switch,G1(:,:,:,127),wf(:,6),G1tensor(:,79))
  call loop_QZ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,29),gZl)
  call loop_Q_A(G0(:,:,:,29),Q(:,57),ZERO,G1(:,:,:,128))
  call loop_QV_A(G1(:,:,:,128),wf(:,17),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),ZERO,G2tensor(:,109))
  call loop_QZ_A(G1(:,:,:,128),wf(:,6),G1(:,:,:,130),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),ZERO,G2tensor(:,110))
  call loop_QZ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,30),gZl)
  call loop_Q_A(G0(:,:,:,30),Q(:,57),ML,G1(:,:,:,131))
  call loop_QV_A(G1(:,:,:,131),wf(:,17),G1(:,:,:,132))
  call check_last_Q_A(l_switch,G1(:,:,:,132),Q(:,63),ML,G2tensor(:,111))
  call loop_QZ_A(G1(:,:,:,131),wf(:,6),G1(:,:,:,133),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,63),ML,G2tensor(:,112))
  call loop_QZ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,31),gZu)
  call loop_Q_A(G0(:,:,:,31),Q(:,57),ZERO,G1(:,:,:,134))
  call loop_QV_A(G1(:,:,:,134),wf(:,17),G1(:,:,:,135))
  call check_last_Q_A(l_switch,G1(:,:,:,135),Q(:,63),ZERO,G2tensor(:,113))
  call loop_QZ_A(G1(:,:,:,134),wf(:,6),G1(:,:,:,136),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,136),Q(:,63),ZERO,G2tensor(:,114))
  call loop_QZ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,32),gZu)
  call loop_Q_A(G0(:,:,:,32),Q(:,57),MT,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,17),G1(:,:,:,138))
  call check_last_Q_A(l_switch,G1(:,:,:,138),Q(:,63),MT,G2tensor(:,115))
  call loop_QZ_A(G1(:,:,:,137),wf(:,6),G1(:,:,:,139),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,139),Q(:,63),MT,G2tensor(:,116))
  call loop_QZ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,33),gZd)
  call loop_Q_A(G0(:,:,:,33),Q(:,57),ZERO,G1(:,:,:,140))
  call loop_QV_A(G1(:,:,:,140),wf(:,17),G1(:,:,:,141))
  call check_last_Q_A(l_switch,G1(:,:,:,141),Q(:,63),ZERO,G2tensor(:,117))
  call loop_QZ_A(G1(:,:,:,140),wf(:,6),G1(:,:,:,142),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,142),Q(:,63),ZERO,G2tensor(:,118))
  call loop_QZ_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,34),gZn)
  call loop_Q_A(G0(:,:,:,34),Q(:,57),ZERO,G1(:,:,:,143))
  call loop_QZ_A(G1(:,:,:,143),wf(:,6),G1(:,:,:,144),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,144),Q(:,63),ZERO,G2tensor(:,119))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,57),G1(:,:,:,145))
  call check_last_TV_S(l_switch,G1(:,:,:,145),Q(:,57),wf(:,17),Q(:,6),G2tensor(:,120))
  call check_last_TV_S(l_switch,G1(:,:,:,145),Q(:,57),wf(:,6),Q(:,6),G2tensor(:,121))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,57),G1(:,:,:,146))
  call check_last_TV_S(l_switch,G1(:,:,:,146),Q(:,57),wf(:,6),Q(:,6),G2tensor(:,122))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,57),G1(:,:,:,147))
  call check_last_CV_D(l_switch,G1(:,:,:,147),Q(:,57),wf(:,17),Q(:,6),G2tensor(:,123))
  call check_last_CV_D(l_switch,G1(:,:,:,147),Q(:,57),wf(:,6),Q(:,6),G2tensor(:,124))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,57),G1(:,:,:,148))
  call check_last_UV_W(l_switch,G1(:,:,:,148),Q(:,57),wf(:,17),Q(:,6),G2tensor(:,125))
  call check_last_UV_W(l_switch,G1(:,:,:,148),Q(:,57),wf(:,6),Q(:,6),G2tensor(:,126))
  call loop_VV_S(G0(:,:,:,1),wf(:,52),G0(:,:,:,35))
  call check_last_SV_V(l_switch,G0(:,:,:,35),wf(:,17),G0tensor(:,7))
  call check_last_SV_V(l_switch,G0(:,:,:,35),wf(:,6),G0tensor(:,8))
  call loop_VV_S(G0(:,:,:,1),wf(:,52),G0(:,:,:,36))
  call check_last_SV_V(l_switch,G0(:,:,:,36),wf(:,6),G0tensor(:,9))
  call loop_QS_A(G0(:,:,:,1),wf(:,43),G0(:,:,:,37),gX)
  call loop_Q_A(G0(:,:,:,37),Q(:,54),ML,G1(:,:,:,149))
  call loop_QV_A(G1(:,:,:,149),wf(:,16),G1(:,:,:,150))
  call check_last_Q_A(l_switch,G1(:,:,:,150),Q(:,63),ML,G2tensor(:,127))
  call loop_QZ_A(G1(:,:,:,149),wf(:,5),G1(:,:,:,151),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,151),Q(:,63),ML,G2tensor(:,128))
  call loop_QS_A(G0(:,:,:,1),wf(:,43),G0(:,:,:,38),gX)
  call loop_Q_A(G0(:,:,:,38),Q(:,54),MT,G1(:,:,:,152))
  call loop_QV_A(G1(:,:,:,152),wf(:,16),G1(:,:,:,153))
  call check_last_Q_A(l_switch,G1(:,:,:,153),Q(:,63),MT,G2tensor(:,129))
  call loop_QZ_A(G1(:,:,:,152),wf(:,5),G1(:,:,:,154),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,154),Q(:,63),MT,G2tensor(:,130))
  call loop_SS_S(G0(:,:,:,1),wf(:,43),G0(:,:,:,39))
  call check_last_TV_S(l_switch,G0(:,:,:,39),Q(:,54),wf(:,5),Q(:,9),G1tensor(:,80))
  call loop_SS_S(G0(:,:,:,1),wf(:,43),G0(:,:,:,40))
  call check_last_CV_D(l_switch,G0(:,:,:,40),Q(:,54),wf(:,16),Q(:,9),G1tensor(:,81))
  call check_last_CV_D(l_switch,G0(:,:,:,40),Q(:,54),wf(:,5),Q(:,9),G1tensor(:,82))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,43),Q(:,54),G1(:,:,:,155))
  call check_last_SV_V(l_switch,G1(:,:,:,155),wf(:,16),G1tensor(:,83))
  call check_last_SV_V(l_switch,G1(:,:,:,155),wf(:,5),G1tensor(:,84))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,43),Q(:,54),G1(:,:,:,156))
  call check_last_SV_V(l_switch,G1(:,:,:,156),wf(:,5),G1tensor(:,85))
  call loop_QZ_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,41),gZl)
  call loop_Q_A(G0(:,:,:,41),Q(:,54),ZERO,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,16),G1(:,:,:,158))
  call check_last_Q_A(l_switch,G1(:,:,:,158),Q(:,63),ZERO,G2tensor(:,131))
  call loop_QZ_A(G1(:,:,:,157),wf(:,5),G1(:,:,:,159),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,159),Q(:,63),ZERO,G2tensor(:,132))
  call loop_QZ_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,42),gZl)
  call loop_Q_A(G0(:,:,:,42),Q(:,54),ML,G1(:,:,:,160))
  call loop_QV_A(G1(:,:,:,160),wf(:,16),G1(:,:,:,161))
  call check_last_Q_A(l_switch,G1(:,:,:,161),Q(:,63),ML,G2tensor(:,133))
  call loop_QZ_A(G1(:,:,:,160),wf(:,5),G1(:,:,:,162),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,162),Q(:,63),ML,G2tensor(:,134))
  call loop_QZ_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,43),gZu)
  call loop_Q_A(G0(:,:,:,43),Q(:,54),ZERO,G1(:,:,:,163))
  call loop_QV_A(G1(:,:,:,163),wf(:,16),G1(:,:,:,164))
  call check_last_Q_A(l_switch,G1(:,:,:,164),Q(:,63),ZERO,G2tensor(:,135))
  call loop_QZ_A(G1(:,:,:,163),wf(:,5),G1(:,:,:,165),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,165),Q(:,63),ZERO,G2tensor(:,136))
  call loop_QZ_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,44),gZu)
  call loop_Q_A(G0(:,:,:,44),Q(:,54),MT,G1(:,:,:,166))
  call loop_QV_A(G1(:,:,:,166),wf(:,16),G1(:,:,:,167))
  call check_last_Q_A(l_switch,G1(:,:,:,167),Q(:,63),MT,G2tensor(:,137))
  call loop_QZ_A(G1(:,:,:,166),wf(:,5),G1(:,:,:,168),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,168),Q(:,63),MT,G2tensor(:,138))
  call loop_QZ_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,45),gZd)
  call loop_Q_A(G0(:,:,:,45),Q(:,54),ZERO,G1(:,:,:,169))
  call loop_QV_A(G1(:,:,:,169),wf(:,16),G1(:,:,:,170))
  call check_last_Q_A(l_switch,G1(:,:,:,170),Q(:,63),ZERO,G2tensor(:,139))
  call loop_QZ_A(G1(:,:,:,169),wf(:,5),G1(:,:,:,171),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,171),Q(:,63),ZERO,G2tensor(:,140))
  call loop_QZ_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,46),gZn)
  call loop_Q_A(G0(:,:,:,46),Q(:,54),ZERO,G1(:,:,:,172))
  call loop_QZ_A(G1(:,:,:,172),wf(:,5),G1(:,:,:,173),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,173),Q(:,63),ZERO,G2tensor(:,141))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,46),Q(:,54),G1(:,:,:,174))
  call check_last_TV_S(l_switch,G1(:,:,:,174),Q(:,54),wf(:,16),Q(:,9),G2tensor(:,142))
  call check_last_TV_S(l_switch,G1(:,:,:,174),Q(:,54),wf(:,5),Q(:,9),G2tensor(:,143))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,46),Q(:,54),G1(:,:,:,175))
  call check_last_TV_S(l_switch,G1(:,:,:,175),Q(:,54),wf(:,5),Q(:,9),G2tensor(:,144))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,46),Q(:,54),G1(:,:,:,176))
  call check_last_CV_D(l_switch,G1(:,:,:,176),Q(:,54),wf(:,16),Q(:,9),G2tensor(:,145))
  call check_last_CV_D(l_switch,G1(:,:,:,176),Q(:,54),wf(:,5),Q(:,9),G2tensor(:,146))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,46),Q(:,54),G1(:,:,:,177))
  call check_last_UV_W(l_switch,G1(:,:,:,177),Q(:,54),wf(:,16),Q(:,9),G2tensor(:,147))
  call check_last_UV_W(l_switch,G1(:,:,:,177),Q(:,54),wf(:,5),Q(:,9),G2tensor(:,148))
  call loop_VV_S(G0(:,:,:,1),wf(:,46),G0(:,:,:,47))
  call check_last_SV_V(l_switch,G0(:,:,:,47),wf(:,16),G0tensor(:,10))
  call check_last_SV_V(l_switch,G0(:,:,:,47),wf(:,5),G0tensor(:,11))
  call loop_VV_S(G0(:,:,:,1),wf(:,46),G0(:,:,:,48))
  call check_last_SV_V(l_switch,G0(:,:,:,48),wf(:,5),G0tensor(:,12))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(20)*M(1))) * den(34)
  T2sum(1:5,61) = T2sum(1:5,61) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(20)*M(1))) * den(34)
  T2sum(1:5,61) = T2sum(1:5,61) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(11)*M(1)) * den(35)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(26)*M(1))) * den(35)
  T2sum(1:5,61) = T2sum(1:5,61) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(26)*M(1))) * den(35)
  T2sum(1:5,61) = T2sum(1:5,61) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(51)*M(1)) * den(34)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(48)*M(1)) * den(34)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(50)*M(1))) * den(34)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(47)*M(1))) * den(34)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(49)*M(1)) * den(34)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(53)*M(1)) * den(35)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(51)*M(1)) * den(35)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(48)*M(1)) * den(35)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(52)*M(1)) * den(35)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(49)*M(1)) * den(35)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(54)*M(1)) * den(35)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(40)*M(1))) * den(34)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(11)*M(1)) * den(35)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(37)*M(1)) * den(35)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(21)*M(1))) * den(34)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(21)*M(1))) * den(34)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(10)*M(1)) * den(35)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(10)*M(1)) * den(35)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(21)*M(1)) * den(34)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(10)*M(1))) * den(35)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(34)*M(1)) * den(34)
  T2sum(1:1,61) = T2sum(1:1,61) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(34)*M(1)) * den(34)
  T2sum(1:1,61) = T2sum(1:1,61) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(19)*M(1)) * den(35)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(3)*M(1)) * den(35)
  T2sum(1:1,61) = T2sum(1:1,61) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(3)*M(1)) * den(35)
  T2sum(1:1,61) = T2sum(1:1,61) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(44)*M(1))) * den(29)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(45)*M(1))) * den(29)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(44)*M(1))) * den(30)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(46)*M(1)) * den(30)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(17)*M(1)) * den(30)
  T2sum(1:5,60) = T2sum(1:5,60) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(20)*M(1))) * den(29)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(20)*M(1))) * den(29)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(8)*M(1)) * den(30)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(8)*M(1)) * den(30)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(20)*M(1))) * den(29)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(20)*M(1))) * den(29)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(11)*M(1)) * den(30)
  T2sum(1:5,60) = T2sum(1:5,60) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(26)*M(1))) * den(30)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(26)*M(1))) * den(30)
  T2sum(1:5,59) = T2sum(1:5,59) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(51)*M(1)) * den(29)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(48)*M(1)) * den(29)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(50)*M(1))) * den(29)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(47)*M(1))) * den(29)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(49)*M(1)) * den(29)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(53)*M(1)) * den(30)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(51)*M(1)) * den(30)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(48)*M(1)) * den(30)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(52)*M(1)) * den(30)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(49)*M(1)) * den(30)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(54)*M(1)) * den(30)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(40)*M(1))) * den(29)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(11)*M(1)) * den(30)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(37)*M(1)) * den(30)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(21)*M(1))) * den(29)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(21)*M(1))) * den(29)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(10)*M(1)) * den(30)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(10)*M(1)) * den(30)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(21)*M(1)) * den(29)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(10)*M(1))) * den(30)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(34)*M(1)) * den(29)
  T2sum(1:1,59) = T2sum(1:1,59) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(34)*M(1)) * den(29)
  T2sum(1:1,59) = T2sum(1:1,59) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(19)*M(1)) * den(30)
  T2sum(1:1,60) = T2sum(1:1,60) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(3)*M(1)) * den(30)
  T2sum(1:1,59) = T2sum(1:1,59) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(3)*M(1)) * den(30)
  T2sum(1:1,59) = T2sum(1:1,59) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(55)*M(1)) * den(147)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(57)*M(1))) * den(147)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(55)*M(1)) * den(148)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(58)*M(1)) * den(148)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(55)*M(1)) * den(149)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(57)*M(1))) * den(149)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(55)*M(1)) * den(150)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(58)*M(1)) * den(150)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(24)*M(1)) * den(147)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(24)*M(1))) * den(147)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(22)*M(1))) * den(148)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(22)*M(1)) * den(148)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(24)*M(1)) * den(149)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(24)*M(1))) * den(149)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(22)*M(1))) * den(150)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(22)*M(1)) * den(150)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(24)*M(1)) * den(147)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,42)
  Gcoeff = (-(c(24)*M(1))) * den(147)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(32)*M(1)) * den(148)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,43)
  Gcoeff = (-(c(32)*M(1))) * den(148)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(24)*M(1)) * den(149)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,44)
  Gcoeff = (-(c(24)*M(1))) * den(149)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(32)*M(1)) * den(150)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,45)
  Gcoeff = (-(c(32)*M(1))) * den(150)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(55)*M(1)) * den(151)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(57)*M(1))) * den(151)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(55)*M(1)) * den(152)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(58)*M(1)) * den(152)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(55)*M(1)) * den(153)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(57)*M(1))) * den(153)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(55)*M(1)) * den(154)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(58)*M(1)) * den(154)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(24)*M(1)) * den(151)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(24)*M(1))) * den(151)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(22)*M(1))) * den(152)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(22)*M(1)) * den(152)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(24)*M(1)) * den(153)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(24)*M(1))) * den(153)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(22)*M(1))) * den(154)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(22)*M(1)) * den(154)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(24)*M(1)) * den(151)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,46)
  Gcoeff = (-(c(24)*M(1))) * den(151)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(32)*M(1)) * den(152)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,47)
  Gcoeff = (-(c(32)*M(1))) * den(152)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(24)*M(1)) * den(153)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,48)
  Gcoeff = (-(c(24)*M(1))) * den(153)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(32)*M(1)) * den(154)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,49)
  Gcoeff = (-(c(32)*M(1))) * den(154)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(44)*M(1)) * den(44)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(45)*M(1)) * den(44)
  T2sum(1:15,76) = T2sum(1:15,76) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(44)*M(1)) * den(45)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(46)*M(1))) * den(45)
  T2sum(1:15,76) = T2sum(1:15,76) + Gcoeff * G2tensor(:,108)
  Gcoeff = (-(c(17)*M(1))) * den(45)
  T2sum(1:5,66) = T2sum(1:5,66) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(20)*M(1)) * den(44)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(20)*M(1)) * den(44)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,75)
  Gcoeff = (-(c(8)*M(1))) * den(45)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,76)
  Gcoeff = (-(c(8)*M(1))) * den(45)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(20)*M(1)) * den(44)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(20)*M(1)) * den(44)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,77)
  Gcoeff = (-(c(11)*M(1))) * den(45)
  T2sum(1:5,66) = T2sum(1:5,66) + Gcoeff * G1tensor(:,79)
  Gcoeff = (c(26)*M(1)) * den(45)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(26)*M(1)) * den(45)
  T2sum(1:5,65) = T2sum(1:5,65) + Gcoeff * G1tensor(:,78)
  Gcoeff = (-(c(51)*M(1))) * den(44)
  T2sum(1:15,77) = T2sum(1:15,77) + Gcoeff * G2tensor(:,109)
  Gcoeff = (-(c(48)*M(1))) * den(44)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(50)*M(1)) * den(44)
  T2sum(1:15,77) = T2sum(1:15,77) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(47)*M(1)) * den(44)
  T2sum(1:15,76) = T2sum(1:15,76) + Gcoeff * G2tensor(:,115)
  Gcoeff = (-(c(49)*M(1))) * den(44)
  T2sum(1:15,77) = T2sum(1:15,77) + Gcoeff * G2tensor(:,117)
  Gcoeff = (-(c(53)*M(1))) * den(45)
  T2sum(1:15,77) = T2sum(1:15,77) + Gcoeff * G2tensor(:,119)
  Gcoeff = (-(c(51)*M(1))) * den(45)
  T2sum(1:15,77) = T2sum(1:15,77) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(48)*M(1))) * den(45)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(52)*M(1))) * den(45)
  T2sum(1:15,77) = T2sum(1:15,77) + Gcoeff * G2tensor(:,114)
  Gcoeff = (-(c(49)*M(1))) * den(45)
  T2sum(1:15,76) = T2sum(1:15,76) + Gcoeff * G2tensor(:,116)
  Gcoeff = (-(c(54)*M(1))) * den(45)
  T2sum(1:15,77) = T2sum(1:15,77) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(40)*M(1)) * den(44)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(11)*M(1))) * den(45)
  T2sum(1:15,66) = T2sum(1:15,66) + Gcoeff * G2tensor(:,122)
  Gcoeff = (-(c(37)*M(1))) * den(45)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(21)*M(1)) * den(44)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(21)*M(1)) * den(44)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,123)
  Gcoeff = (-(c(10)*M(1))) * den(45)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,124)
  Gcoeff = (-(c(10)*M(1))) * den(45)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,124)
  Gcoeff = (-(c(21)*M(1))) * den(44)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,125)
  Gcoeff = (c(10)*M(1)) * den(45)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,126)
  Gcoeff = (-(c(34)*M(1))) * den(44)
  T2sum(1:1,65) = T2sum(1:1,65) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(34)*M(1))) * den(44)
  T2sum(1:1,65) = T2sum(1:1,65) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(19)*M(1))) * den(45)
  T2sum(1:1,66) = T2sum(1:1,66) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(3)*M(1))) * den(45)
  T2sum(1:1,65) = T2sum(1:1,65) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(3)*M(1))) * den(45)
  T2sum(1:1,65) = T2sum(1:1,65) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(44)*M(1)) * den(39)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(45)*M(1)) * den(39)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(44)*M(1)) * den(40)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,128)
  Gcoeff = (-(c(46)*M(1))) * den(40)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,130)
  Gcoeff = (-(c(17)*M(1))) * den(40)
  T2sum(1:5,64) = T2sum(1:5,64) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(20)*M(1)) * den(39)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,81)
  Gcoeff = (c(20)*M(1)) * den(39)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,81)
  Gcoeff = (-(c(8)*M(1))) * den(40)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,82)
  Gcoeff = (-(c(8)*M(1))) * den(40)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(20)*M(1)) * den(39)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(20)*M(1)) * den(39)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,83)
  Gcoeff = (-(c(11)*M(1))) * den(40)
  T2sum(1:5,64) = T2sum(1:5,64) + Gcoeff * G1tensor(:,85)
  Gcoeff = (c(26)*M(1)) * den(40)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(26)*M(1)) * den(40)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,84)
  Gcoeff = (-(c(51)*M(1))) * den(39)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,131)
  Gcoeff = (-(c(48)*M(1))) * den(39)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(50)*M(1)) * den(39)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,135)
  Gcoeff = (c(47)*M(1)) * den(39)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,137)
  Gcoeff = (-(c(49)*M(1))) * den(39)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,139)
  Gcoeff = (-(c(53)*M(1))) * den(40)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,141)
  Gcoeff = (-(c(51)*M(1))) * den(40)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,132)
  Gcoeff = (-(c(48)*M(1))) * den(40)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,134)
  Gcoeff = (-(c(52)*M(1))) * den(40)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,136)
  Gcoeff = (-(c(49)*M(1))) * den(40)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,138)
  Gcoeff = (-(c(54)*M(1))) * den(40)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(40)*M(1)) * den(39)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,142)
  Gcoeff = (-(c(11)*M(1))) * den(40)
  T2sum(1:15,64) = T2sum(1:15,64) + Gcoeff * G2tensor(:,144)
  Gcoeff = (-(c(37)*M(1))) * den(40)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,143)
  Gcoeff = (c(21)*M(1)) * den(39)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,145)
  Gcoeff = (c(21)*M(1)) * den(39)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,145)
  Gcoeff = (-(c(10)*M(1))) * den(40)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,146)
  Gcoeff = (-(c(10)*M(1))) * den(40)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,146)
  Gcoeff = (-(c(21)*M(1))) * den(39)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,147)
  Gcoeff = (c(10)*M(1)) * den(40)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,148)
  Gcoeff = (-(c(34)*M(1))) * den(39)
  T2sum(1:1,63) = T2sum(1:1,63) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(34)*M(1))) * den(39)
  T2sum(1:1,63) = T2sum(1:1,63) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(19)*M(1))) * den(40)
  T2sum(1:1,64) = T2sum(1:1,64) + Gcoeff * G0tensor(:,12)
  Gcoeff = (-(c(3)*M(1))) * den(40)
  T2sum(1:1,63) = T2sum(1:1,63) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(3)*M(1))) * den(40)
  T2sum(1:1,63) = T2sum(1:1,63) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(55)*M(1))) * den(155)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(57)*M(1)) * den(155)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(55)*M(1))) * den(156)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(58)*M(1))) * den(156)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(55)*M(1))) * den(157)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(57)*M(1)) * den(157)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(55)*M(1))) * den(158)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(58)*M(1))) * den(158)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(24)*M(1))) * den(155)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(24)*M(1)) * den(155)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(22)*M(1)) * den(156)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(22)*M(1))) * den(156)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(24)*M(1))) * den(157)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(24)*M(1)) * den(157)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(22)*M(1)) * den(158)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,21)
  Gcoeff = (-(c(22)*M(1))) * den(158)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,21)
  Gcoeff = (-(c(24)*M(1))) * den(155)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(24)*M(1)) * den(155)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,50)
  Gcoeff = (-(c(32)*M(1))) * den(156)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(32)*M(1)) * den(156)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,51)
  Gcoeff = (-(c(24)*M(1))) * den(157)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(24)*M(1)) * den(157)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,52)
  Gcoeff = (-(c(32)*M(1))) * den(158)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(32)*M(1)) * den(158)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,53)
  Gcoeff = (-(c(55)*M(1))) * den(159)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(57)*M(1)) * den(159)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(55)*M(1))) * den(160)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(57)*M(1)) * den(160)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,86)
  Gcoeff = (-(c(55)*M(1))) * den(161)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(58)*M(1))) * den(161)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(55)*M(1))) * den(162)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(58)*M(1))) * den(162)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(24)*M(1))) * den(159)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(24)*M(1)) * den(159)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,22)
  Gcoeff = (-(c(24)*M(1))) * den(160)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(24)*M(1)) * den(160)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(22)*M(1)) * den(161)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,24)
  Gcoeff = (-(c(22)*M(1))) * den(161)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(22)*M(1)) * den(162)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,25)
  Gcoeff = (-(c(22)*M(1))) * den(162)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,25)
  Gcoeff = (-(c(24)*M(1))) * den(159)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(24)*M(1)) * den(159)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,54)
  Gcoeff = (-(c(24)*M(1))) * den(160)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(24)*M(1)) * den(160)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,55)
  Gcoeff = (-(c(32)*M(1))) * den(161)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(32)*M(1)) * den(161)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,56)
  Gcoeff = (-(c(32)*M(1))) * den(162)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(32)*M(1)) * den(162)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,57)
  Gcoeff = (-(c(55)*M(1))) * den(163)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(57)*M(1)) * den(163)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(55)*M(1))) * den(164)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(58)*M(1))) * den(164)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(55)*M(1))) * den(165)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(57)*M(1)) * den(165)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,91)
  Gcoeff = (-(c(55)*M(1))) * den(166)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(58)*M(1))) * den(166)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(24)*M(1))) * den(163)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(24)*M(1)) * den(163)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(22)*M(1)) * den(164)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(22)*M(1))) * den(164)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(24)*M(1))) * den(165)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(24)*M(1)) * den(165)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(22)*M(1)) * den(166)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(22)*M(1))) * den(166)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(24)*M(1))) * den(163)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(24)*M(1)) * den(163)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,58)
  Gcoeff = (-(c(32)*M(1))) * den(164)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(32)*M(1)) * den(164)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,59)
  Gcoeff = (-(c(24)*M(1))) * den(165)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(24)*M(1)) * den(165)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,60)
  Gcoeff = (-(c(32)*M(1))) * den(166)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(32)*M(1)) * den(166)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,61)
  Gcoeff = (-(c(55)*M(1))) * den(167)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(57)*M(1)) * den(167)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,93)
  Gcoeff = (-(c(55)*M(1))) * den(168)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(58)*M(1))) * den(168)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(55)*M(1))) * den(169)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(57)*M(1)) * den(169)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,95)
  Gcoeff = (-(c(55)*M(1))) * den(170)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,64)
  Gcoeff = (-(c(58)*M(1))) * den(170)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,96)
  Gcoeff = (-(c(24)*M(1))) * den(167)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(24)*M(1)) * den(167)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(22)*M(1)) * den(168)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,31)
  Gcoeff = (-(c(22)*M(1))) * den(168)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,31)
  Gcoeff = (-(c(24)*M(1))) * den(169)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(24)*M(1)) * den(169)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(22)*M(1)) * den(170)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,33)
  Gcoeff = (-(c(22)*M(1))) * den(170)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,33)
  Gcoeff = (-(c(24)*M(1))) * den(167)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(24)*M(1)) * den(167)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,62)
  Gcoeff = (-(c(32)*M(1))) * den(168)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(32)*M(1)) * den(168)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,63)
  Gcoeff = (-(c(24)*M(1))) * den(169)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(24)*M(1)) * den(169)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,64)
  Gcoeff = (-(c(32)*M(1))) * den(170)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(32)*M(1)) * den(170)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(55)*M(1)) * den(171)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(57)*M(1))) * den(171)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(55)*M(1)) * den(172)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(58)*M(1)) * den(172)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(55)*M(1)) * den(173)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(57)*M(1))) * den(173)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(55)*M(1)) * den(174)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(58)*M(1)) * den(174)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(24)*M(1)) * den(171)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,34)
  Gcoeff = (-(c(24)*M(1))) * den(171)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,34)
  Gcoeff = (-(c(22)*M(1))) * den(172)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(22)*M(1)) * den(172)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(24)*M(1)) * den(173)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,36)
  Gcoeff = (-(c(24)*M(1))) * den(173)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,36)
  Gcoeff = (-(c(22)*M(1))) * den(174)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(22)*M(1)) * den(174)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(24)*M(1)) * den(171)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,66)
  Gcoeff = (-(c(24)*M(1))) * den(171)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(32)*M(1)) * den(172)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,67)
  Gcoeff = (-(c(32)*M(1))) * den(172)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(24)*M(1)) * den(173)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,68)
  Gcoeff = (-(c(24)*M(1))) * den(173)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(32)*M(1)) * den(174)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,69)
  Gcoeff = (-(c(32)*M(1))) * den(174)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(55)*M(1)) * den(175)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(57)*M(1))) * den(175)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(55)*M(1)) * den(176)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(57)*M(1))) * den(176)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(55)*M(1)) * den(177)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(58)*M(1)) * den(177)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(55)*M(1)) * den(178)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(58)*M(1)) * den(178)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(24)*M(1)) * den(175)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,38)
  Gcoeff = (-(c(24)*M(1))) * den(175)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(24)*M(1)) * den(176)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,39)
  Gcoeff = (-(c(24)*M(1))) * den(176)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,39)
  Gcoeff = (-(c(22)*M(1))) * den(177)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(22)*M(1)) * den(177)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,40)
  Gcoeff = (-(c(22)*M(1))) * den(178)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(22)*M(1)) * den(178)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(24)*M(1)) * den(175)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,70)
  Gcoeff = (-(c(24)*M(1))) * den(175)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(24)*M(1)) * den(176)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,71)
  Gcoeff = (-(c(24)*M(1))) * den(176)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(32)*M(1)) * den(177)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,72)
  Gcoeff = (-(c(32)*M(1))) * den(177)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(32)*M(1)) * den(178)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,73)
  Gcoeff = (-(c(32)*M(1))) * den(178)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,73)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_2_heftpph_ew_eeexexgg_1_/**/REALKIND
