
module ol_vamp_1_heftpph_ew_nmnmxeexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpph_ew_nmnmxeexgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpph_ew_nmnmxeexgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpph_ew_nmnmxeexgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpph_ew_nmnmxeexgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,108) :: G0
  complex(REALKIND), dimension(4,5,4,190) :: G1
  complex(REALKIND), dimension(4,15,4,32) :: G2
  complex(REALKIND), dimension(1,23) :: G0tensor
  complex(REALKIND), dimension(5,42) :: G1tensor
  complex(REALKIND), dimension(15,108) :: G2tensor
  complex(REALKIND), dimension(35,8) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ML,G1(:,:,:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,2),gH)
  call loop_A_Q(G1(:,:,:,2),Q(:,60),ML,G2(:,:,:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2),gZl)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),ML,G3tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),ML,G1(:,:,:,3))
  call loop_QS_A(G1(:,:,:,3),wf(:,3),G1(:,:,:,4),gH)
  call loop_Q_A(G1(:,:,:,4),Q(:,60),ML,G2(:,:,:,3))
  call loop_QZ_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4),gZl)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),ML,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MT,G1(:,:,:,5))
  call loop_AS_Q(G1(:,:,:,5),wf(:,3),G1(:,:,:,6),gH)
  call loop_A_Q(G1(:,:,:,6),Q(:,60),MT,G2(:,:,:,5))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MT,G1(:,:,:,7))
  call loop_QS_A(G1(:,:,:,7),wf(:,3),G1(:,:,:,8),gH)
  call loop_Q_A(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,7))
  call loop_QZ_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,6),gZl)
  call loop_A_Q(G0(:,:,:,6),Q(:,12),ML,G1(:,:,:,9))
  call loop_AS_Q(G1(:,:,:,9),wf(:,3),G1(:,:,:,10),gH)
  call loop_A_Q(G1(:,:,:,10),Q(:,60),ML,G2(:,:,:,9))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,10),gZl)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),ML,G3tensor(:,5))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,7),gZl)
  call loop_Q_A(G0(:,:,:,7),Q(:,12),ML,G1(:,:,:,11))
  call loop_QS_A(G1(:,:,:,11),wf(:,3),G1(:,:,:,12),gH)
  call loop_Q_A(G1(:,:,:,12),Q(:,60),ML,G2(:,:,:,11))
  call loop_QZ_A(G2(:,:,:,11),wf(:,1),G2(:,:,:,12),gZl)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),ML,G3tensor(:,6))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,12),MT,G1(:,:,:,13))
  call loop_AS_Q(G1(:,:,:,13),wf(:,3),G1(:,:,:,14),gH)
  call loop_A_Q(G1(:,:,:,14),Q(:,60),MT,G2(:,:,:,13))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,1),G2(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,7))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,9),gZu)
  call loop_Q_A(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,15))
  call loop_QS_A(G1(:,:,:,15),wf(:,3),G1(:,:,:,16),gH)
  call loop_Q_A(G1(:,:,:,16),Q(:,60),MT,G2(:,:,:,15))
  call loop_QZ_A(G2(:,:,:,15),wf(:,1),G2(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,8))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,17))
  call loop_SS_S(G1(:,:,:,17),wf(:,3),G1(:,:,:,18))
  call check_last_SV_T(l_switch,G1(:,:,:,18),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,1))
  call loop_ST_V(G1(:,:,:,17),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,17))
  call check_last_VV_S(l_switch,G2(:,:,:,17),wf(:,1),G2tensor(:,2))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,19))
  call loop_SS_S(G1(:,:,:,19),wf(:,3),G1(:,:,:,20))
  call check_last_TV_S(l_switch,G1(:,:,:,20),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,3))
  call loop_ST_V(G1(:,:,:,19),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,18))
  call check_last_VV_S(l_switch,G2(:,:,:,18),wf(:,1),G2tensor(:,4))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,21))
  call loop_SS_S(G1(:,:,:,21),wf(:,3),G1(:,:,:,22))
  call check_last_TV_S(l_switch,G1(:,:,:,22),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,5))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,23))
  call loop_SS_S(G1(:,:,:,23),wf(:,3),G1(:,:,:,24))
  call check_last_SV_T(l_switch,G1(:,:,:,24),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,6))
  call loop_ST_V(G1(:,:,:,23),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,19))
  call check_last_VV_S(l_switch,G2(:,:,:,19),wf(:,1),G2tensor(:,7))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,25))
  call loop_SS_S(G1(:,:,:,25),wf(:,3),G1(:,:,:,26))
  call check_last_SV_T(l_switch,G1(:,:,:,26),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,8))
  call loop_ST_V(G1(:,:,:,25),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,20))
  call check_last_VV_S(l_switch,G2(:,:,:,20),wf(:,1),G2tensor(:,9))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,27))
  call loop_SS_S(G1(:,:,:,27),wf(:,3),G1(:,:,:,28))
  call check_last_TV_S(l_switch,G1(:,:,:,28),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,10))
  call loop_ST_V(G1(:,:,:,27),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,21))
  call check_last_VV_S(l_switch,G2(:,:,:,21),wf(:,1),G2tensor(:,11))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,5),G1(:,:,:,29))
  call loop_SS_S(G1(:,:,:,29),wf(:,3),G1(:,:,:,30))
  call check_last_DV_C(l_switch,G1(:,:,:,30),Q(:,60),wf(:,1),G2tensor(:,12))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,31))
  call loop_SS_S(G1(:,:,:,31),wf(:,3),G1(:,:,:,32))
  call check_last_CV_D(l_switch,G1(:,:,:,32),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,13))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,33))
  call loop_SS_S(G1(:,:,:,33),wf(:,3),G1(:,:,:,34))
  call check_last_DV_C(l_switch,G1(:,:,:,34),Q(:,60),wf(:,1),G2tensor(:,14))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,35))
  call loop_SS_S(G1(:,:,:,35),wf(:,3),G1(:,:,:,36))
  call check_last_CV_D(l_switch,G1(:,:,:,36),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,15))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,37))
  call loop_VS_V(G1(:,:,:,37),wf(:,3),G1(:,:,:,38))
  call check_last_UW_V(l_switch,G1(:,:,:,38),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,16))
  call loop_VT_S(G1(:,:,:,37),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,22))
  call check_last_SV_V(l_switch,G2(:,:,:,22),wf(:,1),G2tensor(:,17))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,39))
  call loop_VS_V(G1(:,:,:,39),wf(:,3),G1(:,:,:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,40),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,18))
  call loop_VT_S(G1(:,:,:,39),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,23))
  call check_last_SV_V(l_switch,G2(:,:,:,23),wf(:,1),G2tensor(:,19))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,41))
  call loop_VS_V(G1(:,:,:,41),wf(:,3),G1(:,:,:,42))
  call check_last_UW_V(l_switch,G1(:,:,:,42),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,20))
  call loop_VT_S(G1(:,:,:,41),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,24))
  call check_last_SV_V(l_switch,G2(:,:,:,24),wf(:,1),G2tensor(:,21))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,43))
  call loop_VS_V(G1(:,:,:,43),wf(:,3),G1(:,:,:,44))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,22))
  call loop_VT_S(G1(:,:,:,43),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,25))
  call check_last_SV_V(l_switch,G2(:,:,:,25),wf(:,1),G2tensor(:,23))
  call loop_SV_V(G0(:,:,:,1),wf(:,5),G0(:,:,:,10))
  call loop_VT_S(G0(:,:,:,10),Q(:,12),wf(:,3),Q(:,48),G1(:,:,:,45))
  call check_last_SV_T(l_switch,G1(:,:,:,45),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,24))
  call check_last_TV_S(l_switch,G1(:,:,:,45),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,25))
  call loop_VS_V(G0(:,:,:,10),wf(:,3),G0(:,:,:,11))
  call check_last_VV_S(l_switch,G0(:,:,:,11),wf(:,1),G0tensor(:,1))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_VT_S(G0(:,:,:,12),Q(:,12),wf(:,3),Q(:,48),G1(:,:,:,46))
  call check_last_SV_T(l_switch,G1(:,:,:,46),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,26))
  call loop_VS_V(G0(:,:,:,12),wf(:,3),G0(:,:,:,13))
  call check_last_VV_S(l_switch,G0(:,:,:,13),wf(:,1),G0tensor(:,2))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,14))
  call loop_VT_S(G0(:,:,:,14),Q(:,12),wf(:,3),Q(:,48),G1(:,:,:,47))
  call check_last_SV_T(l_switch,G1(:,:,:,47),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,27))
  call check_last_TV_S(l_switch,G1(:,:,:,47),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,28))
  call loop_VS_V(G0(:,:,:,14),wf(:,3),G0(:,:,:,15))
  call check_last_VV_S(l_switch,G0(:,:,:,15),wf(:,1),G0tensor(:,3))
  call loop_VV_S(G0(:,:,:,1),wf(:,5),G0(:,:,:,16))
  call loop_SS_S(G0(:,:,:,16),wf(:,3),G0(:,:,:,17))
  call check_last_SV_V(l_switch,G0(:,:,:,17),wf(:,1),G0tensor(:,4))
  call loop_ST_V(G0(:,:,:,16),Q(:,12),wf(:,3),Q(:,48),G1(:,:,:,48))
  call check_last_UW_V(l_switch,G1(:,:,:,48),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,48),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,30))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,18))
  call loop_SS_S(G0(:,:,:,18),wf(:,3),G0(:,:,:,19))
  call check_last_SV_V(l_switch,G0(:,:,:,19),wf(:,1),G0tensor(:,5))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,20))
  call loop_SS_S(G0(:,:,:,20),wf(:,3),G0(:,:,:,21))
  call check_last_SV_V(l_switch,G0(:,:,:,21),wf(:,1),G0tensor(:,6))
  call loop_ST_V(G0(:,:,:,20),Q(:,12),wf(:,3),Q(:,48),G1(:,:,:,49))
  call check_last_UW_V(l_switch,G1(:,:,:,49),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,31))
  call check_last_UV_W(l_switch,G1(:,:,:,49),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,32))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-3),G0(:,:,:,22),gZl)
  call loop_VS_V(G0(:,:,:,22),wf(:,3),G0(:,:,:,23))
  call loop_ZQ_A(G0(:,:,:,23),wf(:,23),G0(:,:,:,24),gZl)
  call check_last_Q_A(l_switch,G0(:,:,:,24),Q(:,63),ZERO,G1tensor(:,1))
  call loop_QA_W(G0(:,:,:,1),wf(:,-3),G0(:,:,:,25))
  call loop_VS_V(G0(:,:,:,25),wf(:,3),G0(:,:,:,26))
  call loop_WQ_A(G0(:,:,:,26),wf(:,23),G0(:,:,:,27))
  call check_last_Q_A(l_switch,G0(:,:,:,27),Q(:,63),ZERO,G1tensor(:,2))
  call loop_UW_V(G0(:,:,:,25),Q(:,8),wf(:,19),Q(:,51),G1(:,:,:,50))
  call loop_WQ_A(G1(:,:,:,50),wf(:,-2),G1(:,:,:,51))
  call check_last_Q_A(l_switch,G1(:,:,:,51),Q(:,63),ZERO,G2tensor(:,33))
  call loop_QA_Z(G0(:,:,:,1),wf(:,25),G0(:,:,:,28),gZl)
  call loop_VS_V(G0(:,:,:,28),wf(:,3),G0(:,:,:,29))
  call loop_ZQ_A(G0(:,:,:,29),wf(:,-2),G0(:,:,:,30),gZl)
  call check_last_Q_A(l_switch,G0(:,:,:,30),Q(:,63),ZERO,G1tensor(:,3))
  call loop_QA_W(G0(:,:,:,1),wf(:,25),G0(:,:,:,31))
  call loop_VS_V(G0(:,:,:,31),wf(:,3),G0(:,:,:,32))
  call loop_WQ_A(G0(:,:,:,32),wf(:,-2),G0(:,:,:,33))
  call check_last_Q_A(l_switch,G0(:,:,:,33),Q(:,63),ZERO,G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,8),ZERO,G1(:,:,:,52))
  call loop_AZ_Q(G1(:,:,:,52),wf(:,19),G1(:,:,:,53),gZl)
  call loop_A_Q(G1(:,:,:,53),Q(:,59),ZERO,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,-2),G2tensor(:,34))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,35),gZl)
  call loop_A_Q(G0(:,:,:,35),Q(:,8),ZERO,G1(:,:,:,54))
  call loop_AZ_Q(G1(:,:,:,54),wf(:,19),G1(:,:,:,55),gZl)
  call loop_A_Q(G1(:,:,:,55),Q(:,59),ZERO,G2(:,:,:,27))
  call check_last_AQ_Z(l_switch,G2(:,:,:,27),wf(:,-2),G2tensor(:,35),gZl)
  call loop_WA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,8),ZERO,G1(:,:,:,56))
  call loop_AZ_Q(G1(:,:,:,56),wf(:,19),G1(:,:,:,57),gZn)
  call loop_A_Q(G1(:,:,:,57),Q(:,59),ZERO,G2(:,:,:,28))
  call check_last_AQ_W(l_switch,G2(:,:,:,28),wf(:,-2),G2tensor(:,36))
  call loop_AQ_W(G1(:,:,:,56),wf(:,-2),G1(:,:,:,58))
  call loop_VT_S(G1(:,:,:,58),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,29))
  call check_last_SV_V(l_switch,G2(:,:,:,29),wf(:,1),G2tensor(:,37))
  call loop_VS_V(G1(:,:,:,58),wf(:,3),G1(:,:,:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,38))
  call loop_WQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,4),ZERO,G1(:,:,:,60))
  call loop_QA_W(G1(:,:,:,60),wf(:,-3),G1(:,:,:,61))
  call loop_VT_S(G1(:,:,:,61),Q(:,12),wf(:,3),Q(:,48),G2(:,:,:,30))
  call check_last_SV_V(l_switch,G2(:,:,:,30),wf(:,1),G2tensor(:,39))
  call loop_VS_V(G1(:,:,:,61),wf(:,3),G1(:,:,:,62))
  call check_last_UW_V(l_switch,G1(:,:,:,62),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,40))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-2),G0(:,:,:,38),gZl)
  call loop_VS_V(G0(:,:,:,38),wf(:,3),G0(:,:,:,39))
  call loop_ZA_Q(G0(:,:,:,39),wf(:,-3),G0(:,:,:,40),gZl)
  call loop_A_Q(G0(:,:,:,40),Q(:,60),ZERO,G1(:,:,:,63))
  call loop_AZ_Q(G1(:,:,:,63),wf(:,1),G1(:,:,:,64),gZl)
  call check_last_A_Q(l_switch,G1(:,:,:,64),Q(:,63),ZERO,G2tensor(:,41))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-2),G0(:,:,:,41))
  call loop_VS_V(G0(:,:,:,41),wf(:,3),G0(:,:,:,42))
  call loop_WA_Q(G0(:,:,:,42),wf(:,-3),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,60),ZERO,G1(:,:,:,65))
  call loop_AZ_Q(G1(:,:,:,65),wf(:,1),G1(:,:,:,66),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,66),Q(:,63),ZERO,G2tensor(:,42))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,27),G0(:,:,:,44),gZn)
  call loop_VS_V(G0(:,:,:,44),wf(:,3),G0(:,:,:,45))
  call loop_ZA_Q(G0(:,:,:,45),wf(:,-1),G0(:,:,:,46),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,46),Q(:,63),ZERO,G1tensor(:,5))
  call loop_AQ_W(G0(:,:,:,1),wf(:,27),G0(:,:,:,47))
  call loop_VS_V(G0(:,:,:,47),wf(:,3),G0(:,:,:,48))
  call loop_WA_Q(G0(:,:,:,48),wf(:,-1),G0(:,:,:,49))
  call check_last_A_Q(l_switch,G0(:,:,:,49),Q(:,63),ZERO,G1tensor(:,6))
  call loop_QA_Z(G0(:,:,:,1),wf(:,29),G0(:,:,:,50),gZn)
  call loop_VS_V(G0(:,:,:,50),wf(:,3),G0(:,:,:,51))
  call loop_ZQ_A(G0(:,:,:,51),wf(:,0),G0(:,:,:,52),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,52),Q(:,63),ZERO,G1tensor(:,7))
  call loop_QA_W(G0(:,:,:,1),wf(:,29),G0(:,:,:,53))
  call loop_VS_V(G0(:,:,:,53),wf(:,3),G0(:,:,:,54))
  call loop_WQ_A(G0(:,:,:,54),wf(:,0),G0(:,:,:,55))
  call check_last_Q_A(l_switch,G0(:,:,:,55),Q(:,63),ZERO,G1tensor(:,8))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,56),gZn)
  call loop_A_Q(G0(:,:,:,56),Q(:,2),ZERO,G1(:,:,:,67))
  call loop_AZ_Q(G1(:,:,:,67),wf(:,14),G1(:,:,:,68),gZn)
  call loop_A_Q(G1(:,:,:,68),Q(:,62),ZERO,G2(:,:,:,31))
  call check_last_AQ_Z(l_switch,G2(:,:,:,31),wf(:,0),G2tensor(:,43),gZn)
  call loop_WA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,2),ZERO,G1(:,:,:,69))
  call loop_AZ_Q(G1(:,:,:,69),wf(:,14),G1(:,:,:,70),gZl)
  call loop_A_Q(G1(:,:,:,70),Q(:,62),ZERO,G2(:,:,:,32))
  call check_last_AQ_W(l_switch,G2(:,:,:,32),wf(:,0),G2tensor(:,44))
  call loop_QA_W(G0(:,:,:,1),wf(:,-1),G0(:,:,:,58))
  call loop_UV_W(G0(:,:,:,58),Q(:,2),wf(:,14),Q(:,60),G1(:,:,:,71))
  call loop_WQ_A(G1(:,:,:,71),wf(:,0),G1(:,:,:,72))
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,63),ZERO,G2tensor(:,45))
  call loop_VT_S(G0(:,:,:,58),Q(:,2),wf(:,3),Q(:,48),G1(:,:,:,73))
  call loop_SV_V(G1(:,:,:,73),wf(:,5),G1(:,:,:,74))
  call loop_WQ_A(G1(:,:,:,74),wf(:,0),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,63),ZERO,G2tensor(:,46))
  call loop_SV_V(G1(:,:,:,73),wf(:,2),G1(:,:,:,76))
  call loop_WQ_A(G1(:,:,:,76),wf(:,0),G1(:,:,:,77))
  call check_last_Q_A(l_switch,G1(:,:,:,77),Q(:,63),ZERO,G2tensor(:,47))
  call loop_VS_V(G0(:,:,:,58),wf(:,3),G0(:,:,:,59))
  call loop_UV_W(G0(:,:,:,59),Q(:,50),wf(:,5),Q(:,12),G1(:,:,:,78))
  call loop_WQ_A(G1(:,:,:,78),wf(:,0),G1(:,:,:,79))
  call check_last_Q_A(l_switch,G1(:,:,:,79),Q(:,63),ZERO,G2tensor(:,48))
  call loop_UV_W(G0(:,:,:,59),Q(:,50),wf(:,2),Q(:,12),G1(:,:,:,80))
  call loop_WQ_A(G1(:,:,:,80),wf(:,0),G1(:,:,:,81))
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,63),ZERO,G2tensor(:,49))
  call loop_WA_Q(G0(:,:,:,59),wf(:,-3),G0(:,:,:,60))
  call loop_A_Q(G0(:,:,:,60),Q(:,58),ZERO,G1(:,:,:,82))
  call loop_AQ_W(G1(:,:,:,82),wf(:,-2),G1(:,:,:,83))
  call loop_WQ_A(G1(:,:,:,83),wf(:,0),G1(:,:,:,84))
  call check_last_Q_A(l_switch,G1(:,:,:,84),Q(:,63),ZERO,G2tensor(:,50))
  call loop_VV_S(G0(:,:,:,58),wf(:,5),G0(:,:,:,61))
  call loop_ST_V(G0(:,:,:,61),Q(:,14),wf(:,3),Q(:,48),G1(:,:,:,85))
  call loop_WQ_A(G1(:,:,:,85),wf(:,0),G1(:,:,:,86))
  call check_last_Q_A(l_switch,G1(:,:,:,86),Q(:,63),ZERO,G2tensor(:,51))
  call loop_VV_S(G0(:,:,:,58),wf(:,2),G0(:,:,:,62))
  call loop_ST_V(G0(:,:,:,62),Q(:,14),wf(:,3),Q(:,48),G1(:,:,:,87))
  call loop_WQ_A(G1(:,:,:,87),wf(:,0),G1(:,:,:,88))
  call check_last_Q_A(l_switch,G1(:,:,:,88),Q(:,63),ZERO,G2tensor(:,52))
  call loop_UV_W(G0(:,:,:,58),Q(:,2),wf(:,5),Q(:,12),G1(:,:,:,89))
  call loop_VS_V(G1(:,:,:,89),wf(:,3),G1(:,:,:,90))
  call loop_WQ_A(G1(:,:,:,90),wf(:,0),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,63),ZERO,G2tensor(:,53))
  call loop_UV_W(G0(:,:,:,58),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,92))
  call loop_VS_V(G1(:,:,:,92),wf(:,3),G1(:,:,:,93))
  call loop_WQ_A(G1(:,:,:,93),wf(:,0),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),ZERO,G2tensor(:,54))
  call loop_WA_Q(G0(:,:,:,58),wf(:,-3),G0(:,:,:,63))
  call loop_A_Q(G0(:,:,:,63),Q(:,10),ZERO,G1(:,:,:,95))
  call loop_AQ_W(G1(:,:,:,95),wf(:,-2),G1(:,:,:,96))
  call loop_VS_V(G1(:,:,:,96),wf(:,3),G1(:,:,:,97))
  call loop_WQ_A(G1(:,:,:,97),wf(:,0),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,63),ZERO,G2tensor(:,55))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,64))
  call loop_Q_A(G0(:,:,:,64),Q(:,12),ZERO,G1(:,:,:,99))
  call loop_QA_W(G1(:,:,:,99),wf(:,-1),G1(:,:,:,100))
  call loop_VS_V(G1(:,:,:,100),wf(:,3),G1(:,:,:,101))
  call loop_WQ_A(G1(:,:,:,101),wf(:,0),G1(:,:,:,102))
  call check_last_Q_A(l_switch,G1(:,:,:,102),Q(:,63),ZERO,G2tensor(:,56))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,65),gZn)
  call loop_Q_A(G0(:,:,:,65),Q(:,12),ZERO,G1(:,:,:,103))
  call loop_QA_Z(G1(:,:,:,103),wf(:,-1),G1(:,:,:,104),gZn)
  call loop_VS_V(G1(:,:,:,104),wf(:,3),G1(:,:,:,105))
  call loop_ZQ_A(G1(:,:,:,105),wf(:,0),G1(:,:,:,106),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),ZERO,G2tensor(:,57))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,66),gZl)
  call loop_Q_A(G0(:,:,:,66),Q(:,12),ZERO,G1(:,:,:,107))
  call loop_QA_W(G1(:,:,:,107),wf(:,-1),G1(:,:,:,108))
  call loop_VS_V(G1(:,:,:,108),wf(:,3),G1(:,:,:,109))
  call loop_WQ_A(G1(:,:,:,109),wf(:,0),G1(:,:,:,110))
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,63),ZERO,G2tensor(:,58))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-1),G0(:,:,:,67),gZn)
  call loop_VS_V(G0(:,:,:,67),wf(:,3),G0(:,:,:,68))
  call loop_ZA_Q(G0(:,:,:,68),wf(:,-3),G0(:,:,:,69),gZl)
  call loop_A_Q(G0(:,:,:,69),Q(:,58),ZERO,G1(:,:,:,111))
  call loop_AQ_Z(G1(:,:,:,111),wf(:,-2),G1(:,:,:,112),gZl)
  call loop_ZQ_A(G1(:,:,:,112),wf(:,0),G1(:,:,:,113),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,63),ZERO,G2tensor(:,59))
  call loop_ZQ_A(G0(:,:,:,68),wf(:,-2),G0(:,:,:,70),gZl)
  call loop_Q_A(G0(:,:,:,70),Q(:,54),ZERO,G1(:,:,:,114))
  call loop_QA_Z(G1(:,:,:,114),wf(:,-3),G1(:,:,:,115),gZl)
  call loop_ZQ_A(G1(:,:,:,115),wf(:,0),G1(:,:,:,116),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,116),Q(:,63),ZERO,G2tensor(:,60))
  call loop_ZQ_A(G0(:,:,:,67),wf(:,-2),G0(:,:,:,71),gZl)
  call loop_Q_A(G0(:,:,:,71),Q(:,6),ZERO,G1(:,:,:,117))
  call loop_QA_Z(G1(:,:,:,117),wf(:,-3),G1(:,:,:,118),gZl)
  call loop_VS_V(G1(:,:,:,118),wf(:,3),G1(:,:,:,119))
  call loop_ZQ_A(G1(:,:,:,119),wf(:,0),G1(:,:,:,120),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,63),ZERO,G2tensor(:,61))
  call loop_ZA_Q(G0(:,:,:,67),wf(:,-3),G0(:,:,:,72),gZl)
  call loop_A_Q(G0(:,:,:,72),Q(:,10),ZERO,G1(:,:,:,121))
  call loop_AQ_Z(G1(:,:,:,121),wf(:,-2),G1(:,:,:,122),gZl)
  call loop_VS_V(G1(:,:,:,122),wf(:,3),G1(:,:,:,123))
  call loop_ZQ_A(G1(:,:,:,123),wf(:,0),G1(:,:,:,124),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,63),ZERO,G2tensor(:,62))
  call loop_VVS_S(G0(:,:,:,1),wf(:,5),wf(:,3),G0(:,:,:,73))
  call check_last_SV_V(l_switch,G0(:,:,:,73),wf(:,1),G0tensor(:,7))
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,74))
  call check_last_SV_V(l_switch,G0(:,:,:,74),wf(:,1),G0tensor(:,8))
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,75))
  call check_last_SV_V(l_switch,G0(:,:,:,75),wf(:,1),G0tensor(:,9))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,76))
  call check_last_SV_V(l_switch,G0(:,:,:,76),wf(:,5),G0tensor(:,10))
  call check_last_SV_V(l_switch,G0(:,:,:,76),wf(:,2),G0tensor(:,11))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,77))
  call check_last_SV_V(l_switch,G0(:,:,:,77),wf(:,2),G0tensor(:,12))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,78))
  call check_last_SVV_S(l_switch,G0(:,:,:,78),wf(:,1),wf(:,5),G0tensor(:,13))
  call check_last_SVV_S(l_switch,G0(:,:,:,78),wf(:,1),wf(:,2),G0tensor(:,14))
  call check_last_TV_S(l_switch,G0(:,:,:,78),Q(:,48),wf(:,30),Q(:,15),G1tensor(:,9))
  call check_last_TV_S(l_switch,G0(:,:,:,78),Q(:,48),wf(:,31),Q(:,15),G1tensor(:,10))
  call check_last_TV_S(l_switch,G0(:,:,:,78),Q(:,48),wf(:,32),Q(:,15),G1tensor(:,11))
  call check_last_TV_S(l_switch,G0(:,:,:,78),Q(:,48),wf(:,33),Q(:,15),G1tensor(:,12))
  call check_last_TV_S(l_switch,G0(:,:,:,78),Q(:,48),wf(:,34),Q(:,15),G1tensor(:,13))
  call check_last_TV_S(l_switch,G0(:,:,:,78),Q(:,48),wf(:,35),Q(:,15),G1tensor(:,14))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,79))
  call check_last_SVV_S(l_switch,G0(:,:,:,79),wf(:,1),wf(:,2),G0tensor(:,15))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,80))
  call check_last_SVV_S(l_switch,G0(:,:,:,80),wf(:,1),wf(:,2),G0tensor(:,16))
  call loop_VS_V(G0(:,:,:,1),wf(:,3),G0(:,:,:,81))
  call check_last_VWW_V(l_switch,G0(:,:,:,81),wf(:,1),wf(:,5),G0tensor(:,17))
  call check_last_VWW_V(l_switch,G0(:,:,:,81),wf(:,1),wf(:,2),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,48),wf(:,30),Q(:,15),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,48),wf(:,31),Q(:,15),G1tensor(:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,48),wf(:,32),Q(:,15),G1tensor(:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,48),wf(:,33),Q(:,15),G1tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,48),wf(:,34),Q(:,15),G1tensor(:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,48),wf(:,35),Q(:,15),G1tensor(:,20))
  call loop_QS_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,82),gX)
  call loop_Q_A(G0(:,:,:,82),Q(:,51),ML,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,5),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,63),ML,G2tensor(:,63))
  call loop_QZ_A(G1(:,:,:,125),wf(:,2),G1(:,:,:,127),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,63),ML,G2tensor(:,64))
  call loop_QS_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,83),gX)
  call loop_Q_A(G0(:,:,:,83),Q(:,51),MT,G1(:,:,:,128))
  call loop_QV_A(G1(:,:,:,128),wf(:,5),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),MT,G2tensor(:,65))
  call loop_QZ_A(G1(:,:,:,128),wf(:,2),G1(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),MT,G2tensor(:,66))
  call loop_SS_S(G0(:,:,:,1),wf(:,16),G0(:,:,:,84))
  call check_last_TV_S(l_switch,G0(:,:,:,84),Q(:,51),wf(:,2),Q(:,12),G1tensor(:,21))
  call loop_SS_S(G0(:,:,:,1),wf(:,16),G0(:,:,:,85))
  call check_last_CV_D(l_switch,G0(:,:,:,85),Q(:,51),wf(:,5),Q(:,12),G1tensor(:,22))
  call check_last_CV_D(l_switch,G0(:,:,:,85),Q(:,51),wf(:,2),Q(:,12),G1tensor(:,23))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,51),G1(:,:,:,131))
  call check_last_SV_V(l_switch,G1(:,:,:,131),wf(:,5),G1tensor(:,24))
  call check_last_SV_V(l_switch,G1(:,:,:,131),wf(:,2),G1tensor(:,25))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,51),G1(:,:,:,132))
  call check_last_SV_V(l_switch,G1(:,:,:,132),wf(:,2),G1tensor(:,26))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,86),gZl)
  call loop_Q_A(G0(:,:,:,86),Q(:,51),ZERO,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,5),G1(:,:,:,134))
  call check_last_Q_A(l_switch,G1(:,:,:,134),Q(:,63),ZERO,G2tensor(:,67))
  call loop_QZ_A(G1(:,:,:,133),wf(:,2),G1(:,:,:,135),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,135),Q(:,63),ZERO,G2tensor(:,68))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,87),gZl)
  call loop_Q_A(G0(:,:,:,87),Q(:,51),ML,G1(:,:,:,136))
  call loop_QV_A(G1(:,:,:,136),wf(:,5),G1(:,:,:,137))
  call check_last_Q_A(l_switch,G1(:,:,:,137),Q(:,63),ML,G2tensor(:,69))
  call loop_QZ_A(G1(:,:,:,136),wf(:,2),G1(:,:,:,138),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,138),Q(:,63),ML,G2tensor(:,70))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,88),gZu)
  call loop_Q_A(G0(:,:,:,88),Q(:,51),ZERO,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,5),G1(:,:,:,140))
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,63),ZERO,G2tensor(:,71))
  call loop_QZ_A(G1(:,:,:,139),wf(:,2),G1(:,:,:,141),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,141),Q(:,63),ZERO,G2tensor(:,72))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,89),gZu)
  call loop_Q_A(G0(:,:,:,89),Q(:,51),MT,G1(:,:,:,142))
  call loop_QV_A(G1(:,:,:,142),wf(:,5),G1(:,:,:,143))
  call check_last_Q_A(l_switch,G1(:,:,:,143),Q(:,63),MT,G2tensor(:,73))
  call loop_QZ_A(G1(:,:,:,142),wf(:,2),G1(:,:,:,144),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,144),Q(:,63),MT,G2tensor(:,74))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,90),gZd)
  call loop_Q_A(G0(:,:,:,90),Q(:,51),ZERO,G1(:,:,:,145))
  call loop_QV_A(G1(:,:,:,145),wf(:,5),G1(:,:,:,146))
  call check_last_Q_A(l_switch,G1(:,:,:,146),Q(:,63),ZERO,G2tensor(:,75))
  call loop_QZ_A(G1(:,:,:,145),wf(:,2),G1(:,:,:,147),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,147),Q(:,63),ZERO,G2tensor(:,76))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,91),gZn)
  call loop_Q_A(G0(:,:,:,91),Q(:,51),ZERO,G1(:,:,:,148))
  call loop_QZ_A(G1(:,:,:,148),wf(:,2),G1(:,:,:,149),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,149),Q(:,63),ZERO,G2tensor(:,77))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,51),G1(:,:,:,150))
  call check_last_TV_S(l_switch,G1(:,:,:,150),Q(:,51),wf(:,5),Q(:,12),G2tensor(:,78))
  call check_last_TV_S(l_switch,G1(:,:,:,150),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,79))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,51),G1(:,:,:,151))
  call check_last_TV_S(l_switch,G1(:,:,:,151),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,80))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,51),G1(:,:,:,152))
  call check_last_CV_D(l_switch,G1(:,:,:,152),Q(:,51),wf(:,5),Q(:,12),G2tensor(:,81))
  call check_last_CV_D(l_switch,G1(:,:,:,152),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,82))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,51),G1(:,:,:,153))
  call check_last_UV_W(l_switch,G1(:,:,:,153),Q(:,51),wf(:,5),Q(:,12),G2tensor(:,83))
  call check_last_UV_W(l_switch,G1(:,:,:,153),Q(:,51),wf(:,2),Q(:,12),G2tensor(:,84))
  call loop_VV_S(G0(:,:,:,1),wf(:,19),G0(:,:,:,92))
  call check_last_SV_V(l_switch,G0(:,:,:,92),wf(:,5),G0tensor(:,19))
  call check_last_SV_V(l_switch,G0(:,:,:,92),wf(:,2),G0tensor(:,20))
  call loop_VV_S(G0(:,:,:,1),wf(:,19),G0(:,:,:,93))
  call check_last_SV_V(l_switch,G0(:,:,:,93),wf(:,2),G0tensor(:,21))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,94),gX)
  call loop_Q_A(G0(:,:,:,94),Q(:,60),ML,G1(:,:,:,154))
  call loop_QZ_A(G1(:,:,:,154),wf(:,1),G1(:,:,:,155),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,155),Q(:,63),ML,G2tensor(:,85))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,95),gX)
  call loop_Q_A(G0(:,:,:,95),Q(:,60),MT,G1(:,:,:,156))
  call loop_QZ_A(G1(:,:,:,156),wf(:,1),G1(:,:,:,157),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,157),Q(:,63),MT,G2tensor(:,86))
  call loop_SS_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,96))
  call check_last_TV_S(l_switch,G0(:,:,:,96),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,27))
  call loop_SS_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,97))
  call check_last_CV_D(l_switch,G0(:,:,:,97),Q(:,60),wf(:,1),Q(:,3),G1tensor(:,28))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,60),G1(:,:,:,158))
  call check_last_SV_V(l_switch,G1(:,:,:,158),wf(:,1),G1tensor(:,29))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,60),G1(:,:,:,159))
  call check_last_SV_V(l_switch,G1(:,:,:,159),wf(:,1),G1tensor(:,30))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,98),gZn)
  call loop_Q_A(G0(:,:,:,98),Q(:,60),ZERO,G1(:,:,:,160))
  call loop_QZ_A(G1(:,:,:,160),wf(:,1),G1(:,:,:,161),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,161),Q(:,63),ZERO,G2tensor(:,87))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,99),gZl)
  call loop_Q_A(G0(:,:,:,99),Q(:,60),ZERO,G1(:,:,:,162))
  call loop_QZ_A(G1(:,:,:,162),wf(:,1),G1(:,:,:,163),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,163),Q(:,63),ZERO,G2tensor(:,88))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,100),gZl)
  call loop_Q_A(G0(:,:,:,100),Q(:,60),ML,G1(:,:,:,164))
  call loop_QZ_A(G1(:,:,:,164),wf(:,1),G1(:,:,:,165),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,165),Q(:,63),ML,G2tensor(:,89))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,101),gZu)
  call loop_Q_A(G0(:,:,:,101),Q(:,60),ZERO,G1(:,:,:,166))
  call loop_QZ_A(G1(:,:,:,166),wf(:,1),G1(:,:,:,167),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,167),Q(:,63),ZERO,G2tensor(:,90))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,102),gZu)
  call loop_Q_A(G0(:,:,:,102),Q(:,60),MT,G1(:,:,:,168))
  call loop_QZ_A(G1(:,:,:,168),wf(:,1),G1(:,:,:,169),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,169),Q(:,63),MT,G2tensor(:,91))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,103),gZd)
  call loop_Q_A(G0(:,:,:,103),Q(:,60),ZERO,G1(:,:,:,170))
  call loop_QZ_A(G1(:,:,:,170),wf(:,1),G1(:,:,:,171),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,171),Q(:,63),ZERO,G2tensor(:,92))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,60),G1(:,:,:,172))
  call check_last_TV_S(l_switch,G1(:,:,:,172),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,93))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,60),G1(:,:,:,173))
  call check_last_TV_S(l_switch,G1(:,:,:,173),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,94))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,60),G1(:,:,:,174))
  call check_last_CV_D(l_switch,G1(:,:,:,174),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,95))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,60),G1(:,:,:,175))
  call check_last_UV_W(l_switch,G1(:,:,:,175),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,96))
  call loop_VV_S(G0(:,:,:,1),wf(:,14),G0(:,:,:,104))
  call check_last_SV_V(l_switch,G0(:,:,:,104),wf(:,1),G0tensor(:,22))
  call loop_VV_S(G0(:,:,:,1),wf(:,14),G0(:,:,:,105))
  call check_last_SV_V(l_switch,G0(:,:,:,105),wf(:,1),G0tensor(:,23))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,106),gH)
  call loop_Q_A(G0(:,:,:,106),Q(:,48),ML,G1(:,:,:,176))
  call loop_QV_A(G1(:,:,:,176),wf(:,30),G1(:,:,:,177))
  call check_last_Q_A(l_switch,G1(:,:,:,177),Q(:,63),ML,G2tensor(:,97))
  call loop_QZ_A(G1(:,:,:,176),wf(:,31),G1(:,:,:,178),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,178),Q(:,63),ML,G2tensor(:,98))
  call loop_QV_A(G1(:,:,:,176),wf(:,32),G1(:,:,:,179))
  call check_last_Q_A(l_switch,G1(:,:,:,179),Q(:,63),ML,G2tensor(:,99))
  call loop_QZ_A(G1(:,:,:,176),wf(:,33),G1(:,:,:,180),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,180),Q(:,63),ML,G2tensor(:,100))
  call loop_QZ_A(G1(:,:,:,176),wf(:,34),G1(:,:,:,181),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,63),ML,G2tensor(:,101))
  call loop_QZ_A(G1(:,:,:,176),wf(:,35),G1(:,:,:,182),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,182),Q(:,63),ML,G2tensor(:,102))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,107),gH)
  call loop_Q_A(G0(:,:,:,107),Q(:,48),MT,G1(:,:,:,183))
  call loop_QV_A(G1(:,:,:,183),wf(:,30),G1(:,:,:,184))
  call check_last_Q_A(l_switch,G1(:,:,:,184),Q(:,63),MT,G2tensor(:,103))
  call loop_QZ_A(G1(:,:,:,183),wf(:,31),G1(:,:,:,185),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,63),MT,G2tensor(:,104))
  call loop_QV_A(G1(:,:,:,183),wf(:,32),G1(:,:,:,186))
  call check_last_Q_A(l_switch,G1(:,:,:,186),Q(:,63),MT,G2tensor(:,105))
  call loop_QZ_A(G1(:,:,:,183),wf(:,33),G1(:,:,:,187),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,187),Q(:,63),MT,G2tensor(:,106))
  call loop_QZ_A(G1(:,:,:,183),wf(:,34),G1(:,:,:,188),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,188),Q(:,63),MT,G2tensor(:,107))
  call loop_QZ_A(G1(:,:,:,183),wf(:,35),G1(:,:,:,189),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,189),Q(:,63),MT,G2tensor(:,108))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,108))
  call check_last_CV_D(l_switch,G0(:,:,:,108),Q(:,48),wf(:,30),Q(:,15),G1tensor(:,31))
  call check_last_CV_D(l_switch,G0(:,:,:,108),Q(:,48),wf(:,31),Q(:,15),G1tensor(:,32))
  call check_last_CV_D(l_switch,G0(:,:,:,108),Q(:,48),wf(:,32),Q(:,15),G1tensor(:,33))
  call check_last_CV_D(l_switch,G0(:,:,:,108),Q(:,48),wf(:,33),Q(:,15),G1tensor(:,34))
  call check_last_CV_D(l_switch,G0(:,:,:,108),Q(:,48),wf(:,34),Q(:,15),G1tensor(:,35))
  call check_last_CV_D(l_switch,G0(:,:,:,108),Q(:,48),wf(:,35),Q(:,15),G1tensor(:,36))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,48),G1(:,:,:,190))
  call check_last_SV_V(l_switch,G1(:,:,:,190),wf(:,30),G1tensor(:,37))
  call check_last_SV_V(l_switch,G1(:,:,:,190),wf(:,31),G1tensor(:,38))
  call check_last_SV_V(l_switch,G1(:,:,:,190),wf(:,32),G1tensor(:,39))
  call check_last_SV_V(l_switch,G1(:,:,:,190),wf(:,33),G1tensor(:,40))
  call check_last_SV_V(l_switch,G1(:,:,:,190),wf(:,34),G1tensor(:,41))
  call check_last_SV_V(l_switch,G1(:,:,:,190),wf(:,35),G1tensor(:,42))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(52)*M(1))) * den(34)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(52)*M(1))) * den(34)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(53)*M(1)) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(53)*M(1)) * den(34)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(52)*M(1))) * den(35)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(52)*M(1))) * den(35)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(54)*M(1))) * den(35)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(54)*M(1))) * den(35)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(39)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(39)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(18)*M(1))) * den(35)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(17)*M(1))) * den(35)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(35)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(35)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(22)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(22)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(22)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(22)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(14)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(14)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(14)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(14)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(23)*M(1))) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(23)*M(1))) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(15)*M(1)) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(15)*M(1)) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(38)*M(1))) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(38)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(11)*M(1))) * den(35)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(33)*M(1)) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(33)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(29)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(29)*M(1))) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(11)*M(1))) * den(35)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(33)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(33)*M(1)) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(30)*M(1))) * den(34)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,4)
  Gcoeff = (-(c(30)*M(1))) * den(34)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,4)
  Gcoeff = (-(c(16)*M(1))) * den(35)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,5)
  Gcoeff = (-(c(2)*M(1))) * den(35)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(2)*M(1))) * den(35)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(32)*M(1))) * den(34)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(32)*M(1))) * den(34)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(19)*M(1))) * den(35)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(4)*M(1))) * den(35)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(4)*M(1))) * den(35)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(29)*M(1))) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(29)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(24)*M(1)) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(24)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(22)*M(1))) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(22)*M(1)) * den(34)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(24)*M(1))) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(24)*M(1)) * den(35)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(27)*M(1)) * den(36)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(9)*M(1)) * den(36)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(27)*M(1)) * den(37)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(9)*M(1)) * den(37)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(27)*M(1)) * den(15)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(27)*M(1)) * den(15)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(13)*M(1)) * den(15)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(6)*M(1)) * den(15)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(20)*M(1)) * den(13)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(7)*M(1)) * den(13)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(20)*M(1))) * den(13)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(7)*M(1)) * den(13)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(27)*M(1)) * den(13)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(9)*M(1)) * den(13)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(27)*M(1)) * den(38)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(9)*M(1)) * den(38)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(27)*M(1)) * den(39)
  T1sum(1:5,7) = T1sum(1:5,7) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(9)*M(1)) * den(39)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(27)*M(1)) * den(11)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(13)*M(1)) * den(11)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(6)*M(1)) * den(11)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(8)*M(1))) * den(40)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(20)*M(1))) * den(9)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(9)*M(1))) * den(40)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(7)*M(1)) * den(9)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(8)*M(1)) * den(40)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(20)*M(1)) * den(9)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(9)*M(1))) * den(40)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(7)*M(1)) * den(9)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(9)*M(1)) * den(40)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(27)*M(1)) * den(9)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(9)*M(1)) * den(9)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(27)*M(1)) * den(3)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(5)*M(1)) * den(3)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(27)*M(1)) * den(3)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(27)*M(1)) * den(3)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(27)*M(1)) * den(3)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(5)*M(1)) * den(3)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(29)*M(1))) * den(41)
  T2sum(1:1,25) = T2sum(1:1,25) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(29)*M(1))) * den(41)
  T2sum(1:1,25) = T2sum(1:1,25) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(12)*M(1))) * den(42)
  T2sum(1:1,26) = T2sum(1:1,26) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(1)*M(1))) * den(42)
  T2sum(1:1,25) = T2sum(1:1,25) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(1)*M(1))) * den(42)
  T2sum(1:1,25) = T2sum(1:1,25) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(29)*M(1))) * den(43)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(29)*M(1))) * den(43)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(12)*M(1))) * den(44)
  T2sum(1:1,28) = T2sum(1:1,28) + Gcoeff * G0tensor(:,12)
  Gcoeff = (-(c(1)*M(1))) * den(44)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(1)*M(1))) * den(44)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(40)*M(1))) * den(8)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,13)
  Gcoeff = (-(c(18)*M(1))) * den(5)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,15)
  Gcoeff = (-(c(17)*M(1))) * den(5)
  T0sum(1:1,2) = T0sum(1:1,2) + Gcoeff * G0tensor(:,16)
  Gcoeff = (c(36)*M(1)) * den(5)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(23)*M(1)) * den(8)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,17)
  Gcoeff = (-(c(15)*M(1))) * den(5)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(41)*M(1)) * den(16)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(42)*M(1)) * den(16)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(41)*M(1)) * den(17)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,64)
  Gcoeff = (-(c(43)*M(1))) * den(17)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(17)*M(1))) * den(17)
  T2sum(1:5,28) = T2sum(1:5,28) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(20)*M(1)) * den(16)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(20)*M(1)) * den(16)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,22)
  Gcoeff = (-(c(8)*M(1))) * den(17)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(8)*M(1))) * den(17)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(20)*M(1)) * den(16)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(20)*M(1)) * den(16)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,24)
  Gcoeff = (-(c(11)*M(1))) * den(17)
  T2sum(1:5,28) = T2sum(1:5,28) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(26)*M(1)) * den(17)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(26)*M(1)) * den(17)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,25)
  Gcoeff = (-(c(48)*M(1))) * den(16)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(45)*M(1))) * den(16)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(47)*M(1)) * den(16)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(44)*M(1)) * den(16)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(46)*M(1))) * den(16)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(50)*M(1))) * den(17)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(48)*M(1))) * den(17)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(45)*M(1))) * den(17)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(49)*M(1))) * den(17)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(46)*M(1))) * den(17)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(51)*M(1))) * den(17)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(37)*M(1)) * den(16)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(11)*M(1))) * den(17)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(34)*M(1))) * den(17)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(21)*M(1)) * den(16)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(21)*M(1)) * den(16)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(10)*M(1))) * den(17)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(10)*M(1))) * den(17)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(21)*M(1))) * den(16)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(10)*M(1)) * den(17)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(31)*M(1))) * den(16)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,19)
  Gcoeff = (-(c(31)*M(1))) * den(16)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,19)
  Gcoeff = (-(c(19)*M(1))) * den(17)
  T2sum(1:1,28) = T2sum(1:1,28) + Gcoeff * G0tensor(:,21)
  Gcoeff = (-(c(3)*M(1))) * den(17)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,20)
  Gcoeff = (-(c(3)*M(1))) * den(17)
  T2sum(1:1,27) = T2sum(1:1,27) + Gcoeff * G0tensor(:,20)
  Gcoeff = (c(41)*M(1)) * den(12)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(43)*M(1))) * den(12)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,86)
  Gcoeff = (-(c(17)*M(1))) * den(12)
  T2sum(1:5,26) = T2sum(1:5,26) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(8)*M(1))) * den(12)
  T2sum(1:5,25) = T2sum(1:5,25) + Gcoeff * G1tensor(:,28)
  Gcoeff = (-(c(8)*M(1))) * den(12)
  T2sum(1:5,25) = T2sum(1:5,25) + Gcoeff * G1tensor(:,28)
  Gcoeff = (-(c(11)*M(1))) * den(12)
  T2sum(1:5,26) = T2sum(1:5,26) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(26)*M(1)) * den(12)
  T2sum(1:5,25) = T2sum(1:5,25) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(26)*M(1)) * den(12)
  T2sum(1:5,25) = T2sum(1:5,25) + Gcoeff * G1tensor(:,30)
  Gcoeff = (-(c(50)*M(1))) * den(12)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(48)*M(1))) * den(12)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(45)*M(1))) * den(12)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(49)*M(1))) * den(12)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(46)*M(1))) * den(12)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,91)
  Gcoeff = (-(c(51)*M(1))) * den(12)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(11)*M(1))) * den(12)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,93)
  Gcoeff = (-(c(34)*M(1))) * den(12)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(10)*M(1))) * den(12)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,95)
  Gcoeff = (-(c(10)*M(1))) * den(12)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(10)*M(1)) * den(12)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,96)
  Gcoeff = (-(c(19)*M(1))) * den(12)
  T2sum(1:1,26) = T2sum(1:1,26) + Gcoeff * G0tensor(:,22)
  Gcoeff = (-(c(3)*M(1))) * den(12)
  T2sum(1:1,25) = T2sum(1:1,25) + Gcoeff * G0tensor(:,23)
  Gcoeff = (-(c(3)*M(1))) * den(12)
  T2sum(1:1,25) = T2sum(1:1,25) + Gcoeff * G0tensor(:,23)
  Gcoeff = (-(c(52)*M(1))) * den(45)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(53)*M(1)) * den(45)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,103)
  Gcoeff = (-(c(52)*M(1))) * den(46)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(54)*M(1))) * den(46)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,104)
  Gcoeff = (-(c(28)*M(1))) * den(45)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(39)*M(1))) * den(46)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(24)*M(1))) * den(45)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(24)*M(1)) * den(45)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(22)*M(1)) * den(46)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,32)
  Gcoeff = (-(c(22)*M(1))) * den(46)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,32)
  Gcoeff = (-(c(25)*M(1))) * den(45)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(23)*M(1)) * den(46)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(24)*M(1))) * den(45)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(24)*M(1)) * den(45)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,37)
  Gcoeff = (-(c(29)*M(1))) * den(46)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(29)*M(1)) * den(46)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,38)
  Gcoeff = (-(c(52)*M(1))) * den(47)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(53)*M(1)) * den(47)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(52)*M(1))) * den(48)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,100)
  Gcoeff = (-(c(54)*M(1))) * den(48)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(28)*M(1))) * den(47)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(39)*M(1))) * den(48)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(24)*M(1))) * den(47)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(24)*M(1)) * den(47)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(22)*M(1)) * den(48)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,34)
  Gcoeff = (-(c(22)*M(1))) * den(48)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,34)
  Gcoeff = (-(c(25)*M(1))) * den(47)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(23)*M(1)) * den(48)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(24)*M(1))) * den(47)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(24)*M(1)) * den(47)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,39)
  Gcoeff = (-(c(29)*M(1))) * den(48)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(29)*M(1)) * den(48)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,40)
  Gcoeff = (-(c(52)*M(1))) * den(49)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,101)
  Gcoeff = (-(c(54)*M(1))) * den(49)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,107)
  Gcoeff = (-(c(39)*M(1))) * den(49)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(22)*M(1)) * den(49)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,35)
  Gcoeff = (-(c(22)*M(1))) * den(49)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(23)*M(1)) * den(49)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(29)*M(1))) * den(49)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(29)*M(1)) * den(49)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,41)
  Gcoeff = (-(c(52)*M(1))) * den(50)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,102)
  Gcoeff = (-(c(54)*M(1))) * den(50)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,108)
  Gcoeff = (-(c(39)*M(1))) * den(50)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(22)*M(1)) * den(50)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,36)
  Gcoeff = (-(c(22)*M(1))) * den(50)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(23)*M(1)) * den(50)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(29)*M(1))) * den(50)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(29)*M(1)) * den(50)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,42)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_heftpph_ew_nmnmxeexgg_1_/**/REALKIND
