
module ol_vamp_1_heftpph_ew_nexnmemxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpph_ew_nexnmemxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpph_ew_nexnmemxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpph_ew_nexnmemxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpph_ew_nexnmemxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,101) :: G0
  complex(REALKIND), dimension(4,5,4,174) :: G1
  complex(REALKIND), dimension(4,15,4,20) :: G2
  complex(REALKIND), dimension(1,22) :: G0tensor
  complex(REALKIND), dimension(5,60) :: G1tensor
  complex(REALKIND), dimension(15,98) :: G2tensor
  complex(REALKIND), dimension(35,2) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AW_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,10),ML,G1(:,:,:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,2),gH)
  call loop_A_Q(G1(:,:,:,2),Q(:,58),ML,G2(:,:,:,1))
  call loop_AW_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_QW_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,10),MT,G1(:,:,:,3))
  call loop_QS_A(G1(:,:,:,3),wf(:,3),G1(:,:,:,4),gH)
  call loop_Q_A(G1(:,:,:,4),Q(:,58),MT,G2(:,:,:,3))
  call loop_QW_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),ZERO,G3tensor(:,2))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,5))
  call loop_SS_S(G1(:,:,:,5),wf(:,3),G1(:,:,:,6))
  call check_last_TV_S(l_switch,G1(:,:,:,6),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,1))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,7))
  call loop_SS_S(G1(:,:,:,7),wf(:,3),G1(:,:,:,8))
  call check_last_TV_S(l_switch,G1(:,:,:,8),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,2))
  call loop_ST_V(G1(:,:,:,7),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,5))
  call check_last_VV_S(l_switch,G2(:,:,:,5),wf(:,1),G2tensor(:,3))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,9))
  call loop_SS_S(G1(:,:,:,9),wf(:,3),G1(:,:,:,10))
  call check_last_SV_T(l_switch,G1(:,:,:,10),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,4))
  call check_last_SV_T(l_switch,G1(:,:,:,10),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,5))
  call loop_ST_V(G1(:,:,:,9),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,6))
  call check_last_VV_S(l_switch,G2(:,:,:,6),wf(:,1),G2tensor(:,6))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,11))
  call loop_SS_S(G1(:,:,:,11),wf(:,3),G1(:,:,:,12))
  call check_last_CV_D(l_switch,G1(:,:,:,12),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,7))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,13))
  call loop_SS_S(G1(:,:,:,13),wf(:,3),G1(:,:,:,14))
  call check_last_DV_C(l_switch,G1(:,:,:,14),Q(:,58),wf(:,1),G2tensor(:,8))
  call check_last_DV_C(l_switch,G1(:,:,:,14),Q(:,58),wf(:,1),G2tensor(:,9))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,15))
  call loop_SS_S(G1(:,:,:,15),wf(:,3),G1(:,:,:,16))
  call check_last_DV_C(l_switch,G1(:,:,:,16),Q(:,58),wf(:,1),G2tensor(:,10))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,17))
  call loop_SS_S(G1(:,:,:,17),wf(:,3),G1(:,:,:,18))
  call check_last_CV_D(l_switch,G1(:,:,:,18),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,11))
  call check_last_CV_D(l_switch,G1(:,:,:,18),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,12))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,19))
  call loop_VS_V(G1(:,:,:,19),wf(:,3),G1(:,:,:,20))
  call check_last_UW_V(l_switch,G1(:,:,:,20),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,13))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,21))
  call loop_VS_V(G1(:,:,:,21),wf(:,3),G1(:,:,:,22))
  call check_last_UV_W(l_switch,G1(:,:,:,22),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,22),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,15))
  call loop_WA_Q(G1(:,:,:,22),wf(:,0),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,59),ZERO,G2(:,:,:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,7),wf(:,-2),G2tensor(:,16))
  call loop_VT_S(G1(:,:,:,21),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,8))
  call check_last_SV_V(l_switch,G2(:,:,:,8),wf(:,1),G2tensor(:,17))
  call check_last_SV_V(l_switch,G2(:,:,:,8),wf(:,1),G2tensor(:,18))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_VT_S(G0(:,:,:,4),Q(:,10),wf(:,3),Q(:,48),G1(:,:,:,24))
  call check_last_TV_S(l_switch,G1(:,:,:,24),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,19))
  call loop_VS_V(G0(:,:,:,4),wf(:,3),G0(:,:,:,5))
  call check_last_VV_S(l_switch,G0(:,:,:,5),wf(:,1),G0tensor(:,1))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_VT_S(G0(:,:,:,6),Q(:,10),wf(:,3),Q(:,48),G1(:,:,:,25))
  call check_last_SV_T(l_switch,G1(:,:,:,25),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,20))
  call loop_VS_V(G0(:,:,:,6),wf(:,3),G0(:,:,:,7))
  call check_last_VV_S(l_switch,G0(:,:,:,7),wf(:,1),G0tensor(:,2))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_SS_S(G0(:,:,:,8),wf(:,3),G0(:,:,:,9))
  call check_last_SV_V(l_switch,G0(:,:,:,9),wf(:,1),G0tensor(:,3))
  call check_last_SV_V(l_switch,G0(:,:,:,9),wf(:,1),G0tensor(:,4))
  call loop_ST_V(G0(:,:,:,8),Q(:,10),wf(:,3),Q(:,48),G1(:,:,:,26))
  call check_last_UV_W(l_switch,G1(:,:,:,26),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,21))
  call check_last_UV_W(l_switch,G1(:,:,:,26),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,22))
  call loop_WA_Q(G1(:,:,:,26),wf(:,0),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,59),ZERO,G2(:,:,:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,-2),G2tensor(:,23))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_SS_S(G0(:,:,:,10),wf(:,3),G0(:,:,:,11))
  call check_last_SV_V(l_switch,G0(:,:,:,11),wf(:,1),G0tensor(:,5))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12),gZl)
  call loop_VS_V(G0(:,:,:,12),wf(:,3),G0(:,:,:,13))
  call loop_ZQ_A(G0(:,:,:,13),wf(:,19),G0(:,:,:,14),gZl)
  call check_last_Q_A(l_switch,G0(:,:,:,14),Q(:,63),ZERO,G1tensor(:,1))
  call loop_VS_V(G0(:,:,:,12),wf(:,14),G0(:,:,:,15))
  call loop_WQ_A(G0(:,:,:,15),wf(:,-1),G0(:,:,:,16))
  call check_last_Q_A(l_switch,G0(:,:,:,16),Q(:,63),ZERO,G1tensor(:,2))
  call loop_UW_V(G0(:,:,:,12),Q(:,8),wf(:,16),Q(:,53),G1(:,:,:,28))
  call loop_WQ_A(G1(:,:,:,28),wf(:,-1),G1(:,:,:,29))
  call check_last_Q_A(l_switch,G1(:,:,:,29),Q(:,63),ZERO,G2tensor(:,24))
  call loop_VV_S(G0(:,:,:,12),wf(:,1),G0(:,:,:,17))
  call loop_ST_V(G0(:,:,:,17),Q(:,13),wf(:,3),Q(:,48),G1(:,:,:,30))
  call loop_WQ_A(G1(:,:,:,30),wf(:,-1),G1(:,:,:,31))
  call check_last_Q_A(l_switch,G1(:,:,:,31),Q(:,63),ZERO,G2tensor(:,25))
  call loop_UW_V(G0(:,:,:,12),Q(:,8),wf(:,1),Q(:,5),G1(:,:,:,32))
  call loop_VS_V(G1(:,:,:,32),wf(:,3),G1(:,:,:,33))
  call loop_WQ_A(G1(:,:,:,33),wf(:,-1),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,63),ZERO,G2tensor(:,26))
  call loop_QA_W(G0(:,:,:,1),wf(:,-3),G0(:,:,:,18))
  call loop_VS_V(G0(:,:,:,18),wf(:,3),G0(:,:,:,19))
  call loop_WQ_A(G0(:,:,:,19),wf(:,19),G0(:,:,:,20))
  call check_last_Q_A(l_switch,G0(:,:,:,20),Q(:,63),ZERO,G1tensor(:,3))
  call loop_VS_V(G0(:,:,:,18),wf(:,14),G0(:,:,:,21))
  call loop_ZQ_A(G0(:,:,:,21),wf(:,-1),G0(:,:,:,22),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,22),Q(:,63),ZERO,G1tensor(:,4))
  call loop_UV_W(G0(:,:,:,18),Q(:,8),wf(:,16),Q(:,53),G1(:,:,:,35))
  call loop_ZQ_A(G1(:,:,:,35),wf(:,-1),G1(:,:,:,36),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,63),ZERO,G2tensor(:,27))
  call loop_UV_W(G0(:,:,:,18),Q(:,8),wf(:,1),Q(:,5),G1(:,:,:,37))
  call loop_VS_V(G1(:,:,:,37),wf(:,3),G1(:,:,:,38))
  call loop_ZQ_A(G1(:,:,:,38),wf(:,-1),G1(:,:,:,39),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,63),ZERO,G2tensor(:,28))
  call loop_QA_Z(G0(:,:,:,1),wf(:,21),G0(:,:,:,23),gZn)
  call loop_VS_V(G0(:,:,:,23),wf(:,3),G0(:,:,:,24))
  call loop_ZQ_A(G0(:,:,:,24),wf(:,-1),G0(:,:,:,25),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,25),Q(:,63),ZERO,G1tensor(:,5))
  call loop_QA_W(G0(:,:,:,1),wf(:,21),G0(:,:,:,26))
  call loop_VS_V(G0(:,:,:,26),wf(:,3),G0(:,:,:,27))
  call loop_WQ_A(G0(:,:,:,27),wf(:,-1),G0(:,:,:,28))
  call check_last_Q_A(l_switch,G0(:,:,:,28),Q(:,63),ZERO,G1tensor(:,6))
  call loop_VS_V(G0(:,:,:,1),wf(:,14),G0(:,:,:,29))
  call loop_WQ_A(G0(:,:,:,29),wf(:,-1),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,55),ZERO,G1(:,:,:,40))
  call check_last_QA_V(l_switch,G1(:,:,:,40),wf(:,-3),G1tensor(:,7))
  call check_last_UW_V(l_switch,G0(:,:,:,29),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,8))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,31),gZl)
  call loop_A_Q(G0(:,:,:,31),Q(:,8),ZERO,G1(:,:,:,41))
  call loop_AW_Q(G1(:,:,:,41),wf(:,16),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,61),ZERO,G2(:,:,:,10))
  call check_last_AQ_Z(l_switch,G2(:,:,:,10),wf(:,-1),G2tensor(:,29),gZn)
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,53),G1(:,:,:,43))
  call loop_WQ_A(G1(:,:,:,43),wf(:,-1),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,55),ZERO,G2(:,:,:,11))
  call check_last_QA_V(l_switch,G2(:,:,:,11),wf(:,-3),G2tensor(:,30))
  call check_last_UW_V(l_switch,G1(:,:,:,43),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,31))
  call loop_VV_S(G0(:,:,:,1),wf(:,1),G0(:,:,:,32))
  call loop_ST_V(G0(:,:,:,32),Q(:,5),wf(:,3),Q(:,48),G1(:,:,:,45))
  call loop_WA_Q(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,61),ZERO,G2(:,:,:,12))
  call check_last_AQ_Z(l_switch,G2(:,:,:,12),wf(:,-1),G2tensor(:,32),gZn)
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,1),Q(:,5),G1(:,:,:,47))
  call loop_VS_V(G1(:,:,:,47),wf(:,3),G1(:,:,:,48))
  call loop_ZA_Q(G1(:,:,:,48),wf(:,-3),G1(:,:,:,49),gZl)
  call loop_A_Q(G1(:,:,:,49),Q(:,61),ZERO,G2(:,:,:,13))
  call check_last_AQ_W(l_switch,G2(:,:,:,13),wf(:,-1),G2tensor(:,33))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,1),Q(:,5),G1(:,:,:,50))
  call loop_VS_V(G1(:,:,:,50),wf(:,3),G1(:,:,:,51))
  call loop_WA_Q(G1(:,:,:,51),wf(:,-3),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,61),ZERO,G2(:,:,:,14))
  call check_last_AQ_Z(l_switch,G2(:,:,:,14),wf(:,-1),G2tensor(:,34),gZn)
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,8),ZERO,G1(:,:,:,53))
  call loop_AQ_W(G1(:,:,:,53),wf(:,-1),G1(:,:,:,54))
  call loop_VT_S(G1(:,:,:,54),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,15))
  call check_last_SV_V(l_switch,G2(:,:,:,15),wf(:,1),G2tensor(:,35))
  call loop_VS_V(G1(:,:,:,54),wf(:,3),G1(:,:,:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,55),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,36))
  call loop_WA_Q(G1(:,:,:,55),wf(:,0),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,59),ZERO,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,-2),G2tensor(:,37))
  call loop_QW_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,5),ZERO,G1(:,:,:,57))
  call loop_QA_Z(G1(:,:,:,57),wf(:,-3),G1(:,:,:,58),gZl)
  call loop_VS_V(G1(:,:,:,58),wf(:,3),G1(:,:,:,59))
  call loop_ZQ_A(G1(:,:,:,59),wf(:,-1),G1(:,:,:,60),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,63),ZERO,G2tensor(:,38))
  call loop_QA_Z(G0(:,:,:,1),wf(:,23),G0(:,:,:,35),gZl)
  call loop_VS_V(G0(:,:,:,35),wf(:,3),G0(:,:,:,36))
  call loop_ZQ_A(G0(:,:,:,36),wf(:,-2),G0(:,:,:,37),gZl)
  call check_last_Q_A(l_switch,G0(:,:,:,37),Q(:,63),ZERO,G1tensor(:,9))
  call loop_QA_W(G0(:,:,:,1),wf(:,23),G0(:,:,:,38))
  call loop_VS_V(G0(:,:,:,38),wf(:,3),G0(:,:,:,39))
  call loop_WQ_A(G0(:,:,:,39),wf(:,-2),G0(:,:,:,40))
  call check_last_Q_A(l_switch,G0(:,:,:,40),Q(:,63),ZERO,G1tensor(:,10))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,25),G0(:,:,:,41),gZn)
  call loop_VS_V(G0(:,:,:,41),wf(:,3),G0(:,:,:,42))
  call loop_ZA_Q(G0(:,:,:,42),wf(:,0),G0(:,:,:,43),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,43),Q(:,63),ZERO,G1tensor(:,11))
  call loop_AQ_W(G0(:,:,:,1),wf(:,25),G0(:,:,:,44))
  call loop_VS_V(G0(:,:,:,44),wf(:,3),G0(:,:,:,45))
  call loop_WA_Q(G0(:,:,:,45),wf(:,0),G0(:,:,:,46))
  call check_last_A_Q(l_switch,G0(:,:,:,46),Q(:,63),ZERO,G1tensor(:,12))
  call loop_VS_V(G0(:,:,:,1),wf(:,10),G0(:,:,:,47))
  call loop_WA_Q(G0(:,:,:,47),wf(:,0),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,59),ZERO,G1(:,:,:,61))
  call check_last_AQ_V(l_switch,G1(:,:,:,61),wf(:,-2),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,14))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-2),G0(:,:,:,49))
  call loop_VS_V(G0(:,:,:,49),wf(:,10),G0(:,:,:,50))
  call loop_ZA_Q(G0(:,:,:,50),wf(:,0),G0(:,:,:,51),gZn)
  call check_last_A_Q(l_switch,G0(:,:,:,51),Q(:,63),ZERO,G1tensor(:,15))
  call loop_UW_V(G0(:,:,:,49),Q(:,4),wf(:,12),Q(:,58),G1(:,:,:,62))
  call loop_ZA_Q(G1(:,:,:,62),wf(:,0),G1(:,:,:,63),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,63),Q(:,63),ZERO,G2tensor(:,39))
  call loop_VT_S(G0(:,:,:,49),Q(:,4),wf(:,3),Q(:,48),G1(:,:,:,64))
  call loop_SV_V(G1(:,:,:,64),wf(:,2),G1(:,:,:,65))
  call loop_ZA_Q(G1(:,:,:,65),wf(:,0),G1(:,:,:,66),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,66),Q(:,63),ZERO,G2tensor(:,40))
  call loop_VS_V(G0(:,:,:,49),wf(:,3),G0(:,:,:,52))
  call loop_UW_V(G0(:,:,:,52),Q(:,52),wf(:,2),Q(:,10),G1(:,:,:,67))
  call loop_ZA_Q(G1(:,:,:,67),wf(:,0),G1(:,:,:,68),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,68),Q(:,63),ZERO,G2tensor(:,41))
  call loop_WQ_A(G0(:,:,:,52),wf(:,-1),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,54),ZERO,G1(:,:,:,69))
  call loop_QA_Z(G1(:,:,:,69),wf(:,-3),G1(:,:,:,70),gZl)
  call loop_ZA_Q(G1(:,:,:,70),wf(:,0),G1(:,:,:,71),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,71),Q(:,63),ZERO,G2tensor(:,42))
  call loop_UW_V(G0(:,:,:,49),Q(:,4),wf(:,2),Q(:,10),G1(:,:,:,72))
  call loop_VS_V(G1(:,:,:,72),wf(:,3),G1(:,:,:,73))
  call loop_ZA_Q(G1(:,:,:,73),wf(:,0),G1(:,:,:,74),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,74),Q(:,63),ZERO,G2tensor(:,43))
  call loop_WQ_A(G0(:,:,:,49),wf(:,-1),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,6),ZERO,G1(:,:,:,75))
  call loop_QA_Z(G1(:,:,:,75),wf(:,-3),G1(:,:,:,76),gZl)
  call loop_VS_V(G1(:,:,:,76),wf(:,3),G1(:,:,:,77))
  call loop_ZA_Q(G1(:,:,:,77),wf(:,0),G1(:,:,:,78),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,78),Q(:,63),ZERO,G2tensor(:,44))
  call loop_WA_Q(G0(:,:,:,49),wf(:,-3),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,12),ZERO,G1(:,:,:,79))
  call loop_AQ_Z(G1(:,:,:,79),wf(:,-1),G1(:,:,:,80),gZn)
  call loop_VS_V(G1(:,:,:,80),wf(:,3),G1(:,:,:,81))
  call loop_ZA_Q(G1(:,:,:,81),wf(:,0),G1(:,:,:,82),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,82),Q(:,63),ZERO,G2tensor(:,45))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-2),G0(:,:,:,56),gZl)
  call loop_VS_V(G0(:,:,:,56),wf(:,10),G0(:,:,:,57))
  call loop_WA_Q(G0(:,:,:,57),wf(:,0),G0(:,:,:,58))
  call check_last_A_Q(l_switch,G0(:,:,:,58),Q(:,63),ZERO,G1tensor(:,16))
  call loop_UV_W(G0(:,:,:,56),Q(:,4),wf(:,12),Q(:,58),G1(:,:,:,83))
  call loop_WA_Q(G1(:,:,:,83),wf(:,0),G1(:,:,:,84))
  call check_last_A_Q(l_switch,G1(:,:,:,84),Q(:,63),ZERO,G2tensor(:,46))
  call loop_VS_V(G0(:,:,:,56),wf(:,3),G0(:,:,:,59))
  call loop_UV_W(G0(:,:,:,59),Q(:,52),wf(:,2),Q(:,10),G1(:,:,:,85))
  call loop_WA_Q(G1(:,:,:,85),wf(:,0),G1(:,:,:,86))
  call check_last_A_Q(l_switch,G1(:,:,:,86),Q(:,63),ZERO,G2tensor(:,47))
  call loop_ZQ_A(G0(:,:,:,59),wf(:,-1),G0(:,:,:,60),gZn)
  call loop_Q_A(G0(:,:,:,60),Q(:,54),ZERO,G1(:,:,:,87))
  call loop_QA_W(G1(:,:,:,87),wf(:,-3),G1(:,:,:,88))
  call loop_WA_Q(G1(:,:,:,88),wf(:,0),G1(:,:,:,89))
  call check_last_A_Q(l_switch,G1(:,:,:,89),Q(:,63),ZERO,G2tensor(:,48))
  call loop_VV_S(G0(:,:,:,56),wf(:,2),G0(:,:,:,61))
  call loop_ST_V(G0(:,:,:,61),Q(:,14),wf(:,3),Q(:,48),G1(:,:,:,90))
  call loop_WA_Q(G1(:,:,:,90),wf(:,0),G1(:,:,:,91))
  call check_last_A_Q(l_switch,G1(:,:,:,91),Q(:,63),ZERO,G2tensor(:,49))
  call loop_UV_W(G0(:,:,:,56),Q(:,4),wf(:,2),Q(:,10),G1(:,:,:,92))
  call loop_VS_V(G1(:,:,:,92),wf(:,3),G1(:,:,:,93))
  call loop_WA_Q(G1(:,:,:,93),wf(:,0),G1(:,:,:,94))
  call check_last_A_Q(l_switch,G1(:,:,:,94),Q(:,63),ZERO,G2tensor(:,50))
  call loop_ZQ_A(G0(:,:,:,56),wf(:,-1),G0(:,:,:,62),gZn)
  call loop_Q_A(G0(:,:,:,62),Q(:,6),ZERO,G1(:,:,:,95))
  call loop_QA_W(G1(:,:,:,95),wf(:,-3),G1(:,:,:,96))
  call loop_VS_V(G1(:,:,:,96),wf(:,3),G1(:,:,:,97))
  call loop_WA_Q(G1(:,:,:,97),wf(:,0),G1(:,:,:,98))
  call check_last_A_Q(l_switch,G1(:,:,:,98),Q(:,63),ZERO,G2tensor(:,51))
  call loop_ZA_Q(G0(:,:,:,56),wf(:,-3),G0(:,:,:,63),gZl)
  call loop_A_Q(G0(:,:,:,63),Q(:,12),ZERO,G1(:,:,:,99))
  call loop_AQ_W(G1(:,:,:,99),wf(:,-1),G1(:,:,:,100))
  call loop_VS_V(G1(:,:,:,100),wf(:,3),G1(:,:,:,101))
  call loop_WA_Q(G1(:,:,:,101),wf(:,0),G1(:,:,:,102))
  call check_last_A_Q(l_switch,G1(:,:,:,102),Q(:,63),ZERO,G2tensor(:,52))
  call loop_ZQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,64),gZl)
  call loop_Q_A(G0(:,:,:,64),Q(:,4),ZERO,G1(:,:,:,103))
  call loop_QW_A(G1(:,:,:,103),wf(:,12),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,62),ZERO,G2(:,:,:,17))
  call check_last_QA_Z(l_switch,G2(:,:,:,17),wf(:,0),G2tensor(:,53),gZn)
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,58),G1(:,:,:,105))
  call loop_WA_Q(G1(:,:,:,105),wf(:,0),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,59),ZERO,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,-2),G2tensor(:,54))
  call check_last_UV_W(l_switch,G1(:,:,:,105),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,55))
  call loop_AW_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,10),ZERO,G1(:,:,:,107))
  call loop_AQ_Z(G1(:,:,:,107),wf(:,-2),G1(:,:,:,108),gZl)
  call loop_VS_V(G1(:,:,:,108),wf(:,3),G1(:,:,:,109))
  call loop_ZA_Q(G1(:,:,:,109),wf(:,0),G1(:,:,:,110),gZn)
  call check_last_A_Q(l_switch,G1(:,:,:,110),Q(:,63),ZERO,G2tensor(:,56))
  call loop_WQ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,2),ZERO,G1(:,:,:,111))
  call loop_QA_Z(G1(:,:,:,111),wf(:,-3),G1(:,:,:,112),gZl)
  call loop_VS_V(G1(:,:,:,112),wf(:,3),G1(:,:,:,113))
  call loop_ZQ_A(G1(:,:,:,113),wf(:,-2),G1(:,:,:,114),gZl)
  call loop_Q_A(G1(:,:,:,114),Q(:,62),ZERO,G2(:,:,:,19))
  call check_last_QA_W(l_switch,G2(:,:,:,19),wf(:,0),G2tensor(:,57))
  call loop_ZQ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,67),gZn)
  call loop_Q_A(G0(:,:,:,67),Q(:,2),ZERO,G1(:,:,:,115))
  call loop_QA_W(G1(:,:,:,115),wf(:,-3),G1(:,:,:,116))
  call loop_VS_V(G1(:,:,:,116),wf(:,3),G1(:,:,:,117))
  call loop_WQ_A(G1(:,:,:,117),wf(:,-2),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,62),ZERO,G2(:,:,:,20))
  call check_last_QA_Z(l_switch,G2(:,:,:,20),wf(:,0),G2tensor(:,58),gZn)
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,68))
  call check_last_SV_V(l_switch,G0(:,:,:,68),wf(:,1),G0tensor(:,6))
  call check_last_SV_V(l_switch,G0(:,:,:,68),wf(:,1),G0tensor(:,7))
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,69))
  call check_last_SV_V(l_switch,G0(:,:,:,69),wf(:,1),G0tensor(:,8))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,70))
  call check_last_SV_V(l_switch,G0(:,:,:,70),wf(:,2),G0tensor(:,9))
  call check_last_SV_V(l_switch,G0(:,:,:,70),wf(:,2),G0tensor(:,10))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,71))
  call check_last_SV_V(l_switch,G0(:,:,:,71),wf(:,2),G0tensor(:,11))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,72))
  call check_last_SVV_S(l_switch,G0(:,:,:,72),wf(:,1),wf(:,2),G0tensor(:,12))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,73))
  call check_last_SVV_S(l_switch,G0(:,:,:,73),wf(:,1),wf(:,2),G0tensor(:,13))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,74))
  call check_last_SVV_S(l_switch,G0(:,:,:,74),wf(:,1),wf(:,2),G0tensor(:,14))
  call check_last_TV_S(l_switch,G0(:,:,:,74),Q(:,48),wf(:,26),Q(:,15),G1tensor(:,17))
  call check_last_TV_S(l_switch,G0(:,:,:,74),Q(:,48),wf(:,27),Q(:,15),G1tensor(:,18))
  call check_last_TV_S(l_switch,G0(:,:,:,74),Q(:,48),wf(:,28),Q(:,15),G1tensor(:,19))
  call check_last_TV_S(l_switch,G0(:,:,:,74),Q(:,48),wf(:,29),Q(:,15),G1tensor(:,20))
  call check_last_TV_S(l_switch,G0(:,:,:,74),Q(:,48),wf(:,30),Q(:,15),G1tensor(:,21))
  call check_last_TV_S(l_switch,G0(:,:,:,74),Q(:,48),wf(:,31),Q(:,15),G1tensor(:,22))
  call check_last_TV_S(l_switch,G0(:,:,:,74),Q(:,48),wf(:,32),Q(:,15),G1tensor(:,23))
  call loop_VS_V(G0(:,:,:,1),wf(:,3),G0(:,:,:,75))
  call check_last_VWW_V(l_switch,G0(:,:,:,75),wf(:,1),wf(:,2),G0tensor(:,15))
  call loop_VS_V(G0(:,:,:,1),wf(:,3),G0(:,:,:,76))
  call check_last_WWV_V(l_switch,G0(:,:,:,76),wf(:,1),wf(:,2),G0tensor(:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,48),wf(:,26),Q(:,15),G1tensor(:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,48),wf(:,27),Q(:,15),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,48),wf(:,28),Q(:,15),G1tensor(:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,48),wf(:,29),Q(:,15),G1tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,48),wf(:,30),Q(:,15),G1tensor(:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,48),wf(:,31),Q(:,15),G1tensor(:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,48),wf(:,32),Q(:,15),G1tensor(:,30))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,77),gH)
  call loop_Q_A(G0(:,:,:,77),Q(:,48),ML,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,26),G1(:,:,:,120))
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,63),ML,G2tensor(:,59))
  call loop_QZ_A(G1(:,:,:,119),wf(:,26),G1(:,:,:,121),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,121),Q(:,63),ML,G2tensor(:,60))
  call loop_QV_A(G1(:,:,:,119),wf(:,27),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,63),ML,G2tensor(:,61))
  call loop_QZ_A(G1(:,:,:,119),wf(:,28),G1(:,:,:,123),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,123),Q(:,63),ML,G2tensor(:,62))
  call loop_QZ_A(G1(:,:,:,119),wf(:,29),G1(:,:,:,124),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,63),ML,G2tensor(:,63))
  call loop_QV_A(G1(:,:,:,119),wf(:,30),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,63),ML,G2tensor(:,64))
  call loop_QZ_A(G1(:,:,:,119),wf(:,31),G1(:,:,:,126),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,63),ML,G2tensor(:,65))
  call loop_QZ_A(G1(:,:,:,119),wf(:,32),G1(:,:,:,127),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,63),ML,G2tensor(:,66))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,78),gH)
  call loop_Q_A(G0(:,:,:,78),Q(:,48),MT,G1(:,:,:,128))
  call loop_QV_A(G1(:,:,:,128),wf(:,26),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),MT,G2tensor(:,67))
  call loop_QZ_A(G1(:,:,:,128),wf(:,26),G1(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),MT,G2tensor(:,68))
  call loop_QV_A(G1(:,:,:,128),wf(:,27),G1(:,:,:,131))
  call check_last_Q_A(l_switch,G1(:,:,:,131),Q(:,63),MT,G2tensor(:,69))
  call loop_QZ_A(G1(:,:,:,128),wf(:,28),G1(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,132),Q(:,63),MT,G2tensor(:,70))
  call loop_QZ_A(G1(:,:,:,128),wf(:,29),G1(:,:,:,133),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,63),MT,G2tensor(:,71))
  call loop_QV_A(G1(:,:,:,128),wf(:,30),G1(:,:,:,134))
  call check_last_Q_A(l_switch,G1(:,:,:,134),Q(:,63),MT,G2tensor(:,72))
  call loop_QZ_A(G1(:,:,:,128),wf(:,31),G1(:,:,:,135),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,135),Q(:,63),MT,G2tensor(:,73))
  call loop_QZ_A(G1(:,:,:,128),wf(:,32),G1(:,:,:,136),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,136),Q(:,63),MT,G2tensor(:,74))
  call loop_SS_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,79))
  call check_last_CV_D(l_switch,G0(:,:,:,79),Q(:,48),wf(:,26),Q(:,15),G1tensor(:,31))
  call check_last_CV_D(l_switch,G0(:,:,:,79),Q(:,48),wf(:,27),Q(:,15),G1tensor(:,32))
  call check_last_CV_D(l_switch,G0(:,:,:,79),Q(:,48),wf(:,28),Q(:,15),G1tensor(:,33))
  call check_last_CV_D(l_switch,G0(:,:,:,79),Q(:,48),wf(:,29),Q(:,15),G1tensor(:,34))
  call check_last_CV_D(l_switch,G0(:,:,:,79),Q(:,48),wf(:,30),Q(:,15),G1tensor(:,35))
  call check_last_CV_D(l_switch,G0(:,:,:,79),Q(:,48),wf(:,31),Q(:,15),G1tensor(:,36))
  call check_last_CV_D(l_switch,G0(:,:,:,79),Q(:,48),wf(:,32),Q(:,15),G1tensor(:,37))
  call loop_ST_V(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,48),G1(:,:,:,137))
  call check_last_VV_S(l_switch,G1(:,:,:,137),wf(:,26),G1tensor(:,38))
  call loop_AS_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,80),gPln)
  call loop_A_Q(G0(:,:,:,80),Q(:,53),ZERO,G1(:,:,:,138))
  call loop_AW_Q(G1(:,:,:,138),wf(:,2),G1(:,:,:,139))
  call check_last_A_Q(l_switch,G1(:,:,:,139),Q(:,63),ML,G2tensor(:,75))
  call loop_AS_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,81),gPbt)
  call loop_A_Q(G0(:,:,:,81),Q(:,53),MT,G1(:,:,:,140))
  call loop_AW_Q(G1(:,:,:,140),wf(:,2),G1(:,:,:,141))
  call check_last_A_Q(l_switch,G1(:,:,:,141),Q(:,63),ZERO,G2tensor(:,76))
  call loop_SS_S(G0(:,:,:,1),wf(:,14),G0(:,:,:,82))
  call check_last_TV_S(l_switch,G0(:,:,:,82),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,39))
  call loop_SS_S(G0(:,:,:,1),wf(:,14),G0(:,:,:,83))
  call check_last_DV_C(l_switch,G0(:,:,:,83),Q(:,53),wf(:,2),G1tensor(:,40))
  call loop_SS_S(G0(:,:,:,1),wf(:,14),G0(:,:,:,84))
  call check_last_DV_C(l_switch,G0(:,:,:,84),Q(:,53),wf(:,2),G1tensor(:,41))
  call loop_SS_S(G0(:,:,:,1),wf(:,14),G0(:,:,:,85))
  call check_last_CV_D(l_switch,G0(:,:,:,85),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,42))
  call loop_VS_V(G0(:,:,:,1),wf(:,14),G0(:,:,:,86))
  call check_last_UV_W(l_switch,G0(:,:,:,86),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,43))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,53),G1(:,:,:,142))
  call check_last_SV_V(l_switch,G1(:,:,:,142),wf(:,2),G1tensor(:,44))
  call check_last_SV_V(l_switch,G1(:,:,:,142),wf(:,2),G1tensor(:,45))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,53),G1(:,:,:,143))
  call check_last_SV_V(l_switch,G1(:,:,:,143),wf(:,2),G1tensor(:,46))
  call loop_AW_Q(G0(:,:,:,1),wf(:,16),G0(:,:,:,87))
  call loop_A_Q(G0(:,:,:,87),Q(:,53),ZERO,G1(:,:,:,144))
  call loop_AW_Q(G1(:,:,:,144),wf(:,2),G1(:,:,:,145))
  call check_last_A_Q(l_switch,G1(:,:,:,145),Q(:,63),ZERO,G2tensor(:,77))
  call loop_AW_Q(G1(:,:,:,144),wf(:,2),G1(:,:,:,146))
  call check_last_A_Q(l_switch,G1(:,:,:,146),Q(:,63),ML,G2tensor(:,78))
  call loop_AW_Q(G0(:,:,:,1),wf(:,16),G0(:,:,:,88))
  call loop_A_Q(G0(:,:,:,88),Q(:,53),MT,G1(:,:,:,147))
  call loop_AW_Q(G1(:,:,:,147),wf(:,2),G1(:,:,:,148))
  call check_last_A_Q(l_switch,G1(:,:,:,148),Q(:,63),ZERO,G2tensor(:,79))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,53),G1(:,:,:,149))
  call check_last_TV_S(l_switch,G1(:,:,:,149),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,80))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,53),G1(:,:,:,150))
  call check_last_TV_S(l_switch,G1(:,:,:,150),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,81))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,16),G1(:,:,:,151))
  call check_last_DV_C(l_switch,G1(:,:,:,151),Q(:,53),wf(:,2),G2tensor(:,82))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,16),G1(:,:,:,152))
  call check_last_DV_C(l_switch,G1(:,:,:,152),Q(:,53),wf(:,2),G2tensor(:,83))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,53),G1(:,:,:,153))
  call check_last_CV_D(l_switch,G1(:,:,:,153),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,84))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,53),G1(:,:,:,154))
  call check_last_CV_D(l_switch,G1(:,:,:,154),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,85))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,16),Q(:,53),G1(:,:,:,155))
  call check_last_UV_W(l_switch,G1(:,:,:,155),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,86))
  call loop_VV_S(G0(:,:,:,1),wf(:,16),G0(:,:,:,89))
  call check_last_SV_V(l_switch,G0(:,:,:,89),wf(:,2),G0tensor(:,17))
  call check_last_SV_V(l_switch,G0(:,:,:,89),wf(:,2),G0tensor(:,18))
  call loop_VV_S(G0(:,:,:,1),wf(:,16),G0(:,:,:,90))
  call check_last_SV_V(l_switch,G0(:,:,:,90),wf(:,2),G0tensor(:,19))
  call loop_QS_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,91),gPnl)
  call loop_Q_A(G0(:,:,:,91),Q(:,58),ZERO,G1(:,:,:,156))
  call loop_QW_A(G1(:,:,:,156),wf(:,1),G1(:,:,:,157))
  call check_last_Q_A(l_switch,G1(:,:,:,157),Q(:,63),ML,G2tensor(:,87))
  call loop_QS_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,92),gPtb)
  call loop_Q_A(G0(:,:,:,92),Q(:,58),MT,G1(:,:,:,158))
  call loop_QW_A(G1(:,:,:,158),wf(:,1),G1(:,:,:,159))
  call check_last_Q_A(l_switch,G1(:,:,:,159),Q(:,63),ZERO,G2tensor(:,88))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,93))
  call check_last_TV_S(l_switch,G0(:,:,:,93),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,47))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,94))
  call check_last_CV_D(l_switch,G0(:,:,:,94),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,48))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,95))
  call check_last_DV_C(l_switch,G0(:,:,:,95),Q(:,58),wf(:,1),G1tensor(:,49))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,96))
  call check_last_DV_C(l_switch,G0(:,:,:,96),Q(:,58),wf(:,1),G1tensor(:,50))
  call loop_VS_V(G0(:,:,:,1),wf(:,10),G0(:,:,:,97))
  call check_last_UW_V(l_switch,G0(:,:,:,97),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,51))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,58),G1(:,:,:,160))
  call check_last_SV_V(l_switch,G1(:,:,:,160),wf(:,1),G1tensor(:,52))
  call check_last_SV_V(l_switch,G1(:,:,:,160),wf(:,1),G1tensor(:,53))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,58),G1(:,:,:,161))
  call check_last_SV_V(l_switch,G1(:,:,:,161),wf(:,1),G1tensor(:,54))
  call loop_QW_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,98))
  call loop_Q_A(G0(:,:,:,98),Q(:,58),ZERO,G1(:,:,:,162))
  call loop_QW_A(G1(:,:,:,162),wf(:,1),G1(:,:,:,163))
  call check_last_Q_A(l_switch,G1(:,:,:,163),Q(:,63),ZERO,G2tensor(:,89))
  call loop_QW_A(G1(:,:,:,162),wf(:,1),G1(:,:,:,164))
  call check_last_Q_A(l_switch,G1(:,:,:,164),Q(:,63),ML,G2tensor(:,90))
  call loop_QW_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,99))
  call loop_Q_A(G0(:,:,:,99),Q(:,58),MT,G1(:,:,:,165))
  call loop_QW_A(G1(:,:,:,165),wf(:,1),G1(:,:,:,166))
  call check_last_Q_A(l_switch,G1(:,:,:,166),Q(:,63),ZERO,G2tensor(:,91))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,58),G1(:,:,:,167))
  call check_last_TV_S(l_switch,G1(:,:,:,167),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,92))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,58),G1(:,:,:,168))
  call check_last_TV_S(l_switch,G1(:,:,:,168),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,93))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,58),G1(:,:,:,169))
  call check_last_CV_D(l_switch,G1(:,:,:,169),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,94))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,58),G1(:,:,:,170))
  call check_last_CV_D(l_switch,G1(:,:,:,170),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,95))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,12),G1(:,:,:,171))
  call check_last_DV_C(l_switch,G1(:,:,:,171),Q(:,58),wf(:,1),G2tensor(:,96))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,12),G1(:,:,:,172))
  call check_last_DV_C(l_switch,G1(:,:,:,172),Q(:,58),wf(:,1),G2tensor(:,97))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,58),G1(:,:,:,173))
  call check_last_UW_V(l_switch,G1(:,:,:,173),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,98))
  call loop_VV_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,100))
  call check_last_SV_V(l_switch,G0(:,:,:,100),wf(:,1),G0tensor(:,20))
  call check_last_SV_V(l_switch,G0(:,:,:,100),wf(:,1),G0tensor(:,21))
  call loop_VV_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,101))
  call check_last_SV_V(l_switch,G0(:,:,:,101),wf(:,1),G0tensor(:,22))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,48),G1(:,:,:,174))
  call check_last_SV_V(l_switch,G1(:,:,:,174),wf(:,27),G1tensor(:,55))
  call check_last_SV_V(l_switch,G1(:,:,:,174),wf(:,28),G1tensor(:,56))
  call check_last_SV_V(l_switch,G1(:,:,:,174),wf(:,29),G1tensor(:,57))
  call check_last_SV_V(l_switch,G1(:,:,:,174),wf(:,30),G1tensor(:,58))
  call check_last_SV_V(l_switch,G1(:,:,:,174),wf(:,31),G1tensor(:,59))
  call check_last_SV_V(l_switch,G1(:,:,:,174),wf(:,32),G1tensor(:,60))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(35)*M(1))) * den(32)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(36)*M(1))) * den(32)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(9)*M(1))) * den(32)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(7)*M(1))) * den(32)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(7)*M(1))) * den(32)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(7)*M(1))) * den(32)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(2)*M(1))) * den(32)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(14)*M(1))) * den(32)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(4)*M(1))) * den(32)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(2)*M(1))) * den(32)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(14)*M(1))) * den(32)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(4)*M(1))) * den(32)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(3)*M(1)) * den(32)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(15)*M(1)) * den(32)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(5)*M(1)) * den(32)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(16)*M(1)) * den(32)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(1)*M(1))) * den(32)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(16)*M(1)) * den(32)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(1)*M(1))) * den(32)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(18)*M(1))) * den(32)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(23)*M(1))) * den(32)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,4)
  Gcoeff = (-(c(6)*M(1))) * den(32)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,5)
  Gcoeff = (-(c(24)*M(1))) * den(32)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(10)*M(1))) * den(32)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(14)*M(1))) * den(32)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(14)*M(1)) * den(32)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(14)*M(1)) * den(32)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(14)*M(1))) * den(32)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(17)*M(1)) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(2)*M(1)) * den(33)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(17)*M(1)) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(2)*M(1)) * den(34)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(14)*M(1))) * den(12)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(21)*M(1))) * den(12)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(21)*M(1))) * den(12)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(15)*M(1)) * den(12)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(15)*M(1))) * den(12)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(13)*M(1)) * den(12)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(13)*M(1)) * den(12)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(21)*M(1)) * den(10)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(11)*M(1)) * den(10)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(13)*M(1)) * den(10)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(14)*M(1)) * den(10)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(21)*M(1)) * den(10)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(11)*M(1)) * den(10)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(15)*M(1))) * den(10)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(13)*M(1)) * den(10)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(17)*M(1)) * den(10)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(17)*M(1)) * den(35)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(2)*M(1)) * den(35)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(17)*M(1)) * den(36)
  T1sum(1:5,7) = T1sum(1:5,7) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(2)*M(1)) * den(36)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(14)*M(1)) * den(8)
  T2sum(1:5,16) = T2sum(1:5,16) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(21)*M(1)) * den(8)
  T2sum(1:5,17) = T2sum(1:5,17) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(21)*M(1)) * den(8)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(15)*M(1)) * den(8)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(15)*M(1))) * den(8)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(13)*M(1)) * den(8)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(13)*M(1)) * den(8)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(21)*M(1))) * den(6)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(11)*M(1)) * den(6)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(13)*M(1)) * den(6)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(14)*M(1))) * den(6)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(21)*M(1))) * den(6)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(11)*M(1)) * den(6)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(15)*M(1))) * den(6)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(13)*M(1)) * den(6)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(17)*M(1)) * den(6)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(17)*M(1)) * den(3)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(15)*M(1)) * den(3)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(17)*M(1)) * den(3)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(15)*M(1)) * den(3)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(17)*M(1)) * den(3)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(15)*M(1)) * den(3)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(17)*M(1)) * den(3)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(15)*M(1)) * den(3)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(15)*M(1)) * den(3)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(14)*M(1))) * den(37)
  T2sum(1:1,35) = T2sum(1:1,35) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(22)*M(1))) * den(37)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(2)*M(1))) * den(37)
  T2sum(1:1,36) = T2sum(1:1,36) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(14)*M(1))) * den(38)
  T2sum(1:1,37) = T2sum(1:1,37) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(22)*M(1))) * den(38)
  T1sum(1:1,10) = T1sum(1:1,10) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(2)*M(1))) * den(38)
  T2sum(1:1,38) = T2sum(1:1,38) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(9)*M(1))) * den(5)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,12)
  Gcoeff = (-(c(7)*M(1))) * den(5)
  T0sum(1:1,2) = T0sum(1:1,2) + Gcoeff * G0tensor(:,13)
  Gcoeff = (-(c(8)*M(1))) * den(5)
  T1sum(1:1,11) = T1sum(1:1,11) + Gcoeff * G0tensor(:,14)
  Gcoeff = (-(c(2)*M(1))) * den(5)
  T0sum(1:1,2) = T0sum(1:1,2) + Gcoeff * G0tensor(:,15)
  Gcoeff = (c(3)*M(1)) * den(5)
  T1sum(1:1,11) = T1sum(1:1,11) + Gcoeff * G0tensor(:,16)
  Gcoeff = (c(39)*M(1)) * den(39)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(40)*M(1))) * den(39)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(37)*M(1))) * den(40)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(38)*M(1))) * den(40)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(19)*M(1)) * den(39)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,17)
  Gcoeff = (-(c(27)*M(1))) * den(40)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(14)*M(1)) * den(39)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,31)
  Gcoeff = (-(c(14)*M(1))) * den(39)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(4)*M(1)) * den(40)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,31)
  Gcoeff = (-(c(4)*M(1))) * den(40)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(15)*M(1)) * den(39)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(5)*M(1)) * den(40)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,24)
  Gcoeff = (-(c(14)*M(1))) * den(39)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(14)*M(1)) * den(39)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(14)*M(1)) * den(40)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,38)
  Gcoeff = (-(c(14)*M(1))) * den(40)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,38)
  Gcoeff = (-(c(35)*M(1))) * den(13)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(34)*M(1))) * den(13)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(7)*M(1))) * den(13)
  T2sum(1:5,38) = T2sum(1:5,38) + Gcoeff * G1tensor(:,39)
  Gcoeff = (-(c(14)*M(1))) * den(13)
  T2sum(1:5,43) = T2sum(1:5,43) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(26)*M(1)) * den(13)
  T2sum(1:5,44) = T2sum(1:5,44) + Gcoeff * G1tensor(:,41)
  Gcoeff = (-(c(1)*M(1))) * den(13)
  T2sum(1:5,44) = T2sum(1:5,44) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(14)*M(1)) * den(13)
  T2sum(1:5,37) = T2sum(1:5,37) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(14)*M(1))) * den(13)
  T2sum(1:5,44) = T2sum(1:5,44) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(14)*M(1)) * den(13)
  T2sum(1:5,37) = T2sum(1:5,37) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(29)*M(1)) * den(13)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,45)
  Gcoeff = (-(c(1)*M(1))) * den(13)
  T2sum(1:5,38) = T2sum(1:5,38) + Gcoeff * G1tensor(:,46)
  Gcoeff = (-(c(32)*M(1))) * den(13)
  T2sum(1:15,45) = T2sum(1:15,45) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(30)*M(1))) * den(13)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(33)*M(1))) * den(13)
  T2sum(1:15,45) = T2sum(1:15,45) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(31)*M(1))) * den(13)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(1)*M(1))) * den(13)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(1)*M(1))) * den(13)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(15)*M(1))) * den(13)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(5)*M(1))) * den(13)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(15)*M(1))) * den(13)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(5)*M(1))) * den(13)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(15)*M(1)) * den(13)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(5)*M(1)) * den(13)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,86)
  Gcoeff = (-(c(20)*M(1))) * den(13)
  T2sum(1:1,37) = T2sum(1:1,37) + Gcoeff * G0tensor(:,17)
  Gcoeff = (-(c(25)*M(1))) * den(13)
  T1sum(1:1,10) = T1sum(1:1,10) + Gcoeff * G0tensor(:,18)
  Gcoeff = (-(c(10)*M(1))) * den(13)
  T2sum(1:1,38) = T2sum(1:1,38) + Gcoeff * G0tensor(:,19)
  Gcoeff = (c(35)*M(1)) * den(9)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(34)*M(1))) * den(9)
  T2sum(1:15,47) = T2sum(1:15,47) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(7)*M(1))) * den(9)
  T2sum(1:5,36) = T2sum(1:5,36) + Gcoeff * G1tensor(:,47)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T2sum(1:5,48) = T2sum(1:5,48) + Gcoeff * G1tensor(:,48)
  Gcoeff = (-(c(14)*M(1))) * den(9)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(26)*M(1)) * den(9)
  T2sum(1:5,48) = T2sum(1:5,48) + Gcoeff * G1tensor(:,50)
  Gcoeff = (-(c(14)*M(1))) * den(9)
  T2sum(1:5,35) = T2sum(1:5,35) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(14)*M(1)) * den(9)
  T2sum(1:5,48) = T2sum(1:5,48) + Gcoeff * G1tensor(:,51)
  Gcoeff = (-(c(14)*M(1))) * den(9)
  T2sum(1:5,35) = T2sum(1:5,35) + Gcoeff * G1tensor(:,52)
  Gcoeff = (-(c(29)*M(1))) * den(9)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,53)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T2sum(1:5,36) = T2sum(1:5,36) + Gcoeff * G1tensor(:,54)
  Gcoeff = (-(c(32)*M(1))) * den(9)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(30)*M(1))) * den(9)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(33)*M(1))) * den(9)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(31)*M(1))) * den(9)
  T2sum(1:15,47) = T2sum(1:15,47) + Gcoeff * G2tensor(:,91)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,93)
  Gcoeff = (-(c(15)*M(1))) * den(9)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(5)*M(1))) * den(9)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,95)
  Gcoeff = (-(c(15)*M(1))) * den(9)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,96)
  Gcoeff = (-(c(5)*M(1))) * den(9)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(15)*M(1)) * den(9)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(5)*M(1)) * den(9)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(20)*M(1))) * den(9)
  T2sum(1:1,35) = T2sum(1:1,35) + Gcoeff * G0tensor(:,20)
  Gcoeff = (-(c(25)*M(1))) * den(9)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,21)
  Gcoeff = (-(c(10)*M(1))) * den(9)
  T2sum(1:1,36) = T2sum(1:1,36) + Gcoeff * G0tensor(:,22)
  Gcoeff = (-(c(39)*M(1))) * den(41)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(40)*M(1)) * den(41)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(39)*M(1))) * den(42)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(41)*M(1))) * den(42)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(19)*M(1))) * den(41)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(28)*M(1))) * den(42)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(14)*M(1))) * den(41)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(14)*M(1)) * den(41)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(12)*M(1)) * den(42)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,33)
  Gcoeff = (-(c(12)*M(1))) * den(42)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,33)
  Gcoeff = (-(c(15)*M(1))) * den(41)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(13)*M(1)) * den(42)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,26)
  Gcoeff = (-(c(14)*M(1))) * den(41)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(14)*M(1)) * den(41)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,55)
  Gcoeff = (-(c(21)*M(1))) * den(42)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(21)*M(1)) * den(42)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,56)
  Gcoeff = (-(c(39)*M(1))) * den(43)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(41)*M(1))) * den(43)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(28)*M(1))) * den(43)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(12)*M(1)) * den(43)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,34)
  Gcoeff = (-(c(12)*M(1))) * den(43)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(13)*M(1)) * den(43)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(21)*M(1))) * den(43)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(21)*M(1)) * den(43)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,57)
  Gcoeff = (-(c(39)*M(1))) * den(44)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(40)*M(1)) * den(44)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(39)*M(1))) * den(45)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(41)*M(1))) * den(45)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(19)*M(1))) * den(44)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,21)
  Gcoeff = (-(c(28)*M(1))) * den(45)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,22)
  Gcoeff = (-(c(14)*M(1))) * den(44)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(14)*M(1)) * den(44)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(12)*M(1)) * den(45)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,36)
  Gcoeff = (-(c(12)*M(1))) * den(45)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,36)
  Gcoeff = (-(c(15)*M(1))) * den(44)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(13)*M(1)) * den(45)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(14)*M(1))) * den(44)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(14)*M(1)) * den(44)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,58)
  Gcoeff = (-(c(21)*M(1))) * den(45)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(21)*M(1)) * den(45)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,59)
  Gcoeff = (-(c(39)*M(1))) * den(46)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(41)*M(1))) * den(46)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(28)*M(1))) * den(46)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(12)*M(1)) * den(46)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,37)
  Gcoeff = (-(c(12)*M(1))) * den(46)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(13)*M(1)) * den(46)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,30)
  Gcoeff = (-(c(21)*M(1))) * den(46)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(21)*M(1)) * den(46)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,60)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_heftpph_ew_nexnmemxgg_1_/**/REALKIND
