
module ol_vamp_1_heftpph_ew_mmxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_heftpph_ew_mmxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_heftpph_ew_mmxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_heftpph_ew_mmxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_heftpph_ew_mmxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,27) :: G0
  complex(REALKIND), dimension(4,5,4,33) :: G1
  complex(REALKIND), dimension(4,15,4,4) :: G2
  complex(REALKIND), dimension(1,1) :: G0tensor
  complex(REALKIND), dimension(5,13) :: G1tensor
  complex(REALKIND), dimension(15,21) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_SA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2),gH)
  call loop_A_Q(G0(:,:,:,2),Q(:,2),MM,G1(:,:,:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2),gH)
  call loop_A_Q(G1(:,:,:,2),Q(:,14),MM,G2(:,:,:,1))
  call check_last_AQ_S(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,1),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,3),gX)
  call loop_A_Q(G0(:,:,:,3),Q(:,2),MM,G1(:,:,:,3))
  call loop_AS_Q(G1(:,:,:,3),wf(:,2),G1(:,:,:,4),gH)
  call loop_A_Q(G1(:,:,:,4),Q(:,14),MM,G2(:,:,:,2))
  call check_last_AQ_S(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,2),gX)
  call loop_QA_S(G0(:,:,:,1),wf(:,-1),G0(:,:,:,4),gH)
  call loop_SS_S(G0(:,:,:,4),wf(:,2),G0(:,:,:,5))
  call loop_SQ_A(G0(:,:,:,5),wf(:,0),G0(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G0(:,:,:,6),Q(:,15),MM,G1tensor(:,1))
  call loop_QA_S(G0(:,:,:,1),wf(:,-1),G0(:,:,:,7),gX)
  call loop_SS_S(G0(:,:,:,7),wf(:,2),G0(:,:,:,8))
  call loop_SQ_A(G0(:,:,:,8),wf(:,0),G0(:,:,:,9),gX)
  call check_last_Q_A(l_switch,G0(:,:,:,9),Q(:,15),MM,G1tensor(:,2))
  call loop_ST_V(G0(:,:,:,7),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,5))
  call loop_ZQ_A(G1(:,:,:,5),wf(:,0),G1(:,:,:,6),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,15),MM,G2tensor(:,3))
  call loop_QA_S(G0(:,:,:,1),wf(:,-1),G0(:,:,:,10),gPln)
  call loop_SS_S(G0(:,:,:,10),wf(:,2),G0(:,:,:,11))
  call loop_SQ_A(G0(:,:,:,11),wf(:,0),G0(:,:,:,12),gPnl)
  call check_last_Q_A(l_switch,G0(:,:,:,12),Q(:,15),ZERO,G1tensor(:,3))
  call loop_ST_V(G0(:,:,:,10),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,7))
  call loop_WQ_A(G1(:,:,:,7),wf(:,0),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,15),ZERO,G2tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,2),MM,G1(:,:,:,9))
  call loop_AS_Q(G1(:,:,:,9),wf(:,2),G1(:,:,:,10),gH)
  call loop_A_Q(G1(:,:,:,10),Q(:,14),MM,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,5))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,14),gZl)
  call loop_A_Q(G0(:,:,:,14),Q(:,2),MM,G1(:,:,:,11))
  call loop_AS_Q(G1(:,:,:,11),wf(:,2),G1(:,:,:,12),gH)
  call loop_A_Q(G1(:,:,:,12),Q(:,14),MM,G2(:,:,:,4))
  call check_last_AQ_Z(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,6),gZl)
  call loop_QA_Z(G0(:,:,:,1),wf(:,-1),G0(:,:,:,15),gZl)
  call loop_VT_S(G0(:,:,:,15),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,13))
  call loop_SQ_A(G1(:,:,:,13),wf(:,0),G1(:,:,:,14),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,15),MM,G2tensor(:,7))
  call loop_VS_V(G0(:,:,:,15),wf(:,2),G0(:,:,:,16))
  call loop_ZQ_A(G0(:,:,:,16),wf(:,0),G0(:,:,:,17),gZl)
  call check_last_Q_A(l_switch,G0(:,:,:,17),Q(:,15),MM,G1tensor(:,4))
  call loop_QA_W(G0(:,:,:,1),wf(:,-1),G0(:,:,:,18))
  call loop_VT_S(G0(:,:,:,18),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,15))
  call loop_SQ_A(G1(:,:,:,15),wf(:,0),G1(:,:,:,16),gPnl)
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,15),ZERO,G2tensor(:,8))
  call loop_VS_V(G0(:,:,:,18),wf(:,2),G0(:,:,:,19))
  call loop_WQ_A(G0(:,:,:,19),wf(:,0),G0(:,:,:,20))
  call check_last_Q_A(l_switch,G0(:,:,:,20),Q(:,15),ZERO,G1tensor(:,5))
  call loop_QS_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,21),gH)
  call loop_Q_A(G0(:,:,:,21),Q(:,12),ME,G1(:,:,:,17))
  call loop_QS_A(G1(:,:,:,17),wf(:,4),G1(:,:,:,18),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,18),Q(:,15),ME,G2tensor(:,9))
  call loop_QV_A(G1(:,:,:,17),wf(:,5),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,15),ME,G2tensor(:,10))
  call loop_QZ_A(G1(:,:,:,17),wf(:,6),G1(:,:,:,20),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,15),ME,G2tensor(:,11))
  call loop_QS_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,22),gH)
  call loop_Q_A(G0(:,:,:,22),Q(:,12),MM,G1(:,:,:,21))
  call loop_QS_A(G1(:,:,:,21),wf(:,4),G1(:,:,:,22),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,15),MM,G2tensor(:,12))
  call loop_QV_A(G1(:,:,:,21),wf(:,5),G1(:,:,:,23))
  call check_last_Q_A(l_switch,G1(:,:,:,23),Q(:,15),MM,G2tensor(:,13))
  call loop_QZ_A(G1(:,:,:,21),wf(:,6),G1(:,:,:,24),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,15),MM,G2tensor(:,14))
  call loop_QS_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,23),gH)
  call loop_Q_A(G0(:,:,:,23),Q(:,12),ML,G1(:,:,:,25))
  call loop_QS_A(G1(:,:,:,25),wf(:,4),G1(:,:,:,26),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,15),ML,G2tensor(:,15))
  call loop_QV_A(G1(:,:,:,25),wf(:,5),G1(:,:,:,27))
  call check_last_Q_A(l_switch,G1(:,:,:,27),Q(:,15),ML,G2tensor(:,16))
  call loop_QZ_A(G1(:,:,:,25),wf(:,6),G1(:,:,:,28),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,15),ML,G2tensor(:,17))
  call loop_QS_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,24),gH)
  call loop_Q_A(G0(:,:,:,24),Q(:,12),MT,G1(:,:,:,29))
  call loop_QS_A(G1(:,:,:,29),wf(:,4),G1(:,:,:,30),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,15),MT,G2tensor(:,18))
  call loop_QV_A(G1(:,:,:,29),wf(:,5),G1(:,:,:,31))
  call check_last_Q_A(l_switch,G1(:,:,:,31),Q(:,15),MT,G2tensor(:,19))
  call loop_QZ_A(G1(:,:,:,29),wf(:,6),G1(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,15),MT,G2tensor(:,20))
  call loop_SS_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,25))
  call check_last_SS_S(l_switch,G0(:,:,:,25),wf(:,4),G0tensor(:,1))
  call check_last_CV_D(l_switch,G0(:,:,:,25),Q(:,12),wf(:,5),Q(:,3),G1tensor(:,6))
  call check_last_CV_D(l_switch,G0(:,:,:,25),Q(:,12),wf(:,6),Q(:,3),G1tensor(:,7))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,33))
  call check_last_ST_V(l_switch,G1(:,:,:,33),Q(:,12),wf(:,4),Q(:,3),G2tensor(:,21))
  call check_last_SV_V(l_switch,G1(:,:,:,33),wf(:,5),G1tensor(:,8))
  call check_last_SV_V(l_switch,G1(:,:,:,33),wf(:,6),G1tensor(:,9))
  call loop_SS_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,26))
  call check_last_TV_S(l_switch,G0(:,:,:,26),Q(:,12),wf(:,5),Q(:,3),G1tensor(:,10))
  call check_last_TV_S(l_switch,G0(:,:,:,26),Q(:,12),wf(:,6),Q(:,3),G1tensor(:,11))
  call loop_VS_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,12),wf(:,5),Q(:,3),G1tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,12),wf(:,6),Q(:,3),G1tensor(:,13))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(6)*M(1))) * den(2)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(6)*M(1)) * den(2)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(5)*M(1))) * den(2)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(3)*M(1)) * den(2)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(4)*M(1))) * den(2)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(16)*M(1)) * den(2)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(16)*M(1)) * den(2)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(11)*M(1))) * den(2)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(8)*M(1))) * den(2)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(11)*M(1))) * den(2)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(8)*M(1)) * den(2)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(14)*M(1)) * den(2)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(1)*M(1)) * den(2)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(19)*M(1))) * den(5)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(21)*M(1))) * den(5)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(20)*M(1))) * den(5)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(22)*M(1)) * den(5)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(2)*M(1))) * den(5)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(2)*M(1)) * den(5)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(7)*M(1))) * den(5)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(7)*M(1)) * den(5)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(23)*M(1))) * den(6)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(25)*M(1))) * den(6)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(24)*M(1))) * den(6)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(26)*M(1)) * den(6)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(23)*M(1))) * den(5)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(25)*M(1))) * den(5)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(24)*M(1))) * den(5)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(27)*M(1))) * den(5)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(15)*M(1))) * den(6)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(18)*M(1))) * den(5)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(12)*M(1))) * den(6)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(12)*M(1)) * den(6)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(9)*M(1)) * den(5)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(9)*M(1))) * den(5)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(13)*M(1))) * den(6)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(10)*M(1)) * den(5)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,13)
  Gcoeff = (-(c(12)*M(1))) * den(6)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(12)*M(1)) * den(6)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(17)*M(1))) * den(5)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(17)*M(1)) * den(5)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,9)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_heftpph_ew_mmxgg_1_/**/REALKIND
