
! **********************************************************************
module ol_tensor_sum_storage_heftpph_ew_nmnmxeexgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,1)
  complex(REALKIND) :: momenta_2(4,1)
  complex(REALKIND) :: momenta_3(4,1)
  complex(REALKIND) :: momenta_4(4,2)
  complex(REALKIND) :: momenta_5(4,2)
  complex(REALKIND) :: momenta_6(4,2)
  complex(REALKIND) :: momenta_7(4,2)
  complex(REALKIND) :: momenta_8(4,2)
  complex(REALKIND) :: momenta_9(4,2)
  complex(REALKIND) :: momenta_10(4,2)
  complex(REALKIND) :: momenta_11(4,3)
  complex(REALKIND) :: momenta_12(4,3)
  complex(REALKIND) :: momenta_13(4,3)
  complex(REALKIND) :: momenta_14(4,3)
  complex(REALKIND) :: momenta_15(4,3)
  complex(REALKIND) :: momenta_16(4,3)
  complex(REALKIND) :: momenta_17(4,4)
  complex(REALKIND) :: momenta_18(4,4)
  complex(REALKIND) :: momenta_19(4,4)
  complex(REALKIND) :: momenta_20(4,4)

  complex(REALKIND), save :: masses2_1(2)
  complex(REALKIND), save :: masses2_2(2)
  complex(REALKIND), save :: masses2_3(2)
  complex(REALKIND), save :: masses2_4(2)
  complex(REALKIND), save :: masses2_5(2)
  complex(REALKIND), save :: masses2_6(2)
  complex(REALKIND), save :: masses2_7(2)
  complex(REALKIND), save :: masses2_8(3)
  complex(REALKIND), save :: masses2_9(3)
  complex(REALKIND), save :: masses2_10(3)
  complex(REALKIND), save :: masses2_11(3)
  complex(REALKIND), save :: masses2_12(3)
  complex(REALKIND), save :: masses2_13(3)
  complex(REALKIND), save :: masses2_14(3)
  complex(REALKIND), save :: masses2_15(3)
  complex(REALKIND), save :: masses2_16(3)
  complex(REALKIND), save :: masses2_17(3)
  complex(REALKIND), save :: masses2_18(4)
  complex(REALKIND), save :: masses2_19(4)
  complex(REALKIND), save :: masses2_20(4)
  complex(REALKIND), save :: masses2_21(4)
  complex(REALKIND), save :: masses2_22(4)
  complex(REALKIND), save :: masses2_23(4)
  complex(REALKIND), save :: masses2_24(5)
  complex(REALKIND), save :: masses2_25(5)
  complex(REALKIND), save :: masses2_26(5)
  complex(REALKIND), save :: masses2_27(5)

  complex(REALKIND), save :: T0sum(1,2) = 0
  complex(REALKIND), save :: T1sum(5,9) = 0
  complex(REALKIND), save :: T2sum(15,36) = 0
  complex(REALKIND), save :: T3sum(35,2) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_heftpph_ew_nmnmxeexgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_heftpph_ew_nmnmxeexgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 3
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none
  T0sum = 0
  T1sum = 0
  T2sum = 0
  T3sum = 0

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(:,1), -4)
  call scale_one_tsum(T0sum(:,2), -4)
  call scale_one_tsum(T1sum(:,1), -2)
  call scale_one_tsum(T1sum(:,2), -2)
  call scale_one_tsum(T1sum(:,3), -2)
  call scale_one_tsum(T1sum(:,4), -2)
  call scale_one_tsum(T1sum(:,5), -2)
  call scale_one_tsum(T1sum(:,6), -2)
  call scale_one_tsum(T1sum(:,7), -2)
  call scale_one_tsum(T1sum(:,8), -2)
  call scale_one_tsum(T1sum(:,9), -4)
  call scale_one_tsum(T2sum(:,1), -2)
  call scale_one_tsum(T2sum(:,2), -2)
  call scale_one_tsum(T2sum(:,3), -2)
  call scale_one_tsum(T2sum(:,4), -2)
  call scale_one_tsum(T2sum(:,5), -2)
  call scale_one_tsum(T2sum(:,6), -2)
  call scale_one_tsum(T2sum(:,7), -2)
  call scale_one_tsum(T2sum(:,8), 0)
  call scale_one_tsum(T2sum(:,9), 0)
  call scale_one_tsum(T2sum(:,10), 0)
  call scale_one_tsum(T2sum(:,11), 0)
  call scale_one_tsum(T2sum(:,12), -2)
  call scale_one_tsum(T2sum(:,13), -2)
  call scale_one_tsum(T2sum(:,14), -2)
  call scale_one_tsum(T2sum(:,15), 0)
  call scale_one_tsum(T2sum(:,16), 0)
  call scale_one_tsum(T2sum(:,17), 0)
  call scale_one_tsum(T2sum(:,18), 0)
  call scale_one_tsum(T2sum(:,19), 2)
  call scale_one_tsum(T2sum(:,20), 2)
  call scale_one_tsum(T2sum(:,21), 2)
  call scale_one_tsum(T2sum(:,22), 2)
  call scale_one_tsum(T2sum(:,23), 2)
  call scale_one_tsum(T2sum(:,24), 2)
  call scale_one_tsum(T2sum(:,25), -4)
  call scale_one_tsum(T2sum(:,26), -4)
  call scale_one_tsum(T2sum(:,27), -4)
  call scale_one_tsum(T2sum(:,28), -4)
  call scale_one_tsum(T2sum(:,29), -4)
  call scale_one_tsum(T2sum(:,30), -4)
  call scale_one_tsum(T2sum(:,31), -4)
  call scale_one_tsum(T2sum(:,32), -4)
  call scale_one_tsum(T2sum(:,33), -4)
  call scale_one_tsum(T2sum(:,34), -4)
  call scale_one_tsum(T2sum(:,35), -4)
  call scale_one_tsum(T2sum(:,36), -4)
  call scale_one_tsum(T3sum(:,1), -2)
  call scale_one_tsum(T3sum(:,2), -2)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_heftpph_ew_nmnmxeexgg_1, only: &
       & channel_number_heftpph_ew_nmnmxeexgg_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_heftpph_ew_nmnmxeexgg_1)
  M2 = 0

  momenta_1(:,1) = Q(1:4,48)
  momenta_2(:,1) = Q(1:4,51)
  momenta_3(:,1) = Q(1:4,60)
  momenta_4(:,1) = Q(1:4,2)
  momenta_4(:,2) = Q(1:4,62)
  momenta_5(:,1) = Q(1:4,8)
  momenta_5(:,2) = Q(1:4,56)
  momenta_6(:,1) = Q(1:4,8)
  momenta_6(:,2) = Q(1:4,59)
  momenta_7(:,1) = Q(1:4,11)
  momenta_7(:,2) = Q(1:4,59)
  momenta_8(:,1) = Q(1:4,12)
  momenta_8(:,2) = Q(1:4,60)
  momenta_9(:,1) = Q(1:4,13)
  momenta_9(:,2) = Q(1:4,61)
  momenta_10(:,1) = Q(1:4,14)
  momenta_10(:,2) = Q(1:4,62)
  momenta_11(:,1) = Q(1:4,2)
  momenta_11(:,2) = Q(1:4,14)
  momenta_11(:,3) = Q(1:4,62)
  momenta_12(:,1) = Q(1:4,2)
  momenta_12(:,2) = Q(1:4,50)
  momenta_12(:,3) = Q(1:4,62)
  momenta_13(:,1) = Q(1:4,4)
  momenta_13(:,2) = Q(1:4,12)
  momenta_13(:,3) = Q(1:4,60)
  momenta_14(:,1) = Q(1:4,4)
  momenta_14(:,2) = Q(1:4,52)
  momenta_14(:,3) = Q(1:4,60)
  momenta_15(:,1) = Q(1:4,8)
  momenta_15(:,2) = Q(1:4,12)
  momenta_15(:,3) = Q(1:4,60)
  momenta_16(:,1) = Q(1:4,12)
  momenta_16(:,2) = Q(1:4,14)
  momenta_16(:,3) = Q(1:4,62)
  momenta_17(:,1) = Q(1:4,2)
  momenta_17(:,2) = Q(1:4,6)
  momenta_17(:,3) = Q(1:4,14)
  momenta_17(:,4) = Q(1:4,62)
  momenta_18(:,1) = Q(1:4,2)
  momenta_18(:,2) = Q(1:4,10)
  momenta_18(:,3) = Q(1:4,14)
  momenta_18(:,4) = Q(1:4,62)
  momenta_19(:,1) = Q(1:4,2)
  momenta_19(:,2) = Q(1:4,50)
  momenta_19(:,3) = Q(1:4,54)
  momenta_19(:,4) = Q(1:4,62)
  momenta_20(:,1) = Q(1:4,2)
  momenta_20(:,2) = Q(1:4,50)
  momenta_20(:,3) = Q(1:4,58)
  momenta_20(:,4) = Q(1:4,62)

  masses2_1 = [ MH2, MH2 ]
  masses2_2 = [ MZ2, MH2 ]
  masses2_3 = [ ML2, ML2 ]
  masses2_4 = [ MT2, MT2 ]
  masses2_5 = [ MW2, MW2 ]
  masses2_6 = [ MZ2, MZ2 ]
  masses2_7 = [ ZERO2, ZERO2 ]
  masses2_8 = [ MZ2, MH2, MH2 ]
  masses2_9 = [ ML2, ML2, ML2 ]
  masses2_10 = [ MT2, MT2, MT2 ]
  masses2_11 = [ MW2, MW2, MW2 ]
  masses2_12 = [ ZERO2, MW2, MW2 ]
  masses2_13 = [ MH2, MZ2, MZ2 ]
  masses2_14 = [ ZERO2, MZ2, MZ2 ]
  masses2_15 = [ MW2, ZERO2, ZERO2 ]
  masses2_16 = [ MZ2, ZERO2, ZERO2 ]
  masses2_17 = [ ZERO2, ZERO2, ZERO2 ]
  masses2_18 = [ ZERO2, MW2, MW2, MW2 ]
  masses2_19 = [ ZERO2, MW2, MW2, ZERO2 ]
  masses2_20 = [ ZERO2, MZ2, MZ2, ZERO2 ]
  masses2_21 = [ MW2, ZERO2, MW2, MW2 ]
  masses2_22 = [ ZERO2, ZERO2, MW2, MW2 ]
  masses2_23 = [ ZERO2, ZERO2, MZ2, MZ2 ]
  masses2_24 = [ ZERO2, MW2, MW2, ZERO2, MW2 ]
  masses2_25 = [ ZERO2, MW2, ZERO2, MW2, MW2 ]
  masses2_26 = [ ZERO2, MZ2, MZ2, ZERO2, MZ2 ]
  masses2_27 = [ ZERO2, MZ2, ZERO2, MZ2, MZ2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call TI_call(0, momenta_1, masses2_1, T0sum(:,1), M2)
  call TI_call(0, momenta_1, masses2_6, T0sum(:,2), M2)

  call TI_call(1, momenta_5, masses2_14, T1sum(:,1), M2)
  call TI_call(1, momenta_5, masses2_12, T1sum(:,2), M2)
  call TI_call(1, momenta_7, masses2_14, T1sum(:,3), M2)
  call TI_call(1, momenta_7, masses2_12, T1sum(:,4), M2)
  call TI_call(1, momenta_9, masses2_14, T1sum(:,5), M2)
  call TI_call(1, momenta_9, masses2_12, T1sum(:,6), M2)
  call TI_call(1, momenta_10, masses2_14, T1sum(:,7), M2)
  call TI_call(1, momenta_10, masses2_12, T1sum(:,8), M2)
  call TI_call(1, momenta_1, masses2_5, T1sum(:,9), M2)

  call TI_call(2, momenta_8, masses2_11, T2sum(:,1), M2)
  call TI_call(2, momenta_8, masses2_8, T2sum(:,2), M2)
  call TI_call(2, momenta_8, masses2_13, T2sum(:,3), M2)
  call TI_call(2, momenta_6, masses2_17, T2sum(:,4), M2)
  call TI_call(2, momenta_6, masses2_16, T2sum(:,5), M2)
  call TI_call(2, momenta_6, masses2_15, T2sum(:,6), M2)
  call TI_call(2, momenta_6, masses2_12, T2sum(:,7), M2)
  call TI_call(2, momenta_13, masses2_21, T2sum(:,8), M2)
  call TI_call(2, momenta_15, masses2_21, T2sum(:,9), M2)
  call TI_call(2, momenta_14, masses2_20, T2sum(:,10), M2)
  call TI_call(2, momenta_14, masses2_19, T2sum(:,11), M2)
  call TI_call(2, momenta_4, masses2_16, T2sum(:,12), M2)
  call TI_call(2, momenta_4, masses2_15, T2sum(:,13), M2)
  call TI_call(2, momenta_4, masses2_12, T2sum(:,14), M2)
  call TI_call(2, momenta_12, masses2_18, T2sum(:,15), M2)
  call TI_call(2, momenta_11, masses2_18, T2sum(:,16), M2)
  call TI_call(2, momenta_16, masses2_22, T2sum(:,17), M2)
  call TI_call(2, momenta_16, masses2_23, T2sum(:,18), M2)
  call TI_call(2, momenta_20, masses2_26, T2sum(:,19), M2)
  call TI_call(2, momenta_20, masses2_24, T2sum(:,20), M2)
  call TI_call(2, momenta_19, masses2_26, T2sum(:,21), M2)
  call TI_call(2, momenta_17, masses2_27, T2sum(:,22), M2)
  call TI_call(2, momenta_18, masses2_27, T2sum(:,23), M2)
  call TI_call(2, momenta_18, masses2_25, T2sum(:,24), M2)
  call TI_call(2, momenta_3, masses2_5, T2sum(:,25), M2)
  call TI_call(2, momenta_3, masses2_2, T2sum(:,26), M2)
  call TI_call(2, momenta_2, masses2_5, T2sum(:,27), M2)
  call TI_call(2, momenta_2, masses2_2, T2sum(:,28), M2)
  call TI_call(2, momenta_2, masses2_3, T2sum(:,29), M2)
  call TI_call(2, momenta_2, masses2_4, T2sum(:,30), M2)
  call TI_call(2, momenta_2, masses2_7, T2sum(:,31), M2)
  call TI_call(2, momenta_3, masses2_3, T2sum(:,32), M2)
  call TI_call(2, momenta_3, masses2_4, T2sum(:,33), M2)
  call TI_call(2, momenta_3, masses2_7, T2sum(:,34), M2)
  call TI_call(2, momenta_1, masses2_3, T2sum(:,35), M2)
  call TI_call(2, momenta_1, masses2_4, T2sum(:,36), M2)

  call TI_call(3, momenta_8, masses2_9, T3sum(:,1), M2)
  call TI_call(3, momenta_8, masses2_10, T3sum(:,2), M2)

#ifdef LOOPSQUARED
  end if
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_heftpph_ew_nmnmxeexgg_1_/**/REALKIND
