
! **********************************************************************
module ol_tensor_sum_storage_heftpph_ew_nexnmemxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,1)
  complex(REALKIND) :: momenta_2(4,1)
  complex(REALKIND) :: momenta_3(4,1)
  complex(REALKIND) :: momenta_4(4,2)
  complex(REALKIND) :: momenta_5(4,2)
  complex(REALKIND) :: momenta_6(4,2)
  complex(REALKIND) :: momenta_7(4,2)
  complex(REALKIND) :: momenta_8(4,2)
  complex(REALKIND) :: momenta_9(4,2)
  complex(REALKIND) :: momenta_10(4,2)
  complex(REALKIND) :: momenta_11(4,2)
  complex(REALKIND) :: momenta_12(4,2)
  complex(REALKIND) :: momenta_13(4,3)
  complex(REALKIND) :: momenta_14(4,3)
  complex(REALKIND) :: momenta_15(4,3)
  complex(REALKIND) :: momenta_16(4,3)
  complex(REALKIND) :: momenta_17(4,3)
  complex(REALKIND) :: momenta_18(4,3)
  complex(REALKIND) :: momenta_19(4,3)
  complex(REALKIND) :: momenta_20(4,3)
  complex(REALKIND) :: momenta_21(4,4)
  complex(REALKIND) :: momenta_22(4,4)
  complex(REALKIND) :: momenta_23(4,4)
  complex(REALKIND) :: momenta_24(4,4)
  complex(REALKIND) :: momenta_25(4,4)

  complex(REALKIND), save :: masses2_1(2)
  complex(REALKIND), save :: masses2_2(2)
  complex(REALKIND), save :: masses2_3(2)
  complex(REALKIND), save :: masses2_4(2)
  complex(REALKIND), save :: masses2_5(2)
  complex(REALKIND), save :: masses2_6(2)
  complex(REALKIND), save :: masses2_7(2)
  complex(REALKIND), save :: masses2_8(2)
  complex(REALKIND), save :: masses2_9(2)
  complex(REALKIND), save :: masses2_10(2)
  complex(REALKIND), save :: masses2_11(2)
  complex(REALKIND), save :: masses2_12(2)
  complex(REALKIND), save :: masses2_13(2)
  complex(REALKIND), save :: masses2_14(3)
  complex(REALKIND), save :: masses2_15(3)
  complex(REALKIND), save :: masses2_16(3)
  complex(REALKIND), save :: masses2_17(3)
  complex(REALKIND), save :: masses2_18(3)
  complex(REALKIND), save :: masses2_19(3)
  complex(REALKIND), save :: masses2_20(3)
  complex(REALKIND), save :: masses2_21(3)
  complex(REALKIND), save :: masses2_22(3)
  complex(REALKIND), save :: masses2_23(3)
  complex(REALKIND), save :: masses2_24(3)
  complex(REALKIND), save :: masses2_25(3)
  complex(REALKIND), save :: masses2_26(4)
  complex(REALKIND), save :: masses2_27(4)
  complex(REALKIND), save :: masses2_28(4)
  complex(REALKIND), save :: masses2_29(4)
  complex(REALKIND), save :: masses2_30(4)
  complex(REALKIND), save :: masses2_31(4)
  complex(REALKIND), save :: masses2_32(4)
  complex(REALKIND), save :: masses2_33(4)
  complex(REALKIND), save :: masses2_34(4)
  complex(REALKIND), save :: masses2_35(5)
  complex(REALKIND), save :: masses2_36(5)
  complex(REALKIND), save :: masses2_37(5)
  complex(REALKIND), save :: masses2_38(5)
  complex(REALKIND), save :: masses2_39(5)
  complex(REALKIND), save :: masses2_40(5)
  complex(REALKIND), save :: masses2_41(5)

  complex(REALKIND), save :: T0sum(1,2) = 0
  complex(REALKIND), save :: T1sum(5,11) = 0
  complex(REALKIND), save :: T2sum(15,50) = 0
  complex(REALKIND), save :: T3sum(35,2) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_heftpph_ew_nexnmemxgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_heftpph_ew_nexnmemxgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 3
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none
  T0sum = 0
  T1sum = 0
  T2sum = 0
  T3sum = 0

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(:,1), -4)
  call scale_one_tsum(T0sum(:,2), -4)
  call scale_one_tsum(T1sum(:,1), -2)
  call scale_one_tsum(T1sum(:,2), -2)
  call scale_one_tsum(T1sum(:,3), -2)
  call scale_one_tsum(T1sum(:,4), -2)
  call scale_one_tsum(T1sum(:,5), -2)
  call scale_one_tsum(T1sum(:,6), -2)
  call scale_one_tsum(T1sum(:,7), -2)
  call scale_one_tsum(T1sum(:,8), -2)
  call scale_one_tsum(T1sum(:,9), -4)
  call scale_one_tsum(T1sum(:,10), -4)
  call scale_one_tsum(T1sum(:,11), -4)
  call scale_one_tsum(T2sum(:,1), -2)
  call scale_one_tsum(T2sum(:,2), -2)
  call scale_one_tsum(T2sum(:,3), -2)
  call scale_one_tsum(T2sum(:,4), -2)
  call scale_one_tsum(T2sum(:,5), -2)
  call scale_one_tsum(T2sum(:,6), -2)
  call scale_one_tsum(T2sum(:,7), -2)
  call scale_one_tsum(T2sum(:,8), -2)
  call scale_one_tsum(T2sum(:,9), -2)
  call scale_one_tsum(T2sum(:,10), 0)
  call scale_one_tsum(T2sum(:,11), 0)
  call scale_one_tsum(T2sum(:,12), 0)
  call scale_one_tsum(T2sum(:,13), 0)
  call scale_one_tsum(T2sum(:,14), 0)
  call scale_one_tsum(T2sum(:,15), 0)
  call scale_one_tsum(T2sum(:,16), -2)
  call scale_one_tsum(T2sum(:,17), -2)
  call scale_one_tsum(T2sum(:,18), -2)
  call scale_one_tsum(T2sum(:,19), -2)
  call scale_one_tsum(T2sum(:,20), 0)
  call scale_one_tsum(T2sum(:,21), 0)
  call scale_one_tsum(T2sum(:,22), 0)
  call scale_one_tsum(T2sum(:,23), 0)
  call scale_one_tsum(T2sum(:,24), 0)
  call scale_one_tsum(T2sum(:,25), 0)
  call scale_one_tsum(T2sum(:,26), 2)
  call scale_one_tsum(T2sum(:,27), 2)
  call scale_one_tsum(T2sum(:,28), 2)
  call scale_one_tsum(T2sum(:,29), 2)
  call scale_one_tsum(T2sum(:,30), 2)
  call scale_one_tsum(T2sum(:,31), 2)
  call scale_one_tsum(T2sum(:,32), 2)
  call scale_one_tsum(T2sum(:,33), 2)
  call scale_one_tsum(T2sum(:,34), 2)
  call scale_one_tsum(T2sum(:,35), -4)
  call scale_one_tsum(T2sum(:,36), -4)
  call scale_one_tsum(T2sum(:,37), -4)
  call scale_one_tsum(T2sum(:,38), -4)
  call scale_one_tsum(T2sum(:,39), -4)
  call scale_one_tsum(T2sum(:,40), -4)
  call scale_one_tsum(T2sum(:,41), -4)
  call scale_one_tsum(T2sum(:,42), -4)
  call scale_one_tsum(T2sum(:,43), -4)
  call scale_one_tsum(T2sum(:,44), -4)
  call scale_one_tsum(T2sum(:,45), -4)
  call scale_one_tsum(T2sum(:,46), -4)
  call scale_one_tsum(T2sum(:,47), -4)
  call scale_one_tsum(T2sum(:,48), -4)
  call scale_one_tsum(T2sum(:,49), -4)
  call scale_one_tsum(T2sum(:,50), -4)
  call scale_one_tsum(T3sum(:,1), -2)
  call scale_one_tsum(T3sum(:,2), -2)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_heftpph_ew_nexnmemxgg_1, only: &
       & channel_number_heftpph_ew_nexnmemxgg_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_heftpph_ew_nexnmemxgg_1)
  M2 = 0

  momenta_1(:,1) = Q(1:4,48)
  momenta_2(:,1) = Q(1:4,53)
  momenta_3(:,1) = Q(1:4,58)
  momenta_4(:,1) = Q(1:4,4)
  momenta_4(:,2) = Q(1:4,62)
  momenta_5(:,1) = Q(1:4,8)
  momenta_5(:,2) = Q(1:4,56)
  momenta_6(:,1) = Q(1:4,8)
  momenta_6(:,2) = Q(1:4,61)
  momenta_7(:,1) = Q(1:4,10)
  momenta_7(:,2) = Q(1:4,58)
  momenta_8(:,1) = Q(1:4,11)
  momenta_8(:,2) = Q(1:4,59)
  momenta_9(:,1) = Q(1:4,13)
  momenta_9(:,2) = Q(1:4,61)
  momenta_10(:,1) = Q(1:4,14)
  momenta_10(:,2) = Q(1:4,62)
  momenta_11(:,1) = Q(1:4,53)
  momenta_11(:,2) = Q(1:4,55)
  momenta_12(:,1) = Q(1:4,58)
  momenta_12(:,2) = Q(1:4,59)
  momenta_13(:,1) = Q(1:4,4)
  momenta_13(:,2) = Q(1:4,14)
  momenta_13(:,3) = Q(1:4,62)
  momenta_14(:,1) = Q(1:4,4)
  momenta_14(:,2) = Q(1:4,52)
  momenta_14(:,3) = Q(1:4,62)
  momenta_15(:,1) = Q(1:4,5)
  momenta_15(:,2) = Q(1:4,13)
  momenta_15(:,3) = Q(1:4,61)
  momenta_16(:,1) = Q(1:4,5)
  momenta_16(:,2) = Q(1:4,53)
  momenta_16(:,3) = Q(1:4,61)
  momenta_17(:,1) = Q(1:4,8)
  momenta_17(:,2) = Q(1:4,10)
  momenta_17(:,3) = Q(1:4,58)
  momenta_18(:,1) = Q(1:4,8)
  momenta_18(:,2) = Q(1:4,13)
  momenta_18(:,3) = Q(1:4,61)
  momenta_19(:,1) = Q(1:4,10)
  momenta_19(:,2) = Q(1:4,14)
  momenta_19(:,3) = Q(1:4,62)
  momenta_20(:,1) = Q(1:4,10)
  momenta_20(:,2) = Q(1:4,58)
  momenta_20(:,3) = Q(1:4,59)
  momenta_21(:,1) = Q(1:4,2)
  momenta_21(:,2) = Q(1:4,10)
  momenta_21(:,3) = Q(1:4,58)
  momenta_21(:,4) = Q(1:4,62)
  momenta_22(:,1) = Q(1:4,4)
  momenta_22(:,2) = Q(1:4,6)
  momenta_22(:,3) = Q(1:4,14)
  momenta_22(:,4) = Q(1:4,62)
  momenta_23(:,1) = Q(1:4,4)
  momenta_23(:,2) = Q(1:4,12)
  momenta_23(:,3) = Q(1:4,14)
  momenta_23(:,4) = Q(1:4,62)
  momenta_24(:,1) = Q(1:4,4)
  momenta_24(:,2) = Q(1:4,52)
  momenta_24(:,3) = Q(1:4,54)
  momenta_24(:,4) = Q(1:4,62)
  momenta_25(:,1) = Q(1:4,8)
  momenta_25(:,2) = Q(1:4,10)
  momenta_25(:,3) = Q(1:4,58)
  momenta_25(:,4) = Q(1:4,59)

  masses2_1 = [ MH2, MH2 ]
  masses2_2 = [ MW2, MH2 ]
  masses2_3 = [ ML2, ML2 ]
  masses2_4 = [ MT2, MT2 ]
  masses2_5 = [ ZERO2, MT2 ]
  masses2_6 = [ MW2, MW2 ]
  masses2_7 = [ MZ2, MW2 ]
  masses2_8 = [ ZERO2, MW2 ]
  masses2_9 = [ MW2, MZ2 ]
  masses2_10 = [ MZ2, MZ2 ]
  masses2_11 = [ ML2, ZERO2 ]
  masses2_12 = [ MW2, ZERO2 ]
  masses2_13 = [ ZERO2, ZERO2 ]
  masses2_14 = [ MW2, MH2, MH2 ]
  masses2_15 = [ ZERO2, ML2, ML2 ]
  masses2_16 = [ ZERO2, MT2, MT2 ]
  masses2_17 = [ MH2, MW2, MW2 ]
  masses2_18 = [ MZ2, MW2, MW2 ]
  masses2_19 = [ ZERO2, MW2, MW2 ]
  masses2_20 = [ ZERO2, MW2, MZ2 ]
  masses2_21 = [ ZERO2, MW2, ZERO2 ]
  masses2_22 = [ ZERO2, MZ2, MW2 ]
  masses2_23 = [ MW2, MZ2, MZ2 ]
  masses2_24 = [ ZERO2, MZ2, MZ2 ]
  masses2_25 = [ MZ2, ZERO2, ZERO2 ]
  masses2_26 = [ ZERO2, MW2, MW2, MZ2 ]
  masses2_27 = [ MZ2, MW2, MW2, ZERO2 ]
  masses2_28 = [ ZERO2, MW2, MW2, ZERO2 ]
  masses2_29 = [ ZERO2, MW2, MZ2, MZ2 ]
  masses2_30 = [ ZERO2, MZ2, MW2, MW2 ]
  masses2_31 = [ ZERO2, MZ2, MZ2, MW2 ]
  masses2_32 = [ MW2, MZ2, MZ2, ZERO2 ]
  masses2_33 = [ ZERO2, ZERO2, MW2, MW2 ]
  masses2_34 = [ ZERO2, ZERO2, MZ2, MZ2 ]
  masses2_35 = [ ZERO2, MW2, MW2, ZERO2, MZ2 ]
  masses2_36 = [ ZERO2, MW2, ZERO2, MZ2, MZ2 ]
  masses2_37 = [ ZERO2, MZ2, MZ2, ZERO2, MW2 ]
  masses2_38 = [ ZERO2, MZ2, ZERO2, MW2, MW2 ]
  masses2_39 = [ MZ2, ZERO2, MW2, MW2, ZERO2 ]
  masses2_40 = [ ZERO2, ZERO2, MW2, MW2, ZERO2 ]
  masses2_41 = [ MW2, ZERO2, MZ2, MZ2, ZERO2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call TI_call(0, momenta_1, masses2_1, T0sum(:,1), M2)
  call TI_call(0, momenta_1, masses2_10, T0sum(:,2), M2)

  call TI_call(1, momenta_5, masses2_24, T1sum(:,1), M2)
  call TI_call(1, momenta_5, masses2_19, T1sum(:,2), M2)
  call TI_call(1, momenta_9, masses2_24, T1sum(:,3), M2)
  call TI_call(1, momenta_9, masses2_19, T1sum(:,4), M2)
  call TI_call(1, momenta_8, masses2_24, T1sum(:,5), M2)
  call TI_call(1, momenta_8, masses2_19, T1sum(:,6), M2)
  call TI_call(1, momenta_10, masses2_24, T1sum(:,7), M2)
  call TI_call(1, momenta_10, masses2_19, T1sum(:,8), M2)
  call TI_call(1, momenta_3, masses2_7, T1sum(:,9), M2)
  call TI_call(1, momenta_2, masses2_7, T1sum(:,10), M2)
  call TI_call(1, momenta_1, masses2_6, T1sum(:,11), M2)

  call TI_call(2, momenta_7, masses2_14, T2sum(:,1), M2)
  call TI_call(2, momenta_7, masses2_23, T2sum(:,2), M2)
  call TI_call(2, momenta_7, masses2_17, T2sum(:,3), M2)
  call TI_call(2, momenta_7, masses2_18, T2sum(:,4), M2)
  call TI_call(2, momenta_7, masses2_19, T2sum(:,5), M2)
  call TI_call(2, momenta_11, masses2_21, T2sum(:,6), M2)
  call TI_call(2, momenta_6, masses2_20, T2sum(:,7), M2)
  call TI_call(2, momenta_6, masses2_22, T2sum(:,8), M2)
  call TI_call(2, momenta_6, masses2_25, T2sum(:,9), M2)
  call TI_call(2, momenta_16, masses2_27, T2sum(:,10), M2)
  call TI_call(2, momenta_16, masses2_32, T2sum(:,11), M2)
  call TI_call(2, momenta_17, masses2_33, T2sum(:,12), M2)
  call TI_call(2, momenta_18, masses2_30, T2sum(:,13), M2)
  call TI_call(2, momenta_18, masses2_29, T2sum(:,14), M2)
  call TI_call(2, momenta_15, masses2_34, T2sum(:,15), M2)
  call TI_call(2, momenta_12, masses2_21, T2sum(:,16), M2)
  call TI_call(2, momenta_4, masses2_20, T2sum(:,17), M2)
  call TI_call(2, momenta_4, masses2_22, T2sum(:,18), M2)
  call TI_call(2, momenta_4, masses2_25, T2sum(:,19), M2)
  call TI_call(2, momenta_14, masses2_26, T2sum(:,20), M2)
  call TI_call(2, momenta_14, masses2_31, T2sum(:,21), M2)
  call TI_call(2, momenta_20, masses2_28, T2sum(:,22), M2)
  call TI_call(2, momenta_13, masses2_30, T2sum(:,23), M2)
  call TI_call(2, momenta_13, masses2_29, T2sum(:,24), M2)
  call TI_call(2, momenta_19, masses2_34, T2sum(:,25), M2)
  call TI_call(2, momenta_21, masses2_41, T2sum(:,26), M2)
  call TI_call(2, momenta_21, masses2_39, T2sum(:,27), M2)
  call TI_call(2, momenta_24, masses2_37, T2sum(:,28), M2)
  call TI_call(2, momenta_24, masses2_35, T2sum(:,29), M2)
  call TI_call(2, momenta_22, masses2_36, T2sum(:,30), M2)
  call TI_call(2, momenta_22, masses2_38, T2sum(:,31), M2)
  call TI_call(2, momenta_23, masses2_36, T2sum(:,32), M2)
  call TI_call(2, momenta_25, masses2_40, T2sum(:,33), M2)
  call TI_call(2, momenta_23, masses2_38, T2sum(:,34), M2)
  call TI_call(2, momenta_3, masses2_8, T2sum(:,35), M2)
  call TI_call(2, momenta_3, masses2_2, T2sum(:,36), M2)
  call TI_call(2, momenta_2, masses2_8, T2sum(:,37), M2)
  call TI_call(2, momenta_2, masses2_2, T2sum(:,38), M2)
  call TI_call(2, momenta_1, masses2_3, T2sum(:,39), M2)
  call TI_call(2, momenta_1, masses2_4, T2sum(:,40), M2)
  call TI_call(2, momenta_2, masses2_11, T2sum(:,41), M2)
  call TI_call(2, momenta_2, masses2_5, T2sum(:,42), M2)
  call TI_call(2, momenta_2, masses2_12, T2sum(:,43), M2)
  call TI_call(2, momenta_2, masses2_9, T2sum(:,44), M2)
  call TI_call(2, momenta_2, masses2_13, T2sum(:,45), M2)
  call TI_call(2, momenta_3, masses2_11, T2sum(:,46), M2)
  call TI_call(2, momenta_3, masses2_5, T2sum(:,47), M2)
  call TI_call(2, momenta_3, masses2_9, T2sum(:,48), M2)
  call TI_call(2, momenta_3, masses2_12, T2sum(:,49), M2)
  call TI_call(2, momenta_3, masses2_13, T2sum(:,50), M2)

  call TI_call(3, momenta_7, masses2_15, T3sum(:,1), M2)
  call TI_call(3, momenta_7, masses2_16, T3sum(:,2), M2)

#ifdef LOOPSQUARED
  end if
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_heftpph_ew_nexnmemxgg_1_/**/REALKIND
