
! **********************************************************************
module ol_tensor_sum_storage_heftpph_ew_nenexeexgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,1)
  complex(REALKIND) :: momenta_2(4,1)
  complex(REALKIND) :: momenta_3(4,1)
  complex(REALKIND) :: momenta_4(4,1)
  complex(REALKIND) :: momenta_5(4,1)
  complex(REALKIND) :: momenta_6(4,2)
  complex(REALKIND) :: momenta_7(4,2)
  complex(REALKIND) :: momenta_8(4,2)
  complex(REALKIND) :: momenta_9(4,2)
  complex(REALKIND) :: momenta_10(4,2)
  complex(REALKIND) :: momenta_11(4,2)
  complex(REALKIND) :: momenta_12(4,2)
  complex(REALKIND) :: momenta_13(4,2)
  complex(REALKIND) :: momenta_14(4,2)
  complex(REALKIND) :: momenta_15(4,2)
  complex(REALKIND) :: momenta_16(4,2)
  complex(REALKIND) :: momenta_17(4,2)
  complex(REALKIND) :: momenta_18(4,3)
  complex(REALKIND) :: momenta_19(4,3)
  complex(REALKIND) :: momenta_20(4,3)
  complex(REALKIND) :: momenta_21(4,3)
  complex(REALKIND) :: momenta_22(4,3)
  complex(REALKIND) :: momenta_23(4,3)
  complex(REALKIND) :: momenta_24(4,3)
  complex(REALKIND) :: momenta_25(4,3)
  complex(REALKIND) :: momenta_26(4,3)
  complex(REALKIND) :: momenta_27(4,3)
  complex(REALKIND) :: momenta_28(4,3)
  complex(REALKIND) :: momenta_29(4,3)
  complex(REALKIND) :: momenta_30(4,3)
  complex(REALKIND) :: momenta_31(4,3)
  complex(REALKIND) :: momenta_32(4,4)
  complex(REALKIND) :: momenta_33(4,4)
  complex(REALKIND) :: momenta_34(4,4)
  complex(REALKIND) :: momenta_35(4,4)
  complex(REALKIND) :: momenta_36(4,4)
  complex(REALKIND) :: momenta_37(4,4)
  complex(REALKIND) :: momenta_38(4,4)
  complex(REALKIND) :: momenta_39(4,4)
  complex(REALKIND) :: momenta_40(4,4)

  complex(REALKIND), save :: masses2_1(2)
  complex(REALKIND), save :: masses2_2(2)
  complex(REALKIND), save :: masses2_3(2)
  complex(REALKIND), save :: masses2_4(2)
  complex(REALKIND), save :: masses2_5(2)
  complex(REALKIND), save :: masses2_6(2)
  complex(REALKIND), save :: masses2_7(2)
  complex(REALKIND), save :: masses2_8(2)
  complex(REALKIND), save :: masses2_9(2)
  complex(REALKIND), save :: masses2_10(2)
  complex(REALKIND), save :: masses2_11(2)
  complex(REALKIND), save :: masses2_12(2)
  complex(REALKIND), save :: masses2_13(2)
  complex(REALKIND), save :: masses2_14(2)
  complex(REALKIND), save :: masses2_15(3)
  complex(REALKIND), save :: masses2_16(3)
  complex(REALKIND), save :: masses2_17(3)
  complex(REALKIND), save :: masses2_18(3)
  complex(REALKIND), save :: masses2_19(3)
  complex(REALKIND), save :: masses2_20(3)
  complex(REALKIND), save :: masses2_21(3)
  complex(REALKIND), save :: masses2_22(3)
  complex(REALKIND), save :: masses2_23(3)
  complex(REALKIND), save :: masses2_24(3)
  complex(REALKIND), save :: masses2_25(3)
  complex(REALKIND), save :: masses2_26(3)
  complex(REALKIND), save :: masses2_27(3)
  complex(REALKIND), save :: masses2_28(3)
  complex(REALKIND), save :: masses2_29(3)
  complex(REALKIND), save :: masses2_30(3)
  complex(REALKIND), save :: masses2_31(3)
  complex(REALKIND), save :: masses2_32(3)
  complex(REALKIND), save :: masses2_33(3)
  complex(REALKIND), save :: masses2_34(4)
  complex(REALKIND), save :: masses2_35(4)
  complex(REALKIND), save :: masses2_36(4)
  complex(REALKIND), save :: masses2_37(4)
  complex(REALKIND), save :: masses2_38(4)
  complex(REALKIND), save :: masses2_39(4)
  complex(REALKIND), save :: masses2_40(4)
  complex(REALKIND), save :: masses2_41(4)
  complex(REALKIND), save :: masses2_42(4)
  complex(REALKIND), save :: masses2_43(4)
  complex(REALKIND), save :: masses2_44(4)
  complex(REALKIND), save :: masses2_45(4)
  complex(REALKIND), save :: masses2_46(5)
  complex(REALKIND), save :: masses2_47(5)
  complex(REALKIND), save :: masses2_48(5)
  complex(REALKIND), save :: masses2_49(5)
  complex(REALKIND), save :: masses2_50(5)
  complex(REALKIND), save :: masses2_51(5)
  complex(REALKIND), save :: masses2_52(5)
  complex(REALKIND), save :: masses2_53(5)
  complex(REALKIND), save :: masses2_54(5)

  complex(REALKIND), save :: T0sum(1,2) = 0
  complex(REALKIND), save :: T1sum(5,11) = 0
  complex(REALKIND), save :: T2sum(15,84) = 0
  complex(REALKIND), save :: T3sum(35,4) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_heftpph_ew_nenexeexgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_heftpph_ew_nenexeexgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 3
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none
  T0sum = 0
  T1sum = 0
  T2sum = 0
  T3sum = 0

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(:,1), -4)
  call scale_one_tsum(T0sum(:,2), -4)
  call scale_one_tsum(T1sum(:,1), -2)
  call scale_one_tsum(T1sum(:,2), -2)
  call scale_one_tsum(T1sum(:,3), -2)
  call scale_one_tsum(T1sum(:,4), -2)
  call scale_one_tsum(T1sum(:,5), -2)
  call scale_one_tsum(T1sum(:,6), -2)
  call scale_one_tsum(T1sum(:,7), -2)
  call scale_one_tsum(T1sum(:,8), -2)
  call scale_one_tsum(T1sum(:,9), -4)
  call scale_one_tsum(T1sum(:,10), -4)
  call scale_one_tsum(T1sum(:,11), -4)
  call scale_one_tsum(T2sum(:,1), -2)
  call scale_one_tsum(T2sum(:,2), -2)
  call scale_one_tsum(T2sum(:,3), -2)
  call scale_one_tsum(T2sum(:,4), -2)
  call scale_one_tsum(T2sum(:,5), -2)
  call scale_one_tsum(T2sum(:,6), -2)
  call scale_one_tsum(T2sum(:,7), -2)
  call scale_one_tsum(T2sum(:,8), 0)
  call scale_one_tsum(T2sum(:,9), 0)
  call scale_one_tsum(T2sum(:,10), 0)
  call scale_one_tsum(T2sum(:,11), 0)
  call scale_one_tsum(T2sum(:,12), -2)
  call scale_one_tsum(T2sum(:,13), -2)
  call scale_one_tsum(T2sum(:,14), -2)
  call scale_one_tsum(T2sum(:,15), -2)
  call scale_one_tsum(T2sum(:,16), -2)
  call scale_one_tsum(T2sum(:,17), -2)
  call scale_one_tsum(T2sum(:,18), -2)
  call scale_one_tsum(T2sum(:,19), -2)
  call scale_one_tsum(T2sum(:,20), -2)
  call scale_one_tsum(T2sum(:,21), 0)
  call scale_one_tsum(T2sum(:,22), 0)
  call scale_one_tsum(T2sum(:,23), 0)
  call scale_one_tsum(T2sum(:,24), 0)
  call scale_one_tsum(T2sum(:,25), 0)
  call scale_one_tsum(T2sum(:,26), 0)
  call scale_one_tsum(T2sum(:,27), -2)
  call scale_one_tsum(T2sum(:,28), -2)
  call scale_one_tsum(T2sum(:,29), -2)
  call scale_one_tsum(T2sum(:,30), -2)
  call scale_one_tsum(T2sum(:,31), 0)
  call scale_one_tsum(T2sum(:,32), 0)
  call scale_one_tsum(T2sum(:,33), 0)
  call scale_one_tsum(T2sum(:,34), 0)
  call scale_one_tsum(T2sum(:,35), 0)
  call scale_one_tsum(T2sum(:,36), 0)
  call scale_one_tsum(T2sum(:,37), -2)
  call scale_one_tsum(T2sum(:,38), -2)
  call scale_one_tsum(T2sum(:,39), -2)
  call scale_one_tsum(T2sum(:,40), 0)
  call scale_one_tsum(T2sum(:,41), 0)
  call scale_one_tsum(T2sum(:,42), 0)
  call scale_one_tsum(T2sum(:,43), 0)
  call scale_one_tsum(T2sum(:,44), 2)
  call scale_one_tsum(T2sum(:,45), 2)
  call scale_one_tsum(T2sum(:,46), 2)
  call scale_one_tsum(T2sum(:,47), 2)
  call scale_one_tsum(T2sum(:,48), 2)
  call scale_one_tsum(T2sum(:,49), 2)
  call scale_one_tsum(T2sum(:,50), 2)
  call scale_one_tsum(T2sum(:,51), 2)
  call scale_one_tsum(T2sum(:,52), 2)
  call scale_one_tsum(T2sum(:,53), 2)
  call scale_one_tsum(T2sum(:,54), 2)
  call scale_one_tsum(T2sum(:,55), 2)
  call scale_one_tsum(T2sum(:,56), 2)
  call scale_one_tsum(T2sum(:,57), 2)
  call scale_one_tsum(T2sum(:,58), 2)
  call scale_one_tsum(T2sum(:,59), -4)
  call scale_one_tsum(T2sum(:,60), -4)
  call scale_one_tsum(T2sum(:,61), -4)
  call scale_one_tsum(T2sum(:,62), -4)
  call scale_one_tsum(T2sum(:,63), -4)
  call scale_one_tsum(T2sum(:,64), -4)
  call scale_one_tsum(T2sum(:,65), -4)
  call scale_one_tsum(T2sum(:,66), -4)
  call scale_one_tsum(T2sum(:,67), -4)
  call scale_one_tsum(T2sum(:,68), -4)
  call scale_one_tsum(T2sum(:,69), -4)
  call scale_one_tsum(T2sum(:,70), -4)
  call scale_one_tsum(T2sum(:,71), -4)
  call scale_one_tsum(T2sum(:,72), -4)
  call scale_one_tsum(T2sum(:,73), -4)
  call scale_one_tsum(T2sum(:,74), -4)
  call scale_one_tsum(T2sum(:,75), -4)
  call scale_one_tsum(T2sum(:,76), -4)
  call scale_one_tsum(T2sum(:,77), -4)
  call scale_one_tsum(T2sum(:,78), -4)
  call scale_one_tsum(T2sum(:,79), -4)
  call scale_one_tsum(T2sum(:,80), -4)
  call scale_one_tsum(T2sum(:,81), -4)
  call scale_one_tsum(T2sum(:,82), -4)
  call scale_one_tsum(T2sum(:,83), -4)
  call scale_one_tsum(T2sum(:,84), -4)
  call scale_one_tsum(T3sum(:,1), -2)
  call scale_one_tsum(T3sum(:,2), -2)
  call scale_one_tsum(T3sum(:,3), -2)
  call scale_one_tsum(T3sum(:,4), -2)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_heftpph_ew_nenexeexgg_1, only: &
       & channel_number_heftpph_ew_nenexeexgg_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_heftpph_ew_nenexeexgg_1)
  M2 = 0

  momenta_1(:,1) = Q(1:4,48)
  momenta_2(:,1) = Q(1:4,51)
  momenta_3(:,1) = Q(1:4,54)
  momenta_4(:,1) = Q(1:4,57)
  momenta_5(:,1) = Q(1:4,60)
  momenta_6(:,1) = Q(1:4,2)
  momenta_6(:,2) = Q(1:4,62)
  momenta_7(:,1) = Q(1:4,4)
  momenta_7(:,2) = Q(1:4,61)
  momenta_8(:,1) = Q(1:4,8)
  momenta_8(:,2) = Q(1:4,56)
  momenta_9(:,1) = Q(1:4,8)
  momenta_9(:,2) = Q(1:4,59)
  momenta_10(:,1) = Q(1:4,8)
  momenta_10(:,2) = Q(1:4,62)
  momenta_11(:,1) = Q(1:4,9)
  momenta_11(:,2) = Q(1:4,57)
  momenta_12(:,1) = Q(1:4,11)
  momenta_12(:,2) = Q(1:4,59)
  momenta_13(:,1) = Q(1:4,12)
  momenta_13(:,2) = Q(1:4,60)
  momenta_14(:,1) = Q(1:4,13)
  momenta_14(:,2) = Q(1:4,61)
  momenta_15(:,1) = Q(1:4,14)
  momenta_15(:,2) = Q(1:4,62)
  momenta_16(:,1) = Q(1:4,54)
  momenta_16(:,2) = Q(1:4,55)
  momenta_17(:,1) = Q(1:4,57)
  momenta_17(:,2) = Q(1:4,59)
  momenta_18(:,1) = Q(1:4,2)
  momenta_18(:,2) = Q(1:4,14)
  momenta_18(:,3) = Q(1:4,62)
  momenta_19(:,1) = Q(1:4,2)
  momenta_19(:,2) = Q(1:4,50)
  momenta_19(:,3) = Q(1:4,62)
  momenta_20(:,1) = Q(1:4,4)
  momenta_20(:,2) = Q(1:4,12)
  momenta_20(:,3) = Q(1:4,60)
  momenta_21(:,1) = Q(1:4,4)
  momenta_21(:,2) = Q(1:4,13)
  momenta_21(:,3) = Q(1:4,61)
  momenta_22(:,1) = Q(1:4,4)
  momenta_22(:,2) = Q(1:4,52)
  momenta_22(:,3) = Q(1:4,60)
  momenta_23(:,1) = Q(1:4,4)
  momenta_23(:,2) = Q(1:4,52)
  momenta_23(:,3) = Q(1:4,61)
  momenta_24(:,1) = Q(1:4,6)
  momenta_24(:,2) = Q(1:4,14)
  momenta_24(:,3) = Q(1:4,62)
  momenta_25(:,1) = Q(1:4,6)
  momenta_25(:,2) = Q(1:4,54)
  momenta_25(:,3) = Q(1:4,62)
  momenta_26(:,1) = Q(1:4,8)
  momenta_26(:,2) = Q(1:4,9)
  momenta_26(:,3) = Q(1:4,57)
  momenta_27(:,1) = Q(1:4,8)
  momenta_27(:,2) = Q(1:4,12)
  momenta_27(:,3) = Q(1:4,60)
  momenta_28(:,1) = Q(1:4,8)
  momenta_28(:,2) = Q(1:4,14)
  momenta_28(:,3) = Q(1:4,62)
  momenta_29(:,1) = Q(1:4,9)
  momenta_29(:,2) = Q(1:4,13)
  momenta_29(:,3) = Q(1:4,61)
  momenta_30(:,1) = Q(1:4,9)
  momenta_30(:,2) = Q(1:4,57)
  momenta_30(:,3) = Q(1:4,59)
  momenta_31(:,1) = Q(1:4,12)
  momenta_31(:,2) = Q(1:4,14)
  momenta_31(:,3) = Q(1:4,62)
  momenta_32(:,1) = Q(1:4,2)
  momenta_32(:,2) = Q(1:4,6)
  momenta_32(:,3) = Q(1:4,14)
  momenta_32(:,4) = Q(1:4,62)
  momenta_33(:,1) = Q(1:4,2)
  momenta_33(:,2) = Q(1:4,6)
  momenta_33(:,3) = Q(1:4,54)
  momenta_33(:,4) = Q(1:4,62)
  momenta_34(:,1) = Q(1:4,2)
  momenta_34(:,2) = Q(1:4,10)
  momenta_34(:,3) = Q(1:4,14)
  momenta_34(:,4) = Q(1:4,62)
  momenta_35(:,1) = Q(1:4,2)
  momenta_35(:,2) = Q(1:4,50)
  momenta_35(:,3) = Q(1:4,54)
  momenta_35(:,4) = Q(1:4,62)
  momenta_36(:,1) = Q(1:4,2)
  momenta_36(:,2) = Q(1:4,50)
  momenta_36(:,3) = Q(1:4,58)
  momenta_36(:,4) = Q(1:4,62)
  momenta_37(:,1) = Q(1:4,4)
  momenta_37(:,2) = Q(1:4,6)
  momenta_37(:,3) = Q(1:4,54)
  momenta_37(:,4) = Q(1:4,62)
  momenta_38(:,1) = Q(1:4,8)
  momenta_38(:,2) = Q(1:4,9)
  momenta_38(:,3) = Q(1:4,57)
  momenta_38(:,4) = Q(1:4,59)
  momenta_39(:,1) = Q(1:4,8)
  momenta_39(:,2) = Q(1:4,10)
  momenta_39(:,3) = Q(1:4,14)
  momenta_39(:,4) = Q(1:4,62)
  momenta_40(:,1) = Q(1:4,8)
  momenta_40(:,2) = Q(1:4,12)
  momenta_40(:,3) = Q(1:4,14)
  momenta_40(:,4) = Q(1:4,62)

  masses2_1 = [ MH2, MH2 ]
  masses2_2 = [ MW2, MH2 ]
  masses2_3 = [ MZ2, MH2 ]
  masses2_4 = [ ML2, ML2 ]
  masses2_5 = [ MT2, MT2 ]
  masses2_6 = [ ZERO2, MT2 ]
  masses2_7 = [ MW2, MW2 ]
  masses2_8 = [ MZ2, MW2 ]
  masses2_9 = [ ZERO2, MW2 ]
  masses2_10 = [ MW2, MZ2 ]
  masses2_11 = [ MZ2, MZ2 ]
  masses2_12 = [ ML2, ZERO2 ]
  masses2_13 = [ MW2, ZERO2 ]
  masses2_14 = [ ZERO2, ZERO2 ]
  masses2_15 = [ MW2, MH2, MH2 ]
  masses2_16 = [ MZ2, MH2, MH2 ]
  masses2_17 = [ ML2, ML2, ML2 ]
  masses2_18 = [ ZERO2, ML2, ML2 ]
  masses2_19 = [ MT2, MT2, MT2 ]
  masses2_20 = [ ZERO2, MT2, MT2 ]
  masses2_21 = [ MH2, MW2, MW2 ]
  masses2_22 = [ MW2, MW2, MW2 ]
  masses2_23 = [ MZ2, MW2, MW2 ]
  masses2_24 = [ ZERO2, MW2, MW2 ]
  masses2_25 = [ ZERO2, MW2, MZ2 ]
  masses2_26 = [ ZERO2, MW2, ZERO2 ]
  masses2_27 = [ ZERO2, MZ2, MW2 ]
  masses2_28 = [ MH2, MZ2, MZ2 ]
  masses2_29 = [ MW2, MZ2, MZ2 ]
  masses2_30 = [ ZERO2, MZ2, MZ2 ]
  masses2_31 = [ MW2, ZERO2, ZERO2 ]
  masses2_32 = [ MZ2, ZERO2, ZERO2 ]
  masses2_33 = [ ZERO2, ZERO2, ZERO2 ]
  masses2_34 = [ ZERO2, MW2, MW2, MW2 ]
  masses2_35 = [ ZERO2, MW2, MW2, MZ2 ]
  masses2_36 = [ MZ2, MW2, MW2, ZERO2 ]
  masses2_37 = [ ZERO2, MW2, MW2, ZERO2 ]
  masses2_38 = [ ZERO2, MW2, MZ2, MZ2 ]
  masses2_39 = [ ZERO2, MZ2, MW2, MW2 ]
  masses2_40 = [ ZERO2, MZ2, MZ2, MW2 ]
  masses2_41 = [ MW2, MZ2, MZ2, ZERO2 ]
  masses2_42 = [ ZERO2, MZ2, MZ2, ZERO2 ]
  masses2_43 = [ MW2, ZERO2, MW2, MW2 ]
  masses2_44 = [ ZERO2, ZERO2, MW2, MW2 ]
  masses2_45 = [ ZERO2, ZERO2, MZ2, MZ2 ]
  masses2_46 = [ ZERO2, MW2, MW2, ZERO2, MW2 ]
  masses2_47 = [ ZERO2, MW2, ZERO2, MW2, MW2 ]
  masses2_48 = [ ZERO2, MW2, ZERO2, MZ2, MZ2 ]
  masses2_49 = [ ZERO2, MZ2, MZ2, ZERO2, MZ2 ]
  masses2_50 = [ ZERO2, MZ2, ZERO2, MW2, MW2 ]
  masses2_51 = [ ZERO2, MZ2, ZERO2, MZ2, MZ2 ]
  masses2_52 = [ MZ2, ZERO2, MW2, MW2, ZERO2 ]
  masses2_53 = [ ZERO2, ZERO2, MW2, MW2, ZERO2 ]
  masses2_54 = [ MW2, ZERO2, MZ2, MZ2, ZERO2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call TI_call(0, momenta_1, masses2_1, T0sum(:,1), M2)
  call TI_call(0, momenta_1, masses2_11, T0sum(:,2), M2)

  call TI_call(1, momenta_8, masses2_30, T1sum(:,1), M2)
  call TI_call(1, momenta_8, masses2_24, T1sum(:,2), M2)
  call TI_call(1, momenta_12, masses2_30, T1sum(:,3), M2)
  call TI_call(1, momenta_12, masses2_24, T1sum(:,4), M2)
  call TI_call(1, momenta_15, masses2_30, T1sum(:,5), M2)
  call TI_call(1, momenta_15, masses2_24, T1sum(:,6), M2)
  call TI_call(1, momenta_14, masses2_30, T1sum(:,7), M2)
  call TI_call(1, momenta_14, masses2_24, T1sum(:,8), M2)
  call TI_call(1, momenta_1, masses2_7, T1sum(:,9), M2)
  call TI_call(1, momenta_3, masses2_8, T1sum(:,10), M2)
  call TI_call(1, momenta_4, masses2_8, T1sum(:,11), M2)

  call TI_call(2, momenta_13, masses2_22, T2sum(:,1), M2)
  call TI_call(2, momenta_13, masses2_16, T2sum(:,2), M2)
  call TI_call(2, momenta_13, masses2_28, T2sum(:,3), M2)
  call TI_call(2, momenta_9, masses2_33, T2sum(:,4), M2)
  call TI_call(2, momenta_9, masses2_32, T2sum(:,5), M2)
  call TI_call(2, momenta_9, masses2_31, T2sum(:,6), M2)
  call TI_call(2, momenta_9, masses2_24, T2sum(:,7), M2)
  call TI_call(2, momenta_20, masses2_43, T2sum(:,8), M2)
  call TI_call(2, momenta_27, masses2_43, T2sum(:,9), M2)
  call TI_call(2, momenta_22, masses2_42, T2sum(:,10), M2)
  call TI_call(2, momenta_22, masses2_37, T2sum(:,11), M2)
  call TI_call(2, momenta_11, masses2_15, T2sum(:,12), M2)
  call TI_call(2, momenta_11, masses2_29, T2sum(:,13), M2)
  call TI_call(2, momenta_11, masses2_21, T2sum(:,14), M2)
  call TI_call(2, momenta_11, masses2_23, T2sum(:,15), M2)
  call TI_call(2, momenta_11, masses2_24, T2sum(:,16), M2)
  call TI_call(2, momenta_16, masses2_26, T2sum(:,17), M2)
  call TI_call(2, momenta_10, masses2_25, T2sum(:,18), M2)
  call TI_call(2, momenta_10, masses2_27, T2sum(:,19), M2)
  call TI_call(2, momenta_10, masses2_32, T2sum(:,20), M2)
  call TI_call(2, momenta_25, masses2_36, T2sum(:,21), M2)
  call TI_call(2, momenta_25, masses2_41, T2sum(:,22), M2)
  call TI_call(2, momenta_26, masses2_44, T2sum(:,23), M2)
  call TI_call(2, momenta_28, masses2_39, T2sum(:,24), M2)
  call TI_call(2, momenta_28, masses2_38, T2sum(:,25), M2)
  call TI_call(2, momenta_24, masses2_45, T2sum(:,26), M2)
  call TI_call(2, momenta_17, masses2_26, T2sum(:,27), M2)
  call TI_call(2, momenta_7, masses2_25, T2sum(:,28), M2)
  call TI_call(2, momenta_7, masses2_27, T2sum(:,29), M2)
  call TI_call(2, momenta_7, masses2_32, T2sum(:,30), M2)
  call TI_call(2, momenta_23, masses2_35, T2sum(:,31), M2)
  call TI_call(2, momenta_23, masses2_40, T2sum(:,32), M2)
  call TI_call(2, momenta_30, masses2_37, T2sum(:,33), M2)
  call TI_call(2, momenta_21, masses2_39, T2sum(:,34), M2)
  call TI_call(2, momenta_21, masses2_38, T2sum(:,35), M2)
  call TI_call(2, momenta_29, masses2_45, T2sum(:,36), M2)
  call TI_call(2, momenta_6, masses2_32, T2sum(:,37), M2)
  call TI_call(2, momenta_6, masses2_31, T2sum(:,38), M2)
  call TI_call(2, momenta_6, masses2_24, T2sum(:,39), M2)
  call TI_call(2, momenta_19, masses2_34, T2sum(:,40), M2)
  call TI_call(2, momenta_18, masses2_34, T2sum(:,41), M2)
  call TI_call(2, momenta_31, masses2_44, T2sum(:,42), M2)
  call TI_call(2, momenta_31, masses2_45, T2sum(:,43), M2)
  call TI_call(2, momenta_36, masses2_49, T2sum(:,44), M2)
  call TI_call(2, momenta_36, masses2_46, T2sum(:,45), M2)
  call TI_call(2, momenta_33, masses2_54, T2sum(:,46), M2)
  call TI_call(2, momenta_33, masses2_52, T2sum(:,47), M2)
  call TI_call(2, momenta_35, masses2_49, T2sum(:,48), M2)
  call TI_call(2, momenta_32, masses2_51, T2sum(:,49), M2)
  call TI_call(2, momenta_34, masses2_51, T2sum(:,50), M2)
  call TI_call(2, momenta_34, masses2_47, T2sum(:,51), M2)
  call TI_call(2, momenta_37, masses2_54, T2sum(:,52), M2)
  call TI_call(2, momenta_37, masses2_52, T2sum(:,53), M2)
  call TI_call(2, momenta_39, masses2_48, T2sum(:,54), M2)
  call TI_call(2, momenta_39, masses2_50, T2sum(:,55), M2)
  call TI_call(2, momenta_40, masses2_48, T2sum(:,56), M2)
  call TI_call(2, momenta_38, masses2_53, T2sum(:,57), M2)
  call TI_call(2, momenta_40, masses2_50, T2sum(:,58), M2)
  call TI_call(2, momenta_5, masses2_7, T2sum(:,59), M2)
  call TI_call(2, momenta_5, masses2_3, T2sum(:,60), M2)
  call TI_call(2, momenta_2, masses2_7, T2sum(:,61), M2)
  call TI_call(2, momenta_2, masses2_3, T2sum(:,62), M2)
  call TI_call(2, momenta_3, masses2_9, T2sum(:,63), M2)
  call TI_call(2, momenta_3, masses2_2, T2sum(:,64), M2)
  call TI_call(2, momenta_4, masses2_9, T2sum(:,65), M2)
  call TI_call(2, momenta_4, masses2_2, T2sum(:,66), M2)
  call TI_call(2, momenta_2, masses2_4, T2sum(:,67), M2)
  call TI_call(2, momenta_2, masses2_5, T2sum(:,68), M2)
  call TI_call(2, momenta_2, masses2_14, T2sum(:,69), M2)
  call TI_call(2, momenta_5, masses2_4, T2sum(:,70), M2)
  call TI_call(2, momenta_5, masses2_5, T2sum(:,71), M2)
  call TI_call(2, momenta_5, masses2_14, T2sum(:,72), M2)
  call TI_call(2, momenta_1, masses2_4, T2sum(:,73), M2)
  call TI_call(2, momenta_1, masses2_5, T2sum(:,74), M2)
  call TI_call(2, momenta_4, masses2_12, T2sum(:,75), M2)
  call TI_call(2, momenta_4, masses2_6, T2sum(:,76), M2)
  call TI_call(2, momenta_4, masses2_10, T2sum(:,77), M2)
  call TI_call(2, momenta_4, masses2_13, T2sum(:,78), M2)
  call TI_call(2, momenta_4, masses2_14, T2sum(:,79), M2)
  call TI_call(2, momenta_3, masses2_12, T2sum(:,80), M2)
  call TI_call(2, momenta_3, masses2_6, T2sum(:,81), M2)
  call TI_call(2, momenta_3, masses2_13, T2sum(:,82), M2)
  call TI_call(2, momenta_3, masses2_10, T2sum(:,83), M2)
  call TI_call(2, momenta_3, masses2_14, T2sum(:,84), M2)

  call TI_call(3, momenta_13, masses2_17, T3sum(:,1), M2)
  call TI_call(3, momenta_13, masses2_19, T3sum(:,2), M2)
  call TI_call(3, momenta_11, masses2_18, T3sum(:,3), M2)
  call TI_call(3, momenta_11, masses2_20, T3sum(:,4), M2)

#ifdef LOOPSQUARED
  end if
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_heftpph_ew_nenexeexgg_1_/**/REALKIND
