
! **********************************************************************
module ol_tensor_sum_storage_heftpph_ew_mmxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,1)
  complex(REALKIND) :: momenta_2(4,2)

  complex(REALKIND), save :: masses2_1(2)
  complex(REALKIND), save :: masses2_2(2)
  complex(REALKIND), save :: masses2_3(2)
  complex(REALKIND), save :: masses2_4(2)
  complex(REALKIND), save :: masses2_5(2)
  complex(REALKIND), save :: masses2_6(3)
  complex(REALKIND), save :: masses2_7(3)
  complex(REALKIND), save :: masses2_8(3)
  complex(REALKIND), save :: masses2_9(3)
  complex(REALKIND), save :: masses2_10(3)
  complex(REALKIND), save :: masses2_11(3)

  complex(REALKIND), save :: T1sum(5,1) = 0
  complex(REALKIND), save :: T2sum(15,10) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_heftpph_ew_mmxgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 3
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_heftpph_ew_mmxgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 2
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none
  T1sum = 0
  T2sum = 0

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(:,1), 2)
  call scale_one_tsum(T2sum(:,1), 2)
  call scale_one_tsum(T2sum(:,2), 2)
  call scale_one_tsum(T2sum(:,3), 2)
  call scale_one_tsum(T2sum(:,4), 2)
  call scale_one_tsum(T2sum(:,5), 2)
  call scale_one_tsum(T2sum(:,6), 0)
  call scale_one_tsum(T2sum(:,7), 0)
  call scale_one_tsum(T2sum(:,8), 0)
  call scale_one_tsum(T2sum(:,9), 0)
  call scale_one_tsum(T2sum(:,10), 0)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_heftpph_ew_mmxgg_1, only: &
       & channel_number_heftpph_ew_mmxgg_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_heftpph_ew_mmxgg_1)
  M2 = 0

  momenta_1(:,1) = Q(1:4,12)
  momenta_2(:,1) = Q(1:4,2)
  momenta_2(:,2) = Q(1:4,14)

  masses2_1 = [ ME2, ME2 ]
  masses2_2 = [ ML2, ML2 ]
  masses2_3 = [ MM2, MM2 ]
  masses2_4 = [ MT2, MT2 ]
  masses2_5 = [ MW2, MW2 ]
  masses2_6 = [ MM2, MH2, MH2 ]
  masses2_7 = [ MH2, MM2, MM2 ]
  masses2_8 = [ MZ2, MM2, MM2 ]
  masses2_9 = [ ZERO2, MM2, MM2 ]
  masses2_10 = [ ZERO2, MW2, MW2 ]
  masses2_11 = [ MM2, MZ2, MZ2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call TI_call(1, momenta_2, masses2_6, T1sum(:,1), M2)

  call TI_call(2, momenta_2, masses2_7, T2sum(:,1), M2)
  call TI_call(2, momenta_2, masses2_8, T2sum(:,2), M2)
  call TI_call(2, momenta_2, masses2_11, T2sum(:,3), M2)
  call TI_call(2, momenta_2, masses2_10, T2sum(:,4), M2)
  call TI_call(2, momenta_2, masses2_9, T2sum(:,5), M2)
  call TI_call(2, momenta_1, masses2_1, T2sum(:,6), M2)
  call TI_call(2, momenta_1, masses2_3, T2sum(:,7), M2)
  call TI_call(2, momenta_1, masses2_2, T2sum(:,8), M2)
  call TI_call(2, momenta_1, masses2_4, T2sum(:,9), M2)
  call TI_call(2, momenta_1, masses2_5, T2sum(:,10), M2)

#ifdef LOOPSQUARED
  end if
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_heftpph_ew_mmxgg_1_/**/REALKIND
