
FeynArtsProcess = {F[1, {1}], -F[1, {1}]} -> {-F[2, {1}], F[2, {1}], V[5], V[5]};

SortExternal = True;

OpenLoopsModel = "HEFT";

CreateTopologiesOptions = {
  ExcludeTopologies -> {Snails, WFCorrectionCTs, TadpoleCTs},
  Adjacencies -> {3, 4, 5, 6}
};

InsertFieldsOptions = {
  Model -> {"HEFT", "HEFTR2"},
  GenericModel -> "HEFT",
  InsertionLevel -> {Particles},
  Restrictions -> {ExcludeParticles -> {V[4]}, NoQuarkMixing}
};

UnitaryGauge = False;

ColourCorrelations = Automatic;

OTFColourCorrelations = Automatic;

SpinCorrelatedHardFactor = Automatic;

SubProcessName = Automatic;

SelectCoupling = Exponent[#1, eQED] == 4 + 2*#2 && Exponent[#1, gQCD] == 2 & ;

SelectInterference = {
  gQCD -> {4},
  DOI -> {0}
};

SelectTreeDiagrams = HasResonance[S[1], {5, 6}][##1] & ;

SelectLoopDiagrams = HasResonance[S[1], {5, 6}][##1] & ;

SelectCTDiagrams = HasResonance[S[1], {5, 6}][##1] & ;

ReplaceOSw = False;

SetParameters = {
  MB -> 0,
  YB -> 0,
  ME -> 0,
  YE -> 0,
  MM -> 0,
  YM -> 0,
  CKMORDER -> 0,
  nc -> 3,
  nf -> 6,
  nfl -> 3,
  MU -> 0,
  MD -> 0,
  MS -> 0,
  MC -> 0,
  LeadingColour -> 0,
  POLSEL -> 1
};

ChannelMap = {};

Approximation = "";

QED = 0;

ForceLoops = Automatic;

ForceLoopsInclude = Automatic;

NonZeroHels = Null;

OnTheFlyMode = 0;

noQCD = False;

noEW = False;

SetExternalSubtrees = {};
