
module ol_colourmatrix_heftpph_ew_nenexeexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 2]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 2]

  K2(1,:) = [ 2]

  KL(1,:) = [ 2]


  end subroutine colourmatrix_init
end module ol_colourmatrix_heftpph_ew_nenexeexgg_1_/**/REALKIND



module ol_forced_parameters_heftpph_ew_nenexeexgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (YB /= 0) write(*,101) 'YB = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (YM /= 0) write(*,101) 'YM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_heftpph_ew_nenexeexgg_1_/**/REALKIND

module ol_loop_heftpph_ew_nenexeexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(93), c(87)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:66)
  ! denominators
  complex(REALKIND), save :: den(89)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,64), Mct(1,64), Mcol_loop(1,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD**2)/(48._/**/REALKIND*pi**2*sw**4)
    f( 2) = (CI*countertermnorm*eQED**6*gQCD**2)/(48._/**/REALKIND*pi**2*sw**4)
    f( 3) = (CI*countertermnorm*eQED**6*EWctVen*gQCD**2)/(48._/**/REALKIND*pi**2*sw**4)
    f( 4) = (CI*countertermnorm*eQED**6*EWctVne*gQCD**2)/(48._/**/REALKIND*pi**2*sw**4)
    f( 5) = (CI*countertermnorm*eQED**6*gQCD**2)/(96._/**/REALKIND*MW*pi**2*sw**4)
    f( 6) = (CI*countertermnorm*eQED**6*EWctHWW*gQCD**2)/(48._/**/REALKIND*MW*pi**2*sw**3)
    f( 7) = (CI*eQED**4*gQCD**2)/(24._/**/REALKIND*cw**2*pi**2*sw**2)
    f( 8) = (CI*countertermnorm*eQED**6*gQCD**2)/(24._/**/REALKIND*cw**2*pi**2*sw**2)
    f( 9) = (countertermnorm*eQED**6*gQCD**2)/(cw*MW*pi**2*sw**2*48._/**/REALKIND)
    f(10) = (CI*countertermnorm*eQED**6*EWctHZA*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f(11) = (CI*countertermnorm*eQED**6*EWctHZZ*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f(12) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*48._/**/REALKIND)
    f(13) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw**2*pi**2*48._/**/REALKIND)
    f(14) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**4*pi**2*24._/**/REALKIND)
    f(15) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**2*pi**2*24._/**/REALKIND)
    f(16) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**6*192._/**/REALKIND)
    f(17) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**6*96._/**/REALKIND)
    f(18) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**6*48._/**/REALKIND)
    f(19) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**6*96._/**/REALKIND)
    f(20) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**6*48._/**/REALKIND)
    f(21) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(pi**2*sw**6*32._/**/REALKIND)
    f(22) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**6*384._/**/REALKIND)
    f(23) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**6*192._/**/REALKIND)
    f(24) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(MW**2*pi**2*sw**6*128._/**/REALKIND)
    f(25) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(pi**2*sw**6*48._/**/REALKIND)
    f(26) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**5*48._/**/REALKIND)
    f(27) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**5*96._/**/REALKIND)
    f(28) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**5*48._/**/REALKIND)
    f(29) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*96._/**/REALKIND)
    f(30) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f(31) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*24._/**/REALKIND)
    f(32) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**4*pi**2*sw**4*96._/**/REALKIND)
    f(33) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**4*pi**2*sw**4*48._/**/REALKIND)
    f(34) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**4*192._/**/REALKIND)
    f(35) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**4*48._/**/REALKIND)
    f(36) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f(37) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*24._/**/REALKIND)
    f(38) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(pi**2*sw**4*96._/**/REALKIND)
    f(39) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(cw**4*pi**2*sw**4*16._/**/REALKIND)
    f(40) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**4*96._/**/REALKIND)
    f(41) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw**2*MW**2*pi**2*sw**4*192._/**/REALKIND)
    f(42) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW**2*pi**2*sw**4*64._/**/REALKIND)
    f(43) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f(44) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**6*pi**2*sw**4*24._/**/REALKIND)
    f(45) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**3*96._/**/REALKIND)
    f(46) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**3*24._/**/REALKIND)
    f(47) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*48._/**/REALKIND)
    f(48) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*24._/**/REALKIND)
    f(49) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*48._/**/REALKIND)
    f(50) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*24._/**/REALKIND)
    f(51) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**2*96._/**/REALKIND)
    f(52) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**2*24._/**/REALKIND)
    f(53) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw**2*pi**2*sw**2*96._/**/REALKIND)
    f(54) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(55) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**4*pi**2*sw**2*48._/**/REALKIND)
    f(56) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**2*pi**2*sw**2*48._/**/REALKIND)
    f(57) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw*48._/**/REALKIND)
    f(58) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw*pi**2*sw*48._/**/REALKIND)
    f(59) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**3*pi**2*sw*24._/**/REALKIND)
    f(60) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw*pi**2*sw*24._/**/REALKIND)
    f(61) = -((eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(pi**2*sw**6*192._/**/REALKIND))
    f(62) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**2*pi**2*sw**6*192._/**/REALKIND))
    f(63) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**5*192._/**/REALKIND))
    f(64) = (eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*pi**2*sw**2*96._/**/REALKIND)
    f(65) = (eQED**6*gQCD**2*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*pi**2*sw**4*192._/**/REALKIND)
    f(66) = -((eQED**6*gQCD**2*integralnorm*SwB*(cw**4*48._/**/REALKIND + sw**4*48._/**/REALKIND  &
      - cw**2*sw**2*96._/**/REALKIND))/(cw**4*pi**2*sw**4*48._/**/REALKIND*96._/**/REALKIND))
    f(67) = -((eQED**6*gQCD**2*integralnorm*MH**2*SwB*(-(cw**2*sw**2*192._/**/REALKIND) + cw**4*96._/**/REALKIND  &
      + sw**4*96._/**/REALKIND))/(cw**2*MW**2*pi**2*sw**4*192._/**/REALKIND*96._/**/REALKIND))
    f(68) = -((eQED**6*gQCD**2*integralnorm*MH**2*SwB*(cw**4*48._/**/REALKIND + sw**4*48._/**/REALKIND  &
      - cw**2*sw**2*96._/**/REALKIND))/(cw**2*MW**2*pi**2*sw**4*48._/**/REALKIND*96._/**/REALKIND))
    f(69) = -((eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*pi**2*sw**3*48._/**/REALKIND))
    f(70) = -((eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*pi**2*sw**3*96._/**/REALKIND))
    f(71) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND))
    f(72) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**3*48._/**/REALKIND))
    f(73) = (eQED**6*gQCD**2*integralnorm*SwF)/(pi**2*sw**6*96._/**/REALKIND)
    f(74) = (eQED**6*gQCD**2*integralnorm*SwF)/(pi**2*sw**6*48._/**/REALKIND)
    f(75) = (eQED**6*gQCD**2*integralnorm*SwF)/(MW**2*pi**2*sw**6*192._/**/REALKIND)
    f(76) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(MW**2*pi**2*sw**6*192._/**/REALKIND)
    f(77) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**6*192._/**/REALKIND)
    f(78) = (cw*eQED**6*gQCD**2*integralnorm*ML*SwF)/(MW**2*pi**2*sw**5*96._/**/REALKIND)
    f(79) = (cw*eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**5*96._/**/REALKIND)
    f(80) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(MW**2*pi**2*sw**4*96._/**/REALKIND)
    f(81) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**4*144._/**/REALKIND)
    f(82) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**4*96._/**/REALKIND)
    f(83) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND)
    f(84) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(cw*MW**2*pi**2*sw**3*144._/**/REALKIND)
    f(85) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND)
    f(86) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*36._/**/REALKIND)
    f(87) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*24._/**/REALKIND)
    f(88) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*18._/**/REALKIND)
    f(89) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*12._/**/REALKIND)
    f(90) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*8._/**/REALKIND)
    f(91) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(92) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*72._/**/REALKIND)
    f(93) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)

  c = [ 2*f(12), 2*f(13), 2*f(14), 2*f(15), 2*f(16), 2*f(17), 2*f(18), 2*f(19), 2*f(20), 2*f(21), 2*f(22), 2*f(23), 2*f(24) &
    , 2*f(25), 2*f(26), 2*f(27), 2*f(28), 2*f(29), 2*f(30), 2*f(31), 2*f(32), 2*f(33), 2*f(34), 2*f(35), 2*f(36), 2*f(37), 2*f(38) &
    , 2*f(39), 2*f(40), 2*f(41), 2*f(42), 2*f(43), 2*f(44), 2*f(45), 2*f(46), 2*f(47), 2*f(48), 2*f(49), 2*f(50), 2*f(51), 2*f(52) &
    , 2*f(53), 2*f(54), 2*f(55), 2*f(56), 2*f(57), 2*f(58), 2*f(59), 2*f(60), 2*f(61), 2*f(62), 2*f(63), 2*f(64), 2*f(65), 2*f(66) &
    , 2*f(67), 2*f(68), 2*f(69), 2*f(70), 2*f(71), 2*f(72), 2*f(73), 6*f(73), 2*f(74), 6*f(74), 6*f(75), 2*f(76), 6*f(77), 2*f(78) &
    , 6*f(79), 2*f(80), 6*f(81), 6*f(82), 2*f(83), 6*f(84), 6*f(85), 6*f(86), 2*f(87), 6*f(87), 6*f(88), 2*f(89), 6*f(89), 2*f(90) &
    , 6*f(90), 2*f(91), 6*f(92), 6*f(93) ]
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(19)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,-3),wf(:,2))
  call vert_GG_H(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,3))
  call vert_VV_S(wf(:,1),wf(:,2),wf(:,4))
  call vert_QA_W(wf(:,0),wf(:,-3),wf(:,5))
  call vert_QA_W(wf(:,-2),wf(:,-1),wf(:,6))
  call vert_VV_S(wf(:,6),wf(:,5),wf(:,7))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,8))
  call counter_VV_S(wf(:,1),wf(:,8),wf(:,9))
  call counter_VV_S(wf(:,1),wf(:,2),wf(:,10))
  call counter_QA_Z(EWctVee,wf(:,-2),wf(:,-3),wf(:,11))
  call vert_VV_S(wf(:,1),wf(:,11),wf(:,12))
  call counter_VV_S(wf(:,6),wf(:,5),wf(:,13))
  call counter_QA_W(wf(:,-2),wf(:,-1),wf(:,14))
  call vert_VV_S(wf(:,14),wf(:,5),wf(:,15))
  call counter_QA_W(wf(:,0),wf(:,-3),wf(:,16))
  call vert_VV_S(wf(:,6),wf(:,16),wf(:,17))
  call counter_QA_Z(EWctVnn,wf(:,0),wf(:,-1),wf(:,18))
  call vert_VV_S(wf(:,18),wf(:,2),wf(:,19))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,2),Q(:,12),wf(:,20))
  call counter_V_S(EWctXZ,wf(:,1),Q(:,3),wf(:,21))
  call vert_SV_V(wf(:,3),wf(:,2),wf(:,22))
  call counter_V_V(EWctZZ,wf(:,1),Q(:,3),wf(:,23))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,1),Q(:,3),wf(:,24))
  call counter_V_S(EWctXA,wf(:,8),Q(:,12),wf(:,25))
  call counter_V_S(EWctXZ,wf(:,2),Q(:,12),wf(:,26))
  call vert_SV_V(wf(:,3),wf(:,1),wf(:,27))
  call counter_V_V(EWctAZ,wf(:,8),Q(:,12),wf(:,28))
  call counter_V_V(EWctZZ,wf(:,2),Q(:,12),wf(:,29))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,6),Q(:,6),wf(:,30))
  call counter_V_S(EWctPW,wf(:,5),Q(:,9),wf(:,31))
  call vert_SV_V(wf(:,3),wf(:,6),wf(:,32))
  call counter_V_V(EWctWW,wf(:,5),Q(:,9),wf(:,33))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,5),Q(:,9),wf(:,34))
  call counter_V_S(EWctPW,wf(:,6),Q(:,6),wf(:,35))
  call vert_SV_V(wf(:,3),wf(:,5),wf(:,36))
  call counter_V_V(EWctWW,wf(:,6),Q(:,6),wf(:,37))
  call vert_ZQ_A(gZl,wf(:,1),wf(:,-2),wf(:,38))
  call prop_Q_A(wf(:,38),Q(:,7),ZERO,0_intkind1,wf(:,39))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,1),wf(:,40))
  call prop_A_Q(wf(:,40),Q(:,11),ZERO,0_intkind1,wf(:,41))
  call vert_WQ_A(wf(:,6),wf(:,0),wf(:,42))
  call prop_Q_A(wf(:,42),Q(:,7),ZERO,0_intkind1,wf(:,43))
  call vert_AW_Q(wf(:,-3),wf(:,6),wf(:,44))
  call prop_A_Q(wf(:,44),Q(:,14),ZERO,0_intkind1,wf(:,45))
  call vert_AW_Q(wf(:,-1),wf(:,5),wf(:,46))
  call prop_A_Q(wf(:,46),Q(:,11),ZERO,0_intkind1,wf(:,47))
  call vert_WQ_A(wf(:,5),wf(:,-2),wf(:,48))
  call prop_Q_A(wf(:,48),Q(:,13),ZERO,0_intkind1,wf(:,49))
  call vert_ZQ_A(gZn,wf(:,2),wf(:,0),wf(:,50))
  call prop_Q_A(wf(:,50),Q(:,13),ZERO,0_intkind1,wf(:,51))
  call vert_AZ_Q(gZn,wf(:,-1),wf(:,2),wf(:,52))
  call prop_A_Q(wf(:,52),Q(:,14),ZERO,0_intkind1,wf(:,53))
  call vert_QA_V(wf(:,39),wf(:,-3),wf(:,54))
  call vert_QA_Z(gZl,wf(:,39),wf(:,-3),wf(:,55))
  call vert_QA_V(wf(:,-2),wf(:,41),wf(:,56))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,41),wf(:,57))
  call vert_UV_W(wf(:,5),Q(:,9),wf(:,6),Q(:,6),wf(:,58))
  call vert_QA_V(wf(:,43),wf(:,-3),wf(:,59))
  call vert_QA_Z(gZl,wf(:,43),wf(:,-3),wf(:,60))
  call vert_QA_Z(gZn,wf(:,0),wf(:,45),wf(:,61))
  call vert_QA_V(wf(:,-2),wf(:,47),wf(:,62))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,47),wf(:,63))
  call vert_QA_Z(gZn,wf(:,49),wf(:,-1),wf(:,64))
  call vert_QA_Z(gZn,wf(:,51),wf(:,-1),wf(:,65))
  call vert_QA_Z(gZn,wf(:,0),wf(:,53),wf(:,66))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MZ2)
  den(2) = 1 / (Q(5,12) - MZ2)
  den(3) = 1 / (Q(5,48) - MH2)
  den(6) = 1 / (Q(5,9) - MW2)
  den(7) = 1 / (Q(5,6) - MW2)
  den(10) = 1 / (Q(5,12))
  den(14) = 1 / (Q(5,60) - MZ2)
  den(18) = 1 / (Q(5,51) - MZ2)
  den(23) = 1 / (Q(5,54) - MW2)
  den(27) = 1 / (Q(5,57) - MW2)
  den(30) = 1 / (Q(5,7))
  den(32) = 1 / (Q(5,11))
  den(35) = 1 / (Q(5,14))
  den(38) = 1 / (Q(5,13))
  den(42) = 1 / (Q(5,15))
  den(44) = 1 / (Q(5,15) - MZ2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(8) = den(6)*den(7)
  den(9) = den(3)*den(8)
  den(11) = den(1)*den(10)
  den(12) = den(3)*den(11)
  den(13) = den(2)*den(3)
  den(15) = den(13)*den(14)
  den(16) = den(1)*den(15)
  den(17) = den(1)*den(3)
  den(19) = den(17)*den(18)
  den(20) = den(10)*den(19)
  den(21) = den(2)*den(19)
  den(22) = den(3)*den(7)
  den(24) = den(22)*den(23)
  den(25) = den(6)*den(24)
  den(26) = den(3)*den(6)
  den(28) = den(26)*den(27)
  den(29) = den(7)*den(28)
  den(31) = den(1)*den(30)
  den(33) = den(1)*den(32)
  den(34) = den(7)*den(30)
  den(36) = den(7)*den(35)
  den(37) = den(6)*den(32)
  den(39) = den(6)*den(38)
  den(40) = den(2)*den(38)
  den(41) = den(2)*den(35)
  den(43) = den(31)*den(42)
  den(45) = den(31)*den(44)
  den(46) = den(33)*den(42)
  den(47) = den(33)*den(44)
  den(48) = den(8)*den(42)
  den(49) = den(8)*den(44)
  den(50) = den(34)*den(42)
  den(51) = den(34)*den(44)
  den(52) = den(36)*den(44)
  den(53) = den(37)*den(42)
  den(54) = den(37)*den(44)
  den(55) = den(39)*den(44)
  den(56) = den(40)*den(44)
  den(57) = den(41)*den(44)
  den(58) = den(1)*den(3)*den(10)
  den(59) = den(1)*den(2)*den(3)
  den(60) = den(3)*den(31)
  den(61) = den(3)*den(33)
  den(62) = den(3)*den(6)*den(7)
  den(63) = den(3)*den(34)
  den(64) = den(3)*den(36)
  den(65) = den(3)*den(37)
  den(66) = den(3)*den(39)
  den(67) = den(3)*den(40)
  den(68) = den(3)*den(41)
  den(69) = den(3)*den(10)
  den(70) = den(1)*den(69)
  den(71) = den(1)*den(13)
  den(72) = den(10)*den(17)
  den(73) = den(2)*den(17)
  den(74) = den(6)*den(22)
  den(75) = den(7)*den(26)
  den(76) = den(3)*den(43)
  den(77) = den(3)*den(45)
  den(78) = den(3)*den(46)
  den(79) = den(3)*den(47)
  den(80) = den(3)*den(48)
  den(81) = den(3)*den(49)
  den(82) = den(3)*den(50)
  den(83) = den(3)*den(51)
  den(84) = den(3)*den(52)
  den(85) = den(3)*den(53)
  den(86) = den(3)*den(54)
  den(87) = den(3)*den(55)
  den(88) = den(3)*den(56)
  den(89) = den(3)*den(57)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(19)

  A(1) = cont_SS(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_SS(wf(:,3),wf(:,7)) * den(9)

  A(3) = cont_SS(wf(:,3),wf(:,9)) * den(12)
  A(4) = cont_SS(wf(:,3),wf(:,10)) * den(5)
  A(5) = cont_SS(wf(:,3),wf(:,12)) * den(5)
  A(6) = cont_SS(wf(:,3),wf(:,13)) * den(9)
  A(7) = cont_SS(wf(:,3),wf(:,15)) * den(9)
  A(8) = cont_SS(wf(:,3),wf(:,17)) * den(9)
  A(9) = cont_SS(wf(:,3),wf(:,19)) * den(5)
  A(10) = cont_SS(wf(:,20),wf(:,21)) * den(16)
  A(11) = cont_VV(wf(:,22),wf(:,23)) * den(16)
  A(12) = cont_SS(wf(:,24),wf(:,25)) * den(20)
  A(13) = cont_SS(wf(:,24),wf(:,26)) * den(21)
  A(14) = cont_VV(wf(:,27),wf(:,28)) * den(20)
  A(15) = cont_VV(wf(:,27),wf(:,29)) * den(21)
  A(16) = cont_SS(wf(:,30),wf(:,31)) * den(25)
  A(17) = cont_VV(wf(:,32),wf(:,33)) * den(25)
  A(18) = cont_SS(wf(:,34),wf(:,35)) * den(29)
  A(19) = cont_VV(wf(:,36),wf(:,37)) * den(29)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(19)
  complex(REALKIND), intent(out) :: M1(1), M2(1)

  M1(1) = -2*A(2)*f(1)+2*A(1)*f(7)

  M2(1) = 2*(A(17)+A(19))*f(2)-2*A(7)*f(3)-2*A(8)*f(4)+2*(A(16)-A(18))*f(5)-2*A(6)*f(6)+2*(A(5)+A(9)-A(11)-A(14)-A(15))*f(8)+2*( &
       -A(10)-A(12)-A(13))*f(9)+2*A(3)*f(10)+2*A(4)*f(11)

end subroutine colourvectors

end module ol_loop_heftpph_ew_nenexeexgg_1_/**/REALKIND
