
module ol_colourmatrix_heftpph_ew_mmxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(12,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 2]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 2]

  K2(1,:) = [ 2]

  KL(1,:) = [ 2]


  end subroutine colourmatrix_init
end module ol_colourmatrix_heftpph_ew_mmxgg_1_/**/REALKIND



module ol_forced_parameters_heftpph_ew_mmxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (YB /= 0) write(*,101) 'YB = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMM /= 0) write(*,101) 'wMM = 0'
  if (wMM /= 0) write(*,101) 'wMM = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_heftpph_ew_mmxgg_1_/**/REALKIND

module ol_loop_heftpph_ew_mmxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(29), c(27)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-4+1:6)
  ! denominators
  complex(REALKIND), save :: den(6)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,16), Mct(1,16), Mcol_loop(1,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2*MM)/(48._/**/REALKIND*MW**2*pi**2*sw**2)
    f( 2) = (CI*countertermnorm*eQED**4*gQCD**2*MM)/(24._/**/REALKIND*MW**2*pi**2*sw)
    f( 3) = (eQED**4*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f( 4) = (eQED**4*gQCD**2*integralnorm*MM*SwB)/(pi**2*sw**4*192._/**/REALKIND)
    f( 5) = (eQED**4*gQCD**2*integralnorm*MH**2*MM**2*SwB)/(MW**4*pi**2*sw**4*192._/**/REALKIND)
    f( 6) = (eQED**4*gQCD**2*integralnorm*MH**2*MM**2*SwB)/(MW**4*pi**2*sw**4*96._/**/REALKIND)
    f( 7) = (eQED**4*gQCD**2*integralnorm*lambdaHHH*MH**2*MM**2*SwB)/(MW**4*pi**2*sw**4*64._/**/REALKIND)
    f( 8) = (eQED**4*gQCD**2*integralnorm*MM**3*SwB)/(MW**4*pi**2*sw**4*192._/**/REALKIND)
    f( 9) = (eQED**4*gQCD**2*integralnorm*MM*SwB)/(MW**2*pi**2*sw**4*192._/**/REALKIND)
    f(10) = (eQED**4*gQCD**2*integralnorm*MM*SwB)/(MW**2*pi**2*sw**4*96._/**/REALKIND)
    f(11) = (cw*eQED**4*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*48._/**/REALKIND)
    f(12) = (cw*eQED**4*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*24._/**/REALKIND)
    f(13) = (eQED**4*gQCD**2*integralnorm*MM*SwB)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND)
    f(14) = (eQED**4*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*48._/**/REALKIND)
    f(15) = (eQED**4*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*24._/**/REALKIND)
    f(16) = (eQED**4*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**2*24._/**/REALKIND)
    f(17) = (eQED**4*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(18) = (eQED**4*gQCD**2*integralnorm*MM*SwB)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(19) = (eQED**4*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw*48._/**/REALKIND)
    f(20) = -((eQED**4*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND))
    f(21) = (eQED**4*gQCD**2*integralnorm*ME**2*MM*SwF)/(MW**4*pi**2*sw**4*192._/**/REALKIND)
    f(22) = (eQED**4*gQCD**2*integralnorm*ML**2*MM*SwF)/(MW**4*pi**2*sw**4*192._/**/REALKIND)
    f(23) = (eQED**4*gQCD**2*integralnorm*MM**3*SwF)/(MW**4*pi**2*sw**4*192._/**/REALKIND)
    f(24) = (eQED**4*gQCD**2*integralnorm*MM*MT**2*SwF)/(MW**4*pi**2*sw**4*192._/**/REALKIND)
    f(25) = (eQED**4*gQCD**2*integralnorm*ME*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(26) = (eQED**4*gQCD**2*integralnorm*ML*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(27) = (eQED**4*gQCD**2*integralnorm*MM*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(28) = (eQED**4*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*72._/**/REALKIND)
    f(29) = (eQED**4*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)

  c = [ 2*f(3), 2*f(4), 2*f(5), 2*f(6), 2*f(7), 2*f(8), 2*f(9), 2*f(10), 2*f(11), 2*f(12), 2*f(13), 2*f(14), 2*f(15), 2*f(16) &
    , 2*f(17), 2*f(18), 2*f(19), 2*f(20), 2*f(21), 2*f(22), 2*f(23), 6*f(24), 2*f(25), 2*f(26), 2*f(27), 6*f(28), 6*f(29) ]
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,4)
  integer,           intent(in)  :: H(4)
  integer,           intent(in), optional  :: POLSEL(4)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(2)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMM, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rMM, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))

  else
    call pol_wf_Q(P(:,1), rMM, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rMM, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), 0)

  end if

  ! internal WFs
  call vert_AQ_S(gH,wf(:,-1),wf(:,0),wf(:,1))
  call vert_GG_H(wf(:,-2),Q(:,4),wf(:,-3),Q(:,8),wf(:,2))
  call counter_AQ_S(EWctHmm,wf(:,-1),wf(:,0),wf(:,3))
  call vert_AQ_S(gX,wf(:,-1),wf(:,0),wf(:,4))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,5))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-1),wf(:,6))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MH2)
  den(2) = 1 / (Q(5,12) - MH2)
  den(3) = 1 / (Q(5,3) - MZ2)
  den(4) = 1 / (Q(5,3))

  ! denominators
  den(5) = den(2)*den(3)
  den(6) = den(2)*den(4)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(2)

  A(1) = cont_SS(wf(:,1),wf(:,2)) * den(1)

  A(2) = cont_SS(wf(:,2),wf(:,3)) * den(2)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(2)
  complex(REALKIND), intent(out) :: M1(1), M2(1)

  M1(1) = 2*A(1)*f(1)

  M2(1) = -2*A(2)*f(2)

end subroutine colourvectors

end module ol_loop_heftpph_ew_mmxgg_1_/**/REALKIND
