
module ol_colourmatrix_heftpph_ew_eexmmxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,2), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 2]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 2]

  K2(1,:) = [ 0, 2]

  KL(1,:) = [ 2]


  end subroutine colourmatrix_init
end module ol_colourmatrix_heftpph_ew_eexmmxgg_1_/**/REALKIND



module ol_forced_parameters_heftpph_ew_eexmmxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (YB /= 0) write(*,101) 'YB = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (YM /= 0) write(*,101) 'YM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_heftpph_ew_eexmmxgg_1_/**/REALKIND

module ol_loop_heftpph_ew_eexmmxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(63), c(59)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:60)
  ! denominators
  complex(REALKIND), save :: den(93)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,64), Mct(2,64), Mcol_loop(1,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (47*CI*DOI*eQED**6*gQCD**2)/(6912._/**/REALKIND*MW**2*pi**4*sw**2)
    f( 2) = (CI*eQED**4*gQCD**2)/(24._/**/REALKIND*cw**2*pi**2*sw**2)
    f( 3) = (CI*countertermnorm*eQED**6*gQCD**2)/(24._/**/REALKIND*cw**2*pi**2*sw**2)
    f( 4) = (countertermnorm*eQED**6*gQCD**2)/(cw*MW*pi**2*sw**2*48._/**/REALKIND)
    f( 5) = (CI*countertermnorm*eQED**6*EWctHAA*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f( 6) = (CI*countertermnorm*eQED**6*EWctHZA*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f( 7) = (CI*countertermnorm*eQED**6*EWctHZZ*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f( 8) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*48._/**/REALKIND)
    f( 9) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw**2*pi**2*48._/**/REALKIND)
    f(10) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**4*pi**2*24._/**/REALKIND)
    f(11) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**2*pi**2*24._/**/REALKIND)
    f(12) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**6*96._/**/REALKIND)
    f(13) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**5*48._/**/REALKIND)
    f(14) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**5*48._/**/REALKIND)
    f(15) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*96._/**/REALKIND)
    f(16) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f(17) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*24._/**/REALKIND)
    f(18) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**4*pi**2*sw**4*96._/**/REALKIND)
    f(19) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**4*pi**2*sw**4*48._/**/REALKIND)
    f(20) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**4*48._/**/REALKIND)
    f(21) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f(22) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*24._/**/REALKIND)
    f(23) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(cw**4*pi**2*sw**4*16._/**/REALKIND)
    f(24) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw**2*MW**2*pi**2*sw**4*192._/**/REALKIND)
    f(25) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW**2*pi**2*sw**4*64._/**/REALKIND)
    f(26) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**6*pi**2*sw**4*24._/**/REALKIND)
    f(27) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**3*96._/**/REALKIND)
    f(28) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**3*24._/**/REALKIND)
    f(29) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*48._/**/REALKIND)
    f(30) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*24._/**/REALKIND)
    f(31) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*48._/**/REALKIND)
    f(32) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*24._/**/REALKIND)
    f(33) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**2*96._/**/REALKIND)
    f(34) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**2*24._/**/REALKIND)
    f(35) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(pi**2*sw**2*48._/**/REALKIND)
    f(36) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(37) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**2*24._/**/REALKIND)
    f(38) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(pi**2*sw**2*24._/**/REALKIND)
    f(39) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw*48._/**/REALKIND)
    f(40) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw*pi**2*sw*48._/**/REALKIND)
    f(41) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**3*pi**2*sw*24._/**/REALKIND)
    f(42) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw*pi**2*sw*24._/**/REALKIND)
    f(43) = (eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*pi**2*sw**2*96._/**/REALKIND)
    f(44) = -((eQED**6*gQCD**2*integralnorm*SwB*(cw**4*48._/**/REALKIND + sw**4*48._/**/REALKIND  &
      - cw**2*sw**2*96._/**/REALKIND))/(cw**4*pi**2*sw**4*48._/**/REALKIND*96._/**/REALKIND))
    f(45) = -((eQED**6*gQCD**2*integralnorm*MH**2*SwB*(-(cw**2*sw**2*192._/**/REALKIND) + cw**4*96._/**/REALKIND  &
      + sw**4*96._/**/REALKIND))/(cw**2*MW**2*pi**2*sw**4*192._/**/REALKIND*96._/**/REALKIND))
    f(46) = -((eQED**6*gQCD**2*integralnorm*MH**2*SwB*(cw**4*48._/**/REALKIND + sw**4*48._/**/REALKIND  &
      - cw**2*sw**2*96._/**/REALKIND))/(cw**2*MW**2*pi**2*sw**4*48._/**/REALKIND*96._/**/REALKIND))
    f(47) = -((eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*pi**2*sw**3*48._/**/REALKIND))
    f(48) = -((eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*pi**2*sw**3*96._/**/REALKIND))
    f(49) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND))
    f(50) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**3*48._/**/REALKIND))
    f(51) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND)
    f(52) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(cw*MW**2*pi**2*sw**3*144._/**/REALKIND)
    f(53) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND)
    f(54) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*36._/**/REALKIND)
    f(55) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*24._/**/REALKIND)
    f(56) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*18._/**/REALKIND)
    f(57) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*12._/**/REALKIND)
    f(58) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*8._/**/REALKIND)
    f(59) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(60) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*108._/**/REALKIND)
    f(61) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*72._/**/REALKIND)
    f(62) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(63) = (47*eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*288._/**/REALKIND)

  c = [ 2*f(8), 2*f(9), 2*f(10), 2*f(11), 2*f(12), 2*f(13), 2*f(14), 2*f(15), 2*f(16), 2*f(17), 2*f(18), 2*f(19), 2*f(20), 2*f(21) &
    , 2*f(22), 2*f(23), 2*f(24), 2*f(25), 2*f(26), 2*f(27), 2*f(28), 2*f(29), 2*f(30), 2*f(31), 2*f(32), 2*f(33), 2*f(34), 2*f(35) &
    , 2*f(36), 2*f(37), 2*f(38), 2*f(39), 2*f(40), 2*f(41), 2*f(42), 2*f(43), 2*f(44), 2*f(45), 2*f(46), 2*f(47), 2*f(48), 2*f(49) &
    , 2*f(50), 2*f(51), 6*f(52), 6*f(53), 6*f(54), 2*f(55), 6*f(55), 6*f(56), 2*f(57), 6*f(57), 2*f(58), 6*f(58), 2*f(59), 6*f(60) &
    , 6*f(61), 6*f(62), f(63) ]
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(1), M2(2)
  complex(REALKIND) :: A(16)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_Z(gZl,wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,-3),wf(:,2))
  call vert_GG_H(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,3))
  call vert_VV_S(wf(:,1),wf(:,2),wf(:,4))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,5))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,6))
  call counter_VV_S(wf(:,5),wf(:,6),wf(:,7))
  call counter_VV_S(wf(:,5),wf(:,2),wf(:,8))
  call counter_VV_S(wf(:,1),wf(:,6),wf(:,9))
  call counter_VV_S(wf(:,1),wf(:,2),wf(:,10))
  call counter_GG_H_vert(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,11))
  call vert_GG_H(wf(:,5),Q(:,3),wf(:,6),Q(:,12),wf(:,12))
  call counter_QA_Z(EWctVmm,wf(:,-2),wf(:,-3),wf(:,13))
  call vert_VV_S(wf(:,1),wf(:,13),wf(:,14))
  call counter_QA_Z(EWctVee,wf(:,0),wf(:,-1),wf(:,15))
  call vert_VV_S(wf(:,15),wf(:,2),wf(:,16))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,2),Q(:,12),wf(:,17))
  call counter_V_S(EWctXA,wf(:,5),Q(:,3),wf(:,18))
  call counter_V_S(EWctXZ,wf(:,1),Q(:,3),wf(:,19))
  call vert_SV_V(wf(:,3),wf(:,2),wf(:,20))
  call counter_V_V(EWctAZ,wf(:,5),Q(:,3),wf(:,21))
  call counter_V_V(EWctZZ,wf(:,1),Q(:,3),wf(:,22))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,1),Q(:,3),wf(:,23))
  call counter_V_S(EWctXA,wf(:,6),Q(:,12),wf(:,24))
  call counter_V_S(EWctXZ,wf(:,2),Q(:,12),wf(:,25))
  call vert_SV_V(wf(:,3),wf(:,1),wf(:,26))
  call counter_V_V(EWctAZ,wf(:,6),Q(:,12),wf(:,27))
  call counter_V_V(EWctZZ,wf(:,2),Q(:,12),wf(:,28))
  call vert_VQ_A(wf(:,5),wf(:,-2),wf(:,29))
  call prop_Q_A(wf(:,29),Q(:,7),ZERO,0_intkind1,wf(:,30))
  call vert_ZQ_A(gZl,wf(:,1),wf(:,-2),wf(:,31))
  call prop_Q_A(wf(:,31),Q(:,7),ZERO,0_intkind1,wf(:,32))
  call vert_AV_Q(wf(:,-3),wf(:,5),wf(:,33))
  call prop_A_Q(wf(:,33),Q(:,11),ZERO,0_intkind1,wf(:,34))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,1),wf(:,35))
  call prop_A_Q(wf(:,35),Q(:,11),ZERO,0_intkind1,wf(:,36))
  call vert_VQ_A(wf(:,6),wf(:,0),wf(:,37))
  call prop_Q_A(wf(:,37),Q(:,13),ZERO,0_intkind1,wf(:,38))
  call vert_ZQ_A(gZl,wf(:,2),wf(:,0),wf(:,39))
  call prop_Q_A(wf(:,39),Q(:,13),ZERO,0_intkind1,wf(:,40))
  call vert_AV_Q(wf(:,-1),wf(:,6),wf(:,41))
  call prop_A_Q(wf(:,41),Q(:,14),ZERO,0_intkind1,wf(:,42))
  call vert_AZ_Q(gZl,wf(:,-1),wf(:,2),wf(:,43))
  call prop_A_Q(wf(:,43),Q(:,14),ZERO,0_intkind1,wf(:,44))
  call vert_QA_V(wf(:,30),wf(:,-3),wf(:,45))
  call vert_QA_Z(gZl,wf(:,30),wf(:,-3),wf(:,46))
  call vert_QA_V(wf(:,32),wf(:,-3),wf(:,47))
  call vert_QA_Z(gZl,wf(:,32),wf(:,-3),wf(:,48))
  call vert_QA_V(wf(:,-2),wf(:,34),wf(:,49))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,34),wf(:,50))
  call vert_QA_V(wf(:,-2),wf(:,36),wf(:,51))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,36),wf(:,52))
  call vert_QA_V(wf(:,38),wf(:,-1),wf(:,53))
  call vert_QA_Z(gZl,wf(:,38),wf(:,-1),wf(:,54))
  call vert_QA_V(wf(:,40),wf(:,-1),wf(:,55))
  call vert_QA_Z(gZl,wf(:,40),wf(:,-1),wf(:,56))
  call vert_QA_V(wf(:,0),wf(:,42),wf(:,57))
  call vert_QA_V(wf(:,0),wf(:,44),wf(:,58))
  call vert_QA_Z(gZl,wf(:,0),wf(:,42),wf(:,59))
  call vert_QA_Z(gZl,wf(:,0),wf(:,44),wf(:,60))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MZ2)
  den(2) = 1 / (Q(5,12) - MZ2)
  den(3) = 1 / (Q(5,48) - MH2)
  den(6) = 1 / (Q(5,3))
  den(7) = 1 / (Q(5,12))
  den(15) = 1 / (Q(5,60) - MZ2)
  den(20) = 1 / (Q(5,51) - MZ2)
  den(24) = 1 / (Q(5,15) - MH2)
  den(26) = 1 / (Q(5,7))
  den(29) = 1 / (Q(5,11))
  den(32) = 1 / (Q(5,13))
  den(35) = 1 / (Q(5,14))
  den(38) = 1 / (Q(5,15))
  den(40) = 1 / (Q(5,15) - MZ2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(8) = den(6)*den(7)
  den(9) = den(3)*den(8)
  den(10) = den(2)*den(6)
  den(11) = den(3)*den(10)
  den(12) = den(1)*den(7)
  den(13) = den(3)*den(12)
  den(14) = den(2)*den(3)
  den(16) = den(14)*den(15)
  den(17) = den(6)*den(16)
  den(18) = den(1)*den(16)
  den(19) = den(1)*den(3)
  den(21) = den(19)*den(20)
  den(22) = den(7)*den(21)
  den(23) = den(2)*den(21)
  den(25) = den(8)*den(24)
  den(27) = den(6)*den(26)
  den(28) = den(1)*den(26)
  den(30) = den(6)*den(29)
  den(31) = den(1)*den(29)
  den(33) = den(7)*den(32)
  den(34) = den(2)*den(32)
  den(36) = den(7)*den(35)
  den(37) = den(2)*den(35)
  den(39) = den(27)*den(38)
  den(41) = den(27)*den(40)
  den(42) = den(28)*den(38)
  den(43) = den(28)*den(40)
  den(44) = den(30)*den(38)
  den(45) = den(30)*den(40)
  den(46) = den(31)*den(38)
  den(47) = den(31)*den(40)
  den(48) = den(33)*den(38)
  den(49) = den(33)*den(40)
  den(50) = den(34)*den(38)
  den(51) = den(34)*den(40)
  den(52) = den(36)*den(38)
  den(53) = den(37)*den(38)
  den(54) = den(36)*den(40)
  den(55) = den(37)*den(40)
  den(56) = den(3)*den(6)*den(7)
  den(57) = den(2)*den(3)*den(6)
  den(58) = den(1)*den(3)*den(7)
  den(59) = den(1)*den(2)*den(3)
  den(60) = den(3)*den(27)
  den(61) = den(3)*den(28)
  den(62) = den(3)*den(30)
  den(63) = den(3)*den(31)
  den(64) = den(3)*den(6)
  den(65) = den(3)*den(33)
  den(66) = den(3)*den(34)
  den(67) = den(3)*den(36)
  den(68) = den(3)*den(37)
  den(69) = den(3)*den(7)
  den(70) = den(6)*den(69)
  den(71) = den(6)*den(14)
  den(72) = den(1)*den(69)
  den(73) = den(1)*den(14)
  den(74) = den(7)*den(64)
  den(75) = den(2)*den(64)
  den(76) = den(7)*den(19)
  den(77) = den(2)*den(19)
  den(78) = den(3)*den(39)
  den(79) = den(3)*den(41)
  den(80) = den(3)*den(42)
  den(81) = den(3)*den(43)
  den(82) = den(3)*den(44)
  den(83) = den(3)*den(45)
  den(84) = den(3)*den(46)
  den(85) = den(3)*den(47)
  den(86) = den(3)*den(48)
  den(87) = den(3)*den(49)
  den(88) = den(3)*den(50)
  den(89) = den(3)*den(51)
  den(90) = den(3)*den(52)
  den(91) = den(3)*den(53)
  den(92) = den(3)*den(54)
  den(93) = den(3)*den(55)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(16)

  A(1) = cont_SS(wf(:,3),wf(:,4)) * den(5)

  A(2) = cont_SS(wf(:,3),wf(:,7)) * den(9)
  A(3) = cont_SS(wf(:,3),wf(:,8)) * den(11)
  A(4) = cont_SS(wf(:,3),wf(:,9)) * den(13)
  A(5) = cont_SS(wf(:,3),wf(:,10)) * den(5)
  A(6) = cont_SS(wf(:,11),wf(:,12)) * den(9)
  A(7) = cont_SS(wf(:,3),wf(:,14)) * den(5)
  A(8) = cont_SS(wf(:,3),wf(:,16)) * den(5)
  A(9) = cont_SS(wf(:,17),wf(:,18)) * den(17)
  A(10) = cont_SS(wf(:,17),wf(:,19)) * den(18)
  A(11) = cont_VV(wf(:,20),wf(:,21)) * den(17)
  A(12) = cont_VV(wf(:,20),wf(:,22)) * den(18)
  A(13) = cont_SS(wf(:,23),wf(:,24)) * den(22)
  A(14) = cont_SS(wf(:,23),wf(:,25)) * den(23)
  A(15) = cont_VV(wf(:,26),wf(:,27)) * den(22)
  A(16) = cont_VV(wf(:,26),wf(:,28)) * den(23)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(16)
  complex(REALKIND), intent(out) :: M1(1), M2(2)

  M1(1) = 2*A(1)*f(2)

  M2(1) = 2*A(6)*f(1)
  M2(2) = 2*(A(7)+A(8)-A(11)-A(12)-A(15)-A(16))*f(3)+2*(-A(9)-A(10)-A(13)-A(14))*f(4)+2*A(2)*f(5)+2*(A(3)+A(4))*f(6)+2*A(5)*f(7)

end subroutine colourvectors

end module ol_loop_heftpph_ew_eexmmxgg_1_/**/REALKIND
