
module ol_colourmatrix_heftpph_ew_eeexexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,2), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 2]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 2]

  K2(1,:) = [ 0, 2]

  KL(1,:) = [ 2]


  end subroutine colourmatrix_init
end module ol_colourmatrix_heftpph_ew_eeexexgg_1_/**/REALKIND



module ol_forced_parameters_heftpph_ew_eeexexgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (YB /= 0) write(*,101) 'YB = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (YM /= 0) write(*,101) 'YM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_heftpph_ew_eeexexgg_1_/**/REALKIND

module ol_loop_heftpph_ew_eeexexgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(63), c(59)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:118)
  ! denominators
  complex(REALKIND), save :: den(178)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,64), Mct(2,64), Mcol_loop(1,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (47*CI*DOI*eQED**6*gQCD**2)/(6912._/**/REALKIND*MW**2*pi**4*sw**2)
    f( 2) = (CI*eQED**4*gQCD**2)/(24._/**/REALKIND*cw**2*pi**2*sw**2)
    f( 3) = (CI*countertermnorm*eQED**6*gQCD**2)/(24._/**/REALKIND*cw**2*pi**2*sw**2)
    f( 4) = (countertermnorm*eQED**6*gQCD**2)/(cw*MW*pi**2*sw**2*48._/**/REALKIND)
    f( 5) = (CI*countertermnorm*eQED**6*EWctHAA*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f( 6) = (CI*countertermnorm*eQED**6*EWctHZA*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f( 7) = (CI*countertermnorm*eQED**6*EWctHZZ*gQCD**2)/(24._/**/REALKIND*MW*pi**2*sw)
    f( 8) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*48._/**/REALKIND)
    f( 9) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw**2*pi**2*48._/**/REALKIND)
    f(10) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**4*pi**2*24._/**/REALKIND)
    f(11) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**2*pi**2*24._/**/REALKIND)
    f(12) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**6*96._/**/REALKIND)
    f(13) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**5*48._/**/REALKIND)
    f(14) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**5*48._/**/REALKIND)
    f(15) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*96._/**/REALKIND)
    f(16) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f(17) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*24._/**/REALKIND)
    f(18) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**4*pi**2*sw**4*96._/**/REALKIND)
    f(19) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**4*pi**2*sw**4*48._/**/REALKIND)
    f(20) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**4*48._/**/REALKIND)
    f(21) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*48._/**/REALKIND)
    f(22) = (cw**2*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**4*24._/**/REALKIND)
    f(23) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(cw**4*pi**2*sw**4*16._/**/REALKIND)
    f(24) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw**2*MW**2*pi**2*sw**4*192._/**/REALKIND)
    f(25) = (eQED**6*gQCD**2*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW**2*pi**2*sw**4*64._/**/REALKIND)
    f(26) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**6*pi**2*sw**4*24._/**/REALKIND)
    f(27) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**3*96._/**/REALKIND)
    f(28) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw**3*24._/**/REALKIND)
    f(29) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*48._/**/REALKIND)
    f(30) = (cw*eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**3*24._/**/REALKIND)
    f(31) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*48._/**/REALKIND)
    f(32) = (eQED**6*gQCD**2*integralnorm*SwB)/(pi**2*sw**2*24._/**/REALKIND)
    f(33) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**2*96._/**/REALKIND)
    f(34) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw**2*pi**2*sw**2*24._/**/REALKIND)
    f(35) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(pi**2*sw**2*48._/**/REALKIND)
    f(36) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(37) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(MW**2*pi**2*sw**2*24._/**/REALKIND)
    f(38) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(pi**2*sw**2*24._/**/REALKIND)
    f(39) = (eQED**6*gQCD**2*integralnorm*SwB)/(cw*pi**2*sw*48._/**/REALKIND)
    f(40) = (eQED**6*gQCD**2*integralnorm*MH**2*SwB)/(cw*pi**2*sw*48._/**/REALKIND)
    f(41) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw**3*pi**2*sw*24._/**/REALKIND)
    f(42) = (eQED**6*gQCD**2*integralnorm*MW**2*SwB)/(cw*pi**2*sw*24._/**/REALKIND)
    f(43) = (eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*pi**2*sw**2*96._/**/REALKIND)
    f(44) = -((eQED**6*gQCD**2*integralnorm*SwB*(cw**4*48._/**/REALKIND + sw**4*48._/**/REALKIND  &
      - cw**2*sw**2*96._/**/REALKIND))/(cw**4*pi**2*sw**4*48._/**/REALKIND*96._/**/REALKIND))
    f(45) = -((eQED**6*gQCD**2*integralnorm*MH**2*SwB*(-(cw**2*sw**2*192._/**/REALKIND) + cw**4*96._/**/REALKIND  &
      + sw**4*96._/**/REALKIND))/(cw**2*MW**2*pi**2*sw**4*192._/**/REALKIND*96._/**/REALKIND))
    f(46) = -((eQED**6*gQCD**2*integralnorm*MH**2*SwB*(cw**4*48._/**/REALKIND + sw**4*48._/**/REALKIND  &
      - cw**2*sw**2*96._/**/REALKIND))/(cw**2*MW**2*pi**2*sw**4*48._/**/REALKIND*96._/**/REALKIND))
    f(47) = -((eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*pi**2*sw**3*48._/**/REALKIND))
    f(48) = -((eQED**6*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*pi**2*sw**3*96._/**/REALKIND))
    f(49) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND))
    f(50) = -((eQED**6*gQCD**2*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*pi**2*sw**3*48._/**/REALKIND))
    f(51) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND)
    f(52) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(cw*MW**2*pi**2*sw**3*144._/**/REALKIND)
    f(53) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(cw*MW**2*pi**2*sw**3*96._/**/REALKIND)
    f(54) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*36._/**/REALKIND)
    f(55) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*24._/**/REALKIND)
    f(56) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*18._/**/REALKIND)
    f(57) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*12._/**/REALKIND)
    f(58) = (eQED**6*gQCD**2*integralnorm*SwF)/(cw**2*pi**2*sw**2*8._/**/REALKIND)
    f(59) = (eQED**6*gQCD**2*integralnorm*ML*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(60) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*108._/**/REALKIND)
    f(61) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*72._/**/REALKIND)
    f(62) = (eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*48._/**/REALKIND)
    f(63) = (47*eQED**6*gQCD**2*integralnorm*MT*SwF)/(MW**2*pi**2*sw**2*288._/**/REALKIND)

  c = [ 2*f(8), 2*f(9), 2*f(10), 2*f(11), 2*f(12), 2*f(13), 2*f(14), 2*f(15), 2*f(16), 2*f(17), 2*f(18), 2*f(19), 2*f(20), 2*f(21) &
    , 2*f(22), 2*f(23), 2*f(24), 2*f(25), 2*f(26), 2*f(27), 2*f(28), 2*f(29), 2*f(30), 2*f(31), 2*f(32), 2*f(33), 2*f(34), 2*f(35) &
    , 2*f(36), 2*f(37), 2*f(38), 2*f(39), 2*f(40), 2*f(41), 2*f(42), 2*f(43), 2*f(44), 2*f(45), 2*f(46), 2*f(47), 2*f(48), 2*f(49) &
    , 2*f(50), 2*f(51), 6*f(52), 6*f(53), 6*f(54), 2*f(55), 6*f(55), 6*f(56), 2*f(57), 6*f(57), 2*f(58), 6*f(58), 2*f(59), 6*f(60) &
    , 6*f(61), 6*f(62), f(63) ]
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(1), M2(2)
  complex(REALKIND) :: A(32)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_Z(gZl,wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,-3),wf(:,2))
  call vert_GG_H(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,3))
  call vert_VV_S(wf(:,1),wf(:,2),wf(:,4))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-3),wf(:,5))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,-2),wf(:,6))
  call vert_VV_S(wf(:,6),wf(:,5),wf(:,7))
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,8))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,9))
  call counter_VV_S(wf(:,8),wf(:,9),wf(:,10))
  call counter_VV_S(wf(:,8),wf(:,2),wf(:,11))
  call counter_VV_S(wf(:,1),wf(:,9),wf(:,12))
  call counter_VV_S(wf(:,1),wf(:,2),wf(:,13))
  call counter_GG_H_vert(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,14))
  call vert_GG_H(wf(:,8),Q(:,5),wf(:,9),Q(:,10),wf(:,15))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,16))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,17))
  call counter_VV_S(wf(:,17),wf(:,16),wf(:,18))
  call counter_VV_S(wf(:,6),wf(:,16),wf(:,19))
  call counter_VV_S(wf(:,17),wf(:,5),wf(:,20))
  call counter_VV_S(wf(:,6),wf(:,5),wf(:,21))
  call vert_GG_H(wf(:,17),Q(:,6),wf(:,16),Q(:,9),wf(:,22))
  call counter_QA_Z(EWctVee,wf(:,-1),wf(:,-3),wf(:,23))
  call vert_VV_S(wf(:,1),wf(:,23),wf(:,24))
  call counter_QA_Z(EWctVee,wf(:,-1),wf(:,-2),wf(:,25))
  call vert_VV_S(wf(:,25),wf(:,5),wf(:,26))
  call counter_QA_Z(EWctVee,wf(:,0),wf(:,-3),wf(:,27))
  call vert_VV_S(wf(:,6),wf(:,27),wf(:,28))
  call counter_QA_Z(EWctVee,wf(:,0),wf(:,-2),wf(:,29))
  call vert_VV_S(wf(:,29),wf(:,2),wf(:,30))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,2),Q(:,10),wf(:,31))
  call counter_V_S(EWctXA,wf(:,8),Q(:,5),wf(:,32))
  call counter_V_S(EWctXZ,wf(:,1),Q(:,5),wf(:,33))
  call vert_SV_V(wf(:,3),wf(:,2),wf(:,34))
  call counter_V_V(EWctAZ,wf(:,8),Q(:,5),wf(:,35))
  call counter_V_V(EWctZZ,wf(:,1),Q(:,5),wf(:,36))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,1),Q(:,5),wf(:,37))
  call counter_V_S(EWctXA,wf(:,9),Q(:,10),wf(:,38))
  call counter_V_S(EWctXZ,wf(:,2),Q(:,10),wf(:,39))
  call vert_SV_V(wf(:,3),wf(:,1),wf(:,40))
  call counter_V_V(EWctAZ,wf(:,9),Q(:,10),wf(:,41))
  call counter_V_V(EWctZZ,wf(:,2),Q(:,10),wf(:,42))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,6),Q(:,6),wf(:,43))
  call counter_V_S(EWctXA,wf(:,16),Q(:,9),wf(:,44))
  call counter_V_S(EWctXZ,wf(:,5),Q(:,9),wf(:,45))
  call vert_SV_V(wf(:,3),wf(:,6),wf(:,46))
  call counter_V_V(EWctAZ,wf(:,16),Q(:,9),wf(:,47))
  call counter_V_V(EWctZZ,wf(:,5),Q(:,9),wf(:,48))
  call vert_TV_S(wf(:,3),Q(:,48),wf(:,5),Q(:,9),wf(:,49))
  call counter_V_S(EWctXA,wf(:,17),Q(:,6),wf(:,50))
  call counter_V_S(EWctXZ,wf(:,6),Q(:,6),wf(:,51))
  call vert_SV_V(wf(:,3),wf(:,5),wf(:,52))
  call counter_V_V(EWctAZ,wf(:,17),Q(:,6),wf(:,53))
  call counter_V_V(EWctZZ,wf(:,6),Q(:,6),wf(:,54))
  call vert_VQ_A(wf(:,8),wf(:,-1),wf(:,55))
  call prop_Q_A(wf(:,55),Q(:,7),ZERO,0_intkind1,wf(:,56))
  call vert_ZQ_A(gZl,wf(:,1),wf(:,-1),wf(:,57))
  call prop_Q_A(wf(:,57),Q(:,7),ZERO,0_intkind1,wf(:,58))
  call vert_AV_Q(wf(:,-3),wf(:,8),wf(:,59))
  call prop_A_Q(wf(:,59),Q(:,13),ZERO,0_intkind1,wf(:,60))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,1),wf(:,61))
  call prop_A_Q(wf(:,61),Q(:,13),ZERO,0_intkind1,wf(:,62))
  call vert_VQ_A(wf(:,17),wf(:,0),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,7),ZERO,0_intkind1,wf(:,64))
  call vert_ZQ_A(gZl,wf(:,6),wf(:,0),wf(:,65))
  call prop_Q_A(wf(:,65),Q(:,7),ZERO,0_intkind1,wf(:,66))
  call vert_AV_Q(wf(:,-3),wf(:,17),wf(:,67))
  call prop_A_Q(wf(:,67),Q(:,14),ZERO,0_intkind1,wf(:,68))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,6),wf(:,69))
  call prop_A_Q(wf(:,69),Q(:,14),ZERO,0_intkind1,wf(:,70))
  call vert_VQ_A(wf(:,16),wf(:,-1),wf(:,71))
  call prop_Q_A(wf(:,71),Q(:,11),ZERO,0_intkind1,wf(:,72))
  call vert_ZQ_A(gZl,wf(:,5),wf(:,-1),wf(:,73))
  call prop_Q_A(wf(:,73),Q(:,11),ZERO,0_intkind1,wf(:,74))
  call vert_AV_Q(wf(:,-2),wf(:,16),wf(:,75))
  call prop_A_Q(wf(:,75),Q(:,13),ZERO,0_intkind1,wf(:,76))
  call vert_AZ_Q(gZl,wf(:,-2),wf(:,5),wf(:,77))
  call prop_A_Q(wf(:,77),Q(:,13),ZERO,0_intkind1,wf(:,78))
  call vert_VQ_A(wf(:,9),wf(:,0),wf(:,79))
  call prop_Q_A(wf(:,79),Q(:,11),ZERO,0_intkind1,wf(:,80))
  call vert_ZQ_A(gZl,wf(:,2),wf(:,0),wf(:,81))
  call prop_Q_A(wf(:,81),Q(:,11),ZERO,0_intkind1,wf(:,82))
  call vert_AV_Q(wf(:,-2),wf(:,9),wf(:,83))
  call prop_A_Q(wf(:,83),Q(:,14),ZERO,0_intkind1,wf(:,84))
  call vert_AZ_Q(gZl,wf(:,-2),wf(:,2),wf(:,85))
  call prop_A_Q(wf(:,85),Q(:,14),ZERO,0_intkind1,wf(:,86))
  call vert_QA_V(wf(:,56),wf(:,-3),wf(:,87))
  call vert_QA_Z(gZl,wf(:,56),wf(:,-3),wf(:,88))
  call vert_QA_V(wf(:,58),wf(:,-3),wf(:,89))
  call vert_QA_Z(gZl,wf(:,58),wf(:,-3),wf(:,90))
  call vert_QA_V(wf(:,-1),wf(:,60),wf(:,91))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,60),wf(:,92))
  call vert_QA_V(wf(:,-1),wf(:,62),wf(:,93))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,62),wf(:,94))
  call vert_QA_V(wf(:,64),wf(:,-3),wf(:,95))
  call vert_QA_Z(gZl,wf(:,64),wf(:,-3),wf(:,96))
  call vert_QA_V(wf(:,66),wf(:,-3),wf(:,97))
  call vert_QA_Z(gZl,wf(:,66),wf(:,-3),wf(:,98))
  call vert_QA_V(wf(:,0),wf(:,68),wf(:,99))
  call vert_QA_V(wf(:,0),wf(:,70),wf(:,100))
  call vert_QA_Z(gZl,wf(:,0),wf(:,68),wf(:,101))
  call vert_QA_Z(gZl,wf(:,0),wf(:,70),wf(:,102))
  call vert_QA_V(wf(:,72),wf(:,-2),wf(:,103))
  call vert_QA_Z(gZl,wf(:,72),wf(:,-2),wf(:,104))
  call vert_QA_V(wf(:,74),wf(:,-2),wf(:,105))
  call vert_QA_Z(gZl,wf(:,74),wf(:,-2),wf(:,106))
  call vert_QA_V(wf(:,-1),wf(:,76),wf(:,107))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,76),wf(:,108))
  call vert_QA_V(wf(:,-1),wf(:,78),wf(:,109))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,78),wf(:,110))
  call vert_QA_V(wf(:,80),wf(:,-2),wf(:,111))
  call vert_QA_Z(gZl,wf(:,80),wf(:,-2),wf(:,112))
  call vert_QA_V(wf(:,82),wf(:,-2),wf(:,113))
  call vert_QA_Z(gZl,wf(:,82),wf(:,-2),wf(:,114))
  call vert_QA_V(wf(:,0),wf(:,84),wf(:,115))
  call vert_QA_V(wf(:,0),wf(:,86),wf(:,116))
  call vert_QA_Z(gZl,wf(:,0),wf(:,84),wf(:,117))
  call vert_QA_Z(gZl,wf(:,0),wf(:,86),wf(:,118))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5) - MZ2)
  den(2) = 1 / (Q(5,10) - MZ2)
  den(3) = 1 / (Q(5,48) - MH2)
  den(6) = 1 / (Q(5,9) - MZ2)
  den(7) = 1 / (Q(5,6) - MZ2)
  den(10) = 1 / (Q(5,5))
  den(11) = 1 / (Q(5,10))
  den(18) = 1 / (Q(5,9))
  den(19) = 1 / (Q(5,6))
  den(27) = 1 / (Q(5,58) - MZ2)
  den(32) = 1 / (Q(5,53) - MZ2)
  den(37) = 1 / (Q(5,54) - MZ2)
  den(42) = 1 / (Q(5,57) - MZ2)
  den(46) = 1 / (Q(5,15) - MH2)
  den(48) = 1 / (Q(5,7))
  den(51) = 1 / (Q(5,13))
  den(57) = 1 / (Q(5,14))
  den(60) = 1 / (Q(5,11))
  den(69) = 1 / (Q(5,15))
  den(71) = 1 / (Q(5,15) - MZ2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(8) = den(6)*den(7)
  den(9) = den(3)*den(8)
  den(12) = den(10)*den(11)
  den(13) = den(3)*den(12)
  den(14) = den(2)*den(10)
  den(15) = den(3)*den(14)
  den(16) = den(1)*den(11)
  den(17) = den(3)*den(16)
  den(20) = den(18)*den(19)
  den(21) = den(3)*den(20)
  den(22) = den(7)*den(18)
  den(23) = den(3)*den(22)
  den(24) = den(6)*den(19)
  den(25) = den(3)*den(24)
  den(26) = den(2)*den(3)
  den(28) = den(26)*den(27)
  den(29) = den(10)*den(28)
  den(30) = den(1)*den(28)
  den(31) = den(1)*den(3)
  den(33) = den(31)*den(32)
  den(34) = den(11)*den(33)
  den(35) = den(2)*den(33)
  den(36) = den(3)*den(7)
  den(38) = den(36)*den(37)
  den(39) = den(18)*den(38)
  den(40) = den(6)*den(38)
  den(41) = den(3)*den(6)
  den(43) = den(41)*den(42)
  den(44) = den(19)*den(43)
  den(45) = den(7)*den(43)
  den(47) = den(12)*den(46)
  den(49) = den(10)*den(48)
  den(50) = den(1)*den(48)
  den(52) = den(10)*den(51)
  den(53) = den(1)*den(51)
  den(54) = den(20)*den(46)
  den(55) = den(19)*den(48)
  den(56) = den(7)*den(48)
  den(58) = den(19)*den(57)
  den(59) = den(7)*den(57)
  den(61) = den(18)*den(60)
  den(62) = den(6)*den(60)
  den(63) = den(18)*den(51)
  den(64) = den(6)*den(51)
  den(65) = den(11)*den(60)
  den(66) = den(2)*den(60)
  den(67) = den(11)*den(57)
  den(68) = den(2)*den(57)
  den(70) = den(49)*den(69)
  den(72) = den(49)*den(71)
  den(73) = den(50)*den(69)
  den(74) = den(50)*den(71)
  den(75) = den(52)*den(69)
  den(76) = den(52)*den(71)
  den(77) = den(53)*den(69)
  den(78) = den(53)*den(71)
  den(79) = den(55)*den(69)
  den(80) = den(55)*den(71)
  den(81) = den(56)*den(69)
  den(82) = den(56)*den(71)
  den(83) = den(58)*den(69)
  den(84) = den(59)*den(69)
  den(85) = den(58)*den(71)
  den(86) = den(59)*den(71)
  den(87) = den(61)*den(69)
  den(88) = den(61)*den(71)
  den(89) = den(62)*den(69)
  den(90) = den(62)*den(71)
  den(91) = den(63)*den(69)
  den(92) = den(63)*den(71)
  den(93) = den(64)*den(69)
  den(94) = den(64)*den(71)
  den(95) = den(65)*den(69)
  den(96) = den(65)*den(71)
  den(97) = den(66)*den(69)
  den(98) = den(66)*den(71)
  den(99) = den(67)*den(69)
  den(100) = den(68)*den(69)
  den(101) = den(67)*den(71)
  den(102) = den(68)*den(71)
  den(103) = den(3)*den(10)*den(11)
  den(104) = den(2)*den(3)*den(10)
  den(105) = den(1)*den(3)*den(11)
  den(106) = den(1)*den(2)*den(3)
  den(107) = den(3)*den(49)
  den(108) = den(3)*den(50)
  den(109) = den(3)*den(52)
  den(110) = den(3)*den(53)
  den(111) = den(3)*den(10)
  den(112) = den(3)*den(18)*den(19)
  den(113) = den(3)*den(7)*den(18)
  den(114) = den(3)*den(6)*den(19)
  den(115) = den(3)*den(6)*den(7)
  den(116) = den(3)*den(55)
  den(117) = den(3)*den(56)
  den(118) = den(3)*den(58)
  den(119) = den(3)*den(59)
  den(120) = den(3)*den(19)
  den(121) = den(3)*den(61)
  den(122) = den(3)*den(62)
  den(123) = den(3)*den(63)
  den(124) = den(3)*den(64)
  den(125) = den(3)*den(18)
  den(126) = den(3)*den(65)
  den(127) = den(3)*den(66)
  den(128) = den(3)*den(67)
  den(129) = den(3)*den(68)
  den(130) = den(3)*den(11)
  den(131) = den(10)*den(130)
  den(132) = den(10)*den(26)
  den(133) = den(1)*den(130)
  den(134) = den(1)*den(26)
  den(135) = den(11)*den(111)
  den(136) = den(2)*den(111)
  den(137) = den(11)*den(31)
  den(138) = den(2)*den(31)
  den(139) = den(18)*den(120)
  den(140) = den(18)*den(36)
  den(141) = den(6)*den(120)
  den(142) = den(6)*den(36)
  den(143) = den(19)*den(125)
  den(144) = den(7)*den(125)
  den(145) = den(19)*den(41)
  den(146) = den(7)*den(41)
  den(147) = den(3)*den(70)
  den(148) = den(3)*den(72)
  den(149) = den(3)*den(73)
  den(150) = den(3)*den(74)
  den(151) = den(3)*den(75)
  den(152) = den(3)*den(76)
  den(153) = den(3)*den(77)
  den(154) = den(3)*den(78)
  den(155) = den(3)*den(79)
  den(156) = den(3)*den(80)
  den(157) = den(3)*den(81)
  den(158) = den(3)*den(82)
  den(159) = den(3)*den(83)
  den(160) = den(3)*den(84)
  den(161) = den(3)*den(85)
  den(162) = den(3)*den(86)
  den(163) = den(3)*den(87)
  den(164) = den(3)*den(88)
  den(165) = den(3)*den(89)
  den(166) = den(3)*den(90)
  den(167) = den(3)*den(91)
  den(168) = den(3)*den(92)
  den(169) = den(3)*den(93)
  den(170) = den(3)*den(94)
  den(171) = den(3)*den(95)
  den(172) = den(3)*den(96)
  den(173) = den(3)*den(97)
  den(174) = den(3)*den(98)
  den(175) = den(3)*den(99)
  den(176) = den(3)*den(100)
  den(177) = den(3)*den(101)
  den(178) = den(3)*den(102)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(32)

  A(1) = cont_SS(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_SS(wf(:,3),wf(:,7)) * den(9)

  A(3) = cont_SS(wf(:,3),wf(:,10)) * den(13)
  A(4) = cont_SS(wf(:,3),wf(:,11)) * den(15)
  A(5) = cont_SS(wf(:,3),wf(:,12)) * den(17)
  A(6) = cont_SS(wf(:,3),wf(:,13)) * den(5)
  A(7) = cont_SS(wf(:,14),wf(:,15)) * den(13)
  A(8) = cont_SS(wf(:,3),wf(:,18)) * den(21)
  A(9) = cont_SS(wf(:,3),wf(:,19)) * den(23)
  A(10) = cont_SS(wf(:,3),wf(:,20)) * den(25)
  A(11) = cont_SS(wf(:,3),wf(:,21)) * den(9)
  A(12) = cont_SS(wf(:,14),wf(:,22)) * den(21)
  A(13) = cont_SS(wf(:,3),wf(:,24)) * den(5)
  A(14) = cont_SS(wf(:,3),wf(:,26)) * den(9)
  A(15) = cont_SS(wf(:,3),wf(:,28)) * den(9)
  A(16) = cont_SS(wf(:,3),wf(:,30)) * den(5)
  A(17) = cont_SS(wf(:,31),wf(:,32)) * den(29)
  A(18) = cont_SS(wf(:,31),wf(:,33)) * den(30)
  A(19) = cont_VV(wf(:,34),wf(:,35)) * den(29)
  A(20) = cont_VV(wf(:,34),wf(:,36)) * den(30)
  A(21) = cont_SS(wf(:,37),wf(:,38)) * den(34)
  A(22) = cont_SS(wf(:,37),wf(:,39)) * den(35)
  A(23) = cont_VV(wf(:,40),wf(:,41)) * den(34)
  A(24) = cont_VV(wf(:,40),wf(:,42)) * den(35)
  A(25) = cont_SS(wf(:,43),wf(:,44)) * den(39)
  A(26) = cont_SS(wf(:,43),wf(:,45)) * den(40)
  A(27) = cont_VV(wf(:,46),wf(:,47)) * den(39)
  A(28) = cont_VV(wf(:,46),wf(:,48)) * den(40)
  A(29) = cont_SS(wf(:,49),wf(:,50)) * den(44)
  A(30) = cont_SS(wf(:,49),wf(:,51)) * den(45)
  A(31) = cont_VV(wf(:,52),wf(:,53)) * den(44)
  A(32) = cont_VV(wf(:,52),wf(:,54)) * den(45)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(32)
  complex(REALKIND), intent(out) :: M1(1), M2(2)

  M1(1) = 2*(-A(1)+A(2))*f(2)

  M2(1) = 2*(-A(7)+A(12))*f(1)
  M2(2) = 2*(-A(13)+A(14)+A(15)-A(16)+A(19)+A(20)+A(23)+A(24)-A(27)-A(28)-A(31)-A(32))*f(3)+2*(A(17)+A(18)+A(21)+A(22)-A(25)-A(26) &
       -A(29)-A(30))*f(4)+2*(-A(3)+A(8))*f(5)+2*(-A(4)-A(5)+A(9)+A(10))*f(6)+2*(-A(6)+A(11))*f(7)

end subroutine colourvectors

end module ol_loop_heftpph_ew_eeexexgg_1_/**/REALKIND
