
module ol_vamp_1_eevv_ew_eexaz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eevv_ew_eexaz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eevv_ew_eexaz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eevv_ew_eexaz_1_/**/DREALKIND
  use ol_tensor_sum_storage_eevv_ew_eexaz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_eevv_ew_eexaz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eevv_ew_eexaz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1),h0tab(:,1),[8,2,1,4],[nME,nMH,nME,nME],4,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(1),ngZl,m3h3x8(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G0H8(1),8,nME,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(2),h0tab(:,2),[8,2,1,4],[nME,nMZ,nME,nME],4,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(1),ngZl,m3h3x8(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G0H8(1),8,nME,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(3),m3h3x8(:,3),heltab2x24(:,:,3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(4),h0tab(:,4),[8,2,1,4],[nME,0,nME,nME],4,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(1),ngZl,m3h3x8(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G0H8(1),8,nME,G1H8(4),n2h8(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(5),h0tab(:,5),[8,2,1,4],[nME,nMZ,nME,nME],4,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(1),ngZl,m3h3x8(:,5),heltab2x24(:,:,5))
  call Hloop_Q_A(ntryL,G0H8(1),8,nME,G1H8(5),n2h8(4))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(6),h0tab(:,6),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(1),m3h3x8(:,6),heltab2x24(:,:,6))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(7),h0tab(:,7),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(2),m3h3x8(:,7),heltab2x24(:,:,7))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(6),m3h3x8(:,8),heltab2x24(:,:,8))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(9),h0tab(:,9),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(7),m3h3x8(:,9),heltab2x24(:,:,9))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(10),h0tab(:,10),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(3),m3h3x8(:,10),heltab2x24(:,:,10))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(11),h0tab(:,11),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(4),m3h3x8(:,11),heltab2x24(:,:,11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(12),h0tab(:,12),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(8),m3h3x8(:,12),heltab2x24(:,:,12))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(13),h0tab(:,13),[8,1,2,4],[nME,nMH,nME,nME],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(5),ngZl,m3h3x8(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(9),n2h8(5))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(14),h0tab(:,14),[8,1,2,4],[nME,nMZ,nME,nME],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(5),ngZl,m3h3x8(:,14),heltab2x24(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(10),n2h8(6))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(15),h0tab(:,15),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(11),m3h3x8(:,15),heltab2x24(:,:,15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(16),h0tab(:,16),[8,1,2,4],[nME,0,nME,nME],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(5),ngZl,m3h3x8(:,16),heltab2x24(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(12),n2h8(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(17),h0tab(:,17),[8,1,2,4],[nME,nMZ,nME,nME],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(5),ngZl,m3h3x8(:,17),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(13),n2h8(8))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(18),h0tab(:,18),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(5),m3h3x8(:,18),heltab2x24(:,:,18))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(19),h0tab(:,19),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(14),m3h3x8(:,19),heltab2x24(:,:,19))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(20),h0tab(:,20),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(6),m3h3x8(:,20),heltab2x24(:,:,20))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(21),h0tab(:,21),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(7),m3h3x8(:,21),heltab2x24(:,:,21))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(22),h0tab(:,22),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(15),m3h3x8(:,22),heltab2x24(:,:,22))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(23),h0tab(:,23),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(8),m3h3x8(:,23),heltab2x24(:,:,23))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(24),h0tab(:,24),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(16),m3h3x8(:,24),heltab2x24(:,:,24))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(25),h0tab(:,25),[8,1,4,2],[nMH,nME,nME,nMZ],4,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(17),m3h3x8(:,25),heltab2x24(:,:,25))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(26),h0tab(:,26),[8,1,4,2],[nMZ,nME,nME,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(18),m3h3x8(:,26),heltab2x24(:,:,26))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(27),h0tab(:,27),[8,1,4,2],[0,nMW,nMW,0],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(9),ngZn,m3h3x8(:,27),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(9),8,0,G1H8(19),n2h8(9))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(28),h0tab(:,28),[8,1,4,2],[nMH,nME,nME,nMZ],4,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(9),m3h3x8(:,28),heltab2x24(:,:,28))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(29),h0tab(:,29),[8,1,4,2],[nMZ,nME,nME,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(10),m3h3x8(:,29),heltab2x24(:,:,29))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(30),h0tab(:,30),[8,1,4,2],[0,nMW,nMW,0],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(11),ngZn,m3h3x8(:,30),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(11),8,0,G1H8(20),n2h8(10))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(31),h0tab(:,31),[8,1,4,2],[0,nMW,nMW,0],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(11),ngZn,m3h3x8(:,31),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(11),8,0,G1H8(21),n2h8(11))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(32),h0tab(:,32),[8,1,4,2],[0,nMW,nMW,0],4,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(11),ngZn,m3h3x8(:,32),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(11),8,0,G1H8(22),n2h8(12))
  call Hloop_QA_S(ntryL,G1H8(1),ex2(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_S(ntryL,G1H8(2),ex2(:),G1H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_SA_Q(ntryL,G1H8(3),ex2(:),G1H4(3),ngPln,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(3),10,0,G2H4(1),n2h4(1))
  call Hloop_QA_V(ntryL,G1H8(4),ex2(:),G1H4(3),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_Z(ntryL,G1H8(5),ex2(:),G1H4(4),ngZl,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_SA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngPln,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(5),n2h4(2))
  call Hloop_WA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(6),n2h4(3))
  call Hloop_SA_Q(ntryL,G1H8(6),ex2(:),G1H4(7),ngPln,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(7),10,0,G2H4(2),n2h4(4))
  call Hloop_WA_Q(ntryL,G1H8(7),ex2(:),G1H4(7),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(7),10,0,G2H4(3),n2h4(5))
  call Hloop_SA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngPln,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(7),n2h4(6))
  call Hloop_WA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(8),n2h4(7))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(9),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(9),10,0,G2H4(4),n2h4(8))
  call Hloop_AQ_S(ntryL,G1H8(9),ex1(:),G1H4(9),ngH,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_S(ntryL,G1H8(10),ex1(:),G1H4(10),ngX,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_SQ_A(ntryL,G1H8(11),ex1(:),G1H4(11),ngPnl,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(11),9,0,G2H4(5),n2h4(9))
  call Hloop_AQ_V(ntryL,G1H8(12),ex1(:),G1H4(11),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H8(13),ex1(:),G1H4(12),ngZl,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_SQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),ngPnl,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(13),n2h4(10))
  call Hloop_SQ_A(ntryL,G1H8(14),ex1(:),G1H4(14),ngPnl,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(14),9,0,G2H4(6),n2h4(11))
  call Hloop_WQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(14),n2h4(12))
  call Hloop_SQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),ngPnl,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(15),n2h4(13))
  call Hloop_WQ_A(ntryL,G1H8(15),ex1(:),G1H4(16),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(16),9,0,G2H4(7),n2h4(14))
  call Hloop_WQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(16),n2h4(15))
  call Hloop_WQ_A(ntryL,G1H8(16),ex1(:),G1H4(17),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(17),9,0,G2H4(8),n2h4(16))
  call Hloop_SQ_A(ntryL,G1H8(17),ex1(:),G1H4(17),ngH,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(17),9,nME,G2H4(9),n2h4(17))
  call Hloop_SQ_A(ntryL,G1H8(18),ex1(:),G1H4(17),ngX,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(17),9,nME,G2H4(10),n2h4(18))
  call Hloop_AQ_S(ntryL,G1H8(19),ex1(:),G1H4(17),ngPnl,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_SQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),ngH,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(18),n2h4(19))
  call Hloop_ZQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),ngZl,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(19),n2h4(20))
  call Hloop_AQ_S(ntryL,G1H8(20),ex1(:),G1H4(20),ngPnl,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_AQ_W(ntryL,G1H8(21),ex1(:),G1H4(21),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_AQ_W(ntryL,G1H8(22),ex1(:),G1H4(22),m3h2x4(:,32),heltab2x8(:,:,32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(19)])
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(1),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(2),n2h2(2))
  call Hloop_AQ_S(ntryL,G2H4(1),ex1(:),G2H2(3),ngPnl,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_VQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(4),n2h2(3))
  call Hloop_ZQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),ngZl,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(5),n2h2(4))
  call Hloop_AQ_S(ntryL,G2H4(3),ex1(:),G2H2(6),ngPnl,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_W(ntryL,G2H4(2),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_W(ntryL,G2H4(4),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_SA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),ngH,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),11,nME,G2H2(9),n2h2(5))
  call Hloop_SA_Q(ntryL,G1H4(10),ex2(:),G1H2(1),ngX,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),11,nME,G2H2(10),n2h2(6))
  call Hloop_QA_S(ntryL,G2H4(5),ex2(:),G2H2(11),ngPln,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),11,nME,G2H2(12),n2h2(7))
  call Hloop_ZA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),ngZl,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),11,nME,G2H2(13),n2h2(8))
  call Hloop_QA_S(ntryL,G2H4(7),ex2(:),G2H2(14),ngPln,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_W(ntryL,G2H4(6),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_W(ntryL,G2H4(8),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(1),mass4set(:,1),  & 
G1H4(6),G1H4(5),G1H4(8),G1H4(7),G1H4(14),4)
  call HG1shiftOLR(G1H4(5),2,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(1),mass4set(:,2),  & 
G1H4(13),G1H4(16),G1H4(15),G1H4(19),G1H4(1),4)
  call HG1shiftOLR(G1H4(16),2,4)
  call Hloop_TV_S(ntryL,G1H4(17),9,ex3(:),4,G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QV_A(ntryL,G1H4(18),ex3(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),13,nME,G2H2(18),n2h2(9))
  call Hloop_SV_V(ntryL,G1H4(20),ex3(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VV_S(ntryL,G1H4(21),ex3(:),G1H2(2),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_UV_W(ntryL,G1H4(22),9,ex3(:),4,G2H2(19),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QV_A(ntryL,G1H4(6),ex3(:),G1H2(3),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(3),13,nME,G2H2(20),n2h2(10))
call HGT_OLR(G1H4(5),1,1,4)
call HGT_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(5),ex2(:),G1H2(3),ngX,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QV_A(ntryL,G1H4(7),ex3(:),G1H2(4),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(4),13,nME,G2H2(21),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(14),ex3(:),G1H2(4),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(4),13,nME,G2H2(22),n2h2(12))
  call Hloop_QV_A(ntryL,G1H4(13),ex3(:),G1H2(4),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(4),13,nME,G2H2(23),n2h2(13))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(16),ex2(:),G1H2(4),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QV_A(ntryL,G1H4(19),ex3(:),G1H2(5),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(5),13,nME,G2H2(24),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(1),ex3(:),G1H2(5),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(5),13,nME,G2H2(25),n2h2(15))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(1)])
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(2),mass4set(:,3),  & 
G1H2(5),G1H2(2),G1H2(1),G1H2(6),G1H2(7),2)
  call HG1shiftOLR(G1H2(2),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(2),mass4set(:,4),  & 
G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(9),4,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(2),mass4set(:,5),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(14),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(2),mass4set(:,6),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(2),mass4set(:,5),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),2)
  call HG1shiftOLR(G1H2(24),4,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(3),mass4set(:,3),  & 
G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(29),4,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(3),mass4set(:,4),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),2)
  call HG1shiftOLR(G1H2(34),4,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(3),mass4set(:,5),  & 
G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(39),4,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(3),mass4set(:,6),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(3),mass4set(:,5),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(49),4,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(1),mass4set(:,7),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),2)
  call HG1shiftOLR(G1H2(54),2,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(5),ngZl,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(1),mass4set(:,7),  & 
G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(59),2,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(6),ngX,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(7),ngX,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(8),ngH,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(9),ngH,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hloop_QV_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(10),n2h1(1))
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(11),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(12),n2h1(3))
  call Hloop_QV_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(13),n2h1(4))
  call Hloop_QV_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(14),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(15),n2h1(6))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(13),11,ex3(:),4,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(14),0,ex3(:),4,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(17),11,ex3(:),4,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hloop_QV_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(19),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(20),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(21),n2h1(10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(23),11,ex3(:),4,G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(24),0,ex3(:),4,G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),11,ex3(:),4,G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_AV_Q(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(25),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(26),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(27),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(28),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(29),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(30),n2h1(17))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(38),11,ex3(:),4,G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(39),0,ex3(:),4,G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(42),11,ex3(:),4,G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hloop_AV_Q(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(34),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(35),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(36),n2h1(21))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(48),11,ex3(:),4,G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(49),0,ex3(:),4,G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(52),11,ex3(:),4,G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hloop_SA_Q(ntryL,G1H2(53),ex2(:),G1H1(1),ngPln,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(40),n2h1(23))
  call Hloop_SA_Q(ntryL,G1H2(54),ex2(:),G1H1(1),ngPln,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(41),n2h1(24))
  call Hloop_SA_Q(ntryL,G1H2(57),ex2(:),G1H1(1),ngPln,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(42),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(58),ex2(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(43),n2h1(26))
  call Hloop_WA_Q(ntryL,G1H2(59),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(44),n2h1(27))
  call Hloop_WA_Q(ntryL,G1H2(62),ex2(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(45),n2h1(28))
  call ol_merge_tensors(G2tensor(22),[G2tensor(16),G2tensor(2),G2tensor(1)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(31),G2tensor(4),G2tensor(3)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(40)])
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(2),mass4set(:,5),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(3),mass4set(:,5),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(1),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),2)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(1),mass4set(:,2),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),2)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(2),mass4set(:,3),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(2),mass4set(:,4),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(2),mass4set(:,6),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(3),mass4set(:,3),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(3),mass4set(:,4),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(3),mass4set(:,6),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(1),mass4set(:,7),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,5),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(3),mass4set(:,5),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,3),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,4),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(2),mass4set(:,6),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(3),mass4set(:,3),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(3),mass4set(:,4),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(3),mass4set(:,6),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(1),mass4set(:,7),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(33),h0tab(:,33),[12,1,2],[nMW,0,nMW],4,0)
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(1),m4h3x2x4(:,1),heltab3x24(:,:,1))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(34),h0tab(:,34),[12,1,2],[nMW,0,nMW],4,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(2),m4h3x2x4(:,2),heltab3x24(:,:,2))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(35),h0tab(:,35),[8,3,4],[nME,nME,nME],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(11),ngZl,m3h3x8(:,33),heltab2x24(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(11),8,nME,G1H8(1),n2h8(13))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(36),h0tab(:,36),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(1),ngZl,m3h3x8(:,34),heltab2x24(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMM,G1H8(2),n2h8(14))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(37),h0tab(:,37),[8,3,4],[nML,nML,nML],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(2),ngZl,m3h3x8(:,35),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(2),8,nML,G1H8(3),n2h8(15))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(38),h0tab(:,38),[8,3,4],[nME,nME,nME],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(3),ngZl,m3h3x8(:,36),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G0H8(3),8,nME,G1H8(4),n2h8(16))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(39),h0tab(:,39),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(4),ngZl,m3h3x8(:,37),heltab2x24(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(4),8,nMM,G1H8(5),n2h8(17))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(40),h0tab(:,40),[8,3,4],[nML,nML,nML],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(5),ngZl,m3h3x8(:,38),heltab2x24(:,:,38))
  call Hloop_Q_A(ntryL,G0H8(5),8,nML,G1H8(6),n2h8(18))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(41),h0tab(:,41),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(6),ngZu,m3h3x8(:,39),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(6),8,nMT,G1H8(7),n2h8(19))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(42),h0tab(:,42),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(7),ngZu,m3h3x8(:,40),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G0H8(7),8,nMT,G1H8(8),n2h8(20))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(43),h0tab(:,43),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(8),ngZd,m3h3x8(:,41),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(8),8,nMB,G1H8(9),n2h8(21))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(44),h0tab(:,44),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(9),ngZd,m3h3x8(:,42),heltab2x24(:,:,42))
  call Hloop_Q_A(ntryL,G0H8(9),8,nMB,G1H8(10),n2h8(22))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(45),h0tab(:,45),[8,3,4],[nME,nME,nME],3,1,wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(10),ngZl,m3h3x8(:,43),heltab2x24(:,:,43))
  call Hloop_A_Q(ntryL,G0H8(10),8,nME,G1H8(11),n2h8(23))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(46),h0tab(:,46),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(11),ngZl,m3h3x8(:,44),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G0H8(11),8,nMM,G1H8(12),n2h8(24))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(47),h0tab(:,47),[8,3,4],[nML,nML,nML],3,1,wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(1),ngZl,m3h3x8(:,45),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(1),8,nML,G1H8(13),n2h8(25))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(48),h0tab(:,48),[8,3,4],[nME,nME,nME],3,1,wf4(:,9))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(2),ngZl,m3h3x8(:,46),heltab2x24(:,:,46))
  call Hloop_Q_A(ntryL,G0H8(2),8,nME,G1H8(14),n2h8(26))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(49),h0tab(:,49),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,9))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(3),ngZl,m3h3x8(:,47),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(3),8,nMM,G1H8(15),n2h8(27))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(50),h0tab(:,50),[8,3,4],[nML,nML,nML],3,1,wf4(:,9))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(4),ngZl,m3h3x8(:,48),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G0H8(4),8,nML,G1H8(16),n2h8(28))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(51),h0tab(:,51),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(5),ngZu,m3h3x8(:,49),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMT,G1H8(17),n2h8(29))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(52),h0tab(:,52),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,9))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(6),ngZu,m3h3x8(:,50),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G0H8(6),8,nMT,G1H8(18),n2h8(30))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(53),h0tab(:,53),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(7),ngZd,m3h3x8(:,51),heltab2x24(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(7),8,nMB,G1H8(19),n2h8(31))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(54),h0tab(:,54),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,9))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(8),ngZd,m3h3x8(:,52),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G0H8(8),8,nMB,G1H8(20),n2h8(32))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(55),h0tab(:,55),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(21),m3h3x8(:,53),heltab2x24(:,:,53))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(56),h0tab(:,56),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(22),m3h3x8(:,54),heltab2x24(:,:,54))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(57),h0tab(:,57),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(23),m3h3x8(:,55),heltab2x24(:,:,55))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(58),h0tab(:,58),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(24),m3h3x8(:,56),heltab2x24(:,:,56))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(59),h0tab(:,59),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(25),m3h3x8(:,57),heltab2x24(:,:,57))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(60),h0tab(:,60),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(26),m3h3x8(:,58),heltab2x24(:,:,58))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(61),h0tab(:,61),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(27),m3h3x8(:,59),heltab2x24(:,:,59))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(62),h0tab(:,62),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(28),m3h3x8(:,60),heltab2x24(:,:,60))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(63),h0tab(:,63),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(29),m3h3x8(:,61),heltab2x24(:,:,61))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(64),h0tab(:,64),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(30),m3h3x8(:,62),heltab2x24(:,:,62))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(65),h0tab(:,65),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(31),m3h3x8(:,63),heltab2x24(:,:,63))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(66),h0tab(:,66),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(32),m3h3x8(:,64),heltab2x24(:,:,64))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(67),h0tab(:,67),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(9),m3h3x8(:,65),heltab2x24(:,:,65))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(68),h0tab(:,68),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(10),m3h3x8(:,66),heltab2x24(:,:,66))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(69),h0tab(:,69),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(11),m3h3x8(:,67),heltab2x24(:,:,67))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(70),h0tab(:,70),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(1),m3h3x8(:,68),heltab2x24(:,:,68))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(71),h0tab(:,71),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(33),m3h3x8(:,69),heltab2x24(:,:,69))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(72),h0tab(:,72),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(34),m3h3x8(:,70),heltab2x24(:,:,70))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(73),h0tab(:,73),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(35),m3h3x8(:,71),heltab2x24(:,:,71))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(74),h0tab(:,74),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(36),m3h3x8(:,72),heltab2x24(:,:,72))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(75),h0tab(:,75),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(2),m3h3x8(:,73),heltab2x24(:,:,73))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(76),h0tab(:,76),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(3),m3h3x8(:,74),heltab2x24(:,:,74))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(77),h0tab(:,77),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(4),m3h3x8(:,75),heltab2x24(:,:,75))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(78),h0tab(:,78),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(5),m3h3x8(:,76),heltab2x24(:,:,76))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(79),h0tab(:,79),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(37),m3h3x8(:,77),heltab2x24(:,:,77))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(80),h0tab(:,80),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(38),m3h3x8(:,78),heltab2x24(:,:,78))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(81),h0tab(:,81),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(39),m3h3x8(:,79),heltab2x24(:,:,79))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(82),h0tab(:,82),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(40),m3h3x8(:,80),heltab2x24(:,:,80))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(83),h0tab(:,83),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(6),m3h3x8(:,81),heltab2x24(:,:,81))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(84),h0tab(:,84),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(7),m3h3x8(:,82),heltab2x24(:,:,82))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(85),h0tab(:,85),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(8),m3h3x8(:,83),heltab2x24(:,:,83))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(86),h0tab(:,86),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(12),m3h3x8(:,84),heltab2x24(:,:,84))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(87),h0tab(:,87),[8,3,4],[nME,nME,nME],3,1,wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,85),heltab2x24(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(13),8,nME,G1H8(41),n2h8(33))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(88),h0tab(:,88),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,86),heltab2x24(:,:,86))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMM,G1H8(42),n2h8(34))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(89),h0tab(:,89),[8,3,4],[nML,nML,nML],3,1,wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,87),heltab2x24(:,:,87))
  call Hloop_A_Q(ntryL,G0H8(13),8,nML,G1H8(43),n2h8(35))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(90),h0tab(:,90),[8,3,4],[nME,nME,nME],3,1,wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,88),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G0H8(13),8,nME,G1H8(44),n2h8(36))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(91),h0tab(:,91),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,89),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G0H8(13),8,nMM,G1H8(45),n2h8(37))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(92),h0tab(:,92),[8,3,4],[nML,nML,nML],3,1,wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,90),heltab2x24(:,:,90))
  call Hloop_Q_A(ntryL,G0H8(13),8,nML,G1H8(46),n2h8(38))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(93),h0tab(:,93),[8,3,4],[0,0,0],3,1,wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,91),heltab2x24(:,:,91))
  call Hloop_A_Q(ntryL,G0H8(13),8,0,G1H8(47),n2h8(39))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(94),h0tab(:,94),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,92),heltab2x24(:,:,92))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMT,G1H8(48),n2h8(40))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(95),h0tab(:,95),[8,3,4],[0,0,0],3,1,wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,93),heltab2x24(:,:,93))
  call Hloop_Q_A(ntryL,G0H8(13),8,0,G1H8(49),n2h8(41))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(96),h0tab(:,96),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,94),heltab2x24(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(13),8,nMT,G1H8(50),n2h8(42))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(97),h0tab(:,97),[8,3,4],[0,0,0],3,1,wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,95),heltab2x24(:,:,95))
  call Hloop_A_Q(ntryL,G0H8(13),8,0,G1H8(51),n2h8(43))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(98),h0tab(:,98),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,10))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,96),heltab2x24(:,:,96))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMB,G1H8(52),n2h8(44))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(99),h0tab(:,99),[8,3,4],[0,0,0],3,1,wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,97),heltab2x24(:,:,97))
  call Hloop_Q_A(ntryL,G0H8(13),8,0,G1H8(53),n2h8(45))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(100),h0tab(:,100),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,98),heltab2x24(:,:,98))
  call Hloop_Q_A(ntryL,G0H8(13),8,nMB,G1H8(54),n2h8(46))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(101),h0tab(:,101),[8,3,4],[nME,nME,nME],3,1,wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,99),heltab2x24(:,:,99))
  call Hloop_A_Q(ntryL,G0H8(13),8,nME,G1H8(55),n2h8(47))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(102),h0tab(:,102),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,100),heltab2x24(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMM,G1H8(56),n2h8(48))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(103),h0tab(:,103),[8,3,4],[nML,nML,nML],3,1,wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,101),heltab2x24(:,:,101))
  call Hloop_A_Q(ntryL,G0H8(13),8,nML,G1H8(57),n2h8(49))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(104),h0tab(:,104),[8,3,4],[nME,nME,nME],3,1,wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,102),heltab2x24(:,:,102))
  call Hloop_Q_A(ntryL,G0H8(13),8,nME,G1H8(58),n2h8(50))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(105),h0tab(:,105),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,103),heltab2x24(:,:,103))
  call Hloop_Q_A(ntryL,G0H8(13),8,nMM,G1H8(59),n2h8(51))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(106),h0tab(:,106),[8,3,4],[nML,nML,nML],3,1,wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZl,m3h3x8(:,104),heltab2x24(:,:,104))
  call Hloop_Q_A(ntryL,G0H8(13),8,nML,G1H8(60),n2h8(52))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(107),h0tab(:,107),[8,3,4],[0,0,0],3,1,wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,105),heltab2x24(:,:,105))
  call Hloop_A_Q(ntryL,G0H8(13),8,0,G1H8(61),n2h8(53))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(108),h0tab(:,108),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,106),heltab2x24(:,:,106))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMT,G1H8(62),n2h8(54))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(109),h0tab(:,109),[8,3,4],[0,0,0],3,1,wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,107),heltab2x24(:,:,107))
  call Hloop_Q_A(ntryL,G0H8(13),8,0,G1H8(63),n2h8(55))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(110),h0tab(:,110),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZu,m3h3x8(:,108),heltab2x24(:,:,108))
  call Hloop_Q_A(ntryL,G0H8(13),8,nMT,G1H8(64),n2h8(56))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(111),h0tab(:,111),[8,3,4],[0,0,0],3,1,wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,109),heltab2x24(:,:,109))
  call Hloop_A_Q(ntryL,G0H8(13),8,0,G1H8(65),n2h8(57))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(112),h0tab(:,112),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,11))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,110),heltab2x24(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMB,G1H8(66),n2h8(58))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(113),h0tab(:,113),[8,3,4],[0,0,0],3,1,wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,111),heltab2x24(:,:,111))
  call Hloop_Q_A(ntryL,G0H8(13),8,0,G1H8(67),n2h8(59))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(114),h0tab(:,114),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(13),ngZd,m3h3x8(:,112),heltab2x24(:,:,112))
  call Hloop_Q_A(ntryL,G0H8(13),8,nMB,G1H8(68),n2h8(60))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(115),h0tab(:,115),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(69),m3h3x8(:,113),heltab2x24(:,:,113))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(116),h0tab(:,116),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(70),m3h3x8(:,114),heltab2x24(:,:,114))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(117),h0tab(:,117),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(71),m3h3x8(:,115),heltab2x24(:,:,115))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(118),h0tab(:,118),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(72),m3h3x8(:,116),heltab2x24(:,:,116))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(119),h0tab(:,119),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(73),m3h3x8(:,117),heltab2x24(:,:,117))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(120),h0tab(:,120),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(74),m3h3x8(:,118),heltab2x24(:,:,118))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(121),h0tab(:,121),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(75),m3h3x8(:,119),heltab2x24(:,:,119))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(122),h0tab(:,122),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(76),m3h3x8(:,120),heltab2x24(:,:,120))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(123),h0tab(:,123),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(77),m3h3x8(:,121),heltab2x24(:,:,121))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(124),h0tab(:,124),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(78),m3h3x8(:,122),heltab2x24(:,:,122))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(125),h0tab(:,125),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex4(:),G1H8(79),m3h3x8(:,123),heltab2x24(:,:,123))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(126),h0tab(:,126),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex4(:),8,G1H8(80),m3h3x8(:,124),heltab2x24(:,:,124))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(127),h0tab(:,127),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(81),m3h3x8(:,125),heltab2x24(:,:,125))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(128),h0tab(:,128),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(82),m3h3x8(:,126),heltab2x24(:,:,126))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(129),h0tab(:,129),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(83),m3h3x8(:,127),heltab2x24(:,:,127))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(130),h0tab(:,130),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(84),m3h3x8(:,128),heltab2x24(:,:,128))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(131),h0tab(:,131),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(13),m3h3x8(:,129),heltab2x24(:,:,129))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(132),h0tab(:,132),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(14),m3h3x8(:,130),heltab2x24(:,:,130))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(133),h0tab(:,133),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(15),m3h3x8(:,131),heltab2x24(:,:,131))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(134),h0tab(:,134),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(16),m3h3x8(:,132),heltab2x24(:,:,132))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(135),h0tab(:,135),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(85),m3h3x8(:,133),heltab2x24(:,:,133))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(136),h0tab(:,136),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(86),m3h3x8(:,134),heltab2x24(:,:,134))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(137),h0tab(:,137),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(87),m3h3x8(:,135),heltab2x24(:,:,135))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(138),h0tab(:,138),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(88),m3h3x8(:,136),heltab2x24(:,:,136))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(139),h0tab(:,139),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(17),m3h3x8(:,137),heltab2x24(:,:,137))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(140),h0tab(:,140),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(18),m3h3x8(:,138),heltab2x24(:,:,138))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(141),h0tab(:,141),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(19),m3h3x8(:,139),heltab2x24(:,:,139))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(142),h0tab(:,142),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(20),m3h3x8(:,140),heltab2x24(:,:,140))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(143),h0tab(:,143),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(21),m3h3x8(:,141),heltab2x24(:,:,141))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(144),h0tab(:,144),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(22),m3h3x8(:,142),heltab2x24(:,:,142))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(145),h0tab(:,145),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(23),m3h3x8(:,143),heltab2x24(:,:,143))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(146),h0tab(:,146),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(24),m3h3x8(:,144),heltab2x24(:,:,144))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(147),h0tab(:,147),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(89),m3h3x8(:,145),heltab2x24(:,:,145))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(148),h0tab(:,148),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(90),m3h3x8(:,146),heltab2x24(:,:,146))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(149),h0tab(:,149),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(91),m3h3x8(:,147),heltab2x24(:,:,147))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(150),h0tab(:,150),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(92),m3h3x8(:,148),heltab2x24(:,:,148))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(151),h0tab(:,151),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(25),m3h3x8(:,149),heltab2x24(:,:,149))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(152),h0tab(:,152),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(26),m3h3x8(:,150),heltab2x24(:,:,150))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(153),h0tab(:,153),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(27),m3h3x8(:,151),heltab2x24(:,:,151))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(154),h0tab(:,154),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(28),m3h3x8(:,152),heltab2x24(:,:,152))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(155),h0tab(:,155),[8,2,5],[nME,nMH,nME],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(29),ngZl,m3h3x8(:,153),heltab2x24(:,:,153))
  call Hloop_Q_A(ntryL,G0H8(29),8,nME,G1H8(93),n2h8(61))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(156),h0tab(:,156),[8,2,5],[nME,nMZ,nME],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(29),ngZl,m3h3x8(:,154),heltab2x24(:,:,154))
  call Hloop_Q_A(ntryL,G0H8(29),8,nME,G1H8(94),n2h8(62))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(157),h0tab(:,157),[8,2,5],[0,nMW,0],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(29),ngZn,m3h3x8(:,155),heltab2x24(:,:,155))
  call Hloop_Q_A(ntryL,G0H8(29),8,0,G1H8(95),n2h8(63))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(158),h0tab(:,158),[8,2,5],[nMH,nME,nMZ],3,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(96),m3h3x8(:,156),heltab2x24(:,:,156))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(159),h0tab(:,159),[8,2,5],[nMZ,nME,nMH],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(97),m3h3x8(:,157),heltab2x24(:,:,157))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(160),h0tab(:,160),[8,2,5],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(98),m3h3x8(:,158),heltab2x24(:,:,158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(161),h0tab(:,161),[8,2,5],[nME,0,nME],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(29),ngZl,m3h3x8(:,159),heltab2x24(:,:,159))
  call Hloop_Q_A(ntryL,G0H8(29),8,nME,G1H8(99),n2h8(64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(162),h0tab(:,162),[8,2,5],[nME,nMZ,nME],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(29),ngZl,m3h3x8(:,160),heltab2x24(:,:,160))
  call Hloop_Q_A(ntryL,G0H8(29),8,nME,G1H8(100),n2h8(65))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(163),h0tab(:,163),[8,2,5],[0,nMW,0],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex4(:),G0H8(29),ngZn,m3h3x8(:,161),heltab2x24(:,:,161))
  call Hloop_Q_A(ntryL,G0H8(29),8,0,G1H8(101),n2h8(66))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(164),h0tab(:,164),[8,2,5],[nMH,nME,nMZ],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(29),m3h3x8(:,162),heltab2x24(:,:,162))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(165),h0tab(:,165),[8,2,5],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(30),m3h3x8(:,163),heltab2x24(:,:,163))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(166),h0tab(:,166),[8,2,5],[nMZ,nME,nMH],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(31),m3h3x8(:,164),heltab2x24(:,:,164))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(167),h0tab(:,167),[8,2,5],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(32),m3h3x8(:,165),heltab2x24(:,:,165))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(168),h0tab(:,168),[8,2,5],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(102),m3h3x8(:,166),heltab2x24(:,:,166))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(169),h0tab(:,169),[8,1,6],[nME,nMH,nME],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(33),ngZl,m3h3x8(:,167),heltab2x24(:,:,167))
  call Hloop_A_Q(ntryL,G0H8(33),8,nME,G1H8(103),n2h8(67))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(170),h0tab(:,170),[8,1,6],[nME,nMZ,nME],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(33),ngZl,m3h3x8(:,168),heltab2x24(:,:,168))
  call Hloop_A_Q(ntryL,G0H8(33),8,nME,G1H8(104),n2h8(68))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(171),h0tab(:,171),[8,1,6],[0,nMW,0],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(33),ngZn,m3h3x8(:,169),heltab2x24(:,:,169))
  call Hloop_A_Q(ntryL,G0H8(33),8,0,G1H8(105),n2h8(69))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(172),h0tab(:,172),[8,1,6],[nMH,nME,nMZ],3,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(106),m3h3x8(:,170),heltab2x24(:,:,170))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(173),h0tab(:,173),[8,1,6],[nMZ,nME,nMH],3,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(107),m3h3x8(:,171),heltab2x24(:,:,171))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(174),h0tab(:,174),[8,1,6],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex4(:),8,G1H8(108),m3h3x8(:,172),heltab2x24(:,:,172))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(175),h0tab(:,175),[8,1,6],[nME,0,nME],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(33),ngZl,m3h3x8(:,173),heltab2x24(:,:,173))
  call Hloop_A_Q(ntryL,G0H8(33),8,nME,G1H8(109),n2h8(70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(176),h0tab(:,176),[8,1,6],[nME,nMZ,nME],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(33),ngZl,m3h3x8(:,174),heltab2x24(:,:,174))
  call Hloop_A_Q(ntryL,G0H8(33),8,nME,G1H8(110),n2h8(71))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(177),h0tab(:,177),[8,1,6],[0,nMW,0],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex4(:),G0H8(33),ngZn,m3h3x8(:,175),heltab2x24(:,:,175))
  call Hloop_A_Q(ntryL,G0H8(33),8,0,G1H8(111),n2h8(72))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(178),h0tab(:,178),[8,1,6],[nMH,nME,nMZ],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(33),m3h3x8(:,176),heltab2x24(:,:,176))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(179),h0tab(:,179),[8,1,6],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H24(1),ex4(:),G0H8(34),m3h3x8(:,177),heltab2x24(:,:,177))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(180),h0tab(:,180),[8,1,6],[nMZ,nME,nMH],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(35),m3h3x8(:,178),heltab2x24(:,:,178))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(181),h0tab(:,181),[8,1,6],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(36),m3h3x8(:,179),heltab2x24(:,:,179))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(182),h0tab(:,182),[8,1,6],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex4(:),8,G1H8(112),m3h3x8(:,180),heltab2x24(:,:,180))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(183),h0tab(:,183),[9,2,4],[nMH,nME,nME],3,1,wf6(:,3))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,3),G0H4(3),ngH,m3h6x4(:,1),heltab2x24(:,:,181))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(184),h0tab(:,184),[9,2,4],[nMZ,nME,nME],3,1,wf6(:,3))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,3),G0H4(4),ngX,m3h6x4(:,2),heltab2x24(:,:,182))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(185),h0tab(:,185),[9,2,4],[0,nMW,nMW],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,3),G0H4(5),ngPnl,m3h6x4(:,3),heltab2x24(:,:,183))
  call Hloop_Q_A(ntryL,G0H4(5),9,0,G1H4(2),n2h4(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(186),h0tab(:,186),[9,2,4],[0,nME,nME],3,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,3),G0H4(5),m3h6x4(:,4),heltab2x24(:,:,184))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(187),h0tab(:,187),[9,2,4],[nMZ,nME,nME],3,1,wf6(:,3))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,3),G0H4(6),ngZl,m3h6x4(:,5),heltab2x24(:,:,185))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(188),h0tab(:,188),[9,2,4],[0,nMW,nMW],3,1,wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,3),G0H4(7),m3h6x4(:,6),heltab2x24(:,:,186))
  call Hloop_Q_A(ntryL,G0H4(7),9,0,G1H4(3),n2h4(24))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(189),h0tab(:,189),[9,2,4],[0,nMW,nMW],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,3),G0H4(7),ngPnl,m3h6x4(:,7),heltab2x24(:,:,187))
  call Hloop_Q_A(ntryL,G0H4(7),9,0,G1H4(4),n2h4(25))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(190),h0tab(:,190),[9,2,4],[0,nMW,nMW],3,1,wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,3),G0H4(7),m3h6x4(:,8),heltab2x24(:,:,188))
  call Hloop_Q_A(ntryL,G0H4(7),9,0,G1H4(9),n2h4(26))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(191),h0tab(:,191),[10,1,4],[nMH,nME,nME],3,1,wf6(:,7))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,7),G0H4(7),ngH,m3h6x4(:,9),heltab2x24(:,:,189))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(192),h0tab(:,192),[10,1,4],[nMZ,nME,nME],3,1,wf6(:,7))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,7),G0H4(8),ngX,m3h6x4(:,10),heltab2x24(:,:,190))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(193),h0tab(:,193),[10,1,4],[0,nMW,nMW],3,1,wf6(:,7))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(9),ngPln,m3h6x4(:,11),heltab2x24(:,:,191))
  call Hloop_A_Q(ntryL,G0H4(9),10,0,G1H4(10),n2h4(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(194),h0tab(:,194),[10,1,4],[0,nME,nME],3,1,wf6(:,7))
  call Hloop_QA_V(ntryL,G0H24(1),wf6(:,7),G0H4(9),m3h6x4(:,12),heltab2x24(:,:,192))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(195),h0tab(:,195),[10,1,4],[nMZ,nME,nME],3,1,wf6(:,7))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,7),G0H4(10),ngZl,m3h6x4(:,13),heltab2x24(:,:,193))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(196),h0tab(:,196),[10,1,4],[0,nMW,nMW],3,1,wf6(:,7))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(11),m3h6x4(:,14),heltab2x24(:,:,194))
  call Hloop_A_Q(ntryL,G0H4(11),10,0,G1H4(11),n2h4(28))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(197),h0tab(:,197),[10,1,4],[0,nMW,nMW],3,1,wf6(:,7))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(11),ngPln,m3h6x4(:,15),heltab2x24(:,:,195))
  call Hloop_A_Q(ntryL,G0H4(11),10,0,G1H4(12),n2h4(29))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(198),h0tab(:,198),[10,1,4],[0,nMW,nMW],3,1,wf6(:,7))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(11),m3h6x4(:,16),heltab2x24(:,:,196))
  call Hloop_A_Q(ntryL,G0H4(11),10,0,G1H4(17),n2h4(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(80),[G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(91)])
  call Hloop_QV_A(ntryL,G1H4(8),ex3(:),G1H2(5),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(5),13,nME,G2H2(2),n2h2(16))
  call Hloop_QV_A(ntryL,G1H4(15),ex3(:),G1H2(2),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(2),13,nME,G2H2(10),n2h2(17))
  call Hloop_SQ_A(ntryL,G0H4(1),ex1(:),G0H2(1),ngPnl,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G0H2(1),13,0,G1H2(7),n2h2(18))
  call Hloop_WQ_A(ntryL,G0H4(2),ex1(:),G0H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G0H2(1),13,0,G1H2(8),n2h2(19))
  call Hloop_AS_Q(ntryL,G1H8(1),wf4(:,4),G1H2(9),ngH,m3h4x2(:,1),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(9),11,nME,G2H2(1),n2h2(20))
  call Hloop_AS_Q(ntryL,G1H8(2),wf4(:,4),G1H2(12),ngH,m3h4x2(:,2),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(12),11,nMM,G2H2(5),n2h2(21))
  call Hloop_AS_Q(ntryL,G1H8(3),wf4(:,4),G1H2(13),ngH,m3h4x2(:,3),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(13),11,nML,G2H2(3),n2h2(22))
  call Hloop_QS_A(ntryL,G1H8(4),wf4(:,4),G1H2(14),ngH,m3h4x2(:,4),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(14),11,nME,G2H2(4),n2h2(23))
  call Hloop_QS_A(ntryL,G1H8(5),wf4(:,4),G1H2(17),ngH,m3h4x2(:,5),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(17),11,nMM,G2H2(6),n2h2(24))
  call Hloop_QS_A(ntryL,G1H8(6),wf4(:,4),G1H2(18),ngH,m3h4x2(:,6),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(18),11,nML,G2H2(7),n2h2(25))
  call Hloop_AS_Q(ntryL,G1H8(7),wf4(:,4),G1H2(19),ngH,m3h4x2(:,7),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(19),11,nMT,G2H2(8),n2h2(26))
  call Hloop_QS_A(ntryL,G1H8(8),wf4(:,4),G1H2(22),ngH,m3h4x2(:,8),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(22),11,nMT,G2H2(9),n2h2(27))
  call Hloop_AS_Q(ntryL,G1H8(9),wf4(:,4),G1H2(23),ngH,m3h4x2(:,9),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(23),11,nMB,G2H2(13),n2h2(28))
  call Hloop_QS_A(ntryL,G1H8(10),wf4(:,4),G1H2(24),ngH,m3h4x2(:,10),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(24),11,nMB,G2H2(11),n2h2(29))
  call Hloop_AS_Q(ntryL,G1H8(11),wf4(:,9),G1H2(27),ngX,m3h4x2(:,11),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(27),11,nME,G2H2(12),n2h2(30))
  call Hloop_AS_Q(ntryL,G1H8(12),wf4(:,9),G1H2(28),ngX,m3h4x2(:,12),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(28),11,nMM,G2H2(14),n2h2(31))
  call Hloop_AS_Q(ntryL,G1H8(13),wf4(:,9),G1H2(29),ngX,m3h4x2(:,13),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(29),11,nML,G2H2(15),n2h2(32))
  call Hloop_QS_A(ntryL,G1H8(14),wf4(:,9),G1H2(32),ngX,m3h4x2(:,14),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(32),11,nME,G2H2(16),n2h2(33))
  call Hloop_QS_A(ntryL,G1H8(15),wf4(:,9),G1H2(33),ngX,m3h4x2(:,15),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(33),11,nMM,G2H2(17),n2h2(34))
  call Hloop_QS_A(ntryL,G1H8(16),wf4(:,9),G1H2(34),ngX,m3h4x2(:,16),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(34),11,nML,G2H2(18),n2h2(35))
  call Hloop_AS_Q(ntryL,G1H8(17),wf4(:,9),G1H2(37),ngX,m3h4x2(:,17),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(37),11,nMT,G2H2(19),n2h2(36))
  call Hloop_QS_A(ntryL,G1H8(18),wf4(:,9),G1H2(38),ngX,m3h4x2(:,18),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(38),11,nMT,G2H2(20),n2h2(37))
  call Hloop_AS_Q(ntryL,G1H8(19),wf4(:,9),G1H2(39),ngX,m3h4x2(:,19),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(39),11,nMB,G2H2(22),n2h2(38))
  call Hloop_QS_A(ntryL,G1H8(20),wf4(:,9),G1H2(42),ngX,m3h4x2(:,20),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(42),11,nMB,G2H2(23),n2h2(39))
  call Hloop_SS_S(ntryL,G1H8(21),wf4(:,4),G1H2(43),m3h4x2(:,21),heltab2x8(:,:,53))
  call Hloop_SS_S(ntryL,G1H8(22),wf4(:,4),G1H2(44),m3h4x2(:,22),heltab2x8(:,:,54))
  call Hloop_SS_S(ntryL,G1H8(25),wf4(:,4),G1H2(47),m3h4x2(:,23),heltab2x8(:,:,55))
  call Hloop_SS_S(ntryL,G1H8(26),wf4(:,4),G1H2(48),m3h4x2(:,24),heltab2x8(:,:,56))
  call Hloop_SS_S(ntryL,G1H8(29),wf4(:,9),G1H2(49),m3h4x2(:,25),heltab2x8(:,:,57))
  call Hloop_SS_S(ntryL,G1H8(30),wf4(:,9),G1H2(52),m3h4x2(:,26),heltab2x8(:,:,58))
  call Hloop_VS_V(ntryL,G1H8(31),wf4(:,4),G1H2(53),m3h4x2(:,27),heltab2x8(:,:,59))
  call Hloop_VS_V(ntryL,G1H8(32),wf4(:,4),G1H2(54),m3h4x2(:,28),heltab2x8(:,:,60))
  call Hloop_VT_S(ntryL,G0H8(9),8,wf4(:,4),3,G1H2(57),m3h4x2(:,29),heltab2x8(:,:,61))
  call Hloop_VT_S(ntryL,G0H8(10),8,wf4(:,4),3,G1H2(58),m3h4x2(:,30),heltab2x8(:,:,62))
  call Hloop_VT_S(ntryL,G0H8(11),8,wf4(:,9),3,G1H2(59),m3h4x2(:,31),heltab2x8(:,:,63))
  call Hloop_VT_S(ntryL,G0H8(1),8,wf4(:,9),3,G1H2(62),m3h4x2(:,32),heltab2x8(:,:,64))
  call Hloop_ST_V(ntryL,G1H8(34),8,wf4(:,4),3,G2H2(25),m3h4x2(:,33),heltab2x8(:,:,65))
  call Hloop_ST_V(ntryL,G1H8(36),8,wf4(:,9),3,G2H2(26),m3h4x2(:,34),heltab2x8(:,:,66))
  call Hloop_SS_S(ntryL,G0H8(3),wf4(:,4),G0H2(1),m3h4x2(:,35),heltab2x8(:,:,67))
  call Hloop_VS_V(ntryL,G0H8(5),wf4(:,4),G0H2(2),m3h4x2(:,36),heltab2x8(:,:,68))
  call Hloop_VT_S(ntryL,G1H8(38),8,wf4(:,4),3,G2H2(27),m3h4x2(:,37),heltab2x8(:,:,69))
  call Hloop_VT_S(ntryL,G1H8(40),8,wf4(:,9),3,G2H2(28),m3h4x2(:,38),heltab2x8(:,:,70))
  call Hloop_ST_V(ntryL,G0H8(6),8,wf4(:,4),3,G1H2(5),m3h4x2(:,39),heltab2x8(:,:,71))
  call Hloop_ST_V(ntryL,G0H8(7),8,wf4(:,4),3,G1H2(2),m3h4x2(:,40),heltab2x8(:,:,72))
  call Hloop_ST_V(ntryL,G0H8(8),8,wf4(:,9),3,G1H2(9),m3h4x2(:,41),heltab2x8(:,:,73))
  call Hloop_ST_V(ntryL,G0H8(12),8,wf4(:,9),3,G1H2(12),m3h4x2(:,42),heltab2x8(:,:,74))
  call Hloop_AV_Q(ntryL,G1H8(41),wf4(:,10),G1H2(13),m3h4x2(:,43),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(13),11,nME,G2H2(29),n2h2(40))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,10),G1H2(14),m3h4x2(:,44),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(14),11,nMM,G2H2(30),n2h2(41))
  call Hloop_AV_Q(ntryL,G1H8(43),wf4(:,10),G1H2(17),m3h4x2(:,45),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(17),11,nML,G2H2(31),n2h2(42))
  call Hloop_QV_A(ntryL,G1H8(44),wf4(:,10),G1H2(18),m3h4x2(:,46),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(18),11,nME,G2H2(32),n2h2(43))
  call Hloop_QV_A(ntryL,G1H8(45),wf4(:,10),G1H2(19),m3h4x2(:,47),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(19),11,nMM,G2H2(33),n2h2(44))
  call Hloop_QV_A(ntryL,G1H8(46),wf4(:,10),G1H2(22),m3h4x2(:,48),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(22),11,nML,G2H2(34),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H8(51),wf4(:,10),G1H2(23),m3h4x2(:,49),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(23),11,0,G2H2(35),n2h2(46))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,10),G1H2(24),m3h4x2(:,50),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(24),11,nMT,G2H2(36),n2h2(47))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,10),G1H2(27),m3h4x2(:,51),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(27),11,0,G2H2(37),n2h2(48))
  call Hloop_QV_A(ntryL,G1H8(50),wf4(:,10),G1H2(28),m3h4x2(:,52),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(28),11,nMT,G2H2(38),n2h2(49))
  call Hloop_AV_Q(ntryL,G1H8(52),wf4(:,10),G1H2(29),m3h4x2(:,53),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(29),11,nMB,G2H2(39),n2h2(50))
  call Hloop_QV_A(ntryL,G1H8(54),wf4(:,10),G1H2(32),m3h4x2(:,54),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(32),11,nMB,G2H2(40),n2h2(51))
  call Hloop_AZ_Q(ntryL,G1H8(55),wf4(:,11),G1H2(33),ngZl,m3h4x2(:,55),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(33),11,nME,G2H2(41),n2h2(52))
  call Hloop_AZ_Q(ntryL,G1H8(56),wf4(:,11),G1H2(34),ngZl,m3h4x2(:,56),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(34),11,nMM,G2H2(42),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H8(57),wf4(:,11),G1H2(37),ngZl,m3h4x2(:,57),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(37),11,nML,G2H2(43),n2h2(54))
  call Hloop_QZ_A(ntryL,G1H8(58),wf4(:,11),G1H2(38),ngZl,m3h4x2(:,58),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(38),11,nME,G2H2(44),n2h2(55))
  call Hloop_QZ_A(ntryL,G1H8(59),wf4(:,11),G1H2(39),ngZl,m3h4x2(:,59),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(39),11,nMM,G2H2(45),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H8(60),wf4(:,11),G1H2(42),ngZl,m3h4x2(:,60),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(42),11,nML,G2H2(46),n2h2(57))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,11),G1H2(13),ngZu,m3h4x2(:,61),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(13),11,0,G2H2(47),n2h2(58))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,11),G1H2(14),ngZu,m3h4x2(:,62),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(14),11,nMT,G2H2(48),n2h2(59))
  call Hloop_QZ_A(ntryL,G1H8(63),wf4(:,11),G1H2(17),ngZu,m3h4x2(:,63),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(17),11,0,G2H2(49),n2h2(60))
  call Hloop_QZ_A(ntryL,G1H8(64),wf4(:,11),G1H2(18),ngZu,m3h4x2(:,64),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(18),11,nMT,G2H2(50),n2h2(61))
  call Hloop_AZ_Q(ntryL,G1H8(65),wf4(:,11),G1H2(19),ngZd,m3h4x2(:,65),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(19),11,0,G2H2(51),n2h2(62))
  call Hloop_AZ_Q(ntryL,G1H8(66),wf4(:,11),G1H2(22),ngZd,m3h4x2(:,66),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(22),11,nMB,G2H2(52),n2h2(63))
  call Hloop_QZ_A(ntryL,G1H8(67),wf4(:,11),G1H2(23),ngZd,m3h4x2(:,67),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(23),11,0,G2H2(53),n2h2(64))
  call Hloop_QZ_A(ntryL,G1H8(68),wf4(:,11),G1H2(24),ngZd,m3h4x2(:,68),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(24),11,nMB,G2H2(54),n2h2(65))
  call Hloop_SV_T(ntryL,G1H8(69),8,wf4(:,10),3,G2H2(55),m3h4x2(:,69),heltab2x8(:,:,101))
  call Hloop_TV_S(ntryL,G1H8(70),8,wf4(:,10),3,G2H2(56),m3h4x2(:,70),heltab2x8(:,:,102))
  call Hloop_SV_T(ntryL,G1H8(71),8,wf4(:,11),3,G2H2(57),m3h4x2(:,71),heltab2x8(:,:,103))
  call Hloop_TV_S(ntryL,G1H8(72),8,wf4(:,11),3,G2H2(58),m3h4x2(:,72),heltab2x8(:,:,104))
  call Hloop_DV_C(ntryL,G1H8(75),8,wf4(:,10),G2H2(59),m3h4x2(:,73),heltab2x8(:,:,105))
  call Hloop_CV_D(ntryL,G1H8(76),8,wf4(:,10),3,G2H2(60),m3h4x2(:,74),heltab2x8(:,:,106))
  call Hloop_DV_C(ntryL,G1H8(79),8,wf4(:,11),G2H2(61),m3h4x2(:,75),heltab2x8(:,:,107))
  call Hloop_CV_D(ntryL,G1H8(80),8,wf4(:,11),3,G2H2(62),m3h4x2(:,76),heltab2x8(:,:,108))
  call Hloop_UW_V(ntryL,G1H8(81),8,wf4(:,10),3,G2H2(63),m3h4x2(:,77),heltab2x8(:,:,109))
  call Hloop_UV_W(ntryL,G1H8(82),8,wf4(:,10),3,G2H2(64),m3h4x2(:,78),heltab2x8(:,:,110))
  call Hloop_UW_V(ntryL,G1H8(83),8,wf4(:,11),3,G2H2(65),m3h4x2(:,79),heltab2x8(:,:,111))
  call Hloop_UV_W(ntryL,G1H8(84),8,wf4(:,11),3,G2H2(66),m3h4x2(:,80),heltab2x8(:,:,112))
  call Hloop_VV_S(ntryL,G0H8(13),wf4(:,10),G0H2(3),m3h4x2(:,81),heltab2x8(:,:,113))
  call Hloop_VV_S(ntryL,G0H8(14),wf4(:,10),G0H2(4),m3h4x2(:,82),heltab2x8(:,:,114))
  call Hloop_VV_S(ntryL,G0H8(15),wf4(:,11),G0H2(5),m3h4x2(:,83),heltab2x8(:,:,115))
  call Hloop_VV_S(ntryL,G0H8(16),wf4(:,11),G0H2(6),m3h4x2(:,84),heltab2x8(:,:,116))
  call Hloop_SV_V(ntryL,G1H8(86),wf4(:,10),G1H2(27),m3h4x2(:,85),heltab2x8(:,:,117))
  call Hloop_SV_V(ntryL,G1H8(88),wf4(:,11),G1H2(28),m3h4x2(:,86),heltab2x8(:,:,118))
  call Hloop_SV_T(ntryL,G0H8(17),8,wf4(:,10),3,G1H2(29),m3h4x2(:,87),heltab2x8(:,:,119))
  call Hloop_TV_S(ntryL,G0H8(18),8,wf4(:,10),3,G1H2(32),m3h4x2(:,88),heltab2x8(:,:,120))
  call Hloop_SV_T(ntryL,G0H8(19),8,wf4(:,11),3,G1H2(33),m3h4x2(:,89),heltab2x8(:,:,121))
  call Hloop_TV_S(ntryL,G0H8(20),8,wf4(:,11),3,G1H2(34),m3h4x2(:,90),heltab2x8(:,:,122))
  call Hloop_UW_V(ntryL,G0H8(21),8,wf4(:,10),3,G1H2(37),m3h4x2(:,91),heltab2x8(:,:,123))
  call Hloop_UV_W(ntryL,G0H8(22),8,wf4(:,10),3,G1H2(38),m3h4x2(:,92),heltab2x8(:,:,124))
  call Hloop_UW_V(ntryL,G0H8(23),8,wf4(:,11),3,G1H2(39),m3h4x2(:,93),heltab2x8(:,:,125))
  call Hloop_UV_W(ntryL,G0H8(24),8,wf4(:,11),3,G1H2(42),m3h4x2(:,94),heltab2x8(:,:,126))
  call Hloop_VV_S(ntryL,G1H8(90),wf4(:,10),G1H2(13),m3h4x2(:,95),heltab2x8(:,:,127))
  call Hloop_VV_S(ntryL,G1H8(92),wf4(:,11),G1H2(14),m3h4x2(:,96),heltab2x8(:,:,128))
  call Hloop_SV_V(ntryL,G0H8(25),wf4(:,10),G0H2(7),m3h4x2(:,97),heltab2x8(:,:,129))
  call Hloop_SV_V(ntryL,G0H8(26),wf4(:,10),G0H2(8),m3h4x2(:,98),heltab2x8(:,:,130))
  call Hloop_SV_V(ntryL,G0H8(27),wf4(:,11),G0H2(9),m3h4x2(:,99),heltab2x8(:,:,131))
  call Hloop_SV_V(ntryL,G0H8(28),wf4(:,11),G0H2(10),m3h4x2(:,100),heltab2x8(:,:,132))
  call Hloop_QA_S(ntryL,G1H8(93),ex2(:),G1H4(18),ngH,m3h2x4(:,33),heltab2x8(:,:,133))
  call Hloop_QA_S(ntryL,G1H8(94),ex2(:),G1H4(20),ngX,m3h2x4(:,34),heltab2x8(:,:,134))
  call Hloop_QA_S(ntryL,G1H8(95),ex2(:),G1H4(21),ngPln,m3h2x4(:,35),heltab2x8(:,:,135))
  call Hloop_SA_Q(ntryL,G1H8(96),ex2(:),G1H4(22),ngH,m3h2x4(:,36),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(22),10,nME,G2H4(1),n2h4(31))
  call Hloop_SA_Q(ntryL,G1H8(97),ex2(:),G1H4(6),ngX,m3h2x4(:,37),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(6),10,nME,G2H4(3),n2h4(32))
  call Hloop_SA_Q(ntryL,G1H8(98),ex2(:),G1H4(5),ngPln,m3h2x4(:,38),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(5),10,0,G2H4(2),n2h4(33))
  call Hloop_QA_V(ntryL,G1H8(99),ex2(:),G1H4(7),m3h2x4(:,39),heltab2x8(:,:,139))
  call Hloop_QA_Z(ntryL,G1H8(100),ex2(:),G1H4(14),ngZl,m3h2x4(:,40),heltab2x8(:,:,140))
  call Hloop_QA_W(ntryL,G1H8(101),ex2(:),G1H4(13),m3h2x4(:,41),heltab2x8(:,:,141))
  call Hloop_SA_Q(ntryL,G0H8(29),ex2(:),G0H4(11),ngH,m3h2x4(:,42),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G0H4(11),10,nME,G1H4(16),n2h4(34))
  call Hloop_SA_Q(ntryL,G0H8(30),ex2(:),G0H4(1),ngPln,m3h2x4(:,43),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(19),n2h4(35))
  call Hloop_ZA_Q(ntryL,G0H8(31),ex2(:),G0H4(2),ngZl,m3h2x4(:,44),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G0H4(2),10,nME,G1H4(1),n2h4(36))
  call Hloop_WA_Q(ntryL,G0H8(32),ex2(:),G0H4(11),m3h2x4(:,45),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G0H4(11),10,0,G1H4(8),n2h4(37))
  call Hloop_WA_Q(ntryL,G1H8(102),ex2(:),G1H4(15),m3h2x4(:,46),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(15),10,0,G2H4(4),n2h4(38))
  call Hloop_AQ_S(ntryL,G1H8(103),ex1(:),G1H4(22),ngH,m3h2x4(:,47),heltab2x8(:,:,147))
  call Hloop_AQ_S(ntryL,G1H8(104),ex1(:),G1H4(6),ngX,m3h2x4(:,48),heltab2x8(:,:,148))
  call Hloop_AQ_S(ntryL,G1H8(105),ex1(:),G1H4(5),ngPnl,m3h2x4(:,49),heltab2x8(:,:,149))
  call Hloop_SQ_A(ntryL,G1H8(106),ex1(:),G1H4(15),ngH,m3h2x4(:,50),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(15),9,nME,G2H4(5),n2h4(39))
  call Hloop_SQ_A(ntryL,G1H8(107),ex1(:),G1H4(15),ngX,m3h2x4(:,51),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(15),9,nME,G2H4(7),n2h4(40))
  call Hloop_SQ_A(ntryL,G1H8(108),ex1(:),G1H4(15),ngPnl,m3h2x4(:,52),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(15),9,0,G2H4(6),n2h4(41))
  call Hloop_AQ_V(ntryL,G1H8(109),ex1(:),G1H4(15),m3h2x4(:,53),heltab2x8(:,:,153))
  call Hloop_AQ_Z(ntryL,G1H8(110),ex1(:),G1H4(23),ngZl,m3h2x4(:,54),heltab2x8(:,:,154))
  call Hloop_AQ_W(ntryL,G1H8(111),ex1(:),G1H4(24),m3h2x4(:,55),heltab2x8(:,:,155))
  call Hloop_SQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),ngH,m3h2x4(:,56),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(25),n2h4(42))
  call Hloop_SQ_A(ntryL,G0H8(34),ex1(:),G0H4(2),ngPnl,m3h2x4(:,57),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G0H4(2),9,0,G1H4(26),n2h4(43))
  call Hloop_ZQ_A(ntryL,G0H8(35),ex1(:),G0H4(11),ngZl,m3h2x4(:,58),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G0H4(11),9,nME,G1H4(27),n2h4(44))
  call Hloop_WQ_A(ntryL,G0H8(36),ex1(:),G0H4(1),m3h2x4(:,59),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(28),n2h4(45))
  call Hloop_WQ_A(ntryL,G1H8(112),ex1(:),G1H4(29),m3h2x4(:,60),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(29),9,0,G2H4(8),n2h4(46))
  call Hloop_SA_Q(ntryL,G0H4(3),ex2(:),G0H2(11),ngH,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G0H2(11),11,nME,G1H2(17),n2h2(66))
  call Hloop_SA_Q(ntryL,G0H4(4),ex2(:),G0H2(11),ngX,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G0H2(11),11,nME,G1H2(18),n2h2(67))
  call Hloop_QA_S(ntryL,G1H4(2),ex2(:),G1H2(19),ngPln,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VA_Q(ntryL,G0H4(5),ex2(:),G0H2(11),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G0H2(11),11,nME,G1H2(22),n2h2(68))
  call Hloop_ZA_Q(ntryL,G0H4(6),ex2(:),G0H2(11),ngZl,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G0H2(11),11,nME,G1H2(23),n2h2(69))
  call Hloop_QA_S(ntryL,G1H4(3),ex2(:),G1H2(24),ngPln,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_W(ntryL,G1H4(4),ex2(:),G1H2(63),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_W(ntryL,G1H4(9),ex2(:),G1H2(64),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_SQ_A(ntryL,G0H4(7),ex1(:),G0H2(11),ngH,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G0H2(11),11,nME,G1H2(65),n2h2(70))
  call Hloop_SQ_A(ntryL,G0H4(8),ex1(:),G0H2(11),ngX,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G0H2(11),11,nME,G1H2(66),n2h2(71))
  call Hloop_AQ_S(ntryL,G1H4(10),ex1(:),G1H2(67),ngPnl,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G0H4(9),ex1(:),G0H2(11),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G0H2(11),11,nME,G1H2(68),n2h2(72))
  call Hloop_ZQ_A(ntryL,G0H4(10),ex1(:),G0H2(11),ngZl,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G0H2(11),11,nME,G1H2(69),n2h2(73))
  call Hloop_AQ_S(ntryL,G1H4(11),ex1(:),G1H2(70),ngPnl,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_W(ntryL,G1H4(12),ex1(:),G1H2(71),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_W(ntryL,G1H4(17),ex1(:),G1H2(72),m3h2x2(:,49),heltab2x4(:,:,49))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(1)])
call HGT_OLR(G1H2(3),1,1,2)
call HGT_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(66),G1H2(10)])
call HGT_OLR(G1H2(4),1,1,2)
call HGT_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(32),G2H2(16),G2H2(4),G1H2(21),G1H2(11) &
    ,G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(67),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(56),G1H2(62),G1H2(58),G1H2(44),G1H2(16),G0H2(6) &
    ,G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(68),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(64),G1H2(12),G1H2(2),G1H2(54),G1H2(26),G0H2(10) &
    ,G0H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(29),G2H2(12),G2H2(1),G1H2(46),G1H2(36) &
    ,G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(18),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(55),G1H2(59),G1H2(57),G1H2(43),G1H2(41),G0H2(5) &
    ,G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(63),G1H2(9),G1H2(5),G1H2(53),G1H2(51),G0H2(9) &
    ,G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(30),G2H2(14),G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G2H2(31),G2H2(15),G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(33),G2H2(17),G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(34),G2H2(18),G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(36),G2H2(19),G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(38),G2H2(20),G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(39),G2H2(22),G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(40),G2H2(23),G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(59),G1H2(49),G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(60),G1H2(52),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(25),G1H2(42),G1H2(39),G1H2(38),G1H2(37) &
    ,G1H2(28),G1H2(27),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(27),G1H2(14),G1H2(13),G1H2(34),G1H2(33) &
    ,G1H2(32),G1H2(29),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(47),G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(49),G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(26)])
  call Hloop_QV_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(16),n2h1(29))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(21),ex2(:),G2tensor(2),ngX,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hloop_QV_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(1),n2h1(30))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(24),ex2(:),G2tensor(31),ngH,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hloop_QV_A(ntryL,G2H2(44),ex3(:),G2H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nME,G3tensor(1),n2h1(31))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(67),11,ex3(:),4,G2tensor(4),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(58),11,ex3(:),4,G3tensor(2),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hloop_QV_A(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(3),n2h1(32))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(72),11,ex3(:),4,G2tensor(5),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(66),11,ex3(:),4,G3tensor(3),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hloop_AV_Q(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(40),n2h1(33))
  call Hloop_AV_Q(ntryL,G2H2(41),ex3(:),G2H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nME,G3tensor(4),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(22),n2h1(35))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(19),11,ex3(:),4,G2tensor(37),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(57),11,ex3(:),4,G3tensor(5),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hloop_AV_Q(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(6),n2h1(36))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(64),11,ex3(:),4,G2tensor(8),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(65),11,ex3(:),4,G3tensor(6),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hloop_SA_Q(ntryL,G1H2(55),ex2(:),G1H1(1),ngPln,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(10),n2h1(37))
  call Hloop_SA_Q(ntryL,G1H2(56),ex2(:),G1H1(1),ngPln,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(13),n2h1(38))
  call Hloop_WA_Q(ntryL,G1H2(60),ex2(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(19),n2h1(39))
  call Hloop_WA_Q(ntryL,G1H2(61),ex2(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(25),n2h1(40))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(28),ngX,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(34),ngH,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H2(7),ex2(:),G1tensor(1),ngPln,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H2(8),ex2(:),G1tensor(6),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hloop_AV_Q(ntryL,G2H2(42),ex3(:),G2H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(7),n2h1(41))
  call Hloop_AV_Q(ntryL,G2H2(43),ex3(:),G2H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nML,G3tensor(8),n2h1(42))
  call Hloop_QV_A(ntryL,G2H2(45),ex3(:),G2H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(9),n2h1(43))
  call Hloop_QV_A(ntryL,G2H2(46),ex3(:),G2H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nML,G3tensor(10),n2h1(44))
  call Hloop_AV_Q(ntryL,G2H2(48),ex3(:),G2H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(11),n2h1(45))
  call Hloop_QV_A(ntryL,G2H2(50),ex3(:),G2H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(12),n2h1(46))
  call Hloop_AV_Q(ntryL,G2H2(52),ex3(:),G2H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(13),n2h1(47))
  call Hloop_QV_A(ntryL,G2H2(54),ex3(:),G2H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(14),n2h1(48))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(61),11,ex3(:),G3tensor(15),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(62),11,ex3(:),4,G3tensor(16),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(43),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(28),ex3(:),G2tensor(46),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hloop_AV_Q(ntryL,G2H2(51),ex3(:),G2H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(17),n2h1(49))
  call Hloop_QV_A(ntryL,G2H2(53),ex3(:),G2H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(18),n2h1(50))
  call Hloop_SQ_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),ngH,m3h4x1(:,1),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(47),n2h1(51))
  call Hloop_SQ_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),ngX,m3h4x1(:,2),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(48),n2h1(52))
  call Hloop_SQ_A(ntryL,G1H4(21),wf4(:,2),G1H1(1),ngPnl,m3h4x1(:,3),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(49),n2h1(53))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(1),wf4(:,2),G2tensor(50),ngX,m3h4x1(:,4),heltab2x4(:,:,53))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(3),wf4(:,2),G2tensor(51),ngH,m3h4x1(:,5),heltab2x4(:,:,54))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(2),wf4(:,2),G2tensor(52),ngPnl,m3h4x1(:,6),heltab2x4(:,:,55))
  call Hloop_VQ_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(53),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H4(14),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,8),heltab2x4(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(54),n2h1(55))
  call Hloop_WQ_A(ntryL,G1H4(13),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(55),n2h1(56))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(16),wf4(:,2),G1tensor(11),ngZl,m3h4x1(:,10),heltab2x4(:,:,59))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(4),wf4(:,2),G2tensor(56),m3h4x1(:,11),heltab2x4(:,:,60))
  call Hloop_SA_Q(ntryL,G1H4(22),wf4(:,6),G1H1(1),ngH,m3h4x1(:,12),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(57),n2h1(57))
  call Hloop_SA_Q(ntryL,G1H4(6),wf4(:,6),G1H1(1),ngX,m3h4x1(:,13),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(58),n2h1(58))
  call Hloop_SA_Q(ntryL,G1H4(5),wf4(:,6),G1H1(1),ngPln,m3h4x1(:,14),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(59),n2h1(59))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(5),wf4(:,6),G2tensor(60),ngX,m3h4x1(:,15),heltab2x4(:,:,64))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(7),wf4(:,6),G2tensor(61),ngH,m3h4x1(:,16),heltab2x4(:,:,65))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(6),wf4(:,6),G2tensor(62),ngPln,m3h4x1(:,17),heltab2x4(:,:,66))
  call Hloop_VA_Q(ntryL,G1H4(15),wf4(:,6),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(63),n2h1(60))
  call Hloop_ZA_Q(ntryL,G1H4(23),wf4(:,6),G1H1(1),ngZl,m3h4x1(:,19),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(64),n2h1(61))
  call Hloop_WA_Q(ntryL,G1H4(24),wf4(:,6),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(65),n2h1(62))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(25),wf4(:,6),G1tensor(16),ngZl,m3h4x1(:,21),heltab2x4(:,:,70))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(8),wf4(:,6),G2tensor(66),m3h4x1(:,22),heltab2x4(:,:,71))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(24),ex3(:),G1tensor(21),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(63),ex3(:),G1tensor(26),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(70),ex3(:),G1tensor(31),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(71),ex3(:),G1tensor(36),m3h2x1(:,89),heltab2x2(:,:,89))
  call ol_merge_tensors(G2tensor(60),[G2tensor(7),G1tensor(16),G1tensor(15),G0tensor(15)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(9),G1tensor(20),G0tensor(20)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(22),G0tensor(22)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(12),G1tensor(25),G0tensor(25)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(27),G0tensor(27)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(48),G2tensor(15),G1tensor(30),G0tensor(30)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(17),G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(52),G2tensor(24),G2tensor(18),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(32),G0tensor(32)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(21),G1tensor(35),G0tensor(35)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(37),G0tensor(37)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(27),G1tensor(40),G0tensor(40)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(42),G0tensor(42)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(58),G2tensor(30),G1tensor(45),G0tensor(45)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(32),G1tensor(6),G1tensor(1),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(62),G2tensor(39),G2tensor(33),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(47),G0tensor(47)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(36),G1tensor(50),G0tensor(50)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(4),G2tensor(44),G2tensor(41),G1tensor(36),G1tensor(31),G1tensor(52),G1tensor(3) &
    ,G0tensor(52),G0tensor(3)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(59),G2tensor(45),G2tensor(42),G1tensor(55),G0tensor(55)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(6),G3tensor(5),G3tensor(3),G3tensor(2),G2tensor(46),G2tensor(43) &
    ,G1tensor(9),G1tensor(4),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(37),G1tensor(26),G1tensor(21),G1tensor(8),G0tensor(8)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(23),G1tensor(12),G0tensor(23),G0tensor(12)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(13),G0tensor(13)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(14),G0tensor(14)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(28),G1tensor(17),G0tensor(28),G0tensor(17)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(18),G0tensor(18)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(19),G0tensor(19)])
  call ol_merge_tensors(G3tensor(4),[G3tensor(1),G1tensor(49),G1tensor(44),G1tensor(39),G1tensor(34),G1tensor(29),G1tensor(24) &
    ,G0tensor(49),G0tensor(44),G0tensor(39),G0tensor(34),G0tensor(29),G0tensor(24)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(33),G0tensor(33)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(38),G0tensor(38)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(43),G0tensor(43)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(10),G1tensor(53),G0tensor(53)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(13),G1tensor(54),G0tensor(54)])
  call ol_merge_tensors(G3tensor(9),[G3tensor(7)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(8)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(13)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(49)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(11)])
  call TI_triangle_red(G2tensor(60),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11), &
    G0tensor(16),M2L1R1,[nMZ,nMH,nME],G0tensor(21),G0tensor(26),G0tensor(31))
  call TI_triangle_red(G2tensor(61),RedBasis(1),mass3set(:,2),G0tensor(36),G0tensor(41),G0tensor(46), &
    G0tensor(51),M2L1R1,[nMH,nMZ,nME],G0tensor(15),G0tensor(20),G0tensor(22))
  call TI_triangle_red(G2tensor(11),RedBasis(8),mass3set(:,3),G0tensor(25),G0tensor(27),G0tensor(30),G0tensor(2),M2L1R1,[nME,nMH], &
    G0tensor(5),G0tensor(32))
  call TI_triangle_red(G2tensor(47),RedBasis(4),mass3set(:,3),G0tensor(35),G0tensor(37),G0tensor(40), &
    G0tensor(42),M2L1R1,[nME,nMH],G0tensor(45),G0tensor(7))
  call TI_triangle_red(G2tensor(14),RedBasis(8),mass3set(:,4),G0tensor(10),G0tensor(47),G0tensor(50), &
    G0tensor(52),M2L1R1,[nME,nMZ],G0tensor(3),G0tensor(55))
  call TI_triangle_red(G2tensor(54),RedBasis(4),mass3set(:,4),G0tensor(9),G0tensor(4),G0tensor(8),G0tensor(23),M2L1R1,[nME,nMZ], &
    G0tensor(12),G0tensor(13))
  call TI_triangle_red(G2tensor(23),RedBasis(8),mass3set(:,5),G0tensor(14),G0tensor(28),G0tensor(17),G0tensor(18),M2L1R1,[nMW], &
    G0tensor(19))
  call TI_triangle_red(G2tensor(56),RedBasis(4),mass3set(:,5),G0tensor(49),G0tensor(44),G0tensor(39),G0tensor(34),M2L1R1,[nMW], &
    G0tensor(29))
  call TI_triangle_red(G2tensor(20),RedBasis(8),mass3set(:,6),G0tensor(24),G0tensor(33),G0tensor(38),G0tensor(43),M2L1R1,[nME], &
    G0tensor(48))
  call TI_triangle_red(G2tensor(53),RedBasis(4),mass3set(:,6),G0tensor(53),G0tensor(54),G0tensor(56),G0tensor(57),M2L1R1,[nME], &
    G0tensor(58))
  call TI_triangle_red(G2tensor(26),RedBasis(9),mass3set(:,3),G0tensor(59),G0tensor(60),G0tensor(61), &
    G0tensor(62),M2L1R1,[nME,nMH],G0tensor(63),G0tensor(64))
  call TI_triangle_red(G2tensor(57),RedBasis(1),mass3set(:,3),G0tensor(65),G0tensor(66),G0tensor(67), &
    G0tensor(68),M2L1R1,[nME,nMH],G0tensor(69),G0tensor(70))
  call TI_triangle_red(G2tensor(29),RedBasis(9),mass3set(:,4),G0tensor(71),G0tensor(72),G0tensor(73), &
    G0tensor(74),M2L1R1,[nME,nMZ],G0tensor(75),G0tensor(76))
  call TI_triangle_red(G2tensor(64),RedBasis(1),mass3set(:,4),G0tensor(77),G0tensor(78),G0tensor(79), &
    G0tensor(80),M2L1R1,[nME,nMZ],G0tensor(81),G0tensor(82))
  call TI_triangle_red(G2tensor(38),RedBasis(9),mass3set(:,5),G0tensor(83),G0tensor(84),G0tensor(85),G0tensor(86),M2L1R1,[nMW], &
    G0tensor(87))
  call TI_triangle_red(G2tensor(66),RedBasis(1),mass3set(:,5),G0tensor(88),G0tensor(89),G0tensor(90),G0tensor(91),M2L1R1,[nMW], &
    G0tensor(92))
  call TI_triangle_red(G2tensor(35),RedBasis(9),mass3set(:,6),G0tensor(93),G0tensor(94),G0tensor(95),G0tensor(96),M2L1R1,[nME], &
    G0tensor(97))
  call TI_triangle_red(G2tensor(63),RedBasis(1),mass3set(:,6),G0tensor(98),G0tensor(99),G0tensor(100),G0tensor(101),M2L1R1,[nME], &
    G0tensor(102))
  call TI_triangle_red(G2tensor(5),RedBasis(6),mass3set(:,7),G0tensor(103),G0tensor(104),G0tensor(105),G0tensor(106),M2L1R1,[nMW], &
    G0tensor(107))
  call TI_triangle_red(G2tensor(65),RedBasis(1),mass3set(:,8),G0tensor(108),G0tensor(109),G0tensor(110), &
    G0tensor(111),M2L1R1,[nMW],G0tensor(112))
  call TI_triangle_red(G3tensor(16),RedBasis(5),mass3set(:,9),G0tensor(113),G0tensor(114),G0tensor(115), &
    G0tensor(116),M2L1R1,[nMW],G0tensor(117))
  call TI_triangle_red(G2tensor(8),RedBasis(7),mass3set(:,7),G0tensor(118),G0tensor(119),G0tensor(120),G0tensor(121),M2L1R1,[nMW], &
    G0tensor(122))
  call TI_triangle_red(G2tensor(16),RedBasis(6),mass3set(:,10),G0tensor(123),G0tensor(124),G0tensor(125), &
    G0tensor(126),M2L1R1,[nME,nMH],G0tensor(127),G0tensor(128))
  call TI_triangle_red(G2tensor(28),RedBasis(3),mass3set(:,11),G0tensor(129),G0tensor(130),G0tensor(131), &
    G0tensor(132),M2L1R1,[nMZ,nME],G0tensor(133),G0tensor(134))
  call TI_triangle_red(G2tensor(2),RedBasis(2),mass3set(:,1),G0tensor(135),G0tensor(136),G0tensor(137), &
    G0tensor(138),M2L1R1,[nMZ,nMH,nME],G0tensor(139),G0tensor(140),G0tensor(141))
  call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,12),G0tensor(142),G0tensor(143),G0tensor(144), &
    G0tensor(145),M2L1R1,[nME,nMZ],G0tensor(146),G0tensor(147))
  call TI_triangle_red(G2tensor(34),RedBasis(3),mass3set(:,13),G0tensor(148),G0tensor(149),G0tensor(150), &
    G0tensor(151),M2L1R1,[nMH,nME],G0tensor(152),G0tensor(153))
  call TI_triangle_red(G2tensor(31),RedBasis(2),mass3set(:,2),G0tensor(154),G0tensor(155),G0tensor(156), &
    G0tensor(157),M2L1R1,[nMH,nMZ,nME],G0tensor(158),G0tensor(159),G0tensor(160))
  call TI_triangle_red(G3tensor(4),RedBasis(5),mass3set(:,14),G0tensor(161),G0tensor(162),G0tensor(163), &
    G0tensor(164),M2L1R1,[nME],G0tensor(165))
  call TI_triangle_red(G2tensor(3),RedBasis(6),mass3set(:,15),G0tensor(166),G0tensor(167),G0tensor(168), &
    G0tensor(169),M2L1R1,[nME],G0tensor(170))
  call TI_triangle_red(G2tensor(40),RedBasis(7),mass3set(:,10),G0tensor(171),G0tensor(172),G0tensor(173), &
    G0tensor(174),M2L1R1,[nME,nMH],G0tensor(175),G0tensor(176))
  call TI_triangle_red(G2tensor(22),RedBasis(7),mass3set(:,12),G0tensor(177),G0tensor(178),G0tensor(179), &
    G0tensor(180),M2L1R1,[nME,nMZ],G0tensor(181),G0tensor(182))
  call TI_triangle_red(G2tensor(6),RedBasis(7),mass3set(:,15),G0tensor(183),G0tensor(184),G0tensor(185), &
    G0tensor(186),M2L1R1,[nME],G0tensor(187))
  call TI_triangle_red(G2tensor(19),RedBasis(3),mass3set(:,16),G0tensor(188),G0tensor(189),G0tensor(190), &
    G0tensor(191),M2L1R1,[nMW],G0tensor(192))
  call TI_triangle_red(G2tensor(25),RedBasis(2),mass3set(:,8),G0tensor(193),G0tensor(194),G0tensor(195), &
    G0tensor(196),M2L1R1,[nMW],G0tensor(197))
  call TI_triangle_red(G3tensor(9),RedBasis(5),mass3set(:,17),G0tensor(198),G0tensor(199),G0tensor(200), &
    G0tensor(201),M2L1R1,[nMM],G0tensor(202))
  call TI_triangle_red(G3tensor(10),RedBasis(5),mass3set(:,18),G0tensor(203),G0tensor(204),G0tensor(205), &
    G0tensor(206),M2L1R1,[nML],G0tensor(207))
  call TI_triangle_red(G3tensor(12),RedBasis(5),mass3set(:,19),G0tensor(208),G0tensor(209),G0tensor(210), &
    G0tensor(211),M2L1R1,[nMT],G0tensor(212))
  call TI_triangle_red(G3tensor(14),RedBasis(5),mass3set(:,20),G0tensor(213),G0tensor(214),G0tensor(215), &
    G0tensor(216),M2L1R1,[nMB],G0tensor(217))
  call TI_triangle_red(G3tensor(18),RedBasis(5),mass3set(:,21),G0tensor(218),G0tensor(219),G0tensor(220),G0tensor(221),M2L1R1)
  call TI_triangle_red(G2tensor(55),RedBasis(4),mass3set(:,8),G0tensor(222),G0tensor(223),G0tensor(224), &
    G0tensor(225),M2L1R1,[nMW],G0tensor(226))
  call TI_triangle_red(G2tensor(50),RedBasis(4),mass3set(:,1),G0tensor(227),G0tensor(228),G0tensor(229), &
    G0tensor(230),M2L1R1,[nMZ,nMH,nME],G0tensor(231),G0tensor(232),G0tensor(233))
  call TI_triangle_red(G2tensor(51),RedBasis(4),mass3set(:,2),G0tensor(234),G0tensor(235),G0tensor(236), &
    G0tensor(237),M2L1R1,[nMH,nMZ,nME],G0tensor(238),G0tensor(239),G0tensor(240))
  call ol_merge_tensors(T0sum(12),[G0tensor(1)])
  call ol_merge_tensors(T0sum(13),[G0tensor(36)])
  call ol_merge_tensors(T0sum(14),[G0tensor(25)])
  call ol_merge_tensors(T0sum(15),[G0tensor(35)])
  call ol_merge_tensors(T0sum(16),[G0tensor(10)])
  call ol_merge_tensors(T0sum(17),[G0tensor(9)])
  call ol_merge_tensors(T0sum(18),[G0tensor(14)])
  call ol_merge_tensors(T0sum(19),[G0tensor(49)])
  call ol_merge_tensors(T0sum(20),[G0tensor(24)])
  call ol_merge_tensors(T0sum(21),[G0tensor(53)])
  call ol_merge_tensors(T0sum(22),[G0tensor(59)])
  call ol_merge_tensors(T0sum(23),[G0tensor(65)])
  call ol_merge_tensors(T0sum(24),[G0tensor(71)])
  call ol_merge_tensors(T0sum(25),[G0tensor(77)])
  call ol_merge_tensors(T0sum(26),[G0tensor(83)])
  call ol_merge_tensors(T0sum(27),[G0tensor(88)])
  call ol_merge_tensors(T0sum(28),[G0tensor(93)])
  call ol_merge_tensors(T0sum(29),[G0tensor(98)])
  call ol_merge_tensors(T0sum(30),[G0tensor(103)])
  call ol_merge_tensors(T0sum(31),[G0tensor(108)])
  call ol_merge_tensors(T0sum(32),[G0tensor(113)])
  call ol_merge_tensors(T0sum(33),[G0tensor(118)])
  call ol_merge_tensors(T0sum(34),[G0tensor(123)])
  call ol_merge_tensors(T0sum(35),[G0tensor(129)])
  call ol_merge_tensors(T0sum(36),[G0tensor(135)])
  call ol_merge_tensors(T0sum(37),[G0tensor(142)])
  call ol_merge_tensors(T0sum(38),[G0tensor(148)])
  call ol_merge_tensors(T0sum(39),[G0tensor(154)])
  call ol_merge_tensors(T0sum(40),[G0tensor(161)])
  call ol_merge_tensors(T0sum(41),[G0tensor(166)])
  call ol_merge_tensors(T0sum(42),[G0tensor(171)])
  call ol_merge_tensors(T0sum(43),[G0tensor(177)])
  call ol_merge_tensors(T0sum(44),[G0tensor(183)])
  call ol_merge_tensors(T0sum(45),[G0tensor(188)])
  call ol_merge_tensors(T0sum(46),[G0tensor(193)])
  call ol_merge_tensors(T0sum(47),[G0tensor(198)])
  call ol_merge_tensors(T0sum(48),[G0tensor(203)])
  call ol_merge_tensors(T0sum(49),[G0tensor(208)])
  call ol_merge_tensors(T0sum(50),[G0tensor(213)])
  call ol_merge_tensors(T0sum(51),[G0tensor(218)])
  call ol_merge_tensors(T0sum(52),[G0tensor(222)])
  call ol_merge_tensors(T0sum(53),[G0tensor(227)])
  call ol_merge_tensors(T0sum(54),[G0tensor(234)])
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(199),h0tab(:,199),[11,4],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf4(:,4),G0H2(11),m4h3x4x2(:,1),heltab3x24(:,:,3))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(200),h0tab(:,200),[11,4],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf4(:,4),G0H2(6),m4h3x4x2(:,2),heltab3x24(:,:,4))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(201),h0tab(:,201),[11,4],[nMW,nMW],3,1,wf4(:,9))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf4(:,9),G0H2(4),m4h3x4x2(:,3),heltab3x24(:,:,5))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(202),h0tab(:,202),[11,4],[nMW,nMW],3,1,wf4(:,9))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf4(:,9),G0H2(10),m4h3x4x2(:,4),heltab3x24(:,:,6))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(203),h0tab(:,203),[11,4],[nMW,nMW],3,1,wf4(:,10))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf4(:,10),G0H2(8),m4h3x4x2(:,5),heltab3x24(:,:,7))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(204),h0tab(:,204),[11,4],[nMW,nMW],3,1,wf4(:,11))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf4(:,11),G0H2(5),m4h3x4x2(:,6),heltab3x24(:,:,8))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(205),h0tab(:,205),[11,4],[nMW,nMW],3,1,wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf4(:,10),G0H2(3),m4h3x4x2(:,7),heltab3x24(:,:,9))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(206),h0tab(:,206),[11,4],[nMW,nMW],3,1,wf4(:,11))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf4(:,11),G0H2(9),m4h3x4x2(:,8),heltab3x24(:,:,10))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(207),h0tab(:,207),[8,7],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(2),m3h3x8(:,181),heltab2x24(:,:,197))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(208),h0tab(:,208),[8,7],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(4),m3h3x8(:,182),heltab2x24(:,:,198))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(209),h0tab(:,209),[8,7],[nMW,nMW],3,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(9),m3h3x8(:,183),heltab2x24(:,:,199))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(210),h0tab(:,210),[8,7],[nMW,nMW],3,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H24(1),ex4(:),G0H8(10),m3h3x8(:,184),heltab2x24(:,:,200))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(211),h0tab(:,211),[8,7],[nMW,nMW],3,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(23),m3h3x8(:,185),heltab2x24(:,:,201))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(212),h0tab(:,212),[8,7],[nMW,nMW],3,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex4(:),8,G1H8(24),m3h3x8(:,186),heltab2x24(:,:,202))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(213),h0tab(:,213),[8,7],[nMW,nMW],3,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(27),m3h3x8(:,187),heltab2x24(:,:,203))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(214),h0tab(:,214),[8,7],[nMW,nMW],3,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H8(28),m3h3x8(:,188),heltab2x24(:,:,204))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(215),h0tab(:,215),[12,3],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(2),m4h3x2x4(:,3),heltab3x24(:,:,11))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(216),h0tab(:,216),[12,3],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(11),m4h3x2x4(:,4),heltab3x24(:,:,12))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(217),h0tab(:,217),[12,3],[nMW,nMW],3,1,wf4(:,10))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(1),m4h3x2x4(:,5),heltab3x24(:,:,13))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(218),h0tab(:,218),[12,3],[nMW,nMW],3,1,wf4(:,11))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(3),m4h3x2x4(:,6),heltab3x24(:,:,14))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(219),h0tab(:,219),[12,3],[nMW,nMW],3,1,wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(4),m4h3x2x4(:,7),heltab3x24(:,:,15))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(220),h0tab(:,220),[12,3],[nMW,nMW],3,1,wf4(:,11))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),ex3(:),G0H4(5),m4h3x2x4(:,8),heltab3x24(:,:,16))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(221),h0tab(:,221),[10,5],[nME,nMH],2,2,wf6(:,7),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(6),ngH,m3h6x4(:,17),heltab2x24(:,:,205))
  call Hloop_A_Q(ntryL,G0H4(6),10,nME,G1H4(29),n2h4(47))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(222),h0tab(:,222),[10,5],[nME,nMZ],2,2,wf6(:,7),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(7),ngX,m3h6x4(:,18),heltab2x24(:,:,206))
  call Hloop_A_Q(ntryL,G0H4(7),10,nME,G1H4(2),n2h4(48))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(223),h0tab(:,223),[10,5],[0,nMW],2,2,wf6(:,7),wf4(:,2))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(8),ngPln,m3h6x4(:,19),heltab2x24(:,:,207))
  call Hloop_A_Q(ntryL,G0H4(8),10,0,G1H4(3),n2h4(49))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(224),h0tab(:,224),[10,5],[nME,0],2,2,wf6(:,7),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(9),m3h6x4(:,20),heltab2x24(:,:,208))
  call Hloop_A_Q(ntryL,G0H4(9),10,nME,G1H4(4),n2h4(50))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(225),h0tab(:,225),[10,5],[nME,nMZ],2,2,wf6(:,7),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(10),ngZl,m3h6x4(:,21),heltab2x24(:,:,209))
  call Hloop_A_Q(ntryL,G0H4(10),10,nME,G1H4(9),n2h4(51))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(226),h0tab(:,226),[10,5],[0,nMW],2,2,wf6(:,7),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,7),G0H4(6),m3h6x4(:,22),heltab2x24(:,:,210))
  call Hloop_A_Q(ntryL,G0H4(6),10,0,G1H4(10),n2h4(52))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(227),h0tab(:,227),[9,6],[nMH,nME],2,2,wf6(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,3),G0H4(7),ngH,m3h6x4(:,23),heltab2x24(:,:,211))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(228),h0tab(:,228),[9,6],[nMZ,nME],2,2,wf6(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,3),G0H4(8),ngX,m3h6x4(:,24),heltab2x24(:,:,212))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(229),h0tab(:,229),[9,6],[nMW,0],2,2,wf6(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,3),G0H4(9),ngPnl,m3h6x4(:,25),heltab2x24(:,:,213))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(230),h0tab(:,230),[9,6],[0,nME],2,2,wf6(:,3),wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,3),G0H4(10),m3h6x4(:,26),heltab2x24(:,:,214))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(231),h0tab(:,231),[9,6],[nMZ,nME],2,2,wf6(:,3),wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,3),G0H4(6),ngZl,m3h6x4(:,27),heltab2x24(:,:,215))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(232),h0tab(:,232),[9,6],[nMW,0],2,2,wf6(:,3),wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,3),G0H4(12),m3h6x4(:,28),heltab2x24(:,:,216))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(10),[G0H2(4),G0H2(6),G0H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(5),[G0H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(9),[G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(10),[G0H8(9)])
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(10),ex3(:),G0tensor(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(5),11,ex3(:),4,G1tensor(41),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(9),11,ex3(:),4,G1tensor(46),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(4),ex3(:),wf4(:,4),G0tensor(36),m4h2x4x1(:,1),heltab3x8(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(10),ex3(:),wf4(:,9),G0tensor(25),m4h2x4x1(:,2),heltab3x8(:,:,2))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(23),ex3(:),wf4(:,10),G1tensor(51),m4h2x4x1(:,3),heltab3x8(:,:,3))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(24),ex3(:),wf4(:,11),G1tensor(16),m4h2x4x1(:,4),heltab3x8(:,:,4))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(27),ex3(:),wf4(:,10),G1tensor(15),m4h2x4x1(:,5),heltab3x8(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(28),ex3(:),wf4(:,11),G1tensor(20),m4h2x4x1(:,6),heltab3x8(:,:,6))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(2),wf4(:,4),G0tensor(35),m3h4x1(:,23),heltab2x4(:,:,72))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H4(11),wf4(:,4),G0tensor(10),m3h4x1(:,24),heltab2x4(:,:,73))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(1),12,wf4(:,10),3,G1tensor(22),m3h4x1(:,25),heltab2x4(:,:,74))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(3),12,wf4(:,11),3,G1tensor(25),m3h4x1(:,26),heltab2x4(:,:,75))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(4),12,wf4(:,10),3,G1tensor(27),m3h4x1(:,27),heltab2x4(:,:,76))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(5),12,wf4(:,11),3,G1tensor(30),m3h4x1(:,28),heltab2x4(:,:,77))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(29),wf4(:,2),G1tensor(2),ngH,m3h4x1(:,29),heltab2x4(:,:,78))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(2),wf4(:,2),G1tensor(5),ngX,m3h4x1(:,30),heltab2x4(:,:,79))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(3),wf4(:,2),G1tensor(32),ngPnl,m3h4x1(:,31),heltab2x4(:,:,80))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(4),wf4(:,2),G1tensor(35),m3h4x1(:,32),heltab2x4(:,:,81))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(9),wf4(:,2),G1tensor(37),ngZl,m3h4x1(:,33),heltab2x4(:,:,82))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(10),wf4(:,2),G1tensor(40),m3h4x1(:,34),heltab2x4(:,:,83))
  call Hloop_SA_Q(ntryL,G0H4(7),wf4(:,6),G0H1(1),ngH,m3h4x1(:,35),heltab2x4(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,nME,G1tensor(42),n2h1(63))
  call Hloop_SA_Q(ntryL,G0H4(8),wf4(:,6),G0H1(1),ngX,m3h4x1(:,36),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,nME,G1tensor(45),n2h1(64))
  call Hloop_SA_Q(ntryL,G0H4(9),wf4(:,6),G0H1(1),ngPln,m3h4x1(:,37),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,0,G1tensor(6),n2h1(65))
  call Hloop_VA_Q(ntryL,G0H4(10),wf4(:,6),G0H1(1),m3h4x1(:,38),heltab2x4(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,nME,G1tensor(1),n2h1(66))
  call Hloop_ZA_Q(ntryL,G0H4(6),wf4(:,6),G0H1(1),ngZl,m3h4x1(:,39),heltab2x4(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,nME,G1tensor(7),n2h1(67))
  call Hloop_WA_Q(ntryL,G0H4(12),wf4(:,6),G0H1(1),m3h4x1(:,40),heltab2x4(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,0,G1tensor(10),n2h1(68))
  call ol_merge_tensors(G0tensor(124),[G0tensor(30),G0tensor(6)])
  call ol_merge_tensors(G0tensor(132),[G0tensor(11)])
  call ol_merge_tensors(G0tensor(230),[G0tensor(138),G0tensor(16)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(231),G0tensor(182),G0tensor(159),G0tensor(147),G0tensor(139),G0tensor(133) &
    ,G0tensor(82),G0tensor(76),G0tensor(13),G0tensor(55),G0tensor(20),G0tensor(21)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(232),G0tensor(176),G0tensor(158),G0tensor(152),G0tensor(140),G0tensor(128) &
    ,G0tensor(70),G0tensor(64),G0tensor(7),G0tensor(32),G0tensor(15),G0tensor(26)])
  call ol_merge_tensors(G0tensor(240),[G0tensor(233),G0tensor(187),G0tensor(181),G0tensor(175),G0tensor(170),G0tensor(165) &
    ,G0tensor(160),G0tensor(153),G0tensor(146),G0tensor(141),G0tensor(134),G0tensor(127),G0tensor(102),G0tensor(97),G0tensor(81) &
    ,G0tensor(75),G0tensor(69),G0tensor(63),G0tensor(58),G0tensor(48),G0tensor(12),G0tensor(3),G0tensor(45),G0tensor(5) &
    ,G0tensor(22),G0tensor(31)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(50),G0tensor(41)])
  call ol_merge_tensors(G0tensor(151),[G0tensor(46)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(157),G0tensor(51)])
  call ol_merge_tensors(G0tensor(156),[G0tensor(150),G0tensor(37),G0tensor(27)])
  call ol_merge_tensors(G0tensor(162),[G0tensor(96),G0tensor(74),G0tensor(62),G0tensor(43),G0tensor(52),G0tensor(2)])
  call ol_merge_tensors(G0tensor(136),[G0tensor(126),G0tensor(40)])
  call ol_merge_tensors(G0tensor(164),[G0tensor(101),G0tensor(80),G0tensor(68),G0tensor(57),G0tensor(23),G0tensor(42)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(131),G0tensor(4),G0tensor(47)])
  call ol_merge_tensors(G0tensor(155),[G0tensor(145),G0tensor(8)])
  call ol_merge_tensors(G0tensor(195),[G0tensor(190),G0tensor(44),G0tensor(28)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(104),G0tensor(17)])
  call ol_merge_tensors(G1tensor(30),[G1tensor(27),G1tensor(25),G1tensor(22),G0tensor(10),G0tensor(35),G0tensor(114),G0tensor(86) &
    ,G0tensor(18)])
  call ol_merge_tensors(G0tensor(226),[G0tensor(197),G0tensor(192),G0tensor(122),G0tensor(117),G0tensor(112),G0tensor(107) &
    ,G0tensor(92),G0tensor(87),G0tensor(29),G0tensor(19)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(32),G0tensor(194),G0tensor(106),G0tensor(39)])
  call ol_merge_tensors(G1tensor(20),[G1tensor(15),G1tensor(16),G1tensor(51),G0tensor(25),G0tensor(36),G0tensor(116),G0tensor(91) &
    ,G0tensor(34)])
  call ol_merge_tensors(G0tensor(54),[G0tensor(33)])
  call ol_merge_tensors(G0tensor(167),[G0tensor(38)])
  call ol_merge_tensors(G0tensor(169),[G0tensor(56)])
  call ol_merge_tensors(G0tensor(66),[G0tensor(60)])
  call ol_merge_tensors(G0tensor(228),[G0tensor(172),G0tensor(61)])
  call ol_merge_tensors(G1tensor(42),[G0tensor(174),G0tensor(67)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(72)])
  call ol_merge_tensors(G0tensor(235),[G0tensor(178),G0tensor(73)])
  call ol_merge_tensors(G1tensor(7),[G1tensor(45),G0tensor(180),G0tensor(79)])
  call ol_merge_tensors(G0tensor(89),[G0tensor(84)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(119),G0tensor(85)])
  call ol_merge_tensors(G0tensor(121),[G0tensor(90)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(94)])
  call ol_merge_tensors(G0tensor(184),[G0tensor(95)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(186),G0tensor(100)])
  call ol_merge_tensors(G1tensor(46),[G1tensor(41),G0tensor(1),G0tensor(189),G0tensor(120),G0tensor(115),G0tensor(105)])
  call ol_merge_tensors(G1tensor(10),[G1tensor(6),G0tensor(191),G0tensor(110)])
  call ol_merge_tensors(G0tensor(225),[G0tensor(221),G0tensor(196),G0tensor(111)])
  call ol_merge_tensors(G0tensor(185),[G0tensor(179),G0tensor(173),G0tensor(168),G0tensor(163),G0tensor(149),G0tensor(144) &
    ,G0tensor(130),G0tensor(125)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(5),G0tensor(229)])
  call ol_merge_tensors(G1tensor(2),[G0tensor(236)])
call TI_bubble_red(G1tensor(30),12,mass2set(:,1),G0tensor(9),M2L1R1,G0tensor(14))
call TI_bubble_red(G1tensor(40),10,mass2set(:,2),G0tensor(49),M2L1R1,G0tensor(24))
call TI_bubble_red(G1tensor(20),8,mass2set(:,1),G0tensor(53),M2L1R1,G0tensor(59))
call TI_bubble_red(G1tensor(42),9,mass2set(:,3),G0tensor(65),M2L1R1,G0tensor(71),G0tensor(77))
call TI_bubble_red(G1tensor(7),9,mass2set(:,4),G0tensor(83),M2L1R1,G0tensor(88),G0tensor(93))
call TI_bubble_red(G1tensor(1),9,mass2set(:,5),G0tensor(98),M2L1R1,G0tensor(103))
call TI_bubble_red(G1tensor(46),11,mass2set(:,1),G0tensor(108),M2L1R1,G0tensor(113))
call TI_bubble_red(G1tensor(10),9,mass2set(:,6),G0tensor(118),M2L1R1,G0tensor(123))
call TI_bubble_red(G1tensor(37),10,mass2set(:,7),G0tensor(129),M2L1R1,G0tensor(135),G0tensor(142))
call TI_bubble_red(G1tensor(2),10,mass2set(:,8),G0tensor(148),M2L1R1,G0tensor(154),G0tensor(161))
call TI_bubble_red(G1tensor(35),10,mass2set(:,9),G0tensor(166),M2L1R1,G0tensor(171))
  call ol_merge_tensors(G0tensor(135),[G0tensor(93),G0tensor(239)])
  call ol_merge_tensors(G0tensor(154),[G0tensor(77),G0tensor(238)])
  call ol_merge_tensors(G0tensor(171),[G0tensor(161),G0tensor(142),G0tensor(103),G0tensor(88),G0tensor(71),G0tensor(240)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(113),G0tensor(59),G0tensor(24),G0tensor(226),G0tensor(14)])
  call ol_merge_tensors(T0sum(55),[G0tensor(124)])
  call ol_merge_tensors(T0sum(56),[G0tensor(132)])
  call ol_merge_tensors(T0sum(57),[G0tensor(230)])
  call ol_merge_tensors(T0sum(58),[G0tensor(135)])
  call ol_merge_tensors(T0sum(59),[G0tensor(154)])
  call ol_merge_tensors(T0sum(60),[G0tensor(171)])
  call ol_merge_tensors(T0sum(61),[G0tensor(143)])
  call ol_merge_tensors(T0sum(62),[G0tensor(151)])
  call ol_merge_tensors(T0sum(63),[G0tensor(237)])
  call ol_merge_tensors(T0sum(64),[G0tensor(156)])
  call ol_merge_tensors(T0sum(65),[G0tensor(162)])
  call ol_merge_tensors(T0sum(66),[G0tensor(136)])
  call ol_merge_tensors(T0sum(67),[G0tensor(164)])
  call ol_merge_tensors(T0sum(68),[G0tensor(137)])
  call ol_merge_tensors(T0sum(69),[G0tensor(155)])
  call ol_merge_tensors(T0sum(70),[G0tensor(195)])
  call ol_merge_tensors(T0sum(71),[G0tensor(109)])
  call ol_merge_tensors(T0sum(72),[G0tensor(9)])
  call ol_merge_tensors(T0sum(73),[G0tensor(123)])
  call ol_merge_tensors(T0sum(74),[G0tensor(49)])
  call ol_merge_tensors(T0sum(75),[G0tensor(53)])
  call ol_merge_tensors(T0sum(76),[G0tensor(54)])
  call ol_merge_tensors(T0sum(77),[G0tensor(167)])
  call ol_merge_tensors(T0sum(78),[G0tensor(169)])
  call ol_merge_tensors(T0sum(79),[G0tensor(66)])
  call ol_merge_tensors(T0sum(80),[G0tensor(228)])
  call ol_merge_tensors(T0sum(81),[G0tensor(65)])
  call ol_merge_tensors(T0sum(82),[G0tensor(78)])
  call ol_merge_tensors(T0sum(83),[G0tensor(235)])
  call ol_merge_tensors(T0sum(84),[G0tensor(83)])
  call ol_merge_tensors(T0sum(85),[G0tensor(89)])
  call ol_merge_tensors(T0sum(86),[G0tensor(223)])
  call ol_merge_tensors(T0sum(87),[G0tensor(121)])
  call ol_merge_tensors(T0sum(88),[G0tensor(99)])
  call ol_merge_tensors(T0sum(89),[G0tensor(184)])
  call ol_merge_tensors(T0sum(90),[G0tensor(98)])
  call ol_merge_tensors(T0sum(91),[G0tensor(108)])
  call ol_merge_tensors(T0sum(92),[G0tensor(118)])
  call ol_merge_tensors(T0sum(93),[G0tensor(225)])
  call ol_merge_tensors(T0sum(94),[G0tensor(185)])
  call ol_merge_tensors(T0sum(95),[G0tensor(199)])
  call ol_merge_tensors(T0sum(96),[G0tensor(200)])
  call ol_merge_tensors(T0sum(97),[G0tensor(201)])
  call ol_merge_tensors(T0sum(98),[G0tensor(202)])
  call ol_merge_tensors(T0sum(99),[G0tensor(204)])
  call ol_merge_tensors(T0sum(100),[G0tensor(205)])
  call ol_merge_tensors(T0sum(101),[G0tensor(206)])
  call ol_merge_tensors(T0sum(102),[G0tensor(207)])
  call ol_merge_tensors(T0sum(103),[G0tensor(209)])
  call ol_merge_tensors(T0sum(104),[G0tensor(210)])
  call ol_merge_tensors(T0sum(105),[G0tensor(211)])
  call ol_merge_tensors(T0sum(106),[G0tensor(212)])
  call ol_merge_tensors(T0sum(107),[G0tensor(214)])
  call ol_merge_tensors(T0sum(108),[G0tensor(215)])
  call ol_merge_tensors(T0sum(109),[G0tensor(216)])
  call ol_merge_tensors(T0sum(110),[G0tensor(217)])
  call ol_merge_tensors(T0sum(111),[G0tensor(219)])
  call ol_merge_tensors(T0sum(112),[G0tensor(220)])
  call ol_merge_tensors(T0sum(113),[G0tensor(224)])
  call ol_merge_tensors(T0sum(114),[G0tensor(129)])
  call ol_merge_tensors(T0sum(115),[G0tensor(148)])
  call ol_merge_tensors(T0sum(116),[G0tensor(166)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_eevv_ew_eexaz_1_/**/REALKIND
