
module ol_vamp_1_eevttj_eexttxzg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eevttj_eexttxzg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eevttj_eexttxzg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eevttj_eexttxzg_1_/**/DREALKIND
  use ol_tensor_sum_storage_eevttj_eexttxzg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eevttj_eexttxzg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eevttj_eexttxzg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,3,16,4,8],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,2),heltab2x96(:,:,2))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,3,8,4,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,3),heltab2x96(:,:,3))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(3),n2h48(3))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,3,8,4,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(4))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,3,16,8,4],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(5),n2h48(5))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,3,16,8,4],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,6),heltab2x96(:,:,6))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,4,8,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(7),n2h48(7))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,4,8,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(8),n2h48(8))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,3,4,8,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(9),n2h48(9))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,3,4,8,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(10))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,8,4,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(11),n2h48(11))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,8,4,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,4,16,3,8],[0,nMT,nMT,nMT,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(13),m3h2x48(:,13),heltab2x96(:,:,13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,4,16,3,8],[0,nMT,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(14),m3h2x48(:,14),heltab2x96(:,:,14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,4,3,16,8],[0,nMT,nMT,nMT,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(15),m3h2x48(:,15),heltab2x96(:,:,15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,4,3,16,8],[0,nMT,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(16),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_AV_Q(ntryL,G1H48(1),wf4(:,1),G1H12(1),m3h4x12(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(1),n2h12(1))
  call Hloop_AZ_Q(ntryL,G1H48(2),wf4(:,5),G1H12(1),ngZu,m3h4x12(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(2),n2h12(2))
  call Hloop_QV_A(ntryL,G1H48(3),wf4(:,1),G1H12(1),m3h4x12(:,3),heltab2x48(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(3),n2h12(3))
  call Hloop_QZ_A(ntryL,G1H48(4),wf4(:,5),G1H12(1),ngZu,m3h4x12(:,4),heltab2x48(:,:,4))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(4),n2h12(4))
  call Hloop_QV_A(ntryL,G1H48(5),wf4(:,1),G1H12(1),m3h4x12(:,5),heltab2x48(:,:,5))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(5),n2h12(5))
  call Hloop_QZ_A(ntryL,G1H48(6),wf4(:,5),G1H12(1),ngZu,m3h4x12(:,6),heltab2x48(:,:,6))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(6),n2h12(6))
  call Hloop_AQ_V(ntryL,G1H48(7),ex3(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,7))
  call Hloop_AQ_V(ntryL,G1H48(8),ex3(:),G1H24(2),m3h2x24(:,2),heltab2x48(:,:,8))
  call Hloop_AV_Q(ntryL,G1H48(9),wf4(:,1),G1H12(1),m3h4x12(:,7),heltab2x48(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(7),n2h12(7))
  call Hloop_AZ_Q(ntryL,G1H48(10),wf4(:,5),G1H12(1),ngZu,m3h4x12(:,8),heltab2x48(:,:,10))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(8),n2h12(8))
  call Hloop_QA_V(ntryL,G1H48(11),ex4(:),G1H24(3),m3h2x24(:,3),heltab2x48(:,:,11))
  call Hloop_QA_V(ntryL,G1H48(12),ex4(:),G1H24(4),m3h2x24(:,4),heltab2x48(:,:,12))
  call Hloop_VQ_A(ntryL,G1H48(13),ex3(:),G1H24(5),m3h2x24(:,5),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G1H24(5),36,nMT,G2H24(1),n2h24(1))
  call Hloop_VQ_A(ntryL,G1H48(14),ex3(:),G1H24(5),m3h2x24(:,6),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G1H24(5),36,nMT,G2H24(2),n2h24(2))
  call Hloop_VQ_A(ntryL,G1H48(15),ex3(:),G1H24(5),m3h2x24(:,7),heltab2x48(:,:,15))
  call Hloop_Q_A(ntryL,G1H24(5),36,nMT,G2H24(3),n2h24(3))
  call Hloop_VQ_A(ntryL,G1H48(16),ex3(:),G1H24(5),m3h2x24(:,8),heltab2x48(:,:,16))
  call Hloop_Q_A(ntryL,G1H24(5),36,nMT,G2H24(4),n2h24(4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(2),[G2H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G2H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(6),[G2H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G2H12(7)])
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(5),G1H12(6),12)
  call HG1shiftOLR(G1H12(2),8,12)
  call Hloop_QA_V(ntryL,G2H12(4),ex4(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(2),mass5set(:,1),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),4,12)
  call Hloop_VA_Q(ntryL,G1H24(1),ex4(:),G1H12(13),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(13),44,nMT,G2H12(1),n2h12(9))
  call Hloop_VA_Q(ntryL,G1H24(2),ex4(:),G1H12(13),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(13),44,nMT,G2H12(3),n2h12(10))
  call Hloop_AQ_V(ntryL,G2H12(8),ex3(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VQ_A(ntryL,G1H24(3),ex3(:),G1H12(13),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(13),44,nMT,G2H12(5),n2h12(11))
  call Hloop_VQ_A(ntryL,G1H24(4),ex3(:),G1H12(13),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G1H12(13),44,nMT,G2H12(7),n2h12(12))
  call Hotf_5pt_reduction(G2H24(1),RedSet_5(3),mass5set(:,2),  & 
G1H24(5),G1H24(1),G1H24(2),G1H24(3),G1H24(4),G1H24(6),24)
  call HG1shiftOLR(G1H24(1),8,24)
  call Hotf_5pt_reduction(G2H24(2),RedSet_5(3),mass5set(:,2),  & 
G1H24(7),G1H24(8),G1H24(9),G1H24(10),G1H24(11),G1H24(12),24)
  call HG1shiftOLR(G1H24(8),8,24)
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(4),mass5set(:,2),  & 
G1H24(13),G1H24(14),G1H24(15),G1H24(16),G1H24(17),G1H24(18),24)
  call HG1shiftOLR(G1H24(14),8,24)
  call Hotf_5pt_reduction(G2H24(4),RedSet_5(4),mass5set(:,2),  & 
G1H24(19),G1H24(20),G1H24(21),G1H24(22),G1H24(23),G1H24(24),24)
  call HG1shiftOLR(G1H24(20),8,24)
  call Hloop_AZ_Q(ntryL,G1H12(1),ex5(:),G1H4(1),ngZu,m3h3x4(:,1),heltab2x12(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(1),n2h4(1))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(2),-8,nMT,G2H12(2),n2h12(13))
  call Hloop_QA_V(ntryL,G2H12(2),ex4(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,4))
  call Hloop_AZ_Q(ntryL,G1H12(4),ex5(:),G1H4(1),ngZu,m3h3x4(:,2),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(2),n2h4(2))
  call Hloop_AZ_Q(ntryL,G1H12(5),ex5(:),G1H4(1),ngZu,m3h3x4(:,3),heltab2x12(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(3),n2h4(3))
  call Hloop_AZ_Q(ntryL,G1H12(6),ex5(:),G1H4(1),ngZu,m3h3x4(:,4),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(4),n2h4(4))
  call Hloop_QZ_A(ntryL,G1H12(7),ex5(:),G1H4(1),ngZu,m3h3x4(:,5),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(5),n2h4(5))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(8),-4,nMT,G2H12(4),n2h12(14))
  call Hloop_AQ_V(ntryL,G2H12(4),ex3(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,9))
  call Hloop_QZ_A(ntryL,G1H12(10),ex5(:),G1H4(1),ngZu,m3h3x4(:,6),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(6),n2h4(6))
  call Hloop_QZ_A(ntryL,G1H12(11),ex5(:),G1H4(1),ngZu,m3h3x4(:,7),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H12(12),ex5(:),G1H4(1),ngZu,m3h3x4(:,8),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(8),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H24(5),ex5(:),G1H8(1),ngZu,m3h3x8(:,1),heltab2x24(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(1),n2h8(1))
call HGT_raise_alpha_OLR(G1H24(1),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(1),ex4(:),G1H12(13),m3h2x12(:,5),heltab2x24(:,:,6))
  call Hloop_QZ_A(ntryL,G1H24(3),ex5(:),G1H8(1),ngZu,m3h3x8(:,2),heltab2x24(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(2),n2h8(2))
  call Hloop_QZ_A(ntryL,G1H24(4),ex5(:),G1H8(1),ngZu,m3h3x8(:,3),heltab2x24(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(3),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H24(6),ex5(:),G1H8(1),ngZu,m3h3x8(:,4),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(4),n2h8(4))
  call Hloop_QZ_A(ntryL,G1H24(7),ex5(:),G1H8(1),ngZu,m3h3x8(:,5),heltab2x24(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(5),n2h8(5))
call HGT_raise_alpha_OLR(G1H24(8),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(8),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(8),ex4(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,11))
  call Hloop_QZ_A(ntryL,G1H24(10),ex5(:),G1H8(1),ngZu,m3h3x8(:,6),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(6),n2h8(6))
  call Hloop_QZ_A(ntryL,G1H24(11),ex5(:),G1H8(1),ngZu,m3h3x8(:,7),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(7),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H24(12),ex5(:),G1H8(1),ngZu,m3h3x8(:,8),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(8),n2h8(8))
  call Hloop_QV_A(ntryL,G1H24(13),wf4(:,1),G1H6(1),m3h4x6(:,1),heltab2x24(:,:,15))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(5),n2h6(1))
call HGT_raise_alpha_OLR(G1H24(14),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(14),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(14),ex4(:),G1H12(2),m3h2x12(:,7),heltab2x24(:,:,16))
  call Hloop_QV_A(ntryL,G1H24(16),wf4(:,1),G1H6(1),m3h4x6(:,2),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(6),n2h6(2))
  call Hloop_QV_A(ntryL,G1H24(17),wf4(:,1),G1H6(1),m3h4x6(:,3),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(7),n2h6(3))
  call Hloop_QV_A(ntryL,G1H24(18),wf4(:,1),G1H6(1),m3h4x6(:,4),heltab2x24(:,:,19))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(8),n2h6(4))
  call Hloop_QZ_A(ntryL,G1H24(19),wf4(:,5),G1H6(1),ngZu,m3h4x6(:,5),heltab2x24(:,:,20))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(9),n2h6(5))
call HGT_raise_alpha_OLR(G1H24(20),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(20),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(20),ex4(:),G1H12(4),m3h2x12(:,8),heltab2x24(:,:,21))
  call Hloop_QZ_A(ntryL,G1H24(22),wf4(:,5),G1H6(1),ngZu,m3h4x6(:,6),heltab2x24(:,:,22))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(10),n2h6(6))
  call Hloop_QZ_A(ntryL,G1H24(23),wf4(:,5),G1H6(1),ngZu,m3h4x6(:,7),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(11),n2h6(7))
  call Hloop_QZ_A(ntryL,G1H24(24),wf4(:,5),G1H6(1),ngZu,m3h4x6(:,8),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMT,G2H6(12),n2h6(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G2H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G2H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(8)])
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(5),mass5set(:,3),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
  call HG1shiftOLR(G1H6(2),16,6)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(6),mass5set(:,4),  & 
G1H12(5),G1H12(6),G1H12(7),G1H12(8),G1H12(10),G1H12(11),12)
  call HG1shiftOLR(G1H12(6),16,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(6),mass5set(:,4),  & 
G1H12(12),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(14),16,12)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(7),mass5set(:,3),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),16,6)
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(8),mass5set(:,4),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(20),16,12)
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(8),mass5set(:,4),  & 
G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),G1H12(30),12)
  call HG1shiftOLR(G1H12(26),16,12)
  call Hloop_AQ_V(ntryL,G2H4(1),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(3),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(5),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(3),mass5set(:,2),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(1),mass4set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(2),mass4set(:,1),  & 
G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(13),11,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(3),mass5set(:,2),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(18),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(1),mass4set(:,1),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(24),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(2),mass4set(:,1),  & 
G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(29),11,8)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(4),mass5set(:,2),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_4pt_reduction(G2H6(11),RedSet_4(1),mass4set(:,1),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),6)
  call HG1shiftOLR(G1H6(20),8,6)
  call Hotf_4pt_reduction(G2H6(12),RedSet_4(3),mass4set(:,1),  & 
G1H6(24),G1H6(25),G1H6(26),G1H6(27),G1H6(28),6)
  call HG1shiftOLR(G1H6(25),24,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(19),[G1H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(18)])
  call Hloop_VQ_A(ntryL,G1H6(1),ex3(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(2),-16,nMT,G2H6(5),n2h6(9))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex5(:),G2H2(7),ngZu,m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VQ_A(ntryL,G1H6(5),ex3(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(2),n2h3(2))
  call Hloop_VQ_A(ntryL,G1H6(6),ex3(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(3),n2h3(3))
  call Hloop_AV_Q(ntryL,G1H12(5),wf4(:,1),G1H3(1),m3h4x3(:,1),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(4),n2h3(4))
call HGT_OLR(G1H12(6),1,1,12)
call HGT_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(6),-16,nMT,G2H12(6),n2h12(15))
  call Hloop_QZ_A(ntryL,G2H12(6),ex5(:),G2H4(1),ngZu,m3h3x4(:,9),heltab2x12(:,:,14))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,1),G1H3(1),m3h4x3(:,2),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(5),n2h3(5))
  call Hloop_AV_Q(ntryL,G1H12(11),wf4(:,1),G1H3(1),m3h4x3(:,3),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(6),n2h3(6))
  call Hloop_AZ_Q(ntryL,G1H12(12),wf4(:,5),G1H3(1),ngZu,m3h4x3(:,4),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(7),n2h3(7))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(14),-16,nMT,G2H12(8),n2h12(16))
  call Hloop_QZ_A(ntryL,G2H12(8),ex5(:),G2H4(3),ngZu,m3h3x4(:,10),heltab2x12(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H12(17),wf4(:,5),G1H3(1),ngZu,m3h4x3(:,5),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(8),n2h3(8))
  call Hloop_AZ_Q(ntryL,G1H12(18),wf4(:,5),G1H3(1),ngZu,m3h4x3(:,6),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(9),n2h3(9))
  call Hloop_VA_Q(ntryL,G1H6(7),ex4(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,5))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(10),n2h3(10))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(8),-16,nMT,G2H6(7),n2h6(10))
  call Hloop_QZ_A(ntryL,G2H6(7),ex5(:),G2H2(8),ngZu,m3h3x2(:,2),heltab2x6(:,:,6))
  call Hloop_VA_Q(ntryL,G1H6(11),ex4(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,7))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(11),n2h3(11))
  call Hloop_VA_Q(ntryL,G1H6(12),ex4(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,8))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(12),n2h3(12))
  call Hloop_QV_A(ntryL,G1H12(19),wf4(:,1),G1H3(1),m3h4x3(:,7),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(13),n2h3(13))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(20),-16,nMT,G2H12(2),n2h12(17))
  call Hloop_AZ_Q(ntryL,G2H12(2),ex5(:),G2H4(4),ngZu,m3h3x4(:,11),heltab2x12(:,:,22))
  call Hloop_QV_A(ntryL,G1H12(23),wf4(:,1),G1H3(1),m3h4x3(:,8),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(14),n2h3(14))
  call Hloop_QV_A(ntryL,G1H12(24),wf4(:,1),G1H3(1),m3h4x3(:,9),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(15),n2h3(15))
  call Hloop_QZ_A(ntryL,G1H12(25),wf4(:,5),G1H3(1),ngZu,m3h4x3(:,10),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(16),n2h3(16))
call HGT_OLR(G1H12(26),1,1,12)
call HGT_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(26),-16,nMT,G2H12(4),n2h12(18))
  call Hloop_AZ_Q(ntryL,G2H12(4),ex5(:),G2H4(5),ngZu,m3h3x4(:,12),heltab2x12(:,:,26))
  call Hloop_QZ_A(ntryL,G1H12(29),wf4(:,5),G1H3(1),ngZu,m3h4x3(:,11),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(17),n2h3(17))
  call Hloop_QZ_A(ntryL,G1H12(30),wf4(:,5),G1H3(1),ngZu,m3h4x3(:,12),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(18),n2h3(18))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(9),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(10),n2h2(2))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,1),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(11),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,5))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,1),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(12),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),ex4(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,7))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,1),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(13),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H8(17),wf4(:,5),G1H2(1),ngZu,m3h4x2(:,6),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(14),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,10))
  call Hloop_QZ_A(ntryL,G1H8(23),wf4(:,5),G1H2(1),ngZu,m3h4x2(:,7),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(15),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H8(28),wf4(:,5),G1H2(1),ngZu,m3h4x2(:,8),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(16),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,13))
  call Hloop_QZ_A(ntryL,G1H8(27),wf4(:,5),G1H2(1),ngZu,m3h4x2(:,9),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(17),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(29),ex4(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,15))
  call Hloop_QZ_A(ntryL,G1H8(32),wf4(:,5),G1H2(1),ngZu,m3h4x2(:,10),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(18),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H6(13),ex5(:),G1H2(1),ngZu,m3h3x2(:,3),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(19),n2h2(11))
call HGT_raise_alpha_OLR(G1H6(14),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(14),ex4(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,10))
  call Hloop_QZ_A(ntryL,G1H6(19),ex5(:),G1H2(1),ngZu,m3h3x2(:,4),heltab2x6(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(20),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H6(24),ex5(:),G1H2(1),ngZu,m3h3x2(:,5),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(21),n2h2(13))
call HGT_raise_alpha_OLR(G1H6(20),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(20),ex4(:),G1H3(2),m3h2x3(:,8),heltab2x6(:,:,13))
  call Hloop_QZ_A(ntryL,G1H6(23),ex5(:),G1H2(1),ngZu,m3h3x2(:,6),heltab2x6(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(22),n2h2(14))
call HGT_raise_alpha_OLR(G1H6(25),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(25),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(25),ex4(:),G1H3(3),m3h2x3(:,9),heltab2x6(:,:,15))
  call Hloop_QZ_A(ntryL,G1H6(28),ex5(:),G1H2(1),ngZu,m3h3x2(:,7),heltab2x6(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(23),n2h2(15))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G2H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(11)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),12,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(4),mass4set(:,2),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),12,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(5),mass5set(:,3),  & 
G1H3(4),G1H3(5),G1H3(6),G1H3(7),G1H3(8),G1H3(9),3)
  call HG1shiftOLR(G1H3(5),16,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(5),mass4set(:,3),  & 
G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
  call HG1shiftOLR(G1H3(11),20,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(6),mass5set(:,4),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(16),16,3)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(6),mass4set(:,4),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),3)
  call HG1shiftOLR(G1H3(22),19,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(7),mass5set(:,3),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
  call HG1shiftOLR(G1H3(27),16,3)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(7),mass4set(:,3),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(33),24,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(8),mass5set(:,4),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),16,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(8),mass4set(:,4),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),3)
  call HG1shiftOLR(G1H3(44),19,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(32),[G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(43),[G1H3(42)])
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(5),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(7),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(8),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(9),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(10),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(11),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(12),n2h1(8))
  call Hloop_QZ_A(ntryL,G1H3(4),ex5(:),G1H1(1),ngZu,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(13),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H3(5),ex5(:),G1H1(1),ngZu,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(14),n2h1(10))
  call Hloop_QZ_A(ntryL,G1H3(10),ex5(:),G1H1(1),ngZu,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(15),n2h1(11))
  call Hloop_QZ_A(ntryL,G1H3(11),ex5(:),G1H1(1),ngZu,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nMT,G2tensor(16),n2h1(12))
  call Hloop_AZ_Q(ntryL,G1H3(15),ex5(:),G1H1(1),ngZu,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(17),n2h1(13))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex5(:),G1H1(1),ngZu,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(18),n2h1(14))
  call Hloop_AZ_Q(ntryL,G1H3(21),ex5(:),G1H1(1),ngZu,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(19),n2h1(15))
  call Hloop_AZ_Q(ntryL,G1H3(22),ex5(:),G1H1(1),ngZu,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nMT,G2tensor(20),n2h1(16))
  call Hloop_AZ_Q(ntryL,G1H3(26),ex5(:),G1H1(1),ngZu,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(21),n2h1(17))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex5(:),G1H1(1),ngZu,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(22),n2h1(18))
  call Hloop_AZ_Q(ntryL,G1H3(32),ex5(:),G1H1(1),ngZu,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(23),n2h1(19))
  call Hloop_AZ_Q(ntryL,G1H3(33),ex5(:),G1H1(1),ngZu,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMT,G2tensor(24),n2h1(20))
  call Hloop_QZ_A(ntryL,G1H3(37),ex5(:),G1H1(1),ngZu,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(21))
  call Hloop_QZ_A(ntryL,G1H3(38),ex5(:),G1H1(1),ngZu,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(26),n2h1(22))
  call Hloop_QZ_A(ntryL,G1H3(43),ex5(:),G1H1(1),ngZu,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(27),n2h1(23))
  call Hloop_QZ_A(ntryL,G1H3(44),ex5(:),G1H1(1),ngZu,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nMT,G2tensor(28),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(3),mass5set(:,2),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(4),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(1),n2h48(13))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(14))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,19),heltab2x96(:,:,19))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(3),n2h48(15))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(16))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(5),n2h48(17))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(6),n2h48(18))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(7),n2h48(19))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(8),n2h48(20))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,25),heltab2x96(:,:,25))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(9),n2h48(21))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,26),heltab2x96(:,:,26))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(22))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(11),n2h48(23))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,28),heltab2x96(:,:,28))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(24))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,29),heltab2x96(:,:,29))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(13),n2h48(25))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,8),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,30),heltab2x96(:,:,30))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(14),n2h48(26))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,12,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,31),heltab2x96(:,:,31))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(15),n2h48(27))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,8),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,32),heltab2x96(:,:,32))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(16),n2h48(28))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(17),n2h48(29))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,34),heltab2x96(:,:,34))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(30))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,35),heltab2x96(:,:,35))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(19),n2h48(31))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,36),heltab2x96(:,:,36))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(32))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,37),heltab2x96(:,:,37))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(21),n2h48(33))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,38),heltab2x96(:,:,38))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(22),n2h48(34))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,39),heltab2x96(:,:,39))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(23),n2h48(35))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,40),heltab2x96(:,:,40))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(24),n2h48(36))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[32,3,12,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,41),heltab2x96(:,:,41))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(25),n2h48(37))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,42),heltab2x96(:,:,42))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(26),n2h48(38))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[32,3,12,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,43),heltab2x96(:,:,43))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(27),n2h48(39))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,44),heltab2x96(:,:,44))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(28),n2h48(40))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[32,3,12,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,45))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(29),n2h48(41))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,46),heltab2x96(:,:,46))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(30),n2h48(42))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,3,12,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,47))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(31),n2h48(43))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(32),n2h48(44))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,49))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(33),n2h48(45))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,50),heltab2x96(:,:,50))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(34),n2h48(46))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,51),heltab2x96(:,:,51))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(35),n2h48(47))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,52),heltab2x96(:,:,52))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(36),n2h48(48))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(37),n2h48(49))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,54),heltab2x96(:,:,54))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(38),n2h48(50))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,55),heltab2x96(:,:,55))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(39),n2h48(51))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,56),heltab2x96(:,:,56))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(40),n2h48(52))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,3,16,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,57),heltab2x96(:,:,57))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(41),n2h48(53))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,58),heltab2x96(:,:,58))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(42),n2h48(54))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,3,16,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,59),heltab2x96(:,:,59))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(43),n2h48(55))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,60),heltab2x96(:,:,60))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(44),n2h48(56))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,3,16,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,61),heltab2x96(:,:,61))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(45),n2h48(57))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,62),heltab2x96(:,:,62))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(46),n2h48(58))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[32,3,16,12],[0,0,0,0],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,63),heltab2x96(:,:,63))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(47),n2h48(59))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,5),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,64),heltab2x96(:,:,64))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(48),n2h48(60))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[32,8,3,20],[0,nMT,nMT,0],4,2,wf4(:,1),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(49),m3h2x48(:,65),heltab2x96(:,:,65))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[32,8,3,20],[0,nMT,nMT,0],4,2,wf4(:,5),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(50),m3h2x48(:,66),heltab2x96(:,:,66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[32,3,20,8],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,67),heltab2x96(:,:,67))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(51),n2h48(61))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,3,20,8],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,68),heltab2x96(:,:,68))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(52),n2h48(62))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,3,8,20],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,69),heltab2x96(:,:,69))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(53),n2h48(63))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,3,8,20],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,70),heltab2x96(:,:,70))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(54),n2h48(64))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,4,3,24],[0,nMT,nMT,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(55),m3h2x48(:,71),heltab2x96(:,:,71))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,4,3,24],[0,nMT,nMT,0],4,2,wf4(:,5),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(56),m3h2x48(:,72),heltab2x96(:,:,72))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,3,24,4],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,73),heltab2x96(:,:,73))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(57),n2h48(65))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[32,3,24,4],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,74),heltab2x96(:,:,74))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(58),n2h48(66))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[32,3,4,24],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,75),heltab2x96(:,:,75))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(59),n2h48(67))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[32,3,4,24],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,76),heltab2x96(:,:,76))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(60),n2h48(68))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[36,3,16,8],[nMT,nMT,nMT,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,7),G0H24(1),m3h4x24(:,1),heltab2x96(:,:,77))
  call Hloop_Q_A(ntryL,G0H24(1),36,nMT,G1H24(5),n2h24(9))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[36,3,16,8],[nMT,nMT,nMT,0],4,2,wf4(:,7),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,7),G0H24(1),m3h4x24(:,2),heltab2x96(:,:,78))
  call Hloop_Q_A(ntryL,G0H24(1),36,nMT,G1H24(1),n2h24(10))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[36,8,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,7),G0H24(1),m3h4x24(:,3),heltab2x96(:,:,79))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[36,8,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,7),G0H24(2),m3h4x24(:,4),heltab2x96(:,:,80))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[40,3,16,4],[nMT,nMT,nMT,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(3),m3h4x24(:,5),heltab2x96(:,:,81))
  call Hloop_A_Q(ntryL,G0H24(3),40,nMT,G1H24(3),n2h24(11))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[40,3,16,4],[nMT,nMT,nMT,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(3),m3h4x24(:,6),heltab2x96(:,:,82))
  call Hloop_A_Q(ntryL,G0H24(3),40,nMT,G1H24(4),n2h24(12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[40,4,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(3),m3h4x24(:,7),heltab2x96(:,:,83))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[40,4,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(4),m3h4x24(:,8),heltab2x96(:,:,84))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[32,7,16,8],[0,nMT,nMT,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(61),m3h2x48(:,77),heltab2x96(:,:,85))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[32,7,16,8],[0,nMT,nMT,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(62),m3h2x48(:,78),heltab2x96(:,:,86))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[32,7,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,79),heltab2x96(:,:,87))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(63),n2h48(69))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[32,7,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,80),heltab2x96(:,:,88))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(64),n2h48(70))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[32,8,7,16],[nMT,0,nMT,nMT],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,81),heltab2x96(:,:,89))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(65),n2h48(71))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[32,8,7,16],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,82),heltab2x96(:,:,90))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(66),n2h48(72))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[32,4,16,11],[0,nMT,nMT,0],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(67),m3h2x48(:,83),heltab2x96(:,:,91))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[32,4,16,11],[0,nMT,nMT,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(68),m3h2x48(:,84),heltab2x96(:,:,92))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(93),h0tab(:,93),[32,11,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,85),heltab2x96(:,:,93))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(69),n2h48(73))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(94),h0tab(:,94),[32,11,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,86),heltab2x96(:,:,94))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(70),n2h48(74))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(95),h0tab(:,95),[32,4,11,16],[nMT,0,nMT,nMT],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,87),heltab2x96(:,:,95))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(71),n2h48(75))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(96),h0tab(:,96),[32,4,11,16],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,88),heltab2x96(:,:,96))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(72),n2h48(76))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(97),h0tab(:,97),[32,4,8,19],[nMT,0,nMT,nMT],4,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,89),heltab2x96(:,:,97))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(73),n2h48(77))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(98),h0tab(:,98),[32,8,4,19],[nMT,0,nMT,nMT],4,1,wf12(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,90),heltab2x96(:,:,98))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(74),n2h48(78))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(99),h0tab(:,99),[32,4,19,8],[0,nMT,nMT,0],4,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(75),m3h2x48(:,91),heltab2x96(:,:,99))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(100),h0tab(:,100),[32,4,8,19],[nMT,0,nMT,nMT],4,1,wf12(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,92),heltab2x96(:,:,100))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(76),n2h48(79))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(101),h0tab(:,101),[32,4,8,19],[nMT,0,nMT,nMT],4,1,wf12(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,93),heltab2x96(:,:,101))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(77),n2h48(80))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(102),h0tab(:,102),[32,8,4,19],[nMT,0,nMT,nMT],4,1,wf12(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,94),heltab2x96(:,:,102))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(78),n2h48(81))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(103),h0tab(:,103),[32,8,4,19],[nMT,0,nMT,nMT],4,1,wf12(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,95),heltab2x96(:,:,103))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(79),n2h48(82))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(104),h0tab(:,104),[32,4,19,8],[0,nMT,nMT,0],4,1,wf12(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(80),m3h2x48(:,96),heltab2x96(:,:,104))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(105),h0tab(:,105),[32,4,19,8],[0,nMT,nMT,0],4,1,wf12(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(81),m3h2x48(:,97),heltab2x96(:,:,105))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(106),h0tab(:,106),[32,4,8,19],[nMT,0,nMT,nMT],4,1,wf12(:,9))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,98),heltab2x96(:,:,106))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(82),n2h48(83))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(107),h0tab(:,107),[32,4,8,19],[nMT,0,nMT,nMT],4,1,wf12(:,11))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,99),heltab2x96(:,:,107))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(83),n2h48(84))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(108),h0tab(:,108),[32,8,4,19],[nMT,0,nMT,nMT],4,1,wf12(:,9))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,100),heltab2x96(:,:,108))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(84),n2h48(85))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(109),h0tab(:,109),[32,8,4,19],[nMT,0,nMT,nMT],4,1,wf12(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,101),heltab2x96(:,:,109))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(85),n2h48(86))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(110),h0tab(:,110),[32,4,19,8],[0,nMT,nMT,0],4,1,wf12(:,9))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(86),m3h2x48(:,102),heltab2x96(:,:,110))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(111),h0tab(:,111),[32,4,19,8],[0,nMT,nMT,0],4,1,wf12(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(87),m3h2x48(:,103),heltab2x96(:,:,111))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(5),[G1H24(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(1),[G1H24(21)])
  call Hloop_AZ_Q(ntryL,G1H12(3),ex5(:),G1H4(7),ngZu,m3h3x4(:,13),heltab2x12(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(7),51,nMT,G2H4(7),n2h4(9))
  call Hloop_QZ_A(ntryL,G1H12(9),ex5(:),G1H4(7),ngZu,m3h3x4(:,14),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(7),51,nMT,G2H4(8),n2h4(10))
  call Hloop_QZ_A(ntryL,G1H24(2),ex5(:),G1H8(5),ngZu,m3h3x8(:,9),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(5),52,nMT,G2H8(1),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H24(9),ex5(:),G1H8(6),ngZu,m3h3x8(:,10),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(6),52,nMT,G2H8(3),n2h8(16))
  call Hloop_QV_A(ntryL,G1H24(5),wf4(:,1),G1H6(17),m3h4x6(:,9),heltab2x24(:,:,27))
  call Hloop_Q_A(ntryL,G1H6(17),39,nMT,G2H6(8),n2h6(14))
  call Hloop_QZ_A(ntryL,G1H24(1),wf4(:,5),G1H6(18),ngZu,m3h4x6(:,10),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G1H6(18),39,nMT,G2H6(1),n2h6(15))
  call Hloop_AV_Q(ntryL,G1H48(1),wf4(:,8),G1H12(5),m3h4x12(:,9),heltab2x48(:,:,17))
  call Hloop_A_Q(ntryL,G1H12(5),44,0,G2H12(1),n2h12(19))
  call Hloop_AV_Q(ntryL,G1H48(2),wf4(:,8),G1H12(6),m3h4x12(:,10),heltab2x48(:,:,18))
  call Hloop_A_Q(ntryL,G1H12(6),44,nMT,G2H12(3),n2h12(20))
  call Hloop_QV_A(ntryL,G1H48(3),wf4(:,8),G1H12(10),m3h4x12(:,11),heltab2x48(:,:,19))
  call Hloop_Q_A(ntryL,G1H12(10),44,0,G2H12(5),n2h12(21))
  call Hloop_QV_A(ntryL,G1H48(4),wf4(:,8),G1H12(11),m3h4x12(:,12),heltab2x48(:,:,20))
  call Hloop_Q_A(ntryL,G1H12(11),44,nMT,G2H12(7),n2h12(22))
  call Hloop_AV_Q(ntryL,G1H48(5),wf4(:,8),G1H12(12),m3h4x12(:,13),heltab2x48(:,:,21))
  call Hloop_A_Q(ntryL,G1H12(12),44,0,G2H12(6),n2h12(23))
  call Hloop_AV_Q(ntryL,G1H48(6),wf4(:,8),G1H12(14),m3h4x12(:,14),heltab2x48(:,:,22))
  call Hloop_A_Q(ntryL,G1H12(14),44,nMB,G2H12(8),n2h12(24))
  call Hloop_QV_A(ntryL,G1H48(7),wf4(:,8),G1H12(17),m3h4x12(:,15),heltab2x48(:,:,23))
  call Hloop_Q_A(ntryL,G1H12(17),44,0,G2H12(2),n2h12(25))
  call Hloop_QV_A(ntryL,G1H48(8),wf4(:,8),G1H12(18),m3h4x12(:,16),heltab2x48(:,:,24))
  call Hloop_Q_A(ntryL,G1H12(18),44,nMB,G2H12(4),n2h12(26))
  call Hloop_AV_Q(ntryL,G1H48(9),wf4(:,8),G1H12(19),m3h4x12(:,17),heltab2x48(:,:,25))
  call Hloop_A_Q(ntryL,G1H12(19),44,0,G2H12(9),n2h12(27))
  call Hloop_AV_Q(ntryL,G1H48(10),wf4(:,8),G1H12(20),m3h4x12(:,18),heltab2x48(:,:,26))
  call Hloop_A_Q(ntryL,G1H12(20),44,nMT,G2H12(10),n2h12(28))
  call Hloop_QV_A(ntryL,G1H48(11),wf4(:,8),G1H12(23),m3h4x12(:,19),heltab2x48(:,:,27))
  call Hloop_Q_A(ntryL,G1H12(23),44,0,G2H12(11),n2h12(29))
  call Hloop_QV_A(ntryL,G1H48(12),wf4(:,8),G1H12(24),m3h4x12(:,20),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G1H12(24),44,nMT,G2H12(12),n2h12(30))
  call Hloop_AV_Q(ntryL,G1H48(13),wf4(:,8),G1H12(25),m3h4x12(:,21),heltab2x48(:,:,29))
  call Hloop_A_Q(ntryL,G1H12(25),44,0,G2H12(13),n2h12(31))
  call Hloop_AV_Q(ntryL,G1H48(14),wf4(:,8),G1H12(26),m3h4x12(:,22),heltab2x48(:,:,30))
  call Hloop_A_Q(ntryL,G1H12(26),44,nMB,G2H12(14),n2h12(32))
  call Hloop_QV_A(ntryL,G1H48(15),wf4(:,8),G1H12(29),m3h4x12(:,23),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(29),44,0,G2H12(15),n2h12(33))
  call Hloop_QV_A(ntryL,G1H48(16),wf4(:,8),G1H12(30),m3h4x12(:,24),heltab2x48(:,:,32))
  call Hloop_Q_A(ntryL,G1H12(30),44,nMB,G2H12(16),n2h12(34))
  call Hloop_AV_Q(ntryL,G1H48(17),wf4(:,1),G1H12(3),m3h4x12(:,25),heltab2x48(:,:,33))
  call Hloop_A_Q(ntryL,G1H12(3),35,0,G2H12(17),n2h12(35))
  call Hloop_AV_Q(ntryL,G1H48(18),wf4(:,1),G1H12(9),m3h4x12(:,26),heltab2x48(:,:,34))
  call Hloop_A_Q(ntryL,G1H12(9),35,nMT,G2H12(18),n2h12(36))
  call Hloop_QV_A(ntryL,G1H48(19),wf4(:,1),G1H12(5),m3h4x12(:,27),heltab2x48(:,:,35))
  call Hloop_Q_A(ntryL,G1H12(5),35,0,G2H12(19),n2h12(37))
  call Hloop_QV_A(ntryL,G1H48(20),wf4(:,1),G1H12(6),m3h4x12(:,28),heltab2x48(:,:,36))
  call Hloop_Q_A(ntryL,G1H12(6),35,nMT,G2H12(20),n2h12(38))
  call Hloop_AV_Q(ntryL,G1H48(21),wf4(:,1),G1H12(10),m3h4x12(:,29),heltab2x48(:,:,37))
  call Hloop_A_Q(ntryL,G1H12(10),35,0,G2H12(21),n2h12(39))
  call Hloop_AV_Q(ntryL,G1H48(22),wf4(:,1),G1H12(11),m3h4x12(:,30),heltab2x48(:,:,38))
  call Hloop_A_Q(ntryL,G1H12(11),35,nMB,G2H12(22),n2h12(40))
  call Hloop_QV_A(ntryL,G1H48(23),wf4(:,1),G1H12(12),m3h4x12(:,31),heltab2x48(:,:,39))
  call Hloop_Q_A(ntryL,G1H12(12),35,0,G2H12(23),n2h12(41))
  call Hloop_QV_A(ntryL,G1H48(24),wf4(:,1),G1H12(14),m3h4x12(:,32),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G1H12(14),35,nMB,G2H12(24),n2h12(42))
  call Hloop_AZ_Q(ntryL,G1H48(25),wf4(:,5),G1H12(17),ngZu,m3h4x12(:,33),heltab2x48(:,:,41))
  call Hloop_A_Q(ntryL,G1H12(17),35,0,G2H12(25),n2h12(43))
  call Hloop_AZ_Q(ntryL,G1H48(26),wf4(:,5),G1H12(18),ngZu,m3h4x12(:,34),heltab2x48(:,:,42))
  call Hloop_A_Q(ntryL,G1H12(18),35,nMT,G2H12(26),n2h12(44))
  call Hloop_QZ_A(ntryL,G1H48(27),wf4(:,5),G1H12(19),ngZu,m3h4x12(:,35),heltab2x48(:,:,43))
  call Hloop_Q_A(ntryL,G1H12(19),35,0,G2H12(27),n2h12(45))
  call Hloop_QZ_A(ntryL,G1H48(28),wf4(:,5),G1H12(20),ngZu,m3h4x12(:,36),heltab2x48(:,:,44))
  call Hloop_Q_A(ntryL,G1H12(20),35,nMT,G2H12(28),n2h12(46))
  call Hloop_AZ_Q(ntryL,G1H48(29),wf4(:,5),G1H12(23),ngZd,m3h4x12(:,37),heltab2x48(:,:,45))
  call Hloop_A_Q(ntryL,G1H12(23),35,0,G2H12(29),n2h12(47))
  call Hloop_AZ_Q(ntryL,G1H48(30),wf4(:,5),G1H12(24),ngZd,m3h4x12(:,38),heltab2x48(:,:,46))
  call Hloop_A_Q(ntryL,G1H12(24),35,nMB,G2H12(30),n2h12(48))
  call Hloop_QZ_A(ntryL,G1H48(31),wf4(:,5),G1H12(25),ngZd,m3h4x12(:,39),heltab2x48(:,:,47))
  call Hloop_Q_A(ntryL,G1H12(25),35,0,G2H12(31),n2h12(49))
  call Hloop_QZ_A(ntryL,G1H48(32),wf4(:,5),G1H12(26),ngZd,m3h4x12(:,40),heltab2x48(:,:,48))
  call Hloop_Q_A(ntryL,G1H12(26),35,nMB,G2H12(32),n2h12(50))
  call Hloop_QV_A(ntryL,G1H48(33),wf4(:,1),G1H12(29),m3h4x12(:,41),heltab2x48(:,:,49))
  call Hloop_Q_A(ntryL,G1H12(29),35,0,G2H12(33),n2h12(51))
  call Hloop_QV_A(ntryL,G1H48(34),wf4(:,1),G1H12(30),m3h4x12(:,42),heltab2x48(:,:,50))
  call Hloop_Q_A(ntryL,G1H12(30),35,nMT,G2H12(34),n2h12(52))
  call Hloop_AV_Q(ntryL,G1H48(35),wf4(:,1),G1H12(3),m3h4x12(:,43),heltab2x48(:,:,51))
  call Hloop_A_Q(ntryL,G1H12(3),35,0,G2H12(35),n2h12(53))
  call Hloop_AV_Q(ntryL,G1H48(36),wf4(:,1),G1H12(9),m3h4x12(:,44),heltab2x48(:,:,52))
  call Hloop_A_Q(ntryL,G1H12(9),35,nMT,G2H12(36),n2h12(54))
  call Hloop_QV_A(ntryL,G1H48(37),wf4(:,1),G1H12(5),m3h4x12(:,45),heltab2x48(:,:,53))
  call Hloop_Q_A(ntryL,G1H12(5),35,0,G2H12(37),n2h12(55))
  call Hloop_QV_A(ntryL,G1H48(38),wf4(:,1),G1H12(6),m3h4x12(:,46),heltab2x48(:,:,54))
  call Hloop_Q_A(ntryL,G1H12(6),35,nMB,G2H12(38),n2h12(56))
  call Hloop_AV_Q(ntryL,G1H48(39),wf4(:,1),G1H12(10),m3h4x12(:,47),heltab2x48(:,:,55))
  call Hloop_A_Q(ntryL,G1H12(10),35,0,G2H12(39),n2h12(57))
  call Hloop_AV_Q(ntryL,G1H48(40),wf4(:,1),G1H12(11),m3h4x12(:,48),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G1H12(11),35,nMB,G2H12(40),n2h12(58))
  call Hloop_QZ_A(ntryL,G1H48(41),wf4(:,5),G1H12(12),ngZu,m3h4x12(:,49),heltab2x48(:,:,57))
  call Hloop_Q_A(ntryL,G1H12(12),35,0,G2H12(41),n2h12(59))
  call Hloop_QZ_A(ntryL,G1H48(42),wf4(:,5),G1H12(14),ngZu,m3h4x12(:,50),heltab2x48(:,:,58))
  call Hloop_Q_A(ntryL,G1H12(14),35,nMT,G2H12(42),n2h12(60))
  call Hloop_AZ_Q(ntryL,G1H48(43),wf4(:,5),G1H12(17),ngZu,m3h4x12(:,51),heltab2x48(:,:,59))
  call Hloop_A_Q(ntryL,G1H12(17),35,0,G2H12(43),n2h12(61))
  call Hloop_AZ_Q(ntryL,G1H48(44),wf4(:,5),G1H12(18),ngZu,m3h4x12(:,52),heltab2x48(:,:,60))
  call Hloop_A_Q(ntryL,G1H12(18),35,nMT,G2H12(44),n2h12(62))
  call Hloop_QZ_A(ntryL,G1H48(45),wf4(:,5),G1H12(19),ngZd,m3h4x12(:,53),heltab2x48(:,:,61))
  call Hloop_Q_A(ntryL,G1H12(19),35,0,G2H12(45),n2h12(63))
  call Hloop_QZ_A(ntryL,G1H48(46),wf4(:,5),G1H12(20),ngZd,m3h4x12(:,54),heltab2x48(:,:,62))
  call Hloop_Q_A(ntryL,G1H12(20),35,nMB,G2H12(46),n2h12(64))
  call Hloop_AZ_Q(ntryL,G1H48(47),wf4(:,5),G1H12(23),ngZd,m3h4x12(:,55),heltab2x48(:,:,63))
  call Hloop_A_Q(ntryL,G1H12(23),35,0,G2H12(47),n2h12(65))
  call Hloop_AZ_Q(ntryL,G1H48(48),wf4(:,5),G1H12(24),ngZd,m3h4x12(:,56),heltab2x48(:,:,64))
  call Hloop_A_Q(ntryL,G1H12(24),35,nMB,G2H12(48),n2h12(66))
  call Hloop_VA_Q(ntryL,G1H48(49),ex4(:),G1H24(6),m3h2x24(:,9),heltab2x48(:,:,65))
  call Hloop_A_Q(ntryL,G1H24(6),40,nMT,G2H24(1),n2h24(13))
  call Hloop_VA_Q(ntryL,G1H48(50),ex4(:),G1H24(7),m3h2x24(:,10),heltab2x48(:,:,66))
  call Hloop_A_Q(ntryL,G1H24(7),40,nMT,G2H24(2),n2h24(14))
  call Hloop_AV_Q(ntryL,G1H48(51),wf4(:,1),G1H12(25),m3h4x12(:,57),heltab2x48(:,:,67))
  call Hloop_A_Q(ntryL,G1H12(25),35,nMT,G2H12(49),n2h12(67))
  call Hloop_AZ_Q(ntryL,G1H48(52),wf4(:,5),G1H12(26),ngZu,m3h4x12(:,58),heltab2x48(:,:,68))
  call Hloop_A_Q(ntryL,G1H12(26),35,nMT,G2H12(50),n2h12(68))
  call Hloop_QV_A(ntryL,G1H48(53),wf4(:,1),G1H12(29),m3h4x12(:,59),heltab2x48(:,:,69))
  call Hloop_Q_A(ntryL,G1H12(29),35,nMT,G2H12(51),n2h12(69))
  call Hloop_QZ_A(ntryL,G1H48(54),wf4(:,5),G1H12(30),ngZu,m3h4x12(:,60),heltab2x48(:,:,70))
  call Hloop_Q_A(ntryL,G1H12(30),35,nMT,G2H12(52),n2h12(70))
  call Hloop_VQ_A(ntryL,G1H48(55),ex3(:),G1H24(8),m3h2x24(:,11),heltab2x48(:,:,71))
  call Hloop_Q_A(ntryL,G1H24(8),36,nMT,G2H24(3),n2h24(15))
  call Hloop_VQ_A(ntryL,G1H48(56),ex3(:),G1H24(10),m3h2x24(:,12),heltab2x48(:,:,72))
  call Hloop_Q_A(ntryL,G1H24(10),36,nMT,G2H24(4),n2h24(16))
  call Hloop_QV_A(ntryL,G1H48(57),wf4(:,1),G1H12(3),m3h4x12(:,61),heltab2x48(:,:,73))
  call Hloop_Q_A(ntryL,G1H12(3),35,nMT,G2H12(53),n2h12(71))
  call Hloop_QZ_A(ntryL,G1H48(58),wf4(:,5),G1H12(9),ngZu,m3h4x12(:,62),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G1H12(9),35,nMT,G2H12(54),n2h12(72))
  call Hloop_AV_Q(ntryL,G1H48(59),wf4(:,1),G1H12(5),m3h4x12(:,63),heltab2x48(:,:,75))
  call Hloop_A_Q(ntryL,G1H12(5),35,nMT,G2H12(55),n2h12(73))
  call Hloop_AZ_Q(ntryL,G1H48(60),wf4(:,5),G1H12(6),ngZu,m3h4x12(:,64),heltab2x48(:,:,76))
  call Hloop_A_Q(ntryL,G1H12(6),35,nMT,G2H12(56),n2h12(74))
  call Hloop_VA_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,9),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(10),n2h12(75))
  call Hloop_VA_Q(ntryL,G0H24(2),ex4(:),G0H12(1),m3h2x12(:,10),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(11),n2h12(76))
  call Hloop_AV_Q(ntryL,G1H24(3),wf4(:,1),G1H6(1),m3h4x6(:,11),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(2),n2h6(16))
  call Hloop_AZ_Q(ntryL,G1H24(4),wf4(:,5),G1H6(2),ngZu,m3h4x6(:,12),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G1H6(2),43,nMT,G2H6(9),n2h6(17))
  call Hloop_VQ_A(ntryL,G0H24(3),ex3(:),G0H12(1),m3h2x12(:,11),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G0H12(1),44,nMT,G1H12(12),n2h12(77))
  call Hloop_VQ_A(ntryL,G0H24(4),ex3(:),G0H12(1),m3h2x12(:,12),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G0H12(1),44,nMT,G1H12(14),n2h12(78))
  call Hloop_VQ_A(ntryL,G1H48(61),wf8(:,6),G1H6(5),m3h8x6(:,1),heltab2x48(:,:,77))
  call Hloop_Q_A(ntryL,G1H6(5),39,nMT,G2H6(11),n2h6(18))
  call Hloop_VQ_A(ntryL,G1H48(62),wf8(:,8),G1H6(6),m3h8x6(:,2),heltab2x48(:,:,78))
  call Hloop_Q_A(ntryL,G1H6(6),39,nMT,G2H6(12),n2h6(19))
  call Hloop_AQ_V(ntryL,G1H48(63),wf8(:,6),G1H6(7),m3h8x6(:,3),heltab2x48(:,:,79))
  call Hloop_AQ_V(ntryL,G1H48(64),wf8(:,8),G1H6(8),m3h8x6(:,4),heltab2x48(:,:,80))
  call Hloop_QA_V(ntryL,G1H48(65),ex4(:),G1H24(11),m3h2x24(:,13),heltab2x48(:,:,81))
  call Hloop_QA_V(ntryL,G1H48(66),ex4(:),G1H24(12),m3h2x24(:,14),heltab2x48(:,:,82))
  call Hloop_VQ_A(ntryL,G1H48(67),ex3(:),G1H24(13),m3h2x24(:,15),heltab2x48(:,:,83))
  call Hloop_Q_A(ntryL,G1H24(13),36,nMT,G2H24(5),n2h24(17))
  call Hloop_VQ_A(ntryL,G1H48(68),ex3(:),G1H24(14),m3h2x24(:,16),heltab2x48(:,:,84))
  call Hloop_Q_A(ntryL,G1H24(14),36,nMT,G2H24(6),n2h24(18))
  call Hloop_QA_V(ntryL,G1H48(69),wf8(:,2),G1H6(11),m3h8x6(:,5),heltab2x48(:,:,85))
  call Hloop_QA_V(ntryL,G1H48(70),wf8(:,4),G1H6(12),m3h8x6(:,6),heltab2x48(:,:,86))
  call Hloop_AQ_V(ntryL,G1H48(71),ex3(:),G1H24(16),m3h2x24(:,17),heltab2x48(:,:,87))
  call Hloop_AQ_V(ntryL,G1H48(72),ex3(:),G1H24(17),m3h2x24(:,18),heltab2x48(:,:,88))
  call Hloop_AQ_V(ntryL,G1H48(73),ex3(:),G1H24(18),m3h2x24(:,19),heltab2x48(:,:,89))
  call Hloop_QA_V(ntryL,G1H48(74),ex4(:),G1H24(19),m3h2x24(:,20),heltab2x48(:,:,90))
  call Hloop_VQ_A(ntryL,G1H48(75),ex3(:),G1H24(20),m3h2x24(:,21),heltab2x48(:,:,91))
  call Hloop_Q_A(ntryL,G1H24(20),36,nMT,G2H24(7),n2h24(19))
  call Hloop_AQ_V(ntryL,G1H48(76),ex3(:),G1H24(22),m3h2x24(:,22),heltab2x48(:,:,92))
  call Hloop_AQ_V(ntryL,G1H48(77),ex3(:),G1H24(23),m3h2x24(:,23),heltab2x48(:,:,93))
  call Hloop_QA_V(ntryL,G1H48(78),ex4(:),G1H24(24),m3h2x24(:,24),heltab2x48(:,:,94))
  call Hloop_QA_V(ntryL,G1H48(79),ex4(:),G1H24(15),m3h2x24(:,25),heltab2x48(:,:,95))
  call Hloop_VQ_A(ntryL,G1H48(80),ex3(:),G1H24(21),m3h2x24(:,26),heltab2x48(:,:,96))
  call Hloop_Q_A(ntryL,G1H24(21),36,nMT,G2H24(8),n2h24(20))
  call Hloop_VQ_A(ntryL,G1H48(81),ex3(:),G1H24(2),m3h2x24(:,27),heltab2x48(:,:,97))
  call Hloop_Q_A(ntryL,G1H24(2),36,nMT,G2H24(9),n2h24(21))
  call Hloop_AQ_V(ntryL,G1H48(82),ex3(:),G1H24(9),m3h2x24(:,28),heltab2x48(:,:,98))
  call Hloop_AQ_V(ntryL,G1H48(83),ex3(:),G1H24(5),m3h2x24(:,29),heltab2x48(:,:,99))
  call Hloop_QA_V(ntryL,G1H48(84),ex4(:),G1H24(1),m3h2x24(:,30),heltab2x48(:,:,100))
  call Hloop_QA_V(ntryL,G1H48(85),ex4(:),G1H24(6),m3h2x24(:,31),heltab2x48(:,:,101))
  call Hloop_VQ_A(ntryL,G1H48(86),ex3(:),G1H24(7),m3h2x24(:,32),heltab2x48(:,:,102))
  call Hloop_Q_A(ntryL,G1H24(7),36,nMT,G2H24(10),n2h24(22))
  call Hloop_VQ_A(ntryL,G1H48(87),ex3(:),G1H24(8),m3h2x24(:,33),heltab2x48(:,:,103))
  call Hloop_Q_A(ntryL,G1H24(8),36,nMT,G2H24(11),n2h24(23))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G2H6(2)])
call HGT_lower_alpha_w2_OLR(G2H6(3),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(3),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(3),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G2H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(1),[G2H6(8),G1H6(15)])
call HGT_lower_alpha_w2_OLR(G2H6(4),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(4),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(4),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G2H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G1H12(21)])
call HGT_w2_OLR(G1H12(2),1,1,12)
call HGT_w2_invQ_OLR(G1H12(2),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(11),G2H6(10),G2H6(6),G1H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(14),[G1H12(27)])
call HGT_w2_OLR(G1H12(4),1,1,12)
call HGT_w2_invQ_OLR(G1H12(4),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(12),[G1H6(11),G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G1H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(3),[G1H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(11),[G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(8),[G1H6(7),G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(12),[G1H12(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(25),[G2H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(26),[G2H12(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(27),[G2H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(28),[G2H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(29),[G2H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(30),[G2H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(31),[G2H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(32),[G2H12(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(41),[G2H12(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(42),[G2H12(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(43),[G2H12(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(44),[G2H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(45),[G2H12(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(46),[G2H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(47),[G2H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(48),[G2H12(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(50),[G2H12(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(52),[G2H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(54),[G2H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(56),[G2H12(55)])
  call Hotf_4pt_reduction(G2H6(3),RedSet_4(37),mass4set(:,5),  & 
G1H6(13),G1H6(14),G1H6(19),G1H6(24),G1H6(20),6)
  call HG1shiftOLR(G1H6(14),4,6)
  call Hloop_AQ_V(ntryL,G2H4(2),ex3(:),G2H2(9),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hotf_4pt_reduction(G2H6(4),RedSet_4(12),mass4set(:,5),  & 
G1H6(23),G1H6(25),G1H6(28),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(25),8,6)
  call Hloop_QA_V(ntryL,G2H4(6),ex4(:),G2H2(11),m3h2x2(:,8),heltab2x4(:,:,8))
call HGT_w2_OLR(G1H12(13),1,1,12)
call HGT_w2_invQ_OLR(G1H12(13),2,5,12)
  call Hloop_QZ_A(ntryL,G1H12(13),ex5(:),G1H4(7),ngZu,m3h3x4(:,15),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(7),60,nMT,G2H4(2),n2h4(11))
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(10),mass4set(:,1),  & 
G1H8(21),G1H8(22),G1H8(1),G1H8(2),G1H8(7),8)
  call HG1shiftOLR(G1H8(22),8,8)
call HGT_w2_OLR(G1H12(1),1,1,12)
call HGT_w2_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_QZ_A(ntryL,G1H12(1),ex5(:),G1H4(7),ngZu,m3h3x4(:,16),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(7),60,nMT,G2H4(6),n2h4(12))
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(10),mass4set(:,1),  & 
G1H8(12),G1H8(8),G1H8(11),G1H8(13),G1H8(16),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hloop_QV_A(ntryL,G1H12(2),wf4(:,1),G1H3(9),m3h4x3(:,13),heltab2x12(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(9),47,nMT,G2H3(4),n2h3(19))
  call Hotf_4pt_reduction(G2H6(12),RedSet_4(13),mass4set(:,1),  & 
G1H6(1),G1H6(2),G1H6(5),G1H6(6),G1H6(15),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hloop_QZ_A(ntryL,G1H12(4),wf4(:,5),G1H3(20),ngZu,m3h4x3(:,14),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G1H3(20),47,nMT,G2H3(6),n2h3(20))
  call Hloop_VQ_A(ntryL,G1H6(3),ex3(:),G1H3(31),m3h2x3(:,10),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(31),47,nMT,G2H3(13),n2h3(21))
  call Hloop_VQ_A(ntryL,G1H6(12),ex3(:),G1H3(42),m3h2x3(:,11),heltab2x6(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(42),47,nMT,G2H3(15),n2h3(22))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,1),G1H3(4),m3h4x3(:,15),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G1H3(4),47,nMT,G2H3(1),n2h3(23))
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(28),mass4set(:,2),  & 
G1H12(17),G1H12(18),G1H12(19),G1H12(20),G1H12(23),G0H12(1),12)
  call HG1shiftOLR(G1H12(18),16,12)
  call Hloop_AZ_Q(ntryL,G1H12(11),wf4(:,5),G1H3(5),ngZu,m3h4x3(:,16),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(5),47,nMT,G2H3(3),n2h3(24))
  call Hotf_4pt_reduction(G2H12(10),RedSet_4(28),mass4set(:,2),  & 
G1H12(24),G1H12(25),G1H12(26),G1H12(29),G1H12(30),G0H12(2),12)
  call HG1shiftOLR(G1H12(25),16,12)
  call Hloop_VA_Q(ntryL,G1H6(9),ex4(:),G1H3(10),m3h2x3(:,12),heltab2x6(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(10),47,nMT,G2H3(7),n2h3(25))
  call Hloop_VA_Q(ntryL,G1H6(8),ex4(:),G1H3(11),m3h2x3(:,13),heltab2x6(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(11),47,nMT,G2H3(9),n2h3(26))
  call Hotf_4pt_reduction(G2H12(7),RedSet_4(28),mass4set(:,2),  & 
G1H12(3),G1H12(9),G1H12(5),G1H12(6),G1H12(21),G0H12(3),12)
  call HG1shiftOLR(G1H12(9),16,12)
  call Hotf_4pt_reduction(G2H12(12),RedSet_4(28),mass4set(:,2),  & 
G1H12(12),G1H12(27),G1H12(14),G1H12(7),G1H12(8),G0H12(4),12)
  call HG1shiftOLR(G1H12(27),16,12)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(9),mass4set(:,5),  & 
G1H8(17),G1H8(18),G1H8(23),G1H8(28),G1H8(24),8)
  call HG1shiftOLR(G1H8(18),8,8)
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,1),G1H2(6),m3h4x2(:,11),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMT,G2H2(1),n2h2(16))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,1),G1H2(17),m3h4x2(:,12),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(3),n2h2(17))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,1),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(4),n2h2(18))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,1),G1H2(2),m3h4x2(:,14),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(6),n2h2(19))
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(9),mass4set(:,5),  & 
G1H8(27),G1H8(29),G1H8(32),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(29),8,8)
  call Hloop_QZ_A(ntryL,G1H8(25),wf4(:,5),G1H2(7),ngZu,m3h4x2(:,15),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMT,G2H2(14),n2h2(20))
  call Hloop_QZ_A(ntryL,G1H8(26),wf4(:,5),G1H2(8),ngZu,m3h4x2(:,16),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(16),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H8(30),wf4(:,5),G1H2(12),ngZu,m3h4x2(:,17),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMT,G2H2(19),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H8(31),wf4(:,5),G1H2(13),ngZu,m3h4x2(:,18),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(21),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H6(21),ex5(:),G1H2(18),ngZu,m3h3x2(:,8),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMT,G2H2(24),n2h2(24))
  call Hloop_QZ_A(ntryL,G1H6(22),ex5(:),G1H2(19),ngZu,m3h3x2(:,9),heltab2x6(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(19),55,nMT,G2H2(25),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H6(26),ex5(:),G1H2(6),ngZu,m3h3x2(:,10),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMT,G2H2(26),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H6(27),ex5(:),G1H2(17),ngZu,m3h3x2(:,11),heltab2x6(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(27),n2h2(27))
  call Hloop_AQ_V(ntryL,G2H4(7),ex3(:),G2H2(28),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(29),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(28),mass4set(:,6),  & 
G1H12(15),G1H12(16),G1H12(22),G1H12(28),G1H12(13),G0H12(5),12)
  call HG1shiftOLR(G1H12(16),16,12)
  call Hotf_4pt_reduction(G2H12(5),RedSet_4(28),mass4set(:,6),  & 
G1H12(1),G1H12(2),G1H12(4),G1H12(10),G1H12(11),G0H12(6),12)
  call HG1shiftOLR(G1H12(2),16,12)
  call Hotf_4pt_reduction(G2H12(6),RedSet_4(28),mass4set(:,6),  & 
G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),G0H12(7),12)
  call HG1shiftOLR(G1H12(32),16,12)
  call Hotf_4pt_reduction(G2H12(8),RedSet_4(28),mass4set(:,7),  & 
G1H12(36),G1H12(37),G1H12(38),G1H12(39),G1H12(40),G0H12(8),12)
  call HG1shiftOLR(G1H12(37),16,12)
  call Hotf_4pt_reduction(G2H12(2),RedSet_4(28),mass4set(:,6),  & 
G1H12(41),G1H12(42),G1H12(43),G1H12(44),G1H12(45),G0H12(9),12)
  call HG1shiftOLR(G1H12(42),16,12)
  call Hotf_4pt_reduction(G2H12(4),RedSet_4(28),mass4set(:,7),  & 
G1H12(46),G1H12(47),G1H12(48),G1H12(49),G1H12(50),G0H12(10),12)
  call HG1shiftOLR(G1H12(47),16,12)
  call Hotf_4pt_reduction(G2H12(9),RedSet_4(28),mass4set(:,6),  & 
G1H12(51),G1H12(52),G1H12(53),G1H12(54),G1H12(55),G0H12(11),12)
  call HG1shiftOLR(G1H12(52),16,12)
  call Hotf_4pt_reduction(G2H12(11),RedSet_4(28),mass4set(:,6),  & 
G1H12(56),G1H12(57),G1H12(58),G1H12(59),G1H12(60),G0H12(12),12)
  call HG1shiftOLR(G1H12(57),16,12)
  call Hotf_4pt_reduction(G2H12(13),RedSet_4(28),mass4set(:,6),  & 
G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),G0H12(13),12)
  call HG1shiftOLR(G1H12(62),16,12)
  call Hotf_4pt_reduction(G2H12(14),RedSet_4(28),mass4set(:,7),  & 
G1H12(66),G1H12(67),G1H12(68),G1H12(69),G1H12(70),G0H12(14),12)
  call HG1shiftOLR(G1H12(67),16,12)
  call Hotf_4pt_reduction(G2H12(15),RedSet_4(28),mass4set(:,6),  & 
G1H12(71),G1H12(72),G1H12(73),G1H12(74),G1H12(75),G0H12(15),12)
  call HG1shiftOLR(G1H12(72),16,12)
  call Hotf_4pt_reduction(G2H12(16),RedSet_4(28),mass4set(:,7),  & 
G1H12(76),G1H12(77),G1H12(78),G1H12(79),G1H12(80),G0H12(16),12)
  call HG1shiftOLR(G1H12(77),16,12)
  call Hotf_4pt_reduction(G2H12(25),RedSet_4(25),mass4set(:,6),  & 
G1H12(81),G1H12(82),G1H12(83),G1H12(84),G1H12(85),G0H12(17),12)
  call HG1shiftOLR(G1H12(82),16,12)
  call Hotf_4pt_reduction(G2H12(26),RedSet_4(25),mass4set(:,2),  & 
G1H12(86),G1H12(87),G1H12(88),G1H12(89),G1H12(90),G0H12(18),12)
  call HG1shiftOLR(G1H12(87),16,12)
  call Hotf_4pt_reduction(G2H12(27),RedSet_4(25),mass4set(:,6),  & 
G1H12(91),G1H12(92),G1H12(93),G1H12(94),G1H12(95),G0H12(19),12)
  call HG1shiftOLR(G1H12(92),16,12)
  call Hotf_4pt_reduction(G2H12(28),RedSet_4(25),mass4set(:,2),  & 
G1H12(96),G1H12(97),G1H12(98),G1H12(99),G1H12(100),G0H12(20),12)
  call HG1shiftOLR(G1H12(97),16,12)
  call Hotf_4pt_reduction(G2H12(29),RedSet_4(25),mass4set(:,6),  & 
G1H12(101),G1H12(102),G1H12(103),G1H12(104),G1H12(105),G0H12(21),12)
  call HG1shiftOLR(G1H12(102),16,12)
  call Hotf_4pt_reduction(G2H12(30),RedSet_4(25),mass4set(:,7),  & 
G1H12(106),G1H12(107),G1H12(108),G1H12(109),G1H12(110),G0H12(22),12)
  call HG1shiftOLR(G1H12(107),16,12)
  call Hotf_4pt_reduction(G2H12(31),RedSet_4(25),mass4set(:,6),  & 
G1H12(111),G1H12(112),G1H12(113),G1H12(114),G1H12(115),G0H12(23),12)
  call HG1shiftOLR(G1H12(112),16,12)
  call Hotf_4pt_reduction(G2H12(32),RedSet_4(25),mass4set(:,7),  & 
G1H12(116),G1H12(117),G1H12(118),G1H12(119),G1H12(120),G0H12(24),12)
  call HG1shiftOLR(G1H12(117),16,12)
  call Hotf_4pt_reduction(G2H12(41),RedSet_4(4),mass4set(:,6),  & 
G1H12(121),G1H12(122),G1H12(123),G1H12(124),G1H12(125),G0H12(25),12)
  call HG1shiftOLR(G1H12(122),12,12)
  call Hotf_4pt_reduction(G2H12(42),RedSet_4(4),mass4set(:,2),  & 
G1H12(126),G1H12(127),G1H12(128),G1H12(129),G1H12(130),G0H12(26),12)
  call HG1shiftOLR(G1H12(127),12,12)
  call Hotf_4pt_reduction(G2H12(43),RedSet_4(4),mass4set(:,6),  & 
G1H12(131),G1H12(132),G1H12(133),G1H12(134),G1H12(135),G0H12(27),12)
  call HG1shiftOLR(G1H12(132),12,12)
  call Hotf_4pt_reduction(G2H12(44),RedSet_4(4),mass4set(:,2),  & 
G1H12(136),G1H12(137),G1H12(138),G1H12(139),G1H12(140),G0H12(28),12)
  call HG1shiftOLR(G1H12(137),12,12)
  call Hotf_4pt_reduction(G2H12(45),RedSet_4(4),mass4set(:,6),  & 
G1H12(141),G1H12(142),G1H12(143),G1H12(144),G1H12(145),G0H12(29),12)
  call HG1shiftOLR(G1H12(142),12,12)
  call Hotf_4pt_reduction(G2H12(46),RedSet_4(4),mass4set(:,7),  & 
G1H12(146),G1H12(147),G1H12(148),G1H12(149),G1H12(150),G0H12(30),12)
  call HG1shiftOLR(G1H12(147),12,12)
  call Hotf_4pt_reduction(G2H12(47),RedSet_4(4),mass4set(:,6),  & 
G1H12(151),G1H12(152),G1H12(153),G1H12(154),G1H12(155),G0H12(31),12)
  call HG1shiftOLR(G1H12(152),12,12)
  call Hotf_4pt_reduction(G2H12(48),RedSet_4(4),mass4set(:,7),  & 
G1H12(156),G1H12(157),G1H12(158),G1H12(159),G1H12(160),G0H12(32),12)
  call HG1shiftOLR(G1H12(157),12,12)
  call Hotf_4pt_reduction(G2H24(1),RedSet_4(38),mass4set(:,1),  & 
G1H24(10),G1H24(3),G1H24(4),G1H24(13),G1H24(14),24)
  call HG1shiftOLR(G1H24(3),20,24)
  call Hotf_4pt_reduction(G2H24(2),RedSet_4(38),mass4set(:,1),  & 
G1H24(20),G1H24(21),G1H24(2),G1H24(7),G1H24(8),24)
  call HG1shiftOLR(G1H24(21),20,24)
  call Hloop_AQ_V(ntryL,G2H12(50),wf6(:,2),G2H2(30),m3h6x2(:,1),heltab2x12(:,:,37))
  call Hloop_QA_V(ntryL,G2H12(52),ex4(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,38))
  call Hotf_4pt_reduction(G2H24(3),RedSet_4(3),mass4set(:,1),  & 
G1H24(25),G1H24(26),G1H24(27),G1H24(28),G1H24(29),24)
  call HG1shiftOLR(G1H24(26),24,24)
  call Hotf_4pt_reduction(G2H24(4),RedSet_4(3),mass4set(:,1),  & 
G1H24(30),G1H24(31),G1H24(32),G1H24(33),G1H24(34),24)
  call HG1shiftOLR(G1H24(31),24,24)
  call Hloop_QA_V(ntryL,G2H12(54),wf6(:,4),G2H2(31),m3h6x2(:,2),heltab2x12(:,:,39))
  call Hloop_AQ_V(ntryL,G2H12(56),ex3(:),G2H6(7),m3h2x6(:,6),heltab2x12(:,:,40))
  call Hloop_VQ_A(ntryL,G1H24(11),wf8(:,6),G1H3(15),m3h8x3(:,1),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(15),47,nMT,G2H3(10),n2h3(27))
  call Hloop_VQ_A(ntryL,G1H24(12),wf8(:,8),G1H3(16),m3h8x3(:,2),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(16),47,nMT,G2H3(12),n2h3(28))
  call Hotf_4pt_reduction(G2H24(5),RedSet_4(2),mass4set(:,1),  & 
G1H24(11),G1H24(12),G1H24(35),G1H24(36),G1H24(37),24)
  call HG1shiftOLR(G1H24(12),11,24)
  call Hotf_4pt_reduction(G2H24(6),RedSet_4(2),mass4set(:,1),  & 
G1H24(38),G1H24(39),G1H24(40),G1H24(41),G1H24(42),24)
  call HG1shiftOLR(G1H24(39),11,24)
  call Hloop_VA_Q(ntryL,G1H24(16),wf8(:,2),G1H3(21),m3h8x3(:,3),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(21),47,nMT,G2H3(16),n2h3(29))
  call Hloop_VA_Q(ntryL,G1H24(17),wf8(:,4),G1H3(22),m3h8x3(:,4),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H3(22),47,nMT,G2H3(18),n2h3(30))
  call Hloop_VA_Q(ntryL,G1H24(18),ex4(:),G1H12(161),m3h2x12(:,13),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G1H12(161),44,nMT,G2H12(17),n2h12(79))
  call Hloop_VQ_A(ntryL,G1H24(19),ex3(:),G1H12(161),m3h2x12(:,14),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H12(161),44,nMT,G2H12(18),n2h12(80))
  call Hotf_4pt_reduction(G2H24(7),RedSet_4(1),mass4set(:,1),  & 
G1H24(16),G1H24(17),G1H24(18),G1H24(19),G1H24(43),24)
  call HG1shiftOLR(G1H24(17),8,24)
  call Hloop_VA_Q(ntryL,G1H24(22),ex4(:),G1H12(161),m3h2x12(:,15),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G1H12(161),44,nMT,G2H12(19),n2h12(81))
  call Hloop_VA_Q(ntryL,G1H24(23),ex4(:),G1H12(161),m3h2x12(:,16),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H12(161),44,nMT,G2H12(20),n2h12(82))
  call Hloop_VQ_A(ntryL,G1H24(24),ex3(:),G1H12(161),m3h2x12(:,17),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G1H12(161),44,nMT,G2H12(21),n2h12(83))
  call Hloop_VQ_A(ntryL,G1H24(15),ex3(:),G1H12(161),m3h2x12(:,18),heltab2x24(:,:,44))
  call Hloop_Q_A(ntryL,G1H12(161),44,nMT,G2H12(22),n2h12(84))
  call Hotf_4pt_reduction(G2H24(8),RedSet_4(1),mass4set(:,1),  & 
G1H24(22),G1H24(23),G1H24(24),G1H24(15),G1H24(44),24)
  call HG1shiftOLR(G1H24(23),8,24)
  call Hotf_4pt_reduction(G2H24(9),RedSet_4(1),mass4set(:,1),  & 
G1H24(45),G1H24(46),G1H24(47),G1H24(48),G1H24(49),24)
  call HG1shiftOLR(G1H24(46),8,24)
  call Hloop_VA_Q(ntryL,G1H24(9),ex4(:),G1H12(161),m3h2x12(:,19),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G1H12(161),44,nMT,G2H12(23),n2h12(85))
  call Hloop_VA_Q(ntryL,G1H24(5),ex4(:),G1H12(161),m3h2x12(:,20),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G1H12(161),44,nMT,G2H12(24),n2h12(86))
  call Hloop_VQ_A(ntryL,G1H24(1),ex3(:),G1H12(161),m3h2x12(:,21),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G1H12(161),44,nMT,G2H12(33),n2h12(87))
  call Hloop_VQ_A(ntryL,G1H24(6),ex3(:),G1H12(161),m3h2x12(:,22),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G1H12(161),44,nMT,G2H12(34),n2h12(88))
  call Hotf_4pt_reduction(G2H24(10),RedSet_4(1),mass4set(:,1),  & 
G1H24(9),G1H24(5),G1H24(1),G1H24(6),G1H24(50),24)
  call HG1shiftOLR(G1H24(5),8,24)
  call Hotf_4pt_reduction(G2H24(11),RedSet_4(1),mass4set(:,1),  & 
G1H24(51),G1H24(52),G1H24(53),G1H24(54),G1H24(55),24)
  call HG1shiftOLR(G1H24(52),8,24)
  call Hloop_AZ_Q(ntryL,G1H6(13),ex5(:),G1H2(1),ngZu,m3h3x2(:,12),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(32),n2h2(28))
call HGT_raise_alpha_OLR(G1H6(14),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(14),ex3(:),G1H3(26),m3h2x3(:,14),heltab2x6(:,:,26))
  call Hloop_AZ_Q(ntryL,G1H6(24),ex5(:),G1H2(2),ngZu,m3h3x2(:,13),heltab2x6(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(2),59,nMT,G2H2(33),n2h2(29))
  call Hloop_AZ_Q(ntryL,G1H6(20),ex5(:),G1H2(7),ngZu,m3h3x2(:,14),heltab2x6(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(7),59,nMT,G2H2(34),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H6(23),ex5(:),G1H2(8),ngZu,m3h3x2(:,15),heltab2x6(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(35),n2h2(31))
call HGT_raise_alpha_OLR(G1H6(25),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(25),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(25),ex4(:),G1H3(27),m3h2x3(:,15),heltab2x6(:,:,30))
  call Hloop_QZ_A(ntryL,G1H6(17),ex5(:),G1H2(12),ngZu,m3h3x2(:,16),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMT,G2H2(36),n2h2(32))
  call Hloop_QZ_A(ntryL,G1H6(18),ex5(:),G1H2(13),ngZu,m3h3x2(:,17),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(37),n2h2(33))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,1),G1H2(18),m3h4x2(:,19),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMT,G2H2(38),n2h2(34))
call HGT_raise_alpha_OLR(G1H8(22),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(22),ex4(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,26))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,1),G1H2(19),m3h4x2(:,20),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(19),55,nMT,G2H2(39),n2h2(35))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(6),m3h4x2(:,21),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMT,G2H2(40),n2h2(36))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,5),G1H2(17),ngZu,m3h4x2(:,22),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(41),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,30))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,5),G1H2(1),ngZu,m3h4x2(:,23),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(42),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H8(16),wf4(:,5),G1H2(2),ngZu,m3h4x2(:,24),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(43),n2h2(39))
  call Hloop_QZ_A(ntryL,G1H6(1),ex5(:),G1H2(7),ngZu,m3h3x2(:,18),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMT,G2H2(44),n2h2(40))
call HGT_raise_alpha_OLR(G1H6(2),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(2),ex4(:),G1H3(32),m3h2x3(:,16),heltab2x6(:,:,34))
  call Hloop_QZ_A(ntryL,G1H6(6),ex5(:),G1H2(8),ngZu,m3h3x2(:,19),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(45),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H6(15),ex5(:),G1H2(12),ngZu,m3h3x2(:,20),heltab2x6(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMT,G2H2(46),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H12(17),wf4(:,1),G1H3(33),m3h4x3(:,17),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(33),47,nMT,G2H3(19),n2h3(31))
call HGT_OLR(G1H12(18),1,1,12)
call HGT_invQ_OLR(G1H12(18),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(18),-16,nMT,G2H12(35),n2h12(89))
  call Hloop_QZ_A(ntryL,G2H12(35),ex5(:),G2H4(7),ngZu,m3h3x4(:,17),heltab2x12(:,:,42))
  call Hloop_AV_Q(ntryL,G1H12(20),wf4(:,1),G1H3(37),m3h4x3(:,18),heltab2x12(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(37),47,nMT,G2H3(20),n2h3(32))
  call Hloop_AV_Q(ntryL,G1H12(23),wf4(:,1),G1H3(38),m3h4x3(:,19),heltab2x12(:,:,44))
  call Hloop_A_Q(ntryL,G1H3(38),47,nMT,G2H3(21),n2h3(33))
  call Hloop_AV_Q(ntryL,G0H12(1),wf4(:,1),G0H3(1),m3h4x3(:,20),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMT,G1H3(43),n2h3(34))
  call Hloop_AZ_Q(ntryL,G1H12(24),wf4(:,5),G1H3(44),ngZu,m3h4x3(:,21),heltab2x12(:,:,46))
  call Hloop_A_Q(ntryL,G1H3(44),47,nMT,G2H3(22),n2h3(35))
call HGT_OLR(G1H12(25),1,1,12)
call HGT_invQ_OLR(G1H12(25),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(25),-16,nMT,G2H12(36),n2h12(90))
  call Hloop_QZ_A(ntryL,G2H12(36),ex5(:),G2H4(8),ngZu,m3h3x4(:,18),heltab2x12(:,:,47))
  call Hloop_AZ_Q(ntryL,G1H12(29),wf4(:,5),G1H3(9),ngZu,m3h4x3(:,22),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(9),47,nMT,G2H3(23),n2h3(36))
  call Hloop_AZ_Q(ntryL,G1H12(30),wf4(:,5),G1H3(20),ngZu,m3h4x3(:,23),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(20),47,nMT,G2H3(24),n2h3(37))
  call Hloop_AZ_Q(ntryL,G0H12(2),wf4(:,5),G0H3(1),ngZu,m3h4x3(:,24),heltab2x12(:,:,50))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMT,G1H3(31),n2h3(38))
  call Hloop_QV_A(ntryL,G1H12(3),wf4(:,1),G1H3(42),m3h4x3(:,25),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G1H3(42),47,nMT,G2H3(25),n2h3(39))
call HGT_OLR(G1H12(9),1,1,12)
call HGT_invQ_OLR(G1H12(9),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(9),-16,nMT,G2H12(37),n2h12(91))
  call Hloop_AZ_Q(ntryL,G2H12(37),ex5(:),G2H4(9),ngZu,m3h3x4(:,19),heltab2x12(:,:,52))
  call Hloop_QV_A(ntryL,G1H12(6),wf4(:,1),G1H3(4),m3h4x3(:,26),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(4),47,nMT,G2H3(26),n2h3(40))
  call Hloop_QV_A(ntryL,G1H12(21),wf4(:,1),G1H3(5),m3h4x3(:,27),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(5),47,nMT,G2H3(27),n2h3(41))
  call Hloop_QV_A(ntryL,G0H12(3),wf4(:,1),G0H3(1),m3h4x3(:,28),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMT,G1H3(10),n2h3(42))
  call Hloop_QZ_A(ntryL,G1H12(12),wf4(:,5),G1H3(11),ngZu,m3h4x3(:,29),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G1H3(11),47,nMT,G2H3(28),n2h3(43))
call HGT_OLR(G1H12(27),1,1,12)
call HGT_invQ_OLR(G1H12(27),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(27),-16,nMT,G2H12(38),n2h12(92))
  call Hloop_AZ_Q(ntryL,G2H12(38),ex5(:),G2H4(10),ngZu,m3h3x4(:,20),heltab2x12(:,:,57))
  call Hloop_QZ_A(ntryL,G1H12(7),wf4(:,5),G1H3(15),ngZu,m3h4x3(:,30),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(15),47,nMT,G2H3(29),n2h3(44))
  call Hloop_QZ_A(ntryL,G1H12(8),wf4(:,5),G1H3(16),ngZu,m3h4x3(:,31),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G1H3(16),47,nMT,G2H3(30),n2h3(45))
  call Hloop_QZ_A(ntryL,G0H12(4),wf4(:,5),G0H3(1),ngZu,m3h4x3(:,32),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMT,G1H3(21),n2h3(46))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,1),G1H2(13),m3h4x2(:,25),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(47),n2h2(43))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(9),m3h2x4(:,9),heltab2x8(:,:,34))
  call Hloop_QV_A(ntryL,G1H8(28),wf4(:,1),G1H2(18),m3h4x2(:,26),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMT,G2H2(48),n2h2(44))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,1),G1H2(19),m3h4x2(:,27),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(19),55,nMT,G2H2(49),n2h2(45))
  call Hloop_QZ_A(ntryL,G1H8(27),wf4(:,5),G1H2(6),ngZu,m3h4x2(:,28),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMT,G2H2(50),n2h2(46))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(29),ex4(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,38))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,5),G1H2(17),ngZu,m3h4x2(:,29),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(51),n2h2(47))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,5),G1H2(1),ngZu,m3h4x2(:,30),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(52),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H12(15),wf4(:,1),G1H3(22),m3h4x3(:,33),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H3(22),47,0,G2H3(31),n2h3(47))
call HGT_OLR(G1H12(16),1,1,12)
call HGT_invQ_OLR(G1H12(16),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(16),-16,0,G2H12(39),n2h12(93))
  call Hloop_QZ_A(ntryL,G2H12(39),ex5(:),G2H4(11),ngZu,m3h3x4(:,21),heltab2x12(:,:,62))
  call Hloop_AV_Q(ntryL,G1H12(28),wf4(:,1),G1H3(33),m3h4x3(:,34),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H3(33),47,0,G2H3(32),n2h3(48))
  call Hloop_AV_Q(ntryL,G1H12(13),wf4(:,1),G1H3(37),m3h4x3(:,35),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H3(37),47,0,G2H3(33),n2h3(49))
  call Hloop_AV_Q(ntryL,G0H12(5),wf4(:,1),G0H3(1),m3h4x3(:,36),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(38),n2h3(50))
  call Hloop_QV_A(ntryL,G1H12(1),wf4(:,1),G1H3(44),m3h4x3(:,37),heltab2x12(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(44),47,0,G2H3(34),n2h3(51))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(2),-16,0,G2H12(40),n2h12(94))
  call Hloop_AZ_Q(ntryL,G2H12(40),ex5(:),G2H4(12),ngZu,m3h3x4(:,22),heltab2x12(:,:,67))
  call Hloop_QV_A(ntryL,G1H12(10),wf4(:,1),G1H3(9),m3h4x3(:,38),heltab2x12(:,:,68))
  call Hloop_Q_A(ntryL,G1H3(9),47,0,G2H3(35),n2h3(52))
  call Hloop_QV_A(ntryL,G1H12(11),wf4(:,1),G1H3(20),m3h4x3(:,39),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G1H3(20),47,0,G2H3(36),n2h3(53))
  call Hloop_QV_A(ntryL,G0H12(6),wf4(:,1),G0H3(1),m3h4x3(:,40),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(42),n2h3(54))
  call Hloop_AV_Q(ntryL,G1H12(31),wf4(:,1),G1H3(4),m3h4x3(:,41),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H3(4),47,0,G2H3(37),n2h3(55))
call HGT_OLR(G1H12(32),1,1,12)
call HGT_invQ_OLR(G1H12(32),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(32),-16,0,G2H12(49),n2h12(95))
  call Hloop_QZ_A(ntryL,G2H12(49),ex5(:),G2H4(13),ngZd,m3h3x4(:,23),heltab2x12(:,:,72))
  call Hloop_AV_Q(ntryL,G1H12(34),wf4(:,1),G1H3(5),m3h4x3(:,42),heltab2x12(:,:,73))
  call Hloop_A_Q(ntryL,G1H3(5),47,0,G2H3(38),n2h3(56))
  call Hloop_AV_Q(ntryL,G1H12(35),wf4(:,1),G1H3(11),m3h4x3(:,43),heltab2x12(:,:,74))
  call Hloop_A_Q(ntryL,G1H3(11),47,0,G2H3(39),n2h3(57))
  call Hloop_AV_Q(ntryL,G0H12(7),wf4(:,1),G0H3(1),m3h4x3(:,44),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(15),n2h3(58))
  call Hloop_AV_Q(ntryL,G1H12(36),wf4(:,1),G1H3(16),m3h4x3(:,45),heltab2x12(:,:,76))
  call Hloop_A_Q(ntryL,G1H3(16),47,nMB,G2H3(40),n2h3(59))
call HGT_OLR(G1H12(37),1,1,12)
call HGT_invQ_OLR(G1H12(37),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(37),-16,nMB,G2H12(51),n2h12(96))
  call Hloop_QZ_A(ntryL,G2H12(51),ex5(:),G2H4(14),ngZd,m3h3x4(:,24),heltab2x12(:,:,77))
  call Hloop_AV_Q(ntryL,G1H12(39),wf4(:,1),G1H3(22),m3h4x3(:,46),heltab2x12(:,:,78))
  call Hloop_A_Q(ntryL,G1H3(22),47,nMB,G2H3(41),n2h3(60))
  call Hloop_AV_Q(ntryL,G1H12(40),wf4(:,1),G1H3(33),m3h4x3(:,47),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G1H3(33),47,nMB,G2H3(42),n2h3(61))
  call Hloop_AV_Q(ntryL,G0H12(8),wf4(:,1),G0H3(1),m3h4x3(:,48),heltab2x12(:,:,80))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMB,G1H3(37),n2h3(62))
  call Hloop_QV_A(ntryL,G1H12(41),wf4(:,1),G1H3(44),m3h4x3(:,49),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(44),47,0,G2H3(43),n2h3(63))
call HGT_OLR(G1H12(42),1,1,12)
call HGT_invQ_OLR(G1H12(42),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(42),-16,0,G2H12(53),n2h12(97))
  call Hloop_AZ_Q(ntryL,G2H12(53),ex5(:),G2H4(15),ngZd,m3h3x4(:,25),heltab2x12(:,:,82))
  call Hloop_QV_A(ntryL,G1H12(44),wf4(:,1),G1H3(9),m3h4x3(:,50),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(9),47,0,G2H3(44),n2h3(64))
  call Hloop_QV_A(ntryL,G1H12(45),wf4(:,1),G1H3(20),m3h4x3(:,51),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G1H3(20),47,0,G2H3(45),n2h3(65))
  call Hloop_QV_A(ntryL,G0H12(9),wf4(:,1),G0H3(1),m3h4x3(:,52),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(4),n2h3(66))
  call Hloop_QV_A(ntryL,G1H12(46),wf4(:,1),G1H3(5),m3h4x3(:,53),heltab2x12(:,:,86))
  call Hloop_Q_A(ntryL,G1H3(5),47,nMB,G2H3(46),n2h3(67))
call HGT_OLR(G1H12(47),1,1,12)
call HGT_invQ_OLR(G1H12(47),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(47),-16,nMB,G2H12(55),n2h12(98))
  call Hloop_AZ_Q(ntryL,G2H12(55),ex5(:),G2H4(16),ngZd,m3h3x4(:,26),heltab2x12(:,:,87))
  call Hloop_QV_A(ntryL,G1H12(49),wf4(:,1),G1H3(11),m3h4x3(:,54),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G1H3(11),47,nMB,G2H3(47),n2h3(68))
  call Hloop_QV_A(ntryL,G1H12(50),wf4(:,1),G1H3(16),m3h4x3(:,55),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G1H3(16),47,nMB,G2H3(48),n2h3(69))
  call Hloop_QV_A(ntryL,G0H12(10),wf4(:,1),G0H3(1),m3h4x3(:,56),heltab2x12(:,:,90))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMB,G1H3(22),n2h3(70))
  call Hloop_AZ_Q(ntryL,G1H12(51),wf4(:,5),G1H3(33),ngZu,m3h4x3(:,57),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(33),47,0,G2H3(49),n2h3(71))
call HGT_OLR(G1H12(52),1,1,12)
call HGT_invQ_OLR(G1H12(52),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(52),-16,0,G2H12(3),n2h12(99))
  call Hloop_QZ_A(ntryL,G2H12(3),ex5(:),G2H4(17),ngZu,m3h3x4(:,27),heltab2x12(:,:,92))
  call Hloop_AZ_Q(ntryL,G1H12(54),wf4(:,5),G1H3(44),ngZu,m3h4x3(:,58),heltab2x12(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(44),47,0,G2H3(50),n2h3(72))
  call Hloop_AZ_Q(ntryL,G1H12(55),wf4(:,5),G1H3(9),ngZu,m3h4x3(:,59),heltab2x12(:,:,94))
  call Hloop_A_Q(ntryL,G1H3(9),47,0,G2H3(51),n2h3(73))
  call Hloop_AZ_Q(ntryL,G0H12(11),wf4(:,5),G0H3(1),ngZu,m3h4x3(:,60),heltab2x12(:,:,95))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(20),n2h3(74))
  call Hloop_QZ_A(ntryL,G1H12(56),wf4(:,5),G1H3(5),ngZu,m3h4x3(:,61),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H3(5),47,0,G2H3(52),n2h3(75))
call HGT_OLR(G1H12(57),1,1,12)
call HGT_invQ_OLR(G1H12(57),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(57),-16,0,G2H12(10),n2h12(100))
  call Hloop_AZ_Q(ntryL,G2H12(10),ex5(:),G2H4(18),ngZu,m3h3x4(:,28),heltab2x12(:,:,97))
  call Hloop_QZ_A(ntryL,G1H12(59),wf4(:,5),G1H3(11),ngZu,m3h4x3(:,62),heltab2x12(:,:,98))
  call Hloop_Q_A(ntryL,G1H3(11),47,0,G2H3(53),n2h3(76))
  call Hloop_QZ_A(ntryL,G1H12(60),wf4(:,5),G1H3(16),ngZu,m3h4x3(:,63),heltab2x12(:,:,99))
  call Hloop_Q_A(ntryL,G1H3(16),47,0,G2H3(54),n2h3(77))
  call Hloop_QZ_A(ntryL,G0H12(12),wf4(:,5),G0H3(1),ngZu,m3h4x3(:,64),heltab2x12(:,:,100))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(33),n2h3(78))
  call Hloop_AZ_Q(ntryL,G1H12(61),wf4(:,5),G1H3(44),ngZd,m3h4x3(:,65),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(44),47,0,G2H3(55),n2h3(79))
call HGT_OLR(G1H12(62),1,1,12)
call HGT_invQ_OLR(G1H12(62),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(62),-16,0,G2H12(7),n2h12(101))
  call Hloop_QZ_A(ntryL,G2H12(7),ex5(:),G2H4(19),ngZd,m3h3x4(:,29),heltab2x12(:,:,102))
  call Hloop_AZ_Q(ntryL,G1H12(64),wf4(:,5),G1H3(9),ngZd,m3h4x3(:,66),heltab2x12(:,:,103))
  call Hloop_A_Q(ntryL,G1H3(9),47,0,G2H3(56),n2h3(80))
  call Hloop_AZ_Q(ntryL,G1H12(65),wf4(:,5),G1H3(5),ngZd,m3h4x3(:,67),heltab2x12(:,:,104))
  call Hloop_A_Q(ntryL,G1H3(5),47,0,G2H3(57),n2h3(81))
  call Hloop_AZ_Q(ntryL,G0H12(13),wf4(:,5),G0H3(1),ngZd,m3h4x3(:,68),heltab2x12(:,:,105))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(11),n2h3(82))
  call Hloop_AZ_Q(ntryL,G1H12(66),wf4(:,5),G1H3(16),ngZd,m3h4x3(:,69),heltab2x12(:,:,106))
  call Hloop_A_Q(ntryL,G1H3(16),47,nMB,G2H3(58),n2h3(83))
call HGT_OLR(G1H12(67),1,1,12)
call HGT_invQ_OLR(G1H12(67),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(67),-16,nMB,G2H12(12),n2h12(102))
  call Hloop_QZ_A(ntryL,G2H12(12),ex5(:),G2H4(20),ngZd,m3h3x4(:,30),heltab2x12(:,:,107))
  call Hloop_AZ_Q(ntryL,G1H12(69),wf4(:,5),G1H3(44),ngZd,m3h4x3(:,70),heltab2x12(:,:,108))
  call Hloop_A_Q(ntryL,G1H3(44),47,nMB,G2H3(59),n2h3(84))
  call Hloop_AZ_Q(ntryL,G1H12(70),wf4(:,5),G1H3(9),ngZd,m3h4x3(:,71),heltab2x12(:,:,109))
  call Hloop_A_Q(ntryL,G1H3(9),47,nMB,G2H3(60),n2h3(85))
  call Hloop_AZ_Q(ntryL,G0H12(14),wf4(:,5),G0H3(1),ngZd,m3h4x3(:,72),heltab2x12(:,:,110))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMB,G1H3(5),n2h3(86))
  call Hloop_QZ_A(ntryL,G1H12(71),wf4(:,5),G1H3(16),ngZd,m3h4x3(:,73),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G1H3(16),47,0,G2H3(61),n2h3(87))
call HGT_OLR(G1H12(72),1,1,12)
call HGT_invQ_OLR(G1H12(72),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(72),-16,0,G2H12(1),n2h12(103))
  call Hloop_AZ_Q(ntryL,G2H12(1),ex5(:),G2H4(21),ngZd,m3h3x4(:,31),heltab2x12(:,:,112))
  call Hloop_QZ_A(ntryL,G1H12(74),wf4(:,5),G1H3(44),ngZd,m3h4x3(:,74),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H3(44),47,0,G2H3(62),n2h3(88))
  call Hloop_QZ_A(ntryL,G1H12(75),wf4(:,5),G1H3(9),ngZd,m3h4x3(:,75),heltab2x12(:,:,114))
  call Hloop_Q_A(ntryL,G1H3(9),47,0,G2H3(63),n2h3(89))
  call Hloop_QZ_A(ntryL,G0H12(15),wf4(:,5),G0H3(1),ngZd,m3h4x3(:,76),heltab2x12(:,:,115))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(16),n2h3(90))
  call Hloop_QZ_A(ntryL,G1H12(76),wf4(:,5),G1H3(44),ngZd,m3h4x3(:,77),heltab2x12(:,:,116))
  call Hloop_Q_A(ntryL,G1H3(44),47,nMB,G2H3(64),n2h3(91))
call HGT_OLR(G1H12(77),1,1,12)
call HGT_invQ_OLR(G1H12(77),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(77),-16,nMB,G2H12(5),n2h12(104))
  call Hloop_AZ_Q(ntryL,G2H12(5),ex5(:),G2H4(22),ngZd,m3h3x4(:,32),heltab2x12(:,:,117))
  call Hloop_QZ_A(ntryL,G1H12(79),wf4(:,5),G1H3(9),ngZd,m3h4x3(:,78),heltab2x12(:,:,118))
  call Hloop_Q_A(ntryL,G1H3(9),47,nMB,G2H3(65),n2h3(92))
  call Hloop_QZ_A(ntryL,G1H12(80),wf4(:,5),G1H3(44),ngZd,m3h4x3(:,79),heltab2x12(:,:,119))
  call Hloop_Q_A(ntryL,G1H3(44),47,nMB,G2H3(66),n2h3(93))
  call Hloop_QZ_A(ntryL,G0H12(16),wf4(:,5),G0H3(1),ngZd,m3h4x3(:,80),heltab2x12(:,:,120))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMB,G1H3(9),n2h3(94))
  call Hloop_AV_Q(ntryL,G1H12(81),wf4(:,8),G1H3(44),m3h4x3(:,81),heltab2x12(:,:,121))
  call Hloop_A_Q(ntryL,G1H3(44),47,0,G2H3(67),n2h3(95))
call HGT_OLR(G1H12(82),1,1,12)
call HGT_invQ_OLR(G1H12(82),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(82),-16,0,G2H12(6),n2h12(105))
  call Hloop_QZ_A(ntryL,G2H12(6),ex5(:),G2H4(23),ngZu,m3h3x4(:,33),heltab2x12(:,:,122))
  call Hloop_AV_Q(ntryL,G1H12(84),wf4(:,8),G1H3(44),m3h4x3(:,82),heltab2x12(:,:,123))
  call Hloop_A_Q(ntryL,G1H3(44),47,0,G2H3(68),n2h3(96))
  call Hloop_AV_Q(ntryL,G1H12(85),wf4(:,8),G1H3(44),m3h4x3(:,83),heltab2x12(:,:,124))
  call Hloop_A_Q(ntryL,G1H3(44),47,0,G2H3(69),n2h3(97))
  call Hloop_AV_Q(ntryL,G0H12(17),wf4(:,8),G0H3(1),m3h4x3(:,84),heltab2x12(:,:,125))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(44),n2h3(98))
  call Hloop_AV_Q(ntryL,G1H12(86),wf4(:,8),G1H3(48),m3h4x3(:,85),heltab2x12(:,:,126))
  call Hloop_A_Q(ntryL,G1H3(48),47,nMT,G2H3(70),n2h3(99))
call HGT_OLR(G1H12(87),1,1,12)
call HGT_invQ_OLR(G1H12(87),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(87),-16,nMT,G2H12(8),n2h12(106))
  call Hloop_QZ_A(ntryL,G2H12(8),ex5(:),G2H4(24),ngZu,m3h3x4(:,34),heltab2x12(:,:,127))
  call Hloop_AV_Q(ntryL,G1H12(89),wf4(:,8),G1H3(48),m3h4x3(:,86),heltab2x12(:,:,128))
  call Hloop_A_Q(ntryL,G1H3(48),47,nMT,G2H3(71),n2h3(100))
  call Hloop_AV_Q(ntryL,G1H12(90),wf4(:,8),G1H3(48),m3h4x3(:,87),heltab2x12(:,:,129))
  call Hloop_A_Q(ntryL,G1H3(48),47,nMT,G2H3(72),n2h3(101))
  call Hloop_AV_Q(ntryL,G0H12(18),wf4(:,8),G0H3(1),m3h4x3(:,88),heltab2x12(:,:,130))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMT,G1H3(48),n2h3(102))
  call Hloop_QV_A(ntryL,G1H12(91),wf4(:,8),G1H3(49),m3h4x3(:,89),heltab2x12(:,:,131))
  call Hloop_Q_A(ntryL,G1H3(49),47,0,G2H3(73),n2h3(103))
call HGT_OLR(G1H12(92),1,1,12)
call HGT_invQ_OLR(G1H12(92),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(92),-16,0,G2H12(2),n2h12(107))
  call Hloop_AZ_Q(ntryL,G2H12(2),ex5(:),G2H4(25),ngZu,m3h3x4(:,35),heltab2x12(:,:,132))
  call Hloop_QV_A(ntryL,G1H12(94),wf4(:,8),G1H3(49),m3h4x3(:,90),heltab2x12(:,:,133))
  call Hloop_Q_A(ntryL,G1H3(49),47,0,G2H3(74),n2h3(104))
  call Hloop_QV_A(ntryL,G1H12(95),wf4(:,8),G1H3(49),m3h4x3(:,91),heltab2x12(:,:,134))
  call Hloop_Q_A(ntryL,G1H3(49),47,0,G2H3(75),n2h3(105))
  call Hloop_QV_A(ntryL,G0H12(19),wf4(:,8),G0H3(1),m3h4x3(:,92),heltab2x12(:,:,135))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(49),n2h3(106))
  call Hloop_QV_A(ntryL,G1H12(96),wf4(:,8),G1H3(50),m3h4x3(:,93),heltab2x12(:,:,136))
  call Hloop_Q_A(ntryL,G1H3(50),47,nMT,G2H3(76),n2h3(107))
call HGT_OLR(G1H12(97),1,1,12)
call HGT_invQ_OLR(G1H12(97),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(97),-16,nMT,G2H12(4),n2h12(108))
  call Hloop_AZ_Q(ntryL,G2H12(4),ex5(:),G2H4(26),ngZu,m3h3x4(:,36),heltab2x12(:,:,137))
  call Hloop_QV_A(ntryL,G1H12(99),wf4(:,8),G1H3(50),m3h4x3(:,94),heltab2x12(:,:,138))
  call Hloop_Q_A(ntryL,G1H3(50),47,nMT,G2H3(77),n2h3(108))
  call Hloop_QV_A(ntryL,G1H12(100),wf4(:,8),G1H3(50),m3h4x3(:,95),heltab2x12(:,:,139))
  call Hloop_Q_A(ntryL,G1H3(50),47,nMT,G2H3(78),n2h3(109))
  call Hloop_QV_A(ntryL,G0H12(20),wf4(:,8),G0H3(1),m3h4x3(:,96),heltab2x12(:,:,140))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMT,G1H3(50),n2h3(110))
  call Hloop_AV_Q(ntryL,G1H12(101),wf4(:,8),G1H3(51),m3h4x3(:,97),heltab2x12(:,:,141))
  call Hloop_A_Q(ntryL,G1H3(51),47,0,G2H3(79),n2h3(111))
call HGT_OLR(G1H12(102),1,1,12)
call HGT_invQ_OLR(G1H12(102),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(102),-16,0,G2H12(9),n2h12(109))
  call Hloop_QZ_A(ntryL,G2H12(9),ex5(:),G2H4(27),ngZd,m3h3x4(:,37),heltab2x12(:,:,142))
  call Hloop_AV_Q(ntryL,G1H12(104),wf4(:,8),G1H3(51),m3h4x3(:,98),heltab2x12(:,:,143))
  call Hloop_A_Q(ntryL,G1H3(51),47,0,G2H3(80),n2h3(112))
  call Hloop_AV_Q(ntryL,G1H12(105),wf4(:,8),G1H3(51),m3h4x3(:,99),heltab2x12(:,:,144))
  call Hloop_A_Q(ntryL,G1H3(51),47,0,G2H3(81),n2h3(113))
  call Hloop_AV_Q(ntryL,G0H12(21),wf4(:,8),G0H3(1),m3h4x3(:,100),heltab2x12(:,:,145))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(51),n2h3(114))
  call Hloop_AV_Q(ntryL,G1H12(106),wf4(:,8),G1H3(52),m3h4x3(:,101),heltab2x12(:,:,146))
  call Hloop_A_Q(ntryL,G1H3(52),47,nMB,G2H3(82),n2h3(115))
call HGT_OLR(G1H12(107),1,1,12)
call HGT_invQ_OLR(G1H12(107),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(107),-16,nMB,G2H12(11),n2h12(110))
  call Hloop_QZ_A(ntryL,G2H12(11),ex5(:),G2H4(28),ngZd,m3h3x4(:,38),heltab2x12(:,:,147))
  call Hloop_AV_Q(ntryL,G1H12(109),wf4(:,8),G1H3(52),m3h4x3(:,102),heltab2x12(:,:,148))
  call Hloop_A_Q(ntryL,G1H3(52),47,nMB,G2H3(83),n2h3(116))
  call Hloop_AV_Q(ntryL,G1H12(110),wf4(:,8),G1H3(52),m3h4x3(:,103),heltab2x12(:,:,149))
  call Hloop_A_Q(ntryL,G1H3(52),47,nMB,G2H3(84),n2h3(117))
  call Hloop_AV_Q(ntryL,G0H12(22),wf4(:,8),G0H3(1),m3h4x3(:,104),heltab2x12(:,:,150))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMB,G1H3(52),n2h3(118))
  call Hloop_QV_A(ntryL,G1H12(111),wf4(:,8),G1H3(53),m3h4x3(:,105),heltab2x12(:,:,151))
  call Hloop_Q_A(ntryL,G1H3(53),47,0,G2H3(85),n2h3(119))
call HGT_OLR(G1H12(112),1,1,12)
call HGT_invQ_OLR(G1H12(112),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(112),-16,0,G2H12(13),n2h12(111))
  call Hloop_AZ_Q(ntryL,G2H12(13),ex5(:),G2H4(29),ngZd,m3h3x4(:,39),heltab2x12(:,:,152))
  call Hloop_QV_A(ntryL,G1H12(114),wf4(:,8),G1H3(53),m3h4x3(:,106),heltab2x12(:,:,153))
  call Hloop_Q_A(ntryL,G1H3(53),47,0,G2H3(86),n2h3(120))
  call Hloop_QV_A(ntryL,G1H12(115),wf4(:,8),G1H3(53),m3h4x3(:,107),heltab2x12(:,:,154))
  call Hloop_Q_A(ntryL,G1H3(53),47,0,G2H3(87),n2h3(121))
  call Hloop_QV_A(ntryL,G0H12(23),wf4(:,8),G0H3(1),m3h4x3(:,108),heltab2x12(:,:,155))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(53),n2h3(122))
  call Hloop_QV_A(ntryL,G1H12(116),wf4(:,8),G1H3(54),m3h4x3(:,109),heltab2x12(:,:,156))
  call Hloop_Q_A(ntryL,G1H3(54),47,nMB,G2H3(88),n2h3(123))
call HGT_OLR(G1H12(117),1,1,12)
call HGT_invQ_OLR(G1H12(117),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(117),-16,nMB,G2H12(14),n2h12(112))
  call Hloop_AZ_Q(ntryL,G2H12(14),ex5(:),G2H4(30),ngZd,m3h3x4(:,40),heltab2x12(:,:,157))
  call Hloop_QV_A(ntryL,G1H12(119),wf4(:,8),G1H3(54),m3h4x3(:,110),heltab2x12(:,:,158))
  call Hloop_Q_A(ntryL,G1H3(54),47,nMB,G2H3(89),n2h3(124))
  call Hloop_QV_A(ntryL,G1H12(120),wf4(:,8),G1H3(54),m3h4x3(:,111),heltab2x12(:,:,159))
  call Hloop_Q_A(ntryL,G1H3(54),47,nMB,G2H3(90),n2h3(125))
  call Hloop_QV_A(ntryL,G0H12(24),wf4(:,8),G0H3(1),m3h4x3(:,112),heltab2x12(:,:,160))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMB,G1H3(54),n2h3(126))
  call Hloop_QZ_A(ntryL,G1H12(121),ex5(:),G1H4(11),ngZu,m3h3x4(:,41),heltab2x12(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(11),51,0,G2H4(31),n2h4(13))
call HGT_OLR(G1H12(122),1,1,12)
call HGT_invQ_OLR(G1H12(122),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(122),-12,0,G2H12(15),n2h12(113))
  call Hloop_AV_Q(ntryL,G2H12(15),wf4(:,8),G2H3(91),m3h4x3(:,113),heltab2x12(:,:,162))
  call Hloop_QZ_A(ntryL,G1H12(124),ex5(:),G1H4(11),ngZu,m3h3x4(:,42),heltab2x12(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(11),51,0,G2H4(32),n2h4(14))
  call Hloop_QZ_A(ntryL,G1H12(125),ex5(:),G1H4(11),ngZu,m3h3x4(:,43),heltab2x12(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(11),51,0,G2H4(33),n2h4(15))
  call Hloop_QZ_A(ntryL,G0H12(25),ex5(:),G0H4(1),ngZu,m3h3x4(:,44),heltab2x12(:,:,165))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(11),n2h4(16))
  call Hloop_QZ_A(ntryL,G1H12(126),ex5(:),G1H4(12),ngZu,m3h3x4(:,45),heltab2x12(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(12),51,nMT,G2H4(34),n2h4(17))
call HGT_OLR(G1H12(127),1,1,12)
call HGT_invQ_OLR(G1H12(127),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(127),-12,nMT,G2H12(16),n2h12(114))
  call Hloop_AV_Q(ntryL,G2H12(16),wf4(:,8),G2H3(92),m3h4x3(:,114),heltab2x12(:,:,167))
  call Hloop_QZ_A(ntryL,G1H12(129),ex5(:),G1H4(12),ngZu,m3h3x4(:,46),heltab2x12(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(12),51,nMT,G2H4(35),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H12(130),ex5(:),G1H4(12),ngZu,m3h3x4(:,47),heltab2x12(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(12),51,nMT,G2H4(36),n2h4(19))
  call Hloop_QZ_A(ntryL,G0H12(26),ex5(:),G0H4(1),ngZu,m3h3x4(:,48),heltab2x12(:,:,170))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(12),n2h4(20))
  call Hloop_AZ_Q(ntryL,G1H12(131),ex5(:),G1H4(13),ngZu,m3h3x4(:,49),heltab2x12(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(13),51,0,G2H4(37),n2h4(21))
call HGT_OLR(G1H12(132),1,1,12)
call HGT_invQ_OLR(G1H12(132),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(132),-12,0,G2H12(25),n2h12(115))
  call Hloop_QV_A(ntryL,G2H12(25),wf4(:,8),G2H3(93),m3h4x3(:,115),heltab2x12(:,:,172))
  call Hloop_AZ_Q(ntryL,G1H12(134),ex5(:),G1H4(13),ngZu,m3h3x4(:,50),heltab2x12(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(13),51,0,G2H4(38),n2h4(22))
  call Hloop_AZ_Q(ntryL,G1H12(135),ex5(:),G1H4(13),ngZu,m3h3x4(:,51),heltab2x12(:,:,174))
  call Hloop_A_Q(ntryL,G1H4(13),51,0,G2H4(39),n2h4(23))
  call Hloop_AZ_Q(ntryL,G0H12(27),ex5(:),G0H4(1),ngZu,m3h3x4(:,52),heltab2x12(:,:,175))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(13),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H12(136),ex5(:),G1H4(14),ngZu,m3h3x4(:,53),heltab2x12(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(14),51,nMT,G2H4(40),n2h4(25))
call HGT_OLR(G1H12(137),1,1,12)
call HGT_invQ_OLR(G1H12(137),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(137),-12,nMT,G2H12(26),n2h12(116))
  call Hloop_QV_A(ntryL,G2H12(26),wf4(:,8),G2H3(94),m3h4x3(:,116),heltab2x12(:,:,177))
  call Hloop_AZ_Q(ntryL,G1H12(139),ex5(:),G1H4(14),ngZu,m3h3x4(:,54),heltab2x12(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(14),51,nMT,G2H4(41),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H12(140),ex5(:),G1H4(14),ngZu,m3h3x4(:,55),heltab2x12(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(14),51,nMT,G2H4(42),n2h4(27))
  call Hloop_AZ_Q(ntryL,G0H12(28),ex5(:),G0H4(1),ngZu,m3h3x4(:,56),heltab2x12(:,:,180))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(14),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H12(141),ex5(:),G1H4(15),ngZd,m3h3x4(:,57),heltab2x12(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(15),51,0,G2H4(43),n2h4(29))
call HGT_OLR(G1H12(142),1,1,12)
call HGT_invQ_OLR(G1H12(142),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(142),-12,0,G2H12(27),n2h12(117))
  call Hloop_AV_Q(ntryL,G2H12(27),wf4(:,8),G2H3(95),m3h4x3(:,117),heltab2x12(:,:,182))
  call Hloop_QZ_A(ntryL,G1H12(144),ex5(:),G1H4(15),ngZd,m3h3x4(:,58),heltab2x12(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(15),51,0,G2H4(44),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H12(145),ex5(:),G1H4(15),ngZd,m3h3x4(:,59),heltab2x12(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(15),51,0,G2H4(45),n2h4(31))
  call Hloop_QZ_A(ntryL,G0H12(29),ex5(:),G0H4(1),ngZd,m3h3x4(:,60),heltab2x12(:,:,185))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(15),n2h4(32))
  call Hloop_QZ_A(ntryL,G1H12(146),ex5(:),G1H4(16),ngZd,m3h3x4(:,61),heltab2x12(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(16),51,nMB,G2H4(46),n2h4(33))
call HGT_OLR(G1H12(147),1,1,12)
call HGT_invQ_OLR(G1H12(147),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(147),-12,nMB,G2H12(28),n2h12(118))
  call Hloop_AV_Q(ntryL,G2H12(28),wf4(:,8),G2H3(96),m3h4x3(:,118),heltab2x12(:,:,187))
  call Hloop_QZ_A(ntryL,G1H12(149),ex5(:),G1H4(16),ngZd,m3h3x4(:,62),heltab2x12(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(16),51,nMB,G2H4(47),n2h4(34))
  call Hloop_QZ_A(ntryL,G1H12(150),ex5(:),G1H4(16),ngZd,m3h3x4(:,63),heltab2x12(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(16),51,nMB,G2H4(48),n2h4(35))
  call Hloop_QZ_A(ntryL,G0H12(30),ex5(:),G0H4(1),ngZd,m3h3x4(:,64),heltab2x12(:,:,190))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(16),n2h4(36))
  call Hloop_AZ_Q(ntryL,G1H12(151),ex5(:),G1H4(17),ngZd,m3h3x4(:,65),heltab2x12(:,:,191))
  call Hloop_A_Q(ntryL,G1H4(17),51,0,G2H4(49),n2h4(37))
call HGT_OLR(G1H12(152),1,1,12)
call HGT_invQ_OLR(G1H12(152),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(152),-12,0,G2H12(29),n2h12(119))
  call Hloop_QV_A(ntryL,G2H12(29),wf4(:,8),G2H3(97),m3h4x3(:,119),heltab2x12(:,:,192))
  call Hloop_AZ_Q(ntryL,G1H12(154),ex5(:),G1H4(17),ngZd,m3h3x4(:,66),heltab2x12(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(17),51,0,G2H4(50),n2h4(38))
  call Hloop_AZ_Q(ntryL,G1H12(155),ex5(:),G1H4(17),ngZd,m3h3x4(:,67),heltab2x12(:,:,194))
  call Hloop_A_Q(ntryL,G1H4(17),51,0,G2H4(51),n2h4(39))
  call Hloop_AZ_Q(ntryL,G0H12(31),ex5(:),G0H4(1),ngZd,m3h3x4(:,68),heltab2x12(:,:,195))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(17),n2h4(40))
  call Hloop_AZ_Q(ntryL,G1H12(156),ex5(:),G1H4(18),ngZd,m3h3x4(:,69),heltab2x12(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(18),51,nMB,G2H4(52),n2h4(41))
call HGT_OLR(G1H12(157),1,1,12)
call HGT_invQ_OLR(G1H12(157),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(157),-12,nMB,G2H12(30),n2h12(120))
  call Hloop_QV_A(ntryL,G2H12(30),wf4(:,8),G2H3(98),m3h4x3(:,120),heltab2x12(:,:,197))
  call Hloop_AZ_Q(ntryL,G1H12(159),ex5(:),G1H4(18),ngZd,m3h3x4(:,70),heltab2x12(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(18),51,nMB,G2H4(53),n2h4(42))
  call Hloop_AZ_Q(ntryL,G1H12(160),ex5(:),G1H4(18),ngZd,m3h3x4(:,71),heltab2x12(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(18),51,nMB,G2H4(54),n2h4(43))
  call Hloop_AZ_Q(ntryL,G0H12(32),ex5(:),G0H4(1),ngZd,m3h3x4(:,72),heltab2x12(:,:,200))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMB,G1H4(18),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H24(10),wf4(:,1),G1H6(16),m3h4x6(:,13),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(16),43,nMT,G2H6(2),n2h6(23))
call HGT_raise_alpha_OLR(G1H24(3),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(3),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(3),wf6(:,2),G1H4(19),m3h6x4(:,1),heltab2x24(:,:,50))
  call Hloop_AV_Q(ntryL,G1H24(13),wf4(:,1),G1H6(11),m3h4x6(:,14),heltab2x24(:,:,51))
  call Hloop_A_Q(ntryL,G1H6(11),43,nMT,G2H6(9),n2h6(24))
  call Hloop_AV_Q(ntryL,G1H24(14),wf4(:,1),G1H6(4),m3h4x6(:,15),heltab2x24(:,:,52))
  call Hloop_A_Q(ntryL,G1H6(4),43,nMT,G2H6(8),n2h6(25))
  call Hloop_AZ_Q(ntryL,G1H24(20),wf4(:,5),G1H6(7),ngZu,m3h4x6(:,16),heltab2x24(:,:,53))
  call Hloop_A_Q(ntryL,G1H6(7),43,nMT,G2H6(1),n2h6(26))
call HGT_raise_alpha_OLR(G1H24(21),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(21),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(21),wf6(:,2),G1H4(20),m3h6x4(:,2),heltab2x24(:,:,54))
  call Hloop_AZ_Q(ntryL,G1H24(7),wf4(:,5),G1H6(10),ngZu,m3h4x6(:,17),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G1H6(10),43,nMT,G2H6(11),n2h6(27))
  call Hloop_AZ_Q(ntryL,G1H24(8),wf4(:,5),G1H6(3),ngZu,m3h4x6(:,18),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G1H6(3),43,nMT,G2H6(10),n2h6(28))
  call Hloop_QV_A(ntryL,G1H24(25),wf4(:,1),G1H6(12),m3h4x6(:,19),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(12),39,nMT,G2H6(6),n2h6(29))
call HGT_raise_alpha_OLR(G1H24(26),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(26),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(26),wf6(:,4),G1H4(21),m3h6x4(:,3),heltab2x24(:,:,58))
  call Hloop_QV_A(ntryL,G1H24(28),wf4(:,1),G1H6(9),m3h4x6(:,20),heltab2x24(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(9),39,nMT,G2H6(3),n2h6(30))
  call Hloop_QV_A(ntryL,G1H24(29),wf4(:,1),G1H6(8),m3h4x6(:,21),heltab2x24(:,:,60))
  call Hloop_Q_A(ntryL,G1H6(8),39,nMT,G2H6(4),n2h6(31))
  call Hloop_QZ_A(ntryL,G1H24(30),wf4(:,5),G1H6(21),ngZu,m3h4x6(:,22),heltab2x24(:,:,61))
  call Hloop_Q_A(ntryL,G1H6(21),39,nMT,G2H6(12),n2h6(32))
call HGT_raise_alpha_OLR(G1H24(31),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(31),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(31),wf6(:,4),G1H4(22),m3h6x4(:,4),heltab2x24(:,:,62))
  call Hloop_QZ_A(ntryL,G1H24(33),wf4(:,5),G1H6(22),ngZu,m3h4x6(:,23),heltab2x24(:,:,63))
  call Hloop_Q_A(ntryL,G1H6(22),39,nMT,G2H6(13),n2h6(33))
  call Hloop_QZ_A(ntryL,G1H24(34),wf4(:,5),G1H6(26),ngZu,m3h4x6(:,24),heltab2x24(:,:,64))
  call Hloop_Q_A(ntryL,G1H6(26),39,nMT,G2H6(14),n2h6(34))
  call Hloop_QZ_A(ntryL,G1H24(11),ex5(:),G1H8(4),ngZu,m3h3x8(:,11),heltab2x24(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(4),52,nMT,G2H8(4),n2h8(21))
call HGT_raise_alpha_OLR(G1H24(12),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(12),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(12),wf8(:,2),G1H3(55),m3h8x3(:,5),heltab2x24(:,:,66))
  call Hloop_QZ_A(ntryL,G1H24(36),ex5(:),G1H8(20),ngZu,m3h3x8(:,12),heltab2x24(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(20),52,nMT,G2H8(5),n2h8(22))
  call Hloop_QZ_A(ntryL,G1H24(37),ex5(:),G1H8(3),ngZu,m3h3x8(:,13),heltab2x24(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(3),52,nMT,G2H8(7),n2h8(23))
  call Hloop_QZ_A(ntryL,G1H24(38),ex5(:),G1H8(19),ngZu,m3h3x8(:,14),heltab2x24(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(19),52,nMT,G2H8(8),n2h8(24))
call HGT_raise_alpha_OLR(G1H24(39),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(39),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(39),wf8(:,4),G1H3(56),m3h8x3(:,6),heltab2x24(:,:,70))
  call Hloop_QZ_A(ntryL,G1H24(41),ex5(:),G1H8(9),ngZu,m3h3x8(:,15),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(9),52,nMT,G2H8(2),n2h8(25))
  call Hloop_QZ_A(ntryL,G1H24(42),ex5(:),G1H8(10),ngZu,m3h3x8(:,16),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(10),52,nMT,G2H8(6),n2h8(26))
  call Hloop_QS_A(ntryL,G1H24(16),wf12(:,4),G1H2(2),ngH,m3h12x2(:,1),heltab2x24(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(53),n2h2(49))
call HGT_raise_alpha_OLR(G1H24(17),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(17),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(17),ex4(:),G1H12(161),m3h2x12(:,23),heltab2x24(:,:,74))
  call Hloop_QS_A(ntryL,G1H24(19),wf12(:,4),G1H2(7),ngH,m3h12x2(:,2),heltab2x24(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMT,G2H2(54),n2h2(50))
  call Hloop_QS_A(ntryL,G1H24(43),wf12(:,4),G1H2(8),ngH,m3h12x2(:,3),heltab2x24(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(55),n2h2(51))
  call Hloop_QV_A(ntryL,G1H24(22),wf12(:,6),G1H2(12),m3h12x2(:,4),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMT,G2H2(56),n2h2(52))
call HGT_raise_alpha_OLR(G1H24(23),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(23),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(23),ex4(:),G1H12(17),m3h2x12(:,24),heltab2x24(:,:,78))
  call Hloop_QV_A(ntryL,G1H24(15),wf12(:,6),G1H2(13),m3h12x2(:,5),heltab2x24(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(57),n2h2(53))
  call Hloop_QV_A(ntryL,G1H24(44),wf12(:,6),G1H2(18),m3h12x2(:,6),heltab2x24(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMT,G2H2(58),n2h2(54))
  call Hloop_QZ_A(ntryL,G1H24(45),wf12(:,8),G1H2(19),ngZu,m3h12x2(:,7),heltab2x24(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(19),55,nMT,G2H2(59),n2h2(55))
call HGT_raise_alpha_OLR(G1H24(46),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(46),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(46),ex4(:),G1H12(18),m3h2x12(:,25),heltab2x24(:,:,82))
  call Hloop_QZ_A(ntryL,G1H24(48),wf12(:,8),G1H2(6),ngZu,m3h12x2(:,8),heltab2x24(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMT,G2H2(60),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H24(49),wf12(:,8),G1H2(17),ngZu,m3h12x2(:,9),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(61),n2h2(57))
  call Hloop_QV_A(ntryL,G1H24(9),wf12(:,9),G1H2(1),m3h12x2(:,10),heltab2x24(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(62),n2h2(58))
call HGT_raise_alpha_OLR(G1H24(5),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(5),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(5),ex4(:),G1H12(20),m3h2x12(:,26),heltab2x24(:,:,86))
  call Hloop_QV_A(ntryL,G1H24(6),wf12(:,9),G1H2(2),m3h12x2(:,11),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(63),n2h2(59))
  call Hloop_QV_A(ntryL,G1H24(50),wf12(:,9),G1H2(7),m3h12x2(:,12),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMT,G2H2(64),n2h2(60))
  call Hloop_QZ_A(ntryL,G1H24(51),wf12(:,11),G1H2(8),ngZu,m3h12x2(:,13),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(65),n2h2(61))
call HGT_raise_alpha_OLR(G1H24(52),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(52),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(52),ex4(:),G1H12(23),m3h2x12(:,27),heltab2x24(:,:,90))
  call Hloop_QZ_A(ntryL,G1H24(54),wf12(:,11),G1H2(12),ngZu,m3h12x2(:,14),heltab2x24(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMT,G2H2(66),n2h2(62))
  call Hloop_QZ_A(ntryL,G1H24(55),wf12(:,11),G1H2(13),ngZu,m3h12x2(:,15),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(67),n2h2(63))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(2),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(5),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(76),[G2H3(2),G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G2H3(16),G2H3(8),G2H3(5),G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(70),[G2H3(11),G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G2H3(10),G2H3(17),G2H3(14),G1H3(41)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(62),G2H2(59),G2H2(56),G2H2(53),G2H2(20) &
    ,G2H2(15),G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(64),G2H2(61),G2H2(58),G2H2(55),G2H2(23) &
    ,G2H2(22),G2H2(18),G2H2(17),G2H2(13),G2H2(12)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G2H3(4),G1H3(39)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(1)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(78),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G2H3(1),G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G2H3(19),G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G2H3(21),G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(72),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G2H3(25),G1H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G2H3(27),G1H3(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(49),G2H2(19),G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G2H2(40),G2H2(21),G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(31),[G1H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(49),[G2H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(51),[G2H3(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(20),[G1H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(52),[G2H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(54),[G2H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(33),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(55),[G2H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(57),[G2H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(11),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(60),[G2H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(5),[G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(61),[G2H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(63),[G2H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(16),[G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(64),[G2H3(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G2H3(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(9),[G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(1),[G2H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G2H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(14),[G2H6(4)])
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(17),mass4set(:,3),  & 
G1H2(18),G1H2(19),G1H2(6),G1H2(17),G1H2(1),2)
  call HG1shiftOLR(G1H2(19),8,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(21),mass4set(:,3),  & 
G1H2(2),G1H2(7),G1H2(8),G1H2(12),G1H2(13),2)
  call HG1shiftOLR(G1H2(7),4,2)
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(39),mass4set(:,3),  & 
G1H2(5),G1H2(16),G1H2(3),G1H2(4),G1H2(14),2)
  call HG1shiftOLR(G1H2(16),4,2)
  call Hotf_4pt_reduction(G2H3(76),RedSet_4(25),mass4set(:,2),  & 
G1H3(8),G1H3(19),G1H3(30),G1H3(41),G1H3(39),3)
  call HG1shiftOLR(G1H3(19),16,3)
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(40),mass4set(:,4),  & 
G1H4(1),G1H4(4),G1H4(11),G1H4(13),G1H4(23),4)
  call HG1shiftOLR(G1H4(4),3,4)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(29),mass4set(:,4),  & 
G1H3(1),G1H3(45),G1H3(6),G1H3(7),G1H3(14),3)
  call HG1shiftOLR(G1H3(45),16,3)
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(40),mass4set(:,4),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(25),3,4)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(41),mass4set(:,3),  & 
G1H2(15),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(23),8,2)
  call Hotf_4pt_reduction(G2H3(70),RedSet_4(25),mass4set(:,2),  & 
G1H3(17),G1H3(18),G1H3(24),G1H3(28),G1H3(29),3)
  call HG1shiftOLR(G1H3(18),16,3)
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(42),mass4set(:,4),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),4)
  call HG1shiftOLR(G1H4(30),3,4)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(35),mass4set(:,4),  & 
G1H3(36),G1H3(40),G1H3(46),G1H3(43),G1H3(10),3)
  call HG1shiftOLR(G1H3(40),16,3)
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(42),mass4set(:,4),  & 
G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(35),3,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(43),mass4set(:,8),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),4)
  call HG1shiftOLR(G1H4(40),3,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(65),ex4(:),G2tensor(1),m3h2x1(:,13),heltab2x2(:,:,13))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(3),n2h1(25))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex4(:),G2tensor(5),m3h2x1(:,14),heltab2x2(:,:,14))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nMT,G2tensor(9),n2h1(26))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(43),mass4set(:,8),  & 
G1H4(2),G1H4(3),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(3),3,4)
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,3),heltab2x4(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(13),n2h1(27))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nMT,G2tensor(17),n2h1(28))
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(34),mass4set(:,8),  & 
G1H3(38),G1H3(42),G1H3(15),G1H3(37),G1H3(4),3)
  call HG1shiftOLR(G1H3(42),16,3)
  call Hloop_QZ_A(ntryL,G1H3(2),ex5(:),G1H1(1),ngZu,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(21),n2h1(29))
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_QZ_A(ntryL,G1H3(3),ex5(:),G1H1(1),ngZu,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(25),n2h1(30))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(15),mass4set(:,3),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(16),mass4set(:,3),  & 
G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(33),8,2)
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(29),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(30),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(33))
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(19),mass4set(:,3),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(10),4,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(20),mass4set(:,3),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),2)
  call HG1shiftOLR(G1H2(40),4,2)
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(32),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(34),n2h1(36))
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(23),mass4set(:,4),  & 
G1H3(22),G1H3(2),G1H3(3),G1H3(57),G1H3(58),3)
  call HG1shiftOLR(G1H3(2),16,3)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(24),mass4set(:,4),  & 
G1H3(59),G1H3(60),G1H3(61),G1H3(62),G1H3(63),3)
  call HG1shiftOLR(G1H3(60),16,3)
  call Hloop_QZ_A(ntryL,G1H3(12),ex5(:),G1H1(1),ngZu,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(35),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H3(13),ex5(:),G1H1(1),ngZu,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(36),n2h1(38))
  call Hloop_QZ_A(ntryL,G2H3(78),ex5(:),G2H1(1),ngZu,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(1),n2h1(39))
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(27),mass4set(:,8),  & 
G1H3(12),G1H3(13),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(13),16,3)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(28),mass4set(:,2),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),3)
  call HG1shiftOLR(G1H3(68),16,3)
  call Hloop_AZ_Q(ntryL,G1H3(23),ex5(:),G1H1(1),ngZu,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(37),n2h1(40))
  call Hloop_AZ_Q(ntryL,G2H3(24),ex5(:),G2H1(1),ngZu,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(2),n2h1(41))
  call Hloop_AZ_Q(ntryL,G1H3(25),ex5(:),G1H1(1),ngZu,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(38),n2h1(42))
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(31),mass4set(:,4),  & 
G1H3(23),G1H3(25),G1H3(72),G1H3(73),G1H3(74),3)
  call HG1shiftOLR(G1H3(25),16,3)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(32),mass4set(:,4),  & 
G1H3(75),G1H3(76),G1H3(77),G1H3(78),G1H3(79),3)
  call HG1shiftOLR(G1H3(76),16,3)
  call Hloop_AZ_Q(ntryL,G1H3(34),ex5(:),G1H1(1),ngZu,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(43))
  call Hloop_AZ_Q(ntryL,G1H3(35),ex5(:),G1H1(1),ngZu,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(40),n2h1(44))
  call Hloop_AZ_Q(ntryL,G2H3(72),ex5(:),G2H1(1),ngZu,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(3),n2h1(45))
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(28),mass4set(:,2),  & 
G1H3(34),G1H3(35),G1H3(80),G1H3(81),G1H3(82),3)
  call HG1shiftOLR(G1H3(35),16,3)
  call Hloop_QZ_A(ntryL,G2H3(30),ex5(:),G2H1(1),ngZu,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(4),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H3(47),ex5(:),G1H1(1),ngZu,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(47))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(42),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(43),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(44),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(45),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hotf_4pt_reduction(G2H6(5),RedSet_4(5),mass4set(:,3),  & 
G1H6(27),G1H6(13),G1H6(14),G1H6(24),G1H6(20),6)
  call HG1shiftOLR(G1H6(13),20,6)
  call Hotf_4pt_reduction(G2H6(7),RedSet_4(7),mass4set(:,3),  & 
G1H6(23),G1H6(25),G1H6(17),G1H6(18),G1H6(1),6)
  call HG1shiftOLR(G1H6(25),24,6)
  call Hotf_4pt_reduction(G2H12(17),RedSet_4(6),mass4set(:,4),  & 
G1H12(24),G1H12(25),G1H12(29),G1H12(30),G1H12(3),12)
  call HG1shiftOLR(G1H12(25),19,12)
  call Hotf_4pt_reduction(G2H12(18),RedSet_4(8),mass4set(:,4),  & 
G1H12(9),G1H12(6),G1H12(21),G1H12(12),G1H12(27),12)
  call HG1shiftOLR(G1H12(6),19,12)
  call Hotf_4pt_reduction(G2H12(19),RedSet_4(6),mass4set(:,4),  & 
G1H12(7),G1H12(8),G1H12(15),G1H12(16),G1H12(28),12)
  call HG1shiftOLR(G1H12(8),19,12)
  call Hotf_4pt_reduction(G2H12(20),RedSet_4(6),mass4set(:,4),  & 
G1H12(13),G1H12(1),G1H12(2),G1H12(10),G1H12(11),12)
  call HG1shiftOLR(G1H12(1),19,12)
  call Hotf_4pt_reduction(G2H12(21),RedSet_4(8),mass4set(:,4),  & 
G1H12(31),G1H12(32),G1H12(34),G1H12(35),G1H12(36),12)
  call HG1shiftOLR(G1H12(32),19,12)
  call Hotf_4pt_reduction(G2H12(22),RedSet_4(8),mass4set(:,4),  & 
G1H12(37),G1H12(39),G1H12(40),G1H12(41),G1H12(42),12)
  call HG1shiftOLR(G1H12(39),19,12)
  call Hotf_4pt_reduction(G2H12(23),RedSet_4(6),mass4set(:,4),  & 
G1H12(44),G1H12(45),G1H12(46),G1H12(47),G1H12(49),12)
  call HG1shiftOLR(G1H12(45),19,12)
  call Hotf_4pt_reduction(G2H12(24),RedSet_4(6),mass4set(:,4),  & 
G1H12(50),G1H12(51),G1H12(52),G1H12(54),G1H12(55),12)
  call HG1shiftOLR(G1H12(51),19,12)
  call Hotf_4pt_reduction(G2H12(33),RedSet_4(8),mass4set(:,4),  & 
G1H12(56),G1H12(57),G1H12(59),G1H12(60),G1H12(61),12)
  call HG1shiftOLR(G1H12(57),19,12)
  call Hotf_4pt_reduction(G2H12(34),RedSet_4(8),mass4set(:,4),  & 
G1H12(62),G1H12(64),G1H12(65),G1H12(66),G1H12(67),12)
  call HG1shiftOLR(G1H12(64),19,12)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex3(:),G2tensor(46),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(34),ex3(:),G2tensor(47),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(48),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(49),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(44),ex4(:),G2tensor(50),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hloop_AZ_Q(ntryL,G1H3(31),ex5(:),G1H1(1),ngZu,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(51),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H3(21),ex5(:),G1H1(1),ngZu,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(52),n2h1(49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(53),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hotf_4pt_reduction(G2H3(49),RedSet_4(28),mass4set(:,6),  & 
G1H3(47),G1H3(31),G1H3(21),G1H3(83),G1H3(84),3)
  call HG1shiftOLR(G1H3(31),16,3)
  call Hloop_AZ_Q(ntryL,G2H3(51),ex5(:),G2H1(1),ngZu,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(5),n2h1(50))
  call Hloop_AZ_Q(ntryL,G1H3(20),ex5(:),G1H1(1),ngZu,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(51))
  call Hotf_4pt_reduction(G2H3(52),RedSet_4(28),mass4set(:,6),  & 
G1H3(20),G1H3(85),G1H3(86),G1H3(87),G1H3(88),3)
  call HG1shiftOLR(G1H3(85),16,3)
  call Hloop_QZ_A(ntryL,G2H3(54),ex5(:),G2H1(1),ngZu,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(6),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H3(33),ex5(:),G1H1(1),ngZu,m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(53))
  call Hotf_4pt_reduction(G2H3(55),RedSet_4(28),mass4set(:,6),  & 
G1H3(33),G1H3(89),G1H3(90),G1H3(91),G1H3(92),3)
  call HG1shiftOLR(G1H3(89),16,3)
  call Hloop_AZ_Q(ntryL,G2H3(57),ex5(:),G2H1(1),ngZd,m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(7),n2h1(54))
  call Hloop_AZ_Q(ntryL,G1H3(11),ex5(:),G1H1(1),ngZd,m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(56),n2h1(55))
  call Hotf_4pt_reduction(G2H3(58),RedSet_4(28),mass4set(:,7),  & 
G1H3(11),G1H3(93),G1H3(94),G1H3(95),G1H3(96),3)
  call HG1shiftOLR(G1H3(93),16,3)
  call Hloop_AZ_Q(ntryL,G2H3(60),ex5(:),G2H1(1),ngZd,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(8),n2h1(56))
  call Hloop_AZ_Q(ntryL,G1H3(5),ex5(:),G1H1(1),ngZd,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(57),n2h1(57))
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(28),mass4set(:,6),  & 
G1H3(5),G1H3(97),G1H3(98),G1H3(99),G1H3(100),3)
  call HG1shiftOLR(G1H3(97),16,3)
  call Hloop_QZ_A(ntryL,G2H3(63),ex5(:),G2H1(1),ngZd,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(9),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H3(16),ex5(:),G1H1(1),ngZd,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(59))
  call Hotf_4pt_reduction(G2H3(64),RedSet_4(28),mass4set(:,7),  & 
G1H3(16),G1H3(101),G1H3(102),G1H3(103),G1H3(104),3)
  call HG1shiftOLR(G1H3(101),16,3)
  call Hloop_QZ_A(ntryL,G2H3(66),ex5(:),G2H1(1),ngZd,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(10),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H3(9),ex5(:),G1H1(1),ngZd,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(59),n2h1(61))
  call Hotf_4pt_reduction(G2H3(67),RedSet_4(25),mass4set(:,6),  & 
G1H3(9),G1H3(105),G1H3(106),G1H3(107),G1H3(108),3)
  call HG1shiftOLR(G1H3(105),16,3)
  call Hloop_AZ_Q(ntryL,G2H3(69),ex5(:),G2H1(1),ngZu,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(11),n2h1(62))
  call Hloop_AZ_Q(ntryL,G1H3(44),ex5(:),G1H1(1),ngZu,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(63))
  call Hloop_AZ_Q(ntryL,G1H3(48),ex5(:),G1H1(1),ngZu,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(64))
  call Hotf_4pt_reduction(G2H3(73),RedSet_4(25),mass4set(:,6),  & 
G1H3(44),G1H3(48),G1H3(109),G1H3(110),G1H3(111),3)
  call HG1shiftOLR(G1H3(48),16,3)
  call Hloop_QZ_A(ntryL,G2H3(75),ex5(:),G2H1(1),ngZu,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(12),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(49),ex5(:),G1H1(1),ngZu,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(62),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H3(50),ex5(:),G1H1(1),ngZu,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(67))
  call Hotf_4pt_reduction(G2H3(79),RedSet_4(25),mass4set(:,6),  & 
G1H3(49),G1H3(50),G1H3(112),G1H3(113),G1H3(114),3)
  call HG1shiftOLR(G1H3(50),16,3)
  call Hloop_AZ_Q(ntryL,G2H3(81),ex5(:),G2H1(1),ngZd,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(13),n2h1(68))
  call Hloop_AZ_Q(ntryL,G1H3(51),ex5(:),G1H1(1),ngZd,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(69))
  call Hotf_4pt_reduction(G2H3(82),RedSet_4(25),mass4set(:,7),  & 
G1H3(51),G1H3(115),G1H3(116),G1H3(117),G1H3(118),3)
  call HG1shiftOLR(G1H3(115),16,3)
  call Hloop_AZ_Q(ntryL,G2H3(84),ex5(:),G2H1(1),ngZd,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(14),n2h1(70))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex5(:),G1H1(1),ngZd,m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(65),n2h1(71))
  call Hotf_4pt_reduction(G2H3(85),RedSet_4(25),mass4set(:,6),  & 
G1H3(52),G1H3(119),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(119),16,3)
  call Hloop_QZ_A(ntryL,G2H3(87),ex5(:),G2H1(1),ngZd,m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(15),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H3(53),ex5(:),G1H1(1),ngZd,m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(73))
  call Hotf_4pt_reduction(G2H3(88),RedSet_4(25),mass4set(:,7),  & 
G1H3(53),G1H3(123),G1H3(124),G1H3(125),G1H3(126),3)
  call HG1shiftOLR(G1H3(123),16,3)
  call Hloop_QZ_A(ntryL,G2H3(90),ex5(:),G2H1(1),ngZd,m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(16),n2h1(74))
  call Hloop_QZ_A(ntryL,G1H3(54),ex5(:),G1H1(1),ngZd,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(67),n2h1(75))
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(4),mass4set(:,6),  & 
G1H4(5),G1H4(6),G1H4(47),G1H4(48),G1H4(49),4)
  call HG1shiftOLR(G1H4(6),12,4)
  call Hloop_QV_A(ntryL,G2H4(45),wf4(:,8),G2H1(1),m3h4x1(:,5),heltab2x4(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(17),n2h1(76))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,8),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(77))
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(4),mass4set(:,2),  & 
G1H4(15),G1H4(50),G1H4(51),G1H4(52),G1H4(53),4)
  call HG1shiftOLR(G1H4(50),12,4)
  call Hloop_QV_A(ntryL,G2H4(36),wf4(:,8),G2H1(1),m3h4x1(:,7),heltab2x4(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(18),n2h1(78))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,8),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(69),n2h1(79))
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(4),mass4set(:,6),  & 
G1H4(12),G1H4(54),G1H4(55),G1H4(56),G1H4(57),4)
  call HG1shiftOLR(G1H4(54),12,4)
  call Hloop_AV_Q(ntryL,G2H4(51),wf4(:,8),G2H1(1),m3h4x1(:,9),heltab2x4(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(19),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H4(17),wf4(:,8),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(81))
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(4),mass4set(:,2),  & 
G1H4(17),G1H4(58),G1H4(59),G1H4(60),G1H4(61),4)
  call HG1shiftOLR(G1H4(58),12,4)
  call Hloop_AV_Q(ntryL,G2H4(42),wf4(:,8),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(20),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,8),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(83))
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(4),mass4set(:,7),  & 
G1H4(14),G1H4(62),G1H4(63),G1H4(64),G1H4(65),4)
  call HG1shiftOLR(G1H4(62),12,4)
  call Hloop_QV_A(ntryL,G2H4(48),wf4(:,8),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(21),n2h1(84))
  call Hloop_QV_A(ntryL,G1H4(16),wf4(:,8),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(72),n2h1(85))
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(4),mass4set(:,7),  & 
G1H4(16),G1H4(66),G1H4(67),G1H4(68),G1H4(69),4)
  call HG1shiftOLR(G1H4(66),12,4)
  call Hloop_AV_Q(ntryL,G2H4(54),wf4(:,8),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(22),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H4(18),wf4(:,8),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(73),n2h1(87))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(1),wf6(:,2),G2tensor(74),m3h6x1(:,1),heltab2x6(:,:,37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(10),wf6(:,2),G2tensor(75),m3h6x1(:,2),heltab2x6(:,:,38))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(12),wf6(:,4),G2tensor(76),m3h6x1(:,3),heltab2x6(:,:,39))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(14),wf6(:,4),G2tensor(77),m3h6x1(:,4),heltab2x6(:,:,40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(4),wf8(:,2),G2tensor(78),m3h8x1(:,1),heltab2x8(:,:,41))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(7),wf8(:,2),G2tensor(79),m3h8x1(:,2),heltab2x8(:,:,42))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,4),G2tensor(80),m3h8x1(:,3),heltab2x8(:,:,43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,4),G2tensor(81),m3h8x1(:,4),heltab2x8(:,:,44))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(82),n2h1(88))
  call Hloop_VA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(83),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(84),n2h1(90))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(85),n2h1(91))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(86),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(87),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(88),n2h1(94))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(89),n2h1(95))
  call Hloop_VQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(90),n2h1(96))
  call Hloop_QZ_A(ntryL,G1H3(8),ex5(:),G1H1(1),ngZu,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(91),n2h1(97))
  call Hloop_QZ_A(ntryL,G1H3(19),ex5(:),G1H1(1),ngZu,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(92),n2h1(98))
  call Hloop_QZ_A(ntryL,G1H3(39),ex5(:),G1H1(1),ngZu,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(93),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(94),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H4(4),wf4(:,1),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nMT,G2tensor(95),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H4(23),wf4(:,1),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(96),n2h1(102))
  call Hloop_AZ_Q(ntryL,G1H3(1),ex5(:),G1H1(1),ngZu,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(97),n2h1(103))
  call Hloop_AZ_Q(ntryL,G1H3(45),ex5(:),G1H1(1),ngZu,m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(98),n2h1(104))
  call Hloop_AZ_Q(ntryL,G1H3(14),ex5(:),G1H1(1),ngZu,m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(99),n2h1(105))
  call Hloop_AZ_Q(ntryL,G1H4(24),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,20),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(100),n2h1(106))



end subroutine vamp_1

end module ol_vamp_1_eevttj_eexttxzg_1_/**/REALKIND
