
module ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [  16]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   2]
  K1(11,:) = [  16]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [   0]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [ -18]
  K1(20,:) = [ -18]
  K1(21,:) = [   0]
  K1(22,:) = [  36]
  K1(23,:) = [   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND



module ol_forced_parameters_eevttj_eexttxzg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_eevttj_eexttxzg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_eevttj_eexttxzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 96 ! number of helicity configurations
  integer(intkind2), save :: nhel = 96 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 96 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(96) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(187)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,16), wf6(6,17), wf8(8,43), wf12(12,32), wf16(16,24), wf24(24,42), wf96(96,124)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(31), c(16)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_eevttj_eexttxzg_1_/**/REALKIND






! **********************************************************************
module ol_loop_eevttj_eexttxzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_eevttj_eexttxzg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**3*gQCD)/3._/**/REALKIND
    f( 2) = CI*eQED**3*gQCD
    f( 3) = (2*CI*countertermnorm*eQED**3*gQCD**3)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED**3*gQCD**3
    f( 5) = CI*countertermnorm*ctAZGG*eQED**3*gQCD**3
    f( 6) = (2*CI*countertermnorm*ctGtt*eQED**3*gQCD**3)/3._/**/REALKIND
    f( 7) = CI*countertermnorm*ctGtt*eQED**3*gQCD**3
    f( 8) = (2*CI*countertermnorm*ctVtt*eQED**3*gQCD**3)/3._/**/REALKIND
    f( 9) = CI*countertermnorm*ctVtt*eQED**3*gQCD**3
    f(10) = (2*countertermnorm*ctZGG*eQED**3*gQCD**3)/3._/**/REALKIND
    f(11) = countertermnorm*ctZGG*eQED**3*gQCD**3
    f(12) = CI*countertermnorm*ctZZGG*eQED**3*gQCD**3
    f(13) = (2*CI*eQED**3*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(14) = CI*eQED**3*gQCD**3*integralnorm*SwB
    f(15) = (2*eQED**3*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(16) = eQED**3*gQCD**3*integralnorm*SwB
    f(17) = (eQED**3*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(18) = (2*eQED**3*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(19) = eQED**3*gQCD**3*integralnorm*SwF
    f(20) = (4*eQED**3*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(21) = 2*eQED**3*gQCD**3*integralnorm*SwF
    f(22) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3*lambdaHZZ*MB*MW*YB)/(cw**2*MQ2sum*sw)
    f(23) = (eQED**3*gQCD**3*integralnorm*lambdaHZZ*SwF*YB)/(cw**2*sw**2*2._/**/REALKIND)
    f(24) = (CI*eQED**3*gQCD*lambdaHZZ*YT)/(2._/**/REALKIND*cw**2*sw**2)
    f(25) = (CI*countertermnorm*eQED**3*gQCD**3*lambdaHZZ*YT)/(2._/**/REALKIND*cw**2*sw**2)
    f(26) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*lambdaHZZ*YT)/(2._/**/REALKIND*cw**2*sw**2)
    f(27) = (CI*countertermnorm*ctStt*eQED**3*gQCD**3*lambdaHZZ*YT)/(2._/**/REALKIND*cw**2*sw**2)
    f(28) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3*lambdaHZZ*MT*MW*YT)/(cw**2*MQ2sum*sw)
    f(29) = (CI*eQED**3*gQCD**3*integralnorm*lambdaHZZ*SwB*YT)/(2._/**/REALKIND*cw**2*sw**2)
    f(30) = (eQED**3*gQCD**3*integralnorm*lambdaHZZ*SwB*YT)/(cw**2*sw**2*2._/**/REALKIND)
    f(31) = (eQED**3*gQCD**3*integralnorm*lambdaHZZ*SwF*YT)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(13), 9*CI*f(14), f(15), 8*f(15), f(16), 8*f(16), 3*f(17), 3*f(18), 3*f(19), 3*f(20), 3*f(21), 3*f(23), 9*CI*f(29) &
    , f(30), 8*f(30), 3*f(31) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20) - MT2)+L(6,20))
  den(3) = 1 /((L(5,40) - MT2)+L(6,40))
  den(6) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,11) - MT2)+L(6,11))
  den(14) = 1 /((L(5,36) - MT2)+L(6,36))
  den(15) = 1 /((L(5,24) - MT2)+L(6,24))
  den(20) = 1 /((L(5,7) - MT2)+L(6,7))
  den(27) = 1 /((L(5,44) - MH2)+L(6,44))
  den(34) = 1 /((L(5,17))+L(6,17))
  den(35) = 1 /((L(5,19))+L(6,19))
  den(38) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(43) = 1 /((L(5,18))+L(6,18))
  den(50) = 1 /((L(5,12))+L(6,12))
  den(53) = 1 /((L(5,19) - MH2)+L(6,19))
  den(56) = 1 /((L(5,28))+L(6,28))
  den(61) = 1 /((L(5,48))+L(6,48))
  den(64) = 1 /((L(5,52) - MT2)+L(6,52))
  den(75) = 1 /((L(5,56) - MT2)+L(6,56))
  den(86) = 1 /((L(5,43) - MT2)+L(6,43))
  den(92) = 1 /((L(5,23) - MT2)+L(6,23))
  den(103) = 1 /((L(5,27) - MT2)+L(6,27))
  den(109) = 1 /((L(5,39) - MT2)+L(6,39))
  den(139) = 1 /((L(5,15))+L(6,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(12) = den(6)*den(9)
  den(13) = den(2)*den(12)
  den(16) = den(1)*den(14)
  den(17) = den(15)*den(16)
  den(18) = den(6)*den(14)
  den(19) = den(15)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(15)*den(21)
  den(23) = den(6)*den(20)
  den(24) = den(15)*den(23)
  den(25) = den(10)*den(14)
  den(26) = den(12)*den(14)
  den(28) = den(14)*den(27)
  den(29) = den(6)*den(28)
  den(30) = den(3)*den(21)
  den(31) = den(3)*den(23)
  den(32) = den(3)*den(27)
  den(33) = den(6)*den(32)
  den(36) = den(34)*den(35)
  den(37) = den(14)*den(36)
  den(39) = den(34)*den(38)
  den(40) = den(14)*den(39)
  den(41) = den(3)*den(36)
  den(42) = den(3)*den(39)
  den(44) = den(35)*den(43)
  den(45) = den(14)*den(44)
  den(46) = den(38)*den(43)
  den(47) = den(14)*den(46)
  den(48) = den(3)*den(44)
  den(49) = den(3)*den(46)
  den(51) = den(1)*den(50)
  den(52) = den(6)*den(50)
  den(54) = den(6)*den(53)
  den(55) = den(50)*den(54)
  den(57) = den(2)*den(56)
  den(58) = den(6)*den(57)
  den(59) = den(15)*den(56)
  den(60) = den(6)*den(59)
  den(62) = den(21)*den(61)
  den(63) = den(23)*den(61)
  den(65) = den(61)*den(64)
  den(66) = den(1)*den(65)
  den(67) = den(6)*den(65)
  den(68) = den(2)*den(64)
  den(69) = den(1)*den(68)
  den(70) = den(6)*den(68)
  den(71) = den(14)*den(54)
  den(72) = den(14)*den(64)
  den(73) = den(1)*den(72)
  den(74) = den(6)*den(72)
  den(76) = den(15)*den(75)
  den(77) = den(1)*den(76)
  den(78) = den(6)*den(76)
  den(79) = den(3)*den(54)
  den(80) = den(3)*den(75)
  den(81) = den(1)*den(80)
  den(82) = den(6)*den(80)
  den(83) = den(39)*den(50)
  den(84) = den(46)*den(50)
  den(85) = den(1)*den(3)
  den(87) = den(85)*den(86)
  den(88) = den(2)*den(87)
  den(89) = den(3)*den(6)
  den(90) = den(86)*den(89)
  den(91) = den(2)*den(90)
  den(93) = den(4)*den(92)
  den(94) = den(3)*den(93)
  den(95) = den(7)*den(92)
  den(96) = den(3)*den(95)
  den(97) = den(2)**2
  den(98) = den(10)*den(97)
  den(99) = den(12)*den(97)
  den(100) = den(10)*den(68)
  den(101) = den(12)*den(68)
  den(102) = den(1)*den(15)
  den(104) = den(102)*den(103)
  den(105) = den(14)*den(104)
  den(106) = den(6)*den(15)
  den(107) = den(103)*den(106)
  den(108) = den(14)*den(107)
  den(110) = den(16)*den(109)
  den(111) = den(15)*den(110)
  den(112) = den(18)*den(109)
  den(113) = den(15)*den(112)
  den(114) = den(21)*den(76)
  den(115) = den(23)*den(76)
  den(116) = den(15)**2
  den(117) = den(21)*den(116)
  den(118) = den(23)*den(116)
  den(119) = den(14)**2
  den(120) = den(54)*den(119)
  den(121) = den(10)*den(119)
  den(122) = den(12)*den(119)
  den(123) = den(10)*den(72)
  den(124) = den(12)*den(72)
  den(125) = den(3)**2
  den(126) = den(54)*den(125)
  den(127) = den(21)*den(80)
  den(128) = den(23)*den(80)
  den(129) = den(21)*den(125)
  den(130) = den(23)*den(125)
  den(131) = den(36)*den(119)
  den(132) = den(39)*den(119)
  den(133) = den(36)*den(125)
  den(134) = den(39)*den(125)
  den(135) = den(44)*den(119)
  den(136) = den(46)*den(119)
  den(137) = den(44)*den(125)
  den(138) = den(46)*den(125)
  den(140) = den(21)*den(139)
  den(141) = den(23)*den(139)
  den(142) = den(21)*den(92)
  den(143) = den(23)*den(92)
  den(144) = den(21)*den(109)
  den(145) = den(23)*den(109)
  den(146) = den(10)*den(139)
  den(147) = den(12)*den(139)
  den(148) = den(10)*den(103)
  den(149) = den(12)*den(103)
  den(150) = den(10)*den(86)
  den(151) = den(12)*den(86)
  den(152) = den(54)*den(92)
  den(153) = den(54)*den(103)
  den(154) = den(36)*den(92)
  den(155) = den(39)*den(92)
  den(156) = den(36)*den(103)
  den(157) = den(39)*den(103)
  den(158) = den(44)*den(92)
  den(159) = den(46)*den(92)
  den(160) = den(44)*den(103)
  den(161) = den(46)*den(103)
  den(162) = den(1)*den(2)*den(3)
  den(163) = den(2)*den(3)*den(6)
  den(164) = den(1)*den(57)
  den(165) = den(1)*den(14)*den(15)
  den(166) = den(6)*den(14)*den(15)
  den(167) = den(1)*den(59)
  den(168) = den(36)*den(50)
  den(169) = den(44)*den(50)
  den(170) = den(2)*den(150)
  den(171) = den(2)*den(151)
  den(172) = den(15)*den(144)
  den(173) = den(15)*den(145)
  den(174) = den(14)*den(148)
  den(175) = den(14)*den(149)
  den(176) = den(14)*den(153)
  den(177) = den(3)*den(142)
  den(178) = den(3)*den(143)
  den(179) = den(3)*den(152)
  den(180) = den(14)*den(156)
  den(181) = den(14)*den(157)
  den(182) = den(3)*den(154)
  den(183) = den(3)*den(155)
  den(184) = den(14)*den(160)
  den(185) = den(14)*den(161)
  den(186) = den(3)*den(158)
  den(187) = den(3)*den(159)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_eevttj_eexttxzg_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,124))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_eevttj_eexttxzg_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ top anti-top Z glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_eevttj_eexttxzg_1, only: hel_mem_opt
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_eevttj_eexttxzg_1, only: &
    & external_perm_eevttj_eexttxzg_1, &
    & external_perm_inv_eevttj_eexttxzg_1, &
    & extcomb_perm_eevttj_eexttxzg_1, &
    & average_factor_eevttj_eexttxzg_1, &
    & photonid_eevttj_eexttxzg_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_eevttj_eexttxzg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_eevttj_eexttxzg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_eevttj_eexttxzg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(124)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,124))
  end if

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMT, nMT, nMZ, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_eevttj_eexttxzg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMT, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex3(:), wf6(:,1), n3(:,2), t3x6(:,:,1))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,2), n3(:,3), t3x4(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 20, MT, 1_intkind1, wf6(:,2), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 40, MT, 1_intkind1, wf4(:,3), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,2), wf24(:,1), n3(:,4), t3x24(:,:,1))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,5), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,4), 3, MZ, 1_intkind1, wf4(:,5), n2(3))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf6(:,2), wf24(:,2), n3(:,6), t3x24(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex6(:), wf6(:,2), wf12(:,1), n3(:,8), t3x12(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 11, MT, 1_intkind1, wf8(:,2), n2(4))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,3), n3(:,9), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 11, MT, 1_intkind1, wf8(:,4), n2(5))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,6), n3(:,10), t3x4(:,:,4))
  call vert_AZ_Q(gZu,ntry, ex4(:), ex5(:), wf6(:,3), n3(:,11), t3x6(:,:,2))
  call prop_Q_A(ntry, wf4(:,6), 36, MT, 1_intkind1, wf4(:,7), n2(6))
  call prop_A_Q(ntry, wf6(:,3), 24, MT, 1_intkind1, wf6(:,4), n2(7))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,7), wf16(:,1), n3(:,12), t3x16(:,:,1))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,7), wf16(:,2), n3(:,13), t3x16(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,5), n3(:,14), t3x8(:,:,3))
  call vert_AV_Q(ntry, wf6(:,4), ex6(:), wf12(:,2), n3(:,15), t3x12(:,:,2))
  call prop_Q_A(ntry, wf8(:,5), 7, MT, 1_intkind1, wf8(:,6), n2(8))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,7), n3(:,16), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,7), 7, MT, 1_intkind1, wf8(:,8), n2(9))
  call vert_ZQ_A(gZu,ntry, ex5(:), wf4(:,7), wf12(:,3), n3(:,17), t3x12(:,:,3))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,7), wf8(:,9), n3(:,18), t3x8(:,:,5))
  call vert_VV_S(ntry, wf4(:,5), ex5(:), wf12(:,4), n3(:,19), t3x12(:,:,4))
  call vert_AZ_Q(gZu,ntry, wf4(:,3), ex5(:), wf12(:,5), n3(:,20), t3x12(:,:,5))
  call vert_AQ_S(gH,ntry, wf4(:,3), ex3(:), wf8(:,10), n3(:,21), t3x8(:,:,6))
  call vert_ZQ_A(gZl,ntry, ex5(:), ex1(:), wf6(:,5), n3(:,22), t3x6(:,:,3))
  call prop_Q_A(ntry, wf6(:,5), 17, ZERO, 0_intkind1, wf6(:,6), n2(10))
  call vert_QA_V(ntry, wf6(:,6), ex2(:), wf12(:,6), n3(:,23), t3x12(:,:,6))
  call vert_QA_V(ntry, wf4(:,7), ex4(:), wf8(:,11), n3(:,24), t3x8(:,:,7))
  call vert_QA_Z(gZl,ntry, wf6(:,6), ex2(:), wf12(:,7), n3(:,25), t3x12(:,:,7))
  call vert_QA_Z(gZu,ntry, wf4(:,7), ex4(:), wf8(:,12), n3(:,26), t3x8(:,:,8))
  call prop_W_W(ntry, wf12(:,7), 19, MZ, 1_intkind1, wf12(:,8), n2(11))
  call vert_QA_V(ntry, ex3(:), wf4(:,3), wf8(:,13), n3(:,27), t3x8(:,:,9))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,3), wf8(:,14), n3(:,28), t3x8(:,:,10))
  call vert_AZ_Q(gZl,ntry, ex2(:), ex5(:), wf6(:,7), n3(:,29), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 18, ZERO, 0_intkind1, wf6(:,8), n2(12))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,9), n3(:,30), t3x12(:,:,8))
  call vert_QA_Z(gZl,ntry, ex1(:), wf6(:,8), wf12(:,10), n3(:,31), t3x12(:,:,9))
  call prop_W_W(ntry, wf12(:,10), 19, MZ, 1_intkind1, wf12(:,11), n2(13))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,8), n3(:,32), t3x4(:,:,5))
  call counter_VVG_G(ntry, wf4(:,1), ex5(:), ex6(:), wf24(:,3), n4(:,1), t4x24(:,:,1))
  call counter_VVG_G(ntry, wf4(:,5), ex5(:), ex6(:), wf24(:,4), n4(:,2), t4x24(:,:,2))
  call counter_GG_S(ntry, wf4(:,8), ex6(:), wf8(:,15), n3(:,33), t3x8(:,:,11))
  call counter_VQ_A(ntry, wf4(:,1), wf6(:,2), wf24(:,5), n3(:,34), t3x24(:,:,3))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), wf6(:,2), wf24(:,6), n3(:,35), t3x24(:,:,4))
  call counter_VQ_A(ntry, ex6(:), wf6(:,2), wf12(:,12), n3(:,36), t3x12(:,:,10))
  call vert_QA_V(ntry, wf6(:,2), ex4(:), wf12(:,13), n3(:,37), t3x12(:,:,11))
  call counter_VG_G(ntry, wf4(:,5), ex6(:), 32, wf8(:,16), 35, n3(:,38), t3x8(:,:,12))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,7), wf16(:,3), n3(:,39), t3x16(:,:,3))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,7), wf16(:,4), n3(:,40), t3x16(:,:,4))
  call counter_AV_Q(ntry, wf6(:,4), ex6(:), wf12(:,14), n3(:,41), t3x12(:,:,12))
  call vert_QA_V(ntry, ex3(:), wf6(:,4), wf12(:,15), n3(:,42), t3x12(:,:,13))
  call counter_ZQ_A(gZu,ntry, ex5(:), wf4(:,7), wf12(:,16), n3(:,43), t3x12(:,:,14))
  call counter_AZ_Q(gZu,ntry, wf4(:,3), ex5(:), wf12(:,17), n3(:,44), t3x12(:,:,15))
  call counter_VG_G(ntry, ex5(:), ex6(:), 32, wf6(:,9), 48, n3(:,45), t3x6(:,:,5))
  call vert_AV_Q(ntry, ex4(:), wf6(:,9), wf12(:,18), n3(:,46), t3x12(:,:,16))
  call vert_VQ_A(ntry, wf6(:,9), ex3(:), wf12(:,19), n3(:,47), t3x12(:,:,17))
  call prop_Q_A(ntry, wf12(:,19), 52, MT, 1_intkind1, wf12(:,20), n2(14))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,17), n3(:,48), t3x8(:,:,13))
  call prop_Q_A(ntry, wf12(:,1), 52, MT, 1_intkind1, wf12(:,21), n2(15))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,18), n3(:,49), t3x8(:,:,14))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,9), n3(:,50), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,9), 40, MT, 1_intkind1, wf4(:,10), n2(16))
  call counter_AQ_S(gH,ntry, ex4(:), wf4(:,7), wf8(:,19), n3(:,51), t3x8(:,:,15))
  call prop_Q_A(ntry, wf12(:,3), 52, MT, 1_intkind1, wf12(:,22), n2(17))
  call vert_AZ_Q(gZu,ntry, wf4(:,10), ex5(:), wf12(:,23), n3(:,52), t3x12(:,:,18))
  call vert_AQ_S(gH,ntry, wf4(:,10), ex3(:), wf8(:,20), n3(:,53), t3x8(:,:,16))
  call counter_AZ_Q(gZu,ntry, ex4(:), ex5(:), wf6(:,10), n3(:,54), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,10), 24, MT, 1_intkind1, wf6(:,11), n2(18))
  call vert_AV_Q(ntry, wf6(:,11), ex6(:), wf12(:,24), n3(:,55), t3x12(:,:,19))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,21), n3(:,56), t3x8(:,:,17))
  call prop_A_Q(ntry, wf12(:,2), 56, MT, 1_intkind1, wf12(:,25), n2(19))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,22), n3(:,57), t3x8(:,:,18))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,11), n3(:,58), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,11), 36, MT, 1_intkind1, wf4(:,12), n2(20))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,12), wf16(:,5), n3(:,59), t3x16(:,:,5))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,12), wf16(:,6), n3(:,60), t3x16(:,:,6))
  call counter_AQ_S(gH,ntry, wf4(:,3), ex3(:), wf8(:,23), n3(:,61), t3x8(:,:,19))
  call prop_A_Q(ntry, wf12(:,5), 56, MT, 1_intkind1, wf12(:,26), n2(21))
  call vert_ZQ_A(gZu,ntry, ex5(:), wf4(:,12), wf12(:,27), n3(:,62), t3x12(:,:,20))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,12), wf8(:,24), n3(:,63), t3x8(:,:,20))
  call counter_ZQ_A(gZu,ntry, ex5(:), ex3(:), wf6(:,12), n3(:,64), t3x6(:,:,7))
  call prop_Q_A(ntry, wf6(:,12), 20, MT, 1_intkind1, wf6(:,13), n2(22))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,13), wf24(:,7), n3(:,65), t3x24(:,:,5))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf6(:,13), wf24(:,8), n3(:,66), t3x24(:,:,6))
  call vert_VQ_A(ntry, ex6(:), wf6(:,13), wf12(:,28), n3(:,67), t3x12(:,:,21))
  call counter_GG_V(ntry, wf4(:,8), 12, ex6(:), 32, wf8(:,25), n3(:,68), t3x8(:,:,21))
  call counter_QA_V(ntry, wf4(:,7), ex4(:), wf8(:,26), n3(:,69), t3x8(:,:,22))
  call counter_QA_Z(gZu,ntry, wf4(:,7), ex4(:), wf8(:,27), n3(:,70), t3x8(:,:,23))
  call vert_QA_V(ntry, ex3(:), wf4(:,10), wf8(:,28), n3(:,71), t3x8(:,:,24))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,10), wf8(:,29), n3(:,72), t3x8(:,:,25))
  call counter_QA_V(ntry, ex3(:), wf4(:,3), wf8(:,30), n3(:,73), t3x8(:,:,26))
  call counter_QA_Z(gZu,ntry, ex3(:), wf4(:,3), wf8(:,31), n3(:,74), t3x8(:,:,27))
  call vert_QA_V(ntry, wf4(:,12), ex4(:), wf8(:,32), n3(:,75), t3x8(:,:,28))
  call vert_QA_Z(gZu,ntry, wf4(:,12), ex4(:), wf8(:,33), n3(:,76), t3x8(:,:,29))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,7), n3(:,77), t3x16(:,:,7))
  call counter_Q_A(cttt,6,ntry, wf6(:,2), 20, wf6(:,14), n2(23))
  call prop_A_Q(ntry, wf16(:,7), 43, MT, 1_intkind1, wf16(:,8), n2(24))
  call vert_AZ_Q(gZu,ntry, wf4(:,3), wf4(:,5), wf16(:,9), n3(:,78), t3x16(:,:,8))
  call prop_A_Q(ntry, wf16(:,9), 43, MT, 1_intkind1, wf16(:,10), n2(25))
  call counter_A_Q(cttt,6,ntry, wf4(:,3), 40, wf4(:,13), n2(26))
  call prop_Q_A(ntry, wf24(:,1), 23, MT, 1_intkind1, wf24(:,9), n2(27))
  call prop_Q_A(ntry, wf24(:,2), 23, MT, 1_intkind1, wf24(:,10), n2(28))
  call prop_Q_A(ntry, wf6(:,14), 20, MT, 1_intkind1, wf6(:,15), n2(29))
  call vert_VQ_A(ntry, ex6(:), wf6(:,15), wf12(:,29), n3(:,79), t3x12(:,:,22))
  call counter_A_Q(cttt,6,ntry, wf8(:,2), 11, wf8(:,34), n2(30))
  call counter_A_Q(cttt,6,ntry, wf8(:,4), 11, wf8(:,35), n2(31))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,11), n3(:,80), t3x24(:,:,7))
  call counter_Q_A(cttt,6,ntry, wf4(:,7), 36, wf4(:,14), n2(32))
  call prop_A_Q(ntry, wf24(:,11), 27, MT, 1_intkind1, wf24(:,12), n2(33))
  call vert_AZ_Q(gZu,ntry, wf6(:,4), wf4(:,5), wf24(:,13), n3(:,81), t3x24(:,:,8))
  call prop_A_Q(ntry, wf24(:,13), 27, MT, 1_intkind1, wf24(:,14), n2(34))
  call counter_A_Q(cttt,6,ntry, wf6(:,4), 24, wf6(:,16), n2(35))
  call prop_Q_A(ntry, wf16(:,1), 39, MT, 1_intkind1, wf16(:,11), n2(36))
  call prop_Q_A(ntry, wf16(:,2), 39, MT, 1_intkind1, wf16(:,12), n2(37))
  call counter_Q_A(cttt,6,ntry, wf8(:,6), 7, wf8(:,36), n2(38))
  call counter_Q_A(cttt,6,ntry, wf8(:,8), 7, wf8(:,37), n2(39))
  call prop_A_Q(ntry, wf6(:,16), 24, MT, 1_intkind1, wf6(:,17), n2(40))
  call vert_AV_Q(ntry, wf6(:,17), ex6(:), wf12(:,30), n3(:,82), t3x12(:,:,23))
  call prop_Q_A(ntry, wf4(:,14), 36, MT, 1_intkind1, wf4(:,15), n2(41))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,15), wf8(:,38), n3(:,83), t3x8(:,:,30))
  call vert_ZQ_A(gZu,ntry, ex5(:), wf4(:,15), wf12(:,31), n3(:,84), t3x12(:,:,24))
  call prop_A_Q(ntry, wf4(:,13), 40, MT, 1_intkind1, wf4(:,16), n2(42))
  call vert_AQ_S(gH,ntry, wf4(:,16), ex3(:), wf8(:,39), n3(:,85), t3x8(:,:,31))
  call vert_AZ_Q(gZu,ntry, wf4(:,16), ex5(:), wf12(:,32), n3(:,86), t3x12(:,:,25))
  call vert_QA_V(ntry, wf4(:,15), ex4(:), wf8(:,40), n3(:,87), t3x8(:,:,32))
  call vert_QA_Z(gZu,ntry, wf4(:,15), ex4(:), wf8(:,41), n3(:,88), t3x8(:,:,33))
  call vert_QA_V(ntry, ex3(:), wf4(:,16), wf8(:,42), n3(:,89), t3x8(:,:,34))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,16), wf8(:,43), n3(:,90), t3x8(:,:,35))
  call vert_QA_V(ntry, wf8(:,6), ex4(:), wf16(:,13), n3(:,91), t3x16(:,:,9))
  call vert_QA_V(ntry, wf8(:,8), ex4(:), wf16(:,14), n3(:,92), t3x16(:,:,10))
  call vert_ZQ_A(gZu,ntry, ex5(:), wf8(:,6), wf24(:,15), n3(:,93), t3x24(:,:,9))
  call prop_Q_A(ntry, wf24(:,15), 23, MT, 1_intkind1, wf24(:,16), n2(43))
  call vert_ZQ_A(gZu,ntry, ex5(:), wf8(:,8), wf24(:,17), n3(:,94), t3x24(:,:,10))
  call prop_Q_A(ntry, wf24(:,17), 23, MT, 1_intkind1, wf24(:,18), n2(44))
  call vert_VQ_A(ntry, ex6(:), wf8(:,6), wf16(:,15), n3(:,95), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,15), 39, MT, 1_intkind1, wf16(:,16), n2(45))
  call vert_VQ_A(ntry, ex6(:), wf8(:,8), wf16(:,17), n3(:,96), t3x16(:,:,12))
  call prop_Q_A(ntry, wf16(:,17), 39, MT, 1_intkind1, wf16(:,18), n2(46))
  call vert_QA_V(ntry, ex3(:), wf8(:,2), wf16(:,19), n3(:,97), t3x16(:,:,13))
  call vert_QA_V(ntry, ex3(:), wf8(:,4), wf16(:,20), n3(:,98), t3x16(:,:,14))
  call vert_AZ_Q(gZu,ntry, wf8(:,2), ex5(:), wf24(:,19), n3(:,99), t3x24(:,:,11))
  call prop_A_Q(ntry, wf24(:,19), 27, MT, 1_intkind1, wf24(:,20), n2(47))
  call vert_AZ_Q(gZu,ntry, wf8(:,4), ex5(:), wf24(:,21), n3(:,100), t3x24(:,:,12))
  call prop_A_Q(ntry, wf24(:,21), 27, MT, 1_intkind1, wf24(:,22), n2(48))
  call vert_AV_Q(ntry, wf8(:,2), ex6(:), wf16(:,21), n3(:,101), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,21), 43, MT, 1_intkind1, wf16(:,22), n2(49))
  call vert_AV_Q(ntry, wf8(:,4), ex6(:), wf16(:,23), n3(:,102), t3x16(:,:,16))
  call prop_A_Q(ntry, wf16(:,23), 43, MT, 1_intkind1, wf16(:,24), n2(50))
  call vert_QS_A(gH,ntry, ex3(:), wf12(:,4), wf24(:,23), n3(:,103), t3x24(:,:,13))
  call prop_Q_A(ntry, wf24(:,23), 23, MT, 1_intkind1, wf24(:,24), n2(51))
  call vert_SA_Q(gH,ntry, wf12(:,4), ex4(:), wf24(:,25), n3(:,104), t3x24(:,:,14))
  call prop_A_Q(ntry, wf24(:,25), 27, MT, 1_intkind1, wf24(:,26), n2(52))
  call vert_VQ_A(ntry, wf12(:,6), ex3(:), wf24(:,27), n3(:,105), t3x24(:,:,15))
  call prop_Q_A(ntry, wf24(:,27), 23, MT, 1_intkind1, wf24(:,28), n2(53))
  call vert_ZQ_A(gZu,ntry, wf12(:,8), ex3(:), wf24(:,29), n3(:,106), t3x24(:,:,16))
  call prop_Q_A(ntry, wf24(:,29), 23, MT, 1_intkind1, wf24(:,30), n2(54))
  call vert_AV_Q(ntry, ex4(:), wf12(:,6), wf24(:,31), n3(:,107), t3x24(:,:,17))
  call prop_A_Q(ntry, wf24(:,31), 27, MT, 1_intkind1, wf24(:,32), n2(55))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf12(:,8), wf24(:,33), n3(:,108), t3x24(:,:,18))
  call prop_A_Q(ntry, wf24(:,33), 27, MT, 1_intkind1, wf24(:,34), n2(56))
  call vert_VQ_A(ntry, wf12(:,9), ex3(:), wf24(:,35), n3(:,109), t3x24(:,:,19))
  call prop_Q_A(ntry, wf24(:,35), 23, MT, 1_intkind1, wf24(:,36), n2(57))
  call vert_ZQ_A(gZu,ntry, wf12(:,11), ex3(:), wf24(:,37), n3(:,110), t3x24(:,:,20))
  call prop_Q_A(ntry, wf24(:,37), 23, MT, 1_intkind1, wf24(:,38), n2(58))
  call vert_AV_Q(ntry, ex4(:), wf12(:,9), wf24(:,39), n3(:,111), t3x24(:,:,21))
  call prop_A_Q(ntry, wf24(:,39), 27, MT, 1_intkind1, wf24(:,40), n2(59))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf12(:,11), wf24(:,41), n3(:,112), t3x24(:,:,22))
  call prop_A_Q(ntry, wf24(:,41), 27, MT, 1_intkind1, wf24(:,42), n2(60))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_eevttj_eexttxzg_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference
  
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,3), wf24(:,1), A(:,1), n3(:,113), t3x96(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,2), A(:,2), n3(:,114), t3x96(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,2), A(:,3), n3(:,115), t3x96(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,1), wf8(:,4), A(:,4), n3(:,116), t3x96(:,:,4), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,1), A(:,5), n3(:,117), t3x96(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,2), A(:,6), n3(:,118), t3x96(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,6), A(:,7), n3(:,119), t3x96(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf12(:,2), wf8(:,8), A(:,8), n3(:,120), t3x96(:,:,8), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,3), A(:,9), n3(:,121), t3x96(:,:,9), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,3), A(:,10), n3(:,122), t3x96(:,:,10), nhel, den(26))
    call Hcont_SS(nsync, wf8(:,9), wf12(:,4), A(:,11), n3(:,123), t3x96(:,:,11), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,5), A(:,12), n3(:,124), t3x96(:,:,12), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,5), A(:,13), n3(:,125), t3x96(:,:,13), nhel, den(31))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,10), A(:,14), n3(:,126), t3x96(:,:,14), nhel, den(33))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,11), A(:,15), n3(:,127), t3x96(:,:,15), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,8), A(:,16), n3(:,128), t3x96(:,:,16), nhel, den(40))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,13), A(:,17), n3(:,129), t3x96(:,:,17), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,14), A(:,18), n3(:,130), t3x96(:,:,18), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,11), wf12(:,9), A(:,19), n3(:,131), t3x96(:,:,19), nhel, den(45))
    call Hcont_VV(nsync, wf8(:,12), wf12(:,11), A(:,20), n3(:,132), t3x96(:,:,20), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,13), wf12(:,9), A(:,21), n3(:,133), t3x96(:,:,21), nhel, den(48))
    call Hcont_VV(nsync, wf8(:,14), wf12(:,11), A(:,22), n3(:,134), t3x96(:,:,22), nhel, den(49))

    call Hcont_VV(nsync, wf4(:,8), wf24(:,3), A(:,23), n3(:,135), t3x96(:,:,23), nhel, den(51))
    call Hcont_VV(nsync, wf4(:,8), wf24(:,4), A(:,24), n3(:,136), t3x96(:,:,24), nhel, den(52))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,15), A(:,25), n3(:,137), t3x96(:,:,25), nhel, den(55))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,15), A(:,26), n3(:,138), t3x96(:,:,26), nhel, den(55))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,5), A(:,27), n3(:,139), t3x96(:,:,27), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,6), A(:,28), n3(:,140), t3x96(:,:,28), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,12), A(:,29), n3(:,141), t3x96(:,:,29), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,12), A(:,30), n3(:,142), t3x96(:,:,30), nhel, den(13))
    call Hcont_VV(nsync, wf12(:,13), wf8(:,16), A(:,31), n3(:,143), t3x96(:,:,31), nhel, den(58))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,3), A(:,32), n3(:,144), t3x96(:,:,32), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,4), A(:,33), n3(:,145), t3x96(:,:,33), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,14), A(:,34), n3(:,146), t3x96(:,:,34), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,14), A(:,35), n3(:,147), t3x96(:,:,35), nhel, den(24))
    call Hcont_VV(nsync, wf8(:,16), wf12(:,15), A(:,36), n3(:,148), t3x96(:,:,36), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,16), A(:,37), n3(:,149), t3x96(:,:,37), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,16), A(:,38), n3(:,150), t3x96(:,:,38), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,17), A(:,39), n3(:,151), t3x96(:,:,39), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,17), A(:,40), n3(:,152), t3x96(:,:,40), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,18), A(:,41), n3(:,153), t3x96(:,:,41), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,18), A(:,42), n3(:,154), t3x96(:,:,42), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,1), wf12(:,20), A(:,43), n3(:,155), t3x96(:,:,43), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,3), wf12(:,20), A(:,44), n3(:,156), t3x96(:,:,44), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,17), wf12(:,21), A(:,45), n3(:,157), t3x96(:,:,45), nhel, den(69))
    call Hcont_QA(nsync, wf12(:,21), wf8(:,18), A(:,46), n3(:,158), t3x96(:,:,46), nhel, den(70))
    call Hcont_QA(nsync, wf24(:,1), wf4(:,10), A(:,47), n3(:,159), t3x96(:,:,47), nhel, den(5))
    call Hcont_QA(nsync, wf24(:,2), wf4(:,10), A(:,48), n3(:,160), t3x96(:,:,48), nhel, den(8))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,19), A(:,49), n3(:,161), t3x96(:,:,49), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,17), wf12(:,22), A(:,50), n3(:,162), t3x96(:,:,50), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,18), wf12(:,22), A(:,51), n3(:,163), t3x96(:,:,51), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,23), A(:,52), n3(:,164), t3x96(:,:,52), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,23), A(:,53), n3(:,165), t3x96(:,:,53), nhel, den(31))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,20), A(:,54), n3(:,166), t3x96(:,:,54), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,1), wf6(:,11), A(:,55), n3(:,167), t3x96(:,:,55), nhel, den(17))
    call Hcont_QA(nsync, wf16(:,2), wf6(:,11), A(:,56), n3(:,168), t3x96(:,:,56), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,24), A(:,57), n3(:,169), t3x96(:,:,57), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,24), A(:,58), n3(:,170), t3x96(:,:,58), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,21), wf12(:,25), A(:,59), n3(:,171), t3x96(:,:,59), nhel, den(77))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,22), A(:,60), n3(:,172), t3x96(:,:,60), nhel, den(78))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,5), A(:,61), n3(:,173), t3x96(:,:,61), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,4), wf16(:,6), A(:,62), n3(:,174), t3x96(:,:,62), nhel, den(19))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,23), A(:,63), n3(:,175), t3x96(:,:,63), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,21), wf12(:,26), A(:,64), n3(:,176), t3x96(:,:,64), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,22), wf12(:,26), A(:,65), n3(:,177), t3x96(:,:,65), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,27), A(:,66), n3(:,178), t3x96(:,:,66), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,27), A(:,67), n3(:,179), t3x96(:,:,67), nhel, den(26))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,24), A(:,68), n3(:,180), t3x96(:,:,68), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,7), A(:,69), n3(:,181), t3x96(:,:,69), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf24(:,8), A(:,70), n3(:,182), t3x96(:,:,70), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,28), A(:,71), n3(:,183), t3x96(:,:,71), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,28), A(:,72), n3(:,184), t3x96(:,:,72), nhel, den(13))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,25), A(:,73), n3(:,185), t3x96(:,:,73), nhel, den(83))
    call Hcont_VV(nsync, wf12(:,11), wf8(:,25), A(:,74), n3(:,186), t3x96(:,:,74), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,26), A(:,75), n3(:,187), t3x96(:,:,75), nhel, den(37))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,27), A(:,76), n3(:,188), t3x96(:,:,76), nhel, den(40))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,28), A(:,77), n3(:,189), t3x96(:,:,77), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,29), A(:,78), n3(:,190), t3x96(:,:,78), nhel, den(42))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,26), A(:,79), n3(:,191), t3x96(:,:,79), nhel, den(45))
    call Hcont_VV(nsync, wf12(:,11), wf8(:,27), A(:,80), n3(:,192), t3x96(:,:,80), nhel, den(47))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,28), A(:,81), n3(:,193), t3x96(:,:,81), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,11), wf8(:,29), A(:,82), n3(:,194), t3x96(:,:,82), nhel, den(49))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,30), A(:,83), n3(:,195), t3x96(:,:,83), nhel, den(41))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,31), A(:,84), n3(:,196), t3x96(:,:,84), nhel, den(42))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,32), A(:,85), n3(:,197), t3x96(:,:,85), nhel, den(37))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,33), A(:,86), n3(:,198), t3x96(:,:,86), nhel, den(40))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,30), A(:,87), n3(:,199), t3x96(:,:,87), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,11), wf8(:,31), A(:,88), n3(:,200), t3x96(:,:,88), nhel, den(49))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,32), A(:,89), n3(:,201), t3x96(:,:,89), nhel, den(45))
    call Hcont_VV(nsync, wf12(:,11), wf8(:,33), A(:,90), n3(:,202), t3x96(:,:,90), nhel, den(47))
    call Hcont_QA(nsync, wf6(:,14), wf16(:,8), A(:,91), n3(:,203), t3x96(:,:,91), nhel, den(88))
    call Hcont_QA(nsync, wf6(:,14), wf16(:,10), A(:,92), n3(:,204), t3x96(:,:,92), nhel, den(91))
    call Hcont_QA(nsync, wf4(:,13), wf24(:,9), A(:,93), n3(:,205), t3x96(:,:,93), nhel, den(94))
    call Hcont_QA(nsync, wf4(:,13), wf24(:,10), A(:,94), n3(:,206), t3x96(:,:,94), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,29), A(:,95), n3(:,207), t3x96(:,:,95), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,29), A(:,96), n3(:,208), t3x96(:,:,96), nhel, den(99))
    call Hcont_QA(nsync, wf12(:,21), wf8(:,34), A(:,97), n3(:,209), t3x96(:,:,97), nhel, den(100))
    call Hcont_QA(nsync, wf12(:,21), wf8(:,35), A(:,98), n3(:,210), t3x96(:,:,98), nhel, den(101))
    call Hcont_QA(nsync, wf4(:,14), wf24(:,12), A(:,99), n3(:,211), t3x96(:,:,99), nhel, den(105))
    call Hcont_QA(nsync, wf4(:,14), wf24(:,14), A(:,100), n3(:,212), t3x96(:,:,100), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,16), wf16(:,11), A(:,101), n3(:,213), t3x96(:,:,101), nhel, den(111))
    call Hcont_QA(nsync, wf6(:,16), wf16(:,12), A(:,102), n3(:,214), t3x96(:,:,102), nhel, den(113))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,36), A(:,103), n3(:,215), t3x96(:,:,103), nhel, den(114))
    call Hcont_QA(nsync, wf12(:,25), wf8(:,37), A(:,104), n3(:,216), t3x96(:,:,104), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,30), A(:,105), n3(:,217), t3x96(:,:,105), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,30), A(:,106), n3(:,218), t3x96(:,:,106), nhel, den(118))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,38), A(:,107), n3(:,219), t3x96(:,:,107), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,2), wf12(:,31), A(:,108), n3(:,220), t3x96(:,:,108), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,4), wf12(:,31), A(:,109), n3(:,221), t3x96(:,:,109), nhel, den(122))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,34), A(:,110), n3(:,222), t3x96(:,:,110), nhel, den(123))
    call Hcont_QA(nsync, wf12(:,22), wf8(:,35), A(:,111), n3(:,223), t3x96(:,:,111), nhel, den(124))
    call Hcont_SS(nsync, wf12(:,4), wf8(:,39), A(:,112), n3(:,224), t3x96(:,:,112), nhel, den(126))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,36), A(:,113), n3(:,225), t3x96(:,:,113), nhel, den(127))
    call Hcont_QA(nsync, wf12(:,26), wf8(:,37), A(:,114), n3(:,226), t3x96(:,:,114), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,6), wf12(:,32), A(:,115), n3(:,227), t3x96(:,:,115), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,8), wf12(:,32), A(:,116), n3(:,228), t3x96(:,:,116), nhel, den(130))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,40), A(:,117), n3(:,229), t3x96(:,:,117), nhel, den(131))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,41), A(:,118), n3(:,230), t3x96(:,:,118), nhel, den(132))
    call Hcont_VV(nsync, wf12(:,6), wf8(:,42), A(:,119), n3(:,231), t3x96(:,:,119), nhel, den(133))
    call Hcont_VV(nsync, wf12(:,8), wf8(:,43), A(:,120), n3(:,232), t3x96(:,:,120), nhel, den(134))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,40), A(:,121), n3(:,233), t3x96(:,:,121), nhel, den(135))
    call Hcont_VV(nsync, wf12(:,11), wf8(:,41), A(:,122), n3(:,234), t3x96(:,:,122), nhel, den(136))
    call Hcont_VV(nsync, wf12(:,9), wf8(:,42), A(:,123), n3(:,235), t3x96(:,:,123), nhel, den(137))
    call Hcont_VV(nsync, wf12(:,11), wf8(:,43), A(:,124), n3(:,236), t3x96(:,:,124), nhel, den(138))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,3)%j+A(j,5)%j+A(j,7)%j+A(j,9)%j+A(j,12)%j+A(j,15)%j+A(j,17)%j+A(j,19)%j+A(j,21)%j)*f(1)+(-A(j,2)%j &
       -A(j,4)%j-A(j,6)%j-A(j,8)%j-A(j,10)%j-A(j,13)%j-A(j,16)%j-A(j,18)%j-A(j,20)%j-A(j,22)%j)*f(2)+(A(j,11)%j+A(j,14)%j)*f(24)

  M2(1)%j = (-A(j,91)%j-A(j,93)%j-A(j,95)%j-A(j,97)%j-A(j,99)%j-A(j,101)%j-A(j,103)%j-A(j,105)%j-A(j,108)%j-A(j,110)%j-A(j,113)%j &
       -A(j,115)%j-A(j,117)%j-A(j,119)%j-A(j,121)%j-A(j,123)%j)*f(3)+(A(j,92)%j+A(j,94)%j+A(j,96)%j+A(j,98)%j+A(j,100)%j &
       +A(j,102)%j+A(j,104)%j+A(j,106)%j+A(j,109)%j+A(j,111)%j+A(j,114)%j+A(j,116)%j+A(j,118)%j+A(j,120)%j+A(j,122)%j &
       +A(j,124)%j)*f(4)-A(j,23)%j*f(5)+(A(j,29)%j+A(j,34)%j+A(j,47)%j+A(j,52)%j+A(j,61)%j+A(j,66)%j+A(j,77)%j+A(j,81)%j+A(j,85)%j &
       +A(j,89)%j)*f(6)+(-A(j,30)%j-A(j,35)%j-A(j,48)%j-A(j,53)%j-A(j,62)%j-A(j,67)%j-A(j,78)%j-A(j,82)%j-A(j,86)%j &
       -A(j,90)%j)*f(7)+(A(j,27)%j+A(j,32)%j+A(j,37)%j+A(j,39)%j+A(j,45)%j+A(j,50)%j+A(j,55)%j+A(j,57)%j+A(j,59)%j+A(j,64)%j &
       +A(j,69)%j+A(j,71)%j+A(j,75)%j+A(j,79)%j+A(j,83)%j+A(j,87)%j)*f(8)+(-A(j,28)%j-A(j,33)%j-A(j,38)%j-A(j,40)%j-A(j,46)%j &
       -A(j,51)%j-A(j,56)%j-A(j,58)%j-A(j,60)%j-A(j,65)%j-A(j,70)%j-A(j,72)%j-A(j,76)%j-A(j,80)%j-A(j,84)%j-A(j,88)%j)*f(9)+( &
       -A(j,41)%j-A(j,43)%j)*f(10)+(A(j,31)%j+A(j,36)%j+A(j,42)%j+A(j,44)%j+A(j,73)%j+A(j,74)%j)*f(11)-A(j,24)%j*f(12) &
       +A(j,26)%j*f(22)+(-A(j,107)%j-A(j,112)%j)*f(25)+(A(j,54)%j+A(j,68)%j)*f(26)+(A(j,49)%j+A(j,63)%j)*f(27)+A(j,25)%j*f(28)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_eevttj_eexttxzg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_eevttj_eexttxzg_1_/**/REALKIND
