
module ol_vamp_1_eellllbb_nexnmeeexmxbbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eellllbb_nexnmeeexmxbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eellllbb_nexnmeeexmxbbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eellllbb_nexnmeeexmxbbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_eellllbb_nexnmeeexmxbbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eellllbb_nexnmeeexmxbbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eellllbb_nexnmeeexmxbbx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(1),h0tab(:,1),[128,5,24,34,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,5),wf4(:,3) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,1),heltab2x256(:,:,1))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(1),n2h128(1))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(2),h0tab(:,2),[128,5,24,34,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,5),wf4(:,10) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,2),heltab2x256(:,:,2))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(2),n2h128(2))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(3),h0tab(:,3),[128,24,5,34,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,3),wf4(:,5) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,3),heltab2x256(:,:,3))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(3),n2h128(3))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(4),h0tab(:,4),[128,24,5,34,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,10),wf4(:,5) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,4),heltab2x256(:,:,4))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(4),n2h128(4))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(5),h0tab(:,5),[128,5,34,24,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,5),wf4(:,6) &
    ,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,5),heltab2x256(:,:,5))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(5),n2h128(5))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(6),h0tab(:,6),[128,5,34,24,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,5),wf4(:,6) &
    ,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,6),heltab2x256(:,:,6))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(6),n2h128(6))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(7),h0tab(:,7),[128,9,20,34,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,13),wf4(:,12) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,7),heltab2x256(:,:,7))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(7),n2h128(7))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(8),h0tab(:,8),[128,9,20,34,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,13),wf4(:,15) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,8),heltab2x256(:,:,8))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(8),n2h128(8))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(9),h0tab(:,9),[128,20,9,34,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,12),wf4(:,13) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,9),heltab2x256(:,:,9))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(9),n2h128(9))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(10),h0tab(:,10),[128,20,9,34,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,15),wf4(: &
    ,13),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,10),heltab2x256(:,:,10))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(10),n2h128(10))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(11),h0tab(:,11),[128,9,34,20,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,13),wf4(: &
    ,6),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,11),heltab2x256(:,:,11))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(11),n2h128(11))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(12),h0tab(:,12),[128,9,34,20,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,13),wf4(: &
    ,6),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,12),heltab2x256(:,:,12))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(12),n2h128(12))
  call Hloop_AW_Q(ntryL,G1H128(1),wf4(:,5),G1H32(1),m3h4x32(:,1),heltab2x128(:,:,1))
  call Hloop_A_Q(ntryL,G1H32(1),133,nMT,G2H32(1),n2h32(1))
  call Hloop_AW_Q(ntryL,G1H128(2),wf4(:,5),G1H32(1),m3h4x32(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G1H32(1),133,nMT,G2H32(2),n2h32(2))
  call Hloop_AV_Q(ntryL,G1H128(3),wf4(:,3),G1H32(1),m3h4x32(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(3),n2h32(3))
  call Hloop_AZ_Q(ntryL,G1H128(4),wf4(:,10),G1H32(1),ngZd,m3h4x32(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(4),n2h32(4))
  call Hloop_AW_Q(ntryL,G1H128(5),wf4(:,5),G1H32(1),m3h4x32(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G1H32(1),133,nMT,G2H32(5),n2h32(5))
  call Hloop_AW_Q(ntryL,G1H128(6),wf4(:,5),G1H32(1),m3h4x32(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G1H32(1),133,nMT,G2H32(6),n2h32(6))
  call Hloop_AW_Q(ntryL,G1H128(7),wf4(:,13),G1H32(1),m3h4x32(:,7),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G1H32(1),137,nMT,G2H32(7),n2h32(7))
  call Hloop_AW_Q(ntryL,G1H128(8),wf4(:,13),G1H32(1),m3h4x32(:,8),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G1H32(1),137,nMT,G2H32(8),n2h32(8))
  call Hloop_AV_Q(ntryL,G1H128(9),wf4(:,12),G1H32(1),m3h4x32(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(9),n2h32(9))
  call Hloop_AZ_Q(ntryL,G1H128(10),wf4(:,15),G1H32(1),ngZd,m3h4x32(:,10),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(10),n2h32(10))
  call Hloop_AW_Q(ntryL,G1H128(11),wf4(:,13),G1H32(1),m3h4x32(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G1H32(1),137,nMT,G2H32(11),n2h32(11))
  call Hloop_AW_Q(ntryL,G1H128(12),wf4(:,13),G1H32(1),m3h4x32(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G1H32(1),137,nMT,G2H32(12),n2h32(12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(4),[G2H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(10),[G2H32(9)])
  call Hotf_5pt_reduction(G2H32(1),RedSet_5(1),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
  call HG1shiftOLR(G1H32(2),64,32)
  call Hotf_5pt_reduction(G2H32(2),RedSet_5(1),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(8),64,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(2),mass5set(:,2),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),64,32)
  call Hotf_5pt_reduction(G2H32(5),RedSet_5(3),mass5set(:,3),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
  call HG1shiftOLR(G1H32(20),64,32)
  call Hotf_5pt_reduction(G2H32(6),RedSet_5(3),mass5set(:,3),  & 
G1H32(25),G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
  call HG1shiftOLR(G1H32(26),64,32)
  call Hotf_5pt_reduction(G2H32(7),RedSet_5(4),mass5set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
  call HG1shiftOLR(G1H32(32),64,32)
  call Hotf_5pt_reduction(G2H32(8),RedSet_5(4),mass5set(:,1),  & 
G1H32(37),G1H32(38),G1H32(39),G1H32(40),G1H32(41),G1H32(42),32)
  call HG1shiftOLR(G1H32(38),64,32)
  call Hotf_5pt_reduction(G2H32(10),RedSet_5(5),mass5set(:,2),  & 
G1H32(43),G1H32(44),G1H32(45),G1H32(46),G1H32(47),G1H32(48),32)
  call HG1shiftOLR(G1H32(44),64,32)
  call Hotf_5pt_reduction(G2H32(11),RedSet_5(6),mass5set(:,3),  & 
G1H32(49),G1H32(50),G1H32(51),G1H32(52),G1H32(53),G1H32(54),32)
  call HG1shiftOLR(G1H32(50),64,32)
  call Hotf_5pt_reduction(G2H32(12),RedSet_5(6),mass5set(:,3),  & 
G1H32(55),G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
  call HG1shiftOLR(G1H32(56),64,32)
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,3),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(1),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(2),ex7(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_AV_Q(ntryL,G1H32(4),wf4(:,3),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,3),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(3),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H32(6),wf4(:,3),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(4),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(5),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(8),ex7(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(8),n2h8(8))
  call Hloop_AW_Q(ntryL,G1H32(13),wf4(:,5),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(9),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(14),ex7(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_AW_Q(ntryL,G1H32(16),wf4(:,5),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(10),n2h8(10))
  call Hloop_AW_Q(ntryL,G1H32(17),wf4(:,5),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(11),n2h8(11))
  call Hloop_AW_Q(ntryL,G1H32(18),wf4(:,5),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(12),n2h8(12))
  call Hloop_AW_Q(ntryL,G1H32(19),wf4(:,6),G1H8(1),m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(13),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(20),ex7(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_AW_Q(ntryL,G1H32(22),wf4(:,6),G1H8(1),m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(14),n2h8(14))
  call Hloop_AW_Q(ntryL,G1H32(23),wf4(:,6),G1H8(1),m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(15),n2h8(15))
  call Hloop_AW_Q(ntryL,G1H32(24),wf4(:,6),G1H8(1),m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(16),n2h8(16))
  call Hloop_AW_Q(ntryL,G1H32(25),wf4(:,6),G1H8(1),m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(17),n2h8(17))
call HGT_raise_alpha_OLR(G1H32(26),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(26),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(26),ex7(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,22))
  call Hloop_AW_Q(ntryL,G1H32(28),wf4(:,6),G1H8(1),m3h4x8(:,18),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(18),n2h8(18))
  call Hloop_AW_Q(ntryL,G1H32(29),wf4(:,6),G1H8(1),m3h4x8(:,19),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(19),n2h8(19))
  call Hloop_AW_Q(ntryL,G1H32(30),wf4(:,6),G1H8(1),m3h4x8(:,20),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(20),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H32(31),wf4(:,12),G1H8(1),m3h4x8(:,21),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(21),n2h8(21))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(32),ex7(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,27))
  call Hloop_AV_Q(ntryL,G1H32(34),wf4(:,12),G1H8(1),m3h4x8(:,22),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(22),n2h8(22))
  call Hloop_AV_Q(ntryL,G1H32(35),wf4(:,12),G1H8(1),m3h4x8(:,23),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(23),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H32(36),wf4(:,12),G1H8(1),m3h4x8(:,24),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(24),n2h8(24))
  call Hloop_AZ_Q(ntryL,G1H32(37),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,25),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(25),n2h8(25))
call HGT_raise_alpha_OLR(G1H32(38),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(38),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(38),ex7(:),G1H16(7),m3h2x16(:,7),heltab2x32(:,:,32))
  call Hloop_AZ_Q(ntryL,G1H32(40),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,26),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(26),n2h8(26))
  call Hloop_AZ_Q(ntryL,G1H32(41),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,27),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(27),n2h8(27))
  call Hloop_AZ_Q(ntryL,G1H32(42),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,28),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(28),n2h8(28))
  call Hloop_AW_Q(ntryL,G1H32(43),wf4(:,13),G1H8(1),m3h4x8(:,29),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(29),n2h8(29))
call HGT_raise_alpha_OLR(G1H32(44),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(44),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(44),ex7(:),G1H16(8),m3h2x16(:,8),heltab2x32(:,:,37))
  call Hloop_AW_Q(ntryL,G1H32(46),wf4(:,13),G1H8(1),m3h4x8(:,30),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(30),n2h8(30))
  call Hloop_AW_Q(ntryL,G1H32(47),wf4(:,13),G1H8(1),m3h4x8(:,31),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(31),n2h8(31))
  call Hloop_AW_Q(ntryL,G1H32(48),wf4(:,13),G1H8(1),m3h4x8(:,32),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(32),n2h8(32))
  call Hloop_AW_Q(ntryL,G1H32(49),wf4(:,6),G1H8(1),m3h4x8(:,33),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(33),n2h8(33))
call HGT_raise_alpha_OLR(G1H32(50),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(50),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(50),ex7(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,42))
  call Hloop_AW_Q(ntryL,G1H32(52),wf4(:,6),G1H8(1),m3h4x8(:,34),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(34),n2h8(34))
  call Hloop_AW_Q(ntryL,G1H32(53),wf4(:,6),G1H8(1),m3h4x8(:,35),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(35),n2h8(35))
  call Hloop_AW_Q(ntryL,G1H32(54),wf4(:,6),G1H8(1),m3h4x8(:,36),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(36),n2h8(36))
  call Hloop_AW_Q(ntryL,G1H32(55),wf4(:,6),G1H8(1),m3h4x8(:,37),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(37),n2h8(37))
call HGT_raise_alpha_OLR(G1H32(56),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(56),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(56),ex7(:),G1H16(10),m3h2x16(:,10),heltab2x32(:,:,47))
  call Hloop_AW_Q(ntryL,G1H32(58),wf4(:,6),G1H8(1),m3h4x8(:,38),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(38),n2h8(38))
  call Hloop_AW_Q(ntryL,G1H32(59),wf4(:,6),G1H8(1),m3h4x8(:,39),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(39),n2h8(39))
  call Hloop_AW_Q(ntryL,G1H32(60),wf4(:,6),G1H8(1),m3h4x8(:,40),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(40),n2h8(40))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(24)])
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),64,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(1),mass4set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(8),64,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(2),mass4set(:,2),  & 
G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(13),98,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(2),mass5set(:,2),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(18),64,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(3),mass4set(:,3),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(24),64,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(4),mass4set(:,4),  & 
G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(29),98,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(3),mass5set(:,3),  & 
G1H8(33),G1H8(34),G1H8(35),G1H8(36),G1H8(37),G1H8(38),8)
  call HG1shiftOLR(G1H8(34),64,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(1),mass4set(:,1),  & 
G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),8)
  call HG1shiftOLR(G1H8(40),64,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(5),mass4set(:,1),  & 
G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(45),88,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(3),mass5set(:,3),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),64,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(1),mass4set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),8)
  call HG1shiftOLR(G1H8(56),64,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(5),mass4set(:,1),  & 
G1H8(60),G1H8(61),G1H8(62),G1H8(63),G1H8(64),8)
  call HG1shiftOLR(G1H8(61),88,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(4),mass5set(:,1),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(66),64,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(6),mass4set(:,1),  & 
G1H8(71),G1H8(72),G1H8(73),G1H8(74),G1H8(75),8)
  call HG1shiftOLR(G1H8(72),64,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(7),mass4set(:,2),  & 
G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(77),98,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(5),mass5set(:,2),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),64,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(8),mass4set(:,3),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),8)
  call HG1shiftOLR(G1H8(88),64,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(9),mass4set(:,4),  & 
G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(93),98,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(6),mass5set(:,3),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),64,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(6),mass4set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),8)
  call HG1shiftOLR(G1H8(104),64,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(10),mass4set(:,1),  & 
G1H8(108),G1H8(109),G1H8(110),G1H8(111),G1H8(112),8)
  call HG1shiftOLR(G1H8(109),84,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(6),mass5set(:,3),  & 
G1H8(113),G1H8(114),G1H8(115),G1H8(116),G1H8(117),G1H8(118),8)
  call HG1shiftOLR(G1H8(114),64,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(6),mass4set(:,1),  & 
G1H8(119),G1H8(120),G1H8(121),G1H8(122),G1H8(123),8)
  call HG1shiftOLR(G1H8(120),64,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(10),mass4set(:,1),  & 
G1H8(124),G1H8(125),G1H8(126),G1H8(127),G1H8(128),8)
  call HG1shiftOLR(G1H8(125),84,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(119),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G1H8(118)])
  call Hloop_AW_Q(ntryL,G1H8(1),wf4(:,6),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex7(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_AW_Q(ntryL,G1H8(7),wf4(:,6),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(2),n2h2(2))
  call Hloop_AW_Q(ntryL,G1H8(12),wf4(:,6),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(3),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(8),ex7(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,5))
  call Hloop_AW_Q(ntryL,G1H8(11),wf4(:,6),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(13),ex7(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,7))
  call Hloop_AW_Q(ntryL,G1H8(16),wf4(:,6),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(5),n2h2(5))
  call Hloop_AW_Q(ntryL,G1H8(17),wf4(:,6),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(6),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(18),ex7(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,10))
  call Hloop_AW_Q(ntryL,G1H8(23),wf4(:,6),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(7),n2h2(7))
  call Hloop_AW_Q(ntryL,G1H8(28),wf4(:,6),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(8),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(24),ex7(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,13))
  call Hloop_AW_Q(ntryL,G1H8(27),wf4(:,6),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(9),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(29),ex7(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,15))
  call Hloop_AW_Q(ntryL,G1H8(32),wf4(:,6),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(10),n2h2(10))
  call Hloop_AV_Q(ntryL,G1H8(33),wf4(:,3),G1H2(1),m3h4x2(:,11),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(11),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(34),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(34),ex7(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,18))
  call Hloop_AV_Q(ntryL,G1H8(39),wf4(:,3),G1H2(1),m3h4x2(:,12),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(12),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(44),wf4(:,3),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(13),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(40),ex7(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,21))
  call Hloop_AV_Q(ntryL,G1H8(43),wf4(:,3),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(14),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(45),ex7(:),G1H4(9),m3h2x4(:,9),heltab2x8(:,:,23))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,3),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(15),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(49),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(16),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(50),ex7(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,26))
  call Hloop_AZ_Q(ntryL,G1H8(55),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(17),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H8(60),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(18),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(56),ex7(:),G1H4(11),m3h2x4(:,11),heltab2x8(:,:,29))
  call Hloop_AZ_Q(ntryL,G1H8(59),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,19),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(19),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(61),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(61),ex7(:),G1H4(12),m3h2x4(:,12),heltab2x8(:,:,31))
  call Hloop_AZ_Q(ntryL,G1H8(64),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,20),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(20),n2h2(20))
  call Hloop_AW_Q(ntryL,G1H8(65),wf4(:,6),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(21),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(66),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(66),ex7(:),G1H4(13),m3h2x4(:,13),heltab2x8(:,:,34))
  call Hloop_AW_Q(ntryL,G1H8(71),wf4(:,6),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(22),n2h2(22))
  call Hloop_AW_Q(ntryL,G1H8(76),wf4(:,6),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(23),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(72),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(72),ex7(:),G1H4(14),m3h2x4(:,14),heltab2x8(:,:,37))
  call Hloop_AW_Q(ntryL,G1H8(75),wf4(:,6),G1H2(1),m3h4x2(:,24),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(24),n2h2(24))
call HGT_raise_alpha_OLR(G1H8(77),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(77),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(77),ex7(:),G1H4(15),m3h2x4(:,15),heltab2x8(:,:,39))
  call Hloop_AW_Q(ntryL,G1H8(80),wf4(:,6),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(25),n2h2(25))
  call Hloop_AW_Q(ntryL,G1H8(81),wf4(:,6),G1H2(1),m3h4x2(:,26),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(26),n2h2(26))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(82),ex7(:),G1H4(16),m3h2x4(:,16),heltab2x8(:,:,42))
  call Hloop_AW_Q(ntryL,G1H8(87),wf4(:,6),G1H2(1),m3h4x2(:,27),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(27),n2h2(27))
  call Hloop_AW_Q(ntryL,G1H8(92),wf4(:,6),G1H2(1),m3h4x2(:,28),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(28),n2h2(28))
call HGT_raise_alpha_OLR(G1H8(88),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(88),ex7(:),G1H4(17),m3h2x4(:,17),heltab2x8(:,:,45))
  call Hloop_AW_Q(ntryL,G1H8(91),wf4(:,6),G1H2(1),m3h4x2(:,29),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(29),n2h2(29))
call HGT_raise_alpha_OLR(G1H8(93),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(93),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(93),ex7(:),G1H4(18),m3h2x4(:,18),heltab2x8(:,:,47))
  call Hloop_AW_Q(ntryL,G1H8(96),wf4(:,6),G1H2(1),m3h4x2(:,30),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(30),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H8(97),wf4(:,12),G1H2(1),m3h4x2(:,31),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(31),n2h2(31))
call HGT_raise_alpha_OLR(G1H8(98),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(98),ex7(:),G1H4(19),m3h2x4(:,19),heltab2x8(:,:,50))
  call Hloop_AV_Q(ntryL,G1H8(103),wf4(:,12),G1H2(1),m3h4x2(:,32),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(32),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H8(108),wf4(:,12),G1H2(1),m3h4x2(:,33),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(33),n2h2(33))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(104),ex7(:),G1H4(20),m3h2x4(:,20),heltab2x8(:,:,53))
  call Hloop_AV_Q(ntryL,G1H8(107),wf4(:,12),G1H2(1),m3h4x2(:,34),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(34),n2h2(34))
call HGT_raise_alpha_OLR(G1H8(109),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(109),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(109),ex7(:),G1H4(21),m3h2x4(:,21),heltab2x8(:,:,55))
  call Hloop_AV_Q(ntryL,G1H8(112),wf4(:,12),G1H2(1),m3h4x2(:,35),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(35),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H8(113),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,36),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(36),n2h2(36))
call HGT_raise_alpha_OLR(G1H8(114),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(114),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(114),ex7(:),G1H4(22),m3h2x4(:,22),heltab2x8(:,:,58))
  call Hloop_AZ_Q(ntryL,G1H8(119),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,37),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(37),n2h2(37))
  call Hloop_AZ_Q(ntryL,G1H8(124),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,38),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(38),n2h2(38))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(120),ex7(:),G1H4(23),m3h2x4(:,23),heltab2x8(:,:,61))
  call Hloop_AZ_Q(ntryL,G1H8(123),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,39),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(39),n2h2(39))
call HGT_raise_alpha_OLR(G1H8(125),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(125),ex7(:),G1H4(24),m3h2x4(:,24),heltab2x8(:,:,63))
  call Hloop_AZ_Q(ntryL,G1H8(128),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,40),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(40),n2h2(40))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(33)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(1),ex7(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex7(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex7(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex7(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex7(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex7(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex7(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex7(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex7(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(28),ex7(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex7(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(38),ex7(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),64)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),64)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),64)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),64)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),64)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),64)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(1428)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(13),h0tab(:,13),[133,24,34,64],[nMT,nMT,nMB,0],4,3,wf8(:,4),wf4(:,3),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,4),G0H32(1),m3h8x32(:,1),heltab2x256(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),133,nMT,G1H32(1),n2h32(23))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1429)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(14),h0tab(:,14),[133,24,34,64],[nMT,nMT,nMB,0],4,3,wf8(:,4),wf4(:,10) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,4),G0H32(1),m3h8x32(:,2),heltab2x256(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),133,nMT,G1H32(2),n2h32(24))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1428)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(15),h0tab(:,15),[133,34,24,64],[nMT,nMB,nMB,0],4,3,wf8(:,4),wf4(:,6),wf4(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,4),G0H32(1),m3h8x32(:,3),heltab2x256(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),133,nMT,G1H32(4),n2h32(25))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1429)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(16),h0tab(:,16),[133,34,24,64],[nMT,nMB,nMB,0],4,3,wf8(:,4),wf4(:,6),wf4(: &
    ,10))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,4),G0H32(1),m3h8x32(:,4),heltab2x256(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),133,nMT,G1H32(5),n2h32(26))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(1436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(17),h0tab(:,17),[128,5,24,98],[nMB,nMT,nMT,0],4,3,wf4(:,5),wf4(:,3),wf8(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,13),heltab2x256(:,:,17))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(1),n2h128(13))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(18),h0tab(:,18),[128,5,24,98],[nMB,nMT,nMT,0],4,3,wf4(:,5),wf4(:,10),wf8(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,14),heltab2x256(:,:,18))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(2),n2h128(14))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(19),h0tab(:,19),[128,24,5,98],[nMB,nMB,nMT,0],4,3,wf4(:,3),wf4(:,5),wf8(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,15),heltab2x256(:,:,19))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(3),n2h128(15))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(20),h0tab(:,20),[128,24,5,98],[nMB,nMB,nMT,0],4,3,wf4(:,10),wf4(:,5),wf8(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,16),heltab2x256(:,:,20))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(4),n2h128(16))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(1450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(21),h0tab(:,21),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,17),heltab2x256(:,:,21))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(5),n2h128(17))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(897)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(22),h0tab(:,22),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,4),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,18),heltab2x256(:,:,22))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(6),n2h128(18))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(23),h0tab(:,23),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,1),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,19),heltab2x256(:,:,23))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(7),n2h128(19))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(24),h0tab(:,24),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,3),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,20),heltab2x256(:,:,24))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(8),n2h128(20))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(25),h0tab(:,25),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,1),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,21),heltab2x256(:,:,25))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(9),n2h128(21))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(899)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(26),h0tab(:,26),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,3),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,22),heltab2x256(:,:,26))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(10),n2h128(22))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(1450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(27),h0tab(:,27),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(:,4))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,23),heltab2x256(:,:,27))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(11),n2h128(23))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(897)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(28),h0tab(:,28),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(:,4))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,24),heltab2x256(:,:,28))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(12),n2h128(24))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(29),h0tab(:,29),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(:,1))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,25),heltab2x256(:,:,29))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(13),n2h128(25))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(30),h0tab(:,30),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,26),heltab2x256(:,:,30))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(14),n2h128(26))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(31),h0tab(:,31),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(:,1))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,27),heltab2x256(:,:,31))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(15),n2h128(27))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(899)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(32),h0tab(:,32),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,28),heltab2x256(:,:,32))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(16),n2h128(28))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(33),h0tab(:,33),[128,5,34,88],[nMB,nMT,nMB,0],4,3,wf4(:,5),wf4(:,6),wf8(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,29),heltab2x256(:,:,33))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(17),n2h128(29))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(34),h0tab(:,34),[128,5,34,88],[nMB,nMT,nMB,0],4,3,wf4(:,5),wf4(:,6),wf8(: &
    ,8))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,30),heltab2x256(:,:,34))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(18),n2h128(30))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(35),h0tab(:,35),[152,5,34,64],[nMB,nMT,nMB,0],4,3,wf8(:,10),wf4(:,5),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,10),G0H32(1),m3h8x32(:,5),heltab2x256(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),152,nMB,G1H32(6),n2h32(27))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1461)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(36),h0tab(:,36),[152,5,34,64],[nMB,nMT,nMB,0],4,3,wf8(:,12),wf4(:,5),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,12),G0H32(1),m3h8x32(:,6),heltab2x256(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),152,nMB,G1H32(7),n2h32(28))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(902)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(37),h0tab(:,37),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,8),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,31),heltab2x256(:,:,37))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(19),n2h128(31))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(904)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(38),h0tab(:,38),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,10),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,32),heltab2x256(:,:,38))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(20),n2h128(32))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(910)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(39),h0tab(:,39),[128,5,58,64],[nMB,nMT,nMB,0],4,2,wf4(:,5),wf16(:,21))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,33),heltab2x256(:,:,39))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(21),n2h128(33))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(912)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(40),h0tab(:,40),[128,5,58,64],[nMB,nMT,nMB,0],4,2,wf4(:,5),wf16(:,23))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,34),heltab2x256(:,:,40))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(22),n2h128(34))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(41),h0tab(:,41),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,37),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,35),heltab2x256(:,:,41))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(23),n2h128(35))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(924)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(42),h0tab(:,42),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,37),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,36),heltab2x256(:,:,42))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(24),n2h128(36))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(43),h0tab(:,43),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,48),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,37),heltab2x256(:,:,43))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(25),n2h128(37))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1480)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(44),h0tab(:,44),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,49),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,38),heltab2x256(:,:,44))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(26),n2h128(38))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1481)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(45),h0tab(:,45),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,48),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,39),heltab2x256(:,:,45))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(27),n2h128(39))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(926)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(46),h0tab(:,46),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,49),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,40),heltab2x256(:,:,46))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(28),n2h128(40))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(47),h0tab(:,47),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(:,37))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,41),heltab2x256(:,:,47))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(29),n2h128(41))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(924)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(48),h0tab(:,48),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(:,37))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,42),heltab2x256(:,:,48))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(30),n2h128(42))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(49),h0tab(:,49),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(:,48))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,43),heltab2x256(:,:,49))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(31),n2h128(43))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1480)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(50),h0tab(:,50),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(:,49))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,44),heltab2x256(:,:,50))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(32),n2h128(44))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1481)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(51),h0tab(:,51),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(:,48))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,45),heltab2x256(:,:,51))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(33),n2h128(45))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(926)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(52),h0tab(:,52),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(:,49))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,46),heltab2x256(:,:,52))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(34),n2h128(46))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(53),h0tab(:,53),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(:,50))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,47),heltab2x256(:,:,53))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(35),n2h128(47))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(946)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(54),h0tab(:,54),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(:,50))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,48),heltab2x256(:,:,54))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(36),n2h128(48))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1486)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(55),h0tab(:,55),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,50),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,49),heltab2x256(:,:,55))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(37),n2h128(49))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(946)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(56),h0tab(:,56),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,50),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,50),heltab2x256(:,:,56))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(38),n2h128(50))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(953)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(57),h0tab(:,57),[128,5,58,64],[nMB,nMT,nMB,0],4,2,wf4(:,5),wf16(:,51))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,51),heltab2x256(:,:,57))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(39),n2h128(51))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(963)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(58),h0tab(:,58),[128,5,58,64],[nMB,nMT,nMB,0],4,2,wf4(:,5),wf16(:,52))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,52),heltab2x256(:,:,58))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(40),n2h128(52))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(965)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(59),h0tab(:,59),[128,5,58,64],[nMB,nMT,nMB,0],4,2,wf4(:,5),wf16(:,53))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,53),heltab2x256(:,:,59))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(41),n2h128(53))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(991)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(60),h0tab(:,60),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,67),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,54),heltab2x256(:,:,60))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(42),n2h128(54))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1001)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(61),h0tab(:,61),[128,5,58,64],[nMB,nMT,nMB,0],4,2,wf4(:,5),wf16(:,68))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,55),heltab2x256(:,:,61))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(43),n2h128(55))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(62),h0tab(:,62),[137,20,34,64],[nMT,nMT,nMB,0],4,3,wf8(:,44),wf4(:,12) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,44),G0H32(1),m3h8x32(:,7),heltab2x256(:,:,62))
  call Hloop_A_Q(ntryL,G0H32(1),137,nMT,G1H32(8),n2h32(29))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(63),h0tab(:,63),[137,20,34,64],[nMT,nMT,nMB,0],4,3,wf8(:,44),wf4(:,15) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,44),G0H32(1),m3h8x32(:,8),heltab2x256(:,:,63))
  call Hloop_A_Q(ntryL,G0H32(1),137,nMT,G1H32(10),n2h32(30))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(64),h0tab(:,64),[137,34,20,64],[nMT,nMB,nMB,0],4,3,wf8(:,44),wf4(:,6) &
    ,wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,44),G0H32(1),m3h8x32(:,9),heltab2x256(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(1),137,nMT,G1H32(11),n2h32(31))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(65),h0tab(:,65),[137,34,20,64],[nMT,nMB,nMB,0],4,3,wf8(:,44),wf4(:,6) &
    ,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,44),G0H32(1),m3h8x32(:,10),heltab2x256(:,:,65))
  call Hloop_A_Q(ntryL,G0H32(1),137,nMT,G1H32(12),n2h32(32))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1508)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(66),h0tab(:,66),[128,9,20,98],[nMB,nMT,nMT,0],4,3,wf4(:,13),wf4(:,12) &
    ,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,56),heltab2x256(:,:,66))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(44),n2h128(56))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1509)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(67),h0tab(:,67),[128,9,20,98],[nMB,nMT,nMT,0],4,3,wf4(:,13),wf4(:,15) &
    ,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,57),heltab2x256(:,:,67))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(45),n2h128(57))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1508)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(68),h0tab(:,68),[128,20,9,98],[nMB,nMB,nMT,0],4,3,wf4(:,12),wf4(:,13) &
    ,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,58),heltab2x256(:,:,68))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(46),n2h128(58))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1509)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(69),h0tab(:,69),[128,20,9,98],[nMB,nMB,nMT,0],4,3,wf4(:,15),wf4(:,13) &
    ,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,59),heltab2x256(:,:,69))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(47),n2h128(59))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1522)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(70),h0tab(:,70),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,79),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,60),heltab2x256(:,:,70))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(48),n2h128(60))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1045)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(71),h0tab(:,71),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,79),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,61),heltab2x256(:,:,71))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(49),n2h128(61))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1523)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(72),h0tab(:,72),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,76),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,62),heltab2x256(:,:,72))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(50),n2h128(62))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1524)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(73),h0tab(:,73),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,78),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,63),heltab2x256(:,:,73))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(51),n2h128(63))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1525)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(74),h0tab(:,74),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,76),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,64),heltab2x256(:,:,74))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(52),n2h128(64))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1047)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(75),h0tab(:,75),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,78),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,65),heltab2x256(:,:,75))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(53),n2h128(65))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1522)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(76),h0tab(:,76),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(:,79))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,66),heltab2x256(:,:,76))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(54),n2h128(66))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1045)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(77),h0tab(:,77),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(:,79))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,67),heltab2x256(:,:,77))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(55),n2h128(67))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1523)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(78),h0tab(:,78),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(:,76))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,68),heltab2x256(:,:,78))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(56),n2h128(68))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(1524)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(79),h0tab(:,79),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(:,78))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,69),heltab2x256(:,:,79))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(57),n2h128(69))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1525)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(80),h0tab(:,80),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(:,76))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,70),heltab2x256(:,:,80))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(58),n2h128(70))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1047)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(81),h0tab(:,81),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(:,78))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,71),heltab2x256(:,:,81))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(59),n2h128(71))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1528)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(82),h0tab(:,82),[128,9,34,84],[nMB,nMT,nMB,0],4,3,wf4(:,13),wf4(:,6),wf8(: &
    ,46))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,72),heltab2x256(:,:,82))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(60),n2h128(72))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1529)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(83),h0tab(:,83),[128,9,34,84],[nMB,nMT,nMB,0],4,3,wf4(:,13),wf4(:,6),wf8(: &
    ,48))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,73),heltab2x256(:,:,83))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(61),n2h128(73))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1532)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(84),h0tab(:,84),[148,9,34,64],[nMB,nMT,nMB,0],4,3,wf8(:,50),wf4(:,13) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,50),G0H32(1),m3h8x32(:,11),heltab2x256(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(1),148,nMB,G1H32(13),n2h32(33))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1533)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(85),h0tab(:,85),[148,9,34,64],[nMB,nMT,nMB,0],4,3,wf8(:,52),wf4(:,13) &
    ,wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),wf8(:,52),G0H32(1),m3h8x32(:,12),heltab2x256(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(1),148,nMB,G1H32(14),n2h32(34))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1049)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(86),h0tab(:,86),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,82),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,74),heltab2x256(:,:,86))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(62),n2h128(74))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1051)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(87),h0tab(:,87),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,84),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,75),heltab2x256(:,:,87))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(63),n2h128(75))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(88),h0tab(:,88),[128,9,54,64],[nMB,nMT,nMB,0],4,2,wf4(:,13),wf16(:,93))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,76),heltab2x256(:,:,88))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(64),n2h128(76))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1059)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(89),h0tab(:,89),[128,9,54,64],[nMB,nMT,nMB,0],4,2,wf4(:,13),wf16(:,95))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,77),heltab2x256(:,:,89))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(65),n2h128(77))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(90),h0tab(:,90),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,108),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,78),heltab2x256(:,:,90))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(66),n2h128(78))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1071)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(91),h0tab(:,91),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,108),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,79),heltab2x256(:,:,91))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(67),n2h128(79))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(92),h0tab(:,92),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,115),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,80),heltab2x256(:,:,92))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(68),n2h128(80))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(93),h0tab(:,93),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,116),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,81),heltab2x256(:,:,93))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(69),n2h128(81))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(94),h0tab(:,94),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,115),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,82),heltab2x256(:,:,94))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(70),n2h128(82))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1073)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(95),h0tab(:,95),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,116),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,83),heltab2x256(:,:,95))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(71),n2h128(83))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1550)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(96),h0tab(:,96),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(:,108))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,84),heltab2x256(:,:,96))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(72),n2h128(84))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1071)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(97),h0tab(:,97),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(:,108))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,85),heltab2x256(:,:,97))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(73),n2h128(85))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1551)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(98),h0tab(:,98),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(:,115))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,86),heltab2x256(:,:,98))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(74),n2h128(86))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1552)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(99),h0tab(:,99),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(:,116))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,87),heltab2x256(:,:,99))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(75),n2h128(87))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(100),h0tab(:,100),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(: &
    ,115))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,88),heltab2x256(:,:,100))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(76),n2h128(88))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1073)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(101),h0tab(:,101),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(: &
    ,116))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,89),heltab2x256(:,:,101))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(77),n2h128(89))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1558)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(102),h0tab(:,102),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(: &
    ,117))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,90),heltab2x256(:,:,102))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(78),n2h128(90))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1092)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(103),h0tab(:,103),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(: &
    ,117))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,91),heltab2x256(:,:,103))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(79),n2h128(91))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1558)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(104),h0tab(:,104),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,117),wf4(: &
    ,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,92),heltab2x256(:,:,104))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(80),n2h128(92))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1092)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(105),h0tab(:,105),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,117),wf4(: &
    ,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,93),heltab2x256(:,:,105))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(81),n2h128(93))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1098)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(106),h0tab(:,106),[128,9,54,64],[nMB,nMT,nMB,0],4,2,wf4(:,13),wf16(: &
    ,118))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,94),heltab2x256(:,:,106))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(82),n2h128(94))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(107),h0tab(:,107),[128,9,54,64],[nMB,nMT,nMB,0],4,2,wf4(:,13),wf16(: &
    ,119))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,95),heltab2x256(:,:,107))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(83),n2h128(95))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(108),h0tab(:,108),[128,9,54,64],[nMB,nMT,nMB,0],4,2,wf4(:,13),wf16(: &
    ,120))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,96),heltab2x256(:,:,108))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(84),n2h128(96))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(109),h0tab(:,109),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,131),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,97),heltab2x256(:,:,109))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(85),n2h128(97))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(110),h0tab(:,110),[128,9,54,64],[nMB,nMT,nMB,0],4,2,wf4(:,13),wf16(: &
    ,132))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,98),heltab2x256(:,:,110))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(86),n2h128(98))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1572)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(111),h0tab(:,111),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,145),wf4(: &
    ,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,99),heltab2x256(:,:,111))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(87),n2h128(99))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1573)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(112),h0tab(:,112),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,146),wf4(: &
    ,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,100),heltab2x256(:,:,112))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(88),n2h128(100))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1574)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(113),h0tab(:,113),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,145),wf4(: &
    ,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,101),heltab2x256(:,:,113))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(89),n2h128(101))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(114),h0tab(:,114),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,146),wf4(: &
    ,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,102),heltab2x256(:,:,114))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(90),n2h128(102))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1572)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(115),h0tab(:,115),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(: &
    ,145))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,103),heltab2x256(:,:,115))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(91),n2h128(103))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1573)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(116),h0tab(:,116),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(: &
    ,146))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,104),heltab2x256(:,:,116))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(92),n2h128(104))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1574)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(117),h0tab(:,117),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(: &
    ,145))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,105),heltab2x256(:,:,117))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(93),n2h128(105))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(118),h0tab(:,118),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(: &
    ,146))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,106),heltab2x256(:,:,118))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(94),n2h128(106))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(119),h0tab(:,119),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,147),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,107),heltab2x256(:,:,119))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(95),n2h128(107))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1582)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(120),h0tab(:,120),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,12),wf16(: &
    ,148))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,108),heltab2x256(:,:,120))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(96),n2h128(108))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(121),h0tab(:,121),[128,20,43,64],[nMB,nMB,nMB,0],4,2,wf4(:,15),wf16(: &
    ,148))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,109),heltab2x256(:,:,121))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(97),n2h128(109))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1582)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(122),h0tab(:,122),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,148),wf4(: &
    ,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,110),heltab2x256(:,:,122))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(98),n2h128(110))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(123),h0tab(:,123),[128,43,20,64],[nMB,nMB,nMB,0],4,2,wf16(:,148),wf4(: &
    ,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,111),heltab2x256(:,:,123))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(99),n2h128(111))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(124),h0tab(:,124),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,149),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,112),heltab2x256(:,:,124))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(100),n2h128(112))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(125),h0tab(:,125),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,150),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,113),heltab2x256(:,:,125))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(101),n2h128(113))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1591)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(126),h0tab(:,126),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(: &
    ,162))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,114),heltab2x256(:,:,126))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(102),n2h128(114))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(127),h0tab(:,127),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(: &
    ,162))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,115),heltab2x256(:,:,127))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(103),n2h128(115))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1593)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(128),h0tab(:,128),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(: &
    ,163))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,116),heltab2x256(:,:,128))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(104),n2h128(116))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1285)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(129),h0tab(:,129),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(: &
    ,163))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,117),heltab2x256(:,:,129))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(105),n2h128(117))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1591)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(130),h0tab(:,130),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,162),wf4(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,118),heltab2x256(:,:,130))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(106),n2h128(118))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1592)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(131),h0tab(:,131),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,162),wf4(: &
    ,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,119),heltab2x256(:,:,131))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(107),n2h128(119))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1593)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(132),h0tab(:,132),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,163),wf4(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,120),heltab2x256(:,:,132))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(108),n2h128(120))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1285)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(133),h0tab(:,133),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,163),wf4(: &
    ,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,121),heltab2x256(:,:,133))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(109),n2h128(121))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1300)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(134),h0tab(:,134),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,164),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,122),heltab2x256(:,:,134))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(110),n2h128(122))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(135),h0tab(:,135),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,3),wf16(: &
    ,165))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,123),heltab2x256(:,:,135))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(111),n2h128(123))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(136),h0tab(:,136),[128,24,39,64],[nMB,nMB,nMB,0],4,2,wf4(:,10),wf16(: &
    ,165))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,124),heltab2x256(:,:,136))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(112),n2h128(124))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(137),h0tab(:,137),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,165),wf4(: &
    ,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,125),heltab2x256(:,:,137))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(113),n2h128(125))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1308)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(138),h0tab(:,138),[128,39,24,64],[nMB,nMB,nMB,0],4,2,wf16(:,165),wf4(: &
    ,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,126),heltab2x256(:,:,138))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(114),n2h128(126))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1310)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(139),h0tab(:,139),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,166),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,127),heltab2x256(:,:,139))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(115),n2h128(127))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1312)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(140),h0tab(:,140),[128,29,34,64],[nMB,nMT,nMB,0],4,2,wf16(:,167),wf4(: &
    ,6))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,128),heltab2x256(:,:,140))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(116),n2h128(128))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(1),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(2),[G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(6),G1H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(10),[G1H32(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(14),[G1H32(13),G1H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(12),[G1H32(57)])
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,3),G1H8(5),m3h4x8(:,41),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(5),157,nMT,G2H8(1),n2h8(65))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,10),G1H8(6),ngZu,m3h4x8(:,42),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(6),157,nMT,G2H8(3),n2h8(66))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,5),G1H8(21),m3h4x8(:,43),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(21),157,nMT,G2H8(4),n2h8(67))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,6),G1H8(22),m3h4x8(:,44),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(22),167,nMB,G2H8(21),n2h8(68))
  call Hloop_AW_Q(ntryL,G1H32(5),wf4(:,6),G1H8(37),m3h4x8(:,45),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(37),167,nMB,G2H8(23),n2h8(69))
  call Hloop_AV_Q(ntryL,G1H32(8),wf4(:,12),G1H8(38),m3h4x8(:,46),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(38),157,nMT,G2H8(24),n2h8(70))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,15),G1H8(53),ngZu,m3h4x8(:,47),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(53),157,nMT,G2H8(5),n2h8(71))
  call Hloop_AW_Q(ntryL,G1H32(14),wf4(:,13),G1H8(54),m3h4x8(:,48),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(54),157,nMT,G2H8(7),n2h8(72))
  call Hloop_AW_Q(ntryL,G1H32(11),wf4(:,6),G1H8(69),m3h4x8(:,49),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(69),171,nMB,G2H8(8),n2h8(73))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,6),G1H8(70),m3h4x8(:,50),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(70),171,nMB,G2H8(9),n2h8(74))
  call Hloop_AW_Q(ntryL,G1H128(1),wf4(:,5),G1H32(16),m3h4x32(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G1H32(16),133,nMT,G2H32(3),n2h32(35))
  call Hloop_AW_Q(ntryL,G1H128(2),wf4(:,5),G1H32(17),m3h4x32(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G1H32(17),133,nMT,G2H32(9),n2h32(36))
  call Hloop_AV_Q(ntryL,G1H128(3),wf4(:,3),G1H32(18),m3h4x32(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G1H32(18),152,nMB,G2H32(1),n2h32(37))
  call Hloop_AZ_Q(ntryL,G1H128(4),wf4(:,10),G1H32(19),ngZd,m3h4x32(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G1H32(19),152,nMB,G2H32(2),n2h32(38))
  call Hloop_AS_Q(ntryL,G1H128(5),wf16(:,4),G1H8(85),ngH,m3h16x8(:,1),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(85),167,nMB,G2H8(11),n2h8(75))
  call Hloop_AS_Q(ntryL,G1H128(6),wf16(:,4),G1H8(86),ngH,m3h16x8(:,2),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(86),167,nMB,G2H8(12),n2h8(76))
  call Hloop_AV_Q(ntryL,G1H128(7),wf16(:,1),G1H8(101),m3h16x8(:,3),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(101),167,nMB,G2H8(13),n2h8(77))
  call Hloop_AZ_Q(ntryL,G1H128(8),wf16(:,3),G1H8(102),ngZd,m3h16x8(:,4),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(102),167,nMB,G2H8(15),n2h8(78))
  call Hloop_AV_Q(ntryL,G1H128(9),wf16(:,1),G1H8(117),m3h16x8(:,5),heltab2x128(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(117),167,nMB,G2H8(16),n2h8(79))
  call Hloop_AZ_Q(ntryL,G1H128(10),wf16(:,3),G1H8(118),ngZd,m3h16x8(:,6),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(118),167,nMB,G2H8(17),n2h8(80))
  call Hloop_AV_Q(ntryL,G1H128(11),wf4(:,3),G1H32(20),m3h4x32(:,17),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G1H32(20),152,nMB,G2H32(4),n2h32(39))
  call Hloop_AZ_Q(ntryL,G1H128(12),wf4(:,10),G1H32(22),ngZd,m3h4x32(:,18),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G1H32(22),152,nMB,G2H32(5),n2h32(40))
  call Hloop_AV_Q(ntryL,G1H128(13),wf4(:,3),G1H32(23),m3h4x32(:,19),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G1H32(23),152,nMB,G2H32(6),n2h32(41))
  call Hloop_AV_Q(ntryL,G1H128(14),wf4(:,3),G1H32(24),m3h4x32(:,20),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G1H32(24),152,nMB,G2H32(7),n2h32(42))
  call Hloop_AZ_Q(ntryL,G1H128(15),wf4(:,10),G1H32(25),ngZd,m3h4x32(:,21),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G1H32(25),152,nMB,G2H32(8),n2h32(43))
  call Hloop_AZ_Q(ntryL,G1H128(16),wf4(:,10),G1H32(26),ngZd,m3h4x32(:,22),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G1H32(26),152,nMB,G2H32(10),n2h32(44))
  call Hloop_AW_Q(ntryL,G1H128(17),wf4(:,5),G1H32(28),m3h4x32(:,23),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G1H32(28),133,nMT,G2H32(11),n2h32(45))
  call Hloop_AW_Q(ntryL,G1H128(18),wf4(:,5),G1H32(29),m3h4x32(:,24),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G1H32(29),133,nMT,G2H32(12),n2h32(46))
  call Hloop_AW_Q(ntryL,G1H128(19),wf16(:,8),G1H8(1),m3h16x8(:,7),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),157,nMT,G2H8(19),n2h8(81))
  call Hloop_AW_Q(ntryL,G1H128(20),wf16(:,10),G1H8(2),m3h16x8(:,8),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(2),157,nMT,G2H8(20),n2h8(82))
  call Hloop_AW_Q(ntryL,G1H128(21),wf4(:,5),G1H32(30),m3h4x32(:,25),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G1H32(30),133,nMT,G2H32(13),n2h32(47))
  call Hloop_AW_Q(ntryL,G1H128(22),wf4(:,5),G1H32(31),m3h4x32(:,26),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G1H32(31),133,nMT,G2H32(14),n2h32(48))
  call Hloop_AS_Q(ntryL,G1H128(23),wf16(:,37),G1H8(7),ngH,m3h16x8(:,9),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(7),167,nMB,G2H8(25),n2h8(83))
  call Hloop_AS_Q(ntryL,G1H128(24),wf16(:,37),G1H8(12),ngH,m3h16x8(:,10),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(12),167,nMB,G2H8(27),n2h8(84))
  call Hloop_AV_Q(ntryL,G1H128(25),wf16(:,48),G1H8(8),m3h16x8(:,11),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(8),167,nMB,G2H8(28),n2h8(85))
  call Hloop_AZ_Q(ntryL,G1H128(26),wf16(:,49),G1H8(11),ngZd,m3h16x8(:,12),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(11),167,nMB,G2H8(29),n2h8(86))
  call Hloop_AV_Q(ntryL,G1H128(27),wf16(:,48),G1H8(13),m3h16x8(:,13),heltab2x128(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(13),167,nMB,G2H8(31),n2h8(87))
  call Hloop_AZ_Q(ntryL,G1H128(28),wf16(:,49),G1H8(16),ngZd,m3h16x8(:,14),heltab2x128(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(16),167,nMB,G2H8(32),n2h8(88))
  call Hloop_AV_Q(ntryL,G1H128(29),wf4(:,3),G1H32(32),m3h4x32(:,27),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G1H32(32),152,nMB,G2H32(15),n2h32(49))
  call Hloop_AZ_Q(ntryL,G1H128(30),wf4(:,10),G1H32(34),ngZd,m3h4x32(:,28),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G1H32(34),152,nMB,G2H32(16),n2h32(50))
  call Hloop_AV_Q(ntryL,G1H128(31),wf4(:,3),G1H32(35),m3h4x32(:,29),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G1H32(35),152,nMB,G2H32(17),n2h32(51))
  call Hloop_AV_Q(ntryL,G1H128(32),wf4(:,3),G1H32(36),m3h4x32(:,30),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G1H32(36),152,nMB,G2H32(18),n2h32(52))
  call Hloop_AZ_Q(ntryL,G1H128(33),wf4(:,10),G1H32(37),ngZd,m3h4x32(:,31),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G1H32(37),152,nMB,G2H32(19),n2h32(53))
  call Hloop_AZ_Q(ntryL,G1H128(34),wf4(:,10),G1H32(38),ngZd,m3h4x32(:,32),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G1H32(38),152,nMB,G2H32(20),n2h32(54))
  call Hloop_AV_Q(ntryL,G1H128(35),wf4(:,3),G1H32(40),m3h4x32(:,33),heltab2x128(:,:,47))
  call Hloop_A_Q(ntryL,G1H32(40),152,nMB,G2H32(21),n2h32(55))
  call Hloop_AZ_Q(ntryL,G1H128(36),wf4(:,10),G1H32(41),ngZd,m3h4x32(:,34),heltab2x128(:,:,48))
  call Hloop_A_Q(ntryL,G1H32(41),152,nMB,G2H32(22),n2h32(56))
  call Hloop_AZ_Q(ntryL,G1H128(37),wf16(:,50),G1H8(17),ngZd,m3h16x8(:,15),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(17),167,nMB,G2H8(33),n2h8(89))
  call Hloop_AZ_Q(ntryL,G1H128(38),wf16(:,50),G1H8(18),ngZd,m3h16x8(:,16),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(18),167,nMB,G2H8(35),n2h8(90))
  call Hloop_AW_Q(ntryL,G1H128(39),wf4(:,5),G1H32(42),m3h4x32(:,35),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G1H32(42),133,nMT,G2H32(23),n2h32(57))
  call Hloop_AW_Q(ntryL,G1H128(40),wf4(:,5),G1H32(43),m3h4x32(:,36),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G1H32(43),133,nMT,G2H32(24),n2h32(58))
  call Hloop_AW_Q(ntryL,G1H128(41),wf4(:,5),G1H32(44),m3h4x32(:,37),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G1H32(44),133,nMT,G2H32(25),n2h32(59))
  call Hloop_AW_Q(ntryL,G1H128(42),wf16(:,67),G1H8(23),m3h16x8(:,17),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(23),157,nMT,G2H8(36),n2h8(91))
  call Hloop_AW_Q(ntryL,G1H128(43),wf4(:,5),G1H32(46),m3h4x32(:,38),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G1H32(46),133,nMT,G2H32(26),n2h32(60))
  call Hloop_AW_Q(ntryL,G1H128(44),wf4(:,13),G1H32(47),m3h4x32(:,39),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G1H32(47),137,nMT,G2H32(27),n2h32(61))
  call Hloop_AW_Q(ntryL,G1H128(45),wf4(:,13),G1H32(48),m3h4x32(:,40),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G1H32(48),137,nMT,G2H32(28),n2h32(62))
  call Hloop_AV_Q(ntryL,G1H128(46),wf4(:,12),G1H32(49),m3h4x32(:,41),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G1H32(49),148,nMB,G2H32(29),n2h32(63))
  call Hloop_AZ_Q(ntryL,G1H128(47),wf4(:,15),G1H32(50),ngZd,m3h4x32(:,42),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G1H32(50),148,nMB,G2H32(30),n2h32(64))
  call Hloop_AS_Q(ntryL,G1H128(48),wf16(:,79),G1H8(28),ngH,m3h16x8(:,18),heltab2x128(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(28),171,nMB,G2H8(37),n2h8(92))
  call Hloop_AS_Q(ntryL,G1H128(49),wf16(:,79),G1H8(24),ngH,m3h16x8(:,19),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(24),171,nMB,G2H8(39),n2h8(93))
  call Hloop_AV_Q(ntryL,G1H128(50),wf16(:,76),G1H8(27),m3h16x8(:,20),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(27),171,nMB,G2H8(40),n2h8(94))
  call Hloop_AZ_Q(ntryL,G1H128(51),wf16(:,78),G1H8(29),ngZd,m3h16x8(:,21),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(29),171,nMB,G2H8(41),n2h8(95))
  call Hloop_AV_Q(ntryL,G1H128(52),wf16(:,76),G1H8(32),m3h16x8(:,22),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(32),171,nMB,G2H8(42),n2h8(96))
  call Hloop_AZ_Q(ntryL,G1H128(53),wf16(:,78),G1H8(33),ngZd,m3h16x8(:,23),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(33),171,nMB,G2H8(43),n2h8(97))
  call Hloop_AV_Q(ntryL,G1H128(54),wf4(:,12),G1H32(52),m3h4x32(:,43),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G1H32(52),148,nMB,G2H32(31),n2h32(65))
  call Hloop_AZ_Q(ntryL,G1H128(55),wf4(:,15),G1H32(53),ngZd,m3h4x32(:,44),heltab2x128(:,:,67))
  call Hloop_A_Q(ntryL,G1H32(53),148,nMB,G2H32(32),n2h32(66))
  call Hloop_AV_Q(ntryL,G1H128(56),wf4(:,12),G1H32(54),m3h4x32(:,45),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G1H32(54),148,nMB,G2H32(33),n2h32(67))
  call Hloop_AV_Q(ntryL,G1H128(57),wf4(:,12),G1H32(55),m3h4x32(:,46),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G1H32(55),148,nMB,G2H32(34),n2h32(68))
  call Hloop_AZ_Q(ntryL,G1H128(58),wf4(:,15),G1H32(56),ngZd,m3h4x32(:,47),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G1H32(56),148,nMB,G2H32(35),n2h32(69))
  call Hloop_AZ_Q(ntryL,G1H128(59),wf4(:,15),G1H32(58),ngZd,m3h4x32(:,48),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G1H32(58),148,nMB,G2H32(36),n2h32(70))
  call Hloop_AW_Q(ntryL,G1H128(60),wf4(:,13),G1H32(59),m3h4x32(:,49),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G1H32(59),137,nMT,G2H32(37),n2h32(71))
  call Hloop_AW_Q(ntryL,G1H128(61),wf4(:,13),G1H32(60),m3h4x32(:,50),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G1H32(60),137,nMT,G2H32(38),n2h32(72))
  call Hloop_AW_Q(ntryL,G1H128(62),wf16(:,82),G1H8(34),m3h16x8(:,24),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(34),157,nMT,G2H8(44),n2h8(98))
  call Hloop_AW_Q(ntryL,G1H128(63),wf16(:,84),G1H8(39),m3h16x8(:,25),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(39),157,nMT,G2H8(45),n2h8(99))
  call Hloop_AW_Q(ntryL,G1H128(64),wf4(:,13),G1H32(3),m3h4x32(:,51),heltab2x128(:,:,76))
  call Hloop_A_Q(ntryL,G1H32(3),137,nMT,G2H32(39),n2h32(73))
  call Hloop_AW_Q(ntryL,G1H128(65),wf4(:,13),G1H32(9),m3h4x32(:,52),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G1H32(9),137,nMT,G2H32(40),n2h32(74))
  call Hloop_AS_Q(ntryL,G1H128(66),wf16(:,108),G1H8(44),ngH,m3h16x8(:,26),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(44),171,nMB,G2H8(46),n2h8(100))
  call Hloop_AS_Q(ntryL,G1H128(67),wf16(:,108),G1H8(40),ngH,m3h16x8(:,27),heltab2x128(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(40),171,nMB,G2H8(47),n2h8(101))
  call Hloop_AV_Q(ntryL,G1H128(68),wf16(:,115),G1H8(43),m3h16x8(:,28),heltab2x128(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(43),171,nMB,G2H8(48),n2h8(102))
  call Hloop_AZ_Q(ntryL,G1H128(69),wf16(:,116),G1H8(45),ngZd,m3h16x8(:,29),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(45),171,nMB,G2H8(49),n2h8(103))
  call Hloop_AV_Q(ntryL,G1H128(70),wf16(:,115),G1H8(48),m3h16x8(:,30),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(48),171,nMB,G2H8(50),n2h8(104))
  call Hloop_AZ_Q(ntryL,G1H128(71),wf16(:,116),G1H8(49),ngZd,m3h16x8(:,31),heltab2x128(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(49),171,nMB,G2H8(51),n2h8(105))
  call Hloop_AV_Q(ntryL,G1H128(72),wf4(:,12),G1H32(6),m3h4x32(:,53),heltab2x128(:,:,84))
  call Hloop_A_Q(ntryL,G1H32(6),148,nMB,G2H32(41),n2h32(75))
  call Hloop_AZ_Q(ntryL,G1H128(73),wf4(:,15),G1H32(15),ngZd,m3h4x32(:,54),heltab2x128(:,:,85))
  call Hloop_A_Q(ntryL,G1H32(15),148,nMB,G2H32(42),n2h32(76))
  call Hloop_AV_Q(ntryL,G1H128(74),wf4(:,12),G1H32(21),m3h4x32(:,55),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G1H32(21),148,nMB,G2H32(43),n2h32(77))
  call Hloop_AV_Q(ntryL,G1H128(75),wf4(:,12),G1H32(27),m3h4x32(:,56),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G1H32(27),148,nMB,G2H32(44),n2h32(78))
  call Hloop_AZ_Q(ntryL,G1H128(76),wf4(:,15),G1H32(33),ngZd,m3h4x32(:,57),heltab2x128(:,:,88))
  call Hloop_A_Q(ntryL,G1H32(33),148,nMB,G2H32(45),n2h32(79))
  call Hloop_AZ_Q(ntryL,G1H128(77),wf4(:,15),G1H32(39),ngZd,m3h4x32(:,58),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G1H32(39),148,nMB,G2H32(46),n2h32(80))
  call Hloop_AV_Q(ntryL,G1H128(78),wf4(:,12),G1H32(13),m3h4x32(:,59),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G1H32(13),148,nMB,G2H32(47),n2h32(81))
  call Hloop_AZ_Q(ntryL,G1H128(79),wf4(:,15),G1H32(45),ngZd,m3h4x32(:,60),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G1H32(45),148,nMB,G2H32(48),n2h32(82))
  call Hloop_AZ_Q(ntryL,G1H128(80),wf16(:,117),G1H8(50),ngZd,m3h16x8(:,32),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(50),171,nMB,G2H8(52),n2h8(106))
  call Hloop_AZ_Q(ntryL,G1H128(81),wf16(:,117),G1H8(55),ngZd,m3h16x8(:,33),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(55),171,nMB,G2H8(53),n2h8(107))
  call Hloop_AW_Q(ntryL,G1H128(82),wf4(:,13),G1H32(51),m3h4x32(:,61),heltab2x128(:,:,94))
  call Hloop_A_Q(ntryL,G1H32(51),137,nMT,G2H32(49),n2h32(83))
  call Hloop_AW_Q(ntryL,G1H128(83),wf4(:,13),G1H32(57),m3h4x32(:,62),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G1H32(57),137,nMT,G2H32(50),n2h32(84))
  call Hloop_AW_Q(ntryL,G1H128(84),wf4(:,13),G1H32(1),m3h4x32(:,63),heltab2x128(:,:,96))
  call Hloop_A_Q(ntryL,G1H32(1),137,nMT,G2H32(51),n2h32(85))
  call Hloop_AW_Q(ntryL,G1H128(85),wf16(:,131),G1H8(60),m3h16x8(:,34),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(60),157,nMT,G2H8(54),n2h8(108))
  call Hloop_AW_Q(ntryL,G1H128(86),wf4(:,13),G1H32(2),m3h4x32(:,64),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G1H32(2),137,nMT,G2H32(52),n2h32(86))
  call Hloop_AV_Q(ntryL,G1H128(87),wf16(:,145),G1H8(56),m3h16x8(:,35),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(56),171,nMB,G2H8(55),n2h8(109))
  call Hloop_AZ_Q(ntryL,G1H128(88),wf16(:,146),G1H8(59),ngZd,m3h16x8(:,36),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(59),171,nMB,G2H8(56),n2h8(110))
  call Hloop_AV_Q(ntryL,G1H128(89),wf16(:,145),G1H8(61),m3h16x8(:,37),heltab2x128(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(61),171,nMB,G2H8(57),n2h8(111))
  call Hloop_AZ_Q(ntryL,G1H128(90),wf16(:,146),G1H8(64),ngZd,m3h16x8(:,38),heltab2x128(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(64),171,nMB,G2H8(58),n2h8(112))
  call Hloop_AV_Q(ntryL,G1H128(91),wf4(:,12),G1H32(7),m3h4x32(:,65),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G1H32(7),148,nMB,G2H32(53),n2h32(87))
  call Hloop_AV_Q(ntryL,G1H128(92),wf4(:,12),G1H32(4),m3h4x32(:,66),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G1H32(4),148,nMB,G2H32(54),n2h32(88))
  call Hloop_AZ_Q(ntryL,G1H128(93),wf4(:,15),G1H32(5),ngZd,m3h4x32(:,67),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G1H32(5),148,nMB,G2H32(55),n2h32(89))
  call Hloop_AZ_Q(ntryL,G1H128(94),wf4(:,15),G1H32(8),ngZd,m3h4x32(:,68),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G1H32(8),148,nMB,G2H32(56),n2h32(90))
  call Hloop_AW_Q(ntryL,G1H128(95),wf16(:,147),G1H8(65),m3h16x8(:,39),heltab2x128(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(65),157,nMT,G2H8(59),n2h8(113))
  call Hloop_AV_Q(ntryL,G1H128(96),wf4(:,12),G1H32(10),m3h4x32(:,69),heltab2x128(:,:,108))
  call Hloop_A_Q(ntryL,G1H32(10),148,nMB,G2H32(57),n2h32(91))
  call Hloop_AZ_Q(ntryL,G1H128(97),wf4(:,15),G1H32(14),ngZd,m3h4x32(:,70),heltab2x128(:,:,109))
  call Hloop_A_Q(ntryL,G1H32(14),148,nMB,G2H32(58),n2h32(92))
  call Hloop_AZ_Q(ntryL,G1H128(98),wf16(:,148),G1H8(66),ngZd,m3h16x8(:,40),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(66),171,nMB,G2H8(60),n2h8(114))
  call Hloop_AZ_Q(ntryL,G1H128(99),wf16(:,148),G1H8(71),ngZd,m3h16x8(:,41),heltab2x128(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(71),171,nMB,G2H8(61),n2h8(115))
  call Hloop_AW_Q(ntryL,G1H128(100),wf16(:,149),G1H8(76),m3h16x8(:,42),heltab2x128(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(76),157,nMT,G2H8(62),n2h8(116))
  call Hloop_AW_Q(ntryL,G1H128(101),wf16(:,150),G1H8(72),m3h16x8(:,43),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(72),157,nMT,G2H8(63),n2h8(117))
  call Hloop_AV_Q(ntryL,G1H128(102),wf4(:,3),G1H32(11),m3h4x32(:,71),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G1H32(11),152,nMB,G2H32(59),n2h32(93))
  call Hloop_AZ_Q(ntryL,G1H128(103),wf4(:,10),G1H32(12),ngZd,m3h4x32(:,72),heltab2x128(:,:,115))
  call Hloop_A_Q(ntryL,G1H32(12),152,nMB,G2H32(60),n2h32(94))
  call Hloop_AV_Q(ntryL,G1H128(104),wf4(:,3),G1H32(16),m3h4x32(:,73),heltab2x128(:,:,116))
  call Hloop_A_Q(ntryL,G1H32(16),152,nMB,G2H32(61),n2h32(95))
  call Hloop_AZ_Q(ntryL,G1H128(105),wf4(:,10),G1H32(17),ngZd,m3h4x32(:,74),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G1H32(17),152,nMB,G2H32(62),n2h32(96))
  call Hloop_AV_Q(ntryL,G1H128(106),wf16(:,162),G1H8(75),m3h16x8(:,44),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(75),167,nMB,G2H8(64),n2h8(118))
  call Hloop_AV_Q(ntryL,G1H128(107),wf16(:,162),G1H8(77),m3h16x8(:,45),heltab2x128(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(77),167,nMB,G2H8(65),n2h8(119))
  call Hloop_AZ_Q(ntryL,G1H128(108),wf16(:,163),G1H8(80),ngZd,m3h16x8(:,46),heltab2x128(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(80),167,nMB,G2H8(66),n2h8(120))
  call Hloop_AZ_Q(ntryL,G1H128(109),wf16(:,163),G1H8(81),ngZd,m3h16x8(:,47),heltab2x128(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(81),167,nMB,G2H8(67),n2h8(121))
  call Hloop_AW_Q(ntryL,G1H128(110),wf16(:,164),G1H8(82),m3h16x8(:,48),heltab2x128(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(82),157,nMT,G2H8(68),n2h8(122))
  call Hloop_AV_Q(ntryL,G1H128(111),wf4(:,3),G1H32(18),m3h4x32(:,75),heltab2x128(:,:,123))
  call Hloop_A_Q(ntryL,G1H32(18),152,nMB,G2H32(63),n2h32(97))
  call Hloop_AZ_Q(ntryL,G1H128(112),wf4(:,10),G1H32(19),ngZd,m3h4x32(:,76),heltab2x128(:,:,124))
  call Hloop_A_Q(ntryL,G1H32(19),152,nMB,G2H32(64),n2h32(98))
  call Hloop_AZ_Q(ntryL,G1H128(113),wf16(:,165),G1H8(87),ngZd,m3h16x8(:,49),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(87),167,nMB,G2H8(69),n2h8(123))
  call Hloop_AZ_Q(ntryL,G1H128(114),wf16(:,165),G1H8(92),ngZd,m3h16x8(:,50),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(92),167,nMB,G2H8(70),n2h8(124))
  call Hloop_AW_Q(ntryL,G1H128(115),wf16(:,166),G1H8(88),m3h16x8(:,51),heltab2x128(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(88),157,nMT,G2H8(71),n2h8(125))
  call Hloop_AW_Q(ntryL,G1H128(116),wf16(:,167),G1H8(91),m3h16x8(:,52),heltab2x128(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(91),157,nMT,G2H8(72),n2h8(126))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(72),[G2H8(71),G2H8(68),G2H8(63),G2H8(62),G2H8(59) &
    ,G2H8(54),G2H8(45),G2H8(44),G2H8(36),G2H8(20),G2H8(19),G2H8(30),G2H8(26),G2H8(22),G2H8(10),G2H8(6),G2H8(2),G1H8(84),G1H8(68) &
    ,G1H8(20),G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G2H8(66),G2H8(64),G2H8(33),G2H8(29),G2H8(28) &
    ,G2H8(25),G2H8(15),G2H8(13),G2H8(11),G2H8(14),G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(70),[G2H8(67),G2H8(65),G2H8(35),G2H8(32),G2H8(31) &
    ,G2H8(27),G2H8(17),G2H8(16),G2H8(12),G2H8(18),G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(60),[G2H8(56),G2H8(55),G2H8(52),G2H8(49),G2H8(48) &
    ,G2H8(46),G2H8(41),G2H8(40),G2H8(37),G2H8(34),G1H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(61),[G2H8(58),G2H8(57),G2H8(53),G2H8(51),G2H8(50) &
    ,G2H8(47),G2H8(43),G2H8(42),G2H8(39),G2H8(38),G1H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G2H8(1),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(74),G1H8(26),G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(95),[G1H8(79),G1H8(31),G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(24),G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(2),[G2H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(5),[G2H32(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(8),[G2H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(10),[G2H32(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(16),[G2H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(19),[G2H32(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(20),[G2H32(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(22),[G2H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(30),[G2H32(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(32),[G2H32(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(35),[G2H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(36),[G2H32(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(42),[G2H32(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(45),[G2H32(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(46),[G2H32(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(48),[G2H32(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(55),[G2H32(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(56),[G2H32(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(58),[G2H32(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(60),[G2H32(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(62),[G2H32(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(64),[G2H32(63)])
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,3),G1H4(25),m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(25),221,nMT,G2H4(1),n2h4(1))
  call Hotf_4pt_reduction(G2H8(72),RedSet_4(12),mass4set(:,1),  & 
G1H8(93),G1H8(96),G1H8(97),G1H8(98),G1H8(103),8)
  call HG1shiftOLR(G1H8(96),64,8)
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,10),G1H4(25),ngZu,m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(25),221,nMT,G2H4(2),n2h4(2))
call HGT_w2_OLR(G1H16(3),1,1,16)
call HGT_w2_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(3),wf4(:,5),G1H4(25),m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(25),221,nMT,G2H4(3),n2h4(3))
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(4),wf4(:,6),G1H4(25),m3h4x4(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(25),231,nMB,G2H4(4),n2h4(4))
  call Hotf_4pt_reduction(G2H8(69),RedSet_4(17),mass4set(:,3),  & 
G1H8(108),G1H8(104),G1H8(107),G1H8(109),G1H8(112),8)
  call HG1shiftOLR(G1H8(104),64,8)
call HGT_w2_OLR(G1H16(5),1,1,16)
call HGT_w2_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(5),wf4(:,6),G1H4(25),m3h4x4(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(25),231,nMB,G2H4(5),n2h4(5))
  call Hotf_4pt_reduction(G2H8(70),RedSet_4(17),mass4set(:,3),  & 
G1H8(113),G1H8(114),G1H8(119),G1H8(124),G1H8(120),8)
  call HG1shiftOLR(G1H8(114),64,8)
call HGT_w2_OLR(G1H16(6),1,1,16)
call HGT_w2_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,12),G1H4(25),m3h4x4(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(25),221,nMT,G2H4(6),n2h4(6))
call HGT_w2_OLR(G1H16(7),1,1,16)
call HGT_w2_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,15),G1H4(25),ngZu,m3h4x4(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(25),221,nMT,G2H4(7),n2h4(7))
call HGT_w2_OLR(G1H16(8),1,1,16)
call HGT_w2_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(8),wf4(:,13),G1H4(25),m3h4x4(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(25),221,nMT,G2H4(8),n2h4(8))
call HGT_w2_OLR(G1H16(9),1,1,16)
call HGT_w2_invQ_OLR(G1H16(9),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(9),wf4(:,6),G1H4(25),m3h4x4(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(25),235,nMB,G2H4(9),n2h4(9))
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(24),mass4set(:,3),  & 
G1H8(123),G1H8(125),G1H8(128),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(125),64,8)
call HGT_w2_OLR(G1H16(10),1,1,16)
call HGT_w2_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_AW_Q(ntryL,G1H16(10),wf4(:,6),G1H4(25),m3h4x4(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(25),235,nMB,G2H4(10),n2h4(10))
  call Hotf_4pt_reduction(G2H8(61),RedSet_4(24),mass4set(:,3),  & 
G1H8(21),G1H8(22),G1H8(37),G1H8(38),G1H8(53),8)
  call HG1shiftOLR(G1H8(22),64,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(11),mass4set(:,5),  & 
G1H8(54),G1H8(69),G1H8(70),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(69),64,8)
  call Hloop_AW_Q(ntryL,G1H8(9),wf4(:,6),G1H2(1),m3h4x2(:,41),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(11),n2h2(41))
  call Hloop_AW_Q(ntryL,G1H8(90),wf4(:,6),G1H2(1),m3h4x2(:,42),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(13),n2h2(42))
  call Hloop_AW_Q(ntryL,G1H8(14),wf4(:,6),G1H2(1),m3h4x2(:,43),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(31),n2h2(43))
  call Hloop_AW_Q(ntryL,G1H8(95),wf4(:,6),G1H2(1),m3h4x2(:,44),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(33),n2h2(44))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(14),mass4set(:,1),  & 
G1H8(101),G1H8(102),G1H8(117),G1H8(118),G1H8(1),8)
  call HG1shiftOLR(G1H8(102),64,8)
  call Hloop_AW_Q(ntryL,G1H8(25),wf4(:,6),G1H2(1),m3h4x2(:,45),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(1),n2h2(45))
  call Hloop_AW_Q(ntryL,G1H8(30),wf4(:,6),G1H2(1),m3h4x2(:,46),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(3),n2h2(46))
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(16),mass4set(:,6),  & 
G1H8(2),G1H8(7),G1H8(12),G1H8(8),G1H8(11),8)
  call HG1shiftOLR(G1H8(7),64,8)
  call Hloop_AV_Q(ntryL,G1H8(41),wf4(:,3),G1H2(1),m3h4x2(:,47),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(6),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,3),G1H2(1),m3h4x2(:,48),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(8),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H8(46),wf4(:,3),G1H2(1),m3h4x2(:,49),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(16),n2h2(49))
  call Hloop_AV_Q(ntryL,G1H8(47),wf4(:,3),G1H2(1),m3h4x2(:,50),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(18),n2h2(50))
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(16),mass4set(:,6),  & 
G1H8(13),G1H8(16),G1H8(17),G1H8(18),G1H8(23),8)
  call HG1shiftOLR(G1H8(16),64,8)
  call Hloop_AZ_Q(ntryL,G1H8(57),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,51),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(21),n2h2(51))
  call Hloop_AZ_Q(ntryL,G1H8(58),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,52),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(23),n2h2(52))
  call Hloop_AZ_Q(ntryL,G1H8(62),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,53),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(26),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H8(63),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,54),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(28),n2h2(54))
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(19),mass4set(:,5),  & 
G1H8(28),G1H8(24),G1H8(27),G1H8(29),G1H8(32),8)
  call HG1shiftOLR(G1H8(24),64,8)
  call Hloop_AW_Q(ntryL,G1H8(73),wf4(:,6),G1H2(1),m3h4x2(:,55),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(36),n2h2(55))
  call Hloop_AW_Q(ntryL,G1H8(78),wf4(:,6),G1H2(1),m3h4x2(:,56),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(38),n2h2(56))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(21),mass4set(:,1),  & 
G1H8(33),G1H8(34),G1H8(39),G1H8(44),G1H8(40),8)
  call HG1shiftOLR(G1H8(34),64,8)
  call Hloop_AW_Q(ntryL,G1H8(89),wf4(:,6),G1H2(1),m3h4x2(:,57),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(41),n2h2(57))
  call Hloop_AW_Q(ntryL,G1H8(94),wf4(:,6),G1H2(1),m3h4x2(:,58),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(42),n2h2(58))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(23),mass4set(:,6),  & 
G1H8(43),G1H8(45),G1H8(48),G1H8(49),G1H8(50),8)
  call HG1shiftOLR(G1H8(45),64,8)
  call Hloop_AV_Q(ntryL,G1H8(105),wf4(:,12),G1H2(1),m3h4x2(:,59),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(43),n2h2(59))
  call Hloop_AV_Q(ntryL,G1H8(106),wf4(:,12),G1H2(1),m3h4x2(:,60),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(44),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H8(110),wf4(:,12),G1H2(1),m3h4x2(:,61),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(45),n2h2(61))
  call Hloop_AV_Q(ntryL,G1H8(111),wf4(:,12),G1H2(1),m3h4x2(:,62),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(46),n2h2(62))
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(23),mass4set(:,6),  & 
G1H8(55),G1H8(60),G1H8(56),G1H8(59),G1H8(61),8)
  call HG1shiftOLR(G1H8(60),64,8)
  call Hloop_AZ_Q(ntryL,G1H8(121),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,63),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(47),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H8(122),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,64),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(48),n2h2(64))
  call Hloop_AZ_Q(ntryL,G1H8(126),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,65),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(49),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H8(127),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,66),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(50),n2h2(66))
  call Hotf_4pt_reduction(G2H32(3),RedSet_4(2),mass4set(:,2),  & 
G1H32(20),G1H32(22),G1H32(23),G1H32(24),G1H32(25),32)
  call HG1shiftOLR(G1H32(22),98,32)
  call Hotf_4pt_reduction(G2H32(9),RedSet_4(2),mass4set(:,2),  & 
G1H32(26),G1H32(28),G1H32(29),G1H32(30),G1H32(31),32)
  call HG1shiftOLR(G1H32(28),98,32)
  call Hotf_4pt_reduction(G2H32(2),RedSet_4(4),mass4set(:,4),  & 
G1H32(32),G1H32(34),G1H32(35),G1H32(36),G1H32(37),32)
  call HG1shiftOLR(G1H32(34),98,32)
  call Hotf_4pt_reduction(G2H32(5),RedSet_4(3),mass4set(:,3),  & 
G1H32(38),G1H32(40),G1H32(41),G1H32(42),G1H32(43),32)
  call HG1shiftOLR(G1H32(40),64,32)
  call Hotf_4pt_reduction(G2H32(8),RedSet_4(3),mass4set(:,3),  & 
G1H32(44),G1H32(46),G1H32(47),G1H32(48),G1H32(49),32)
  call HG1shiftOLR(G1H32(46),64,32)
  call Hotf_4pt_reduction(G2H32(10),RedSet_4(3),mass4set(:,3),  & 
G1H32(50),G1H32(52),G1H32(53),G1H32(54),G1H32(55),32)
  call HG1shiftOLR(G1H32(52),64,32)
  call Hotf_4pt_reduction(G2H32(11),RedSet_4(5),mass4set(:,1),  & 
G1H32(56),G1H32(58),G1H32(59),G1H32(60),G1H32(3),32)
  call HG1shiftOLR(G1H32(58),88,32)
  call Hotf_4pt_reduction(G2H32(12),RedSet_4(5),mass4set(:,1),  & 
G1H32(9),G1H32(6),G1H32(15),G1H32(21),G1H32(27),32)
  call HG1shiftOLR(G1H32(6),88,32)
  call Hotf_4pt_reduction(G2H32(13),RedSet_4(1),mass4set(:,1),  & 
G1H32(33),G1H32(39),G1H32(13),G1H32(45),G1H32(51),32)
  call HG1shiftOLR(G1H32(39),64,32)
  call Hotf_4pt_reduction(G2H32(14),RedSet_4(1),mass4set(:,1),  & 
G1H32(57),G1H32(1),G1H32(2),G1H32(7),G1H32(4),32)
  call HG1shiftOLR(G1H32(1),64,32)
  call Hotf_4pt_reduction(G2H32(16),RedSet_4(3),mass4set(:,3),  & 
G1H32(5),G1H32(8),G1H32(10),G1H32(14),G1H32(11),32)
  call HG1shiftOLR(G1H32(8),64,32)
  call Hotf_4pt_reduction(G2H32(19),RedSet_4(3),mass4set(:,3),  & 
G1H32(12),G1H32(16),G1H32(17),G1H32(18),G1H32(19),32)
  call HG1shiftOLR(G1H32(16),64,32)
  call Hotf_4pt_reduction(G2H32(20),RedSet_4(3),mass4set(:,3),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),32)
  call HG1shiftOLR(G1H32(62),64,32)
  call Hotf_4pt_reduction(G2H32(22),RedSet_4(3),mass4set(:,3),  & 
G1H32(66),G1H32(67),G1H32(68),G1H32(69),G1H32(70),32)
  call HG1shiftOLR(G1H32(67),64,32)
  call Hotf_4pt_reduction(G2H32(23),RedSet_4(1),mass4set(:,1),  & 
G1H32(71),G1H32(72),G1H32(73),G1H32(74),G1H32(75),32)
  call HG1shiftOLR(G1H32(72),64,32)
  call Hotf_4pt_reduction(G2H32(24),RedSet_4(1),mass4set(:,1),  & 
G1H32(76),G1H32(77),G1H32(78),G1H32(79),G1H32(80),32)
  call HG1shiftOLR(G1H32(77),64,32)
  call Hotf_4pt_reduction(G2H32(25),RedSet_4(1),mass4set(:,1),  & 
G1H32(81),G1H32(82),G1H32(83),G1H32(84),G1H32(85),32)
  call HG1shiftOLR(G1H32(82),64,32)
  call Hotf_4pt_reduction(G2H32(26),RedSet_4(1),mass4set(:,1),  & 
G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
  call HG1shiftOLR(G1H32(87),64,32)
  call Hotf_4pt_reduction(G2H32(27),RedSet_4(7),mass4set(:,2),  & 
G1H32(91),G1H32(92),G1H32(93),G1H32(94),G1H32(95),32)
  call HG1shiftOLR(G1H32(92),98,32)
  call Hotf_4pt_reduction(G2H32(28),RedSet_4(7),mass4set(:,2),  & 
G1H32(96),G1H32(97),G1H32(98),G1H32(99),G1H32(100),32)
  call HG1shiftOLR(G1H32(97),98,32)
  call Hotf_4pt_reduction(G2H32(30),RedSet_4(9),mass4set(:,4),  & 
G1H32(101),G1H32(102),G1H32(103),G1H32(104),G1H32(105),32)
  call HG1shiftOLR(G1H32(102),98,32)
  call Hotf_4pt_reduction(G2H32(32),RedSet_4(8),mass4set(:,3),  & 
G1H32(106),G1H32(107),G1H32(108),G1H32(109),G1H32(110),32)
  call HG1shiftOLR(G1H32(107),64,32)
  call Hotf_4pt_reduction(G2H32(35),RedSet_4(8),mass4set(:,3),  & 
G1H32(111),G1H32(112),G1H32(113),G1H32(114),G1H32(115),32)
  call HG1shiftOLR(G1H32(112),64,32)
  call Hotf_4pt_reduction(G2H32(36),RedSet_4(8),mass4set(:,3),  & 
G1H32(116),G1H32(117),G1H32(118),G1H32(119),G1H32(120),32)
  call HG1shiftOLR(G1H32(117),64,32)
  call Hotf_4pt_reduction(G2H32(37),RedSet_4(10),mass4set(:,1),  & 
G1H32(121),G1H32(122),G1H32(123),G1H32(124),G1H32(125),32)
  call HG1shiftOLR(G1H32(122),84,32)
  call Hotf_4pt_reduction(G2H32(38),RedSet_4(10),mass4set(:,1),  & 
G1H32(126),G1H32(127),G1H32(128),G1H32(129),G1H32(130),32)
  call HG1shiftOLR(G1H32(127),84,32)
  call Hotf_4pt_reduction(G2H32(39),RedSet_4(6),mass4set(:,1),  & 
G1H32(131),G1H32(132),G1H32(133),G1H32(134),G1H32(135),32)
  call HG1shiftOLR(G1H32(132),64,32)
  call Hotf_4pt_reduction(G2H32(40),RedSet_4(6),mass4set(:,1),  & 
G1H32(136),G1H32(137),G1H32(138),G1H32(139),G1H32(140),32)
  call HG1shiftOLR(G1H32(137),64,32)
  call Hotf_4pt_reduction(G2H32(42),RedSet_4(8),mass4set(:,3),  & 
G1H32(141),G1H32(142),G1H32(143),G1H32(144),G1H32(145),32)
  call HG1shiftOLR(G1H32(142),64,32)
  call Hotf_4pt_reduction(G2H32(45),RedSet_4(8),mass4set(:,3),  & 
G1H32(146),G1H32(147),G1H32(148),G1H32(149),G1H32(150),32)
  call HG1shiftOLR(G1H32(147),64,32)
  call Hotf_4pt_reduction(G2H32(46),RedSet_4(8),mass4set(:,3),  & 
G1H32(151),G1H32(152),G1H32(153),G1H32(154),G1H32(155),32)
  call HG1shiftOLR(G1H32(152),64,32)
  call Hotf_4pt_reduction(G2H32(48),RedSet_4(8),mass4set(:,3),  & 
G1H32(156),G1H32(157),G1H32(158),G1H32(159),G1H32(160),32)
  call HG1shiftOLR(G1H32(157),64,32)
  call Hotf_4pt_reduction(G2H32(49),RedSet_4(6),mass4set(:,1),  & 
G1H32(161),G1H32(162),G1H32(163),G1H32(164),G1H32(165),32)
  call HG1shiftOLR(G1H32(162),64,32)
  call Hotf_4pt_reduction(G2H32(50),RedSet_4(6),mass4set(:,1),  & 
G1H32(166),G1H32(167),G1H32(168),G1H32(169),G1H32(170),32)
  call HG1shiftOLR(G1H32(167),64,32)
  call Hotf_4pt_reduction(G2H32(51),RedSet_4(6),mass4set(:,1),  & 
G1H32(171),G1H32(172),G1H32(173),G1H32(174),G1H32(175),32)
  call HG1shiftOLR(G1H32(172),64,32)
  call Hotf_4pt_reduction(G2H32(52),RedSet_4(6),mass4set(:,1),  & 
G1H32(176),G1H32(177),G1H32(178),G1H32(179),G1H32(180),32)
  call HG1shiftOLR(G1H32(177),64,32)
  call Hotf_4pt_reduction(G2H32(55),RedSet_4(8),mass4set(:,3),  & 
G1H32(181),G1H32(182),G1H32(183),G1H32(184),G1H32(185),32)
  call HG1shiftOLR(G1H32(182),64,32)
  call Hotf_4pt_reduction(G2H32(56),RedSet_4(8),mass4set(:,3),  & 
G1H32(186),G1H32(187),G1H32(188),G1H32(189),G1H32(190),32)
  call HG1shiftOLR(G1H32(187),64,32)
  call Hotf_4pt_reduction(G2H32(58),RedSet_4(8),mass4set(:,3),  & 
G1H32(191),G1H32(192),G1H32(193),G1H32(194),G1H32(195),32)
  call HG1shiftOLR(G1H32(192),64,32)
  call Hotf_4pt_reduction(G2H32(60),RedSet_4(3),mass4set(:,3),  & 
G1H32(196),G1H32(197),G1H32(198),G1H32(199),G1H32(200),32)
  call HG1shiftOLR(G1H32(197),64,32)
  call Hotf_4pt_reduction(G2H32(62),RedSet_4(3),mass4set(:,3),  & 
G1H32(201),G1H32(202),G1H32(203),G1H32(204),G1H32(205),32)
  call HG1shiftOLR(G1H32(202),64,32)
  call Hotf_4pt_reduction(G2H32(64),RedSet_4(3),mass4set(:,3),  & 
G1H32(206),G1H32(207),G1H32(208),G1H32(209),G1H32(210),32)
  call HG1shiftOLR(G1H32(207),64,32)
  call Hloop_AW_Q(ntryL,G1H8(93),wf4(:,6),G1H2(1),m3h4x2(:,67),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(51),n2h2(67))
call HGT_raise_alpha_OLR(G1H8(96),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(96),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(96),ex7(:),G1H4(25),m3h2x4(:,25),heltab2x8(:,:,92))
  call Hloop_AW_Q(ntryL,G1H8(98),wf4(:,6),G1H2(1),m3h4x2(:,68),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(52),n2h2(68))
  call Hloop_AW_Q(ntryL,G1H8(103),wf4(:,6),G1H2(1),m3h4x2(:,69),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(53),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H8(108),wf4(:,3),G1H2(1),m3h4x2(:,70),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(54),n2h2(70))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(104),ex7(:),G1H4(26),m3h2x4(:,26),heltab2x8(:,:,96))
  call Hloop_AV_Q(ntryL,G1H8(109),wf4(:,3),G1H2(1),m3h4x2(:,71),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(55),n2h2(71))
  call Hloop_AV_Q(ntryL,G1H8(112),wf4(:,3),G1H2(1),m3h4x2(:,72),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(56),n2h2(72))
  call Hloop_AZ_Q(ntryL,G1H8(113),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,73),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(57),n2h2(73))
call HGT_raise_alpha_OLR(G1H8(114),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(114),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(114),ex7(:),G1H4(27),m3h2x4(:,27),heltab2x8(:,:,100))
  call Hloop_AZ_Q(ntryL,G1H8(124),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,74),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(58),n2h2(74))
  call Hloop_AZ_Q(ntryL,G1H8(120),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,75),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(59),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H8(123),wf4(:,12),G1H2(1),m3h4x2(:,76),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(60),n2h2(76))
call HGT_raise_alpha_OLR(G1H8(125),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(125),ex7(:),G1H4(28),m3h2x4(:,28),heltab2x8(:,:,104))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,12),G1H2(1),m3h4x2(:,77),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(61),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,12),G1H2(1),m3h4x2(:,78),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(62),n2h2(78))
  call Hloop_AZ_Q(ntryL,G1H8(21),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,79),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(63),n2h2(79))
call HGT_raise_alpha_OLR(G1H8(22),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(22),ex7(:),G1H4(29),m3h2x4(:,29),heltab2x8(:,:,108))
  call Hloop_AZ_Q(ntryL,G1H8(38),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,80),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(64),n2h2(80))
  call Hloop_AZ_Q(ntryL,G1H8(53),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,81),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(65),n2h2(81))
  call Hloop_AW_Q(ntryL,G1H8(54),wf4(:,6),G1H2(1),m3h4x2(:,82),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(66),n2h2(82))
call HGT_raise_alpha_OLR(G1H8(69),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(69),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(69),ex7(:),G1H4(30),m3h2x4(:,30),heltab2x8(:,:,112))
  call Hloop_AW_Q(ntryL,G1H8(85),wf4(:,6),G1H2(1),m3h4x2(:,83),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(67),n2h2(83))
  call Hloop_AW_Q(ntryL,G1H8(86),wf4(:,6),G1H2(1),m3h4x2(:,84),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(68),n2h2(84))
  call Hloop_AW_Q(ntryL,G1H8(101),wf4(:,6),G1H2(1),m3h4x2(:,85),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(69),n2h2(85))
call HGT_raise_alpha_OLR(G1H8(102),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(102),ex7(:),G1H4(31),m3h2x4(:,31),heltab2x8(:,:,116))
  call Hloop_AW_Q(ntryL,G1H8(118),wf4(:,6),G1H2(1),m3h4x2(:,86),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(70),n2h2(86))
  call Hloop_AW_Q(ntryL,G1H8(1),wf4(:,6),G1H2(1),m3h4x2(:,87),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(71),n2h2(87))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,3),G1H2(1),m3h4x2(:,88),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(72),n2h2(88))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex7(:),G1H4(32),m3h2x4(:,32),heltab2x8(:,:,120))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,3),G1H2(1),m3h4x2(:,89),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(73),n2h2(89))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,3),G1H2(1),m3h4x2(:,90),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(74),n2h2(90))
  call Hloop_AZ_Q(ntryL,G1H8(13),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,91),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(75),n2h2(91))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(16),ex7(:),G1H4(33),m3h2x4(:,33),heltab2x8(:,:,124))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,92),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(76),n2h2(92))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,93),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(77),n2h2(93))
  call Hloop_AW_Q(ntryL,G1H8(28),wf4(:,6),G1H2(1),m3h4x2(:,94),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(78),n2h2(94))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(24),ex7(:),G1H4(34),m3h2x4(:,34),heltab2x8(:,:,128))
  call Hloop_AW_Q(ntryL,G1H8(29),wf4(:,6),G1H2(1),m3h4x2(:,95),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(79),n2h2(95))
  call Hloop_AW_Q(ntryL,G1H8(32),wf4(:,6),G1H2(1),m3h4x2(:,96),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(80),n2h2(96))
  call Hloop_AW_Q(ntryL,G1H8(33),wf4(:,6),G1H2(1),m3h4x2(:,97),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(81),n2h2(97))
call HGT_raise_alpha_OLR(G1H8(34),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(34),ex7(:),G1H4(35),m3h2x4(:,35),heltab2x8(:,:,132))
  call Hloop_AW_Q(ntryL,G1H8(44),wf4(:,6),G1H2(1),m3h4x2(:,98),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(82),n2h2(98))
  call Hloop_AW_Q(ntryL,G1H8(40),wf4(:,6),G1H2(1),m3h4x2(:,99),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(83),n2h2(99))
  call Hloop_AV_Q(ntryL,G1H8(43),wf4(:,12),G1H2(1),m3h4x2(:,100),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(84),n2h2(100))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(45),ex7(:),G1H4(36),m3h2x4(:,36),heltab2x8(:,:,136))
  call Hloop_AV_Q(ntryL,G1H8(49),wf4(:,12),G1H2(1),m3h4x2(:,101),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(85),n2h2(101))
  call Hloop_AV_Q(ntryL,G1H8(50),wf4(:,12),G1H2(1),m3h4x2(:,102),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(86),n2h2(102))
  call Hloop_AZ_Q(ntryL,G1H8(55),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,103),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(87),n2h2(103))
call HGT_raise_alpha_OLR(G1H8(60),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(60),ex7(:),G1H4(37),m3h2x4(:,37),heltab2x8(:,:,140))
  call Hloop_AZ_Q(ntryL,G1H8(59),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,104),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(88),n2h2(104))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,105),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(89),n2h2(105))
  call Hloop_AV_Q(ntryL,G1H32(20),wf4(:,3),G1H8(64),m3h4x8(:,51),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(64),157,nMT,G2H8(71),n2h8(140))
call HGT_raise_alpha_OLR(G1H32(22),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(22),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(22),wf8(:,3),G1H4(38),m3h8x4(:,1),heltab2x32(:,:,62))
  call Hloop_AV_Q(ntryL,G1H32(24),wf4(:,3),G1H8(65),m3h4x8(:,52),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(65),157,nMT,G2H8(68),n2h8(141))
  call Hloop_AV_Q(ntryL,G1H32(25),wf4(:,3),G1H8(66),m3h4x8(:,53),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(66),157,nMT,G2H8(63),n2h8(142))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf4(:,10),G1H8(71),ngZu,m3h4x8(:,54),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(71),157,nMT,G2H8(62),n2h8(143))
call HGT_raise_alpha_OLR(G1H32(28),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(28),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(28),wf8(:,3),G1H4(39),m3h8x4(:,2),heltab2x32(:,:,66))
  call Hloop_AZ_Q(ntryL,G1H32(30),wf4(:,10),G1H8(76),ngZu,m3h4x8(:,55),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(76),157,nMT,G2H8(59),n2h8(144))
  call Hloop_AZ_Q(ntryL,G1H32(31),wf4(:,10),G1H8(72),ngZu,m3h4x8(:,56),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(72),157,nMT,G2H8(54),n2h8(145))
  call Hloop_AW_Q(ntryL,G1H32(32),wf4(:,5),G1H8(75),m3h4x8(:,57),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(75),157,nMT,G2H8(45),n2h8(146))
call HGT_raise_alpha_OLR(G1H32(34),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(34),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(34),wf8(:,3),G1H4(40),m3h8x4(:,3),heltab2x32(:,:,70))
  call Hloop_AW_Q(ntryL,G1H32(36),wf4(:,5),G1H8(77),m3h4x8(:,58),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(77),157,nMT,G2H8(44),n2h8(147))
  call Hloop_AW_Q(ntryL,G1H32(37),wf4(:,5),G1H8(80),m3h4x8(:,59),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(80),157,nMT,G2H8(36),n2h8(148))
  call Hloop_AS_Q(ntryL,G1H32(38),wf16(:,4),G1H2(1),ngH,m3h16x2(:,1),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(90),n2h2(106))
call HGT_raise_alpha_OLR(G1H32(40),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(40),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(40),ex7(:),G1H16(1),m3h2x16(:,11),heltab2x32(:,:,74))
  call Hloop_AS_Q(ntryL,G1H32(42),wf16(:,4),G1H2(1),ngH,m3h16x2(:,2),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(91),n2h2(107))
  call Hloop_AS_Q(ntryL,G1H32(43),wf16(:,4),G1H2(1),ngH,m3h16x2(:,3),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(92),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H32(44),wf16(:,1),G1H2(1),m3h16x2(:,4),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(93),n2h2(109))
call HGT_raise_alpha_OLR(G1H32(46),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(46),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(46),ex7(:),G1H16(2),m3h2x16(:,12),heltab2x32(:,:,78))
  call Hloop_AV_Q(ntryL,G1H32(48),wf16(:,1),G1H2(1),m3h16x2(:,5),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(94),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H32(49),wf16(:,1),G1H2(1),m3h16x2(:,6),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(95),n2h2(111))
  call Hloop_AZ_Q(ntryL,G1H32(50),wf16(:,3),G1H2(1),ngZd,m3h16x2(:,7),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(96),n2h2(112))
call HGT_raise_alpha_OLR(G1H32(52),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(52),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(52),ex7(:),G1H16(3),m3h2x16(:,13),heltab2x32(:,:,82))
  call Hloop_AZ_Q(ntryL,G1H32(54),wf16(:,3),G1H2(1),ngZd,m3h16x2(:,8),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(97),n2h2(113))
  call Hloop_AZ_Q(ntryL,G1H32(55),wf16(:,3),G1H2(1),ngZd,m3h16x2(:,9),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(98),n2h2(114))
  call Hloop_AW_Q(ntryL,G1H32(56),wf4(:,6),G1H8(81),m3h4x8(:,60),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(81),167,nMB,G2H8(20),n2h8(149))
call HGT_raise_alpha_OLR(G1H32(58),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(58),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(58),wf8(:,6),G1H4(41),m3h8x4(:,4),heltab2x32(:,:,86))
  call Hloop_AW_Q(ntryL,G1H32(60),wf4(:,6),G1H8(82),m3h4x8(:,61),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(82),167,nMB,G2H8(19),n2h8(150))
  call Hloop_AW_Q(ntryL,G1H32(3),wf4(:,6),G1H8(87),m3h4x8(:,62),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(87),167,nMB,G2H8(30),n2h8(151))
  call Hloop_AW_Q(ntryL,G1H32(9),wf4(:,6),G1H8(92),m3h4x8(:,63),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(92),167,nMB,G2H8(26),n2h8(152))
call HGT_raise_alpha_OLR(G1H32(6),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(6),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(6),wf8(:,8),G1H4(42),m3h8x4(:,5),heltab2x32(:,:,90))
  call Hloop_AW_Q(ntryL,G1H32(21),wf4(:,6),G1H8(88),m3h4x8(:,64),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(88),167,nMB,G2H8(22),n2h8(153))
  call Hloop_AW_Q(ntryL,G1H32(27),wf4(:,6),G1H8(91),m3h4x8(:,65),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(91),167,nMB,G2H8(10),n2h8(154))
  call Hloop_AW_Q(ntryL,G1H32(33),wf16(:,21),G1H2(1),m3h16x2(:,10),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(99),n2h2(115))
call HGT_raise_alpha_OLR(G1H32(39),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(39),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(39),ex7(:),G1H16(4),m3h2x16(:,14),heltab2x32(:,:,94))
  call Hloop_AW_Q(ntryL,G1H32(45),wf16(:,21),G1H2(1),m3h16x2(:,11),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(100),n2h2(116))
  call Hloop_AW_Q(ntryL,G1H32(51),wf16(:,21),G1H2(1),m3h16x2(:,12),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(101),n2h2(117))
  call Hloop_AW_Q(ntryL,G1H32(57),wf16(:,23),G1H2(1),m3h16x2(:,13),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(102),n2h2(118))
call HGT_raise_alpha_OLR(G1H32(1),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(1),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(1),ex7(:),G1H16(5),m3h2x16(:,15),heltab2x32(:,:,98))
  call Hloop_AW_Q(ntryL,G1H32(7),wf16(:,23),G1H2(1),m3h16x2(:,14),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(103),n2h2(119))
  call Hloop_AW_Q(ntryL,G1H32(4),wf16(:,23),G1H2(1),m3h16x2(:,15),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(104),n2h2(120))
  call Hloop_AS_Q(ntryL,G1H32(5),wf16(:,37),G1H2(1),ngH,m3h16x2(:,16),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(105),n2h2(121))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(8),ex7(:),G1H16(6),m3h2x16(:,16),heltab2x32(:,:,102))
  call Hloop_AS_Q(ntryL,G1H32(14),wf16(:,37),G1H2(1),ngH,m3h16x2(:,17),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(106),n2h2(122))
  call Hloop_AS_Q(ntryL,G1H32(11),wf16(:,37),G1H2(1),ngH,m3h16x2(:,18),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(107),n2h2(123))
  call Hloop_AV_Q(ntryL,G1H32(12),wf16(:,48),G1H2(1),m3h16x2(:,19),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(108),n2h2(124))
call HGT_raise_alpha_OLR(G1H32(16),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(16),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(16),ex7(:),G1H16(7),m3h2x16(:,17),heltab2x32(:,:,106))
  call Hloop_AV_Q(ntryL,G1H32(18),wf16(:,48),G1H2(1),m3h16x2(:,20),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(109),n2h2(125))
  call Hloop_AV_Q(ntryL,G1H32(19),wf16(:,48),G1H2(1),m3h16x2(:,21),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(110),n2h2(126))
  call Hloop_AZ_Q(ntryL,G1H32(61),wf16(:,49),G1H2(1),ngZd,m3h16x2(:,22),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(111),n2h2(127))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(62),ex7(:),G1H16(8),m3h2x16(:,18),heltab2x32(:,:,110))
  call Hloop_AZ_Q(ntryL,G1H32(64),wf16(:,49),G1H2(1),ngZd,m3h16x2(:,23),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(112),n2h2(128))
  call Hloop_AZ_Q(ntryL,G1H32(65),wf16(:,49),G1H2(1),ngZd,m3h16x2(:,24),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(113),n2h2(129))
  call Hloop_AZ_Q(ntryL,G1H32(66),wf16(:,50),G1H2(1),ngZd,m3h16x2(:,25),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(114),n2h2(130))
call HGT_raise_alpha_OLR(G1H32(67),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(67),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(67),ex7(:),G1H16(9),m3h2x16(:,19),heltab2x32(:,:,114))
  call Hloop_AZ_Q(ntryL,G1H32(69),wf16(:,50),G1H2(1),ngZd,m3h16x2(:,26),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(115),n2h2(131))
  call Hloop_AZ_Q(ntryL,G1H32(70),wf16(:,50),G1H2(1),ngZd,m3h16x2(:,27),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(116),n2h2(132))
  call Hloop_AW_Q(ntryL,G1H32(71),wf16(:,51),G1H2(1),m3h16x2(:,28),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(117),n2h2(133))
call HGT_raise_alpha_OLR(G1H32(72),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(72),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(72),ex7(:),G1H16(10),m3h2x16(:,20),heltab2x32(:,:,118))
  call Hloop_AW_Q(ntryL,G1H32(74),wf16(:,51),G1H2(1),m3h16x2(:,29),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(118),n2h2(134))
  call Hloop_AW_Q(ntryL,G1H32(75),wf16(:,51),G1H2(1),m3h16x2(:,30),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(119),n2h2(135))
  call Hloop_AW_Q(ntryL,G1H32(76),wf16(:,52),G1H2(1),m3h16x2(:,31),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(120),n2h2(136))
call HGT_raise_alpha_OLR(G1H32(77),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(77),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(77),ex7(:),G1H16(11),m3h2x16(:,21),heltab2x32(:,:,122))
  call Hloop_AW_Q(ntryL,G1H32(79),wf16(:,52),G1H2(1),m3h16x2(:,32),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(121),n2h2(137))
  call Hloop_AW_Q(ntryL,G1H32(80),wf16(:,52),G1H2(1),m3h16x2(:,33),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(122),n2h2(138))
  call Hloop_AW_Q(ntryL,G1H32(81),wf16(:,53),G1H2(1),m3h16x2(:,34),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(123),n2h2(139))
call HGT_raise_alpha_OLR(G1H32(82),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(82),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(82),ex7(:),G1H16(12),m3h2x16(:,22),heltab2x32(:,:,126))
  call Hloop_AW_Q(ntryL,G1H32(84),wf16(:,53),G1H2(1),m3h16x2(:,35),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(124),n2h2(140))
  call Hloop_AW_Q(ntryL,G1H32(85),wf16(:,53),G1H2(1),m3h16x2(:,36),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(125),n2h2(141))
  call Hloop_AW_Q(ntryL,G1H32(86),wf16(:,68),G1H2(1),m3h16x2(:,37),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(126),n2h2(142))
call HGT_raise_alpha_OLR(G1H32(87),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(87),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(87),ex7(:),G1H16(13),m3h2x16(:,23),heltab2x32(:,:,130))
  call Hloop_AW_Q(ntryL,G1H32(89),wf16(:,68),G1H2(1),m3h16x2(:,38),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(127),n2h2(143))
  call Hloop_AW_Q(ntryL,G1H32(90),wf16(:,68),G1H2(1),m3h16x2(:,39),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(128),n2h2(144))
  call Hloop_AV_Q(ntryL,G1H32(91),wf4(:,12),G1H8(84),m3h4x8(:,66),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(84),157,nMT,G2H8(6),n2h8(155))
call HGT_raise_alpha_OLR(G1H32(92),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(92),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(92),wf8(:,3),G1H4(43),m3h8x4(:,6),heltab2x32(:,:,134))
  call Hloop_AV_Q(ntryL,G1H32(94),wf4(:,12),G1H8(68),m3h4x8(:,67),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(68),157,nMT,G2H8(2),n2h8(156))
  call Hloop_AV_Q(ntryL,G1H32(95),wf4(:,12),G1H8(20),m3h4x8(:,68),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(20),157,nMT,G2H8(66),n2h8(157))
  call Hloop_AZ_Q(ntryL,G1H32(96),wf4(:,15),G1H8(4),ngZu,m3h4x8(:,69),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G1H8(4),157,nMT,G2H8(64),n2h8(158))
call HGT_raise_alpha_OLR(G1H32(97),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(97),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(97),wf8(:,3),G1H4(44),m3h8x4(:,7),heltab2x32(:,:,138))
  call Hloop_AZ_Q(ntryL,G1H32(99),wf4(:,15),G1H8(36),ngZu,m3h4x8(:,70),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(36),157,nMT,G2H8(33),n2h8(159))
  call Hloop_AZ_Q(ntryL,G1H32(100),wf4(:,15),G1H8(52),ngZu,m3h4x8(:,71),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(52),157,nMT,G2H8(29),n2h8(160))
  call Hloop_AW_Q(ntryL,G1H32(101),wf4(:,13),G1H8(100),m3h4x8(:,72),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(100),157,nMT,G2H8(28),n2h8(161))
call HGT_raise_alpha_OLR(G1H32(102),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(102),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(102),wf8(:,3),G1H4(45),m3h8x4(:,8),heltab2x32(:,:,142))
  call Hloop_AW_Q(ntryL,G1H32(104),wf4(:,13),G1H8(116),m3h4x8(:,73),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G1H8(116),157,nMT,G2H8(25),n2h8(162))
  call Hloop_AW_Q(ntryL,G1H32(105),wf4(:,13),G1H8(3),m3h4x8(:,74),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G1H8(3),157,nMT,G2H8(15),n2h8(163))
  call Hloop_AS_Q(ntryL,G1H32(106),wf16(:,79),G1H2(1),ngH,m3h16x2(:,40),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(129),n2h2(145))
call HGT_raise_alpha_OLR(G1H32(107),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(107),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(107),ex7(:),G1H16(14),m3h2x16(:,24),heltab2x32(:,:,146))
  call Hloop_AS_Q(ntryL,G1H32(109),wf16(:,79),G1H2(1),ngH,m3h16x2(:,41),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(130),n2h2(146))
  call Hloop_AS_Q(ntryL,G1H32(110),wf16(:,79),G1H2(1),ngH,m3h16x2(:,42),heltab2x32(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(131),n2h2(147))
  call Hloop_AV_Q(ntryL,G1H32(111),wf16(:,76),G1H2(1),m3h16x2(:,43),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(132),n2h2(148))
call HGT_raise_alpha_OLR(G1H32(112),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(112),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(112),ex7(:),G1H16(15),m3h2x16(:,25),heltab2x32(:,:,150))
  call Hloop_AV_Q(ntryL,G1H32(114),wf16(:,76),G1H2(1),m3h16x2(:,44),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(133),n2h2(149))
  call Hloop_AV_Q(ntryL,G1H32(115),wf16(:,76),G1H2(1),m3h16x2(:,45),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(134),n2h2(150))
  call Hloop_AZ_Q(ntryL,G1H32(116),wf16(:,78),G1H2(1),ngZd,m3h16x2(:,46),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(135),n2h2(151))
call HGT_raise_alpha_OLR(G1H32(117),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(117),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(117),ex7(:),G1H16(16),m3h2x16(:,26),heltab2x32(:,:,154))
  call Hloop_AZ_Q(ntryL,G1H32(119),wf16(:,78),G1H2(1),ngZd,m3h16x2(:,47),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(136),n2h2(152))
  call Hloop_AZ_Q(ntryL,G1H32(120),wf16(:,78),G1H2(1),ngZd,m3h16x2(:,48),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(137),n2h2(153))
  call Hloop_AW_Q(ntryL,G1H32(121),wf4(:,6),G1H8(74),m3h4x8(:,75),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G1H8(74),171,nMB,G2H8(13),n2h8(164))
call HGT_raise_alpha_OLR(G1H32(122),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(122),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(122),wf8(:,46),G1H4(46),m3h8x4(:,9),heltab2x32(:,:,158))
  call Hloop_AW_Q(ntryL,G1H32(124),wf4(:,6),G1H8(26),m3h4x8(:,76),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G1H8(26),171,nMB,G2H8(11),n2h8(165))
  call Hloop_AW_Q(ntryL,G1H32(125),wf4(:,6),G1H8(10),m3h4x8(:,77),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G1H8(10),171,nMB,G2H8(14),n2h8(166))
  call Hloop_AW_Q(ntryL,G1H32(126),wf4(:,6),G1H8(79),m3h4x8(:,78),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G1H8(79),171,nMB,G2H8(67),n2h8(167))
call HGT_raise_alpha_OLR(G1H32(127),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(127),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(127),wf8(:,48),G1H4(47),m3h8x4(:,10),heltab2x32(:,:,162))
  call Hloop_AW_Q(ntryL,G1H32(129),wf4(:,6),G1H8(31),m3h4x8(:,79),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H8(31),171,nMB,G2H8(65),n2h8(168))
  call Hloop_AW_Q(ntryL,G1H32(130),wf4(:,6),G1H8(15),m3h4x8(:,80),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G1H8(15),171,nMB,G2H8(35),n2h8(169))
  call Hloop_AW_Q(ntryL,G1H32(131),wf16(:,93),G1H2(1),m3h16x2(:,49),heltab2x32(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(138),n2h2(154))
call HGT_raise_alpha_OLR(G1H32(132),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(132),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(132),ex7(:),G1H16(17),m3h2x16(:,27),heltab2x32(:,:,166))
  call Hloop_AW_Q(ntryL,G1H32(134),wf16(:,93),G1H2(1),m3h16x2(:,50),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(139),n2h2(155))
  call Hloop_AW_Q(ntryL,G1H32(135),wf16(:,93),G1H2(1),m3h16x2(:,51),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(140),n2h2(156))
  call Hloop_AW_Q(ntryL,G1H32(136),wf16(:,95),G1H2(1),m3h16x2(:,52),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(141),n2h2(157))
call HGT_raise_alpha_OLR(G1H32(137),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(137),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(137),ex7(:),G1H16(18),m3h2x16(:,28),heltab2x32(:,:,170))
  call Hloop_AW_Q(ntryL,G1H32(139),wf16(:,95),G1H2(1),m3h16x2(:,53),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(142),n2h2(158))
  call Hloop_AW_Q(ntryL,G1H32(140),wf16(:,95),G1H2(1),m3h16x2(:,54),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(143),n2h2(159))
  call Hloop_AS_Q(ntryL,G1H32(141),wf16(:,108),G1H2(1),ngH,m3h16x2(:,55),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(144),n2h2(160))
call HGT_raise_alpha_OLR(G1H32(142),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(142),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(142),ex7(:),G1H16(19),m3h2x16(:,29),heltab2x32(:,:,174))
  call Hloop_AS_Q(ntryL,G1H32(144),wf16(:,108),G1H2(1),ngH,m3h16x2(:,56),heltab2x32(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(145),n2h2(161))
  call Hloop_AS_Q(ntryL,G1H32(145),wf16(:,108),G1H2(1),ngH,m3h16x2(:,57),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(146),n2h2(162))
  call Hloop_AV_Q(ntryL,G1H32(146),wf16(:,115),G1H2(1),m3h16x2(:,58),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(147),n2h2(163))
call HGT_raise_alpha_OLR(G1H32(147),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(147),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(147),ex7(:),G1H16(20),m3h2x16(:,30),heltab2x32(:,:,178))
  call Hloop_AV_Q(ntryL,G1H32(149),wf16(:,115),G1H2(1),m3h16x2(:,59),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(148),n2h2(164))
  call Hloop_AV_Q(ntryL,G1H32(150),wf16(:,115),G1H2(1),m3h16x2(:,60),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(149),n2h2(165))
  call Hloop_AZ_Q(ntryL,G1H32(151),wf16(:,116),G1H2(1),ngZd,m3h16x2(:,61),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(150),n2h2(166))
call HGT_raise_alpha_OLR(G1H32(152),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(152),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(152),ex7(:),G1H16(21),m3h2x16(:,31),heltab2x32(:,:,182))
  call Hloop_AZ_Q(ntryL,G1H32(154),wf16(:,116),G1H2(1),ngZd,m3h16x2(:,62),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(151),n2h2(167))
  call Hloop_AZ_Q(ntryL,G1H32(155),wf16(:,116),G1H2(1),ngZd,m3h16x2(:,63),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(152),n2h2(168))
  call Hloop_AZ_Q(ntryL,G1H32(156),wf16(:,117),G1H2(1),ngZd,m3h16x2(:,64),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(153),n2h2(169))
call HGT_raise_alpha_OLR(G1H32(157),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(157),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(157),ex7(:),G1H16(22),m3h2x16(:,32),heltab2x32(:,:,186))
  call Hloop_AZ_Q(ntryL,G1H32(159),wf16(:,117),G1H2(1),ngZd,m3h16x2(:,65),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(154),n2h2(170))
  call Hloop_AZ_Q(ntryL,G1H32(160),wf16(:,117),G1H2(1),ngZd,m3h16x2(:,66),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(155),n2h2(171))
  call Hloop_AW_Q(ntryL,G1H32(161),wf16(:,118),G1H2(1),m3h16x2(:,67),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(156),n2h2(172))
call HGT_raise_alpha_OLR(G1H32(162),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(162),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(162),ex7(:),G1H16(23),m3h2x16(:,33),heltab2x32(:,:,190))
  call Hloop_AW_Q(ntryL,G1H32(164),wf16(:,118),G1H2(1),m3h16x2(:,68),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(157),n2h2(173))
  call Hloop_AW_Q(ntryL,G1H32(165),wf16(:,118),G1H2(1),m3h16x2(:,69),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(158),n2h2(174))
  call Hloop_AW_Q(ntryL,G1H32(166),wf16(:,119),G1H2(1),m3h16x2(:,70),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(159),n2h2(175))
call HGT_raise_alpha_OLR(G1H32(167),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(167),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(167),ex7(:),G1H16(24),m3h2x16(:,34),heltab2x32(:,:,194))
  call Hloop_AW_Q(ntryL,G1H32(169),wf16(:,119),G1H2(1),m3h16x2(:,71),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(160),n2h2(176))
  call Hloop_AW_Q(ntryL,G1H32(170),wf16(:,119),G1H2(1),m3h16x2(:,72),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(161),n2h2(177))
  call Hloop_AW_Q(ntryL,G1H32(171),wf16(:,120),G1H2(1),m3h16x2(:,73),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(162),n2h2(178))
call HGT_raise_alpha_OLR(G1H32(172),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(172),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(172),ex7(:),G1H16(25),m3h2x16(:,35),heltab2x32(:,:,198))
  call Hloop_AW_Q(ntryL,G1H32(174),wf16(:,120),G1H2(1),m3h16x2(:,74),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(163),n2h2(179))
  call Hloop_AW_Q(ntryL,G1H32(175),wf16(:,120),G1H2(1),m3h16x2(:,75),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(164),n2h2(180))
  call Hloop_AW_Q(ntryL,G1H32(176),wf16(:,132),G1H2(1),m3h16x2(:,76),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(165),n2h2(181))
call HGT_raise_alpha_OLR(G1H32(177),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(177),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(177),ex7(:),G1H16(26),m3h2x16(:,36),heltab2x32(:,:,202))
  call Hloop_AW_Q(ntryL,G1H32(179),wf16(:,132),G1H2(1),m3h16x2(:,77),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(166),n2h2(182))
  call Hloop_AW_Q(ntryL,G1H32(180),wf16(:,132),G1H2(1),m3h16x2(:,78),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(167),n2h2(183))
  call Hloop_AV_Q(ntryL,G1H32(181),wf16(:,145),G1H2(1),m3h16x2(:,79),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(168),n2h2(184))
call HGT_raise_alpha_OLR(G1H32(182),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(182),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(182),ex7(:),G1H16(27),m3h2x16(:,37),heltab2x32(:,:,206))
  call Hloop_AV_Q(ntryL,G1H32(184),wf16(:,145),G1H2(1),m3h16x2(:,80),heltab2x32(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(169),n2h2(185))
  call Hloop_AV_Q(ntryL,G1H32(185),wf16(:,145),G1H2(1),m3h16x2(:,81),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(170),n2h2(186))
  call Hloop_AZ_Q(ntryL,G1H32(186),wf16(:,146),G1H2(1),ngZd,m3h16x2(:,82),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(171),n2h2(187))
call HGT_raise_alpha_OLR(G1H32(187),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(187),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(187),ex7(:),G1H16(28),m3h2x16(:,38),heltab2x32(:,:,210))
  call Hloop_AZ_Q(ntryL,G1H32(189),wf16(:,146),G1H2(1),ngZd,m3h16x2(:,83),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(172),n2h2(188))
  call Hloop_AZ_Q(ntryL,G1H32(190),wf16(:,146),G1H2(1),ngZd,m3h16x2(:,84),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(173),n2h2(189))
  call Hloop_AZ_Q(ntryL,G1H32(191),wf16(:,148),G1H2(1),ngZd,m3h16x2(:,85),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(174),n2h2(190))
call HGT_raise_alpha_OLR(G1H32(192),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(192),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(192),ex7(:),G1H16(29),m3h2x16(:,39),heltab2x32(:,:,214))
  call Hloop_AZ_Q(ntryL,G1H32(194),wf16(:,148),G1H2(1),ngZd,m3h16x2(:,86),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(175),n2h2(191))
  call Hloop_AZ_Q(ntryL,G1H32(195),wf16(:,148),G1H2(1),ngZd,m3h16x2(:,87),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(176),n2h2(192))
  call Hloop_AV_Q(ntryL,G1H32(196),wf16(:,162),G1H2(1),m3h16x2(:,88),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(177),n2h2(193))
call HGT_raise_alpha_OLR(G1H32(197),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(197),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(197),ex7(:),G1H16(30),m3h2x16(:,40),heltab2x32(:,:,218))
  call Hloop_AV_Q(ntryL,G1H32(199),wf16(:,162),G1H2(1),m3h16x2(:,89),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(178),n2h2(194))
  call Hloop_AV_Q(ntryL,G1H32(200),wf16(:,162),G1H2(1),m3h16x2(:,90),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(179),n2h2(195))
  call Hloop_AZ_Q(ntryL,G1H32(201),wf16(:,163),G1H2(1),ngZd,m3h16x2(:,91),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(180),n2h2(196))
call HGT_raise_alpha_OLR(G1H32(202),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(202),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(202),ex7(:),G1H16(31),m3h2x16(:,41),heltab2x32(:,:,222))
  call Hloop_AZ_Q(ntryL,G1H32(204),wf16(:,163),G1H2(1),ngZd,m3h16x2(:,92),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(181),n2h2(197))
  call Hloop_AZ_Q(ntryL,G1H32(205),wf16(:,163),G1H2(1),ngZd,m3h16x2(:,93),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(182),n2h2(198))
  call Hloop_AZ_Q(ntryL,G1H32(206),wf16(:,165),G1H2(1),ngZd,m3h16x2(:,94),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(183),n2h2(199))
call HGT_raise_alpha_OLR(G1H32(207),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(207),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(207),ex7(:),G1H16(32),m3h2x16(:,42),heltab2x32(:,:,226))
  call Hloop_AZ_Q(ntryL,G1H32(209),wf16(:,165),G1H2(1),ngZd,m3h16x2(:,95),heltab2x32(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(184),n2h2(200))
  call Hloop_AZ_Q(ntryL,G1H32(210),wf16(:,165),G1H2(1),ngZd,m3h16x2(:,96),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(185),n2h2(201))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(1)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(123),G2H2(120),G2H2(117),G2H2(102),G2H2(99) &
    ,G2H2(17),G2H2(12),G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G2H2(125),G2H2(122),G2H2(119),G2H2(104),G2H2(101) &
    ,G2H2(20),G2H2(19),G2H2(15),G2H2(14),G2H2(5),G2H2(4)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G2H2(180),G2H2(177),G2H2(114),G2H2(111),G2H2(108) &
    ,G2H2(105),G2H2(96),G2H2(93),G2H2(90),G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(185),[G2H2(182),G2H2(179),G2H2(116),G2H2(113),G2H2(110) &
    ,G2H2(107),G2H2(98),G2H2(95),G2H2(92),G2H2(10),G2H2(9)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(7)])
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(6)])
call HGT_w2_OLR(G1H4(13),1,1,4)
call HGT_w2_invQ_OLR(G1H4(13),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G2H2(162),G2H2(159),G2H2(156),G2H2(141),G2H2(138) &
    ,G2H2(37),G2H2(32),G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G2H2(164),G2H2(161),G2H2(158),G2H2(143),G2H2(140) &
    ,G2H2(40),G2H2(39),G2H2(35),G2H2(34),G2H2(25),G2H2(24)])
call HGT_w2_OLR(G1H4(16),1,1,4)
call HGT_w2_invQ_OLR(G1H4(16),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G2H2(171),G2H2(168),G2H2(153),G2H2(150),G2H2(147) &
    ,G2H2(144),G2H2(135),G2H2(132),G2H2(129),G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(176),[G2H2(173),G2H2(170),G2H2(155),G2H2(152),G2H2(149) &
    ,G2H2(146),G2H2(137),G2H2(134),G2H2(131),G2H2(30),G2H2(29)])
call HGT_w2_OLR(G1H4(19),1,1,4)
call HGT_w2_invQ_OLR(G1H4(19),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(19)])
call HGT_w2_OLR(G1H4(22),1,1,4)
call HGT_w2_invQ_OLR(G1H4(22),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(74),G2H2(26),G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(56),G2H2(28),G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(86),G2H2(49),G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(62),G2H2(50),G2H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(62),[G2H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G2H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(64),[G2H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(66)])
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(26),mass4set(:,7),  & 
G1H4(1),G1H4(4),G1H4(7),G1H4(10),G1H4(13),4)
  call HG1shiftOLR(G1H4(4),34,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(126),ex7(:),G2tensor(1),m3h2x1(:,13),heltab2x2(:,:,13))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(2),wf4(:,6),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,nMB,G2tensor(3),n2h1(1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(128),ex7(:),G2tensor(5),m3h2x1(:,14),heltab2x2(:,:,14))
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(3),wf4(:,6),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),34,nMB,G2tensor(7),n2h1(2))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(27),mass4set(:,8),  & 
G1H4(16),G1H4(19),G1H4(22),G1H4(2),G1H4(3),4)
  call HG1shiftOLR(G1H4(19),34,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(183),ex7(:),G2tensor(9),m3h2x1(:,15),heltab2x2(:,:,15))
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(5),wf4(:,6),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,nMB,G2tensor(11),n2h1(3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(185),ex7(:),G2tensor(13),m3h2x1(:,16),heltab2x2(:,:,16))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(6),wf4(:,6),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),34,nMB,G2tensor(14),n2h1(4))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(28),mass4set(:,9),  & 
G1H4(5),G1H4(6),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(6),24,4)
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(8),wf4(:,3),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,nMB,G2tensor(15),n2h1(5))
call HGT_w2_OLR(G1H4(9),1,1,4)
call HGT_w2_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,3),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMB,G2tensor(16),n2h1(6))
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(28),mass4set(:,9),  & 
G1H4(8),G1H4(9),G1H4(51),G1H4(52),G1H4(53),4)
  call HG1shiftOLR(G1H4(9),24,4)
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,nMB,G2tensor(17),n2h1(7))
call HGT_w2_OLR(G1H4(12),1,1,4)
call HGT_w2_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(12),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,8),heltab2x4(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMB,G2tensor(18),n2h1(8))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(29),mass4set(:,7),  & 
G1H4(11),G1H4(12),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(12),34,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(165),ex7(:),G2tensor(19),m3h2x1(:,17),heltab2x2(:,:,17))
call HGT_w2_OLR(G1H4(14),1,1,4)
call HGT_w2_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(14),wf4(:,6),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),255,nMB,G2tensor(20),n2h1(9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(167),ex7(:),G2tensor(21),m3h2x1(:,18),heltab2x2(:,:,18))
call HGT_w2_OLR(G1H4(15),1,1,4)
call HGT_w2_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(15),wf4(:,6),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),34,nMB,G2tensor(22),n2h1(10))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(30),mass4set(:,8),  & 
G1H4(14),G1H4(15),G1H4(57),G1H4(58),G1H4(59),4)
  call HG1shiftOLR(G1H4(15),34,4)



end subroutine vamp_1

end module ol_vamp_1_eellllbb_nexnmeeexmxbbx_1_/**/REALKIND
