
module ol_vamp_1_eellllbb_nenexeeexexbbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eellllbb_nenexeeexexbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eellllbb_nenexeeexexbbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eellllbb_nenexeeexexbbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_eellllbb_nenexeeexexbbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eellllbb_nenexeeexexbbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eellllbb_nenexeeexexbbx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(1),h0tab(:,1),[128,20,40,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,21),wf4(:,3) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,1),heltab2x256(:,:,1))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(1),n2h128(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(2),h0tab(:,2),[128,20,40,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,21),wf4(:,10) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,2),heltab2x256(:,:,2))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(2),n2h128(2))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(3),h0tab(:,3),[128,20,40,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,23),wf4(:,3) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,3),heltab2x256(:,:,3))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(3),n2h128(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(4),h0tab(:,4),[128,20,40,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,23),wf4(:,10) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,4),heltab2x256(:,:,4))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(4),n2h128(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(5),h0tab(:,5),[128,40,20,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,3),wf4(:,21) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,5),heltab2x256(:,:,5))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(5),n2h128(5))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(6),h0tab(:,6),[128,40,20,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,10),wf4(:,21) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,6),heltab2x256(:,:,6))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(6),n2h128(6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(7),h0tab(:,7),[128,40,20,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,3),wf4(:,23) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,7),heltab2x256(:,:,7))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(7),n2h128(7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(8),h0tab(:,8),[128,40,20,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,10),wf4(:,23) &
    ,wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,8),heltab2x256(:,:,8))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(8),n2h128(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(9),h0tab(:,9),[128,3,40,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(:,3) &
    ,wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,9),heltab2x256(:,:,9))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(9),n2h128(9))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(10),h0tab(:,10),[128,3,40,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,10),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,10),heltab2x256(:,:,10))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(10),n2h128(10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(11),h0tab(:,11),[128,3,40,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,3),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,11),heltab2x256(:,:,11))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(11),n2h128(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(12),h0tab(:,12),[128,3,40,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,10),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,12),heltab2x256(:,:,12))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(12),n2h128(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(13),h0tab(:,13),[128,40,3,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,3),wf4(: &
    ,25),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,13),heltab2x256(:,:,13))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(13),n2h128(13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(14),h0tab(:,14),[128,40,3,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,10),wf4(: &
    ,25),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,14),heltab2x256(:,:,14))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(14),n2h128(14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(15),h0tab(:,15),[128,40,3,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,3),wf4(: &
    ,25),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,15),heltab2x256(:,:,15))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(15),n2h128(15))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(16),h0tab(:,16),[128,40,3,20,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,10),wf4(: &
    ,25),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,16),heltab2x256(:,:,16))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(16),n2h128(16))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(17),h0tab(:,17),[128,3,20,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,21),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,17),heltab2x256(:,:,17))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(17),n2h128(17))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(18),h0tab(:,18),[128,3,20,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,21),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,18),heltab2x256(:,:,18))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(18),n2h128(18))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(19),h0tab(:,19),[128,3,20,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,23),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,19),heltab2x256(:,:,19))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(19),n2h128(19))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(20),h0tab(:,20),[128,3,20,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,23),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,20),heltab2x256(:,:,20))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(20),n2h128(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4345)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(21),h0tab(:,21),[128,20,3,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,21),wf4(: &
    ,25),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,21),heltab2x256(:,:,21))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(21),n2h128(21))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4346)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(22),h0tab(:,22),[128,20,3,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,21),wf4(: &
    ,25),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,22),heltab2x256(:,:,22))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(22),n2h128(22))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4347)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(23),h0tab(:,23),[128,20,3,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,23),wf4(: &
    ,25),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,23),heltab2x256(:,:,23))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(23),n2h128(23))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4348)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(24),h0tab(:,24),[128,20,3,40,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,23),wf4(: &
    ,25),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,24),heltab2x256(:,:,24))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(24),n2h128(24))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(25),h0tab(:,25),[128,36,24,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,17),wf4(: &
    ,12),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,25),heltab2x256(:,:,25))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(25),n2h128(25))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(26),h0tab(:,26),[128,36,24,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,17),wf4(: &
    ,15),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,26),heltab2x256(:,:,26))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(26),n2h128(26))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(27),h0tab(:,27),[128,36,24,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,20),wf4(: &
    ,12),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,27),heltab2x256(:,:,27))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(27),n2h128(27))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(28),h0tab(:,28),[128,36,24,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,20),wf4(: &
    ,15),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,28),heltab2x256(:,:,28))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(28),n2h128(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(29),h0tab(:,29),[128,24,36,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,12),wf4(: &
    ,17),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,29),heltab2x256(:,:,29))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(29),n2h128(29))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(30),h0tab(:,30),[128,24,36,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,15),wf4(: &
    ,17),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,30),heltab2x256(:,:,30))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(30),n2h128(30))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(31),h0tab(:,31),[128,24,36,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,12),wf4(: &
    ,20),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,31),heltab2x256(:,:,31))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(31),n2h128(31))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(32),h0tab(:,32),[128,24,36,3,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,15),wf4(: &
    ,20),wf4(:,25))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,32),heltab2x256(:,:,32))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(32),n2h128(32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(33),h0tab(:,33),[128,3,24,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,12),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,33),heltab2x256(:,:,33))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(33),n2h128(33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(34),h0tab(:,34),[128,3,24,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,15),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,34),heltab2x256(:,:,34))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(34),n2h128(34))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(35),h0tab(:,35),[128,3,24,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,12),wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,35),heltab2x256(:,:,35))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(35),n2h128(35))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(36),h0tab(:,36),[128,3,24,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,15),wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,36),heltab2x256(:,:,36))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(36),n2h128(36))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(37),h0tab(:,37),[128,24,3,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,12),wf4(: &
    ,25),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,37),heltab2x256(:,:,37))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(37),n2h128(37))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(38),h0tab(:,38),[128,24,3,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,15),wf4(: &
    ,25),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,38),heltab2x256(:,:,38))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(38),n2h128(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(39),h0tab(:,39),[128,24,3,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,12),wf4(: &
    ,25),wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,39),heltab2x256(:,:,39))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(39),n2h128(39))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(40),h0tab(:,40),[128,24,3,36,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,15),wf4(: &
    ,25),wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,40),heltab2x256(:,:,40))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(40),n2h128(40))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(41),h0tab(:,41),[128,3,36,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,17),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,41),heltab2x256(:,:,41))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(41),n2h128(41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(42),h0tab(:,42),[128,3,36,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,17),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,42),heltab2x256(:,:,42))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(42),n2h128(42))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(43),h0tab(:,43),[128,3,36,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,20),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,43),heltab2x256(:,:,43))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(43),n2h128(43))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(44),h0tab(:,44),[128,3,36,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,25),wf4(: &
    ,20),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,44),heltab2x256(:,:,44))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(44),n2h128(44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4499)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(45),h0tab(:,45),[128,36,3,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,17),wf4(: &
    ,25),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,45),heltab2x256(:,:,45))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(45),n2h128(45))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4500)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(46),h0tab(:,46),[128,36,3,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,17),wf4(: &
    ,25),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,46),heltab2x256(:,:,46))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(46),n2h128(46))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4501)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(47),h0tab(:,47),[128,36,3,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,20),wf4(: &
    ,25),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,47),heltab2x256(:,:,47))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(47),n2h128(47))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(48),h0tab(:,48),[128,36,3,24,64],[nMB,nMB,nMB,nMB,0],5,3,wf4(:,20),wf4(: &
    ,25),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,48),heltab2x256(:,:,48))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(48),n2h128(48))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(49),h0tab(:,49),[128,6,40,17,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,6),wf4(:,3) &
    ,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,49),heltab2x256(:,:,49))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(49),n2h128(49))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(50),h0tab(:,50),[128,6,40,17,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,6),wf4(: &
    ,10),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,50),heltab2x256(:,:,50))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(50),n2h128(50))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(51),h0tab(:,51),[128,40,6,17,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,3),wf4(:,6) &
    ,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,51),heltab2x256(:,:,51))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(51),n2h128(51))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(52),h0tab(:,52),[128,40,6,17,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,10),wf4(: &
    ,6),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,52),heltab2x256(:,:,52))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(52),n2h128(52))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(53),h0tab(:,53),[128,6,17,40,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,6),wf4(:,5) &
    ,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,53),heltab2x256(:,:,53))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(53),n2h128(53))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(54),h0tab(:,54),[128,6,17,40,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,6),wf4(:,5) &
    ,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,54),heltab2x256(:,:,54))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(54),n2h128(54))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(55),h0tab(:,55),[128,6,24,33,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,6),wf4(: &
    ,12),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,55),heltab2x256(:,:,55))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(55),n2h128(55))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(56),h0tab(:,56),[128,6,24,33,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,6),wf4(: &
    ,15),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,56),heltab2x256(:,:,56))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(56),n2h128(56))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(57),h0tab(:,57),[128,24,6,33,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,12),wf4(: &
    ,6),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,57),heltab2x256(:,:,57))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(57),n2h128(57))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(58),h0tab(:,58),[128,24,6,33,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,15),wf4(: &
    ,6),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,58),heltab2x256(:,:,58))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(58),n2h128(58))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(59),h0tab(:,59),[128,6,33,24,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,6),wf4(: &
    ,13),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,59),heltab2x256(:,:,59))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(59),n2h128(59))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(60),h0tab(:,60),[128,6,33,24,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,6),wf4(: &
    ,13),wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,60),heltab2x256(:,:,60))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(60),n2h128(60))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(61),h0tab(:,61),[128,10,36,17,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,18),wf4(: &
    ,17),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,61),heltab2x256(:,:,61))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(61),n2h128(61))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(62),h0tab(:,62),[128,10,36,17,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,18),wf4(: &
    ,20),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,62),heltab2x256(:,:,62))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(62),n2h128(62))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(63),h0tab(:,63),[128,36,10,17,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,17),wf4(: &
    ,18),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,63),heltab2x256(:,:,63))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(63),n2h128(63))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(64),h0tab(:,64),[128,36,10,17,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,20),wf4(: &
    ,18),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,64),heltab2x256(:,:,64))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(64),n2h128(64))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(65),h0tab(:,65),[128,10,17,36,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,18),wf4(: &
    ,5),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,65),heltab2x256(:,:,65))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(65),n2h128(65))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(66),h0tab(:,66),[128,10,17,36,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,18),wf4(: &
    ,5),wf4(:,20))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,66),heltab2x256(:,:,66))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(66),n2h128(66))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(67),h0tab(:,67),[128,10,20,33,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,18),wf4(: &
    ,21),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,67),heltab2x256(:,:,67))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(67),n2h128(67))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(68),h0tab(:,68),[128,10,20,33,64],[nMB,nMT,nMT,nMB,0],5,3,wf4(:,18),wf4(: &
    ,23),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,68),heltab2x256(:,:,68))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(68),n2h128(68))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(69),h0tab(:,69),[128,20,10,33,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,21),wf4(: &
    ,18),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,69),heltab2x256(:,:,69))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(69),n2h128(69))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(70),h0tab(:,70),[128,20,10,33,64],[nMB,nMB,nMT,nMB,0],5,3,wf4(:,23),wf4(: &
    ,18),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,70),heltab2x256(:,:,70))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(70),n2h128(70))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(71),h0tab(:,71),[128,10,33,20,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,18),wf4(: &
    ,13),wf4(:,21))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,71),heltab2x256(:,:,71))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(71),n2h128(71))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H256(1),m0h(72),h0tab(:,72),[128,10,33,20,64],[nMB,nMT,nMB,nMB,0],5,3,wf4(:,18),wf4(: &
    ,13),wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H256(1),ex8(:),G0H128(1),m3h2x128(:,72),heltab2x256(:,:,72))
  call Hloop_A_Q(ntryL,G0H128(1),128,nMB,G1H128(72),n2h128(72))
  call Hloop_AV_Q(ntryL,G1H128(1),wf4(:,21),G1H32(1),m3h4x32(:,1),heltab2x128(:,:,1))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(1),n2h32(1))
  call Hloop_AV_Q(ntryL,G1H128(2),wf4(:,21),G1H32(1),m3h4x32(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(2),n2h32(2))
  call Hloop_AZ_Q(ntryL,G1H128(3),wf4(:,23),G1H32(1),ngZd,m3h4x32(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(3),n2h32(3))
  call Hloop_AZ_Q(ntryL,G1H128(4),wf4(:,23),G1H32(1),ngZd,m3h4x32(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(4),n2h32(4))
  call Hloop_AV_Q(ntryL,G1H128(5),wf4(:,3),G1H32(1),m3h4x32(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(5),n2h32(5))
  call Hloop_AZ_Q(ntryL,G1H128(6),wf4(:,10),G1H32(1),ngZd,m3h4x32(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(6),n2h32(6))
  call Hloop_AV_Q(ntryL,G1H128(7),wf4(:,3),G1H32(1),m3h4x32(:,7),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(7),n2h32(7))
  call Hloop_AZ_Q(ntryL,G1H128(8),wf4(:,10),G1H32(1),ngZd,m3h4x32(:,8),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(8),n2h32(8))
  call Hloop_AZ_Q(ntryL,G1H128(9),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(9),n2h32(9))
  call Hloop_AZ_Q(ntryL,G1H128(10),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,10),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(10),n2h32(10))
  call Hloop_AZ_Q(ntryL,G1H128(11),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(11),n2h32(11))
  call Hloop_AZ_Q(ntryL,G1H128(12),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(12),n2h32(12))
  call Hloop_AV_Q(ntryL,G1H128(13),wf4(:,3),G1H32(1),m3h4x32(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(13),n2h32(13))
  call Hloop_AZ_Q(ntryL,G1H128(14),wf4(:,10),G1H32(1),ngZd,m3h4x32(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(14),n2h32(14))
  call Hloop_AV_Q(ntryL,G1H128(15),wf4(:,3),G1H32(1),m3h4x32(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(15),n2h32(15))
  call Hloop_AZ_Q(ntryL,G1H128(16),wf4(:,10),G1H32(1),ngZd,m3h4x32(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(16),n2h32(16))
  call Hloop_AZ_Q(ntryL,G1H128(17),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(17),n2h32(17))
  call Hloop_AZ_Q(ntryL,G1H128(18),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(18),n2h32(18))
  call Hloop_AZ_Q(ntryL,G1H128(19),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,19),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(19),n2h32(19))
  call Hloop_AZ_Q(ntryL,G1H128(20),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,20),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(20),n2h32(20))
  call Hloop_AV_Q(ntryL,G1H128(21),wf4(:,21),G1H32(1),m3h4x32(:,21),heltab2x128(:,:,21))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(21),n2h32(21))
  call Hloop_AV_Q(ntryL,G1H128(22),wf4(:,21),G1H32(1),m3h4x32(:,22),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(22),n2h32(22))
  call Hloop_AZ_Q(ntryL,G1H128(23),wf4(:,23),G1H32(1),ngZd,m3h4x32(:,23),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(23),n2h32(23))
  call Hloop_AZ_Q(ntryL,G1H128(24),wf4(:,23),G1H32(1),ngZd,m3h4x32(:,24),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(24),n2h32(24))
  call Hloop_AV_Q(ntryL,G1H128(25),wf4(:,17),G1H32(1),m3h4x32(:,25),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(25),n2h32(25))
  call Hloop_AV_Q(ntryL,G1H128(26),wf4(:,17),G1H32(1),m3h4x32(:,26),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(26),n2h32(26))
  call Hloop_AZ_Q(ntryL,G1H128(27),wf4(:,20),G1H32(1),ngZd,m3h4x32(:,27),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(27),n2h32(27))
  call Hloop_AZ_Q(ntryL,G1H128(28),wf4(:,20),G1H32(1),ngZd,m3h4x32(:,28),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(28),n2h32(28))
  call Hloop_AV_Q(ntryL,G1H128(29),wf4(:,12),G1H32(1),m3h4x32(:,29),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(29),n2h32(29))
  call Hloop_AZ_Q(ntryL,G1H128(30),wf4(:,15),G1H32(1),ngZd,m3h4x32(:,30),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(30),n2h32(30))
  call Hloop_AV_Q(ntryL,G1H128(31),wf4(:,12),G1H32(1),m3h4x32(:,31),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(31),n2h32(31))
  call Hloop_AZ_Q(ntryL,G1H128(32),wf4(:,15),G1H32(1),ngZd,m3h4x32(:,32),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(32),n2h32(32))
  call Hloop_AZ_Q(ntryL,G1H128(33),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,33),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(33),n2h32(33))
  call Hloop_AZ_Q(ntryL,G1H128(34),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,34),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(34),n2h32(34))
  call Hloop_AZ_Q(ntryL,G1H128(35),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,35),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(35),n2h32(35))
  call Hloop_AZ_Q(ntryL,G1H128(36),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,36),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(36),n2h32(36))
  call Hloop_AV_Q(ntryL,G1H128(37),wf4(:,12),G1H32(1),m3h4x32(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(37),n2h32(37))
  call Hloop_AZ_Q(ntryL,G1H128(38),wf4(:,15),G1H32(1),ngZd,m3h4x32(:,38),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(38),n2h32(38))
  call Hloop_AV_Q(ntryL,G1H128(39),wf4(:,12),G1H32(1),m3h4x32(:,39),heltab2x128(:,:,39))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(39),n2h32(39))
  call Hloop_AZ_Q(ntryL,G1H128(40),wf4(:,15),G1H32(1),ngZd,m3h4x32(:,40),heltab2x128(:,:,40))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(40),n2h32(40))
  call Hloop_AZ_Q(ntryL,G1H128(41),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,41),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(41),n2h32(41))
  call Hloop_AZ_Q(ntryL,G1H128(42),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,42),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(42),n2h32(42))
  call Hloop_AZ_Q(ntryL,G1H128(43),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,43),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(43),n2h32(43))
  call Hloop_AZ_Q(ntryL,G1H128(44),wf4(:,25),G1H32(1),ngZd,m3h4x32(:,44),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G1H32(1),131,nMB,G2H32(44),n2h32(44))
  call Hloop_AV_Q(ntryL,G1H128(45),wf4(:,17),G1H32(1),m3h4x32(:,45),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(45),n2h32(45))
  call Hloop_AV_Q(ntryL,G1H128(46),wf4(:,17),G1H32(1),m3h4x32(:,46),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(46),n2h32(46))
  call Hloop_AZ_Q(ntryL,G1H128(47),wf4(:,20),G1H32(1),ngZd,m3h4x32(:,47),heltab2x128(:,:,47))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(47),n2h32(47))
  call Hloop_AZ_Q(ntryL,G1H128(48),wf4(:,20),G1H32(1),ngZd,m3h4x32(:,48),heltab2x128(:,:,48))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(48),n2h32(48))
  call Hloop_AW_Q(ntryL,G1H128(49),wf4(:,6),G1H32(1),m3h4x32(:,49),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(49),n2h32(49))
  call Hloop_AW_Q(ntryL,G1H128(50),wf4(:,6),G1H32(1),m3h4x32(:,50),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(50),n2h32(50))
  call Hloop_AV_Q(ntryL,G1H128(51),wf4(:,3),G1H32(1),m3h4x32(:,51),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(51),n2h32(51))
  call Hloop_AZ_Q(ntryL,G1H128(52),wf4(:,10),G1H32(1),ngZd,m3h4x32(:,52),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G1H32(1),168,nMB,G2H32(52),n2h32(52))
  call Hloop_AW_Q(ntryL,G1H128(53),wf4(:,6),G1H32(1),m3h4x32(:,53),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(53),n2h32(53))
  call Hloop_AW_Q(ntryL,G1H128(54),wf4(:,6),G1H32(1),m3h4x32(:,54),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(54),n2h32(54))
  call Hloop_AW_Q(ntryL,G1H128(55),wf4(:,6),G1H32(1),m3h4x32(:,55),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(55),n2h32(55))
  call Hloop_AW_Q(ntryL,G1H128(56),wf4(:,6),G1H32(1),m3h4x32(:,56),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(56),n2h32(56))
  call Hloop_AV_Q(ntryL,G1H128(57),wf4(:,12),G1H32(1),m3h4x32(:,57),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(57),n2h32(57))
  call Hloop_AZ_Q(ntryL,G1H128(58),wf4(:,15),G1H32(1),ngZd,m3h4x32(:,58),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G1H32(1),152,nMB,G2H32(58),n2h32(58))
  call Hloop_AW_Q(ntryL,G1H128(59),wf4(:,6),G1H32(1),m3h4x32(:,59),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(59),n2h32(59))
  call Hloop_AW_Q(ntryL,G1H128(60),wf4(:,6),G1H32(1),m3h4x32(:,60),heltab2x128(:,:,60))
  call Hloop_A_Q(ntryL,G1H32(1),134,nMT,G2H32(60),n2h32(60))
  call Hloop_AW_Q(ntryL,G1H128(61),wf4(:,18),G1H32(1),m3h4x32(:,61),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(61),n2h32(61))
  call Hloop_AW_Q(ntryL,G1H128(62),wf4(:,18),G1H32(1),m3h4x32(:,62),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(62),n2h32(62))
  call Hloop_AV_Q(ntryL,G1H128(63),wf4(:,17),G1H32(1),m3h4x32(:,63),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(63),n2h32(63))
  call Hloop_AZ_Q(ntryL,G1H128(64),wf4(:,20),G1H32(1),ngZd,m3h4x32(:,64),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G1H32(1),164,nMB,G2H32(64),n2h32(64))
  call Hloop_AW_Q(ntryL,G1H128(65),wf4(:,18),G1H32(1),m3h4x32(:,65),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(65),n2h32(65))
  call Hloop_AW_Q(ntryL,G1H128(66),wf4(:,18),G1H32(1),m3h4x32(:,66),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(66),n2h32(66))
  call Hloop_AW_Q(ntryL,G1H128(67),wf4(:,18),G1H32(1),m3h4x32(:,67),heltab2x128(:,:,67))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(67),n2h32(67))
  call Hloop_AW_Q(ntryL,G1H128(68),wf4(:,18),G1H32(1),m3h4x32(:,68),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(68),n2h32(68))
  call Hloop_AV_Q(ntryL,G1H128(69),wf4(:,21),G1H32(1),m3h4x32(:,69),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(69),n2h32(69))
  call Hloop_AZ_Q(ntryL,G1H128(70),wf4(:,23),G1H32(1),ngZd,m3h4x32(:,70),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G1H32(1),148,nMB,G2H32(70),n2h32(70))
  call Hloop_AW_Q(ntryL,G1H128(71),wf4(:,18),G1H32(1),m3h4x32(:,71),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(71),n2h32(71))
  call Hloop_AW_Q(ntryL,G1H128(72),wf4(:,18),G1H32(1),m3h4x32(:,72),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G1H32(1),138,nMT,G2H32(72),n2h32(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(3),[G2H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(4),[G2H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(6),[G2H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(8),[G2H32(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(14),[G2H32(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(16),[G2H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(23),[G2H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(24),[G2H32(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(27),[G2H32(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(28),[G2H32(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(30),[G2H32(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(32),[G2H32(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(38),[G2H32(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(40),[G2H32(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(47),[G2H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(48),[G2H32(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(52),[G2H32(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(58),[G2H32(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(64),[G2H32(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H32(70),[G2H32(69)])
  call Hotf_5pt_reduction(G2H32(3),RedSet_5(1),mass5set(:,1),  & 
G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(5),G1H32(6),32)
  call HG1shiftOLR(G1H32(2),64,32)
  call Hotf_5pt_reduction(G2H32(4),RedSet_5(1),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
  call HG1shiftOLR(G1H32(8),64,32)
  call Hotf_5pt_reduction(G2H32(6),RedSet_5(2),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
  call HG1shiftOLR(G1H32(14),64,32)
  call Hotf_5pt_reduction(G2H32(8),RedSet_5(2),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
  call HG1shiftOLR(G1H32(20),64,32)
  call Hotf_5pt_reduction(G2H32(9),RedSet_5(3),mass5set(:,1),  & 
G1H32(25),G1H32(26),G1H32(27),G1H32(28),G1H32(29),G1H32(30),32)
  call HG1shiftOLR(G1H32(26),64,32)
  call Hotf_5pt_reduction(G2H32(10),RedSet_5(3),mass5set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
  call HG1shiftOLR(G1H32(32),64,32)
  call Hotf_5pt_reduction(G2H32(11),RedSet_5(3),mass5set(:,1),  & 
G1H32(37),G1H32(38),G1H32(39),G1H32(40),G1H32(41),G1H32(42),32)
  call HG1shiftOLR(G1H32(38),64,32)
  call Hotf_5pt_reduction(G2H32(12),RedSet_5(3),mass5set(:,1),  & 
G1H32(43),G1H32(44),G1H32(45),G1H32(46),G1H32(47),G1H32(48),32)
  call HG1shiftOLR(G1H32(44),64,32)
  call Hotf_5pt_reduction(G2H32(14),RedSet_5(4),mass5set(:,1),  & 
G1H32(49),G1H32(50),G1H32(51),G1H32(52),G1H32(53),G1H32(54),32)
  call HG1shiftOLR(G1H32(50),64,32)
  call Hotf_5pt_reduction(G2H32(16),RedSet_5(4),mass5set(:,1),  & 
G1H32(55),G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
  call HG1shiftOLR(G1H32(56),64,32)
  call Hotf_5pt_reduction(G2H32(17),RedSet_5(5),mass5set(:,1),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),G1H32(66),32)
  call HG1shiftOLR(G1H32(62),64,32)
  call Hotf_5pt_reduction(G2H32(18),RedSet_5(5),mass5set(:,1),  & 
G1H32(67),G1H32(68),G1H32(69),G1H32(70),G1H32(71),G1H32(72),32)
  call HG1shiftOLR(G1H32(68),64,32)
  call Hotf_5pt_reduction(G2H32(19),RedSet_5(5),mass5set(:,1),  & 
G1H32(73),G1H32(74),G1H32(75),G1H32(76),G1H32(77),G1H32(78),32)
  call HG1shiftOLR(G1H32(74),64,32)
  call Hotf_5pt_reduction(G2H32(20),RedSet_5(5),mass5set(:,1),  & 
G1H32(79),G1H32(80),G1H32(81),G1H32(82),G1H32(83),G1H32(84),32)
  call HG1shiftOLR(G1H32(80),64,32)
  call Hotf_5pt_reduction(G2H32(23),RedSet_5(6),mass5set(:,1),  & 
G1H32(85),G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
  call HG1shiftOLR(G1H32(86),64,32)
  call Hotf_5pt_reduction(G2H32(24),RedSet_5(6),mass5set(:,1),  & 
G1H32(91),G1H32(92),G1H32(93),G1H32(94),G1H32(95),G1H32(96),32)
  call HG1shiftOLR(G1H32(92),64,32)
  call Hotf_5pt_reduction(G2H32(27),RedSet_5(7),mass5set(:,1),  & 
G1H32(97),G1H32(98),G1H32(99),G1H32(100),G1H32(101),G1H32(102),32)
  call HG1shiftOLR(G1H32(98),64,32)
  call Hotf_5pt_reduction(G2H32(28),RedSet_5(7),mass5set(:,1),  & 
G1H32(103),G1H32(104),G1H32(105),G1H32(106),G1H32(107),G1H32(108),32)
  call HG1shiftOLR(G1H32(104),64,32)
  call Hotf_5pt_reduction(G2H32(30),RedSet_5(8),mass5set(:,1),  & 
G1H32(109),G1H32(110),G1H32(111),G1H32(112),G1H32(113),G1H32(114),32)
  call HG1shiftOLR(G1H32(110),64,32)
  call Hotf_5pt_reduction(G2H32(32),RedSet_5(8),mass5set(:,1),  & 
G1H32(115),G1H32(116),G1H32(117),G1H32(118),G1H32(119),G1H32(120),32)
  call HG1shiftOLR(G1H32(116),64,32)
  call Hotf_5pt_reduction(G2H32(33),RedSet_5(9),mass5set(:,1),  & 
G1H32(121),G1H32(122),G1H32(123),G1H32(124),G1H32(125),G1H32(126),32)
  call HG1shiftOLR(G1H32(122),64,32)
  call Hotf_5pt_reduction(G2H32(34),RedSet_5(9),mass5set(:,1),  & 
G1H32(127),G1H32(128),G1H32(129),G1H32(130),G1H32(131),G1H32(132),32)
  call HG1shiftOLR(G1H32(128),64,32)
  call Hotf_5pt_reduction(G2H32(35),RedSet_5(9),mass5set(:,1),  & 
G1H32(133),G1H32(134),G1H32(135),G1H32(136),G1H32(137),G1H32(138),32)
  call HG1shiftOLR(G1H32(134),64,32)
  call Hotf_5pt_reduction(G2H32(36),RedSet_5(9),mass5set(:,1),  & 
G1H32(139),G1H32(140),G1H32(141),G1H32(142),G1H32(143),G1H32(144),32)
  call HG1shiftOLR(G1H32(140),64,32)
  call Hotf_5pt_reduction(G2H32(38),RedSet_5(10),mass5set(:,1),  & 
G1H32(145),G1H32(146),G1H32(147),G1H32(148),G1H32(149),G1H32(150),32)
  call HG1shiftOLR(G1H32(146),64,32)
  call Hotf_5pt_reduction(G2H32(40),RedSet_5(10),mass5set(:,1),  & 
G1H32(151),G1H32(152),G1H32(153),G1H32(154),G1H32(155),G1H32(156),32)
  call HG1shiftOLR(G1H32(152),64,32)
  call Hotf_5pt_reduction(G2H32(41),RedSet_5(11),mass5set(:,1),  & 
G1H32(157),G1H32(158),G1H32(159),G1H32(160),G1H32(161),G1H32(162),32)
  call HG1shiftOLR(G1H32(158),64,32)
  call Hotf_5pt_reduction(G2H32(42),RedSet_5(11),mass5set(:,1),  & 
G1H32(163),G1H32(164),G1H32(165),G1H32(166),G1H32(167),G1H32(168),32)
  call HG1shiftOLR(G1H32(164),64,32)
  call Hotf_5pt_reduction(G2H32(43),RedSet_5(11),mass5set(:,1),  & 
G1H32(169),G1H32(170),G1H32(171),G1H32(172),G1H32(173),G1H32(174),32)
  call HG1shiftOLR(G1H32(170),64,32)
  call Hotf_5pt_reduction(G2H32(44),RedSet_5(11),mass5set(:,1),  & 
G1H32(175),G1H32(176),G1H32(177),G1H32(178),G1H32(179),G1H32(180),32)
  call HG1shiftOLR(G1H32(176),64,32)
  call Hotf_5pt_reduction(G2H32(47),RedSet_5(12),mass5set(:,1),  & 
G1H32(181),G1H32(182),G1H32(183),G1H32(184),G1H32(185),G1H32(186),32)
  call HG1shiftOLR(G1H32(182),64,32)
  call Hotf_5pt_reduction(G2H32(48),RedSet_5(12),mass5set(:,1),  & 
G1H32(187),G1H32(188),G1H32(189),G1H32(190),G1H32(191),G1H32(192),32)
  call HG1shiftOLR(G1H32(188),64,32)
  call Hotf_5pt_reduction(G2H32(49),RedSet_5(13),mass5set(:,2),  & 
G1H32(193),G1H32(194),G1H32(195),G1H32(196),G1H32(197),G1H32(198),32)
  call HG1shiftOLR(G1H32(194),64,32)
  call Hotf_5pt_reduction(G2H32(50),RedSet_5(13),mass5set(:,2),  & 
G1H32(199),G1H32(200),G1H32(201),G1H32(202),G1H32(203),G1H32(204),32)
  call HG1shiftOLR(G1H32(200),64,32)
  call Hotf_5pt_reduction(G2H32(52),RedSet_5(14),mass5set(:,3),  & 
G1H32(205),G1H32(206),G1H32(207),G1H32(208),G1H32(209),G1H32(210),32)
  call HG1shiftOLR(G1H32(206),64,32)
  call Hotf_5pt_reduction(G2H32(53),RedSet_5(15),mass5set(:,4),  & 
G1H32(211),G1H32(212),G1H32(213),G1H32(214),G1H32(215),G1H32(216),32)
  call HG1shiftOLR(G1H32(212),64,32)
  call Hotf_5pt_reduction(G2H32(54),RedSet_5(15),mass5set(:,4),  & 
G1H32(217),G1H32(218),G1H32(219),G1H32(220),G1H32(221),G1H32(222),32)
  call HG1shiftOLR(G1H32(218),64,32)
  call Hotf_5pt_reduction(G2H32(55),RedSet_5(16),mass5set(:,2),  & 
G1H32(223),G1H32(224),G1H32(225),G1H32(226),G1H32(227),G1H32(228),32)
  call HG1shiftOLR(G1H32(224),64,32)
  call Hotf_5pt_reduction(G2H32(56),RedSet_5(16),mass5set(:,2),  & 
G1H32(229),G1H32(230),G1H32(231),G1H32(232),G1H32(233),G1H32(234),32)
  call HG1shiftOLR(G1H32(230),64,32)
  call Hotf_5pt_reduction(G2H32(58),RedSet_5(17),mass5set(:,3),  & 
G1H32(235),G1H32(236),G1H32(237),G1H32(238),G1H32(239),G1H32(240),32)
  call HG1shiftOLR(G1H32(236),64,32)
  call Hotf_5pt_reduction(G2H32(59),RedSet_5(18),mass5set(:,4),  & 
G1H32(241),G1H32(242),G1H32(243),G1H32(244),G1H32(245),G1H32(246),32)
  call HG1shiftOLR(G1H32(242),64,32)
  call Hotf_5pt_reduction(G2H32(60),RedSet_5(18),mass5set(:,4),  & 
G1H32(247),G1H32(248),G1H32(249),G1H32(250),G1H32(251),G1H32(252),32)
  call HG1shiftOLR(G1H32(248),64,32)
  call Hotf_5pt_reduction(G2H32(61),RedSet_5(19),mass5set(:,2),  & 
G1H32(253),G1H32(254),G1H32(255),G1H32(256),G1H32(257),G1H32(258),32)
  call HG1shiftOLR(G1H32(254),64,32)
  call Hotf_5pt_reduction(G2H32(62),RedSet_5(19),mass5set(:,2),  & 
G1H32(259),G1H32(260),G1H32(261),G1H32(262),G1H32(263),G1H32(264),32)
  call HG1shiftOLR(G1H32(260),64,32)
  call Hotf_5pt_reduction(G2H32(64),RedSet_5(20),mass5set(:,3),  & 
G1H32(265),G1H32(266),G1H32(267),G1H32(268),G1H32(269),G1H32(270),32)
  call HG1shiftOLR(G1H32(266),64,32)
  call Hotf_5pt_reduction(G2H32(65),RedSet_5(21),mass5set(:,4),  & 
G1H32(271),G1H32(272),G1H32(273),G1H32(274),G1H32(275),G1H32(276),32)
  call HG1shiftOLR(G1H32(272),64,32)
  call Hotf_5pt_reduction(G2H32(66),RedSet_5(21),mass5set(:,4),  & 
G1H32(277),G1H32(278),G1H32(279),G1H32(280),G1H32(281),G1H32(282),32)
  call HG1shiftOLR(G1H32(278),64,32)
  call Hotf_5pt_reduction(G2H32(67),RedSet_5(22),mass5set(:,2),  & 
G1H32(283),G1H32(284),G1H32(285),G1H32(286),G1H32(287),G1H32(288),32)
  call HG1shiftOLR(G1H32(284),64,32)
  call Hotf_5pt_reduction(G2H32(68),RedSet_5(22),mass5set(:,2),  & 
G1H32(289),G1H32(290),G1H32(291),G1H32(292),G1H32(293),G1H32(294),32)
  call HG1shiftOLR(G1H32(290),64,32)
  call Hotf_5pt_reduction(G2H32(70),RedSet_5(23),mass5set(:,3),  & 
G1H32(295),G1H32(296),G1H32(297),G1H32(298),G1H32(299),G1H32(300),32)
  call HG1shiftOLR(G1H32(296),64,32)
  call Hotf_5pt_reduction(G2H32(71),RedSet_5(24),mass5set(:,4),  & 
G1H32(301),G1H32(302),G1H32(303),G1H32(304),G1H32(305),G1H32(306),32)
  call HG1shiftOLR(G1H32(302),64,32)
  call Hotf_5pt_reduction(G2H32(72),RedSet_5(24),mass5set(:,4),  & 
G1H32(307),G1H32(308),G1H32(309),G1H32(310),G1H32(311),G1H32(312),32)
  call HG1shiftOLR(G1H32(308),64,32)
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,3),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(1),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(2),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(2),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(2),ex7(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,2))
  call Hloop_AV_Q(ntryL,G1H32(4),wf4(:,3),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,3),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(3),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H32(6),wf4(:,3),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(4),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,5),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(5),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(8),ex7(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,7))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(8),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,21),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(9),n2h8(9))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(14),ex7(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,12))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,21),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(10),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H32(17),wf4(:,21),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(11),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H32(18),wf4(:,21),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(12),n2h8(12))
  call Hloop_AZ_Q(ntryL,G1H32(19),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,13),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(13),n2h8(13))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(20),ex7(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,17))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,14),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(14),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H32(23),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(15),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H32(24),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,16),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(16),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H32(25),wf4(:,3),G1H8(1),m3h4x8(:,17),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(17),n2h8(17))
call HGT_raise_alpha_OLR(G1H32(26),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(26),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(26),ex7(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,22))
  call Hloop_AV_Q(ntryL,G1H32(28),wf4(:,3),G1H8(1),m3h4x8(:,18),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(18),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H32(29),wf4(:,3),G1H8(1),m3h4x8(:,19),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(19),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H32(30),wf4(:,3),G1H8(1),m3h4x8(:,20),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(20),n2h8(20))
  call Hloop_AZ_Q(ntryL,G1H32(31),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,21),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(21),n2h8(21))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(32),ex7(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,27))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,22),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(22),n2h8(22))
  call Hloop_AZ_Q(ntryL,G1H32(35),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,23),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(23),n2h8(23))
  call Hloop_AZ_Q(ntryL,G1H32(36),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,24),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(24),n2h8(24))
  call Hloop_AV_Q(ntryL,G1H32(37),wf4(:,3),G1H8(1),m3h4x8(:,25),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(25),n2h8(25))
call HGT_raise_alpha_OLR(G1H32(38),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(38),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(38),ex7(:),G1H16(7),m3h2x16(:,7),heltab2x32(:,:,32))
  call Hloop_AV_Q(ntryL,G1H32(40),wf4(:,3),G1H8(1),m3h4x8(:,26),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(26),n2h8(26))
  call Hloop_AV_Q(ntryL,G1H32(41),wf4(:,3),G1H8(1),m3h4x8(:,27),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(27),n2h8(27))
  call Hloop_AV_Q(ntryL,G1H32(42),wf4(:,3),G1H8(1),m3h4x8(:,28),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(28),n2h8(28))
  call Hloop_AZ_Q(ntryL,G1H32(43),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,29),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(29),n2h8(29))
call HGT_raise_alpha_OLR(G1H32(44),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(44),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(44),ex7(:),G1H16(8),m3h2x16(:,8),heltab2x32(:,:,37))
  call Hloop_AZ_Q(ntryL,G1H32(46),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,30),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(30),n2h8(30))
  call Hloop_AZ_Q(ntryL,G1H32(47),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,31),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(31),n2h8(31))
  call Hloop_AZ_Q(ntryL,G1H32(48),wf4(:,10),G1H8(1),ngZd,m3h4x8(:,32),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(32),n2h8(32))
  call Hloop_AZ_Q(ntryL,G1H32(49),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,33),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(33),n2h8(33))
call HGT_raise_alpha_OLR(G1H32(50),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(50),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(50),ex7(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,42))
  call Hloop_AZ_Q(ntryL,G1H32(52),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,34),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(34),n2h8(34))
  call Hloop_AZ_Q(ntryL,G1H32(53),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,35),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(35),n2h8(35))
  call Hloop_AZ_Q(ntryL,G1H32(54),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,36),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(36),n2h8(36))
  call Hloop_AZ_Q(ntryL,G1H32(55),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,37),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(37),n2h8(37))
call HGT_raise_alpha_OLR(G1H32(56),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(56),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(56),ex7(:),G1H16(10),m3h2x16(:,10),heltab2x32(:,:,47))
  call Hloop_AZ_Q(ntryL,G1H32(58),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,38),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(38),n2h8(38))
  call Hloop_AZ_Q(ntryL,G1H32(59),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,39),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(39),n2h8(39))
  call Hloop_AZ_Q(ntryL,G1H32(60),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,40),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(40),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H32(61),wf4(:,21),G1H8(1),m3h4x8(:,41),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(41),n2h8(41))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(62),ex7(:),G1H16(11),m3h2x16(:,11),heltab2x32(:,:,52))
  call Hloop_AV_Q(ntryL,G1H32(64),wf4(:,21),G1H8(1),m3h4x8(:,42),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(42),n2h8(42))
  call Hloop_AV_Q(ntryL,G1H32(65),wf4(:,21),G1H8(1),m3h4x8(:,43),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(43),n2h8(43))
  call Hloop_AV_Q(ntryL,G1H32(66),wf4(:,21),G1H8(1),m3h4x8(:,44),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(44),n2h8(44))
  call Hloop_AV_Q(ntryL,G1H32(67),wf4(:,21),G1H8(1),m3h4x8(:,45),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(45),n2h8(45))
call HGT_raise_alpha_OLR(G1H32(68),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(68),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(68),ex7(:),G1H16(12),m3h2x16(:,12),heltab2x32(:,:,57))
  call Hloop_AV_Q(ntryL,G1H32(70),wf4(:,21),G1H8(1),m3h4x8(:,46),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(46),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H32(71),wf4(:,21),G1H8(1),m3h4x8(:,47),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(47),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H32(72),wf4(:,21),G1H8(1),m3h4x8(:,48),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(48),n2h8(48))
  call Hloop_AZ_Q(ntryL,G1H32(73),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,49),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(49),n2h8(49))
call HGT_raise_alpha_OLR(G1H32(74),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(74),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(74),ex7(:),G1H16(13),m3h2x16(:,13),heltab2x32(:,:,62))
  call Hloop_AZ_Q(ntryL,G1H32(76),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,50),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(50),n2h8(50))
  call Hloop_AZ_Q(ntryL,G1H32(77),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,51),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(51),n2h8(51))
  call Hloop_AZ_Q(ntryL,G1H32(78),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,52),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(52),n2h8(52))
  call Hloop_AZ_Q(ntryL,G1H32(79),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,53),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(53),n2h8(53))
call HGT_raise_alpha_OLR(G1H32(80),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(80),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(80),ex7(:),G1H16(14),m3h2x16(:,14),heltab2x32(:,:,67))
  call Hloop_AZ_Q(ntryL,G1H32(82),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,54),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(54),n2h8(54))
  call Hloop_AZ_Q(ntryL,G1H32(83),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,55),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(55),n2h8(55))
  call Hloop_AZ_Q(ntryL,G1H32(84),wf4(:,23),G1H8(1),ngZd,m3h4x8(:,56),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(56),n2h8(56))
  call Hloop_AZ_Q(ntryL,G1H32(85),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,57),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(57),n2h8(57))
call HGT_raise_alpha_OLR(G1H32(86),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(86),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(86),ex7(:),G1H16(15),m3h2x16(:,15),heltab2x32(:,:,72))
  call Hloop_AZ_Q(ntryL,G1H32(88),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,58),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(58),n2h8(58))
  call Hloop_AZ_Q(ntryL,G1H32(89),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,59),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(59),n2h8(59))
  call Hloop_AZ_Q(ntryL,G1H32(90),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,60),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(60),n2h8(60))
  call Hloop_AZ_Q(ntryL,G1H32(91),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,61),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(61),n2h8(61))
call HGT_raise_alpha_OLR(G1H32(92),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(92),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(92),ex7(:),G1H16(16),m3h2x16(:,16),heltab2x32(:,:,77))
  call Hloop_AZ_Q(ntryL,G1H32(94),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,62),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(62),n2h8(62))
  call Hloop_AZ_Q(ntryL,G1H32(95),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,63),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(63),n2h8(63))
  call Hloop_AZ_Q(ntryL,G1H32(96),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,64),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(64),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H32(97),wf4(:,12),G1H8(1),m3h4x8(:,65),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(65),n2h8(65))
call HGT_raise_alpha_OLR(G1H32(98),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(98),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(98),ex7(:),G1H16(17),m3h2x16(:,17),heltab2x32(:,:,82))
  call Hloop_AV_Q(ntryL,G1H32(100),wf4(:,12),G1H8(1),m3h4x8(:,66),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(66),n2h8(66))
  call Hloop_AV_Q(ntryL,G1H32(101),wf4(:,12),G1H8(1),m3h4x8(:,67),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(67),n2h8(67))
  call Hloop_AV_Q(ntryL,G1H32(102),wf4(:,12),G1H8(1),m3h4x8(:,68),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(68),n2h8(68))
  call Hloop_AZ_Q(ntryL,G1H32(103),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,69),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(69),n2h8(69))
call HGT_raise_alpha_OLR(G1H32(104),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(104),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(104),ex7(:),G1H16(18),m3h2x16(:,18),heltab2x32(:,:,87))
  call Hloop_AZ_Q(ntryL,G1H32(106),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,70),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(70),n2h8(70))
  call Hloop_AZ_Q(ntryL,G1H32(107),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,71),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(71),n2h8(71))
  call Hloop_AZ_Q(ntryL,G1H32(108),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,72),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(72),n2h8(72))
  call Hloop_AV_Q(ntryL,G1H32(109),wf4(:,17),G1H8(1),m3h4x8(:,73),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(73),n2h8(73))
call HGT_raise_alpha_OLR(G1H32(110),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(110),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(110),ex7(:),G1H16(19),m3h2x16(:,19),heltab2x32(:,:,92))
  call Hloop_AV_Q(ntryL,G1H32(112),wf4(:,17),G1H8(1),m3h4x8(:,74),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(74),n2h8(74))
  call Hloop_AV_Q(ntryL,G1H32(113),wf4(:,17),G1H8(1),m3h4x8(:,75),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(75),n2h8(75))
  call Hloop_AV_Q(ntryL,G1H32(114),wf4(:,17),G1H8(1),m3h4x8(:,76),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(76),n2h8(76))
  call Hloop_AZ_Q(ntryL,G1H32(115),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,77),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(77),n2h8(77))
call HGT_raise_alpha_OLR(G1H32(116),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(116),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(116),ex7(:),G1H16(20),m3h2x16(:,20),heltab2x32(:,:,97))
  call Hloop_AZ_Q(ntryL,G1H32(118),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,78),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(78),n2h8(78))
  call Hloop_AZ_Q(ntryL,G1H32(119),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,79),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(79),n2h8(79))
  call Hloop_AZ_Q(ntryL,G1H32(120),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,80),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(1),188,nMB,G2H8(80),n2h8(80))
  call Hloop_AV_Q(ntryL,G1H32(121),wf4(:,12),G1H8(1),m3h4x8(:,81),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(81),n2h8(81))
call HGT_raise_alpha_OLR(G1H32(122),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(122),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(122),ex7(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,102))
  call Hloop_AV_Q(ntryL,G1H32(124),wf4(:,12),G1H8(1),m3h4x8(:,82),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(82),n2h8(82))
  call Hloop_AV_Q(ntryL,G1H32(125),wf4(:,12),G1H8(1),m3h4x8(:,83),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(83),n2h8(83))
  call Hloop_AV_Q(ntryL,G1H32(126),wf4(:,12),G1H8(1),m3h4x8(:,84),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(84),n2h8(84))
  call Hloop_AZ_Q(ntryL,G1H32(127),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,85),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(85),n2h8(85))
call HGT_raise_alpha_OLR(G1H32(128),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(128),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(128),ex7(:),G1H16(22),m3h2x16(:,22),heltab2x32(:,:,107))
  call Hloop_AZ_Q(ntryL,G1H32(130),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,86),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(86),n2h8(86))
  call Hloop_AZ_Q(ntryL,G1H32(131),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,87),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(87),n2h8(87))
  call Hloop_AZ_Q(ntryL,G1H32(132),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,88),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(88),n2h8(88))
  call Hloop_AV_Q(ntryL,G1H32(133),wf4(:,12),G1H8(1),m3h4x8(:,89),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(89),n2h8(89))
call HGT_raise_alpha_OLR(G1H32(134),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(134),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(134),ex7(:),G1H16(23),m3h2x16(:,23),heltab2x32(:,:,112))
  call Hloop_AV_Q(ntryL,G1H32(136),wf4(:,12),G1H8(1),m3h4x8(:,90),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(90),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H32(137),wf4(:,12),G1H8(1),m3h4x8(:,91),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(91),n2h8(91))
  call Hloop_AV_Q(ntryL,G1H32(138),wf4(:,12),G1H8(1),m3h4x8(:,92),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(92),n2h8(92))
  call Hloop_AZ_Q(ntryL,G1H32(139),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,93),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(93),n2h8(93))
call HGT_raise_alpha_OLR(G1H32(140),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(140),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(140),ex7(:),G1H16(24),m3h2x16(:,24),heltab2x32(:,:,117))
  call Hloop_AZ_Q(ntryL,G1H32(142),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,94),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(94),n2h8(94))
  call Hloop_AZ_Q(ntryL,G1H32(143),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,95),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(95),n2h8(95))
  call Hloop_AZ_Q(ntryL,G1H32(144),wf4(:,15),G1H8(1),ngZd,m3h4x8(:,96),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(96),n2h8(96))
  call Hloop_AZ_Q(ntryL,G1H32(145),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,97),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(97),n2h8(97))
call HGT_raise_alpha_OLR(G1H32(146),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(146),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(146),ex7(:),G1H16(25),m3h2x16(:,25),heltab2x32(:,:,122))
  call Hloop_AZ_Q(ntryL,G1H32(148),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,98),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(98),n2h8(98))
  call Hloop_AZ_Q(ntryL,G1H32(149),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,99),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(99),n2h8(99))
  call Hloop_AZ_Q(ntryL,G1H32(150),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,100),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(100),n2h8(100))
  call Hloop_AZ_Q(ntryL,G1H32(151),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,101),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(101),n2h8(101))
call HGT_raise_alpha_OLR(G1H32(152),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(152),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(152),ex7(:),G1H16(26),m3h2x16(:,26),heltab2x32(:,:,127))
  call Hloop_AZ_Q(ntryL,G1H32(154),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,102),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(102),n2h8(102))
  call Hloop_AZ_Q(ntryL,G1H32(155),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,103),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(103),n2h8(103))
  call Hloop_AZ_Q(ntryL,G1H32(156),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,104),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(104),n2h8(104))
  call Hloop_AV_Q(ntryL,G1H32(157),wf4(:,17),G1H8(1),m3h4x8(:,105),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(105),n2h8(105))
call HGT_raise_alpha_OLR(G1H32(158),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(158),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(158),ex7(:),G1H16(27),m3h2x16(:,27),heltab2x32(:,:,132))
  call Hloop_AV_Q(ntryL,G1H32(160),wf4(:,17),G1H8(1),m3h4x8(:,106),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(106),n2h8(106))
  call Hloop_AV_Q(ntryL,G1H32(161),wf4(:,17),G1H8(1),m3h4x8(:,107),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(107),n2h8(107))
  call Hloop_AV_Q(ntryL,G1H32(162),wf4(:,17),G1H8(1),m3h4x8(:,108),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(108),n2h8(108))
  call Hloop_AV_Q(ntryL,G1H32(163),wf4(:,17),G1H8(1),m3h4x8(:,109),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(109),n2h8(109))
call HGT_raise_alpha_OLR(G1H32(164),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(164),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(164),ex7(:),G1H16(28),m3h2x16(:,28),heltab2x32(:,:,137))
  call Hloop_AV_Q(ntryL,G1H32(166),wf4(:,17),G1H8(1),m3h4x8(:,110),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(110),n2h8(110))
  call Hloop_AV_Q(ntryL,G1H32(167),wf4(:,17),G1H8(1),m3h4x8(:,111),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(111),n2h8(111))
  call Hloop_AV_Q(ntryL,G1H32(168),wf4(:,17),G1H8(1),m3h4x8(:,112),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(112),n2h8(112))
  call Hloop_AZ_Q(ntryL,G1H32(169),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,113),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(113),n2h8(113))
call HGT_raise_alpha_OLR(G1H32(170),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(170),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(170),ex7(:),G1H16(29),m3h2x16(:,29),heltab2x32(:,:,142))
  call Hloop_AZ_Q(ntryL,G1H32(172),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,114),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(114),n2h8(114))
  call Hloop_AZ_Q(ntryL,G1H32(173),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,115),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(115),n2h8(115))
  call Hloop_AZ_Q(ntryL,G1H32(174),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,116),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(116),n2h8(116))
  call Hloop_AZ_Q(ntryL,G1H32(175),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,117),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(117),n2h8(117))
call HGT_raise_alpha_OLR(G1H32(176),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(176),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(176),ex7(:),G1H16(30),m3h2x16(:,30),heltab2x32(:,:,147))
  call Hloop_AZ_Q(ntryL,G1H32(178),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,118),heltab2x32(:,:,148))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(118),n2h8(118))
  call Hloop_AZ_Q(ntryL,G1H32(179),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,119),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(119),n2h8(119))
  call Hloop_AZ_Q(ntryL,G1H32(180),wf4(:,20),G1H8(1),ngZd,m3h4x8(:,120),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(120),n2h8(120))
  call Hloop_AZ_Q(ntryL,G1H32(181),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,121),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(121),n2h8(121))
call HGT_raise_alpha_OLR(G1H32(182),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(182),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(182),ex7(:),G1H16(31),m3h2x16(:,31),heltab2x32(:,:,152))
  call Hloop_AZ_Q(ntryL,G1H32(184),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,122),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(122),n2h8(122))
  call Hloop_AZ_Q(ntryL,G1H32(185),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,123),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(123),n2h8(123))
  call Hloop_AZ_Q(ntryL,G1H32(186),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,124),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(124),n2h8(124))
  call Hloop_AZ_Q(ntryL,G1H32(187),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,125),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(125),n2h8(125))
call HGT_raise_alpha_OLR(G1H32(188),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(188),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(188),ex7(:),G1H16(32),m3h2x16(:,32),heltab2x32(:,:,157))
  call Hloop_AZ_Q(ntryL,G1H32(190),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,126),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(126),n2h8(126))
  call Hloop_AZ_Q(ntryL,G1H32(191),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,127),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(127),n2h8(127))
  call Hloop_AZ_Q(ntryL,G1H32(192),wf4(:,25),G1H8(1),ngZd,m3h4x8(:,128),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(128),n2h8(128))
  call Hloop_AV_Q(ntryL,G1H32(193),wf4(:,3),G1H8(1),m3h4x8(:,129),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(129),n2h8(129))
call HGT_raise_alpha_OLR(G1H32(194),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(194),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(194),ex7(:),G1H16(33),m3h2x16(:,33),heltab2x32(:,:,162))
  call Hloop_AV_Q(ntryL,G1H32(196),wf4(:,3),G1H8(1),m3h4x8(:,130),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(130),n2h8(130))
  call Hloop_AV_Q(ntryL,G1H32(197),wf4(:,3),G1H8(1),m3h4x8(:,131),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(131),n2h8(131))
  call Hloop_AV_Q(ntryL,G1H32(198),wf4(:,3),G1H8(1),m3h4x8(:,132),heltab2x32(:,:,165))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(132),n2h8(132))
  call Hloop_AZ_Q(ntryL,G1H32(199),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,133),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(133),n2h8(133))
call HGT_raise_alpha_OLR(G1H32(200),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(200),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(200),ex7(:),G1H16(34),m3h2x16(:,34),heltab2x32(:,:,167))
  call Hloop_AZ_Q(ntryL,G1H32(202),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,134),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(134),n2h8(134))
  call Hloop_AZ_Q(ntryL,G1H32(203),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,135),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(135),n2h8(135))
  call Hloop_AZ_Q(ntryL,G1H32(204),wf4(:,10),G1H8(1),ngZu,m3h4x8(:,136),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(136),n2h8(136))
  call Hloop_AW_Q(ntryL,G1H32(205),wf4(:,6),G1H8(1),m3h4x8(:,137),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(137),n2h8(137))
call HGT_raise_alpha_OLR(G1H32(206),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(206),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(206),ex7(:),G1H16(35),m3h2x16(:,35),heltab2x32(:,:,172))
  call Hloop_AW_Q(ntryL,G1H32(208),wf4(:,6),G1H8(1),m3h4x8(:,138),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(138),n2h8(138))
  call Hloop_AW_Q(ntryL,G1H32(209),wf4(:,6),G1H8(1),m3h4x8(:,139),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(139),n2h8(139))
  call Hloop_AW_Q(ntryL,G1H32(210),wf4(:,6),G1H8(1),m3h4x8(:,140),heltab2x32(:,:,175))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(140),n2h8(140))
  call Hloop_AW_Q(ntryL,G1H32(211),wf4(:,5),G1H8(1),m3h4x8(:,141),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(141),n2h8(141))
call HGT_raise_alpha_OLR(G1H32(212),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(212),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(212),ex7(:),G1H16(36),m3h2x16(:,36),heltab2x32(:,:,177))
  call Hloop_AW_Q(ntryL,G1H32(214),wf4(:,5),G1H8(1),m3h4x8(:,142),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(142),n2h8(142))
  call Hloop_AW_Q(ntryL,G1H32(215),wf4(:,5),G1H8(1),m3h4x8(:,143),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(143),n2h8(143))
  call Hloop_AW_Q(ntryL,G1H32(216),wf4(:,5),G1H8(1),m3h4x8(:,144),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(144),n2h8(144))
  call Hloop_AW_Q(ntryL,G1H32(217),wf4(:,5),G1H8(1),m3h4x8(:,145),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(145),n2h8(145))
call HGT_raise_alpha_OLR(G1H32(218),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(218),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(218),ex7(:),G1H16(37),m3h2x16(:,37),heltab2x32(:,:,182))
  call Hloop_AW_Q(ntryL,G1H32(220),wf4(:,5),G1H8(1),m3h4x8(:,146),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(146),n2h8(146))
  call Hloop_AW_Q(ntryL,G1H32(221),wf4(:,5),G1H8(1),m3h4x8(:,147),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(147),n2h8(147))
  call Hloop_AW_Q(ntryL,G1H32(222),wf4(:,5),G1H8(1),m3h4x8(:,148),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G1H8(1),151,nMB,G2H8(148),n2h8(148))
  call Hloop_AV_Q(ntryL,G1H32(223),wf4(:,12),G1H8(1),m3h4x8(:,149),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(149),n2h8(149))
call HGT_raise_alpha_OLR(G1H32(224),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(224),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(224),ex7(:),G1H16(38),m3h2x16(:,38),heltab2x32(:,:,187))
  call Hloop_AV_Q(ntryL,G1H32(226),wf4(:,12),G1H8(1),m3h4x8(:,150),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(150),n2h8(150))
  call Hloop_AV_Q(ntryL,G1H32(227),wf4(:,12),G1H8(1),m3h4x8(:,151),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(151),n2h8(151))
  call Hloop_AV_Q(ntryL,G1H32(228),wf4(:,12),G1H8(1),m3h4x8(:,152),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(152),n2h8(152))
  call Hloop_AZ_Q(ntryL,G1H32(229),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,153),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(153),n2h8(153))
call HGT_raise_alpha_OLR(G1H32(230),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(230),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(230),ex7(:),G1H16(39),m3h2x16(:,39),heltab2x32(:,:,192))
  call Hloop_AZ_Q(ntryL,G1H32(232),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,154),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(154),n2h8(154))
  call Hloop_AZ_Q(ntryL,G1H32(233),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,155),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(155),n2h8(155))
  call Hloop_AZ_Q(ntryL,G1H32(234),wf4(:,15),G1H8(1),ngZu,m3h4x8(:,156),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(156),n2h8(156))
  call Hloop_AW_Q(ntryL,G1H32(235),wf4(:,6),G1H8(1),m3h4x8(:,157),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(157),n2h8(157))
call HGT_raise_alpha_OLR(G1H32(236),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(236),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(236),ex7(:),G1H16(40),m3h2x16(:,40),heltab2x32(:,:,197))
  call Hloop_AW_Q(ntryL,G1H32(238),wf4(:,6),G1H8(1),m3h4x8(:,158),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(158),n2h8(158))
  call Hloop_AW_Q(ntryL,G1H32(239),wf4(:,6),G1H8(1),m3h4x8(:,159),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(159),n2h8(159))
  call Hloop_AW_Q(ntryL,G1H32(240),wf4(:,6),G1H8(1),m3h4x8(:,160),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(160),n2h8(160))
  call Hloop_AW_Q(ntryL,G1H32(241),wf4(:,13),G1H8(1),m3h4x8(:,161),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(161),n2h8(161))
call HGT_raise_alpha_OLR(G1H32(242),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(242),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(242),ex7(:),G1H16(41),m3h2x16(:,41),heltab2x32(:,:,202))
  call Hloop_AW_Q(ntryL,G1H32(244),wf4(:,13),G1H8(1),m3h4x8(:,162),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(162),n2h8(162))
  call Hloop_AW_Q(ntryL,G1H32(245),wf4(:,13),G1H8(1),m3h4x8(:,163),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(163),n2h8(163))
  call Hloop_AW_Q(ntryL,G1H32(246),wf4(:,13),G1H8(1),m3h4x8(:,164),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(164),n2h8(164))
  call Hloop_AW_Q(ntryL,G1H32(247),wf4(:,13),G1H8(1),m3h4x8(:,165),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(165),n2h8(165))
call HGT_raise_alpha_OLR(G1H32(248),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(248),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(248),ex7(:),G1H16(42),m3h2x16(:,42),heltab2x32(:,:,207))
  call Hloop_AW_Q(ntryL,G1H32(250),wf4(:,13),G1H8(1),m3h4x8(:,166),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(166),n2h8(166))
  call Hloop_AW_Q(ntryL,G1H32(251),wf4(:,13),G1H8(1),m3h4x8(:,167),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(167),n2h8(167))
  call Hloop_AW_Q(ntryL,G1H32(252),wf4(:,13),G1H8(1),m3h4x8(:,168),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G1H8(1),167,nMB,G2H8(168),n2h8(168))
  call Hloop_AV_Q(ntryL,G1H32(253),wf4(:,17),G1H8(1),m3h4x8(:,169),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(169),n2h8(169))
call HGT_raise_alpha_OLR(G1H32(254),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(254),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(254),ex7(:),G1H16(43),m3h2x16(:,43),heltab2x32(:,:,212))
  call Hloop_AV_Q(ntryL,G1H32(256),wf4(:,17),G1H8(1),m3h4x8(:,170),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(170),n2h8(170))
  call Hloop_AV_Q(ntryL,G1H32(257),wf4(:,17),G1H8(1),m3h4x8(:,171),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(171),n2h8(171))
  call Hloop_AV_Q(ntryL,G1H32(258),wf4(:,17),G1H8(1),m3h4x8(:,172),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(172),n2h8(172))
  call Hloop_AZ_Q(ntryL,G1H32(259),wf4(:,20),G1H8(1),ngZu,m3h4x8(:,173),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(173),n2h8(173))
call HGT_raise_alpha_OLR(G1H32(260),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(260),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(260),ex7(:),G1H16(44),m3h2x16(:,44),heltab2x32(:,:,217))
  call Hloop_AZ_Q(ntryL,G1H32(262),wf4(:,20),G1H8(1),ngZu,m3h4x8(:,174),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(174),n2h8(174))
  call Hloop_AZ_Q(ntryL,G1H32(263),wf4(:,20),G1H8(1),ngZu,m3h4x8(:,175),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(175),n2h8(175))
  call Hloop_AZ_Q(ntryL,G1H32(264),wf4(:,20),G1H8(1),ngZu,m3h4x8(:,176),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(176),n2h8(176))
  call Hloop_AW_Q(ntryL,G1H32(265),wf4(:,18),G1H8(1),m3h4x8(:,177),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(177),n2h8(177))
call HGT_raise_alpha_OLR(G1H32(266),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(266),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(266),ex7(:),G1H16(45),m3h2x16(:,45),heltab2x32(:,:,222))
  call Hloop_AW_Q(ntryL,G1H32(268),wf4(:,18),G1H8(1),m3h4x8(:,178),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(178),n2h8(178))
  call Hloop_AW_Q(ntryL,G1H32(269),wf4(:,18),G1H8(1),m3h4x8(:,179),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(179),n2h8(179))
  call Hloop_AW_Q(ntryL,G1H32(270),wf4(:,18),G1H8(1),m3h4x8(:,180),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G1H8(1),174,nMT,G2H8(180),n2h8(180))
  call Hloop_AW_Q(ntryL,G1H32(271),wf4(:,5),G1H8(1),m3h4x8(:,181),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(181),n2h8(181))
call HGT_raise_alpha_OLR(G1H32(272),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(272),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(272),ex7(:),G1H16(46),m3h2x16(:,46),heltab2x32(:,:,227))
  call Hloop_AW_Q(ntryL,G1H32(274),wf4(:,5),G1H8(1),m3h4x8(:,182),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(182),n2h8(182))
  call Hloop_AW_Q(ntryL,G1H32(275),wf4(:,5),G1H8(1),m3h4x8(:,183),heltab2x32(:,:,229))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(183),n2h8(183))
  call Hloop_AW_Q(ntryL,G1H32(276),wf4(:,5),G1H8(1),m3h4x8(:,184),heltab2x32(:,:,230))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(184),n2h8(184))
  call Hloop_AW_Q(ntryL,G1H32(277),wf4(:,5),G1H8(1),m3h4x8(:,185),heltab2x32(:,:,231))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(185),n2h8(185))
call HGT_raise_alpha_OLR(G1H32(278),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(278),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(278),ex7(:),G1H16(47),m3h2x16(:,47),heltab2x32(:,:,232))
  call Hloop_AW_Q(ntryL,G1H32(280),wf4(:,5),G1H8(1),m3h4x8(:,186),heltab2x32(:,:,233))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(186),n2h8(186))
  call Hloop_AW_Q(ntryL,G1H32(281),wf4(:,5),G1H8(1),m3h4x8(:,187),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(187),n2h8(187))
  call Hloop_AW_Q(ntryL,G1H32(282),wf4(:,5),G1H8(1),m3h4x8(:,188),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G1H8(1),155,nMB,G2H8(188),n2h8(188))
  call Hloop_AV_Q(ntryL,G1H32(283),wf4(:,21),G1H8(1),m3h4x8(:,189),heltab2x32(:,:,236))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(189),n2h8(189))
call HGT_raise_alpha_OLR(G1H32(284),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(284),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(284),ex7(:),G1H16(48),m3h2x16(:,48),heltab2x32(:,:,237))
  call Hloop_AV_Q(ntryL,G1H32(286),wf4(:,21),G1H8(1),m3h4x8(:,190),heltab2x32(:,:,238))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(190),n2h8(190))
  call Hloop_AV_Q(ntryL,G1H32(287),wf4(:,21),G1H8(1),m3h4x8(:,191),heltab2x32(:,:,239))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(191),n2h8(191))
  call Hloop_AV_Q(ntryL,G1H32(288),wf4(:,21),G1H8(1),m3h4x8(:,192),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(192),n2h8(192))
  call Hloop_AZ_Q(ntryL,G1H32(289),wf4(:,23),G1H8(1),ngZu,m3h4x8(:,193),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(193),n2h8(193))
call HGT_raise_alpha_OLR(G1H32(290),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(290),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(290),ex7(:),G1H16(49),m3h2x16(:,49),heltab2x32(:,:,242))
  call Hloop_AZ_Q(ntryL,G1H32(292),wf4(:,23),G1H8(1),ngZu,m3h4x8(:,194),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(194),n2h8(194))
  call Hloop_AZ_Q(ntryL,G1H32(293),wf4(:,23),G1H8(1),ngZu,m3h4x8(:,195),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(195),n2h8(195))
  call Hloop_AZ_Q(ntryL,G1H32(294),wf4(:,23),G1H8(1),ngZu,m3h4x8(:,196),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(196),n2h8(196))
  call Hloop_AW_Q(ntryL,G1H32(295),wf4(:,18),G1H8(1),m3h4x8(:,197),heltab2x32(:,:,246))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(197),n2h8(197))
call HGT_raise_alpha_OLR(G1H32(296),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(296),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(296),ex7(:),G1H16(50),m3h2x16(:,50),heltab2x32(:,:,247))
  call Hloop_AW_Q(ntryL,G1H32(298),wf4(:,18),G1H8(1),m3h4x8(:,198),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(198),n2h8(198))
  call Hloop_AW_Q(ntryL,G1H32(299),wf4(:,18),G1H8(1),m3h4x8(:,199),heltab2x32(:,:,249))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(199),n2h8(199))
  call Hloop_AW_Q(ntryL,G1H32(300),wf4(:,18),G1H8(1),m3h4x8(:,200),heltab2x32(:,:,250))
  call Hloop_A_Q(ntryL,G1H8(1),158,nMT,G2H8(200),n2h8(200))
  call Hloop_AW_Q(ntryL,G1H32(301),wf4(:,13),G1H8(1),m3h4x8(:,201),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(201),n2h8(201))
call HGT_raise_alpha_OLR(G1H32(302),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(302),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(302),ex7(:),G1H16(51),m3h2x16(:,51),heltab2x32(:,:,252))
  call Hloop_AW_Q(ntryL,G1H32(304),wf4(:,13),G1H8(1),m3h4x8(:,202),heltab2x32(:,:,253))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(202),n2h8(202))
  call Hloop_AW_Q(ntryL,G1H32(305),wf4(:,13),G1H8(1),m3h4x8(:,203),heltab2x32(:,:,254))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(203),n2h8(203))
  call Hloop_AW_Q(ntryL,G1H32(306),wf4(:,13),G1H8(1),m3h4x8(:,204),heltab2x32(:,:,255))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(204),n2h8(204))
  call Hloop_AW_Q(ntryL,G1H32(307),wf4(:,13),G1H8(1),m3h4x8(:,205),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(205),n2h8(205))
call HGT_raise_alpha_OLR(G1H32(308),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(308),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(308),ex7(:),G1H16(52),m3h2x16(:,52),heltab2x32(:,:,257))
  call Hloop_AW_Q(ntryL,G1H32(310),wf4(:,13),G1H8(1),m3h4x8(:,206),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(206),n2h8(206))
  call Hloop_AW_Q(ntryL,G1H32(311),wf4(:,13),G1H8(1),m3h4x8(:,207),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(207),n2h8(207))
  call Hloop_AW_Q(ntryL,G1H32(312),wf4(:,13),G1H8(1),m3h4x8(:,208),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G1H8(1),171,nMB,G2H8(208),n2h8(208))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G2H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G2H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G2H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G2H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G2H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G2H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G2H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(56),[G2H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G2H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(71),[G2H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(72),[G2H8(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(77),[G2H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(79),[G2H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G2H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(85),[G2H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(87),[G2H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(88),[G2H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(93),[G2H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(95),[G2H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(96),[G2H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(113),[G2H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(115),[G2H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(116),[G2H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(117),[G2H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(119),[G2H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(120),[G2H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(133),[G2H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(135),[G2H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(136),[G2H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(153),[G2H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(155),[G2H8(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(156),[G2H8(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(173),[G2H8(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(175),[G2H8(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(176),[G2H8(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(193),[G2H8(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(195),[G2H8(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(196),[G2H8(192)])
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),64,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(1),mass4set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(8),64,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(2),mass4set(:,1),  & 
G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(13),67,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(2),mass5set(:,1),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(18),64,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(3),mass4set(:,1),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(24),64,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(4),mass4set(:,1),  & 
G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(29),67,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(3),mass5set(:,1),  & 
G1H8(33),G1H8(34),G1H8(35),G1H8(36),G1H8(37),G1H8(38),8)
  call HG1shiftOLR(G1H8(34),64,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(5),mass4set(:,1),  & 
G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),8)
  call HG1shiftOLR(G1H8(40),64,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(6),mass4set(:,1),  & 
G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(45),84,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(3),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),64,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(5),mass4set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),8)
  call HG1shiftOLR(G1H8(56),64,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(6),mass4set(:,1),  & 
G1H8(60),G1H8(61),G1H8(62),G1H8(63),G1H8(64),8)
  call HG1shiftOLR(G1H8(61),84,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(4),mass5set(:,1),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(66),64,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(3),mass4set(:,1),  & 
G1H8(71),G1H8(72),G1H8(73),G1H8(74),G1H8(75),8)
  call HG1shiftOLR(G1H8(72),64,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(7),mass4set(:,1),  & 
G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(77),84,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(4),mass5set(:,1),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),64,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(3),mass4set(:,1),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),8)
  call HG1shiftOLR(G1H8(88),64,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(7),mass4set(:,1),  & 
G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(93),84,8)
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(5),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),64,8)
  call Hotf_4pt_reduction(G2H8(51),RedSet_4(5),mass4set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),8)
  call HG1shiftOLR(G1H8(104),64,8)
  call Hotf_4pt_reduction(G2H8(52),RedSet_4(8),mass4set(:,1),  & 
G1H8(108),G1H8(109),G1H8(110),G1H8(111),G1H8(112),8)
  call HG1shiftOLR(G1H8(109),104,8)
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(5),mass5set(:,1),  & 
G1H8(113),G1H8(114),G1H8(115),G1H8(116),G1H8(117),G1H8(118),8)
  call HG1shiftOLR(G1H8(114),64,8)
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(5),mass4set(:,1),  & 
G1H8(119),G1H8(120),G1H8(121),G1H8(122),G1H8(123),8)
  call HG1shiftOLR(G1H8(120),64,8)
  call Hotf_4pt_reduction(G2H8(56),RedSet_4(8),mass4set(:,1),  & 
G1H8(124),G1H8(125),G1H8(126),G1H8(127),G1H8(128),8)
  call HG1shiftOLR(G1H8(125),104,8)
  call Hotf_5pt_reduction(G2H8(57),RedSet_5(6),mass5set(:,1),  & 
G1H8(129),G1H8(130),G1H8(131),G1H8(132),G1H8(133),G1H8(134),8)
  call HG1shiftOLR(G1H8(130),64,8)
  call Hotf_4pt_reduction(G2H8(59),RedSet_4(1),mass4set(:,1),  & 
G1H8(135),G1H8(136),G1H8(137),G1H8(138),G1H8(139),8)
  call HG1shiftOLR(G1H8(136),64,8)
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(9),mass4set(:,1),  & 
G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(141),104,8)
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(6),mass5set(:,1),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),64,8)
  call Hotf_4pt_reduction(G2H8(63),RedSet_4(1),mass4set(:,1),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),8)
  call HG1shiftOLR(G1H8(152),64,8)
  call Hotf_4pt_reduction(G2H8(64),RedSet_4(9),mass4set(:,1),  & 
G1H8(156),G1H8(157),G1H8(158),G1H8(159),G1H8(160),8)
  call HG1shiftOLR(G1H8(157),104,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(7),mass5set(:,1),  & 
G1H8(161),G1H8(162),G1H8(163),G1H8(164),G1H8(165),G1H8(166),8)
  call HG1shiftOLR(G1H8(162),64,8)
  call Hotf_4pt_reduction(G2H8(71),RedSet_4(10),mass4set(:,1),  & 
G1H8(167),G1H8(168),G1H8(169),G1H8(170),G1H8(171),8)
  call HG1shiftOLR(G1H8(168),64,8)
  call Hotf_4pt_reduction(G2H8(72),RedSet_4(11),mass4set(:,1),  & 
G1H8(172),G1H8(173),G1H8(174),G1H8(175),G1H8(176),8)
  call HG1shiftOLR(G1H8(173),67,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(8),mass5set(:,1),  & 
G1H8(177),G1H8(178),G1H8(179),G1H8(180),G1H8(181),G1H8(182),8)
  call HG1shiftOLR(G1H8(178),64,8)
  call Hotf_4pt_reduction(G2H8(79),RedSet_4(12),mass4set(:,1),  & 
G1H8(183),G1H8(184),G1H8(185),G1H8(186),G1H8(187),8)
  call HG1shiftOLR(G1H8(184),64,8)
  call Hotf_4pt_reduction(G2H8(80),RedSet_4(13),mass4set(:,1),  & 
G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(189),67,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(9),mass5set(:,1),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),64,8)
  call Hotf_4pt_reduction(G2H8(87),RedSet_4(5),mass4set(:,1),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),8)
  call HG1shiftOLR(G1H8(200),64,8)
  call Hotf_4pt_reduction(G2H8(88),RedSet_4(14),mass4set(:,1),  & 
G1H8(204),G1H8(205),G1H8(206),G1H8(207),G1H8(208),8)
  call HG1shiftOLR(G1H8(205),100,8)
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(9),mass5set(:,1),  & 
G1H8(209),G1H8(210),G1H8(211),G1H8(212),G1H8(213),G1H8(214),8)
  call HG1shiftOLR(G1H8(210),64,8)
  call Hotf_4pt_reduction(G2H8(95),RedSet_4(5),mass4set(:,1),  & 
G1H8(215),G1H8(216),G1H8(217),G1H8(218),G1H8(219),8)
  call HG1shiftOLR(G1H8(216),64,8)
  call Hotf_4pt_reduction(G2H8(96),RedSet_4(14),mass4set(:,1),  & 
G1H8(220),G1H8(221),G1H8(222),G1H8(223),G1H8(224),8)
  call HG1shiftOLR(G1H8(221),100,8)
  call Hotf_5pt_reduction(G2H8(97),RedSet_5(10),mass5set(:,1),  & 
G1H8(225),G1H8(226),G1H8(227),G1H8(228),G1H8(229),G1H8(230),8)
  call HG1shiftOLR(G1H8(226),64,8)
  call Hotf_4pt_reduction(G2H8(99),RedSet_4(12),mass4set(:,1),  & 
G1H8(231),G1H8(232),G1H8(233),G1H8(234),G1H8(235),8)
  call HG1shiftOLR(G1H8(232),64,8)
  call Hotf_4pt_reduction(G2H8(100),RedSet_4(15),mass4set(:,1),  & 
G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(237),100,8)
  call Hotf_5pt_reduction(G2H8(101),RedSet_5(10),mass5set(:,1),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),64,8)
  call Hotf_4pt_reduction(G2H8(103),RedSet_4(12),mass4set(:,1),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),8)
  call HG1shiftOLR(G1H8(248),64,8)
  call Hotf_4pt_reduction(G2H8(104),RedSet_4(15),mass4set(:,1),  & 
G1H8(252),G1H8(253),G1H8(254),G1H8(255),G1H8(256),8)
  call HG1shiftOLR(G1H8(253),100,8)
  call Hotf_5pt_reduction(G2H8(113),RedSet_5(11),mass5set(:,1),  & 
G1H8(257),G1H8(258),G1H8(259),G1H8(260),G1H8(261),G1H8(262),8)
  call HG1shiftOLR(G1H8(258),64,8)
  call Hotf_4pt_reduction(G2H8(115),RedSet_4(5),mass4set(:,1),  & 
G1H8(263),G1H8(264),G1H8(265),G1H8(266),G1H8(267),8)
  call HG1shiftOLR(G1H8(264),64,8)
  call Hotf_4pt_reduction(G2H8(116),RedSet_4(16),mass4set(:,1),  & 
G1H8(268),G1H8(269),G1H8(270),G1H8(271),G1H8(272),8)
  call HG1shiftOLR(G1H8(269),88,8)
  call Hotf_5pt_reduction(G2H8(117),RedSet_5(11),mass5set(:,1),  & 
G1H8(273),G1H8(274),G1H8(275),G1H8(276),G1H8(277),G1H8(278),8)
  call HG1shiftOLR(G1H8(274),64,8)
  call Hotf_4pt_reduction(G2H8(119),RedSet_4(5),mass4set(:,1),  & 
G1H8(279),G1H8(280),G1H8(281),G1H8(282),G1H8(283),8)
  call HG1shiftOLR(G1H8(280),64,8)
  call Hotf_4pt_reduction(G2H8(120),RedSet_4(16),mass4set(:,1),  & 
G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(285),88,8)
  call Hotf_5pt_reduction(G2H8(121),RedSet_5(12),mass5set(:,1),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),64,8)
  call Hotf_4pt_reduction(G2H8(123),RedSet_4(10),mass4set(:,1),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),8)
  call HG1shiftOLR(G1H8(296),64,8)
  call Hotf_4pt_reduction(G2H8(124),RedSet_4(17),mass4set(:,1),  & 
G1H8(300),G1H8(301),G1H8(302),G1H8(303),G1H8(304),8)
  call HG1shiftOLR(G1H8(301),88,8)
  call Hotf_5pt_reduction(G2H8(125),RedSet_5(12),mass5set(:,1),  & 
G1H8(305),G1H8(306),G1H8(307),G1H8(308),G1H8(309),G1H8(310),8)
  call HG1shiftOLR(G1H8(306),64,8)
  call Hotf_4pt_reduction(G2H8(127),RedSet_4(10),mass4set(:,1),  & 
G1H8(311),G1H8(312),G1H8(313),G1H8(314),G1H8(315),8)
  call HG1shiftOLR(G1H8(312),64,8)
  call Hotf_4pt_reduction(G2H8(128),RedSet_4(17),mass4set(:,1),  & 
G1H8(316),G1H8(317),G1H8(318),G1H8(319),G1H8(320),8)
  call HG1shiftOLR(G1H8(317),88,8)
  call Hotf_5pt_reduction(G2H8(133),RedSet_5(13),mass5set(:,2),  & 
G1H8(321),G1H8(322),G1H8(323),G1H8(324),G1H8(325),G1H8(326),8)
  call HG1shiftOLR(G1H8(322),64,8)
  call Hotf_4pt_reduction(G2H8(135),RedSet_4(18),mass4set(:,2),  & 
G1H8(327),G1H8(328),G1H8(329),G1H8(330),G1H8(331),8)
  call HG1shiftOLR(G1H8(328),64,8)
  call Hotf_4pt_reduction(G2H8(136),RedSet_4(19),mass4set(:,3),  & 
G1H8(332),G1H8(333),G1H8(334),G1H8(335),G1H8(336),8)
  call HG1shiftOLR(G1H8(333),81,8)
  call Hotf_5pt_reduction(G2H8(137),RedSet_5(14),mass5set(:,3),  & 
G1H8(337),G1H8(338),G1H8(339),G1H8(340),G1H8(341),G1H8(342),8)
  call HG1shiftOLR(G1H8(338),64,8)
  call Hotf_4pt_reduction(G2H8(139),RedSet_4(3),mass4set(:,1),  & 
G1H8(343),G1H8(344),G1H8(345),G1H8(346),G1H8(347),8)
  call HG1shiftOLR(G1H8(344),64,8)
  call Hotf_4pt_reduction(G2H8(140),RedSet_4(20),mass4set(:,4),  & 
G1H8(348),G1H8(349),G1H8(350),G1H8(351),G1H8(352),8)
  call HG1shiftOLR(G1H8(349),81,8)
  call Hotf_5pt_reduction(G2H8(141),RedSet_5(15),mass5set(:,4),  & 
G1H8(353),G1H8(354),G1H8(355),G1H8(356),G1H8(357),G1H8(358),8)
  call HG1shiftOLR(G1H8(354),64,8)
  call Hotf_4pt_reduction(G2H8(143),RedSet_4(18),mass4set(:,2),  & 
G1H8(359),G1H8(360),G1H8(361),G1H8(362),G1H8(363),8)
  call HG1shiftOLR(G1H8(360),64,8)
  call Hotf_4pt_reduction(G2H8(144),RedSet_4(21),mass4set(:,2),  & 
G1H8(364),G1H8(365),G1H8(366),G1H8(367),G1H8(368),8)
  call HG1shiftOLR(G1H8(365),104,8)
  call Hotf_5pt_reduction(G2H8(145),RedSet_5(15),mass5set(:,4),  & 
G1H8(369),G1H8(370),G1H8(371),G1H8(372),G1H8(373),G1H8(374),8)
  call HG1shiftOLR(G1H8(370),64,8)
  call Hotf_4pt_reduction(G2H8(147),RedSet_4(18),mass4set(:,2),  & 
G1H8(375),G1H8(376),G1H8(377),G1H8(378),G1H8(379),8)
  call HG1shiftOLR(G1H8(376),64,8)
  call Hotf_4pt_reduction(G2H8(148),RedSet_4(21),mass4set(:,2),  & 
G1H8(380),G1H8(381),G1H8(382),G1H8(383),G1H8(384),8)
  call HG1shiftOLR(G1H8(381),104,8)
  call Hotf_5pt_reduction(G2H8(153),RedSet_5(16),mass5set(:,2),  & 
G1H8(385),G1H8(386),G1H8(387),G1H8(388),G1H8(389),G1H8(390),8)
  call HG1shiftOLR(G1H8(386),64,8)
  call Hotf_4pt_reduction(G2H8(155),RedSet_4(18),mass4set(:,2),  & 
G1H8(391),G1H8(392),G1H8(393),G1H8(394),G1H8(395),8)
  call HG1shiftOLR(G1H8(392),64,8)
  call Hotf_4pt_reduction(G2H8(156),RedSet_4(22),mass4set(:,3),  & 
G1H8(396),G1H8(397),G1H8(398),G1H8(399),G1H8(400),8)
  call HG1shiftOLR(G1H8(397),97,8)
  call Hotf_5pt_reduction(G2H8(157),RedSet_5(17),mass5set(:,3),  & 
G1H8(401),G1H8(402),G1H8(403),G1H8(404),G1H8(405),G1H8(406),8)
  call HG1shiftOLR(G1H8(402),64,8)
  call Hotf_4pt_reduction(G2H8(159),RedSet_4(12),mass4set(:,1),  & 
G1H8(407),G1H8(408),G1H8(409),G1H8(410),G1H8(411),8)
  call HG1shiftOLR(G1H8(408),64,8)
  call Hotf_4pt_reduction(G2H8(160),RedSet_4(23),mass4set(:,4),  & 
G1H8(412),G1H8(413),G1H8(414),G1H8(415),G1H8(416),8)
  call HG1shiftOLR(G1H8(413),97,8)
  call Hotf_5pt_reduction(G2H8(161),RedSet_5(18),mass5set(:,4),  & 
G1H8(417),G1H8(418),G1H8(419),G1H8(420),G1H8(421),G1H8(422),8)
  call HG1shiftOLR(G1H8(418),64,8)
  call Hotf_4pt_reduction(G2H8(163),RedSet_4(18),mass4set(:,2),  & 
G1H8(423),G1H8(424),G1H8(425),G1H8(426),G1H8(427),8)
  call HG1shiftOLR(G1H8(424),64,8)
  call Hotf_4pt_reduction(G2H8(164),RedSet_4(24),mass4set(:,2),  & 
G1H8(428),G1H8(429),G1H8(430),G1H8(431),G1H8(432),8)
  call HG1shiftOLR(G1H8(429),88,8)
  call Hotf_5pt_reduction(G2H8(165),RedSet_5(18),mass5set(:,4),  & 
G1H8(433),G1H8(434),G1H8(435),G1H8(436),G1H8(437),G1H8(438),8)
  call HG1shiftOLR(G1H8(434),64,8)
  call Hotf_4pt_reduction(G2H8(167),RedSet_4(18),mass4set(:,2),  & 
G1H8(439),G1H8(440),G1H8(441),G1H8(442),G1H8(443),8)
  call HG1shiftOLR(G1H8(440),64,8)
  call Hotf_4pt_reduction(G2H8(168),RedSet_4(24),mass4set(:,2),  & 
G1H8(444),G1H8(445),G1H8(446),G1H8(447),G1H8(448),8)
  call HG1shiftOLR(G1H8(445),88,8)
  call Hotf_5pt_reduction(G2H8(173),RedSet_5(19),mass5set(:,2),  & 
G1H8(449),G1H8(450),G1H8(451),G1H8(452),G1H8(453),G1H8(454),8)
  call HG1shiftOLR(G1H8(450),64,8)
  call Hotf_4pt_reduction(G2H8(175),RedSet_4(25),mass4set(:,2),  & 
G1H8(455),G1H8(456),G1H8(457),G1H8(458),G1H8(459),8)
  call HG1shiftOLR(G1H8(456),64,8)
  call Hotf_4pt_reduction(G2H8(176),RedSet_4(26),mass4set(:,3),  & 
G1H8(460),G1H8(461),G1H8(462),G1H8(463),G1H8(464),8)
  call HG1shiftOLR(G1H8(461),81,8)
  call Hotf_5pt_reduction(G2H8(177),RedSet_5(20),mass5set(:,3),  & 
G1H8(465),G1H8(466),G1H8(467),G1H8(468),G1H8(469),G1H8(470),8)
  call HG1shiftOLR(G1H8(466),64,8)
  call Hotf_4pt_reduction(G2H8(179),RedSet_4(10),mass4set(:,1),  & 
G1H8(471),G1H8(472),G1H8(473),G1H8(474),G1H8(475),8)
  call HG1shiftOLR(G1H8(472),64,8)
  call Hotf_4pt_reduction(G2H8(180),RedSet_4(27),mass4set(:,4),  & 
G1H8(476),G1H8(477),G1H8(478),G1H8(479),G1H8(480),8)
  call HG1shiftOLR(G1H8(477),81,8)
  call Hotf_5pt_reduction(G2H8(181),RedSet_5(21),mass5set(:,4),  & 
G1H8(481),G1H8(482),G1H8(483),G1H8(484),G1H8(485),G1H8(486),8)
  call HG1shiftOLR(G1H8(482),64,8)
  call Hotf_4pt_reduction(G2H8(183),RedSet_4(25),mass4set(:,2),  & 
G1H8(487),G1H8(488),G1H8(489),G1H8(490),G1H8(491),8)
  call HG1shiftOLR(G1H8(488),64,8)
  call Hotf_4pt_reduction(G2H8(184),RedSet_4(28),mass4set(:,2),  & 
G1H8(492),G1H8(493),G1H8(494),G1H8(495),G1H8(496),8)
  call HG1shiftOLR(G1H8(493),100,8)
  call Hotf_5pt_reduction(G2H8(185),RedSet_5(21),mass5set(:,4),  & 
G1H8(497),G1H8(498),G1H8(499),G1H8(500),G1H8(501),G1H8(502),8)
  call HG1shiftOLR(G1H8(498),64,8)
  call Hotf_4pt_reduction(G2H8(187),RedSet_4(25),mass4set(:,2),  & 
G1H8(503),G1H8(504),G1H8(505),G1H8(506),G1H8(507),8)
  call HG1shiftOLR(G1H8(504),64,8)
  call Hotf_4pt_reduction(G2H8(188),RedSet_4(28),mass4set(:,2),  & 
G1H8(508),G1H8(509),G1H8(510),G1H8(511),G1H8(512),8)
  call HG1shiftOLR(G1H8(509),100,8)
  call Hotf_5pt_reduction(G2H8(193),RedSet_5(22),mass5set(:,2),  & 
G1H8(513),G1H8(514),G1H8(515),G1H8(516),G1H8(517),G1H8(518),8)
  call HG1shiftOLR(G1H8(514),64,8)
  call Hotf_4pt_reduction(G2H8(195),RedSet_4(25),mass4set(:,2),  & 
G1H8(519),G1H8(520),G1H8(521),G1H8(522),G1H8(523),8)
  call HG1shiftOLR(G1H8(520),64,8)
  call Hotf_4pt_reduction(G2H8(196),RedSet_4(29),mass4set(:,3),  & 
G1H8(524),G1H8(525),G1H8(526),G1H8(527),G1H8(528),8)
  call HG1shiftOLR(G1H8(525),97,8)
  call Hotf_5pt_reduction(G2H8(197),RedSet_5(23),mass5set(:,3),  & 
G1H8(529),G1H8(530),G1H8(531),G1H8(532),G1H8(533),G1H8(534),8)
  call HG1shiftOLR(G1H8(530),64,8)
  call Hotf_4pt_reduction(G2H8(199),RedSet_4(1),mass4set(:,1),  & 
G1H8(535),G1H8(536),G1H8(537),G1H8(538),G1H8(539),8)
  call HG1shiftOLR(G1H8(536),64,8)
  call Hotf_4pt_reduction(G2H8(200),RedSet_4(30),mass4set(:,4),  & 
G1H8(540),G1H8(541),G1H8(542),G1H8(543),G1H8(544),8)
  call HG1shiftOLR(G1H8(541),97,8)
  call Hotf_5pt_reduction(G2H8(201),RedSet_5(24),mass5set(:,4),  & 
G1H8(545),G1H8(546),G1H8(547),G1H8(548),G1H8(549),G1H8(550),8)
  call HG1shiftOLR(G1H8(546),64,8)
  call Hotf_4pt_reduction(G2H8(203),RedSet_4(25),mass4set(:,2),  & 
G1H8(551),G1H8(552),G1H8(553),G1H8(554),G1H8(555),8)
  call HG1shiftOLR(G1H8(552),64,8)
  call Hotf_4pt_reduction(G2H8(204),RedSet_4(31),mass4set(:,2),  & 
G1H8(556),G1H8(557),G1H8(558),G1H8(559),G1H8(560),8)
  call HG1shiftOLR(G1H8(557),84,8)
  call Hotf_5pt_reduction(G2H8(205),RedSet_5(24),mass5set(:,4),  & 
G1H8(561),G1H8(562),G1H8(563),G1H8(564),G1H8(565),G1H8(566),8)
  call HG1shiftOLR(G1H8(562),64,8)
  call Hotf_4pt_reduction(G2H8(207),RedSet_4(25),mass4set(:,2),  & 
G1H8(567),G1H8(568),G1H8(569),G1H8(570),G1H8(571),8)
  call HG1shiftOLR(G1H8(568),64,8)
  call Hotf_4pt_reduction(G2H8(208),RedSet_4(31),mass4set(:,2),  & 
G1H8(572),G1H8(573),G1H8(574),G1H8(575),G1H8(576),8)
  call HG1shiftOLR(G1H8(573),84,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(119),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(135),[G1H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(140),[G1H8(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(156),[G1H8(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(167),[G1H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(172),[G1H8(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(183),[G1H8(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(188),[G1H8(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(199),[G1H8(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(204),[G1H8(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(215),[G1H8(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(220),[G1H8(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(231),[G1H8(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(236),[G1H8(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(247),[G1H8(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(252),[G1H8(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(263),[G1H8(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(268),[G1H8(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(279),[G1H8(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(284),[G1H8(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(295),[G1H8(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(300),[G1H8(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(311),[G1H8(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(316),[G1H8(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(327),[G1H8(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(332),[G1H8(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(343),[G1H8(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(348),[G1H8(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(359),[G1H8(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(364),[G1H8(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(375),[G1H8(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(380),[G1H8(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(391),[G1H8(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(396),[G1H8(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(407),[G1H8(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(412),[G1H8(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(423),[G1H8(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(428),[G1H8(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(439),[G1H8(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(444),[G1H8(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(455),[G1H8(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(460),[G1H8(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(471),[G1H8(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(476),[G1H8(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(487),[G1H8(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(492),[G1H8(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(503),[G1H8(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(508),[G1H8(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(519),[G1H8(517)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(524),[G1H8(518)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(535),[G1H8(533)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(540),[G1H8(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(551),[G1H8(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(556),[G1H8(550)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(567),[G1H8(565)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(572),[G1H8(566)])
  call Hloop_AZ_Q(ntryL,G1H8(1),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex7(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,2))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,2),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(2),n2h2(2))
  call Hloop_AZ_Q(ntryL,G1H8(12),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(3),n2h2(3))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(8),ex7(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,5))
  call Hloop_AZ_Q(ntryL,G1H8(11),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(13),ex7(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,7))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,5),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(5),n2h2(5))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,6),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(6),n2h2(6))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(18),ex7(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,10))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,7),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(7),n2h2(7))
  call Hloop_AZ_Q(ntryL,G1H8(28),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,8),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(8),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(24),ex7(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,13))
  call Hloop_AZ_Q(ntryL,G1H8(27),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,9),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(9),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(29),ex7(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,15))
  call Hloop_AZ_Q(ntryL,G1H8(32),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,10),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(10),n2h2(10))
  call Hloop_AV_Q(ntryL,G1H8(33),wf4(:,21),G1H2(1),m3h4x2(:,11),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(11),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(34),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(34),ex7(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,18))
  call Hloop_AV_Q(ntryL,G1H8(39),wf4(:,21),G1H2(1),m3h4x2(:,12),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(12),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(44),wf4(:,21),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(13),n2h2(13))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(40),ex7(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,21))
  call Hloop_AV_Q(ntryL,G1H8(43),wf4(:,21),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(14),n2h2(14))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(45),ex7(:),G1H4(9),m3h2x4(:,9),heltab2x8(:,:,23))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,21),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(15),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H8(49),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(16),n2h2(16))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(50),ex7(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,26))
  call Hloop_AZ_Q(ntryL,G1H8(55),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(17),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H8(60),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(18),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(56),ex7(:),G1H4(11),m3h2x4(:,11),heltab2x8(:,:,29))
  call Hloop_AZ_Q(ntryL,G1H8(59),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,19),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(19),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(61),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(61),ex7(:),G1H4(12),m3h2x4(:,12),heltab2x8(:,:,31))
  call Hloop_AZ_Q(ntryL,G1H8(64),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,20),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(20),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H8(65),wf4(:,21),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(21),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(66),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(66),ex7(:),G1H4(13),m3h2x4(:,13),heltab2x8(:,:,34))
  call Hloop_AV_Q(ntryL,G1H8(71),wf4(:,21),G1H2(1),m3h4x2(:,22),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(22),n2h2(22))
  call Hloop_AV_Q(ntryL,G1H8(76),wf4(:,21),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(23),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(72),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(72),ex7(:),G1H4(14),m3h2x4(:,14),heltab2x8(:,:,37))
  call Hloop_AV_Q(ntryL,G1H8(75),wf4(:,21),G1H2(1),m3h4x2(:,24),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(24),n2h2(24))
call HGT_raise_alpha_OLR(G1H8(77),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(77),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(77),ex7(:),G1H4(15),m3h2x4(:,15),heltab2x8(:,:,39))
  call Hloop_AV_Q(ntryL,G1H8(80),wf4(:,21),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(25),n2h2(25))
  call Hloop_AZ_Q(ntryL,G1H8(81),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,26),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(26),n2h2(26))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(82),ex7(:),G1H4(16),m3h2x4(:,16),heltab2x8(:,:,42))
  call Hloop_AZ_Q(ntryL,G1H8(87),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,27),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(27),n2h2(27))
  call Hloop_AZ_Q(ntryL,G1H8(92),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,28),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(28),n2h2(28))
call HGT_raise_alpha_OLR(G1H8(88),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(88),ex7(:),G1H4(17),m3h2x4(:,17),heltab2x8(:,:,45))
  call Hloop_AZ_Q(ntryL,G1H8(91),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,29),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(29),n2h2(29))
call HGT_raise_alpha_OLR(G1H8(93),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(93),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(93),ex7(:),G1H4(18),m3h2x4(:,18),heltab2x8(:,:,47))
  call Hloop_AZ_Q(ntryL,G1H8(96),wf4(:,23),G1H2(1),ngZd,m3h4x2(:,30),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(30),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H8(97),wf4(:,3),G1H2(1),m3h4x2(:,31),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(31),n2h2(31))
call HGT_raise_alpha_OLR(G1H8(98),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(98),ex7(:),G1H4(19),m3h2x4(:,19),heltab2x8(:,:,50))
  call Hloop_AV_Q(ntryL,G1H8(103),wf4(:,3),G1H2(1),m3h4x2(:,32),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(32),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H8(108),wf4(:,3),G1H2(1),m3h4x2(:,33),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(33),n2h2(33))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(104),ex7(:),G1H4(20),m3h2x4(:,20),heltab2x8(:,:,53))
  call Hloop_AV_Q(ntryL,G1H8(107),wf4(:,3),G1H2(1),m3h4x2(:,34),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(34),n2h2(34))
call HGT_raise_alpha_OLR(G1H8(109),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(109),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(109),ex7(:),G1H4(21),m3h2x4(:,21),heltab2x8(:,:,55))
  call Hloop_AV_Q(ntryL,G1H8(112),wf4(:,3),G1H2(1),m3h4x2(:,35),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(35),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H8(113),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,36),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(36),n2h2(36))
call HGT_raise_alpha_OLR(G1H8(114),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(114),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(114),ex7(:),G1H4(22),m3h2x4(:,22),heltab2x8(:,:,58))
  call Hloop_AZ_Q(ntryL,G1H8(119),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,37),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(37),n2h2(37))
  call Hloop_AZ_Q(ntryL,G1H8(124),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,38),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(38),n2h2(38))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(120),ex7(:),G1H4(23),m3h2x4(:,23),heltab2x8(:,:,61))
  call Hloop_AZ_Q(ntryL,G1H8(123),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,39),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(39),n2h2(39))
call HGT_raise_alpha_OLR(G1H8(125),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(125),ex7(:),G1H4(24),m3h2x4(:,24),heltab2x8(:,:,63))
  call Hloop_AZ_Q(ntryL,G1H8(128),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,40),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(40),n2h2(40))
  call Hloop_AV_Q(ntryL,G1H8(129),wf4(:,3),G1H2(1),m3h4x2(:,41),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(41),n2h2(41))
call HGT_raise_alpha_OLR(G1H8(130),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(130),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(130),ex7(:),G1H4(25),m3h2x4(:,25),heltab2x8(:,:,66))
  call Hloop_AV_Q(ntryL,G1H8(135),wf4(:,3),G1H2(1),m3h4x2(:,42),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(42),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H8(140),wf4(:,3),G1H2(1),m3h4x2(:,43),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(43),n2h2(43))
call HGT_raise_alpha_OLR(G1H8(136),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(136),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(136),ex7(:),G1H4(26),m3h2x4(:,26),heltab2x8(:,:,69))
  call Hloop_AV_Q(ntryL,G1H8(139),wf4(:,3),G1H2(1),m3h4x2(:,44),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(44),n2h2(44))
call HGT_raise_alpha_OLR(G1H8(141),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(141),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(141),ex7(:),G1H4(27),m3h2x4(:,27),heltab2x8(:,:,71))
  call Hloop_AV_Q(ntryL,G1H8(144),wf4(:,3),G1H2(1),m3h4x2(:,45),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(45),n2h2(45))
  call Hloop_AZ_Q(ntryL,G1H8(145),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,46),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(46),n2h2(46))
call HGT_raise_alpha_OLR(G1H8(146),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(146),ex7(:),G1H4(28),m3h2x4(:,28),heltab2x8(:,:,74))
  call Hloop_AZ_Q(ntryL,G1H8(151),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,47),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(47),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H8(156),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,48),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(48),n2h2(48))
call HGT_raise_alpha_OLR(G1H8(152),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(152),ex7(:),G1H4(29),m3h2x4(:,29),heltab2x8(:,:,77))
  call Hloop_AZ_Q(ntryL,G1H8(155),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,49),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(49),n2h2(49))
call HGT_raise_alpha_OLR(G1H8(157),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(157),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(157),ex7(:),G1H4(30),m3h2x4(:,30),heltab2x8(:,:,79))
  call Hloop_AZ_Q(ntryL,G1H8(160),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,50),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(50),n2h2(50))
  call Hloop_AZ_Q(ntryL,G1H8(161),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,51),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(51),n2h2(51))
call HGT_raise_alpha_OLR(G1H8(162),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(162),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(162),ex7(:),G1H4(31),m3h2x4(:,31),heltab2x8(:,:,82))
  call Hloop_AZ_Q(ntryL,G1H8(167),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,52),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(52),n2h2(52))
  call Hloop_AZ_Q(ntryL,G1H8(172),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,53),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(53),n2h2(53))
call HGT_raise_alpha_OLR(G1H8(168),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(168),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(168),ex7(:),G1H4(32),m3h2x4(:,32),heltab2x8(:,:,85))
  call Hloop_AZ_Q(ntryL,G1H8(171),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,54),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(54),n2h2(54))
call HGT_raise_alpha_OLR(G1H8(173),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(173),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(173),ex7(:),G1H4(33),m3h2x4(:,33),heltab2x8(:,:,87))
  call Hloop_AZ_Q(ntryL,G1H8(176),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,55),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(55),n2h2(55))
  call Hloop_AZ_Q(ntryL,G1H8(177),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,56),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(56),n2h2(56))
call HGT_raise_alpha_OLR(G1H8(178),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(178),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(178),ex7(:),G1H4(34),m3h2x4(:,34),heltab2x8(:,:,90))
  call Hloop_AZ_Q(ntryL,G1H8(183),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,57),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(57),n2h2(57))
  call Hloop_AZ_Q(ntryL,G1H8(188),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,58),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(58),n2h2(58))
call HGT_raise_alpha_OLR(G1H8(184),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(184),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(184),ex7(:),G1H4(35),m3h2x4(:,35),heltab2x8(:,:,93))
  call Hloop_AZ_Q(ntryL,G1H8(187),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,59),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(59),n2h2(59))
call HGT_raise_alpha_OLR(G1H8(189),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(189),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(189),ex7(:),G1H4(36),m3h2x4(:,36),heltab2x8(:,:,95))
  call Hloop_AZ_Q(ntryL,G1H8(192),wf4(:,25),G1H2(1),ngZd,m3h4x2(:,60),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(60),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H8(193),wf4(:,17),G1H2(1),m3h4x2(:,61),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(61),n2h2(61))
call HGT_raise_alpha_OLR(G1H8(194),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(194),ex7(:),G1H4(37),m3h2x4(:,37),heltab2x8(:,:,98))
  call Hloop_AV_Q(ntryL,G1H8(199),wf4(:,17),G1H2(1),m3h4x2(:,62),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(62),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H8(204),wf4(:,17),G1H2(1),m3h4x2(:,63),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(63),n2h2(63))
call HGT_raise_alpha_OLR(G1H8(200),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(200),ex7(:),G1H4(38),m3h2x4(:,38),heltab2x8(:,:,101))
  call Hloop_AV_Q(ntryL,G1H8(203),wf4(:,17),G1H2(1),m3h4x2(:,64),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(64),n2h2(64))
call HGT_raise_alpha_OLR(G1H8(205),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(205),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(205),ex7(:),G1H4(39),m3h2x4(:,39),heltab2x8(:,:,103))
  call Hloop_AV_Q(ntryL,G1H8(208),wf4(:,17),G1H2(1),m3h4x2(:,65),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(65),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H8(209),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,66),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(66),n2h2(66))
call HGT_raise_alpha_OLR(G1H8(210),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(210),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(210),ex7(:),G1H4(40),m3h2x4(:,40),heltab2x8(:,:,106))
  call Hloop_AZ_Q(ntryL,G1H8(215),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,67),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(67),n2h2(67))
  call Hloop_AZ_Q(ntryL,G1H8(220),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,68),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(68),n2h2(68))
call HGT_raise_alpha_OLR(G1H8(216),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(216),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(216),ex7(:),G1H4(41),m3h2x4(:,41),heltab2x8(:,:,109))
  call Hloop_AZ_Q(ntryL,G1H8(219),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,69),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(69),n2h2(69))
call HGT_raise_alpha_OLR(G1H8(221),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(221),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(221),ex7(:),G1H4(42),m3h2x4(:,42),heltab2x8(:,:,111))
  call Hloop_AZ_Q(ntryL,G1H8(224),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,70),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(70),n2h2(70))
  call Hloop_AV_Q(ntryL,G1H8(225),wf4(:,17),G1H2(1),m3h4x2(:,71),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(71),n2h2(71))
call HGT_raise_alpha_OLR(G1H8(226),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(226),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(226),ex7(:),G1H4(43),m3h2x4(:,43),heltab2x8(:,:,114))
  call Hloop_AV_Q(ntryL,G1H8(231),wf4(:,17),G1H2(1),m3h4x2(:,72),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(72),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H8(236),wf4(:,17),G1H2(1),m3h4x2(:,73),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(73),n2h2(73))
call HGT_raise_alpha_OLR(G1H8(232),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(232),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(232),ex7(:),G1H4(44),m3h2x4(:,44),heltab2x8(:,:,117))
  call Hloop_AV_Q(ntryL,G1H8(235),wf4(:,17),G1H2(1),m3h4x2(:,74),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(74),n2h2(74))
call HGT_raise_alpha_OLR(G1H8(237),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(237),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(237),ex7(:),G1H4(45),m3h2x4(:,45),heltab2x8(:,:,119))
  call Hloop_AV_Q(ntryL,G1H8(240),wf4(:,17),G1H2(1),m3h4x2(:,75),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(75),n2h2(75))
  call Hloop_AZ_Q(ntryL,G1H8(241),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,76),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(76),n2h2(76))
call HGT_raise_alpha_OLR(G1H8(242),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(242),ex7(:),G1H4(46),m3h2x4(:,46),heltab2x8(:,:,122))
  call Hloop_AZ_Q(ntryL,G1H8(247),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,77),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(77),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H8(252),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,78),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(78),n2h2(78))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(248),ex7(:),G1H4(47),m3h2x4(:,47),heltab2x8(:,:,125))
  call Hloop_AZ_Q(ntryL,G1H8(251),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,79),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(79),n2h2(79))
call HGT_raise_alpha_OLR(G1H8(253),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(253),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(253),ex7(:),G1H4(48),m3h2x4(:,48),heltab2x8(:,:,127))
  call Hloop_AZ_Q(ntryL,G1H8(256),wf4(:,20),G1H2(1),ngZd,m3h4x2(:,80),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(80),n2h2(80))
  call Hloop_AV_Q(ntryL,G1H8(257),wf4(:,12),G1H2(1),m3h4x2(:,81),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(81),n2h2(81))
call HGT_raise_alpha_OLR(G1H8(258),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(258),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(258),ex7(:),G1H4(49),m3h2x4(:,49),heltab2x8(:,:,130))
  call Hloop_AV_Q(ntryL,G1H8(263),wf4(:,12),G1H2(1),m3h4x2(:,82),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(82),n2h2(82))
  call Hloop_AV_Q(ntryL,G1H8(268),wf4(:,12),G1H2(1),m3h4x2(:,83),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(83),n2h2(83))
call HGT_raise_alpha_OLR(G1H8(264),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(264),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(264),ex7(:),G1H4(50),m3h2x4(:,50),heltab2x8(:,:,133))
  call Hloop_AV_Q(ntryL,G1H8(267),wf4(:,12),G1H2(1),m3h4x2(:,84),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(84),n2h2(84))
call HGT_raise_alpha_OLR(G1H8(269),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(269),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(269),ex7(:),G1H4(51),m3h2x4(:,51),heltab2x8(:,:,135))
  call Hloop_AV_Q(ntryL,G1H8(272),wf4(:,12),G1H2(1),m3h4x2(:,85),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(85),n2h2(85))
  call Hloop_AZ_Q(ntryL,G1H8(273),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,86),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(86),n2h2(86))
call HGT_raise_alpha_OLR(G1H8(274),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(274),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(274),ex7(:),G1H4(52),m3h2x4(:,52),heltab2x8(:,:,138))
  call Hloop_AZ_Q(ntryL,G1H8(279),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,87),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(87),n2h2(87))
  call Hloop_AZ_Q(ntryL,G1H8(284),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,88),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(88),n2h2(88))
call HGT_raise_alpha_OLR(G1H8(280),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(280),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(280),ex7(:),G1H4(53),m3h2x4(:,53),heltab2x8(:,:,141))
  call Hloop_AZ_Q(ntryL,G1H8(283),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,89),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(89),n2h2(89))
call HGT_raise_alpha_OLR(G1H8(285),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(285),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(285),ex7(:),G1H4(54),m3h2x4(:,54),heltab2x8(:,:,143))
  call Hloop_AZ_Q(ntryL,G1H8(288),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,90),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(90),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H8(289),wf4(:,12),G1H2(1),m3h4x2(:,91),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(91),n2h2(91))
call HGT_raise_alpha_OLR(G1H8(290),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(290),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(290),ex7(:),G1H4(55),m3h2x4(:,55),heltab2x8(:,:,146))
  call Hloop_AV_Q(ntryL,G1H8(295),wf4(:,12),G1H2(1),m3h4x2(:,92),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(92),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H8(300),wf4(:,12),G1H2(1),m3h4x2(:,93),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(93),n2h2(93))
call HGT_raise_alpha_OLR(G1H8(296),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(296),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(296),ex7(:),G1H4(56),m3h2x4(:,56),heltab2x8(:,:,149))
  call Hloop_AV_Q(ntryL,G1H8(299),wf4(:,12),G1H2(1),m3h4x2(:,94),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(94),n2h2(94))
call HGT_raise_alpha_OLR(G1H8(301),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(301),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(301),ex7(:),G1H4(57),m3h2x4(:,57),heltab2x8(:,:,151))
  call Hloop_AV_Q(ntryL,G1H8(304),wf4(:,12),G1H2(1),m3h4x2(:,95),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(95),n2h2(95))
  call Hloop_AZ_Q(ntryL,G1H8(305),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,96),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(96),n2h2(96))
call HGT_raise_alpha_OLR(G1H8(306),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(306),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(306),ex7(:),G1H4(58),m3h2x4(:,58),heltab2x8(:,:,154))
  call Hloop_AZ_Q(ntryL,G1H8(311),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,97),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(97),n2h2(97))
  call Hloop_AZ_Q(ntryL,G1H8(316),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,98),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(98),n2h2(98))
call HGT_raise_alpha_OLR(G1H8(312),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(312),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(312),ex7(:),G1H4(59),m3h2x4(:,59),heltab2x8(:,:,157))
  call Hloop_AZ_Q(ntryL,G1H8(315),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,99),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(99),n2h2(99))
call HGT_raise_alpha_OLR(G1H8(317),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(317),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(317),ex7(:),G1H4(60),m3h2x4(:,60),heltab2x8(:,:,159))
  call Hloop_AZ_Q(ntryL,G1H8(320),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,100),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(100),n2h2(100))
  call Hloop_AW_Q(ntryL,G1H8(321),wf4(:,5),G1H2(1),m3h4x2(:,101),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(101),n2h2(101))
call HGT_raise_alpha_OLR(G1H8(322),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(322),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(322),ex7(:),G1H4(61),m3h2x4(:,61),heltab2x8(:,:,162))
  call Hloop_AW_Q(ntryL,G1H8(327),wf4(:,5),G1H2(1),m3h4x2(:,102),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(102),n2h2(102))
  call Hloop_AW_Q(ntryL,G1H8(332),wf4(:,5),G1H2(1),m3h4x2(:,103),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(103),n2h2(103))
call HGT_raise_alpha_OLR(G1H8(328),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(328),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(328),ex7(:),G1H4(62),m3h2x4(:,62),heltab2x8(:,:,165))
  call Hloop_AW_Q(ntryL,G1H8(331),wf4(:,5),G1H2(1),m3h4x2(:,104),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(104),n2h2(104))
call HGT_raise_alpha_OLR(G1H8(333),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(333),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(333),ex7(:),G1H4(63),m3h2x4(:,63),heltab2x8(:,:,167))
  call Hloop_AW_Q(ntryL,G1H8(336),wf4(:,5),G1H2(1),m3h4x2(:,105),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(105),n2h2(105))
  call Hloop_AW_Q(ntryL,G1H8(337),wf4(:,5),G1H2(1),m3h4x2(:,106),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(106),n2h2(106))
call HGT_raise_alpha_OLR(G1H8(338),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(338),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(338),ex7(:),G1H4(64),m3h2x4(:,64),heltab2x8(:,:,170))
  call Hloop_AW_Q(ntryL,G1H8(343),wf4(:,5),G1H2(1),m3h4x2(:,107),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(107),n2h2(107))
  call Hloop_AW_Q(ntryL,G1H8(348),wf4(:,5),G1H2(1),m3h4x2(:,108),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(108),n2h2(108))
call HGT_raise_alpha_OLR(G1H8(344),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(344),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(344),ex7(:),G1H4(65),m3h2x4(:,65),heltab2x8(:,:,173))
  call Hloop_AW_Q(ntryL,G1H8(347),wf4(:,5),G1H2(1),m3h4x2(:,109),heltab2x8(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(109),n2h2(109))
call HGT_raise_alpha_OLR(G1H8(349),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(349),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(349),ex7(:),G1H4(66),m3h2x4(:,66),heltab2x8(:,:,175))
  call Hloop_AW_Q(ntryL,G1H8(352),wf4(:,5),G1H2(1),m3h4x2(:,110),heltab2x8(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(110),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H8(353),wf4(:,3),G1H2(1),m3h4x2(:,111),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(111),n2h2(111))
call HGT_raise_alpha_OLR(G1H8(354),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(354),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(354),ex7(:),G1H4(67),m3h2x4(:,67),heltab2x8(:,:,178))
  call Hloop_AV_Q(ntryL,G1H8(359),wf4(:,3),G1H2(1),m3h4x2(:,112),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(112),n2h2(112))
  call Hloop_AV_Q(ntryL,G1H8(364),wf4(:,3),G1H2(1),m3h4x2(:,113),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(113),n2h2(113))
call HGT_raise_alpha_OLR(G1H8(360),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(360),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(360),ex7(:),G1H4(68),m3h2x4(:,68),heltab2x8(:,:,181))
  call Hloop_AV_Q(ntryL,G1H8(363),wf4(:,3),G1H2(1),m3h4x2(:,114),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(114),n2h2(114))
call HGT_raise_alpha_OLR(G1H8(365),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(365),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(365),ex7(:),G1H4(69),m3h2x4(:,69),heltab2x8(:,:,183))
  call Hloop_AV_Q(ntryL,G1H8(368),wf4(:,3),G1H2(1),m3h4x2(:,115),heltab2x8(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(115),n2h2(115))
  call Hloop_AZ_Q(ntryL,G1H8(369),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,116),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(116),n2h2(116))
call HGT_raise_alpha_OLR(G1H8(370),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(370),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(370),ex7(:),G1H4(70),m3h2x4(:,70),heltab2x8(:,:,186))
  call Hloop_AZ_Q(ntryL,G1H8(375),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,117),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(117),n2h2(117))
  call Hloop_AZ_Q(ntryL,G1H8(380),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,118),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(118),n2h2(118))
call HGT_raise_alpha_OLR(G1H8(376),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(376),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(376),ex7(:),G1H4(71),m3h2x4(:,71),heltab2x8(:,:,189))
  call Hloop_AZ_Q(ntryL,G1H8(379),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,119),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(119),n2h2(119))
call HGT_raise_alpha_OLR(G1H8(381),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(381),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(381),ex7(:),G1H4(72),m3h2x4(:,72),heltab2x8(:,:,191))
  call Hloop_AZ_Q(ntryL,G1H8(384),wf4(:,10),G1H2(1),ngZd,m3h4x2(:,120),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(120),n2h2(120))
  call Hloop_AW_Q(ntryL,G1H8(385),wf4(:,13),G1H2(1),m3h4x2(:,121),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(121),n2h2(121))
call HGT_raise_alpha_OLR(G1H8(386),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(386),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(386),ex7(:),G1H4(73),m3h2x4(:,73),heltab2x8(:,:,194))
  call Hloop_AW_Q(ntryL,G1H8(391),wf4(:,13),G1H2(1),m3h4x2(:,122),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(122),n2h2(122))
  call Hloop_AW_Q(ntryL,G1H8(396),wf4(:,13),G1H2(1),m3h4x2(:,123),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(123),n2h2(123))
call HGT_raise_alpha_OLR(G1H8(392),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(392),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(392),ex7(:),G1H4(74),m3h2x4(:,74),heltab2x8(:,:,197))
  call Hloop_AW_Q(ntryL,G1H8(395),wf4(:,13),G1H2(1),m3h4x2(:,124),heltab2x8(:,:,198))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(124),n2h2(124))
call HGT_raise_alpha_OLR(G1H8(397),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(397),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(397),ex7(:),G1H4(75),m3h2x4(:,75),heltab2x8(:,:,199))
  call Hloop_AW_Q(ntryL,G1H8(400),wf4(:,13),G1H2(1),m3h4x2(:,125),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(125),n2h2(125))
  call Hloop_AW_Q(ntryL,G1H8(401),wf4(:,13),G1H2(1),m3h4x2(:,126),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(126),n2h2(126))
call HGT_raise_alpha_OLR(G1H8(402),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(402),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(402),ex7(:),G1H4(76),m3h2x4(:,76),heltab2x8(:,:,202))
  call Hloop_AW_Q(ntryL,G1H8(407),wf4(:,13),G1H2(1),m3h4x2(:,127),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(127),n2h2(127))
  call Hloop_AW_Q(ntryL,G1H8(412),wf4(:,13),G1H2(1),m3h4x2(:,128),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(128),n2h2(128))
call HGT_raise_alpha_OLR(G1H8(408),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(408),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(408),ex7(:),G1H4(77),m3h2x4(:,77),heltab2x8(:,:,205))
  call Hloop_AW_Q(ntryL,G1H8(411),wf4(:,13),G1H2(1),m3h4x2(:,129),heltab2x8(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(129),n2h2(129))
call HGT_raise_alpha_OLR(G1H8(413),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(413),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(413),ex7(:),G1H4(78),m3h2x4(:,78),heltab2x8(:,:,207))
  call Hloop_AW_Q(ntryL,G1H8(416),wf4(:,13),G1H2(1),m3h4x2(:,130),heltab2x8(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(130),n2h2(130))
  call Hloop_AV_Q(ntryL,G1H8(417),wf4(:,12),G1H2(1),m3h4x2(:,131),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(131),n2h2(131))
call HGT_raise_alpha_OLR(G1H8(418),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(418),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(418),ex7(:),G1H4(79),m3h2x4(:,79),heltab2x8(:,:,210))
  call Hloop_AV_Q(ntryL,G1H8(423),wf4(:,12),G1H2(1),m3h4x2(:,132),heltab2x8(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(132),n2h2(132))
  call Hloop_AV_Q(ntryL,G1H8(428),wf4(:,12),G1H2(1),m3h4x2(:,133),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(133),n2h2(133))
call HGT_raise_alpha_OLR(G1H8(424),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(424),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(424),ex7(:),G1H4(80),m3h2x4(:,80),heltab2x8(:,:,213))
  call Hloop_AV_Q(ntryL,G1H8(427),wf4(:,12),G1H2(1),m3h4x2(:,134),heltab2x8(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(134),n2h2(134))
call HGT_raise_alpha_OLR(G1H8(429),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(429),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(429),ex7(:),G1H4(81),m3h2x4(:,81),heltab2x8(:,:,215))
  call Hloop_AV_Q(ntryL,G1H8(432),wf4(:,12),G1H2(1),m3h4x2(:,135),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(135),n2h2(135))
  call Hloop_AZ_Q(ntryL,G1H8(433),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,136),heltab2x8(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(136),n2h2(136))
call HGT_raise_alpha_OLR(G1H8(434),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(434),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(434),ex7(:),G1H4(82),m3h2x4(:,82),heltab2x8(:,:,218))
  call Hloop_AZ_Q(ntryL,G1H8(439),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,137),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(137),n2h2(137))
  call Hloop_AZ_Q(ntryL,G1H8(444),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,138),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(138),n2h2(138))
call HGT_raise_alpha_OLR(G1H8(440),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(440),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(440),ex7(:),G1H4(83),m3h2x4(:,83),heltab2x8(:,:,221))
  call Hloop_AZ_Q(ntryL,G1H8(443),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,139),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(139),n2h2(139))
call HGT_raise_alpha_OLR(G1H8(445),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(445),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(445),ex7(:),G1H4(84),m3h2x4(:,84),heltab2x8(:,:,223))
  call Hloop_AZ_Q(ntryL,G1H8(448),wf4(:,15),G1H2(1),ngZd,m3h4x2(:,140),heltab2x8(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(140),n2h2(140))
  call Hloop_AW_Q(ntryL,G1H8(449),wf4(:,5),G1H2(1),m3h4x2(:,141),heltab2x8(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(1),191,nMB,G2H2(141),n2h2(141))
call HGT_raise_alpha_OLR(G1H8(450),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(450),2,5,8)



end subroutine vamp_1

end module ol_vamp_1_eellllbb_nenexeeexexbbx_1_/**/REALKIND
