
! **********************************************************************
module ol_tables_storage_eellllbb_nenmxeexexmbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(256,830)
integer(intkind2), save :: heltab2x2(2,2,46)
integer(intkind2), save :: heltab2x4(2,4,60)
integer(intkind2), save :: heltab2x8(2,8,190)
integer(intkind2), save :: heltab2x16(2,16,42)
integer(intkind2), save :: heltab2x32(2,32,354)
integer(intkind2), save :: heltab2x128(2,128,562)
integer(intkind2), save :: heltab2x256(2,256,830)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(830)
integer(intkind2), save :: m3h2x1(3,46)
integer(intkind2), save :: m3h4x1(3,60)
integer(intkind2), save :: m3h8x1(3,36)
integer(intkind2), save :: m3h16x1(3,32)
integer(intkind2), save :: m3h32x1(3,84)
integer(intkind2), save :: m3h4x2(3,116)
integer(intkind2), save :: m3h16x2(3,128)
integer(intkind2), save :: m3h64x2(3,318)
integer(intkind2), save :: m3h2x4(3,38)
integer(intkind2), save :: m3h4x4(3,10)
integer(intkind2), save :: m3h8x4(3,10)
integer(intkind2), save :: m3h4x8(3,90)
integer(intkind2), save :: m3h16x8(3,104)
integer(intkind2), save :: m3h32x8(3,128)
integer(intkind2), save :: m3h2x16(3,42)
integer(intkind2), save :: m3h4x32(3,140)
integer(intkind2), save :: m3h8x32(3,140)
integer(intkind2), save :: m3h2x128(3,562)

integer(intkind2), save :: n2h1(102)
integer(intkind2), save :: n2h2(562)
integer(intkind2), save :: n2h4(10)
integer(intkind2), save :: n2h8(360)
integer(intkind2), save :: n2h32(320)
integer(intkind2), save :: n2h128(562)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h64x2(1,:)=64
m3h64x2(2,:)=2
m3h64x2(3,:)=128
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h16x8(1,:)=16
m3h16x8(2,:)=8
m3h16x8(3,:)=128
m3h32x8(1,:)=32
m3h32x8(2,:)=8
m3h32x8(3,:)=256
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h8x32(1,:)=8
m3h8x32(2,:)=32
m3h8x32(3,:)=256
m3h2x128(1,:)=2
m3h2x128(2,:)=128
m3h2x128(3,:)=256

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h32(:)=32
n2h128(:)=128


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_eellllbb_nenmxeexexmbbx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_eellllbb_nenmxeexexmbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(1)
  type(hol), save :: G2H2(416)
  type(hol), save :: G1H4(66)
  type(hol), save :: G2H4(10)
  type(hol), save :: G0H8(1)
  type(hol), save :: G1H8(128)
  type(hol), save :: G2H8(72)
  type(hol), save :: G1H16(32)
  type(hol), save :: G0H32(13)
  type(hol), save :: G1H32(210)
  type(hol), save :: G2H32(64)
  type(hol), save :: G0H128(1)
  type(hol), save :: G1H128(434)
  type(hol), save :: G0H256(1)
  type(hcl), save, dimension(213) :: G0tensor
  type(hcl), save, dimension(125) :: G1tensor
  type(hcl), save, dimension(169) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(51)
type (redset4),    save :: RedSet_4(31)
type (redset5),    save :: RedSet_5(6)
integer, save :: mass2set(0:1,4)
integer, save :: mass3set(0:2,10)
integer, save :: mass4set(0:3,9)
integer, save :: mass5set(0:4,3)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(4)
  integer, save :: momenta_61(4)
  integer, save :: momenta_62(4)
  integer, save :: momenta_63(4)
  integer, save :: momenta_64(4)
  integer, save :: momenta_65(4)
  integer, save :: momenta_66(4)
  integer, save :: momenta_67(4)
  integer, save :: momenta_68(4)
  integer, save :: momenta_69(4)
  integer, save :: momenta_70(4)
  integer, save :: momenta_71(4)
  integer, save :: momenta_72(4)
  integer, save :: momenta_73(4)
  integer, save :: momenta_74(4)
  integer, save :: momenta_75(4)
  integer, save :: momenta_76(4)
  integer, save :: momenta_77(4)
  integer, save :: momenta_78(4)
  integer, save :: momenta_79(4)
  integer, save :: momenta_80(4)
  integer, save :: momenta_81(4)
  integer, save :: momenta_82(4)
  integer, save :: momenta_83(4)
  integer, save :: momenta_84(4)
  integer, save :: momenta_85(5)
  integer, save :: momenta_86(5)
  integer, save :: momenta_87(5)
  integer, save :: momenta_88(5)
  integer, save :: momenta_89(5)
  integer, save :: momenta_90(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(3)
  integer, save :: masses2_10(3)
  integer, save :: masses2_11(3)
  integer, save :: masses2_12(3)
  integer, save :: masses2_13(3)
  integer, save :: masses2_14(3)
  integer, save :: masses2_15(3)
  integer, save :: masses2_16(3)
  integer, save :: masses2_17(3)
  integer, save :: masses2_18(3)
  integer, save :: masses2_19(4)
  integer, save :: masses2_20(4)
  integer, save :: masses2_21(4)
  integer, save :: masses2_22(4)
  integer, save :: masses2_23(4)
  integer, save :: masses2_24(4)
  integer, save :: masses2_25(4)
  integer, save :: masses2_26(4)
  integer, save :: masses2_27(4)
  integer, save :: masses2_28(4)
  integer, save :: masses2_29(4)
  integer, save :: masses2_30(5)
  integer, save :: masses2_31(5)
  integer, save :: masses2_32(5)

type(scalarbox), save :: ScalarBoxes(25)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)
integer, save :: sbarray_4(5)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)

  type(hcl), save, dimension(90) :: T0sum
  type(hcl), save, dimension(6) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_eellllbb_nenmxeexexmbbx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,1)
  call hol_allocation(4,15,4,2,G2H2,416)
  call hol_allocation(4,5,4,4,G1H4,66)
  call hol_allocation(4,15,4,4,G2H4,10)
  call hol_allocation(4,1,4,8,G0H8,1)
  call hol_allocation(4,5,4,8,G1H8,128)
  call hol_allocation(4,15,4,8,G2H8,72)
  call hol_allocation(4,5,4,16,G1H16,32)
  call hol_allocation(4,1,4,32,G0H32,13)
  call hol_allocation(4,5,4,32,G1H32,210)
  call hol_allocation(4,15,4,32,G2H32,64)
  call hol_allocation(4,1,4,128,G0H128,1)
  call hol_allocation(4,5,4,128,G1H128,434)
  call hol_allocation(4,1,4,256,G0H256,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_eellllbb_nenmxeexexmbbx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,1)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,416)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,66)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,10)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,1)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,128)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,72)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,32)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,13)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,210)
  call hol_allocation(4,15,4,min(nhel,32),G2H32,64)
  call hol_allocation(4,1,4,min(nhel,128),G0H128,1)
  call hol_allocation(4,5,4,min(nhel,128),G1H128,434)
  call hol_allocation(4,1,4,min(nhel,256),G0H256,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,1,dmode)
  call hol_deallocation(G2H2,416,dmode)
  call hol_deallocation(G1H4,66,dmode)
  call hol_deallocation(G2H4,10,dmode)
  call hol_deallocation(G0H8,1,dmode)
  call hol_deallocation(G1H8,128,dmode)
  call hol_deallocation(G2H8,72,dmode)
  call hol_deallocation(G1H16,32,dmode)
  call hol_deallocation(G0H32,13,dmode)
  call hol_deallocation(G1H32,210,dmode)
  call hol_deallocation(G2H32,64,dmode)
  call hol_deallocation(G0H128,1,dmode)
  call hol_deallocation(G1H128,434,dmode)
  call hol_deallocation(G0H256,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 213)
call hcl_allocation(5,G1tensor, 125)
call hcl_allocation(15,G2tensor, 169)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 213,dmode)
call hcl_deallocation(G1tensor, 125,dmode)
call hcl_deallocation(G2tensor, 169,dmode)

    call hcl_deallocation(T0sum,90,dmode)
  call hcl_deallocation(T1sum,6,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,90)
  call hcl_allocation(5,T1sum,6)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_eellllbb_nenmxeexexmbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_eellllbb_nenmxeexexmbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,90
    call init_hcl(T0sum(i))
  end do
  do i = 1,6
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, -2)
  call scale_one_tsum(T1sum(2)%cmp, -2)
  call scale_one_tsum(T1sum(3)%cmp, -2)
  call scale_one_tsum(T1sum(4)%cmp, -2)
  call scale_one_tsum(T1sum(5)%cmp, -2)
  call scale_one_tsum(T1sum(6)%cmp, -2)
  call scale_one_tsum(T0sum(1)%cmp, -4)
  call scale_one_tsum(T0sum(2)%cmp, -4)
  call scale_one_tsum(T0sum(3)%cmp, -4)
  call scale_one_tsum(T0sum(4)%cmp, -4)
  call scale_one_tsum(T0sum(5)%cmp, -4)
  call scale_one_tsum(T0sum(6)%cmp, -4)
  call scale_one_tsum(T0sum(7)%cmp, -4)
  call scale_one_tsum(T0sum(8)%cmp, -4)
  call scale_one_tsum(T0sum(9)%cmp, -4)
  call scale_one_tsum(T0sum(10)%cmp, -4)
  call scale_one_tsum(T0sum(11)%cmp, -4)
  call scale_one_tsum(T0sum(12)%cmp, -4)
  call scale_one_tsum(T0sum(13)%cmp, -4)
  call scale_one_tsum(T0sum(14)%cmp, -4)
  call scale_one_tsum(T0sum(15)%cmp, -4)
  call scale_one_tsum(T0sum(16)%cmp, -4)
  call scale_one_tsum(T0sum(17)%cmp, -4)
  call scale_one_tsum(T0sum(18)%cmp, -4)
  call scale_one_tsum(T0sum(19)%cmp, -4)
  call scale_one_tsum(T0sum(20)%cmp, -4)
  call scale_one_tsum(T0sum(21)%cmp, -4)
  call scale_one_tsum(T0sum(22)%cmp, -4)
  call scale_one_tsum(T0sum(23)%cmp, -4)
  call scale_one_tsum(T0sum(24)%cmp, -4)
  call scale_one_tsum(T0sum(25)%cmp, -4)
  call scale_one_tsum(T0sum(26)%cmp, -6)
  call scale_one_tsum(T0sum(27)%cmp, -6)
  call scale_one_tsum(T0sum(28)%cmp, -6)
  call scale_one_tsum(T0sum(29)%cmp, -6)
  call scale_one_tsum(T0sum(30)%cmp, -6)
  call scale_one_tsum(T0sum(31)%cmp, -6)
  call scale_one_tsum(T0sum(32)%cmp, -6)
  call scale_one_tsum(T0sum(33)%cmp, -6)
  call scale_one_tsum(T0sum(34)%cmp, -6)
  call scale_one_tsum(T0sum(35)%cmp, -6)
  call scale_one_tsum(T0sum(36)%cmp, -6)
  call scale_one_tsum(T0sum(37)%cmp, -6)
  call scale_one_tsum(T0sum(38)%cmp, -6)
  call scale_one_tsum(T0sum(39)%cmp, -6)
  call scale_one_tsum(T0sum(40)%cmp, -6)
  call scale_one_tsum(T0sum(41)%cmp, -6)
  call scale_one_tsum(T0sum(42)%cmp, -6)
  call scale_one_tsum(T0sum(43)%cmp, -6)
  call scale_one_tsum(T0sum(44)%cmp, -6)
  call scale_one_tsum(T0sum(45)%cmp, -6)
  call scale_one_tsum(T0sum(46)%cmp, -6)
  call scale_one_tsum(T0sum(47)%cmp, -6)
  call scale_one_tsum(T0sum(48)%cmp, -6)
  call scale_one_tsum(T0sum(49)%cmp, -6)
  call scale_one_tsum(T0sum(50)%cmp, -6)
  call scale_one_tsum(T0sum(51)%cmp, -6)
  call scale_one_tsum(T0sum(52)%cmp, -6)
  call scale_one_tsum(T0sum(53)%cmp, -6)
  call scale_one_tsum(T0sum(54)%cmp, -6)
  call scale_one_tsum(T0sum(55)%cmp, -6)
  call scale_one_tsum(T0sum(56)%cmp, -6)
  call scale_one_tsum(T0sum(57)%cmp, -6)
  call scale_one_tsum(T0sum(58)%cmp, -6)
  call scale_one_tsum(T0sum(59)%cmp, -6)
  call scale_one_tsum(T0sum(60)%cmp, -6)
  call scale_one_tsum(T0sum(61)%cmp, -6)
  call scale_one_tsum(T0sum(62)%cmp, -6)
  call scale_one_tsum(T0sum(63)%cmp, -6)
  call scale_one_tsum(T0sum(64)%cmp, -8)
  call scale_one_tsum(T0sum(65)%cmp, -8)
  call scale_one_tsum(T0sum(66)%cmp, -8)
  call scale_one_tsum(T0sum(67)%cmp, -8)
  call scale_one_tsum(T0sum(68)%cmp, -8)
  call scale_one_tsum(T0sum(69)%cmp, -8)
  call scale_one_tsum(T0sum(70)%cmp, -8)
  call scale_one_tsum(T0sum(71)%cmp, -8)
  call scale_one_tsum(T0sum(72)%cmp, -8)
  call scale_one_tsum(T0sum(73)%cmp, -8)
  call scale_one_tsum(T0sum(74)%cmp, -8)
  call scale_one_tsum(T0sum(75)%cmp, -8)
  call scale_one_tsum(T0sum(76)%cmp, -8)
  call scale_one_tsum(T0sum(77)%cmp, -8)
  call scale_one_tsum(T0sum(78)%cmp, -8)
  call scale_one_tsum(T0sum(79)%cmp, -8)
  call scale_one_tsum(T0sum(80)%cmp, -8)
  call scale_one_tsum(T0sum(81)%cmp, -8)
  call scale_one_tsum(T0sum(82)%cmp, -8)
  call scale_one_tsum(T0sum(83)%cmp, -8)
  call scale_one_tsum(T0sum(84)%cmp, -8)
  call scale_one_tsum(T0sum(85)%cmp, -8)
  call scale_one_tsum(T0sum(86)%cmp, -8)
  call scale_one_tsum(T0sum(87)%cmp, -8)
  call scale_one_tsum(T0sum(88)%cmp, -8)
  call scale_one_tsum(T0sum(89)%cmp, -8)
  call scale_one_tsum(T0sum(90)%cmp, -8)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 128, 127 ]
  momenta_3 = [ 140, 115 ]
  momenta_4 = [ 148, 107 ]
  momenta_5 = [ 162, 93 ]
  momenta_6 = [ 171, 84 ]
  momenta_7 = [ 174, 81 ]
  momenta_8 = [ 179, 76 ]
  momenta_9 = [ 182, 73 ]
  momenta_10 = [ 191, 64 ]
  momenta_11 = [ 192, 63 ]
  momenta_12 = [ 201, 54 ]
  momenta_13 = [ 204, 51 ]
  momenta_14 = [ 209, 46 ]
  momenta_15 = [ 212, 43 ]
  momenta_16 = [ 221, 34 ]
  momenta_17 = [ 226, 29 ]
  momenta_18 = [ 235, 20 ]
  momenta_19 = [ 238, 17 ]
  momenta_20 = [ 243, 12 ]
  momenta_21 = [ 246, 9 ]
  momenta_22 = [ 128, 12, 115 ]
  momenta_23 = [ 128, 20, 107 ]
  momenta_24 = [ 128, 34, 93 ]
  momenta_25 = [ 128, 43, 84 ]
  momenta_26 = [ 128, 46, 81 ]
  momenta_27 = [ 128, 51, 76 ]
  momenta_28 = [ 128, 54, 73 ]
  momenta_29 = [ 128, 63, 64 ]
  momenta_30 = [ 140, 34, 81 ]
  momenta_31 = [ 140, 51, 64 ]
  momenta_32 = [ 148, 34, 73 ]
  momenta_33 = [ 148, 43, 64 ]
  momenta_34 = [ 162, 9, 84 ]
  momenta_35 = [ 162, 12, 81 ]
  momenta_36 = [ 162, 17, 76 ]
  momenta_37 = [ 162, 20, 73 ]
  momenta_38 = [ 162, 29, 64 ]
  momenta_39 = [ 171, 20, 64 ]
  momenta_40 = [ 174, 17, 64 ]
  momenta_41 = [ 179, 12, 64 ]
  momenta_42 = [ 182, 9, 64 ]
  momenta_43 = [ 192, 12, 51 ]
  momenta_44 = [ 192, 20, 43 ]
  momenta_45 = [ 192, 34, 29 ]
  momenta_46 = [ 192, 43, 20 ]
  momenta_47 = [ 192, 46, 17 ]
  momenta_48 = [ 192, 51, 12 ]
  momenta_49 = [ 192, 54, 9 ]
  momenta_50 = [ 201, 20, 34 ]
  momenta_51 = [ 201, 34, 20 ]
  momenta_52 = [ 204, 34, 17 ]
  momenta_53 = [ 209, 12, 34 ]
  momenta_54 = [ 209, 34, 12 ]
  momenta_55 = [ 212, 34, 9 ]
  momenta_56 = [ 226, 9, 20 ]
  momenta_57 = [ 226, 12, 17 ]
  momenta_58 = [ 226, 17, 12 ]
  momenta_59 = [ 226, 20, 9 ]
  momenta_60 = [ 128, 12, 34, 81 ]
  momenta_61 = [ 128, 12, 51, 64 ]
  momenta_62 = [ 128, 20, 34, 73 ]
  momenta_63 = [ 128, 20, 43, 64 ]
  momenta_64 = [ 128, 34, 9, 84 ]
  momenta_65 = [ 128, 34, 12, 81 ]
  momenta_66 = [ 128, 34, 17, 76 ]
  momenta_67 = [ 128, 34, 20, 73 ]
  momenta_68 = [ 128, 34, 29, 64 ]
  momenta_69 = [ 128, 43, 20, 64 ]
  momenta_70 = [ 128, 46, 17, 64 ]
  momenta_71 = [ 128, 51, 12, 64 ]
  momenta_72 = [ 128, 54, 9, 64 ]
  momenta_73 = [ 140, 34, 17, 64 ]
  momenta_74 = [ 148, 34, 9, 64 ]
  momenta_75 = [ 162, 9, 20, 64 ]
  momenta_76 = [ 162, 12, 17, 64 ]
  momenta_77 = [ 162, 17, 12, 64 ]
  momenta_78 = [ 162, 20, 9, 64 ]
  momenta_79 = [ 192, 12, 34, 17 ]
  momenta_80 = [ 192, 20, 34, 9 ]
  momenta_81 = [ 192, 34, 9, 20 ]
  momenta_82 = [ 192, 34, 12, 17 ]
  momenta_83 = [ 192, 34, 17, 12 ]
  momenta_84 = [ 192, 34, 20, 9 ]
  momenta_85 = [ 128, 12, 34, 17, 64 ]
  momenta_86 = [ 128, 20, 34, 9, 64 ]
  momenta_87 = [ 128, 34, 9, 20, 64 ]
  momenta_88 = [ 128, 34, 12, 17, 64 ]
  momenta_89 = [ 128, 34, 17, 12, 64 ]
  momenta_90 = [ 128, 34, 20, 9, 64 ]

  masses2_1 = [ nMB, 0 ]
  masses2_2 = [ nMT, 0 ]
  masses2_3 = [ 0, nMB ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMB ]
  masses2_6 = [ 0, nMT ]
  masses2_7 = [ nMB, nMT ]
  masses2_8 = [ nMT, nMT ]
  masses2_9 = [ 0, nMB, nMB ]
  masses2_10 = [ nMB, nMB, nMB ]
  masses2_11 = [ nMT, nMB, nMB ]
  masses2_12 = [ 0, nMB, nMT ]
  masses2_13 = [ nMB, nMB, nMT ]
  masses2_14 = [ nMT, nMB, nMT ]
  masses2_15 = [ 0, nMT, nMB ]
  masses2_16 = [ nMB, nMT, nMB ]
  masses2_17 = [ 0, nMT, nMT ]
  masses2_18 = [ nMB, nMT, nMT ]
  masses2_19 = [ 0, nMB, nMB, nMB ]
  masses2_20 = [ 0, nMB, nMB, nMT ]
  masses2_21 = [ nMB, nMB, nMB, nMT ]
  masses2_22 = [ 0, nMB, nMT, nMB ]
  masses2_23 = [ nMB, nMB, nMT, nMB ]
  masses2_24 = [ 0, nMB, nMT, nMT ]
  masses2_25 = [ nMB, nMB, nMT, nMT ]
  masses2_26 = [ 0, nMT, nMB, nMB ]
  masses2_27 = [ nMB, nMT, nMB, nMB ]
  masses2_28 = [ 0, nMT, nMT, nMB ]
  masses2_29 = [ nMB, nMT, nMT, nMB ]
  masses2_30 = [ 0, nMB, nMB, nMT, nMB ]
  masses2_31 = [ 0, nMB, nMT, nMB, nMB ]
  masses2_32 = [ 0, nMB, nMT, nMT, nMB ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 2, 7, 8, 9]
sbarray_3 = [10, 11, 3, 12, 13]
sbarray_4 = [14, 15, 3, 16, 17]
sbarray_5 = [18, 15, 19, 20, 21]
sbarray_6 = [22, 23, 3, 24, 25]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_67, masses2_24, T0sum(1), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_62, masses2_20, T0sum(2), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_64, masses2_22, T0sum(3), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_65, masses2_24, T0sum(4), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_60, masses2_20, T0sum(5), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_66, masses2_22, T0sum(6), M2,[24], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_84, masses2_25, T0sum(7), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_78, masses2_28, T0sum(8), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_72, masses2_22, T0sum(9), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_22, T0sum(10), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_80, masses2_21, T0sum(11), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_74, masses2_22, T0sum(12), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_63, masses2_19, T0sum(13), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_81, masses2_23, T0sum(14), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_75, masses2_26, T0sum(15), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_69, masses2_19, T0sum(16), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_82, masses2_25, T0sum(17), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_76, masses2_28, T0sum(18), M2,[14], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_22, T0sum(19), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_79, masses2_21, T0sum(20), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_73, masses2_22, T0sum(21), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_61, masses2_19, T0sum(22), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_83, masses2_23, T0sum(23), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_77, masses2_26, T0sum(24), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_19, T0sum(25), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_45, masses2_13, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_24, masses2_12, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_51, masses2_14, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_44, masses2_10, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_23, masses2_9, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_50, masses2_11, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_55, masses2_13, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_54, masses2_14, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_43, masses2_10, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_22, masses2_9, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_53, masses2_11, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_52, masses2_13, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_37, masses2_17, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_28, masses2_12, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_32, masses2_12, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_34, masses2_15, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_25, masses2_9, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_35, masses2_17, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_26, masses2_12, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_30, masses2_12, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_36, masses2_15, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_27, masses2_9, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_59, masses2_18, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_49, masses2_13, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_42, masses2_15, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_38, masses2_15, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_29, masses2_9, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_33, masses2_9, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_56, masses2_16, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_46, masses2_10, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_39, masses2_9, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_57, masses2_18, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_47, masses2_13, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_40, masses2_15, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_31, masses2_9, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_58, masses2_16, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_48, masses2_10, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_41, masses2_9, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_16, masses2_5, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_17, masses2_7, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_11, masses2_4, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_5, masses2_6, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_2, masses2_3, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_18, masses2_8, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_12, masses2_5, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_18, masses2_4, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_15, masses2_4, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_4, masses2_3, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_21, masses2_7, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_20, masses2_8, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_14, masses2_5, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_20, masses2_4, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_13, masses2_4, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_3, masses2_3, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_19, masses2_7, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_9, masses2_6, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_6, masses2_3, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_7, masses2_6, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_8, masses2_3, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_10, masses2_3, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_5, masses2_2, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(90), M2)

  call TI_call_OL(0,1, momenta_90, masses2_32, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_86, masses2_30, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_87, masses2_31, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_88, masses2_32, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_85, masses2_30, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_89, masses2_31, T1sum(6), M2,sbarray_6, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_eellllbb_nenmxeexexmbbx_1_/**/REALKIND
