
! **********************************************************************
module ol_tables_storage_eellllbb_nenexeexmmxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(256,1513)
integer(intkind2), save :: heltab2x2(2,2,61)
integer(intkind2), save :: heltab2x4(2,4,113)
integer(intkind2), save :: heltab2x8(2,8,352)
integer(intkind2), save :: heltab2x16(2,16,84)
integer(intkind2), save :: heltab2x32(2,32,762)
integer(intkind2), save :: heltab2x128(2,128,900)
integer(intkind2), save :: heltab2x256(2,256,1513)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(1513)
integer(intkind2), save :: m3h2x1(3,61)
integer(intkind2), save :: m3h4x1(3,113)
integer(intkind2), save :: m3h8x1(3,65)
integer(intkind2), save :: m3h16x1(3,55)
integer(intkind2), save :: m3h32x1(3,168)
integer(intkind2), save :: m3h4x2(3,212)
integer(intkind2), save :: m3h16x2(3,220)
integer(intkind2), save :: m3h64x2(3,377)
integer(intkind2), save :: m3h2x4(3,75)
integer(intkind2), save :: m3h4x4(3,29)
integer(intkind2), save :: m3h8x4(3,29)
integer(intkind2), save :: m3h4x8(3,261)
integer(intkind2), save :: m3h16x8(3,194)
integer(intkind2), save :: m3h32x8(3,284)
integer(intkind2), save :: m3h2x16(3,84)
integer(intkind2), save :: m3h4x32(3,329)
integer(intkind2), save :: m3h8x32(3,329)
integer(intkind2), save :: m3h2x128(3,900)

integer(intkind2), save :: n2h1(197)
integer(intkind2), save :: n2h2(809)
integer(intkind2), save :: n2h4(29)
integer(intkind2), save :: n2h8(814)
integer(intkind2), save :: n2h32(726)
integer(intkind2), save :: n2h128(900)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h32x1(1,:)=32
m3h32x1(2,:)=1
m3h32x1(3,:)=32
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h64x2(1,:)=64
m3h64x2(2,:)=2
m3h64x2(3,:)=128
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h16x8(1,:)=16
m3h16x8(2,:)=8
m3h16x8(3,:)=128
m3h32x8(1,:)=32
m3h32x8(2,:)=8
m3h32x8(3,:)=256
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x32(1,:)=4
m3h4x32(2,:)=32
m3h4x32(3,:)=128
m3h8x32(1,:)=8
m3h8x32(2,:)=32
m3h8x32(3,:)=256
m3h2x128(1,:)=2
m3h2x128(2,:)=128
m3h2x128(3,:)=256

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h32(:)=32
n2h128(:)=128


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_eellllbb_nenexeexmmxbbx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_eellllbb_nenexeexmmxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(1)
  type(hol), save :: G2H2(542)
  type(hol), save :: G1H4(140)
  type(hol), save :: G2H4(29)
  type(hol), save :: G0H8(1)
  type(hol), save :: G1H8(272)
  type(hol), save :: G2H8(155)
  type(hol), save :: G1H16(55)
  type(hol), save :: G0H32(46)
  type(hol), save :: G1H32(420)
  type(hol), save :: G2H32(142)
  type(hol), save :: G0H128(1)
  type(hol), save :: G1H128(616)
  type(hol), save :: G0H256(1)
  type(hcl), save, dimension(238) :: G0tensor
  type(hcl), save, dimension(175) :: G1tensor
  type(hcl), save, dimension(302) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(62)
type (redset4),    save :: RedSet_4(44)
type (redset5),    save :: RedSet_5(9)
integer, save :: mass2set(0:1,4)
integer, save :: mass3set(0:2,10)
integer, save :: mass4set(0:3,10)
integer, save :: mass5set(0:4,4)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(4)
  integer, save :: momenta_69(4)
  integer, save :: momenta_70(4)
  integer, save :: momenta_71(4)
  integer, save :: momenta_72(4)
  integer, save :: momenta_73(4)
  integer, save :: momenta_74(4)
  integer, save :: momenta_75(4)
  integer, save :: momenta_76(4)
  integer, save :: momenta_77(4)
  integer, save :: momenta_78(4)
  integer, save :: momenta_79(4)
  integer, save :: momenta_80(4)
  integer, save :: momenta_81(4)
  integer, save :: momenta_82(4)
  integer, save :: momenta_83(4)
  integer, save :: momenta_84(4)
  integer, save :: momenta_85(4)
  integer, save :: momenta_86(4)
  integer, save :: momenta_87(4)
  integer, save :: momenta_88(4)
  integer, save :: momenta_89(4)
  integer, save :: momenta_90(4)
  integer, save :: momenta_91(4)
  integer, save :: momenta_92(4)
  integer, save :: momenta_93(4)
  integer, save :: momenta_94(4)
  integer, save :: momenta_95(4)
  integer, save :: momenta_96(4)
  integer, save :: momenta_97(4)
  integer, save :: momenta_98(4)
  integer, save :: momenta_99(4)
  integer, save :: momenta_100(4)
  integer, save :: momenta_101(4)
  integer, save :: momenta_102(4)
  integer, save :: momenta_103(5)
  integer, save :: momenta_104(5)
  integer, save :: momenta_105(5)
  integer, save :: momenta_106(5)
  integer, save :: momenta_107(5)
  integer, save :: momenta_108(5)
  integer, save :: momenta_109(5)
  integer, save :: momenta_110(5)
  integer, save :: momenta_111(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(3)
  integer, save :: masses2_10(3)
  integer, save :: masses2_11(3)
  integer, save :: masses2_12(3)
  integer, save :: masses2_13(3)
  integer, save :: masses2_14(3)
  integer, save :: masses2_15(3)
  integer, save :: masses2_16(3)
  integer, save :: masses2_17(3)
  integer, save :: masses2_18(3)
  integer, save :: masses2_19(4)
  integer, save :: masses2_20(4)
  integer, save :: masses2_21(4)
  integer, save :: masses2_22(4)
  integer, save :: masses2_23(4)
  integer, save :: masses2_24(4)
  integer, save :: masses2_25(4)
  integer, save :: masses2_26(4)
  integer, save :: masses2_27(4)
  integer, save :: masses2_28(4)
  integer, save :: masses2_29(4)
  integer, save :: masses2_30(4)
  integer, save :: masses2_31(5)
  integer, save :: masses2_32(5)
  integer, save :: masses2_33(5)
  integer, save :: masses2_34(5)

type(scalarbox), save :: ScalarBoxes(35)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)
integer, save :: sbarray_4(5)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)

  type(hcl), save, dimension(108) :: T0sum
  type(hcl), save, dimension(9) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_eellllbb_nenexeexmmxbbx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,1)
  call hol_allocation(4,15,4,2,G2H2,542)
  call hol_allocation(4,5,4,4,G1H4,140)
  call hol_allocation(4,15,4,4,G2H4,29)
  call hol_allocation(4,1,4,8,G0H8,1)
  call hol_allocation(4,5,4,8,G1H8,272)
  call hol_allocation(4,15,4,8,G2H8,155)
  call hol_allocation(4,5,4,16,G1H16,55)
  call hol_allocation(4,1,4,32,G0H32,46)
  call hol_allocation(4,5,4,32,G1H32,420)
  call hol_allocation(4,15,4,32,G2H32,142)
  call hol_allocation(4,1,4,128,G0H128,1)
  call hol_allocation(4,5,4,128,G1H128,616)
  call hol_allocation(4,1,4,256,G0H256,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_eellllbb_nenexeexmmxbbx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,1)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,542)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,140)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,29)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,1)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,272)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,155)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,55)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,46)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,420)
  call hol_allocation(4,15,4,min(nhel,32),G2H32,142)
  call hol_allocation(4,1,4,min(nhel,128),G0H128,1)
  call hol_allocation(4,5,4,min(nhel,128),G1H128,616)
  call hol_allocation(4,1,4,min(nhel,256),G0H256,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,1,dmode)
  call hol_deallocation(G2H2,542,dmode)
  call hol_deallocation(G1H4,140,dmode)
  call hol_deallocation(G2H4,29,dmode)
  call hol_deallocation(G0H8,1,dmode)
  call hol_deallocation(G1H8,272,dmode)
  call hol_deallocation(G2H8,155,dmode)
  call hol_deallocation(G1H16,55,dmode)
  call hol_deallocation(G0H32,46,dmode)
  call hol_deallocation(G1H32,420,dmode)
  call hol_deallocation(G2H32,142,dmode)
  call hol_deallocation(G0H128,1,dmode)
  call hol_deallocation(G1H128,616,dmode)
  call hol_deallocation(G0H256,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 238)
call hcl_allocation(5,G1tensor, 175)
call hcl_allocation(15,G2tensor, 302)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 238,dmode)
call hcl_deallocation(G1tensor, 175,dmode)
call hcl_deallocation(G2tensor, 302,dmode)

    call hcl_deallocation(T0sum,108,dmode)
  call hcl_deallocation(T1sum,9,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,108)
  call hcl_allocation(5,T1sum,9)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_eellllbb_nenexeexmmxbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_eellllbb_nenexeexmmxbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,108
    call init_hcl(T0sum(i))
  end do
  do i = 1,9
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, -2)
  call scale_one_tsum(T1sum(2)%cmp, -2)
  call scale_one_tsum(T1sum(3)%cmp, -2)
  call scale_one_tsum(T1sum(4)%cmp, -2)
  call scale_one_tsum(T1sum(5)%cmp, -2)
  call scale_one_tsum(T1sum(6)%cmp, -2)
  call scale_one_tsum(T1sum(7)%cmp, -2)
  call scale_one_tsum(T1sum(8)%cmp, -2)
  call scale_one_tsum(T1sum(9)%cmp, -2)
  call scale_one_tsum(T0sum(1)%cmp, -4)
  call scale_one_tsum(T0sum(2)%cmp, -4)
  call scale_one_tsum(T0sum(3)%cmp, -4)
  call scale_one_tsum(T0sum(4)%cmp, -4)
  call scale_one_tsum(T0sum(5)%cmp, -4)
  call scale_one_tsum(T0sum(6)%cmp, -4)
  call scale_one_tsum(T0sum(7)%cmp, -4)
  call scale_one_tsum(T0sum(8)%cmp, -4)
  call scale_one_tsum(T0sum(9)%cmp, -4)
  call scale_one_tsum(T0sum(10)%cmp, -4)
  call scale_one_tsum(T0sum(11)%cmp, -4)
  call scale_one_tsum(T0sum(12)%cmp, -4)
  call scale_one_tsum(T0sum(13)%cmp, -4)
  call scale_one_tsum(T0sum(14)%cmp, -4)
  call scale_one_tsum(T0sum(15)%cmp, -4)
  call scale_one_tsum(T0sum(16)%cmp, -4)
  call scale_one_tsum(T0sum(17)%cmp, -4)
  call scale_one_tsum(T0sum(18)%cmp, -4)
  call scale_one_tsum(T0sum(19)%cmp, -4)
  call scale_one_tsum(T0sum(20)%cmp, -4)
  call scale_one_tsum(T0sum(21)%cmp, -4)
  call scale_one_tsum(T0sum(22)%cmp, -4)
  call scale_one_tsum(T0sum(23)%cmp, -4)
  call scale_one_tsum(T0sum(24)%cmp, -4)
  call scale_one_tsum(T0sum(25)%cmp, -4)
  call scale_one_tsum(T0sum(26)%cmp, -4)
  call scale_one_tsum(T0sum(27)%cmp, -4)
  call scale_one_tsum(T0sum(28)%cmp, -4)
  call scale_one_tsum(T0sum(29)%cmp, -4)
  call scale_one_tsum(T0sum(30)%cmp, -4)
  call scale_one_tsum(T0sum(31)%cmp, -4)
  call scale_one_tsum(T0sum(32)%cmp, -4)
  call scale_one_tsum(T0sum(33)%cmp, -4)
  call scale_one_tsum(T0sum(34)%cmp, -4)
  call scale_one_tsum(T0sum(35)%cmp, -4)
  call scale_one_tsum(T0sum(36)%cmp, -6)
  call scale_one_tsum(T0sum(37)%cmp, -6)
  call scale_one_tsum(T0sum(38)%cmp, -6)
  call scale_one_tsum(T0sum(39)%cmp, -6)
  call scale_one_tsum(T0sum(40)%cmp, -6)
  call scale_one_tsum(T0sum(41)%cmp, -6)
  call scale_one_tsum(T0sum(42)%cmp, -6)
  call scale_one_tsum(T0sum(43)%cmp, -6)
  call scale_one_tsum(T0sum(44)%cmp, -6)
  call scale_one_tsum(T0sum(45)%cmp, -6)
  call scale_one_tsum(T0sum(46)%cmp, -6)
  call scale_one_tsum(T0sum(47)%cmp, -6)
  call scale_one_tsum(T0sum(48)%cmp, -6)
  call scale_one_tsum(T0sum(49)%cmp, -6)
  call scale_one_tsum(T0sum(50)%cmp, -6)
  call scale_one_tsum(T0sum(51)%cmp, -6)
  call scale_one_tsum(T0sum(52)%cmp, -6)
  call scale_one_tsum(T0sum(53)%cmp, -6)
  call scale_one_tsum(T0sum(54)%cmp, -6)
  call scale_one_tsum(T0sum(55)%cmp, -6)
  call scale_one_tsum(T0sum(56)%cmp, -6)
  call scale_one_tsum(T0sum(57)%cmp, -6)
  call scale_one_tsum(T0sum(58)%cmp, -6)
  call scale_one_tsum(T0sum(59)%cmp, -6)
  call scale_one_tsum(T0sum(60)%cmp, -6)
  call scale_one_tsum(T0sum(61)%cmp, -6)
  call scale_one_tsum(T0sum(62)%cmp, -6)
  call scale_one_tsum(T0sum(63)%cmp, -6)
  call scale_one_tsum(T0sum(64)%cmp, -6)
  call scale_one_tsum(T0sum(65)%cmp, -6)
  call scale_one_tsum(T0sum(66)%cmp, -6)
  call scale_one_tsum(T0sum(67)%cmp, -6)
  call scale_one_tsum(T0sum(68)%cmp, -6)
  call scale_one_tsum(T0sum(69)%cmp, -6)
  call scale_one_tsum(T0sum(70)%cmp, -6)
  call scale_one_tsum(T0sum(71)%cmp, -6)
  call scale_one_tsum(T0sum(72)%cmp, -6)
  call scale_one_tsum(T0sum(73)%cmp, -6)
  call scale_one_tsum(T0sum(74)%cmp, -6)
  call scale_one_tsum(T0sum(75)%cmp, -6)
  call scale_one_tsum(T0sum(76)%cmp, -6)
  call scale_one_tsum(T0sum(77)%cmp, -6)
  call scale_one_tsum(T0sum(78)%cmp, -6)
  call scale_one_tsum(T0sum(79)%cmp, -6)
  call scale_one_tsum(T0sum(80)%cmp, -6)
  call scale_one_tsum(T0sum(81)%cmp, -8)
  call scale_one_tsum(T0sum(82)%cmp, -8)
  call scale_one_tsum(T0sum(83)%cmp, -8)
  call scale_one_tsum(T0sum(84)%cmp, -8)
  call scale_one_tsum(T0sum(85)%cmp, -8)
  call scale_one_tsum(T0sum(86)%cmp, -8)
  call scale_one_tsum(T0sum(87)%cmp, -8)
  call scale_one_tsum(T0sum(88)%cmp, -8)
  call scale_one_tsum(T0sum(89)%cmp, -8)
  call scale_one_tsum(T0sum(90)%cmp, -8)
  call scale_one_tsum(T0sum(91)%cmp, -8)
  call scale_one_tsum(T0sum(92)%cmp, -8)
  call scale_one_tsum(T0sum(93)%cmp, -8)
  call scale_one_tsum(T0sum(94)%cmp, -8)
  call scale_one_tsum(T0sum(95)%cmp, -8)
  call scale_one_tsum(T0sum(96)%cmp, -8)
  call scale_one_tsum(T0sum(97)%cmp, -8)
  call scale_one_tsum(T0sum(98)%cmp, -8)
  call scale_one_tsum(T0sum(99)%cmp, -8)
  call scale_one_tsum(T0sum(100)%cmp, -8)
  call scale_one_tsum(T0sum(101)%cmp, -8)
  call scale_one_tsum(T0sum(102)%cmp, -8)
  call scale_one_tsum(T0sum(103)%cmp, -8)
  call scale_one_tsum(T0sum(104)%cmp, -8)
  call scale_one_tsum(T0sum(105)%cmp, -8)
  call scale_one_tsum(T0sum(106)%cmp, -8)
  call scale_one_tsum(T0sum(107)%cmp, -8)
  call scale_one_tsum(T0sum(108)%cmp, -8)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 128, 127 ]
  momenta_3 = [ 131, 124 ]
  momenta_4 = [ 134, 121 ]
  momenta_5 = [ 140, 115 ]
  momenta_6 = [ 143, 112 ]
  momenta_7 = [ 176, 79 ]
  momenta_8 = [ 179, 76 ]
  momenta_9 = [ 182, 73 ]
  momenta_10 = [ 188, 67 ]
  momenta_11 = [ 191, 64 ]
  momenta_12 = [ 192, 63 ]
  momenta_13 = [ 195, 60 ]
  momenta_14 = [ 198, 57 ]
  momenta_15 = [ 201, 54 ]
  momenta_16 = [ 204, 51 ]
  momenta_17 = [ 207, 48 ]
  momenta_18 = [ 240, 15 ]
  momenta_19 = [ 243, 12 ]
  momenta_20 = [ 246, 9 ]
  momenta_21 = [ 249, 6 ]
  momenta_22 = [ 252, 3 ]
  momenta_23 = [ 128, 3, 124 ]
  momenta_24 = [ 128, 6, 121 ]
  momenta_25 = [ 128, 12, 115 ]
  momenta_26 = [ 128, 15, 112 ]
  momenta_27 = [ 128, 48, 79 ]
  momenta_28 = [ 128, 51, 76 ]
  momenta_29 = [ 128, 54, 73 ]
  momenta_30 = [ 128, 60, 67 ]
  momenta_31 = [ 128, 63, 64 ]
  momenta_32 = [ 131, 12, 112 ]
  momenta_33 = [ 131, 48, 76 ]
  momenta_34 = [ 131, 60, 64 ]
  momenta_35 = [ 134, 9, 112 ]
  momenta_36 = [ 134, 48, 73 ]
  momenta_37 = [ 134, 57, 64 ]
  momenta_38 = [ 140, 3, 112 ]
  momenta_39 = [ 140, 48, 67 ]
  momenta_40 = [ 140, 51, 64 ]
  momenta_41 = [ 143, 48, 64 ]
  momenta_42 = [ 176, 3, 76 ]
  momenta_43 = [ 176, 6, 73 ]
  momenta_44 = [ 176, 12, 67 ]
  momenta_45 = [ 176, 15, 64 ]
  momenta_46 = [ 179, 12, 64 ]
  momenta_47 = [ 182, 9, 64 ]
  momenta_48 = [ 188, 3, 64 ]
  momenta_49 = [ 192, 3, 60 ]
  momenta_50 = [ 192, 6, 57 ]
  momenta_51 = [ 192, 12, 51 ]
  momenta_52 = [ 192, 15, 48 ]
  momenta_53 = [ 192, 48, 15 ]
  momenta_54 = [ 192, 51, 12 ]
  momenta_55 = [ 192, 54, 9 ]
  momenta_56 = [ 192, 60, 3 ]
  momenta_57 = [ 195, 12, 48 ]
  momenta_58 = [ 195, 48, 12 ]
  momenta_59 = [ 198, 9, 48 ]
  momenta_60 = [ 198, 48, 9 ]
  momenta_61 = [ 201, 6, 48 ]
  momenta_62 = [ 201, 48, 6 ]
  momenta_63 = [ 204, 3, 48 ]
  momenta_64 = [ 204, 48, 3 ]
  momenta_65 = [ 240, 3, 12 ]
  momenta_66 = [ 240, 6, 9 ]
  momenta_67 = [ 240, 12, 3 ]
  momenta_68 = [ 128, 3, 12, 112 ]
  momenta_69 = [ 128, 3, 48, 76 ]
  momenta_70 = [ 128, 3, 60, 64 ]
  momenta_71 = [ 128, 6, 9, 112 ]
  momenta_72 = [ 128, 6, 48, 73 ]
  momenta_73 = [ 128, 6, 57, 64 ]
  momenta_74 = [ 128, 12, 3, 112 ]
  momenta_75 = [ 128, 12, 48, 67 ]
  momenta_76 = [ 128, 12, 51, 64 ]
  momenta_77 = [ 128, 15, 48, 64 ]
  momenta_78 = [ 128, 48, 3, 76 ]
  momenta_79 = [ 128, 48, 6, 73 ]
  momenta_80 = [ 128, 48, 12, 67 ]
  momenta_81 = [ 128, 48, 15, 64 ]
  momenta_82 = [ 128, 51, 12, 64 ]
  momenta_83 = [ 128, 54, 9, 64 ]
  momenta_84 = [ 128, 60, 3, 64 ]
  momenta_85 = [ 131, 12, 48, 64 ]
  momenta_86 = [ 131, 48, 12, 64 ]
  momenta_87 = [ 134, 9, 48, 64 ]
  momenta_88 = [ 134, 48, 9, 64 ]
  momenta_89 = [ 140, 3, 48, 64 ]
  momenta_90 = [ 140, 48, 3, 64 ]
  momenta_91 = [ 176, 3, 12, 64 ]
  momenta_92 = [ 176, 6, 9, 64 ]
  momenta_93 = [ 176, 12, 3, 64 ]
  momenta_94 = [ 192, 3, 12, 48 ]
  momenta_95 = [ 192, 3, 48, 12 ]
  momenta_96 = [ 192, 6, 9, 48 ]
  momenta_97 = [ 192, 6, 48, 9 ]
  momenta_98 = [ 192, 12, 3, 48 ]
  momenta_99 = [ 192, 12, 48, 3 ]
  momenta_100 = [ 192, 48, 3, 12 ]
  momenta_101 = [ 192, 48, 6, 9 ]
  momenta_102 = [ 192, 48, 12, 3 ]
  momenta_103 = [ 128, 3, 12, 48, 64 ]
  momenta_104 = [ 128, 3, 48, 12, 64 ]
  momenta_105 = [ 128, 6, 9, 48, 64 ]
  momenta_106 = [ 128, 6, 48, 9, 64 ]
  momenta_107 = [ 128, 12, 3, 48, 64 ]
  momenta_108 = [ 128, 12, 48, 3, 64 ]
  momenta_109 = [ 128, 48, 3, 12, 64 ]
  momenta_110 = [ 128, 48, 6, 9, 64 ]
  momenta_111 = [ 128, 48, 12, 3, 64 ]

  masses2_1 = [ nMB, 0 ]
  masses2_2 = [ nMT, 0 ]
  masses2_3 = [ 0, nMB ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMB ]
  masses2_6 = [ 0, nMT ]
  masses2_7 = [ nMB, nMT ]
  masses2_8 = [ nMT, nMT ]
  masses2_9 = [ 0, nMB, nMB ]
  masses2_10 = [ nMB, nMB, nMB ]
  masses2_11 = [ nMT, nMB, nMB ]
  masses2_12 = [ 0, nMB, nMT ]
  masses2_13 = [ nMB, nMB, nMT ]
  masses2_14 = [ nMT, nMB, nMT ]
  masses2_15 = [ 0, nMT, nMB ]
  masses2_16 = [ nMB, nMT, nMB ]
  masses2_17 = [ 0, nMT, nMT ]
  masses2_18 = [ nMB, nMT, nMT ]
  masses2_19 = [ 0, nMB, nMB, nMB ]
  masses2_20 = [ nMB, nMB, nMB, nMB ]
  masses2_21 = [ 0, nMB, nMB, nMT ]
  masses2_22 = [ nMB, nMB, nMB, nMT ]
  masses2_23 = [ 0, nMB, nMT, nMB ]
  masses2_24 = [ nMB, nMB, nMT, nMB ]
  masses2_25 = [ 0, nMB, nMT, nMT ]
  masses2_26 = [ nMB, nMB, nMT, nMT ]
  masses2_27 = [ 0, nMT, nMB, nMB ]
  masses2_28 = [ nMB, nMT, nMB, nMB ]
  masses2_29 = [ 0, nMT, nMT, nMB ]
  masses2_30 = [ nMB, nMT, nMT, nMB ]
  masses2_31 = [ 0, nMB, nMB, nMB, nMB ]
  masses2_32 = [ 0, nMB, nMB, nMT, nMB ]
  masses2_33 = [ 0, nMB, nMT, nMB, nMB ]
  masses2_34 = [ 0, nMB, nMT, nMT, nMB ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 2, 7, 8, 9]
sbarray_3 = [10, 11, 12, 13, 14]
sbarray_4 = [15, 11, 7, 16, 17]
sbarray_5 = [18, 19, 12, 20, 21]
sbarray_6 = [22, 19, 3, 23, 24]
sbarray_7 = [25, 26, 27, 28, 29]
sbarray_8 = [30, 26, 7, 31, 32]
sbarray_9 = [33, 19, 27, 34, 35]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_75, masses2_19, T0sum(1), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_80, masses2_19, T0sum(2), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_69, masses2_19, T0sum(3), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_78, masses2_19, T0sum(4), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_19, T0sum(5), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_74, masses2_19, T0sum(6), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_72, masses2_25, T0sum(7), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_79, masses2_21, T0sum(8), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_23, T0sum(9), M2,[34], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_99, masses2_20, T0sum(10), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_90, masses2_19, T0sum(11), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_84, masses2_19, T0sum(12), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_76, masses2_19, T0sum(13), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_102, masses2_20, T0sum(14), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_93, masses2_19, T0sum(15), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_81, masses2_19, T0sum(16), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_95, masses2_20, T0sum(17), M2,[14], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_86, masses2_19, T0sum(18), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_82, masses2_19, T0sum(19), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_19, T0sum(20), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_100, masses2_20, T0sum(21), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_91, masses2_19, T0sum(22), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_94, masses2_20, T0sum(23), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_85, masses2_19, T0sum(24), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_77, masses2_19, T0sum(25), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_98, masses2_20, T0sum(26), M2,[24], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_89, masses2_19, T0sum(27), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_97, masses2_26, T0sum(28), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_88, masses2_29, T0sum(29), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_83, masses2_23, T0sum(30), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_73, masses2_23, T0sum(31), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_101, masses2_22, T0sum(32), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_92, masses2_23, T0sum(33), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_96, masses2_24, T0sum(34), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_87, masses2_27, T0sum(35), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_51, masses2_10, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_25, masses2_9, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_57, masses2_10, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_53, masses2_10, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_27, masses2_9, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_58, masses2_10, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_49, masses2_10, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_23, masses2_9, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_63, masses2_10, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_64, masses2_10, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_65, masses2_10, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_67, masses2_10, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_50, masses2_13, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_24, masses2_12, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_61, masses2_14, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_62, masses2_11, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_66, masses2_13, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_39, masses2_9, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_30, masses2_9, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_44, masses2_9, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_33, masses2_9, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_28, masses2_9, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_42, masses2_9, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_32, masses2_9, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_26, masses2_9, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_38, masses2_9, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_36, masses2_17, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_29, masses2_12, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_43, masses2_12, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_35, masses2_15, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_56, masses2_10, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_48, masses2_9, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_40, masses2_9, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_31, masses2_9, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_45, masses2_9, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_54, masses2_10, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_46, masses2_9, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_34, masses2_9, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_52, masses2_10, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_41, masses2_9, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_60, masses2_18, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_55, masses2_13, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_47, masses2_15, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_37, masses2_15, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_59, masses2_16, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_19, masses2_4, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_16, masses2_4, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_12, masses2_4, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_5, masses2_3, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_2, masses2_3, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_17, masses2_4, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_13, masses2_4, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_18, masses2_4, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_7, masses2_3, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_22, masses2_4, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_3, masses2_3, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_21, masses2_5, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_14, masses2_7, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_4, masses2_6, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_17, masses2_8, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_15, masses2_5, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_20, masses2_7, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_10, masses2_3, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_8, masses2_3, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_6, masses2_3, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_9, masses2_6, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_11, masses2_3, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_4, masses2_2, T0sum(108), M2)

  call TI_call_OL(0,1, momenta_108, masses2_31, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_111, masses2_31, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_104, masses2_31, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_109, masses2_31, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_103, masses2_31, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_107, masses2_31, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_106, masses2_34, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_110, masses2_32, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_105, masses2_33, T1sum(9), M2,sbarray_9, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_eellllbb_nenexeexmmxbbx_1_/**/REALKIND
