
module ol_external_eellllbb_nenexeexmmxbbxg_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_eellllbb_nenexeexmmxbbxg_1(9) = &
                     [ (dummy_counter, dummy_counter = 1, 9) ]
  integer, save :: external_perm_inv_eellllbb_nenexeexmmxbbxg_1(9) = &
                     [ (dummy_counter, dummy_counter = 1, 9) ]
  integer, save :: extcomb_perm_eellllbb_nenexeexmmxbbxg_1(0:46) = &
                     [ (dummy_counter, dummy_counter = 0, 46) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_eellllbb_nenexeexmmxbbxg_1(9) = &
                     [ 1, 2, 3, 4, 5, 6, 7, 8, 9 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_eellllbb_nenexeexmmxbbxg_1(9) = &
                     [ 2, 2, 2, 2, 2, 2, 6, 6, 16 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_eellllbb_nenexeexmmxbbxg_1 = &
                     4
  integer, save :: channel_number_eellllbb_nenexeexmmxbbxg_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(9,512) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(512,9)
  integer, save :: POLSEL(9) = 0
  integer, save :: photonid_eellllbb_nenexeexmmxbbxg_1(9) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_eellllbb_nenexeexmmxbbxg_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 9
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_eellllbb_nenexeexmmxbbxg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 9
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_eellllbb_nenexeexmmxbbxg_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(9)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_eellllbb_nenexeexmmxbbxg_1(9)
    external_perm_eellllbb_nenexeexmmxbbxg_1 = perm
    do i = 1, 9
      external_perm_inv_eellllbb_nenexeexmmxbbxg_1( &
        external_perm_eellllbb_nenexeexmmxbbxg_1(i)) = i
      particle_types_perm_eellllbb_nenexeexmmxbbxg_1(i) = &
        particle_types_eellllbb_nenexeexmmxbbxg_1( &
        external_perm_eellllbb_nenexeexmmxbbxg_1(i))
    end do
    do i = 1, 9
      do j = 1, i
        if (external_perm_eellllbb_nenexeexmmxbbxg_1(i) >= &
          external_perm_eellllbb_nenexeexmmxbbxg_1(j)) then
          ii = external_perm_eellllbb_nenexeexmmxbbxg_1(i)
          jj = external_perm_eellllbb_nenexeexmmxbbxg_1(j)
        else
          ii = external_perm_eellllbb_nenexeexmmxbbxg_1(j)
          jj = external_perm_eellllbb_nenexeexmmxbbxg_1(i)
        end if
        extcomb_perm_eellllbb_nenexeexmmxbbxg_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_eellllbb_nenexeexmmxbbxg_1 = 1
    do i = 1, n_scatt
      average_factor_eellllbb_nenexeexmmxbbxg_1 = &
        average_factor_eellllbb_nenexeexmmxbbxg_1 &
        * average_factors_eellllbb_nenexeexmmxbbxg_1( &
        external_perm_eellllbb_nenexeexmmxbbxg_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 9
        average_factor_eellllbb_nenexeexmmxbbxg_1 = &
          average_factor_eellllbb_nenexeexmmxbbxg_1 &
          * factorial(count(particle_types_perm_eellllbb_nenexeexmmxbbxg_1(n_scatt+1:9) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_eellllbb_nenexeexmmxbbxg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(9)
    integer :: f_perm(9)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_eellllbb_nenexeexmmxbbxg_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(9)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(9)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rZERO, rZERO, rZERO, rZERO, rMM_unscaled, rMM_unscaled, rMB_unscaled, rMB_unscaled, rZERO ]
    do i = 1, 9
      m_ex(i) = m_ex_orig(external_perm_eellllbb_nenexeexmmxbbxg_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_eellllbb_nenexeexmmxbbxg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(9)
    real(DREALKIND) :: f_m_ex(9)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_eellllbb_nenexeexmmxbbxg_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,9)
    real(DREALKIND) :: m_ex(9)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_eellllbb_nenexeexmmxbbxg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,9)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,9)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:,  1) = [ -1, -1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,  2) = [ -1, -1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,  3) = [ -1, -1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,  4) = [ -1, -1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,  5) = [ -1, -1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,  6) = [ -1, -1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,  7) = [ -1, -1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,  8) = [ -1, -1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,  9) = [ -1, -1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:, 10) = [ -1, -1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:, 11) = [ -1, -1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:, 12) = [ -1, -1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:, 13) = [ -1, -1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:, 14) = [ -1, -1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:, 15) = [ -1, -1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:, 16) = [ -1, -1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:, 17) = [ -1, -1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:, 18) = [ -1, -1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:, 19) = [ -1, -1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:, 20) = [ -1, -1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:, 21) = [ -1, -1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:, 22) = [ -1, -1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:, 23) = [ -1, -1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:, 24) = [ -1, -1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:, 25) = [ -1, -1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:, 26) = [ -1, -1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:, 27) = [ -1, -1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:, 28) = [ -1, -1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:, 29) = [ -1, -1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:, 30) = [ -1, -1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:, 31) = [ -1, -1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:, 32) = [ -1, -1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:, 33) = [ -1, -1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:, 34) = [ -1, -1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:, 35) = [ -1, -1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:, 36) = [ -1, -1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:, 37) = [ -1, -1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:, 38) = [ -1, -1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:, 39) = [ -1, -1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:, 40) = [ -1, -1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:, 41) = [ -1, -1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:, 42) = [ -1, -1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:, 43) = [ -1, -1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:, 44) = [ -1, -1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:, 45) = [ -1, -1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:, 46) = [ -1, -1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:, 47) = [ -1, -1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:, 48) = [ -1, -1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:, 49) = [ -1, -1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:, 50) = [ -1, -1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:, 51) = [ -1, -1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:, 52) = [ -1, -1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:, 53) = [ -1, -1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:, 54) = [ -1, -1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:, 55) = [ -1, -1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:, 56) = [ -1, -1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:, 57) = [ -1, -1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:, 58) = [ -1, -1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:, 59) = [ -1, -1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:, 60) = [ -1, -1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:, 61) = [ -1, -1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:, 62) = [ -1, -1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:, 63) = [ -1, -1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:, 64) = [ -1, -1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:, 65) = [ -1, -1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:, 66) = [ -1, -1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:, 67) = [ -1, -1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:, 68) = [ -1, -1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:, 69) = [ -1, -1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:, 70) = [ -1, -1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:, 71) = [ -1, -1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:, 72) = [ -1, -1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:, 73) = [ -1, -1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:, 74) = [ -1, -1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:, 75) = [ -1, -1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:, 76) = [ -1, -1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:, 77) = [ -1, -1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:, 78) = [ -1, -1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:, 79) = [ -1, -1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:, 80) = [ -1, -1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:, 81) = [ -1, -1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:, 82) = [ -1, -1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:, 83) = [ -1, -1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:, 84) = [ -1, -1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:, 85) = [ -1, -1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:, 86) = [ -1, -1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:, 87) = [ -1, -1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:, 88) = [ -1, -1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:, 89) = [ -1, -1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:, 90) = [ -1, -1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:, 91) = [ -1, -1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:, 92) = [ -1, -1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:, 93) = [ -1, -1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:, 94) = [ -1, -1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:, 95) = [ -1, -1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:, 96) = [ -1, -1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:, 97) = [ -1, -1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:, 98) = [ -1, -1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:, 99) = [ -1, -1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,100) = [ -1, -1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,101) = [ -1, -1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,102) = [ -1, -1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,103) = [ -1, -1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,104) = [ -1, -1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,105) = [ -1, -1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,106) = [ -1, -1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,107) = [ -1, -1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,108) = [ -1, -1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,109) = [ -1, -1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,110) = [ -1, -1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,111) = [ -1, -1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,112) = [ -1, -1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,113) = [ -1, -1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,114) = [ -1, -1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,115) = [ -1, -1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,116) = [ -1, -1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,117) = [ -1, -1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,118) = [ -1, -1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,119) = [ -1, -1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,120) = [ -1, -1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,121) = [ -1, -1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,122) = [ -1, -1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,123) = [ -1, -1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,124) = [ -1, -1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,125) = [ -1, -1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,126) = [ -1, -1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,127) = [ -1, -1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,128) = [ -1, -1,  1,  1,  1,  1,  1,  1,  1 ]
  H(:,129) = [ -1,  1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,130) = [ -1,  1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,131) = [ -1,  1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,132) = [ -1,  1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,133) = [ -1,  1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,134) = [ -1,  1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,135) = [ -1,  1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,136) = [ -1,  1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,137) = [ -1,  1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:,138) = [ -1,  1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:,139) = [ -1,  1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:,140) = [ -1,  1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:,141) = [ -1,  1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:,142) = [ -1,  1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:,143) = [ -1,  1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:,144) = [ -1,  1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:,145) = [ -1,  1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:,146) = [ -1,  1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:,147) = [ -1,  1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:,148) = [ -1,  1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:,149) = [ -1,  1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:,150) = [ -1,  1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:,151) = [ -1,  1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:,152) = [ -1,  1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:,153) = [ -1,  1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:,154) = [ -1,  1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:,155) = [ -1,  1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:,156) = [ -1,  1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:,157) = [ -1,  1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:,158) = [ -1,  1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:,159) = [ -1,  1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:,160) = [ -1,  1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:,161) = [ -1,  1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:,162) = [ -1,  1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:,163) = [ -1,  1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:,164) = [ -1,  1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:,165) = [ -1,  1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:,166) = [ -1,  1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:,167) = [ -1,  1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:,168) = [ -1,  1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:,169) = [ -1,  1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:,170) = [ -1,  1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:,171) = [ -1,  1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:,172) = [ -1,  1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:,173) = [ -1,  1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:,174) = [ -1,  1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:,175) = [ -1,  1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:,176) = [ -1,  1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:,177) = [ -1,  1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:,178) = [ -1,  1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:,179) = [ -1,  1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:,180) = [ -1,  1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:,181) = [ -1,  1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:,182) = [ -1,  1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:,183) = [ -1,  1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:,184) = [ -1,  1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:,185) = [ -1,  1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:,186) = [ -1,  1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:,187) = [ -1,  1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:,188) = [ -1,  1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:,189) = [ -1,  1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:,190) = [ -1,  1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:,191) = [ -1,  1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:,192) = [ -1,  1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:,193) = [ -1,  1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:,194) = [ -1,  1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:,195) = [ -1,  1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:,196) = [ -1,  1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:,197) = [ -1,  1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:,198) = [ -1,  1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:,199) = [ -1,  1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:,200) = [ -1,  1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:,201) = [ -1,  1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:,202) = [ -1,  1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:,203) = [ -1,  1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:,204) = [ -1,  1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:,205) = [ -1,  1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:,206) = [ -1,  1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:,207) = [ -1,  1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:,208) = [ -1,  1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:,209) = [ -1,  1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:,210) = [ -1,  1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:,211) = [ -1,  1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:,212) = [ -1,  1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:,213) = [ -1,  1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:,214) = [ -1,  1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:,215) = [ -1,  1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:,216) = [ -1,  1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:,217) = [ -1,  1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:,218) = [ -1,  1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:,219) = [ -1,  1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:,220) = [ -1,  1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:,221) = [ -1,  1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:,222) = [ -1,  1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:,223) = [ -1,  1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:,224) = [ -1,  1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:,225) = [ -1,  1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:,226) = [ -1,  1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:,227) = [ -1,  1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,228) = [ -1,  1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,229) = [ -1,  1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,230) = [ -1,  1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,231) = [ -1,  1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,232) = [ -1,  1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,233) = [ -1,  1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,234) = [ -1,  1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,235) = [ -1,  1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,236) = [ -1,  1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,237) = [ -1,  1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,238) = [ -1,  1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,239) = [ -1,  1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,240) = [ -1,  1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,241) = [ -1,  1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,242) = [ -1,  1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,243) = [ -1,  1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,244) = [ -1,  1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,245) = [ -1,  1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,246) = [ -1,  1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,247) = [ -1,  1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,248) = [ -1,  1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,249) = [ -1,  1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,250) = [ -1,  1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,251) = [ -1,  1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,252) = [ -1,  1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,253) = [ -1,  1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,254) = [ -1,  1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,255) = [ -1,  1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,256) = [ -1,  1,  1,  1,  1,  1,  1,  1,  1 ]
  H(:,257) = [  1, -1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,258) = [  1, -1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,259) = [  1, -1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,260) = [  1, -1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,261) = [  1, -1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,262) = [  1, -1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,263) = [  1, -1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,264) = [  1, -1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,265) = [  1, -1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:,266) = [  1, -1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:,267) = [  1, -1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:,268) = [  1, -1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:,269) = [  1, -1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:,270) = [  1, -1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:,271) = [  1, -1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:,272) = [  1, -1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:,273) = [  1, -1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:,274) = [  1, -1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:,275) = [  1, -1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:,276) = [  1, -1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:,277) = [  1, -1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:,278) = [  1, -1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:,279) = [  1, -1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:,280) = [  1, -1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:,281) = [  1, -1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:,282) = [  1, -1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:,283) = [  1, -1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:,284) = [  1, -1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:,285) = [  1, -1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:,286) = [  1, -1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:,287) = [  1, -1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:,288) = [  1, -1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:,289) = [  1, -1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:,290) = [  1, -1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:,291) = [  1, -1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:,292) = [  1, -1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:,293) = [  1, -1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:,294) = [  1, -1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:,295) = [  1, -1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:,296) = [  1, -1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:,297) = [  1, -1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:,298) = [  1, -1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:,299) = [  1, -1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:,300) = [  1, -1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:,301) = [  1, -1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:,302) = [  1, -1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:,303) = [  1, -1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:,304) = [  1, -1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:,305) = [  1, -1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:,306) = [  1, -1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:,307) = [  1, -1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:,308) = [  1, -1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:,309) = [  1, -1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:,310) = [  1, -1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:,311) = [  1, -1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:,312) = [  1, -1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:,313) = [  1, -1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:,314) = [  1, -1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:,315) = [  1, -1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:,316) = [  1, -1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:,317) = [  1, -1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:,318) = [  1, -1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:,319) = [  1, -1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:,320) = [  1, -1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:,321) = [  1, -1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:,322) = [  1, -1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:,323) = [  1, -1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:,324) = [  1, -1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:,325) = [  1, -1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:,326) = [  1, -1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:,327) = [  1, -1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:,328) = [  1, -1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:,329) = [  1, -1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:,330) = [  1, -1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:,331) = [  1, -1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:,332) = [  1, -1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:,333) = [  1, -1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:,334) = [  1, -1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:,335) = [  1, -1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:,336) = [  1, -1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:,337) = [  1, -1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:,338) = [  1, -1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:,339) = [  1, -1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:,340) = [  1, -1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:,341) = [  1, -1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:,342) = [  1, -1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:,343) = [  1, -1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:,344) = [  1, -1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:,345) = [  1, -1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:,346) = [  1, -1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:,347) = [  1, -1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:,348) = [  1, -1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:,349) = [  1, -1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:,350) = [  1, -1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:,351) = [  1, -1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:,352) = [  1, -1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:,353) = [  1, -1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:,354) = [  1, -1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:,355) = [  1, -1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,356) = [  1, -1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,357) = [  1, -1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,358) = [  1, -1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,359) = [  1, -1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,360) = [  1, -1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,361) = [  1, -1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,362) = [  1, -1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,363) = [  1, -1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,364) = [  1, -1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,365) = [  1, -1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,366) = [  1, -1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,367) = [  1, -1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,368) = [  1, -1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,369) = [  1, -1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,370) = [  1, -1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,371) = [  1, -1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,372) = [  1, -1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,373) = [  1, -1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,374) = [  1, -1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,375) = [  1, -1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,376) = [  1, -1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,377) = [  1, -1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,378) = [  1, -1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,379) = [  1, -1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,380) = [  1, -1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,381) = [  1, -1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,382) = [  1, -1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,383) = [  1, -1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,384) = [  1, -1,  1,  1,  1,  1,  1,  1,  1 ]
  H(:,385) = [  1,  1, -1, -1, -1, -1, -1, -1, -1 ]
  H(:,386) = [  1,  1, -1, -1, -1, -1, -1, -1,  1 ]
  H(:,387) = [  1,  1, -1, -1, -1, -1, -1,  1, -1 ]
  H(:,388) = [  1,  1, -1, -1, -1, -1, -1,  1,  1 ]
  H(:,389) = [  1,  1, -1, -1, -1, -1,  1, -1, -1 ]
  H(:,390) = [  1,  1, -1, -1, -1, -1,  1, -1,  1 ]
  H(:,391) = [  1,  1, -1, -1, -1, -1,  1,  1, -1 ]
  H(:,392) = [  1,  1, -1, -1, -1, -1,  1,  1,  1 ]
  H(:,393) = [  1,  1, -1, -1, -1,  1, -1, -1, -1 ]
  H(:,394) = [  1,  1, -1, -1, -1,  1, -1, -1,  1 ]
  H(:,395) = [  1,  1, -1, -1, -1,  1, -1,  1, -1 ]
  H(:,396) = [  1,  1, -1, -1, -1,  1, -1,  1,  1 ]
  H(:,397) = [  1,  1, -1, -1, -1,  1,  1, -1, -1 ]
  H(:,398) = [  1,  1, -1, -1, -1,  1,  1, -1,  1 ]
  H(:,399) = [  1,  1, -1, -1, -1,  1,  1,  1, -1 ]
  H(:,400) = [  1,  1, -1, -1, -1,  1,  1,  1,  1 ]
  H(:,401) = [  1,  1, -1, -1,  1, -1, -1, -1, -1 ]
  H(:,402) = [  1,  1, -1, -1,  1, -1, -1, -1,  1 ]
  H(:,403) = [  1,  1, -1, -1,  1, -1, -1,  1, -1 ]
  H(:,404) = [  1,  1, -1, -1,  1, -1, -1,  1,  1 ]
  H(:,405) = [  1,  1, -1, -1,  1, -1,  1, -1, -1 ]
  H(:,406) = [  1,  1, -1, -1,  1, -1,  1, -1,  1 ]
  H(:,407) = [  1,  1, -1, -1,  1, -1,  1,  1, -1 ]
  H(:,408) = [  1,  1, -1, -1,  1, -1,  1,  1,  1 ]
  H(:,409) = [  1,  1, -1, -1,  1,  1, -1, -1, -1 ]
  H(:,410) = [  1,  1, -1, -1,  1,  1, -1, -1,  1 ]
  H(:,411) = [  1,  1, -1, -1,  1,  1, -1,  1, -1 ]
  H(:,412) = [  1,  1, -1, -1,  1,  1, -1,  1,  1 ]
  H(:,413) = [  1,  1, -1, -1,  1,  1,  1, -1, -1 ]
  H(:,414) = [  1,  1, -1, -1,  1,  1,  1, -1,  1 ]
  H(:,415) = [  1,  1, -1, -1,  1,  1,  1,  1, -1 ]
  H(:,416) = [  1,  1, -1, -1,  1,  1,  1,  1,  1 ]
  H(:,417) = [  1,  1, -1,  1, -1, -1, -1, -1, -1 ]
  H(:,418) = [  1,  1, -1,  1, -1, -1, -1, -1,  1 ]
  H(:,419) = [  1,  1, -1,  1, -1, -1, -1,  1, -1 ]
  H(:,420) = [  1,  1, -1,  1, -1, -1, -1,  1,  1 ]
  H(:,421) = [  1,  1, -1,  1, -1, -1,  1, -1, -1 ]
  H(:,422) = [  1,  1, -1,  1, -1, -1,  1, -1,  1 ]
  H(:,423) = [  1,  1, -1,  1, -1, -1,  1,  1, -1 ]
  H(:,424) = [  1,  1, -1,  1, -1, -1,  1,  1,  1 ]
  H(:,425) = [  1,  1, -1,  1, -1,  1, -1, -1, -1 ]
  H(:,426) = [  1,  1, -1,  1, -1,  1, -1, -1,  1 ]
  H(:,427) = [  1,  1, -1,  1, -1,  1, -1,  1, -1 ]
  H(:,428) = [  1,  1, -1,  1, -1,  1, -1,  1,  1 ]
  H(:,429) = [  1,  1, -1,  1, -1,  1,  1, -1, -1 ]
  H(:,430) = [  1,  1, -1,  1, -1,  1,  1, -1,  1 ]
  H(:,431) = [  1,  1, -1,  1, -1,  1,  1,  1, -1 ]
  H(:,432) = [  1,  1, -1,  1, -1,  1,  1,  1,  1 ]
  H(:,433) = [  1,  1, -1,  1,  1, -1, -1, -1, -1 ]
  H(:,434) = [  1,  1, -1,  1,  1, -1, -1, -1,  1 ]
  H(:,435) = [  1,  1, -1,  1,  1, -1, -1,  1, -1 ]
  H(:,436) = [  1,  1, -1,  1,  1, -1, -1,  1,  1 ]
  H(:,437) = [  1,  1, -1,  1,  1, -1,  1, -1, -1 ]
  H(:,438) = [  1,  1, -1,  1,  1, -1,  1, -1,  1 ]
  H(:,439) = [  1,  1, -1,  1,  1, -1,  1,  1, -1 ]
  H(:,440) = [  1,  1, -1,  1,  1, -1,  1,  1,  1 ]
  H(:,441) = [  1,  1, -1,  1,  1,  1, -1, -1, -1 ]
  H(:,442) = [  1,  1, -1,  1,  1,  1, -1, -1,  1 ]
  H(:,443) = [  1,  1, -1,  1,  1,  1, -1,  1, -1 ]
  H(:,444) = [  1,  1, -1,  1,  1,  1, -1,  1,  1 ]
  H(:,445) = [  1,  1, -1,  1,  1,  1,  1, -1, -1 ]
  H(:,446) = [  1,  1, -1,  1,  1,  1,  1, -1,  1 ]
  H(:,447) = [  1,  1, -1,  1,  1,  1,  1,  1, -1 ]
  H(:,448) = [  1,  1, -1,  1,  1,  1,  1,  1,  1 ]
  H(:,449) = [  1,  1,  1, -1, -1, -1, -1, -1, -1 ]
  H(:,450) = [  1,  1,  1, -1, -1, -1, -1, -1,  1 ]
  H(:,451) = [  1,  1,  1, -1, -1, -1, -1,  1, -1 ]
  H(:,452) = [  1,  1,  1, -1, -1, -1, -1,  1,  1 ]
  H(:,453) = [  1,  1,  1, -1, -1, -1,  1, -1, -1 ]
  H(:,454) = [  1,  1,  1, -1, -1, -1,  1, -1,  1 ]
  H(:,455) = [  1,  1,  1, -1, -1, -1,  1,  1, -1 ]
  H(:,456) = [  1,  1,  1, -1, -1, -1,  1,  1,  1 ]
  H(:,457) = [  1,  1,  1, -1, -1,  1, -1, -1, -1 ]
  H(:,458) = [  1,  1,  1, -1, -1,  1, -1, -1,  1 ]
  H(:,459) = [  1,  1,  1, -1, -1,  1, -1,  1, -1 ]
  H(:,460) = [  1,  1,  1, -1, -1,  1, -1,  1,  1 ]
  H(:,461) = [  1,  1,  1, -1, -1,  1,  1, -1, -1 ]
  H(:,462) = [  1,  1,  1, -1, -1,  1,  1, -1,  1 ]
  H(:,463) = [  1,  1,  1, -1, -1,  1,  1,  1, -1 ]
  H(:,464) = [  1,  1,  1, -1, -1,  1,  1,  1,  1 ]
  H(:,465) = [  1,  1,  1, -1,  1, -1, -1, -1, -1 ]
  H(:,466) = [  1,  1,  1, -1,  1, -1, -1, -1,  1 ]
  H(:,467) = [  1,  1,  1, -1,  1, -1, -1,  1, -1 ]
  H(:,468) = [  1,  1,  1, -1,  1, -1, -1,  1,  1 ]
  H(:,469) = [  1,  1,  1, -1,  1, -1,  1, -1, -1 ]
  H(:,470) = [  1,  1,  1, -1,  1, -1,  1, -1,  1 ]
  H(:,471) = [  1,  1,  1, -1,  1, -1,  1,  1, -1 ]
  H(:,472) = [  1,  1,  1, -1,  1, -1,  1,  1,  1 ]
  H(:,473) = [  1,  1,  1, -1,  1,  1, -1, -1, -1 ]
  H(:,474) = [  1,  1,  1, -1,  1,  1, -1, -1,  1 ]
  H(:,475) = [  1,  1,  1, -1,  1,  1, -1,  1, -1 ]
  H(:,476) = [  1,  1,  1, -1,  1,  1, -1,  1,  1 ]
  H(:,477) = [  1,  1,  1, -1,  1,  1,  1, -1, -1 ]
  H(:,478) = [  1,  1,  1, -1,  1,  1,  1, -1,  1 ]
  H(:,479) = [  1,  1,  1, -1,  1,  1,  1,  1, -1 ]
  H(:,480) = [  1,  1,  1, -1,  1,  1,  1,  1,  1 ]
  H(:,481) = [  1,  1,  1,  1, -1, -1, -1, -1, -1 ]
  H(:,482) = [  1,  1,  1,  1, -1, -1, -1, -1,  1 ]
  H(:,483) = [  1,  1,  1,  1, -1, -1, -1,  1, -1 ]
  H(:,484) = [  1,  1,  1,  1, -1, -1, -1,  1,  1 ]
  H(:,485) = [  1,  1,  1,  1, -1, -1,  1, -1, -1 ]
  H(:,486) = [  1,  1,  1,  1, -1, -1,  1, -1,  1 ]
  H(:,487) = [  1,  1,  1,  1, -1, -1,  1,  1, -1 ]
  H(:,488) = [  1,  1,  1,  1, -1, -1,  1,  1,  1 ]
  H(:,489) = [  1,  1,  1,  1, -1,  1, -1, -1, -1 ]
  H(:,490) = [  1,  1,  1,  1, -1,  1, -1, -1,  1 ]
  H(:,491) = [  1,  1,  1,  1, -1,  1, -1,  1, -1 ]
  H(:,492) = [  1,  1,  1,  1, -1,  1, -1,  1,  1 ]
  H(:,493) = [  1,  1,  1,  1, -1,  1,  1, -1, -1 ]
  H(:,494) = [  1,  1,  1,  1, -1,  1,  1, -1,  1 ]
  H(:,495) = [  1,  1,  1,  1, -1,  1,  1,  1, -1 ]
  H(:,496) = [  1,  1,  1,  1, -1,  1,  1,  1,  1 ]
  H(:,497) = [  1,  1,  1,  1,  1, -1, -1, -1, -1 ]
  H(:,498) = [  1,  1,  1,  1,  1, -1, -1, -1,  1 ]
  H(:,499) = [  1,  1,  1,  1,  1, -1, -1,  1, -1 ]
  H(:,500) = [  1,  1,  1,  1,  1, -1, -1,  1,  1 ]
  H(:,501) = [  1,  1,  1,  1,  1, -1,  1, -1, -1 ]
  H(:,502) = [  1,  1,  1,  1,  1, -1,  1, -1,  1 ]
  H(:,503) = [  1,  1,  1,  1,  1, -1,  1,  1, -1 ]
  H(:,504) = [  1,  1,  1,  1,  1, -1,  1,  1,  1 ]
  H(:,505) = [  1,  1,  1,  1,  1,  1, -1, -1, -1 ]
  H(:,506) = [  1,  1,  1,  1,  1,  1, -1, -1,  1 ]
  H(:,507) = [  1,  1,  1,  1,  1,  1, -1,  1, -1 ]
  H(:,508) = [  1,  1,  1,  1,  1,  1, -1,  1,  1 ]
  H(:,509) = [  1,  1,  1,  1,  1,  1,  1, -1, -1 ]
  H(:,510) = [  1,  1,  1,  1,  1,  1,  1, -1,  1 ]
  H(:,511) = [  1,  1,  1,  1,  1,  1,  1,  1, -1 ]
  H(:,512) = [  1,  1,  1,  1,  1,  1,  1,  1,  1 ]

  H_HC(:,9) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 512/1/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_eellllbb_nenexeexmmxbbxg_1")
    implicit none
    integer, intent(in) :: pol(9)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_eellllbb_nenexeexmmxbbxg_1")
    implicit none
    integer, intent(in) :: photon_id(9)
    photonid_eellllbb_nenexeexmmxbbxg_1 = photon_id
  end subroutine set_photons


end module ol_external_eellllbb_nenexeexmmxbbxg_1


module ol_settings_eellllbb_nenexeexmmxbbxg_1
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_eellllbb_nenexeexmmxbbxg_1")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

end module ol_settings_eellllbb_nenexeexmmxbbxg_1

module colour_basis_eellllbb_nenexeexmmxbbxg_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(9) = [0,0,0,0,0,0,1,1,2]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_eellllbb_nenexeexmmxbbxg_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(9)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 1
    ncoupl = 1
    maxpows = 1
    nhel = 512
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_eellllbb_nenexeexmmxbbxg_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,1)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([12], [1,1])
#endif
#if 1 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,6,6], &
      [3,1])
#endif
  end subroutine tree_colbasis

end module colour_basis_eellllbb_nenexeexmmxbbxg_1

! **********************************************************************
module ol_heltables_eellllbb_nenexeexmmxbbxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1], &
    H8(2) = [-1,1], &
    H9(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(168), n3(3,2105), n4(4,4)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x4(2,4,10), t3x64(2,64,33), t3x8(2,8,42), t3x16(2,16,113), t3x32(2,32,391), t3x512(2,512,1516), &
    t4x64(3,64,4)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(512,9)
  integer,           save :: exthel(512,9)
  integer,           save :: firstpol(9)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  call heltable([2,2,4], n3(:,4), t3x4(:,:,4))
  n2(1) = 4
  n2(2) = 4
  n2(3) = 4
  call heltable([2,4,8], n3(:,5), t3x8(:,:,1))
  call heltable([4,4,4,64], n4(:,1), t4x64(:,:,1))
  call heltable([2,2,4], n3(:,6), t3x4(:,:,5))
  n2(4) = 4
  call heltable([4,2,8], n3(:,7), t3x8(:,:,2))
  call heltable([2,2,4], n3(:,8), t3x4(:,:,6))
  call heltable([2,2,4], n3(:,9), t3x4(:,:,7))
  n2(5) = 4
  n2(6) = 4
  call heltable([4,4,4,64], n4(:,2), t4x64(:,:,2))
  call heltable([2,2,4], n3(:,10), t3x4(:,:,8))
  call heltable([4,2,8], n3(:,11), t3x8(:,:,3))
  call heltable([4,4,4,64], n4(:,3), t4x64(:,:,3))
  call heltable([4,2,8], n3(:,12), t3x8(:,:,4))
  n2(7) = 8
  call heltable([2,2,4], n3(:,13), t3x4(:,:,9))
  n2(8) = 4
  call heltable([4,4,4,64], n4(:,4), t4x64(:,:,4))
  call heltable([2,4,8], n3(:,14), t3x8(:,:,5))
  call heltable([2,4,8], n3(:,15), t3x8(:,:,6))
  n2(9) = 8
  call heltable([2,4,8], n3(:,16), t3x8(:,:,7))
  call heltable([4,4,16], n3(:,17), t3x16(:,:,1))
  n2(10) = 8
  n2(11) = 16
  call heltable([4,8,32], n3(:,18), t3x32(:,:,1))
  call heltable([4,4,16], n3(:,19), t3x16(:,:,2))
  call heltable([8,4,32], n3(:,20), t3x32(:,:,2))
  call heltable([2,2,4], n3(:,21), t3x4(:,:,10))
  call heltable([4,4,16], n3(:,22), t3x16(:,:,3))
  n2(12) = 16
  call heltable([4,8,32], n3(:,23), t3x32(:,:,3))
  call heltable([4,4,16], n3(:,24), t3x16(:,:,4))
  n2(13) = 16
  call heltable([8,4,32], n3(:,25), t3x32(:,:,4))
  call heltable([8,4,32], n3(:,26), t3x32(:,:,5))
  call heltable([4,4,16], n3(:,27), t3x16(:,:,5))
  n2(14) = 16
  call heltable([8,4,32], n3(:,28), t3x32(:,:,6))
  call heltable([8,4,32], n3(:,29), t3x32(:,:,7))
  call heltable([4,4,16], n3(:,30), t3x16(:,:,6))
  n2(15) = 16
  call heltable([4,4,16], n3(:,31), t3x16(:,:,7))
  n2(16) = 16
  call heltable([2,4,8], n3(:,32), t3x8(:,:,8))
  call heltable([4,4,16], n3(:,33), t3x16(:,:,8))
  n2(17) = 8
  n2(18) = 16
  call heltable([4,8,32], n3(:,34), t3x32(:,:,8))
  call heltable([2,4,8], n3(:,35), t3x8(:,:,9))
  n2(19) = 8
  call heltable([4,8,32], n3(:,36), t3x32(:,:,9))
  call heltable([4,4,16], n3(:,37), t3x16(:,:,9))
  call heltable([8,4,32], n3(:,38), t3x32(:,:,10))
  call heltable([8,4,32], n3(:,39), t3x32(:,:,11))
  call heltable([4,4,16], n3(:,40), t3x16(:,:,10))
  n2(20) = 16
  call heltable([4,8,32], n3(:,41), t3x32(:,:,12))
  call heltable([4,8,32], n3(:,42), t3x32(:,:,13))
  call heltable([8,4,32], n3(:,43), t3x32(:,:,14))
  call heltable([8,4,32], n3(:,44), t3x32(:,:,15))
  call heltable([8,4,32], n3(:,45), t3x32(:,:,16))
  call heltable([8,4,32], n3(:,46), t3x32(:,:,17))
  call heltable([8,4,32], n3(:,47), t3x32(:,:,18))
  call heltable([8,4,32], n3(:,48), t3x32(:,:,19))
  call heltable([4,2,8], n3(:,49), t3x8(:,:,10))
  call heltable([4,4,16], n3(:,50), t3x16(:,:,11))
  n2(21) = 8
  call heltable([8,4,32], n3(:,51), t3x32(:,:,20))
  call heltable([2,4,8], n3(:,52), t3x8(:,:,11))
  n2(22) = 8
  call heltable([8,4,32], n3(:,53), t3x32(:,:,21))
  call heltable([2,4,8], n3(:,54), t3x8(:,:,12))
  n2(23) = 8
  call heltable([8,4,32], n3(:,55), t3x32(:,:,22))
  call heltable([4,8,32], n3(:,56), t3x32(:,:,23))
  call heltable([4,8,32], n3(:,57), t3x32(:,:,24))
  call heltable([16,2,32], n3(:,58), t3x32(:,:,25))
  call heltable([8,4,32], n3(:,59), t3x32(:,:,26))
  call heltable([8,4,32], n3(:,60), t3x32(:,:,27))
  call heltable([8,4,32], n3(:,61), t3x32(:,:,28))
  call heltable([8,4,32], n3(:,62), t3x32(:,:,29))
  call heltable([8,4,32], n3(:,63), t3x32(:,:,30))
  call heltable([8,4,32], n3(:,64), t3x32(:,:,31))
  call heltable([8,4,32], n3(:,65), t3x32(:,:,32))
  call heltable([8,4,32], n3(:,66), t3x32(:,:,33))
  call heltable([8,4,32], n3(:,67), t3x32(:,:,34))
  call heltable([8,4,32], n3(:,68), t3x32(:,:,35))
  call heltable([4,8,32], n3(:,69), t3x32(:,:,36))
  call heltable([2,16,32], n3(:,70), t3x32(:,:,37))
  call heltable([16,2,32], n3(:,71), t3x32(:,:,38))
  call heltable([8,4,32], n3(:,72), t3x32(:,:,39))
  call heltable([4,8,32], n3(:,73), t3x32(:,:,40))
  call heltable([16,2,32], n3(:,74), t3x32(:,:,41))
  call heltable([2,16,32], n3(:,75), t3x32(:,:,42))
  call heltable([4,2,8], n3(:,76), t3x8(:,:,13))
  n2(24) = 8
  call heltable([8,4,32], n3(:,77), t3x32(:,:,43))
  call heltable([4,8,32], n3(:,78), t3x32(:,:,44))
  call heltable([4,4,16], n3(:,79), t3x16(:,:,12))
  n2(25) = 16
  call heltable([4,8,32], n3(:,80), t3x32(:,:,45))
  call heltable([4,8,32], n3(:,81), t3x32(:,:,46))
  call heltable([4,4,16], n3(:,82), t3x16(:,:,13))
  n2(26) = 16
  call heltable([4,4,16], n3(:,83), t3x16(:,:,14))
  n2(27) = 16
  call heltable([4,4,16], n3(:,84), t3x16(:,:,15))
  n2(28) = 16
  call heltable([8,4,32], n3(:,85), t3x32(:,:,47))
  call heltable([4,4,16], n3(:,86), t3x16(:,:,16))
  n2(29) = 16
  call heltable([4,8,32], n3(:,87), t3x32(:,:,48))
  call heltable([4,8,32], n3(:,88), t3x32(:,:,49))
  call heltable([4,2,8], n3(:,89), t3x8(:,:,14))
  n2(30) = 8
  call heltable([8,4,32], n3(:,90), t3x32(:,:,50))
  call heltable([4,2,8], n3(:,91), t3x8(:,:,15))
  n2(31) = 8
  call heltable([8,4,32], n3(:,92), t3x32(:,:,51))
  call heltable([4,8,32], n3(:,93), t3x32(:,:,52))
  call heltable([4,8,32], n3(:,94), t3x32(:,:,53))
  call heltable([4,8,32], n3(:,95), t3x32(:,:,54))
  call heltable([4,8,32], n3(:,96), t3x32(:,:,55))
  call heltable([4,4,16], n3(:,97), t3x16(:,:,17))
  n2(32) = 16
  call heltable([8,4,32], n3(:,98), t3x32(:,:,56))
  call heltable([8,4,32], n3(:,99), t3x32(:,:,57))
  call heltable([4,8,32], n3(:,100), t3x32(:,:,58))
  call heltable([4,8,32], n3(:,101), t3x32(:,:,59))
  call heltable([4,8,32], n3(:,102), t3x32(:,:,60))
  call heltable([4,8,32], n3(:,103), t3x32(:,:,61))
  call heltable([2,4,8], n3(:,104), t3x8(:,:,16))
  n2(33) = 8
  call heltable([4,8,32], n3(:,105), t3x32(:,:,62))
  call heltable([4,2,8], n3(:,106), t3x8(:,:,17))
  n2(34) = 8
  call heltable([4,8,32], n3(:,107), t3x32(:,:,63))
  call heltable([4,2,8], n3(:,108), t3x8(:,:,18))
  n2(35) = 8
  call heltable([4,8,32], n3(:,109), t3x32(:,:,64))
  call heltable([4,8,32], n3(:,110), t3x32(:,:,65))
  call heltable([4,8,32], n3(:,111), t3x32(:,:,66))
  call heltable([2,16,32], n3(:,112), t3x32(:,:,67))
  call heltable([4,8,32], n3(:,113), t3x32(:,:,68))
  call heltable([4,8,32], n3(:,114), t3x32(:,:,69))
  call heltable([4,8,32], n3(:,115), t3x32(:,:,70))
  call heltable([4,8,32], n3(:,116), t3x32(:,:,71))
  call heltable([4,8,32], n3(:,117), t3x32(:,:,72))
  call heltable([4,8,32], n3(:,118), t3x32(:,:,73))
  call heltable([4,8,32], n3(:,119), t3x32(:,:,74))
  call heltable([4,8,32], n3(:,120), t3x32(:,:,75))
  call heltable([4,8,32], n3(:,121), t3x32(:,:,76))
  call heltable([8,4,32], n3(:,122), t3x32(:,:,77))
  call heltable([4,8,32], n3(:,123), t3x32(:,:,78))
  call heltable([16,2,32], n3(:,124), t3x32(:,:,79))
  call heltable([2,16,32], n3(:,125), t3x32(:,:,80))
  call heltable([8,4,32], n3(:,126), t3x32(:,:,81))
  call heltable([4,8,32], n3(:,127), t3x32(:,:,82))
  call heltable([2,16,32], n3(:,128), t3x32(:,:,83))
  call heltable([16,2,32], n3(:,129), t3x32(:,:,84))
  call heltable([2,8,16], n3(:,130), t3x16(:,:,18))
  n2(36) = 16
  call heltable([8,2,16], n3(:,131), t3x16(:,:,19))
  n2(37) = 16
  call heltable([8,2,16], n3(:,132), t3x16(:,:,20))
  n2(38) = 16
  call heltable([8,2,16], n3(:,133), t3x16(:,:,21))
  n2(39) = 16
  call heltable([8,2,16], n3(:,134), t3x16(:,:,22))
  n2(40) = 16
  call heltable([8,2,16], n3(:,135), t3x16(:,:,23))
  n2(41) = 16
  call heltable([2,16,32], n3(:,136), t3x32(:,:,85))
  n2(42) = 32
  call heltable([16,2,32], n3(:,137), t3x32(:,:,86))
  n2(43) = 32
  call heltable([2,8,16], n3(:,138), t3x16(:,:,24))
  n2(44) = 16
  call heltable([2,8,16], n3(:,139), t3x16(:,:,25))
  n2(45) = 16
  call heltable([8,2,16], n3(:,140), t3x16(:,:,26))
  n2(46) = 16
  call heltable([2,8,16], n3(:,141), t3x16(:,:,27))
  n2(47) = 16
  call heltable([2,8,16], n3(:,142), t3x16(:,:,28))
  n2(48) = 16
  call heltable([2,8,16], n3(:,143), t3x16(:,:,29))
  n2(49) = 16
  call heltable([16,2,32], n3(:,144), t3x32(:,:,87))
  n2(50) = 32
  call heltable([2,16,32], n3(:,145), t3x32(:,:,88))
  n2(51) = 32
  n2(52) = 32
  n2(53) = 32
  n2(54) = 32
  n2(55) = 32
  n2(56) = 32
  n2(57) = 32
  call heltable([4,2,8], n3(:,146), t3x8(:,:,19))
  call heltable([2,4,8], n3(:,147), t3x8(:,:,20))
  n2(58) = 8
  n2(59) = 8
  call heltable([8,8,64], n3(:,148), t3x64(:,:,1))
  call heltable([2,4,8], n3(:,149), t3x8(:,:,21))
  n2(60) = 8
  call heltable([8,8,64], n3(:,150), t3x64(:,:,2))
  call heltable([8,8,64], n3(:,151), t3x64(:,:,3))
  call heltable([8,8,64], n3(:,152), t3x64(:,:,4))
  call heltable([8,8,64], n3(:,153), t3x64(:,:,5))
  call heltable([8,8,64], n3(:,154), t3x64(:,:,6))
  call heltable([2,8,16], n3(:,155), t3x16(:,:,30))
  call heltable([8,2,16], n3(:,156), t3x16(:,:,31))
  call heltable([4,8,32], n3(:,157), t3x32(:,:,89))
  call heltable([8,2,16], n3(:,158), t3x16(:,:,32))
  n2(61) = 16
  call heltable([4,8,32], n3(:,159), t3x32(:,:,90))
  call heltable([2,16,32], n3(:,160), t3x32(:,:,91))
  call heltable([2,16,32], n3(:,161), t3x32(:,:,92))
  call heltable([16,2,32], n3(:,162), t3x32(:,:,93))
  call heltable([16,2,32], n3(:,163), t3x32(:,:,94))
  call heltable([16,2,32], n3(:,164), t3x32(:,:,95))
  call heltable([16,2,32], n3(:,165), t3x32(:,:,96))
  call heltable([8,2,16], n3(:,166), t3x16(:,:,33))
  call heltable([4,8,32], n3(:,167), t3x32(:,:,97))
  n2(62) = 16
  call heltable([4,8,32], n3(:,168), t3x32(:,:,98))
  call heltable([2,8,16], n3(:,169), t3x16(:,:,34))
  n2(63) = 16
  call heltable([2,8,16], n3(:,170), t3x16(:,:,35))
  n2(64) = 16
  call heltable([4,2,8], n3(:,171), t3x8(:,:,22))
  call heltable([2,4,8], n3(:,172), t3x8(:,:,23))
  n2(65) = 8
  n2(66) = 8
  call heltable([8,8,64], n3(:,173), t3x64(:,:,7))
  call heltable([4,2,8], n3(:,174), t3x8(:,:,24))
  n2(67) = 8
  call heltable([8,8,64], n3(:,175), t3x64(:,:,8))
  call heltable([8,8,64], n3(:,176), t3x64(:,:,9))
  call heltable([8,8,64], n3(:,177), t3x64(:,:,10))
  call heltable([8,8,64], n3(:,178), t3x64(:,:,11))
  call heltable([8,8,64], n3(:,179), t3x64(:,:,12))
  call heltable([8,2,16], n3(:,180), t3x16(:,:,36))
  call heltable([2,8,16], n3(:,181), t3x16(:,:,37))
  call heltable([2,8,16], n3(:,182), t3x16(:,:,38))
  n2(68) = 16
  call heltable([2,8,16], n3(:,183), t3x16(:,:,39))
  call heltable([8,4,32], n3(:,184), t3x32(:,:,99))
  n2(69) = 16
  call heltable([8,4,32], n3(:,185), t3x32(:,:,100))
  call heltable([8,2,16], n3(:,186), t3x16(:,:,40))
  n2(70) = 16
  call heltable([8,2,16], n3(:,187), t3x16(:,:,41))
  n2(71) = 16
  call heltable([2,8,16], n3(:,188), t3x16(:,:,42))
  call heltable([2,8,16], n3(:,189), t3x16(:,:,43))
  call heltable([8,2,16], n3(:,190), t3x16(:,:,44))
  call heltable([4,8,32], n3(:,191), t3x32(:,:,101))
  call heltable([8,2,16], n3(:,192), t3x16(:,:,45))
  n2(72) = 16
  call heltable([8,2,16], n3(:,193), t3x16(:,:,46))
  call heltable([8,2,16], n3(:,194), t3x16(:,:,47))
  n2(73) = 16
  call heltable([8,2,16], n3(:,195), t3x16(:,:,48))
  call heltable([8,2,16], n3(:,196), t3x16(:,:,49))
  call heltable([2,8,16], n3(:,197), t3x16(:,:,50))
  call heltable([2,8,16], n3(:,198), t3x16(:,:,51))
  n2(74) = 16
  call heltable([2,8,16], n3(:,199), t3x16(:,:,52))
  call heltable([2,8,16], n3(:,200), t3x16(:,:,53))
  n2(75) = 16
  call heltable([16,2,32], n3(:,201), t3x32(:,:,102))
  call heltable([4,8,32], n3(:,202), t3x32(:,:,103))
  call heltable([4,8,32], n3(:,203), t3x32(:,:,104))
  call heltable([8,4,32], n3(:,204), t3x32(:,:,105))
  call heltable([8,4,32], n3(:,205), t3x32(:,:,106))
  call heltable([16,2,32], n3(:,206), t3x32(:,:,107))
  call heltable([2,16,32], n3(:,207), t3x32(:,:,108))
  n2(76) = 32
  call heltable([8,4,32], n3(:,208), t3x32(:,:,109))
  call heltable([8,4,32], n3(:,209), t3x32(:,:,110))
  call heltable([16,2,32], n3(:,210), t3x32(:,:,111))
  call heltable([16,2,32], n3(:,211), t3x32(:,:,112))
  call heltable([2,16,32], n3(:,212), t3x32(:,:,113))
  call heltable([2,16,32], n3(:,213), t3x32(:,:,114))
  call heltable([2,16,32], n3(:,214), t3x32(:,:,115))
  call heltable([2,16,32], n3(:,215), t3x32(:,:,116))
  call heltable([8,2,16], n3(:,216), t3x16(:,:,54))
  n2(77) = 16
  call heltable([2,8,16], n3(:,217), t3x16(:,:,55))
  n2(78) = 16
  call heltable([2,8,16], n3(:,218), t3x16(:,:,56))
  n2(79) = 16
  call heltable([2,8,16], n3(:,219), t3x16(:,:,57))
  n2(80) = 16
  call heltable([8,2,16], n3(:,220), t3x16(:,:,58))
  n2(81) = 16
  call heltable([8,2,16], n3(:,221), t3x16(:,:,59))
  n2(82) = 16
  call heltable([8,4,32], n3(:,222), t3x32(:,:,117))
  call heltable([2,16,32], n3(:,223), t3x32(:,:,118))
  call heltable([16,2,32], n3(:,224), t3x32(:,:,119))
  call heltable([2,16,32], n3(:,225), t3x32(:,:,120))
  call heltable([2,16,32], n3(:,226), t3x32(:,:,121))
  call heltable([2,16,32], n3(:,227), t3x32(:,:,122))
  call heltable([16,2,32], n3(:,228), t3x32(:,:,123))
  call heltable([16,2,32], n3(:,229), t3x32(:,:,124))
  call heltable([16,2,32], n3(:,230), t3x32(:,:,125))
  call heltable([2,16,32], n3(:,231), t3x32(:,:,126))
  call heltable([2,16,32], n3(:,232), t3x32(:,:,127))
  call heltable([2,16,32], n3(:,233), t3x32(:,:,128))
  call heltable([16,2,32], n3(:,234), t3x32(:,:,129))
  call heltable([16,2,32], n3(:,235), t3x32(:,:,130))
  call heltable([16,2,32], n3(:,236), t3x32(:,:,131))
  call heltable([16,2,32], n3(:,237), t3x32(:,:,132))
  call heltable([2,16,32], n3(:,238), t3x32(:,:,133))
  call heltable([2,16,32], n3(:,239), t3x32(:,:,134))
  call heltable([2,16,32], n3(:,240), t3x32(:,:,135))
  call heltable([2,16,32], n3(:,241), t3x32(:,:,136))
  call heltable([16,2,32], n3(:,242), t3x32(:,:,137))
  call heltable([16,2,32], n3(:,243), t3x32(:,:,138))
  call heltable([2,16,32], n3(:,244), t3x32(:,:,139))
  call heltable([2,16,32], n3(:,245), t3x32(:,:,140))
  call heltable([2,16,32], n3(:,246), t3x32(:,:,141))
  call heltable([2,16,32], n3(:,247), t3x32(:,:,142))
  call heltable([2,16,32], n3(:,248), t3x32(:,:,143))
  call heltable([2,16,32], n3(:,249), t3x32(:,:,144))
  call heltable([16,2,32], n3(:,250), t3x32(:,:,145))
  call heltable([16,2,32], n3(:,251), t3x32(:,:,146))
  call heltable([16,2,32], n3(:,252), t3x32(:,:,147))
  call heltable([16,2,32], n3(:,253), t3x32(:,:,148))
  call heltable([2,16,32], n3(:,254), t3x32(:,:,149))
  call heltable([2,16,32], n3(:,255), t3x32(:,:,150))
  call heltable([16,2,32], n3(:,256), t3x32(:,:,151))
  call heltable([16,2,32], n3(:,257), t3x32(:,:,152))
  call heltable([16,2,32], n3(:,258), t3x32(:,:,153))
  call heltable([16,2,32], n3(:,259), t3x32(:,:,154))
  call heltable([4,2,8], n3(:,260), t3x8(:,:,25))
  n2(83) = 8
  call heltable([8,2,16], n3(:,261), t3x16(:,:,60))
  call heltable([16,2,32], n3(:,262), t3x32(:,:,155))
  call heltable([8,2,16], n3(:,263), t3x16(:,:,61))
  call heltable([16,2,32], n3(:,264), t3x32(:,:,156))
  n2(84) = 16
  call heltable([16,2,32], n3(:,265), t3x32(:,:,157))
  call heltable([16,2,32], n3(:,266), t3x32(:,:,158))
  call heltable([16,2,32], n3(:,267), t3x32(:,:,159))
  call heltable([16,2,32], n3(:,268), t3x32(:,:,160))
  call heltable([4,8,32], n3(:,269), t3x32(:,:,161))
  call heltable([4,8,32], n3(:,270), t3x32(:,:,162))
  call heltable([4,8,32], n3(:,271), t3x32(:,:,163))
  call heltable([4,8,32], n3(:,272), t3x32(:,:,164))
  call heltable([4,8,32], n3(:,273), t3x32(:,:,165))
  call heltable([4,8,32], n3(:,274), t3x32(:,:,166))
  call heltable([4,8,32], n3(:,275), t3x32(:,:,167))
  call heltable([8,4,32], n3(:,276), t3x32(:,:,168))
  call heltable([2,4,8], n3(:,277), t3x8(:,:,26))
  n2(85) = 8
  call heltable([8,8,64], n3(:,278), t3x64(:,:,13))
  call heltable([8,8,64], n3(:,279), t3x64(:,:,14))
  call heltable([2,4,8], n3(:,280), t3x8(:,:,27))
  n2(86) = 8
  call heltable([8,8,64], n3(:,281), t3x64(:,:,15))
  call heltable([8,8,64], n3(:,282), t3x64(:,:,16))
  call heltable([2,8,16], n3(:,283), t3x16(:,:,62))
  call heltable([4,8,32], n3(:,284), t3x32(:,:,169))
  n2(87) = 16
  call heltable([4,8,32], n3(:,285), t3x32(:,:,170))
  call heltable([2,8,16], n3(:,286), t3x16(:,:,63))
  n2(88) = 16
  call heltable([2,4,8], n3(:,287), t3x8(:,:,28))
  n2(89) = 8
  call heltable([2,8,16], n3(:,288), t3x16(:,:,64))
  call heltable([2,8,16], n3(:,289), t3x16(:,:,65))
  n2(90) = 16
  call heltable([4,2,8], n3(:,290), t3x8(:,:,29))
  n2(91) = 8
  call heltable([8,8,64], n3(:,291), t3x64(:,:,17))
  call heltable([8,8,64], n3(:,292), t3x64(:,:,18))
  call heltable([4,2,8], n3(:,293), t3x8(:,:,30))
  n2(92) = 8
  call heltable([8,8,64], n3(:,294), t3x64(:,:,19))
  call heltable([8,8,64], n3(:,295), t3x64(:,:,20))
  call heltable([8,2,16], n3(:,296), t3x16(:,:,66))
  call heltable([8,4,32], n3(:,297), t3x32(:,:,171))
  n2(93) = 16
  call heltable([8,4,32], n3(:,298), t3x32(:,:,172))
  call heltable([8,2,16], n3(:,299), t3x16(:,:,67))
  n2(94) = 16
  call heltable([8,2,16], n3(:,300), t3x16(:,:,68))
  call heltable([8,2,16], n3(:,301), t3x16(:,:,69))
  n2(95) = 16
  call heltable([8,2,16], n3(:,302), t3x16(:,:,70))
  call heltable([8,2,16], n3(:,303), t3x16(:,:,71))
  n2(96) = 16
  call heltable([2,8,16], n3(:,304), t3x16(:,:,72))
  call heltable([2,8,16], n3(:,305), t3x16(:,:,73))
  call heltable([2,8,16], n3(:,306), t3x16(:,:,74))
  n2(97) = 16
  call heltable([2,8,16], n3(:,307), t3x16(:,:,75))
  n2(98) = 16
  call heltable([2,16,32], n3(:,308), t3x32(:,:,173))
  call heltable([16,2,32], n3(:,309), t3x32(:,:,174))
  n2(99) = 32
  call heltable([4,8,32], n3(:,310), t3x32(:,:,175))
  call heltable([4,8,32], n3(:,311), t3x32(:,:,176))
  call heltable([8,4,32], n3(:,312), t3x32(:,:,177))
  call heltable([8,4,32], n3(:,313), t3x32(:,:,178))
  call heltable([2,16,32], n3(:,314), t3x32(:,:,179))
  call heltable([2,16,32], n3(:,315), t3x32(:,:,180))
  call heltable([2,16,32], n3(:,316), t3x32(:,:,181))
  call heltable([2,16,32], n3(:,317), t3x32(:,:,182))
  call heltable([2,16,32], n3(:,318), t3x32(:,:,183))
  call heltable([2,16,32], n3(:,319), t3x32(:,:,184))
  call heltable([8,4,32], n3(:,320), t3x32(:,:,185))
  call heltable([8,4,32], n3(:,321), t3x32(:,:,186))
  call heltable([8,4,32], n3(:,322), t3x32(:,:,187))
  call heltable([8,4,32], n3(:,323), t3x32(:,:,188))
  call heltable([8,4,32], n3(:,324), t3x32(:,:,189))
  call heltable([8,4,32], n3(:,325), t3x32(:,:,190))
  call heltable([4,8,32], n3(:,326), t3x32(:,:,191))
  call heltable([8,4,32], n3(:,327), t3x32(:,:,192))
  call heltable([2,8,16], n3(:,328), t3x16(:,:,76))
  n2(100) = 16
  call heltable([2,8,16], n3(:,329), t3x16(:,:,77))
  n2(101) = 16
  call heltable([8,2,16], n3(:,330), t3x16(:,:,78))
  n2(102) = 16
  call heltable([8,2,16], n3(:,331), t3x16(:,:,79))
  n2(103) = 16
  call heltable([16,2,32], n3(:,332), t3x32(:,:,193))
  call heltable([16,2,32], n3(:,333), t3x32(:,:,194))
  call heltable([2,16,32], n3(:,334), t3x32(:,:,195))
  call heltable([2,16,32], n3(:,335), t3x32(:,:,196))
  call heltable([16,2,32], n3(:,336), t3x32(:,:,197))
  call heltable([16,2,32], n3(:,337), t3x32(:,:,198))
  call heltable([2,16,32], n3(:,338), t3x32(:,:,199))
  call heltable([2,16,32], n3(:,339), t3x32(:,:,200))
  call heltable([2,16,32], n3(:,340), t3x32(:,:,201))
  call heltable([2,16,32], n3(:,341), t3x32(:,:,202))
  call heltable([2,16,32], n3(:,342), t3x32(:,:,203))
  call heltable([2,16,32], n3(:,343), t3x32(:,:,204))
  call heltable([2,16,32], n3(:,344), t3x32(:,:,205))
  call heltable([2,16,32], n3(:,345), t3x32(:,:,206))
  call heltable([2,16,32], n3(:,346), t3x32(:,:,207))
  call heltable([2,16,32], n3(:,347), t3x32(:,:,208))
  call heltable([16,2,32], n3(:,348), t3x32(:,:,209))
  call heltable([16,2,32], n3(:,349), t3x32(:,:,210))
  call heltable([16,2,32], n3(:,350), t3x32(:,:,211))
  call heltable([16,2,32], n3(:,351), t3x32(:,:,212))
  call heltable([16,2,32], n3(:,352), t3x32(:,:,213))
  call heltable([16,2,32], n3(:,353), t3x32(:,:,214))
  call heltable([16,2,32], n3(:,354), t3x32(:,:,215))
  call heltable([16,2,32], n3(:,355), t3x32(:,:,216))
  call heltable([16,2,32], n3(:,356), t3x32(:,:,217))
  call heltable([16,2,32], n3(:,357), t3x32(:,:,218))
  call heltable([2,16,32], n3(:,358), t3x32(:,:,219))
  call heltable([2,16,32], n3(:,359), t3x32(:,:,220))
  call heltable([16,2,32], n3(:,360), t3x32(:,:,221))
  call heltable([16,2,32], n3(:,361), t3x32(:,:,222))
  call heltable([2,16,32], n3(:,362), t3x32(:,:,223))
  call heltable([2,16,32], n3(:,363), t3x32(:,:,224))
  call heltable([2,16,32], n3(:,364), t3x32(:,:,225))
  call heltable([2,16,32], n3(:,365), t3x32(:,:,226))
  call heltable([2,16,32], n3(:,366), t3x32(:,:,227))
  call heltable([2,16,32], n3(:,367), t3x32(:,:,228))
  call heltable([16,2,32], n3(:,368), t3x32(:,:,229))
  call heltable([16,2,32], n3(:,369), t3x32(:,:,230))
  call heltable([16,2,32], n3(:,370), t3x32(:,:,231))
  call heltable([16,2,32], n3(:,371), t3x32(:,:,232))
  call heltable([2,16,32], n3(:,372), t3x32(:,:,233))
  call heltable([2,16,32], n3(:,373), t3x32(:,:,234))
  call heltable([2,16,32], n3(:,374), t3x32(:,:,235))
  call heltable([2,16,32], n3(:,375), t3x32(:,:,236))
  call heltable([16,2,32], n3(:,376), t3x32(:,:,237))
  call heltable([16,2,32], n3(:,377), t3x32(:,:,238))
  call heltable([16,2,32], n3(:,378), t3x32(:,:,239))
  call heltable([16,2,32], n3(:,379), t3x32(:,:,240))
  call heltable([2,4,8], n3(:,380), t3x8(:,:,31))
  call heltable([4,4,16], n3(:,381), t3x16(:,:,80))
  n2(104) = 8
  n2(105) = 16
  call heltable([4,8,32], n3(:,382), t3x32(:,:,241))
  call heltable([4,4,16], n3(:,383), t3x16(:,:,81))
  n2(106) = 16
  call heltable([4,4,16], n3(:,384), t3x16(:,:,82))
  n2(107) = 16
  call heltable([4,4,16], n3(:,385), t3x16(:,:,83))
  n2(108) = 16
  call heltable([4,8,32], n3(:,386), t3x32(:,:,242))
  call heltable([8,4,32], n3(:,387), t3x32(:,:,243))
  call heltable([8,4,32], n3(:,388), t3x32(:,:,244))
  call heltable([8,4,32], n3(:,389), t3x32(:,:,245))
  call heltable([4,4,16], n3(:,390), t3x16(:,:,84))
  call heltable([4,4,16], n3(:,391), t3x16(:,:,85))
  n2(109) = 16
  call heltable([16,2,32], n3(:,392), t3x32(:,:,246))
  call heltable([2,16,32], n3(:,393), t3x32(:,:,247))
  call heltable([2,16,32], n3(:,394), t3x32(:,:,248))
  call heltable([8,4,32], n3(:,395), t3x32(:,:,249))
  call heltable([8,4,32], n3(:,396), t3x32(:,:,250))
  call heltable([8,4,32], n3(:,397), t3x32(:,:,251))
  call heltable([8,4,32], n3(:,398), t3x32(:,:,252))
  call heltable([4,8,32], n3(:,399), t3x32(:,:,253))
  call heltable([4,8,32], n3(:,400), t3x32(:,:,254))
  call heltable([4,4,16], n3(:,401), t3x16(:,:,86))
  n2(110) = 16
  call heltable([8,4,32], n3(:,402), t3x32(:,:,255))
  call heltable([8,4,32], n3(:,403), t3x32(:,:,256))
  call heltable([8,4,32], n3(:,404), t3x32(:,:,257))
  call heltable([4,4,16], n3(:,405), t3x16(:,:,87))
  n2(111) = 16
  call heltable([4,4,16], n3(:,406), t3x16(:,:,88))
  n2(112) = 16
  call heltable([16,2,32], n3(:,407), t3x32(:,:,258))
  call heltable([4,2,8], n3(:,408), t3x8(:,:,32))
  n2(113) = 8
  call heltable([8,4,32], n3(:,409), t3x32(:,:,259))
  call heltable([4,8,32], n3(:,410), t3x32(:,:,260))
  call heltable([4,4,16], n3(:,411), t3x16(:,:,89))
  n2(114) = 16
  call heltable([8,4,32], n3(:,412), t3x32(:,:,261))
  call heltable([4,8,32], n3(:,413), t3x32(:,:,262))
  call heltable([4,8,32], n3(:,414), t3x32(:,:,263))
  call heltable([2,16,32], n3(:,415), t3x32(:,:,264))
  call heltable([16,2,32], n3(:,416), t3x32(:,:,265))
  call heltable([16,2,32], n3(:,417), t3x32(:,:,266))
  call heltable([4,8,32], n3(:,418), t3x32(:,:,267))
  call heltable([4,8,32], n3(:,419), t3x32(:,:,268))
  call heltable([4,8,32], n3(:,420), t3x32(:,:,269))
  call heltable([8,4,32], n3(:,421), t3x32(:,:,270))
  call heltable([4,8,32], n3(:,422), t3x32(:,:,271))
  call heltable([4,8,32], n3(:,423), t3x32(:,:,272))
  call heltable([16,2,32], n3(:,424), t3x32(:,:,273))
  call heltable([16,2,32], n3(:,425), t3x32(:,:,274))
  call heltable([16,2,32], n3(:,426), t3x32(:,:,275))
  call heltable([8,4,32], n3(:,427), t3x32(:,:,276))
  call heltable([8,4,32], n3(:,428), t3x32(:,:,277))
  call heltable([8,4,32], n3(:,429), t3x32(:,:,278))
  call heltable([2,8,16], n3(:,430), t3x16(:,:,90))
  n2(115) = 16
  call heltable([8,2,16], n3(:,431), t3x16(:,:,91))
  n2(116) = 16
  call heltable([2,16,32], n3(:,432), t3x32(:,:,279))
  n2(117) = 32
  call heltable([2,16,32], n3(:,433), t3x32(:,:,280))
  n2(118) = 32
  call heltable([2,16,32], n3(:,434), t3x32(:,:,281))
  n2(119) = 32
  n2(120) = 32
  n2(121) = 32
  n2(122) = 32
  n2(123) = 32
  n2(124) = 32
  n2(125) = 32
  n2(126) = 32
  n2(127) = 32
  n2(128) = 32
  call heltable([4,2,8], n3(:,435), t3x8(:,:,33))
  call heltable([2,4,8], n3(:,436), t3x8(:,:,34))
  n2(129) = 8
  n2(130) = 8
  call heltable([8,8,64], n3(:,437), t3x64(:,:,21))
  call heltable([8,2,16], n3(:,438), t3x16(:,:,92))
  n2(131) = 16
  call heltable([4,8,32], n3(:,439), t3x32(:,:,282))
  call heltable([2,8,16], n3(:,440), t3x16(:,:,93))
  n2(132) = 16
  call heltable([8,4,32], n3(:,441), t3x32(:,:,283))
  call heltable([16,2,32], n3(:,442), t3x32(:,:,284))
  call heltable([2,16,32], n3(:,443), t3x32(:,:,285))
  call heltable([2,16,32], n3(:,444), t3x32(:,:,286))
  call heltable([2,16,32], n3(:,445), t3x32(:,:,287))
  n2(133) = 32
  call heltable([16,2,32], n3(:,446), t3x32(:,:,288))
  n2(134) = 32
  call heltable([16,2,32], n3(:,447), t3x32(:,:,289))
  n2(135) = 32
  call heltable([2,16,32], n3(:,448), t3x32(:,:,290))
  call heltable([16,2,32], n3(:,449), t3x32(:,:,291))
  call heltable([2,16,32], n3(:,450), t3x32(:,:,292))
  call heltable([4,2,8], n3(:,451), t3x8(:,:,35))
  n2(136) = 8
  call heltable([8,2,16], n3(:,452), t3x16(:,:,94))
  call heltable([8,2,16], n3(:,453), t3x16(:,:,95))
  n2(137) = 16
  call heltable([8,8,64], n3(:,454), t3x64(:,:,22))
  call heltable([8,8,64], n3(:,455), t3x64(:,:,23))
  call heltable([8,8,64], n3(:,456), t3x64(:,:,24))
  call heltable([8,8,64], n3(:,457), t3x64(:,:,25))
  call heltable([4,8,32], n3(:,458), t3x32(:,:,293))
  call heltable([4,8,32], n3(:,459), t3x32(:,:,294))
  call heltable([4,2,8], n3(:,460), t3x8(:,:,36))
  n2(138) = 8
  call heltable([8,2,16], n3(:,461), t3x16(:,:,96))
  n2(139) = 16
  call heltable([2,4,8], n3(:,462), t3x8(:,:,37))
  n2(140) = 8
  call heltable([2,8,16], n3(:,463), t3x16(:,:,97))
  n2(141) = 16
  call heltable([8,2,16], n3(:,464), t3x16(:,:,98))
  call heltable([2,16,32], n3(:,465), t3x32(:,:,295))
  n2(142) = 16
  call heltable([2,16,32], n3(:,466), t3x32(:,:,296))
  call heltable([2,16,32], n3(:,467), t3x32(:,:,297))
  call heltable([2,8,16], n3(:,468), t3x16(:,:,99))
  n2(143) = 16
  call heltable([2,8,16], n3(:,469), t3x16(:,:,100))
  n2(144) = 16
  call heltable([16,2,32], n3(:,470), t3x32(:,:,298))
  n2(145) = 32
  call heltable([16,2,32], n3(:,471), t3x32(:,:,299))
  n2(146) = 32
  call heltable([16,2,32], n3(:,472), t3x32(:,:,300))
  n2(147) = 32
  call heltable([8,8,64], n3(:,473), t3x64(:,:,26))
  call heltable([4,8,32], n3(:,474), t3x32(:,:,301))
  call heltable([8,4,32], n3(:,475), t3x32(:,:,302))
  call heltable([8,4,32], n3(:,476), t3x32(:,:,303))
  call heltable([8,4,32], n3(:,477), t3x32(:,:,304))
  call heltable([8,2,16], n3(:,478), t3x16(:,:,101))
  n2(148) = 16
  call heltable([16,2,32], n3(:,479), t3x32(:,:,305))
  call heltable([16,2,32], n3(:,480), t3x32(:,:,306))
  call heltable([2,16,32], n3(:,481), t3x32(:,:,307))
  call heltable([2,16,32], n3(:,482), t3x32(:,:,308))
  call heltable([16,2,32], n3(:,483), t3x32(:,:,309))
  call heltable([16,2,32], n3(:,484), t3x32(:,:,310))
  call heltable([16,2,32], n3(:,485), t3x32(:,:,311))
  call heltable([16,2,32], n3(:,486), t3x32(:,:,312))
  call heltable([2,16,32], n3(:,487), t3x32(:,:,313))
  call heltable([16,2,32], n3(:,488), t3x32(:,:,314))
  call heltable([16,2,32], n3(:,489), t3x32(:,:,315))
  call heltable([2,16,32], n3(:,490), t3x32(:,:,316))
  call heltable([2,16,32], n3(:,491), t3x32(:,:,317))
  call heltable([16,2,32], n3(:,492), t3x32(:,:,318))
  call heltable([2,16,32], n3(:,493), t3x32(:,:,319))
  call heltable([2,16,32], n3(:,494), t3x32(:,:,320))
  call heltable([2,16,32], n3(:,495), t3x32(:,:,321))
  call heltable([16,2,32], n3(:,496), t3x32(:,:,322))
  call heltable([2,16,32], n3(:,497), t3x32(:,:,323))
  call heltable([2,16,32], n3(:,498), t3x32(:,:,324))
  call heltable([16,2,32], n3(:,499), t3x32(:,:,325))
  call heltable([2,4,8], n3(:,500), t3x8(:,:,38))
  n2(149) = 8
  call heltable([2,8,16], n3(:,501), t3x16(:,:,102))
  call heltable([2,8,16], n3(:,502), t3x16(:,:,103))
  n2(150) = 16
  call heltable([8,8,64], n3(:,503), t3x64(:,:,27))
  call heltable([8,8,64], n3(:,504), t3x64(:,:,28))
  call heltable([8,8,64], n3(:,505), t3x64(:,:,29))
  call heltable([8,8,64], n3(:,506), t3x64(:,:,30))
  call heltable([8,4,32], n3(:,507), t3x32(:,:,326))
  call heltable([8,4,32], n3(:,508), t3x32(:,:,327))
  call heltable([4,2,8], n3(:,509), t3x8(:,:,39))
  n2(151) = 8
  call heltable([8,2,16], n3(:,510), t3x16(:,:,104))
  n2(152) = 16
  call heltable([2,4,8], n3(:,511), t3x8(:,:,40))
  n2(153) = 8
  call heltable([8,8,64], n3(:,512), t3x64(:,:,31))
  call heltable([2,8,16], n3(:,513), t3x16(:,:,105))
  call heltable([4,8,32], n3(:,514), t3x32(:,:,328))
  n2(154) = 16
  call heltable([2,8,16], n3(:,515), t3x16(:,:,106))
  n2(155) = 16
  call heltable([8,2,16], n3(:,516), t3x16(:,:,107))
  n2(156) = 16
  call heltable([8,2,16], n3(:,517), t3x16(:,:,108))
  n2(157) = 16
  call heltable([16,2,32], n3(:,518), t3x32(:,:,329))
  call heltable([16,2,32], n3(:,519), t3x32(:,:,330))
  call heltable([16,2,32], n3(:,520), t3x32(:,:,331))
  call heltable([2,16,32], n3(:,521), t3x32(:,:,332))
  n2(158) = 32
  call heltable([2,16,32], n3(:,522), t3x32(:,:,333))
  n2(159) = 32
  call heltable([2,16,32], n3(:,523), t3x32(:,:,334))
  n2(160) = 32
  call heltable([8,4,32], n3(:,524), t3x32(:,:,335))
  call heltable([4,8,32], n3(:,525), t3x32(:,:,336))
  call heltable([4,8,32], n3(:,526), t3x32(:,:,337))
  call heltable([2,8,16], n3(:,527), t3x16(:,:,109))
  n2(161) = 16
  call heltable([16,2,32], n3(:,528), t3x32(:,:,338))
  call heltable([16,2,32], n3(:,529), t3x32(:,:,339))
  call heltable([2,16,32], n3(:,530), t3x32(:,:,340))
  call heltable([2,16,32], n3(:,531), t3x32(:,:,341))
  call heltable([16,2,32], n3(:,532), t3x32(:,:,342))
  call heltable([2,16,32], n3(:,533), t3x32(:,:,343))
  call heltable([2,16,32], n3(:,534), t3x32(:,:,344))
  call heltable([2,16,32], n3(:,535), t3x32(:,:,345))
  call heltable([2,16,32], n3(:,536), t3x32(:,:,346))
  call heltable([16,2,32], n3(:,537), t3x32(:,:,347))
  call heltable([16,2,32], n3(:,538), t3x32(:,:,348))
  call heltable([2,16,32], n3(:,539), t3x32(:,:,349))
  call heltable([2,16,32], n3(:,540), t3x32(:,:,350))
  call heltable([16,2,32], n3(:,541), t3x32(:,:,351))
  call heltable([2,16,32], n3(:,542), t3x32(:,:,352))
  call heltable([16,2,32], n3(:,543), t3x32(:,:,353))
  call heltable([16,2,32], n3(:,544), t3x32(:,:,354))
  call heltable([2,16,32], n3(:,545), t3x32(:,:,355))
  call heltable([16,2,32], n3(:,546), t3x32(:,:,356))
  call heltable([16,2,32], n3(:,547), t3x32(:,:,357))
  call heltable([2,16,32], n3(:,548), t3x32(:,:,358))
  call heltable([4,2,8], n3(:,549), t3x8(:,:,41))
  n2(162) = 8
  call heltable([8,2,16], n3(:,550), t3x16(:,:,110))
  n2(163) = 16
  call heltable([8,2,16], n3(:,551), t3x16(:,:,111))
  n2(164) = 16
  call heltable([2,4,8], n3(:,552), t3x8(:,:,42))
  n2(165) = 8
  call heltable([2,8,16], n3(:,553), t3x16(:,:,112))
  n2(166) = 16
  call heltable([2,8,16], n3(:,554), t3x16(:,:,113))
  n2(167) = 16
  call heltable([2,16,32], n3(:,555), t3x32(:,:,359))
  call heltable([16,2,32], n3(:,556), t3x32(:,:,360))
  n2(168) = 32
  call heltable([8,8,64], n3(:,557), t3x64(:,:,32))
  call heltable([4,8,32], n3(:,558), t3x32(:,:,361))
  call heltable([8,8,64], n3(:,559), t3x64(:,:,33))
  call heltable([4,8,32], n3(:,560), t3x32(:,:,362))
  call heltable([8,4,32], n3(:,561), t3x32(:,:,363))
  call heltable([8,4,32], n3(:,562), t3x32(:,:,364))
  call heltable([16,2,32], n3(:,563), t3x32(:,:,365))
  call heltable([2,16,32], n3(:,564), t3x32(:,:,366))
  call heltable([16,2,32], n3(:,565), t3x32(:,:,367))
  call heltable([2,16,32], n3(:,566), t3x32(:,:,368))
  call heltable([16,2,32], n3(:,567), t3x32(:,:,369))
  call heltable([16,2,32], n3(:,568), t3x32(:,:,370))
  call heltable([2,16,32], n3(:,569), t3x32(:,:,371))
  call heltable([2,16,32], n3(:,570), t3x32(:,:,372))
  call heltable([16,2,32], n3(:,571), t3x32(:,:,373))
  call heltable([2,16,32], n3(:,572), t3x32(:,:,374))
  call heltable([16,2,32], n3(:,573), t3x32(:,:,375))
  call heltable([2,16,32], n3(:,574), t3x32(:,:,376))
  call heltable([2,16,32], n3(:,575), t3x32(:,:,377))
  call heltable([16,2,32], n3(:,576), t3x32(:,:,378))
  call heltable([2,16,32], n3(:,577), t3x32(:,:,379))
  call heltable([16,2,32], n3(:,578), t3x32(:,:,380))
  call heltable([16,2,32], n3(:,579), t3x32(:,:,381))
  call heltable([16,2,32], n3(:,580), t3x32(:,:,382))
  call heltable([16,2,32], n3(:,581), t3x32(:,:,383))
  call heltable([2,16,32], n3(:,582), t3x32(:,:,384))
  call heltable([2,16,32], n3(:,583), t3x32(:,:,385))
  call heltable([2,16,32], n3(:,584), t3x32(:,:,386))
  call heltable([16,2,32], n3(:,585), t3x32(:,:,387))
  call heltable([2,16,32], n3(:,586), t3x32(:,:,388))
  call heltable([16,2,32], n3(:,587), t3x32(:,:,389))
  call heltable([16,2,32], n3(:,588), t3x32(:,:,390))
  call heltable([16,2,32], n3(:,589), t3x32(:,:,391))
  call heltable([8,64,512], n3(:,590), t3x512(:,:,1))
  call heltable([64,8,512], n3(:,591), t3x512(:,:,2))
  call heltable([8,64,512], n3(:,592), t3x512(:,:,3))
  call heltable([8,64,512], n3(:,593), t3x512(:,:,4))
  call heltable([64,8,512], n3(:,594), t3x512(:,:,5))
  call heltable([8,64,512], n3(:,595), t3x512(:,:,6))
  call heltable([8,64,512], n3(:,596), t3x512(:,:,7))
  call heltable([8,64,512], n3(:,597), t3x512(:,:,8))
  call heltable([64,8,512], n3(:,598), t3x512(:,:,9))
  call heltable([64,8,512], n3(:,599), t3x512(:,:,10))
  call heltable([64,8,512], n3(:,600), t3x512(:,:,11))
  call heltable([64,8,512], n3(:,601), t3x512(:,:,12))
  call heltable([16,32,512], n3(:,602), t3x512(:,:,13))
  call heltable([16,32,512], n3(:,603), t3x512(:,:,14))
  call heltable([16,32,512], n3(:,604), t3x512(:,:,15))
  call heltable([32,16,512], n3(:,605), t3x512(:,:,16))
  call heltable([16,32,512], n3(:,606), t3x512(:,:,17))
  call heltable([16,32,512], n3(:,607), t3x512(:,:,18))
  call heltable([16,32,512], n3(:,608), t3x512(:,:,19))
  call heltable([16,32,512], n3(:,609), t3x512(:,:,20))
  call heltable([16,32,512], n3(:,610), t3x512(:,:,21))
  call heltable([16,32,512], n3(:,611), t3x512(:,:,22))
  call heltable([32,16,512], n3(:,612), t3x512(:,:,23))
  call heltable([32,16,512], n3(:,613), t3x512(:,:,24))
  call heltable([32,16,512], n3(:,614), t3x512(:,:,25))
  call heltable([32,16,512], n3(:,615), t3x512(:,:,26))
  call heltable([16,32,512], n3(:,616), t3x512(:,:,27))
  call heltable([16,32,512], n3(:,617), t3x512(:,:,28))
  call heltable([16,32,512], n3(:,618), t3x512(:,:,29))
  call heltable([16,32,512], n3(:,619), t3x512(:,:,30))
  call heltable([16,32,512], n3(:,620), t3x512(:,:,31))
  call heltable([16,32,512], n3(:,621), t3x512(:,:,32))
  call heltable([16,32,512], n3(:,622), t3x512(:,:,33))
  call heltable([16,32,512], n3(:,623), t3x512(:,:,34))
  call heltable([16,32,512], n3(:,624), t3x512(:,:,35))
  call heltable([16,32,512], n3(:,625), t3x512(:,:,36))
  call heltable([16,32,512], n3(:,626), t3x512(:,:,37))
  call heltable([16,32,512], n3(:,627), t3x512(:,:,38))
  call heltable([16,32,512], n3(:,628), t3x512(:,:,39))
  call heltable([16,32,512], n3(:,629), t3x512(:,:,40))
  call heltable([16,32,512], n3(:,630), t3x512(:,:,41))
  call heltable([16,32,512], n3(:,631), t3x512(:,:,42))
  call heltable([16,32,512], n3(:,632), t3x512(:,:,43))
  call heltable([16,32,512], n3(:,633), t3x512(:,:,44))
  call heltable([16,32,512], n3(:,634), t3x512(:,:,45))
  call heltable([16,32,512], n3(:,635), t3x512(:,:,46))
  call heltable([16,32,512], n3(:,636), t3x512(:,:,47))
  call heltable([16,32,512], n3(:,637), t3x512(:,:,48))
  call heltable([16,32,512], n3(:,638), t3x512(:,:,49))
  call heltable([16,32,512], n3(:,639), t3x512(:,:,50))
  call heltable([16,32,512], n3(:,640), t3x512(:,:,51))
  call heltable([16,32,512], n3(:,641), t3x512(:,:,52))
  call heltable([16,32,512], n3(:,642), t3x512(:,:,53))
  call heltable([16,32,512], n3(:,643), t3x512(:,:,54))
  call heltable([16,32,512], n3(:,644), t3x512(:,:,55))
  call heltable([16,32,512], n3(:,645), t3x512(:,:,56))
  call heltable([16,32,512], n3(:,646), t3x512(:,:,57))
  call heltable([16,32,512], n3(:,647), t3x512(:,:,58))
  call heltable([16,32,512], n3(:,648), t3x512(:,:,59))
  call heltable([16,32,512], n3(:,649), t3x512(:,:,60))
  call heltable([16,32,512], n3(:,650), t3x512(:,:,61))
  call heltable([16,32,512], n3(:,651), t3x512(:,:,62))
  call heltable([16,32,512], n3(:,652), t3x512(:,:,63))
  call heltable([16,32,512], n3(:,653), t3x512(:,:,64))
  call heltable([16,32,512], n3(:,654), t3x512(:,:,65))
  call heltable([16,32,512], n3(:,655), t3x512(:,:,66))
  call heltable([16,32,512], n3(:,656), t3x512(:,:,67))
  call heltable([16,32,512], n3(:,657), t3x512(:,:,68))
  call heltable([16,32,512], n3(:,658), t3x512(:,:,69))
  call heltable([16,32,512], n3(:,659), t3x512(:,:,70))
  call heltable([16,32,512], n3(:,660), t3x512(:,:,71))
  call heltable([16,32,512], n3(:,661), t3x512(:,:,72))
  call heltable([16,32,512], n3(:,662), t3x512(:,:,73))
  call heltable([16,32,512], n3(:,663), t3x512(:,:,74))
  call heltable([16,32,512], n3(:,664), t3x512(:,:,75))
  call heltable([16,32,512], n3(:,665), t3x512(:,:,76))
  call heltable([32,16,512], n3(:,666), t3x512(:,:,77))
  call heltable([32,16,512], n3(:,667), t3x512(:,:,78))
  call heltable([32,16,512], n3(:,668), t3x512(:,:,79))
  call heltable([32,16,512], n3(:,669), t3x512(:,:,80))
  call heltable([16,32,512], n3(:,670), t3x512(:,:,81))
  call heltable([32,16,512], n3(:,671), t3x512(:,:,82))
  call heltable([16,32,512], n3(:,672), t3x512(:,:,83))
  call heltable([16,32,512], n3(:,673), t3x512(:,:,84))
  call heltable([16,32,512], n3(:,674), t3x512(:,:,85))
  call heltable([16,32,512], n3(:,675), t3x512(:,:,86))
  call heltable([16,32,512], n3(:,676), t3x512(:,:,87))
  call heltable([16,32,512], n3(:,677), t3x512(:,:,88))
  call heltable([16,32,512], n3(:,678), t3x512(:,:,89))
  call heltable([16,32,512], n3(:,679), t3x512(:,:,90))
  call heltable([16,32,512], n3(:,680), t3x512(:,:,91))
  call heltable([16,32,512], n3(:,681), t3x512(:,:,92))
  call heltable([16,32,512], n3(:,682), t3x512(:,:,93))
  call heltable([16,32,512], n3(:,683), t3x512(:,:,94))
  call heltable([16,32,512], n3(:,684), t3x512(:,:,95))
  call heltable([16,32,512], n3(:,685), t3x512(:,:,96))
  call heltable([16,32,512], n3(:,686), t3x512(:,:,97))
  call heltable([16,32,512], n3(:,687), t3x512(:,:,98))
  call heltable([16,32,512], n3(:,688), t3x512(:,:,99))
  call heltable([16,32,512], n3(:,689), t3x512(:,:,100))
  call heltable([16,32,512], n3(:,690), t3x512(:,:,101))
  call heltable([16,32,512], n3(:,691), t3x512(:,:,102))
  call heltable([16,32,512], n3(:,692), t3x512(:,:,103))
  call heltable([16,32,512], n3(:,693), t3x512(:,:,104))
  call heltable([16,32,512], n3(:,694), t3x512(:,:,105))
  call heltable([16,32,512], n3(:,695), t3x512(:,:,106))
  call heltable([16,32,512], n3(:,696), t3x512(:,:,107))
  call heltable([16,32,512], n3(:,697), t3x512(:,:,108))
  call heltable([16,32,512], n3(:,698), t3x512(:,:,109))
  call heltable([16,32,512], n3(:,699), t3x512(:,:,110))
  call heltable([16,32,512], n3(:,700), t3x512(:,:,111))
  call heltable([16,32,512], n3(:,701), t3x512(:,:,112))
  call heltable([16,32,512], n3(:,702), t3x512(:,:,113))
  call heltable([16,32,512], n3(:,703), t3x512(:,:,114))
  call heltable([16,32,512], n3(:,704), t3x512(:,:,115))
  call heltable([16,32,512], n3(:,705), t3x512(:,:,116))
  call heltable([16,32,512], n3(:,706), t3x512(:,:,117))
  call heltable([16,32,512], n3(:,707), t3x512(:,:,118))
  call heltable([16,32,512], n3(:,708), t3x512(:,:,119))
  call heltable([16,32,512], n3(:,709), t3x512(:,:,120))
  call heltable([16,32,512], n3(:,710), t3x512(:,:,121))
  call heltable([16,32,512], n3(:,711), t3x512(:,:,122))
  call heltable([16,32,512], n3(:,712), t3x512(:,:,123))
  call heltable([16,32,512], n3(:,713), t3x512(:,:,124))
  call heltable([16,32,512], n3(:,714), t3x512(:,:,125))
  call heltable([16,32,512], n3(:,715), t3x512(:,:,126))
  call heltable([16,32,512], n3(:,716), t3x512(:,:,127))
  call heltable([16,32,512], n3(:,717), t3x512(:,:,128))
  call heltable([16,32,512], n3(:,718), t3x512(:,:,129))
  call heltable([16,32,512], n3(:,719), t3x512(:,:,130))
  call heltable([16,32,512], n3(:,720), t3x512(:,:,131))
  call heltable([16,32,512], n3(:,721), t3x512(:,:,132))
  call heltable([32,16,512], n3(:,722), t3x512(:,:,133))
  call heltable([32,16,512], n3(:,723), t3x512(:,:,134))
  call heltable([32,16,512], n3(:,724), t3x512(:,:,135))
  call heltable([32,16,512], n3(:,725), t3x512(:,:,136))
  call heltable([32,16,512], n3(:,726), t3x512(:,:,137))
  call heltable([32,16,512], n3(:,727), t3x512(:,:,138))
  call heltable([32,16,512], n3(:,728), t3x512(:,:,139))
  call heltable([32,16,512], n3(:,729), t3x512(:,:,140))
  call heltable([32,16,512], n3(:,730), t3x512(:,:,141))
  call heltable([32,16,512], n3(:,731), t3x512(:,:,142))
  call heltable([32,16,512], n3(:,732), t3x512(:,:,143))
  call heltable([32,16,512], n3(:,733), t3x512(:,:,144))
  call heltable([32,16,512], n3(:,734), t3x512(:,:,145))
  call heltable([32,16,512], n3(:,735), t3x512(:,:,146))
  call heltable([32,16,512], n3(:,736), t3x512(:,:,147))
  call heltable([32,16,512], n3(:,737), t3x512(:,:,148))
  call heltable([32,16,512], n3(:,738), t3x512(:,:,149))
  call heltable([32,16,512], n3(:,739), t3x512(:,:,150))
  call heltable([32,16,512], n3(:,740), t3x512(:,:,151))
  call heltable([32,16,512], n3(:,741), t3x512(:,:,152))
  call heltable([32,16,512], n3(:,742), t3x512(:,:,153))
  call heltable([32,16,512], n3(:,743), t3x512(:,:,154))
  call heltable([32,16,512], n3(:,744), t3x512(:,:,155))
  call heltable([32,16,512], n3(:,745), t3x512(:,:,156))
  call heltable([16,32,512], n3(:,746), t3x512(:,:,157))
  call heltable([16,32,512], n3(:,747), t3x512(:,:,158))
  call heltable([32,16,512], n3(:,748), t3x512(:,:,159))
  call heltable([32,16,512], n3(:,749), t3x512(:,:,160))
  call heltable([32,16,512], n3(:,750), t3x512(:,:,161))
  call heltable([32,16,512], n3(:,751), t3x512(:,:,162))
  call heltable([32,16,512], n3(:,752), t3x512(:,:,163))
  call heltable([32,16,512], n3(:,753), t3x512(:,:,164))
  call heltable([32,16,512], n3(:,754), t3x512(:,:,165))
  call heltable([32,16,512], n3(:,755), t3x512(:,:,166))
  call heltable([32,16,512], n3(:,756), t3x512(:,:,167))
  call heltable([32,16,512], n3(:,757), t3x512(:,:,168))
  call heltable([32,16,512], n3(:,758), t3x512(:,:,169))
  call heltable([32,16,512], n3(:,759), t3x512(:,:,170))
  call heltable([32,16,512], n3(:,760), t3x512(:,:,171))
  call heltable([32,16,512], n3(:,761), t3x512(:,:,172))
  call heltable([32,16,512], n3(:,762), t3x512(:,:,173))
  call heltable([32,16,512], n3(:,763), t3x512(:,:,174))
  call heltable([32,16,512], n3(:,764), t3x512(:,:,175))
  call heltable([32,16,512], n3(:,765), t3x512(:,:,176))
  call heltable([32,16,512], n3(:,766), t3x512(:,:,177))
  call heltable([32,16,512], n3(:,767), t3x512(:,:,178))
  call heltable([32,16,512], n3(:,768), t3x512(:,:,179))
  call heltable([32,16,512], n3(:,769), t3x512(:,:,180))
  call heltable([32,16,512], n3(:,770), t3x512(:,:,181))
  call heltable([32,16,512], n3(:,771), t3x512(:,:,182))
  call heltable([16,32,512], n3(:,772), t3x512(:,:,183))
  call heltable([16,32,512], n3(:,773), t3x512(:,:,184))
  call heltable([32,16,512], n3(:,774), t3x512(:,:,185))
  call heltable([32,16,512], n3(:,775), t3x512(:,:,186))
  call heltable([32,16,512], n3(:,776), t3x512(:,:,187))
  call heltable([32,16,512], n3(:,777), t3x512(:,:,188))
  call heltable([32,16,512], n3(:,778), t3x512(:,:,189))
  call heltable([32,16,512], n3(:,779), t3x512(:,:,190))
  call heltable([32,16,512], n3(:,780), t3x512(:,:,191))
  call heltable([32,16,512], n3(:,781), t3x512(:,:,192))
  call heltable([32,16,512], n3(:,782), t3x512(:,:,193))
  call heltable([32,16,512], n3(:,783), t3x512(:,:,194))
  call heltable([32,16,512], n3(:,784), t3x512(:,:,195))
  call heltable([32,16,512], n3(:,785), t3x512(:,:,196))
  call heltable([16,32,512], n3(:,786), t3x512(:,:,197))
  call heltable([16,32,512], n3(:,787), t3x512(:,:,198))
  call heltable([16,32,512], n3(:,788), t3x512(:,:,199))
  call heltable([16,32,512], n3(:,789), t3x512(:,:,200))
  call heltable([32,16,512], n3(:,790), t3x512(:,:,201))
  call heltable([32,16,512], n3(:,791), t3x512(:,:,202))
  call heltable([32,16,512], n3(:,792), t3x512(:,:,203))
  call heltable([32,16,512], n3(:,793), t3x512(:,:,204))
  call heltable([32,16,512], n3(:,794), t3x512(:,:,205))
  call heltable([32,16,512], n3(:,795), t3x512(:,:,206))
  call heltable([32,16,512], n3(:,796), t3x512(:,:,207))
  call heltable([32,16,512], n3(:,797), t3x512(:,:,208))
  call heltable([32,16,512], n3(:,798), t3x512(:,:,209))
  call heltable([32,16,512], n3(:,799), t3x512(:,:,210))
  call heltable([32,16,512], n3(:,800), t3x512(:,:,211))
  call heltable([32,16,512], n3(:,801), t3x512(:,:,212))
  call heltable([16,32,512], n3(:,802), t3x512(:,:,213))
  call heltable([16,32,512], n3(:,803), t3x512(:,:,214))
  call heltable([16,32,512], n3(:,804), t3x512(:,:,215))
  call heltable([16,32,512], n3(:,805), t3x512(:,:,216))
  call heltable([16,32,512], n3(:,806), t3x512(:,:,217))
  call heltable([16,32,512], n3(:,807), t3x512(:,:,218))
  call heltable([16,32,512], n3(:,808), t3x512(:,:,219))
  call heltable([16,32,512], n3(:,809), t3x512(:,:,220))
  call heltable([16,32,512], n3(:,810), t3x512(:,:,221))
  call heltable([16,32,512], n3(:,811), t3x512(:,:,222))
  call heltable([8,64,512], n3(:,812), t3x512(:,:,223))
  call heltable([8,64,512], n3(:,813), t3x512(:,:,224))
  call heltable([8,64,512], n3(:,814), t3x512(:,:,225))
  call heltable([8,64,512], n3(:,815), t3x512(:,:,226))
  call heltable([8,64,512], n3(:,816), t3x512(:,:,227))
  call heltable([8,64,512], n3(:,817), t3x512(:,:,228))
  call heltable([32,16,512], n3(:,818), t3x512(:,:,229))
  call heltable([32,16,512], n3(:,819), t3x512(:,:,230))
  call heltable([16,32,512], n3(:,820), t3x512(:,:,231))
  call heltable([32,16,512], n3(:,821), t3x512(:,:,232))
  call heltable([16,32,512], n3(:,822), t3x512(:,:,233))
  call heltable([32,16,512], n3(:,823), t3x512(:,:,234))
  call heltable([16,32,512], n3(:,824), t3x512(:,:,235))
  call heltable([16,32,512], n3(:,825), t3x512(:,:,236))
  call heltable([16,32,512], n3(:,826), t3x512(:,:,237))
  call heltable([16,32,512], n3(:,827), t3x512(:,:,238))
  call heltable([16,32,512], n3(:,828), t3x512(:,:,239))
  call heltable([16,32,512], n3(:,829), t3x512(:,:,240))
  call heltable([32,16,512], n3(:,830), t3x512(:,:,241))
  call heltable([32,16,512], n3(:,831), t3x512(:,:,242))
  call heltable([32,16,512], n3(:,832), t3x512(:,:,243))
  call heltable([16,32,512], n3(:,833), t3x512(:,:,244))
  call heltable([32,16,512], n3(:,834), t3x512(:,:,245))
  call heltable([32,16,512], n3(:,835), t3x512(:,:,246))
  call heltable([32,16,512], n3(:,836), t3x512(:,:,247))
  call heltable([32,16,512], n3(:,837), t3x512(:,:,248))
  call heltable([8,64,512], n3(:,838), t3x512(:,:,249))
  call heltable([8,64,512], n3(:,839), t3x512(:,:,250))
  call heltable([8,64,512], n3(:,840), t3x512(:,:,251))
  call heltable([8,64,512], n3(:,841), t3x512(:,:,252))
  call heltable([8,64,512], n3(:,842), t3x512(:,:,253))
  call heltable([8,64,512], n3(:,843), t3x512(:,:,254))
  call heltable([32,16,512], n3(:,844), t3x512(:,:,255))
  call heltable([32,16,512], n3(:,845), t3x512(:,:,256))
  call heltable([32,16,512], n3(:,846), t3x512(:,:,257))
  call heltable([32,16,512], n3(:,847), t3x512(:,:,258))
  call heltable([32,16,512], n3(:,848), t3x512(:,:,259))
  call heltable([32,16,512], n3(:,849), t3x512(:,:,260))
  call heltable([32,16,512], n3(:,850), t3x512(:,:,261))
  call heltable([32,16,512], n3(:,851), t3x512(:,:,262))
  call heltable([32,16,512], n3(:,852), t3x512(:,:,263))
  call heltable([32,16,512], n3(:,853), t3x512(:,:,264))
  call heltable([32,16,512], n3(:,854), t3x512(:,:,265))
  call heltable([32,16,512], n3(:,855), t3x512(:,:,266))
  call heltable([32,16,512], n3(:,856), t3x512(:,:,267))
  call heltable([32,16,512], n3(:,857), t3x512(:,:,268))
  call heltable([32,16,512], n3(:,858), t3x512(:,:,269))
  call heltable([16,32,512], n3(:,859), t3x512(:,:,270))
  call heltable([32,16,512], n3(:,860), t3x512(:,:,271))
  call heltable([32,16,512], n3(:,861), t3x512(:,:,272))
  call heltable([32,16,512], n3(:,862), t3x512(:,:,273))
  call heltable([32,16,512], n3(:,863), t3x512(:,:,274))
  call heltable([32,16,512], n3(:,864), t3x512(:,:,275))
  call heltable([32,16,512], n3(:,865), t3x512(:,:,276))
  call heltable([16,32,512], n3(:,866), t3x512(:,:,277))
  call heltable([32,16,512], n3(:,867), t3x512(:,:,278))
  call heltable([32,16,512], n3(:,868), t3x512(:,:,279))
  call heltable([32,16,512], n3(:,869), t3x512(:,:,280))
  call heltable([32,16,512], n3(:,870), t3x512(:,:,281))
  call heltable([32,16,512], n3(:,871), t3x512(:,:,282))
  call heltable([32,16,512], n3(:,872), t3x512(:,:,283))
  call heltable([32,16,512], n3(:,873), t3x512(:,:,284))
  call heltable([32,16,512], n3(:,874), t3x512(:,:,285))
  call heltable([32,16,512], n3(:,875), t3x512(:,:,286))
  call heltable([32,16,512], n3(:,876), t3x512(:,:,287))
  call heltable([32,16,512], n3(:,877), t3x512(:,:,288))
  call heltable([16,32,512], n3(:,878), t3x512(:,:,289))
  call heltable([32,16,512], n3(:,879), t3x512(:,:,290))
  call heltable([16,32,512], n3(:,880), t3x512(:,:,291))
  call heltable([32,16,512], n3(:,881), t3x512(:,:,292))
  call heltable([32,16,512], n3(:,882), t3x512(:,:,293))
  call heltable([32,16,512], n3(:,883), t3x512(:,:,294))
  call heltable([32,16,512], n3(:,884), t3x512(:,:,295))
  call heltable([32,16,512], n3(:,885), t3x512(:,:,296))
  call heltable([16,32,512], n3(:,886), t3x512(:,:,297))
  call heltable([16,32,512], n3(:,887), t3x512(:,:,298))
  call heltable([16,32,512], n3(:,888), t3x512(:,:,299))
  call heltable([16,32,512], n3(:,889), t3x512(:,:,300))
  call heltable([16,32,512], n3(:,890), t3x512(:,:,301))
  call heltable([16,32,512], n3(:,891), t3x512(:,:,302))
  call heltable([32,16,512], n3(:,892), t3x512(:,:,303))
  call heltable([32,16,512], n3(:,893), t3x512(:,:,304))
  call heltable([16,32,512], n3(:,894), t3x512(:,:,305))
  call heltable([32,16,512], n3(:,895), t3x512(:,:,306))
  call heltable([16,32,512], n3(:,896), t3x512(:,:,307))
  call heltable([32,16,512], n3(:,897), t3x512(:,:,308))
  call heltable([32,16,512], n3(:,898), t3x512(:,:,309))
  call heltable([32,16,512], n3(:,899), t3x512(:,:,310))
  call heltable([32,16,512], n3(:,900), t3x512(:,:,311))
  call heltable([32,16,512], n3(:,901), t3x512(:,:,312))
  call heltable([16,32,512], n3(:,902), t3x512(:,:,313))
  call heltable([16,32,512], n3(:,903), t3x512(:,:,314))
  call heltable([16,32,512], n3(:,904), t3x512(:,:,315))
  call heltable([16,32,512], n3(:,905), t3x512(:,:,316))
  call heltable([16,32,512], n3(:,906), t3x512(:,:,317))
  call heltable([16,32,512], n3(:,907), t3x512(:,:,318))
  call heltable([16,32,512], n3(:,908), t3x512(:,:,319))
  call heltable([16,32,512], n3(:,909), t3x512(:,:,320))
  call heltable([16,32,512], n3(:,910), t3x512(:,:,321))
  call heltable([16,32,512], n3(:,911), t3x512(:,:,322))
  call heltable([16,32,512], n3(:,912), t3x512(:,:,323))
  call heltable([16,32,512], n3(:,913), t3x512(:,:,324))
  call heltable([8,64,512], n3(:,914), t3x512(:,:,325))
  call heltable([8,64,512], n3(:,915), t3x512(:,:,326))
  call heltable([8,64,512], n3(:,916), t3x512(:,:,327))
  call heltable([8,64,512], n3(:,917), t3x512(:,:,328))
  call heltable([8,64,512], n3(:,918), t3x512(:,:,329))
  call heltable([8,64,512], n3(:,919), t3x512(:,:,330))
  call heltable([32,16,512], n3(:,920), t3x512(:,:,331))
  call heltable([32,16,512], n3(:,921), t3x512(:,:,332))
  call heltable([16,32,512], n3(:,922), t3x512(:,:,333))
  call heltable([32,16,512], n3(:,923), t3x512(:,:,334))
  call heltable([16,32,512], n3(:,924), t3x512(:,:,335))
  call heltable([32,16,512], n3(:,925), t3x512(:,:,336))
  call heltable([16,32,512], n3(:,926), t3x512(:,:,337))
  call heltable([16,32,512], n3(:,927), t3x512(:,:,338))
  call heltable([16,32,512], n3(:,928), t3x512(:,:,339))
  call heltable([16,32,512], n3(:,929), t3x512(:,:,340))
  call heltable([16,32,512], n3(:,930), t3x512(:,:,341))
  call heltable([16,32,512], n3(:,931), t3x512(:,:,342))
  call heltable([32,16,512], n3(:,932), t3x512(:,:,343))
  call heltable([32,16,512], n3(:,933), t3x512(:,:,344))
  call heltable([32,16,512], n3(:,934), t3x512(:,:,345))
  call heltable([32,16,512], n3(:,935), t3x512(:,:,346))
  call heltable([32,16,512], n3(:,936), t3x512(:,:,347))
  call heltable([32,16,512], n3(:,937), t3x512(:,:,348))
  call heltable([32,16,512], n3(:,938), t3x512(:,:,349))
  call heltable([32,16,512], n3(:,939), t3x512(:,:,350))
  call heltable([8,64,512], n3(:,940), t3x512(:,:,351))
  call heltable([8,64,512], n3(:,941), t3x512(:,:,352))
  call heltable([8,64,512], n3(:,942), t3x512(:,:,353))
  call heltable([8,64,512], n3(:,943), t3x512(:,:,354))
  call heltable([8,64,512], n3(:,944), t3x512(:,:,355))
  call heltable([8,64,512], n3(:,945), t3x512(:,:,356))
  call heltable([32,16,512], n3(:,946), t3x512(:,:,357))
  call heltable([32,16,512], n3(:,947), t3x512(:,:,358))
  call heltable([16,32,512], n3(:,948), t3x512(:,:,359))
  call heltable([32,16,512], n3(:,949), t3x512(:,:,360))
  call heltable([16,32,512], n3(:,950), t3x512(:,:,361))
  call heltable([32,16,512], n3(:,951), t3x512(:,:,362))
  call heltable([16,32,512], n3(:,952), t3x512(:,:,363))
  call heltable([16,32,512], n3(:,953), t3x512(:,:,364))
  call heltable([16,32,512], n3(:,954), t3x512(:,:,365))
  call heltable([16,32,512], n3(:,955), t3x512(:,:,366))
  call heltable([16,32,512], n3(:,956), t3x512(:,:,367))
  call heltable([16,32,512], n3(:,957), t3x512(:,:,368))
  call heltable([32,16,512], n3(:,958), t3x512(:,:,369))
  call heltable([32,16,512], n3(:,959), t3x512(:,:,370))
  call heltable([32,16,512], n3(:,960), t3x512(:,:,371))
  call heltable([32,16,512], n3(:,961), t3x512(:,:,372))
  call heltable([32,16,512], n3(:,962), t3x512(:,:,373))
  call heltable([32,16,512], n3(:,963), t3x512(:,:,374))
  call heltable([32,16,512], n3(:,964), t3x512(:,:,375))
  call heltable([32,16,512], n3(:,965), t3x512(:,:,376))
  call heltable([32,16,512], n3(:,966), t3x512(:,:,377))
  call heltable([32,16,512], n3(:,967), t3x512(:,:,378))
  call heltable([16,32,512], n3(:,968), t3x512(:,:,379))
  call heltable([32,16,512], n3(:,969), t3x512(:,:,380))
  call heltable([16,32,512], n3(:,970), t3x512(:,:,381))
  call heltable([32,16,512], n3(:,971), t3x512(:,:,382))
  call heltable([32,16,512], n3(:,972), t3x512(:,:,383))
  call heltable([32,16,512], n3(:,973), t3x512(:,:,384))
  call heltable([16,32,512], n3(:,974), t3x512(:,:,385))
  call heltable([32,16,512], n3(:,975), t3x512(:,:,386))
  call heltable([16,32,512], n3(:,976), t3x512(:,:,387))
  call heltable([32,16,512], n3(:,977), t3x512(:,:,388))
  call heltable([32,16,512], n3(:,978), t3x512(:,:,389))
  call heltable([32,16,512], n3(:,979), t3x512(:,:,390))
  call heltable([16,32,512], n3(:,980), t3x512(:,:,391))
  call heltable([32,16,512], n3(:,981), t3x512(:,:,392))
  call heltable([16,32,512], n3(:,982), t3x512(:,:,393))
  call heltable([32,16,512], n3(:,983), t3x512(:,:,394))
  call heltable([32,16,512], n3(:,984), t3x512(:,:,395))
  call heltable([32,16,512], n3(:,985), t3x512(:,:,396))
  call heltable([32,16,512], n3(:,986), t3x512(:,:,397))
  call heltable([32,16,512], n3(:,987), t3x512(:,:,398))
  call heltable([32,16,512], n3(:,988), t3x512(:,:,399))
  call heltable([32,16,512], n3(:,989), t3x512(:,:,400))
  call heltable([32,16,512], n3(:,990), t3x512(:,:,401))
  call heltable([32,16,512], n3(:,991), t3x512(:,:,402))
  call heltable([32,16,512], n3(:,992), t3x512(:,:,403))
  call heltable([32,16,512], n3(:,993), t3x512(:,:,404))
  call heltable([32,16,512], n3(:,994), t3x512(:,:,405))
  call heltable([32,16,512], n3(:,995), t3x512(:,:,406))
  call heltable([16,32,512], n3(:,996), t3x512(:,:,407))
  call heltable([32,16,512], n3(:,997), t3x512(:,:,408))
  call heltable([16,32,512], n3(:,998), t3x512(:,:,409))
  call heltable([32,16,512], n3(:,999), t3x512(:,:,410))
  call heltable([32,16,512], n3(:,1000), t3x512(:,:,411))
  call heltable([32,16,512], n3(:,1001), t3x512(:,:,412))
  call heltable([32,16,512], n3(:,1002), t3x512(:,:,413))
  call heltable([32,16,512], n3(:,1003), t3x512(:,:,414))
  call heltable([32,16,512], n3(:,1004), t3x512(:,:,415))
  call heltable([32,16,512], n3(:,1005), t3x512(:,:,416))
  call heltable([32,16,512], n3(:,1006), t3x512(:,:,417))
  call heltable([32,16,512], n3(:,1007), t3x512(:,:,418))
  call heltable([32,16,512], n3(:,1008), t3x512(:,:,419))
  call heltable([32,16,512], n3(:,1009), t3x512(:,:,420))
  call heltable([32,16,512], n3(:,1010), t3x512(:,:,421))
  call heltable([32,16,512], n3(:,1011), t3x512(:,:,422))
  call heltable([32,16,512], n3(:,1012), t3x512(:,:,423))
  call heltable([32,16,512], n3(:,1013), t3x512(:,:,424))
  call heltable([32,16,512], n3(:,1014), t3x512(:,:,425))
  call heltable([32,16,512], n3(:,1015), t3x512(:,:,426))
  call heltable([16,32,512], n3(:,1016), t3x512(:,:,427))
  call heltable([16,32,512], n3(:,1017), t3x512(:,:,428))
  call heltable([16,32,512], n3(:,1018), t3x512(:,:,429))
  call heltable([16,32,512], n3(:,1019), t3x512(:,:,430))
  call heltable([16,32,512], n3(:,1020), t3x512(:,:,431))
  call heltable([16,32,512], n3(:,1021), t3x512(:,:,432))
  call heltable([16,32,512], n3(:,1022), t3x512(:,:,433))
  call heltable([16,32,512], n3(:,1023), t3x512(:,:,434))
  call heltable([16,32,512], n3(:,1024), t3x512(:,:,435))
  call heltable([16,32,512], n3(:,1025), t3x512(:,:,436))
  call heltable([16,32,512], n3(:,1026), t3x512(:,:,437))
  call heltable([16,32,512], n3(:,1027), t3x512(:,:,438))
  call heltable([16,32,512], n3(:,1028), t3x512(:,:,439))
  call heltable([16,32,512], n3(:,1029), t3x512(:,:,440))
  call heltable([16,32,512], n3(:,1030), t3x512(:,:,441))
  call heltable([16,32,512], n3(:,1031), t3x512(:,:,442))
  call heltable([16,32,512], n3(:,1032), t3x512(:,:,443))
  call heltable([16,32,512], n3(:,1033), t3x512(:,:,444))
  call heltable([16,32,512], n3(:,1034), t3x512(:,:,445))
  call heltable([16,32,512], n3(:,1035), t3x512(:,:,446))
  call heltable([16,32,512], n3(:,1036), t3x512(:,:,447))
  call heltable([16,32,512], n3(:,1037), t3x512(:,:,448))
  call heltable([16,32,512], n3(:,1038), t3x512(:,:,449))
  call heltable([16,32,512], n3(:,1039), t3x512(:,:,450))
  call heltable([16,32,512], n3(:,1040), t3x512(:,:,451))
  call heltable([16,32,512], n3(:,1041), t3x512(:,:,452))
  call heltable([16,32,512], n3(:,1042), t3x512(:,:,453))
  call heltable([16,32,512], n3(:,1043), t3x512(:,:,454))
  call heltable([16,32,512], n3(:,1044), t3x512(:,:,455))
  call heltable([16,32,512], n3(:,1045), t3x512(:,:,456))
  call heltable([16,32,512], n3(:,1046), t3x512(:,:,457))
  call heltable([16,32,512], n3(:,1047), t3x512(:,:,458))
  call heltable([16,32,512], n3(:,1048), t3x512(:,:,459))
  call heltable([16,32,512], n3(:,1049), t3x512(:,:,460))
  call heltable([16,32,512], n3(:,1050), t3x512(:,:,461))
  call heltable([16,32,512], n3(:,1051), t3x512(:,:,462))
  call heltable([16,32,512], n3(:,1052), t3x512(:,:,463))
  call heltable([16,32,512], n3(:,1053), t3x512(:,:,464))
  call heltable([16,32,512], n3(:,1054), t3x512(:,:,465))
  call heltable([16,32,512], n3(:,1055), t3x512(:,:,466))
  call heltable([16,32,512], n3(:,1056), t3x512(:,:,467))
  call heltable([16,32,512], n3(:,1057), t3x512(:,:,468))
  call heltable([16,32,512], n3(:,1058), t3x512(:,:,469))
  call heltable([16,32,512], n3(:,1059), t3x512(:,:,470))
  call heltable([16,32,512], n3(:,1060), t3x512(:,:,471))
  call heltable([16,32,512], n3(:,1061), t3x512(:,:,472))
  call heltable([16,32,512], n3(:,1062), t3x512(:,:,473))
  call heltable([16,32,512], n3(:,1063), t3x512(:,:,474))
  call heltable([16,32,512], n3(:,1064), t3x512(:,:,475))
  call heltable([32,16,512], n3(:,1065), t3x512(:,:,476))
  call heltable([16,32,512], n3(:,1066), t3x512(:,:,477))
  call heltable([16,32,512], n3(:,1067), t3x512(:,:,478))
  call heltable([16,32,512], n3(:,1068), t3x512(:,:,479))
  call heltable([16,32,512], n3(:,1069), t3x512(:,:,480))
  call heltable([16,32,512], n3(:,1070), t3x512(:,:,481))
  call heltable([16,32,512], n3(:,1071), t3x512(:,:,482))
  call heltable([16,32,512], n3(:,1072), t3x512(:,:,483))
  call heltable([16,32,512], n3(:,1073), t3x512(:,:,484))
  call heltable([16,32,512], n3(:,1074), t3x512(:,:,485))
  call heltable([16,32,512], n3(:,1075), t3x512(:,:,486))
  call heltable([16,32,512], n3(:,1076), t3x512(:,:,487))
  call heltable([16,32,512], n3(:,1077), t3x512(:,:,488))
  call heltable([8,64,512], n3(:,1078), t3x512(:,:,489))
  call heltable([8,64,512], n3(:,1079), t3x512(:,:,490))
  call heltable([8,64,512], n3(:,1080), t3x512(:,:,491))
  call heltable([8,64,512], n3(:,1081), t3x512(:,:,492))
  call heltable([32,16,512], n3(:,1082), t3x512(:,:,493))
  call heltable([16,32,512], n3(:,1083), t3x512(:,:,494))
  call heltable([32,16,512], n3(:,1084), t3x512(:,:,495))
  call heltable([32,16,512], n3(:,1085), t3x512(:,:,496))
  call heltable([32,16,512], n3(:,1086), t3x512(:,:,497))
  call heltable([32,16,512], n3(:,1087), t3x512(:,:,498))
  call heltable([32,16,512], n3(:,1088), t3x512(:,:,499))
  call heltable([32,16,512], n3(:,1089), t3x512(:,:,500))
  call heltable([32,16,512], n3(:,1090), t3x512(:,:,501))
  call heltable([32,16,512], n3(:,1091), t3x512(:,:,502))
  call heltable([32,16,512], n3(:,1092), t3x512(:,:,503))
  call heltable([32,16,512], n3(:,1093), t3x512(:,:,504))
  call heltable([32,16,512], n3(:,1094), t3x512(:,:,505))
  call heltable([32,16,512], n3(:,1095), t3x512(:,:,506))
  call heltable([32,16,512], n3(:,1096), t3x512(:,:,507))
  call heltable([32,16,512], n3(:,1097), t3x512(:,:,508))
  call heltable([32,16,512], n3(:,1098), t3x512(:,:,509))
  call heltable([32,16,512], n3(:,1099), t3x512(:,:,510))
  call heltable([8,64,512], n3(:,1100), t3x512(:,:,511))
  call heltable([8,64,512], n3(:,1101), t3x512(:,:,512))
  call heltable([8,64,512], n3(:,1102), t3x512(:,:,513))
  call heltable([8,64,512], n3(:,1103), t3x512(:,:,514))
  call heltable([32,16,512], n3(:,1104), t3x512(:,:,515))
  call heltable([16,32,512], n3(:,1105), t3x512(:,:,516))
  call heltable([32,16,512], n3(:,1106), t3x512(:,:,517))
  call heltable([32,16,512], n3(:,1107), t3x512(:,:,518))
  call heltable([32,16,512], n3(:,1108), t3x512(:,:,519))
  call heltable([32,16,512], n3(:,1109), t3x512(:,:,520))
  call heltable([32,16,512], n3(:,1110), t3x512(:,:,521))
  call heltable([32,16,512], n3(:,1111), t3x512(:,:,522))
  call heltable([32,16,512], n3(:,1112), t3x512(:,:,523))
  call heltable([32,16,512], n3(:,1113), t3x512(:,:,524))
  call heltable([32,16,512], n3(:,1114), t3x512(:,:,525))
  call heltable([32,16,512], n3(:,1115), t3x512(:,:,526))
  call heltable([32,16,512], n3(:,1116), t3x512(:,:,527))
  call heltable([32,16,512], n3(:,1117), t3x512(:,:,528))
  call heltable([32,16,512], n3(:,1118), t3x512(:,:,529))
  call heltable([32,16,512], n3(:,1119), t3x512(:,:,530))
  call heltable([32,16,512], n3(:,1120), t3x512(:,:,531))
  call heltable([32,16,512], n3(:,1121), t3x512(:,:,532))
  call heltable([32,16,512], n3(:,1122), t3x512(:,:,533))
  call heltable([32,16,512], n3(:,1123), t3x512(:,:,534))
  call heltable([32,16,512], n3(:,1124), t3x512(:,:,535))
  call heltable([32,16,512], n3(:,1125), t3x512(:,:,536))
  call heltable([16,32,512], n3(:,1126), t3x512(:,:,537))
  call heltable([16,32,512], n3(:,1127), t3x512(:,:,538))
  call heltable([32,16,512], n3(:,1128), t3x512(:,:,539))
  call heltable([32,16,512], n3(:,1129), t3x512(:,:,540))
  call heltable([16,32,512], n3(:,1130), t3x512(:,:,541))
  call heltable([16,32,512], n3(:,1131), t3x512(:,:,542))
  call heltable([16,32,512], n3(:,1132), t3x512(:,:,543))
  call heltable([16,32,512], n3(:,1133), t3x512(:,:,544))
  call heltable([16,32,512], n3(:,1134), t3x512(:,:,545))
  call heltable([16,32,512], n3(:,1135), t3x512(:,:,546))
  call heltable([16,32,512], n3(:,1136), t3x512(:,:,547))
  call heltable([16,32,512], n3(:,1137), t3x512(:,:,548))
  call heltable([16,32,512], n3(:,1138), t3x512(:,:,549))
  call heltable([16,32,512], n3(:,1139), t3x512(:,:,550))
  call heltable([16,32,512], n3(:,1140), t3x512(:,:,551))
  call heltable([16,32,512], n3(:,1141), t3x512(:,:,552))
  call heltable([16,32,512], n3(:,1142), t3x512(:,:,553))
  call heltable([16,32,512], n3(:,1143), t3x512(:,:,554))
  call heltable([16,32,512], n3(:,1144), t3x512(:,:,555))
  call heltable([16,32,512], n3(:,1145), t3x512(:,:,556))
  call heltable([16,32,512], n3(:,1146), t3x512(:,:,557))
  call heltable([16,32,512], n3(:,1147), t3x512(:,:,558))
  call heltable([16,32,512], n3(:,1148), t3x512(:,:,559))
  call heltable([16,32,512], n3(:,1149), t3x512(:,:,560))
  call heltable([16,32,512], n3(:,1150), t3x512(:,:,561))
  call heltable([16,32,512], n3(:,1151), t3x512(:,:,562))
  call heltable([16,32,512], n3(:,1152), t3x512(:,:,563))
  call heltable([16,32,512], n3(:,1153), t3x512(:,:,564))
  call heltable([8,64,512], n3(:,1154), t3x512(:,:,565))
  call heltable([8,64,512], n3(:,1155), t3x512(:,:,566))
  call heltable([8,64,512], n3(:,1156), t3x512(:,:,567))
  call heltable([8,64,512], n3(:,1157), t3x512(:,:,568))
  call heltable([32,16,512], n3(:,1158), t3x512(:,:,569))
  call heltable([32,16,512], n3(:,1159), t3x512(:,:,570))
  call heltable([32,16,512], n3(:,1160), t3x512(:,:,571))
  call heltable([32,16,512], n3(:,1161), t3x512(:,:,572))
  call heltable([16,32,512], n3(:,1162), t3x512(:,:,573))
  call heltable([16,32,512], n3(:,1163), t3x512(:,:,574))
  call heltable([16,32,512], n3(:,1164), t3x512(:,:,575))
  call heltable([16,32,512], n3(:,1165), t3x512(:,:,576))
  call heltable([16,32,512], n3(:,1166), t3x512(:,:,577))
  call heltable([16,32,512], n3(:,1167), t3x512(:,:,578))
  call heltable([16,32,512], n3(:,1168), t3x512(:,:,579))
  call heltable([16,32,512], n3(:,1169), t3x512(:,:,580))
  call heltable([16,32,512], n3(:,1170), t3x512(:,:,581))
  call heltable([16,32,512], n3(:,1171), t3x512(:,:,582))
  call heltable([16,32,512], n3(:,1172), t3x512(:,:,583))
  call heltable([16,32,512], n3(:,1173), t3x512(:,:,584))
  call heltable([16,32,512], n3(:,1174), t3x512(:,:,585))
  call heltable([16,32,512], n3(:,1175), t3x512(:,:,586))
  call heltable([8,64,512], n3(:,1176), t3x512(:,:,587))
  call heltable([8,64,512], n3(:,1177), t3x512(:,:,588))
  call heltable([8,64,512], n3(:,1178), t3x512(:,:,589))
  call heltable([8,64,512], n3(:,1179), t3x512(:,:,590))
  call heltable([32,16,512], n3(:,1180), t3x512(:,:,591))
  call heltable([32,16,512], n3(:,1181), t3x512(:,:,592))
  call heltable([32,16,512], n3(:,1182), t3x512(:,:,593))
  call heltable([32,16,512], n3(:,1183), t3x512(:,:,594))
  call heltable([32,16,512], n3(:,1184), t3x512(:,:,595))
  call heltable([32,16,512], n3(:,1185), t3x512(:,:,596))
  call heltable([32,16,512], n3(:,1186), t3x512(:,:,597))
  call heltable([32,16,512], n3(:,1187), t3x512(:,:,598))
  call heltable([32,16,512], n3(:,1188), t3x512(:,:,599))
  call heltable([32,16,512], n3(:,1189), t3x512(:,:,600))
  call heltable([32,16,512], n3(:,1190), t3x512(:,:,601))
  call heltable([32,16,512], n3(:,1191), t3x512(:,:,602))
  call heltable([32,16,512], n3(:,1192), t3x512(:,:,603))
  call heltable([32,16,512], n3(:,1193), t3x512(:,:,604))
  call heltable([32,16,512], n3(:,1194), t3x512(:,:,605))
  call heltable([32,16,512], n3(:,1195), t3x512(:,:,606))
  call heltable([32,16,512], n3(:,1196), t3x512(:,:,607))
  call heltable([32,16,512], n3(:,1197), t3x512(:,:,608))
  call heltable([32,16,512], n3(:,1198), t3x512(:,:,609))
  call heltable([32,16,512], n3(:,1199), t3x512(:,:,610))
  call heltable([32,16,512], n3(:,1200), t3x512(:,:,611))
  call heltable([32,16,512], n3(:,1201), t3x512(:,:,612))
  call heltable([32,16,512], n3(:,1202), t3x512(:,:,613))
  call heltable([32,16,512], n3(:,1203), t3x512(:,:,614))
  call heltable([32,16,512], n3(:,1204), t3x512(:,:,615))
  call heltable([32,16,512], n3(:,1205), t3x512(:,:,616))
  call heltable([32,16,512], n3(:,1206), t3x512(:,:,617))
  call heltable([32,16,512], n3(:,1207), t3x512(:,:,618))
  call heltable([32,16,512], n3(:,1208), t3x512(:,:,619))
  call heltable([32,16,512], n3(:,1209), t3x512(:,:,620))
  call heltable([32,16,512], n3(:,1210), t3x512(:,:,621))
  call heltable([32,16,512], n3(:,1211), t3x512(:,:,622))
  call heltable([32,16,512], n3(:,1212), t3x512(:,:,623))
  call heltable([32,16,512], n3(:,1213), t3x512(:,:,624))
  call heltable([32,16,512], n3(:,1214), t3x512(:,:,625))
  call heltable([32,16,512], n3(:,1215), t3x512(:,:,626))
  call heltable([16,32,512], n3(:,1216), t3x512(:,:,627))
  call heltable([16,32,512], n3(:,1217), t3x512(:,:,628))
  call heltable([16,32,512], n3(:,1218), t3x512(:,:,629))
  call heltable([16,32,512], n3(:,1219), t3x512(:,:,630))
  call heltable([16,32,512], n3(:,1220), t3x512(:,:,631))
  call heltable([16,32,512], n3(:,1221), t3x512(:,:,632))
  call heltable([16,32,512], n3(:,1222), t3x512(:,:,633))
  call heltable([16,32,512], n3(:,1223), t3x512(:,:,634))
  call heltable([16,32,512], n3(:,1224), t3x512(:,:,635))
  call heltable([16,32,512], n3(:,1225), t3x512(:,:,636))
  call heltable([16,32,512], n3(:,1226), t3x512(:,:,637))
  call heltable([16,32,512], n3(:,1227), t3x512(:,:,638))
  call heltable([16,32,512], n3(:,1228), t3x512(:,:,639))
  call heltable([16,32,512], n3(:,1229), t3x512(:,:,640))
  call heltable([16,32,512], n3(:,1230), t3x512(:,:,641))
  call heltable([16,32,512], n3(:,1231), t3x512(:,:,642))
  call heltable([16,32,512], n3(:,1232), t3x512(:,:,643))
  call heltable([16,32,512], n3(:,1233), t3x512(:,:,644))
  call heltable([16,32,512], n3(:,1234), t3x512(:,:,645))
  call heltable([16,32,512], n3(:,1235), t3x512(:,:,646))
  call heltable([16,32,512], n3(:,1236), t3x512(:,:,647))
  call heltable([16,32,512], n3(:,1237), t3x512(:,:,648))
  call heltable([16,32,512], n3(:,1238), t3x512(:,:,649))
  call heltable([16,32,512], n3(:,1239), t3x512(:,:,650))
  call heltable([16,32,512], n3(:,1240), t3x512(:,:,651))
  call heltable([16,32,512], n3(:,1241), t3x512(:,:,652))
  call heltable([16,32,512], n3(:,1242), t3x512(:,:,653))
  call heltable([16,32,512], n3(:,1243), t3x512(:,:,654))
  call heltable([16,32,512], n3(:,1244), t3x512(:,:,655))
  call heltable([16,32,512], n3(:,1245), t3x512(:,:,656))
  call heltable([16,32,512], n3(:,1246), t3x512(:,:,657))
  call heltable([16,32,512], n3(:,1247), t3x512(:,:,658))
  call heltable([16,32,512], n3(:,1248), t3x512(:,:,659))
  call heltable([16,32,512], n3(:,1249), t3x512(:,:,660))
  call heltable([16,32,512], n3(:,1250), t3x512(:,:,661))
  call heltable([16,32,512], n3(:,1251), t3x512(:,:,662))
  call heltable([16,32,512], n3(:,1252), t3x512(:,:,663))
  call heltable([16,32,512], n3(:,1253), t3x512(:,:,664))
  call heltable([16,32,512], n3(:,1254), t3x512(:,:,665))
  call heltable([16,32,512], n3(:,1255), t3x512(:,:,666))
  call heltable([16,32,512], n3(:,1256), t3x512(:,:,667))
  call heltable([16,32,512], n3(:,1257), t3x512(:,:,668))
  call heltable([16,32,512], n3(:,1258), t3x512(:,:,669))
  call heltable([16,32,512], n3(:,1259), t3x512(:,:,670))
  call heltable([16,32,512], n3(:,1260), t3x512(:,:,671))
  call heltable([16,32,512], n3(:,1261), t3x512(:,:,672))
  call heltable([16,32,512], n3(:,1262), t3x512(:,:,673))
  call heltable([16,32,512], n3(:,1263), t3x512(:,:,674))
  call heltable([16,32,512], n3(:,1264), t3x512(:,:,675))
  call heltable([16,32,512], n3(:,1265), t3x512(:,:,676))
  call heltable([16,32,512], n3(:,1266), t3x512(:,:,677))
  call heltable([16,32,512], n3(:,1267), t3x512(:,:,678))
  call heltable([16,32,512], n3(:,1268), t3x512(:,:,679))
  call heltable([16,32,512], n3(:,1269), t3x512(:,:,680))
  call heltable([16,32,512], n3(:,1270), t3x512(:,:,681))
  call heltable([16,32,512], n3(:,1271), t3x512(:,:,682))
  call heltable([16,32,512], n3(:,1272), t3x512(:,:,683))
  call heltable([16,32,512], n3(:,1273), t3x512(:,:,684))
  call heltable([16,32,512], n3(:,1274), t3x512(:,:,685))
  call heltable([16,32,512], n3(:,1275), t3x512(:,:,686))
  call heltable([16,32,512], n3(:,1276), t3x512(:,:,687))
  call heltable([16,32,512], n3(:,1277), t3x512(:,:,688))
  call heltable([16,32,512], n3(:,1278), t3x512(:,:,689))
  call heltable([16,32,512], n3(:,1279), t3x512(:,:,690))
  call heltable([16,32,512], n3(:,1280), t3x512(:,:,691))
  call heltable([16,32,512], n3(:,1281), t3x512(:,:,692))
  call heltable([16,32,512], n3(:,1282), t3x512(:,:,693))
  call heltable([16,32,512], n3(:,1283), t3x512(:,:,694))
  call heltable([16,32,512], n3(:,1284), t3x512(:,:,695))
  call heltable([16,32,512], n3(:,1285), t3x512(:,:,696))
  call heltable([16,32,512], n3(:,1286), t3x512(:,:,697))
  call heltable([16,32,512], n3(:,1287), t3x512(:,:,698))
  call heltable([16,32,512], n3(:,1288), t3x512(:,:,699))
  call heltable([16,32,512], n3(:,1289), t3x512(:,:,700))
  call heltable([16,32,512], n3(:,1290), t3x512(:,:,701))
  call heltable([16,32,512], n3(:,1291), t3x512(:,:,702))
  call heltable([16,32,512], n3(:,1292), t3x512(:,:,703))
  call heltable([16,32,512], n3(:,1293), t3x512(:,:,704))
  call heltable([16,32,512], n3(:,1294), t3x512(:,:,705))
  call heltable([16,32,512], n3(:,1295), t3x512(:,:,706))
  call heltable([16,32,512], n3(:,1296), t3x512(:,:,707))
  call heltable([16,32,512], n3(:,1297), t3x512(:,:,708))
  call heltable([16,32,512], n3(:,1298), t3x512(:,:,709))
  call heltable([16,32,512], n3(:,1299), t3x512(:,:,710))
  call heltable([16,32,512], n3(:,1300), t3x512(:,:,711))
  call heltable([16,32,512], n3(:,1301), t3x512(:,:,712))
  call heltable([16,32,512], n3(:,1302), t3x512(:,:,713))
  call heltable([16,32,512], n3(:,1303), t3x512(:,:,714))
  call heltable([16,32,512], n3(:,1304), t3x512(:,:,715))
  call heltable([16,32,512], n3(:,1305), t3x512(:,:,716))
  call heltable([16,32,512], n3(:,1306), t3x512(:,:,717))
  call heltable([16,32,512], n3(:,1307), t3x512(:,:,718))
  call heltable([16,32,512], n3(:,1308), t3x512(:,:,719))
  call heltable([16,32,512], n3(:,1309), t3x512(:,:,720))
  call heltable([16,32,512], n3(:,1310), t3x512(:,:,721))
  call heltable([16,32,512], n3(:,1311), t3x512(:,:,722))
  call heltable([16,32,512], n3(:,1312), t3x512(:,:,723))
  call heltable([16,32,512], n3(:,1313), t3x512(:,:,724))
  call heltable([16,32,512], n3(:,1314), t3x512(:,:,725))
  call heltable([16,32,512], n3(:,1315), t3x512(:,:,726))
  call heltable([16,32,512], n3(:,1316), t3x512(:,:,727))
  call heltable([16,32,512], n3(:,1317), t3x512(:,:,728))
  call heltable([16,32,512], n3(:,1318), t3x512(:,:,729))
  call heltable([16,32,512], n3(:,1319), t3x512(:,:,730))
  call heltable([16,32,512], n3(:,1320), t3x512(:,:,731))
  call heltable([16,32,512], n3(:,1321), t3x512(:,:,732))
  call heltable([16,32,512], n3(:,1322), t3x512(:,:,733))
  call heltable([16,32,512], n3(:,1323), t3x512(:,:,734))
  call heltable([16,32,512], n3(:,1324), t3x512(:,:,735))
  call heltable([16,32,512], n3(:,1325), t3x512(:,:,736))
  call heltable([16,32,512], n3(:,1326), t3x512(:,:,737))
  call heltable([16,32,512], n3(:,1327), t3x512(:,:,738))
  call heltable([16,32,512], n3(:,1328), t3x512(:,:,739))
  call heltable([16,32,512], n3(:,1329), t3x512(:,:,740))
  call heltable([16,32,512], n3(:,1330), t3x512(:,:,741))
  call heltable([16,32,512], n3(:,1331), t3x512(:,:,742))
  call heltable([16,32,512], n3(:,1332), t3x512(:,:,743))
  call heltable([16,32,512], n3(:,1333), t3x512(:,:,744))
  call heltable([16,32,512], n3(:,1334), t3x512(:,:,745))
  call heltable([16,32,512], n3(:,1335), t3x512(:,:,746))
  call heltable([16,32,512], n3(:,1336), t3x512(:,:,747))
  call heltable([32,16,512], n3(:,1337), t3x512(:,:,748))
  call heltable([32,16,512], n3(:,1338), t3x512(:,:,749))
  call heltable([16,32,512], n3(:,1339), t3x512(:,:,750))
  call heltable([16,32,512], n3(:,1340), t3x512(:,:,751))
  call heltable([16,32,512], n3(:,1341), t3x512(:,:,752))
  call heltable([16,32,512], n3(:,1342), t3x512(:,:,753))
  call heltable([16,32,512], n3(:,1343), t3x512(:,:,754))
  call heltable([16,32,512], n3(:,1344), t3x512(:,:,755))
  call heltable([32,16,512], n3(:,1345), t3x512(:,:,756))
  call heltable([32,16,512], n3(:,1346), t3x512(:,:,757))
  call heltable([32,16,512], n3(:,1347), t3x512(:,:,758))
  call heltable([32,16,512], n3(:,1348), t3x512(:,:,759))
  call heltable([32,16,512], n3(:,1349), t3x512(:,:,760))
  call heltable([32,16,512], n3(:,1350), t3x512(:,:,761))
  call heltable([32,16,512], n3(:,1351), t3x512(:,:,762))
  call heltable([32,16,512], n3(:,1352), t3x512(:,:,763))
  call heltable([32,16,512], n3(:,1353), t3x512(:,:,764))
  call heltable([32,16,512], n3(:,1354), t3x512(:,:,765))
  call heltable([32,16,512], n3(:,1355), t3x512(:,:,766))
  call heltable([32,16,512], n3(:,1356), t3x512(:,:,767))
  call heltable([32,16,512], n3(:,1357), t3x512(:,:,768))
  call heltable([16,32,512], n3(:,1358), t3x512(:,:,769))
  call heltable([16,32,512], n3(:,1359), t3x512(:,:,770))
  call heltable([16,32,512], n3(:,1360), t3x512(:,:,771))
  call heltable([16,32,512], n3(:,1361), t3x512(:,:,772))
  call heltable([16,32,512], n3(:,1362), t3x512(:,:,773))
  call heltable([16,32,512], n3(:,1363), t3x512(:,:,774))
  call heltable([16,32,512], n3(:,1364), t3x512(:,:,775))
  call heltable([16,32,512], n3(:,1365), t3x512(:,:,776))
  call heltable([16,32,512], n3(:,1366), t3x512(:,:,777))
  call heltable([16,32,512], n3(:,1367), t3x512(:,:,778))
  call heltable([16,32,512], n3(:,1368), t3x512(:,:,779))
  call heltable([16,32,512], n3(:,1369), t3x512(:,:,780))
  call heltable([16,32,512], n3(:,1370), t3x512(:,:,781))
  call heltable([16,32,512], n3(:,1371), t3x512(:,:,782))
  call heltable([16,32,512], n3(:,1372), t3x512(:,:,783))
  call heltable([16,32,512], n3(:,1373), t3x512(:,:,784))
  call heltable([16,32,512], n3(:,1374), t3x512(:,:,785))
  call heltable([16,32,512], n3(:,1375), t3x512(:,:,786))
  call heltable([16,32,512], n3(:,1376), t3x512(:,:,787))
  call heltable([16,32,512], n3(:,1377), t3x512(:,:,788))
  call heltable([16,32,512], n3(:,1378), t3x512(:,:,789))
  call heltable([16,32,512], n3(:,1379), t3x512(:,:,790))
  call heltable([16,32,512], n3(:,1380), t3x512(:,:,791))
  call heltable([16,32,512], n3(:,1381), t3x512(:,:,792))
  call heltable([32,16,512], n3(:,1382), t3x512(:,:,793))
  call heltable([32,16,512], n3(:,1383), t3x512(:,:,794))
  call heltable([32,16,512], n3(:,1384), t3x512(:,:,795))
  call heltable([32,16,512], n3(:,1385), t3x512(:,:,796))
  call heltable([32,16,512], n3(:,1386), t3x512(:,:,797))
  call heltable([32,16,512], n3(:,1387), t3x512(:,:,798))
  call heltable([16,32,512], n3(:,1388), t3x512(:,:,799))
  call heltable([16,32,512], n3(:,1389), t3x512(:,:,800))
  call heltable([16,32,512], n3(:,1390), t3x512(:,:,801))
  call heltable([16,32,512], n3(:,1391), t3x512(:,:,802))
  call heltable([16,32,512], n3(:,1392), t3x512(:,:,803))
  call heltable([16,32,512], n3(:,1393), t3x512(:,:,804))
  call heltable([16,32,512], n3(:,1394), t3x512(:,:,805))
  call heltable([16,32,512], n3(:,1395), t3x512(:,:,806))
  call heltable([16,32,512], n3(:,1396), t3x512(:,:,807))
  call heltable([16,32,512], n3(:,1397), t3x512(:,:,808))
  call heltable([16,32,512], n3(:,1398), t3x512(:,:,809))
  call heltable([16,32,512], n3(:,1399), t3x512(:,:,810))
  call heltable([32,16,512], n3(:,1400), t3x512(:,:,811))
  call heltable([32,16,512], n3(:,1401), t3x512(:,:,812))
  call heltable([32,16,512], n3(:,1402), t3x512(:,:,813))
  call heltable([32,16,512], n3(:,1403), t3x512(:,:,814))
  call heltable([32,16,512], n3(:,1404), t3x512(:,:,815))
  call heltable([32,16,512], n3(:,1405), t3x512(:,:,816))
  call heltable([32,16,512], n3(:,1406), t3x512(:,:,817))
  call heltable([32,16,512], n3(:,1407), t3x512(:,:,818))
  call heltable([32,16,512], n3(:,1408), t3x512(:,:,819))
  call heltable([32,16,512], n3(:,1409), t3x512(:,:,820))
  call heltable([32,16,512], n3(:,1410), t3x512(:,:,821))
  call heltable([32,16,512], n3(:,1411), t3x512(:,:,822))
  call heltable([32,16,512], n3(:,1412), t3x512(:,:,823))
  call heltable([16,32,512], n3(:,1413), t3x512(:,:,824))
  call heltable([16,32,512], n3(:,1414), t3x512(:,:,825))
  call heltable([16,32,512], n3(:,1415), t3x512(:,:,826))
  call heltable([16,32,512], n3(:,1416), t3x512(:,:,827))
  call heltable([16,32,512], n3(:,1417), t3x512(:,:,828))
  call heltable([16,32,512], n3(:,1418), t3x512(:,:,829))
  call heltable([16,32,512], n3(:,1419), t3x512(:,:,830))
  call heltable([16,32,512], n3(:,1420), t3x512(:,:,831))
  call heltable([16,32,512], n3(:,1421), t3x512(:,:,832))
  call heltable([16,32,512], n3(:,1422), t3x512(:,:,833))
  call heltable([16,32,512], n3(:,1423), t3x512(:,:,834))
  call heltable([16,32,512], n3(:,1424), t3x512(:,:,835))
  call heltable([16,32,512], n3(:,1425), t3x512(:,:,836))
  call heltable([16,32,512], n3(:,1426), t3x512(:,:,837))
  call heltable([16,32,512], n3(:,1427), t3x512(:,:,838))
  call heltable([16,32,512], n3(:,1428), t3x512(:,:,839))
  call heltable([16,32,512], n3(:,1429), t3x512(:,:,840))
  call heltable([16,32,512], n3(:,1430), t3x512(:,:,841))
  call heltable([16,32,512], n3(:,1431), t3x512(:,:,842))
  call heltable([16,32,512], n3(:,1432), t3x512(:,:,843))
  call heltable([16,32,512], n3(:,1433), t3x512(:,:,844))
  call heltable([16,32,512], n3(:,1434), t3x512(:,:,845))
  call heltable([16,32,512], n3(:,1435), t3x512(:,:,846))
  call heltable([16,32,512], n3(:,1436), t3x512(:,:,847))
  call heltable([16,32,512], n3(:,1437), t3x512(:,:,848))
  call heltable([16,32,512], n3(:,1438), t3x512(:,:,849))
  call heltable([16,32,512], n3(:,1439), t3x512(:,:,850))
  call heltable([16,32,512], n3(:,1440), t3x512(:,:,851))
  call heltable([16,32,512], n3(:,1441), t3x512(:,:,852))
  call heltable([16,32,512], n3(:,1442), t3x512(:,:,853))
  call heltable([16,32,512], n3(:,1443), t3x512(:,:,854))
  call heltable([16,32,512], n3(:,1444), t3x512(:,:,855))
  call heltable([16,32,512], n3(:,1445), t3x512(:,:,856))
  call heltable([32,16,512], n3(:,1446), t3x512(:,:,857))
  call heltable([32,16,512], n3(:,1447), t3x512(:,:,858))
  call heltable([32,16,512], n3(:,1448), t3x512(:,:,859))
  call heltable([32,16,512], n3(:,1449), t3x512(:,:,860))
  call heltable([32,16,512], n3(:,1450), t3x512(:,:,861))
  call heltable([32,16,512], n3(:,1451), t3x512(:,:,862))
  call heltable([32,16,512], n3(:,1452), t3x512(:,:,863))
  call heltable([32,16,512], n3(:,1453), t3x512(:,:,864))
  call heltable([32,16,512], n3(:,1454), t3x512(:,:,865))
  call heltable([16,32,512], n3(:,1455), t3x512(:,:,866))
  call heltable([16,32,512], n3(:,1456), t3x512(:,:,867))
  call heltable([16,32,512], n3(:,1457), t3x512(:,:,868))
  call heltable([16,32,512], n3(:,1458), t3x512(:,:,869))
  call heltable([16,32,512], n3(:,1459), t3x512(:,:,870))
  call heltable([16,32,512], n3(:,1460), t3x512(:,:,871))
  call heltable([16,32,512], n3(:,1461), t3x512(:,:,872))
  call heltable([16,32,512], n3(:,1462), t3x512(:,:,873))
  call heltable([16,32,512], n3(:,1463), t3x512(:,:,874))
  call heltable([32,16,512], n3(:,1464), t3x512(:,:,875))
  call heltable([32,16,512], n3(:,1465), t3x512(:,:,876))
  call heltable([32,16,512], n3(:,1466), t3x512(:,:,877))
  call heltable([16,32,512], n3(:,1467), t3x512(:,:,878))
  call heltable([16,32,512], n3(:,1468), t3x512(:,:,879))
  call heltable([16,32,512], n3(:,1469), t3x512(:,:,880))
  call heltable([16,32,512], n3(:,1470), t3x512(:,:,881))
  call heltable([16,32,512], n3(:,1471), t3x512(:,:,882))
  call heltable([16,32,512], n3(:,1472), t3x512(:,:,883))
  call heltable([16,32,512], n3(:,1473), t3x512(:,:,884))
  call heltable([16,32,512], n3(:,1474), t3x512(:,:,885))
  call heltable([16,32,512], n3(:,1475), t3x512(:,:,886))
  call heltable([16,32,512], n3(:,1476), t3x512(:,:,887))
  call heltable([16,32,512], n3(:,1477), t3x512(:,:,888))
  call heltable([16,32,512], n3(:,1478), t3x512(:,:,889))
  call heltable([16,32,512], n3(:,1479), t3x512(:,:,890))
  call heltable([16,32,512], n3(:,1480), t3x512(:,:,891))
  call heltable([16,32,512], n3(:,1481), t3x512(:,:,892))
  call heltable([16,32,512], n3(:,1482), t3x512(:,:,893))
  call heltable([16,32,512], n3(:,1483), t3x512(:,:,894))
  call heltable([16,32,512], n3(:,1484), t3x512(:,:,895))
  call heltable([16,32,512], n3(:,1485), t3x512(:,:,896))
  call heltable([16,32,512], n3(:,1486), t3x512(:,:,897))
  call heltable([16,32,512], n3(:,1487), t3x512(:,:,898))
  call heltable([8,64,512], n3(:,1488), t3x512(:,:,899))
  call heltable([32,16,512], n3(:,1489), t3x512(:,:,900))
  call heltable([32,16,512], n3(:,1490), t3x512(:,:,901))
  call heltable([32,16,512], n3(:,1491), t3x512(:,:,902))
  call heltable([32,16,512], n3(:,1492), t3x512(:,:,903))
  call heltable([16,32,512], n3(:,1493), t3x512(:,:,904))
  call heltable([16,32,512], n3(:,1494), t3x512(:,:,905))
  call heltable([16,32,512], n3(:,1495), t3x512(:,:,906))
  call heltable([32,16,512], n3(:,1496), t3x512(:,:,907))
  call heltable([32,16,512], n3(:,1497), t3x512(:,:,908))
  call heltable([32,16,512], n3(:,1498), t3x512(:,:,909))
  call heltable([32,16,512], n3(:,1499), t3x512(:,:,910))
  call heltable([16,32,512], n3(:,1500), t3x512(:,:,911))
  call heltable([16,32,512], n3(:,1501), t3x512(:,:,912))
  call heltable([16,32,512], n3(:,1502), t3x512(:,:,913))
  call heltable([16,32,512], n3(:,1503), t3x512(:,:,914))
  call heltable([16,32,512], n3(:,1504), t3x512(:,:,915))
  call heltable([16,32,512], n3(:,1505), t3x512(:,:,916))
  call heltable([16,32,512], n3(:,1506), t3x512(:,:,917))
  call heltable([16,32,512], n3(:,1507), t3x512(:,:,918))
  call heltable([16,32,512], n3(:,1508), t3x512(:,:,919))
  call heltable([16,32,512], n3(:,1509), t3x512(:,:,920))
  call heltable([16,32,512], n3(:,1510), t3x512(:,:,921))
  call heltable([16,32,512], n3(:,1511), t3x512(:,:,922))
  call heltable([16,32,512], n3(:,1512), t3x512(:,:,923))
  call heltable([16,32,512], n3(:,1513), t3x512(:,:,924))
  call heltable([16,32,512], n3(:,1514), t3x512(:,:,925))
  call heltable([16,32,512], n3(:,1515), t3x512(:,:,926))
  call heltable([16,32,512], n3(:,1516), t3x512(:,:,927))
  call heltable([16,32,512], n3(:,1517), t3x512(:,:,928))
  call heltable([16,32,512], n3(:,1518), t3x512(:,:,929))
  call heltable([16,32,512], n3(:,1519), t3x512(:,:,930))
  call heltable([16,32,512], n3(:,1520), t3x512(:,:,931))
  call heltable([8,64,512], n3(:,1521), t3x512(:,:,932))
  call heltable([16,32,512], n3(:,1522), t3x512(:,:,933))
  call heltable([32,16,512], n3(:,1523), t3x512(:,:,934))
  call heltable([32,16,512], n3(:,1524), t3x512(:,:,935))
  call heltable([32,16,512], n3(:,1525), t3x512(:,:,936))
  call heltable([16,32,512], n3(:,1526), t3x512(:,:,937))
  call heltable([16,32,512], n3(:,1527), t3x512(:,:,938))
  call heltable([16,32,512], n3(:,1528), t3x512(:,:,939))
  call heltable([32,16,512], n3(:,1529), t3x512(:,:,940))
  call heltable([32,16,512], n3(:,1530), t3x512(:,:,941))
  call heltable([32,16,512], n3(:,1531), t3x512(:,:,942))
  call heltable([32,16,512], n3(:,1532), t3x512(:,:,943))
  call heltable([16,32,512], n3(:,1533), t3x512(:,:,944))
  call heltable([16,32,512], n3(:,1534), t3x512(:,:,945))
  call heltable([16,32,512], n3(:,1535), t3x512(:,:,946))
  call heltable([16,32,512], n3(:,1536), t3x512(:,:,947))
  call heltable([16,32,512], n3(:,1537), t3x512(:,:,948))
  call heltable([16,32,512], n3(:,1538), t3x512(:,:,949))
  call heltable([16,32,512], n3(:,1539), t3x512(:,:,950))
  call heltable([16,32,512], n3(:,1540), t3x512(:,:,951))
  call heltable([16,32,512], n3(:,1541), t3x512(:,:,952))
  call heltable([16,32,512], n3(:,1542), t3x512(:,:,953))
  call heltable([16,32,512], n3(:,1543), t3x512(:,:,954))
  call heltable([16,32,512], n3(:,1544), t3x512(:,:,955))
  call heltable([16,32,512], n3(:,1545), t3x512(:,:,956))
  call heltable([16,32,512], n3(:,1546), t3x512(:,:,957))
  call heltable([16,32,512], n3(:,1547), t3x512(:,:,958))
  call heltable([16,32,512], n3(:,1548), t3x512(:,:,959))
  call heltable([16,32,512], n3(:,1549), t3x512(:,:,960))
  call heltable([16,32,512], n3(:,1550), t3x512(:,:,961))
  call heltable([16,32,512], n3(:,1551), t3x512(:,:,962))
  call heltable([16,32,512], n3(:,1552), t3x512(:,:,963))
  call heltable([16,32,512], n3(:,1553), t3x512(:,:,964))
  call heltable([16,32,512], n3(:,1554), t3x512(:,:,965))
  call heltable([16,32,512], n3(:,1555), t3x512(:,:,966))
  call heltable([32,16,512], n3(:,1556), t3x512(:,:,967))
  call heltable([32,16,512], n3(:,1557), t3x512(:,:,968))
  call heltable([32,16,512], n3(:,1558), t3x512(:,:,969))
  call heltable([32,16,512], n3(:,1559), t3x512(:,:,970))
  call heltable([32,16,512], n3(:,1560), t3x512(:,:,971))
  call heltable([32,16,512], n3(:,1561), t3x512(:,:,972))
  call heltable([32,16,512], n3(:,1562), t3x512(:,:,973))
  call heltable([32,16,512], n3(:,1563), t3x512(:,:,974))
  call heltable([32,16,512], n3(:,1564), t3x512(:,:,975))
  call heltable([32,16,512], n3(:,1565), t3x512(:,:,976))
  call heltable([32,16,512], n3(:,1566), t3x512(:,:,977))
  call heltable([32,16,512], n3(:,1567), t3x512(:,:,978))
  call heltable([32,16,512], n3(:,1568), t3x512(:,:,979))
  call heltable([32,16,512], n3(:,1569), t3x512(:,:,980))
  call heltable([8,64,512], n3(:,1570), t3x512(:,:,981))
  call heltable([8,64,512], n3(:,1571), t3x512(:,:,982))
  call heltable([8,64,512], n3(:,1572), t3x512(:,:,983))
  call heltable([8,64,512], n3(:,1573), t3x512(:,:,984))
  call heltable([16,32,512], n3(:,1574), t3x512(:,:,985))
  call heltable([16,32,512], n3(:,1575), t3x512(:,:,986))
  call heltable([16,32,512], n3(:,1576), t3x512(:,:,987))
  call heltable([16,32,512], n3(:,1577), t3x512(:,:,988))
  call heltable([32,16,512], n3(:,1578), t3x512(:,:,989))
  call heltable([32,16,512], n3(:,1579), t3x512(:,:,990))
  call heltable([32,16,512], n3(:,1580), t3x512(:,:,991))
  call heltable([32,16,512], n3(:,1581), t3x512(:,:,992))
  call heltable([32,16,512], n3(:,1582), t3x512(:,:,993))
  call heltable([32,16,512], n3(:,1583), t3x512(:,:,994))
  call heltable([32,16,512], n3(:,1584), t3x512(:,:,995))
  call heltable([32,16,512], n3(:,1585), t3x512(:,:,996))
  call heltable([16,32,512], n3(:,1586), t3x512(:,:,997))
  call heltable([16,32,512], n3(:,1587), t3x512(:,:,998))
  call heltable([32,16,512], n3(:,1588), t3x512(:,:,999))
  call heltable([32,16,512], n3(:,1589), t3x512(:,:,1000))
  call heltable([32,16,512], n3(:,1590), t3x512(:,:,1001))
  call heltable([32,16,512], n3(:,1591), t3x512(:,:,1002))
  call heltable([32,16,512], n3(:,1592), t3x512(:,:,1003))
  call heltable([32,16,512], n3(:,1593), t3x512(:,:,1004))
  call heltable([32,16,512], n3(:,1594), t3x512(:,:,1005))
  call heltable([32,16,512], n3(:,1595), t3x512(:,:,1006))
  call heltable([32,16,512], n3(:,1596), t3x512(:,:,1007))
  call heltable([32,16,512], n3(:,1597), t3x512(:,:,1008))
  call heltable([32,16,512], n3(:,1598), t3x512(:,:,1009))
  call heltable([32,16,512], n3(:,1599), t3x512(:,:,1010))
  call heltable([32,16,512], n3(:,1600), t3x512(:,:,1011))
  call heltable([16,32,512], n3(:,1601), t3x512(:,:,1012))
  call heltable([16,32,512], n3(:,1602), t3x512(:,:,1013))
  call heltable([16,32,512], n3(:,1603), t3x512(:,:,1014))
  call heltable([16,32,512], n3(:,1604), t3x512(:,:,1015))
  call heltable([16,32,512], n3(:,1605), t3x512(:,:,1016))
  call heltable([16,32,512], n3(:,1606), t3x512(:,:,1017))
  call heltable([8,64,512], n3(:,1607), t3x512(:,:,1018))
  call heltable([16,32,512], n3(:,1608), t3x512(:,:,1019))
  call heltable([16,32,512], n3(:,1609), t3x512(:,:,1020))
  call heltable([16,32,512], n3(:,1610), t3x512(:,:,1021))
  call heltable([16,32,512], n3(:,1611), t3x512(:,:,1022))
  call heltable([16,32,512], n3(:,1612), t3x512(:,:,1023))
  call heltable([32,16,512], n3(:,1613), t3x512(:,:,1024))
  call heltable([32,16,512], n3(:,1614), t3x512(:,:,1025))
  call heltable([32,16,512], n3(:,1615), t3x512(:,:,1026))
  call heltable([32,16,512], n3(:,1616), t3x512(:,:,1027))
  call heltable([32,16,512], n3(:,1617), t3x512(:,:,1028))
  call heltable([32,16,512], n3(:,1618), t3x512(:,:,1029))
  call heltable([32,16,512], n3(:,1619), t3x512(:,:,1030))
  call heltable([32,16,512], n3(:,1620), t3x512(:,:,1031))
  call heltable([32,16,512], n3(:,1621), t3x512(:,:,1032))
  call heltable([32,16,512], n3(:,1622), t3x512(:,:,1033))
  call heltable([32,16,512], n3(:,1623), t3x512(:,:,1034))
  call heltable([32,16,512], n3(:,1624), t3x512(:,:,1035))
  call heltable([32,16,512], n3(:,1625), t3x512(:,:,1036))
  call heltable([32,16,512], n3(:,1626), t3x512(:,:,1037))
  call heltable([8,64,512], n3(:,1627), t3x512(:,:,1038))
  call heltable([8,64,512], n3(:,1628), t3x512(:,:,1039))
  call heltable([8,64,512], n3(:,1629), t3x512(:,:,1040))
  call heltable([8,64,512], n3(:,1630), t3x512(:,:,1041))
  call heltable([16,32,512], n3(:,1631), t3x512(:,:,1042))
  call heltable([16,32,512], n3(:,1632), t3x512(:,:,1043))
  call heltable([16,32,512], n3(:,1633), t3x512(:,:,1044))
  call heltable([16,32,512], n3(:,1634), t3x512(:,:,1045))
  call heltable([32,16,512], n3(:,1635), t3x512(:,:,1046))
  call heltable([32,16,512], n3(:,1636), t3x512(:,:,1047))
  call heltable([32,16,512], n3(:,1637), t3x512(:,:,1048))
  call heltable([32,16,512], n3(:,1638), t3x512(:,:,1049))
  call heltable([32,16,512], n3(:,1639), t3x512(:,:,1050))
  call heltable([32,16,512], n3(:,1640), t3x512(:,:,1051))
  call heltable([32,16,512], n3(:,1641), t3x512(:,:,1052))
  call heltable([32,16,512], n3(:,1642), t3x512(:,:,1053))
  call heltable([32,16,512], n3(:,1643), t3x512(:,:,1054))
  call heltable([32,16,512], n3(:,1644), t3x512(:,:,1055))
  call heltable([32,16,512], n3(:,1645), t3x512(:,:,1056))
  call heltable([32,16,512], n3(:,1646), t3x512(:,:,1057))
  call heltable([32,16,512], n3(:,1647), t3x512(:,:,1058))
  call heltable([32,16,512], n3(:,1648), t3x512(:,:,1059))
  call heltable([32,16,512], n3(:,1649), t3x512(:,:,1060))
  call heltable([32,16,512], n3(:,1650), t3x512(:,:,1061))
  call heltable([32,16,512], n3(:,1651), t3x512(:,:,1062))
  call heltable([32,16,512], n3(:,1652), t3x512(:,:,1063))
  call heltable([32,16,512], n3(:,1653), t3x512(:,:,1064))
  call heltable([32,16,512], n3(:,1654), t3x512(:,:,1065))
  call heltable([32,16,512], n3(:,1655), t3x512(:,:,1066))
  call heltable([32,16,512], n3(:,1656), t3x512(:,:,1067))
  call heltable([32,16,512], n3(:,1657), t3x512(:,:,1068))
  call heltable([16,32,512], n3(:,1658), t3x512(:,:,1069))
  call heltable([16,32,512], n3(:,1659), t3x512(:,:,1070))
  call heltable([16,32,512], n3(:,1660), t3x512(:,:,1071))
  call heltable([16,32,512], n3(:,1661), t3x512(:,:,1072))
  call heltable([16,32,512], n3(:,1662), t3x512(:,:,1073))
  call heltable([16,32,512], n3(:,1663), t3x512(:,:,1074))
  call heltable([8,64,512], n3(:,1664), t3x512(:,:,1075))
  call heltable([16,32,512], n3(:,1665), t3x512(:,:,1076))
  call heltable([16,32,512], n3(:,1666), t3x512(:,:,1077))
  call heltable([32,16,512], n3(:,1667), t3x512(:,:,1078))
  call heltable([32,16,512], n3(:,1668), t3x512(:,:,1079))
  call heltable([32,16,512], n3(:,1669), t3x512(:,:,1080))
  call heltable([16,32,512], n3(:,1670), t3x512(:,:,1081))
  call heltable([16,32,512], n3(:,1671), t3x512(:,:,1082))
  call heltable([16,32,512], n3(:,1672), t3x512(:,:,1083))
  call heltable([16,32,512], n3(:,1673), t3x512(:,:,1084))
  call heltable([16,32,512], n3(:,1674), t3x512(:,:,1085))
  call heltable([16,32,512], n3(:,1675), t3x512(:,:,1086))
  call heltable([16,32,512], n3(:,1676), t3x512(:,:,1087))
  call heltable([16,32,512], n3(:,1677), t3x512(:,:,1088))
  call heltable([16,32,512], n3(:,1678), t3x512(:,:,1089))
  call heltable([16,32,512], n3(:,1679), t3x512(:,:,1090))
  call heltable([16,32,512], n3(:,1680), t3x512(:,:,1091))
  call heltable([16,32,512], n3(:,1681), t3x512(:,:,1092))
  call heltable([16,32,512], n3(:,1682), t3x512(:,:,1093))
  call heltable([16,32,512], n3(:,1683), t3x512(:,:,1094))
  call heltable([16,32,512], n3(:,1684), t3x512(:,:,1095))
  call heltable([16,32,512], n3(:,1685), t3x512(:,:,1096))
  call heltable([16,32,512], n3(:,1686), t3x512(:,:,1097))
  call heltable([16,32,512], n3(:,1687), t3x512(:,:,1098))
  call heltable([16,32,512], n3(:,1688), t3x512(:,:,1099))
  call heltable([16,32,512], n3(:,1689), t3x512(:,:,1100))
  call heltable([16,32,512], n3(:,1690), t3x512(:,:,1101))
  call heltable([16,32,512], n3(:,1691), t3x512(:,:,1102))
  call heltable([16,32,512], n3(:,1692), t3x512(:,:,1103))
  call heltable([16,32,512], n3(:,1693), t3x512(:,:,1104))
  call heltable([16,32,512], n3(:,1694), t3x512(:,:,1105))
  call heltable([16,32,512], n3(:,1695), t3x512(:,:,1106))
  call heltable([16,32,512], n3(:,1696), t3x512(:,:,1107))
  call heltable([16,32,512], n3(:,1697), t3x512(:,:,1108))
  call heltable([16,32,512], n3(:,1698), t3x512(:,:,1109))
  call heltable([16,32,512], n3(:,1699), t3x512(:,:,1110))
  call heltable([16,32,512], n3(:,1700), t3x512(:,:,1111))
  call heltable([16,32,512], n3(:,1701), t3x512(:,:,1112))
  call heltable([16,32,512], n3(:,1702), t3x512(:,:,1113))
  call heltable([16,32,512], n3(:,1703), t3x512(:,:,1114))
  call heltable([16,32,512], n3(:,1704), t3x512(:,:,1115))
  call heltable([16,32,512], n3(:,1705), t3x512(:,:,1116))
  call heltable([16,32,512], n3(:,1706), t3x512(:,:,1117))
  call heltable([16,32,512], n3(:,1707), t3x512(:,:,1118))
  call heltable([16,32,512], n3(:,1708), t3x512(:,:,1119))
  call heltable([16,32,512], n3(:,1709), t3x512(:,:,1120))
  call heltable([16,32,512], n3(:,1710), t3x512(:,:,1121))
  call heltable([16,32,512], n3(:,1711), t3x512(:,:,1122))
  call heltable([16,32,512], n3(:,1712), t3x512(:,:,1123))
  call heltable([16,32,512], n3(:,1713), t3x512(:,:,1124))
  call heltable([16,32,512], n3(:,1714), t3x512(:,:,1125))
  call heltable([16,32,512], n3(:,1715), t3x512(:,:,1126))
  call heltable([16,32,512], n3(:,1716), t3x512(:,:,1127))
  call heltable([16,32,512], n3(:,1717), t3x512(:,:,1128))
  call heltable([16,32,512], n3(:,1718), t3x512(:,:,1129))
  call heltable([16,32,512], n3(:,1719), t3x512(:,:,1130))
  call heltable([16,32,512], n3(:,1720), t3x512(:,:,1131))
  call heltable([16,32,512], n3(:,1721), t3x512(:,:,1132))
  call heltable([16,32,512], n3(:,1722), t3x512(:,:,1133))
  call heltable([16,32,512], n3(:,1723), t3x512(:,:,1134))
  call heltable([16,32,512], n3(:,1724), t3x512(:,:,1135))
  call heltable([16,32,512], n3(:,1725), t3x512(:,:,1136))
  call heltable([16,32,512], n3(:,1726), t3x512(:,:,1137))
  call heltable([16,32,512], n3(:,1727), t3x512(:,:,1138))
  call heltable([16,32,512], n3(:,1728), t3x512(:,:,1139))
  call heltable([16,32,512], n3(:,1729), t3x512(:,:,1140))
  call heltable([16,32,512], n3(:,1730), t3x512(:,:,1141))
  call heltable([16,32,512], n3(:,1731), t3x512(:,:,1142))
  call heltable([16,32,512], n3(:,1732), t3x512(:,:,1143))
  call heltable([32,16,512], n3(:,1733), t3x512(:,:,1144))
  call heltable([32,16,512], n3(:,1734), t3x512(:,:,1145))
  call heltable([32,16,512], n3(:,1735), t3x512(:,:,1146))
  call heltable([32,16,512], n3(:,1736), t3x512(:,:,1147))
  call heltable([32,16,512], n3(:,1737), t3x512(:,:,1148))
  call heltable([32,16,512], n3(:,1738), t3x512(:,:,1149))
  call heltable([32,16,512], n3(:,1739), t3x512(:,:,1150))
  call heltable([32,16,512], n3(:,1740), t3x512(:,:,1151))
  call heltable([32,16,512], n3(:,1741), t3x512(:,:,1152))
  call heltable([32,16,512], n3(:,1742), t3x512(:,:,1153))
  call heltable([32,16,512], n3(:,1743), t3x512(:,:,1154))
  call heltable([32,16,512], n3(:,1744), t3x512(:,:,1155))
  call heltable([32,16,512], n3(:,1745), t3x512(:,:,1156))
  call heltable([32,16,512], n3(:,1746), t3x512(:,:,1157))
  call heltable([8,64,512], n3(:,1747), t3x512(:,:,1158))
  call heltable([8,64,512], n3(:,1748), t3x512(:,:,1159))
  call heltable([8,64,512], n3(:,1749), t3x512(:,:,1160))
  call heltable([8,64,512], n3(:,1750), t3x512(:,:,1161))
  call heltable([16,32,512], n3(:,1751), t3x512(:,:,1162))
  call heltable([16,32,512], n3(:,1752), t3x512(:,:,1163))
  call heltable([16,32,512], n3(:,1753), t3x512(:,:,1164))
  call heltable([16,32,512], n3(:,1754), t3x512(:,:,1165))
  call heltable([32,16,512], n3(:,1755), t3x512(:,:,1166))
  call heltable([32,16,512], n3(:,1756), t3x512(:,:,1167))
  call heltable([32,16,512], n3(:,1757), t3x512(:,:,1168))
  call heltable([32,16,512], n3(:,1758), t3x512(:,:,1169))
  call heltable([32,16,512], n3(:,1759), t3x512(:,:,1170))
  call heltable([32,16,512], n3(:,1760), t3x512(:,:,1171))
  call heltable([32,16,512], n3(:,1761), t3x512(:,:,1172))
  call heltable([32,16,512], n3(:,1762), t3x512(:,:,1173))
  call heltable([8,64,512], n3(:,1763), t3x512(:,:,1174))
  call heltable([32,16,512], n3(:,1764), t3x512(:,:,1175))
  call heltable([32,16,512], n3(:,1765), t3x512(:,:,1176))
  call heltable([32,16,512], n3(:,1766), t3x512(:,:,1177))
  call heltable([32,16,512], n3(:,1767), t3x512(:,:,1178))
  call heltable([32,16,512], n3(:,1768), t3x512(:,:,1179))
  call heltable([32,16,512], n3(:,1769), t3x512(:,:,1180))
  call heltable([32,16,512], n3(:,1770), t3x512(:,:,1181))
  call heltable([16,32,512], n3(:,1771), t3x512(:,:,1182))
  call heltable([16,32,512], n3(:,1772), t3x512(:,:,1183))
  call heltable([16,32,512], n3(:,1773), t3x512(:,:,1184))
  call heltable([32,16,512], n3(:,1774), t3x512(:,:,1185))
  call heltable([32,16,512], n3(:,1775), t3x512(:,:,1186))
  call heltable([32,16,512], n3(:,1776), t3x512(:,:,1187))
  call heltable([32,16,512], n3(:,1777), t3x512(:,:,1188))
  call heltable([32,16,512], n3(:,1778), t3x512(:,:,1189))
  call heltable([32,16,512], n3(:,1779), t3x512(:,:,1190))
  call heltable([16,32,512], n3(:,1780), t3x512(:,:,1191))
  call heltable([16,32,512], n3(:,1781), t3x512(:,:,1192))
  call heltable([16,32,512], n3(:,1782), t3x512(:,:,1193))
  call heltable([16,32,512], n3(:,1783), t3x512(:,:,1194))
  call heltable([16,32,512], n3(:,1784), t3x512(:,:,1195))
  call heltable([16,32,512], n3(:,1785), t3x512(:,:,1196))
  call heltable([16,32,512], n3(:,1786), t3x512(:,:,1197))
  call heltable([16,32,512], n3(:,1787), t3x512(:,:,1198))
  call heltable([16,32,512], n3(:,1788), t3x512(:,:,1199))
  call heltable([16,32,512], n3(:,1789), t3x512(:,:,1200))
  call heltable([32,16,512], n3(:,1790), t3x512(:,:,1201))
  call heltable([32,16,512], n3(:,1791), t3x512(:,:,1202))
  call heltable([32,16,512], n3(:,1792), t3x512(:,:,1203))
  call heltable([32,16,512], n3(:,1793), t3x512(:,:,1204))
  call heltable([32,16,512], n3(:,1794), t3x512(:,:,1205))
  call heltable([32,16,512], n3(:,1795), t3x512(:,:,1206))
  call heltable([32,16,512], n3(:,1796), t3x512(:,:,1207))
  call heltable([32,16,512], n3(:,1797), t3x512(:,:,1208))
  call heltable([32,16,512], n3(:,1798), t3x512(:,:,1209))
  call heltable([32,16,512], n3(:,1799), t3x512(:,:,1210))
  call heltable([32,16,512], n3(:,1800), t3x512(:,:,1211))
  call heltable([32,16,512], n3(:,1801), t3x512(:,:,1212))
  call heltable([32,16,512], n3(:,1802), t3x512(:,:,1213))
  call heltable([32,16,512], n3(:,1803), t3x512(:,:,1214))
  call heltable([8,64,512], n3(:,1804), t3x512(:,:,1215))
  call heltable([8,64,512], n3(:,1805), t3x512(:,:,1216))
  call heltable([8,64,512], n3(:,1806), t3x512(:,:,1217))
  call heltable([8,64,512], n3(:,1807), t3x512(:,:,1218))
  call heltable([16,32,512], n3(:,1808), t3x512(:,:,1219))
  call heltable([16,32,512], n3(:,1809), t3x512(:,:,1220))
  call heltable([16,32,512], n3(:,1810), t3x512(:,:,1221))
  call heltable([16,32,512], n3(:,1811), t3x512(:,:,1222))
  call heltable([32,16,512], n3(:,1812), t3x512(:,:,1223))
  call heltable([32,16,512], n3(:,1813), t3x512(:,:,1224))
  call heltable([32,16,512], n3(:,1814), t3x512(:,:,1225))
  call heltable([32,16,512], n3(:,1815), t3x512(:,:,1226))
  call heltable([32,16,512], n3(:,1816), t3x512(:,:,1227))
  call heltable([32,16,512], n3(:,1817), t3x512(:,:,1228))
  call heltable([32,16,512], n3(:,1818), t3x512(:,:,1229))
  call heltable([32,16,512], n3(:,1819), t3x512(:,:,1230))
  call heltable([8,64,512], n3(:,1820), t3x512(:,:,1231))
  call heltable([32,16,512], n3(:,1821), t3x512(:,:,1232))
  call heltable([32,16,512], n3(:,1822), t3x512(:,:,1233))
  call heltable([32,16,512], n3(:,1823), t3x512(:,:,1234))
  call heltable([32,16,512], n3(:,1824), t3x512(:,:,1235))
  call heltable([32,16,512], n3(:,1825), t3x512(:,:,1236))
  call heltable([32,16,512], n3(:,1826), t3x512(:,:,1237))
  call heltable([32,16,512], n3(:,1827), t3x512(:,:,1238))
  call heltable([32,16,512], n3(:,1828), t3x512(:,:,1239))
  call heltable([32,16,512], n3(:,1829), t3x512(:,:,1240))
  call heltable([32,16,512], n3(:,1830), t3x512(:,:,1241))
  call heltable([32,16,512], n3(:,1831), t3x512(:,:,1242))
  call heltable([32,16,512], n3(:,1832), t3x512(:,:,1243))
  call heltable([32,16,512], n3(:,1833), t3x512(:,:,1244))
  call heltable([32,16,512], n3(:,1834), t3x512(:,:,1245))
  call heltable([32,16,512], n3(:,1835), t3x512(:,:,1246))
  call heltable([32,16,512], n3(:,1836), t3x512(:,:,1247))
  call heltable([16,32,512], n3(:,1837), t3x512(:,:,1248))
  call heltable([16,32,512], n3(:,1838), t3x512(:,:,1249))
  call heltable([16,32,512], n3(:,1839), t3x512(:,:,1250))
  call heltable([16,32,512], n3(:,1840), t3x512(:,:,1251))
  call heltable([16,32,512], n3(:,1841), t3x512(:,:,1252))
  call heltable([16,32,512], n3(:,1842), t3x512(:,:,1253))
  call heltable([16,32,512], n3(:,1843), t3x512(:,:,1254))
  call heltable([16,32,512], n3(:,1844), t3x512(:,:,1255))
  call heltable([32,16,512], n3(:,1845), t3x512(:,:,1256))
  call heltable([32,16,512], n3(:,1846), t3x512(:,:,1257))
  call heltable([16,32,512], n3(:,1847), t3x512(:,:,1258))
  call heltable([16,32,512], n3(:,1848), t3x512(:,:,1259))
  call heltable([16,32,512], n3(:,1849), t3x512(:,:,1260))
  call heltable([16,32,512], n3(:,1850), t3x512(:,:,1261))
  call heltable([16,32,512], n3(:,1851), t3x512(:,:,1262))
  call heltable([16,32,512], n3(:,1852), t3x512(:,:,1263))
  call heltable([16,32,512], n3(:,1853), t3x512(:,:,1264))
  call heltable([16,32,512], n3(:,1854), t3x512(:,:,1265))
  call heltable([16,32,512], n3(:,1855), t3x512(:,:,1266))
  call heltable([16,32,512], n3(:,1856), t3x512(:,:,1267))
  call heltable([16,32,512], n3(:,1857), t3x512(:,:,1268))
  call heltable([16,32,512], n3(:,1858), t3x512(:,:,1269))
  call heltable([16,32,512], n3(:,1859), t3x512(:,:,1270))
  call heltable([16,32,512], n3(:,1860), t3x512(:,:,1271))
  call heltable([16,32,512], n3(:,1861), t3x512(:,:,1272))
  call heltable([16,32,512], n3(:,1862), t3x512(:,:,1273))
  call heltable([16,32,512], n3(:,1863), t3x512(:,:,1274))
  call heltable([16,32,512], n3(:,1864), t3x512(:,:,1275))
  call heltable([16,32,512], n3(:,1865), t3x512(:,:,1276))
  call heltable([16,32,512], n3(:,1866), t3x512(:,:,1277))
  call heltable([16,32,512], n3(:,1867), t3x512(:,:,1278))
  call heltable([16,32,512], n3(:,1868), t3x512(:,:,1279))
  call heltable([16,32,512], n3(:,1869), t3x512(:,:,1280))
  call heltable([16,32,512], n3(:,1870), t3x512(:,:,1281))
  call heltable([16,32,512], n3(:,1871), t3x512(:,:,1282))
  call heltable([16,32,512], n3(:,1872), t3x512(:,:,1283))
  call heltable([16,32,512], n3(:,1873), t3x512(:,:,1284))
  call heltable([16,32,512], n3(:,1874), t3x512(:,:,1285))
  call heltable([16,32,512], n3(:,1875), t3x512(:,:,1286))
  call heltable([16,32,512], n3(:,1876), t3x512(:,:,1287))
  call heltable([16,32,512], n3(:,1877), t3x512(:,:,1288))
  call heltable([16,32,512], n3(:,1878), t3x512(:,:,1289))
  call heltable([16,32,512], n3(:,1879), t3x512(:,:,1290))
  call heltable([16,32,512], n3(:,1880), t3x512(:,:,1291))
  call heltable([16,32,512], n3(:,1881), t3x512(:,:,1292))
  call heltable([16,32,512], n3(:,1882), t3x512(:,:,1293))
  call heltable([16,32,512], n3(:,1883), t3x512(:,:,1294))
  call heltable([16,32,512], n3(:,1884), t3x512(:,:,1295))
  call heltable([16,32,512], n3(:,1885), t3x512(:,:,1296))
  call heltable([16,32,512], n3(:,1886), t3x512(:,:,1297))
  call heltable([16,32,512], n3(:,1887), t3x512(:,:,1298))
  call heltable([16,32,512], n3(:,1888), t3x512(:,:,1299))
  call heltable([16,32,512], n3(:,1889), t3x512(:,:,1300))
  call heltable([16,32,512], n3(:,1890), t3x512(:,:,1301))
  call heltable([16,32,512], n3(:,1891), t3x512(:,:,1302))
  call heltable([16,32,512], n3(:,1892), t3x512(:,:,1303))
  call heltable([16,32,512], n3(:,1893), t3x512(:,:,1304))
  call heltable([16,32,512], n3(:,1894), t3x512(:,:,1305))
  call heltable([16,32,512], n3(:,1895), t3x512(:,:,1306))
  call heltable([16,32,512], n3(:,1896), t3x512(:,:,1307))
  call heltable([16,32,512], n3(:,1897), t3x512(:,:,1308))
  call heltable([16,32,512], n3(:,1898), t3x512(:,:,1309))
  call heltable([16,32,512], n3(:,1899), t3x512(:,:,1310))
  call heltable([16,32,512], n3(:,1900), t3x512(:,:,1311))
  call heltable([16,32,512], n3(:,1901), t3x512(:,:,1312))
  call heltable([16,32,512], n3(:,1902), t3x512(:,:,1313))
  call heltable([16,32,512], n3(:,1903), t3x512(:,:,1314))
  call heltable([16,32,512], n3(:,1904), t3x512(:,:,1315))
  call heltable([16,32,512], n3(:,1905), t3x512(:,:,1316))
  call heltable([16,32,512], n3(:,1906), t3x512(:,:,1317))
  call heltable([16,32,512], n3(:,1907), t3x512(:,:,1318))
  call heltable([16,32,512], n3(:,1908), t3x512(:,:,1319))
  call heltable([16,32,512], n3(:,1909), t3x512(:,:,1320))
  call heltable([32,16,512], n3(:,1910), t3x512(:,:,1321))
  call heltable([32,16,512], n3(:,1911), t3x512(:,:,1322))
  call heltable([32,16,512], n3(:,1912), t3x512(:,:,1323))
  call heltable([32,16,512], n3(:,1913), t3x512(:,:,1324))
  call heltable([32,16,512], n3(:,1914), t3x512(:,:,1325))
  call heltable([32,16,512], n3(:,1915), t3x512(:,:,1326))
  call heltable([32,16,512], n3(:,1916), t3x512(:,:,1327))
  call heltable([32,16,512], n3(:,1917), t3x512(:,:,1328))
  call heltable([32,16,512], n3(:,1918), t3x512(:,:,1329))
  call heltable([32,16,512], n3(:,1919), t3x512(:,:,1330))
  call heltable([32,16,512], n3(:,1920), t3x512(:,:,1331))
  call heltable([32,16,512], n3(:,1921), t3x512(:,:,1332))
  call heltable([32,16,512], n3(:,1922), t3x512(:,:,1333))
  call heltable([32,16,512], n3(:,1923), t3x512(:,:,1334))
  call heltable([32,16,512], n3(:,1924), t3x512(:,:,1335))
  call heltable([32,16,512], n3(:,1925), t3x512(:,:,1336))
  call heltable([32,16,512], n3(:,1926), t3x512(:,:,1337))
  call heltable([32,16,512], n3(:,1927), t3x512(:,:,1338))
  call heltable([16,32,512], n3(:,1928), t3x512(:,:,1339))
  call heltable([32,16,512], n3(:,1929), t3x512(:,:,1340))
  call heltable([32,16,512], n3(:,1930), t3x512(:,:,1341))
  call heltable([32,16,512], n3(:,1931), t3x512(:,:,1342))
  call heltable([32,16,512], n3(:,1932), t3x512(:,:,1343))
  call heltable([32,16,512], n3(:,1933), t3x512(:,:,1344))
  call heltable([32,16,512], n3(:,1934), t3x512(:,:,1345))
  call heltable([32,16,512], n3(:,1935), t3x512(:,:,1346))
  call heltable([32,16,512], n3(:,1936), t3x512(:,:,1347))
  call heltable([16,32,512], n3(:,1937), t3x512(:,:,1348))
  call heltable([8,64,512], n3(:,1938), t3x512(:,:,1349))
  call heltable([16,32,512], n3(:,1939), t3x512(:,:,1350))
  call heltable([8,64,512], n3(:,1940), t3x512(:,:,1351))
  call heltable([16,32,512], n3(:,1941), t3x512(:,:,1352))
  call heltable([16,32,512], n3(:,1942), t3x512(:,:,1353))
  call heltable([16,32,512], n3(:,1943), t3x512(:,:,1354))
  call heltable([32,16,512], n3(:,1944), t3x512(:,:,1355))
  call heltable([32,16,512], n3(:,1945), t3x512(:,:,1356))
  call heltable([32,16,512], n3(:,1946), t3x512(:,:,1357))
  call heltable([32,16,512], n3(:,1947), t3x512(:,:,1358))
  call heltable([32,16,512], n3(:,1948), t3x512(:,:,1359))
  call heltable([32,16,512], n3(:,1949), t3x512(:,:,1360))
  call heltable([32,16,512], n3(:,1950), t3x512(:,:,1361))
  call heltable([32,16,512], n3(:,1951), t3x512(:,:,1362))
  call heltable([32,16,512], n3(:,1952), t3x512(:,:,1363))
  call heltable([32,16,512], n3(:,1953), t3x512(:,:,1364))
  call heltable([32,16,512], n3(:,1954), t3x512(:,:,1365))
  call heltable([32,16,512], n3(:,1955), t3x512(:,:,1366))
  call heltable([32,16,512], n3(:,1956), t3x512(:,:,1367))
  call heltable([32,16,512], n3(:,1957), t3x512(:,:,1368))
  call heltable([32,16,512], n3(:,1958), t3x512(:,:,1369))
  call heltable([32,16,512], n3(:,1959), t3x512(:,:,1370))
  call heltable([32,16,512], n3(:,1960), t3x512(:,:,1371))
  call heltable([32,16,512], n3(:,1961), t3x512(:,:,1372))
  call heltable([16,32,512], n3(:,1962), t3x512(:,:,1373))
  call heltable([32,16,512], n3(:,1963), t3x512(:,:,1374))
  call heltable([32,16,512], n3(:,1964), t3x512(:,:,1375))
  call heltable([32,16,512], n3(:,1965), t3x512(:,:,1376))
  call heltable([32,16,512], n3(:,1966), t3x512(:,:,1377))
  call heltable([32,16,512], n3(:,1967), t3x512(:,:,1378))
  call heltable([32,16,512], n3(:,1968), t3x512(:,:,1379))
  call heltable([32,16,512], n3(:,1969), t3x512(:,:,1380))
  call heltable([32,16,512], n3(:,1970), t3x512(:,:,1381))
  call heltable([16,32,512], n3(:,1971), t3x512(:,:,1382))
  call heltable([8,64,512], n3(:,1972), t3x512(:,:,1383))
  call heltable([16,32,512], n3(:,1973), t3x512(:,:,1384))
  call heltable([8,64,512], n3(:,1974), t3x512(:,:,1385))
  call heltable([16,32,512], n3(:,1975), t3x512(:,:,1386))
  call heltable([16,32,512], n3(:,1976), t3x512(:,:,1387))
  call heltable([16,32,512], n3(:,1977), t3x512(:,:,1388))
  call heltable([16,32,512], n3(:,1978), t3x512(:,:,1389))
  call heltable([16,32,512], n3(:,1979), t3x512(:,:,1390))
  call heltable([16,32,512], n3(:,1980), t3x512(:,:,1391))
  call heltable([16,32,512], n3(:,1981), t3x512(:,:,1392))
  call heltable([16,32,512], n3(:,1982), t3x512(:,:,1393))
  call heltable([16,32,512], n3(:,1983), t3x512(:,:,1394))
  call heltable([16,32,512], n3(:,1984), t3x512(:,:,1395))
  call heltable([16,32,512], n3(:,1985), t3x512(:,:,1396))
  call heltable([16,32,512], n3(:,1986), t3x512(:,:,1397))
  call heltable([16,32,512], n3(:,1987), t3x512(:,:,1398))
  call heltable([16,32,512], n3(:,1988), t3x512(:,:,1399))
  call heltable([16,32,512], n3(:,1989), t3x512(:,:,1400))
  call heltable([16,32,512], n3(:,1990), t3x512(:,:,1401))
  call heltable([16,32,512], n3(:,1991), t3x512(:,:,1402))
  call heltable([16,32,512], n3(:,1992), t3x512(:,:,1403))
  call heltable([16,32,512], n3(:,1993), t3x512(:,:,1404))
  call heltable([16,32,512], n3(:,1994), t3x512(:,:,1405))
  call heltable([16,32,512], n3(:,1995), t3x512(:,:,1406))
  call heltable([16,32,512], n3(:,1996), t3x512(:,:,1407))
  call heltable([16,32,512], n3(:,1997), t3x512(:,:,1408))
  call heltable([16,32,512], n3(:,1998), t3x512(:,:,1409))
  call heltable([16,32,512], n3(:,1999), t3x512(:,:,1410))
  call heltable([16,32,512], n3(:,2000), t3x512(:,:,1411))
  call heltable([16,32,512], n3(:,2001), t3x512(:,:,1412))
  call heltable([16,32,512], n3(:,2002), t3x512(:,:,1413))
  call heltable([16,32,512], n3(:,2003), t3x512(:,:,1414))
  call heltable([16,32,512], n3(:,2004), t3x512(:,:,1415))
  call heltable([16,32,512], n3(:,2005), t3x512(:,:,1416))
  call heltable([16,32,512], n3(:,2006), t3x512(:,:,1417))
  call heltable([16,32,512], n3(:,2007), t3x512(:,:,1418))
  call heltable([16,32,512], n3(:,2008), t3x512(:,:,1419))
  call heltable([16,32,512], n3(:,2009), t3x512(:,:,1420))
  call heltable([16,32,512], n3(:,2010), t3x512(:,:,1421))
  call heltable([16,32,512], n3(:,2011), t3x512(:,:,1422))
  call heltable([16,32,512], n3(:,2012), t3x512(:,:,1423))
  call heltable([16,32,512], n3(:,2013), t3x512(:,:,1424))
  call heltable([16,32,512], n3(:,2014), t3x512(:,:,1425))
  call heltable([16,32,512], n3(:,2015), t3x512(:,:,1426))
  call heltable([16,32,512], n3(:,2016), t3x512(:,:,1427))
  call heltable([16,32,512], n3(:,2017), t3x512(:,:,1428))
  call heltable([16,32,512], n3(:,2018), t3x512(:,:,1429))
  call heltable([16,32,512], n3(:,2019), t3x512(:,:,1430))
  call heltable([16,32,512], n3(:,2020), t3x512(:,:,1431))
  call heltable([16,32,512], n3(:,2021), t3x512(:,:,1432))
  call heltable([16,32,512], n3(:,2022), t3x512(:,:,1433))
  call heltable([16,32,512], n3(:,2023), t3x512(:,:,1434))
  call heltable([16,32,512], n3(:,2024), t3x512(:,:,1435))
  call heltable([16,32,512], n3(:,2025), t3x512(:,:,1436))
  call heltable([16,32,512], n3(:,2026), t3x512(:,:,1437))
  call heltable([16,32,512], n3(:,2027), t3x512(:,:,1438))
  call heltable([16,32,512], n3(:,2028), t3x512(:,:,1439))
  call heltable([16,32,512], n3(:,2029), t3x512(:,:,1440))
  call heltable([16,32,512], n3(:,2030), t3x512(:,:,1441))
  call heltable([16,32,512], n3(:,2031), t3x512(:,:,1442))
  call heltable([16,32,512], n3(:,2032), t3x512(:,:,1443))
  call heltable([16,32,512], n3(:,2033), t3x512(:,:,1444))
  call heltable([16,32,512], n3(:,2034), t3x512(:,:,1445))
  call heltable([16,32,512], n3(:,2035), t3x512(:,:,1446))
  call heltable([16,32,512], n3(:,2036), t3x512(:,:,1447))
  call heltable([16,32,512], n3(:,2037), t3x512(:,:,1448))
  call heltable([16,32,512], n3(:,2038), t3x512(:,:,1449))
  call heltable([16,32,512], n3(:,2039), t3x512(:,:,1450))
  call heltable([16,32,512], n3(:,2040), t3x512(:,:,1451))
  call heltable([16,32,512], n3(:,2041), t3x512(:,:,1452))
  call heltable([16,32,512], n3(:,2042), t3x512(:,:,1453))
  call heltable([16,32,512], n3(:,2043), t3x512(:,:,1454))
  call heltable([16,32,512], n3(:,2044), t3x512(:,:,1455))
  call heltable([16,32,512], n3(:,2045), t3x512(:,:,1456))
  call heltable([16,32,512], n3(:,2046), t3x512(:,:,1457))
  call heltable([16,32,512], n3(:,2047), t3x512(:,:,1458))
  call heltable([16,32,512], n3(:,2048), t3x512(:,:,1459))
  call heltable([16,32,512], n3(:,2049), t3x512(:,:,1460))
  call heltable([16,32,512], n3(:,2050), t3x512(:,:,1461))
  call heltable([16,32,512], n3(:,2051), t3x512(:,:,1462))
  call heltable([16,32,512], n3(:,2052), t3x512(:,:,1463))
  call heltable([16,32,512], n3(:,2053), t3x512(:,:,1464))
  call heltable([16,32,512], n3(:,2054), t3x512(:,:,1465))
  call heltable([16,32,512], n3(:,2055), t3x512(:,:,1466))
  call heltable([16,32,512], n3(:,2056), t3x512(:,:,1467))
  call heltable([16,32,512], n3(:,2057), t3x512(:,:,1468))
  call heltable([16,32,512], n3(:,2058), t3x512(:,:,1469))
  call heltable([16,32,512], n3(:,2059), t3x512(:,:,1470))
  call heltable([16,32,512], n3(:,2060), t3x512(:,:,1471))
  call heltable([16,32,512], n3(:,2061), t3x512(:,:,1472))
  call heltable([16,32,512], n3(:,2062), t3x512(:,:,1473))
  call heltable([16,32,512], n3(:,2063), t3x512(:,:,1474))
  call heltable([16,32,512], n3(:,2064), t3x512(:,:,1475))
  call heltable([16,32,512], n3(:,2065), t3x512(:,:,1476))
  call heltable([16,32,512], n3(:,2066), t3x512(:,:,1477))
  call heltable([16,32,512], n3(:,2067), t3x512(:,:,1478))
  call heltable([16,32,512], n3(:,2068), t3x512(:,:,1479))
  call heltable([32,16,512], n3(:,2069), t3x512(:,:,1480))
  call heltable([32,16,512], n3(:,2070), t3x512(:,:,1481))
  call heltable([32,16,512], n3(:,2071), t3x512(:,:,1482))
  call heltable([16,32,512], n3(:,2072), t3x512(:,:,1483))
  call heltable([16,32,512], n3(:,2073), t3x512(:,:,1484))
  call heltable([16,32,512], n3(:,2074), t3x512(:,:,1485))
  call heltable([16,32,512], n3(:,2075), t3x512(:,:,1486))
  call heltable([16,32,512], n3(:,2076), t3x512(:,:,1487))
  call heltable([16,32,512], n3(:,2077), t3x512(:,:,1488))
  call heltable([16,32,512], n3(:,2078), t3x512(:,:,1489))
  call heltable([16,32,512], n3(:,2079), t3x512(:,:,1490))
  call heltable([16,32,512], n3(:,2080), t3x512(:,:,1491))
  call heltable([16,32,512], n3(:,2081), t3x512(:,:,1492))
  call heltable([16,32,512], n3(:,2082), t3x512(:,:,1493))
  call heltable([16,32,512], n3(:,2083), t3x512(:,:,1494))
  call heltable([16,32,512], n3(:,2084), t3x512(:,:,1495))
  call heltable([16,32,512], n3(:,2085), t3x512(:,:,1496))
  call heltable([16,32,512], n3(:,2086), t3x512(:,:,1497))
  call heltable([16,32,512], n3(:,2087), t3x512(:,:,1498))
  call heltable([16,32,512], n3(:,2088), t3x512(:,:,1499))
  call heltable([16,32,512], n3(:,2089), t3x512(:,:,1500))
  call heltable([16,32,512], n3(:,2090), t3x512(:,:,1501))
  call heltable([16,32,512], n3(:,2091), t3x512(:,:,1502))
  call heltable([16,32,512], n3(:,2092), t3x512(:,:,1503))
  call heltable([16,32,512], n3(:,2093), t3x512(:,:,1504))
  call heltable([16,32,512], n3(:,2094), t3x512(:,:,1505))
  call heltable([16,32,512], n3(:,2095), t3x512(:,:,1506))
  call heltable([16,32,512], n3(:,2096), t3x512(:,:,1507))
  call heltable([16,32,512], n3(:,2097), t3x512(:,:,1508))
  call heltable([16,32,512], n3(:,2098), t3x512(:,:,1509))
  call heltable([16,32,512], n3(:,2099), t3x512(:,:,1510))
  call heltable([16,32,512], n3(:,2100), t3x512(:,:,1511))
  call heltable([16,32,512], n3(:,2101), t3x512(:,:,1512))
  call heltable([16,32,512], n3(:,2102), t3x512(:,:,1513))
  call heltable([32,16,512], n3(:,2103), t3x512(:,:,1514))
  call heltable([32,16,512], n3(:,2104), t3x512(:,:,1515))
  call heltable([32,16,512], n3(:,2105), t3x512(:,:,1516))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_eellllbb_nenexeexmmxbbxg_1
