
module ol_vamp_1_eellll_ew_nenexeeexex_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eellll_ew_nenexeeexex_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eellll_ew_nenexeeexex_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eellll_ew_nenexeeexex_1_/**/DREALKIND
  use ol_tensor_sum_storage_eellll_ew_nenexeeexex_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eellll_ew_nenexeeexex_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eellll_ew_nenexeeexex_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,1,2,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,8,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,1,2,16,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,1,2,16,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,1,2,16,8],[0,nMW,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,2,1,4,16,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,2,1,4,16,8],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(2),ngZl,m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,2,1,4,16,8],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,8,1,2,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,8,1,2,4,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZl,m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,2,1,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,8,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZl,m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,16,2,1,8],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,2,1,8],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZl,m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,4,16,2,1,8],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,8,16,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZl,m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,2,1,8,16,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZl,m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,2,1,8,16,4],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,8,4,2,1,16],[0,0,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,8,4,2,1,16],[0,0,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),ngZl,m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,8,4,2,1,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,8,4,2,1,16],[0,nMZ,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),ngZl,m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,4,2,1,16,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,4,2,1,16,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),ngZl,m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,4,2,1,16,8],[0,0,nMW,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,4,2,1,16,8],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,4,2,1,16,8],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(12),ngZl,m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,2,1,16,8],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZl,m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,2,1,16,8],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,8,2,1,16],[0,0,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,4,8,2,1,16],[0,0,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),ngZl,m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,4,8,2,1,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,4,8,2,1,16],[0,nMZ,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),ngZl,m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,4,16,1,2,8],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,4,16,1,2,8],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZl,m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,4,16,1,2,8],[0,0,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,16,1,2,8],[0,0,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,16,1,2,8],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(24),n2h32(24))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,16,1,2,8],[0,nMZ,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(25),n2h32(25))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,16,1,2,8],[0,nMW,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(26),n2h32(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,2,1,16,4,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,2,1,16,4,8],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZl,m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,2,1,16,8,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(19),ngZl,m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,2,1,16,8,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(20),ngZl,m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,1,2,4,8,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(27),n2h32(27))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,1,2,4,8,16],[0,nMW,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),ngZl,m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(28),n2h32(28))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,1,2,4,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(29),n2h32(29))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,1,2,4,8,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(21),ngZl,m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(21),32,0,G1H32(30),n2h32(30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,1,2,4,16,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZl,m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,1,2,4,16,8],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(22),ngZl,m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,1,2,4,16,8],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(31),n2h32(31))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,1,2,4,16,8],[0,nMW,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),ngZl,m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(32),n2h32(32))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,1,2,4,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(33),n2h32(33))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,1,2,4,16,8],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),ngZl,m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(34),n2h32(34))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,1,2,4,16,8],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(35),n2h32(35))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,1,2,8,4,16],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(36),n2h32(36))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,2,8,4,16],[0,nMW,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),ngZl,m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(37),n2h32(37))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,2,8,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(38),n2h32(38))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,1,2,8,4,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(23),ngZl,m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(23),32,0,G1H32(39),n2h32(39))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,1,2,8,16,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZl,m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,1,2,8,16,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZl,m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,1,2,8,16,4],[0,nMW,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(40),n2h32(40))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,1,2,8,16,4],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(41),n2h32(41))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,1,2,8,16,4],[0,nMW,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZl,m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(42),n2h32(42))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,1,2,8,16,4],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZl,m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(43),n2h32(43))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,1,2,8,16,4],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(44),n2h32(44))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,1,2,16,4,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(25),ngZl,m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,1,2,16,4,8],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(26),ngZl,m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,1,2,16,8,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZl,m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,1,2,16,8,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZl,m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,8,2,4,1,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(29),32,0,G1H32(45),n2h32(45))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,8,2,4,1,16],[0,nMZ,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(29),ngZl,m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(29),32,0,G1H32(46),n2h32(46))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,2,4,1,16,8],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(29),ngZl,m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,2,4,1,16,8],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(30),ngZl,m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,2,4,1,16,8],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,4,1,16,2,8],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(32),32,0,G1H32(47),n2h32(47))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,4,1,16,2,8],[0,nMZ,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(32),ngZl,m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(32),32,0,G1H32(48),n2h32(48))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,4,1,16,2,8],[0,nMW,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(32),32,0,G1H32(49),n2h32(49))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,2,8,16,1,4],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(32),ngZl,m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,2,8,16,1,4],[nMW,0,0,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,82),heltab2x64(:,:,82))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,2,8,16,1,4],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,4,2,8,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(50),n2h32(50))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,1,4,2,8,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(51),n2h32(51))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,1,4,2,16,8],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(52),n2h32(52))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,1,4,2,16,8],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(53),n2h32(53))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,1,4,2,16,8],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,88),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(54),n2h32(54))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,1,4,16,2,8],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,89),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(55),n2h32(55))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,1,4,16,2,8],[0,nMW,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,90),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(56),n2h32(56))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,1,4,16,2,8],[0,nMW,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(57),n2h32(57))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,1,4,16,8,2],[0,nMZ,0,0,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(58),n2h32(58))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,1,4,16,8,2],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(59),n2h32(59))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,1,4,16,8,2],[0,nMW,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(60),n2h32(60))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,4,2,8,1,16],[0,nMZ,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(61),n2h32(61))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,4,2,8,1,16],[0,nMZ,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(62),n2h32(62))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,4,2,16,1,8],[0,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,97),heltab2x64(:,:,97))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,4,2,16,1,8],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(36),ngZl,m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,4,2,16,1,8],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,2,4,16,1,8],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZl,m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,2,4,16,1,8],[nMW,0,0,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,101),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,2,4,16,1,8],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,2,8,1,16,4],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(41),ngZl,m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,2,8,1,16,4],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(42),ngZl,m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,2,8,1,16,4],[nMW,0,nMZ,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,1,8,2,4,16],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(63),n2h32(63))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,1,8,2,4,16],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),ngZl,m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(64),n2h32(64))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,1,8,16,2,4],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(65),n2h32(65))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,1,8,16,2,4],[0,nMW,0,nMW,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(66),n2h32(66))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,1,8,16,2,4],[0,nMW,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),ngZl,m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(67),n2h32(67))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,1,8,16,4,2],[0,nMZ,0,0,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(68),n2h32(68))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,1,8,16,4,2],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(69),n2h32(69))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,1,8,16,4,2],[0,nMW,0,nMW,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),ngZl,m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(70),n2h32(70))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,1,8,2,16,4],[0,nMW,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(71),n2h32(71))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,1,8,2,16,4],[0,nMW,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),ngZl,m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(72),n2h32(72))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,1,8,2,16,4],[0,nMZ,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H32(44),32,0,G1H32(73),n2h32(73))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,1,16,4,2,8],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(44),ngZl,m3h2x32(:,117),heltab2x64(:,:,117))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,1,16,4,2,8],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,118),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G0H32(45),32,0,G1H32(74),n2h32(74))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,1,16,8,2,4],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(45),ngZl,m3h2x32(:,119),heltab2x64(:,:,119))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,1,16,8,2,4],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H32(46),32,0,G1H32(75),n2h32(75))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,1,16,2,4,8],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(46),ngZl,m3h2x32(:,121),heltab2x64(:,:,121))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,1,16,2,4,8],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(47),ngZl,m3h2x32(:,122),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,1,16,8,4,2],[0,nMZ,0,0,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,123),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G0H32(48),32,0,G1H32(76),n2h32(76))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,1,16,8,4,2],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,124),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(48),32,0,G1H32(77),n2h32(77))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,1,16,2,8,4],[nMZ,0,nMW,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(48),ngZl,m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,1,16,2,8,4],[nMZ,0,nMW,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(49),ngZl,m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,1,16,4,8,2],[0,nMZ,0,0,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,127),heltab2x64(:,:,127))
  call Hloop_A_Q(ntryL,G0H32(50),32,0,G1H32(78),n2h32(78))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,1,16,4,8,2],[0,nMZ,0,nMZ,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,128),heltab2x64(:,:,128))
  call Hloop_A_Q(ntryL,G0H32(50),32,0,G1H32(79),n2h32(79))
  call Hloop_AQ_Z(ntryL,G1H32(1),ex4(:),G1H16(1),ngZl,m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H32(2),ex4(:),G1H16(2),ngZl,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H32(3),ex3(:),G1H16(3),ngZl,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H32(4),ex3(:),G1H16(4),ngZl,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_Z(ntryL,G1H32(5),ex3(:),G1H16(5),ngZl,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H32(6),ex3(:),G1H16(6),ngZl,m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AQ_W(ntryL,G1H32(7),ex3(:),G1H16(7),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_ZA_Q(ntryL,G0H32(1),ex2(:),G0H16(1),ngZn,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(8),n2h16(1))
  call Hloop_ZA_Q(ntryL,G0H32(2),ex2(:),G0H16(1),ngZn,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(9),n2h16(2))
  call Hloop_WA_Q(ntryL,G0H32(3),ex2(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(10),n2h16(3))
  call Hloop_AQ_Z(ntryL,G1H32(8),ex4(:),G1H16(11),ngZl,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H32(9),ex4(:),G1H16(12),ngZl,m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H32(10),ex3(:),G1H16(13),ngZl,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H32(11),ex3(:),G1H16(14),ngZl,m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_VQ_A(ntryL,G0H32(4),ex3(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(15),n2h16(4))
  call Hloop_ZQ_A(ntryL,G0H32(5),ex3(:),G0H16(1),ngZl,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(16),n2h16(5))
  call Hloop_WQ_A(ntryL,G0H32(6),ex3(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(17),n2h16(6))
  call Hloop_ZA_Q(ntryL,G0H32(7),ex2(:),G0H16(1),ngZn,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(18),n2h16(7))
  call Hloop_ZA_Q(ntryL,G0H32(8),ex2(:),G0H16(1),ngZn,m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(19),n2h16(8))
  call Hloop_WA_Q(ntryL,G0H32(9),ex2(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(20),n2h16(9))
  call Hloop_AQ_V(ntryL,G1H32(12),ex4(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(13),ex4(:),G1H16(22),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_Z(ntryL,G1H32(14),ex4(:),G1H16(23),ngZl,m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H32(15),ex4(:),G1H16(24),ngZl,m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H32(16),ex3(:),G1H16(25),ngZl,m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H32(17),ex3(:),G1H16(26),ngZl,m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_VQ_A(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(27),n2h16(10))
  call Hloop_VQ_A(ntryL,G0H32(11),ex3(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(28),n2h16(11))
  call Hloop_ZQ_A(ntryL,G0H32(12),ex3(:),G0H16(1),ngZl,m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(29),n2h16(12))
  call Hloop_ZQ_A(ntryL,G0H32(13),ex3(:),G0H16(1),ngZl,m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(30),n2h16(13))
  call Hloop_WQ_A(ntryL,G0H32(14),ex3(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(31),n2h16(14))
  call Hloop_AQ_V(ntryL,G1H32(18),ex3(:),G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_AQ_V(ntryL,G1H32(19),ex3(:),G1H16(33),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_AQ_Z(ntryL,G1H32(20),ex3(:),G1H16(34),ngZl,m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H32(21),ex3(:),G1H16(35),ngZl,m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_VQ_A(ntryL,G0H32(15),ex3(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(36),n2h16(15))
  call Hloop_ZQ_A(ntryL,G0H32(16),ex3(:),G0H16(1),ngZl,m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(37),n2h16(16))
  call Hloop_AQ_V(ntryL,G1H32(22),ex3(:),G1H16(38),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_AQ_V(ntryL,G1H32(23),ex3(:),G1H16(39),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_AQ_Z(ntryL,G1H32(24),ex3(:),G1H16(40),ngZl,m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_AQ_Z(ntryL,G1H32(25),ex3(:),G1H16(41),ngZl,m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_AQ_W(ntryL,G1H32(26),ex3(:),G1H16(42),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_ZA_Q(ntryL,G0H32(17),ex2(:),G0H16(1),ngZn,m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(43),n2h16(17))
  call Hloop_ZA_Q(ntryL,G0H32(18),ex2(:),G0H16(1),ngZn,m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(44),n2h16(18))
  call Hloop_ZA_Q(ntryL,G0H32(19),ex2(:),G0H16(1),ngZn,m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(45),n2h16(19))
  call Hloop_ZA_Q(ntryL,G0H32(20),ex2(:),G0H16(1),ngZn,m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(46),n2h16(20))
  call Hloop_AQ_W(ntryL,G1H32(27),ex1(:),G1H16(47),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_AQ_W(ntryL,G1H32(28),ex1(:),G1H16(48),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_AQ_W(ntryL,G1H32(29),ex1(:),G1H16(49),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_AQ_W(ntryL,G1H32(30),ex1(:),G1H16(50),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_ZQ_A(ntryL,G0H32(21),ex1(:),G0H16(1),ngZn,m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(51),n2h16(21))
  call Hloop_ZQ_A(ntryL,G0H32(22),ex1(:),G0H16(1),ngZn,m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(52),n2h16(22))
  call Hloop_AQ_W(ntryL,G1H32(31),ex1(:),G1H16(53),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_AQ_W(ntryL,G1H32(32),ex1(:),G1H16(54),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_AQ_W(ntryL,G1H32(33),ex1(:),G1H16(55),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_AQ_W(ntryL,G1H32(34),ex1(:),G1H16(56),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_AQ_Z(ntryL,G1H32(35),ex1(:),G1H16(57),ngZn,m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_AQ_W(ntryL,G1H32(36),ex1(:),G1H16(58),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_AQ_W(ntryL,G1H32(37),ex1(:),G1H16(59),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_AQ_W(ntryL,G1H32(38),ex1(:),G1H16(60),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_AQ_W(ntryL,G1H32(39),ex1(:),G1H16(61),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_ZQ_A(ntryL,G0H32(23),ex1(:),G0H16(1),ngZn,m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(62),n2h16(23))
  call Hloop_ZQ_A(ntryL,G0H32(24),ex1(:),G0H16(1),ngZn,m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(63),n2h16(24))
  call Hloop_AQ_W(ntryL,G1H32(40),ex1(:),G1H16(64),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_AQ_W(ntryL,G1H32(41),ex1(:),G1H16(65),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_AQ_W(ntryL,G1H32(42),ex1(:),G1H16(66),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_AQ_W(ntryL,G1H32(43),ex1(:),G1H16(67),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_AQ_Z(ntryL,G1H32(44),ex1(:),G1H16(68),ngZn,m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_ZQ_A(ntryL,G0H32(25),ex1(:),G0H16(1),ngZn,m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(69),n2h16(25))
  call Hloop_ZQ_A(ntryL,G0H32(26),ex1(:),G0H16(1),ngZn,m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(70),n2h16(26))
  call Hloop_ZQ_A(ntryL,G0H32(27),ex1(:),G0H16(1),ngZn,m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(71),n2h16(27))
  call Hloop_ZQ_A(ntryL,G0H32(28),ex1(:),G0H16(1),ngZn,m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(72),n2h16(28))
  call Hloop_AQ_Z(ntryL,G1H32(45),ex4(:),G1H16(73),ngZl,m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H32(46),ex4(:),G1H16(74),ngZl,m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_ZA_Q(ntryL,G0H32(29),ex2(:),G0H16(1),ngZn,m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(75),n2h16(29))
  call Hloop_ZA_Q(ntryL,G0H32(30),ex2(:),G0H16(1),ngZn,m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(76),n2h16(30))
  call Hloop_WA_Q(ntryL,G0H32(31),ex2(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(77),n2h16(31))
  call Hloop_AQ_Z(ntryL,G1H32(47),ex3(:),G1H16(78),ngZl,m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_AQ_Z(ntryL,G1H32(48),ex3(:),G1H16(79),ngZl,m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_AQ_W(ntryL,G1H32(49),ex3(:),G1H16(80),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_ZA_Q(ntryL,G0H32(32),ex2(:),G0H16(1),ngZn,m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(81),n2h16(32))
  call Hloop_WA_Q(ntryL,G0H32(33),ex2(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(82),n2h16(33))
  call Hloop_WA_Q(ntryL,G0H32(34),ex2(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(83),n2h16(34))
  call Hloop_AQ_W(ntryL,G1H32(50),ex1(:),G1H16(84),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_AQ_W(ntryL,G1H32(51),ex1(:),G1H16(85),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_AQ_W(ntryL,G1H32(52),ex1(:),G1H16(86),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_AQ_W(ntryL,G1H32(53),ex1(:),G1H16(87),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_AQ_Z(ntryL,G1H32(54),ex1(:),G1H16(88),ngZn,m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_AQ_Z(ntryL,G1H32(55),ex1(:),G1H16(89),ngZn,m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_AQ_W(ntryL,G1H32(56),ex1(:),G1H16(90),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_AQ_W(ntryL,G1H32(57),ex1(:),G1H16(91),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_AQ_Z(ntryL,G1H32(58),ex1(:),G1H16(92),ngZn,m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_AQ_Z(ntryL,G1H32(59),ex1(:),G1H16(93),ngZn,m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_AQ_W(ntryL,G1H32(60),ex1(:),G1H16(94),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_AQ_Z(ntryL,G1H32(61),ex3(:),G1H16(95),ngZl,m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_AQ_Z(ntryL,G1H32(62),ex3(:),G1H16(96),ngZl,m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_VQ_A(ntryL,G0H32(35),ex3(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(97),n2h16(35))
  call Hloop_ZQ_A(ntryL,G0H32(36),ex3(:),G0H16(1),ngZl,m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(98),n2h16(36))
  call Hloop_WQ_A(ntryL,G0H32(37),ex3(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(99),n2h16(37))
  call Hloop_ZA_Q(ntryL,G0H32(38),ex2(:),G0H16(1),ngZn,m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(100),n2h16(38))
  call Hloop_WA_Q(ntryL,G0H32(39),ex2(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(101),n2h16(39))
  call Hloop_WA_Q(ntryL,G0H32(40),ex2(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(102),n2h16(40))
  call Hloop_ZA_Q(ntryL,G0H32(41),ex2(:),G0H16(1),ngZn,m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(103),n2h16(41))
  call Hloop_ZA_Q(ntryL,G0H32(42),ex2(:),G0H16(1),ngZn,m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(104),n2h16(42))
  call Hloop_WA_Q(ntryL,G0H32(43),ex2(:),G0H16(1),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(105),n2h16(43))
  call Hloop_AQ_W(ntryL,G1H32(63),ex1(:),G1H16(106),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_AQ_W(ntryL,G1H32(64),ex1(:),G1H16(107),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_AQ_Z(ntryL,G1H32(65),ex1(:),G1H16(108),ngZn,m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_AQ_W(ntryL,G1H32(66),ex1(:),G1H16(109),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_AQ_W(ntryL,G1H32(67),ex1(:),G1H16(110),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_AQ_Z(ntryL,G1H32(68),ex1(:),G1H16(111),ngZn,m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_AQ_Z(ntryL,G1H32(69),ex1(:),G1H16(112),ngZn,m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_AQ_W(ntryL,G1H32(70),ex1(:),G1H16(113),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_AQ_W(ntryL,G1H32(71),ex1(:),G1H16(114),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_AQ_W(ntryL,G1H32(72),ex1(:),G1H16(115),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_AQ_Z(ntryL,G1H32(73),ex1(:),G1H16(116),ngZn,m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_ZQ_A(ntryL,G0H32(44),ex1(:),G0H16(1),ngZn,m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(117),n2h16(44))
  call Hloop_AQ_Z(ntryL,G1H32(74),ex1(:),G1H16(118),ngZn,m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_ZQ_A(ntryL,G0H32(45),ex1(:),G0H16(1),ngZn,m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(119),n2h16(45))
  call Hloop_AQ_Z(ntryL,G1H32(75),ex1(:),G1H16(120),ngZn,m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_ZQ_A(ntryL,G0H32(46),ex1(:),G0H16(1),ngZn,m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(121),n2h16(46))
  call Hloop_ZQ_A(ntryL,G0H32(47),ex1(:),G0H16(1),ngZn,m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(122),n2h16(47))
  call Hloop_AQ_Z(ntryL,G1H32(76),ex1(:),G1H16(123),ngZn,m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_AQ_Z(ntryL,G1H32(77),ex1(:),G1H16(124),ngZn,m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_ZQ_A(ntryL,G0H32(48),ex1(:),G0H16(1),ngZn,m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(125),n2h16(48))
  call Hloop_ZQ_A(ntryL,G0H32(49),ex1(:),G0H16(1),ngZn,m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(126),n2h16(49))
  call Hloop_AQ_Z(ntryL,G1H32(78),ex1(:),G1H16(127),ngZn,m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_AQ_Z(ntryL,G1H32(79),ex1(:),G1H16(128),ngZn,m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_ZA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),ngZn,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_ZA_Q(ntryL,G1H16(2),ex2(:),G1H8(1),ngZn,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(2),n2h8(2))
  call Hloop_ZQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),ngZn,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(3),n2h8(3))
  call Hloop_ZQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),ngZn,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(4),n2h8(4))
  call Hloop_ZQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),ngZn,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(5),n2h8(5))
  call Hloop_ZQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),ngZn,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(6),n2h8(6))
  call Hloop_WQ_A(ntryL,G1H16(7),ex1(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(7),n2h8(7))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex1(:),G1H8(1),ngZn,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_Z(ntryL,G1H16(9),ex1(:),G1H8(2),ngZn,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_W(ntryL,G1H16(10),ex1(:),G1H8(3),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_ZQ_A(ntryL,G1H16(11),ex1(:),G1H8(4),ngZn,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(4),41,0,G2H8(8),n2h8(8))
  call Hloop_ZQ_A(ntryL,G1H16(12),ex1(:),G1H8(4),ngZn,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(4),41,0,G2H8(9),n2h8(9))
  call Hloop_ZA_Q(ntryL,G1H16(13),ex2(:),G1H8(4),ngZn,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(4),38,0,G2H8(10),n2h8(10))
  call Hloop_ZA_Q(ntryL,G1H16(14),ex2(:),G1H8(4),ngZn,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(4),38,0,G2H8(11),n2h8(11))
  call Hloop_QA_Z(ntryL,G1H16(15),ex5(:),G1H8(4),ngZl,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_QA_Z(ntryL,G1H16(16),ex5(:),G1H8(5),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_QA_W(ntryL,G1H16(17),ex5(:),G1H8(6),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex1(:),G1H8(7),ngZn,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H16(19),ex1(:),G1H8(8),ngZn,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AQ_W(ntryL,G1H16(20),ex1(:),G1H8(9),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_VQ_A(ntryL,G1H16(21),ex3(:),G1H8(10),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(10),44,0,G2H8(12),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(22),ex3(:),G1H8(10),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(10),44,0,G2H8(13),n2h8(13))
  call Hloop_ZQ_A(ntryL,G1H16(23),ex3(:),G1H8(10),ngZl,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(10),44,0,G2H8(14),n2h8(14))
  call Hloop_ZQ_A(ntryL,G1H16(24),ex3(:),G1H8(10),ngZl,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(10),44,0,G2H8(15),n2h8(15))
  call Hloop_ZA_Q(ntryL,G1H16(25),ex2(:),G1H8(10),ngZn,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(10),38,0,G2H8(16),n2h8(16))
  call Hloop_ZA_Q(ntryL,G1H16(26),ex2(:),G1H8(10),ngZn,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(10),38,0,G2H8(17),n2h8(17))
  call Hloop_QA_W(ntryL,G1H16(27),ex2(:),G1H8(10),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QA_W(ntryL,G1H16(28),ex2(:),G1H8(11),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_QA_W(ntryL,G1H16(29),ex2(:),G1H8(12),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_QA_W(ntryL,G1H16(30),ex2(:),G1H8(13),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_QA_Z(ntryL,G1H16(31),ex2(:),G1H8(14),ngZn,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_VQ_A(ntryL,G1H16(32),ex4(:),G1H8(15),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(15),44,0,G2H8(18),n2h8(18))
  call Hloop_VQ_A(ntryL,G1H16(33),ex4(:),G1H8(15),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(15),44,0,G2H8(19),n2h8(19))
  call Hloop_ZQ_A(ntryL,G1H16(34),ex4(:),G1H8(15),ngZl,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(15),44,0,G2H8(20),n2h8(20))
  call Hloop_ZQ_A(ntryL,G1H16(35),ex4(:),G1H8(15),ngZl,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(15),44,0,G2H8(21),n2h8(21))
  call Hloop_QA_Z(ntryL,G1H16(36),ex5(:),G1H8(15),ngZl,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_QA_Z(ntryL,G1H16(37),ex5(:),G1H8(16),ngZl,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_VA_Q(ntryL,G1H16(38),ex5(:),G1H8(17),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(22),n2h8(22))
  call Hloop_VA_Q(ntryL,G1H16(39),ex5(:),G1H8(17),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(23),n2h8(23))
  call Hloop_ZA_Q(ntryL,G1H16(40),ex5(:),G1H8(17),ngZl,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(24),n2h8(24))
  call Hloop_ZA_Q(ntryL,G1H16(41),ex5(:),G1H8(17),ngZl,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(25),n2h8(25))
  call Hloop_WA_Q(ntryL,G1H16(42),ex5(:),G1H8(17),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(17),52,0,G2H8(26),n2h8(26))
  call Hloop_AQ_Z(ntryL,G1H16(43),ex1(:),G1H8(17),ngZn,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_AQ_Z(ntryL,G1H16(44),ex1(:),G1H8(18),ngZn,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_AQ_Z(ntryL,G1H16(45),ex1(:),G1H8(19),ngZn,m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AQ_Z(ntryL,G1H16(46),ex1(:),G1H8(20),ngZn,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_WA_Q(ntryL,G1H16(47),ex2(:),G1H8(21),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(21),35,0,G2H8(27),n2h8(27))
  call Hloop_WA_Q(ntryL,G1H16(48),ex2(:),G1H8(21),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(21),35,0,G2H8(28),n2h8(28))
  call Hloop_WA_Q(ntryL,G1H16(49),ex2(:),G1H8(21),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(21),35,0,G2H8(29),n2h8(29))
  call Hloop_WA_Q(ntryL,G1H16(50),ex2(:),G1H8(21),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(21),35,0,G2H8(30),n2h8(30))
  call Hloop_QA_Z(ntryL,G1H16(51),ex2(:),G1H8(21),ngZn,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_QA_Z(ntryL,G1H16(52),ex2(:),G1H8(22),ngZn,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_WA_Q(ntryL,G1H16(53),ex2(:),G1H8(23),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(31),n2h8(31))
  call Hloop_WA_Q(ntryL,G1H16(54),ex2(:),G1H8(23),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(32),n2h8(32))
  call Hloop_WA_Q(ntryL,G1H16(55),ex2(:),G1H8(23),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(33),n2h8(33))
  call Hloop_WA_Q(ntryL,G1H16(56),ex2(:),G1H8(23),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(34),n2h8(34))
  call Hloop_ZA_Q(ntryL,G1H16(57),ex2(:),G1H8(23),ngZn,m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(35),n2h8(35))
  call Hloop_WA_Q(ntryL,G1H16(58),ex2(:),G1H8(23),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(36),n2h8(36))
  call Hloop_WA_Q(ntryL,G1H16(59),ex2(:),G1H8(23),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(37),n2h8(37))
  call Hloop_WA_Q(ntryL,G1H16(60),ex2(:),G1H8(23),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(38),n2h8(38))
  call Hloop_WA_Q(ntryL,G1H16(61),ex2(:),G1H8(23),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(39),n2h8(39))
  call Hloop_QA_Z(ntryL,G1H16(62),ex2(:),G1H8(23),ngZn,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_QA_Z(ntryL,G1H16(63),ex2(:),G1H8(24),ngZn,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_WA_Q(ntryL,G1H16(64),ex2(:),G1H8(25),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(40),n2h8(40))
  call Hloop_WA_Q(ntryL,G1H16(65),ex2(:),G1H8(25),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(41),n2h8(41))
  call Hloop_WA_Q(ntryL,G1H16(66),ex2(:),G1H8(25),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(42),n2h8(42))
  call Hloop_WA_Q(ntryL,G1H16(67),ex2(:),G1H8(25),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(43),n2h8(43))
  call Hloop_ZA_Q(ntryL,G1H16(68),ex2(:),G1H8(25),ngZn,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(44),n2h8(44))
  call Hloop_QA_Z(ntryL,G1H16(69),ex2(:),G1H8(25),ngZn,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_QA_Z(ntryL,G1H16(70),ex2(:),G1H8(26),ngZn,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_QA_Z(ntryL,G1H16(71),ex2(:),G1H8(27),ngZn,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_QA_Z(ntryL,G1H16(72),ex2(:),G1H8(28),ngZn,m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_ZA_Q(ntryL,G1H16(73),ex2(:),G1H8(29),ngZn,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(45),n2h8(45))
  call Hloop_ZA_Q(ntryL,G1H16(74),ex2(:),G1H8(29),ngZn,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(46),n2h8(46))
  call Hloop_AQ_W(ntryL,G1H16(75),ex3(:),G1H8(29),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_AQ_W(ntryL,G1H16(76),ex3(:),G1H8(30),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_AQ_Z(ntryL,G1H16(77),ex3(:),G1H8(31),ngZl,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_ZQ_A(ntryL,G1H16(78),ex1(:),G1H8(32),ngZn,m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(47),n2h8(47))
  call Hloop_ZQ_A(ntryL,G1H16(79),ex1(:),G1H8(32),ngZn,m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(48),n2h8(48))
  call Hloop_WQ_A(ntryL,G1H16(80),ex1(:),G1H8(32),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(49),n2h8(49))
  call Hloop_AQ_W(ntryL,G1H16(81),ex4(:),G1H8(32),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_AQ_V(ntryL,G1H16(82),ex4(:),G1H8(33),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_AQ_Z(ntryL,G1H16(83),ex4(:),G1H8(34),ngZl,m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_WQ_A(ntryL,G1H16(84),ex3(:),G1H8(35),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(50),n2h8(50))
  call Hloop_WQ_A(ntryL,G1H16(85),ex3(:),G1H8(35),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(51),n2h8(51))
  call Hloop_WQ_A(ntryL,G1H16(86),ex3(:),G1H8(35),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(52),n2h8(52))
  call Hloop_WQ_A(ntryL,G1H16(87),ex3(:),G1H8(35),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(53),n2h8(53))
  call Hloop_ZQ_A(ntryL,G1H16(88),ex3(:),G1H8(35),ngZl,m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(54),n2h8(54))
  call Hloop_ZQ_A(ntryL,G1H16(89),ex3(:),G1H8(35),ngZl,m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(55),n2h8(55))
  call Hloop_WQ_A(ntryL,G1H16(90),ex3(:),G1H8(35),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(56),n2h8(56))
  call Hloop_WQ_A(ntryL,G1H16(91),ex3(:),G1H8(35),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(57),n2h8(57))
  call Hloop_ZQ_A(ntryL,G1H16(92),ex3(:),G1H8(35),ngZl,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(58),n2h8(58))
  call Hloop_ZQ_A(ntryL,G1H16(93),ex3(:),G1H8(35),ngZl,m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(59),n2h8(59))
  call Hloop_WQ_A(ntryL,G1H16(94),ex3(:),G1H8(35),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(60),n2h8(60))
  call Hloop_ZA_Q(ntryL,G1H16(95),ex2(:),G1H8(35),ngZn,m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(35),38,0,G2H8(61),n2h8(61))
  call Hloop_ZA_Q(ntryL,G1H16(96),ex2(:),G1H8(35),ngZn,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H8(35),38,0,G2H8(62),n2h8(62))
  call Hloop_QA_W(ntryL,G1H16(97),ex2(:),G1H8(35),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_QA_W(ntryL,G1H16(98),ex2(:),G1H8(36),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_QA_Z(ntryL,G1H16(99),ex2(:),G1H8(37),ngZn,m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AQ_W(ntryL,G1H16(100),ex3(:),G1H8(38),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_AQ_V(ntryL,G1H16(101),ex3(:),G1H8(39),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H16(102),ex3(:),G1H8(40),ngZl,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_AQ_W(ntryL,G1H16(103),ex4(:),G1H8(41),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_AQ_W(ntryL,G1H16(104),ex4(:),G1H8(42),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_AQ_Z(ntryL,G1H16(105),ex4(:),G1H8(43),ngZl,m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_WQ_A(ntryL,G1H16(106),ex4(:),G1H8(44),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(63),n2h8(63))
  call Hloop_WQ_A(ntryL,G1H16(107),ex4(:),G1H8(44),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(64),n2h8(64))
  call Hloop_ZQ_A(ntryL,G1H16(108),ex4(:),G1H8(44),ngZl,m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(65),n2h8(65))
  call Hloop_WQ_A(ntryL,G1H16(109),ex4(:),G1H8(44),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(66),n2h8(66))
  call Hloop_WQ_A(ntryL,G1H16(110),ex4(:),G1H8(44),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(67),n2h8(67))
  call Hloop_ZQ_A(ntryL,G1H16(111),ex4(:),G1H8(44),ngZl,m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(68),n2h8(68))
  call Hloop_ZQ_A(ntryL,G1H16(112),ex4(:),G1H8(44),ngZl,m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(69),n2h8(69))
  call Hloop_WQ_A(ntryL,G1H16(113),ex4(:),G1H8(44),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(70),n2h8(70))
  call Hloop_WQ_A(ntryL,G1H16(114),ex4(:),G1H8(44),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(71),n2h8(71))
  call Hloop_WQ_A(ntryL,G1H16(115),ex4(:),G1H8(44),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(72),n2h8(72))
  call Hloop_ZQ_A(ntryL,G1H16(116),ex4(:),G1H8(44),ngZl,m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(44),41,0,G2H8(73),n2h8(73))
  call Hloop_QA_W(ntryL,G1H16(117),ex5(:),G1H8(44),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_ZA_Q(ntryL,G1H16(118),ex5(:),G1H8(45),ngZl,m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(45),49,0,G2H8(74),n2h8(74))
  call Hloop_QA_W(ntryL,G1H16(119),ex5(:),G1H8(45),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_ZA_Q(ntryL,G1H16(120),ex5(:),G1H8(46),ngZl,m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(46),49,0,G2H8(75),n2h8(75))
  call Hloop_QA_W(ntryL,G1H16(121),ex5(:),G1H8(46),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_QA_W(ntryL,G1H16(122),ex5(:),G1H8(47),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_ZA_Q(ntryL,G1H16(123),ex5(:),G1H8(48),ngZl,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(48),49,0,G2H8(76),n2h8(76))
  call Hloop_ZA_Q(ntryL,G1H16(124),ex5(:),G1H8(48),ngZl,m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G1H8(48),49,0,G2H8(77),n2h8(77))
  call Hloop_QA_W(ntryL,G1H16(125),ex5(:),G1H8(48),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_QA_W(ntryL,G1H16(126),ex5(:),G1H8(49),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_ZA_Q(ntryL,G1H16(127),ex5(:),G1H8(50),ngZl,m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(50),49,0,G2H8(78),n2h8(78))
  call Hloop_ZA_Q(ntryL,G1H16(128),ex5(:),G1H8(50),ngZl,m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(50),49,0,G2H8(79),n2h8(79))
  call Hloop_AQ_Z(ntryL,G2H8(1),ex1(:),G2H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_Z(ntryL,G2H8(3),ex2(:),G2H4(3),ngZn,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_Z(ntryL,G2H8(4),ex2(:),G2H4(4),ngZn,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_Z(ntryL,G2H8(5),ex2(:),G2H4(5),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_Z(ntryL,G2H8(6),ex2(:),G2H4(6),ngZn,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_W(ntryL,G2H8(7),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(8),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex3(:),G1H4(1),ngZl,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(9),n2h4(2))
  call Hloop_WQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(10),n2h4(3))
  call Hloop_QA_Z(ntryL,G2H8(8),ex2(:),G2H4(11),ngZn,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_Z(ntryL,G2H8(9),ex2(:),G2H4(12),ngZn,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H8(10),ex1(:),G2H4(13),ngZn,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex1(:),G2H4(14),ngZn,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_ZA_Q(ntryL,G1H8(4),ex2(:),G1H4(1),ngZn,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(15),n2h4(4))
  call Hloop_ZA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),ngZn,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(16),n2h4(5))
  call Hloop_WA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(17),n2h4(6))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex4(:),G1H4(1),ngZl,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(18),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(8),ex4(:),G1H4(1),ngZl,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(19),n2h4(8))
  call Hloop_WQ_A(ntryL,G1H8(9),ex4(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(20),n2h4(9))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_W(ntryL,G2H8(13),ex2(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_W(ntryL,G2H8(14),ex2(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_W(ntryL,G2H8(15),ex2(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_AQ_Z(ntryL,G2H8(16),ex1(:),G2H4(25),ngZn,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_Z(ntryL,G2H8(17),ex1(:),G2H4(26),ngZn,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(27),n2h4(10))
  call Hloop_WQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(28),n2h4(11))
  call Hloop_WQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(29),n2h4(12))
  call Hloop_WQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(30),n2h4(13))
  call Hloop_ZQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),ngZn,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(31),n2h4(14))
  call Hloop_QA_W(ntryL,G2H8(18),ex2(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QA_W(ntryL,G2H8(19),ex2(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_QA_W(ntryL,G2H8(20),ex2(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_QA_W(ntryL,G2H8(21),ex2(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex1(:),G1H4(1),ngZn,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(36),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(16),ex1(:),G1H4(1),ngZn,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(37),n2h4(16))
  call Hloop_AQ_W(ntryL,G2H8(22),ex1(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_W(ntryL,G2H8(23),ex1(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_AQ_W(ntryL,G2H8(24),ex1(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_AQ_W(ntryL,G2H8(25),ex1(:),G2H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H8(26),ex1(:),G2H4(42),ngZn,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_ZA_Q(ntryL,G1H8(17),ex5(:),G1H4(1),ngZl,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(43),n2h4(17))
  call Hloop_ZA_Q(ntryL,G1H8(18),ex5(:),G1H4(1),ngZl,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(44),n2h4(18))
  call Hloop_ZA_Q(ntryL,G1H8(19),ex5(:),G1H4(1),ngZl,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(45),n2h4(19))
  call Hloop_ZA_Q(ntryL,G1H8(20),ex5(:),G1H4(1),ngZl,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(46),n2h4(20))
  call Hloop_AQ_V(ntryL,G2H8(27),ex3(:),G2H4(47),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_AQ_V(ntryL,G2H8(28),ex3(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_AQ_Z(ntryL,G2H8(29),ex3(:),G2H4(49),ngZl,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_AQ_Z(ntryL,G2H8(30),ex3(:),G2H4(50),ngZl,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_ZQ_A(ntryL,G1H8(21),ex3(:),G1H4(1),ngZl,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(51),n2h4(21))
  call Hloop_ZQ_A(ntryL,G1H8(22),ex3(:),G1H4(1),ngZl,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(52),n2h4(22))
  call Hloop_AQ_V(ntryL,G2H8(31),ex3(:),G2H4(53),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_AQ_V(ntryL,G2H8(32),ex3(:),G2H4(54),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_AQ_Z(ntryL,G2H8(33),ex3(:),G2H4(55),ngZl,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_AQ_Z(ntryL,G2H8(34),ex3(:),G2H4(56),ngZl,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_AQ_W(ntryL,G2H8(35),ex3(:),G2H4(57),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_AQ_V(ntryL,G2H8(36),ex4(:),G2H4(58),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_AQ_V(ntryL,G2H8(37),ex4(:),G2H4(59),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_AQ_Z(ntryL,G2H8(38),ex4(:),G2H4(60),ngZl,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_AQ_Z(ntryL,G2H8(39),ex4(:),G2H4(61),ngZl,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_ZQ_A(ntryL,G1H8(23),ex4(:),G1H4(1),ngZl,m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(62),n2h4(23))
  call Hloop_ZQ_A(ntryL,G1H8(24),ex4(:),G1H4(1),ngZl,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(63),n2h4(24))
  call Hloop_AQ_V(ntryL,G2H8(40),ex4(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_AQ_Z(ntryL,G2H8(41),ex4(:),G2H4(65),ngZl,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_AQ_V(ntryL,G2H8(42),ex4(:),G2H4(66),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_AQ_Z(ntryL,G2H8(43),ex4(:),G2H4(67),ngZl,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_AQ_W(ntryL,G2H8(44),ex4(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_ZA_Q(ntryL,G1H8(25),ex5(:),G1H4(1),ngZl,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(69),n2h4(25))
  call Hloop_ZA_Q(ntryL,G1H8(26),ex5(:),G1H4(1),ngZl,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(70),n2h4(26))
  call Hloop_ZA_Q(ntryL,G1H8(27),ex5(:),G1H4(1),ngZl,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(71),n2h4(27))
  call Hloop_ZA_Q(ntryL,G1H8(28),ex5(:),G1H4(1),ngZl,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(72),n2h4(28))
  call Hloop_AQ_W(ntryL,G2H8(45),ex3(:),G2H4(73),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_AQ_W(ntryL,G2H8(46),ex3(:),G2H4(74),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_WQ_A(ntryL,G1H8(29),ex1(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(75),n2h4(29))
  call Hloop_WQ_A(ntryL,G1H8(30),ex1(:),G1H4(1),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(76),n2h4(30))
  call Hloop_ZQ_A(ntryL,G1H8(31),ex1(:),G1H4(1),ngZn,m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(77),n2h4(31))
  call Hloop_QA_W(ntryL,G2H8(47),ex5(:),G2H4(78),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_QA_W(ntryL,G2H8(48),ex5(:),G2H4(79),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_QA_Z(ntryL,G2H8(49),ex5(:),G2H4(80),ngZl,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_WA_Q(ntryL,G1H8(32),ex5(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(81),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H8(33),ex5(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(82),n2h4(33))
  call Hloop_ZA_Q(ntryL,G1H8(34),ex5(:),G1H4(1),ngZl,m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(83),n2h4(34))
  call Hloop_QA_Z(ntryL,G2H8(50),ex2(:),G2H4(84),ngZn,m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_QA_Z(ntryL,G2H8(51),ex2(:),G2H4(85),ngZn,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QA_Z(ntryL,G2H8(52),ex2(:),G2H4(86),ngZn,m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QA_Z(ntryL,G2H8(53),ex2(:),G2H4(87),ngZn,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_QA_W(ntryL,G2H8(54),ex2(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_QA_Z(ntryL,G2H8(55),ex5(:),G2H4(89),ngZl,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_QA_W(ntryL,G2H8(56),ex5(:),G2H4(90),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_QA_W(ntryL,G2H8(57),ex5(:),G2H4(91),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_QA_V(ntryL,G2H8(58),ex5(:),G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_QA_Z(ntryL,G2H8(59),ex5(:),G2H4(93),ngZl,m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_QA_W(ntryL,G2H8(60),ex5(:),G2H4(94),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_AQ_W(ntryL,G2H8(61),ex4(:),G2H4(95),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_AQ_W(ntryL,G2H8(62),ex4(:),G2H4(96),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_WA_Q(ntryL,G1H8(35),ex5(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(97),n2h4(35))
  call Hloop_WA_Q(ntryL,G1H8(36),ex5(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(98),n2h4(36))
  call Hloop_ZA_Q(ntryL,G1H8(37),ex5(:),G1H4(1),ngZl,m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(99),n2h4(37))
  call Hloop_WA_Q(ntryL,G1H8(38),ex5(:),G1H4(1),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(100),n2h4(38))
  call Hloop_VA_Q(ntryL,G1H8(39),ex5(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(101),n2h4(39))
  call Hloop_ZA_Q(ntryL,G1H8(40),ex5(:),G1H4(1),ngZl,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(102),n2h4(40))
  call Hloop_WQ_A(ntryL,G1H8(41),ex1(:),G1H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(103),n2h4(41))
  call Hloop_WQ_A(ntryL,G1H8(42),ex1(:),G1H4(1),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(104),n2h4(42))
  call Hloop_ZQ_A(ntryL,G1H8(43),ex1(:),G1H4(1),ngZn,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(105),n2h4(43))
  call Hloop_QA_Z(ntryL,G2H8(63),ex2(:),G2H4(106),ngZn,m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_QA_Z(ntryL,G2H8(64),ex2(:),G2H4(107),ngZn,m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_QA_Z(ntryL,G2H8(65),ex5(:),G2H4(108),ngZl,m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_QA_W(ntryL,G2H8(66),ex5(:),G2H4(109),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_QA_W(ntryL,G2H8(67),ex5(:),G2H4(110),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_QA_V(ntryL,G2H8(68),ex5(:),G2H4(111),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_QA_Z(ntryL,G2H8(69),ex5(:),G2H4(112),ngZl,m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_QA_W(ntryL,G2H8(70),ex5(:),G2H4(113),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_QA_Z(ntryL,G2H8(71),ex2(:),G2H4(114),ngZn,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_QA_Z(ntryL,G2H8(72),ex2(:),G2H4(115),ngZn,m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_QA_W(ntryL,G2H8(73),ex2(:),G2H4(116),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_WQ_A(ntryL,G1H8(44),ex3(:),G1H4(1),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(117),n2h4(44))
  call Hloop_AQ_Z(ntryL,G2H8(74),ex3(:),G2H4(118),ngZl,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_WQ_A(ntryL,G1H8(45),ex4(:),G1H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),57,0,G2H4(119),n2h4(45))
  call Hloop_AQ_Z(ntryL,G2H8(75),ex4(:),G2H4(120),ngZl,m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_WA_Q(ntryL,G1H8(46),ex2(:),G1H4(1),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(121),n2h4(46))
  call Hloop_WA_Q(ntryL,G1H8(47),ex2(:),G1H4(1),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(122),n2h4(47))
  call Hloop_AQ_V(ntryL,G2H8(76),ex4(:),G2H4(123),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_AQ_Z(ntryL,G2H8(77),ex4(:),G2H4(124),ngZl,m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_WA_Q(ntryL,G1H8(48),ex2(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(125),n2h4(48))
  call Hloop_WA_Q(ntryL,G1H8(49),ex2(:),G1H4(1),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(126),n2h4(49))
  call Hloop_AQ_V(ntryL,G2H8(78),ex3(:),G2H4(127),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_AQ_Z(ntryL,G2H8(79),ex3(:),G2H4(128),ngZl,m3h2x4(:,128),heltab2x8(:,:,128))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(2),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(2),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(2),mass5set(:,2),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,3),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hloop_QA_V(ntryL,G2H4(8),ex5(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(9),ex5(:),G2H2(2),ngZl,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_W(ntryL,G2H4(10),ex5(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(3),mass5set(:,2),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(4),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(4),mass5set(:,2),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hloop_AQ_Z(ntryL,G2H4(15),ex1(:),G2H2(4),ngZn,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H4(16),ex1(:),G2H2(5),ngZn,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_W(ntryL,G2H4(17),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(18),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_Z(ntryL,G2H4(19),ex5(:),G2H2(8),ngZl,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_W(ntryL,G2H4(20),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(5),mass5set(:,4),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(5),mass5set(:,5),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(5),mass5set(:,6),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(5),mass5set(:,7),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),16,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(4),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),8,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(4),mass5set(:,2),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hloop_QA_V(ntryL,G2H4(27),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_Z(ntryL,G2H4(28),ex5(:),G2H2(11),ngZl,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(29),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_Z(ntryL,G2H4(30),ex5(:),G2H2(13),ngZl,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_W(ntryL,G2H4(31),ex5(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(6),mass5set(:,4),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),16,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(6),mass5set(:,5),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(6),mass5set(:,6),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(6),mass5set(:,7),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),16,4)
  call Hloop_QA_Z(ntryL,G2H4(36),ex2(:),G2H2(15),ngZn,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(37),ex2(:),G2H2(16),ngZn,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(7),mass5set(:,4),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(7),mass5set(:,5),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),8,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(7),mass5set(:,6),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),8,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(7),mass5set(:,7),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(7),mass5set(:,8),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),8,4)
  call Hloop_AQ_V(ntryL,G2H4(43),ex3(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H4(44),ex3(:),G2H2(18),ngZl,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_V(ntryL,G2H4(45),ex4(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_Z(ntryL,G2H4(46),ex4(:),G2H2(20),ngZl,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(8),mass5set(:,9),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),16,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(8),mass5set(:,10),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),16,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(8),mass5set(:,11),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),16,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(8),mass5set(:,12),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),16,4)
  call Hloop_QA_V(ntryL,G2H4(51),ex5(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_Z(ntryL,G2H4(52),ex5(:),G2H2(22),ngZl,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(8),mass5set(:,9),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),8,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(8),mass5set(:,10),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),8,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(8),mass5set(:,11),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(8),mass5set(:,12),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(8),mass5set(:,13),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(9),mass5set(:,9),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),16,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(9),mass5set(:,10),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(9),mass5set(:,11),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),16,4)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(9),mass5set(:,12),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),16,4)
  call Hloop_QA_V(ntryL,G2H4(62),ex5(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G2H4(63),ex5(:),G2H2(24),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(9),mass5set(:,9),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),4,4)
  call Hotf_5pt_reduction(G2H4(65),RedSet_5(9),mass5set(:,11),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(9),mass5set(:,10),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),4,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(9),mass5set(:,12),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),4,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(9),mass5set(:,13),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),4,4)
  call Hloop_AQ_V(ntryL,G2H4(69),ex3(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_Z(ntryL,G2H4(70),ex3(:),G2H2(26),ngZl,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_V(ntryL,G2H4(71),ex4(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_Z(ntryL,G2H4(72),ex4(:),G2H2(28),ngZl,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(10),mass5set(:,6),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),16,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(10),mass5set(:,7),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),16,4)
  call Hloop_QA_V(ntryL,G2H4(75),ex5(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G2H4(76),ex5(:),G2H2(30),ngZl,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_W(ntryL,G2H4(77),ex5(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(11),mass5set(:,6),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),8,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(11),mass5set(:,7),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),8,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(11),mass5set(:,8),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),8,4)
  call Hloop_AQ_Z(ntryL,G2H4(81),ex1(:),G2H2(32),ngZn,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_W(ntryL,G2H4(82),ex1(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_W(ntryL,G2H4(83),ex1(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(12),mass5set(:,11),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(296),16,4)
  call Hotf_5pt_reduction(G2H4(85),RedSet_5(12),mass5set(:,12),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(302),16,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(12),mass5set(:,11),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
  call HG1shiftOLR(G1H4(308),8,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(12),mass5set(:,12),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
  call HG1shiftOLR(G1H4(314),8,4)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(12),mass5set(:,13),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
  call HG1shiftOLR(G1H4(320),8,4)
  call Hotf_5pt_reduction(G2H4(89),RedSet_5(13),mass5set(:,14),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
  call HG1shiftOLR(G1H4(326),8,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(13),mass5set(:,15),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
  call HG1shiftOLR(G1H4(332),8,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(13),mass5set(:,16),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),8,4)
  call Hotf_5pt_reduction(G2H4(92),RedSet_5(13),mass5set(:,17),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),2,4)
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(13),mass5set(:,14),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(350),2,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(13),mass5set(:,16),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),2,4)
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(14),mass5set(:,6),  & 
G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),G1H4(366),4)
  call HG1shiftOLR(G1H4(362),16,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(14),mass5set(:,7),  & 
G1H4(367),G1H4(368),G1H4(369),G1H4(370),G1H4(371),G1H4(372),4)
  call HG1shiftOLR(G1H4(368),16,4)
  call Hloop_AQ_Z(ntryL,G2H4(97),ex1(:),G2H2(35),ngZn,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H4(98),ex1(:),G2H2(36),ngZn,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_W(ntryL,G2H4(99),ex1(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_Z(ntryL,G2H4(100),ex1(:),G2H2(38),ngZn,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_W(ntryL,G2H4(101),ex1(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_W(ntryL,G2H4(102),ex1(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_V(ntryL,G2H4(103),ex5(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_Z(ntryL,G2H4(104),ex5(:),G2H2(42),ngZl,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_QA_W(ntryL,G2H4(105),ex5(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(15),mass5set(:,11),  & 
G1H4(373),G1H4(374),G1H4(375),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(374),16,4)
  call Hotf_5pt_reduction(G2H4(107),RedSet_5(15),mass5set(:,12),  & 
G1H4(379),G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(380),16,4)
  call Hotf_5pt_reduction(G2H4(108),RedSet_5(16),mass5set(:,14),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),4,4)
  call Hotf_5pt_reduction(G2H4(109),RedSet_5(16),mass5set(:,15),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),G1H4(396),4)
  call HG1shiftOLR(G1H4(392),4,4)
  call Hotf_5pt_reduction(G2H4(110),RedSet_5(16),mass5set(:,16),  & 
G1H4(397),G1H4(398),G1H4(399),G1H4(400),G1H4(401),G1H4(402),4)
  call HG1shiftOLR(G1H4(398),4,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(16),mass5set(:,17),  & 
G1H4(403),G1H4(404),G1H4(405),G1H4(406),G1H4(407),G1H4(408),4)
  call HG1shiftOLR(G1H4(404),2,4)
  call Hotf_5pt_reduction(G2H4(112),RedSet_5(16),mass5set(:,14),  & 
G1H4(409),G1H4(410),G1H4(411),G1H4(412),G1H4(413),G1H4(414),4)
  call HG1shiftOLR(G1H4(410),2,4)
  call Hotf_5pt_reduction(G2H4(113),RedSet_5(16),mass5set(:,16),  & 
G1H4(415),G1H4(416),G1H4(417),G1H4(418),G1H4(419),G1H4(420),4)
  call HG1shiftOLR(G1H4(416),2,4)
  call Hotf_5pt_reduction(G2H4(114),RedSet_5(15),mass5set(:,11),  & 
G1H4(421),G1H4(422),G1H4(423),G1H4(424),G1H4(425),G1H4(426),4)
  call HG1shiftOLR(G1H4(422),4,4)
  call Hotf_5pt_reduction(G2H4(115),RedSet_5(15),mass5set(:,12),  & 
G1H4(427),G1H4(428),G1H4(429),G1H4(430),G1H4(431),G1H4(432),4)
  call HG1shiftOLR(G1H4(428),4,4)
  call Hotf_5pt_reduction(G2H4(116),RedSet_5(15),mass5set(:,13),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),4,4)
  call Hloop_QA_Z(ntryL,G2H4(117),ex2(:),G2H2(44),ngZn,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hotf_5pt_reduction(G2H4(118),RedSet_5(17),mass5set(:,14),  & 
G1H4(439),G1H4(440),G1H4(441),G1H4(442),G1H4(443),G1H4(444),4)
  call HG1shiftOLR(G1H4(440),8,4)
  call Hloop_QA_Z(ntryL,G2H4(119),ex2(:),G2H2(45),ngZn,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hotf_5pt_reduction(G2H4(120),RedSet_5(18),mass5set(:,14),  & 
G1H4(445),G1H4(446),G1H4(447),G1H4(448),G1H4(449),G1H4(450),4)
  call HG1shiftOLR(G1H4(446),4,4)
  call Hloop_AQ_V(ntryL,G2H4(121),ex3(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_Z(ntryL,G2H4(122),ex3(:),G2H2(47),ngZl,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hotf_5pt_reduction(G2H4(123),RedSet_5(18),mass5set(:,17),  & 
G1H4(451),G1H4(452),G1H4(453),G1H4(454),G1H4(455),G1H4(456),4)
  call HG1shiftOLR(G1H4(452),2,4)
  call Hotf_5pt_reduction(G2H4(124),RedSet_5(18),mass5set(:,14),  & 
G1H4(457),G1H4(458),G1H4(459),G1H4(460),G1H4(461),G1H4(462),4)
  call HG1shiftOLR(G1H4(458),2,4)
  call Hloop_AQ_V(ntryL,G2H4(125),ex4(:),G2H2(48),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_Z(ntryL,G2H4(126),ex4(:),G2H2(49),ngZl,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hotf_5pt_reduction(G2H4(127),RedSet_5(17),mass5set(:,17),  & 
G1H4(463),G1H4(464),G1H4(465),G1H4(466),G1H4(467),G1H4(468),4)
  call HG1shiftOLR(G1H4(464),2,4)
  call Hotf_5pt_reduction(G2H4(128),RedSet_5(17),mass5set(:,14),  & 
G1H4(469),G1H4(470),G1H4(471),G1H4(472),G1H4(473),G1H4(474),4)
  call HG1shiftOLR(G1H4(470),2,4)
  call Hloop_ZQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),ngZl,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(50),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex5(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),ngZl,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(51),n2h2(2))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex3(:),G1H2(2),ngZl,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(52),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(8),ex5(:),G1H2(2),ngZl,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex3(:),G1H2(3),ngZl,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(53),n2h2(4))
  call Hloop_ZQ_A(ntryL,G1H4(13),ex4(:),G1H2(3),ngZl,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(54),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex5(:),G1H2(3),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_ZQ_A(ntryL,G1H4(18),ex4(:),G1H2(4),ngZl,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(4),47,0,G2H2(55),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex4(:),G1H2(4),ngZl,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(4),47,0,G2H2(56),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(20),ex5(:),G1H2(4),ngZl,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex4(:),G1H2(5),ngZl,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(5),47,0,G2H2(57),n2h2(8))
  call Hloop_ZA_Q(ntryL,G1H4(25),ex5(:),G1H2(5),ngZl,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(5),55,0,G2H2(58),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(26),ex4(:),G1H2(5),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_ZA_Q(ntryL,G1H4(30),ex5(:),G1H2(6),ngZl,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(6),55,0,G2H2(59),n2h2(10))
  call Hloop_ZA_Q(ntryL,G1H4(31),ex5(:),G1H2(6),ngZl,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(6),55,0,G2H2(60),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(32),ex4(:),G1H2(6),ngZl,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_ZA_Q(ntryL,G1H4(36),ex5(:),G1H2(7),ngZl,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(61),n2h2(12))
  call Hloop_WA_Q(ntryL,G1H4(37),ex5(:),G1H2(7),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(62),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(38),ex4(:),G1H2(7),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_WA_Q(ntryL,G1H4(42),ex5(:),G1H2(8),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(8),55,0,G2H2(63),n2h2(14))
  call Hloop_ZQ_A(ntryL,G1H4(43),ex3(:),G1H2(8),ngZl,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(64),n2h2(15))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(44),ex5(:),G1H2(8),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex3(:),G1H2(9),ngZl,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(65),n2h2(16))
  call Hloop_ZQ_A(ntryL,G1H4(49),ex3(:),G1H2(9),ngZl,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(66),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(50),ex5(:),G1H2(9),ngZl,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_ZQ_A(ntryL,G1H4(54),ex3(:),G1H2(10),ngZl,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(10),47,0,G2H2(67),n2h2(18))
  call Hloop_ZQ_A(ntryL,G1H4(55),ex4(:),G1H2(10),ngZl,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(10),47,0,G2H2(68),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(56),ex5(:),G1H2(10),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_ZQ_A(ntryL,G1H4(60),ex4(:),G1H2(11),ngZl,m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(11),47,0,G2H2(69),n2h2(20))
  call Hloop_ZQ_A(ntryL,G1H4(61),ex4(:),G1H2(11),ngZl,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(11),47,0,G2H2(70),n2h2(21))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(62),ex5(:),G1H2(11),ngZl,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_ZQ_A(ntryL,G1H4(66),ex4(:),G1H2(12),ngZl,m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(12),47,0,G2H2(71),n2h2(22))
  call Hloop_WQ_A(ntryL,G1H4(67),ex1(:),G1H2(12),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(12),47,0,G2H2(72),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(68),ex5(:),G1H2(12),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_WQ_A(ntryL,G1H4(72),ex1(:),G1H2(13),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(73),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(73),ex1(:),G1H2(13),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(74),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(74),ex5(:),G1H2(13),ngZl,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_WQ_A(ntryL,G1H4(78),ex1(:),G1H2(14),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(75),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(79),ex1(:),G1H2(14),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(76),n2h2(27))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(80),ex5(:),G1H2(14),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_WQ_A(ntryL,G1H4(84),ex1(:),G1H2(15),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(15),47,0,G2H2(77),n2h2(28))
  call Hloop_WQ_A(ntryL,G1H4(85),ex1(:),G1H2(15),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(15),47,0,G2H2(78),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(86),ex5(:),G1H2(15),ngZl,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_WQ_A(ntryL,G1H4(90),ex1(:),G1H2(16),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(16),47,0,G2H2(79),n2h2(30))
  call Hloop_ZA_Q(ntryL,G1H4(91),ex5(:),G1H2(16),ngZl,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(16),55,0,G2H2(80),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(92),ex4(:),G1H2(16),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_ZA_Q(ntryL,G1H4(96),ex5(:),G1H2(17),ngZl,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(17),55,0,G2H2(81),n2h2(32))
  call Hloop_ZA_Q(ntryL,G1H4(97),ex5(:),G1H2(17),ngZl,m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(17),55,0,G2H2(82),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(98),ex4(:),G1H2(17),ngZl,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_ZA_Q(ntryL,G1H4(102),ex5(:),G1H2(18),ngZl,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(18),55,0,G2H2(83),n2h2(34))
  call Hloop_WQ_A(ntryL,G1H4(103),ex1(:),G1H2(18),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(18),47,0,G2H2(84),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(104),ex5(:),G1H2(18),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_WQ_A(ntryL,G1H4(108),ex1(:),G1H2(19),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(85),n2h2(36))
  call Hloop_WQ_A(ntryL,G1H4(109),ex1(:),G1H2(19),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(86),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(110),ex5(:),G1H2(19),ngZl,m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_WQ_A(ntryL,G1H4(114),ex1(:),G1H2(20),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(87),n2h2(38))
  call Hloop_WQ_A(ntryL,G1H4(115),ex1(:),G1H2(20),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(88),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(116),ex5(:),G1H2(20),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_WQ_A(ntryL,G1H4(120),ex1(:),G1H2(21),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(21),47,0,G2H2(89),n2h2(40))
  call Hloop_WQ_A(ntryL,G1H4(121),ex1(:),G1H2(21),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(21),47,0,G2H2(90),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(122),ex5(:),G1H2(21),ngZl,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_WQ_A(ntryL,G1H4(126),ex1(:),G1H2(22),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(22),47,0,G2H2(91),n2h2(42))
  call Hloop_WA_Q(ntryL,G1H4(127),ex2(:),G1H2(22),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(22),55,0,G2H2(92),n2h2(43))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(128),ex4(:),G1H2(22),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_WA_Q(ntryL,G1H4(132),ex2(:),G1H2(23),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(23),55,0,G2H2(93),n2h2(44))
  call Hloop_WA_Q(ntryL,G1H4(133),ex2(:),G1H2(23),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(23),55,0,G2H2(94),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(134),ex4(:),G1H2(23),ngZl,m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_WA_Q(ntryL,G1H4(138),ex2(:),G1H2(24),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(24),55,0,G2H2(95),n2h2(46))
  call Hloop_WA_Q(ntryL,G1H4(139),ex2(:),G1H2(24),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(24),55,0,G2H2(96),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(140),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(140),ex4(:),G1H2(24),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_WA_Q(ntryL,G1H4(144),ex2(:),G1H2(25),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(97),n2h2(48))
  call Hloop_WA_Q(ntryL,G1H4(145),ex2(:),G1H2(25),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(98),n2h2(49))
call HGT_raise_alpha_OLR(G1H4(146),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(146),ex4(:),G1H2(25),ngZl,m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_WA_Q(ntryL,G1H4(150),ex2(:),G1H2(26),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(99),n2h2(50))
  call Hloop_ZA_Q(ntryL,G1H4(151),ex2(:),G1H2(26),ngZn,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(100),n2h2(51))
call HGT_raise_alpha_OLR(G1H4(152),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(152),ex4(:),G1H2(26),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_ZA_Q(ntryL,G1H4(156),ex2(:),G1H2(27),ngZn,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(27),55,0,G2H2(101),n2h2(52))
  call Hloop_VQ_A(ntryL,G1H4(157),ex4(:),G1H2(27),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(27),47,0,G2H2(102),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(158),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(158),ex5(:),G1H2(27),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_VQ_A(ntryL,G1H4(162),ex4(:),G1H2(28),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(28),47,0,G2H2(103),n2h2(54))
  call Hloop_VQ_A(ntryL,G1H4(163),ex4(:),G1H2(28),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(28),47,0,G2H2(104),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(164),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(164),ex5(:),G1H2(28),ngZl,m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_VQ_A(ntryL,G1H4(168),ex4(:),G1H2(29),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(29),47,0,G2H2(105),n2h2(56))
  call Hloop_ZQ_A(ntryL,G1H4(169),ex4(:),G1H2(29),ngZl,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(29),47,0,G2H2(106),n2h2(57))
call HGT_raise_alpha_OLR(G1H4(170),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(170),ex5(:),G1H2(29),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_ZQ_A(ntryL,G1H4(174),ex4(:),G1H2(30),ngZl,m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(30),47,0,G2H2(107),n2h2(58))
  call Hloop_ZQ_A(ntryL,G1H4(175),ex4(:),G1H2(30),ngZl,m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(30),47,0,G2H2(108),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(176),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(176),ex5(:),G1H2(30),ngZl,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_ZQ_A(ntryL,G1H4(180),ex4(:),G1H2(31),ngZl,m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(109),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(181),ex5(:),G1H2(31),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(110),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(182),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(182),ex4(:),G1H2(31),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_VA_Q(ntryL,G1H4(186),ex5(:),G1H2(32),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(32),55,0,G2H2(111),n2h2(62))
  call Hloop_VA_Q(ntryL,G1H4(187),ex5(:),G1H2(32),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(32),55,0,G2H2(112),n2h2(63))
call HGT_raise_alpha_OLR(G1H4(188),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(188),ex4(:),G1H2(32),ngZl,m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_VA_Q(ntryL,G1H4(192),ex5(:),G1H2(33),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(33),55,0,G2H2(113),n2h2(64))
  call Hloop_ZA_Q(ntryL,G1H4(193),ex5(:),G1H2(33),ngZl,m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(33),55,0,G2H2(114),n2h2(65))
call HGT_raise_alpha_OLR(G1H4(194),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(194),ex4(:),G1H2(33),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_ZA_Q(ntryL,G1H4(198),ex5(:),G1H2(34),ngZl,m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(34),55,0,G2H2(115),n2h2(66))
  call Hloop_ZA_Q(ntryL,G1H4(199),ex5(:),G1H2(34),ngZl,m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(34),55,0,G2H2(116),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(200),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(200),ex4(:),G1H2(34),ngZl,m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_ZA_Q(ntryL,G1H4(204),ex5(:),G1H2(35),ngZl,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(35),55,0,G2H2(117),n2h2(68))
  call Hloop_WA_Q(ntryL,G1H4(205),ex5(:),G1H2(35),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(35),55,0,G2H2(118),n2h2(69))
call HGT_raise_alpha_OLR(G1H4(206),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(206),ex4(:),G1H2(35),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_WA_Q(ntryL,G1H4(210),ex5(:),G1H2(36),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(36),55,0,G2H2(119),n2h2(70))
  call Hloop_VQ_A(ntryL,G1H4(211),ex3(:),G1H2(36),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(36),47,0,G2H2(120),n2h2(71))
call HGT_raise_alpha_OLR(G1H4(212),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(212),ex5(:),G1H2(36),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_VQ_A(ntryL,G1H4(216),ex3(:),G1H2(37),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(121),n2h2(72))
  call Hloop_VQ_A(ntryL,G1H4(217),ex3(:),G1H2(37),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(122),n2h2(73))
call HGT_raise_alpha_OLR(G1H4(218),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(218),ex5(:),G1H2(37),ngZl,m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_VQ_A(ntryL,G1H4(222),ex3(:),G1H2(38),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(123),n2h2(74))
  call Hloop_ZQ_A(ntryL,G1H4(223),ex3(:),G1H2(38),ngZl,m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(124),n2h2(75))
call HGT_raise_alpha_OLR(G1H4(224),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(224),ex5(:),G1H2(38),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_ZQ_A(ntryL,G1H4(228),ex3(:),G1H2(39),ngZl,m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(39),47,0,G2H2(125),n2h2(76))
  call Hloop_ZQ_A(ntryL,G1H4(229),ex3(:),G1H2(39),ngZl,m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(39),47,0,G2H2(126),n2h2(77))
call HGT_raise_alpha_OLR(G1H4(230),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(230),ex5(:),G1H2(39),ngZl,m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_ZQ_A(ntryL,G1H4(234),ex3(:),G1H2(40),ngZl,m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(40),47,0,G2H2(127),n2h2(78))
  call Hloop_VA_Q(ntryL,G1H4(235),ex5(:),G1H2(40),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(40),59,0,G2H2(128),n2h2(79))
call HGT_raise_alpha_OLR(G1H4(236),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(236),ex3(:),G1H2(40),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_VA_Q(ntryL,G1H4(240),ex5(:),G1H2(41),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(41),59,0,G2H2(129),n2h2(80))
  call Hloop_ZA_Q(ntryL,G1H4(241),ex5(:),G1H2(41),ngZl,m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(41),59,0,G2H2(130),n2h2(81))
call HGT_raise_alpha_OLR(G1H4(242),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(242),ex3(:),G1H2(41),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_ZA_Q(ntryL,G1H4(246),ex5(:),G1H2(42),ngZl,m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(42),59,0,G2H2(131),n2h2(82))
  call Hloop_VA_Q(ntryL,G1H4(247),ex5(:),G1H2(42),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(42),59,0,G2H2(132),n2h2(83))
call HGT_raise_alpha_OLR(G1H4(248),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(248),ex3(:),G1H2(42),ngZl,m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_VA_Q(ntryL,G1H4(252),ex5(:),G1H2(43),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(43),59,0,G2H2(133),n2h2(84))
  call Hloop_ZA_Q(ntryL,G1H4(253),ex5(:),G1H2(43),ngZl,m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(43),59,0,G2H2(134),n2h2(85))
call HGT_raise_alpha_OLR(G1H4(254),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(254),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(254),ex3(:),G1H2(43),ngZl,m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_ZA_Q(ntryL,G1H4(258),ex5(:),G1H2(44),ngZl,m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(44),59,0,G2H2(135),n2h2(86))
  call Hloop_WA_Q(ntryL,G1H4(259),ex5(:),G1H2(44),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(44),59,0,G2H2(136),n2h2(87))
call HGT_raise_alpha_OLR(G1H4(260),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(260),ex3(:),G1H2(44),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_WA_Q(ntryL,G1H4(264),ex5(:),G1H2(45),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(45),59,0,G2H2(137),n2h2(88))
  call Hloop_WQ_A(ntryL,G1H4(265),ex1(:),G1H2(45),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(45),47,0,G2H2(138),n2h2(89))
call HGT_raise_alpha_OLR(G1H4(266),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(266),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(266),ex5(:),G1H2(45),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_WQ_A(ntryL,G1H4(270),ex1(:),G1H2(46),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(46),47,0,G2H2(139),n2h2(90))
  call Hloop_WQ_A(ntryL,G1H4(271),ex1(:),G1H2(46),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(46),47,0,G2H2(140),n2h2(91))
call HGT_raise_alpha_OLR(G1H4(272),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(272),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(272),ex5(:),G1H2(46),ngZl,m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_WQ_A(ntryL,G1H4(276),ex1(:),G1H2(47),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(47),47,0,G2H2(141),n2h2(92))
  call Hloop_WA_Q(ntryL,G1H4(277),ex2(:),G1H2(47),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(47),55,0,G2H2(142),n2h2(93))
call HGT_raise_alpha_OLR(G1H4(278),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(278),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(278),ex4(:),G1H2(47),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_WA_Q(ntryL,G1H4(282),ex2(:),G1H2(48),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(48),55,0,G2H2(143),n2h2(94))
  call Hloop_WA_Q(ntryL,G1H4(283),ex2(:),G1H2(48),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(48),55,0,G2H2(144),n2h2(95))
call HGT_raise_alpha_OLR(G1H4(284),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(284),ex4(:),G1H2(48),ngZl,m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_WA_Q(ntryL,G1H4(288),ex2(:),G1H2(49),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(145),n2h2(96))
  call Hloop_ZA_Q(ntryL,G1H4(289),ex2(:),G1H2(49),ngZn,m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(146),n2h2(97))
call HGT_raise_alpha_OLR(G1H4(290),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(290),ex4(:),G1H2(49),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_ZA_Q(ntryL,G1H4(294),ex2(:),G1H2(50),ngZn,m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(50),55,0,G2H2(147),n2h2(98))
  call Hloop_ZQ_A(ntryL,G1H4(295),ex4(:),G1H2(50),ngZl,m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(148),n2h2(99))
call HGT_raise_alpha_OLR(G1H4(296),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(296),ex5(:),G1H2(50),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_ZQ_A(ntryL,G1H4(300),ex4(:),G1H2(51),ngZl,m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(51),47,0,G2H2(149),n2h2(100))
  call Hloop_ZQ_A(ntryL,G1H4(301),ex4(:),G1H2(51),ngZl,m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(51),47,0,G2H2(150),n2h2(101))
call HGT_raise_alpha_OLR(G1H4(302),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(302),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(302),ex5(:),G1H2(51),ngZl,m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_ZQ_A(ntryL,G1H4(306),ex4(:),G1H2(52),ngZl,m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(52),47,0,G2H2(151),n2h2(102))
  call Hloop_ZA_Q(ntryL,G1H4(307),ex5(:),G1H2(52),ngZl,m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(52),55,0,G2H2(152),n2h2(103))
call HGT_raise_alpha_OLR(G1H4(308),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(308),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(308),ex4(:),G1H2(52),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_ZA_Q(ntryL,G1H4(312),ex5(:),G1H2(53),ngZl,m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(53),55,0,G2H2(153),n2h2(104))
  call Hloop_ZA_Q(ntryL,G1H4(313),ex5(:),G1H2(53),ngZl,m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(53),55,0,G2H2(154),n2h2(105))
call HGT_raise_alpha_OLR(G1H4(314),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(314),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(314),ex4(:),G1H2(53),ngZl,m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_ZA_Q(ntryL,G1H4(318),ex5(:),G1H2(54),ngZl,m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(54),55,0,G2H2(155),n2h2(106))
  call Hloop_WA_Q(ntryL,G1H4(319),ex5(:),G1H2(54),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(54),55,0,G2H2(156),n2h2(107))
call HGT_raise_alpha_OLR(G1H4(320),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(320),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(320),ex4(:),G1H2(54),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_WA_Q(ntryL,G1H4(324),ex5(:),G1H2(55),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(157),n2h2(108))
  call Hloop_ZA_Q(ntryL,G1H4(325),ex2(:),G1H2(55),ngZn,m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(55),55,0,G2H2(158),n2h2(109))
call HGT_raise_alpha_OLR(G1H4(326),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(326),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(326),ex4(:),G1H2(55),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_ZA_Q(ntryL,G1H4(330),ex2(:),G1H2(56),ngZn,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(56),55,0,G2H2(159),n2h2(110))
  call Hloop_WA_Q(ntryL,G1H4(331),ex2(:),G1H2(56),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(56),55,0,G2H2(160),n2h2(111))
call HGT_raise_alpha_OLR(G1H4(332),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(332),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(332),ex4(:),G1H2(56),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_WA_Q(ntryL,G1H4(336),ex2(:),G1H2(57),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(57),55,0,G2H2(161),n2h2(112))
  call Hloop_WA_Q(ntryL,G1H4(337),ex2(:),G1H2(57),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(57),55,0,G2H2(162),n2h2(113))
call HGT_raise_alpha_OLR(G1H4(338),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(338),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(338),ex4(:),G1H2(57),ngZl,m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_WA_Q(ntryL,G1H4(342),ex2(:),G1H2(58),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(58),55,0,G2H2(163),n2h2(114))
  call Hloop_VQ_A(ntryL,G1H4(343),ex4(:),G1H2(58),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(58),61,0,G2H2(164),n2h2(115))
call HGT_raise_alpha_OLR(G1H4(344),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(344),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(344),ex2(:),G1H2(58),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_VQ_A(ntryL,G1H4(348),ex4(:),G1H2(59),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(59),61,0,G2H2(165),n2h2(116))
  call Hloop_ZQ_A(ntryL,G1H4(349),ex4(:),G1H2(59),ngZl,m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(59),61,0,G2H2(166),n2h2(117))
call HGT_raise_alpha_OLR(G1H4(350),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(350),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(350),ex2(:),G1H2(59),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_ZQ_A(ntryL,G1H4(354),ex4(:),G1H2(60),ngZl,m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_Q_A(ntryL,G1H2(60),61,0,G2H2(167),n2h2(118))
  call Hloop_WQ_A(ntryL,G1H4(355),ex4(:),G1H2(60),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(60),61,0,G2H2(168),n2h2(119))
call HGT_raise_alpha_OLR(G1H4(356),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(356),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(356),ex2(:),G1H2(60),ngZn,m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_WQ_A(ntryL,G1H4(360),ex4(:),G1H2(61),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(61),61,0,G2H2(169),n2h2(120))
  call Hloop_WQ_A(ntryL,G1H4(361),ex1(:),G1H2(61),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(170),n2h2(121))
call HGT_raise_alpha_OLR(G1H4(362),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(362),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(362),ex5(:),G1H2(61),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_WQ_A(ntryL,G1H4(366),ex1(:),G1H2(62),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(171),n2h2(122))
  call Hloop_WQ_A(ntryL,G1H4(367),ex1(:),G1H2(62),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(172),n2h2(123))
call HGT_raise_alpha_OLR(G1H4(368),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(368),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(368),ex5(:),G1H2(62),ngZl,m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_WQ_A(ntryL,G1H4(372),ex1(:),G1H2(63),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(63),47,0,G2H2(173),n2h2(124))
  call Hloop_ZQ_A(ntryL,G1H4(373),ex3(:),G1H2(63),ngZl,m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(63),47,0,G2H2(174),n2h2(125))
call HGT_raise_alpha_OLR(G1H4(374),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(374),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(374),ex5(:),G1H2(63),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_ZQ_A(ntryL,G1H4(378),ex3(:),G1H2(64),ngZl,m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(64),47,0,G2H2(175),n2h2(126))
  call Hloop_ZQ_A(ntryL,G1H4(379),ex3(:),G1H2(64),ngZl,m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(64),47,0,G2H2(176),n2h2(127))
call HGT_raise_alpha_OLR(G1H4(380),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(380),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(380),ex5(:),G1H2(64),ngZl,m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_ZQ_A(ntryL,G1H4(384),ex3(:),G1H2(65),ngZl,m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(65),47,0,G2H2(177),n2h2(128))
  call Hloop_ZA_Q(ntryL,G1H4(385),ex2(:),G1H2(65),ngZn,m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_A_Q(ntryL,G1H2(65),59,0,G2H2(178),n2h2(129))
call HGT_raise_alpha_OLR(G1H4(386),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(386),ex3(:),G1H2(65),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_ZA_Q(ntryL,G1H4(390),ex2(:),G1H2(66),ngZn,m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(66),59,0,G2H2(179),n2h2(130))
  call Hloop_WA_Q(ntryL,G1H4(391),ex2(:),G1H2(66),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_A_Q(ntryL,G1H2(66),59,0,G2H2(180),n2h2(131))
call HGT_raise_alpha_OLR(G1H4(392),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(392),ex3(:),G1H2(66),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_WA_Q(ntryL,G1H4(396),ex2(:),G1H2(67),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(67),59,0,G2H2(181),n2h2(132))
  call Hloop_WA_Q(ntryL,G1H4(397),ex2(:),G1H2(67),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(67),59,0,G2H2(182),n2h2(133))
call HGT_raise_alpha_OLR(G1H4(398),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(398),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(398),ex3(:),G1H2(67),ngZl,m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_WA_Q(ntryL,G1H4(402),ex2(:),G1H2(68),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(68),59,0,G2H2(183),n2h2(134))
  call Hloop_VQ_A(ntryL,G1H4(403),ex3(:),G1H2(68),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(68),61,0,G2H2(184),n2h2(135))
call HGT_raise_alpha_OLR(G1H4(404),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(404),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(404),ex2(:),G1H2(68),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_VQ_A(ntryL,G1H4(408),ex3(:),G1H2(69),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(69),61,0,G2H2(185),n2h2(136))
  call Hloop_ZQ_A(ntryL,G1H4(409),ex3(:),G1H2(69),ngZl,m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(69),61,0,G2H2(186),n2h2(137))
call HGT_raise_alpha_OLR(G1H4(410),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(410),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(410),ex2(:),G1H2(69),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_ZQ_A(ntryL,G1H4(414),ex3(:),G1H2(70),ngZl,m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_Q_A(ntryL,G1H2(70),61,0,G2H2(187),n2h2(138))
  call Hloop_WQ_A(ntryL,G1H4(415),ex3(:),G1H2(70),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(70),61,0,G2H2(188),n2h2(139))
call HGT_raise_alpha_OLR(G1H4(416),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(416),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(416),ex2(:),G1H2(70),ngZn,m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_WQ_A(ntryL,G1H4(420),ex3(:),G1H2(71),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(71),61,0,G2H2(189),n2h2(140))
  call Hloop_ZA_Q(ntryL,G1H4(421),ex5(:),G1H2(71),ngZl,m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(71),59,0,G2H2(190),n2h2(141))
call HGT_raise_alpha_OLR(G1H4(422),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(422),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(422),ex3(:),G1H2(71),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_ZA_Q(ntryL,G1H4(426),ex5(:),G1H2(72),ngZl,m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_A_Q(ntryL,G1H2(72),59,0,G2H2(191),n2h2(142))
  call Hloop_ZA_Q(ntryL,G1H4(427),ex5(:),G1H2(72),ngZl,m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_A_Q(ntryL,G1H2(72),59,0,G2H2(192),n2h2(143))
call HGT_raise_alpha_OLR(G1H4(428),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(428),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(428),ex3(:),G1H2(72),ngZl,m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_ZA_Q(ntryL,G1H4(432),ex5(:),G1H2(73),ngZl,m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_A_Q(ntryL,G1H2(73),59,0,G2H2(193),n2h2(144))
  call Hloop_WA_Q(ntryL,G1H4(433),ex5(:),G1H2(73),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_A_Q(ntryL,G1H2(73),59,0,G2H2(194),n2h2(145))
call HGT_raise_alpha_OLR(G1H4(434),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(434),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(434),ex3(:),G1H2(73),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_WA_Q(ntryL,G1H4(438),ex5(:),G1H2(74),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_A_Q(ntryL,G1H2(74),59,0,G2H2(195),n2h2(146))
  call Hloop_ZA_Q(ntryL,G1H4(439),ex2(:),G1H2(74),ngZn,m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_A_Q(ntryL,G1H2(74),55,0,G2H2(196),n2h2(147))
call HGT_raise_alpha_OLR(G1H4(440),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(440),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(440),ex4(:),G1H2(74),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_ZA_Q(ntryL,G1H4(444),ex2(:),G1H2(75),ngZn,m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_A_Q(ntryL,G1H2(75),55,0,G2H2(197),n2h2(148))
  call Hloop_ZA_Q(ntryL,G1H4(445),ex2(:),G1H2(75),ngZn,m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_A_Q(ntryL,G1H2(75),59,0,G2H2(198),n2h2(149))
call HGT_raise_alpha_OLR(G1H4(446),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(446),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(446),ex3(:),G1H2(75),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_ZA_Q(ntryL,G1H4(450),ex2(:),G1H2(76),ngZn,m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_A_Q(ntryL,G1H2(76),59,0,G2H2(199),n2h2(150))
  call Hloop_VQ_A(ntryL,G1H4(451),ex3(:),G1H2(76),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(76),61,0,G2H2(200),n2h2(151))
call HGT_raise_alpha_OLR(G1H4(452),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(452),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(452),ex2(:),G1H2(76),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_VQ_A(ntryL,G1H4(456),ex3(:),G1H2(77),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(77),61,0,G2H2(201),n2h2(152))
  call Hloop_ZQ_A(ntryL,G1H4(457),ex3(:),G1H2(77),ngZl,m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_Q_A(ntryL,G1H2(77),61,0,G2H2(202),n2h2(153))
call HGT_raise_alpha_OLR(G1H4(458),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(458),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(458),ex2(:),G1H2(77),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_ZQ_A(ntryL,G1H4(462),ex3(:),G1H2(78),ngZl,m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(78),61,0,G2H2(203),n2h2(154))
  call Hloop_VQ_A(ntryL,G1H4(463),ex4(:),G1H2(78),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(78),61,0,G2H2(204),n2h2(155))
call HGT_raise_alpha_OLR(G1H4(464),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(464),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(464),ex2(:),G1H2(78),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_VQ_A(ntryL,G1H4(468),ex4(:),G1H2(79),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(79),61,0,G2H2(205),n2h2(156))
  call Hloop_ZQ_A(ntryL,G1H4(469),ex4(:),G1H2(79),ngZl,m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(79),61,0,G2H2(206),n2h2(157))
call HGT_raise_alpha_OLR(G1H4(470),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(470),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(470),ex2(:),G1H2(79),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_ZQ_A(ntryL,G1H4(474),ex4(:),G1H2(80),ngZl,m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(80),61,0,G2H2(207),n2h2(158))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(19),mass5set(:,18),  & 
G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(81),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(19),mass5set(:,18),  & 
G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),2)
  call HG1shiftOLR(G1H2(87),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(19),mass5set(:,19),  & 
G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),2)
  call HG1shiftOLR(G1H2(93),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(20),mass5set(:,20),  & 
G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),2)
  call HG1shiftOLR(G1H2(99),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(20),mass5set(:,18),  & 
G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),2)
  call HG1shiftOLR(G1H2(105),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(20),mass5set(:,19),  & 
G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),2)
  call HG1shiftOLR(G1H2(111),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(21),mass5set(:,18),  & 
G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(117),4,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(21),mass5set(:,18),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(123),4,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(21),mass5set(:,19),  & 
G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(129),4,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,21),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(135),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(4),mass5set(:,21),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),2)
  call HG1shiftOLR(G1H2(141),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(4),mass5set(:,22),  & 
G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),2)
  call HG1shiftOLR(G1H2(147),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(4),mass5set(:,22),  & 
G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(153),8,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(4),mass5set(:,23),  & 
G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(159),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(7),mass5set(:,20),  & 
G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),2)
  call HG1shiftOLR(G1H2(165),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(7),mass5set(:,18),  & 
G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),2)
  call HG1shiftOLR(G1H2(171),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(22),mass5set(:,18),  & 
G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),2)
  call HG1shiftOLR(G1H2(177),8,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(22),mass5set(:,18),  & 
G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),2)
  call HG1shiftOLR(G1H2(183),8,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(22),mass5set(:,18),  & 
G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(189),4,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(22),mass5set(:,18),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(195),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(8),mass5set(:,18),  & 
G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),G1H2(205),2)
  call HG1shiftOLR(G1H2(201),8,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(8),mass5set(:,18),  & 
G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(207),8,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(9),mass5set(:,18),  & 
G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),G1H2(217),2)
  call HG1shiftOLR(G1H2(213),4,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(9),mass5set(:,18),  & 
G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),G1H2(223),2)
  call HG1shiftOLR(G1H2(219),4,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(23),mass5set(:,18),  & 
G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),G1H2(229),2)
  call HG1shiftOLR(G1H2(225),8,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(23),mass5set(:,18),  & 
G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),G1H2(235),2)
  call HG1shiftOLR(G1H2(231),8,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(23),mass5set(:,18),  & 
G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),G1H2(241),2)
  call HG1shiftOLR(G1H2(237),4,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(23),mass5set(:,18),  & 
G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),2)
  call HG1shiftOLR(G1H2(243),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(24),mass5set(:,22),  & 
G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),G1H2(253),2)
  call HG1shiftOLR(G1H2(249),8,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(24),mass5set(:,22),  & 
G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),2)
  call HG1shiftOLR(G1H2(255),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(24),mass5set(:,23),  & 
G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),G1H2(265),2)
  call HG1shiftOLR(G1H2(261),8,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(25),mass5set(:,22),  & 
G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),G1H2(271),2)
  call HG1shiftOLR(G1H2(267),4,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(25),mass5set(:,24),  & 
G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),G1H2(277),2)
  call HG1shiftOLR(G1H2(273),4,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(25),mass5set(:,23),  & 
G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),G1H2(283),2)
  call HG1shiftOLR(G1H2(279),4,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(26),mass5set(:,21),  & 
G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),G1H2(289),2)
  call HG1shiftOLR(G1H2(285),8,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(26),mass5set(:,22),  & 
G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),G1H2(295),2)
  call HG1shiftOLR(G1H2(291),8,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(26),mass5set(:,23),  & 
G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),G1H2(301),2)
  call HG1shiftOLR(G1H2(297),8,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(27),mass5set(:,22),  & 
G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),G1H2(307),2)
  call HG1shiftOLR(G1H2(303),8,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(27),mass5set(:,24),  & 
G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),G1H2(313),2)
  call HG1shiftOLR(G1H2(309),8,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(27),mass5set(:,23),  & 
G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),G1H2(319),2)
  call HG1shiftOLR(G1H2(315),8,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(28),mass5set(:,22),  & 
G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),G1H2(325),2)
  call HG1shiftOLR(G1H2(321),4,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(28),mass5set(:,22),  & 
G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),G1H2(331),2)
  call HG1shiftOLR(G1H2(327),4,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(28),mass5set(:,23),  & 
G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(333),4,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(17),mass5set(:,22),  & 
G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),G1H2(343),2)
  call HG1shiftOLR(G1H2(339),8,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(18),mass5set(:,22),  & 
G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),G1H2(349),2)
  call HG1shiftOLR(G1H2(345),4,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(29),mass5set(:,22),  & 
G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),G1H2(355),2)
  call HG1shiftOLR(G1H2(351),8,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(29),mass5set(:,22),  & 
G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),G1H2(361),2)
  call HG1shiftOLR(G1H2(357),8,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(29),mass5set(:,22),  & 
G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),G1H2(367),2)
  call HG1shiftOLR(G1H2(363),4,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(29),mass5set(:,22),  & 
G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),G1H2(373),2)
  call HG1shiftOLR(G1H2(369),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(52),ex5(:),G2tensor(2),ngZl,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(56),ex5(:),G2tensor(4),ngZl,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(58),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(6),ngZl,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(62),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(64),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(66),ex5(:),G2tensor(9),ngZl,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(68),ex5(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(70),ex5(:),G2tensor(11),ngZl,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(72),ex5(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(74),ex5(:),G2tensor(13),ngZl,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(76),ex5(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(78),ex5(:),G2tensor(15),ngZl,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(80),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(82),ex4(:),G2tensor(17),ngZl,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(84),ex5(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(86),ex5(:),G2tensor(19),ngZl,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(88),ex5(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(90),ex5(:),G2tensor(21),ngZl,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(92),ex4(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(94),ex4(:),G2tensor(23),ngZl,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(96),ex4(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(98),ex4(:),G2tensor(25),ngZl,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(100),ex4(:),G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex5(:),G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(104),ex5(:),G2tensor(28),ngZl,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex5(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(108),ex5(:),G2tensor(30),ngZl,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(110),ex4(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(112),ex4(:),G2tensor(32),ngZl,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(114),ex4(:),G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(116),ex4(:),G2tensor(34),ngZl,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(118),ex4(:),G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(120),ex5(:),G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(122),ex5(:),G2tensor(37),ngZl,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(124),ex5(:),G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(126),ex5(:),G2tensor(39),ngZl,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(128),ex3(:),G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(130),ex3(:),G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(132),ex3(:),G2tensor(42),ngZl,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(134),ex3(:),G2tensor(43),ngZl,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(136),ex3(:),G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(138),ex5(:),G2tensor(45),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(140),ex5(:),G2tensor(46),ngZl,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(142),ex4(:),G2tensor(47),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(144),ex4(:),G2tensor(48),ngZl,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(146),ex4(:),G2tensor(49),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(148),ex5(:),G2tensor(50),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(150),ex5(:),G2tensor(51),ngZl,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(152),ex4(:),G2tensor(52),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(154),ex4(:),G2tensor(53),ngZl,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(156),ex4(:),G2tensor(54),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(158),ex4(:),G2tensor(55),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(160),ex4(:),G2tensor(56),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(162),ex4(:),G2tensor(57),ngZl,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(164),ex2(:),G2tensor(58),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(166),ex2(:),G2tensor(59),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(168),ex2(:),G2tensor(60),ngZn,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(170),ex5(:),G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(172),ex5(:),G2tensor(62),ngZl,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(174),ex5(:),G2tensor(63),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(176),ex5(:),G2tensor(64),ngZl,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(178),ex3(:),G2tensor(65),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(180),ex3(:),G2tensor(66),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(182),ex3(:),G2tensor(67),ngZl,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(184),ex2(:),G2tensor(68),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(186),ex2(:),G2tensor(69),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(188),ex2(:),G2tensor(70),ngZn,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(190),ex3(:),G2tensor(71),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(192),ex3(:),G2tensor(72),ngZl,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(194),ex3(:),G2tensor(73),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(196),ex4(:),G2tensor(74),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(198),ex3(:),G2tensor(75),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(200),ex2(:),G2tensor(76),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(202),ex2(:),G2tensor(77),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(204),ex2(:),G2tensor(78),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(206),ex2(:),G2tensor(79),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hloop_VQ_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(81),n2h1(2))
  call Hloop_ZQ_A(ntryL,G1H2(86),ex4(:),G1H1(1),ngZl,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(82),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(87),ex4(:),G1H1(1),ngZl,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(83),n2h1(4))
  call Hloop_WQ_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(5))
  call Hloop_WQ_A(ntryL,G1H2(93),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(85),n2h1(6))
  call Hloop_ZQ_A(ntryL,G1H2(98),ex4(:),G1H1(1),ngZl,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(7))
  call Hloop_ZQ_A(ntryL,G1H2(99),ex4(:),G1H1(1),ngZl,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(87),n2h1(8))
  call Hloop_ZQ_A(ntryL,G1H2(104),ex4(:),G1H1(1),ngZl,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(105),ex4(:),G1H1(1),ngZl,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(89),n2h1(10))
  call Hloop_WQ_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(11))
  call Hloop_WQ_A(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(91),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(116),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(92),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(117),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(93),n2h1(14))
  call Hloop_ZQ_A(ntryL,G1H2(122),ex3(:),G1H1(1),ngZl,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(15))
  call Hloop_ZQ_A(ntryL,G1H2(123),ex3(:),G1H1(1),ngZl,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(95),n2h1(16))
  call Hloop_WQ_A(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(17))
  call Hloop_WQ_A(ntryL,G1H2(129),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(97),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(99),n2h1(20))
  call Hloop_ZQ_A(ntryL,G1H2(140),ex4(:),G1H1(1),ngZl,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(100),n2h1(21))
  call Hloop_ZQ_A(ntryL,G1H2(141),ex4(:),G1H1(1),ngZl,m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(101),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(147),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(103),n2h1(24))
  call Hloop_ZQ_A(ntryL,G1H2(152),ex4(:),G1H1(1),ngZl,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(153),ex4(:),G1H1(1),ngZl,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(105),n2h1(26))
  call Hloop_WQ_A(ntryL,G1H2(158),ex4(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(159),ex4(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(107),n2h1(28))
  call Hloop_ZQ_A(ntryL,G1H2(164),ex4(:),G1H1(1),ngZl,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(29))
  call Hloop_ZQ_A(ntryL,G1H2(165),ex4(:),G1H1(1),ngZl,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(109),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(170),ex4(:),G1H1(1),ngZl,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(171),ex4(:),G1H1(1),ngZl,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(111),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(176),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(177),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(113),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H2(182),ex4(:),G1H1(1),ngZl,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(35))
  call Hloop_ZQ_A(ntryL,G1H2(183),ex4(:),G1H1(1),ngZl,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(115),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(116),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(189),ex3(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(117),n2h1(38))
  call Hloop_ZQ_A(ntryL,G1H2(194),ex3(:),G1H1(1),ngZl,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(39))
  call Hloop_ZQ_A(ntryL,G1H2(195),ex3(:),G1H1(1),ngZl,m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(119),n2h1(40))
  call Hloop_VQ_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(201),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(121),n2h1(42))
  call Hloop_ZQ_A(ntryL,G1H2(206),ex4(:),G1H1(1),ngZl,m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(43))
  call Hloop_ZQ_A(ntryL,G1H2(207),ex4(:),G1H1(1),ngZl,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(123),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(213),ex3(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(125),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(218),ex3(:),G1H1(1),ngZl,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(219),ex3(:),G1H1(1),ngZl,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(127),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(224),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(128),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(225),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(129),n2h1(50))
  call Hloop_ZQ_A(ntryL,G1H2(230),ex4(:),G1H1(1),ngZl,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(51))
  call Hloop_ZQ_A(ntryL,G1H2(231),ex4(:),G1H1(1),ngZl,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(131),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(236),ex3(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(237),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(133),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H2(242),ex3(:),G1H1(1),ngZl,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(55))
  call Hloop_ZQ_A(ntryL,G1H2(243),ex3(:),G1H1(1),ngZl,m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(135),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(248),ex4(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(249),ex4(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(137),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(254),ex4(:),G1H1(1),ngZl,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(59))
  call Hloop_ZQ_A(ntryL,G1H2(255),ex4(:),G1H1(1),ngZl,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(139),n2h1(60))
  call Hloop_WQ_A(ntryL,G1H2(260),ex4(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(61))
  call Hloop_WQ_A(ntryL,G1H2(261),ex4(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(141),n2h1(62))
  call Hloop_ZQ_A(ntryL,G1H2(266),ex3(:),G1H1(1),ngZl,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(63))
  call Hloop_ZQ_A(ntryL,G1H2(267),ex3(:),G1H1(1),ngZl,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(143),n2h1(64))
  call Hloop_WQ_A(ntryL,G1H2(272),ex3(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(65))
  call Hloop_WQ_A(ntryL,G1H2(273),ex3(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(145),n2h1(66))
  call Hloop_WQ_A(ntryL,G1H2(278),ex3(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(67))
  call Hloop_WQ_A(ntryL,G1H2(279),ex3(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(147),n2h1(68))
  call Hloop_ZQ_A(ntryL,G1H2(284),ex4(:),G1H1(1),ngZl,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(69))
  call Hloop_ZQ_A(ntryL,G1H2(285),ex4(:),G1H1(1),ngZl,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(149),n2h1(70))
  call Hloop_ZQ_A(ntryL,G1H2(290),ex4(:),G1H1(1),ngZl,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(71))
  call Hloop_ZQ_A(ntryL,G1H2(291),ex4(:),G1H1(1),ngZl,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(151),n2h1(72))
  call Hloop_WQ_A(ntryL,G1H2(296),ex4(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(73))
  call Hloop_WQ_A(ntryL,G1H2(297),ex4(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(153),n2h1(74))
  call Hloop_ZQ_A(ntryL,G1H2(302),ex4(:),G1H1(1),ngZl,m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(75))
  call Hloop_ZQ_A(ntryL,G1H2(303),ex4(:),G1H1(1),ngZl,m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(155),n2h1(76))
  call Hloop_WQ_A(ntryL,G1H2(308),ex4(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(77))
  call Hloop_WQ_A(ntryL,G1H2(309),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(157),n2h1(78))
  call Hloop_WQ_A(ntryL,G1H2(314),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(79))
  call Hloop_WQ_A(ntryL,G1H2(315),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(159),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(320),ex3(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(160),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(321),ex3(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(161),n2h1(82))
  call Hloop_ZQ_A(ntryL,G1H2(326),ex3(:),G1H1(1),ngZl,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(83))
  call Hloop_ZQ_A(ntryL,G1H2(327),ex3(:),G1H1(1),ngZl,m3h2x1(:,163),heltab2x2(:,:,163))



end subroutine vamp_1

end module ol_vamp_1_eellll_ew_nenexeeexex_1_/**/REALKIND
