
module ol_vamp_1_eellll_ew_eeeexexex_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eellll_ew_eeeexexex_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eellll_ew_eeeexexex_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eellll_ew_eeeexexex_1_/**/DREALKIND
  use ol_tensor_sum_storage_eellll_ew_eeeexexex_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eellll_ew_eeeexexex_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eellll_ew_eeeexexex_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,4,8,1,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,8,1,2,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,8,1,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,8,1,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,4,8,1,2,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,8,1,2,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,8,1,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,8,1,2,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,16,2,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,4,16,2,1,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,16,2,1,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,16,2,1,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,16,2,1,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,16,2,1,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,2,1,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,8,4,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,2,1,8,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,2,1,8,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,2,1,8,4,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,1,8,4,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,2,1,8,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,2,1,8,4,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(24))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,2,1,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(25),n2h32(25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,1,8,16,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(26),n2h32(26))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,1,8,16,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(27),n2h32(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,1,8,16,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(28),n2h32(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,2,1,8,16,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(29))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,2,1,8,16,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(30),n2h32(30))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,2,1,8,16,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,1,8,16,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(32),n2h32(32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,4,8,2,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(33))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,4,8,2,1,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(34),n2h32(34))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,4,8,2,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,4,8,2,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(36),n2h32(36))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,4,8,2,1,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(37))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,4,8,2,1,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(38),n2h32(38))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,8,2,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(39))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,8,2,1,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(40),n2h32(40))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,16,1,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(41),n2h32(41))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,16,1,2,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(42),n2h32(42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,16,1,2,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(43),n2h32(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,16,1,2,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(44),n2h32(44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,16,1,2,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(45),n2h32(45))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,16,1,2,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(46),n2h32(46))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,16,1,2,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(47),n2h32(47))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,4,16,1,2,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,2,1,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(49),n2h32(49))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,2,1,16,4,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(50),n2h32(50))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,2,1,16,4,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(51),n2h32(51))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,2,1,16,4,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(52),n2h32(52))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,2,1,16,4,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(53),n2h32(53))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,2,1,16,4,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(54),n2h32(54))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,2,1,16,4,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(55),n2h32(55))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,2,1,16,4,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(56),n2h32(56))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,2,1,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(57),n2h32(57))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,2,1,16,8,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(58),n2h32(58))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,2,1,16,8,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(59))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,2,1,16,8,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(60),n2h32(60))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,2,1,16,8,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(61),n2h32(61))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,2,1,16,8,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(62),n2h32(62))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,2,1,16,8,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(63))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,2,1,16,8,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(64),n2h32(64))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,1,2,8,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(65),n2h32(65))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,1,2,8,4,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(66),n2h32(66))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,1,2,8,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(67),n2h32(67))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,1,2,8,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(68),n2h32(68))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,1,2,8,4,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(69),n2h32(69))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,1,2,8,4,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(70),n2h32(70))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,1,2,8,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(71),n2h32(71))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,1,2,8,4,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(72),n2h32(72))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,1,2,8,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(73),n2h32(73))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,1,2,8,16,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(74),n2h32(74))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,1,2,8,16,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(75),n2h32(75))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,1,2,8,16,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(76),n2h32(76))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,1,2,8,16,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(77),n2h32(77))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,1,2,8,16,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(78),n2h32(78))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,1,2,8,16,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(79),n2h32(79))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,1,2,8,16,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(80),n2h32(80))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,1,2,16,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(81),n2h32(81))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,1,2,16,4,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(82),n2h32(82))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,2,16,4,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(83),n2h32(83))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,2,16,4,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(84),n2h32(84))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,1,2,16,4,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(85),n2h32(85))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,1,2,16,4,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(86),n2h32(86))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,1,2,16,4,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(87),n2h32(87))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,1,2,16,4,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,88),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(88),n2h32(88))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,1,2,16,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(89),n2h32(89))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,1,2,16,8,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,90),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(90),n2h32(90))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,1,2,16,8,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(91),n2h32(91))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,1,2,16,8,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(92),n2h32(92))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,1,2,16,8,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(93),n2h32(93))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,1,2,16,8,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(94),n2h32(94))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,1,2,16,8,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(95),n2h32(95))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,1,2,16,8,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(96),n2h32(96))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,4,1,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(97),n2h32(97))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,4,1,8,2,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,98),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(98),n2h32(98))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,4,1,8,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,99),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(99),n2h32(99))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,4,1,8,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,100),heltab2x64(:,:,100))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(100),n2h32(100))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,4,1,8,2,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(101),n2h32(101))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,4,1,8,2,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(102),n2h32(102))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,1,8,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,103),heltab2x64(:,:,103))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(103),n2h32(103))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,4,1,8,2,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,104),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(104),n2h32(104))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,2,8,1,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,105),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(105),n2h32(105))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,2,8,1,4,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(106),n2h32(106))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,2,8,1,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(107),n2h32(107))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,2,8,1,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(108),n2h32(108))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,2,8,1,4,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(109),n2h32(109))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,2,8,1,4,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(110),n2h32(110))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,2,8,1,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(111),n2h32(111))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,2,8,1,4,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(112),n2h32(112))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,2,16,4,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(113),n2h32(113))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,2,16,4,1,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(114),n2h32(114))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,2,16,4,1,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(115),n2h32(115))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,2,16,4,1,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(116),n2h32(116))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,2,16,4,1,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(117),n2h32(117))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,2,16,4,1,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,118),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(118),n2h32(118))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,2,16,4,1,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(119),n2h32(119))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,2,16,4,1,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),ngZl,m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(120),n2h32(120))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,2,16,8,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,121),heltab2x64(:,:,121))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,2,16,8,1,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,122),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,2,16,8,1,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZl,m3h2x32(:,123),heltab2x64(:,:,123))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,2,16,8,1,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,124),heltab2x64(:,:,124))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,2,16,8,1,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZl,m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,2,16,8,1,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,2,16,8,1,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZl,m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,2,16,8,1,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZl,m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,4,1,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,129),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(121),n2h32(121))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,4,1,16,2,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,130),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(122),n2h32(122))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,4,1,16,2,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,131),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(123),n2h32(123))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,4,1,16,2,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,132),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(124),n2h32(124))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,4,1,16,2,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,133),heltab2x64(:,:,133))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(125),n2h32(125))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,4,1,16,2,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,134),heltab2x64(:,:,134))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(126),n2h32(126))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,4,1,16,2,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(127),n2h32(127))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,4,1,16,2,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,136),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(128),n2h32(128))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,2,8,4,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(129),n2h32(129))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,2,8,4,1,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,138),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(130),n2h32(130))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,2,8,4,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(131),n2h32(131))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,2,8,4,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(132),n2h32(132))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,2,8,4,1,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,141),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(133),n2h32(133))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,2,8,4,1,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,142),heltab2x64(:,:,142))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(134),n2h32(134))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,2,8,4,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,143),heltab2x64(:,:,143))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(135),n2h32(135))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,2,8,4,1,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZl,m3h2x32(:,144),heltab2x64(:,:,144))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(136),n2h32(136))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,2,8,16,1,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,145),heltab2x64(:,:,145))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,2,8,16,1,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,146),heltab2x64(:,:,146))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,2,8,16,1,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZl,m3h2x32(:,147),heltab2x64(:,:,147))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,2,8,16,1,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,148),heltab2x64(:,:,148))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,2,8,16,1,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(13),ngZl,m3h2x32(:,149),heltab2x64(:,:,149))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,2,8,16,1,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,150),heltab2x64(:,:,150))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,2,8,16,1,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(15),ngZl,m3h2x32(:,151),heltab2x64(:,:,151))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,2,8,16,1,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(16),ngZl,m3h2x32(:,152),heltab2x64(:,:,152))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,2,16,1,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,153),heltab2x64(:,:,153))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(137),n2h32(137))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,2,16,1,4,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,154),heltab2x64(:,:,154))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(138),n2h32(138))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,2,16,1,4,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,155),heltab2x64(:,:,155))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(139),n2h32(139))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,2,16,1,4,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,156),heltab2x64(:,:,156))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(140),n2h32(140))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,2,16,1,4,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,157),heltab2x64(:,:,157))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(141),n2h32(141))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,2,16,1,4,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,158),heltab2x64(:,:,158))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(142),n2h32(142))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,2,16,1,4,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,159),heltab2x64(:,:,159))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(143),n2h32(143))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,2,16,1,4,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,160),heltab2x64(:,:,160))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(144),n2h32(144))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,1,4,8,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,161),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(145),n2h32(145))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,1,4,8,2,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,162),heltab2x64(:,:,162))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(146),n2h32(146))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,1,4,8,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,163),heltab2x64(:,:,163))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(147),n2h32(147))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,1,4,8,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,164),heltab2x64(:,:,164))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(148),n2h32(148))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,1,4,8,2,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,165),heltab2x64(:,:,165))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(149),n2h32(149))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,1,4,8,2,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,166),heltab2x64(:,:,166))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(150),n2h32(150))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,1,4,8,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,167),heltab2x64(:,:,167))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(151),n2h32(151))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,1,4,8,2,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,168),heltab2x64(:,:,168))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(152),n2h32(152))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,1,4,16,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,169),heltab2x64(:,:,169))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(153),n2h32(153))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,1,4,16,2,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,170),heltab2x64(:,:,170))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(154),n2h32(154))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,1,4,16,2,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,171),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(155),n2h32(155))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,1,4,16,2,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,172),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(156),n2h32(156))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,1,4,16,2,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,173),heltab2x64(:,:,173))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(157),n2h32(157))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,1,4,16,2,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,174),heltab2x64(:,:,174))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(158),n2h32(158))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,1,4,16,2,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,175),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(159),n2h32(159))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,1,4,16,2,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,176),heltab2x64(:,:,176))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(160),n2h32(160))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,1,4,16,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,177),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(161),n2h32(161))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,1,4,16,8,2],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,178),heltab2x64(:,:,178))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(162),n2h32(162))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,1,4,16,8,2],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,179),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(163),n2h32(163))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,1,4,16,8,2],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,180),heltab2x64(:,:,180))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(164),n2h32(164))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,1,4,16,8,2],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,181),heltab2x64(:,:,181))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(165),n2h32(165))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,1,4,16,8,2],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,182),heltab2x64(:,:,182))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(166),n2h32(166))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,1,4,16,8,2],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,183),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(167),n2h32(167))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,1,4,16,8,2],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,184),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(168),n2h32(168))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,1,4,8,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,185),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(169),n2h32(169))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,1,4,8,16,2],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,186),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(170),n2h32(170))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,1,4,8,16,2],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,187),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(171),n2h32(171))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,1,4,8,16,2],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,188),heltab2x64(:,:,188))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(172),n2h32(172))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,1,4,8,16,2],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,189),heltab2x64(:,:,189))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(173),n2h32(173))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,1,4,8,16,2],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,190),heltab2x64(:,:,190))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(174),n2h32(174))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,1,4,8,16,2],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,191),heltab2x64(:,:,191))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(175),n2h32(175))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,1,4,8,16,2],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,192),heltab2x64(:,:,192))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(176),n2h32(176))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,4,2,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,193),heltab2x64(:,:,193))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(177),n2h32(177))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,4,2,8,1,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,194),heltab2x64(:,:,194))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(178),n2h32(178))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,4,2,8,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,195),heltab2x64(:,:,195))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(179),n2h32(179))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,4,2,8,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,196),heltab2x64(:,:,196))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(180),n2h32(180))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,4,2,8,1,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,197),heltab2x64(:,:,197))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(181),n2h32(181))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,4,2,8,1,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,198),heltab2x64(:,:,198))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(182),n2h32(182))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,4,2,8,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,199),heltab2x64(:,:,199))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(183),n2h32(183))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,4,2,8,1,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,200),heltab2x64(:,:,200))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(184),n2h32(184))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,4,2,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,201),heltab2x64(:,:,201))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(185),n2h32(185))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,4,2,16,1,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,202),heltab2x64(:,:,202))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(186),n2h32(186))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,4,2,16,1,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,203),heltab2x64(:,:,203))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(187),n2h32(187))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,4,2,16,1,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,204),heltab2x64(:,:,204))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(188),n2h32(188))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,4,2,16,1,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,205),heltab2x64(:,:,205))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(189),n2h32(189))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,4,2,16,1,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,206),heltab2x64(:,:,206))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(190),n2h32(190))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,4,2,16,1,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,207),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(191),n2h32(191))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,4,2,16,1,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,208),heltab2x64(:,:,208))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(192),n2h32(192))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,2,4,8,1,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,209),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(193),n2h32(193))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,2,4,8,1,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,210),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(194),n2h32(194))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,2,4,8,1,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,211),heltab2x64(:,:,211))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(195),n2h32(195))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,2,4,8,1,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,212),heltab2x64(:,:,212))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(196),n2h32(196))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,2,4,8,1,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,213),heltab2x64(:,:,213))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(197),n2h32(197))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,2,4,8,1,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,214),heltab2x64(:,:,214))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(198),n2h32(198))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,4,8,1,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,215),heltab2x64(:,:,215))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(199),n2h32(199))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,2,4,8,1,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,216),heltab2x64(:,:,216))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(200),n2h32(200))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,2,4,16,1,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,217),heltab2x64(:,:,217))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(201),n2h32(201))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,2,4,16,1,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,218),heltab2x64(:,:,218))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(202),n2h32(202))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,2,4,16,1,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,219),heltab2x64(:,:,219))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(203),n2h32(203))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,2,4,16,1,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,220),heltab2x64(:,:,220))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(204),n2h32(204))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,2,4,16,1,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,221),heltab2x64(:,:,221))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(205),n2h32(205))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,2,4,16,1,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,222),heltab2x64(:,:,222))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(206),n2h32(206))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,2,4,16,1,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,223),heltab2x64(:,:,223))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(207),n2h32(207))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,2,4,16,1,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,224),heltab2x64(:,:,224))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(208),n2h32(208))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,2,8,1,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,225),heltab2x64(:,:,225))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(209),n2h32(209))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,2,8,1,16,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,226),heltab2x64(:,:,226))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(210),n2h32(210))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,2,8,1,16,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,227),heltab2x64(:,:,227))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(211),n2h32(211))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,2,8,1,16,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,228),heltab2x64(:,:,228))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(212),n2h32(212))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,2,8,1,16,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,229),heltab2x64(:,:,229))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(213),n2h32(213))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,2,8,1,16,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,230),heltab2x64(:,:,230))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(214),n2h32(214))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,2,8,1,16,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,231),heltab2x64(:,:,231))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(215),n2h32(215))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,2,8,1,16,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),ngZl,m3h2x32(:,232),heltab2x64(:,:,232))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(216),n2h32(216))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,2,8,1,16,4],[0,nMW,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,233),heltab2x64(:,:,233))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(217),n2h32(217))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,2,8,1,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,234),heltab2x64(:,:,234))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,2,8,1,16,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,235),heltab2x64(:,:,235))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,2,8,1,16,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(19),ngZl,m3h2x32(:,236),heltab2x64(:,:,236))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,2,8,1,16,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,237),heltab2x64(:,:,237))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,2,8,1,16,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(21),ngZl,m3h2x32(:,238),heltab2x64(:,:,238))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,2,8,1,16,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,239),heltab2x64(:,:,239))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,2,8,1,16,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(23),ngZl,m3h2x32(:,240),heltab2x64(:,:,240))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,2,8,1,16,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(24),ngZl,m3h2x32(:,241),heltab2x64(:,:,241))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,2,8,1,16,4],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,242),heltab2x64(:,:,242))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,2,16,1,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,243),heltab2x64(:,:,243))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,2,16,1,8,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,244),heltab2x64(:,:,244))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,2,16,1,8,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(28),ngZl,m3h2x32(:,245),heltab2x64(:,:,245))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,2,16,1,8,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,246),heltab2x64(:,:,246))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,2,16,1,8,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(30),ngZl,m3h2x32(:,247),heltab2x64(:,:,247))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,2,16,1,8,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,248),heltab2x64(:,:,248))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,2,16,1,8,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(32),ngZl,m3h2x32(:,249),heltab2x64(:,:,249))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,2,16,1,8,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(33),ngZl,m3h2x32(:,250),heltab2x64(:,:,250))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,2,16,1,8,4],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,251),heltab2x64(:,:,251))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,2,16,1,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,252),heltab2x64(:,:,252))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(218),n2h32(218))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,2,16,1,8,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,253),heltab2x64(:,:,253))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(219),n2h32(219))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,2,16,1,8,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,254),heltab2x64(:,:,254))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(220),n2h32(220))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,2,16,1,8,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,255),heltab2x64(:,:,255))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(221),n2h32(221))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,2,16,1,8,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,256),heltab2x64(:,:,256))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(222),n2h32(222))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,2,16,1,8,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,257),heltab2x64(:,:,257))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(223),n2h32(223))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,2,16,1,8,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,258),heltab2x64(:,:,258))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(224),n2h32(224))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,2,16,1,8,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,259),heltab2x64(:,:,259))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(225),n2h32(225))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,2,16,1,8,4],[0,nMW,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,260),heltab2x64(:,:,260))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(226),n2h32(226))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,1,8,2,4,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,261),heltab2x64(:,:,261))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(227),n2h32(227))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,1,8,2,4,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,262),heltab2x64(:,:,262))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(228),n2h32(228))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,1,8,2,4,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,263),heltab2x64(:,:,263))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(229),n2h32(229))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,1,8,2,4,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,264),heltab2x64(:,:,264))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(230),n2h32(230))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[32,1,8,2,4,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,265),heltab2x64(:,:,265))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(231),n2h32(231))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,1,8,2,4,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,266),heltab2x64(:,:,266))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(232),n2h32(232))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,1,8,2,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,267),heltab2x64(:,:,267))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(233),n2h32(233))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,1,8,2,4,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,268),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(234),n2h32(234))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,1,8,4,2,16],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,269),heltab2x64(:,:,269))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(235),n2h32(235))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,1,8,4,2,16],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,270),heltab2x64(:,:,270))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(236),n2h32(236))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,1,8,4,2,16],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,271),heltab2x64(:,:,271))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(237),n2h32(237))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,1,8,4,2,16],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,272),heltab2x64(:,:,272))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(238),n2h32(238))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,1,8,4,2,16],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,273),heltab2x64(:,:,273))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(239),n2h32(239))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,1,8,4,2,16],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,274),heltab2x64(:,:,274))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(240),n2h32(240))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,1,8,4,2,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,275),heltab2x64(:,:,275))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(241),n2h32(241))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,1,8,4,2,16],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(35),ngZl,m3h2x32(:,276),heltab2x64(:,:,276))
  call Hloop_A_Q(ntryL,G0H32(35),32,0,G1H32(242),n2h32(242))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,1,8,16,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,277),heltab2x64(:,:,277))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,1,8,16,2,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,278),heltab2x64(:,:,278))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,1,8,16,2,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,279),heltab2x64(:,:,279))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,1,8,16,2,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(38),ngZl,m3h2x32(:,280),heltab2x64(:,:,280))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,1,8,16,2,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,281),heltab2x64(:,:,281))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,1,8,16,2,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(40),ngZl,m3h2x32(:,282),heltab2x64(:,:,282))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,1,8,16,2,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(41),ngZl,m3h2x32(:,283),heltab2x64(:,:,283))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,1,8,16,2,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(42),ngZl,m3h2x32(:,284),heltab2x64(:,:,284))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,1,8,16,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,285),heltab2x64(:,:,285))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,1,8,16,4,2],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,286),heltab2x64(:,:,286))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,1,8,16,4,2],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,287),heltab2x64(:,:,287))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,1,8,16,4,2],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(46),ngZl,m3h2x32(:,288),heltab2x64(:,:,288))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,1,8,16,4,2],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,289),heltab2x64(:,:,289))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[32,1,8,16,4,2],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(48),ngZl,m3h2x32(:,290),heltab2x64(:,:,290))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[32,1,8,16,4,2],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(49),ngZl,m3h2x32(:,291),heltab2x64(:,:,291))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,1,8,16,4,2],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(50),ngZl,m3h2x32(:,292),heltab2x64(:,:,292))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,1,8,2,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,293),heltab2x64(:,:,293))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,1,8,2,16,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,294),heltab2x64(:,:,294))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,1,8,2,16,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,295),heltab2x64(:,:,295))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,1,8,2,16,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(54),ngZl,m3h2x32(:,296),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,1,8,2,16,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,297),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,1,8,2,16,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(56),ngZl,m3h2x32(:,298),heltab2x64(:,:,298))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[32,1,8,2,16,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(57),ngZl,m3h2x32(:,299),heltab2x64(:,:,299))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,1,8,2,16,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(58),ngZl,m3h2x32(:,300),heltab2x64(:,:,300))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[32,1,8,2,16,4],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,301),heltab2x64(:,:,301))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,1,8,2,16,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,302),heltab2x64(:,:,302))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(243),n2h32(243))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,1,8,2,16,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),ngZl,m3h2x32(:,303),heltab2x64(:,:,303))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(244),n2h32(244))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,1,8,2,16,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,304),heltab2x64(:,:,304))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(245),n2h32(245))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,1,8,2,16,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,305),heltab2x64(:,:,305))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(246),n2h32(246))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,1,8,2,16,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),ngZl,m3h2x32(:,306),heltab2x64(:,:,306))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(247),n2h32(247))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[32,1,8,2,16,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),ngZl,m3h2x32(:,307),heltab2x64(:,:,307))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(248),n2h32(248))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[32,1,8,2,16,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,308),heltab2x64(:,:,308))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(249),n2h32(249))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,1,8,2,16,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),ngZl,m3h2x32(:,309),heltab2x64(:,:,309))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(250),n2h32(250))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,1,8,2,16,4],[0,nMW,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,310),heltab2x64(:,:,310))
  call Hloop_A_Q(ntryL,G0H32(60),32,0,G1H32(251),n2h32(251))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,1,8,4,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,311),heltab2x64(:,:,311))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,1,8,4,16,2],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,312),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,1,8,4,16,2],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,313),heltab2x64(:,:,313))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[32,1,8,4,16,2],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(63),ngZl,m3h2x32(:,314),heltab2x64(:,:,314))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[32,1,8,4,16,2],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,315),heltab2x64(:,:,315))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[32,1,8,4,16,2],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(65),ngZl,m3h2x32(:,316),heltab2x64(:,:,316))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[32,1,8,4,16,2],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(66),ngZl,m3h2x32(:,317),heltab2x64(:,:,317))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[32,1,8,4,16,2],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(67),ngZl,m3h2x32(:,318),heltab2x64(:,:,318))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[32,1,8,4,16,2],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(68),m3h2x32(:,319),heltab2x64(:,:,319))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,1,8,4,16,2],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,320),heltab2x64(:,:,320))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(252),n2h32(252))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,1,8,4,16,2],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,321),heltab2x64(:,:,321))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(253),n2h32(253))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,1,8,4,16,2],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,322),heltab2x64(:,:,322))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(254),n2h32(254))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,1,8,4,16,2],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,323),heltab2x64(:,:,323))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(255),n2h32(255))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,1,8,4,16,2],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,324),heltab2x64(:,:,324))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(256),n2h32(256))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,1,8,4,16,2],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,325),heltab2x64(:,:,325))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(257),n2h32(257))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[32,1,8,4,16,2],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,326),heltab2x64(:,:,326))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(258),n2h32(258))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[32,1,8,4,16,2],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,327),heltab2x64(:,:,327))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(259),n2h32(259))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[32,1,8,4,16,2],[0,nMW,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,328),heltab2x64(:,:,328))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(260),n2h32(260))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[32,1,16,4,2,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,329),heltab2x64(:,:,329))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(261),n2h32(261))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[32,1,16,4,2,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,330),heltab2x64(:,:,330))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(262),n2h32(262))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[32,1,16,4,2,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,331),heltab2x64(:,:,331))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(263),n2h32(263))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[32,1,16,4,2,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,332),heltab2x64(:,:,332))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(264),n2h32(264))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[32,1,16,4,2,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,333),heltab2x64(:,:,333))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(265),n2h32(265))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,1,16,4,2,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,334),heltab2x64(:,:,334))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(266),n2h32(266))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,1,16,4,2,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,335),heltab2x64(:,:,335))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(267),n2h32(267))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,1,16,4,2,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(69),ngZl,m3h2x32(:,336),heltab2x64(:,:,336))
  call Hloop_A_Q(ntryL,G0H32(69),32,0,G1H32(268),n2h32(268))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[32,1,16,8,2,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,337),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[32,1,16,8,2,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,338),heltab2x64(:,:,338))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[32,1,16,8,2,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(71),m3h2x32(:,339),heltab2x64(:,:,339))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[32,1,16,8,2,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(72),ngZl,m3h2x32(:,340),heltab2x64(:,:,340))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[32,1,16,8,2,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(73),m3h2x32(:,341),heltab2x64(:,:,341))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[32,1,16,8,2,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(74),ngZl,m3h2x32(:,342),heltab2x64(:,:,342))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[32,1,16,8,2,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(75),ngZl,m3h2x32(:,343),heltab2x64(:,:,343))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[32,1,16,8,2,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(76),ngZl,m3h2x32(:,344),heltab2x64(:,:,344))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[32,1,16,2,4,8],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,345),heltab2x64(:,:,345))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(269),n2h32(269))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[32,1,16,2,4,8],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),ngZl,m3h2x32(:,346),heltab2x64(:,:,346))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(270),n2h32(270))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[32,1,16,2,4,8],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,347),heltab2x64(:,:,347))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(271),n2h32(271))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[32,1,16,2,4,8],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,348),heltab2x64(:,:,348))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(272),n2h32(272))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,1,16,2,4,8],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),ngZl,m3h2x32(:,349),heltab2x64(:,:,349))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(273),n2h32(273))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,1,16,2,4,8],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),ngZl,m3h2x32(:,350),heltab2x64(:,:,350))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(274),n2h32(274))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[32,1,16,2,4,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,351),heltab2x64(:,:,351))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(275),n2h32(275))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[32,1,16,2,4,8],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(77),ngZl,m3h2x32(:,352),heltab2x64(:,:,352))
  call Hloop_A_Q(ntryL,G0H32(77),32,0,G1H32(276),n2h32(276))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[32,1,16,8,4,2],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,353),heltab2x64(:,:,353))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[32,1,16,8,4,2],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(78),m3h2x32(:,354),heltab2x64(:,:,354))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[32,1,16,8,4,2],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,355),heltab2x64(:,:,355))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[32,1,16,8,4,2],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(80),ngZl,m3h2x32(:,356),heltab2x64(:,:,356))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[32,1,16,8,4,2],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,357),heltab2x64(:,:,357))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[32,1,16,8,4,2],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(82),ngZl,m3h2x32(:,358),heltab2x64(:,:,358))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[32,1,16,8,4,2],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(83),ngZl,m3h2x32(:,359),heltab2x64(:,:,359))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[32,1,16,8,4,2],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(84),ngZl,m3h2x32(:,360),heltab2x64(:,:,360))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[32,1,16,2,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,361),heltab2x64(:,:,361))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[32,1,16,2,8,4],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,362),heltab2x64(:,:,362))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[32,1,16,2,8,4],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(87),m3h2x32(:,363),heltab2x64(:,:,363))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[32,1,16,2,8,4],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(88),ngZl,m3h2x32(:,364),heltab2x64(:,:,364))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[32,1,16,2,8,4],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(89),m3h2x32(:,365),heltab2x64(:,:,365))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[32,1,16,2,8,4],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(90),ngZl,m3h2x32(:,366),heltab2x64(:,:,366))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[32,1,16,2,8,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(91),ngZl,m3h2x32(:,367),heltab2x64(:,:,367))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[32,1,16,2,8,4],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(92),ngZl,m3h2x32(:,368),heltab2x64(:,:,368))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,1,16,2,8,4],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(93),m3h2x32(:,369),heltab2x64(:,:,369))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,1,16,2,8,4],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,370),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(277),n2h32(277))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[32,1,16,2,8,4],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),ngZl,m3h2x32(:,371),heltab2x64(:,:,371))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(278),n2h32(278))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[32,1,16,2,8,4],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,372),heltab2x64(:,:,372))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(279),n2h32(279))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[32,1,16,2,8,4],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,373),heltab2x64(:,:,373))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(280),n2h32(280))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[32,1,16,2,8,4],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),ngZl,m3h2x32(:,374),heltab2x64(:,:,374))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(281),n2h32(281))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,1,16,2,8,4],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),ngZl,m3h2x32(:,375),heltab2x64(:,:,375))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(282),n2h32(282))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,1,16,2,8,4],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,376),heltab2x64(:,:,376))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(283),n2h32(283))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[32,1,16,2,8,4],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),ngZl,m3h2x32(:,377),heltab2x64(:,:,377))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(284),n2h32(284))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[32,1,16,2,8,4],[0,nMW,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,378),heltab2x64(:,:,378))
  call Hloop_A_Q(ntryL,G0H32(94),32,0,G1H32(285),n2h32(285))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[32,1,16,4,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,379),heltab2x64(:,:,379))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[32,1,16,4,8,2],[0,0,nMZ,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(95),m3h2x32(:,380),heltab2x64(:,:,380))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[32,1,16,4,8,2],[0,0,0,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(96),m3h2x32(:,381),heltab2x64(:,:,381))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[32,1,16,4,8,2],[nMZ,0,0,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(97),ngZl,m3h2x32(:,382),heltab2x64(:,:,382))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[32,1,16,4,8,2],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(98),m3h2x32(:,383),heltab2x64(:,:,383))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[32,1,16,4,8,2],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(99),ngZl,m3h2x32(:,384),heltab2x64(:,:,384))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[32,1,16,4,8,2],[nMZ,0,0,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(100),ngZl,m3h2x32(:,385),heltab2x64(:,:,385))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[32,1,16,4,8,2],[nMZ,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(101),ngZl,m3h2x32(:,386),heltab2x64(:,:,386))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[32,1,16,4,8,2],[nMW,0,nMW,0,nMW,0],6,0)
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,387),heltab2x64(:,:,387))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[32,1,16,4,8,2],[0,0,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,388),heltab2x64(:,:,388))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(286),n2h32(286))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[32,1,16,4,8,2],[0,0,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,389),heltab2x64(:,:,389))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(287),n2h32(287))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[32,1,16,4,8,2],[0,0,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),ngZl,m3h2x32(:,390),heltab2x64(:,:,390))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(288),n2h32(288))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[32,1,16,4,8,2],[0,nMZ,0,0,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,391),heltab2x64(:,:,391))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(289),n2h32(289))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[32,1,16,4,8,2],[0,0,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),ngZl,m3h2x32(:,392),heltab2x64(:,:,392))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(290),n2h32(290))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[32,1,16,4,8,2],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,393),heltab2x64(:,:,393))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(291),n2h32(291))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[32,1,16,4,8,2],[0,nMZ,0,0,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),ngZl,m3h2x32(:,394),heltab2x64(:,:,394))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(292),n2h32(292))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[32,1,16,4,8,2],[0,nMZ,0,nMZ,0,nMZ],6,0)
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),ngZl,m3h2x32(:,395),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(293),n2h32(293))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[32,1,16,4,8,2],[0,nMW,0,nMW,0,nMW],6,0)
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,396),heltab2x64(:,:,396))
  call Hloop_A_Q(ntryL,G0H32(103),32,0,G1H32(294),n2h32(294))
  call Hloop_AQ_V(ntryL,G1H32(1),ex3(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_V(ntryL,G1H32(2),ex3(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H32(3),ex3(:),G1H16(3),ngZl,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_V(ntryL,G1H32(4),ex3(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AQ_Z(ntryL,G1H32(5),ex3(:),G1H16(5),ngZl,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_AQ_V(ntryL,G1H32(6),ex3(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H32(7),ex3(:),G1H16(7),ngZl,m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H32(8),ex3(:),G1H16(8),ngZl,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_AQ_V(ntryL,G1H32(9),ex3(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_AQ_V(ntryL,G1H32(10),ex3(:),G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H32(11),ex3(:),G1H16(11),ngZl,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_AQ_V(ntryL,G1H32(12),ex3(:),G1H16(12),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H32(13),ex3(:),G1H16(13),ngZl,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_AQ_V(ntryL,G1H32(14),ex3(:),G1H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_AQ_Z(ntryL,G1H32(15),ex3(:),G1H16(15),ngZl,m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H32(16),ex3(:),G1H16(16),ngZl,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_AQ_V(ntryL,G1H32(17),ex2(:),G1H16(17),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_AQ_V(ntryL,G1H32(18),ex2(:),G1H16(18),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_V(ntryL,G1H32(19),ex2(:),G1H16(19),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_Z(ntryL,G1H32(20),ex2(:),G1H16(20),ngZl,m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_AQ_V(ntryL,G1H32(21),ex2(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H32(22),ex2(:),G1H16(22),ngZl,m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_Z(ntryL,G1H32(23),ex2(:),G1H16(23),ngZl,m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H32(24),ex2(:),G1H16(24),ngZl,m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_AQ_V(ntryL,G1H32(25),ex2(:),G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_AQ_V(ntryL,G1H32(26),ex2(:),G1H16(26),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_AQ_V(ntryL,G1H32(27),ex2(:),G1H16(27),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H32(28),ex2(:),G1H16(28),ngZl,m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_AQ_V(ntryL,G1H32(29),ex2(:),G1H16(29),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H32(30),ex2(:),G1H16(30),ngZl,m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H32(31),ex2(:),G1H16(31),ngZl,m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H32(32),ex2(:),G1H16(32),ngZl,m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_AQ_V(ntryL,G1H32(33),ex3(:),G1H16(33),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_AQ_V(ntryL,G1H32(34),ex3(:),G1H16(34),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H32(35),ex3(:),G1H16(35),ngZl,m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntryL,G1H32(36),ex3(:),G1H16(36),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H32(37),ex3(:),G1H16(37),ngZl,m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_AQ_V(ntryL,G1H32(38),ex3(:),G1H16(38),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H32(39),ex3(:),G1H16(39),ngZl,m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_AQ_Z(ntryL,G1H32(40),ex3(:),G1H16(40),ngZl,m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_AQ_V(ntryL,G1H32(41),ex3(:),G1H16(41),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_AQ_V(ntryL,G1H32(42),ex3(:),G1H16(42),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_AQ_Z(ntryL,G1H32(43),ex3(:),G1H16(43),ngZl,m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_AQ_V(ntryL,G1H32(44),ex3(:),G1H16(44),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_AQ_Z(ntryL,G1H32(45),ex3(:),G1H16(45),ngZl,m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_AQ_V(ntryL,G1H32(46),ex3(:),G1H16(46),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_AQ_Z(ntryL,G1H32(47),ex3(:),G1H16(47),ngZl,m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H32(48),ex3(:),G1H16(48),ngZl,m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_AQ_V(ntryL,G1H32(49),ex2(:),G1H16(49),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_AQ_V(ntryL,G1H32(50),ex2(:),G1H16(50),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_AQ_V(ntryL,G1H32(51),ex2(:),G1H16(51),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_AQ_Z(ntryL,G1H32(52),ex2(:),G1H16(52),ngZl,m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_AQ_V(ntryL,G1H32(53),ex2(:),G1H16(53),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H32(54),ex2(:),G1H16(54),ngZl,m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_AQ_Z(ntryL,G1H32(55),ex2(:),G1H16(55),ngZl,m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H32(56),ex2(:),G1H16(56),ngZl,m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_AQ_V(ntryL,G1H32(57),ex2(:),G1H16(57),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_AQ_V(ntryL,G1H32(58),ex2(:),G1H16(58),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_AQ_V(ntryL,G1H32(59),ex2(:),G1H16(59),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_AQ_Z(ntryL,G1H32(60),ex2(:),G1H16(60),ngZl,m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_AQ_V(ntryL,G1H32(61),ex2(:),G1H16(61),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_AQ_Z(ntryL,G1H32(62),ex2(:),G1H16(62),ngZl,m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_AQ_Z(ntryL,G1H32(63),ex2(:),G1H16(63),ngZl,m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_AQ_Z(ntryL,G1H32(64),ex2(:),G1H16(64),ngZl,m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_AQ_V(ntryL,G1H32(65),ex1(:),G1H16(65),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_AQ_V(ntryL,G1H32(66),ex1(:),G1H16(66),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_AQ_V(ntryL,G1H32(67),ex1(:),G1H16(67),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_AQ_Z(ntryL,G1H32(68),ex1(:),G1H16(68),ngZl,m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_AQ_V(ntryL,G1H32(69),ex1(:),G1H16(69),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_AQ_Z(ntryL,G1H32(70),ex1(:),G1H16(70),ngZl,m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_AQ_Z(ntryL,G1H32(71),ex1(:),G1H16(71),ngZl,m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_AQ_Z(ntryL,G1H32(72),ex1(:),G1H16(72),ngZl,m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_AQ_V(ntryL,G1H32(73),ex1(:),G1H16(73),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_AQ_V(ntryL,G1H32(74),ex1(:),G1H16(74),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_AQ_V(ntryL,G1H32(75),ex1(:),G1H16(75),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_AQ_Z(ntryL,G1H32(76),ex1(:),G1H16(76),ngZl,m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_AQ_V(ntryL,G1H32(77),ex1(:),G1H16(77),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_AQ_Z(ntryL,G1H32(78),ex1(:),G1H16(78),ngZl,m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_AQ_Z(ntryL,G1H32(79),ex1(:),G1H16(79),ngZl,m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_AQ_Z(ntryL,G1H32(80),ex1(:),G1H16(80),ngZl,m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_AQ_V(ntryL,G1H32(81),ex1(:),G1H16(81),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_AQ_V(ntryL,G1H32(82),ex1(:),G1H16(82),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_AQ_V(ntryL,G1H32(83),ex1(:),G1H16(83),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_AQ_Z(ntryL,G1H32(84),ex1(:),G1H16(84),ngZl,m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_AQ_V(ntryL,G1H32(85),ex1(:),G1H16(85),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_AQ_Z(ntryL,G1H32(86),ex1(:),G1H16(86),ngZl,m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H32(87),ex1(:),G1H16(87),ngZl,m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_AQ_Z(ntryL,G1H32(88),ex1(:),G1H16(88),ngZl,m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_AQ_V(ntryL,G1H32(89),ex1(:),G1H16(89),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_AQ_V(ntryL,G1H32(90),ex1(:),G1H16(90),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_AQ_V(ntryL,G1H32(91),ex1(:),G1H16(91),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_AQ_Z(ntryL,G1H32(92),ex1(:),G1H16(92),ngZl,m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_AQ_V(ntryL,G1H32(93),ex1(:),G1H16(93),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H32(94),ex1(:),G1H16(94),ngZl,m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_AQ_Z(ntryL,G1H32(95),ex1(:),G1H16(95),ngZl,m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_AQ_Z(ntryL,G1H32(96),ex1(:),G1H16(96),ngZl,m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_AQ_V(ntryL,G1H32(97),ex3(:),G1H16(97),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_AQ_V(ntryL,G1H32(98),ex3(:),G1H16(98),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_AQ_V(ntryL,G1H32(99),ex3(:),G1H16(99),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_AQ_Z(ntryL,G1H32(100),ex3(:),G1H16(100),ngZl,m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_AQ_V(ntryL,G1H32(101),ex3(:),G1H16(101),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H32(102),ex3(:),G1H16(102),ngZl,m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_AQ_Z(ntryL,G1H32(103),ex3(:),G1H16(103),ngZl,m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_AQ_Z(ntryL,G1H32(104),ex3(:),G1H16(104),ngZl,m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_AQ_V(ntryL,G1H32(105),ex2(:),G1H16(105),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_AQ_V(ntryL,G1H32(106),ex2(:),G1H16(106),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_AQ_Z(ntryL,G1H32(107),ex2(:),G1H16(107),ngZl,m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_AQ_V(ntryL,G1H32(108),ex2(:),G1H16(108),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_AQ_Z(ntryL,G1H32(109),ex2(:),G1H16(109),ngZl,m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_AQ_V(ntryL,G1H32(110),ex2(:),G1H16(110),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_AQ_Z(ntryL,G1H32(111),ex2(:),G1H16(111),ngZl,m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_AQ_Z(ntryL,G1H32(112),ex2(:),G1H16(112),ngZl,m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_AQ_V(ntryL,G1H32(113),ex2(:),G1H16(113),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_AQ_V(ntryL,G1H32(114),ex2(:),G1H16(114),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_AQ_Z(ntryL,G1H32(115),ex2(:),G1H16(115),ngZl,m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_AQ_V(ntryL,G1H32(116),ex2(:),G1H16(116),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_AQ_Z(ntryL,G1H32(117),ex2(:),G1H16(117),ngZl,m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_AQ_V(ntryL,G1H32(118),ex2(:),G1H16(118),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_AQ_Z(ntryL,G1H32(119),ex2(:),G1H16(119),ngZl,m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_AQ_Z(ntryL,G1H32(120),ex2(:),G1H16(120),ngZl,m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_VQ_A(ntryL,G0H32(1),ex2(:),G0H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(121),n2h16(1))
  call Hloop_VQ_A(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(122),n2h16(2))
  call Hloop_ZQ_A(ntryL,G0H32(3),ex2(:),G0H16(1),ngZl,m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(123),n2h16(3))
  call Hloop_VQ_A(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(124),n2h16(4))
  call Hloop_ZQ_A(ntryL,G0H32(5),ex2(:),G0H16(1),ngZl,m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(125),n2h16(5))
  call Hloop_VQ_A(ntryL,G0H32(6),ex2(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(126),n2h16(6))
  call Hloop_ZQ_A(ntryL,G0H32(7),ex2(:),G0H16(1),ngZl,m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(127),n2h16(7))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex2(:),G0H16(1),ngZl,m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(128),n2h16(8))
  call Hloop_AQ_V(ntryL,G1H32(121),ex3(:),G1H16(129),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_AQ_V(ntryL,G1H32(122),ex3(:),G1H16(130),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_AQ_V(ntryL,G1H32(123),ex3(:),G1H16(131),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_AQ_Z(ntryL,G1H32(124),ex3(:),G1H16(132),ngZl,m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_AQ_V(ntryL,G1H32(125),ex3(:),G1H16(133),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_AQ_Z(ntryL,G1H32(126),ex3(:),G1H16(134),ngZl,m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H32(127),ex3(:),G1H16(135),ngZl,m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_AQ_Z(ntryL,G1H32(128),ex3(:),G1H16(136),ngZl,m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_AQ_V(ntryL,G1H32(129),ex2(:),G1H16(137),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_AQ_V(ntryL,G1H32(130),ex2(:),G1H16(138),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_AQ_Z(ntryL,G1H32(131),ex2(:),G1H16(139),ngZl,m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_AQ_V(ntryL,G1H32(132),ex2(:),G1H16(140),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_AQ_Z(ntryL,G1H32(133),ex2(:),G1H16(141),ngZl,m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_AQ_V(ntryL,G1H32(134),ex2(:),G1H16(142),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_AQ_Z(ntryL,G1H32(135),ex2(:),G1H16(143),ngZl,m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_AQ_Z(ntryL,G1H32(136),ex2(:),G1H16(144),ngZl,m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_VQ_A(ntryL,G0H32(9),ex2(:),G0H16(1),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(145),n2h16(9))
  call Hloop_VQ_A(ntryL,G0H32(10),ex2(:),G0H16(1),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(146),n2h16(10))
  call Hloop_ZQ_A(ntryL,G0H32(11),ex2(:),G0H16(1),ngZl,m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(147),n2h16(11))
  call Hloop_VQ_A(ntryL,G0H32(12),ex2(:),G0H16(1),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(148),n2h16(12))
  call Hloop_ZQ_A(ntryL,G0H32(13),ex2(:),G0H16(1),ngZl,m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(149),n2h16(13))
  call Hloop_VQ_A(ntryL,G0H32(14),ex2(:),G0H16(1),m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(150),n2h16(14))
  call Hloop_ZQ_A(ntryL,G0H32(15),ex2(:),G0H16(1),ngZl,m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(151),n2h16(15))
  call Hloop_ZQ_A(ntryL,G0H32(16),ex2(:),G0H16(1),ngZl,m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(152),n2h16(16))
  call Hloop_AQ_V(ntryL,G1H32(137),ex2(:),G1H16(153),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_AQ_V(ntryL,G1H32(138),ex2(:),G1H16(154),m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_AQ_Z(ntryL,G1H32(139),ex2(:),G1H16(155),ngZl,m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_AQ_V(ntryL,G1H32(140),ex2(:),G1H16(156),m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_AQ_Z(ntryL,G1H32(141),ex2(:),G1H16(157),ngZl,m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_AQ_V(ntryL,G1H32(142),ex2(:),G1H16(158),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_AQ_Z(ntryL,G1H32(143),ex2(:),G1H16(159),ngZl,m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_AQ_Z(ntryL,G1H32(144),ex2(:),G1H16(160),ngZl,m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_AQ_V(ntryL,G1H32(145),ex1(:),G1H16(161),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_AQ_V(ntryL,G1H32(146),ex1(:),G1H16(162),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_AQ_V(ntryL,G1H32(147),ex1(:),G1H16(163),m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_AQ_Z(ntryL,G1H32(148),ex1(:),G1H16(164),ngZl,m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_AQ_V(ntryL,G1H32(149),ex1(:),G1H16(165),m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_AQ_Z(ntryL,G1H32(150),ex1(:),G1H16(166),ngZl,m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_AQ_Z(ntryL,G1H32(151),ex1(:),G1H16(167),ngZl,m3h2x16(:,167),heltab2x32(:,:,167))
  call Hloop_AQ_Z(ntryL,G1H32(152),ex1(:),G1H16(168),ngZl,m3h2x16(:,168),heltab2x32(:,:,168))
  call Hloop_AQ_V(ntryL,G1H32(153),ex1(:),G1H16(169),m3h2x16(:,169),heltab2x32(:,:,169))
  call Hloop_AQ_V(ntryL,G1H32(154),ex1(:),G1H16(170),m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_AQ_V(ntryL,G1H32(155),ex1(:),G1H16(171),m3h2x16(:,171),heltab2x32(:,:,171))
  call Hloop_AQ_Z(ntryL,G1H32(156),ex1(:),G1H16(172),ngZl,m3h2x16(:,172),heltab2x32(:,:,172))
  call Hloop_AQ_V(ntryL,G1H32(157),ex1(:),G1H16(173),m3h2x16(:,173),heltab2x32(:,:,173))
  call Hloop_AQ_Z(ntryL,G1H32(158),ex1(:),G1H16(174),ngZl,m3h2x16(:,174),heltab2x32(:,:,174))
  call Hloop_AQ_Z(ntryL,G1H32(159),ex1(:),G1H16(175),ngZl,m3h2x16(:,175),heltab2x32(:,:,175))
  call Hloop_AQ_Z(ntryL,G1H32(160),ex1(:),G1H16(176),ngZl,m3h2x16(:,176),heltab2x32(:,:,176))
  call Hloop_AQ_V(ntryL,G1H32(161),ex1(:),G1H16(177),m3h2x16(:,177),heltab2x32(:,:,177))
  call Hloop_AQ_V(ntryL,G1H32(162),ex1(:),G1H16(178),m3h2x16(:,178),heltab2x32(:,:,178))
  call Hloop_AQ_V(ntryL,G1H32(163),ex1(:),G1H16(179),m3h2x16(:,179),heltab2x32(:,:,179))
  call Hloop_AQ_Z(ntryL,G1H32(164),ex1(:),G1H16(180),ngZl,m3h2x16(:,180),heltab2x32(:,:,180))
  call Hloop_AQ_V(ntryL,G1H32(165),ex1(:),G1H16(181),m3h2x16(:,181),heltab2x32(:,:,181))
  call Hloop_AQ_Z(ntryL,G1H32(166),ex1(:),G1H16(182),ngZl,m3h2x16(:,182),heltab2x32(:,:,182))
  call Hloop_AQ_Z(ntryL,G1H32(167),ex1(:),G1H16(183),ngZl,m3h2x16(:,183),heltab2x32(:,:,183))
  call Hloop_AQ_Z(ntryL,G1H32(168),ex1(:),G1H16(184),ngZl,m3h2x16(:,184),heltab2x32(:,:,184))
  call Hloop_AQ_V(ntryL,G1H32(169),ex1(:),G1H16(185),m3h2x16(:,185),heltab2x32(:,:,185))
  call Hloop_AQ_V(ntryL,G1H32(170),ex1(:),G1H16(186),m3h2x16(:,186),heltab2x32(:,:,186))
  call Hloop_AQ_V(ntryL,G1H32(171),ex1(:),G1H16(187),m3h2x16(:,187),heltab2x32(:,:,187))
  call Hloop_AQ_Z(ntryL,G1H32(172),ex1(:),G1H16(188),ngZl,m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_AQ_V(ntryL,G1H32(173),ex1(:),G1H16(189),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_AQ_Z(ntryL,G1H32(174),ex1(:),G1H16(190),ngZl,m3h2x16(:,190),heltab2x32(:,:,190))
  call Hloop_AQ_Z(ntryL,G1H32(175),ex1(:),G1H16(191),ngZl,m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_AQ_Z(ntryL,G1H32(176),ex1(:),G1H16(192),ngZl,m3h2x16(:,192),heltab2x32(:,:,192))
  call Hloop_AQ_V(ntryL,G1H32(177),ex3(:),G1H16(193),m3h2x16(:,193),heltab2x32(:,:,193))
  call Hloop_AQ_V(ntryL,G1H32(178),ex3(:),G1H16(194),m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_AQ_Z(ntryL,G1H32(179),ex3(:),G1H16(195),ngZl,m3h2x16(:,195),heltab2x32(:,:,195))
  call Hloop_AQ_V(ntryL,G1H32(180),ex3(:),G1H16(196),m3h2x16(:,196),heltab2x32(:,:,196))
  call Hloop_AQ_Z(ntryL,G1H32(181),ex3(:),G1H16(197),ngZl,m3h2x16(:,197),heltab2x32(:,:,197))
  call Hloop_AQ_V(ntryL,G1H32(182),ex3(:),G1H16(198),m3h2x16(:,198),heltab2x32(:,:,198))
  call Hloop_AQ_Z(ntryL,G1H32(183),ex3(:),G1H16(199),ngZl,m3h2x16(:,199),heltab2x32(:,:,199))
  call Hloop_AQ_Z(ntryL,G1H32(184),ex3(:),G1H16(200),ngZl,m3h2x16(:,200),heltab2x32(:,:,200))
  call Hloop_AQ_V(ntryL,G1H32(185),ex3(:),G1H16(201),m3h2x16(:,201),heltab2x32(:,:,201))
  call Hloop_AQ_V(ntryL,G1H32(186),ex3(:),G1H16(202),m3h2x16(:,202),heltab2x32(:,:,202))
  call Hloop_AQ_Z(ntryL,G1H32(187),ex3(:),G1H16(203),ngZl,m3h2x16(:,203),heltab2x32(:,:,203))
  call Hloop_AQ_V(ntryL,G1H32(188),ex3(:),G1H16(204),m3h2x16(:,204),heltab2x32(:,:,204))
  call Hloop_AQ_Z(ntryL,G1H32(189),ex3(:),G1H16(205),ngZl,m3h2x16(:,205),heltab2x32(:,:,205))
  call Hloop_AQ_V(ntryL,G1H32(190),ex3(:),G1H16(206),m3h2x16(:,206),heltab2x32(:,:,206))
  call Hloop_AQ_Z(ntryL,G1H32(191),ex3(:),G1H16(207),ngZl,m3h2x16(:,207),heltab2x32(:,:,207))
  call Hloop_AQ_Z(ntryL,G1H32(192),ex3(:),G1H16(208),ngZl,m3h2x16(:,208),heltab2x32(:,:,208))
  call Hloop_AQ_V(ntryL,G1H32(193),ex2(:),G1H16(209),m3h2x16(:,209),heltab2x32(:,:,209))
  call Hloop_AQ_V(ntryL,G1H32(194),ex2(:),G1H16(210),m3h2x16(:,210),heltab2x32(:,:,210))
  call Hloop_AQ_Z(ntryL,G1H32(195),ex2(:),G1H16(211),ngZl,m3h2x16(:,211),heltab2x32(:,:,211))
  call Hloop_AQ_V(ntryL,G1H32(196),ex2(:),G1H16(212),m3h2x16(:,212),heltab2x32(:,:,212))
  call Hloop_AQ_Z(ntryL,G1H32(197),ex2(:),G1H16(213),ngZl,m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_AQ_V(ntryL,G1H32(198),ex2(:),G1H16(214),m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_AQ_Z(ntryL,G1H32(199),ex2(:),G1H16(215),ngZl,m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_AQ_Z(ntryL,G1H32(200),ex2(:),G1H16(216),ngZl,m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_AQ_V(ntryL,G1H32(201),ex2(:),G1H16(217),m3h2x16(:,217),heltab2x32(:,:,217))
  call Hloop_AQ_V(ntryL,G1H32(202),ex2(:),G1H16(218),m3h2x16(:,218),heltab2x32(:,:,218))
  call Hloop_AQ_Z(ntryL,G1H32(203),ex2(:),G1H16(219),ngZl,m3h2x16(:,219),heltab2x32(:,:,219))
  call Hloop_AQ_V(ntryL,G1H32(204),ex2(:),G1H16(220),m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_AQ_Z(ntryL,G1H32(205),ex2(:),G1H16(221),ngZl,m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_AQ_V(ntryL,G1H32(206),ex2(:),G1H16(222),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_AQ_Z(ntryL,G1H32(207),ex2(:),G1H16(223),ngZl,m3h2x16(:,223),heltab2x32(:,:,223))
  call Hloop_AQ_Z(ntryL,G1H32(208),ex2(:),G1H16(224),ngZl,m3h2x16(:,224),heltab2x32(:,:,224))
  call Hloop_AQ_V(ntryL,G1H32(209),ex2(:),G1H16(225),m3h2x16(:,225),heltab2x32(:,:,225))
  call Hloop_AQ_V(ntryL,G1H32(210),ex2(:),G1H16(226),m3h2x16(:,226),heltab2x32(:,:,226))
  call Hloop_AQ_Z(ntryL,G1H32(211),ex2(:),G1H16(227),ngZl,m3h2x16(:,227),heltab2x32(:,:,227))
  call Hloop_AQ_V(ntryL,G1H32(212),ex2(:),G1H16(228),m3h2x16(:,228),heltab2x32(:,:,228))
  call Hloop_AQ_Z(ntryL,G1H32(213),ex2(:),G1H16(229),ngZl,m3h2x16(:,229),heltab2x32(:,:,229))
  call Hloop_AQ_V(ntryL,G1H32(214),ex2(:),G1H16(230),m3h2x16(:,230),heltab2x32(:,:,230))
  call Hloop_AQ_Z(ntryL,G1H32(215),ex2(:),G1H16(231),ngZl,m3h2x16(:,231),heltab2x32(:,:,231))
  call Hloop_AQ_Z(ntryL,G1H32(216),ex2(:),G1H16(232),ngZl,m3h2x16(:,232),heltab2x32(:,:,232))
  call Hloop_AQ_W(ntryL,G1H32(217),ex2(:),G1H16(233),m3h2x16(:,233),heltab2x32(:,:,233))
  call Hloop_VQ_A(ntryL,G0H32(17),ex2(:),G0H16(1),m3h2x16(:,234),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(234),n2h16(17))
  call Hloop_VQ_A(ntryL,G0H32(18),ex2(:),G0H16(1),m3h2x16(:,235),heltab2x32(:,:,235))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(235),n2h16(18))
  call Hloop_ZQ_A(ntryL,G0H32(19),ex2(:),G0H16(1),ngZl,m3h2x16(:,236),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(236),n2h16(19))
  call Hloop_VQ_A(ntryL,G0H32(20),ex2(:),G0H16(1),m3h2x16(:,237),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(237),n2h16(20))
  call Hloop_ZQ_A(ntryL,G0H32(21),ex2(:),G0H16(1),ngZl,m3h2x16(:,238),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(238),n2h16(21))
  call Hloop_VQ_A(ntryL,G0H32(22),ex2(:),G0H16(1),m3h2x16(:,239),heltab2x32(:,:,239))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(239),n2h16(22))
  call Hloop_ZQ_A(ntryL,G0H32(23),ex2(:),G0H16(1),ngZl,m3h2x16(:,240),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(240),n2h16(23))
  call Hloop_ZQ_A(ntryL,G0H32(24),ex2(:),G0H16(1),ngZl,m3h2x16(:,241),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(241),n2h16(24))
  call Hloop_WQ_A(ntryL,G0H32(25),ex2(:),G0H16(1),m3h2x16(:,242),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(242),n2h16(25))
  call Hloop_VQ_A(ntryL,G0H32(26),ex2(:),G0H16(1),m3h2x16(:,243),heltab2x32(:,:,243))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(243),n2h16(26))
  call Hloop_VQ_A(ntryL,G0H32(27),ex2(:),G0H16(1),m3h2x16(:,244),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(244),n2h16(27))
  call Hloop_ZQ_A(ntryL,G0H32(28),ex2(:),G0H16(1),ngZl,m3h2x16(:,245),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(245),n2h16(28))
  call Hloop_VQ_A(ntryL,G0H32(29),ex2(:),G0H16(1),m3h2x16(:,246),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(246),n2h16(29))
  call Hloop_ZQ_A(ntryL,G0H32(30),ex2(:),G0H16(1),ngZl,m3h2x16(:,247),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(247),n2h16(30))
  call Hloop_VQ_A(ntryL,G0H32(31),ex2(:),G0H16(1),m3h2x16(:,248),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(248),n2h16(31))
  call Hloop_ZQ_A(ntryL,G0H32(32),ex2(:),G0H16(1),ngZl,m3h2x16(:,249),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(249),n2h16(32))
  call Hloop_ZQ_A(ntryL,G0H32(33),ex2(:),G0H16(1),ngZl,m3h2x16(:,250),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(250),n2h16(33))
  call Hloop_WQ_A(ntryL,G0H32(34),ex2(:),G0H16(1),m3h2x16(:,251),heltab2x32(:,:,251))
  call Hloop_Q_A(ntryL,G0H16(1),34,0,G1H16(251),n2h16(34))
  call Hloop_AQ_V(ntryL,G1H32(218),ex2(:),G1H16(252),m3h2x16(:,252),heltab2x32(:,:,252))
  call Hloop_AQ_V(ntryL,G1H32(219),ex2(:),G1H16(253),m3h2x16(:,253),heltab2x32(:,:,253))
  call Hloop_AQ_Z(ntryL,G1H32(220),ex2(:),G1H16(254),ngZl,m3h2x16(:,254),heltab2x32(:,:,254))
  call Hloop_AQ_V(ntryL,G1H32(221),ex2(:),G1H16(255),m3h2x16(:,255),heltab2x32(:,:,255))
  call Hloop_AQ_Z(ntryL,G1H32(222),ex2(:),G1H16(256),ngZl,m3h2x16(:,256),heltab2x32(:,:,256))
  call Hloop_AQ_V(ntryL,G1H32(223),ex2(:),G1H16(257),m3h2x16(:,257),heltab2x32(:,:,257))
  call Hloop_AQ_Z(ntryL,G1H32(224),ex2(:),G1H16(258),ngZl,m3h2x16(:,258),heltab2x32(:,:,258))
  call Hloop_AQ_Z(ntryL,G1H32(225),ex2(:),G1H16(259),ngZl,m3h2x16(:,259),heltab2x32(:,:,259))
  call Hloop_AQ_W(ntryL,G1H32(226),ex2(:),G1H16(260),m3h2x16(:,260),heltab2x32(:,:,260))
  call Hloop_AQ_V(ntryL,G1H32(227),ex1(:),G1H16(261),m3h2x16(:,261),heltab2x32(:,:,261))
  call Hloop_AQ_V(ntryL,G1H32(228),ex1(:),G1H16(262),m3h2x16(:,262),heltab2x32(:,:,262))
  call Hloop_AQ_V(ntryL,G1H32(229),ex1(:),G1H16(263),m3h2x16(:,263),heltab2x32(:,:,263))
  call Hloop_AQ_Z(ntryL,G1H32(230),ex1(:),G1H16(264),ngZl,m3h2x16(:,264),heltab2x32(:,:,264))
  call Hloop_AQ_V(ntryL,G1H32(231),ex1(:),G1H16(265),m3h2x16(:,265),heltab2x32(:,:,265))
  call Hloop_AQ_Z(ntryL,G1H32(232),ex1(:),G1H16(266),ngZl,m3h2x16(:,266),heltab2x32(:,:,266))
  call Hloop_AQ_Z(ntryL,G1H32(233),ex1(:),G1H16(267),ngZl,m3h2x16(:,267),heltab2x32(:,:,267))
  call Hloop_AQ_Z(ntryL,G1H32(234),ex1(:),G1H16(268),ngZl,m3h2x16(:,268),heltab2x32(:,:,268))
  call Hloop_AQ_V(ntryL,G1H32(235),ex1(:),G1H16(269),m3h2x16(:,269),heltab2x32(:,:,269))
  call Hloop_AQ_V(ntryL,G1H32(236),ex1(:),G1H16(270),m3h2x16(:,270),heltab2x32(:,:,270))
  call Hloop_AQ_V(ntryL,G1H32(237),ex1(:),G1H16(271),m3h2x16(:,271),heltab2x32(:,:,271))
  call Hloop_AQ_Z(ntryL,G1H32(238),ex1(:),G1H16(272),ngZl,m3h2x16(:,272),heltab2x32(:,:,272))
  call Hloop_AQ_V(ntryL,G1H32(239),ex1(:),G1H16(273),m3h2x16(:,273),heltab2x32(:,:,273))
  call Hloop_AQ_Z(ntryL,G1H32(240),ex1(:),G1H16(274),ngZl,m3h2x16(:,274),heltab2x32(:,:,274))
  call Hloop_AQ_Z(ntryL,G1H32(241),ex1(:),G1H16(275),ngZl,m3h2x16(:,275),heltab2x32(:,:,275))
  call Hloop_AQ_Z(ntryL,G1H32(242),ex1(:),G1H16(276),ngZl,m3h2x16(:,276),heltab2x32(:,:,276))
  call Hloop_VQ_A(ntryL,G0H32(35),ex1(:),G0H16(1),m3h2x16(:,277),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(277),n2h16(35))
  call Hloop_VQ_A(ntryL,G0H32(36),ex1(:),G0H16(1),m3h2x16(:,278),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(278),n2h16(36))
  call Hloop_VQ_A(ntryL,G0H32(37),ex1(:),G0H16(1),m3h2x16(:,279),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(279),n2h16(37))
  call Hloop_ZQ_A(ntryL,G0H32(38),ex1(:),G0H16(1),ngZl,m3h2x16(:,280),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(280),n2h16(38))
  call Hloop_VQ_A(ntryL,G0H32(39),ex1(:),G0H16(1),m3h2x16(:,281),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(281),n2h16(39))
  call Hloop_ZQ_A(ntryL,G0H32(40),ex1(:),G0H16(1),ngZl,m3h2x16(:,282),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(282),n2h16(40))
  call Hloop_ZQ_A(ntryL,G0H32(41),ex1(:),G0H16(1),ngZl,m3h2x16(:,283),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(283),n2h16(41))
  call Hloop_ZQ_A(ntryL,G0H32(42),ex1(:),G0H16(1),ngZl,m3h2x16(:,284),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(284),n2h16(42))
  call Hloop_VQ_A(ntryL,G0H32(43),ex1(:),G0H16(1),m3h2x16(:,285),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(285),n2h16(43))
  call Hloop_VQ_A(ntryL,G0H32(44),ex1(:),G0H16(1),m3h2x16(:,286),heltab2x32(:,:,286))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(286),n2h16(44))
  call Hloop_VQ_A(ntryL,G0H32(45),ex1(:),G0H16(1),m3h2x16(:,287),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(287),n2h16(45))
  call Hloop_ZQ_A(ntryL,G0H32(46),ex1(:),G0H16(1),ngZl,m3h2x16(:,288),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(288),n2h16(46))
  call Hloop_VQ_A(ntryL,G0H32(47),ex1(:),G0H16(1),m3h2x16(:,289),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(289),n2h16(47))
  call Hloop_ZQ_A(ntryL,G0H32(48),ex1(:),G0H16(1),ngZl,m3h2x16(:,290),heltab2x32(:,:,290))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(290),n2h16(48))
  call Hloop_ZQ_A(ntryL,G0H32(49),ex1(:),G0H16(1),ngZl,m3h2x16(:,291),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(291),n2h16(49))
  call Hloop_ZQ_A(ntryL,G0H32(50),ex1(:),G0H16(1),ngZl,m3h2x16(:,292),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(292),n2h16(50))
  call Hloop_VQ_A(ntryL,G0H32(51),ex1(:),G0H16(1),m3h2x16(:,293),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(293),n2h16(51))
  call Hloop_VQ_A(ntryL,G0H32(52),ex1(:),G0H16(1),m3h2x16(:,294),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(294),n2h16(52))
  call Hloop_VQ_A(ntryL,G0H32(53),ex1(:),G0H16(1),m3h2x16(:,295),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(295),n2h16(53))
  call Hloop_ZQ_A(ntryL,G0H32(54),ex1(:),G0H16(1),ngZl,m3h2x16(:,296),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(296),n2h16(54))
  call Hloop_VQ_A(ntryL,G0H32(55),ex1(:),G0H16(1),m3h2x16(:,297),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(297),n2h16(55))
  call Hloop_ZQ_A(ntryL,G0H32(56),ex1(:),G0H16(1),ngZl,m3h2x16(:,298),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(298),n2h16(56))
  call Hloop_ZQ_A(ntryL,G0H32(57),ex1(:),G0H16(1),ngZl,m3h2x16(:,299),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(299),n2h16(57))
  call Hloop_ZQ_A(ntryL,G0H32(58),ex1(:),G0H16(1),ngZl,m3h2x16(:,300),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(300),n2h16(58))
  call Hloop_WQ_A(ntryL,G0H32(59),ex1(:),G0H16(1),m3h2x16(:,301),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(301),n2h16(59))
  call Hloop_AQ_V(ntryL,G1H32(243),ex1(:),G1H16(302),m3h2x16(:,302),heltab2x32(:,:,302))
  call Hloop_AQ_V(ntryL,G1H32(244),ex1(:),G1H16(303),m3h2x16(:,303),heltab2x32(:,:,303))
  call Hloop_AQ_V(ntryL,G1H32(245),ex1(:),G1H16(304),m3h2x16(:,304),heltab2x32(:,:,304))
  call Hloop_AQ_Z(ntryL,G1H32(246),ex1(:),G1H16(305),ngZl,m3h2x16(:,305),heltab2x32(:,:,305))
  call Hloop_AQ_V(ntryL,G1H32(247),ex1(:),G1H16(306),m3h2x16(:,306),heltab2x32(:,:,306))
  call Hloop_AQ_Z(ntryL,G1H32(248),ex1(:),G1H16(307),ngZl,m3h2x16(:,307),heltab2x32(:,:,307))
  call Hloop_AQ_Z(ntryL,G1H32(249),ex1(:),G1H16(308),ngZl,m3h2x16(:,308),heltab2x32(:,:,308))
  call Hloop_AQ_Z(ntryL,G1H32(250),ex1(:),G1H16(309),ngZl,m3h2x16(:,309),heltab2x32(:,:,309))
  call Hloop_AQ_W(ntryL,G1H32(251),ex1(:),G1H16(310),m3h2x16(:,310),heltab2x32(:,:,310))
  call Hloop_VQ_A(ntryL,G0H32(60),ex1(:),G0H16(1),m3h2x16(:,311),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(311),n2h16(60))
  call Hloop_VQ_A(ntryL,G0H32(61),ex1(:),G0H16(1),m3h2x16(:,312),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(312),n2h16(61))
  call Hloop_VQ_A(ntryL,G0H32(62),ex1(:),G0H16(1),m3h2x16(:,313),heltab2x32(:,:,313))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(313),n2h16(62))
  call Hloop_ZQ_A(ntryL,G0H32(63),ex1(:),G0H16(1),ngZl,m3h2x16(:,314),heltab2x32(:,:,314))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(314),n2h16(63))
  call Hloop_VQ_A(ntryL,G0H32(64),ex1(:),G0H16(1),m3h2x16(:,315),heltab2x32(:,:,315))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(315),n2h16(64))
  call Hloop_ZQ_A(ntryL,G0H32(65),ex1(:),G0H16(1),ngZl,m3h2x16(:,316),heltab2x32(:,:,316))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(316),n2h16(65))
  call Hloop_ZQ_A(ntryL,G0H32(66),ex1(:),G0H16(1),ngZl,m3h2x16(:,317),heltab2x32(:,:,317))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(317),n2h16(66))
  call Hloop_ZQ_A(ntryL,G0H32(67),ex1(:),G0H16(1),ngZl,m3h2x16(:,318),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(318),n2h16(67))
  call Hloop_WQ_A(ntryL,G0H32(68),ex1(:),G0H16(1),m3h2x16(:,319),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(319),n2h16(68))
  call Hloop_AQ_V(ntryL,G1H32(252),ex1(:),G1H16(320),m3h2x16(:,320),heltab2x32(:,:,320))
  call Hloop_AQ_V(ntryL,G1H32(253),ex1(:),G1H16(321),m3h2x16(:,321),heltab2x32(:,:,321))
  call Hloop_AQ_V(ntryL,G1H32(254),ex1(:),G1H16(322),m3h2x16(:,322),heltab2x32(:,:,322))
  call Hloop_AQ_Z(ntryL,G1H32(255),ex1(:),G1H16(323),ngZl,m3h2x16(:,323),heltab2x32(:,:,323))
  call Hloop_AQ_V(ntryL,G1H32(256),ex1(:),G1H16(324),m3h2x16(:,324),heltab2x32(:,:,324))
  call Hloop_AQ_Z(ntryL,G1H32(257),ex1(:),G1H16(325),ngZl,m3h2x16(:,325),heltab2x32(:,:,325))
  call Hloop_AQ_Z(ntryL,G1H32(258),ex1(:),G1H16(326),ngZl,m3h2x16(:,326),heltab2x32(:,:,326))
  call Hloop_AQ_Z(ntryL,G1H32(259),ex1(:),G1H16(327),ngZl,m3h2x16(:,327),heltab2x32(:,:,327))
  call Hloop_AQ_W(ntryL,G1H32(260),ex1(:),G1H16(328),m3h2x16(:,328),heltab2x32(:,:,328))
  call Hloop_AQ_V(ntryL,G1H32(261),ex1(:),G1H16(329),m3h2x16(:,329),heltab2x32(:,:,329))
  call Hloop_AQ_V(ntryL,G1H32(262),ex1(:),G1H16(330),m3h2x16(:,330),heltab2x32(:,:,330))
  call Hloop_AQ_V(ntryL,G1H32(263),ex1(:),G1H16(331),m3h2x16(:,331),heltab2x32(:,:,331))
  call Hloop_AQ_Z(ntryL,G1H32(264),ex1(:),G1H16(332),ngZl,m3h2x16(:,332),heltab2x32(:,:,332))
  call Hloop_AQ_V(ntryL,G1H32(265),ex1(:),G1H16(333),m3h2x16(:,333),heltab2x32(:,:,333))
  call Hloop_AQ_Z(ntryL,G1H32(266),ex1(:),G1H16(334),ngZl,m3h2x16(:,334),heltab2x32(:,:,334))
  call Hloop_AQ_Z(ntryL,G1H32(267),ex1(:),G1H16(335),ngZl,m3h2x16(:,335),heltab2x32(:,:,335))
  call Hloop_AQ_Z(ntryL,G1H32(268),ex1(:),G1H16(336),ngZl,m3h2x16(:,336),heltab2x32(:,:,336))
  call Hloop_VQ_A(ntryL,G0H32(69),ex1(:),G0H16(1),m3h2x16(:,337),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(337),n2h16(69))
  call Hloop_VQ_A(ntryL,G0H32(70),ex1(:),G0H16(1),m3h2x16(:,338),heltab2x32(:,:,338))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(338),n2h16(70))
  call Hloop_VQ_A(ntryL,G0H32(71),ex1(:),G0H16(1),m3h2x16(:,339),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(339),n2h16(71))
  call Hloop_ZQ_A(ntryL,G0H32(72),ex1(:),G0H16(1),ngZl,m3h2x16(:,340),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(340),n2h16(72))
  call Hloop_VQ_A(ntryL,G0H32(73),ex1(:),G0H16(1),m3h2x16(:,341),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(341),n2h16(73))
  call Hloop_ZQ_A(ntryL,G0H32(74),ex1(:),G0H16(1),ngZl,m3h2x16(:,342),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(342),n2h16(74))
  call Hloop_ZQ_A(ntryL,G0H32(75),ex1(:),G0H16(1),ngZl,m3h2x16(:,343),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(343),n2h16(75))
  call Hloop_ZQ_A(ntryL,G0H32(76),ex1(:),G0H16(1),ngZl,m3h2x16(:,344),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(344),n2h16(76))
  call Hloop_AQ_V(ntryL,G1H32(269),ex1(:),G1H16(345),m3h2x16(:,345),heltab2x32(:,:,345))
  call Hloop_AQ_V(ntryL,G1H32(270),ex1(:),G1H16(346),m3h2x16(:,346),heltab2x32(:,:,346))
  call Hloop_AQ_V(ntryL,G1H32(271),ex1(:),G1H16(347),m3h2x16(:,347),heltab2x32(:,:,347))
  call Hloop_AQ_Z(ntryL,G1H32(272),ex1(:),G1H16(348),ngZl,m3h2x16(:,348),heltab2x32(:,:,348))
  call Hloop_AQ_V(ntryL,G1H32(273),ex1(:),G1H16(349),m3h2x16(:,349),heltab2x32(:,:,349))
  call Hloop_AQ_Z(ntryL,G1H32(274),ex1(:),G1H16(350),ngZl,m3h2x16(:,350),heltab2x32(:,:,350))
  call Hloop_AQ_Z(ntryL,G1H32(275),ex1(:),G1H16(351),ngZl,m3h2x16(:,351),heltab2x32(:,:,351))
  call Hloop_AQ_Z(ntryL,G1H32(276),ex1(:),G1H16(352),ngZl,m3h2x16(:,352),heltab2x32(:,:,352))
  call Hloop_VQ_A(ntryL,G0H32(77),ex1(:),G0H16(1),m3h2x16(:,353),heltab2x32(:,:,353))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(353),n2h16(77))
  call Hloop_VQ_A(ntryL,G0H32(78),ex1(:),G0H16(1),m3h2x16(:,354),heltab2x32(:,:,354))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(354),n2h16(78))
  call Hloop_VQ_A(ntryL,G0H32(79),ex1(:),G0H16(1),m3h2x16(:,355),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(355),n2h16(79))
  call Hloop_ZQ_A(ntryL,G0H32(80),ex1(:),G0H16(1),ngZl,m3h2x16(:,356),heltab2x32(:,:,356))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(356),n2h16(80))
  call Hloop_VQ_A(ntryL,G0H32(81),ex1(:),G0H16(1),m3h2x16(:,357),heltab2x32(:,:,357))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(357),n2h16(81))
  call Hloop_ZQ_A(ntryL,G0H32(82),ex1(:),G0H16(1),ngZl,m3h2x16(:,358),heltab2x32(:,:,358))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(358),n2h16(82))
  call Hloop_ZQ_A(ntryL,G0H32(83),ex1(:),G0H16(1),ngZl,m3h2x16(:,359),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(359),n2h16(83))
  call Hloop_ZQ_A(ntryL,G0H32(84),ex1(:),G0H16(1),ngZl,m3h2x16(:,360),heltab2x32(:,:,360))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(360),n2h16(84))
  call Hloop_VQ_A(ntryL,G0H32(85),ex1(:),G0H16(1),m3h2x16(:,361),heltab2x32(:,:,361))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(361),n2h16(85))
  call Hloop_VQ_A(ntryL,G0H32(86),ex1(:),G0H16(1),m3h2x16(:,362),heltab2x32(:,:,362))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(362),n2h16(86))
  call Hloop_VQ_A(ntryL,G0H32(87),ex1(:),G0H16(1),m3h2x16(:,363),heltab2x32(:,:,363))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(363),n2h16(87))
  call Hloop_ZQ_A(ntryL,G0H32(88),ex1(:),G0H16(1),ngZl,m3h2x16(:,364),heltab2x32(:,:,364))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(364),n2h16(88))
  call Hloop_VQ_A(ntryL,G0H32(89),ex1(:),G0H16(1),m3h2x16(:,365),heltab2x32(:,:,365))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(365),n2h16(89))
  call Hloop_ZQ_A(ntryL,G0H32(90),ex1(:),G0H16(1),ngZl,m3h2x16(:,366),heltab2x32(:,:,366))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(366),n2h16(90))
  call Hloop_ZQ_A(ntryL,G0H32(91),ex1(:),G0H16(1),ngZl,m3h2x16(:,367),heltab2x32(:,:,367))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(367),n2h16(91))
  call Hloop_ZQ_A(ntryL,G0H32(92),ex1(:),G0H16(1),ngZl,m3h2x16(:,368),heltab2x32(:,:,368))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(368),n2h16(92))
  call Hloop_WQ_A(ntryL,G0H32(93),ex1(:),G0H16(1),m3h2x16(:,369),heltab2x32(:,:,369))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(369),n2h16(93))
  call Hloop_AQ_V(ntryL,G1H32(277),ex1(:),G1H16(370),m3h2x16(:,370),heltab2x32(:,:,370))
  call Hloop_AQ_V(ntryL,G1H32(278),ex1(:),G1H16(371),m3h2x16(:,371),heltab2x32(:,:,371))
  call Hloop_AQ_V(ntryL,G1H32(279),ex1(:),G1H16(372),m3h2x16(:,372),heltab2x32(:,:,372))
  call Hloop_AQ_Z(ntryL,G1H32(280),ex1(:),G1H16(373),ngZl,m3h2x16(:,373),heltab2x32(:,:,373))
  call Hloop_AQ_V(ntryL,G1H32(281),ex1(:),G1H16(374),m3h2x16(:,374),heltab2x32(:,:,374))
  call Hloop_AQ_Z(ntryL,G1H32(282),ex1(:),G1H16(375),ngZl,m3h2x16(:,375),heltab2x32(:,:,375))
  call Hloop_AQ_Z(ntryL,G1H32(283),ex1(:),G1H16(376),ngZl,m3h2x16(:,376),heltab2x32(:,:,376))
  call Hloop_AQ_Z(ntryL,G1H32(284),ex1(:),G1H16(377),ngZl,m3h2x16(:,377),heltab2x32(:,:,377))
  call Hloop_AQ_W(ntryL,G1H32(285),ex1(:),G1H16(378),m3h2x16(:,378),heltab2x32(:,:,378))
  call Hloop_VQ_A(ntryL,G0H32(94),ex1(:),G0H16(1),m3h2x16(:,379),heltab2x32(:,:,379))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(379),n2h16(94))
  call Hloop_VQ_A(ntryL,G0H32(95),ex1(:),G0H16(1),m3h2x16(:,380),heltab2x32(:,:,380))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(380),n2h16(95))
  call Hloop_VQ_A(ntryL,G0H32(96),ex1(:),G0H16(1),m3h2x16(:,381),heltab2x32(:,:,381))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(381),n2h16(96))
  call Hloop_ZQ_A(ntryL,G0H32(97),ex1(:),G0H16(1),ngZl,m3h2x16(:,382),heltab2x32(:,:,382))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(382),n2h16(97))
  call Hloop_VQ_A(ntryL,G0H32(98),ex1(:),G0H16(1),m3h2x16(:,383),heltab2x32(:,:,383))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(383),n2h16(98))
  call Hloop_ZQ_A(ntryL,G0H32(99),ex1(:),G0H16(1),ngZl,m3h2x16(:,384),heltab2x32(:,:,384))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(384),n2h16(99))
  call Hloop_ZQ_A(ntryL,G0H32(100),ex1(:),G0H16(1),ngZl,m3h2x16(:,385),heltab2x32(:,:,385))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(385),n2h16(100))
  call Hloop_ZQ_A(ntryL,G0H32(101),ex1(:),G0H16(1),ngZl,m3h2x16(:,386),heltab2x32(:,:,386))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(386),n2h16(101))
  call Hloop_WQ_A(ntryL,G0H32(102),ex1(:),G0H16(1),m3h2x16(:,387),heltab2x32(:,:,387))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(387),n2h16(102))
  call Hloop_AQ_V(ntryL,G1H32(286),ex1(:),G1H16(388),m3h2x16(:,388),heltab2x32(:,:,388))
  call Hloop_AQ_V(ntryL,G1H32(287),ex1(:),G1H16(389),m3h2x16(:,389),heltab2x32(:,:,389))
  call Hloop_AQ_V(ntryL,G1H32(288),ex1(:),G1H16(390),m3h2x16(:,390),heltab2x32(:,:,390))
  call Hloop_AQ_Z(ntryL,G1H32(289),ex1(:),G1H16(391),ngZl,m3h2x16(:,391),heltab2x32(:,:,391))
  call Hloop_AQ_V(ntryL,G1H32(290),ex1(:),G1H16(392),m3h2x16(:,392),heltab2x32(:,:,392))
  call Hloop_AQ_Z(ntryL,G1H32(291),ex1(:),G1H16(393),ngZl,m3h2x16(:,393),heltab2x32(:,:,393))
  call Hloop_AQ_Z(ntryL,G1H32(292),ex1(:),G1H16(394),ngZl,m3h2x16(:,394),heltab2x32(:,:,394))
  call Hloop_AQ_Z(ntryL,G1H32(293),ex1(:),G1H16(395),ngZl,m3h2x16(:,395),heltab2x32(:,:,395))
  call Hloop_AQ_W(ntryL,G1H32(294),ex1(:),G1H16(396),m3h2x16(:,396),heltab2x32(:,:,396))
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(1))
  call Hloop_VA_Q(ntryL,G1H16(2),ex4(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(2),n2h8(2))
  call Hloop_ZA_Q(ntryL,G1H16(3),ex4(:),G1H8(1),ngZl,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(3),n2h8(3))
  call Hloop_VA_Q(ntryL,G1H16(4),ex4(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(4),n2h8(4))
  call Hloop_ZA_Q(ntryL,G1H16(5),ex4(:),G1H8(1),ngZl,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(5),n2h8(5))
  call Hloop_VA_Q(ntryL,G1H16(6),ex4(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(6),n2h8(6))
  call Hloop_ZA_Q(ntryL,G1H16(7),ex4(:),G1H8(1),ngZl,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(7),n2h8(7))
  call Hloop_ZA_Q(ntryL,G1H16(8),ex4(:),G1H8(1),ngZl,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(8),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex5(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(9),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(10),ex5(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(10),n2h8(10))
  call Hloop_ZA_Q(ntryL,G1H16(11),ex5(:),G1H8(1),ngZl,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(11),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex5(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(12),n2h8(12))
  call Hloop_ZA_Q(ntryL,G1H16(13),ex5(:),G1H8(1),ngZl,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(13),n2h8(13))
  call Hloop_VA_Q(ntryL,G1H16(14),ex5(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(14),n2h8(14))
  call Hloop_ZA_Q(ntryL,G1H16(15),ex5(:),G1H8(1),ngZl,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(15),n2h8(15))
  call Hloop_ZA_Q(ntryL,G1H16(16),ex5(:),G1H8(1),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(16),n2h8(16))
  call Hloop_VQ_A(ntryL,G1H16(17),ex1(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(17),n2h8(17))
  call Hloop_VQ_A(ntryL,G1H16(18),ex1(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(18),n2h8(18))
  call Hloop_VQ_A(ntryL,G1H16(19),ex1(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(19),n2h8(19))
  call Hloop_ZQ_A(ntryL,G1H16(20),ex1(:),G1H8(1),ngZl,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(20),n2h8(20))
  call Hloop_VQ_A(ntryL,G1H16(21),ex1(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(21),n2h8(21))
  call Hloop_ZQ_A(ntryL,G1H16(22),ex1(:),G1H8(1),ngZl,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(22),n2h8(22))
  call Hloop_ZQ_A(ntryL,G1H16(23),ex1(:),G1H8(1),ngZl,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(23),n2h8(23))
  call Hloop_ZQ_A(ntryL,G1H16(24),ex1(:),G1H8(1),ngZl,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(24),n2h8(24))
  call Hloop_VQ_A(ntryL,G1H16(25),ex1(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(25),n2h8(25))
  call Hloop_VQ_A(ntryL,G1H16(26),ex1(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(26),n2h8(26))
  call Hloop_VQ_A(ntryL,G1H16(27),ex1(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(27),n2h8(27))
  call Hloop_ZQ_A(ntryL,G1H16(28),ex1(:),G1H8(1),ngZl,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(28),n2h8(28))
  call Hloop_VQ_A(ntryL,G1H16(29),ex1(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(29),n2h8(29))
  call Hloop_ZQ_A(ntryL,G1H16(30),ex1(:),G1H8(1),ngZl,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(30),n2h8(30))
  call Hloop_ZQ_A(ntryL,G1H16(31),ex1(:),G1H8(1),ngZl,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(31),n2h8(31))
  call Hloop_ZQ_A(ntryL,G1H16(32),ex1(:),G1H8(1),ngZl,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(32),n2h8(32))
  call Hloop_VA_Q(ntryL,G1H16(33),ex4(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(33),n2h8(33))
  call Hloop_VA_Q(ntryL,G1H16(34),ex4(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(34),n2h8(34))
  call Hloop_ZA_Q(ntryL,G1H16(35),ex4(:),G1H8(1),ngZl,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(35),n2h8(35))
  call Hloop_VA_Q(ntryL,G1H16(36),ex4(:),G1H8(1),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(36),n2h8(36))
  call Hloop_ZA_Q(ntryL,G1H16(37),ex4(:),G1H8(1),ngZl,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(37),n2h8(37))
  call Hloop_VA_Q(ntryL,G1H16(38),ex4(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(38),n2h8(38))
  call Hloop_ZA_Q(ntryL,G1H16(39),ex4(:),G1H8(1),ngZl,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(39),n2h8(39))
  call Hloop_ZA_Q(ntryL,G1H16(40),ex4(:),G1H8(1),ngZl,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(40),n2h8(40))
  call Hloop_VA_Q(ntryL,G1H16(41),ex5(:),G1H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(41),n2h8(41))
  call Hloop_VA_Q(ntryL,G1H16(42),ex5(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(42),n2h8(42))
  call Hloop_ZA_Q(ntryL,G1H16(43),ex5(:),G1H8(1),ngZl,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(43),n2h8(43))
  call Hloop_VA_Q(ntryL,G1H16(44),ex5(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(44),n2h8(44))
  call Hloop_ZA_Q(ntryL,G1H16(45),ex5(:),G1H8(1),ngZl,m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(45),n2h8(45))
  call Hloop_VA_Q(ntryL,G1H16(46),ex5(:),G1H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(46),n2h8(46))
  call Hloop_ZA_Q(ntryL,G1H16(47),ex5(:),G1H8(1),ngZl,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(47),n2h8(47))
  call Hloop_ZA_Q(ntryL,G1H16(48),ex5(:),G1H8(1),ngZl,m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(48),n2h8(48))
  call Hloop_VQ_A(ntryL,G1H16(49),ex1(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(49),n2h8(49))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(50),n2h8(50))
  call Hloop_VQ_A(ntryL,G1H16(51),ex1(:),G1H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(51),n2h8(51))
  call Hloop_ZQ_A(ntryL,G1H16(52),ex1(:),G1H8(1),ngZl,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(52),n2h8(52))
  call Hloop_VQ_A(ntryL,G1H16(53),ex1(:),G1H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(53),n2h8(53))
  call Hloop_ZQ_A(ntryL,G1H16(54),ex1(:),G1H8(1),ngZl,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(54),n2h8(54))
  call Hloop_ZQ_A(ntryL,G1H16(55),ex1(:),G1H8(1),ngZl,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(55),n2h8(55))
  call Hloop_ZQ_A(ntryL,G1H16(56),ex1(:),G1H8(1),ngZl,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(56),n2h8(56))
  call Hloop_VQ_A(ntryL,G1H16(57),ex1(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(57),n2h8(57))
  call Hloop_VQ_A(ntryL,G1H16(58),ex1(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(58),n2h8(58))
  call Hloop_VQ_A(ntryL,G1H16(59),ex1(:),G1H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(59),n2h8(59))
  call Hloop_ZQ_A(ntryL,G1H16(60),ex1(:),G1H8(1),ngZl,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(60),n2h8(60))
  call Hloop_VQ_A(ntryL,G1H16(61),ex1(:),G1H8(1),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(61),n2h8(61))
  call Hloop_ZQ_A(ntryL,G1H16(62),ex1(:),G1H8(1),ngZl,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(62),n2h8(62))
  call Hloop_ZQ_A(ntryL,G1H16(63),ex1(:),G1H8(1),ngZl,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(63),n2h8(63))
  call Hloop_ZQ_A(ntryL,G1H16(64),ex1(:),G1H8(1),ngZl,m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(64),n2h8(64))
  call Hloop_VQ_A(ntryL,G1H16(65),ex2(:),G1H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(65),n2h8(65))
  call Hloop_VQ_A(ntryL,G1H16(66),ex2(:),G1H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(66),n2h8(66))
  call Hloop_VQ_A(ntryL,G1H16(67),ex2(:),G1H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(67),n2h8(67))
  call Hloop_ZQ_A(ntryL,G1H16(68),ex2(:),G1H8(1),ngZl,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(68),n2h8(68))
  call Hloop_VQ_A(ntryL,G1H16(69),ex2(:),G1H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(69),n2h8(69))
  call Hloop_ZQ_A(ntryL,G1H16(70),ex2(:),G1H8(1),ngZl,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(70),n2h8(70))
  call Hloop_ZQ_A(ntryL,G1H16(71),ex2(:),G1H8(1),ngZl,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(71),n2h8(71))
  call Hloop_ZQ_A(ntryL,G1H16(72),ex2(:),G1H8(1),ngZl,m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(72),n2h8(72))
  call Hloop_VQ_A(ntryL,G1H16(73),ex2(:),G1H8(1),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(73),n2h8(73))
  call Hloop_VQ_A(ntryL,G1H16(74),ex2(:),G1H8(1),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(74),n2h8(74))
  call Hloop_VQ_A(ntryL,G1H16(75),ex2(:),G1H8(1),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(75),n2h8(75))
  call Hloop_ZQ_A(ntryL,G1H16(76),ex2(:),G1H8(1),ngZl,m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(76),n2h8(76))
  call Hloop_VQ_A(ntryL,G1H16(77),ex2(:),G1H8(1),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(77),n2h8(77))
  call Hloop_ZQ_A(ntryL,G1H16(78),ex2(:),G1H8(1),ngZl,m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(78),n2h8(78))
  call Hloop_ZQ_A(ntryL,G1H16(79),ex2(:),G1H8(1),ngZl,m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(79),n2h8(79))
  call Hloop_ZQ_A(ntryL,G1H16(80),ex2(:),G1H8(1),ngZl,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(80),n2h8(80))
  call Hloop_VQ_A(ntryL,G1H16(81),ex2(:),G1H8(1),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(81),n2h8(81))
  call Hloop_VQ_A(ntryL,G1H16(82),ex2(:),G1H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(82),n2h8(82))
  call Hloop_VQ_A(ntryL,G1H16(83),ex2(:),G1H8(1),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(83),n2h8(83))
  call Hloop_ZQ_A(ntryL,G1H16(84),ex2(:),G1H8(1),ngZl,m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(84),n2h8(84))
  call Hloop_VQ_A(ntryL,G1H16(85),ex2(:),G1H8(1),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(85),n2h8(85))
  call Hloop_ZQ_A(ntryL,G1H16(86),ex2(:),G1H8(1),ngZl,m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(86),n2h8(86))
  call Hloop_ZQ_A(ntryL,G1H16(87),ex2(:),G1H8(1),ngZl,m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(87),n2h8(87))
  call Hloop_ZQ_A(ntryL,G1H16(88),ex2(:),G1H8(1),ngZl,m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(88),n2h8(88))
  call Hloop_VQ_A(ntryL,G1H16(89),ex2(:),G1H8(1),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(89),n2h8(89))
  call Hloop_VQ_A(ntryL,G1H16(90),ex2(:),G1H8(1),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(90),n2h8(90))
  call Hloop_VQ_A(ntryL,G1H16(91),ex2(:),G1H8(1),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(91),n2h8(91))
  call Hloop_ZQ_A(ntryL,G1H16(92),ex2(:),G1H8(1),ngZl,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(92),n2h8(92))
  call Hloop_VQ_A(ntryL,G1H16(93),ex2(:),G1H8(1),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(93),n2h8(93))
  call Hloop_ZQ_A(ntryL,G1H16(94),ex2(:),G1H8(1),ngZl,m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(94),n2h8(94))
  call Hloop_ZQ_A(ntryL,G1H16(95),ex2(:),G1H8(1),ngZl,m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(95),n2h8(95))
  call Hloop_ZQ_A(ntryL,G1H16(96),ex2(:),G1H8(1),ngZl,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(96),n2h8(96))
  call Hloop_VQ_A(ntryL,G1H16(97),ex1(:),G1H8(1),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(97),n2h8(97))
  call Hloop_VQ_A(ntryL,G1H16(98),ex1(:),G1H8(1),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(98),n2h8(98))
  call Hloop_VQ_A(ntryL,G1H16(99),ex1(:),G1H8(1),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(99),n2h8(99))
  call Hloop_ZQ_A(ntryL,G1H16(100),ex1(:),G1H8(1),ngZl,m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(100),n2h8(100))
  call Hloop_VQ_A(ntryL,G1H16(101),ex1(:),G1H8(1),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(101),n2h8(101))
  call Hloop_ZQ_A(ntryL,G1H16(102),ex1(:),G1H8(1),ngZl,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(102),n2h8(102))
  call Hloop_ZQ_A(ntryL,G1H16(103),ex1(:),G1H8(1),ngZl,m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(103),n2h8(103))
  call Hloop_ZQ_A(ntryL,G1H16(104),ex1(:),G1H8(1),ngZl,m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(104),n2h8(104))
  call Hloop_VA_Q(ntryL,G1H16(105),ex4(:),G1H8(1),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(105),n2h8(105))
  call Hloop_VA_Q(ntryL,G1H16(106),ex4(:),G1H8(1),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(106),n2h8(106))
  call Hloop_ZA_Q(ntryL,G1H16(107),ex4(:),G1H8(1),ngZl,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(107),n2h8(107))
  call Hloop_VA_Q(ntryL,G1H16(108),ex4(:),G1H8(1),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(108),n2h8(108))
  call Hloop_ZA_Q(ntryL,G1H16(109),ex4(:),G1H8(1),ngZl,m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(109),n2h8(109))
  call Hloop_VA_Q(ntryL,G1H16(110),ex4(:),G1H8(1),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(110),n2h8(110))
  call Hloop_ZA_Q(ntryL,G1H16(111),ex4(:),G1H8(1),ngZl,m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(111),n2h8(111))
  call Hloop_ZA_Q(ntryL,G1H16(112),ex4(:),G1H8(1),ngZl,m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(112),n2h8(112))
  call Hloop_VA_Q(ntryL,G1H16(113),ex5(:),G1H8(1),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(113),n2h8(113))
  call Hloop_VA_Q(ntryL,G1H16(114),ex5(:),G1H8(1),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(114),n2h8(114))
  call Hloop_ZA_Q(ntryL,G1H16(115),ex5(:),G1H8(1),ngZl,m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(115),n2h8(115))
  call Hloop_VA_Q(ntryL,G1H16(116),ex5(:),G1H8(1),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(116),n2h8(116))
  call Hloop_ZA_Q(ntryL,G1H16(117),ex5(:),G1H8(1),ngZl,m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(117),n2h8(117))
  call Hloop_VA_Q(ntryL,G1H16(118),ex5(:),G1H8(1),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(118),n2h8(118))
  call Hloop_ZA_Q(ntryL,G1H16(119),ex5(:),G1H8(1),ngZl,m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(119),n2h8(119))
  call Hloop_ZA_Q(ntryL,G1H16(120),ex5(:),G1H8(1),ngZl,m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(1),50,0,G2H8(120),n2h8(120))
  call Hloop_QA_V(ntryL,G1H16(121),ex5(:),G1H8(1),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_QA_Z(ntryL,G1H16(122),ex5(:),G1H8(2),ngZl,m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_QA_V(ntryL,G1H16(123),ex5(:),G1H8(3),m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_QA_V(ntryL,G1H16(124),ex5(:),G1H8(4),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_QA_Z(ntryL,G1H16(125),ex5(:),G1H8(5),ngZl,m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_QA_Z(ntryL,G1H16(126),ex5(:),G1H8(6),ngZl,m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_QA_V(ntryL,G1H16(127),ex5(:),G1H8(7),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_QA_Z(ntryL,G1H16(128),ex5(:),G1H8(8),ngZl,m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_VQ_A(ntryL,G1H16(129),ex1(:),G1H8(9),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(121),n2h8(121))
  call Hloop_VQ_A(ntryL,G1H16(130),ex1(:),G1H8(9),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(122),n2h8(122))
  call Hloop_VQ_A(ntryL,G1H16(131),ex1(:),G1H8(9),m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(123),n2h8(123))
  call Hloop_ZQ_A(ntryL,G1H16(132),ex1(:),G1H8(9),ngZl,m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(124),n2h8(124))
  call Hloop_VQ_A(ntryL,G1H16(133),ex1(:),G1H8(9),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(125),n2h8(125))
  call Hloop_ZQ_A(ntryL,G1H16(134),ex1(:),G1H8(9),ngZl,m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(126),n2h8(126))
  call Hloop_ZQ_A(ntryL,G1H16(135),ex1(:),G1H8(9),ngZl,m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(127),n2h8(127))
  call Hloop_ZQ_A(ntryL,G1H16(136),ex1(:),G1H8(9),ngZl,m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H8(9),37,0,G2H8(128),n2h8(128))
  call Hloop_VA_Q(ntryL,G1H16(137),ex4(:),G1H8(9),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(129),n2h8(129))
  call Hloop_VA_Q(ntryL,G1H16(138),ex4(:),G1H8(9),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(130),n2h8(130))
  call Hloop_ZA_Q(ntryL,G1H16(139),ex4(:),G1H8(9),ngZl,m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(131),n2h8(131))
  call Hloop_VA_Q(ntryL,G1H16(140),ex4(:),G1H8(9),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(132),n2h8(132))
  call Hloop_ZA_Q(ntryL,G1H16(141),ex4(:),G1H8(9),ngZl,m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(133),n2h8(133))
  call Hloop_VA_Q(ntryL,G1H16(142),ex4(:),G1H8(9),m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(134),n2h8(134))
  call Hloop_ZA_Q(ntryL,G1H16(143),ex4(:),G1H8(9),ngZl,m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(135),n2h8(135))
  call Hloop_ZA_Q(ntryL,G1H16(144),ex4(:),G1H8(9),ngZl,m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H8(9),42,0,G2H8(136),n2h8(136))
  call Hloop_QA_V(ntryL,G1H16(145),ex4(:),G1H8(9),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_QA_Z(ntryL,G1H16(146),ex4(:),G1H8(10),ngZl,m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_QA_V(ntryL,G1H16(147),ex4(:),G1H8(11),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_QA_V(ntryL,G1H16(148),ex4(:),G1H8(12),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_QA_Z(ntryL,G1H16(149),ex4(:),G1H8(13),ngZl,m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_QA_Z(ntryL,G1H16(150),ex4(:),G1H8(14),ngZl,m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_QA_V(ntryL,G1H16(151),ex4(:),G1H8(15),m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_QA_Z(ntryL,G1H16(152),ex4(:),G1H8(16),ngZl,m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_VA_Q(ntryL,G1H16(153),ex5(:),G1H8(17),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(137),n2h8(137))
  call Hloop_VA_Q(ntryL,G1H16(154),ex5(:),G1H8(17),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(138),n2h8(138))
  call Hloop_ZA_Q(ntryL,G1H16(155),ex5(:),G1H8(17),ngZl,m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(139),n2h8(139))
  call Hloop_VA_Q(ntryL,G1H16(156),ex5(:),G1H8(17),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(140),n2h8(140))
  call Hloop_ZA_Q(ntryL,G1H16(157),ex5(:),G1H8(17),ngZl,m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(141),n2h8(141))
  call Hloop_VA_Q(ntryL,G1H16(158),ex5(:),G1H8(17),m3h2x8(:,158),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(142),n2h8(142))
  call Hloop_ZA_Q(ntryL,G1H16(159),ex5(:),G1H8(17),ngZl,m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(143),n2h8(143))
  call Hloop_ZA_Q(ntryL,G1H16(160),ex5(:),G1H8(17),ngZl,m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H8(17),50,0,G2H8(144),n2h8(144))
  call Hloop_VQ_A(ntryL,G1H16(161),ex3(:),G1H8(17),m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(145),n2h8(145))
  call Hloop_VQ_A(ntryL,G1H16(162),ex3(:),G1H8(17),m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(146),n2h8(146))
  call Hloop_VQ_A(ntryL,G1H16(163),ex3(:),G1H8(17),m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(147),n2h8(147))
  call Hloop_ZQ_A(ntryL,G1H16(164),ex3(:),G1H8(17),ngZl,m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(148),n2h8(148))
  call Hloop_VQ_A(ntryL,G1H16(165),ex3(:),G1H8(17),m3h2x8(:,165),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(149),n2h8(149))
  call Hloop_ZQ_A(ntryL,G1H16(166),ex3(:),G1H8(17),ngZl,m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(150),n2h8(150))
  call Hloop_ZQ_A(ntryL,G1H16(167),ex3(:),G1H8(17),ngZl,m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(151),n2h8(151))
  call Hloop_ZQ_A(ntryL,G1H16(168),ex3(:),G1H8(17),ngZl,m3h2x8(:,168),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(152),n2h8(152))
  call Hloop_VQ_A(ntryL,G1H16(169),ex3(:),G1H8(17),m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(153),n2h8(153))
  call Hloop_VQ_A(ntryL,G1H16(170),ex3(:),G1H8(17),m3h2x8(:,170),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(154),n2h8(154))
  call Hloop_VQ_A(ntryL,G1H16(171),ex3(:),G1H8(17),m3h2x8(:,171),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(155),n2h8(155))
  call Hloop_ZQ_A(ntryL,G1H16(172),ex3(:),G1H8(17),ngZl,m3h2x8(:,172),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(156),n2h8(156))
  call Hloop_VQ_A(ntryL,G1H16(173),ex3(:),G1H8(17),m3h2x8(:,173),heltab2x16(:,:,173))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(157),n2h8(157))
  call Hloop_ZQ_A(ntryL,G1H16(174),ex3(:),G1H8(17),ngZl,m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(158),n2h8(158))
  call Hloop_ZQ_A(ntryL,G1H16(175),ex3(:),G1H8(17),ngZl,m3h2x8(:,175),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(159),n2h8(159))
  call Hloop_ZQ_A(ntryL,G1H16(176),ex3(:),G1H8(17),ngZl,m3h2x8(:,176),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(160),n2h8(160))
  call Hloop_VQ_A(ntryL,G1H16(177),ex3(:),G1H8(17),m3h2x8(:,177),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(161),n2h8(161))
  call Hloop_VQ_A(ntryL,G1H16(178),ex3(:),G1H8(17),m3h2x8(:,178),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(162),n2h8(162))
  call Hloop_VQ_A(ntryL,G1H16(179),ex3(:),G1H8(17),m3h2x8(:,179),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(163),n2h8(163))
  call Hloop_ZQ_A(ntryL,G1H16(180),ex3(:),G1H8(17),ngZl,m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(164),n2h8(164))
  call Hloop_VQ_A(ntryL,G1H16(181),ex3(:),G1H8(17),m3h2x8(:,181),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(165),n2h8(165))
  call Hloop_ZQ_A(ntryL,G1H16(182),ex3(:),G1H8(17),ngZl,m3h2x8(:,182),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(166),n2h8(166))
  call Hloop_ZQ_A(ntryL,G1H16(183),ex3(:),G1H8(17),ngZl,m3h2x8(:,183),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(167),n2h8(167))
  call Hloop_ZQ_A(ntryL,G1H16(184),ex3(:),G1H8(17),ngZl,m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(168),n2h8(168))
  call Hloop_VQ_A(ntryL,G1H16(185),ex3(:),G1H8(17),m3h2x8(:,185),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(169),n2h8(169))
  call Hloop_VQ_A(ntryL,G1H16(186),ex3(:),G1H8(17),m3h2x8(:,186),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(170),n2h8(170))
  call Hloop_VQ_A(ntryL,G1H16(187),ex3(:),G1H8(17),m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(171),n2h8(171))
  call Hloop_ZQ_A(ntryL,G1H16(188),ex3(:),G1H8(17),ngZl,m3h2x8(:,188),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(172),n2h8(172))
  call Hloop_VQ_A(ntryL,G1H16(189),ex3(:),G1H8(17),m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(173),n2h8(173))
  call Hloop_ZQ_A(ntryL,G1H16(190),ex3(:),G1H8(17),ngZl,m3h2x8(:,190),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(174),n2h8(174))
  call Hloop_ZQ_A(ntryL,G1H16(191),ex3(:),G1H8(17),ngZl,m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(175),n2h8(175))
  call Hloop_ZQ_A(ntryL,G1H16(192),ex3(:),G1H8(17),ngZl,m3h2x8(:,192),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H8(17),37,0,G2H8(176),n2h8(176))
  call Hloop_VQ_A(ntryL,G1H16(193),ex2(:),G1H8(17),m3h2x8(:,193),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(177),n2h8(177))
  call Hloop_VQ_A(ntryL,G1H16(194),ex2(:),G1H8(17),m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(178),n2h8(178))
  call Hloop_ZQ_A(ntryL,G1H16(195),ex2(:),G1H8(17),ngZl,m3h2x8(:,195),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(179),n2h8(179))
  call Hloop_VQ_A(ntryL,G1H16(196),ex2(:),G1H8(17),m3h2x8(:,196),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(180),n2h8(180))
  call Hloop_ZQ_A(ntryL,G1H16(197),ex2(:),G1H8(17),ngZl,m3h2x8(:,197),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(181),n2h8(181))
  call Hloop_VQ_A(ntryL,G1H16(198),ex2(:),G1H8(17),m3h2x8(:,198),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(182),n2h8(182))
  call Hloop_ZQ_A(ntryL,G1H16(199),ex2(:),G1H8(17),ngZl,m3h2x8(:,199),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(183),n2h8(183))
  call Hloop_ZQ_A(ntryL,G1H16(200),ex2(:),G1H8(17),ngZl,m3h2x8(:,200),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(184),n2h8(184))
  call Hloop_VQ_A(ntryL,G1H16(201),ex2(:),G1H8(17),m3h2x8(:,201),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(185),n2h8(185))
  call Hloop_VQ_A(ntryL,G1H16(202),ex2(:),G1H8(17),m3h2x8(:,202),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(186),n2h8(186))
  call Hloop_ZQ_A(ntryL,G1H16(203),ex2(:),G1H8(17),ngZl,m3h2x8(:,203),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(187),n2h8(187))
  call Hloop_VQ_A(ntryL,G1H16(204),ex2(:),G1H8(17),m3h2x8(:,204),heltab2x16(:,:,204))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(188),n2h8(188))
  call Hloop_ZQ_A(ntryL,G1H16(205),ex2(:),G1H8(17),ngZl,m3h2x8(:,205),heltab2x16(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(189),n2h8(189))
  call Hloop_VQ_A(ntryL,G1H16(206),ex2(:),G1H8(17),m3h2x8(:,206),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(190),n2h8(190))
  call Hloop_ZQ_A(ntryL,G1H16(207),ex2(:),G1H8(17),ngZl,m3h2x8(:,207),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(191),n2h8(191))
  call Hloop_ZQ_A(ntryL,G1H16(208),ex2(:),G1H8(17),ngZl,m3h2x8(:,208),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(192),n2h8(192))
  call Hloop_VQ_A(ntryL,G1H16(209),ex3(:),G1H8(17),m3h2x8(:,209),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(193),n2h8(193))
  call Hloop_VQ_A(ntryL,G1H16(210),ex3(:),G1H8(17),m3h2x8(:,210),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(194),n2h8(194))
  call Hloop_ZQ_A(ntryL,G1H16(211),ex3(:),G1H8(17),ngZl,m3h2x8(:,211),heltab2x16(:,:,211))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(195),n2h8(195))
  call Hloop_VQ_A(ntryL,G1H16(212),ex3(:),G1H8(17),m3h2x8(:,212),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(196),n2h8(196))
  call Hloop_ZQ_A(ntryL,G1H16(213),ex3(:),G1H8(17),ngZl,m3h2x8(:,213),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(197),n2h8(197))
  call Hloop_VQ_A(ntryL,G1H16(214),ex3(:),G1H8(17),m3h2x8(:,214),heltab2x16(:,:,214))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(198),n2h8(198))
  call Hloop_ZQ_A(ntryL,G1H16(215),ex3(:),G1H8(17),ngZl,m3h2x8(:,215),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(199),n2h8(199))
  call Hloop_ZQ_A(ntryL,G1H16(216),ex3(:),G1H8(17),ngZl,m3h2x8(:,216),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H8(17),38,0,G2H8(200),n2h8(200))



end subroutine vamp_1

end module ol_vamp_1_eellll_ew_eeeexexex_1_/**/REALKIND
