
module ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 1]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 1]

  K2(1,:) = [ 1]

  KL(1,:) = [ 1]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND



module ol_forced_parameters_eellll_ew_eeeexexex_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_eellll_ew_eeeexexex_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_eellll_ew_eeeexexex_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(2208)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,72), wf8(8,504), wf16(16,306), wf64(64,1440)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(59), c(58)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_eellll_ew_eeeexexex_1_/**/REALKIND






! **********************************************************************
module ol_loop_eellll_ew_eeeexexex_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_eellll_ew_eeeexexex_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**4
    f( 2) = CI*countertermnorm*eQED**6
    f( 3) = eQED**6*integralnorm*SwB
    f( 4) = 2*eQED**6*integralnorm*SwB
    f( 5) = eQED**6*integralnorm*MW**2*SwB
    f( 6) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 7) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f( 8) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 9) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(10) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(11) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(12) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(13) = (cw**3*eQED**6*integralnorm*SwB)/sw**3
    f(14) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(15) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(16) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(17) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(18) = (cw**2*eQED**6*integralnorm*SwB)/sw**2
    f(19) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(20) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(21) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(22) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(23) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f(24) = (cw*eQED**6*integralnorm*SwB)/sw
    f(25) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(26) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(27) = (cw*eQED**6*integralnorm*MW**2*SwB)/sw
    f(28) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(29) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(30) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(31) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(32) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(33) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(34) = (eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(35) = (eQED**6*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(36) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(37) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(38) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(39) = -((eQED**6*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(40) = (eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(41) = (2*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(42) = (eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(43) = (2*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(44) = (8*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(45) = (eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(46) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(47) = (16*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(48) = (2*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(49) = (8*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(50) = eQED**6*integralnorm*SwF
    f(51) = (4*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(52) = 2*eQED**6*integralnorm*SwF
    f(53) = 3*eQED**6*integralnorm*SwF
    f(54) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(55) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(56) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(57) = (eQED**6*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(58) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(59) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ f(3), f(4), f(5), f(6), f(7), f(8), f(9), f(10), f(11), f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20) &
    , f(21), f(22), f(23), f(24), f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38) &
    , f(39), 3*f(40), 3*f(41), 3*f(42), 3*f(43), 3*f(44), 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), f(50), 3*f(50), 3*f(51) &
    , 3*f(52), f(53), 3*f(54), 3*f(55), f(56), f(57), 3*f(58), 3*f(59) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,9))+L(6,9))
  den(2) = 1 /((L(5,18))+L(6,18))
  den(3) = 1 /((L(5,13))+L(6,13))
  den(6) = 1 /((L(5,18) - MZ2)+L(6,18))
  den(8) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(12) = 1 /((L(5,22))+L(6,22))
  den(19) = 1 /((L(5,20))+L(6,20))
  den(20) = 1 /((L(5,11))+L(6,11))
  den(23) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(34) = 1 /((L(5,34))+L(6,34))
  den(36) = 1 /((L(5,34) - MZ2)+L(6,34))
  den(40) = 1 /((L(5,38))+L(6,38))
  den(47) = 1 /((L(5,36))+L(6,36))
  den(49) = 1 /((L(5,36) - MZ2)+L(6,36))
  den(59) = 1 /((L(5,17))+L(6,17))
  den(60) = 1 /((L(5,10))+L(6,10))
  den(61) = 1 /((L(5,21))+L(6,21))
  den(64) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(66) = 1 /((L(5,17) - MZ2)+L(6,17))
  den(70) = 1 /((L(5,14))+L(6,14))
  den(89) = 1 /((L(5,33))+L(6,33))
  den(90) = 1 /((L(5,37))+L(6,37))
  den(94) = 1 /((L(5,33) - MZ2)+L(6,33))
  den(112) = 1 /((L(5,12))+L(6,12))
  den(113) = 1 /((L(5,19))+L(6,19))
  den(116) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(139) = 1 /((L(5,35))+L(6,35))
  den(208) = 1 /((L(5,41))+L(6,41))
  den(215) = 1 /((L(5,50))+L(6,50))
  den(222) = 1 /((L(5,25))+L(6,25))
  den(235) = 1 /((L(5,49))+L(6,49))
  den(242) = 1 /((L(5,42))+L(6,42))
  den(255) = 1 /((L(5,26))+L(6,26))
  den(290) = 1 /((L(5,52))+L(6,52))
  den(311) = 1 /((L(5,44))+L(6,44))
  den(322) = 1 /((L(5,28))+L(6,28))
  den(1001) = 1 /((L(5,27) - MH2)+L(6,27))
  den(1004) = 1 /((L(5,29) - MH2)+L(6,29))
  den(1007) = 1 /((L(5,43) - MH2)+L(6,43))
  den(1010) = 1 /((L(5,45) - MH2)+L(6,45))
  den(1012) = 1 /((L(5,27))+L(6,27))
  den(1014) = 1 /((L(5,27) - MZ2)+L(6,27))
  den(1018) = 1 /((L(5,43))+L(6,43))
  den(1020) = 1 /((L(5,43) - MZ2)+L(6,43))
  den(1024) = 1 /((L(5,29))+L(6,29))
  den(1026) = 1 /((L(5,29) - MZ2)+L(6,29))
  den(1030) = 1 /((L(5,45))+L(6,45))
  den(1032) = 1 /((L(5,45) - MZ2)+L(6,45))
  den(1055) = 1 /((L(5,30) - MH2)+L(6,30))
  den(1060) = 1 /((L(5,46) - MH2)+L(6,46))
  den(1078) = 1 /((L(5,30))+L(6,30))
  den(1080) = 1 /((L(5,30) - MZ2)+L(6,30))
  den(1084) = 1 /((L(5,46))+L(6,46))
  den(1086) = 1 /((L(5,46) - MZ2)+L(6,46))
  den(1139) = 1 /((L(5,51) - MH2)+L(6,51))
  den(1142) = 1 /((L(5,53) - MH2)+L(6,53))
  den(1148) = 1 /((L(5,51))+L(6,51))
  den(1150) = 1 /((L(5,51) - MZ2)+L(6,51))
  den(1158) = 1 /((L(5,53))+L(6,53))
  den(1160) = 1 /((L(5,53) - MZ2)+L(6,53))
  den(1183) = 1 /((L(5,54) - MH2)+L(6,54))
  den(1205) = 1 /((L(5,54))+L(6,54))
  den(1207) = 1 /((L(5,54) - MZ2)+L(6,54))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(4)*den(6)
  den(9) = den(3)*den(8)
  den(10) = den(2)*den(9)
  den(11) = den(6)*den(9)
  den(13) = den(2)*den(12)
  den(14) = den(1)*den(13)
  den(15) = den(6)*den(12)
  den(16) = den(1)*den(15)
  den(17) = den(8)*den(13)
  den(18) = den(8)*den(15)
  den(21) = den(1)*den(20)
  den(22) = den(19)*den(21)
  den(24) = den(21)*den(23)
  den(25) = den(8)*den(20)
  den(26) = den(19)*den(25)
  den(27) = den(23)*den(25)
  den(28) = den(12)*den(19)
  den(29) = den(1)*den(28)
  den(30) = den(12)*den(23)
  den(31) = den(1)*den(30)
  den(32) = den(8)*den(28)
  den(33) = den(8)*den(30)
  den(35) = den(4)*den(34)
  den(37) = den(4)*den(36)
  den(38) = den(9)*den(34)
  den(39) = den(9)*den(36)
  den(41) = den(34)*den(40)
  den(42) = den(1)*den(41)
  den(43) = den(36)*den(40)
  den(44) = den(1)*den(43)
  den(45) = den(8)*den(41)
  den(46) = den(8)*den(43)
  den(48) = den(21)*den(47)
  den(50) = den(21)*den(49)
  den(51) = den(25)*den(47)
  den(52) = den(25)*den(49)
  den(53) = den(40)*den(47)
  den(54) = den(1)*den(53)
  den(55) = den(40)*den(49)
  den(56) = den(1)*den(55)
  den(57) = den(8)*den(53)
  den(58) = den(8)*den(55)
  den(62) = den(59)*den(61)
  den(63) = den(60)*den(62)
  den(65) = den(62)*den(64)
  den(67) = den(61)*den(66)
  den(68) = den(60)*den(67)
  den(69) = den(64)*den(67)
  den(71) = den(60)*den(70)
  den(72) = den(59)*den(71)
  den(73) = den(64)*den(70)
  den(74) = den(59)*den(73)
  den(75) = den(66)*den(71)
  den(76) = den(66)*den(73)
  den(77) = den(20)*den(60)
  den(78) = den(19)*den(77)
  den(79) = den(23)*den(77)
  den(80) = den(20)*den(64)
  den(81) = den(19)*den(80)
  den(82) = den(23)*den(80)
  den(83) = den(19)*den(61)
  den(84) = den(60)*den(83)
  den(85) = den(64)*den(83)
  den(86) = den(23)*den(61)
  den(87) = den(60)*den(86)
  den(88) = den(64)*den(86)
  den(91) = den(89)*den(90)
  den(92) = den(60)*den(91)
  den(93) = den(64)*den(91)
  den(95) = den(90)*den(94)
  den(96) = den(60)*den(95)
  den(97) = den(64)*den(95)
  den(98) = den(71)*den(89)
  den(99) = den(73)*den(89)
  den(100) = den(71)*den(94)
  den(101) = den(73)*den(94)
  den(102) = den(47)*den(77)
  den(103) = den(49)*den(77)
  den(104) = den(47)*den(80)
  den(105) = den(49)*den(80)
  den(106) = den(47)*den(90)
  den(107) = den(60)*den(106)
  den(108) = den(64)*den(106)
  den(109) = den(49)*den(90)
  den(110) = den(60)*den(109)
  den(111) = den(64)*den(109)
  den(114) = den(59)*den(113)
  den(115) = den(112)*den(114)
  den(117) = den(114)*den(116)
  den(118) = den(66)*den(113)
  den(119) = den(112)*den(118)
  den(120) = den(116)*den(118)
  den(121) = den(70)*den(112)
  den(122) = den(59)*den(121)
  den(123) = den(70)*den(116)
  den(124) = den(59)*den(123)
  den(125) = den(66)*den(121)
  den(126) = den(66)*den(123)
  den(127) = den(2)*den(113)
  den(128) = den(112)*den(127)
  den(129) = den(116)*den(127)
  den(130) = den(6)*den(113)
  den(131) = den(112)*den(130)
  den(132) = den(116)*den(130)
  den(133) = den(3)*den(112)
  den(134) = den(2)*den(133)
  den(135) = den(6)*den(133)
  den(136) = den(3)*den(116)
  den(137) = den(2)*den(136)
  den(138) = den(6)*den(136)
  den(140) = den(89)*den(139)
  den(141) = den(112)*den(140)
  den(142) = den(116)*den(140)
  den(143) = den(94)*den(139)
  den(144) = den(112)*den(143)
  den(145) = den(116)*den(143)
  den(146) = den(89)*den(121)
  den(147) = den(89)*den(123)
  den(148) = den(94)*den(121)
  den(149) = den(94)*den(123)
  den(150) = den(34)*den(139)
  den(151) = den(112)*den(150)
  den(152) = den(116)*den(150)
  den(153) = den(36)*den(139)
  den(154) = den(112)*den(153)
  den(155) = den(116)*den(153)
  den(156) = den(34)*den(133)
  den(157) = den(36)*den(133)
  den(158) = den(34)*den(136)
  den(159) = den(36)*den(136)
  den(160) = den(34)*den(62)
  den(161) = den(36)*den(62)
  den(162) = den(34)*den(67)
  den(163) = den(36)*den(67)
  den(164) = den(41)*den(59)
  den(165) = den(43)*den(59)
  den(166) = den(41)*den(66)
  den(167) = den(43)*den(66)
  den(168) = den(47)*den(114)
  den(169) = den(49)*den(114)
  den(170) = den(47)*den(118)
  den(171) = den(49)*den(118)
  den(172) = den(53)*den(59)
  den(173) = den(55)*den(59)
  den(174) = den(53)*den(66)
  den(175) = den(55)*den(66)
  den(176) = den(2)*den(91)
  den(177) = den(6)*den(91)
  den(178) = den(2)*den(95)
  den(179) = den(6)*den(95)
  den(180) = den(13)*den(89)
  den(181) = den(15)*den(89)
  den(182) = den(13)*den(94)
  den(183) = den(15)*den(94)
  den(184) = den(47)*den(127)
  den(185) = den(49)*den(127)
  den(186) = den(47)*den(130)
  den(187) = den(49)*den(130)
  den(188) = den(2)*den(106)
  den(189) = den(6)*den(106)
  den(190) = den(2)*den(109)
  den(191) = den(6)*den(109)
  den(192) = den(19)*den(140)
  den(193) = den(23)*den(140)
  den(194) = den(19)*den(143)
  den(195) = den(23)*den(143)
  den(196) = den(28)*den(89)
  den(197) = den(30)*den(89)
  den(198) = den(28)*den(94)
  den(199) = den(30)*den(94)
  den(200) = den(19)*den(150)
  den(201) = den(23)*den(150)
  den(202) = den(19)*den(153)
  den(203) = den(23)*den(153)
  den(204) = den(34)*den(83)
  den(205) = den(36)*den(83)
  den(206) = den(34)*den(86)
  den(207) = den(36)*den(86)
  den(209) = den(1)*den(208)
  den(210) = den(2)*den(209)
  den(211) = den(6)*den(209)
  den(212) = den(8)*den(208)
  den(213) = den(2)*den(212)
  den(214) = den(6)*den(212)
  den(216) = den(2)*den(215)
  den(217) = den(1)*den(216)
  den(218) = den(6)*den(215)
  den(219) = den(1)*den(218)
  den(220) = den(8)*den(216)
  den(221) = den(8)*den(218)
  den(223) = den(1)*den(222)
  den(224) = den(34)*den(223)
  den(225) = den(36)*den(223)
  den(226) = den(8)*den(222)
  den(227) = den(34)*den(226)
  den(228) = den(36)*den(226)
  den(229) = den(34)*den(215)
  den(230) = den(1)*den(229)
  den(231) = den(36)*den(215)
  den(232) = den(1)*den(231)
  den(233) = den(8)*den(229)
  den(234) = den(8)*den(231)
  den(236) = den(59)*den(235)
  den(237) = den(60)*den(236)
  den(238) = den(64)*den(236)
  den(239) = den(66)*den(235)
  den(240) = den(60)*den(239)
  den(241) = den(64)*den(239)
  den(243) = den(60)*den(242)
  den(244) = den(59)*den(243)
  den(245) = den(64)*den(242)
  den(246) = den(59)*den(245)
  den(247) = den(66)*den(243)
  den(248) = den(66)*den(245)
  den(249) = den(89)*den(235)
  den(250) = den(60)*den(249)
  den(251) = den(64)*den(249)
  den(252) = den(94)*den(235)
  den(253) = den(60)*den(252)
  den(254) = den(64)*den(252)
  den(256) = den(60)*den(255)
  den(257) = den(89)*den(256)
  den(258) = den(64)*den(255)
  den(259) = den(89)*den(258)
  den(260) = den(94)*den(256)
  den(261) = den(94)*den(258)
  den(262) = den(59)*den(222)
  den(263) = den(34)*den(262)
  den(264) = den(36)*den(262)
  den(265) = den(66)*den(222)
  den(266) = den(34)*den(265)
  den(267) = den(36)*den(265)
  den(268) = den(34)*den(242)
  den(269) = den(59)*den(268)
  den(270) = den(36)*den(242)
  den(271) = den(59)*den(270)
  den(272) = den(66)*den(268)
  den(273) = den(66)*den(270)
  den(274) = den(89)*den(208)
  den(275) = den(2)*den(274)
  den(276) = den(6)*den(274)
  den(277) = den(94)*den(208)
  den(278) = den(2)*den(277)
  den(279) = den(6)*den(277)
  den(280) = den(2)*den(255)
  den(281) = den(89)*den(280)
  den(282) = den(6)*den(255)
  den(283) = den(89)*den(282)
  den(284) = den(94)*den(280)
  den(285) = den(94)*den(282)
  den(286) = den(19)*den(209)
  den(287) = den(23)*den(209)
  den(288) = den(19)*den(212)
  den(289) = den(23)*den(212)
  den(291) = den(19)*den(290)
  den(292) = den(1)*den(291)
  den(293) = den(23)*den(290)
  den(294) = den(1)*den(293)
  den(295) = den(8)*den(291)
  den(296) = den(8)*den(293)
  den(297) = den(47)*den(223)
  den(298) = den(49)*den(223)
  den(299) = den(47)*den(226)
  den(300) = den(49)*den(226)
  den(301) = den(47)*den(290)
  den(302) = den(1)*den(301)
  den(303) = den(49)*den(290)
  den(304) = den(1)*den(303)
  den(305) = den(8)*den(301)
  den(306) = den(8)*den(303)
  den(307) = den(112)*den(236)
  den(308) = den(116)*den(236)
  den(309) = den(112)*den(239)
  den(310) = den(116)*den(239)
  den(312) = den(112)*den(311)
  den(313) = den(59)*den(312)
  den(314) = den(116)*den(311)
  den(315) = den(59)*den(314)
  den(316) = den(66)*den(312)
  den(317) = den(66)*den(314)
  den(318) = den(112)*den(249)
  den(319) = den(116)*den(249)
  den(320) = den(112)*den(252)
  den(321) = den(116)*den(252)
  den(323) = den(112)*den(322)
  den(324) = den(89)*den(323)
  den(325) = den(116)*den(322)
  den(326) = den(89)*den(325)
  den(327) = den(94)*den(323)
  den(328) = den(94)*den(325)
  den(329) = den(47)*den(262)
  den(330) = den(49)*den(262)
  den(331) = den(47)*den(265)
  den(332) = den(49)*den(265)
  den(333) = den(47)*den(311)
  den(334) = den(59)*den(333)
  den(335) = den(49)*den(311)
  den(336) = den(59)*den(335)
  den(337) = den(66)*den(333)
  den(338) = den(66)*den(335)
  den(339) = den(19)*den(274)
  den(340) = den(23)*den(274)
  den(341) = den(19)*den(277)
  den(342) = den(23)*den(277)
  den(343) = den(19)*den(322)
  den(344) = den(89)*den(343)
  den(345) = den(23)*den(322)
  den(346) = den(89)*den(345)
  den(347) = den(94)*den(343)
  den(348) = den(94)*den(345)
  den(349) = den(60)*den(291)
  den(350) = den(60)*den(293)
  den(351) = den(64)*den(291)
  den(352) = den(64)*den(293)
  den(353) = den(19)*den(243)
  den(354) = den(19)*den(245)
  den(355) = den(23)*den(243)
  den(356) = den(23)*den(245)
  den(357) = den(60)*den(301)
  den(358) = den(60)*den(303)
  den(359) = den(64)*den(301)
  den(360) = den(64)*den(303)
  den(361) = den(47)*den(256)
  den(362) = den(47)*den(258)
  den(363) = den(49)*den(256)
  den(364) = den(49)*den(258)
  den(365) = den(2)*den(312)
  den(366) = den(2)*den(314)
  den(367) = den(6)*den(312)
  den(368) = den(6)*den(314)
  den(369) = den(112)*den(216)
  den(370) = den(112)*den(218)
  den(371) = den(116)*den(216)
  den(372) = den(116)*den(218)
  den(373) = den(34)*den(323)
  den(374) = den(34)*den(325)
  den(375) = den(36)*den(323)
  den(376) = den(36)*den(325)
  den(377) = den(112)*den(229)
  den(378) = den(112)*den(231)
  den(379) = den(116)*den(229)
  den(380) = den(116)*den(231)
  den(381) = den(2)*den(333)
  den(382) = den(2)*den(335)
  den(383) = den(6)*den(333)
  den(384) = den(6)*den(335)
  den(385) = den(47)*den(280)
  den(386) = den(47)*den(282)
  den(387) = den(49)*den(280)
  den(388) = den(49)*den(282)
  den(389) = den(34)*den(343)
  den(390) = den(34)*den(345)
  den(391) = den(36)*den(343)
  den(392) = den(36)*den(345)
  den(393) = den(19)*den(268)
  den(394) = den(19)*den(270)
  den(395) = den(23)*den(268)
  den(396) = den(23)*den(270)
  den(397) = den(1)**2
  den(398) = den(216)*den(397)
  den(399) = den(218)*den(397)
  den(400) = den(1)*den(8)
  den(401) = den(216)*den(400)
  den(402) = den(218)*den(400)
  den(403) = den(8)**2
  den(404) = den(216)*den(403)
  den(405) = den(218)*den(403)
  den(406) = den(13)*den(397)
  den(407) = den(15)*den(397)
  den(408) = den(13)*den(400)
  den(409) = den(15)*den(400)
  den(410) = den(13)*den(403)
  den(411) = den(15)*den(403)
  den(412) = den(2)**2
  den(413) = den(209)*den(412)
  den(414) = den(212)*den(412)
  den(415) = den(2)*den(6)
  den(416) = den(209)*den(415)
  den(417) = den(212)*den(415)
  den(418) = den(6)**2
  den(419) = den(209)*den(418)
  den(420) = den(212)*den(418)
  den(421) = den(4)*den(412)
  den(422) = den(9)*den(412)
  den(423) = den(4)*den(415)
  den(424) = den(9)*den(415)
  den(425) = den(4)*den(418)
  den(426) = den(9)*den(418)
  den(427) = den(4)*den(216)
  den(428) = den(4)*den(218)
  den(429) = den(9)*den(216)
  den(430) = den(9)*den(218)
  den(431) = den(13)*den(209)
  den(432) = den(15)*den(209)
  den(433) = den(13)*den(212)
  den(434) = den(15)*den(212)
  den(435) = den(291)*den(397)
  den(436) = den(293)*den(397)
  den(437) = den(291)*den(400)
  den(438) = den(293)*den(400)
  den(439) = den(291)*den(403)
  den(440) = den(293)*den(403)
  den(441) = den(28)*den(397)
  den(442) = den(30)*den(397)
  den(443) = den(28)*den(400)
  den(444) = den(30)*den(400)
  den(445) = den(28)*den(403)
  den(446) = den(30)*den(403)
  den(447) = den(19)**2
  den(448) = den(209)*den(447)
  den(449) = den(212)*den(447)
  den(450) = den(19)*den(23)
  den(451) = den(209)*den(450)
  den(452) = den(212)*den(450)
  den(453) = den(23)**2
  den(454) = den(209)*den(453)
  den(455) = den(212)*den(453)
  den(456) = den(21)*den(291)
  den(457) = den(21)*den(293)
  den(458) = den(25)*den(291)
  den(459) = den(25)*den(293)
  den(460) = den(28)*den(209)
  den(461) = den(30)*den(209)
  den(462) = den(28)*den(212)
  den(463) = den(30)*den(212)
  den(464) = den(21)*den(447)
  den(465) = den(25)*den(447)
  den(466) = den(21)*den(450)
  den(467) = den(25)*den(450)
  den(468) = den(21)*den(453)
  den(469) = den(25)*den(453)
  den(470) = den(229)*den(397)
  den(471) = den(231)*den(397)
  den(472) = den(229)*den(400)
  den(473) = den(231)*den(400)
  den(474) = den(229)*den(403)
  den(475) = den(231)*den(403)
  den(476) = den(41)*den(397)
  den(477) = den(43)*den(397)
  den(478) = den(41)*den(400)
  den(479) = den(43)*den(400)
  den(480) = den(41)*den(403)
  den(481) = den(43)*den(403)
  den(482) = den(34)**2
  den(483) = den(223)*den(482)
  den(484) = den(226)*den(482)
  den(485) = den(34)*den(36)
  den(486) = den(223)*den(485)
  den(487) = den(226)*den(485)
  den(488) = den(36)**2
  den(489) = den(223)*den(488)
  den(490) = den(226)*den(488)
  den(491) = den(4)*den(482)
  den(492) = den(9)*den(482)
  den(493) = den(4)*den(485)
  den(494) = den(9)*den(485)
  den(495) = den(4)*den(488)
  den(496) = den(9)*den(488)
  den(497) = den(4)*den(229)
  den(498) = den(4)*den(231)
  den(499) = den(9)*den(229)
  den(500) = den(9)*den(231)
  den(501) = den(41)*den(223)
  den(502) = den(43)*den(223)
  den(503) = den(41)*den(226)
  den(504) = den(43)*den(226)
  den(505) = den(301)*den(397)
  den(506) = den(303)*den(397)
  den(507) = den(301)*den(400)
  den(508) = den(303)*den(400)
  den(509) = den(301)*den(403)
  den(510) = den(303)*den(403)
  den(511) = den(53)*den(397)
  den(512) = den(55)*den(397)
  den(513) = den(53)*den(400)
  den(514) = den(55)*den(400)
  den(515) = den(53)*den(403)
  den(516) = den(55)*den(403)
  den(517) = den(47)**2
  den(518) = den(223)*den(517)
  den(519) = den(226)*den(517)
  den(520) = den(47)*den(49)
  den(521) = den(223)*den(520)
  den(522) = den(226)*den(520)
  den(523) = den(49)**2
  den(524) = den(223)*den(523)
  den(525) = den(226)*den(523)
  den(526) = den(21)*den(301)
  den(527) = den(21)*den(303)
  den(528) = den(25)*den(301)
  den(529) = den(25)*den(303)
  den(530) = den(53)*den(223)
  den(531) = den(55)*den(223)
  den(532) = den(53)*den(226)
  den(533) = den(55)*den(226)
  den(534) = den(21)*den(517)
  den(535) = den(25)*den(517)
  den(536) = den(21)*den(520)
  den(537) = den(25)*den(520)
  den(538) = den(21)*den(523)
  den(539) = den(25)*den(523)
  den(540) = den(59)**2
  den(541) = den(243)*den(540)
  den(542) = den(245)*den(540)
  den(543) = den(59)*den(66)
  den(544) = den(243)*den(543)
  den(545) = den(245)*den(543)
  den(546) = den(66)**2
  den(547) = den(243)*den(546)
  den(548) = den(245)*den(546)
  den(549) = den(71)*den(540)
  den(550) = den(73)*den(540)
  den(551) = den(71)*den(543)
  den(552) = den(73)*den(543)
  den(553) = den(71)*den(546)
  den(554) = den(73)*den(546)
  den(555) = den(60)**2
  den(556) = den(236)*den(555)
  den(557) = den(239)*den(555)
  den(558) = den(60)*den(64)
  den(559) = den(236)*den(558)
  den(560) = den(239)*den(558)
  den(561) = den(64)**2
  den(562) = den(236)*den(561)
  den(563) = den(239)*den(561)
  den(564) = den(62)*den(555)
  den(565) = den(67)*den(555)
  den(566) = den(62)*den(558)
  den(567) = den(67)*den(558)
  den(568) = den(62)*den(561)
  den(569) = den(67)*den(561)
  den(570) = den(62)*den(243)
  den(571) = den(62)*den(245)
  den(572) = den(67)*den(243)
  den(573) = den(67)*den(245)
  den(574) = den(71)*den(236)
  den(575) = den(73)*den(236)
  den(576) = den(71)*den(239)
  den(577) = den(73)*den(239)
  den(578) = den(291)*den(555)
  den(579) = den(293)*den(555)
  den(580) = den(291)*den(558)
  den(581) = den(293)*den(558)
  den(582) = den(291)*den(561)
  den(583) = den(293)*den(561)
  den(584) = den(243)*den(447)
  den(585) = den(245)*den(447)
  den(586) = den(243)*den(450)
  den(587) = den(245)*den(450)
  den(588) = den(243)*den(453)
  den(589) = den(245)*den(453)
  den(590) = den(77)*den(291)
  den(591) = den(77)*den(293)
  den(592) = den(80)*den(291)
  den(593) = den(80)*den(293)
  den(594) = den(83)*den(243)
  den(595) = den(83)*den(245)
  den(596) = den(86)*den(243)
  den(597) = den(86)*den(245)
  den(598) = den(83)*den(555)
  den(599) = den(86)*den(555)
  den(600) = den(83)*den(558)
  den(601) = den(86)*den(558)
  den(602) = den(83)*den(561)
  den(603) = den(86)*den(561)
  den(604) = den(77)*den(447)
  den(605) = den(80)*den(447)
  den(606) = den(77)*den(450)
  den(607) = den(80)*den(450)
  den(608) = den(77)*den(453)
  den(609) = den(80)*den(453)
  den(610) = den(89)**2
  den(611) = den(256)*den(610)
  den(612) = den(258)*den(610)
  den(613) = den(89)*den(94)
  den(614) = den(256)*den(613)
  den(615) = den(258)*den(613)
  den(616) = den(94)**2
  den(617) = den(256)*den(616)
  den(618) = den(258)*den(616)
  den(619) = den(71)*den(610)
  den(620) = den(73)*den(610)
  den(621) = den(71)*den(613)
  den(622) = den(73)*den(613)
  den(623) = den(71)*den(616)
  den(624) = den(73)*den(616)
  den(625) = den(249)*den(555)
  den(626) = den(252)*den(555)
  den(627) = den(249)*den(558)
  den(628) = den(252)*den(558)
  den(629) = den(249)*den(561)
  den(630) = den(252)*den(561)
  den(631) = den(91)*den(555)
  den(632) = den(95)*den(555)
  den(633) = den(91)*den(558)
  den(634) = den(95)*den(558)
  den(635) = den(91)*den(561)
  den(636) = den(95)*den(561)
  den(637) = den(91)*den(256)
  den(638) = den(91)*den(258)
  den(639) = den(95)*den(256)
  den(640) = den(95)*den(258)
  den(641) = den(71)*den(249)
  den(642) = den(73)*den(249)
  den(643) = den(71)*den(252)
  den(644) = den(73)*den(252)
  den(645) = den(301)*den(555)
  den(646) = den(303)*den(555)
  den(647) = den(301)*den(558)
  den(648) = den(303)*den(558)
  den(649) = den(301)*den(561)
  den(650) = den(303)*den(561)
  den(651) = den(256)*den(517)
  den(652) = den(258)*den(517)
  den(653) = den(256)*den(520)
  den(654) = den(258)*den(520)
  den(655) = den(256)*den(523)
  den(656) = den(258)*den(523)
  den(657) = den(77)*den(301)
  den(658) = den(77)*den(303)
  den(659) = den(80)*den(301)
  den(660) = den(80)*den(303)
  den(661) = den(106)*den(256)
  den(662) = den(106)*den(258)
  den(663) = den(109)*den(256)
  den(664) = den(109)*den(258)
  den(665) = den(106)*den(555)
  den(666) = den(109)*den(555)
  den(667) = den(106)*den(558)
  den(668) = den(109)*den(558)
  den(669) = den(106)*den(561)
  den(670) = den(109)*den(561)
  den(671) = den(77)*den(517)
  den(672) = den(80)*den(517)
  den(673) = den(77)*den(520)
  den(674) = den(80)*den(520)
  den(675) = den(77)*den(523)
  den(676) = den(80)*den(523)
  den(677) = den(312)*den(540)
  den(678) = den(314)*den(540)
  den(679) = den(312)*den(543)
  den(680) = den(314)*den(543)
  den(681) = den(312)*den(546)
  den(682) = den(314)*den(546)
  den(683) = den(121)*den(540)
  den(684) = den(123)*den(540)
  den(685) = den(121)*den(543)
  den(686) = den(123)*den(543)
  den(687) = den(121)*den(546)
  den(688) = den(123)*den(546)
  den(689) = den(112)**2
  den(690) = den(236)*den(689)
  den(691) = den(239)*den(689)
  den(692) = den(112)*den(116)
  den(693) = den(236)*den(692)
  den(694) = den(239)*den(692)
  den(695) = den(116)**2
  den(696) = den(236)*den(695)
  den(697) = den(239)*den(695)
  den(698) = den(114)*den(312)
  den(699) = den(114)*den(314)
  den(700) = den(118)*den(312)
  den(701) = den(118)*den(314)
  den(702) = den(121)*den(236)
  den(703) = den(123)*den(236)
  den(704) = den(121)*den(239)
  den(705) = den(123)*den(239)
  den(706) = den(114)*den(689)
  den(707) = den(118)*den(689)
  den(708) = den(114)*den(692)
  den(709) = den(118)*den(692)
  den(710) = den(114)*den(695)
  den(711) = den(118)*den(695)
  den(712) = den(312)*den(412)
  den(713) = den(314)*den(412)
  den(714) = den(312)*den(415)
  den(715) = den(314)*den(415)
  den(716) = den(312)*den(418)
  den(717) = den(314)*den(418)
  den(718) = den(216)*den(689)
  den(719) = den(218)*den(689)
  den(720) = den(216)*den(692)
  den(721) = den(218)*den(692)
  den(722) = den(216)*den(695)
  den(723) = den(218)*den(695)
  den(724) = den(127)*den(312)
  den(725) = den(127)*den(314)
  den(726) = den(130)*den(312)
  den(727) = den(130)*den(314)
  den(728) = den(133)*den(216)
  den(729) = den(133)*den(218)
  den(730) = den(136)*den(216)
  den(731) = den(136)*den(218)
  den(732) = den(133)*den(412)
  den(733) = den(136)*den(412)
  den(734) = den(133)*den(415)
  den(735) = den(136)*den(415)
  den(736) = den(133)*den(418)
  den(737) = den(136)*den(418)
  den(738) = den(127)*den(689)
  den(739) = den(130)*den(689)
  den(740) = den(127)*den(692)
  den(741) = den(130)*den(692)
  den(742) = den(127)*den(695)
  den(743) = den(130)*den(695)
  den(744) = den(323)*den(610)
  den(745) = den(325)*den(610)
  den(746) = den(323)*den(613)
  den(747) = den(325)*den(613)
  den(748) = den(323)*den(616)
  den(749) = den(325)*den(616)
  den(750) = den(121)*den(610)
  den(751) = den(123)*den(610)
  den(752) = den(121)*den(613)
  den(753) = den(123)*den(613)
  den(754) = den(121)*den(616)
  den(755) = den(123)*den(616)
  den(756) = den(249)*den(689)
  den(757) = den(252)*den(689)
  den(758) = den(249)*den(692)
  den(759) = den(252)*den(692)
  den(760) = den(249)*den(695)
  den(761) = den(252)*den(695)
  den(762) = den(140)*den(323)
  den(763) = den(140)*den(325)
  den(764) = den(143)*den(323)
  den(765) = den(143)*den(325)
  den(766) = den(121)*den(249)
  den(767) = den(123)*den(249)
  den(768) = den(121)*den(252)
  den(769) = den(123)*den(252)
  den(770) = den(140)*den(689)
  den(771) = den(143)*den(689)
  den(772) = den(140)*den(692)
  den(773) = den(143)*den(692)
  den(774) = den(140)*den(695)
  den(775) = den(143)*den(695)
  den(776) = den(323)*den(482)
  den(777) = den(325)*den(482)
  den(778) = den(323)*den(485)
  den(779) = den(325)*den(485)
  den(780) = den(323)*den(488)
  den(781) = den(325)*den(488)
  den(782) = den(229)*den(689)
  den(783) = den(231)*den(689)
  den(784) = den(229)*den(692)
  den(785) = den(231)*den(692)
  den(786) = den(229)*den(695)
  den(787) = den(231)*den(695)
  den(788) = den(150)*den(323)
  den(789) = den(150)*den(325)
  den(790) = den(153)*den(323)
  den(791) = den(153)*den(325)
  den(792) = den(133)*den(229)
  den(793) = den(133)*den(231)
  den(794) = den(136)*den(229)
  den(795) = den(136)*den(231)
  den(796) = den(133)*den(482)
  den(797) = den(136)*den(482)
  den(798) = den(133)*den(485)
  den(799) = den(136)*den(485)
  den(800) = den(133)*den(488)
  den(801) = den(136)*den(488)
  den(802) = den(150)*den(689)
  den(803) = den(153)*den(689)
  den(804) = den(150)*den(692)
  den(805) = den(153)*den(692)
  den(806) = den(150)*den(695)
  den(807) = den(153)*den(695)
  den(808) = den(268)*den(540)
  den(809) = den(270)*den(540)
  den(810) = den(268)*den(543)
  den(811) = den(270)*den(543)
  den(812) = den(268)*den(546)
  den(813) = den(270)*den(546)
  den(814) = den(41)*den(540)
  den(815) = den(43)*den(540)
  den(816) = den(41)*den(543)
  den(817) = den(43)*den(543)
  den(818) = den(41)*den(546)
  den(819) = den(43)*den(546)
  den(820) = den(262)*den(482)
  den(821) = den(265)*den(482)
  den(822) = den(262)*den(485)
  den(823) = den(265)*den(485)
  den(824) = den(262)*den(488)
  den(825) = den(265)*den(488)
  den(826) = den(62)*den(482)
  den(827) = den(67)*den(482)
  den(828) = den(62)*den(485)
  den(829) = den(67)*den(485)
  den(830) = den(62)*den(488)
  den(831) = den(67)*den(488)
  den(832) = den(62)*den(268)
  den(833) = den(62)*den(270)
  den(834) = den(67)*den(268)
  den(835) = den(67)*den(270)
  den(836) = den(41)*den(262)
  den(837) = den(43)*den(262)
  den(838) = den(41)*den(265)
  den(839) = den(43)*den(265)
  den(840) = den(333)*den(540)
  den(841) = den(335)*den(540)
  den(842) = den(333)*den(543)
  den(843) = den(335)*den(543)
  den(844) = den(333)*den(546)
  den(845) = den(335)*den(546)
  den(846) = den(53)*den(540)
  den(847) = den(55)*den(540)
  den(848) = den(53)*den(543)
  den(849) = den(55)*den(543)
  den(850) = den(53)*den(546)
  den(851) = den(55)*den(546)
  den(852) = den(262)*den(517)
  den(853) = den(265)*den(517)
  den(854) = den(262)*den(520)
  den(855) = den(265)*den(520)
  den(856) = den(262)*den(523)
  den(857) = den(265)*den(523)
  den(858) = den(114)*den(333)
  den(859) = den(114)*den(335)
  den(860) = den(118)*den(333)
  den(861) = den(118)*den(335)
  den(862) = den(53)*den(262)
  den(863) = den(55)*den(262)
  den(864) = den(53)*den(265)
  den(865) = den(55)*den(265)
  den(866) = den(114)*den(517)
  den(867) = den(118)*den(517)
  den(868) = den(114)*den(520)
  den(869) = den(118)*den(520)
  den(870) = den(114)*den(523)
  den(871) = den(118)*den(523)
  den(872) = den(280)*den(610)
  den(873) = den(282)*den(610)
  den(874) = den(280)*den(613)
  den(875) = den(282)*den(613)
  den(876) = den(280)*den(616)
  den(877) = den(282)*den(616)
  den(878) = den(13)*den(610)
  den(879) = den(15)*den(610)
  den(880) = den(13)*den(613)
  den(881) = den(15)*den(613)
  den(882) = den(13)*den(616)
  den(883) = den(15)*den(616)
  den(884) = den(274)*den(412)
  den(885) = den(277)*den(412)
  den(886) = den(274)*den(415)
  den(887) = den(277)*den(415)
  den(888) = den(274)*den(418)
  den(889) = den(277)*den(418)
  den(890) = den(91)*den(412)
  den(891) = den(95)*den(412)
  den(892) = den(91)*den(415)
  den(893) = den(95)*den(415)
  den(894) = den(91)*den(418)
  den(895) = den(95)*den(418)
  den(896) = den(91)*den(280)
  den(897) = den(91)*den(282)
  den(898) = den(95)*den(280)
  den(899) = den(95)*den(282)
  den(900) = den(13)*den(274)
  den(901) = den(15)*den(274)
  den(902) = den(13)*den(277)
  den(903) = den(15)*den(277)
  den(904) = den(333)*den(412)
  den(905) = den(335)*den(412)
  den(906) = den(333)*den(415)
  den(907) = den(335)*den(415)
  den(908) = den(333)*den(418)
  den(909) = den(335)*den(418)
  den(910) = den(280)*den(517)
  den(911) = den(282)*den(517)
  den(912) = den(280)*den(520)
  den(913) = den(282)*den(520)
  den(914) = den(280)*den(523)
  den(915) = den(282)*den(523)
  den(916) = den(127)*den(333)
  den(917) = den(127)*den(335)
  den(918) = den(130)*den(333)
  den(919) = den(130)*den(335)
  den(920) = den(106)*den(280)
  den(921) = den(106)*den(282)
  den(922) = den(109)*den(280)
  den(923) = den(109)*den(282)
  den(924) = den(106)*den(412)
  den(925) = den(109)*den(412)
  den(926) = den(106)*den(415)
  den(927) = den(109)*den(415)
  den(928) = den(106)*den(418)
  den(929) = den(109)*den(418)
  den(930) = den(127)*den(517)
  den(931) = den(130)*den(517)
  den(932) = den(127)*den(520)
  den(933) = den(130)*den(520)
  den(934) = den(127)*den(523)
  den(935) = den(130)*den(523)
  den(936) = den(343)*den(610)
  den(937) = den(345)*den(610)
  den(938) = den(343)*den(613)
  den(939) = den(345)*den(613)
  den(940) = den(343)*den(616)
  den(941) = den(345)*den(616)
  den(942) = den(28)*den(610)
  den(943) = den(30)*den(610)
  den(944) = den(28)*den(613)
  den(945) = den(30)*den(613)
  den(946) = den(28)*den(616)
  den(947) = den(30)*den(616)
  den(948) = den(274)*den(447)
  den(949) = den(277)*den(447)
  den(950) = den(274)*den(450)
  den(951) = den(277)*den(450)
  den(952) = den(274)*den(453)
  den(953) = den(277)*den(453)
  den(954) = den(140)*den(343)
  den(955) = den(140)*den(345)
  den(956) = den(143)*den(343)
  den(957) = den(143)*den(345)
  den(958) = den(28)*den(274)
  den(959) = den(30)*den(274)
  den(960) = den(28)*den(277)
  den(961) = den(30)*den(277)
  den(962) = den(140)*den(447)
  den(963) = den(143)*den(447)
  den(964) = den(140)*den(450)
  den(965) = den(143)*den(450)
  den(966) = den(140)*den(453)
  den(967) = den(143)*den(453)
  den(968) = den(343)*den(482)
  den(969) = den(345)*den(482)
  den(970) = den(343)*den(485)
  den(971) = den(345)*den(485)
  den(972) = den(343)*den(488)
  den(973) = den(345)*den(488)
  den(974) = den(268)*den(447)
  den(975) = den(270)*den(447)
  den(976) = den(268)*den(450)
  den(977) = den(270)*den(450)
  den(978) = den(268)*den(453)
  den(979) = den(270)*den(453)
  den(980) = den(150)*den(343)
  den(981) = den(150)*den(345)
  den(982) = den(153)*den(343)
  den(983) = den(153)*den(345)
  den(984) = den(83)*den(268)
  den(985) = den(83)*den(270)
  den(986) = den(86)*den(268)
  den(987) = den(86)*den(270)
  den(988) = den(83)*den(482)
  den(989) = den(86)*den(482)
  den(990) = den(83)*den(485)
  den(991) = den(86)*den(485)
  den(992) = den(83)*den(488)
  den(993) = den(86)*den(488)
  den(994) = den(150)*den(447)
  den(995) = den(153)*den(447)
  den(996) = den(150)*den(450)
  den(997) = den(153)*den(450)
  den(998) = den(150)*den(453)
  den(999) = den(153)*den(453)
  den(1000) = den(6)*den(8)
  den(1002) = den(1000)*den(1001)
  den(1003) = den(8)*den(23)
  den(1005) = den(1003)*den(1004)
  den(1006) = den(8)*den(36)
  den(1008) = den(1006)*den(1007)
  den(1009) = den(8)*den(49)
  den(1011) = den(1009)*den(1010)
  den(1013) = den(21)*den(1012)
  den(1015) = den(21)*den(1014)
  den(1016) = den(25)*den(1012)
  den(1017) = den(25)*den(1014)
  den(1019) = den(21)*den(1018)
  den(1021) = den(21)*den(1020)
  den(1022) = den(25)*den(1018)
  den(1023) = den(25)*den(1020)
  den(1025) = den(4)*den(1024)
  den(1027) = den(4)*den(1026)
  den(1028) = den(9)*den(1024)
  den(1029) = den(9)*den(1026)
  den(1031) = den(4)*den(1030)
  den(1033) = den(4)*den(1032)
  den(1034) = den(9)*den(1030)
  den(1035) = den(9)*den(1032)
  den(1036) = den(223)*den(1012)
  den(1037) = den(223)*den(1014)
  den(1038) = den(226)*den(1012)
  den(1039) = den(226)*den(1014)
  den(1040) = den(223)*den(1024)
  den(1041) = den(223)*den(1026)
  den(1042) = den(226)*den(1024)
  den(1043) = den(226)*den(1026)
  den(1044) = den(209)*den(1018)
  den(1045) = den(209)*den(1020)
  den(1046) = den(212)*den(1018)
  den(1047) = den(212)*den(1020)
  den(1048) = den(209)*den(1030)
  den(1049) = den(209)*den(1032)
  den(1050) = den(212)*den(1030)
  den(1051) = den(212)*den(1032)
  den(1052) = den(64)*den(66)
  den(1053) = den(1001)*den(1052)
  den(1054) = den(23)*den(64)
  den(1056) = den(1054)*den(1055)
  den(1057) = den(64)*den(94)
  den(1058) = den(1007)*den(1057)
  den(1059) = den(49)*den(64)
  den(1061) = den(1059)*den(1060)
  den(1062) = den(77)*den(1012)
  den(1063) = den(77)*den(1014)
  den(1064) = den(80)*den(1012)
  den(1065) = den(80)*den(1014)
  den(1066) = den(77)*den(1018)
  den(1067) = den(77)*den(1020)
  den(1068) = den(80)*den(1018)
  den(1069) = den(80)*den(1020)
  den(1070) = den(256)*den(1012)
  den(1071) = den(258)*den(1012)
  den(1072) = den(256)*den(1014)
  den(1073) = den(258)*den(1014)
  den(1074) = den(243)*den(1018)
  den(1075) = den(245)*den(1018)
  den(1076) = den(243)*den(1020)
  den(1077) = den(245)*den(1020)
  den(1079) = den(71)*den(1078)
  den(1081) = den(71)*den(1080)
  den(1082) = den(73)*den(1078)
  den(1083) = den(73)*den(1080)
  den(1085) = den(71)*den(1084)
  den(1087) = den(71)*den(1086)
  den(1088) = den(73)*den(1084)
  den(1089) = den(73)*den(1086)
  den(1090) = den(256)*den(1078)
  den(1091) = den(256)*den(1080)
  den(1092) = den(258)*den(1078)
  den(1093) = den(258)*den(1080)
  den(1094) = den(243)*den(1084)
  den(1095) = den(243)*den(1086)
  den(1096) = den(245)*den(1084)
  den(1097) = den(245)*den(1086)
  den(1098) = den(66)*den(116)
  den(1099) = den(1004)*den(1098)
  den(1100) = den(6)*den(116)
  den(1101) = den(1055)*den(1100)
  den(1102) = den(94)*den(116)
  den(1103) = den(1010)*den(1102)
  den(1104) = den(36)*den(116)
  den(1105) = den(1060)*den(1104)
  den(1106) = den(133)*den(1024)
  den(1107) = den(133)*den(1026)
  den(1108) = den(136)*den(1024)
  den(1109) = den(136)*den(1026)
  den(1110) = den(133)*den(1030)
  den(1111) = den(133)*den(1032)
  den(1112) = den(136)*den(1030)
  den(1113) = den(136)*den(1032)
  den(1114) = den(323)*den(1024)
  den(1115) = den(325)*den(1024)
  den(1116) = den(323)*den(1026)
  den(1117) = den(325)*den(1026)
  den(1118) = den(312)*den(1030)
  den(1119) = den(314)*den(1030)
  den(1120) = den(312)*den(1032)
  den(1121) = den(314)*den(1032)
  den(1122) = den(121)*den(1078)
  den(1123) = den(121)*den(1080)
  den(1124) = den(123)*den(1078)
  den(1125) = den(123)*den(1080)
  den(1126) = den(121)*den(1084)
  den(1127) = den(121)*den(1086)
  den(1128) = den(123)*den(1084)
  den(1129) = den(123)*den(1086)
  den(1130) = den(323)*den(1078)
  den(1131) = den(325)*den(1078)
  den(1132) = den(323)*den(1080)
  den(1133) = den(325)*den(1080)
  den(1134) = den(312)*den(1084)
  den(1135) = den(314)*den(1084)
  den(1136) = den(312)*den(1086)
  den(1137) = den(314)*den(1086)
  den(1138) = den(36)*den(66)
  den(1140) = den(1138)*den(1139)
  den(1141) = den(49)*den(66)
  den(1143) = den(1141)*den(1142)
  den(1144) = den(114)*den(1012)
  den(1145) = den(114)*den(1014)
  den(1146) = den(118)*den(1012)
  den(1147) = den(118)*den(1014)
  den(1149) = den(114)*den(1148)
  den(1151) = den(114)*den(1150)
  den(1152) = den(118)*den(1148)
  den(1153) = den(118)*den(1150)
  den(1154) = den(62)*den(1024)
  den(1155) = den(62)*den(1026)
  den(1156) = den(67)*den(1024)
  den(1157) = den(67)*den(1026)
  den(1159) = den(62)*den(1158)
  den(1161) = den(62)*den(1160)
  den(1162) = den(67)*den(1158)
  den(1163) = den(67)*den(1160)
  den(1164) = den(262)*den(1012)
  den(1165) = den(262)*den(1014)
  den(1166) = den(265)*den(1012)
  den(1167) = den(265)*den(1014)
  den(1168) = den(262)*den(1024)
  den(1169) = den(262)*den(1026)
  den(1170) = den(265)*den(1024)
  den(1171) = den(265)*den(1026)
  den(1172) = den(236)*den(1148)
  den(1173) = den(236)*den(1150)
  den(1174) = den(239)*den(1148)
  den(1175) = den(239)*den(1150)
  den(1176) = den(236)*den(1158)
  den(1177) = den(236)*den(1160)
  den(1178) = den(239)*den(1158)
  den(1179) = den(239)*den(1160)
  den(1180) = den(6)*den(94)
  den(1181) = den(1139)*den(1180)
  den(1182) = den(6)*den(49)
  den(1184) = den(1182)*den(1183)
  den(1185) = den(127)*den(1012)
  den(1186) = den(127)*den(1014)
  den(1187) = den(130)*den(1012)
  den(1188) = den(130)*den(1014)
  den(1189) = den(127)*den(1148)
  den(1190) = den(127)*den(1150)
  den(1191) = den(130)*den(1148)
  den(1192) = den(130)*den(1150)
  den(1193) = den(280)*den(1012)
  den(1194) = den(282)*den(1012)
  den(1195) = den(280)*den(1014)
  den(1196) = den(282)*den(1014)
  den(1197) = den(216)*den(1148)
  den(1198) = den(218)*den(1148)
  den(1199) = den(216)*den(1150)
  den(1200) = den(218)*den(1150)
  den(1201) = den(13)*den(1078)
  den(1202) = den(13)*den(1080)
  den(1203) = den(15)*den(1078)
  den(1204) = den(15)*den(1080)
  den(1206) = den(13)*den(1205)
  den(1208) = den(13)*den(1207)
  den(1209) = den(15)*den(1205)
  den(1210) = den(15)*den(1207)
  den(1211) = den(280)*den(1078)
  den(1212) = den(280)*den(1080)
  den(1213) = den(282)*den(1078)
  den(1214) = den(282)*den(1080)
  den(1215) = den(216)*den(1205)
  den(1216) = den(216)*den(1207)
  den(1217) = den(218)*den(1205)
  den(1218) = den(218)*den(1207)
  den(1219) = den(23)*den(94)
  den(1220) = den(1142)*den(1219)
  den(1221) = den(23)*den(36)
  den(1222) = den(1183)*den(1221)
  den(1223) = den(83)*den(1024)
  den(1224) = den(83)*den(1026)
  den(1225) = den(86)*den(1024)
  den(1226) = den(86)*den(1026)
  den(1227) = den(83)*den(1158)
  den(1228) = den(83)*den(1160)
  den(1229) = den(86)*den(1158)
  den(1230) = den(86)*den(1160)
  den(1231) = den(343)*den(1024)
  den(1232) = den(345)*den(1024)
  den(1233) = den(343)*den(1026)
  den(1234) = den(345)*den(1026)
  den(1235) = den(291)*den(1158)
  den(1236) = den(293)*den(1158)
  den(1237) = den(291)*den(1160)
  den(1238) = den(293)*den(1160)
  den(1239) = den(28)*den(1078)
  den(1240) = den(28)*den(1080)
  den(1241) = den(30)*den(1078)
  den(1242) = den(30)*den(1080)
  den(1243) = den(28)*den(1205)
  den(1244) = den(28)*den(1207)
  den(1245) = den(30)*den(1205)
  den(1246) = den(30)*den(1207)
  den(1247) = den(343)*den(1078)
  den(1248) = den(345)*den(1078)
  den(1249) = den(343)*den(1080)
  den(1250) = den(345)*den(1080)
  den(1251) = den(291)*den(1205)
  den(1252) = den(293)*den(1205)
  den(1253) = den(291)*den(1207)
  den(1254) = den(293)*den(1207)
  den(1255) = den(140)*den(1018)
  den(1256) = den(140)*den(1020)
  den(1257) = den(143)*den(1018)
  den(1258) = den(143)*den(1020)
  den(1259) = den(140)*den(1148)
  den(1260) = den(140)*den(1150)
  den(1261) = den(143)*den(1148)
  den(1262) = den(143)*den(1150)
  den(1263) = den(91)*den(1030)
  den(1264) = den(91)*den(1032)
  den(1265) = den(95)*den(1030)
  den(1266) = den(95)*den(1032)
  den(1267) = den(91)*den(1158)
  den(1268) = den(91)*den(1160)
  den(1269) = den(95)*den(1158)
  den(1270) = den(95)*den(1160)
  den(1271) = den(274)*den(1018)
  den(1272) = den(274)*den(1020)
  den(1273) = den(277)*den(1018)
  den(1274) = den(277)*den(1020)
  den(1275) = den(274)*den(1030)
  den(1276) = den(274)*den(1032)
  den(1277) = den(277)*den(1030)
  den(1278) = den(277)*den(1032)
  den(1279) = den(249)*den(1148)
  den(1280) = den(249)*den(1150)
  den(1281) = den(252)*den(1148)
  den(1282) = den(252)*den(1150)
  den(1283) = den(249)*den(1158)
  den(1284) = den(249)*den(1160)
  den(1285) = den(252)*den(1158)
  den(1286) = den(252)*den(1160)
  den(1287) = den(150)*den(1018)
  den(1288) = den(150)*den(1020)
  den(1289) = den(153)*den(1018)
  den(1290) = den(153)*den(1020)
  den(1291) = den(150)*den(1148)
  den(1292) = den(150)*den(1150)
  den(1293) = den(153)*den(1148)
  den(1294) = den(153)*den(1150)
  den(1295) = den(268)*den(1018)
  den(1296) = den(270)*den(1018)
  den(1297) = den(268)*den(1020)
  den(1298) = den(270)*den(1020)
  den(1299) = den(229)*den(1148)
  den(1300) = den(231)*den(1148)
  den(1301) = den(229)*den(1150)
  den(1302) = den(231)*den(1150)
  den(1303) = den(41)*den(1084)
  den(1304) = den(41)*den(1086)
  den(1305) = den(43)*den(1084)
  den(1306) = den(43)*den(1086)
  den(1307) = den(41)*den(1205)
  den(1308) = den(41)*den(1207)
  den(1309) = den(43)*den(1205)
  den(1310) = den(43)*den(1207)
  den(1311) = den(268)*den(1084)
  den(1312) = den(268)*den(1086)
  den(1313) = den(270)*den(1084)
  den(1314) = den(270)*den(1086)
  den(1315) = den(229)*den(1205)
  den(1316) = den(229)*den(1207)
  den(1317) = den(231)*den(1205)
  den(1318) = den(231)*den(1207)
  den(1319) = den(106)*den(1030)
  den(1320) = den(106)*den(1032)
  den(1321) = den(109)*den(1030)
  den(1322) = den(109)*den(1032)
  den(1323) = den(106)*den(1158)
  den(1324) = den(106)*den(1160)
  den(1325) = den(109)*den(1158)
  den(1326) = den(109)*den(1160)
  den(1327) = den(333)*den(1030)
  den(1328) = den(335)*den(1030)
  den(1329) = den(333)*den(1032)
  den(1330) = den(335)*den(1032)
  den(1331) = den(301)*den(1158)
  den(1332) = den(303)*den(1158)
  den(1333) = den(301)*den(1160)
  den(1334) = den(303)*den(1160)
  den(1335) = den(53)*den(1084)
  den(1336) = den(53)*den(1086)
  den(1337) = den(55)*den(1084)
  den(1338) = den(55)*den(1086)
  den(1339) = den(53)*den(1205)
  den(1340) = den(53)*den(1207)
  den(1341) = den(55)*den(1205)
  den(1342) = den(55)*den(1207)
  den(1343) = den(333)*den(1084)
  den(1344) = den(335)*den(1084)
  den(1345) = den(333)*den(1086)
  den(1346) = den(335)*den(1086)
  den(1347) = den(301)*den(1205)
  den(1348) = den(303)*den(1205)
  den(1349) = den(301)*den(1207)
  den(1350) = den(303)*den(1207)
  den(1351) = den(1)*den(2)
  den(1352) = den(1)*den(6)
  den(1353) = den(2)*den(8)
  den(1354) = den(1)*den(19)
  den(1355) = den(1)*den(23)
  den(1356) = den(8)*den(19)
  den(1357) = den(1)*den(34)
  den(1358) = den(1)*den(36)
  den(1359) = den(8)*den(34)
  den(1360) = den(1)*den(47)
  den(1361) = den(1)*den(49)
  den(1362) = den(8)*den(47)
  den(1363) = den(59)*den(60)
  den(1364) = den(59)*den(64)
  den(1365) = den(60)*den(66)
  den(1366) = den(19)*den(60)
  den(1367) = den(23)*den(60)
  den(1368) = den(19)*den(64)
  den(1369) = den(60)*den(89)
  den(1370) = den(64)*den(89)
  den(1371) = den(60)*den(94)
  den(1372) = den(47)*den(60)
  den(1373) = den(49)*den(60)
  den(1374) = den(47)*den(64)
  den(1375) = den(59)*den(112)
  den(1376) = den(59)*den(116)
  den(1377) = den(66)*den(112)
  den(1378) = den(2)*den(112)
  den(1379) = den(2)*den(116)
  den(1380) = den(6)*den(112)
  den(1381) = den(89)*den(112)
  den(1382) = den(89)*den(116)
  den(1383) = den(94)*den(112)
  den(1384) = den(34)*den(112)
  den(1385) = den(34)*den(116)
  den(1386) = den(36)*den(112)
  den(1387) = den(34)*den(59)
  den(1388) = den(36)*den(59)
  den(1389) = den(34)*den(66)
  den(1390) = den(47)*den(59)
  den(1391) = den(49)*den(59)
  den(1392) = den(47)*den(66)
  den(1393) = den(2)*den(89)
  den(1394) = den(6)*den(89)
  den(1395) = den(2)*den(94)
  den(1396) = den(2)*den(47)
  den(1397) = den(2)*den(49)
  den(1398) = den(6)*den(47)
  den(1399) = den(19)*den(89)
  den(1400) = den(23)*den(89)
  den(1401) = den(19)*den(94)
  den(1402) = den(19)*den(34)
  den(1403) = den(23)*den(34)
  den(1404) = den(19)*den(36)
  den(1405) = den(1)*den(2)*den(47)
  den(1406) = den(1)*den(2)*den(49)
  den(1407) = den(1)*den(6)*den(47)
  den(1408) = den(1)*den(6)*den(49)
  den(1409) = den(2)*den(8)*den(47)
  den(1410) = den(2)*den(8)*den(49)
  den(1411) = den(6)*den(8)*den(47)
  den(1412) = den(6)*den(8)*den(49)
  den(1413) = den(1)*den(19)*den(34)
  den(1414) = den(1)*den(23)*den(34)
  den(1415) = den(1)*den(19)*den(36)
  den(1416) = den(1)*den(23)*den(36)
  den(1417) = den(8)*den(19)*den(34)
  den(1418) = den(8)*den(23)*den(34)
  den(1419) = den(8)*den(19)*den(36)
  den(1420) = den(8)*den(23)*den(36)
  den(1421) = den(47)*den(59)*den(60)
  den(1422) = den(49)*den(59)*den(60)
  den(1423) = den(47)*den(59)*den(64)
  den(1424) = den(49)*den(59)*den(64)
  den(1425) = den(47)*den(60)*den(66)
  den(1426) = den(49)*den(60)*den(66)
  den(1427) = den(47)*den(64)*den(66)
  den(1428) = den(49)*den(64)*den(66)
  den(1429) = den(19)*den(60)*den(89)
  den(1430) = den(23)*den(60)*den(89)
  den(1431) = den(19)*den(64)*den(89)
  den(1432) = den(23)*den(64)*den(89)
  den(1433) = den(19)*den(60)*den(94)
  den(1434) = den(23)*den(60)*den(94)
  den(1435) = den(19)*den(64)*den(94)
  den(1436) = den(23)*den(64)*den(94)
  den(1437) = den(34)*den(59)*den(112)
  den(1438) = den(34)*den(59)*den(116)
  den(1439) = den(36)*den(59)*den(112)
  den(1440) = den(36)*den(59)*den(116)
  den(1441) = den(34)*den(66)*den(112)
  den(1442) = den(34)*den(66)*den(116)
  den(1443) = den(36)*den(66)*den(112)
  den(1444) = den(36)*den(66)*den(116)
  den(1445) = den(2)*den(89)*den(112)
  den(1446) = den(2)*den(89)*den(116)
  den(1447) = den(6)*den(89)*den(112)
  den(1448) = den(6)*den(89)*den(116)
  den(1449) = den(2)*den(94)*den(112)
  den(1450) = den(2)*den(94)*den(116)
  den(1451) = den(6)*den(94)*den(112)
  den(1452) = den(6)*den(94)*den(116)
  den(1453) = den(1)*den(1396)
  den(1454) = den(1)*den(1397)
  den(1455) = den(1)*den(1398)
  den(1456) = den(1)*den(1182)
  den(1457) = den(8)*den(1396)
  den(1458) = den(8)*den(1397)
  den(1459) = den(8)*den(1398)
  den(1460) = den(8)*den(1182)
  den(1461) = den(2)*den(1360)
  den(1462) = den(2)*den(1361)
  den(1463) = den(6)*den(1360)
  den(1464) = den(6)*den(1361)
  den(1465) = den(2)*den(1362)
  den(1466) = den(2)*den(1009)
  den(1467) = den(6)*den(1362)
  den(1468) = den(6)*den(1009)
  den(1469) = den(47)*den(1351)
  den(1470) = den(49)*den(1351)
  den(1471) = den(47)*den(1352)
  den(1472) = den(49)*den(1352)
  den(1473) = den(47)*den(1353)
  den(1474) = den(49)*den(1353)
  den(1475) = den(47)*den(1000)
  den(1476) = den(49)*den(1000)
  den(1477) = den(1)*den(1402)
  den(1478) = den(1)*den(1403)
  den(1479) = den(1)*den(1404)
  den(1480) = den(1)*den(1221)
  den(1481) = den(8)*den(1402)
  den(1482) = den(8)*den(1403)
  den(1483) = den(8)*den(1404)
  den(1484) = den(8)*den(1221)
  den(1485) = den(34)*den(1354)
  den(1486) = den(34)*den(1355)
  den(1487) = den(36)*den(1354)
  den(1488) = den(36)*den(1355)
  den(1489) = den(34)*den(1356)
  den(1490) = den(34)*den(1003)
  den(1491) = den(36)*den(1356)
  den(1492) = den(36)*den(1003)
  den(1493) = den(19)*den(1357)
  den(1494) = den(23)*den(1357)
  den(1495) = den(19)*den(1358)
  den(1496) = den(23)*den(1358)
  den(1497) = den(19)*den(1359)
  den(1498) = den(23)*den(1359)
  den(1499) = den(19)*den(1006)
  den(1500) = den(23)*den(1006)
  den(1501) = den(59)*den(1372)
  den(1502) = den(59)*den(1373)
  den(1503) = den(59)*den(1374)
  den(1504) = den(59)*den(1059)
  den(1505) = den(66)*den(1372)
  den(1506) = den(66)*den(1373)
  den(1507) = den(66)*den(1374)
  den(1508) = den(66)*den(1059)
  den(1509) = den(60)*den(1390)
  den(1510) = den(60)*den(1391)
  den(1511) = den(64)*den(1390)
  den(1512) = den(64)*den(1391)
  den(1513) = den(60)*den(1392)
  den(1514) = den(60)*den(1141)
  den(1515) = den(64)*den(1392)
  den(1516) = den(64)*den(1141)
  den(1517) = den(47)*den(1363)
  den(1518) = den(49)*den(1363)
  den(1519) = den(47)*den(1364)
  den(1520) = den(49)*den(1364)
  den(1521) = den(47)*den(1365)
  den(1522) = den(49)*den(1365)
  den(1523) = den(47)*den(1052)
  den(1524) = den(49)*den(1052)
  den(1525) = den(89)*den(1366)
  den(1526) = den(89)*den(1367)
  den(1527) = den(89)*den(1368)
  den(1528) = den(89)*den(1054)
  den(1529) = den(94)*den(1366)
  den(1530) = den(94)*den(1367)
  den(1531) = den(94)*den(1368)
  den(1532) = den(94)*den(1054)
  den(1533) = den(60)*den(1399)
  den(1534) = den(60)*den(1400)
  den(1535) = den(64)*den(1399)
  den(1536) = den(64)*den(1400)
  den(1537) = den(60)*den(1401)
  den(1538) = den(60)*den(1219)
  den(1539) = den(64)*den(1401)
  den(1540) = den(64)*den(1219)
  den(1541) = den(19)*den(1369)
  den(1542) = den(23)*den(1369)
  den(1543) = den(19)*den(1370)
  den(1544) = den(23)*den(1370)
  den(1545) = den(19)*den(1371)
  den(1546) = den(23)*den(1371)
  den(1547) = den(19)*den(1057)
  den(1548) = den(23)*den(1057)
  den(1549) = den(59)*den(1384)
  den(1550) = den(59)*den(1385)
  den(1551) = den(59)*den(1386)
  den(1552) = den(59)*den(1104)
  den(1553) = den(66)*den(1384)
  den(1554) = den(66)*den(1385)
  den(1555) = den(66)*den(1386)
  den(1556) = den(66)*den(1104)
  den(1557) = den(34)*den(1375)
  den(1558) = den(34)*den(1376)
  den(1559) = den(36)*den(1375)
  den(1560) = den(36)*den(1376)
  den(1561) = den(34)*den(1377)
  den(1562) = den(34)*den(1098)
  den(1563) = den(36)*den(1377)
  den(1564) = den(36)*den(1098)
  den(1565) = den(112)*den(1387)
  den(1566) = den(116)*den(1387)
  den(1567) = den(112)*den(1388)
  den(1568) = den(116)*den(1388)
  den(1569) = den(112)*den(1389)
  den(1570) = den(116)*den(1389)
  den(1571) = den(112)*den(1138)
  den(1572) = den(116)*den(1138)
  den(1573) = den(89)*den(1378)
  den(1574) = den(89)*den(1379)
  den(1575) = den(89)*den(1380)
  den(1576) = den(89)*den(1100)
  den(1577) = den(94)*den(1378)
  den(1578) = den(94)*den(1379)
  den(1579) = den(94)*den(1380)
  den(1580) = den(94)*den(1100)
  den(1581) = den(2)*den(1381)
  den(1582) = den(2)*den(1382)
  den(1583) = den(6)*den(1381)
  den(1584) = den(6)*den(1382)
  den(1585) = den(2)*den(1383)
  den(1586) = den(2)*den(1102)
  den(1587) = den(6)*den(1383)
  den(1588) = den(6)*den(1102)
  den(1589) = den(112)*den(1393)
  den(1590) = den(116)*den(1393)
  den(1591) = den(112)*den(1394)
  den(1592) = den(116)*den(1394)
  den(1593) = den(112)*den(1395)
  den(1594) = den(116)*den(1395)
  den(1595) = den(112)*den(1180)
  den(1596) = den(116)*den(1180)
  den(1597) = den(47)*den(1002)
  den(1598) = den(49)*den(1002)
  den(1599) = den(2)*den(1011)
  den(1600) = den(6)*den(1011)
  den(1601) = den(1)*den(1184)
  den(1602) = den(8)*den(1184)
  den(1603) = den(2)*den(1031)
  den(1604) = den(2)*den(1033)
  den(1605) = den(6)*den(1031)
  den(1606) = den(6)*den(1033)
  den(1607) = den(2)*den(1034)
  den(1608) = den(2)*den(1035)
  den(1609) = den(6)*den(1034)
  den(1610) = den(6)*den(1035)
  den(1611) = den(2)*den(1048)
  den(1612) = den(2)*den(1049)
  den(1613) = den(6)*den(1048)
  den(1614) = den(6)*den(1049)
  den(1615) = den(2)*den(1050)
  den(1616) = den(2)*den(1051)
  den(1617) = den(6)*den(1050)
  den(1618) = den(6)*den(1051)
  den(1619) = den(1)*den(1206)
  den(1620) = den(1)*den(1208)
  den(1621) = den(1)*den(1209)
  den(1622) = den(1)*den(1210)
  den(1623) = den(8)*den(1206)
  den(1624) = den(8)*den(1208)
  den(1625) = den(8)*den(1209)
  den(1626) = den(8)*den(1210)
  den(1627) = den(1)*den(1215)
  den(1628) = den(1)*den(1216)
  den(1629) = den(1)*den(1217)
  den(1630) = den(1)*den(1218)
  den(1631) = den(8)*den(1215)
  den(1632) = den(8)*den(1216)
  den(1633) = den(8)*den(1217)
  den(1634) = den(8)*den(1218)
  den(1635) = den(19)*den(1008)
  den(1636) = den(23)*den(1008)
  den(1637) = den(34)*den(1005)
  den(1638) = den(36)*den(1005)
  den(1639) = den(1)*den(1222)
  den(1640) = den(8)*den(1222)
  den(1641) = den(19)*den(1019)
  den(1642) = den(19)*den(1021)
  den(1643) = den(23)*den(1019)
  den(1644) = den(23)*den(1021)
  den(1645) = den(19)*den(1022)
  den(1646) = den(19)*den(1023)
  den(1647) = den(23)*den(1022)
  den(1648) = den(23)*den(1023)
  den(1649) = den(19)*den(1044)
  den(1650) = den(23)*den(1044)
  den(1651) = den(19)*den(1045)
  den(1652) = den(23)*den(1045)
  den(1653) = den(19)*den(1046)
  den(1654) = den(23)*den(1046)
  den(1655) = den(19)*den(1047)
  den(1656) = den(23)*den(1047)
  den(1657) = den(1)*den(1243)
  den(1658) = den(1)*den(1244)
  den(1659) = den(1)*den(1245)
  den(1660) = den(1)*den(1246)
  den(1661) = den(8)*den(1243)
  den(1662) = den(8)*den(1244)
  den(1663) = den(8)*den(1245)
  den(1664) = den(8)*den(1246)
  den(1665) = den(1)*den(1251)
  den(1666) = den(1)*den(1252)
  den(1667) = den(1)*den(1253)
  den(1668) = den(1)*den(1254)
  den(1669) = den(8)*den(1251)
  den(1670) = den(8)*den(1252)
  den(1671) = den(8)*den(1253)
  den(1672) = den(8)*den(1254)
  den(1673) = den(34)*den(1025)
  den(1674) = den(34)*den(1027)
  den(1675) = den(36)*den(1025)
  den(1676) = den(36)*den(1027)
  den(1677) = den(34)*den(1028)
  den(1678) = den(34)*den(1029)
  den(1679) = den(36)*den(1028)
  den(1680) = den(36)*den(1029)
  den(1681) = den(34)*den(1040)
  den(1682) = den(34)*den(1041)
  den(1683) = den(36)*den(1040)
  den(1684) = den(36)*den(1041)
  den(1685) = den(34)*den(1042)
  den(1686) = den(34)*den(1043)
  den(1687) = den(36)*den(1042)
  den(1688) = den(36)*den(1043)
  den(1689) = den(1)*den(1307)
  den(1690) = den(1)*den(1308)
  den(1691) = den(1)*den(1309)
  den(1692) = den(1)*den(1310)
  den(1693) = den(8)*den(1307)
  den(1694) = den(8)*den(1308)
  den(1695) = den(8)*den(1309)
  den(1696) = den(8)*den(1310)
  den(1697) = den(1)*den(1315)
  den(1698) = den(1)*den(1316)
  den(1699) = den(1)*den(1317)
  den(1700) = den(1)*den(1318)
  den(1701) = den(8)*den(1315)
  den(1702) = den(8)*den(1316)
  den(1703) = den(8)*den(1317)
  den(1704) = den(8)*den(1318)
  den(1705) = den(47)*den(1013)
  den(1706) = den(47)*den(1015)
  den(1707) = den(49)*den(1013)
  den(1708) = den(49)*den(1015)
  den(1709) = den(47)*den(1016)
  den(1710) = den(47)*den(1017)
  den(1711) = den(49)*den(1016)
  den(1712) = den(49)*den(1017)
  den(1713) = den(47)*den(1036)
  den(1714) = den(49)*den(1036)
  den(1715) = den(47)*den(1037)
  den(1716) = den(49)*den(1037)
  den(1717) = den(47)*den(1038)
  den(1718) = den(49)*den(1038)
  den(1719) = den(47)*den(1039)
  den(1720) = den(49)*den(1039)
  den(1721) = den(1)*den(1339)
  den(1722) = den(1)*den(1340)
  den(1723) = den(1)*den(1341)
  den(1724) = den(1)*den(1342)
  den(1725) = den(8)*den(1339)
  den(1726) = den(8)*den(1340)
  den(1727) = den(8)*den(1341)
  den(1728) = den(8)*den(1342)
  den(1729) = den(1)*den(1347)
  den(1730) = den(1)*den(1348)
  den(1731) = den(1)*den(1349)
  den(1732) = den(1)*den(1350)
  den(1733) = den(8)*den(1347)
  den(1734) = den(8)*den(1348)
  den(1735) = den(8)*den(1349)
  den(1736) = den(8)*den(1350)
  den(1737) = den(47)*den(1053)
  den(1738) = den(49)*den(1053)
  den(1739) = den(60)*den(1143)
  den(1740) = den(64)*den(1143)
  den(1741) = den(59)*den(1061)
  den(1742) = den(66)*den(1061)
  den(1743) = den(60)*den(1159)
  den(1744) = den(60)*den(1161)
  den(1745) = den(64)*den(1159)
  den(1746) = den(64)*den(1161)
  den(1747) = den(60)*den(1162)
  den(1748) = den(60)*den(1163)
  den(1749) = den(64)*den(1162)
  den(1750) = den(64)*den(1163)
  den(1751) = den(60)*den(1176)
  den(1752) = den(60)*den(1177)
  den(1753) = den(64)*den(1176)
  den(1754) = den(64)*den(1177)
  den(1755) = den(60)*den(1178)
  den(1756) = den(60)*den(1179)
  den(1757) = den(64)*den(1178)
  den(1758) = den(64)*den(1179)
  den(1759) = den(59)*den(1085)
  den(1760) = den(59)*den(1087)
  den(1761) = den(59)*den(1088)
  den(1762) = den(59)*den(1089)
  den(1763) = den(66)*den(1085)
  den(1764) = den(66)*den(1087)
  den(1765) = den(66)*den(1088)
  den(1766) = den(66)*den(1089)
  den(1767) = den(59)*den(1094)
  den(1768) = den(59)*den(1095)
  den(1769) = den(59)*den(1096)
  den(1770) = den(59)*den(1097)
  den(1771) = den(66)*den(1094)
  den(1772) = den(66)*den(1095)
  den(1773) = den(66)*den(1096)
  den(1774) = den(66)*den(1097)
  den(1775) = den(19)*den(1058)
  den(1776) = den(23)*den(1058)
  den(1777) = den(60)*den(1220)
  den(1778) = den(64)*den(1220)
  den(1779) = den(89)*den(1056)
  den(1780) = den(94)*den(1056)
  den(1781) = den(19)*den(1066)
  den(1782) = den(19)*den(1067)
  den(1783) = den(23)*den(1066)
  den(1784) = den(23)*den(1067)
  den(1785) = den(19)*den(1068)
  den(1786) = den(19)*den(1069)
  den(1787) = den(23)*den(1068)
  den(1788) = den(23)*den(1069)
  den(1789) = den(60)*den(1227)
  den(1790) = den(60)*den(1228)
  den(1791) = den(64)*den(1227)
  den(1792) = den(64)*den(1228)
  den(1793) = den(60)*den(1229)
  den(1794) = den(60)*den(1230)
  den(1795) = den(64)*den(1229)
  den(1796) = den(64)*den(1230)
  den(1797) = den(19)*den(1074)
  den(1798) = den(23)*den(1074)
  den(1799) = den(19)*den(1075)
  den(1800) = den(23)*den(1075)
  den(1801) = den(19)*den(1076)
  den(1802) = den(23)*den(1076)
  den(1803) = den(19)*den(1077)
  den(1804) = den(23)*den(1077)
  den(1805) = den(60)*den(1235)
  den(1806) = den(60)*den(1236)
  den(1807) = den(64)*den(1235)
  den(1808) = den(64)*den(1236)
  den(1809) = den(60)*den(1237)
  den(1810) = den(60)*den(1238)
  den(1811) = den(64)*den(1237)
  den(1812) = den(64)*den(1238)
  den(1813) = den(60)*den(1267)
  den(1814) = den(60)*den(1268)
  den(1815) = den(64)*den(1267)
  den(1816) = den(64)*den(1268)
  den(1817) = den(60)*den(1269)
  den(1818) = den(60)*den(1270)
  den(1819) = den(64)*den(1269)
  den(1820) = den(64)*den(1270)
  den(1821) = den(60)*den(1283)
  den(1822) = den(60)*den(1284)
  den(1823) = den(64)*den(1283)
  den(1824) = den(64)*den(1284)
  den(1825) = den(60)*den(1285)
  den(1826) = den(60)*den(1286)
  den(1827) = den(64)*den(1285)
  den(1828) = den(64)*den(1286)
  den(1829) = den(89)*den(1079)
  den(1830) = den(89)*den(1081)
  den(1831) = den(89)*den(1082)
  den(1832) = den(89)*den(1083)
  den(1833) = den(94)*den(1079)
  den(1834) = den(94)*den(1081)
  den(1835) = den(94)*den(1082)
  den(1836) = den(94)*den(1083)
  den(1837) = den(89)*den(1090)
  den(1838) = den(89)*den(1091)
  den(1839) = den(89)*den(1092)
  den(1840) = den(89)*den(1093)
  den(1841) = den(94)*den(1090)
  den(1842) = den(94)*den(1091)
  den(1843) = den(94)*den(1092)
  den(1844) = den(94)*den(1093)
  den(1845) = den(47)*den(1062)
  den(1846) = den(47)*den(1063)
  den(1847) = den(49)*den(1062)
  den(1848) = den(49)*den(1063)
  den(1849) = den(47)*den(1064)
  den(1850) = den(47)*den(1065)
  den(1851) = den(49)*den(1064)
  den(1852) = den(49)*den(1065)
  den(1853) = den(60)*den(1323)
  den(1854) = den(60)*den(1324)
  den(1855) = den(64)*den(1323)
  den(1856) = den(64)*den(1324)
  den(1857) = den(60)*den(1325)
  den(1858) = den(60)*den(1326)
  den(1859) = den(64)*den(1325)
  den(1860) = den(64)*den(1326)
  den(1861) = den(47)*den(1070)
  den(1862) = den(49)*den(1070)
  den(1863) = den(47)*den(1071)
  den(1864) = den(49)*den(1071)
  den(1865) = den(47)*den(1072)
  den(1866) = den(49)*den(1072)
  den(1867) = den(47)*den(1073)
  den(1868) = den(49)*den(1073)
  den(1869) = den(60)*den(1331)
  den(1870) = den(60)*den(1332)
  den(1871) = den(64)*den(1331)
  den(1872) = den(64)*den(1332)
  den(1873) = den(60)*den(1333)
  den(1874) = den(60)*den(1334)
  den(1875) = den(64)*den(1333)
  den(1876) = den(64)*den(1334)
  den(1877) = den(112)*den(1140)
  den(1878) = den(116)*den(1140)
  den(1879) = den(34)*den(1099)
  den(1880) = den(36)*den(1099)
  den(1881) = den(59)*den(1105)
  den(1882) = den(66)*den(1105)
  den(1883) = den(112)*den(1149)
  den(1884) = den(112)*den(1151)
  den(1885) = den(116)*den(1149)
  den(1886) = den(116)*den(1151)
  den(1887) = den(112)*den(1152)
  den(1888) = den(112)*den(1153)
  den(1889) = den(116)*den(1152)
  den(1890) = den(116)*den(1153)
  den(1891) = den(112)*den(1172)
  den(1892) = den(116)*den(1172)
  den(1893) = den(112)*den(1173)
  den(1894) = den(116)*den(1173)
  den(1895) = den(112)*den(1174)
  den(1896) = den(116)*den(1174)
  den(1897) = den(112)*den(1175)
  den(1898) = den(116)*den(1175)
  den(1899) = den(59)*den(1126)
  den(1900) = den(59)*den(1127)
  den(1901) = den(59)*den(1128)
  den(1902) = den(59)*den(1129)
  den(1903) = den(66)*den(1126)
  den(1904) = den(66)*den(1127)
  den(1905) = den(66)*den(1128)
  den(1906) = den(66)*den(1129)
  den(1907) = den(59)*den(1134)
  den(1908) = den(59)*den(1135)
  den(1909) = den(59)*den(1136)
  den(1910) = den(59)*den(1137)
  den(1911) = den(66)*den(1134)
  den(1912) = den(66)*den(1135)
  den(1913) = den(66)*den(1136)
  den(1914) = den(66)*den(1137)
  den(1915) = den(112)*den(1181)
  den(1916) = den(116)*den(1181)
  den(1917) = den(2)*den(1103)
  den(1918) = den(6)*den(1103)
  den(1919) = den(89)*den(1101)
  den(1920) = den(94)*den(1101)
  den(1921) = den(112)*den(1189)
  den(1922) = den(112)*den(1190)
  den(1923) = den(116)*den(1189)
  den(1924) = den(116)*den(1190)
  den(1925) = den(112)*den(1191)
  den(1926) = den(112)*den(1192)
  den(1927) = den(116)*den(1191)
  den(1928) = den(116)*den(1192)
  den(1929) = den(2)*den(1110)
  den(1930) = den(2)*den(1111)
  den(1931) = den(6)*den(1110)
  den(1932) = den(6)*den(1111)
  den(1933) = den(2)*den(1112)
  den(1934) = den(2)*den(1113)
  den(1935) = den(6)*den(1112)
  den(1936) = den(6)*den(1113)
  den(1937) = den(112)*den(1197)
  den(1938) = den(116)*den(1197)
  den(1939) = den(112)*den(1198)
  den(1940) = den(116)*den(1198)
  den(1941) = den(112)*den(1199)
  den(1942) = den(116)*den(1199)
  den(1943) = den(112)*den(1200)
  den(1944) = den(116)*den(1200)
  den(1945) = den(2)*den(1118)
  den(1946) = den(2)*den(1119)
  den(1947) = den(6)*den(1118)
  den(1948) = den(6)*den(1119)
  den(1949) = den(2)*den(1120)
  den(1950) = den(2)*den(1121)
  den(1951) = den(6)*den(1120)
  den(1952) = den(6)*den(1121)
  den(1953) = den(112)*den(1259)
  den(1954) = den(112)*den(1260)
  den(1955) = den(116)*den(1259)
  den(1956) = den(116)*den(1260)
  den(1957) = den(112)*den(1261)
  den(1958) = den(112)*den(1262)
  den(1959) = den(116)*den(1261)
  den(1960) = den(116)*den(1262)
  den(1961) = den(112)*den(1279)
  den(1962) = den(116)*den(1279)
  den(1963) = den(112)*den(1280)
  den(1964) = den(116)*den(1280)
  den(1965) = den(112)*den(1281)
  den(1966) = den(116)*den(1281)
  den(1967) = den(112)*den(1282)
  den(1968) = den(116)*den(1282)
  den(1969) = den(89)*den(1122)
  den(1970) = den(89)*den(1123)
  den(1971) = den(89)*den(1124)
  den(1972) = den(89)*den(1125)
  den(1973) = den(94)*den(1122)
  den(1974) = den(94)*den(1123)
  den(1975) = den(94)*den(1124)
  den(1976) = den(94)*den(1125)
  den(1977) = den(89)*den(1130)
  den(1978) = den(89)*den(1131)
  den(1979) = den(89)*den(1132)
  den(1980) = den(89)*den(1133)
  den(1981) = den(94)*den(1130)
  den(1982) = den(94)*den(1131)
  den(1983) = den(94)*den(1132)
  den(1984) = den(94)*den(1133)
  den(1985) = den(112)*den(1291)
  den(1986) = den(112)*den(1292)
  den(1987) = den(116)*den(1291)
  den(1988) = den(116)*den(1292)
  den(1989) = den(112)*den(1293)
  den(1990) = den(112)*den(1294)
  den(1991) = den(116)*den(1293)
  den(1992) = den(116)*den(1294)
  den(1993) = den(34)*den(1106)
  den(1994) = den(34)*den(1107)
  den(1995) = den(36)*den(1106)
  den(1996) = den(36)*den(1107)
  den(1997) = den(34)*den(1108)
  den(1998) = den(34)*den(1109)
  den(1999) = den(36)*den(1108)
  den(2000) = den(36)*den(1109)
  den(2001) = den(112)*den(1299)
  den(2002) = den(116)*den(1299)
  den(2003) = den(112)*den(1300)
  den(2004) = den(116)*den(1300)
  den(2005) = den(112)*den(1301)
  den(2006) = den(116)*den(1301)
  den(2007) = den(112)*den(1302)
  den(2008) = den(116)*den(1302)
  den(2009) = den(34)*den(1114)
  den(2010) = den(34)*den(1115)
  den(2011) = den(36)*den(1114)
  den(2012) = den(36)*den(1115)
  den(2013) = den(34)*den(1116)
  den(2014) = den(34)*den(1117)
  den(2015) = den(36)*den(1116)
  den(2016) = den(36)*den(1117)
  den(2017) = den(34)*den(1154)
  den(2018) = den(34)*den(1155)
  den(2019) = den(36)*den(1154)
  den(2020) = den(36)*den(1155)
  den(2021) = den(34)*den(1156)
  den(2022) = den(34)*den(1157)
  den(2023) = den(36)*den(1156)
  den(2024) = den(36)*den(1157)
  den(2025) = den(34)*den(1168)
  den(2026) = den(34)*den(1169)
  den(2027) = den(36)*den(1168)
  den(2028) = den(36)*den(1169)
  den(2029) = den(34)*den(1170)
  den(2030) = den(34)*den(1171)
  den(2031) = den(36)*den(1170)
  den(2032) = den(36)*den(1171)
  den(2033) = den(59)*den(1303)
  den(2034) = den(59)*den(1304)
  den(2035) = den(59)*den(1305)
  den(2036) = den(59)*den(1306)
  den(2037) = den(66)*den(1303)
  den(2038) = den(66)*den(1304)
  den(2039) = den(66)*den(1305)
  den(2040) = den(66)*den(1306)
  den(2041) = den(59)*den(1311)
  den(2042) = den(59)*den(1312)
  den(2043) = den(59)*den(1313)
  den(2044) = den(59)*den(1314)
  den(2045) = den(66)*den(1311)
  den(2046) = den(66)*den(1312)
  den(2047) = den(66)*den(1313)
  den(2048) = den(66)*den(1314)
  den(2049) = den(47)*den(1144)
  den(2050) = den(47)*den(1145)
  den(2051) = den(49)*den(1144)
  den(2052) = den(49)*den(1145)
  den(2053) = den(47)*den(1146)
  den(2054) = den(47)*den(1147)
  den(2055) = den(49)*den(1146)
  den(2056) = den(49)*den(1147)
  den(2057) = den(47)*den(1164)
  den(2058) = den(49)*den(1164)
  den(2059) = den(47)*den(1165)
  den(2060) = den(49)*den(1165)
  den(2061) = den(47)*den(1166)
  den(2062) = den(49)*den(1166)
  den(2063) = den(47)*den(1167)
  den(2064) = den(49)*den(1167)
  den(2065) = den(59)*den(1335)
  den(2066) = den(59)*den(1336)
  den(2067) = den(59)*den(1337)
  den(2068) = den(59)*den(1338)
  den(2069) = den(66)*den(1335)
  den(2070) = den(66)*den(1336)
  den(2071) = den(66)*den(1337)
  den(2072) = den(66)*den(1338)
  den(2073) = den(59)*den(1343)
  den(2074) = den(59)*den(1344)
  den(2075) = den(59)*den(1345)
  den(2076) = den(59)*den(1346)
  den(2077) = den(66)*den(1343)
  den(2078) = den(66)*den(1344)
  den(2079) = den(66)*den(1345)
  den(2080) = den(66)*den(1346)
  den(2081) = den(2)*den(1263)
  den(2082) = den(2)*den(1264)
  den(2083) = den(6)*den(1263)
  den(2084) = den(6)*den(1264)
  den(2085) = den(2)*den(1265)
  den(2086) = den(2)*den(1266)
  den(2087) = den(6)*den(1265)
  den(2088) = den(6)*den(1266)
  den(2089) = den(2)*den(1275)
  den(2090) = den(2)*den(1276)
  den(2091) = den(6)*den(1275)
  den(2092) = den(6)*den(1276)
  den(2093) = den(2)*den(1277)
  den(2094) = den(2)*den(1278)
  den(2095) = den(6)*den(1277)
  den(2096) = den(6)*den(1278)
  den(2097) = den(89)*den(1201)
  den(2098) = den(89)*den(1202)
  den(2099) = den(89)*den(1203)
  den(2100) = den(89)*den(1204)
  den(2101) = den(94)*den(1201)
  den(2102) = den(94)*den(1202)
  den(2103) = den(94)*den(1203)
  den(2104) = den(94)*den(1204)
  den(2105) = den(89)*den(1211)
  den(2106) = den(89)*den(1212)
  den(2107) = den(89)*den(1213)
  den(2108) = den(89)*den(1214)
  den(2109) = den(94)*den(1211)
  den(2110) = den(94)*den(1212)
  den(2111) = den(94)*den(1213)
  den(2112) = den(94)*den(1214)
  den(2113) = den(47)*den(1185)
  den(2114) = den(47)*den(1186)
  den(2115) = den(49)*den(1185)
  den(2116) = den(49)*den(1186)
  den(2117) = den(47)*den(1187)
  den(2118) = den(47)*den(1188)
  den(2119) = den(49)*den(1187)
  den(2120) = den(49)*den(1188)
  den(2121) = den(2)*den(1319)
  den(2122) = den(2)*den(1320)
  den(2123) = den(6)*den(1319)
  den(2124) = den(6)*den(1320)
  den(2125) = den(2)*den(1321)
  den(2126) = den(2)*den(1322)
  den(2127) = den(6)*den(1321)
  den(2128) = den(6)*den(1322)
  den(2129) = den(47)*den(1193)
  den(2130) = den(49)*den(1193)
  den(2131) = den(47)*den(1194)
  den(2132) = den(49)*den(1194)
  den(2133) = den(47)*den(1195)
  den(2134) = den(49)*den(1195)
  den(2135) = den(47)*den(1196)
  den(2136) = den(49)*den(1196)
  den(2137) = den(2)*den(1327)
  den(2138) = den(2)*den(1328)
  den(2139) = den(6)*den(1327)
  den(2140) = den(6)*den(1328)
  den(2141) = den(2)*den(1329)
  den(2142) = den(2)*den(1330)
  den(2143) = den(6)*den(1329)
  den(2144) = den(6)*den(1330)
  den(2145) = den(19)*den(1255)
  den(2146) = den(19)*den(1256)
  den(2147) = den(23)*den(1255)
  den(2148) = den(23)*den(1256)
  den(2149) = den(19)*den(1257)
  den(2150) = den(19)*den(1258)
  den(2151) = den(23)*den(1257)
  den(2152) = den(23)*den(1258)
  den(2153) = den(19)*den(1271)
  den(2154) = den(23)*den(1271)
  den(2155) = den(19)*den(1272)
  den(2156) = den(23)*den(1272)
  den(2157) = den(19)*den(1273)
  den(2158) = den(23)*den(1273)
  den(2159) = den(19)*den(1274)
  den(2160) = den(23)*den(1274)
  den(2161) = den(89)*den(1239)
  den(2162) = den(89)*den(1240)
  den(2163) = den(89)*den(1241)
  den(2164) = den(89)*den(1242)
  den(2165) = den(94)*den(1239)
  den(2166) = den(94)*den(1240)
  den(2167) = den(94)*den(1241)
  den(2168) = den(94)*den(1242)
  den(2169) = den(89)*den(1247)
  den(2170) = den(89)*den(1248)
  den(2171) = den(89)*den(1249)
  den(2172) = den(89)*den(1250)
  den(2173) = den(94)*den(1247)
  den(2174) = den(94)*den(1248)
  den(2175) = den(94)*den(1249)
  den(2176) = den(94)*den(1250)
  den(2177) = den(19)*den(1287)
  den(2178) = den(19)*den(1288)
  den(2179) = den(23)*den(1287)
  den(2180) = den(23)*den(1288)
  den(2181) = den(19)*den(1289)
  den(2182) = den(19)*den(1290)
  den(2183) = den(23)*den(1289)
  den(2184) = den(23)*den(1290)
  den(2185) = den(34)*den(1223)
  den(2186) = den(34)*den(1224)
  den(2187) = den(36)*den(1223)
  den(2188) = den(36)*den(1224)
  den(2189) = den(34)*den(1225)
  den(2190) = den(34)*den(1226)
  den(2191) = den(36)*den(1225)
  den(2192) = den(36)*den(1226)
  den(2193) = den(19)*den(1295)
  den(2194) = den(23)*den(1295)
  den(2195) = den(19)*den(1296)
  den(2196) = den(23)*den(1296)
  den(2197) = den(19)*den(1297)
  den(2198) = den(23)*den(1297)
  den(2199) = den(19)*den(1298)
  den(2200) = den(23)*den(1298)
  den(2201) = den(34)*den(1231)
  den(2202) = den(34)*den(1232)
  den(2203) = den(36)*den(1231)
  den(2204) = den(36)*den(1232)
  den(2205) = den(34)*den(1233)
  den(2206) = den(34)*den(1234)
  den(2207) = den(36)*den(1233)
  den(2208) = den(36)*den(1234)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_eellll_ew_eeeexexex_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,1440))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_eellll_ew_eeeexexex_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e- e- e+ e+ e+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_eellll_ew_eeeexexex_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_eellll_ew_eeeexexex_1, only: &
    & external_perm_eellll_ew_eeeexexex_1, &
    & external_perm_inv_eellll_ew_eeeexexex_1, &
    & extcomb_perm_eellll_ew_eeeexexex_1, &
    & average_factor_eellll_ew_eeeexexex_1
  use ol_external_eellll_ew_eeeexexex_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_eellll_ew_eeeexexex_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_eellll_ew_eeeexexex_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,1440))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_eellll_ew_eeeexexex_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex2(:), ex5(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,2), n3(:,4), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 13, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_QA_Z(gZl,ntry, ex2(:), ex5(:), wf4(:,3), n3(:,5), t3x4(:,:,3))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,3), wf8(:,4), n3(:,6), t3x8(:,:,3))
  call vert_QA_Z(gZl,ntry, ex1(:), ex4(:), wf4(:,4), n3(:,7), t3x4(:,:,4))
  call vert_ZQ_A(gZl,ntry, wf4(:,4), ex3(:), wf8(:,5), n3(:,8), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,5), 13, ZERO, 0_intkind1, wf8(:,6), n2(2))
  call vert_VQ_A(ntry, wf4(:,2), ex3(:), wf8(:,7), n3(:,9), t3x8(:,:,5))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,8), n3(:,10), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 22, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_ZQ_A(gZl,ntry, wf4(:,3), ex3(:), wf8(:,10), n3(:,11), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,10), 22, ZERO, 0_intkind1, wf8(:,11), n2(4))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,4), wf8(:,12), n3(:,12), t3x8(:,:,8))
  call vert_QA_V(ntry, ex3(:), ex5(:), wf4(:,5), n3(:,13), t3x4(:,:,5))
  call vert_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,13), n3(:,14), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex6(:), wf4(:,5), wf8(:,14), n3(:,15), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), 11, ZERO, 0_intkind1, wf8(:,15), n2(5))
  call vert_QA_Z(gZl,ntry, ex3(:), ex5(:), wf4(:,6), n3(:,16), t3x4(:,:,6))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,6), wf8(:,16), n3(:,17), t3x8(:,:,11))
  call vert_ZQ_A(gZl,ntry, wf4(:,4), ex2(:), wf8(:,17), n3(:,18), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,17), 11, ZERO, 0_intkind1, wf8(:,18), n2(6))
  call vert_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,19), n3(:,19), t3x8(:,:,13))
  call prop_Q_A(ntry, wf8(:,19), 22, ZERO, 0_intkind1, wf8(:,20), n2(7))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex2(:), wf8(:,21), n3(:,20), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,21), 22, ZERO, 0_intkind1, wf8(:,22), n2(8))
  call vert_QA_V(ntry, ex2(:), ex6(:), wf4(:,7), n3(:,21), t3x4(:,:,7))
  call vert_AV_Q(ntry, ex5(:), wf4(:,7), wf8(:,23), n3(:,22), t3x8(:,:,15))
  call vert_QA_Z(gZl,ntry, ex2(:), ex6(:), wf4(:,8), n3(:,23), t3x4(:,:,8))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,8), wf8(:,24), n3(:,24), t3x8(:,:,16))
  call vert_VQ_A(ntry, wf4(:,7), ex3(:), wf8(:,25), n3(:,25), t3x8(:,:,17))
  call vert_AV_Q(ntry, ex5(:), wf4(:,1), wf8(:,26), n3(:,26), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,25), 38, ZERO, 0_intkind1, wf8(:,27), n2(9))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), ex3(:), wf8(:,28), n3(:,27), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,28), 38, ZERO, 0_intkind1, wf8(:,29), n2(10))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,4), wf8(:,30), n3(:,28), t3x8(:,:,20))
  call vert_QA_V(ntry, ex3(:), ex6(:), wf4(:,9), n3(:,29), t3x4(:,:,9))
  call vert_AV_Q(ntry, ex5(:), wf4(:,9), wf8(:,31), n3(:,30), t3x8(:,:,21))
  call vert_QA_Z(gZl,ntry, ex3(:), ex6(:), wf4(:,10), n3(:,31), t3x4(:,:,10))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,10), wf8(:,32), n3(:,32), t3x8(:,:,22))
  call vert_VQ_A(ntry, wf4(:,9), ex2(:), wf8(:,33), n3(:,33), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,33), 38, ZERO, 0_intkind1, wf8(:,34), n2(11))
  call vert_ZQ_A(gZl,ntry, wf4(:,10), ex2(:), wf8(:,35), n3(:,34), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,35), 38, ZERO, 0_intkind1, wf8(:,36), n2(12))
  call vert_QA_V(ntry, ex1(:), ex5(:), wf4(:,11), n3(:,35), t3x4(:,:,11))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,12), n3(:,36), t3x4(:,:,12))
  call vert_VQ_A(ntry, wf4(:,11), ex3(:), wf8(:,37), n3(:,37), t3x8(:,:,25))
  call vert_AV_Q(ntry, ex6(:), wf4(:,12), wf8(:,38), n3(:,38), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,37), 21, ZERO, 0_intkind1, wf8(:,39), n2(13))
  call vert_QA_Z(gZl,ntry, ex2(:), ex4(:), wf4(:,13), n3(:,39), t3x4(:,:,13))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,13), wf8(:,40), n3(:,40), t3x8(:,:,27))
  call vert_QA_Z(gZl,ntry, ex1(:), ex5(:), wf4(:,14), n3(:,41), t3x4(:,:,14))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), ex3(:), wf8(:,41), n3(:,42), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,41), 21, ZERO, 0_intkind1, wf8(:,42), n2(14))
  call vert_VQ_A(ntry, wf4(:,12), ex3(:), wf8(:,43), n3(:,43), t3x8(:,:,29))
  call vert_AV_Q(ntry, ex6(:), wf4(:,11), wf8(:,44), n3(:,44), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,43), 14, ZERO, 0_intkind1, wf8(:,45), n2(15))
  call vert_ZQ_A(gZl,ntry, wf4(:,13), ex3(:), wf8(:,46), n3(:,45), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,46), 14, ZERO, 0_intkind1, wf8(:,47), n2(16))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,14), wf8(:,48), n3(:,46), t3x8(:,:,32))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,49), n3(:,47), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,49), 11, ZERO, 0_intkind1, wf8(:,50), n2(17))
  call vert_ZQ_A(gZl,ntry, wf4(:,13), ex1(:), wf8(:,51), n3(:,48), t3x8(:,:,34))
  call prop_Q_A(ntry, wf8(:,51), 11, ZERO, 0_intkind1, wf8(:,52), n2(18))
  call vert_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,53), n3(:,49), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,53), 21, ZERO, 0_intkind1, wf8(:,54), n2(19))
  call vert_ZQ_A(gZl,ntry, wf4(:,6), ex1(:), wf8(:,55), n3(:,50), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,55), 21, ZERO, 0_intkind1, wf8(:,56), n2(20))
  call vert_QA_V(ntry, ex1(:), ex6(:), wf4(:,15), n3(:,51), t3x4(:,:,15))
  call vert_VQ_A(ntry, wf4(:,15), ex3(:), wf8(:,57), n3(:,52), t3x8(:,:,37))
  call vert_AV_Q(ntry, ex5(:), wf4(:,12), wf8(:,58), n3(:,53), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,57), 37, ZERO, 0_intkind1, wf8(:,59), n2(21))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,13), wf8(:,60), n3(:,54), t3x8(:,:,39))
  call vert_QA_Z(gZl,ntry, ex1(:), ex6(:), wf4(:,16), n3(:,55), t3x4(:,:,16))
  call vert_ZQ_A(gZl,ntry, wf4(:,16), ex3(:), wf8(:,61), n3(:,56), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,61), 37, ZERO, 0_intkind1, wf8(:,62), n2(22))
  call vert_AV_Q(ntry, ex5(:), wf4(:,15), wf8(:,63), n3(:,57), t3x8(:,:,41))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,16), wf8(:,64), n3(:,58), t3x8(:,:,42))
  call vert_VQ_A(ntry, wf4(:,9), ex1(:), wf8(:,65), n3(:,59), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,65), 37, ZERO, 0_intkind1, wf8(:,66), n2(23))
  call vert_ZQ_A(gZl,ntry, wf4(:,10), ex1(:), wf8(:,67), n3(:,60), t3x8(:,:,44))
  call prop_Q_A(ntry, wf8(:,67), 37, ZERO, 0_intkind1, wf8(:,68), n2(24))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,17), n3(:,61), t3x4(:,:,17))
  call vert_VQ_A(ntry, wf4(:,11), ex2(:), wf8(:,69), n3(:,62), t3x8(:,:,45))
  call vert_AV_Q(ntry, ex6(:), wf4(:,17), wf8(:,70), n3(:,63), t3x8(:,:,46))
  call prop_Q_A(ntry, wf8(:,69), 19, ZERO, 0_intkind1, wf8(:,71), n2(25))
  call vert_QA_Z(gZl,ntry, ex3(:), ex4(:), wf4(:,18), n3(:,64), t3x4(:,:,18))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,18), wf8(:,72), n3(:,65), t3x8(:,:,47))
  call vert_ZQ_A(gZl,ntry, wf4(:,14), ex2(:), wf8(:,73), n3(:,66), t3x8(:,:,48))
  call prop_Q_A(ntry, wf8(:,73), 19, ZERO, 0_intkind1, wf8(:,74), n2(26))
  call vert_VQ_A(ntry, wf4(:,17), ex2(:), wf8(:,75), n3(:,67), t3x8(:,:,49))
  call prop_Q_A(ntry, wf8(:,75), 14, ZERO, 0_intkind1, wf8(:,76), n2(27))
  call vert_ZQ_A(gZl,ntry, wf4(:,18), ex2(:), wf8(:,77), n3(:,68), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,77), 14, ZERO, 0_intkind1, wf8(:,78), n2(28))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,79), n3(:,69), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,79), 19, ZERO, 0_intkind1, wf8(:,80), n2(29))
  call vert_ZQ_A(gZl,ntry, wf4(:,3), ex1(:), wf8(:,81), n3(:,70), t3x8(:,:,52))
  call prop_Q_A(ntry, wf8(:,81), 19, ZERO, 0_intkind1, wf8(:,82), n2(30))
  call vert_VQ_A(ntry, wf4(:,17), ex1(:), wf8(:,83), n3(:,71), t3x8(:,:,53))
  call prop_Q_A(ntry, wf8(:,83), 13, ZERO, 0_intkind1, wf8(:,84), n2(31))
  call vert_ZQ_A(gZl,ntry, wf4(:,18), ex1(:), wf8(:,85), n3(:,72), t3x8(:,:,54))
  call prop_Q_A(ntry, wf8(:,85), 13, ZERO, 0_intkind1, wf8(:,86), n2(32))
  call vert_VQ_A(ntry, wf4(:,15), ex2(:), wf8(:,87), n3(:,73), t3x8(:,:,55))
  call vert_AV_Q(ntry, ex5(:), wf4(:,17), wf8(:,88), n3(:,74), t3x8(:,:,56))
  call prop_Q_A(ntry, wf8(:,87), 35, ZERO, 0_intkind1, wf8(:,89), n2(33))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,18), wf8(:,90), n3(:,75), t3x8(:,:,57))
  call vert_ZQ_A(gZl,ntry, wf4(:,16), ex2(:), wf8(:,91), n3(:,76), t3x8(:,:,58))
  call prop_Q_A(ntry, wf8(:,91), 35, ZERO, 0_intkind1, wf8(:,92), n2(34))
  call vert_VQ_A(ntry, wf4(:,7), ex1(:), wf8(:,93), n3(:,77), t3x8(:,:,59))
  call prop_Q_A(ntry, wf8(:,93), 35, ZERO, 0_intkind1, wf8(:,94), n2(35))
  call vert_ZQ_A(gZl,ntry, wf4(:,8), ex1(:), wf8(:,95), n3(:,78), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,95), 35, ZERO, 0_intkind1, wf8(:,96), n2(36))
  call vert_AV_Q(ntry, ex4(:), wf4(:,7), wf8(:,97), n3(:,79), t3x8(:,:,61))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,8), wf8(:,98), n3(:,80), t3x8(:,:,62))
  call vert_AV_Q(ntry, ex4(:), wf4(:,11), wf8(:,99), n3(:,81), t3x8(:,:,63))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,14), wf8(:,100), n3(:,82), t3x8(:,:,64))
  call vert_AV_Q(ntry, ex4(:), wf4(:,9), wf8(:,101), n3(:,83), t3x8(:,:,65))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,10), wf8(:,102), n3(:,84), t3x8(:,:,66))
  call vert_AV_Q(ntry, ex4(:), wf4(:,2), wf8(:,103), n3(:,85), t3x8(:,:,67))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,3), wf8(:,104), n3(:,86), t3x8(:,:,68))
  call vert_AV_Q(ntry, ex4(:), wf4(:,15), wf8(:,105), n3(:,87), t3x8(:,:,69))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,16), wf8(:,106), n3(:,88), t3x8(:,:,70))
  call vert_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,107), n3(:,89), t3x8(:,:,71))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,6), wf8(:,108), n3(:,90), t3x8(:,:,72))
  call counter_AZ_Q(EWctAee,ntry, ex6(:), wf4(:,2), wf8(:,109), n3(:,91), t3x8(:,:,73))
  call counter_AZ_Q(EWctVee,ntry, ex6(:), wf4(:,3), wf8(:,110), n3(:,92), t3x8(:,:,74))
  call counter_AZ_Q(EWctAee,ntry, ex6(:), wf4(:,1), wf8(:,111), n3(:,93), t3x8(:,:,75))
  call counter_AZ_Q(EWctVee,ntry, ex6(:), wf4(:,4), wf8(:,112), n3(:,94), t3x8(:,:,76))
  call counter_AZ_Q(EWctAee,ntry, ex6(:), wf4(:,5), wf8(:,113), n3(:,95), t3x8(:,:,77))
  call counter_AZ_Q(EWctVee,ntry, ex6(:), wf4(:,6), wf8(:,114), n3(:,96), t3x8(:,:,78))
  call counter_AZ_Q(EWctAee,ntry, ex5(:), wf4(:,7), wf8(:,115), n3(:,97), t3x8(:,:,79))
  call counter_AZ_Q(EWctVee,ntry, ex5(:), wf4(:,8), wf8(:,116), n3(:,98), t3x8(:,:,80))
  call counter_AZ_Q(EWctAee,ntry, ex5(:), wf4(:,1), wf8(:,117), n3(:,99), t3x8(:,:,81))
  call counter_AZ_Q(EWctVee,ntry, ex5(:), wf4(:,4), wf8(:,118), n3(:,100), t3x8(:,:,82))
  call counter_AZ_Q(EWctAee,ntry, ex5(:), wf4(:,9), wf8(:,119), n3(:,101), t3x8(:,:,83))
  call counter_AZ_Q(EWctVee,ntry, ex5(:), wf4(:,10), wf8(:,120), n3(:,102), t3x8(:,:,84))
  call counter_AZ_Q(EWctAee,ntry, ex6(:), wf4(:,12), wf8(:,121), n3(:,103), t3x8(:,:,85))
  call counter_AZ_Q(EWctVee,ntry, ex6(:), wf4(:,13), wf8(:,122), n3(:,104), t3x8(:,:,86))
  call counter_AZ_Q(EWctAee,ntry, ex6(:), wf4(:,11), wf8(:,123), n3(:,105), t3x8(:,:,87))
  call counter_AZ_Q(EWctVee,ntry, ex6(:), wf4(:,14), wf8(:,124), n3(:,106), t3x8(:,:,88))
  call counter_AZ_Q(EWctAee,ntry, ex5(:), wf4(:,12), wf8(:,125), n3(:,107), t3x8(:,:,89))
  call counter_AZ_Q(EWctVee,ntry, ex5(:), wf4(:,13), wf8(:,126), n3(:,108), t3x8(:,:,90))
  call counter_AZ_Q(EWctAee,ntry, ex5(:), wf4(:,15), wf8(:,127), n3(:,109), t3x8(:,:,91))
  call counter_AZ_Q(EWctVee,ntry, ex5(:), wf4(:,16), wf8(:,128), n3(:,110), t3x8(:,:,92))
  call counter_AZ_Q(EWctAee,ntry, ex6(:), wf4(:,17), wf8(:,129), n3(:,111), t3x8(:,:,93))
  call counter_AZ_Q(EWctVee,ntry, ex6(:), wf4(:,18), wf8(:,130), n3(:,112), t3x8(:,:,94))
  call counter_AZ_Q(EWctAee,ntry, ex5(:), wf4(:,17), wf8(:,131), n3(:,113), t3x8(:,:,95))
  call counter_AZ_Q(EWctVee,ntry, ex5(:), wf4(:,18), wf8(:,132), n3(:,114), t3x8(:,:,96))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,7), wf8(:,133), n3(:,115), t3x8(:,:,97))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,8), wf8(:,134), n3(:,116), t3x8(:,:,98))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,11), wf8(:,135), n3(:,117), t3x8(:,:,99))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,14), wf8(:,136), n3(:,118), t3x8(:,:,100))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,9), wf8(:,137), n3(:,119), t3x8(:,:,101))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,10), wf8(:,138), n3(:,120), t3x8(:,:,102))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,2), wf8(:,139), n3(:,121), t3x8(:,:,103))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,3), wf8(:,140), n3(:,122), t3x8(:,:,104))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,15), wf8(:,141), n3(:,123), t3x8(:,:,105))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,16), wf8(:,142), n3(:,124), t3x8(:,:,106))
  call counter_AZ_Q(EWctAee,ntry, ex4(:), wf4(:,5), wf8(:,143), n3(:,125), t3x8(:,:,107))
  call counter_AZ_Q(EWctVee,ntry, ex4(:), wf4(:,6), wf8(:,144), n3(:,126), t3x8(:,:,108))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,2), ex3(:), wf8(:,145), n3(:,127), t3x8(:,:,109))
  call prop_A_Q(ntry, wf8(:,8), 41, ZERO, 0_intkind1, wf8(:,146), n2(37))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,3), ex3(:), wf8(:,147), n3(:,128), t3x8(:,:,110))
  call prop_A_Q(ntry, wf8(:,12), 41, ZERO, 0_intkind1, wf8(:,148), n2(38))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,1), ex3(:), wf8(:,149), n3(:,129), t3x8(:,:,111))
  call prop_A_Q(ntry, wf8(:,2), 50, ZERO, 0_intkind1, wf8(:,150), n2(39))
  call prop_A_Q(ntry, wf8(:,4), 50, ZERO, 0_intkind1, wf8(:,151), n2(40))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,4), ex3(:), wf8(:,152), n3(:,130), t3x8(:,:,112))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,7), ex3(:), wf8(:,153), n3(:,131), t3x8(:,:,113))
  call prop_A_Q(ntry, wf8(:,26), 25, ZERO, 0_intkind1, wf8(:,154), n2(41))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,8), ex3(:), wf8(:,155), n3(:,132), t3x8(:,:,114))
  call prop_A_Q(ntry, wf8(:,30), 25, ZERO, 0_intkind1, wf8(:,156), n2(42))
  call prop_A_Q(ntry, wf8(:,23), 50, ZERO, 0_intkind1, wf8(:,157), n2(43))
  call prop_A_Q(ntry, wf8(:,24), 50, ZERO, 0_intkind1, wf8(:,158), n2(44))
  call counter_QA_Z(EWctAee,ntry, ex3(:), ex6(:), wf4(:,19), n3(:,133), t3x4(:,:,19))
  call vert_AV_Q(ntry, ex5(:), wf4(:,19), wf8(:,159), n3(:,134), t3x8(:,:,115))
  call counter_QA_Z(EWctVee,ntry, ex3(:), ex6(:), wf4(:,20), n3(:,135), t3x4(:,:,20))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,20), wf8(:,160), n3(:,136), t3x8(:,:,116))
  call vert_VQ_A(ntry, wf4(:,19), ex2(:), wf8(:,161), n3(:,137), t3x8(:,:,117))
  call prop_Q_A(ntry, wf8(:,161), 38, ZERO, 0_intkind1, wf8(:,162), n2(45))
  call vert_ZQ_A(gZl,ntry, wf4(:,20), ex2(:), wf8(:,163), n3(:,138), t3x8(:,:,118))
  call prop_Q_A(ntry, wf8(:,163), 38, ZERO, 0_intkind1, wf8(:,164), n2(46))
  call counter_QA_Z(EWctAee,ntry, ex3(:), ex5(:), wf4(:,21), n3(:,139), t3x4(:,:,21))
  call vert_AV_Q(ntry, ex6(:), wf4(:,21), wf8(:,165), n3(:,140), t3x8(:,:,119))
  call counter_QA_Z(EWctVee,ntry, ex3(:), ex5(:), wf4(:,22), n3(:,141), t3x4(:,:,22))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,22), wf8(:,166), n3(:,142), t3x8(:,:,120))
  call vert_VQ_A(ntry, wf4(:,21), ex2(:), wf8(:,167), n3(:,143), t3x8(:,:,121))
  call prop_Q_A(ntry, wf8(:,167), 22, ZERO, 0_intkind1, wf8(:,168), n2(47))
  call vert_ZQ_A(gZl,ntry, wf4(:,22), ex2(:), wf8(:,169), n3(:,144), t3x8(:,:,122))
  call prop_Q_A(ntry, wf8(:,169), 22, ZERO, 0_intkind1, wf8(:,170), n2(48))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,12), ex3(:), wf8(:,171), n3(:,145), t3x8(:,:,123))
  call prop_A_Q(ntry, wf8(:,44), 49, ZERO, 0_intkind1, wf8(:,172), n2(49))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,13), ex3(:), wf8(:,173), n3(:,146), t3x8(:,:,124))
  call prop_A_Q(ntry, wf8(:,48), 49, ZERO, 0_intkind1, wf8(:,174), n2(50))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,11), ex3(:), wf8(:,175), n3(:,147), t3x8(:,:,125))
  call prop_A_Q(ntry, wf8(:,38), 42, ZERO, 0_intkind1, wf8(:,176), n2(51))
  call prop_A_Q(ntry, wf8(:,40), 42, ZERO, 0_intkind1, wf8(:,177), n2(52))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,14), ex3(:), wf8(:,178), n3(:,148), t3x8(:,:,126))
  call prop_A_Q(ntry, wf8(:,63), 49, ZERO, 0_intkind1, wf8(:,179), n2(53))
  call prop_A_Q(ntry, wf8(:,64), 49, ZERO, 0_intkind1, wf8(:,180), n2(54))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,15), ex3(:), wf8(:,181), n3(:,149), t3x8(:,:,127))
  call prop_A_Q(ntry, wf8(:,58), 26, ZERO, 0_intkind1, wf8(:,182), n2(55))
  call prop_A_Q(ntry, wf8(:,60), 26, ZERO, 0_intkind1, wf8(:,183), n2(56))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,16), ex3(:), wf8(:,184), n3(:,150), t3x8(:,:,128))
  call vert_VQ_A(ntry, wf4(:,19), ex1(:), wf8(:,185), n3(:,151), t3x8(:,:,129))
  call prop_Q_A(ntry, wf8(:,185), 37, ZERO, 0_intkind1, wf8(:,186), n2(57))
  call vert_ZQ_A(gZl,ntry, wf4(:,20), ex1(:), wf8(:,187), n3(:,152), t3x8(:,:,130))
  call prop_Q_A(ntry, wf8(:,187), 37, ZERO, 0_intkind1, wf8(:,188), n2(58))
  call vert_VQ_A(ntry, wf4(:,21), ex1(:), wf8(:,189), n3(:,153), t3x8(:,:,131))
  call prop_Q_A(ntry, wf8(:,189), 21, ZERO, 0_intkind1, wf8(:,190), n2(59))
  call vert_ZQ_A(gZl,ntry, wf4(:,22), ex1(:), wf8(:,191), n3(:,154), t3x8(:,:,132))
  call prop_Q_A(ntry, wf8(:,191), 21, ZERO, 0_intkind1, wf8(:,192), n2(60))
  call prop_A_Q(ntry, wf8(:,99), 25, ZERO, 0_intkind1, wf8(:,193), n2(61))
  call prop_A_Q(ntry, wf8(:,100), 25, ZERO, 0_intkind1, wf8(:,194), n2(62))
  call prop_A_Q(ntry, wf8(:,97), 42, ZERO, 0_intkind1, wf8(:,195), n2(63))
  call prop_A_Q(ntry, wf8(:,98), 42, ZERO, 0_intkind1, wf8(:,196), n2(64))
  call vert_AV_Q(ntry, ex4(:), wf4(:,19), wf8(:,197), n3(:,155), t3x8(:,:,133))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,20), wf8(:,198), n3(:,156), t3x8(:,:,134))
  call prop_A_Q(ntry, wf8(:,105), 41, ZERO, 0_intkind1, wf8(:,199), n2(65))
  call prop_A_Q(ntry, wf8(:,106), 41, ZERO, 0_intkind1, wf8(:,200), n2(66))
  call prop_A_Q(ntry, wf8(:,103), 26, ZERO, 0_intkind1, wf8(:,201), n2(67))
  call prop_A_Q(ntry, wf8(:,104), 26, ZERO, 0_intkind1, wf8(:,202), n2(68))
  call vert_AV_Q(ntry, ex4(:), wf4(:,21), wf8(:,203), n3(:,157), t3x8(:,:,135))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,22), wf8(:,204), n3(:,158), t3x8(:,:,136))
  call counter_QA_Z(EWctAee,ntry, ex3(:), ex4(:), wf4(:,23), n3(:,159), t3x4(:,:,23))
  call vert_AV_Q(ntry, ex6(:), wf4(:,23), wf8(:,205), n3(:,160), t3x8(:,:,137))
  call counter_QA_Z(EWctVee,ntry, ex3(:), ex4(:), wf4(:,24), n3(:,161), t3x4(:,:,24))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,24), wf8(:,206), n3(:,162), t3x8(:,:,138))
  call vert_VQ_A(ntry, wf4(:,23), ex2(:), wf8(:,207), n3(:,163), t3x8(:,:,139))
  call prop_Q_A(ntry, wf8(:,207), 14, ZERO, 0_intkind1, wf8(:,208), n2(69))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), ex2(:), wf8(:,209), n3(:,164), t3x8(:,:,140))
  call prop_Q_A(ntry, wf8(:,209), 14, ZERO, 0_intkind1, wf8(:,210), n2(70))
  call vert_VQ_A(ntry, wf4(:,23), ex1(:), wf8(:,211), n3(:,165), t3x8(:,:,141))
  call prop_Q_A(ntry, wf8(:,211), 13, ZERO, 0_intkind1, wf8(:,212), n2(71))
  call vert_ZQ_A(gZl,ntry, wf4(:,24), ex1(:), wf8(:,213), n3(:,166), t3x8(:,:,142))
  call prop_Q_A(ntry, wf8(:,213), 13, ZERO, 0_intkind1, wf8(:,214), n2(72))
  call vert_AV_Q(ntry, ex5(:), wf4(:,23), wf8(:,215), n3(:,167), t3x8(:,:,143))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,24), wf8(:,216), n3(:,168), t3x8(:,:,144))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,5), ex2(:), wf8(:,217), n3(:,169), t3x8(:,:,145))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,6), ex2(:), wf8(:,218), n3(:,170), t3x8(:,:,146))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,1), ex2(:), wf8(:,219), n3(:,171), t3x8(:,:,147))
  call prop_A_Q(ntry, wf8(:,14), 52, ZERO, 0_intkind1, wf8(:,220), n2(73))
  call prop_A_Q(ntry, wf8(:,16), 52, ZERO, 0_intkind1, wf8(:,221), n2(74))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,4), ex2(:), wf8(:,222), n3(:,172), t3x8(:,:,148))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,9), ex2(:), wf8(:,223), n3(:,173), t3x8(:,:,149))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,10), ex2(:), wf8(:,224), n3(:,174), t3x8(:,:,150))
  call prop_A_Q(ntry, wf8(:,31), 52, ZERO, 0_intkind1, wf8(:,225), n2(75))
  call prop_A_Q(ntry, wf8(:,32), 52, ZERO, 0_intkind1, wf8(:,226), n2(76))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex6(:), wf4(:,25), n3(:,175), t3x4(:,:,25))
  call vert_AV_Q(ntry, ex5(:), wf4(:,25), wf8(:,227), n3(:,176), t3x8(:,:,151))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex6(:), wf4(:,26), n3(:,177), t3x4(:,:,26))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,26), wf8(:,228), n3(:,178), t3x8(:,:,152))
  call vert_VQ_A(ntry, wf4(:,25), ex3(:), wf8(:,229), n3(:,179), t3x8(:,:,153))
  call prop_Q_A(ntry, wf8(:,229), 38, ZERO, 0_intkind1, wf8(:,230), n2(77))
  call vert_ZQ_A(gZl,ntry, wf4(:,26), ex3(:), wf8(:,231), n3(:,180), t3x8(:,:,154))
  call prop_Q_A(ntry, wf8(:,231), 38, ZERO, 0_intkind1, wf8(:,232), n2(78))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex5(:), wf4(:,27), n3(:,181), t3x4(:,:,27))
  call vert_AV_Q(ntry, ex6(:), wf4(:,27), wf8(:,233), n3(:,182), t3x8(:,:,155))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex5(:), wf4(:,28), n3(:,183), t3x4(:,:,28))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,28), wf8(:,234), n3(:,184), t3x8(:,:,156))
  call vert_VQ_A(ntry, wf4(:,27), ex3(:), wf8(:,235), n3(:,185), t3x8(:,:,157))
  call prop_Q_A(ntry, wf8(:,235), 22, ZERO, 0_intkind1, wf8(:,236), n2(79))
  call vert_ZQ_A(gZl,ntry, wf4(:,28), ex3(:), wf8(:,237), n3(:,186), t3x8(:,:,158))
  call prop_Q_A(ntry, wf8(:,237), 22, ZERO, 0_intkind1, wf8(:,238), n2(80))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,17), ex2(:), wf8(:,239), n3(:,187), t3x8(:,:,159))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,18), ex2(:), wf8(:,240), n3(:,188), t3x8(:,:,160))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,11), ex2(:), wf8(:,241), n3(:,189), t3x8(:,:,161))
  call prop_A_Q(ntry, wf8(:,70), 44, ZERO, 0_intkind1, wf8(:,242), n2(81))
  call prop_A_Q(ntry, wf8(:,72), 44, ZERO, 0_intkind1, wf8(:,243), n2(82))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,14), ex2(:), wf8(:,244), n3(:,190), t3x8(:,:,162))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,15), ex2(:), wf8(:,245), n3(:,191), t3x8(:,:,163))
  call prop_A_Q(ntry, wf8(:,88), 28, ZERO, 0_intkind1, wf8(:,246), n2(83))
  call prop_A_Q(ntry, wf8(:,90), 28, ZERO, 0_intkind1, wf8(:,247), n2(84))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,16), ex2(:), wf8(:,248), n3(:,192), t3x8(:,:,164))
  call vert_VQ_A(ntry, wf4(:,25), ex1(:), wf8(:,249), n3(:,193), t3x8(:,:,165))
  call prop_Q_A(ntry, wf8(:,249), 35, ZERO, 0_intkind1, wf8(:,250), n2(85))
  call vert_ZQ_A(gZl,ntry, wf4(:,26), ex1(:), wf8(:,251), n3(:,194), t3x8(:,:,166))
  call prop_Q_A(ntry, wf8(:,251), 35, ZERO, 0_intkind1, wf8(:,252), n2(86))
  call vert_VQ_A(ntry, wf4(:,27), ex1(:), wf8(:,253), n3(:,195), t3x8(:,:,167))
  call prop_Q_A(ntry, wf8(:,253), 19, ZERO, 0_intkind1, wf8(:,254), n2(87))
  call vert_ZQ_A(gZl,ntry, wf4(:,28), ex1(:), wf8(:,255), n3(:,196), t3x8(:,:,168))
  call prop_Q_A(ntry, wf8(:,255), 19, ZERO, 0_intkind1, wf8(:,256), n2(88))
  call prop_A_Q(ntry, wf8(:,101), 44, ZERO, 0_intkind1, wf8(:,257), n2(89))
  call prop_A_Q(ntry, wf8(:,102), 44, ZERO, 0_intkind1, wf8(:,258), n2(90))
  call vert_AV_Q(ntry, ex4(:), wf4(:,25), wf8(:,259), n3(:,197), t3x8(:,:,169))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,26), wf8(:,260), n3(:,198), t3x8(:,:,170))
  call prop_A_Q(ntry, wf8(:,107), 28, ZERO, 0_intkind1, wf8(:,261), n2(91))
  call prop_A_Q(ntry, wf8(:,108), 28, ZERO, 0_intkind1, wf8(:,262), n2(92))
  call vert_AV_Q(ntry, ex4(:), wf4(:,27), wf8(:,263), n3(:,199), t3x8(:,:,171))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,28), wf8(:,264), n3(:,200), t3x8(:,:,172))
  call counter_QA_Z(EWctAee,ntry, ex2(:), ex4(:), wf4(:,29), n3(:,201), t3x4(:,:,29))
  call vert_AV_Q(ntry, ex6(:), wf4(:,29), wf8(:,265), n3(:,202), t3x8(:,:,173))
  call counter_QA_Z(EWctVee,ntry, ex2(:), ex4(:), wf4(:,30), n3(:,203), t3x4(:,:,30))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,30), wf8(:,266), n3(:,204), t3x8(:,:,174))
  call vert_VQ_A(ntry, wf4(:,29), ex3(:), wf8(:,267), n3(:,205), t3x8(:,:,175))
  call prop_Q_A(ntry, wf8(:,267), 14, ZERO, 0_intkind1, wf8(:,268), n2(93))
  call vert_ZQ_A(gZl,ntry, wf4(:,30), ex3(:), wf8(:,269), n3(:,206), t3x8(:,:,176))
  call prop_Q_A(ntry, wf8(:,269), 14, ZERO, 0_intkind1, wf8(:,270), n2(94))
  call vert_VQ_A(ntry, wf4(:,29), ex1(:), wf8(:,271), n3(:,207), t3x8(:,:,177))
  call prop_Q_A(ntry, wf8(:,271), 11, ZERO, 0_intkind1, wf8(:,272), n2(95))
  call vert_ZQ_A(gZl,ntry, wf4(:,30), ex1(:), wf8(:,273), n3(:,208), t3x8(:,:,178))
  call prop_Q_A(ntry, wf8(:,273), 11, ZERO, 0_intkind1, wf8(:,274), n2(96))
  call vert_AV_Q(ntry, ex5(:), wf4(:,29), wf8(:,275), n3(:,209), t3x8(:,:,179))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,30), wf8(:,276), n3(:,210), t3x8(:,:,180))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,12), ex1(:), wf8(:,277), n3(:,211), t3x8(:,:,181))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,13), ex1(:), wf8(:,278), n3(:,212), t3x8(:,:,182))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,5), ex1(:), wf8(:,279), n3(:,213), t3x8(:,:,183))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,6), ex1(:), wf8(:,280), n3(:,214), t3x8(:,:,184))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,9), ex1(:), wf8(:,281), n3(:,215), t3x8(:,:,185))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,10), ex1(:), wf8(:,282), n3(:,216), t3x8(:,:,186))
  call counter_QA_Z(EWctAee,ntry, ex1(:), ex6(:), wf4(:,31), n3(:,217), t3x4(:,:,31))
  call vert_VQ_A(ntry, wf4(:,31), ex3(:), wf8(:,283), n3(:,218), t3x8(:,:,187))
  call prop_Q_A(ntry, wf8(:,283), 37, ZERO, 0_intkind1, wf8(:,284), n2(97))
  call counter_QA_Z(EWctVee,ntry, ex1(:), ex6(:), wf4(:,32), n3(:,219), t3x4(:,:,32))
  call vert_ZQ_A(gZl,ntry, wf4(:,32), ex3(:), wf8(:,285), n3(:,220), t3x8(:,:,188))
  call prop_Q_A(ntry, wf8(:,285), 37, ZERO, 0_intkind1, wf8(:,286), n2(98))
  call vert_AV_Q(ntry, ex5(:), wf4(:,31), wf8(:,287), n3(:,221), t3x8(:,:,189))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,32), wf8(:,288), n3(:,222), t3x8(:,:,190))
  call counter_QA_Z(EWctAee,ntry, ex1(:), ex5(:), wf4(:,33), n3(:,223), t3x4(:,:,33))
  call vert_VQ_A(ntry, wf4(:,33), ex3(:), wf8(:,289), n3(:,224), t3x8(:,:,191))
  call prop_Q_A(ntry, wf8(:,289), 21, ZERO, 0_intkind1, wf8(:,290), n2(99))
  call counter_QA_Z(EWctVee,ntry, ex1(:), ex5(:), wf4(:,34), n3(:,225), t3x4(:,:,34))
  call vert_ZQ_A(gZl,ntry, wf4(:,34), ex3(:), wf8(:,291), n3(:,226), t3x8(:,:,192))
  call prop_Q_A(ntry, wf8(:,291), 21, ZERO, 0_intkind1, wf8(:,292), n2(100))
  call vert_AV_Q(ntry, ex6(:), wf4(:,33), wf8(:,293), n3(:,227), t3x8(:,:,193))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,34), wf8(:,294), n3(:,228), t3x8(:,:,194))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,2), ex1(:), wf8(:,295), n3(:,229), t3x8(:,:,195))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,3), ex1(:), wf8(:,296), n3(:,230), t3x8(:,:,196))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,17), ex1(:), wf8(:,297), n3(:,231), t3x8(:,:,197))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,18), ex1(:), wf8(:,298), n3(:,232), t3x8(:,:,198))
  call counter_ZQ_A(EWctAee,ntry, wf4(:,7), ex1(:), wf8(:,299), n3(:,233), t3x8(:,:,199))
  call counter_ZQ_A(EWctVee,ntry, wf4(:,8), ex1(:), wf8(:,300), n3(:,234), t3x8(:,:,200))
  call vert_VQ_A(ntry, wf4(:,31), ex2(:), wf8(:,301), n3(:,235), t3x8(:,:,201))
  call prop_Q_A(ntry, wf8(:,301), 35, ZERO, 0_intkind1, wf8(:,302), n2(101))
  call vert_ZQ_A(gZl,ntry, wf4(:,32), ex2(:), wf8(:,303), n3(:,236), t3x8(:,:,202))
  call prop_Q_A(ntry, wf8(:,303), 35, ZERO, 0_intkind1, wf8(:,304), n2(102))
  call vert_VQ_A(ntry, wf4(:,33), ex2(:), wf8(:,305), n3(:,237), t3x8(:,:,203))
  call prop_Q_A(ntry, wf8(:,305), 19, ZERO, 0_intkind1, wf8(:,306), n2(103))
  call vert_ZQ_A(gZl,ntry, wf4(:,34), ex2(:), wf8(:,307), n3(:,238), t3x8(:,:,204))
  call prop_Q_A(ntry, wf8(:,307), 19, ZERO, 0_intkind1, wf8(:,308), n2(104))
  call vert_AV_Q(ntry, ex4(:), wf4(:,31), wf8(:,309), n3(:,239), t3x8(:,:,205))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,32), wf8(:,310), n3(:,240), t3x8(:,:,206))
  call vert_AV_Q(ntry, ex4(:), wf4(:,33), wf8(:,311), n3(:,241), t3x8(:,:,207))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,34), wf8(:,312), n3(:,242), t3x8(:,:,208))
  call counter_QA_Z(EWctAee,ntry, ex1(:), ex4(:), wf4(:,35), n3(:,243), t3x4(:,:,35))
  call vert_VQ_A(ntry, wf4(:,35), ex3(:), wf8(:,313), n3(:,244), t3x8(:,:,209))
  call prop_Q_A(ntry, wf8(:,313), 13, ZERO, 0_intkind1, wf8(:,314), n2(105))
  call counter_QA_Z(EWctVee,ntry, ex1(:), ex4(:), wf4(:,36), n3(:,245), t3x4(:,:,36))
  call vert_ZQ_A(gZl,ntry, wf4(:,36), ex3(:), wf8(:,315), n3(:,246), t3x8(:,:,210))
  call prop_Q_A(ntry, wf8(:,315), 13, ZERO, 0_intkind1, wf8(:,316), n2(106))
  call vert_AV_Q(ntry, ex6(:), wf4(:,35), wf8(:,317), n3(:,247), t3x8(:,:,211))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,36), wf8(:,318), n3(:,248), t3x8(:,:,212))
  call vert_VQ_A(ntry, wf4(:,35), ex2(:), wf8(:,319), n3(:,249), t3x8(:,:,213))
  call prop_Q_A(ntry, wf8(:,319), 11, ZERO, 0_intkind1, wf8(:,320), n2(107))
  call vert_ZQ_A(gZl,ntry, wf4(:,36), ex2(:), wf8(:,321), n3(:,250), t3x8(:,:,214))
  call prop_Q_A(ntry, wf8(:,321), 11, ZERO, 0_intkind1, wf8(:,322), n2(108))
  call vert_AV_Q(ntry, ex5(:), wf4(:,35), wf8(:,323), n3(:,251), t3x8(:,:,215))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,36), wf8(:,324), n3(:,252), t3x8(:,:,216))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 9, wf4(:,37), n2(109))
  call vert_VQ_A(ntry, wf4(:,37), ex3(:), wf8(:,325), n3(:,253), t3x8(:,:,217))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 9, wf4(:,38), n2(110))
  call vert_ZQ_A(gZl,ntry, wf4(:,38), ex3(:), wf8(:,326), n3(:,254), t3x8(:,:,218))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 9, wf4(:,39), n2(111))
  call vert_VQ_A(ntry, wf4(:,39), ex3(:), wf8(:,327), n3(:,255), t3x8(:,:,219))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 9, wf4(:,40), n2(112))
  call vert_ZQ_A(gZl,ntry, wf4(:,40), ex3(:), wf8(:,328), n3(:,256), t3x8(:,:,220))
  call vert_AV_Q(ntry, ex6(:), wf4(:,37), wf8(:,329), n3(:,257), t3x8(:,:,221))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,38), wf8(:,330), n3(:,258), t3x8(:,:,222))
  call vert_AV_Q(ntry, ex6(:), wf4(:,39), wf8(:,331), n3(:,259), t3x8(:,:,223))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,40), wf8(:,332), n3(:,260), t3x8(:,:,224))
  call counter_V_V(EWctAA,ntry, wf4(:,2), 18, wf4(:,41), n2(113))
  call vert_VQ_A(ntry, wf4(:,41), ex3(:), wf8(:,333), n3(:,261), t3x8(:,:,225))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 18, wf4(:,42), n2(114))
  call vert_ZQ_A(gZl,ntry, wf4(:,42), ex3(:), wf8(:,334), n3(:,262), t3x8(:,:,226))
  call counter_V_V(EWctAZ,ntry, wf4(:,3), 18, wf4(:,43), n2(115))
  call vert_VQ_A(ntry, wf4(:,43), ex3(:), wf8(:,335), n3(:,263), t3x8(:,:,227))
  call counter_V_V(EWctZZ,ntry, wf4(:,3), 18, wf4(:,44), n2(116))
  call vert_ZQ_A(gZl,ntry, wf4(:,44), ex3(:), wf8(:,336), n3(:,264), t3x8(:,:,228))
  call vert_AV_Q(ntry, ex6(:), wf4(:,41), wf8(:,337), n3(:,265), t3x8(:,:,229))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,42), wf8(:,338), n3(:,266), t3x8(:,:,230))
  call vert_AV_Q(ntry, ex6(:), wf4(:,43), wf8(:,339), n3(:,267), t3x8(:,:,231))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,44), wf8(:,340), n3(:,268), t3x8(:,:,232))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,3), 13, wf8(:,341), n2(117))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,6), 13, wf8(:,342), n2(118))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,9), 22, wf8(:,343), n2(119))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,11), 22, wf8(:,344), n2(120))
  call vert_VQ_A(ntry, wf4(:,37), ex2(:), wf8(:,345), n3(:,269), t3x8(:,:,233))
  call vert_ZQ_A(gZl,ntry, wf4(:,38), ex2(:), wf8(:,346), n3(:,270), t3x8(:,:,234))
  call vert_VQ_A(ntry, wf4(:,39), ex2(:), wf8(:,347), n3(:,271), t3x8(:,:,235))
  call vert_ZQ_A(gZl,ntry, wf4(:,40), ex2(:), wf8(:,348), n3(:,272), t3x8(:,:,236))
  call counter_V_V(EWctAA,ntry, wf4(:,5), 20, wf4(:,45), n2(121))
  call vert_VQ_A(ntry, wf4(:,45), ex2(:), wf8(:,349), n3(:,273), t3x8(:,:,237))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 20, wf4(:,46), n2(122))
  call vert_VQ_A(ntry, wf4(:,46), ex2(:), wf8(:,350), n3(:,274), t3x8(:,:,238))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 20, wf4(:,47), n2(123))
  call vert_ZQ_A(gZl,ntry, wf4(:,47), ex2(:), wf8(:,351), n3(:,275), t3x8(:,:,239))
  call counter_V_V(EWctZZ,ntry, wf4(:,6), 20, wf4(:,48), n2(124))
  call vert_ZQ_A(gZl,ntry, wf4(:,48), ex2(:), wf8(:,352), n3(:,276), t3x8(:,:,240))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,15), 11, wf8(:,353), n2(125))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,18), 11, wf8(:,354), n2(126))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,20), 22, wf8(:,355), n2(127))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,22), 22, wf8(:,356), n2(128))
  call vert_AV_Q(ntry, ex6(:), wf4(:,45), wf8(:,357), n3(:,277), t3x8(:,:,241))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,47), wf8(:,358), n3(:,278), t3x8(:,:,242))
  call vert_AV_Q(ntry, ex6(:), wf4(:,46), wf8(:,359), n3(:,279), t3x8(:,:,243))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,48), wf8(:,360), n3(:,280), t3x8(:,:,244))
  call vert_AV_Q(ntry, ex5(:), wf4(:,37), wf8(:,361), n3(:,281), t3x8(:,:,245))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,38), wf8(:,362), n3(:,282), t3x8(:,:,246))
  call vert_AV_Q(ntry, ex5(:), wf4(:,39), wf8(:,363), n3(:,283), t3x8(:,:,247))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,40), wf8(:,364), n3(:,284), t3x8(:,:,248))
  call counter_V_V(EWctAA,ntry, wf4(:,7), 34, wf4(:,49), n2(129))
  call vert_VQ_A(ntry, wf4(:,49), ex3(:), wf8(:,365), n3(:,285), t3x8(:,:,249))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 34, wf4(:,50), n2(130))
  call vert_ZQ_A(gZl,ntry, wf4(:,50), ex3(:), wf8(:,366), n3(:,286), t3x8(:,:,250))
  call counter_V_V(EWctAZ,ntry, wf4(:,8), 34, wf4(:,51), n2(131))
  call vert_VQ_A(ntry, wf4(:,51), ex3(:), wf8(:,367), n3(:,287), t3x8(:,:,251))
  call counter_V_V(EWctZZ,ntry, wf4(:,8), 34, wf4(:,52), n2(132))
  call vert_ZQ_A(gZl,ntry, wf4(:,52), ex3(:), wf8(:,368), n3(:,288), t3x8(:,:,252))
  call vert_AV_Q(ntry, ex5(:), wf4(:,49), wf8(:,369), n3(:,289), t3x8(:,:,253))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,50), wf8(:,370), n3(:,290), t3x8(:,:,254))
  call vert_AV_Q(ntry, ex5(:), wf4(:,51), wf8(:,371), n3(:,291), t3x8(:,:,255))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,52), wf8(:,372), n3(:,292), t3x8(:,:,256))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,27), 38, wf8(:,373), n2(133))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,29), 38, wf8(:,374), n2(134))
  call counter_V_V(EWctAA,ntry, wf4(:,9), 36, wf4(:,53), n2(135))
  call vert_VQ_A(ntry, wf4(:,53), ex2(:), wf8(:,375), n3(:,293), t3x8(:,:,257))
  call counter_V_V(EWctAZ,ntry, wf4(:,10), 36, wf4(:,54), n2(136))
  call vert_VQ_A(ntry, wf4(:,54), ex2(:), wf8(:,376), n3(:,294), t3x8(:,:,258))
  call counter_V_V(EWctAZ,ntry, wf4(:,9), 36, wf4(:,55), n2(137))
  call vert_ZQ_A(gZl,ntry, wf4(:,55), ex2(:), wf8(:,377), n3(:,295), t3x8(:,:,259))
  call counter_V_V(EWctZZ,ntry, wf4(:,10), 36, wf4(:,56), n2(138))
  call vert_ZQ_A(gZl,ntry, wf4(:,56), ex2(:), wf8(:,378), n3(:,296), t3x8(:,:,260))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,34), 38, wf8(:,379), n2(139))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,36), 38, wf8(:,380), n2(140))
  call vert_AV_Q(ntry, ex5(:), wf4(:,53), wf8(:,381), n3(:,297), t3x8(:,:,261))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,55), wf8(:,382), n3(:,298), t3x8(:,:,262))
  call vert_AV_Q(ntry, ex5(:), wf4(:,54), wf8(:,383), n3(:,299), t3x8(:,:,263))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,56), wf8(:,384), n3(:,300), t3x8(:,:,264))
  call counter_V_V(EWctAA,ntry, wf4(:,11), 17, wf4(:,57), n2(141))
  call vert_VQ_A(ntry, wf4(:,57), ex3(:), wf8(:,385), n3(:,301), t3x8(:,:,265))
  call counter_V_V(EWctAZ,ntry, wf4(:,11), 17, wf4(:,58), n2(142))
  call vert_ZQ_A(gZl,ntry, wf4(:,58), ex3(:), wf8(:,386), n3(:,302), t3x8(:,:,266))
  call counter_V_V(EWctAZ,ntry, wf4(:,14), 17, wf4(:,59), n2(143))
  call vert_VQ_A(ntry, wf4(:,59), ex3(:), wf8(:,387), n3(:,303), t3x8(:,:,267))
  call counter_V_V(EWctZZ,ntry, wf4(:,14), 17, wf4(:,60), n2(144))
  call vert_ZQ_A(gZl,ntry, wf4(:,60), ex3(:), wf8(:,388), n3(:,304), t3x8(:,:,268))
  call vert_AV_Q(ntry, ex6(:), wf4(:,57), wf8(:,389), n3(:,305), t3x8(:,:,269))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,58), wf8(:,390), n3(:,306), t3x8(:,:,270))
  call vert_AV_Q(ntry, ex6(:), wf4(:,59), wf8(:,391), n3(:,307), t3x8(:,:,271))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,60), wf8(:,392), n3(:,308), t3x8(:,:,272))
  call counter_V_V(EWctAA,ntry, wf4(:,12), 10, wf4(:,61), n2(145))
  call vert_VQ_A(ntry, wf4(:,61), ex3(:), wf8(:,393), n3(:,309), t3x8(:,:,273))
  call counter_V_V(EWctAZ,ntry, wf4(:,12), 10, wf4(:,62), n2(146))
  call vert_ZQ_A(gZl,ntry, wf4(:,62), ex3(:), wf8(:,394), n3(:,310), t3x8(:,:,274))
  call counter_V_V(EWctAZ,ntry, wf4(:,13), 10, wf4(:,63), n2(147))
  call vert_VQ_A(ntry, wf4(:,63), ex3(:), wf8(:,395), n3(:,311), t3x8(:,:,275))
  call counter_V_V(EWctZZ,ntry, wf4(:,13), 10, wf4(:,64), n2(148))
  call vert_ZQ_A(gZl,ntry, wf4(:,64), ex3(:), wf8(:,396), n3(:,312), t3x8(:,:,276))
  call vert_AV_Q(ntry, ex6(:), wf4(:,61), wf8(:,397), n3(:,313), t3x8(:,:,277))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,62), wf8(:,398), n3(:,314), t3x8(:,:,278))
  call vert_AV_Q(ntry, ex6(:), wf4(:,63), wf8(:,399), n3(:,315), t3x8(:,:,279))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,64), wf8(:,400), n3(:,316), t3x8(:,:,280))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,39), 21, wf8(:,401), n2(149))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,42), 21, wf8(:,402), n2(150))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,45), 14, wf8(:,403), n2(151))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,47), 14, wf8(:,404), n2(152))
  call vert_VQ_A(ntry, wf4(:,61), ex1(:), wf8(:,405), n3(:,317), t3x8(:,:,281))
  call vert_VQ_A(ntry, wf4(:,63), ex1(:), wf8(:,406), n3(:,318), t3x8(:,:,282))
  call vert_ZQ_A(gZl,ntry, wf4(:,62), ex1(:), wf8(:,407), n3(:,319), t3x8(:,:,283))
  call vert_ZQ_A(gZl,ntry, wf4(:,64), ex1(:), wf8(:,408), n3(:,320), t3x8(:,:,284))
  call vert_VQ_A(ntry, wf4(:,45), ex1(:), wf8(:,409), n3(:,321), t3x8(:,:,285))
  call vert_VQ_A(ntry, wf4(:,46), ex1(:), wf8(:,410), n3(:,322), t3x8(:,:,286))
  call vert_ZQ_A(gZl,ntry, wf4(:,47), ex1(:), wf8(:,411), n3(:,323), t3x8(:,:,287))
  call vert_ZQ_A(gZl,ntry, wf4(:,48), ex1(:), wf8(:,412), n3(:,324), t3x8(:,:,288))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,50), 11, wf8(:,413), n2(153))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,52), 11, wf8(:,414), n2(154))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,54), 21, wf8(:,415), n2(155))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,56), 21, wf8(:,416), n2(156))
  call counter_V_V(EWctAA,ntry, wf4(:,15), 33, wf4(:,65), n2(157))
  call vert_VQ_A(ntry, wf4(:,65), ex3(:), wf8(:,417), n3(:,325), t3x8(:,:,289))
  call counter_V_V(EWctAZ,ntry, wf4(:,15), 33, wf4(:,66), n2(158))
  call vert_ZQ_A(gZl,ntry, wf4(:,66), ex3(:), wf8(:,418), n3(:,326), t3x8(:,:,290))
  call counter_V_V(EWctAZ,ntry, wf4(:,16), 33, wf4(:,67), n2(159))
  call vert_VQ_A(ntry, wf4(:,67), ex3(:), wf8(:,419), n3(:,327), t3x8(:,:,291))
  call counter_V_V(EWctZZ,ntry, wf4(:,16), 33, wf4(:,68), n2(160))
  call vert_ZQ_A(gZl,ntry, wf4(:,68), ex3(:), wf8(:,420), n3(:,328), t3x8(:,:,292))
  call vert_AV_Q(ntry, ex5(:), wf4(:,65), wf8(:,421), n3(:,329), t3x8(:,:,293))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,66), wf8(:,422), n3(:,330), t3x8(:,:,294))
  call vert_AV_Q(ntry, ex5(:), wf4(:,67), wf8(:,423), n3(:,331), t3x8(:,:,295))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,68), wf8(:,424), n3(:,332), t3x8(:,:,296))
  call vert_AV_Q(ntry, ex5(:), wf4(:,61), wf8(:,425), n3(:,333), t3x8(:,:,297))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,62), wf8(:,426), n3(:,334), t3x8(:,:,298))
  call vert_AV_Q(ntry, ex5(:), wf4(:,63), wf8(:,427), n3(:,335), t3x8(:,:,299))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,64), wf8(:,428), n3(:,336), t3x8(:,:,300))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,59), 37, wf8(:,429), n2(161))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,62), 37, wf8(:,430), n2(162))
  call vert_VQ_A(ntry, wf4(:,53), ex1(:), wf8(:,431), n3(:,337), t3x8(:,:,301))
  call vert_VQ_A(ntry, wf4(:,54), ex1(:), wf8(:,432), n3(:,338), t3x8(:,:,302))
  call vert_ZQ_A(gZl,ntry, wf4(:,55), ex1(:), wf8(:,433), n3(:,339), t3x8(:,:,303))
  call vert_ZQ_A(gZl,ntry, wf4(:,56), ex1(:), wf8(:,434), n3(:,340), t3x8(:,:,304))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,66), 37, wf8(:,435), n2(163))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,68), 37, wf8(:,436), n2(164))
  call vert_VQ_A(ntry, wf4(:,57), ex2(:), wf8(:,437), n3(:,341), t3x8(:,:,305))
  call vert_ZQ_A(gZl,ntry, wf4(:,58), ex2(:), wf8(:,438), n3(:,342), t3x8(:,:,306))
  call vert_VQ_A(ntry, wf4(:,59), ex2(:), wf8(:,439), n3(:,343), t3x8(:,:,307))
  call vert_ZQ_A(gZl,ntry, wf4(:,60), ex2(:), wf8(:,440), n3(:,344), t3x8(:,:,308))
  call counter_V_V(EWctAA,ntry, wf4(:,17), 12, wf4(:,69), n2(165))
  call vert_VQ_A(ntry, wf4(:,69), ex2(:), wf8(:,441), n3(:,345), t3x8(:,:,309))
  call counter_V_V(EWctAZ,ntry, wf4(:,18), 12, wf4(:,70), n2(166))
  call vert_VQ_A(ntry, wf4(:,70), ex2(:), wf8(:,442), n3(:,346), t3x8(:,:,310))
  call counter_V_V(EWctAZ,ntry, wf4(:,17), 12, wf4(:,71), n2(167))
  call vert_ZQ_A(gZl,ntry, wf4(:,71), ex2(:), wf8(:,443), n3(:,347), t3x8(:,:,311))
  call counter_V_V(EWctZZ,ntry, wf4(:,18), 12, wf4(:,72), n2(168))
  call vert_ZQ_A(gZl,ntry, wf4(:,72), ex2(:), wf8(:,444), n3(:,348), t3x8(:,:,312))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,71), 19, wf8(:,445), n2(169))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,74), 19, wf8(:,446), n2(170))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,76), 14, wf8(:,447), n2(171))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,78), 14, wf8(:,448), n2(172))
  call vert_AV_Q(ntry, ex6(:), wf4(:,69), wf8(:,449), n3(:,349), t3x8(:,:,313))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,71), wf8(:,450), n3(:,350), t3x8(:,:,314))
  call vert_AV_Q(ntry, ex6(:), wf4(:,70), wf8(:,451), n3(:,351), t3x8(:,:,315))
  call vert_AZ_Q(gZl,ntry, ex6(:), wf4(:,72), wf8(:,452), n3(:,352), t3x8(:,:,316))
  call vert_VQ_A(ntry, wf4(:,41), ex1(:), wf8(:,453), n3(:,353), t3x8(:,:,317))
  call vert_VQ_A(ntry, wf4(:,43), ex1(:), wf8(:,454), n3(:,354), t3x8(:,:,318))
  call vert_ZQ_A(gZl,ntry, wf4(:,42), ex1(:), wf8(:,455), n3(:,355), t3x8(:,:,319))
  call vert_ZQ_A(gZl,ntry, wf4(:,44), ex1(:), wf8(:,456), n3(:,356), t3x8(:,:,320))
  call vert_VQ_A(ntry, wf4(:,69), ex1(:), wf8(:,457), n3(:,357), t3x8(:,:,321))
  call vert_VQ_A(ntry, wf4(:,70), ex1(:), wf8(:,458), n3(:,358), t3x8(:,:,322))
  call vert_ZQ_A(gZl,ntry, wf4(:,71), ex1(:), wf8(:,459), n3(:,359), t3x8(:,:,323))
  call vert_ZQ_A(gZl,ntry, wf4(:,72), ex1(:), wf8(:,460), n3(:,360), t3x8(:,:,324))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,80), 19, wf8(:,461), n2(173))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,82), 19, wf8(:,462), n2(174))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,84), 13, wf8(:,463), n2(175))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,86), 13, wf8(:,464), n2(176))
  call vert_VQ_A(ntry, wf4(:,65), ex2(:), wf8(:,465), n3(:,361), t3x8(:,:,325))
  call vert_ZQ_A(gZl,ntry, wf4(:,66), ex2(:), wf8(:,466), n3(:,362), t3x8(:,:,326))
  call vert_VQ_A(ntry, wf4(:,67), ex2(:), wf8(:,467), n3(:,363), t3x8(:,:,327))
  call vert_ZQ_A(gZl,ntry, wf4(:,68), ex2(:), wf8(:,468), n3(:,364), t3x8(:,:,328))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,89), 35, wf8(:,469), n2(177))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,92), 35, wf8(:,470), n2(178))
  call vert_AV_Q(ntry, ex5(:), wf4(:,69), wf8(:,471), n3(:,365), t3x8(:,:,329))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,71), wf8(:,472), n3(:,366), t3x8(:,:,330))
  call vert_AV_Q(ntry, ex5(:), wf4(:,70), wf8(:,473), n3(:,367), t3x8(:,:,331))
  call vert_AZ_Q(gZl,ntry, ex5(:), wf4(:,72), wf8(:,474), n3(:,368), t3x8(:,:,332))
  call vert_VQ_A(ntry, wf4(:,49), ex1(:), wf8(:,475), n3(:,369), t3x8(:,:,333))
  call vert_VQ_A(ntry, wf4(:,51), ex1(:), wf8(:,476), n3(:,370), t3x8(:,:,334))
  call vert_ZQ_A(gZl,ntry, wf4(:,50), ex1(:), wf8(:,477), n3(:,371), t3x8(:,:,335))
  call vert_ZQ_A(gZl,ntry, wf4(:,52), ex1(:), wf8(:,478), n3(:,372), t3x8(:,:,336))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,94), 35, wf8(:,479), n2(179))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,96), 35, wf8(:,480), n2(180))
  call vert_AV_Q(ntry, ex4(:), wf4(:,57), wf8(:,481), n3(:,373), t3x8(:,:,337))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,58), wf8(:,482), n3(:,374), t3x8(:,:,338))
  call vert_AV_Q(ntry, ex4(:), wf4(:,59), wf8(:,483), n3(:,375), t3x8(:,:,339))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,60), wf8(:,484), n3(:,376), t3x8(:,:,340))
  call vert_AV_Q(ntry, ex4(:), wf4(:,49), wf8(:,485), n3(:,377), t3x8(:,:,341))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,50), wf8(:,486), n3(:,378), t3x8(:,:,342))
  call vert_AV_Q(ntry, ex4(:), wf4(:,51), wf8(:,487), n3(:,379), t3x8(:,:,343))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,52), wf8(:,488), n3(:,380), t3x8(:,:,344))
  call vert_AV_Q(ntry, ex4(:), wf4(:,53), wf8(:,489), n3(:,381), t3x8(:,:,345))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,55), wf8(:,490), n3(:,382), t3x8(:,:,346))
  call vert_AV_Q(ntry, ex4(:), wf4(:,54), wf8(:,491), n3(:,383), t3x8(:,:,347))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,56), wf8(:,492), n3(:,384), t3x8(:,:,348))
  call vert_AV_Q(ntry, ex4(:), wf4(:,65), wf8(:,493), n3(:,385), t3x8(:,:,349))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,66), wf8(:,494), n3(:,386), t3x8(:,:,350))
  call vert_AV_Q(ntry, ex4(:), wf4(:,67), wf8(:,495), n3(:,387), t3x8(:,:,351))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,68), wf8(:,496), n3(:,388), t3x8(:,:,352))
  call vert_AV_Q(ntry, ex4(:), wf4(:,41), wf8(:,497), n3(:,389), t3x8(:,:,353))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,42), wf8(:,498), n3(:,390), t3x8(:,:,354))
  call vert_AV_Q(ntry, ex4(:), wf4(:,43), wf8(:,499), n3(:,391), t3x8(:,:,355))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,44), wf8(:,500), n3(:,392), t3x8(:,:,356))
  call vert_AV_Q(ntry, ex4(:), wf4(:,45), wf8(:,501), n3(:,393), t3x8(:,:,357))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,47), wf8(:,502), n3(:,394), t3x8(:,:,358))
  call vert_AV_Q(ntry, ex4(:), wf4(:,46), wf8(:,503), n3(:,395), t3x8(:,:,359))
  call vert_AZ_Q(gZl,ntry, ex4(:), wf4(:,48), wf8(:,504), n3(:,396), t3x8(:,:,360))
  call vert_VV_S(ntry, wf4(:,4), wf4(:,3), wf16(:,1), n3(:,397), t3x16(:,:,1))
  call vert_VV_S(ntry, wf4(:,4), wf4(:,6), wf16(:,2), n3(:,398), t3x16(:,:,2))
  call vert_VV_S(ntry, wf4(:,4), wf4(:,8), wf16(:,3), n3(:,399), t3x16(:,:,3))
  call vert_VV_S(ntry, wf4(:,4), wf4(:,10), wf16(:,4), n3(:,400), t3x16(:,:,4))
  call vert_QA_V(ntry, wf8(:,15), ex5(:), wf16(:,5), n3(:,401), t3x16(:,:,5))
  call vert_QA_Z(gZl,ntry, wf8(:,15), ex5(:), wf16(:,6), n3(:,402), t3x16(:,:,6))
  call vert_QA_V(ntry, wf8(:,18), ex5(:), wf16(:,7), n3(:,403), t3x16(:,:,7))
  call vert_QA_Z(gZl,ntry, wf8(:,18), ex5(:), wf16(:,8), n3(:,404), t3x16(:,:,8))
  call vert_QA_V(ntry, wf8(:,15), ex6(:), wf16(:,9), n3(:,405), t3x16(:,:,9))
  call vert_QA_Z(gZl,ntry, wf8(:,15), ex6(:), wf16(:,10), n3(:,406), t3x16(:,:,10))
  call vert_QA_V(ntry, wf8(:,18), ex6(:), wf16(:,11), n3(:,407), t3x16(:,:,11))
  call vert_QA_Z(gZl,ntry, wf8(:,18), ex6(:), wf16(:,12), n3(:,408), t3x16(:,:,12))
  call vert_QA_V(ntry, wf8(:,3), ex5(:), wf16(:,13), n3(:,409), t3x16(:,:,13))
  call vert_QA_Z(gZl,ntry, wf8(:,3), ex5(:), wf16(:,14), n3(:,410), t3x16(:,:,14))
  call vert_QA_V(ntry, wf8(:,6), ex5(:), wf16(:,15), n3(:,411), t3x16(:,:,15))
  call vert_QA_Z(gZl,ntry, wf8(:,6), ex5(:), wf16(:,16), n3(:,412), t3x16(:,:,16))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,17), n3(:,413), t3x16(:,:,17))
  call vert_QA_Z(gZl,ntry, wf8(:,3), ex6(:), wf16(:,18), n3(:,414), t3x16(:,:,18))
  call vert_QA_V(ntry, wf8(:,6), ex6(:), wf16(:,19), n3(:,415), t3x16(:,:,19))
  call vert_QA_Z(gZl,ntry, wf8(:,6), ex6(:), wf16(:,20), n3(:,416), t3x16(:,:,20))
  call vert_QA_V(ntry, ex2(:), wf8(:,154), wf16(:,21), n3(:,417), t3x16(:,:,21))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,154), wf16(:,22), n3(:,418), t3x16(:,:,22))
  call vert_QA_V(ntry, ex2(:), wf8(:,156), wf16(:,23), n3(:,419), t3x16(:,:,23))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,156), wf16(:,24), n3(:,420), t3x16(:,:,24))
  call vert_QA_V(ntry, ex3(:), wf8(:,154), wf16(:,25), n3(:,421), t3x16(:,:,25))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,154), wf16(:,26), n3(:,422), t3x16(:,:,26))
  call vert_QA_V(ntry, ex3(:), wf8(:,156), wf16(:,27), n3(:,423), t3x16(:,:,27))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,156), wf16(:,28), n3(:,424), t3x16(:,:,28))
  call vert_QA_V(ntry, ex2(:), wf8(:,146), wf16(:,29), n3(:,425), t3x16(:,:,29))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,146), wf16(:,30), n3(:,426), t3x16(:,:,30))
  call vert_QA_V(ntry, ex2(:), wf8(:,148), wf16(:,31), n3(:,427), t3x16(:,:,31))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,148), wf16(:,32), n3(:,428), t3x16(:,:,32))
  call vert_QA_V(ntry, ex3(:), wf8(:,146), wf16(:,33), n3(:,429), t3x16(:,:,33))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,146), wf16(:,34), n3(:,430), t3x16(:,:,34))
  call vert_QA_V(ntry, ex3(:), wf8(:,148), wf16(:,35), n3(:,431), t3x16(:,:,35))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,148), wf16(:,36), n3(:,432), t3x16(:,:,36))
  call vert_VV_S(ntry, wf4(:,13), wf4(:,14), wf16(:,37), n3(:,433), t3x16(:,:,37))
  call vert_VV_S(ntry, wf4(:,13), wf4(:,6), wf16(:,38), n3(:,434), t3x16(:,:,38))
  call vert_VV_S(ntry, wf4(:,13), wf4(:,16), wf16(:,39), n3(:,435), t3x16(:,:,39))
  call vert_VV_S(ntry, wf4(:,13), wf4(:,10), wf16(:,40), n3(:,436), t3x16(:,:,40))
  call vert_QA_V(ntry, wf8(:,50), ex5(:), wf16(:,41), n3(:,437), t3x16(:,:,41))
  call vert_QA_Z(gZl,ntry, wf8(:,50), ex5(:), wf16(:,42), n3(:,438), t3x16(:,:,42))
  call vert_QA_V(ntry, wf8(:,52), ex5(:), wf16(:,43), n3(:,439), t3x16(:,:,43))
  call vert_QA_Z(gZl,ntry, wf8(:,52), ex5(:), wf16(:,44), n3(:,440), t3x16(:,:,44))
  call vert_QA_V(ntry, wf8(:,50), ex6(:), wf16(:,45), n3(:,441), t3x16(:,:,45))
  call vert_QA_Z(gZl,ntry, wf8(:,50), ex6(:), wf16(:,46), n3(:,442), t3x16(:,:,46))
  call vert_QA_V(ntry, wf8(:,52), ex6(:), wf16(:,47), n3(:,443), t3x16(:,:,47))
  call vert_QA_Z(gZl,ntry, wf8(:,52), ex6(:), wf16(:,48), n3(:,444), t3x16(:,:,48))
  call vert_QA_V(ntry, ex1(:), wf8(:,182), wf16(:,49), n3(:,445), t3x16(:,:,49))
  call vert_QA_V(ntry, ex1(:), wf8(:,183), wf16(:,50), n3(:,446), t3x16(:,:,50))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,182), wf16(:,51), n3(:,447), t3x16(:,:,51))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,183), wf16(:,52), n3(:,448), t3x16(:,:,52))
  call vert_QA_V(ntry, ex1(:), wf8(:,176), wf16(:,53), n3(:,449), t3x16(:,:,53))
  call vert_QA_V(ntry, ex1(:), wf8(:,177), wf16(:,54), n3(:,450), t3x16(:,:,54))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,176), wf16(:,55), n3(:,451), t3x16(:,:,55))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,177), wf16(:,56), n3(:,452), t3x16(:,:,56))
  call vert_QA_V(ntry, wf8(:,45), ex5(:), wf16(:,57), n3(:,453), t3x16(:,:,57))
  call vert_QA_Z(gZl,ntry, wf8(:,45), ex5(:), wf16(:,58), n3(:,454), t3x16(:,:,58))
  call vert_QA_V(ntry, wf8(:,47), ex5(:), wf16(:,59), n3(:,455), t3x16(:,:,59))
  call vert_QA_Z(gZl,ntry, wf8(:,47), ex5(:), wf16(:,60), n3(:,456), t3x16(:,:,60))
  call vert_QA_V(ntry, wf8(:,45), ex6(:), wf16(:,61), n3(:,457), t3x16(:,:,61))
  call vert_QA_Z(gZl,ntry, wf8(:,45), ex6(:), wf16(:,62), n3(:,458), t3x16(:,:,62))
  call vert_QA_V(ntry, wf8(:,47), ex6(:), wf16(:,63), n3(:,459), t3x16(:,:,63))
  call vert_QA_Z(gZl,ntry, wf8(:,47), ex6(:), wf16(:,64), n3(:,460), t3x16(:,:,64))
  call vert_QA_V(ntry, ex3(:), wf8(:,182), wf16(:,65), n3(:,461), t3x16(:,:,65))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,182), wf16(:,66), n3(:,462), t3x16(:,:,66))
  call vert_QA_V(ntry, ex3(:), wf8(:,183), wf16(:,67), n3(:,463), t3x16(:,:,67))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,183), wf16(:,68), n3(:,464), t3x16(:,:,68))
  call vert_QA_V(ntry, ex3(:), wf8(:,176), wf16(:,69), n3(:,465), t3x16(:,:,69))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,176), wf16(:,70), n3(:,466), t3x16(:,:,70))
  call vert_QA_V(ntry, ex3(:), wf8(:,177), wf16(:,71), n3(:,467), t3x16(:,:,71))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,177), wf16(:,72), n3(:,468), t3x16(:,:,72))
  call vert_VV_S(ntry, wf4(:,18), wf4(:,14), wf16(:,73), n3(:,469), t3x16(:,:,73))
  call vert_VV_S(ntry, wf4(:,18), wf4(:,3), wf16(:,74), n3(:,470), t3x16(:,:,74))
  call vert_VV_S(ntry, wf4(:,18), wf4(:,16), wf16(:,75), n3(:,471), t3x16(:,:,75))
  call vert_VV_S(ntry, wf4(:,18), wf4(:,8), wf16(:,76), n3(:,472), t3x16(:,:,76))
  call vert_QA_V(ntry, wf8(:,84), ex5(:), wf16(:,77), n3(:,473), t3x16(:,:,77))
  call vert_QA_Z(gZl,ntry, wf8(:,84), ex5(:), wf16(:,78), n3(:,474), t3x16(:,:,78))
  call vert_QA_V(ntry, wf8(:,86), ex5(:), wf16(:,79), n3(:,475), t3x16(:,:,79))
  call vert_QA_Z(gZl,ntry, wf8(:,86), ex5(:), wf16(:,80), n3(:,476), t3x16(:,:,80))
  call vert_QA_V(ntry, wf8(:,84), ex6(:), wf16(:,81), n3(:,477), t3x16(:,:,81))
  call vert_QA_Z(gZl,ntry, wf8(:,84), ex6(:), wf16(:,82), n3(:,478), t3x16(:,:,82))
  call vert_QA_V(ntry, wf8(:,86), ex6(:), wf16(:,83), n3(:,479), t3x16(:,:,83))
  call vert_QA_Z(gZl,ntry, wf8(:,86), ex6(:), wf16(:,84), n3(:,480), t3x16(:,:,84))
  call vert_QA_V(ntry, ex1(:), wf8(:,246), wf16(:,85), n3(:,481), t3x16(:,:,85))
  call vert_QA_V(ntry, ex1(:), wf8(:,247), wf16(:,86), n3(:,482), t3x16(:,:,86))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,246), wf16(:,87), n3(:,483), t3x16(:,:,87))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,247), wf16(:,88), n3(:,484), t3x16(:,:,88))
  call vert_QA_V(ntry, ex1(:), wf8(:,242), wf16(:,89), n3(:,485), t3x16(:,:,89))
  call vert_QA_V(ntry, ex1(:), wf8(:,243), wf16(:,90), n3(:,486), t3x16(:,:,90))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,242), wf16(:,91), n3(:,487), t3x16(:,:,91))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,243), wf16(:,92), n3(:,488), t3x16(:,:,92))
  call vert_QA_V(ntry, wf8(:,76), ex5(:), wf16(:,93), n3(:,489), t3x16(:,:,93))
  call vert_QA_Z(gZl,ntry, wf8(:,76), ex5(:), wf16(:,94), n3(:,490), t3x16(:,:,94))
  call vert_QA_V(ntry, wf8(:,78), ex5(:), wf16(:,95), n3(:,491), t3x16(:,:,95))
  call vert_QA_Z(gZl,ntry, wf8(:,78), ex5(:), wf16(:,96), n3(:,492), t3x16(:,:,96))
  call vert_QA_V(ntry, wf8(:,76), ex6(:), wf16(:,97), n3(:,493), t3x16(:,:,97))
  call vert_QA_Z(gZl,ntry, wf8(:,76), ex6(:), wf16(:,98), n3(:,494), t3x16(:,:,98))
  call vert_QA_V(ntry, wf8(:,78), ex6(:), wf16(:,99), n3(:,495), t3x16(:,:,99))
  call vert_QA_Z(gZl,ntry, wf8(:,78), ex6(:), wf16(:,100), n3(:,496), t3x16(:,:,100))
  call vert_QA_V(ntry, ex2(:), wf8(:,246), wf16(:,101), n3(:,497), t3x16(:,:,101))
  call vert_QA_V(ntry, ex2(:), wf8(:,247), wf16(:,102), n3(:,498), t3x16(:,:,102))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,246), wf16(:,103), n3(:,499), t3x16(:,:,103))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,247), wf16(:,104), n3(:,500), t3x16(:,:,104))
  call vert_QA_V(ntry, ex2(:), wf8(:,242), wf16(:,105), n3(:,501), t3x16(:,:,105))
  call vert_QA_V(ntry, ex2(:), wf8(:,243), wf16(:,106), n3(:,502), t3x16(:,:,106))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,242), wf16(:,107), n3(:,503), t3x16(:,:,107))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,243), wf16(:,108), n3(:,504), t3x16(:,:,108))
  call vert_VV_S(ntry, wf4(:,14), wf4(:,8), wf16(:,109), n3(:,505), t3x16(:,:,109))
  call vert_VV_S(ntry, wf4(:,14), wf4(:,10), wf16(:,110), n3(:,506), t3x16(:,:,110))
  call vert_QA_V(ntry, wf8(:,71), ex4(:), wf16(:,111), n3(:,507), t3x16(:,:,111))
  call vert_QA_Z(gZl,ntry, wf8(:,71), ex4(:), wf16(:,112), n3(:,508), t3x16(:,:,112))
  call vert_QA_V(ntry, wf8(:,74), ex4(:), wf16(:,113), n3(:,509), t3x16(:,:,113))
  call vert_QA_Z(gZl,ntry, wf8(:,74), ex4(:), wf16(:,114), n3(:,510), t3x16(:,:,114))
  call vert_QA_V(ntry, wf8(:,71), ex6(:), wf16(:,115), n3(:,511), t3x16(:,:,115))
  call vert_QA_Z(gZl,ntry, wf8(:,71), ex6(:), wf16(:,116), n3(:,512), t3x16(:,:,116))
  call vert_QA_V(ntry, wf8(:,74), ex6(:), wf16(:,117), n3(:,513), t3x16(:,:,117))
  call vert_QA_Z(gZl,ntry, wf8(:,74), ex6(:), wf16(:,118), n3(:,514), t3x16(:,:,118))
  call vert_QA_V(ntry, wf8(:,39), ex4(:), wf16(:,119), n3(:,515), t3x16(:,:,119))
  call vert_QA_Z(gZl,ntry, wf8(:,39), ex4(:), wf16(:,120), n3(:,516), t3x16(:,:,120))
  call vert_QA_V(ntry, wf8(:,42), ex4(:), wf16(:,121), n3(:,517), t3x16(:,:,121))
  call vert_QA_Z(gZl,ntry, wf8(:,42), ex4(:), wf16(:,122), n3(:,518), t3x16(:,:,122))
  call vert_QA_V(ntry, wf8(:,39), ex6(:), wf16(:,123), n3(:,519), t3x16(:,:,123))
  call vert_QA_Z(gZl,ntry, wf8(:,39), ex6(:), wf16(:,124), n3(:,520), t3x16(:,:,124))
  call vert_QA_V(ntry, wf8(:,42), ex6(:), wf16(:,125), n3(:,521), t3x16(:,:,125))
  call vert_QA_Z(gZl,ntry, wf8(:,42), ex6(:), wf16(:,126), n3(:,522), t3x16(:,:,126))
  call vert_QA_V(ntry, ex2(:), wf8(:,193), wf16(:,127), n3(:,523), t3x16(:,:,127))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,193), wf16(:,128), n3(:,524), t3x16(:,:,128))
  call vert_QA_V(ntry, ex2(:), wf8(:,194), wf16(:,129), n3(:,525), t3x16(:,:,129))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,194), wf16(:,130), n3(:,526), t3x16(:,:,130))
  call vert_QA_V(ntry, ex3(:), wf8(:,193), wf16(:,131), n3(:,527), t3x16(:,:,131))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,193), wf16(:,132), n3(:,528), t3x16(:,:,132))
  call vert_QA_V(ntry, ex3(:), wf8(:,194), wf16(:,133), n3(:,529), t3x16(:,:,133))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,194), wf16(:,134), n3(:,530), t3x16(:,:,134))
  call vert_QA_V(ntry, ex2(:), wf8(:,172), wf16(:,135), n3(:,531), t3x16(:,:,135))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,172), wf16(:,136), n3(:,532), t3x16(:,:,136))
  call vert_QA_V(ntry, ex2(:), wf8(:,174), wf16(:,137), n3(:,533), t3x16(:,:,137))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,174), wf16(:,138), n3(:,534), t3x16(:,:,138))
  call vert_QA_V(ntry, ex3(:), wf8(:,172), wf16(:,139), n3(:,535), t3x16(:,:,139))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,172), wf16(:,140), n3(:,536), t3x16(:,:,140))
  call vert_QA_V(ntry, ex3(:), wf8(:,174), wf16(:,141), n3(:,537), t3x16(:,:,141))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,174), wf16(:,142), n3(:,538), t3x16(:,:,142))
  call vert_VV_S(ntry, wf4(:,3), wf4(:,16), wf16(:,143), n3(:,539), t3x16(:,:,143))
  call vert_VV_S(ntry, wf4(:,3), wf4(:,10), wf16(:,144), n3(:,540), t3x16(:,:,144))
  call vert_QA_V(ntry, wf8(:,80), ex4(:), wf16(:,145), n3(:,541), t3x16(:,:,145))
  call vert_QA_Z(gZl,ntry, wf8(:,80), ex4(:), wf16(:,146), n3(:,542), t3x16(:,:,146))
  call vert_QA_V(ntry, wf8(:,82), ex4(:), wf16(:,147), n3(:,543), t3x16(:,:,147))
  call vert_QA_Z(gZl,ntry, wf8(:,82), ex4(:), wf16(:,148), n3(:,544), t3x16(:,:,148))
  call vert_QA_V(ntry, wf8(:,80), ex6(:), wf16(:,149), n3(:,545), t3x16(:,:,149))
  call vert_QA_Z(gZl,ntry, wf8(:,80), ex6(:), wf16(:,150), n3(:,546), t3x16(:,:,150))
  call vert_QA_V(ntry, wf8(:,82), ex6(:), wf16(:,151), n3(:,547), t3x16(:,:,151))
  call vert_QA_Z(gZl,ntry, wf8(:,82), ex6(:), wf16(:,152), n3(:,548), t3x16(:,:,152))
  call vert_QA_V(ntry, ex1(:), wf8(:,201), wf16(:,153), n3(:,549), t3x16(:,:,153))
  call vert_QA_V(ntry, ex1(:), wf8(:,202), wf16(:,154), n3(:,550), t3x16(:,:,154))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,201), wf16(:,155), n3(:,551), t3x16(:,:,155))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,202), wf16(:,156), n3(:,552), t3x16(:,:,156))
  call vert_QA_V(ntry, ex1(:), wf8(:,150), wf16(:,157), n3(:,553), t3x16(:,:,157))
  call vert_QA_V(ntry, ex1(:), wf8(:,151), wf16(:,158), n3(:,554), t3x16(:,:,158))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,150), wf16(:,159), n3(:,555), t3x16(:,:,159))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,151), wf16(:,160), n3(:,556), t3x16(:,:,160))
  call vert_QA_V(ntry, wf8(:,9), ex4(:), wf16(:,161), n3(:,557), t3x16(:,:,161))
  call vert_QA_Z(gZl,ntry, wf8(:,9), ex4(:), wf16(:,162), n3(:,558), t3x16(:,:,162))
  call vert_QA_V(ntry, wf8(:,11), ex4(:), wf16(:,163), n3(:,559), t3x16(:,:,163))
  call vert_QA_Z(gZl,ntry, wf8(:,11), ex4(:), wf16(:,164), n3(:,560), t3x16(:,:,164))
  call vert_QA_V(ntry, wf8(:,9), ex6(:), wf16(:,165), n3(:,561), t3x16(:,:,165))
  call vert_QA_Z(gZl,ntry, wf8(:,9), ex6(:), wf16(:,166), n3(:,562), t3x16(:,:,166))
  call vert_QA_V(ntry, wf8(:,11), ex6(:), wf16(:,167), n3(:,563), t3x16(:,:,167))
  call vert_QA_Z(gZl,ntry, wf8(:,11), ex6(:), wf16(:,168), n3(:,564), t3x16(:,:,168))
  call vert_QA_V(ntry, ex3(:), wf8(:,201), wf16(:,169), n3(:,565), t3x16(:,:,169))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,201), wf16(:,170), n3(:,566), t3x16(:,:,170))
  call vert_QA_V(ntry, ex3(:), wf8(:,202), wf16(:,171), n3(:,567), t3x16(:,:,171))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,202), wf16(:,172), n3(:,568), t3x16(:,:,172))
  call vert_QA_V(ntry, ex3(:), wf8(:,150), wf16(:,173), n3(:,569), t3x16(:,:,173))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,150), wf16(:,174), n3(:,570), t3x16(:,:,174))
  call vert_QA_V(ntry, ex3(:), wf8(:,151), wf16(:,175), n3(:,571), t3x16(:,:,175))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,151), wf16(:,176), n3(:,572), t3x16(:,:,176))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,16), wf16(:,177), n3(:,573), t3x16(:,:,177))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,8), wf16(:,178), n3(:,574), t3x16(:,:,178))
  call vert_QA_V(ntry, wf8(:,54), ex4(:), wf16(:,179), n3(:,575), t3x16(:,:,179))
  call vert_QA_Z(gZl,ntry, wf8(:,54), ex4(:), wf16(:,180), n3(:,576), t3x16(:,:,180))
  call vert_QA_V(ntry, wf8(:,56), ex4(:), wf16(:,181), n3(:,577), t3x16(:,:,181))
  call vert_QA_Z(gZl,ntry, wf8(:,56), ex4(:), wf16(:,182), n3(:,578), t3x16(:,:,182))
  call vert_QA_V(ntry, wf8(:,54), ex6(:), wf16(:,183), n3(:,579), t3x16(:,:,183))
  call vert_QA_Z(gZl,ntry, wf8(:,54), ex6(:), wf16(:,184), n3(:,580), t3x16(:,:,184))
  call vert_QA_V(ntry, wf8(:,56), ex6(:), wf16(:,185), n3(:,581), t3x16(:,:,185))
  call vert_QA_Z(gZl,ntry, wf8(:,56), ex6(:), wf16(:,186), n3(:,582), t3x16(:,:,186))
  call vert_QA_V(ntry, ex1(:), wf8(:,261), wf16(:,187), n3(:,583), t3x16(:,:,187))
  call vert_QA_V(ntry, ex1(:), wf8(:,262), wf16(:,188), n3(:,584), t3x16(:,:,188))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,261), wf16(:,189), n3(:,585), t3x16(:,:,189))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,262), wf16(:,190), n3(:,586), t3x16(:,:,190))
  call vert_QA_V(ntry, ex1(:), wf8(:,220), wf16(:,191), n3(:,587), t3x16(:,:,191))
  call vert_QA_V(ntry, ex1(:), wf8(:,221), wf16(:,192), n3(:,588), t3x16(:,:,192))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,220), wf16(:,193), n3(:,589), t3x16(:,:,193))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,221), wf16(:,194), n3(:,590), t3x16(:,:,194))
  call vert_QA_V(ntry, wf8(:,20), ex4(:), wf16(:,195), n3(:,591), t3x16(:,:,195))
  call vert_QA_Z(gZl,ntry, wf8(:,20), ex4(:), wf16(:,196), n3(:,592), t3x16(:,:,196))
  call vert_QA_V(ntry, wf8(:,22), ex4(:), wf16(:,197), n3(:,593), t3x16(:,:,197))
  call vert_QA_Z(gZl,ntry, wf8(:,22), ex4(:), wf16(:,198), n3(:,594), t3x16(:,:,198))
  call vert_QA_V(ntry, wf8(:,20), ex6(:), wf16(:,199), n3(:,595), t3x16(:,:,199))
  call vert_QA_Z(gZl,ntry, wf8(:,20), ex6(:), wf16(:,200), n3(:,596), t3x16(:,:,200))
  call vert_QA_V(ntry, wf8(:,22), ex6(:), wf16(:,201), n3(:,597), t3x16(:,:,201))
  call vert_QA_Z(gZl,ntry, wf8(:,22), ex6(:), wf16(:,202), n3(:,598), t3x16(:,:,202))
  call vert_QA_V(ntry, ex2(:), wf8(:,261), wf16(:,203), n3(:,599), t3x16(:,:,203))
  call vert_QA_V(ntry, ex2(:), wf8(:,262), wf16(:,204), n3(:,600), t3x16(:,:,204))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,261), wf16(:,205), n3(:,601), t3x16(:,:,205))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,262), wf16(:,206), n3(:,602), t3x16(:,:,206))
  call vert_QA_V(ntry, ex2(:), wf8(:,220), wf16(:,207), n3(:,603), t3x16(:,:,207))
  call vert_QA_V(ntry, ex2(:), wf8(:,221), wf16(:,208), n3(:,604), t3x16(:,:,208))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,220), wf16(:,209), n3(:,605), t3x16(:,:,209))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,221), wf16(:,210), n3(:,606), t3x16(:,:,210))
  call vert_QA_V(ntry, wf8(:,89), ex4(:), wf16(:,211), n3(:,607), t3x16(:,:,211))
  call vert_QA_Z(gZl,ntry, wf8(:,89), ex4(:), wf16(:,212), n3(:,608), t3x16(:,:,212))
  call vert_QA_V(ntry, wf8(:,92), ex4(:), wf16(:,213), n3(:,609), t3x16(:,:,213))
  call vert_QA_Z(gZl,ntry, wf8(:,92), ex4(:), wf16(:,214), n3(:,610), t3x16(:,:,214))
  call vert_QA_V(ntry, wf8(:,89), ex5(:), wf16(:,215), n3(:,611), t3x16(:,:,215))
  call vert_QA_Z(gZl,ntry, wf8(:,89), ex5(:), wf16(:,216), n3(:,612), t3x16(:,:,216))
  call vert_QA_V(ntry, wf8(:,92), ex5(:), wf16(:,217), n3(:,613), t3x16(:,:,217))
  call vert_QA_Z(gZl,ntry, wf8(:,92), ex5(:), wf16(:,218), n3(:,614), t3x16(:,:,218))
  call vert_QA_V(ntry, wf8(:,59), ex4(:), wf16(:,219), n3(:,615), t3x16(:,:,219))
  call vert_QA_Z(gZl,ntry, wf8(:,59), ex4(:), wf16(:,220), n3(:,616), t3x16(:,:,220))
  call vert_QA_V(ntry, wf8(:,62), ex4(:), wf16(:,221), n3(:,617), t3x16(:,:,221))
  call vert_QA_Z(gZl,ntry, wf8(:,62), ex4(:), wf16(:,222), n3(:,618), t3x16(:,:,222))
  call vert_QA_V(ntry, wf8(:,59), ex5(:), wf16(:,223), n3(:,619), t3x16(:,:,223))
  call vert_QA_Z(gZl,ntry, wf8(:,59), ex5(:), wf16(:,224), n3(:,620), t3x16(:,:,224))
  call vert_QA_V(ntry, wf8(:,62), ex5(:), wf16(:,225), n3(:,621), t3x16(:,:,225))
  call vert_QA_Z(gZl,ntry, wf8(:,62), ex5(:), wf16(:,226), n3(:,622), t3x16(:,:,226))
  call vert_QA_V(ntry, ex2(:), wf8(:,199), wf16(:,227), n3(:,623), t3x16(:,:,227))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,199), wf16(:,228), n3(:,624), t3x16(:,:,228))
  call vert_QA_V(ntry, ex2(:), wf8(:,200), wf16(:,229), n3(:,625), t3x16(:,:,229))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,200), wf16(:,230), n3(:,626), t3x16(:,:,230))
  call vert_QA_V(ntry, ex3(:), wf8(:,199), wf16(:,231), n3(:,627), t3x16(:,:,231))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,199), wf16(:,232), n3(:,628), t3x16(:,:,232))
  call vert_QA_V(ntry, ex3(:), wf8(:,200), wf16(:,233), n3(:,629), t3x16(:,:,233))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,200), wf16(:,234), n3(:,630), t3x16(:,:,234))
  call vert_QA_V(ntry, ex2(:), wf8(:,179), wf16(:,235), n3(:,631), t3x16(:,:,235))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,179), wf16(:,236), n3(:,632), t3x16(:,:,236))
  call vert_QA_V(ntry, ex2(:), wf8(:,180), wf16(:,237), n3(:,633), t3x16(:,:,237))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,180), wf16(:,238), n3(:,634), t3x16(:,:,238))
  call vert_QA_V(ntry, ex3(:), wf8(:,179), wf16(:,239), n3(:,635), t3x16(:,:,239))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,179), wf16(:,240), n3(:,636), t3x16(:,:,240))
  call vert_QA_V(ntry, ex3(:), wf8(:,180), wf16(:,241), n3(:,637), t3x16(:,:,241))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,180), wf16(:,242), n3(:,638), t3x16(:,:,242))
  call vert_QA_V(ntry, wf8(:,94), ex4(:), wf16(:,243), n3(:,639), t3x16(:,:,243))
  call vert_QA_Z(gZl,ntry, wf8(:,94), ex4(:), wf16(:,244), n3(:,640), t3x16(:,:,244))
  call vert_QA_V(ntry, wf8(:,96), ex4(:), wf16(:,245), n3(:,641), t3x16(:,:,245))
  call vert_QA_Z(gZl,ntry, wf8(:,96), ex4(:), wf16(:,246), n3(:,642), t3x16(:,:,246))
  call vert_QA_V(ntry, wf8(:,94), ex5(:), wf16(:,247), n3(:,643), t3x16(:,:,247))
  call vert_QA_Z(gZl,ntry, wf8(:,94), ex5(:), wf16(:,248), n3(:,644), t3x16(:,:,248))
  call vert_QA_V(ntry, wf8(:,96), ex5(:), wf16(:,249), n3(:,645), t3x16(:,:,249))
  call vert_QA_Z(gZl,ntry, wf8(:,96), ex5(:), wf16(:,250), n3(:,646), t3x16(:,:,250))
  call vert_QA_V(ntry, ex1(:), wf8(:,195), wf16(:,251), n3(:,647), t3x16(:,:,251))
  call vert_QA_V(ntry, ex1(:), wf8(:,196), wf16(:,252), n3(:,648), t3x16(:,:,252))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,195), wf16(:,253), n3(:,649), t3x16(:,:,253))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,196), wf16(:,254), n3(:,650), t3x16(:,:,254))
  call vert_QA_V(ntry, ex1(:), wf8(:,157), wf16(:,255), n3(:,651), t3x16(:,:,255))
  call vert_QA_V(ntry, ex1(:), wf8(:,158), wf16(:,256), n3(:,652), t3x16(:,:,256))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,157), wf16(:,257), n3(:,653), t3x16(:,:,257))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,158), wf16(:,258), n3(:,654), t3x16(:,:,258))
  call vert_QA_V(ntry, wf8(:,27), ex4(:), wf16(:,259), n3(:,655), t3x16(:,:,259))
  call vert_QA_Z(gZl,ntry, wf8(:,27), ex4(:), wf16(:,260), n3(:,656), t3x16(:,:,260))
  call vert_QA_V(ntry, wf8(:,29), ex4(:), wf16(:,261), n3(:,657), t3x16(:,:,261))
  call vert_QA_Z(gZl,ntry, wf8(:,29), ex4(:), wf16(:,262), n3(:,658), t3x16(:,:,262))
  call vert_QA_V(ntry, wf8(:,27), ex5(:), wf16(:,263), n3(:,659), t3x16(:,:,263))
  call vert_QA_Z(gZl,ntry, wf8(:,27), ex5(:), wf16(:,264), n3(:,660), t3x16(:,:,264))
  call vert_QA_V(ntry, wf8(:,29), ex5(:), wf16(:,265), n3(:,661), t3x16(:,:,265))
  call vert_QA_Z(gZl,ntry, wf8(:,29), ex5(:), wf16(:,266), n3(:,662), t3x16(:,:,266))
  call vert_QA_V(ntry, ex3(:), wf8(:,195), wf16(:,267), n3(:,663), t3x16(:,:,267))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,195), wf16(:,268), n3(:,664), t3x16(:,:,268))
  call vert_QA_V(ntry, ex3(:), wf8(:,196), wf16(:,269), n3(:,665), t3x16(:,:,269))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,196), wf16(:,270), n3(:,666), t3x16(:,:,270))
  call vert_QA_V(ntry, ex3(:), wf8(:,157), wf16(:,271), n3(:,667), t3x16(:,:,271))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,157), wf16(:,272), n3(:,668), t3x16(:,:,272))
  call vert_QA_V(ntry, ex3(:), wf8(:,158), wf16(:,273), n3(:,669), t3x16(:,:,273))
  call vert_QA_Z(gZl,ntry, ex3(:), wf8(:,158), wf16(:,274), n3(:,670), t3x16(:,:,274))
  call vert_QA_V(ntry, wf8(:,66), ex4(:), wf16(:,275), n3(:,671), t3x16(:,:,275))
  call vert_QA_Z(gZl,ntry, wf8(:,66), ex4(:), wf16(:,276), n3(:,672), t3x16(:,:,276))
  call vert_QA_V(ntry, wf8(:,68), ex4(:), wf16(:,277), n3(:,673), t3x16(:,:,277))
  call vert_QA_Z(gZl,ntry, wf8(:,68), ex4(:), wf16(:,278), n3(:,674), t3x16(:,:,278))
  call vert_QA_V(ntry, wf8(:,66), ex5(:), wf16(:,279), n3(:,675), t3x16(:,:,279))
  call vert_QA_Z(gZl,ntry, wf8(:,66), ex5(:), wf16(:,280), n3(:,676), t3x16(:,:,280))
  call vert_QA_V(ntry, wf8(:,68), ex5(:), wf16(:,281), n3(:,677), t3x16(:,:,281))
  call vert_QA_Z(gZl,ntry, wf8(:,68), ex5(:), wf16(:,282), n3(:,678), t3x16(:,:,282))
  call vert_QA_V(ntry, ex1(:), wf8(:,257), wf16(:,283), n3(:,679), t3x16(:,:,283))
  call vert_QA_V(ntry, ex1(:), wf8(:,258), wf16(:,284), n3(:,680), t3x16(:,:,284))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,257), wf16(:,285), n3(:,681), t3x16(:,:,285))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,258), wf16(:,286), n3(:,682), t3x16(:,:,286))
  call vert_QA_V(ntry, ex1(:), wf8(:,225), wf16(:,287), n3(:,683), t3x16(:,:,287))
  call vert_QA_V(ntry, ex1(:), wf8(:,226), wf16(:,288), n3(:,684), t3x16(:,:,288))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,225), wf16(:,289), n3(:,685), t3x16(:,:,289))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,226), wf16(:,290), n3(:,686), t3x16(:,:,290))
  call vert_QA_V(ntry, wf8(:,34), ex4(:), wf16(:,291), n3(:,687), t3x16(:,:,291))
  call vert_QA_Z(gZl,ntry, wf8(:,34), ex4(:), wf16(:,292), n3(:,688), t3x16(:,:,292))
  call vert_QA_V(ntry, wf8(:,36), ex4(:), wf16(:,293), n3(:,689), t3x16(:,:,293))
  call vert_QA_Z(gZl,ntry, wf8(:,36), ex4(:), wf16(:,294), n3(:,690), t3x16(:,:,294))
  call vert_QA_V(ntry, wf8(:,34), ex5(:), wf16(:,295), n3(:,691), t3x16(:,:,295))
  call vert_QA_Z(gZl,ntry, wf8(:,34), ex5(:), wf16(:,296), n3(:,692), t3x16(:,:,296))
  call vert_QA_V(ntry, wf8(:,36), ex5(:), wf16(:,297), n3(:,693), t3x16(:,:,297))
  call vert_QA_Z(gZl,ntry, wf8(:,36), ex5(:), wf16(:,298), n3(:,694), t3x16(:,:,298))
  call vert_QA_V(ntry, ex2(:), wf8(:,257), wf16(:,299), n3(:,695), t3x16(:,:,299))
  call vert_QA_V(ntry, ex2(:), wf8(:,258), wf16(:,300), n3(:,696), t3x16(:,:,300))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,257), wf16(:,301), n3(:,697), t3x16(:,:,301))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,258), wf16(:,302), n3(:,698), t3x16(:,:,302))
  call vert_QA_V(ntry, ex2(:), wf8(:,225), wf16(:,303), n3(:,699), t3x16(:,:,303))
  call vert_QA_V(ntry, ex2(:), wf8(:,226), wf16(:,304), n3(:,700), t3x16(:,:,304))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,225), wf16(:,305), n3(:,701), t3x16(:,:,305))
  call vert_QA_Z(gZl,ntry, ex2(:), wf8(:,226), wf16(:,306), n3(:,702), t3x16(:,:,306))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,1), n3(:,703), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,4), A(:,2), n3(:,704), t3x64(:,:,2), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,6), A(:,3), n3(:,705), t3x64(:,:,3), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,6), A(:,4), n3(:,706), t3x64(:,:,4), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,5), n3(:,707), t3x64(:,:,5), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,11), A(:,6), n3(:,708), t3x64(:,:,6), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,12), A(:,7), n3(:,709), t3x64(:,:,7), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,8), n3(:,710), t3x64(:,:,8), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,9), n3(:,711), t3x64(:,:,9), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,16), A(:,10), n3(:,712), t3x64(:,:,10), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,18), A(:,11), n3(:,713), t3x64(:,:,11), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,18), A(:,12), n3(:,714), t3x64(:,:,12), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,20), A(:,13), n3(:,715), t3x64(:,:,13), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,22), A(:,14), n3(:,716), t3x64(:,:,14), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,20), A(:,15), n3(:,717), t3x64(:,:,15), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,22), A(:,16), n3(:,718), t3x64(:,:,16), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,23), A(:,17), n3(:,719), t3x64(:,:,17), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,24), A(:,18), n3(:,720), t3x64(:,:,18), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,23), A(:,19), n3(:,721), t3x64(:,:,19), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,24), A(:,20), n3(:,722), t3x64(:,:,20), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,21), n3(:,723), t3x64(:,:,21), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,29), A(:,22), n3(:,724), t3x64(:,:,22), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,30), A(:,23), n3(:,725), t3x64(:,:,23), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,30), A(:,24), n3(:,726), t3x64(:,:,24), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,31), A(:,25), n3(:,727), t3x64(:,:,25), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,32), A(:,26), n3(:,728), t3x64(:,:,26), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,31), A(:,27), n3(:,729), t3x64(:,:,27), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,32), A(:,28), n3(:,730), t3x64(:,:,28), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,34), A(:,29), n3(:,731), t3x64(:,:,29), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,36), A(:,30), n3(:,732), t3x64(:,:,30), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,34), A(:,31), n3(:,733), t3x64(:,:,31), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,36), A(:,32), n3(:,734), t3x64(:,:,32), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,39), A(:,33), n3(:,735), t3x64(:,:,33), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,40), A(:,34), n3(:,736), t3x64(:,:,34), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,42), A(:,35), n3(:,737), t3x64(:,:,35), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,42), A(:,36), n3(:,738), t3x64(:,:,36), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,45), A(:,37), n3(:,739), t3x64(:,:,37), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,47), A(:,38), n3(:,740), t3x64(:,:,38), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,48), A(:,39), n3(:,741), t3x64(:,:,39), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,48), A(:,40), n3(:,742), t3x64(:,:,40), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,50), A(:,41), n3(:,743), t3x64(:,:,41), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,50), A(:,42), n3(:,744), t3x64(:,:,42), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,52), A(:,43), n3(:,745), t3x64(:,:,43), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,52), A(:,44), n3(:,746), t3x64(:,:,44), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,54), A(:,45), n3(:,747), t3x64(:,:,45), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,54), A(:,46), n3(:,748), t3x64(:,:,46), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,56), A(:,47), n3(:,749), t3x64(:,:,47), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,56), A(:,48), n3(:,750), t3x64(:,:,48), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,59), A(:,49), n3(:,751), t3x64(:,:,49), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,60), A(:,50), n3(:,752), t3x64(:,:,50), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,62), A(:,51), n3(:,753), t3x64(:,:,51), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,62), A(:,52), n3(:,754), t3x64(:,:,52), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,63), A(:,53), n3(:,755), t3x64(:,:,53), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,63), A(:,54), n3(:,756), t3x64(:,:,54), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,64), A(:,55), n3(:,757), t3x64(:,:,55), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,64), A(:,56), n3(:,758), t3x64(:,:,56), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,50), A(:,57), n3(:,759), t3x64(:,:,57), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,50), A(:,58), n3(:,760), t3x64(:,:,58), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,52), A(:,59), n3(:,761), t3x64(:,:,59), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,52), A(:,60), n3(:,762), t3x64(:,:,60), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,66), A(:,61), n3(:,763), t3x64(:,:,61), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,66), A(:,62), n3(:,764), t3x64(:,:,62), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,68), A(:,63), n3(:,765), t3x64(:,:,63), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,68), A(:,64), n3(:,766), t3x64(:,:,64), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,71), A(:,65), n3(:,767), t3x64(:,:,65), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,72), A(:,66), n3(:,768), t3x64(:,:,66), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,74), A(:,67), n3(:,769), t3x64(:,:,67), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,74), A(:,68), n3(:,770), t3x64(:,:,68), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,76), A(:,69), n3(:,771), t3x64(:,:,69), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,78), A(:,70), n3(:,772), t3x64(:,:,70), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,76), A(:,71), n3(:,773), t3x64(:,:,71), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,78), A(:,72), n3(:,774), t3x64(:,:,72), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,80), A(:,73), n3(:,775), t3x64(:,:,73), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,80), A(:,74), n3(:,776), t3x64(:,:,74), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,82), A(:,75), n3(:,777), t3x64(:,:,75), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,82), A(:,76), n3(:,778), t3x64(:,:,76), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,84), A(:,77), n3(:,779), t3x64(:,:,77), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,84), A(:,78), n3(:,780), t3x64(:,:,78), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,86), A(:,79), n3(:,781), t3x64(:,:,79), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,86), A(:,80), n3(:,782), t3x64(:,:,80), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,89), A(:,81), n3(:,783), t3x64(:,:,81), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,90), A(:,82), n3(:,784), t3x64(:,:,82), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,92), A(:,83), n3(:,785), t3x64(:,:,83), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,92), A(:,84), n3(:,786), t3x64(:,:,84), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,76), A(:,85), n3(:,787), t3x64(:,:,85), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,78), A(:,86), n3(:,788), t3x64(:,:,86), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,76), A(:,87), n3(:,789), t3x64(:,:,87), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,78), A(:,88), n3(:,790), t3x64(:,:,88), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,94), A(:,89), n3(:,791), t3x64(:,:,89), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,94), A(:,90), n3(:,792), t3x64(:,:,90), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,96), A(:,91), n3(:,793), t3x64(:,:,91), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,96), A(:,92), n3(:,794), t3x64(:,:,92), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,84), A(:,93), n3(:,795), t3x64(:,:,93), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,84), A(:,94), n3(:,796), t3x64(:,:,94), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,86), A(:,95), n3(:,797), t3x64(:,:,95), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,86), A(:,96), n3(:,798), t3x64(:,:,96), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,97), A(:,97), n3(:,799), t3x64(:,:,97), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,98), A(:,98), n3(:,800), t3x64(:,:,98), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,97), A(:,99), n3(:,801), t3x64(:,:,99), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,98), A(:,100), n3(:,802), t3x64(:,:,100), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,99), A(:,101), n3(:,803), t3x64(:,:,101), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,99), A(:,102), n3(:,804), t3x64(:,:,102), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,100), A(:,103), n3(:,805), t3x64(:,:,103), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,100), A(:,104), n3(:,806), t3x64(:,:,104), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,101), A(:,105), n3(:,807), t3x64(:,:,105), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,102), A(:,106), n3(:,808), t3x64(:,:,106), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,101), A(:,107), n3(:,809), t3x64(:,:,107), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,102), A(:,108), n3(:,810), t3x64(:,:,108), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,99), A(:,109), n3(:,811), t3x64(:,:,109), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,99), A(:,110), n3(:,812), t3x64(:,:,110), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,100), A(:,111), n3(:,813), t3x64(:,:,111), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,100), A(:,112), n3(:,814), t3x64(:,:,112), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,103), A(:,113), n3(:,815), t3x64(:,:,113), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,104), A(:,114), n3(:,816), t3x64(:,:,114), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,103), A(:,115), n3(:,817), t3x64(:,:,115), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,104), A(:,116), n3(:,818), t3x64(:,:,116), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,105), A(:,117), n3(:,819), t3x64(:,:,117), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,105), A(:,118), n3(:,820), t3x64(:,:,118), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,106), A(:,119), n3(:,821), t3x64(:,:,119), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,106), A(:,120), n3(:,822), t3x64(:,:,120), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,101), A(:,121), n3(:,823), t3x64(:,:,121), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,102), A(:,122), n3(:,824), t3x64(:,:,122), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,101), A(:,123), n3(:,825), t3x64(:,:,123), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,102), A(:,124), n3(:,826), t3x64(:,:,124), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,103), A(:,125), n3(:,827), t3x64(:,:,125), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,104), A(:,126), n3(:,828), t3x64(:,:,126), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,103), A(:,127), n3(:,829), t3x64(:,:,127), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,104), A(:,128), n3(:,830), t3x64(:,:,128), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,107), A(:,129), n3(:,831), t3x64(:,:,129), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,108), A(:,130), n3(:,832), t3x64(:,:,130), nhel, den(193))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,107), A(:,131), n3(:,833), t3x64(:,:,131), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,108), A(:,132), n3(:,834), t3x64(:,:,132), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,105), A(:,133), n3(:,835), t3x64(:,:,133), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,105), A(:,134), n3(:,836), t3x64(:,:,134), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,106), A(:,135), n3(:,837), t3x64(:,:,135), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,106), A(:,136), n3(:,838), t3x64(:,:,136), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,107), A(:,137), n3(:,839), t3x64(:,:,137), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,108), A(:,138), n3(:,840), t3x64(:,:,138), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,107), A(:,139), n3(:,841), t3x64(:,:,139), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,108), A(:,140), n3(:,842), t3x64(:,:,140), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,97), A(:,141), n3(:,843), t3x64(:,:,141), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,98), A(:,142), n3(:,844), t3x64(:,:,142), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,97), A(:,143), n3(:,845), t3x64(:,:,143), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,98), A(:,144), n3(:,846), t3x64(:,:,144), nhel, den(207))

    call Hcont_QA(nsync, wf8(:,3), wf8(:,109), A(:,145), n3(:,847), t3x64(:,:,145), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,110), A(:,146), n3(:,848), t3x64(:,:,146), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,109), A(:,147), n3(:,849), t3x64(:,:,147), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,110), A(:,148), n3(:,850), t3x64(:,:,148), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,111), A(:,149), n3(:,851), t3x64(:,:,149), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,111), A(:,150), n3(:,852), t3x64(:,:,150), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,112), A(:,151), n3(:,853), t3x64(:,:,151), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,112), A(:,152), n3(:,854), t3x64(:,:,152), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,113), A(:,153), n3(:,855), t3x64(:,:,153), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,114), A(:,154), n3(:,856), t3x64(:,:,154), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,113), A(:,155), n3(:,857), t3x64(:,:,155), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,114), A(:,156), n3(:,858), t3x64(:,:,156), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,111), A(:,157), n3(:,859), t3x64(:,:,157), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,111), A(:,158), n3(:,860), t3x64(:,:,158), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,112), A(:,159), n3(:,861), t3x64(:,:,159), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,112), A(:,160), n3(:,862), t3x64(:,:,160), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,115), A(:,161), n3(:,863), t3x64(:,:,161), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,116), A(:,162), n3(:,864), t3x64(:,:,162), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,115), A(:,163), n3(:,865), t3x64(:,:,163), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,116), A(:,164), n3(:,866), t3x64(:,:,164), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,117), A(:,165), n3(:,867), t3x64(:,:,165), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,117), A(:,166), n3(:,868), t3x64(:,:,166), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,118), A(:,167), n3(:,869), t3x64(:,:,167), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,118), A(:,168), n3(:,870), t3x64(:,:,168), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,119), A(:,169), n3(:,871), t3x64(:,:,169), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,120), A(:,170), n3(:,872), t3x64(:,:,170), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,119), A(:,171), n3(:,873), t3x64(:,:,171), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,120), A(:,172), n3(:,874), t3x64(:,:,172), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,117), A(:,173), n3(:,875), t3x64(:,:,173), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,117), A(:,174), n3(:,876), t3x64(:,:,174), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,118), A(:,175), n3(:,877), t3x64(:,:,175), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,118), A(:,176), n3(:,878), t3x64(:,:,176), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,121), A(:,177), n3(:,879), t3x64(:,:,177), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,122), A(:,178), n3(:,880), t3x64(:,:,178), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,121), A(:,179), n3(:,881), t3x64(:,:,179), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,122), A(:,180), n3(:,882), t3x64(:,:,180), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,123), A(:,181), n3(:,883), t3x64(:,:,181), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,123), A(:,182), n3(:,884), t3x64(:,:,182), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,124), A(:,183), n3(:,885), t3x64(:,:,183), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,124), A(:,184), n3(:,886), t3x64(:,:,184), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,113), A(:,185), n3(:,887), t3x64(:,:,185), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,114), A(:,186), n3(:,888), t3x64(:,:,186), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,113), A(:,187), n3(:,889), t3x64(:,:,187), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,114), A(:,188), n3(:,890), t3x64(:,:,188), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,121), A(:,189), n3(:,891), t3x64(:,:,189), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,122), A(:,190), n3(:,892), t3x64(:,:,190), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,121), A(:,191), n3(:,893), t3x64(:,:,191), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,122), A(:,192), n3(:,894), t3x64(:,:,192), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,125), A(:,193), n3(:,895), t3x64(:,:,193), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,126), A(:,194), n3(:,896), t3x64(:,:,194), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,125), A(:,195), n3(:,897), t3x64(:,:,195), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,126), A(:,196), n3(:,898), t3x64(:,:,196), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,127), A(:,197), n3(:,899), t3x64(:,:,197), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,127), A(:,198), n3(:,900), t3x64(:,:,198), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,128), A(:,199), n3(:,901), t3x64(:,:,199), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,128), A(:,200), n3(:,902), t3x64(:,:,200), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,119), A(:,201), n3(:,903), t3x64(:,:,201), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,120), A(:,202), n3(:,904), t3x64(:,:,202), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,119), A(:,203), n3(:,905), t3x64(:,:,203), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,120), A(:,204), n3(:,906), t3x64(:,:,204), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,125), A(:,205), n3(:,907), t3x64(:,:,205), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,126), A(:,206), n3(:,908), t3x64(:,:,206), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,125), A(:,207), n3(:,909), t3x64(:,:,207), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,126), A(:,208), n3(:,910), t3x64(:,:,208), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,129), A(:,209), n3(:,911), t3x64(:,:,209), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,130), A(:,210), n3(:,912), t3x64(:,:,210), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,129), A(:,211), n3(:,913), t3x64(:,:,211), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,130), A(:,212), n3(:,914), t3x64(:,:,212), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,123), A(:,213), n3(:,915), t3x64(:,:,213), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,123), A(:,214), n3(:,916), t3x64(:,:,214), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,124), A(:,215), n3(:,917), t3x64(:,:,215), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,124), A(:,216), n3(:,918), t3x64(:,:,216), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,129), A(:,217), n3(:,919), t3x64(:,:,217), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,130), A(:,218), n3(:,920), t3x64(:,:,218), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,129), A(:,219), n3(:,921), t3x64(:,:,219), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,130), A(:,220), n3(:,922), t3x64(:,:,220), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,109), A(:,221), n3(:,923), t3x64(:,:,221), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,110), A(:,222), n3(:,924), t3x64(:,:,222), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,109), A(:,223), n3(:,925), t3x64(:,:,223), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,110), A(:,224), n3(:,926), t3x64(:,:,224), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,131), A(:,225), n3(:,927), t3x64(:,:,225), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,132), A(:,226), n3(:,928), t3x64(:,:,226), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,131), A(:,227), n3(:,929), t3x64(:,:,227), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,132), A(:,228), n3(:,930), t3x64(:,:,228), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,127), A(:,229), n3(:,931), t3x64(:,:,229), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,127), A(:,230), n3(:,932), t3x64(:,:,230), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,128), A(:,231), n3(:,933), t3x64(:,:,231), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,128), A(:,232), n3(:,934), t3x64(:,:,232), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,131), A(:,233), n3(:,935), t3x64(:,:,233), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,132), A(:,234), n3(:,936), t3x64(:,:,234), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,131), A(:,235), n3(:,937), t3x64(:,:,235), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,132), A(:,236), n3(:,938), t3x64(:,:,236), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,115), A(:,237), n3(:,939), t3x64(:,:,237), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,116), A(:,238), n3(:,940), t3x64(:,:,238), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,115), A(:,239), n3(:,941), t3x64(:,:,239), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,116), A(:,240), n3(:,942), t3x64(:,:,240), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,133), A(:,241), n3(:,943), t3x64(:,:,241), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,134), A(:,242), n3(:,944), t3x64(:,:,242), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,133), A(:,243), n3(:,945), t3x64(:,:,243), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,134), A(:,244), n3(:,946), t3x64(:,:,244), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,135), A(:,245), n3(:,947), t3x64(:,:,245), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,135), A(:,246), n3(:,948), t3x64(:,:,246), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,136), A(:,247), n3(:,949), t3x64(:,:,247), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,136), A(:,248), n3(:,950), t3x64(:,:,248), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,137), A(:,249), n3(:,951), t3x64(:,:,249), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,138), A(:,250), n3(:,952), t3x64(:,:,250), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,137), A(:,251), n3(:,953), t3x64(:,:,251), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,138), A(:,252), n3(:,954), t3x64(:,:,252), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,135), A(:,253), n3(:,955), t3x64(:,:,253), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,135), A(:,254), n3(:,956), t3x64(:,:,254), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,136), A(:,255), n3(:,957), t3x64(:,:,255), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,136), A(:,256), n3(:,958), t3x64(:,:,256), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,139), A(:,257), n3(:,959), t3x64(:,:,257), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,140), A(:,258), n3(:,960), t3x64(:,:,258), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,139), A(:,259), n3(:,961), t3x64(:,:,259), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,140), A(:,260), n3(:,962), t3x64(:,:,260), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,141), A(:,261), n3(:,963), t3x64(:,:,261), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,141), A(:,262), n3(:,964), t3x64(:,:,262), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,142), A(:,263), n3(:,965), t3x64(:,:,263), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,142), A(:,264), n3(:,966), t3x64(:,:,264), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,137), A(:,265), n3(:,967), t3x64(:,:,265), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,138), A(:,266), n3(:,968), t3x64(:,:,266), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,137), A(:,267), n3(:,969), t3x64(:,:,267), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,138), A(:,268), n3(:,970), t3x64(:,:,268), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,139), A(:,269), n3(:,971), t3x64(:,:,269), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,140), A(:,270), n3(:,972), t3x64(:,:,270), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,139), A(:,271), n3(:,973), t3x64(:,:,271), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,140), A(:,272), n3(:,974), t3x64(:,:,272), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,143), A(:,273), n3(:,975), t3x64(:,:,273), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,144), A(:,274), n3(:,976), t3x64(:,:,274), nhel, den(193))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,143), A(:,275), n3(:,977), t3x64(:,:,275), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,144), A(:,276), n3(:,978), t3x64(:,:,276), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,141), A(:,277), n3(:,979), t3x64(:,:,277), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,141), A(:,278), n3(:,980), t3x64(:,:,278), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,142), A(:,279), n3(:,981), t3x64(:,:,279), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,142), A(:,280), n3(:,982), t3x64(:,:,280), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,143), A(:,281), n3(:,983), t3x64(:,:,281), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,144), A(:,282), n3(:,984), t3x64(:,:,282), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,143), A(:,283), n3(:,985), t3x64(:,:,283), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,144), A(:,284), n3(:,986), t3x64(:,:,284), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,133), A(:,285), n3(:,987), t3x64(:,:,285), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,134), A(:,286), n3(:,988), t3x64(:,:,286), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,133), A(:,287), n3(:,989), t3x64(:,:,287), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,134), A(:,288), n3(:,990), t3x64(:,:,288), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,145), wf8(:,146), A(:,289), n3(:,991), t3x64(:,:,289), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,147), A(:,290), n3(:,992), t3x64(:,:,290), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,145), wf8(:,148), A(:,291), n3(:,993), t3x64(:,:,291), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,147), wf8(:,148), A(:,292), n3(:,994), t3x64(:,:,292), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,150), A(:,293), n3(:,995), t3x64(:,:,293), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,151), A(:,294), n3(:,996), t3x64(:,:,294), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,152), A(:,295), n3(:,997), t3x64(:,:,295), nhel, den(220))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,152), A(:,296), n3(:,998), t3x64(:,:,296), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,153), wf8(:,154), A(:,297), n3(:,999), t3x64(:,:,297), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,155), A(:,298), n3(:,1000), t3x64(:,:,298), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,153), wf8(:,156), A(:,299), n3(:,1001), t3x64(:,:,299), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,155), wf8(:,156), A(:,300), n3(:,1002), t3x64(:,:,300), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,157), A(:,301), n3(:,1003), t3x64(:,:,301), nhel, den(230))
    call Hcont_QA(nsync, wf8(:,149), wf8(:,158), A(:,302), n3(:,1004), t3x64(:,:,302), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,152), wf8(:,157), A(:,303), n3(:,1005), t3x64(:,:,303), nhel, den(233))
    call Hcont_QA(nsync, wf8(:,152), wf8(:,158), A(:,304), n3(:,1006), t3x64(:,:,304), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,159), A(:,305), n3(:,1007), t3x64(:,:,305), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,160), A(:,306), n3(:,1008), t3x64(:,:,306), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,159), A(:,307), n3(:,1009), t3x64(:,:,307), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,160), A(:,308), n3(:,1010), t3x64(:,:,308), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,162), A(:,309), n3(:,1011), t3x64(:,:,309), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,164), A(:,310), n3(:,1012), t3x64(:,:,310), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,162), A(:,311), n3(:,1013), t3x64(:,:,311), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,164), A(:,312), n3(:,1014), t3x64(:,:,312), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,165), A(:,313), n3(:,1015), t3x64(:,:,313), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,166), A(:,314), n3(:,1016), t3x64(:,:,314), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,165), A(:,315), n3(:,1017), t3x64(:,:,315), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,166), A(:,316), n3(:,1018), t3x64(:,:,316), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,168), A(:,317), n3(:,1019), t3x64(:,:,317), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,170), A(:,318), n3(:,1020), t3x64(:,:,318), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,168), A(:,319), n3(:,1021), t3x64(:,:,319), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,170), A(:,320), n3(:,1022), t3x64(:,:,320), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,171), wf8(:,172), A(:,321), n3(:,1023), t3x64(:,:,321), nhel, den(237))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,173), A(:,322), n3(:,1024), t3x64(:,:,322), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,171), wf8(:,174), A(:,323), n3(:,1025), t3x64(:,:,323), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,173), wf8(:,174), A(:,324), n3(:,1026), t3x64(:,:,324), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,175), wf8(:,176), A(:,325), n3(:,1027), t3x64(:,:,325), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,175), wf8(:,177), A(:,326), n3(:,1028), t3x64(:,:,326), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,178), A(:,327), n3(:,1029), t3x64(:,:,327), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,178), A(:,328), n3(:,1030), t3x64(:,:,328), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,171), wf8(:,179), A(:,329), n3(:,1031), t3x64(:,:,329), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,173), wf8(:,179), A(:,330), n3(:,1032), t3x64(:,:,330), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,171), wf8(:,180), A(:,331), n3(:,1033), t3x64(:,:,331), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,173), wf8(:,180), A(:,332), n3(:,1034), t3x64(:,:,332), nhel, den(254))
    call Hcont_QA(nsync, wf8(:,181), wf8(:,182), A(:,333), n3(:,1035), t3x64(:,:,333), nhel, den(257))
    call Hcont_QA(nsync, wf8(:,181), wf8(:,183), A(:,334), n3(:,1036), t3x64(:,:,334), nhel, den(259))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,184), A(:,335), n3(:,1037), t3x64(:,:,335), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,184), A(:,336), n3(:,1038), t3x64(:,:,336), nhel, den(261))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,159), A(:,337), n3(:,1039), t3x64(:,:,337), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,160), A(:,338), n3(:,1040), t3x64(:,:,338), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,159), A(:,339), n3(:,1041), t3x64(:,:,339), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,160), A(:,340), n3(:,1042), t3x64(:,:,340), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,186), A(:,341), n3(:,1043), t3x64(:,:,341), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,186), A(:,342), n3(:,1044), t3x64(:,:,342), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,188), A(:,343), n3(:,1045), t3x64(:,:,343), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,188), A(:,344), n3(:,1046), t3x64(:,:,344), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,165), A(:,345), n3(:,1047), t3x64(:,:,345), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,166), A(:,346), n3(:,1048), t3x64(:,:,346), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,165), A(:,347), n3(:,1049), t3x64(:,:,347), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,166), A(:,348), n3(:,1050), t3x64(:,:,348), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,190), A(:,349), n3(:,1051), t3x64(:,:,349), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,190), A(:,350), n3(:,1052), t3x64(:,:,350), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,192), A(:,351), n3(:,1053), t3x64(:,:,351), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,192), A(:,352), n3(:,1054), t3x64(:,:,352), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,153), wf8(:,193), A(:,353), n3(:,1055), t3x64(:,:,353), nhel, den(263))
    call Hcont_QA(nsync, wf8(:,155), wf8(:,193), A(:,354), n3(:,1056), t3x64(:,:,354), nhel, den(264))
    call Hcont_QA(nsync, wf8(:,153), wf8(:,194), A(:,355), n3(:,1057), t3x64(:,:,355), nhel, den(266))
    call Hcont_QA(nsync, wf8(:,155), wf8(:,194), A(:,356), n3(:,1058), t3x64(:,:,356), nhel, den(267))
    call Hcont_QA(nsync, wf8(:,175), wf8(:,195), A(:,357), n3(:,1059), t3x64(:,:,357), nhel, den(269))
    call Hcont_QA(nsync, wf8(:,175), wf8(:,196), A(:,358), n3(:,1060), t3x64(:,:,358), nhel, den(271))
    call Hcont_QA(nsync, wf8(:,178), wf8(:,195), A(:,359), n3(:,1061), t3x64(:,:,359), nhel, den(272))
    call Hcont_QA(nsync, wf8(:,178), wf8(:,196), A(:,360), n3(:,1062), t3x64(:,:,360), nhel, den(273))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,197), A(:,361), n3(:,1063), t3x64(:,:,361), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,198), A(:,362), n3(:,1064), t3x64(:,:,362), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,197), A(:,363), n3(:,1065), t3x64(:,:,363), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,198), A(:,364), n3(:,1066), t3x64(:,:,364), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,99), wf8(:,162), A(:,365), n3(:,1067), t3x64(:,:,365), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,99), wf8(:,164), A(:,366), n3(:,1068), t3x64(:,:,366), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,100), wf8(:,162), A(:,367), n3(:,1069), t3x64(:,:,367), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,100), wf8(:,164), A(:,368), n3(:,1070), t3x64(:,:,368), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,145), wf8(:,199), A(:,369), n3(:,1071), t3x64(:,:,369), nhel, den(275))
    call Hcont_QA(nsync, wf8(:,147), wf8(:,199), A(:,370), n3(:,1072), t3x64(:,:,370), nhel, den(276))
    call Hcont_QA(nsync, wf8(:,145), wf8(:,200), A(:,371), n3(:,1073), t3x64(:,:,371), nhel, den(278))
    call Hcont_QA(nsync, wf8(:,147), wf8(:,200), A(:,372), n3(:,1074), t3x64(:,:,372), nhel, den(279))
    call Hcont_QA(nsync, wf8(:,181), wf8(:,201), A(:,373), n3(:,1075), t3x64(:,:,373), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,181), wf8(:,202), A(:,374), n3(:,1076), t3x64(:,:,374), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,184), wf8(:,201), A(:,375), n3(:,1077), t3x64(:,:,375), nhel, den(284))
    call Hcont_QA(nsync, wf8(:,184), wf8(:,202), A(:,376), n3(:,1078), t3x64(:,:,376), nhel, den(285))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,197), A(:,377), n3(:,1079), t3x64(:,:,377), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,198), A(:,378), n3(:,1080), t3x64(:,:,378), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,197), A(:,379), n3(:,1081), t3x64(:,:,379), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,198), A(:,380), n3(:,1082), t3x64(:,:,380), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,186), A(:,381), n3(:,1083), t3x64(:,:,381), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,104), wf8(:,186), A(:,382), n3(:,1084), t3x64(:,:,382), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,188), A(:,383), n3(:,1085), t3x64(:,:,383), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,104), wf8(:,188), A(:,384), n3(:,1086), t3x64(:,:,384), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,203), A(:,385), n3(:,1087), t3x64(:,:,385), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,204), A(:,386), n3(:,1088), t3x64(:,:,386), nhel, den(193))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,203), A(:,387), n3(:,1089), t3x64(:,:,387), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,204), A(:,388), n3(:,1090), t3x64(:,:,388), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,105), wf8(:,168), A(:,389), n3(:,1091), t3x64(:,:,389), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,105), wf8(:,170), A(:,390), n3(:,1092), t3x64(:,:,390), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,106), wf8(:,168), A(:,391), n3(:,1093), t3x64(:,:,391), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,106), wf8(:,170), A(:,392), n3(:,1094), t3x64(:,:,392), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,203), A(:,393), n3(:,1095), t3x64(:,:,393), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,204), A(:,394), n3(:,1096), t3x64(:,:,394), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,203), A(:,395), n3(:,1097), t3x64(:,:,395), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,204), A(:,396), n3(:,1098), t3x64(:,:,396), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,97), wf8(:,190), A(:,397), n3(:,1099), t3x64(:,:,397), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,98), wf8(:,190), A(:,398), n3(:,1100), t3x64(:,:,398), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,97), wf8(:,192), A(:,399), n3(:,1101), t3x64(:,:,399), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,98), wf8(:,192), A(:,400), n3(:,1102), t3x64(:,:,400), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,205), A(:,401), n3(:,1103), t3x64(:,:,401), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,206), A(:,402), n3(:,1104), t3x64(:,:,402), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,205), A(:,403), n3(:,1105), t3x64(:,:,403), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,206), A(:,404), n3(:,1106), t3x64(:,:,404), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,208), A(:,405), n3(:,1107), t3x64(:,:,405), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,210), A(:,406), n3(:,1108), t3x64(:,:,406), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,208), A(:,407), n3(:,1109), t3x64(:,:,407), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,210), A(:,408), n3(:,1110), t3x64(:,:,408), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,205), A(:,409), n3(:,1111), t3x64(:,:,409), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,206), A(:,410), n3(:,1112), t3x64(:,:,410), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,205), A(:,411), n3(:,1113), t3x64(:,:,411), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,206), A(:,412), n3(:,1114), t3x64(:,:,412), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,212), A(:,413), n3(:,1115), t3x64(:,:,413), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,212), A(:,414), n3(:,1116), t3x64(:,:,414), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,214), A(:,415), n3(:,1117), t3x64(:,:,415), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,214), A(:,416), n3(:,1118), t3x64(:,:,416), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,215), A(:,417), n3(:,1119), t3x64(:,:,417), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,216), A(:,418), n3(:,1120), t3x64(:,:,418), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,215), A(:,419), n3(:,1121), t3x64(:,:,419), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,216), A(:,420), n3(:,1122), t3x64(:,:,420), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,208), A(:,421), n3(:,1123), t3x64(:,:,421), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,210), A(:,422), n3(:,1124), t3x64(:,:,422), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,208), A(:,423), n3(:,1125), t3x64(:,:,423), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,210), A(:,424), n3(:,1126), t3x64(:,:,424), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,215), A(:,425), n3(:,1127), t3x64(:,:,425), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,216), A(:,426), n3(:,1128), t3x64(:,:,426), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,215), A(:,427), n3(:,1129), t3x64(:,:,427), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,216), A(:,428), n3(:,1130), t3x64(:,:,428), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,212), A(:,429), n3(:,1131), t3x64(:,:,429), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,212), A(:,430), n3(:,1132), t3x64(:,:,430), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,214), A(:,431), n3(:,1133), t3x64(:,:,431), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,214), A(:,432), n3(:,1134), t3x64(:,:,432), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,217), A(:,433), n3(:,1135), t3x64(:,:,433), nhel, den(286))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,218), A(:,434), n3(:,1136), t3x64(:,:,434), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,217), A(:,435), n3(:,1137), t3x64(:,:,435), nhel, den(288))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,218), A(:,436), n3(:,1138), t3x64(:,:,436), nhel, den(289))
    call Hcont_QA(nsync, wf8(:,219), wf8(:,220), A(:,437), n3(:,1139), t3x64(:,:,437), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,219), wf8(:,221), A(:,438), n3(:,1140), t3x64(:,:,438), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,222), A(:,439), n3(:,1141), t3x64(:,:,439), nhel, den(295))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,222), A(:,440), n3(:,1142), t3x64(:,:,440), nhel, den(296))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,223), A(:,441), n3(:,1143), t3x64(:,:,441), nhel, den(297))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,224), A(:,442), n3(:,1144), t3x64(:,:,442), nhel, den(298))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,223), A(:,443), n3(:,1145), t3x64(:,:,443), nhel, den(299))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,224), A(:,444), n3(:,1146), t3x64(:,:,444), nhel, den(300))
    call Hcont_QA(nsync, wf8(:,219), wf8(:,225), A(:,445), n3(:,1147), t3x64(:,:,445), nhel, den(302))
    call Hcont_QA(nsync, wf8(:,219), wf8(:,226), A(:,446), n3(:,1148), t3x64(:,:,446), nhel, den(304))
    call Hcont_QA(nsync, wf8(:,222), wf8(:,225), A(:,447), n3(:,1149), t3x64(:,:,447), nhel, den(305))
    call Hcont_QA(nsync, wf8(:,222), wf8(:,226), A(:,448), n3(:,1150), t3x64(:,:,448), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,227), A(:,449), n3(:,1151), t3x64(:,:,449), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,228), A(:,450), n3(:,1152), t3x64(:,:,450), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,227), A(:,451), n3(:,1153), t3x64(:,:,451), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,228), A(:,452), n3(:,1154), t3x64(:,:,452), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,230), A(:,453), n3(:,1155), t3x64(:,:,453), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,232), A(:,454), n3(:,1156), t3x64(:,:,454), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,230), A(:,455), n3(:,1157), t3x64(:,:,455), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,232), A(:,456), n3(:,1158), t3x64(:,:,456), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,233), A(:,457), n3(:,1159), t3x64(:,:,457), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,234), A(:,458), n3(:,1160), t3x64(:,:,458), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,233), A(:,459), n3(:,1161), t3x64(:,:,459), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,234), A(:,460), n3(:,1162), t3x64(:,:,460), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,236), A(:,461), n3(:,1163), t3x64(:,:,461), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,238), A(:,462), n3(:,1164), t3x64(:,:,462), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,236), A(:,463), n3(:,1165), t3x64(:,:,463), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,238), A(:,464), n3(:,1166), t3x64(:,:,464), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,239), A(:,465), n3(:,1167), t3x64(:,:,465), nhel, den(307))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,240), A(:,466), n3(:,1168), t3x64(:,:,466), nhel, den(308))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,239), A(:,467), n3(:,1169), t3x64(:,:,467), nhel, den(309))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,240), A(:,468), n3(:,1170), t3x64(:,:,468), nhel, den(310))
    call Hcont_QA(nsync, wf8(:,241), wf8(:,242), A(:,469), n3(:,1171), t3x64(:,:,469), nhel, den(313))
    call Hcont_QA(nsync, wf8(:,241), wf8(:,243), A(:,470), n3(:,1172), t3x64(:,:,470), nhel, den(315))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,244), A(:,471), n3(:,1173), t3x64(:,:,471), nhel, den(316))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,244), A(:,472), n3(:,1174), t3x64(:,:,472), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,239), A(:,473), n3(:,1175), t3x64(:,:,473), nhel, den(318))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,240), A(:,474), n3(:,1176), t3x64(:,:,474), nhel, den(319))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,239), A(:,475), n3(:,1177), t3x64(:,:,475), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,240), A(:,476), n3(:,1178), t3x64(:,:,476), nhel, den(321))
    call Hcont_QA(nsync, wf8(:,245), wf8(:,246), A(:,477), n3(:,1179), t3x64(:,:,477), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,245), wf8(:,247), A(:,478), n3(:,1180), t3x64(:,:,478), nhel, den(326))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,248), A(:,479), n3(:,1181), t3x64(:,:,479), nhel, den(327))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,248), A(:,480), n3(:,1182), t3x64(:,:,480), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,227), A(:,481), n3(:,1183), t3x64(:,:,481), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,228), A(:,482), n3(:,1184), t3x64(:,:,482), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,227), A(:,483), n3(:,1185), t3x64(:,:,483), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,228), A(:,484), n3(:,1186), t3x64(:,:,484), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,250), A(:,485), n3(:,1187), t3x64(:,:,485), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,250), A(:,486), n3(:,1188), t3x64(:,:,486), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,252), A(:,487), n3(:,1189), t3x64(:,:,487), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,252), A(:,488), n3(:,1190), t3x64(:,:,488), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,233), A(:,489), n3(:,1191), t3x64(:,:,489), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,234), A(:,490), n3(:,1192), t3x64(:,:,490), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,233), A(:,491), n3(:,1193), t3x64(:,:,491), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,234), A(:,492), n3(:,1194), t3x64(:,:,492), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,254), A(:,493), n3(:,1195), t3x64(:,:,493), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,254), A(:,494), n3(:,1196), t3x64(:,:,494), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,256), A(:,495), n3(:,1197), t3x64(:,:,495), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,256), A(:,496), n3(:,1198), t3x64(:,:,496), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,223), A(:,497), n3(:,1199), t3x64(:,:,497), nhel, den(329))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,224), A(:,498), n3(:,1200), t3x64(:,:,498), nhel, den(330))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,223), A(:,499), n3(:,1201), t3x64(:,:,499), nhel, den(331))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,224), A(:,500), n3(:,1202), t3x64(:,:,500), nhel, den(332))
    call Hcont_QA(nsync, wf8(:,241), wf8(:,257), A(:,501), n3(:,1203), t3x64(:,:,501), nhel, den(334))
    call Hcont_QA(nsync, wf8(:,241), wf8(:,258), A(:,502), n3(:,1204), t3x64(:,:,502), nhel, den(336))
    call Hcont_QA(nsync, wf8(:,244), wf8(:,257), A(:,503), n3(:,1205), t3x64(:,:,503), nhel, den(337))
    call Hcont_QA(nsync, wf8(:,244), wf8(:,258), A(:,504), n3(:,1206), t3x64(:,:,504), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,259), A(:,505), n3(:,1207), t3x64(:,:,505), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,260), A(:,506), n3(:,1208), t3x64(:,:,506), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,259), A(:,507), n3(:,1209), t3x64(:,:,507), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,260), A(:,508), n3(:,1210), t3x64(:,:,508), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,99), wf8(:,230), A(:,509), n3(:,1211), t3x64(:,:,509), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,99), wf8(:,232), A(:,510), n3(:,1212), t3x64(:,:,510), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,100), wf8(:,230), A(:,511), n3(:,1213), t3x64(:,:,511), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,100), wf8(:,232), A(:,512), n3(:,1214), t3x64(:,:,512), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,217), A(:,513), n3(:,1215), t3x64(:,:,513), nhel, den(339))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,218), A(:,514), n3(:,1216), t3x64(:,:,514), nhel, den(340))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,217), A(:,515), n3(:,1217), t3x64(:,:,515), nhel, den(341))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,218), A(:,516), n3(:,1218), t3x64(:,:,516), nhel, den(342))
    call Hcont_QA(nsync, wf8(:,245), wf8(:,261), A(:,517), n3(:,1219), t3x64(:,:,517), nhel, den(344))
    call Hcont_QA(nsync, wf8(:,245), wf8(:,262), A(:,518), n3(:,1220), t3x64(:,:,518), nhel, den(346))
    call Hcont_QA(nsync, wf8(:,248), wf8(:,261), A(:,519), n3(:,1221), t3x64(:,:,519), nhel, den(347))
    call Hcont_QA(nsync, wf8(:,248), wf8(:,262), A(:,520), n3(:,1222), t3x64(:,:,520), nhel, den(348))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,259), A(:,521), n3(:,1223), t3x64(:,:,521), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,260), A(:,522), n3(:,1224), t3x64(:,:,522), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,259), A(:,523), n3(:,1225), t3x64(:,:,523), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,260), A(:,524), n3(:,1226), t3x64(:,:,524), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,107), wf8(:,250), A(:,525), n3(:,1227), t3x64(:,:,525), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,108), wf8(:,250), A(:,526), n3(:,1228), t3x64(:,:,526), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,107), wf8(:,252), A(:,527), n3(:,1229), t3x64(:,:,527), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,108), wf8(:,252), A(:,528), n3(:,1230), t3x64(:,:,528), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,263), A(:,529), n3(:,1231), t3x64(:,:,529), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,264), A(:,530), n3(:,1232), t3x64(:,:,530), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,263), A(:,531), n3(:,1233), t3x64(:,:,531), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,264), A(:,532), n3(:,1234), t3x64(:,:,532), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,105), wf8(:,236), A(:,533), n3(:,1235), t3x64(:,:,533), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,105), wf8(:,238), A(:,534), n3(:,1236), t3x64(:,:,534), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,106), wf8(:,236), A(:,535), n3(:,1237), t3x64(:,:,535), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,106), wf8(:,238), A(:,536), n3(:,1238), t3x64(:,:,536), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,263), A(:,537), n3(:,1239), t3x64(:,:,537), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,264), A(:,538), n3(:,1240), t3x64(:,:,538), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,263), A(:,539), n3(:,1241), t3x64(:,:,539), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,264), A(:,540), n3(:,1242), t3x64(:,:,540), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,254), A(:,541), n3(:,1243), t3x64(:,:,541), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,102), wf8(:,254), A(:,542), n3(:,1244), t3x64(:,:,542), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,256), A(:,543), n3(:,1245), t3x64(:,:,543), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,102), wf8(:,256), A(:,544), n3(:,1246), t3x64(:,:,544), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,265), A(:,545), n3(:,1247), t3x64(:,:,545), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,266), A(:,546), n3(:,1248), t3x64(:,:,546), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,265), A(:,547), n3(:,1249), t3x64(:,:,547), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,266), A(:,548), n3(:,1250), t3x64(:,:,548), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,268), A(:,549), n3(:,1251), t3x64(:,:,549), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,270), A(:,550), n3(:,1252), t3x64(:,:,550), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,268), A(:,551), n3(:,1253), t3x64(:,:,551), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,270), A(:,552), n3(:,1254), t3x64(:,:,552), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,265), A(:,553), n3(:,1255), t3x64(:,:,553), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,266), A(:,554), n3(:,1256), t3x64(:,:,554), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,265), A(:,555), n3(:,1257), t3x64(:,:,555), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,266), A(:,556), n3(:,1258), t3x64(:,:,556), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,272), A(:,557), n3(:,1259), t3x64(:,:,557), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,272), A(:,558), n3(:,1260), t3x64(:,:,558), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,274), A(:,559), n3(:,1261), t3x64(:,:,559), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,274), A(:,560), n3(:,1262), t3x64(:,:,560), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,275), A(:,561), n3(:,1263), t3x64(:,:,561), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,276), A(:,562), n3(:,1264), t3x64(:,:,562), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,275), A(:,563), n3(:,1265), t3x64(:,:,563), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,276), A(:,564), n3(:,1266), t3x64(:,:,564), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,268), A(:,565), n3(:,1267), t3x64(:,:,565), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,270), A(:,566), n3(:,1268), t3x64(:,:,566), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,268), A(:,567), n3(:,1269), t3x64(:,:,567), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,270), A(:,568), n3(:,1270), t3x64(:,:,568), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,275), A(:,569), n3(:,1271), t3x64(:,:,569), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,276), A(:,570), n3(:,1272), t3x64(:,:,570), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,275), A(:,571), n3(:,1273), t3x64(:,:,571), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,276), A(:,572), n3(:,1274), t3x64(:,:,572), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,272), A(:,573), n3(:,1275), t3x64(:,:,573), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,272), A(:,574), n3(:,1276), t3x64(:,:,574), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,274), A(:,575), n3(:,1277), t3x64(:,:,575), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,274), A(:,576), n3(:,1278), t3x64(:,:,576), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,277), A(:,577), n3(:,1279), t3x64(:,:,577), nhel, den(349))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,277), A(:,578), n3(:,1280), t3x64(:,:,578), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,278), A(:,579), n3(:,1281), t3x64(:,:,579), nhel, den(351))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,278), A(:,580), n3(:,1282), t3x64(:,:,580), nhel, den(352))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,279), A(:,581), n3(:,1283), t3x64(:,:,581), nhel, den(353))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,279), A(:,582), n3(:,1284), t3x64(:,:,582), nhel, den(354))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,280), A(:,583), n3(:,1285), t3x64(:,:,583), nhel, den(355))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,280), A(:,584), n3(:,1286), t3x64(:,:,584), nhel, den(356))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,277), A(:,585), n3(:,1287), t3x64(:,:,585), nhel, den(357))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,277), A(:,586), n3(:,1288), t3x64(:,:,586), nhel, den(358))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,278), A(:,587), n3(:,1289), t3x64(:,:,587), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,278), A(:,588), n3(:,1290), t3x64(:,:,588), nhel, den(360))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,281), A(:,589), n3(:,1291), t3x64(:,:,589), nhel, den(361))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,281), A(:,590), n3(:,1292), t3x64(:,:,590), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,282), A(:,591), n3(:,1293), t3x64(:,:,591), nhel, den(363))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,282), A(:,592), n3(:,1294), t3x64(:,:,592), nhel, den(364))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,284), A(:,593), n3(:,1295), t3x64(:,:,593), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,284), A(:,594), n3(:,1296), t3x64(:,:,594), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,286), A(:,595), n3(:,1297), t3x64(:,:,595), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,286), A(:,596), n3(:,1298), t3x64(:,:,596), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,287), A(:,597), n3(:,1299), t3x64(:,:,597), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,287), A(:,598), n3(:,1300), t3x64(:,:,598), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,288), A(:,599), n3(:,1301), t3x64(:,:,599), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,288), A(:,600), n3(:,1302), t3x64(:,:,600), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,290), A(:,601), n3(:,1303), t3x64(:,:,601), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,290), A(:,602), n3(:,1304), t3x64(:,:,602), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,292), A(:,603), n3(:,1305), t3x64(:,:,603), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,292), A(:,604), n3(:,1306), t3x64(:,:,604), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,293), A(:,605), n3(:,1307), t3x64(:,:,605), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,293), A(:,606), n3(:,1308), t3x64(:,:,606), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,294), A(:,607), n3(:,1309), t3x64(:,:,607), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,294), A(:,608), n3(:,1310), t3x64(:,:,608), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,295), A(:,609), n3(:,1311), t3x64(:,:,609), nhel, den(365))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,295), A(:,610), n3(:,1312), t3x64(:,:,610), nhel, den(366))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,296), A(:,611), n3(:,1313), t3x64(:,:,611), nhel, den(367))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,296), A(:,612), n3(:,1314), t3x64(:,:,612), nhel, den(368))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,297), A(:,613), n3(:,1315), t3x64(:,:,613), nhel, den(369))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,297), A(:,614), n3(:,1316), t3x64(:,:,614), nhel, den(370))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,298), A(:,615), n3(:,1317), t3x64(:,:,615), nhel, den(371))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,298), A(:,616), n3(:,1318), t3x64(:,:,616), nhel, den(372))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,299), A(:,617), n3(:,1319), t3x64(:,:,617), nhel, den(373))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,299), A(:,618), n3(:,1320), t3x64(:,:,618), nhel, den(374))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,300), A(:,619), n3(:,1321), t3x64(:,:,619), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,300), A(:,620), n3(:,1322), t3x64(:,:,620), nhel, den(376))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,297), A(:,621), n3(:,1323), t3x64(:,:,621), nhel, den(377))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,297), A(:,622), n3(:,1324), t3x64(:,:,622), nhel, den(378))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,298), A(:,623), n3(:,1325), t3x64(:,:,623), nhel, den(379))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,298), A(:,624), n3(:,1326), t3x64(:,:,624), nhel, den(380))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,302), A(:,625), n3(:,1327), t3x64(:,:,625), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,302), A(:,626), n3(:,1328), t3x64(:,:,626), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,88), wf8(:,304), A(:,627), n3(:,1329), t3x64(:,:,627), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,304), A(:,628), n3(:,1330), t3x64(:,:,628), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,287), A(:,629), n3(:,1331), t3x64(:,:,629), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,287), A(:,630), n3(:,1332), t3x64(:,:,630), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,288), A(:,631), n3(:,1333), t3x64(:,:,631), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,288), A(:,632), n3(:,1334), t3x64(:,:,632), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,306), A(:,633), n3(:,1335), t3x64(:,:,633), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,306), A(:,634), n3(:,1336), t3x64(:,:,634), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,308), A(:,635), n3(:,1337), t3x64(:,:,635), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,308), A(:,636), n3(:,1338), t3x64(:,:,636), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,293), A(:,637), n3(:,1339), t3x64(:,:,637), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,293), A(:,638), n3(:,1340), t3x64(:,:,638), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,294), A(:,639), n3(:,1341), t3x64(:,:,639), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,294), A(:,640), n3(:,1342), t3x64(:,:,640), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,295), A(:,641), n3(:,1343), t3x64(:,:,641), nhel, den(381))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,295), A(:,642), n3(:,1344), t3x64(:,:,642), nhel, den(382))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,296), A(:,643), n3(:,1345), t3x64(:,:,643), nhel, den(383))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,296), A(:,644), n3(:,1346), t3x64(:,:,644), nhel, den(384))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,281), A(:,645), n3(:,1347), t3x64(:,:,645), nhel, den(385))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,281), A(:,646), n3(:,1348), t3x64(:,:,646), nhel, den(386))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,282), A(:,647), n3(:,1349), t3x64(:,:,647), nhel, den(387))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,282), A(:,648), n3(:,1350), t3x64(:,:,648), nhel, den(388))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,284), A(:,649), n3(:,1351), t3x64(:,:,649), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,104), wf8(:,284), A(:,650), n3(:,1352), t3x64(:,:,650), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,103), wf8(:,286), A(:,651), n3(:,1353), t3x64(:,:,651), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,104), wf8(:,286), A(:,652), n3(:,1354), t3x64(:,:,652), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,309), A(:,653), n3(:,1355), t3x64(:,:,653), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,309), A(:,654), n3(:,1356), t3x64(:,:,654), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,310), A(:,655), n3(:,1357), t3x64(:,:,655), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,310), A(:,656), n3(:,1358), t3x64(:,:,656), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,299), A(:,657), n3(:,1359), t3x64(:,:,657), nhel, den(389))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,299), A(:,658), n3(:,1360), t3x64(:,:,658), nhel, den(390))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,300), A(:,659), n3(:,1361), t3x64(:,:,659), nhel, den(391))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,300), A(:,660), n3(:,1362), t3x64(:,:,660), nhel, den(392))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,279), A(:,661), n3(:,1363), t3x64(:,:,661), nhel, den(393))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,279), A(:,662), n3(:,1364), t3x64(:,:,662), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,280), A(:,663), n3(:,1365), t3x64(:,:,663), nhel, den(395))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,280), A(:,664), n3(:,1366), t3x64(:,:,664), nhel, den(396))
    call Hcont_QA(nsync, wf8(:,107), wf8(:,302), A(:,665), n3(:,1367), t3x64(:,:,665), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,108), wf8(:,302), A(:,666), n3(:,1368), t3x64(:,:,666), nhel, den(193))
    call Hcont_QA(nsync, wf8(:,107), wf8(:,304), A(:,667), n3(:,1369), t3x64(:,:,667), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,108), wf8(:,304), A(:,668), n3(:,1370), t3x64(:,:,668), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,309), A(:,669), n3(:,1371), t3x64(:,:,669), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,309), A(:,670), n3(:,1372), t3x64(:,:,670), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,310), A(:,671), n3(:,1373), t3x64(:,:,671), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,310), A(:,672), n3(:,1374), t3x64(:,:,672), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,97), wf8(:,290), A(:,673), n3(:,1375), t3x64(:,:,673), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,98), wf8(:,290), A(:,674), n3(:,1376), t3x64(:,:,674), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,97), wf8(:,292), A(:,675), n3(:,1377), t3x64(:,:,675), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,98), wf8(:,292), A(:,676), n3(:,1378), t3x64(:,:,676), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,311), A(:,677), n3(:,1379), t3x64(:,:,677), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,311), A(:,678), n3(:,1380), t3x64(:,:,678), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,312), A(:,679), n3(:,1381), t3x64(:,:,679), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,312), A(:,680), n3(:,1382), t3x64(:,:,680), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,306), A(:,681), n3(:,1383), t3x64(:,:,681), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,102), wf8(:,306), A(:,682), n3(:,1384), t3x64(:,:,682), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,101), wf8(:,308), A(:,683), n3(:,1385), t3x64(:,:,683), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,102), wf8(:,308), A(:,684), n3(:,1386), t3x64(:,:,684), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,311), A(:,685), n3(:,1387), t3x64(:,:,685), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,311), A(:,686), n3(:,1388), t3x64(:,:,686), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,312), A(:,687), n3(:,1389), t3x64(:,:,687), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,312), A(:,688), n3(:,1390), t3x64(:,:,688), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,314), A(:,689), n3(:,1391), t3x64(:,:,689), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,314), A(:,690), n3(:,1392), t3x64(:,:,690), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,316), A(:,691), n3(:,1393), t3x64(:,:,691), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,316), A(:,692), n3(:,1394), t3x64(:,:,692), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,317), A(:,693), n3(:,1395), t3x64(:,:,693), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,317), A(:,694), n3(:,1396), t3x64(:,:,694), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,318), A(:,695), n3(:,1397), t3x64(:,:,695), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,318), A(:,696), n3(:,1398), t3x64(:,:,696), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,320), A(:,697), n3(:,1399), t3x64(:,:,697), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,320), A(:,698), n3(:,1400), t3x64(:,:,698), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,322), A(:,699), n3(:,1401), t3x64(:,:,699), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,322), A(:,700), n3(:,1402), t3x64(:,:,700), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,317), A(:,701), n3(:,1403), t3x64(:,:,701), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,317), A(:,702), n3(:,1404), t3x64(:,:,702), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,318), A(:,703), n3(:,1405), t3x64(:,:,703), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,318), A(:,704), n3(:,1406), t3x64(:,:,704), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,314), A(:,705), n3(:,1407), t3x64(:,:,705), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,314), A(:,706), n3(:,1408), t3x64(:,:,706), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,316), A(:,707), n3(:,1409), t3x64(:,:,707), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,316), A(:,708), n3(:,1410), t3x64(:,:,708), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,323), A(:,709), n3(:,1411), t3x64(:,:,709), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,323), A(:,710), n3(:,1412), t3x64(:,:,710), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,324), A(:,711), n3(:,1413), t3x64(:,:,711), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,324), A(:,712), n3(:,1414), t3x64(:,:,712), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,320), A(:,713), n3(:,1415), t3x64(:,:,713), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,320), A(:,714), n3(:,1416), t3x64(:,:,714), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,322), A(:,715), n3(:,1417), t3x64(:,:,715), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,322), A(:,716), n3(:,1418), t3x64(:,:,716), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,323), A(:,717), n3(:,1419), t3x64(:,:,717), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,323), A(:,718), n3(:,1420), t3x64(:,:,718), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,324), A(:,719), n3(:,1421), t3x64(:,:,719), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,324), A(:,720), n3(:,1422), t3x64(:,:,720), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,325), A(:,721), n3(:,1423), t3x64(:,:,721), nhel, den(398))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,325), A(:,722), n3(:,1424), t3x64(:,:,722), nhel, den(399))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,326), A(:,723), n3(:,1425), t3x64(:,:,723), nhel, den(401))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,326), A(:,724), n3(:,1426), t3x64(:,:,724), nhel, den(402))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,327), A(:,725), n3(:,1427), t3x64(:,:,725), nhel, den(401))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,327), A(:,726), n3(:,1428), t3x64(:,:,726), nhel, den(402))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,328), A(:,727), n3(:,1429), t3x64(:,:,727), nhel, den(404))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,328), A(:,728), n3(:,1430), t3x64(:,:,728), nhel, den(405))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,329), A(:,729), n3(:,1431), t3x64(:,:,729), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,329), A(:,730), n3(:,1432), t3x64(:,:,730), nhel, den(407))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,330), A(:,731), n3(:,1433), t3x64(:,:,731), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,330), A(:,732), n3(:,1434), t3x64(:,:,732), nhel, den(409))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,331), A(:,733), n3(:,1435), t3x64(:,:,733), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,331), A(:,734), n3(:,1436), t3x64(:,:,734), nhel, den(409))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,332), A(:,735), n3(:,1437), t3x64(:,:,735), nhel, den(410))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,332), A(:,736), n3(:,1438), t3x64(:,:,736), nhel, den(411))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,333), A(:,737), n3(:,1439), t3x64(:,:,737), nhel, den(413))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,333), A(:,738), n3(:,1440), t3x64(:,:,738), nhel, den(414))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,334), A(:,739), n3(:,1441), t3x64(:,:,739), nhel, den(416))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,334), A(:,740), n3(:,1442), t3x64(:,:,740), nhel, den(417))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,335), A(:,741), n3(:,1443), t3x64(:,:,741), nhel, den(416))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,335), A(:,742), n3(:,1444), t3x64(:,:,742), nhel, den(417))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,336), A(:,743), n3(:,1445), t3x64(:,:,743), nhel, den(419))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,336), A(:,744), n3(:,1446), t3x64(:,:,744), nhel, den(420))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,337), A(:,745), n3(:,1447), t3x64(:,:,745), nhel, den(421))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,337), A(:,746), n3(:,1448), t3x64(:,:,746), nhel, den(422))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,338), A(:,747), n3(:,1449), t3x64(:,:,747), nhel, den(423))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,338), A(:,748), n3(:,1450), t3x64(:,:,748), nhel, den(424))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,339), A(:,749), n3(:,1451), t3x64(:,:,749), nhel, den(423))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,339), A(:,750), n3(:,1452), t3x64(:,:,750), nhel, den(424))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,340), A(:,751), n3(:,1453), t3x64(:,:,751), nhel, den(425))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,340), A(:,752), n3(:,1454), t3x64(:,:,752), nhel, den(426))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,341), A(:,753), n3(:,1455), t3x64(:,:,753), nhel, den(427))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,341), A(:,754), n3(:,1456), t3x64(:,:,754), nhel, den(428))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,342), A(:,755), n3(:,1457), t3x64(:,:,755), nhel, den(429))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,342), A(:,756), n3(:,1458), t3x64(:,:,756), nhel, den(430))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,343), A(:,757), n3(:,1459), t3x64(:,:,757), nhel, den(431))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,344), A(:,758), n3(:,1460), t3x64(:,:,758), nhel, den(432))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,343), A(:,759), n3(:,1461), t3x64(:,:,759), nhel, den(433))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,344), A(:,760), n3(:,1462), t3x64(:,:,760), nhel, den(434))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,345), A(:,761), n3(:,1463), t3x64(:,:,761), nhel, den(435))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,345), A(:,762), n3(:,1464), t3x64(:,:,762), nhel, den(436))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,346), A(:,763), n3(:,1465), t3x64(:,:,763), nhel, den(437))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,346), A(:,764), n3(:,1466), t3x64(:,:,764), nhel, den(438))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,347), A(:,765), n3(:,1467), t3x64(:,:,765), nhel, den(437))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,347), A(:,766), n3(:,1468), t3x64(:,:,766), nhel, den(438))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,348), A(:,767), n3(:,1469), t3x64(:,:,767), nhel, den(439))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,348), A(:,768), n3(:,1470), t3x64(:,:,768), nhel, den(440))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,329), A(:,769), n3(:,1471), t3x64(:,:,769), nhel, den(441))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,329), A(:,770), n3(:,1472), t3x64(:,:,770), nhel, den(442))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,330), A(:,771), n3(:,1473), t3x64(:,:,771), nhel, den(443))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,330), A(:,772), n3(:,1474), t3x64(:,:,772), nhel, den(444))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,331), A(:,773), n3(:,1475), t3x64(:,:,773), nhel, den(443))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,331), A(:,774), n3(:,1476), t3x64(:,:,774), nhel, den(444))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,332), A(:,775), n3(:,1477), t3x64(:,:,775), nhel, den(445))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,332), A(:,776), n3(:,1478), t3x64(:,:,776), nhel, den(446))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,349), A(:,777), n3(:,1479), t3x64(:,:,777), nhel, den(448))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,349), A(:,778), n3(:,1480), t3x64(:,:,778), nhel, den(449))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,350), A(:,779), n3(:,1481), t3x64(:,:,779), nhel, den(451))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,350), A(:,780), n3(:,1482), t3x64(:,:,780), nhel, den(452))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,351), A(:,781), n3(:,1483), t3x64(:,:,781), nhel, den(451))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,351), A(:,782), n3(:,1484), t3x64(:,:,782), nhel, den(452))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,352), A(:,783), n3(:,1485), t3x64(:,:,783), nhel, den(454))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,352), A(:,784), n3(:,1486), t3x64(:,:,784), nhel, den(455))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,353), A(:,785), n3(:,1487), t3x64(:,:,785), nhel, den(456))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,353), A(:,786), n3(:,1488), t3x64(:,:,786), nhel, den(457))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,354), A(:,787), n3(:,1489), t3x64(:,:,787), nhel, den(458))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,354), A(:,788), n3(:,1490), t3x64(:,:,788), nhel, den(459))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,355), A(:,789), n3(:,1491), t3x64(:,:,789), nhel, den(460))
    call Hcont_QA(nsync, wf8(:,146), wf8(:,356), A(:,790), n3(:,1492), t3x64(:,:,790), nhel, den(461))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,355), A(:,791), n3(:,1493), t3x64(:,:,791), nhel, den(462))
    call Hcont_QA(nsync, wf8(:,148), wf8(:,356), A(:,792), n3(:,1494), t3x64(:,:,792), nhel, den(463))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,357), A(:,793), n3(:,1495), t3x64(:,:,793), nhel, den(464))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,357), A(:,794), n3(:,1496), t3x64(:,:,794), nhel, den(465))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,358), A(:,795), n3(:,1497), t3x64(:,:,795), nhel, den(466))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,358), A(:,796), n3(:,1498), t3x64(:,:,796), nhel, den(467))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,359), A(:,797), n3(:,1499), t3x64(:,:,797), nhel, den(466))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,359), A(:,798), n3(:,1500), t3x64(:,:,798), nhel, den(467))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,360), A(:,799), n3(:,1501), t3x64(:,:,799), nhel, den(468))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,360), A(:,800), n3(:,1502), t3x64(:,:,800), nhel, den(469))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,325), A(:,801), n3(:,1503), t3x64(:,:,801), nhel, den(470))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,325), A(:,802), n3(:,1504), t3x64(:,:,802), nhel, den(471))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,326), A(:,803), n3(:,1505), t3x64(:,:,803), nhel, den(472))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,326), A(:,804), n3(:,1506), t3x64(:,:,804), nhel, den(473))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,327), A(:,805), n3(:,1507), t3x64(:,:,805), nhel, den(472))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,327), A(:,806), n3(:,1508), t3x64(:,:,806), nhel, den(473))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,328), A(:,807), n3(:,1509), t3x64(:,:,807), nhel, den(474))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,328), A(:,808), n3(:,1510), t3x64(:,:,808), nhel, den(475))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,361), A(:,809), n3(:,1511), t3x64(:,:,809), nhel, den(476))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,361), A(:,810), n3(:,1512), t3x64(:,:,810), nhel, den(477))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,362), A(:,811), n3(:,1513), t3x64(:,:,811), nhel, den(478))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,362), A(:,812), n3(:,1514), t3x64(:,:,812), nhel, den(479))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,363), A(:,813), n3(:,1515), t3x64(:,:,813), nhel, den(478))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,363), A(:,814), n3(:,1516), t3x64(:,:,814), nhel, den(479))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,364), A(:,815), n3(:,1517), t3x64(:,:,815), nhel, den(480))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,364), A(:,816), n3(:,1518), t3x64(:,:,816), nhel, den(481))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,365), A(:,817), n3(:,1519), t3x64(:,:,817), nhel, den(483))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,365), A(:,818), n3(:,1520), t3x64(:,:,818), nhel, den(484))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,366), A(:,819), n3(:,1521), t3x64(:,:,819), nhel, den(486))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,366), A(:,820), n3(:,1522), t3x64(:,:,820), nhel, den(487))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,367), A(:,821), n3(:,1523), t3x64(:,:,821), nhel, den(486))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,367), A(:,822), n3(:,1524), t3x64(:,:,822), nhel, den(487))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,368), A(:,823), n3(:,1525), t3x64(:,:,823), nhel, den(489))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,368), A(:,824), n3(:,1526), t3x64(:,:,824), nhel, den(490))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,369), A(:,825), n3(:,1527), t3x64(:,:,825), nhel, den(491))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,369), A(:,826), n3(:,1528), t3x64(:,:,826), nhel, den(492))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,370), A(:,827), n3(:,1529), t3x64(:,:,827), nhel, den(493))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,370), A(:,828), n3(:,1530), t3x64(:,:,828), nhel, den(494))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,371), A(:,829), n3(:,1531), t3x64(:,:,829), nhel, den(493))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,371), A(:,830), n3(:,1532), t3x64(:,:,830), nhel, den(494))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,372), A(:,831), n3(:,1533), t3x64(:,:,831), nhel, den(495))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,372), A(:,832), n3(:,1534), t3x64(:,:,832), nhel, den(496))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,341), A(:,833), n3(:,1535), t3x64(:,:,833), nhel, den(497))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,341), A(:,834), n3(:,1536), t3x64(:,:,834), nhel, den(498))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,342), A(:,835), n3(:,1537), t3x64(:,:,835), nhel, den(499))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,342), A(:,836), n3(:,1538), t3x64(:,:,836), nhel, den(500))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,373), A(:,837), n3(:,1539), t3x64(:,:,837), nhel, den(501))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,374), A(:,838), n3(:,1540), t3x64(:,:,838), nhel, den(502))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,373), A(:,839), n3(:,1541), t3x64(:,:,839), nhel, den(503))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,374), A(:,840), n3(:,1542), t3x64(:,:,840), nhel, den(504))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,345), A(:,841), n3(:,1543), t3x64(:,:,841), nhel, den(505))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,345), A(:,842), n3(:,1544), t3x64(:,:,842), nhel, den(506))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,346), A(:,843), n3(:,1545), t3x64(:,:,843), nhel, den(507))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,346), A(:,844), n3(:,1546), t3x64(:,:,844), nhel, den(508))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,347), A(:,845), n3(:,1547), t3x64(:,:,845), nhel, den(507))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,347), A(:,846), n3(:,1548), t3x64(:,:,846), nhel, den(508))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,348), A(:,847), n3(:,1549), t3x64(:,:,847), nhel, den(509))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,348), A(:,848), n3(:,1550), t3x64(:,:,848), nhel, den(510))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,361), A(:,849), n3(:,1551), t3x64(:,:,849), nhel, den(511))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,361), A(:,850), n3(:,1552), t3x64(:,:,850), nhel, den(512))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,362), A(:,851), n3(:,1553), t3x64(:,:,851), nhel, den(513))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,362), A(:,852), n3(:,1554), t3x64(:,:,852), nhel, den(514))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,363), A(:,853), n3(:,1555), t3x64(:,:,853), nhel, den(513))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,363), A(:,854), n3(:,1556), t3x64(:,:,854), nhel, den(514))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,364), A(:,855), n3(:,1557), t3x64(:,:,855), nhel, den(515))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,364), A(:,856), n3(:,1558), t3x64(:,:,856), nhel, den(516))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,375), A(:,857), n3(:,1559), t3x64(:,:,857), nhel, den(518))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,375), A(:,858), n3(:,1560), t3x64(:,:,858), nhel, den(519))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,376), A(:,859), n3(:,1561), t3x64(:,:,859), nhel, den(521))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,376), A(:,860), n3(:,1562), t3x64(:,:,860), nhel, den(522))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,377), A(:,861), n3(:,1563), t3x64(:,:,861), nhel, den(521))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,377), A(:,862), n3(:,1564), t3x64(:,:,862), nhel, den(522))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,378), A(:,863), n3(:,1565), t3x64(:,:,863), nhel, den(524))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,378), A(:,864), n3(:,1566), t3x64(:,:,864), nhel, den(525))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,353), A(:,865), n3(:,1567), t3x64(:,:,865), nhel, den(526))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,353), A(:,866), n3(:,1568), t3x64(:,:,866), nhel, den(527))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,354), A(:,867), n3(:,1569), t3x64(:,:,867), nhel, den(528))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,354), A(:,868), n3(:,1570), t3x64(:,:,868), nhel, den(529))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,379), A(:,869), n3(:,1571), t3x64(:,:,869), nhel, den(530))
    call Hcont_QA(nsync, wf8(:,154), wf8(:,380), A(:,870), n3(:,1572), t3x64(:,:,870), nhel, den(531))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,379), A(:,871), n3(:,1573), t3x64(:,:,871), nhel, den(532))
    call Hcont_QA(nsync, wf8(:,156), wf8(:,380), A(:,872), n3(:,1574), t3x64(:,:,872), nhel, den(533))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,381), A(:,873), n3(:,1575), t3x64(:,:,873), nhel, den(534))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,381), A(:,874), n3(:,1576), t3x64(:,:,874), nhel, den(535))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,382), A(:,875), n3(:,1577), t3x64(:,:,875), nhel, den(536))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,382), A(:,876), n3(:,1578), t3x64(:,:,876), nhel, den(537))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,383), A(:,877), n3(:,1579), t3x64(:,:,877), nhel, den(536))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,383), A(:,878), n3(:,1580), t3x64(:,:,878), nhel, den(537))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,384), A(:,879), n3(:,1581), t3x64(:,:,879), nhel, den(538))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,384), A(:,880), n3(:,1582), t3x64(:,:,880), nhel, den(539))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,385), A(:,881), n3(:,1583), t3x64(:,:,881), nhel, den(541))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,385), A(:,882), n3(:,1584), t3x64(:,:,882), nhel, den(542))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,386), A(:,883), n3(:,1585), t3x64(:,:,883), nhel, den(544))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,386), A(:,884), n3(:,1586), t3x64(:,:,884), nhel, den(545))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,387), A(:,885), n3(:,1587), t3x64(:,:,885), nhel, den(544))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,387), A(:,886), n3(:,1588), t3x64(:,:,886), nhel, den(545))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,388), A(:,887), n3(:,1589), t3x64(:,:,887), nhel, den(547))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,388), A(:,888), n3(:,1590), t3x64(:,:,888), nhel, den(548))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,389), A(:,889), n3(:,1591), t3x64(:,:,889), nhel, den(549))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,389), A(:,890), n3(:,1592), t3x64(:,:,890), nhel, den(550))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,390), A(:,891), n3(:,1593), t3x64(:,:,891), nhel, den(551))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,390), A(:,892), n3(:,1594), t3x64(:,:,892), nhel, den(552))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,391), A(:,893), n3(:,1595), t3x64(:,:,893), nhel, den(551))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,391), A(:,894), n3(:,1596), t3x64(:,:,894), nhel, den(552))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,392), A(:,895), n3(:,1597), t3x64(:,:,895), nhel, den(553))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,392), A(:,896), n3(:,1598), t3x64(:,:,896), nhel, den(554))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,393), A(:,897), n3(:,1599), t3x64(:,:,897), nhel, den(556))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,393), A(:,898), n3(:,1600), t3x64(:,:,898), nhel, den(557))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,394), A(:,899), n3(:,1601), t3x64(:,:,899), nhel, den(559))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,394), A(:,900), n3(:,1602), t3x64(:,:,900), nhel, den(560))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,395), A(:,901), n3(:,1603), t3x64(:,:,901), nhel, den(559))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,395), A(:,902), n3(:,1604), t3x64(:,:,902), nhel, den(560))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,396), A(:,903), n3(:,1605), t3x64(:,:,903), nhel, den(562))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,396), A(:,904), n3(:,1606), t3x64(:,:,904), nhel, den(563))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,397), A(:,905), n3(:,1607), t3x64(:,:,905), nhel, den(564))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,397), A(:,906), n3(:,1608), t3x64(:,:,906), nhel, den(565))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,398), A(:,907), n3(:,1609), t3x64(:,:,907), nhel, den(566))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,398), A(:,908), n3(:,1610), t3x64(:,:,908), nhel, den(567))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,399), A(:,909), n3(:,1611), t3x64(:,:,909), nhel, den(566))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,399), A(:,910), n3(:,1612), t3x64(:,:,910), nhel, den(567))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,400), A(:,911), n3(:,1613), t3x64(:,:,911), nhel, den(568))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,400), A(:,912), n3(:,1614), t3x64(:,:,912), nhel, den(569))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,401), A(:,913), n3(:,1615), t3x64(:,:,913), nhel, den(570))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,401), A(:,914), n3(:,1616), t3x64(:,:,914), nhel, den(571))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,402), A(:,915), n3(:,1617), t3x64(:,:,915), nhel, den(572))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,402), A(:,916), n3(:,1618), t3x64(:,:,916), nhel, den(573))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,403), A(:,917), n3(:,1619), t3x64(:,:,917), nhel, den(574))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,404), A(:,918), n3(:,1620), t3x64(:,:,918), nhel, den(575))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,403), A(:,919), n3(:,1621), t3x64(:,:,919), nhel, den(576))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,404), A(:,920), n3(:,1622), t3x64(:,:,920), nhel, den(577))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,405), A(:,921), n3(:,1623), t3x64(:,:,921), nhel, den(578))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,405), A(:,922), n3(:,1624), t3x64(:,:,922), nhel, den(579))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,406), A(:,923), n3(:,1625), t3x64(:,:,923), nhel, den(580))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,406), A(:,924), n3(:,1626), t3x64(:,:,924), nhel, den(581))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,407), A(:,925), n3(:,1627), t3x64(:,:,925), nhel, den(580))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,407), A(:,926), n3(:,1628), t3x64(:,:,926), nhel, den(581))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,408), A(:,927), n3(:,1629), t3x64(:,:,927), nhel, den(582))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,408), A(:,928), n3(:,1630), t3x64(:,:,928), nhel, den(583))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,409), A(:,929), n3(:,1631), t3x64(:,:,929), nhel, den(584))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,409), A(:,930), n3(:,1632), t3x64(:,:,930), nhel, den(585))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,410), A(:,931), n3(:,1633), t3x64(:,:,931), nhel, den(586))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,410), A(:,932), n3(:,1634), t3x64(:,:,932), nhel, den(587))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,411), A(:,933), n3(:,1635), t3x64(:,:,933), nhel, den(586))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,411), A(:,934), n3(:,1636), t3x64(:,:,934), nhel, den(587))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,412), A(:,935), n3(:,1637), t3x64(:,:,935), nhel, den(588))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,412), A(:,936), n3(:,1638), t3x64(:,:,936), nhel, den(589))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,413), A(:,937), n3(:,1639), t3x64(:,:,937), nhel, den(590))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,413), A(:,938), n3(:,1640), t3x64(:,:,938), nhel, den(591))
    call Hcont_QA(nsync, wf8(:,220), wf8(:,414), A(:,939), n3(:,1641), t3x64(:,:,939), nhel, den(592))
    call Hcont_QA(nsync, wf8(:,221), wf8(:,414), A(:,940), n3(:,1642), t3x64(:,:,940), nhel, den(593))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,415), A(:,941), n3(:,1643), t3x64(:,:,941), nhel, den(594))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,415), A(:,942), n3(:,1644), t3x64(:,:,942), nhel, den(595))
    call Hcont_QA(nsync, wf8(:,176), wf8(:,416), A(:,943), n3(:,1645), t3x64(:,:,943), nhel, den(596))
    call Hcont_QA(nsync, wf8(:,177), wf8(:,416), A(:,944), n3(:,1646), t3x64(:,:,944), nhel, den(597))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,397), A(:,945), n3(:,1647), t3x64(:,:,945), nhel, den(598))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,397), A(:,946), n3(:,1648), t3x64(:,:,946), nhel, den(599))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,398), A(:,947), n3(:,1649), t3x64(:,:,947), nhel, den(600))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,398), A(:,948), n3(:,1650), t3x64(:,:,948), nhel, den(601))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,399), A(:,949), n3(:,1651), t3x64(:,:,949), nhel, den(600))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,399), A(:,950), n3(:,1652), t3x64(:,:,950), nhel, den(601))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,400), A(:,951), n3(:,1653), t3x64(:,:,951), nhel, den(602))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,400), A(:,952), n3(:,1654), t3x64(:,:,952), nhel, den(603))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,357), A(:,953), n3(:,1655), t3x64(:,:,953), nhel, den(604))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,357), A(:,954), n3(:,1656), t3x64(:,:,954), nhel, den(605))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,358), A(:,955), n3(:,1657), t3x64(:,:,955), nhel, den(606))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,358), A(:,956), n3(:,1658), t3x64(:,:,956), nhel, den(607))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,359), A(:,957), n3(:,1659), t3x64(:,:,957), nhel, den(606))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,359), A(:,958), n3(:,1660), t3x64(:,:,958), nhel, den(607))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,360), A(:,959), n3(:,1661), t3x64(:,:,959), nhel, den(608))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,360), A(:,960), n3(:,1662), t3x64(:,:,960), nhel, den(609))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,417), A(:,961), n3(:,1663), t3x64(:,:,961), nhel, den(611))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,417), A(:,962), n3(:,1664), t3x64(:,:,962), nhel, den(612))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,418), A(:,963), n3(:,1665), t3x64(:,:,963), nhel, den(614))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,418), A(:,964), n3(:,1666), t3x64(:,:,964), nhel, den(615))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,419), A(:,965), n3(:,1667), t3x64(:,:,965), nhel, den(614))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,419), A(:,966), n3(:,1668), t3x64(:,:,966), nhel, den(615))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,420), A(:,967), n3(:,1669), t3x64(:,:,967), nhel, den(617))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,420), A(:,968), n3(:,1670), t3x64(:,:,968), nhel, den(618))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,421), A(:,969), n3(:,1671), t3x64(:,:,969), nhel, den(619))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,421), A(:,970), n3(:,1672), t3x64(:,:,970), nhel, den(620))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,422), A(:,971), n3(:,1673), t3x64(:,:,971), nhel, den(621))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,422), A(:,972), n3(:,1674), t3x64(:,:,972), nhel, den(622))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,423), A(:,973), n3(:,1675), t3x64(:,:,973), nhel, den(621))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,423), A(:,974), n3(:,1676), t3x64(:,:,974), nhel, den(622))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,424), A(:,975), n3(:,1677), t3x64(:,:,975), nhel, den(623))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,424), A(:,976), n3(:,1678), t3x64(:,:,976), nhel, den(624))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,393), A(:,977), n3(:,1679), t3x64(:,:,977), nhel, den(625))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,393), A(:,978), n3(:,1680), t3x64(:,:,978), nhel, den(626))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,394), A(:,979), n3(:,1681), t3x64(:,:,979), nhel, den(627))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,394), A(:,980), n3(:,1682), t3x64(:,:,980), nhel, den(628))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,395), A(:,981), n3(:,1683), t3x64(:,:,981), nhel, den(627))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,395), A(:,982), n3(:,1684), t3x64(:,:,982), nhel, den(628))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,396), A(:,983), n3(:,1685), t3x64(:,:,983), nhel, den(629))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,396), A(:,984), n3(:,1686), t3x64(:,:,984), nhel, den(630))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,425), A(:,985), n3(:,1687), t3x64(:,:,985), nhel, den(631))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,425), A(:,986), n3(:,1688), t3x64(:,:,986), nhel, den(632))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,426), A(:,987), n3(:,1689), t3x64(:,:,987), nhel, den(633))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,426), A(:,988), n3(:,1690), t3x64(:,:,988), nhel, den(634))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,427), A(:,989), n3(:,1691), t3x64(:,:,989), nhel, den(633))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,427), A(:,990), n3(:,1692), t3x64(:,:,990), nhel, den(634))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,428), A(:,991), n3(:,1693), t3x64(:,:,991), nhel, den(635))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,428), A(:,992), n3(:,1694), t3x64(:,:,992), nhel, den(636))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,429), A(:,993), n3(:,1695), t3x64(:,:,993), nhel, den(637))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,429), A(:,994), n3(:,1696), t3x64(:,:,994), nhel, den(638))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,430), A(:,995), n3(:,1697), t3x64(:,:,995), nhel, den(639))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,430), A(:,996), n3(:,1698), t3x64(:,:,996), nhel, den(640))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,403), A(:,997), n3(:,1699), t3x64(:,:,997), nhel, den(641))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,404), A(:,998), n3(:,1700), t3x64(:,:,998), nhel, den(642))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,403), A(:,999), n3(:,1701), t3x64(:,:,999), nhel, den(643))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,404), A(:,1000), n3(:,1702), t3x64(:,:,1000), nhel, den(644))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,405), A(:,1001), n3(:,1703), t3x64(:,:,1001), nhel, den(645))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,405), A(:,1002), n3(:,1704), t3x64(:,:,1002), nhel, den(646))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,406), A(:,1003), n3(:,1705), t3x64(:,:,1003), nhel, den(647))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,406), A(:,1004), n3(:,1706), t3x64(:,:,1004), nhel, den(648))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,407), A(:,1005), n3(:,1707), t3x64(:,:,1005), nhel, den(647))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,407), A(:,1006), n3(:,1708), t3x64(:,:,1006), nhel, den(648))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,408), A(:,1007), n3(:,1709), t3x64(:,:,1007), nhel, den(649))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,408), A(:,1008), n3(:,1710), t3x64(:,:,1008), nhel, den(650))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,431), A(:,1009), n3(:,1711), t3x64(:,:,1009), nhel, den(651))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,431), A(:,1010), n3(:,1712), t3x64(:,:,1010), nhel, den(652))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,432), A(:,1011), n3(:,1713), t3x64(:,:,1011), nhel, den(653))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,432), A(:,1012), n3(:,1714), t3x64(:,:,1012), nhel, den(654))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,433), A(:,1013), n3(:,1715), t3x64(:,:,1013), nhel, den(653))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,433), A(:,1014), n3(:,1716), t3x64(:,:,1014), nhel, den(654))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,434), A(:,1015), n3(:,1717), t3x64(:,:,1015), nhel, den(655))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,434), A(:,1016), n3(:,1718), t3x64(:,:,1016), nhel, den(656))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,413), A(:,1017), n3(:,1719), t3x64(:,:,1017), nhel, den(657))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,413), A(:,1018), n3(:,1720), t3x64(:,:,1018), nhel, den(658))
    call Hcont_QA(nsync, wf8(:,225), wf8(:,414), A(:,1019), n3(:,1721), t3x64(:,:,1019), nhel, den(659))
    call Hcont_QA(nsync, wf8(:,226), wf8(:,414), A(:,1020), n3(:,1722), t3x64(:,:,1020), nhel, den(660))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,435), A(:,1021), n3(:,1723), t3x64(:,:,1021), nhel, den(661))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,435), A(:,1022), n3(:,1724), t3x64(:,:,1022), nhel, den(662))
    call Hcont_QA(nsync, wf8(:,182), wf8(:,436), A(:,1023), n3(:,1725), t3x64(:,:,1023), nhel, den(663))
    call Hcont_QA(nsync, wf8(:,183), wf8(:,436), A(:,1024), n3(:,1726), t3x64(:,:,1024), nhel, den(664))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,425), A(:,1025), n3(:,1727), t3x64(:,:,1025), nhel, den(665))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,425), A(:,1026), n3(:,1728), t3x64(:,:,1026), nhel, den(666))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,426), A(:,1027), n3(:,1729), t3x64(:,:,1027), nhel, den(667))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,426), A(:,1028), n3(:,1730), t3x64(:,:,1028), nhel, den(668))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,427), A(:,1029), n3(:,1731), t3x64(:,:,1029), nhel, den(667))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,427), A(:,1030), n3(:,1732), t3x64(:,:,1030), nhel, den(668))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,428), A(:,1031), n3(:,1733), t3x64(:,:,1031), nhel, den(669))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,428), A(:,1032), n3(:,1734), t3x64(:,:,1032), nhel, den(670))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,381), A(:,1033), n3(:,1735), t3x64(:,:,1033), nhel, den(671))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,381), A(:,1034), n3(:,1736), t3x64(:,:,1034), nhel, den(672))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,382), A(:,1035), n3(:,1737), t3x64(:,:,1035), nhel, den(673))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,382), A(:,1036), n3(:,1738), t3x64(:,:,1036), nhel, den(674))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,383), A(:,1037), n3(:,1739), t3x64(:,:,1037), nhel, den(673))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,383), A(:,1038), n3(:,1740), t3x64(:,:,1038), nhel, den(674))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,384), A(:,1039), n3(:,1741), t3x64(:,:,1039), nhel, den(675))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,384), A(:,1040), n3(:,1742), t3x64(:,:,1040), nhel, den(676))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,437), A(:,1041), n3(:,1743), t3x64(:,:,1041), nhel, den(677))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,437), A(:,1042), n3(:,1744), t3x64(:,:,1042), nhel, den(678))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,438), A(:,1043), n3(:,1745), t3x64(:,:,1043), nhel, den(679))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,438), A(:,1044), n3(:,1746), t3x64(:,:,1044), nhel, den(680))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,439), A(:,1045), n3(:,1747), t3x64(:,:,1045), nhel, den(679))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,439), A(:,1046), n3(:,1748), t3x64(:,:,1046), nhel, den(680))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,440), A(:,1047), n3(:,1749), t3x64(:,:,1047), nhel, den(681))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,440), A(:,1048), n3(:,1750), t3x64(:,:,1048), nhel, den(682))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,389), A(:,1049), n3(:,1751), t3x64(:,:,1049), nhel, den(683))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,389), A(:,1050), n3(:,1752), t3x64(:,:,1050), nhel, den(684))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,390), A(:,1051), n3(:,1753), t3x64(:,:,1051), nhel, den(685))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,390), A(:,1052), n3(:,1754), t3x64(:,:,1052), nhel, den(686))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,391), A(:,1053), n3(:,1755), t3x64(:,:,1053), nhel, den(685))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,391), A(:,1054), n3(:,1756), t3x64(:,:,1054), nhel, den(686))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,392), A(:,1055), n3(:,1757), t3x64(:,:,1055), nhel, den(687))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,392), A(:,1056), n3(:,1758), t3x64(:,:,1056), nhel, den(688))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,441), A(:,1057), n3(:,1759), t3x64(:,:,1057), nhel, den(690))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,441), A(:,1058), n3(:,1760), t3x64(:,:,1058), nhel, den(691))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,442), A(:,1059), n3(:,1761), t3x64(:,:,1059), nhel, den(693))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,442), A(:,1060), n3(:,1762), t3x64(:,:,1060), nhel, den(694))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,443), A(:,1061), n3(:,1763), t3x64(:,:,1061), nhel, den(693))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,443), A(:,1062), n3(:,1764), t3x64(:,:,1062), nhel, den(694))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,444), A(:,1063), n3(:,1765), t3x64(:,:,1063), nhel, den(696))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,444), A(:,1064), n3(:,1766), t3x64(:,:,1064), nhel, den(697))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,445), A(:,1065), n3(:,1767), t3x64(:,:,1065), nhel, den(698))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,445), A(:,1066), n3(:,1768), t3x64(:,:,1066), nhel, den(699))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,446), A(:,1067), n3(:,1769), t3x64(:,:,1067), nhel, den(700))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,446), A(:,1068), n3(:,1770), t3x64(:,:,1068), nhel, den(701))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,447), A(:,1069), n3(:,1771), t3x64(:,:,1069), nhel, den(702))
    call Hcont_QA(nsync, wf8(:,172), wf8(:,448), A(:,1070), n3(:,1772), t3x64(:,:,1070), nhel, den(703))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,447), A(:,1071), n3(:,1773), t3x64(:,:,1071), nhel, den(704))
    call Hcont_QA(nsync, wf8(:,174), wf8(:,448), A(:,1072), n3(:,1774), t3x64(:,:,1072), nhel, den(705))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,449), A(:,1073), n3(:,1775), t3x64(:,:,1073), nhel, den(706))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,449), A(:,1074), n3(:,1776), t3x64(:,:,1074), nhel, den(707))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,450), A(:,1075), n3(:,1777), t3x64(:,:,1075), nhel, den(708))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,450), A(:,1076), n3(:,1778), t3x64(:,:,1076), nhel, den(709))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,451), A(:,1077), n3(:,1779), t3x64(:,:,1077), nhel, den(708))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,451), A(:,1078), n3(:,1780), t3x64(:,:,1078), nhel, den(709))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,452), A(:,1079), n3(:,1781), t3x64(:,:,1079), nhel, den(710))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,452), A(:,1080), n3(:,1782), t3x64(:,:,1080), nhel, den(711))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,453), A(:,1081), n3(:,1783), t3x64(:,:,1081), nhel, den(712))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,453), A(:,1082), n3(:,1784), t3x64(:,:,1082), nhel, den(713))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,454), A(:,1083), n3(:,1785), t3x64(:,:,1083), nhel, den(714))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,454), A(:,1084), n3(:,1786), t3x64(:,:,1084), nhel, den(715))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,455), A(:,1085), n3(:,1787), t3x64(:,:,1085), nhel, den(714))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,455), A(:,1086), n3(:,1788), t3x64(:,:,1086), nhel, den(715))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,456), A(:,1087), n3(:,1789), t3x64(:,:,1087), nhel, den(716))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,456), A(:,1088), n3(:,1790), t3x64(:,:,1088), nhel, den(717))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,457), A(:,1089), n3(:,1791), t3x64(:,:,1089), nhel, den(718))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,457), A(:,1090), n3(:,1792), t3x64(:,:,1090), nhel, den(719))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,458), A(:,1091), n3(:,1793), t3x64(:,:,1091), nhel, den(720))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,458), A(:,1092), n3(:,1794), t3x64(:,:,1092), nhel, den(721))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,459), A(:,1093), n3(:,1795), t3x64(:,:,1093), nhel, den(720))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,459), A(:,1094), n3(:,1796), t3x64(:,:,1094), nhel, den(721))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,460), A(:,1095), n3(:,1797), t3x64(:,:,1095), nhel, den(722))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,460), A(:,1096), n3(:,1798), t3x64(:,:,1096), nhel, den(723))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,461), A(:,1097), n3(:,1799), t3x64(:,:,1097), nhel, den(724))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,461), A(:,1098), n3(:,1800), t3x64(:,:,1098), nhel, den(725))
    call Hcont_QA(nsync, wf8(:,242), wf8(:,462), A(:,1099), n3(:,1801), t3x64(:,:,1099), nhel, den(726))
    call Hcont_QA(nsync, wf8(:,243), wf8(:,462), A(:,1100), n3(:,1802), t3x64(:,:,1100), nhel, den(727))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,463), A(:,1101), n3(:,1803), t3x64(:,:,1101), nhel, den(728))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,463), A(:,1102), n3(:,1804), t3x64(:,:,1102), nhel, den(729))
    call Hcont_QA(nsync, wf8(:,150), wf8(:,464), A(:,1103), n3(:,1805), t3x64(:,:,1103), nhel, den(730))
    call Hcont_QA(nsync, wf8(:,151), wf8(:,464), A(:,1104), n3(:,1806), t3x64(:,:,1104), nhel, den(731))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,337), A(:,1105), n3(:,1807), t3x64(:,:,1105), nhel, den(732))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,337), A(:,1106), n3(:,1808), t3x64(:,:,1106), nhel, den(733))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,338), A(:,1107), n3(:,1809), t3x64(:,:,1107), nhel, den(734))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,338), A(:,1108), n3(:,1810), t3x64(:,:,1108), nhel, den(735))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,339), A(:,1109), n3(:,1811), t3x64(:,:,1109), nhel, den(734))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,339), A(:,1110), n3(:,1812), t3x64(:,:,1110), nhel, den(735))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,340), A(:,1111), n3(:,1813), t3x64(:,:,1111), nhel, den(736))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,340), A(:,1112), n3(:,1814), t3x64(:,:,1112), nhel, den(737))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,449), A(:,1113), n3(:,1815), t3x64(:,:,1113), nhel, den(738))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,449), A(:,1114), n3(:,1816), t3x64(:,:,1114), nhel, den(739))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,450), A(:,1115), n3(:,1817), t3x64(:,:,1115), nhel, den(740))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,450), A(:,1116), n3(:,1818), t3x64(:,:,1116), nhel, den(741))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,451), A(:,1117), n3(:,1819), t3x64(:,:,1117), nhel, den(740))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,451), A(:,1118), n3(:,1820), t3x64(:,:,1118), nhel, den(741))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,452), A(:,1119), n3(:,1821), t3x64(:,:,1119), nhel, den(742))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,452), A(:,1120), n3(:,1822), t3x64(:,:,1120), nhel, den(743))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,465), A(:,1121), n3(:,1823), t3x64(:,:,1121), nhel, den(744))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,465), A(:,1122), n3(:,1824), t3x64(:,:,1122), nhel, den(745))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,466), A(:,1123), n3(:,1825), t3x64(:,:,1123), nhel, den(746))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,466), A(:,1124), n3(:,1826), t3x64(:,:,1124), nhel, den(747))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,467), A(:,1125), n3(:,1827), t3x64(:,:,1125), nhel, den(746))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,467), A(:,1126), n3(:,1828), t3x64(:,:,1126), nhel, den(747))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,468), A(:,1127), n3(:,1829), t3x64(:,:,1127), nhel, den(748))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,468), A(:,1128), n3(:,1830), t3x64(:,:,1128), nhel, den(749))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,421), A(:,1129), n3(:,1831), t3x64(:,:,1129), nhel, den(750))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,421), A(:,1130), n3(:,1832), t3x64(:,:,1130), nhel, den(751))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,422), A(:,1131), n3(:,1833), t3x64(:,:,1131), nhel, den(752))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,422), A(:,1132), n3(:,1834), t3x64(:,:,1132), nhel, den(753))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,423), A(:,1133), n3(:,1835), t3x64(:,:,1133), nhel, den(752))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,423), A(:,1134), n3(:,1836), t3x64(:,:,1134), nhel, den(753))
    call Hcont_QA(nsync, wf8(:,76), wf8(:,424), A(:,1135), n3(:,1837), t3x64(:,:,1135), nhel, den(754))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,424), A(:,1136), n3(:,1838), t3x64(:,:,1136), nhel, den(755))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,441), A(:,1137), n3(:,1839), t3x64(:,:,1137), nhel, den(756))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,441), A(:,1138), n3(:,1840), t3x64(:,:,1138), nhel, den(757))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,442), A(:,1139), n3(:,1841), t3x64(:,:,1139), nhel, den(758))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,442), A(:,1140), n3(:,1842), t3x64(:,:,1140), nhel, den(759))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,443), A(:,1141), n3(:,1843), t3x64(:,:,1141), nhel, den(758))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,443), A(:,1142), n3(:,1844), t3x64(:,:,1142), nhel, den(759))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,444), A(:,1143), n3(:,1845), t3x64(:,:,1143), nhel, den(760))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,444), A(:,1144), n3(:,1846), t3x64(:,:,1144), nhel, den(761))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,469), A(:,1145), n3(:,1847), t3x64(:,:,1145), nhel, den(762))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,469), A(:,1146), n3(:,1848), t3x64(:,:,1146), nhel, den(763))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,470), A(:,1147), n3(:,1849), t3x64(:,:,1147), nhel, den(764))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,470), A(:,1148), n3(:,1850), t3x64(:,:,1148), nhel, den(765))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,447), A(:,1149), n3(:,1851), t3x64(:,:,1149), nhel, den(766))
    call Hcont_QA(nsync, wf8(:,179), wf8(:,448), A(:,1150), n3(:,1852), t3x64(:,:,1150), nhel, den(767))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,447), A(:,1151), n3(:,1853), t3x64(:,:,1151), nhel, den(768))
    call Hcont_QA(nsync, wf8(:,180), wf8(:,448), A(:,1152), n3(:,1854), t3x64(:,:,1152), nhel, den(769))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,471), A(:,1153), n3(:,1855), t3x64(:,:,1153), nhel, den(770))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,471), A(:,1154), n3(:,1856), t3x64(:,:,1154), nhel, den(771))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,472), A(:,1155), n3(:,1857), t3x64(:,:,1155), nhel, den(772))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,472), A(:,1156), n3(:,1858), t3x64(:,:,1156), nhel, den(773))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,473), A(:,1157), n3(:,1859), t3x64(:,:,1157), nhel, den(772))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,473), A(:,1158), n3(:,1860), t3x64(:,:,1158), nhel, den(773))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,474), A(:,1159), n3(:,1861), t3x64(:,:,1159), nhel, den(774))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,474), A(:,1160), n3(:,1862), t3x64(:,:,1160), nhel, den(775))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,475), A(:,1161), n3(:,1863), t3x64(:,:,1161), nhel, den(776))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,475), A(:,1162), n3(:,1864), t3x64(:,:,1162), nhel, den(777))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,476), A(:,1163), n3(:,1865), t3x64(:,:,1163), nhel, den(778))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,476), A(:,1164), n3(:,1866), t3x64(:,:,1164), nhel, den(779))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,477), A(:,1165), n3(:,1867), t3x64(:,:,1165), nhel, den(778))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,477), A(:,1166), n3(:,1868), t3x64(:,:,1166), nhel, den(779))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,478), A(:,1167), n3(:,1869), t3x64(:,:,1167), nhel, den(780))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,478), A(:,1168), n3(:,1870), t3x64(:,:,1168), nhel, den(781))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,457), A(:,1169), n3(:,1871), t3x64(:,:,1169), nhel, den(782))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,457), A(:,1170), n3(:,1872), t3x64(:,:,1170), nhel, den(783))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,458), A(:,1171), n3(:,1873), t3x64(:,:,1171), nhel, den(784))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,458), A(:,1172), n3(:,1874), t3x64(:,:,1172), nhel, den(785))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,459), A(:,1173), n3(:,1875), t3x64(:,:,1173), nhel, den(784))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,459), A(:,1174), n3(:,1876), t3x64(:,:,1174), nhel, den(785))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,460), A(:,1175), n3(:,1877), t3x64(:,:,1175), nhel, den(786))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,460), A(:,1176), n3(:,1878), t3x64(:,:,1176), nhel, den(787))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,479), A(:,1177), n3(:,1879), t3x64(:,:,1177), nhel, den(788))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,479), A(:,1178), n3(:,1880), t3x64(:,:,1178), nhel, den(789))
    call Hcont_QA(nsync, wf8(:,246), wf8(:,480), A(:,1179), n3(:,1881), t3x64(:,:,1179), nhel, den(790))
    call Hcont_QA(nsync, wf8(:,247), wf8(:,480), A(:,1180), n3(:,1882), t3x64(:,:,1180), nhel, den(791))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,463), A(:,1181), n3(:,1883), t3x64(:,:,1181), nhel, den(792))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,463), A(:,1182), n3(:,1884), t3x64(:,:,1182), nhel, den(793))
    call Hcont_QA(nsync, wf8(:,157), wf8(:,464), A(:,1183), n3(:,1885), t3x64(:,:,1183), nhel, den(794))
    call Hcont_QA(nsync, wf8(:,158), wf8(:,464), A(:,1184), n3(:,1886), t3x64(:,:,1184), nhel, den(795))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,369), A(:,1185), n3(:,1887), t3x64(:,:,1185), nhel, den(796))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,369), A(:,1186), n3(:,1888), t3x64(:,:,1186), nhel, den(797))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,370), A(:,1187), n3(:,1889), t3x64(:,:,1187), nhel, den(798))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,370), A(:,1188), n3(:,1890), t3x64(:,:,1188), nhel, den(799))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,371), A(:,1189), n3(:,1891), t3x64(:,:,1189), nhel, den(798))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,371), A(:,1190), n3(:,1892), t3x64(:,:,1190), nhel, den(799))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,372), A(:,1191), n3(:,1893), t3x64(:,:,1191), nhel, den(800))
    call Hcont_QA(nsync, wf8(:,86), wf8(:,372), A(:,1192), n3(:,1894), t3x64(:,:,1192), nhel, den(801))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,471), A(:,1193), n3(:,1895), t3x64(:,:,1193), nhel, den(802))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,471), A(:,1194), n3(:,1896), t3x64(:,:,1194), nhel, den(803))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,472), A(:,1195), n3(:,1897), t3x64(:,:,1195), nhel, den(804))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,472), A(:,1196), n3(:,1898), t3x64(:,:,1196), nhel, den(805))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,473), A(:,1197), n3(:,1899), t3x64(:,:,1197), nhel, den(804))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,473), A(:,1198), n3(:,1900), t3x64(:,:,1198), nhel, den(805))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,474), A(:,1199), n3(:,1901), t3x64(:,:,1199), nhel, den(806))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,474), A(:,1200), n3(:,1902), t3x64(:,:,1200), nhel, den(807))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,385), A(:,1201), n3(:,1903), t3x64(:,:,1201), nhel, den(808))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,385), A(:,1202), n3(:,1904), t3x64(:,:,1202), nhel, den(809))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,386), A(:,1203), n3(:,1905), t3x64(:,:,1203), nhel, den(810))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,386), A(:,1204), n3(:,1906), t3x64(:,:,1204), nhel, den(811))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,387), A(:,1205), n3(:,1907), t3x64(:,:,1205), nhel, den(810))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,387), A(:,1206), n3(:,1908), t3x64(:,:,1206), nhel, den(811))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,388), A(:,1207), n3(:,1909), t3x64(:,:,1207), nhel, den(812))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,388), A(:,1208), n3(:,1910), t3x64(:,:,1208), nhel, den(813))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,481), A(:,1209), n3(:,1911), t3x64(:,:,1209), nhel, den(814))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,481), A(:,1210), n3(:,1912), t3x64(:,:,1210), nhel, den(815))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,482), A(:,1211), n3(:,1913), t3x64(:,:,1211), nhel, den(816))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,482), A(:,1212), n3(:,1914), t3x64(:,:,1212), nhel, den(817))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,483), A(:,1213), n3(:,1915), t3x64(:,:,1213), nhel, den(816))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,483), A(:,1214), n3(:,1916), t3x64(:,:,1214), nhel, den(817))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,484), A(:,1215), n3(:,1917), t3x64(:,:,1215), nhel, den(818))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,484), A(:,1216), n3(:,1918), t3x64(:,:,1216), nhel, den(819))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,365), A(:,1217), n3(:,1919), t3x64(:,:,1217), nhel, den(820))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,365), A(:,1218), n3(:,1920), t3x64(:,:,1218), nhel, den(821))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,366), A(:,1219), n3(:,1921), t3x64(:,:,1219), nhel, den(822))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,366), A(:,1220), n3(:,1922), t3x64(:,:,1220), nhel, den(823))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,367), A(:,1221), n3(:,1923), t3x64(:,:,1221), nhel, den(822))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,367), A(:,1222), n3(:,1924), t3x64(:,:,1222), nhel, den(823))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,368), A(:,1223), n3(:,1925), t3x64(:,:,1223), nhel, den(824))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,368), A(:,1224), n3(:,1926), t3x64(:,:,1224), nhel, den(825))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,485), A(:,1225), n3(:,1927), t3x64(:,:,1225), nhel, den(826))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,485), A(:,1226), n3(:,1928), t3x64(:,:,1226), nhel, den(827))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,486), A(:,1227), n3(:,1929), t3x64(:,:,1227), nhel, den(828))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,486), A(:,1228), n3(:,1930), t3x64(:,:,1228), nhel, den(829))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,487), A(:,1229), n3(:,1931), t3x64(:,:,1229), nhel, den(828))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,487), A(:,1230), n3(:,1932), t3x64(:,:,1230), nhel, den(829))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,488), A(:,1231), n3(:,1933), t3x64(:,:,1231), nhel, den(830))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,488), A(:,1232), n3(:,1934), t3x64(:,:,1232), nhel, den(831))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,401), A(:,1233), n3(:,1935), t3x64(:,:,1233), nhel, den(832))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,401), A(:,1234), n3(:,1936), t3x64(:,:,1234), nhel, den(833))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,402), A(:,1235), n3(:,1937), t3x64(:,:,1235), nhel, den(834))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,402), A(:,1236), n3(:,1938), t3x64(:,:,1236), nhel, den(835))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,373), A(:,1237), n3(:,1939), t3x64(:,:,1237), nhel, den(836))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,374), A(:,1238), n3(:,1940), t3x64(:,:,1238), nhel, den(837))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,373), A(:,1239), n3(:,1941), t3x64(:,:,1239), nhel, den(838))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,374), A(:,1240), n3(:,1942), t3x64(:,:,1240), nhel, den(839))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,437), A(:,1241), n3(:,1943), t3x64(:,:,1241), nhel, den(840))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,437), A(:,1242), n3(:,1944), t3x64(:,:,1242), nhel, den(841))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,438), A(:,1243), n3(:,1945), t3x64(:,:,1243), nhel, den(842))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,438), A(:,1244), n3(:,1946), t3x64(:,:,1244), nhel, den(843))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,439), A(:,1245), n3(:,1947), t3x64(:,:,1245), nhel, den(842))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,439), A(:,1246), n3(:,1948), t3x64(:,:,1246), nhel, den(843))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,440), A(:,1247), n3(:,1949), t3x64(:,:,1247), nhel, den(844))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,440), A(:,1248), n3(:,1950), t3x64(:,:,1248), nhel, den(845))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,481), A(:,1249), n3(:,1951), t3x64(:,:,1249), nhel, den(846))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,481), A(:,1250), n3(:,1952), t3x64(:,:,1250), nhel, den(847))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,482), A(:,1251), n3(:,1953), t3x64(:,:,1251), nhel, den(848))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,482), A(:,1252), n3(:,1954), t3x64(:,:,1252), nhel, den(849))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,483), A(:,1253), n3(:,1955), t3x64(:,:,1253), nhel, den(848))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,483), A(:,1254), n3(:,1956), t3x64(:,:,1254), nhel, den(849))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,484), A(:,1255), n3(:,1957), t3x64(:,:,1255), nhel, den(850))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,484), A(:,1256), n3(:,1958), t3x64(:,:,1256), nhel, den(851))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,375), A(:,1257), n3(:,1959), t3x64(:,:,1257), nhel, den(852))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,375), A(:,1258), n3(:,1960), t3x64(:,:,1258), nhel, den(853))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,376), A(:,1259), n3(:,1961), t3x64(:,:,1259), nhel, den(854))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,376), A(:,1260), n3(:,1962), t3x64(:,:,1260), nhel, den(855))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,377), A(:,1261), n3(:,1963), t3x64(:,:,1261), nhel, den(854))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,377), A(:,1262), n3(:,1964), t3x64(:,:,1262), nhel, den(855))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,378), A(:,1263), n3(:,1965), t3x64(:,:,1263), nhel, den(856))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,378), A(:,1264), n3(:,1966), t3x64(:,:,1264), nhel, den(857))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,445), A(:,1265), n3(:,1967), t3x64(:,:,1265), nhel, den(858))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,445), A(:,1266), n3(:,1968), t3x64(:,:,1266), nhel, den(859))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,446), A(:,1267), n3(:,1969), t3x64(:,:,1267), nhel, den(860))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,446), A(:,1268), n3(:,1970), t3x64(:,:,1268), nhel, den(861))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,379), A(:,1269), n3(:,1971), t3x64(:,:,1269), nhel, den(862))
    call Hcont_QA(nsync, wf8(:,193), wf8(:,380), A(:,1270), n3(:,1972), t3x64(:,:,1270), nhel, den(863))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,379), A(:,1271), n3(:,1973), t3x64(:,:,1271), nhel, den(864))
    call Hcont_QA(nsync, wf8(:,194), wf8(:,380), A(:,1272), n3(:,1974), t3x64(:,:,1272), nhel, den(865))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,489), A(:,1273), n3(:,1975), t3x64(:,:,1273), nhel, den(866))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,489), A(:,1274), n3(:,1976), t3x64(:,:,1274), nhel, den(867))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,490), A(:,1275), n3(:,1977), t3x64(:,:,1275), nhel, den(868))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,490), A(:,1276), n3(:,1978), t3x64(:,:,1276), nhel, den(869))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,491), A(:,1277), n3(:,1979), t3x64(:,:,1277), nhel, den(868))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,491), A(:,1278), n3(:,1980), t3x64(:,:,1278), nhel, den(869))
    call Hcont_QA(nsync, wf8(:,71), wf8(:,492), A(:,1279), n3(:,1981), t3x64(:,:,1279), nhel, den(870))
    call Hcont_QA(nsync, wf8(:,74), wf8(:,492), A(:,1280), n3(:,1982), t3x64(:,:,1280), nhel, den(871))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,417), A(:,1281), n3(:,1983), t3x64(:,:,1281), nhel, den(872))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,417), A(:,1282), n3(:,1984), t3x64(:,:,1282), nhel, den(873))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,418), A(:,1283), n3(:,1985), t3x64(:,:,1283), nhel, den(874))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,418), A(:,1284), n3(:,1986), t3x64(:,:,1284), nhel, den(875))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,419), A(:,1285), n3(:,1987), t3x64(:,:,1285), nhel, den(874))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,419), A(:,1286), n3(:,1988), t3x64(:,:,1286), nhel, den(875))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,420), A(:,1287), n3(:,1989), t3x64(:,:,1287), nhel, den(876))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,420), A(:,1288), n3(:,1990), t3x64(:,:,1288), nhel, den(877))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,493), A(:,1289), n3(:,1991), t3x64(:,:,1289), nhel, den(878))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,493), A(:,1290), n3(:,1992), t3x64(:,:,1290), nhel, den(879))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,494), A(:,1291), n3(:,1993), t3x64(:,:,1291), nhel, den(880))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,494), A(:,1292), n3(:,1994), t3x64(:,:,1292), nhel, den(881))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,495), A(:,1293), n3(:,1995), t3x64(:,:,1293), nhel, den(880))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,495), A(:,1294), n3(:,1996), t3x64(:,:,1294), nhel, den(881))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,496), A(:,1295), n3(:,1997), t3x64(:,:,1295), nhel, den(882))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,496), A(:,1296), n3(:,1998), t3x64(:,:,1296), nhel, den(883))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,333), A(:,1297), n3(:,1999), t3x64(:,:,1297), nhel, den(884))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,333), A(:,1298), n3(:,2000), t3x64(:,:,1298), nhel, den(885))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,334), A(:,1299), n3(:,2001), t3x64(:,:,1299), nhel, den(886))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,334), A(:,1300), n3(:,2002), t3x64(:,:,1300), nhel, den(887))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,335), A(:,1301), n3(:,2003), t3x64(:,:,1301), nhel, den(886))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,335), A(:,1302), n3(:,2004), t3x64(:,:,1302), nhel, den(887))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,336), A(:,1303), n3(:,2005), t3x64(:,:,1303), nhel, den(888))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,336), A(:,1304), n3(:,2006), t3x64(:,:,1304), nhel, den(889))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,497), A(:,1305), n3(:,2007), t3x64(:,:,1305), nhel, den(890))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,497), A(:,1306), n3(:,2008), t3x64(:,:,1306), nhel, den(891))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,498), A(:,1307), n3(:,2009), t3x64(:,:,1307), nhel, den(892))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,498), A(:,1308), n3(:,2010), t3x64(:,:,1308), nhel, den(893))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,499), A(:,1309), n3(:,2011), t3x64(:,:,1309), nhel, den(892))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,499), A(:,1310), n3(:,2012), t3x64(:,:,1310), nhel, den(893))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,500), A(:,1311), n3(:,2013), t3x64(:,:,1311), nhel, den(894))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,500), A(:,1312), n3(:,2014), t3x64(:,:,1312), nhel, den(895))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,429), A(:,1313), n3(:,2015), t3x64(:,:,1313), nhel, den(896))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,429), A(:,1314), n3(:,2016), t3x64(:,:,1314), nhel, den(897))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,430), A(:,1315), n3(:,2017), t3x64(:,:,1315), nhel, den(898))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,430), A(:,1316), n3(:,2018), t3x64(:,:,1316), nhel, den(899))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,343), A(:,1317), n3(:,2019), t3x64(:,:,1317), nhel, den(900))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,344), A(:,1318), n3(:,2020), t3x64(:,:,1318), nhel, den(901))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,343), A(:,1319), n3(:,2021), t3x64(:,:,1319), nhel, den(902))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,344), A(:,1320), n3(:,2022), t3x64(:,:,1320), nhel, den(903))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,453), A(:,1321), n3(:,2023), t3x64(:,:,1321), nhel, den(904))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,453), A(:,1322), n3(:,2024), t3x64(:,:,1322), nhel, den(905))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,454), A(:,1323), n3(:,2025), t3x64(:,:,1323), nhel, den(906))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,454), A(:,1324), n3(:,2026), t3x64(:,:,1324), nhel, den(907))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,455), A(:,1325), n3(:,2027), t3x64(:,:,1325), nhel, den(906))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,455), A(:,1326), n3(:,2028), t3x64(:,:,1326), nhel, den(907))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,456), A(:,1327), n3(:,2029), t3x64(:,:,1327), nhel, den(908))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,456), A(:,1328), n3(:,2030), t3x64(:,:,1328), nhel, den(909))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,431), A(:,1329), n3(:,2031), t3x64(:,:,1329), nhel, den(910))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,431), A(:,1330), n3(:,2032), t3x64(:,:,1330), nhel, den(911))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,432), A(:,1331), n3(:,2033), t3x64(:,:,1331), nhel, den(912))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,432), A(:,1332), n3(:,2034), t3x64(:,:,1332), nhel, den(913))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,433), A(:,1333), n3(:,2035), t3x64(:,:,1333), nhel, den(912))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,433), A(:,1334), n3(:,2036), t3x64(:,:,1334), nhel, den(913))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,434), A(:,1335), n3(:,2037), t3x64(:,:,1335), nhel, den(914))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,434), A(:,1336), n3(:,2038), t3x64(:,:,1336), nhel, den(915))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,461), A(:,1337), n3(:,2039), t3x64(:,:,1337), nhel, den(916))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,461), A(:,1338), n3(:,2040), t3x64(:,:,1338), nhel, den(917))
    call Hcont_QA(nsync, wf8(:,257), wf8(:,462), A(:,1339), n3(:,2041), t3x64(:,:,1339), nhel, den(918))
    call Hcont_QA(nsync, wf8(:,258), wf8(:,462), A(:,1340), n3(:,2042), t3x64(:,:,1340), nhel, den(919))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,435), A(:,1341), n3(:,2043), t3x64(:,:,1341), nhel, den(920))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,435), A(:,1342), n3(:,2044), t3x64(:,:,1342), nhel, den(921))
    call Hcont_QA(nsync, wf8(:,201), wf8(:,436), A(:,1343), n3(:,2045), t3x64(:,:,1343), nhel, den(922))
    call Hcont_QA(nsync, wf8(:,202), wf8(:,436), A(:,1344), n3(:,2046), t3x64(:,:,1344), nhel, den(923))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,497), A(:,1345), n3(:,2047), t3x64(:,:,1345), nhel, den(924))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,497), A(:,1346), n3(:,2048), t3x64(:,:,1346), nhel, den(925))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,498), A(:,1347), n3(:,2049), t3x64(:,:,1347), nhel, den(926))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,498), A(:,1348), n3(:,2050), t3x64(:,:,1348), nhel, den(927))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,499), A(:,1349), n3(:,2051), t3x64(:,:,1349), nhel, den(926))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,499), A(:,1350), n3(:,2052), t3x64(:,:,1350), nhel, den(927))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,500), A(:,1351), n3(:,2053), t3x64(:,:,1351), nhel, den(928))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,500), A(:,1352), n3(:,2054), t3x64(:,:,1352), nhel, den(929))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,489), A(:,1353), n3(:,2055), t3x64(:,:,1353), nhel, den(930))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,489), A(:,1354), n3(:,2056), t3x64(:,:,1354), nhel, den(931))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,490), A(:,1355), n3(:,2057), t3x64(:,:,1355), nhel, den(932))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,490), A(:,1356), n3(:,2058), t3x64(:,:,1356), nhel, den(933))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,491), A(:,1357), n3(:,2059), t3x64(:,:,1357), nhel, den(932))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,491), A(:,1358), n3(:,2060), t3x64(:,:,1358), nhel, den(933))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,492), A(:,1359), n3(:,2061), t3x64(:,:,1359), nhel, den(934))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,492), A(:,1360), n3(:,2062), t3x64(:,:,1360), nhel, den(935))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,465), A(:,1361), n3(:,2063), t3x64(:,:,1361), nhel, den(936))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,465), A(:,1362), n3(:,2064), t3x64(:,:,1362), nhel, den(937))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,466), A(:,1363), n3(:,2065), t3x64(:,:,1363), nhel, den(938))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,466), A(:,1364), n3(:,2066), t3x64(:,:,1364), nhel, den(939))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,467), A(:,1365), n3(:,2067), t3x64(:,:,1365), nhel, den(938))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,467), A(:,1366), n3(:,2068), t3x64(:,:,1366), nhel, den(939))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,468), A(:,1367), n3(:,2069), t3x64(:,:,1367), nhel, den(940))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,468), A(:,1368), n3(:,2070), t3x64(:,:,1368), nhel, den(941))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,493), A(:,1369), n3(:,2071), t3x64(:,:,1369), nhel, den(942))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,493), A(:,1370), n3(:,2072), t3x64(:,:,1370), nhel, den(943))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,494), A(:,1371), n3(:,2073), t3x64(:,:,1371), nhel, den(944))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,494), A(:,1372), n3(:,2074), t3x64(:,:,1372), nhel, den(945))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,495), A(:,1373), n3(:,2075), t3x64(:,:,1373), nhel, den(944))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,495), A(:,1374), n3(:,2076), t3x64(:,:,1374), nhel, den(945))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,496), A(:,1375), n3(:,2077), t3x64(:,:,1375), nhel, den(946))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,496), A(:,1376), n3(:,2078), t3x64(:,:,1376), nhel, den(947))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,349), A(:,1377), n3(:,2079), t3x64(:,:,1377), nhel, den(948))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,349), A(:,1378), n3(:,2080), t3x64(:,:,1378), nhel, den(949))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,350), A(:,1379), n3(:,2081), t3x64(:,:,1379), nhel, den(950))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,350), A(:,1380), n3(:,2082), t3x64(:,:,1380), nhel, den(951))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,351), A(:,1381), n3(:,2083), t3x64(:,:,1381), nhel, den(950))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,351), A(:,1382), n3(:,2084), t3x64(:,:,1382), nhel, den(951))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,352), A(:,1383), n3(:,2085), t3x64(:,:,1383), nhel, den(952))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,352), A(:,1384), n3(:,2086), t3x64(:,:,1384), nhel, den(953))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,469), A(:,1385), n3(:,2087), t3x64(:,:,1385), nhel, den(954))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,469), A(:,1386), n3(:,2088), t3x64(:,:,1386), nhel, den(955))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,470), A(:,1387), n3(:,2089), t3x64(:,:,1387), nhel, den(956))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,470), A(:,1388), n3(:,2090), t3x64(:,:,1388), nhel, den(957))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,355), A(:,1389), n3(:,2091), t3x64(:,:,1389), nhel, den(958))
    call Hcont_QA(nsync, wf8(:,199), wf8(:,356), A(:,1390), n3(:,2092), t3x64(:,:,1390), nhel, den(959))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,355), A(:,1391), n3(:,2093), t3x64(:,:,1391), nhel, den(960))
    call Hcont_QA(nsync, wf8(:,200), wf8(:,356), A(:,1392), n3(:,2094), t3x64(:,:,1392), nhel, den(961))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,501), A(:,1393), n3(:,2095), t3x64(:,:,1393), nhel, den(962))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,501), A(:,1394), n3(:,2096), t3x64(:,:,1394), nhel, den(963))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,502), A(:,1395), n3(:,2097), t3x64(:,:,1395), nhel, den(964))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,502), A(:,1396), n3(:,2098), t3x64(:,:,1396), nhel, den(965))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,503), A(:,1397), n3(:,2099), t3x64(:,:,1397), nhel, den(964))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,503), A(:,1398), n3(:,2100), t3x64(:,:,1398), nhel, den(965))
    call Hcont_QA(nsync, wf8(:,89), wf8(:,504), A(:,1399), n3(:,2101), t3x64(:,:,1399), nhel, den(966))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,504), A(:,1400), n3(:,2102), t3x64(:,:,1400), nhel, den(967))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,475), A(:,1401), n3(:,2103), t3x64(:,:,1401), nhel, den(968))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,475), A(:,1402), n3(:,2104), t3x64(:,:,1402), nhel, den(969))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,476), A(:,1403), n3(:,2105), t3x64(:,:,1403), nhel, den(970))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,476), A(:,1404), n3(:,2106), t3x64(:,:,1404), nhel, den(971))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,477), A(:,1405), n3(:,2107), t3x64(:,:,1405), nhel, den(970))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,477), A(:,1406), n3(:,2108), t3x64(:,:,1406), nhel, den(971))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,478), A(:,1407), n3(:,2109), t3x64(:,:,1407), nhel, den(972))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,478), A(:,1408), n3(:,2110), t3x64(:,:,1408), nhel, den(973))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,409), A(:,1409), n3(:,2111), t3x64(:,:,1409), nhel, den(974))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,409), A(:,1410), n3(:,2112), t3x64(:,:,1410), nhel, den(975))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,410), A(:,1411), n3(:,2113), t3x64(:,:,1411), nhel, den(976))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,410), A(:,1412), n3(:,2114), t3x64(:,:,1412), nhel, den(977))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,411), A(:,1413), n3(:,2115), t3x64(:,:,1413), nhel, den(976))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,411), A(:,1414), n3(:,2116), t3x64(:,:,1414), nhel, den(977))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,412), A(:,1415), n3(:,2117), t3x64(:,:,1415), nhel, den(978))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,412), A(:,1416), n3(:,2118), t3x64(:,:,1416), nhel, den(979))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,479), A(:,1417), n3(:,2119), t3x64(:,:,1417), nhel, den(980))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,479), A(:,1418), n3(:,2120), t3x64(:,:,1418), nhel, den(981))
    call Hcont_QA(nsync, wf8(:,261), wf8(:,480), A(:,1419), n3(:,2121), t3x64(:,:,1419), nhel, den(982))
    call Hcont_QA(nsync, wf8(:,262), wf8(:,480), A(:,1420), n3(:,2122), t3x64(:,:,1420), nhel, den(983))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,415), A(:,1421), n3(:,2123), t3x64(:,:,1421), nhel, den(984))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,415), A(:,1422), n3(:,2124), t3x64(:,:,1422), nhel, den(985))
    call Hcont_QA(nsync, wf8(:,195), wf8(:,416), A(:,1423), n3(:,2125), t3x64(:,:,1423), nhel, den(986))
    call Hcont_QA(nsync, wf8(:,196), wf8(:,416), A(:,1424), n3(:,2126), t3x64(:,:,1424), nhel, den(987))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,485), A(:,1425), n3(:,2127), t3x64(:,:,1425), nhel, den(988))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,485), A(:,1426), n3(:,2128), t3x64(:,:,1426), nhel, den(989))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,486), A(:,1427), n3(:,2129), t3x64(:,:,1427), nhel, den(990))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,486), A(:,1428), n3(:,2130), t3x64(:,:,1428), nhel, den(991))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,487), A(:,1429), n3(:,2131), t3x64(:,:,1429), nhel, den(990))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,487), A(:,1430), n3(:,2132), t3x64(:,:,1430), nhel, den(991))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,488), A(:,1431), n3(:,2133), t3x64(:,:,1431), nhel, den(992))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,488), A(:,1432), n3(:,2134), t3x64(:,:,1432), nhel, den(993))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,501), A(:,1433), n3(:,2135), t3x64(:,:,1433), nhel, den(994))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,501), A(:,1434), n3(:,2136), t3x64(:,:,1434), nhel, den(995))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,502), A(:,1435), n3(:,2137), t3x64(:,:,1435), nhel, den(996))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,502), A(:,1436), n3(:,2138), t3x64(:,:,1436), nhel, den(997))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,503), A(:,1437), n3(:,2139), t3x64(:,:,1437), nhel, den(996))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,503), A(:,1438), n3(:,2140), t3x64(:,:,1438), nhel, den(997))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,504), A(:,1439), n3(:,2141), t3x64(:,:,1439), nhel, den(998))
    call Hcont_QA(nsync, wf8(:,96), wf8(:,504), A(:,1440), n3(:,2142), t3x64(:,:,1440), nhel, den(999))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,1)%j-A(j,2)%j-A(j,3)%j-A(j,4)%j-A(j,5)%j-A(j,6)%j-A(j,7)%j-A(j,8)%j+A(j,9)%j+A(j,10)%j+A(j,11)%j+A(j,12)%j &
       +A(j,13)%j+A(j,14)%j+A(j,15)%j+A(j,16)%j+A(j,17)%j+A(j,18)%j+A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,22)%j+A(j,23)%j+A(j,24)%j &
       -A(j,25)%j-A(j,26)%j-A(j,27)%j-A(j,28)%j-A(j,29)%j-A(j,30)%j-A(j,31)%j-A(j,32)%j+A(j,33)%j+A(j,34)%j+A(j,35)%j+A(j,36)%j &
       +A(j,37)%j+A(j,38)%j+A(j,39)%j+A(j,40)%j-A(j,41)%j-A(j,42)%j-A(j,43)%j-A(j,44)%j-A(j,45)%j-A(j,46)%j-A(j,47)%j-A(j,48)%j &
       -A(j,49)%j-A(j,50)%j-A(j,51)%j-A(j,52)%j-A(j,53)%j-A(j,54)%j-A(j,55)%j-A(j,56)%j+A(j,57)%j+A(j,58)%j+A(j,59)%j+A(j,60)%j &
       +A(j,61)%j+A(j,62)%j+A(j,63)%j+A(j,64)%j-A(j,65)%j-A(j,66)%j-A(j,67)%j-A(j,68)%j-A(j,69)%j-A(j,70)%j-A(j,71)%j-A(j,72)%j &
       +A(j,73)%j+A(j,74)%j+A(j,75)%j+A(j,76)%j+A(j,77)%j+A(j,78)%j+A(j,79)%j+A(j,80)%j+A(j,81)%j+A(j,82)%j+A(j,83)%j+A(j,84)%j &
       +A(j,85)%j+A(j,86)%j+A(j,87)%j+A(j,88)%j-A(j,89)%j-A(j,90)%j-A(j,91)%j-A(j,92)%j-A(j,93)%j-A(j,94)%j-A(j,95)%j-A(j,96)%j &
       -A(j,97)%j-A(j,98)%j-A(j,99)%j-A(j,100)%j-A(j,101)%j-A(j,102)%j-A(j,103)%j-A(j,104)%j+A(j,105)%j+A(j,106)%j+A(j,107)%j &
       +A(j,108)%j+A(j,109)%j+A(j,110)%j+A(j,111)%j+A(j,112)%j+A(j,113)%j+A(j,114)%j+A(j,115)%j+A(j,116)%j+A(j,117)%j+A(j,118)%j &
       +A(j,119)%j+A(j,120)%j-A(j,121)%j-A(j,122)%j-A(j,123)%j-A(j,124)%j-A(j,125)%j-A(j,126)%j-A(j,127)%j-A(j,128)%j-A(j,129)%j &
       -A(j,130)%j-A(j,131)%j-A(j,132)%j-A(j,133)%j-A(j,134)%j-A(j,135)%j-A(j,136)%j+A(j,137)%j+A(j,138)%j+A(j,139)%j+A(j,140)%j &
       +A(j,141)%j+A(j,142)%j+A(j,143)%j+A(j,144)%j)*f(1)

  M2(1)%j = (-A(j,145)%j-A(j,146)%j-A(j,147)%j-A(j,148)%j-A(j,149)%j-A(j,150)%j-A(j,151)%j-A(j,152)%j+A(j,153)%j+A(j,154)%j &
       +A(j,155)%j+A(j,156)%j+A(j,157)%j+A(j,158)%j+A(j,159)%j+A(j,160)%j+A(j,161)%j+A(j,162)%j+A(j,163)%j+A(j,164)%j+A(j,165)%j &
       +A(j,166)%j+A(j,167)%j+A(j,168)%j-A(j,169)%j-A(j,170)%j-A(j,171)%j-A(j,172)%j-A(j,173)%j-A(j,174)%j-A(j,175)%j-A(j,176)%j &
       +A(j,177)%j+A(j,178)%j+A(j,179)%j+A(j,180)%j+A(j,181)%j+A(j,182)%j+A(j,183)%j+A(j,184)%j-A(j,185)%j-A(j,186)%j-A(j,187)%j &
       -A(j,188)%j-A(j,189)%j-A(j,190)%j-A(j,191)%j-A(j,192)%j-A(j,193)%j-A(j,194)%j-A(j,195)%j-A(j,196)%j-A(j,197)%j-A(j,198)%j &
       -A(j,199)%j-A(j,200)%j+A(j,201)%j+A(j,202)%j+A(j,203)%j+A(j,204)%j+A(j,205)%j+A(j,206)%j+A(j,207)%j+A(j,208)%j-A(j,209)%j &
       -A(j,210)%j-A(j,211)%j-A(j,212)%j-A(j,213)%j-A(j,214)%j-A(j,215)%j-A(j,216)%j+A(j,217)%j+A(j,218)%j+A(j,219)%j+A(j,220)%j &
       +A(j,221)%j+A(j,222)%j+A(j,223)%j+A(j,224)%j+A(j,225)%j+A(j,226)%j+A(j,227)%j+A(j,228)%j+A(j,229)%j+A(j,230)%j+A(j,231)%j &
       +A(j,232)%j-A(j,233)%j-A(j,234)%j-A(j,235)%j-A(j,236)%j-A(j,237)%j-A(j,238)%j-A(j,239)%j-A(j,240)%j-A(j,241)%j-A(j,242)%j &
       -A(j,243)%j-A(j,244)%j-A(j,245)%j-A(j,246)%j-A(j,247)%j-A(j,248)%j+A(j,249)%j+A(j,250)%j+A(j,251)%j+A(j,252)%j+A(j,253)%j &
       +A(j,254)%j+A(j,255)%j+A(j,256)%j+A(j,257)%j+A(j,258)%j+A(j,259)%j+A(j,260)%j+A(j,261)%j+A(j,262)%j+A(j,263)%j+A(j,264)%j &
       -A(j,265)%j-A(j,266)%j-A(j,267)%j-A(j,268)%j-A(j,269)%j-A(j,270)%j-A(j,271)%j-A(j,272)%j-A(j,273)%j-A(j,274)%j-A(j,275)%j &
       -A(j,276)%j-A(j,277)%j-A(j,278)%j-A(j,279)%j-A(j,280)%j+A(j,281)%j+A(j,282)%j+A(j,283)%j+A(j,284)%j+A(j,285)%j+A(j,286)%j &
       +A(j,287)%j+A(j,288)%j-A(j,289)%j-A(j,290)%j-A(j,291)%j-A(j,292)%j-A(j,293)%j-A(j,294)%j-A(j,295)%j-A(j,296)%j+A(j,297)%j &
       +A(j,298)%j+A(j,299)%j+A(j,300)%j+A(j,301)%j+A(j,302)%j+A(j,303)%j+A(j,304)%j-A(j,305)%j-A(j,306)%j-A(j,307)%j-A(j,308)%j &
       -A(j,309)%j-A(j,310)%j-A(j,311)%j-A(j,312)%j+A(j,313)%j+A(j,314)%j+A(j,315)%j+A(j,316)%j+A(j,317)%j+A(j,318)%j+A(j,319)%j &
       +A(j,320)%j+A(j,321)%j+A(j,322)%j+A(j,323)%j+A(j,324)%j+A(j,325)%j+A(j,326)%j+A(j,327)%j+A(j,328)%j-A(j,329)%j-A(j,330)%j &
       -A(j,331)%j-A(j,332)%j-A(j,333)%j-A(j,334)%j-A(j,335)%j-A(j,336)%j+A(j,337)%j+A(j,338)%j+A(j,339)%j+A(j,340)%j+A(j,341)%j &
       +A(j,342)%j+A(j,343)%j+A(j,344)%j-A(j,345)%j-A(j,346)%j-A(j,347)%j-A(j,348)%j-A(j,349)%j-A(j,350)%j-A(j,351)%j-A(j,352)%j &
       -A(j,353)%j-A(j,354)%j-A(j,355)%j-A(j,356)%j-A(j,357)%j-A(j,358)%j-A(j,359)%j-A(j,360)%j+A(j,361)%j+A(j,362)%j+A(j,363)%j &
       +A(j,364)%j+A(j,365)%j+A(j,366)%j+A(j,367)%j+A(j,368)%j+A(j,369)%j+A(j,370)%j+A(j,371)%j+A(j,372)%j+A(j,373)%j+A(j,374)%j &
       +A(j,375)%j+A(j,376)%j-A(j,377)%j-A(j,378)%j-A(j,379)%j-A(j,380)%j-A(j,381)%j-A(j,382)%j-A(j,383)%j-A(j,384)%j-A(j,385)%j &
       -A(j,386)%j-A(j,387)%j-A(j,388)%j-A(j,389)%j-A(j,390)%j-A(j,391)%j-A(j,392)%j+A(j,393)%j+A(j,394)%j+A(j,395)%j+A(j,396)%j &
       +A(j,397)%j+A(j,398)%j+A(j,399)%j+A(j,400)%j-A(j,401)%j-A(j,402)%j-A(j,403)%j-A(j,404)%j-A(j,405)%j-A(j,406)%j-A(j,407)%j &
       -A(j,408)%j+A(j,409)%j+A(j,410)%j+A(j,411)%j+A(j,412)%j+A(j,413)%j+A(j,414)%j+A(j,415)%j+A(j,416)%j+A(j,417)%j+A(j,418)%j &
       +A(j,419)%j+A(j,420)%j+A(j,421)%j+A(j,422)%j+A(j,423)%j+A(j,424)%j-A(j,425)%j-A(j,426)%j-A(j,427)%j-A(j,428)%j-A(j,429)%j &
       -A(j,430)%j-A(j,431)%j-A(j,432)%j+A(j,433)%j+A(j,434)%j+A(j,435)%j+A(j,436)%j+A(j,437)%j+A(j,438)%j+A(j,439)%j+A(j,440)%j &
       -A(j,441)%j-A(j,442)%j-A(j,443)%j-A(j,444)%j-A(j,445)%j-A(j,446)%j-A(j,447)%j-A(j,448)%j+A(j,449)%j+A(j,450)%j+A(j,451)%j &
       +A(j,452)%j+A(j,453)%j+A(j,454)%j+A(j,455)%j+A(j,456)%j-A(j,457)%j-A(j,458)%j-A(j,459)%j-A(j,460)%j-A(j,461)%j-A(j,462)%j &
       -A(j,463)%j-A(j,464)%j-A(j,465)%j-A(j,466)%j-A(j,467)%j-A(j,468)%j-A(j,469)%j-A(j,470)%j-A(j,471)%j-A(j,472)%j+A(j,473)%j &
       +A(j,474)%j+A(j,475)%j+A(j,476)%j+A(j,477)%j+A(j,478)%j+A(j,479)%j+A(j,480)%j-A(j,481)%j-A(j,482)%j-A(j,483)%j-A(j,484)%j &
       -A(j,485)%j-A(j,486)%j-A(j,487)%j-A(j,488)%j+A(j,489)%j+A(j,490)%j+A(j,491)%j+A(j,492)%j+A(j,493)%j+A(j,494)%j+A(j,495)%j &
       +A(j,496)%j+A(j,497)%j+A(j,498)%j+A(j,499)%j+A(j,500)%j+A(j,501)%j+A(j,502)%j+A(j,503)%j+A(j,504)%j-A(j,505)%j-A(j,506)%j &
       -A(j,507)%j-A(j,508)%j-A(j,509)%j-A(j,510)%j-A(j,511)%j-A(j,512)%j-A(j,513)%j-A(j,514)%j-A(j,515)%j-A(j,516)%j-A(j,517)%j &
       -A(j,518)%j-A(j,519)%j-A(j,520)%j+A(j,521)%j+A(j,522)%j+A(j,523)%j+A(j,524)%j+A(j,525)%j+A(j,526)%j+A(j,527)%j+A(j,528)%j &
       +A(j,529)%j+A(j,530)%j+A(j,531)%j+A(j,532)%j+A(j,533)%j+A(j,534)%j+A(j,535)%j+A(j,536)%j-A(j,537)%j-A(j,538)%j-A(j,539)%j &
       -A(j,540)%j-A(j,541)%j-A(j,542)%j-A(j,543)%j-A(j,544)%j+A(j,545)%j+A(j,546)%j+A(j,547)%j+A(j,548)%j+A(j,549)%j+A(j,550)%j &
       +A(j,551)%j+A(j,552)%j-A(j,553)%j-A(j,554)%j-A(j,555)%j-A(j,556)%j-A(j,557)%j-A(j,558)%j-A(j,559)%j-A(j,560)%j-A(j,561)%j &
       -A(j,562)%j-A(j,563)%j-A(j,564)%j-A(j,565)%j-A(j,566)%j-A(j,567)%j-A(j,568)%j+A(j,569)%j+A(j,570)%j+A(j,571)%j+A(j,572)%j &
       +A(j,573)%j+A(j,574)%j+A(j,575)%j+A(j,576)%j-A(j,577)%j-A(j,578)%j-A(j,579)%j-A(j,580)%j-A(j,581)%j-A(j,582)%j-A(j,583)%j &
       -A(j,584)%j+A(j,585)%j+A(j,586)%j+A(j,587)%j+A(j,588)%j+A(j,589)%j+A(j,590)%j+A(j,591)%j+A(j,592)%j-A(j,593)%j-A(j,594)%j &
       -A(j,595)%j-A(j,596)%j-A(j,597)%j-A(j,598)%j-A(j,599)%j-A(j,600)%j+A(j,601)%j+A(j,602)%j+A(j,603)%j+A(j,604)%j+A(j,605)%j &
       +A(j,606)%j+A(j,607)%j+A(j,608)%j+A(j,609)%j+A(j,610)%j+A(j,611)%j+A(j,612)%j+A(j,613)%j+A(j,614)%j+A(j,615)%j+A(j,616)%j &
       -A(j,617)%j-A(j,618)%j-A(j,619)%j-A(j,620)%j-A(j,621)%j-A(j,622)%j-A(j,623)%j-A(j,624)%j+A(j,625)%j+A(j,626)%j+A(j,627)%j &
       +A(j,628)%j+A(j,629)%j+A(j,630)%j+A(j,631)%j+A(j,632)%j-A(j,633)%j-A(j,634)%j-A(j,635)%j-A(j,636)%j-A(j,637)%j-A(j,638)%j &
       -A(j,639)%j-A(j,640)%j-A(j,641)%j-A(j,642)%j-A(j,643)%j-A(j,644)%j-A(j,645)%j-A(j,646)%j-A(j,647)%j-A(j,648)%j+A(j,649)%j &
       +A(j,650)%j+A(j,651)%j+A(j,652)%j+A(j,653)%j+A(j,654)%j+A(j,655)%j+A(j,656)%j+A(j,657)%j+A(j,658)%j+A(j,659)%j+A(j,660)%j &
       +A(j,661)%j+A(j,662)%j+A(j,663)%j+A(j,664)%j-A(j,665)%j-A(j,666)%j-A(j,667)%j-A(j,668)%j-A(j,669)%j-A(j,670)%j-A(j,671)%j &
       -A(j,672)%j-A(j,673)%j-A(j,674)%j-A(j,675)%j-A(j,676)%j-A(j,677)%j-A(j,678)%j-A(j,679)%j-A(j,680)%j+A(j,681)%j+A(j,682)%j &
       +A(j,683)%j+A(j,684)%j+A(j,685)%j+A(j,686)%j+A(j,687)%j+A(j,688)%j-A(j,689)%j-A(j,690)%j-A(j,691)%j-A(j,692)%j-A(j,693)%j &
       -A(j,694)%j-A(j,695)%j-A(j,696)%j+A(j,697)%j+A(j,698)%j+A(j,699)%j+A(j,700)%j+A(j,701)%j+A(j,702)%j+A(j,703)%j+A(j,704)%j &
       +A(j,705)%j+A(j,706)%j+A(j,707)%j+A(j,708)%j+A(j,709)%j+A(j,710)%j+A(j,711)%j+A(j,712)%j-A(j,713)%j-A(j,714)%j-A(j,715)%j &
       -A(j,716)%j-A(j,717)%j-A(j,718)%j-A(j,719)%j-A(j,720)%j+A(j,721)%j+A(j,722)%j+A(j,723)%j+A(j,724)%j+A(j,725)%j+A(j,726)%j &
       +A(j,727)%j+A(j,728)%j+A(j,729)%j+A(j,730)%j+A(j,731)%j+A(j,732)%j+A(j,733)%j+A(j,734)%j+A(j,735)%j+A(j,736)%j+A(j,737)%j &
       +A(j,738)%j+A(j,739)%j+A(j,740)%j+A(j,741)%j+A(j,742)%j+A(j,743)%j+A(j,744)%j+A(j,745)%j+A(j,746)%j+A(j,747)%j+A(j,748)%j &
       +A(j,749)%j+A(j,750)%j+A(j,751)%j+A(j,752)%j+A(j,753)%j+A(j,754)%j+A(j,755)%j+A(j,756)%j+A(j,757)%j+A(j,758)%j+A(j,759)%j &
       +A(j,760)%j-A(j,761)%j-A(j,762)%j-A(j,763)%j-A(j,764)%j-A(j,765)%j-A(j,766)%j-A(j,767)%j-A(j,768)%j-A(j,769)%j-A(j,770)%j &
       -A(j,771)%j-A(j,772)%j-A(j,773)%j-A(j,774)%j-A(j,775)%j-A(j,776)%j-A(j,777)%j-A(j,778)%j-A(j,779)%j-A(j,780)%j-A(j,781)%j &
       -A(j,782)%j-A(j,783)%j-A(j,784)%j-A(j,785)%j-A(j,786)%j-A(j,787)%j-A(j,788)%j-A(j,789)%j-A(j,790)%j-A(j,791)%j-A(j,792)%j &
       -A(j,793)%j-A(j,794)%j-A(j,795)%j-A(j,796)%j-A(j,797)%j-A(j,798)%j-A(j,799)%j-A(j,800)%j-A(j,801)%j-A(j,802)%j-A(j,803)%j &
       -A(j,804)%j-A(j,805)%j-A(j,806)%j-A(j,807)%j-A(j,808)%j-A(j,809)%j-A(j,810)%j-A(j,811)%j-A(j,812)%j-A(j,813)%j-A(j,814)%j &
       -A(j,815)%j-A(j,816)%j-A(j,817)%j-A(j,818)%j-A(j,819)%j-A(j,820)%j-A(j,821)%j-A(j,822)%j-A(j,823)%j-A(j,824)%j-A(j,825)%j &
       -A(j,826)%j-A(j,827)%j-A(j,828)%j-A(j,829)%j-A(j,830)%j-A(j,831)%j-A(j,832)%j-A(j,833)%j-A(j,834)%j-A(j,835)%j-A(j,836)%j &
       -A(j,837)%j-A(j,838)%j-A(j,839)%j-A(j,840)%j+A(j,841)%j+A(j,842)%j+A(j,843)%j+A(j,844)%j+A(j,845)%j+A(j,846)%j+A(j,847)%j &
       +A(j,848)%j+A(j,849)%j+A(j,850)%j+A(j,851)%j+A(j,852)%j+A(j,853)%j+A(j,854)%j+A(j,855)%j+A(j,856)%j+A(j,857)%j+A(j,858)%j &
       +A(j,859)%j+A(j,860)%j+A(j,861)%j+A(j,862)%j+A(j,863)%j+A(j,864)%j+A(j,865)%j+A(j,866)%j+A(j,867)%j+A(j,868)%j+A(j,869)%j &
       +A(j,870)%j+A(j,871)%j+A(j,872)%j+A(j,873)%j+A(j,874)%j+A(j,875)%j+A(j,876)%j+A(j,877)%j+A(j,878)%j+A(j,879)%j+A(j,880)%j &
       -A(j,881)%j-A(j,882)%j-A(j,883)%j-A(j,884)%j-A(j,885)%j-A(j,886)%j-A(j,887)%j-A(j,888)%j-A(j,889)%j-A(j,890)%j-A(j,891)%j &
       -A(j,892)%j-A(j,893)%j-A(j,894)%j-A(j,895)%j-A(j,896)%j-A(j,897)%j-A(j,898)%j-A(j,899)%j-A(j,900)%j-A(j,901)%j-A(j,902)%j &
       -A(j,903)%j-A(j,904)%j-A(j,905)%j-A(j,906)%j-A(j,907)%j-A(j,908)%j-A(j,909)%j-A(j,910)%j-A(j,911)%j-A(j,912)%j-A(j,913)%j &
       -A(j,914)%j-A(j,915)%j-A(j,916)%j-A(j,917)%j-A(j,918)%j-A(j,919)%j-A(j,920)%j+A(j,921)%j+A(j,922)%j+A(j,923)%j+A(j,924)%j &
       +A(j,925)%j+A(j,926)%j+A(j,927)%j+A(j,928)%j+A(j,929)%j+A(j,930)%j+A(j,931)%j+A(j,932)%j+A(j,933)%j+A(j,934)%j+A(j,935)%j &
       +A(j,936)%j+A(j,937)%j+A(j,938)%j+A(j,939)%j+A(j,940)%j+A(j,941)%j+A(j,942)%j+A(j,943)%j+A(j,944)%j+A(j,945)%j+A(j,946)%j &
       +A(j,947)%j+A(j,948)%j+A(j,949)%j+A(j,950)%j+A(j,951)%j+A(j,952)%j+A(j,953)%j+A(j,954)%j+A(j,955)%j+A(j,956)%j+A(j,957)%j &
       +A(j,958)%j+A(j,959)%j+A(j,960)%j+A(j,961)%j+A(j,962)%j+A(j,963)%j+A(j,964)%j+A(j,965)%j+A(j,966)%j+A(j,967)%j+A(j,968)%j &
       +A(j,969)%j+A(j,970)%j+A(j,971)%j+A(j,972)%j+A(j,973)%j+A(j,974)%j+A(j,975)%j+A(j,976)%j+A(j,977)%j+A(j,978)%j+A(j,979)%j &
       +A(j,980)%j+A(j,981)%j+A(j,982)%j+A(j,983)%j+A(j,984)%j+A(j,985)%j+A(j,986)%j+A(j,987)%j+A(j,988)%j+A(j,989)%j+A(j,990)%j &
       +A(j,991)%j+A(j,992)%j+A(j,993)%j+A(j,994)%j+A(j,995)%j+A(j,996)%j+A(j,997)%j+A(j,998)%j+A(j,999)%j+A(j,1000)%j-A(j,1001)%j &
       -A(j,1002)%j-A(j,1003)%j-A(j,1004)%j-A(j,1005)%j-A(j,1006)%j-A(j,1007)%j-A(j,1008)%j-A(j,1009)%j-A(j,1010)%j-A(j,1011)%j &
       -A(j,1012)%j-A(j,1013)%j-A(j,1014)%j-A(j,1015)%j-A(j,1016)%j-A(j,1017)%j-A(j,1018)%j-A(j,1019)%j-A(j,1020)%j-A(j,1021)%j &
       -A(j,1022)%j-A(j,1023)%j-A(j,1024)%j-A(j,1025)%j-A(j,1026)%j-A(j,1027)%j-A(j,1028)%j-A(j,1029)%j-A(j,1030)%j-A(j,1031)%j &
       -A(j,1032)%j-A(j,1033)%j-A(j,1034)%j-A(j,1035)%j-A(j,1036)%j-A(j,1037)%j-A(j,1038)%j-A(j,1039)%j-A(j,1040)%j+A(j,1041)%j &
       +A(j,1042)%j+A(j,1043)%j+A(j,1044)%j+A(j,1045)%j+A(j,1046)%j+A(j,1047)%j+A(j,1048)%j+A(j,1049)%j+A(j,1050)%j+A(j,1051)%j &
       +A(j,1052)%j+A(j,1053)%j+A(j,1054)%j+A(j,1055)%j+A(j,1056)%j+A(j,1057)%j+A(j,1058)%j+A(j,1059)%j+A(j,1060)%j+A(j,1061)%j &
       +A(j,1062)%j+A(j,1063)%j+A(j,1064)%j+A(j,1065)%j+A(j,1066)%j+A(j,1067)%j+A(j,1068)%j+A(j,1069)%j+A(j,1070)%j+A(j,1071)%j &
       +A(j,1072)%j+A(j,1073)%j+A(j,1074)%j+A(j,1075)%j+A(j,1076)%j+A(j,1077)%j+A(j,1078)%j+A(j,1079)%j+A(j,1080)%j-A(j,1081)%j &
       -A(j,1082)%j-A(j,1083)%j-A(j,1084)%j-A(j,1085)%j-A(j,1086)%j-A(j,1087)%j-A(j,1088)%j-A(j,1089)%j-A(j,1090)%j-A(j,1091)%j &
       -A(j,1092)%j-A(j,1093)%j-A(j,1094)%j-A(j,1095)%j-A(j,1096)%j-A(j,1097)%j-A(j,1098)%j-A(j,1099)%j-A(j,1100)%j-A(j,1101)%j &
       -A(j,1102)%j-A(j,1103)%j-A(j,1104)%j-A(j,1105)%j-A(j,1106)%j-A(j,1107)%j-A(j,1108)%j-A(j,1109)%j-A(j,1110)%j-A(j,1111)%j &
       -A(j,1112)%j-A(j,1113)%j-A(j,1114)%j-A(j,1115)%j-A(j,1116)%j-A(j,1117)%j-A(j,1118)%j-A(j,1119)%j-A(j,1120)%j-A(j,1121)%j &
       -A(j,1122)%j-A(j,1123)%j-A(j,1124)%j-A(j,1125)%j-A(j,1126)%j-A(j,1127)%j-A(j,1128)%j-A(j,1129)%j-A(j,1130)%j-A(j,1131)%j &
       -A(j,1132)%j-A(j,1133)%j-A(j,1134)%j-A(j,1135)%j-A(j,1136)%j-A(j,1137)%j-A(j,1138)%j-A(j,1139)%j-A(j,1140)%j-A(j,1141)%j &
       -A(j,1142)%j-A(j,1143)%j-A(j,1144)%j-A(j,1145)%j-A(j,1146)%j-A(j,1147)%j-A(j,1148)%j-A(j,1149)%j-A(j,1150)%j-A(j,1151)%j &
       -A(j,1152)%j-A(j,1153)%j-A(j,1154)%j-A(j,1155)%j-A(j,1156)%j-A(j,1157)%j-A(j,1158)%j-A(j,1159)%j-A(j,1160)%j+A(j,1161)%j &
       +A(j,1162)%j+A(j,1163)%j+A(j,1164)%j+A(j,1165)%j+A(j,1166)%j+A(j,1167)%j+A(j,1168)%j+A(j,1169)%j+A(j,1170)%j+A(j,1171)%j &
       +A(j,1172)%j+A(j,1173)%j+A(j,1174)%j+A(j,1175)%j+A(j,1176)%j+A(j,1177)%j+A(j,1178)%j+A(j,1179)%j+A(j,1180)%j+A(j,1181)%j &
       +A(j,1182)%j+A(j,1183)%j+A(j,1184)%j+A(j,1185)%j+A(j,1186)%j+A(j,1187)%j+A(j,1188)%j+A(j,1189)%j+A(j,1190)%j+A(j,1191)%j &
       +A(j,1192)%j+A(j,1193)%j+A(j,1194)%j+A(j,1195)%j+A(j,1196)%j+A(j,1197)%j+A(j,1198)%j+A(j,1199)%j+A(j,1200)%j+A(j,1201)%j &
       +A(j,1202)%j+A(j,1203)%j+A(j,1204)%j+A(j,1205)%j+A(j,1206)%j+A(j,1207)%j+A(j,1208)%j+A(j,1209)%j+A(j,1210)%j+A(j,1211)%j &
       +A(j,1212)%j+A(j,1213)%j+A(j,1214)%j+A(j,1215)%j+A(j,1216)%j+A(j,1217)%j+A(j,1218)%j+A(j,1219)%j+A(j,1220)%j+A(j,1221)%j &
       +A(j,1222)%j+A(j,1223)%j+A(j,1224)%j+A(j,1225)%j+A(j,1226)%j+A(j,1227)%j+A(j,1228)%j+A(j,1229)%j+A(j,1230)%j+A(j,1231)%j &
       +A(j,1232)%j+A(j,1233)%j+A(j,1234)%j+A(j,1235)%j+A(j,1236)%j+A(j,1237)%j+A(j,1238)%j+A(j,1239)%j+A(j,1240)%j-A(j,1241)%j &
       -A(j,1242)%j-A(j,1243)%j-A(j,1244)%j-A(j,1245)%j-A(j,1246)%j-A(j,1247)%j-A(j,1248)%j-A(j,1249)%j-A(j,1250)%j-A(j,1251)%j &
       -A(j,1252)%j-A(j,1253)%j-A(j,1254)%j-A(j,1255)%j-A(j,1256)%j-A(j,1257)%j-A(j,1258)%j-A(j,1259)%j-A(j,1260)%j-A(j,1261)%j &
       -A(j,1262)%j-A(j,1263)%j-A(j,1264)%j-A(j,1265)%j-A(j,1266)%j-A(j,1267)%j-A(j,1268)%j-A(j,1269)%j-A(j,1270)%j-A(j,1271)%j &
       -A(j,1272)%j-A(j,1273)%j-A(j,1274)%j-A(j,1275)%j-A(j,1276)%j-A(j,1277)%j-A(j,1278)%j-A(j,1279)%j-A(j,1280)%j-A(j,1281)%j &
       -A(j,1282)%j-A(j,1283)%j-A(j,1284)%j-A(j,1285)%j-A(j,1286)%j-A(j,1287)%j-A(j,1288)%j-A(j,1289)%j-A(j,1290)%j-A(j,1291)%j &
       -A(j,1292)%j-A(j,1293)%j-A(j,1294)%j-A(j,1295)%j-A(j,1296)%j-A(j,1297)%j-A(j,1298)%j-A(j,1299)%j-A(j,1300)%j-A(j,1301)%j &
       -A(j,1302)%j-A(j,1303)%j-A(j,1304)%j-A(j,1305)%j-A(j,1306)%j-A(j,1307)%j-A(j,1308)%j-A(j,1309)%j-A(j,1310)%j-A(j,1311)%j &
       -A(j,1312)%j-A(j,1313)%j-A(j,1314)%j-A(j,1315)%j-A(j,1316)%j-A(j,1317)%j-A(j,1318)%j-A(j,1319)%j-A(j,1320)%j+A(j,1321)%j &
       +A(j,1322)%j+A(j,1323)%j+A(j,1324)%j+A(j,1325)%j+A(j,1326)%j+A(j,1327)%j+A(j,1328)%j+A(j,1329)%j+A(j,1330)%j+A(j,1331)%j &
       +A(j,1332)%j+A(j,1333)%j+A(j,1334)%j+A(j,1335)%j+A(j,1336)%j+A(j,1337)%j+A(j,1338)%j+A(j,1339)%j+A(j,1340)%j+A(j,1341)%j &
       +A(j,1342)%j+A(j,1343)%j+A(j,1344)%j+A(j,1345)%j+A(j,1346)%j+A(j,1347)%j+A(j,1348)%j+A(j,1349)%j+A(j,1350)%j+A(j,1351)%j &
       +A(j,1352)%j+A(j,1353)%j+A(j,1354)%j+A(j,1355)%j+A(j,1356)%j+A(j,1357)%j+A(j,1358)%j+A(j,1359)%j+A(j,1360)%j+A(j,1361)%j &
       +A(j,1362)%j+A(j,1363)%j+A(j,1364)%j+A(j,1365)%j+A(j,1366)%j+A(j,1367)%j+A(j,1368)%j+A(j,1369)%j+A(j,1370)%j+A(j,1371)%j &
       +A(j,1372)%j+A(j,1373)%j+A(j,1374)%j+A(j,1375)%j+A(j,1376)%j+A(j,1377)%j+A(j,1378)%j+A(j,1379)%j+A(j,1380)%j+A(j,1381)%j &
       +A(j,1382)%j+A(j,1383)%j+A(j,1384)%j+A(j,1385)%j+A(j,1386)%j+A(j,1387)%j+A(j,1388)%j+A(j,1389)%j+A(j,1390)%j+A(j,1391)%j &
       +A(j,1392)%j+A(j,1393)%j+A(j,1394)%j+A(j,1395)%j+A(j,1396)%j+A(j,1397)%j+A(j,1398)%j+A(j,1399)%j+A(j,1400)%j-A(j,1401)%j &
       -A(j,1402)%j-A(j,1403)%j-A(j,1404)%j-A(j,1405)%j-A(j,1406)%j-A(j,1407)%j-A(j,1408)%j-A(j,1409)%j-A(j,1410)%j-A(j,1411)%j &
       -A(j,1412)%j-A(j,1413)%j-A(j,1414)%j-A(j,1415)%j-A(j,1416)%j-A(j,1417)%j-A(j,1418)%j-A(j,1419)%j-A(j,1420)%j-A(j,1421)%j &
       -A(j,1422)%j-A(j,1423)%j-A(j,1424)%j-A(j,1425)%j-A(j,1426)%j-A(j,1427)%j-A(j,1428)%j-A(j,1429)%j-A(j,1430)%j-A(j,1431)%j &
       -A(j,1432)%j-A(j,1433)%j-A(j,1434)%j-A(j,1435)%j-A(j,1436)%j-A(j,1437)%j-A(j,1438)%j-A(j,1439)%j-A(j,1440)%j)*f(2)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_eellll_ew_eeeexexex_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_eellll_ew_eeeexexex_1_/**/REALKIND
