
module ol_vamp_1_eell_ew_eeexex_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eell_ew_eeexex_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eell_ew_eeexex_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eell_ew_eeexex_2_/**/DREALKIND
  use ol_tensor_sum_storage_eell_ew_eeexex_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_eell_ew_eeexex_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eell_ew_eeexex_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[nME,nMH,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[nME,nMZ,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[nME,0,nME,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[nME,0,nME,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngX,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[nME,0,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[nME,0,nME,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZl,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,2,1,4],[nME,nMZ,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,1,2,4],[nME,nMH,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,1,2,4],[nME,nMZ,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,1,2,4],[nME,0,nME,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,1,2,4],[nME,0,nME,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngX,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,1,2,4],[nME,0,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,1,2,4],[nME,0,nME,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZl,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,1,2,4],[nME,nMZ,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(1),8,nME,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,1,4,2],[nMH,nME,0,nME],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,15),heltab2x16(:,:,15))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,1,4,2],[nMZ,nME,0,nME],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(2),ngX,m3h2x8(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,1,4,2],[0,nME,nMH,nME],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,1,4,2],[0,nME,nMZ,nME],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,18),heltab2x16(:,:,18))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,1,4,2],[nME,nMH,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,1,4,2],[nME,nMZ,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,1,4,2],[nME,0,nME,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngH,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,1,4,2],[nME,0,nME,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngX,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G0H8(5),8,nME,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,4,2],[0,nME,0,nME],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,23),heltab2x16(:,:,23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,4,2],[0,nME,nMZ,nME],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,24),heltab2x16(:,:,24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,1,4,2],[nMZ,nME,0,nME],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(7),ngZl,m3h2x8(:,25),heltab2x16(:,:,25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,1,4,2],[nME,0,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(8),8,nME,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,1,4,2],[nME,0,nME,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(8),ngZl,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(8),8,nME,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,1,4,2],[nME,nMZ,nME,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(8),8,nME,G1H8(21),n2h8(21))
  call Hloop_AQ_S(ntryL,G1H8(1),ex2(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G1H8(2),ex2(:),G1H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G1H8(3),ex2(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G1H8(4),ex2(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G1H8(5),ex2(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G1H8(6),ex2(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H8(7),ex2(:),G1H4(7),ngZl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_S(ntryL,G1H8(8),ex1(:),G1H4(8),ngH,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_S(ntryL,G1H8(9),ex1(:),G1H4(9),ngX,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G1H8(10),ex1(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntryL,G1H8(11),ex1(:),G1H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_V(ntryL,G1H8(12),ex1(:),G1H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_V(ntryL,G1H8(13),ex1(:),G1H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H8(14),ex1(:),G1H4(14),ngZl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_SQ_A(ntryL,G0H8(1),ex1(:),G0H4(1),ngH,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(15),n2h4(1))
  call Hloop_SQ_A(ntryL,G0H8(2),ex1(:),G0H4(1),ngX,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(16),n2h4(2))
  call Hloop_VQ_A(ntryL,G0H8(3),ex1(:),G0H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(17),n2h4(3))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(18),n2h4(4))
  call Hloop_AQ_S(ntryL,G1H8(15),ex1(:),G1H4(19),ngH,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_S(ntryL,G1H8(16),ex1(:),G1H4(20),ngX,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G1H8(17),ex1(:),G1H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G1H8(18),ex1(:),G1H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(23),n2h4(5))
  call Hloop_VQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(24),n2h4(6))
  call Hloop_ZQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),ngZl,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(25),n2h4(7))
  call Hloop_AQ_V(ntryL,G1H8(19),ex1(:),G1H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_V(ntryL,G1H8(20),ex1(:),G1H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H8(21),ex1(:),G1H4(28),ngZl,m3h2x4(:,28),heltab2x8(:,:,28))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(16)])
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(1),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(2),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(3),n2h2(3))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(4),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(5),ex1(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(5),n2h2(5))
  call Hloop_VQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(6),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex1(:),G1H2(1),ngZl,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(7),n2h2(7))
  call Hloop_SQ_A(ntryL,G1H4(8),ex2(:),G1H2(1),ngH,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(8),n2h2(8))
  call Hloop_SQ_A(ntryL,G1H4(9),ex2(:),G1H2(1),ngX,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(9),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(10),ex2(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(10),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(11),ex2(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(11),n2h2(11))
  call Hloop_VQ_A(ntryL,G1H4(12),ex2(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(12),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(13),n2h2(13))
  call Hloop_ZQ_A(ntryL,G1H4(14),ex2(:),G1H2(1),ngZl,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),11,nME,G2H2(14),n2h2(14))
  call Hloop_QA_V(ntryL,G1H4(15),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G1H4(25),ex3(:),G1H2(2),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_S(ntryL,G1H4(17),ex3(:),G1H2(3),ngH,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_S(ntryL,G1H4(18),ex3(:),G1H2(4),ngX,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_SA_Q(ntryL,G1H4(19),ex3(:),G1H2(5),ngH,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(5),13,nME,G2H2(15),n2h2(15))
  call Hloop_SA_Q(ntryL,G1H4(20),ex3(:),G1H2(5),ngX,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(5),13,nME,G2H2(16),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(21),ex3(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(5),13,nME,G2H2(17),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(22),ex3(:),G1H2(5),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(5),13,nME,G2H2(18),n2h2(18))
  call Hloop_QA_V(ntryL,G1H4(23),ex3(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G1H4(24),ex3(:),G1H2(6),ngZl,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VA_Q(ntryL,G1H4(26),ex3(:),G1H2(7),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(7),13,nME,G2H2(19),n2h2(19))
  call Hloop_VA_Q(ntryL,G1H4(27),ex3(:),G1H2(7),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(7),13,nME,G2H2(20),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(28),ex3(:),G1H2(7),ngZl,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(7),13,nME,G2H2(21),n2h2(21))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(16)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(3),ngH,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(4),ngX,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(6),ngZl,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(9),ngH,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(10),ngX,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(12),ngZl,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_VQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(13),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(14),n2h1(2))
  call Hloop_SQ_A(ntryL,G1H2(3),ex2(:),G1H1(1),ngH,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(15),n2h1(3))
  call Hloop_SQ_A(ntryL,G1H2(4),ex2(:),G1H1(1),ngX,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(16),n2h1(4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex2(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex2(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(19),ngH,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(20),ngX,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hloop_VQ_A(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(21),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex2(:),G1H1(1),ngZl,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(22),n2h1(6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(19),ex2(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(24),ngZl,m3h2x1(:,24),heltab2x2(:,:,24))
  call ol_merge_tensors(G2tensor(6),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(10)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(16)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(20)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(1),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(1),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(2),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(2),mass4set(:,3),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(2),mass4set(:,4),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(2),mass4set(:,5),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(3),mass4set(:,6),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),2)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(3),mass4set(:,7),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),2)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(3),mass4set(:,8),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(3),mass4set(:,9),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(3),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),2)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(3),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),2)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(3),mass4set(:,3),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),2)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(3),mass4set(:,4),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),2)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(3),mass4set(:,10),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(3),mass4set(:,5),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(1),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(2),mass4set(:,2),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,3),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(2),mass4set(:,4),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(2),mass4set(:,5),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(3),mass4set(:,6),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(3),mass4set(:,7),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(3),mass4set(:,8),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(3),mass4set(:,9),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(3),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(3),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(3),mass4set(:,3),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(3),mass4set(:,4),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(3),mass4set(:,10),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(3),mass4set(:,5),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,2,5],[0,nME,nME],3,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,29),heltab2x16(:,:,29))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,2,5],[0,nME,nME],3,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,2,5],[0,nME,nME],3,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,2,5],[0,nME,nME],3,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,32),heltab2x16(:,:,32))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,1,6],[0,nME,nME],3,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,33),heltab2x16(:,:,33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,1,6],[0,nME,nME],3,1,wf4(:,12))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,1,6],[0,nME,nME],3,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,1,6],[0,nME,nME],3,1,wf4(:,16))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[9,2,4],[nME,0,nME],3,1,wf4(:,9))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H4(1),9,nME,G1H4(16),n2h4(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[9,2,4],[nME,0,nME],3,1,wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,11),G0H4(1),ngX,m3h4x4(:,2),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G0H4(1),9,nME,G1H4(1),n2h4(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[9,2,4],[nME,0,nME],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,3),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(1),9,nME,G1H4(2),n2h4(10))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[9,2,4],[nME,0,nME],3,1,wf4(:,15))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,15),G0H4(1),ngZl,m3h4x4(:,4),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G0H4(1),9,nME,G1H4(3),n2h4(11))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[10,1,4],[nME,0,nME],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),ngH,m3h4x4(:,5),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(1),10,nME,G1H4(4),n2h4(12))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[10,1,4],[nME,0,nME],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngX,m3h4x4(:,6),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G0H4(1),10,nME,G1H4(5),n2h4(13))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[10,1,4],[nME,0,nME],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,7),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),10,nME,G1H4(6),n2h4(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[10,1,4],[nME,0,nME],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(1),ngZl,m3h4x4(:,8),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(1),10,nME,G1H4(7),n2h4(15))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(2),G1H4(1),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6),G1H4(5),G1H4(4)])
  call Hloop_VQ_A(ntryL,G0H8(8),ex2(:),G0H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(8),n2h4(16))
  call Hloop_VQ_A(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(9),n2h4(17))
  call Hloop_VQ_A(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(10),n2h4(18))
  call Hloop_VQ_A(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(11),n2h4(19))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(12),n2h4(20))
  call Hloop_VQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(13),n2h4(21))
  call Hloop_VQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(14),n2h4(22))
  call Hloop_VQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G0H4(1),9,nME,G1H4(15),n2h4(23))
  call Hloop_AQ_V(ntryL,G1H4(3),ex2(:),G1H2(7),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_V(ntryL,G1H4(7),ex1(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QS_A(ntryL,G1H4(8),wf4(:,1),G1H1(1),ngH,m3h4x1(:,1),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(4),n2h1(7))
  call Hloop_QS_A(ntryL,G1H4(9),wf4(:,3),G1H1(1),ngX,m3h4x1(:,2),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(10),n2h1(8))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,5),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(16),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,4),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(20),n2h1(10))
  call Hloop_QS_A(ntryL,G1H4(12),wf4(:,10),G1H1(1),ngH,m3h4x1(:,5),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(1),n2h1(11))
  call Hloop_QS_A(ntryL,G1H4(13),wf4(:,12),G1H1(1),ngX,m3h4x1(:,6),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(2),n2h1(12))
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,14),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(3),n2h1(13))
  call Hloop_QZ_A(ntryL,G1H4(15),wf4(:,16),G1H1(1),ngZl,m3h4x1(:,8),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(6),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(5),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nME,G2tensor(7),n2h1(16))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(3),G0tensor(52),G0tensor(3)])
  call ol_merge_tensors(G1tensor(49),[G1tensor(34),G1tensor(29),G1tensor(24),G1tensor(9),G1tensor(4),G0tensor(49),G0tensor(34) &
    ,G0tensor(29),G0tensor(24),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(8),G0tensor(57),G0tensor(8)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(10)])
  call ol_merge_tensors(G1tensor(22),[G1tensor(17),G1tensor(12),G0tensor(22),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(13),G0tensor(62),G0tensor(13)])
  call ol_merge_tensors(G1tensor(39),[G1tensor(14),G0tensor(39),G0tensor(14)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(15)])
  call ol_merge_tensors(G1tensor(67),[G1tensor(18),G0tensor(67),G0tensor(18)])
  call ol_merge_tensors(G1tensor(44),[G1tensor(19),G0tensor(44),G0tensor(19)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(20)])
  call ol_merge_tensors(G1tensor(92),[G1tensor(23),G0tensor(92),G0tensor(23)])
  call ol_merge_tensors(G1tensor(25),[G0tensor(25)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(27)])
  call ol_merge_tensors(G1tensor(28),[G0tensor(28)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(30),G0tensor(75),G0tensor(30)])
  call ol_merge_tensors(G1tensor(32),[G0tensor(32)])
  call ol_merge_tensors(G1tensor(33),[G0tensor(33)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(35),G0tensor(80),G0tensor(35)])
  call ol_merge_tensors(G1tensor(47),[G1tensor(42),G1tensor(37),G0tensor(47),G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G1tensor(38),[G0tensor(38)])
  call ol_merge_tensors(G1tensor(85),[G1tensor(40),G0tensor(85),G0tensor(40)])
  call ol_merge_tensors(G1tensor(43),[G0tensor(43)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(45),G0tensor(90),G0tensor(45)])
  call ol_merge_tensors(G1tensor(48),[G0tensor(48)])
  call ol_merge_tensors(G1tensor(100),[G1tensor(50),G0tensor(100),G0tensor(50)])
  call ol_merge_tensors(G1tensor(93),[G1tensor(58),G1tensor(53),G0tensor(93),G0tensor(58),G0tensor(53)])
  call ol_merge_tensors(G1tensor(54),[G0tensor(54)])
  call ol_merge_tensors(G1tensor(55),[G0tensor(55)])
  call ol_merge_tensors(G1tensor(59),[G0tensor(59)])
  call ol_merge_tensors(G1tensor(60),[G0tensor(60)])
  call ol_merge_tensors(G1tensor(63),[G0tensor(63)])
  call ol_merge_tensors(G1tensor(64),[G0tensor(64)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(3),G2tensor(2),G2tensor(1),G1tensor(95),G1tensor(70),G1tensor(65),G0tensor(95) &
    ,G0tensor(70),G0tensor(65)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(68)])
  call ol_merge_tensors(G1tensor(69),[G0tensor(69)])
  call ol_merge_tensors(G1tensor(72),[G0tensor(72)])
  call ol_merge_tensors(G1tensor(73),[G0tensor(73)])
  call ol_merge_tensors(G1tensor(99),[G1tensor(79),G1tensor(74),G0tensor(99),G0tensor(79),G0tensor(74)])
  call ol_merge_tensors(G1tensor(77),[G0tensor(77)])
  call ol_merge_tensors(G1tensor(78),[G0tensor(78)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(97),G1tensor(87),G1tensor(82),G0tensor(97),G0tensor(87),G0tensor(82)])
  call ol_merge_tensors(G1tensor(83),[G0tensor(83)])
  call ol_merge_tensors(G1tensor(84),[G0tensor(84)])
  call ol_merge_tensors(G1tensor(88),[G0tensor(88)])
  call ol_merge_tensors(G1tensor(89),[G0tensor(89)])
  call ol_merge_tensors(G1tensor(94),[G0tensor(94)])
  call ol_merge_tensors(G1tensor(98),[G0tensor(98)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(16),G2tensor(10),G2tensor(4)])
  call TI_triangle_red(G2tensor(6),RedBasis(4),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nME], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(7),RedBasis(3),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nME], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(20),RedBasis(1),mass3set(:,1),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nME], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(5),RedBasis(5),mass3set(:,2),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nME], &
    G0tensor(96))
  call TI_triangle_red(G1tensor(2),RedBasis(8),mass3set(:,3),G0tensor(2),G0tensor(52),G0tensor(3),G0tensor(49),M2L1R1,[nME,nMH], &
    G0tensor(34),G0tensor(29))
  call TI_triangle_red(G1tensor(52),RedBasis(3),mass3set(:,4),G0tensor(24),G0tensor(9),G0tensor(4),G0tensor(5),M2L1R1,[nMH,nME], &
    G0tensor(7),G0tensor(57))
  call TI_triangle_red(G1tensor(49),RedBasis(2),mass3set(:,5),G0tensor(8),G0tensor(10),G0tensor(22),G0tensor(17),M2L1R1,[nME], &
    G0tensor(12))
  call TI_triangle_red(G1tensor(5),RedBasis(1),mass3set(:,6),G0tensor(62),G0tensor(13),G0tensor(39),G0tensor(14),M2L1R1,[nME,nMH], &
    G0tensor(15),G0tensor(67))
  call TI_triangle_red(G1tensor(7),RedBasis(8),mass3set(:,7),G0tensor(18),G0tensor(44),G0tensor(19),G0tensor(20),M2L1R1,[nME,nMZ], &
    G0tensor(92),G0tensor(23))
  call TI_triangle_red(G1tensor(57),RedBasis(3),mass3set(:,8),G0tensor(25),G0tensor(27),G0tensor(28), &
    G0tensor(75),M2L1R1,[nMZ,nME],G0tensor(30),G0tensor(32))
  call TI_triangle_red(G1tensor(10),RedBasis(1),mass3set(:,9),G0tensor(33),G0tensor(80),G0tensor(35), &
    G0tensor(47),M2L1R1,[nME,nMZ],G0tensor(42),G0tensor(37))
  call TI_triangle_red(G1tensor(22),RedBasis(8),mass3set(:,2),G0tensor(38),G0tensor(85),G0tensor(40),G0tensor(43),M2L1R1,[nME], &
    G0tensor(90))
  call TI_triangle_red(G1tensor(62),RedBasis(3),mass3set(:,10),G0tensor(45),G0tensor(48),G0tensor(100), &
    G0tensor(50),M2L1R1,[nMH,nME],G0tensor(93),G0tensor(58))
  call TI_triangle_red(G1tensor(39),RedBasis(2),mass3set(:,11),G0tensor(53),G0tensor(54),G0tensor(55), &
    G0tensor(59),M2L1R1,[nMH,nME],G0tensor(60),G0tensor(63))
  call TI_triangle_red(G1tensor(15),RedBasis(1),mass3set(:,12),G0tensor(64),G0tensor(95),G0tensor(70), &
    G0tensor(65),M2L1R1,[nMH,nME],G0tensor(68),G0tensor(69))
  call TI_triangle_red(G1tensor(67),RedBasis(3),mass3set(:,13),G0tensor(72),G0tensor(73),G0tensor(99), &
    G0tensor(79),M2L1R1,[nMZ,nME],G0tensor(74),G0tensor(77))
  call TI_triangle_red(G1tensor(44),RedBasis(2),mass3set(:,14),G0tensor(78),G0tensor(97),G0tensor(87), &
    G0tensor(82),M2L1R1,[nMZ,nME],G0tensor(83),G0tensor(84))
  call TI_triangle_red(G1tensor(20),RedBasis(1),mass3set(:,15),G0tensor(88),G0tensor(89),G0tensor(94), &
    G0tensor(98),M2L1R1,[nMZ,nME],G0tensor(101),G0tensor(102))
  call TI_triangle_red(G1tensor(92),RedBasis(3),mass3set(:,16),G0tensor(103),G0tensor(104),G0tensor(105), &
    G0tensor(106),M2L1R1,[nME],G0tensor(107))
  call TI_triangle_red(G1tensor(25),RedBasis(1),mass3set(:,17),G0tensor(108),G0tensor(109),G0tensor(110), &
    G0tensor(111),M2L1R1,[nME],G0tensor(112))
  call TI_triangle_red(G1tensor(27),RedBasis(9),mass3set(:,3),G0tensor(113),G0tensor(114),G0tensor(115), &
    G0tensor(116),M2L1R1,[nME,nMH],G0tensor(117),G0tensor(118))
  call TI_triangle_red(G1tensor(28),RedBasis(5),mass3set(:,4),G0tensor(119),G0tensor(120),G0tensor(121), &
    G0tensor(122),M2L1R1,[nMH,nME],G0tensor(123),G0tensor(124))
  call TI_triangle_red(G1tensor(75),RedBasis(4),mass3set(:,6),G0tensor(125),G0tensor(126),G0tensor(127), &
    G0tensor(128),M2L1R1,[nME,nMH],G0tensor(129),G0tensor(130))
  call TI_triangle_red(G1tensor(32),RedBasis(9),mass3set(:,7),G0tensor(131),G0tensor(132),G0tensor(133), &
    G0tensor(134),M2L1R1,[nME,nMZ],G0tensor(135),G0tensor(136))
  call TI_triangle_red(G1tensor(33),RedBasis(5),mass3set(:,8),G0tensor(137),G0tensor(138),G0tensor(139), &
    G0tensor(140),M2L1R1,[nMZ,nME],G0tensor(141),G0tensor(142))
  call TI_triangle_red(G1tensor(80),RedBasis(4),mass3set(:,9),G0tensor(143),G0tensor(144),G0tensor(145), &
    G0tensor(146),M2L1R1,[nME,nMZ],G0tensor(147),G0tensor(148))
  call TI_triangle_red(G1tensor(47),RedBasis(9),mass3set(:,2),G0tensor(149),G0tensor(150),G0tensor(151), &
    G0tensor(152),M2L1R1,[nME],G0tensor(153))
  call TI_triangle_red(G1tensor(38),RedBasis(5),mass3set(:,10),G0tensor(154),G0tensor(155),G0tensor(156), &
    G0tensor(157),M2L1R1,[nMH,nME],G0tensor(158),G0tensor(159))
  call TI_triangle_red(G1tensor(85),RedBasis(4),mass3set(:,12),G0tensor(160),G0tensor(161),G0tensor(162), &
    G0tensor(163),M2L1R1,[nMH,nME],G0tensor(164),G0tensor(165))
  call TI_triangle_red(G1tensor(43),RedBasis(5),mass3set(:,13),G0tensor(166),G0tensor(167),G0tensor(168), &
    G0tensor(169),M2L1R1,[nMZ,nME],G0tensor(170),G0tensor(171))
  call TI_triangle_red(G1tensor(90),RedBasis(4),mass3set(:,15),G0tensor(172),G0tensor(173),G0tensor(174), &
    G0tensor(175),M2L1R1,[nMZ,nME],G0tensor(176),G0tensor(177))
  call TI_triangle_red(G1tensor(48),RedBasis(5),mass3set(:,16),G0tensor(178),G0tensor(179),G0tensor(180), &
    G0tensor(181),M2L1R1,[nME],G0tensor(182))
  call TI_triangle_red(G1tensor(100),RedBasis(4),mass3set(:,17),G0tensor(183),G0tensor(184),G0tensor(185), &
    G0tensor(186),M2L1R1,[nME],G0tensor(187))
  call TI_triangle_red(G1tensor(93),RedBasis(7),mass3set(:,2),G0tensor(188),G0tensor(189),G0tensor(190), &
    G0tensor(191),M2L1R1,[nME],G0tensor(192))
  call TI_triangle_red(G1tensor(54),RedBasis(6),mass3set(:,18),G0tensor(193),G0tensor(194),G0tensor(195), &
    G0tensor(196),M2L1R1,[nME,nMH],G0tensor(197),G0tensor(198))
  call TI_triangle_red(G1tensor(55),RedBasis(4),mass3set(:,19),G0tensor(199),G0tensor(200),G0tensor(201), &
    G0tensor(202),M2L1R1,[nME,nMH],G0tensor(203),G0tensor(204))
  call TI_triangle_red(G1tensor(59),RedBasis(6),mass3set(:,20),G0tensor(205),G0tensor(206),G0tensor(207), &
    G0tensor(208),M2L1R1,[nME,nMZ],G0tensor(209),G0tensor(210))
  call TI_triangle_red(G1tensor(60),RedBasis(4),mass3set(:,21),G0tensor(211),G0tensor(212),G0tensor(213), &
    G0tensor(214),M2L1R1,[nME,nMZ],G0tensor(215),G0tensor(216))
  call TI_triangle_red(G1tensor(63),RedBasis(7),mass3set(:,3),G0tensor(217),G0tensor(218),G0tensor(219), &
    G0tensor(220),M2L1R1,[nME,nMH],G0tensor(221),G0tensor(222))
  call TI_triangle_red(G1tensor(64),RedBasis(6),mass3set(:,22),G0tensor(223),G0tensor(224),G0tensor(225), &
    G0tensor(226),M2L1R1,[nME,nMH],G0tensor(227),G0tensor(228))
  call TI_triangle_red(G1tensor(68),RedBasis(7),mass3set(:,7),G0tensor(229),G0tensor(230),G0tensor(231), &
    G0tensor(232),M2L1R1,[nME,nMZ],G0tensor(233),G0tensor(234))
  call TI_triangle_red(G1tensor(69),RedBasis(6),mass3set(:,23),G0tensor(235),G0tensor(236),G0tensor(237), &
    G0tensor(238),M2L1R1,[nME,nMZ],G0tensor(239),G0tensor(240))
  call TI_triangle_red(G1tensor(72),RedBasis(3),mass3set(:,3),G0tensor(241),G0tensor(242),G0tensor(243), &
    G0tensor(244),M2L1R1,[nME,nMH],G0tensor(245),G0tensor(246))
  call TI_triangle_red(G1tensor(73),RedBasis(7),mass3set(:,4),G0tensor(247),G0tensor(248),G0tensor(249), &
    G0tensor(250),M2L1R1,[nMH,nME],G0tensor(251),G0tensor(252))
  call TI_triangle_red(G1tensor(99),RedBasis(6),mass3set(:,5),G0tensor(253),G0tensor(254),G0tensor(255), &
    G0tensor(256),M2L1R1,[nME],G0tensor(257))
  call TI_triangle_red(G1tensor(77),RedBasis(3),mass3set(:,7),G0tensor(258),G0tensor(259),G0tensor(260), &
    G0tensor(261),M2L1R1,[nME,nMZ],G0tensor(262),G0tensor(263))
  call TI_triangle_red(G1tensor(78),RedBasis(7),mass3set(:,8),G0tensor(264),G0tensor(265),G0tensor(266), &
    G0tensor(267),M2L1R1,[nMZ,nME],G0tensor(268),G0tensor(269))
  call TI_triangle_red(G1tensor(83),RedBasis(7),mass3set(:,10),G0tensor(270),G0tensor(271),G0tensor(272), &
    G0tensor(273),M2L1R1,[nMH,nME],G0tensor(274),G0tensor(275))
  call TI_triangle_red(G1tensor(84),RedBasis(6),mass3set(:,11),G0tensor(276),G0tensor(277),G0tensor(278), &
    G0tensor(279),M2L1R1,[nMH,nME],G0tensor(280),G0tensor(281))
  call TI_triangle_red(G1tensor(88),RedBasis(7),mass3set(:,13),G0tensor(282),G0tensor(283),G0tensor(284), &
    G0tensor(285),M2L1R1,[nMZ,nME],G0tensor(286),G0tensor(287))
  call TI_triangle_red(G1tensor(89),RedBasis(6),mass3set(:,14),G0tensor(288),G0tensor(289),G0tensor(290), &
    G0tensor(291),M2L1R1,[nMZ,nME],G0tensor(292),G0tensor(293))
  call TI_triangle_red(G1tensor(94),RedBasis(6),mass3set(:,24),G0tensor(294),G0tensor(295),G0tensor(296), &
    G0tensor(297),M2L1R1,[nME],G0tensor(298))
  call TI_triangle_red(G1tensor(98),RedBasis(7),mass3set(:,16),G0tensor(299),G0tensor(300),G0tensor(301), &
    G0tensor(302),M2L1R1,[nME],G0tensor(303))
  call ol_merge_tensors(T0sum(21),[G0tensor(2)])
  call ol_merge_tensors(T0sum(22),[G0tensor(24)])
  call ol_merge_tensors(T0sum(23),[G0tensor(8)])
  call ol_merge_tensors(T0sum(24),[G0tensor(62)])
  call ol_merge_tensors(T0sum(25),[G0tensor(18)])
  call ol_merge_tensors(T0sum(26),[G0tensor(25)])
  call ol_merge_tensors(T0sum(27),[G0tensor(33)])
  call ol_merge_tensors(T0sum(28),[G0tensor(38)])
  call ol_merge_tensors(T0sum(29),[G0tensor(45)])
  call ol_merge_tensors(T0sum(30),[G0tensor(53)])
  call ol_merge_tensors(T0sum(31),[G0tensor(64)])
  call ol_merge_tensors(T0sum(32),[G0tensor(72)])
  call ol_merge_tensors(T0sum(33),[G0tensor(78)])
  call ol_merge_tensors(T0sum(34),[G0tensor(88)])
  call ol_merge_tensors(T0sum(35),[G0tensor(103)])
  call ol_merge_tensors(T0sum(36),[G0tensor(108)])
  call ol_merge_tensors(T0sum(37),[G0tensor(113)])
  call ol_merge_tensors(T0sum(38),[G0tensor(119)])
  call ol_merge_tensors(T0sum(39),[G0tensor(125)])
  call ol_merge_tensors(T0sum(40),[G0tensor(131)])
  call ol_merge_tensors(T0sum(41),[G0tensor(137)])
  call ol_merge_tensors(T0sum(42),[G0tensor(143)])
  call ol_merge_tensors(T0sum(43),[G0tensor(149)])
  call ol_merge_tensors(T0sum(44),[G0tensor(154)])
  call ol_merge_tensors(T0sum(45),[G0tensor(160)])
  call ol_merge_tensors(T0sum(46),[G0tensor(166)])
  call ol_merge_tensors(T0sum(47),[G0tensor(172)])
  call ol_merge_tensors(T0sum(48),[G0tensor(178)])
  call ol_merge_tensors(T0sum(49),[G0tensor(183)])
  call ol_merge_tensors(T0sum(50),[G0tensor(188)])
  call ol_merge_tensors(T0sum(51),[G0tensor(193)])
  call ol_merge_tensors(T0sum(52),[G0tensor(199)])
  call ol_merge_tensors(T0sum(53),[G0tensor(205)])
  call ol_merge_tensors(T0sum(54),[G0tensor(211)])
  call ol_merge_tensors(T0sum(55),[G0tensor(217)])
  call ol_merge_tensors(T0sum(56),[G0tensor(223)])
  call ol_merge_tensors(T0sum(57),[G0tensor(1)])
  call ol_merge_tensors(T0sum(58),[G0tensor(229)])
  call ol_merge_tensors(T0sum(59),[G0tensor(235)])
  call ol_merge_tensors(T0sum(60),[G0tensor(241)])
  call ol_merge_tensors(T0sum(61),[G0tensor(247)])
  call ol_merge_tensors(T0sum(62),[G0tensor(253)])
  call ol_merge_tensors(T0sum(63),[G0tensor(258)])
  call ol_merge_tensors(T0sum(64),[G0tensor(264)])
  call ol_merge_tensors(T0sum(65),[G0tensor(26)])
  call ol_merge_tensors(T0sum(66),[G0tensor(270)])
  call ol_merge_tensors(T0sum(67),[G0tensor(276)])
  call ol_merge_tensors(T0sum(68),[G0tensor(282)])
  call ol_merge_tensors(T0sum(69),[G0tensor(288)])
  call ol_merge_tensors(T0sum(70),[G0tensor(294)])
  call ol_merge_tensors(T0sum(71),[G0tensor(299)])
  call ol_merge_tensors(T0sum(72),[G0tensor(51)])
  call ol_merge_tensors(T0sum(73),[G0tensor(76)])
  call ol_merge_tensors(G0tensor(104),[G0tensor(73),G0tensor(48),G0tensor(40),G0tensor(6)])
  call ol_merge_tensors(G0tensor(232),[G0tensor(220),G0tensor(213),G0tensor(201),G0tensor(191),G0tensor(91),G0tensor(11)])
  call ol_merge_tensors(G0tensor(297),[G0tensor(238),G0tensor(226),G0tensor(66),G0tensor(16)])
  call ol_merge_tensors(G0tensor(303),[G0tensor(298),G0tensor(293),G0tensor(287),G0tensor(281),G0tensor(275),G0tensor(269) &
    ,G0tensor(262),G0tensor(257),G0tensor(252),G0tensor(245),G0tensor(239),G0tensor(233),G0tensor(227),G0tensor(221),G0tensor(215) &
    ,G0tensor(209),G0tensor(203),G0tensor(197),G0tensor(192),G0tensor(187),G0tensor(182),G0tensor(177),G0tensor(171),G0tensor(165) &
    ,G0tensor(159),G0tensor(153),G0tensor(147),G0tensor(142),G0tensor(135),G0tensor(129),G0tensor(124),G0tensor(117),G0tensor(112) &
    ,G0tensor(107),G0tensor(102),G0tensor(84),G0tensor(77),G0tensor(69),G0tensor(63),G0tensor(58),G0tensor(90),G0tensor(42) &
    ,G0tensor(32),G0tensor(92),G0tensor(15),G0tensor(12),G0tensor(57),G0tensor(34),G0tensor(96),G0tensor(71),G0tensor(46) &
    ,G0tensor(21)])
  call ol_merge_tensors(G0tensor(184),[G0tensor(173),G0tensor(161),G0tensor(150),G0tensor(31)])
  call ol_merge_tensors(G0tensor(300),[G0tensor(283),G0tensor(271),G0tensor(86),G0tensor(36)])
  call ol_merge_tensors(G0tensor(289),[G0tensor(277),G0tensor(261),G0tensor(254),G0tensor(244),G0tensor(61),G0tensor(41)])
  call ol_merge_tensors(G0tensor(296),[G0tensor(207),G0tensor(195),G0tensor(190),G0tensor(179),G0tensor(167),G0tensor(155) &
    ,G0tensor(151),G0tensor(56)])
  call ol_merge_tensors(G0tensor(301),[G0tensor(266),G0tensor(255),G0tensor(249),G0tensor(109),G0tensor(89),G0tensor(95) &
    ,G0tensor(85),G0tensor(81)])
  call ol_merge_tensors(G0tensor(278),[G0tensor(272),G0tensor(13),G0tensor(52)])
  call ol_merge_tensors(G0tensor(200),[G0tensor(9),G0tensor(3)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(134),G0tensor(116),G0tensor(97),G0tensor(54),G0tensor(43),G0tensor(20) &
    ,G0tensor(10),G0tensor(49)])
  call ol_merge_tensors(G0tensor(280),[G0tensor(274),G0tensor(251),G0tensor(246),G0tensor(228),G0tensor(222),G0tensor(204) &
    ,G0tensor(198),G0tensor(164),G0tensor(158),G0tensor(130),G0tensor(123),G0tensor(118),G0tensor(68),G0tensor(60),G0tensor(93) &
    ,G0tensor(67),G0tensor(7),G0tensor(29)])
  call ol_merge_tensors(G0tensor(189),[G0tensor(180),G0tensor(139),G0tensor(121),G0tensor(105),G0tensor(28),G0tensor(22) &
    ,G0tensor(4)])
  call ol_merge_tensors(G0tensor(194),[G0tensor(39),G0tensor(5)])
  call ol_merge_tensors(G0tensor(256),[G0tensor(186),G0tensor(146),G0tensor(128),G0tensor(111),G0tensor(47),G0tensor(14) &
    ,G0tensor(17)])
  call ol_merge_tensors(G0tensor(290),[G0tensor(284),G0tensor(80),G0tensor(44)])
  call ol_merge_tensors(G0tensor(212),[G0tensor(27),G0tensor(19)])
  call ol_merge_tensors(G0tensor(292),[G0tensor(286),G0tensor(268),G0tensor(263),G0tensor(240),G0tensor(234),G0tensor(216) &
    ,G0tensor(210),G0tensor(176),G0tensor(170),G0tensor(148),G0tensor(141),G0tensor(136),G0tensor(101),G0tensor(83),G0tensor(74) &
    ,G0tensor(37),G0tensor(30),G0tensor(23)])
  call ol_merge_tensors(G0tensor(206),[G0tensor(35),G0tensor(75)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(156),G0tensor(55),G0tensor(100)])
  call ol_merge_tensors(G0tensor(224),[G0tensor(70),G0tensor(50)])
  call ol_merge_tensors(G0tensor(279),[G0tensor(163),G0tensor(65),G0tensor(59)])
  call ol_merge_tensors(G0tensor(230),[G0tensor(168),G0tensor(87),G0tensor(99)])
  call ol_merge_tensors(G0tensor(236),[G0tensor(94),G0tensor(79)])
  call ol_merge_tensors(G0tensor(291),[G0tensor(175),G0tensor(98),G0tensor(82)])
  call ol_merge_tensors(G0tensor(295),[G0tensor(110),G0tensor(106)])
  call ol_merge_tensors(G0tensor(242),[G0tensor(126),G0tensor(114)])
  call ol_merge_tensors(G0tensor(225),[G0tensor(219),G0tensor(120),G0tensor(115)])
  call ol_merge_tensors(G0tensor(250),[G0tensor(127),G0tensor(122)])
  call ol_merge_tensors(G0tensor(259),[G0tensor(144),G0tensor(132)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(231),G0tensor(138),G0tensor(133)])
  call ol_merge_tensors(G0tensor(267),[G0tensor(145),G0tensor(140)])
  call ol_merge_tensors(G0tensor(273),[G0tensor(162),G0tensor(157)])
  call ol_merge_tensors(G0tensor(285),[G0tensor(174),G0tensor(169)])
  call ol_merge_tensors(G0tensor(302),[G0tensor(185),G0tensor(181)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(196)])
  call ol_merge_tensors(G0tensor(214),[G0tensor(208)])
  call ol_merge_tensors(G0tensor(248),[G0tensor(243)])
  call ol_merge_tensors(G0tensor(265),[G0tensor(260)])
  call ol_merge_tensors(T0sum(74),[G0tensor(104)])
  call ol_merge_tensors(T0sum(75),[G0tensor(232)])
  call ol_merge_tensors(T0sum(76),[G0tensor(297)])
  call ol_merge_tensors(T0sum(77),[G0tensor(303)])
  call ol_merge_tensors(T0sum(78),[G0tensor(184)])
  call ol_merge_tensors(T0sum(79),[G0tensor(300)])
  call ol_merge_tensors(T0sum(80),[G0tensor(289)])
  call ol_merge_tensors(T0sum(81),[G0tensor(296)])
  call ol_merge_tensors(T0sum(82),[G0tensor(301)])
  call ol_merge_tensors(T0sum(83),[G0tensor(278)])
  call ol_merge_tensors(T0sum(84),[G0tensor(200)])
  call ol_merge_tensors(T0sum(85),[G0tensor(152)])
  call ol_merge_tensors(T0sum(86),[G0tensor(280)])
  call ol_merge_tensors(T0sum(87),[G0tensor(189)])
  call ol_merge_tensors(T0sum(88),[G0tensor(194)])
  call ol_merge_tensors(T0sum(89),[G0tensor(256)])
  call ol_merge_tensors(T0sum(90),[G0tensor(290)])
  call ol_merge_tensors(T0sum(91),[G0tensor(212)])
  call ol_merge_tensors(T0sum(92),[G0tensor(292)])
  call ol_merge_tensors(T0sum(93),[G0tensor(206)])
  call ol_merge_tensors(T0sum(94),[G0tensor(218)])
  call ol_merge_tensors(T0sum(95),[G0tensor(224)])
  call ol_merge_tensors(T0sum(96),[G0tensor(279)])
  call ol_merge_tensors(T0sum(97),[G0tensor(230)])
  call ol_merge_tensors(T0sum(98),[G0tensor(236)])
  call ol_merge_tensors(T0sum(99),[G0tensor(291)])
  call ol_merge_tensors(T0sum(100),[G0tensor(295)])
  call ol_merge_tensors(T0sum(101),[G0tensor(242)])
  call ol_merge_tensors(T0sum(102),[G0tensor(225)])
  call ol_merge_tensors(T0sum(103),[G0tensor(250)])
  call ol_merge_tensors(T0sum(104),[G0tensor(259)])
  call ol_merge_tensors(T0sum(105),[G0tensor(237)])
  call ol_merge_tensors(T0sum(106),[G0tensor(267)])
  call ol_merge_tensors(T0sum(107),[G0tensor(273)])
  call ol_merge_tensors(T0sum(108),[G0tensor(285)])
  call ol_merge_tensors(T0sum(109),[G0tensor(302)])
  call ol_merge_tensors(T0sum(110),[G0tensor(202)])
  call ol_merge_tensors(T0sum(111),[G0tensor(214)])
  call ol_merge_tensors(T0sum(112),[G0tensor(248)])
  call ol_merge_tensors(T0sum(113),[G0tensor(265)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_eell_ew_eeexex_2_/**/REALKIND
