
module ol_vamp_1_eehvtt_eexttxha_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eehvtt_eexttxha_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eehvtt_eexttxha_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eehvtt_eexttxha_1_/**/DREALKIND
  use ol_tensor_sum_storage_eehvtt_eexttxha_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eehvtt_eexttxha_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eehvtt_eexttxha_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,3,16,4,8],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,3,8,4,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,3,8,4,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,3,16,8,4],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,3,16,8,4],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,4,8,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,4,8,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,3,4,8,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,3,4,8,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[32,8,4,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[32,8,4,3,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(12),n2h16(12))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(1),n2h4(1))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,5),G1H4(1),ngZu,m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(3),n2h4(3))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,5),G1H4(1),ngZu,m3h4x4(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(4),n2h4(4))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(5),n2h4(5))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,5),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(6),n2h4(6))
  call Hloop_AQ_V(ntryL,G1H16(7),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,8))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,1),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(7),n2h4(7))
  call Hloop_AZ_Q(ntryL,G1H16(10),wf4(:,5),G1H4(1),ngZu,m3h4x4(:,8),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(8),n2h4(8))
  call Hloop_QA_V(ntryL,G1H16(11),ex4(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,11))
  call Hloop_QA_V(ntryL,G1H16(12),ex4(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(7)])
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(13),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(13),44,nMT,G2H4(1),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(2),ex4(:),G1H4(13),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(13),44,nMT,G2H4(3),n2h4(10))
  call Hloop_AQ_V(ntryL,G2H4(8),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex3(:),G1H4(13),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(13),44,nMT,G2H4(5),n2h4(11))
  call Hloop_VQ_A(ntryL,G1H8(4),ex3(:),G1H4(13),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(13),44,nMT,G2H4(7),n2h4(12))
  call Hloop_AS_Q(ntryL,G1H4(1),ex5(:),G1H4(13),ngH,m3h1x4(:,1),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMT,G2H4(2),n2h4(13))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,nMT,G2H4(4),n2h4(14))
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,4))
  call Hloop_AS_Q(ntryL,G1H4(4),ex5(:),G1H4(1),ngH,m3h1x4(:,2),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(6),n2h4(15))
  call Hloop_AS_Q(ntryL,G1H4(5),ex5(:),G1H4(13),ngH,m3h1x4(:,3),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMT,G2H4(8),n2h4(16))
  call Hloop_AS_Q(ntryL,G1H4(6),ex5(:),G1H4(2),ngH,m3h1x4(:,4),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMT,G2H4(4),n2h4(17))
  call Hloop_QS_A(ntryL,G1H4(7),ex5(:),G1H4(4),ngH,m3h1x4(:,5),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(4),51,nMT,G2H4(9),n2h4(18))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-4,nMT,G2H4(10),n2h4(19))
  call Hloop_AQ_V(ntryL,G2H4(10),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,9))
  call Hloop_QS_A(ntryL,G1H4(10),ex5(:),G1H4(1),ngH,m3h1x4(:,6),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(10),n2h4(20))
  call Hloop_QS_A(ntryL,G1H4(11),ex5(:),G1H4(5),ngH,m3h1x4(:,7),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(5),51,nMT,G2H4(11),n2h4(21))
  call Hloop_QS_A(ntryL,G1H4(12),ex5(:),G1H4(13),ngH,m3h1x4(:,8),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(13),51,nMT,G2H4(12),n2h4(22))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(4),mass5set(:,3),  & 
G1H4(6),G1H4(2),G1H4(7),G1H4(4),G1H4(8),G1H4(10),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(4),mass5set(:,3),  & 
G1H4(1),G1H4(11),G1H4(5),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(11),16,4)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(5),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(6),mass5set(:,3),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(6),mass5set(:,3),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hloop_AQ_V(ntryL,G2H4(2),ex3(:),G2H2(1),m3h2x2(:,5),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(8),ex3(:),G2H2(2),m3h2x2(:,6),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(5),m3h2x2(:,7),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(9),ex4(:),G2H2(6),m3h2x2(:,8),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(11),ex4(:),G2H2(7),m3h2x2(:,9),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(12),ex4(:),G2H2(8),m3h2x2(:,10),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(1),n2h1(1))
call HGT_OLR(G1H2(2),1,1,2)
call HGT_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(2),-16,nMT,G2H2(9),n2h2(1))
  call Hloop_AS_Q(ntryL,G2H2(9),ex5(:),G2H2(10),ngH,m3h1x2(:,1),heltab2x2(:,:,2))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,4))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(3),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(4),n2h1(4))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,nMT,G2H4(1),n2h4(23))
  call Hloop_QS_A(ntryL,G2H4(1),ex5(:),G2H4(3),ngH,m3h1x4(:,9),heltab2x4(:,:,20))
  call Hloop_AV_Q(ntryL,G1H4(8),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(5),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H4(10),wf4(:,1),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(6),n2h1(6))
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(7),n2h1(7))
call HGT_OLR(G1H4(11),1,1,4)
call HGT_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(11),-16,nMT,G2H4(5),n2h4(24))
  call Hloop_QS_A(ntryL,G2H4(5),ex5(:),G2H4(7),ngH,m3h1x4(:,10),heltab2x4(:,:,24))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,5),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(8),n2h1(8))
  call Hloop_AZ_Q(ntryL,G1H4(14),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,6),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(9),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,5))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(10),n2h1(10))
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(8),-16,nMT,G2H2(9),n2h2(2))
  call Hloop_QS_A(ntryL,G2H2(9),ex5(:),G2H2(11),ngH,m3h1x2(:,2),heltab2x2(:,:,6))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,7))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(11),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,8))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(12),n2h1(12))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(13),n2h1(13))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(16),-16,nMT,G2H4(2),n2h4(25))
  call Hloop_AS_Q(ntryL,G2H4(2),ex5(:),G2H4(8),ngH,m3h1x4(:,11),heltab2x4(:,:,28))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,1),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(14),n2h1(14))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,1),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(15),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H4(21),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,10),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(16),n2h1(16))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-16,nMT,G2H4(4),n2h4(26))
  call Hloop_AS_Q(ntryL,G2H4(4),ex5(:),G2H4(9),ngH,m3h1x4(:,12),heltab2x4(:,:,32))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,11),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(17),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,12),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(18),n2h1(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(7),[G2H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G2H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(16),[G2H1(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(18),[G2H1(15)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(5),G1H2(6),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(1),mass4set(:,1),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(12),12,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,1),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),2)
  call HG1shiftOLR(G1H2(17),4,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(1),mass4set(:,1),  & 
G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(23),12,2)
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(3),mass5set(:,2),  & 
G1H1(1),G1H1(2),G1H1(3),G1H1(4),G1H1(5),G1H1(6),1)
  call HG1shiftOLR(G1H1(2),16,1)
  call Hotf_4pt_reduction(G2H1(3),RedSet_4(2),mass4set(:,2),  & 
G1H1(7),G1H1(8),G1H1(9),G1H1(10),G1H1(11),1)
  call HG1shiftOLR(G1H1(8),20,1)
  call Hotf_5pt_reduction(G2H1(7),RedSet_5(4),mass5set(:,3),  & 
G1H1(12),G1H1(13),G1H1(14),G1H1(15),G1H1(16),G1H1(17),1)
  call HG1shiftOLR(G1H1(13),16,1)
  call Hotf_4pt_reduction(G2H1(9),RedSet_4(3),mass4set(:,3),  & 
G1H1(18),G1H1(19),G1H1(20),G1H1(21),G1H1(22),1)
  call HG1shiftOLR(G1H1(19),19,1)
  call Hotf_5pt_reduction(G2H1(10),RedSet_5(5),mass5set(:,2),  & 
G1H1(23),G1H1(24),G1H1(25),G1H1(26),G1H1(27),G1H1(28),1)
  call HG1shiftOLR(G1H1(24),16,1)
  call Hotf_4pt_reduction(G2H1(12),RedSet_4(4),mass4set(:,2),  & 
G1H1(29),G1H1(30),G1H1(31),G1H1(32),G1H1(33),1)
  call HG1shiftOLR(G1H1(30),24,1)
  call Hotf_5pt_reduction(G2H1(16),RedSet_5(6),mass5set(:,3),  & 
G1H1(34),G1H1(35),G1H1(36),G1H1(37),G1H1(38),G1H1(39),1)
  call HG1shiftOLR(G1H1(35),16,1)
  call Hotf_4pt_reduction(G2H1(18),RedSet_4(5),mass4set(:,3),  & 
G1H1(40),G1H1(41),G1H1(42),G1H1(43),G1H1(44),1)
  call HG1shiftOLR(G1H1(41),19,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(7),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(18),[G1H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(29),[G1H1(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(40),[G1H1(39)])
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(6),m3h2x1(:,7),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(1),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(17),m3h2x1(:,8),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMT,G2tensor(2),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(28),m3h2x1(:,9),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),63,nMT,G2tensor(3),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(39),m3h2x1(:,10),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),12,nMT,G2tensor(4),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(6),m3h2x1(:,11),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(5),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(17),ex3(:),G1H1(17),m3h2x1(:,12),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),4,nMT,G2tensor(6),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(28),m3h2x1(:,13),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),63,nMT,G2tensor(7),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(39),m3h2x1(:,14),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),12,nMT,G2tensor(8),n2h1(26))
  call Hloop_QS_A(ntryL,G1H1(1),ex5(:),G1H1(6),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(9),n2h1(27))
  call Hloop_QS_A(ntryL,G1H1(2),ex5(:),G1H1(17),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),16,nMT,G2tensor(10),n2h1(28))
  call Hloop_QS_A(ntryL,G1H1(7),ex5(:),G1H1(28),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),63,nMT,G2tensor(11),n2h1(29))
  call Hloop_QS_A(ntryL,G1H1(8),ex5(:),G1H1(39),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),20,nMT,G2tensor(12),n2h1(30))
  call Hloop_AS_Q(ntryL,G1H1(12),ex5(:),G1H1(1),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(13),n2h1(31))
  call Hloop_AS_Q(ntryL,G1H1(13),ex5(:),G1H1(6),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),16,nMT,G2tensor(14),n2h1(32))
  call Hloop_AS_Q(ntryL,G1H1(18),ex5(:),G1H1(2),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,nMT,G2tensor(15),n2h1(33))
  call Hloop_AS_Q(ntryL,G1H1(19),ex5(:),G1H1(17),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),19,nMT,G2tensor(16),n2h1(34))
  call Hloop_AS_Q(ntryL,G1H1(23),ex5(:),G1H1(7),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),63,nMT,G2tensor(17),n2h1(35))
  call Hloop_AS_Q(ntryL,G1H1(24),ex5(:),G1H1(28),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),16,nMT,G2tensor(18),n2h1(36))
  call Hloop_AS_Q(ntryL,G1H1(29),ex5(:),G1H1(8),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,nMT,G2tensor(19),n2h1(37))
  call Hloop_AS_Q(ntryL,G1H1(30),ex5(:),G1H1(39),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),24,nMT,G2tensor(20),n2h1(38))
  call Hloop_QS_A(ntryL,G1H1(34),ex5(:),G1H1(12),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),63,nMT,G2tensor(21),n2h1(39))
  call Hloop_QS_A(ntryL,G1H1(35),ex5(:),G1H1(1),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(22),n2h1(40))
  call Hloop_QS_A(ntryL,G1H1(40),ex5(:),G1H1(13),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),63,nMT,G2tensor(23),n2h1(41))
  call Hloop_QS_A(ntryL,G1H1(41),ex5(:),G1H1(6),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),19,nMT,G2tensor(24),n2h1(42))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(4),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[32,3,20,8],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(13))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[32,3,20,8],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,3,8,20],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(3),n2h16(15))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,3,8,20],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(16))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,3,24,4],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf2(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(17))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,3,24,4],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf2(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(18))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,3,4,24],[nMT,nMT,0,nMT],4,2,wf4(:,1),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(7),n2h16(19))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,3,4,24],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(8),n2h16(20))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[36,3,16,8],[nMT,nMT,nMT,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[36,3,16,8],[nMT,nMT,nMT,0],4,2,wf4(:,8),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[36,8,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,3),heltab2x32(:,:,23))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[36,8,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(2),m3h4x8(:,4),heltab2x32(:,:,24))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[40,3,16,4],[nMT,nMT,nMT,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,5),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(3),40,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[40,3,16,4],[nMT,nMT,nMT,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,6),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(3),40,nMT,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[40,4,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,7),heltab2x32(:,:,27))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[40,4,3,16],[0,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,8),heltab2x32(:,:,28))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[32,7,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(21))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[32,7,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(22))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[32,8,7,16],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(11),n2h16(23))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[32,8,7,16],[nMT,0,nMT,nMT],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(12),n2h16(24))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[32,11,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(13),n2h16(25))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[32,11,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(14),n2h16(26))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[32,4,11,16],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(15),n2h16(27))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[32,4,11,16],[nMT,0,nMT,nMT],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(16),n2h16(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[32,4,8,19],[nMT,0,nMT,nMT],4,1,wf4(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(17),n2h16(29))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[32,8,4,19],[nMT,0,nMT,nMT],4,1,wf4(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(18),n2h16(30))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[35,8,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(6),n2h4(27))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[35,8,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,16))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(1),ngZu,m3h8x4(:,2),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(2),n2h4(28))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[35,4,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(8),n2h4(29))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[35,4,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,16))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,16),G0H4(1),ngZu,m3h8x4(:,4),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(10),n2h4(30))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[35,8,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(1),m3h8x4(:,5),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(1),n2h4(31))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[35,8,4,16],[nMT,0,nMT,nMT],4,1,wf8(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,18),G0H4(1),ngZu,m3h8x4(:,6),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(11),n2h4(32))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[35,4,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(1),m3h8x4(:,7),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(13),n2h4(33))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[35,4,8,16],[nMT,0,nMT,nMT],4,1,wf8(:,18))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,18),G0H4(1),ngZu,m3h8x4(:,8),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(14),n2h4(34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(1),G1H4(2),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(13),G1H4(10),G1H4(8)])
  call Hloop_AS_Q(ntryL,G1H4(3),ex5(:),G1H4(15),ngH,m3h1x4(:,13),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(15),51,nMT,G2H4(11),n2h4(35))
  call Hloop_QS_A(ntryL,G1H4(9),ex5(:),G1H4(16),ngH,m3h1x4(:,14),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(16),51,nMT,G2H4(12),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(19),m3h4x4(:,9),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(19),35,nMT,G2H4(1),n2h4(37))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,5),G1H4(20),ngZu,m3h4x4(:,10),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(20),35,nMT,G2H4(5),n2h4(38))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(21),m3h4x4(:,11),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(21),35,nMT,G2H4(2),n2h4(39))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,5),G1H4(22),ngZu,m3h4x4(:,12),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(22),35,nMT,G2H4(4),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(25),m3h4x4(:,13),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(25),35,nMT,G2H4(13),n2h4(41))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,5),G1H4(26),ngZu,m3h4x4(:,14),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(26),35,nMT,G2H4(14),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,1),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(15),n2h4(43))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,5),G1H4(2),ngZu,m3h4x4(:,16),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(2),35,nMT,G2H4(16),n2h4(44))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(8),m3h4x2(:,1),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(8),39,nMT,G2H2(9),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,5),G1H2(21),ngZu,m3h4x2(:,2),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(21),39,nMT,G2H2(1),n2h2(4))
  call Hloop_VA_Q(ntryL,G0H8(1),ex4(:),G0H4(1),m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),44,nMT,G1H4(6),n2h4(45))
  call Hloop_VA_Q(ntryL,G0H8(2),ex4(:),G0H4(1),m3h2x4(:,6),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),44,nMT,G1H4(13),n2h4(46))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,1),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(5),n2h2(5))
  call Hloop_AZ_Q(ntryL,G1H8(4),wf4(:,5),G1H2(2),ngZu,m3h4x2(:,4),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(2),43,nMT,G2H2(6),n2h2(6))
  call Hloop_VQ_A(ntryL,G0H8(3),ex3(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G0H4(1),44,nMT,G1H4(10),n2h4(47))
  call Hloop_VQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G0H4(1),44,nMT,G1H4(8),n2h4(48))
  call Hloop_AQ_V(ntryL,G1H16(9),wf8(:,8),G1H2(11),m3h8x2(:,1),heltab2x16(:,:,21))
  call Hloop_AQ_V(ntryL,G1H16(10),wf8(:,10),G1H2(12),m3h8x2(:,2),heltab2x16(:,:,22))
  call Hloop_QA_V(ntryL,G1H16(11),ex4(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,23))
  call Hloop_QA_V(ntryL,G1H16(12),ex4(:),G1H8(2),m3h2x8(:,6),heltab2x16(:,:,24))
  call Hloop_QA_V(ntryL,G1H16(13),wf8(:,4),G1H2(16),m3h8x2(:,3),heltab2x16(:,:,25))
  call Hloop_QA_V(ntryL,G1H16(14),wf8(:,6),G1H2(17),m3h8x2(:,4),heltab2x16(:,:,26))
  call Hloop_AQ_V(ntryL,G1H16(15),ex3(:),G1H8(3),m3h2x8(:,7),heltab2x16(:,:,27))
  call Hloop_AQ_V(ntryL,G1H16(16),ex3(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,28))
  call Hloop_AQ_V(ntryL,G1H16(17),ex3(:),G1H8(5),m3h2x8(:,9),heltab2x16(:,:,29))
  call Hloop_QA_V(ntryL,G1H16(18),ex4(:),G1H8(6),m3h2x8(:,10),heltab2x16(:,:,30))
  call Hloop_QA_V(ntryL,G1H4(11),ex4(:),G1H2(22),m3h2x2(:,11),heltab2x4(:,:,37))
  call Hloop_AQ_V(ntryL,G1H4(14),ex3(:),G1H2(23),m3h2x2(:,12),heltab2x4(:,:,38))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(5)])
call HGT_lower_alpha_w2_OLR(G2H2(3),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(3),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(3),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(9)])
call HGT_lower_alpha_w2_OLR(G2H2(4),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(4),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(4),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(16),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(11),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(15)])
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(28),mass4set(:,4),  & 
G1H2(8),G1H2(21),G1H2(1),G1H2(2),G1H2(3),2)
  call HG1shiftOLR(G1H2(21),4,2)
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(8),m3h2x2(:,13),heltab2x4(:,:,39))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(29),mass4set(:,4),  & 
G1H2(16),G1H2(4),G1H2(9),G1H2(11),G1H2(10),2)
  call HG1shiftOLR(G1H2(4),8,2)
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(5),m3h2x2(:,14),heltab2x4(:,:,40))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(18),m3h2x1(:,15),heltab2x2(:,:,17))
  call Hloop_Q_A(ntryL,G1H1(18),47,nMT,G2H1(4),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(17),ex3(:),G1H1(2),m3h2x1(:,16),heltab2x2(:,:,18))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(6),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,1),G1H1(19),m3h4x1(:,13),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMT,G2H1(13),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H4(4),wf4(:,1),G1H1(17),m3h4x1(:,14),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H1(17),47,nMT,G2H1(15),n2h1(46))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,5),G1H1(23),ngZu,m3h4x1(:,15),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H1(23),47,nMT,G2H1(1),n2h1(47))
  call Hloop_AZ_Q(ntryL,G1H4(12),wf4(:,5),G1H1(7),ngZu,m3h4x1(:,16),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMT,G2H1(3),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(23),ex4(:),G1H1(24),m3h2x1(:,17),heltab2x2(:,:,19))
  call Hloop_A_Q(ntryL,G1H1(24),47,nMT,G2H1(7),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(28),m3h2x1(:,18),heltab2x2(:,:,20))
  call Hloop_A_Q(ntryL,G1H1(28),47,nMT,G2H1(9),n2h1(50))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,1),G1H1(29),m3h4x1(:,17),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H1(29),47,nMT,G2H1(10),n2h1(51))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,1),G1H1(8),m3h4x1(:,18),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMT,G2H1(12),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,5),G1H1(30),ngZu,m3h4x1(:,19),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H1(30),47,nMT,G2H1(16),n2h1(53))
  call Hloop_QZ_A(ntryL,G1H4(24),wf4(:,5),G1H1(39),ngZu,m3h4x1(:,20),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H1(39),47,nMT,G2H1(18),n2h1(54))
  call Hloop_AQ_V(ntryL,G2H4(11),ex3(:),G2H2(6),m3h2x2(:,15),heltab2x4(:,:,49))
  call Hloop_QA_V(ntryL,G2H4(12),ex4(:),G2H2(9),m3h2x2(:,16),heltab2x4(:,:,50))
  call Hloop_AQ_V(ntryL,G2H4(5),wf2(:,2),G2H2(1),m3h2x2(:,17),heltab2x4(:,:,51))
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(3),m3h2x2(:,18),heltab2x4(:,:,52))
  call Hloop_QA_V(ntryL,G2H4(14),wf2(:,4),G2H2(4),m3h2x2(:,19),heltab2x4(:,:,53))
  call Hloop_AQ_V(ntryL,G2H4(16),ex3(:),G2H2(12),m3h2x2(:,20),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,8),G1H1(34),m3h8x1(:,1),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H1(34),47,nMT,G2H1(19),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,10),G1H1(12),m3h8x1(:,2),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H1(12),47,nMT,G2H1(20),n2h1(56))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,4),G1H1(35),m3h8x1(:,3),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H1(35),47,nMT,G2H1(21),n2h1(57))
  call Hloop_VA_Q(ntryL,G1H8(4),wf8(:,6),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(22),n2h1(58))
  call Hloop_VA_Q(ntryL,G1H8(5),ex4(:),G1H4(3),m3h2x4(:,9),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(3),44,nMT,G2H4(1),n2h4(49))
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(15),m3h2x4(:,10),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(15),44,nMT,G2H4(2),n2h4(50))
  call Hloop_AS_Q(ntryL,G1H2(8),ex5(:),G1H2(22),ngH,m3h1x2(:,3),heltab2x2(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(22),59,nMT,G2H2(13),n2h2(7))
call HGT_raise_alpha_OLR(G1H2(21),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(21),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(40),m3h2x1(:,19),heltab2x2(:,:,22))
  call Hloop_AS_Q(ntryL,G1H2(2),ex5(:),G1H2(17),ngH,m3h1x2(:,4),heltab2x2(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(17),59,nMT,G2H2(14),n2h2(9))
  call Hloop_AS_Q(ntryL,G1H2(3),ex5(:),G1H2(23),ngH,m3h1x2(:,5),heltab2x2(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(23),59,nMT,G2H2(15),n2h2(10))
  call Hloop_QS_A(ntryL,G1H2(16),ex5(:),G1H2(12),ngH,m3h1x2(:,6),heltab2x2(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMT,G2H2(16),n2h2(11))
call HGT_raise_alpha_OLR(G1H2(4),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(13),m3h2x1(:,20),heltab2x2(:,:,26))
  call Hloop_QS_A(ntryL,G1H2(11),ex5(:),G1H2(8),ngH,m3h1x2(:,7),heltab2x2(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(17),n2h2(13))
  call Hloop_QS_A(ntryL,G1H2(10),ex5(:),G1H2(22),ngH,m3h1x2(:,8),heltab2x2(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(22),55,nMT,G2H2(18),n2h2(14))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(2),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(7),G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(22),[G2H1(21),G2H1(8),G2H1(5),G1H1(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G1H1(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(20),[G2H1(19),G2H1(17),G2H1(14),G1H1(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(1),[G2H1(13),G1H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(3),[G2H1(15),G1H1(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(7),[G1H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G1H1(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(16),[G2H1(10),G1H1(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(18),[G2H1(12),G1H1(37)])
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(8),mass4set(:,2),  & 
G1H2(21),G1H2(2),G1H2(17),G1H2(3),G1H2(23),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(12),mass4set(:,2),  & 
G1H2(16),G1H2(12),G1H2(4),G1H2(11),G1H2(8),2)
  call HG1shiftOLR(G1H2(12),4,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(30),mass4set(:,2),  & 
G1H2(10),G1H2(22),G1H2(7),G1H2(20),G1H2(5),2)
  call HG1shiftOLR(G1H2(22),4,2)
  call Hotf_4pt_reduction(G2H1(2),RedSet_4(16),mass4set(:,1),  & 
G1H1(41),G1H1(6),G1H1(18),G1H1(2),G1H1(19),1)
  call HG1shiftOLR(G1H1(6),16,1)
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(31),mass4set(:,3),  & 
G1H4(9),G1H4(16),G1H4(19),G1H4(20),G1H4(21),4)
  call HG1shiftOLR(G1H4(16),3,4)
  call Hotf_4pt_reduction(G2H1(22),RedSet_4(20),mass4set(:,3),  & 
G1H1(17),G1H1(23),G1H1(7),G1H1(24),G1H1(28),1)
  call HG1shiftOLR(G1H1(23),16,1)
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(31),mass4set(:,3),  & 
G1H4(22),G1H4(25),G1H4(26),G1H4(1),G1H4(2),4)
  call HG1shiftOLR(G1H4(25),3,4)
call HGT_OLR(G2H2(11),1,1,2)
call HGT_invQ_OLR(G2H2(11),2,5,2)
call HGT_OLR(G2H2(11),6,15,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(32),mass4set(:,2),  & 
G1H2(6),G1H2(18),G1H2(19),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hotf_4pt_reduction(G2H1(11),RedSet_4(16),mass4set(:,1),  & 
G1H1(29),G1H1(8),G1H1(30),G1H1(39),G1H1(34),1)
  call HG1shiftOLR(G1H1(8),16,1)
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(33),mass4set(:,3),  & 
G1H4(11),G1H4(14),G1H4(7),G1H4(5),G1H4(17),4)
  call HG1shiftOLR(G1H4(14),3,4)
  call Hotf_4pt_reduction(G2H1(20),RedSet_4(26),mass4set(:,3),  & 
G1H1(12),G1H1(35),G1H1(1),G1H1(5),G1H1(16),1)
  call HG1shiftOLR(G1H1(35),16,1)
call HGT_OLR(G2H4(9),1,1,4)
call HGT_invQ_OLR(G2H4(9),2,5,4)
call HGT_OLR(G2H4(9),6,15,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(33),mass4set(:,3),  & 
G1H4(23),G1H4(6),G1H4(4),G1H4(13),G1H4(12),4)
  call HG1shiftOLR(G1H4(6),3,4)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(6),mass4set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(7),mass4set(:,2),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(27),m3h2x1(:,21),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),63,nMT,G2tensor(1),n2h1(59))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(38),m3h2x1(:,22),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),63,nMT,G2tensor(5),n2h1(60))
  call Hloop_VA_Q(ntryL,G1H2(15),ex4(:),G1H1(3),m3h2x1(:,23),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),63,nMT,G2tensor(9),n2h1(61))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(10),mass4set(:,2),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(14),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(11),mass4set(:,2),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(42),4,2)
  call Hloop_VQ_A(ntryL,G1H2(24),ex3(:),G1H1(4),m3h2x1(:,24),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),63,nMT,G2tensor(13),n2h1(62))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(14),m3h2x1(:,25),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),63,nMT,G2tensor(17),n2h1(63))
  call Hloop_VQ_A(ntryL,G1H2(26),ex3(:),G1H1(15),m3h2x1(:,26),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),63,nMT,G2tensor(21),n2h1(64))
  call Hotf_4pt_reduction(G2H1(4),RedSet_4(14),mass4set(:,3),  & 
G1H1(25),G1H1(26),G1H1(36),G1H1(37),G1H1(27),1)
  call HG1shiftOLR(G1H1(26),16,1)
  call Hotf_4pt_reduction(G2H1(6),RedSet_4(15),mass4set(:,3),  & 
G1H1(38),G1H1(3),G1H1(4),G1H1(14),G1H1(15),1)
  call HG1shiftOLR(G1H1(3),16,1)
  call Hloop_QS_A(ntryL,G1H1(9),ex5(:),G1H1(45),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),63,nMT,G2tensor(25),n2h1(65))
  call Hloop_QS_A(ntryL,G1H1(10),ex5(:),G1H1(9),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMT,G2tensor(26),n2h1(66))
  call Hloop_QS_A(ntryL,G1H1(11),ex5(:),G1H1(45),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),63,nMT,G2tensor(27),n2h1(67))
  call Hotf_4pt_reduction(G2H1(1),RedSet_4(18),mass4set(:,5),  & 
G1H1(10),G1H1(9),G1H1(11),G1H1(45),G1H1(46),1)
  call HG1shiftOLR(G1H1(9),16,1)
  call Hotf_4pt_reduction(G2H1(3),RedSet_4(19),mass4set(:,1),  & 
G1H1(47),G1H1(48),G1H1(49),G1H1(50),G1H1(51),1)
  call HG1shiftOLR(G1H1(48),16,1)
  call Hloop_AS_Q(ntryL,G1H1(20),ex5(:),G1H1(52),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(52),63,nMT,G2tensor(28),n2h1(68))
  call Hloop_AS_Q(ntryL,G1H1(21),ex5(:),G1H1(20),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMT,G2tensor(29),n2h1(69))
  call Hloop_AS_Q(ntryL,G1H1(22),ex5(:),G1H1(52),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(52),63,nMT,G2tensor(30),n2h1(70))
  call Hotf_4pt_reduction(G2H1(7),RedSet_4(22),mass4set(:,3),  & 
G1H1(21),G1H1(20),G1H1(22),G1H1(52),G1H1(53),1)
  call HG1shiftOLR(G1H1(20),16,1)
  call Hotf_4pt_reduction(G2H1(9),RedSet_4(23),mass4set(:,3),  & 
G1H1(54),G1H1(55),G1H1(56),G1H1(57),G1H1(58),1)
  call HG1shiftOLR(G1H1(55),16,1)
  call Hloop_AS_Q(ntryL,G1H1(31),ex5(:),G1H1(59),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),63,nMT,G2tensor(31),n2h1(71))
  call Hloop_AS_Q(ntryL,G1H1(32),ex5(:),G1H1(31),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),63,nMT,G2tensor(32),n2h1(72))
  call Hloop_AS_Q(ntryL,G1H1(33),ex5(:),G1H1(59),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),63,nMT,G2tensor(33),n2h1(73))
  call Hotf_4pt_reduction(G2H1(16),RedSet_4(25),mass4set(:,5),  & 
G1H1(32),G1H1(31),G1H1(33),G1H1(59),G1H1(60),1)
  call HG1shiftOLR(G1H1(31),16,1)
  call Hotf_4pt_reduction(G2H1(18),RedSet_4(19),mass4set(:,1),  & 
G1H1(61),G1H1(62),G1H1(63),G1H1(64),G1H1(65),1)
  call HG1shiftOLR(G1H1(62),16,1)
  call Hloop_QS_A(ntryL,G1H1(42),ex5(:),G1H1(66),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(34),n2h1(74))
  call Hloop_QS_A(ntryL,G1H1(43),ex5(:),G1H1(42),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(35),n2h1(75))
  call Hloop_QS_A(ntryL,G1H1(44),ex5(:),G1H1(66),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(36),n2h1(76))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(2),mass4set(:,2),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(25),20,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(4),mass4set(:,2),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(49),24,2)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(3),mass4set(:,3),  & 
G1H4(10),G1H4(18),G1H4(8),G1H4(24),G1H4(3),4)
  call HG1shiftOLR(G1H4(18),19,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(5),mass4set(:,3),  & 
G1H4(15),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(27),19,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(37),m3h2x1(:,27),heltab2x2(:,:,35))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(38),m3h2x1(:,28),heltab2x2(:,:,36))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(39),m3h2x1(:,29),heltab2x2(:,:,37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(40),m3h2x1(:,30),heltab2x2(:,:,38))
  call Hloop_VA_Q(ntryL,G1H2(21),ex4(:),G1H1(43),m3h2x1(:,31),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),63,nMT,G2tensor(41),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(42),m3h2x1(:,32),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),8,nMT,G2tensor(42),n2h1(78))
  call Hloop_VA_Q(ntryL,G1H2(23),ex4(:),G1H1(44),m3h2x1(:,33),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),63,nMT,G2tensor(43),n2h1(79))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(66),m3h2x1(:,34),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(44),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(12),ex3(:),G1H1(43),m3h2x1(:,35),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),4,nMT,G2tensor(45),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(42),m3h2x1(:,36),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(46),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(10),ex3(:),G1H1(44),m3h2x1(:,37),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),63,nMT,G2tensor(47),n2h1(83))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(66),m3h2x1(:,38),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),4,nMT,G2tensor(48),n2h1(84))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(43),m3h2x1(:,39),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMT,G2tensor(49),n2h1(85))
  call Hloop_QS_A(ntryL,G1H1(41),ex5(:),G1H1(42),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(50),n2h1(86))
  call Hloop_QS_A(ntryL,G1H1(6),ex5(:),G1H1(44),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),16,nMT,G2tensor(51),n2h1(87))
  call Hloop_QS_A(ntryL,G1H1(19),ex5(:),G1H1(66),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(52),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,1),G1H1(43),m3h4x1(:,21),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),63,nMT,G2tensor(53),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H4(16),wf4(:,1),G1H1(41),m3h4x1(:,22),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),3,nMT,G2tensor(54),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H4(21),wf4(:,1),G1H1(42),m3h4x1(:,23),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(55),n2h1(91))
  call Hloop_AS_Q(ntryL,G1H1(17),ex5(:),G1H1(6),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(56),n2h1(92))
  call Hloop_AS_Q(ntryL,G1H1(23),ex5(:),G1H1(44),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),16,nMT,G2tensor(57),n2h1(93))
  call Hloop_AS_Q(ntryL,G1H1(28),ex5(:),G1H1(19),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),63,nMT,G2tensor(58),n2h1(94))
  call Hloop_AZ_Q(ntryL,G1H4(22),wf4(:,5),G1H1(66),ngZu,m3h4x1(:,24),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(59),n2h1(95))
  call Hloop_AZ_Q(ntryL,G1H4(25),wf4(:,5),G1H1(43),ngZu,m3h4x1(:,25),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),3,nMT,G2tensor(60),n2h1(96))
  call Hloop_AZ_Q(ntryL,G1H4(2),wf4(:,5),G1H1(41),ngZu,m3h4x1(:,26),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),63,nMT,G2tensor(61),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(42),m3h2x1(:,40),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(62),n2h1(98))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(17),m3h2x1(:,41),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMT,G2tensor(63),n2h1(99))
  call Hloop_VA_Q(ntryL,G1H2(28),ex4(:),G1H1(6),m3h2x1(:,42),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(64),n2h1(100))
  call Hloop_AS_Q(ntryL,G1H1(29),ex5(:),G1H1(23),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),63,nMT,G2tensor(65),n2h1(101))
  call Hloop_AS_Q(ntryL,G1H1(8),ex5(:),G1H1(44),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),16,nMT,G2tensor(66),n2h1(102))
  call Hloop_AS_Q(ntryL,G1H1(34),ex5(:),G1H1(28),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),63,nMT,G2tensor(67),n2h1(103))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,1),G1H1(19),m3h4x1(:,27),heltab2x4(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),63,nMT,G2tensor(68),n2h1(104))
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,1),G1H1(66),m3h4x1(:,28),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),3,nMT,G2tensor(69),n2h1(105))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,1),G1H1(43),m3h4x1(:,29),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMT,G2tensor(70),n2h1(106))
  call Hloop_QS_A(ntryL,G1H1(12),ex5(:),G1H1(41),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),63,nMT,G2tensor(71),n2h1(107))
  call Hloop_QS_A(ntryL,G1H1(35),ex5(:),G1H1(42),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),16,nMT,G2tensor(72),n2h1(108))
  call Hloop_QS_A(ntryL,G1H1(16),ex5(:),G1H1(17),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),63,nMT,G2tensor(73),n2h1(109))
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,5),G1H1(6),ngZu,m3h4x1(:,30),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(74),n2h1(110))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,5),G1H1(29),ngZu,m3h4x1(:,31),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),3,nMT,G2tensor(75),n2h1(111))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,5),G1H1(23),ngZu,m3h4x1(:,32),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),63,nMT,G2tensor(76),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(8),m3h2x1(:,43),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,nMT,G2tensor(77),n2h1(113))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(44),m3h2x1(:,44),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),8,nMT,G2tensor(78),n2h1(114))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(34),m3h2x1(:,45),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),63,nMT,G2tensor(79),n2h1(115))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(28),m3h2x1(:,46),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),63,nMT,G2tensor(80),n2h1(116))
  call Hloop_VA_Q(ntryL,G1H2(35),ex4(:),G1H1(19),m3h2x1(:,47),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMT,G2tensor(81),n2h1(117))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(66),m3h2x1(:,48),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(82),n2h1(118))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(43),m3h2x1(:,49),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMT,G2tensor(83),n2h1(119))
  call Hloop_VQ_A(ntryL,G1H2(14),ex3(:),G1H1(12),m3h2x1(:,50),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),4,nMT,G2tensor(84),n2h1(120))
  call Hloop_VQ_A(ntryL,G1H2(40),ex3(:),G1H1(41),m3h2x1(:,51),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),63,nMT,G2tensor(85),n2h1(121))
  call Hloop_VQ_A(ntryL,G1H2(41),ex3(:),G1H1(35),m3h2x1(:,52),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(35),63,nMT,G2tensor(86),n2h1(122))
  call Hloop_VQ_A(ntryL,G1H2(42),ex3(:),G1H1(42),m3h2x1(:,53),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),4,nMT,G2tensor(87),n2h1(123))
  call Hloop_VQ_A(ntryL,G1H2(45),ex3(:),G1H1(16),m3h2x1(:,54),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMT,G2tensor(88),n2h1(124))
  call Hloop_QS_A(ntryL,G1H1(25),ex5(:),G1H1(17),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),63,nMT,G2tensor(89),n2h1(125))
  call Hloop_QS_A(ntryL,G1H1(26),ex5(:),G1H1(6),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),16,nMT,G2tensor(90),n2h1(126))
  call Hloop_QS_A(ntryL,G1H1(27),ex5(:),G1H1(29),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),63,nMT,G2tensor(91),n2h1(127))
  call Hloop_QS_A(ntryL,G1H1(38),ex5(:),G1H1(23),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),63,nMT,G2tensor(92),n2h1(128))
  call Hloop_QS_A(ntryL,G1H1(3),ex5(:),G1H1(8),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),16,nMT,G2tensor(93),n2h1(129))
  call Hloop_QS_A(ntryL,G1H1(15),ex5(:),G1H1(44),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),63,nMT,G2tensor(94),n2h1(130))
  call Hloop_AS_Q(ntryL,G1H1(10),ex5(:),G1H1(34),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),63,nMT,G2tensor(95),n2h1(131))
  call Hloop_AS_Q(ntryL,G1H1(9),ex5(:),G1H1(28),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),16,nMT,G2tensor(96),n2h1(132))
  call Hloop_AS_Q(ntryL,G1H1(46),ex5(:),G1H1(19),ngH,m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),63,nMT,G2tensor(97),n2h1(133))
  call Hloop_AS_Q(ntryL,G1H1(47),ex5(:),G1H1(66),ngH,m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(98),n2h1(134))
  call Hloop_AS_Q(ntryL,G1H1(48),ex5(:),G1H1(43),ngH,m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),16,nMT,G2tensor(99),n2h1(135))
  call Hloop_AS_Q(ntryL,G1H1(51),ex5(:),G1H1(12),ngH,m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),63,nMT,G2tensor(100),n2h1(136))
  call Hloop_AS_Q(ntryL,G1H1(21),ex5(:),G1H1(41),ngH,m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),63,nMT,G2tensor(101),n2h1(137))
  call Hloop_AS_Q(ntryL,G1H1(20),ex5(:),G1H1(35),ngH,m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),16,nMT,G2tensor(102),n2h1(138))
  call Hloop_AS_Q(ntryL,G1H1(53),ex5(:),G1H1(42),ngH,m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(103),n2h1(139))
  call Hloop_AS_Q(ntryL,G1H1(54),ex5(:),G1H1(16),ngH,m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),63,nMT,G2tensor(104),n2h1(140))
  call Hloop_AS_Q(ntryL,G1H1(55),ex5(:),G1H1(25),ngH,m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),16,nMT,G2tensor(105),n2h1(141))
  call Hloop_AS_Q(ntryL,G1H1(58),ex5(:),G1H1(17),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),63,nMT,G2tensor(106),n2h1(142))
  call Hloop_QS_A(ntryL,G1H1(32),ex5(:),G1H1(26),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,nMT,G2tensor(107),n2h1(143))
  call Hloop_QS_A(ntryL,G1H1(31),ex5(:),G1H1(6),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),16,nMT,G2tensor(108),n2h1(144))
  call Hloop_QS_A(ntryL,G1H1(60),ex5(:),G1H1(27),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),63,nMT,G2tensor(109),n2h1(145))
  call Hloop_QS_A(ntryL,G1H1(61),ex5(:),G1H1(29),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),63,nMT,G2tensor(110),n2h1(146))
  call Hloop_QS_A(ntryL,G1H1(62),ex5(:),G1H1(38),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),16,nMT,G2tensor(111),n2h1(147))
  call Hloop_QS_A(ntryL,G1H1(65),ex5(:),G1H1(23),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),63,nMT,G2tensor(112),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H2(24),wf2(:,2),G1H1(3),m3h2x1(:,55),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),63,nMT,G2tensor(113),n2h1(149))
  call Hloop_VQ_A(ntryL,G1H2(25),wf2(:,2),G1H1(8),m3h2x1(:,56),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),20,nMT,G2tensor(114),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(47),wf2(:,2),G1H1(15),m3h2x1(:,57),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),63,nMT,G2tensor(115),n2h1(151))
  call Hloop_VA_Q(ntryL,G1H2(48),wf2(:,4),G1H1(44),m3h2x1(:,58),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),63,nMT,G2tensor(116),n2h1(152))
  call Hloop_VA_Q(ntryL,G1H2(49),wf2(:,4),G1H1(10),m3h2x1(:,59),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),24,nMT,G2tensor(117),n2h1(153))
  call Hloop_VA_Q(ntryL,G1H2(52),wf2(:,4),G1H1(34),m3h2x1(:,60),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),63,nMT,G2tensor(118),n2h1(154))
  call Hloop_AZ_Q(ntryL,G1H4(10),wf4(:,31),G1H1(9),ngZu,m3h4x1(:,33),heltab2x4(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMT,G2tensor(119),n2h1(155))
  call Hloop_AZ_Q(ntryL,G1H4(18),wf4(:,31),G1H1(28),ngZu,m3h4x1(:,34),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),19,nMT,G2tensor(120),n2h1(156))
  call Hloop_AZ_Q(ntryL,G1H4(3),wf4(:,31),G1H1(46),ngZu,m3h4x1(:,35),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(46),63,nMT,G2tensor(121),n2h1(157))
  call Hloop_QZ_A(ntryL,G1H4(15),wf4(:,31),G1H1(19),ngZu,m3h4x1(:,36),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),63,nMT,G2tensor(122),n2h1(158))
  call Hloop_QZ_A(ntryL,G1H4(27),wf4(:,31),G1H1(47),ngZu,m3h4x1(:,37),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),19,nMT,G2tensor(123),n2h1(159))
  call Hloop_QZ_A(ntryL,G1H4(30),wf4(:,31),G1H1(66),ngZu,m3h4x1(:,38),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(124),n2h1(160))
  call ol_merge_tensors(G2tensor(37),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(3),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(6),G1tensor(8)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(10),G1tensor(14)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(11),G1tensor(18)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(53),G2tensor(14),G1tensor(20)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(15),G1tensor(24)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(18),G1tensor(26)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(19),G1tensor(30)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(68),G2tensor(22),G1tensor(32)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(23),G1tensor(36)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(50),G1tensor(29),G1tensor(17)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(98),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(35)])
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(28),mass4set(:,4),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(1),mass4set(:,1),  & 
G1tensor(31),G1tensor(2),G1tensor(12),G1tensor(6),G1tensor(8))
  call G_TensorShift(G1tensor(2),12)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(29),mass4set(:,4),  & 
G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(24),G1tensor(26))
  call G_TensorShift(G1tensor(18),8)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(30),mass4set(:,2),  & 
G1tensor(30),G1tensor(32),G1tensor(36),G1tensor(3),G1tensor(4))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(2),mass4set(:,2),  & 
G1tensor(5),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(15))
  call G_TensorShift(G1tensor(9),20)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(31),mass4set(:,3),  & 
G1tensor(16),G1tensor(29),G1tensor(17),G1tensor(21),G1tensor(34))
  call G_TensorShift(G1tensor(29),3)
  call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(3),mass4set(:,3),  & 
G1tensor(22),G1tensor(23),G1tensor(27),G1tensor(28),G1tensor(33))
  call G_TensorShift(G1tensor(23),19)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(32),mass4set(:,2),  & 
G1tensor(35),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),8)
  call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(4),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),24)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(33),mass4set(:,3),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),3)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(5),mass4set(:,3),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),19)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(6),mass4set(:,2),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(7),mass4set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(8),mass4set(:,2),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(10),mass4set(:,2),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(11),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(12),mass4set(:,2),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(14),mass4set(:,3),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),16)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(15),mass4set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(16),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),16)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(18),mass4set(:,5),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),16)
  call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(19),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),16)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(20),mass4set(:,3),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),16)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(22),mass4set(:,3),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),16)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(23),mass4set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(25),mass4set(:,5),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),16)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(26),mass4set(:,3),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),16)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(28),mass4set(:,4),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(29),mass4set(:,4),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(30),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(2),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(31),mass4set(:,3),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(3),mass4set(:,3),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(32),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(4),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(33),mass4set(:,3),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(5),mass4set(:,3),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(6),mass4set(:,2),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(7),mass4set(:,2),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(8),mass4set(:,2),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(10),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(11),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(12),mass4set(:,2),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(14),mass4set(:,3),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(15),mass4set(:,3),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(16),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(18),mass4set(:,5),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(19),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(20),mass4set(:,3),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(22),mass4set(:,3),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(23),mass4set(:,3),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(25),mass4set(:,5),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(26),mass4set(:,3),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[40,3,20],[nMT,nMT,0],3,3,wf4(:,3),wf4(:,1),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H8(1),40,nMT,G1H8(1),n2h8(5))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[40,3,20],[nMT,nMT,0],3,3,wf4(:,3),wf4(:,5),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(2),40,nMT,G1H8(2),n2h8(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[32,11,20],[nMT,0,nMT],3,2,wf8(:,4),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(31))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[32,11,20],[nMT,0,nMT],3,2,wf8(:,6),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(32))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[52,3,8],[nMT,nMT,0],3,2,wf4(:,28),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,28),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H8(3),52,nMT,G1H8(3),n2h8(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[52,3,8],[nMT,nMT,0],3,2,wf4(:,28),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,28),G0H8(4),m3h4x8(:,12),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H8(4),52,nMT,G1H8(4),n2h8(8))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[32,8,23],[nMT,0,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(3),n2h16(33))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[32,8,23],[nMT,0,nMT],3,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(34))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[36,3,24],[nMT,nMT,0],3,3,wf4(:,8),wf4(:,1),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,13),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMT,G1H8(5),n2h8(9))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[36,3,24],[nMT,nMT,0],3,3,wf4(:,8),wf4(:,5),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(2),m3h4x8(:,14),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H8(2),36,nMT,G1H8(6),n2h8(10))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[32,7,24],[nMT,0,nMT],3,2,wf8(:,8),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(35))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[32,7,24],[nMT,0,nMT],3,2,wf8(:,10),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(36))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[56,3,4],[nMT,nMT,0],3,2,wf4(:,35),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,35),G0H8(3),m3h4x8(:,15),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(3),56,nMT,G1H8(7),n2h8(11))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[56,3,4],[nMT,nMT,0],3,2,wf4(:,35),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,35),G0H8(4),m3h4x8(:,16),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(4),56,nMT,G1H8(8),n2h8(12))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[32,4,27],[nMT,0,nMT],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(7),n2h16(37))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[32,4,27],[nMT,0,nMT],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(8),n2h16(38))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[36,11,16],[0,nMT,nMT],3,2,wf4(:,8),wf8(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,17),heltab2x32(:,:,63))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[36,11,16],[0,nMT,nMT],3,2,wf4(:,8),wf8(:,6))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(2),m3h4x8(:,18),heltab2x32(:,:,64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[36,8,19],[0,nMT,nMT],3,2,wf4(:,8),wf4(:,31))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(3),m3h4x8(:,19),heltab2x32(:,:,65))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[52,3,8],[nMT,nMT,0],3,2,wf4(:,32),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,32),G0H8(4),m3h4x8(:,20),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(4),52,nMT,G1H8(9),n2h8(13))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[52,3,8],[nMT,nMT,0],3,2,wf4(:,32),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,32),G0H8(4),m3h4x8(:,21),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(4),52,nMT,G1H8(10),n2h8(14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[39,8,16],[0,nMT,nMT],3,1,wf16(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,11),G0H2(1),m3h16x2(:,1),heltab2x32(:,:,68))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[39,8,16],[0,nMT,nMT],3,1,wf16(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,12),G0H2(2),m3h16x2(:,2),heltab2x32(:,:,69))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[40,7,16],[0,nMT,nMT],3,2,wf4(:,3),wf8(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,22),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[40,7,16],[0,nMT,nMT],3,2,wf4(:,3),wf8(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,23),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[40,4,19],[0,nMT,nMT],3,2,wf4(:,3),wf4(:,31))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,24),heltab2x32(:,:,72))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[56,3,4],[nMT,nMT,0],3,2,wf4(:,38),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,38),G0H8(7),m3h4x8(:,25),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(7),56,nMT,G1H8(11),n2h8(15))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[56,3,4],[nMT,nMT,0],3,2,wf4(:,38),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,38),G0H8(7),m3h4x8(:,26),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(7),56,nMT,G1H8(12),n2h8(16))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[43,4,16],[0,nMT,nMT],3,1,wf16(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,8),G0H2(3),m3h16x2(:,3),heltab2x32(:,:,75))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[43,4,16],[0,nMT,nMT],3,1,wf16(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,10),G0H2(4),m3h16x2(:,4),heltab2x32(:,:,76))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[32,8,23],[nMT,0,nMT],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(39))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[32,8,23],[nMT,0,nMT],3,1,wf8(:,50))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(40))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[39,8,16],[0,nMT,nMT],3,1,wf16(:,14))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,14),G0H2(5),m3h16x2(:,5),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[39,8,16],[0,nMT,nMT],3,1,wf16(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,16),G0H2(6),m3h16x2(:,6),heltab2x32(:,:,80))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[32,4,27],[nMT,0,nMT],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(11),n2h16(41))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[32,4,27],[nMT,0,nMT],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(12),n2h16(42))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[43,4,16],[0,nMT,nMT],3,1,wf16(:,18))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,18),G0H2(7),m3h16x2(:,7),heltab2x32(:,:,83))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[43,4,16],[0,nMT,nMT],3,1,wf16(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,20),G0H2(8),m3h16x2(:,8),heltab2x32(:,:,84))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[32,8,23],[nMT,0,nMT],3,1,wf8(:,56))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(13),n2h16(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[32,4,27],[nMT,0,nMT],3,1,wf8(:,58))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(14),n2h16(44))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[35,8,20],[nMT,0,nMT],3,2,wf8(:,19),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(1),m3h8x4(:,9),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(9),n2h4(51))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[35,8,20],[nMT,0,nMT],3,2,wf8(:,16),wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,16),G0H4(1),ngZu,m3h8x4(:,10),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(16),n2h4(52))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[35,8,20],[nMT,0,nMT],3,2,wf8(:,20),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(1),m3h8x4(:,11),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(21),n2h4(53))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[35,8,20],[nMT,0,nMT],3,2,wf8(:,18),wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,18),G0H4(1),ngZu,m3h8x4(:,12),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(22),n2h4(54))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[35,4,24],[nMT,0,nMT],3,2,wf8(:,19),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(1),m3h8x4(:,13),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(25),n2h4(55))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[35,4,24],[nMT,0,nMT],3,2,wf8(:,16),wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,16),G0H4(1),ngZu,m3h8x4(:,14),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(2),n2h4(56))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[35,4,24],[nMT,0,nMT],3,2,wf8(:,20),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(1),m3h8x4(:,15),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(11),n2h4(57))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[35,4,24],[nMT,0,nMT],3,2,wf8(:,18),wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,18),G0H4(1),ngZu,m3h8x4(:,16),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H4(1),35,nMT,G1H4(14),n2h4(58))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[39,8,16],[0,nMT,nMT],3,1,wf16(:,22))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,22),G0H2(9),m3h16x2(:,9),heltab2x32(:,:,95))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[39,8,16],[0,nMT,nMT],3,1,wf16(:,24))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,24),G0H2(10),m3h16x2(:,10),heltab2x32(:,:,96))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[43,4,16],[0,nMT,nMT],3,1,wf16(:,26))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,26),G0H2(11),m3h16x2(:,11),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[43,4,16],[0,nMT,nMT],3,1,wf16(:,28))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,28),G0H2(12),m3h16x2(:,12),heltab2x32(:,:,98))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[51,4,8],[nMT,0,nMT],3,1,wf8(:,60))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,60),G0H4(1),ngZu,m3h8x4(:,17),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(17),n2h4(59))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[39,8,16],[0,nMT,nMT],3,1,wf16(:,30))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,30),G0H2(13),m3h16x2(:,13),heltab2x32(:,:,100))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[39,8,16],[0,nMT,nMT],3,1,wf16(:,32))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,32),G0H2(14),m3h16x2(:,14),heltab2x32(:,:,101))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[43,4,16],[0,nMT,nMT],3,1,wf16(:,34))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,34),G0H2(15),m3h16x2(:,15),heltab2x32(:,:,102))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[43,4,16],[0,nMT,nMT],3,1,wf16(:,36))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,36),G0H2(16),m3h16x2(:,16),heltab2x32(:,:,103))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[51,4,8],[nMT,0,nMT],3,1,wf8(:,62))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,62),G0H4(1),ngZu,m3h8x4(:,18),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(23),n2h4(60))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(14),[G0H2(13),G0H2(10),G0H2(9),G0H2(6),G0H2(5),G0H2(2) &
    ,G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(16),[G0H2(15),G0H2(12),G0H2(11),G0H2(8),G0H2(7),G0H2(4) &
    ,G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(21),G1H4(16),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(11),G1H4(2),G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(17)])
  call Hloop_AS_Q(ntryL,G1H2(1),ex5(:),G1H2(21),ngH,m3h1x2(:,9),heltab2x2(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(21),59,nMT,G2H2(2),n2h2(15))
  call Hloop_QS_A(ntryL,G1H2(9),ex5(:),G1H2(2),ngH,m3h1x2(:,10),heltab2x2(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(7),n2h2(16))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,1),G1H2(23),m3h4x2(:,5),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(23),43,nMT,G2H2(1),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H8(2),wf4(:,5),G1H2(16),ngZu,m3h4x2(:,6),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(16),43,nMT,G2H2(4),n2h2(18))
  call Hloop_QA_V(ntryL,G1H16(1),wf8(:,4),G1H2(12),m3h8x2(:,5),heltab2x16(:,:,31))
  call Hloop_QA_V(ntryL,G1H16(2),wf8(:,6),G1H2(8),m3h8x2(:,6),heltab2x16(:,:,32))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,1),G1H2(10),m3h4x2(:,7),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(10),55,nMT,G2H2(10),n2h2(19))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,5),G1H2(22),ngZu,m3h4x2(:,8),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(22),55,nMT,G2H2(11),n2h2(20))
  call Hloop_QA_V(ntryL,G1H16(3),ex4(:),G1H8(3),m3h2x8(:,11),heltab2x16(:,:,33))
  call Hloop_QA_V(ntryL,G1H16(4),ex4(:),G1H8(4),m3h2x8(:,12),heltab2x16(:,:,34))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,1),G1H2(5),m3h4x2(:,9),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(5),39,nMT,G2H2(6),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,5),G1H2(6),ngZu,m3h4x2(:,10),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(6),39,nMT,G2H2(8),n2h2(22))
  call Hloop_AQ_V(ntryL,G1H16(5),wf8(:,8),G1H2(18),m3h8x2(:,7),heltab2x16(:,:,35))
  call Hloop_AQ_V(ntryL,G1H16(6),wf8(:,10),G1H2(28),m3h8x2(:,8),heltab2x16(:,:,36))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,1),G1H2(29),m3h4x2(:,11),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(29),59,nMT,G2H2(9),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H8(12),wf4(:,5),G1H2(30),ngZu,m3h4x2(:,12),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(30),59,nMT,G2H2(5),n2h2(24))
  call Hloop_AQ_V(ntryL,G1H16(7),ex3(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,37))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(8),m3h2x8(:,14),heltab2x16(:,:,38))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,4),G0H1(1),m3h8x1(:,5),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(48),n2h1(161))
  call Hloop_VA_Q(ntryL,G0H8(2),wf8(:,6),G0H1(1),m3h8x1(:,6),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(43),n2h1(162))
  call Hloop_VA_Q(ntryL,G0H8(3),ex4(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G0H4(1),44,nMT,G1H4(6),n2h4(61))
  call Hloop_VA_Q(ntryL,G0H2(14),ex4(:),G0H1(1),m3h2x1(:,61),heltab2x2(:,:,71))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(51),n2h1(163))
  call Hloop_VQ_A(ntryL,G0H8(4),wf8(:,8),G0H1(1),m3h8x1(:,7),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(12),n2h1(164))
  call Hloop_VQ_A(ntryL,G0H8(5),wf8(:,10),G0H1(1),m3h8x1(:,8),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(21),n2h1(165))
  call Hloop_VQ_A(ntryL,G0H8(6),ex3(:),G0H4(1),m3h2x4(:,12),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),44,nMT,G1H4(12),n2h4(62))
  call Hloop_VQ_A(ntryL,G0H2(16),ex3(:),G0H1(1),m3h2x1(:,62),heltab2x2(:,:,72))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(41),n2h1(166))
  call Hloop_QA_V(ntryL,G1H16(9),ex4(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,39))
  call Hloop_QA_V(ntryL,G1H16(10),ex4(:),G1H8(2),m3h2x8(:,16),heltab2x16(:,:,40))
  call Hloop_AQ_V(ntryL,G1H16(11),ex3(:),G1H8(9),m3h2x8(:,17),heltab2x16(:,:,41))
  call Hloop_AQ_V(ntryL,G1H16(12),ex3(:),G1H8(10),m3h2x8(:,18),heltab2x16(:,:,42))
  call Hloop_QA_V(ntryL,G1H16(13),ex4(:),G1H8(5),m3h2x8(:,19),heltab2x16(:,:,43))
  call Hloop_AQ_V(ntryL,G1H16(14),ex3(:),G1H8(6),m3h2x8(:,20),heltab2x16(:,:,44))
  call Hloop_QA_V(ntryL,G1H4(22),ex4(:),G1H2(33),m3h2x2(:,21),heltab2x4(:,:,73))
  call Hloop_AQ_V(ntryL,G1H4(14),ex3(:),G1H2(34),m3h2x2(:,22),heltab2x4(:,:,74))
  call Hloop_AQ_V(ntryL,G1H4(23),ex3(:),G1H2(35),m3h2x2(:,23),heltab2x4(:,:,75))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(49),[G1H1(11)])
call HGT_w2_OLR(G1H1(40),1,1,1)
call HGT_w2_invQ_OLR(G1H1(40),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(40),[G1H1(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(63),[G1H1(33)])
call HGT_w2_OLR(G1H1(13),1,1,1)
call HGT_w2_invQ_OLR(G1H1(13),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(13),[G1H1(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(15),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(37),[G1H1(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(64),[G1H1(14),G1H1(5),G1H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(43),[G1H1(48),G1H1(45),G1H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(57),[G1H1(50),G1H1(39),G1H1(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(36),G1H2(31),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(52),[G1H1(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(21),[G1H1(12),G1H1(59),G1H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(41),[G1H1(4),G1H1(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(51),[G1H1(56),G1H1(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(12),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(18),G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(9)])
  call Hloop_AS_Q(ntryL,G1H1(40),ex5(:),G1H1(20),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMT,G2tensor(2),n2h1(167))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(3),m3h2x1(:,63),heltab2x2(:,:,73))
  call Hloop_QS_A(ntryL,G1H1(13),ex5(:),G1H1(35),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(35),63,nMT,G2tensor(6),n2h1(168))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(10),m3h2x1(:,64),heltab2x2(:,:,74))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(53),m3h2x1(:,65),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(53),63,nMT,G2tensor(11),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(42),m3h2x1(:,66),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(53),n2h1(170))
  call Hloop_VQ_A(ntryL,G1H2(39),ex3(:),G1H1(54),m3h2x1(:,67),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),63,nMT,G2tensor(14),n2h1(171))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(16),m3h2x1(:,68),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMT,G2tensor(15),n2h1(172))
  call Hloop_VQ_A(ntryL,G1H2(43),ex3(:),G1H1(55),m3h2x1(:,69),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),63,nMT,G2tensor(18),n2h1(173))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(25),m3h2x1(:,70),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),63,nMT,G2tensor(19),n2h1(174))
  call Hloop_QS_A(ntryL,G1H1(37),ex5(:),G1H1(58),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(58),63,nMT,G2tensor(68),n2h1(175))
  call Hloop_QS_A(ntryL,G1H1(64),ex5(:),G1H1(17),ngH,m3h1x1(:,68),heltab2x1(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),63,nMT,G2tensor(22),n2h1(176))
  call Hloop_AV_Q(ntryL,G1H4(19),wf4(:,1),G1H1(32),m3h4x1(:,39),heltab2x4(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),63,nMT,G2tensor(23),n2h1(177))
  call Hloop_AV_Q(ntryL,G1H4(20),wf4(:,1),G1H1(26),m3h4x1(:,40),heltab2x4(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),63,nMT,G2tensor(50),n2h1(178))
  call Hloop_AS_Q(ntryL,G1H1(43),ex5(:),G1H1(31),ngH,m3h1x1(:,69),heltab2x1(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),63,nMT,G2tensor(98),n2h1(179))
  call Hloop_AS_Q(ntryL,G1H1(57),ex5(:),G1H1(6),ngH,m3h1x1(:,70),heltab2x1(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(37),n2h1(180))
  call Hloop_AZ_Q(ntryL,G1H4(26),wf4(:,5),G1H1(60),ngZu,m3h4x1(:,41),heltab2x4(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(60),63,nMT,G2tensor(7),n2h1(181))
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,5),G1H1(27),ngZu,m3h4x1(:,42),heltab2x4(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),63,nMT,G2tensor(39),n2h1(182))
  call Hloop_VA_Q(ntryL,G1H2(35),ex4(:),G1H1(61),m3h2x1(:,71),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(61),63,nMT,G2tensor(47),n2h1(183))
  call Hloop_VA_Q(ntryL,G1H2(27),ex4(:),G1H1(29),m3h2x1(:,72),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),63,nMT,G2tensor(113),n2h1(184))
  call Hloop_AS_Q(ntryL,G1H1(52),ex5(:),G1H1(62),ngH,m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(62),63,nMT,G2tensor(59),n2h1(185))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,1),G1H1(38),m3h4x1(:,43),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),63,nMT,G2tensor(119),n2h1(186))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,1),G1H1(65),m3h4x1(:,44),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),63,nMT,G2tensor(62),n2h1(187))
  call Hloop_QS_A(ntryL,G1H1(21),ex5(:),G1H1(23),ngH,m3h1x1(:,72),heltab2x1(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),63,nMT,G2tensor(116),n2h1(188))
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,5),G1H1(3),ngZu,m3h4x1(:,45),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),63,nMT,G2tensor(74),n2h1(189))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,5),G1H1(8),ngZu,m3h4x1(:,46),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,nMT,G2tensor(122),n2h1(190))
  call Hloop_QS_A(ntryL,G1H1(41),ex5(:),G1H1(15),ngH,m3h1x1(:,73),heltab2x1(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),63,nMT,G2tensor(77),n2h1(191))
  call Hloop_AS_Q(ntryL,G1H1(51),ex5(:),G1H1(44),ngH,m3h1x1(:,74),heltab2x1(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),63,nMT,G2tensor(80),n2h1(192))
  call Hloop_VQ_A(ntryL,G1H2(33),wf2(:,2),G1H1(10),m3h2x1(:,73),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),63,nMT,G2tensor(41),n2h1(193))
  call Hloop_VQ_A(ntryL,G1H2(8),wf2(:,2),G1H1(34),m3h2x1(:,74),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),63,nMT,G2tensor(83),n2h1(194))
  call Hloop_VA_Q(ntryL,G1H2(34),wf2(:,4),G1H1(9),m3h2x1(:,75),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMT,G2tensor(86),n2h1(195))
  call Hloop_VA_Q(ntryL,G1H2(28),wf2(:,4),G1H1(28),m3h2x1(:,76),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),63,nMT,G2tensor(44),n2h1(196))
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,31),G1H1(46),ngZu,m3h4x1(:,47),heltab2x4(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(46),63,nMT,G2tensor(89),n2h1(197))
  call Hloop_AZ_Q(ntryL,G1H4(24),wf4(:,31),G1H1(19),ngZu,m3h4x1(:,48),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),63,nMT,G2tensor(92),n2h1(198))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,31),G1H1(47),ngZu,m3h4x1(:,49),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),63,nMT,G2tensor(65),n2h1(199))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,31),G1H1(66),ngZu,m3h4x1(:,50),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(95),n2h1(200))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(110),m3h2x1(:,77),heltab2x2(:,:,87))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(56),m3h2x1(:,78),heltab2x2(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),wf2(:,2),G2tensor(101),m3h2x1(:,79),heltab2x2(:,:,89))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(104),m3h2x1(:,80),heltab2x2(:,:,90))
  call Hloop_VQ_A(ntryL,G1H8(3),wf8(:,35),G1H1(11),m3h8x1(:,9),heltab2x8(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(11),63,nMT,G2tensor(107),n2h1(201))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,36),G1H1(49),m3h8x1(:,10),heltab2x8(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(49),63,nMT,G2tensor(71),n2h1(202))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),wf2(:,4),G2tensor(125),m3h2x1(:,81),heltab2x2(:,:,91))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(126),m3h2x1(:,82),heltab2x2(:,:,92))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,40),G1H1(33),m3h8x1(:,11),heltab2x8(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(33),63,nMT,G2tensor(127),n2h1(203))
  call Hloop_VA_Q(ntryL,G1H8(8),wf8(:,42),G1H1(63),m3h8x1(:,12),heltab2x8(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(63),63,nMT,G2tensor(128),n2h1(204))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,48),G1H1(18),m3h8x1(:,13),heltab2x8(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),63,nMT,G2tensor(129),n2h1(205))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,50),G1H1(14),m3h8x1(:,14),heltab2x8(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),63,nMT,G2tensor(130),n2h1(206))
  call Hloop_VA_Q(ntryL,G1H8(9),wf8(:,52),G1H1(5),m3h8x1(:,15),heltab2x8(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),63,nMT,G2tensor(131),n2h1(207))
  call Hloop_VA_Q(ntryL,G1H8(10),wf8(:,54),G1H1(2),m3h8x1(:,16),heltab2x8(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,nMT,G2tensor(132),n2h1(208))
  call Hloop_VQ_A(ntryL,G1H8(5),wf8(:,56),G1H1(48),m3h8x1(:,17),heltab2x8(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(48),63,nMT,G2tensor(133),n2h1(209))
  call Hloop_VA_Q(ntryL,G1H8(6),wf8(:,58),G1H1(45),m3h8x1(:,18),heltab2x8(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(45),63,nMT,G2tensor(134),n2h1(210))
  call ol_merge_tensors(G2tensor(6),[G2tensor(2),G2tensor(8),G2tensor(4),G1tensor(128),G1tensor(108),G1tensor(103),G1tensor(18) &
    ,G1tensor(2),G1tensor(7),G0tensor(128),G0tensor(108),G0tensor(103),G0tensor(12),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(114),G2tensor(48),G2tensor(12),G1tensor(9),G1tensor(32),G0tensor(22) &
    ,G0tensor(17)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(120),G2tensor(102),G2tensor(60),G2tensor(54),G2tensor(16),G1tensor(117) &
    ,G1tensor(63),G1tensor(58),G1tensor(38),G1tensor(23),G1tensor(29),G0tensor(117),G0tensor(63),G0tensor(58),G0tensor(38) &
    ,G0tensor(32),G0tensor(27)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(117),G2tensor(63),G2tensor(20),G1tensor(42),G1tensor(37),G0tensor(42) &
    ,G0tensor(37)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(123),G2tensor(90),G2tensor(75),G2tensor(69),G2tensor(24),G1tensor(87),G1tensor(78) &
    ,G1tensor(73),G1tensor(52),G1tensor(47),G1tensor(36),G0tensor(87),G0tensor(78),G0tensor(73),G0tensor(52),G0tensor(47) &
    ,G0tensor(18)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(79),G2tensor(13),G2tensor(1),G1tensor(75),G1tensor(60),G1tensor(12),G0tensor(75) &
    ,G0tensor(60),G0tensor(8)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(82),G2tensor(17),G2tensor(5),G1tensor(80),G1tensor(65),G1tensor(6),G0tensor(80) &
    ,G0tensor(65),G0tensor(9)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(115),G2tensor(67),G2tensor(52),G2tensor(46),G2tensor(43),G2tensor(33),G2tensor(27) &
    ,G2tensor(21),G2tensor(9),G1tensor(100),G1tensor(85),G1tensor(70),G1tensor(45),G1tensor(15),G1tensor(8),G0tensor(100) &
    ,G0tensor(85),G0tensor(70),G0tensor(45),G0tensor(25),G0tensor(10)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(91),G2tensor(25),G1tensor(90),G1tensor(10),G0tensor(90),G0tensor(23)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(94),G2tensor(26),G1tensor(95),G1tensor(11),G0tensor(95),G0tensor(24)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(97),G2tensor(28),G1tensor(105),G1tensor(27),G0tensor(105),G0tensor(33)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(92),G2tensor(112),G2tensor(100),G2tensor(35),G2tensor(29),G1tensor(110) &
    ,G1tensor(54),G1tensor(28),G0tensor(110),G0tensor(54),G0tensor(34)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(132),G2tensor(131),G2tensor(128),G2tensor(127),G2tensor(121),G2tensor(58) &
    ,G2tensor(30),G1tensor(115),G1tensor(33),G0tensor(115),G0tensor(35)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(103),G2tensor(31),G1tensor(120),G1tensor(43),G0tensor(120),G0tensor(43)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(106),G2tensor(32),G1tensor(125),G1tensor(44),G0tensor(125),G0tensor(44)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(109),G2tensor(34),G1tensor(130),G1tensor(53),G0tensor(130),G0tensor(53)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(130),G2tensor(129),G2tensor(71),G2tensor(107),G2tensor(124),G2tensor(73) &
    ,G2tensor(36),G1tensor(135),G1tensor(55),G0tensor(135),G0tensor(55)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(42),G2tensor(38),G1tensor(67),G1tensor(25),G0tensor(67),G0tensor(5)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(45),G2tensor(40),G1tensor(82),G1tensor(26),G0tensor(82),G0tensor(15)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(64),G2tensor(51),G2tensor(49),G1tensor(97),G1tensor(40),G1tensor(4),G0tensor(97) &
    ,G0tensor(40),G0tensor(20)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(57),G2tensor(55),G1tensor(112),G1tensor(34),G0tensor(112),G0tensor(30)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(72),G2tensor(70),G1tensor(132),G1tensor(50),G0tensor(132),G0tensor(50)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(78),G1tensor(57),G1tensor(13),G0tensor(57),G0tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(81),G1tensor(62),G1tensor(19),G0tensor(62),G0tensor(4)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(84),G1tensor(72),G1tensor(20),G0tensor(72),G0tensor(13)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(87),G1tensor(77),G1tensor(24),G0tensor(77),G0tensor(14)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(93),G1tensor(92),G1tensor(3),G0tensor(92),G0tensor(19)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(23),G2tensor(96),G1tensor(102),G1tensor(17),G0tensor(102),G0tensor(28)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(62),G2tensor(39),G2tensor(50),G2tensor(111),G2tensor(99),G1tensor(107) &
    ,G1tensor(49),G1tensor(21),G0tensor(107),G0tensor(49),G0tensor(29)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(105),G1tensor(122),G1tensor(39),G0tensor(122),G0tensor(39)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(119),G2tensor(108),G1tensor(127),G1tensor(48),G0tensor(127),G0tensor(48)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(68),G1tensor(59),G0tensor(68),G0tensor(59)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(69),G1tensor(64),G0tensor(69),G0tensor(64)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(83),G1tensor(74),G0tensor(83),G0tensor(74)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(84),G1tensor(79),G0tensor(84),G0tensor(79)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(93),G1tensor(88),G0tensor(93),G0tensor(88)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(68),G1tensor(119),G1tensor(98),G1tensor(89),G0tensor(119),G0tensor(98) &
    ,G0tensor(89)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(22),G1tensor(134),G1tensor(124),G1tensor(114),G1tensor(109),G1tensor(99) &
    ,G1tensor(94),G0tensor(134),G0tensor(124),G0tensor(114),G0tensor(109),G0tensor(99),G0tensor(94)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(113),G1tensor(104),G0tensor(113),G0tensor(104)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(123),G1tensor(118),G0tensor(123),G0tensor(118)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(133),G1tensor(129),G0tensor(133),G0tensor(129)])
  call TI_triangle_red(G2tensor(6),RedBasis(19),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMT], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(104),RedBasis(55),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMT], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(47),RedBasis(6),mass3set(:,3),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMT], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(126),RedBasis(56),mass3set(:,2),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nMT], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(18),RedBasis(9),mass3set(:,3),G0tensor(101),G0tensor(106),G0tensor(111), &
    G0tensor(116),M2L1R1,[nMT],G0tensor(121))
  call TI_triangle_red(G2tensor(85),RedBasis(4),mass3set(:,1),G0tensor(126),G0tensor(131),G0tensor(128), &
    G0tensor(108),M2L1R1,[nMT],G0tensor(103))
  call TI_triangle_red(G2tensor(88),RedBasis(2),mass3set(:,1),G0tensor(12),G0tensor(7),G0tensor(2),G0tensor(22),M2L1R1,[nMT], &
    G0tensor(17))
  call TI_triangle_red(G2tensor(118),RedBasis(1),mass3set(:,1),G0tensor(117),G0tensor(63),G0tensor(58),G0tensor(38),M2L1R1,[nMT], &
    G0tensor(32))
  call TI_triangle_red(G2tensor(41),RedBasis(12),mass3set(:,3),G0tensor(27),G0tensor(42),G0tensor(37),G0tensor(87),M2L1R1,[nMT], &
    G0tensor(78))
  call TI_triangle_red(G2tensor(83),RedBasis(10),mass3set(:,3),G0tensor(73),G0tensor(52),G0tensor(47),G0tensor(18),M2L1R1,[nMT], &
    G0tensor(75))
  call TI_triangle_red(G2tensor(89),RedBasis(17),mass3set(:,4),G0tensor(60),G0tensor(8),G0tensor(80),G0tensor(65),M2L1R1,[nMT], &
    G0tensor(9))
  call TI_triangle_red(G2tensor(95),RedBasis(16),mass3set(:,1),G0tensor(100),G0tensor(85),G0tensor(70),G0tensor(45),M2L1R1,[nMT], &
    G0tensor(25))
  call TI_triangle_red(G2tensor(134),RedBasis(15),mass3set(:,3),G0tensor(10),G0tensor(90),G0tensor(23),G0tensor(95),M2L1R1,[nMT], &
    G0tensor(24))
  call TI_triangle_red(G2tensor(86),RedBasis(21),mass3set(:,3),G0tensor(105),G0tensor(33),G0tensor(110),G0tensor(54),M2L1R1,[nMT], &
    G0tensor(34))
  call TI_triangle_red(G2tensor(44),RedBasis(20),mass3set(:,3),G0tensor(115),G0tensor(35),G0tensor(120),G0tensor(43),M2L1R1,[nMT], &
    G0tensor(125))
  call TI_triangle_red(G2tensor(65),RedBasis(24),mass3set(:,4),G0tensor(44),G0tensor(130),G0tensor(53),G0tensor(135),M2L1R1,[nMT], &
    G0tensor(55))
  call TI_triangle_red(G2tensor(133),RedBasis(23),mass3set(:,3),G0tensor(67),G0tensor(5),G0tensor(82),G0tensor(15),M2L1R1,[nMT], &
    G0tensor(97))
  call TI_triangle_red(G2tensor(101),RedBasis(41),mass3set(:,2),G0tensor(40),G0tensor(20),G0tensor(112),G0tensor(30),M2L1R1,[nMT], &
    G0tensor(132))
  call TI_triangle_red(G2tensor(125),RedBasis(44),mass3set(:,2),G0tensor(50),G0tensor(57),G0tensor(3),G0tensor(62),M2L1R1,[nMT], &
    G0tensor(4))
  call TI_triangle_red(G2tensor(66),RedBasis(47),mass3set(:,1),G0tensor(72),G0tensor(13),G0tensor(77),G0tensor(14),M2L1R1,[nMT], &
    G0tensor(92))
  call TI_triangle_red(G2tensor(61),RedBasis(49),mass3set(:,3),G0tensor(19),G0tensor(102),G0tensor(28),G0tensor(107),M2L1R1,[nMT], &
    G0tensor(49))
  call TI_triangle_red(G2tensor(76),RedBasis(53),mass3set(:,3),G0tensor(29),G0tensor(122),G0tensor(39),G0tensor(127),M2L1R1,[nMT], &
    G0tensor(48))
  call TI_triangle_red(G2tensor(110),RedBasis(43),mass3set(:,2),G0tensor(68),G0tensor(59),G0tensor(69),G0tensor(64),M2L1R1,[nMT], &
    G0tensor(83))
  call TI_triangle_red(G2tensor(3),RedBasis(42),mass3set(:,2),G0tensor(74),G0tensor(84),G0tensor(79),G0tensor(93),M2L1R1,[nMT], &
    G0tensor(88))
  call TI_triangle_red(G2tensor(56),RedBasis(46),mass3set(:,2),G0tensor(119),G0tensor(98),G0tensor(89),G0tensor(134),M2L1R1,[nMT], &
    G0tensor(124))
  call TI_triangle_red(G2tensor(10),RedBasis(45),mass3set(:,2),G0tensor(114),G0tensor(109),G0tensor(99),G0tensor(94),M2L1R1,[nMT], &
    G0tensor(113))
  call TI_triangle_red(G2tensor(19),RedBasis(48),mass3set(:,3),G0tensor(104),G0tensor(123),G0tensor(118), &
    G0tensor(133),M2L1R1,[nMT],G0tensor(129))
  call TI_triangle_red(G2tensor(7),RedBasis(51),mass3set(:,4),G0tensor(136),G0tensor(137),G0tensor(138), &
    G0tensor(139),M2L1R1,[nMT],G0tensor(140))
  call TI_triangle_red(G2tensor(122),RedBasis(50),mass3set(:,1),G0tensor(141),G0tensor(142),G0tensor(143), &
    G0tensor(144),M2L1R1,[nMT],G0tensor(145))
  call TI_triangle_red(G2tensor(113),RedBasis(52),mass3set(:,3),G0tensor(146),G0tensor(147),G0tensor(148), &
    G0tensor(149),M2L1R1,[nMT],G0tensor(150))
  call TI_triangle_red(G2tensor(74),RedBasis(54),mass3set(:,4),G0tensor(151),G0tensor(152),G0tensor(153), &
    G0tensor(154),M2L1R1,[nMT],G0tensor(155))
  call TI_triangle_red(G2tensor(11),RedBasis(5),mass3set(:,3),G0tensor(156),G0tensor(157),G0tensor(158), &
    G0tensor(159),M2L1R1,[nMT],G0tensor(160))
  call TI_triangle_red(G2tensor(53),RedBasis(3),mass3set(:,3),G0tensor(161),G0tensor(162),G0tensor(163), &
    G0tensor(164),M2L1R1,[nMT],G0tensor(165))
  call TI_triangle_red(G2tensor(14),RedBasis(8),mass3set(:,3),G0tensor(166),G0tensor(167),G0tensor(168), &
    G0tensor(169),M2L1R1,[nMT],G0tensor(170))
  call TI_triangle_red(G2tensor(15),RedBasis(7),mass3set(:,3),G0tensor(171),G0tensor(172),G0tensor(173), &
    G0tensor(174),M2L1R1,[nMT],G0tensor(175))
  call TI_triangle_red(G2tensor(77),RedBasis(14),mass3set(:,4),G0tensor(176),G0tensor(177),G0tensor(178), &
    G0tensor(179),M2L1R1,[nMT],G0tensor(180))
  call TI_triangle_red(G2tensor(59),RedBasis(13),mass3set(:,1),G0tensor(181),G0tensor(182),G0tensor(183), &
    G0tensor(184),M2L1R1,[nMT],G0tensor(185))
  call TI_triangle_red(G2tensor(37),RedBasis(11),mass3set(:,1),G0tensor(186),G0tensor(187),G0tensor(188), &
    G0tensor(189),M2L1R1,[nMT],G0tensor(190))
  call TI_triangle_red(G2tensor(98),RedBasis(18),mass3set(:,4),G0tensor(191),G0tensor(192),G0tensor(193), &
    G0tensor(194),M2L1R1,[nMT],G0tensor(195))
  call TI_triangle_red(G2tensor(80),RedBasis(22),mass3set(:,4),G0tensor(196),G0tensor(197),G0tensor(198), &
    G0tensor(199),M2L1R1,[nMT],G0tensor(200))
  call TI_triangle_red(G2tensor(116),RedBasis(25),mass3set(:,4),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nMT],G0tensor(205))
  call ol_merge_tensors(T0sum(28),[G0tensor(1)])
  call ol_merge_tensors(T0sum(29),[G0tensor(26)])
  call ol_merge_tensors(T0sum(30),[G0tensor(51)])
  call ol_merge_tensors(T0sum(31),[G0tensor(76)])
  call ol_merge_tensors(T0sum(32),[G0tensor(101)])
  call ol_merge_tensors(T0sum(33),[G0tensor(126)])
  call ol_merge_tensors(T0sum(34),[G0tensor(12)])
  call ol_merge_tensors(T0sum(35),[G0tensor(117)])
  call ol_merge_tensors(T0sum(36),[G0tensor(27)])
  call ol_merge_tensors(T0sum(37),[G0tensor(73)])
  call ol_merge_tensors(T0sum(38),[G0tensor(60)])
  call ol_merge_tensors(T0sum(39),[G0tensor(100)])
  call ol_merge_tensors(T0sum(40),[G0tensor(10)])
  call ol_merge_tensors(T0sum(41),[G0tensor(105)])
  call ol_merge_tensors(T0sum(42),[G0tensor(115)])
  call ol_merge_tensors(T0sum(43),[G0tensor(44)])
  call ol_merge_tensors(T0sum(44),[G0tensor(67)])
  call ol_merge_tensors(T0sum(45),[G0tensor(40)])
  call ol_merge_tensors(T0sum(46),[G0tensor(50)])
  call ol_merge_tensors(T0sum(47),[G0tensor(72)])
  call ol_merge_tensors(T0sum(48),[G0tensor(19)])
  call ol_merge_tensors(T0sum(49),[G0tensor(29)])
  call ol_merge_tensors(T0sum(50),[G0tensor(68)])
  call ol_merge_tensors(T0sum(51),[G0tensor(74)])
  call ol_merge_tensors(T0sum(52),[G0tensor(119)])
  call ol_merge_tensors(T0sum(53),[G0tensor(114)])
  call ol_merge_tensors(T0sum(54),[G0tensor(104)])
  call ol_merge_tensors(T0sum(55),[G0tensor(136)])
  call ol_merge_tensors(T0sum(56),[G0tensor(141)])
  call ol_merge_tensors(T0sum(57),[G0tensor(146)])
  call ol_merge_tensors(T0sum(58),[G0tensor(151)])
  call ol_merge_tensors(T0sum(59),[G0tensor(156)])
  call ol_merge_tensors(T0sum(60),[G0tensor(161)])
  call ol_merge_tensors(T0sum(61),[G0tensor(166)])
  call ol_merge_tensors(T0sum(62),[G0tensor(171)])
  call ol_merge_tensors(T0sum(63),[G0tensor(176)])
  call ol_merge_tensors(T0sum(64),[G0tensor(181)])
  call ol_merge_tensors(T0sum(65),[G0tensor(186)])
  call ol_merge_tensors(T0sum(66),[G0tensor(191)])
  call ol_merge_tensors(T0sum(67),[G0tensor(196)])
  call ol_merge_tensors(T0sum(68),[G0tensor(201)])
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[40,23],[0,nMT],2,2,wf4(:,3),wf8(:,35))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,27),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[40,23],[0,nMT],2,2,wf4(:,3),wf8(:,36))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,28),heltab2x32(:,:,106))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[43,20],[nMT,0],2,2,wf16(:,8),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,8),G0H2(13),m3h16x2(:,17),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H2(13),43,nMT,G1H2(38),n2h2(25))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[43,20],[nMT,0],2,2,wf16(:,10),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,10),G0H2(10),m3h16x2(:,18),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H2(10),43,nMT,G1H2(13),n2h2(26))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[52,11],[nMT,0],2,2,wf4(:,28),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,28),G0H8(2),m3h4x8(:,29),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(2),52,nMT,G1H8(11),n2h8(17))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[52,11],[nMT,0],2,2,wf4(:,28),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,28),G0H8(3),m3h4x8(:,30),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G0H8(3),52,nMT,G1H8(12),n2h8(18))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[43,20],[nMT,0],2,2,wf16(:,18),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,18),G0H2(9),m3h16x2(:,19),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H2(9),43,nMT,G1H2(14),n2h2(27))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[43,20],[nMT,0],2,2,wf16(:,20),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,20),G0H2(6),m3h16x2(:,20),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H2(6),43,nMT,G1H2(40),n2h2(28))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[39,24],[nMT,0],2,2,wf16(:,11),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf16(:,11),G0H2(5),m3h16x2(:,21),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H2(5),39,nMT,G1H2(41),n2h2(29))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[39,24],[nMT,0],2,2,wf16(:,12),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf16(:,12),G0H2(2),m3h16x2(:,22),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H2(2),39,nMT,G1H2(42),n2h2(30))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[36,27],[0,nMT],2,2,wf4(:,8),wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(4),m3h4x8(:,31),heltab2x32(:,:,115))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[36,27],[0,nMT],2,2,wf4(:,8),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(5),m3h4x8(:,32),heltab2x32(:,:,116))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[39,24],[nMT,0],2,2,wf16(:,14),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf16(:,14),G0H2(1),m3h16x2(:,23),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H2(1),39,nMT,G1H2(45),n2h2(31))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[39,24],[nMT,0],2,2,wf16(:,16),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf16(:,16),G0H2(15),m3h16x2(:,24),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H2(15),39,nMT,G1H2(24),n2h2(32))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[56,7],[nMT,0],2,2,wf4(:,35),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,35),G0H8(6),m3h4x8(:,33),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H8(6),56,nMT,G1H8(3),n2h8(19))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[56,7],[nMT,0],2,2,wf4(:,35),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,35),G0H8(2),m3h4x8(:,34),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H8(2),56,nMT,G1H8(4),n2h8(20))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[52,11],[nMT,0],2,2,wf4(:,32),wf8(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,32),G0H8(3),m3h4x8(:,35),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G0H8(3),52,nMT,G1H8(7),n2h8(21))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[52,11],[nMT,0],2,2,wf4(:,32),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,32),G0H8(6),m3h4x8(:,36),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(6),52,nMT,G1H8(8),n2h8(22))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[36,27],[0,nMT],2,2,wf4(:,8),wf8(:,52))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(2),m3h4x8(:,37),heltab2x32(:,:,123))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[36,27],[0,nMT],2,2,wf4(:,8),wf8(:,54))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(3),m3h4x8(:,38),heltab2x32(:,:,124))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[36,27],[0,nMT],2,2,wf4(:,8),wf8(:,58))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(6),m3h4x8(:,39),heltab2x32(:,:,125))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[40,23],[0,nMT],2,2,wf4(:,3),wf8(:,48))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(8),m3h4x8(:,40),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[40,23],[0,nMT],2,2,wf4(:,3),wf8(:,50))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(9),m3h4x8(:,41),heltab2x32(:,:,127))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[56,7],[nMT,0],2,2,wf4(:,38),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,38),G0H8(10),m3h4x8(:,42),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H8(10),56,nMT,G1H8(1),n2h8(23))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[56,7],[nMT,0],2,2,wf4(:,38),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,38),G0H8(10),m3h4x8(:,43),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H8(10),56,nMT,G1H8(2),n2h8(24))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[40,23],[nMT,0],2,2,wf4(:,3),wf8(:,56))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(10),m3h4x8(:,44),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H8(10),40,nMT,G1H8(9),n2h8(25))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[43,20],[nMT,0],2,2,wf16(:,26),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,26),G0H2(12),m3h16x2(:,25),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H2(12),43,nMT,G1H2(25),n2h2(33))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[43,20],[nMT,0],2,2,wf16(:,28),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,28),G0H2(11),m3h16x2(:,26),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H2(11),43,nMT,G1H2(47),n2h2(34))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[43,20],[nMT,0],2,2,wf16(:,34),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,34),G0H2(8),m3h16x2(:,27),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H2(8),43,nMT,G1H2(48),n2h2(35))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[43,20],[nMT,0],2,2,wf16(:,36),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,36),G0H2(7),m3h16x2(:,28),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H2(7),43,nMT,G1H2(49),n2h2(36))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[39,24],[0,nMT],2,2,wf16(:,22),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,22),G0H2(4),m3h16x2(:,29),heltab2x32(:,:,135))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[39,24],[0,nMT],2,2,wf16(:,24),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,24),G0H2(3),m3h16x2(:,30),heltab2x32(:,:,136))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[39,24],[0,nMT],2,2,wf16(:,30),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,30),G0H2(14),m3h16x2(:,31),heltab2x32(:,:,137))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[39,24],[0,nMT],2,2,wf16(:,32),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,32),G0H2(16),m3h16x2(:,32),heltab2x32(:,:,138))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(49),[G1H2(48),G1H2(47),G1H2(25),G1H2(40),G1H2(14) &
    ,G1H2(13),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(45),G1H2(42),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(16),[G0H2(14),G0H2(3),G0H2(4)])
  call Hloop_VQ_A(ntryL,G0H8(7),wf8(:,35),G0H1(1),m3h8x1(:,19),heltab2x8(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(1),n2h1(211))
  call Hloop_VQ_A(ntryL,G0H8(1),wf8(:,36),G0H1(1),m3h8x1(:,20),heltab2x8(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(31),n2h1(212))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H2(49),wf2(:,2),G1tensor(14),m3h2x1(:,83),heltab2x2(:,:,93))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(7),wf8(:,4),G1tensor(30),m3h8x1(:,21),heltab2x8(:,:,45))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(8),wf8(:,6),G1tensor(5),m3h8x1(:,22),heltab2x8(:,:,46))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H2(24),wf2(:,4),G1tensor(16),m3h2x1(:,84),heltab2x2(:,:,94))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,40),G0H1(1),m3h8x1(:,23),heltab2x8(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(22),n2h1(213))
  call Hloop_VA_Q(ntryL,G0H8(5),wf8(:,42),G0H1(1),m3h8x1(:,24),heltab2x8(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(35),n2h1(214))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(1),wf8(:,8),G1tensor(41),m3h8x1(:,25),heltab2x8(:,:,49))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(2),wf8(:,10),G1tensor(46),m3h8x1(:,26),heltab2x8(:,:,50))
  call Hloop_VA_Q(ntryL,G0H8(2),wf8(:,52),G0H1(1),m3h8x1(:,27),heltab2x8(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(51),n2h1(215))
  call Hloop_VA_Q(ntryL,G0H8(3),wf8(:,54),G0H1(1),m3h8x1(:,28),heltab2x8(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(56),n2h1(216))
  call Hloop_VA_Q(ntryL,G0H8(6),wf8(:,58),G0H1(1),m3h8x1(:,29),heltab2x8(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(61),n2h1(217))
  call Hloop_VQ_A(ntryL,G0H8(8),wf8(:,48),G0H1(1),m3h8x1(:,30),heltab2x8(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(66),n2h1(218))
  call Hloop_VQ_A(ntryL,G0H8(9),wf8(:,50),G0H1(1),m3h8x1(:,31),heltab2x8(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(71),n2h1(219))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,56),G1tensor(76),m3h8x1(:,32),heltab2x8(:,:,56))
  call Hloop_VA_Q(ntryL,G0H2(16),wf2(:,4),G0H1(1),m3h2x1(:,85),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(81),n2h1(220))
  call ol_merge_tensors(G0tensor(153),[G0tensor(143),G0tensor(138),G0tensor(13),G0tensor(57),G0tensor(20),G0tensor(63) &
    ,G0tensor(81),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G0tensor(203),[G0tensor(198),G0tensor(193),G0tensor(188),G0tensor(183),G0tensor(178),G0tensor(98) &
    ,G0tensor(59),G0tensor(131),G0tensor(11)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(84),G0tensor(53),G0tensor(70),G0tensor(80),G0tensor(7),G0tensor(16)])
  call ol_merge_tensors(G0tensor(205),[G0tensor(200),G0tensor(195),G0tensor(190),G0tensor(185),G0tensor(180),G0tensor(175) &
    ,G0tensor(170),G0tensor(165),G0tensor(160),G0tensor(155),G0tensor(150),G0tensor(145),G0tensor(140),G0tensor(129),G0tensor(113) &
    ,G0tensor(124),G0tensor(88),G0tensor(83),G0tensor(48),G0tensor(49),G0tensor(92),G0tensor(4),G0tensor(132),G0tensor(97) &
    ,G0tensor(55),G0tensor(125),G0tensor(34),G0tensor(24),G0tensor(25),G0tensor(9),G0tensor(75),G0tensor(78),G0tensor(32) &
    ,G0tensor(17),G0tensor(103),G0tensor(121),G0tensor(96),G0tensor(71),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(89),G0tensor(122),G0tensor(5),G0tensor(42),G0tensor(106),G0tensor(36)])
  call ol_merge_tensors(G1tensor(5),[G1tensor(30),G0tensor(123),G0tensor(52),G0tensor(41)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(69),G0tensor(102),G0tensor(33),G0tensor(90),G0tensor(86),G0tensor(56)])
  call ol_merge_tensors(G0tensor(197),[G0tensor(163),G0tensor(158),G0tensor(148),G0tensor(137),G0tensor(8),G0tensor(61)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(142),G0tensor(77),G0tensor(85),G0tensor(2),G0tensor(128),G0tensor(116) &
    ,G0tensor(66)])
  call ol_merge_tensors(G1tensor(46),[G1tensor(41),G0tensor(147),G0tensor(35),G0tensor(91)])
  call ol_merge_tensors(G0tensor(177),[G0tensor(173),G0tensor(168),G0tensor(152),G0tensor(118),G0tensor(130),G0tensor(111)])
  call ol_merge_tensors(G0tensor(184),[G0tensor(169),G0tensor(159),G0tensor(54),G0tensor(87),G0tensor(58),G0tensor(108)])
  call ol_merge_tensors(G0tensor(189),[G0tensor(174),G0tensor(164),G0tensor(15),G0tensor(43),G0tensor(95),G0tensor(45) &
    ,G0tensor(18),G0tensor(38),G0tensor(22)])
  call ol_merge_tensors(G0tensor(179),[G0tensor(47),G0tensor(37)])
  call ol_merge_tensors(G1tensor(61),[G1tensor(56),G1tensor(51),G1tensor(35),G1tensor(22),G0tensor(194),G0tensor(23) &
    ,G0tensor(65)])
  call ol_merge_tensors(G1tensor(81),[G0tensor(199),G0tensor(120),G0tensor(110)])
  call ol_merge_tensors(G1tensor(71),[G1tensor(66),G1tensor(31),G1tensor(1),G0tensor(204),G0tensor(82),G0tensor(135)])
  call ol_merge_tensors(G1tensor(14),[G0tensor(157),G0tensor(64),G0tensor(112)])
  call ol_merge_tensors(G1tensor(76),[G0tensor(162),G0tensor(93),G0tensor(30)])
  call ol_merge_tensors(G1tensor(16),[G0tensor(167),G0tensor(134),G0tensor(3)])
  call ol_merge_tensors(G0tensor(172),[G0tensor(94),G0tensor(62)])
  call ol_merge_tensors(G0tensor(187),[G0tensor(149),G0tensor(144),G0tensor(133),G0tensor(127),G0tensor(107),G0tensor(14)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(139),G0tensor(28)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(154),G0tensor(39)])
call TI_bubble_red(G1tensor(5),52,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(46),56,mass2set(:,1),G0tensor(51),M2L1R1,G0tensor(76))
call TI_bubble_red(G1tensor(61),36,mass2set(:,2),G0tensor(101),M2L1R1,G0tensor(126))
call TI_bubble_red(G1tensor(81),39,mass2set(:,2),G0tensor(12),M2L1R1,G0tensor(117))
call TI_bubble_red(G1tensor(71),40,mass2set(:,2),G0tensor(27),M2L1R1,G0tensor(73))
call TI_bubble_red(G1tensor(14),43,mass2set(:,1),G0tensor(60),M2L1R1,G0tensor(100))
call TI_bubble_red(G1tensor(76),40,mass2set(:,1),G0tensor(10),M2L1R1,G0tensor(105))
call TI_bubble_red(G1tensor(16),39,mass2set(:,1),G0tensor(115),M2L1R1,G0tensor(44))
  call ol_merge_tensors(G0tensor(44),[G0tensor(105),G0tensor(100),G0tensor(73),G0tensor(117),G0tensor(126),G0tensor(76) &
    ,G0tensor(26),G0tensor(205)])
  call ol_merge_tensors(T0sum(69),[G0tensor(153)])
  call ol_merge_tensors(T0sum(70),[G0tensor(203)])
  call ol_merge_tensors(T0sum(71),[G0tensor(109)])
  call ol_merge_tensors(T0sum(72),[G0tensor(44)])
  call ol_merge_tensors(T0sum(73),[G0tensor(99)])
  call ol_merge_tensors(T0sum(74),[G0tensor(1)])
  call ol_merge_tensors(T0sum(75),[G0tensor(79)])
  call ol_merge_tensors(T0sum(76),[G0tensor(197)])
  call ol_merge_tensors(T0sum(77),[G0tensor(182)])
  call ol_merge_tensors(T0sum(78),[G0tensor(51)])
  call ol_merge_tensors(T0sum(79),[G0tensor(177)])
  call ol_merge_tensors(T0sum(80),[G0tensor(184)])
  call ol_merge_tensors(T0sum(81),[G0tensor(189)])
  call ol_merge_tensors(T0sum(82),[G0tensor(179)])
  call ol_merge_tensors(T0sum(83),[G0tensor(101)])
  call ol_merge_tensors(T0sum(84),[G0tensor(12)])
  call ol_merge_tensors(T0sum(85),[G0tensor(27)])
  call ol_merge_tensors(T0sum(86),[G0tensor(60)])
  call ol_merge_tensors(T0sum(87),[G0tensor(10)])
  call ol_merge_tensors(T0sum(88),[G0tensor(115)])
  call ol_merge_tensors(T0sum(89),[G0tensor(172)])
  call ol_merge_tensors(T0sum(90),[G0tensor(187)])
  call ol_merge_tensors(T0sum(91),[G0tensor(192)])
  call ol_merge_tensors(T0sum(92),[G0tensor(202)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 35, 51, 55 ],masses2_10,RedSet_4(6),ScalarBoxes(1))
  call compute_scalar_box([ 32, 51, 55 ],masses2_10,RedSet_4(7),ScalarBoxes(2))
  call compute_scalar_box([ 32, 35, 55 ],masses2_10,RedSet_4(8),ScalarBoxes(3))
  call compute_scalar_box([ 32, 35, 51 ],masses2_12,RedSet_4(1),ScalarBoxes(4))
  call compute_scalar_box([ 3, 19, 23 ],masses2_10,RedSet_4(9),ScalarBoxes(5))
  call compute_scalar_box([ 35, 51, 59 ],masses2_10,RedSet_4(10),ScalarBoxes(6))
  call compute_scalar_box([ 32, 51, 59 ],masses2_10,RedSet_4(11),ScalarBoxes(7))
  call compute_scalar_box([ 32, 35, 59 ],masses2_10,RedSet_4(12),ScalarBoxes(8))
  call compute_scalar_box([ 3, 19, 27 ],masses2_10,RedSet_4(13),ScalarBoxes(9))
  call compute_scalar_box([ 35, 43, 47 ],masses2_9,RedSet_4(14),ScalarBoxes(10))
  call compute_scalar_box([ 32, 43, 47 ],masses2_9,RedSet_4(15),ScalarBoxes(11))
  call compute_scalar_box([ 32, 35, 47 ],masses2_12,RedSet_4(16),ScalarBoxes(12))
  call compute_scalar_box([ 32, 35, 43 ],masses2_10,RedSet_4(2),ScalarBoxes(13))
  call compute_scalar_box([ 3, 11, 15 ],masses2_9,RedSet_4(17),ScalarBoxes(14))
  call compute_scalar_box([ 36, 44, 47 ],masses2_8,RedSet_4(18),ScalarBoxes(15))
  call compute_scalar_box([ 32, 44, 47 ],masses2_12,RedSet_4(19),ScalarBoxes(16))
  call compute_scalar_box([ 32, 36, 47 ],masses2_9,RedSet_4(20),ScalarBoxes(17))
  call compute_scalar_box([ 32, 36, 44 ],masses2_9,RedSet_4(3),ScalarBoxes(18))
  call compute_scalar_box([ 4, 12, 15 ],masses2_8,RedSet_4(21),ScalarBoxes(19))
  call compute_scalar_box([ 35, 39, 47 ],masses2_9,RedSet_4(22),ScalarBoxes(20))
  call compute_scalar_box([ 32, 39, 47 ],masses2_9,RedSet_4(23),ScalarBoxes(21))
  call compute_scalar_box([ 32, 35, 39 ],masses2_10,RedSet_4(4),ScalarBoxes(22))
  call compute_scalar_box([ 3, 7, 15 ],masses2_9,RedSet_4(24),ScalarBoxes(23))
  call compute_scalar_box([ 40, 44, 47 ],masses2_8,RedSet_4(25),ScalarBoxes(24))
  call compute_scalar_box([ 32, 40, 47 ],masses2_9,RedSet_4(26),ScalarBoxes(25))
  call compute_scalar_box([ 32, 40, 44 ],masses2_9,RedSet_4(5),ScalarBoxes(26))
  call compute_scalar_box([ 8, 12, 15 ],masses2_8,RedSet_4(27),ScalarBoxes(27))
! end of process


end subroutine vamp_1

end module ol_vamp_1_eehvtt_eexttxha_1_/**/REALKIND
