
module ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  3]
  K1( 2,:) = [  0]
  K1( 3,:) = [  0]
  K1( 4,:) = [  0]
  K1( 5,:) = [  0]
  K1( 6,:) = [  0]
  K1( 7,:) = [  4]
  K1( 8,:) = [  0]
  K1( 9,:) = [  0]
  K1(10,:) = [ -4]
  K1(11,:) = [  4]
  K1(12,:) = [  0]
  K1(13,:) = [  0]
  K1(14,:) = [  0]
  K1(15,:) = [  0]
  K1(16,:) = [  0]
  K1(17,:) = [  0]
  K1(18,:) = [  0]
  K1(19,:) = [  0]
  K1(20,:) = [  0]
  K1(21,:) = [  0]
  K1(22,:) = [  0]
  K1(23,:) = [  0]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND



module ol_forced_parameters_eehvtt_eexttxha_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (YE /= 0) write(*,101) 'YE = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_eehvtt_eexttxha_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_eehvtt_eexttxha_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 32 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(167)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,12), wf4(4,63), wf8(8,62), wf16(16,36), wf32(32,116)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(22), c(5)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_eehvtt_eexttxha_1_/**/REALKIND






! **********************************************************************
module ol_loop_eehvtt_eexttxha_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_eehvtt_eexttxha_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**4*lambdaHZZ*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 2) = (CI*eQED**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 3) = (2*CI*countertermnorm*eQED**4*gQCD**2*lambdaHZZ*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 4) = (2*CI*countertermnorm*ctVtt*eQED**4*gQCD**2*lambdaHZZ*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 5) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2*lambdaHZZ*MW)/(cw**2*sw)
    f( 6) = (2*eQED**4*gQCD**2*integralnorm*lambdaHZZ*MW*SwB)/(cw**2*sw*3._/**/REALKIND)
    f( 7) = (eQED**4*gQCD**2*integralnorm*lambdaHZZ*MW*SwB)/(cw**2*sw)
    f( 8) = (2*CI*eQED**4*YT)/(9._/**/REALKIND*MW*sw)
    f( 9) = (CI*eQED**4*YT)/(3._/**/REALKIND*MW*sw)
    f(10) = (CI*eQED**4*YT)/(2._/**/REALKIND*MW*sw)
    f(11) = (2*CI*countertermnorm*eQED**4*gQCD**2*YT)/(9._/**/REALKIND*MW*sw)
    f(12) = (CI*countertermnorm*eQED**4*gQCD**2*YT)/(3._/**/REALKIND*MW*sw)
    f(13) = (CI*countertermnorm*eQED**4*gQCD**2*YT)/(2._/**/REALKIND*MW*sw)
    f(14) = (2*CI*countertermnorm*ctStt*eQED**4*gQCD**2*YT)/(9._/**/REALKIND*MW*sw)
    f(15) = (CI*countertermnorm*ctStt*eQED**4*gQCD**2*YT)/(3._/**/REALKIND*MW*sw)
    f(16) = (CI*countertermnorm*ctStt*eQED**4*gQCD**2*YT)/(2._/**/REALKIND*MW*sw)
    f(17) = (2*CI*countertermnorm*ctVtt*eQED**4*gQCD**2*YT)/(9._/**/REALKIND*MW*sw)
    f(18) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2*YT)/(3._/**/REALKIND*MW*sw)
    f(19) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2*YT)/(2._/**/REALKIND*MW*sw)
    f(20) = (2*eQED**4*gQCD**2*integralnorm*SwB*YT)/(MW*sw*9._/**/REALKIND)
    f(21) = (eQED**4*gQCD**2*integralnorm*SwB*YT)/(MW*sw*3._/**/REALKIND)
    f(22) = (eQED**4*gQCD**2*integralnorm*SwB*YT)/(MW*sw*2._/**/REALKIND)

  c = [ 4*f(6), 4*f(7), 4*f(20), 4*f(21), 4*f(22) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20) - MT2)+L(6,20))
  den(3) = 1 /((L(5,40) - MT2)+L(6,40))
  den(6) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,11) - MT2)+L(6,11))
  den(14) = 1 /((L(5,36) - MT2)+L(6,36))
  den(15) = 1 /((L(5,24) - MT2)+L(6,24))
  den(20) = 1 /((L(5,7) - MT2)+L(6,7))
  den(27) = 1 /((L(5,44) - MZ2)+L(6,44))
  den(34) = 1 /((L(5,33))+L(6,33))
  den(35) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(36) = 1 /((L(5,35) - MZ2)+L(6,35))
  den(39) = 1 /((L(5,34))+L(6,34))
  den(42) = 1 /((L(5,35))+L(6,35))
  den(53) = 1 /((L(5,52) - MT2)+L(6,52))
  den(57) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(63) = 1 /((L(5,56) - MT2)+L(6,56))
  den(72) = 1 /((L(5,43) - MT2)+L(6,43))
  den(78) = 1 /((L(5,23) - MT2)+L(6,23))
  den(89) = 1 /((L(5,27) - MT2)+L(6,27))
  den(95) = 1 /((L(5,39) - MT2)+L(6,39))
  den(139) = 1 /((L(5,51) - MZ2)+L(6,51))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(12) = den(6)*den(9)
  den(13) = den(2)*den(12)
  den(16) = den(1)*den(14)
  den(17) = den(15)*den(16)
  den(18) = den(6)*den(14)
  den(19) = den(15)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(15)*den(21)
  den(23) = den(6)*den(20)
  den(24) = den(15)*den(23)
  den(25) = den(10)*den(14)
  den(26) = den(12)*den(14)
  den(28) = den(14)*den(27)
  den(29) = den(6)*den(28)
  den(30) = den(3)*den(21)
  den(31) = den(3)*den(23)
  den(32) = den(3)*den(27)
  den(33) = den(6)*den(32)
  den(37) = den(34)*den(36)
  den(38) = den(35)*den(37)
  den(40) = den(36)*den(39)
  den(41) = den(35)*den(40)
  den(43) = den(34)*den(42)
  den(44) = den(2)*den(43)
  den(45) = den(2)*den(37)
  den(46) = den(39)*den(42)
  den(47) = den(2)*den(46)
  den(48) = den(2)*den(40)
  den(49) = den(15)*den(43)
  den(50) = den(15)*den(37)
  den(51) = den(15)*den(46)
  den(52) = den(15)*den(40)
  den(54) = den(2)*den(53)
  den(55) = den(1)*den(54)
  den(56) = den(6)*den(54)
  den(58) = den(6)*den(57)
  den(59) = den(14)*den(58)
  den(60) = den(14)*den(53)
  den(61) = den(1)*den(60)
  den(62) = den(6)*den(60)
  den(64) = den(15)*den(63)
  den(65) = den(1)*den(64)
  den(66) = den(6)*den(64)
  den(67) = den(3)*den(58)
  den(68) = den(3)*den(63)
  den(69) = den(1)*den(68)
  den(70) = den(6)*den(68)
  den(71) = den(1)*den(3)
  den(73) = den(71)*den(72)
  den(74) = den(2)*den(73)
  den(75) = den(3)*den(6)
  den(76) = den(72)*den(75)
  den(77) = den(2)*den(76)
  den(79) = den(4)*den(78)
  den(80) = den(3)*den(79)
  den(81) = den(7)*den(78)
  den(82) = den(3)*den(81)
  den(83) = den(2)**2
  den(84) = den(10)*den(83)
  den(85) = den(12)*den(83)
  den(86) = den(10)*den(54)
  den(87) = den(12)*den(54)
  den(88) = den(1)*den(15)
  den(90) = den(88)*den(89)
  den(91) = den(14)*den(90)
  den(92) = den(6)*den(15)
  den(93) = den(89)*den(92)
  den(94) = den(14)*den(93)
  den(96) = den(16)*den(95)
  den(97) = den(15)*den(96)
  den(98) = den(18)*den(95)
  den(99) = den(15)*den(98)
  den(100) = den(21)*den(64)
  den(101) = den(23)*den(64)
  den(102) = den(15)**2
  den(103) = den(21)*den(102)
  den(104) = den(23)*den(102)
  den(105) = den(14)**2
  den(106) = den(58)*den(105)
  den(107) = den(10)*den(105)
  den(108) = den(12)*den(105)
  den(109) = den(10)*den(60)
  den(110) = den(12)*den(60)
  den(111) = den(3)**2
  den(112) = den(58)*den(111)
  den(113) = den(21)*den(68)
  den(114) = den(23)*den(68)
  den(115) = den(21)*den(111)
  den(116) = den(23)*den(111)
  den(117) = den(43)*den(83)
  den(118) = den(37)*den(83)
  den(119) = den(46)*den(83)
  den(120) = den(40)*den(83)
  den(121) = den(43)*den(102)
  den(122) = den(37)*den(102)
  den(123) = den(46)*den(102)
  den(124) = den(40)*den(102)
  den(125) = den(21)*den(78)
  den(126) = den(23)*den(78)
  den(127) = den(21)*den(95)
  den(128) = den(23)*den(95)
  den(129) = den(10)*den(89)
  den(130) = den(12)*den(89)
  den(131) = den(10)*den(72)
  den(132) = den(12)*den(72)
  den(133) = den(58)*den(78)
  den(134) = den(58)*den(89)
  den(135) = den(43)*den(95)
  den(136) = den(37)*den(95)
  den(137) = den(43)*den(72)
  den(138) = den(37)*den(72)
  den(140) = den(37)*den(139)
  den(141) = den(46)*den(95)
  den(142) = den(40)*den(95)
  den(143) = den(46)*den(72)
  den(144) = den(40)*den(72)
  den(145) = den(40)*den(139)
  den(146) = den(1)*den(2)*den(3)
  den(147) = den(2)*den(3)*den(6)
  den(148) = den(1)*den(14)*den(15)
  den(149) = den(6)*den(14)*den(15)
  den(150) = den(2)*den(131)
  den(151) = den(2)*den(132)
  den(152) = den(15)*den(127)
  den(153) = den(15)*den(128)
  den(154) = den(14)*den(129)
  den(155) = den(14)*den(130)
  den(156) = den(14)*den(134)
  den(157) = den(3)*den(125)
  den(158) = den(3)*den(126)
  den(159) = den(3)*den(133)
  den(160) = den(2)*den(137)
  den(161) = den(2)*den(138)
  den(162) = den(2)*den(143)
  den(163) = den(2)*den(144)
  den(164) = den(15)*den(135)
  den(165) = den(15)*den(136)
  den(166) = den(15)*den(141)
  den(167) = den(15)*den(142)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_eehvtt_eexttxha_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,116))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_eehvtt_eexttxha_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ top anti-top higgs gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_eehvtt_eexttxha_1, only: hel_mem_opt
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_eehvtt_eexttxha_1, only: &
    & external_perm_eehvtt_eexttxha_1, &
    & external_perm_inv_eehvtt_eexttxha_1, &
    & extcomb_perm_eehvtt_eexttxha_1, &
    & average_factor_eehvtt_eexttxha_1, &
    & photonid_eehvtt_eexttxha_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_eehvtt_eexttxha_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_eehvtt_eexttxha_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_eehvtt_eexttxha_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(116)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,116))
  end if

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMT, nMT, nMH, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_eehvtt_eexttxha_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMT, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,1), n3(:,2), t3x2(:,:,1))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,2), n3(:,3), t3x4(:,:,2))
  call prop_Q_A(ntry, wf2(:,1), 20, MT, 1_intkind1, wf2(:,2), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 40, MT, 1_intkind1, wf4(:,3), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf2(:,2), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,5), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,4), 3, MZ, 1_intkind1, wf4(:,5), n2(3))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf2(:,2), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,6), n3(:,8), t3x4(:,:,4))
  call prop_A_Q(ntry, wf8(:,3), 11, MT, 1_intkind1, wf8(:,4), n2(4))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,5), n3(:,9), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,5), 11, MT, 1_intkind1, wf8(:,6), n2(5))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,7), n3(:,10), t3x4(:,:,5))
  call vert_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,3), n3(:,11), t3x2(:,:,2))
  call prop_Q_A(ntry, wf4(:,7), 36, MT, 1_intkind1, wf4(:,8), n2(6))
  call prop_A_Q(ntry, wf2(:,3), 24, MT, 1_intkind1, wf2(:,4), n2(7))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,1), n3(:,12), t3x16(:,:,1))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,8), wf16(:,2), n3(:,13), t3x16(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,7), n3(:,14), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,9), n3(:,15), t3x4(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 7, MT, 1_intkind1, wf8(:,8), n2(8))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,9), n3(:,16), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,9), 7, MT, 1_intkind1, wf8(:,10), n2(9))
  call vert_QS_A(gH,ntry, wf4(:,8), ex5(:), wf4(:,10), n3(:,17), t3x4(:,:,7))
  call vert_QA_Z(gZu,ntry, wf4(:,8), ex4(:), wf8(:,11), n3(:,18), t3x8(:,:,7))
  call vert_SV_V(ntry, ex5(:), wf4(:,5), wf4(:,11), n3(:,19), t3x4(:,:,8))
  call prop_W_W(ntry, wf8(:,11), 44, MZ, 1_intkind1, wf8(:,12), n2(10))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,12), n3(:,20), t3x4(:,:,9))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,3), wf8(:,13), n3(:,21), t3x8(:,:,8))
  call prop_W_W(ntry, wf8(:,13), 44, MZ, 1_intkind1, wf8(:,14), n2(11))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,13), n3(:,22), t3x4(:,:,10))
  call vert_QA_Z(gZu,ntry, ex3(:), ex4(:), wf4(:,14), n3(:,23), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,13), 33, ZERO, 0_intkind1, wf4(:,15), n2(12))
  call prop_W_W(ntry, wf4(:,14), 12, MZ, 1_intkind1, wf4(:,16), n2(13))
  call vert_QA_Z(gZl,ntry, wf4(:,15), ex2(:), wf8(:,15), n3(:,24), t3x8(:,:,9))
  call vert_SV_V(ntry, ex5(:), wf4(:,16), wf4(:,17), n3(:,25), t3x4(:,:,12))
  call prop_W_W(ntry, wf8(:,15), 35, MZ, 1_intkind1, wf8(:,16), n2(14))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,18), n3(:,26), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,18), 34, ZERO, 0_intkind1, wf4(:,19), n2(15))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,19), wf8(:,17), n3(:,27), t3x8(:,:,10))
  call prop_W_W(ntry, wf8(:,17), 35, MZ, 1_intkind1, wf8(:,18), n2(16))
  call vert_QA_V(ntry, wf4(:,15), ex2(:), wf8(:,19), n3(:,28), t3x8(:,:,11))
  call vert_QA_V(ntry, wf2(:,2), ex4(:), wf4(:,20), n3(:,29), t3x4(:,:,14))
  call vert_QA_Z(gZu,ntry, wf2(:,2), ex4(:), wf4(:,21), n3(:,30), t3x4(:,:,15))
  call vert_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,20), n3(:,31), t3x8(:,:,12))
  call vert_QA_V(ntry, ex3(:), wf2(:,4), wf4(:,22), n3(:,32), t3x4(:,:,16))
  call vert_QA_Z(gZu,ntry, ex3(:), wf2(:,4), wf4(:,23), n3(:,33), t3x4(:,:,17))
  call counter_VQ_A(ntry, wf4(:,1), wf2(:,2), wf8(:,21), n3(:,34), t3x8(:,:,13))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), wf2(:,2), wf8(:,22), n3(:,35), t3x8(:,:,14))
  call counter_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,24), n3(:,36), t3x4(:,:,18))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,3), n3(:,37), t3x16(:,:,3))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,8), wf16(:,4), n3(:,38), t3x16(:,:,4))
  call counter_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,25), n3(:,39), t3x4(:,:,19))
  call counter_QS_A(gH,ntry, wf4(:,8), ex5(:), wf4(:,26), n3(:,40), t3x4(:,:,20))
  call counter_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,27), n3(:,41), t3x4(:,:,21))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,23), n3(:,42), t3x8(:,:,15))
  call prop_Q_A(ntry, wf4(:,6), 52, MT, 1_intkind1, wf4(:,28), n2(17))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,24), n3(:,43), t3x8(:,:,16))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,29), n3(:,44), t3x4(:,:,22))
  call prop_A_Q(ntry, wf4(:,29), 40, MT, 1_intkind1, wf4(:,30), n2(18))
  call counter_QA_Z(gZu,ntry, wf4(:,8), ex4(:), wf8(:,25), n3(:,45), t3x8(:,:,17))
  call prop_W_W(ntry, wf4(:,11), 19, MZ, 1_intkind1, wf4(:,31), n2(19))
  call prop_Q_A(ntry, wf4(:,10), 52, MT, 1_intkind1, wf4(:,32), n2(20))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,30), wf4(:,33), n3(:,46), t3x4(:,:,23))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,30), wf8(:,26), n3(:,47), t3x8(:,:,18))
  call prop_W_W(ntry, wf8(:,26), 44, MZ, 1_intkind1, wf8(:,27), n2(21))
  call counter_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,5), n3(:,48), t3x2(:,:,3))
  call prop_A_Q(ntry, wf2(:,5), 24, MT, 1_intkind1, wf2(:,6), n2(22))
  call vert_AV_Q(ntry, wf2(:,6), ex6(:), wf4(:,34), n3(:,49), t3x4(:,:,24))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,28), n3(:,50), t3x8(:,:,19))
  call prop_A_Q(ntry, wf4(:,9), 56, MT, 1_intkind1, wf4(:,35), n2(23))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,29), n3(:,51), t3x8(:,:,20))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,36), n3(:,52), t3x4(:,:,25))
  call prop_Q_A(ntry, wf4(:,36), 36, MT, 1_intkind1, wf4(:,37), n2(24))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,37), wf16(:,5), n3(:,53), t3x16(:,:,5))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,37), wf16(:,6), n3(:,54), t3x16(:,:,6))
  call counter_QA_Z(gZu,ntry, ex3(:), wf4(:,3), wf8(:,30), n3(:,55), t3x8(:,:,21))
  call prop_A_Q(ntry, wf4(:,12), 56, MT, 1_intkind1, wf4(:,38), n2(25))
  call vert_QS_A(gH,ntry, wf4(:,37), ex5(:), wf4(:,39), n3(:,56), t3x4(:,:,26))
  call vert_QA_Z(gZu,ntry, wf4(:,37), ex4(:), wf8(:,31), n3(:,57), t3x8(:,:,22))
  call prop_W_W(ntry, wf8(:,31), 44, MZ, 1_intkind1, wf8(:,32), n2(26))
  call counter_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,7), n3(:,58), t3x2(:,:,4))
  call prop_Q_A(ntry, wf2(:,7), 20, MT, 1_intkind1, wf2(:,8), n2(27))
  call vert_VQ_A(ntry, wf4(:,1), wf2(:,8), wf8(:,33), n3(:,59), t3x8(:,:,23))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf2(:,8), wf8(:,34), n3(:,60), t3x8(:,:,24))
  call vert_VQ_A(ntry, ex6(:), wf2(:,8), wf4(:,40), n3(:,61), t3x4(:,:,27))
  call counter_QA_V(ntry, wf2(:,2), ex4(:), wf4(:,41), n3(:,62), t3x4(:,:,28))
  call counter_QA_Z(gZu,ntry, wf2(:,2), ex4(:), wf4(:,42), n3(:,63), t3x4(:,:,29))
  call vert_QA_V(ntry, ex3(:), wf2(:,6), wf4(:,43), n3(:,64), t3x4(:,:,30))
  call vert_QA_Z(gZu,ntry, ex3(:), wf2(:,6), wf4(:,44), n3(:,65), t3x4(:,:,31))
  call counter_QA_V(ntry, ex3(:), wf2(:,4), wf4(:,45), n3(:,66), t3x4(:,:,32))
  call counter_QA_Z(gZu,ntry, ex3(:), wf2(:,4), wf4(:,46), n3(:,67), t3x4(:,:,33))
  call vert_QA_V(ntry, wf2(:,8), ex4(:), wf4(:,47), n3(:,68), t3x4(:,:,34))
  call vert_QA_Z(gZu,ntry, wf2(:,8), ex4(:), wf4(:,48), n3(:,69), t3x4(:,:,35))
  call counter_QA_Z(gZu,ntry, ex3(:), ex4(:), wf4(:,49), n3(:,70), t3x4(:,:,36))
  call prop_W_W(ntry, wf4(:,49), 12, MZ, 1_intkind1, wf4(:,50), n2(28))
  call vert_SV_V(ntry, ex5(:), wf4(:,50), wf4(:,51), n3(:,71), t3x4(:,:,37))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,7), n3(:,72), t3x16(:,:,7))
  call counter_Q_A(cttt,6,ntry, wf2(:,2), 20, wf2(:,9), n2(29))
  call prop_A_Q(ntry, wf16(:,7), 43, MT, 1_intkind1, wf16(:,8), n2(30))
  call vert_AZ_Q(gZu,ntry, wf4(:,3), wf4(:,5), wf16(:,9), n3(:,73), t3x16(:,:,8))
  call prop_A_Q(ntry, wf16(:,9), 43, MT, 1_intkind1, wf16(:,10), n2(31))
  call counter_A_Q(cttt,6,ntry, wf4(:,3), 40, wf4(:,52), n2(32))
  call prop_Q_A(ntry, wf8(:,1), 23, MT, 1_intkind1, wf8(:,35), n2(33))
  call prop_Q_A(ntry, wf8(:,2), 23, MT, 1_intkind1, wf8(:,36), n2(34))
  call prop_Q_A(ntry, wf2(:,9), 20, MT, 1_intkind1, wf2(:,10), n2(35))
  call vert_VQ_A(ntry, ex6(:), wf2(:,10), wf4(:,53), n3(:,74), t3x4(:,:,38))
  call counter_A_Q(cttt,6,ntry, wf8(:,4), 11, wf8(:,37), n2(36))
  call counter_A_Q(cttt,6,ntry, wf8(:,6), 11, wf8(:,38), n2(37))
  call vert_AV_Q(ntry, wf2(:,4), wf4(:,1), wf8(:,39), n3(:,75), t3x8(:,:,25))
  call counter_Q_A(cttt,6,ntry, wf4(:,8), 36, wf4(:,54), n2(38))
  call prop_A_Q(ntry, wf8(:,39), 27, MT, 1_intkind1, wf8(:,40), n2(39))
  call vert_AZ_Q(gZu,ntry, wf2(:,4), wf4(:,5), wf8(:,41), n3(:,76), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,41), 27, MT, 1_intkind1, wf8(:,42), n2(40))
  call counter_A_Q(cttt,6,ntry, wf2(:,4), 24, wf2(:,11), n2(41))
  call prop_Q_A(ntry, wf16(:,1), 39, MT, 1_intkind1, wf16(:,11), n2(42))
  call prop_Q_A(ntry, wf16(:,2), 39, MT, 1_intkind1, wf16(:,12), n2(43))
  call counter_Q_A(cttt,6,ntry, wf8(:,8), 7, wf8(:,43), n2(44))
  call counter_Q_A(cttt,6,ntry, wf8(:,10), 7, wf8(:,44), n2(45))
  call prop_A_Q(ntry, wf2(:,11), 24, MT, 1_intkind1, wf2(:,12), n2(46))
  call vert_AV_Q(ntry, wf2(:,12), ex6(:), wf4(:,55), n3(:,77), t3x4(:,:,39))
  call prop_Q_A(ntry, wf4(:,54), 36, MT, 1_intkind1, wf4(:,56), n2(47))
  call vert_QA_Z(gZu,ntry, wf4(:,56), ex4(:), wf8(:,45), n3(:,78), t3x8(:,:,27))
  call vert_QS_A(gH,ntry, wf4(:,56), ex5(:), wf4(:,57), n3(:,79), t3x4(:,:,40))
  call prop_A_Q(ntry, wf4(:,52), 40, MT, 1_intkind1, wf4(:,58), n2(48))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,58), wf8(:,46), n3(:,80), t3x8(:,:,28))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,58), wf4(:,59), n3(:,81), t3x4(:,:,41))
  call vert_QA_V(ntry, wf2(:,10), ex4(:), wf4(:,60), n3(:,82), t3x4(:,:,42))
  call vert_QA_Z(gZu,ntry, wf2(:,10), ex4(:), wf4(:,61), n3(:,83), t3x4(:,:,43))
  call vert_QA_V(ntry, ex3(:), wf2(:,12), wf4(:,62), n3(:,84), t3x4(:,:,44))
  call vert_QA_Z(gZu,ntry, ex3(:), wf2(:,12), wf4(:,63), n3(:,85), t3x4(:,:,45))
  call vert_QS_A(gH,ntry, wf8(:,8), ex5(:), wf8(:,47), n3(:,86), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,47), 23, MT, 1_intkind1, wf8(:,48), n2(49))
  call vert_QS_A(gH,ntry, wf8(:,10), ex5(:), wf8(:,49), n3(:,87), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,49), 23, MT, 1_intkind1, wf8(:,50), n2(50))
  call vert_VQ_A(ntry, ex6(:), wf8(:,8), wf16(:,13), n3(:,88), t3x16(:,:,9))
  call prop_Q_A(ntry, wf16(:,13), 39, MT, 1_intkind1, wf16(:,14), n2(51))
  call vert_VQ_A(ntry, ex6(:), wf8(:,10), wf16(:,15), n3(:,89), t3x16(:,:,10))
  call prop_Q_A(ntry, wf16(:,15), 39, MT, 1_intkind1, wf16(:,16), n2(52))
  call vert_SA_Q(gH,ntry, ex5(:), wf8(:,4), wf8(:,51), n3(:,90), t3x8(:,:,31))
  call prop_A_Q(ntry, wf8(:,51), 27, MT, 1_intkind1, wf8(:,52), n2(53))
  call vert_SA_Q(gH,ntry, ex5(:), wf8(:,6), wf8(:,53), n3(:,91), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,53), 27, MT, 1_intkind1, wf8(:,54), n2(54))
  call vert_AV_Q(ntry, wf8(:,4), ex6(:), wf16(:,17), n3(:,92), t3x16(:,:,11))
  call prop_A_Q(ntry, wf16(:,17), 43, MT, 1_intkind1, wf16(:,18), n2(55))
  call vert_AV_Q(ntry, wf8(:,6), ex6(:), wf16(:,19), n3(:,93), t3x16(:,:,12))
  call prop_A_Q(ntry, wf16(:,19), 43, MT, 1_intkind1, wf16(:,20), n2(56))
  call vert_ZQ_A(gZu,ntry, wf4(:,31), ex3(:), wf8(:,55), n3(:,94), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,55), 23, MT, 1_intkind1, wf8(:,56), n2(57))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,31), wf8(:,57), n3(:,95), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,57), 27, MT, 1_intkind1, wf8(:,58), n2(58))
  call vert_VQ_A(ntry, wf8(:,19), ex3(:), wf16(:,21), n3(:,96), t3x16(:,:,13))
  call prop_Q_A(ntry, wf16(:,21), 39, MT, 1_intkind1, wf16(:,22), n2(59))
  call vert_ZQ_A(gZu,ntry, wf8(:,16), ex3(:), wf16(:,23), n3(:,97), t3x16(:,:,14))
  call prop_Q_A(ntry, wf16(:,23), 39, MT, 1_intkind1, wf16(:,24), n2(60))
  call vert_AV_Q(ntry, ex4(:), wf8(:,19), wf16(:,25), n3(:,98), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,25), 43, MT, 1_intkind1, wf16(:,26), n2(61))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf8(:,16), wf16(:,27), n3(:,99), t3x16(:,:,16))
  call prop_A_Q(ntry, wf16(:,27), 43, MT, 1_intkind1, wf16(:,28), n2(62))
  call vert_SV_V(ntry, ex5(:), wf8(:,16), wf8(:,59), n3(:,100), t3x8(:,:,35))
  call prop_W_W(ntry, wf8(:,59), 51, MZ, 1_intkind1, wf8(:,60), n2(63))
  call vert_VQ_A(ntry, wf8(:,20), ex3(:), wf16(:,29), n3(:,101), t3x16(:,:,17))
  call prop_Q_A(ntry, wf16(:,29), 39, MT, 1_intkind1, wf16(:,30), n2(64))
  call vert_ZQ_A(gZu,ntry, wf8(:,18), ex3(:), wf16(:,31), n3(:,102), t3x16(:,:,18))
  call prop_Q_A(ntry, wf16(:,31), 39, MT, 1_intkind1, wf16(:,32), n2(65))
  call vert_AV_Q(ntry, ex4(:), wf8(:,20), wf16(:,33), n3(:,103), t3x16(:,:,19))
  call prop_A_Q(ntry, wf16(:,33), 43, MT, 1_intkind1, wf16(:,34), n2(66))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf8(:,18), wf16(:,35), n3(:,104), t3x16(:,:,20))
  call prop_A_Q(ntry, wf16(:,35), 43, MT, 1_intkind1, wf16(:,36), n2(67))
  call vert_SV_V(ntry, ex5(:), wf8(:,18), wf8(:,61), n3(:,105), t3x8(:,:,36))
  call prop_W_W(ntry, wf8(:,61), 51, MZ, 1_intkind1, wf8(:,62), n2(68))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_eehvtt_eexttxha_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference
  
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,3), wf8(:,1), A(:,1), n3(:,106), t3x32(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,2), A(:,2), n3(:,107), t3x32(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,4), A(:,3), n3(:,108), t3x32(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,6), A(:,4), n3(:,109), t3x32(:,:,4), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,1), A(:,5), n3(:,110), t3x32(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,2), A(:,6), n3(:,111), t3x32(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,8), A(:,7), n3(:,112), t3x32(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,10), A(:,8), n3(:,113), t3x32(:,:,8), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,10), A(:,9), n3(:,114), t3x32(:,:,9), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,10), A(:,10), n3(:,115), t3x32(:,:,10), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,12), A(:,11), n3(:,116), t3x32(:,:,11), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,12), A(:,12), n3(:,117), t3x32(:,:,12), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,12), A(:,13), n3(:,118), t3x32(:,:,13), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,14), A(:,14), n3(:,119), t3x32(:,:,14), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,16), A(:,15), n3(:,120), t3x32(:,:,15), nhel, den(38))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,18), A(:,16), n3(:,121), t3x32(:,:,16), nhel, den(41))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,20), A(:,17), n3(:,122), t3x32(:,:,17), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,21), A(:,18), n3(:,123), t3x32(:,:,18), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,20), A(:,19), n3(:,124), t3x32(:,:,19), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,21), A(:,20), n3(:,125), t3x32(:,:,20), nhel, den(48))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,22), A(:,21), n3(:,126), t3x32(:,:,21), nhel, den(49))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,23), A(:,22), n3(:,127), t3x32(:,:,22), nhel, den(50))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,22), A(:,23), n3(:,128), t3x32(:,:,23), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,23), A(:,24), n3(:,129), t3x32(:,:,24), nhel, den(52))

    call Hcont_QA(nsync, wf4(:,3), wf8(:,21), A(:,25), n3(:,130), t3x32(:,:,25), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,22), A(:,26), n3(:,131), t3x32(:,:,26), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,24), A(:,27), n3(:,132), t3x32(:,:,27), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,24), A(:,28), n3(:,133), t3x32(:,:,28), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,3), A(:,29), n3(:,134), t3x32(:,:,29), nhel, den(17))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,4), A(:,30), n3(:,135), t3x32(:,:,30), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,25), A(:,31), n3(:,136), t3x32(:,:,31), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,25), A(:,32), n3(:,137), t3x32(:,:,32), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,26), A(:,33), n3(:,138), t3x32(:,:,33), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,26), A(:,34), n3(:,139), t3x32(:,:,34), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,27), A(:,35), n3(:,140), t3x32(:,:,35), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,27), A(:,36), n3(:,141), t3x32(:,:,36), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,23), wf4(:,28), A(:,37), n3(:,142), t3x32(:,:,37), nhel, den(55))
    call Hcont_QA(nsync, wf4(:,28), wf8(:,24), A(:,38), n3(:,143), t3x32(:,:,38), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,30), A(:,39), n3(:,144), t3x32(:,:,39), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,30), A(:,40), n3(:,145), t3x32(:,:,40), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,31), A(:,41), n3(:,146), t3x32(:,:,41), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,23), wf4(:,32), A(:,42), n3(:,147), t3x32(:,:,42), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,32), A(:,43), n3(:,148), t3x32(:,:,43), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,33), A(:,44), n3(:,149), t3x32(:,:,44), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,33), A(:,45), n3(:,150), t3x32(:,:,45), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,27), A(:,46), n3(:,151), t3x32(:,:,46), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,1), wf2(:,6), A(:,47), n3(:,152), t3x32(:,:,47), nhel, den(17))
    call Hcont_QA(nsync, wf16(:,2), wf2(:,6), A(:,48), n3(:,153), t3x32(:,:,48), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,34), A(:,49), n3(:,154), t3x32(:,:,49), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,34), A(:,50), n3(:,155), t3x32(:,:,50), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,35), A(:,51), n3(:,156), t3x32(:,:,51), nhel, den(65))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,29), A(:,52), n3(:,157), t3x32(:,:,52), nhel, den(66))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,5), A(:,53), n3(:,158), t3x32(:,:,53), nhel, den(17))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,6), A(:,54), n3(:,159), t3x32(:,:,54), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,31), wf8(:,30), A(:,55), n3(:,160), t3x32(:,:,55), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,38), A(:,56), n3(:,161), t3x32(:,:,56), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,29), wf4(:,38), A(:,57), n3(:,162), t3x32(:,:,57), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,39), A(:,58), n3(:,163), t3x32(:,:,58), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,39), A(:,59), n3(:,164), t3x32(:,:,59), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,32), A(:,60), n3(:,165), t3x32(:,:,60), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,33), A(:,61), n3(:,166), t3x32(:,:,61), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,34), A(:,62), n3(:,167), t3x32(:,:,62), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,40), A(:,63), n3(:,168), t3x32(:,:,63), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,40), A(:,64), n3(:,169), t3x32(:,:,64), nhel, den(13))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,41), A(:,65), n3(:,170), t3x32(:,:,65), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,42), A(:,66), n3(:,171), t3x32(:,:,66), nhel, den(45))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,41), A(:,67), n3(:,172), t3x32(:,:,67), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,42), A(:,68), n3(:,173), t3x32(:,:,68), nhel, den(48))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,43), A(:,69), n3(:,174), t3x32(:,:,69), nhel, den(49))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,44), A(:,70), n3(:,175), t3x32(:,:,70), nhel, den(50))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,43), A(:,71), n3(:,176), t3x32(:,:,71), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,44), A(:,72), n3(:,177), t3x32(:,:,72), nhel, den(52))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,45), A(:,73), n3(:,178), t3x32(:,:,73), nhel, den(49))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,46), A(:,74), n3(:,179), t3x32(:,:,74), nhel, den(50))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,45), A(:,75), n3(:,180), t3x32(:,:,75), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,46), A(:,76), n3(:,181), t3x32(:,:,76), nhel, den(52))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,47), A(:,77), n3(:,182), t3x32(:,:,77), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,48), A(:,78), n3(:,183), t3x32(:,:,78), nhel, den(45))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,47), A(:,79), n3(:,184), t3x32(:,:,79), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,48), A(:,80), n3(:,185), t3x32(:,:,80), nhel, den(48))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,51), A(:,81), n3(:,186), t3x32(:,:,81), nhel, den(38))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,51), A(:,82), n3(:,187), t3x32(:,:,82), nhel, den(41))
    call Hcont_QA(nsync, wf2(:,9), wf16(:,8), A(:,83), n3(:,188), t3x32(:,:,83), nhel, den(74))
    call Hcont_QA(nsync, wf2(:,9), wf16(:,10), A(:,84), n3(:,189), t3x32(:,:,84), nhel, den(77))
    call Hcont_QA(nsync, wf4(:,52), wf8(:,35), A(:,85), n3(:,190), t3x32(:,:,85), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,52), wf8(:,36), A(:,86), n3(:,191), t3x32(:,:,86), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,53), A(:,87), n3(:,192), t3x32(:,:,87), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,53), A(:,88), n3(:,193), t3x32(:,:,88), nhel, den(85))
    call Hcont_QA(nsync, wf4(:,28), wf8(:,37), A(:,89), n3(:,194), t3x32(:,:,89), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,28), wf8(:,38), A(:,90), n3(:,195), t3x32(:,:,90), nhel, den(87))
    call Hcont_QA(nsync, wf4(:,54), wf8(:,40), A(:,91), n3(:,196), t3x32(:,:,91), nhel, den(91))
    call Hcont_QA(nsync, wf4(:,54), wf8(:,42), A(:,92), n3(:,197), t3x32(:,:,92), nhel, den(94))
    call Hcont_QA(nsync, wf2(:,11), wf16(:,11), A(:,93), n3(:,198), t3x32(:,:,93), nhel, den(97))
    call Hcont_QA(nsync, wf2(:,11), wf16(:,12), A(:,94), n3(:,199), t3x32(:,:,94), nhel, den(99))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,43), A(:,95), n3(:,200), t3x32(:,:,95), nhel, den(100))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,44), A(:,96), n3(:,201), t3x32(:,:,96), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,55), A(:,97), n3(:,202), t3x32(:,:,97), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,55), A(:,98), n3(:,203), t3x32(:,:,98), nhel, den(104))
    call Hcont_VV(nsync, wf4(:,31), wf8(:,45), A(:,99), n3(:,204), t3x32(:,:,99), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,57), A(:,100), n3(:,205), t3x32(:,:,100), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,57), A(:,101), n3(:,206), t3x32(:,:,101), nhel, den(108))
    call Hcont_QA(nsync, wf4(:,32), wf8(:,37), A(:,102), n3(:,207), t3x32(:,:,102), nhel, den(109))
    call Hcont_QA(nsync, wf4(:,32), wf8(:,38), A(:,103), n3(:,208), t3x32(:,:,103), nhel, den(110))
    call Hcont_VV(nsync, wf4(:,31), wf8(:,46), A(:,104), n3(:,209), t3x32(:,:,104), nhel, den(112))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,43), A(:,105), n3(:,210), t3x32(:,:,105), nhel, den(113))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,44), A(:,106), n3(:,211), t3x32(:,:,106), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,59), A(:,107), n3(:,212), t3x32(:,:,107), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,59), A(:,108), n3(:,213), t3x32(:,:,108), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,60), A(:,109), n3(:,214), t3x32(:,:,109), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,61), A(:,110), n3(:,215), t3x32(:,:,110), nhel, den(118))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,60), A(:,111), n3(:,216), t3x32(:,:,111), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,61), A(:,112), n3(:,217), t3x32(:,:,112), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,62), A(:,113), n3(:,218), t3x32(:,:,113), nhel, den(121))
    call Hcont_VV(nsync, wf8(:,16), wf4(:,63), A(:,114), n3(:,219), t3x32(:,:,114), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,62), A(:,115), n3(:,220), t3x32(:,:,115), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,63), A(:,116), n3(:,221), t3x32(:,:,116), nhel, den(124))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,11)%j+A(j,14)%j)*f(1)+(-A(j,15)%j-A(j,16)%j)*f(2)+(-A(j,1)%j-A(j,3)%j-A(j,5)%j-A(j,7)%j-A(j,9)%j-A(j,12)%j)*f(8) &
       +(A(j,2)%j+A(j,4)%j+A(j,6)%j+A(j,8)%j+A(j,10)%j+A(j,13)%j+A(j,17)%j+A(j,19)%j+A(j,21)%j+A(j,23)%j)*f(9)+(-A(j,18)%j &
       -A(j,20)%j-A(j,22)%j-A(j,24)%j)*f(10)

  M2(1)%j = (-A(j,99)%j-A(j,104)%j)*f(3)+(A(j,41)%j+A(j,46)%j+A(j,55)%j+A(j,60)%j)*f(4)+(-A(j,81)%j-A(j,82)%j)*f(5)+(A(j,83)%j &
       +A(j,85)%j+A(j,87)%j+A(j,89)%j+A(j,91)%j+A(j,93)%j+A(j,95)%j+A(j,97)%j+A(j,100)%j+A(j,102)%j+A(j,105)%j+A(j,107)%j)*f(11)+( &
       -A(j,84)%j-A(j,86)%j-A(j,88)%j-A(j,90)%j-A(j,92)%j-A(j,94)%j-A(j,96)%j-A(j,98)%j-A(j,101)%j-A(j,103)%j-A(j,106)%j &
       -A(j,108)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,115)%j)*f(12)+(A(j,110)%j+A(j,112)%j+A(j,114)%j+A(j,116)%j)*f(13)+( &
       -A(j,33)%j-A(j,35)%j-A(j,47)%j-A(j,49)%j-A(j,61)%j-A(j,63)%j)*f(14)+(A(j,34)%j+A(j,36)%j+A(j,48)%j+A(j,50)%j+A(j,62)%j &
       +A(j,64)%j+A(j,69)%j+A(j,71)%j+A(j,77)%j+A(j,79)%j)*f(15)+(-A(j,70)%j-A(j,72)%j-A(j,78)%j-A(j,80)%j)*f(16)+(-A(j,25)%j &
       -A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,37)%j-A(j,39)%j-A(j,42)%j-A(j,44)%j-A(j,51)%j-A(j,53)%j-A(j,56)%j-A(j,58)%j)*f(17) &
       +(A(j,26)%j+A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,38)%j+A(j,40)%j+A(j,43)%j+A(j,45)%j+A(j,52)%j+A(j,54)%j+A(j,57)%j+A(j,59)%j &
       +A(j,65)%j+A(j,67)%j+A(j,73)%j+A(j,75)%j)*f(18)+(-A(j,66)%j-A(j,68)%j-A(j,74)%j-A(j,76)%j)*f(19)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_eehvtt_eexttxha_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_eehvtt_eexttxha_1_/**/REALKIND
