
module ol_vamp_1_eehv_ew_eexhz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eehv_ew_eexhz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eehv_ew_eexhz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eehv_ew_eexhz_1_/**/DREALKIND
  use ol_tensor_sum_storage_eehv_ew_eexhz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_eehv_ew_eexhz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eehv_ew_eexhz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(1),h0tab(:,1),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(1),m3h3x4(:,1),heltab2x12(:,:,1))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UV_W(ntryL,G0H12(1),0,ex4(:),8,G1H4(1),m3h3x4(:,2),heltab2x12(:,:,2))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(3),h0tab(:,3),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(2),m3h3x4(:,3),heltab2x12(:,:,3))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(4),h0tab(:,4),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H12(1),0,ex4(:),8,G1H4(2),m3h3x4(:,4),heltab2x12(:,:,4))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(5),h0tab(:,5),[8,1,4,2],[0,nMZ,nMZ,0],4,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(3),ngZl,m3h3x4(:,5),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(3),8,0,G1H4(3),n2h4(1))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(6),h0tab(:,6),[8,1,4,2],[0,nMW,nMW,0],4,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(3),ngZn,m3h3x4(:,6),heltab2x12(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(3),8,0,G1H4(4),n2h4(2))
  call Hloop_WA_Q(ntryL,G0H4(1),ex2(:),G0H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G0H2(1),10,0,G1H2(1),n2h2(1))
  call Hloop_WA_Q(ntryL,G1H4(1),ex2(:),G1H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_A_Q(ntryL,G1H2(2),10,0,G2H2(1),n2h2(2))
  call Hloop_WQ_A(ntryL,G0H4(2),ex1(:),G0H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G0H2(1),9,0,G1H2(2),n2h2(3))
  call Hloop_WQ_A(ntryL,G1H4(2),ex1(:),G1H2(3),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(3),9,0,G2H2(2),n2h2(4))
  call Hloop_AQ_Z(ntryL,G1H4(3),ex1(:),G1H2(3),ngZl,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_W(ntryL,G1H4(4),ex1(:),G1H2(4),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_W(ntryL,G1H2(1),ex1(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_AQ_W(ntryL,G2H2(1),ex1(:),G2H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_QA_W(ntryL,G1H2(2),ex2(:),G1H1(2),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hloop_QA_W(ntryL,G2H2(2),ex2(:),G2H1(2),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_VS_V(ntryL,G1H2(3),ex3(:),G1H2(1),m3h1x2(:,1),heltab2x2(:,:,5))
  call Hloop_VS_V(ntryL,G1H2(4),ex3(:),G1H2(2),m3h1x2(:,2),heltab2x2(:,:,6))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(1),11,ex3(:),4,G2tensor(1),m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(1),ex3(:),G2tensor(2),m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(2),11,ex3(:),4,G2tensor(3),m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(2),ex3(:),G2tensor(4),m3h1x1(:,4),heltab2x1(:,:,4))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngZl,m3h2x1(:,5),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(1))
  call Hloop_WA_Q(ntryL,G1H2(2),ex2(:),G1H1(2),m3h2x1(:,6),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),15,0,G2tensor(6),n2h1(2))
  call ol_merge_tensors(G2tensor(2),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(3)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(3),mass4set(:,2),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),2)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(3),mass4set(:,3),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,2),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(3),mass4set(:,3),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(7),h0tab(:,7),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(3),ngZl,m3h3x4(:,7),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(3),8,nMM,G1H4(1),n2h4(3))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(8),h0tab(:,8),[8,3,4],[nML,nML,nML],3,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(1),ngZl,m3h3x4(:,8),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),8,nML,G1H4(2),n2h4(4))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(9),h0tab(:,9),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(2),ngZl,m3h3x4(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(2),8,nMM,G1H4(3),n2h4(5))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(10),h0tab(:,10),[8,3,4],[nML,nML,nML],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(3),ngZl,m3h3x4(:,10),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G0H4(3),8,nML,G1H4(4),n2h4(6))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(11),h0tab(:,11),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(1),ngZu,m3h3x4(:,11),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),8,nMT,G1H4(5),n2h4(7))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(12),h0tab(:,12),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(2),ngZu,m3h3x4(:,12),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G0H4(2),8,nMT,G1H4(6),n2h4(8))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(13),h0tab(:,13),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(3),ngZd,m3h3x4(:,13),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G0H4(3),8,nMB,G1H4(7),n2h4(9))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(14),h0tab(:,14),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(1),ngZd,m3h3x4(:,14),heltab2x12(:,:,14))
  call Hloop_Q_A(ntryL,G0H4(1),8,nMB,G1H4(8),n2h4(10))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(15),h0tab(:,15),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(2),ngZl,m3h3x4(:,15),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G0H4(2),8,nMM,G1H4(9),n2h4(11))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(16),h0tab(:,16),[8,3,4],[nML,nML,nML],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(3),ngZl,m3h3x4(:,16),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G0H4(3),8,nML,G1H4(10),n2h4(12))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(17),h0tab(:,17),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(1),ngZl,m3h3x4(:,17),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G0H4(1),8,nMM,G1H4(11),n2h4(13))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(18),h0tab(:,18),[8,3,4],[nML,nML,nML],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(2),ngZl,m3h3x4(:,18),heltab2x12(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(2),8,nML,G1H4(12),n2h4(14))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(19),h0tab(:,19),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(3),ngZu,m3h3x4(:,19),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G0H4(3),8,nMT,G1H4(13),n2h4(15))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(20),h0tab(:,20),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(1),ngZu,m3h3x4(:,20),heltab2x12(:,:,20))
  call Hloop_Q_A(ntryL,G0H4(1),8,nMT,G1H4(14),n2h4(16))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(21),h0tab(:,21),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H12(1),ex4(:),G0H4(2),ngZd,m3h3x4(:,21),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G0H4(2),8,nMB,G1H4(15),n2h4(17))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(22),h0tab(:,22),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),ex4(:),G0H4(3),ngZd,m3h3x4(:,22),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(3),8,nMB,G1H4(16),n2h4(18))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(23),h0tab(:,23),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H12(1),0,ex4(:),8,G1H4(17),m3h3x4(:,23),heltab2x12(:,:,23))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(24),h0tab(:,24),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H12(1),0,ex4(:),8,G1H4(18),m3h3x4(:,24),heltab2x12(:,:,24))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(25),h0tab(:,25),[8,3,4],[nMZ,nMH,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H12(1),0,ex4(:),8,G1H4(19),m3h3x4(:,25),heltab2x12(:,:,25))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(26),h0tab(:,26),[8,3,4],[nMH,nMZ,nMZ],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H12(1),0,ex4(:),8,G1H4(20),m3h3x4(:,26),heltab2x12(:,:,26))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(27),h0tab(:,27),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H12(1),0,ex4(:),8,G1H4(21),m3h3x4(:,27),heltab2x12(:,:,27))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(28),h0tab(:,28),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H12(1),0,ex4(:),8,G1H4(22),m3h3x4(:,28),heltab2x12(:,:,28))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(29),h0tab(:,29),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H12(1),0,ex4(:),G1H4(23),m3h3x4(:,29),heltab2x12(:,:,29))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(30),h0tab(:,30),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H12(1),0,ex4(:),8,G1H4(24),m3h3x4(:,30),heltab2x12(:,:,30))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(31),h0tab(:,31),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H12(1),0,ex4(:),G1H4(25),m3h3x4(:,31),heltab2x12(:,:,31))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(32),h0tab(:,32),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H12(1),0,ex4(:),8,G1H4(26),m3h3x4(:,32),heltab2x12(:,:,32))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(33),h0tab(:,33),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H12(1),0,ex4(:),G1H4(27),m3h3x4(:,33),heltab2x12(:,:,33))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(34),h0tab(:,34),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H12(1),0,ex4(:),8,G1H4(28),m3h3x4(:,34),heltab2x12(:,:,34))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(35),h0tab(:,35),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H12(1),0,ex4(:),G1H4(29),m3h3x4(:,35),heltab2x12(:,:,35))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(36),h0tab(:,36),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H12(1),0,ex4(:),8,G1H4(30),m3h3x4(:,36),heltab2x12(:,:,36))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(37),h0tab(:,37),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H12(1),0,ex4(:),8,G1H4(31),m3h3x4(:,37),heltab2x12(:,:,37))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(38),h0tab(:,38),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H12(1),0,ex4(:),8,G1H4(32),m3h3x4(:,38),heltab2x12(:,:,38))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(39),h0tab(:,39),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H12(1),0,ex4(:),8,G1H4(33),m3h3x4(:,39),heltab2x12(:,:,39))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(40),h0tab(:,40),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H12(1),0,ex4(:),8,G1H4(34),m3h3x4(:,40),heltab2x12(:,:,40))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(41),h0tab(:,41),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(1),m3h3x4(:,41),heltab2x12(:,:,41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(42),h0tab(:,42),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(2),m3h3x4(:,42),heltab2x12(:,:,42))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(43),h0tab(:,43),[8,3,4],[nMZ,nMH,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(3),m3h3x4(:,43),heltab2x12(:,:,43))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(44),h0tab(:,44),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(4),m3h3x4(:,44),heltab2x12(:,:,44))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(45),h0tab(:,45),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(5),m3h3x4(:,45),heltab2x12(:,:,45))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(46),h0tab(:,46),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H12(1),0,ex4(:),8,G1H4(35),m3h3x4(:,46),heltab2x12(:,:,46))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(47),h0tab(:,47),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H12(1),0,ex4(:),8,G1H4(36),m3h3x4(:,47),heltab2x12(:,:,47))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(48),h0tab(:,48),[8,3,4],[nMH,nMZ,nMZ],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H12(1),0,ex4(:),8,G1H4(37),m3h3x4(:,48),heltab2x12(:,:,48))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(49),h0tab(:,49),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H12(1),0,ex4(:),8,G1H4(38),m3h3x4(:,49),heltab2x12(:,:,49))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(50),h0tab(:,50),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H12(1),0,ex4(:),8,G1H4(39),m3h3x4(:,50),heltab2x12(:,:,50))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(51),h0tab(:,51),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(6),m3h3x4(:,51),heltab2x12(:,:,51))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(52),h0tab(:,52),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(7),m3h3x4(:,52),heltab2x12(:,:,52))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(53),h0tab(:,53),[8,3,4],[nMH,nMZ,nMZ],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(8),m3h3x4(:,53),heltab2x12(:,:,53))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(54),h0tab(:,54),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(9),m3h3x4(:,54),heltab2x12(:,:,54))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(55),h0tab(:,55),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(10),m3h3x4(:,55),heltab2x12(:,:,55))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(56),h0tab(:,56),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(11),m3h3x4(:,56),heltab2x12(:,:,56))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(57),h0tab(:,57),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(12),m3h3x4(:,57),heltab2x12(:,:,57))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(58),h0tab(:,58),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(13),m3h3x4(:,58),heltab2x12(:,:,58))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(59),h0tab(:,59),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(14),m3h3x4(:,59),heltab2x12(:,:,59))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(60),h0tab(:,60),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H12(1),0,ex4(:),8,G1H4(40),m3h3x4(:,60),heltab2x12(:,:,60))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(61),h0tab(:,61),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H12(1),0,ex4(:),8,G1H4(41),m3h3x4(:,61),heltab2x12(:,:,61))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(62),h0tab(:,62),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H12(1),0,ex4(:),8,G1H4(42),m3h3x4(:,62),heltab2x12(:,:,62))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(63),h0tab(:,63),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H12(1),0,ex4(:),8,G1H4(43),m3h3x4(:,63),heltab2x12(:,:,63))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(64),h0tab(:,64),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(15),m3h3x4(:,64),heltab2x12(:,:,64))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(65),h0tab(:,65),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(16),m3h3x4(:,65),heltab2x12(:,:,65))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(66),h0tab(:,66),[8,3,4],[nMH,nMZ,nMZ],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(17),m3h3x4(:,66),heltab2x12(:,:,66))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(67),h0tab(:,67),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(18),m3h3x4(:,67),heltab2x12(:,:,67))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(68),h0tab(:,68),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),ex4(:),G0H4(19),m3h3x4(:,68),heltab2x12(:,:,68))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(69),h0tab(:,69),[9,2,4],[0,nMZ,nMZ],3,1,wf6(:,2))
  call Hloop_ZQ_A(ntryL,G0H12(1),wf6(:,2),G0H2(1),ngZl,m3h6x2(:,1),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G0H2(1),9,0,G1H2(3),n2h2(5))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(70),h0tab(:,70),[9,2,4],[0,nMW,nMW],3,1,wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H12(1),wf6(:,2),G0H2(1),m3h6x2(:,2),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G0H2(1),9,0,G1H2(4),n2h2(6))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(71),h0tab(:,71),[10,1,4],[0,nMZ,nMZ],3,1,wf6(:,4))
  call Hloop_ZA_Q(ntryL,G0H12(1),wf6(:,4),G0H2(1),ngZl,m3h6x2(:,3),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G0H2(1),10,0,G1H2(1),n2h2(7))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(72),h0tab(:,72),[10,1,4],[0,nMW,nMW],3,1,wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H12(1),wf6(:,4),G0H2(1),m3h6x2(:,4),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G0H2(1),10,0,G1H2(2),n2h2(8))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(73),h0tab(:,73),[12,1,2],[0,0,0],3,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H12(1),wf3(:,1),G0H4(20),ngZl,m3h3x4(:,69),heltab2x12(:,:,73))
  call Hloop_A_Q(ntryL,G0H4(20),12,0,G1H4(44),n2h4(19))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(74),h0tab(:,74),[12,1,2],[0,nMZ,0],3,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H12(1),wf3(:,1),G0H4(20),ngZl,m3h3x4(:,70),heltab2x12(:,:,74))
  call Hloop_A_Q(ntryL,G0H4(20),12,0,G1H4(45),n2h4(20))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(75),h0tab(:,75),[12,1,2],[0,nMW,0],3,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H12(1),wf3(:,1),G0H4(20),ngZn,m3h3x4(:,71),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G0H4(20),12,0,G1H4(46),n2h4(21))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(76),h0tab(:,76),[12,1,2],[nMW,0,nMW],3,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(47),m3h3x4(:,72),heltab2x12(:,:,76))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(2),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(5),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(16),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(19),[G0H4(18)])
  call Hloop_AV_Q(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H1(1),11,nMM,G2H1(1),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H4(2),wf4(:,2),G1H1(2),m3h4x1(:,2),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H1(2),11,nML,G2H1(2),n2h1(4))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H1(1),11,nMM,G2H1(3),n2h1(5))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,2),G1H1(2),m3h4x1(:,4),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H1(2),11,nML,G2H1(4),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H4(5),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H1(1),11,nMT,G2H1(5),n2h1(7))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,2),G1H1(2),m3h4x1(:,6),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H1(2),11,nMT,G2H1(6),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H1(1),11,nMB,G2H1(7),n2h1(9))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,2),G1H1(2),m3h4x1(:,8),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H1(2),11,nMB,G2H1(8),n2h1(10))
  call Hloop_AZ_Q(ntryL,G1H4(9),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,9),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H1(1),11,nMM,G2H1(9),n2h1(11))
  call Hloop_AZ_Q(ntryL,G1H4(10),wf4(:,1),G1H1(2),ngZl,m3h4x1(:,10),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H1(2),11,nML,G2H1(10),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,11),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H1(1),11,nMM,G2H1(11),n2h1(13))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,1),G1H1(2),ngZl,m3h4x1(:,12),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H1(2),11,nML,G2H1(12),n2h1(14))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,13),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H1(1),11,nMT,G2H1(13),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,1),G1H1(2),ngZu,m3h4x1(:,14),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H1(2),11,nMT,G2H1(14),n2h1(16))
  call Hloop_AZ_Q(ntryL,G1H4(15),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,15),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H1(1),11,nMB,G2H1(15),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,1),G1H1(2),ngZd,m3h4x1(:,16),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H1(2),11,nMB,G2H1(16),n2h1(18))
  call Hloop_SV_T(ntryL,G1H4(17),8,wf4(:,2),3,G2H1(17),m3h4x1(:,17),heltab2x4(:,:,23))
  call Hloop_TV_S(ntryL,G1H4(18),8,wf4(:,2),3,G2H1(18),m3h4x1(:,18),heltab2x4(:,:,24))
  call Hloop_SV_T(ntryL,G1H4(19),8,wf4(:,1),3,G2H1(19),m3h4x1(:,19),heltab2x4(:,:,25))
  call Hloop_TV_S(ntryL,G1H4(20),8,wf4(:,1),3,G2H1(20),m3h4x1(:,20),heltab2x4(:,:,26))
  call Hloop_SV_T(ntryL,G1H4(21),8,wf4(:,1),3,G2H1(21),m3h4x1(:,21),heltab2x4(:,:,27))
  call Hloop_TV_S(ntryL,G1H4(22),8,wf4(:,1),3,G2H1(22),m3h4x1(:,22),heltab2x4(:,:,28))
  call Hloop_DV_C(ntryL,G1H4(25),8,wf4(:,2),G2H1(23),m3h4x1(:,23),heltab2x4(:,:,29))
  call Hloop_CV_D(ntryL,G1H4(26),8,wf4(:,2),3,G2H1(24),m3h4x1(:,24),heltab2x4(:,:,30))
  call Hloop_DV_C(ntryL,G1H4(29),8,wf4(:,1),G2H1(25),m3h4x1(:,25),heltab2x4(:,:,31))
  call Hloop_CV_D(ntryL,G1H4(30),8,wf4(:,1),3,G2H1(26),m3h4x1(:,26),heltab2x4(:,:,32))
  call Hloop_UW_V(ntryL,G1H4(31),8,wf4(:,2),3,G2H1(27),m3h4x1(:,27),heltab2x4(:,:,33))
  call Hloop_UV_W(ntryL,G1H4(32),8,wf4(:,2),3,G2H1(28),m3h4x1(:,28),heltab2x4(:,:,34))
  call Hloop_UW_V(ntryL,G1H4(33),8,wf4(:,1),3,G2H1(29),m3h4x1(:,29),heltab2x4(:,:,35))
  call Hloop_UV_W(ntryL,G1H4(34),8,wf4(:,1),3,G2H1(30),m3h4x1(:,30),heltab2x4(:,:,36))
  call Hloop_VV_S(ntryL,G0H4(2),wf4(:,2),G0H1(1),m3h4x1(:,31),heltab2x4(:,:,37))
  call Hloop_VV_S(ntryL,G0H4(3),wf4(:,1),G0H1(2),m3h4x1(:,32),heltab2x4(:,:,38))
  call Hloop_VV_S(ntryL,G0H4(5),wf4(:,1),G0H1(3),m3h4x1(:,33),heltab2x4(:,:,39))
  call Hloop_SV_V(ntryL,G1H4(36),wf4(:,2),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,40))
  call Hloop_SV_V(ntryL,G1H4(37),wf4(:,1),G1H1(2),m3h4x1(:,35),heltab2x4(:,:,41))
  call Hloop_SV_V(ntryL,G1H4(39),wf4(:,1),G1H1(3),m3h4x1(:,36),heltab2x4(:,:,42))
  call Hloop_SV_T(ntryL,G0H4(6),8,wf4(:,2),3,G1H1(4),m3h4x1(:,37),heltab2x4(:,:,43))
  call Hloop_TV_S(ntryL,G0H4(7),8,wf4(:,2),3,G1H1(5),m3h4x1(:,38),heltab2x4(:,:,44))
  call Hloop_TV_S(ntryL,G0H4(8),8,wf4(:,1),3,G1H1(6),m3h4x1(:,39),heltab2x4(:,:,45))
  call Hloop_SV_T(ntryL,G0H4(9),8,wf4(:,1),3,G1H1(7),m3h4x1(:,40),heltab2x4(:,:,46))
  call Hloop_TV_S(ntryL,G0H4(10),8,wf4(:,1),3,G1H1(8),m3h4x1(:,41),heltab2x4(:,:,47))
  call Hloop_UW_V(ntryL,G0H4(11),8,wf4(:,2),3,G1H1(9),m3h4x1(:,42),heltab2x4(:,:,48))
  call Hloop_UV_W(ntryL,G0H4(12),8,wf4(:,2),3,G1H1(10),m3h4x1(:,43),heltab2x4(:,:,49))
  call Hloop_UW_V(ntryL,G0H4(13),8,wf4(:,1),3,G1H1(11),m3h4x1(:,44),heltab2x4(:,:,50))
  call Hloop_UV_W(ntryL,G0H4(14),8,wf4(:,1),3,G1H1(12),m3h4x1(:,45),heltab2x4(:,:,51))
  call Hloop_VV_S(ntryL,G1H4(41),wf4(:,2),G1H1(13),m3h4x1(:,46),heltab2x4(:,:,52))
  call Hloop_VV_S(ntryL,G1H4(43),wf4(:,1),G1H1(14),m3h4x1(:,47),heltab2x4(:,:,53))
  call Hloop_SV_V(ntryL,G0H4(16),wf4(:,2),G0H1(4),m3h4x1(:,48),heltab2x4(:,:,54))
  call Hloop_SV_V(ntryL,G0H4(17),wf4(:,1),G0H1(5),m3h4x1(:,49),heltab2x4(:,:,55))
  call Hloop_SV_V(ntryL,G0H4(19),wf4(:,1),G0H1(6),m3h4x1(:,50),heltab2x4(:,:,56))
  call Hloop_QA_Z(ntryL,G1H2(3),ex2(:),G1H1(15),ngZl,m3h2x1(:,7),heltab2x2(:,:,9))
  call Hloop_QA_W(ntryL,G1H2(4),ex2(:),G1H1(16),m3h2x1(:,8),heltab2x2(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H2(1),ex1(:),G1H1(17),ngZl,m3h2x1(:,9),heltab2x2(:,:,11))
  call Hloop_AQ_W(ntryL,G1H2(2),ex1(:),G1H1(18),m3h2x1(:,10),heltab2x2(:,:,12))
  call Hloop_AQ_V(ntryL,G1H4(44),ex1(:),G1H2(3),m3h2x2(:,7),heltab2x4(:,:,57))
  call Hloop_AQ_Z(ntryL,G1H4(45),ex1(:),G1H2(4),ngZl,m3h2x2(:,8),heltab2x4(:,:,58))
  call Hloop_AQ_W(ntryL,G1H4(46),ex1(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,59))
  call Hloop_WQ_A(ntryL,G1H4(47),ex1(:),G1H2(2),m3h2x2(:,10),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(2),13,0,G2H2(1),n2h2(9))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G2H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(10),[G2H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G2H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(12),[G2H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(13),[G2H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(14),[G2H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(15),[G2H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(16),[G2H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(22),[G2H1(21),G2H1(18),G2H1(17),G0H1(3),G0H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(19),[G0H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(25),[G2H1(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(26),[G2H1(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(30),[G2H1(29),G2H1(28),G2H1(27),G0H1(6),G0H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(12),[G1H1(11),G1H1(10),G1H1(9),G1H1(3),G1H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(14),[G1H1(13),G1H1(8),G1H1(7),G1H1(5),G1H1(4)])
  call Hloop_AS_Q(ntryL,G2H1(9),ex3(:),G2H1(1),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(1),n2h1(19))
  call Hloop_AS_Q(ntryL,G2H1(10),ex3(:),G2H1(2),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),15,nML,G3tensor(2),n2h1(20))
  call Hloop_QS_A(ntryL,G2H1(11),ex3(:),G2H1(3),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),15,nMM,G3tensor(3),n2h1(21))
  call Hloop_QS_A(ntryL,G2H1(12),ex3(:),G2H1(4),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),15,nML,G3tensor(4),n2h1(22))
  call Hloop_AS_Q(ntryL,G2H1(13),ex3(:),G2H1(5),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),15,nMT,G3tensor(5),n2h1(23))
  call Hloop_QS_A(ntryL,G2H1(14),ex3(:),G2H1(6),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(6),15,nMT,G3tensor(6),n2h1(24))
  call Hloop_AS_Q(ntryL,G2H1(15),ex3(:),G2H1(7),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),15,nMB,G3tensor(7),n2h1(25))
  call Hloop_QS_A(ntryL,G2H1(16),ex3(:),G2H1(8),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),15,nMB,G3tensor(8),n2h1(26))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(22),ex3(:),G2tensor(1),m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(19),ex3(:),G2tensor(3),m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(20),ex3(:),G2tensor(2),m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(25),ex3(:),G2tensor(4),m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(26),ex3(:),G2tensor(5),m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(30),ex3(:),G2tensor(6),m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(12),11,ex3(:),4,G2tensor(7),m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(2),11,ex3(:),4,G2tensor(8),m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(14),11,ex3(:),4,G2tensor(9),m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(6),11,ex3(:),4,G2tensor(10),m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H1(5),ex3(:),G0tensor(1),m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(15),ex3(:),G1tensor(1),m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(16),ex3(:),G1tensor(6),m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(17),ex3(:),G1tensor(11),m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(18),ex3(:),G1tensor(16),m3h1x1(:,27),heltab2x1(:,:,27))
  call Hloop_VA_Q(ntryL,G1H2(3),ex2(:),G1H1(11),m3h2x1(:,11),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),15,0,G2tensor(11),n2h1(27))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex2(:),G1H1(10),ngZl,m3h2x1(:,12),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),15,0,G2tensor(12),n2h1(28))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(9),m3h2x1(:,13),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),15,0,G2tensor(13),n2h1(29))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,16))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(16),[G1tensor(17),G1tensor(3),G0tensor(17),G0tensor(3)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(7),G2tensor(6),G2tensor(5),G2tensor(4),G2tensor(1),G1tensor(9),G1tensor(4) &
    ,G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(5)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(8),G0tensor(8)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(10)])
  call ol_merge_tensors(G1tensor(11),[G1tensor(12),G0tensor(12)])
  call ol_merge_tensors(G1tensor(13),[G0tensor(13)])
  call ol_merge_tensors(G1tensor(14),[G0tensor(14)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(15)])
  call ol_merge_tensors(G1tensor(18),[G0tensor(18)])
  call ol_merge_tensors(G1tensor(19),[G0tensor(19)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(20)])
  call ol_merge_tensors(G3tensor(3),[G3tensor(1)])
  call ol_merge_tensors(G3tensor(4),[G3tensor(2)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(5)])
  call ol_merge_tensors(G3tensor(8),[G3tensor(7)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(8),G2tensor(2),G0tensor(1)])
  call TI_triangle_red(G2tensor(9),RedBasis(2),mass3set(:,1),G0tensor(6),G0tensor(11),G0tensor(16),G0tensor(2),M2L1R1,[nMW], &
    G0tensor(17))
  call TI_triangle_red(G2tensor(14),RedBasis(8),mass3set(:,2),G0tensor(3),G0tensor(9),G0tensor(4),G0tensor(5),M2L1R1,[nMW], &
    G0tensor(7))
  call TI_triangle_red(G3tensor(3),RedBasis(2),mass3set(:,3),G0tensor(8),G0tensor(10),G0tensor(12),G0tensor(13),M2L1R1,[nMM], &
    G0tensor(14))
  call TI_triangle_red(G3tensor(4),RedBasis(2),mass3set(:,4),G0tensor(15),G0tensor(18),G0tensor(19),G0tensor(20),M2L1R1,[nML], &
    G0tensor(1))
  call TI_triangle_red(G3tensor(6),RedBasis(2),mass3set(:,5),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),M2L1R1,[nMT], &
    G0tensor(25))
  call TI_triangle_red(G3tensor(8),RedBasis(2),mass3set(:,6),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),M2L1R1,[nMB], &
    G0tensor(30))
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,7),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),M2L1R1,[nMH,nMZ], &
    G0tensor(35),G0tensor(36))
  call TI_triangle_red(G2tensor(10),RedBasis(2),mass3set(:,8),G0tensor(37),G0tensor(38),G0tensor(39), &
    G0tensor(40),M2L1R1,[nMZ,nMH],G0tensor(41),G0tensor(42))
  call TI_triangle_red(G2tensor(11),RedBasis(8),mass3set(:,9),G0tensor(43),G0tensor(44),G0tensor(45),G0tensor(46),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(8),mass3set(:,10),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50),M2L1R1,[nMZ], &
    G0tensor(51))
  call TI_triangle_red(G2tensor(13),RedBasis(8),mass3set(:,11),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55),M2L1R1,[nMW], &
    G0tensor(56))
  call TI_triangle_red(G1tensor(2),RedBasis(9),mass3set(:,2),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1,[nMW], &
    G0tensor(61))
  call TI_triangle_red(G1tensor(16),RedBasis(3),mass3set(:,12),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65),M2L1R1,[nMW], &
    G0tensor(66))
  call TI_triangle_red(G1tensor(5),RedBasis(1),mass3set(:,2),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70),M2L1R1,[nMW], &
    G0tensor(71))
  call TI_triangle_red(G1tensor(6),RedBasis(5),mass3set(:,12),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75),M2L1R1,[nMW], &
    G0tensor(76))
  call TI_triangle_red(G1tensor(10),RedBasis(4),mass3set(:,2),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),M2L1R1,[nMW], &
    G0tensor(81))
  call TI_triangle_red(G1tensor(11),RedBasis(3),mass3set(:,13),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85),M2L1R1,[nMZ], &
    G0tensor(86))
  call TI_triangle_red(G1tensor(13),RedBasis(7),mass3set(:,14),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90),M2L1R1,[nMZ], &
    G0tensor(91))
  call TI_triangle_red(G1tensor(14),RedBasis(6),mass3set(:,10),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),M2L1R1,[nMZ], &
    G0tensor(96))
  call TI_triangle_red(G1tensor(15),RedBasis(4),mass3set(:,10),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),M2L1R1,[nMZ], &
    G0tensor(101))
  call TI_triangle_red(G1tensor(18),RedBasis(7),mass3set(:,15),G0tensor(102),G0tensor(103),G0tensor(104), &
    G0tensor(105),M2L1R1,[nMW],G0tensor(106))
  call TI_triangle_red(G1tensor(19),RedBasis(6),mass3set(:,11),G0tensor(107),G0tensor(108),G0tensor(109), &
    G0tensor(110),M2L1R1,[nMW],G0tensor(111))
  call TI_triangle_red(G1tensor(20),RedBasis(4),mass3set(:,11),G0tensor(112),G0tensor(113),G0tensor(114), &
    G0tensor(115),M2L1R1,[nMW],G0tensor(116))
  call TI_triangle_red(G1tensor(1),RedBasis(5),mass3set(:,13),G0tensor(117),G0tensor(118),G0tensor(119), &
    G0tensor(120),M2L1R1,[nMZ],G0tensor(121))
  call ol_merge_tensors(T0sum(5),[G0tensor(57)])
  call ol_merge_tensors(T0sum(6),[G0tensor(62)])
  call ol_merge_tensors(T0sum(7),[G0tensor(6)])
  call ol_merge_tensors(T0sum(8),[G0tensor(67)])
  call ol_merge_tensors(T0sum(9),[G0tensor(3)])
  call ol_merge_tensors(T0sum(10),[G0tensor(72)])
  call ol_merge_tensors(T0sum(11),[G0tensor(77)])
  call ol_merge_tensors(T0sum(12),[G0tensor(82)])
  call ol_merge_tensors(T0sum(13),[G0tensor(87)])
  call ol_merge_tensors(T0sum(14),[G0tensor(92)])
  call ol_merge_tensors(T0sum(15),[G0tensor(97)])
  call ol_merge_tensors(T0sum(16),[G0tensor(102)])
  call ol_merge_tensors(T0sum(17),[G0tensor(107)])
  call ol_merge_tensors(T0sum(18),[G0tensor(112)])
  call ol_merge_tensors(T0sum(19),[G0tensor(8)])
  call ol_merge_tensors(T0sum(20),[G0tensor(15)])
  call ol_merge_tensors(T0sum(21),[G0tensor(21)])
  call ol_merge_tensors(T0sum(22),[G0tensor(26)])
  call ol_merge_tensors(T0sum(23),[G0tensor(31)])
  call ol_merge_tensors(T0sum(24),[G0tensor(37)])
  call ol_merge_tensors(T0sum(25),[G0tensor(117)])
  call ol_merge_tensors(T0sum(26),[G0tensor(43)])
  call ol_merge_tensors(T0sum(27),[G0tensor(47)])
  call ol_merge_tensors(T0sum(28),[G0tensor(52)])
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(77),h0tab(:,77),[11,4],[nMW,nMW],3,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H12(1),ex4(:),wf4(:,2),G0H1(3),m4h3x4x1(:,1),heltab3x12(:,:,1))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(78),h0tab(:,78),[11,4],[nMH,nMH],3,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H12(1),ex4(:),wf4(:,1),G0H1(1),m4h3x4x1(:,2),heltab3x12(:,:,2))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(79),h0tab(:,79),[11,4],[nMZ,nMZ],3,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H12(1),ex4(:),wf4(:,1),G0H1(2),m4h3x4x1(:,3),heltab3x12(:,:,3))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(80),h0tab(:,80),[11,4],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H12(1),ex4(:),wf4(:,1),G0H1(6),m4h3x4x1(:,4),heltab3x12(:,:,4))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(81),h0tab(:,81),[11,4],[nMW,nMW],3,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H12(1),ex4(:),wf4(:,2),G0H1(4),m4h3x4x1(:,5),heltab3x12(:,:,5))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(82),h0tab(:,82),[11,4],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H12(1),ex4(:),wf4(:,1),G0H1(5),m4h3x4x1(:,6),heltab3x12(:,:,6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(83),h0tab(:,83),[8,7],[nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(20),m3h3x4(:,73),heltab2x12(:,:,77))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(84),h0tab(:,84),[8,7],[nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(1),m3h3x4(:,74),heltab2x12(:,:,78))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(85),h0tab(:,85),[8,7],[nMZ,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(4),m3h3x4(:,75),heltab2x12(:,:,79))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(86),h0tab(:,86),[8,7],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(15),m3h3x4(:,76),heltab2x12(:,:,80))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(87),h0tab(:,87),[8,7],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H12(1),ex4(:),G0H4(18),m3h3x4(:,77),heltab2x12(:,:,81))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(88),h0tab(:,88),[12,3],[nMW,nMW],3,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H12(1),ex4(:),ex3(:),G0H4(2),m4h3x1x4(:,1),heltab3x12(:,:,7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(89),h0tab(:,89),[12,3],[nMW,nMW],3,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H12(1),ex4(:),ex3(:),G0H4(3),m4h3x1x4(:,2),heltab3x12(:,:,8))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(90),h0tab(:,90),[12,3],[nMH,nMZ],3,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H12(1),ex4(:),ex3(:),G0H4(5),m4h3x1x4(:,3),heltab3x12(:,:,9))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(91),h0tab(:,91),[12,3],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H12(1),ex4(:),ex3(:),G0H4(6),m4h3x1x4(:,4),heltab3x12(:,:,10))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(92),h0tab(:,92),[12,3],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H12(1),ex4(:),ex3(:),G0H4(7),m4h3x1x4(:,5),heltab3x12(:,:,11))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(93),h0tab(:,93),[12,3],[nMM,nMM],2,2,wf3(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(8),ngX,m3h3x4(:,78),heltab2x12(:,:,82))
  call Hloop_Q_A(ntryL,G0H4(8),12,nMM,G1H4(23),n2h4(22))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(94),h0tab(:,94),[12,3],[nML,nML],2,2,wf3(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(9),ngX,m3h3x4(:,79),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G0H4(9),12,nML,G1H4(24),n2h4(23))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(95),h0tab(:,95),[12,3],[nMT,nMT],2,2,wf3(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(10),ngX,m3h3x4(:,80),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMT,G1H4(27),n2h4(24))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(96),h0tab(:,96),[12,3],[nMB,nMB],2,2,wf3(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(11),ngX,m3h3x4(:,81),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G0H4(11),12,nMB,G1H4(28),n2h4(25))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(97),h0tab(:,97),[12,3],[nMM,nMM],2,2,wf3(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(12),ngX,m3h3x4(:,82),heltab2x12(:,:,86))
  call Hloop_Q_A(ntryL,G0H4(12),12,nMM,G1H4(35),n2h4(26))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(98),h0tab(:,98),[12,3],[nML,nML],2,2,wf3(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(13),ngX,m3h3x4(:,83),heltab2x12(:,:,87))
  call Hloop_Q_A(ntryL,G0H4(13),12,nML,G1H4(38),n2h4(27))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(99),h0tab(:,99),[12,3],[nMT,nMT],2,2,wf3(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(14),ngX,m3h3x4(:,84),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G0H4(14),12,nMT,G1H4(40),n2h4(28))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(100),h0tab(:,100),[12,3],[nMB,nMB],2,2,wf3(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H12(1),wf3(:,3),G0H4(16),ngX,m3h3x4(:,85),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMB,G1H4(42),n2h4(29))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(101),h0tab(:,101),[12,3],[nMH,nMZ],2,2,wf3(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H12(1),wf3(:,3),G0H4(17),m3h3x4(:,86),heltab2x12(:,:,90))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(102),h0tab(:,102),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H12(1),wf3(:,3),G0H4(19),m3h3x4(:,87),heltab2x12(:,:,91))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(103),h0tab(:,103),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H12(1),wf3(:,3),G0H4(8),m3h3x4(:,88),heltab2x12(:,:,92))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(104),h0tab(:,104),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H12(1),wf3(:,3),G0H4(9),m3h3x4(:,89),heltab2x12(:,:,93))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(105),h0tab(:,105),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H12(1),wf3(:,3),G0H4(10),m3h3x4(:,90),heltab2x12(:,:,94))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(106),h0tab(:,106),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H12(1),0,wf3(:,3),12,G1H4(1),m3h3x4(:,91),heltab2x12(:,:,95))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(107),h0tab(:,107),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H12(1),0,wf3(:,3),12,G1H4(2),m3h3x4(:,92),heltab2x12(:,:,96))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(108),h0tab(:,108),[12,3],[nMH,nMZ],2,2,wf3(:,3),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H12(1),0,wf3(:,3),12,G1H4(3),m3h3x4(:,93),heltab2x12(:,:,97))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(109),h0tab(:,109),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H12(1),0,wf3(:,3),12,G1H4(4),m3h3x4(:,94),heltab2x12(:,:,98))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(110),h0tab(:,110),[12,3],[nMW,nMW],2,2,wf3(:,3),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H12(1),0,wf3(:,3),12,G1H4(5),m3h3x4(:,95),heltab2x12(:,:,99))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(111),h0tab(:,111),[12,3],[0,0],2,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(11),ngZl,m3h3x4(:,96),heltab2x12(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(11),12,0,G1H4(6),n2h4(30))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(112),h0tab(:,112),[12,3],[nMM,nMM],2,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(12),ngZl,m3h3x4(:,97),heltab2x12(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(12),12,nMM,G1H4(7),n2h4(31))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(113),h0tab(:,113),[12,3],[nML,nML],2,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(13),ngZl,m3h3x4(:,98),heltab2x12(:,:,102))
  call Hloop_Q_A(ntryL,G0H4(13),12,nML,G1H4(8),n2h4(32))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(114),h0tab(:,114),[12,3],[0,0],2,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(14),ngZu,m3h3x4(:,99),heltab2x12(:,:,103))
  call Hloop_Q_A(ntryL,G0H4(14),12,0,G1H4(9),n2h4(33))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(115),h0tab(:,115),[12,3],[nMT,nMT],2,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(16),ngZu,m3h3x4(:,100),heltab2x12(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMT,G1H4(10),n2h4(34))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(116),h0tab(:,116),[12,3],[0,0],2,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(11),ngZd,m3h3x4(:,101),heltab2x12(:,:,105))
  call Hloop_Q_A(ntryL,G0H4(11),12,0,G1H4(11),n2h4(35))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(117),h0tab(:,117),[12,3],[nMB,nMB],2,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(12),ngZd,m3h3x4(:,102),heltab2x12(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(12),12,nMB,G1H4(12),n2h4(36))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(118),h0tab(:,118),[12,3],[0,0],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(13),ngZn,m3h3x4(:,103),heltab2x12(:,:,107))
  call Hloop_Q_A(ntryL,G0H4(13),12,0,G1H4(13),n2h4(37))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(119),h0tab(:,119),[12,3],[0,0],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(14),ngZl,m3h3x4(:,104),heltab2x12(:,:,108))
  call Hloop_Q_A(ntryL,G0H4(14),12,0,G1H4(14),n2h4(38))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(120),h0tab(:,120),[12,3],[nMM,nMM],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(16),ngZl,m3h3x4(:,105),heltab2x12(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMM,G1H4(15),n2h4(39))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(121),h0tab(:,121),[12,3],[nML,nML],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(11),ngZl,m3h3x4(:,106),heltab2x12(:,:,110))
  call Hloop_Q_A(ntryL,G0H4(11),12,nML,G1H4(16),n2h4(40))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(122),h0tab(:,122),[12,3],[0,0],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(12),ngZu,m3h3x4(:,107),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G0H4(12),12,0,G1H4(17),n2h4(41))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(123),h0tab(:,123),[12,3],[nMT,nMT],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(13),ngZu,m3h3x4(:,108),heltab2x12(:,:,112))
  call Hloop_Q_A(ntryL,G0H4(13),12,nMT,G1H4(18),n2h4(42))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(124),h0tab(:,124),[12,3],[0,0],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(14),ngZd,m3h3x4(:,109),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(14),12,0,G1H4(19),n2h4(43))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(125),h0tab(:,125),[12,3],[nMB,nMB],2,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H12(1),wf3(:,1),G0H4(16),ngZd,m3h3x4(:,110),heltab2x12(:,:,114))
  call Hloop_Q_A(ntryL,G0H4(16),12,nMB,G1H4(20),n2h4(44))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(126),h0tab(:,126),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(21),m3h3x4(:,111),heltab2x12(:,:,115))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(127),h0tab(:,127),[12,3],[nMH,nMZ],2,2,wf3(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(22),m3h3x4(:,112),heltab2x12(:,:,116))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(128),h0tab(:,128),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(25),m3h3x4(:,113),heltab2x12(:,:,117))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(129),h0tab(:,129),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(26),m3h3x4(:,114),heltab2x12(:,:,118))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(130),h0tab(:,130),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(29),m3h3x4(:,115),heltab2x12(:,:,119))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(131),h0tab(:,131),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(30),m3h3x4(:,116),heltab2x12(:,:,120))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(132),h0tab(:,132),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(31),m3h3x4(:,117),heltab2x12(:,:,121))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(133),h0tab(:,133),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(32),m3h3x4(:,118),heltab2x12(:,:,122))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(134),h0tab(:,134),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H12(1),0,wf3(:,1),12,G1H4(33),m3h3x4(:,119),heltab2x12(:,:,123))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(135),h0tab(:,135),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H12(1),wf3(:,1),G0H4(11),m3h3x4(:,120),heltab2x12(:,:,124))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(136),h0tab(:,136),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H12(1),wf3(:,1),G0H4(12),m3h3x4(:,121),heltab2x12(:,:,125))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(137),h0tab(:,137),[12,3],[nMH,nMZ],2,2,wf3(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),wf3(:,1),G0H4(13),m3h3x4(:,122),heltab2x12(:,:,126))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(138),h0tab(:,138),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),wf3(:,1),G0H4(14),m3h3x4(:,123),heltab2x12(:,:,127))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(139),h0tab(:,139),[12,3],[nMW,nMW],2,2,wf3(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H12(1),wf3(:,1),G0H4(16),m3h3x4(:,124),heltab2x12(:,:,128))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(6),[G0H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(5),[G0H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(1),[G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(18),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(1),G0H4(12),G0H4(11),G0H4(3),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G0H4(13),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(4),G0H4(16),G0H4(14),G0H4(7),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(26),G0H4(8),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30),G0H4(10),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(9),G1H4(6)])
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(6),ex3(:),G0tensor(57),m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(1),ex3(:),G0tensor(62),m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(2),ex3(:),G0tensor(6),m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H1(5),ex3(:),G0tensor(67),m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H4(1),wf4(:,2),ex3(:),G0tensor(3),m4h4x1x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H4(4),wf4(:,1),ex3(:),G0tensor(72),m4h4x1x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H4(18),wf4(:,1),ex3(:),G0tensor(77),m4h4x1x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(2),wf4(:,2),G1tensor(17),m3h4x1(:,51),heltab2x4(:,:,61))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(3),wf4(:,1),G1tensor(3),m3h4x1(:,52),heltab2x4(:,:,62))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(5),wf4(:,1),G1tensor(9),m3h4x1(:,53),heltab2x4(:,:,63))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,2),G1H1(3),m3h4x1(:,54),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),15,nMM,G2tensor(7),n2h1(30))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(6),n2h1(31))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,2),G1H1(13),m3h4x1(:,56),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),15,nMT,G2tensor(5),n2h1(32))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,2),G1H1(8),m3h4x1(:,57),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),15,nMB,G2tensor(4),n2h1(33))
  call Hloop_QZ_A(ntryL,G1H4(15),wf4(:,1),G1H1(7),ngZl,m3h4x1(:,58),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),15,nMM,G2tensor(1),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,1),G1H1(5),ngZl,m3h4x1(:,59),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),15,nML,G2tensor(8),n2h1(35))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,1),G1H1(4),ngZu,m3h4x1(:,60),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),15,nMT,G2tensor(2),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,1),G1H1(12),ngZd,m3h4x1(:,61),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),15,nMB,G2tensor(9),n2h1(37))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(22),12,wf4(:,1),3,G2tensor(14),m3h4x1(:,62),heltab2x4(:,:,72))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(29),12,wf4(:,2),3,G2tensor(3),m3h4x1(:,63),heltab2x4(:,:,73))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(31),12,wf4(:,1),3,G2tensor(10),m3h4x1(:,64),heltab2x4(:,:,74))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,2),G1H1(2),m3h4x1(:,65),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),15,0,G2tensor(11),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,1),G1H1(14),ngZn,m3h4x1(:,66),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),15,0,G2tensor(12),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,1),G1H1(6),ngZl,m3h4x1(:,67),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),15,0,G2tensor(13),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,1),G1H1(15),ngZu,m3h4x1(:,68),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),15,0,G2tensor(15),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,1),G1H1(16),ngZd,m3h4x1(:,69),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),15,0,G2tensor(16),n2h1(42))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(21),12,wf4(:,2),3,G2tensor(17),m3h4x1(:,70),heltab2x4(:,:,80))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(25),12,wf4(:,1),3,G2tensor(18),m3h4x1(:,71),heltab2x4(:,:,81))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(32),12,wf4(:,2),3,G2tensor(19),m3h4x1(:,72),heltab2x4(:,:,82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(33),12,wf4(:,1),3,G2tensor(20),m3h4x1(:,73),heltab2x4(:,:,83))
  call ol_merge_tensors(G2tensor(20),[G2tensor(19),G2tensor(18),G2tensor(17),G2tensor(10),G2tensor(3),G1tensor(9),G1tensor(17) &
    ,G0tensor(60),G0tensor(5),G0tensor(11)])
  call ol_merge_tensors(G0tensor(67),[G0tensor(57),G0tensor(103),G0tensor(74),G0tensor(64),G0tensor(16)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(3),G0tensor(80),G0tensor(70),G0tensor(2)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(111),G0tensor(106),G0tensor(81),G0tensor(76),G0tensor(71),G0tensor(66) &
    ,G0tensor(61),G0tensor(56),G0tensor(7),G0tensor(17)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(9)])
  call ol_merge_tensors(G0tensor(73),[G0tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(7),G0tensor(10)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(6),G0tensor(18)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(5),G0tensor(22)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(4),G0tensor(27)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(33)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(34)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(35)])
  call ol_merge_tensors(G0tensor(121),[G0tensor(101),G0tensor(96),G0tensor(91),G0tensor(86),G0tensor(51),G0tensor(41) &
    ,G0tensor(36)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(3),G0tensor(38)])
  call ol_merge_tensors(G0tensor(6),[G0tensor(119),G0tensor(88),G0tensor(84),G0tensor(39)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(15),G2tensor(13),G2tensor(12),G2tensor(11),G0tensor(55),G0tensor(50) &
    ,G0tensor(46)])
  call ol_merge_tensors(G0tensor(98),[G0tensor(83),G0tensor(48)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(89),G0tensor(49)])
  call ol_merge_tensors(G0tensor(113),[G0tensor(63),G0tensor(59),G0tensor(53)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(104),G0tensor(68),G0tensor(58),G0tensor(54)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(69),G0tensor(65)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(75)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(85)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(90)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(110),G0tensor(100),G0tensor(95)])
  call ol_merge_tensors(G0tensor(114),[G0tensor(105)])
call TI_bubble_red(G2tensor(20),12,mass2set(:,1),G0tensor(82),M2L1R1,G0tensor(87))
call TI_bubble_red(G2tensor(1),12,mass2set(:,2),G0tensor(92),M2L1R1,G0tensor(97))
call TI_bubble_red(G2tensor(8),12,mass2set(:,3),G0tensor(102),M2L1R1,G0tensor(107))
call TI_bubble_red(G2tensor(2),12,mass2set(:,4),G0tensor(112),M2L1R1,G0tensor(8))
call TI_bubble_red(G2tensor(9),12,mass2set(:,5),G0tensor(15),M2L1R1,G0tensor(21))
call TI_bubble_red(G2tensor(14),12,mass2set(:,6),G0tensor(26),M2L1R1,G0tensor(31),G0tensor(37))
call TI_bubble_red(G2tensor(16),12,mass2set(:,7),G0tensor(117),M2L1R1)
  call ol_merge_tensors(G0tensor(116),[G0tensor(87)])
  call ol_merge_tensors(G0tensor(14),[G0tensor(97)])
  call ol_merge_tensors(G0tensor(1),[G0tensor(107)])
  call ol_merge_tensors(G0tensor(25),[G0tensor(8)])
  call ol_merge_tensors(G0tensor(30),[G0tensor(21)])
  call ol_merge_tensors(G0tensor(37),[G0tensor(42)])
  call ol_merge_tensors(G0tensor(31),[G0tensor(121)])
  call ol_merge_tensors(T0sum(29),[G0tensor(82)])
  call ol_merge_tensors(T0sum(30),[G0tensor(116)])
  call ol_merge_tensors(T0sum(31),[G0tensor(67)])
  call ol_merge_tensors(T0sum(32),[G0tensor(77)])
  call ol_merge_tensors(T0sum(33),[G0tensor(78)])
  call ol_merge_tensors(T0sum(34),[G0tensor(73)])
  call ol_merge_tensors(T0sum(35),[G0tensor(92)])
  call ol_merge_tensors(T0sum(36),[G0tensor(14)])
  call ol_merge_tensors(T0sum(37),[G0tensor(12)])
  call ol_merge_tensors(T0sum(38),[G0tensor(13)])
  call ol_merge_tensors(T0sum(39),[G0tensor(102)])
  call ol_merge_tensors(T0sum(40),[G0tensor(1)])
  call ol_merge_tensors(T0sum(41),[G0tensor(19)])
  call ol_merge_tensors(T0sum(42),[G0tensor(20)])
  call ol_merge_tensors(T0sum(43),[G0tensor(112)])
  call ol_merge_tensors(T0sum(44),[G0tensor(25)])
  call ol_merge_tensors(T0sum(45),[G0tensor(23)])
  call ol_merge_tensors(T0sum(46),[G0tensor(24)])
  call ol_merge_tensors(T0sum(47),[G0tensor(15)])
  call ol_merge_tensors(T0sum(48),[G0tensor(30)])
  call ol_merge_tensors(T0sum(49),[G0tensor(28)])
  call ol_merge_tensors(T0sum(50),[G0tensor(29)])
  call ol_merge_tensors(T0sum(51),[G0tensor(32)])
  call ol_merge_tensors(T0sum(52),[G0tensor(62)])
  call ol_merge_tensors(T0sum(53),[G0tensor(72)])
  call ol_merge_tensors(T0sum(54),[G0tensor(37)])
  call ol_merge_tensors(T0sum(55),[G0tensor(31)])
  call ol_merge_tensors(T0sum(56),[G0tensor(26)])
  call ol_merge_tensors(T0sum(57),[G0tensor(6)])
  call ol_merge_tensors(T0sum(58),[G0tensor(40)])
  call ol_merge_tensors(T0sum(59),[G0tensor(44)])
  call ol_merge_tensors(T0sum(60),[G0tensor(45)])
  call ol_merge_tensors(T0sum(61),[G0tensor(117)])
  call ol_merge_tensors(T0sum(62),[G0tensor(98)])
  call ol_merge_tensors(T0sum(63),[G0tensor(94)])
  call ol_merge_tensors(T0sum(64),[G0tensor(113)])
  call ol_merge_tensors(T0sum(65),[G0tensor(109)])
  call ol_merge_tensors(T0sum(66),[G0tensor(108)])
  call ol_merge_tensors(T0sum(67),[G0tensor(79)])
  call ol_merge_tensors(T0sum(68),[G0tensor(93)])
  call ol_merge_tensors(T0sum(69),[G0tensor(99)])
  call ol_merge_tensors(T0sum(70),[G0tensor(115)])
  call ol_merge_tensors(T0sum(71),[G0tensor(114)])
  call ol_merge_tensors(T0sum(72),[G0tensor(118)])
  call ol_merge_tensors(T0sum(73),[G0tensor(120)])
! end of process

! end do

end subroutine vamp_1

end module ol_vamp_1_eehv_ew_eexhz_1_/**/REALKIND
