
module ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [  16]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   2]
  K1(11,:) = [  16]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [   0]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [ -18]
  K1(20,:) = [ -18]
  K1(21,:) = [   0]
  K1(22,:) = [  36]
  K1(23,:) = [   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND



module ol_forced_parameters_eehttj_eexttxhg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_eehttj_eexttxhg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_eehttj_eexttxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  complex(REALKIND), save :: den(143)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,13), wf4(4,43), wf8(8,54), wf16(16,24), wf32(32,87)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(34), c(19)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(1,32), M0M1_hel_cc(1,32,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_eehttj_eexttxhg_1_/**/REALKIND






! **********************************************************************
module ol_loop_eehttj_eexttxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_eehttj_eexttxhg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*countertermnorm*ctHGG*eQED**3*gQCD**3)/3._/**/REALKIND
    f( 2) = CI*countertermnorm*ctHGG*eQED**3*gQCD**3
    f( 3) = (CI*eQED**3*gQCD*MT)/(3._/**/REALKIND*MW*sw)
    f( 4) = (CI*eQED**3*gQCD*MT)/(2._/**/REALKIND*MW*sw)
    f( 5) = (CI*countertermnorm*eQED**3*gQCD**3*MT)/(3._/**/REALKIND*MW*sw)
    f( 6) = (CI*countertermnorm*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 7) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MT)/(3._/**/REALKIND*MW*sw)
    f( 8) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 9) = (CI*countertermnorm*ctStt*eQED**3*gQCD**3*MT)/(3._/**/REALKIND*MW*sw)
    f(10) = (CI*countertermnorm*ctStt*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f(11) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**3*MT)/(3._/**/REALKIND*MW*sw)
    f(12) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f(13) = (countertermnorm*ctZGG*eQED**3*gQCD**3*MT)/(MW*sw*2._/**/REALKIND)
    f(14) = (CI*eQED**3*gQCD*MW)/(cw**2*sw)
    f(15) = (CI*countertermnorm*eQED**3*gQCD**3*MW)/(cw**2*sw)
    f(16) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MW)/(cw**2*sw)
    f(17) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**3*MW)/(cw**2*sw)
    f(18) = (countertermnorm*ctZGG*eQED**3*gQCD**3*MW)/(cw**2*sw)
    f(19) = (CI*eQED**3*gQCD**3*integralnorm*MT*SwB)/(3._/**/REALKIND*MW*sw)
    f(20) = (CI*eQED**3*gQCD**3*integralnorm*MT*SwB)/(2._/**/REALKIND*MW*sw)
    f(21) = (eQED**3*gQCD**3*integralnorm*MT*SwB)/(MW*sw*3._/**/REALKIND)
    f(22) = (eQED**3*gQCD**3*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(23) = (CI*eQED**3*gQCD**3*integralnorm*MW*SwB)/(cw**2*sw)
    f(24) = (eQED**3*gQCD**3*integralnorm*MW*SwB)/(cw**2*sw)
    f(25) = (eQED**3*gQCD**3*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(26) = (eQED**3*gQCD**3*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(27) = (eQED**3*gQCD**3*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(28) = (eQED**3*gQCD**3*integralnorm*MT*SwF)/(MW*sw*6._/**/REALKIND)
    f(29) = (eQED**3*gQCD**3*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(30) = (eQED**3*gQCD**3*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(31) = (2*eQED**3*gQCD**3*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(32) = (eQED**3*gQCD**3*integralnorm*MT*SwF)/(MW*sw)
    f(33) = (eQED**3*gQCD**3*integralnorm*MW*SwF)/(cw**2*sw)
    f(34) = (2*eQED**3*gQCD**3*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 9*CI*f(19), 9*CI*f(20), f(21), 8*f(21), f(22), 8*f(22), 9*CI*f(23), f(24), 8*f(24), 3*f(25), 3*f(26), 3*f(27), 3*f(28) &
    , 3*f(29), 3*f(30), 3*f(31), 3*f(32), 3*f(33), 3*f(34) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20) - MT2)+L(6,20))
  den(3) = 1 /((L(5,40) - MT2)+L(6,40))
  den(6) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,11) - MT2)+L(6,11))
  den(14) = 1 /((L(5,36) - MT2)+L(6,36))
  den(15) = 1 /((L(5,24) - MT2)+L(6,24))
  den(20) = 1 /((L(5,7) - MT2)+L(6,7))
  den(27) = 1 /((L(5,44) - MZ2)+L(6,44))
  den(34) = 1 /((L(5,12))+L(6,12))
  den(35) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(38) = 1 /((L(5,28))+L(6,28))
  den(43) = 1 /((L(5,48))+L(6,48))
  den(46) = 1 /((L(5,52) - MT2)+L(6,52))
  den(57) = 1 /((L(5,56) - MT2)+L(6,56))
  den(66) = 1 /((L(5,43) - MT2)+L(6,43))
  den(72) = 1 /((L(5,23) - MT2)+L(6,23))
  den(83) = 1 /((L(5,27) - MT2)+L(6,27))
  den(89) = 1 /((L(5,39) - MT2)+L(6,39))
  den(111) = 1 /((L(5,15))+L(6,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(12) = den(6)*den(9)
  den(13) = den(2)*den(12)
  den(16) = den(1)*den(14)
  den(17) = den(15)*den(16)
  den(18) = den(6)*den(14)
  den(19) = den(15)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(15)*den(21)
  den(23) = den(6)*den(20)
  den(24) = den(15)*den(23)
  den(25) = den(10)*den(14)
  den(26) = den(12)*den(14)
  den(28) = den(14)*den(27)
  den(29) = den(6)*den(28)
  den(30) = den(3)*den(21)
  den(31) = den(3)*den(23)
  den(32) = den(3)*den(27)
  den(33) = den(6)*den(32)
  den(36) = den(6)*den(35)
  den(37) = den(34)*den(36)
  den(39) = den(2)*den(38)
  den(40) = den(6)*den(39)
  den(41) = den(15)*den(38)
  den(42) = den(6)*den(41)
  den(44) = den(21)*den(43)
  den(45) = den(23)*den(43)
  den(47) = den(43)*den(46)
  den(48) = den(1)*den(47)
  den(49) = den(6)*den(47)
  den(50) = den(2)*den(46)
  den(51) = den(1)*den(50)
  den(52) = den(6)*den(50)
  den(53) = den(14)*den(36)
  den(54) = den(14)*den(46)
  den(55) = den(1)*den(54)
  den(56) = den(6)*den(54)
  den(58) = den(15)*den(57)
  den(59) = den(1)*den(58)
  den(60) = den(6)*den(58)
  den(61) = den(3)*den(36)
  den(62) = den(3)*den(57)
  den(63) = den(1)*den(62)
  den(64) = den(6)*den(62)
  den(65) = den(1)*den(3)
  den(67) = den(65)*den(66)
  den(68) = den(2)*den(67)
  den(69) = den(3)*den(6)
  den(70) = den(66)*den(69)
  den(71) = den(2)*den(70)
  den(73) = den(4)*den(72)
  den(74) = den(3)*den(73)
  den(75) = den(7)*den(72)
  den(76) = den(3)*den(75)
  den(77) = den(2)**2
  den(78) = den(10)*den(77)
  den(79) = den(12)*den(77)
  den(80) = den(10)*den(50)
  den(81) = den(12)*den(50)
  den(82) = den(1)*den(15)
  den(84) = den(82)*den(83)
  den(85) = den(14)*den(84)
  den(86) = den(6)*den(15)
  den(87) = den(83)*den(86)
  den(88) = den(14)*den(87)
  den(90) = den(16)*den(89)
  den(91) = den(15)*den(90)
  den(92) = den(18)*den(89)
  den(93) = den(15)*den(92)
  den(94) = den(21)*den(58)
  den(95) = den(23)*den(58)
  den(96) = den(15)**2
  den(97) = den(21)*den(96)
  den(98) = den(23)*den(96)
  den(99) = den(14)**2
  den(100) = den(36)*den(99)
  den(101) = den(10)*den(99)
  den(102) = den(12)*den(99)
  den(103) = den(10)*den(54)
  den(104) = den(12)*den(54)
  den(105) = den(3)**2
  den(106) = den(36)*den(105)
  den(107) = den(21)*den(62)
  den(108) = den(23)*den(62)
  den(109) = den(21)*den(105)
  den(110) = den(23)*den(105)
  den(112) = den(21)*den(111)
  den(113) = den(23)*den(111)
  den(114) = den(21)*den(72)
  den(115) = den(23)*den(72)
  den(116) = den(21)*den(89)
  den(117) = den(23)*den(89)
  den(118) = den(10)*den(111)
  den(119) = den(12)*den(111)
  den(120) = den(10)*den(83)
  den(121) = den(12)*den(83)
  den(122) = den(10)*den(66)
  den(123) = den(12)*den(66)
  den(124) = den(36)*den(72)
  den(125) = den(36)*den(83)
  den(126) = den(1)*den(34)
  den(127) = den(6)*den(34)
  den(128) = den(1)*den(2)*den(3)
  den(129) = den(2)*den(3)*den(6)
  den(130) = den(1)*den(39)
  den(131) = den(1)*den(14)*den(15)
  den(132) = den(6)*den(14)*den(15)
  den(133) = den(1)*den(41)
  den(134) = den(2)*den(122)
  den(135) = den(2)*den(123)
  den(136) = den(15)*den(116)
  den(137) = den(15)*den(117)
  den(138) = den(14)*den(120)
  den(139) = den(14)*den(121)
  den(140) = den(14)*den(125)
  den(141) = den(3)*den(114)
  den(142) = den(3)*den(115)
  den(143) = den(3)*den(124)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_eehttj_eexttxhg_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ top anti-top higgs glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_eehttj_eexttxhg_1, only: &
    & external_perm_eehttj_eexttxhg_1, &
    & external_perm_inv_eehttj_eexttxhg_1, &
    & extcomb_perm_eehttj_eexttxhg_1, &
    & average_factor_eehttj_eexttxhg_1, &
    & photonid_eehttj_eexttxhg_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_eehttj_eexttxhg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_eehttj_eexttxhg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_eehttj_eexttxhg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,32)
  type(Hpolcont) :: M1helarray_ct(1,32)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  type(Hpolcont) :: A(32,87)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(87)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if


  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMT, nMT, nMH, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_eehttj_eexttxhg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMT, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,1), n3(:,2), t3x2(:,:,1))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,2), n3(:,3), t3x4(:,:,2))
  call prop_Q_A(ntry, wf2(:,1), 20, MT, 1_intkind1, wf2(:,2), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 40, MT, 1_intkind1, wf4(:,3), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf2(:,2), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,5), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,4), 3, MZ, 1_intkind1, wf4(:,5), n2(3))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf2(:,2), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,6), n3(:,8), t3x4(:,:,4))
  call prop_A_Q(ntry, wf8(:,3), 11, MT, 1_intkind1, wf8(:,4), n2(4))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,5), n3(:,9), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,5), 11, MT, 1_intkind1, wf8(:,6), n2(5))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,7), n3(:,10), t3x4(:,:,5))
  call vert_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,3), n3(:,11), t3x2(:,:,2))
  call prop_Q_A(ntry, wf4(:,7), 36, MT, 1_intkind1, wf4(:,8), n2(6))
  call prop_A_Q(ntry, wf2(:,3), 24, MT, 1_intkind1, wf2(:,4), n2(7))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,1), n3(:,12), t3x16(:,:,1))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,8), wf16(:,2), n3(:,13), t3x16(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,7), n3(:,14), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,9), n3(:,15), t3x4(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 7, MT, 1_intkind1, wf8(:,8), n2(8))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,9), n3(:,16), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,9), 7, MT, 1_intkind1, wf8(:,10), n2(9))
  call vert_QS_A(gH,ntry, wf4(:,8), ex5(:), wf4(:,10), n3(:,17), t3x4(:,:,7))
  call vert_QA_Z(gZu,ntry, wf4(:,8), ex4(:), wf8(:,11), n3(:,18), t3x8(:,:,7))
  call vert_SV_V(ntry, ex5(:), wf4(:,5), wf4(:,11), n3(:,19), t3x4(:,:,8))
  call prop_W_W(ntry, wf8(:,11), 44, MZ, 1_intkind1, wf8(:,12), n2(10))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,12), n3(:,20), t3x4(:,:,9))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,3), wf8(:,13), n3(:,21), t3x8(:,:,8))
  call prop_W_W(ntry, wf8(:,13), 44, MZ, 1_intkind1, wf8(:,14), n2(11))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,13), n3(:,22), t3x4(:,:,10))
  call counter_GG_V(ntry, wf4(:,13), 12, ex6(:), 32, wf8(:,15), n3(:,23), t3x8(:,:,9))
  call prop_W_W(ntry, wf4(:,11), 19, MZ, 1_intkind1, wf4(:,14), n2(12))
  call counter_VQ_A(ntry, wf4(:,1), wf2(:,2), wf8(:,16), n3(:,24), t3x8(:,:,10))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), wf2(:,2), wf8(:,17), n3(:,25), t3x8(:,:,11))
  call counter_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,15), n3(:,26), t3x4(:,:,11))
  call vert_QA_V(ntry, wf2(:,2), ex4(:), wf4(:,16), n3(:,27), t3x4(:,:,12))
  call counter_VG_G(ntry, wf4(:,5), ex6(:), 32, wf8(:,18), 35, n3(:,28), t3x8(:,:,12))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,3), n3(:,29), t3x16(:,:,3))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,8), wf16(:,4), n3(:,30), t3x16(:,:,4))
  call counter_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,17), n3(:,31), t3x4(:,:,13))
  call vert_QA_V(ntry, ex3(:), wf2(:,4), wf4(:,18), n3(:,32), t3x4(:,:,14))
  call counter_QS_A(gH,ntry, wf4(:,8), ex5(:), wf4(:,19), n3(:,33), t3x4(:,:,15))
  call counter_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,20), n3(:,34), t3x4(:,:,16))
  call counter_SG_G(ntry, ex5(:), ex6(:), wf2(:,5), n3(:,35), t3x2(:,:,3))
  call vert_AV_Q(ntry, ex4(:), wf2(:,5), wf4(:,21), n3(:,36), t3x4(:,:,17))
  call vert_VQ_A(ntry, wf2(:,5), ex3(:), wf4(:,22), n3(:,37), t3x4(:,:,18))
  call prop_Q_A(ntry, wf4(:,22), 52, MT, 1_intkind1, wf4(:,23), n2(13))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,19), n3(:,38), t3x8(:,:,13))
  call prop_Q_A(ntry, wf4(:,6), 52, MT, 1_intkind1, wf4(:,24), n2(14))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,20), n3(:,39), t3x8(:,:,14))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,25), n3(:,40), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,25), 40, MT, 1_intkind1, wf4(:,26), n2(15))
  call counter_QA_Z(gZu,ntry, wf4(:,8), ex4(:), wf8(:,21), n3(:,41), t3x8(:,:,15))
  call prop_Q_A(ntry, wf4(:,10), 52, MT, 1_intkind1, wf4(:,27), n2(16))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,26), wf4(:,28), n3(:,42), t3x4(:,:,20))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,26), wf8(:,22), n3(:,43), t3x8(:,:,16))
  call prop_W_W(ntry, wf8(:,22), 44, MZ, 1_intkind1, wf8(:,23), n2(17))
  call counter_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,6), n3(:,44), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,6), 24, MT, 1_intkind1, wf2(:,7), n2(18))
  call vert_AV_Q(ntry, wf2(:,7), ex6(:), wf4(:,29), n3(:,45), t3x4(:,:,21))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,24), n3(:,46), t3x8(:,:,17))
  call prop_A_Q(ntry, wf4(:,9), 56, MT, 1_intkind1, wf4(:,30), n2(19))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,25), n3(:,47), t3x8(:,:,18))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,31), n3(:,48), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,31), 36, MT, 1_intkind1, wf4(:,32), n2(20))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,32), wf16(:,5), n3(:,49), t3x16(:,:,5))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf4(:,32), wf16(:,6), n3(:,50), t3x16(:,:,6))
  call counter_QA_Z(gZu,ntry, ex3(:), wf4(:,3), wf8(:,26), n3(:,51), t3x8(:,:,19))
  call prop_A_Q(ntry, wf4(:,12), 56, MT, 1_intkind1, wf4(:,33), n2(21))
  call vert_QS_A(gH,ntry, wf4(:,32), ex5(:), wf4(:,34), n3(:,52), t3x4(:,:,23))
  call vert_QA_Z(gZu,ntry, wf4(:,32), ex4(:), wf8(:,27), n3(:,53), t3x8(:,:,20))
  call prop_W_W(ntry, wf8(:,27), 44, MZ, 1_intkind1, wf8(:,28), n2(22))
  call counter_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,8), n3(:,54), t3x2(:,:,5))
  call prop_Q_A(ntry, wf2(:,8), 20, MT, 1_intkind1, wf2(:,9), n2(23))
  call vert_VQ_A(ntry, wf4(:,1), wf2(:,9), wf8(:,29), n3(:,55), t3x8(:,:,21))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), wf2(:,9), wf8(:,30), n3(:,56), t3x8(:,:,22))
  call vert_VQ_A(ntry, ex6(:), wf2(:,9), wf4(:,35), n3(:,57), t3x4(:,:,24))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,7), n3(:,58), t3x16(:,:,7))
  call counter_Q_A(cttt,6,ntry, wf2(:,2), 20, wf2(:,10), n2(24))
  call prop_A_Q(ntry, wf16(:,7), 43, MT, 1_intkind1, wf16(:,8), n2(25))
  call vert_AZ_Q(gZu,ntry, wf4(:,3), wf4(:,5), wf16(:,9), n3(:,59), t3x16(:,:,8))
  call prop_A_Q(ntry, wf16(:,9), 43, MT, 1_intkind1, wf16(:,10), n2(26))
  call counter_A_Q(cttt,6,ntry, wf4(:,3), 40, wf4(:,36), n2(27))
  call prop_Q_A(ntry, wf8(:,1), 23, MT, 1_intkind1, wf8(:,31), n2(28))
  call prop_Q_A(ntry, wf8(:,2), 23, MT, 1_intkind1, wf8(:,32), n2(29))
  call prop_Q_A(ntry, wf2(:,10), 20, MT, 1_intkind1, wf2(:,11), n2(30))
  call vert_VQ_A(ntry, ex6(:), wf2(:,11), wf4(:,37), n3(:,60), t3x4(:,:,25))
  call counter_A_Q(cttt,6,ntry, wf8(:,4), 11, wf8(:,33), n2(31))
  call counter_A_Q(cttt,6,ntry, wf8(:,6), 11, wf8(:,34), n2(32))
  call vert_AV_Q(ntry, wf2(:,4), wf4(:,1), wf8(:,35), n3(:,61), t3x8(:,:,23))
  call counter_Q_A(cttt,6,ntry, wf4(:,8), 36, wf4(:,38), n2(33))
  call prop_A_Q(ntry, wf8(:,35), 27, MT, 1_intkind1, wf8(:,36), n2(34))
  call vert_AZ_Q(gZu,ntry, wf2(:,4), wf4(:,5), wf8(:,37), n3(:,62), t3x8(:,:,24))
  call prop_A_Q(ntry, wf8(:,37), 27, MT, 1_intkind1, wf8(:,38), n2(35))
  call counter_A_Q(cttt,6,ntry, wf2(:,4), 24, wf2(:,12), n2(36))
  call prop_Q_A(ntry, wf16(:,1), 39, MT, 1_intkind1, wf16(:,11), n2(37))
  call prop_Q_A(ntry, wf16(:,2), 39, MT, 1_intkind1, wf16(:,12), n2(38))
  call counter_Q_A(cttt,6,ntry, wf8(:,8), 7, wf8(:,39), n2(39))
  call counter_Q_A(cttt,6,ntry, wf8(:,10), 7, wf8(:,40), n2(40))
  call prop_A_Q(ntry, wf2(:,12), 24, MT, 1_intkind1, wf2(:,13), n2(41))
  call vert_AV_Q(ntry, wf2(:,13), ex6(:), wf4(:,39), n3(:,63), t3x4(:,:,26))
  call prop_Q_A(ntry, wf4(:,38), 36, MT, 1_intkind1, wf4(:,40), n2(42))
  call vert_QA_Z(gZu,ntry, wf4(:,40), ex4(:), wf8(:,41), n3(:,64), t3x8(:,:,25))
  call vert_QS_A(gH,ntry, wf4(:,40), ex5(:), wf4(:,41), n3(:,65), t3x4(:,:,27))
  call prop_A_Q(ntry, wf4(:,36), 40, MT, 1_intkind1, wf4(:,42), n2(43))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,42), wf8(:,42), n3(:,66), t3x8(:,:,26))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,42), wf4(:,43), n3(:,67), t3x4(:,:,28))
  call vert_QA_V(ntry, wf8(:,8), ex4(:), wf16(:,13), n3(:,68), t3x16(:,:,9))
  call vert_QA_V(ntry, wf8(:,10), ex4(:), wf16(:,14), n3(:,69), t3x16(:,:,10))
  call vert_QS_A(gH,ntry, wf8(:,8), ex5(:), wf8(:,43), n3(:,70), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,43), 23, MT, 1_intkind1, wf8(:,44), n2(44))
  call vert_QS_A(gH,ntry, wf8(:,10), ex5(:), wf8(:,45), n3(:,71), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,45), 23, MT, 1_intkind1, wf8(:,46), n2(45))
  call vert_VQ_A(ntry, ex6(:), wf8(:,8), wf16(:,15), n3(:,72), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,15), 39, MT, 1_intkind1, wf16(:,16), n2(46))
  call vert_VQ_A(ntry, ex6(:), wf8(:,10), wf16(:,17), n3(:,73), t3x16(:,:,12))
  call prop_Q_A(ntry, wf16(:,17), 39, MT, 1_intkind1, wf16(:,18), n2(47))
  call vert_QA_V(ntry, ex3(:), wf8(:,4), wf16(:,19), n3(:,74), t3x16(:,:,13))
  call vert_QA_V(ntry, ex3(:), wf8(:,6), wf16(:,20), n3(:,75), t3x16(:,:,14))
  call vert_SA_Q(gH,ntry, ex5(:), wf8(:,4), wf8(:,47), n3(:,76), t3x8(:,:,29))
  call prop_A_Q(ntry, wf8(:,47), 27, MT, 1_intkind1, wf8(:,48), n2(48))
  call vert_SA_Q(gH,ntry, ex5(:), wf8(:,6), wf8(:,49), n3(:,77), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,49), 27, MT, 1_intkind1, wf8(:,50), n2(49))
  call vert_AV_Q(ntry, wf8(:,4), ex6(:), wf16(:,21), n3(:,78), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,21), 43, MT, 1_intkind1, wf16(:,22), n2(50))
  call vert_AV_Q(ntry, wf8(:,6), ex6(:), wf16(:,23), n3(:,79), t3x16(:,:,16))
  call prop_A_Q(ntry, wf16(:,23), 43, MT, 1_intkind1, wf16(:,24), n2(51))
  call vert_ZQ_A(gZu,ntry, wf4(:,14), ex3(:), wf8(:,51), n3(:,80), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,51), 23, MT, 1_intkind1, wf8(:,52), n2(52))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,14), wf8(:,53), n3(:,81), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,53), 27, MT, 1_intkind1, wf8(:,54), n2(53))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf2)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_eehttj_eexttxhg_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_eehttj_eexttxhg_1(extcombs(k))
  end do

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference

  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,3), wf8(:,1), A(:,1), n3(:,82), t3x32(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,2), A(:,2), n3(:,83), t3x32(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,4), A(:,3), n3(:,84), t3x32(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,6), A(:,4), n3(:,85), t3x32(:,:,4), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,1), A(:,5), n3(:,86), t3x32(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,2), A(:,6), n3(:,87), t3x32(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,8), A(:,7), n3(:,88), t3x32(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,10), A(:,8), n3(:,89), t3x32(:,:,8), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,10), A(:,9), n3(:,90), t3x32(:,:,9), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,10), A(:,10), n3(:,91), t3x32(:,:,10), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,12), A(:,11), n3(:,92), t3x32(:,:,11), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,12), A(:,12), n3(:,93), t3x32(:,:,12), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,12), A(:,13), n3(:,94), t3x32(:,:,13), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,14), A(:,14), n3(:,95), t3x32(:,:,14), nhel, den(33))

    call Hcont_VV(nsync, wf8(:,15), wf4(:,14), A(:,15), n3(:,96), t3x32(:,:,15), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,16), A(:,16), n3(:,97), t3x32(:,:,16), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,17), A(:,17), n3(:,98), t3x32(:,:,17), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,15), A(:,18), n3(:,99), t3x32(:,:,18), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,15), A(:,19), n3(:,100), t3x32(:,:,19), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,16), wf8(:,18), A(:,20), n3(:,101), t3x32(:,:,20), nhel, den(40))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,3), A(:,21), n3(:,102), t3x32(:,:,21), nhel, den(17))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,4), A(:,22), n3(:,103), t3x32(:,:,22), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,17), A(:,23), n3(:,104), t3x32(:,:,23), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,17), A(:,24), n3(:,105), t3x32(:,:,24), nhel, den(24))
    call Hcont_VV(nsync, wf8(:,18), wf4(:,18), A(:,25), n3(:,106), t3x32(:,:,25), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,19), A(:,26), n3(:,107), t3x32(:,:,26), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,19), A(:,27), n3(:,108), t3x32(:,:,27), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,20), A(:,28), n3(:,109), t3x32(:,:,28), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,20), A(:,29), n3(:,110), t3x32(:,:,29), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,21), A(:,30), n3(:,111), t3x32(:,:,30), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,21), A(:,31), n3(:,112), t3x32(:,:,31), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,23), A(:,32), n3(:,113), t3x32(:,:,32), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,23), A(:,33), n3(:,114), t3x32(:,:,33), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,19), wf4(:,24), A(:,34), n3(:,115), t3x32(:,:,34), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,24), wf8(:,20), A(:,35), n3(:,116), t3x32(:,:,35), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,26), A(:,36), n3(:,117), t3x32(:,:,36), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,26), A(:,37), n3(:,118), t3x32(:,:,37), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,21), A(:,38), n3(:,119), t3x32(:,:,38), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,19), wf4(:,27), A(:,39), n3(:,120), t3x32(:,:,39), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,20), wf4(:,27), A(:,40), n3(:,121), t3x32(:,:,40), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,28), A(:,41), n3(:,122), t3x32(:,:,41), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,28), A(:,42), n3(:,123), t3x32(:,:,42), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,23), A(:,43), n3(:,124), t3x32(:,:,43), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,1), wf2(:,7), A(:,44), n3(:,125), t3x32(:,:,44), nhel, den(17))
    call Hcont_QA(nsync, wf16(:,2), wf2(:,7), A(:,45), n3(:,126), t3x32(:,:,45), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,29), A(:,46), n3(:,127), t3x32(:,:,46), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,29), A(:,47), n3(:,128), t3x32(:,:,47), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,30), A(:,48), n3(:,129), t3x32(:,:,48), nhel, den(59))
    call Hcont_QA(nsync, wf4(:,30), wf8(:,25), A(:,49), n3(:,130), t3x32(:,:,49), nhel, den(60))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,5), A(:,50), n3(:,131), t3x32(:,:,50), nhel, den(17))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,6), A(:,51), n3(:,132), t3x32(:,:,51), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,26), A(:,52), n3(:,133), t3x32(:,:,52), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,33), A(:,53), n3(:,134), t3x32(:,:,53), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,25), wf4(:,33), A(:,54), n3(:,135), t3x32(:,:,54), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,34), A(:,55), n3(:,136), t3x32(:,:,55), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,34), A(:,56), n3(:,137), t3x32(:,:,56), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,11), wf8(:,28), A(:,57), n3(:,138), t3x32(:,:,57), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,29), A(:,58), n3(:,139), t3x32(:,:,58), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,30), A(:,59), n3(:,140), t3x32(:,:,59), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,35), A(:,60), n3(:,141), t3x32(:,:,60), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,35), A(:,61), n3(:,142), t3x32(:,:,61), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,10), wf16(:,8), A(:,62), n3(:,143), t3x32(:,:,62), nhel, den(68))
    call Hcont_QA(nsync, wf2(:,10), wf16(:,10), A(:,63), n3(:,144), t3x32(:,:,63), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,36), wf8(:,31), A(:,64), n3(:,145), t3x32(:,:,64), nhel, den(74))
    call Hcont_QA(nsync, wf4(:,36), wf8(:,32), A(:,65), n3(:,146), t3x32(:,:,65), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,37), A(:,66), n3(:,147), t3x32(:,:,66), nhel, den(78))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,37), A(:,67), n3(:,148), t3x32(:,:,67), nhel, den(79))
    call Hcont_QA(nsync, wf4(:,24), wf8(:,33), A(:,68), n3(:,149), t3x32(:,:,68), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,24), wf8(:,34), A(:,69), n3(:,150), t3x32(:,:,69), nhel, den(81))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,36), A(:,70), n3(:,151), t3x32(:,:,70), nhel, den(85))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,38), A(:,71), n3(:,152), t3x32(:,:,71), nhel, den(88))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,11), A(:,72), n3(:,153), t3x32(:,:,72), nhel, den(91))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,12), A(:,73), n3(:,154), t3x32(:,:,73), nhel, den(93))
    call Hcont_QA(nsync, wf4(:,30), wf8(:,39), A(:,74), n3(:,155), t3x32(:,:,74), nhel, den(94))
    call Hcont_QA(nsync, wf4(:,30), wf8(:,40), A(:,75), n3(:,156), t3x32(:,:,75), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,39), A(:,76), n3(:,157), t3x32(:,:,76), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,39), A(:,77), n3(:,158), t3x32(:,:,77), nhel, den(98))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,41), A(:,78), n3(:,159), t3x32(:,:,78), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,41), A(:,79), n3(:,160), t3x32(:,:,79), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,41), A(:,80), n3(:,161), t3x32(:,:,80), nhel, den(102))
    call Hcont_QA(nsync, wf4(:,27), wf8(:,33), A(:,81), n3(:,162), t3x32(:,:,81), nhel, den(103))
    call Hcont_QA(nsync, wf4(:,27), wf8(:,34), A(:,82), n3(:,163), t3x32(:,:,82), nhel, den(104))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,42), A(:,83), n3(:,164), t3x32(:,:,83), nhel, den(106))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,39), A(:,84), n3(:,165), t3x32(:,:,84), nhel, den(107))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,40), A(:,85), n3(:,166), t3x32(:,:,85), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,43), A(:,86), n3(:,167), t3x32(:,:,86), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,43), A(:,87), n3(:,168), t3x32(:,:,87), nhel, den(110))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,32)
  integer :: empty(0), i

  M1(1)%j = (-A(j,1)%j-A(j,3)%j-A(j,5)%j-A(j,7)%j-A(j,9)%j-A(j,12)%j)*f(3)+(A(j,2)%j+A(j,4)%j+A(j,6)%j+A(j,8)%j+A(j,10)%j &
       +A(j,13)%j)*f(4)+(A(j,11)%j+A(j,14)%j)*f(14)

  M2(1)%j = (-A(j,30)%j-A(j,32)%j)*f(1)+(A(j,31)%j+A(j,33)%j)*f(2)+(A(j,62)%j+A(j,64)%j+A(j,66)%j+A(j,68)%j+A(j,70)%j+A(j,72)%j &
       +A(j,74)%j+A(j,76)%j+A(j,79)%j+A(j,81)%j+A(j,84)%j+A(j,86)%j)*f(5)+(-A(j,63)%j-A(j,65)%j-A(j,67)%j-A(j,69)%j-A(j,71)%j &
       -A(j,73)%j-A(j,75)%j-A(j,77)%j-A(j,80)%j-A(j,82)%j-A(j,85)%j-A(j,87)%j)*f(6)+(-A(j,18)%j-A(j,23)%j-A(j,36)%j-A(j,41)%j &
       -A(j,50)%j-A(j,55)%j)*f(7)+(A(j,19)%j+A(j,24)%j+A(j,37)%j+A(j,42)%j+A(j,51)%j+A(j,56)%j)*f(8)+(-A(j,26)%j-A(j,28)%j &
       -A(j,44)%j-A(j,46)%j-A(j,58)%j-A(j,60)%j)*f(9)+(A(j,27)%j+A(j,29)%j+A(j,45)%j+A(j,47)%j+A(j,59)%j+A(j,61)%j)*f(10)+( &
       -A(j,16)%j-A(j,21)%j-A(j,34)%j-A(j,39)%j-A(j,48)%j-A(j,53)%j)*f(11)+(A(j,17)%j+A(j,22)%j+A(j,35)%j+A(j,40)%j+A(j,49)%j &
       +A(j,54)%j)*f(12)+(-A(j,20)%j-A(j,25)%j)*f(13)+(-A(j,78)%j-A(j,83)%j)*f(15)+(A(j,43)%j+A(j,57)%j)*f(16)+(A(j,38)%j &
       +A(j,52)%j)*f(17)-A(j,15)%j*f(18)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_eehttj_eexttxhg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_eehttj_eexttxhg_1_/**/REALKIND
