
module ol_vamp_1_eehtt_eexttxh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eehtt_eexttxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eehtt_eexttxh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eehtt_eexttxh_1_/**/DREALKIND
  use ol_tensor_sum_storage_eehtt_eexttxh_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_eehtt_eexttxh_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eehtt_eexttxh_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(1,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(1),n2h16(1))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(2),n2h16(2))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(3),n2h16(3))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(4),n2h16(4))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,6),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(1),n2h4(1))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,2),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(2),n2h4(2))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,6),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(3),n2h4(3))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,3),G1H4(1),ngZu,m3h4x4(:,4),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(4),n2h4(4))
  call ol_merge(ntryL,G2H4(2),[G2H4(1)])
  call ol_merge(ntryL,G2H4(4),[G2H4(3)])
  call Hloop_QA_V(ntryL,G2H4(2),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
call Hotf_4pt_reduction(G2H2(1),RedSet_4(1),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
call HG1shiftOLR(G1H2(2),4,2)
call Hotf_4pt_reduction(G2H2(2),RedSet_4(2),mass4set(:,1),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
call HG1shiftOLR(G1H2(7),8,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(3),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(5),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(6),n2h1(6))
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(2),4)
call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
call G_TensorShift(G1tensor(7),8)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[20,3,8],[nMT,nMT,0],3,2,wf2(:,2),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H16(1),wf2(:,2),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(1),n2h8(1))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(6),h0tab(:,6),[20,3,8],[nMT,nMT,0],3,2,wf2(:,2),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H16(2),wf2(:,2),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(2),n2h8(2))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[24,3,4],[nMT,nMT,0],3,2,wf2(:,4),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H16(1),wf2(:,4),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),24,nMT,G1H8(3),n2h8(3))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(8),h0tab(:,8),[24,3,4],[nMT,nMT,0],3,2,wf2(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(2),wf2(:,4),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),24,nMT,G1H8(4),n2h8(4))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,7,8],[nMT,0,nMT],3,1,wf8(:,11))
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,5),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(1),n2h16(5))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,7,8],[nMT,0,nMT],3,1,wf8(:,12))
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,6),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(2),n2h16(6))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,4,11],[nMT,0,nMT],3,1,wf8(:,9))
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,7),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(3),n2h16(7))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[16,4,11],[nMT,0,nMT],3,1,wf8(:,10))
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,8),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(4),n2h16(8))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[19,4,8],[nMT,0,nMT],3,1,wf4(:,9))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,9),G0H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(1),n2h4(5))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,6),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(1),n2h2(1))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,3),G1H2(2),ngZu,m3h4x2(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(2),n2h2(2))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,6),G1H2(5),m3h4x2(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMT,G2H2(3),n2h2(3))
  call Hloop_AZ_Q(ntryL,G1H8(4),wf4(:,3),G1H2(6),ngZu,m3h4x2(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(6),27,nMT,G2H2(4),n2h2(4))
  call Hloop_AQ_V(ntryL,G1H16(1),wf8(:,11),G1H2(7),m3h8x2(:,1),heltab2x16(:,:,18))
  call Hloop_AQ_V(ntryL,G1H16(2),wf8(:,12),G1H2(10),m3h8x2(:,2),heltab2x16(:,:,19))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,20))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(2),m3h2x8(:,6),heltab2x16(:,:,21))
  call Hloop_AQ_V(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call ol_merge(ntryL,G1H2(1),[G1H2(8)])
  call ol_merge(ntryL,G1H2(10),[G1H2(7),G1H2(9)])
  call ol_merge(ntryL,G2H2(2),[G2H2(1)])
  call ol_merge(ntryL,G2H2(4),[G2H2(3)])
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(7),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(8),n2h1(10))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(9),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(10),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_VA_Q(ntryL,G1H8(1),wf8(:,9),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(11),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H8(2),wf8(:,10),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(12),n2h1(12))
  call ol_merge_tensors(G2tensor(9),[G2tensor(2),G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(3),G1tensor(10),G1tensor(5),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(5),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(4),G0tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(8),G0tensor(8)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(9),G0tensor(9)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(11)])
call TI_triangle_red(G2tensor(9),RedBasis(6),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(2),G0tensor(10),M2L1R1,[nMT], &
    G0tensor(5))
call TI_triangle_red(G2tensor(6),RedBasis(1),mass3set(:,2),G0tensor(7),G0tensor(3),G0tensor(4),G0tensor(8),M2L1R1,[nMT], &
    G0tensor(9))
call TI_triangle_red(G2tensor(10),RedBasis(7),mass3set(:,1),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),M2L1R1,[nMT], &
    G0tensor(15))
call TI_triangle_red(G2tensor(1),RedBasis(3),mass3set(:,3),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),M2L1R1,[nMT], &
    G0tensor(20))
call TI_triangle_red(G2tensor(4),RedBasis(2),mass3set(:,3),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),M2L1R1,[nMT], &
    G0tensor(25))
call TI_triangle_red(G2tensor(7),RedBasis(5),mass3set(:,3),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),M2L1R1,[nMT], &
    G0tensor(30))
call TI_triangle_red(G2tensor(8),RedBasis(4),mass3set(:,3),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),M2L1R1,[nMT], &
    G0tensor(35))
call TI_triangle_red(G2tensor(12),RedBasis(8),mass3set(:,3),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),M2L1R1,[nMT], &
    G0tensor(40))
call ol_merge_tensors(T0sum(3),[G0tensor(1)])
call ol_merge_tensors(T0sum(4),[G0tensor(7)])
call ol_merge_tensors(T0sum(5),[G0tensor(11)])
call ol_merge_tensors(T0sum(6),[G0tensor(16)])
call ol_merge_tensors(T0sum(7),[G0tensor(21)])
call ol_merge_tensors(T0sum(8),[G0tensor(26)])
call ol_merge_tensors(T0sum(9),[G0tensor(31)])
call ol_merge_tensors(T0sum(10),[G0tensor(36)])
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(14),h0tab(:,14),[20,11],[0,nMT],2,2,wf2(:,2),wf8(:,9))
  call Hloop_AQ_V(ntryL,G0H16(2),wf2(:,2),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,22))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[20,11],[0,nMT],2,2,wf2(:,2),wf8(:,10))
  call Hloop_AQ_V(ntryL,G0H16(1),wf2(:,2),G0H8(2),m3h2x8(:,8),heltab2x16(:,:,23))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(16),h0tab(:,16),[24,7],[nMT,0],2,2,wf2(:,4),wf8(:,11))
  call Hloop_VA_Q(ntryL,G0H16(2),wf2(:,4),G0H8(3),m3h2x8(:,9),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMT,G1H8(3),n2h8(5))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[24,7],[nMT,0],2,2,wf2(:,4),wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H16(1),wf2(:,4),G0H8(3),m3h2x8(:,10),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMT,G1H8(4),n2h8(6))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,9),G0H1(1),m3h8x1(:,3),heltab2x8(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1),n2h1(13))
  call Hloop_VA_Q(ntryL,G0H8(2),wf8(:,10),G0H1(1),m3h8x1(:,4),heltab2x8(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(6),n2h1(14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(3),wf8(:,11),G1tensor(2),m3h8x1(:,5),heltab2x8(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(4),wf8(:,12),G1tensor(10),m3h8x1(:,6),heltab2x8(:,:,10))
  call ol_merge_tensors(G0tensor(12),[G0tensor(3),G0tensor(6)])
  call ol_merge_tensors(G0tensor(17),[G0tensor(2)])
  call ol_merge_tensors(G0tensor(22),[G0tensor(10)])
  call ol_merge_tensors(G0tensor(40),[G0tensor(35),G0tensor(30),G0tensor(25),G0tensor(20),G0tensor(15),G0tensor(9),G0tensor(5)])
  call ol_merge_tensors(G0tensor(29),[G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G0tensor(39),[G0tensor(34),G0tensor(24),G0tensor(8)])
  call ol_merge_tensors(G0tensor(37),[G0tensor(27),G0tensor(13)])
  call ol_merge_tensors(G1tensor(10),[G1tensor(2),G0tensor(32),G0tensor(14)])
  call ol_merge_tensors(G0tensor(23),[G0tensor(18)])
  call ol_merge_tensors(G0tensor(33),[G0tensor(28)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(1),G0tensor(38)])
call TI_bubble_red(G1tensor(10),24,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(7))
call TI_bubble_red(G1tensor(6),20,mass2set(:,2),G0tensor(11),M2L1R1,G0tensor(16))
  call ol_merge_tensors(G0tensor(16),[G0tensor(7),G0tensor(40)])
call ol_merge_tensors(T0sum(11),[G0tensor(12)])
call ol_merge_tensors(T0sum(12),[G0tensor(17)])
call ol_merge_tensors(T0sum(13),[G0tensor(22)])
call ol_merge_tensors(T0sum(14),[G0tensor(16)])
call ol_merge_tensors(T0sum(15),[G0tensor(29)])
call ol_merge_tensors(T0sum(16),[G0tensor(39)])
call ol_merge_tensors(T0sum(17),[G0tensor(37)])
call ol_merge_tensors(T0sum(18),[G0tensor(1)])
call ol_merge_tensors(T0sum(19),[G0tensor(23)])
call ol_merge_tensors(T0sum(20),[G0tensor(33)])
call ol_merge_tensors(T0sum(21),[G0tensor(11)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_eehtt_eexttxh_1_/**/REALKIND
