
module ol_vamp_2_eehll_ew_nenexeexh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eehll_ew_nenexeexh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eehll_ew_nenexeexh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eehll_ew_nenexeexh_1_/**/DREALKIND
  use ol_tensor_sum_storage_eehll_ew_nenexeexh_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eehll_ew_nenexeexh_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eehll_ew_nenexeexh_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G0H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G0H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(81),[G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(74)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(1),wf4(:,1),wf4(:,7),G0tensor(159),m4h4x4x1(:,1),heltab3x16(:,:,17))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(22),wf4(:,1),wf4(:,2),G0tensor(11),m4h4x4x1(:,2),heltab3x16(:,:,18))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(10),wf4(:,1),wf4(:,2),G0tensor(169),m4h4x4x1(:,3),heltab3x16(:,:,19))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(25),wf4(:,1),wf4(:,2),G0tensor(36),m4h4x4x1(:,4),heltab3x16(:,:,20))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(3),wf4(:,1),wf4(:,7),G0tensor(295),m4h4x4x1(:,5),heltab3x16(:,:,21))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(14),wf4(:,1),wf4(:,2),G0tensor(243),m4h4x4x1(:,6),heltab3x16(:,:,22))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(8),wf4(:,1),G1tensor(12),m3h4x1(:,75),heltab2x4(:,:,109))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(37),wf4(:,1),G1tensor(20),m3h4x1(:,76),heltab2x4(:,:,110))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(13),wf4(:,7),G1tensor(21),m3h4x1(:,77),heltab2x4(:,:,111))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(3),wf4(:,2),G1tensor(58),m3h4x1(:,78),heltab2x4(:,:,112))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(2),wf4(:,2),G1tensor(29),m3h4x1(:,79),heltab2x4(:,:,113))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(12),wf4(:,4),wf4(:,5),G0tensor(190),m4h4x4x1(:,7),heltab3x16(:,:,23))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(4),wf4(:,4),wf4(:,5),G0tensor(208),m4h4x4x1(:,8),heltab3x16(:,:,24))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(27),wf4(:,4),wf4(:,5),G0tensor(61),m4h4x4x1(:,9),heltab3x16(:,:,25))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(30),wf4(:,4),wf4(:,5),G0tensor(229),m4h4x4x1(:,10),heltab3x16(:,:,26))
  call Hcheck_last_WWV_V(ntryL,l_switch,G0H16(32),wf4(:,5),wf4(:,4),G0tensor(91),m4h4x4x1(:,11),heltab3x16(:,:,27))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(71),wf4(:,4),G1tensor(47),m3h4x1(:,80),heltab2x4(:,:,114))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(72),wf4(:,4),G1tensor(26),m3h4x1(:,81),heltab2x4(:,:,115))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(73),wf4(:,4),G1tensor(27),m3h4x1(:,82),heltab2x4(:,:,116))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(54),wf4(:,5),G1tensor(40),m3h4x1(:,83),heltab2x4(:,:,117))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(55),wf4(:,5),G1tensor(66),m3h4x1(:,84),heltab2x4(:,:,118))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(56),wf4(:,5),G1tensor(32),m3h4x1(:,85),heltab2x4(:,:,119))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,7),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(10),n2h1(23))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,7),G1H1(1),m3h4x1(:,87),heltab2x4(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(19),n2h1(24))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,7),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(25))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,89),heltab2x4(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(11),n2h1(26))
  call Hloop_QZ_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,90),heltab2x4(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(29),n2h1(27))
  call Hloop_QZ_A(ntryL,G1H4(47),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,91),heltab2x4(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(2),n2h1(28))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(31),19,wf4(:,2),12,G2tensor(13),m3h4x1(:,92),heltab2x4(:,:,126))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(33),19,wf4(:,7),12,G2tensor(5),m3h4x1(:,93),heltab2x4(:,:,127))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(22),19,wf4(:,2),12,G2tensor(6),m3h4x1(:,94),heltab2x4(:,:,128))
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,7),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(29))
  call Hloop_QZ_A(ntryL,G1H4(27),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,96),heltab2x4(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(30))
  call Hloop_QZ_A(ntryL,G1H4(28),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,97),heltab2x4(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(31))
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,98),heltab2x4(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(32))
  call Hloop_QZ_A(ntryL,G1H4(46),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,99),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(33))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(30),19,wf4(:,7),12,G2tensor(28),m3h4x1(:,100),heltab2x4(:,:,134))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(18),19,wf4(:,2),12,G2tensor(34),m3h4x1(:,101),heltab2x4(:,:,135))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(23),19,wf4(:,7),12,G2tensor(16),m3h4x1(:,102),heltab2x4(:,:,136))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(24),19,wf4(:,2),12,G2tensor(31),m3h4x1(:,103),heltab2x4(:,:,137))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,104),heltab2x4(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(17),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H4(40),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,105),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(36),n2h1(35))
  call Hloop_QZ_A(ntryL,G1H4(42),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,106),heltab2x4(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(36))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(43),28,wf4(:,1),3,G2tensor(8),m3h4x1(:,107),heltab2x4(:,:,141))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(50),28,wf4(:,1),3,G2tensor(9),m3h4x1(:,108),heltab2x4(:,:,142))
  call Hloop_QZ_A(ntryL,G1H4(48),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,109),heltab2x4(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H4(49),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,110),heltab2x4(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H4(39),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,111),heltab2x4(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(41),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,112),heltab2x4(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(40))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(44),28,wf4(:,1),3,G2tensor(7),m3h4x1(:,113),heltab2x4(:,:,147))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(51),28,wf4(:,1),3,G2tensor(25),m3h4x1(:,114),heltab2x4(:,:,148))
  call Hloop_QW_A(ntryL,G1H4(58),wf4(:,5),G1H1(1),m3h4x1(:,115),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(20),n2h1(41))
  call Hloop_QW_A(ntryL,G1H4(60),wf4(:,5),G1H1(1),m3h4x1(:,116),heltab2x4(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(42))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(61),25,wf4(:,5),6,G2tensor(39),m3h4x1(:,117),heltab2x4(:,:,151))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(64),25,wf4(:,5),6,G2tensor(42),m3h4x1(:,118),heltab2x4(:,:,152))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(65),25,wf4(:,5),G2tensor(38),m3h4x1(:,119),heltab2x4(:,:,153))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(66),25,wf4(:,5),G2tensor(51),m3h4x1(:,120),heltab2x4(:,:,154))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(67),25,wf4(:,5),6,G2tensor(46),m3h4x1(:,121),heltab2x4(:,:,155))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(68),25,wf4(:,5),6,G2tensor(47),m3h4x1(:,122),heltab2x4(:,:,156))
  call Hloop_QW_A(ntryL,G1H4(59),wf4(:,5),G1H1(1),m3h4x1(:,123),heltab2x4(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(43))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(62),25,wf4(:,5),6,G2tensor(45),m3h4x1(:,124),heltab2x4(:,:,158))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(63),25,wf4(:,5),6,G2tensor(37),m3h4x1(:,125),heltab2x4(:,:,159))
  call Hloop_AW_Q(ntryL,G1H4(75),wf4(:,4),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(44),n2h1(44))
  call Hloop_AW_Q(ntryL,G1H4(77),wf4(:,4),G1H1(1),m3h4x1(:,127),heltab2x4(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(48),n2h1(45))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(78),22,wf4(:,4),9,G2tensor(26),m3h4x1(:,128),heltab2x4(:,:,162))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(80),22,wf4(:,4),G2tensor(4),m3h4x1(:,129),heltab2x4(:,:,163))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(81),22,wf4(:,4),G2tensor(21),m3h4x1(:,130),heltab2x4(:,:,164))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(83),22,wf4(:,4),9,G2tensor(12),m3h4x1(:,131),heltab2x4(:,:,165))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(84),22,wf4(:,4),9,G2tensor(1),m3h4x1(:,132),heltab2x4(:,:,166))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(85),22,wf4(:,4),9,G2tensor(15),m3h4x1(:,133),heltab2x4(:,:,167))
  call Hloop_AW_Q(ntryL,G1H4(76),wf4(:,4),G1H1(1),m3h4x1(:,134),heltab2x4(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(46))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(79),22,wf4(:,4),9,G2tensor(49),m3h4x1(:,135),heltab2x4(:,:,169))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(82),22,wf4(:,4),9,G2tensor(50),m3h4x1(:,136),heltab2x4(:,:,170))
  call ol_merge_tensors(G0tensor(78),[G0tensor(42),G0tensor(13),G0tensor(163),G0tensor(16)])
  call ol_merge_tensors(G0tensor(362),[G0tensor(115),G0tensor(157),G0tensor(131),G0tensor(21)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(16),G2tensor(34),G2tensor(28),G2tensor(6),G2tensor(5),G1tensor(29),G1tensor(21) &
    ,G0tensor(341),G0tensor(332),G0tensor(192),G0tensor(46),G0tensor(26)])
  call ol_merge_tensors(G0tensor(429),[G0tensor(424),G0tensor(419),G0tensor(414),G0tensor(409),G0tensor(404),G0tensor(383) &
    ,G0tensor(377),G0tensor(372),G0tensor(366),G0tensor(359),G0tensor(354),G0tensor(348),G0tensor(343),G0tensor(338),G0tensor(333) &
    ,G0tensor(328),G0tensor(127),G0tensor(104),G0tensor(34),G0tensor(15),G0tensor(9),G0tensor(4),G0tensor(314),G0tensor(272) &
    ,G0tensor(265),G0tensor(197),G0tensor(193),G0tensor(175),G0tensor(165),G0tensor(174),G0tensor(167),G0tensor(25),G0tensor(154) &
    ,G0tensor(203),G0tensor(94),G0tensor(311),G0tensor(286),G0tensor(261),G0tensor(226),G0tensor(201),G0tensor(171),G0tensor(141) &
    ,G0tensor(116),G0tensor(86),G0tensor(56),G0tensor(31)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(7),G2tensor(9),G1tensor(12),G0tensor(325),G0tensor(180),G0tensor(168),G0tensor(196) &
    ,G0tensor(41)])
  call ol_merge_tensors(G0tensor(91),[G0tensor(61),G0tensor(243),G0tensor(295),G0tensor(36),G0tensor(159),G0tensor(423) &
    ,G0tensor(413),G0tensor(382),G0tensor(347),G0tensor(337),G0tensor(43),G0tensor(207),G0tensor(178),G0tensor(120),G0tensor(33) &
    ,G0tensor(166),G0tensor(51)])
  call ol_merge_tensors(G0tensor(401),[G0tensor(345),G0tensor(260),G0tensor(271),G0tensor(186),G0tensor(66)])
  call ol_merge_tensors(G0tensor(374),[G0tensor(316),G0tensor(269),G0tensor(305),G0tensor(71)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(380),G0tensor(351),G0tensor(285),G0tensor(101),G0tensor(76)])
  call ol_merge_tensors(G0tensor(399),[G0tensor(394),G0tensor(389),G0tensor(384),G0tensor(378),G0tensor(371),G0tensor(365) &
    ,G0tensor(360),G0tensor(353),G0tensor(323),G0tensor(318),G0tensor(299),G0tensor(254),G0tensor(213),G0tensor(160),G0tensor(145) &
    ,G0tensor(123),G0tensor(112),G0tensor(17),G0tensor(313),G0tensor(293),G0tensor(279),G0tensor(300),G0tensor(255),G0tensor(240) &
    ,G0tensor(220),G0tensor(270),G0tensor(87),G0tensor(59),G0tensor(74),G0tensor(48),G0tensor(170),G0tensor(256),G0tensor(231) &
    ,G0tensor(176),G0tensor(146),G0tensor(111),G0tensor(81)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(47),G2tensor(51),G2tensor(42),G0tensor(381),G0tensor(375),G0tensor(292) &
    ,G0tensor(205),G0tensor(221),G0tensor(96)])
  call ol_merge_tensors(G0tensor(229),[G0tensor(208),G0tensor(169),G0tensor(398),G0tensor(370),G0tensor(322),G0tensor(253) &
    ,G0tensor(198),G0tensor(288),G0tensor(248),G0tensor(68),G0tensor(106)])
  call ol_merge_tensors(G0tensor(386),[G0tensor(320),G0tensor(274),G0tensor(3),G0tensor(126)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(15),G2tensor(12),G2tensor(21),G0tensor(368),G0tensor(357),G0tensor(137) &
    ,G0tensor(161),G0tensor(136)])
  call ol_merge_tensors(G1tensor(66),[G0tensor(369),G0tensor(363),G0tensor(103),G0tensor(2),G0tensor(251),G0tensor(156)])
  call ol_merge_tensors(G0tensor(412),[G0tensor(407),G0tensor(340),G0tensor(294),G0tensor(284),G0tensor(191)])
  call ol_merge_tensors(G0tensor(233),[G0tensor(130),G0tensor(133),G0tensor(211)])
  call ol_merge_tensors(G0tensor(350),[G0tensor(336),G0tensor(331),G0tensor(252),G0tensor(216)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(290),G0tensor(140),G0tensor(296),G0tensor(241)])
  call ol_merge_tensors(G0tensor(356),[G0tensor(183),G0tensor(158),G0tensor(73),G0tensor(246)])
  call ol_merge_tensors(G0tensor(416),[G0tensor(303),G0tensor(276)])
  call ol_merge_tensors(G1tensor(47),[G0tensor(421),G0tensor(281)])
  call ol_merge_tensors(G0tensor(426),[G0tensor(308),G0tensor(301)])
  call ol_merge_tensors(G1tensor(40),[G0tensor(29),G0tensor(306)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(1),G2tensor(4),G0tensor(427),G0tensor(38)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(44)])
  call ol_merge_tensors(G0tensor(60),[G0tensor(39)])
  call ol_merge_tensors(G2tensor(40),[G0tensor(149),G0tensor(143),G0tensor(179)])
  call ol_merge_tensors(G0tensor(397),[G0tensor(392),G0tensor(108),G0tensor(107),G0tensor(40)])
  call ol_merge_tensors(G0tensor(289),[G0tensor(275),G0tensor(249),G0tensor(47)])
  call ol_merge_tensors(G2tensor(41),[G0tensor(6),G0tensor(278),G0tensor(27)])
  call ol_merge_tensors(G2tensor(17),[G0tensor(315)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(10),G0tensor(210)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(50)])
  call ol_merge_tensors(G0tensor(90),[G0tensor(45)])
  call ol_merge_tensors(G2tensor(36),[G0tensor(62)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(19),G0tensor(54)])
  call ol_merge_tensors(G0tensor(84),[G0tensor(297)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(100),G0tensor(247)])
  call ol_merge_tensors(G2tensor(33),[G0tensor(188)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(3),G0tensor(63)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(58)])
  call ol_merge_tensors(G0tensor(98),[G0tensor(95),G0tensor(134)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(20),G0tensor(64)])
  call ol_merge_tensors(G0tensor(190),[G0tensor(11),G0tensor(109),G0tensor(14)])
  call ol_merge_tensors(G0tensor(20),[G0tensor(224),G0tensor(75),G0tensor(194)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(58),G0tensor(55)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(24),G2tensor(23),G2tensor(22),G2tensor(14),G0tensor(406),G0tensor(402) &
    ,G0tensor(391),G0tensor(387),G0tensor(212),G0tensor(199),G0tensor(72)])
  call ol_merge_tensors(G0tensor(330),[G0tensor(326),G0tensor(227)])
  call ol_merge_tensors(G2tensor(44),[G0tensor(209)])
  call ol_merge_tensors(G2tensor(43),[G0tensor(80)])
  call ol_merge_tensors(G2tensor(48),[G0tensor(97)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(32),G0tensor(105)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(27),G0tensor(195)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(30),G2tensor(32),G2tensor(35),G0tensor(10),G0tensor(8),G0tensor(259),G0tensor(245) &
    ,G0tensor(135),G0tensor(129)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(250),G0tensor(155)])
  call ol_merge_tensors(G0tensor(18),[G0tensor(12),G0tensor(177),G0tensor(244)])
  call ol_merge_tensors(G0tensor(428),[G0tensor(358),G0tensor(218),G0tensor(182)])
  call ol_merge_tensors(G0tensor(298),[G0tensor(267),G0tensor(225),G0tensor(228)])
  call ol_merge_tensors(G0tensor(312),[G0tensor(304),G0tensor(264)])
  call ol_merge_tensors(G0tensor(122),[G0tensor(30),G0tensor(24)])
  call ol_merge_tensors(G0tensor(164),[G0tensor(152)])
  call ol_merge_tensors(G0tensor(352),[G0tensor(234),G0tensor(172)])
  call ol_merge_tensors(G0tensor(393),[G0tensor(364),G0tensor(321),G0tensor(317)])
  call ol_merge_tensors(G0tensor(335),[G0tensor(327)])
  call ol_merge_tensors(G0tensor(418),[G0tensor(408),G0tensor(376),G0tensor(346),G0tensor(342)])
  call ol_merge_tensors(G0tensor(396),[G0tensor(388)])
  call ol_merge_tensors(G0tensor(411),[G0tensor(403)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(46),G2tensor(38),G0tensor(422),G0tensor(417)])
call TI_bubble_red(G2tensor(31),19,mass2set(:,1),G0tensor(310),M2L1R1,G0tensor(268))
call TI_bubble_red(G2tensor(25),28,mass2set(:,1),G0tensor(287),M2L1R1,G0tensor(309))
call TI_bubble_red(G2tensor(45),25,mass2set(:,2),G0tensor(280),M2L1R1,G0tensor(22),G0tensor(121))
call TI_bubble_red(G2tensor(49),22,mass2set(:,2),G0tensor(151),M2L1R1,G0tensor(5),G0tensor(23))
call TI_bubble_red(G2tensor(50),22,mass2set(:,3),G0tensor(28),M2L1R1,G0tensor(53))
call TI_bubble_red(G2tensor(40),22,mass2set(:,4),G0tensor(113),M2L1R1)
call TI_bubble_red(G2tensor(41),25,mass2set(:,4),G0tensor(138),M2L1R1)
call TI_bubble_red(G2tensor(17),28,mass2set(:,5),G0tensor(153),M2L1R1,G0tensor(173))
call TI_bubble_red(G2tensor(11),19,mass2set(:,5),G0tensor(214),M2L1R1,G0tensor(273))
call TI_bubble_red(G2tensor(36),28,mass2set(:,6),G0tensor(1),M2L1R1,G0tensor(319))
call TI_bubble_red(G2tensor(29),19,mass2set(:,6),G0tensor(324),M2L1R1,G0tensor(329))
call TI_bubble_red(G2tensor(33),28,mass2set(:,7),G0tensor(334),M2L1R1,G0tensor(181))
call TI_bubble_red(G2tensor(2),19,mass2set(:,7),G0tensor(339),M2L1R1,G0tensor(344))
call TI_bubble_red(G2tensor(8),28,mass2set(:,8),G0tensor(206),M2L1R1,G0tensor(349),G0tensor(236))
call TI_bubble_red(G2tensor(13),19,mass2set(:,8),G0tensor(355),M2L1R1,G0tensor(361),G0tensor(367))
call TI_bubble_red(G2tensor(27),19,mass2set(:,4),G0tensor(373),M2L1R1)
call TI_bubble_red(G2tensor(44),22,mass2set(:,9),G0tensor(379),M2L1R1,G0tensor(385))
call TI_bubble_red(G2tensor(43),25,mass2set(:,10),G0tensor(390),M2L1R1,G0tensor(395),G0tensor(400))
call TI_bubble_red(G2tensor(48),22,mass2set(:,10),G0tensor(405),M2L1R1,G0tensor(410),G0tensor(266))
call TI_bubble_red(G2tensor(39),25,mass2set(:,11),G0tensor(415),M2L1R1,G0tensor(420),G0tensor(291))
call TI_bubble_red(G2tensor(26),22,mass2set(:,11),G0tensor(425),M2L1R1,G0tensor(37),G0tensor(102))
call TI_bubble_red(G2tensor(18),28,mass2set(:,4),G0tensor(7),M2L1R1)
call TI_bubble_red(G2tensor(37),25,mass2set(:,3),G0tensor(124),M2L1R1,G0tensor(185))
call TI_bubble_red(G2tensor(20),25,mass2set(:,9),G0tensor(128),M2L1R1,G0tensor(189))
  call ol_merge_tensors(G0tensor(185),[G0tensor(37),G0tensor(420),G0tensor(53),G0tensor(5),G0tensor(22),G0tensor(309) &
    ,G0tensor(429),G0tensor(268)])
  call ol_merge_tensors(G0tensor(361),[G0tensor(349),G0tensor(23),G0tensor(121),G0tensor(399)])
  call ol_merge_tensors(G0tensor(189),[G0tensor(385),G0tensor(90),G0tensor(273),G0tensor(173)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(400),G0tensor(85),G0tensor(329),G0tensor(319)])
  call ol_merge_tensors(G0tensor(410),[G0tensor(395),G0tensor(98),G0tensor(344),G0tensor(181)])
  call ol_merge_tensors(G0tensor(102),[G0tensor(291),G0tensor(367),G0tensor(20),G0tensor(236)])
call TI_bubble_red(G1tensor(26),22,mass2set(:,12),G0tensor(110),M2L1R1,G0tensor(139),G0tensor(32))
call TI_bubble_red(G1tensor(66),25,mass2set(:,12),G0tensor(200),M2L1R1,G0tensor(204),G0tensor(57))
call TI_bubble_red(G1tensor(47),22,mass2set(:,13),G0tensor(82),M2L1R1,G0tensor(89))
call TI_bubble_red(G1tensor(40),25,mass2set(:,13),G0tensor(144),M2L1R1,G0tensor(148))
  call ol_merge_tensors(G0tensor(148),[G0tensor(89),G0tensor(57),G0tensor(32),G0tensor(185)])
  call ol_merge_tensors(G0tensor(204),[G0tensor(361),G0tensor(139)])
  call ol_merge_tensors(T0sum(174),[G0tensor(78)])
  call ol_merge_tensors(T0sum(175),[G0tensor(362)])
  call ol_merge_tensors(T0sum(176),[G0tensor(310)])
  call ol_merge_tensors(T0sum(177),[G0tensor(148)])
  call ol_merge_tensors(T0sum(178),[G0tensor(287)])
  call ol_merge_tensors(T0sum(179),[G0tensor(91)])
  call ol_merge_tensors(T0sum(180),[G0tensor(401)])
  call ol_merge_tensors(T0sum(181),[G0tensor(374)])
  call ol_merge_tensors(T0sum(182),[G0tensor(110)])
  call ol_merge_tensors(T0sum(183),[G0tensor(204)])
  call ol_merge_tensors(T0sum(184),[G0tensor(280)])
  call ol_merge_tensors(T0sum(185),[G0tensor(229)])
  call ol_merge_tensors(T0sum(186),[G0tensor(386)])
  call ol_merge_tensors(T0sum(187),[G0tensor(151)])
  call ol_merge_tensors(T0sum(188),[G0tensor(200)])
  call ol_merge_tensors(T0sum(189),[G0tensor(412)])
  call ol_merge_tensors(T0sum(190),[G0tensor(233)])
  call ol_merge_tensors(T0sum(191),[G0tensor(350)])
  call ol_merge_tensors(T0sum(192),[G0tensor(223)])
  call ol_merge_tensors(T0sum(193),[G0tensor(356)])
  call ol_merge_tensors(T0sum(194),[G0tensor(416)])
  call ol_merge_tensors(T0sum(195),[G0tensor(82)])
  call ol_merge_tensors(T0sum(196),[G0tensor(426)])
  call ol_merge_tensors(T0sum(197),[G0tensor(144)])
  call ol_merge_tensors(T0sum(198),[G0tensor(28)])
  call ol_merge_tensors(T0sum(199),[G0tensor(125)])
  call ol_merge_tensors(T0sum(200),[G0tensor(60)])
  call ol_merge_tensors(T0sum(201),[G0tensor(113)])
  call ol_merge_tensors(T0sum(202),[G0tensor(397)])
  call ol_merge_tensors(T0sum(203),[G0tensor(289)])
  call ol_merge_tensors(T0sum(204),[G0tensor(138)])
  call ol_merge_tensors(T0sum(205),[G0tensor(153)])
  call ol_merge_tensors(T0sum(206),[G0tensor(189)])
  call ol_merge_tensors(T0sum(207),[G0tensor(214)])
  call ol_merge_tensors(T0sum(208),[G0tensor(99)])
  call ol_merge_tensors(T0sum(209),[G0tensor(1)])
  call ol_merge_tensors(T0sum(210),[G0tensor(266)])
  call ol_merge_tensors(T0sum(211),[G0tensor(324)])
  call ol_merge_tensors(T0sum(212),[G0tensor(84)])
  call ol_merge_tensors(T0sum(213),[G0tensor(334)])
  call ol_merge_tensors(T0sum(214),[G0tensor(410)])
  call ol_merge_tensors(T0sum(215),[G0tensor(339)])
  call ol_merge_tensors(T0sum(216),[G0tensor(77)])
  call ol_merge_tensors(T0sum(217),[G0tensor(206)])
  call ol_merge_tensors(T0sum(218),[G0tensor(102)])
  call ol_merge_tensors(T0sum(219),[G0tensor(19)])
  call ol_merge_tensors(T0sum(220),[G0tensor(190)])
  call ol_merge_tensors(T0sum(221),[G0tensor(67)])
  call ol_merge_tensors(T0sum(222),[G0tensor(355)])
  call ol_merge_tensors(T0sum(223),[G0tensor(373)])
  call ol_merge_tensors(T0sum(224),[G0tensor(330)])
  call ol_merge_tensors(T0sum(225),[G0tensor(83)])
  call ol_merge_tensors(T0sum(226),[G0tensor(379)])
  call ol_merge_tensors(T0sum(227),[G0tensor(390)])
  call ol_merge_tensors(T0sum(228),[G0tensor(93)])
  call ol_merge_tensors(T0sum(229),[G0tensor(258)])
  call ol_merge_tensors(T0sum(230),[G0tensor(405)])
  call ol_merge_tensors(T0sum(231),[G0tensor(415)])
  call ol_merge_tensors(T0sum(232),[G0tensor(118)])
  call ol_merge_tensors(T0sum(233),[G0tensor(114)])
  call ol_merge_tensors(T0sum(234),[G0tensor(425)])
  call ol_merge_tensors(T0sum(235),[G0tensor(7)])
  call ol_merge_tensors(T0sum(236),[G0tensor(238)])
  call ol_merge_tensors(T0sum(237),[G0tensor(18)])
  call ol_merge_tensors(T0sum(238),[G0tensor(428)])
  call ol_merge_tensors(T0sum(239),[G0tensor(298)])
  call ol_merge_tensors(T0sum(240),[G0tensor(312)])
  call ol_merge_tensors(T0sum(241),[G0tensor(122)])
  call ol_merge_tensors(T0sum(242),[G0tensor(164)])
  call ol_merge_tensors(T0sum(243),[G0tensor(352)])
  call ol_merge_tensors(T0sum(244),[G0tensor(393)])
  call ol_merge_tensors(T0sum(245),[G0tensor(335)])
  call ol_merge_tensors(T0sum(246),[G0tensor(418)])
  call ol_merge_tensors(T0sum(247),[G0tensor(396)])
  call ol_merge_tensors(T0sum(248),[G0tensor(411)])
  call ol_merge_tensors(T0sum(249),[G0tensor(124)])
  call ol_merge_tensors(T0sum(250),[G0tensor(128)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_62,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_77,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_71,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_75,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_62,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_59,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_69,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 23 ],masses2_64,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 16, 18, 19 ],masses2_66,RedSet_4(4),ScalarBoxes(9))
  call compute_scalar_box([ 2, 3, 7 ],masses2_59,RedSet_4(5),ScalarBoxes(10))
  call compute_scalar_box([ 20, 22, 23 ],masses2_60,RedSet_4(6),ScalarBoxes(11))
  call compute_scalar_box([ 16, 22, 23 ],masses2_76,RedSet_4(7),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 23 ],masses2_71,RedSet_4(8),ScalarBoxes(13))
  call compute_scalar_box([ 16, 20, 22 ],masses2_73,RedSet_4(9),ScalarBoxes(14))
  call compute_scalar_box([ 4, 6, 7 ],masses2_60,RedSet_4(10),ScalarBoxes(15))
  call compute_scalar_box([ 20, 22, 23 ],masses2_61,RedSet_4(6),ScalarBoxes(16))
  call compute_scalar_box([ 16, 22, 23 ],masses2_70,RedSet_4(7),ScalarBoxes(17))
  call compute_scalar_box([ 16, 20, 23 ],masses2_64,RedSet_4(8),ScalarBoxes(18))
  call compute_scalar_box([ 16, 20, 22 ],masses2_68,RedSet_4(9),ScalarBoxes(19))
  call compute_scalar_box([ 4, 6, 7 ],masses2_61,RedSet_4(10),ScalarBoxes(20))
  call compute_scalar_box([ 18, 19, 27 ],masses2_62,RedSet_4(11),ScalarBoxes(21))
  call compute_scalar_box([ 16, 19, 27 ],masses2_77,RedSet_4(12),ScalarBoxes(22))
  call compute_scalar_box([ 16, 18, 27 ],masses2_71,RedSet_4(13),ScalarBoxes(23))
  call compute_scalar_box([ 2, 3, 11 ],masses2_62,RedSet_4(14),ScalarBoxes(24))
  call compute_scalar_box([ 17, 19, 23 ],masses2_62,RedSet_4(15),ScalarBoxes(25))
  call compute_scalar_box([ 16, 17, 23 ],masses2_71,RedSet_4(16),ScalarBoxes(26))
  call compute_scalar_box([ 16, 17, 19 ],masses2_75,RedSet_4(17),ScalarBoxes(27))
  call compute_scalar_box([ 1, 3, 7 ],masses2_62,RedSet_4(18),ScalarBoxes(28))
  call compute_scalar_box([ 17, 19, 27 ],masses2_62,RedSet_4(19),ScalarBoxes(29))
  call compute_scalar_box([ 16, 17, 27 ],masses2_71,RedSet_4(20),ScalarBoxes(30))
  call compute_scalar_box([ 1, 3, 11 ],masses2_62,RedSet_4(21),ScalarBoxes(31))
  call compute_scalar_box([ 17, 19, 27 ],masses2_59,RedSet_4(19),ScalarBoxes(32))
  call compute_scalar_box([ 16, 19, 27 ],masses2_69,RedSet_4(12),ScalarBoxes(33))
  call compute_scalar_box([ 16, 17, 27 ],masses2_64,RedSet_4(20),ScalarBoxes(34))
  call compute_scalar_box([ 16, 17, 19 ],masses2_66,RedSet_4(17),ScalarBoxes(35))
  call compute_scalar_box([ 1, 3, 11 ],masses2_59,RedSet_4(21),ScalarBoxes(36))
  call compute_scalar_box([ 18, 22, 23 ],masses2_60,RedSet_4(22),ScalarBoxes(37))
  call compute_scalar_box([ 16, 18, 22 ],masses2_73,RedSet_4(23),ScalarBoxes(38))
  call compute_scalar_box([ 2, 6, 7 ],masses2_60,RedSet_4(24),ScalarBoxes(39))
  call compute_scalar_box([ 18, 22, 23 ],masses2_61,RedSet_4(22),ScalarBoxes(40))
  call compute_scalar_box([ 16, 18, 22 ],masses2_68,RedSet_4(23),ScalarBoxes(41))
  call compute_scalar_box([ 2, 6, 7 ],masses2_61,RedSet_4(24),ScalarBoxes(42))
  call compute_scalar_box([ 17, 25, 27 ],masses2_60,RedSet_4(25),ScalarBoxes(43))
  call compute_scalar_box([ 16, 25, 27 ],masses2_76,RedSet_4(26),ScalarBoxes(44))
  call compute_scalar_box([ 16, 17, 25 ],masses2_73,RedSet_4(27),ScalarBoxes(45))
  call compute_scalar_box([ 1, 9, 11 ],masses2_60,RedSet_4(28),ScalarBoxes(46))
  call compute_scalar_box([ 17, 25, 27 ],masses2_61,RedSet_4(25),ScalarBoxes(47))
  call compute_scalar_box([ 16, 25, 27 ],masses2_70,RedSet_4(26),ScalarBoxes(48))
  call compute_scalar_box([ 16, 17, 25 ],masses2_68,RedSet_4(27),ScalarBoxes(49))
  call compute_scalar_box([ 1, 9, 11 ],masses2_61,RedSet_4(28),ScalarBoxes(50))
  call compute_scalar_box([ 17, 25, 29 ],masses2_60,RedSet_4(29),ScalarBoxes(51))
  call compute_scalar_box([ 16, 25, 29 ],masses2_76,RedSet_4(30),ScalarBoxes(52))
  call compute_scalar_box([ 16, 17, 29 ],masses2_71,RedSet_4(31),ScalarBoxes(53))
  call compute_scalar_box([ 1, 9, 13 ],masses2_60,RedSet_4(32),ScalarBoxes(54))
  call compute_scalar_box([ 17, 25, 29 ],masses2_58,RedSet_4(29),ScalarBoxes(55))
  call compute_scalar_box([ 16, 25, 29 ],masses2_64,RedSet_4(30),ScalarBoxes(56))
  call compute_scalar_box([ 16, 17, 29 ],masses2_64,RedSet_4(31),ScalarBoxes(57))
  call compute_scalar_box([ 16, 17, 25 ],masses2_64,RedSet_4(27),ScalarBoxes(58))
  call compute_scalar_box([ 1, 9, 13 ],masses2_58,RedSet_4(32),ScalarBoxes(59))
  call compute_scalar_box([ 17, 25, 29 ],masses2_61,RedSet_4(29),ScalarBoxes(60))
  call compute_scalar_box([ 16, 25, 29 ],masses2_70,RedSet_4(30),ScalarBoxes(61))
  call compute_scalar_box([ 1, 9, 13 ],masses2_61,RedSet_4(32),ScalarBoxes(62))
! end of process


end subroutine vamp_2

end module ol_vamp_2_eehll_ew_nenexeexh_1_/**/REALKIND
