
module ol_vamp_1_eehll_ew_eeexexh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eehll_ew_eeexexh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eehll_ew_eeexexh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eehll_ew_eeexexh_1_/**/DREALKIND
  use ol_tensor_sum_storage_eehll_ew_eeexexh_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eehll_ew_eeexexh_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eehll_ew_eeexexh_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(2),m3h1x16(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(3),m3h1x16(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(4),m3h1x16(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,4,2,1,8],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(5),m3h1x16(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,2,4,1,8],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(6),m3h1x16(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,2,4,1,8],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(7),m3h1x16(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,2,4,1,8],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(8),m3h1x16(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,2,8,1,4],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(9),m3h1x16(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,2,8,1,4],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(10),m3h1x16(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,2,8,1,4],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(11),m3h1x16(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,1,4,2,8],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(12),m3h1x16(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[16,1,4,2,8],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(13),m3h1x16(:,12),heltab2x16(:,:,12))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[16,1,4,2,8],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(14),m3h1x16(:,13),heltab2x16(:,:,13))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[16,1,4,8,2],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(15),m3h1x16(:,14),heltab2x16(:,:,14))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[16,1,4,8,2],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(16),m3h1x16(:,15),heltab2x16(:,:,15))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[16,1,8,2,4],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(17),m3h1x16(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[16,1,8,2,4],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(18),m3h1x16(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[16,1,8,2,4],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(19),m3h1x16(:,18),heltab2x16(:,:,18))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[16,1,8,4,2],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(20),m3h1x16(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[16,1,8,4,2],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(21),m3h1x16(:,20),heltab2x16(:,:,20))
  call Hloop_ZA_Q(ntryL,G0H16(2),ex3(:),G0H8(1),ngZl,m3h2x8(:,1),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(1),n2h8(1))
  call Hloop_ZA_Q(ntryL,G0H16(3),ex3(:),G0H8(1),ngZl,m3h2x8(:,2),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(2),n2h8(2))
  call Hloop_ZA_Q(ntryL,G0H16(4),ex3(:),G0H8(1),ngZl,m3h2x8(:,3),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(3),n2h8(3))
  call Hloop_ZA_Q(ntryL,G0H16(5),ex3(:),G0H8(1),ngZl,m3h2x8(:,4),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(4),n2h8(4))
  call Hloop_ZQ_A(ntryL,G0H16(6),ex2(:),G0H8(1),ngZl,m3h2x8(:,5),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(5),n2h8(5))
  call Hloop_ZQ_A(ntryL,G0H16(7),ex2(:),G0H8(1),ngZl,m3h2x8(:,6),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(6),n2h8(6))
  call Hloop_WQ_A(ntryL,G0H16(8),ex2(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(7),n2h8(7))
  call Hloop_ZQ_A(ntryL,G0H16(9),ex2(:),G0H8(1),ngZl,m3h2x8(:,8),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(8),n2h8(8))
  call Hloop_ZQ_A(ntryL,G0H16(10),ex2(:),G0H8(1),ngZl,m3h2x8(:,9),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(9),n2h8(9))
  call Hloop_WQ_A(ntryL,G0H16(11),ex2(:),G0H8(1),m3h2x8(:,10),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(10),n2h8(10))
  call Hloop_ZQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),ngZl,m3h2x8(:,11),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(11),n2h8(11))
  call Hloop_ZQ_A(ntryL,G0H16(13),ex1(:),G0H8(1),ngZl,m3h2x8(:,12),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(12),n2h8(12))
  call Hloop_WQ_A(ntryL,G0H16(14),ex1(:),G0H8(1),m3h2x8(:,13),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(13),n2h8(13))
  call Hloop_ZQ_A(ntryL,G0H16(15),ex1(:),G0H8(1),ngZl,m3h2x8(:,14),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(14),n2h8(14))
  call Hloop_ZQ_A(ntryL,G0H16(16),ex1(:),G0H8(1),ngZl,m3h2x8(:,15),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(15),n2h8(15))
  call Hloop_ZQ_A(ntryL,G0H16(17),ex1(:),G0H8(1),ngZl,m3h2x8(:,16),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(16),n2h8(16))
  call Hloop_ZQ_A(ntryL,G0H16(18),ex1(:),G0H8(1),ngZl,m3h2x8(:,17),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(17),n2h8(17))
  call Hloop_WQ_A(ntryL,G0H16(19),ex1(:),G0H8(1),m3h2x8(:,18),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(18),n2h8(18))
  call Hloop_ZQ_A(ntryL,G0H16(20),ex1(:),G0H8(1),ngZl,m3h2x8(:,19),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(19),n2h8(19))
  call Hloop_ZQ_A(ntryL,G0H16(21),ex1(:),G0H8(1),ngZl,m3h2x8(:,20),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(20),n2h8(20))
  call Hloop_AQ_V(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H8(2),ex1(:),G1H4(2),ngZl,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G1H8(3),ex2(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H8(4),ex2(:),G1H4(4),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G1H8(5),ex3(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_Z(ntryL,G1H8(6),ex3(:),G1H4(6),ngZl,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_W(ntryL,G1H8(7),ex3(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G1H8(8),ex4(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_Z(ntryL,G1H8(9),ex4(:),G1H4(9),ngZl,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_W(ntryL,G1H8(10),ex4(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G1H8(11),ex3(:),G1H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_Z(ntryL,G1H8(12),ex3(:),G1H4(12),ngZl,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_W(ntryL,G1H8(13),ex3(:),G1H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G1H8(14),ex3(:),G1H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_Z(ntryL,G1H8(15),ex3(:),G1H4(15),ngZl,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_V(ntryL,G1H8(16),ex4(:),G1H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_QA_Z(ntryL,G1H8(17),ex4(:),G1H4(17),ngZl,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QA_W(ntryL,G1H8(18),ex4(:),G1H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_V(ntryL,G1H8(19),ex4(:),G1H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_Z(ntryL,G1H8(20),ex4(:),G1H4(20),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(1),n2h2(1))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex2(:),G1H2(1),ngZl,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(2),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(3),n2h2(3))
  call Hloop_ZQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),ngZl,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(4),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(5),ex1(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(5),n2h2(5))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),ngZl,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(6),n2h2(6))
  call Hloop_WQ_A(ntryL,G1H4(7),ex1(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(7),n2h2(7))
  call Hloop_VQ_A(ntryL,G1H4(8),ex1(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(8),n2h2(8))
  call Hloop_ZQ_A(ntryL,G1H4(9),ex1(:),G1H2(1),ngZl,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(9),n2h2(9))
  call Hloop_WQ_A(ntryL,G1H4(10),ex1(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(10),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(11),ex2(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(11),n2h2(11))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex2(:),G1H2(1),ngZl,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(12),n2h2(12))
  call Hloop_WQ_A(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(13),n2h2(13))
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(14),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex4(:),G1H2(1),ngZl,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(15),n2h2(15))
  call Hloop_VQ_A(ntryL,G1H4(16),ex2(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(16),n2h2(16))
  call Hloop_ZQ_A(ntryL,G1H4(17),ex2(:),G1H2(1),ngZl,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(17),n2h2(17))
  call Hloop_WQ_A(ntryL,G1H4(18),ex2(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(18),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(19),ex3(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(19),n2h2(19))
  call Hloop_ZA_Q(ntryL,G1H4(20),ex3(:),G1H2(1),ngZl,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(20),n2h2(20))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),ngZl,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(2),ngZl,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(3),ngZl,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(4),ngZl,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(5),ngZl,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(6),ngZl,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(8),ngZl,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(9),ngZl,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(11),ngZl,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(12),ngZl,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(14),ex2(:),G2tensor(14),ngZl,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(15),ex2(:),G2tensor(15),ngZl,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(16),ngZl,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(17),ngZl,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(19),ex2(:),G2tensor(19),ngZl,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(20),ngZl,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(3),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(4),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(5),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(6),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(6),mass5set(:,2),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),2)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(7),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(7),mass5set(:,2),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(7),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(8),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),2)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(8),mass5set(:,2),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[16,2,8,5],[nMW,0,nMW,nMW],4,1,wf4(:,7))
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(1),m3h1x16(:,21),heltab2x16(:,:,41))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(22),h0tab(:,22),[16,2,8,5],[nMW,0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(2),m3h1x16(:,22),heltab2x16(:,:,42))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(23),h0tab(:,23),[16,2,8,5],[nMW,0,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VS_V(ntryL,G0H16(3),ex5(:),G0H16(4),m3h1x16(:,23),heltab2x16(:,:,43))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(24),h0tab(:,24),[16,2,8,5],[nMW,0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(6),m3h1x16(:,24),heltab2x16(:,:,44))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(25),h0tab(:,25),[16,5,2,8],[nMW,nMW,0,nMW],4,1,wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(3),m3h1x16(:,25),heltab2x16(:,:,45))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(26),h0tab(:,26),[16,5,2,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(4),m3h1x16(:,26),heltab2x16(:,:,46))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(27),h0tab(:,27),[16,5,2,8],[nMW,nMW,0,nMW],4,1,wf4(:,7))
  call Hloop_VS_V(ntryL,G0H16(9),ex5(:),G0H16(10),m3h1x16(:,27),heltab2x16(:,:,47))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(28),h0tab(:,28),[16,5,2,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(12),m3h1x16(:,28),heltab2x16(:,:,48))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(29),h0tab(:,29),[16,2,5,8],[nMZ,0,0,nMZ],4,1,wf4(:,7))
  call Hloop_VS_V(ntryL,G0H16(13),ex5(:),G0H16(14),m3h1x16(:,29),heltab2x16(:,:,49))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(30),h0tab(:,30),[16,2,5,8],[nMZ,0,0,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(16),m3h1x16(:,30),heltab2x16(:,:,50))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(31),h0tab(:,31),[16,2,5,8],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(17),ex5(:),G0H16(18),m3h1x16(:,31),heltab2x16(:,:,51))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(32),h0tab(:,32),[16,1,8,6],[nMW,0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(5),m3h1x16(:,32),heltab2x16(:,:,52))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(20),m0h(33),h0tab(:,33),[16,1,8,6],[nMW,0,nMW,nMW],4,1,wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(20),0,ex5(:),16,G1H16(6),m3h1x16(:,33),heltab2x16(:,:,53))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(34),h0tab(:,34),[16,1,8,6],[nMW,0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_VS_V(ntryL,G0H16(21),ex5(:),G0H16(1),m3h1x16(:,34),heltab2x16(:,:,54))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(35),h0tab(:,35),[16,1,8,6],[nMW,0,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(3),m3h1x16(:,35),heltab2x16(:,:,55))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(36),h0tab(:,36),[16,6,1,8],[nMW,nMW,0,nMW],4,1,wf4(:,12))
  call Hloop_VT_S(ntryL,G0H16(5),0,ex5(:),16,G1H16(7),m3h1x16(:,36),heltab2x16(:,:,56))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(37),h0tab(:,37),[16,6,1,8],[nMW,nMW,0,nMW],4,1,wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(8),m3h1x16(:,37),heltab2x16(:,:,57))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(38),h0tab(:,38),[16,6,1,8],[nMW,nMW,0,nMW],4,1,wf4(:,12))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(9),m3h1x16(:,38),heltab2x16(:,:,58))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(39),h0tab(:,39),[16,6,1,8],[nMW,nMW,0,nMW],4,1,wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(13),m3h1x16(:,39),heltab2x16(:,:,59))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(40),h0tab(:,40),[16,1,6,8],[nMZ,0,0,nMZ],4,1,wf4(:,12))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(17),m3h1x16(:,40),heltab2x16(:,:,60))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(41),h0tab(:,41),[16,1,6,8],[nMZ,0,0,nMZ],4,1,wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(20),m3h1x16(:,41),heltab2x16(:,:,61))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(42),h0tab(:,42),[16,1,6,8],[nMW,0,0,nMW],4,1,wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(21),ex5(:),G0H16(2),m3h1x16(:,42),heltab2x16(:,:,62))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(43),h0tab(:,43),[16,2,4,9],[nMW,0,nMW,nMW],4,1,wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(5),0,ex5(:),16,G1H16(9),m3h1x16(:,43),heltab2x16(:,:,63))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(44),h0tab(:,44),[16,2,4,9],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(10),m3h1x16(:,44),heltab2x16(:,:,64))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(45),h0tab(:,45),[16,2,4,9],[nMW,0,nMW,nMW],4,1,wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(11),m3h1x16(:,45),heltab2x16(:,:,65))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(46),h0tab(:,46),[16,2,4,9],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(19),m3h1x16(:,46),heltab2x16(:,:,66))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(47),h0tab(:,47),[16,4,2,9],[nMW,0,nMW,nMW],4,1,wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(21),0,ex5(:),16,G1H16(11),m3h1x16(:,47),heltab2x16(:,:,67))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(48),h0tab(:,48),[16,4,2,9],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(5),0,ex5(:),16,G1H16(12),m3h1x16(:,48),heltab2x16(:,:,68))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(49),h0tab(:,49),[16,4,2,9],[nMW,0,nMW,nMW],4,1,wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(8),m3h1x16(:,49),heltab2x16(:,:,69))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(50),h0tab(:,50),[16,4,2,9],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(21),m3h1x16(:,50),heltab2x16(:,:,70))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(51),h0tab(:,51),[16,2,9,4],[nMZ,0,0,nMZ],4,1,wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(7),m3h1x16(:,51),heltab2x16(:,:,71))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(52),h0tab(:,52),[16,2,9,4],[nMZ,0,0,nMZ],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(5),m3h1x16(:,52),heltab2x16(:,:,72))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(53),h0tab(:,53),[16,2,9,4],[nMW,0,0,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(22),m3h1x16(:,53),heltab2x16(:,:,73))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(54),h0tab(:,54),[16,1,4,10],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(15),0,ex5(:),16,G1H16(13),m3h1x16(:,54),heltab2x16(:,:,74))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(55),h0tab(:,55),[16,1,4,10],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(15),0,ex5(:),16,G1H16(14),m3h1x16(:,55),heltab2x16(:,:,75))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(56),h0tab(:,56),[16,1,4,10],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(23),m3h1x16(:,56),heltab2x16(:,:,76))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(57),h0tab(:,57),[16,1,4,10],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(24),m3h1x16(:,57),heltab2x16(:,:,77))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(58),h0tab(:,58),[16,4,1,10],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(15),0,ex5(:),16,G1H16(15),m3h1x16(:,58),heltab2x16(:,:,78))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(59),h0tab(:,59),[16,4,1,10],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(15),0,ex5(:),16,G1H16(16),m3h1x16(:,59),heltab2x16(:,:,79))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(60),h0tab(:,60),[16,4,1,10],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(25),m3h1x16(:,60),heltab2x16(:,:,80))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(61),h0tab(:,61),[16,4,1,10],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(26),m3h1x16(:,61),heltab2x16(:,:,81))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(62),h0tab(:,62),[16,1,10,4],[nMZ,0,0,nMZ],4,1,wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(27),m3h1x16(:,62),heltab2x16(:,:,82))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(63),h0tab(:,63),[16,1,10,4],[nMZ,0,0,nMZ],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(28),m3h1x16(:,63),heltab2x16(:,:,83))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(64),h0tab(:,64),[16,1,10,4],[nMW,0,0,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(29),m3h1x16(:,64),heltab2x16(:,:,84))
  call Hloop_WQ_A(ntryL,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(1),18,0,G2H8(1),n2h8(21))
  call Hloop_WQ_A(ntryL,G1H16(2),ex2(:),G1H8(2),m3h2x8(:,22),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(2),18,0,G2H8(2),n2h8(22))
  call Hloop_WQ_A(ntryL,G0H16(4),ex2(:),G0H8(1),m3h2x8(:,23),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(3),n2h8(23))
  call Hloop_WQ_A(ntryL,G0H16(6),ex2(:),G0H8(1),m3h2x8(:,24),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(4),n2h8(24))
  call Hloop_SV_V(ntryL,G1H16(3),wf4(:,7),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,89))
  call Hloop_SV_V(ntryL,G1H16(4),wf4(:,1),G1H4(2),m3h4x4(:,2),heltab2x16(:,:,90))
  call Hloop_UW_V(ntryL,G0H16(10),16,wf4(:,7),5,G1H4(3),m3h4x4(:,3),heltab2x16(:,:,91))
  call Hloop_UW_V(ntryL,G0H16(12),16,wf4(:,1),5,G1H4(4),m3h4x4(:,4),heltab2x16(:,:,92))
  call Hloop_ZQ_A(ntryL,G0H16(14),ex2(:),G0H8(1),ngZl,m3h2x8(:,25),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(5),n2h8(25))
  call Hloop_ZQ_A(ntryL,G0H16(16),ex2(:),G0H8(1),ngZl,m3h2x8(:,26),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(6),n2h8(26))
  call Hloop_WQ_A(ntryL,G0H16(18),ex2(:),G0H8(1),m3h2x8(:,27),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(7),n2h8(27))
  call Hloop_WQ_A(ntryL,G1H16(5),ex1(:),G1H8(8),m3h2x8(:,28),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(8),17,0,G2H8(3),n2h8(28))
  call Hloop_WQ_A(ntryL,G1H16(6),ex1(:),G1H8(9),m3h2x8(:,29),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(9),17,0,G2H8(4),n2h8(29))
  call Hloop_WQ_A(ntryL,G0H16(1),ex1(:),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(10),n2h8(30))
  call Hloop_WQ_A(ntryL,G0H16(3),ex1(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(11),n2h8(31))
  call Hloop_SV_V(ntryL,G1H16(7),wf4(:,12),G1H4(5),m3h4x4(:,5),heltab2x16(:,:,100))
  call Hloop_SV_V(ntryL,G1H16(8),wf4(:,5),G1H4(6),m3h4x4(:,6),heltab2x16(:,:,101))
  call Hloop_UW_V(ntryL,G0H16(9),16,wf4(:,12),6,G1H4(7),m3h4x4(:,7),heltab2x16(:,:,102))
  call Hloop_UW_V(ntryL,G0H16(13),16,wf4(:,5),6,G1H4(8),m3h4x4(:,8),heltab2x16(:,:,103))
  call Hloop_ZQ_A(ntryL,G0H16(17),ex1(:),G0H8(1),ngZl,m3h2x8(:,32),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(12),n2h8(32))
  call Hloop_ZQ_A(ntryL,G0H16(20),ex1(:),G0H8(1),ngZl,m3h2x8(:,33),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(13),n2h8(33))
  call Hloop_WQ_A(ntryL,G0H16(2),ex1(:),G0H8(1),m3h2x8(:,34),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(14),n2h8(34))
  call Hloop_WQ_A(ntryL,G1H16(9),ex2(:),G1H8(15),m3h2x8(:,35),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(15),18,0,G2H8(5),n2h8(35))
  call Hloop_WQ_A(ntryL,G1H16(10),ex2(:),G1H8(16),m3h2x8(:,36),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(16),18,0,G2H8(6),n2h8(36))
  call Hloop_WQ_A(ntryL,G0H16(11),ex2(:),G0H8(1),m3h2x8(:,37),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(17),n2h8(37))
  call Hloop_WQ_A(ntryL,G0H16(19),ex2(:),G0H8(1),m3h2x8(:,38),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(18),n2h8(38))
  call Hloop_WA_Q(ntryL,G1H16(11),ex3(:),G1H8(19),m3h2x8(:,39),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(19),20,0,G2H8(7),n2h8(39))
  call Hloop_WA_Q(ntryL,G1H16(12),ex3(:),G1H8(20),m3h2x8(:,40),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(20),20,0,G2H8(8),n2h8(40))
  call Hloop_WA_Q(ntryL,G0H16(8),ex3(:),G0H8(1),m3h2x8(:,41),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(1),n2h8(41))
  call Hloop_WA_Q(ntryL,G0H16(21),ex3(:),G0H8(1),m3h2x8(:,42),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(2),n2h8(42))
  call Hloop_ZQ_A(ntryL,G0H16(7),ex2(:),G0H8(1),ngZl,m3h2x8(:,43),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(8),n2h8(43))
  call Hloop_ZQ_A(ntryL,G0H16(5),ex2(:),G0H8(1),ngZl,m3h2x8(:,44),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(9),n2h8(44))
  call Hloop_WQ_A(ntryL,G0H16(22),ex2(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(15),n2h8(45))
  call Hloop_WQ_A(ntryL,G1H16(13),ex1(:),G1H8(16),m3h2x8(:,46),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(16),17,0,G2H8(9),n2h8(46))
  call Hloop_WQ_A(ntryL,G1H16(14),ex1(:),G1H8(19),m3h2x8(:,47),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(19),17,0,G2H8(10),n2h8(47))
  call Hloop_WQ_A(ntryL,G0H16(23),ex1(:),G0H8(1),m3h2x8(:,48),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(20),n2h8(48))
  call Hloop_WQ_A(ntryL,G0H16(24),ex1(:),G0H8(1),m3h2x8(:,49),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(16),n2h8(49))
  call Hloop_WA_Q(ntryL,G1H16(15),ex3(:),G1H8(19),m3h2x8(:,50),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(19),20,0,G2H8(11),n2h8(50))
  call Hloop_WA_Q(ntryL,G1H16(16),ex3(:),G1H8(19),m3h2x8(:,51),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(19),20,0,G2H8(12),n2h8(51))
  call Hloop_WA_Q(ntryL,G0H16(25),ex3(:),G0H8(1),m3h2x8(:,52),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(19),n2h8(52))
  call Hloop_WA_Q(ntryL,G0H16(26),ex3(:),G0H8(1),m3h2x8(:,53),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(21),n2h8(53))
  call Hloop_ZQ_A(ntryL,G0H16(27),ex1(:),G0H8(1),ngZl,m3h2x8(:,54),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(22),n2h8(54))
  call Hloop_ZQ_A(ntryL,G0H16(28),ex1(:),G0H8(1),ngZl,m3h2x8(:,55),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(23),n2h8(55))
  call Hloop_WQ_A(ntryL,G0H16(29),ex1(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(24),n2h8(56))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(3),G1H4(2),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(7),G1H4(6),G1H4(5)])
  call Hloop_QA_W(ntryL,G2H8(1),ex4(:),G2H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_W(ntryL,G2H8(2),ex4(:),G2H4(2),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_W(ntryL,G1H8(3),ex4(:),G1H4(9),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_W(ntryL,G1H8(4),ex4(:),G1H4(10),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_WQ_A(ntryL,G1H4(4),ex2(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(1),n2h2(21))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,7),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(2),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,1),G1H2(1),ngZl,m3h4x2(:,2),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(3),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,1),G1H2(1),ngZn,m3h4x2(:,3),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(4),n2h2(24))
  call Hloop_QA_W(ntryL,G2H8(3),ex4(:),G2H4(3),m3h2x4(:,25),heltab2x8(:,:,28))
  call Hloop_QA_W(ntryL,G2H8(4),ex4(:),G2H4(4),m3h2x4(:,26),heltab2x8(:,:,29))
  call Hloop_QA_W(ntryL,G1H8(10),ex4(:),G1H4(11),m3h2x4(:,27),heltab2x8(:,:,30))
  call Hloop_QA_W(ntryL,G1H8(11),ex4(:),G1H4(12),m3h2x4(:,28),heltab2x8(:,:,31))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(5),n2h2(25))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,12),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(6),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,5),G1H2(1),ngZl,m3h4x2(:,5),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(7),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,5),G1H2(1),ngZn,m3h4x2(:,6),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(8),n2h2(28))
  call Hloop_QA_W(ntryL,G2H8(5),ex3(:),G2H4(5),m3h2x4(:,29),heltab2x8(:,:,35))
  call Hloop_QA_W(ntryL,G2H8(6),ex3(:),G2H4(6),m3h2x4(:,30),heltab2x8(:,:,36))
  call Hloop_QA_W(ntryL,G1H8(17),ex3(:),G1H4(13),m3h2x4(:,31),heltab2x8(:,:,37))
  call Hloop_QA_W(ntryL,G1H8(18),ex3(:),G1H4(14),m3h2x4(:,32),heltab2x8(:,:,38))
  call Hloop_AQ_W(ntryL,G2H8(7),ex2(:),G2H4(7),m3h2x4(:,33),heltab2x8(:,:,39))
  call Hloop_AQ_W(ntryL,G2H8(8),ex2(:),G2H4(8),m3h2x4(:,34),heltab2x8(:,:,40))
  call Hloop_AQ_W(ntryL,G1H8(1),ex2(:),G1H4(15),m3h2x4(:,35),heltab2x8(:,:,41))
  call Hloop_AQ_W(ntryL,G1H8(2),ex2(:),G1H4(16),m3h2x4(:,36),heltab2x8(:,:,42))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,11),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(9),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H8(9),wf4(:,4),G1H2(1),ngZl,m3h4x2(:,8),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(10),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H8(15),wf4(:,4),G1H2(1),ngZn,m3h4x2(:,9),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(11),n2h2(31))
  call Hloop_QA_W(ntryL,G2H8(9),ex3(:),G2H4(9),m3h2x4(:,37),heltab2x8(:,:,46))
  call Hloop_QA_W(ntryL,G2H8(10),ex3(:),G2H4(10),m3h2x4(:,38),heltab2x8(:,:,47))
  call Hloop_QA_W(ntryL,G1H8(20),ex3(:),G1H4(17),m3h2x4(:,39),heltab2x8(:,:,48))
  call Hloop_QA_W(ntryL,G1H8(16),ex3(:),G1H4(18),m3h2x4(:,40),heltab2x8(:,:,49))
  call Hloop_AQ_W(ntryL,G2H8(11),ex1(:),G2H4(11),m3h2x4(:,41),heltab2x8(:,:,50))
  call Hloop_AQ_W(ntryL,G2H8(12),ex1(:),G2H4(12),m3h2x4(:,42),heltab2x8(:,:,51))
  call Hloop_AQ_W(ntryL,G1H8(19),ex1(:),G1H4(19),m3h2x4(:,43),heltab2x8(:,:,52))
  call Hloop_AQ_W(ntryL,G1H8(21),ex1(:),G1H4(20),m3h2x4(:,44),heltab2x8(:,:,53))
  call Hloop_QV_A(ntryL,G1H8(22),wf4(:,8),G1H2(1),m3h4x2(:,10),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(12),n2h2(32))
  call Hloop_QZ_A(ntryL,G1H8(23),wf4(:,2),G1H2(1),ngZl,m3h4x2(:,11),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(13),n2h2(33))
  call Hloop_QZ_A(ntryL,G1H8(24),wf4(:,2),G1H2(1),ngZn,m3h4x2(:,12),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(14),n2h2(34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(12)])
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(1),wf4(:,7),G2tensor(1),m3h4x1(:,1),heltab2x4(:,:,23))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(2),wf4(:,1),G2tensor(2),m3h4x1(:,2),heltab2x4(:,:,24))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(9),26,wf4(:,7),5,G2tensor(3),m3h4x1(:,3),heltab2x4(:,:,25))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(10),26,wf4(:,1),5,G2tensor(4),m3h4x1(:,4),heltab2x4(:,:,26))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(5),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(6),ngZl,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(7),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(3),wf4(:,12),G2tensor(8),m3h4x1(:,5),heltab2x4(:,:,27))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(4),wf4(:,5),G2tensor(9),m3h4x1(:,6),heltab2x4(:,:,28))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(11),25,wf4(:,12),6,G2tensor(10),m3h4x1(:,7),heltab2x4(:,:,29))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(12),25,wf4(:,5),6,G2tensor(11),m3h4x1(:,8),heltab2x4(:,:,30))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(12),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(13),ngZl,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(14),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(5),wf4(:,11),G2tensor(15),m3h4x1(:,9),heltab2x4(:,:,31))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(6),wf4(:,4),G2tensor(16),m3h4x1(:,10),heltab2x4(:,:,32))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(13),22,wf4(:,11),9,G2tensor(17),m3h4x1(:,11),heltab2x4(:,:,33))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(14),22,wf4(:,4),9,G2tensor(18),m3h4x1(:,12),heltab2x4(:,:,34))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(7),wf4(:,11),G2tensor(19),m3h4x1(:,13),heltab2x4(:,:,35))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(8),wf4(:,4),G2tensor(20),m3h4x1(:,14),heltab2x4(:,:,36))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(15),22,wf4(:,11),9,G2tensor(21),m3h4x1(:,15),heltab2x4(:,:,37))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(16),22,wf4(:,4),9,G2tensor(22),m3h4x1(:,16),heltab2x4(:,:,38))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(23),ngZl,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(24),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(9),wf4(:,8),G2tensor(25),m3h4x1(:,17),heltab2x4(:,:,39))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(10),wf4(:,2),G2tensor(26),m3h4x1(:,18),heltab2x4(:,:,40))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(17),21,wf4(:,8),10,G2tensor(27),m3h4x1(:,19),heltab2x4(:,:,41))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(18),21,wf4(:,2),10,G2tensor(28),m3h4x1(:,20),heltab2x4(:,:,42))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(11),wf4(:,8),G2tensor(29),m3h4x1(:,21),heltab2x4(:,:,43))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(12),wf4(:,2),G2tensor(30),m3h4x1(:,22),heltab2x4(:,:,44))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(19),21,wf4(:,8),10,G2tensor(31),m3h4x1(:,23),heltab2x4(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),21,wf4(:,2),10,G2tensor(32),m3h4x1(:,24),heltab2x4(:,:,46))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(33),ngZl,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(34),m3h2x1(:,30),heltab2x2(:,:,30))
  call ol_merge_tensors(G1tensor(64),[G1tensor(4)])
  call ol_merge_tensors(G1tensor(23),[G1tensor(17),G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(10)])
  call ol_merge_tensors(G1tensor(28),[G1tensor(16)])
  call ol_merge_tensors(G1tensor(34),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(35),G1tensor(29)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(17),G2tensor(16),G2tensor(15),G1tensor(42)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(53),G1tensor(47)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(3),G2tensor(2),G2tensor(1),G1tensor(60)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(71),G1tensor(65)])
  call ol_merge_tensors(G1tensor(84),[G1tensor(66)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(72)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(27),G2tensor(26),G2tensor(25),G1tensor(78)])
  call ol_merge_tensors(G1tensor(119),[G1tensor(113),G1tensor(89),G1tensor(83)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(101),G1tensor(95)])
  call ol_merge_tensors(G1tensor(114),[G1tensor(96)])
  call ol_merge_tensors(G1tensor(120),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(10),G2tensor(9),G2tensor(8),G1tensor(108)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(21),G2tensor(20),G2tensor(19)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(31),G2tensor(30),G2tensor(29)])
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(11),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(7),mass4set(:,2),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(11),mass4set(:,3),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(12),mass4set(:,4),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),9)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(16),mass4set(:,1),  & 
G1tensor(4),G1tensor(17),G1tensor(11),G1tensor(5),G1tensor(10))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(16),mass4set(:,3),  & 
G1tensor(16),G1tensor(22),G1tensor(35),G1tensor(29),G1tensor(40))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(17),mass4set(:,4),  & 
G1tensor(41),G1tensor(42),G1tensor(53),G1tensor(47),G1tensor(59))
  call G_TensorShift(G1tensor(42),5)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(20),mass4set(:,1),  & 
G1tensor(60),G1tensor(71),G1tensor(65),G1tensor(66),G1tensor(72))
  call G_TensorShift(G1tensor(71),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(2),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(113),G1tensor(89))
  call G_TensorShift(G1tensor(77),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(20),mass4set(:,3),  & 
G1tensor(83),G1tensor(101),G1tensor(95),G1tensor(96),G1tensor(102))
  call G_TensorShift(G1tensor(101),8)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(21),mass4set(:,4),  & 
G1tensor(107),G1tensor(108),G1tensor(121),G1tensor(122),G1tensor(123))
  call G_TensorShift(G1tensor(108),10)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(29),mass4set(:,1),  & 
G1tensor(124),G1tensor(125),G1tensor(126),G1tensor(127),G1tensor(128))
  call G_TensorShift(G1tensor(125),4)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(29),mass4set(:,3),  & 
G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132),G1tensor(133))
  call G_TensorShift(G1tensor(130),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(30),mass4set(:,4),  & 
G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(135),6)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(8),mass4set(:,4),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143))
  call G_TensorShift(G1tensor(140),9)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(4),mass4set(:,4),  & 
G1tensor(144),G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148))
  call G_TensorShift(G1tensor(145),10)
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(35),mass4set(:,5),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(1),mass4set(:,6),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(2),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(3),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(4),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(35),mass4set(:,7),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(1),mass4set(:,8),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(70),RedSet_4(2),mass4set(:,9),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(4),mass4set(:,10),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(36),mass4set(:,5),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(6),mass4set(:,6),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(7),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(8),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(36),mass4set(:,7),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(6),mass4set(:,8),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(7),mass4set(:,9),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(24),RedSet_4(8),mass4set(:,10),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(37),mass4set(:,5),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(27),RedSet_4(10),mass4set(:,6),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(11),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(12),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(37),mass4set(:,7),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(10),mass4set(:,8),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(12),mass4set(:,10),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(37),mass4set(:,11),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(10),mass4set(:,12),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(7),mass4set(:,2),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(11),mass4set(:,3),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(12),mass4set(:,4),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(38),mass4set(:,5),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(14),mass4set(:,6),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(15),mass4set(:,1),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(16),mass4set(:,1),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(17),mass4set(:,1),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(38),mass4set(:,7),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(14),mass4set(:,8),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(15),mass4set(:,9),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(54),RedSet_4(17),mass4set(:,10),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(38),mass4set(:,11),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(14),mass4set(:,12),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(15),mass4set(:,2),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(16),mass4set(:,3),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(17),mass4set(:,4),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(39),mass4set(:,5),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(19),mass4set(:,6),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(60),RedSet_4(20),mass4set(:,1),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(21),mass4set(:,1),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(39),mass4set(:,7),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(19),mass4set(:,8),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(21),mass4set(:,10),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(39),mass4set(:,11),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(75),RedSet_4(19),mass4set(:,12),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(2),mass4set(:,2),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(20),mass4set(:,3),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(107),RedSet_4(21),mass4set(:,4),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(40),mass4set(:,5),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(23),mass4set(:,6),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(82),RedSet_4(24),mass4set(:,1),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(119),RedSet_4(25),mass4set(:,1),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(40),mass4set(:,7),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(87),RedSet_4(23),mass4set(:,8),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(88),RedSet_4(24),mass4set(:,9),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(92),RedSet_4(41),mass4set(:,5),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(27),mass4set(:,6),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(94),RedSet_4(28),mass4set(:,1),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(124),RedSet_4(29),mass4set(:,1),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(114),RedSet_4(30),mass4set(:,1),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(41),mass4set(:,7),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(99),RedSet_4(27),mass4set(:,8),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(100),RedSet_4(28),mass4set(:,9),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(120),RedSet_4(30),mass4set(:,10),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(41),mass4set(:,11),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(105),RedSet_4(27),mass4set(:,12),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(28),mass4set(:,2),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(129),RedSet_4(29),mass4set(:,3),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(134),RedSet_4(30),mass4set(:,4),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(42),mass4set(:,5),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(32),mass4set(:,6),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(112),RedSet_4(33),mass4set(:,1),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(42),mass4set(:,7),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(117),RedSet_4(32),mass4set(:,8),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(118),RedSet_4(33),mass4set(:,9),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(139),RedSet_4(8),mass4set(:,4),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(144),RedSet_4(4),mass4set(:,4),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(65),h0tab(:,65),[16,5,10],[nML,nML,nML],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H16(15),ex5(:),G0H16(4),ngH,m3h1x16(:,65),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(4),16,nML,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(66),h0tab(:,66),[16,5,10],[nML,nML,nML],3,2,wf4(:,7),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(6),ex5(:),G0H16(10),ngH,m3h1x16(:,66),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G0H16(10),16,nML,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(67),h0tab(:,67),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H16(12),ex5(:),G0H16(14),ngH,m3h1x16(:,67),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMT,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(16),m0h(68),h0tab(:,68),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(16),ex5(:),G0H16(18),ngH,m3h1x16(:,68),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G0H16(18),16,nMT,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(3),ngH,m3h1x16(:,69),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(70),h0tab(:,70),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(9),ex5(:),G0H16(13),ngH,m3h1x16(:,70),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G0H16(13),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(71),h0tab(:,71),[16,5,10],[nML,nML,nML],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(17),ex5(:),G0H16(20),ngH,m3h1x16(:,71),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(20),16,nML,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(72),h0tab(:,72),[16,5,10],[nML,nML,nML],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(2),ex5(:),G0H16(11),ngH,m3h1x16(:,72),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G0H16(11),16,nML,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(73),h0tab(:,73),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(8),ngH,m3h1x16(:,73),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G0H16(8),16,nMT,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(74),h0tab(:,74),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(21),ex5(:),G0H16(7),ngH,m3h1x16(:,74),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G0H16(7),16,nMT,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(75),h0tab(:,75),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(5),ex5(:),G0H16(22),ngH,m3h1x16(:,75),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(22),16,nMB,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(76),h0tab(:,76),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(23),ex5(:),G0H16(24),ngH,m3h1x16(:,76),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(24),16,nMB,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(77),h0tab(:,77),[16,5,10],[nML,nML,nML],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H16(25),ex5(:),G0H16(26),ngH,m3h1x16(:,77),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G0H16(26),16,nML,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(78),h0tab(:,78),[16,5,10],[nML,nML,nML],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(27),ex5(:),G0H16(28),ngH,m3h1x16(:,78),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(28),16,nML,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(29),m0h(79),h0tab(:,79),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H16(29),ex5(:),G0H16(15),ngH,m3h1x16(:,79),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMT,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(80),h0tab(:,80),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(4),ex5(:),G0H16(6),ngH,m3h1x16(:,80),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMT,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(81),h0tab(:,81),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AS_Q(ntryL,G0H16(10),ex5(:),G0H16(12),ngH,m3h1x16(:,81),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(12),16,nMB,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(82),h0tab(:,82),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(14),ex5(:),G0H16(16),ngH,m3h1x16(:,82),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(16),16,nMB,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(83),h0tab(:,83),[16,5,10],[nML,nML,nML],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(18),ex5(:),G0H16(1),ngH,m3h1x16(:,83),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G0H16(1),16,nML,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(84),h0tab(:,84),[16,5,10],[nML,nML,nML],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(3),ex5(:),G0H16(9),ngH,m3h1x16(:,84),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(85),h0tab(:,85),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(13),ex5(:),G0H16(17),ngH,m3h1x16(:,85),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(17),16,nMT,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(20),m0h(86),h0tab(:,86),[16,5,10],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(20),ex5(:),G0H16(2),ngH,m3h1x16(:,86),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(87),h0tab(:,87),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(11),ex5(:),G0H16(19),ngH,m3h1x16(:,87),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G0H16(19),16,nMB,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(88),h0tab(:,88),[16,5,10],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(8),ex5(:),G0H16(21),ngH,m3h1x16(:,88),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(21),16,nMB,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(89),h0tab(:,89),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(5),m3h1x16(:,89),heltab2x16(:,:,153))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(90),h0tab(:,90),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(22),ex5(:),G0H16(23),m3h1x16(:,90),heltab2x16(:,:,154))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(24),m0h(91),h0tab(:,91),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(24),ex5(:),G0H16(25),m3h1x16(:,91),heltab2x16(:,:,155))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(26),m0h(92),h0tab(:,92),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(26),ex5(:),G0H16(27),m3h1x16(:,92),heltab2x16(:,:,156))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(28),m0h(93),h0tab(:,93),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(28),ex5(:),G0H16(29),m3h1x16(:,93),heltab2x16(:,:,157))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(94),h0tab(:,94),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(15),ex5(:),G0H16(4),m3h1x16(:,94),heltab2x16(:,:,158))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(95),h0tab(:,95),[16,5,10],[nMH,nMZ,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(6),ex5(:),G0H16(10),m3h1x16(:,95),heltab2x16(:,:,159))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(96),h0tab(:,96),[16,5,10],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(12),ex5(:),G0H16(14),m3h1x16(:,96),heltab2x16(:,:,160))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(16),m0h(97),h0tab(:,97),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(16),ex5(:),G0H16(18),m3h1x16(:,97),heltab2x16(:,:,161))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(3),m3h1x16(:,98),heltab2x16(:,:,162))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(99),h0tab(:,99),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(9),ex5(:),G0H16(13),m3h1x16(:,99),heltab2x16(:,:,163))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(100),h0tab(:,100),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(17),ex5(:),G0H16(20),m3h1x16(:,100),heltab2x16(:,:,164))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(101),h0tab(:,101),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(2),ex5(:),G0H16(11),m3h1x16(:,101),heltab2x16(:,:,165))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(102),h0tab(:,102),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(8),m3h1x16(:,102),heltab2x16(:,:,166))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(103),h0tab(:,103),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(21),ex5(:),G0H16(7),m3h1x16(:,103),heltab2x16(:,:,167))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(104),h0tab(:,104),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(22),ex5(:),G0H16(24),m3h1x16(:,104),heltab2x16(:,:,168))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(26),m0h(105),h0tab(:,105),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(26),ex5(:),G0H16(28),m3h1x16(:,105),heltab2x16(:,:,169))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(106),h0tab(:,106),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(15),ex5(:),G0H16(6),m3h1x16(:,106),heltab2x16(:,:,170))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(107),h0tab(:,107),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(12),ex5(:),G0H16(16),m3h1x16(:,107),heltab2x16(:,:,171))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(9),m3h1x16(:,108),heltab2x16(:,:,172))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(109),h0tab(:,109),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(17),ex5(:),G0H16(2),m3h1x16(:,109),heltab2x16(:,:,173))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(110),h0tab(:,110),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(21),m3h1x16(:,110),heltab2x16(:,:,174))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(111),h0tab(:,111),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(22),ex5(:),G0H16(26),m3h1x16(:,111),heltab2x16(:,:,175))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(112),h0tab(:,112),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(15),ex5(:),G0H16(12),m3h1x16(:,112),heltab2x16(:,:,176))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(17),m3h1x16(:,113),heltab2x16(:,:,177))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(114),h0tab(:,114),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(22),m3h1x16(:,114),heltab2x16(:,:,178))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(115),h0tab(:,115),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(1),m3h1x16(:,115),heltab2x16(:,:,179))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(116),h0tab(:,116),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(15),m3h1x16(:,116),heltab2x16(:,:,180))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(117),h0tab(:,117),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(30),m3h1x16(:,117),heltab2x16(:,:,181))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(118),h0tab(:,118),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(31),m3h1x16(:,118),heltab2x16(:,:,182))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(119),h0tab(:,119),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(32),m3h1x16(:,119),heltab2x16(:,:,183))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(120),h0tab(:,120),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(33),m3h1x16(:,120),heltab2x16(:,:,184))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(121),h0tab(:,121),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(34),m3h1x16(:,121),heltab2x16(:,:,185))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(122),h0tab(:,122),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(35),m3h1x16(:,122),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(123),h0tab(:,123),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(36),m3h1x16(:,123),heltab2x16(:,:,187))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(124),h0tab(:,124),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(37),m3h1x16(:,124),heltab2x16(:,:,188))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(125),h0tab(:,125),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(38),m3h1x16(:,125),heltab2x16(:,:,189))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(126),h0tab(:,126),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(39),m3h1x16(:,126),heltab2x16(:,:,190))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(127),h0tab(:,127),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(40),m3h1x16(:,127),heltab2x16(:,:,191))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(128),h0tab(:,128),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(41),m3h1x16(:,128),heltab2x16(:,:,192))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(129),h0tab(:,129),[16,5,10],[nMH,nMZ,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(42),m3h1x16(:,129),heltab2x16(:,:,193))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(130),h0tab(:,130),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(43),m3h1x16(:,130),heltab2x16(:,:,194))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(131),h0tab(:,131),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(44),m3h1x16(:,131),heltab2x16(:,:,195))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(132),h0tab(:,132),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(25),m3h1x16(:,132),heltab2x16(:,:,196))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(133),h0tab(:,133),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(26),m3h1x16(:,133),heltab2x16(:,:,197))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(134),h0tab(:,134),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(27),m3h1x16(:,134),heltab2x16(:,:,198))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(135),h0tab(:,135),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(28),m3h1x16(:,135),heltab2x16(:,:,199))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(136),h0tab(:,136),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(29),m3h1x16(:,136),heltab2x16(:,:,200))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(137),h0tab(:,137),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(30),m3h1x16(:,137),heltab2x16(:,:,201))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(138),h0tab(:,138),[16,5,10],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(31),m3h1x16(:,138),heltab2x16(:,:,202))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(139),h0tab(:,139),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(32),m3h1x16(:,139),heltab2x16(:,:,203))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(140),h0tab(:,140),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(33),m3h1x16(:,140),heltab2x16(:,:,204))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(141),h0tab(:,141),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(34),m3h1x16(:,141),heltab2x16(:,:,205))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(142),h0tab(:,142),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(35),m3h1x16(:,142),heltab2x16(:,:,206))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(143),h0tab(:,143),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(36),m3h1x16(:,143),heltab2x16(:,:,207))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(144),h0tab(:,144),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(37),m3h1x16(:,144),heltab2x16(:,:,208))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(145),h0tab(:,145),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(38),m3h1x16(:,145),heltab2x16(:,:,209))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(146),h0tab(:,146),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(39),m3h1x16(:,146),heltab2x16(:,:,210))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(147),h0tab(:,147),[16,5,10],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(40),m3h1x16(:,147),heltab2x16(:,:,211))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(148),h0tab(:,148),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(41),m3h1x16(:,148),heltab2x16(:,:,212))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(149),h0tab(:,149),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(42),m3h1x16(:,149),heltab2x16(:,:,213))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(150),h0tab(:,150),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(43),m3h1x16(:,150),heltab2x16(:,:,214))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(151),h0tab(:,151),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(44),m3h1x16(:,151),heltab2x16(:,:,215))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(152),h0tab(:,152),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(45),m3h1x16(:,152),heltab2x16(:,:,216))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(153),h0tab(:,153),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(46),m3h1x16(:,153),heltab2x16(:,:,217))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(154),h0tab(:,154),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(47),m3h1x16(:,154),heltab2x16(:,:,218))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(155),h0tab(:,155),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(48),m3h1x16(:,155),heltab2x16(:,:,219))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(156),h0tab(:,156),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(49),m3h1x16(:,156),heltab2x16(:,:,220))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(157),h0tab(:,157),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(50),m3h1x16(:,157),heltab2x16(:,:,221))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(158),h0tab(:,158),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(51),m3h1x16(:,158),heltab2x16(:,:,222))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(159),h0tab(:,159),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(52),m3h1x16(:,159),heltab2x16(:,:,223))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(160),h0tab(:,160),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(53),m3h1x16(:,160),heltab2x16(:,:,224))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(161),h0tab(:,161),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(54),m3h1x16(:,161),heltab2x16(:,:,225))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(162),h0tab(:,162),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(55),m3h1x16(:,162),heltab2x16(:,:,226))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(163),h0tab(:,163),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(56),m3h1x16(:,163),heltab2x16(:,:,227))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(164),h0tab(:,164),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(57),m3h1x16(:,164),heltab2x16(:,:,228))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(165),h0tab(:,165),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(58),m3h1x16(:,165),heltab2x16(:,:,229))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(166),h0tab(:,166),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(45),m3h1x16(:,166),heltab2x16(:,:,230))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(167),h0tab(:,167),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(46),m3h1x16(:,167),heltab2x16(:,:,231))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(168),h0tab(:,168),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(47),m3h1x16(:,168),heltab2x16(:,:,232))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(169),h0tab(:,169),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(48),m3h1x16(:,169),heltab2x16(:,:,233))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(170),h0tab(:,170),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(49),m3h1x16(:,170),heltab2x16(:,:,234))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(171),h0tab(:,171),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(50),m3h1x16(:,171),heltab2x16(:,:,235))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(172),h0tab(:,172),[16,5,10],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(51),m3h1x16(:,172),heltab2x16(:,:,236))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(173),h0tab(:,173),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(52),m3h1x16(:,173),heltab2x16(:,:,237))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(174),h0tab(:,174),[16,5,10],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(53),m3h1x16(:,174),heltab2x16(:,:,238))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(175),h0tab(:,175),[16,7,8],[nMZ,0,nMZ],3,1,wf8(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(54),m3h1x16(:,175),heltab2x16(:,:,239))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(176),h0tab(:,176),[16,7,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(55),m3h1x16(:,176),heltab2x16(:,:,240))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(177),h0tab(:,177),[16,7,8],[nMZ,0,nMZ],3,1,wf8(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(56),m3h1x16(:,177),heltab2x16(:,:,241))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(178),h0tab(:,178),[16,7,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(57),m3h1x16(:,178),heltab2x16(:,:,242))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(179),h0tab(:,179),[16,2,13],[nMZ,0,nMZ],3,1,wf8(:,6))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(58),m3h1x16(:,179),heltab2x16(:,:,243))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(180),h0tab(:,180),[16,2,13],[nMW,0,nMW],3,1,wf8(:,6))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(59),m3h1x16(:,180),heltab2x16(:,:,244))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(181),h0tab(:,181),[16,2,13],[nMZ,0,nMZ],3,1,wf8(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(60),m3h1x16(:,181),heltab2x16(:,:,245))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(182),h0tab(:,182),[16,2,13],[nMW,0,nMW],3,1,wf8(:,8))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(61),m3h1x16(:,182),heltab2x16(:,:,246))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(183),h0tab(:,183),[21,2,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,3),G0H4(1),ngZl,m3h4x4(:,9),heltab2x16(:,:,247))
  call Hloop_A_Q(ntryL,G0H4(1),21,0,G1H4(3),n2h4(1))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(184),h0tab(:,184),[21,2,8],[0,nMZ,0],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,3),G0H4(1),ngZl,m3h4x4(:,10),heltab2x16(:,:,248))
  call Hloop_A_Q(ntryL,G0H4(1),21,0,G1H4(2),n2h4(2))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(185),h0tab(:,185),[21,2,8],[0,nMW,0],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,3),G0H4(1),ngZn,m3h4x4(:,11),heltab2x16(:,:,249))
  call Hloop_A_Q(ntryL,G0H4(1),21,0,G1H4(1),n2h4(3))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(186),h0tab(:,186),[21,2,8],[nMW,0,nMW],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H16(19),0,wf4(:,3),21,G1H4(7),m3h4x4(:,12),heltab2x16(:,:,250))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(187),h0tab(:,187),[16,6,9],[nML,nML,nML],3,2,wf4(:,12),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,183),heltab2x16(:,:,251))
  call Hloop_Q_A(ntryL,G0H16(62),16,nML,G1H16(59),n2h16(25))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(188),h0tab(:,188),[16,6,9],[nML,nML,nML],3,2,wf4(:,12),wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,184),heltab2x16(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(62),16,nML,G1H16(60),n2h16(26))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(189),h0tab(:,189),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,12),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,185),heltab2x16(:,:,253))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMT,G1H16(61),n2h16(27))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(190),h0tab(:,190),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,12),wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,186),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMT,G1H16(62),n2h16(28))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(191),h0tab(:,191),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,12),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,187),heltab2x16(:,:,255))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMB,G1H16(63),n2h16(29))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(192),h0tab(:,192),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,12),wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,188),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMB,G1H16(64),n2h16(30))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(193),h0tab(:,193),[16,6,9],[nML,nML,nML],3,2,wf4(:,5),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,189),heltab2x16(:,:,257))
  call Hloop_Q_A(ntryL,G0H16(62),16,nML,G1H16(65),n2h16(31))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(194),h0tab(:,194),[16,6,9],[nML,nML,nML],3,2,wf4(:,5),wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,190),heltab2x16(:,:,258))
  call Hloop_A_Q(ntryL,G0H16(62),16,nML,G1H16(66),n2h16(32))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(195),h0tab(:,195),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,5),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,191),heltab2x16(:,:,259))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMT,G1H16(67),n2h16(33))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(196),h0tab(:,196),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,5),wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,192),heltab2x16(:,:,260))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMT,G1H16(68),n2h16(34))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(197),h0tab(:,197),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,5),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,193),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMB,G1H16(69),n2h16(35))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(198),h0tab(:,198),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,5),wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,194),heltab2x16(:,:,262))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMB,G1H16(70),n2h16(36))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(199),h0tab(:,199),[16,6,9],[nML,nML,nML],3,2,wf4(:,12),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,195),heltab2x16(:,:,263))
  call Hloop_Q_A(ntryL,G0H16(62),16,nML,G1H16(71),n2h16(37))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(200),h0tab(:,200),[16,6,9],[nML,nML,nML],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,196),heltab2x16(:,:,264))
  call Hloop_A_Q(ntryL,G0H16(62),16,nML,G1H16(72),n2h16(38))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(201),h0tab(:,201),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,12),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,197),heltab2x16(:,:,265))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMT,G1H16(73),n2h16(39))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(202),h0tab(:,202),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,198),heltab2x16(:,:,266))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMT,G1H16(74),n2h16(40))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(203),h0tab(:,203),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,12),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,199),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMB,G1H16(75),n2h16(41))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(204),h0tab(:,204),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,200),heltab2x16(:,:,268))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMB,G1H16(76),n2h16(42))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(205),h0tab(:,205),[16,6,9],[nML,nML,nML],3,2,wf4(:,5),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,201),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G0H16(62),16,nML,G1H16(77),n2h16(43))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(206),h0tab(:,206),[16,6,9],[nML,nML,nML],3,2,wf4(:,5),wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,202),heltab2x16(:,:,270))
  call Hloop_A_Q(ntryL,G0H16(62),16,nML,G1H16(78),n2h16(44))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(207),h0tab(:,207),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,5),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,203),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMT,G1H16(79),n2h16(45))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(208),h0tab(:,208),[16,6,9],[nMT,nMT,nMT],3,2,wf4(:,5),wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,204),heltab2x16(:,:,272))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMT,G1H16(80),n2h16(46))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(209),h0tab(:,209),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,5),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,205),heltab2x16(:,:,273))
  call Hloop_Q_A(ntryL,G0H16(62),16,nMB,G1H16(81),n2h16(47))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(210),h0tab(:,210),[16,6,9],[nMB,nMB,nMB],3,2,wf4(:,5),wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(19),ex5(:),G0H16(62),ngH,m3h1x16(:,206),heltab2x16(:,:,274))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMB,G1H16(82),n2h16(48))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(211),h0tab(:,211),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(62),m3h1x16(:,207),heltab2x16(:,:,275))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(212),h0tab(:,212),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(63),m3h1x16(:,208),heltab2x16(:,:,276))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(213),h0tab(:,213),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(64),m3h1x16(:,209),heltab2x16(:,:,277))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(214),h0tab(:,214),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(65),m3h1x16(:,210),heltab2x16(:,:,278))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(215),h0tab(:,215),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(66),m3h1x16(:,211),heltab2x16(:,:,279))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(216),h0tab(:,216),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(67),m3h1x16(:,212),heltab2x16(:,:,280))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(217),h0tab(:,217),[16,6,9],[nMH,nMZ,nMH],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(68),m3h1x16(:,213),heltab2x16(:,:,281))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(218),h0tab(:,218),[16,6,9],[nMZ,nMH,nMZ],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(69),m3h1x16(:,214),heltab2x16(:,:,282))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(219),h0tab(:,219),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(70),m3h1x16(:,215),heltab2x16(:,:,283))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(220),h0tab(:,220),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(71),m3h1x16(:,216),heltab2x16(:,:,284))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(221),h0tab(:,221),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(72),m3h1x16(:,217),heltab2x16(:,:,285))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(222),h0tab(:,222),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(73),m3h1x16(:,218),heltab2x16(:,:,286))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(223),h0tab(:,223),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(74),m3h1x16(:,219),heltab2x16(:,:,287))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(224),h0tab(:,224),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(75),m3h1x16(:,220),heltab2x16(:,:,288))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(225),h0tab(:,225),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(76),m3h1x16(:,221),heltab2x16(:,:,289))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(226),h0tab(:,226),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(77),m3h1x16(:,222),heltab2x16(:,:,290))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(227),h0tab(:,227),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(78),m3h1x16(:,223),heltab2x16(:,:,291))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(228),h0tab(:,228),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(79),m3h1x16(:,224),heltab2x16(:,:,292))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(229),h0tab(:,229),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(80),m3h1x16(:,225),heltab2x16(:,:,293))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(230),h0tab(:,230),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(81),m3h1x16(:,226),heltab2x16(:,:,294))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(231),h0tab(:,231),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(82),m3h1x16(:,227),heltab2x16(:,:,295))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(232),h0tab(:,232),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(83),m3h1x16(:,228),heltab2x16(:,:,296))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(233),h0tab(:,233),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(84),m3h1x16(:,229),heltab2x16(:,:,297))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(234),h0tab(:,234),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(85),m3h1x16(:,230),heltab2x16(:,:,298))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(235),h0tab(:,235),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(86),m3h1x16(:,231),heltab2x16(:,:,299))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(236),h0tab(:,236),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(87),m3h1x16(:,232),heltab2x16(:,:,300))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(237),h0tab(:,237),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(88),m3h1x16(:,233),heltab2x16(:,:,301))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(238),h0tab(:,238),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(89),m3h1x16(:,234),heltab2x16(:,:,302))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(239),h0tab(:,239),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(90),m3h1x16(:,235),heltab2x16(:,:,303))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(240),h0tab(:,240),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(91),m3h1x16(:,236),heltab2x16(:,:,304))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(241),h0tab(:,241),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(92),m3h1x16(:,237),heltab2x16(:,:,305))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(242),h0tab(:,242),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(93),m3h1x16(:,238),heltab2x16(:,:,306))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(243),h0tab(:,243),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(94),m3h1x16(:,239),heltab2x16(:,:,307))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(244),h0tab(:,244),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(95),m3h1x16(:,240),heltab2x16(:,:,308))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(245),h0tab(:,245),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(96),m3h1x16(:,241),heltab2x16(:,:,309))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(246),h0tab(:,246),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(97),m3h1x16(:,242),heltab2x16(:,:,310))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(247),h0tab(:,247),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(98),m3h1x16(:,243),heltab2x16(:,:,311))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(248),h0tab(:,248),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(99),m3h1x16(:,244),heltab2x16(:,:,312))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(249),h0tab(:,249),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(100),m3h1x16(:,245),heltab2x16(:,:,313))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(250),h0tab(:,250),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(101),m3h1x16(:,246),heltab2x16(:,:,314))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(251),h0tab(:,251),[16,6,9],[nMH,nMZ,nMH],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(102),m3h1x16(:,247),heltab2x16(:,:,315))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(252),h0tab(:,252),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(103),m3h1x16(:,248),heltab2x16(:,:,316))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(253),h0tab(:,253),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(104),m3h1x16(:,249),heltab2x16(:,:,317))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(254),h0tab(:,254),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(83),m3h1x16(:,250),heltab2x16(:,:,318))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(255),h0tab(:,255),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(84),m3h1x16(:,251),heltab2x16(:,:,319))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(256),h0tab(:,256),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(85),m3h1x16(:,252),heltab2x16(:,:,320))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(257),h0tab(:,257),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(86),m3h1x16(:,253),heltab2x16(:,:,321))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(258),h0tab(:,258),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(87),m3h1x16(:,254),heltab2x16(:,:,322))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(259),h0tab(:,259),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(88),m3h1x16(:,255),heltab2x16(:,:,323))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(260),h0tab(:,260),[16,6,9],[nMZ,nMH,nMZ],3,2,wf4(:,5),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(89),m3h1x16(:,256),heltab2x16(:,:,324))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(261),h0tab(:,261),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(90),m3h1x16(:,257),heltab2x16(:,:,325))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(262),h0tab(:,262),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(91),m3h1x16(:,258),heltab2x16(:,:,326))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(263),h0tab(:,263),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(92),m3h1x16(:,259),heltab2x16(:,:,327))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(264),h0tab(:,264),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(93),m3h1x16(:,260),heltab2x16(:,:,328))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(265),h0tab(:,265),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(94),m3h1x16(:,261),heltab2x16(:,:,329))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(266),h0tab(:,266),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(95),m3h1x16(:,262),heltab2x16(:,:,330))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(267),h0tab(:,267),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(96),m3h1x16(:,263),heltab2x16(:,:,331))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(268),h0tab(:,268),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(97),m3h1x16(:,264),heltab2x16(:,:,332))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(269),h0tab(:,269),[16,6,9],[nMZ,nMH,nMZ],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(98),m3h1x16(:,265),heltab2x16(:,:,333))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(270),h0tab(:,270),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(99),m3h1x16(:,266),heltab2x16(:,:,334))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(271),h0tab(:,271),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(100),m3h1x16(:,267),heltab2x16(:,:,335))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(272),h0tab(:,272),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(101),m3h1x16(:,268),heltab2x16(:,:,336))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(273),h0tab(:,273),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(102),m3h1x16(:,269),heltab2x16(:,:,337))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(274),h0tab(:,274),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(103),m3h1x16(:,270),heltab2x16(:,:,338))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(275),h0tab(:,275),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(104),m3h1x16(:,271),heltab2x16(:,:,339))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(276),h0tab(:,276),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(105),m3h1x16(:,272),heltab2x16(:,:,340))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(277),h0tab(:,277),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(106),m3h1x16(:,273),heltab2x16(:,:,341))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(278),h0tab(:,278),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(107),m3h1x16(:,274),heltab2x16(:,:,342))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(279),h0tab(:,279),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(19),0,ex5(:),16,G1H16(108),m3h1x16(:,275),heltab2x16(:,:,343))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(280),h0tab(:,280),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(109),m3h1x16(:,276),heltab2x16(:,:,344))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(281),h0tab(:,281),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(110),m3h1x16(:,277),heltab2x16(:,:,345))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(282),h0tab(:,282),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(111),m3h1x16(:,278),heltab2x16(:,:,346))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(283),h0tab(:,283),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(112),m3h1x16(:,279),heltab2x16(:,:,347))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(284),h0tab(:,284),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(113),m3h1x16(:,280),heltab2x16(:,:,348))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(285),h0tab(:,285),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(114),m3h1x16(:,281),heltab2x16(:,:,349))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(286),h0tab(:,286),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(115),m3h1x16(:,282),heltab2x16(:,:,350))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(287),h0tab(:,287),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(19),0,ex5(:),16,G1H16(116),m3h1x16(:,283),heltab2x16(:,:,351))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(288),h0tab(:,288),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(105),m3h1x16(:,284),heltab2x16(:,:,352))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(289),h0tab(:,289),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(106),m3h1x16(:,285),heltab2x16(:,:,353))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(290),h0tab(:,290),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(107),m3h1x16(:,286),heltab2x16(:,:,354))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(291),h0tab(:,291),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(108),m3h1x16(:,287),heltab2x16(:,:,355))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(292),h0tab(:,292),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(109),m3h1x16(:,288),heltab2x16(:,:,356))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(293),h0tab(:,293),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(110),m3h1x16(:,289),heltab2x16(:,:,357))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(294),h0tab(:,294),[16,6,9],[nMZ,nMH,nMZ],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(111),m3h1x16(:,290),heltab2x16(:,:,358))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(295),h0tab(:,295),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(112),m3h1x16(:,291),heltab2x16(:,:,359))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(296),h0tab(:,296),[16,6,9],[nMW,nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(113),m3h1x16(:,292),heltab2x16(:,:,360))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(297),h0tab(:,297),[16,7,8],[nMZ,0,nMZ],3,1,wf8(:,10))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(114),m3h1x16(:,293),heltab2x16(:,:,361))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(298),h0tab(:,298),[16,7,8],[nMW,0,nMW],3,1,wf8(:,10))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(115),m3h1x16(:,294),heltab2x16(:,:,362))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(299),h0tab(:,299),[16,7,8],[nMZ,0,nMZ],3,1,wf8(:,12))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(116),m3h1x16(:,295),heltab2x16(:,:,363))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(300),h0tab(:,300),[16,7,8],[nMW,0,nMW],3,1,wf8(:,12))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(117),m3h1x16(:,296),heltab2x16(:,:,364))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(301),h0tab(:,301),[16,1,14],[nMZ,0,nMZ],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(118),m3h1x16(:,297),heltab2x16(:,:,365))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(302),h0tab(:,302),[16,1,14],[nMW,0,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(119),m3h1x16(:,298),heltab2x16(:,:,366))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(303),h0tab(:,303),[16,1,14],[nMZ,0,nMZ],3,1,wf8(:,16))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(120),m3h1x16(:,299),heltab2x16(:,:,367))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(304),h0tab(:,304),[16,1,14],[nMW,0,nMW],3,1,wf8(:,16))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(121),m3h1x16(:,300),heltab2x16(:,:,368))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(305),h0tab(:,305),[22,1,8],[0,0,0],3,1,wf4(:,35))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,35),G0H4(1),ngZl,m3h4x4(:,13),heltab2x16(:,:,369))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(6),n2h4(4))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(306),h0tab(:,306),[22,1,8],[0,nMZ,0],3,1,wf4(:,35))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,35),G0H4(1),ngZl,m3h4x4(:,14),heltab2x16(:,:,370))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(5),n2h4(5))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(307),h0tab(:,307),[22,1,8],[0,nMW,0],3,1,wf4(:,35))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,35),G0H4(1),ngZn,m3h4x4(:,15),heltab2x16(:,:,371))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(4),n2h4(6))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(308),h0tab(:,308),[22,1,8],[nMW,0,nMW],3,1,wf4(:,35))
  call Hloop_UW_V(ntryL,G0H16(19),0,wf4(:,35),22,G1H4(8),m3h4x4(:,16),heltab2x16(:,:,372))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(309),h0tab(:,309),[16,4,11],[nMZ,0,nMZ],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(122),m3h1x16(:,301),heltab2x16(:,:,373))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(310),h0tab(:,310),[16,4,11],[nMW,0,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(123),m3h1x16(:,302),heltab2x16(:,:,374))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(311),h0tab(:,311),[16,4,11],[nMZ,0,nMZ],3,1,wf8(:,20))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(124),m3h1x16(:,303),heltab2x16(:,:,375))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(312),h0tab(:,312),[16,4,11],[nMW,0,nMW],3,1,wf8(:,20))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(125),m3h1x16(:,304),heltab2x16(:,:,376))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(313),h0tab(:,313),[16,2,13],[nMZ,0,nMZ],3,1,wf8(:,22))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(126),m3h1x16(:,305),heltab2x16(:,:,377))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(314),h0tab(:,314),[16,2,13],[nMW,0,nMW],3,1,wf8(:,22))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(127),m3h1x16(:,306),heltab2x16(:,:,378))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(315),h0tab(:,315),[16,2,13],[nMZ,0,nMZ],3,1,wf8(:,24))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(128),m3h1x16(:,307),heltab2x16(:,:,379))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(316),h0tab(:,316),[16,2,13],[nMW,0,nMW],3,1,wf8(:,24))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(129),m3h1x16(:,308),heltab2x16(:,:,380))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(317),h0tab(:,317),[25,2,4],[0,0,0],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,6),G0H4(1),ngZl,m3h4x4(:,17),heltab2x16(:,:,381))
  call Hloop_A_Q(ntryL,G0H4(1),25,0,G1H4(9),n2h4(7))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(318),h0tab(:,318),[25,2,4],[0,nMZ,0],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,6),G0H4(1),ngZl,m3h4x4(:,18),heltab2x16(:,:,382))
  call Hloop_A_Q(ntryL,G0H4(1),25,0,G1H4(10),n2h4(8))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(319),h0tab(:,319),[25,2,4],[0,nMW,0],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,6),G0H4(1),ngZn,m3h4x4(:,19),heltab2x16(:,:,383))
  call Hloop_A_Q(ntryL,G0H4(1),25,0,G1H4(11),n2h4(9))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(320),h0tab(:,320),[25,2,4],[nMW,0,nMW],3,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H16(19),0,wf4(:,6),25,G1H4(12),m3h4x4(:,20),heltab2x16(:,:,384))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(321),h0tab(:,321),[16,4,11],[nMZ,0,nMZ],3,1,wf8(:,26))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(130),m3h1x16(:,309),heltab2x16(:,:,385))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(322),h0tab(:,322),[16,4,11],[nMW,0,nMW],3,1,wf8(:,26))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(131),m3h1x16(:,310),heltab2x16(:,:,386))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(323),h0tab(:,323),[16,4,11],[nMZ,0,nMZ],3,1,wf8(:,28))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(132),m3h1x16(:,311),heltab2x16(:,:,387))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(324),h0tab(:,324),[16,4,11],[nMW,0,nMW],3,1,wf8(:,28))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(133),m3h1x16(:,312),heltab2x16(:,:,388))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(325),h0tab(:,325),[16,1,14],[nMZ,0,nMZ],3,1,wf8(:,30))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(134),m3h1x16(:,313),heltab2x16(:,:,389))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(326),h0tab(:,326),[16,1,14],[nMW,0,nMW],3,1,wf8(:,30))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(135),m3h1x16(:,314),heltab2x16(:,:,390))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(327),h0tab(:,327),[16,1,14],[nMZ,0,nMZ],3,1,wf8(:,32))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(136),m3h1x16(:,315),heltab2x16(:,:,391))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(328),h0tab(:,328),[16,1,14],[nMW,0,nMW],3,1,wf8(:,32))
  call Hloop_VS_V(ntryL,G0H16(19),ex5(:),G0H16(137),m3h1x16(:,316),heltab2x16(:,:,392))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(329),h0tab(:,329),[26,1,4],[0,0,0],3,1,wf4(:,24))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,24),G0H4(1),ngZl,m3h4x4(:,21),heltab2x16(:,:,393))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(13),n2h4(10))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(330),h0tab(:,330),[26,1,4],[0,nMZ,0],3,1,wf4(:,24))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,24),G0H4(1),ngZl,m3h4x4(:,22),heltab2x16(:,:,394))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(14),n2h4(11))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(331),h0tab(:,331),[26,1,4],[0,nMW,0],3,1,wf4(:,24))
  call Hloop_AZ_Q(ntryL,G0H16(19),wf4(:,24),G0H4(1),ngZn,m3h4x4(:,23),heltab2x16(:,:,395))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(15),n2h4(12))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(332),h0tab(:,332),[26,1,4],[nMW,0,nMW],3,1,wf4(:,24))
  call Hloop_UW_V(ntryL,G0H16(19),0,wf4(:,24),26,G1H4(16),m3h4x4(:,24),heltab2x16(:,:,396))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(11),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(8),[G0H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(28),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(6),[G0H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(2),[G0H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(21),[G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(17),[G0H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(22),[G0H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(37),[G0H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(39),[G0H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(41),[G0H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(44),[G0H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(46),[G0H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(48),[G0H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(50),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(53),[G0H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(74),[G0H16(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(75),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(78),[G0H16(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(79),[G0H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(82),[G0H16(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(83),[G0H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(86),[G0H16(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(87),[G0H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(97),[G0H16(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(99),[G0H16(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(101),[G0H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(104),[G0H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(106),[G0H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(108),[G0H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(110),[G0H16(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(113),[G0H16(112)])
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,7),G1H4(17),m3h4x4(:,25),heltab2x16(:,:,397))
  call Hloop_A_Q(ntryL,G1H4(17),21,nML,G2H4(1),n2h4(13))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,7),G1H4(18),m3h4x4(:,26),heltab2x16(:,:,398))
  call Hloop_Q_A(ntryL,G1H4(18),21,nML,G2H4(2),n2h4(14))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,7),G1H4(19),m3h4x4(:,27),heltab2x16(:,:,399))
  call Hloop_A_Q(ntryL,G1H4(19),21,nMT,G2H4(3),n2h4(15))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,7),G1H4(20),m3h4x4(:,28),heltab2x16(:,:,400))
  call Hloop_Q_A(ntryL,G1H4(20),21,nMT,G2H4(4),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,7),G1H4(17),m3h4x4(:,29),heltab2x16(:,:,401))
  call Hloop_A_Q(ntryL,G1H4(17),21,nMB,G2H4(5),n2h4(17))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,7),G1H4(18),m3h4x4(:,30),heltab2x16(:,:,402))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMB,G2H4(6),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,7),G1H4(19),m3h4x4(:,31),heltab2x16(:,:,403))
  call Hloop_A_Q(ntryL,G1H4(19),21,nML,G2H4(7),n2h4(19))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,7),G1H4(20),m3h4x4(:,32),heltab2x16(:,:,404))
  call Hloop_Q_A(ntryL,G1H4(20),21,nML,G2H4(8),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,7),G1H4(17),m3h4x4(:,33),heltab2x16(:,:,405))
  call Hloop_A_Q(ntryL,G1H4(17),21,nMT,G2H4(9),n2h4(21))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,7),G1H4(18),m3h4x4(:,34),heltab2x16(:,:,406))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMT,G2H4(10),n2h4(22))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,7),G1H4(19),m3h4x4(:,35),heltab2x16(:,:,407))
  call Hloop_A_Q(ntryL,G1H4(19),21,nMB,G2H4(11),n2h4(23))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,7),G1H4(20),m3h4x4(:,36),heltab2x16(:,:,408))
  call Hloop_Q_A(ntryL,G1H4(20),21,nMB,G2H4(12),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,1),G1H4(17),ngZl,m3h4x4(:,37),heltab2x16(:,:,409))
  call Hloop_A_Q(ntryL,G1H4(17),21,nML,G2H4(13),n2h4(25))
  call Hloop_QZ_A(ntryL,G1H16(14),wf4(:,1),G1H4(18),ngZl,m3h4x4(:,38),heltab2x16(:,:,410))
  call Hloop_Q_A(ntryL,G1H4(18),21,nML,G2H4(14),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,1),G1H4(19),ngZu,m3h4x4(:,39),heltab2x16(:,:,411))
  call Hloop_A_Q(ntryL,G1H4(19),21,nMT,G2H4(15),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,1),G1H4(20),ngZu,m3h4x4(:,40),heltab2x16(:,:,412))
  call Hloop_Q_A(ntryL,G1H4(20),21,nMT,G2H4(16),n2h4(28))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,1),G1H4(17),ngZd,m3h4x4(:,41),heltab2x16(:,:,413))
  call Hloop_A_Q(ntryL,G1H4(17),21,nMB,G2H4(17),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,1),G1H4(18),ngZd,m3h4x4(:,42),heltab2x16(:,:,414))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMB,G2H4(18),n2h4(30))
  call Hloop_AZ_Q(ntryL,G1H16(19),wf4(:,1),G1H4(19),ngZl,m3h4x4(:,43),heltab2x16(:,:,415))
  call Hloop_A_Q(ntryL,G1H4(19),21,nML,G2H4(19),n2h4(31))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,1),G1H4(20),ngZl,m3h4x4(:,44),heltab2x16(:,:,416))
  call Hloop_Q_A(ntryL,G1H4(20),21,nML,G2H4(20),n2h4(32))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,1),G1H4(17),ngZu,m3h4x4(:,45),heltab2x16(:,:,417))
  call Hloop_A_Q(ntryL,G1H4(17),21,nMT,G2H4(21),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(22),wf4(:,1),G1H4(18),ngZu,m3h4x4(:,46),heltab2x16(:,:,418))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMT,G2H4(22),n2h4(34))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,1),G1H4(19),ngZd,m3h4x4(:,47),heltab2x16(:,:,419))
  call Hloop_A_Q(ntryL,G1H4(19),21,nMB,G2H4(23),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,1),G1H4(20),ngZd,m3h4x4(:,48),heltab2x16(:,:,420))
  call Hloop_Q_A(ntryL,G1H4(20),21,nMB,G2H4(24),n2h4(36))
  call Hloop_SV_T(ntryL,G0H16(5),16,wf4(:,7),5,G1H4(17),m3h4x4(:,49),heltab2x16(:,:,421))
  call Hloop_TV_S(ntryL,G0H16(23),16,wf4(:,7),5,G1H4(18),m3h4x4(:,50),heltab2x16(:,:,422))
  call Hloop_SV_T(ntryL,G0H16(25),16,wf4(:,7),5,G1H4(19),m3h4x4(:,51),heltab2x16(:,:,423))
  call Hloop_TV_S(ntryL,G0H16(27),16,wf4(:,7),5,G1H4(20),m3h4x4(:,52),heltab2x16(:,:,424))
  call Hloop_SV_T(ntryL,G0H16(29),16,wf4(:,1),5,G1H4(21),m3h4x4(:,53),heltab2x16(:,:,425))
  call Hloop_TV_S(ntryL,G0H16(4),16,wf4(:,1),5,G1H4(22),m3h4x4(:,54),heltab2x16(:,:,426))
  call Hloop_TV_S(ntryL,G0H16(10),16,wf4(:,1),5,G1H4(23),m3h4x4(:,55),heltab2x16(:,:,427))
  call Hloop_SV_T(ntryL,G0H16(14),16,wf4(:,1),5,G1H4(24),m3h4x4(:,56),heltab2x16(:,:,428))
  call Hloop_SV_T(ntryL,G0H16(18),16,wf4(:,1),5,G1H4(25),m3h4x4(:,57),heltab2x16(:,:,429))
  call Hloop_TV_S(ntryL,G0H16(3),16,wf4(:,1),5,G1H4(26),m3h4x4(:,58),heltab2x16(:,:,430))
  call Hloop_DV_C(ntryL,G0H16(11),16,wf4(:,7),G1H4(27),m3h4x4(:,59),heltab2x16(:,:,431))
  call Hloop_CV_D(ntryL,G0H16(8),16,wf4(:,7),5,G1H4(28),m3h4x4(:,60),heltab2x16(:,:,432))
  call Hloop_DV_C(ntryL,G0H16(28),16,wf4(:,7),G1H4(29),m3h4x4(:,61),heltab2x16(:,:,433))
  call Hloop_CV_D(ntryL,G0H16(6),16,wf4(:,7),5,G1H4(30),m3h4x4(:,62),heltab2x16(:,:,434))
  call Hloop_DV_C(ntryL,G0H16(2),16,wf4(:,1),G1H4(31),m3h4x4(:,63),heltab2x16(:,:,435))
  call Hloop_CV_D(ntryL,G0H16(21),16,wf4(:,1),5,G1H4(32),m3h4x4(:,64),heltab2x16(:,:,436))
  call Hloop_DV_C(ntryL,G0H16(17),16,wf4(:,1),G1H4(33),m3h4x4(:,65),heltab2x16(:,:,437))
  call Hloop_CV_D(ntryL,G0H16(22),16,wf4(:,1),5,G1H4(34),m3h4x4(:,66),heltab2x16(:,:,438))
  call Hloop_UW_V(ntryL,G0H16(1),16,wf4(:,7),5,G1H4(35),m3h4x4(:,67),heltab2x16(:,:,439))
  call Hloop_UV_W(ntryL,G0H16(15),16,wf4(:,7),5,G1H4(36),m3h4x4(:,68),heltab2x16(:,:,440))
  call Hloop_UW_V(ntryL,G0H16(30),16,wf4(:,7),5,G1H4(37),m3h4x4(:,69),heltab2x16(:,:,441))
  call Hloop_UV_W(ntryL,G0H16(31),16,wf4(:,7),5,G1H4(38),m3h4x4(:,70),heltab2x16(:,:,442))
  call Hloop_UW_V(ntryL,G0H16(32),16,wf4(:,1),5,G1H4(39),m3h4x4(:,71),heltab2x16(:,:,443))
  call Hloop_UV_W(ntryL,G0H16(33),16,wf4(:,1),5,G1H4(40),m3h4x4(:,72),heltab2x16(:,:,444))
  call Hloop_UW_V(ntryL,G0H16(34),16,wf4(:,1),5,G1H4(41),m3h4x4(:,73),heltab2x16(:,:,445))
  call Hloop_UV_W(ntryL,G0H16(35),16,wf4(:,1),5,G1H4(42),m3h4x4(:,74),heltab2x16(:,:,446))
  call Hloop_SV_V(ntryL,G0H16(37),wf4(:,7),G0H4(1),m3h4x4(:,75),heltab2x16(:,:,447))
  call Hloop_SV_V(ntryL,G0H16(39),wf4(:,7),G0H4(2),m3h4x4(:,76),heltab2x16(:,:,448))
  call Hloop_SV_V(ntryL,G0H16(41),wf4(:,1),G0H4(3),m3h4x4(:,77),heltab2x16(:,:,449))
  call Hloop_SV_V(ntryL,G0H16(42),wf4(:,1),G0H4(4),m3h4x4(:,78),heltab2x16(:,:,450))
  call Hloop_SV_V(ntryL,G0H16(44),wf4(:,1),G0H4(5),m3h4x4(:,79),heltab2x16(:,:,451))
  call Hloop_SV_T(ntryL,G1H16(25),16,wf4(:,7),5,G2H4(25),m3h4x4(:,80),heltab2x16(:,:,452))
  call Hloop_TV_S(ntryL,G1H16(26),16,wf4(:,7),5,G2H4(26),m3h4x4(:,81),heltab2x16(:,:,453))
  call Hloop_SV_T(ntryL,G1H16(27),16,wf4(:,7),5,G2H4(27),m3h4x4(:,82),heltab2x16(:,:,454))
  call Hloop_TV_S(ntryL,G1H16(28),16,wf4(:,7),5,G2H4(28),m3h4x4(:,83),heltab2x16(:,:,455))
  call Hloop_SV_T(ntryL,G1H16(29),16,wf4(:,1),5,G2H4(29),m3h4x4(:,84),heltab2x16(:,:,456))
  call Hloop_TV_S(ntryL,G1H16(30),16,wf4(:,1),5,G2H4(30),m3h4x4(:,85),heltab2x16(:,:,457))
  call Hloop_SV_T(ntryL,G1H16(31),16,wf4(:,1),5,G2H4(31),m3h4x4(:,86),heltab2x16(:,:,458))
  call Hloop_SV_T(ntryL,G1H16(32),16,wf4(:,1),5,G2H4(32),m3h4x4(:,87),heltab2x16(:,:,459))
  call Hloop_TV_S(ntryL,G1H16(33),16,wf4(:,1),5,G2H4(33),m3h4x4(:,88),heltab2x16(:,:,460))
  call Hloop_VV_S(ntryL,G1H16(34),wf4(:,7),G1H4(43),m3h4x4(:,89),heltab2x16(:,:,461))
  call Hloop_VV_S(ntryL,G1H16(35),wf4(:,7),G1H4(44),m3h4x4(:,90),heltab2x16(:,:,462))
  call Hloop_VV_S(ntryL,G1H16(36),wf4(:,7),G1H4(45),m3h4x4(:,91),heltab2x16(:,:,463))
  call Hloop_VV_S(ntryL,G1H16(37),wf4(:,7),G1H4(46),m3h4x4(:,92),heltab2x16(:,:,464))
  call Hloop_VV_S(ntryL,G1H16(38),wf4(:,1),G1H4(47),m3h4x4(:,93),heltab2x16(:,:,465))
  call Hloop_VV_S(ntryL,G1H16(39),wf4(:,1),G1H4(48),m3h4x4(:,94),heltab2x16(:,:,466))
  call Hloop_VV_S(ntryL,G1H16(40),wf4(:,1),G1H4(49),m3h4x4(:,95),heltab2x16(:,:,467))
  call Hloop_VV_S(ntryL,G1H16(41),wf4(:,1),G1H4(50),m3h4x4(:,96),heltab2x16(:,:,468))
  call Hloop_VV_S(ntryL,G1H16(42),wf4(:,1),G1H4(51),m3h4x4(:,97),heltab2x16(:,:,469))
  call Hloop_SV_V(ntryL,G1H16(43),wf4(:,7),G1H4(52),m3h4x4(:,98),heltab2x16(:,:,470))
  call Hloop_SV_V(ntryL,G1H16(44),wf4(:,7),G1H4(53),m3h4x4(:,99),heltab2x16(:,:,471))
  call Hloop_SV_V(ntryL,G1H16(45),wf4(:,7),G1H4(54),m3h4x4(:,100),heltab2x16(:,:,472))
  call Hloop_SV_V(ntryL,G1H16(46),wf4(:,7),G1H4(55),m3h4x4(:,101),heltab2x16(:,:,473))
  call Hloop_SV_V(ntryL,G1H16(47),wf4(:,1),G1H4(56),m3h4x4(:,102),heltab2x16(:,:,474))
  call Hloop_SV_V(ntryL,G1H16(48),wf4(:,1),G1H4(57),m3h4x4(:,103),heltab2x16(:,:,475))
  call Hloop_SV_V(ntryL,G1H16(49),wf4(:,1),G1H4(58),m3h4x4(:,104),heltab2x16(:,:,476))
  call Hloop_SV_V(ntryL,G1H16(50),wf4(:,1),G1H4(59),m3h4x4(:,105),heltab2x16(:,:,477))
  call Hloop_UW_V(ntryL,G1H16(51),16,wf4(:,7),5,G2H4(34),m3h4x4(:,106),heltab2x16(:,:,478))
  call Hloop_UV_W(ntryL,G1H16(52),16,wf4(:,7),5,G2H4(35),m3h4x4(:,107),heltab2x16(:,:,479))
  call Hloop_UW_V(ntryL,G1H16(53),16,wf4(:,7),5,G2H4(36),m3h4x4(:,108),heltab2x16(:,:,480))
  call Hloop_UV_W(ntryL,G1H16(54),16,wf4(:,7),5,G2H4(37),m3h4x4(:,109),heltab2x16(:,:,481))
  call Hloop_UW_V(ntryL,G1H16(55),16,wf4(:,1),5,G2H4(38),m3h4x4(:,110),heltab2x16(:,:,482))
  call Hloop_UV_W(ntryL,G1H16(56),16,wf4(:,1),5,G2H4(39),m3h4x4(:,111),heltab2x16(:,:,483))
  call Hloop_UW_V(ntryL,G1H16(57),16,wf4(:,1),5,G2H4(40),m3h4x4(:,112),heltab2x16(:,:,484))
  call Hloop_UV_W(ntryL,G1H16(58),16,wf4(:,1),5,G2H4(41),m3h4x4(:,113),heltab2x16(:,:,485))
  call Hloop_VV_S(ntryL,G0H16(46),wf4(:,7),G0H4(6),m3h4x4(:,114),heltab2x16(:,:,486))
  call Hloop_VV_S(ntryL,G0H16(48),wf4(:,7),G0H4(7),m3h4x4(:,115),heltab2x16(:,:,487))
  call Hloop_VV_S(ntryL,G0H16(50),wf4(:,1),G0H4(8),m3h4x4(:,116),heltab2x16(:,:,488))
  call Hloop_VV_S(ntryL,G0H16(51),wf4(:,1),G0H4(9),m3h4x4(:,117),heltab2x16(:,:,489))
  call Hloop_VV_S(ntryL,G0H16(53),wf4(:,1),G0H4(10),m3h4x4(:,118),heltab2x16(:,:,490))
  call Hloop_ZQ_A(ntryL,G0H16(54),wf8(:,2),G0H2(1),ngZl,m3h8x2(:,1),heltab2x16(:,:,491))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(1),n2h2(35))
  call Hloop_WQ_A(ntryL,G0H16(55),wf8(:,2),G0H2(1),m3h8x2(:,2),heltab2x16(:,:,492))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(2),n2h2(36))
  call Hloop_ZQ_A(ntryL,G0H16(56),wf8(:,4),G0H2(1),ngZl,m3h8x2(:,3),heltab2x16(:,:,493))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(3),n2h2(37))
  call Hloop_WQ_A(ntryL,G0H16(57),wf8(:,4),G0H2(1),m3h8x2(:,4),heltab2x16(:,:,494))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(4),n2h2(38))
  call Hloop_ZQ_A(ntryL,G0H16(58),ex2(:),G0H8(1),ngZl,m3h2x8(:,57),heltab2x16(:,:,495))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(3),n2h8(57))
  call Hloop_WQ_A(ntryL,G0H16(59),ex2(:),G0H8(1),m3h2x8(:,58),heltab2x16(:,:,496))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(4),n2h8(58))
  call Hloop_ZQ_A(ntryL,G0H16(60),ex2(:),G0H8(1),ngZl,m3h2x8(:,59),heltab2x16(:,:,497))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(5),n2h8(59))
  call Hloop_WQ_A(ntryL,G0H16(61),ex2(:),G0H8(1),m3h2x8(:,60),heltab2x16(:,:,498))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(6),n2h8(60))
  call Hloop_AQ_V(ntryL,G1H4(3),ex2(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex2(:),G1H2(6),ngZl,m3h2x2(:,24),heltab2x4(:,:,48))
  call Hloop_AQ_W(ntryL,G1H4(1),ex2(:),G1H2(7),m3h2x2(:,25),heltab2x4(:,:,49))
  call Hloop_WQ_A(ntryL,G1H4(7),ex2(:),G1H2(8),m3h2x2(:,26),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(8),23,0,G2H2(15),n2h2(39))
  call Hloop_QV_A(ntryL,G1H16(59),wf4(:,12),G1H4(3),m3h4x4(:,119),heltab2x16(:,:,499))
  call Hloop_Q_A(ntryL,G1H4(3),22,nML,G2H4(42),n2h4(37))
  call Hloop_AV_Q(ntryL,G1H16(60),wf4(:,12),G1H4(2),m3h4x4(:,120),heltab2x16(:,:,500))
  call Hloop_A_Q(ntryL,G1H4(2),22,nML,G2H4(43),n2h4(38))
  call Hloop_QV_A(ntryL,G1H16(61),wf4(:,12),G1H4(1),m3h4x4(:,121),heltab2x16(:,:,501))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(44),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H16(62),wf4(:,12),G1H4(7),m3h4x4(:,122),heltab2x16(:,:,502))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMT,G2H4(45),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(63),wf4(:,12),G1H4(3),m3h4x4(:,123),heltab2x16(:,:,503))
  call Hloop_Q_A(ntryL,G1H4(3),22,nMB,G2H4(46),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H16(64),wf4(:,12),G1H4(2),m3h4x4(:,124),heltab2x16(:,:,504))
  call Hloop_A_Q(ntryL,G1H4(2),22,nMB,G2H4(47),n2h4(42))
  call Hloop_QZ_A(ntryL,G1H16(65),wf4(:,5),G1H4(1),ngZl,m3h4x4(:,125),heltab2x16(:,:,505))
  call Hloop_Q_A(ntryL,G1H4(1),22,nML,G2H4(48),n2h4(43))
  call Hloop_AZ_Q(ntryL,G1H16(66),wf4(:,5),G1H4(7),ngZl,m3h4x4(:,126),heltab2x16(:,:,506))
  call Hloop_A_Q(ntryL,G1H4(7),22,nML,G2H4(49),n2h4(44))
  call Hloop_QZ_A(ntryL,G1H16(67),wf4(:,5),G1H4(3),ngZu,m3h4x4(:,127),heltab2x16(:,:,507))
  call Hloop_Q_A(ntryL,G1H4(3),22,nMT,G2H4(50),n2h4(45))
  call Hloop_AZ_Q(ntryL,G1H16(68),wf4(:,5),G1H4(2),ngZu,m3h4x4(:,128),heltab2x16(:,:,508))
  call Hloop_A_Q(ntryL,G1H4(2),22,nMT,G2H4(51),n2h4(46))
  call Hloop_QZ_A(ntryL,G1H16(69),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,129),heltab2x16(:,:,509))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(52),n2h4(47))
  call Hloop_AZ_Q(ntryL,G1H16(70),wf4(:,5),G1H4(7),ngZd,m3h4x4(:,130),heltab2x16(:,:,510))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMB,G2H4(53),n2h4(48))
  call Hloop_QV_A(ntryL,G1H16(71),wf4(:,12),G1H4(3),m3h4x4(:,131),heltab2x16(:,:,511))
  call Hloop_Q_A(ntryL,G1H4(3),22,nML,G2H4(54),n2h4(49))
  call Hloop_AV_Q(ntryL,G1H16(72),wf4(:,12),G1H4(2),m3h4x4(:,132),heltab2x16(:,:,512))
  call Hloop_A_Q(ntryL,G1H4(2),22,nML,G2H4(55),n2h4(50))
  call Hloop_QV_A(ntryL,G1H16(73),wf4(:,12),G1H4(1),m3h4x4(:,133),heltab2x16(:,:,513))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(56),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H16(74),wf4(:,12),G1H4(7),m3h4x4(:,134),heltab2x16(:,:,514))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMT,G2H4(57),n2h4(52))
  call Hloop_QV_A(ntryL,G1H16(75),wf4(:,12),G1H4(3),m3h4x4(:,135),heltab2x16(:,:,515))
  call Hloop_Q_A(ntryL,G1H4(3),22,nMB,G2H4(58),n2h4(53))
  call Hloop_AV_Q(ntryL,G1H16(76),wf4(:,12),G1H4(2),m3h4x4(:,136),heltab2x16(:,:,516))
  call Hloop_A_Q(ntryL,G1H4(2),22,nMB,G2H4(59),n2h4(54))
  call Hloop_QZ_A(ntryL,G1H16(77),wf4(:,5),G1H4(1),ngZl,m3h4x4(:,137),heltab2x16(:,:,517))
  call Hloop_Q_A(ntryL,G1H4(1),22,nML,G2H4(60),n2h4(55))
  call Hloop_AZ_Q(ntryL,G1H16(78),wf4(:,5),G1H4(7),ngZl,m3h4x4(:,138),heltab2x16(:,:,518))
  call Hloop_A_Q(ntryL,G1H4(7),22,nML,G2H4(61),n2h4(56))
  call Hloop_QZ_A(ntryL,G1H16(79),wf4(:,5),G1H4(3),ngZu,m3h4x4(:,139),heltab2x16(:,:,519))
  call Hloop_Q_A(ntryL,G1H4(3),22,nMT,G2H4(62),n2h4(57))
  call Hloop_AZ_Q(ntryL,G1H16(80),wf4(:,5),G1H4(2),ngZu,m3h4x4(:,140),heltab2x16(:,:,520))
  call Hloop_A_Q(ntryL,G1H4(2),22,nMT,G2H4(63),n2h4(58))
  call Hloop_QZ_A(ntryL,G1H16(81),wf4(:,5),G1H4(1),ngZd,m3h4x4(:,141),heltab2x16(:,:,521))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(64),n2h4(59))
  call Hloop_AZ_Q(ntryL,G1H16(82),wf4(:,5),G1H4(7),ngZd,m3h4x4(:,142),heltab2x16(:,:,522))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMB,G2H4(65),n2h4(60))
  call Hloop_TV_S(ntryL,G0H16(62),16,wf4(:,12),6,G1H4(3),m3h4x4(:,143),heltab2x16(:,:,523))
  call Hloop_SV_T(ntryL,G0H16(63),16,wf4(:,12),6,G1H4(2),m3h4x4(:,144),heltab2x16(:,:,524))
  call Hloop_TV_S(ntryL,G0H16(64),16,wf4(:,5),6,G1H4(1),m3h4x4(:,145),heltab2x16(:,:,525))
  call Hloop_SV_T(ntryL,G0H16(65),16,wf4(:,5),6,G1H4(7),m3h4x4(:,146),heltab2x16(:,:,526))
  call Hloop_TV_S(ntryL,G0H16(66),16,wf4(:,12),6,G1H4(60),m3h4x4(:,147),heltab2x16(:,:,527))
  call Hloop_SV_T(ntryL,G0H16(67),16,wf4(:,12),6,G1H4(61),m3h4x4(:,148),heltab2x16(:,:,528))
  call Hloop_TV_S(ntryL,G0H16(68),16,wf4(:,5),6,G1H4(62),m3h4x4(:,149),heltab2x16(:,:,529))
  call Hloop_SV_T(ntryL,G0H16(69),16,wf4(:,5),6,G1H4(63),m3h4x4(:,150),heltab2x16(:,:,530))
  call Hloop_TV_S(ntryL,G0H16(70),16,wf4(:,5),6,G1H4(64),m3h4x4(:,151),heltab2x16(:,:,531))
  call Hloop_SV_T(ntryL,G0H16(71),16,wf4(:,5),6,G1H4(65),m3h4x4(:,152),heltab2x16(:,:,532))
  call Hloop_CV_D(ntryL,G0H16(74),16,wf4(:,12),6,G1H4(66),m3h4x4(:,153),heltab2x16(:,:,533))
  call Hloop_DV_C(ntryL,G0H16(75),16,wf4(:,12),G1H4(67),m3h4x4(:,154),heltab2x16(:,:,534))
  call Hloop_CV_D(ntryL,G0H16(78),16,wf4(:,5),6,G1H4(68),m3h4x4(:,155),heltab2x16(:,:,535))
  call Hloop_DV_C(ntryL,G0H16(79),16,wf4(:,5),G1H4(69),m3h4x4(:,156),heltab2x16(:,:,536))
  call Hloop_CV_D(ntryL,G0H16(82),16,wf4(:,12),6,G1H4(70),m3h4x4(:,157),heltab2x16(:,:,537))
  call Hloop_DV_C(ntryL,G0H16(83),16,wf4(:,12),G1H4(71),m3h4x4(:,158),heltab2x16(:,:,538))
  call Hloop_CV_D(ntryL,G0H16(86),16,wf4(:,5),6,G1H4(72),m3h4x4(:,159),heltab2x16(:,:,539))
  call Hloop_DV_C(ntryL,G0H16(87),16,wf4(:,5),G1H4(73),m3h4x4(:,160),heltab2x16(:,:,540))
  call Hloop_UV_W(ntryL,G0H16(88),16,wf4(:,12),6,G1H4(74),m3h4x4(:,161),heltab2x16(:,:,541))
  call Hloop_UW_V(ntryL,G0H16(89),16,wf4(:,12),6,G1H4(75),m3h4x4(:,162),heltab2x16(:,:,542))
  call Hloop_UV_W(ntryL,G0H16(90),16,wf4(:,5),6,G1H4(76),m3h4x4(:,163),heltab2x16(:,:,543))
  call Hloop_UW_V(ntryL,G0H16(91),16,wf4(:,5),6,G1H4(77),m3h4x4(:,164),heltab2x16(:,:,544))
  call Hloop_UV_W(ntryL,G0H16(92),16,wf4(:,12),6,G1H4(78),m3h4x4(:,165),heltab2x16(:,:,545))
  call Hloop_UW_V(ntryL,G0H16(93),16,wf4(:,12),6,G1H4(79),m3h4x4(:,166),heltab2x16(:,:,546))
  call Hloop_UV_W(ntryL,G0H16(94),16,wf4(:,5),6,G1H4(80),m3h4x4(:,167),heltab2x16(:,:,547))
  call Hloop_UW_V(ntryL,G0H16(95),16,wf4(:,5),6,G1H4(81),m3h4x4(:,168),heltab2x16(:,:,548))
  call Hloop_SV_V(ntryL,G0H16(97),wf4(:,12),G0H4(11),m3h4x4(:,169),heltab2x16(:,:,549))
  call Hloop_SV_V(ntryL,G0H16(99),wf4(:,5),G0H4(12),m3h4x4(:,170),heltab2x16(:,:,550))
  call Hloop_SV_V(ntryL,G0H16(101),wf4(:,12),G0H4(13),m3h4x4(:,171),heltab2x16(:,:,551))
  call Hloop_SV_V(ntryL,G0H16(102),wf4(:,5),G0H4(14),m3h4x4(:,172),heltab2x16(:,:,552))
  call Hloop_SV_V(ntryL,G0H16(104),wf4(:,5),G0H4(15),m3h4x4(:,173),heltab2x16(:,:,553))
  call Hloop_VV_S(ntryL,G1H16(83),wf4(:,12),G1H4(82),m3h4x4(:,174),heltab2x16(:,:,554))
  call Hloop_VV_S(ntryL,G1H16(84),wf4(:,12),G1H4(83),m3h4x4(:,175),heltab2x16(:,:,555))
  call Hloop_VV_S(ntryL,G1H16(85),wf4(:,5),G1H4(84),m3h4x4(:,176),heltab2x16(:,:,556))
  call Hloop_VV_S(ntryL,G1H16(86),wf4(:,5),G1H4(85),m3h4x4(:,177),heltab2x16(:,:,557))
  call Hloop_VV_S(ntryL,G1H16(87),wf4(:,12),G1H4(86),m3h4x4(:,178),heltab2x16(:,:,558))
  call Hloop_VV_S(ntryL,G1H16(88),wf4(:,12),G1H4(87),m3h4x4(:,179),heltab2x16(:,:,559))
  call Hloop_VV_S(ntryL,G1H16(89),wf4(:,5),G1H4(88),m3h4x4(:,180),heltab2x16(:,:,560))
  call Hloop_VV_S(ntryL,G1H16(90),wf4(:,5),G1H4(89),m3h4x4(:,181),heltab2x16(:,:,561))
  call Hloop_VV_S(ntryL,G1H16(91),wf4(:,5),G1H4(90),m3h4x4(:,182),heltab2x16(:,:,562))
  call Hloop_TV_S(ntryL,G1H16(92),16,wf4(:,12),6,G2H4(66),m3h4x4(:,183),heltab2x16(:,:,563))
  call Hloop_SV_T(ntryL,G1H16(93),16,wf4(:,12),6,G2H4(67),m3h4x4(:,184),heltab2x16(:,:,564))
  call Hloop_TV_S(ntryL,G1H16(94),16,wf4(:,5),6,G2H4(68),m3h4x4(:,185),heltab2x16(:,:,565))
  call Hloop_SV_T(ntryL,G1H16(95),16,wf4(:,5),6,G2H4(69),m3h4x4(:,186),heltab2x16(:,:,566))
  call Hloop_TV_S(ntryL,G1H16(96),16,wf4(:,12),6,G2H4(70),m3h4x4(:,187),heltab2x16(:,:,567))
  call Hloop_SV_T(ntryL,G1H16(97),16,wf4(:,12),6,G2H4(71),m3h4x4(:,188),heltab2x16(:,:,568))
  call Hloop_SV_T(ntryL,G1H16(98),16,wf4(:,5),6,G2H4(72),m3h4x4(:,189),heltab2x16(:,:,569))
  call Hloop_TV_S(ntryL,G1H16(99),16,wf4(:,5),6,G2H4(73),m3h4x4(:,190),heltab2x16(:,:,570))
  call Hloop_SV_T(ntryL,G1H16(100),16,wf4(:,5),6,G2H4(74),m3h4x4(:,191),heltab2x16(:,:,571))
  call Hloop_UV_W(ntryL,G1H16(101),16,wf4(:,12),6,G2H4(75),m3h4x4(:,192),heltab2x16(:,:,572))
  call Hloop_UW_V(ntryL,G1H16(102),16,wf4(:,12),6,G2H4(76),m3h4x4(:,193),heltab2x16(:,:,573))
  call Hloop_UV_W(ntryL,G1H16(103),16,wf4(:,5),6,G2H4(77),m3h4x4(:,194),heltab2x16(:,:,574))
  call Hloop_UW_V(ntryL,G1H16(104),16,wf4(:,5),6,G2H4(78),m3h4x4(:,195),heltab2x16(:,:,575))
  call Hloop_UV_W(ntryL,G1H16(105),16,wf4(:,12),6,G2H4(79),m3h4x4(:,196),heltab2x16(:,:,576))
  call Hloop_UW_V(ntryL,G1H16(106),16,wf4(:,12),6,G2H4(80),m3h4x4(:,197),heltab2x16(:,:,577))
  call Hloop_UV_W(ntryL,G1H16(107),16,wf4(:,5),6,G2H4(81),m3h4x4(:,198),heltab2x16(:,:,578))
  call Hloop_UW_V(ntryL,G1H16(108),16,wf4(:,5),6,G2H4(82),m3h4x4(:,199),heltab2x16(:,:,579))
  call Hloop_SV_V(ntryL,G1H16(109),wf4(:,12),G1H4(91),m3h4x4(:,200),heltab2x16(:,:,580))
  call Hloop_SV_V(ntryL,G1H16(110),wf4(:,12),G1H4(92),m3h4x4(:,201),heltab2x16(:,:,581))
  call Hloop_SV_V(ntryL,G1H16(111),wf4(:,5),G1H4(93),m3h4x4(:,202),heltab2x16(:,:,582))
  call Hloop_SV_V(ntryL,G1H16(112),wf4(:,5),G1H4(94),m3h4x4(:,203),heltab2x16(:,:,583))
  call Hloop_SV_V(ntryL,G1H16(113),wf4(:,12),G1H4(95),m3h4x4(:,204),heltab2x16(:,:,584))
  call Hloop_SV_V(ntryL,G1H16(114),wf4(:,12),G1H4(96),m3h4x4(:,205),heltab2x16(:,:,585))
  call Hloop_SV_V(ntryL,G1H16(115),wf4(:,5),G1H4(97),m3h4x4(:,206),heltab2x16(:,:,586))
  call Hloop_SV_V(ntryL,G1H16(116),wf4(:,5),G1H4(98),m3h4x4(:,207),heltab2x16(:,:,587))
  call Hloop_VV_S(ntryL,G0H16(106),wf4(:,12),G0H4(16),m3h4x4(:,208),heltab2x16(:,:,588))
  call Hloop_VV_S(ntryL,G0H16(108),wf4(:,5),G0H4(17),m3h4x4(:,209),heltab2x16(:,:,589))
  call Hloop_VV_S(ntryL,G0H16(110),wf4(:,12),G0H4(18),m3h4x4(:,210),heltab2x16(:,:,590))
  call Hloop_VV_S(ntryL,G0H16(111),wf4(:,5),G0H4(19),m3h4x4(:,211),heltab2x16(:,:,591))
  call Hloop_VV_S(ntryL,G0H16(113),wf4(:,5),G0H4(20),m3h4x4(:,212),heltab2x16(:,:,592))
  call Hloop_ZQ_A(ntryL,G0H16(114),wf8(:,10),G0H2(1),ngZl,m3h8x2(:,5),heltab2x16(:,:,593))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(8),n2h2(40))
  call Hloop_WQ_A(ntryL,G0H16(115),wf8(:,10),G0H2(1),m3h8x2(:,6),heltab2x16(:,:,594))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(9),n2h2(41))
  call Hloop_ZQ_A(ntryL,G0H16(116),wf8(:,12),G0H2(1),ngZl,m3h8x2(:,7),heltab2x16(:,:,595))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(10),n2h2(42))
  call Hloop_WQ_A(ntryL,G0H16(117),wf8(:,12),G0H2(1),m3h8x2(:,8),heltab2x16(:,:,596))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(11),n2h2(43))
  call Hloop_ZQ_A(ntryL,G0H16(118),ex1(:),G0H8(1),ngZl,m3h2x8(:,61),heltab2x16(:,:,597))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(7),n2h8(61))
  call Hloop_WQ_A(ntryL,G0H16(119),ex1(:),G0H8(1),m3h2x8(:,62),heltab2x16(:,:,598))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(10),n2h8(62))
  call Hloop_ZQ_A(ntryL,G0H16(120),ex1(:),G0H8(1),ngZl,m3h2x8(:,63),heltab2x16(:,:,599))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(11),n2h8(63))
  call Hloop_WQ_A(ntryL,G0H16(121),ex1(:),G0H8(1),m3h2x8(:,64),heltab2x16(:,:,600))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(12),n2h8(64))
  call Hloop_AQ_V(ntryL,G1H4(6),ex1(:),G1H2(12),m3h2x2(:,27),heltab2x4(:,:,51))
  call Hloop_AQ_Z(ntryL,G1H4(5),ex1(:),G1H2(13),ngZl,m3h2x2(:,28),heltab2x4(:,:,52))
  call Hloop_AQ_W(ntryL,G1H4(4),ex1(:),G1H2(14),m3h2x2(:,29),heltab2x4(:,:,53))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(15),m3h2x2(:,30),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(15),23,0,G2H2(16),n2h2(44))
  call Hloop_ZA_Q(ntryL,G0H16(122),ex3(:),G0H8(1),ngZl,m3h2x8(:,65),heltab2x16(:,:,601))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(13),n2h8(65))
  call Hloop_WA_Q(ntryL,G0H16(123),ex3(:),G0H8(1),m3h2x8(:,66),heltab2x16(:,:,602))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(14),n2h8(66))
  call Hloop_ZA_Q(ntryL,G0H16(124),ex3(:),G0H8(1),ngZl,m3h2x8(:,67),heltab2x16(:,:,603))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(17),n2h8(67))
  call Hloop_WA_Q(ntryL,G0H16(125),ex3(:),G0H8(1),m3h2x8(:,68),heltab2x16(:,:,604))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(18),n2h8(68))
  call Hloop_ZQ_A(ntryL,G0H16(126),ex2(:),G0H8(1),ngZl,m3h2x8(:,69),heltab2x16(:,:,605))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(1),n2h8(69))
  call Hloop_WQ_A(ntryL,G0H16(127),ex2(:),G0H8(1),m3h2x8(:,70),heltab2x16(:,:,606))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(2),n2h8(70))
  call Hloop_ZQ_A(ntryL,G0H16(128),ex2(:),G0H8(1),ngZl,m3h2x8(:,71),heltab2x16(:,:,607))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(8),n2h8(71))
  call Hloop_WQ_A(ntryL,G0H16(129),ex2(:),G0H8(1),m3h2x8(:,72),heltab2x16(:,:,608))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(9),n2h8(72))
  call Hloop_AQ_V(ntryL,G1H4(9),ex2(:),G1H2(15),m3h2x2(:,31),heltab2x4(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H4(10),ex2(:),G1H2(16),ngZl,m3h2x2(:,32),heltab2x4(:,:,56))
  call Hloop_AQ_W(ntryL,G1H4(11),ex2(:),G1H2(17),m3h2x2(:,33),heltab2x4(:,:,57))
  call Hloop_WQ_A(ntryL,G1H4(12),ex2(:),G1H2(18),m3h2x2(:,34),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(18),27,0,G2H2(17),n2h2(45))
  call Hloop_ZA_Q(ntryL,G0H16(130),ex3(:),G0H8(1),ngZl,m3h2x8(:,73),heltab2x16(:,:,609))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(15),n2h8(73))
  call Hloop_WA_Q(ntryL,G0H16(131),ex3(:),G0H8(1),m3h2x8(:,74),heltab2x16(:,:,610))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(20),n2h8(74))
  call Hloop_ZA_Q(ntryL,G0H16(132),ex3(:),G0H8(1),ngZl,m3h2x8(:,75),heltab2x16(:,:,611))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(16),n2h8(75))
  call Hloop_WA_Q(ntryL,G0H16(133),ex3(:),G0H8(1),m3h2x8(:,76),heltab2x16(:,:,612))
  call Hloop_A_Q(ntryL,G0H8(1),20,0,G1H8(19),n2h8(76))
  call Hloop_ZQ_A(ntryL,G0H16(134),ex1(:),G0H8(1),ngZl,m3h2x8(:,77),heltab2x16(:,:,613))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(21),n2h8(77))
  call Hloop_WQ_A(ntryL,G0H16(135),ex1(:),G0H8(1),m3h2x8(:,78),heltab2x16(:,:,614))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(22),n2h8(78))
  call Hloop_ZQ_A(ntryL,G0H16(136),ex1(:),G0H8(1),ngZl,m3h2x8(:,79),heltab2x16(:,:,615))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(23),n2h8(79))
  call Hloop_WQ_A(ntryL,G0H16(137),ex1(:),G0H8(1),m3h2x8(:,80),heltab2x16(:,:,616))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(24),n2h8(80))
  call Hloop_AQ_V(ntryL,G1H4(13),ex1(:),G1H2(18),m3h2x2(:,35),heltab2x4(:,:,59))
  call Hloop_AQ_Z(ntryL,G1H4(14),ex1(:),G1H2(19),ngZl,m3h2x2(:,36),heltab2x4(:,:,60))
  call Hloop_AQ_W(ntryL,G1H4(15),ex1(:),G1H2(20),m3h2x2(:,37),heltab2x4(:,:,61))
  call Hloop_WQ_A(ntryL,G1H4(16),ex1(:),G1H2(21),m3h2x2(:,38),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(21),27,0,G2H2(18),n2h2(46))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(43),G1H4(21),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(44),G1H4(22),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(45),G1H4(25),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(46),G1H4(26),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(52),G1H4(39),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(53),G1H4(40),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(54),G1H4(41),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(55),G1H4(42),G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(38),G2H4(35),G2H4(34),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(40),G2H4(37),G2H4(36),G0H4(5),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(29),G2H4(26),G2H4(25),G0H4(8),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(32),G2H4(28),G2H4(27),G0H4(10),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(8),G1H2(3),G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(9),G1H2(4),G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G2H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(82),G1H4(1),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(83),G1H4(7),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(86),G1H4(64),G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(87),G1H4(65),G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G1H4(91),G1H4(76),G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(92),G1H4(77),G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(95),G1H4(80),G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(96),G1H4(81),G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(77),G2H4(76),G2H4(75),G0H4(12),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G2H4(81),G2H4(80),G2H4(79),G0H4(15),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(68),G2H4(67),G2H4(66),G0H4(17),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(73),G2H4(71),G2H4(70),G0H4(20),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G0H4(19)])
  call Hloop_AV_Q(ntryL,G2H4(13),wf4(:,8),G2H1(1),m3h4x1(:,25),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(1),n2h1(1))
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,8),G2H1(1),m3h4x1(:,26),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(2),n2h1(2))
  call Hloop_AV_Q(ntryL,G2H4(15),wf4(:,8),G2H1(1),m3h4x1(:,27),heltab2x4(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(3),n2h1(3))
  call Hloop_QV_A(ntryL,G2H4(16),wf4(:,8),G2H1(1),m3h4x1(:,28),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(4),n2h1(4))
  call Hloop_AV_Q(ntryL,G2H4(17),wf4(:,8),G2H1(1),m3h4x1(:,29),heltab2x4(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(5),n2h1(5))
  call Hloop_QV_A(ntryL,G2H4(18),wf4(:,8),G2H1(1),m3h4x1(:,30),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(6),n2h1(6))
  call Hloop_AZ_Q(ntryL,G2H4(19),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,31),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(7),n2h1(7))
  call Hloop_QZ_A(ntryL,G2H4(20),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,32),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(8),n2h1(8))
  call Hloop_AZ_Q(ntryL,G2H4(21),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,33),heltab2x4(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(9),n2h1(9))
  call Hloop_QZ_A(ntryL,G2H4(22),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,34),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(10),n2h1(10))
  call Hloop_AZ_Q(ntryL,G2H4(23),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,35),heltab2x4(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(11),n2h1(11))
  call Hloop_QZ_A(ntryL,G2H4(24),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,36),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(12))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(47),21,wf4(:,8),10,G2tensor(17),m3h4x1(:,37),heltab2x4(:,:,75))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(48),21,wf4(:,8),10,G2tensor(16),m3h4x1(:,38),heltab2x4(:,:,76))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(50),21,wf4(:,2),10,G2tensor(15),m3h4x1(:,39),heltab2x4(:,:,77))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(51),21,wf4(:,2),10,G2tensor(3),m3h4x1(:,40),heltab2x4(:,:,78))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(23),21,wf4(:,2),10,G2tensor(2),m3h4x1(:,41),heltab2x4(:,:,79))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(49),21,wf4(:,2),10,G2tensor(1),m3h4x1(:,42),heltab2x4(:,:,80))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(31),21,wf4(:,8),G2tensor(27),m3h4x1(:,43),heltab2x4(:,:,81))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(32),21,wf4(:,8),10,G2tensor(26),m3h4x1(:,44),heltab2x4(:,:,82))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(33),21,wf4(:,2),G2tensor(25),m3h4x1(:,45),heltab2x4(:,:,83))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(34),21,wf4(:,2),10,G2tensor(10),m3h4x1(:,46),heltab2x4(:,:,84))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(56),21,wf4(:,8),10,G2tensor(9),m3h4x1(:,47),heltab2x4(:,:,85))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(57),21,wf4(:,8),10,G2tensor(8),m3h4x1(:,48),heltab2x4(:,:,86))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(58),21,wf4(:,2),10,G2tensor(21),m3h4x1(:,49),heltab2x4(:,:,87))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(59),21,wf4(:,2),10,G2tensor(20),m3h4x1(:,50),heltab2x4(:,:,88))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(39),wf4(:,8),G2tensor(19),m3h4x1(:,51),heltab2x4(:,:,89))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(41),wf4(:,2),G2tensor(31),m3h4x1(:,52),heltab2x4(:,:,90))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(4),wf4(:,2),G0tensor(1),m3h4x1(:,53),heltab2x4(:,:,91))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(30),wf4(:,8),G2tensor(30),m3h4x1(:,54),heltab2x4(:,:,92))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(33),wf4(:,2),G2tensor(29),m3h4x1(:,55),heltab2x4(:,:,93))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(31),wf4(:,2),G2tensor(6),m3h4x1(:,56),heltab2x4(:,:,94))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(10),ex4(:),G1tensor(2),ngZl,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H2(11),ex4(:),G1tensor(3),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(3),wf8(:,6),G1tensor(64),ngZl,m3h8x1(:,1),heltab2x8(:,:,57))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(4),wf8(:,6),G1tensor(23),m3h8x1(:,2),heltab2x8(:,:,58))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(5),wf8(:,8),G1tensor(6),ngZl,m3h8x1(:,3),heltab2x8(:,:,59))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(6),wf8(:,8),G1tensor(8),m3h8x1(:,4),heltab2x8(:,:,60))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(13))
  call Hloop_ZA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),ngZl,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(14))
  call Hloop_WA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(15))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(23),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hloop_QV_A(ntryL,G2H4(48),wf4(:,11),G2H1(1),m3h4x1(:,57),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(13),n2h1(16))
  call Hloop_AV_Q(ntryL,G2H4(49),wf4(:,11),G2H1(1),m3h4x1(:,58),heltab2x4(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(14),n2h1(17))
  call Hloop_QV_A(ntryL,G2H4(50),wf4(:,11),G2H1(1),m3h4x1(:,59),heltab2x4(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(15),n2h1(18))
  call Hloop_AV_Q(ntryL,G2H4(51),wf4(:,11),G2H1(1),m3h4x1(:,60),heltab2x4(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(16),n2h1(19))
  call Hloop_QV_A(ntryL,G2H4(52),wf4(:,11),G2H1(1),m3h4x1(:,61),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(17),n2h1(20))
  call Hloop_AV_Q(ntryL,G2H4(53),wf4(:,11),G2H1(1),m3h4x1(:,62),heltab2x4(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(18),n2h1(21))
  call Hloop_QZ_A(ntryL,G2H4(60),wf4(:,4),G2H1(1),ngZl,m3h4x1(:,63),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(19),n2h1(22))
  call Hloop_AZ_Q(ntryL,G2H4(61),wf4(:,4),G2H1(1),ngZl,m3h4x1(:,64),heltab2x4(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(20),n2h1(23))
  call Hloop_QZ_A(ntryL,G2H4(62),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,65),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(21),n2h1(24))
  call Hloop_AZ_Q(ntryL,G2H4(63),wf4(:,4),G2H1(1),ngZu,m3h4x1(:,66),heltab2x4(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(22),n2h1(25))
  call Hloop_QZ_A(ntryL,G2H4(64),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,67),heltab2x4(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(23),n2h1(26))
  call Hloop_AZ_Q(ntryL,G2H4(65),wf4(:,4),G2H1(1),ngZd,m3h4x1(:,68),heltab2x4(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(24),n2h1(27))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(84),22,wf4(:,11),9,G2tensor(24),m3h4x1(:,69),heltab2x4(:,:,107))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(85),22,wf4(:,11),9,G2tensor(4),m3h4x1(:,70),heltab2x4(:,:,108))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(89),22,wf4(:,4),9,G2tensor(13),m3h4x1(:,71),heltab2x4(:,:,109))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(90),22,wf4(:,4),9,G2tensor(5),m3h4x1(:,72),heltab2x4(:,:,110))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(62),22,wf4(:,4),9,G2tensor(14),m3h4x1(:,73),heltab2x4(:,:,111))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(88),22,wf4(:,4),9,G2tensor(28),m3h4x1(:,74),heltab2x4(:,:,112))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(68),22,wf4(:,11),9,G2tensor(33),m3h4x1(:,75),heltab2x4(:,:,113))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(69),22,wf4(:,11),G2tensor(34),m3h4x1(:,76),heltab2x4(:,:,114))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(72),22,wf4(:,4),9,G2tensor(11),m3h4x1(:,77),heltab2x4(:,:,115))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(73),22,wf4(:,4),G2tensor(22),m3h4x1(:,78),heltab2x4(:,:,116))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(93),22,wf4(:,11),9,G2tensor(32),m3h4x1(:,79),heltab2x4(:,:,117))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(94),22,wf4(:,11),9,G2tensor(35),m3h4x1(:,80),heltab2x4(:,:,118))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(97),22,wf4(:,4),9,G2tensor(36),m3h4x1(:,81),heltab2x4(:,:,119))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(98),22,wf4(:,4),9,G2tensor(37),m3h4x1(:,82),heltab2x4(:,:,120))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(78),wf4(:,11),G2tensor(38),m3h4x1(:,83),heltab2x4(:,:,121))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(82),wf4(:,4),G2tensor(39),m3h4x1(:,84),heltab2x4(:,:,122))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(14),wf4(:,4),G0tensor(6),m3h4x1(:,85),heltab2x4(:,:,123))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(69),wf4(:,11),G2tensor(40),m3h4x1(:,86),heltab2x4(:,:,124))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(74),wf4(:,4),G2tensor(41),m3h4x1(:,87),heltab2x4(:,:,125))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(72),wf4(:,4),G2tensor(42),m3h4x1(:,88),heltab2x4(:,:,126))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(7),wf8(:,14),G1tensor(9),ngZl,m3h8x1(:,5),heltab2x8(:,:,61))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(10),wf8(:,14),G1tensor(70),m3h8x1(:,6),heltab2x8(:,:,62))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(11),wf8(:,16),G1tensor(12),ngZl,m3h8x1(:,7),heltab2x8(:,:,63))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(12),wf8(:,16),G1tensor(14),m3h8x1(:,8),heltab2x8(:,:,64))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(28))
  call Hloop_ZA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),ngZl,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(29))
  call Hloop_WA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(30))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(46),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(13),wf8(:,18),G1tensor(15),ngZl,m3h8x1(:,9),heltab2x8(:,:,65))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(14),wf8(:,18),G1tensor(28),m3h8x1(:,10),heltab2x8(:,:,66))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(17),wf8(:,20),G1tensor(18),ngZl,m3h8x1(:,11),heltab2x8(:,:,67))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(18),wf8(:,20),G1tensor(20),m3h8x1(:,12),heltab2x8(:,:,68))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(1),wf8(:,22),G1tensor(21),ngZl,m3h8x1(:,13),heltab2x8(:,:,69))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(2),wf8(:,22),G1tensor(34),m3h8x1(:,14),heltab2x8(:,:,70))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(8),wf8(:,24),G1tensor(24),ngZl,m3h8x1(:,15),heltab2x8(:,:,71))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(9),wf8(:,24),G1tensor(26),m3h8x1(:,16),heltab2x8(:,:,72))
  call Hloop_VA_Q(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(31))
  call Hloop_ZA_Q(ntryL,G1H2(16),ex3(:),G1H1(1),ngZl,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(32))
  call Hloop_WA_Q(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(33))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(50),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(15),wf8(:,26),G1tensor(27),ngZl,m3h8x1(:,17),heltab2x8(:,:,73))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(20),wf8(:,26),G1tensor(1),m3h8x1(:,18),heltab2x8(:,:,74))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(16),wf8(:,28),G1tensor(30),ngZl,m3h8x1(:,19),heltab2x8(:,:,75))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(19),wf8(:,28),G1tensor(32),m3h8x1(:,20),heltab2x8(:,:,76))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(21),wf8(:,30),G1tensor(33),ngZl,m3h8x1(:,21),heltab2x8(:,:,77))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(22),wf8(:,30),G1tensor(36),m3h8x1(:,22),heltab2x8(:,:,78))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(23),wf8(:,32),G1tensor(38),ngZl,m3h8x1(:,23),heltab2x8(:,:,79))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(24),wf8(:,32),G1tensor(39),m3h8x1(:,24),heltab2x8(:,:,80))
  call Hloop_VA_Q(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(19),ex3(:),G1H1(1),ngZl,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(35))
  call Hloop_WA_Q(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(36))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(54),m3h2x1(:,48),heltab2x2(:,:,48))
  call ol_merge_tensors(G1tensor(7),[G0tensor(110),G0tensor(97),G0tensor(90)])
  call ol_merge_tensors(G1tensor(13),[G0tensor(114),G0tensor(98),G0tensor(94)])
  call ol_merge_tensors(G1tensor(2),[G1tensor(66),G1tensor(19),G0tensor(229),G0tensor(99),G0tensor(79),G0tensor(59),G0tensor(39) &
    ,G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(21),G1tensor(6),G1tensor(64),G1tensor(10),G1tensor(25),G0tensor(190),G0tensor(170) &
    ,G0tensor(165),G0tensor(120),G0tensor(105),G0tensor(100)])
  call ol_merge_tensors(G1tensor(37),[G0tensor(132),G0tensor(124)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(135),G1tensor(43),G0tensor(377),G0tensor(357),G0tensor(133),G0tensor(128)])
  call ol_merge_tensors(G1tensor(3),[G1tensor(96),G1tensor(113),G1tensor(79),G1tensor(49),G0tensor(269),G0tensor(264) &
    ,G0tensor(139),G0tensor(134)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(40),G2tensor(39),G2tensor(38),G2tensor(37),G2tensor(36),G2tensor(35),G2tensor(32) &
    ,G2tensor(22),G2tensor(11),G2tensor(34),G2tensor(33),G2tensor(5),G2tensor(13),G2tensor(4),G2tensor(24),G1tensor(142) &
    ,G1tensor(109),G1tensor(55),G0tensor(414),G0tensor(144),G0tensor(135)])
  call ol_merge_tensors(G1tensor(67),[G0tensor(137),G0tensor(125)])
  call ol_merge_tensors(G1tensor(73),[G0tensor(138),G0tensor(129)])
  call ol_merge_tensors(G1tensor(26),[G1tensor(34),G1tensor(8),G1tensor(23),G1tensor(59),G1tensor(40),G1tensor(115),G1tensor(85) &
    ,G0tensor(215),G0tensor(210),G0tensor(145),G0tensor(140)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(97),G0tensor(368),G0tensor(363),G0tensor(142),G0tensor(122)])
  call ol_merge_tensors(G1tensor(103),[G0tensor(143),G0tensor(130)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(175),G0tensor(162),G0tensor(150)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(179),G0tensor(163),G0tensor(154)])
  call ol_merge_tensors(G1tensor(127),[G1tensor(5),G0tensor(349),G0tensor(329),G0tensor(324),G0tensor(184),G0tensor(164) &
    ,G0tensor(159)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(207),G0tensor(195)])
  call ol_merge_tensors(G1tensor(35),[G0tensor(208),G0tensor(199)])
  call ol_merge_tensors(G1tensor(132),[G1tensor(29),G0tensor(374),G0tensor(369),G0tensor(209),G0tensor(204)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(78),G1tensor(42),G0tensor(263),G0tensor(258),G0tensor(212),G0tensor(192)])
  call ol_merge_tensors(G1tensor(53),[G0tensor(213),G0tensor(200)])
  call ol_merge_tensors(G1tensor(47),[G0tensor(214),G0tensor(205)])
  call ol_merge_tensors(G1tensor(71),[G0tensor(240),G0tensor(227),G0tensor(220)])
  call ol_merge_tensors(G1tensor(65),[G0tensor(244),G0tensor(228),G0tensor(224)])
  call ol_merge_tensors(G1tensor(38),[G1tensor(33),G1tensor(12),G1tensor(9),G1tensor(128),G1tensor(72),G0tensor(355),G0tensor(335) &
    ,G0tensor(330),G0tensor(295),G0tensor(250),G0tensor(235),G0tensor(230)])
  call ol_merge_tensors(G1tensor(77),[G0tensor(262),G0tensor(254)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(30),G2tensor(31),G2tensor(19),G2tensor(20),G2tensor(21),G2tensor(8),G2tensor(9) &
    ,G2tensor(10),G2tensor(25),G2tensor(26),G2tensor(27),G2tensor(3),G2tensor(15),G2tensor(16),G2tensor(17),G1tensor(147) &
    ,G1tensor(122),G1tensor(89),G0tensor(419),G0tensor(274),G0tensor(265)])
  call ol_merge_tensors(G1tensor(101),[G0tensor(267),G0tensor(255)])
  call ol_merge_tensors(G1tensor(95),[G0tensor(268),G0tensor(259)])
  call ol_merge_tensors(G1tensor(39),[G1tensor(36),G1tensor(14),G1tensor(70),G1tensor(138),G1tensor(133),G1tensor(123) &
    ,G1tensor(102),G0tensor(380),G0tensor(375),G0tensor(275),G0tensor(270)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(108),G0tensor(272),G0tensor(252),G0tensor(203),G0tensor(198)])
  call ol_merge_tensors(G1tensor(121),[G0tensor(273),G0tensor(260)])
  call ol_merge_tensors(G1tensor(125),[G0tensor(340),G0tensor(327),G0tensor(315)])
  call ol_merge_tensors(G1tensor(126),[G0tensor(344),G0tensor(328),G0tensor(319)])
  call ol_merge_tensors(G1tensor(130),[G0tensor(372),G0tensor(360)])
  call ol_merge_tensors(G1tensor(131),[G0tensor(373),G0tensor(364)])
  call ol_merge_tensors(G1tensor(136),[G0tensor(378),G0tensor(365)])
  call ol_merge_tensors(G1tensor(137),[G0tensor(379),G0tensor(370)])
  call ol_merge_tensors(G1tensor(140),[G0tensor(412)])
  call ol_merge_tensors(G1tensor(141),[G0tensor(413)])
  call ol_merge_tensors(G1tensor(32),[G1tensor(1),G1tensor(20),G1tensor(28),G1tensor(148),G1tensor(143),G0tensor(420) &
    ,G0tensor(415)])
  call ol_merge_tensors(G1tensor(145),[G0tensor(417)])
  call ol_merge_tensors(G1tensor(146),[G0tensor(418)])
  call ol_merge_tensors(G0tensor(22),[G0tensor(2)])
  call ol_merge_tensors(G0tensor(7),[G0tensor(3)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(12),G0tensor(4)])



end subroutine vamp_1

end module ol_vamp_1_eehll_ew_eeexexh_1_/**/REALKIND
