
module ol_vamp_2_eehll_ew_eeexexh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eehll_ew_eeexexh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eehll_ew_eeexexh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eehll_ew_eeexexh_1_/**/DREALKIND
  use ol_tensor_sum_storage_eehll_ew_eeexexh_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eehll_ew_eeexexh_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eehll_ew_eeexexh_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(1,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call ol_merge_tensors(G0tensor(70),[G0tensor(50),G0tensor(30),G0tensor(17),G0tensor(5)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(13),G0tensor(8)])
  call ol_merge_tensors(G0tensor(74),[G0tensor(54),G0tensor(34),G0tensor(18),G0tensor(9)])
  call ol_merge_tensors(G0tensor(23),[G0tensor(10)])
  call ol_merge_tensors(G0tensor(290),[G0tensor(234),G0tensor(24),G0tensor(15)])
  call ol_merge_tensors(G1tensor(30),[G1tensor(27),G1tensor(18),G1tensor(15),G0tensor(85),G0tensor(65),G0tensor(45),G0tensor(25) &
    ,G0tensor(20)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(27)])
  call ol_merge_tensors(G0tensor(32),[G0tensor(28)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(37),G0tensor(29)])
  call ol_merge_tensors(G0tensor(243),[G0tensor(187),G0tensor(172),G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G0tensor(43),[G0tensor(35)])
  call ol_merge_tensors(G0tensor(310),[G0tensor(249),G0tensor(44),G0tensor(40)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(47)])
  call ol_merge_tensors(G0tensor(52),[G0tensor(48)])
  call ol_merge_tensors(G0tensor(89),[G0tensor(57),G0tensor(49)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(58),G0tensor(53)])
  call ol_merge_tensors(G0tensor(63),[G0tensor(55)])
  call ol_merge_tensors(G0tensor(104),[G0tensor(64),G0tensor(60)])
  call ol_merge_tensors(G0tensor(408),[G0tensor(403),G0tensor(82),G0tensor(67)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(68)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(77),G0tensor(69)])
  call ol_merge_tensors(G0tensor(397),[G0tensor(352),G0tensor(337),G0tensor(113),G0tensor(78),G0tensor(73)])
  call ol_merge_tensors(G0tensor(83),[G0tensor(75)])
  call ol_merge_tensors(G0tensor(119),[G0tensor(84),G0tensor(80)])
  call ol_merge_tensors(G0tensor(102),[G0tensor(87)])
  call ol_merge_tensors(G0tensor(92),[G0tensor(88)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(95)])
  call ol_merge_tensors(G0tensor(348),[G0tensor(343),G0tensor(117),G0tensor(107)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(108)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(115)])
  call ol_merge_tensors(G0tensor(127),[G0tensor(123)])
  call ol_merge_tensors(G0tensor(167),[G0tensor(147)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(148)])
  call ol_merge_tensors(G0tensor(157),[G0tensor(149)])
  call ol_merge_tensors(G0tensor(158),[G0tensor(153)])
  call ol_merge_tensors(G0tensor(168),[G0tensor(155)])
  call ol_merge_tensors(G0tensor(169),[G0tensor(160)])
  call ol_merge_tensors(G0tensor(177),[G0tensor(173)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(174)])
  call ol_merge_tensors(G0tensor(297),[G0tensor(247),G0tensor(237),G0tensor(183),G0tensor(178)])
  call ol_merge_tensors(G0tensor(188),[G0tensor(180)])
  call ol_merge_tensors(G0tensor(189),[G0tensor(185)])
  call ol_merge_tensors(G0tensor(197),[G0tensor(193)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(194)])
  call ol_merge_tensors(G0tensor(277),[G0tensor(232),G0tensor(217)])
  call ol_merge_tensors(G0tensor(222),[G0tensor(218)])
  call ol_merge_tensors(G0tensor(285),[G0tensor(233),G0tensor(225)])
  call ol_merge_tensors(G0tensor(242),[G0tensor(238)])
  call ol_merge_tensors(G0tensor(305),[G0tensor(248),G0tensor(245)])
  call ol_merge_tensors(G0tensor(257),[G0tensor(253)])
  call ol_merge_tensors(G0tensor(282),[G0tensor(278)])
  call ol_merge_tensors(G0tensor(287),[G0tensor(279)])
  call ol_merge_tensors(G0tensor(400),[G0tensor(385),G0tensor(300),G0tensor(292),G0tensor(280)])
  call ol_merge_tensors(G0tensor(288),[G0tensor(283)])
  call ol_merge_tensors(G0tensor(404),[G0tensor(389),G0tensor(304),G0tensor(293),G0tensor(284)])
  call ol_merge_tensors(G0tensor(409),[G0tensor(394),G0tensor(309),G0tensor(294),G0tensor(289)])
  call ol_merge_tensors(G0tensor(302),[G0tensor(298)])
  call ol_merge_tensors(G0tensor(307),[G0tensor(299)])
  call ol_merge_tensors(G0tensor(308),[G0tensor(303)])
  call ol_merge_tensors(G0tensor(382),[G0tensor(332),G0tensor(312)])
  call ol_merge_tensors(G0tensor(317),[G0tensor(313)])
  call ol_merge_tensors(G0tensor(322),[G0tensor(314)])
  call ol_merge_tensors(G0tensor(323),[G0tensor(318)])
  call ol_merge_tensors(G0tensor(390),[G0tensor(333),G0tensor(320)])
  call ol_merge_tensors(G0tensor(395),[G0tensor(334),G0tensor(325)])
  call ol_merge_tensors(G0tensor(342),[G0tensor(338)])
  call ol_merge_tensors(G0tensor(347),[G0tensor(339)])
  call ol_merge_tensors(G0tensor(405),[G0tensor(353),G0tensor(345)])
  call ol_merge_tensors(G0tensor(410),[G0tensor(354),G0tensor(350)])
  call ol_merge_tensors(G0tensor(362),[G0tensor(358)])
  call ol_merge_tensors(G0tensor(367),[G0tensor(359)])
  call ol_merge_tensors(G0tensor(387),[G0tensor(383)])
  call ol_merge_tensors(G0tensor(392),[G0tensor(384)])
  call ol_merge_tensors(G0tensor(393),[G0tensor(388)])
  call ol_merge_tensors(G0tensor(402),[G0tensor(398)])
  call ol_merge_tensors(G0tensor(407),[G0tensor(399)])
  call ol_merge_tensors(G3tensor(8),[G3tensor(7),G3tensor(2),G3tensor(1)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(9),G3tensor(4),G3tensor(3)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(6),G3tensor(5)])
  call ol_merge_tensors(G2tensor(2),[G0tensor(1)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(1)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(19),G3tensor(14),G3tensor(13)])
  call ol_merge_tensors(G3tensor(22),[G3tensor(21),G3tensor(16),G3tensor(15)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(23),G3tensor(18),G3tensor(17)])
  call ol_merge_tensors(G2tensor(14),[G0tensor(6)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(28)])
  call TI_triangle_red(G2tensor(46),RedBasis(9),mass3set(:,1),G0tensor(11),G0tensor(16),G0tensor(21),G0tensor(26),M2L1R1,[nMW], &
    G0tensor(31))
  call TI_triangle_red(G2tensor(41),RedBasis(7),mass3set(:,2),G0tensor(36),G0tensor(41),G0tensor(46),G0tensor(51),M2L1R1,[nMW], &
    G0tensor(56))
  call TI_triangle_red(G2tensor(50),RedBasis(27),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1,[nMW], &
    G0tensor(81))
  call TI_triangle_red(G2tensor(23),RedBasis(6),mass3set(:,1),G0tensor(86),G0tensor(91),G0tensor(96),G0tensor(101),M2L1R1,[nMW], &
    G0tensor(106))
  call TI_triangle_red(G2tensor(29),RedBasis(2),mass3set(:,2),G0tensor(111),G0tensor(116),G0tensor(121), &
    G0tensor(126),M2L1R1,[nMW],G0tensor(131))
  call TI_triangle_red(G2tensor(54),RedBasis(17),mass3set(:,1),G0tensor(136),G0tensor(141),G0tensor(146), &
    G0tensor(151),M2L1R1,[nMW],G0tensor(156))
  call TI_triangle_red(G3tensor(8),RedBasis(2),mass3set(:,3),G0tensor(161),G0tensor(166),G0tensor(171),G0tensor(176),M2L1R1,[nML], &
    G0tensor(181))
  call TI_triangle_red(G3tensor(10),RedBasis(2),mass3set(:,4),G0tensor(186),G0tensor(191),G0tensor(196), &
    G0tensor(201),M2L1R1,[nMT],G0tensor(206))
  call TI_triangle_red(G3tensor(12),RedBasis(2),mass3set(:,5),G0tensor(211),G0tensor(216),G0tensor(221), &
    G0tensor(226),M2L1R1,[nMB],G0tensor(231))
  call TI_triangle_red(G2tensor(2),RedBasis(2),mass3set(:,6),G0tensor(236),G0tensor(241),G0tensor(246), &
    G0tensor(251),M2L1R1,[nMH,nMZ],G0tensor(256),G0tensor(261))
  call TI_triangle_red(G2tensor(6),RedBasis(2),mass3set(:,7),G0tensor(266),G0tensor(271),G0tensor(276), &
    G0tensor(281),M2L1R1,[nMZ,nMH],G0tensor(286),G0tensor(291))
  call TI_triangle_red(G2tensor(12),RedBasis(6),mass3set(:,8),G0tensor(296),G0tensor(301),G0tensor(306),G0tensor(311),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(6),mass3set(:,9),G0tensor(316),G0tensor(321),G0tensor(326),G0tensor(331),M2L1R1,[nMZ], &
    G0tensor(336))
  call TI_triangle_red(G2tensor(18),RedBasis(6),mass3set(:,10),G0tensor(341),G0tensor(346),G0tensor(351), &
    G0tensor(356),M2L1R1,[nMW],G0tensor(361))
  call TI_triangle_red(G3tensor(20),RedBasis(7),mass3set(:,3),G0tensor(366),G0tensor(371),G0tensor(376), &
    G0tensor(381),M2L1R1,[nML],G0tensor(386))
  call TI_triangle_red(G3tensor(22),RedBasis(7),mass3set(:,4),G0tensor(391),G0tensor(396),G0tensor(401), &
    G0tensor(406),M2L1R1,[nMT],G0tensor(411))
  call TI_triangle_red(G3tensor(24),RedBasis(7),mass3set(:,5),G0tensor(416),G0tensor(110),G0tensor(97),G0tensor(90),M2L1R1,[nMB], &
    G0tensor(114))
  call TI_triangle_red(G2tensor(14),RedBasis(7),mass3set(:,6),G0tensor(98),G0tensor(94),G0tensor(229), &
    G0tensor(99),M2L1R1,[nMH,nMZ],G0tensor(79),G0tensor(59))
  call TI_triangle_red(G2tensor(42),RedBasis(7),mass3set(:,7),G0tensor(39),G0tensor(19),G0tensor(14), &
    G0tensor(190),M2L1R1,[nMZ,nMH],G0tensor(170),G0tensor(165))
  call TI_triangle_red(G2tensor(43),RedBasis(9),mass3set(:,8),G0tensor(120),G0tensor(105),G0tensor(100),G0tensor(132),M2L1R1)
  call TI_triangle_red(G2tensor(44),RedBasis(9),mass3set(:,9),G0tensor(124),G0tensor(377),G0tensor(357), &
    G0tensor(133),M2L1R1,[nMZ],G0tensor(128))
  call TI_triangle_red(G2tensor(45),RedBasis(9),mass3set(:,10),G0tensor(269),G0tensor(264),G0tensor(139), &
    G0tensor(134),M2L1R1,[nMW],G0tensor(414))
  call TI_triangle_red(G2tensor(47),RedBasis(27),mass3set(:,8),G0tensor(144),G0tensor(135),G0tensor(137),G0tensor(125),M2L1R1)
  call TI_triangle_red(G2tensor(48),RedBasis(27),mass3set(:,9),G0tensor(138),G0tensor(129),G0tensor(215), &
    G0tensor(210),M2L1R1,[nMZ],G0tensor(145))
  call TI_triangle_red(G2tensor(49),RedBasis(27),mass3set(:,10),G0tensor(140),G0tensor(368),G0tensor(363), &
    G0tensor(142),M2L1R1,[nMW],G0tensor(122))
  call TI_triangle_red(G2tensor(51),RedBasis(17),mass3set(:,8),G0tensor(143),G0tensor(130),G0tensor(175),G0tensor(162),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(17),mass3set(:,9),G0tensor(150),G0tensor(179),G0tensor(163), &
    G0tensor(154),M2L1R1,[nMZ],G0tensor(349))
  call TI_triangle_red(G2tensor(53),RedBasis(17),mass3set(:,10),G0tensor(329),G0tensor(324),G0tensor(184), &
    G0tensor(164),M2L1R1,[nMW],G0tensor(159))
  call TI_triangle_red(G1tensor(7),RedBasis(52),mass3set(:,11),G0tensor(207),G0tensor(195),G0tensor(208), &
    G0tensor(199),M2L1R1,[nMZ],G0tensor(374))
  call TI_triangle_red(G1tensor(13),RedBasis(12),mass3set(:,12),G0tensor(369),G0tensor(209),G0tensor(204), &
    G0tensor(263),M2L1R1,[nMZ],G0tensor(258))
  call TI_triangle_red(G1tensor(2),RedBasis(3),mass3set(:,13),G0tensor(212),G0tensor(192),G0tensor(213), &
    G0tensor(200),M2L1R1,[nMZ],G0tensor(214))
  call TI_triangle_red(G1tensor(24),RedBasis(10),mass3set(:,13),G0tensor(205),G0tensor(240),G0tensor(227), &
    G0tensor(220),M2L1R1,[nMZ],G0tensor(244))
  call TI_triangle_red(G1tensor(37),RedBasis(50),mass3set(:,14),G0tensor(228),G0tensor(224),G0tensor(355), &
    G0tensor(335),M2L1R1,[nMW],G0tensor(330))
  call TI_triangle_red(G1tensor(3),RedBasis(3),mass3set(:,1),G0tensor(295),G0tensor(250),G0tensor(235),G0tensor(230),M2L1R1,[nMW], &
    G0tensor(262))
  call TI_triangle_red(G1tensor(67),RedBasis(52),mass3set(:,15),G0tensor(254),G0tensor(419),G0tensor(274), &
    G0tensor(265),M2L1R1,[nMW],G0tensor(267))
  call TI_triangle_red(G1tensor(73),RedBasis(12),mass3set(:,16),G0tensor(255),G0tensor(268),G0tensor(259), &
    G0tensor(380),M2L1R1,[nMW],G0tensor(375))
  call TI_triangle_red(G1tensor(26),RedBasis(10),mass3set(:,1),G0tensor(275),G0tensor(270),G0tensor(272), &
    G0tensor(252),M2L1R1,[nMW],G0tensor(203))
  call TI_triangle_red(G1tensor(103),RedBasis(11),mass3set(:,17),G0tensor(198),G0tensor(273),G0tensor(260), &
    G0tensor(340),M2L1R1,[nMW],G0tensor(327))
  call TI_triangle_red(G1tensor(17),RedBasis(8),mass3set(:,11),G0tensor(315),G0tensor(344),G0tensor(328), &
    G0tensor(319),M2L1R1,[nMZ],G0tensor(372))
  call TI_triangle_red(G1tensor(11),RedBasis(16),mass3set(:,12),G0tensor(360),G0tensor(373),G0tensor(364), &
    G0tensor(378),M2L1R1,[nMZ],G0tensor(365))
  call TI_triangle_red(G1tensor(127),RedBasis(14),mass3set(:,13),G0tensor(379),G0tensor(370),G0tensor(412), &
    G0tensor(413),M2L1R1,[nMZ],G0tensor(420))
  call TI_triangle_red(G1tensor(22),RedBasis(8),mass3set(:,15),G0tensor(415),G0tensor(417),G0tensor(418),G0tensor(2),M2L1R1,[nMW], &
    G0tensor(3))
  call TI_triangle_red(G1tensor(35),RedBasis(16),mass3set(:,16),G0tensor(12),G0tensor(4),G0tensor(50),G0tensor(30),M2L1R1,[nMW], &
    G0tensor(17))
  call TI_triangle_red(G1tensor(132),RedBasis(14),mass3set(:,1),G0tensor(5),G0tensor(13),G0tensor(8),G0tensor(54),M2L1R1,[nMW], &
    G0tensor(34))
  call TI_triangle_red(G1tensor(53),RedBasis(15),mass3set(:,17),G0tensor(18),G0tensor(9),G0tensor(10),G0tensor(234),M2L1R1,[nMW], &
    G0tensor(24))
  call TI_triangle_red(G1tensor(47),RedBasis(13),mass3set(:,2),G0tensor(15),G0tensor(85),G0tensor(65),G0tensor(45),M2L1R1,[nMW], &
    G0tensor(25))
  call TI_triangle_red(G1tensor(71),RedBasis(56),mass3set(:,11),G0tensor(20),G0tensor(27),G0tensor(28),G0tensor(37),M2L1R1,[nMZ], &
    G0tensor(29))
  call TI_triangle_red(G1tensor(65),RedBasis(20),mass3set(:,12),G0tensor(187),G0tensor(172),G0tensor(38), &
    G0tensor(33),M2L1R1,[nMZ],G0tensor(35))
  call TI_triangle_red(G1tensor(38),RedBasis(18),mass3set(:,13),G0tensor(249),G0tensor(44),G0tensor(40),G0tensor(47),M2L1R1,[nMZ], &
    G0tensor(48))
  call TI_triangle_red(G1tensor(77),RedBasis(48),mass3set(:,14),G0tensor(57),G0tensor(49),G0tensor(58),G0tensor(53),M2L1R1,[nMW], &
    G0tensor(55))
  call TI_triangle_red(G1tensor(101),RedBasis(56),mass3set(:,15),G0tensor(64),G0tensor(60),G0tensor(403), &
    G0tensor(82),M2L1R1,[nMW],G0tensor(67))
  call TI_triangle_red(G1tensor(95),RedBasis(20),mass3set(:,16),G0tensor(68),G0tensor(77),G0tensor(69),G0tensor(352),M2L1R1,[nMW], &
    G0tensor(337))
  call TI_triangle_red(G1tensor(39),RedBasis(18),mass3set(:,1),G0tensor(113),G0tensor(78),G0tensor(73),G0tensor(75),M2L1R1,[nMW], &
    G0tensor(84))
  call TI_triangle_red(G1tensor(121),RedBasis(19),mass3set(:,17),G0tensor(80),G0tensor(87),G0tensor(88),G0tensor(95),M2L1R1,[nMW], &
    G0tensor(343))
  call TI_triangle_red(G1tensor(125),RedBasis(4),mass3set(:,11),G0tensor(117),G0tensor(107),G0tensor(108), &
    G0tensor(115),M2L1R1,[nMZ],G0tensor(123))
  call TI_triangle_red(G1tensor(126),RedBasis(26),mass3set(:,12),G0tensor(147),G0tensor(148),G0tensor(149), &
    G0tensor(153),M2L1R1,[nMZ],G0tensor(155))
  call TI_triangle_red(G1tensor(130),RedBasis(4),mass3set(:,15),G0tensor(160),G0tensor(173),G0tensor(174), &
    G0tensor(247),M2L1R1,[nMW],G0tensor(237))
  call TI_triangle_red(G1tensor(131),RedBasis(26),mass3set(:,16),G0tensor(183),G0tensor(178),G0tensor(180), &
    G0tensor(185),M2L1R1,[nMW],G0tensor(193))
  call TI_triangle_red(G1tensor(136),RedBasis(25),mass3set(:,17),G0tensor(194),G0tensor(232),G0tensor(217), &
    G0tensor(218),M2L1R1,[nMW],G0tensor(233))
  call TI_triangle_red(G1tensor(137),RedBasis(24),mass3set(:,2),G0tensor(225),G0tensor(238),G0tensor(248), &
    G0tensor(245),M2L1R1,[nMW],G0tensor(253))
  call TI_triangle_red(G1tensor(140),RedBasis(28),mass3set(:,1),G0tensor(278),G0tensor(279),G0tensor(385), &
    G0tensor(300),M2L1R1,[nMW],G0tensor(292))
  call TI_triangle_red(G1tensor(141),RedBasis(8),mass3set(:,17),G0tensor(280),G0tensor(283),G0tensor(389), &
    G0tensor(304),M2L1R1,[nMW],G0tensor(293))
  call TI_triangle_red(G1tensor(32),RedBasis(1),mass3set(:,1),G0tensor(284),G0tensor(394),G0tensor(309), &
    G0tensor(294),M2L1R1,[nMW],G0tensor(289))
  call TI_triangle_red(G1tensor(145),RedBasis(53),mass3set(:,1),G0tensor(298),G0tensor(299),G0tensor(303), &
    G0tensor(332),M2L1R1,[nMW],G0tensor(312))
  call TI_triangle_red(G1tensor(146),RedBasis(4),mass3set(:,17),G0tensor(313),G0tensor(314),G0tensor(318), &
    G0tensor(333),M2L1R1,[nMW],G0tensor(320))
  call TI_triangle_red(G1tensor(30),RedBasis(1),mass3set(:,13),G0tensor(334),G0tensor(325),G0tensor(338), &
    G0tensor(339),M2L1R1,[nMZ],G0tensor(353))
  call ol_merge_tensors(T0sum(85),[G0tensor(207)])
  call ol_merge_tensors(T0sum(86),[G0tensor(369)])
  call ol_merge_tensors(T0sum(87),[G0tensor(212)])
  call ol_merge_tensors(T0sum(88),[G0tensor(205)])
  call ol_merge_tensors(T0sum(89),[G0tensor(228)])
  call ol_merge_tensors(T0sum(90),[G0tensor(11)])
  call ol_merge_tensors(T0sum(91),[G0tensor(295)])
  call ol_merge_tensors(T0sum(92),[G0tensor(36)])
  call ol_merge_tensors(T0sum(93),[G0tensor(254)])
  call ol_merge_tensors(T0sum(94),[G0tensor(255)])
  call ol_merge_tensors(T0sum(95),[G0tensor(275)])
  call ol_merge_tensors(T0sum(96),[G0tensor(61)])
  call ol_merge_tensors(T0sum(97),[G0tensor(198)])
  call ol_merge_tensors(T0sum(98),[G0tensor(315)])
  call ol_merge_tensors(T0sum(99),[G0tensor(360)])
  call ol_merge_tensors(T0sum(100),[G0tensor(379)])
  call ol_merge_tensors(T0sum(101),[G0tensor(415)])
  call ol_merge_tensors(T0sum(102),[G0tensor(12)])
  call ol_merge_tensors(T0sum(103),[G0tensor(5)])
  call ol_merge_tensors(T0sum(104),[G0tensor(86)])
  call ol_merge_tensors(T0sum(105),[G0tensor(18)])
  call ol_merge_tensors(T0sum(106),[G0tensor(15)])
  call ol_merge_tensors(T0sum(107),[G0tensor(20)])
  call ol_merge_tensors(T0sum(108),[G0tensor(187)])
  call ol_merge_tensors(T0sum(109),[G0tensor(249)])
  call ol_merge_tensors(T0sum(110),[G0tensor(57)])
  call ol_merge_tensors(T0sum(111),[G0tensor(111)])
  call ol_merge_tensors(T0sum(112),[G0tensor(64)])
  call ol_merge_tensors(T0sum(113),[G0tensor(68)])
  call ol_merge_tensors(T0sum(114),[G0tensor(113)])
  call ol_merge_tensors(T0sum(115),[G0tensor(136)])
  call ol_merge_tensors(T0sum(116),[G0tensor(80)])
  call ol_merge_tensors(T0sum(117),[G0tensor(117)])
  call ol_merge_tensors(T0sum(118),[G0tensor(147)])
  call ol_merge_tensors(T0sum(119),[G0tensor(160)])
  call ol_merge_tensors(T0sum(120),[G0tensor(183)])
  call ol_merge_tensors(T0sum(121),[G0tensor(194)])
  call ol_merge_tensors(T0sum(122),[G0tensor(225)])
  call ol_merge_tensors(T0sum(123),[G0tensor(278)])
  call ol_merge_tensors(T0sum(124),[G0tensor(280)])
  call ol_merge_tensors(T0sum(125),[G0tensor(284)])
  call ol_merge_tensors(T0sum(126),[G0tensor(298)])
  call ol_merge_tensors(T0sum(127),[G0tensor(313)])
  call ol_merge_tensors(T0sum(128),[G0tensor(22)])
  call ol_merge_tensors(T0sum(129),[G0tensor(7)])
  call ol_merge_tensors(T0sum(130),[G0tensor(219)])
  call ol_merge_tensors(T0sum(131),[G0tensor(70)])
  call ol_merge_tensors(T0sum(132),[G0tensor(223)])
  call ol_merge_tensors(T0sum(133),[G0tensor(74)])
  call ol_merge_tensors(T0sum(134),[G0tensor(23)])
  call ol_merge_tensors(T0sum(135),[G0tensor(290)])
  call ol_merge_tensors(T0sum(136),[G0tensor(334)])
  call ol_merge_tensors(T0sum(137),[G0tensor(42)])
  call ol_merge_tensors(T0sum(138),[G0tensor(32)])
  call ol_merge_tensors(T0sum(139),[G0tensor(239)])
  call ol_merge_tensors(T0sum(140),[G0tensor(243)])
  call ol_merge_tensors(T0sum(141),[G0tensor(43)])
  call ol_merge_tensors(T0sum(142),[G0tensor(310)])
  call ol_merge_tensors(T0sum(143),[G0tensor(62)])
  call ol_merge_tensors(T0sum(144),[G0tensor(52)])
  call ol_merge_tensors(T0sum(145),[G0tensor(89)])
  call ol_merge_tensors(T0sum(146),[G0tensor(93)])
  call ol_merge_tensors(T0sum(147),[G0tensor(63)])
  call ol_merge_tensors(T0sum(148),[G0tensor(104)])
  call ol_merge_tensors(T0sum(149),[G0tensor(408)])
  call ol_merge_tensors(T0sum(150),[G0tensor(72)])
  call ol_merge_tensors(T0sum(151),[G0tensor(109)])
  call ol_merge_tensors(T0sum(152),[G0tensor(397)])
  call ol_merge_tensors(T0sum(153),[G0tensor(83)])
  call ol_merge_tensors(T0sum(154),[G0tensor(119)])
  call ol_merge_tensors(T0sum(155),[G0tensor(102)])
  call ol_merge_tensors(T0sum(156),[G0tensor(92)])
  call ol_merge_tensors(T0sum(157),[G0tensor(103)])
  call ol_merge_tensors(T0sum(158),[G0tensor(348)])
  call ol_merge_tensors(T0sum(159),[G0tensor(112)])
  call ol_merge_tensors(T0sum(160),[G0tensor(118)])
  call ol_merge_tensors(T0sum(161),[G0tensor(127)])
  call ol_merge_tensors(T0sum(162),[G0tensor(167)])
  call ol_merge_tensors(T0sum(163),[G0tensor(152)])
  call ol_merge_tensors(T0sum(164),[G0tensor(157)])
  call ol_merge_tensors(T0sum(165),[G0tensor(158)])
  call ol_merge_tensors(T0sum(166),[G0tensor(168)])
  call ol_merge_tensors(T0sum(167),[G0tensor(169)])
  call ol_merge_tensors(T0sum(168),[G0tensor(177)])
  call ol_merge_tensors(T0sum(169),[G0tensor(182)])
  call ol_merge_tensors(T0sum(170),[G0tensor(297)])
  call ol_merge_tensors(T0sum(171),[G0tensor(188)])
  call ol_merge_tensors(T0sum(172),[G0tensor(189)])
  call ol_merge_tensors(T0sum(173),[G0tensor(197)])
  call ol_merge_tensors(T0sum(174),[G0tensor(202)])
  call ol_merge_tensors(T0sum(175),[G0tensor(277)])
  call ol_merge_tensors(T0sum(176),[G0tensor(222)])
  call ol_merge_tensors(T0sum(177),[G0tensor(285)])
  call ol_merge_tensors(T0sum(178),[G0tensor(242)])
  call ol_merge_tensors(T0sum(179),[G0tensor(305)])
  call ol_merge_tensors(T0sum(180),[G0tensor(257)])
  call ol_merge_tensors(T0sum(181),[G0tensor(282)])
  call ol_merge_tensors(T0sum(182),[G0tensor(287)])
  call ol_merge_tensors(T0sum(183),[G0tensor(400)])
  call ol_merge_tensors(T0sum(184),[G0tensor(288)])
  call ol_merge_tensors(T0sum(185),[G0tensor(404)])
  call ol_merge_tensors(T0sum(186),[G0tensor(409)])
  call ol_merge_tensors(T0sum(187),[G0tensor(302)])
  call ol_merge_tensors(T0sum(188),[G0tensor(307)])
  call ol_merge_tensors(T0sum(189),[G0tensor(308)])
  call ol_merge_tensors(T0sum(190),[G0tensor(382)])
  call ol_merge_tensors(T0sum(191),[G0tensor(317)])
  call ol_merge_tensors(T0sum(192),[G0tensor(322)])
  call ol_merge_tensors(T0sum(193),[G0tensor(323)])
  call ol_merge_tensors(T0sum(194),[G0tensor(390)])
  call ol_merge_tensors(T0sum(195),[G0tensor(395)])
  call ol_merge_tensors(T0sum(196),[G0tensor(342)])
  call ol_merge_tensors(T0sum(197),[G0tensor(347)])
  call ol_merge_tensors(T0sum(198),[G0tensor(405)])
  call ol_merge_tensors(T0sum(199),[G0tensor(410)])
  call ol_merge_tensors(T0sum(200),[G0tensor(362)])
  call ol_merge_tensors(T0sum(201),[G0tensor(367)])
  call ol_merge_tensors(T0sum(202),[G0tensor(387)])
  call ol_merge_tensors(T0sum(203),[G0tensor(392)])
  call ol_merge_tensors(T0sum(204),[G0tensor(393)])
  call ol_merge_tensors(T0sum(205),[G0tensor(402)])
  call ol_merge_tensors(T0sum(206),[G0tensor(407)])
  call ol_merge_tensors(T0sum(207),[G0tensor(161)])
  call ol_merge_tensors(T0sum(208),[G0tensor(186)])
  call ol_merge_tensors(T0sum(209),[G0tensor(211)])
  call ol_merge_tensors(T0sum(210),[G0tensor(236)])
  call ol_merge_tensors(T0sum(211),[G0tensor(266)])
  call ol_merge_tensors(T0sum(212),[G0tensor(296)])
  call ol_merge_tensors(T0sum(213),[G0tensor(316)])
  call ol_merge_tensors(T0sum(214),[G0tensor(341)])
  call ol_merge_tensors(T0sum(215),[G0tensor(366)])
  call ol_merge_tensors(T0sum(216),[G0tensor(391)])
  call ol_merge_tensors(T0sum(217),[G0tensor(416)])
  call ol_merge_tensors(T0sum(218),[G0tensor(98)])
  call ol_merge_tensors(T0sum(219),[G0tensor(39)])
  call ol_merge_tensors(T0sum(220),[G0tensor(120)])
  call ol_merge_tensors(T0sum(221),[G0tensor(124)])
  call ol_merge_tensors(T0sum(222),[G0tensor(269)])
  call ol_merge_tensors(T0sum(223),[G0tensor(144)])
  call ol_merge_tensors(T0sum(224),[G0tensor(138)])
  call ol_merge_tensors(T0sum(225),[G0tensor(140)])
  call ol_merge_tensors(T0sum(226),[G0tensor(143)])
  call ol_merge_tensors(T0sum(227),[G0tensor(150)])
  call ol_merge_tensors(T0sum(228),[G0tensor(329)])
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(333),h0tab(:,333),[16,15],[nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(19),ex5(:),G0H16(13),m3h1x16(:,317),heltab2x16(:,:,617))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(20),m0h(334),h0tab(:,334),[16,15],[nMW,nMW],3,2,wf4(:,2),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(20),ex5(:),G0H16(7),m3h1x16(:,318),heltab2x16(:,:,618))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(24),m0h(335),h0tab(:,335),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(24),ex5(:),G0H16(16),m3h1x16(:,319),heltab2x16(:,:,619))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(336),h0tab(:,336),[16,15],[nMH,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(9),ex5(:),G0H16(26),m3h1x16(:,320),heltab2x16(:,:,620))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(337),h0tab(:,337),[16,15],[nMZ,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(12),ex5(:),G0H16(36),m3h1x16(:,321),heltab2x16(:,:,621))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(38),m0h(338),h0tab(:,338),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(38),ex5(:),G0H16(40),m3h1x16(:,322),heltab2x16(:,:,622))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(43),m0h(339),h0tab(:,339),[16,15],[nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(43),ex5(:),G0H16(45),m3h1x16(:,323),heltab2x16(:,:,623))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(47),m0h(340),h0tab(:,340),[16,15],[nMW,nMW],3,2,wf4(:,2),wf4(:,7))
  call Hloop_VS_V(ntryL,G0H16(47),ex5(:),G0H16(49),m3h1x16(:,324),heltab2x16(:,:,624))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(52),m0h(341),h0tab(:,341),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VS_V(ntryL,G0H16(52),ex5(:),G0H16(72),m3h1x16(:,325),heltab2x16(:,:,625))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(73),m0h(342),h0tab(:,342),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(73),ex5(:),G0H16(76),m3h1x16(:,326),heltab2x16(:,:,626))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(77),m0h(343),h0tab(:,343),[26,5],[nMW,nMW],3,2,wf4(:,8),wf4(:,7))
  call Hloop_VVS_S(ntryL,G0H16(77),wf4(:,8),ex5(:),G0H4(3),m4h4x1x4(:,1),heltab3x16(:,:,1))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(80),m0h(344),h0tab(:,344),[26,5],[nMW,nMW],3,2,wf4(:,8),wf4(:,7))
  call Hloop_VVS_S(ntryL,G0H16(80),wf4(:,8),ex5(:),G0H4(1),m4h4x1x4(:,2),heltab3x16(:,:,2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(81),m0h(345),h0tab(:,345),[26,5],[nMW,nMW],3,2,wf4(:,2),wf4(:,7))
  call Hloop_VVS_S(ntryL,G0H16(81),wf4(:,2),ex5(:),G0H4(5),m4h4x1x4(:,3),heltab3x16(:,:,3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(84),m0h(346),h0tab(:,346),[26,5],[nMW,nMW],3,2,wf4(:,2),wf4(:,7))
  call Hloop_VVS_S(ntryL,G0H16(84),wf4(:,2),ex5(:),G0H4(2),m4h4x1x4(:,4),heltab3x16(:,:,4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(85),m0h(347),h0tab(:,347),[26,5],[nMW,nMW],3,2,wf4(:,8),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(85),wf4(:,8),ex5(:),G0H4(8),m4h4x1x4(:,5),heltab3x16(:,:,5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(96),m0h(348),h0tab(:,348),[26,5],[nMW,nMW],3,2,wf4(:,8),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(96),wf4(:,8),ex5(:),G0H4(6),m4h4x1x4(:,6),heltab3x16(:,:,6))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(98),m0h(349),h0tab(:,349),[26,5],[nMH,nMZ],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(98),wf4(:,2),ex5(:),G0H4(10),m4h4x1x4(:,7),heltab3x16(:,:,7))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(100),m0h(350),h0tab(:,350),[26,5],[nMW,nMW],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(100),wf4(:,2),ex5(:),G0H4(7),m4h4x1x4(:,8),heltab3x16(:,:,8))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(103),m0h(351),h0tab(:,351),[26,5],[nMW,nMW],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(103),wf4(:,2),ex5(:),G0H4(9),m4h4x1x4(:,9),heltab3x16(:,:,9))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(105),m0h(352),h0tab(:,352),[21,10],[nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VVS_S(ntryL,G0H16(105),wf4(:,7),ex5(:),G0H4(12),m4h4x1x4(:,10),heltab3x16(:,:,10))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(107),m0h(353),h0tab(:,353),[21,10],[nMW,nMW],3,2,wf4(:,7),wf4(:,8))
  call Hloop_VVS_S(ntryL,G0H16(107),wf4(:,7),ex5(:),G0H4(11),m4h4x1x4(:,11),heltab3x16(:,:,11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(109),m0h(354),h0tab(:,354),[21,10],[nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(109),wf4(:,7),ex5(:),G0H4(15),m4h4x1x4(:,12),heltab3x16(:,:,12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(112),m0h(355),h0tab(:,355),[21,10],[nMW,nMW],3,2,wf4(:,7),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(112),wf4(:,7),ex5(:),G0H4(13),m4h4x1x4(:,13),heltab3x16(:,:,13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(356),h0tab(:,356),[21,10],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VVS_S(ntryL,G0H16(5),wf4(:,1),ex5(:),G0H4(17),m4h4x1x4(:,14),heltab3x16(:,:,14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(357),h0tab(:,357),[21,10],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VVS_S(ntryL,G0H16(23),wf4(:,1),ex5(:),G0H4(16),m4h4x1x4(:,15),heltab3x16(:,:,15))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(358),h0tab(:,358),[21,10],[nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(25),wf4(:,1),ex5(:),G0H4(20),m4h4x1x4(:,16),heltab3x16(:,:,16))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(359),h0tab(:,359),[21,10],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(27),wf4(:,1),ex5(:),G0H4(18),m4h4x1x4(:,17),heltab3x16(:,:,17))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(29),m0h(360),h0tab(:,360),[21,10],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(29),wf4(:,1),ex5(:),G0H4(19),m4h4x1x4(:,18),heltab3x16(:,:,18))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(361),h0tab(:,361),[16,15],[nMW,nMW],3,2,wf4(:,11),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(4),ex5(:),G0H16(10),m3h1x16(:,327),heltab2x16(:,:,627))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(362),h0tab(:,362),[16,15],[nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(14),ex5(:),G0H16(18),m3h1x16(:,328),heltab2x16(:,:,628))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(363),h0tab(:,363),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(3),ex5(:),G0H16(11),m3h1x16(:,329),heltab2x16(:,:,629))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(364),h0tab(:,364),[16,15],[nMH,nMH],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(28),m3h1x16(:,330),heltab2x16(:,:,630))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(365),h0tab(:,365),[16,15],[nMZ,nMZ],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(6),ex5(:),G0H16(2),m3h1x16(:,331),heltab2x16(:,:,631))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(366),h0tab(:,366),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(21),ex5(:),G0H16(17),m3h1x16(:,332),heltab2x16(:,:,632))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(367),h0tab(:,367),[16,15],[nMW,nMW],3,2,wf4(:,11),wf4(:,12))
  call Hloop_VS_V(ntryL,G0H16(22),ex5(:),G0H16(1),m3h1x16(:,333),heltab2x16(:,:,633))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(368),h0tab(:,368),[16,15],[nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VS_V(ntryL,G0H16(15),ex5(:),G0H16(30),m3h1x16(:,334),heltab2x16(:,:,634))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(31),m0h(369),h0tab(:,369),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,12))
  call Hloop_VS_V(ntryL,G0H16(31),ex5(:),G0H16(32),m3h1x16(:,335),heltab2x16(:,:,635))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(33),m0h(370),h0tab(:,370),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(33),ex5(:),G0H16(34),m3h1x16(:,336),heltab2x16(:,:,636))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(371),h0tab(:,371),[22,9],[nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VVS_S(ntryL,G0H16(35),wf4(:,12),ex5(:),G0H4(4),m4h4x1x4(:,19),heltab3x16(:,:,19))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(37),m0h(372),h0tab(:,372),[22,9],[nMW,nMW],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VVS_S(ntryL,G0H16(37),wf4(:,12),ex5(:),G0H4(14),m4h4x1x4(:,20),heltab3x16(:,:,20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(39),m0h(373),h0tab(:,373),[22,9],[nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VVS_S(ntryL,G0H16(39),wf4(:,5),ex5(:),G0H4(21),m4h4x1x4(:,21),heltab3x16(:,:,21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(41),m0h(374),h0tab(:,374),[22,9],[nMW,nMW],3,2,wf4(:,5),wf4(:,11))
  call Hloop_VVS_S(ntryL,G0H16(41),wf4(:,5),ex5(:),G0H4(22),m4h4x1x4(:,22),heltab3x16(:,:,22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(42),m0h(375),h0tab(:,375),[22,9],[nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(42),wf4(:,12),ex5(:),G0H4(23),m4h4x1x4(:,23),heltab3x16(:,:,23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(44),m0h(376),h0tab(:,376),[22,9],[nMW,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(44),wf4(:,12),ex5(:),G0H4(24),m4h4x1x4(:,24),heltab3x16(:,:,24))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(46),m0h(377),h0tab(:,377),[22,9],[nMH,nMZ],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(46),wf4(:,5),ex5(:),G0H4(25),m4h4x1x4(:,25),heltab3x16(:,:,25))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(48),m0h(378),h0tab(:,378),[22,9],[nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(48),wf4(:,5),ex5(:),G0H4(26),m4h4x1x4(:,26),heltab3x16(:,:,26))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(50),m0h(379),h0tab(:,379),[22,9],[nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(50),wf4(:,5),ex5(:),G0H4(27),m4h4x1x4(:,27),heltab3x16(:,:,27))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(51),m0h(380),h0tab(:,380),[25,6],[nMW,nMW],3,2,wf4(:,11),wf4(:,12))
  call Hloop_VVS_S(ntryL,G0H16(51),wf4(:,11),ex5(:),G0H4(28),m4h4x1x4(:,28),heltab3x16(:,:,28))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(53),m0h(381),h0tab(:,381),[25,6],[nMW,nMW],3,2,wf4(:,11),wf4(:,12))
  call Hloop_VVS_S(ntryL,G0H16(53),wf4(:,11),ex5(:),G0H4(29),m4h4x1x4(:,29),heltab3x16(:,:,29))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(54),m0h(382),h0tab(:,382),[25,6],[nMW,nMW],3,2,wf4(:,11),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(54),wf4(:,11),ex5(:),G0H4(30),m4h4x1x4(:,30),heltab3x16(:,:,30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(55),m0h(383),h0tab(:,383),[25,6],[nMW,nMW],3,2,wf4(:,11),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(55),wf4(:,11),ex5(:),G0H4(31),m4h4x1x4(:,31),heltab3x16(:,:,31))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(56),m0h(384),h0tab(:,384),[25,6],[nMW,nMW],3,2,wf4(:,4),wf4(:,12))
  call Hloop_VVS_S(ntryL,G0H16(56),wf4(:,4),ex5(:),G0H4(32),m4h4x1x4(:,32),heltab3x16(:,:,32))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(57),m0h(385),h0tab(:,385),[25,6],[nMW,nMW],3,2,wf4(:,4),wf4(:,12))
  call Hloop_VVS_S(ntryL,G0H16(57),wf4(:,4),ex5(:),G0H4(33),m4h4x1x4(:,33),heltab3x16(:,:,33))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(58),m0h(386),h0tab(:,386),[25,6],[nMH,nMZ],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(58),wf4(:,4),ex5(:),G0H4(34),m4h4x1x4(:,34),heltab3x16(:,:,34))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(59),m0h(387),h0tab(:,387),[25,6],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(59),wf4(:,4),ex5(:),G0H4(35),m4h4x1x4(:,35),heltab3x16(:,:,35))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(60),m0h(388),h0tab(:,388),[25,6],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(60),wf4(:,4),ex5(:),G0H4(36),m4h4x1x4(:,36),heltab3x16(:,:,36))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(61),m0h(389),h0tab(:,389),[21,10],[nML,nML],2,2,wf4(:,27),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(61),wf4(:,27),G0H4(37),ngX,m3h4x4(:,213),heltab2x16(:,:,637))
  call Hloop_Q_A(ntryL,G0H4(37),21,nML,G1H4(6),n2h4(61))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(390),h0tab(:,390),[21,10],[nMT,nMT],2,2,wf4(:,27),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(62),wf4(:,27),G0H4(37),ngX,m3h4x4(:,214),heltab2x16(:,:,638))
  call Hloop_Q_A(ntryL,G0H4(37),21,nMT,G1H4(5),n2h4(62))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(63),m0h(391),h0tab(:,391),[21,10],[nMB,nMB],2,2,wf4(:,27),wf4(:,8))
  call Hloop_QS_A(ntryL,G0H16(63),wf4(:,27),G0H4(37),ngX,m3h4x4(:,215),heltab2x16(:,:,639))
  call Hloop_Q_A(ntryL,G0H4(37),21,nMB,G1H4(4),n2h4(63))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(64),m0h(392),h0tab(:,392),[21,10],[nML,nML],2,2,wf4(:,27),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(64),wf4(:,27),G0H4(37),ngX,m3h4x4(:,216),heltab2x16(:,:,640))
  call Hloop_Q_A(ntryL,G0H4(37),21,nML,G1H4(8),n2h4(64))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(65),m0h(393),h0tab(:,393),[21,10],[nMT,nMT],2,2,wf4(:,27),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(65),wf4(:,27),G0H4(37),ngX,m3h4x4(:,217),heltab2x16(:,:,641))
  call Hloop_Q_A(ntryL,G0H4(37),21,nMT,G1H4(9),n2h4(65))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(66),m0h(394),h0tab(:,394),[21,10],[nMB,nMB],2,2,wf4(:,27),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(66),wf4(:,27),G0H4(37),ngX,m3h4x4(:,218),heltab2x16(:,:,642))
  call Hloop_Q_A(ntryL,G0H4(37),21,nMB,G1H4(10),n2h4(66))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(67),m0h(395),h0tab(:,395),[21,10],[nMH,nMZ],2,2,wf4(:,27),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(67),wf4(:,27),G0H4(37),m3h4x4(:,219),heltab2x16(:,:,643))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(68),m0h(396),h0tab(:,396),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(68),wf4(:,27),G0H4(38),m3h4x4(:,220),heltab2x16(:,:,644))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(69),m0h(397),h0tab(:,397),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,8))
  call Hloop_SS_S(ntryL,G0H16(69),wf4(:,27),G0H4(39),m3h4x4(:,221),heltab2x16(:,:,645))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(70),m0h(398),h0tab(:,398),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(70),wf4(:,27),G0H4(40),m3h4x4(:,222),heltab2x16(:,:,646))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(71),m0h(399),h0tab(:,399),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(71),wf4(:,27),G0H4(41),m3h4x4(:,223),heltab2x16(:,:,647))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(74),m0h(400),h0tab(:,400),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(74),0,wf4(:,27),21,G1H4(11),m3h4x4(:,224),heltab2x16(:,:,648))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(75),m0h(401),h0tab(:,401),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,8))
  call Hloop_VT_S(ntryL,G0H16(75),0,wf4(:,27),21,G1H4(12),m3h4x4(:,225),heltab2x16(:,:,649))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(78),m0h(402),h0tab(:,402),[21,10],[nMH,nMZ],2,2,wf4(:,27),wf4(:,2))
  call Hloop_VS_T(ntryL,G0H16(78),0,wf4(:,27),21,G1H4(13),m3h4x4(:,226),heltab2x16(:,:,650))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(79),m0h(403),h0tab(:,403),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(79),0,wf4(:,27),21,G1H4(14),m3h4x4(:,227),heltab2x16(:,:,651))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(82),m0h(404),h0tab(:,404),[21,10],[nMW,nMW],2,2,wf4(:,27),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(82),0,wf4(:,27),21,G1H4(15),m3h4x4(:,228),heltab2x16(:,:,652))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(83),m0h(405),h0tab(:,405),[21,10],[0,0],2,2,wf4(:,3),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(83),wf4(:,3),G0H4(42),ngZl,m3h4x4(:,229),heltab2x16(:,:,653))
  call Hloop_Q_A(ntryL,G0H4(42),21,0,G1H4(16),n2h4(67))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(86),m0h(406),h0tab(:,406),[21,10],[nML,nML],2,2,wf4(:,3),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(86),wf4(:,3),G0H4(42),ngZl,m3h4x4(:,230),heltab2x16(:,:,654))
  call Hloop_Q_A(ntryL,G0H4(42),21,nML,G1H4(43),n2h4(68))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(87),m0h(407),h0tab(:,407),[21,10],[0,0],2,2,wf4(:,3),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(87),wf4(:,3),G0H4(42),ngZu,m3h4x4(:,231),heltab2x16(:,:,655))
  call Hloop_Q_A(ntryL,G0H4(42),21,0,G1H4(21),n2h4(69))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(88),m0h(408),h0tab(:,408),[21,10],[nMT,nMT],2,2,wf4(:,3),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(88),wf4(:,3),G0H4(42),ngZu,m3h4x4(:,232),heltab2x16(:,:,656))
  call Hloop_Q_A(ntryL,G0H4(42),21,nMT,G1H4(17),n2h4(70))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(89),m0h(409),h0tab(:,409),[21,10],[0,0],2,2,wf4(:,3),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(89),wf4(:,3),G0H4(42),ngZd,m3h4x4(:,233),heltab2x16(:,:,657))
  call Hloop_Q_A(ntryL,G0H4(42),21,0,G1H4(44),n2h4(71))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(90),m0h(410),h0tab(:,410),[21,10],[nMB,nMB],2,2,wf4(:,3),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(90),wf4(:,3),G0H4(42),ngZd,m3h4x4(:,234),heltab2x16(:,:,658))
  call Hloop_Q_A(ntryL,G0H4(42),21,nMB,G1H4(22),n2h4(72))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(91),m0h(411),h0tab(:,411),[21,10],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(91),wf4(:,3),G0H4(42),ngZn,m3h4x4(:,235),heltab2x16(:,:,659))
  call Hloop_Q_A(ntryL,G0H4(42),21,0,G1H4(18),n2h4(73))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(92),m0h(412),h0tab(:,412),[21,10],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(92),wf4(:,3),G0H4(42),ngZl,m3h4x4(:,236),heltab2x16(:,:,660))
  call Hloop_Q_A(ntryL,G0H4(42),21,0,G1H4(45),n2h4(74))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(93),m0h(413),h0tab(:,413),[21,10],[nML,nML],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(93),wf4(:,3),G0H4(42),ngZl,m3h4x4(:,237),heltab2x16(:,:,661))
  call Hloop_Q_A(ntryL,G0H4(42),21,nML,G1H4(25),n2h4(75))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(94),m0h(414),h0tab(:,414),[21,10],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(94),wf4(:,3),G0H4(42),ngZu,m3h4x4(:,238),heltab2x16(:,:,662))
  call Hloop_Q_A(ntryL,G0H4(42),21,0,G1H4(19),n2h4(76))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(95),m0h(415),h0tab(:,415),[21,10],[nMT,nMT],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(95),wf4(:,3),G0H4(42),ngZu,m3h4x4(:,239),heltab2x16(:,:,663))
  call Hloop_Q_A(ntryL,G0H4(42),21,nMT,G1H4(46),n2h4(77))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(97),m0h(416),h0tab(:,416),[21,10],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(97),wf4(:,3),G0H4(42),ngZd,m3h4x4(:,240),heltab2x16(:,:,664))
  call Hloop_Q_A(ntryL,G0H4(42),21,0,G1H4(26),n2h4(78))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(99),m0h(417),h0tab(:,417),[21,10],[nMB,nMB],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(99),wf4(:,3),G0H4(42),ngZd,m3h4x4(:,241),heltab2x16(:,:,665))
  call Hloop_Q_A(ntryL,G0H4(42),21,nMB,G1H4(20),n2h4(79))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(101),m0h(418),h0tab(:,418),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H16(101),0,wf4(:,3),21,G1H4(24),m3h4x4(:,242),heltab2x16(:,:,666))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(102),m0h(419),h0tab(:,419),[21,10],[nMH,nMZ],2,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H16(102),0,wf4(:,3),21,G1H4(27),m3h4x4(:,243),heltab2x16(:,:,667))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(104),m0h(420),h0tab(:,420),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H16(104),0,wf4(:,3),21,G1H4(28),m3h4x4(:,244),heltab2x16(:,:,668))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(106),m0h(421),h0tab(:,421),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H16(106),0,wf4(:,3),21,G1H4(29),m3h4x4(:,245),heltab2x16(:,:,669))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(108),m0h(422),h0tab(:,422),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H16(108),0,wf4(:,3),21,G1H4(30),m3h4x4(:,246),heltab2x16(:,:,670))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(110),m0h(423),h0tab(:,423),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H16(110),0,wf4(:,3),21,G1H4(52),m3h4x4(:,247),heltab2x16(:,:,671))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(111),m0h(424),h0tab(:,424),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H16(111),0,wf4(:,3),21,G1H4(39),m3h4x4(:,248),heltab2x16(:,:,672))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(113),m0h(425),h0tab(:,425),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H16(113),0,wf4(:,3),21,G1H4(35),m3h4x4(:,249),heltab2x16(:,:,673))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(114),m0h(426),h0tab(:,426),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(114),0,wf4(:,3),21,G1H4(53),m3h4x4(:,250),heltab2x16(:,:,674))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(115),m0h(427),h0tab(:,427),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H16(115),wf4(:,3),G0H4(42),m3h4x4(:,251),heltab2x16(:,:,675))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(116),m0h(428),h0tab(:,428),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H16(116),wf4(:,3),G0H4(43),m3h4x4(:,252),heltab2x16(:,:,676))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(117),m0h(429),h0tab(:,429),[21,10],[nMH,nMZ],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(117),wf4(:,3),G0H4(44),m3h4x4(:,253),heltab2x16(:,:,677))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(118),m0h(430),h0tab(:,430),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(118),wf4(:,3),G0H4(45),m3h4x4(:,254),heltab2x16(:,:,678))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(119),m0h(431),h0tab(:,431),[21,10],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(119),wf4(:,3),G0H4(46),m3h4x4(:,255),heltab2x16(:,:,679))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(120),m0h(432),h0tab(:,432),[26,5],[nML,nML],2,2,wf4(:,21),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(120),wf4(:,21),G0H4(47),ngX,m3h4x4(:,256),heltab2x16(:,:,680))
  call Hloop_Q_A(ntryL,G0H4(47),26,nML,G1H4(40),n2h4(80))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(121),m0h(433),h0tab(:,433),[26,5],[nMT,nMT],2,2,wf4(:,21),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(121),wf4(:,21),G0H4(47),ngX,m3h4x4(:,257),heltab2x16(:,:,681))
  call Hloop_Q_A(ntryL,G0H4(47),26,nMT,G1H4(36),n2h4(81))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(122),m0h(434),h0tab(:,434),[26,5],[nMB,nMB],2,2,wf4(:,21),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(122),wf4(:,21),G0H4(47),ngX,m3h4x4(:,258),heltab2x16(:,:,682))
  call Hloop_Q_A(ntryL,G0H4(47),26,nMB,G1H4(54),n2h4(82))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(123),m0h(435),h0tab(:,435),[26,5],[nML,nML],2,2,wf4(:,21),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(123),wf4(:,21),G0H4(47),ngX,m3h4x4(:,259),heltab2x16(:,:,683))
  call Hloop_Q_A(ntryL,G0H4(47),26,nML,G1H4(41),n2h4(83))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(124),m0h(436),h0tab(:,436),[26,5],[nMT,nMT],2,2,wf4(:,21),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(124),wf4(:,21),G0H4(47),ngX,m3h4x4(:,260),heltab2x16(:,:,684))
  call Hloop_Q_A(ntryL,G0H4(47),26,nMT,G1H4(37),n2h4(84))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(125),m0h(437),h0tab(:,437),[26,5],[nMB,nMB],2,2,wf4(:,21),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(125),wf4(:,21),G0H4(47),ngX,m3h4x4(:,261),heltab2x16(:,:,685))
  call Hloop_Q_A(ntryL,G0H4(47),26,nMB,G1H4(55),n2h4(85))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(126),m0h(438),h0tab(:,438),[26,5],[nMH,nMZ],2,2,wf4(:,21),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(126),wf4(:,21),G0H4(47),m3h4x4(:,262),heltab2x16(:,:,686))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(127),m0h(439),h0tab(:,439),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(127),wf4(:,21),G0H4(48),m3h4x4(:,263),heltab2x16(:,:,687))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(128),m0h(440),h0tab(:,440),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(128),wf4(:,21),G0H4(49),m3h4x4(:,264),heltab2x16(:,:,688))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(129),m0h(441),h0tab(:,441),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(129),wf4(:,21),G0H4(50),m3h4x4(:,265),heltab2x16(:,:,689))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(130),m0h(442),h0tab(:,442),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(130),wf4(:,21),G0H4(51),m3h4x4(:,266),heltab2x16(:,:,690))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(131),m0h(443),h0tab(:,443),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(131),0,wf4(:,21),26,G1H4(42),m3h4x4(:,267),heltab2x16(:,:,691))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(132),m0h(444),h0tab(:,444),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(132),0,wf4(:,21),26,G1H4(38),m3h4x4(:,268),heltab2x16(:,:,692))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(133),m0h(445),h0tab(:,445),[26,5],[nMH,nMZ],2,2,wf4(:,21),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H16(133),0,wf4(:,21),26,G1H4(82),m3h4x4(:,269),heltab2x16(:,:,693))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(134),m0h(446),h0tab(:,446),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(134),0,wf4(:,21),26,G1H4(1),m3h4x4(:,270),heltab2x16(:,:,694))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(135),m0h(447),h0tab(:,447),[26,5],[nMW,nMW],2,2,wf4(:,21),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(135),0,wf4(:,21),26,G1H4(3),m3h4x4(:,271),heltab2x16(:,:,695))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(136),m0h(448),h0tab(:,448),[26,5],[0,0],2,2,wf4(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(136),wf4(:,24),G0H4(52),ngZl,m3h4x4(:,272),heltab2x16(:,:,696))
  call Hloop_Q_A(ntryL,G0H4(52),26,0,G1H4(83),n2h4(86))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(137),m0h(449),h0tab(:,449),[26,5],[nML,nML],2,2,wf4(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(137),wf4(:,24),G0H4(52),ngZl,m3h4x4(:,273),heltab2x16(:,:,697))
  call Hloop_Q_A(ntryL,G0H4(52),26,nML,G1H4(7),n2h4(87))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(450),h0tab(:,450),[26,5],[0,0],2,2,wf4(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(19),wf4(:,24),G0H4(52),ngZu,m3h4x4(:,274),heltab2x16(:,:,698))
  call Hloop_Q_A(ntryL,G0H4(52),26,0,G1H4(2),n2h4(88))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(20),m0h(451),h0tab(:,451),[26,5],[nMT,nMT],2,2,wf4(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(20),wf4(:,24),G0H4(52),ngZu,m3h4x4(:,275),heltab2x16(:,:,699))
  call Hloop_Q_A(ntryL,G0H4(52),26,nMT,G1H4(86),n2h4(89))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(24),m0h(452),h0tab(:,452),[26,5],[0,0],2,2,wf4(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(24),wf4(:,24),G0H4(52),ngZd,m3h4x4(:,276),heltab2x16(:,:,700))
  call Hloop_Q_A(ntryL,G0H4(52),26,0,G1H4(64),n2h4(90))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(453),h0tab(:,453),[26,5],[nMB,nMB],2,2,wf4(:,24),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(9),wf4(:,24),G0H4(52),ngZd,m3h4x4(:,277),heltab2x16(:,:,701))
  call Hloop_Q_A(ntryL,G0H4(52),26,nMB,G1H4(60),n2h4(91))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(454),h0tab(:,454),[26,5],[0,0],2,2,wf4(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(12),wf4(:,24),G0H4(52),ngZn,m3h4x4(:,278),heltab2x16(:,:,702))
  call Hloop_Q_A(ntryL,G0H4(52),26,0,G1H4(87),n2h4(92))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(38),m0h(455),h0tab(:,455),[26,5],[0,0],2,2,wf4(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(38),wf4(:,24),G0H4(52),ngZl,m3h4x4(:,279),heltab2x16(:,:,703))
  call Hloop_Q_A(ntryL,G0H4(52),26,0,G1H4(65),n2h4(93))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(43),m0h(456),h0tab(:,456),[26,5],[nML,nML],2,2,wf4(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(43),wf4(:,24),G0H4(52),ngZl,m3h4x4(:,280),heltab2x16(:,:,704))
  call Hloop_Q_A(ntryL,G0H4(52),26,nML,G1H4(61),n2h4(94))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(47),m0h(457),h0tab(:,457),[26,5],[0,0],2,2,wf4(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(47),wf4(:,24),G0H4(52),ngZu,m3h4x4(:,281),heltab2x16(:,:,705))
  call Hloop_Q_A(ntryL,G0H4(52),26,0,G1H4(63),n2h4(95))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(52),m0h(458),h0tab(:,458),[26,5],[nMT,nMT],2,2,wf4(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(52),wf4(:,24),G0H4(52),ngZu,m3h4x4(:,282),heltab2x16(:,:,706))
  call Hloop_Q_A(ntryL,G0H4(52),26,nMT,G1H4(66),n2h4(96))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(73),m0h(459),h0tab(:,459),[26,5],[0,0],2,2,wf4(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(73),wf4(:,24),G0H4(52),ngZd,m3h4x4(:,283),heltab2x16(:,:,707))
  call Hloop_Q_A(ntryL,G0H4(52),26,0,G1H4(67),n2h4(97))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(77),m0h(460),h0tab(:,460),[26,5],[nMB,nMB],2,2,wf4(:,24),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(77),wf4(:,24),G0H4(52),ngZd,m3h4x4(:,284),heltab2x16(:,:,708))
  call Hloop_Q_A(ntryL,G0H4(52),26,nMB,G1H4(70),n2h4(98))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(80),m0h(461),h0tab(:,461),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H16(80),0,wf4(:,24),26,G1H4(71),m3h4x4(:,285),heltab2x16(:,:,709))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(81),m0h(462),h0tab(:,462),[26,5],[nMH,nMZ],2,2,wf4(:,24),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(81),0,wf4(:,24),26,G1H4(91),m3h4x4(:,286),heltab2x16(:,:,710))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(84),m0h(463),h0tab(:,463),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(84),0,wf4(:,24),26,G1H4(76),m3h4x4(:,287),heltab2x16(:,:,711))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(85),m0h(464),h0tab(:,464),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(85),0,wf4(:,24),26,G1H4(74),m3h4x4(:,288),heltab2x16(:,:,712))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(96),m0h(465),h0tab(:,465),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(96),0,wf4(:,24),26,G1H4(92),m3h4x4(:,289),heltab2x16(:,:,713))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(98),m0h(466),h0tab(:,466),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(98),0,wf4(:,24),26,G1H4(77),m3h4x4(:,290),heltab2x16(:,:,714))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(100),m0h(467),h0tab(:,467),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(100),0,wf4(:,24),26,G1H4(75),m3h4x4(:,291),heltab2x16(:,:,715))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(103),m0h(468),h0tab(:,468),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H16(103),0,wf4(:,24),26,G1H4(95),m3h4x4(:,292),heltab2x16(:,:,716))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(105),m0h(469),h0tab(:,469),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(105),0,wf4(:,24),26,G1H4(80),m3h4x4(:,293),heltab2x16(:,:,717))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(107),m0h(470),h0tab(:,470),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(107),wf4(:,24),G0H4(52),m3h4x4(:,294),heltab2x16(:,:,718))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(109),m0h(471),h0tab(:,471),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(109),wf4(:,24),G0H4(53),m3h4x4(:,295),heltab2x16(:,:,719))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(112),m0h(472),h0tab(:,472),[26,5],[nMH,nMZ],2,2,wf4(:,24),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(112),wf4(:,24),G0H4(54),m3h4x4(:,296),heltab2x16(:,:,720))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(473),h0tab(:,473),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(5),wf4(:,24),G0H4(55),m3h4x4(:,297),heltab2x16(:,:,721))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(474),h0tab(:,474),[26,5],[nMW,nMW],2,2,wf4(:,24),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(23),wf4(:,24),G0H4(56),m3h4x4(:,298),heltab2x16(:,:,722))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(475),h0tab(:,475),[25,6],[nML,nML],2,2,wf4(:,38),wf4(:,12))
  call Hloop_QS_A(ntryL,G0H16(25),wf4(:,38),G0H4(57),ngX,m3h4x4(:,299),heltab2x16(:,:,723))
  call Hloop_Q_A(ntryL,G0H4(57),25,nML,G1H4(78),n2h4(99))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(476),h0tab(:,476),[25,6],[nMT,nMT],2,2,wf4(:,38),wf4(:,12))
  call Hloop_QS_A(ntryL,G0H16(27),wf4(:,38),G0H4(57),ngX,m3h4x4(:,300),heltab2x16(:,:,724))
  call Hloop_Q_A(ntryL,G0H4(57),25,nMT,G1H4(96),n2h4(100))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(29),m0h(477),h0tab(:,477),[25,6],[nMB,nMB],2,2,wf4(:,38),wf4(:,12))
  call Hloop_QS_A(ntryL,G0H16(29),wf4(:,38),G0H4(57),ngX,m3h4x4(:,301),heltab2x16(:,:,725))
  call Hloop_Q_A(ntryL,G0H4(57),25,nMB,G1H4(81),n2h4(101))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(478),h0tab(:,478),[25,6],[nML,nML],2,2,wf4(:,38),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(4),wf4(:,38),G0H4(57),ngX,m3h4x4(:,302),heltab2x16(:,:,726))
  call Hloop_Q_A(ntryL,G0H4(57),25,nML,G1H4(79),n2h4(102))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(479),h0tab(:,479),[25,6],[nMT,nMT],2,2,wf4(:,38),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(14),wf4(:,38),G0H4(57),ngX,m3h4x4(:,303),heltab2x16(:,:,727))
  call Hloop_Q_A(ntryL,G0H4(57),25,nMT,G1H4(47),n2h4(103))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(480),h0tab(:,480),[25,6],[nMB,nMB],2,2,wf4(:,38),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(3),wf4(:,38),G0H4(57),ngX,m3h4x4(:,304),heltab2x16(:,:,728))
  call Hloop_Q_A(ntryL,G0H4(57),25,nMB,G1H4(48),n2h4(104))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(481),h0tab(:,481),[25,6],[nMH,nMZ],2,2,wf4(:,38),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),wf4(:,38),G0H4(57),m3h4x4(:,305),heltab2x16(:,:,729))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(482),h0tab(:,482),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(6),wf4(:,38),G0H4(58),m3h4x4(:,306),heltab2x16(:,:,730))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(483),h0tab(:,483),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(21),wf4(:,38),G0H4(59),m3h4x4(:,307),heltab2x16(:,:,731))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(484),h0tab(:,484),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(22),wf4(:,38),G0H4(60),m3h4x4(:,308),heltab2x16(:,:,732))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(485),h0tab(:,485),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(15),wf4(:,38),G0H4(61),m3h4x4(:,309),heltab2x16(:,:,733))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(31),m0h(486),h0tab(:,486),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,12))
  call Hloop_VT_S(ntryL,G0H16(31),0,wf4(:,38),25,G1H4(50),m3h4x4(:,310),heltab2x16(:,:,734))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(33),m0h(487),h0tab(:,487),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,12))
  call Hloop_VT_S(ntryL,G0H16(33),0,wf4(:,38),25,G1H4(51),m3h4x4(:,311),heltab2x16(:,:,735))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(488),h0tab(:,488),[25,6],[nMH,nMZ],2,2,wf4(:,38),wf4(:,5))
  call Hloop_VS_T(ntryL,G0H16(35),0,wf4(:,38),25,G1H4(23),m3h4x4(:,312),heltab2x16(:,:,736))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(37),m0h(489),h0tab(:,489),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(37),0,wf4(:,38),25,G1H4(49),m3h4x4(:,313),heltab2x16(:,:,737))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(39),m0h(490),h0tab(:,490),[25,6],[nMW,nMW],2,2,wf4(:,38),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(39),0,wf4(:,38),25,G1H4(31),m3h4x4(:,314),heltab2x16(:,:,738))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(41),m0h(491),h0tab(:,491),[25,6],[0,0],2,2,wf4(:,6),wf4(:,12))
  call Hloop_QZ_A(ntryL,G0H16(41),wf4(:,6),G0H4(62),ngZl,m3h4x4(:,315),heltab2x16(:,:,739))
  call Hloop_Q_A(ntryL,G0H4(62),25,0,G1H4(32),n2h4(105))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(42),m0h(492),h0tab(:,492),[25,6],[nML,nML],2,2,wf4(:,6),wf4(:,12))
  call Hloop_QZ_A(ntryL,G0H16(42),wf4(:,6),G0H4(62),ngZl,m3h4x4(:,316),heltab2x16(:,:,740))
  call Hloop_Q_A(ntryL,G0H4(62),25,nML,G1H4(33),n2h4(106))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(44),m0h(493),h0tab(:,493),[25,6],[0,0],2,2,wf4(:,6),wf4(:,12))
  call Hloop_QZ_A(ntryL,G0H16(44),wf4(:,6),G0H4(62),ngZu,m3h4x4(:,317),heltab2x16(:,:,741))
  call Hloop_Q_A(ntryL,G0H4(62),25,0,G1H4(34),n2h4(107))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(46),m0h(494),h0tab(:,494),[25,6],[nMT,nMT],2,2,wf4(:,6),wf4(:,12))
  call Hloop_QZ_A(ntryL,G0H16(46),wf4(:,6),G0H4(62),ngZu,m3h4x4(:,318),heltab2x16(:,:,742))
  call Hloop_Q_A(ntryL,G0H4(62),25,nMT,G1H4(56),n2h4(108))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(48),m0h(495),h0tab(:,495),[25,6],[0,0],2,2,wf4(:,6),wf4(:,12))
  call Hloop_QZ_A(ntryL,G0H16(48),wf4(:,6),G0H4(62),ngZd,m3h4x4(:,319),heltab2x16(:,:,743))
  call Hloop_Q_A(ntryL,G0H4(62),25,0,G1H4(57),n2h4(109))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(50),m0h(496),h0tab(:,496),[25,6],[nMB,nMB],2,2,wf4(:,6),wf4(:,12))
  call Hloop_QZ_A(ntryL,G0H16(50),wf4(:,6),G0H4(62),ngZd,m3h4x4(:,320),heltab2x16(:,:,744))
  call Hloop_Q_A(ntryL,G0H4(62),25,nMB,G1H4(58),n2h4(110))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(51),m0h(497),h0tab(:,497),[25,6],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(51),wf4(:,6),G0H4(62),ngZn,m3h4x4(:,321),heltab2x16(:,:,745))
  call Hloop_Q_A(ntryL,G0H4(62),25,0,G1H4(59),n2h4(111))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(53),m0h(498),h0tab(:,498),[25,6],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(53),wf4(:,6),G0H4(62),ngZl,m3h4x4(:,322),heltab2x16(:,:,746))
  call Hloop_Q_A(ntryL,G0H4(62),25,0,G1H4(84),n2h4(112))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(54),m0h(499),h0tab(:,499),[25,6],[nML,nML],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(54),wf4(:,6),G0H4(62),ngZl,m3h4x4(:,323),heltab2x16(:,:,747))
  call Hloop_Q_A(ntryL,G0H4(62),25,nML,G1H4(85),n2h4(113))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(55),m0h(500),h0tab(:,500),[25,6],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(55),wf4(:,6),G0H4(62),ngZu,m3h4x4(:,324),heltab2x16(:,:,748))
  call Hloop_Q_A(ntryL,G0H4(62),25,0,G1H4(89),n2h4(114))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(56),m0h(501),h0tab(:,501),[25,6],[nMT,nMT],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(56),wf4(:,6),G0H4(62),ngZu,m3h4x4(:,325),heltab2x16(:,:,749))
  call Hloop_Q_A(ntryL,G0H4(62),25,nMT,G1H4(90),n2h4(115))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(57),m0h(502),h0tab(:,502),[25,6],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(57),wf4(:,6),G0H4(62),ngZd,m3h4x4(:,326),heltab2x16(:,:,750))
  call Hloop_Q_A(ntryL,G0H4(62),25,0,G1H4(62),n2h4(116))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(58),m0h(503),h0tab(:,503),[25,6],[nMB,nMB],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(58),wf4(:,6),G0H4(62),ngZd,m3h4x4(:,327),heltab2x16(:,:,751))
  call Hloop_Q_A(ntryL,G0H4(62),25,nMB,G1H4(88),n2h4(117))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(59),m0h(504),h0tab(:,504),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,12))
  call Hloop_TV_S(ntryL,G0H16(59),0,wf4(:,6),25,G1H4(68),m3h4x4(:,328),heltab2x16(:,:,752))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(60),m0h(505),h0tab(:,505),[25,6],[nMH,nMZ],2,2,wf4(:,6),wf4(:,5))
  call Hloop_SV_T(ntryL,G0H16(60),0,wf4(:,6),25,G1H4(69),m3h4x4(:,329),heltab2x16(:,:,753))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(61),m0h(506),h0tab(:,506),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H16(61),0,wf4(:,6),25,G1H4(72),m3h4x4(:,330),heltab2x16(:,:,754))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(507),h0tab(:,507),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H16(62),0,wf4(:,6),25,G1H4(73),m3h4x4(:,331),heltab2x16(:,:,755))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(63),m0h(508),h0tab(:,508),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H16(63),0,wf4(:,6),25,G1H4(93),m3h4x4(:,332),heltab2x16(:,:,756))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(64),m0h(509),h0tab(:,509),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(64),0,wf4(:,6),25,G1H4(94),m3h4x4(:,333),heltab2x16(:,:,757))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(65),m0h(510),h0tab(:,510),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(65),0,wf4(:,6),25,G1H4(97),m3h4x4(:,334),heltab2x16(:,:,758))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(66),m0h(511),h0tab(:,511),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H16(66),0,wf4(:,6),25,G1H4(98),m3h4x4(:,335),heltab2x16(:,:,759))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(67),m0h(512),h0tab(:,512),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(67),0,wf4(:,6),25,G1H4(99),m3h4x4(:,336),heltab2x16(:,:,760))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(68),m0h(513),h0tab(:,513),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H16(68),wf4(:,6),G0H4(62),m3h4x4(:,337),heltab2x16(:,:,761))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(69),m0h(514),h0tab(:,514),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,12))
  call Hloop_VV_S(ntryL,G0H16(69),wf4(:,6),G0H4(63),m3h4x4(:,338),heltab2x16(:,:,762))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(70),m0h(515),h0tab(:,515),[25,6],[nMH,nMZ],2,2,wf4(:,6),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(70),wf4(:,6),G0H4(64),m3h4x4(:,339),heltab2x16(:,:,763))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(71),m0h(516),h0tab(:,516),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(71),wf4(:,6),G0H4(65),m3h4x4(:,340),heltab2x16(:,:,764))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(74),m0h(517),h0tab(:,517),[25,6],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(74),wf4(:,6),G0H4(66),m3h4x4(:,341),heltab2x16(:,:,765))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(75),m0h(518),h0tab(:,518),[22,9],[nML,nML],2,2,wf4(:,32),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(75),wf4(:,32),G0H4(67),ngX,m3h4x4(:,342),heltab2x16(:,:,766))
  call Hloop_Q_A(ntryL,G0H4(67),22,nML,G1H4(100),n2h4(118))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(78),m0h(519),h0tab(:,519),[22,9],[nMT,nMT],2,2,wf4(:,32),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(78),wf4(:,32),G0H4(67),ngX,m3h4x4(:,343),heltab2x16(:,:,767))
  call Hloop_Q_A(ntryL,G0H4(67),22,nMT,G1H4(101),n2h4(119))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(79),m0h(520),h0tab(:,520),[22,9],[nMB,nMB],2,2,wf4(:,32),wf4(:,11))
  call Hloop_QS_A(ntryL,G0H16(79),wf4(:,32),G0H4(67),ngX,m3h4x4(:,344),heltab2x16(:,:,768))
  call Hloop_Q_A(ntryL,G0H4(67),22,nMB,G1H4(102),n2h4(120))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(82),m0h(521),h0tab(:,521),[22,9],[nML,nML],2,2,wf4(:,32),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(82),wf4(:,32),G0H4(67),ngX,m3h4x4(:,345),heltab2x16(:,:,769))
  call Hloop_Q_A(ntryL,G0H4(67),22,nML,G1H4(103),n2h4(121))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(83),m0h(522),h0tab(:,522),[22,9],[nMT,nMT],2,2,wf4(:,32),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(83),wf4(:,32),G0H4(67),ngX,m3h4x4(:,346),heltab2x16(:,:,770))
  call Hloop_Q_A(ntryL,G0H4(67),22,nMT,G1H4(104),n2h4(122))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(86),m0h(523),h0tab(:,523),[22,9],[nMB,nMB],2,2,wf4(:,32),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(86),wf4(:,32),G0H4(67),ngX,m3h4x4(:,347),heltab2x16(:,:,771))
  call Hloop_Q_A(ntryL,G0H4(67),22,nMB,G1H4(105),n2h4(123))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(87),m0h(524),h0tab(:,524),[22,9],[nMH,nMZ],2,2,wf4(:,32),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(87),wf4(:,32),G0H4(67),m3h4x4(:,348),heltab2x16(:,:,772))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(88),m0h(525),h0tab(:,525),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(88),wf4(:,32),G0H4(68),m3h4x4(:,349),heltab2x16(:,:,773))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(89),m0h(526),h0tab(:,526),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,11))
  call Hloop_SS_S(ntryL,G0H16(89),wf4(:,32),G0H4(69),m3h4x4(:,350),heltab2x16(:,:,774))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(90),m0h(527),h0tab(:,527),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(90),wf4(:,32),G0H4(70),m3h4x4(:,351),heltab2x16(:,:,775))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(91),m0h(528),h0tab(:,528),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(91),wf4(:,32),G0H4(71),m3h4x4(:,352),heltab2x16(:,:,776))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(92),m0h(529),h0tab(:,529),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(92),0,wf4(:,32),22,G1H4(106),m3h4x4(:,353),heltab2x16(:,:,777))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(93),m0h(530),h0tab(:,530),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,11))
  call Hloop_VT_S(ntryL,G0H16(93),0,wf4(:,32),22,G1H4(107),m3h4x4(:,354),heltab2x16(:,:,778))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(94),m0h(531),h0tab(:,531),[22,9],[nMH,nMZ],2,2,wf4(:,32),wf4(:,4))
  call Hloop_VS_T(ntryL,G0H16(94),0,wf4(:,32),22,G1H4(108),m3h4x4(:,355),heltab2x16(:,:,779))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(95),m0h(532),h0tab(:,532),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(95),0,wf4(:,32),22,G1H4(109),m3h4x4(:,356),heltab2x16(:,:,780))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(97),m0h(533),h0tab(:,533),[22,9],[nMW,nMW],2,2,wf4(:,32),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(97),0,wf4(:,32),22,G1H4(110),m3h4x4(:,357),heltab2x16(:,:,781))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(99),m0h(534),h0tab(:,534),[22,9],[0,0],2,2,wf4(:,35),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H16(99),wf4(:,35),G0H4(72),ngZl,m3h4x4(:,358),heltab2x16(:,:,782))
  call Hloop_Q_A(ntryL,G0H4(72),22,0,G1H4(111),n2h4(124))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(101),m0h(535),h0tab(:,535),[22,9],[nML,nML],2,2,wf4(:,35),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H16(101),wf4(:,35),G0H4(72),ngZl,m3h4x4(:,359),heltab2x16(:,:,783))
  call Hloop_Q_A(ntryL,G0H4(72),22,nML,G1H4(112),n2h4(125))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(102),m0h(536),h0tab(:,536),[22,9],[0,0],2,2,wf4(:,35),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H16(102),wf4(:,35),G0H4(72),ngZu,m3h4x4(:,360),heltab2x16(:,:,784))
  call Hloop_Q_A(ntryL,G0H4(72),22,0,G1H4(113),n2h4(126))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(104),m0h(537),h0tab(:,537),[22,9],[nMT,nMT],2,2,wf4(:,35),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H16(104),wf4(:,35),G0H4(72),ngZu,m3h4x4(:,361),heltab2x16(:,:,785))
  call Hloop_Q_A(ntryL,G0H4(72),22,nMT,G1H4(114),n2h4(127))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(106),m0h(538),h0tab(:,538),[22,9],[0,0],2,2,wf4(:,35),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H16(106),wf4(:,35),G0H4(72),ngZd,m3h4x4(:,362),heltab2x16(:,:,786))
  call Hloop_Q_A(ntryL,G0H4(72),22,0,G1H4(115),n2h4(128))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(108),m0h(539),h0tab(:,539),[22,9],[nMB,nMB],2,2,wf4(:,35),wf4(:,11))
  call Hloop_QZ_A(ntryL,G0H16(108),wf4(:,35),G0H4(72),ngZd,m3h4x4(:,363),heltab2x16(:,:,787))
  call Hloop_Q_A(ntryL,G0H4(72),22,nMB,G1H4(116),n2h4(129))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(110),m0h(540),h0tab(:,540),[22,9],[0,0],2,2,wf4(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(110),wf4(:,35),G0H4(72),ngZn,m3h4x4(:,364),heltab2x16(:,:,788))
  call Hloop_Q_A(ntryL,G0H4(72),22,0,G1H4(117),n2h4(130))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(111),m0h(541),h0tab(:,541),[22,9],[0,0],2,2,wf4(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(111),wf4(:,35),G0H4(72),ngZl,m3h4x4(:,365),heltab2x16(:,:,789))
  call Hloop_Q_A(ntryL,G0H4(72),22,0,G1H4(118),n2h4(131))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(113),m0h(542),h0tab(:,542),[22,9],[nML,nML],2,2,wf4(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(113),wf4(:,35),G0H4(72),ngZl,m3h4x4(:,366),heltab2x16(:,:,790))
  call Hloop_Q_A(ntryL,G0H4(72),22,nML,G1H4(119),n2h4(132))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(114),m0h(543),h0tab(:,543),[22,9],[0,0],2,2,wf4(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(114),wf4(:,35),G0H4(72),ngZu,m3h4x4(:,367),heltab2x16(:,:,791))
  call Hloop_Q_A(ntryL,G0H4(72),22,0,G1H4(120),n2h4(133))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(115),m0h(544),h0tab(:,544),[22,9],[nMT,nMT],2,2,wf4(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(115),wf4(:,35),G0H4(72),ngZu,m3h4x4(:,368),heltab2x16(:,:,792))
  call Hloop_Q_A(ntryL,G0H4(72),22,nMT,G1H4(121),n2h4(134))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(116),m0h(545),h0tab(:,545),[22,9],[0,0],2,2,wf4(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(116),wf4(:,35),G0H4(72),ngZd,m3h4x4(:,369),heltab2x16(:,:,793))
  call Hloop_Q_A(ntryL,G0H4(72),22,0,G1H4(122),n2h4(135))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(117),m0h(546),h0tab(:,546),[22,9],[nMB,nMB],2,2,wf4(:,35),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(117),wf4(:,35),G0H4(72),ngZd,m3h4x4(:,370),heltab2x16(:,:,794))
  call Hloop_Q_A(ntryL,G0H4(72),22,nMB,G1H4(123),n2h4(136))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(118),m0h(547),h0tab(:,547),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,11))
  call Hloop_TV_S(ntryL,G0H16(118),0,wf4(:,35),22,G1H4(124),m3h4x4(:,371),heltab2x16(:,:,795))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(119),m0h(548),h0tab(:,548),[22,9],[nMH,nMZ],2,2,wf4(:,35),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H16(119),0,wf4(:,35),22,G1H4(125),m3h4x4(:,372),heltab2x16(:,:,796))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(120),m0h(549),h0tab(:,549),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H16(120),0,wf4(:,35),22,G1H4(126),m3h4x4(:,373),heltab2x16(:,:,797))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(121),m0h(550),h0tab(:,550),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,11))
  call Hloop_CV_D(ntryL,G0H16(121),0,wf4(:,35),22,G1H4(127),m3h4x4(:,374),heltab2x16(:,:,798))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(122),m0h(551),h0tab(:,551),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,11))
  call Hloop_CV_D(ntryL,G0H16(122),0,wf4(:,35),22,G1H4(128),m3h4x4(:,375),heltab2x16(:,:,799))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(123),m0h(552),h0tab(:,552),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H16(123),0,wf4(:,35),22,G1H4(129),m3h4x4(:,376),heltab2x16(:,:,800))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(124),m0h(553),h0tab(:,553),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H16(124),0,wf4(:,35),22,G1H4(130),m3h4x4(:,377),heltab2x16(:,:,801))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(125),m0h(554),h0tab(:,554),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H16(125),0,wf4(:,35),22,G1H4(131),m3h4x4(:,378),heltab2x16(:,:,802))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(126),m0h(555),h0tab(:,555),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H16(126),0,wf4(:,35),22,G1H4(132),m3h4x4(:,379),heltab2x16(:,:,803))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(127),m0h(556),h0tab(:,556),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H16(127),wf4(:,35),G0H4(72),m3h4x4(:,380),heltab2x16(:,:,804))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(128),m0h(557),h0tab(:,557),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,11))
  call Hloop_VV_S(ntryL,G0H16(128),wf4(:,35),G0H4(73),m3h4x4(:,381),heltab2x16(:,:,805))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(129),m0h(558),h0tab(:,558),[22,9],[nMH,nMZ],2,2,wf4(:,35),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H16(129),wf4(:,35),G0H4(74),m3h4x4(:,382),heltab2x16(:,:,806))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(130),m0h(559),h0tab(:,559),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H16(130),wf4(:,35),G0H4(75),m3h4x4(:,383),heltab2x16(:,:,807))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(131),m0h(560),h0tab(:,560),[22,9],[nMW,nMW],2,2,wf4(:,35),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H16(131),wf4(:,35),G0H4(76),m3h4x4(:,384),heltab2x16(:,:,808))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(42),G0H4(53),G0H4(52),G0H4(2),G0H4(5),G0H4(1) &
    ,G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(1),G0H4(56),G0H4(55),G0H4(9),G0H4(7),G0H4(6) &
    ,G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G0H4(54),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(11),G0H4(43),G0H4(42),G0H4(16),G0H4(17) &
    ,G0H4(11),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(14),G0H4(46),G0H4(45),G0H4(19),G0H4(18) &
    ,G0H4(13),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G0H4(44),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(106),G0H4(73),G0H4(72),G0H4(22),G0H4(21) &
    ,G0H4(14),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(109),G0H4(76),G0H4(75),G0H4(27),G0H4(26) &
    ,G0H4(24),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G0H4(74),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(50),G0H4(63),G0H4(62),G0H4(33),G0H4(32) &
    ,G0H4(29),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(49),G0H4(66),G0H4(65),G0H4(36),G0H4(35) &
    ,G0H4(31),G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G0H4(64),G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(29),G0H4(39),G0H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(52),G0H4(41),G0H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(21),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(74),G0H4(49),G0H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(77),G0H4(51),G0H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(2),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G0H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G1H4(73),G0H4(59),G0H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(94),G0H4(61),G0H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(34),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G0H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(127),G0H4(69),G0H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(129),G0H4(71),G0H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(113),G1H4(111)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(13),wf4(:,7),wf4(:,8),G0tensor(345),m4h4x4x1(:,1),heltab3x16(:,:,37))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(7),wf4(:,2),wf4(:,7),G0tensor(354),m4h4x4x1(:,2),heltab3x16(:,:,38))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(16),wf4(:,1),wf4(:,8),G0tensor(350),m4h4x4x1(:,3),heltab3x16(:,:,39))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(26),wf4(:,1),wf4(:,2),G0tensor(358),m4h4x4x1(:,4),heltab3x16(:,:,40))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(36),wf4(:,1),wf4(:,2),G0tensor(359),m4h4x4x1(:,5),heltab3x16(:,:,41))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(40),wf4(:,1),wf4(:,2),G0tensor(383),m4h4x4x1(:,6),heltab3x16(:,:,42))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(45),wf4(:,7),wf4(:,8),G0tensor(384),m4h4x4x1(:,7),heltab3x16(:,:,43))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(49),wf4(:,2),wf4(:,7),G0tensor(388),m4h4x4x1(:,8),heltab3x16(:,:,44))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(72),wf4(:,1),wf4(:,8),G0tensor(398),m4h4x4x1(:,9),heltab3x16(:,:,45))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(76),wf4(:,1),wf4(:,2),G0tensor(399),m4h4x4x1(:,10),heltab3x16(:,:,46))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(38),wf4(:,7),G1tensor(31),m3h4x1(:,89),heltab2x4(:,:,127))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(3),wf4(:,1),G1tensor(61),m3h4x1(:,90),heltab2x4(:,:,128))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(82),wf4(:,1),G1tensor(91),m3h4x1(:,91),heltab2x4(:,:,129))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(12),wf4(:,8),G1tensor(44),m3h4x1(:,92),heltab2x4(:,:,130))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(15),wf4(:,2),G1tensor(45),m3h4x1(:,93),heltab2x4(:,:,131))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(13),wf4(:,2),G1tensor(46),m3h4x1(:,94),heltab2x4(:,:,132))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(10),wf4(:,11),wf4(:,12),G0tensor(1),m4h4x4x1(:,11),heltab3x16(:,:,47))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(18),wf4(:,5),wf4(:,11),G0tensor(6),m4h4x4x1(:,12),heltab3x16(:,:,48))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(11),wf4(:,4),wf4(:,12),G0tensor(207),m4h4x4x1(:,13),heltab3x16(:,:,49))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(28),wf4(:,4),wf4(:,5),G0tensor(369),m4h4x4x1(:,14),heltab3x16(:,:,50))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(2),wf4(:,4),wf4(:,5),G0tensor(212),m4h4x4x1(:,15),heltab3x16(:,:,51))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(17),wf4(:,4),wf4(:,5),G0tensor(205),m4h4x4x1(:,16),heltab3x16(:,:,52))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(1),wf4(:,11),wf4(:,12),G0tensor(228),m4h4x4x1(:,17),heltab3x16(:,:,53))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(30),wf4(:,5),wf4(:,11),G0tensor(11),m4h4x4x1(:,18),heltab3x16(:,:,54))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(32),wf4(:,4),wf4(:,12),G0tensor(295),m4h4x4x1(:,19),heltab3x16(:,:,55))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(34),wf4(:,4),wf4(:,5),G0tensor(36),m4h4x4x1(:,20),heltab3x16(:,:,56))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(107),wf4(:,11),G1tensor(4),m3h4x1(:,95),heltab2x4(:,:,133))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(110),wf4(:,4),G1tensor(48),m3h4x1(:,96),heltab2x4(:,:,134))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(108),wf4(:,4),G1tensor(50),m3h4x1(:,97),heltab2x4(:,:,135))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(51),wf4(:,12),G1tensor(51),m3h4x1(:,98),heltab2x4(:,:,136))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(31),wf4(:,5),G1tensor(52),m3h4x1(:,99),heltab2x4(:,:,137))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(23),wf4(:,5),G1tensor(54),m3h4x1(:,100),heltab2x4(:,:,138))
  call Hloop_QV_A(ntryL,G1H4(43),wf4(:,8),G1H1(1),m3h4x1(:,101),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(40),n2h1(37))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,8),G1H1(1),m3h4x1(:,102),heltab2x4(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(39),n2h1(38))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,8),G1H1(1),m3h4x1(:,103),heltab2x4(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,104),heltab2x4(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(37),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H4(46),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,105),heltab2x4(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(36),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,106),heltab2x4(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(42))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(27),21,wf4(:,2),10,G2tensor(32),m3h4x1(:,107),heltab2x4(:,:,145))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(30),21,wf4(:,8),10,G2tensor(22),m3h4x1(:,108),heltab2x4(:,:,146))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(39),21,wf4(:,2),10,G2tensor(11),m3h4x1(:,109),heltab2x4(:,:,147))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,8),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,111),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H4(45),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,112),heltab2x4(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,113),heltab2x4(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,114),heltab2x4(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(47))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(24),21,wf4(:,8),10,G2tensor(24),m3h4x1(:,115),heltab2x4(:,:,153))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(28),21,wf4(:,2),10,G2tensor(30),m3h4x1(:,116),heltab2x4(:,:,154))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(35),21,wf4(:,8),10,G2tensor(31),m3h4x1(:,117),heltab2x4(:,:,155))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(53),21,wf4(:,2),10,G2tensor(19),m3h4x1(:,118),heltab2x4(:,:,156))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,7),G1H1(1),m3h4x1(:,119),heltab2x4(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(20),n2h1(48))
  call Hloop_QV_A(ntryL,G1H4(86),wf4(:,7),G1H1(1),m3h4x1(:,120),heltab2x4(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(21),n2h1(49))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,7),G1H1(1),m3h4x1(:,121),heltab2x4(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(8),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H4(61),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,122),heltab2x4(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(9),n2h1(51))
  call Hloop_QZ_A(ntryL,G1H4(66),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,123),heltab2x4(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(10),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H4(70),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,124),heltab2x4(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(53))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(91),26,wf4(:,1),5,G2tensor(26),m3h4x1(:,125),heltab2x4(:,:,163))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(92),26,wf4(:,7),5,G2tensor(27),m3h4x1(:,126),heltab2x4(:,:,164))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(75),26,wf4(:,1),5,G2tensor(3),m3h4x1(:,127),heltab2x4(:,:,165))
  call Hloop_QV_A(ntryL,G1H4(64),wf4(:,7),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(54))
  call Hloop_QZ_A(ntryL,G1H4(87),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,129),heltab2x4(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H4(65),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,130),heltab2x4(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(56))
  call Hloop_QZ_A(ntryL,G1H4(63),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,131),heltab2x4(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(57))
  call Hloop_QZ_A(ntryL,G1H4(67),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,132),heltab2x4(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(58))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(71),26,wf4(:,7),5,G2tensor(46),m3h4x1(:,133),heltab2x4(:,:,171))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(76),26,wf4(:,1),5,G2tensor(41),m3h4x1(:,134),heltab2x4(:,:,172))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(95),26,wf4(:,7),5,G2tensor(50),m3h4x1(:,135),heltab2x4(:,:,173))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(80),26,wf4(:,1),5,G2tensor(23),m3h4x1(:,136),heltab2x4(:,:,174))
  call Hloop_QV_A(ntryL,G1H4(33),wf4(:,12),G1H1(1),m3h4x1(:,137),heltab2x4(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(29),n2h1(59))
  call Hloop_QV_A(ntryL,G1H4(56),wf4(:,12),G1H1(1),m3h4x1(:,138),heltab2x4(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(54),n2h1(60))
  call Hloop_QV_A(ntryL,G1H4(58),wf4(:,12),G1H1(1),m3h4x1(:,139),heltab2x4(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(2),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H4(85),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,140),heltab2x4(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(6),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H4(90),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,141),heltab2x4(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(12),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H4(88),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,142),heltab2x4(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(64))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(69),25,wf4(:,5),6,G2tensor(18),m3h4x1(:,143),heltab2x4(:,:,181))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(93),25,wf4(:,12),6,G2tensor(14),m3h4x1(:,144),heltab2x4(:,:,182))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(97),25,wf4(:,5),6,G2tensor(42),m3h4x1(:,145),heltab2x4(:,:,183))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,12),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,5),G1H1(1),ngZn,m3h4x1(:,147),heltab2x4(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H4(84),wf4(:,5),G1H1(1),ngZl,m3h4x1(:,148),heltab2x4(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H4(89),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,149),heltab2x4(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(68))
  call Hloop_QZ_A(ntryL,G1H4(62),wf4(:,5),G1H1(1),ngZd,m3h4x1(:,150),heltab2x4(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(69))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(68),25,wf4(:,12),6,G2tensor(49),m3h4x1(:,151),heltab2x4(:,:,189))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(72),25,wf4(:,5),6,G2tensor(51),m3h4x1(:,152),heltab2x4(:,:,190))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(98),25,wf4(:,12),6,G2tensor(52),m3h4x1(:,153),heltab2x4(:,:,191))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(99),25,wf4(:,5),6,G2tensor(53),m3h4x1(:,154),heltab2x4(:,:,192))
  call Hloop_QV_A(ntryL,G1H4(112),wf4(:,11),G1H1(1),m3h4x1(:,155),heltab2x4(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(55),n2h1(70))
  call Hloop_QV_A(ntryL,G1H4(114),wf4(:,11),G1H1(1),m3h4x1(:,156),heltab2x4(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(71))
  call Hloop_QV_A(ntryL,G1H4(116),wf4(:,11),G1H1(1),m3h4x1(:,157),heltab2x4(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H4(119),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,158),heltab2x4(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(58),n2h1(73))
  call Hloop_QZ_A(ntryL,G1H4(121),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,159),heltab2x4(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(59),n2h1(74))
  call Hloop_QZ_A(ntryL,G1H4(123),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,160),heltab2x4(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(75))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(125),22,wf4(:,4),9,G2tensor(61),m3h4x1(:,161),heltab2x4(:,:,199))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(128),22,wf4(:,11),9,G2tensor(62),m3h4x1(:,162),heltab2x4(:,:,200))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(130),22,wf4(:,4),9,G2tensor(63),m3h4x1(:,163),heltab2x4(:,:,201))
  call Hloop_QV_A(ntryL,G1H4(115),wf4(:,11),G1H1(1),m3h4x1(:,164),heltab2x4(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(76))
  call Hloop_QZ_A(ntryL,G1H4(117),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,165),heltab2x4(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(77))
  call Hloop_QZ_A(ntryL,G1H4(118),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,166),heltab2x4(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(78))
  call Hloop_QZ_A(ntryL,G1H4(120),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,167),heltab2x4(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(79))
  call Hloop_QZ_A(ntryL,G1H4(122),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,168),heltab2x4(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(80))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(124),22,wf4(:,11),9,G2tensor(69),m3h4x1(:,169),heltab2x4(:,:,207))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(126),22,wf4(:,4),9,G2tensor(70),m3h4x1(:,170),heltab2x4(:,:,208))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(131),22,wf4(:,11),9,G2tensor(71),m3h4x1(:,171),heltab2x4(:,:,209))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(132),22,wf4(:,4),9,G2tensor(72),m3h4x1(:,172),heltab2x4(:,:,210))
  call ol_merge_tensors(G0tensor(173),[G0tensor(78),G0tensor(60),G0tensor(355),G0tensor(141),G0tensor(16)])
  call ol_merge_tensors(G0tensor(232),[G0tensor(69),G0tensor(9),G0tensor(259),G0tensor(235),G0tensor(96),G0tensor(21)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(71),G2tensor(70),G2tensor(69),G2tensor(63),G2tensor(62),G1tensor(48),G1tensor(4) &
    ,G0tensor(389),G0tensor(238),G0tensor(260),G0tensor(46),G0tensor(26)])
  call ol_merge_tensors(G0tensor(320),[G0tensor(312),G0tensor(289),G0tensor(293),G0tensor(292),G0tensor(253),G0tensor(233) &
    ,G0tensor(193),G0tensor(237),G0tensor(343),G0tensor(84),G0tensor(337),G0tensor(67),G0tensor(55),G0tensor(25),G0tensor(24) &
    ,G0tensor(34),G0tensor(17),G0tensor(3),G0tensor(327),G0tensor(203),G0tensor(375),G0tensor(267),G0tensor(262),G0tensor(330) &
    ,G0tensor(159),G0tensor(122),G0tensor(414),G0tensor(361),G0tensor(156),G0tensor(131),G0tensor(106),G0tensor(81),G0tensor(56) &
    ,G0tensor(31)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(52),G2tensor(51),G2tensor(49),G2tensor(42),G2tensor(14),G1tensor(52),G1tensor(51) &
    ,G0tensor(300),G0tensor(248),G0tensor(217),G0tensor(224),G0tensor(76),G0tensor(41)])
  call ol_merge_tensors(G0tensor(36),[G0tensor(295),G0tensor(11),G0tensor(228),G0tensor(205),G0tensor(207),G0tensor(6),G0tensor(1) &
    ,G0tensor(399),G0tensor(398),G0tensor(388),G0tensor(384),G0tensor(383),G0tensor(350),G0tensor(354),G0tensor(345),G0tensor(294) &
    ,G0tensor(245),G0tensor(75),G0tensor(45),G0tensor(54),G0tensor(252),G0tensor(230),G0tensor(126),G0tensor(51)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(417),G0tensor(270),G0tensor(419),G0tensor(91),G0tensor(66)])
  call ol_merge_tensors(G0tensor(180),[G0tensor(87),G0tensor(8),G0tensor(50),G0tensor(273),G0tensor(146),G0tensor(71)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(31),G2tensor(30),G2tensor(24),G2tensor(11),G2tensor(22),G1tensor(45),G1tensor(44) &
    ,G0tensor(318),G0tensor(88),G0tensor(85),G0tensor(121),G0tensor(101)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(50),G2tensor(41),G2tensor(46),G2tensor(3),G2tensor(27),G1tensor(61),G1tensor(31) &
    ,G0tensor(332),G0tensor(49),G0tensor(65),G0tensor(10),G0tensor(151),G0tensor(116)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(20),G0tensor(166)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(40),G0tensor(171)])
  call ol_merge_tensors(G0tensor(381),[G0tensor(176)])
  call ol_merge_tensors(G0tensor(386),[G0tensor(181)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(21),G0tensor(191)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(39),G0tensor(196)])
  call ol_merge_tensors(G0tensor(406),[G0tensor(201)])
  call ol_merge_tensors(G0tensor(411),[G0tensor(206)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(8),G0tensor(216)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(38),G0tensor(221)])
  call ol_merge_tensors(G0tensor(90),[G0tensor(226)])
  call ol_merge_tensors(G0tensor(114),[G0tensor(231)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(91),G0tensor(241)])
  call ol_merge_tensors(G0tensor(369),[G0tensor(358),G0tensor(99),G0tensor(251)])
  call ol_merge_tensors(G0tensor(165),[G0tensor(79),G0tensor(291),G0tensor(256)])
  call ol_merge_tensors(G0tensor(353),[G0tensor(155),G0tensor(123),G0tensor(48),G0tensor(35),G0tensor(29),G0tensor(420) &
    ,G0tensor(365),G0tensor(372),G0tensor(244),G0tensor(214),G0tensor(258),G0tensor(374),G0tensor(349),G0tensor(145),G0tensor(128) &
    ,G0tensor(170),G0tensor(59),G0tensor(336),G0tensor(286),G0tensor(261)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(46),G0tensor(276)])
  call ol_merge_tensors(G0tensor(212),[G0tensor(359),G0tensor(339),G0tensor(47),G0tensor(413),G0tensor(220),G0tensor(200) &
    ,G0tensor(190),G0tensor(281)])
  call ol_merge_tensors(G0tensor(135),[G0tensor(301)])
  call ol_merge_tensors(G0tensor(100),[G0tensor(306)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(13),G2tensor(5),G2tensor(33),G2tensor(34),G0tensor(178),G0tensor(174),G0tensor(148) &
    ,G0tensor(108),G0tensor(356),G0tensor(331),G0tensor(311)])
  call ol_merge_tensors(G0tensor(129),[G0tensor(321)])
  call ol_merge_tensors(G0tensor(357),[G0tensor(326)])
  call ol_merge_tensors(G0tensor(283),[G0tensor(385),G0tensor(368),G0tensor(346)])
  call ol_merge_tensors(G0tensor(139),[G0tensor(351)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(29),G0tensor(371)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(55),G0tensor(376)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(54),G0tensor(396)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(56),G0tensor(401)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(2),G0tensor(110)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(57),G0tensor(97)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(54),G0tensor(94)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(50),G0tensor(14)])
  call ol_merge_tensors(G0tensor(130),[G0tensor(105)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(67),G2tensor(66),G2tensor(65),G2tensor(64),G0tensor(4),G0tensor(418),G0tensor(373) &
    ,G0tensor(328),G0tensor(134),G0tensor(133),G0tensor(132)])
  call ol_merge_tensors(G0tensor(179),[G0tensor(377)])
  call ol_merge_tensors(G0tensor(314),[G0tensor(303),G0tensor(324),G0tensor(264)])
  call ol_merge_tensors(G0tensor(175),[G0tensor(137)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(47),G2tensor(45),G2tensor(44),G2tensor(43),G0tensor(77),G0tensor(403),G0tensor(172) &
    ,G0tensor(28),G0tensor(142),G0tensor(210),G0tensor(125)])
  call ol_merge_tensors(G0tensor(325),[G0tensor(163),G0tensor(215)])
  call ol_merge_tensors(G0tensor(299),[G0tensor(394),G0tensor(279),G0tensor(184),G0tensor(363)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(1),G2tensor(17),G2tensor(16),G2tensor(15),G0tensor(268),G0tensor(274),G0tensor(209) &
    ,G0tensor(208),G0tensor(164),G0tensor(154),G0tensor(162)])
  call ol_merge_tensors(G0tensor(344),[G0tensor(240),G0tensor(195)])
  call ol_merge_tensors(G0tensor(37),[G0tensor(192),G0tensor(199)])
  call ol_merge_tensors(G0tensor(38),[G0tensor(213),G0tensor(204)])
  call ol_merge_tensors(G0tensor(378),[G0tensor(227),G0tensor(263)])
  call ol_merge_tensors(G0tensor(82),[G0tensor(53),G0tensor(265),G0tensor(250),G0tensor(335)])
  call ol_merge_tensors(G0tensor(234),[G0tensor(30),G0tensor(340),G0tensor(272),G0tensor(380)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(370),G0tensor(319)])
  call ol_merge_tensors(G0tensor(149),[G0tensor(412),G0tensor(364)])
  call ol_merge_tensors(G0tensor(247),[G0tensor(13),G0tensor(2)])
  call ol_merge_tensors(G0tensor(107),[G0tensor(44),G0tensor(27)])
  call ol_merge_tensors(G0tensor(153),[G0tensor(40),G0tensor(33)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(185),G0tensor(95),G0tensor(73),G0tensor(352)])
  call ol_merge_tensors(G0tensor(333),[G0tensor(309),G0tensor(304)])
call TI_bubble_red(G2tensor(72),22,mass2set(:,1),G0tensor(254),M2L1R1,G0tensor(255))
call TI_bubble_red(G2tensor(53),25,mass2set(:,1),G0tensor(275),M2L1R1,G0tensor(61))
call TI_bubble_red(G2tensor(19),21,mass2set(:,1),G0tensor(198),M2L1R1,G0tensor(315))
call TI_bubble_red(G2tensor(23),26,mass2set(:,1),G0tensor(360),M2L1R1,G0tensor(379))
call TI_bubble_red(G2tensor(9),26,mass2set(:,2),G0tensor(415),M2L1R1,G0tensor(12))
call TI_bubble_red(G2tensor(37),21,mass2set(:,2),G0tensor(5),M2L1R1,G0tensor(86))
call TI_bubble_red(G2tensor(10),26,mass2set(:,3),G0tensor(18),M2L1R1,G0tensor(15))
call TI_bubble_red(G2tensor(36),21,mass2set(:,3),G0tensor(20),M2L1R1,G0tensor(187))
call TI_bubble_red(G2tensor(25),26,mass2set(:,4),G0tensor(249),M2L1R1,G0tensor(57))
call TI_bubble_red(G2tensor(35),21,mass2set(:,4),G0tensor(111),M2L1R1,G0tensor(64))
call TI_bubble_red(G2tensor(26),26,mass2set(:,5),G0tensor(68),M2L1R1,G0tensor(113),G0tensor(136))
call TI_bubble_red(G2tensor(32),21,mass2set(:,5),G0tensor(80),M2L1R1,G0tensor(117),G0tensor(147))
call TI_bubble_red(G2tensor(4),21,mass2set(:,6),G0tensor(160),M2L1R1)
call TI_bubble_red(G2tensor(6),25,mass2set(:,2),G0tensor(183),M2L1R1,G0tensor(194))
call TI_bubble_red(G2tensor(58),22,mass2set(:,2),G0tensor(225),M2L1R1,G0tensor(278))
call TI_bubble_red(G2tensor(12),25,mass2set(:,3),G0tensor(280),M2L1R1,G0tensor(284))
call TI_bubble_red(G2tensor(59),22,mass2set(:,3),G0tensor(298),M2L1R1,G0tensor(313))
call TI_bubble_red(G2tensor(7),25,mass2set(:,4),G0tensor(22),M2L1R1,G0tensor(7))
call TI_bubble_red(G2tensor(60),22,mass2set(:,4),G0tensor(219),M2L1R1,G0tensor(70))
call TI_bubble_red(G2tensor(18),25,mass2set(:,5),G0tensor(223),M2L1R1,G0tensor(74),G0tensor(23))
call TI_bubble_red(G2tensor(61),22,mass2set(:,5),G0tensor(290),M2L1R1,G0tensor(334),G0tensor(42))
call TI_bubble_red(G2tensor(68),22,mass2set(:,6),G0tensor(32),M2L1R1)
call TI_bubble_red(G2tensor(48),25,mass2set(:,6),G0tensor(239),M2L1R1)
call TI_bubble_red(G2tensor(28),26,mass2set(:,6),G0tensor(243),M2L1R1)
  call ol_merge_tensors(G0tensor(379),[G0tensor(315),G0tensor(61),G0tensor(320),G0tensor(255)])
  call ol_merge_tensors(G0tensor(278),[G0tensor(194),G0tensor(386),G0tensor(86),G0tensor(12)])
  call ol_merge_tensors(G0tensor(313),[G0tensor(284),G0tensor(411),G0tensor(187),G0tensor(15)])
  call ol_merge_tensors(G0tensor(70),[G0tensor(7),G0tensor(114),G0tensor(64),G0tensor(57)])
  call ol_merge_tensors(G0tensor(334),[G0tensor(74),G0tensor(117),G0tensor(353),G0tensor(113)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(23),G0tensor(147),G0tensor(165),G0tensor(136)])
  call ol_merge_tensors(T0sum(229),[G0tensor(173)])
  call ol_merge_tensors(T0sum(230),[G0tensor(232)])
  call ol_merge_tensors(T0sum(231),[G0tensor(254)])
  call ol_merge_tensors(T0sum(232),[G0tensor(379)])
  call ol_merge_tensors(T0sum(233),[G0tensor(275)])
  call ol_merge_tensors(T0sum(234),[G0tensor(36)])
  call ol_merge_tensors(T0sum(235),[G0tensor(58)])
  call ol_merge_tensors(T0sum(236),[G0tensor(180)])
  call ol_merge_tensors(T0sum(237),[G0tensor(198)])
  call ol_merge_tensors(T0sum(238),[G0tensor(360)])
  call ol_merge_tensors(T0sum(239),[G0tensor(415)])
  call ol_merge_tensors(T0sum(240),[G0tensor(278)])
  call ol_merge_tensors(T0sum(241),[G0tensor(5)])
  call ol_merge_tensors(T0sum(242),[G0tensor(381)])
  call ol_merge_tensors(T0sum(243),[G0tensor(18)])
  call ol_merge_tensors(T0sum(244),[G0tensor(313)])
  call ol_merge_tensors(T0sum(245),[G0tensor(20)])
  call ol_merge_tensors(T0sum(246),[G0tensor(406)])
  call ol_merge_tensors(T0sum(247),[G0tensor(249)])
  call ol_merge_tensors(T0sum(248),[G0tensor(70)])
  call ol_merge_tensors(T0sum(249),[G0tensor(111)])
  call ol_merge_tensors(T0sum(250),[G0tensor(90)])
  call ol_merge_tensors(T0sum(251),[G0tensor(68)])
  call ol_merge_tensors(T0sum(252),[G0tensor(334)])
  call ol_merge_tensors(T0sum(253),[G0tensor(42)])
  call ol_merge_tensors(T0sum(254),[G0tensor(246)])
  call ol_merge_tensors(T0sum(255),[G0tensor(369)])
  call ol_merge_tensors(T0sum(256),[G0tensor(271)])
  call ol_merge_tensors(T0sum(257),[G0tensor(80)])
  call ol_merge_tensors(T0sum(258),[G0tensor(212)])
  call ol_merge_tensors(T0sum(259),[G0tensor(135)])
  call ol_merge_tensors(T0sum(260),[G0tensor(100)])
  call ol_merge_tensors(T0sum(261),[G0tensor(160)])
  call ol_merge_tensors(T0sum(262),[G0tensor(129)])
  call ol_merge_tensors(T0sum(263),[G0tensor(357)])
  call ol_merge_tensors(T0sum(264),[G0tensor(283)])
  call ol_merge_tensors(T0sum(265),[G0tensor(139)])
  call ol_merge_tensors(T0sum(266),[G0tensor(183)])
  call ol_merge_tensors(T0sum(267),[G0tensor(225)])
  call ol_merge_tensors(T0sum(268),[G0tensor(280)])
  call ol_merge_tensors(T0sum(269),[G0tensor(298)])
  call ol_merge_tensors(T0sum(270),[G0tensor(22)])
  call ol_merge_tensors(T0sum(271),[G0tensor(219)])
  call ol_merge_tensors(T0sum(272),[G0tensor(223)])
  call ol_merge_tensors(T0sum(273),[G0tensor(229)])
  call ol_merge_tensors(T0sum(274),[G0tensor(19)])
  call ol_merge_tensors(T0sum(275),[G0tensor(290)])
  call ol_merge_tensors(T0sum(276),[G0tensor(130)])
  call ol_merge_tensors(T0sum(277),[G0tensor(32)])
  call ol_merge_tensors(T0sum(278),[G0tensor(179)])
  call ol_merge_tensors(T0sum(279),[G0tensor(314)])
  call ol_merge_tensors(T0sum(280),[G0tensor(175)])
  call ol_merge_tensors(T0sum(281),[G0tensor(239)])
  call ol_merge_tensors(T0sum(282),[G0tensor(325)])
  call ol_merge_tensors(T0sum(283),[G0tensor(299)])
  call ol_merge_tensors(T0sum(284),[G0tensor(243)])
  call ol_merge_tensors(T0sum(285),[G0tensor(344)])
  call ol_merge_tensors(T0sum(286),[G0tensor(37)])
  call ol_merge_tensors(T0sum(287),[G0tensor(38)])
  call ol_merge_tensors(T0sum(288),[G0tensor(378)])
  call ol_merge_tensors(T0sum(289),[G0tensor(82)])
  call ol_merge_tensors(T0sum(290),[G0tensor(234)])
  call ol_merge_tensors(T0sum(291),[G0tensor(115)])
  call ol_merge_tensors(T0sum(292),[G0tensor(149)])
  call ol_merge_tensors(T0sum(293),[G0tensor(247)])
  call ol_merge_tensors(T0sum(294),[G0tensor(107)])
  call ol_merge_tensors(T0sum(295),[G0tensor(153)])
  call ol_merge_tensors(T0sum(296),[G0tensor(218)])
  call ol_merge_tensors(T0sum(297),[G0tensor(333)])
  call ol_merge_tensors(T0sum(298),[G0tensor(338)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_38,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_46,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_46,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_46,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_38,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 20, 21, 23 ],masses2_40,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 21, 23 ],masses2_49,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 20, 21 ],masses2_48,RedSet_4(4),ScalarBoxes(8))
  call compute_scalar_box([ 4, 5, 7 ],masses2_40,RedSet_4(5),ScalarBoxes(9))
  call compute_scalar_box([ 20, 22, 23 ],masses2_38,RedSet_4(6),ScalarBoxes(10))
  call compute_scalar_box([ 16, 22, 23 ],masses2_46,RedSet_4(7),ScalarBoxes(11))
  call compute_scalar_box([ 16, 20, 22 ],masses2_46,RedSet_4(8),ScalarBoxes(12))
  call compute_scalar_box([ 4, 6, 7 ],masses2_38,RedSet_4(9),ScalarBoxes(13))
  call compute_scalar_box([ 20, 22, 23 ],masses2_40,RedSet_4(6),ScalarBoxes(14))
  call compute_scalar_box([ 16, 22, 23 ],masses2_49,RedSet_4(7),ScalarBoxes(15))
  call compute_scalar_box([ 16, 20, 22 ],masses2_48,RedSet_4(8),ScalarBoxes(16))
  call compute_scalar_box([ 4, 6, 7 ],masses2_40,RedSet_4(9),ScalarBoxes(17))
  call compute_scalar_box([ 18, 22, 23 ],masses2_38,RedSet_4(10),ScalarBoxes(18))
  call compute_scalar_box([ 16, 18, 23 ],masses2_46,RedSet_4(11),ScalarBoxes(19))
  call compute_scalar_box([ 16, 18, 22 ],masses2_46,RedSet_4(12),ScalarBoxes(20))
  call compute_scalar_box([ 2, 6, 7 ],masses2_38,RedSet_4(13),ScalarBoxes(21))
  call compute_scalar_box([ 18, 22, 23 ],masses2_40,RedSet_4(10),ScalarBoxes(22))
  call compute_scalar_box([ 16, 18, 22 ],masses2_48,RedSet_4(12),ScalarBoxes(23))
  call compute_scalar_box([ 2, 6, 7 ],masses2_40,RedSet_4(13),ScalarBoxes(24))
  call compute_scalar_box([ 18, 22, 23 ],masses2_39,RedSet_4(10),ScalarBoxes(25))
  call compute_scalar_box([ 16, 22, 23 ],masses2_44,RedSet_4(7),ScalarBoxes(26))
  call compute_scalar_box([ 16, 18, 23 ],masses2_41,RedSet_4(11),ScalarBoxes(27))
  call compute_scalar_box([ 16, 18, 22 ],masses2_43,RedSet_4(12),ScalarBoxes(28))
  call compute_scalar_box([ 2, 6, 7 ],masses2_39,RedSet_4(13),ScalarBoxes(29))
  call compute_scalar_box([ 18, 26, 27 ],masses2_38,RedSet_4(14),ScalarBoxes(30))
  call compute_scalar_box([ 16, 26, 27 ],masses2_46,RedSet_4(15),ScalarBoxes(31))
  call compute_scalar_box([ 16, 18, 27 ],masses2_46,RedSet_4(16),ScalarBoxes(32))
  call compute_scalar_box([ 16, 18, 26 ],masses2_46,RedSet_4(17),ScalarBoxes(33))
  call compute_scalar_box([ 2, 10, 11 ],masses2_38,RedSet_4(18),ScalarBoxes(34))
  call compute_scalar_box([ 18, 26, 27 ],masses2_40,RedSet_4(14),ScalarBoxes(35))
  call compute_scalar_box([ 16, 26, 27 ],masses2_49,RedSet_4(15),ScalarBoxes(36))
  call compute_scalar_box([ 16, 18, 26 ],masses2_48,RedSet_4(17),ScalarBoxes(37))
  call compute_scalar_box([ 2, 10, 11 ],masses2_40,RedSet_4(18),ScalarBoxes(38))
  call compute_scalar_box([ 18, 26, 27 ],masses2_39,RedSet_4(14),ScalarBoxes(39))
  call compute_scalar_box([ 16, 26, 27 ],masses2_44,RedSet_4(15),ScalarBoxes(40))
  call compute_scalar_box([ 16, 18, 27 ],masses2_41,RedSet_4(16),ScalarBoxes(41))
  call compute_scalar_box([ 16, 18, 26 ],masses2_43,RedSet_4(17),ScalarBoxes(42))
  call compute_scalar_box([ 2, 10, 11 ],masses2_39,RedSet_4(18),ScalarBoxes(43))
  call compute_scalar_box([ 17, 21, 23 ],masses2_38,RedSet_4(19),ScalarBoxes(44))
  call compute_scalar_box([ 16, 17, 23 ],masses2_46,RedSet_4(20),ScalarBoxes(45))
  call compute_scalar_box([ 16, 17, 21 ],masses2_46,RedSet_4(21),ScalarBoxes(46))
  call compute_scalar_box([ 1, 5, 7 ],masses2_38,RedSet_4(22),ScalarBoxes(47))
  call compute_scalar_box([ 17, 21, 23 ],masses2_40,RedSet_4(19),ScalarBoxes(48))
  call compute_scalar_box([ 16, 17, 21 ],masses2_48,RedSet_4(21),ScalarBoxes(49))
  call compute_scalar_box([ 1, 5, 7 ],masses2_40,RedSet_4(22),ScalarBoxes(50))
  call compute_scalar_box([ 17, 21, 23 ],masses2_39,RedSet_4(19),ScalarBoxes(51))
  call compute_scalar_box([ 16, 21, 23 ],masses2_44,RedSet_4(2),ScalarBoxes(52))
  call compute_scalar_box([ 16, 17, 23 ],masses2_41,RedSet_4(20),ScalarBoxes(53))
  call compute_scalar_box([ 16, 17, 21 ],masses2_43,RedSet_4(21),ScalarBoxes(54))
  call compute_scalar_box([ 1, 5, 7 ],masses2_39,RedSet_4(22),ScalarBoxes(55))
  call compute_scalar_box([ 17, 21, 29 ],masses2_38,RedSet_4(23),ScalarBoxes(56))
  call compute_scalar_box([ 16, 21, 29 ],masses2_46,RedSet_4(24),ScalarBoxes(57))
  call compute_scalar_box([ 16, 17, 29 ],masses2_46,RedSet_4(25),ScalarBoxes(58))
  call compute_scalar_box([ 1, 5, 13 ],masses2_38,RedSet_4(26),ScalarBoxes(59))
  call compute_scalar_box([ 17, 21, 29 ],masses2_40,RedSet_4(23),ScalarBoxes(60))
  call compute_scalar_box([ 16, 21, 29 ],masses2_49,RedSet_4(24),ScalarBoxes(61))
  call compute_scalar_box([ 1, 5, 13 ],masses2_40,RedSet_4(26),ScalarBoxes(62))
  call compute_scalar_box([ 17, 25, 27 ],masses2_38,RedSet_4(27),ScalarBoxes(63))
  call compute_scalar_box([ 16, 25, 27 ],masses2_46,RedSet_4(28),ScalarBoxes(64))
  call compute_scalar_box([ 16, 17, 27 ],masses2_46,RedSet_4(29),ScalarBoxes(65))
  call compute_scalar_box([ 16, 17, 25 ],masses2_46,RedSet_4(30),ScalarBoxes(66))
  call compute_scalar_box([ 1, 9, 11 ],masses2_38,RedSet_4(31),ScalarBoxes(67))
  call compute_scalar_box([ 17, 25, 27 ],masses2_40,RedSet_4(27),ScalarBoxes(68))
  call compute_scalar_box([ 16, 25, 27 ],masses2_49,RedSet_4(28),ScalarBoxes(69))
  call compute_scalar_box([ 16, 17, 25 ],masses2_48,RedSet_4(30),ScalarBoxes(70))
  call compute_scalar_box([ 1, 9, 11 ],masses2_40,RedSet_4(31),ScalarBoxes(71))
  call compute_scalar_box([ 17, 25, 27 ],masses2_39,RedSet_4(27),ScalarBoxes(72))
  call compute_scalar_box([ 16, 25, 27 ],masses2_44,RedSet_4(28),ScalarBoxes(73))
  call compute_scalar_box([ 16, 17, 27 ],masses2_41,RedSet_4(29),ScalarBoxes(74))
  call compute_scalar_box([ 16, 17, 25 ],masses2_43,RedSet_4(30),ScalarBoxes(75))
  call compute_scalar_box([ 1, 9, 11 ],masses2_39,RedSet_4(31),ScalarBoxes(76))
  call compute_scalar_box([ 17, 25, 29 ],masses2_38,RedSet_4(32),ScalarBoxes(77))
  call compute_scalar_box([ 16, 25, 29 ],masses2_46,RedSet_4(33),ScalarBoxes(78))
  call compute_scalar_box([ 1, 9, 13 ],masses2_38,RedSet_4(34),ScalarBoxes(79))
  call compute_scalar_box([ 17, 25, 29 ],masses2_40,RedSet_4(32),ScalarBoxes(80))
  call compute_scalar_box([ 16, 25, 29 ],masses2_49,RedSet_4(33),ScalarBoxes(81))
  call compute_scalar_box([ 1, 9, 13 ],masses2_40,RedSet_4(34),ScalarBoxes(82))
! end of process


end subroutine vamp_2

end module ol_vamp_2_eehll_ew_eeexexh_1_/**/REALKIND
