
module ol_vamp_1_eeeemma_ew_eeexexmmxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eeeemma_ew_eeexexmmxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eeeemma_ew_eeexexmmxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eeeemma_ew_eeexexmmxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_eeeemma_ew_eeexexmmxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eeeemma_ew_eeexexmmxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eeeemma_ew_eeexexmmxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,16,4,1,2,8,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1),n2h64(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,16,4,1,2,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(2),n2h64(2))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,16,4,1,2,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(3),n2h64(3))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,16,4,1,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(4),n2h64(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,16,4,1,2,8,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(5),n2h64(5))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,16,4,1,2,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(6),n2h64(6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(7),n2h64(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(8),n2h64(8))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,16,4,1,2,8,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(9),n2h64(9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,16,4,1,2,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(10),n2h64(10))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(11),n2h64(11))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(12),n2h64(12))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,16,4,1,2,8,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(13),n2h64(13))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(14),n2h64(14))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,16,4,1,2,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(15),n2h64(15))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,16,4,1,2,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(16),n2h64(16))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(17),n2h64(17))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,16,4,1,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(18),n2h64(18))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,16,4,1,2,8,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(19),n2h64(19))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(20),n2h64(20))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,16,4,1,2,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(21),n2h64(21))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,16,4,1,2,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(22),n2h64(22))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(23),n2h64(23))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,16,4,1,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(24),n2h64(24))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,16,4,1,2,8,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(25),n2h64(25))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,16,4,1,2,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(26),n2h64(26))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(27),n2h64(27))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(28),n2h64(28))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(29),n2h64(29))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(30),n2h64(30))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,16,4,1,2,8,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(31),n2h64(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,16,4,1,2,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(32),n2h64(32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(33),n2h64(33))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(34),n2h64(34))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,16,4,1,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(35),n2h64(35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,16,4,1,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(36),n2h64(36))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,16,4,1,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(37),n2h64(37))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,16,8,2,1,4,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(38),n2h64(38))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,16,8,2,1,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,39))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(39),n2h64(39))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,40))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(40),n2h64(40))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(41),n2h64(41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,16,8,2,1,4,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(42),n2h64(42))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,16,8,2,1,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(43),n2h64(43))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,16,8,2,1,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(44),n2h64(44))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,16,8,2,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,45))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(45),n2h64(45))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,16,8,2,1,4,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,46))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(46),n2h64(46))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,47))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(47),n2h64(47))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,16,8,2,1,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,48))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(48),n2h64(48))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,49))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(49),n2h64(49))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,16,8,2,1,4,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,50),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(50),n2h64(50))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,51),heltab2x128(:,:,51))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(51),n2h64(51))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,16,8,2,1,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(52),n2h64(52))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,16,8,2,1,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(53),n2h64(53))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,16,8,2,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,54),heltab2x128(:,:,54))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(54),n2h64(54))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(55),n2h64(55))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,16,8,2,1,4,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,56))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(56),n2h64(56))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,16,8,2,1,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(57),n2h64(57))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,58),heltab2x128(:,:,58))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(58),n2h64(58))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(59),n2h64(59))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,60),heltab2x128(:,:,60))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(60),n2h64(60))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(61),n2h64(61))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,16,8,2,1,4,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,62),heltab2x128(:,:,62))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(62),n2h64(62))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(63),n2h64(63))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,16,8,2,1,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,64),heltab2x128(:,:,64))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(64),n2h64(64))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,16,8,2,1,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,65))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(65),n2h64(65))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,66),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(66),n2h64(66))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,16,8,2,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,67))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(67),n2h64(67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,16,8,2,1,4,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,68),heltab2x128(:,:,68))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(68),n2h64(68))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,69),heltab2x128(:,:,69))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(69),n2h64(69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,16,8,2,1,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,70),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(70),n2h64(70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,71),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(71),n2h64(71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,16,8,2,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,72),heltab2x128(:,:,72))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(72),n2h64(72))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,16,8,2,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,73),heltab2x128(:,:,73))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(73),n2h64(73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[64,16,8,2,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,74),heltab2x128(:,:,74))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(74),n2h64(74))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[64,2,1,4,16,32,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,75),heltab2x128(:,:,75))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(75),n2h64(75))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[64,2,1,4,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,76),heltab2x128(:,:,76))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(76),n2h64(76))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[64,2,1,4,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,77),heltab2x128(:,:,77))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(77),n2h64(77))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[64,2,1,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,78),heltab2x128(:,:,78))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(78),n2h64(78))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[64,2,1,4,16,32,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,79),heltab2x128(:,:,79))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(79),n2h64(79))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[64,2,1,4,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,80),heltab2x128(:,:,80))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(80),n2h64(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,81),heltab2x128(:,:,81))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(81),n2h64(81))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,82),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(82),n2h64(82))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[64,2,1,4,16,32,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,83),heltab2x128(:,:,83))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(83),n2h64(83))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[64,2,1,4,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,84),heltab2x128(:,:,84))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(84),n2h64(84))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,85),heltab2x128(:,:,85))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(85),n2h64(85))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,86),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(86),n2h64(86))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[64,2,1,4,16,32,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,87),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(87),n2h64(87))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,88),heltab2x128(:,:,88))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(88),n2h64(88))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[64,2,1,4,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,89),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(89),n2h64(89))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[64,2,1,4,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,90),heltab2x128(:,:,90))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(90),n2h64(90))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,91),heltab2x128(:,:,91))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(91),n2h64(91))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[64,2,1,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,92),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(92),n2h64(92))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[64,2,1,4,16,32,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,93),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(93),n2h64(93))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,94),heltab2x128(:,:,94))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(94),n2h64(94))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[64,2,1,4,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,95),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(95),n2h64(95))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[64,2,1,4,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,96),heltab2x128(:,:,96))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(96),n2h64(96))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,97),heltab2x128(:,:,97))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(97),n2h64(97))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[64,2,1,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,98),heltab2x128(:,:,98))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(98),n2h64(98))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,2,1,4,16,32,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,99),heltab2x128(:,:,99))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(99),n2h64(99))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,2,1,4,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,100),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(100),n2h64(100))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,101),heltab2x128(:,:,101))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(101),n2h64(101))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,102),heltab2x128(:,:,102))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(102),n2h64(102))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,103),heltab2x128(:,:,103))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(103),n2h64(103))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,104),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(104),n2h64(104))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[64,2,1,4,16,32,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,105),heltab2x128(:,:,105))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(105),n2h64(105))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[64,2,1,4,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,106),heltab2x128(:,:,106))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(106),n2h64(106))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,107),heltab2x128(:,:,107))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(107),n2h64(107))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,108),heltab2x128(:,:,108))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(108),n2h64(108))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,2,1,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,109),heltab2x128(:,:,109))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(109),n2h64(109))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,2,1,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,110),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(110),n2h64(110))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,2,1,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,111),heltab2x128(:,:,111))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(111),n2h64(111))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,2,1,4,32,16,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,112),heltab2x128(:,:,112))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(112),n2h64(112))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[64,2,1,4,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,113),heltab2x128(:,:,113))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(113),n2h64(113))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[64,2,1,4,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,114),heltab2x128(:,:,114))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(114),n2h64(114))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(115),h0tab(:,115),[64,2,1,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,115),heltab2x128(:,:,115))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(115),n2h64(115))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(116),h0tab(:,116),[64,2,1,4,32,16,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,116),heltab2x128(:,:,116))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(116),n2h64(116))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(117),h0tab(:,117),[64,2,1,4,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,117),heltab2x128(:,:,117))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(117),n2h64(117))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(118),h0tab(:,118),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,118),heltab2x128(:,:,118))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(118),n2h64(118))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(119),h0tab(:,119),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,119),heltab2x128(:,:,119))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(119),n2h64(119))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(120),h0tab(:,120),[64,2,1,4,32,16,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,120),heltab2x128(:,:,120))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(120),n2h64(120))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(121),h0tab(:,121),[64,2,1,4,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,121),heltab2x128(:,:,121))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(121),n2h64(121))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(122),h0tab(:,122),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,122),heltab2x128(:,:,122))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(122),n2h64(122))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(123),h0tab(:,123),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,123),heltab2x128(:,:,123))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(123),n2h64(123))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(124),h0tab(:,124),[64,2,1,4,32,16,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,124),heltab2x128(:,:,124))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(124),n2h64(124))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(125),h0tab(:,125),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,125),heltab2x128(:,:,125))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(125),n2h64(125))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(126),h0tab(:,126),[64,2,1,4,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,126),heltab2x128(:,:,126))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(126),n2h64(126))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(127),h0tab(:,127),[64,2,1,4,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,127),heltab2x128(:,:,127))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(127),n2h64(127))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(128),h0tab(:,128),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,128),heltab2x128(:,:,128))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(128),n2h64(128))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(129),h0tab(:,129),[64,2,1,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,129),heltab2x128(:,:,129))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(129),n2h64(129))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(130),h0tab(:,130),[64,2,1,4,32,16,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,130),heltab2x128(:,:,130))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(130),n2h64(130))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(131),h0tab(:,131),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,131),heltab2x128(:,:,131))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(131),n2h64(131))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(132),h0tab(:,132),[64,2,1,4,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,132),heltab2x128(:,:,132))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(132),n2h64(132))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(133),h0tab(:,133),[64,2,1,4,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,133),heltab2x128(:,:,133))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(133),n2h64(133))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(134),h0tab(:,134),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,134),heltab2x128(:,:,134))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(134),n2h64(134))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(135),h0tab(:,135),[64,2,1,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,135),heltab2x128(:,:,135))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(135),n2h64(135))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(136),h0tab(:,136),[64,2,1,4,32,16,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,136),heltab2x128(:,:,136))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(136),n2h64(136))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(137),h0tab(:,137),[64,2,1,4,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,137),heltab2x128(:,:,137))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(137),n2h64(137))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(138),h0tab(:,138),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,138),heltab2x128(:,:,138))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(138),n2h64(138))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(139),h0tab(:,139),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,139),heltab2x128(:,:,139))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(139),n2h64(139))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(140),h0tab(:,140),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,140),heltab2x128(:,:,140))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(140),n2h64(140))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(141),h0tab(:,141),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,141),heltab2x128(:,:,141))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(141),n2h64(141))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(142),h0tab(:,142),[64,2,1,4,32,16,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,142),heltab2x128(:,:,142))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(142),n2h64(142))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(143),h0tab(:,143),[64,2,1,4,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,143),heltab2x128(:,:,143))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(143),n2h64(143))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(144),h0tab(:,144),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,144),heltab2x128(:,:,144))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(144),n2h64(144))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(145),h0tab(:,145),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,145),heltab2x128(:,:,145))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(145),n2h64(145))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(146),h0tab(:,146),[64,2,1,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,146),heltab2x128(:,:,146))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(146),n2h64(146))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(147),h0tab(:,147),[64,2,1,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,147),heltab2x128(:,:,147))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(147),n2h64(147))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(148),h0tab(:,148),[64,2,1,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,148),heltab2x128(:,:,148))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(148),n2h64(148))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(149),h0tab(:,149),[64,16,4,2,1,8,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,149),heltab2x128(:,:,149))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(149),n2h64(149))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(150),h0tab(:,150),[64,16,4,2,1,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,150),heltab2x128(:,:,150))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(150),n2h64(150))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(151),h0tab(:,151),[64,16,4,2,1,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,151),heltab2x128(:,:,151))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(151),n2h64(151))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(152),h0tab(:,152),[64,16,4,2,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,152),heltab2x128(:,:,152))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(152),n2h64(152))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(153),h0tab(:,153),[64,16,4,2,1,8,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,153),heltab2x128(:,:,153))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(153),n2h64(153))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(154),h0tab(:,154),[64,16,4,2,1,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,154),heltab2x128(:,:,154))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(154),n2h64(154))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(155),h0tab(:,155),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,155),heltab2x128(:,:,155))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(155),n2h64(155))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(156),h0tab(:,156),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,156),heltab2x128(:,:,156))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(156),n2h64(156))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(157),h0tab(:,157),[64,16,4,2,1,8,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,157),heltab2x128(:,:,157))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(157),n2h64(157))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(158),h0tab(:,158),[64,16,4,2,1,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,158),heltab2x128(:,:,158))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(158),n2h64(158))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(159),h0tab(:,159),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,159),heltab2x128(:,:,159))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(159),n2h64(159))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(160),h0tab(:,160),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,160),heltab2x128(:,:,160))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(160),n2h64(160))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(161),h0tab(:,161),[64,16,4,2,1,8,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,161),heltab2x128(:,:,161))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(161),n2h64(161))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(162),h0tab(:,162),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,162),heltab2x128(:,:,162))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(162),n2h64(162))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(163),h0tab(:,163),[64,16,4,2,1,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,163),heltab2x128(:,:,163))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(163),n2h64(163))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(164),h0tab(:,164),[64,16,4,2,1,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,164),heltab2x128(:,:,164))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(164),n2h64(164))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(165),h0tab(:,165),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,165),heltab2x128(:,:,165))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(165),n2h64(165))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(166),h0tab(:,166),[64,16,4,2,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,166),heltab2x128(:,:,166))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(166),n2h64(166))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(167),h0tab(:,167),[64,16,4,2,1,8,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,167),heltab2x128(:,:,167))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(167),n2h64(167))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(168),h0tab(:,168),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,168),heltab2x128(:,:,168))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(168),n2h64(168))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(169),h0tab(:,169),[64,16,4,2,1,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,169),heltab2x128(:,:,169))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(169),n2h64(169))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(170),h0tab(:,170),[64,16,4,2,1,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,170),heltab2x128(:,:,170))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(170),n2h64(170))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(171),h0tab(:,171),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,171),heltab2x128(:,:,171))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(171),n2h64(171))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(172),h0tab(:,172),[64,16,4,2,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,172),heltab2x128(:,:,172))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(172),n2h64(172))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(173),h0tab(:,173),[64,16,4,2,1,8,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,173),heltab2x128(:,:,173))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(173),n2h64(173))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(174),h0tab(:,174),[64,16,4,2,1,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,174),heltab2x128(:,:,174))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(174),n2h64(174))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(175),h0tab(:,175),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,175),heltab2x128(:,:,175))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(175),n2h64(175))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(176),h0tab(:,176),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,176),heltab2x128(:,:,176))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(176),n2h64(176))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(177),h0tab(:,177),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,177),heltab2x128(:,:,177))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(177),n2h64(177))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(178),h0tab(:,178),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,178),heltab2x128(:,:,178))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(178),n2h64(178))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(179),h0tab(:,179),[64,16,4,2,1,8,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,179),heltab2x128(:,:,179))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(179),n2h64(179))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(180),h0tab(:,180),[64,16,4,2,1,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,180),heltab2x128(:,:,180))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(180),n2h64(180))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(181),h0tab(:,181),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,181),heltab2x128(:,:,181))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(181),n2h64(181))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(182),h0tab(:,182),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,182),heltab2x128(:,:,182))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(182),n2h64(182))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(183),h0tab(:,183),[64,16,4,2,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,183),heltab2x128(:,:,183))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(183),n2h64(183))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(184),h0tab(:,184),[64,16,4,2,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,184),heltab2x128(:,:,184))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(184),n2h64(184))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(185),h0tab(:,185),[64,16,4,2,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,185),heltab2x128(:,:,185))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(185),n2h64(185))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(186),h0tab(:,186),[64,16,8,1,2,4,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,186),heltab2x128(:,:,186))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(186),n2h64(186))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(187),h0tab(:,187),[64,16,8,1,2,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,187),heltab2x128(:,:,187))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(187),n2h64(187))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(188),h0tab(:,188),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,188),heltab2x128(:,:,188))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(188),n2h64(188))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(189),h0tab(:,189),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,189),heltab2x128(:,:,189))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(189),n2h64(189))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(190),h0tab(:,190),[64,16,8,1,2,4,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,190),heltab2x128(:,:,190))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(190),n2h64(190))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(191),h0tab(:,191),[64,16,8,1,2,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,191),heltab2x128(:,:,191))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(191),n2h64(191))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(192),h0tab(:,192),[64,16,8,1,2,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,192),heltab2x128(:,:,192))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(192),n2h64(192))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(193),h0tab(:,193),[64,16,8,1,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,193),heltab2x128(:,:,193))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(193),n2h64(193))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(194),h0tab(:,194),[64,16,8,1,2,4,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,194),heltab2x128(:,:,194))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(194),n2h64(194))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(195),h0tab(:,195),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,195),heltab2x128(:,:,195))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(195),n2h64(195))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(196),h0tab(:,196),[64,16,8,1,2,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,196),heltab2x128(:,:,196))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(196),n2h64(196))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(197),h0tab(:,197),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,197),heltab2x128(:,:,197))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(197),n2h64(197))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(198),h0tab(:,198),[64,16,8,1,2,4,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,198),heltab2x128(:,:,198))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(198),n2h64(198))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(199),h0tab(:,199),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,199),heltab2x128(:,:,199))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(199),n2h64(199))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(200),h0tab(:,200),[64,16,8,1,2,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,200),heltab2x128(:,:,200))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(200),n2h64(200))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(201),h0tab(:,201),[64,16,8,1,2,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,201),heltab2x128(:,:,201))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(201),n2h64(201))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(202),h0tab(:,202),[64,16,8,1,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,202),heltab2x128(:,:,202))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(202),n2h64(202))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(203),h0tab(:,203),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,203),heltab2x128(:,:,203))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(203),n2h64(203))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(204),h0tab(:,204),[64,16,8,1,2,4,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,204),heltab2x128(:,:,204))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(204),n2h64(204))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(205),h0tab(:,205),[64,16,8,1,2,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,205),heltab2x128(:,:,205))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(205),n2h64(205))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(206),h0tab(:,206),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,206),heltab2x128(:,:,206))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(206),n2h64(206))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(207),h0tab(:,207),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,207),heltab2x128(:,:,207))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(207),n2h64(207))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(208),h0tab(:,208),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,208),heltab2x128(:,:,208))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(208),n2h64(208))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(209),h0tab(:,209),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,209),heltab2x128(:,:,209))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(209),n2h64(209))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(210),h0tab(:,210),[64,16,8,1,2,4,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,210),heltab2x128(:,:,210))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(210),n2h64(210))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(211),h0tab(:,211),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,211),heltab2x128(:,:,211))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(211),n2h64(211))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(212),h0tab(:,212),[64,16,8,1,2,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,212),heltab2x128(:,:,212))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(212),n2h64(212))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(213),h0tab(:,213),[64,16,8,1,2,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,213),heltab2x128(:,:,213))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(213),n2h64(213))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(214),h0tab(:,214),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,214),heltab2x128(:,:,214))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(214),n2h64(214))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(215),h0tab(:,215),[64,16,8,1,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,215),heltab2x128(:,:,215))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(215),n2h64(215))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(216),h0tab(:,216),[64,16,8,1,2,4,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,216),heltab2x128(:,:,216))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(216),n2h64(216))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(217),h0tab(:,217),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,217),heltab2x128(:,:,217))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(217),n2h64(217))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(218),h0tab(:,218),[64,16,8,1,2,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,218),heltab2x128(:,:,218))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(218),n2h64(218))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(219),h0tab(:,219),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,219),heltab2x128(:,:,219))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(219),n2h64(219))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(220),h0tab(:,220),[64,16,8,1,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,220),heltab2x128(:,:,220))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(220),n2h64(220))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(221),h0tab(:,221),[64,16,8,1,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,221),heltab2x128(:,:,221))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(221),n2h64(221))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(222),h0tab(:,222),[64,16,8,1,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,222),heltab2x128(:,:,222))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(222),n2h64(222))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(223),h0tab(:,223),[64,2,1,8,32,16,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,223),heltab2x128(:,:,223))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(223),n2h64(223))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(224),h0tab(:,224),[64,2,1,8,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,224),heltab2x128(:,:,224))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(224),n2h64(224))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(225),h0tab(:,225),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,225),heltab2x128(:,:,225))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(225),n2h64(225))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(226),h0tab(:,226),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,226),heltab2x128(:,:,226))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(226),n2h64(226))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(227),h0tab(:,227),[64,2,1,8,32,16,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,227),heltab2x128(:,:,227))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(227),n2h64(227))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(228),h0tab(:,228),[64,2,1,8,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,228),heltab2x128(:,:,228))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(228),n2h64(228))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(229),h0tab(:,229),[64,2,1,8,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,229),heltab2x128(:,:,229))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(229),n2h64(229))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(230),h0tab(:,230),[64,2,1,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,230),heltab2x128(:,:,230))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(230),n2h64(230))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(231),h0tab(:,231),[64,2,1,8,32,16,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,231),heltab2x128(:,:,231))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(231),n2h64(231))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(232),h0tab(:,232),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,232),heltab2x128(:,:,232))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(232),n2h64(232))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(233),h0tab(:,233),[64,2,1,8,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,233),heltab2x128(:,:,233))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(233),n2h64(233))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(234),h0tab(:,234),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,234),heltab2x128(:,:,234))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(234),n2h64(234))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(235),h0tab(:,235),[64,2,1,8,32,16,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,235),heltab2x128(:,:,235))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(235),n2h64(235))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(236),h0tab(:,236),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,236),heltab2x128(:,:,236))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(236),n2h64(236))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(237),h0tab(:,237),[64,2,1,8,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,237),heltab2x128(:,:,237))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(237),n2h64(237))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(238),h0tab(:,238),[64,2,1,8,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,238),heltab2x128(:,:,238))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(238),n2h64(238))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(239),h0tab(:,239),[64,2,1,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,239),heltab2x128(:,:,239))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(239),n2h64(239))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(240),h0tab(:,240),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,240),heltab2x128(:,:,240))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(240),n2h64(240))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(241),h0tab(:,241),[64,2,1,8,32,16,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,241),heltab2x128(:,:,241))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(241),n2h64(241))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(242),h0tab(:,242),[64,2,1,8,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,242),heltab2x128(:,:,242))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(242),n2h64(242))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(243),h0tab(:,243),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,243),heltab2x128(:,:,243))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(243),n2h64(243))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(244),h0tab(:,244),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,244),heltab2x128(:,:,244))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(244),n2h64(244))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(245),h0tab(:,245),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,245),heltab2x128(:,:,245))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(245),n2h64(245))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(246),h0tab(:,246),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,246),heltab2x128(:,:,246))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(246),n2h64(246))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(247),h0tab(:,247),[64,2,1,8,32,16,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,247),heltab2x128(:,:,247))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(247),n2h64(247))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(248),h0tab(:,248),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,248),heltab2x128(:,:,248))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(248),n2h64(248))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(249),h0tab(:,249),[64,2,1,8,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,249),heltab2x128(:,:,249))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(249),n2h64(249))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(250),h0tab(:,250),[64,2,1,8,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,250),heltab2x128(:,:,250))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(250),n2h64(250))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(251),h0tab(:,251),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,251),heltab2x128(:,:,251))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(251),n2h64(251))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(252),h0tab(:,252),[64,2,1,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,252),heltab2x128(:,:,252))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(252),n2h64(252))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(253),h0tab(:,253),[64,2,1,8,32,16,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,253),heltab2x128(:,:,253))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(253),n2h64(253))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(254),h0tab(:,254),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,254),heltab2x128(:,:,254))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(254),n2h64(254))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(255),h0tab(:,255),[64,2,1,8,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,255),heltab2x128(:,:,255))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(255),n2h64(255))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(256),h0tab(:,256),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,256),heltab2x128(:,:,256))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(256),n2h64(256))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(257),h0tab(:,257),[64,2,1,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,257),heltab2x128(:,:,257))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(257),n2h64(257))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(258),h0tab(:,258),[64,2,1,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,258),heltab2x128(:,:,258))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(258),n2h64(258))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(259),h0tab(:,259),[64,2,1,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,259),heltab2x128(:,:,259))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(259),n2h64(259))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(260),h0tab(:,260),[64,2,1,8,16,32,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,260),heltab2x128(:,:,260))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(260),n2h64(260))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(261),h0tab(:,261),[64,2,1,8,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,261),heltab2x128(:,:,261))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(261),n2h64(261))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(262),h0tab(:,262),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,262),heltab2x128(:,:,262))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(262),n2h64(262))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(263),h0tab(:,263),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,263),heltab2x128(:,:,263))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(263),n2h64(263))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(264),h0tab(:,264),[64,2,1,8,16,32,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,264),heltab2x128(:,:,264))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(264),n2h64(264))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(265),h0tab(:,265),[64,2,1,8,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,265),heltab2x128(:,:,265))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(265),n2h64(265))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(266),h0tab(:,266),[64,2,1,8,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,266),heltab2x128(:,:,266))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(266),n2h64(266))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(267),h0tab(:,267),[64,2,1,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,267),heltab2x128(:,:,267))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(267),n2h64(267))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(268),h0tab(:,268),[64,2,1,8,16,32,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,268),heltab2x128(:,:,268))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(268),n2h64(268))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(269),h0tab(:,269),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,269),heltab2x128(:,:,269))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(269),n2h64(269))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(270),h0tab(:,270),[64,2,1,8,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,270),heltab2x128(:,:,270))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(270),n2h64(270))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(271),h0tab(:,271),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,271),heltab2x128(:,:,271))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(271),n2h64(271))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(272),h0tab(:,272),[64,2,1,8,16,32,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,272),heltab2x128(:,:,272))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(272),n2h64(272))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(273),h0tab(:,273),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,273),heltab2x128(:,:,273))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(273),n2h64(273))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(274),h0tab(:,274),[64,2,1,8,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,274),heltab2x128(:,:,274))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(274),n2h64(274))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(275),h0tab(:,275),[64,2,1,8,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,275),heltab2x128(:,:,275))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(275),n2h64(275))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(276),h0tab(:,276),[64,2,1,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,276),heltab2x128(:,:,276))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(276),n2h64(276))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(277),h0tab(:,277),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,277),heltab2x128(:,:,277))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(277),n2h64(277))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(278),h0tab(:,278),[64,2,1,8,16,32,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,278),heltab2x128(:,:,278))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(278),n2h64(278))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(279),h0tab(:,279),[64,2,1,8,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,279),heltab2x128(:,:,279))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(279),n2h64(279))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(280),h0tab(:,280),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,280),heltab2x128(:,:,280))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(280),n2h64(280))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(281),h0tab(:,281),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,281),heltab2x128(:,:,281))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(281),n2h64(281))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(282),h0tab(:,282),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,282),heltab2x128(:,:,282))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(282),n2h64(282))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(283),h0tab(:,283),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,283),heltab2x128(:,:,283))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(283),n2h64(283))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(284),h0tab(:,284),[64,2,1,8,16,32,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,284),heltab2x128(:,:,284))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(284),n2h64(284))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(285),h0tab(:,285),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,285),heltab2x128(:,:,285))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(285),n2h64(285))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(286),h0tab(:,286),[64,2,1,8,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,286),heltab2x128(:,:,286))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(286),n2h64(286))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(287),h0tab(:,287),[64,2,1,8,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,287),heltab2x128(:,:,287))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(287),n2h64(287))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(288),h0tab(:,288),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,288),heltab2x128(:,:,288))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(288),n2h64(288))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(289),h0tab(:,289),[64,2,1,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,289),heltab2x128(:,:,289))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(289),n2h64(289))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(290),h0tab(:,290),[64,2,1,8,16,32,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,290),heltab2x128(:,:,290))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(290),n2h64(290))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(291),h0tab(:,291),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,291),heltab2x128(:,:,291))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(291),n2h64(291))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(292),h0tab(:,292),[64,2,1,8,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,292),heltab2x128(:,:,292))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(292),n2h64(292))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(293),h0tab(:,293),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,293),heltab2x128(:,:,293))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(293),n2h64(293))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(294),h0tab(:,294),[64,2,1,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,294),heltab2x128(:,:,294))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(294),n2h64(294))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(295),h0tab(:,295),[64,2,1,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,295),heltab2x128(:,:,295))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(295),n2h64(295))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(296),h0tab(:,296),[64,2,1,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,296),heltab2x128(:,:,296))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(296),n2h64(296))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(297),h0tab(:,297),[64,1,2,4,16,32,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,297),heltab2x128(:,:,297))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(297),n2h64(297))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(298),h0tab(:,298),[64,1,2,4,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,298),heltab2x128(:,:,298))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(298),n2h64(298))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(299),h0tab(:,299),[64,1,2,4,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,299),heltab2x128(:,:,299))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(299),n2h64(299))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(300),h0tab(:,300),[64,1,2,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,300),heltab2x128(:,:,300))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(300),n2h64(300))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(301),h0tab(:,301),[64,1,2,4,16,32,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,301),heltab2x128(:,:,301))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(301),n2h64(301))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(302),h0tab(:,302),[64,1,2,4,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,302),heltab2x128(:,:,302))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(302),n2h64(302))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(303),h0tab(:,303),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,303),heltab2x128(:,:,303))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(303),n2h64(303))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(304),h0tab(:,304),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,304),heltab2x128(:,:,304))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(304),n2h64(304))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(305),h0tab(:,305),[64,1,2,4,16,32,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,305),heltab2x128(:,:,305))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(305),n2h64(305))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(306),h0tab(:,306),[64,1,2,4,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,306),heltab2x128(:,:,306))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(306),n2h64(306))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(307),h0tab(:,307),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,307),heltab2x128(:,:,307))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(307),n2h64(307))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(308),h0tab(:,308),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,308),heltab2x128(:,:,308))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(308),n2h64(308))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(309),h0tab(:,309),[64,1,2,4,16,32,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,309),heltab2x128(:,:,309))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(309),n2h64(309))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(310),h0tab(:,310),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,310),heltab2x128(:,:,310))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(310),n2h64(310))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(311),h0tab(:,311),[64,1,2,4,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,311),heltab2x128(:,:,311))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(311),n2h64(311))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(312),h0tab(:,312),[64,1,2,4,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,312),heltab2x128(:,:,312))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(312),n2h64(312))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(313),h0tab(:,313),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,313),heltab2x128(:,:,313))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(313),n2h64(313))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(314),h0tab(:,314),[64,1,2,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,314),heltab2x128(:,:,314))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(314),n2h64(314))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(315),h0tab(:,315),[64,1,2,4,16,32,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,315),heltab2x128(:,:,315))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(315),n2h64(315))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(316),h0tab(:,316),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,316),heltab2x128(:,:,316))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(316),n2h64(316))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(317),h0tab(:,317),[64,1,2,4,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,317),heltab2x128(:,:,317))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(317),n2h64(317))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(318),h0tab(:,318),[64,1,2,4,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,318),heltab2x128(:,:,318))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(318),n2h64(318))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(319),h0tab(:,319),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,319),heltab2x128(:,:,319))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(319),n2h64(319))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(320),h0tab(:,320),[64,1,2,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,320),heltab2x128(:,:,320))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(320),n2h64(320))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(321),h0tab(:,321),[64,1,2,4,16,32,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,321),heltab2x128(:,:,321))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(321),n2h64(321))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(322),h0tab(:,322),[64,1,2,4,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,322),heltab2x128(:,:,322))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(322),n2h64(322))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(323),h0tab(:,323),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,323),heltab2x128(:,:,323))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(323),n2h64(323))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(324),h0tab(:,324),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,324),heltab2x128(:,:,324))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(324),n2h64(324))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(325),h0tab(:,325),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,325),heltab2x128(:,:,325))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(325),n2h64(325))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(326),h0tab(:,326),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,326),heltab2x128(:,:,326))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(326),n2h64(326))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(327),h0tab(:,327),[64,1,2,4,16,32,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,327),heltab2x128(:,:,327))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(327),n2h64(327))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(328),h0tab(:,328),[64,1,2,4,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,328),heltab2x128(:,:,328))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(328),n2h64(328))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(329),h0tab(:,329),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,329),heltab2x128(:,:,329))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(329),n2h64(329))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(330),h0tab(:,330),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,330),heltab2x128(:,:,330))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(330),n2h64(330))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(331),h0tab(:,331),[64,1,2,4,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,331),heltab2x128(:,:,331))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(331),n2h64(331))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(332),h0tab(:,332),[64,1,2,4,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,332),heltab2x128(:,:,332))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(332),n2h64(332))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(333),h0tab(:,333),[64,1,2,4,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,333),heltab2x128(:,:,333))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(333),n2h64(333))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(334),h0tab(:,334),[64,1,2,4,32,16,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,334),heltab2x128(:,:,334))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(334),n2h64(334))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(335),h0tab(:,335),[64,1,2,4,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,335),heltab2x128(:,:,335))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(335),n2h64(335))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(336),h0tab(:,336),[64,1,2,4,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,336),heltab2x128(:,:,336))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(336),n2h64(336))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(337),h0tab(:,337),[64,1,2,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,337),heltab2x128(:,:,337))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(337),n2h64(337))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(338),h0tab(:,338),[64,1,2,4,32,16,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,338),heltab2x128(:,:,338))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(338),n2h64(338))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(339),h0tab(:,339),[64,1,2,4,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,339),heltab2x128(:,:,339))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(339),n2h64(339))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(340),h0tab(:,340),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,340),heltab2x128(:,:,340))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(340),n2h64(340))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(341),h0tab(:,341),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,341),heltab2x128(:,:,341))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(341),n2h64(341))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(342),h0tab(:,342),[64,1,2,4,32,16,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,342),heltab2x128(:,:,342))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(342),n2h64(342))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(343),h0tab(:,343),[64,1,2,4,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,343),heltab2x128(:,:,343))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(343),n2h64(343))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(344),h0tab(:,344),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,344),heltab2x128(:,:,344))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(344),n2h64(344))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(345),h0tab(:,345),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,345),heltab2x128(:,:,345))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(345),n2h64(345))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(346),h0tab(:,346),[64,1,2,4,32,16,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,346),heltab2x128(:,:,346))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(346),n2h64(346))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(347),h0tab(:,347),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,347),heltab2x128(:,:,347))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(347),n2h64(347))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(348),h0tab(:,348),[64,1,2,4,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,348),heltab2x128(:,:,348))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(348),n2h64(348))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(349),h0tab(:,349),[64,1,2,4,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,349),heltab2x128(:,:,349))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(349),n2h64(349))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(350),h0tab(:,350),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,350),heltab2x128(:,:,350))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(350),n2h64(350))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(351),h0tab(:,351),[64,1,2,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,351),heltab2x128(:,:,351))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(351),n2h64(351))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(352),h0tab(:,352),[64,1,2,4,32,16,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,352),heltab2x128(:,:,352))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(352),n2h64(352))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(353),h0tab(:,353),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,353),heltab2x128(:,:,353))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(353),n2h64(353))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(354),h0tab(:,354),[64,1,2,4,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,354),heltab2x128(:,:,354))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(354),n2h64(354))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(355),h0tab(:,355),[64,1,2,4,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,355),heltab2x128(:,:,355))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(355),n2h64(355))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(356),h0tab(:,356),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,356),heltab2x128(:,:,356))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(356),n2h64(356))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(357),h0tab(:,357),[64,1,2,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,357),heltab2x128(:,:,357))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(357),n2h64(357))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(358),h0tab(:,358),[64,1,2,4,32,16,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,358),heltab2x128(:,:,358))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(358),n2h64(358))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(359),h0tab(:,359),[64,1,2,4,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,359),heltab2x128(:,:,359))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(359),n2h64(359))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(360),h0tab(:,360),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,360),heltab2x128(:,:,360))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(360),n2h64(360))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(361),h0tab(:,361),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,361),heltab2x128(:,:,361))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(361),n2h64(361))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(362),h0tab(:,362),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,362),heltab2x128(:,:,362))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(362),n2h64(362))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(363),h0tab(:,363),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,363),heltab2x128(:,:,363))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(363),n2h64(363))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(364),h0tab(:,364),[64,1,2,4,32,16,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,364),heltab2x128(:,:,364))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(364),n2h64(364))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(365),h0tab(:,365),[64,1,2,4,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,365),heltab2x128(:,:,365))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(365),n2h64(365))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(366),h0tab(:,366),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,366),heltab2x128(:,:,366))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(366),n2h64(366))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(367),h0tab(:,367),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,367),heltab2x128(:,:,367))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(367),n2h64(367))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(368),h0tab(:,368),[64,1,2,4,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,368),heltab2x128(:,:,368))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(368),n2h64(368))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(369),h0tab(:,369),[64,1,2,4,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,369),heltab2x128(:,:,369))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(369),n2h64(369))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(370),h0tab(:,370),[64,1,2,4,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,370),heltab2x128(:,:,370))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(370),n2h64(370))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(371),h0tab(:,371),[64,1,2,8,32,16,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,371),heltab2x128(:,:,371))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(371),n2h64(371))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(372),h0tab(:,372),[64,1,2,8,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,372),heltab2x128(:,:,372))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(372),n2h64(372))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(373),h0tab(:,373),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,373),heltab2x128(:,:,373))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(373),n2h64(373))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(374),h0tab(:,374),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,374),heltab2x128(:,:,374))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(374),n2h64(374))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(375),h0tab(:,375),[64,1,2,8,32,16,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,375),heltab2x128(:,:,375))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(375),n2h64(375))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(376),h0tab(:,376),[64,1,2,8,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,376),heltab2x128(:,:,376))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(376),n2h64(376))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(377),h0tab(:,377),[64,1,2,8,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,377),heltab2x128(:,:,377))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(377),n2h64(377))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(378),h0tab(:,378),[64,1,2,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,378),heltab2x128(:,:,378))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(378),n2h64(378))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(379),h0tab(:,379),[64,1,2,8,32,16,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,379),heltab2x128(:,:,379))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(379),n2h64(379))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(380),h0tab(:,380),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,380),heltab2x128(:,:,380))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(380),n2h64(380))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(381),h0tab(:,381),[64,1,2,8,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,381),heltab2x128(:,:,381))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(381),n2h64(381))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(382),h0tab(:,382),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,382),heltab2x128(:,:,382))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(382),n2h64(382))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(383),h0tab(:,383),[64,1,2,8,32,16,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,383),heltab2x128(:,:,383))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(383),n2h64(383))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(384),h0tab(:,384),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,384),heltab2x128(:,:,384))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(384),n2h64(384))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(385),h0tab(:,385),[64,1,2,8,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,385),heltab2x128(:,:,385))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(385),n2h64(385))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(386),h0tab(:,386),[64,1,2,8,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,386),heltab2x128(:,:,386))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(386),n2h64(386))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(387),h0tab(:,387),[64,1,2,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,387),heltab2x128(:,:,387))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(387),n2h64(387))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(388),h0tab(:,388),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,388),heltab2x128(:,:,388))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(388),n2h64(388))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(389),h0tab(:,389),[64,1,2,8,32,16,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,389),heltab2x128(:,:,389))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(389),n2h64(389))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(390),h0tab(:,390),[64,1,2,8,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,390),heltab2x128(:,:,390))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(390),n2h64(390))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(391),h0tab(:,391),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,391),heltab2x128(:,:,391))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(391),n2h64(391))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(392),h0tab(:,392),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,392),heltab2x128(:,:,392))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(392),n2h64(392))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(393),h0tab(:,393),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,393),heltab2x128(:,:,393))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(393),n2h64(393))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(394),h0tab(:,394),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,394),heltab2x128(:,:,394))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(394),n2h64(394))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(395),h0tab(:,395),[64,1,2,8,32,16,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,395),heltab2x128(:,:,395))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(395),n2h64(395))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(396),h0tab(:,396),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,396),heltab2x128(:,:,396))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(396),n2h64(396))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(397),h0tab(:,397),[64,1,2,8,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,397),heltab2x128(:,:,397))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(397),n2h64(397))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(398),h0tab(:,398),[64,1,2,8,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,398),heltab2x128(:,:,398))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(398),n2h64(398))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(399),h0tab(:,399),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,399),heltab2x128(:,:,399))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(399),n2h64(399))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(400),h0tab(:,400),[64,1,2,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,400),heltab2x128(:,:,400))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(400),n2h64(400))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(401),h0tab(:,401),[64,1,2,8,32,16,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,401),heltab2x128(:,:,401))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(401),n2h64(401))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(402),h0tab(:,402),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,402),heltab2x128(:,:,402))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(402),n2h64(402))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(403),h0tab(:,403),[64,1,2,8,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,403),heltab2x128(:,:,403))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(403),n2h64(403))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(404),h0tab(:,404),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,404),heltab2x128(:,:,404))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(404),n2h64(404))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(405),h0tab(:,405),[64,1,2,8,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,405),heltab2x128(:,:,405))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(405),n2h64(405))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(406),h0tab(:,406),[64,1,2,8,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,406),heltab2x128(:,:,406))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(406),n2h64(406))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(407),h0tab(:,407),[64,1,2,8,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,407),heltab2x128(:,:,407))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(407),n2h64(407))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(408),h0tab(:,408),[64,1,2,8,16,32,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,408),heltab2x128(:,:,408))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(408),n2h64(408))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(409),h0tab(:,409),[64,1,2,8,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,409),heltab2x128(:,:,409))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(409),n2h64(409))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(410),h0tab(:,410),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,410),heltab2x128(:,:,410))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(410),n2h64(410))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(411),h0tab(:,411),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,411),heltab2x128(:,:,411))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(411),n2h64(411))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(412),h0tab(:,412),[64,1,2,8,16,32,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,412),heltab2x128(:,:,412))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(412),n2h64(412))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(413),h0tab(:,413),[64,1,2,8,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,413),heltab2x128(:,:,413))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(413),n2h64(413))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(414),h0tab(:,414),[64,1,2,8,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,414),heltab2x128(:,:,414))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(414),n2h64(414))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(415),h0tab(:,415),[64,1,2,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,415),heltab2x128(:,:,415))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(415),n2h64(415))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(416),h0tab(:,416),[64,1,2,8,16,32,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,416),heltab2x128(:,:,416))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(416),n2h64(416))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(417),h0tab(:,417),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,417),heltab2x128(:,:,417))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(417),n2h64(417))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(418),h0tab(:,418),[64,1,2,8,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,418),heltab2x128(:,:,418))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(418),n2h64(418))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(419),h0tab(:,419),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,419),heltab2x128(:,:,419))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(419),n2h64(419))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(420),h0tab(:,420),[64,1,2,8,16,32,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,420),heltab2x128(:,:,420))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(420),n2h64(420))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(421),h0tab(:,421),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,421),heltab2x128(:,:,421))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(421),n2h64(421))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(422),h0tab(:,422),[64,1,2,8,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,422),heltab2x128(:,:,422))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(422),n2h64(422))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(423),h0tab(:,423),[64,1,2,8,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,423),heltab2x128(:,:,423))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(423),n2h64(423))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(424),h0tab(:,424),[64,1,2,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,424),heltab2x128(:,:,424))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(424),n2h64(424))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(425),h0tab(:,425),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,425),heltab2x128(:,:,425))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(425),n2h64(425))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(426),h0tab(:,426),[64,1,2,8,16,32,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,426),heltab2x128(:,:,426))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(426),n2h64(426))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(427),h0tab(:,427),[64,1,2,8,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,427),heltab2x128(:,:,427))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(427),n2h64(427))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(428),h0tab(:,428),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,428),heltab2x128(:,:,428))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(428),n2h64(428))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(429),h0tab(:,429),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,429),heltab2x128(:,:,429))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(429),n2h64(429))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(430),h0tab(:,430),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,430),heltab2x128(:,:,430))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(430),n2h64(430))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(431),h0tab(:,431),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,431),heltab2x128(:,:,431))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(431),n2h64(431))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(432),h0tab(:,432),[64,1,2,8,16,32,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,432),heltab2x128(:,:,432))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(432),n2h64(432))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(433),h0tab(:,433),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,433),heltab2x128(:,:,433))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(433),n2h64(433))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(434),h0tab(:,434),[64,1,2,8,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,434),heltab2x128(:,:,434))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(434),n2h64(434))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(435),h0tab(:,435),[64,1,2,8,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,435),heltab2x128(:,:,435))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(435),n2h64(435))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(436),h0tab(:,436),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,436),heltab2x128(:,:,436))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(436),n2h64(436))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(437),h0tab(:,437),[64,1,2,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,437),heltab2x128(:,:,437))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(437),n2h64(437))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(438),h0tab(:,438),[64,1,2,8,16,32,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,438),heltab2x128(:,:,438))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(438),n2h64(438))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(439),h0tab(:,439),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,439),heltab2x128(:,:,439))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(439),n2h64(439))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(440),h0tab(:,440),[64,1,2,8,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,440),heltab2x128(:,:,440))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(440),n2h64(440))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(441),h0tab(:,441),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,441),heltab2x128(:,:,441))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(441),n2h64(441))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(442),h0tab(:,442),[64,1,2,8,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,442),heltab2x128(:,:,442))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(442),n2h64(442))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(443),h0tab(:,443),[64,1,2,8,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,443),heltab2x128(:,:,443))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(443),n2h64(443))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(444),h0tab(:,444),[64,1,2,8,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,444),heltab2x128(:,:,444))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(444),n2h64(444))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(445),h0tab(:,445),[64,16,2,4,1,8,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,445),heltab2x128(:,:,445))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(445),n2h64(445))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(446),h0tab(:,446),[64,16,2,4,1,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,446),heltab2x128(:,:,446))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(446),n2h64(446))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(447),h0tab(:,447),[64,16,2,4,1,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,447),heltab2x128(:,:,447))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(447),n2h64(447))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(448),h0tab(:,448),[64,16,2,4,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,448),heltab2x128(:,:,448))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(448),n2h64(448))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(449),h0tab(:,449),[64,16,2,4,1,8,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,449),heltab2x128(:,:,449))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(449),n2h64(449))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(450),h0tab(:,450),[64,16,2,4,1,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,450),heltab2x128(:,:,450))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(450),n2h64(450))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(451),h0tab(:,451),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,451),heltab2x128(:,:,451))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(451),n2h64(451))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(452),h0tab(:,452),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,452),heltab2x128(:,:,452))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(452),n2h64(452))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(453),h0tab(:,453),[64,16,2,4,1,8,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,453),heltab2x128(:,:,453))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(453),n2h64(453))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(454),h0tab(:,454),[64,16,2,4,1,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,454),heltab2x128(:,:,454))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(454),n2h64(454))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(455),h0tab(:,455),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,455),heltab2x128(:,:,455))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(455),n2h64(455))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(456),h0tab(:,456),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,456),heltab2x128(:,:,456))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(456),n2h64(456))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(457),h0tab(:,457),[64,16,2,4,1,8,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,457),heltab2x128(:,:,457))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(457),n2h64(457))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(458),h0tab(:,458),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,458),heltab2x128(:,:,458))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(458),n2h64(458))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(459),h0tab(:,459),[64,16,2,4,1,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,459),heltab2x128(:,:,459))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(459),n2h64(459))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(460),h0tab(:,460),[64,16,2,4,1,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,460),heltab2x128(:,:,460))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(460),n2h64(460))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(461),h0tab(:,461),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,461),heltab2x128(:,:,461))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(461),n2h64(461))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(462),h0tab(:,462),[64,16,2,4,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,462),heltab2x128(:,:,462))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(462),n2h64(462))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(463),h0tab(:,463),[64,16,2,4,1,8,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,463),heltab2x128(:,:,463))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(463),n2h64(463))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(464),h0tab(:,464),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,464),heltab2x128(:,:,464))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(464),n2h64(464))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(465),h0tab(:,465),[64,16,2,4,1,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,465),heltab2x128(:,:,465))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(465),n2h64(465))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(466),h0tab(:,466),[64,16,2,4,1,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,466),heltab2x128(:,:,466))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(466),n2h64(466))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(467),h0tab(:,467),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,467),heltab2x128(:,:,467))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(467),n2h64(467))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(468),h0tab(:,468),[64,16,2,4,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,468),heltab2x128(:,:,468))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(468),n2h64(468))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(469),h0tab(:,469),[64,16,2,4,1,8,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,469),heltab2x128(:,:,469))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(469),n2h64(469))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(470),h0tab(:,470),[64,16,2,4,1,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,470),heltab2x128(:,:,470))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(470),n2h64(470))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(471),h0tab(:,471),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,471),heltab2x128(:,:,471))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(471),n2h64(471))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(472),h0tab(:,472),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,472),heltab2x128(:,:,472))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(472),n2h64(472))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(473),h0tab(:,473),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,473),heltab2x128(:,:,473))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(473),n2h64(473))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(474),h0tab(:,474),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,474),heltab2x128(:,:,474))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(474),n2h64(474))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(475),h0tab(:,475),[64,16,2,4,1,8,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,475),heltab2x128(:,:,475))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(475),n2h64(475))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(476),h0tab(:,476),[64,16,2,4,1,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,476),heltab2x128(:,:,476))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(476),n2h64(476))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(477),h0tab(:,477),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,477),heltab2x128(:,:,477))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(477),n2h64(477))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(478),h0tab(:,478),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,478),heltab2x128(:,:,478))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(478),n2h64(478))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(479),h0tab(:,479),[64,16,2,4,1,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,479),heltab2x128(:,:,479))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(479),n2h64(479))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(480),h0tab(:,480),[64,16,2,4,1,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,480),heltab2x128(:,:,480))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(480),n2h64(480))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(481),h0tab(:,481),[64,16,2,4,1,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,481),heltab2x128(:,:,481))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(481),n2h64(481))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(482),h0tab(:,482),[64,16,8,1,4,2,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,482),heltab2x128(:,:,482))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(482),n2h64(482))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(483),h0tab(:,483),[64,16,8,1,4,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,483),heltab2x128(:,:,483))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(483),n2h64(483))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(484),h0tab(:,484),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,484),heltab2x128(:,:,484))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(484),n2h64(484))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(485),h0tab(:,485),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,485),heltab2x128(:,:,485))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(485),n2h64(485))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(486),h0tab(:,486),[64,16,8,1,4,2,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,486),heltab2x128(:,:,486))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(486),n2h64(486))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(487),h0tab(:,487),[64,16,8,1,4,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,487),heltab2x128(:,:,487))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(487),n2h64(487))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(488),h0tab(:,488),[64,16,8,1,4,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,488),heltab2x128(:,:,488))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(488),n2h64(488))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(489),h0tab(:,489),[64,16,8,1,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,489),heltab2x128(:,:,489))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(489),n2h64(489))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(490),h0tab(:,490),[64,16,8,1,4,2,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,490),heltab2x128(:,:,490))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(490),n2h64(490))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(491),h0tab(:,491),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,491),heltab2x128(:,:,491))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(491),n2h64(491))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(492),h0tab(:,492),[64,16,8,1,4,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,492),heltab2x128(:,:,492))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(492),n2h64(492))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(493),h0tab(:,493),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,493),heltab2x128(:,:,493))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(493),n2h64(493))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(494),h0tab(:,494),[64,16,8,1,4,2,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,494),heltab2x128(:,:,494))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(494),n2h64(494))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(495),h0tab(:,495),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,495),heltab2x128(:,:,495))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(495),n2h64(495))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(496),h0tab(:,496),[64,16,8,1,4,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,496),heltab2x128(:,:,496))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(496),n2h64(496))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(497),h0tab(:,497),[64,16,8,1,4,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,497),heltab2x128(:,:,497))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(497),n2h64(497))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(498),h0tab(:,498),[64,16,8,1,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,498),heltab2x128(:,:,498))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(498),n2h64(498))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(499),h0tab(:,499),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,499),heltab2x128(:,:,499))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(499),n2h64(499))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(500),h0tab(:,500),[64,16,8,1,4,2,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,500),heltab2x128(:,:,500))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(500),n2h64(500))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(501),h0tab(:,501),[64,16,8,1,4,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,501),heltab2x128(:,:,501))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(501),n2h64(501))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(502),h0tab(:,502),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,502),heltab2x128(:,:,502))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(502),n2h64(502))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(503),h0tab(:,503),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,503),heltab2x128(:,:,503))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(503),n2h64(503))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(504),h0tab(:,504),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,504),heltab2x128(:,:,504))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(504),n2h64(504))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(505),h0tab(:,505),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,505),heltab2x128(:,:,505))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(505),n2h64(505))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(506),h0tab(:,506),[64,16,8,1,4,2,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,506),heltab2x128(:,:,506))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(506),n2h64(506))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(507),h0tab(:,507),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,507),heltab2x128(:,:,507))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(507),n2h64(507))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(508),h0tab(:,508),[64,16,8,1,4,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,508),heltab2x128(:,:,508))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(508),n2h64(508))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(509),h0tab(:,509),[64,16,8,1,4,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,509),heltab2x128(:,:,509))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(509),n2h64(509))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(510),h0tab(:,510),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,510),heltab2x128(:,:,510))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(510),n2h64(510))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(511),h0tab(:,511),[64,16,8,1,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,511),heltab2x128(:,:,511))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(511),n2h64(511))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(512),h0tab(:,512),[64,16,8,1,4,2,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,512),heltab2x128(:,:,512))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(512),n2h64(512))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(513),h0tab(:,513),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,513),heltab2x128(:,:,513))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(513),n2h64(513))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(514),h0tab(:,514),[64,16,8,1,4,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,514),heltab2x128(:,:,514))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(514),n2h64(514))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(515),h0tab(:,515),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,515),heltab2x128(:,:,515))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(515),n2h64(515))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(516),h0tab(:,516),[64,16,8,1,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,516),heltab2x128(:,:,516))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(516),n2h64(516))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(517),h0tab(:,517),[64,16,8,1,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,517),heltab2x128(:,:,517))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(517),n2h64(517))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(518),h0tab(:,518),[64,16,8,1,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,518),heltab2x128(:,:,518))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(518),n2h64(518))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(519),h0tab(:,519),[64,16,2,8,1,4,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,519),heltab2x128(:,:,519))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(519),n2h64(519))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(520),h0tab(:,520),[64,16,2,8,1,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,520),heltab2x128(:,:,520))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(520),n2h64(520))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(521),h0tab(:,521),[64,16,2,8,1,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,521),heltab2x128(:,:,521))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(521),n2h64(521))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(522),h0tab(:,522),[64,16,2,8,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,522),heltab2x128(:,:,522))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(522),n2h64(522))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(523),h0tab(:,523),[64,16,2,8,1,4,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,523),heltab2x128(:,:,523))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(523),n2h64(523))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(524),h0tab(:,524),[64,16,2,8,1,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,524),heltab2x128(:,:,524))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(524),n2h64(524))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(525),h0tab(:,525),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,525),heltab2x128(:,:,525))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(525),n2h64(525))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(526),h0tab(:,526),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,526),heltab2x128(:,:,526))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(526),n2h64(526))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(527),h0tab(:,527),[64,16,2,8,1,4,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,527),heltab2x128(:,:,527))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(527),n2h64(527))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(528),h0tab(:,528),[64,16,2,8,1,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,528),heltab2x128(:,:,528))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(528),n2h64(528))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(529),h0tab(:,529),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,529),heltab2x128(:,:,529))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(529),n2h64(529))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(530),h0tab(:,530),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,530),heltab2x128(:,:,530))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(530),n2h64(530))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(531),h0tab(:,531),[64,16,2,8,1,4,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,531),heltab2x128(:,:,531))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(531),n2h64(531))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(532),h0tab(:,532),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,532),heltab2x128(:,:,532))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(532),n2h64(532))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(533),h0tab(:,533),[64,16,2,8,1,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,533),heltab2x128(:,:,533))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(533),n2h64(533))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(534),h0tab(:,534),[64,16,2,8,1,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,534),heltab2x128(:,:,534))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(534),n2h64(534))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(535),h0tab(:,535),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,535),heltab2x128(:,:,535))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(535),n2h64(535))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(536),h0tab(:,536),[64,16,2,8,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,536),heltab2x128(:,:,536))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(536),n2h64(536))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(537),h0tab(:,537),[64,16,2,8,1,4,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,537),heltab2x128(:,:,537))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(537),n2h64(537))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(538),h0tab(:,538),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,538),heltab2x128(:,:,538))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(538),n2h64(538))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(539),h0tab(:,539),[64,16,2,8,1,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,539),heltab2x128(:,:,539))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(539),n2h64(539))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(540),h0tab(:,540),[64,16,2,8,1,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,540),heltab2x128(:,:,540))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(540),n2h64(540))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(541),h0tab(:,541),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,541),heltab2x128(:,:,541))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(541),n2h64(541))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(542),h0tab(:,542),[64,16,2,8,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,542),heltab2x128(:,:,542))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(542),n2h64(542))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(543),h0tab(:,543),[64,16,2,8,1,4,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,543),heltab2x128(:,:,543))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(543),n2h64(543))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(544),h0tab(:,544),[64,16,2,8,1,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,544),heltab2x128(:,:,544))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(544),n2h64(544))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(545),h0tab(:,545),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,545),heltab2x128(:,:,545))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(545),n2h64(545))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(546),h0tab(:,546),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,546),heltab2x128(:,:,546))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(546),n2h64(546))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(547),h0tab(:,547),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,547),heltab2x128(:,:,547))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(547),n2h64(547))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(548),h0tab(:,548),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,548),heltab2x128(:,:,548))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(548),n2h64(548))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(549),h0tab(:,549),[64,16,2,8,1,4,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,549),heltab2x128(:,:,549))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(549),n2h64(549))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(550),h0tab(:,550),[64,16,2,8,1,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,550),heltab2x128(:,:,550))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(550),n2h64(550))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(551),h0tab(:,551),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,551),heltab2x128(:,:,551))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(551),n2h64(551))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(552),h0tab(:,552),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,552),heltab2x128(:,:,552))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(552),n2h64(552))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(553),h0tab(:,553),[64,16,2,8,1,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,553),heltab2x128(:,:,553))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(553),n2h64(553))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(554),h0tab(:,554),[64,16,2,8,1,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,554),heltab2x128(:,:,554))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(554),n2h64(554))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(555),h0tab(:,555),[64,16,2,8,1,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,555),heltab2x128(:,:,555))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(555),n2h64(555))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(556),h0tab(:,556),[64,16,4,1,8,2,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,556),heltab2x128(:,:,556))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(556),n2h64(556))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(557),h0tab(:,557),[64,16,4,1,8,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,557),heltab2x128(:,:,557))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(557),n2h64(557))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(558),h0tab(:,558),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,558),heltab2x128(:,:,558))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(558),n2h64(558))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(559),h0tab(:,559),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,559),heltab2x128(:,:,559))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(559),n2h64(559))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(560),h0tab(:,560),[64,16,4,1,8,2,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,560),heltab2x128(:,:,560))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(560),n2h64(560))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(561),h0tab(:,561),[64,16,4,1,8,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,561),heltab2x128(:,:,561))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(561),n2h64(561))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(562),h0tab(:,562),[64,16,4,1,8,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,562),heltab2x128(:,:,562))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(562),n2h64(562))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(563),h0tab(:,563),[64,16,4,1,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,563),heltab2x128(:,:,563))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(563),n2h64(563))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(564),h0tab(:,564),[64,16,4,1,8,2,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,564),heltab2x128(:,:,564))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(564),n2h64(564))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(565),h0tab(:,565),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,565),heltab2x128(:,:,565))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(565),n2h64(565))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(566),h0tab(:,566),[64,16,4,1,8,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,566),heltab2x128(:,:,566))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(566),n2h64(566))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(567),h0tab(:,567),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,567),heltab2x128(:,:,567))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(567),n2h64(567))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(568),h0tab(:,568),[64,16,4,1,8,2,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,568),heltab2x128(:,:,568))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(568),n2h64(568))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(569),h0tab(:,569),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,569),heltab2x128(:,:,569))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(569),n2h64(569))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(570),h0tab(:,570),[64,16,4,1,8,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,570),heltab2x128(:,:,570))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(570),n2h64(570))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(571),h0tab(:,571),[64,16,4,1,8,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,571),heltab2x128(:,:,571))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(571),n2h64(571))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(572),h0tab(:,572),[64,16,4,1,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,572),heltab2x128(:,:,572))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(572),n2h64(572))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(573),h0tab(:,573),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,573),heltab2x128(:,:,573))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(573),n2h64(573))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(574),h0tab(:,574),[64,16,4,1,8,2,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,574),heltab2x128(:,:,574))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(574),n2h64(574))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(575),h0tab(:,575),[64,16,4,1,8,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,575),heltab2x128(:,:,575))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(575),n2h64(575))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(576),h0tab(:,576),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,576),heltab2x128(:,:,576))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(576),n2h64(576))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(577),h0tab(:,577),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,577),heltab2x128(:,:,577))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(577),n2h64(577))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(578),h0tab(:,578),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,578),heltab2x128(:,:,578))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(578),n2h64(578))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(579),h0tab(:,579),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,579),heltab2x128(:,:,579))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(579),n2h64(579))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(580),h0tab(:,580),[64,16,4,1,8,2,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,580),heltab2x128(:,:,580))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(580),n2h64(580))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(581),h0tab(:,581),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,581),heltab2x128(:,:,581))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(581),n2h64(581))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(582),h0tab(:,582),[64,16,4,1,8,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,582),heltab2x128(:,:,582))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(582),n2h64(582))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(583),h0tab(:,583),[64,16,4,1,8,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,583),heltab2x128(:,:,583))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(583),n2h64(583))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(584),h0tab(:,584),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,584),heltab2x128(:,:,584))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(584),n2h64(584))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(585),h0tab(:,585),[64,16,4,1,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,585),heltab2x128(:,:,585))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(585),n2h64(585))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(586),h0tab(:,586),[64,16,4,1,8,2,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,586),heltab2x128(:,:,586))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(586),n2h64(586))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(587),h0tab(:,587),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,587),heltab2x128(:,:,587))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(587),n2h64(587))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(588),h0tab(:,588),[64,16,4,1,8,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,588),heltab2x128(:,:,588))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(588),n2h64(588))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(589),h0tab(:,589),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,589),heltab2x128(:,:,589))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(589),n2h64(589))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(590),h0tab(:,590),[64,16,4,1,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,590),heltab2x128(:,:,590))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(590),n2h64(590))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(591),h0tab(:,591),[64,16,4,1,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,591),heltab2x128(:,:,591))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(591),n2h64(591))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(592),h0tab(:,592),[64,16,4,1,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,592),heltab2x128(:,:,592))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(592),n2h64(592))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(593),h0tab(:,593),[64,2,16,32,4,1,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,593),heltab2x128(:,:,593))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(593),n2h64(593))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(594),h0tab(:,594),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,594),heltab2x128(:,:,594))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(594),n2h64(594))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(595),h0tab(:,595),[64,2,16,32,4,1,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,595),heltab2x128(:,:,595))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(595),n2h64(595))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(596),h0tab(:,596),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,596),heltab2x128(:,:,596))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(596),n2h64(596))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(597),h0tab(:,597),[64,2,16,32,4,1,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,597),heltab2x128(:,:,597))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(597),n2h64(597))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(598),h0tab(:,598),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,598),heltab2x128(:,:,598))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(598),n2h64(598))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(599),h0tab(:,599),[64,2,16,32,4,1,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,599),heltab2x128(:,:,599))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(599),n2h64(599))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(600),h0tab(:,600),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,600),heltab2x128(:,:,600))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(600),n2h64(600))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(601),h0tab(:,601),[64,2,16,32,4,1,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,601),heltab2x128(:,:,601))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(601),n2h64(601))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(602),h0tab(:,602),[64,2,16,32,4,1,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,602),heltab2x128(:,:,602))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(602),n2h64(602))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(603),h0tab(:,603),[64,2,16,32,4,1,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,603),heltab2x128(:,:,603))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(603),n2h64(603))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(604),h0tab(:,604),[64,2,16,32,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,604),heltab2x128(:,:,604))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(604),n2h64(604))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(605),h0tab(:,605),[64,2,16,32,4,1,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,605),heltab2x128(:,:,605))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(605),n2h64(605))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(606),h0tab(:,606),[64,2,16,32,4,1,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,606),heltab2x128(:,:,606))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(606),n2h64(606))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(607),h0tab(:,607),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,607),heltab2x128(:,:,607))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(607),n2h64(607))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(608),h0tab(:,608),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,608),heltab2x128(:,:,608))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(608),n2h64(608))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(609),h0tab(:,609),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,609),heltab2x128(:,:,609))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(609),n2h64(609))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(610),h0tab(:,610),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,610),heltab2x128(:,:,610))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(610),n2h64(610))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(611),h0tab(:,611),[64,2,16,32,4,1,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,611),heltab2x128(:,:,611))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(611),n2h64(611))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(612),h0tab(:,612),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,612),heltab2x128(:,:,612))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(612),n2h64(612))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(613),h0tab(:,613),[64,2,16,32,4,1,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,613),heltab2x128(:,:,613))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(613),n2h64(613))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(614),h0tab(:,614),[64,2,16,32,4,1,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,614),heltab2x128(:,:,614))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(614),n2h64(614))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(615),h0tab(:,615),[64,2,16,32,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,615),heltab2x128(:,:,615))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(615),n2h64(615))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(616),h0tab(:,616),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,616),heltab2x128(:,:,616))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(616),n2h64(616))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(617),h0tab(:,617),[64,2,16,32,4,1,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,617),heltab2x128(:,:,617))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(617),n2h64(617))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(618),h0tab(:,618),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,618),heltab2x128(:,:,618))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(618),n2h64(618))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(619),h0tab(:,619),[64,2,16,32,4,1,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,619),heltab2x128(:,:,619))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(619),n2h64(619))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(620),h0tab(:,620),[64,2,16,32,4,1,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,620),heltab2x128(:,:,620))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(620),n2h64(620))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(621),h0tab(:,621),[64,2,16,32,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,621),heltab2x128(:,:,621))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(621),n2h64(621))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(622),h0tab(:,622),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,622),heltab2x128(:,:,622))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(622),n2h64(622))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(623),h0tab(:,623),[64,2,16,32,4,1,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,623),heltab2x128(:,:,623))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(623),n2h64(623))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(624),h0tab(:,624),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,624),heltab2x128(:,:,624))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(624),n2h64(624))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(625),h0tab(:,625),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,625),heltab2x128(:,:,625))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(625),n2h64(625))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(626),h0tab(:,626),[64,2,16,32,4,1,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,626),heltab2x128(:,:,626))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(626),n2h64(626))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(627),h0tab(:,627),[64,2,16,32,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,627),heltab2x128(:,:,627))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(627),n2h64(627))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(628),h0tab(:,628),[64,2,16,32,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,628),heltab2x128(:,:,628))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(628),n2h64(628))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(629),h0tab(:,629),[64,2,16,32,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,629),heltab2x128(:,:,629))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(629),n2h64(629))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(630),h0tab(:,630),[64,2,16,32,8,1,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,630),heltab2x128(:,:,630))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(630),n2h64(630))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(631),h0tab(:,631),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,631),heltab2x128(:,:,631))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(631),n2h64(631))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(632),h0tab(:,632),[64,2,16,32,8,1,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,632),heltab2x128(:,:,632))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(632),n2h64(632))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(633),h0tab(:,633),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,633),heltab2x128(:,:,633))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(633),n2h64(633))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(634),h0tab(:,634),[64,2,16,32,8,1,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,634),heltab2x128(:,:,634))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(634),n2h64(634))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(635),h0tab(:,635),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,635),heltab2x128(:,:,635))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(635),n2h64(635))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(636),h0tab(:,636),[64,2,16,32,8,1,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,636),heltab2x128(:,:,636))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(636),n2h64(636))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(637),h0tab(:,637),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,637),heltab2x128(:,:,637))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(637),n2h64(637))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(638),h0tab(:,638),[64,2,16,32,8,1,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,638),heltab2x128(:,:,638))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(638),n2h64(638))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(639),h0tab(:,639),[64,2,16,32,8,1,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,639),heltab2x128(:,:,639))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(639),n2h64(639))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(640),h0tab(:,640),[64,2,16,32,8,1,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,640),heltab2x128(:,:,640))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(640),n2h64(640))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(641),h0tab(:,641),[64,2,16,32,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,641),heltab2x128(:,:,641))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(641),n2h64(641))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(642),h0tab(:,642),[64,2,16,32,8,1,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,642),heltab2x128(:,:,642))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(642),n2h64(642))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(643),h0tab(:,643),[64,2,16,32,8,1,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,643),heltab2x128(:,:,643))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(643),n2h64(643))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(644),h0tab(:,644),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,644),heltab2x128(:,:,644))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(644),n2h64(644))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(645),h0tab(:,645),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,645),heltab2x128(:,:,645))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(645),n2h64(645))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(646),h0tab(:,646),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,646),heltab2x128(:,:,646))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(646),n2h64(646))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(647),h0tab(:,647),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,647),heltab2x128(:,:,647))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(647),n2h64(647))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(648),h0tab(:,648),[64,2,16,32,8,1,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,648),heltab2x128(:,:,648))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(648),n2h64(648))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(649),h0tab(:,649),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,649),heltab2x128(:,:,649))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(649),n2h64(649))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(650),h0tab(:,650),[64,2,16,32,8,1,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,650),heltab2x128(:,:,650))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(650),n2h64(650))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(651),h0tab(:,651),[64,2,16,32,8,1,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,651),heltab2x128(:,:,651))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(651),n2h64(651))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(652),h0tab(:,652),[64,2,16,32,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,652),heltab2x128(:,:,652))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(652),n2h64(652))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(653),h0tab(:,653),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,653),heltab2x128(:,:,653))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(653),n2h64(653))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(654),h0tab(:,654),[64,2,16,32,8,1,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,654),heltab2x128(:,:,654))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(654),n2h64(654))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(655),h0tab(:,655),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,655),heltab2x128(:,:,655))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(655),n2h64(655))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(656),h0tab(:,656),[64,2,16,32,8,1,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,656),heltab2x128(:,:,656))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(656),n2h64(656))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(657),h0tab(:,657),[64,2,16,32,8,1,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,657),heltab2x128(:,:,657))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(657),n2h64(657))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(658),h0tab(:,658),[64,2,16,32,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,658),heltab2x128(:,:,658))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(658),n2h64(658))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(659),h0tab(:,659),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,659),heltab2x128(:,:,659))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(659),n2h64(659))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(660),h0tab(:,660),[64,2,16,32,8,1,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,660),heltab2x128(:,:,660))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(660),n2h64(660))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(661),h0tab(:,661),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,661),heltab2x128(:,:,661))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(661),n2h64(661))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(662),h0tab(:,662),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,662),heltab2x128(:,:,662))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(662),n2h64(662))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(663),h0tab(:,663),[64,2,16,32,8,1,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,663),heltab2x128(:,:,663))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(663),n2h64(663))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(664),h0tab(:,664),[64,2,16,32,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,664),heltab2x128(:,:,664))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(664),n2h64(664))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(665),h0tab(:,665),[64,2,16,32,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,665),heltab2x128(:,:,665))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(665),n2h64(665))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(666),h0tab(:,666),[64,2,16,32,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,666),heltab2x128(:,:,666))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(666),n2h64(666))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(667),h0tab(:,667),[64,2,32,16,4,1,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,667),heltab2x128(:,:,667))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(667),n2h64(667))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(668),h0tab(:,668),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,668),heltab2x128(:,:,668))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(668),n2h64(668))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(669),h0tab(:,669),[64,2,32,16,4,1,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,669),heltab2x128(:,:,669))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(669),n2h64(669))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(670),h0tab(:,670),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,670),heltab2x128(:,:,670))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(670),n2h64(670))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(671),h0tab(:,671),[64,2,32,16,4,1,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,671),heltab2x128(:,:,671))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(671),n2h64(671))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(672),h0tab(:,672),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,672),heltab2x128(:,:,672))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(672),n2h64(672))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(673),h0tab(:,673),[64,2,32,16,4,1,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,673),heltab2x128(:,:,673))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(673),n2h64(673))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(674),h0tab(:,674),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,674),heltab2x128(:,:,674))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(674),n2h64(674))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(675),h0tab(:,675),[64,2,32,16,4,1,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,675),heltab2x128(:,:,675))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(675),n2h64(675))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(676),h0tab(:,676),[64,2,32,16,4,1,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,676),heltab2x128(:,:,676))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(676),n2h64(676))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(677),h0tab(:,677),[64,2,32,16,4,1,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,677),heltab2x128(:,:,677))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(677),n2h64(677))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(678),h0tab(:,678),[64,2,32,16,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,678),heltab2x128(:,:,678))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(678),n2h64(678))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(679),h0tab(:,679),[64,2,32,16,4,1,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,679),heltab2x128(:,:,679))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(679),n2h64(679))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(680),h0tab(:,680),[64,2,32,16,4,1,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,680),heltab2x128(:,:,680))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(680),n2h64(680))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(681),h0tab(:,681),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,681),heltab2x128(:,:,681))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(681),n2h64(681))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(682),h0tab(:,682),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,682),heltab2x128(:,:,682))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(682),n2h64(682))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(683),h0tab(:,683),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,683),heltab2x128(:,:,683))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(683),n2h64(683))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(684),h0tab(:,684),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,684),heltab2x128(:,:,684))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(684),n2h64(684))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(685),h0tab(:,685),[64,2,32,16,4,1,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,685),heltab2x128(:,:,685))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(685),n2h64(685))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(686),h0tab(:,686),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,686),heltab2x128(:,:,686))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(686),n2h64(686))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(687),h0tab(:,687),[64,2,32,16,4,1,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,687),heltab2x128(:,:,687))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(687),n2h64(687))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(688),h0tab(:,688),[64,2,32,16,4,1,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,688),heltab2x128(:,:,688))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(688),n2h64(688))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(689),h0tab(:,689),[64,2,32,16,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,689),heltab2x128(:,:,689))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(689),n2h64(689))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(690),h0tab(:,690),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,690),heltab2x128(:,:,690))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(690),n2h64(690))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(691),h0tab(:,691),[64,2,32,16,4,1,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,691),heltab2x128(:,:,691))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(691),n2h64(691))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(692),h0tab(:,692),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,692),heltab2x128(:,:,692))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(692),n2h64(692))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(693),h0tab(:,693),[64,2,32,16,4,1,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,693),heltab2x128(:,:,693))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(693),n2h64(693))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(694),h0tab(:,694),[64,2,32,16,4,1,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,694),heltab2x128(:,:,694))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(694),n2h64(694))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(695),h0tab(:,695),[64,2,32,16,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,695),heltab2x128(:,:,695))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(695),n2h64(695))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(696),h0tab(:,696),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,696),heltab2x128(:,:,696))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(696),n2h64(696))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(697),h0tab(:,697),[64,2,32,16,4,1,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,697),heltab2x128(:,:,697))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(697),n2h64(697))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(698),h0tab(:,698),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,698),heltab2x128(:,:,698))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(698),n2h64(698))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(699),h0tab(:,699),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,699),heltab2x128(:,:,699))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(699),n2h64(699))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(700),h0tab(:,700),[64,2,32,16,4,1,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,700),heltab2x128(:,:,700))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(700),n2h64(700))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(701),h0tab(:,701),[64,2,32,16,4,1,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,701),heltab2x128(:,:,701))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(701),n2h64(701))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(702),h0tab(:,702),[64,2,32,16,4,1,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,702),heltab2x128(:,:,702))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(702),n2h64(702))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(703),h0tab(:,703),[64,2,32,16,4,1,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,703),heltab2x128(:,:,703))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(703),n2h64(703))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(704),h0tab(:,704),[64,2,32,16,8,1,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,704),heltab2x128(:,:,704))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(704),n2h64(704))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(705),h0tab(:,705),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,705),heltab2x128(:,:,705))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(705),n2h64(705))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(706),h0tab(:,706),[64,2,32,16,8,1,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,706),heltab2x128(:,:,706))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(706),n2h64(706))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(707),h0tab(:,707),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,707),heltab2x128(:,:,707))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(707),n2h64(707))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(708),h0tab(:,708),[64,2,32,16,8,1,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,708),heltab2x128(:,:,708))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(708),n2h64(708))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(709),h0tab(:,709),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,709),heltab2x128(:,:,709))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(709),n2h64(709))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(710),h0tab(:,710),[64,2,32,16,8,1,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,710),heltab2x128(:,:,710))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(710),n2h64(710))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(711),h0tab(:,711),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,711),heltab2x128(:,:,711))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(711),n2h64(711))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(712),h0tab(:,712),[64,2,32,16,8,1,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,712),heltab2x128(:,:,712))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(712),n2h64(712))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(713),h0tab(:,713),[64,2,32,16,8,1,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,713),heltab2x128(:,:,713))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(713),n2h64(713))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(714),h0tab(:,714),[64,2,32,16,8,1,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,714),heltab2x128(:,:,714))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(714),n2h64(714))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(715),h0tab(:,715),[64,2,32,16,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,715),heltab2x128(:,:,715))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(715),n2h64(715))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(716),h0tab(:,716),[64,2,32,16,8,1,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,716),heltab2x128(:,:,716))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(716),n2h64(716))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(717),h0tab(:,717),[64,2,32,16,8,1,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,717),heltab2x128(:,:,717))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(717),n2h64(717))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(718),h0tab(:,718),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,718),heltab2x128(:,:,718))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(718),n2h64(718))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(719),h0tab(:,719),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,719),heltab2x128(:,:,719))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(719),n2h64(719))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(720),h0tab(:,720),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,720),heltab2x128(:,:,720))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(720),n2h64(720))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(721),h0tab(:,721),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,721),heltab2x128(:,:,721))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(721),n2h64(721))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(722),h0tab(:,722),[64,2,32,16,8,1,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,722),heltab2x128(:,:,722))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(722),n2h64(722))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(723),h0tab(:,723),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,723),heltab2x128(:,:,723))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(723),n2h64(723))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(724),h0tab(:,724),[64,2,32,16,8,1,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,724),heltab2x128(:,:,724))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(724),n2h64(724))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(725),h0tab(:,725),[64,2,32,16,8,1,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,725),heltab2x128(:,:,725))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(725),n2h64(725))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(726),h0tab(:,726),[64,2,32,16,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,726),heltab2x128(:,:,726))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(726),n2h64(726))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(727),h0tab(:,727),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,727),heltab2x128(:,:,727))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(727),n2h64(727))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(728),h0tab(:,728),[64,2,32,16,8,1,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,728),heltab2x128(:,:,728))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(728),n2h64(728))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(729),h0tab(:,729),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,729),heltab2x128(:,:,729))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(729),n2h64(729))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(730),h0tab(:,730),[64,2,32,16,8,1,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,730),heltab2x128(:,:,730))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(730),n2h64(730))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(731),h0tab(:,731),[64,2,32,16,8,1,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,731),heltab2x128(:,:,731))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(731),n2h64(731))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(732),h0tab(:,732),[64,2,32,16,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,732),heltab2x128(:,:,732))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(732),n2h64(732))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(733),h0tab(:,733),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,733),heltab2x128(:,:,733))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(733),n2h64(733))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(734),h0tab(:,734),[64,2,32,16,8,1,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,734),heltab2x128(:,:,734))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(734),n2h64(734))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(735),h0tab(:,735),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,735),heltab2x128(:,:,735))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(735),n2h64(735))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(736),h0tab(:,736),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,736),heltab2x128(:,:,736))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(736),n2h64(736))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(737),h0tab(:,737),[64,2,32,16,8,1,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,737),heltab2x128(:,:,737))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(737),n2h64(737))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(738),h0tab(:,738),[64,2,32,16,8,1,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,738),heltab2x128(:,:,738))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(738),n2h64(738))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(739),h0tab(:,739),[64,2,32,16,8,1,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,739),heltab2x128(:,:,739))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(739),n2h64(739))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(740),h0tab(:,740),[64,2,32,16,8,1,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,740),heltab2x128(:,:,740))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(740),n2h64(740))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(741),h0tab(:,741),[64,16,1,4,2,8,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,741),heltab2x128(:,:,741))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(741),n2h64(741))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(742),h0tab(:,742),[64,16,1,4,2,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,742),heltab2x128(:,:,742))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(742),n2h64(742))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(743),h0tab(:,743),[64,16,1,4,2,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,743),heltab2x128(:,:,743))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(743),n2h64(743))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(744),h0tab(:,744),[64,16,1,4,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,744),heltab2x128(:,:,744))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(744),n2h64(744))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(745),h0tab(:,745),[64,16,1,4,2,8,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,745),heltab2x128(:,:,745))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(745),n2h64(745))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(746),h0tab(:,746),[64,16,1,4,2,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,746),heltab2x128(:,:,746))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(746),n2h64(746))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(747),h0tab(:,747),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,747),heltab2x128(:,:,747))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(747),n2h64(747))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(748),h0tab(:,748),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,748),heltab2x128(:,:,748))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(748),n2h64(748))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(749),h0tab(:,749),[64,16,1,4,2,8,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,749),heltab2x128(:,:,749))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(749),n2h64(749))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(750),h0tab(:,750),[64,16,1,4,2,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,750),heltab2x128(:,:,750))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(750),n2h64(750))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(751),h0tab(:,751),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,751),heltab2x128(:,:,751))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(751),n2h64(751))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(752),h0tab(:,752),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,752),heltab2x128(:,:,752))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(752),n2h64(752))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(753),h0tab(:,753),[64,16,1,4,2,8,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,753),heltab2x128(:,:,753))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(753),n2h64(753))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(754),h0tab(:,754),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,754),heltab2x128(:,:,754))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(754),n2h64(754))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(755),h0tab(:,755),[64,16,1,4,2,8,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,755),heltab2x128(:,:,755))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(755),n2h64(755))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(756),h0tab(:,756),[64,16,1,4,2,8,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,756),heltab2x128(:,:,756))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(756),n2h64(756))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(757),h0tab(:,757),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,757),heltab2x128(:,:,757))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(757),n2h64(757))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(758),h0tab(:,758),[64,16,1,4,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,758),heltab2x128(:,:,758))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(758),n2h64(758))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(759),h0tab(:,759),[64,16,1,4,2,8,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,759),heltab2x128(:,:,759))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(759),n2h64(759))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(760),h0tab(:,760),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,760),heltab2x128(:,:,760))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(760),n2h64(760))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(761),h0tab(:,761),[64,16,1,4,2,8,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,761),heltab2x128(:,:,761))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(761),n2h64(761))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(762),h0tab(:,762),[64,16,1,4,2,8,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,762),heltab2x128(:,:,762))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(762),n2h64(762))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(763),h0tab(:,763),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,763),heltab2x128(:,:,763))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(763),n2h64(763))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(764),h0tab(:,764),[64,16,1,4,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,764),heltab2x128(:,:,764))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(764),n2h64(764))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(765),h0tab(:,765),[64,16,1,4,2,8,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,765),heltab2x128(:,:,765))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(765),n2h64(765))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(766),h0tab(:,766),[64,16,1,4,2,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,766),heltab2x128(:,:,766))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(766),n2h64(766))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(767),h0tab(:,767),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,767),heltab2x128(:,:,767))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(767),n2h64(767))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(768),h0tab(:,768),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,768),heltab2x128(:,:,768))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(768),n2h64(768))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(769),h0tab(:,769),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,769),heltab2x128(:,:,769))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(769),n2h64(769))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(770),h0tab(:,770),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,770),heltab2x128(:,:,770))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(770),n2h64(770))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(771),h0tab(:,771),[64,16,1,4,2,8,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,771),heltab2x128(:,:,771))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(771),n2h64(771))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(772),h0tab(:,772),[64,16,1,4,2,8,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,772),heltab2x128(:,:,772))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(772),n2h64(772))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(773),h0tab(:,773),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,773),heltab2x128(:,:,773))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(773),n2h64(773))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(774),h0tab(:,774),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,774),heltab2x128(:,:,774))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(774),n2h64(774))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(775),h0tab(:,775),[64,16,1,4,2,8,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,775),heltab2x128(:,:,775))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(775),n2h64(775))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(776),h0tab(:,776),[64,16,1,4,2,8,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,776),heltab2x128(:,:,776))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(776),n2h64(776))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(777),h0tab(:,777),[64,16,1,4,2,8,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,777),heltab2x128(:,:,777))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(777),n2h64(777))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(778),h0tab(:,778),[64,2,4,1,16,32,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,778),heltab2x128(:,:,778))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(778),n2h64(778))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(779),h0tab(:,779),[64,2,4,1,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,779),heltab2x128(:,:,779))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(779),n2h64(779))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(780),h0tab(:,780),[64,2,4,1,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,780),heltab2x128(:,:,780))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(780),n2h64(780))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(781),h0tab(:,781),[64,2,4,1,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,781),heltab2x128(:,:,781))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(781),n2h64(781))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(782),h0tab(:,782),[64,2,4,1,16,32,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,782),heltab2x128(:,:,782))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(782),n2h64(782))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(783),h0tab(:,783),[64,2,4,1,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,783),heltab2x128(:,:,783))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(783),n2h64(783))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(784),h0tab(:,784),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,784),heltab2x128(:,:,784))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(784),n2h64(784))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(785),h0tab(:,785),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,785),heltab2x128(:,:,785))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(785),n2h64(785))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(786),h0tab(:,786),[64,2,4,1,16,32,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,786),heltab2x128(:,:,786))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(786),n2h64(786))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(787),h0tab(:,787),[64,2,4,1,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,787),heltab2x128(:,:,787))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(787),n2h64(787))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(788),h0tab(:,788),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,788),heltab2x128(:,:,788))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(788),n2h64(788))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(789),h0tab(:,789),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,789),heltab2x128(:,:,789))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(789),n2h64(789))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(790),h0tab(:,790),[64,2,4,1,16,32,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,790),heltab2x128(:,:,790))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(790),n2h64(790))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(791),h0tab(:,791),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,791),heltab2x128(:,:,791))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(791),n2h64(791))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(792),h0tab(:,792),[64,2,4,1,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,792),heltab2x128(:,:,792))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(792),n2h64(792))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(793),h0tab(:,793),[64,2,4,1,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,793),heltab2x128(:,:,793))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(793),n2h64(793))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(794),h0tab(:,794),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,794),heltab2x128(:,:,794))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(794),n2h64(794))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(795),h0tab(:,795),[64,2,4,1,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,795),heltab2x128(:,:,795))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(795),n2h64(795))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(796),h0tab(:,796),[64,2,4,1,16,32,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,796),heltab2x128(:,:,796))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(796),n2h64(796))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(797),h0tab(:,797),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,797),heltab2x128(:,:,797))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(797),n2h64(797))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(798),h0tab(:,798),[64,2,4,1,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,798),heltab2x128(:,:,798))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(798),n2h64(798))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(799),h0tab(:,799),[64,2,4,1,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,799),heltab2x128(:,:,799))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(799),n2h64(799))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(800),h0tab(:,800),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,800),heltab2x128(:,:,800))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(800),n2h64(800))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(801),h0tab(:,801),[64,2,4,1,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,801),heltab2x128(:,:,801))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(801),n2h64(801))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(802),h0tab(:,802),[64,2,4,1,16,32,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,802),heltab2x128(:,:,802))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(802),n2h64(802))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(803),h0tab(:,803),[64,2,4,1,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,803),heltab2x128(:,:,803))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(803),n2h64(803))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(804),h0tab(:,804),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,804),heltab2x128(:,:,804))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(804),n2h64(804))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(805),h0tab(:,805),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,805),heltab2x128(:,:,805))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(805),n2h64(805))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(806),h0tab(:,806),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,806),heltab2x128(:,:,806))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(806),n2h64(806))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(807),h0tab(:,807),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,807),heltab2x128(:,:,807))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(807),n2h64(807))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(808),h0tab(:,808),[64,2,4,1,16,32,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,808),heltab2x128(:,:,808))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(808),n2h64(808))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(809),h0tab(:,809),[64,2,4,1,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,809),heltab2x128(:,:,809))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(809),n2h64(809))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(810),h0tab(:,810),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,810),heltab2x128(:,:,810))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(810),n2h64(810))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(811),h0tab(:,811),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,811),heltab2x128(:,:,811))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(811),n2h64(811))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(812),h0tab(:,812),[64,2,4,1,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,812),heltab2x128(:,:,812))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(812),n2h64(812))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(813),h0tab(:,813),[64,2,4,1,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,813),heltab2x128(:,:,813))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(813),n2h64(813))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(814),h0tab(:,814),[64,2,4,1,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,814),heltab2x128(:,:,814))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(814),n2h64(814))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(815),h0tab(:,815),[64,16,1,4,8,2,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,815),heltab2x128(:,:,815))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(815),n2h64(815))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(816),h0tab(:,816),[64,16,1,4,8,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,816),heltab2x128(:,:,816))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(816),n2h64(816))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(817),h0tab(:,817),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,817),heltab2x128(:,:,817))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(817),n2h64(817))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(818),h0tab(:,818),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,818),heltab2x128(:,:,818))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(818),n2h64(818))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(819),h0tab(:,819),[64,16,1,4,8,2,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,819),heltab2x128(:,:,819))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(819),n2h64(819))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(820),h0tab(:,820),[64,16,1,4,8,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,820),heltab2x128(:,:,820))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(820),n2h64(820))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(821),h0tab(:,821),[64,16,1,4,8,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,821),heltab2x128(:,:,821))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(821),n2h64(821))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(822),h0tab(:,822),[64,16,1,4,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,822),heltab2x128(:,:,822))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(822),n2h64(822))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(823),h0tab(:,823),[64,16,1,4,8,2,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,823),heltab2x128(:,:,823))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(823),n2h64(823))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(824),h0tab(:,824),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,824),heltab2x128(:,:,824))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(824),n2h64(824))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(825),h0tab(:,825),[64,16,1,4,8,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,825),heltab2x128(:,:,825))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(825),n2h64(825))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(826),h0tab(:,826),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,826),heltab2x128(:,:,826))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(826),n2h64(826))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(827),h0tab(:,827),[64,16,1,4,8,2,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,827),heltab2x128(:,:,827))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(827),n2h64(827))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(828),h0tab(:,828),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,828),heltab2x128(:,:,828))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(828),n2h64(828))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(829),h0tab(:,829),[64,16,1,4,8,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,829),heltab2x128(:,:,829))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(829),n2h64(829))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(830),h0tab(:,830),[64,16,1,4,8,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,830),heltab2x128(:,:,830))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(830),n2h64(830))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(831),h0tab(:,831),[64,16,1,4,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,831),heltab2x128(:,:,831))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(831),n2h64(831))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(832),h0tab(:,832),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,832),heltab2x128(:,:,832))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(832),n2h64(832))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(833),h0tab(:,833),[64,16,1,4,8,2,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,833),heltab2x128(:,:,833))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(833),n2h64(833))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(834),h0tab(:,834),[64,16,1,4,8,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,834),heltab2x128(:,:,834))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(834),n2h64(834))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(835),h0tab(:,835),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,835),heltab2x128(:,:,835))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(835),n2h64(835))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(836),h0tab(:,836),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,836),heltab2x128(:,:,836))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(836),n2h64(836))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(837),h0tab(:,837),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,837),heltab2x128(:,:,837))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(837),n2h64(837))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(838),h0tab(:,838),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,838),heltab2x128(:,:,838))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(838),n2h64(838))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(839),h0tab(:,839),[64,16,1,4,8,2,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,839),heltab2x128(:,:,839))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(839),n2h64(839))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(840),h0tab(:,840),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,840),heltab2x128(:,:,840))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(840),n2h64(840))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(841),h0tab(:,841),[64,16,1,4,8,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,841),heltab2x128(:,:,841))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(841),n2h64(841))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(842),h0tab(:,842),[64,16,1,4,8,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,842),heltab2x128(:,:,842))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(842),n2h64(842))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(843),h0tab(:,843),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,843),heltab2x128(:,:,843))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(843),n2h64(843))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(844),h0tab(:,844),[64,16,1,4,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,844),heltab2x128(:,:,844))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(844),n2h64(844))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(845),h0tab(:,845),[64,16,1,4,8,2,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,845),heltab2x128(:,:,845))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(845),n2h64(845))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(846),h0tab(:,846),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,846),heltab2x128(:,:,846))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(846),n2h64(846))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(847),h0tab(:,847),[64,16,1,4,8,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,847),heltab2x128(:,:,847))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(847),n2h64(847))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(848),h0tab(:,848),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,848),heltab2x128(:,:,848))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(848),n2h64(848))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(849),h0tab(:,849),[64,16,1,4,8,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,849),heltab2x128(:,:,849))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(849),n2h64(849))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(850),h0tab(:,850),[64,16,1,4,8,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,850),heltab2x128(:,:,850))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(850),n2h64(850))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(851),h0tab(:,851),[64,16,1,4,8,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,851),heltab2x128(:,:,851))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(851),n2h64(851))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(852),h0tab(:,852),[64,2,32,16,1,4,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,852),heltab2x128(:,:,852))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(852),n2h64(852))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(853),h0tab(:,853),[64,2,32,16,1,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,853),heltab2x128(:,:,853))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(853),n2h64(853))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(854),h0tab(:,854),[64,2,32,16,1,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,854),heltab2x128(:,:,854))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(854),n2h64(854))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(855),h0tab(:,855),[64,2,32,16,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,855),heltab2x128(:,:,855))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(855),n2h64(855))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(856),h0tab(:,856),[64,2,32,16,1,4,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,856),heltab2x128(:,:,856))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(856),n2h64(856))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(857),h0tab(:,857),[64,2,32,16,1,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,857),heltab2x128(:,:,857))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(857),n2h64(857))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(858),h0tab(:,858),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,858),heltab2x128(:,:,858))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(858),n2h64(858))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(859),h0tab(:,859),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,859),heltab2x128(:,:,859))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(859),n2h64(859))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(860),h0tab(:,860),[64,2,32,16,1,4,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,860),heltab2x128(:,:,860))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(860),n2h64(860))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(861),h0tab(:,861),[64,2,32,16,1,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,861),heltab2x128(:,:,861))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(861),n2h64(861))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(862),h0tab(:,862),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,862),heltab2x128(:,:,862))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(862),n2h64(862))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(863),h0tab(:,863),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,863),heltab2x128(:,:,863))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(863),n2h64(863))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(864),h0tab(:,864),[64,2,32,16,1,4,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,864),heltab2x128(:,:,864))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(864),n2h64(864))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(865),h0tab(:,865),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,865),heltab2x128(:,:,865))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(865),n2h64(865))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(866),h0tab(:,866),[64,2,32,16,1,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,866),heltab2x128(:,:,866))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(866),n2h64(866))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(867),h0tab(:,867),[64,2,32,16,1,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,867),heltab2x128(:,:,867))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(867),n2h64(867))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(868),h0tab(:,868),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,868),heltab2x128(:,:,868))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(868),n2h64(868))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(869),h0tab(:,869),[64,2,32,16,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,869),heltab2x128(:,:,869))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(869),n2h64(869))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(870),h0tab(:,870),[64,2,32,16,1,4,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,870),heltab2x128(:,:,870))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(870),n2h64(870))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(871),h0tab(:,871),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,871),heltab2x128(:,:,871))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(871),n2h64(871))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(872),h0tab(:,872),[64,2,32,16,1,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,872),heltab2x128(:,:,872))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(872),n2h64(872))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(873),h0tab(:,873),[64,2,32,16,1,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,873),heltab2x128(:,:,873))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(873),n2h64(873))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(874),h0tab(:,874),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,874),heltab2x128(:,:,874))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(874),n2h64(874))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(875),h0tab(:,875),[64,2,32,16,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,875),heltab2x128(:,:,875))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(875),n2h64(875))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(876),h0tab(:,876),[64,2,32,16,1,4,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,876),heltab2x128(:,:,876))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(876),n2h64(876))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(877),h0tab(:,877),[64,2,32,16,1,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,877),heltab2x128(:,:,877))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(877),n2h64(877))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(878),h0tab(:,878),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,878),heltab2x128(:,:,878))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(878),n2h64(878))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(879),h0tab(:,879),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,879),heltab2x128(:,:,879))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(879),n2h64(879))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(880),h0tab(:,880),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,880),heltab2x128(:,:,880))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(880),n2h64(880))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(881),h0tab(:,881),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,881),heltab2x128(:,:,881))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(881),n2h64(881))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(882),h0tab(:,882),[64,2,32,16,1,4,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,882),heltab2x128(:,:,882))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(882),n2h64(882))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(883),h0tab(:,883),[64,2,32,16,1,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,883),heltab2x128(:,:,883))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(883),n2h64(883))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(884),h0tab(:,884),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,884),heltab2x128(:,:,884))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(884),n2h64(884))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(885),h0tab(:,885),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,885),heltab2x128(:,:,885))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(885),n2h64(885))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(886),h0tab(:,886),[64,2,32,16,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,886),heltab2x128(:,:,886))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(886),n2h64(886))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(887),h0tab(:,887),[64,2,32,16,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,887),heltab2x128(:,:,887))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(887),n2h64(887))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(888),h0tab(:,888),[64,2,32,16,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,888),heltab2x128(:,:,888))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(888),n2h64(888))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(889),h0tab(:,889),[64,16,8,2,4,1,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,889),heltab2x128(:,:,889))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(889),n2h64(889))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(890),h0tab(:,890),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,890),heltab2x128(:,:,890))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(890),n2h64(890))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(891),h0tab(:,891),[64,16,8,2,4,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,891),heltab2x128(:,:,891))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(891),n2h64(891))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(892),h0tab(:,892),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,892),heltab2x128(:,:,892))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(892),n2h64(892))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(893),h0tab(:,893),[64,16,8,2,4,1,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,893),heltab2x128(:,:,893))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(893),n2h64(893))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(894),h0tab(:,894),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,894),heltab2x128(:,:,894))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(894),n2h64(894))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(895),h0tab(:,895),[64,16,8,2,4,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,895),heltab2x128(:,:,895))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(895),n2h64(895))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(896),h0tab(:,896),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,896),heltab2x128(:,:,896))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(896),n2h64(896))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(897),h0tab(:,897),[64,16,8,2,4,1,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,897),heltab2x128(:,:,897))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(897),n2h64(897))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(898),h0tab(:,898),[64,16,8,2,4,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,898),heltab2x128(:,:,898))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(898),n2h64(898))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(899),h0tab(:,899),[64,16,8,2,4,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,899),heltab2x128(:,:,899))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(899),n2h64(899))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(900),h0tab(:,900),[64,16,8,2,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,900),heltab2x128(:,:,900))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(900),n2h64(900))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(901),h0tab(:,901),[64,16,8,2,4,1,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,901),heltab2x128(:,:,901))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(901),n2h64(901))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(902),h0tab(:,902),[64,16,8,2,4,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,902),heltab2x128(:,:,902))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(902),n2h64(902))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(903),h0tab(:,903),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,903),heltab2x128(:,:,903))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(903),n2h64(903))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(904),h0tab(:,904),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,904),heltab2x128(:,:,904))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(904),n2h64(904))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(905),h0tab(:,905),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,905),heltab2x128(:,:,905))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(905),n2h64(905))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(906),h0tab(:,906),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,906),heltab2x128(:,:,906))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(906),n2h64(906))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(907),h0tab(:,907),[64,16,8,2,4,1,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,907),heltab2x128(:,:,907))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(907),n2h64(907))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(908),h0tab(:,908),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,908),heltab2x128(:,:,908))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(908),n2h64(908))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(909),h0tab(:,909),[64,16,8,2,4,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,909),heltab2x128(:,:,909))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(909),n2h64(909))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(910),h0tab(:,910),[64,16,8,2,4,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,910),heltab2x128(:,:,910))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(910),n2h64(910))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(911),h0tab(:,911),[64,16,8,2,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,911),heltab2x128(:,:,911))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(911),n2h64(911))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(912),h0tab(:,912),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,912),heltab2x128(:,:,912))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(912),n2h64(912))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(913),h0tab(:,913),[64,16,8,2,4,1,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,913),heltab2x128(:,:,913))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(913),n2h64(913))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(914),h0tab(:,914),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,914),heltab2x128(:,:,914))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(914),n2h64(914))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(915),h0tab(:,915),[64,16,8,2,4,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,915),heltab2x128(:,:,915))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(915),n2h64(915))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(916),h0tab(:,916),[64,16,8,2,4,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,916),heltab2x128(:,:,916))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(916),n2h64(916))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(917),h0tab(:,917),[64,16,8,2,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,917),heltab2x128(:,:,917))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(917),n2h64(917))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(918),h0tab(:,918),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,918),heltab2x128(:,:,918))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(918),n2h64(918))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(919),h0tab(:,919),[64,16,8,2,4,1,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,919),heltab2x128(:,:,919))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(919),n2h64(919))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(920),h0tab(:,920),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,920),heltab2x128(:,:,920))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(920),n2h64(920))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(921),h0tab(:,921),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,921),heltab2x128(:,:,921))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(921),n2h64(921))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(922),h0tab(:,922),[64,16,8,2,4,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,922),heltab2x128(:,:,922))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(922),n2h64(922))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(923),h0tab(:,923),[64,16,8,2,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,923),heltab2x128(:,:,923))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(923),n2h64(923))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(924),h0tab(:,924),[64,16,8,2,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,924),heltab2x128(:,:,924))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(924),n2h64(924))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(925),h0tab(:,925),[64,16,8,2,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,925),heltab2x128(:,:,925))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(925),n2h64(925))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(926),h0tab(:,926),[64,2,4,1,32,16,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,926),heltab2x128(:,:,926))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(926),n2h64(926))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(927),h0tab(:,927),[64,2,4,1,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,927),heltab2x128(:,:,927))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(927),n2h64(927))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(928),h0tab(:,928),[64,2,4,1,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,928),heltab2x128(:,:,928))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(928),n2h64(928))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(929),h0tab(:,929),[64,2,4,1,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,929),heltab2x128(:,:,929))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(929),n2h64(929))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(930),h0tab(:,930),[64,2,4,1,32,16,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,930),heltab2x128(:,:,930))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(930),n2h64(930))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(931),h0tab(:,931),[64,2,4,1,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,931),heltab2x128(:,:,931))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(931),n2h64(931))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(932),h0tab(:,932),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,932),heltab2x128(:,:,932))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(932),n2h64(932))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(933),h0tab(:,933),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,933),heltab2x128(:,:,933))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(933),n2h64(933))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(934),h0tab(:,934),[64,2,4,1,32,16,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,934),heltab2x128(:,:,934))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(934),n2h64(934))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(935),h0tab(:,935),[64,2,4,1,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,935),heltab2x128(:,:,935))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(935),n2h64(935))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(936),h0tab(:,936),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,936),heltab2x128(:,:,936))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(936),n2h64(936))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(937),h0tab(:,937),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,937),heltab2x128(:,:,937))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(937),n2h64(937))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(938),h0tab(:,938),[64,2,4,1,32,16,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,938),heltab2x128(:,:,938))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(938),n2h64(938))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(939),h0tab(:,939),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,939),heltab2x128(:,:,939))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(939),n2h64(939))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(940),h0tab(:,940),[64,2,4,1,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,940),heltab2x128(:,:,940))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(940),n2h64(940))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(941),h0tab(:,941),[64,2,4,1,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,941),heltab2x128(:,:,941))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(941),n2h64(941))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(942),h0tab(:,942),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,942),heltab2x128(:,:,942))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(942),n2h64(942))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(943),h0tab(:,943),[64,2,4,1,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,943),heltab2x128(:,:,943))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(943),n2h64(943))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(944),h0tab(:,944),[64,2,4,1,32,16,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,944),heltab2x128(:,:,944))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(944),n2h64(944))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(945),h0tab(:,945),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,945),heltab2x128(:,:,945))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(945),n2h64(945))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(946),h0tab(:,946),[64,2,4,1,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,946),heltab2x128(:,:,946))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(946),n2h64(946))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(947),h0tab(:,947),[64,2,4,1,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,947),heltab2x128(:,:,947))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(947),n2h64(947))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(948),h0tab(:,948),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,948),heltab2x128(:,:,948))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(948),n2h64(948))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(949),h0tab(:,949),[64,2,4,1,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,949),heltab2x128(:,:,949))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(949),n2h64(949))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(950),h0tab(:,950),[64,2,4,1,32,16,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,950),heltab2x128(:,:,950))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(950),n2h64(950))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(951),h0tab(:,951),[64,2,4,1,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,951),heltab2x128(:,:,951))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(951),n2h64(951))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(952),h0tab(:,952),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,952),heltab2x128(:,:,952))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(952),n2h64(952))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(953),h0tab(:,953),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,953),heltab2x128(:,:,953))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(953),n2h64(953))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(954),h0tab(:,954),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,954),heltab2x128(:,:,954))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(954),n2h64(954))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(955),h0tab(:,955),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,955),heltab2x128(:,:,955))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(955),n2h64(955))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(956),h0tab(:,956),[64,2,4,1,32,16,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,956),heltab2x128(:,:,956))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(956),n2h64(956))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(957),h0tab(:,957),[64,2,4,1,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,957),heltab2x128(:,:,957))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(957),n2h64(957))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(958),h0tab(:,958),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,958),heltab2x128(:,:,958))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(958),n2h64(958))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(959),h0tab(:,959),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,959),heltab2x128(:,:,959))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(959),n2h64(959))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(960),h0tab(:,960),[64,2,4,1,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,960),heltab2x128(:,:,960))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(960),n2h64(960))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(961),h0tab(:,961),[64,2,4,1,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,961),heltab2x128(:,:,961))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(961),n2h64(961))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(962),h0tab(:,962),[64,2,4,1,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,962),heltab2x128(:,:,962))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(962),n2h64(962))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(963),h0tab(:,963),[64,16,2,8,4,1,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,963),heltab2x128(:,:,963))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(963),n2h64(963))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(964),h0tab(:,964),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,964),heltab2x128(:,:,964))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(964),n2h64(964))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(965),h0tab(:,965),[64,16,2,8,4,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,965),heltab2x128(:,:,965))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(965),n2h64(965))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(966),h0tab(:,966),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,966),heltab2x128(:,:,966))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(966),n2h64(966))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(967),h0tab(:,967),[64,16,2,8,4,1,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,967),heltab2x128(:,:,967))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(967),n2h64(967))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(968),h0tab(:,968),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,968),heltab2x128(:,:,968))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(968),n2h64(968))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(969),h0tab(:,969),[64,16,2,8,4,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,969),heltab2x128(:,:,969))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(969),n2h64(969))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(970),h0tab(:,970),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,970),heltab2x128(:,:,970))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(970),n2h64(970))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(971),h0tab(:,971),[64,16,2,8,4,1,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,971),heltab2x128(:,:,971))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(971),n2h64(971))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(972),h0tab(:,972),[64,16,2,8,4,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,972),heltab2x128(:,:,972))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(972),n2h64(972))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(973),h0tab(:,973),[64,16,2,8,4,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,973),heltab2x128(:,:,973))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(973),n2h64(973))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(974),h0tab(:,974),[64,16,2,8,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,974),heltab2x128(:,:,974))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(974),n2h64(974))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(975),h0tab(:,975),[64,16,2,8,4,1,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,975),heltab2x128(:,:,975))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(975),n2h64(975))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(976),h0tab(:,976),[64,16,2,8,4,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,976),heltab2x128(:,:,976))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(976),n2h64(976))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(977),h0tab(:,977),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,977),heltab2x128(:,:,977))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(977),n2h64(977))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(978),h0tab(:,978),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,978),heltab2x128(:,:,978))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(978),n2h64(978))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(979),h0tab(:,979),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,979),heltab2x128(:,:,979))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(979),n2h64(979))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(980),h0tab(:,980),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,980),heltab2x128(:,:,980))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(980),n2h64(980))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(981),h0tab(:,981),[64,16,2,8,4,1,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,981),heltab2x128(:,:,981))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(981),n2h64(981))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(982),h0tab(:,982),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,982),heltab2x128(:,:,982))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(982),n2h64(982))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(983),h0tab(:,983),[64,16,2,8,4,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,983),heltab2x128(:,:,983))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(983),n2h64(983))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(984),h0tab(:,984),[64,16,2,8,4,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,984),heltab2x128(:,:,984))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(984),n2h64(984))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(985),h0tab(:,985),[64,16,2,8,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,985),heltab2x128(:,:,985))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(985),n2h64(985))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(986),h0tab(:,986),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,986),heltab2x128(:,:,986))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(986),n2h64(986))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(987),h0tab(:,987),[64,16,2,8,4,1,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,987),heltab2x128(:,:,987))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(987),n2h64(987))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(988),h0tab(:,988),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,988),heltab2x128(:,:,988))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(988),n2h64(988))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(989),h0tab(:,989),[64,16,2,8,4,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,989),heltab2x128(:,:,989))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(989),n2h64(989))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(990),h0tab(:,990),[64,16,2,8,4,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,990),heltab2x128(:,:,990))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(990),n2h64(990))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(991),h0tab(:,991),[64,16,2,8,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,991),heltab2x128(:,:,991))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(991),n2h64(991))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(992),h0tab(:,992),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,992),heltab2x128(:,:,992))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(992),n2h64(992))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(993),h0tab(:,993),[64,16,2,8,4,1,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,993),heltab2x128(:,:,993))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(993),n2h64(993))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(994),h0tab(:,994),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,994),heltab2x128(:,:,994))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(994),n2h64(994))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(995),h0tab(:,995),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,995),heltab2x128(:,:,995))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(995),n2h64(995))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(996),h0tab(:,996),[64,16,2,8,4,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,996),heltab2x128(:,:,996))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(996),n2h64(996))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(997),h0tab(:,997),[64,16,2,8,4,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,997),heltab2x128(:,:,997))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(997),n2h64(997))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(998),h0tab(:,998),[64,16,2,8,4,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,998),heltab2x128(:,:,998))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(998),n2h64(998))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(999),h0tab(:,999),[64,16,2,8,4,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,999),heltab2x128(:,:,999))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(999),n2h64(999))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1000),h0tab(:,1000),[64,2,16,32,1,4,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1000),heltab2x128(:,:,1000))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1000),n2h64(1000))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1001),h0tab(:,1001),[64,2,16,32,1,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1001),heltab2x128(:,:,1001))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1001),n2h64(1001))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1002),h0tab(:,1002),[64,2,16,32,1,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1002),heltab2x128(:,:,1002))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1002),n2h64(1002))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1003),h0tab(:,1003),[64,2,16,32,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1003),heltab2x128(:,:,1003))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1003),n2h64(1003))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1004),h0tab(:,1004),[64,2,16,32,1,4,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1004),heltab2x128(:,:,1004))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1004),n2h64(1004))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1005),h0tab(:,1005),[64,2,16,32,1,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1005),heltab2x128(:,:,1005))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1005),n2h64(1005))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1006),h0tab(:,1006),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1006),heltab2x128(:,:,1006))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1006),n2h64(1006))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1007),h0tab(:,1007),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1007),heltab2x128(:,:,1007))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1007),n2h64(1007))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1008),h0tab(:,1008),[64,2,16,32,1,4,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1008),heltab2x128(:,:,1008))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1008),n2h64(1008))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1009),h0tab(:,1009),[64,2,16,32,1,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1009),heltab2x128(:,:,1009))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1009),n2h64(1009))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1010),h0tab(:,1010),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1010),heltab2x128(:,:,1010))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1010),n2h64(1010))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1011),h0tab(:,1011),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1011),heltab2x128(:,:,1011))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1011),n2h64(1011))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1012),h0tab(:,1012),[64,2,16,32,1,4,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1012),heltab2x128(:,:,1012))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1012),n2h64(1012))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1013),h0tab(:,1013),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1013),heltab2x128(:,:,1013))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1013),n2h64(1013))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1014),h0tab(:,1014),[64,2,16,32,1,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1014),heltab2x128(:,:,1014))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1014),n2h64(1014))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1015),h0tab(:,1015),[64,2,16,32,1,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1015),heltab2x128(:,:,1015))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1015),n2h64(1015))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1016),h0tab(:,1016),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1016),heltab2x128(:,:,1016))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1016),n2h64(1016))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1017),h0tab(:,1017),[64,2,16,32,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1017),heltab2x128(:,:,1017))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1017),n2h64(1017))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1018),h0tab(:,1018),[64,2,16,32,1,4,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1018),heltab2x128(:,:,1018))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1018),n2h64(1018))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1019),h0tab(:,1019),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1019),heltab2x128(:,:,1019))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1019),n2h64(1019))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1020),h0tab(:,1020),[64,2,16,32,1,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1020),heltab2x128(:,:,1020))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1020),n2h64(1020))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1021),h0tab(:,1021),[64,2,16,32,1,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1021),heltab2x128(:,:,1021))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1021),n2h64(1021))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1022),h0tab(:,1022),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1022),heltab2x128(:,:,1022))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1022),n2h64(1022))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1023),h0tab(:,1023),[64,2,16,32,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1023),heltab2x128(:,:,1023))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1023),n2h64(1023))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1024),h0tab(:,1024),[64,2,16,32,1,4,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1024),heltab2x128(:,:,1024))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1024),n2h64(1024))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1025),h0tab(:,1025),[64,2,16,32,1,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1025),heltab2x128(:,:,1025))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1025),n2h64(1025))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1026),h0tab(:,1026),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1026),heltab2x128(:,:,1026))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1026),n2h64(1026))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1027),h0tab(:,1027),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1027),heltab2x128(:,:,1027))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1027),n2h64(1027))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1028),h0tab(:,1028),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1028),heltab2x128(:,:,1028))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1028),n2h64(1028))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1029),h0tab(:,1029),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1029),heltab2x128(:,:,1029))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1029),n2h64(1029))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1030),h0tab(:,1030),[64,2,16,32,1,4,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1030),heltab2x128(:,:,1030))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1030),n2h64(1030))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1031),h0tab(:,1031),[64,2,16,32,1,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1031),heltab2x128(:,:,1031))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1031),n2h64(1031))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1032),h0tab(:,1032),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1032),heltab2x128(:,:,1032))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1032),n2h64(1032))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1033),h0tab(:,1033),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1033),heltab2x128(:,:,1033))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1033),n2h64(1033))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1034),h0tab(:,1034),[64,2,16,32,1,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1034),heltab2x128(:,:,1034))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1034),n2h64(1034))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1035),h0tab(:,1035),[64,2,16,32,1,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1035),heltab2x128(:,:,1035))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1035),n2h64(1035))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1036),h0tab(:,1036),[64,2,16,32,1,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1036),heltab2x128(:,:,1036))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1036),n2h64(1036))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1037),h0tab(:,1037),[64,1,4,2,16,32,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1037),heltab2x128(:,:,1037))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1037),n2h64(1037))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1038),h0tab(:,1038),[64,1,4,2,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1038),heltab2x128(:,:,1038))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1038),n2h64(1038))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1039),h0tab(:,1039),[64,1,4,2,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1039),heltab2x128(:,:,1039))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1039),n2h64(1039))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1040),h0tab(:,1040),[64,1,4,2,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1040),heltab2x128(:,:,1040))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1040),n2h64(1040))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1041),h0tab(:,1041),[64,1,4,2,16,32,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1041),heltab2x128(:,:,1041))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1041),n2h64(1041))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1042),h0tab(:,1042),[64,1,4,2,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1042),heltab2x128(:,:,1042))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1042),n2h64(1042))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1043),h0tab(:,1043),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1043),heltab2x128(:,:,1043))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1043),n2h64(1043))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1044),h0tab(:,1044),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1044),heltab2x128(:,:,1044))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1044),n2h64(1044))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1045),h0tab(:,1045),[64,1,4,2,16,32,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1045),heltab2x128(:,:,1045))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1045),n2h64(1045))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1046),h0tab(:,1046),[64,1,4,2,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1046),heltab2x128(:,:,1046))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1046),n2h64(1046))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1047),h0tab(:,1047),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1047),heltab2x128(:,:,1047))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1047),n2h64(1047))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1048),h0tab(:,1048),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1048),heltab2x128(:,:,1048))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1048),n2h64(1048))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1049),h0tab(:,1049),[64,1,4,2,16,32,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1049),heltab2x128(:,:,1049))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1049),n2h64(1049))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1050),h0tab(:,1050),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1050),heltab2x128(:,:,1050))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1050),n2h64(1050))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1051),h0tab(:,1051),[64,1,4,2,16,32,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1051),heltab2x128(:,:,1051))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1051),n2h64(1051))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1052),h0tab(:,1052),[64,1,4,2,16,32,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1052),heltab2x128(:,:,1052))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1052),n2h64(1052))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1053),h0tab(:,1053),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1053),heltab2x128(:,:,1053))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1053),n2h64(1053))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1054),h0tab(:,1054),[64,1,4,2,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1054),heltab2x128(:,:,1054))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1054),n2h64(1054))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1055),h0tab(:,1055),[64,1,4,2,16,32,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1055),heltab2x128(:,:,1055))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1055),n2h64(1055))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1056),h0tab(:,1056),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1056),heltab2x128(:,:,1056))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1056),n2h64(1056))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1057),h0tab(:,1057),[64,1,4,2,16,32,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1057),heltab2x128(:,:,1057))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1057),n2h64(1057))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1058),h0tab(:,1058),[64,1,4,2,16,32,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1058),heltab2x128(:,:,1058))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1058),n2h64(1058))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1059),h0tab(:,1059),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1059),heltab2x128(:,:,1059))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1059),n2h64(1059))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1060),h0tab(:,1060),[64,1,4,2,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1060),heltab2x128(:,:,1060))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1060),n2h64(1060))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1061),h0tab(:,1061),[64,1,4,2,16,32,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1061),heltab2x128(:,:,1061))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1061),n2h64(1061))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1062),h0tab(:,1062),[64,1,4,2,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1062),heltab2x128(:,:,1062))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1062),n2h64(1062))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1063),h0tab(:,1063),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1063),heltab2x128(:,:,1063))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1063),n2h64(1063))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1064),h0tab(:,1064),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1064),heltab2x128(:,:,1064))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1064),n2h64(1064))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1065),h0tab(:,1065),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1065),heltab2x128(:,:,1065))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1065),n2h64(1065))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1066),h0tab(:,1066),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1066),heltab2x128(:,:,1066))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1066),n2h64(1066))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1067),h0tab(:,1067),[64,1,4,2,16,32,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1067),heltab2x128(:,:,1067))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1067),n2h64(1067))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1068),h0tab(:,1068),[64,1,4,2,16,32,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1068),heltab2x128(:,:,1068))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1068),n2h64(1068))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1069),h0tab(:,1069),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1069),heltab2x128(:,:,1069))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1069),n2h64(1069))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1070),h0tab(:,1070),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1070),heltab2x128(:,:,1070))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1070),n2h64(1070))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1071),h0tab(:,1071),[64,1,4,2,16,32,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1071),heltab2x128(:,:,1071))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1071),n2h64(1071))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1072),h0tab(:,1072),[64,1,4,2,16,32,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1072),heltab2x128(:,:,1072))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1072),n2h64(1072))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1073),h0tab(:,1073),[64,1,4,2,16,32,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1073),heltab2x128(:,:,1073))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1073),n2h64(1073))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1074),h0tab(:,1074),[64,1,4,2,32,16,8],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1074),heltab2x128(:,:,1074))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1074),n2h64(1074))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1075),h0tab(:,1075),[64,1,4,2,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1075),heltab2x128(:,:,1075))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1075),n2h64(1075))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1076),h0tab(:,1076),[64,1,4,2,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1076),heltab2x128(:,:,1076))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1076),n2h64(1076))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1077),h0tab(:,1077),[64,1,4,2,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1077),heltab2x128(:,:,1077))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1077),n2h64(1077))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1078),h0tab(:,1078),[64,1,4,2,32,16,8],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1078),heltab2x128(:,:,1078))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1078),n2h64(1078))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1079),h0tab(:,1079),[64,1,4,2,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1079),heltab2x128(:,:,1079))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1079),n2h64(1079))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1080),h0tab(:,1080),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1080),heltab2x128(:,:,1080))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1080),n2h64(1080))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1081),h0tab(:,1081),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1081),heltab2x128(:,:,1081))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1081),n2h64(1081))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1082),h0tab(:,1082),[64,1,4,2,32,16,8],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1082),heltab2x128(:,:,1082))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1082),n2h64(1082))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1083),h0tab(:,1083),[64,1,4,2,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1083),heltab2x128(:,:,1083))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1083),n2h64(1083))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1084),h0tab(:,1084),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1084),heltab2x128(:,:,1084))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1084),n2h64(1084))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1085),h0tab(:,1085),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1085),heltab2x128(:,:,1085))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1085),n2h64(1085))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1086),h0tab(:,1086),[64,1,4,2,32,16,8],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1086),heltab2x128(:,:,1086))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1086),n2h64(1086))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1087),h0tab(:,1087),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1087),heltab2x128(:,:,1087))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1087),n2h64(1087))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1088),h0tab(:,1088),[64,1,4,2,32,16,8],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1088),heltab2x128(:,:,1088))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1088),n2h64(1088))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1089),h0tab(:,1089),[64,1,4,2,32,16,8],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1089),heltab2x128(:,:,1089))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1089),n2h64(1089))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1090),h0tab(:,1090),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1090),heltab2x128(:,:,1090))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1090),n2h64(1090))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1091),h0tab(:,1091),[64,1,4,2,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1091),heltab2x128(:,:,1091))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1091),n2h64(1091))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1092),h0tab(:,1092),[64,1,4,2,32,16,8],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1092),heltab2x128(:,:,1092))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1092),n2h64(1092))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1093),h0tab(:,1093),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1093),heltab2x128(:,:,1093))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1093),n2h64(1093))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1094),h0tab(:,1094),[64,1,4,2,32,16,8],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1094),heltab2x128(:,:,1094))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1094),n2h64(1094))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1095),h0tab(:,1095),[64,1,4,2,32,16,8],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1095),heltab2x128(:,:,1095))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1095),n2h64(1095))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1096),h0tab(:,1096),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1096),heltab2x128(:,:,1096))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1096),n2h64(1096))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1097),h0tab(:,1097),[64,1,4,2,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1097),heltab2x128(:,:,1097))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1097),n2h64(1097))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1098),h0tab(:,1098),[64,1,4,2,32,16,8],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1098),heltab2x128(:,:,1098))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1098),n2h64(1098))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1099),h0tab(:,1099),[64,1,4,2,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1099),heltab2x128(:,:,1099))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1099),n2h64(1099))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1100),h0tab(:,1100),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1100),heltab2x128(:,:,1100))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1100),n2h64(1100))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1101),h0tab(:,1101),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1101),heltab2x128(:,:,1101))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1101),n2h64(1101))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1102),h0tab(:,1102),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1102),heltab2x128(:,:,1102))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1102),n2h64(1102))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1103),h0tab(:,1103),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1103),heltab2x128(:,:,1103))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1103),n2h64(1103))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1104),h0tab(:,1104),[64,1,4,2,32,16,8],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1104),heltab2x128(:,:,1104))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1104),n2h64(1104))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1105),h0tab(:,1105),[64,1,4,2,32,16,8],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1105),heltab2x128(:,:,1105))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1105),n2h64(1105))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1106),h0tab(:,1106),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1106),heltab2x128(:,:,1106))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1106),n2h64(1106))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1107),h0tab(:,1107),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1107),heltab2x128(:,:,1107))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1107),n2h64(1107))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1108),h0tab(:,1108),[64,1,4,2,32,16,8],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1108),heltab2x128(:,:,1108))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1108),n2h64(1108))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1109),h0tab(:,1109),[64,1,4,2,32,16,8],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1109),heltab2x128(:,:,1109))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1109),n2h64(1109))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1110),h0tab(:,1110),[64,1,4,2,32,16,8],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1110),heltab2x128(:,:,1110))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1110),n2h64(1110))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1111),h0tab(:,1111),[64,16,1,8,2,4,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1111),heltab2x128(:,:,1111))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1111),n2h64(1111))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1112),h0tab(:,1112),[64,16,1,8,2,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1112),heltab2x128(:,:,1112))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1112),n2h64(1112))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1113),h0tab(:,1113),[64,16,1,8,2,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1113),heltab2x128(:,:,1113))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1113),n2h64(1113))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1114),h0tab(:,1114),[64,16,1,8,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1114),heltab2x128(:,:,1114))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1114),n2h64(1114))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1115),h0tab(:,1115),[64,16,1,8,2,4,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1115),heltab2x128(:,:,1115))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1115),n2h64(1115))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1116),h0tab(:,1116),[64,16,1,8,2,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1116),heltab2x128(:,:,1116))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1116),n2h64(1116))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1117),h0tab(:,1117),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1117),heltab2x128(:,:,1117))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1117),n2h64(1117))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1118),h0tab(:,1118),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1118),heltab2x128(:,:,1118))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1118),n2h64(1118))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1119),h0tab(:,1119),[64,16,1,8,2,4,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1119),heltab2x128(:,:,1119))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1119),n2h64(1119))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1120),h0tab(:,1120),[64,16,1,8,2,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1120),heltab2x128(:,:,1120))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1120),n2h64(1120))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1121),h0tab(:,1121),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1121),heltab2x128(:,:,1121))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1121),n2h64(1121))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1122),h0tab(:,1122),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1122),heltab2x128(:,:,1122))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1122),n2h64(1122))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1123),h0tab(:,1123),[64,16,1,8,2,4,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1123),heltab2x128(:,:,1123))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1123),n2h64(1123))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1124),h0tab(:,1124),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1124),heltab2x128(:,:,1124))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1124),n2h64(1124))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1125),h0tab(:,1125),[64,16,1,8,2,4,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1125),heltab2x128(:,:,1125))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1125),n2h64(1125))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1126),h0tab(:,1126),[64,16,1,8,2,4,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1126),heltab2x128(:,:,1126))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1126),n2h64(1126))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1127),h0tab(:,1127),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1127),heltab2x128(:,:,1127))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1127),n2h64(1127))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1128),h0tab(:,1128),[64,16,1,8,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1128),heltab2x128(:,:,1128))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1128),n2h64(1128))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1129),h0tab(:,1129),[64,16,1,8,2,4,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1129),heltab2x128(:,:,1129))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1129),n2h64(1129))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1130),h0tab(:,1130),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1130),heltab2x128(:,:,1130))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1130),n2h64(1130))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1131),h0tab(:,1131),[64,16,1,8,2,4,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1131),heltab2x128(:,:,1131))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1131),n2h64(1131))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1132),h0tab(:,1132),[64,16,1,8,2,4,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1132),heltab2x128(:,:,1132))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1132),n2h64(1132))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1133),h0tab(:,1133),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1133),heltab2x128(:,:,1133))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1133),n2h64(1133))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1134),h0tab(:,1134),[64,16,1,8,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1134),heltab2x128(:,:,1134))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1134),n2h64(1134))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1135),h0tab(:,1135),[64,16,1,8,2,4,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1135),heltab2x128(:,:,1135))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1135),n2h64(1135))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1136),h0tab(:,1136),[64,16,1,8,2,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1136),heltab2x128(:,:,1136))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1136),n2h64(1136))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1137),h0tab(:,1137),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1137),heltab2x128(:,:,1137))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1137),n2h64(1137))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1138),h0tab(:,1138),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1138),heltab2x128(:,:,1138))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1138),n2h64(1138))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1139),h0tab(:,1139),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1139),heltab2x128(:,:,1139))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1139),n2h64(1139))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1140),h0tab(:,1140),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1140),heltab2x128(:,:,1140))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1140),n2h64(1140))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1141),h0tab(:,1141),[64,16,1,8,2,4,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1141),heltab2x128(:,:,1141))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1141),n2h64(1141))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1142),h0tab(:,1142),[64,16,1,8,2,4,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1142),heltab2x128(:,:,1142))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1142),n2h64(1142))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1143),h0tab(:,1143),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1143),heltab2x128(:,:,1143))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1143),n2h64(1143))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1144),h0tab(:,1144),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1144),heltab2x128(:,:,1144))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1144),n2h64(1144))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1145),h0tab(:,1145),[64,16,1,8,2,4,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1145),heltab2x128(:,:,1145))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1145),n2h64(1145))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1146),h0tab(:,1146),[64,16,1,8,2,4,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1146),heltab2x128(:,:,1146))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1146),n2h64(1146))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1147),h0tab(:,1147),[64,16,1,8,2,4,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1147),heltab2x128(:,:,1147))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1147),n2h64(1147))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1148),h0tab(:,1148),[64,16,1,8,4,2,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1148),heltab2x128(:,:,1148))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1148),n2h64(1148))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1149),h0tab(:,1149),[64,16,1,8,4,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1149),heltab2x128(:,:,1149))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1149),n2h64(1149))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1150),h0tab(:,1150),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1150),heltab2x128(:,:,1150))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1150),n2h64(1150))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1151),h0tab(:,1151),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1151),heltab2x128(:,:,1151))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1151),n2h64(1151))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1152),h0tab(:,1152),[64,16,1,8,4,2,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1152),heltab2x128(:,:,1152))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1152),n2h64(1152))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1153),h0tab(:,1153),[64,16,1,8,4,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1153),heltab2x128(:,:,1153))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1153),n2h64(1153))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1154),h0tab(:,1154),[64,16,1,8,4,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1154),heltab2x128(:,:,1154))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1154),n2h64(1154))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1155),h0tab(:,1155),[64,16,1,8,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1155),heltab2x128(:,:,1155))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1155),n2h64(1155))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1156),h0tab(:,1156),[64,16,1,8,4,2,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1156),heltab2x128(:,:,1156))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1156),n2h64(1156))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1157),h0tab(:,1157),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1157),heltab2x128(:,:,1157))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1157),n2h64(1157))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1158),h0tab(:,1158),[64,16,1,8,4,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1158),heltab2x128(:,:,1158))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1158),n2h64(1158))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1159),h0tab(:,1159),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1159),heltab2x128(:,:,1159))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1159),n2h64(1159))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1160),h0tab(:,1160),[64,16,1,8,4,2,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1160),heltab2x128(:,:,1160))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1160),n2h64(1160))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1161),h0tab(:,1161),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1161),heltab2x128(:,:,1161))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1161),n2h64(1161))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1162),h0tab(:,1162),[64,16,1,8,4,2,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1162),heltab2x128(:,:,1162))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1162),n2h64(1162))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1163),h0tab(:,1163),[64,16,1,8,4,2,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1163),heltab2x128(:,:,1163))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1163),n2h64(1163))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1164),h0tab(:,1164),[64,16,1,8,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1164),heltab2x128(:,:,1164))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1164),n2h64(1164))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1165),h0tab(:,1165),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1165),heltab2x128(:,:,1165))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1165),n2h64(1165))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1166),h0tab(:,1166),[64,16,1,8,4,2,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1166),heltab2x128(:,:,1166))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1166),n2h64(1166))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1167),h0tab(:,1167),[64,16,1,8,4,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1167),heltab2x128(:,:,1167))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1167),n2h64(1167))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1168),h0tab(:,1168),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1168),heltab2x128(:,:,1168))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1168),n2h64(1168))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1169),h0tab(:,1169),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1169),heltab2x128(:,:,1169))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1169),n2h64(1169))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1170),h0tab(:,1170),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1170),heltab2x128(:,:,1170))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1170),n2h64(1170))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1171),h0tab(:,1171),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1171),heltab2x128(:,:,1171))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1171),n2h64(1171))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1172),h0tab(:,1172),[64,16,1,8,4,2,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1172),heltab2x128(:,:,1172))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1172),n2h64(1172))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1173),h0tab(:,1173),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1173),heltab2x128(:,:,1173))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1173),n2h64(1173))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1174),h0tab(:,1174),[64,16,1,8,4,2,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1174),heltab2x128(:,:,1174))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1174),n2h64(1174))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1175),h0tab(:,1175),[64,16,1,8,4,2,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1175),heltab2x128(:,:,1175))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1175),n2h64(1175))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1176),h0tab(:,1176),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1176),heltab2x128(:,:,1176))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1176),n2h64(1176))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1177),h0tab(:,1177),[64,16,1,8,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1177),heltab2x128(:,:,1177))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1177),n2h64(1177))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1178),h0tab(:,1178),[64,16,1,8,4,2,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1178),heltab2x128(:,:,1178))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1178),n2h64(1178))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1179),h0tab(:,1179),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1179),heltab2x128(:,:,1179))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1179),n2h64(1179))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1180),h0tab(:,1180),[64,16,1,8,4,2,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1180),heltab2x128(:,:,1180))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1180),n2h64(1180))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1181),h0tab(:,1181),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1181),heltab2x128(:,:,1181))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1181),n2h64(1181))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1182),h0tab(:,1182),[64,16,1,8,4,2,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1182),heltab2x128(:,:,1182))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1182),n2h64(1182))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1183),h0tab(:,1183),[64,16,1,8,4,2,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1183),heltab2x128(:,:,1183))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1183),n2h64(1183))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1184),h0tab(:,1184),[64,16,1,8,4,2,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1184),heltab2x128(:,:,1184))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1184),n2h64(1184))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1185),h0tab(:,1185),[64,2,8,1,16,32,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1185),heltab2x128(:,:,1185))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1185),n2h64(1185))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1186),h0tab(:,1186),[64,2,8,1,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1186),heltab2x128(:,:,1186))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1186),n2h64(1186))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1187),h0tab(:,1187),[64,2,8,1,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1187),heltab2x128(:,:,1187))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1187),n2h64(1187))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1188),h0tab(:,1188),[64,2,8,1,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1188),heltab2x128(:,:,1188))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1188),n2h64(1188))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1189),h0tab(:,1189),[64,2,8,1,16,32,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1189),heltab2x128(:,:,1189))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1189),n2h64(1189))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1190),h0tab(:,1190),[64,2,8,1,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1190),heltab2x128(:,:,1190))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1190),n2h64(1190))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1191),h0tab(:,1191),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1191),heltab2x128(:,:,1191))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1191),n2h64(1191))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1192),h0tab(:,1192),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1192),heltab2x128(:,:,1192))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1192),n2h64(1192))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1193),h0tab(:,1193),[64,2,8,1,16,32,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1193),heltab2x128(:,:,1193))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1193),n2h64(1193))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1194),h0tab(:,1194),[64,2,8,1,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1194),heltab2x128(:,:,1194))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1194),n2h64(1194))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1195),h0tab(:,1195),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1195),heltab2x128(:,:,1195))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1195),n2h64(1195))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1196),h0tab(:,1196),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1196),heltab2x128(:,:,1196))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1196),n2h64(1196))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1197),h0tab(:,1197),[64,2,8,1,16,32,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1197),heltab2x128(:,:,1197))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1197),n2h64(1197))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1198),h0tab(:,1198),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1198),heltab2x128(:,:,1198))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1198),n2h64(1198))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1199),h0tab(:,1199),[64,2,8,1,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1199),heltab2x128(:,:,1199))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1199),n2h64(1199))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1200),h0tab(:,1200),[64,2,8,1,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1200),heltab2x128(:,:,1200))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1200),n2h64(1200))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1201),h0tab(:,1201),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1201),heltab2x128(:,:,1201))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1201),n2h64(1201))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1202),h0tab(:,1202),[64,2,8,1,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1202),heltab2x128(:,:,1202))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1202),n2h64(1202))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1203),h0tab(:,1203),[64,2,8,1,16,32,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1203),heltab2x128(:,:,1203))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1203),n2h64(1203))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1204),h0tab(:,1204),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1204),heltab2x128(:,:,1204))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1204),n2h64(1204))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1205),h0tab(:,1205),[64,2,8,1,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1205),heltab2x128(:,:,1205))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1205),n2h64(1205))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1206),h0tab(:,1206),[64,2,8,1,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1206),heltab2x128(:,:,1206))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1206),n2h64(1206))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1207),h0tab(:,1207),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1207),heltab2x128(:,:,1207))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1207),n2h64(1207))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1208),h0tab(:,1208),[64,2,8,1,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1208),heltab2x128(:,:,1208))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1208),n2h64(1208))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1209),h0tab(:,1209),[64,2,8,1,16,32,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1209),heltab2x128(:,:,1209))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1209),n2h64(1209))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1210),h0tab(:,1210),[64,2,8,1,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1210),heltab2x128(:,:,1210))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1210),n2h64(1210))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1211),h0tab(:,1211),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1211),heltab2x128(:,:,1211))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1211),n2h64(1211))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1212),h0tab(:,1212),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1212),heltab2x128(:,:,1212))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1212),n2h64(1212))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1213),h0tab(:,1213),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1213),heltab2x128(:,:,1213))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1213),n2h64(1213))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1214),h0tab(:,1214),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1214),heltab2x128(:,:,1214))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1214),n2h64(1214))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1215),h0tab(:,1215),[64,2,8,1,16,32,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1215),heltab2x128(:,:,1215))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1215),n2h64(1215))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1216),h0tab(:,1216),[64,2,8,1,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1216),heltab2x128(:,:,1216))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1216),n2h64(1216))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1217),h0tab(:,1217),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1217),heltab2x128(:,:,1217))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1217),n2h64(1217))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1218),h0tab(:,1218),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1218),heltab2x128(:,:,1218))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1218),n2h64(1218))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1219),h0tab(:,1219),[64,2,8,1,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1219),heltab2x128(:,:,1219))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1219),n2h64(1219))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1220),h0tab(:,1220),[64,2,8,1,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1220),heltab2x128(:,:,1220))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1220),n2h64(1220))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1221),h0tab(:,1221),[64,2,8,1,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1221),heltab2x128(:,:,1221))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1221),n2h64(1221))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1222),h0tab(:,1222),[64,2,32,16,1,8,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1222),heltab2x128(:,:,1222))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1222),n2h64(1222))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1223),h0tab(:,1223),[64,2,32,16,1,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1223),heltab2x128(:,:,1223))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1223),n2h64(1223))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1224),h0tab(:,1224),[64,2,32,16,1,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1224),heltab2x128(:,:,1224))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1224),n2h64(1224))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1225),h0tab(:,1225),[64,2,32,16,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1225),heltab2x128(:,:,1225))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1225),n2h64(1225))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1226),h0tab(:,1226),[64,2,32,16,1,8,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1226),heltab2x128(:,:,1226))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1226),n2h64(1226))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1227),h0tab(:,1227),[64,2,32,16,1,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1227),heltab2x128(:,:,1227))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1227),n2h64(1227))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1228),h0tab(:,1228),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1228),heltab2x128(:,:,1228))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1228),n2h64(1228))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1229),h0tab(:,1229),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1229),heltab2x128(:,:,1229))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1229),n2h64(1229))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1230),h0tab(:,1230),[64,2,32,16,1,8,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1230),heltab2x128(:,:,1230))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1230),n2h64(1230))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1231),h0tab(:,1231),[64,2,32,16,1,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1231),heltab2x128(:,:,1231))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1231),n2h64(1231))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1232),h0tab(:,1232),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1232),heltab2x128(:,:,1232))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1232),n2h64(1232))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1233),h0tab(:,1233),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1233),heltab2x128(:,:,1233))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1233),n2h64(1233))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1234),h0tab(:,1234),[64,2,32,16,1,8,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1234),heltab2x128(:,:,1234))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1234),n2h64(1234))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1235),h0tab(:,1235),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1235),heltab2x128(:,:,1235))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1235),n2h64(1235))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1236),h0tab(:,1236),[64,2,32,16,1,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1236),heltab2x128(:,:,1236))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1236),n2h64(1236))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1237),h0tab(:,1237),[64,2,32,16,1,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1237),heltab2x128(:,:,1237))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1237),n2h64(1237))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1238),h0tab(:,1238),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1238),heltab2x128(:,:,1238))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1238),n2h64(1238))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1239),h0tab(:,1239),[64,2,32,16,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1239),heltab2x128(:,:,1239))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1239),n2h64(1239))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1240),h0tab(:,1240),[64,2,32,16,1,8,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1240),heltab2x128(:,:,1240))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1240),n2h64(1240))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1241),h0tab(:,1241),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1241),heltab2x128(:,:,1241))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1241),n2h64(1241))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1242),h0tab(:,1242),[64,2,32,16,1,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1242),heltab2x128(:,:,1242))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1242),n2h64(1242))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1243),h0tab(:,1243),[64,2,32,16,1,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1243),heltab2x128(:,:,1243))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1243),n2h64(1243))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1244),h0tab(:,1244),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1244),heltab2x128(:,:,1244))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1244),n2h64(1244))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1245),h0tab(:,1245),[64,2,32,16,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1245),heltab2x128(:,:,1245))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1245),n2h64(1245))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1246),h0tab(:,1246),[64,2,32,16,1,8,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1246),heltab2x128(:,:,1246))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1246),n2h64(1246))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1247),h0tab(:,1247),[64,2,32,16,1,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1247),heltab2x128(:,:,1247))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1247),n2h64(1247))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1248),h0tab(:,1248),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1248),heltab2x128(:,:,1248))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1248),n2h64(1248))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1249),h0tab(:,1249),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1249),heltab2x128(:,:,1249))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1249),n2h64(1249))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1250),h0tab(:,1250),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1250),heltab2x128(:,:,1250))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1250),n2h64(1250))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1251),h0tab(:,1251),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1251),heltab2x128(:,:,1251))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1251),n2h64(1251))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1252),h0tab(:,1252),[64,2,32,16,1,8,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1252),heltab2x128(:,:,1252))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1252),n2h64(1252))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1253),h0tab(:,1253),[64,2,32,16,1,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1253),heltab2x128(:,:,1253))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1253),n2h64(1253))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1254),h0tab(:,1254),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1254),heltab2x128(:,:,1254))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1254),n2h64(1254))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1255),h0tab(:,1255),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1255),heltab2x128(:,:,1255))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1255),n2h64(1255))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1256),h0tab(:,1256),[64,2,32,16,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1256),heltab2x128(:,:,1256))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1256),n2h64(1256))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1257),h0tab(:,1257),[64,2,32,16,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1257),heltab2x128(:,:,1257))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1257),n2h64(1257))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1258),h0tab(:,1258),[64,2,32,16,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1258),heltab2x128(:,:,1258))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1258),n2h64(1258))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1259),h0tab(:,1259),[64,16,4,2,8,1,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1259),heltab2x128(:,:,1259))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1259),n2h64(1259))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1260),h0tab(:,1260),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1260),heltab2x128(:,:,1260))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1260),n2h64(1260))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1261),h0tab(:,1261),[64,16,4,2,8,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1261),heltab2x128(:,:,1261))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1261),n2h64(1261))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1262),h0tab(:,1262),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1262),heltab2x128(:,:,1262))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1262),n2h64(1262))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1263),h0tab(:,1263),[64,16,4,2,8,1,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1263),heltab2x128(:,:,1263))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1263),n2h64(1263))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1264),h0tab(:,1264),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1264),heltab2x128(:,:,1264))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1264),n2h64(1264))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1265),h0tab(:,1265),[64,16,4,2,8,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1265),heltab2x128(:,:,1265))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1265),n2h64(1265))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1266),h0tab(:,1266),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1266),heltab2x128(:,:,1266))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1266),n2h64(1266))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1267),h0tab(:,1267),[64,16,4,2,8,1,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1267),heltab2x128(:,:,1267))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1267),n2h64(1267))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1268),h0tab(:,1268),[64,16,4,2,8,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1268),heltab2x128(:,:,1268))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1268),n2h64(1268))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1269),h0tab(:,1269),[64,16,4,2,8,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1269),heltab2x128(:,:,1269))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1269),n2h64(1269))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1270),h0tab(:,1270),[64,16,4,2,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1270),heltab2x128(:,:,1270))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1270),n2h64(1270))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1271),h0tab(:,1271),[64,16,4,2,8,1,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1271),heltab2x128(:,:,1271))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1271),n2h64(1271))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1272),h0tab(:,1272),[64,16,4,2,8,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1272),heltab2x128(:,:,1272))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1272),n2h64(1272))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1273),h0tab(:,1273),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1273),heltab2x128(:,:,1273))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1273),n2h64(1273))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1274),h0tab(:,1274),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1274),heltab2x128(:,:,1274))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1274),n2h64(1274))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1275),h0tab(:,1275),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1275),heltab2x128(:,:,1275))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1275),n2h64(1275))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1276),h0tab(:,1276),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1276),heltab2x128(:,:,1276))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1276),n2h64(1276))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1277),h0tab(:,1277),[64,16,4,2,8,1,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1277),heltab2x128(:,:,1277))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1277),n2h64(1277))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1278),h0tab(:,1278),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1278),heltab2x128(:,:,1278))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1278),n2h64(1278))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1279),h0tab(:,1279),[64,16,4,2,8,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1279),heltab2x128(:,:,1279))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1279),n2h64(1279))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1280),h0tab(:,1280),[64,16,4,2,8,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1280),heltab2x128(:,:,1280))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1280),n2h64(1280))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1281),h0tab(:,1281),[64,16,4,2,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1281),heltab2x128(:,:,1281))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1281),n2h64(1281))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1282),h0tab(:,1282),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1282),heltab2x128(:,:,1282))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1282),n2h64(1282))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1283),h0tab(:,1283),[64,16,4,2,8,1,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1283),heltab2x128(:,:,1283))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1283),n2h64(1283))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1284),h0tab(:,1284),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1284),heltab2x128(:,:,1284))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1284),n2h64(1284))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1285),h0tab(:,1285),[64,16,4,2,8,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1285),heltab2x128(:,:,1285))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1285),n2h64(1285))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1286),h0tab(:,1286),[64,16,4,2,8,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1286),heltab2x128(:,:,1286))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1286),n2h64(1286))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1287),h0tab(:,1287),[64,16,4,2,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1287),heltab2x128(:,:,1287))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1287),n2h64(1287))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1288),h0tab(:,1288),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1288),heltab2x128(:,:,1288))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1288),n2h64(1288))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1289),h0tab(:,1289),[64,16,4,2,8,1,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1289),heltab2x128(:,:,1289))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1289),n2h64(1289))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1290),h0tab(:,1290),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1290),heltab2x128(:,:,1290))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1290),n2h64(1290))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1291),h0tab(:,1291),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1291),heltab2x128(:,:,1291))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1291),n2h64(1291))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1292),h0tab(:,1292),[64,16,4,2,8,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1292),heltab2x128(:,:,1292))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1292),n2h64(1292))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1293),h0tab(:,1293),[64,16,4,2,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1293),heltab2x128(:,:,1293))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1293),n2h64(1293))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1294),h0tab(:,1294),[64,16,4,2,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1294),heltab2x128(:,:,1294))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1294),n2h64(1294))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1295),h0tab(:,1295),[64,16,4,2,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1295),heltab2x128(:,:,1295))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1295),n2h64(1295))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1296),h0tab(:,1296),[64,16,2,4,8,1,32],[nMM,nMH,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1296),heltab2x128(:,:,1296))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1296),n2h64(1296))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1297),h0tab(:,1297),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1297),heltab2x128(:,:,1297))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1297),n2h64(1297))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1298),h0tab(:,1298),[64,16,2,4,8,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1298),heltab2x128(:,:,1298))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1298),n2h64(1298))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1299),h0tab(:,1299),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1299),heltab2x128(:,:,1299))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1299),n2h64(1299))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1300),h0tab(:,1300),[64,16,2,4,8,1,32],[nMM,0,nME,nMH,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1300),heltab2x128(:,:,1300))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1300),n2h64(1300))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1301),h0tab(:,1301),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1301),heltab2x128(:,:,1301))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1301),n2h64(1301))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1302),h0tab(:,1302),[64,16,2,4,8,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1302),heltab2x128(:,:,1302))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1302),n2h64(1302))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1303),h0tab(:,1303),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1303),heltab2x128(:,:,1303))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1303),n2h64(1303))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1304),h0tab(:,1304),[64,16,2,4,8,1,32],[nMM,nMH,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1304),heltab2x128(:,:,1304))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1304),n2h64(1304))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1305),h0tab(:,1305),[64,16,2,4,8,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1305),heltab2x128(:,:,1305))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1305),n2h64(1305))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1306),h0tab(:,1306),[64,16,2,4,8,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1306),heltab2x128(:,:,1306))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1306),n2h64(1306))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1307),h0tab(:,1307),[64,16,2,4,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1307),heltab2x128(:,:,1307))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1307),n2h64(1307))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1308),h0tab(:,1308),[64,16,2,4,8,1,32],[nMM,0,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1308),heltab2x128(:,:,1308))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1308),n2h64(1308))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1309),h0tab(:,1309),[64,16,2,4,8,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1309),heltab2x128(:,:,1309))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1309),n2h64(1309))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1310),h0tab(:,1310),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1310),heltab2x128(:,:,1310))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1310),n2h64(1310))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1311),h0tab(:,1311),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,nMH,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1311),heltab2x128(:,:,1311))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1311),n2h64(1311))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1312),h0tab(:,1312),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1312),heltab2x128(:,:,1312))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1312),n2h64(1312))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1313),h0tab(:,1313),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1313),heltab2x128(:,:,1313))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1313),n2h64(1313))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1314),h0tab(:,1314),[64,16,2,4,8,1,32],[nMM,nMH,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1314),heltab2x128(:,:,1314))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1314),n2h64(1314))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1315),h0tab(:,1315),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1315),heltab2x128(:,:,1315))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1315),n2h64(1315))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1316),h0tab(:,1316),[64,16,2,4,8,1,32],[nMM,nMH,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1316),heltab2x128(:,:,1316))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1316),n2h64(1316))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1317),h0tab(:,1317),[64,16,2,4,8,1,32],[nMM,nMH,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1317),heltab2x128(:,:,1317))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1317),n2h64(1317))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1318),h0tab(:,1318),[64,16,2,4,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1318),heltab2x128(:,:,1318))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1318),n2h64(1318))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1319),h0tab(:,1319),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1319),heltab2x128(:,:,1319))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1319),n2h64(1319))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1320),h0tab(:,1320),[64,16,2,4,8,1,32],[nMM,0,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1320),heltab2x128(:,:,1320))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1320),n2h64(1320))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1321),h0tab(:,1321),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1321),heltab2x128(:,:,1321))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1321),n2h64(1321))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1322),h0tab(:,1322),[64,16,2,4,8,1,32],[nMM,nMZ,nME,nMH,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1322),heltab2x128(:,:,1322))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1322),n2h64(1322))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1323),h0tab(:,1323),[64,16,2,4,8,1,32],[nMM,0,nME,nMH,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1323),heltab2x128(:,:,1323))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1323),n2h64(1323))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1324),h0tab(:,1324),[64,16,2,4,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1324),heltab2x128(:,:,1324))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1324),n2h64(1324))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1325),h0tab(:,1325),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1325),heltab2x128(:,:,1325))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1325),n2h64(1325))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1326),h0tab(:,1326),[64,16,2,4,8,1,32],[nMM,0,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1326),heltab2x128(:,:,1326))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1326),n2h64(1326))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1327),h0tab(:,1327),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1327),heltab2x128(:,:,1327))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1327),n2h64(1327))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1328),h0tab(:,1328),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1328),heltab2x128(:,:,1328))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1328),n2h64(1328))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1329),h0tab(:,1329),[64,16,2,4,8,1,32],[nMM,0,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1329),heltab2x128(:,:,1329))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1329),n2h64(1329))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1330),h0tab(:,1330),[64,16,2,4,8,1,32],[nMM,nMZ,nME,nMZ,nME,0,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1330),heltab2x128(:,:,1330))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1330),n2h64(1330))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1331),h0tab(:,1331),[64,16,2,4,8,1,32],[nMM,0,nME,nMZ,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1331),heltab2x128(:,:,1331))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1331),n2h64(1331))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1332),h0tab(:,1332),[64,16,2,4,8,1,32],[nMM,nMZ,nME,0,nME,nMZ,nMM],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1332),heltab2x128(:,:,1332))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMM,G1H64(1332),n2h64(1332))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1333),h0tab(:,1333),[64,2,8,1,32,16,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1333),heltab2x128(:,:,1333))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1333),n2h64(1333))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1334),h0tab(:,1334),[64,2,8,1,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1334),heltab2x128(:,:,1334))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1334),n2h64(1334))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1335),h0tab(:,1335),[64,2,8,1,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1335),heltab2x128(:,:,1335))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1335),n2h64(1335))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1336),h0tab(:,1336),[64,2,8,1,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1336),heltab2x128(:,:,1336))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1336),n2h64(1336))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1337),h0tab(:,1337),[64,2,8,1,32,16,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1337),heltab2x128(:,:,1337))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1337),n2h64(1337))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1338),h0tab(:,1338),[64,2,8,1,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1338),heltab2x128(:,:,1338))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1338),n2h64(1338))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1339),h0tab(:,1339),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1339),heltab2x128(:,:,1339))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1339),n2h64(1339))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1340),h0tab(:,1340),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1340),heltab2x128(:,:,1340))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1340),n2h64(1340))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1341),h0tab(:,1341),[64,2,8,1,32,16,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1341),heltab2x128(:,:,1341))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1341),n2h64(1341))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1342),h0tab(:,1342),[64,2,8,1,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1342),heltab2x128(:,:,1342))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1342),n2h64(1342))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1343),h0tab(:,1343),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1343),heltab2x128(:,:,1343))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1343),n2h64(1343))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1344),h0tab(:,1344),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1344),heltab2x128(:,:,1344))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1344),n2h64(1344))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1345),h0tab(:,1345),[64,2,8,1,32,16,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1345),heltab2x128(:,:,1345))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1345),n2h64(1345))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1346),h0tab(:,1346),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1346),heltab2x128(:,:,1346))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1346),n2h64(1346))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1347),h0tab(:,1347),[64,2,8,1,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1347),heltab2x128(:,:,1347))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1347),n2h64(1347))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1348),h0tab(:,1348),[64,2,8,1,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1348),heltab2x128(:,:,1348))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1348),n2h64(1348))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1349),h0tab(:,1349),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1349),heltab2x128(:,:,1349))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1349),n2h64(1349))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1350),h0tab(:,1350),[64,2,8,1,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1350),heltab2x128(:,:,1350))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1350),n2h64(1350))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1351),h0tab(:,1351),[64,2,8,1,32,16,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1351),heltab2x128(:,:,1351))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1351),n2h64(1351))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1352),h0tab(:,1352),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1352),heltab2x128(:,:,1352))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1352),n2h64(1352))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1353),h0tab(:,1353),[64,2,8,1,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1353),heltab2x128(:,:,1353))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1353),n2h64(1353))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1354),h0tab(:,1354),[64,2,8,1,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1354),heltab2x128(:,:,1354))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1354),n2h64(1354))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1355),h0tab(:,1355),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1355),heltab2x128(:,:,1355))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1355),n2h64(1355))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1356),h0tab(:,1356),[64,2,8,1,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1356),heltab2x128(:,:,1356))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1356),n2h64(1356))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1357),h0tab(:,1357),[64,2,8,1,32,16,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1357),heltab2x128(:,:,1357))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1357),n2h64(1357))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1358),h0tab(:,1358),[64,2,8,1,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1358),heltab2x128(:,:,1358))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1358),n2h64(1358))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1359),h0tab(:,1359),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1359),heltab2x128(:,:,1359))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1359),n2h64(1359))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1360),h0tab(:,1360),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1360),heltab2x128(:,:,1360))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1360),n2h64(1360))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1361),h0tab(:,1361),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1361),heltab2x128(:,:,1361))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1361),n2h64(1361))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1362),h0tab(:,1362),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1362),heltab2x128(:,:,1362))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1362),n2h64(1362))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1363),h0tab(:,1363),[64,2,8,1,32,16,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1363),heltab2x128(:,:,1363))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1363),n2h64(1363))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1364),h0tab(:,1364),[64,2,8,1,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1364),heltab2x128(:,:,1364))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1364),n2h64(1364))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1365),h0tab(:,1365),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1365),heltab2x128(:,:,1365))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1365),n2h64(1365))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1366),h0tab(:,1366),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1366),heltab2x128(:,:,1366))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1366),n2h64(1366))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1367),h0tab(:,1367),[64,2,8,1,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1367),heltab2x128(:,:,1367))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1367),n2h64(1367))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1368),h0tab(:,1368),[64,2,8,1,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1368),heltab2x128(:,:,1368))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1368),n2h64(1368))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1369),h0tab(:,1369),[64,2,8,1,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1369),heltab2x128(:,:,1369))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1369),n2h64(1369))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1370),h0tab(:,1370),[64,2,16,32,1,8,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1370),heltab2x128(:,:,1370))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1370),n2h64(1370))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1371),h0tab(:,1371),[64,2,16,32,1,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1371),heltab2x128(:,:,1371))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1371),n2h64(1371))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1372),h0tab(:,1372),[64,2,16,32,1,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1372),heltab2x128(:,:,1372))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1372),n2h64(1372))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1373),h0tab(:,1373),[64,2,16,32,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1373),heltab2x128(:,:,1373))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1373),n2h64(1373))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1374),h0tab(:,1374),[64,2,16,32,1,8,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1374),heltab2x128(:,:,1374))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1374),n2h64(1374))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1375),h0tab(:,1375),[64,2,16,32,1,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1375),heltab2x128(:,:,1375))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1375),n2h64(1375))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1376),h0tab(:,1376),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1376),heltab2x128(:,:,1376))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1376),n2h64(1376))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1377),h0tab(:,1377),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1377),heltab2x128(:,:,1377))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1377),n2h64(1377))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1378),h0tab(:,1378),[64,2,16,32,1,8,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1378),heltab2x128(:,:,1378))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1378),n2h64(1378))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1379),h0tab(:,1379),[64,2,16,32,1,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1379),heltab2x128(:,:,1379))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1379),n2h64(1379))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1380),h0tab(:,1380),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1380),heltab2x128(:,:,1380))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1380),n2h64(1380))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1381),h0tab(:,1381),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1381),heltab2x128(:,:,1381))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1381),n2h64(1381))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1382),h0tab(:,1382),[64,2,16,32,1,8,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1382),heltab2x128(:,:,1382))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1382),n2h64(1382))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1383),h0tab(:,1383),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1383),heltab2x128(:,:,1383))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1383),n2h64(1383))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1384),h0tab(:,1384),[64,2,16,32,1,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1384),heltab2x128(:,:,1384))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1384),n2h64(1384))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1385),h0tab(:,1385),[64,2,16,32,1,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1385),heltab2x128(:,:,1385))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1385),n2h64(1385))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1386),h0tab(:,1386),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1386),heltab2x128(:,:,1386))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1386),n2h64(1386))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1387),h0tab(:,1387),[64,2,16,32,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1387),heltab2x128(:,:,1387))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1387),n2h64(1387))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1388),h0tab(:,1388),[64,2,16,32,1,8,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1388),heltab2x128(:,:,1388))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1388),n2h64(1388))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1389),h0tab(:,1389),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1389),heltab2x128(:,:,1389))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1389),n2h64(1389))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1390),h0tab(:,1390),[64,2,16,32,1,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1390),heltab2x128(:,:,1390))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1390),n2h64(1390))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1391),h0tab(:,1391),[64,2,16,32,1,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1391),heltab2x128(:,:,1391))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1391),n2h64(1391))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1392),h0tab(:,1392),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1392),heltab2x128(:,:,1392))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1392),n2h64(1392))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1393),h0tab(:,1393),[64,2,16,32,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1393),heltab2x128(:,:,1393))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1393),n2h64(1393))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1394),h0tab(:,1394),[64,2,16,32,1,8,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1394),heltab2x128(:,:,1394))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1394),n2h64(1394))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1395),h0tab(:,1395),[64,2,16,32,1,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1395),heltab2x128(:,:,1395))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1395),n2h64(1395))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1396),h0tab(:,1396),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1396),heltab2x128(:,:,1396))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1396),n2h64(1396))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1397),h0tab(:,1397),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1397),heltab2x128(:,:,1397))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1397),n2h64(1397))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1398),h0tab(:,1398),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1398),heltab2x128(:,:,1398))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1398),n2h64(1398))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1399),h0tab(:,1399),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1399),heltab2x128(:,:,1399))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1399),n2h64(1399))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1400),h0tab(:,1400),[64,2,16,32,1,8,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1400),heltab2x128(:,:,1400))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1400),n2h64(1400))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1401),h0tab(:,1401),[64,2,16,32,1,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1401),heltab2x128(:,:,1401))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1401),n2h64(1401))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1402),h0tab(:,1402),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1402),heltab2x128(:,:,1402))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1402),n2h64(1402))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1403),h0tab(:,1403),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1403),heltab2x128(:,:,1403))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1403),n2h64(1403))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1404),h0tab(:,1404),[64,2,16,32,1,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1404),heltab2x128(:,:,1404))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1404),n2h64(1404))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1405),h0tab(:,1405),[64,2,16,32,1,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1405),heltab2x128(:,:,1405))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1405),n2h64(1405))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1406),h0tab(:,1406),[64,2,16,32,1,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1406),heltab2x128(:,:,1406))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1406),n2h64(1406))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1407),h0tab(:,1407),[64,1,8,2,16,32,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1407),heltab2x128(:,:,1407))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1407),n2h64(1407))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1408),h0tab(:,1408),[64,1,8,2,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1408),heltab2x128(:,:,1408))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1408),n2h64(1408))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1409),h0tab(:,1409),[64,1,8,2,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1409),heltab2x128(:,:,1409))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1409),n2h64(1409))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1410),h0tab(:,1410),[64,1,8,2,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1410),heltab2x128(:,:,1410))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1410),n2h64(1410))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1411),h0tab(:,1411),[64,1,8,2,16,32,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1411),heltab2x128(:,:,1411))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1411),n2h64(1411))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1412),h0tab(:,1412),[64,1,8,2,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1412),heltab2x128(:,:,1412))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1412),n2h64(1412))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1413),h0tab(:,1413),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1413),heltab2x128(:,:,1413))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1413),n2h64(1413))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1414),h0tab(:,1414),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1414),heltab2x128(:,:,1414))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1414),n2h64(1414))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1415),h0tab(:,1415),[64,1,8,2,16,32,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1415),heltab2x128(:,:,1415))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1415),n2h64(1415))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1416),h0tab(:,1416),[64,1,8,2,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1416),heltab2x128(:,:,1416))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1416),n2h64(1416))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1417),h0tab(:,1417),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1417),heltab2x128(:,:,1417))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1417),n2h64(1417))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1418),h0tab(:,1418),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1418),heltab2x128(:,:,1418))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1418),n2h64(1418))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1419),h0tab(:,1419),[64,1,8,2,16,32,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1419),heltab2x128(:,:,1419))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1419),n2h64(1419))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1420),h0tab(:,1420),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1420),heltab2x128(:,:,1420))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1420),n2h64(1420))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1421),h0tab(:,1421),[64,1,8,2,16,32,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1421),heltab2x128(:,:,1421))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1421),n2h64(1421))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1422),h0tab(:,1422),[64,1,8,2,16,32,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1422),heltab2x128(:,:,1422))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1422),n2h64(1422))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1423),h0tab(:,1423),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1423),heltab2x128(:,:,1423))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1423),n2h64(1423))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1424),h0tab(:,1424),[64,1,8,2,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1424),heltab2x128(:,:,1424))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1424),n2h64(1424))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1425),h0tab(:,1425),[64,1,8,2,16,32,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1425),heltab2x128(:,:,1425))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1425),n2h64(1425))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1426),h0tab(:,1426),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1426),heltab2x128(:,:,1426))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1426),n2h64(1426))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1427),h0tab(:,1427),[64,1,8,2,16,32,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1427),heltab2x128(:,:,1427))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1427),n2h64(1427))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1428),h0tab(:,1428),[64,1,8,2,16,32,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1428),heltab2x128(:,:,1428))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1428),n2h64(1428))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1429),h0tab(:,1429),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1429),heltab2x128(:,:,1429))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1429),n2h64(1429))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1430),h0tab(:,1430),[64,1,8,2,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1430),heltab2x128(:,:,1430))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1430),n2h64(1430))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1431),h0tab(:,1431),[64,1,8,2,16,32,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1431),heltab2x128(:,:,1431))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1431),n2h64(1431))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1432),h0tab(:,1432),[64,1,8,2,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1432),heltab2x128(:,:,1432))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1432),n2h64(1432))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1433),h0tab(:,1433),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1433),heltab2x128(:,:,1433))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1433),n2h64(1433))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1434),h0tab(:,1434),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1434),heltab2x128(:,:,1434))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1434),n2h64(1434))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1435),h0tab(:,1435),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1435),heltab2x128(:,:,1435))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1435),n2h64(1435))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1436),h0tab(:,1436),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1436),heltab2x128(:,:,1436))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1436),n2h64(1436))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1437),h0tab(:,1437),[64,1,8,2,16,32,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1437),heltab2x128(:,:,1437))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1437),n2h64(1437))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1438),h0tab(:,1438),[64,1,8,2,16,32,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1438),heltab2x128(:,:,1438))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1438),n2h64(1438))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1439),h0tab(:,1439),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1439),heltab2x128(:,:,1439))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1439),n2h64(1439))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1440),h0tab(:,1440),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1440),heltab2x128(:,:,1440))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1440),n2h64(1440))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1441),h0tab(:,1441),[64,1,8,2,16,32,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1441),heltab2x128(:,:,1441))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1441),n2h64(1441))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1442),h0tab(:,1442),[64,1,8,2,16,32,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1442),heltab2x128(:,:,1442))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1442),n2h64(1442))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1443),h0tab(:,1443),[64,1,8,2,16,32,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1443),heltab2x128(:,:,1443))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1443),n2h64(1443))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1444),h0tab(:,1444),[64,1,8,2,32,16,4],[nME,nMH,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1444),heltab2x128(:,:,1444))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1444),n2h64(1444))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1445),h0tab(:,1445),[64,1,8,2,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1445),heltab2x128(:,:,1445))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1445),n2h64(1445))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1446),h0tab(:,1446),[64,1,8,2,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1446),heltab2x128(:,:,1446))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1446),n2h64(1446))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1447),h0tab(:,1447),[64,1,8,2,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1447),heltab2x128(:,:,1447))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1447),n2h64(1447))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1448),h0tab(:,1448),[64,1,8,2,32,16,4],[nME,nMH,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1448),heltab2x128(:,:,1448))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1448),n2h64(1448))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1449),h0tab(:,1449),[64,1,8,2,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1449),heltab2x128(:,:,1449))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1449),n2h64(1449))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1450),h0tab(:,1450),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1450),heltab2x128(:,:,1450))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1450),n2h64(1450))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1451),h0tab(:,1451),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1451),heltab2x128(:,:,1451))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1451),n2h64(1451))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1452),h0tab(:,1452),[64,1,8,2,32,16,4],[nME,0,nME,nMH,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1452),heltab2x128(:,:,1452))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1452),n2h64(1452))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1453),h0tab(:,1453),[64,1,8,2,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1453),heltab2x128(:,:,1453))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1453),n2h64(1453))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1454),h0tab(:,1454),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1454),heltab2x128(:,:,1454))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1454),n2h64(1454))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1455),h0tab(:,1455),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1455),heltab2x128(:,:,1455))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1455),n2h64(1455))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1456),h0tab(:,1456),[64,1,8,2,32,16,4],[nME,nMH,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1456),heltab2x128(:,:,1456))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1456),n2h64(1456))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1457),h0tab(:,1457),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1457),heltab2x128(:,:,1457))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1457),n2h64(1457))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1458),h0tab(:,1458),[64,1,8,2,32,16,4],[nME,nMH,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1458),heltab2x128(:,:,1458))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1458),n2h64(1458))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1459),h0tab(:,1459),[64,1,8,2,32,16,4],[nME,nMH,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1459),heltab2x128(:,:,1459))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1459),n2h64(1459))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1460),h0tab(:,1460),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1460),heltab2x128(:,:,1460))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1460),n2h64(1460))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1461),h0tab(:,1461),[64,1,8,2,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1461),heltab2x128(:,:,1461))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1461),n2h64(1461))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1462),h0tab(:,1462),[64,1,8,2,32,16,4],[nME,0,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1462),heltab2x128(:,:,1462))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1462),n2h64(1462))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1463),h0tab(:,1463),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1463),heltab2x128(:,:,1463))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1463),n2h64(1463))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1464),h0tab(:,1464),[64,1,8,2,32,16,4],[nME,0,nME,nMH,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1464),heltab2x128(:,:,1464))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1464),n2h64(1464))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1465),h0tab(:,1465),[64,1,8,2,32,16,4],[nME,nMZ,nME,nMH,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1465),heltab2x128(:,:,1465))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1465),n2h64(1465))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1466),h0tab(:,1466),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1466),heltab2x128(:,:,1466))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1466),n2h64(1466))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1467),h0tab(:,1467),[64,1,8,2,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1467),heltab2x128(:,:,1467))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1467),n2h64(1467))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1468),h0tab(:,1468),[64,1,8,2,32,16,4],[nME,0,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1468),heltab2x128(:,:,1468))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1468),n2h64(1468))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1469),h0tab(:,1469),[64,1,8,2,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1469),heltab2x128(:,:,1469))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1469),n2h64(1469))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1470),h0tab(:,1470),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1470),heltab2x128(:,:,1470))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1470),n2h64(1470))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1471),h0tab(:,1471),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1471),heltab2x128(:,:,1471))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1471),n2h64(1471))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1472),h0tab(:,1472),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1472),heltab2x128(:,:,1472))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1472),n2h64(1472))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1473),h0tab(:,1473),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1473),heltab2x128(:,:,1473))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1473),n2h64(1473))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1474),h0tab(:,1474),[64,1,8,2,32,16,4],[nME,0,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1474),heltab2x128(:,:,1474))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1474),n2h64(1474))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1475),h0tab(:,1475),[64,1,8,2,32,16,4],[nME,0,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1475),heltab2x128(:,:,1475))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1475),n2h64(1475))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1476),h0tab(:,1476),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1476),heltab2x128(:,:,1476))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1476),n2h64(1476))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1477),h0tab(:,1477),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1477),heltab2x128(:,:,1477))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1477),n2h64(1477))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1478),h0tab(:,1478),[64,1,8,2,32,16,4],[nME,0,nME,nMZ,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1478),heltab2x128(:,:,1478))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1478),n2h64(1478))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1479),h0tab(:,1479),[64,1,8,2,32,16,4],[nME,nMZ,nME,0,nMM,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1479),heltab2x128(:,:,1479))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1479),n2h64(1479))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1480),h0tab(:,1480),[64,1,8,2,32,16,4],[nME,nMZ,nME,nMZ,nMM,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1480),heltab2x128(:,:,1480))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1480),n2h64(1480))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1481),h0tab(:,1481),[64,1,16,32,4,2,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1481),heltab2x128(:,:,1481))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1481),n2h64(1481))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1482),h0tab(:,1482),[64,1,16,32,4,2,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1482),heltab2x128(:,:,1482))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1482),n2h64(1482))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1483),h0tab(:,1483),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1483),heltab2x128(:,:,1483))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1483),n2h64(1483))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1484),h0tab(:,1484),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1484),heltab2x128(:,:,1484))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1484),n2h64(1484))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1485),h0tab(:,1485),[64,1,16,32,4,2,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1485),heltab2x128(:,:,1485))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1485),n2h64(1485))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1486),h0tab(:,1486),[64,1,16,32,4,2,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1486),heltab2x128(:,:,1486))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1486),n2h64(1486))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1487),h0tab(:,1487),[64,1,16,32,4,2,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1487),heltab2x128(:,:,1487))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1487),n2h64(1487))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1488),h0tab(:,1488),[64,1,16,32,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1488),heltab2x128(:,:,1488))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1488),n2h64(1488))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1489),h0tab(:,1489),[64,1,16,32,4,2,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1489),heltab2x128(:,:,1489))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1489),n2h64(1489))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1490),h0tab(:,1490),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1490),heltab2x128(:,:,1490))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1490),n2h64(1490))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1491),h0tab(:,1491),[64,1,16,32,4,2,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1491),heltab2x128(:,:,1491))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1491),n2h64(1491))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1492),h0tab(:,1492),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1492),heltab2x128(:,:,1492))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1492),n2h64(1492))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1493),h0tab(:,1493),[64,1,16,32,4,2,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1493),heltab2x128(:,:,1493))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1493),n2h64(1493))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1494),h0tab(:,1494),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1494),heltab2x128(:,:,1494))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1494),n2h64(1494))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1495),h0tab(:,1495),[64,1,16,32,4,2,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1495),heltab2x128(:,:,1495))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1495),n2h64(1495))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1496),h0tab(:,1496),[64,1,16,32,4,2,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1496),heltab2x128(:,:,1496))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1496),n2h64(1496))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1497),h0tab(:,1497),[64,1,16,32,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1497),heltab2x128(:,:,1497))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1497),n2h64(1497))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1498),h0tab(:,1498),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1498),heltab2x128(:,:,1498))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1498),n2h64(1498))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1499),h0tab(:,1499),[64,1,16,32,4,2,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1499),heltab2x128(:,:,1499))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1499),n2h64(1499))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1500),h0tab(:,1500),[64,1,16,32,4,2,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1500),heltab2x128(:,:,1500))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1500),n2h64(1500))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1501),h0tab(:,1501),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1501),heltab2x128(:,:,1501))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1501),n2h64(1501))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1502),h0tab(:,1502),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1502),heltab2x128(:,:,1502))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1502),n2h64(1502))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1503),h0tab(:,1503),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1503),heltab2x128(:,:,1503))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1503),n2h64(1503))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1504),h0tab(:,1504),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1504),heltab2x128(:,:,1504))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1504),n2h64(1504))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1505),h0tab(:,1505),[64,1,16,32,4,2,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1505),heltab2x128(:,:,1505))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1505),n2h64(1505))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1506),h0tab(:,1506),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1506),heltab2x128(:,:,1506))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1506),n2h64(1506))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1507),h0tab(:,1507),[64,1,16,32,4,2,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1507),heltab2x128(:,:,1507))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1507),n2h64(1507))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1508),h0tab(:,1508),[64,1,16,32,4,2,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1508),heltab2x128(:,:,1508))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1508),n2h64(1508))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1509),h0tab(:,1509),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1509),heltab2x128(:,:,1509))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1509),n2h64(1509))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1510),h0tab(:,1510),[64,1,16,32,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1510),heltab2x128(:,:,1510))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1510),n2h64(1510))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1511),h0tab(:,1511),[64,1,16,32,4,2,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1511),heltab2x128(:,:,1511))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1511),n2h64(1511))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1512),h0tab(:,1512),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1512),heltab2x128(:,:,1512))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1512),n2h64(1512))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1513),h0tab(:,1513),[64,1,16,32,4,2,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1513),heltab2x128(:,:,1513))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1513),n2h64(1513))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1514),h0tab(:,1514),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1514),heltab2x128(:,:,1514))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1514),n2h64(1514))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1515),h0tab(:,1515),[64,1,16,32,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1515),heltab2x128(:,:,1515))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1515),n2h64(1515))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1516),h0tab(:,1516),[64,1,16,32,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1516),heltab2x128(:,:,1516))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1516),n2h64(1516))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1517),h0tab(:,1517),[64,1,16,32,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1517),heltab2x128(:,:,1517))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1517),n2h64(1517))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1518),h0tab(:,1518),[64,1,16,32,8,2,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1518),heltab2x128(:,:,1518))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1518),n2h64(1518))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1519),h0tab(:,1519),[64,1,16,32,8,2,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1519),heltab2x128(:,:,1519))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1519),n2h64(1519))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1520),h0tab(:,1520),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1520),heltab2x128(:,:,1520))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1520),n2h64(1520))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1521),h0tab(:,1521),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1521),heltab2x128(:,:,1521))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1521),n2h64(1521))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1522),h0tab(:,1522),[64,1,16,32,8,2,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1522),heltab2x128(:,:,1522))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1522),n2h64(1522))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1523),h0tab(:,1523),[64,1,16,32,8,2,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1523),heltab2x128(:,:,1523))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1523),n2h64(1523))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1524),h0tab(:,1524),[64,1,16,32,8,2,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1524),heltab2x128(:,:,1524))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1524),n2h64(1524))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1525),h0tab(:,1525),[64,1,16,32,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1525),heltab2x128(:,:,1525))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1525),n2h64(1525))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1526),h0tab(:,1526),[64,1,16,32,8,2,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1526),heltab2x128(:,:,1526))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1526),n2h64(1526))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1527),h0tab(:,1527),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1527),heltab2x128(:,:,1527))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1527),n2h64(1527))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1528),h0tab(:,1528),[64,1,16,32,8,2,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1528),heltab2x128(:,:,1528))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1528),n2h64(1528))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1529),h0tab(:,1529),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1529),heltab2x128(:,:,1529))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1529),n2h64(1529))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1530),h0tab(:,1530),[64,1,16,32,8,2,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1530),heltab2x128(:,:,1530))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1530),n2h64(1530))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1531),h0tab(:,1531),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1531),heltab2x128(:,:,1531))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1531),n2h64(1531))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1532),h0tab(:,1532),[64,1,16,32,8,2,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1532),heltab2x128(:,:,1532))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1532),n2h64(1532))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1533),h0tab(:,1533),[64,1,16,32,8,2,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1533),heltab2x128(:,:,1533))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1533),n2h64(1533))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1534),h0tab(:,1534),[64,1,16,32,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1534),heltab2x128(:,:,1534))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1534),n2h64(1534))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1535),h0tab(:,1535),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1535),heltab2x128(:,:,1535))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1535),n2h64(1535))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1536),h0tab(:,1536),[64,1,16,32,8,2,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1536),heltab2x128(:,:,1536))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1536),n2h64(1536))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1537),h0tab(:,1537),[64,1,16,32,8,2,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1537),heltab2x128(:,:,1537))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1537),n2h64(1537))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1538),h0tab(:,1538),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1538),heltab2x128(:,:,1538))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1538),n2h64(1538))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1539),h0tab(:,1539),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1539),heltab2x128(:,:,1539))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1539),n2h64(1539))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1540),h0tab(:,1540),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1540),heltab2x128(:,:,1540))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1540),n2h64(1540))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1541),h0tab(:,1541),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1541),heltab2x128(:,:,1541))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1541),n2h64(1541))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1542),h0tab(:,1542),[64,1,16,32,8,2,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1542),heltab2x128(:,:,1542))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1542),n2h64(1542))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1543),h0tab(:,1543),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1543),heltab2x128(:,:,1543))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1543),n2h64(1543))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1544),h0tab(:,1544),[64,1,16,32,8,2,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1544),heltab2x128(:,:,1544))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1544),n2h64(1544))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1545),h0tab(:,1545),[64,1,16,32,8,2,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1545),heltab2x128(:,:,1545))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1545),n2h64(1545))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1546),h0tab(:,1546),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1546),heltab2x128(:,:,1546))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1546),n2h64(1546))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1547),h0tab(:,1547),[64,1,16,32,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1547),heltab2x128(:,:,1547))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1547),n2h64(1547))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1548),h0tab(:,1548),[64,1,16,32,8,2,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1548),heltab2x128(:,:,1548))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1548),n2h64(1548))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1549),h0tab(:,1549),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1549),heltab2x128(:,:,1549))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1549),n2h64(1549))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1550),h0tab(:,1550),[64,1,16,32,8,2,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1550),heltab2x128(:,:,1550))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1550),n2h64(1550))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1551),h0tab(:,1551),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1551),heltab2x128(:,:,1551))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1551),n2h64(1551))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1552),h0tab(:,1552),[64,1,16,32,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1552),heltab2x128(:,:,1552))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1552),n2h64(1552))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1553),h0tab(:,1553),[64,1,16,32,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1553),heltab2x128(:,:,1553))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1553),n2h64(1553))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1554),h0tab(:,1554),[64,1,16,32,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1554),heltab2x128(:,:,1554))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1554),n2h64(1554))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1555),h0tab(:,1555),[64,1,16,32,2,4,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1555),heltab2x128(:,:,1555))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1555),n2h64(1555))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1556),h0tab(:,1556),[64,1,16,32,2,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1556),heltab2x128(:,:,1556))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1556),n2h64(1556))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1557),h0tab(:,1557),[64,1,16,32,2,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1557),heltab2x128(:,:,1557))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1557),n2h64(1557))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1558),h0tab(:,1558),[64,1,16,32,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1558),heltab2x128(:,:,1558))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1558),n2h64(1558))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1559),h0tab(:,1559),[64,1,16,32,2,4,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1559),heltab2x128(:,:,1559))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1559),n2h64(1559))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1560),h0tab(:,1560),[64,1,16,32,2,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1560),heltab2x128(:,:,1560))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1560),n2h64(1560))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1561),h0tab(:,1561),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1561),heltab2x128(:,:,1561))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1561),n2h64(1561))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1562),h0tab(:,1562),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1562),heltab2x128(:,:,1562))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1562),n2h64(1562))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1563),h0tab(:,1563),[64,1,16,32,2,4,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1563),heltab2x128(:,:,1563))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1563),n2h64(1563))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1564),h0tab(:,1564),[64,1,16,32,2,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1564),heltab2x128(:,:,1564))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1564),n2h64(1564))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1565),h0tab(:,1565),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1565),heltab2x128(:,:,1565))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1565),n2h64(1565))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1566),h0tab(:,1566),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1566),heltab2x128(:,:,1566))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1566),n2h64(1566))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1567),h0tab(:,1567),[64,1,16,32,2,4,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1567),heltab2x128(:,:,1567))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1567),n2h64(1567))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1568),h0tab(:,1568),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1568),heltab2x128(:,:,1568))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1568),n2h64(1568))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1569),h0tab(:,1569),[64,1,16,32,2,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1569),heltab2x128(:,:,1569))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1569),n2h64(1569))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1570),h0tab(:,1570),[64,1,16,32,2,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1570),heltab2x128(:,:,1570))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1570),n2h64(1570))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1571),h0tab(:,1571),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1571),heltab2x128(:,:,1571))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1571),n2h64(1571))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1572),h0tab(:,1572),[64,1,16,32,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1572),heltab2x128(:,:,1572))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1572),n2h64(1572))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1573),h0tab(:,1573),[64,1,16,32,2,4,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1573),heltab2x128(:,:,1573))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1573),n2h64(1573))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1574),h0tab(:,1574),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1574),heltab2x128(:,:,1574))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1574),n2h64(1574))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1575),h0tab(:,1575),[64,1,16,32,2,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1575),heltab2x128(:,:,1575))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1575),n2h64(1575))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1576),h0tab(:,1576),[64,1,16,32,2,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1576),heltab2x128(:,:,1576))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1576),n2h64(1576))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1577),h0tab(:,1577),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1577),heltab2x128(:,:,1577))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1577),n2h64(1577))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1578),h0tab(:,1578),[64,1,16,32,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1578),heltab2x128(:,:,1578))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1578),n2h64(1578))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1579),h0tab(:,1579),[64,1,16,32,2,4,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1579),heltab2x128(:,:,1579))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1579),n2h64(1579))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1580),h0tab(:,1580),[64,1,16,32,2,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1580),heltab2x128(:,:,1580))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1580),n2h64(1580))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1581),h0tab(:,1581),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1581),heltab2x128(:,:,1581))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1581),n2h64(1581))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1582),h0tab(:,1582),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1582),heltab2x128(:,:,1582))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1582),n2h64(1582))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1583),h0tab(:,1583),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1583),heltab2x128(:,:,1583))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1583),n2h64(1583))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1584),h0tab(:,1584),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1584),heltab2x128(:,:,1584))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1584),n2h64(1584))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1585),h0tab(:,1585),[64,1,16,32,2,4,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1585),heltab2x128(:,:,1585))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1585),n2h64(1585))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1586),h0tab(:,1586),[64,1,16,32,2,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1586),heltab2x128(:,:,1586))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1586),n2h64(1586))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1587),h0tab(:,1587),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1587),heltab2x128(:,:,1587))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1587),n2h64(1587))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1588),h0tab(:,1588),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1588),heltab2x128(:,:,1588))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1588),n2h64(1588))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1589),h0tab(:,1589),[64,1,16,32,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1589),heltab2x128(:,:,1589))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1589),n2h64(1589))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1590),h0tab(:,1590),[64,1,16,32,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1590),heltab2x128(:,:,1590))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1590),n2h64(1590))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1591),h0tab(:,1591),[64,1,16,32,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1591),heltab2x128(:,:,1591))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1591),n2h64(1591))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1592),h0tab(:,1592),[64,1,16,32,2,8,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1592),heltab2x128(:,:,1592))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1592),n2h64(1592))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1593),h0tab(:,1593),[64,1,16,32,2,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1593),heltab2x128(:,:,1593))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1593),n2h64(1593))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1594),h0tab(:,1594),[64,1,16,32,2,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1594),heltab2x128(:,:,1594))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1594),n2h64(1594))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1595),h0tab(:,1595),[64,1,16,32,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1595),heltab2x128(:,:,1595))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1595),n2h64(1595))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1596),h0tab(:,1596),[64,1,16,32,2,8,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1596),heltab2x128(:,:,1596))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1596),n2h64(1596))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1597),h0tab(:,1597),[64,1,16,32,2,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1597),heltab2x128(:,:,1597))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1597),n2h64(1597))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1598),h0tab(:,1598),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1598),heltab2x128(:,:,1598))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1598),n2h64(1598))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1599),h0tab(:,1599),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1599),heltab2x128(:,:,1599))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1599),n2h64(1599))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1600),h0tab(:,1600),[64,1,16,32,2,8,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1600),heltab2x128(:,:,1600))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1600),n2h64(1600))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1601),h0tab(:,1601),[64,1,16,32,2,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1601),heltab2x128(:,:,1601))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1601),n2h64(1601))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1602),h0tab(:,1602),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1602),heltab2x128(:,:,1602))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1602),n2h64(1602))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1603),h0tab(:,1603),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1603),heltab2x128(:,:,1603))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1603),n2h64(1603))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1604),h0tab(:,1604),[64,1,16,32,2,8,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1604),heltab2x128(:,:,1604))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1604),n2h64(1604))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1605),h0tab(:,1605),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1605),heltab2x128(:,:,1605))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1605),n2h64(1605))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1606),h0tab(:,1606),[64,1,16,32,2,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1606),heltab2x128(:,:,1606))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1606),n2h64(1606))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1607),h0tab(:,1607),[64,1,16,32,2,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1607),heltab2x128(:,:,1607))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1607),n2h64(1607))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1608),h0tab(:,1608),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1608),heltab2x128(:,:,1608))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1608),n2h64(1608))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1609),h0tab(:,1609),[64,1,16,32,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1609),heltab2x128(:,:,1609))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1609),n2h64(1609))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1610),h0tab(:,1610),[64,1,16,32,2,8,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1610),heltab2x128(:,:,1610))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1610),n2h64(1610))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1611),h0tab(:,1611),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1611),heltab2x128(:,:,1611))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1611),n2h64(1611))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1612),h0tab(:,1612),[64,1,16,32,2,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1612),heltab2x128(:,:,1612))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1612),n2h64(1612))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1613),h0tab(:,1613),[64,1,16,32,2,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1613),heltab2x128(:,:,1613))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1613),n2h64(1613))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1614),h0tab(:,1614),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1614),heltab2x128(:,:,1614))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1614),n2h64(1614))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1615),h0tab(:,1615),[64,1,16,32,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1615),heltab2x128(:,:,1615))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1615),n2h64(1615))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1616),h0tab(:,1616),[64,1,16,32,2,8,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1616),heltab2x128(:,:,1616))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1616),n2h64(1616))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1617),h0tab(:,1617),[64,1,16,32,2,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1617),heltab2x128(:,:,1617))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1617),n2h64(1617))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1618),h0tab(:,1618),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1618),heltab2x128(:,:,1618))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1618),n2h64(1618))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1619),h0tab(:,1619),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1619),heltab2x128(:,:,1619))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1619),n2h64(1619))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1620),h0tab(:,1620),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1620),heltab2x128(:,:,1620))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1620),n2h64(1620))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1621),h0tab(:,1621),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1621),heltab2x128(:,:,1621))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1621),n2h64(1621))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1622),h0tab(:,1622),[64,1,16,32,2,8,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1622),heltab2x128(:,:,1622))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1622),n2h64(1622))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1623),h0tab(:,1623),[64,1,16,32,2,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1623),heltab2x128(:,:,1623))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1623),n2h64(1623))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1624),h0tab(:,1624),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1624),heltab2x128(:,:,1624))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1624),n2h64(1624))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1625),h0tab(:,1625),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1625),heltab2x128(:,:,1625))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1625),n2h64(1625))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1626),h0tab(:,1626),[64,1,16,32,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1626),heltab2x128(:,:,1626))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1626),n2h64(1626))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1627),h0tab(:,1627),[64,1,16,32,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1627),heltab2x128(:,:,1627))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1627),n2h64(1627))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1628),h0tab(:,1628),[64,1,16,32,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1628),heltab2x128(:,:,1628))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1628),n2h64(1628))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1629),h0tab(:,1629),[64,1,32,16,4,2,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1629),heltab2x128(:,:,1629))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1629),n2h64(1629))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1630),h0tab(:,1630),[64,1,32,16,4,2,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1630),heltab2x128(:,:,1630))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1630),n2h64(1630))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1631),h0tab(:,1631),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1631),heltab2x128(:,:,1631))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1631),n2h64(1631))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1632),h0tab(:,1632),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1632),heltab2x128(:,:,1632))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1632),n2h64(1632))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1633),h0tab(:,1633),[64,1,32,16,4,2,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1633),heltab2x128(:,:,1633))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1633),n2h64(1633))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1634),h0tab(:,1634),[64,1,32,16,4,2,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1634),heltab2x128(:,:,1634))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1634),n2h64(1634))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1635),h0tab(:,1635),[64,1,32,16,4,2,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1635),heltab2x128(:,:,1635))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1635),n2h64(1635))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1636),h0tab(:,1636),[64,1,32,16,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1636),heltab2x128(:,:,1636))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1636),n2h64(1636))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1637),h0tab(:,1637),[64,1,32,16,4,2,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1637),heltab2x128(:,:,1637))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1637),n2h64(1637))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1638),h0tab(:,1638),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1638),heltab2x128(:,:,1638))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1638),n2h64(1638))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1639),h0tab(:,1639),[64,1,32,16,4,2,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1639),heltab2x128(:,:,1639))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1639),n2h64(1639))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1640),h0tab(:,1640),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1640),heltab2x128(:,:,1640))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1640),n2h64(1640))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1641),h0tab(:,1641),[64,1,32,16,4,2,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1641),heltab2x128(:,:,1641))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1641),n2h64(1641))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1642),h0tab(:,1642),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1642),heltab2x128(:,:,1642))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1642),n2h64(1642))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1643),h0tab(:,1643),[64,1,32,16,4,2,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1643),heltab2x128(:,:,1643))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1643),n2h64(1643))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1644),h0tab(:,1644),[64,1,32,16,4,2,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1644),heltab2x128(:,:,1644))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1644),n2h64(1644))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1645),h0tab(:,1645),[64,1,32,16,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1645),heltab2x128(:,:,1645))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1645),n2h64(1645))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1646),h0tab(:,1646),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1646),heltab2x128(:,:,1646))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1646),n2h64(1646))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1647),h0tab(:,1647),[64,1,32,16,4,2,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1647),heltab2x128(:,:,1647))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1647),n2h64(1647))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1648),h0tab(:,1648),[64,1,32,16,4,2,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1648),heltab2x128(:,:,1648))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1648),n2h64(1648))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1649),h0tab(:,1649),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1649),heltab2x128(:,:,1649))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1649),n2h64(1649))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1650),h0tab(:,1650),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1650),heltab2x128(:,:,1650))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1650),n2h64(1650))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1651),h0tab(:,1651),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1651),heltab2x128(:,:,1651))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1651),n2h64(1651))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1652),h0tab(:,1652),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1652),heltab2x128(:,:,1652))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1652),n2h64(1652))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1653),h0tab(:,1653),[64,1,32,16,4,2,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1653),heltab2x128(:,:,1653))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1653),n2h64(1653))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1654),h0tab(:,1654),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1654),heltab2x128(:,:,1654))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1654),n2h64(1654))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1655),h0tab(:,1655),[64,1,32,16,4,2,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1655),heltab2x128(:,:,1655))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1655),n2h64(1655))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1656),h0tab(:,1656),[64,1,32,16,4,2,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1656),heltab2x128(:,:,1656))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1656),n2h64(1656))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1657),h0tab(:,1657),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1657),heltab2x128(:,:,1657))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1657),n2h64(1657))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1658),h0tab(:,1658),[64,1,32,16,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1658),heltab2x128(:,:,1658))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1658),n2h64(1658))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1659),h0tab(:,1659),[64,1,32,16,4,2,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1659),heltab2x128(:,:,1659))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1659),n2h64(1659))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1660),h0tab(:,1660),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1660),heltab2x128(:,:,1660))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1660),n2h64(1660))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1661),h0tab(:,1661),[64,1,32,16,4,2,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1661),heltab2x128(:,:,1661))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1661),n2h64(1661))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1662),h0tab(:,1662),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1662),heltab2x128(:,:,1662))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1662),n2h64(1662))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1663),h0tab(:,1663),[64,1,32,16,4,2,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1663),heltab2x128(:,:,1663))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1663),n2h64(1663))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1664),h0tab(:,1664),[64,1,32,16,4,2,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1664),heltab2x128(:,:,1664))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1664),n2h64(1664))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1665),h0tab(:,1665),[64,1,32,16,4,2,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1665),heltab2x128(:,:,1665))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1665),n2h64(1665))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1666),h0tab(:,1666),[64,1,32,16,8,2,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1666),heltab2x128(:,:,1666))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1666),n2h64(1666))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1667),h0tab(:,1667),[64,1,32,16,8,2,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1667),heltab2x128(:,:,1667))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1667),n2h64(1667))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1668),h0tab(:,1668),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1668),heltab2x128(:,:,1668))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1668),n2h64(1668))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1669),h0tab(:,1669),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1669),heltab2x128(:,:,1669))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1669),n2h64(1669))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1670),h0tab(:,1670),[64,1,32,16,8,2,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1670),heltab2x128(:,:,1670))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1670),n2h64(1670))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1671),h0tab(:,1671),[64,1,32,16,8,2,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1671),heltab2x128(:,:,1671))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1671),n2h64(1671))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1672),h0tab(:,1672),[64,1,32,16,8,2,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1672),heltab2x128(:,:,1672))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1672),n2h64(1672))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1673),h0tab(:,1673),[64,1,32,16,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1673),heltab2x128(:,:,1673))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1673),n2h64(1673))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1674),h0tab(:,1674),[64,1,32,16,8,2,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1674),heltab2x128(:,:,1674))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1674),n2h64(1674))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1675),h0tab(:,1675),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1675),heltab2x128(:,:,1675))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1675),n2h64(1675))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1676),h0tab(:,1676),[64,1,32,16,8,2,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1676),heltab2x128(:,:,1676))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1676),n2h64(1676))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1677),h0tab(:,1677),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1677),heltab2x128(:,:,1677))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1677),n2h64(1677))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1678),h0tab(:,1678),[64,1,32,16,8,2,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1678),heltab2x128(:,:,1678))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1678),n2h64(1678))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1679),h0tab(:,1679),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1679),heltab2x128(:,:,1679))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1679),n2h64(1679))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1680),h0tab(:,1680),[64,1,32,16,8,2,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1680),heltab2x128(:,:,1680))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1680),n2h64(1680))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1681),h0tab(:,1681),[64,1,32,16,8,2,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1681),heltab2x128(:,:,1681))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1681),n2h64(1681))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1682),h0tab(:,1682),[64,1,32,16,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1682),heltab2x128(:,:,1682))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1682),n2h64(1682))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1683),h0tab(:,1683),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1683),heltab2x128(:,:,1683))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1683),n2h64(1683))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1684),h0tab(:,1684),[64,1,32,16,8,2,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1684),heltab2x128(:,:,1684))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1684),n2h64(1684))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1685),h0tab(:,1685),[64,1,32,16,8,2,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1685),heltab2x128(:,:,1685))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1685),n2h64(1685))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1686),h0tab(:,1686),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1686),heltab2x128(:,:,1686))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1686),n2h64(1686))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1687),h0tab(:,1687),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1687),heltab2x128(:,:,1687))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1687),n2h64(1687))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1688),h0tab(:,1688),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1688),heltab2x128(:,:,1688))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1688),n2h64(1688))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1689),h0tab(:,1689),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1689),heltab2x128(:,:,1689))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1689),n2h64(1689))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1690),h0tab(:,1690),[64,1,32,16,8,2,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1690),heltab2x128(:,:,1690))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1690),n2h64(1690))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1691),h0tab(:,1691),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1691),heltab2x128(:,:,1691))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1691),n2h64(1691))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1692),h0tab(:,1692),[64,1,32,16,8,2,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1692),heltab2x128(:,:,1692))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1692),n2h64(1692))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1693),h0tab(:,1693),[64,1,32,16,8,2,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1693),heltab2x128(:,:,1693))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1693),n2h64(1693))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1694),h0tab(:,1694),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1694),heltab2x128(:,:,1694))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1694),n2h64(1694))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1695),h0tab(:,1695),[64,1,32,16,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1695),heltab2x128(:,:,1695))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1695),n2h64(1695))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1696),h0tab(:,1696),[64,1,32,16,8,2,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1696),heltab2x128(:,:,1696))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1696),n2h64(1696))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1697),h0tab(:,1697),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1697),heltab2x128(:,:,1697))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1697),n2h64(1697))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1698),h0tab(:,1698),[64,1,32,16,8,2,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1698),heltab2x128(:,:,1698))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1698),n2h64(1698))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1699),h0tab(:,1699),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1699),heltab2x128(:,:,1699))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1699),n2h64(1699))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1700),h0tab(:,1700),[64,1,32,16,8,2,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1700),heltab2x128(:,:,1700))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1700),n2h64(1700))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1701),h0tab(:,1701),[64,1,32,16,8,2,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1701),heltab2x128(:,:,1701))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1701),n2h64(1701))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1702),h0tab(:,1702),[64,1,32,16,8,2,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1702),heltab2x128(:,:,1702))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1702),n2h64(1702))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1703),h0tab(:,1703),[64,1,32,16,2,4,8],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1703),heltab2x128(:,:,1703))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1703),n2h64(1703))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1704),h0tab(:,1704),[64,1,32,16,2,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1704),heltab2x128(:,:,1704))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1704),n2h64(1704))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1705),h0tab(:,1705),[64,1,32,16,2,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1705),heltab2x128(:,:,1705))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1705),n2h64(1705))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1706),h0tab(:,1706),[64,1,32,16,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1706),heltab2x128(:,:,1706))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1706),n2h64(1706))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1707),h0tab(:,1707),[64,1,32,16,2,4,8],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1707),heltab2x128(:,:,1707))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1707),n2h64(1707))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1708),h0tab(:,1708),[64,1,32,16,2,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1708),heltab2x128(:,:,1708))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1708),n2h64(1708))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1709),h0tab(:,1709),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1709),heltab2x128(:,:,1709))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1709),n2h64(1709))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1710),h0tab(:,1710),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1710),heltab2x128(:,:,1710))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1710),n2h64(1710))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1711),h0tab(:,1711),[64,1,32,16,2,4,8],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1711),heltab2x128(:,:,1711))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1711),n2h64(1711))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1712),h0tab(:,1712),[64,1,32,16,2,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1712),heltab2x128(:,:,1712))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1712),n2h64(1712))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1713),h0tab(:,1713),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1713),heltab2x128(:,:,1713))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1713),n2h64(1713))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1714),h0tab(:,1714),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1714),heltab2x128(:,:,1714))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1714),n2h64(1714))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1715),h0tab(:,1715),[64,1,32,16,2,4,8],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1715),heltab2x128(:,:,1715))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1715),n2h64(1715))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1716),h0tab(:,1716),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1716),heltab2x128(:,:,1716))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1716),n2h64(1716))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1717),h0tab(:,1717),[64,1,32,16,2,4,8],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1717),heltab2x128(:,:,1717))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1717),n2h64(1717))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1718),h0tab(:,1718),[64,1,32,16,2,4,8],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1718),heltab2x128(:,:,1718))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1718),n2h64(1718))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1719),h0tab(:,1719),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1719),heltab2x128(:,:,1719))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1719),n2h64(1719))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1720),h0tab(:,1720),[64,1,32,16,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1720),heltab2x128(:,:,1720))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1720),n2h64(1720))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1721),h0tab(:,1721),[64,1,32,16,2,4,8],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1721),heltab2x128(:,:,1721))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1721),n2h64(1721))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1722),h0tab(:,1722),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1722),heltab2x128(:,:,1722))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1722),n2h64(1722))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1723),h0tab(:,1723),[64,1,32,16,2,4,8],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1723),heltab2x128(:,:,1723))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1723),n2h64(1723))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1724),h0tab(:,1724),[64,1,32,16,2,4,8],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1724),heltab2x128(:,:,1724))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1724),n2h64(1724))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1725),h0tab(:,1725),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1725),heltab2x128(:,:,1725))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1725),n2h64(1725))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1726),h0tab(:,1726),[64,1,32,16,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1726),heltab2x128(:,:,1726))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1726),n2h64(1726))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1727),h0tab(:,1727),[64,1,32,16,2,4,8],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1727),heltab2x128(:,:,1727))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1727),n2h64(1727))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1728),h0tab(:,1728),[64,1,32,16,2,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1728),heltab2x128(:,:,1728))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1728),n2h64(1728))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1729),h0tab(:,1729),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1729),heltab2x128(:,:,1729))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1729),n2h64(1729))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1730),h0tab(:,1730),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1730),heltab2x128(:,:,1730))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1730),n2h64(1730))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1731),h0tab(:,1731),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1731),heltab2x128(:,:,1731))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1731),n2h64(1731))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1732),h0tab(:,1732),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1732),heltab2x128(:,:,1732))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1732),n2h64(1732))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1733),h0tab(:,1733),[64,1,32,16,2,4,8],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1733),heltab2x128(:,:,1733))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1733),n2h64(1733))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1734),h0tab(:,1734),[64,1,32,16,2,4,8],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1734),heltab2x128(:,:,1734))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1734),n2h64(1734))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1735),h0tab(:,1735),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1735),heltab2x128(:,:,1735))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1735),n2h64(1735))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1736),h0tab(:,1736),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1736),heltab2x128(:,:,1736))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1736),n2h64(1736))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1737),h0tab(:,1737),[64,1,32,16,2,4,8],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1737),heltab2x128(:,:,1737))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1737),n2h64(1737))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1738),h0tab(:,1738),[64,1,32,16,2,4,8],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1738),heltab2x128(:,:,1738))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1738),n2h64(1738))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1739),h0tab(:,1739),[64,1,32,16,2,4,8],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1739),heltab2x128(:,:,1739))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1739),n2h64(1739))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1740),h0tab(:,1740),[64,1,32,16,2,8,4],[nME,nMH,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1740),heltab2x128(:,:,1740))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1740),n2h64(1740))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1741),h0tab(:,1741),[64,1,32,16,2,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1741),heltab2x128(:,:,1741))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1741),n2h64(1741))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1742),h0tab(:,1742),[64,1,32,16,2,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1742),heltab2x128(:,:,1742))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1742),n2h64(1742))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1743),h0tab(:,1743),[64,1,32,16,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1743),heltab2x128(:,:,1743))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1743),n2h64(1743))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1744),h0tab(:,1744),[64,1,32,16,2,8,4],[nME,nMH,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1744),heltab2x128(:,:,1744))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1744),n2h64(1744))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1745),h0tab(:,1745),[64,1,32,16,2,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1745),heltab2x128(:,:,1745))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1745),n2h64(1745))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1746),h0tab(:,1746),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1746),heltab2x128(:,:,1746))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1746),n2h64(1746))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1747),h0tab(:,1747),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1747),heltab2x128(:,:,1747))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1747),n2h64(1747))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1748),h0tab(:,1748),[64,1,32,16,2,8,4],[nME,0,nMM,nMH,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1748),heltab2x128(:,:,1748))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1748),n2h64(1748))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1749),h0tab(:,1749),[64,1,32,16,2,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1749),heltab2x128(:,:,1749))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1749),n2h64(1749))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1750),h0tab(:,1750),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1750),heltab2x128(:,:,1750))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1750),n2h64(1750))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1751),h0tab(:,1751),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1751),heltab2x128(:,:,1751))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1751),n2h64(1751))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1752),h0tab(:,1752),[64,1,32,16,2,8,4],[nME,nMH,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1752),heltab2x128(:,:,1752))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1752),n2h64(1752))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1753),h0tab(:,1753),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1753),heltab2x128(:,:,1753))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1753),n2h64(1753))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1754),h0tab(:,1754),[64,1,32,16,2,8,4],[nME,nMH,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1754),heltab2x128(:,:,1754))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1754),n2h64(1754))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1755),h0tab(:,1755),[64,1,32,16,2,8,4],[nME,nMH,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1755),heltab2x128(:,:,1755))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1755),n2h64(1755))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1756),h0tab(:,1756),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1756),heltab2x128(:,:,1756))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1756),n2h64(1756))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1757),h0tab(:,1757),[64,1,32,16,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1757),heltab2x128(:,:,1757))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1757),n2h64(1757))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1758),h0tab(:,1758),[64,1,32,16,2,8,4],[nME,0,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1758),heltab2x128(:,:,1758))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1758),n2h64(1758))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1759),h0tab(:,1759),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1759),heltab2x128(:,:,1759))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1759),n2h64(1759))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1760),h0tab(:,1760),[64,1,32,16,2,8,4],[nME,0,nMM,nMH,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1760),heltab2x128(:,:,1760))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1760),n2h64(1760))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1761),h0tab(:,1761),[64,1,32,16,2,8,4],[nME,nMZ,nMM,nMH,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1761),heltab2x128(:,:,1761))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1761),n2h64(1761))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1762),h0tab(:,1762),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1762),heltab2x128(:,:,1762))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1762),n2h64(1762))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1763),h0tab(:,1763),[64,1,32,16,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1763),heltab2x128(:,:,1763))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1763),n2h64(1763))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1764),h0tab(:,1764),[64,1,32,16,2,8,4],[nME,0,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1764),heltab2x128(:,:,1764))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1764),n2h64(1764))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1765),h0tab(:,1765),[64,1,32,16,2,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1765),heltab2x128(:,:,1765))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1765),n2h64(1765))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1766),h0tab(:,1766),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1766),heltab2x128(:,:,1766))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1766),n2h64(1766))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1767),h0tab(:,1767),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,nMH,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1767),heltab2x128(:,:,1767))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1767),n2h64(1767))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1768),h0tab(:,1768),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1768),heltab2x128(:,:,1768))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1768),n2h64(1768))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1769),h0tab(:,1769),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1769),heltab2x128(:,:,1769))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1769),n2h64(1769))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1770),h0tab(:,1770),[64,1,32,16,2,8,4],[nME,0,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1770),heltab2x128(:,:,1770))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1770),n2h64(1770))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1771),h0tab(:,1771),[64,1,32,16,2,8,4],[nME,0,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1771),heltab2x128(:,:,1771))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1771),n2h64(1771))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1772),h0tab(:,1772),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1772),heltab2x128(:,:,1772))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1772),n2h64(1772))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1773),h0tab(:,1773),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1773),heltab2x128(:,:,1773))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1773),n2h64(1773))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1774),h0tab(:,1774),[64,1,32,16,2,8,4],[nME,0,nMM,nMZ,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1774),heltab2x128(:,:,1774))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1774),n2h64(1774))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1775),h0tab(:,1775),[64,1,32,16,2,8,4],[nME,nMZ,nMM,0,nME,nMZ,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1775),heltab2x128(:,:,1775))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1775),n2h64(1775))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1776),h0tab(:,1776),[64,1,32,16,2,8,4],[nME,nMZ,nMM,nMZ,nME,0,nME],7,0)
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1776),heltab2x128(:,:,1776))
  call Hloop_A_Q(ntryL,G0H64(1),64,nME,G1H64(1776),n2h64(1776))
  call Hloop_AQ_S(ntryL,G1H64(1),ex5(:),G1H32(1),ngH,m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_AQ_S(ntryL,G1H64(2),ex5(:),G1H32(2),ngX,m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_AQ_S(ntryL,G1H64(3),ex5(:),G1H32(3),ngH,m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_AQ_S(ntryL,G1H64(4),ex5(:),G1H32(4),ngX,m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_AQ_V(ntryL,G1H64(5),ex5(:),G1H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_AQ_V(ntryL,G1H64(6),ex5(:),G1H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_AQ_V(ntryL,G1H64(7),ex5(:),G1H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_AQ_V(ntryL,G1H64(8),ex5(:),G1H32(8),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_AQ_S(ntryL,G1H64(9),ex5(:),G1H32(9),ngH,m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_AQ_S(ntryL,G1H64(10),ex5(:),G1H32(10),ngH,m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_AQ_S(ntryL,G1H64(11),ex5(:),G1H32(11),ngX,m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_AQ_S(ntryL,G1H64(12),ex5(:),G1H32(12),ngX,m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_AQ_V(ntryL,G1H64(13),ex5(:),G1H32(13),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_AQ_V(ntryL,G1H64(14),ex5(:),G1H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_AQ_V(ntryL,G1H64(15),ex5(:),G1H32(15),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H64(16),ex5(:),G1H32(16),ngZl,m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_AQ_V(ntryL,G1H64(17),ex5(:),G1H32(17),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H64(18),ex5(:),G1H32(18),ngZl,m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_AQ_S(ntryL,G1H64(19),ex5(:),G1H32(19),ngH,m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_AQ_S(ntryL,G1H64(20),ex5(:),G1H32(20),ngX,m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_AQ_S(ntryL,G1H64(21),ex5(:),G1H32(21),ngH,m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_AQ_S(ntryL,G1H64(22),ex5(:),G1H32(22),ngH,m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_AQ_S(ntryL,G1H64(23),ex5(:),G1H32(23),ngX,m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_AQ_S(ntryL,G1H64(24),ex5(:),G1H32(24),ngX,m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_AQ_V(ntryL,G1H64(25),ex5(:),G1H32(25),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_AQ_V(ntryL,G1H64(26),ex5(:),G1H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H64(27),ex5(:),G1H32(27),ngZl,m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_AQ_V(ntryL,G1H64(28),ex5(:),G1H32(28),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H64(29),ex5(:),G1H32(29),ngZl,m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_AQ_V(ntryL,G1H64(30),ex5(:),G1H32(30),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_AQ_V(ntryL,G1H64(31),ex5(:),G1H32(31),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_AQ_V(ntryL,G1H64(32),ex5(:),G1H32(32),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_AQ_Z(ntryL,G1H64(33),ex5(:),G1H32(33),ngZl,m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_AQ_V(ntryL,G1H64(34),ex5(:),G1H32(34),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H64(35),ex5(:),G1H32(35),ngZl,m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_AQ_V(ntryL,G1H64(36),ex5(:),G1H32(36),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H64(37),ex5(:),G1H32(37),ngZl,m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_AQ_V(ntryL,G1H64(38),ex5(:),G1H32(38),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_AQ_V(ntryL,G1H64(39),ex5(:),G1H32(39),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_AQ_V(ntryL,G1H64(40),ex5(:),G1H32(40),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_AQ_V(ntryL,G1H64(41),ex5(:),G1H32(41),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_AQ_S(ntryL,G1H64(42),ex5(:),G1H32(42),ngH,m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_AQ_S(ntryL,G1H64(43),ex5(:),G1H32(43),ngX,m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_AQ_S(ntryL,G1H64(44),ex5(:),G1H32(44),ngH,m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_AQ_S(ntryL,G1H64(45),ex5(:),G1H32(45),ngX,m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_AQ_S(ntryL,G1H64(46),ex5(:),G1H32(46),ngH,m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_AQ_S(ntryL,G1H64(47),ex5(:),G1H32(47),ngX,m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_AQ_S(ntryL,G1H64(48),ex5(:),G1H32(48),ngH,m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_AQ_S(ntryL,G1H64(49),ex5(:),G1H32(49),ngX,m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_AQ_V(ntryL,G1H64(50),ex5(:),G1H32(50),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_AQ_V(ntryL,G1H64(51),ex5(:),G1H32(51),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_AQ_Z(ntryL,G1H64(52),ex5(:),G1H32(52),ngZl,m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_AQ_V(ntryL,G1H64(53),ex5(:),G1H32(53),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H64(54),ex5(:),G1H32(54),ngZl,m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_AQ_V(ntryL,G1H64(55),ex5(:),G1H32(55),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_AQ_V(ntryL,G1H64(56),ex5(:),G1H32(56),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_AQ_V(ntryL,G1H64(57),ex5(:),G1H32(57),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_AQ_Z(ntryL,G1H64(58),ex5(:),G1H32(58),ngZl,m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_AQ_V(ntryL,G1H64(59),ex5(:),G1H32(59),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_AQ_Z(ntryL,G1H64(60),ex5(:),G1H32(60),ngZl,m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_AQ_V(ntryL,G1H64(61),ex5(:),G1H32(61),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_AQ_S(ntryL,G1H64(62),ex5(:),G1H32(62),ngH,m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_AQ_S(ntryL,G1H64(63),ex5(:),G1H32(63),ngX,m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_AQ_S(ntryL,G1H64(64),ex5(:),G1H32(64),ngH,m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_AQ_S(ntryL,G1H64(65),ex5(:),G1H32(65),ngH,m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_AQ_S(ntryL,G1H64(66),ex5(:),G1H32(66),ngX,m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_AQ_S(ntryL,G1H64(67),ex5(:),G1H32(67),ngX,m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_AQ_V(ntryL,G1H64(68),ex5(:),G1H32(68),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H64(69),ex5(:),G1H32(69),ngZl,m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_AQ_V(ntryL,G1H64(70),ex5(:),G1H32(70),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_AQ_V(ntryL,G1H64(71),ex5(:),G1H32(71),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_AQ_Z(ntryL,G1H64(72),ex5(:),G1H32(72),ngZl,m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_AQ_Z(ntryL,G1H64(73),ex5(:),G1H32(73),ngZl,m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_AQ_V(ntryL,G1H64(74),ex5(:),G1H32(74),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_AQ_S(ntryL,G1H64(75),ex2(:),G1H32(75),ngH,m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_AQ_S(ntryL,G1H64(76),ex2(:),G1H32(76),ngH,m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_AQ_S(ntryL,G1H64(77),ex2(:),G1H32(77),ngX,m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_AQ_S(ntryL,G1H64(78),ex2(:),G1H32(78),ngX,m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_AQ_S(ntryL,G1H64(79),ex2(:),G1H32(79),ngH,m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_AQ_S(ntryL,G1H64(80),ex2(:),G1H32(80),ngH,m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_AQ_S(ntryL,G1H64(81),ex2(:),G1H32(81),ngX,m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_AQ_S(ntryL,G1H64(82),ex2(:),G1H32(82),ngX,m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_AQ_V(ntryL,G1H64(83),ex2(:),G1H32(83),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_AQ_V(ntryL,G1H64(84),ex2(:),G1H32(84),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_AQ_V(ntryL,G1H64(85),ex2(:),G1H32(85),m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_AQ_V(ntryL,G1H64(86),ex2(:),G1H32(86),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_AQ_S(ntryL,G1H64(87),ex2(:),G1H32(87),ngH,m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_AQ_S(ntryL,G1H64(88),ex2(:),G1H32(88),ngX,m3h2x32(:,88),heltab2x64(:,:,88))
  call Hloop_AQ_S(ntryL,G1H64(89),ex2(:),G1H32(89),ngH,m3h2x32(:,89),heltab2x64(:,:,89))
  call Hloop_AQ_S(ntryL,G1H64(90),ex2(:),G1H32(90),ngH,m3h2x32(:,90),heltab2x64(:,:,90))
  call Hloop_AQ_S(ntryL,G1H64(91),ex2(:),G1H32(91),ngX,m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_AQ_S(ntryL,G1H64(92),ex2(:),G1H32(92),ngX,m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_AQ_V(ntryL,G1H64(93),ex2(:),G1H32(93),m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_AQ_V(ntryL,G1H64(94),ex2(:),G1H32(94),m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_AQ_V(ntryL,G1H64(95),ex2(:),G1H32(95),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_AQ_Z(ntryL,G1H64(96),ex2(:),G1H32(96),ngZl,m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_AQ_V(ntryL,G1H64(97),ex2(:),G1H32(97),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_AQ_Z(ntryL,G1H64(98),ex2(:),G1H32(98),ngZl,m3h2x32(:,98),heltab2x64(:,:,98))
  call Hloop_AQ_V(ntryL,G1H64(99),ex2(:),G1H32(99),m3h2x32(:,99),heltab2x64(:,:,99))
  call Hloop_AQ_V(ntryL,G1H64(100),ex2(:),G1H32(100),m3h2x32(:,100),heltab2x64(:,:,100))
  call Hloop_AQ_V(ntryL,G1H64(101),ex2(:),G1H32(101),m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H64(102),ex2(:),G1H32(102),ngZl,m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_AQ_V(ntryL,G1H64(103),ex2(:),G1H32(103),m3h2x32(:,103),heltab2x64(:,:,103))
  call Hloop_AQ_Z(ntryL,G1H64(104),ex2(:),G1H32(104),ngZl,m3h2x32(:,104),heltab2x64(:,:,104))
  call Hloop_AQ_V(ntryL,G1H64(105),ex2(:),G1H32(105),m3h2x32(:,105),heltab2x64(:,:,105))
  call Hloop_AQ_V(ntryL,G1H64(106),ex2(:),G1H32(106),m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_AQ_V(ntryL,G1H64(107),ex2(:),G1H32(107),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_AQ_Z(ntryL,G1H64(108),ex2(:),G1H32(108),ngZl,m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_AQ_V(ntryL,G1H64(109),ex2(:),G1H32(109),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_AQ_Z(ntryL,G1H64(110),ex2(:),G1H32(110),ngZl,m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_AQ_Z(ntryL,G1H64(111),ex2(:),G1H32(111),ngZl,m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_AQ_S(ntryL,G1H64(112),ex2(:),G1H32(112),ngH,m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_AQ_S(ntryL,G1H64(113),ex2(:),G1H32(113),ngH,m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_AQ_S(ntryL,G1H64(114),ex2(:),G1H32(114),ngX,m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_AQ_S(ntryL,G1H64(115),ex2(:),G1H32(115),ngX,m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_AQ_S(ntryL,G1H64(116),ex2(:),G1H32(116),ngH,m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_AQ_S(ntryL,G1H64(117),ex2(:),G1H32(117),ngH,m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_AQ_S(ntryL,G1H64(118),ex2(:),G1H32(118),ngX,m3h2x32(:,118),heltab2x64(:,:,118))
  call Hloop_AQ_S(ntryL,G1H64(119),ex2(:),G1H32(119),ngX,m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_AQ_V(ntryL,G1H64(120),ex2(:),G1H32(120),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_AQ_V(ntryL,G1H64(121),ex2(:),G1H32(121),m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_AQ_V(ntryL,G1H64(122),ex2(:),G1H32(122),m3h2x32(:,122),heltab2x64(:,:,122))
  call Hloop_AQ_V(ntryL,G1H64(123),ex2(:),G1H32(123),m3h2x32(:,123),heltab2x64(:,:,123))
  call Hloop_AQ_S(ntryL,G1H64(124),ex2(:),G1H32(124),ngH,m3h2x32(:,124),heltab2x64(:,:,124))
  call Hloop_AQ_S(ntryL,G1H64(125),ex2(:),G1H32(125),ngX,m3h2x32(:,125),heltab2x64(:,:,125))
  call Hloop_AQ_S(ntryL,G1H64(126),ex2(:),G1H32(126),ngH,m3h2x32(:,126),heltab2x64(:,:,126))
  call Hloop_AQ_S(ntryL,G1H64(127),ex2(:),G1H32(127),ngH,m3h2x32(:,127),heltab2x64(:,:,127))
  call Hloop_AQ_S(ntryL,G1H64(128),ex2(:),G1H32(128),ngX,m3h2x32(:,128),heltab2x64(:,:,128))
  call Hloop_AQ_S(ntryL,G1H64(129),ex2(:),G1H32(129),ngX,m3h2x32(:,129),heltab2x64(:,:,129))
  call Hloop_AQ_V(ntryL,G1H64(130),ex2(:),G1H32(130),m3h2x32(:,130),heltab2x64(:,:,130))
  call Hloop_AQ_V(ntryL,G1H64(131),ex2(:),G1H32(131),m3h2x32(:,131),heltab2x64(:,:,131))
  call Hloop_AQ_V(ntryL,G1H64(132),ex2(:),G1H32(132),m3h2x32(:,132),heltab2x64(:,:,132))
  call Hloop_AQ_Z(ntryL,G1H64(133),ex2(:),G1H32(133),ngZl,m3h2x32(:,133),heltab2x64(:,:,133))
  call Hloop_AQ_V(ntryL,G1H64(134),ex2(:),G1H32(134),m3h2x32(:,134),heltab2x64(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H64(135),ex2(:),G1H32(135),ngZl,m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_AQ_V(ntryL,G1H64(136),ex2(:),G1H32(136),m3h2x32(:,136),heltab2x64(:,:,136))
  call Hloop_AQ_V(ntryL,G1H64(137),ex2(:),G1H32(137),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_AQ_V(ntryL,G1H64(138),ex2(:),G1H32(138),m3h2x32(:,138),heltab2x64(:,:,138))
  call Hloop_AQ_Z(ntryL,G1H64(139),ex2(:),G1H32(139),ngZl,m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_AQ_V(ntryL,G1H64(140),ex2(:),G1H32(140),m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_AQ_Z(ntryL,G1H64(141),ex2(:),G1H32(141),ngZl,m3h2x32(:,141),heltab2x64(:,:,141))
  call Hloop_AQ_V(ntryL,G1H64(142),ex2(:),G1H32(142),m3h2x32(:,142),heltab2x64(:,:,142))
  call Hloop_AQ_V(ntryL,G1H64(143),ex2(:),G1H32(143),m3h2x32(:,143),heltab2x64(:,:,143))
  call Hloop_AQ_V(ntryL,G1H64(144),ex2(:),G1H32(144),m3h2x32(:,144),heltab2x64(:,:,144))
  call Hloop_AQ_Z(ntryL,G1H64(145),ex2(:),G1H32(145),ngZl,m3h2x32(:,145),heltab2x64(:,:,145))
  call Hloop_AQ_V(ntryL,G1H64(146),ex2(:),G1H32(146),m3h2x32(:,146),heltab2x64(:,:,146))
  call Hloop_AQ_Z(ntryL,G1H64(147),ex2(:),G1H32(147),ngZl,m3h2x32(:,147),heltab2x64(:,:,147))
  call Hloop_AQ_Z(ntryL,G1H64(148),ex2(:),G1H32(148),ngZl,m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_AQ_S(ntryL,G1H64(149),ex5(:),G1H32(149),ngH,m3h2x32(:,149),heltab2x64(:,:,149))
  call Hloop_AQ_S(ntryL,G1H64(150),ex5(:),G1H32(150),ngX,m3h2x32(:,150),heltab2x64(:,:,150))
  call Hloop_AQ_S(ntryL,G1H64(151),ex5(:),G1H32(151),ngH,m3h2x32(:,151),heltab2x64(:,:,151))
  call Hloop_AQ_S(ntryL,G1H64(152),ex5(:),G1H32(152),ngX,m3h2x32(:,152),heltab2x64(:,:,152))
  call Hloop_AQ_V(ntryL,G1H64(153),ex5(:),G1H32(153),m3h2x32(:,153),heltab2x64(:,:,153))
  call Hloop_AQ_V(ntryL,G1H64(154),ex5(:),G1H32(154),m3h2x32(:,154),heltab2x64(:,:,154))
  call Hloop_AQ_V(ntryL,G1H64(155),ex5(:),G1H32(155),m3h2x32(:,155),heltab2x64(:,:,155))
  call Hloop_AQ_V(ntryL,G1H64(156),ex5(:),G1H32(156),m3h2x32(:,156),heltab2x64(:,:,156))
  call Hloop_AQ_S(ntryL,G1H64(157),ex5(:),G1H32(157),ngH,m3h2x32(:,157),heltab2x64(:,:,157))
  call Hloop_AQ_S(ntryL,G1H64(158),ex5(:),G1H32(158),ngH,m3h2x32(:,158),heltab2x64(:,:,158))
  call Hloop_AQ_S(ntryL,G1H64(159),ex5(:),G1H32(159),ngX,m3h2x32(:,159),heltab2x64(:,:,159))
  call Hloop_AQ_S(ntryL,G1H64(160),ex5(:),G1H32(160),ngX,m3h2x32(:,160),heltab2x64(:,:,160))
  call Hloop_AQ_V(ntryL,G1H64(161),ex5(:),G1H32(161),m3h2x32(:,161),heltab2x64(:,:,161))
  call Hloop_AQ_V(ntryL,G1H64(162),ex5(:),G1H32(162),m3h2x32(:,162),heltab2x64(:,:,162))
  call Hloop_AQ_V(ntryL,G1H64(163),ex5(:),G1H32(163),m3h2x32(:,163),heltab2x64(:,:,163))
  call Hloop_AQ_Z(ntryL,G1H64(164),ex5(:),G1H32(164),ngZl,m3h2x32(:,164),heltab2x64(:,:,164))
  call Hloop_AQ_V(ntryL,G1H64(165),ex5(:),G1H32(165),m3h2x32(:,165),heltab2x64(:,:,165))
  call Hloop_AQ_Z(ntryL,G1H64(166),ex5(:),G1H32(166),ngZl,m3h2x32(:,166),heltab2x64(:,:,166))
  call Hloop_AQ_S(ntryL,G1H64(167),ex5(:),G1H32(167),ngH,m3h2x32(:,167),heltab2x64(:,:,167))
  call Hloop_AQ_S(ntryL,G1H64(168),ex5(:),G1H32(168),ngX,m3h2x32(:,168),heltab2x64(:,:,168))
  call Hloop_AQ_S(ntryL,G1H64(169),ex5(:),G1H32(169),ngH,m3h2x32(:,169),heltab2x64(:,:,169))
  call Hloop_AQ_S(ntryL,G1H64(170),ex5(:),G1H32(170),ngH,m3h2x32(:,170),heltab2x64(:,:,170))
  call Hloop_AQ_S(ntryL,G1H64(171),ex5(:),G1H32(171),ngX,m3h2x32(:,171),heltab2x64(:,:,171))
  call Hloop_AQ_S(ntryL,G1H64(172),ex5(:),G1H32(172),ngX,m3h2x32(:,172),heltab2x64(:,:,172))
  call Hloop_AQ_V(ntryL,G1H64(173),ex5(:),G1H32(173),m3h2x32(:,173),heltab2x64(:,:,173))
  call Hloop_AQ_V(ntryL,G1H64(174),ex5(:),G1H32(174),m3h2x32(:,174),heltab2x64(:,:,174))
  call Hloop_AQ_Z(ntryL,G1H64(175),ex5(:),G1H32(175),ngZl,m3h2x32(:,175),heltab2x64(:,:,175))
  call Hloop_AQ_V(ntryL,G1H64(176),ex5(:),G1H32(176),m3h2x32(:,176),heltab2x64(:,:,176))
  call Hloop_AQ_Z(ntryL,G1H64(177),ex5(:),G1H32(177),ngZl,m3h2x32(:,177),heltab2x64(:,:,177))
  call Hloop_AQ_V(ntryL,G1H64(178),ex5(:),G1H32(178),m3h2x32(:,178),heltab2x64(:,:,178))
  call Hloop_AQ_V(ntryL,G1H64(179),ex5(:),G1H32(179),m3h2x32(:,179),heltab2x64(:,:,179))
  call Hloop_AQ_V(ntryL,G1H64(180),ex5(:),G1H32(180),m3h2x32(:,180),heltab2x64(:,:,180))
  call Hloop_AQ_Z(ntryL,G1H64(181),ex5(:),G1H32(181),ngZl,m3h2x32(:,181),heltab2x64(:,:,181))
  call Hloop_AQ_V(ntryL,G1H64(182),ex5(:),G1H32(182),m3h2x32(:,182),heltab2x64(:,:,182))
  call Hloop_AQ_Z(ntryL,G1H64(183),ex5(:),G1H32(183),ngZl,m3h2x32(:,183),heltab2x64(:,:,183))
  call Hloop_AQ_V(ntryL,G1H64(184),ex5(:),G1H32(184),m3h2x32(:,184),heltab2x64(:,:,184))
  call Hloop_AQ_Z(ntryL,G1H64(185),ex5(:),G1H32(185),ngZl,m3h2x32(:,185),heltab2x64(:,:,185))
  call Hloop_AQ_V(ntryL,G1H64(186),ex5(:),G1H32(186),m3h2x32(:,186),heltab2x64(:,:,186))
  call Hloop_AQ_V(ntryL,G1H64(187),ex5(:),G1H32(187),m3h2x32(:,187),heltab2x64(:,:,187))
  call Hloop_AQ_V(ntryL,G1H64(188),ex5(:),G1H32(188),m3h2x32(:,188),heltab2x64(:,:,188))
  call Hloop_AQ_V(ntryL,G1H64(189),ex5(:),G1H32(189),m3h2x32(:,189),heltab2x64(:,:,189))
  call Hloop_AQ_S(ntryL,G1H64(190),ex5(:),G1H32(190),ngH,m3h2x32(:,190),heltab2x64(:,:,190))
  call Hloop_AQ_S(ntryL,G1H64(191),ex5(:),G1H32(191),ngX,m3h2x32(:,191),heltab2x64(:,:,191))
  call Hloop_AQ_S(ntryL,G1H64(192),ex5(:),G1H32(192),ngH,m3h2x32(:,192),heltab2x64(:,:,192))
  call Hloop_AQ_S(ntryL,G1H64(193),ex5(:),G1H32(193),ngX,m3h2x32(:,193),heltab2x64(:,:,193))
  call Hloop_AQ_S(ntryL,G1H64(194),ex5(:),G1H32(194),ngH,m3h2x32(:,194),heltab2x64(:,:,194))
  call Hloop_AQ_S(ntryL,G1H64(195),ex5(:),G1H32(195),ngX,m3h2x32(:,195),heltab2x64(:,:,195))
  call Hloop_AQ_S(ntryL,G1H64(196),ex5(:),G1H32(196),ngH,m3h2x32(:,196),heltab2x64(:,:,196))
  call Hloop_AQ_S(ntryL,G1H64(197),ex5(:),G1H32(197),ngX,m3h2x32(:,197),heltab2x64(:,:,197))
  call Hloop_AQ_V(ntryL,G1H64(198),ex5(:),G1H32(198),m3h2x32(:,198),heltab2x64(:,:,198))
  call Hloop_AQ_V(ntryL,G1H64(199),ex5(:),G1H32(199),m3h2x32(:,199),heltab2x64(:,:,199))
  call Hloop_AQ_Z(ntryL,G1H64(200),ex5(:),G1H32(200),ngZl,m3h2x32(:,200),heltab2x64(:,:,200))
  call Hloop_AQ_V(ntryL,G1H64(201),ex5(:),G1H32(201),m3h2x32(:,201),heltab2x64(:,:,201))
  call Hloop_AQ_Z(ntryL,G1H64(202),ex5(:),G1H32(202),ngZl,m3h2x32(:,202),heltab2x64(:,:,202))
  call Hloop_AQ_V(ntryL,G1H64(203),ex5(:),G1H32(203),m3h2x32(:,203),heltab2x64(:,:,203))
  call Hloop_AQ_V(ntryL,G1H64(204),ex5(:),G1H32(204),m3h2x32(:,204),heltab2x64(:,:,204))
  call Hloop_AQ_V(ntryL,G1H64(205),ex5(:),G1H32(205),m3h2x32(:,205),heltab2x64(:,:,205))
  call Hloop_AQ_Z(ntryL,G1H64(206),ex5(:),G1H32(206),ngZl,m3h2x32(:,206),heltab2x64(:,:,206))
  call Hloop_AQ_V(ntryL,G1H64(207),ex5(:),G1H32(207),m3h2x32(:,207),heltab2x64(:,:,207))
  call Hloop_AQ_Z(ntryL,G1H64(208),ex5(:),G1H32(208),ngZl,m3h2x32(:,208),heltab2x64(:,:,208))
  call Hloop_AQ_V(ntryL,G1H64(209),ex5(:),G1H32(209),m3h2x32(:,209),heltab2x64(:,:,209))
  call Hloop_AQ_S(ntryL,G1H64(210),ex5(:),G1H32(210),ngH,m3h2x32(:,210),heltab2x64(:,:,210))
  call Hloop_AQ_S(ntryL,G1H64(211),ex5(:),G1H32(211),ngX,m3h2x32(:,211),heltab2x64(:,:,211))
  call Hloop_AQ_S(ntryL,G1H64(212),ex5(:),G1H32(212),ngH,m3h2x32(:,212),heltab2x64(:,:,212))
  call Hloop_AQ_S(ntryL,G1H64(213),ex5(:),G1H32(213),ngH,m3h2x32(:,213),heltab2x64(:,:,213))
  call Hloop_AQ_S(ntryL,G1H64(214),ex5(:),G1H32(214),ngX,m3h2x32(:,214),heltab2x64(:,:,214))
  call Hloop_AQ_S(ntryL,G1H64(215),ex5(:),G1H32(215),ngX,m3h2x32(:,215),heltab2x64(:,:,215))
  call Hloop_AQ_V(ntryL,G1H64(216),ex5(:),G1H32(216),m3h2x32(:,216),heltab2x64(:,:,216))
  call Hloop_AQ_Z(ntryL,G1H64(217),ex5(:),G1H32(217),ngZl,m3h2x32(:,217),heltab2x64(:,:,217))
  call Hloop_AQ_V(ntryL,G1H64(218),ex5(:),G1H32(218),m3h2x32(:,218),heltab2x64(:,:,218))
  call Hloop_AQ_V(ntryL,G1H64(219),ex5(:),G1H32(219),m3h2x32(:,219),heltab2x64(:,:,219))
  call Hloop_AQ_Z(ntryL,G1H64(220),ex5(:),G1H32(220),ngZl,m3h2x32(:,220),heltab2x64(:,:,220))
  call Hloop_AQ_Z(ntryL,G1H64(221),ex5(:),G1H32(221),ngZl,m3h2x32(:,221),heltab2x64(:,:,221))
  call Hloop_AQ_V(ntryL,G1H64(222),ex5(:),G1H32(222),m3h2x32(:,222),heltab2x64(:,:,222))
  call Hloop_AQ_S(ntryL,G1H64(223),ex2(:),G1H32(223),ngH,m3h2x32(:,223),heltab2x64(:,:,223))
  call Hloop_AQ_S(ntryL,G1H64(224),ex2(:),G1H32(224),ngH,m3h2x32(:,224),heltab2x64(:,:,224))
  call Hloop_AQ_S(ntryL,G1H64(225),ex2(:),G1H32(225),ngX,m3h2x32(:,225),heltab2x64(:,:,225))
  call Hloop_AQ_S(ntryL,G1H64(226),ex2(:),G1H32(226),ngX,m3h2x32(:,226),heltab2x64(:,:,226))
  call Hloop_AQ_S(ntryL,G1H64(227),ex2(:),G1H32(227),ngH,m3h2x32(:,227),heltab2x64(:,:,227))
  call Hloop_AQ_S(ntryL,G1H64(228),ex2(:),G1H32(228),ngH,m3h2x32(:,228),heltab2x64(:,:,228))
  call Hloop_AQ_S(ntryL,G1H64(229),ex2(:),G1H32(229),ngX,m3h2x32(:,229),heltab2x64(:,:,229))
  call Hloop_AQ_S(ntryL,G1H64(230),ex2(:),G1H32(230),ngX,m3h2x32(:,230),heltab2x64(:,:,230))
  call Hloop_AQ_V(ntryL,G1H64(231),ex2(:),G1H32(231),m3h2x32(:,231),heltab2x64(:,:,231))
  call Hloop_AQ_V(ntryL,G1H64(232),ex2(:),G1H32(232),m3h2x32(:,232),heltab2x64(:,:,232))
  call Hloop_AQ_V(ntryL,G1H64(233),ex2(:),G1H32(233),m3h2x32(:,233),heltab2x64(:,:,233))
  call Hloop_AQ_V(ntryL,G1H64(234),ex2(:),G1H32(234),m3h2x32(:,234),heltab2x64(:,:,234))
  call Hloop_AQ_S(ntryL,G1H64(235),ex2(:),G1H32(235),ngH,m3h2x32(:,235),heltab2x64(:,:,235))
  call Hloop_AQ_S(ntryL,G1H64(236),ex2(:),G1H32(236),ngX,m3h2x32(:,236),heltab2x64(:,:,236))
  call Hloop_AQ_S(ntryL,G1H64(237),ex2(:),G1H32(237),ngH,m3h2x32(:,237),heltab2x64(:,:,237))
  call Hloop_AQ_S(ntryL,G1H64(238),ex2(:),G1H32(238),ngH,m3h2x32(:,238),heltab2x64(:,:,238))
  call Hloop_AQ_S(ntryL,G1H64(239),ex2(:),G1H32(239),ngX,m3h2x32(:,239),heltab2x64(:,:,239))
  call Hloop_AQ_S(ntryL,G1H64(240),ex2(:),G1H32(240),ngX,m3h2x32(:,240),heltab2x64(:,:,240))
  call Hloop_AQ_V(ntryL,G1H64(241),ex2(:),G1H32(241),m3h2x32(:,241),heltab2x64(:,:,241))
  call Hloop_AQ_V(ntryL,G1H64(242),ex2(:),G1H32(242),m3h2x32(:,242),heltab2x64(:,:,242))
  call Hloop_AQ_V(ntryL,G1H64(243),ex2(:),G1H32(243),m3h2x32(:,243),heltab2x64(:,:,243))
  call Hloop_AQ_Z(ntryL,G1H64(244),ex2(:),G1H32(244),ngZl,m3h2x32(:,244),heltab2x64(:,:,244))
  call Hloop_AQ_V(ntryL,G1H64(245),ex2(:),G1H32(245),m3h2x32(:,245),heltab2x64(:,:,245))
  call Hloop_AQ_Z(ntryL,G1H64(246),ex2(:),G1H32(246),ngZl,m3h2x32(:,246),heltab2x64(:,:,246))
  call Hloop_AQ_V(ntryL,G1H64(247),ex2(:),G1H32(247),m3h2x32(:,247),heltab2x64(:,:,247))
  call Hloop_AQ_V(ntryL,G1H64(248),ex2(:),G1H32(248),m3h2x32(:,248),heltab2x64(:,:,248))
  call Hloop_AQ_V(ntryL,G1H64(249),ex2(:),G1H32(249),m3h2x32(:,249),heltab2x64(:,:,249))
  call Hloop_AQ_Z(ntryL,G1H64(250),ex2(:),G1H32(250),ngZl,m3h2x32(:,250),heltab2x64(:,:,250))
  call Hloop_AQ_V(ntryL,G1H64(251),ex2(:),G1H32(251),m3h2x32(:,251),heltab2x64(:,:,251))
  call Hloop_AQ_Z(ntryL,G1H64(252),ex2(:),G1H32(252),ngZl,m3h2x32(:,252),heltab2x64(:,:,252))
  call Hloop_AQ_V(ntryL,G1H64(253),ex2(:),G1H32(253),m3h2x32(:,253),heltab2x64(:,:,253))
  call Hloop_AQ_V(ntryL,G1H64(254),ex2(:),G1H32(254),m3h2x32(:,254),heltab2x64(:,:,254))
  call Hloop_AQ_V(ntryL,G1H64(255),ex2(:),G1H32(255),m3h2x32(:,255),heltab2x64(:,:,255))
  call Hloop_AQ_Z(ntryL,G1H64(256),ex2(:),G1H32(256),ngZl,m3h2x32(:,256),heltab2x64(:,:,256))
  call Hloop_AQ_V(ntryL,G1H64(257),ex2(:),G1H32(257),m3h2x32(:,257),heltab2x64(:,:,257))
  call Hloop_AQ_Z(ntryL,G1H64(258),ex2(:),G1H32(258),ngZl,m3h2x32(:,258),heltab2x64(:,:,258))
  call Hloop_AQ_Z(ntryL,G1H64(259),ex2(:),G1H32(259),ngZl,m3h2x32(:,259),heltab2x64(:,:,259))
  call Hloop_AQ_S(ntryL,G1H64(260),ex2(:),G1H32(260),ngH,m3h2x32(:,260),heltab2x64(:,:,260))
  call Hloop_AQ_S(ntryL,G1H64(261),ex2(:),G1H32(261),ngH,m3h2x32(:,261),heltab2x64(:,:,261))
  call Hloop_AQ_S(ntryL,G1H64(262),ex2(:),G1H32(262),ngX,m3h2x32(:,262),heltab2x64(:,:,262))
  call Hloop_AQ_S(ntryL,G1H64(263),ex2(:),G1H32(263),ngX,m3h2x32(:,263),heltab2x64(:,:,263))
  call Hloop_AQ_S(ntryL,G1H64(264),ex2(:),G1H32(264),ngH,m3h2x32(:,264),heltab2x64(:,:,264))
  call Hloop_AQ_S(ntryL,G1H64(265),ex2(:),G1H32(265),ngH,m3h2x32(:,265),heltab2x64(:,:,265))
  call Hloop_AQ_S(ntryL,G1H64(266),ex2(:),G1H32(266),ngX,m3h2x32(:,266),heltab2x64(:,:,266))
  call Hloop_AQ_S(ntryL,G1H64(267),ex2(:),G1H32(267),ngX,m3h2x32(:,267),heltab2x64(:,:,267))
  call Hloop_AQ_V(ntryL,G1H64(268),ex2(:),G1H32(268),m3h2x32(:,268),heltab2x64(:,:,268))
  call Hloop_AQ_V(ntryL,G1H64(269),ex2(:),G1H32(269),m3h2x32(:,269),heltab2x64(:,:,269))
  call Hloop_AQ_V(ntryL,G1H64(270),ex2(:),G1H32(270),m3h2x32(:,270),heltab2x64(:,:,270))
  call Hloop_AQ_V(ntryL,G1H64(271),ex2(:),G1H32(271),m3h2x32(:,271),heltab2x64(:,:,271))
  call Hloop_AQ_S(ntryL,G1H64(272),ex2(:),G1H32(272),ngH,m3h2x32(:,272),heltab2x64(:,:,272))
  call Hloop_AQ_S(ntryL,G1H64(273),ex2(:),G1H32(273),ngX,m3h2x32(:,273),heltab2x64(:,:,273))
  call Hloop_AQ_S(ntryL,G1H64(274),ex2(:),G1H32(274),ngH,m3h2x32(:,274),heltab2x64(:,:,274))
  call Hloop_AQ_S(ntryL,G1H64(275),ex2(:),G1H32(275),ngH,m3h2x32(:,275),heltab2x64(:,:,275))
  call Hloop_AQ_S(ntryL,G1H64(276),ex2(:),G1H32(276),ngX,m3h2x32(:,276),heltab2x64(:,:,276))
  call Hloop_AQ_S(ntryL,G1H64(277),ex2(:),G1H32(277),ngX,m3h2x32(:,277),heltab2x64(:,:,277))
  call Hloop_AQ_V(ntryL,G1H64(278),ex2(:),G1H32(278),m3h2x32(:,278),heltab2x64(:,:,278))
  call Hloop_AQ_V(ntryL,G1H64(279),ex2(:),G1H32(279),m3h2x32(:,279),heltab2x64(:,:,279))
  call Hloop_AQ_V(ntryL,G1H64(280),ex2(:),G1H32(280),m3h2x32(:,280),heltab2x64(:,:,280))
  call Hloop_AQ_Z(ntryL,G1H64(281),ex2(:),G1H32(281),ngZl,m3h2x32(:,281),heltab2x64(:,:,281))
  call Hloop_AQ_V(ntryL,G1H64(282),ex2(:),G1H32(282),m3h2x32(:,282),heltab2x64(:,:,282))
  call Hloop_AQ_Z(ntryL,G1H64(283),ex2(:),G1H32(283),ngZl,m3h2x32(:,283),heltab2x64(:,:,283))
  call Hloop_AQ_V(ntryL,G1H64(284),ex2(:),G1H32(284),m3h2x32(:,284),heltab2x64(:,:,284))
  call Hloop_AQ_V(ntryL,G1H64(285),ex2(:),G1H32(285),m3h2x32(:,285),heltab2x64(:,:,285))
  call Hloop_AQ_V(ntryL,G1H64(286),ex2(:),G1H32(286),m3h2x32(:,286),heltab2x64(:,:,286))
  call Hloop_AQ_Z(ntryL,G1H64(287),ex2(:),G1H32(287),ngZl,m3h2x32(:,287),heltab2x64(:,:,287))
  call Hloop_AQ_V(ntryL,G1H64(288),ex2(:),G1H32(288),m3h2x32(:,288),heltab2x64(:,:,288))
  call Hloop_AQ_Z(ntryL,G1H64(289),ex2(:),G1H32(289),ngZl,m3h2x32(:,289),heltab2x64(:,:,289))
  call Hloop_AQ_V(ntryL,G1H64(290),ex2(:),G1H32(290),m3h2x32(:,290),heltab2x64(:,:,290))
  call Hloop_AQ_V(ntryL,G1H64(291),ex2(:),G1H32(291),m3h2x32(:,291),heltab2x64(:,:,291))
  call Hloop_AQ_V(ntryL,G1H64(292),ex2(:),G1H32(292),m3h2x32(:,292),heltab2x64(:,:,292))
  call Hloop_AQ_Z(ntryL,G1H64(293),ex2(:),G1H32(293),ngZl,m3h2x32(:,293),heltab2x64(:,:,293))
  call Hloop_AQ_V(ntryL,G1H64(294),ex2(:),G1H32(294),m3h2x32(:,294),heltab2x64(:,:,294))
  call Hloop_AQ_Z(ntryL,G1H64(295),ex2(:),G1H32(295),ngZl,m3h2x32(:,295),heltab2x64(:,:,295))
  call Hloop_AQ_Z(ntryL,G1H64(296),ex2(:),G1H32(296),ngZl,m3h2x32(:,296),heltab2x64(:,:,296))
  call Hloop_AQ_S(ntryL,G1H64(297),ex1(:),G1H32(297),ngH,m3h2x32(:,297),heltab2x64(:,:,297))
  call Hloop_AQ_S(ntryL,G1H64(298),ex1(:),G1H32(298),ngH,m3h2x32(:,298),heltab2x64(:,:,298))
  call Hloop_AQ_S(ntryL,G1H64(299),ex1(:),G1H32(299),ngX,m3h2x32(:,299),heltab2x64(:,:,299))
  call Hloop_AQ_S(ntryL,G1H64(300),ex1(:),G1H32(300),ngX,m3h2x32(:,300),heltab2x64(:,:,300))
  call Hloop_AQ_S(ntryL,G1H64(301),ex1(:),G1H32(301),ngH,m3h2x32(:,301),heltab2x64(:,:,301))
  call Hloop_AQ_S(ntryL,G1H64(302),ex1(:),G1H32(302),ngH,m3h2x32(:,302),heltab2x64(:,:,302))
  call Hloop_AQ_S(ntryL,G1H64(303),ex1(:),G1H32(303),ngX,m3h2x32(:,303),heltab2x64(:,:,303))
  call Hloop_AQ_S(ntryL,G1H64(304),ex1(:),G1H32(304),ngX,m3h2x32(:,304),heltab2x64(:,:,304))
  call Hloop_AQ_V(ntryL,G1H64(305),ex1(:),G1H32(305),m3h2x32(:,305),heltab2x64(:,:,305))
  call Hloop_AQ_V(ntryL,G1H64(306),ex1(:),G1H32(306),m3h2x32(:,306),heltab2x64(:,:,306))
  call Hloop_AQ_V(ntryL,G1H64(307),ex1(:),G1H32(307),m3h2x32(:,307),heltab2x64(:,:,307))
  call Hloop_AQ_V(ntryL,G1H64(308),ex1(:),G1H32(308),m3h2x32(:,308),heltab2x64(:,:,308))
  call Hloop_AQ_S(ntryL,G1H64(309),ex1(:),G1H32(309),ngH,m3h2x32(:,309),heltab2x64(:,:,309))
  call Hloop_AQ_S(ntryL,G1H64(310),ex1(:),G1H32(310),ngX,m3h2x32(:,310),heltab2x64(:,:,310))
  call Hloop_AQ_S(ntryL,G1H64(311),ex1(:),G1H32(311),ngH,m3h2x32(:,311),heltab2x64(:,:,311))
  call Hloop_AQ_S(ntryL,G1H64(312),ex1(:),G1H32(312),ngH,m3h2x32(:,312),heltab2x64(:,:,312))
  call Hloop_AQ_S(ntryL,G1H64(313),ex1(:),G1H32(313),ngX,m3h2x32(:,313),heltab2x64(:,:,313))
  call Hloop_AQ_S(ntryL,G1H64(314),ex1(:),G1H32(314),ngX,m3h2x32(:,314),heltab2x64(:,:,314))
  call Hloop_AQ_V(ntryL,G1H64(315),ex1(:),G1H32(315),m3h2x32(:,315),heltab2x64(:,:,315))
  call Hloop_AQ_V(ntryL,G1H64(316),ex1(:),G1H32(316),m3h2x32(:,316),heltab2x64(:,:,316))
  call Hloop_AQ_V(ntryL,G1H64(317),ex1(:),G1H32(317),m3h2x32(:,317),heltab2x64(:,:,317))
  call Hloop_AQ_Z(ntryL,G1H64(318),ex1(:),G1H32(318),ngZl,m3h2x32(:,318),heltab2x64(:,:,318))
  call Hloop_AQ_V(ntryL,G1H64(319),ex1(:),G1H32(319),m3h2x32(:,319),heltab2x64(:,:,319))
  call Hloop_AQ_Z(ntryL,G1H64(320),ex1(:),G1H32(320),ngZl,m3h2x32(:,320),heltab2x64(:,:,320))
  call Hloop_AQ_V(ntryL,G1H64(321),ex1(:),G1H32(321),m3h2x32(:,321),heltab2x64(:,:,321))
  call Hloop_AQ_V(ntryL,G1H64(322),ex1(:),G1H32(322),m3h2x32(:,322),heltab2x64(:,:,322))
  call Hloop_AQ_V(ntryL,G1H64(323),ex1(:),G1H32(323),m3h2x32(:,323),heltab2x64(:,:,323))
  call Hloop_AQ_Z(ntryL,G1H64(324),ex1(:),G1H32(324),ngZl,m3h2x32(:,324),heltab2x64(:,:,324))
  call Hloop_AQ_V(ntryL,G1H64(325),ex1(:),G1H32(325),m3h2x32(:,325),heltab2x64(:,:,325))
  call Hloop_AQ_Z(ntryL,G1H64(326),ex1(:),G1H32(326),ngZl,m3h2x32(:,326),heltab2x64(:,:,326))
  call Hloop_AQ_V(ntryL,G1H64(327),ex1(:),G1H32(327),m3h2x32(:,327),heltab2x64(:,:,327))
  call Hloop_AQ_V(ntryL,G1H64(328),ex1(:),G1H32(328),m3h2x32(:,328),heltab2x64(:,:,328))
  call Hloop_AQ_V(ntryL,G1H64(329),ex1(:),G1H32(329),m3h2x32(:,329),heltab2x64(:,:,329))
  call Hloop_AQ_Z(ntryL,G1H64(330),ex1(:),G1H32(330),ngZl,m3h2x32(:,330),heltab2x64(:,:,330))
  call Hloop_AQ_V(ntryL,G1H64(331),ex1(:),G1H32(331),m3h2x32(:,331),heltab2x64(:,:,331))
  call Hloop_AQ_Z(ntryL,G1H64(332),ex1(:),G1H32(332),ngZl,m3h2x32(:,332),heltab2x64(:,:,332))
  call Hloop_AQ_Z(ntryL,G1H64(333),ex1(:),G1H32(333),ngZl,m3h2x32(:,333),heltab2x64(:,:,333))
  call Hloop_AQ_S(ntryL,G1H64(334),ex1(:),G1H32(334),ngH,m3h2x32(:,334),heltab2x64(:,:,334))
  call Hloop_AQ_S(ntryL,G1H64(335),ex1(:),G1H32(335),ngH,m3h2x32(:,335),heltab2x64(:,:,335))
  call Hloop_AQ_S(ntryL,G1H64(336),ex1(:),G1H32(336),ngX,m3h2x32(:,336),heltab2x64(:,:,336))
  call Hloop_AQ_S(ntryL,G1H64(337),ex1(:),G1H32(337),ngX,m3h2x32(:,337),heltab2x64(:,:,337))
  call Hloop_AQ_S(ntryL,G1H64(338),ex1(:),G1H32(338),ngH,m3h2x32(:,338),heltab2x64(:,:,338))
  call Hloop_AQ_S(ntryL,G1H64(339),ex1(:),G1H32(339),ngH,m3h2x32(:,339),heltab2x64(:,:,339))
  call Hloop_AQ_S(ntryL,G1H64(340),ex1(:),G1H32(340),ngX,m3h2x32(:,340),heltab2x64(:,:,340))
  call Hloop_AQ_S(ntryL,G1H64(341),ex1(:),G1H32(341),ngX,m3h2x32(:,341),heltab2x64(:,:,341))
  call Hloop_AQ_V(ntryL,G1H64(342),ex1(:),G1H32(342),m3h2x32(:,342),heltab2x64(:,:,342))
  call Hloop_AQ_V(ntryL,G1H64(343),ex1(:),G1H32(343),m3h2x32(:,343),heltab2x64(:,:,343))
  call Hloop_AQ_V(ntryL,G1H64(344),ex1(:),G1H32(344),m3h2x32(:,344),heltab2x64(:,:,344))
  call Hloop_AQ_V(ntryL,G1H64(345),ex1(:),G1H32(345),m3h2x32(:,345),heltab2x64(:,:,345))
  call Hloop_AQ_S(ntryL,G1H64(346),ex1(:),G1H32(346),ngH,m3h2x32(:,346),heltab2x64(:,:,346))
  call Hloop_AQ_S(ntryL,G1H64(347),ex1(:),G1H32(347),ngX,m3h2x32(:,347),heltab2x64(:,:,347))
  call Hloop_AQ_S(ntryL,G1H64(348),ex1(:),G1H32(348),ngH,m3h2x32(:,348),heltab2x64(:,:,348))
  call Hloop_AQ_S(ntryL,G1H64(349),ex1(:),G1H32(349),ngH,m3h2x32(:,349),heltab2x64(:,:,349))
  call Hloop_AQ_S(ntryL,G1H64(350),ex1(:),G1H32(350),ngX,m3h2x32(:,350),heltab2x64(:,:,350))
  call Hloop_AQ_S(ntryL,G1H64(351),ex1(:),G1H32(351),ngX,m3h2x32(:,351),heltab2x64(:,:,351))
  call Hloop_AQ_V(ntryL,G1H64(352),ex1(:),G1H32(352),m3h2x32(:,352),heltab2x64(:,:,352))
  call Hloop_AQ_V(ntryL,G1H64(353),ex1(:),G1H32(353),m3h2x32(:,353),heltab2x64(:,:,353))
  call Hloop_AQ_V(ntryL,G1H64(354),ex1(:),G1H32(354),m3h2x32(:,354),heltab2x64(:,:,354))
  call Hloop_AQ_Z(ntryL,G1H64(355),ex1(:),G1H32(355),ngZl,m3h2x32(:,355),heltab2x64(:,:,355))
  call Hloop_AQ_V(ntryL,G1H64(356),ex1(:),G1H32(356),m3h2x32(:,356),heltab2x64(:,:,356))
  call Hloop_AQ_Z(ntryL,G1H64(357),ex1(:),G1H32(357),ngZl,m3h2x32(:,357),heltab2x64(:,:,357))
  call Hloop_AQ_V(ntryL,G1H64(358),ex1(:),G1H32(358),m3h2x32(:,358),heltab2x64(:,:,358))
  call Hloop_AQ_V(ntryL,G1H64(359),ex1(:),G1H32(359),m3h2x32(:,359),heltab2x64(:,:,359))
  call Hloop_AQ_V(ntryL,G1H64(360),ex1(:),G1H32(360),m3h2x32(:,360),heltab2x64(:,:,360))
  call Hloop_AQ_Z(ntryL,G1H64(361),ex1(:),G1H32(361),ngZl,m3h2x32(:,361),heltab2x64(:,:,361))
  call Hloop_AQ_V(ntryL,G1H64(362),ex1(:),G1H32(362),m3h2x32(:,362),heltab2x64(:,:,362))
  call Hloop_AQ_Z(ntryL,G1H64(363),ex1(:),G1H32(363),ngZl,m3h2x32(:,363),heltab2x64(:,:,363))
  call Hloop_AQ_V(ntryL,G1H64(364),ex1(:),G1H32(364),m3h2x32(:,364),heltab2x64(:,:,364))
  call Hloop_AQ_V(ntryL,G1H64(365),ex1(:),G1H32(365),m3h2x32(:,365),heltab2x64(:,:,365))
  call Hloop_AQ_V(ntryL,G1H64(366),ex1(:),G1H32(366),m3h2x32(:,366),heltab2x64(:,:,366))
  call Hloop_AQ_Z(ntryL,G1H64(367),ex1(:),G1H32(367),ngZl,m3h2x32(:,367),heltab2x64(:,:,367))
  call Hloop_AQ_V(ntryL,G1H64(368),ex1(:),G1H32(368),m3h2x32(:,368),heltab2x64(:,:,368))
  call Hloop_AQ_Z(ntryL,G1H64(369),ex1(:),G1H32(369),ngZl,m3h2x32(:,369),heltab2x64(:,:,369))
  call Hloop_AQ_Z(ntryL,G1H64(370),ex1(:),G1H32(370),ngZl,m3h2x32(:,370),heltab2x64(:,:,370))
  call Hloop_AQ_S(ntryL,G1H64(371),ex1(:),G1H32(371),ngH,m3h2x32(:,371),heltab2x64(:,:,371))
  call Hloop_AQ_S(ntryL,G1H64(372),ex1(:),G1H32(372),ngH,m3h2x32(:,372),heltab2x64(:,:,372))
  call Hloop_AQ_S(ntryL,G1H64(373),ex1(:),G1H32(373),ngX,m3h2x32(:,373),heltab2x64(:,:,373))
  call Hloop_AQ_S(ntryL,G1H64(374),ex1(:),G1H32(374),ngX,m3h2x32(:,374),heltab2x64(:,:,374))
  call Hloop_AQ_S(ntryL,G1H64(375),ex1(:),G1H32(375),ngH,m3h2x32(:,375),heltab2x64(:,:,375))
  call Hloop_AQ_S(ntryL,G1H64(376),ex1(:),G1H32(376),ngH,m3h2x32(:,376),heltab2x64(:,:,376))
  call Hloop_AQ_S(ntryL,G1H64(377),ex1(:),G1H32(377),ngX,m3h2x32(:,377),heltab2x64(:,:,377))
  call Hloop_AQ_S(ntryL,G1H64(378),ex1(:),G1H32(378),ngX,m3h2x32(:,378),heltab2x64(:,:,378))
  call Hloop_AQ_V(ntryL,G1H64(379),ex1(:),G1H32(379),m3h2x32(:,379),heltab2x64(:,:,379))
  call Hloop_AQ_V(ntryL,G1H64(380),ex1(:),G1H32(380),m3h2x32(:,380),heltab2x64(:,:,380))
  call Hloop_AQ_V(ntryL,G1H64(381),ex1(:),G1H32(381),m3h2x32(:,381),heltab2x64(:,:,381))
  call Hloop_AQ_V(ntryL,G1H64(382),ex1(:),G1H32(382),m3h2x32(:,382),heltab2x64(:,:,382))
  call Hloop_AQ_S(ntryL,G1H64(383),ex1(:),G1H32(383),ngH,m3h2x32(:,383),heltab2x64(:,:,383))
  call Hloop_AQ_S(ntryL,G1H64(384),ex1(:),G1H32(384),ngX,m3h2x32(:,384),heltab2x64(:,:,384))
  call Hloop_AQ_S(ntryL,G1H64(385),ex1(:),G1H32(385),ngH,m3h2x32(:,385),heltab2x64(:,:,385))
  call Hloop_AQ_S(ntryL,G1H64(386),ex1(:),G1H32(386),ngH,m3h2x32(:,386),heltab2x64(:,:,386))
  call Hloop_AQ_S(ntryL,G1H64(387),ex1(:),G1H32(387),ngX,m3h2x32(:,387),heltab2x64(:,:,387))
  call Hloop_AQ_S(ntryL,G1H64(388),ex1(:),G1H32(388),ngX,m3h2x32(:,388),heltab2x64(:,:,388))
  call Hloop_AQ_V(ntryL,G1H64(389),ex1(:),G1H32(389),m3h2x32(:,389),heltab2x64(:,:,389))
  call Hloop_AQ_V(ntryL,G1H64(390),ex1(:),G1H32(390),m3h2x32(:,390),heltab2x64(:,:,390))
  call Hloop_AQ_V(ntryL,G1H64(391),ex1(:),G1H32(391),m3h2x32(:,391),heltab2x64(:,:,391))
  call Hloop_AQ_Z(ntryL,G1H64(392),ex1(:),G1H32(392),ngZl,m3h2x32(:,392),heltab2x64(:,:,392))
  call Hloop_AQ_V(ntryL,G1H64(393),ex1(:),G1H32(393),m3h2x32(:,393),heltab2x64(:,:,393))
  call Hloop_AQ_Z(ntryL,G1H64(394),ex1(:),G1H32(394),ngZl,m3h2x32(:,394),heltab2x64(:,:,394))
  call Hloop_AQ_V(ntryL,G1H64(395),ex1(:),G1H32(395),m3h2x32(:,395),heltab2x64(:,:,395))
  call Hloop_AQ_V(ntryL,G1H64(396),ex1(:),G1H32(396),m3h2x32(:,396),heltab2x64(:,:,396))
  call Hloop_AQ_V(ntryL,G1H64(397),ex1(:),G1H32(397),m3h2x32(:,397),heltab2x64(:,:,397))
  call Hloop_AQ_Z(ntryL,G1H64(398),ex1(:),G1H32(398),ngZl,m3h2x32(:,398),heltab2x64(:,:,398))
  call Hloop_AQ_V(ntryL,G1H64(399),ex1(:),G1H32(399),m3h2x32(:,399),heltab2x64(:,:,399))
  call Hloop_AQ_Z(ntryL,G1H64(400),ex1(:),G1H32(400),ngZl,m3h2x32(:,400),heltab2x64(:,:,400))
  call Hloop_AQ_V(ntryL,G1H64(401),ex1(:),G1H32(401),m3h2x32(:,401),heltab2x64(:,:,401))
  call Hloop_AQ_V(ntryL,G1H64(402),ex1(:),G1H32(402),m3h2x32(:,402),heltab2x64(:,:,402))
  call Hloop_AQ_V(ntryL,G1H64(403),ex1(:),G1H32(403),m3h2x32(:,403),heltab2x64(:,:,403))
  call Hloop_AQ_Z(ntryL,G1H64(404),ex1(:),G1H32(404),ngZl,m3h2x32(:,404),heltab2x64(:,:,404))
  call Hloop_AQ_V(ntryL,G1H64(405),ex1(:),G1H32(405),m3h2x32(:,405),heltab2x64(:,:,405))
  call Hloop_AQ_Z(ntryL,G1H64(406),ex1(:),G1H32(406),ngZl,m3h2x32(:,406),heltab2x64(:,:,406))
  call Hloop_AQ_Z(ntryL,G1H64(407),ex1(:),G1H32(407),ngZl,m3h2x32(:,407),heltab2x64(:,:,407))
  call Hloop_AQ_S(ntryL,G1H64(408),ex1(:),G1H32(408),ngH,m3h2x32(:,408),heltab2x64(:,:,408))
  call Hloop_AQ_S(ntryL,G1H64(409),ex1(:),G1H32(409),ngH,m3h2x32(:,409),heltab2x64(:,:,409))
  call Hloop_AQ_S(ntryL,G1H64(410),ex1(:),G1H32(410),ngX,m3h2x32(:,410),heltab2x64(:,:,410))
  call Hloop_AQ_S(ntryL,G1H64(411),ex1(:),G1H32(411),ngX,m3h2x32(:,411),heltab2x64(:,:,411))
  call Hloop_AQ_S(ntryL,G1H64(412),ex1(:),G1H32(412),ngH,m3h2x32(:,412),heltab2x64(:,:,412))
  call Hloop_AQ_S(ntryL,G1H64(413),ex1(:),G1H32(413),ngH,m3h2x32(:,413),heltab2x64(:,:,413))
  call Hloop_AQ_S(ntryL,G1H64(414),ex1(:),G1H32(414),ngX,m3h2x32(:,414),heltab2x64(:,:,414))
  call Hloop_AQ_S(ntryL,G1H64(415),ex1(:),G1H32(415),ngX,m3h2x32(:,415),heltab2x64(:,:,415))
  call Hloop_AQ_V(ntryL,G1H64(416),ex1(:),G1H32(416),m3h2x32(:,416),heltab2x64(:,:,416))
  call Hloop_AQ_V(ntryL,G1H64(417),ex1(:),G1H32(417),m3h2x32(:,417),heltab2x64(:,:,417))
  call Hloop_AQ_V(ntryL,G1H64(418),ex1(:),G1H32(418),m3h2x32(:,418),heltab2x64(:,:,418))
  call Hloop_AQ_V(ntryL,G1H64(419),ex1(:),G1H32(419),m3h2x32(:,419),heltab2x64(:,:,419))
  call Hloop_AQ_S(ntryL,G1H64(420),ex1(:),G1H32(420),ngH,m3h2x32(:,420),heltab2x64(:,:,420))
  call Hloop_AQ_S(ntryL,G1H64(421),ex1(:),G1H32(421),ngX,m3h2x32(:,421),heltab2x64(:,:,421))
  call Hloop_AQ_S(ntryL,G1H64(422),ex1(:),G1H32(422),ngH,m3h2x32(:,422),heltab2x64(:,:,422))
  call Hloop_AQ_S(ntryL,G1H64(423),ex1(:),G1H32(423),ngH,m3h2x32(:,423),heltab2x64(:,:,423))
  call Hloop_AQ_S(ntryL,G1H64(424),ex1(:),G1H32(424),ngX,m3h2x32(:,424),heltab2x64(:,:,424))
  call Hloop_AQ_S(ntryL,G1H64(425),ex1(:),G1H32(425),ngX,m3h2x32(:,425),heltab2x64(:,:,425))
  call Hloop_AQ_V(ntryL,G1H64(426),ex1(:),G1H32(426),m3h2x32(:,426),heltab2x64(:,:,426))
  call Hloop_AQ_V(ntryL,G1H64(427),ex1(:),G1H32(427),m3h2x32(:,427),heltab2x64(:,:,427))
  call Hloop_AQ_V(ntryL,G1H64(428),ex1(:),G1H32(428),m3h2x32(:,428),heltab2x64(:,:,428))
  call Hloop_AQ_Z(ntryL,G1H64(429),ex1(:),G1H32(429),ngZl,m3h2x32(:,429),heltab2x64(:,:,429))
  call Hloop_AQ_V(ntryL,G1H64(430),ex1(:),G1H32(430),m3h2x32(:,430),heltab2x64(:,:,430))
  call Hloop_AQ_Z(ntryL,G1H64(431),ex1(:),G1H32(431),ngZl,m3h2x32(:,431),heltab2x64(:,:,431))
  call Hloop_AQ_V(ntryL,G1H64(432),ex1(:),G1H32(432),m3h2x32(:,432),heltab2x64(:,:,432))
  call Hloop_AQ_V(ntryL,G1H64(433),ex1(:),G1H32(433),m3h2x32(:,433),heltab2x64(:,:,433))
  call Hloop_AQ_V(ntryL,G1H64(434),ex1(:),G1H32(434),m3h2x32(:,434),heltab2x64(:,:,434))
  call Hloop_AQ_Z(ntryL,G1H64(435),ex1(:),G1H32(435),ngZl,m3h2x32(:,435),heltab2x64(:,:,435))
  call Hloop_AQ_V(ntryL,G1H64(436),ex1(:),G1H32(436),m3h2x32(:,436),heltab2x64(:,:,436))
  call Hloop_AQ_Z(ntryL,G1H64(437),ex1(:),G1H32(437),ngZl,m3h2x32(:,437),heltab2x64(:,:,437))
  call Hloop_AQ_V(ntryL,G1H64(438),ex1(:),G1H32(438),m3h2x32(:,438),heltab2x64(:,:,438))
  call Hloop_AQ_V(ntryL,G1H64(439),ex1(:),G1H32(439),m3h2x32(:,439),heltab2x64(:,:,439))
  call Hloop_AQ_V(ntryL,G1H64(440),ex1(:),G1H32(440),m3h2x32(:,440),heltab2x64(:,:,440))
  call Hloop_AQ_Z(ntryL,G1H64(441),ex1(:),G1H32(441),ngZl,m3h2x32(:,441),heltab2x64(:,:,441))
  call Hloop_AQ_V(ntryL,G1H64(442),ex1(:),G1H32(442),m3h2x32(:,442),heltab2x64(:,:,442))
  call Hloop_AQ_Z(ntryL,G1H64(443),ex1(:),G1H32(443),ngZl,m3h2x32(:,443),heltab2x64(:,:,443))
  call Hloop_AQ_Z(ntryL,G1H64(444),ex1(:),G1H32(444),ngZl,m3h2x32(:,444),heltab2x64(:,:,444))
  call Hloop_AQ_S(ntryL,G1H64(445),ex5(:),G1H32(445),ngH,m3h2x32(:,445),heltab2x64(:,:,445))
  call Hloop_AQ_S(ntryL,G1H64(446),ex5(:),G1H32(446),ngX,m3h2x32(:,446),heltab2x64(:,:,446))
  call Hloop_AQ_S(ntryL,G1H64(447),ex5(:),G1H32(447),ngH,m3h2x32(:,447),heltab2x64(:,:,447))
  call Hloop_AQ_S(ntryL,G1H64(448),ex5(:),G1H32(448),ngX,m3h2x32(:,448),heltab2x64(:,:,448))
  call Hloop_AQ_V(ntryL,G1H64(449),ex5(:),G1H32(449),m3h2x32(:,449),heltab2x64(:,:,449))
  call Hloop_AQ_V(ntryL,G1H64(450),ex5(:),G1H32(450),m3h2x32(:,450),heltab2x64(:,:,450))
  call Hloop_AQ_V(ntryL,G1H64(451),ex5(:),G1H32(451),m3h2x32(:,451),heltab2x64(:,:,451))
  call Hloop_AQ_V(ntryL,G1H64(452),ex5(:),G1H32(452),m3h2x32(:,452),heltab2x64(:,:,452))
  call Hloop_AQ_S(ntryL,G1H64(453),ex5(:),G1H32(453),ngH,m3h2x32(:,453),heltab2x64(:,:,453))
  call Hloop_AQ_S(ntryL,G1H64(454),ex5(:),G1H32(454),ngH,m3h2x32(:,454),heltab2x64(:,:,454))
  call Hloop_AQ_S(ntryL,G1H64(455),ex5(:),G1H32(455),ngX,m3h2x32(:,455),heltab2x64(:,:,455))
  call Hloop_AQ_S(ntryL,G1H64(456),ex5(:),G1H32(456),ngX,m3h2x32(:,456),heltab2x64(:,:,456))
  call Hloop_AQ_V(ntryL,G1H64(457),ex5(:),G1H32(457),m3h2x32(:,457),heltab2x64(:,:,457))
  call Hloop_AQ_V(ntryL,G1H64(458),ex5(:),G1H32(458),m3h2x32(:,458),heltab2x64(:,:,458))
  call Hloop_AQ_V(ntryL,G1H64(459),ex5(:),G1H32(459),m3h2x32(:,459),heltab2x64(:,:,459))
  call Hloop_AQ_Z(ntryL,G1H64(460),ex5(:),G1H32(460),ngZl,m3h2x32(:,460),heltab2x64(:,:,460))
  call Hloop_AQ_V(ntryL,G1H64(461),ex5(:),G1H32(461),m3h2x32(:,461),heltab2x64(:,:,461))
  call Hloop_AQ_Z(ntryL,G1H64(462),ex5(:),G1H32(462),ngZl,m3h2x32(:,462),heltab2x64(:,:,462))
  call Hloop_AQ_S(ntryL,G1H64(463),ex5(:),G1H32(463),ngH,m3h2x32(:,463),heltab2x64(:,:,463))
  call Hloop_AQ_S(ntryL,G1H64(464),ex5(:),G1H32(464),ngX,m3h2x32(:,464),heltab2x64(:,:,464))
  call Hloop_AQ_S(ntryL,G1H64(465),ex5(:),G1H32(465),ngH,m3h2x32(:,465),heltab2x64(:,:,465))
  call Hloop_AQ_S(ntryL,G1H64(466),ex5(:),G1H32(466),ngH,m3h2x32(:,466),heltab2x64(:,:,466))
  call Hloop_AQ_S(ntryL,G1H64(467),ex5(:),G1H32(467),ngX,m3h2x32(:,467),heltab2x64(:,:,467))
  call Hloop_AQ_S(ntryL,G1H64(468),ex5(:),G1H32(468),ngX,m3h2x32(:,468),heltab2x64(:,:,468))
  call Hloop_AQ_V(ntryL,G1H64(469),ex5(:),G1H32(469),m3h2x32(:,469),heltab2x64(:,:,469))
  call Hloop_AQ_V(ntryL,G1H64(470),ex5(:),G1H32(470),m3h2x32(:,470),heltab2x64(:,:,470))
  call Hloop_AQ_Z(ntryL,G1H64(471),ex5(:),G1H32(471),ngZl,m3h2x32(:,471),heltab2x64(:,:,471))
  call Hloop_AQ_V(ntryL,G1H64(472),ex5(:),G1H32(472),m3h2x32(:,472),heltab2x64(:,:,472))
  call Hloop_AQ_Z(ntryL,G1H64(473),ex5(:),G1H32(473),ngZl,m3h2x32(:,473),heltab2x64(:,:,473))
  call Hloop_AQ_V(ntryL,G1H64(474),ex5(:),G1H32(474),m3h2x32(:,474),heltab2x64(:,:,474))
  call Hloop_AQ_V(ntryL,G1H64(475),ex5(:),G1H32(475),m3h2x32(:,475),heltab2x64(:,:,475))
  call Hloop_AQ_V(ntryL,G1H64(476),ex5(:),G1H32(476),m3h2x32(:,476),heltab2x64(:,:,476))
  call Hloop_AQ_Z(ntryL,G1H64(477),ex5(:),G1H32(477),ngZl,m3h2x32(:,477),heltab2x64(:,:,477))
  call Hloop_AQ_V(ntryL,G1H64(478),ex5(:),G1H32(478),m3h2x32(:,478),heltab2x64(:,:,478))
  call Hloop_AQ_Z(ntryL,G1H64(479),ex5(:),G1H32(479),ngZl,m3h2x32(:,479),heltab2x64(:,:,479))
  call Hloop_AQ_V(ntryL,G1H64(480),ex5(:),G1H32(480),m3h2x32(:,480),heltab2x64(:,:,480))
  call Hloop_AQ_Z(ntryL,G1H64(481),ex5(:),G1H32(481),ngZl,m3h2x32(:,481),heltab2x64(:,:,481))
  call Hloop_AQ_V(ntryL,G1H64(482),ex5(:),G1H32(482),m3h2x32(:,482),heltab2x64(:,:,482))
  call Hloop_AQ_V(ntryL,G1H64(483),ex5(:),G1H32(483),m3h2x32(:,483),heltab2x64(:,:,483))
  call Hloop_AQ_V(ntryL,G1H64(484),ex5(:),G1H32(484),m3h2x32(:,484),heltab2x64(:,:,484))
  call Hloop_AQ_V(ntryL,G1H64(485),ex5(:),G1H32(485),m3h2x32(:,485),heltab2x64(:,:,485))
  call Hloop_AQ_S(ntryL,G1H64(486),ex5(:),G1H32(486),ngH,m3h2x32(:,486),heltab2x64(:,:,486))
  call Hloop_AQ_S(ntryL,G1H64(487),ex5(:),G1H32(487),ngX,m3h2x32(:,487),heltab2x64(:,:,487))
  call Hloop_AQ_S(ntryL,G1H64(488),ex5(:),G1H32(488),ngH,m3h2x32(:,488),heltab2x64(:,:,488))
  call Hloop_AQ_S(ntryL,G1H64(489),ex5(:),G1H32(489),ngX,m3h2x32(:,489),heltab2x64(:,:,489))
  call Hloop_AQ_S(ntryL,G1H64(490),ex5(:),G1H32(490),ngH,m3h2x32(:,490),heltab2x64(:,:,490))
  call Hloop_AQ_S(ntryL,G1H64(491),ex5(:),G1H32(491),ngX,m3h2x32(:,491),heltab2x64(:,:,491))
  call Hloop_AQ_S(ntryL,G1H64(492),ex5(:),G1H32(492),ngH,m3h2x32(:,492),heltab2x64(:,:,492))
  call Hloop_AQ_S(ntryL,G1H64(493),ex5(:),G1H32(493),ngX,m3h2x32(:,493),heltab2x64(:,:,493))
  call Hloop_AQ_V(ntryL,G1H64(494),ex5(:),G1H32(494),m3h2x32(:,494),heltab2x64(:,:,494))
  call Hloop_AQ_V(ntryL,G1H64(495),ex5(:),G1H32(495),m3h2x32(:,495),heltab2x64(:,:,495))
  call Hloop_AQ_Z(ntryL,G1H64(496),ex5(:),G1H32(496),ngZl,m3h2x32(:,496),heltab2x64(:,:,496))
  call Hloop_AQ_V(ntryL,G1H64(497),ex5(:),G1H32(497),m3h2x32(:,497),heltab2x64(:,:,497))
  call Hloop_AQ_Z(ntryL,G1H64(498),ex5(:),G1H32(498),ngZl,m3h2x32(:,498),heltab2x64(:,:,498))
  call Hloop_AQ_V(ntryL,G1H64(499),ex5(:),G1H32(499),m3h2x32(:,499),heltab2x64(:,:,499))
  call Hloop_AQ_V(ntryL,G1H64(500),ex5(:),G1H32(500),m3h2x32(:,500),heltab2x64(:,:,500))
  call Hloop_AQ_V(ntryL,G1H64(501),ex5(:),G1H32(501),m3h2x32(:,501),heltab2x64(:,:,501))
  call Hloop_AQ_Z(ntryL,G1H64(502),ex5(:),G1H32(502),ngZl,m3h2x32(:,502),heltab2x64(:,:,502))
  call Hloop_AQ_V(ntryL,G1H64(503),ex5(:),G1H32(503),m3h2x32(:,503),heltab2x64(:,:,503))
  call Hloop_AQ_Z(ntryL,G1H64(504),ex5(:),G1H32(504),ngZl,m3h2x32(:,504),heltab2x64(:,:,504))
  call Hloop_AQ_V(ntryL,G1H64(505),ex5(:),G1H32(505),m3h2x32(:,505),heltab2x64(:,:,505))
  call Hloop_AQ_S(ntryL,G1H64(506),ex5(:),G1H32(506),ngH,m3h2x32(:,506),heltab2x64(:,:,506))
  call Hloop_AQ_S(ntryL,G1H64(507),ex5(:),G1H32(507),ngX,m3h2x32(:,507),heltab2x64(:,:,507))
  call Hloop_AQ_S(ntryL,G1H64(508),ex5(:),G1H32(508),ngH,m3h2x32(:,508),heltab2x64(:,:,508))
  call Hloop_AQ_S(ntryL,G1H64(509),ex5(:),G1H32(509),ngH,m3h2x32(:,509),heltab2x64(:,:,509))
  call Hloop_AQ_S(ntryL,G1H64(510),ex5(:),G1H32(510),ngX,m3h2x32(:,510),heltab2x64(:,:,510))
  call Hloop_AQ_S(ntryL,G1H64(511),ex5(:),G1H32(511),ngX,m3h2x32(:,511),heltab2x64(:,:,511))
  call Hloop_AQ_V(ntryL,G1H64(512),ex5(:),G1H32(512),m3h2x32(:,512),heltab2x64(:,:,512))
  call Hloop_AQ_Z(ntryL,G1H64(513),ex5(:),G1H32(513),ngZl,m3h2x32(:,513),heltab2x64(:,:,513))
  call Hloop_AQ_V(ntryL,G1H64(514),ex5(:),G1H32(514),m3h2x32(:,514),heltab2x64(:,:,514))
  call Hloop_AQ_V(ntryL,G1H64(515),ex5(:),G1H32(515),m3h2x32(:,515),heltab2x64(:,:,515))
  call Hloop_AQ_Z(ntryL,G1H64(516),ex5(:),G1H32(516),ngZl,m3h2x32(:,516),heltab2x64(:,:,516))
  call Hloop_AQ_Z(ntryL,G1H64(517),ex5(:),G1H32(517),ngZl,m3h2x32(:,517),heltab2x64(:,:,517))
  call Hloop_AQ_V(ntryL,G1H64(518),ex5(:),G1H32(518),m3h2x32(:,518),heltab2x64(:,:,518))
  call Hloop_AQ_S(ntryL,G1H64(519),ex5(:),G1H32(519),ngH,m3h2x32(:,519),heltab2x64(:,:,519))
  call Hloop_AQ_S(ntryL,G1H64(520),ex5(:),G1H32(520),ngX,m3h2x32(:,520),heltab2x64(:,:,520))
  call Hloop_AQ_S(ntryL,G1H64(521),ex5(:),G1H32(521),ngH,m3h2x32(:,521),heltab2x64(:,:,521))
  call Hloop_AQ_S(ntryL,G1H64(522),ex5(:),G1H32(522),ngX,m3h2x32(:,522),heltab2x64(:,:,522))
  call Hloop_AQ_V(ntryL,G1H64(523),ex5(:),G1H32(523),m3h2x32(:,523),heltab2x64(:,:,523))
  call Hloop_AQ_V(ntryL,G1H64(524),ex5(:),G1H32(524),m3h2x32(:,524),heltab2x64(:,:,524))
  call Hloop_AQ_V(ntryL,G1H64(525),ex5(:),G1H32(525),m3h2x32(:,525),heltab2x64(:,:,525))
  call Hloop_AQ_V(ntryL,G1H64(526),ex5(:),G1H32(526),m3h2x32(:,526),heltab2x64(:,:,526))
  call Hloop_AQ_S(ntryL,G1H64(527),ex5(:),G1H32(527),ngH,m3h2x32(:,527),heltab2x64(:,:,527))
  call Hloop_AQ_S(ntryL,G1H64(528),ex5(:),G1H32(528),ngH,m3h2x32(:,528),heltab2x64(:,:,528))
  call Hloop_AQ_S(ntryL,G1H64(529),ex5(:),G1H32(529),ngX,m3h2x32(:,529),heltab2x64(:,:,529))
  call Hloop_AQ_S(ntryL,G1H64(530),ex5(:),G1H32(530),ngX,m3h2x32(:,530),heltab2x64(:,:,530))
  call Hloop_AQ_V(ntryL,G1H64(531),ex5(:),G1H32(531),m3h2x32(:,531),heltab2x64(:,:,531))
  call Hloop_AQ_V(ntryL,G1H64(532),ex5(:),G1H32(532),m3h2x32(:,532),heltab2x64(:,:,532))
  call Hloop_AQ_V(ntryL,G1H64(533),ex5(:),G1H32(533),m3h2x32(:,533),heltab2x64(:,:,533))
  call Hloop_AQ_Z(ntryL,G1H64(534),ex5(:),G1H32(534),ngZl,m3h2x32(:,534),heltab2x64(:,:,534))
  call Hloop_AQ_V(ntryL,G1H64(535),ex5(:),G1H32(535),m3h2x32(:,535),heltab2x64(:,:,535))
  call Hloop_AQ_Z(ntryL,G1H64(536),ex5(:),G1H32(536),ngZl,m3h2x32(:,536),heltab2x64(:,:,536))
  call Hloop_AQ_S(ntryL,G1H64(537),ex5(:),G1H32(537),ngH,m3h2x32(:,537),heltab2x64(:,:,537))
  call Hloop_AQ_S(ntryL,G1H64(538),ex5(:),G1H32(538),ngX,m3h2x32(:,538),heltab2x64(:,:,538))
  call Hloop_AQ_S(ntryL,G1H64(539),ex5(:),G1H32(539),ngH,m3h2x32(:,539),heltab2x64(:,:,539))
  call Hloop_AQ_S(ntryL,G1H64(540),ex5(:),G1H32(540),ngH,m3h2x32(:,540),heltab2x64(:,:,540))
  call Hloop_AQ_S(ntryL,G1H64(541),ex5(:),G1H32(541),ngX,m3h2x32(:,541),heltab2x64(:,:,541))
  call Hloop_AQ_S(ntryL,G1H64(542),ex5(:),G1H32(542),ngX,m3h2x32(:,542),heltab2x64(:,:,542))
  call Hloop_AQ_V(ntryL,G1H64(543),ex5(:),G1H32(543),m3h2x32(:,543),heltab2x64(:,:,543))
  call Hloop_AQ_V(ntryL,G1H64(544),ex5(:),G1H32(544),m3h2x32(:,544),heltab2x64(:,:,544))
  call Hloop_AQ_Z(ntryL,G1H64(545),ex5(:),G1H32(545),ngZl,m3h2x32(:,545),heltab2x64(:,:,545))
  call Hloop_AQ_V(ntryL,G1H64(546),ex5(:),G1H32(546),m3h2x32(:,546),heltab2x64(:,:,546))
  call Hloop_AQ_Z(ntryL,G1H64(547),ex5(:),G1H32(547),ngZl,m3h2x32(:,547),heltab2x64(:,:,547))
  call Hloop_AQ_V(ntryL,G1H64(548),ex5(:),G1H32(548),m3h2x32(:,548),heltab2x64(:,:,548))
  call Hloop_AQ_V(ntryL,G1H64(549),ex5(:),G1H32(549),m3h2x32(:,549),heltab2x64(:,:,549))
  call Hloop_AQ_V(ntryL,G1H64(550),ex5(:),G1H32(550),m3h2x32(:,550),heltab2x64(:,:,550))
  call Hloop_AQ_Z(ntryL,G1H64(551),ex5(:),G1H32(551),ngZl,m3h2x32(:,551),heltab2x64(:,:,551))
  call Hloop_AQ_V(ntryL,G1H64(552),ex5(:),G1H32(552),m3h2x32(:,552),heltab2x64(:,:,552))
  call Hloop_AQ_Z(ntryL,G1H64(553),ex5(:),G1H32(553),ngZl,m3h2x32(:,553),heltab2x64(:,:,553))
  call Hloop_AQ_V(ntryL,G1H64(554),ex5(:),G1H32(554),m3h2x32(:,554),heltab2x64(:,:,554))
  call Hloop_AQ_Z(ntryL,G1H64(555),ex5(:),G1H32(555),ngZl,m3h2x32(:,555),heltab2x64(:,:,555))
  call Hloop_AQ_V(ntryL,G1H64(556),ex5(:),G1H32(556),m3h2x32(:,556),heltab2x64(:,:,556))
  call Hloop_AQ_V(ntryL,G1H64(557),ex5(:),G1H32(557),m3h2x32(:,557),heltab2x64(:,:,557))
  call Hloop_AQ_V(ntryL,G1H64(558),ex5(:),G1H32(558),m3h2x32(:,558),heltab2x64(:,:,558))
  call Hloop_AQ_V(ntryL,G1H64(559),ex5(:),G1H32(559),m3h2x32(:,559),heltab2x64(:,:,559))
  call Hloop_AQ_S(ntryL,G1H64(560),ex5(:),G1H32(560),ngH,m3h2x32(:,560),heltab2x64(:,:,560))
  call Hloop_AQ_S(ntryL,G1H64(561),ex5(:),G1H32(561),ngX,m3h2x32(:,561),heltab2x64(:,:,561))
  call Hloop_AQ_S(ntryL,G1H64(562),ex5(:),G1H32(562),ngH,m3h2x32(:,562),heltab2x64(:,:,562))
  call Hloop_AQ_S(ntryL,G1H64(563),ex5(:),G1H32(563),ngX,m3h2x32(:,563),heltab2x64(:,:,563))
  call Hloop_AQ_S(ntryL,G1H64(564),ex5(:),G1H32(564),ngH,m3h2x32(:,564),heltab2x64(:,:,564))
  call Hloop_AQ_S(ntryL,G1H64(565),ex5(:),G1H32(565),ngX,m3h2x32(:,565),heltab2x64(:,:,565))
  call Hloop_AQ_S(ntryL,G1H64(566),ex5(:),G1H32(566),ngH,m3h2x32(:,566),heltab2x64(:,:,566))
  call Hloop_AQ_S(ntryL,G1H64(567),ex5(:),G1H32(567),ngX,m3h2x32(:,567),heltab2x64(:,:,567))
  call Hloop_AQ_V(ntryL,G1H64(568),ex5(:),G1H32(568),m3h2x32(:,568),heltab2x64(:,:,568))
  call Hloop_AQ_V(ntryL,G1H64(569),ex5(:),G1H32(569),m3h2x32(:,569),heltab2x64(:,:,569))
  call Hloop_AQ_Z(ntryL,G1H64(570),ex5(:),G1H32(570),ngZl,m3h2x32(:,570),heltab2x64(:,:,570))
  call Hloop_AQ_V(ntryL,G1H64(571),ex5(:),G1H32(571),m3h2x32(:,571),heltab2x64(:,:,571))
  call Hloop_AQ_Z(ntryL,G1H64(572),ex5(:),G1H32(572),ngZl,m3h2x32(:,572),heltab2x64(:,:,572))
  call Hloop_AQ_V(ntryL,G1H64(573),ex5(:),G1H32(573),m3h2x32(:,573),heltab2x64(:,:,573))
  call Hloop_AQ_V(ntryL,G1H64(574),ex5(:),G1H32(574),m3h2x32(:,574),heltab2x64(:,:,574))
  call Hloop_AQ_V(ntryL,G1H64(575),ex5(:),G1H32(575),m3h2x32(:,575),heltab2x64(:,:,575))
  call Hloop_AQ_Z(ntryL,G1H64(576),ex5(:),G1H32(576),ngZl,m3h2x32(:,576),heltab2x64(:,:,576))
  call Hloop_AQ_V(ntryL,G1H64(577),ex5(:),G1H32(577),m3h2x32(:,577),heltab2x64(:,:,577))
  call Hloop_AQ_Z(ntryL,G1H64(578),ex5(:),G1H32(578),ngZl,m3h2x32(:,578),heltab2x64(:,:,578))
  call Hloop_AQ_V(ntryL,G1H64(579),ex5(:),G1H32(579),m3h2x32(:,579),heltab2x64(:,:,579))
  call Hloop_AQ_S(ntryL,G1H64(580),ex5(:),G1H32(580),ngH,m3h2x32(:,580),heltab2x64(:,:,580))
  call Hloop_AQ_S(ntryL,G1H64(581),ex5(:),G1H32(581),ngX,m3h2x32(:,581),heltab2x64(:,:,581))
  call Hloop_AQ_S(ntryL,G1H64(582),ex5(:),G1H32(582),ngH,m3h2x32(:,582),heltab2x64(:,:,582))
  call Hloop_AQ_S(ntryL,G1H64(583),ex5(:),G1H32(583),ngH,m3h2x32(:,583),heltab2x64(:,:,583))
  call Hloop_AQ_S(ntryL,G1H64(584),ex5(:),G1H32(584),ngX,m3h2x32(:,584),heltab2x64(:,:,584))
  call Hloop_AQ_S(ntryL,G1H64(585),ex5(:),G1H32(585),ngX,m3h2x32(:,585),heltab2x64(:,:,585))
  call Hloop_AQ_V(ntryL,G1H64(586),ex5(:),G1H32(586),m3h2x32(:,586),heltab2x64(:,:,586))
  call Hloop_AQ_Z(ntryL,G1H64(587),ex5(:),G1H32(587),ngZl,m3h2x32(:,587),heltab2x64(:,:,587))
  call Hloop_AQ_V(ntryL,G1H64(588),ex5(:),G1H32(588),m3h2x32(:,588),heltab2x64(:,:,588))
  call Hloop_AQ_V(ntryL,G1H64(589),ex5(:),G1H32(589),m3h2x32(:,589),heltab2x64(:,:,589))
  call Hloop_AQ_Z(ntryL,G1H64(590),ex5(:),G1H32(590),ngZl,m3h2x32(:,590),heltab2x64(:,:,590))
  call Hloop_AQ_Z(ntryL,G1H64(591),ex5(:),G1H32(591),ngZl,m3h2x32(:,591),heltab2x64(:,:,591))
  call Hloop_AQ_V(ntryL,G1H64(592),ex5(:),G1H32(592),m3h2x32(:,592),heltab2x64(:,:,592))
  call Hloop_AQ_S(ntryL,G1H64(593),ex2(:),G1H32(593),ngH,m3h2x32(:,593),heltab2x64(:,:,593))
  call Hloop_AQ_S(ntryL,G1H64(594),ex2(:),G1H32(594),ngX,m3h2x32(:,594),heltab2x64(:,:,594))
  call Hloop_AQ_S(ntryL,G1H64(595),ex2(:),G1H32(595),ngH,m3h2x32(:,595),heltab2x64(:,:,595))
  call Hloop_AQ_S(ntryL,G1H64(596),ex2(:),G1H32(596),ngX,m3h2x32(:,596),heltab2x64(:,:,596))
  call Hloop_AQ_V(ntryL,G1H64(597),ex2(:),G1H32(597),m3h2x32(:,597),heltab2x64(:,:,597))
  call Hloop_AQ_V(ntryL,G1H64(598),ex2(:),G1H32(598),m3h2x32(:,598),heltab2x64(:,:,598))
  call Hloop_AQ_V(ntryL,G1H64(599),ex2(:),G1H32(599),m3h2x32(:,599),heltab2x64(:,:,599))
  call Hloop_AQ_V(ntryL,G1H64(600),ex2(:),G1H32(600),m3h2x32(:,600),heltab2x64(:,:,600))
  call Hloop_AQ_S(ntryL,G1H64(601),ex2(:),G1H32(601),ngH,m3h2x32(:,601),heltab2x64(:,:,601))
  call Hloop_AQ_S(ntryL,G1H64(602),ex2(:),G1H32(602),ngH,m3h2x32(:,602),heltab2x64(:,:,602))
  call Hloop_AQ_S(ntryL,G1H64(603),ex2(:),G1H32(603),ngX,m3h2x32(:,603),heltab2x64(:,:,603))
  call Hloop_AQ_S(ntryL,G1H64(604),ex2(:),G1H32(604),ngX,m3h2x32(:,604),heltab2x64(:,:,604))
  call Hloop_AQ_V(ntryL,G1H64(605),ex2(:),G1H32(605),m3h2x32(:,605),heltab2x64(:,:,605))
  call Hloop_AQ_V(ntryL,G1H64(606),ex2(:),G1H32(606),m3h2x32(:,606),heltab2x64(:,:,606))
  call Hloop_AQ_V(ntryL,G1H64(607),ex2(:),G1H32(607),m3h2x32(:,607),heltab2x64(:,:,607))
  call Hloop_AQ_Z(ntryL,G1H64(608),ex2(:),G1H32(608),ngZl,m3h2x32(:,608),heltab2x64(:,:,608))
  call Hloop_AQ_V(ntryL,G1H64(609),ex2(:),G1H32(609),m3h2x32(:,609),heltab2x64(:,:,609))
  call Hloop_AQ_Z(ntryL,G1H64(610),ex2(:),G1H32(610),ngZl,m3h2x32(:,610),heltab2x64(:,:,610))
  call Hloop_AQ_S(ntryL,G1H64(611),ex2(:),G1H32(611),ngH,m3h2x32(:,611),heltab2x64(:,:,611))
  call Hloop_AQ_S(ntryL,G1H64(612),ex2(:),G1H32(612),ngX,m3h2x32(:,612),heltab2x64(:,:,612))
  call Hloop_AQ_S(ntryL,G1H64(613),ex2(:),G1H32(613),ngH,m3h2x32(:,613),heltab2x64(:,:,613))
  call Hloop_AQ_S(ntryL,G1H64(614),ex2(:),G1H32(614),ngH,m3h2x32(:,614),heltab2x64(:,:,614))
  call Hloop_AQ_S(ntryL,G1H64(615),ex2(:),G1H32(615),ngX,m3h2x32(:,615),heltab2x64(:,:,615))
  call Hloop_AQ_S(ntryL,G1H64(616),ex2(:),G1H32(616),ngX,m3h2x32(:,616),heltab2x64(:,:,616))
  call Hloop_AQ_V(ntryL,G1H64(617),ex2(:),G1H32(617),m3h2x32(:,617),heltab2x64(:,:,617))
  call Hloop_AQ_V(ntryL,G1H64(618),ex2(:),G1H32(618),m3h2x32(:,618),heltab2x64(:,:,618))
  call Hloop_AQ_Z(ntryL,G1H64(619),ex2(:),G1H32(619),ngZl,m3h2x32(:,619),heltab2x64(:,:,619))
  call Hloop_AQ_V(ntryL,G1H64(620),ex2(:),G1H32(620),m3h2x32(:,620),heltab2x64(:,:,620))
  call Hloop_AQ_Z(ntryL,G1H64(621),ex2(:),G1H32(621),ngZl,m3h2x32(:,621),heltab2x64(:,:,621))
  call Hloop_AQ_V(ntryL,G1H64(622),ex2(:),G1H32(622),m3h2x32(:,622),heltab2x64(:,:,622))
  call Hloop_AQ_V(ntryL,G1H64(623),ex2(:),G1H32(623),m3h2x32(:,623),heltab2x64(:,:,623))
  call Hloop_AQ_V(ntryL,G1H64(624),ex2(:),G1H32(624),m3h2x32(:,624),heltab2x64(:,:,624))
  call Hloop_AQ_Z(ntryL,G1H64(625),ex2(:),G1H32(625),ngZl,m3h2x32(:,625),heltab2x64(:,:,625))
  call Hloop_AQ_V(ntryL,G1H64(626),ex2(:),G1H32(626),m3h2x32(:,626),heltab2x64(:,:,626))
  call Hloop_AQ_Z(ntryL,G1H64(627),ex2(:),G1H32(627),ngZl,m3h2x32(:,627),heltab2x64(:,:,627))
  call Hloop_AQ_V(ntryL,G1H64(628),ex2(:),G1H32(628),m3h2x32(:,628),heltab2x64(:,:,628))
  call Hloop_AQ_Z(ntryL,G1H64(629),ex2(:),G1H32(629),ngZl,m3h2x32(:,629),heltab2x64(:,:,629))
  call Hloop_AQ_S(ntryL,G1H64(630),ex2(:),G1H32(630),ngH,m3h2x32(:,630),heltab2x64(:,:,630))
  call Hloop_AQ_S(ntryL,G1H64(631),ex2(:),G1H32(631),ngX,m3h2x32(:,631),heltab2x64(:,:,631))
  call Hloop_AQ_S(ntryL,G1H64(632),ex2(:),G1H32(632),ngH,m3h2x32(:,632),heltab2x64(:,:,632))
  call Hloop_AQ_S(ntryL,G1H64(633),ex2(:),G1H32(633),ngX,m3h2x32(:,633),heltab2x64(:,:,633))
  call Hloop_AQ_V(ntryL,G1H64(634),ex2(:),G1H32(634),m3h2x32(:,634),heltab2x64(:,:,634))
  call Hloop_AQ_V(ntryL,G1H64(635),ex2(:),G1H32(635),m3h2x32(:,635),heltab2x64(:,:,635))
  call Hloop_AQ_V(ntryL,G1H64(636),ex2(:),G1H32(636),m3h2x32(:,636),heltab2x64(:,:,636))
  call Hloop_AQ_V(ntryL,G1H64(637),ex2(:),G1H32(637),m3h2x32(:,637),heltab2x64(:,:,637))
  call Hloop_AQ_S(ntryL,G1H64(638),ex2(:),G1H32(638),ngH,m3h2x32(:,638),heltab2x64(:,:,638))
  call Hloop_AQ_S(ntryL,G1H64(639),ex2(:),G1H32(639),ngH,m3h2x32(:,639),heltab2x64(:,:,639))
  call Hloop_AQ_S(ntryL,G1H64(640),ex2(:),G1H32(640),ngX,m3h2x32(:,640),heltab2x64(:,:,640))
  call Hloop_AQ_S(ntryL,G1H64(641),ex2(:),G1H32(641),ngX,m3h2x32(:,641),heltab2x64(:,:,641))
  call Hloop_AQ_V(ntryL,G1H64(642),ex2(:),G1H32(642),m3h2x32(:,642),heltab2x64(:,:,642))
  call Hloop_AQ_V(ntryL,G1H64(643),ex2(:),G1H32(643),m3h2x32(:,643),heltab2x64(:,:,643))
  call Hloop_AQ_V(ntryL,G1H64(644),ex2(:),G1H32(644),m3h2x32(:,644),heltab2x64(:,:,644))
  call Hloop_AQ_Z(ntryL,G1H64(645),ex2(:),G1H32(645),ngZl,m3h2x32(:,645),heltab2x64(:,:,645))
  call Hloop_AQ_V(ntryL,G1H64(646),ex2(:),G1H32(646),m3h2x32(:,646),heltab2x64(:,:,646))
  call Hloop_AQ_Z(ntryL,G1H64(647),ex2(:),G1H32(647),ngZl,m3h2x32(:,647),heltab2x64(:,:,647))
  call Hloop_AQ_S(ntryL,G1H64(648),ex2(:),G1H32(648),ngH,m3h2x32(:,648),heltab2x64(:,:,648))
  call Hloop_AQ_S(ntryL,G1H64(649),ex2(:),G1H32(649),ngX,m3h2x32(:,649),heltab2x64(:,:,649))
  call Hloop_AQ_S(ntryL,G1H64(650),ex2(:),G1H32(650),ngH,m3h2x32(:,650),heltab2x64(:,:,650))
  call Hloop_AQ_S(ntryL,G1H64(651),ex2(:),G1H32(651),ngH,m3h2x32(:,651),heltab2x64(:,:,651))
  call Hloop_AQ_S(ntryL,G1H64(652),ex2(:),G1H32(652),ngX,m3h2x32(:,652),heltab2x64(:,:,652))
  call Hloop_AQ_S(ntryL,G1H64(653),ex2(:),G1H32(653),ngX,m3h2x32(:,653),heltab2x64(:,:,653))
  call Hloop_AQ_V(ntryL,G1H64(654),ex2(:),G1H32(654),m3h2x32(:,654),heltab2x64(:,:,654))
  call Hloop_AQ_V(ntryL,G1H64(655),ex2(:),G1H32(655),m3h2x32(:,655),heltab2x64(:,:,655))
  call Hloop_AQ_Z(ntryL,G1H64(656),ex2(:),G1H32(656),ngZl,m3h2x32(:,656),heltab2x64(:,:,656))
  call Hloop_AQ_V(ntryL,G1H64(657),ex2(:),G1H32(657),m3h2x32(:,657),heltab2x64(:,:,657))
  call Hloop_AQ_Z(ntryL,G1H64(658),ex2(:),G1H32(658),ngZl,m3h2x32(:,658),heltab2x64(:,:,658))
  call Hloop_AQ_V(ntryL,G1H64(659),ex2(:),G1H32(659),m3h2x32(:,659),heltab2x64(:,:,659))
  call Hloop_AQ_V(ntryL,G1H64(660),ex2(:),G1H32(660),m3h2x32(:,660),heltab2x64(:,:,660))
  call Hloop_AQ_V(ntryL,G1H64(661),ex2(:),G1H32(661),m3h2x32(:,661),heltab2x64(:,:,661))
  call Hloop_AQ_Z(ntryL,G1H64(662),ex2(:),G1H32(662),ngZl,m3h2x32(:,662),heltab2x64(:,:,662))
  call Hloop_AQ_V(ntryL,G1H64(663),ex2(:),G1H32(663),m3h2x32(:,663),heltab2x64(:,:,663))
  call Hloop_AQ_Z(ntryL,G1H64(664),ex2(:),G1H32(664),ngZl,m3h2x32(:,664),heltab2x64(:,:,664))
  call Hloop_AQ_V(ntryL,G1H64(665),ex2(:),G1H32(665),m3h2x32(:,665),heltab2x64(:,:,665))
  call Hloop_AQ_Z(ntryL,G1H64(666),ex2(:),G1H32(666),ngZl,m3h2x32(:,666),heltab2x64(:,:,666))
  call Hloop_AQ_S(ntryL,G1H64(667),ex2(:),G1H32(667),ngH,m3h2x32(:,667),heltab2x64(:,:,667))
  call Hloop_AQ_S(ntryL,G1H64(668),ex2(:),G1H32(668),ngX,m3h2x32(:,668),heltab2x64(:,:,668))
  call Hloop_AQ_S(ntryL,G1H64(669),ex2(:),G1H32(669),ngH,m3h2x32(:,669),heltab2x64(:,:,669))
  call Hloop_AQ_S(ntryL,G1H64(670),ex2(:),G1H32(670),ngX,m3h2x32(:,670),heltab2x64(:,:,670))
  call Hloop_AQ_V(ntryL,G1H64(671),ex2(:),G1H32(671),m3h2x32(:,671),heltab2x64(:,:,671))
  call Hloop_AQ_V(ntryL,G1H64(672),ex2(:),G1H32(672),m3h2x32(:,672),heltab2x64(:,:,672))
  call Hloop_AQ_V(ntryL,G1H64(673),ex2(:),G1H32(673),m3h2x32(:,673),heltab2x64(:,:,673))
  call Hloop_AQ_V(ntryL,G1H64(674),ex2(:),G1H32(674),m3h2x32(:,674),heltab2x64(:,:,674))
  call Hloop_AQ_S(ntryL,G1H64(675),ex2(:),G1H32(675),ngH,m3h2x32(:,675),heltab2x64(:,:,675))
  call Hloop_AQ_S(ntryL,G1H64(676),ex2(:),G1H32(676),ngH,m3h2x32(:,676),heltab2x64(:,:,676))
  call Hloop_AQ_S(ntryL,G1H64(677),ex2(:),G1H32(677),ngX,m3h2x32(:,677),heltab2x64(:,:,677))
  call Hloop_AQ_S(ntryL,G1H64(678),ex2(:),G1H32(678),ngX,m3h2x32(:,678),heltab2x64(:,:,678))
  call Hloop_AQ_V(ntryL,G1H64(679),ex2(:),G1H32(679),m3h2x32(:,679),heltab2x64(:,:,679))
  call Hloop_AQ_V(ntryL,G1H64(680),ex2(:),G1H32(680),m3h2x32(:,680),heltab2x64(:,:,680))
  call Hloop_AQ_V(ntryL,G1H64(681),ex2(:),G1H32(681),m3h2x32(:,681),heltab2x64(:,:,681))
  call Hloop_AQ_Z(ntryL,G1H64(682),ex2(:),G1H32(682),ngZl,m3h2x32(:,682),heltab2x64(:,:,682))
  call Hloop_AQ_V(ntryL,G1H64(683),ex2(:),G1H32(683),m3h2x32(:,683),heltab2x64(:,:,683))
  call Hloop_AQ_Z(ntryL,G1H64(684),ex2(:),G1H32(684),ngZl,m3h2x32(:,684),heltab2x64(:,:,684))
  call Hloop_AQ_S(ntryL,G1H64(685),ex2(:),G1H32(685),ngH,m3h2x32(:,685),heltab2x64(:,:,685))
  call Hloop_AQ_S(ntryL,G1H64(686),ex2(:),G1H32(686),ngX,m3h2x32(:,686),heltab2x64(:,:,686))
  call Hloop_AQ_S(ntryL,G1H64(687),ex2(:),G1H32(687),ngH,m3h2x32(:,687),heltab2x64(:,:,687))
  call Hloop_AQ_S(ntryL,G1H64(688),ex2(:),G1H32(688),ngH,m3h2x32(:,688),heltab2x64(:,:,688))
  call Hloop_AQ_S(ntryL,G1H64(689),ex2(:),G1H32(689),ngX,m3h2x32(:,689),heltab2x64(:,:,689))
  call Hloop_AQ_S(ntryL,G1H64(690),ex2(:),G1H32(690),ngX,m3h2x32(:,690),heltab2x64(:,:,690))
  call Hloop_AQ_V(ntryL,G1H64(691),ex2(:),G1H32(691),m3h2x32(:,691),heltab2x64(:,:,691))
  call Hloop_AQ_V(ntryL,G1H64(692),ex2(:),G1H32(692),m3h2x32(:,692),heltab2x64(:,:,692))
  call Hloop_AQ_Z(ntryL,G1H64(693),ex2(:),G1H32(693),ngZl,m3h2x32(:,693),heltab2x64(:,:,693))
  call Hloop_AQ_V(ntryL,G1H64(694),ex2(:),G1H32(694),m3h2x32(:,694),heltab2x64(:,:,694))
  call Hloop_AQ_Z(ntryL,G1H64(695),ex2(:),G1H32(695),ngZl,m3h2x32(:,695),heltab2x64(:,:,695))
  call Hloop_AQ_V(ntryL,G1H64(696),ex2(:),G1H32(696),m3h2x32(:,696),heltab2x64(:,:,696))
  call Hloop_AQ_V(ntryL,G1H64(697),ex2(:),G1H32(697),m3h2x32(:,697),heltab2x64(:,:,697))
  call Hloop_AQ_V(ntryL,G1H64(698),ex2(:),G1H32(698),m3h2x32(:,698),heltab2x64(:,:,698))
  call Hloop_AQ_Z(ntryL,G1H64(699),ex2(:),G1H32(699),ngZl,m3h2x32(:,699),heltab2x64(:,:,699))
  call Hloop_AQ_V(ntryL,G1H64(700),ex2(:),G1H32(700),m3h2x32(:,700),heltab2x64(:,:,700))
  call Hloop_AQ_Z(ntryL,G1H64(701),ex2(:),G1H32(701),ngZl,m3h2x32(:,701),heltab2x64(:,:,701))
  call Hloop_AQ_V(ntryL,G1H64(702),ex2(:),G1H32(702),m3h2x32(:,702),heltab2x64(:,:,702))
  call Hloop_AQ_Z(ntryL,G1H64(703),ex2(:),G1H32(703),ngZl,m3h2x32(:,703),heltab2x64(:,:,703))
  call Hloop_AQ_S(ntryL,G1H64(704),ex2(:),G1H32(704),ngH,m3h2x32(:,704),heltab2x64(:,:,704))
  call Hloop_AQ_S(ntryL,G1H64(705),ex2(:),G1H32(705),ngX,m3h2x32(:,705),heltab2x64(:,:,705))
  call Hloop_AQ_S(ntryL,G1H64(706),ex2(:),G1H32(706),ngH,m3h2x32(:,706),heltab2x64(:,:,706))
  call Hloop_AQ_S(ntryL,G1H64(707),ex2(:),G1H32(707),ngX,m3h2x32(:,707),heltab2x64(:,:,707))
  call Hloop_AQ_V(ntryL,G1H64(708),ex2(:),G1H32(708),m3h2x32(:,708),heltab2x64(:,:,708))
  call Hloop_AQ_V(ntryL,G1H64(709),ex2(:),G1H32(709),m3h2x32(:,709),heltab2x64(:,:,709))
  call Hloop_AQ_V(ntryL,G1H64(710),ex2(:),G1H32(710),m3h2x32(:,710),heltab2x64(:,:,710))
  call Hloop_AQ_V(ntryL,G1H64(711),ex2(:),G1H32(711),m3h2x32(:,711),heltab2x64(:,:,711))
  call Hloop_AQ_S(ntryL,G1H64(712),ex2(:),G1H32(712),ngH,m3h2x32(:,712),heltab2x64(:,:,712))
  call Hloop_AQ_S(ntryL,G1H64(713),ex2(:),G1H32(713),ngH,m3h2x32(:,713),heltab2x64(:,:,713))
  call Hloop_AQ_S(ntryL,G1H64(714),ex2(:),G1H32(714),ngX,m3h2x32(:,714),heltab2x64(:,:,714))
  call Hloop_AQ_S(ntryL,G1H64(715),ex2(:),G1H32(715),ngX,m3h2x32(:,715),heltab2x64(:,:,715))
  call Hloop_AQ_V(ntryL,G1H64(716),ex2(:),G1H32(716),m3h2x32(:,716),heltab2x64(:,:,716))
  call Hloop_AQ_V(ntryL,G1H64(717),ex2(:),G1H32(717),m3h2x32(:,717),heltab2x64(:,:,717))
  call Hloop_AQ_V(ntryL,G1H64(718),ex2(:),G1H32(718),m3h2x32(:,718),heltab2x64(:,:,718))
  call Hloop_AQ_Z(ntryL,G1H64(719),ex2(:),G1H32(719),ngZl,m3h2x32(:,719),heltab2x64(:,:,719))
  call Hloop_AQ_V(ntryL,G1H64(720),ex2(:),G1H32(720),m3h2x32(:,720),heltab2x64(:,:,720))
  call Hloop_AQ_Z(ntryL,G1H64(721),ex2(:),G1H32(721),ngZl,m3h2x32(:,721),heltab2x64(:,:,721))
  call Hloop_AQ_S(ntryL,G1H64(722),ex2(:),G1H32(722),ngH,m3h2x32(:,722),heltab2x64(:,:,722))
  call Hloop_AQ_S(ntryL,G1H64(723),ex2(:),G1H32(723),ngX,m3h2x32(:,723),heltab2x64(:,:,723))
  call Hloop_AQ_S(ntryL,G1H64(724),ex2(:),G1H32(724),ngH,m3h2x32(:,724),heltab2x64(:,:,724))
  call Hloop_AQ_S(ntryL,G1H64(725),ex2(:),G1H32(725),ngH,m3h2x32(:,725),heltab2x64(:,:,725))
  call Hloop_AQ_S(ntryL,G1H64(726),ex2(:),G1H32(726),ngX,m3h2x32(:,726),heltab2x64(:,:,726))
  call Hloop_AQ_S(ntryL,G1H64(727),ex2(:),G1H32(727),ngX,m3h2x32(:,727),heltab2x64(:,:,727))
  call Hloop_AQ_V(ntryL,G1H64(728),ex2(:),G1H32(728),m3h2x32(:,728),heltab2x64(:,:,728))
  call Hloop_AQ_V(ntryL,G1H64(729),ex2(:),G1H32(729),m3h2x32(:,729),heltab2x64(:,:,729))
  call Hloop_AQ_Z(ntryL,G1H64(730),ex2(:),G1H32(730),ngZl,m3h2x32(:,730),heltab2x64(:,:,730))
  call Hloop_AQ_V(ntryL,G1H64(731),ex2(:),G1H32(731),m3h2x32(:,731),heltab2x64(:,:,731))
  call Hloop_AQ_Z(ntryL,G1H64(732),ex2(:),G1H32(732),ngZl,m3h2x32(:,732),heltab2x64(:,:,732))
  call Hloop_AQ_V(ntryL,G1H64(733),ex2(:),G1H32(733),m3h2x32(:,733),heltab2x64(:,:,733))
  call Hloop_AQ_V(ntryL,G1H64(734),ex2(:),G1H32(734),m3h2x32(:,734),heltab2x64(:,:,734))
  call Hloop_AQ_V(ntryL,G1H64(735),ex2(:),G1H32(735),m3h2x32(:,735),heltab2x64(:,:,735))
  call Hloop_AQ_Z(ntryL,G1H64(736),ex2(:),G1H32(736),ngZl,m3h2x32(:,736),heltab2x64(:,:,736))
  call Hloop_AQ_V(ntryL,G1H64(737),ex2(:),G1H32(737),m3h2x32(:,737),heltab2x64(:,:,737))
  call Hloop_AQ_Z(ntryL,G1H64(738),ex2(:),G1H32(738),ngZl,m3h2x32(:,738),heltab2x64(:,:,738))
  call Hloop_AQ_V(ntryL,G1H64(739),ex2(:),G1H32(739),m3h2x32(:,739),heltab2x64(:,:,739))
  call Hloop_AQ_Z(ntryL,G1H64(740),ex2(:),G1H32(740),ngZl,m3h2x32(:,740),heltab2x64(:,:,740))
  call Hloop_AQ_S(ntryL,G1H64(741),ex5(:),G1H32(741),ngH,m3h2x32(:,741),heltab2x64(:,:,741))
  call Hloop_AQ_S(ntryL,G1H64(742),ex5(:),G1H32(742),ngH,m3h2x32(:,742),heltab2x64(:,:,742))
  call Hloop_AQ_S(ntryL,G1H64(743),ex5(:),G1H32(743),ngX,m3h2x32(:,743),heltab2x64(:,:,743))
  call Hloop_AQ_S(ntryL,G1H64(744),ex5(:),G1H32(744),ngX,m3h2x32(:,744),heltab2x64(:,:,744))
  call Hloop_AQ_S(ntryL,G1H64(745),ex5(:),G1H32(745),ngH,m3h2x32(:,745),heltab2x64(:,:,745))
  call Hloop_AQ_S(ntryL,G1H64(746),ex5(:),G1H32(746),ngH,m3h2x32(:,746),heltab2x64(:,:,746))
  call Hloop_AQ_S(ntryL,G1H64(747),ex5(:),G1H32(747),ngX,m3h2x32(:,747),heltab2x64(:,:,747))
  call Hloop_AQ_S(ntryL,G1H64(748),ex5(:),G1H32(748),ngX,m3h2x32(:,748),heltab2x64(:,:,748))
  call Hloop_AQ_V(ntryL,G1H64(749),ex5(:),G1H32(749),m3h2x32(:,749),heltab2x64(:,:,749))
  call Hloop_AQ_V(ntryL,G1H64(750),ex5(:),G1H32(750),m3h2x32(:,750),heltab2x64(:,:,750))
  call Hloop_AQ_V(ntryL,G1H64(751),ex5(:),G1H32(751),m3h2x32(:,751),heltab2x64(:,:,751))
  call Hloop_AQ_V(ntryL,G1H64(752),ex5(:),G1H32(752),m3h2x32(:,752),heltab2x64(:,:,752))
  call Hloop_AQ_S(ntryL,G1H64(753),ex5(:),G1H32(753),ngH,m3h2x32(:,753),heltab2x64(:,:,753))
  call Hloop_AQ_S(ntryL,G1H64(754),ex5(:),G1H32(754),ngX,m3h2x32(:,754),heltab2x64(:,:,754))
  call Hloop_AQ_S(ntryL,G1H64(755),ex5(:),G1H32(755),ngH,m3h2x32(:,755),heltab2x64(:,:,755))
  call Hloop_AQ_S(ntryL,G1H64(756),ex5(:),G1H32(756),ngH,m3h2x32(:,756),heltab2x64(:,:,756))
  call Hloop_AQ_S(ntryL,G1H64(757),ex5(:),G1H32(757),ngX,m3h2x32(:,757),heltab2x64(:,:,757))
  call Hloop_AQ_S(ntryL,G1H64(758),ex5(:),G1H32(758),ngX,m3h2x32(:,758),heltab2x64(:,:,758))
  call Hloop_AQ_V(ntryL,G1H64(759),ex5(:),G1H32(759),m3h2x32(:,759),heltab2x64(:,:,759))
  call Hloop_AQ_V(ntryL,G1H64(760),ex5(:),G1H32(760),m3h2x32(:,760),heltab2x64(:,:,760))
  call Hloop_AQ_V(ntryL,G1H64(761),ex5(:),G1H32(761),m3h2x32(:,761),heltab2x64(:,:,761))
  call Hloop_AQ_Z(ntryL,G1H64(762),ex5(:),G1H32(762),ngZl,m3h2x32(:,762),heltab2x64(:,:,762))
  call Hloop_AQ_V(ntryL,G1H64(763),ex5(:),G1H32(763),m3h2x32(:,763),heltab2x64(:,:,763))
  call Hloop_AQ_Z(ntryL,G1H64(764),ex5(:),G1H32(764),ngZl,m3h2x32(:,764),heltab2x64(:,:,764))
  call Hloop_AQ_V(ntryL,G1H64(765),ex5(:),G1H32(765),m3h2x32(:,765),heltab2x64(:,:,765))
  call Hloop_AQ_V(ntryL,G1H64(766),ex5(:),G1H32(766),m3h2x32(:,766),heltab2x64(:,:,766))
  call Hloop_AQ_V(ntryL,G1H64(767),ex5(:),G1H32(767),m3h2x32(:,767),heltab2x64(:,:,767))
  call Hloop_AQ_Z(ntryL,G1H64(768),ex5(:),G1H32(768),ngZl,m3h2x32(:,768),heltab2x64(:,:,768))
  call Hloop_AQ_V(ntryL,G1H64(769),ex5(:),G1H32(769),m3h2x32(:,769),heltab2x64(:,:,769))
  call Hloop_AQ_Z(ntryL,G1H64(770),ex5(:),G1H32(770),ngZl,m3h2x32(:,770),heltab2x64(:,:,770))
  call Hloop_AQ_V(ntryL,G1H64(771),ex5(:),G1H32(771),m3h2x32(:,771),heltab2x64(:,:,771))
  call Hloop_AQ_V(ntryL,G1H64(772),ex5(:),G1H32(772),m3h2x32(:,772),heltab2x64(:,:,772))
  call Hloop_AQ_V(ntryL,G1H64(773),ex5(:),G1H32(773),m3h2x32(:,773),heltab2x64(:,:,773))
  call Hloop_AQ_Z(ntryL,G1H64(774),ex5(:),G1H32(774),ngZl,m3h2x32(:,774),heltab2x64(:,:,774))
  call Hloop_AQ_V(ntryL,G1H64(775),ex5(:),G1H32(775),m3h2x32(:,775),heltab2x64(:,:,775))
  call Hloop_AQ_Z(ntryL,G1H64(776),ex5(:),G1H32(776),ngZl,m3h2x32(:,776),heltab2x64(:,:,776))
  call Hloop_AQ_Z(ntryL,G1H64(777),ex5(:),G1H32(777),ngZl,m3h2x32(:,777),heltab2x64(:,:,777))
  call Hloop_AQ_S(ntryL,G1H64(778),ex2(:),G1H32(778),ngH,m3h2x32(:,778),heltab2x64(:,:,778))
  call Hloop_AQ_S(ntryL,G1H64(779),ex2(:),G1H32(779),ngX,m3h2x32(:,779),heltab2x64(:,:,779))
  call Hloop_AQ_S(ntryL,G1H64(780),ex2(:),G1H32(780),ngH,m3h2x32(:,780),heltab2x64(:,:,780))
  call Hloop_AQ_S(ntryL,G1H64(781),ex2(:),G1H32(781),ngX,m3h2x32(:,781),heltab2x64(:,:,781))
  call Hloop_AQ_V(ntryL,G1H64(782),ex2(:),G1H32(782),m3h2x32(:,782),heltab2x64(:,:,782))
  call Hloop_AQ_V(ntryL,G1H64(783),ex2(:),G1H32(783),m3h2x32(:,783),heltab2x64(:,:,783))
  call Hloop_AQ_V(ntryL,G1H64(784),ex2(:),G1H32(784),m3h2x32(:,784),heltab2x64(:,:,784))
  call Hloop_AQ_V(ntryL,G1H64(785),ex2(:),G1H32(785),m3h2x32(:,785),heltab2x64(:,:,785))
  call Hloop_AQ_S(ntryL,G1H64(786),ex2(:),G1H32(786),ngH,m3h2x32(:,786),heltab2x64(:,:,786))
  call Hloop_AQ_S(ntryL,G1H64(787),ex2(:),G1H32(787),ngH,m3h2x32(:,787),heltab2x64(:,:,787))
  call Hloop_AQ_S(ntryL,G1H64(788),ex2(:),G1H32(788),ngX,m3h2x32(:,788),heltab2x64(:,:,788))
  call Hloop_AQ_S(ntryL,G1H64(789),ex2(:),G1H32(789),ngX,m3h2x32(:,789),heltab2x64(:,:,789))
  call Hloop_AQ_V(ntryL,G1H64(790),ex2(:),G1H32(790),m3h2x32(:,790),heltab2x64(:,:,790))
  call Hloop_AQ_V(ntryL,G1H64(791),ex2(:),G1H32(791),m3h2x32(:,791),heltab2x64(:,:,791))
  call Hloop_AQ_V(ntryL,G1H64(792),ex2(:),G1H32(792),m3h2x32(:,792),heltab2x64(:,:,792))
  call Hloop_AQ_Z(ntryL,G1H64(793),ex2(:),G1H32(793),ngZl,m3h2x32(:,793),heltab2x64(:,:,793))
  call Hloop_AQ_V(ntryL,G1H64(794),ex2(:),G1H32(794),m3h2x32(:,794),heltab2x64(:,:,794))
  call Hloop_AQ_Z(ntryL,G1H64(795),ex2(:),G1H32(795),ngZl,m3h2x32(:,795),heltab2x64(:,:,795))
  call Hloop_AQ_S(ntryL,G1H64(796),ex2(:),G1H32(796),ngH,m3h2x32(:,796),heltab2x64(:,:,796))
  call Hloop_AQ_S(ntryL,G1H64(797),ex2(:),G1H32(797),ngX,m3h2x32(:,797),heltab2x64(:,:,797))
  call Hloop_AQ_S(ntryL,G1H64(798),ex2(:),G1H32(798),ngH,m3h2x32(:,798),heltab2x64(:,:,798))
  call Hloop_AQ_S(ntryL,G1H64(799),ex2(:),G1H32(799),ngH,m3h2x32(:,799),heltab2x64(:,:,799))
  call Hloop_AQ_S(ntryL,G1H64(800),ex2(:),G1H32(800),ngX,m3h2x32(:,800),heltab2x64(:,:,800))
  call Hloop_AQ_S(ntryL,G1H64(801),ex2(:),G1H32(801),ngX,m3h2x32(:,801),heltab2x64(:,:,801))
  call Hloop_AQ_V(ntryL,G1H64(802),ex2(:),G1H32(802),m3h2x32(:,802),heltab2x64(:,:,802))
  call Hloop_AQ_V(ntryL,G1H64(803),ex2(:),G1H32(803),m3h2x32(:,803),heltab2x64(:,:,803))
  call Hloop_AQ_Z(ntryL,G1H64(804),ex2(:),G1H32(804),ngZl,m3h2x32(:,804),heltab2x64(:,:,804))
  call Hloop_AQ_V(ntryL,G1H64(805),ex2(:),G1H32(805),m3h2x32(:,805),heltab2x64(:,:,805))
  call Hloop_AQ_Z(ntryL,G1H64(806),ex2(:),G1H32(806),ngZl,m3h2x32(:,806),heltab2x64(:,:,806))
  call Hloop_AQ_V(ntryL,G1H64(807),ex2(:),G1H32(807),m3h2x32(:,807),heltab2x64(:,:,807))
  call Hloop_AQ_V(ntryL,G1H64(808),ex2(:),G1H32(808),m3h2x32(:,808),heltab2x64(:,:,808))
  call Hloop_AQ_V(ntryL,G1H64(809),ex2(:),G1H32(809),m3h2x32(:,809),heltab2x64(:,:,809))
  call Hloop_AQ_Z(ntryL,G1H64(810),ex2(:),G1H32(810),ngZl,m3h2x32(:,810),heltab2x64(:,:,810))
  call Hloop_AQ_V(ntryL,G1H64(811),ex2(:),G1H32(811),m3h2x32(:,811),heltab2x64(:,:,811))
  call Hloop_AQ_Z(ntryL,G1H64(812),ex2(:),G1H32(812),ngZl,m3h2x32(:,812),heltab2x64(:,:,812))
  call Hloop_AQ_V(ntryL,G1H64(813),ex2(:),G1H32(813),m3h2x32(:,813),heltab2x64(:,:,813))
  call Hloop_AQ_Z(ntryL,G1H64(814),ex2(:),G1H32(814),ngZl,m3h2x32(:,814),heltab2x64(:,:,814))
  call Hloop_AQ_S(ntryL,G1H64(815),ex5(:),G1H32(815),ngH,m3h2x32(:,815),heltab2x64(:,:,815))
  call Hloop_AQ_S(ntryL,G1H64(816),ex5(:),G1H32(816),ngH,m3h2x32(:,816),heltab2x64(:,:,816))
  call Hloop_AQ_S(ntryL,G1H64(817),ex5(:),G1H32(817),ngX,m3h2x32(:,817),heltab2x64(:,:,817))
  call Hloop_AQ_S(ntryL,G1H64(818),ex5(:),G1H32(818),ngX,m3h2x32(:,818),heltab2x64(:,:,818))
  call Hloop_AQ_S(ntryL,G1H64(819),ex5(:),G1H32(819),ngH,m3h2x32(:,819),heltab2x64(:,:,819))
  call Hloop_AQ_S(ntryL,G1H64(820),ex5(:),G1H32(820),ngH,m3h2x32(:,820),heltab2x64(:,:,820))
  call Hloop_AQ_S(ntryL,G1H64(821),ex5(:),G1H32(821),ngX,m3h2x32(:,821),heltab2x64(:,:,821))
  call Hloop_AQ_S(ntryL,G1H64(822),ex5(:),G1H32(822),ngX,m3h2x32(:,822),heltab2x64(:,:,822))
  call Hloop_AQ_V(ntryL,G1H64(823),ex5(:),G1H32(823),m3h2x32(:,823),heltab2x64(:,:,823))
  call Hloop_AQ_V(ntryL,G1H64(824),ex5(:),G1H32(824),m3h2x32(:,824),heltab2x64(:,:,824))
  call Hloop_AQ_V(ntryL,G1H64(825),ex5(:),G1H32(825),m3h2x32(:,825),heltab2x64(:,:,825))
  call Hloop_AQ_V(ntryL,G1H64(826),ex5(:),G1H32(826),m3h2x32(:,826),heltab2x64(:,:,826))
  call Hloop_AQ_S(ntryL,G1H64(827),ex5(:),G1H32(827),ngH,m3h2x32(:,827),heltab2x64(:,:,827))
  call Hloop_AQ_S(ntryL,G1H64(828),ex5(:),G1H32(828),ngX,m3h2x32(:,828),heltab2x64(:,:,828))
  call Hloop_AQ_S(ntryL,G1H64(829),ex5(:),G1H32(829),ngH,m3h2x32(:,829),heltab2x64(:,:,829))
  call Hloop_AQ_S(ntryL,G1H64(830),ex5(:),G1H32(830),ngH,m3h2x32(:,830),heltab2x64(:,:,830))
  call Hloop_AQ_S(ntryL,G1H64(831),ex5(:),G1H32(831),ngX,m3h2x32(:,831),heltab2x64(:,:,831))
  call Hloop_AQ_S(ntryL,G1H64(832),ex5(:),G1H32(832),ngX,m3h2x32(:,832),heltab2x64(:,:,832))
  call Hloop_AQ_V(ntryL,G1H64(833),ex5(:),G1H32(833),m3h2x32(:,833),heltab2x64(:,:,833))
  call Hloop_AQ_V(ntryL,G1H64(834),ex5(:),G1H32(834),m3h2x32(:,834),heltab2x64(:,:,834))
  call Hloop_AQ_V(ntryL,G1H64(835),ex5(:),G1H32(835),m3h2x32(:,835),heltab2x64(:,:,835))
  call Hloop_AQ_Z(ntryL,G1H64(836),ex5(:),G1H32(836),ngZl,m3h2x32(:,836),heltab2x64(:,:,836))
  call Hloop_AQ_V(ntryL,G1H64(837),ex5(:),G1H32(837),m3h2x32(:,837),heltab2x64(:,:,837))
  call Hloop_AQ_Z(ntryL,G1H64(838),ex5(:),G1H32(838),ngZl,m3h2x32(:,838),heltab2x64(:,:,838))
  call Hloop_AQ_V(ntryL,G1H64(839),ex5(:),G1H32(839),m3h2x32(:,839),heltab2x64(:,:,839))
  call Hloop_AQ_V(ntryL,G1H64(840),ex5(:),G1H32(840),m3h2x32(:,840),heltab2x64(:,:,840))
  call Hloop_AQ_V(ntryL,G1H64(841),ex5(:),G1H32(841),m3h2x32(:,841),heltab2x64(:,:,841))
  call Hloop_AQ_Z(ntryL,G1H64(842),ex5(:),G1H32(842),ngZl,m3h2x32(:,842),heltab2x64(:,:,842))
  call Hloop_AQ_V(ntryL,G1H64(843),ex5(:),G1H32(843),m3h2x32(:,843),heltab2x64(:,:,843))
  call Hloop_AQ_Z(ntryL,G1H64(844),ex5(:),G1H32(844),ngZl,m3h2x32(:,844),heltab2x64(:,:,844))
  call Hloop_AQ_V(ntryL,G1H64(845),ex5(:),G1H32(845),m3h2x32(:,845),heltab2x64(:,:,845))
  call Hloop_AQ_V(ntryL,G1H64(846),ex5(:),G1H32(846),m3h2x32(:,846),heltab2x64(:,:,846))
  call Hloop_AQ_V(ntryL,G1H64(847),ex5(:),G1H32(847),m3h2x32(:,847),heltab2x64(:,:,847))
  call Hloop_AQ_Z(ntryL,G1H64(848),ex5(:),G1H32(848),ngZl,m3h2x32(:,848),heltab2x64(:,:,848))
  call Hloop_AQ_V(ntryL,G1H64(849),ex5(:),G1H32(849),m3h2x32(:,849),heltab2x64(:,:,849))
  call Hloop_AQ_Z(ntryL,G1H64(850),ex5(:),G1H32(850),ngZl,m3h2x32(:,850),heltab2x64(:,:,850))
  call Hloop_AQ_Z(ntryL,G1H64(851),ex5(:),G1H32(851),ngZl,m3h2x32(:,851),heltab2x64(:,:,851))
  call Hloop_AQ_S(ntryL,G1H64(852),ex2(:),G1H32(852),ngH,m3h2x32(:,852),heltab2x64(:,:,852))
  call Hloop_AQ_S(ntryL,G1H64(853),ex2(:),G1H32(853),ngX,m3h2x32(:,853),heltab2x64(:,:,853))
  call Hloop_AQ_S(ntryL,G1H64(854),ex2(:),G1H32(854),ngH,m3h2x32(:,854),heltab2x64(:,:,854))
  call Hloop_AQ_S(ntryL,G1H64(855),ex2(:),G1H32(855),ngX,m3h2x32(:,855),heltab2x64(:,:,855))
  call Hloop_AQ_V(ntryL,G1H64(856),ex2(:),G1H32(856),m3h2x32(:,856),heltab2x64(:,:,856))
  call Hloop_AQ_V(ntryL,G1H64(857),ex2(:),G1H32(857),m3h2x32(:,857),heltab2x64(:,:,857))
  call Hloop_AQ_V(ntryL,G1H64(858),ex2(:),G1H32(858),m3h2x32(:,858),heltab2x64(:,:,858))
  call Hloop_AQ_V(ntryL,G1H64(859),ex2(:),G1H32(859),m3h2x32(:,859),heltab2x64(:,:,859))
  call Hloop_AQ_S(ntryL,G1H64(860),ex2(:),G1H32(860),ngH,m3h2x32(:,860),heltab2x64(:,:,860))
  call Hloop_AQ_S(ntryL,G1H64(861),ex2(:),G1H32(861),ngH,m3h2x32(:,861),heltab2x64(:,:,861))
  call Hloop_AQ_S(ntryL,G1H64(862),ex2(:),G1H32(862),ngX,m3h2x32(:,862),heltab2x64(:,:,862))
  call Hloop_AQ_S(ntryL,G1H64(863),ex2(:),G1H32(863),ngX,m3h2x32(:,863),heltab2x64(:,:,863))
  call Hloop_AQ_V(ntryL,G1H64(864),ex2(:),G1H32(864),m3h2x32(:,864),heltab2x64(:,:,864))
  call Hloop_AQ_V(ntryL,G1H64(865),ex2(:),G1H32(865),m3h2x32(:,865),heltab2x64(:,:,865))
  call Hloop_AQ_V(ntryL,G1H64(866),ex2(:),G1H32(866),m3h2x32(:,866),heltab2x64(:,:,866))
  call Hloop_AQ_Z(ntryL,G1H64(867),ex2(:),G1H32(867),ngZl,m3h2x32(:,867),heltab2x64(:,:,867))
  call Hloop_AQ_V(ntryL,G1H64(868),ex2(:),G1H32(868),m3h2x32(:,868),heltab2x64(:,:,868))
  call Hloop_AQ_Z(ntryL,G1H64(869),ex2(:),G1H32(869),ngZl,m3h2x32(:,869),heltab2x64(:,:,869))
  call Hloop_AQ_S(ntryL,G1H64(870),ex2(:),G1H32(870),ngH,m3h2x32(:,870),heltab2x64(:,:,870))
  call Hloop_AQ_S(ntryL,G1H64(871),ex2(:),G1H32(871),ngX,m3h2x32(:,871),heltab2x64(:,:,871))
  call Hloop_AQ_S(ntryL,G1H64(872),ex2(:),G1H32(872),ngH,m3h2x32(:,872),heltab2x64(:,:,872))
  call Hloop_AQ_S(ntryL,G1H64(873),ex2(:),G1H32(873),ngH,m3h2x32(:,873),heltab2x64(:,:,873))
  call Hloop_AQ_S(ntryL,G1H64(874),ex2(:),G1H32(874),ngX,m3h2x32(:,874),heltab2x64(:,:,874))
  call Hloop_AQ_S(ntryL,G1H64(875),ex2(:),G1H32(875),ngX,m3h2x32(:,875),heltab2x64(:,:,875))
  call Hloop_AQ_V(ntryL,G1H64(876),ex2(:),G1H32(876),m3h2x32(:,876),heltab2x64(:,:,876))
  call Hloop_AQ_V(ntryL,G1H64(877),ex2(:),G1H32(877),m3h2x32(:,877),heltab2x64(:,:,877))
  call Hloop_AQ_Z(ntryL,G1H64(878),ex2(:),G1H32(878),ngZl,m3h2x32(:,878),heltab2x64(:,:,878))
  call Hloop_AQ_V(ntryL,G1H64(879),ex2(:),G1H32(879),m3h2x32(:,879),heltab2x64(:,:,879))
  call Hloop_AQ_Z(ntryL,G1H64(880),ex2(:),G1H32(880),ngZl,m3h2x32(:,880),heltab2x64(:,:,880))
  call Hloop_AQ_V(ntryL,G1H64(881),ex2(:),G1H32(881),m3h2x32(:,881),heltab2x64(:,:,881))
  call Hloop_AQ_V(ntryL,G1H64(882),ex2(:),G1H32(882),m3h2x32(:,882),heltab2x64(:,:,882))
  call Hloop_AQ_V(ntryL,G1H64(883),ex2(:),G1H32(883),m3h2x32(:,883),heltab2x64(:,:,883))
  call Hloop_AQ_Z(ntryL,G1H64(884),ex2(:),G1H32(884),ngZl,m3h2x32(:,884),heltab2x64(:,:,884))
  call Hloop_AQ_V(ntryL,G1H64(885),ex2(:),G1H32(885),m3h2x32(:,885),heltab2x64(:,:,885))
  call Hloop_AQ_Z(ntryL,G1H64(886),ex2(:),G1H32(886),ngZl,m3h2x32(:,886),heltab2x64(:,:,886))
  call Hloop_AQ_V(ntryL,G1H64(887),ex2(:),G1H32(887),m3h2x32(:,887),heltab2x64(:,:,887))
  call Hloop_AQ_Z(ntryL,G1H64(888),ex2(:),G1H32(888),ngZl,m3h2x32(:,888),heltab2x64(:,:,888))
  call Hloop_AQ_V(ntryL,G1H64(889),ex5(:),G1H32(889),m3h2x32(:,889),heltab2x64(:,:,889))
  call Hloop_AQ_V(ntryL,G1H64(890),ex5(:),G1H32(890),m3h2x32(:,890),heltab2x64(:,:,890))
  call Hloop_AQ_V(ntryL,G1H64(891),ex5(:),G1H32(891),m3h2x32(:,891),heltab2x64(:,:,891))
  call Hloop_AQ_V(ntryL,G1H64(892),ex5(:),G1H32(892),m3h2x32(:,892),heltab2x64(:,:,892))
  call Hloop_AQ_S(ntryL,G1H64(893),ex5(:),G1H32(893),ngH,m3h2x32(:,893),heltab2x64(:,:,893))
  call Hloop_AQ_S(ntryL,G1H64(894),ex5(:),G1H32(894),ngX,m3h2x32(:,894),heltab2x64(:,:,894))
  call Hloop_AQ_S(ntryL,G1H64(895),ex5(:),G1H32(895),ngH,m3h2x32(:,895),heltab2x64(:,:,895))
  call Hloop_AQ_S(ntryL,G1H64(896),ex5(:),G1H32(896),ngX,m3h2x32(:,896),heltab2x64(:,:,896))
  call Hloop_AQ_S(ntryL,G1H64(897),ex5(:),G1H32(897),ngH,m3h2x32(:,897),heltab2x64(:,:,897))
  call Hloop_AQ_S(ntryL,G1H64(898),ex5(:),G1H32(898),ngX,m3h2x32(:,898),heltab2x64(:,:,898))
  call Hloop_AQ_S(ntryL,G1H64(899),ex5(:),G1H32(899),ngH,m3h2x32(:,899),heltab2x64(:,:,899))
  call Hloop_AQ_S(ntryL,G1H64(900),ex5(:),G1H32(900),ngX,m3h2x32(:,900),heltab2x64(:,:,900))
  call Hloop_AQ_V(ntryL,G1H64(901),ex5(:),G1H32(901),m3h2x32(:,901),heltab2x64(:,:,901))
  call Hloop_AQ_V(ntryL,G1H64(902),ex5(:),G1H32(902),m3h2x32(:,902),heltab2x64(:,:,902))
  call Hloop_AQ_Z(ntryL,G1H64(903),ex5(:),G1H32(903),ngZl,m3h2x32(:,903),heltab2x64(:,:,903))
  call Hloop_AQ_V(ntryL,G1H64(904),ex5(:),G1H32(904),m3h2x32(:,904),heltab2x64(:,:,904))
  call Hloop_AQ_Z(ntryL,G1H64(905),ex5(:),G1H32(905),ngZl,m3h2x32(:,905),heltab2x64(:,:,905))
  call Hloop_AQ_V(ntryL,G1H64(906),ex5(:),G1H32(906),m3h2x32(:,906),heltab2x64(:,:,906))
  call Hloop_AQ_V(ntryL,G1H64(907),ex5(:),G1H32(907),m3h2x32(:,907),heltab2x64(:,:,907))
  call Hloop_AQ_V(ntryL,G1H64(908),ex5(:),G1H32(908),m3h2x32(:,908),heltab2x64(:,:,908))
  call Hloop_AQ_Z(ntryL,G1H64(909),ex5(:),G1H32(909),ngZl,m3h2x32(:,909),heltab2x64(:,:,909))
  call Hloop_AQ_V(ntryL,G1H64(910),ex5(:),G1H32(910),m3h2x32(:,910),heltab2x64(:,:,910))
  call Hloop_AQ_Z(ntryL,G1H64(911),ex5(:),G1H32(911),ngZl,m3h2x32(:,911),heltab2x64(:,:,911))
  call Hloop_AQ_V(ntryL,G1H64(912),ex5(:),G1H32(912),m3h2x32(:,912),heltab2x64(:,:,912))
  call Hloop_AQ_S(ntryL,G1H64(913),ex5(:),G1H32(913),ngH,m3h2x32(:,913),heltab2x64(:,:,913))
  call Hloop_AQ_S(ntryL,G1H64(914),ex5(:),G1H32(914),ngX,m3h2x32(:,914),heltab2x64(:,:,914))
  call Hloop_AQ_S(ntryL,G1H64(915),ex5(:),G1H32(915),ngH,m3h2x32(:,915),heltab2x64(:,:,915))
  call Hloop_AQ_S(ntryL,G1H64(916),ex5(:),G1H32(916),ngH,m3h2x32(:,916),heltab2x64(:,:,916))
  call Hloop_AQ_S(ntryL,G1H64(917),ex5(:),G1H32(917),ngX,m3h2x32(:,917),heltab2x64(:,:,917))
  call Hloop_AQ_S(ntryL,G1H64(918),ex5(:),G1H32(918),ngX,m3h2x32(:,918),heltab2x64(:,:,918))
  call Hloop_AQ_V(ntryL,G1H64(919),ex5(:),G1H32(919),m3h2x32(:,919),heltab2x64(:,:,919))
  call Hloop_AQ_Z(ntryL,G1H64(920),ex5(:),G1H32(920),ngZl,m3h2x32(:,920),heltab2x64(:,:,920))
  call Hloop_AQ_V(ntryL,G1H64(921),ex5(:),G1H32(921),m3h2x32(:,921),heltab2x64(:,:,921))
  call Hloop_AQ_V(ntryL,G1H64(922),ex5(:),G1H32(922),m3h2x32(:,922),heltab2x64(:,:,922))
  call Hloop_AQ_Z(ntryL,G1H64(923),ex5(:),G1H32(923),ngZl,m3h2x32(:,923),heltab2x64(:,:,923))
  call Hloop_AQ_Z(ntryL,G1H64(924),ex5(:),G1H32(924),ngZl,m3h2x32(:,924),heltab2x64(:,:,924))
  call Hloop_AQ_V(ntryL,G1H64(925),ex5(:),G1H32(925),m3h2x32(:,925),heltab2x64(:,:,925))
  call Hloop_AQ_S(ntryL,G1H64(926),ex2(:),G1H32(926),ngH,m3h2x32(:,926),heltab2x64(:,:,926))
  call Hloop_AQ_S(ntryL,G1H64(927),ex2(:),G1H32(927),ngX,m3h2x32(:,927),heltab2x64(:,:,927))
  call Hloop_AQ_S(ntryL,G1H64(928),ex2(:),G1H32(928),ngH,m3h2x32(:,928),heltab2x64(:,:,928))
  call Hloop_AQ_S(ntryL,G1H64(929),ex2(:),G1H32(929),ngX,m3h2x32(:,929),heltab2x64(:,:,929))
  call Hloop_AQ_V(ntryL,G1H64(930),ex2(:),G1H32(930),m3h2x32(:,930),heltab2x64(:,:,930))
  call Hloop_AQ_V(ntryL,G1H64(931),ex2(:),G1H32(931),m3h2x32(:,931),heltab2x64(:,:,931))
  call Hloop_AQ_V(ntryL,G1H64(932),ex2(:),G1H32(932),m3h2x32(:,932),heltab2x64(:,:,932))
  call Hloop_AQ_V(ntryL,G1H64(933),ex2(:),G1H32(933),m3h2x32(:,933),heltab2x64(:,:,933))
  call Hloop_AQ_S(ntryL,G1H64(934),ex2(:),G1H32(934),ngH,m3h2x32(:,934),heltab2x64(:,:,934))
  call Hloop_AQ_S(ntryL,G1H64(935),ex2(:),G1H32(935),ngH,m3h2x32(:,935),heltab2x64(:,:,935))
  call Hloop_AQ_S(ntryL,G1H64(936),ex2(:),G1H32(936),ngX,m3h2x32(:,936),heltab2x64(:,:,936))
  call Hloop_AQ_S(ntryL,G1H64(937),ex2(:),G1H32(937),ngX,m3h2x32(:,937),heltab2x64(:,:,937))
  call Hloop_AQ_V(ntryL,G1H64(938),ex2(:),G1H32(938),m3h2x32(:,938),heltab2x64(:,:,938))
  call Hloop_AQ_V(ntryL,G1H64(939),ex2(:),G1H32(939),m3h2x32(:,939),heltab2x64(:,:,939))
  call Hloop_AQ_V(ntryL,G1H64(940),ex2(:),G1H32(940),m3h2x32(:,940),heltab2x64(:,:,940))
  call Hloop_AQ_Z(ntryL,G1H64(941),ex2(:),G1H32(941),ngZl,m3h2x32(:,941),heltab2x64(:,:,941))
  call Hloop_AQ_V(ntryL,G1H64(942),ex2(:),G1H32(942),m3h2x32(:,942),heltab2x64(:,:,942))
  call Hloop_AQ_Z(ntryL,G1H64(943),ex2(:),G1H32(943),ngZl,m3h2x32(:,943),heltab2x64(:,:,943))
  call Hloop_AQ_S(ntryL,G1H64(944),ex2(:),G1H32(944),ngH,m3h2x32(:,944),heltab2x64(:,:,944))
  call Hloop_AQ_S(ntryL,G1H64(945),ex2(:),G1H32(945),ngX,m3h2x32(:,945),heltab2x64(:,:,945))
  call Hloop_AQ_S(ntryL,G1H64(946),ex2(:),G1H32(946),ngH,m3h2x32(:,946),heltab2x64(:,:,946))
  call Hloop_AQ_S(ntryL,G1H64(947),ex2(:),G1H32(947),ngH,m3h2x32(:,947),heltab2x64(:,:,947))
  call Hloop_AQ_S(ntryL,G1H64(948),ex2(:),G1H32(948),ngX,m3h2x32(:,948),heltab2x64(:,:,948))
  call Hloop_AQ_S(ntryL,G1H64(949),ex2(:),G1H32(949),ngX,m3h2x32(:,949),heltab2x64(:,:,949))
  call Hloop_AQ_V(ntryL,G1H64(950),ex2(:),G1H32(950),m3h2x32(:,950),heltab2x64(:,:,950))
  call Hloop_AQ_V(ntryL,G1H64(951),ex2(:),G1H32(951),m3h2x32(:,951),heltab2x64(:,:,951))
  call Hloop_AQ_Z(ntryL,G1H64(952),ex2(:),G1H32(952),ngZl,m3h2x32(:,952),heltab2x64(:,:,952))
  call Hloop_AQ_V(ntryL,G1H64(953),ex2(:),G1H32(953),m3h2x32(:,953),heltab2x64(:,:,953))
  call Hloop_AQ_Z(ntryL,G1H64(954),ex2(:),G1H32(954),ngZl,m3h2x32(:,954),heltab2x64(:,:,954))
  call Hloop_AQ_V(ntryL,G1H64(955),ex2(:),G1H32(955),m3h2x32(:,955),heltab2x64(:,:,955))
  call Hloop_AQ_V(ntryL,G1H64(956),ex2(:),G1H32(956),m3h2x32(:,956),heltab2x64(:,:,956))
  call Hloop_AQ_V(ntryL,G1H64(957),ex2(:),G1H32(957),m3h2x32(:,957),heltab2x64(:,:,957))
  call Hloop_AQ_Z(ntryL,G1H64(958),ex2(:),G1H32(958),ngZl,m3h2x32(:,958),heltab2x64(:,:,958))
  call Hloop_AQ_V(ntryL,G1H64(959),ex2(:),G1H32(959),m3h2x32(:,959),heltab2x64(:,:,959))
  call Hloop_AQ_Z(ntryL,G1H64(960),ex2(:),G1H32(960),ngZl,m3h2x32(:,960),heltab2x64(:,:,960))
  call Hloop_AQ_V(ntryL,G1H64(961),ex2(:),G1H32(961),m3h2x32(:,961),heltab2x64(:,:,961))
  call Hloop_AQ_Z(ntryL,G1H64(962),ex2(:),G1H32(962),ngZl,m3h2x32(:,962),heltab2x64(:,:,962))
  call Hloop_AQ_S(ntryL,G1H64(963),ex5(:),G1H32(963),ngH,m3h2x32(:,963),heltab2x64(:,:,963))
  call Hloop_AQ_S(ntryL,G1H64(964),ex5(:),G1H32(964),ngX,m3h2x32(:,964),heltab2x64(:,:,964))
  call Hloop_AQ_S(ntryL,G1H64(965),ex5(:),G1H32(965),ngH,m3h2x32(:,965),heltab2x64(:,:,965))
  call Hloop_AQ_S(ntryL,G1H64(966),ex5(:),G1H32(966),ngX,m3h2x32(:,966),heltab2x64(:,:,966))
  call Hloop_AQ_V(ntryL,G1H64(967),ex5(:),G1H32(967),m3h2x32(:,967),heltab2x64(:,:,967))
  call Hloop_AQ_V(ntryL,G1H64(968),ex5(:),G1H32(968),m3h2x32(:,968),heltab2x64(:,:,968))
  call Hloop_AQ_V(ntryL,G1H64(969),ex5(:),G1H32(969),m3h2x32(:,969),heltab2x64(:,:,969))
  call Hloop_AQ_V(ntryL,G1H64(970),ex5(:),G1H32(970),m3h2x32(:,970),heltab2x64(:,:,970))
  call Hloop_AQ_S(ntryL,G1H64(971),ex5(:),G1H32(971),ngH,m3h2x32(:,971),heltab2x64(:,:,971))
  call Hloop_AQ_S(ntryL,G1H64(972),ex5(:),G1H32(972),ngH,m3h2x32(:,972),heltab2x64(:,:,972))
  call Hloop_AQ_S(ntryL,G1H64(973),ex5(:),G1H32(973),ngX,m3h2x32(:,973),heltab2x64(:,:,973))
  call Hloop_AQ_S(ntryL,G1H64(974),ex5(:),G1H32(974),ngX,m3h2x32(:,974),heltab2x64(:,:,974))
  call Hloop_AQ_V(ntryL,G1H64(975),ex5(:),G1H32(975),m3h2x32(:,975),heltab2x64(:,:,975))
  call Hloop_AQ_V(ntryL,G1H64(976),ex5(:),G1H32(976),m3h2x32(:,976),heltab2x64(:,:,976))
  call Hloop_AQ_V(ntryL,G1H64(977),ex5(:),G1H32(977),m3h2x32(:,977),heltab2x64(:,:,977))
  call Hloop_AQ_Z(ntryL,G1H64(978),ex5(:),G1H32(978),ngZl,m3h2x32(:,978),heltab2x64(:,:,978))
  call Hloop_AQ_V(ntryL,G1H64(979),ex5(:),G1H32(979),m3h2x32(:,979),heltab2x64(:,:,979))
  call Hloop_AQ_Z(ntryL,G1H64(980),ex5(:),G1H32(980),ngZl,m3h2x32(:,980),heltab2x64(:,:,980))
  call Hloop_AQ_S(ntryL,G1H64(981),ex5(:),G1H32(981),ngH,m3h2x32(:,981),heltab2x64(:,:,981))
  call Hloop_AQ_S(ntryL,G1H64(982),ex5(:),G1H32(982),ngX,m3h2x32(:,982),heltab2x64(:,:,982))
  call Hloop_AQ_S(ntryL,G1H64(983),ex5(:),G1H32(983),ngH,m3h2x32(:,983),heltab2x64(:,:,983))
  call Hloop_AQ_S(ntryL,G1H64(984),ex5(:),G1H32(984),ngH,m3h2x32(:,984),heltab2x64(:,:,984))
  call Hloop_AQ_S(ntryL,G1H64(985),ex5(:),G1H32(985),ngX,m3h2x32(:,985),heltab2x64(:,:,985))
  call Hloop_AQ_S(ntryL,G1H64(986),ex5(:),G1H32(986),ngX,m3h2x32(:,986),heltab2x64(:,:,986))
  call Hloop_AQ_V(ntryL,G1H64(987),ex5(:),G1H32(987),m3h2x32(:,987),heltab2x64(:,:,987))
  call Hloop_AQ_V(ntryL,G1H64(988),ex5(:),G1H32(988),m3h2x32(:,988),heltab2x64(:,:,988))
  call Hloop_AQ_Z(ntryL,G1H64(989),ex5(:),G1H32(989),ngZl,m3h2x32(:,989),heltab2x64(:,:,989))
  call Hloop_AQ_V(ntryL,G1H64(990),ex5(:),G1H32(990),m3h2x32(:,990),heltab2x64(:,:,990))
  call Hloop_AQ_Z(ntryL,G1H64(991),ex5(:),G1H32(991),ngZl,m3h2x32(:,991),heltab2x64(:,:,991))
  call Hloop_AQ_V(ntryL,G1H64(992),ex5(:),G1H32(992),m3h2x32(:,992),heltab2x64(:,:,992))
  call Hloop_AQ_V(ntryL,G1H64(993),ex5(:),G1H32(993),m3h2x32(:,993),heltab2x64(:,:,993))
  call Hloop_AQ_V(ntryL,G1H64(994),ex5(:),G1H32(994),m3h2x32(:,994),heltab2x64(:,:,994))
  call Hloop_AQ_Z(ntryL,G1H64(995),ex5(:),G1H32(995),ngZl,m3h2x32(:,995),heltab2x64(:,:,995))
  call Hloop_AQ_V(ntryL,G1H64(996),ex5(:),G1H32(996),m3h2x32(:,996),heltab2x64(:,:,996))
  call Hloop_AQ_Z(ntryL,G1H64(997),ex5(:),G1H32(997),ngZl,m3h2x32(:,997),heltab2x64(:,:,997))
  call Hloop_AQ_V(ntryL,G1H64(998),ex5(:),G1H32(998),m3h2x32(:,998),heltab2x64(:,:,998))
  call Hloop_AQ_Z(ntryL,G1H64(999),ex5(:),G1H32(999),ngZl,m3h2x32(:,999),heltab2x64(:,:,999))
  call Hloop_AQ_S(ntryL,G1H64(1000),ex2(:),G1H32(1000),ngH,m3h2x32(:,1000),heltab2x64(:,:,1000))
  call Hloop_AQ_S(ntryL,G1H64(1001),ex2(:),G1H32(1001),ngX,m3h2x32(:,1001),heltab2x64(:,:,1001))
  call Hloop_AQ_S(ntryL,G1H64(1002),ex2(:),G1H32(1002),ngH,m3h2x32(:,1002),heltab2x64(:,:,1002))
  call Hloop_AQ_S(ntryL,G1H64(1003),ex2(:),G1H32(1003),ngX,m3h2x32(:,1003),heltab2x64(:,:,1003))
  call Hloop_AQ_V(ntryL,G1H64(1004),ex2(:),G1H32(1004),m3h2x32(:,1004),heltab2x64(:,:,1004))
  call Hloop_AQ_V(ntryL,G1H64(1005),ex2(:),G1H32(1005),m3h2x32(:,1005),heltab2x64(:,:,1005))
  call Hloop_AQ_V(ntryL,G1H64(1006),ex2(:),G1H32(1006),m3h2x32(:,1006),heltab2x64(:,:,1006))
  call Hloop_AQ_V(ntryL,G1H64(1007),ex2(:),G1H32(1007),m3h2x32(:,1007),heltab2x64(:,:,1007))
  call Hloop_AQ_S(ntryL,G1H64(1008),ex2(:),G1H32(1008),ngH,m3h2x32(:,1008),heltab2x64(:,:,1008))
  call Hloop_AQ_S(ntryL,G1H64(1009),ex2(:),G1H32(1009),ngH,m3h2x32(:,1009),heltab2x64(:,:,1009))
  call Hloop_AQ_S(ntryL,G1H64(1010),ex2(:),G1H32(1010),ngX,m3h2x32(:,1010),heltab2x64(:,:,1010))
  call Hloop_AQ_S(ntryL,G1H64(1011),ex2(:),G1H32(1011),ngX,m3h2x32(:,1011),heltab2x64(:,:,1011))
  call Hloop_AQ_V(ntryL,G1H64(1012),ex2(:),G1H32(1012),m3h2x32(:,1012),heltab2x64(:,:,1012))
  call Hloop_AQ_V(ntryL,G1H64(1013),ex2(:),G1H32(1013),m3h2x32(:,1013),heltab2x64(:,:,1013))
  call Hloop_AQ_V(ntryL,G1H64(1014),ex2(:),G1H32(1014),m3h2x32(:,1014),heltab2x64(:,:,1014))
  call Hloop_AQ_Z(ntryL,G1H64(1015),ex2(:),G1H32(1015),ngZl,m3h2x32(:,1015),heltab2x64(:,:,1015))
  call Hloop_AQ_V(ntryL,G1H64(1016),ex2(:),G1H32(1016),m3h2x32(:,1016),heltab2x64(:,:,1016))
  call Hloop_AQ_Z(ntryL,G1H64(1017),ex2(:),G1H32(1017),ngZl,m3h2x32(:,1017),heltab2x64(:,:,1017))
  call Hloop_AQ_S(ntryL,G1H64(1018),ex2(:),G1H32(1018),ngH,m3h2x32(:,1018),heltab2x64(:,:,1018))
  call Hloop_AQ_S(ntryL,G1H64(1019),ex2(:),G1H32(1019),ngX,m3h2x32(:,1019),heltab2x64(:,:,1019))
  call Hloop_AQ_S(ntryL,G1H64(1020),ex2(:),G1H32(1020),ngH,m3h2x32(:,1020),heltab2x64(:,:,1020))
  call Hloop_AQ_S(ntryL,G1H64(1021),ex2(:),G1H32(1021),ngH,m3h2x32(:,1021),heltab2x64(:,:,1021))
  call Hloop_AQ_S(ntryL,G1H64(1022),ex2(:),G1H32(1022),ngX,m3h2x32(:,1022),heltab2x64(:,:,1022))
  call Hloop_AQ_S(ntryL,G1H64(1023),ex2(:),G1H32(1023),ngX,m3h2x32(:,1023),heltab2x64(:,:,1023))
  call Hloop_AQ_V(ntryL,G1H64(1024),ex2(:),G1H32(1024),m3h2x32(:,1024),heltab2x64(:,:,1024))
  call Hloop_AQ_V(ntryL,G1H64(1025),ex2(:),G1H32(1025),m3h2x32(:,1025),heltab2x64(:,:,1025))
  call Hloop_AQ_Z(ntryL,G1H64(1026),ex2(:),G1H32(1026),ngZl,m3h2x32(:,1026),heltab2x64(:,:,1026))
  call Hloop_AQ_V(ntryL,G1H64(1027),ex2(:),G1H32(1027),m3h2x32(:,1027),heltab2x64(:,:,1027))
  call Hloop_AQ_Z(ntryL,G1H64(1028),ex2(:),G1H32(1028),ngZl,m3h2x32(:,1028),heltab2x64(:,:,1028))
  call Hloop_AQ_V(ntryL,G1H64(1029),ex2(:),G1H32(1029),m3h2x32(:,1029),heltab2x64(:,:,1029))
  call Hloop_AQ_V(ntryL,G1H64(1030),ex2(:),G1H32(1030),m3h2x32(:,1030),heltab2x64(:,:,1030))
  call Hloop_AQ_V(ntryL,G1H64(1031),ex2(:),G1H32(1031),m3h2x32(:,1031),heltab2x64(:,:,1031))
  call Hloop_AQ_Z(ntryL,G1H64(1032),ex2(:),G1H32(1032),ngZl,m3h2x32(:,1032),heltab2x64(:,:,1032))
  call Hloop_AQ_V(ntryL,G1H64(1033),ex2(:),G1H32(1033),m3h2x32(:,1033),heltab2x64(:,:,1033))
  call Hloop_AQ_Z(ntryL,G1H64(1034),ex2(:),G1H32(1034),ngZl,m3h2x32(:,1034),heltab2x64(:,:,1034))
  call Hloop_AQ_V(ntryL,G1H64(1035),ex2(:),G1H32(1035),m3h2x32(:,1035),heltab2x64(:,:,1035))
  call Hloop_AQ_Z(ntryL,G1H64(1036),ex2(:),G1H32(1036),ngZl,m3h2x32(:,1036),heltab2x64(:,:,1036))
  call Hloop_AQ_S(ntryL,G1H64(1037),ex1(:),G1H32(1037),ngH,m3h2x32(:,1037),heltab2x64(:,:,1037))
  call Hloop_AQ_S(ntryL,G1H64(1038),ex1(:),G1H32(1038),ngH,m3h2x32(:,1038),heltab2x64(:,:,1038))
  call Hloop_AQ_S(ntryL,G1H64(1039),ex1(:),G1H32(1039),ngX,m3h2x32(:,1039),heltab2x64(:,:,1039))
  call Hloop_AQ_S(ntryL,G1H64(1040),ex1(:),G1H32(1040),ngX,m3h2x32(:,1040),heltab2x64(:,:,1040))
  call Hloop_AQ_S(ntryL,G1H64(1041),ex1(:),G1H32(1041),ngH,m3h2x32(:,1041),heltab2x64(:,:,1041))
  call Hloop_AQ_S(ntryL,G1H64(1042),ex1(:),G1H32(1042),ngH,m3h2x32(:,1042),heltab2x64(:,:,1042))
  call Hloop_AQ_S(ntryL,G1H64(1043),ex1(:),G1H32(1043),ngX,m3h2x32(:,1043),heltab2x64(:,:,1043))
  call Hloop_AQ_S(ntryL,G1H64(1044),ex1(:),G1H32(1044),ngX,m3h2x32(:,1044),heltab2x64(:,:,1044))
  call Hloop_AQ_V(ntryL,G1H64(1045),ex1(:),G1H32(1045),m3h2x32(:,1045),heltab2x64(:,:,1045))
  call Hloop_AQ_V(ntryL,G1H64(1046),ex1(:),G1H32(1046),m3h2x32(:,1046),heltab2x64(:,:,1046))
  call Hloop_AQ_V(ntryL,G1H64(1047),ex1(:),G1H32(1047),m3h2x32(:,1047),heltab2x64(:,:,1047))
  call Hloop_AQ_V(ntryL,G1H64(1048),ex1(:),G1H32(1048),m3h2x32(:,1048),heltab2x64(:,:,1048))
  call Hloop_AQ_S(ntryL,G1H64(1049),ex1(:),G1H32(1049),ngH,m3h2x32(:,1049),heltab2x64(:,:,1049))
  call Hloop_AQ_S(ntryL,G1H64(1050),ex1(:),G1H32(1050),ngX,m3h2x32(:,1050),heltab2x64(:,:,1050))
  call Hloop_AQ_S(ntryL,G1H64(1051),ex1(:),G1H32(1051),ngH,m3h2x32(:,1051),heltab2x64(:,:,1051))
  call Hloop_AQ_S(ntryL,G1H64(1052),ex1(:),G1H32(1052),ngH,m3h2x32(:,1052),heltab2x64(:,:,1052))
  call Hloop_AQ_S(ntryL,G1H64(1053),ex1(:),G1H32(1053),ngX,m3h2x32(:,1053),heltab2x64(:,:,1053))
  call Hloop_AQ_S(ntryL,G1H64(1054),ex1(:),G1H32(1054),ngX,m3h2x32(:,1054),heltab2x64(:,:,1054))
  call Hloop_AQ_V(ntryL,G1H64(1055),ex1(:),G1H32(1055),m3h2x32(:,1055),heltab2x64(:,:,1055))
  call Hloop_AQ_V(ntryL,G1H64(1056),ex1(:),G1H32(1056),m3h2x32(:,1056),heltab2x64(:,:,1056))
  call Hloop_AQ_V(ntryL,G1H64(1057),ex1(:),G1H32(1057),m3h2x32(:,1057),heltab2x64(:,:,1057))
  call Hloop_AQ_Z(ntryL,G1H64(1058),ex1(:),G1H32(1058),ngZl,m3h2x32(:,1058),heltab2x64(:,:,1058))
  call Hloop_AQ_V(ntryL,G1H64(1059),ex1(:),G1H32(1059),m3h2x32(:,1059),heltab2x64(:,:,1059))
  call Hloop_AQ_Z(ntryL,G1H64(1060),ex1(:),G1H32(1060),ngZl,m3h2x32(:,1060),heltab2x64(:,:,1060))
  call Hloop_AQ_V(ntryL,G1H64(1061),ex1(:),G1H32(1061),m3h2x32(:,1061),heltab2x64(:,:,1061))
  call Hloop_AQ_V(ntryL,G1H64(1062),ex1(:),G1H32(1062),m3h2x32(:,1062),heltab2x64(:,:,1062))
  call Hloop_AQ_V(ntryL,G1H64(1063),ex1(:),G1H32(1063),m3h2x32(:,1063),heltab2x64(:,:,1063))
  call Hloop_AQ_Z(ntryL,G1H64(1064),ex1(:),G1H32(1064),ngZl,m3h2x32(:,1064),heltab2x64(:,:,1064))
  call Hloop_AQ_V(ntryL,G1H64(1065),ex1(:),G1H32(1065),m3h2x32(:,1065),heltab2x64(:,:,1065))
  call Hloop_AQ_Z(ntryL,G1H64(1066),ex1(:),G1H32(1066),ngZl,m3h2x32(:,1066),heltab2x64(:,:,1066))
  call Hloop_AQ_V(ntryL,G1H64(1067),ex1(:),G1H32(1067),m3h2x32(:,1067),heltab2x64(:,:,1067))
  call Hloop_AQ_V(ntryL,G1H64(1068),ex1(:),G1H32(1068),m3h2x32(:,1068),heltab2x64(:,:,1068))
  call Hloop_AQ_V(ntryL,G1H64(1069),ex1(:),G1H32(1069),m3h2x32(:,1069),heltab2x64(:,:,1069))
  call Hloop_AQ_Z(ntryL,G1H64(1070),ex1(:),G1H32(1070),ngZl,m3h2x32(:,1070),heltab2x64(:,:,1070))
  call Hloop_AQ_V(ntryL,G1H64(1071),ex1(:),G1H32(1071),m3h2x32(:,1071),heltab2x64(:,:,1071))
  call Hloop_AQ_Z(ntryL,G1H64(1072),ex1(:),G1H32(1072),ngZl,m3h2x32(:,1072),heltab2x64(:,:,1072))
  call Hloop_AQ_Z(ntryL,G1H64(1073),ex1(:),G1H32(1073),ngZl,m3h2x32(:,1073),heltab2x64(:,:,1073))
  call Hloop_AQ_S(ntryL,G1H64(1074),ex1(:),G1H32(1074),ngH,m3h2x32(:,1074),heltab2x64(:,:,1074))
  call Hloop_AQ_S(ntryL,G1H64(1075),ex1(:),G1H32(1075),ngH,m3h2x32(:,1075),heltab2x64(:,:,1075))
  call Hloop_AQ_S(ntryL,G1H64(1076),ex1(:),G1H32(1076),ngX,m3h2x32(:,1076),heltab2x64(:,:,1076))
  call Hloop_AQ_S(ntryL,G1H64(1077),ex1(:),G1H32(1077),ngX,m3h2x32(:,1077),heltab2x64(:,:,1077))
  call Hloop_AQ_S(ntryL,G1H64(1078),ex1(:),G1H32(1078),ngH,m3h2x32(:,1078),heltab2x64(:,:,1078))
  call Hloop_AQ_S(ntryL,G1H64(1079),ex1(:),G1H32(1079),ngH,m3h2x32(:,1079),heltab2x64(:,:,1079))
  call Hloop_AQ_S(ntryL,G1H64(1080),ex1(:),G1H32(1080),ngX,m3h2x32(:,1080),heltab2x64(:,:,1080))
  call Hloop_AQ_S(ntryL,G1H64(1081),ex1(:),G1H32(1081),ngX,m3h2x32(:,1081),heltab2x64(:,:,1081))
  call Hloop_AQ_V(ntryL,G1H64(1082),ex1(:),G1H32(1082),m3h2x32(:,1082),heltab2x64(:,:,1082))
  call Hloop_AQ_V(ntryL,G1H64(1083),ex1(:),G1H32(1083),m3h2x32(:,1083),heltab2x64(:,:,1083))
  call Hloop_AQ_V(ntryL,G1H64(1084),ex1(:),G1H32(1084),m3h2x32(:,1084),heltab2x64(:,:,1084))
  call Hloop_AQ_V(ntryL,G1H64(1085),ex1(:),G1H32(1085),m3h2x32(:,1085),heltab2x64(:,:,1085))
  call Hloop_AQ_S(ntryL,G1H64(1086),ex1(:),G1H32(1086),ngH,m3h2x32(:,1086),heltab2x64(:,:,1086))
  call Hloop_AQ_S(ntryL,G1H64(1087),ex1(:),G1H32(1087),ngX,m3h2x32(:,1087),heltab2x64(:,:,1087))
  call Hloop_AQ_S(ntryL,G1H64(1088),ex1(:),G1H32(1088),ngH,m3h2x32(:,1088),heltab2x64(:,:,1088))
  call Hloop_AQ_S(ntryL,G1H64(1089),ex1(:),G1H32(1089),ngH,m3h2x32(:,1089),heltab2x64(:,:,1089))
  call Hloop_AQ_S(ntryL,G1H64(1090),ex1(:),G1H32(1090),ngX,m3h2x32(:,1090),heltab2x64(:,:,1090))
  call Hloop_AQ_S(ntryL,G1H64(1091),ex1(:),G1H32(1091),ngX,m3h2x32(:,1091),heltab2x64(:,:,1091))
  call Hloop_AQ_V(ntryL,G1H64(1092),ex1(:),G1H32(1092),m3h2x32(:,1092),heltab2x64(:,:,1092))
  call Hloop_AQ_V(ntryL,G1H64(1093),ex1(:),G1H32(1093),m3h2x32(:,1093),heltab2x64(:,:,1093))
  call Hloop_AQ_V(ntryL,G1H64(1094),ex1(:),G1H32(1094),m3h2x32(:,1094),heltab2x64(:,:,1094))
  call Hloop_AQ_Z(ntryL,G1H64(1095),ex1(:),G1H32(1095),ngZl,m3h2x32(:,1095),heltab2x64(:,:,1095))
  call Hloop_AQ_V(ntryL,G1H64(1096),ex1(:),G1H32(1096),m3h2x32(:,1096),heltab2x64(:,:,1096))
  call Hloop_AQ_Z(ntryL,G1H64(1097),ex1(:),G1H32(1097),ngZl,m3h2x32(:,1097),heltab2x64(:,:,1097))
  call Hloop_AQ_V(ntryL,G1H64(1098),ex1(:),G1H32(1098),m3h2x32(:,1098),heltab2x64(:,:,1098))
  call Hloop_AQ_V(ntryL,G1H64(1099),ex1(:),G1H32(1099),m3h2x32(:,1099),heltab2x64(:,:,1099))
  call Hloop_AQ_V(ntryL,G1H64(1100),ex1(:),G1H32(1100),m3h2x32(:,1100),heltab2x64(:,:,1100))
  call Hloop_AQ_Z(ntryL,G1H64(1101),ex1(:),G1H32(1101),ngZl,m3h2x32(:,1101),heltab2x64(:,:,1101))
  call Hloop_AQ_V(ntryL,G1H64(1102),ex1(:),G1H32(1102),m3h2x32(:,1102),heltab2x64(:,:,1102))
  call Hloop_AQ_Z(ntryL,G1H64(1103),ex1(:),G1H32(1103),ngZl,m3h2x32(:,1103),heltab2x64(:,:,1103))
  call Hloop_AQ_V(ntryL,G1H64(1104),ex1(:),G1H32(1104),m3h2x32(:,1104),heltab2x64(:,:,1104))
  call Hloop_AQ_V(ntryL,G1H64(1105),ex1(:),G1H32(1105),m3h2x32(:,1105),heltab2x64(:,:,1105))
  call Hloop_AQ_V(ntryL,G1H64(1106),ex1(:),G1H32(1106),m3h2x32(:,1106),heltab2x64(:,:,1106))
  call Hloop_AQ_Z(ntryL,G1H64(1107),ex1(:),G1H32(1107),ngZl,m3h2x32(:,1107),heltab2x64(:,:,1107))
  call Hloop_AQ_V(ntryL,G1H64(1108),ex1(:),G1H32(1108),m3h2x32(:,1108),heltab2x64(:,:,1108))
  call Hloop_AQ_Z(ntryL,G1H64(1109),ex1(:),G1H32(1109),ngZl,m3h2x32(:,1109),heltab2x64(:,:,1109))
  call Hloop_AQ_Z(ntryL,G1H64(1110),ex1(:),G1H32(1110),ngZl,m3h2x32(:,1110),heltab2x64(:,:,1110))
  call Hloop_AQ_S(ntryL,G1H64(1111),ex5(:),G1H32(1111),ngH,m3h2x32(:,1111),heltab2x64(:,:,1111))
  call Hloop_AQ_S(ntryL,G1H64(1112),ex5(:),G1H32(1112),ngH,m3h2x32(:,1112),heltab2x64(:,:,1112))
  call Hloop_AQ_S(ntryL,G1H64(1113),ex5(:),G1H32(1113),ngX,m3h2x32(:,1113),heltab2x64(:,:,1113))
  call Hloop_AQ_S(ntryL,G1H64(1114),ex5(:),G1H32(1114),ngX,m3h2x32(:,1114),heltab2x64(:,:,1114))
  call Hloop_AQ_S(ntryL,G1H64(1115),ex5(:),G1H32(1115),ngH,m3h2x32(:,1115),heltab2x64(:,:,1115))
  call Hloop_AQ_S(ntryL,G1H64(1116),ex5(:),G1H32(1116),ngH,m3h2x32(:,1116),heltab2x64(:,:,1116))
  call Hloop_AQ_S(ntryL,G1H64(1117),ex5(:),G1H32(1117),ngX,m3h2x32(:,1117),heltab2x64(:,:,1117))
  call Hloop_AQ_S(ntryL,G1H64(1118),ex5(:),G1H32(1118),ngX,m3h2x32(:,1118),heltab2x64(:,:,1118))
  call Hloop_AQ_V(ntryL,G1H64(1119),ex5(:),G1H32(1119),m3h2x32(:,1119),heltab2x64(:,:,1119))
  call Hloop_AQ_V(ntryL,G1H64(1120),ex5(:),G1H32(1120),m3h2x32(:,1120),heltab2x64(:,:,1120))
  call Hloop_AQ_V(ntryL,G1H64(1121),ex5(:),G1H32(1121),m3h2x32(:,1121),heltab2x64(:,:,1121))
  call Hloop_AQ_V(ntryL,G1H64(1122),ex5(:),G1H32(1122),m3h2x32(:,1122),heltab2x64(:,:,1122))
  call Hloop_AQ_S(ntryL,G1H64(1123),ex5(:),G1H32(1123),ngH,m3h2x32(:,1123),heltab2x64(:,:,1123))
  call Hloop_AQ_S(ntryL,G1H64(1124),ex5(:),G1H32(1124),ngX,m3h2x32(:,1124),heltab2x64(:,:,1124))
  call Hloop_AQ_S(ntryL,G1H64(1125),ex5(:),G1H32(1125),ngH,m3h2x32(:,1125),heltab2x64(:,:,1125))
  call Hloop_AQ_S(ntryL,G1H64(1126),ex5(:),G1H32(1126),ngH,m3h2x32(:,1126),heltab2x64(:,:,1126))
  call Hloop_AQ_S(ntryL,G1H64(1127),ex5(:),G1H32(1127),ngX,m3h2x32(:,1127),heltab2x64(:,:,1127))
  call Hloop_AQ_S(ntryL,G1H64(1128),ex5(:),G1H32(1128),ngX,m3h2x32(:,1128),heltab2x64(:,:,1128))
  call Hloop_AQ_V(ntryL,G1H64(1129),ex5(:),G1H32(1129),m3h2x32(:,1129),heltab2x64(:,:,1129))
  call Hloop_AQ_V(ntryL,G1H64(1130),ex5(:),G1H32(1130),m3h2x32(:,1130),heltab2x64(:,:,1130))
  call Hloop_AQ_V(ntryL,G1H64(1131),ex5(:),G1H32(1131),m3h2x32(:,1131),heltab2x64(:,:,1131))
  call Hloop_AQ_Z(ntryL,G1H64(1132),ex5(:),G1H32(1132),ngZl,m3h2x32(:,1132),heltab2x64(:,:,1132))
  call Hloop_AQ_V(ntryL,G1H64(1133),ex5(:),G1H32(1133),m3h2x32(:,1133),heltab2x64(:,:,1133))
  call Hloop_AQ_Z(ntryL,G1H64(1134),ex5(:),G1H32(1134),ngZl,m3h2x32(:,1134),heltab2x64(:,:,1134))
  call Hloop_AQ_V(ntryL,G1H64(1135),ex5(:),G1H32(1135),m3h2x32(:,1135),heltab2x64(:,:,1135))
  call Hloop_AQ_V(ntryL,G1H64(1136),ex5(:),G1H32(1136),m3h2x32(:,1136),heltab2x64(:,:,1136))
  call Hloop_AQ_V(ntryL,G1H64(1137),ex5(:),G1H32(1137),m3h2x32(:,1137),heltab2x64(:,:,1137))
  call Hloop_AQ_Z(ntryL,G1H64(1138),ex5(:),G1H32(1138),ngZl,m3h2x32(:,1138),heltab2x64(:,:,1138))
  call Hloop_AQ_V(ntryL,G1H64(1139),ex5(:),G1H32(1139),m3h2x32(:,1139),heltab2x64(:,:,1139))
  call Hloop_AQ_Z(ntryL,G1H64(1140),ex5(:),G1H32(1140),ngZl,m3h2x32(:,1140),heltab2x64(:,:,1140))
  call Hloop_AQ_V(ntryL,G1H64(1141),ex5(:),G1H32(1141),m3h2x32(:,1141),heltab2x64(:,:,1141))
  call Hloop_AQ_V(ntryL,G1H64(1142),ex5(:),G1H32(1142),m3h2x32(:,1142),heltab2x64(:,:,1142))
  call Hloop_AQ_V(ntryL,G1H64(1143),ex5(:),G1H32(1143),m3h2x32(:,1143),heltab2x64(:,:,1143))
  call Hloop_AQ_Z(ntryL,G1H64(1144),ex5(:),G1H32(1144),ngZl,m3h2x32(:,1144),heltab2x64(:,:,1144))
  call Hloop_AQ_V(ntryL,G1H64(1145),ex5(:),G1H32(1145),m3h2x32(:,1145),heltab2x64(:,:,1145))
  call Hloop_AQ_Z(ntryL,G1H64(1146),ex5(:),G1H32(1146),ngZl,m3h2x32(:,1146),heltab2x64(:,:,1146))
  call Hloop_AQ_Z(ntryL,G1H64(1147),ex5(:),G1H32(1147),ngZl,m3h2x32(:,1147),heltab2x64(:,:,1147))
  call Hloop_AQ_S(ntryL,G1H64(1148),ex5(:),G1H32(1148),ngH,m3h2x32(:,1148),heltab2x64(:,:,1148))
  call Hloop_AQ_S(ntryL,G1H64(1149),ex5(:),G1H32(1149),ngH,m3h2x32(:,1149),heltab2x64(:,:,1149))
  call Hloop_AQ_S(ntryL,G1H64(1150),ex5(:),G1H32(1150),ngX,m3h2x32(:,1150),heltab2x64(:,:,1150))
  call Hloop_AQ_S(ntryL,G1H64(1151),ex5(:),G1H32(1151),ngX,m3h2x32(:,1151),heltab2x64(:,:,1151))
  call Hloop_AQ_S(ntryL,G1H64(1152),ex5(:),G1H32(1152),ngH,m3h2x32(:,1152),heltab2x64(:,:,1152))
  call Hloop_AQ_S(ntryL,G1H64(1153),ex5(:),G1H32(1153),ngH,m3h2x32(:,1153),heltab2x64(:,:,1153))
  call Hloop_AQ_S(ntryL,G1H64(1154),ex5(:),G1H32(1154),ngX,m3h2x32(:,1154),heltab2x64(:,:,1154))
  call Hloop_AQ_S(ntryL,G1H64(1155),ex5(:),G1H32(1155),ngX,m3h2x32(:,1155),heltab2x64(:,:,1155))
  call Hloop_AQ_V(ntryL,G1H64(1156),ex5(:),G1H32(1156),m3h2x32(:,1156),heltab2x64(:,:,1156))
  call Hloop_AQ_V(ntryL,G1H64(1157),ex5(:),G1H32(1157),m3h2x32(:,1157),heltab2x64(:,:,1157))
  call Hloop_AQ_V(ntryL,G1H64(1158),ex5(:),G1H32(1158),m3h2x32(:,1158),heltab2x64(:,:,1158))
  call Hloop_AQ_V(ntryL,G1H64(1159),ex5(:),G1H32(1159),m3h2x32(:,1159),heltab2x64(:,:,1159))
  call Hloop_AQ_S(ntryL,G1H64(1160),ex5(:),G1H32(1160),ngH,m3h2x32(:,1160),heltab2x64(:,:,1160))
  call Hloop_AQ_S(ntryL,G1H64(1161),ex5(:),G1H32(1161),ngX,m3h2x32(:,1161),heltab2x64(:,:,1161))
  call Hloop_AQ_S(ntryL,G1H64(1162),ex5(:),G1H32(1162),ngH,m3h2x32(:,1162),heltab2x64(:,:,1162))
  call Hloop_AQ_S(ntryL,G1H64(1163),ex5(:),G1H32(1163),ngH,m3h2x32(:,1163),heltab2x64(:,:,1163))
  call Hloop_AQ_S(ntryL,G1H64(1164),ex5(:),G1H32(1164),ngX,m3h2x32(:,1164),heltab2x64(:,:,1164))
  call Hloop_AQ_S(ntryL,G1H64(1165),ex5(:),G1H32(1165),ngX,m3h2x32(:,1165),heltab2x64(:,:,1165))
  call Hloop_AQ_V(ntryL,G1H64(1166),ex5(:),G1H32(1166),m3h2x32(:,1166),heltab2x64(:,:,1166))
  call Hloop_AQ_V(ntryL,G1H64(1167),ex5(:),G1H32(1167),m3h2x32(:,1167),heltab2x64(:,:,1167))
  call Hloop_AQ_V(ntryL,G1H64(1168),ex5(:),G1H32(1168),m3h2x32(:,1168),heltab2x64(:,:,1168))
  call Hloop_AQ_Z(ntryL,G1H64(1169),ex5(:),G1H32(1169),ngZl,m3h2x32(:,1169),heltab2x64(:,:,1169))
  call Hloop_AQ_V(ntryL,G1H64(1170),ex5(:),G1H32(1170),m3h2x32(:,1170),heltab2x64(:,:,1170))
  call Hloop_AQ_Z(ntryL,G1H64(1171),ex5(:),G1H32(1171),ngZl,m3h2x32(:,1171),heltab2x64(:,:,1171))
  call Hloop_AQ_V(ntryL,G1H64(1172),ex5(:),G1H32(1172),m3h2x32(:,1172),heltab2x64(:,:,1172))
  call Hloop_AQ_V(ntryL,G1H64(1173),ex5(:),G1H32(1173),m3h2x32(:,1173),heltab2x64(:,:,1173))
  call Hloop_AQ_V(ntryL,G1H64(1174),ex5(:),G1H32(1174),m3h2x32(:,1174),heltab2x64(:,:,1174))
  call Hloop_AQ_Z(ntryL,G1H64(1175),ex5(:),G1H32(1175),ngZl,m3h2x32(:,1175),heltab2x64(:,:,1175))
  call Hloop_AQ_V(ntryL,G1H64(1176),ex5(:),G1H32(1176),m3h2x32(:,1176),heltab2x64(:,:,1176))
  call Hloop_AQ_Z(ntryL,G1H64(1177),ex5(:),G1H32(1177),ngZl,m3h2x32(:,1177),heltab2x64(:,:,1177))
  call Hloop_AQ_V(ntryL,G1H64(1178),ex5(:),G1H32(1178),m3h2x32(:,1178),heltab2x64(:,:,1178))
  call Hloop_AQ_V(ntryL,G1H64(1179),ex5(:),G1H32(1179),m3h2x32(:,1179),heltab2x64(:,:,1179))
  call Hloop_AQ_V(ntryL,G1H64(1180),ex5(:),G1H32(1180),m3h2x32(:,1180),heltab2x64(:,:,1180))
  call Hloop_AQ_Z(ntryL,G1H64(1181),ex5(:),G1H32(1181),ngZl,m3h2x32(:,1181),heltab2x64(:,:,1181))
  call Hloop_AQ_V(ntryL,G1H64(1182),ex5(:),G1H32(1182),m3h2x32(:,1182),heltab2x64(:,:,1182))
  call Hloop_AQ_Z(ntryL,G1H64(1183),ex5(:),G1H32(1183),ngZl,m3h2x32(:,1183),heltab2x64(:,:,1183))
  call Hloop_AQ_Z(ntryL,G1H64(1184),ex5(:),G1H32(1184),ngZl,m3h2x32(:,1184),heltab2x64(:,:,1184))
  call Hloop_AQ_S(ntryL,G1H64(1185),ex2(:),G1H32(1185),ngH,m3h2x32(:,1185),heltab2x64(:,:,1185))
  call Hloop_AQ_S(ntryL,G1H64(1186),ex2(:),G1H32(1186),ngX,m3h2x32(:,1186),heltab2x64(:,:,1186))
  call Hloop_AQ_S(ntryL,G1H64(1187),ex2(:),G1H32(1187),ngH,m3h2x32(:,1187),heltab2x64(:,:,1187))
  call Hloop_AQ_S(ntryL,G1H64(1188),ex2(:),G1H32(1188),ngX,m3h2x32(:,1188),heltab2x64(:,:,1188))
  call Hloop_AQ_V(ntryL,G1H64(1189),ex2(:),G1H32(1189),m3h2x32(:,1189),heltab2x64(:,:,1189))
  call Hloop_AQ_V(ntryL,G1H64(1190),ex2(:),G1H32(1190),m3h2x32(:,1190),heltab2x64(:,:,1190))
  call Hloop_AQ_V(ntryL,G1H64(1191),ex2(:),G1H32(1191),m3h2x32(:,1191),heltab2x64(:,:,1191))
  call Hloop_AQ_V(ntryL,G1H64(1192),ex2(:),G1H32(1192),m3h2x32(:,1192),heltab2x64(:,:,1192))
  call Hloop_AQ_S(ntryL,G1H64(1193),ex2(:),G1H32(1193),ngH,m3h2x32(:,1193),heltab2x64(:,:,1193))
  call Hloop_AQ_S(ntryL,G1H64(1194),ex2(:),G1H32(1194),ngH,m3h2x32(:,1194),heltab2x64(:,:,1194))
  call Hloop_AQ_S(ntryL,G1H64(1195),ex2(:),G1H32(1195),ngX,m3h2x32(:,1195),heltab2x64(:,:,1195))
  call Hloop_AQ_S(ntryL,G1H64(1196),ex2(:),G1H32(1196),ngX,m3h2x32(:,1196),heltab2x64(:,:,1196))
  call Hloop_AQ_V(ntryL,G1H64(1197),ex2(:),G1H32(1197),m3h2x32(:,1197),heltab2x64(:,:,1197))
  call Hloop_AQ_V(ntryL,G1H64(1198),ex2(:),G1H32(1198),m3h2x32(:,1198),heltab2x64(:,:,1198))
  call Hloop_AQ_V(ntryL,G1H64(1199),ex2(:),G1H32(1199),m3h2x32(:,1199),heltab2x64(:,:,1199))
  call Hloop_AQ_Z(ntryL,G1H64(1200),ex2(:),G1H32(1200),ngZl,m3h2x32(:,1200),heltab2x64(:,:,1200))
  call Hloop_AQ_V(ntryL,G1H64(1201),ex2(:),G1H32(1201),m3h2x32(:,1201),heltab2x64(:,:,1201))
  call Hloop_AQ_Z(ntryL,G1H64(1202),ex2(:),G1H32(1202),ngZl,m3h2x32(:,1202),heltab2x64(:,:,1202))
  call Hloop_AQ_S(ntryL,G1H64(1203),ex2(:),G1H32(1203),ngH,m3h2x32(:,1203),heltab2x64(:,:,1203))
  call Hloop_AQ_S(ntryL,G1H64(1204),ex2(:),G1H32(1204),ngX,m3h2x32(:,1204),heltab2x64(:,:,1204))
  call Hloop_AQ_S(ntryL,G1H64(1205),ex2(:),G1H32(1205),ngH,m3h2x32(:,1205),heltab2x64(:,:,1205))
  call Hloop_AQ_S(ntryL,G1H64(1206),ex2(:),G1H32(1206),ngH,m3h2x32(:,1206),heltab2x64(:,:,1206))
  call Hloop_AQ_S(ntryL,G1H64(1207),ex2(:),G1H32(1207),ngX,m3h2x32(:,1207),heltab2x64(:,:,1207))
  call Hloop_AQ_S(ntryL,G1H64(1208),ex2(:),G1H32(1208),ngX,m3h2x32(:,1208),heltab2x64(:,:,1208))
  call Hloop_AQ_V(ntryL,G1H64(1209),ex2(:),G1H32(1209),m3h2x32(:,1209),heltab2x64(:,:,1209))
  call Hloop_AQ_V(ntryL,G1H64(1210),ex2(:),G1H32(1210),m3h2x32(:,1210),heltab2x64(:,:,1210))
  call Hloop_AQ_Z(ntryL,G1H64(1211),ex2(:),G1H32(1211),ngZl,m3h2x32(:,1211),heltab2x64(:,:,1211))
  call Hloop_AQ_V(ntryL,G1H64(1212),ex2(:),G1H32(1212),m3h2x32(:,1212),heltab2x64(:,:,1212))
  call Hloop_AQ_Z(ntryL,G1H64(1213),ex2(:),G1H32(1213),ngZl,m3h2x32(:,1213),heltab2x64(:,:,1213))
  call Hloop_AQ_V(ntryL,G1H64(1214),ex2(:),G1H32(1214),m3h2x32(:,1214),heltab2x64(:,:,1214))
  call Hloop_AQ_V(ntryL,G1H64(1215),ex2(:),G1H32(1215),m3h2x32(:,1215),heltab2x64(:,:,1215))
  call Hloop_AQ_V(ntryL,G1H64(1216),ex2(:),G1H32(1216),m3h2x32(:,1216),heltab2x64(:,:,1216))
  call Hloop_AQ_Z(ntryL,G1H64(1217),ex2(:),G1H32(1217),ngZl,m3h2x32(:,1217),heltab2x64(:,:,1217))
  call Hloop_AQ_V(ntryL,G1H64(1218),ex2(:),G1H32(1218),m3h2x32(:,1218),heltab2x64(:,:,1218))
  call Hloop_AQ_Z(ntryL,G1H64(1219),ex2(:),G1H32(1219),ngZl,m3h2x32(:,1219),heltab2x64(:,:,1219))
  call Hloop_AQ_V(ntryL,G1H64(1220),ex2(:),G1H32(1220),m3h2x32(:,1220),heltab2x64(:,:,1220))
  call Hloop_AQ_Z(ntryL,G1H64(1221),ex2(:),G1H32(1221),ngZl,m3h2x32(:,1221),heltab2x64(:,:,1221))
  call Hloop_AQ_S(ntryL,G1H64(1222),ex2(:),G1H32(1222),ngH,m3h2x32(:,1222),heltab2x64(:,:,1222))
  call Hloop_AQ_S(ntryL,G1H64(1223),ex2(:),G1H32(1223),ngX,m3h2x32(:,1223),heltab2x64(:,:,1223))
  call Hloop_AQ_S(ntryL,G1H64(1224),ex2(:),G1H32(1224),ngH,m3h2x32(:,1224),heltab2x64(:,:,1224))
  call Hloop_AQ_S(ntryL,G1H64(1225),ex2(:),G1H32(1225),ngX,m3h2x32(:,1225),heltab2x64(:,:,1225))
  call Hloop_AQ_V(ntryL,G1H64(1226),ex2(:),G1H32(1226),m3h2x32(:,1226),heltab2x64(:,:,1226))
  call Hloop_AQ_V(ntryL,G1H64(1227),ex2(:),G1H32(1227),m3h2x32(:,1227),heltab2x64(:,:,1227))
  call Hloop_AQ_V(ntryL,G1H64(1228),ex2(:),G1H32(1228),m3h2x32(:,1228),heltab2x64(:,:,1228))
  call Hloop_AQ_V(ntryL,G1H64(1229),ex2(:),G1H32(1229),m3h2x32(:,1229),heltab2x64(:,:,1229))
  call Hloop_AQ_S(ntryL,G1H64(1230),ex2(:),G1H32(1230),ngH,m3h2x32(:,1230),heltab2x64(:,:,1230))
  call Hloop_AQ_S(ntryL,G1H64(1231),ex2(:),G1H32(1231),ngH,m3h2x32(:,1231),heltab2x64(:,:,1231))
  call Hloop_AQ_S(ntryL,G1H64(1232),ex2(:),G1H32(1232),ngX,m3h2x32(:,1232),heltab2x64(:,:,1232))
  call Hloop_AQ_S(ntryL,G1H64(1233),ex2(:),G1H32(1233),ngX,m3h2x32(:,1233),heltab2x64(:,:,1233))
  call Hloop_AQ_V(ntryL,G1H64(1234),ex2(:),G1H32(1234),m3h2x32(:,1234),heltab2x64(:,:,1234))
  call Hloop_AQ_V(ntryL,G1H64(1235),ex2(:),G1H32(1235),m3h2x32(:,1235),heltab2x64(:,:,1235))
  call Hloop_AQ_V(ntryL,G1H64(1236),ex2(:),G1H32(1236),m3h2x32(:,1236),heltab2x64(:,:,1236))
  call Hloop_AQ_Z(ntryL,G1H64(1237),ex2(:),G1H32(1237),ngZl,m3h2x32(:,1237),heltab2x64(:,:,1237))
  call Hloop_AQ_V(ntryL,G1H64(1238),ex2(:),G1H32(1238),m3h2x32(:,1238),heltab2x64(:,:,1238))
  call Hloop_AQ_Z(ntryL,G1H64(1239),ex2(:),G1H32(1239),ngZl,m3h2x32(:,1239),heltab2x64(:,:,1239))
  call Hloop_AQ_S(ntryL,G1H64(1240),ex2(:),G1H32(1240),ngH,m3h2x32(:,1240),heltab2x64(:,:,1240))
  call Hloop_AQ_S(ntryL,G1H64(1241),ex2(:),G1H32(1241),ngX,m3h2x32(:,1241),heltab2x64(:,:,1241))
  call Hloop_AQ_S(ntryL,G1H64(1242),ex2(:),G1H32(1242),ngH,m3h2x32(:,1242),heltab2x64(:,:,1242))
  call Hloop_AQ_S(ntryL,G1H64(1243),ex2(:),G1H32(1243),ngH,m3h2x32(:,1243),heltab2x64(:,:,1243))
  call Hloop_AQ_S(ntryL,G1H64(1244),ex2(:),G1H32(1244),ngX,m3h2x32(:,1244),heltab2x64(:,:,1244))
  call Hloop_AQ_S(ntryL,G1H64(1245),ex2(:),G1H32(1245),ngX,m3h2x32(:,1245),heltab2x64(:,:,1245))
  call Hloop_AQ_V(ntryL,G1H64(1246),ex2(:),G1H32(1246),m3h2x32(:,1246),heltab2x64(:,:,1246))
  call Hloop_AQ_V(ntryL,G1H64(1247),ex2(:),G1H32(1247),m3h2x32(:,1247),heltab2x64(:,:,1247))
  call Hloop_AQ_Z(ntryL,G1H64(1248),ex2(:),G1H32(1248),ngZl,m3h2x32(:,1248),heltab2x64(:,:,1248))
  call Hloop_AQ_V(ntryL,G1H64(1249),ex2(:),G1H32(1249),m3h2x32(:,1249),heltab2x64(:,:,1249))
  call Hloop_AQ_Z(ntryL,G1H64(1250),ex2(:),G1H32(1250),ngZl,m3h2x32(:,1250),heltab2x64(:,:,1250))
  call Hloop_AQ_V(ntryL,G1H64(1251),ex2(:),G1H32(1251),m3h2x32(:,1251),heltab2x64(:,:,1251))
  call Hloop_AQ_V(ntryL,G1H64(1252),ex2(:),G1H32(1252),m3h2x32(:,1252),heltab2x64(:,:,1252))
  call Hloop_AQ_V(ntryL,G1H64(1253),ex2(:),G1H32(1253),m3h2x32(:,1253),heltab2x64(:,:,1253))
  call Hloop_AQ_Z(ntryL,G1H64(1254),ex2(:),G1H32(1254),ngZl,m3h2x32(:,1254),heltab2x64(:,:,1254))
  call Hloop_AQ_V(ntryL,G1H64(1255),ex2(:),G1H32(1255),m3h2x32(:,1255),heltab2x64(:,:,1255))
  call Hloop_AQ_Z(ntryL,G1H64(1256),ex2(:),G1H32(1256),ngZl,m3h2x32(:,1256),heltab2x64(:,:,1256))
  call Hloop_AQ_V(ntryL,G1H64(1257),ex2(:),G1H32(1257),m3h2x32(:,1257),heltab2x64(:,:,1257))
  call Hloop_AQ_Z(ntryL,G1H64(1258),ex2(:),G1H32(1258),ngZl,m3h2x32(:,1258),heltab2x64(:,:,1258))
  call Hloop_AQ_V(ntryL,G1H64(1259),ex5(:),G1H32(1259),m3h2x32(:,1259),heltab2x64(:,:,1259))
  call Hloop_AQ_V(ntryL,G1H64(1260),ex5(:),G1H32(1260),m3h2x32(:,1260),heltab2x64(:,:,1260))
  call Hloop_AQ_V(ntryL,G1H64(1261),ex5(:),G1H32(1261),m3h2x32(:,1261),heltab2x64(:,:,1261))
  call Hloop_AQ_V(ntryL,G1H64(1262),ex5(:),G1H32(1262),m3h2x32(:,1262),heltab2x64(:,:,1262))
  call Hloop_AQ_S(ntryL,G1H64(1263),ex5(:),G1H32(1263),ngH,m3h2x32(:,1263),heltab2x64(:,:,1263))
  call Hloop_AQ_S(ntryL,G1H64(1264),ex5(:),G1H32(1264),ngX,m3h2x32(:,1264),heltab2x64(:,:,1264))
  call Hloop_AQ_S(ntryL,G1H64(1265),ex5(:),G1H32(1265),ngH,m3h2x32(:,1265),heltab2x64(:,:,1265))
  call Hloop_AQ_S(ntryL,G1H64(1266),ex5(:),G1H32(1266),ngX,m3h2x32(:,1266),heltab2x64(:,:,1266))
  call Hloop_AQ_S(ntryL,G1H64(1267),ex5(:),G1H32(1267),ngH,m3h2x32(:,1267),heltab2x64(:,:,1267))
  call Hloop_AQ_S(ntryL,G1H64(1268),ex5(:),G1H32(1268),ngX,m3h2x32(:,1268),heltab2x64(:,:,1268))
  call Hloop_AQ_S(ntryL,G1H64(1269),ex5(:),G1H32(1269),ngH,m3h2x32(:,1269),heltab2x64(:,:,1269))
  call Hloop_AQ_S(ntryL,G1H64(1270),ex5(:),G1H32(1270),ngX,m3h2x32(:,1270),heltab2x64(:,:,1270))
  call Hloop_AQ_V(ntryL,G1H64(1271),ex5(:),G1H32(1271),m3h2x32(:,1271),heltab2x64(:,:,1271))
  call Hloop_AQ_V(ntryL,G1H64(1272),ex5(:),G1H32(1272),m3h2x32(:,1272),heltab2x64(:,:,1272))
  call Hloop_AQ_Z(ntryL,G1H64(1273),ex5(:),G1H32(1273),ngZl,m3h2x32(:,1273),heltab2x64(:,:,1273))
  call Hloop_AQ_V(ntryL,G1H64(1274),ex5(:),G1H32(1274),m3h2x32(:,1274),heltab2x64(:,:,1274))
  call Hloop_AQ_Z(ntryL,G1H64(1275),ex5(:),G1H32(1275),ngZl,m3h2x32(:,1275),heltab2x64(:,:,1275))
  call Hloop_AQ_V(ntryL,G1H64(1276),ex5(:),G1H32(1276),m3h2x32(:,1276),heltab2x64(:,:,1276))
  call Hloop_AQ_V(ntryL,G1H64(1277),ex5(:),G1H32(1277),m3h2x32(:,1277),heltab2x64(:,:,1277))
  call Hloop_AQ_V(ntryL,G1H64(1278),ex5(:),G1H32(1278),m3h2x32(:,1278),heltab2x64(:,:,1278))
  call Hloop_AQ_Z(ntryL,G1H64(1279),ex5(:),G1H32(1279),ngZl,m3h2x32(:,1279),heltab2x64(:,:,1279))
  call Hloop_AQ_V(ntryL,G1H64(1280),ex5(:),G1H32(1280),m3h2x32(:,1280),heltab2x64(:,:,1280))
  call Hloop_AQ_Z(ntryL,G1H64(1281),ex5(:),G1H32(1281),ngZl,m3h2x32(:,1281),heltab2x64(:,:,1281))
  call Hloop_AQ_V(ntryL,G1H64(1282),ex5(:),G1H32(1282),m3h2x32(:,1282),heltab2x64(:,:,1282))
  call Hloop_AQ_S(ntryL,G1H64(1283),ex5(:),G1H32(1283),ngH,m3h2x32(:,1283),heltab2x64(:,:,1283))
  call Hloop_AQ_S(ntryL,G1H64(1284),ex5(:),G1H32(1284),ngX,m3h2x32(:,1284),heltab2x64(:,:,1284))
  call Hloop_AQ_S(ntryL,G1H64(1285),ex5(:),G1H32(1285),ngH,m3h2x32(:,1285),heltab2x64(:,:,1285))
  call Hloop_AQ_S(ntryL,G1H64(1286),ex5(:),G1H32(1286),ngH,m3h2x32(:,1286),heltab2x64(:,:,1286))
  call Hloop_AQ_S(ntryL,G1H64(1287),ex5(:),G1H32(1287),ngX,m3h2x32(:,1287),heltab2x64(:,:,1287))
  call Hloop_AQ_S(ntryL,G1H64(1288),ex5(:),G1H32(1288),ngX,m3h2x32(:,1288),heltab2x64(:,:,1288))
  call Hloop_AQ_V(ntryL,G1H64(1289),ex5(:),G1H32(1289),m3h2x32(:,1289),heltab2x64(:,:,1289))
  call Hloop_AQ_Z(ntryL,G1H64(1290),ex5(:),G1H32(1290),ngZl,m3h2x32(:,1290),heltab2x64(:,:,1290))
  call Hloop_AQ_V(ntryL,G1H64(1291),ex5(:),G1H32(1291),m3h2x32(:,1291),heltab2x64(:,:,1291))
  call Hloop_AQ_V(ntryL,G1H64(1292),ex5(:),G1H32(1292),m3h2x32(:,1292),heltab2x64(:,:,1292))
  call Hloop_AQ_Z(ntryL,G1H64(1293),ex5(:),G1H32(1293),ngZl,m3h2x32(:,1293),heltab2x64(:,:,1293))
  call Hloop_AQ_Z(ntryL,G1H64(1294),ex5(:),G1H32(1294),ngZl,m3h2x32(:,1294),heltab2x64(:,:,1294))
  call Hloop_AQ_V(ntryL,G1H64(1295),ex5(:),G1H32(1295),m3h2x32(:,1295),heltab2x64(:,:,1295))
  call Hloop_AQ_S(ntryL,G1H64(1296),ex5(:),G1H32(1296),ngH,m3h2x32(:,1296),heltab2x64(:,:,1296))
  call Hloop_AQ_S(ntryL,G1H64(1297),ex5(:),G1H32(1297),ngX,m3h2x32(:,1297),heltab2x64(:,:,1297))
  call Hloop_AQ_S(ntryL,G1H64(1298),ex5(:),G1H32(1298),ngH,m3h2x32(:,1298),heltab2x64(:,:,1298))
  call Hloop_AQ_S(ntryL,G1H64(1299),ex5(:),G1H32(1299),ngX,m3h2x32(:,1299),heltab2x64(:,:,1299))
  call Hloop_AQ_V(ntryL,G1H64(1300),ex5(:),G1H32(1300),m3h2x32(:,1300),heltab2x64(:,:,1300))
  call Hloop_AQ_V(ntryL,G1H64(1301),ex5(:),G1H32(1301),m3h2x32(:,1301),heltab2x64(:,:,1301))
  call Hloop_AQ_V(ntryL,G1H64(1302),ex5(:),G1H32(1302),m3h2x32(:,1302),heltab2x64(:,:,1302))
  call Hloop_AQ_V(ntryL,G1H64(1303),ex5(:),G1H32(1303),m3h2x32(:,1303),heltab2x64(:,:,1303))
  call Hloop_AQ_S(ntryL,G1H64(1304),ex5(:),G1H32(1304),ngH,m3h2x32(:,1304),heltab2x64(:,:,1304))
  call Hloop_AQ_S(ntryL,G1H64(1305),ex5(:),G1H32(1305),ngH,m3h2x32(:,1305),heltab2x64(:,:,1305))
  call Hloop_AQ_S(ntryL,G1H64(1306),ex5(:),G1H32(1306),ngX,m3h2x32(:,1306),heltab2x64(:,:,1306))
  call Hloop_AQ_S(ntryL,G1H64(1307),ex5(:),G1H32(1307),ngX,m3h2x32(:,1307),heltab2x64(:,:,1307))
  call Hloop_AQ_V(ntryL,G1H64(1308),ex5(:),G1H32(1308),m3h2x32(:,1308),heltab2x64(:,:,1308))
  call Hloop_AQ_V(ntryL,G1H64(1309),ex5(:),G1H32(1309),m3h2x32(:,1309),heltab2x64(:,:,1309))
  call Hloop_AQ_V(ntryL,G1H64(1310),ex5(:),G1H32(1310),m3h2x32(:,1310),heltab2x64(:,:,1310))
  call Hloop_AQ_Z(ntryL,G1H64(1311),ex5(:),G1H32(1311),ngZl,m3h2x32(:,1311),heltab2x64(:,:,1311))
  call Hloop_AQ_V(ntryL,G1H64(1312),ex5(:),G1H32(1312),m3h2x32(:,1312),heltab2x64(:,:,1312))
  call Hloop_AQ_Z(ntryL,G1H64(1313),ex5(:),G1H32(1313),ngZl,m3h2x32(:,1313),heltab2x64(:,:,1313))
  call Hloop_AQ_S(ntryL,G1H64(1314),ex5(:),G1H32(1314),ngH,m3h2x32(:,1314),heltab2x64(:,:,1314))
  call Hloop_AQ_S(ntryL,G1H64(1315),ex5(:),G1H32(1315),ngX,m3h2x32(:,1315),heltab2x64(:,:,1315))
  call Hloop_AQ_S(ntryL,G1H64(1316),ex5(:),G1H32(1316),ngH,m3h2x32(:,1316),heltab2x64(:,:,1316))
  call Hloop_AQ_S(ntryL,G1H64(1317),ex5(:),G1H32(1317),ngH,m3h2x32(:,1317),heltab2x64(:,:,1317))
  call Hloop_AQ_S(ntryL,G1H64(1318),ex5(:),G1H32(1318),ngX,m3h2x32(:,1318),heltab2x64(:,:,1318))
  call Hloop_AQ_S(ntryL,G1H64(1319),ex5(:),G1H32(1319),ngX,m3h2x32(:,1319),heltab2x64(:,:,1319))
  call Hloop_AQ_V(ntryL,G1H64(1320),ex5(:),G1H32(1320),m3h2x32(:,1320),heltab2x64(:,:,1320))
  call Hloop_AQ_V(ntryL,G1H64(1321),ex5(:),G1H32(1321),m3h2x32(:,1321),heltab2x64(:,:,1321))
  call Hloop_AQ_Z(ntryL,G1H64(1322),ex5(:),G1H32(1322),ngZl,m3h2x32(:,1322),heltab2x64(:,:,1322))
  call Hloop_AQ_V(ntryL,G1H64(1323),ex5(:),G1H32(1323),m3h2x32(:,1323),heltab2x64(:,:,1323))
  call Hloop_AQ_Z(ntryL,G1H64(1324),ex5(:),G1H32(1324),ngZl,m3h2x32(:,1324),heltab2x64(:,:,1324))
  call Hloop_AQ_V(ntryL,G1H64(1325),ex5(:),G1H32(1325),m3h2x32(:,1325),heltab2x64(:,:,1325))
  call Hloop_AQ_V(ntryL,G1H64(1326),ex5(:),G1H32(1326),m3h2x32(:,1326),heltab2x64(:,:,1326))
  call Hloop_AQ_V(ntryL,G1H64(1327),ex5(:),G1H32(1327),m3h2x32(:,1327),heltab2x64(:,:,1327))
  call Hloop_AQ_Z(ntryL,G1H64(1328),ex5(:),G1H32(1328),ngZl,m3h2x32(:,1328),heltab2x64(:,:,1328))
  call Hloop_AQ_V(ntryL,G1H64(1329),ex5(:),G1H32(1329),m3h2x32(:,1329),heltab2x64(:,:,1329))
  call Hloop_AQ_Z(ntryL,G1H64(1330),ex5(:),G1H32(1330),ngZl,m3h2x32(:,1330),heltab2x64(:,:,1330))
  call Hloop_AQ_V(ntryL,G1H64(1331),ex5(:),G1H32(1331),m3h2x32(:,1331),heltab2x64(:,:,1331))
  call Hloop_AQ_Z(ntryL,G1H64(1332),ex5(:),G1H32(1332),ngZl,m3h2x32(:,1332),heltab2x64(:,:,1332))
  call Hloop_AQ_S(ntryL,G1H64(1333),ex2(:),G1H32(1333),ngH,m3h2x32(:,1333),heltab2x64(:,:,1333))
  call Hloop_AQ_S(ntryL,G1H64(1334),ex2(:),G1H32(1334),ngX,m3h2x32(:,1334),heltab2x64(:,:,1334))
  call Hloop_AQ_S(ntryL,G1H64(1335),ex2(:),G1H32(1335),ngH,m3h2x32(:,1335),heltab2x64(:,:,1335))
  call Hloop_AQ_S(ntryL,G1H64(1336),ex2(:),G1H32(1336),ngX,m3h2x32(:,1336),heltab2x64(:,:,1336))
  call Hloop_AQ_V(ntryL,G1H64(1337),ex2(:),G1H32(1337),m3h2x32(:,1337),heltab2x64(:,:,1337))
  call Hloop_AQ_V(ntryL,G1H64(1338),ex2(:),G1H32(1338),m3h2x32(:,1338),heltab2x64(:,:,1338))
  call Hloop_AQ_V(ntryL,G1H64(1339),ex2(:),G1H32(1339),m3h2x32(:,1339),heltab2x64(:,:,1339))
  call Hloop_AQ_V(ntryL,G1H64(1340),ex2(:),G1H32(1340),m3h2x32(:,1340),heltab2x64(:,:,1340))
  call Hloop_AQ_S(ntryL,G1H64(1341),ex2(:),G1H32(1341),ngH,m3h2x32(:,1341),heltab2x64(:,:,1341))
  call Hloop_AQ_S(ntryL,G1H64(1342),ex2(:),G1H32(1342),ngH,m3h2x32(:,1342),heltab2x64(:,:,1342))
  call Hloop_AQ_S(ntryL,G1H64(1343),ex2(:),G1H32(1343),ngX,m3h2x32(:,1343),heltab2x64(:,:,1343))
  call Hloop_AQ_S(ntryL,G1H64(1344),ex2(:),G1H32(1344),ngX,m3h2x32(:,1344),heltab2x64(:,:,1344))
  call Hloop_AQ_V(ntryL,G1H64(1345),ex2(:),G1H32(1345),m3h2x32(:,1345),heltab2x64(:,:,1345))
  call Hloop_AQ_V(ntryL,G1H64(1346),ex2(:),G1H32(1346),m3h2x32(:,1346),heltab2x64(:,:,1346))
  call Hloop_AQ_V(ntryL,G1H64(1347),ex2(:),G1H32(1347),m3h2x32(:,1347),heltab2x64(:,:,1347))
  call Hloop_AQ_Z(ntryL,G1H64(1348),ex2(:),G1H32(1348),ngZl,m3h2x32(:,1348),heltab2x64(:,:,1348))
  call Hloop_AQ_V(ntryL,G1H64(1349),ex2(:),G1H32(1349),m3h2x32(:,1349),heltab2x64(:,:,1349))
  call Hloop_AQ_Z(ntryL,G1H64(1350),ex2(:),G1H32(1350),ngZl,m3h2x32(:,1350),heltab2x64(:,:,1350))
  call Hloop_AQ_S(ntryL,G1H64(1351),ex2(:),G1H32(1351),ngH,m3h2x32(:,1351),heltab2x64(:,:,1351))
  call Hloop_AQ_S(ntryL,G1H64(1352),ex2(:),G1H32(1352),ngX,m3h2x32(:,1352),heltab2x64(:,:,1352))
  call Hloop_AQ_S(ntryL,G1H64(1353),ex2(:),G1H32(1353),ngH,m3h2x32(:,1353),heltab2x64(:,:,1353))
  call Hloop_AQ_S(ntryL,G1H64(1354),ex2(:),G1H32(1354),ngH,m3h2x32(:,1354),heltab2x64(:,:,1354))
  call Hloop_AQ_S(ntryL,G1H64(1355),ex2(:),G1H32(1355),ngX,m3h2x32(:,1355),heltab2x64(:,:,1355))
  call Hloop_AQ_S(ntryL,G1H64(1356),ex2(:),G1H32(1356),ngX,m3h2x32(:,1356),heltab2x64(:,:,1356))
  call Hloop_AQ_V(ntryL,G1H64(1357),ex2(:),G1H32(1357),m3h2x32(:,1357),heltab2x64(:,:,1357))
  call Hloop_AQ_V(ntryL,G1H64(1358),ex2(:),G1H32(1358),m3h2x32(:,1358),heltab2x64(:,:,1358))
  call Hloop_AQ_Z(ntryL,G1H64(1359),ex2(:),G1H32(1359),ngZl,m3h2x32(:,1359),heltab2x64(:,:,1359))
  call Hloop_AQ_V(ntryL,G1H64(1360),ex2(:),G1H32(1360),m3h2x32(:,1360),heltab2x64(:,:,1360))
  call Hloop_AQ_Z(ntryL,G1H64(1361),ex2(:),G1H32(1361),ngZl,m3h2x32(:,1361),heltab2x64(:,:,1361))
  call Hloop_AQ_V(ntryL,G1H64(1362),ex2(:),G1H32(1362),m3h2x32(:,1362),heltab2x64(:,:,1362))
  call Hloop_AQ_V(ntryL,G1H64(1363),ex2(:),G1H32(1363),m3h2x32(:,1363),heltab2x64(:,:,1363))
  call Hloop_AQ_V(ntryL,G1H64(1364),ex2(:),G1H32(1364),m3h2x32(:,1364),heltab2x64(:,:,1364))
  call Hloop_AQ_Z(ntryL,G1H64(1365),ex2(:),G1H32(1365),ngZl,m3h2x32(:,1365),heltab2x64(:,:,1365))
  call Hloop_AQ_V(ntryL,G1H64(1366),ex2(:),G1H32(1366),m3h2x32(:,1366),heltab2x64(:,:,1366))
  call Hloop_AQ_Z(ntryL,G1H64(1367),ex2(:),G1H32(1367),ngZl,m3h2x32(:,1367),heltab2x64(:,:,1367))
  call Hloop_AQ_V(ntryL,G1H64(1368),ex2(:),G1H32(1368),m3h2x32(:,1368),heltab2x64(:,:,1368))
  call Hloop_AQ_Z(ntryL,G1H64(1369),ex2(:),G1H32(1369),ngZl,m3h2x32(:,1369),heltab2x64(:,:,1369))
  call Hloop_AQ_S(ntryL,G1H64(1370),ex2(:),G1H32(1370),ngH,m3h2x32(:,1370),heltab2x64(:,:,1370))
  call Hloop_AQ_S(ntryL,G1H64(1371),ex2(:),G1H32(1371),ngX,m3h2x32(:,1371),heltab2x64(:,:,1371))
  call Hloop_AQ_S(ntryL,G1H64(1372),ex2(:),G1H32(1372),ngH,m3h2x32(:,1372),heltab2x64(:,:,1372))
  call Hloop_AQ_S(ntryL,G1H64(1373),ex2(:),G1H32(1373),ngX,m3h2x32(:,1373),heltab2x64(:,:,1373))
  call Hloop_AQ_V(ntryL,G1H64(1374),ex2(:),G1H32(1374),m3h2x32(:,1374),heltab2x64(:,:,1374))
  call Hloop_AQ_V(ntryL,G1H64(1375),ex2(:),G1H32(1375),m3h2x32(:,1375),heltab2x64(:,:,1375))
  call Hloop_AQ_V(ntryL,G1H64(1376),ex2(:),G1H32(1376),m3h2x32(:,1376),heltab2x64(:,:,1376))
  call Hloop_AQ_V(ntryL,G1H64(1377),ex2(:),G1H32(1377),m3h2x32(:,1377),heltab2x64(:,:,1377))
  call Hloop_AQ_S(ntryL,G1H64(1378),ex2(:),G1H32(1378),ngH,m3h2x32(:,1378),heltab2x64(:,:,1378))
  call Hloop_AQ_S(ntryL,G1H64(1379),ex2(:),G1H32(1379),ngH,m3h2x32(:,1379),heltab2x64(:,:,1379))
  call Hloop_AQ_S(ntryL,G1H64(1380),ex2(:),G1H32(1380),ngX,m3h2x32(:,1380),heltab2x64(:,:,1380))
  call Hloop_AQ_S(ntryL,G1H64(1381),ex2(:),G1H32(1381),ngX,m3h2x32(:,1381),heltab2x64(:,:,1381))
  call Hloop_AQ_V(ntryL,G1H64(1382),ex2(:),G1H32(1382),m3h2x32(:,1382),heltab2x64(:,:,1382))
  call Hloop_AQ_V(ntryL,G1H64(1383),ex2(:),G1H32(1383),m3h2x32(:,1383),heltab2x64(:,:,1383))
  call Hloop_AQ_V(ntryL,G1H64(1384),ex2(:),G1H32(1384),m3h2x32(:,1384),heltab2x64(:,:,1384))
  call Hloop_AQ_Z(ntryL,G1H64(1385),ex2(:),G1H32(1385),ngZl,m3h2x32(:,1385),heltab2x64(:,:,1385))
  call Hloop_AQ_V(ntryL,G1H64(1386),ex2(:),G1H32(1386),m3h2x32(:,1386),heltab2x64(:,:,1386))
  call Hloop_AQ_Z(ntryL,G1H64(1387),ex2(:),G1H32(1387),ngZl,m3h2x32(:,1387),heltab2x64(:,:,1387))
  call Hloop_AQ_S(ntryL,G1H64(1388),ex2(:),G1H32(1388),ngH,m3h2x32(:,1388),heltab2x64(:,:,1388))
  call Hloop_AQ_S(ntryL,G1H64(1389),ex2(:),G1H32(1389),ngX,m3h2x32(:,1389),heltab2x64(:,:,1389))
  call Hloop_AQ_S(ntryL,G1H64(1390),ex2(:),G1H32(1390),ngH,m3h2x32(:,1390),heltab2x64(:,:,1390))
  call Hloop_AQ_S(ntryL,G1H64(1391),ex2(:),G1H32(1391),ngH,m3h2x32(:,1391),heltab2x64(:,:,1391))
  call Hloop_AQ_S(ntryL,G1H64(1392),ex2(:),G1H32(1392),ngX,m3h2x32(:,1392),heltab2x64(:,:,1392))
  call Hloop_AQ_S(ntryL,G1H64(1393),ex2(:),G1H32(1393),ngX,m3h2x32(:,1393),heltab2x64(:,:,1393))
  call Hloop_AQ_V(ntryL,G1H64(1394),ex2(:),G1H32(1394),m3h2x32(:,1394),heltab2x64(:,:,1394))
  call Hloop_AQ_V(ntryL,G1H64(1395),ex2(:),G1H32(1395),m3h2x32(:,1395),heltab2x64(:,:,1395))
  call Hloop_AQ_Z(ntryL,G1H64(1396),ex2(:),G1H32(1396),ngZl,m3h2x32(:,1396),heltab2x64(:,:,1396))
  call Hloop_AQ_V(ntryL,G1H64(1397),ex2(:),G1H32(1397),m3h2x32(:,1397),heltab2x64(:,:,1397))
  call Hloop_AQ_Z(ntryL,G1H64(1398),ex2(:),G1H32(1398),ngZl,m3h2x32(:,1398),heltab2x64(:,:,1398))
  call Hloop_AQ_V(ntryL,G1H64(1399),ex2(:),G1H32(1399),m3h2x32(:,1399),heltab2x64(:,:,1399))
  call Hloop_AQ_V(ntryL,G1H64(1400),ex2(:),G1H32(1400),m3h2x32(:,1400),heltab2x64(:,:,1400))
  call Hloop_AQ_V(ntryL,G1H64(1401),ex2(:),G1H32(1401),m3h2x32(:,1401),heltab2x64(:,:,1401))
  call Hloop_AQ_Z(ntryL,G1H64(1402),ex2(:),G1H32(1402),ngZl,m3h2x32(:,1402),heltab2x64(:,:,1402))
  call Hloop_AQ_V(ntryL,G1H64(1403),ex2(:),G1H32(1403),m3h2x32(:,1403),heltab2x64(:,:,1403))
  call Hloop_AQ_Z(ntryL,G1H64(1404),ex2(:),G1H32(1404),ngZl,m3h2x32(:,1404),heltab2x64(:,:,1404))
  call Hloop_AQ_V(ntryL,G1H64(1405),ex2(:),G1H32(1405),m3h2x32(:,1405),heltab2x64(:,:,1405))
  call Hloop_AQ_Z(ntryL,G1H64(1406),ex2(:),G1H32(1406),ngZl,m3h2x32(:,1406),heltab2x64(:,:,1406))
  call Hloop_AQ_S(ntryL,G1H64(1407),ex1(:),G1H32(1407),ngH,m3h2x32(:,1407),heltab2x64(:,:,1407))
  call Hloop_AQ_S(ntryL,G1H64(1408),ex1(:),G1H32(1408),ngH,m3h2x32(:,1408),heltab2x64(:,:,1408))
  call Hloop_AQ_S(ntryL,G1H64(1409),ex1(:),G1H32(1409),ngX,m3h2x32(:,1409),heltab2x64(:,:,1409))
  call Hloop_AQ_S(ntryL,G1H64(1410),ex1(:),G1H32(1410),ngX,m3h2x32(:,1410),heltab2x64(:,:,1410))
  call Hloop_AQ_S(ntryL,G1H64(1411),ex1(:),G1H32(1411),ngH,m3h2x32(:,1411),heltab2x64(:,:,1411))
  call Hloop_AQ_S(ntryL,G1H64(1412),ex1(:),G1H32(1412),ngH,m3h2x32(:,1412),heltab2x64(:,:,1412))
  call Hloop_AQ_S(ntryL,G1H64(1413),ex1(:),G1H32(1413),ngX,m3h2x32(:,1413),heltab2x64(:,:,1413))
  call Hloop_AQ_S(ntryL,G1H64(1414),ex1(:),G1H32(1414),ngX,m3h2x32(:,1414),heltab2x64(:,:,1414))
  call Hloop_AQ_V(ntryL,G1H64(1415),ex1(:),G1H32(1415),m3h2x32(:,1415),heltab2x64(:,:,1415))
  call Hloop_AQ_V(ntryL,G1H64(1416),ex1(:),G1H32(1416),m3h2x32(:,1416),heltab2x64(:,:,1416))
  call Hloop_AQ_V(ntryL,G1H64(1417),ex1(:),G1H32(1417),m3h2x32(:,1417),heltab2x64(:,:,1417))
  call Hloop_AQ_V(ntryL,G1H64(1418),ex1(:),G1H32(1418),m3h2x32(:,1418),heltab2x64(:,:,1418))
  call Hloop_AQ_S(ntryL,G1H64(1419),ex1(:),G1H32(1419),ngH,m3h2x32(:,1419),heltab2x64(:,:,1419))
  call Hloop_AQ_S(ntryL,G1H64(1420),ex1(:),G1H32(1420),ngX,m3h2x32(:,1420),heltab2x64(:,:,1420))
  call Hloop_AQ_S(ntryL,G1H64(1421),ex1(:),G1H32(1421),ngH,m3h2x32(:,1421),heltab2x64(:,:,1421))
  call Hloop_AQ_S(ntryL,G1H64(1422),ex1(:),G1H32(1422),ngH,m3h2x32(:,1422),heltab2x64(:,:,1422))
  call Hloop_AQ_S(ntryL,G1H64(1423),ex1(:),G1H32(1423),ngX,m3h2x32(:,1423),heltab2x64(:,:,1423))
  call Hloop_AQ_S(ntryL,G1H64(1424),ex1(:),G1H32(1424),ngX,m3h2x32(:,1424),heltab2x64(:,:,1424))
  call Hloop_AQ_V(ntryL,G1H64(1425),ex1(:),G1H32(1425),m3h2x32(:,1425),heltab2x64(:,:,1425))
  call Hloop_AQ_V(ntryL,G1H64(1426),ex1(:),G1H32(1426),m3h2x32(:,1426),heltab2x64(:,:,1426))
  call Hloop_AQ_V(ntryL,G1H64(1427),ex1(:),G1H32(1427),m3h2x32(:,1427),heltab2x64(:,:,1427))
  call Hloop_AQ_Z(ntryL,G1H64(1428),ex1(:),G1H32(1428),ngZl,m3h2x32(:,1428),heltab2x64(:,:,1428))
  call Hloop_AQ_V(ntryL,G1H64(1429),ex1(:),G1H32(1429),m3h2x32(:,1429),heltab2x64(:,:,1429))
  call Hloop_AQ_Z(ntryL,G1H64(1430),ex1(:),G1H32(1430),ngZl,m3h2x32(:,1430),heltab2x64(:,:,1430))
  call Hloop_AQ_V(ntryL,G1H64(1431),ex1(:),G1H32(1431),m3h2x32(:,1431),heltab2x64(:,:,1431))
  call Hloop_AQ_V(ntryL,G1H64(1432),ex1(:),G1H32(1432),m3h2x32(:,1432),heltab2x64(:,:,1432))
  call Hloop_AQ_V(ntryL,G1H64(1433),ex1(:),G1H32(1433),m3h2x32(:,1433),heltab2x64(:,:,1433))
  call Hloop_AQ_Z(ntryL,G1H64(1434),ex1(:),G1H32(1434),ngZl,m3h2x32(:,1434),heltab2x64(:,:,1434))
  call Hloop_AQ_V(ntryL,G1H64(1435),ex1(:),G1H32(1435),m3h2x32(:,1435),heltab2x64(:,:,1435))
  call Hloop_AQ_Z(ntryL,G1H64(1436),ex1(:),G1H32(1436),ngZl,m3h2x32(:,1436),heltab2x64(:,:,1436))
  call Hloop_AQ_V(ntryL,G1H64(1437),ex1(:),G1H32(1437),m3h2x32(:,1437),heltab2x64(:,:,1437))
  call Hloop_AQ_V(ntryL,G1H64(1438),ex1(:),G1H32(1438),m3h2x32(:,1438),heltab2x64(:,:,1438))
  call Hloop_AQ_V(ntryL,G1H64(1439),ex1(:),G1H32(1439),m3h2x32(:,1439),heltab2x64(:,:,1439))
  call Hloop_AQ_Z(ntryL,G1H64(1440),ex1(:),G1H32(1440),ngZl,m3h2x32(:,1440),heltab2x64(:,:,1440))
  call Hloop_AQ_V(ntryL,G1H64(1441),ex1(:),G1H32(1441),m3h2x32(:,1441),heltab2x64(:,:,1441))
  call Hloop_AQ_Z(ntryL,G1H64(1442),ex1(:),G1H32(1442),ngZl,m3h2x32(:,1442),heltab2x64(:,:,1442))
  call Hloop_AQ_Z(ntryL,G1H64(1443),ex1(:),G1H32(1443),ngZl,m3h2x32(:,1443),heltab2x64(:,:,1443))
  call Hloop_AQ_S(ntryL,G1H64(1444),ex1(:),G1H32(1444),ngH,m3h2x32(:,1444),heltab2x64(:,:,1444))
  call Hloop_AQ_S(ntryL,G1H64(1445),ex1(:),G1H32(1445),ngH,m3h2x32(:,1445),heltab2x64(:,:,1445))
  call Hloop_AQ_S(ntryL,G1H64(1446),ex1(:),G1H32(1446),ngX,m3h2x32(:,1446),heltab2x64(:,:,1446))
  call Hloop_AQ_S(ntryL,G1H64(1447),ex1(:),G1H32(1447),ngX,m3h2x32(:,1447),heltab2x64(:,:,1447))
  call Hloop_AQ_S(ntryL,G1H64(1448),ex1(:),G1H32(1448),ngH,m3h2x32(:,1448),heltab2x64(:,:,1448))
  call Hloop_AQ_S(ntryL,G1H64(1449),ex1(:),G1H32(1449),ngH,m3h2x32(:,1449),heltab2x64(:,:,1449))
  call Hloop_AQ_S(ntryL,G1H64(1450),ex1(:),G1H32(1450),ngX,m3h2x32(:,1450),heltab2x64(:,:,1450))
  call Hloop_AQ_S(ntryL,G1H64(1451),ex1(:),G1H32(1451),ngX,m3h2x32(:,1451),heltab2x64(:,:,1451))
  call Hloop_AQ_V(ntryL,G1H64(1452),ex1(:),G1H32(1452),m3h2x32(:,1452),heltab2x64(:,:,1452))
  call Hloop_AQ_V(ntryL,G1H64(1453),ex1(:),G1H32(1453),m3h2x32(:,1453),heltab2x64(:,:,1453))
  call Hloop_AQ_V(ntryL,G1H64(1454),ex1(:),G1H32(1454),m3h2x32(:,1454),heltab2x64(:,:,1454))
  call Hloop_AQ_V(ntryL,G1H64(1455),ex1(:),G1H32(1455),m3h2x32(:,1455),heltab2x64(:,:,1455))
  call Hloop_AQ_S(ntryL,G1H64(1456),ex1(:),G1H32(1456),ngH,m3h2x32(:,1456),heltab2x64(:,:,1456))
  call Hloop_AQ_S(ntryL,G1H64(1457),ex1(:),G1H32(1457),ngX,m3h2x32(:,1457),heltab2x64(:,:,1457))
  call Hloop_AQ_S(ntryL,G1H64(1458),ex1(:),G1H32(1458),ngH,m3h2x32(:,1458),heltab2x64(:,:,1458))
  call Hloop_AQ_S(ntryL,G1H64(1459),ex1(:),G1H32(1459),ngH,m3h2x32(:,1459),heltab2x64(:,:,1459))
  call Hloop_AQ_S(ntryL,G1H64(1460),ex1(:),G1H32(1460),ngX,m3h2x32(:,1460),heltab2x64(:,:,1460))
  call Hloop_AQ_S(ntryL,G1H64(1461),ex1(:),G1H32(1461),ngX,m3h2x32(:,1461),heltab2x64(:,:,1461))
  call Hloop_AQ_V(ntryL,G1H64(1462),ex1(:),G1H32(1462),m3h2x32(:,1462),heltab2x64(:,:,1462))
  call Hloop_AQ_V(ntryL,G1H64(1463),ex1(:),G1H32(1463),m3h2x32(:,1463),heltab2x64(:,:,1463))
  call Hloop_AQ_V(ntryL,G1H64(1464),ex1(:),G1H32(1464),m3h2x32(:,1464),heltab2x64(:,:,1464))
  call Hloop_AQ_Z(ntryL,G1H64(1465),ex1(:),G1H32(1465),ngZl,m3h2x32(:,1465),heltab2x64(:,:,1465))
  call Hloop_AQ_V(ntryL,G1H64(1466),ex1(:),G1H32(1466),m3h2x32(:,1466),heltab2x64(:,:,1466))
  call Hloop_AQ_Z(ntryL,G1H64(1467),ex1(:),G1H32(1467),ngZl,m3h2x32(:,1467),heltab2x64(:,:,1467))
  call Hloop_AQ_V(ntryL,G1H64(1468),ex1(:),G1H32(1468),m3h2x32(:,1468),heltab2x64(:,:,1468))
  call Hloop_AQ_V(ntryL,G1H64(1469),ex1(:),G1H32(1469),m3h2x32(:,1469),heltab2x64(:,:,1469))
  call Hloop_AQ_V(ntryL,G1H64(1470),ex1(:),G1H32(1470),m3h2x32(:,1470),heltab2x64(:,:,1470))
  call Hloop_AQ_Z(ntryL,G1H64(1471),ex1(:),G1H32(1471),ngZl,m3h2x32(:,1471),heltab2x64(:,:,1471))
  call Hloop_AQ_V(ntryL,G1H64(1472),ex1(:),G1H32(1472),m3h2x32(:,1472),heltab2x64(:,:,1472))
  call Hloop_AQ_Z(ntryL,G1H64(1473),ex1(:),G1H32(1473),ngZl,m3h2x32(:,1473),heltab2x64(:,:,1473))
  call Hloop_AQ_V(ntryL,G1H64(1474),ex1(:),G1H32(1474),m3h2x32(:,1474),heltab2x64(:,:,1474))
  call Hloop_AQ_V(ntryL,G1H64(1475),ex1(:),G1H32(1475),m3h2x32(:,1475),heltab2x64(:,:,1475))
  call Hloop_AQ_V(ntryL,G1H64(1476),ex1(:),G1H32(1476),m3h2x32(:,1476),heltab2x64(:,:,1476))
  call Hloop_AQ_Z(ntryL,G1H64(1477),ex1(:),G1H32(1477),ngZl,m3h2x32(:,1477),heltab2x64(:,:,1477))
  call Hloop_AQ_V(ntryL,G1H64(1478),ex1(:),G1H32(1478),m3h2x32(:,1478),heltab2x64(:,:,1478))
  call Hloop_AQ_Z(ntryL,G1H64(1479),ex1(:),G1H32(1479),ngZl,m3h2x32(:,1479),heltab2x64(:,:,1479))
  call Hloop_AQ_Z(ntryL,G1H64(1480),ex1(:),G1H32(1480),ngZl,m3h2x32(:,1480),heltab2x64(:,:,1480))
  call Hloop_AQ_S(ntryL,G1H64(1481),ex1(:),G1H32(1481),ngH,m3h2x32(:,1481),heltab2x64(:,:,1481))
  call Hloop_AQ_S(ntryL,G1H64(1482),ex1(:),G1H32(1482),ngH,m3h2x32(:,1482),heltab2x64(:,:,1482))
  call Hloop_AQ_S(ntryL,G1H64(1483),ex1(:),G1H32(1483),ngX,m3h2x32(:,1483),heltab2x64(:,:,1483))
  call Hloop_AQ_S(ntryL,G1H64(1484),ex1(:),G1H32(1484),ngX,m3h2x32(:,1484),heltab2x64(:,:,1484))
  call Hloop_AQ_S(ntryL,G1H64(1485),ex1(:),G1H32(1485),ngH,m3h2x32(:,1485),heltab2x64(:,:,1485))
  call Hloop_AQ_S(ntryL,G1H64(1486),ex1(:),G1H32(1486),ngH,m3h2x32(:,1486),heltab2x64(:,:,1486))
  call Hloop_AQ_S(ntryL,G1H64(1487),ex1(:),G1H32(1487),ngX,m3h2x32(:,1487),heltab2x64(:,:,1487))
  call Hloop_AQ_S(ntryL,G1H64(1488),ex1(:),G1H32(1488),ngX,m3h2x32(:,1488),heltab2x64(:,:,1488))
  call Hloop_AQ_V(ntryL,G1H64(1489),ex1(:),G1H32(1489),m3h2x32(:,1489),heltab2x64(:,:,1489))
  call Hloop_AQ_V(ntryL,G1H64(1490),ex1(:),G1H32(1490),m3h2x32(:,1490),heltab2x64(:,:,1490))
  call Hloop_AQ_V(ntryL,G1H64(1491),ex1(:),G1H32(1491),m3h2x32(:,1491),heltab2x64(:,:,1491))
  call Hloop_AQ_V(ntryL,G1H64(1492),ex1(:),G1H32(1492),m3h2x32(:,1492),heltab2x64(:,:,1492))
  call Hloop_AQ_S(ntryL,G1H64(1493),ex1(:),G1H32(1493),ngH,m3h2x32(:,1493),heltab2x64(:,:,1493))
  call Hloop_AQ_S(ntryL,G1H64(1494),ex1(:),G1H32(1494),ngX,m3h2x32(:,1494),heltab2x64(:,:,1494))
  call Hloop_AQ_S(ntryL,G1H64(1495),ex1(:),G1H32(1495),ngH,m3h2x32(:,1495),heltab2x64(:,:,1495))
  call Hloop_AQ_S(ntryL,G1H64(1496),ex1(:),G1H32(1496),ngH,m3h2x32(:,1496),heltab2x64(:,:,1496))
  call Hloop_AQ_S(ntryL,G1H64(1497),ex1(:),G1H32(1497),ngX,m3h2x32(:,1497),heltab2x64(:,:,1497))
  call Hloop_AQ_S(ntryL,G1H64(1498),ex1(:),G1H32(1498),ngX,m3h2x32(:,1498),heltab2x64(:,:,1498))
  call Hloop_AQ_V(ntryL,G1H64(1499),ex1(:),G1H32(1499),m3h2x32(:,1499),heltab2x64(:,:,1499))
  call Hloop_AQ_V(ntryL,G1H64(1500),ex1(:),G1H32(1500),m3h2x32(:,1500),heltab2x64(:,:,1500))
  call Hloop_AQ_V(ntryL,G1H64(1501),ex1(:),G1H32(1501),m3h2x32(:,1501),heltab2x64(:,:,1501))
  call Hloop_AQ_Z(ntryL,G1H64(1502),ex1(:),G1H32(1502),ngZl,m3h2x32(:,1502),heltab2x64(:,:,1502))
  call Hloop_AQ_V(ntryL,G1H64(1503),ex1(:),G1H32(1503),m3h2x32(:,1503),heltab2x64(:,:,1503))
  call Hloop_AQ_Z(ntryL,G1H64(1504),ex1(:),G1H32(1504),ngZl,m3h2x32(:,1504),heltab2x64(:,:,1504))
  call Hloop_AQ_V(ntryL,G1H64(1505),ex1(:),G1H32(1505),m3h2x32(:,1505),heltab2x64(:,:,1505))
  call Hloop_AQ_V(ntryL,G1H64(1506),ex1(:),G1H32(1506),m3h2x32(:,1506),heltab2x64(:,:,1506))
  call Hloop_AQ_V(ntryL,G1H64(1507),ex1(:),G1H32(1507),m3h2x32(:,1507),heltab2x64(:,:,1507))
  call Hloop_AQ_Z(ntryL,G1H64(1508),ex1(:),G1H32(1508),ngZl,m3h2x32(:,1508),heltab2x64(:,:,1508))
  call Hloop_AQ_V(ntryL,G1H64(1509),ex1(:),G1H32(1509),m3h2x32(:,1509),heltab2x64(:,:,1509))
  call Hloop_AQ_Z(ntryL,G1H64(1510),ex1(:),G1H32(1510),ngZl,m3h2x32(:,1510),heltab2x64(:,:,1510))
  call Hloop_AQ_V(ntryL,G1H64(1511),ex1(:),G1H32(1511),m3h2x32(:,1511),heltab2x64(:,:,1511))
  call Hloop_AQ_V(ntryL,G1H64(1512),ex1(:),G1H32(1512),m3h2x32(:,1512),heltab2x64(:,:,1512))
  call Hloop_AQ_V(ntryL,G1H64(1513),ex1(:),G1H32(1513),m3h2x32(:,1513),heltab2x64(:,:,1513))
  call Hloop_AQ_Z(ntryL,G1H64(1514),ex1(:),G1H32(1514),ngZl,m3h2x32(:,1514),heltab2x64(:,:,1514))
  call Hloop_AQ_V(ntryL,G1H64(1515),ex1(:),G1H32(1515),m3h2x32(:,1515),heltab2x64(:,:,1515))
  call Hloop_AQ_Z(ntryL,G1H64(1516),ex1(:),G1H32(1516),ngZl,m3h2x32(:,1516),heltab2x64(:,:,1516))
  call Hloop_AQ_Z(ntryL,G1H64(1517),ex1(:),G1H32(1517),ngZl,m3h2x32(:,1517),heltab2x64(:,:,1517))
  call Hloop_AQ_S(ntryL,G1H64(1518),ex1(:),G1H32(1518),ngH,m3h2x32(:,1518),heltab2x64(:,:,1518))
  call Hloop_AQ_S(ntryL,G1H64(1519),ex1(:),G1H32(1519),ngH,m3h2x32(:,1519),heltab2x64(:,:,1519))
  call Hloop_AQ_S(ntryL,G1H64(1520),ex1(:),G1H32(1520),ngX,m3h2x32(:,1520),heltab2x64(:,:,1520))
  call Hloop_AQ_S(ntryL,G1H64(1521),ex1(:),G1H32(1521),ngX,m3h2x32(:,1521),heltab2x64(:,:,1521))
  call Hloop_AQ_S(ntryL,G1H64(1522),ex1(:),G1H32(1522),ngH,m3h2x32(:,1522),heltab2x64(:,:,1522))
  call Hloop_AQ_S(ntryL,G1H64(1523),ex1(:),G1H32(1523),ngH,m3h2x32(:,1523),heltab2x64(:,:,1523))
  call Hloop_AQ_S(ntryL,G1H64(1524),ex1(:),G1H32(1524),ngX,m3h2x32(:,1524),heltab2x64(:,:,1524))
  call Hloop_AQ_S(ntryL,G1H64(1525),ex1(:),G1H32(1525),ngX,m3h2x32(:,1525),heltab2x64(:,:,1525))
  call Hloop_AQ_V(ntryL,G1H64(1526),ex1(:),G1H32(1526),m3h2x32(:,1526),heltab2x64(:,:,1526))
  call Hloop_AQ_V(ntryL,G1H64(1527),ex1(:),G1H32(1527),m3h2x32(:,1527),heltab2x64(:,:,1527))
  call Hloop_AQ_V(ntryL,G1H64(1528),ex1(:),G1H32(1528),m3h2x32(:,1528),heltab2x64(:,:,1528))
  call Hloop_AQ_V(ntryL,G1H64(1529),ex1(:),G1H32(1529),m3h2x32(:,1529),heltab2x64(:,:,1529))
  call Hloop_AQ_S(ntryL,G1H64(1530),ex1(:),G1H32(1530),ngH,m3h2x32(:,1530),heltab2x64(:,:,1530))
  call Hloop_AQ_S(ntryL,G1H64(1531),ex1(:),G1H32(1531),ngX,m3h2x32(:,1531),heltab2x64(:,:,1531))
  call Hloop_AQ_S(ntryL,G1H64(1532),ex1(:),G1H32(1532),ngH,m3h2x32(:,1532),heltab2x64(:,:,1532))
  call Hloop_AQ_S(ntryL,G1H64(1533),ex1(:),G1H32(1533),ngH,m3h2x32(:,1533),heltab2x64(:,:,1533))
  call Hloop_AQ_S(ntryL,G1H64(1534),ex1(:),G1H32(1534),ngX,m3h2x32(:,1534),heltab2x64(:,:,1534))
  call Hloop_AQ_S(ntryL,G1H64(1535),ex1(:),G1H32(1535),ngX,m3h2x32(:,1535),heltab2x64(:,:,1535))
  call Hloop_AQ_V(ntryL,G1H64(1536),ex1(:),G1H32(1536),m3h2x32(:,1536),heltab2x64(:,:,1536))
  call Hloop_AQ_V(ntryL,G1H64(1537),ex1(:),G1H32(1537),m3h2x32(:,1537),heltab2x64(:,:,1537))
  call Hloop_AQ_V(ntryL,G1H64(1538),ex1(:),G1H32(1538),m3h2x32(:,1538),heltab2x64(:,:,1538))
  call Hloop_AQ_Z(ntryL,G1H64(1539),ex1(:),G1H32(1539),ngZl,m3h2x32(:,1539),heltab2x64(:,:,1539))
  call Hloop_AQ_V(ntryL,G1H64(1540),ex1(:),G1H32(1540),m3h2x32(:,1540),heltab2x64(:,:,1540))
  call Hloop_AQ_Z(ntryL,G1H64(1541),ex1(:),G1H32(1541),ngZl,m3h2x32(:,1541),heltab2x64(:,:,1541))
  call Hloop_AQ_V(ntryL,G1H64(1542),ex1(:),G1H32(1542),m3h2x32(:,1542),heltab2x64(:,:,1542))
  call Hloop_AQ_V(ntryL,G1H64(1543),ex1(:),G1H32(1543),m3h2x32(:,1543),heltab2x64(:,:,1543))
  call Hloop_AQ_V(ntryL,G1H64(1544),ex1(:),G1H32(1544),m3h2x32(:,1544),heltab2x64(:,:,1544))
  call Hloop_AQ_Z(ntryL,G1H64(1545),ex1(:),G1H32(1545),ngZl,m3h2x32(:,1545),heltab2x64(:,:,1545))
  call Hloop_AQ_V(ntryL,G1H64(1546),ex1(:),G1H32(1546),m3h2x32(:,1546),heltab2x64(:,:,1546))
  call Hloop_AQ_Z(ntryL,G1H64(1547),ex1(:),G1H32(1547),ngZl,m3h2x32(:,1547),heltab2x64(:,:,1547))
  call Hloop_AQ_V(ntryL,G1H64(1548),ex1(:),G1H32(1548),m3h2x32(:,1548),heltab2x64(:,:,1548))
  call Hloop_AQ_V(ntryL,G1H64(1549),ex1(:),G1H32(1549),m3h2x32(:,1549),heltab2x64(:,:,1549))
  call Hloop_AQ_V(ntryL,G1H64(1550),ex1(:),G1H32(1550),m3h2x32(:,1550),heltab2x64(:,:,1550))
  call Hloop_AQ_Z(ntryL,G1H64(1551),ex1(:),G1H32(1551),ngZl,m3h2x32(:,1551),heltab2x64(:,:,1551))
  call Hloop_AQ_V(ntryL,G1H64(1552),ex1(:),G1H32(1552),m3h2x32(:,1552),heltab2x64(:,:,1552))
  call Hloop_AQ_Z(ntryL,G1H64(1553),ex1(:),G1H32(1553),ngZl,m3h2x32(:,1553),heltab2x64(:,:,1553))
  call Hloop_AQ_Z(ntryL,G1H64(1554),ex1(:),G1H32(1554),ngZl,m3h2x32(:,1554),heltab2x64(:,:,1554))
  call Hloop_AQ_S(ntryL,G1H64(1555),ex1(:),G1H32(1555),ngH,m3h2x32(:,1555),heltab2x64(:,:,1555))
  call Hloop_AQ_S(ntryL,G1H64(1556),ex1(:),G1H32(1556),ngH,m3h2x32(:,1556),heltab2x64(:,:,1556))
  call Hloop_AQ_S(ntryL,G1H64(1557),ex1(:),G1H32(1557),ngX,m3h2x32(:,1557),heltab2x64(:,:,1557))
  call Hloop_AQ_S(ntryL,G1H64(1558),ex1(:),G1H32(1558),ngX,m3h2x32(:,1558),heltab2x64(:,:,1558))
  call Hloop_AQ_S(ntryL,G1H64(1559),ex1(:),G1H32(1559),ngH,m3h2x32(:,1559),heltab2x64(:,:,1559))
  call Hloop_AQ_S(ntryL,G1H64(1560),ex1(:),G1H32(1560),ngH,m3h2x32(:,1560),heltab2x64(:,:,1560))
  call Hloop_AQ_S(ntryL,G1H64(1561),ex1(:),G1H32(1561),ngX,m3h2x32(:,1561),heltab2x64(:,:,1561))
  call Hloop_AQ_S(ntryL,G1H64(1562),ex1(:),G1H32(1562),ngX,m3h2x32(:,1562),heltab2x64(:,:,1562))
  call Hloop_AQ_V(ntryL,G1H64(1563),ex1(:),G1H32(1563),m3h2x32(:,1563),heltab2x64(:,:,1563))
  call Hloop_AQ_V(ntryL,G1H64(1564),ex1(:),G1H32(1564),m3h2x32(:,1564),heltab2x64(:,:,1564))
  call Hloop_AQ_V(ntryL,G1H64(1565),ex1(:),G1H32(1565),m3h2x32(:,1565),heltab2x64(:,:,1565))
  call Hloop_AQ_V(ntryL,G1H64(1566),ex1(:),G1H32(1566),m3h2x32(:,1566),heltab2x64(:,:,1566))
  call Hloop_AQ_S(ntryL,G1H64(1567),ex1(:),G1H32(1567),ngH,m3h2x32(:,1567),heltab2x64(:,:,1567))
  call Hloop_AQ_S(ntryL,G1H64(1568),ex1(:),G1H32(1568),ngX,m3h2x32(:,1568),heltab2x64(:,:,1568))
  call Hloop_AQ_S(ntryL,G1H64(1569),ex1(:),G1H32(1569),ngH,m3h2x32(:,1569),heltab2x64(:,:,1569))
  call Hloop_AQ_S(ntryL,G1H64(1570),ex1(:),G1H32(1570),ngH,m3h2x32(:,1570),heltab2x64(:,:,1570))
  call Hloop_AQ_S(ntryL,G1H64(1571),ex1(:),G1H32(1571),ngX,m3h2x32(:,1571),heltab2x64(:,:,1571))
  call Hloop_AQ_S(ntryL,G1H64(1572),ex1(:),G1H32(1572),ngX,m3h2x32(:,1572),heltab2x64(:,:,1572))
  call Hloop_AQ_V(ntryL,G1H64(1573),ex1(:),G1H32(1573),m3h2x32(:,1573),heltab2x64(:,:,1573))
  call Hloop_AQ_V(ntryL,G1H64(1574),ex1(:),G1H32(1574),m3h2x32(:,1574),heltab2x64(:,:,1574))
  call Hloop_AQ_V(ntryL,G1H64(1575),ex1(:),G1H32(1575),m3h2x32(:,1575),heltab2x64(:,:,1575))
  call Hloop_AQ_Z(ntryL,G1H64(1576),ex1(:),G1H32(1576),ngZl,m3h2x32(:,1576),heltab2x64(:,:,1576))
  call Hloop_AQ_V(ntryL,G1H64(1577),ex1(:),G1H32(1577),m3h2x32(:,1577),heltab2x64(:,:,1577))
  call Hloop_AQ_Z(ntryL,G1H64(1578),ex1(:),G1H32(1578),ngZl,m3h2x32(:,1578),heltab2x64(:,:,1578))
  call Hloop_AQ_V(ntryL,G1H64(1579),ex1(:),G1H32(1579),m3h2x32(:,1579),heltab2x64(:,:,1579))
  call Hloop_AQ_V(ntryL,G1H64(1580),ex1(:),G1H32(1580),m3h2x32(:,1580),heltab2x64(:,:,1580))
  call Hloop_AQ_V(ntryL,G1H64(1581),ex1(:),G1H32(1581),m3h2x32(:,1581),heltab2x64(:,:,1581))
  call Hloop_AQ_Z(ntryL,G1H64(1582),ex1(:),G1H32(1582),ngZl,m3h2x32(:,1582),heltab2x64(:,:,1582))
  call Hloop_AQ_V(ntryL,G1H64(1583),ex1(:),G1H32(1583),m3h2x32(:,1583),heltab2x64(:,:,1583))
  call Hloop_AQ_Z(ntryL,G1H64(1584),ex1(:),G1H32(1584),ngZl,m3h2x32(:,1584),heltab2x64(:,:,1584))
  call Hloop_AQ_V(ntryL,G1H64(1585),ex1(:),G1H32(1585),m3h2x32(:,1585),heltab2x64(:,:,1585))
  call Hloop_AQ_V(ntryL,G1H64(1586),ex1(:),G1H32(1586),m3h2x32(:,1586),heltab2x64(:,:,1586))
  call Hloop_AQ_V(ntryL,G1H64(1587),ex1(:),G1H32(1587),m3h2x32(:,1587),heltab2x64(:,:,1587))
  call Hloop_AQ_Z(ntryL,G1H64(1588),ex1(:),G1H32(1588),ngZl,m3h2x32(:,1588),heltab2x64(:,:,1588))
  call Hloop_AQ_V(ntryL,G1H64(1589),ex1(:),G1H32(1589),m3h2x32(:,1589),heltab2x64(:,:,1589))
  call Hloop_AQ_Z(ntryL,G1H64(1590),ex1(:),G1H32(1590),ngZl,m3h2x32(:,1590),heltab2x64(:,:,1590))
  call Hloop_AQ_Z(ntryL,G1H64(1591),ex1(:),G1H32(1591),ngZl,m3h2x32(:,1591),heltab2x64(:,:,1591))
  call Hloop_AQ_S(ntryL,G1H64(1592),ex1(:),G1H32(1592),ngH,m3h2x32(:,1592),heltab2x64(:,:,1592))
  call Hloop_AQ_S(ntryL,G1H64(1593),ex1(:),G1H32(1593),ngH,m3h2x32(:,1593),heltab2x64(:,:,1593))
  call Hloop_AQ_S(ntryL,G1H64(1594),ex1(:),G1H32(1594),ngX,m3h2x32(:,1594),heltab2x64(:,:,1594))
  call Hloop_AQ_S(ntryL,G1H64(1595),ex1(:),G1H32(1595),ngX,m3h2x32(:,1595),heltab2x64(:,:,1595))
  call Hloop_AQ_S(ntryL,G1H64(1596),ex1(:),G1H32(1596),ngH,m3h2x32(:,1596),heltab2x64(:,:,1596))
  call Hloop_AQ_S(ntryL,G1H64(1597),ex1(:),G1H32(1597),ngH,m3h2x32(:,1597),heltab2x64(:,:,1597))
  call Hloop_AQ_S(ntryL,G1H64(1598),ex1(:),G1H32(1598),ngX,m3h2x32(:,1598),heltab2x64(:,:,1598))
  call Hloop_AQ_S(ntryL,G1H64(1599),ex1(:),G1H32(1599),ngX,m3h2x32(:,1599),heltab2x64(:,:,1599))
  call Hloop_AQ_V(ntryL,G1H64(1600),ex1(:),G1H32(1600),m3h2x32(:,1600),heltab2x64(:,:,1600))
  call Hloop_AQ_V(ntryL,G1H64(1601),ex1(:),G1H32(1601),m3h2x32(:,1601),heltab2x64(:,:,1601))
  call Hloop_AQ_V(ntryL,G1H64(1602),ex1(:),G1H32(1602),m3h2x32(:,1602),heltab2x64(:,:,1602))
  call Hloop_AQ_V(ntryL,G1H64(1603),ex1(:),G1H32(1603),m3h2x32(:,1603),heltab2x64(:,:,1603))
  call Hloop_AQ_S(ntryL,G1H64(1604),ex1(:),G1H32(1604),ngH,m3h2x32(:,1604),heltab2x64(:,:,1604))
  call Hloop_AQ_S(ntryL,G1H64(1605),ex1(:),G1H32(1605),ngX,m3h2x32(:,1605),heltab2x64(:,:,1605))
  call Hloop_AQ_S(ntryL,G1H64(1606),ex1(:),G1H32(1606),ngH,m3h2x32(:,1606),heltab2x64(:,:,1606))
  call Hloop_AQ_S(ntryL,G1H64(1607),ex1(:),G1H32(1607),ngH,m3h2x32(:,1607),heltab2x64(:,:,1607))
  call Hloop_AQ_S(ntryL,G1H64(1608),ex1(:),G1H32(1608),ngX,m3h2x32(:,1608),heltab2x64(:,:,1608))
  call Hloop_AQ_S(ntryL,G1H64(1609),ex1(:),G1H32(1609),ngX,m3h2x32(:,1609),heltab2x64(:,:,1609))
  call Hloop_AQ_V(ntryL,G1H64(1610),ex1(:),G1H32(1610),m3h2x32(:,1610),heltab2x64(:,:,1610))
  call Hloop_AQ_V(ntryL,G1H64(1611),ex1(:),G1H32(1611),m3h2x32(:,1611),heltab2x64(:,:,1611))
  call Hloop_AQ_V(ntryL,G1H64(1612),ex1(:),G1H32(1612),m3h2x32(:,1612),heltab2x64(:,:,1612))
  call Hloop_AQ_Z(ntryL,G1H64(1613),ex1(:),G1H32(1613),ngZl,m3h2x32(:,1613),heltab2x64(:,:,1613))
  call Hloop_AQ_V(ntryL,G1H64(1614),ex1(:),G1H32(1614),m3h2x32(:,1614),heltab2x64(:,:,1614))
  call Hloop_AQ_Z(ntryL,G1H64(1615),ex1(:),G1H32(1615),ngZl,m3h2x32(:,1615),heltab2x64(:,:,1615))
  call Hloop_AQ_V(ntryL,G1H64(1616),ex1(:),G1H32(1616),m3h2x32(:,1616),heltab2x64(:,:,1616))
  call Hloop_AQ_V(ntryL,G1H64(1617),ex1(:),G1H32(1617),m3h2x32(:,1617),heltab2x64(:,:,1617))
  call Hloop_AQ_V(ntryL,G1H64(1618),ex1(:),G1H32(1618),m3h2x32(:,1618),heltab2x64(:,:,1618))
  call Hloop_AQ_Z(ntryL,G1H64(1619),ex1(:),G1H32(1619),ngZl,m3h2x32(:,1619),heltab2x64(:,:,1619))
  call Hloop_AQ_V(ntryL,G1H64(1620),ex1(:),G1H32(1620),m3h2x32(:,1620),heltab2x64(:,:,1620))
  call Hloop_AQ_Z(ntryL,G1H64(1621),ex1(:),G1H32(1621),ngZl,m3h2x32(:,1621),heltab2x64(:,:,1621))
  call Hloop_AQ_V(ntryL,G1H64(1622),ex1(:),G1H32(1622),m3h2x32(:,1622),heltab2x64(:,:,1622))
  call Hloop_AQ_V(ntryL,G1H64(1623),ex1(:),G1H32(1623),m3h2x32(:,1623),heltab2x64(:,:,1623))
  call Hloop_AQ_V(ntryL,G1H64(1624),ex1(:),G1H32(1624),m3h2x32(:,1624),heltab2x64(:,:,1624))
  call Hloop_AQ_Z(ntryL,G1H64(1625),ex1(:),G1H32(1625),ngZl,m3h2x32(:,1625),heltab2x64(:,:,1625))
  call Hloop_AQ_V(ntryL,G1H64(1626),ex1(:),G1H32(1626),m3h2x32(:,1626),heltab2x64(:,:,1626))
  call Hloop_AQ_Z(ntryL,G1H64(1627),ex1(:),G1H32(1627),ngZl,m3h2x32(:,1627),heltab2x64(:,:,1627))
  call Hloop_AQ_Z(ntryL,G1H64(1628),ex1(:),G1H32(1628),ngZl,m3h2x32(:,1628),heltab2x64(:,:,1628))
  call Hloop_AQ_S(ntryL,G1H64(1629),ex1(:),G1H32(1629),ngH,m3h2x32(:,1629),heltab2x64(:,:,1629))
  call Hloop_AQ_S(ntryL,G1H64(1630),ex1(:),G1H32(1630),ngH,m3h2x32(:,1630),heltab2x64(:,:,1630))
  call Hloop_AQ_S(ntryL,G1H64(1631),ex1(:),G1H32(1631),ngX,m3h2x32(:,1631),heltab2x64(:,:,1631))
  call Hloop_AQ_S(ntryL,G1H64(1632),ex1(:),G1H32(1632),ngX,m3h2x32(:,1632),heltab2x64(:,:,1632))
  call Hloop_AQ_S(ntryL,G1H64(1633),ex1(:),G1H32(1633),ngH,m3h2x32(:,1633),heltab2x64(:,:,1633))
  call Hloop_AQ_S(ntryL,G1H64(1634),ex1(:),G1H32(1634),ngH,m3h2x32(:,1634),heltab2x64(:,:,1634))
  call Hloop_AQ_S(ntryL,G1H64(1635),ex1(:),G1H32(1635),ngX,m3h2x32(:,1635),heltab2x64(:,:,1635))
  call Hloop_AQ_S(ntryL,G1H64(1636),ex1(:),G1H32(1636),ngX,m3h2x32(:,1636),heltab2x64(:,:,1636))
  call Hloop_AQ_V(ntryL,G1H64(1637),ex1(:),G1H32(1637),m3h2x32(:,1637),heltab2x64(:,:,1637))
  call Hloop_AQ_V(ntryL,G1H64(1638),ex1(:),G1H32(1638),m3h2x32(:,1638),heltab2x64(:,:,1638))
  call Hloop_AQ_V(ntryL,G1H64(1639),ex1(:),G1H32(1639),m3h2x32(:,1639),heltab2x64(:,:,1639))
  call Hloop_AQ_V(ntryL,G1H64(1640),ex1(:),G1H32(1640),m3h2x32(:,1640),heltab2x64(:,:,1640))
  call Hloop_AQ_S(ntryL,G1H64(1641),ex1(:),G1H32(1641),ngH,m3h2x32(:,1641),heltab2x64(:,:,1641))
  call Hloop_AQ_S(ntryL,G1H64(1642),ex1(:),G1H32(1642),ngX,m3h2x32(:,1642),heltab2x64(:,:,1642))
  call Hloop_AQ_S(ntryL,G1H64(1643),ex1(:),G1H32(1643),ngH,m3h2x32(:,1643),heltab2x64(:,:,1643))
  call Hloop_AQ_S(ntryL,G1H64(1644),ex1(:),G1H32(1644),ngH,m3h2x32(:,1644),heltab2x64(:,:,1644))
  call Hloop_AQ_S(ntryL,G1H64(1645),ex1(:),G1H32(1645),ngX,m3h2x32(:,1645),heltab2x64(:,:,1645))
  call Hloop_AQ_S(ntryL,G1H64(1646),ex1(:),G1H32(1646),ngX,m3h2x32(:,1646),heltab2x64(:,:,1646))
  call Hloop_AQ_V(ntryL,G1H64(1647),ex1(:),G1H32(1647),m3h2x32(:,1647),heltab2x64(:,:,1647))
  call Hloop_AQ_V(ntryL,G1H64(1648),ex1(:),G1H32(1648),m3h2x32(:,1648),heltab2x64(:,:,1648))
  call Hloop_AQ_V(ntryL,G1H64(1649),ex1(:),G1H32(1649),m3h2x32(:,1649),heltab2x64(:,:,1649))
  call Hloop_AQ_Z(ntryL,G1H64(1650),ex1(:),G1H32(1650),ngZl,m3h2x32(:,1650),heltab2x64(:,:,1650))
  call Hloop_AQ_V(ntryL,G1H64(1651),ex1(:),G1H32(1651),m3h2x32(:,1651),heltab2x64(:,:,1651))
  call Hloop_AQ_Z(ntryL,G1H64(1652),ex1(:),G1H32(1652),ngZl,m3h2x32(:,1652),heltab2x64(:,:,1652))
  call Hloop_AQ_V(ntryL,G1H64(1653),ex1(:),G1H32(1653),m3h2x32(:,1653),heltab2x64(:,:,1653))
  call Hloop_AQ_V(ntryL,G1H64(1654),ex1(:),G1H32(1654),m3h2x32(:,1654),heltab2x64(:,:,1654))
  call Hloop_AQ_V(ntryL,G1H64(1655),ex1(:),G1H32(1655),m3h2x32(:,1655),heltab2x64(:,:,1655))
  call Hloop_AQ_Z(ntryL,G1H64(1656),ex1(:),G1H32(1656),ngZl,m3h2x32(:,1656),heltab2x64(:,:,1656))
  call Hloop_AQ_V(ntryL,G1H64(1657),ex1(:),G1H32(1657),m3h2x32(:,1657),heltab2x64(:,:,1657))
  call Hloop_AQ_Z(ntryL,G1H64(1658),ex1(:),G1H32(1658),ngZl,m3h2x32(:,1658),heltab2x64(:,:,1658))
  call Hloop_AQ_V(ntryL,G1H64(1659),ex1(:),G1H32(1659),m3h2x32(:,1659),heltab2x64(:,:,1659))
  call Hloop_AQ_V(ntryL,G1H64(1660),ex1(:),G1H32(1660),m3h2x32(:,1660),heltab2x64(:,:,1660))
  call Hloop_AQ_V(ntryL,G1H64(1661),ex1(:),G1H32(1661),m3h2x32(:,1661),heltab2x64(:,:,1661))
  call Hloop_AQ_Z(ntryL,G1H64(1662),ex1(:),G1H32(1662),ngZl,m3h2x32(:,1662),heltab2x64(:,:,1662))
  call Hloop_AQ_V(ntryL,G1H64(1663),ex1(:),G1H32(1663),m3h2x32(:,1663),heltab2x64(:,:,1663))
  call Hloop_AQ_Z(ntryL,G1H64(1664),ex1(:),G1H32(1664),ngZl,m3h2x32(:,1664),heltab2x64(:,:,1664))
  call Hloop_AQ_Z(ntryL,G1H64(1665),ex1(:),G1H32(1665),ngZl,m3h2x32(:,1665),heltab2x64(:,:,1665))
  call Hloop_AQ_S(ntryL,G1H64(1666),ex1(:),G1H32(1666),ngH,m3h2x32(:,1666),heltab2x64(:,:,1666))
  call Hloop_AQ_S(ntryL,G1H64(1667),ex1(:),G1H32(1667),ngH,m3h2x32(:,1667),heltab2x64(:,:,1667))
  call Hloop_AQ_S(ntryL,G1H64(1668),ex1(:),G1H32(1668),ngX,m3h2x32(:,1668),heltab2x64(:,:,1668))
  call Hloop_AQ_S(ntryL,G1H64(1669),ex1(:),G1H32(1669),ngX,m3h2x32(:,1669),heltab2x64(:,:,1669))
  call Hloop_AQ_S(ntryL,G1H64(1670),ex1(:),G1H32(1670),ngH,m3h2x32(:,1670),heltab2x64(:,:,1670))
  call Hloop_AQ_S(ntryL,G1H64(1671),ex1(:),G1H32(1671),ngH,m3h2x32(:,1671),heltab2x64(:,:,1671))
  call Hloop_AQ_S(ntryL,G1H64(1672),ex1(:),G1H32(1672),ngX,m3h2x32(:,1672),heltab2x64(:,:,1672))
  call Hloop_AQ_S(ntryL,G1H64(1673),ex1(:),G1H32(1673),ngX,m3h2x32(:,1673),heltab2x64(:,:,1673))
  call Hloop_AQ_V(ntryL,G1H64(1674),ex1(:),G1H32(1674),m3h2x32(:,1674),heltab2x64(:,:,1674))
  call Hloop_AQ_V(ntryL,G1H64(1675),ex1(:),G1H32(1675),m3h2x32(:,1675),heltab2x64(:,:,1675))
  call Hloop_AQ_V(ntryL,G1H64(1676),ex1(:),G1H32(1676),m3h2x32(:,1676),heltab2x64(:,:,1676))
  call Hloop_AQ_V(ntryL,G1H64(1677),ex1(:),G1H32(1677),m3h2x32(:,1677),heltab2x64(:,:,1677))
  call Hloop_AQ_S(ntryL,G1H64(1678),ex1(:),G1H32(1678),ngH,m3h2x32(:,1678),heltab2x64(:,:,1678))
  call Hloop_AQ_S(ntryL,G1H64(1679),ex1(:),G1H32(1679),ngX,m3h2x32(:,1679),heltab2x64(:,:,1679))
  call Hloop_AQ_S(ntryL,G1H64(1680),ex1(:),G1H32(1680),ngH,m3h2x32(:,1680),heltab2x64(:,:,1680))
  call Hloop_AQ_S(ntryL,G1H64(1681),ex1(:),G1H32(1681),ngH,m3h2x32(:,1681),heltab2x64(:,:,1681))
  call Hloop_AQ_S(ntryL,G1H64(1682),ex1(:),G1H32(1682),ngX,m3h2x32(:,1682),heltab2x64(:,:,1682))
  call Hloop_AQ_S(ntryL,G1H64(1683),ex1(:),G1H32(1683),ngX,m3h2x32(:,1683),heltab2x64(:,:,1683))
  call Hloop_AQ_V(ntryL,G1H64(1684),ex1(:),G1H32(1684),m3h2x32(:,1684),heltab2x64(:,:,1684))
  call Hloop_AQ_V(ntryL,G1H64(1685),ex1(:),G1H32(1685),m3h2x32(:,1685),heltab2x64(:,:,1685))
  call Hloop_AQ_V(ntryL,G1H64(1686),ex1(:),G1H32(1686),m3h2x32(:,1686),heltab2x64(:,:,1686))
  call Hloop_AQ_Z(ntryL,G1H64(1687),ex1(:),G1H32(1687),ngZl,m3h2x32(:,1687),heltab2x64(:,:,1687))
  call Hloop_AQ_V(ntryL,G1H64(1688),ex1(:),G1H32(1688),m3h2x32(:,1688),heltab2x64(:,:,1688))
  call Hloop_AQ_Z(ntryL,G1H64(1689),ex1(:),G1H32(1689),ngZl,m3h2x32(:,1689),heltab2x64(:,:,1689))
  call Hloop_AQ_V(ntryL,G1H64(1690),ex1(:),G1H32(1690),m3h2x32(:,1690),heltab2x64(:,:,1690))
  call Hloop_AQ_V(ntryL,G1H64(1691),ex1(:),G1H32(1691),m3h2x32(:,1691),heltab2x64(:,:,1691))
  call Hloop_AQ_V(ntryL,G1H64(1692),ex1(:),G1H32(1692),m3h2x32(:,1692),heltab2x64(:,:,1692))
  call Hloop_AQ_Z(ntryL,G1H64(1693),ex1(:),G1H32(1693),ngZl,m3h2x32(:,1693),heltab2x64(:,:,1693))
  call Hloop_AQ_V(ntryL,G1H64(1694),ex1(:),G1H32(1694),m3h2x32(:,1694),heltab2x64(:,:,1694))
  call Hloop_AQ_Z(ntryL,G1H64(1695),ex1(:),G1H32(1695),ngZl,m3h2x32(:,1695),heltab2x64(:,:,1695))
  call Hloop_AQ_V(ntryL,G1H64(1696),ex1(:),G1H32(1696),m3h2x32(:,1696),heltab2x64(:,:,1696))
  call Hloop_AQ_V(ntryL,G1H64(1697),ex1(:),G1H32(1697),m3h2x32(:,1697),heltab2x64(:,:,1697))
  call Hloop_AQ_V(ntryL,G1H64(1698),ex1(:),G1H32(1698),m3h2x32(:,1698),heltab2x64(:,:,1698))
  call Hloop_AQ_Z(ntryL,G1H64(1699),ex1(:),G1H32(1699),ngZl,m3h2x32(:,1699),heltab2x64(:,:,1699))
  call Hloop_AQ_V(ntryL,G1H64(1700),ex1(:),G1H32(1700),m3h2x32(:,1700),heltab2x64(:,:,1700))
  call Hloop_AQ_Z(ntryL,G1H64(1701),ex1(:),G1H32(1701),ngZl,m3h2x32(:,1701),heltab2x64(:,:,1701))
  call Hloop_AQ_Z(ntryL,G1H64(1702),ex1(:),G1H32(1702),ngZl,m3h2x32(:,1702),heltab2x64(:,:,1702))
  call Hloop_AQ_S(ntryL,G1H64(1703),ex1(:),G1H32(1703),ngH,m3h2x32(:,1703),heltab2x64(:,:,1703))
  call Hloop_AQ_S(ntryL,G1H64(1704),ex1(:),G1H32(1704),ngH,m3h2x32(:,1704),heltab2x64(:,:,1704))
  call Hloop_AQ_S(ntryL,G1H64(1705),ex1(:),G1H32(1705),ngX,m3h2x32(:,1705),heltab2x64(:,:,1705))
  call Hloop_AQ_S(ntryL,G1H64(1706),ex1(:),G1H32(1706),ngX,m3h2x32(:,1706),heltab2x64(:,:,1706))
  call Hloop_AQ_S(ntryL,G1H64(1707),ex1(:),G1H32(1707),ngH,m3h2x32(:,1707),heltab2x64(:,:,1707))
  call Hloop_AQ_S(ntryL,G1H64(1708),ex1(:),G1H32(1708),ngH,m3h2x32(:,1708),heltab2x64(:,:,1708))
  call Hloop_AQ_S(ntryL,G1H64(1709),ex1(:),G1H32(1709),ngX,m3h2x32(:,1709),heltab2x64(:,:,1709))
  call Hloop_AQ_S(ntryL,G1H64(1710),ex1(:),G1H32(1710),ngX,m3h2x32(:,1710),heltab2x64(:,:,1710))
  call Hloop_AQ_V(ntryL,G1H64(1711),ex1(:),G1H32(1711),m3h2x32(:,1711),heltab2x64(:,:,1711))
  call Hloop_AQ_V(ntryL,G1H64(1712),ex1(:),G1H32(1712),m3h2x32(:,1712),heltab2x64(:,:,1712))
  call Hloop_AQ_V(ntryL,G1H64(1713),ex1(:),G1H32(1713),m3h2x32(:,1713),heltab2x64(:,:,1713))
  call Hloop_AQ_V(ntryL,G1H64(1714),ex1(:),G1H32(1714),m3h2x32(:,1714),heltab2x64(:,:,1714))
  call Hloop_AQ_S(ntryL,G1H64(1715),ex1(:),G1H32(1715),ngH,m3h2x32(:,1715),heltab2x64(:,:,1715))
  call Hloop_AQ_S(ntryL,G1H64(1716),ex1(:),G1H32(1716),ngX,m3h2x32(:,1716),heltab2x64(:,:,1716))
  call Hloop_AQ_S(ntryL,G1H64(1717),ex1(:),G1H32(1717),ngH,m3h2x32(:,1717),heltab2x64(:,:,1717))
  call Hloop_AQ_S(ntryL,G1H64(1718),ex1(:),G1H32(1718),ngH,m3h2x32(:,1718),heltab2x64(:,:,1718))
  call Hloop_AQ_S(ntryL,G1H64(1719),ex1(:),G1H32(1719),ngX,m3h2x32(:,1719),heltab2x64(:,:,1719))
  call Hloop_AQ_S(ntryL,G1H64(1720),ex1(:),G1H32(1720),ngX,m3h2x32(:,1720),heltab2x64(:,:,1720))
  call Hloop_AQ_V(ntryL,G1H64(1721),ex1(:),G1H32(1721),m3h2x32(:,1721),heltab2x64(:,:,1721))
  call Hloop_AQ_V(ntryL,G1H64(1722),ex1(:),G1H32(1722),m3h2x32(:,1722),heltab2x64(:,:,1722))
  call Hloop_AQ_V(ntryL,G1H64(1723),ex1(:),G1H32(1723),m3h2x32(:,1723),heltab2x64(:,:,1723))
  call Hloop_AQ_Z(ntryL,G1H64(1724),ex1(:),G1H32(1724),ngZl,m3h2x32(:,1724),heltab2x64(:,:,1724))
  call Hloop_AQ_V(ntryL,G1H64(1725),ex1(:),G1H32(1725),m3h2x32(:,1725),heltab2x64(:,:,1725))
  call Hloop_AQ_Z(ntryL,G1H64(1726),ex1(:),G1H32(1726),ngZl,m3h2x32(:,1726),heltab2x64(:,:,1726))
  call Hloop_AQ_V(ntryL,G1H64(1727),ex1(:),G1H32(1727),m3h2x32(:,1727),heltab2x64(:,:,1727))
  call Hloop_AQ_V(ntryL,G1H64(1728),ex1(:),G1H32(1728),m3h2x32(:,1728),heltab2x64(:,:,1728))
  call Hloop_AQ_V(ntryL,G1H64(1729),ex1(:),G1H32(1729),m3h2x32(:,1729),heltab2x64(:,:,1729))
  call Hloop_AQ_Z(ntryL,G1H64(1730),ex1(:),G1H32(1730),ngZl,m3h2x32(:,1730),heltab2x64(:,:,1730))
  call Hloop_AQ_V(ntryL,G1H64(1731),ex1(:),G1H32(1731),m3h2x32(:,1731),heltab2x64(:,:,1731))
  call Hloop_AQ_Z(ntryL,G1H64(1732),ex1(:),G1H32(1732),ngZl,m3h2x32(:,1732),heltab2x64(:,:,1732))
  call Hloop_AQ_V(ntryL,G1H64(1733),ex1(:),G1H32(1733),m3h2x32(:,1733),heltab2x64(:,:,1733))
  call Hloop_AQ_V(ntryL,G1H64(1734),ex1(:),G1H32(1734),m3h2x32(:,1734),heltab2x64(:,:,1734))
  call Hloop_AQ_V(ntryL,G1H64(1735),ex1(:),G1H32(1735),m3h2x32(:,1735),heltab2x64(:,:,1735))
  call Hloop_AQ_Z(ntryL,G1H64(1736),ex1(:),G1H32(1736),ngZl,m3h2x32(:,1736),heltab2x64(:,:,1736))
  call Hloop_AQ_V(ntryL,G1H64(1737),ex1(:),G1H32(1737),m3h2x32(:,1737),heltab2x64(:,:,1737))
  call Hloop_AQ_Z(ntryL,G1H64(1738),ex1(:),G1H32(1738),ngZl,m3h2x32(:,1738),heltab2x64(:,:,1738))
  call Hloop_AQ_Z(ntryL,G1H64(1739),ex1(:),G1H32(1739),ngZl,m3h2x32(:,1739),heltab2x64(:,:,1739))
  call Hloop_AQ_S(ntryL,G1H64(1740),ex1(:),G1H32(1740),ngH,m3h2x32(:,1740),heltab2x64(:,:,1740))
  call Hloop_AQ_S(ntryL,G1H64(1741),ex1(:),G1H32(1741),ngH,m3h2x32(:,1741),heltab2x64(:,:,1741))
  call Hloop_AQ_S(ntryL,G1H64(1742),ex1(:),G1H32(1742),ngX,m3h2x32(:,1742),heltab2x64(:,:,1742))
  call Hloop_AQ_S(ntryL,G1H64(1743),ex1(:),G1H32(1743),ngX,m3h2x32(:,1743),heltab2x64(:,:,1743))
  call Hloop_AQ_S(ntryL,G1H64(1744),ex1(:),G1H32(1744),ngH,m3h2x32(:,1744),heltab2x64(:,:,1744))
  call Hloop_AQ_S(ntryL,G1H64(1745),ex1(:),G1H32(1745),ngH,m3h2x32(:,1745),heltab2x64(:,:,1745))
  call Hloop_AQ_S(ntryL,G1H64(1746),ex1(:),G1H32(1746),ngX,m3h2x32(:,1746),heltab2x64(:,:,1746))
  call Hloop_AQ_S(ntryL,G1H64(1747),ex1(:),G1H32(1747),ngX,m3h2x32(:,1747),heltab2x64(:,:,1747))
  call Hloop_AQ_V(ntryL,G1H64(1748),ex1(:),G1H32(1748),m3h2x32(:,1748),heltab2x64(:,:,1748))
  call Hloop_AQ_V(ntryL,G1H64(1749),ex1(:),G1H32(1749),m3h2x32(:,1749),heltab2x64(:,:,1749))
  call Hloop_AQ_V(ntryL,G1H64(1750),ex1(:),G1H32(1750),m3h2x32(:,1750),heltab2x64(:,:,1750))
  call Hloop_AQ_V(ntryL,G1H64(1751),ex1(:),G1H32(1751),m3h2x32(:,1751),heltab2x64(:,:,1751))
  call Hloop_AQ_S(ntryL,G1H64(1752),ex1(:),G1H32(1752),ngH,m3h2x32(:,1752),heltab2x64(:,:,1752))
  call Hloop_AQ_S(ntryL,G1H64(1753),ex1(:),G1H32(1753),ngX,m3h2x32(:,1753),heltab2x64(:,:,1753))
  call Hloop_AQ_S(ntryL,G1H64(1754),ex1(:),G1H32(1754),ngH,m3h2x32(:,1754),heltab2x64(:,:,1754))
  call Hloop_AQ_S(ntryL,G1H64(1755),ex1(:),G1H32(1755),ngH,m3h2x32(:,1755),heltab2x64(:,:,1755))
  call Hloop_AQ_S(ntryL,G1H64(1756),ex1(:),G1H32(1756),ngX,m3h2x32(:,1756),heltab2x64(:,:,1756))
  call Hloop_AQ_S(ntryL,G1H64(1757),ex1(:),G1H32(1757),ngX,m3h2x32(:,1757),heltab2x64(:,:,1757))
  call Hloop_AQ_V(ntryL,G1H64(1758),ex1(:),G1H32(1758),m3h2x32(:,1758),heltab2x64(:,:,1758))
  call Hloop_AQ_V(ntryL,G1H64(1759),ex1(:),G1H32(1759),m3h2x32(:,1759),heltab2x64(:,:,1759))
  call Hloop_AQ_V(ntryL,G1H64(1760),ex1(:),G1H32(1760),m3h2x32(:,1760),heltab2x64(:,:,1760))
  call Hloop_AQ_Z(ntryL,G1H64(1761),ex1(:),G1H32(1761),ngZl,m3h2x32(:,1761),heltab2x64(:,:,1761))
  call Hloop_AQ_V(ntryL,G1H64(1762),ex1(:),G1H32(1762),m3h2x32(:,1762),heltab2x64(:,:,1762))
  call Hloop_AQ_Z(ntryL,G1H64(1763),ex1(:),G1H32(1763),ngZl,m3h2x32(:,1763),heltab2x64(:,:,1763))
  call Hloop_AQ_V(ntryL,G1H64(1764),ex1(:),G1H32(1764),m3h2x32(:,1764),heltab2x64(:,:,1764))
  call Hloop_AQ_V(ntryL,G1H64(1765),ex1(:),G1H32(1765),m3h2x32(:,1765),heltab2x64(:,:,1765))
  call Hloop_AQ_V(ntryL,G1H64(1766),ex1(:),G1H32(1766),m3h2x32(:,1766),heltab2x64(:,:,1766))
  call Hloop_AQ_Z(ntryL,G1H64(1767),ex1(:),G1H32(1767),ngZl,m3h2x32(:,1767),heltab2x64(:,:,1767))
  call Hloop_AQ_V(ntryL,G1H64(1768),ex1(:),G1H32(1768),m3h2x32(:,1768),heltab2x64(:,:,1768))
  call Hloop_AQ_Z(ntryL,G1H64(1769),ex1(:),G1H32(1769),ngZl,m3h2x32(:,1769),heltab2x64(:,:,1769))
  call Hloop_AQ_V(ntryL,G1H64(1770),ex1(:),G1H32(1770),m3h2x32(:,1770),heltab2x64(:,:,1770))
  call Hloop_AQ_V(ntryL,G1H64(1771),ex1(:),G1H32(1771),m3h2x32(:,1771),heltab2x64(:,:,1771))
  call Hloop_AQ_V(ntryL,G1H64(1772),ex1(:),G1H32(1772),m3h2x32(:,1772),heltab2x64(:,:,1772))
  call Hloop_AQ_Z(ntryL,G1H64(1773),ex1(:),G1H32(1773),ngZl,m3h2x32(:,1773),heltab2x64(:,:,1773))
  call Hloop_AQ_V(ntryL,G1H64(1774),ex1(:),G1H32(1774),m3h2x32(:,1774),heltab2x64(:,:,1774))
  call Hloop_AQ_Z(ntryL,G1H64(1775),ex1(:),G1H32(1775),ngZl,m3h2x32(:,1775),heltab2x64(:,:,1775))
  call Hloop_AQ_Z(ntryL,G1H64(1776),ex1(:),G1H32(1776),ngZl,m3h2x32(:,1776),heltab2x64(:,:,1776))
  call Hloop_SA_Q(ntryL,G1H32(1),ex3(:),G1H16(1),ngH,m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1),n2h16(1))
  call Hloop_SA_Q(ntryL,G1H32(2),ex3(:),G1H16(1),ngX,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(2),n2h16(2))
  call Hloop_SA_Q(ntryL,G1H32(3),ex3(:),G1H16(1),ngH,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(3),n2h16(3))
  call Hloop_SA_Q(ntryL,G1H32(4),ex3(:),G1H16(1),ngX,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(4),n2h16(4))
  call Hloop_VA_Q(ntryL,G1H32(5),ex3(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(5),n2h16(5))
  call Hloop_VA_Q(ntryL,G1H32(6),ex3(:),G1H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(6),n2h16(6))
  call Hloop_VA_Q(ntryL,G1H32(7),ex3(:),G1H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(7),n2h16(7))
  call Hloop_VA_Q(ntryL,G1H32(8),ex3(:),G1H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(8),n2h16(8))
  call Hloop_SA_Q(ntryL,G1H32(9),ex3(:),G1H16(1),ngH,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(9),n2h16(9))
  call Hloop_SA_Q(ntryL,G1H32(10),ex3(:),G1H16(1),ngH,m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(10),n2h16(10))
  call Hloop_SA_Q(ntryL,G1H32(11),ex3(:),G1H16(1),ngX,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(11),n2h16(11))
  call Hloop_SA_Q(ntryL,G1H32(12),ex3(:),G1H16(1),ngX,m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(12),n2h16(12))
  call Hloop_VA_Q(ntryL,G1H32(13),ex3(:),G1H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(13),n2h16(13))
  call Hloop_VA_Q(ntryL,G1H32(14),ex3(:),G1H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(14),n2h16(14))
  call Hloop_VA_Q(ntryL,G1H32(15),ex3(:),G1H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(15),n2h16(15))
  call Hloop_ZA_Q(ntryL,G1H32(16),ex3(:),G1H16(1),ngZl,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(16),n2h16(16))
  call Hloop_VA_Q(ntryL,G1H32(17),ex3(:),G1H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(17),n2h16(17))
  call Hloop_ZA_Q(ntryL,G1H32(18),ex3(:),G1H16(1),ngZl,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(18),n2h16(18))
  call Hloop_SA_Q(ntryL,G1H32(19),ex3(:),G1H16(1),ngH,m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(19),n2h16(19))
  call Hloop_SA_Q(ntryL,G1H32(20),ex3(:),G1H16(1),ngX,m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(20),n2h16(20))
  call Hloop_SA_Q(ntryL,G1H32(21),ex3(:),G1H16(1),ngH,m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(21),n2h16(21))
  call Hloop_SA_Q(ntryL,G1H32(22),ex3(:),G1H16(1),ngH,m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(22),n2h16(22))
  call Hloop_SA_Q(ntryL,G1H32(23),ex3(:),G1H16(1),ngX,m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(23),n2h16(23))
  call Hloop_SA_Q(ntryL,G1H32(24),ex3(:),G1H16(1),ngX,m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(24),n2h16(24))
  call Hloop_VA_Q(ntryL,G1H32(25),ex3(:),G1H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(25),n2h16(25))
  call Hloop_VA_Q(ntryL,G1H32(26),ex3(:),G1H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(26),n2h16(26))
  call Hloop_ZA_Q(ntryL,G1H32(27),ex3(:),G1H16(1),ngZl,m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(27),n2h16(27))
  call Hloop_VA_Q(ntryL,G1H32(28),ex3(:),G1H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(28),n2h16(28))
  call Hloop_ZA_Q(ntryL,G1H32(29),ex3(:),G1H16(1),ngZl,m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(29),n2h16(29))
  call Hloop_VA_Q(ntryL,G1H32(30),ex3(:),G1H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(30),n2h16(30))
  call Hloop_VA_Q(ntryL,G1H32(31),ex3(:),G1H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(31),n2h16(31))
  call Hloop_VA_Q(ntryL,G1H32(32),ex3(:),G1H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(32),n2h16(32))
  call Hloop_ZA_Q(ntryL,G1H32(33),ex3(:),G1H16(1),ngZl,m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(33),n2h16(33))
  call Hloop_VA_Q(ntryL,G1H32(34),ex3(:),G1H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(34),n2h16(34))
  call Hloop_ZA_Q(ntryL,G1H32(35),ex3(:),G1H16(1),ngZl,m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(35),n2h16(35))
  call Hloop_VA_Q(ntryL,G1H32(36),ex3(:),G1H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(36),n2h16(36))
  call Hloop_ZA_Q(ntryL,G1H32(37),ex3(:),G1H16(1),ngZl,m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(37),n2h16(37))
  call Hloop_VA_Q(ntryL,G1H32(38),ex4(:),G1H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(38),n2h16(38))
  call Hloop_VA_Q(ntryL,G1H32(39),ex4(:),G1H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(39),n2h16(39))
  call Hloop_VA_Q(ntryL,G1H32(40),ex4(:),G1H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(40),n2h16(40))
  call Hloop_VA_Q(ntryL,G1H32(41),ex4(:),G1H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(41),n2h16(41))
  call Hloop_SA_Q(ntryL,G1H32(42),ex4(:),G1H16(1),ngH,m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(42),n2h16(42))
  call Hloop_SA_Q(ntryL,G1H32(43),ex4(:),G1H16(1),ngX,m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(43),n2h16(43))
  call Hloop_SA_Q(ntryL,G1H32(44),ex4(:),G1H16(1),ngH,m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(44),n2h16(44))
  call Hloop_SA_Q(ntryL,G1H32(45),ex4(:),G1H16(1),ngX,m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(45),n2h16(45))
  call Hloop_SA_Q(ntryL,G1H32(46),ex4(:),G1H16(1),ngH,m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(46),n2h16(46))
  call Hloop_SA_Q(ntryL,G1H32(47),ex4(:),G1H16(1),ngX,m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(47),n2h16(47))
  call Hloop_SA_Q(ntryL,G1H32(48),ex4(:),G1H16(1),ngH,m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(48),n2h16(48))
  call Hloop_SA_Q(ntryL,G1H32(49),ex4(:),G1H16(1),ngX,m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(49),n2h16(49))
  call Hloop_VA_Q(ntryL,G1H32(50),ex4(:),G1H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(50),n2h16(50))
  call Hloop_VA_Q(ntryL,G1H32(51),ex4(:),G1H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(51),n2h16(51))
  call Hloop_ZA_Q(ntryL,G1H32(52),ex4(:),G1H16(1),ngZl,m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(52),n2h16(52))
  call Hloop_VA_Q(ntryL,G1H32(53),ex4(:),G1H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(53),n2h16(53))
  call Hloop_ZA_Q(ntryL,G1H32(54),ex4(:),G1H16(1),ngZl,m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(54),n2h16(54))
  call Hloop_VA_Q(ntryL,G1H32(55),ex4(:),G1H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(55),n2h16(55))
  call Hloop_VA_Q(ntryL,G1H32(56),ex4(:),G1H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(56),n2h16(56))
  call Hloop_VA_Q(ntryL,G1H32(57),ex4(:),G1H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(57),n2h16(57))
  call Hloop_ZA_Q(ntryL,G1H32(58),ex4(:),G1H16(1),ngZl,m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(58),n2h16(58))
  call Hloop_VA_Q(ntryL,G1H32(59),ex4(:),G1H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(59),n2h16(59))
  call Hloop_ZA_Q(ntryL,G1H32(60),ex4(:),G1H16(1),ngZl,m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(60),n2h16(60))
  call Hloop_VA_Q(ntryL,G1H32(61),ex4(:),G1H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(61),n2h16(61))
  call Hloop_SA_Q(ntryL,G1H32(62),ex4(:),G1H16(1),ngH,m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(62),n2h16(62))
  call Hloop_SA_Q(ntryL,G1H32(63),ex4(:),G1H16(1),ngX,m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(63),n2h16(63))
  call Hloop_SA_Q(ntryL,G1H32(64),ex4(:),G1H16(1),ngH,m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(64),n2h16(64))
  call Hloop_SA_Q(ntryL,G1H32(65),ex4(:),G1H16(1),ngH,m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(65),n2h16(65))
  call Hloop_SA_Q(ntryL,G1H32(66),ex4(:),G1H16(1),ngX,m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(66),n2h16(66))
  call Hloop_SA_Q(ntryL,G1H32(67),ex4(:),G1H16(1),ngX,m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(67),n2h16(67))
  call Hloop_VA_Q(ntryL,G1H32(68),ex4(:),G1H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(68),n2h16(68))
  call Hloop_ZA_Q(ntryL,G1H32(69),ex4(:),G1H16(1),ngZl,m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(69),n2h16(69))
  call Hloop_VA_Q(ntryL,G1H32(70),ex4(:),G1H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(70),n2h16(70))
  call Hloop_VA_Q(ntryL,G1H32(71),ex4(:),G1H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(71),n2h16(71))
  call Hloop_ZA_Q(ntryL,G1H32(72),ex4(:),G1H16(1),ngZl,m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(72),n2h16(72))
  call Hloop_ZA_Q(ntryL,G1H32(73),ex4(:),G1H16(1),ngZl,m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(73),n2h16(73))
  call Hloop_VA_Q(ntryL,G1H32(74),ex4(:),G1H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(74),n2h16(74))
  call Hloop_SQ_A(ntryL,G1H32(75),ex1(:),G1H16(1),ngH,m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(75),n2h16(75))
  call Hloop_SQ_A(ntryL,G1H32(76),ex1(:),G1H16(1),ngH,m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(76),n2h16(76))
  call Hloop_SQ_A(ntryL,G1H32(77),ex1(:),G1H16(1),ngX,m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(77),n2h16(77))
  call Hloop_SQ_A(ntryL,G1H32(78),ex1(:),G1H16(1),ngX,m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(78),n2h16(78))
  call Hloop_SQ_A(ntryL,G1H32(79),ex1(:),G1H16(1),ngH,m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(79),n2h16(79))
  call Hloop_SQ_A(ntryL,G1H32(80),ex1(:),G1H16(1),ngH,m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(80),n2h16(80))
  call Hloop_SQ_A(ntryL,G1H32(81),ex1(:),G1H16(1),ngX,m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(81),n2h16(81))
  call Hloop_SQ_A(ntryL,G1H32(82),ex1(:),G1H16(1),ngX,m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(82),n2h16(82))
  call Hloop_VQ_A(ntryL,G1H32(83),ex1(:),G1H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(83),n2h16(83))
  call Hloop_VQ_A(ntryL,G1H32(84),ex1(:),G1H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(84),n2h16(84))
  call Hloop_VQ_A(ntryL,G1H32(85),ex1(:),G1H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(85),n2h16(85))
  call Hloop_VQ_A(ntryL,G1H32(86),ex1(:),G1H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(86),n2h16(86))
  call Hloop_SQ_A(ntryL,G1H32(87),ex1(:),G1H16(1),ngH,m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(87),n2h16(87))
  call Hloop_SQ_A(ntryL,G1H32(88),ex1(:),G1H16(1),ngX,m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(88),n2h16(88))
  call Hloop_SQ_A(ntryL,G1H32(89),ex1(:),G1H16(1),ngH,m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(89),n2h16(89))
  call Hloop_SQ_A(ntryL,G1H32(90),ex1(:),G1H16(1),ngH,m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(90),n2h16(90))
  call Hloop_SQ_A(ntryL,G1H32(91),ex1(:),G1H16(1),ngX,m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(91),n2h16(91))
  call Hloop_SQ_A(ntryL,G1H32(92),ex1(:),G1H16(1),ngX,m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(92),n2h16(92))
  call Hloop_VQ_A(ntryL,G1H32(93),ex1(:),G1H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(93),n2h16(93))
  call Hloop_VQ_A(ntryL,G1H32(94),ex1(:),G1H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(94),n2h16(94))
  call Hloop_VQ_A(ntryL,G1H32(95),ex1(:),G1H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(95),n2h16(95))
  call Hloop_ZQ_A(ntryL,G1H32(96),ex1(:),G1H16(1),ngZl,m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(96),n2h16(96))
  call Hloop_VQ_A(ntryL,G1H32(97),ex1(:),G1H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(97),n2h16(97))
  call Hloop_ZQ_A(ntryL,G1H32(98),ex1(:),G1H16(1),ngZl,m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(98),n2h16(98))
  call Hloop_VQ_A(ntryL,G1H32(99),ex1(:),G1H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(99),n2h16(99))
  call Hloop_VQ_A(ntryL,G1H32(100),ex1(:),G1H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(100),n2h16(100))
  call Hloop_VQ_A(ntryL,G1H32(101),ex1(:),G1H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(101),n2h16(101))
  call Hloop_ZQ_A(ntryL,G1H32(102),ex1(:),G1H16(1),ngZl,m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(102),n2h16(102))
  call Hloop_VQ_A(ntryL,G1H32(103),ex1(:),G1H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(103),n2h16(103))
  call Hloop_ZQ_A(ntryL,G1H32(104),ex1(:),G1H16(1),ngZl,m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(104),n2h16(104))
  call Hloop_VQ_A(ntryL,G1H32(105),ex1(:),G1H16(1),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(105),n2h16(105))
  call Hloop_VQ_A(ntryL,G1H32(106),ex1(:),G1H16(1),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(106),n2h16(106))
  call Hloop_VQ_A(ntryL,G1H32(107),ex1(:),G1H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(107),n2h16(107))
  call Hloop_ZQ_A(ntryL,G1H32(108),ex1(:),G1H16(1),ngZl,m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(108),n2h16(108))
  call Hloop_VQ_A(ntryL,G1H32(109),ex1(:),G1H16(1),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(109),n2h16(109))
  call Hloop_ZQ_A(ntryL,G1H32(110),ex1(:),G1H16(1),ngZl,m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(110),n2h16(110))
  call Hloop_ZQ_A(ntryL,G1H32(111),ex1(:),G1H16(1),ngZl,m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(111),n2h16(111))
  call Hloop_SQ_A(ntryL,G1H32(112),ex1(:),G1H16(1),ngH,m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(112),n2h16(112))
  call Hloop_SQ_A(ntryL,G1H32(113),ex1(:),G1H16(1),ngH,m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(113),n2h16(113))
  call Hloop_SQ_A(ntryL,G1H32(114),ex1(:),G1H16(1),ngX,m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(114),n2h16(114))
  call Hloop_SQ_A(ntryL,G1H32(115),ex1(:),G1H16(1),ngX,m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(115),n2h16(115))
  call Hloop_SQ_A(ntryL,G1H32(116),ex1(:),G1H16(1),ngH,m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(116),n2h16(116))
  call Hloop_SQ_A(ntryL,G1H32(117),ex1(:),G1H16(1),ngH,m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(117),n2h16(117))
  call Hloop_SQ_A(ntryL,G1H32(118),ex1(:),G1H16(1),ngX,m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(118),n2h16(118))
  call Hloop_SQ_A(ntryL,G1H32(119),ex1(:),G1H16(1),ngX,m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(119),n2h16(119))
  call Hloop_VQ_A(ntryL,G1H32(120),ex1(:),G1H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(120),n2h16(120))
  call Hloop_VQ_A(ntryL,G1H32(121),ex1(:),G1H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(121),n2h16(121))
  call Hloop_VQ_A(ntryL,G1H32(122),ex1(:),G1H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(122),n2h16(122))
  call Hloop_VQ_A(ntryL,G1H32(123),ex1(:),G1H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(123),n2h16(123))
  call Hloop_SQ_A(ntryL,G1H32(124),ex1(:),G1H16(1),ngH,m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(124),n2h16(124))
  call Hloop_SQ_A(ntryL,G1H32(125),ex1(:),G1H16(1),ngX,m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(125),n2h16(125))
  call Hloop_SQ_A(ntryL,G1H32(126),ex1(:),G1H16(1),ngH,m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(126),n2h16(126))
  call Hloop_SQ_A(ntryL,G1H32(127),ex1(:),G1H16(1),ngH,m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(127),n2h16(127))
  call Hloop_SQ_A(ntryL,G1H32(128),ex1(:),G1H16(1),ngX,m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(128),n2h16(128))
  call Hloop_SQ_A(ntryL,G1H32(129),ex1(:),G1H16(1),ngX,m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(129),n2h16(129))
  call Hloop_VQ_A(ntryL,G1H32(130),ex1(:),G1H16(1),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(130),n2h16(130))
  call Hloop_VQ_A(ntryL,G1H32(131),ex1(:),G1H16(1),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(131),n2h16(131))
  call Hloop_VQ_A(ntryL,G1H32(132),ex1(:),G1H16(1),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(132),n2h16(132))
  call Hloop_ZQ_A(ntryL,G1H32(133),ex1(:),G1H16(1),ngZl,m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(133),n2h16(133))
  call Hloop_VQ_A(ntryL,G1H32(134),ex1(:),G1H16(1),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(134),n2h16(134))
  call Hloop_ZQ_A(ntryL,G1H32(135),ex1(:),G1H16(1),ngZl,m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(135),n2h16(135))
  call Hloop_VQ_A(ntryL,G1H32(136),ex1(:),G1H16(1),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(136),n2h16(136))
  call Hloop_VQ_A(ntryL,G1H32(137),ex1(:),G1H16(1),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(137),n2h16(137))
  call Hloop_VQ_A(ntryL,G1H32(138),ex1(:),G1H16(1),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(138),n2h16(138))
  call Hloop_ZQ_A(ntryL,G1H32(139),ex1(:),G1H16(1),ngZl,m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(139),n2h16(139))
  call Hloop_VQ_A(ntryL,G1H32(140),ex1(:),G1H16(1),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(140),n2h16(140))
  call Hloop_ZQ_A(ntryL,G1H32(141),ex1(:),G1H16(1),ngZl,m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(141),n2h16(141))
  call Hloop_VQ_A(ntryL,G1H32(142),ex1(:),G1H16(1),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(142),n2h16(142))
  call Hloop_VQ_A(ntryL,G1H32(143),ex1(:),G1H16(1),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(143),n2h16(143))
  call Hloop_VQ_A(ntryL,G1H32(144),ex1(:),G1H16(1),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(144),n2h16(144))
  call Hloop_ZQ_A(ntryL,G1H32(145),ex1(:),G1H16(1),ngZl,m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(145),n2h16(145))
  call Hloop_VQ_A(ntryL,G1H32(146),ex1(:),G1H16(1),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(146),n2h16(146))
  call Hloop_ZQ_A(ntryL,G1H32(147),ex1(:),G1H16(1),ngZl,m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(147),n2h16(147))
  call Hloop_ZQ_A(ntryL,G1H32(148),ex1(:),G1H16(1),ngZl,m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(148),n2h16(148))
  call Hloop_SA_Q(ntryL,G1H32(149),ex3(:),G1H16(1),ngH,m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(149),n2h16(149))
  call Hloop_SA_Q(ntryL,G1H32(150),ex3(:),G1H16(1),ngX,m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(150),n2h16(150))
  call Hloop_SA_Q(ntryL,G1H32(151),ex3(:),G1H16(1),ngH,m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(151),n2h16(151))
  call Hloop_SA_Q(ntryL,G1H32(152),ex3(:),G1H16(1),ngX,m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(152),n2h16(152))
  call Hloop_VA_Q(ntryL,G1H32(153),ex3(:),G1H16(1),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(153),n2h16(153))
  call Hloop_VA_Q(ntryL,G1H32(154),ex3(:),G1H16(1),m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(154),n2h16(154))
  call Hloop_VA_Q(ntryL,G1H32(155),ex3(:),G1H16(1),m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(155),n2h16(155))
  call Hloop_VA_Q(ntryL,G1H32(156),ex3(:),G1H16(1),m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(156),n2h16(156))
  call Hloop_SA_Q(ntryL,G1H32(157),ex3(:),G1H16(1),ngH,m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(157),n2h16(157))
  call Hloop_SA_Q(ntryL,G1H32(158),ex3(:),G1H16(1),ngH,m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(158),n2h16(158))
  call Hloop_SA_Q(ntryL,G1H32(159),ex3(:),G1H16(1),ngX,m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(159),n2h16(159))
  call Hloop_SA_Q(ntryL,G1H32(160),ex3(:),G1H16(1),ngX,m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(160),n2h16(160))
  call Hloop_VA_Q(ntryL,G1H32(161),ex3(:),G1H16(1),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(161),n2h16(161))
  call Hloop_VA_Q(ntryL,G1H32(162),ex3(:),G1H16(1),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(162),n2h16(162))
  call Hloop_VA_Q(ntryL,G1H32(163),ex3(:),G1H16(1),m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(163),n2h16(163))
  call Hloop_ZA_Q(ntryL,G1H32(164),ex3(:),G1H16(1),ngZl,m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(164),n2h16(164))
  call Hloop_VA_Q(ntryL,G1H32(165),ex3(:),G1H16(1),m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(165),n2h16(165))
  call Hloop_ZA_Q(ntryL,G1H32(166),ex3(:),G1H16(1),ngZl,m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(166),n2h16(166))
  call Hloop_SA_Q(ntryL,G1H32(167),ex3(:),G1H16(1),ngH,m3h2x16(:,167),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(167),n2h16(167))
  call Hloop_SA_Q(ntryL,G1H32(168),ex3(:),G1H16(1),ngX,m3h2x16(:,168),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(168),n2h16(168))
  call Hloop_SA_Q(ntryL,G1H32(169),ex3(:),G1H16(1),ngH,m3h2x16(:,169),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(169),n2h16(169))
  call Hloop_SA_Q(ntryL,G1H32(170),ex3(:),G1H16(1),ngH,m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(170),n2h16(170))
  call Hloop_SA_Q(ntryL,G1H32(171),ex3(:),G1H16(1),ngX,m3h2x16(:,171),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(171),n2h16(171))
  call Hloop_SA_Q(ntryL,G1H32(172),ex3(:),G1H16(1),ngX,m3h2x16(:,172),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(172),n2h16(172))
  call Hloop_VA_Q(ntryL,G1H32(173),ex3(:),G1H16(1),m3h2x16(:,173),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(173),n2h16(173))
  call Hloop_VA_Q(ntryL,G1H32(174),ex3(:),G1H16(1),m3h2x16(:,174),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(174),n2h16(174))
  call Hloop_ZA_Q(ntryL,G1H32(175),ex3(:),G1H16(1),ngZl,m3h2x16(:,175),heltab2x32(:,:,175))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(175),n2h16(175))
  call Hloop_VA_Q(ntryL,G1H32(176),ex3(:),G1H16(1),m3h2x16(:,176),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(176),n2h16(176))
  call Hloop_ZA_Q(ntryL,G1H32(177),ex3(:),G1H16(1),ngZl,m3h2x16(:,177),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(177),n2h16(177))
  call Hloop_VA_Q(ntryL,G1H32(178),ex3(:),G1H16(1),m3h2x16(:,178),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(178),n2h16(178))
  call Hloop_VA_Q(ntryL,G1H32(179),ex3(:),G1H16(1),m3h2x16(:,179),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(179),n2h16(179))
  call Hloop_VA_Q(ntryL,G1H32(180),ex3(:),G1H16(1),m3h2x16(:,180),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(180),n2h16(180))
  call Hloop_ZA_Q(ntryL,G1H32(181),ex3(:),G1H16(1),ngZl,m3h2x16(:,181),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(181),n2h16(181))
  call Hloop_VA_Q(ntryL,G1H32(182),ex3(:),G1H16(1),m3h2x16(:,182),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(182),n2h16(182))
  call Hloop_ZA_Q(ntryL,G1H32(183),ex3(:),G1H16(1),ngZl,m3h2x16(:,183),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(183),n2h16(183))
  call Hloop_VA_Q(ntryL,G1H32(184),ex3(:),G1H16(1),m3h2x16(:,184),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(184),n2h16(184))
  call Hloop_ZA_Q(ntryL,G1H32(185),ex3(:),G1H16(1),ngZl,m3h2x16(:,185),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(185),n2h16(185))
  call Hloop_VA_Q(ntryL,G1H32(186),ex4(:),G1H16(1),m3h2x16(:,186),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(186),n2h16(186))
  call Hloop_VA_Q(ntryL,G1H32(187),ex4(:),G1H16(1),m3h2x16(:,187),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(187),n2h16(187))
  call Hloop_VA_Q(ntryL,G1H32(188),ex4(:),G1H16(1),m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(188),n2h16(188))
  call Hloop_VA_Q(ntryL,G1H32(189),ex4(:),G1H16(1),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(189),n2h16(189))
  call Hloop_SA_Q(ntryL,G1H32(190),ex4(:),G1H16(1),ngH,m3h2x16(:,190),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(190),n2h16(190))
  call Hloop_SA_Q(ntryL,G1H32(191),ex4(:),G1H16(1),ngX,m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(191),n2h16(191))
  call Hloop_SA_Q(ntryL,G1H32(192),ex4(:),G1H16(1),ngH,m3h2x16(:,192),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(192),n2h16(192))
  call Hloop_SA_Q(ntryL,G1H32(193),ex4(:),G1H16(1),ngX,m3h2x16(:,193),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(193),n2h16(193))
  call Hloop_SA_Q(ntryL,G1H32(194),ex4(:),G1H16(1),ngH,m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(194),n2h16(194))
  call Hloop_SA_Q(ntryL,G1H32(195),ex4(:),G1H16(1),ngX,m3h2x16(:,195),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(195),n2h16(195))
  call Hloop_SA_Q(ntryL,G1H32(196),ex4(:),G1H16(1),ngH,m3h2x16(:,196),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(196),n2h16(196))
  call Hloop_SA_Q(ntryL,G1H32(197),ex4(:),G1H16(1),ngX,m3h2x16(:,197),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(197),n2h16(197))
  call Hloop_VA_Q(ntryL,G1H32(198),ex4(:),G1H16(1),m3h2x16(:,198),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(198),n2h16(198))
  call Hloop_VA_Q(ntryL,G1H32(199),ex4(:),G1H16(1),m3h2x16(:,199),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(199),n2h16(199))
  call Hloop_ZA_Q(ntryL,G1H32(200),ex4(:),G1H16(1),ngZl,m3h2x16(:,200),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(200),n2h16(200))
  call Hloop_VA_Q(ntryL,G1H32(201),ex4(:),G1H16(1),m3h2x16(:,201),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(201),n2h16(201))
  call Hloop_ZA_Q(ntryL,G1H32(202),ex4(:),G1H16(1),ngZl,m3h2x16(:,202),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(202),n2h16(202))
  call Hloop_VA_Q(ntryL,G1H32(203),ex4(:),G1H16(1),m3h2x16(:,203),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(203),n2h16(203))
  call Hloop_VA_Q(ntryL,G1H32(204),ex4(:),G1H16(1),m3h2x16(:,204),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(204),n2h16(204))
  call Hloop_VA_Q(ntryL,G1H32(205),ex4(:),G1H16(1),m3h2x16(:,205),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(205),n2h16(205))
  call Hloop_ZA_Q(ntryL,G1H32(206),ex4(:),G1H16(1),ngZl,m3h2x16(:,206),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(206),n2h16(206))
  call Hloop_VA_Q(ntryL,G1H32(207),ex4(:),G1H16(1),m3h2x16(:,207),heltab2x32(:,:,207))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(207),n2h16(207))
  call Hloop_ZA_Q(ntryL,G1H32(208),ex4(:),G1H16(1),ngZl,m3h2x16(:,208),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(208),n2h16(208))
  call Hloop_VA_Q(ntryL,G1H32(209),ex4(:),G1H16(1),m3h2x16(:,209),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(209),n2h16(209))
  call Hloop_SA_Q(ntryL,G1H32(210),ex4(:),G1H16(1),ngH,m3h2x16(:,210),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(210),n2h16(210))
  call Hloop_SA_Q(ntryL,G1H32(211),ex4(:),G1H16(1),ngX,m3h2x16(:,211),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(211),n2h16(211))
  call Hloop_SA_Q(ntryL,G1H32(212),ex4(:),G1H16(1),ngH,m3h2x16(:,212),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(212),n2h16(212))
  call Hloop_SA_Q(ntryL,G1H32(213),ex4(:),G1H16(1),ngH,m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(213),n2h16(213))
  call Hloop_SA_Q(ntryL,G1H32(214),ex4(:),G1H16(1),ngX,m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(214),n2h16(214))
  call Hloop_SA_Q(ntryL,G1H32(215),ex4(:),G1H16(1),ngX,m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(215),n2h16(215))
  call Hloop_VA_Q(ntryL,G1H32(216),ex4(:),G1H16(1),m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(216),n2h16(216))
  call Hloop_ZA_Q(ntryL,G1H32(217),ex4(:),G1H16(1),ngZl,m3h2x16(:,217),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(217),n2h16(217))
  call Hloop_VA_Q(ntryL,G1H32(218),ex4(:),G1H16(1),m3h2x16(:,218),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(218),n2h16(218))
  call Hloop_VA_Q(ntryL,G1H32(219),ex4(:),G1H16(1),m3h2x16(:,219),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(219),n2h16(219))
  call Hloop_ZA_Q(ntryL,G1H32(220),ex4(:),G1H16(1),ngZl,m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(220),n2h16(220))
  call Hloop_ZA_Q(ntryL,G1H32(221),ex4(:),G1H16(1),ngZl,m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(221),n2h16(221))
  call Hloop_VA_Q(ntryL,G1H32(222),ex4(:),G1H16(1),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(222),n2h16(222))
  call Hloop_SQ_A(ntryL,G1H32(223),ex1(:),G1H16(1),ngH,m3h2x16(:,223),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(223),n2h16(223))
  call Hloop_SQ_A(ntryL,G1H32(224),ex1(:),G1H16(1),ngH,m3h2x16(:,224),heltab2x32(:,:,224))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(224),n2h16(224))
  call Hloop_SQ_A(ntryL,G1H32(225),ex1(:),G1H16(1),ngX,m3h2x16(:,225),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(225),n2h16(225))
  call Hloop_SQ_A(ntryL,G1H32(226),ex1(:),G1H16(1),ngX,m3h2x16(:,226),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(226),n2h16(226))
  call Hloop_SQ_A(ntryL,G1H32(227),ex1(:),G1H16(1),ngH,m3h2x16(:,227),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(227),n2h16(227))
  call Hloop_SQ_A(ntryL,G1H32(228),ex1(:),G1H16(1),ngH,m3h2x16(:,228),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(228),n2h16(228))
  call Hloop_SQ_A(ntryL,G1H32(229),ex1(:),G1H16(1),ngX,m3h2x16(:,229),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(229),n2h16(229))
  call Hloop_SQ_A(ntryL,G1H32(230),ex1(:),G1H16(1),ngX,m3h2x16(:,230),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(230),n2h16(230))
  call Hloop_VQ_A(ntryL,G1H32(231),ex1(:),G1H16(1),m3h2x16(:,231),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(231),n2h16(231))
  call Hloop_VQ_A(ntryL,G1H32(232),ex1(:),G1H16(1),m3h2x16(:,232),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(232),n2h16(232))
  call Hloop_VQ_A(ntryL,G1H32(233),ex1(:),G1H16(1),m3h2x16(:,233),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(233),n2h16(233))
  call Hloop_VQ_A(ntryL,G1H32(234),ex1(:),G1H16(1),m3h2x16(:,234),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(234),n2h16(234))
  call Hloop_SQ_A(ntryL,G1H32(235),ex1(:),G1H16(1),ngH,m3h2x16(:,235),heltab2x32(:,:,235))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(235),n2h16(235))
  call Hloop_SQ_A(ntryL,G1H32(236),ex1(:),G1H16(1),ngX,m3h2x16(:,236),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(236),n2h16(236))
  call Hloop_SQ_A(ntryL,G1H32(237),ex1(:),G1H16(1),ngH,m3h2x16(:,237),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(237),n2h16(237))
  call Hloop_SQ_A(ntryL,G1H32(238),ex1(:),G1H16(1),ngH,m3h2x16(:,238),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(238),n2h16(238))
  call Hloop_SQ_A(ntryL,G1H32(239),ex1(:),G1H16(1),ngX,m3h2x16(:,239),heltab2x32(:,:,239))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(239),n2h16(239))
  call Hloop_SQ_A(ntryL,G1H32(240),ex1(:),G1H16(1),ngX,m3h2x16(:,240),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(240),n2h16(240))
  call Hloop_VQ_A(ntryL,G1H32(241),ex1(:),G1H16(1),m3h2x16(:,241),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(241),n2h16(241))
  call Hloop_VQ_A(ntryL,G1H32(242),ex1(:),G1H16(1),m3h2x16(:,242),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(242),n2h16(242))
  call Hloop_VQ_A(ntryL,G1H32(243),ex1(:),G1H16(1),m3h2x16(:,243),heltab2x32(:,:,243))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(243),n2h16(243))
  call Hloop_ZQ_A(ntryL,G1H32(244),ex1(:),G1H16(1),ngZl,m3h2x16(:,244),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(244),n2h16(244))
  call Hloop_VQ_A(ntryL,G1H32(245),ex1(:),G1H16(1),m3h2x16(:,245),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(245),n2h16(245))
  call Hloop_ZQ_A(ntryL,G1H32(246),ex1(:),G1H16(1),ngZl,m3h2x16(:,246),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(246),n2h16(246))
  call Hloop_VQ_A(ntryL,G1H32(247),ex1(:),G1H16(1),m3h2x16(:,247),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(247),n2h16(247))
  call Hloop_VQ_A(ntryL,G1H32(248),ex1(:),G1H16(1),m3h2x16(:,248),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(248),n2h16(248))
  call Hloop_VQ_A(ntryL,G1H32(249),ex1(:),G1H16(1),m3h2x16(:,249),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(249),n2h16(249))
  call Hloop_ZQ_A(ntryL,G1H32(250),ex1(:),G1H16(1),ngZl,m3h2x16(:,250),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(250),n2h16(250))
  call Hloop_VQ_A(ntryL,G1H32(251),ex1(:),G1H16(1),m3h2x16(:,251),heltab2x32(:,:,251))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(251),n2h16(251))
  call Hloop_ZQ_A(ntryL,G1H32(252),ex1(:),G1H16(1),ngZl,m3h2x16(:,252),heltab2x32(:,:,252))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(252),n2h16(252))
  call Hloop_VQ_A(ntryL,G1H32(253),ex1(:),G1H16(1),m3h2x16(:,253),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(253),n2h16(253))
  call Hloop_VQ_A(ntryL,G1H32(254),ex1(:),G1H16(1),m3h2x16(:,254),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(254),n2h16(254))
  call Hloop_VQ_A(ntryL,G1H32(255),ex1(:),G1H16(1),m3h2x16(:,255),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(255),n2h16(255))
  call Hloop_ZQ_A(ntryL,G1H32(256),ex1(:),G1H16(1),ngZl,m3h2x16(:,256),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(256),n2h16(256))
  call Hloop_VQ_A(ntryL,G1H32(257),ex1(:),G1H16(1),m3h2x16(:,257),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(257),n2h16(257))
  call Hloop_ZQ_A(ntryL,G1H32(258),ex1(:),G1H16(1),ngZl,m3h2x16(:,258),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(258),n2h16(258))
  call Hloop_ZQ_A(ntryL,G1H32(259),ex1(:),G1H16(1),ngZl,m3h2x16(:,259),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(259),n2h16(259))
  call Hloop_SQ_A(ntryL,G1H32(260),ex1(:),G1H16(1),ngH,m3h2x16(:,260),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(260),n2h16(260))
  call Hloop_SQ_A(ntryL,G1H32(261),ex1(:),G1H16(1),ngH,m3h2x16(:,261),heltab2x32(:,:,261))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(261),n2h16(261))
  call Hloop_SQ_A(ntryL,G1H32(262),ex1(:),G1H16(1),ngX,m3h2x16(:,262),heltab2x32(:,:,262))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(262),n2h16(262))
  call Hloop_SQ_A(ntryL,G1H32(263),ex1(:),G1H16(1),ngX,m3h2x16(:,263),heltab2x32(:,:,263))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(263),n2h16(263))
  call Hloop_SQ_A(ntryL,G1H32(264),ex1(:),G1H16(1),ngH,m3h2x16(:,264),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(264),n2h16(264))
  call Hloop_SQ_A(ntryL,G1H32(265),ex1(:),G1H16(1),ngH,m3h2x16(:,265),heltab2x32(:,:,265))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(265),n2h16(265))
  call Hloop_SQ_A(ntryL,G1H32(266),ex1(:),G1H16(1),ngX,m3h2x16(:,266),heltab2x32(:,:,266))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(266),n2h16(266))
  call Hloop_SQ_A(ntryL,G1H32(267),ex1(:),G1H16(1),ngX,m3h2x16(:,267),heltab2x32(:,:,267))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(267),n2h16(267))
  call Hloop_VQ_A(ntryL,G1H32(268),ex1(:),G1H16(1),m3h2x16(:,268),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(268),n2h16(268))
  call Hloop_VQ_A(ntryL,G1H32(269),ex1(:),G1H16(1),m3h2x16(:,269),heltab2x32(:,:,269))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(269),n2h16(269))
  call Hloop_VQ_A(ntryL,G1H32(270),ex1(:),G1H16(1),m3h2x16(:,270),heltab2x32(:,:,270))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(270),n2h16(270))
  call Hloop_VQ_A(ntryL,G1H32(271),ex1(:),G1H16(1),m3h2x16(:,271),heltab2x32(:,:,271))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(271),n2h16(271))
  call Hloop_SQ_A(ntryL,G1H32(272),ex1(:),G1H16(1),ngH,m3h2x16(:,272),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(272),n2h16(272))
  call Hloop_SQ_A(ntryL,G1H32(273),ex1(:),G1H16(1),ngX,m3h2x16(:,273),heltab2x32(:,:,273))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(273),n2h16(273))
  call Hloop_SQ_A(ntryL,G1H32(274),ex1(:),G1H16(1),ngH,m3h2x16(:,274),heltab2x32(:,:,274))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(274),n2h16(274))
  call Hloop_SQ_A(ntryL,G1H32(275),ex1(:),G1H16(1),ngH,m3h2x16(:,275),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(275),n2h16(275))
  call Hloop_SQ_A(ntryL,G1H32(276),ex1(:),G1H16(1),ngX,m3h2x16(:,276),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(276),n2h16(276))
  call Hloop_SQ_A(ntryL,G1H32(277),ex1(:),G1H16(1),ngX,m3h2x16(:,277),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(277),n2h16(277))
  call Hloop_VQ_A(ntryL,G1H32(278),ex1(:),G1H16(1),m3h2x16(:,278),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(278),n2h16(278))
  call Hloop_VQ_A(ntryL,G1H32(279),ex1(:),G1H16(1),m3h2x16(:,279),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(279),n2h16(279))
  call Hloop_VQ_A(ntryL,G1H32(280),ex1(:),G1H16(1),m3h2x16(:,280),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(280),n2h16(280))
  call Hloop_ZQ_A(ntryL,G1H32(281),ex1(:),G1H16(1),ngZl,m3h2x16(:,281),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(281),n2h16(281))
  call Hloop_VQ_A(ntryL,G1H32(282),ex1(:),G1H16(1),m3h2x16(:,282),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(282),n2h16(282))
  call Hloop_ZQ_A(ntryL,G1H32(283),ex1(:),G1H16(1),ngZl,m3h2x16(:,283),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(283),n2h16(283))
  call Hloop_VQ_A(ntryL,G1H32(284),ex1(:),G1H16(1),m3h2x16(:,284),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(284),n2h16(284))
  call Hloop_VQ_A(ntryL,G1H32(285),ex1(:),G1H16(1),m3h2x16(:,285),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(285),n2h16(285))
  call Hloop_VQ_A(ntryL,G1H32(286),ex1(:),G1H16(1),m3h2x16(:,286),heltab2x32(:,:,286))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(286),n2h16(286))
  call Hloop_ZQ_A(ntryL,G1H32(287),ex1(:),G1H16(1),ngZl,m3h2x16(:,287),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(287),n2h16(287))
  call Hloop_VQ_A(ntryL,G1H32(288),ex1(:),G1H16(1),m3h2x16(:,288),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(288),n2h16(288))
  call Hloop_ZQ_A(ntryL,G1H32(289),ex1(:),G1H16(1),ngZl,m3h2x16(:,289),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(289),n2h16(289))
  call Hloop_VQ_A(ntryL,G1H32(290),ex1(:),G1H16(1),m3h2x16(:,290),heltab2x32(:,:,290))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(290),n2h16(290))
  call Hloop_VQ_A(ntryL,G1H32(291),ex1(:),G1H16(1),m3h2x16(:,291),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(291),n2h16(291))
  call Hloop_VQ_A(ntryL,G1H32(292),ex1(:),G1H16(1),m3h2x16(:,292),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(292),n2h16(292))
  call Hloop_ZQ_A(ntryL,G1H32(293),ex1(:),G1H16(1),ngZl,m3h2x16(:,293),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(293),n2h16(293))
  call Hloop_VQ_A(ntryL,G1H32(294),ex1(:),G1H16(1),m3h2x16(:,294),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(294),n2h16(294))
  call Hloop_ZQ_A(ntryL,G1H32(295),ex1(:),G1H16(1),ngZl,m3h2x16(:,295),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(295),n2h16(295))
  call Hloop_ZQ_A(ntryL,G1H32(296),ex1(:),G1H16(1),ngZl,m3h2x16(:,296),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(296),n2h16(296))
  call Hloop_SQ_A(ntryL,G1H32(297),ex2(:),G1H16(1),ngH,m3h2x16(:,297),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(297),n2h16(297))
  call Hloop_SQ_A(ntryL,G1H32(298),ex2(:),G1H16(1),ngH,m3h2x16(:,298),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(298),n2h16(298))
  call Hloop_SQ_A(ntryL,G1H32(299),ex2(:),G1H16(1),ngX,m3h2x16(:,299),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(299),n2h16(299))
  call Hloop_SQ_A(ntryL,G1H32(300),ex2(:),G1H16(1),ngX,m3h2x16(:,300),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(300),n2h16(300))
  call Hloop_SQ_A(ntryL,G1H32(301),ex2(:),G1H16(1),ngH,m3h2x16(:,301),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(301),n2h16(301))
  call Hloop_SQ_A(ntryL,G1H32(302),ex2(:),G1H16(1),ngH,m3h2x16(:,302),heltab2x32(:,:,302))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(302),n2h16(302))
  call Hloop_SQ_A(ntryL,G1H32(303),ex2(:),G1H16(1),ngX,m3h2x16(:,303),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(303),n2h16(303))
  call Hloop_SQ_A(ntryL,G1H32(304),ex2(:),G1H16(1),ngX,m3h2x16(:,304),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(304),n2h16(304))
  call Hloop_VQ_A(ntryL,G1H32(305),ex2(:),G1H16(1),m3h2x16(:,305),heltab2x32(:,:,305))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(305),n2h16(305))
  call Hloop_VQ_A(ntryL,G1H32(306),ex2(:),G1H16(1),m3h2x16(:,306),heltab2x32(:,:,306))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(306),n2h16(306))
  call Hloop_VQ_A(ntryL,G1H32(307),ex2(:),G1H16(1),m3h2x16(:,307),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(307),n2h16(307))
  call Hloop_VQ_A(ntryL,G1H32(308),ex2(:),G1H16(1),m3h2x16(:,308),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(308),n2h16(308))
  call Hloop_SQ_A(ntryL,G1H32(309),ex2(:),G1H16(1),ngH,m3h2x16(:,309),heltab2x32(:,:,309))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(309),n2h16(309))
  call Hloop_SQ_A(ntryL,G1H32(310),ex2(:),G1H16(1),ngX,m3h2x16(:,310),heltab2x32(:,:,310))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(310),n2h16(310))
  call Hloop_SQ_A(ntryL,G1H32(311),ex2(:),G1H16(1),ngH,m3h2x16(:,311),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(311),n2h16(311))
  call Hloop_SQ_A(ntryL,G1H32(312),ex2(:),G1H16(1),ngH,m3h2x16(:,312),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(312),n2h16(312))
  call Hloop_SQ_A(ntryL,G1H32(313),ex2(:),G1H16(1),ngX,m3h2x16(:,313),heltab2x32(:,:,313))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(313),n2h16(313))
  call Hloop_SQ_A(ntryL,G1H32(314),ex2(:),G1H16(1),ngX,m3h2x16(:,314),heltab2x32(:,:,314))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(314),n2h16(314))
  call Hloop_VQ_A(ntryL,G1H32(315),ex2(:),G1H16(1),m3h2x16(:,315),heltab2x32(:,:,315))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(315),n2h16(315))
  call Hloop_VQ_A(ntryL,G1H32(316),ex2(:),G1H16(1),m3h2x16(:,316),heltab2x32(:,:,316))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(316),n2h16(316))
  call Hloop_VQ_A(ntryL,G1H32(317),ex2(:),G1H16(1),m3h2x16(:,317),heltab2x32(:,:,317))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(317),n2h16(317))
  call Hloop_ZQ_A(ntryL,G1H32(318),ex2(:),G1H16(1),ngZl,m3h2x16(:,318),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(318),n2h16(318))
  call Hloop_VQ_A(ntryL,G1H32(319),ex2(:),G1H16(1),m3h2x16(:,319),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(319),n2h16(319))
  call Hloop_ZQ_A(ntryL,G1H32(320),ex2(:),G1H16(1),ngZl,m3h2x16(:,320),heltab2x32(:,:,320))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(320),n2h16(320))
  call Hloop_VQ_A(ntryL,G1H32(321),ex2(:),G1H16(1),m3h2x16(:,321),heltab2x32(:,:,321))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(321),n2h16(321))
  call Hloop_VQ_A(ntryL,G1H32(322),ex2(:),G1H16(1),m3h2x16(:,322),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(322),n2h16(322))
  call Hloop_VQ_A(ntryL,G1H32(323),ex2(:),G1H16(1),m3h2x16(:,323),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(323),n2h16(323))
  call Hloop_ZQ_A(ntryL,G1H32(324),ex2(:),G1H16(1),ngZl,m3h2x16(:,324),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(324),n2h16(324))
  call Hloop_VQ_A(ntryL,G1H32(325),ex2(:),G1H16(1),m3h2x16(:,325),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(325),n2h16(325))
  call Hloop_ZQ_A(ntryL,G1H32(326),ex2(:),G1H16(1),ngZl,m3h2x16(:,326),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(326),n2h16(326))
  call Hloop_VQ_A(ntryL,G1H32(327),ex2(:),G1H16(1),m3h2x16(:,327),heltab2x32(:,:,327))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(327),n2h16(327))
  call Hloop_VQ_A(ntryL,G1H32(328),ex2(:),G1H16(1),m3h2x16(:,328),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(328),n2h16(328))
  call Hloop_VQ_A(ntryL,G1H32(329),ex2(:),G1H16(1),m3h2x16(:,329),heltab2x32(:,:,329))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(329),n2h16(329))
  call Hloop_ZQ_A(ntryL,G1H32(330),ex2(:),G1H16(1),ngZl,m3h2x16(:,330),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(330),n2h16(330))
  call Hloop_VQ_A(ntryL,G1H32(331),ex2(:),G1H16(1),m3h2x16(:,331),heltab2x32(:,:,331))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(331),n2h16(331))
  call Hloop_ZQ_A(ntryL,G1H32(332),ex2(:),G1H16(1),ngZl,m3h2x16(:,332),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(332),n2h16(332))
  call Hloop_ZQ_A(ntryL,G1H32(333),ex2(:),G1H16(1),ngZl,m3h2x16(:,333),heltab2x32(:,:,333))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(333),n2h16(333))
  call Hloop_SQ_A(ntryL,G1H32(334),ex2(:),G1H16(1),ngH,m3h2x16(:,334),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(334),n2h16(334))
  call Hloop_SQ_A(ntryL,G1H32(335),ex2(:),G1H16(1),ngH,m3h2x16(:,335),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(335),n2h16(335))
  call Hloop_SQ_A(ntryL,G1H32(336),ex2(:),G1H16(1),ngX,m3h2x16(:,336),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(336),n2h16(336))
  call Hloop_SQ_A(ntryL,G1H32(337),ex2(:),G1H16(1),ngX,m3h2x16(:,337),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(337),n2h16(337))
  call Hloop_SQ_A(ntryL,G1H32(338),ex2(:),G1H16(1),ngH,m3h2x16(:,338),heltab2x32(:,:,338))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(338),n2h16(338))
  call Hloop_SQ_A(ntryL,G1H32(339),ex2(:),G1H16(1),ngH,m3h2x16(:,339),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(339),n2h16(339))
  call Hloop_SQ_A(ntryL,G1H32(340),ex2(:),G1H16(1),ngX,m3h2x16(:,340),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(340),n2h16(340))
  call Hloop_SQ_A(ntryL,G1H32(341),ex2(:),G1H16(1),ngX,m3h2x16(:,341),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(341),n2h16(341))
  call Hloop_VQ_A(ntryL,G1H32(342),ex2(:),G1H16(1),m3h2x16(:,342),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(342),n2h16(342))
  call Hloop_VQ_A(ntryL,G1H32(343),ex2(:),G1H16(1),m3h2x16(:,343),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(343),n2h16(343))
  call Hloop_VQ_A(ntryL,G1H32(344),ex2(:),G1H16(1),m3h2x16(:,344),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(344),n2h16(344))
  call Hloop_VQ_A(ntryL,G1H32(345),ex2(:),G1H16(1),m3h2x16(:,345),heltab2x32(:,:,345))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(345),n2h16(345))
  call Hloop_SQ_A(ntryL,G1H32(346),ex2(:),G1H16(1),ngH,m3h2x16(:,346),heltab2x32(:,:,346))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(346),n2h16(346))
  call Hloop_SQ_A(ntryL,G1H32(347),ex2(:),G1H16(1),ngX,m3h2x16(:,347),heltab2x32(:,:,347))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(347),n2h16(347))
  call Hloop_SQ_A(ntryL,G1H32(348),ex2(:),G1H16(1),ngH,m3h2x16(:,348),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(348),n2h16(348))
  call Hloop_SQ_A(ntryL,G1H32(349),ex2(:),G1H16(1),ngH,m3h2x16(:,349),heltab2x32(:,:,349))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(349),n2h16(349))
  call Hloop_SQ_A(ntryL,G1H32(350),ex2(:),G1H16(1),ngX,m3h2x16(:,350),heltab2x32(:,:,350))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(350),n2h16(350))
  call Hloop_SQ_A(ntryL,G1H32(351),ex2(:),G1H16(1),ngX,m3h2x16(:,351),heltab2x32(:,:,351))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(351),n2h16(351))
  call Hloop_VQ_A(ntryL,G1H32(352),ex2(:),G1H16(1),m3h2x16(:,352),heltab2x32(:,:,352))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(352),n2h16(352))
  call Hloop_VQ_A(ntryL,G1H32(353),ex2(:),G1H16(1),m3h2x16(:,353),heltab2x32(:,:,353))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(353),n2h16(353))
  call Hloop_VQ_A(ntryL,G1H32(354),ex2(:),G1H16(1),m3h2x16(:,354),heltab2x32(:,:,354))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(354),n2h16(354))
  call Hloop_ZQ_A(ntryL,G1H32(355),ex2(:),G1H16(1),ngZl,m3h2x16(:,355),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(355),n2h16(355))
  call Hloop_VQ_A(ntryL,G1H32(356),ex2(:),G1H16(1),m3h2x16(:,356),heltab2x32(:,:,356))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(356),n2h16(356))
  call Hloop_ZQ_A(ntryL,G1H32(357),ex2(:),G1H16(1),ngZl,m3h2x16(:,357),heltab2x32(:,:,357))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(357),n2h16(357))
  call Hloop_VQ_A(ntryL,G1H32(358),ex2(:),G1H16(1),m3h2x16(:,358),heltab2x32(:,:,358))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(358),n2h16(358))
  call Hloop_VQ_A(ntryL,G1H32(359),ex2(:),G1H16(1),m3h2x16(:,359),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(359),n2h16(359))
  call Hloop_VQ_A(ntryL,G1H32(360),ex2(:),G1H16(1),m3h2x16(:,360),heltab2x32(:,:,360))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(360),n2h16(360))
  call Hloop_ZQ_A(ntryL,G1H32(361),ex2(:),G1H16(1),ngZl,m3h2x16(:,361),heltab2x32(:,:,361))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(361),n2h16(361))
  call Hloop_VQ_A(ntryL,G1H32(362),ex2(:),G1H16(1),m3h2x16(:,362),heltab2x32(:,:,362))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(362),n2h16(362))
  call Hloop_ZQ_A(ntryL,G1H32(363),ex2(:),G1H16(1),ngZl,m3h2x16(:,363),heltab2x32(:,:,363))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(363),n2h16(363))
  call Hloop_VQ_A(ntryL,G1H32(364),ex2(:),G1H16(1),m3h2x16(:,364),heltab2x32(:,:,364))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(364),n2h16(364))
  call Hloop_VQ_A(ntryL,G1H32(365),ex2(:),G1H16(1),m3h2x16(:,365),heltab2x32(:,:,365))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(365),n2h16(365))
  call Hloop_VQ_A(ntryL,G1H32(366),ex2(:),G1H16(1),m3h2x16(:,366),heltab2x32(:,:,366))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(366),n2h16(366))
  call Hloop_ZQ_A(ntryL,G1H32(367),ex2(:),G1H16(1),ngZl,m3h2x16(:,367),heltab2x32(:,:,367))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(367),n2h16(367))
  call Hloop_VQ_A(ntryL,G1H32(368),ex2(:),G1H16(1),m3h2x16(:,368),heltab2x32(:,:,368))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(368),n2h16(368))
  call Hloop_ZQ_A(ntryL,G1H32(369),ex2(:),G1H16(1),ngZl,m3h2x16(:,369),heltab2x32(:,:,369))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(369),n2h16(369))
  call Hloop_ZQ_A(ntryL,G1H32(370),ex2(:),G1H16(1),ngZl,m3h2x16(:,370),heltab2x32(:,:,370))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(370),n2h16(370))
  call Hloop_SQ_A(ntryL,G1H32(371),ex2(:),G1H16(1),ngH,m3h2x16(:,371),heltab2x32(:,:,371))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(371),n2h16(371))
  call Hloop_SQ_A(ntryL,G1H32(372),ex2(:),G1H16(1),ngH,m3h2x16(:,372),heltab2x32(:,:,372))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(372),n2h16(372))
  call Hloop_SQ_A(ntryL,G1H32(373),ex2(:),G1H16(1),ngX,m3h2x16(:,373),heltab2x32(:,:,373))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(373),n2h16(373))
  call Hloop_SQ_A(ntryL,G1H32(374),ex2(:),G1H16(1),ngX,m3h2x16(:,374),heltab2x32(:,:,374))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(374),n2h16(374))
  call Hloop_SQ_A(ntryL,G1H32(375),ex2(:),G1H16(1),ngH,m3h2x16(:,375),heltab2x32(:,:,375))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(375),n2h16(375))
  call Hloop_SQ_A(ntryL,G1H32(376),ex2(:),G1H16(1),ngH,m3h2x16(:,376),heltab2x32(:,:,376))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(376),n2h16(376))
  call Hloop_SQ_A(ntryL,G1H32(377),ex2(:),G1H16(1),ngX,m3h2x16(:,377),heltab2x32(:,:,377))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(377),n2h16(377))
  call Hloop_SQ_A(ntryL,G1H32(378),ex2(:),G1H16(1),ngX,m3h2x16(:,378),heltab2x32(:,:,378))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(378),n2h16(378))
  call Hloop_VQ_A(ntryL,G1H32(379),ex2(:),G1H16(1),m3h2x16(:,379),heltab2x32(:,:,379))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(379),n2h16(379))
  call Hloop_VQ_A(ntryL,G1H32(380),ex2(:),G1H16(1),m3h2x16(:,380),heltab2x32(:,:,380))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(380),n2h16(380))
  call Hloop_VQ_A(ntryL,G1H32(381),ex2(:),G1H16(1),m3h2x16(:,381),heltab2x32(:,:,381))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(381),n2h16(381))
  call Hloop_VQ_A(ntryL,G1H32(382),ex2(:),G1H16(1),m3h2x16(:,382),heltab2x32(:,:,382))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(382),n2h16(382))
  call Hloop_SQ_A(ntryL,G1H32(383),ex2(:),G1H16(1),ngH,m3h2x16(:,383),heltab2x32(:,:,383))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(383),n2h16(383))
  call Hloop_SQ_A(ntryL,G1H32(384),ex2(:),G1H16(1),ngX,m3h2x16(:,384),heltab2x32(:,:,384))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(384),n2h16(384))
  call Hloop_SQ_A(ntryL,G1H32(385),ex2(:),G1H16(1),ngH,m3h2x16(:,385),heltab2x32(:,:,385))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(385),n2h16(385))
  call Hloop_SQ_A(ntryL,G1H32(386),ex2(:),G1H16(1),ngH,m3h2x16(:,386),heltab2x32(:,:,386))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(386),n2h16(386))
  call Hloop_SQ_A(ntryL,G1H32(387),ex2(:),G1H16(1),ngX,m3h2x16(:,387),heltab2x32(:,:,387))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(387),n2h16(387))
  call Hloop_SQ_A(ntryL,G1H32(388),ex2(:),G1H16(1),ngX,m3h2x16(:,388),heltab2x32(:,:,388))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(388),n2h16(388))
  call Hloop_VQ_A(ntryL,G1H32(389),ex2(:),G1H16(1),m3h2x16(:,389),heltab2x32(:,:,389))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(389),n2h16(389))
  call Hloop_VQ_A(ntryL,G1H32(390),ex2(:),G1H16(1),m3h2x16(:,390),heltab2x32(:,:,390))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(390),n2h16(390))
  call Hloop_VQ_A(ntryL,G1H32(391),ex2(:),G1H16(1),m3h2x16(:,391),heltab2x32(:,:,391))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(391),n2h16(391))
  call Hloop_ZQ_A(ntryL,G1H32(392),ex2(:),G1H16(1),ngZl,m3h2x16(:,392),heltab2x32(:,:,392))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(392),n2h16(392))
  call Hloop_VQ_A(ntryL,G1H32(393),ex2(:),G1H16(1),m3h2x16(:,393),heltab2x32(:,:,393))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(393),n2h16(393))
  call Hloop_ZQ_A(ntryL,G1H32(394),ex2(:),G1H16(1),ngZl,m3h2x16(:,394),heltab2x32(:,:,394))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(394),n2h16(394))
  call Hloop_VQ_A(ntryL,G1H32(395),ex2(:),G1H16(1),m3h2x16(:,395),heltab2x32(:,:,395))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(395),n2h16(395))
  call Hloop_VQ_A(ntryL,G1H32(396),ex2(:),G1H16(1),m3h2x16(:,396),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(396),n2h16(396))
  call Hloop_VQ_A(ntryL,G1H32(397),ex2(:),G1H16(1),m3h2x16(:,397),heltab2x32(:,:,397))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(397),n2h16(397))
  call Hloop_ZQ_A(ntryL,G1H32(398),ex2(:),G1H16(1),ngZl,m3h2x16(:,398),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(398),n2h16(398))
  call Hloop_VQ_A(ntryL,G1H32(399),ex2(:),G1H16(1),m3h2x16(:,399),heltab2x32(:,:,399))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(399),n2h16(399))
  call Hloop_ZQ_A(ntryL,G1H32(400),ex2(:),G1H16(1),ngZl,m3h2x16(:,400),heltab2x32(:,:,400))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(400),n2h16(400))
  call Hloop_VQ_A(ntryL,G1H32(401),ex2(:),G1H16(1),m3h2x16(:,401),heltab2x32(:,:,401))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(401),n2h16(401))
  call Hloop_VQ_A(ntryL,G1H32(402),ex2(:),G1H16(1),m3h2x16(:,402),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(402),n2h16(402))
  call Hloop_VQ_A(ntryL,G1H32(403),ex2(:),G1H16(1),m3h2x16(:,403),heltab2x32(:,:,403))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(403),n2h16(403))
  call Hloop_ZQ_A(ntryL,G1H32(404),ex2(:),G1H16(1),ngZl,m3h2x16(:,404),heltab2x32(:,:,404))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(404),n2h16(404))
  call Hloop_VQ_A(ntryL,G1H32(405),ex2(:),G1H16(1),m3h2x16(:,405),heltab2x32(:,:,405))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(405),n2h16(405))
  call Hloop_ZQ_A(ntryL,G1H32(406),ex2(:),G1H16(1),ngZl,m3h2x16(:,406),heltab2x32(:,:,406))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(406),n2h16(406))
  call Hloop_ZQ_A(ntryL,G1H32(407),ex2(:),G1H16(1),ngZl,m3h2x16(:,407),heltab2x32(:,:,407))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(407),n2h16(407))
  call Hloop_SQ_A(ntryL,G1H32(408),ex2(:),G1H16(1),ngH,m3h2x16(:,408),heltab2x32(:,:,408))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(408),n2h16(408))
  call Hloop_SQ_A(ntryL,G1H32(409),ex2(:),G1H16(1),ngH,m3h2x16(:,409),heltab2x32(:,:,409))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(409),n2h16(409))
  call Hloop_SQ_A(ntryL,G1H32(410),ex2(:),G1H16(1),ngX,m3h2x16(:,410),heltab2x32(:,:,410))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(410),n2h16(410))
  call Hloop_SQ_A(ntryL,G1H32(411),ex2(:),G1H16(1),ngX,m3h2x16(:,411),heltab2x32(:,:,411))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(411),n2h16(411))
  call Hloop_SQ_A(ntryL,G1H32(412),ex2(:),G1H16(1),ngH,m3h2x16(:,412),heltab2x32(:,:,412))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(412),n2h16(412))
  call Hloop_SQ_A(ntryL,G1H32(413),ex2(:),G1H16(1),ngH,m3h2x16(:,413),heltab2x32(:,:,413))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(413),n2h16(413))
  call Hloop_SQ_A(ntryL,G1H32(414),ex2(:),G1H16(1),ngX,m3h2x16(:,414),heltab2x32(:,:,414))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(414),n2h16(414))
  call Hloop_SQ_A(ntryL,G1H32(415),ex2(:),G1H16(1),ngX,m3h2x16(:,415),heltab2x32(:,:,415))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(415),n2h16(415))
  call Hloop_VQ_A(ntryL,G1H32(416),ex2(:),G1H16(1),m3h2x16(:,416),heltab2x32(:,:,416))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(416),n2h16(416))
  call Hloop_VQ_A(ntryL,G1H32(417),ex2(:),G1H16(1),m3h2x16(:,417),heltab2x32(:,:,417))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(417),n2h16(417))
  call Hloop_VQ_A(ntryL,G1H32(418),ex2(:),G1H16(1),m3h2x16(:,418),heltab2x32(:,:,418))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(418),n2h16(418))
  call Hloop_VQ_A(ntryL,G1H32(419),ex2(:),G1H16(1),m3h2x16(:,419),heltab2x32(:,:,419))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(419),n2h16(419))
  call Hloop_SQ_A(ntryL,G1H32(420),ex2(:),G1H16(1),ngH,m3h2x16(:,420),heltab2x32(:,:,420))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(420),n2h16(420))
  call Hloop_SQ_A(ntryL,G1H32(421),ex2(:),G1H16(1),ngX,m3h2x16(:,421),heltab2x32(:,:,421))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(421),n2h16(421))
  call Hloop_SQ_A(ntryL,G1H32(422),ex2(:),G1H16(1),ngH,m3h2x16(:,422),heltab2x32(:,:,422))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(422),n2h16(422))
  call Hloop_SQ_A(ntryL,G1H32(423),ex2(:),G1H16(1),ngH,m3h2x16(:,423),heltab2x32(:,:,423))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(423),n2h16(423))
  call Hloop_SQ_A(ntryL,G1H32(424),ex2(:),G1H16(1),ngX,m3h2x16(:,424),heltab2x32(:,:,424))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(424),n2h16(424))
  call Hloop_SQ_A(ntryL,G1H32(425),ex2(:),G1H16(1),ngX,m3h2x16(:,425),heltab2x32(:,:,425))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(425),n2h16(425))
  call Hloop_VQ_A(ntryL,G1H32(426),ex2(:),G1H16(1),m3h2x16(:,426),heltab2x32(:,:,426))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(426),n2h16(426))
  call Hloop_VQ_A(ntryL,G1H32(427),ex2(:),G1H16(1),m3h2x16(:,427),heltab2x32(:,:,427))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(427),n2h16(427))
  call Hloop_VQ_A(ntryL,G1H32(428),ex2(:),G1H16(1),m3h2x16(:,428),heltab2x32(:,:,428))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(428),n2h16(428))
  call Hloop_ZQ_A(ntryL,G1H32(429),ex2(:),G1H16(1),ngZl,m3h2x16(:,429),heltab2x32(:,:,429))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(429),n2h16(429))
  call Hloop_VQ_A(ntryL,G1H32(430),ex2(:),G1H16(1),m3h2x16(:,430),heltab2x32(:,:,430))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(430),n2h16(430))
  call Hloop_ZQ_A(ntryL,G1H32(431),ex2(:),G1H16(1),ngZl,m3h2x16(:,431),heltab2x32(:,:,431))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(431),n2h16(431))
  call Hloop_VQ_A(ntryL,G1H32(432),ex2(:),G1H16(1),m3h2x16(:,432),heltab2x32(:,:,432))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(432),n2h16(432))
  call Hloop_VQ_A(ntryL,G1H32(433),ex2(:),G1H16(1),m3h2x16(:,433),heltab2x32(:,:,433))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(433),n2h16(433))
  call Hloop_VQ_A(ntryL,G1H32(434),ex2(:),G1H16(1),m3h2x16(:,434),heltab2x32(:,:,434))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(434),n2h16(434))
  call Hloop_ZQ_A(ntryL,G1H32(435),ex2(:),G1H16(1),ngZl,m3h2x16(:,435),heltab2x32(:,:,435))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(435),n2h16(435))
  call Hloop_VQ_A(ntryL,G1H32(436),ex2(:),G1H16(1),m3h2x16(:,436),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(436),n2h16(436))
  call Hloop_ZQ_A(ntryL,G1H32(437),ex2(:),G1H16(1),ngZl,m3h2x16(:,437),heltab2x32(:,:,437))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(437),n2h16(437))
  call Hloop_VQ_A(ntryL,G1H32(438),ex2(:),G1H16(1),m3h2x16(:,438),heltab2x32(:,:,438))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(438),n2h16(438))
  call Hloop_VQ_A(ntryL,G1H32(439),ex2(:),G1H16(1),m3h2x16(:,439),heltab2x32(:,:,439))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(439),n2h16(439))
  call Hloop_VQ_A(ntryL,G1H32(440),ex2(:),G1H16(1),m3h2x16(:,440),heltab2x32(:,:,440))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(440),n2h16(440))
  call Hloop_ZQ_A(ntryL,G1H32(441),ex2(:),G1H16(1),ngZl,m3h2x16(:,441),heltab2x32(:,:,441))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(441),n2h16(441))
  call Hloop_VQ_A(ntryL,G1H32(442),ex2(:),G1H16(1),m3h2x16(:,442),heltab2x32(:,:,442))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(442),n2h16(442))
  call Hloop_ZQ_A(ntryL,G1H32(443),ex2(:),G1H16(1),ngZl,m3h2x16(:,443),heltab2x32(:,:,443))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(443),n2h16(443))
  call Hloop_ZQ_A(ntryL,G1H32(444),ex2(:),G1H16(1),ngZl,m3h2x16(:,444),heltab2x32(:,:,444))
  call Hloop_Q_A(ntryL,G1H16(1),67,nME,G2H16(444),n2h16(444))
  call Hloop_SQ_A(ntryL,G1H32(445),ex2(:),G1H16(1),ngH,m3h2x16(:,445),heltab2x32(:,:,445))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(445),n2h16(445))
  call Hloop_SQ_A(ntryL,G1H32(446),ex2(:),G1H16(1),ngX,m3h2x16(:,446),heltab2x32(:,:,446))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(446),n2h16(446))
  call Hloop_SQ_A(ntryL,G1H32(447),ex2(:),G1H16(1),ngH,m3h2x16(:,447),heltab2x32(:,:,447))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(447),n2h16(447))
  call Hloop_SQ_A(ntryL,G1H32(448),ex2(:),G1H16(1),ngX,m3h2x16(:,448),heltab2x32(:,:,448))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(448),n2h16(448))
  call Hloop_VQ_A(ntryL,G1H32(449),ex2(:),G1H16(1),m3h2x16(:,449),heltab2x32(:,:,449))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(449),n2h16(449))
  call Hloop_VQ_A(ntryL,G1H32(450),ex2(:),G1H16(1),m3h2x16(:,450),heltab2x32(:,:,450))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(450),n2h16(450))
  call Hloop_VQ_A(ntryL,G1H32(451),ex2(:),G1H16(1),m3h2x16(:,451),heltab2x32(:,:,451))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(451),n2h16(451))
  call Hloop_VQ_A(ntryL,G1H32(452),ex2(:),G1H16(1),m3h2x16(:,452),heltab2x32(:,:,452))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(452),n2h16(452))
  call Hloop_SQ_A(ntryL,G1H32(453),ex2(:),G1H16(1),ngH,m3h2x16(:,453),heltab2x32(:,:,453))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(453),n2h16(453))
  call Hloop_SQ_A(ntryL,G1H32(454),ex2(:),G1H16(1),ngH,m3h2x16(:,454),heltab2x32(:,:,454))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(454),n2h16(454))
  call Hloop_SQ_A(ntryL,G1H32(455),ex2(:),G1H16(1),ngX,m3h2x16(:,455),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(455),n2h16(455))
  call Hloop_SQ_A(ntryL,G1H32(456),ex2(:),G1H16(1),ngX,m3h2x16(:,456),heltab2x32(:,:,456))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(456),n2h16(456))
  call Hloop_VQ_A(ntryL,G1H32(457),ex2(:),G1H16(1),m3h2x16(:,457),heltab2x32(:,:,457))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(457),n2h16(457))
  call Hloop_VQ_A(ntryL,G1H32(458),ex2(:),G1H16(1),m3h2x16(:,458),heltab2x32(:,:,458))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(458),n2h16(458))
  call Hloop_VQ_A(ntryL,G1H32(459),ex2(:),G1H16(1),m3h2x16(:,459),heltab2x32(:,:,459))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(459),n2h16(459))
  call Hloop_ZQ_A(ntryL,G1H32(460),ex2(:),G1H16(1),ngZl,m3h2x16(:,460),heltab2x32(:,:,460))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(460),n2h16(460))
  call Hloop_VQ_A(ntryL,G1H32(461),ex2(:),G1H16(1),m3h2x16(:,461),heltab2x32(:,:,461))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(461),n2h16(461))
  call Hloop_ZQ_A(ntryL,G1H32(462),ex2(:),G1H16(1),ngZl,m3h2x16(:,462),heltab2x32(:,:,462))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(462),n2h16(462))
  call Hloop_SQ_A(ntryL,G1H32(463),ex2(:),G1H16(1),ngH,m3h2x16(:,463),heltab2x32(:,:,463))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(463),n2h16(463))
  call Hloop_SQ_A(ntryL,G1H32(464),ex2(:),G1H16(1),ngX,m3h2x16(:,464),heltab2x32(:,:,464))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(464),n2h16(464))
  call Hloop_SQ_A(ntryL,G1H32(465),ex2(:),G1H16(1),ngH,m3h2x16(:,465),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(465),n2h16(465))
  call Hloop_SQ_A(ntryL,G1H32(466),ex2(:),G1H16(1),ngH,m3h2x16(:,466),heltab2x32(:,:,466))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(466),n2h16(466))
  call Hloop_SQ_A(ntryL,G1H32(467),ex2(:),G1H16(1),ngX,m3h2x16(:,467),heltab2x32(:,:,467))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(467),n2h16(467))
  call Hloop_SQ_A(ntryL,G1H32(468),ex2(:),G1H16(1),ngX,m3h2x16(:,468),heltab2x32(:,:,468))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(468),n2h16(468))
  call Hloop_VQ_A(ntryL,G1H32(469),ex2(:),G1H16(1),m3h2x16(:,469),heltab2x32(:,:,469))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(469),n2h16(469))
  call Hloop_VQ_A(ntryL,G1H32(470),ex2(:),G1H16(1),m3h2x16(:,470),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(470),n2h16(470))
  call Hloop_ZQ_A(ntryL,G1H32(471),ex2(:),G1H16(1),ngZl,m3h2x16(:,471),heltab2x32(:,:,471))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(471),n2h16(471))
  call Hloop_VQ_A(ntryL,G1H32(472),ex2(:),G1H16(1),m3h2x16(:,472),heltab2x32(:,:,472))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(472),n2h16(472))
  call Hloop_ZQ_A(ntryL,G1H32(473),ex2(:),G1H16(1),ngZl,m3h2x16(:,473),heltab2x32(:,:,473))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(473),n2h16(473))
  call Hloop_VQ_A(ntryL,G1H32(474),ex2(:),G1H16(1),m3h2x16(:,474),heltab2x32(:,:,474))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(474),n2h16(474))
  call Hloop_VQ_A(ntryL,G1H32(475),ex2(:),G1H16(1),m3h2x16(:,475),heltab2x32(:,:,475))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(475),n2h16(475))
  call Hloop_VQ_A(ntryL,G1H32(476),ex2(:),G1H16(1),m3h2x16(:,476),heltab2x32(:,:,476))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(476),n2h16(476))
  call Hloop_ZQ_A(ntryL,G1H32(477),ex2(:),G1H16(1),ngZl,m3h2x16(:,477),heltab2x32(:,:,477))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(477),n2h16(477))
  call Hloop_VQ_A(ntryL,G1H32(478),ex2(:),G1H16(1),m3h2x16(:,478),heltab2x32(:,:,478))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(478),n2h16(478))
  call Hloop_ZQ_A(ntryL,G1H32(479),ex2(:),G1H16(1),ngZl,m3h2x16(:,479),heltab2x32(:,:,479))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(479),n2h16(479))
  call Hloop_VQ_A(ntryL,G1H32(480),ex2(:),G1H16(1),m3h2x16(:,480),heltab2x32(:,:,480))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(480),n2h16(480))
  call Hloop_ZQ_A(ntryL,G1H32(481),ex2(:),G1H16(1),ngZl,m3h2x16(:,481),heltab2x32(:,:,481))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(481),n2h16(481))
  call Hloop_VA_Q(ntryL,G1H32(482),ex4(:),G1H16(1),m3h2x16(:,482),heltab2x32(:,:,482))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(482),n2h16(482))
  call Hloop_VA_Q(ntryL,G1H32(483),ex4(:),G1H16(1),m3h2x16(:,483),heltab2x32(:,:,483))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(483),n2h16(483))
  call Hloop_VA_Q(ntryL,G1H32(484),ex4(:),G1H16(1),m3h2x16(:,484),heltab2x32(:,:,484))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(484),n2h16(484))
  call Hloop_VA_Q(ntryL,G1H32(485),ex4(:),G1H16(1),m3h2x16(:,485),heltab2x32(:,:,485))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(485),n2h16(485))
  call Hloop_SA_Q(ntryL,G1H32(486),ex4(:),G1H16(1),ngH,m3h2x16(:,486),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(486),n2h16(486))
  call Hloop_SA_Q(ntryL,G1H32(487),ex4(:),G1H16(1),ngX,m3h2x16(:,487),heltab2x32(:,:,487))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(487),n2h16(487))
  call Hloop_SA_Q(ntryL,G1H32(488),ex4(:),G1H16(1),ngH,m3h2x16(:,488),heltab2x32(:,:,488))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(488),n2h16(488))
  call Hloop_SA_Q(ntryL,G1H32(489),ex4(:),G1H16(1),ngX,m3h2x16(:,489),heltab2x32(:,:,489))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(489),n2h16(489))
  call Hloop_SA_Q(ntryL,G1H32(490),ex4(:),G1H16(1),ngH,m3h2x16(:,490),heltab2x32(:,:,490))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(490),n2h16(490))
  call Hloop_SA_Q(ntryL,G1H32(491),ex4(:),G1H16(1),ngX,m3h2x16(:,491),heltab2x32(:,:,491))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(491),n2h16(491))
  call Hloop_SA_Q(ntryL,G1H32(492),ex4(:),G1H16(1),ngH,m3h2x16(:,492),heltab2x32(:,:,492))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(492),n2h16(492))
  call Hloop_SA_Q(ntryL,G1H32(493),ex4(:),G1H16(1),ngX,m3h2x16(:,493),heltab2x32(:,:,493))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(493),n2h16(493))
  call Hloop_VA_Q(ntryL,G1H32(494),ex4(:),G1H16(1),m3h2x16(:,494),heltab2x32(:,:,494))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(494),n2h16(494))
  call Hloop_VA_Q(ntryL,G1H32(495),ex4(:),G1H16(1),m3h2x16(:,495),heltab2x32(:,:,495))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(495),n2h16(495))
  call Hloop_ZA_Q(ntryL,G1H32(496),ex4(:),G1H16(1),ngZl,m3h2x16(:,496),heltab2x32(:,:,496))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(496),n2h16(496))
  call Hloop_VA_Q(ntryL,G1H32(497),ex4(:),G1H16(1),m3h2x16(:,497),heltab2x32(:,:,497))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(497),n2h16(497))
  call Hloop_ZA_Q(ntryL,G1H32(498),ex4(:),G1H16(1),ngZl,m3h2x16(:,498),heltab2x32(:,:,498))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(498),n2h16(498))
  call Hloop_VA_Q(ntryL,G1H32(499),ex4(:),G1H16(1),m3h2x16(:,499),heltab2x32(:,:,499))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(499),n2h16(499))
  call Hloop_VA_Q(ntryL,G1H32(500),ex4(:),G1H16(1),m3h2x16(:,500),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(500),n2h16(500))
  call Hloop_VA_Q(ntryL,G1H32(501),ex4(:),G1H16(1),m3h2x16(:,501),heltab2x32(:,:,501))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(501),n2h16(501))
  call Hloop_ZA_Q(ntryL,G1H32(502),ex4(:),G1H16(1),ngZl,m3h2x16(:,502),heltab2x32(:,:,502))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(502),n2h16(502))
  call Hloop_VA_Q(ntryL,G1H32(503),ex4(:),G1H16(1),m3h2x16(:,503),heltab2x32(:,:,503))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(503),n2h16(503))
  call Hloop_ZA_Q(ntryL,G1H32(504),ex4(:),G1H16(1),ngZl,m3h2x16(:,504),heltab2x32(:,:,504))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(504),n2h16(504))
  call Hloop_VA_Q(ntryL,G1H32(505),ex4(:),G1H16(1),m3h2x16(:,505),heltab2x32(:,:,505))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(505),n2h16(505))
  call Hloop_SA_Q(ntryL,G1H32(506),ex4(:),G1H16(1),ngH,m3h2x16(:,506),heltab2x32(:,:,506))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(506),n2h16(506))
  call Hloop_SA_Q(ntryL,G1H32(507),ex4(:),G1H16(1),ngX,m3h2x16(:,507),heltab2x32(:,:,507))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(507),n2h16(507))
  call Hloop_SA_Q(ntryL,G1H32(508),ex4(:),G1H16(1),ngH,m3h2x16(:,508),heltab2x32(:,:,508))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(508),n2h16(508))
  call Hloop_SA_Q(ntryL,G1H32(509),ex4(:),G1H16(1),ngH,m3h2x16(:,509),heltab2x32(:,:,509))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(509),n2h16(509))
  call Hloop_SA_Q(ntryL,G1H32(510),ex4(:),G1H16(1),ngX,m3h2x16(:,510),heltab2x32(:,:,510))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(510),n2h16(510))
  call Hloop_SA_Q(ntryL,G1H32(511),ex4(:),G1H16(1),ngX,m3h2x16(:,511),heltab2x32(:,:,511))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(511),n2h16(511))
  call Hloop_VA_Q(ntryL,G1H32(512),ex4(:),G1H16(1),m3h2x16(:,512),heltab2x32(:,:,512))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(512),n2h16(512))
  call Hloop_ZA_Q(ntryL,G1H32(513),ex4(:),G1H16(1),ngZl,m3h2x16(:,513),heltab2x32(:,:,513))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(513),n2h16(513))
  call Hloop_VA_Q(ntryL,G1H32(514),ex4(:),G1H16(1),m3h2x16(:,514),heltab2x32(:,:,514))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(514),n2h16(514))
  call Hloop_VA_Q(ntryL,G1H32(515),ex4(:),G1H16(1),m3h2x16(:,515),heltab2x32(:,:,515))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(515),n2h16(515))
  call Hloop_ZA_Q(ntryL,G1H32(516),ex4(:),G1H16(1),ngZl,m3h2x16(:,516),heltab2x32(:,:,516))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(516),n2h16(516))
  call Hloop_ZA_Q(ntryL,G1H32(517),ex4(:),G1H16(1),ngZl,m3h2x16(:,517),heltab2x32(:,:,517))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(517),n2h16(517))
  call Hloop_VA_Q(ntryL,G1H32(518),ex4(:),G1H16(1),m3h2x16(:,518),heltab2x32(:,:,518))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(518),n2h16(518))
  call Hloop_SQ_A(ntryL,G1H32(519),ex2(:),G1H16(1),ngH,m3h2x16(:,519),heltab2x32(:,:,519))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(519),n2h16(519))
  call Hloop_SQ_A(ntryL,G1H32(520),ex2(:),G1H16(1),ngX,m3h2x16(:,520),heltab2x32(:,:,520))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(520),n2h16(520))
  call Hloop_SQ_A(ntryL,G1H32(521),ex2(:),G1H16(1),ngH,m3h2x16(:,521),heltab2x32(:,:,521))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(521),n2h16(521))
  call Hloop_SQ_A(ntryL,G1H32(522),ex2(:),G1H16(1),ngX,m3h2x16(:,522),heltab2x32(:,:,522))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(522),n2h16(522))
  call Hloop_VQ_A(ntryL,G1H32(523),ex2(:),G1H16(1),m3h2x16(:,523),heltab2x32(:,:,523))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(523),n2h16(523))
  call Hloop_VQ_A(ntryL,G1H32(524),ex2(:),G1H16(1),m3h2x16(:,524),heltab2x32(:,:,524))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(524),n2h16(524))
  call Hloop_VQ_A(ntryL,G1H32(525),ex2(:),G1H16(1),m3h2x16(:,525),heltab2x32(:,:,525))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(525),n2h16(525))
  call Hloop_VQ_A(ntryL,G1H32(526),ex2(:),G1H16(1),m3h2x16(:,526),heltab2x32(:,:,526))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(526),n2h16(526))
  call Hloop_SQ_A(ntryL,G1H32(527),ex2(:),G1H16(1),ngH,m3h2x16(:,527),heltab2x32(:,:,527))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(527),n2h16(527))
  call Hloop_SQ_A(ntryL,G1H32(528),ex2(:),G1H16(1),ngH,m3h2x16(:,528),heltab2x32(:,:,528))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(528),n2h16(528))
  call Hloop_SQ_A(ntryL,G1H32(529),ex2(:),G1H16(1),ngX,m3h2x16(:,529),heltab2x32(:,:,529))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(529),n2h16(529))
  call Hloop_SQ_A(ntryL,G1H32(530),ex2(:),G1H16(1),ngX,m3h2x16(:,530),heltab2x32(:,:,530))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(530),n2h16(530))
  call Hloop_VQ_A(ntryL,G1H32(531),ex2(:),G1H16(1),m3h2x16(:,531),heltab2x32(:,:,531))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(531),n2h16(531))
  call Hloop_VQ_A(ntryL,G1H32(532),ex2(:),G1H16(1),m3h2x16(:,532),heltab2x32(:,:,532))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(532),n2h16(532))
  call Hloop_VQ_A(ntryL,G1H32(533),ex2(:),G1H16(1),m3h2x16(:,533),heltab2x32(:,:,533))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(533),n2h16(533))
  call Hloop_ZQ_A(ntryL,G1H32(534),ex2(:),G1H16(1),ngZl,m3h2x16(:,534),heltab2x32(:,:,534))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(534),n2h16(534))
  call Hloop_VQ_A(ntryL,G1H32(535),ex2(:),G1H16(1),m3h2x16(:,535),heltab2x32(:,:,535))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(535),n2h16(535))
  call Hloop_ZQ_A(ntryL,G1H32(536),ex2(:),G1H16(1),ngZl,m3h2x16(:,536),heltab2x32(:,:,536))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(536),n2h16(536))
  call Hloop_SQ_A(ntryL,G1H32(537),ex2(:),G1H16(1),ngH,m3h2x16(:,537),heltab2x32(:,:,537))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(537),n2h16(537))
  call Hloop_SQ_A(ntryL,G1H32(538),ex2(:),G1H16(1),ngX,m3h2x16(:,538),heltab2x32(:,:,538))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(538),n2h16(538))
  call Hloop_SQ_A(ntryL,G1H32(539),ex2(:),G1H16(1),ngH,m3h2x16(:,539),heltab2x32(:,:,539))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(539),n2h16(539))
  call Hloop_SQ_A(ntryL,G1H32(540),ex2(:),G1H16(1),ngH,m3h2x16(:,540),heltab2x32(:,:,540))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(540),n2h16(540))
  call Hloop_SQ_A(ntryL,G1H32(541),ex2(:),G1H16(1),ngX,m3h2x16(:,541),heltab2x32(:,:,541))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(541),n2h16(541))
  call Hloop_SQ_A(ntryL,G1H32(542),ex2(:),G1H16(1),ngX,m3h2x16(:,542),heltab2x32(:,:,542))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(542),n2h16(542))
  call Hloop_VQ_A(ntryL,G1H32(543),ex2(:),G1H16(1),m3h2x16(:,543),heltab2x32(:,:,543))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(543),n2h16(543))
  call Hloop_VQ_A(ntryL,G1H32(544),ex2(:),G1H16(1),m3h2x16(:,544),heltab2x32(:,:,544))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(544),n2h16(544))
  call Hloop_ZQ_A(ntryL,G1H32(545),ex2(:),G1H16(1),ngZl,m3h2x16(:,545),heltab2x32(:,:,545))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(545),n2h16(545))
  call Hloop_VQ_A(ntryL,G1H32(546),ex2(:),G1H16(1),m3h2x16(:,546),heltab2x32(:,:,546))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(546),n2h16(546))
  call Hloop_ZQ_A(ntryL,G1H32(547),ex2(:),G1H16(1),ngZl,m3h2x16(:,547),heltab2x32(:,:,547))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(547),n2h16(547))
  call Hloop_VQ_A(ntryL,G1H32(548),ex2(:),G1H16(1),m3h2x16(:,548),heltab2x32(:,:,548))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(548),n2h16(548))
  call Hloop_VQ_A(ntryL,G1H32(549),ex2(:),G1H16(1),m3h2x16(:,549),heltab2x32(:,:,549))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(549),n2h16(549))
  call Hloop_VQ_A(ntryL,G1H32(550),ex2(:),G1H16(1),m3h2x16(:,550),heltab2x32(:,:,550))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(550),n2h16(550))
  call Hloop_ZQ_A(ntryL,G1H32(551),ex2(:),G1H16(1),ngZl,m3h2x16(:,551),heltab2x32(:,:,551))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(551),n2h16(551))
  call Hloop_VQ_A(ntryL,G1H32(552),ex2(:),G1H16(1),m3h2x16(:,552),heltab2x32(:,:,552))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(552),n2h16(552))
  call Hloop_ZQ_A(ntryL,G1H32(553),ex2(:),G1H16(1),ngZl,m3h2x16(:,553),heltab2x32(:,:,553))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(553),n2h16(553))
  call Hloop_VQ_A(ntryL,G1H32(554),ex2(:),G1H16(1),m3h2x16(:,554),heltab2x32(:,:,554))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(554),n2h16(554))
  call Hloop_ZQ_A(ntryL,G1H32(555),ex2(:),G1H16(1),ngZl,m3h2x16(:,555),heltab2x32(:,:,555))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(555),n2h16(555))
  call Hloop_VA_Q(ntryL,G1H32(556),ex3(:),G1H16(1),m3h2x16(:,556),heltab2x32(:,:,556))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(556),n2h16(556))
  call Hloop_VA_Q(ntryL,G1H32(557),ex3(:),G1H16(1),m3h2x16(:,557),heltab2x32(:,:,557))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(557),n2h16(557))
  call Hloop_VA_Q(ntryL,G1H32(558),ex3(:),G1H16(1),m3h2x16(:,558),heltab2x32(:,:,558))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(558),n2h16(558))
  call Hloop_VA_Q(ntryL,G1H32(559),ex3(:),G1H16(1),m3h2x16(:,559),heltab2x32(:,:,559))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(559),n2h16(559))
  call Hloop_SA_Q(ntryL,G1H32(560),ex3(:),G1H16(1),ngH,m3h2x16(:,560),heltab2x32(:,:,560))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(560),n2h16(560))
  call Hloop_SA_Q(ntryL,G1H32(561),ex3(:),G1H16(1),ngX,m3h2x16(:,561),heltab2x32(:,:,561))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(561),n2h16(561))
  call Hloop_SA_Q(ntryL,G1H32(562),ex3(:),G1H16(1),ngH,m3h2x16(:,562),heltab2x32(:,:,562))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(562),n2h16(562))
  call Hloop_SA_Q(ntryL,G1H32(563),ex3(:),G1H16(1),ngX,m3h2x16(:,563),heltab2x32(:,:,563))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(563),n2h16(563))
  call Hloop_SA_Q(ntryL,G1H32(564),ex3(:),G1H16(1),ngH,m3h2x16(:,564),heltab2x32(:,:,564))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(564),n2h16(564))
  call Hloop_SA_Q(ntryL,G1H32(565),ex3(:),G1H16(1),ngX,m3h2x16(:,565),heltab2x32(:,:,565))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(565),n2h16(565))
  call Hloop_SA_Q(ntryL,G1H32(566),ex3(:),G1H16(1),ngH,m3h2x16(:,566),heltab2x32(:,:,566))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(566),n2h16(566))
  call Hloop_SA_Q(ntryL,G1H32(567),ex3(:),G1H16(1),ngX,m3h2x16(:,567),heltab2x32(:,:,567))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(567),n2h16(567))
  call Hloop_VA_Q(ntryL,G1H32(568),ex3(:),G1H16(1),m3h2x16(:,568),heltab2x32(:,:,568))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(568),n2h16(568))
  call Hloop_VA_Q(ntryL,G1H32(569),ex3(:),G1H16(1),m3h2x16(:,569),heltab2x32(:,:,569))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(569),n2h16(569))
  call Hloop_ZA_Q(ntryL,G1H32(570),ex3(:),G1H16(1),ngZl,m3h2x16(:,570),heltab2x32(:,:,570))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(570),n2h16(570))
  call Hloop_VA_Q(ntryL,G1H32(571),ex3(:),G1H16(1),m3h2x16(:,571),heltab2x32(:,:,571))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(571),n2h16(571))
  call Hloop_ZA_Q(ntryL,G1H32(572),ex3(:),G1H16(1),ngZl,m3h2x16(:,572),heltab2x32(:,:,572))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(572),n2h16(572))
  call Hloop_VA_Q(ntryL,G1H32(573),ex3(:),G1H16(1),m3h2x16(:,573),heltab2x32(:,:,573))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(573),n2h16(573))
  call Hloop_VA_Q(ntryL,G1H32(574),ex3(:),G1H16(1),m3h2x16(:,574),heltab2x32(:,:,574))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(574),n2h16(574))
  call Hloop_VA_Q(ntryL,G1H32(575),ex3(:),G1H16(1),m3h2x16(:,575),heltab2x32(:,:,575))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(575),n2h16(575))
  call Hloop_ZA_Q(ntryL,G1H32(576),ex3(:),G1H16(1),ngZl,m3h2x16(:,576),heltab2x32(:,:,576))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(576),n2h16(576))
  call Hloop_VA_Q(ntryL,G1H32(577),ex3(:),G1H16(1),m3h2x16(:,577),heltab2x32(:,:,577))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(577),n2h16(577))
  call Hloop_ZA_Q(ntryL,G1H32(578),ex3(:),G1H16(1),ngZl,m3h2x16(:,578),heltab2x32(:,:,578))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(578),n2h16(578))
  call Hloop_VA_Q(ntryL,G1H32(579),ex3(:),G1H16(1),m3h2x16(:,579),heltab2x32(:,:,579))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(579),n2h16(579))
  call Hloop_SA_Q(ntryL,G1H32(580),ex3(:),G1H16(1),ngH,m3h2x16(:,580),heltab2x32(:,:,580))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(580),n2h16(580))
  call Hloop_SA_Q(ntryL,G1H32(581),ex3(:),G1H16(1),ngX,m3h2x16(:,581),heltab2x32(:,:,581))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(581),n2h16(581))
  call Hloop_SA_Q(ntryL,G1H32(582),ex3(:),G1H16(1),ngH,m3h2x16(:,582),heltab2x32(:,:,582))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(582),n2h16(582))
  call Hloop_SA_Q(ntryL,G1H32(583),ex3(:),G1H16(1),ngH,m3h2x16(:,583),heltab2x32(:,:,583))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(583),n2h16(583))
  call Hloop_SA_Q(ntryL,G1H32(584),ex3(:),G1H16(1),ngX,m3h2x16(:,584),heltab2x32(:,:,584))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(584),n2h16(584))
  call Hloop_SA_Q(ntryL,G1H32(585),ex3(:),G1H16(1),ngX,m3h2x16(:,585),heltab2x32(:,:,585))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(585),n2h16(585))
  call Hloop_VA_Q(ntryL,G1H32(586),ex3(:),G1H16(1),m3h2x16(:,586),heltab2x32(:,:,586))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(586),n2h16(586))
  call Hloop_ZA_Q(ntryL,G1H32(587),ex3(:),G1H16(1),ngZl,m3h2x16(:,587),heltab2x32(:,:,587))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(587),n2h16(587))
  call Hloop_VA_Q(ntryL,G1H32(588),ex3(:),G1H16(1),m3h2x16(:,588),heltab2x32(:,:,588))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(588),n2h16(588))
  call Hloop_VA_Q(ntryL,G1H32(589),ex3(:),G1H16(1),m3h2x16(:,589),heltab2x32(:,:,589))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(589),n2h16(589))
  call Hloop_ZA_Q(ntryL,G1H32(590),ex3(:),G1H16(1),ngZl,m3h2x16(:,590),heltab2x32(:,:,590))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(590),n2h16(590))
  call Hloop_ZA_Q(ntryL,G1H32(591),ex3(:),G1H16(1),ngZl,m3h2x16(:,591),heltab2x32(:,:,591))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(591),n2h16(591))
  call Hloop_VA_Q(ntryL,G1H32(592),ex3(:),G1H16(1),m3h2x16(:,592),heltab2x32(:,:,592))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(592),n2h16(592))
  call Hloop_SQ_A(ntryL,G1H32(593),ex5(:),G1H16(1),ngH,m3h2x16(:,593),heltab2x32(:,:,593))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(593),n2h16(593))
  call Hloop_SQ_A(ntryL,G1H32(594),ex5(:),G1H16(1),ngX,m3h2x16(:,594),heltab2x32(:,:,594))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(594),n2h16(594))
  call Hloop_SQ_A(ntryL,G1H32(595),ex5(:),G1H16(1),ngH,m3h2x16(:,595),heltab2x32(:,:,595))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(595),n2h16(595))
  call Hloop_SQ_A(ntryL,G1H32(596),ex5(:),G1H16(1),ngX,m3h2x16(:,596),heltab2x32(:,:,596))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(596),n2h16(596))
  call Hloop_VQ_A(ntryL,G1H32(597),ex5(:),G1H16(1),m3h2x16(:,597),heltab2x32(:,:,597))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(597),n2h16(597))
  call Hloop_VQ_A(ntryL,G1H32(598),ex5(:),G1H16(1),m3h2x16(:,598),heltab2x32(:,:,598))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(598),n2h16(598))
  call Hloop_VQ_A(ntryL,G1H32(599),ex5(:),G1H16(1),m3h2x16(:,599),heltab2x32(:,:,599))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(599),n2h16(599))
  call Hloop_VQ_A(ntryL,G1H32(600),ex5(:),G1H16(1),m3h2x16(:,600),heltab2x32(:,:,600))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(600),n2h16(600))
  call Hloop_SQ_A(ntryL,G1H32(601),ex5(:),G1H16(1),ngH,m3h2x16(:,601),heltab2x32(:,:,601))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(601),n2h16(601))
  call Hloop_SQ_A(ntryL,G1H32(602),ex5(:),G1H16(1),ngH,m3h2x16(:,602),heltab2x32(:,:,602))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(602),n2h16(602))
  call Hloop_SQ_A(ntryL,G1H32(603),ex5(:),G1H16(1),ngX,m3h2x16(:,603),heltab2x32(:,:,603))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(603),n2h16(603))
  call Hloop_SQ_A(ntryL,G1H32(604),ex5(:),G1H16(1),ngX,m3h2x16(:,604),heltab2x32(:,:,604))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(604),n2h16(604))
  call Hloop_VQ_A(ntryL,G1H32(605),ex5(:),G1H16(1),m3h2x16(:,605),heltab2x32(:,:,605))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(605),n2h16(605))
  call Hloop_VQ_A(ntryL,G1H32(606),ex5(:),G1H16(1),m3h2x16(:,606),heltab2x32(:,:,606))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(606),n2h16(606))
  call Hloop_VQ_A(ntryL,G1H32(607),ex5(:),G1H16(1),m3h2x16(:,607),heltab2x32(:,:,607))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(607),n2h16(607))
  call Hloop_ZQ_A(ntryL,G1H32(608),ex5(:),G1H16(1),ngZl,m3h2x16(:,608),heltab2x32(:,:,608))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(608),n2h16(608))
  call Hloop_VQ_A(ntryL,G1H32(609),ex5(:),G1H16(1),m3h2x16(:,609),heltab2x32(:,:,609))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(609),n2h16(609))
  call Hloop_ZQ_A(ntryL,G1H32(610),ex5(:),G1H16(1),ngZl,m3h2x16(:,610),heltab2x32(:,:,610))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(610),n2h16(610))
  call Hloop_SQ_A(ntryL,G1H32(611),ex5(:),G1H16(1),ngH,m3h2x16(:,611),heltab2x32(:,:,611))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(611),n2h16(611))
  call Hloop_SQ_A(ntryL,G1H32(612),ex5(:),G1H16(1),ngX,m3h2x16(:,612),heltab2x32(:,:,612))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(612),n2h16(612))
  call Hloop_SQ_A(ntryL,G1H32(613),ex5(:),G1H16(1),ngH,m3h2x16(:,613),heltab2x32(:,:,613))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(613),n2h16(613))
  call Hloop_SQ_A(ntryL,G1H32(614),ex5(:),G1H16(1),ngH,m3h2x16(:,614),heltab2x32(:,:,614))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(614),n2h16(614))
  call Hloop_SQ_A(ntryL,G1H32(615),ex5(:),G1H16(1),ngX,m3h2x16(:,615),heltab2x32(:,:,615))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(615),n2h16(615))
  call Hloop_SQ_A(ntryL,G1H32(616),ex5(:),G1H16(1),ngX,m3h2x16(:,616),heltab2x32(:,:,616))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(616),n2h16(616))
  call Hloop_VQ_A(ntryL,G1H32(617),ex5(:),G1H16(1),m3h2x16(:,617),heltab2x32(:,:,617))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(617),n2h16(617))
  call Hloop_VQ_A(ntryL,G1H32(618),ex5(:),G1H16(1),m3h2x16(:,618),heltab2x32(:,:,618))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(618),n2h16(618))
  call Hloop_ZQ_A(ntryL,G1H32(619),ex5(:),G1H16(1),ngZl,m3h2x16(:,619),heltab2x32(:,:,619))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(619),n2h16(619))
  call Hloop_VQ_A(ntryL,G1H32(620),ex5(:),G1H16(1),m3h2x16(:,620),heltab2x32(:,:,620))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(620),n2h16(620))
  call Hloop_ZQ_A(ntryL,G1H32(621),ex5(:),G1H16(1),ngZl,m3h2x16(:,621),heltab2x32(:,:,621))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(621),n2h16(621))
  call Hloop_VQ_A(ntryL,G1H32(622),ex5(:),G1H16(1),m3h2x16(:,622),heltab2x32(:,:,622))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(622),n2h16(622))
  call Hloop_VQ_A(ntryL,G1H32(623),ex5(:),G1H16(1),m3h2x16(:,623),heltab2x32(:,:,623))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(623),n2h16(623))
  call Hloop_VQ_A(ntryL,G1H32(624),ex5(:),G1H16(1),m3h2x16(:,624),heltab2x32(:,:,624))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(624),n2h16(624))
  call Hloop_ZQ_A(ntryL,G1H32(625),ex5(:),G1H16(1),ngZl,m3h2x16(:,625),heltab2x32(:,:,625))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(625),n2h16(625))
  call Hloop_VQ_A(ntryL,G1H32(626),ex5(:),G1H16(1),m3h2x16(:,626),heltab2x32(:,:,626))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(626),n2h16(626))
  call Hloop_ZQ_A(ntryL,G1H32(627),ex5(:),G1H16(1),ngZl,m3h2x16(:,627),heltab2x32(:,:,627))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(627),n2h16(627))
  call Hloop_VQ_A(ntryL,G1H32(628),ex5(:),G1H16(1),m3h2x16(:,628),heltab2x32(:,:,628))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(628),n2h16(628))
  call Hloop_ZQ_A(ntryL,G1H32(629),ex5(:),G1H16(1),ngZl,m3h2x16(:,629),heltab2x32(:,:,629))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(629),n2h16(629))
  call Hloop_SQ_A(ntryL,G1H32(630),ex5(:),G1H16(1),ngH,m3h2x16(:,630),heltab2x32(:,:,630))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(630),n2h16(630))
  call Hloop_SQ_A(ntryL,G1H32(631),ex5(:),G1H16(1),ngX,m3h2x16(:,631),heltab2x32(:,:,631))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(631),n2h16(631))
  call Hloop_SQ_A(ntryL,G1H32(632),ex5(:),G1H16(1),ngH,m3h2x16(:,632),heltab2x32(:,:,632))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(632),n2h16(632))
  call Hloop_SQ_A(ntryL,G1H32(633),ex5(:),G1H16(1),ngX,m3h2x16(:,633),heltab2x32(:,:,633))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(633),n2h16(633))
  call Hloop_VQ_A(ntryL,G1H32(634),ex5(:),G1H16(1),m3h2x16(:,634),heltab2x32(:,:,634))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(634),n2h16(634))
  call Hloop_VQ_A(ntryL,G1H32(635),ex5(:),G1H16(1),m3h2x16(:,635),heltab2x32(:,:,635))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(635),n2h16(635))
  call Hloop_VQ_A(ntryL,G1H32(636),ex5(:),G1H16(1),m3h2x16(:,636),heltab2x32(:,:,636))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(636),n2h16(636))
  call Hloop_VQ_A(ntryL,G1H32(637),ex5(:),G1H16(1),m3h2x16(:,637),heltab2x32(:,:,637))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(637),n2h16(637))
  call Hloop_SQ_A(ntryL,G1H32(638),ex5(:),G1H16(1),ngH,m3h2x16(:,638),heltab2x32(:,:,638))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(638),n2h16(638))
  call Hloop_SQ_A(ntryL,G1H32(639),ex5(:),G1H16(1),ngH,m3h2x16(:,639),heltab2x32(:,:,639))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(639),n2h16(639))
  call Hloop_SQ_A(ntryL,G1H32(640),ex5(:),G1H16(1),ngX,m3h2x16(:,640),heltab2x32(:,:,640))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(640),n2h16(640))
  call Hloop_SQ_A(ntryL,G1H32(641),ex5(:),G1H16(1),ngX,m3h2x16(:,641),heltab2x32(:,:,641))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(641),n2h16(641))
  call Hloop_VQ_A(ntryL,G1H32(642),ex5(:),G1H16(1),m3h2x16(:,642),heltab2x32(:,:,642))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(642),n2h16(642))
  call Hloop_VQ_A(ntryL,G1H32(643),ex5(:),G1H16(1),m3h2x16(:,643),heltab2x32(:,:,643))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(643),n2h16(643))
  call Hloop_VQ_A(ntryL,G1H32(644),ex5(:),G1H16(1),m3h2x16(:,644),heltab2x32(:,:,644))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(644),n2h16(644))
  call Hloop_ZQ_A(ntryL,G1H32(645),ex5(:),G1H16(1),ngZl,m3h2x16(:,645),heltab2x32(:,:,645))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(645),n2h16(645))
  call Hloop_VQ_A(ntryL,G1H32(646),ex5(:),G1H16(1),m3h2x16(:,646),heltab2x32(:,:,646))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(646),n2h16(646))
  call Hloop_ZQ_A(ntryL,G1H32(647),ex5(:),G1H16(1),ngZl,m3h2x16(:,647),heltab2x32(:,:,647))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(647),n2h16(647))
  call Hloop_SQ_A(ntryL,G1H32(648),ex5(:),G1H16(1),ngH,m3h2x16(:,648),heltab2x32(:,:,648))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(648),n2h16(648))
  call Hloop_SQ_A(ntryL,G1H32(649),ex5(:),G1H16(1),ngX,m3h2x16(:,649),heltab2x32(:,:,649))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(649),n2h16(649))
  call Hloop_SQ_A(ntryL,G1H32(650),ex5(:),G1H16(1),ngH,m3h2x16(:,650),heltab2x32(:,:,650))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(650),n2h16(650))
  call Hloop_SQ_A(ntryL,G1H32(651),ex5(:),G1H16(1),ngH,m3h2x16(:,651),heltab2x32(:,:,651))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(651),n2h16(651))
  call Hloop_SQ_A(ntryL,G1H32(652),ex5(:),G1H16(1),ngX,m3h2x16(:,652),heltab2x32(:,:,652))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(652),n2h16(652))
  call Hloop_SQ_A(ntryL,G1H32(653),ex5(:),G1H16(1),ngX,m3h2x16(:,653),heltab2x32(:,:,653))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(653),n2h16(653))
  call Hloop_VQ_A(ntryL,G1H32(654),ex5(:),G1H16(1),m3h2x16(:,654),heltab2x32(:,:,654))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(654),n2h16(654))
  call Hloop_VQ_A(ntryL,G1H32(655),ex5(:),G1H16(1),m3h2x16(:,655),heltab2x32(:,:,655))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(655),n2h16(655))
  call Hloop_ZQ_A(ntryL,G1H32(656),ex5(:),G1H16(1),ngZl,m3h2x16(:,656),heltab2x32(:,:,656))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(656),n2h16(656))
  call Hloop_VQ_A(ntryL,G1H32(657),ex5(:),G1H16(1),m3h2x16(:,657),heltab2x32(:,:,657))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(657),n2h16(657))
  call Hloop_ZQ_A(ntryL,G1H32(658),ex5(:),G1H16(1),ngZl,m3h2x16(:,658),heltab2x32(:,:,658))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(658),n2h16(658))
  call Hloop_VQ_A(ntryL,G1H32(659),ex5(:),G1H16(1),m3h2x16(:,659),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(659),n2h16(659))
  call Hloop_VQ_A(ntryL,G1H32(660),ex5(:),G1H16(1),m3h2x16(:,660),heltab2x32(:,:,660))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(660),n2h16(660))
  call Hloop_VQ_A(ntryL,G1H32(661),ex5(:),G1H16(1),m3h2x16(:,661),heltab2x32(:,:,661))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(661),n2h16(661))
  call Hloop_ZQ_A(ntryL,G1H32(662),ex5(:),G1H16(1),ngZl,m3h2x16(:,662),heltab2x32(:,:,662))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(662),n2h16(662))
  call Hloop_VQ_A(ntryL,G1H32(663),ex5(:),G1H16(1),m3h2x16(:,663),heltab2x32(:,:,663))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(663),n2h16(663))
  call Hloop_ZQ_A(ntryL,G1H32(664),ex5(:),G1H16(1),ngZl,m3h2x16(:,664),heltab2x32(:,:,664))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(664),n2h16(664))
  call Hloop_VQ_A(ntryL,G1H32(665),ex5(:),G1H16(1),m3h2x16(:,665),heltab2x32(:,:,665))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(665),n2h16(665))
  call Hloop_ZQ_A(ntryL,G1H32(666),ex5(:),G1H16(1),ngZl,m3h2x16(:,666),heltab2x32(:,:,666))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(666),n2h16(666))
  call Hloop_SA_Q(ntryL,G1H32(667),ex6(:),G1H16(1),ngH,m3h2x16(:,667),heltab2x32(:,:,667))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(667),n2h16(667))
  call Hloop_SA_Q(ntryL,G1H32(668),ex6(:),G1H16(1),ngX,m3h2x16(:,668),heltab2x32(:,:,668))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(668),n2h16(668))
  call Hloop_SA_Q(ntryL,G1H32(669),ex6(:),G1H16(1),ngH,m3h2x16(:,669),heltab2x32(:,:,669))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(669),n2h16(669))
  call Hloop_SA_Q(ntryL,G1H32(670),ex6(:),G1H16(1),ngX,m3h2x16(:,670),heltab2x32(:,:,670))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(670),n2h16(670))
  call Hloop_VA_Q(ntryL,G1H32(671),ex6(:),G1H16(1),m3h2x16(:,671),heltab2x32(:,:,671))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(671),n2h16(671))
  call Hloop_VA_Q(ntryL,G1H32(672),ex6(:),G1H16(1),m3h2x16(:,672),heltab2x32(:,:,672))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(672),n2h16(672))
  call Hloop_VA_Q(ntryL,G1H32(673),ex6(:),G1H16(1),m3h2x16(:,673),heltab2x32(:,:,673))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(673),n2h16(673))
  call Hloop_VA_Q(ntryL,G1H32(674),ex6(:),G1H16(1),m3h2x16(:,674),heltab2x32(:,:,674))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(674),n2h16(674))
  call Hloop_SA_Q(ntryL,G1H32(675),ex6(:),G1H16(1),ngH,m3h2x16(:,675),heltab2x32(:,:,675))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(675),n2h16(675))
  call Hloop_SA_Q(ntryL,G1H32(676),ex6(:),G1H16(1),ngH,m3h2x16(:,676),heltab2x32(:,:,676))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(676),n2h16(676))
  call Hloop_SA_Q(ntryL,G1H32(677),ex6(:),G1H16(1),ngX,m3h2x16(:,677),heltab2x32(:,:,677))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(677),n2h16(677))
  call Hloop_SA_Q(ntryL,G1H32(678),ex6(:),G1H16(1),ngX,m3h2x16(:,678),heltab2x32(:,:,678))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(678),n2h16(678))
  call Hloop_VA_Q(ntryL,G1H32(679),ex6(:),G1H16(1),m3h2x16(:,679),heltab2x32(:,:,679))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(679),n2h16(679))
  call Hloop_VA_Q(ntryL,G1H32(680),ex6(:),G1H16(1),m3h2x16(:,680),heltab2x32(:,:,680))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(680),n2h16(680))
  call Hloop_VA_Q(ntryL,G1H32(681),ex6(:),G1H16(1),m3h2x16(:,681),heltab2x32(:,:,681))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(681),n2h16(681))
  call Hloop_ZA_Q(ntryL,G1H32(682),ex6(:),G1H16(1),ngZl,m3h2x16(:,682),heltab2x32(:,:,682))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(682),n2h16(682))
  call Hloop_VA_Q(ntryL,G1H32(683),ex6(:),G1H16(1),m3h2x16(:,683),heltab2x32(:,:,683))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(683),n2h16(683))
  call Hloop_ZA_Q(ntryL,G1H32(684),ex6(:),G1H16(1),ngZl,m3h2x16(:,684),heltab2x32(:,:,684))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(684),n2h16(684))
  call Hloop_SA_Q(ntryL,G1H32(685),ex6(:),G1H16(1),ngH,m3h2x16(:,685),heltab2x32(:,:,685))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(685),n2h16(685))
  call Hloop_SA_Q(ntryL,G1H32(686),ex6(:),G1H16(1),ngX,m3h2x16(:,686),heltab2x32(:,:,686))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(686),n2h16(686))
  call Hloop_SA_Q(ntryL,G1H32(687),ex6(:),G1H16(1),ngH,m3h2x16(:,687),heltab2x32(:,:,687))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(687),n2h16(687))
  call Hloop_SA_Q(ntryL,G1H32(688),ex6(:),G1H16(1),ngH,m3h2x16(:,688),heltab2x32(:,:,688))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(688),n2h16(688))
  call Hloop_SA_Q(ntryL,G1H32(689),ex6(:),G1H16(1),ngX,m3h2x16(:,689),heltab2x32(:,:,689))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(689),n2h16(689))
  call Hloop_SA_Q(ntryL,G1H32(690),ex6(:),G1H16(1),ngX,m3h2x16(:,690),heltab2x32(:,:,690))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(690),n2h16(690))
  call Hloop_VA_Q(ntryL,G1H32(691),ex6(:),G1H16(1),m3h2x16(:,691),heltab2x32(:,:,691))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(691),n2h16(691))
  call Hloop_VA_Q(ntryL,G1H32(692),ex6(:),G1H16(1),m3h2x16(:,692),heltab2x32(:,:,692))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(692),n2h16(692))
  call Hloop_ZA_Q(ntryL,G1H32(693),ex6(:),G1H16(1),ngZl,m3h2x16(:,693),heltab2x32(:,:,693))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(693),n2h16(693))
  call Hloop_VA_Q(ntryL,G1H32(694),ex6(:),G1H16(1),m3h2x16(:,694),heltab2x32(:,:,694))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(694),n2h16(694))
  call Hloop_ZA_Q(ntryL,G1H32(695),ex6(:),G1H16(1),ngZl,m3h2x16(:,695),heltab2x32(:,:,695))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(695),n2h16(695))
  call Hloop_VA_Q(ntryL,G1H32(696),ex6(:),G1H16(1),m3h2x16(:,696),heltab2x32(:,:,696))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(696),n2h16(696))
  call Hloop_VA_Q(ntryL,G1H32(697),ex6(:),G1H16(1),m3h2x16(:,697),heltab2x32(:,:,697))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(697),n2h16(697))
  call Hloop_VA_Q(ntryL,G1H32(698),ex6(:),G1H16(1),m3h2x16(:,698),heltab2x32(:,:,698))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(698),n2h16(698))
  call Hloop_ZA_Q(ntryL,G1H32(699),ex6(:),G1H16(1),ngZl,m3h2x16(:,699),heltab2x32(:,:,699))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(699),n2h16(699))
  call Hloop_VA_Q(ntryL,G1H32(700),ex6(:),G1H16(1),m3h2x16(:,700),heltab2x32(:,:,700))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(700),n2h16(700))
  call Hloop_ZA_Q(ntryL,G1H32(701),ex6(:),G1H16(1),ngZl,m3h2x16(:,701),heltab2x32(:,:,701))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(701),n2h16(701))
  call Hloop_VA_Q(ntryL,G1H32(702),ex6(:),G1H16(1),m3h2x16(:,702),heltab2x32(:,:,702))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(702),n2h16(702))
  call Hloop_ZA_Q(ntryL,G1H32(703),ex6(:),G1H16(1),ngZl,m3h2x16(:,703),heltab2x32(:,:,703))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(703),n2h16(703))
  call Hloop_SA_Q(ntryL,G1H32(704),ex6(:),G1H16(1),ngH,m3h2x16(:,704),heltab2x32(:,:,704))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(704),n2h16(704))
  call Hloop_SA_Q(ntryL,G1H32(705),ex6(:),G1H16(1),ngX,m3h2x16(:,705),heltab2x32(:,:,705))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(705),n2h16(705))
  call Hloop_SA_Q(ntryL,G1H32(706),ex6(:),G1H16(1),ngH,m3h2x16(:,706),heltab2x32(:,:,706))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(706),n2h16(706))
  call Hloop_SA_Q(ntryL,G1H32(707),ex6(:),G1H16(1),ngX,m3h2x16(:,707),heltab2x32(:,:,707))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(707),n2h16(707))
  call Hloop_VA_Q(ntryL,G1H32(708),ex6(:),G1H16(1),m3h2x16(:,708),heltab2x32(:,:,708))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(708),n2h16(708))
  call Hloop_VA_Q(ntryL,G1H32(709),ex6(:),G1H16(1),m3h2x16(:,709),heltab2x32(:,:,709))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(709),n2h16(709))
  call Hloop_VA_Q(ntryL,G1H32(710),ex6(:),G1H16(1),m3h2x16(:,710),heltab2x32(:,:,710))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(710),n2h16(710))
  call Hloop_VA_Q(ntryL,G1H32(711),ex6(:),G1H16(1),m3h2x16(:,711),heltab2x32(:,:,711))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(711),n2h16(711))
  call Hloop_SA_Q(ntryL,G1H32(712),ex6(:),G1H16(1),ngH,m3h2x16(:,712),heltab2x32(:,:,712))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(712),n2h16(712))
  call Hloop_SA_Q(ntryL,G1H32(713),ex6(:),G1H16(1),ngH,m3h2x16(:,713),heltab2x32(:,:,713))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(713),n2h16(713))
  call Hloop_SA_Q(ntryL,G1H32(714),ex6(:),G1H16(1),ngX,m3h2x16(:,714),heltab2x32(:,:,714))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(714),n2h16(714))
  call Hloop_SA_Q(ntryL,G1H32(715),ex6(:),G1H16(1),ngX,m3h2x16(:,715),heltab2x32(:,:,715))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(715),n2h16(715))
  call Hloop_VA_Q(ntryL,G1H32(716),ex6(:),G1H16(1),m3h2x16(:,716),heltab2x32(:,:,716))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(716),n2h16(716))
  call Hloop_VA_Q(ntryL,G1H32(717),ex6(:),G1H16(1),m3h2x16(:,717),heltab2x32(:,:,717))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(717),n2h16(717))
  call Hloop_VA_Q(ntryL,G1H32(718),ex6(:),G1H16(1),m3h2x16(:,718),heltab2x32(:,:,718))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(718),n2h16(718))
  call Hloop_ZA_Q(ntryL,G1H32(719),ex6(:),G1H16(1),ngZl,m3h2x16(:,719),heltab2x32(:,:,719))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(719),n2h16(719))
  call Hloop_VA_Q(ntryL,G1H32(720),ex6(:),G1H16(1),m3h2x16(:,720),heltab2x32(:,:,720))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(720),n2h16(720))
  call Hloop_ZA_Q(ntryL,G1H32(721),ex6(:),G1H16(1),ngZl,m3h2x16(:,721),heltab2x32(:,:,721))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(721),n2h16(721))
  call Hloop_SA_Q(ntryL,G1H32(722),ex6(:),G1H16(1),ngH,m3h2x16(:,722),heltab2x32(:,:,722))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(722),n2h16(722))
  call Hloop_SA_Q(ntryL,G1H32(723),ex6(:),G1H16(1),ngX,m3h2x16(:,723),heltab2x32(:,:,723))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(723),n2h16(723))
  call Hloop_SA_Q(ntryL,G1H32(724),ex6(:),G1H16(1),ngH,m3h2x16(:,724),heltab2x32(:,:,724))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(724),n2h16(724))
  call Hloop_SA_Q(ntryL,G1H32(725),ex6(:),G1H16(1),ngH,m3h2x16(:,725),heltab2x32(:,:,725))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(725),n2h16(725))
  call Hloop_SA_Q(ntryL,G1H32(726),ex6(:),G1H16(1),ngX,m3h2x16(:,726),heltab2x32(:,:,726))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(726),n2h16(726))
  call Hloop_SA_Q(ntryL,G1H32(727),ex6(:),G1H16(1),ngX,m3h2x16(:,727),heltab2x32(:,:,727))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(727),n2h16(727))
  call Hloop_VA_Q(ntryL,G1H32(728),ex6(:),G1H16(1),m3h2x16(:,728),heltab2x32(:,:,728))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(728),n2h16(728))
  call Hloop_VA_Q(ntryL,G1H32(729),ex6(:),G1H16(1),m3h2x16(:,729),heltab2x32(:,:,729))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(729),n2h16(729))
  call Hloop_ZA_Q(ntryL,G1H32(730),ex6(:),G1H16(1),ngZl,m3h2x16(:,730),heltab2x32(:,:,730))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(730),n2h16(730))
  call Hloop_VA_Q(ntryL,G1H32(731),ex6(:),G1H16(1),m3h2x16(:,731),heltab2x32(:,:,731))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(731),n2h16(731))
  call Hloop_ZA_Q(ntryL,G1H32(732),ex6(:),G1H16(1),ngZl,m3h2x16(:,732),heltab2x32(:,:,732))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(732),n2h16(732))
  call Hloop_VA_Q(ntryL,G1H32(733),ex6(:),G1H16(1),m3h2x16(:,733),heltab2x32(:,:,733))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(733),n2h16(733))
  call Hloop_VA_Q(ntryL,G1H32(734),ex6(:),G1H16(1),m3h2x16(:,734),heltab2x32(:,:,734))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(734),n2h16(734))
  call Hloop_VA_Q(ntryL,G1H32(735),ex6(:),G1H16(1),m3h2x16(:,735),heltab2x32(:,:,735))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(735),n2h16(735))
  call Hloop_ZA_Q(ntryL,G1H32(736),ex6(:),G1H16(1),ngZl,m3h2x16(:,736),heltab2x32(:,:,736))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(736),n2h16(736))
  call Hloop_VA_Q(ntryL,G1H32(737),ex6(:),G1H16(1),m3h2x16(:,737),heltab2x32(:,:,737))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(737),n2h16(737))
  call Hloop_ZA_Q(ntryL,G1H32(738),ex6(:),G1H16(1),ngZl,m3h2x16(:,738),heltab2x32(:,:,738))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(738),n2h16(738))
  call Hloop_VA_Q(ntryL,G1H32(739),ex6(:),G1H16(1),m3h2x16(:,739),heltab2x32(:,:,739))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(739),n2h16(739))
  call Hloop_ZA_Q(ntryL,G1H32(740),ex6(:),G1H16(1),ngZl,m3h2x16(:,740),heltab2x32(:,:,740))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(740),n2h16(740))
  call Hloop_SQ_A(ntryL,G1H32(741),ex1(:),G1H16(1),ngH,m3h2x16(:,741),heltab2x32(:,:,741))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(741),n2h16(741))
  call Hloop_SQ_A(ntryL,G1H32(742),ex1(:),G1H16(1),ngH,m3h2x16(:,742),heltab2x32(:,:,742))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(742),n2h16(742))
  call Hloop_SQ_A(ntryL,G1H32(743),ex1(:),G1H16(1),ngX,m3h2x16(:,743),heltab2x32(:,:,743))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(743),n2h16(743))
  call Hloop_SQ_A(ntryL,G1H32(744),ex1(:),G1H16(1),ngX,m3h2x16(:,744),heltab2x32(:,:,744))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(744),n2h16(744))
  call Hloop_SQ_A(ntryL,G1H32(745),ex1(:),G1H16(1),ngH,m3h2x16(:,745),heltab2x32(:,:,745))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(745),n2h16(745))
  call Hloop_SQ_A(ntryL,G1H32(746),ex1(:),G1H16(1),ngH,m3h2x16(:,746),heltab2x32(:,:,746))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(746),n2h16(746))
  call Hloop_SQ_A(ntryL,G1H32(747),ex1(:),G1H16(1),ngX,m3h2x16(:,747),heltab2x32(:,:,747))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(747),n2h16(747))
  call Hloop_SQ_A(ntryL,G1H32(748),ex1(:),G1H16(1),ngX,m3h2x16(:,748),heltab2x32(:,:,748))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(748),n2h16(748))
  call Hloop_VQ_A(ntryL,G1H32(749),ex1(:),G1H16(1),m3h2x16(:,749),heltab2x32(:,:,749))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(749),n2h16(749))
  call Hloop_VQ_A(ntryL,G1H32(750),ex1(:),G1H16(1),m3h2x16(:,750),heltab2x32(:,:,750))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(750),n2h16(750))
  call Hloop_VQ_A(ntryL,G1H32(751),ex1(:),G1H16(1),m3h2x16(:,751),heltab2x32(:,:,751))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(751),n2h16(751))
  call Hloop_VQ_A(ntryL,G1H32(752),ex1(:),G1H16(1),m3h2x16(:,752),heltab2x32(:,:,752))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(752),n2h16(752))
  call Hloop_SQ_A(ntryL,G1H32(753),ex1(:),G1H16(1),ngH,m3h2x16(:,753),heltab2x32(:,:,753))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(753),n2h16(753))
  call Hloop_SQ_A(ntryL,G1H32(754),ex1(:),G1H16(1),ngX,m3h2x16(:,754),heltab2x32(:,:,754))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(754),n2h16(754))
  call Hloop_SQ_A(ntryL,G1H32(755),ex1(:),G1H16(1),ngH,m3h2x16(:,755),heltab2x32(:,:,755))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(755),n2h16(755))
  call Hloop_SQ_A(ntryL,G1H32(756),ex1(:),G1H16(1),ngH,m3h2x16(:,756),heltab2x32(:,:,756))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(756),n2h16(756))
  call Hloop_SQ_A(ntryL,G1H32(757),ex1(:),G1H16(1),ngX,m3h2x16(:,757),heltab2x32(:,:,757))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(757),n2h16(757))
  call Hloop_SQ_A(ntryL,G1H32(758),ex1(:),G1H16(1),ngX,m3h2x16(:,758),heltab2x32(:,:,758))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(758),n2h16(758))
  call Hloop_VQ_A(ntryL,G1H32(759),ex1(:),G1H16(1),m3h2x16(:,759),heltab2x32(:,:,759))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(759),n2h16(759))
  call Hloop_VQ_A(ntryL,G1H32(760),ex1(:),G1H16(1),m3h2x16(:,760),heltab2x32(:,:,760))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(760),n2h16(760))
  call Hloop_VQ_A(ntryL,G1H32(761),ex1(:),G1H16(1),m3h2x16(:,761),heltab2x32(:,:,761))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(761),n2h16(761))
  call Hloop_ZQ_A(ntryL,G1H32(762),ex1(:),G1H16(1),ngZl,m3h2x16(:,762),heltab2x32(:,:,762))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(762),n2h16(762))
  call Hloop_VQ_A(ntryL,G1H32(763),ex1(:),G1H16(1),m3h2x16(:,763),heltab2x32(:,:,763))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(763),n2h16(763))
  call Hloop_ZQ_A(ntryL,G1H32(764),ex1(:),G1H16(1),ngZl,m3h2x16(:,764),heltab2x32(:,:,764))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(764),n2h16(764))
  call Hloop_VQ_A(ntryL,G1H32(765),ex1(:),G1H16(1),m3h2x16(:,765),heltab2x32(:,:,765))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(765),n2h16(765))
  call Hloop_VQ_A(ntryL,G1H32(766),ex1(:),G1H16(1),m3h2x16(:,766),heltab2x32(:,:,766))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(766),n2h16(766))
  call Hloop_VQ_A(ntryL,G1H32(767),ex1(:),G1H16(1),m3h2x16(:,767),heltab2x32(:,:,767))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(767),n2h16(767))
  call Hloop_ZQ_A(ntryL,G1H32(768),ex1(:),G1H16(1),ngZl,m3h2x16(:,768),heltab2x32(:,:,768))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(768),n2h16(768))
  call Hloop_VQ_A(ntryL,G1H32(769),ex1(:),G1H16(1),m3h2x16(:,769),heltab2x32(:,:,769))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(769),n2h16(769))
  call Hloop_ZQ_A(ntryL,G1H32(770),ex1(:),G1H16(1),ngZl,m3h2x16(:,770),heltab2x32(:,:,770))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(770),n2h16(770))
  call Hloop_VQ_A(ntryL,G1H32(771),ex1(:),G1H16(1),m3h2x16(:,771),heltab2x32(:,:,771))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(771),n2h16(771))
  call Hloop_VQ_A(ntryL,G1H32(772),ex1(:),G1H16(1),m3h2x16(:,772),heltab2x32(:,:,772))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(772),n2h16(772))
  call Hloop_VQ_A(ntryL,G1H32(773),ex1(:),G1H16(1),m3h2x16(:,773),heltab2x32(:,:,773))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(773),n2h16(773))
  call Hloop_ZQ_A(ntryL,G1H32(774),ex1(:),G1H16(1),ngZl,m3h2x16(:,774),heltab2x32(:,:,774))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(774),n2h16(774))
  call Hloop_VQ_A(ntryL,G1H32(775),ex1(:),G1H16(1),m3h2x16(:,775),heltab2x32(:,:,775))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(775),n2h16(775))
  call Hloop_ZQ_A(ntryL,G1H32(776),ex1(:),G1H16(1),ngZl,m3h2x16(:,776),heltab2x32(:,:,776))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(776),n2h16(776))
  call Hloop_ZQ_A(ntryL,G1H32(777),ex1(:),G1H16(1),ngZl,m3h2x16(:,777),heltab2x32(:,:,777))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(777),n2h16(777))
  call Hloop_SA_Q(ntryL,G1H32(778),ex3(:),G1H16(1),ngH,m3h2x16(:,778),heltab2x32(:,:,778))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(778),n2h16(778))
  call Hloop_SA_Q(ntryL,G1H32(779),ex3(:),G1H16(1),ngX,m3h2x16(:,779),heltab2x32(:,:,779))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(779),n2h16(779))
  call Hloop_SA_Q(ntryL,G1H32(780),ex3(:),G1H16(1),ngH,m3h2x16(:,780),heltab2x32(:,:,780))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(780),n2h16(780))
  call Hloop_SA_Q(ntryL,G1H32(781),ex3(:),G1H16(1),ngX,m3h2x16(:,781),heltab2x32(:,:,781))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(781),n2h16(781))
  call Hloop_VA_Q(ntryL,G1H32(782),ex3(:),G1H16(1),m3h2x16(:,782),heltab2x32(:,:,782))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(782),n2h16(782))
  call Hloop_VA_Q(ntryL,G1H32(783),ex3(:),G1H16(1),m3h2x16(:,783),heltab2x32(:,:,783))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(783),n2h16(783))
  call Hloop_VA_Q(ntryL,G1H32(784),ex3(:),G1H16(1),m3h2x16(:,784),heltab2x32(:,:,784))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(784),n2h16(784))
  call Hloop_VA_Q(ntryL,G1H32(785),ex3(:),G1H16(1),m3h2x16(:,785),heltab2x32(:,:,785))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(785),n2h16(785))
  call Hloop_SA_Q(ntryL,G1H32(786),ex3(:),G1H16(1),ngH,m3h2x16(:,786),heltab2x32(:,:,786))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(786),n2h16(786))
  call Hloop_SA_Q(ntryL,G1H32(787),ex3(:),G1H16(1),ngH,m3h2x16(:,787),heltab2x32(:,:,787))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(787),n2h16(787))
  call Hloop_SA_Q(ntryL,G1H32(788),ex3(:),G1H16(1),ngX,m3h2x16(:,788),heltab2x32(:,:,788))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(788),n2h16(788))
  call Hloop_SA_Q(ntryL,G1H32(789),ex3(:),G1H16(1),ngX,m3h2x16(:,789),heltab2x32(:,:,789))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(789),n2h16(789))
  call Hloop_VA_Q(ntryL,G1H32(790),ex3(:),G1H16(1),m3h2x16(:,790),heltab2x32(:,:,790))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(790),n2h16(790))
  call Hloop_VA_Q(ntryL,G1H32(791),ex3(:),G1H16(1),m3h2x16(:,791),heltab2x32(:,:,791))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(791),n2h16(791))
  call Hloop_VA_Q(ntryL,G1H32(792),ex3(:),G1H16(1),m3h2x16(:,792),heltab2x32(:,:,792))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(792),n2h16(792))
  call Hloop_ZA_Q(ntryL,G1H32(793),ex3(:),G1H16(1),ngZl,m3h2x16(:,793),heltab2x32(:,:,793))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(793),n2h16(793))
  call Hloop_VA_Q(ntryL,G1H32(794),ex3(:),G1H16(1),m3h2x16(:,794),heltab2x32(:,:,794))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(794),n2h16(794))
  call Hloop_ZA_Q(ntryL,G1H32(795),ex3(:),G1H16(1),ngZl,m3h2x16(:,795),heltab2x32(:,:,795))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(795),n2h16(795))
  call Hloop_SA_Q(ntryL,G1H32(796),ex3(:),G1H16(1),ngH,m3h2x16(:,796),heltab2x32(:,:,796))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(796),n2h16(796))
  call Hloop_SA_Q(ntryL,G1H32(797),ex3(:),G1H16(1),ngX,m3h2x16(:,797),heltab2x32(:,:,797))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(797),n2h16(797))
  call Hloop_SA_Q(ntryL,G1H32(798),ex3(:),G1H16(1),ngH,m3h2x16(:,798),heltab2x32(:,:,798))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(798),n2h16(798))
  call Hloop_SA_Q(ntryL,G1H32(799),ex3(:),G1H16(1),ngH,m3h2x16(:,799),heltab2x32(:,:,799))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(799),n2h16(799))
  call Hloop_SA_Q(ntryL,G1H32(800),ex3(:),G1H16(1),ngX,m3h2x16(:,800),heltab2x32(:,:,800))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(800),n2h16(800))
  call Hloop_SA_Q(ntryL,G1H32(801),ex3(:),G1H16(1),ngX,m3h2x16(:,801),heltab2x32(:,:,801))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(801),n2h16(801))
  call Hloop_VA_Q(ntryL,G1H32(802),ex3(:),G1H16(1),m3h2x16(:,802),heltab2x32(:,:,802))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(802),n2h16(802))
  call Hloop_VA_Q(ntryL,G1H32(803),ex3(:),G1H16(1),m3h2x16(:,803),heltab2x32(:,:,803))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(803),n2h16(803))
  call Hloop_ZA_Q(ntryL,G1H32(804),ex3(:),G1H16(1),ngZl,m3h2x16(:,804),heltab2x32(:,:,804))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(804),n2h16(804))
  call Hloop_VA_Q(ntryL,G1H32(805),ex3(:),G1H16(1),m3h2x16(:,805),heltab2x32(:,:,805))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(805),n2h16(805))
  call Hloop_ZA_Q(ntryL,G1H32(806),ex3(:),G1H16(1),ngZl,m3h2x16(:,806),heltab2x32(:,:,806))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(806),n2h16(806))
  call Hloop_VA_Q(ntryL,G1H32(807),ex3(:),G1H16(1),m3h2x16(:,807),heltab2x32(:,:,807))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(807),n2h16(807))
  call Hloop_VA_Q(ntryL,G1H32(808),ex3(:),G1H16(1),m3h2x16(:,808),heltab2x32(:,:,808))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(808),n2h16(808))
  call Hloop_VA_Q(ntryL,G1H32(809),ex3(:),G1H16(1),m3h2x16(:,809),heltab2x32(:,:,809))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(809),n2h16(809))
  call Hloop_ZA_Q(ntryL,G1H32(810),ex3(:),G1H16(1),ngZl,m3h2x16(:,810),heltab2x32(:,:,810))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(810),n2h16(810))
  call Hloop_VA_Q(ntryL,G1H32(811),ex3(:),G1H16(1),m3h2x16(:,811),heltab2x32(:,:,811))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(811),n2h16(811))
  call Hloop_ZA_Q(ntryL,G1H32(812),ex3(:),G1H16(1),ngZl,m3h2x16(:,812),heltab2x32(:,:,812))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(812),n2h16(812))
  call Hloop_VA_Q(ntryL,G1H32(813),ex3(:),G1H16(1),m3h2x16(:,813),heltab2x32(:,:,813))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(813),n2h16(813))
  call Hloop_ZA_Q(ntryL,G1H32(814),ex3(:),G1H16(1),ngZl,m3h2x16(:,814),heltab2x32(:,:,814))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(814),n2h16(814))
  call Hloop_SQ_A(ntryL,G1H32(815),ex1(:),G1H16(1),ngH,m3h2x16(:,815),heltab2x32(:,:,815))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(815),n2h16(815))
  call Hloop_SQ_A(ntryL,G1H32(816),ex1(:),G1H16(1),ngH,m3h2x16(:,816),heltab2x32(:,:,816))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(816),n2h16(816))
  call Hloop_SQ_A(ntryL,G1H32(817),ex1(:),G1H16(1),ngX,m3h2x16(:,817),heltab2x32(:,:,817))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(817),n2h16(817))
  call Hloop_SQ_A(ntryL,G1H32(818),ex1(:),G1H16(1),ngX,m3h2x16(:,818),heltab2x32(:,:,818))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(818),n2h16(818))
  call Hloop_SQ_A(ntryL,G1H32(819),ex1(:),G1H16(1),ngH,m3h2x16(:,819),heltab2x32(:,:,819))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(819),n2h16(819))
  call Hloop_SQ_A(ntryL,G1H32(820),ex1(:),G1H16(1),ngH,m3h2x16(:,820),heltab2x32(:,:,820))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(820),n2h16(820))
  call Hloop_SQ_A(ntryL,G1H32(821),ex1(:),G1H16(1),ngX,m3h2x16(:,821),heltab2x32(:,:,821))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(821),n2h16(821))
  call Hloop_SQ_A(ntryL,G1H32(822),ex1(:),G1H16(1),ngX,m3h2x16(:,822),heltab2x32(:,:,822))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(822),n2h16(822))
  call Hloop_VQ_A(ntryL,G1H32(823),ex1(:),G1H16(1),m3h2x16(:,823),heltab2x32(:,:,823))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(823),n2h16(823))
  call Hloop_VQ_A(ntryL,G1H32(824),ex1(:),G1H16(1),m3h2x16(:,824),heltab2x32(:,:,824))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(824),n2h16(824))
  call Hloop_VQ_A(ntryL,G1H32(825),ex1(:),G1H16(1),m3h2x16(:,825),heltab2x32(:,:,825))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(825),n2h16(825))
  call Hloop_VQ_A(ntryL,G1H32(826),ex1(:),G1H16(1),m3h2x16(:,826),heltab2x32(:,:,826))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(826),n2h16(826))
  call Hloop_SQ_A(ntryL,G1H32(827),ex1(:),G1H16(1),ngH,m3h2x16(:,827),heltab2x32(:,:,827))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(827),n2h16(827))
  call Hloop_SQ_A(ntryL,G1H32(828),ex1(:),G1H16(1),ngX,m3h2x16(:,828),heltab2x32(:,:,828))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(828),n2h16(828))
  call Hloop_SQ_A(ntryL,G1H32(829),ex1(:),G1H16(1),ngH,m3h2x16(:,829),heltab2x32(:,:,829))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(829),n2h16(829))
  call Hloop_SQ_A(ntryL,G1H32(830),ex1(:),G1H16(1),ngH,m3h2x16(:,830),heltab2x32(:,:,830))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(830),n2h16(830))
  call Hloop_SQ_A(ntryL,G1H32(831),ex1(:),G1H16(1),ngX,m3h2x16(:,831),heltab2x32(:,:,831))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(831),n2h16(831))
  call Hloop_SQ_A(ntryL,G1H32(832),ex1(:),G1H16(1),ngX,m3h2x16(:,832),heltab2x32(:,:,832))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(832),n2h16(832))
  call Hloop_VQ_A(ntryL,G1H32(833),ex1(:),G1H16(1),m3h2x16(:,833),heltab2x32(:,:,833))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(833),n2h16(833))
  call Hloop_VQ_A(ntryL,G1H32(834),ex1(:),G1H16(1),m3h2x16(:,834),heltab2x32(:,:,834))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(834),n2h16(834))
  call Hloop_VQ_A(ntryL,G1H32(835),ex1(:),G1H16(1),m3h2x16(:,835),heltab2x32(:,:,835))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(835),n2h16(835))
  call Hloop_ZQ_A(ntryL,G1H32(836),ex1(:),G1H16(1),ngZl,m3h2x16(:,836),heltab2x32(:,:,836))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(836),n2h16(836))
  call Hloop_VQ_A(ntryL,G1H32(837),ex1(:),G1H16(1),m3h2x16(:,837),heltab2x32(:,:,837))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(837),n2h16(837))
  call Hloop_ZQ_A(ntryL,G1H32(838),ex1(:),G1H16(1),ngZl,m3h2x16(:,838),heltab2x32(:,:,838))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(838),n2h16(838))
  call Hloop_VQ_A(ntryL,G1H32(839),ex1(:),G1H16(1),m3h2x16(:,839),heltab2x32(:,:,839))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(839),n2h16(839))
  call Hloop_VQ_A(ntryL,G1H32(840),ex1(:),G1H16(1),m3h2x16(:,840),heltab2x32(:,:,840))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(840),n2h16(840))
  call Hloop_VQ_A(ntryL,G1H32(841),ex1(:),G1H16(1),m3h2x16(:,841),heltab2x32(:,:,841))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(841),n2h16(841))
  call Hloop_ZQ_A(ntryL,G1H32(842),ex1(:),G1H16(1),ngZl,m3h2x16(:,842),heltab2x32(:,:,842))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(842),n2h16(842))
  call Hloop_VQ_A(ntryL,G1H32(843),ex1(:),G1H16(1),m3h2x16(:,843),heltab2x32(:,:,843))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(843),n2h16(843))
  call Hloop_ZQ_A(ntryL,G1H32(844),ex1(:),G1H16(1),ngZl,m3h2x16(:,844),heltab2x32(:,:,844))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(844),n2h16(844))
  call Hloop_VQ_A(ntryL,G1H32(845),ex1(:),G1H16(1),m3h2x16(:,845),heltab2x32(:,:,845))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(845),n2h16(845))
  call Hloop_VQ_A(ntryL,G1H32(846),ex1(:),G1H16(1),m3h2x16(:,846),heltab2x32(:,:,846))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(846),n2h16(846))
  call Hloop_VQ_A(ntryL,G1H32(847),ex1(:),G1H16(1),m3h2x16(:,847),heltab2x32(:,:,847))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(847),n2h16(847))
  call Hloop_ZQ_A(ntryL,G1H32(848),ex1(:),G1H16(1),ngZl,m3h2x16(:,848),heltab2x32(:,:,848))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(848),n2h16(848))
  call Hloop_VQ_A(ntryL,G1H32(849),ex1(:),G1H16(1),m3h2x16(:,849),heltab2x32(:,:,849))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(849),n2h16(849))
  call Hloop_ZQ_A(ntryL,G1H32(850),ex1(:),G1H16(1),ngZl,m3h2x16(:,850),heltab2x32(:,:,850))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(850),n2h16(850))
  call Hloop_ZQ_A(ntryL,G1H32(851),ex1(:),G1H16(1),ngZl,m3h2x16(:,851),heltab2x32(:,:,851))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(851),n2h16(851))
  call Hloop_SA_Q(ntryL,G1H32(852),ex6(:),G1H16(1),ngH,m3h2x16(:,852),heltab2x32(:,:,852))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(852),n2h16(852))
  call Hloop_SA_Q(ntryL,G1H32(853),ex6(:),G1H16(1),ngX,m3h2x16(:,853),heltab2x32(:,:,853))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(853),n2h16(853))
  call Hloop_SA_Q(ntryL,G1H32(854),ex6(:),G1H16(1),ngH,m3h2x16(:,854),heltab2x32(:,:,854))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(854),n2h16(854))
  call Hloop_SA_Q(ntryL,G1H32(855),ex6(:),G1H16(1),ngX,m3h2x16(:,855),heltab2x32(:,:,855))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(855),n2h16(855))
  call Hloop_VA_Q(ntryL,G1H32(856),ex6(:),G1H16(1),m3h2x16(:,856),heltab2x32(:,:,856))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(856),n2h16(856))
  call Hloop_VA_Q(ntryL,G1H32(857),ex6(:),G1H16(1),m3h2x16(:,857),heltab2x32(:,:,857))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(857),n2h16(857))
  call Hloop_VA_Q(ntryL,G1H32(858),ex6(:),G1H16(1),m3h2x16(:,858),heltab2x32(:,:,858))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(858),n2h16(858))
  call Hloop_VA_Q(ntryL,G1H32(859),ex6(:),G1H16(1),m3h2x16(:,859),heltab2x32(:,:,859))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(859),n2h16(859))
  call Hloop_SA_Q(ntryL,G1H32(860),ex6(:),G1H16(1),ngH,m3h2x16(:,860),heltab2x32(:,:,860))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(860),n2h16(860))
  call Hloop_SA_Q(ntryL,G1H32(861),ex6(:),G1H16(1),ngH,m3h2x16(:,861),heltab2x32(:,:,861))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(861),n2h16(861))
  call Hloop_SA_Q(ntryL,G1H32(862),ex6(:),G1H16(1),ngX,m3h2x16(:,862),heltab2x32(:,:,862))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(862),n2h16(862))
  call Hloop_SA_Q(ntryL,G1H32(863),ex6(:),G1H16(1),ngX,m3h2x16(:,863),heltab2x32(:,:,863))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(863),n2h16(863))
  call Hloop_VA_Q(ntryL,G1H32(864),ex6(:),G1H16(1),m3h2x16(:,864),heltab2x32(:,:,864))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(864),n2h16(864))
  call Hloop_VA_Q(ntryL,G1H32(865),ex6(:),G1H16(1),m3h2x16(:,865),heltab2x32(:,:,865))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(865),n2h16(865))
  call Hloop_VA_Q(ntryL,G1H32(866),ex6(:),G1H16(1),m3h2x16(:,866),heltab2x32(:,:,866))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(866),n2h16(866))
  call Hloop_ZA_Q(ntryL,G1H32(867),ex6(:),G1H16(1),ngZl,m3h2x16(:,867),heltab2x32(:,:,867))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(867),n2h16(867))
  call Hloop_VA_Q(ntryL,G1H32(868),ex6(:),G1H16(1),m3h2x16(:,868),heltab2x32(:,:,868))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(868),n2h16(868))
  call Hloop_ZA_Q(ntryL,G1H32(869),ex6(:),G1H16(1),ngZl,m3h2x16(:,869),heltab2x32(:,:,869))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(869),n2h16(869))
  call Hloop_SA_Q(ntryL,G1H32(870),ex6(:),G1H16(1),ngH,m3h2x16(:,870),heltab2x32(:,:,870))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(870),n2h16(870))
  call Hloop_SA_Q(ntryL,G1H32(871),ex6(:),G1H16(1),ngX,m3h2x16(:,871),heltab2x32(:,:,871))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(871),n2h16(871))
  call Hloop_SA_Q(ntryL,G1H32(872),ex6(:),G1H16(1),ngH,m3h2x16(:,872),heltab2x32(:,:,872))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(872),n2h16(872))
  call Hloop_SA_Q(ntryL,G1H32(873),ex6(:),G1H16(1),ngH,m3h2x16(:,873),heltab2x32(:,:,873))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(873),n2h16(873))
  call Hloop_SA_Q(ntryL,G1H32(874),ex6(:),G1H16(1),ngX,m3h2x16(:,874),heltab2x32(:,:,874))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(874),n2h16(874))
  call Hloop_SA_Q(ntryL,G1H32(875),ex6(:),G1H16(1),ngX,m3h2x16(:,875),heltab2x32(:,:,875))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(875),n2h16(875))
  call Hloop_VA_Q(ntryL,G1H32(876),ex6(:),G1H16(1),m3h2x16(:,876),heltab2x32(:,:,876))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(876),n2h16(876))
  call Hloop_VA_Q(ntryL,G1H32(877),ex6(:),G1H16(1),m3h2x16(:,877),heltab2x32(:,:,877))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(877),n2h16(877))
  call Hloop_ZA_Q(ntryL,G1H32(878),ex6(:),G1H16(1),ngZl,m3h2x16(:,878),heltab2x32(:,:,878))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(878),n2h16(878))
  call Hloop_VA_Q(ntryL,G1H32(879),ex6(:),G1H16(1),m3h2x16(:,879),heltab2x32(:,:,879))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(879),n2h16(879))
  call Hloop_ZA_Q(ntryL,G1H32(880),ex6(:),G1H16(1),ngZl,m3h2x16(:,880),heltab2x32(:,:,880))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(880),n2h16(880))
  call Hloop_VA_Q(ntryL,G1H32(881),ex6(:),G1H16(1),m3h2x16(:,881),heltab2x32(:,:,881))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(881),n2h16(881))
  call Hloop_VA_Q(ntryL,G1H32(882),ex6(:),G1H16(1),m3h2x16(:,882),heltab2x32(:,:,882))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(882),n2h16(882))
  call Hloop_VA_Q(ntryL,G1H32(883),ex6(:),G1H16(1),m3h2x16(:,883),heltab2x32(:,:,883))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(883),n2h16(883))
  call Hloop_ZA_Q(ntryL,G1H32(884),ex6(:),G1H16(1),ngZl,m3h2x16(:,884),heltab2x32(:,:,884))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(884),n2h16(884))
  call Hloop_VA_Q(ntryL,G1H32(885),ex6(:),G1H16(1),m3h2x16(:,885),heltab2x32(:,:,885))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(885),n2h16(885))
  call Hloop_ZA_Q(ntryL,G1H32(886),ex6(:),G1H16(1),ngZl,m3h2x16(:,886),heltab2x32(:,:,886))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(886),n2h16(886))
  call Hloop_VA_Q(ntryL,G1H32(887),ex6(:),G1H16(1),m3h2x16(:,887),heltab2x32(:,:,887))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(887),n2h16(887))
  call Hloop_ZA_Q(ntryL,G1H32(888),ex6(:),G1H16(1),ngZl,m3h2x16(:,888),heltab2x32(:,:,888))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(888),n2h16(888))
  call Hloop_VA_Q(ntryL,G1H32(889),ex4(:),G1H16(1),m3h2x16(:,889),heltab2x32(:,:,889))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(889),n2h16(889))
  call Hloop_VA_Q(ntryL,G1H32(890),ex4(:),G1H16(1),m3h2x16(:,890),heltab2x32(:,:,890))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(890),n2h16(890))
  call Hloop_VA_Q(ntryL,G1H32(891),ex4(:),G1H16(1),m3h2x16(:,891),heltab2x32(:,:,891))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(891),n2h16(891))
  call Hloop_VA_Q(ntryL,G1H32(892),ex4(:),G1H16(1),m3h2x16(:,892),heltab2x32(:,:,892))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(892),n2h16(892))
  call Hloop_SA_Q(ntryL,G1H32(893),ex4(:),G1H16(1),ngH,m3h2x16(:,893),heltab2x32(:,:,893))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(893),n2h16(893))
  call Hloop_SA_Q(ntryL,G1H32(894),ex4(:),G1H16(1),ngX,m3h2x16(:,894),heltab2x32(:,:,894))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(894),n2h16(894))
  call Hloop_SA_Q(ntryL,G1H32(895),ex4(:),G1H16(1),ngH,m3h2x16(:,895),heltab2x32(:,:,895))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(895),n2h16(895))
  call Hloop_SA_Q(ntryL,G1H32(896),ex4(:),G1H16(1),ngX,m3h2x16(:,896),heltab2x32(:,:,896))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(896),n2h16(896))
  call Hloop_SA_Q(ntryL,G1H32(897),ex4(:),G1H16(1),ngH,m3h2x16(:,897),heltab2x32(:,:,897))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(897),n2h16(897))
  call Hloop_SA_Q(ntryL,G1H32(898),ex4(:),G1H16(1),ngX,m3h2x16(:,898),heltab2x32(:,:,898))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(898),n2h16(898))
  call Hloop_SA_Q(ntryL,G1H32(899),ex4(:),G1H16(1),ngH,m3h2x16(:,899),heltab2x32(:,:,899))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(899),n2h16(899))
  call Hloop_SA_Q(ntryL,G1H32(900),ex4(:),G1H16(1),ngX,m3h2x16(:,900),heltab2x32(:,:,900))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(900),n2h16(900))
  call Hloop_VA_Q(ntryL,G1H32(901),ex4(:),G1H16(1),m3h2x16(:,901),heltab2x32(:,:,901))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(901),n2h16(901))
  call Hloop_VA_Q(ntryL,G1H32(902),ex4(:),G1H16(1),m3h2x16(:,902),heltab2x32(:,:,902))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(902),n2h16(902))
  call Hloop_ZA_Q(ntryL,G1H32(903),ex4(:),G1H16(1),ngZl,m3h2x16(:,903),heltab2x32(:,:,903))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(903),n2h16(903))
  call Hloop_VA_Q(ntryL,G1H32(904),ex4(:),G1H16(1),m3h2x16(:,904),heltab2x32(:,:,904))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(904),n2h16(904))
  call Hloop_ZA_Q(ntryL,G1H32(905),ex4(:),G1H16(1),ngZl,m3h2x16(:,905),heltab2x32(:,:,905))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(905),n2h16(905))
  call Hloop_VA_Q(ntryL,G1H32(906),ex4(:),G1H16(1),m3h2x16(:,906),heltab2x32(:,:,906))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(906),n2h16(906))
  call Hloop_VA_Q(ntryL,G1H32(907),ex4(:),G1H16(1),m3h2x16(:,907),heltab2x32(:,:,907))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(907),n2h16(907))
  call Hloop_VA_Q(ntryL,G1H32(908),ex4(:),G1H16(1),m3h2x16(:,908),heltab2x32(:,:,908))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(908),n2h16(908))
  call Hloop_ZA_Q(ntryL,G1H32(909),ex4(:),G1H16(1),ngZl,m3h2x16(:,909),heltab2x32(:,:,909))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(909),n2h16(909))
  call Hloop_VA_Q(ntryL,G1H32(910),ex4(:),G1H16(1),m3h2x16(:,910),heltab2x32(:,:,910))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(910),n2h16(910))
  call Hloop_ZA_Q(ntryL,G1H32(911),ex4(:),G1H16(1),ngZl,m3h2x16(:,911),heltab2x32(:,:,911))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(911),n2h16(911))
  call Hloop_VA_Q(ntryL,G1H32(912),ex4(:),G1H16(1),m3h2x16(:,912),heltab2x32(:,:,912))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(912),n2h16(912))
  call Hloop_SA_Q(ntryL,G1H32(913),ex4(:),G1H16(1),ngH,m3h2x16(:,913),heltab2x32(:,:,913))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(913),n2h16(913))
  call Hloop_SA_Q(ntryL,G1H32(914),ex4(:),G1H16(1),ngX,m3h2x16(:,914),heltab2x32(:,:,914))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(914),n2h16(914))
  call Hloop_SA_Q(ntryL,G1H32(915),ex4(:),G1H16(1),ngH,m3h2x16(:,915),heltab2x32(:,:,915))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(915),n2h16(915))
  call Hloop_SA_Q(ntryL,G1H32(916),ex4(:),G1H16(1),ngH,m3h2x16(:,916),heltab2x32(:,:,916))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(916),n2h16(916))
  call Hloop_SA_Q(ntryL,G1H32(917),ex4(:),G1H16(1),ngX,m3h2x16(:,917),heltab2x32(:,:,917))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(917),n2h16(917))
  call Hloop_SA_Q(ntryL,G1H32(918),ex4(:),G1H16(1),ngX,m3h2x16(:,918),heltab2x32(:,:,918))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(918),n2h16(918))
  call Hloop_VA_Q(ntryL,G1H32(919),ex4(:),G1H16(1),m3h2x16(:,919),heltab2x32(:,:,919))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(919),n2h16(919))
  call Hloop_ZA_Q(ntryL,G1H32(920),ex4(:),G1H16(1),ngZl,m3h2x16(:,920),heltab2x32(:,:,920))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(920),n2h16(920))
  call Hloop_VA_Q(ntryL,G1H32(921),ex4(:),G1H16(1),m3h2x16(:,921),heltab2x32(:,:,921))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(921),n2h16(921))
  call Hloop_VA_Q(ntryL,G1H32(922),ex4(:),G1H16(1),m3h2x16(:,922),heltab2x32(:,:,922))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(922),n2h16(922))
  call Hloop_ZA_Q(ntryL,G1H32(923),ex4(:),G1H16(1),ngZl,m3h2x16(:,923),heltab2x32(:,:,923))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(923),n2h16(923))
  call Hloop_ZA_Q(ntryL,G1H32(924),ex4(:),G1H16(1),ngZl,m3h2x16(:,924),heltab2x32(:,:,924))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(924),n2h16(924))
  call Hloop_VA_Q(ntryL,G1H32(925),ex4(:),G1H16(1),m3h2x16(:,925),heltab2x32(:,:,925))
  call Hloop_A_Q(ntryL,G1H16(1),88,nME,G2H16(925),n2h16(925))
  call Hloop_SA_Q(ntryL,G1H32(926),ex3(:),G1H16(1),ngH,m3h2x16(:,926),heltab2x32(:,:,926))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(926),n2h16(926))
  call Hloop_SA_Q(ntryL,G1H32(927),ex3(:),G1H16(1),ngX,m3h2x16(:,927),heltab2x32(:,:,927))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(927),n2h16(927))
  call Hloop_SA_Q(ntryL,G1H32(928),ex3(:),G1H16(1),ngH,m3h2x16(:,928),heltab2x32(:,:,928))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(928),n2h16(928))
  call Hloop_SA_Q(ntryL,G1H32(929),ex3(:),G1H16(1),ngX,m3h2x16(:,929),heltab2x32(:,:,929))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(929),n2h16(929))
  call Hloop_VA_Q(ntryL,G1H32(930),ex3(:),G1H16(1),m3h2x16(:,930),heltab2x32(:,:,930))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(930),n2h16(930))
  call Hloop_VA_Q(ntryL,G1H32(931),ex3(:),G1H16(1),m3h2x16(:,931),heltab2x32(:,:,931))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(931),n2h16(931))
  call Hloop_VA_Q(ntryL,G1H32(932),ex3(:),G1H16(1),m3h2x16(:,932),heltab2x32(:,:,932))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(932),n2h16(932))
  call Hloop_VA_Q(ntryL,G1H32(933),ex3(:),G1H16(1),m3h2x16(:,933),heltab2x32(:,:,933))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(933),n2h16(933))
  call Hloop_SA_Q(ntryL,G1H32(934),ex3(:),G1H16(1),ngH,m3h2x16(:,934),heltab2x32(:,:,934))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(934),n2h16(934))
  call Hloop_SA_Q(ntryL,G1H32(935),ex3(:),G1H16(1),ngH,m3h2x16(:,935),heltab2x32(:,:,935))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(935),n2h16(935))
  call Hloop_SA_Q(ntryL,G1H32(936),ex3(:),G1H16(1),ngX,m3h2x16(:,936),heltab2x32(:,:,936))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(936),n2h16(936))
  call Hloop_SA_Q(ntryL,G1H32(937),ex3(:),G1H16(1),ngX,m3h2x16(:,937),heltab2x32(:,:,937))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(937),n2h16(937))
  call Hloop_VA_Q(ntryL,G1H32(938),ex3(:),G1H16(1),m3h2x16(:,938),heltab2x32(:,:,938))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(938),n2h16(938))
  call Hloop_VA_Q(ntryL,G1H32(939),ex3(:),G1H16(1),m3h2x16(:,939),heltab2x32(:,:,939))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(939),n2h16(939))
  call Hloop_VA_Q(ntryL,G1H32(940),ex3(:),G1H16(1),m3h2x16(:,940),heltab2x32(:,:,940))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(940),n2h16(940))
  call Hloop_ZA_Q(ntryL,G1H32(941),ex3(:),G1H16(1),ngZl,m3h2x16(:,941),heltab2x32(:,:,941))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(941),n2h16(941))
  call Hloop_VA_Q(ntryL,G1H32(942),ex3(:),G1H16(1),m3h2x16(:,942),heltab2x32(:,:,942))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(942),n2h16(942))
  call Hloop_ZA_Q(ntryL,G1H32(943),ex3(:),G1H16(1),ngZl,m3h2x16(:,943),heltab2x32(:,:,943))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(943),n2h16(943))
  call Hloop_SA_Q(ntryL,G1H32(944),ex3(:),G1H16(1),ngH,m3h2x16(:,944),heltab2x32(:,:,944))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(944),n2h16(944))
  call Hloop_SA_Q(ntryL,G1H32(945),ex3(:),G1H16(1),ngX,m3h2x16(:,945),heltab2x32(:,:,945))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(945),n2h16(945))
  call Hloop_SA_Q(ntryL,G1H32(946),ex3(:),G1H16(1),ngH,m3h2x16(:,946),heltab2x32(:,:,946))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(946),n2h16(946))
  call Hloop_SA_Q(ntryL,G1H32(947),ex3(:),G1H16(1),ngH,m3h2x16(:,947),heltab2x32(:,:,947))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(947),n2h16(947))
  call Hloop_SA_Q(ntryL,G1H32(948),ex3(:),G1H16(1),ngX,m3h2x16(:,948),heltab2x32(:,:,948))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(948),n2h16(948))
  call Hloop_SA_Q(ntryL,G1H32(949),ex3(:),G1H16(1),ngX,m3h2x16(:,949),heltab2x32(:,:,949))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(949),n2h16(949))
  call Hloop_VA_Q(ntryL,G1H32(950),ex3(:),G1H16(1),m3h2x16(:,950),heltab2x32(:,:,950))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(950),n2h16(950))
  call Hloop_VA_Q(ntryL,G1H32(951),ex3(:),G1H16(1),m3h2x16(:,951),heltab2x32(:,:,951))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(951),n2h16(951))
  call Hloop_ZA_Q(ntryL,G1H32(952),ex3(:),G1H16(1),ngZl,m3h2x16(:,952),heltab2x32(:,:,952))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(952),n2h16(952))
  call Hloop_VA_Q(ntryL,G1H32(953),ex3(:),G1H16(1),m3h2x16(:,953),heltab2x32(:,:,953))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(953),n2h16(953))
  call Hloop_ZA_Q(ntryL,G1H32(954),ex3(:),G1H16(1),ngZl,m3h2x16(:,954),heltab2x32(:,:,954))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(954),n2h16(954))
  call Hloop_VA_Q(ntryL,G1H32(955),ex3(:),G1H16(1),m3h2x16(:,955),heltab2x32(:,:,955))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(955),n2h16(955))
  call Hloop_VA_Q(ntryL,G1H32(956),ex3(:),G1H16(1),m3h2x16(:,956),heltab2x32(:,:,956))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(956),n2h16(956))
  call Hloop_VA_Q(ntryL,G1H32(957),ex3(:),G1H16(1),m3h2x16(:,957),heltab2x32(:,:,957))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(957),n2h16(957))
  call Hloop_ZA_Q(ntryL,G1H32(958),ex3(:),G1H16(1),ngZl,m3h2x16(:,958),heltab2x32(:,:,958))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(958),n2h16(958))
  call Hloop_VA_Q(ntryL,G1H32(959),ex3(:),G1H16(1),m3h2x16(:,959),heltab2x32(:,:,959))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(959),n2h16(959))
  call Hloop_ZA_Q(ntryL,G1H32(960),ex3(:),G1H16(1),ngZl,m3h2x16(:,960),heltab2x32(:,:,960))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(960),n2h16(960))
  call Hloop_VA_Q(ntryL,G1H32(961),ex3(:),G1H16(1),m3h2x16(:,961),heltab2x32(:,:,961))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(961),n2h16(961))
  call Hloop_ZA_Q(ntryL,G1H32(962),ex3(:),G1H16(1),ngZl,m3h2x16(:,962),heltab2x32(:,:,962))
  call Hloop_A_Q(ntryL,G1H16(1),70,nME,G2H16(962),n2h16(962))
  call Hloop_SQ_A(ntryL,G1H32(963),ex2(:),G1H16(1),ngH,m3h2x16(:,963),heltab2x32(:,:,963))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(963),n2h16(963))
  call Hloop_SQ_A(ntryL,G1H32(964),ex2(:),G1H16(1),ngX,m3h2x16(:,964),heltab2x32(:,:,964))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(964),n2h16(964))
  call Hloop_SQ_A(ntryL,G1H32(965),ex2(:),G1H16(1),ngH,m3h2x16(:,965),heltab2x32(:,:,965))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(965),n2h16(965))
  call Hloop_SQ_A(ntryL,G1H32(966),ex2(:),G1H16(1),ngX,m3h2x16(:,966),heltab2x32(:,:,966))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(966),n2h16(966))
  call Hloop_VQ_A(ntryL,G1H32(967),ex2(:),G1H16(1),m3h2x16(:,967),heltab2x32(:,:,967))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(967),n2h16(967))
  call Hloop_VQ_A(ntryL,G1H32(968),ex2(:),G1H16(1),m3h2x16(:,968),heltab2x32(:,:,968))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(968),n2h16(968))
  call Hloop_VQ_A(ntryL,G1H32(969),ex2(:),G1H16(1),m3h2x16(:,969),heltab2x32(:,:,969))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(969),n2h16(969))
  call Hloop_VQ_A(ntryL,G1H32(970),ex2(:),G1H16(1),m3h2x16(:,970),heltab2x32(:,:,970))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(970),n2h16(970))
  call Hloop_SQ_A(ntryL,G1H32(971),ex2(:),G1H16(1),ngH,m3h2x16(:,971),heltab2x32(:,:,971))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(971),n2h16(971))
  call Hloop_SQ_A(ntryL,G1H32(972),ex2(:),G1H16(1),ngH,m3h2x16(:,972),heltab2x32(:,:,972))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(972),n2h16(972))
  call Hloop_SQ_A(ntryL,G1H32(973),ex2(:),G1H16(1),ngX,m3h2x16(:,973),heltab2x32(:,:,973))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(973),n2h16(973))
  call Hloop_SQ_A(ntryL,G1H32(974),ex2(:),G1H16(1),ngX,m3h2x16(:,974),heltab2x32(:,:,974))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(974),n2h16(974))
  call Hloop_VQ_A(ntryL,G1H32(975),ex2(:),G1H16(1),m3h2x16(:,975),heltab2x32(:,:,975))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(975),n2h16(975))
  call Hloop_VQ_A(ntryL,G1H32(976),ex2(:),G1H16(1),m3h2x16(:,976),heltab2x32(:,:,976))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(976),n2h16(976))
  call Hloop_VQ_A(ntryL,G1H32(977),ex2(:),G1H16(1),m3h2x16(:,977),heltab2x32(:,:,977))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(977),n2h16(977))
  call Hloop_ZQ_A(ntryL,G1H32(978),ex2(:),G1H16(1),ngZl,m3h2x16(:,978),heltab2x32(:,:,978))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(978),n2h16(978))
  call Hloop_VQ_A(ntryL,G1H32(979),ex2(:),G1H16(1),m3h2x16(:,979),heltab2x32(:,:,979))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(979),n2h16(979))
  call Hloop_ZQ_A(ntryL,G1H32(980),ex2(:),G1H16(1),ngZl,m3h2x16(:,980),heltab2x32(:,:,980))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(980),n2h16(980))
  call Hloop_SQ_A(ntryL,G1H32(981),ex2(:),G1H16(1),ngH,m3h2x16(:,981),heltab2x32(:,:,981))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(981),n2h16(981))
  call Hloop_SQ_A(ntryL,G1H32(982),ex2(:),G1H16(1),ngX,m3h2x16(:,982),heltab2x32(:,:,982))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(982),n2h16(982))
  call Hloop_SQ_A(ntryL,G1H32(983),ex2(:),G1H16(1),ngH,m3h2x16(:,983),heltab2x32(:,:,983))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(983),n2h16(983))
  call Hloop_SQ_A(ntryL,G1H32(984),ex2(:),G1H16(1),ngH,m3h2x16(:,984),heltab2x32(:,:,984))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(984),n2h16(984))
  call Hloop_SQ_A(ntryL,G1H32(985),ex2(:),G1H16(1),ngX,m3h2x16(:,985),heltab2x32(:,:,985))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(985),n2h16(985))
  call Hloop_SQ_A(ntryL,G1H32(986),ex2(:),G1H16(1),ngX,m3h2x16(:,986),heltab2x32(:,:,986))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(986),n2h16(986))
  call Hloop_VQ_A(ntryL,G1H32(987),ex2(:),G1H16(1),m3h2x16(:,987),heltab2x32(:,:,987))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(987),n2h16(987))
  call Hloop_VQ_A(ntryL,G1H32(988),ex2(:),G1H16(1),m3h2x16(:,988),heltab2x32(:,:,988))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(988),n2h16(988))
  call Hloop_ZQ_A(ntryL,G1H32(989),ex2(:),G1H16(1),ngZl,m3h2x16(:,989),heltab2x32(:,:,989))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(989),n2h16(989))
  call Hloop_VQ_A(ntryL,G1H32(990),ex2(:),G1H16(1),m3h2x16(:,990),heltab2x32(:,:,990))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(990),n2h16(990))
  call Hloop_ZQ_A(ntryL,G1H32(991),ex2(:),G1H16(1),ngZl,m3h2x16(:,991),heltab2x32(:,:,991))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(991),n2h16(991))
  call Hloop_VQ_A(ntryL,G1H32(992),ex2(:),G1H16(1),m3h2x16(:,992),heltab2x32(:,:,992))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(992),n2h16(992))
  call Hloop_VQ_A(ntryL,G1H32(993),ex2(:),G1H16(1),m3h2x16(:,993),heltab2x32(:,:,993))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(993),n2h16(993))
  call Hloop_VQ_A(ntryL,G1H32(994),ex2(:),G1H16(1),m3h2x16(:,994),heltab2x32(:,:,994))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(994),n2h16(994))
  call Hloop_ZQ_A(ntryL,G1H32(995),ex2(:),G1H16(1),ngZl,m3h2x16(:,995),heltab2x32(:,:,995))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(995),n2h16(995))
  call Hloop_VQ_A(ntryL,G1H32(996),ex2(:),G1H16(1),m3h2x16(:,996),heltab2x32(:,:,996))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(996),n2h16(996))
  call Hloop_ZQ_A(ntryL,G1H32(997),ex2(:),G1H16(1),ngZl,m3h2x16(:,997),heltab2x32(:,:,997))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(997),n2h16(997))
  call Hloop_VQ_A(ntryL,G1H32(998),ex2(:),G1H16(1),m3h2x16(:,998),heltab2x32(:,:,998))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(998),n2h16(998))
  call Hloop_ZQ_A(ntryL,G1H32(999),ex2(:),G1H16(1),ngZl,m3h2x16(:,999),heltab2x32(:,:,999))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(999),n2h16(999))
  call Hloop_SQ_A(ntryL,G1H32(1000),ex5(:),G1H16(1),ngH,m3h2x16(:,1000),heltab2x32(:,:,1000))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1000),n2h16(1000))
  call Hloop_SQ_A(ntryL,G1H32(1001),ex5(:),G1H16(1),ngX,m3h2x16(:,1001),heltab2x32(:,:,1001))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1001),n2h16(1001))
  call Hloop_SQ_A(ntryL,G1H32(1002),ex5(:),G1H16(1),ngH,m3h2x16(:,1002),heltab2x32(:,:,1002))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1002),n2h16(1002))
  call Hloop_SQ_A(ntryL,G1H32(1003),ex5(:),G1H16(1),ngX,m3h2x16(:,1003),heltab2x32(:,:,1003))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1003),n2h16(1003))
  call Hloop_VQ_A(ntryL,G1H32(1004),ex5(:),G1H16(1),m3h2x16(:,1004),heltab2x32(:,:,1004))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1004),n2h16(1004))
  call Hloop_VQ_A(ntryL,G1H32(1005),ex5(:),G1H16(1),m3h2x16(:,1005),heltab2x32(:,:,1005))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1005),n2h16(1005))
  call Hloop_VQ_A(ntryL,G1H32(1006),ex5(:),G1H16(1),m3h2x16(:,1006),heltab2x32(:,:,1006))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1006),n2h16(1006))
  call Hloop_VQ_A(ntryL,G1H32(1007),ex5(:),G1H16(1),m3h2x16(:,1007),heltab2x32(:,:,1007))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1007),n2h16(1007))
  call Hloop_SQ_A(ntryL,G1H32(1008),ex5(:),G1H16(1),ngH,m3h2x16(:,1008),heltab2x32(:,:,1008))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1008),n2h16(1008))
  call Hloop_SQ_A(ntryL,G1H32(1009),ex5(:),G1H16(1),ngH,m3h2x16(:,1009),heltab2x32(:,:,1009))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1009),n2h16(1009))
  call Hloop_SQ_A(ntryL,G1H32(1010),ex5(:),G1H16(1),ngX,m3h2x16(:,1010),heltab2x32(:,:,1010))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1010),n2h16(1010))
  call Hloop_SQ_A(ntryL,G1H32(1011),ex5(:),G1H16(1),ngX,m3h2x16(:,1011),heltab2x32(:,:,1011))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1011),n2h16(1011))
  call Hloop_VQ_A(ntryL,G1H32(1012),ex5(:),G1H16(1),m3h2x16(:,1012),heltab2x32(:,:,1012))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1012),n2h16(1012))
  call Hloop_VQ_A(ntryL,G1H32(1013),ex5(:),G1H16(1),m3h2x16(:,1013),heltab2x32(:,:,1013))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1013),n2h16(1013))
  call Hloop_VQ_A(ntryL,G1H32(1014),ex5(:),G1H16(1),m3h2x16(:,1014),heltab2x32(:,:,1014))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1014),n2h16(1014))
  call Hloop_ZQ_A(ntryL,G1H32(1015),ex5(:),G1H16(1),ngZl,m3h2x16(:,1015),heltab2x32(:,:,1015))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1015),n2h16(1015))
  call Hloop_VQ_A(ntryL,G1H32(1016),ex5(:),G1H16(1),m3h2x16(:,1016),heltab2x32(:,:,1016))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1016),n2h16(1016))
  call Hloop_ZQ_A(ntryL,G1H32(1017),ex5(:),G1H16(1),ngZl,m3h2x16(:,1017),heltab2x32(:,:,1017))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1017),n2h16(1017))
  call Hloop_SQ_A(ntryL,G1H32(1018),ex5(:),G1H16(1),ngH,m3h2x16(:,1018),heltab2x32(:,:,1018))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1018),n2h16(1018))
  call Hloop_SQ_A(ntryL,G1H32(1019),ex5(:),G1H16(1),ngX,m3h2x16(:,1019),heltab2x32(:,:,1019))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1019),n2h16(1019))
  call Hloop_SQ_A(ntryL,G1H32(1020),ex5(:),G1H16(1),ngH,m3h2x16(:,1020),heltab2x32(:,:,1020))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1020),n2h16(1020))
  call Hloop_SQ_A(ntryL,G1H32(1021),ex5(:),G1H16(1),ngH,m3h2x16(:,1021),heltab2x32(:,:,1021))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1021),n2h16(1021))
  call Hloop_SQ_A(ntryL,G1H32(1022),ex5(:),G1H16(1),ngX,m3h2x16(:,1022),heltab2x32(:,:,1022))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1022),n2h16(1022))
  call Hloop_SQ_A(ntryL,G1H32(1023),ex5(:),G1H16(1),ngX,m3h2x16(:,1023),heltab2x32(:,:,1023))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1023),n2h16(1023))
  call Hloop_VQ_A(ntryL,G1H32(1024),ex5(:),G1H16(1),m3h2x16(:,1024),heltab2x32(:,:,1024))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1024),n2h16(1024))
  call Hloop_VQ_A(ntryL,G1H32(1025),ex5(:),G1H16(1),m3h2x16(:,1025),heltab2x32(:,:,1025))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1025),n2h16(1025))
  call Hloop_ZQ_A(ntryL,G1H32(1026),ex5(:),G1H16(1),ngZl,m3h2x16(:,1026),heltab2x32(:,:,1026))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1026),n2h16(1026))
  call Hloop_VQ_A(ntryL,G1H32(1027),ex5(:),G1H16(1),m3h2x16(:,1027),heltab2x32(:,:,1027))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1027),n2h16(1027))
  call Hloop_ZQ_A(ntryL,G1H32(1028),ex5(:),G1H16(1),ngZl,m3h2x16(:,1028),heltab2x32(:,:,1028))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1028),n2h16(1028))
  call Hloop_VQ_A(ntryL,G1H32(1029),ex5(:),G1H16(1),m3h2x16(:,1029),heltab2x32(:,:,1029))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1029),n2h16(1029))
  call Hloop_VQ_A(ntryL,G1H32(1030),ex5(:),G1H16(1),m3h2x16(:,1030),heltab2x32(:,:,1030))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1030),n2h16(1030))
  call Hloop_VQ_A(ntryL,G1H32(1031),ex5(:),G1H16(1),m3h2x16(:,1031),heltab2x32(:,:,1031))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1031),n2h16(1031))
  call Hloop_ZQ_A(ntryL,G1H32(1032),ex5(:),G1H16(1),ngZl,m3h2x16(:,1032),heltab2x32(:,:,1032))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1032),n2h16(1032))
  call Hloop_VQ_A(ntryL,G1H32(1033),ex5(:),G1H16(1),m3h2x16(:,1033),heltab2x32(:,:,1033))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1033),n2h16(1033))
  call Hloop_ZQ_A(ntryL,G1H32(1034),ex5(:),G1H16(1),ngZl,m3h2x16(:,1034),heltab2x32(:,:,1034))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1034),n2h16(1034))
  call Hloop_VQ_A(ntryL,G1H32(1035),ex5(:),G1H16(1),m3h2x16(:,1035),heltab2x32(:,:,1035))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1035),n2h16(1035))
  call Hloop_ZQ_A(ntryL,G1H32(1036),ex5(:),G1H16(1),ngZl,m3h2x16(:,1036),heltab2x32(:,:,1036))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1036),n2h16(1036))
  call Hloop_SA_Q(ntryL,G1H32(1037),ex3(:),G1H16(1),ngH,m3h2x16(:,1037),heltab2x32(:,:,1037))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1037),n2h16(1037))
  call Hloop_SA_Q(ntryL,G1H32(1038),ex3(:),G1H16(1),ngH,m3h2x16(:,1038),heltab2x32(:,:,1038))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1038),n2h16(1038))
  call Hloop_SA_Q(ntryL,G1H32(1039),ex3(:),G1H16(1),ngX,m3h2x16(:,1039),heltab2x32(:,:,1039))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1039),n2h16(1039))
  call Hloop_SA_Q(ntryL,G1H32(1040),ex3(:),G1H16(1),ngX,m3h2x16(:,1040),heltab2x32(:,:,1040))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1040),n2h16(1040))
  call Hloop_SA_Q(ntryL,G1H32(1041),ex3(:),G1H16(1),ngH,m3h2x16(:,1041),heltab2x32(:,:,1041))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1041),n2h16(1041))
  call Hloop_SA_Q(ntryL,G1H32(1042),ex3(:),G1H16(1),ngH,m3h2x16(:,1042),heltab2x32(:,:,1042))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1042),n2h16(1042))
  call Hloop_SA_Q(ntryL,G1H32(1043),ex3(:),G1H16(1),ngX,m3h2x16(:,1043),heltab2x32(:,:,1043))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1043),n2h16(1043))
  call Hloop_SA_Q(ntryL,G1H32(1044),ex3(:),G1H16(1),ngX,m3h2x16(:,1044),heltab2x32(:,:,1044))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1044),n2h16(1044))
  call Hloop_VA_Q(ntryL,G1H32(1045),ex3(:),G1H16(1),m3h2x16(:,1045),heltab2x32(:,:,1045))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1045),n2h16(1045))
  call Hloop_VA_Q(ntryL,G1H32(1046),ex3(:),G1H16(1),m3h2x16(:,1046),heltab2x32(:,:,1046))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1046),n2h16(1046))
  call Hloop_VA_Q(ntryL,G1H32(1047),ex3(:),G1H16(1),m3h2x16(:,1047),heltab2x32(:,:,1047))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1047),n2h16(1047))
  call Hloop_VA_Q(ntryL,G1H32(1048),ex3(:),G1H16(1),m3h2x16(:,1048),heltab2x32(:,:,1048))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1048),n2h16(1048))
  call Hloop_SA_Q(ntryL,G1H32(1049),ex3(:),G1H16(1),ngH,m3h2x16(:,1049),heltab2x32(:,:,1049))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1049),n2h16(1049))
  call Hloop_SA_Q(ntryL,G1H32(1050),ex3(:),G1H16(1),ngX,m3h2x16(:,1050),heltab2x32(:,:,1050))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1050),n2h16(1050))
  call Hloop_SA_Q(ntryL,G1H32(1051),ex3(:),G1H16(1),ngH,m3h2x16(:,1051),heltab2x32(:,:,1051))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1051),n2h16(1051))
  call Hloop_SA_Q(ntryL,G1H32(1052),ex3(:),G1H16(1),ngH,m3h2x16(:,1052),heltab2x32(:,:,1052))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1052),n2h16(1052))
  call Hloop_SA_Q(ntryL,G1H32(1053),ex3(:),G1H16(1),ngX,m3h2x16(:,1053),heltab2x32(:,:,1053))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1053),n2h16(1053))
  call Hloop_SA_Q(ntryL,G1H32(1054),ex3(:),G1H16(1),ngX,m3h2x16(:,1054),heltab2x32(:,:,1054))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1054),n2h16(1054))
  call Hloop_VA_Q(ntryL,G1H32(1055),ex3(:),G1H16(1),m3h2x16(:,1055),heltab2x32(:,:,1055))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1055),n2h16(1055))
  call Hloop_VA_Q(ntryL,G1H32(1056),ex3(:),G1H16(1),m3h2x16(:,1056),heltab2x32(:,:,1056))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1056),n2h16(1056))
  call Hloop_VA_Q(ntryL,G1H32(1057),ex3(:),G1H16(1),m3h2x16(:,1057),heltab2x32(:,:,1057))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1057),n2h16(1057))
  call Hloop_ZA_Q(ntryL,G1H32(1058),ex3(:),G1H16(1),ngZl,m3h2x16(:,1058),heltab2x32(:,:,1058))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1058),n2h16(1058))
  call Hloop_VA_Q(ntryL,G1H32(1059),ex3(:),G1H16(1),m3h2x16(:,1059),heltab2x32(:,:,1059))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1059),n2h16(1059))
  call Hloop_ZA_Q(ntryL,G1H32(1060),ex3(:),G1H16(1),ngZl,m3h2x16(:,1060),heltab2x32(:,:,1060))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1060),n2h16(1060))
  call Hloop_VA_Q(ntryL,G1H32(1061),ex3(:),G1H16(1),m3h2x16(:,1061),heltab2x32(:,:,1061))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1061),n2h16(1061))
  call Hloop_VA_Q(ntryL,G1H32(1062),ex3(:),G1H16(1),m3h2x16(:,1062),heltab2x32(:,:,1062))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1062),n2h16(1062))
  call Hloop_VA_Q(ntryL,G1H32(1063),ex3(:),G1H16(1),m3h2x16(:,1063),heltab2x32(:,:,1063))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1063),n2h16(1063))
  call Hloop_ZA_Q(ntryL,G1H32(1064),ex3(:),G1H16(1),ngZl,m3h2x16(:,1064),heltab2x32(:,:,1064))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1064),n2h16(1064))
  call Hloop_VA_Q(ntryL,G1H32(1065),ex3(:),G1H16(1),m3h2x16(:,1065),heltab2x32(:,:,1065))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1065),n2h16(1065))
  call Hloop_ZA_Q(ntryL,G1H32(1066),ex3(:),G1H16(1),ngZl,m3h2x16(:,1066),heltab2x32(:,:,1066))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1066),n2h16(1066))
  call Hloop_VA_Q(ntryL,G1H32(1067),ex3(:),G1H16(1),m3h2x16(:,1067),heltab2x32(:,:,1067))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1067),n2h16(1067))
  call Hloop_VA_Q(ntryL,G1H32(1068),ex3(:),G1H16(1),m3h2x16(:,1068),heltab2x32(:,:,1068))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1068),n2h16(1068))
  call Hloop_VA_Q(ntryL,G1H32(1069),ex3(:),G1H16(1),m3h2x16(:,1069),heltab2x32(:,:,1069))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1069),n2h16(1069))
  call Hloop_ZA_Q(ntryL,G1H32(1070),ex3(:),G1H16(1),ngZl,m3h2x16(:,1070),heltab2x32(:,:,1070))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1070),n2h16(1070))
  call Hloop_VA_Q(ntryL,G1H32(1071),ex3(:),G1H16(1),m3h2x16(:,1071),heltab2x32(:,:,1071))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1071),n2h16(1071))
  call Hloop_ZA_Q(ntryL,G1H32(1072),ex3(:),G1H16(1),ngZl,m3h2x16(:,1072),heltab2x32(:,:,1072))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1072),n2h16(1072))
  call Hloop_ZA_Q(ntryL,G1H32(1073),ex3(:),G1H16(1),ngZl,m3h2x16(:,1073),heltab2x32(:,:,1073))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1073),n2h16(1073))
  call Hloop_SA_Q(ntryL,G1H32(1074),ex3(:),G1H16(1),ngH,m3h2x16(:,1074),heltab2x32(:,:,1074))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1074),n2h16(1074))
  call Hloop_SA_Q(ntryL,G1H32(1075),ex3(:),G1H16(1),ngH,m3h2x16(:,1075),heltab2x32(:,:,1075))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1075),n2h16(1075))
  call Hloop_SA_Q(ntryL,G1H32(1076),ex3(:),G1H16(1),ngX,m3h2x16(:,1076),heltab2x32(:,:,1076))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1076),n2h16(1076))
  call Hloop_SA_Q(ntryL,G1H32(1077),ex3(:),G1H16(1),ngX,m3h2x16(:,1077),heltab2x32(:,:,1077))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1077),n2h16(1077))
  call Hloop_SA_Q(ntryL,G1H32(1078),ex3(:),G1H16(1),ngH,m3h2x16(:,1078),heltab2x32(:,:,1078))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1078),n2h16(1078))
  call Hloop_SA_Q(ntryL,G1H32(1079),ex3(:),G1H16(1),ngH,m3h2x16(:,1079),heltab2x32(:,:,1079))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1079),n2h16(1079))
  call Hloop_SA_Q(ntryL,G1H32(1080),ex3(:),G1H16(1),ngX,m3h2x16(:,1080),heltab2x32(:,:,1080))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1080),n2h16(1080))
  call Hloop_SA_Q(ntryL,G1H32(1081),ex3(:),G1H16(1),ngX,m3h2x16(:,1081),heltab2x32(:,:,1081))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1081),n2h16(1081))
  call Hloop_VA_Q(ntryL,G1H32(1082),ex3(:),G1H16(1),m3h2x16(:,1082),heltab2x32(:,:,1082))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1082),n2h16(1082))
  call Hloop_VA_Q(ntryL,G1H32(1083),ex3(:),G1H16(1),m3h2x16(:,1083),heltab2x32(:,:,1083))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1083),n2h16(1083))
  call Hloop_VA_Q(ntryL,G1H32(1084),ex3(:),G1H16(1),m3h2x16(:,1084),heltab2x32(:,:,1084))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1084),n2h16(1084))
  call Hloop_VA_Q(ntryL,G1H32(1085),ex3(:),G1H16(1),m3h2x16(:,1085),heltab2x32(:,:,1085))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1085),n2h16(1085))
  call Hloop_SA_Q(ntryL,G1H32(1086),ex3(:),G1H16(1),ngH,m3h2x16(:,1086),heltab2x32(:,:,1086))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1086),n2h16(1086))
  call Hloop_SA_Q(ntryL,G1H32(1087),ex3(:),G1H16(1),ngX,m3h2x16(:,1087),heltab2x32(:,:,1087))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1087),n2h16(1087))
  call Hloop_SA_Q(ntryL,G1H32(1088),ex3(:),G1H16(1),ngH,m3h2x16(:,1088),heltab2x32(:,:,1088))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1088),n2h16(1088))
  call Hloop_SA_Q(ntryL,G1H32(1089),ex3(:),G1H16(1),ngH,m3h2x16(:,1089),heltab2x32(:,:,1089))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1089),n2h16(1089))
  call Hloop_SA_Q(ntryL,G1H32(1090),ex3(:),G1H16(1),ngX,m3h2x16(:,1090),heltab2x32(:,:,1090))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1090),n2h16(1090))
  call Hloop_SA_Q(ntryL,G1H32(1091),ex3(:),G1H16(1),ngX,m3h2x16(:,1091),heltab2x32(:,:,1091))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1091),n2h16(1091))
  call Hloop_VA_Q(ntryL,G1H32(1092),ex3(:),G1H16(1),m3h2x16(:,1092),heltab2x32(:,:,1092))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1092),n2h16(1092))
  call Hloop_VA_Q(ntryL,G1H32(1093),ex3(:),G1H16(1),m3h2x16(:,1093),heltab2x32(:,:,1093))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1093),n2h16(1093))
  call Hloop_VA_Q(ntryL,G1H32(1094),ex3(:),G1H16(1),m3h2x16(:,1094),heltab2x32(:,:,1094))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1094),n2h16(1094))
  call Hloop_ZA_Q(ntryL,G1H32(1095),ex3(:),G1H16(1),ngZl,m3h2x16(:,1095),heltab2x32(:,:,1095))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1095),n2h16(1095))
  call Hloop_VA_Q(ntryL,G1H32(1096),ex3(:),G1H16(1),m3h2x16(:,1096),heltab2x32(:,:,1096))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1096),n2h16(1096))
  call Hloop_ZA_Q(ntryL,G1H32(1097),ex3(:),G1H16(1),ngZl,m3h2x16(:,1097),heltab2x32(:,:,1097))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1097),n2h16(1097))
  call Hloop_VA_Q(ntryL,G1H32(1098),ex3(:),G1H16(1),m3h2x16(:,1098),heltab2x32(:,:,1098))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1098),n2h16(1098))
  call Hloop_VA_Q(ntryL,G1H32(1099),ex3(:),G1H16(1),m3h2x16(:,1099),heltab2x32(:,:,1099))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1099),n2h16(1099))
  call Hloop_VA_Q(ntryL,G1H32(1100),ex3(:),G1H16(1),m3h2x16(:,1100),heltab2x32(:,:,1100))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1100),n2h16(1100))
  call Hloop_ZA_Q(ntryL,G1H32(1101),ex3(:),G1H16(1),ngZl,m3h2x16(:,1101),heltab2x32(:,:,1101))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1101),n2h16(1101))
  call Hloop_VA_Q(ntryL,G1H32(1102),ex3(:),G1H16(1),m3h2x16(:,1102),heltab2x32(:,:,1102))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1102),n2h16(1102))
  call Hloop_ZA_Q(ntryL,G1H32(1103),ex3(:),G1H16(1),ngZl,m3h2x16(:,1103),heltab2x32(:,:,1103))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1103),n2h16(1103))
  call Hloop_VA_Q(ntryL,G1H32(1104),ex3(:),G1H16(1),m3h2x16(:,1104),heltab2x32(:,:,1104))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1104),n2h16(1104))
  call Hloop_VA_Q(ntryL,G1H32(1105),ex3(:),G1H16(1),m3h2x16(:,1105),heltab2x32(:,:,1105))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1105),n2h16(1105))
  call Hloop_VA_Q(ntryL,G1H32(1106),ex3(:),G1H16(1),m3h2x16(:,1106),heltab2x32(:,:,1106))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1106),n2h16(1106))
  call Hloop_ZA_Q(ntryL,G1H32(1107),ex3(:),G1H16(1),ngZl,m3h2x16(:,1107),heltab2x32(:,:,1107))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1107),n2h16(1107))
  call Hloop_VA_Q(ntryL,G1H32(1108),ex3(:),G1H16(1),m3h2x16(:,1108),heltab2x32(:,:,1108))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1108),n2h16(1108))
  call Hloop_ZA_Q(ntryL,G1H32(1109),ex3(:),G1H16(1),ngZl,m3h2x16(:,1109),heltab2x32(:,:,1109))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1109),n2h16(1109))
  call Hloop_ZA_Q(ntryL,G1H32(1110),ex3(:),G1H16(1),ngZl,m3h2x16(:,1110),heltab2x32(:,:,1110))
  call Hloop_A_Q(ntryL,G1H16(1),69,nME,G2H16(1110),n2h16(1110))
  call Hloop_SQ_A(ntryL,G1H32(1111),ex1(:),G1H16(1),ngH,m3h2x16(:,1111),heltab2x32(:,:,1111))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1111),n2h16(1111))
  call Hloop_SQ_A(ntryL,G1H32(1112),ex1(:),G1H16(1),ngH,m3h2x16(:,1112),heltab2x32(:,:,1112))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1112),n2h16(1112))
  call Hloop_SQ_A(ntryL,G1H32(1113),ex1(:),G1H16(1),ngX,m3h2x16(:,1113),heltab2x32(:,:,1113))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1113),n2h16(1113))
  call Hloop_SQ_A(ntryL,G1H32(1114),ex1(:),G1H16(1),ngX,m3h2x16(:,1114),heltab2x32(:,:,1114))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1114),n2h16(1114))
  call Hloop_SQ_A(ntryL,G1H32(1115),ex1(:),G1H16(1),ngH,m3h2x16(:,1115),heltab2x32(:,:,1115))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1115),n2h16(1115))
  call Hloop_SQ_A(ntryL,G1H32(1116),ex1(:),G1H16(1),ngH,m3h2x16(:,1116),heltab2x32(:,:,1116))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1116),n2h16(1116))
  call Hloop_SQ_A(ntryL,G1H32(1117),ex1(:),G1H16(1),ngX,m3h2x16(:,1117),heltab2x32(:,:,1117))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1117),n2h16(1117))
  call Hloop_SQ_A(ntryL,G1H32(1118),ex1(:),G1H16(1),ngX,m3h2x16(:,1118),heltab2x32(:,:,1118))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1118),n2h16(1118))
  call Hloop_VQ_A(ntryL,G1H32(1119),ex1(:),G1H16(1),m3h2x16(:,1119),heltab2x32(:,:,1119))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1119),n2h16(1119))
  call Hloop_VQ_A(ntryL,G1H32(1120),ex1(:),G1H16(1),m3h2x16(:,1120),heltab2x32(:,:,1120))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1120),n2h16(1120))
  call Hloop_VQ_A(ntryL,G1H32(1121),ex1(:),G1H16(1),m3h2x16(:,1121),heltab2x32(:,:,1121))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1121),n2h16(1121))
  call Hloop_VQ_A(ntryL,G1H32(1122),ex1(:),G1H16(1),m3h2x16(:,1122),heltab2x32(:,:,1122))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1122),n2h16(1122))
  call Hloop_SQ_A(ntryL,G1H32(1123),ex1(:),G1H16(1),ngH,m3h2x16(:,1123),heltab2x32(:,:,1123))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1123),n2h16(1123))
  call Hloop_SQ_A(ntryL,G1H32(1124),ex1(:),G1H16(1),ngX,m3h2x16(:,1124),heltab2x32(:,:,1124))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1124),n2h16(1124))
  call Hloop_SQ_A(ntryL,G1H32(1125),ex1(:),G1H16(1),ngH,m3h2x16(:,1125),heltab2x32(:,:,1125))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1125),n2h16(1125))
  call Hloop_SQ_A(ntryL,G1H32(1126),ex1(:),G1H16(1),ngH,m3h2x16(:,1126),heltab2x32(:,:,1126))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1126),n2h16(1126))
  call Hloop_SQ_A(ntryL,G1H32(1127),ex1(:),G1H16(1),ngX,m3h2x16(:,1127),heltab2x32(:,:,1127))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1127),n2h16(1127))
  call Hloop_SQ_A(ntryL,G1H32(1128),ex1(:),G1H16(1),ngX,m3h2x16(:,1128),heltab2x32(:,:,1128))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1128),n2h16(1128))
  call Hloop_VQ_A(ntryL,G1H32(1129),ex1(:),G1H16(1),m3h2x16(:,1129),heltab2x32(:,:,1129))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1129),n2h16(1129))
  call Hloop_VQ_A(ntryL,G1H32(1130),ex1(:),G1H16(1),m3h2x16(:,1130),heltab2x32(:,:,1130))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1130),n2h16(1130))
  call Hloop_VQ_A(ntryL,G1H32(1131),ex1(:),G1H16(1),m3h2x16(:,1131),heltab2x32(:,:,1131))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1131),n2h16(1131))
  call Hloop_ZQ_A(ntryL,G1H32(1132),ex1(:),G1H16(1),ngZl,m3h2x16(:,1132),heltab2x32(:,:,1132))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1132),n2h16(1132))
  call Hloop_VQ_A(ntryL,G1H32(1133),ex1(:),G1H16(1),m3h2x16(:,1133),heltab2x32(:,:,1133))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1133),n2h16(1133))
  call Hloop_ZQ_A(ntryL,G1H32(1134),ex1(:),G1H16(1),ngZl,m3h2x16(:,1134),heltab2x32(:,:,1134))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1134),n2h16(1134))
  call Hloop_VQ_A(ntryL,G1H32(1135),ex1(:),G1H16(1),m3h2x16(:,1135),heltab2x32(:,:,1135))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1135),n2h16(1135))
  call Hloop_VQ_A(ntryL,G1H32(1136),ex1(:),G1H16(1),m3h2x16(:,1136),heltab2x32(:,:,1136))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1136),n2h16(1136))
  call Hloop_VQ_A(ntryL,G1H32(1137),ex1(:),G1H16(1),m3h2x16(:,1137),heltab2x32(:,:,1137))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1137),n2h16(1137))
  call Hloop_ZQ_A(ntryL,G1H32(1138),ex1(:),G1H16(1),ngZl,m3h2x16(:,1138),heltab2x32(:,:,1138))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1138),n2h16(1138))
  call Hloop_VQ_A(ntryL,G1H32(1139),ex1(:),G1H16(1),m3h2x16(:,1139),heltab2x32(:,:,1139))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1139),n2h16(1139))
  call Hloop_ZQ_A(ntryL,G1H32(1140),ex1(:),G1H16(1),ngZl,m3h2x16(:,1140),heltab2x32(:,:,1140))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1140),n2h16(1140))
  call Hloop_VQ_A(ntryL,G1H32(1141),ex1(:),G1H16(1),m3h2x16(:,1141),heltab2x32(:,:,1141))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1141),n2h16(1141))
  call Hloop_VQ_A(ntryL,G1H32(1142),ex1(:),G1H16(1),m3h2x16(:,1142),heltab2x32(:,:,1142))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1142),n2h16(1142))
  call Hloop_VQ_A(ntryL,G1H32(1143),ex1(:),G1H16(1),m3h2x16(:,1143),heltab2x32(:,:,1143))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1143),n2h16(1143))
  call Hloop_ZQ_A(ntryL,G1H32(1144),ex1(:),G1H16(1),ngZl,m3h2x16(:,1144),heltab2x32(:,:,1144))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1144),n2h16(1144))
  call Hloop_VQ_A(ntryL,G1H32(1145),ex1(:),G1H16(1),m3h2x16(:,1145),heltab2x32(:,:,1145))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1145),n2h16(1145))
  call Hloop_ZQ_A(ntryL,G1H32(1146),ex1(:),G1H16(1),ngZl,m3h2x16(:,1146),heltab2x32(:,:,1146))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1146),n2h16(1146))
  call Hloop_ZQ_A(ntryL,G1H32(1147),ex1(:),G1H16(1),ngZl,m3h2x16(:,1147),heltab2x32(:,:,1147))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1147),n2h16(1147))
  call Hloop_SQ_A(ntryL,G1H32(1148),ex1(:),G1H16(1),ngH,m3h2x16(:,1148),heltab2x32(:,:,1148))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1148),n2h16(1148))
  call Hloop_SQ_A(ntryL,G1H32(1149),ex1(:),G1H16(1),ngH,m3h2x16(:,1149),heltab2x32(:,:,1149))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1149),n2h16(1149))
  call Hloop_SQ_A(ntryL,G1H32(1150),ex1(:),G1H16(1),ngX,m3h2x16(:,1150),heltab2x32(:,:,1150))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1150),n2h16(1150))
  call Hloop_SQ_A(ntryL,G1H32(1151),ex1(:),G1H16(1),ngX,m3h2x16(:,1151),heltab2x32(:,:,1151))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1151),n2h16(1151))
  call Hloop_SQ_A(ntryL,G1H32(1152),ex1(:),G1H16(1),ngH,m3h2x16(:,1152),heltab2x32(:,:,1152))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1152),n2h16(1152))
  call Hloop_SQ_A(ntryL,G1H32(1153),ex1(:),G1H16(1),ngH,m3h2x16(:,1153),heltab2x32(:,:,1153))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1153),n2h16(1153))
  call Hloop_SQ_A(ntryL,G1H32(1154),ex1(:),G1H16(1),ngX,m3h2x16(:,1154),heltab2x32(:,:,1154))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1154),n2h16(1154))
  call Hloop_SQ_A(ntryL,G1H32(1155),ex1(:),G1H16(1),ngX,m3h2x16(:,1155),heltab2x32(:,:,1155))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1155),n2h16(1155))
  call Hloop_VQ_A(ntryL,G1H32(1156),ex1(:),G1H16(1),m3h2x16(:,1156),heltab2x32(:,:,1156))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1156),n2h16(1156))
  call Hloop_VQ_A(ntryL,G1H32(1157),ex1(:),G1H16(1),m3h2x16(:,1157),heltab2x32(:,:,1157))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1157),n2h16(1157))
  call Hloop_VQ_A(ntryL,G1H32(1158),ex1(:),G1H16(1),m3h2x16(:,1158),heltab2x32(:,:,1158))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1158),n2h16(1158))
  call Hloop_VQ_A(ntryL,G1H32(1159),ex1(:),G1H16(1),m3h2x16(:,1159),heltab2x32(:,:,1159))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1159),n2h16(1159))
  call Hloop_SQ_A(ntryL,G1H32(1160),ex1(:),G1H16(1),ngH,m3h2x16(:,1160),heltab2x32(:,:,1160))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1160),n2h16(1160))
  call Hloop_SQ_A(ntryL,G1H32(1161),ex1(:),G1H16(1),ngX,m3h2x16(:,1161),heltab2x32(:,:,1161))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1161),n2h16(1161))
  call Hloop_SQ_A(ntryL,G1H32(1162),ex1(:),G1H16(1),ngH,m3h2x16(:,1162),heltab2x32(:,:,1162))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1162),n2h16(1162))
  call Hloop_SQ_A(ntryL,G1H32(1163),ex1(:),G1H16(1),ngH,m3h2x16(:,1163),heltab2x32(:,:,1163))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1163),n2h16(1163))
  call Hloop_SQ_A(ntryL,G1H32(1164),ex1(:),G1H16(1),ngX,m3h2x16(:,1164),heltab2x32(:,:,1164))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1164),n2h16(1164))
  call Hloop_SQ_A(ntryL,G1H32(1165),ex1(:),G1H16(1),ngX,m3h2x16(:,1165),heltab2x32(:,:,1165))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1165),n2h16(1165))
  call Hloop_VQ_A(ntryL,G1H32(1166),ex1(:),G1H16(1),m3h2x16(:,1166),heltab2x32(:,:,1166))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1166),n2h16(1166))
  call Hloop_VQ_A(ntryL,G1H32(1167),ex1(:),G1H16(1),m3h2x16(:,1167),heltab2x32(:,:,1167))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1167),n2h16(1167))
  call Hloop_VQ_A(ntryL,G1H32(1168),ex1(:),G1H16(1),m3h2x16(:,1168),heltab2x32(:,:,1168))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1168),n2h16(1168))
  call Hloop_ZQ_A(ntryL,G1H32(1169),ex1(:),G1H16(1),ngZl,m3h2x16(:,1169),heltab2x32(:,:,1169))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1169),n2h16(1169))
  call Hloop_VQ_A(ntryL,G1H32(1170),ex1(:),G1H16(1),m3h2x16(:,1170),heltab2x32(:,:,1170))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1170),n2h16(1170))
  call Hloop_ZQ_A(ntryL,G1H32(1171),ex1(:),G1H16(1),ngZl,m3h2x16(:,1171),heltab2x32(:,:,1171))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1171),n2h16(1171))
  call Hloop_VQ_A(ntryL,G1H32(1172),ex1(:),G1H16(1),m3h2x16(:,1172),heltab2x32(:,:,1172))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1172),n2h16(1172))
  call Hloop_VQ_A(ntryL,G1H32(1173),ex1(:),G1H16(1),m3h2x16(:,1173),heltab2x32(:,:,1173))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1173),n2h16(1173))
  call Hloop_VQ_A(ntryL,G1H32(1174),ex1(:),G1H16(1),m3h2x16(:,1174),heltab2x32(:,:,1174))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1174),n2h16(1174))
  call Hloop_ZQ_A(ntryL,G1H32(1175),ex1(:),G1H16(1),ngZl,m3h2x16(:,1175),heltab2x32(:,:,1175))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1175),n2h16(1175))
  call Hloop_VQ_A(ntryL,G1H32(1176),ex1(:),G1H16(1),m3h2x16(:,1176),heltab2x32(:,:,1176))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1176),n2h16(1176))
  call Hloop_ZQ_A(ntryL,G1H32(1177),ex1(:),G1H16(1),ngZl,m3h2x16(:,1177),heltab2x32(:,:,1177))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1177),n2h16(1177))
  call Hloop_VQ_A(ntryL,G1H32(1178),ex1(:),G1H16(1),m3h2x16(:,1178),heltab2x32(:,:,1178))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1178),n2h16(1178))
  call Hloop_VQ_A(ntryL,G1H32(1179),ex1(:),G1H16(1),m3h2x16(:,1179),heltab2x32(:,:,1179))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1179),n2h16(1179))
  call Hloop_VQ_A(ntryL,G1H32(1180),ex1(:),G1H16(1),m3h2x16(:,1180),heltab2x32(:,:,1180))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1180),n2h16(1180))
  call Hloop_ZQ_A(ntryL,G1H32(1181),ex1(:),G1H16(1),ngZl,m3h2x16(:,1181),heltab2x32(:,:,1181))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1181),n2h16(1181))
  call Hloop_VQ_A(ntryL,G1H32(1182),ex1(:),G1H16(1),m3h2x16(:,1182),heltab2x32(:,:,1182))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1182),n2h16(1182))
  call Hloop_ZQ_A(ntryL,G1H32(1183),ex1(:),G1H16(1),ngZl,m3h2x16(:,1183),heltab2x32(:,:,1183))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1183),n2h16(1183))
  call Hloop_ZQ_A(ntryL,G1H32(1184),ex1(:),G1H16(1),ngZl,m3h2x16(:,1184),heltab2x32(:,:,1184))
  call Hloop_Q_A(ntryL,G1H16(1),81,nME,G2H16(1184),n2h16(1184))
  call Hloop_SA_Q(ntryL,G1H32(1185),ex4(:),G1H16(1),ngH,m3h2x16(:,1185),heltab2x32(:,:,1185))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1185),n2h16(1185))
  call Hloop_SA_Q(ntryL,G1H32(1186),ex4(:),G1H16(1),ngX,m3h2x16(:,1186),heltab2x32(:,:,1186))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1186),n2h16(1186))
  call Hloop_SA_Q(ntryL,G1H32(1187),ex4(:),G1H16(1),ngH,m3h2x16(:,1187),heltab2x32(:,:,1187))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1187),n2h16(1187))
  call Hloop_SA_Q(ntryL,G1H32(1188),ex4(:),G1H16(1),ngX,m3h2x16(:,1188),heltab2x32(:,:,1188))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1188),n2h16(1188))
  call Hloop_VA_Q(ntryL,G1H32(1189),ex4(:),G1H16(1),m3h2x16(:,1189),heltab2x32(:,:,1189))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1189),n2h16(1189))
  call Hloop_VA_Q(ntryL,G1H32(1190),ex4(:),G1H16(1),m3h2x16(:,1190),heltab2x32(:,:,1190))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1190),n2h16(1190))
  call Hloop_VA_Q(ntryL,G1H32(1191),ex4(:),G1H16(1),m3h2x16(:,1191),heltab2x32(:,:,1191))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1191),n2h16(1191))
  call Hloop_VA_Q(ntryL,G1H32(1192),ex4(:),G1H16(1),m3h2x16(:,1192),heltab2x32(:,:,1192))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1192),n2h16(1192))
  call Hloop_SA_Q(ntryL,G1H32(1193),ex4(:),G1H16(1),ngH,m3h2x16(:,1193),heltab2x32(:,:,1193))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1193),n2h16(1193))
  call Hloop_SA_Q(ntryL,G1H32(1194),ex4(:),G1H16(1),ngH,m3h2x16(:,1194),heltab2x32(:,:,1194))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1194),n2h16(1194))
  call Hloop_SA_Q(ntryL,G1H32(1195),ex4(:),G1H16(1),ngX,m3h2x16(:,1195),heltab2x32(:,:,1195))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1195),n2h16(1195))
  call Hloop_SA_Q(ntryL,G1H32(1196),ex4(:),G1H16(1),ngX,m3h2x16(:,1196),heltab2x32(:,:,1196))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1196),n2h16(1196))
  call Hloop_VA_Q(ntryL,G1H32(1197),ex4(:),G1H16(1),m3h2x16(:,1197),heltab2x32(:,:,1197))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1197),n2h16(1197))
  call Hloop_VA_Q(ntryL,G1H32(1198),ex4(:),G1H16(1),m3h2x16(:,1198),heltab2x32(:,:,1198))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1198),n2h16(1198))
  call Hloop_VA_Q(ntryL,G1H32(1199),ex4(:),G1H16(1),m3h2x16(:,1199),heltab2x32(:,:,1199))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1199),n2h16(1199))
  call Hloop_ZA_Q(ntryL,G1H32(1200),ex4(:),G1H16(1),ngZl,m3h2x16(:,1200),heltab2x32(:,:,1200))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1200),n2h16(1200))
  call Hloop_VA_Q(ntryL,G1H32(1201),ex4(:),G1H16(1),m3h2x16(:,1201),heltab2x32(:,:,1201))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1201),n2h16(1201))
  call Hloop_ZA_Q(ntryL,G1H32(1202),ex4(:),G1H16(1),ngZl,m3h2x16(:,1202),heltab2x32(:,:,1202))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1202),n2h16(1202))
  call Hloop_SA_Q(ntryL,G1H32(1203),ex4(:),G1H16(1),ngH,m3h2x16(:,1203),heltab2x32(:,:,1203))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1203),n2h16(1203))
  call Hloop_SA_Q(ntryL,G1H32(1204),ex4(:),G1H16(1),ngX,m3h2x16(:,1204),heltab2x32(:,:,1204))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1204),n2h16(1204))
  call Hloop_SA_Q(ntryL,G1H32(1205),ex4(:),G1H16(1),ngH,m3h2x16(:,1205),heltab2x32(:,:,1205))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1205),n2h16(1205))
  call Hloop_SA_Q(ntryL,G1H32(1206),ex4(:),G1H16(1),ngH,m3h2x16(:,1206),heltab2x32(:,:,1206))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1206),n2h16(1206))
  call Hloop_SA_Q(ntryL,G1H32(1207),ex4(:),G1H16(1),ngX,m3h2x16(:,1207),heltab2x32(:,:,1207))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1207),n2h16(1207))
  call Hloop_SA_Q(ntryL,G1H32(1208),ex4(:),G1H16(1),ngX,m3h2x16(:,1208),heltab2x32(:,:,1208))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1208),n2h16(1208))
  call Hloop_VA_Q(ntryL,G1H32(1209),ex4(:),G1H16(1),m3h2x16(:,1209),heltab2x32(:,:,1209))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1209),n2h16(1209))
  call Hloop_VA_Q(ntryL,G1H32(1210),ex4(:),G1H16(1),m3h2x16(:,1210),heltab2x32(:,:,1210))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1210),n2h16(1210))
  call Hloop_ZA_Q(ntryL,G1H32(1211),ex4(:),G1H16(1),ngZl,m3h2x16(:,1211),heltab2x32(:,:,1211))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1211),n2h16(1211))
  call Hloop_VA_Q(ntryL,G1H32(1212),ex4(:),G1H16(1),m3h2x16(:,1212),heltab2x32(:,:,1212))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1212),n2h16(1212))
  call Hloop_ZA_Q(ntryL,G1H32(1213),ex4(:),G1H16(1),ngZl,m3h2x16(:,1213),heltab2x32(:,:,1213))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1213),n2h16(1213))
  call Hloop_VA_Q(ntryL,G1H32(1214),ex4(:),G1H16(1),m3h2x16(:,1214),heltab2x32(:,:,1214))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1214),n2h16(1214))
  call Hloop_VA_Q(ntryL,G1H32(1215),ex4(:),G1H16(1),m3h2x16(:,1215),heltab2x32(:,:,1215))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1215),n2h16(1215))
  call Hloop_VA_Q(ntryL,G1H32(1216),ex4(:),G1H16(1),m3h2x16(:,1216),heltab2x32(:,:,1216))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1216),n2h16(1216))
  call Hloop_ZA_Q(ntryL,G1H32(1217),ex4(:),G1H16(1),ngZl,m3h2x16(:,1217),heltab2x32(:,:,1217))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1217),n2h16(1217))
  call Hloop_VA_Q(ntryL,G1H32(1218),ex4(:),G1H16(1),m3h2x16(:,1218),heltab2x32(:,:,1218))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1218),n2h16(1218))
  call Hloop_ZA_Q(ntryL,G1H32(1219),ex4(:),G1H16(1),ngZl,m3h2x16(:,1219),heltab2x32(:,:,1219))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1219),n2h16(1219))
  call Hloop_VA_Q(ntryL,G1H32(1220),ex4(:),G1H16(1),m3h2x16(:,1220),heltab2x32(:,:,1220))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1220),n2h16(1220))
  call Hloop_ZA_Q(ntryL,G1H32(1221),ex4(:),G1H16(1),ngZl,m3h2x16(:,1221),heltab2x32(:,:,1221))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1221),n2h16(1221))
  call Hloop_SA_Q(ntryL,G1H32(1222),ex6(:),G1H16(1),ngH,m3h2x16(:,1222),heltab2x32(:,:,1222))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1222),n2h16(1222))
  call Hloop_SA_Q(ntryL,G1H32(1223),ex6(:),G1H16(1),ngX,m3h2x16(:,1223),heltab2x32(:,:,1223))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1223),n2h16(1223))
  call Hloop_SA_Q(ntryL,G1H32(1224),ex6(:),G1H16(1),ngH,m3h2x16(:,1224),heltab2x32(:,:,1224))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1224),n2h16(1224))
  call Hloop_SA_Q(ntryL,G1H32(1225),ex6(:),G1H16(1),ngX,m3h2x16(:,1225),heltab2x32(:,:,1225))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1225),n2h16(1225))
  call Hloop_VA_Q(ntryL,G1H32(1226),ex6(:),G1H16(1),m3h2x16(:,1226),heltab2x32(:,:,1226))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1226),n2h16(1226))
  call Hloop_VA_Q(ntryL,G1H32(1227),ex6(:),G1H16(1),m3h2x16(:,1227),heltab2x32(:,:,1227))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1227),n2h16(1227))
  call Hloop_VA_Q(ntryL,G1H32(1228),ex6(:),G1H16(1),m3h2x16(:,1228),heltab2x32(:,:,1228))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1228),n2h16(1228))
  call Hloop_VA_Q(ntryL,G1H32(1229),ex6(:),G1H16(1),m3h2x16(:,1229),heltab2x32(:,:,1229))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1229),n2h16(1229))
  call Hloop_SA_Q(ntryL,G1H32(1230),ex6(:),G1H16(1),ngH,m3h2x16(:,1230),heltab2x32(:,:,1230))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1230),n2h16(1230))
  call Hloop_SA_Q(ntryL,G1H32(1231),ex6(:),G1H16(1),ngH,m3h2x16(:,1231),heltab2x32(:,:,1231))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1231),n2h16(1231))
  call Hloop_SA_Q(ntryL,G1H32(1232),ex6(:),G1H16(1),ngX,m3h2x16(:,1232),heltab2x32(:,:,1232))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1232),n2h16(1232))
  call Hloop_SA_Q(ntryL,G1H32(1233),ex6(:),G1H16(1),ngX,m3h2x16(:,1233),heltab2x32(:,:,1233))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1233),n2h16(1233))
  call Hloop_VA_Q(ntryL,G1H32(1234),ex6(:),G1H16(1),m3h2x16(:,1234),heltab2x32(:,:,1234))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1234),n2h16(1234))
  call Hloop_VA_Q(ntryL,G1H32(1235),ex6(:),G1H16(1),m3h2x16(:,1235),heltab2x32(:,:,1235))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1235),n2h16(1235))
  call Hloop_VA_Q(ntryL,G1H32(1236),ex6(:),G1H16(1),m3h2x16(:,1236),heltab2x32(:,:,1236))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1236),n2h16(1236))
  call Hloop_ZA_Q(ntryL,G1H32(1237),ex6(:),G1H16(1),ngZl,m3h2x16(:,1237),heltab2x32(:,:,1237))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1237),n2h16(1237))
  call Hloop_VA_Q(ntryL,G1H32(1238),ex6(:),G1H16(1),m3h2x16(:,1238),heltab2x32(:,:,1238))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1238),n2h16(1238))
  call Hloop_ZA_Q(ntryL,G1H32(1239),ex6(:),G1H16(1),ngZl,m3h2x16(:,1239),heltab2x32(:,:,1239))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1239),n2h16(1239))
  call Hloop_SA_Q(ntryL,G1H32(1240),ex6(:),G1H16(1),ngH,m3h2x16(:,1240),heltab2x32(:,:,1240))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1240),n2h16(1240))
  call Hloop_SA_Q(ntryL,G1H32(1241),ex6(:),G1H16(1),ngX,m3h2x16(:,1241),heltab2x32(:,:,1241))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1241),n2h16(1241))
  call Hloop_SA_Q(ntryL,G1H32(1242),ex6(:),G1H16(1),ngH,m3h2x16(:,1242),heltab2x32(:,:,1242))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1242),n2h16(1242))
  call Hloop_SA_Q(ntryL,G1H32(1243),ex6(:),G1H16(1),ngH,m3h2x16(:,1243),heltab2x32(:,:,1243))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1243),n2h16(1243))
  call Hloop_SA_Q(ntryL,G1H32(1244),ex6(:),G1H16(1),ngX,m3h2x16(:,1244),heltab2x32(:,:,1244))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1244),n2h16(1244))
  call Hloop_SA_Q(ntryL,G1H32(1245),ex6(:),G1H16(1),ngX,m3h2x16(:,1245),heltab2x32(:,:,1245))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1245),n2h16(1245))
  call Hloop_VA_Q(ntryL,G1H32(1246),ex6(:),G1H16(1),m3h2x16(:,1246),heltab2x32(:,:,1246))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1246),n2h16(1246))
  call Hloop_VA_Q(ntryL,G1H32(1247),ex6(:),G1H16(1),m3h2x16(:,1247),heltab2x32(:,:,1247))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1247),n2h16(1247))
  call Hloop_ZA_Q(ntryL,G1H32(1248),ex6(:),G1H16(1),ngZl,m3h2x16(:,1248),heltab2x32(:,:,1248))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1248),n2h16(1248))
  call Hloop_VA_Q(ntryL,G1H32(1249),ex6(:),G1H16(1),m3h2x16(:,1249),heltab2x32(:,:,1249))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1249),n2h16(1249))
  call Hloop_ZA_Q(ntryL,G1H32(1250),ex6(:),G1H16(1),ngZl,m3h2x16(:,1250),heltab2x32(:,:,1250))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1250),n2h16(1250))
  call Hloop_VA_Q(ntryL,G1H32(1251),ex6(:),G1H16(1),m3h2x16(:,1251),heltab2x32(:,:,1251))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1251),n2h16(1251))
  call Hloop_VA_Q(ntryL,G1H32(1252),ex6(:),G1H16(1),m3h2x16(:,1252),heltab2x32(:,:,1252))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1252),n2h16(1252))
  call Hloop_VA_Q(ntryL,G1H32(1253),ex6(:),G1H16(1),m3h2x16(:,1253),heltab2x32(:,:,1253))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1253),n2h16(1253))
  call Hloop_ZA_Q(ntryL,G1H32(1254),ex6(:),G1H16(1),ngZl,m3h2x16(:,1254),heltab2x32(:,:,1254))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1254),n2h16(1254))
  call Hloop_VA_Q(ntryL,G1H32(1255),ex6(:),G1H16(1),m3h2x16(:,1255),heltab2x32(:,:,1255))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1255),n2h16(1255))
  call Hloop_ZA_Q(ntryL,G1H32(1256),ex6(:),G1H16(1),ngZl,m3h2x16(:,1256),heltab2x32(:,:,1256))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1256),n2h16(1256))
  call Hloop_VA_Q(ntryL,G1H32(1257),ex6(:),G1H16(1),m3h2x16(:,1257),heltab2x32(:,:,1257))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1257),n2h16(1257))
  call Hloop_ZA_Q(ntryL,G1H32(1258),ex6(:),G1H16(1),ngZl,m3h2x16(:,1258),heltab2x32(:,:,1258))
  call Hloop_A_Q(ntryL,G1H16(1),98,nMM,G2H16(1258),n2h16(1258))
  call Hloop_VA_Q(ntryL,G1H32(1259),ex3(:),G1H16(1),m3h2x16(:,1259),heltab2x32(:,:,1259))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1259),n2h16(1259))
  call Hloop_VA_Q(ntryL,G1H32(1260),ex3(:),G1H16(1),m3h2x16(:,1260),heltab2x32(:,:,1260))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1260),n2h16(1260))
  call Hloop_VA_Q(ntryL,G1H32(1261),ex3(:),G1H16(1),m3h2x16(:,1261),heltab2x32(:,:,1261))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1261),n2h16(1261))
  call Hloop_VA_Q(ntryL,G1H32(1262),ex3(:),G1H16(1),m3h2x16(:,1262),heltab2x32(:,:,1262))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1262),n2h16(1262))
  call Hloop_SA_Q(ntryL,G1H32(1263),ex3(:),G1H16(1),ngH,m3h2x16(:,1263),heltab2x32(:,:,1263))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1263),n2h16(1263))
  call Hloop_SA_Q(ntryL,G1H32(1264),ex3(:),G1H16(1),ngX,m3h2x16(:,1264),heltab2x32(:,:,1264))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1264),n2h16(1264))
  call Hloop_SA_Q(ntryL,G1H32(1265),ex3(:),G1H16(1),ngH,m3h2x16(:,1265),heltab2x32(:,:,1265))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1265),n2h16(1265))
  call Hloop_SA_Q(ntryL,G1H32(1266),ex3(:),G1H16(1),ngX,m3h2x16(:,1266),heltab2x32(:,:,1266))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1266),n2h16(1266))
  call Hloop_SA_Q(ntryL,G1H32(1267),ex3(:),G1H16(1),ngH,m3h2x16(:,1267),heltab2x32(:,:,1267))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1267),n2h16(1267))
  call Hloop_SA_Q(ntryL,G1H32(1268),ex3(:),G1H16(1),ngX,m3h2x16(:,1268),heltab2x32(:,:,1268))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1268),n2h16(1268))
  call Hloop_SA_Q(ntryL,G1H32(1269),ex3(:),G1H16(1),ngH,m3h2x16(:,1269),heltab2x32(:,:,1269))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1269),n2h16(1269))
  call Hloop_SA_Q(ntryL,G1H32(1270),ex3(:),G1H16(1),ngX,m3h2x16(:,1270),heltab2x32(:,:,1270))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1270),n2h16(1270))
  call Hloop_VA_Q(ntryL,G1H32(1271),ex3(:),G1H16(1),m3h2x16(:,1271),heltab2x32(:,:,1271))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1271),n2h16(1271))
  call Hloop_VA_Q(ntryL,G1H32(1272),ex3(:),G1H16(1),m3h2x16(:,1272),heltab2x32(:,:,1272))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1272),n2h16(1272))
  call Hloop_ZA_Q(ntryL,G1H32(1273),ex3(:),G1H16(1),ngZl,m3h2x16(:,1273),heltab2x32(:,:,1273))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1273),n2h16(1273))
  call Hloop_VA_Q(ntryL,G1H32(1274),ex3(:),G1H16(1),m3h2x16(:,1274),heltab2x32(:,:,1274))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1274),n2h16(1274))
  call Hloop_ZA_Q(ntryL,G1H32(1275),ex3(:),G1H16(1),ngZl,m3h2x16(:,1275),heltab2x32(:,:,1275))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1275),n2h16(1275))
  call Hloop_VA_Q(ntryL,G1H32(1276),ex3(:),G1H16(1),m3h2x16(:,1276),heltab2x32(:,:,1276))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1276),n2h16(1276))
  call Hloop_VA_Q(ntryL,G1H32(1277),ex3(:),G1H16(1),m3h2x16(:,1277),heltab2x32(:,:,1277))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1277),n2h16(1277))
  call Hloop_VA_Q(ntryL,G1H32(1278),ex3(:),G1H16(1),m3h2x16(:,1278),heltab2x32(:,:,1278))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1278),n2h16(1278))
  call Hloop_ZA_Q(ntryL,G1H32(1279),ex3(:),G1H16(1),ngZl,m3h2x16(:,1279),heltab2x32(:,:,1279))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1279),n2h16(1279))
  call Hloop_VA_Q(ntryL,G1H32(1280),ex3(:),G1H16(1),m3h2x16(:,1280),heltab2x32(:,:,1280))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1280),n2h16(1280))
  call Hloop_ZA_Q(ntryL,G1H32(1281),ex3(:),G1H16(1),ngZl,m3h2x16(:,1281),heltab2x32(:,:,1281))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1281),n2h16(1281))
  call Hloop_VA_Q(ntryL,G1H32(1282),ex3(:),G1H16(1),m3h2x16(:,1282),heltab2x32(:,:,1282))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1282),n2h16(1282))
  call Hloop_SA_Q(ntryL,G1H32(1283),ex3(:),G1H16(1),ngH,m3h2x16(:,1283),heltab2x32(:,:,1283))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1283),n2h16(1283))
  call Hloop_SA_Q(ntryL,G1H32(1284),ex3(:),G1H16(1),ngX,m3h2x16(:,1284),heltab2x32(:,:,1284))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1284),n2h16(1284))
  call Hloop_SA_Q(ntryL,G1H32(1285),ex3(:),G1H16(1),ngH,m3h2x16(:,1285),heltab2x32(:,:,1285))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1285),n2h16(1285))
  call Hloop_SA_Q(ntryL,G1H32(1286),ex3(:),G1H16(1),ngH,m3h2x16(:,1286),heltab2x32(:,:,1286))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1286),n2h16(1286))
  call Hloop_SA_Q(ntryL,G1H32(1287),ex3(:),G1H16(1),ngX,m3h2x16(:,1287),heltab2x32(:,:,1287))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1287),n2h16(1287))
  call Hloop_SA_Q(ntryL,G1H32(1288),ex3(:),G1H16(1),ngX,m3h2x16(:,1288),heltab2x32(:,:,1288))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1288),n2h16(1288))
  call Hloop_VA_Q(ntryL,G1H32(1289),ex3(:),G1H16(1),m3h2x16(:,1289),heltab2x32(:,:,1289))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1289),n2h16(1289))
  call Hloop_ZA_Q(ntryL,G1H32(1290),ex3(:),G1H16(1),ngZl,m3h2x16(:,1290),heltab2x32(:,:,1290))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1290),n2h16(1290))
  call Hloop_VA_Q(ntryL,G1H32(1291),ex3(:),G1H16(1),m3h2x16(:,1291),heltab2x32(:,:,1291))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1291),n2h16(1291))
  call Hloop_VA_Q(ntryL,G1H32(1292),ex3(:),G1H16(1),m3h2x16(:,1292),heltab2x32(:,:,1292))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1292),n2h16(1292))
  call Hloop_ZA_Q(ntryL,G1H32(1293),ex3(:),G1H16(1),ngZl,m3h2x16(:,1293),heltab2x32(:,:,1293))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1293),n2h16(1293))
  call Hloop_ZA_Q(ntryL,G1H32(1294),ex3(:),G1H16(1),ngZl,m3h2x16(:,1294),heltab2x32(:,:,1294))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1294),n2h16(1294))
  call Hloop_VA_Q(ntryL,G1H32(1295),ex3(:),G1H16(1),m3h2x16(:,1295),heltab2x32(:,:,1295))
  call Hloop_A_Q(ntryL,G1H16(1),84,nME,G2H16(1295),n2h16(1295))
  call Hloop_SQ_A(ntryL,G1H32(1296),ex2(:),G1H16(1),ngH,m3h2x16(:,1296),heltab2x32(:,:,1296))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1296),n2h16(1296))
  call Hloop_SQ_A(ntryL,G1H32(1297),ex2(:),G1H16(1),ngX,m3h2x16(:,1297),heltab2x32(:,:,1297))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1297),n2h16(1297))
  call Hloop_SQ_A(ntryL,G1H32(1298),ex2(:),G1H16(1),ngH,m3h2x16(:,1298),heltab2x32(:,:,1298))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1298),n2h16(1298))
  call Hloop_SQ_A(ntryL,G1H32(1299),ex2(:),G1H16(1),ngX,m3h2x16(:,1299),heltab2x32(:,:,1299))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1299),n2h16(1299))
  call Hloop_VQ_A(ntryL,G1H32(1300),ex2(:),G1H16(1),m3h2x16(:,1300),heltab2x32(:,:,1300))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1300),n2h16(1300))
  call Hloop_VQ_A(ntryL,G1H32(1301),ex2(:),G1H16(1),m3h2x16(:,1301),heltab2x32(:,:,1301))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1301),n2h16(1301))
  call Hloop_VQ_A(ntryL,G1H32(1302),ex2(:),G1H16(1),m3h2x16(:,1302),heltab2x32(:,:,1302))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1302),n2h16(1302))
  call Hloop_VQ_A(ntryL,G1H32(1303),ex2(:),G1H16(1),m3h2x16(:,1303),heltab2x32(:,:,1303))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1303),n2h16(1303))
  call Hloop_SQ_A(ntryL,G1H32(1304),ex2(:),G1H16(1),ngH,m3h2x16(:,1304),heltab2x32(:,:,1304))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1304),n2h16(1304))
  call Hloop_SQ_A(ntryL,G1H32(1305),ex2(:),G1H16(1),ngH,m3h2x16(:,1305),heltab2x32(:,:,1305))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1305),n2h16(1305))
  call Hloop_SQ_A(ntryL,G1H32(1306),ex2(:),G1H16(1),ngX,m3h2x16(:,1306),heltab2x32(:,:,1306))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1306),n2h16(1306))
  call Hloop_SQ_A(ntryL,G1H32(1307),ex2(:),G1H16(1),ngX,m3h2x16(:,1307),heltab2x32(:,:,1307))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1307),n2h16(1307))
  call Hloop_VQ_A(ntryL,G1H32(1308),ex2(:),G1H16(1),m3h2x16(:,1308),heltab2x32(:,:,1308))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1308),n2h16(1308))
  call Hloop_VQ_A(ntryL,G1H32(1309),ex2(:),G1H16(1),m3h2x16(:,1309),heltab2x32(:,:,1309))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1309),n2h16(1309))
  call Hloop_VQ_A(ntryL,G1H32(1310),ex2(:),G1H16(1),m3h2x16(:,1310),heltab2x32(:,:,1310))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1310),n2h16(1310))
  call Hloop_ZQ_A(ntryL,G1H32(1311),ex2(:),G1H16(1),ngZl,m3h2x16(:,1311),heltab2x32(:,:,1311))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1311),n2h16(1311))
  call Hloop_VQ_A(ntryL,G1H32(1312),ex2(:),G1H16(1),m3h2x16(:,1312),heltab2x32(:,:,1312))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1312),n2h16(1312))
  call Hloop_ZQ_A(ntryL,G1H32(1313),ex2(:),G1H16(1),ngZl,m3h2x16(:,1313),heltab2x32(:,:,1313))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1313),n2h16(1313))
  call Hloop_SQ_A(ntryL,G1H32(1314),ex2(:),G1H16(1),ngH,m3h2x16(:,1314),heltab2x32(:,:,1314))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1314),n2h16(1314))
  call Hloop_SQ_A(ntryL,G1H32(1315),ex2(:),G1H16(1),ngX,m3h2x16(:,1315),heltab2x32(:,:,1315))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1315),n2h16(1315))
  call Hloop_SQ_A(ntryL,G1H32(1316),ex2(:),G1H16(1),ngH,m3h2x16(:,1316),heltab2x32(:,:,1316))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1316),n2h16(1316))
  call Hloop_SQ_A(ntryL,G1H32(1317),ex2(:),G1H16(1),ngH,m3h2x16(:,1317),heltab2x32(:,:,1317))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1317),n2h16(1317))
  call Hloop_SQ_A(ntryL,G1H32(1318),ex2(:),G1H16(1),ngX,m3h2x16(:,1318),heltab2x32(:,:,1318))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1318),n2h16(1318))
  call Hloop_SQ_A(ntryL,G1H32(1319),ex2(:),G1H16(1),ngX,m3h2x16(:,1319),heltab2x32(:,:,1319))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1319),n2h16(1319))
  call Hloop_VQ_A(ntryL,G1H32(1320),ex2(:),G1H16(1),m3h2x16(:,1320),heltab2x32(:,:,1320))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1320),n2h16(1320))
  call Hloop_VQ_A(ntryL,G1H32(1321),ex2(:),G1H16(1),m3h2x16(:,1321),heltab2x32(:,:,1321))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1321),n2h16(1321))
  call Hloop_ZQ_A(ntryL,G1H32(1322),ex2(:),G1H16(1),ngZl,m3h2x16(:,1322),heltab2x32(:,:,1322))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1322),n2h16(1322))
  call Hloop_VQ_A(ntryL,G1H32(1323),ex2(:),G1H16(1),m3h2x16(:,1323),heltab2x32(:,:,1323))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1323),n2h16(1323))
  call Hloop_ZQ_A(ntryL,G1H32(1324),ex2(:),G1H16(1),ngZl,m3h2x16(:,1324),heltab2x32(:,:,1324))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1324),n2h16(1324))
  call Hloop_VQ_A(ntryL,G1H32(1325),ex2(:),G1H16(1),m3h2x16(:,1325),heltab2x32(:,:,1325))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1325),n2h16(1325))
  call Hloop_VQ_A(ntryL,G1H32(1326),ex2(:),G1H16(1),m3h2x16(:,1326),heltab2x32(:,:,1326))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1326),n2h16(1326))
  call Hloop_VQ_A(ntryL,G1H32(1327),ex2(:),G1H16(1),m3h2x16(:,1327),heltab2x32(:,:,1327))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1327),n2h16(1327))
  call Hloop_ZQ_A(ntryL,G1H32(1328),ex2(:),G1H16(1),ngZl,m3h2x16(:,1328),heltab2x32(:,:,1328))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1328),n2h16(1328))
  call Hloop_VQ_A(ntryL,G1H32(1329),ex2(:),G1H16(1),m3h2x16(:,1329),heltab2x32(:,:,1329))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1329),n2h16(1329))
  call Hloop_ZQ_A(ntryL,G1H32(1330),ex2(:),G1H16(1),ngZl,m3h2x16(:,1330),heltab2x32(:,:,1330))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1330),n2h16(1330))
  call Hloop_VQ_A(ntryL,G1H32(1331),ex2(:),G1H16(1),m3h2x16(:,1331),heltab2x32(:,:,1331))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1331),n2h16(1331))
  call Hloop_ZQ_A(ntryL,G1H32(1332),ex2(:),G1H16(1),ngZl,m3h2x16(:,1332),heltab2x32(:,:,1332))
  call Hloop_Q_A(ntryL,G1H16(1),82,nME,G2H16(1332),n2h16(1332))
  call Hloop_SA_Q(ntryL,G1H32(1333),ex4(:),G1H16(1),ngH,m3h2x16(:,1333),heltab2x32(:,:,1333))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1333),n2h16(1333))
  call Hloop_SA_Q(ntryL,G1H32(1334),ex4(:),G1H16(1),ngX,m3h2x16(:,1334),heltab2x32(:,:,1334))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1334),n2h16(1334))
  call Hloop_SA_Q(ntryL,G1H32(1335),ex4(:),G1H16(1),ngH,m3h2x16(:,1335),heltab2x32(:,:,1335))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1335),n2h16(1335))
  call Hloop_SA_Q(ntryL,G1H32(1336),ex4(:),G1H16(1),ngX,m3h2x16(:,1336),heltab2x32(:,:,1336))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1336),n2h16(1336))
  call Hloop_VA_Q(ntryL,G1H32(1337),ex4(:),G1H16(1),m3h2x16(:,1337),heltab2x32(:,:,1337))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1337),n2h16(1337))
  call Hloop_VA_Q(ntryL,G1H32(1338),ex4(:),G1H16(1),m3h2x16(:,1338),heltab2x32(:,:,1338))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1338),n2h16(1338))
  call Hloop_VA_Q(ntryL,G1H32(1339),ex4(:),G1H16(1),m3h2x16(:,1339),heltab2x32(:,:,1339))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1339),n2h16(1339))
  call Hloop_VA_Q(ntryL,G1H32(1340),ex4(:),G1H16(1),m3h2x16(:,1340),heltab2x32(:,:,1340))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1340),n2h16(1340))
  call Hloop_SA_Q(ntryL,G1H32(1341),ex4(:),G1H16(1),ngH,m3h2x16(:,1341),heltab2x32(:,:,1341))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1341),n2h16(1341))
  call Hloop_SA_Q(ntryL,G1H32(1342),ex4(:),G1H16(1),ngH,m3h2x16(:,1342),heltab2x32(:,:,1342))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1342),n2h16(1342))
  call Hloop_SA_Q(ntryL,G1H32(1343),ex4(:),G1H16(1),ngX,m3h2x16(:,1343),heltab2x32(:,:,1343))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1343),n2h16(1343))
  call Hloop_SA_Q(ntryL,G1H32(1344),ex4(:),G1H16(1),ngX,m3h2x16(:,1344),heltab2x32(:,:,1344))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1344),n2h16(1344))
  call Hloop_VA_Q(ntryL,G1H32(1345),ex4(:),G1H16(1),m3h2x16(:,1345),heltab2x32(:,:,1345))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1345),n2h16(1345))
  call Hloop_VA_Q(ntryL,G1H32(1346),ex4(:),G1H16(1),m3h2x16(:,1346),heltab2x32(:,:,1346))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1346),n2h16(1346))
  call Hloop_VA_Q(ntryL,G1H32(1347),ex4(:),G1H16(1),m3h2x16(:,1347),heltab2x32(:,:,1347))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1347),n2h16(1347))
  call Hloop_ZA_Q(ntryL,G1H32(1348),ex4(:),G1H16(1),ngZl,m3h2x16(:,1348),heltab2x32(:,:,1348))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1348),n2h16(1348))
  call Hloop_VA_Q(ntryL,G1H32(1349),ex4(:),G1H16(1),m3h2x16(:,1349),heltab2x32(:,:,1349))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1349),n2h16(1349))
  call Hloop_ZA_Q(ntryL,G1H32(1350),ex4(:),G1H16(1),ngZl,m3h2x16(:,1350),heltab2x32(:,:,1350))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1350),n2h16(1350))
  call Hloop_SA_Q(ntryL,G1H32(1351),ex4(:),G1H16(1),ngH,m3h2x16(:,1351),heltab2x32(:,:,1351))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1351),n2h16(1351))
  call Hloop_SA_Q(ntryL,G1H32(1352),ex4(:),G1H16(1),ngX,m3h2x16(:,1352),heltab2x32(:,:,1352))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1352),n2h16(1352))
  call Hloop_SA_Q(ntryL,G1H32(1353),ex4(:),G1H16(1),ngH,m3h2x16(:,1353),heltab2x32(:,:,1353))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1353),n2h16(1353))
  call Hloop_SA_Q(ntryL,G1H32(1354),ex4(:),G1H16(1),ngH,m3h2x16(:,1354),heltab2x32(:,:,1354))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1354),n2h16(1354))
  call Hloop_SA_Q(ntryL,G1H32(1355),ex4(:),G1H16(1),ngX,m3h2x16(:,1355),heltab2x32(:,:,1355))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1355),n2h16(1355))
  call Hloop_SA_Q(ntryL,G1H32(1356),ex4(:),G1H16(1),ngX,m3h2x16(:,1356),heltab2x32(:,:,1356))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1356),n2h16(1356))
  call Hloop_VA_Q(ntryL,G1H32(1357),ex4(:),G1H16(1),m3h2x16(:,1357),heltab2x32(:,:,1357))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1357),n2h16(1357))
  call Hloop_VA_Q(ntryL,G1H32(1358),ex4(:),G1H16(1),m3h2x16(:,1358),heltab2x32(:,:,1358))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1358),n2h16(1358))
  call Hloop_ZA_Q(ntryL,G1H32(1359),ex4(:),G1H16(1),ngZl,m3h2x16(:,1359),heltab2x32(:,:,1359))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1359),n2h16(1359))
  call Hloop_VA_Q(ntryL,G1H32(1360),ex4(:),G1H16(1),m3h2x16(:,1360),heltab2x32(:,:,1360))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1360),n2h16(1360))
  call Hloop_ZA_Q(ntryL,G1H32(1361),ex4(:),G1H16(1),ngZl,m3h2x16(:,1361),heltab2x32(:,:,1361))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1361),n2h16(1361))
  call Hloop_VA_Q(ntryL,G1H32(1362),ex4(:),G1H16(1),m3h2x16(:,1362),heltab2x32(:,:,1362))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1362),n2h16(1362))
  call Hloop_VA_Q(ntryL,G1H32(1363),ex4(:),G1H16(1),m3h2x16(:,1363),heltab2x32(:,:,1363))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1363),n2h16(1363))
  call Hloop_VA_Q(ntryL,G1H32(1364),ex4(:),G1H16(1),m3h2x16(:,1364),heltab2x32(:,:,1364))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1364),n2h16(1364))
  call Hloop_ZA_Q(ntryL,G1H32(1365),ex4(:),G1H16(1),ngZl,m3h2x16(:,1365),heltab2x32(:,:,1365))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1365),n2h16(1365))
  call Hloop_VA_Q(ntryL,G1H32(1366),ex4(:),G1H16(1),m3h2x16(:,1366),heltab2x32(:,:,1366))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1366),n2h16(1366))
  call Hloop_ZA_Q(ntryL,G1H32(1367),ex4(:),G1H16(1),ngZl,m3h2x16(:,1367),heltab2x32(:,:,1367))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1367),n2h16(1367))
  call Hloop_VA_Q(ntryL,G1H32(1368),ex4(:),G1H16(1),m3h2x16(:,1368),heltab2x32(:,:,1368))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1368),n2h16(1368))
  call Hloop_ZA_Q(ntryL,G1H32(1369),ex4(:),G1H16(1),ngZl,m3h2x16(:,1369),heltab2x32(:,:,1369))
  call Hloop_A_Q(ntryL,G1H16(1),74,nME,G2H16(1369),n2h16(1369))
  call Hloop_SQ_A(ntryL,G1H32(1370),ex5(:),G1H16(1),ngH,m3h2x16(:,1370),heltab2x32(:,:,1370))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1370),n2h16(1370))
  call Hloop_SQ_A(ntryL,G1H32(1371),ex5(:),G1H16(1),ngX,m3h2x16(:,1371),heltab2x32(:,:,1371))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1371),n2h16(1371))
  call Hloop_SQ_A(ntryL,G1H32(1372),ex5(:),G1H16(1),ngH,m3h2x16(:,1372),heltab2x32(:,:,1372))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1372),n2h16(1372))
  call Hloop_SQ_A(ntryL,G1H32(1373),ex5(:),G1H16(1),ngX,m3h2x16(:,1373),heltab2x32(:,:,1373))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1373),n2h16(1373))
  call Hloop_VQ_A(ntryL,G1H32(1374),ex5(:),G1H16(1),m3h2x16(:,1374),heltab2x32(:,:,1374))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1374),n2h16(1374))
  call Hloop_VQ_A(ntryL,G1H32(1375),ex5(:),G1H16(1),m3h2x16(:,1375),heltab2x32(:,:,1375))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1375),n2h16(1375))
  call Hloop_VQ_A(ntryL,G1H32(1376),ex5(:),G1H16(1),m3h2x16(:,1376),heltab2x32(:,:,1376))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1376),n2h16(1376))
  call Hloop_VQ_A(ntryL,G1H32(1377),ex5(:),G1H16(1),m3h2x16(:,1377),heltab2x32(:,:,1377))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1377),n2h16(1377))
  call Hloop_SQ_A(ntryL,G1H32(1378),ex5(:),G1H16(1),ngH,m3h2x16(:,1378),heltab2x32(:,:,1378))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1378),n2h16(1378))
  call Hloop_SQ_A(ntryL,G1H32(1379),ex5(:),G1H16(1),ngH,m3h2x16(:,1379),heltab2x32(:,:,1379))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1379),n2h16(1379))
  call Hloop_SQ_A(ntryL,G1H32(1380),ex5(:),G1H16(1),ngX,m3h2x16(:,1380),heltab2x32(:,:,1380))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1380),n2h16(1380))
  call Hloop_SQ_A(ntryL,G1H32(1381),ex5(:),G1H16(1),ngX,m3h2x16(:,1381),heltab2x32(:,:,1381))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1381),n2h16(1381))
  call Hloop_VQ_A(ntryL,G1H32(1382),ex5(:),G1H16(1),m3h2x16(:,1382),heltab2x32(:,:,1382))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1382),n2h16(1382))
  call Hloop_VQ_A(ntryL,G1H32(1383),ex5(:),G1H16(1),m3h2x16(:,1383),heltab2x32(:,:,1383))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1383),n2h16(1383))
  call Hloop_VQ_A(ntryL,G1H32(1384),ex5(:),G1H16(1),m3h2x16(:,1384),heltab2x32(:,:,1384))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1384),n2h16(1384))
  call Hloop_ZQ_A(ntryL,G1H32(1385),ex5(:),G1H16(1),ngZl,m3h2x16(:,1385),heltab2x32(:,:,1385))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1385),n2h16(1385))
  call Hloop_VQ_A(ntryL,G1H32(1386),ex5(:),G1H16(1),m3h2x16(:,1386),heltab2x32(:,:,1386))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1386),n2h16(1386))
  call Hloop_ZQ_A(ntryL,G1H32(1387),ex5(:),G1H16(1),ngZl,m3h2x16(:,1387),heltab2x32(:,:,1387))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1387),n2h16(1387))
  call Hloop_SQ_A(ntryL,G1H32(1388),ex5(:),G1H16(1),ngH,m3h2x16(:,1388),heltab2x32(:,:,1388))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1388),n2h16(1388))
  call Hloop_SQ_A(ntryL,G1H32(1389),ex5(:),G1H16(1),ngX,m3h2x16(:,1389),heltab2x32(:,:,1389))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1389),n2h16(1389))
  call Hloop_SQ_A(ntryL,G1H32(1390),ex5(:),G1H16(1),ngH,m3h2x16(:,1390),heltab2x32(:,:,1390))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1390),n2h16(1390))
  call Hloop_SQ_A(ntryL,G1H32(1391),ex5(:),G1H16(1),ngH,m3h2x16(:,1391),heltab2x32(:,:,1391))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1391),n2h16(1391))
  call Hloop_SQ_A(ntryL,G1H32(1392),ex5(:),G1H16(1),ngX,m3h2x16(:,1392),heltab2x32(:,:,1392))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1392),n2h16(1392))
  call Hloop_SQ_A(ntryL,G1H32(1393),ex5(:),G1H16(1),ngX,m3h2x16(:,1393),heltab2x32(:,:,1393))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1393),n2h16(1393))
  call Hloop_VQ_A(ntryL,G1H32(1394),ex5(:),G1H16(1),m3h2x16(:,1394),heltab2x32(:,:,1394))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1394),n2h16(1394))
  call Hloop_VQ_A(ntryL,G1H32(1395),ex5(:),G1H16(1),m3h2x16(:,1395),heltab2x32(:,:,1395))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1395),n2h16(1395))
  call Hloop_ZQ_A(ntryL,G1H32(1396),ex5(:),G1H16(1),ngZl,m3h2x16(:,1396),heltab2x32(:,:,1396))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1396),n2h16(1396))
  call Hloop_VQ_A(ntryL,G1H32(1397),ex5(:),G1H16(1),m3h2x16(:,1397),heltab2x32(:,:,1397))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1397),n2h16(1397))
  call Hloop_ZQ_A(ntryL,G1H32(1398),ex5(:),G1H16(1),ngZl,m3h2x16(:,1398),heltab2x32(:,:,1398))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1398),n2h16(1398))
  call Hloop_VQ_A(ntryL,G1H32(1399),ex5(:),G1H16(1),m3h2x16(:,1399),heltab2x32(:,:,1399))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1399),n2h16(1399))
  call Hloop_VQ_A(ntryL,G1H32(1400),ex5(:),G1H16(1),m3h2x16(:,1400),heltab2x32(:,:,1400))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1400),n2h16(1400))
  call Hloop_VQ_A(ntryL,G1H32(1401),ex5(:),G1H16(1),m3h2x16(:,1401),heltab2x32(:,:,1401))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1401),n2h16(1401))
  call Hloop_ZQ_A(ntryL,G1H32(1402),ex5(:),G1H16(1),ngZl,m3h2x16(:,1402),heltab2x32(:,:,1402))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1402),n2h16(1402))
  call Hloop_VQ_A(ntryL,G1H32(1403),ex5(:),G1H16(1),m3h2x16(:,1403),heltab2x32(:,:,1403))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1403),n2h16(1403))
  call Hloop_ZQ_A(ntryL,G1H32(1404),ex5(:),G1H16(1),ngZl,m3h2x16(:,1404),heltab2x32(:,:,1404))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1404),n2h16(1404))
  call Hloop_VQ_A(ntryL,G1H32(1405),ex5(:),G1H16(1),m3h2x16(:,1405),heltab2x32(:,:,1405))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1405),n2h16(1405))
  call Hloop_ZQ_A(ntryL,G1H32(1406),ex5(:),G1H16(1),ngZl,m3h2x16(:,1406),heltab2x32(:,:,1406))
  call Hloop_Q_A(ntryL,G1H16(1),82,nMM,G2H16(1406),n2h16(1406))
  call Hloop_SA_Q(ntryL,G1H32(1407),ex4(:),G1H16(1),ngH,m3h2x16(:,1407),heltab2x32(:,:,1407))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1407),n2h16(1407))
  call Hloop_SA_Q(ntryL,G1H32(1408),ex4(:),G1H16(1),ngH,m3h2x16(:,1408),heltab2x32(:,:,1408))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1408),n2h16(1408))
  call Hloop_SA_Q(ntryL,G1H32(1409),ex4(:),G1H16(1),ngX,m3h2x16(:,1409),heltab2x32(:,:,1409))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1409),n2h16(1409))
  call Hloop_SA_Q(ntryL,G1H32(1410),ex4(:),G1H16(1),ngX,m3h2x16(:,1410),heltab2x32(:,:,1410))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1410),n2h16(1410))
  call Hloop_SA_Q(ntryL,G1H32(1411),ex4(:),G1H16(1),ngH,m3h2x16(:,1411),heltab2x32(:,:,1411))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1411),n2h16(1411))
  call Hloop_SA_Q(ntryL,G1H32(1412),ex4(:),G1H16(1),ngH,m3h2x16(:,1412),heltab2x32(:,:,1412))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1412),n2h16(1412))
  call Hloop_SA_Q(ntryL,G1H32(1413),ex4(:),G1H16(1),ngX,m3h2x16(:,1413),heltab2x32(:,:,1413))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1413),n2h16(1413))
  call Hloop_SA_Q(ntryL,G1H32(1414),ex4(:),G1H16(1),ngX,m3h2x16(:,1414),heltab2x32(:,:,1414))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1414),n2h16(1414))
  call Hloop_VA_Q(ntryL,G1H32(1415),ex4(:),G1H16(1),m3h2x16(:,1415),heltab2x32(:,:,1415))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1415),n2h16(1415))
  call Hloop_VA_Q(ntryL,G1H32(1416),ex4(:),G1H16(1),m3h2x16(:,1416),heltab2x32(:,:,1416))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1416),n2h16(1416))
  call Hloop_VA_Q(ntryL,G1H32(1417),ex4(:),G1H16(1),m3h2x16(:,1417),heltab2x32(:,:,1417))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1417),n2h16(1417))
  call Hloop_VA_Q(ntryL,G1H32(1418),ex4(:),G1H16(1),m3h2x16(:,1418),heltab2x32(:,:,1418))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1418),n2h16(1418))
  call Hloop_SA_Q(ntryL,G1H32(1419),ex4(:),G1H16(1),ngH,m3h2x16(:,1419),heltab2x32(:,:,1419))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1419),n2h16(1419))
  call Hloop_SA_Q(ntryL,G1H32(1420),ex4(:),G1H16(1),ngX,m3h2x16(:,1420),heltab2x32(:,:,1420))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1420),n2h16(1420))
  call Hloop_SA_Q(ntryL,G1H32(1421),ex4(:),G1H16(1),ngH,m3h2x16(:,1421),heltab2x32(:,:,1421))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1421),n2h16(1421))
  call Hloop_SA_Q(ntryL,G1H32(1422),ex4(:),G1H16(1),ngH,m3h2x16(:,1422),heltab2x32(:,:,1422))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1422),n2h16(1422))
  call Hloop_SA_Q(ntryL,G1H32(1423),ex4(:),G1H16(1),ngX,m3h2x16(:,1423),heltab2x32(:,:,1423))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1423),n2h16(1423))
  call Hloop_SA_Q(ntryL,G1H32(1424),ex4(:),G1H16(1),ngX,m3h2x16(:,1424),heltab2x32(:,:,1424))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1424),n2h16(1424))
  call Hloop_VA_Q(ntryL,G1H32(1425),ex4(:),G1H16(1),m3h2x16(:,1425),heltab2x32(:,:,1425))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1425),n2h16(1425))
  call Hloop_VA_Q(ntryL,G1H32(1426),ex4(:),G1H16(1),m3h2x16(:,1426),heltab2x32(:,:,1426))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1426),n2h16(1426))
  call Hloop_VA_Q(ntryL,G1H32(1427),ex4(:),G1H16(1),m3h2x16(:,1427),heltab2x32(:,:,1427))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1427),n2h16(1427))
  call Hloop_ZA_Q(ntryL,G1H32(1428),ex4(:),G1H16(1),ngZl,m3h2x16(:,1428),heltab2x32(:,:,1428))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1428),n2h16(1428))
  call Hloop_VA_Q(ntryL,G1H32(1429),ex4(:),G1H16(1),m3h2x16(:,1429),heltab2x32(:,:,1429))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1429),n2h16(1429))
  call Hloop_ZA_Q(ntryL,G1H32(1430),ex4(:),G1H16(1),ngZl,m3h2x16(:,1430),heltab2x32(:,:,1430))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1430),n2h16(1430))
  call Hloop_VA_Q(ntryL,G1H32(1431),ex4(:),G1H16(1),m3h2x16(:,1431),heltab2x32(:,:,1431))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1431),n2h16(1431))
  call Hloop_VA_Q(ntryL,G1H32(1432),ex4(:),G1H16(1),m3h2x16(:,1432),heltab2x32(:,:,1432))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1432),n2h16(1432))
  call Hloop_VA_Q(ntryL,G1H32(1433),ex4(:),G1H16(1),m3h2x16(:,1433),heltab2x32(:,:,1433))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1433),n2h16(1433))
  call Hloop_ZA_Q(ntryL,G1H32(1434),ex4(:),G1H16(1),ngZl,m3h2x16(:,1434),heltab2x32(:,:,1434))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1434),n2h16(1434))
  call Hloop_VA_Q(ntryL,G1H32(1435),ex4(:),G1H16(1),m3h2x16(:,1435),heltab2x32(:,:,1435))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1435),n2h16(1435))
  call Hloop_ZA_Q(ntryL,G1H32(1436),ex4(:),G1H16(1),ngZl,m3h2x16(:,1436),heltab2x32(:,:,1436))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1436),n2h16(1436))
  call Hloop_VA_Q(ntryL,G1H32(1437),ex4(:),G1H16(1),m3h2x16(:,1437),heltab2x32(:,:,1437))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1437),n2h16(1437))
  call Hloop_VA_Q(ntryL,G1H32(1438),ex4(:),G1H16(1),m3h2x16(:,1438),heltab2x32(:,:,1438))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1438),n2h16(1438))
  call Hloop_VA_Q(ntryL,G1H32(1439),ex4(:),G1H16(1),m3h2x16(:,1439),heltab2x32(:,:,1439))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1439),n2h16(1439))
  call Hloop_ZA_Q(ntryL,G1H32(1440),ex4(:),G1H16(1),ngZl,m3h2x16(:,1440),heltab2x32(:,:,1440))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1440),n2h16(1440))
  call Hloop_VA_Q(ntryL,G1H32(1441),ex4(:),G1H16(1),m3h2x16(:,1441),heltab2x32(:,:,1441))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1441),n2h16(1441))
  call Hloop_ZA_Q(ntryL,G1H32(1442),ex4(:),G1H16(1),ngZl,m3h2x16(:,1442),heltab2x32(:,:,1442))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1442),n2h16(1442))
  call Hloop_ZA_Q(ntryL,G1H32(1443),ex4(:),G1H16(1),ngZl,m3h2x16(:,1443),heltab2x32(:,:,1443))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1443),n2h16(1443))
  call Hloop_SA_Q(ntryL,G1H32(1444),ex4(:),G1H16(1),ngH,m3h2x16(:,1444),heltab2x32(:,:,1444))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1444),n2h16(1444))
  call Hloop_SA_Q(ntryL,G1H32(1445),ex4(:),G1H16(1),ngH,m3h2x16(:,1445),heltab2x32(:,:,1445))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1445),n2h16(1445))
  call Hloop_SA_Q(ntryL,G1H32(1446),ex4(:),G1H16(1),ngX,m3h2x16(:,1446),heltab2x32(:,:,1446))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1446),n2h16(1446))
  call Hloop_SA_Q(ntryL,G1H32(1447),ex4(:),G1H16(1),ngX,m3h2x16(:,1447),heltab2x32(:,:,1447))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1447),n2h16(1447))
  call Hloop_SA_Q(ntryL,G1H32(1448),ex4(:),G1H16(1),ngH,m3h2x16(:,1448),heltab2x32(:,:,1448))
  call Hloop_A_Q(ntryL,G1H16(1),73,nME,G2H16(1448),n2h16(1448))


! end do

end subroutine vamp_1

end module ol_vamp_1_eeeemma_ew_eeexexmmxa_1_/**/REALKIND
