module ol_external_eeeemma_ew_eeexexmmxa_1
! 
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_eeeemma_ew_eeexexmmxa_1(7) = &
                     [ (dummy_counter, dummy_counter = 1, 7) ]
  integer, save :: external_perm_inv_eeeemma_ew_eeexexmmxa_1(7) = &
                     [ (dummy_counter, dummy_counter = 1, 7) ]
  integer, save :: extcomb_perm_eeeemma_ew_eeexexmmxa_1(0:29) = &
                     [ (dummy_counter, dummy_counter = 0, 29) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_eeeemma_ew_eeexexmmxa_1(7) = &
                     [ 1, 1, 2, 2, 3, 4, 5 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_eeeemma_ew_eeexexmmxa_1(7) = &
                     [ 2, 2, 2, 2, 2, 2, 2 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_eeeemma_ew_eeexexmmxa_1 = &
                     8
  integer, save :: channel_number_eeeemma_ew_eeexexmmxa_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(7,128) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(128,7)
  integer, save :: POLSEL(7) = 0
  integer, save :: photonid_eeeemma_ew_eeexexmmxa_1(7) = 0

  
  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_eeeemma_ew_eeexexmmxa_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 7
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_eeeemma_ew_eeexexmmxa_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 7
  end subroutine n_external_c

  subroutine averagefactor_c(avgf) &
      & bind(c,name="ol_averagefactor_eeeemma_ew_eeexexmmxa_1")
    use KIND_TYPES, only: DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: avgf
    avgf = average_factor_eeeemma_ew_eeexexmmxa_1
  end subroutine averagefactor_c

  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_eeeemma_ew_eeexexmmxa_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(7)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_eeeemma_ew_eeexexmmxa_1(7)
    external_perm_eeeemma_ew_eeexexmmxa_1 = perm
    do i = 1, 7
      external_perm_inv_eeeemma_ew_eeexexmmxa_1( &
        external_perm_eeeemma_ew_eeexexmmxa_1(i)) = i
      particle_types_perm_eeeemma_ew_eeexexmmxa_1(i) = &
        particle_types_eeeemma_ew_eeexexmmxa_1( &
        external_perm_eeeemma_ew_eeexexmmxa_1(i))
    end do
    do i = 1, 7
      do j = 1, i
        if (external_perm_eeeemma_ew_eeexexmmxa_1(i) >= &
          external_perm_eeeemma_ew_eeexexmmxa_1(j)) then
          ii = external_perm_eeeemma_ew_eeexexmmxa_1(i)
          jj = external_perm_eeeemma_ew_eeexexmmxa_1(j)
        else
          ii = external_perm_eeeemma_ew_eeexexmmxa_1(j)
          jj = external_perm_eeeemma_ew_eeexexmmxa_1(i)
        end if
        extcomb_perm_eeeemma_ew_eeexexmmxa_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_eeeemma_ew_eeexexmmxa_1 = 1
    do i = 1, n_scatt
      average_factor_eeeemma_ew_eeexexmmxa_1 = &
        average_factor_eeeemma_ew_eeexexmmxa_1 &
        * average_factors_eeeemma_ew_eeexexmmxa_1( &
        external_perm_eeeemma_ew_eeexexmmxa_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 7
        average_factor_eeeemma_ew_eeexexmmxa_1 = &
          average_factor_eeeemma_ew_eeexexmmxa_1 &
          * factorial(count(particle_types_perm_eeeemma_ew_eeexexmmxa_1(n_scatt+1:7) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_eeeemma_ew_eeexexmmxa_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(7)
    integer :: f_perm(7)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_last_perm(perm) &
      & bind(c,name="ol_f_get_last_perm_eeeemma_ew_eeexexmmxa_1")
    integer, intent(out) :: perm(7)
    perm = external_perm_eeeemma_ew_eeexexmmxa_1
  end subroutine get_last_perm


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_eeeemma_ew_eeexexmmxa_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(7)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(7)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rME_unscaled, rME_unscaled, rME_unscaled, rME_unscaled, rMM_unscaled, rMM_unscaled, rZERO ]
    do i = 1, 7
      m_ex(i) = m_ex_orig(external_perm_eeeemma_ew_eeexexmmxa_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_eeeemma_ew_eeexexmmxa_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(7)
    real(DREALKIND) :: f_m_ex(7)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine get_types(t_ex) &
      & bind(c,name="ol_f_get_types_eeeemma_ew_eeexexmmxa_1")
    ! Return the type of the external particles in the current permutation.
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    integer, intent(out) :: t_ex(7)
    integer        :: i
    integer :: t_ex_orig(7)
    ! External particle masses for in the identity permutation
    t_ex_orig = [3,3,3,3,3,3,-1]
    do i = 1, 7
      t_ex(i) = t_ex_orig(external_perm_eeeemma_ew_eeexexmmxa_1(i))
    end do
  end subroutine get_types


  subroutine get_types_c(t_ex) &
      & bind(c,name="ol_get_types_eeeemma_ew_eeexexmmxa_1")
    use, intrinsic :: iso_c_binding, only: c_int
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    integer(c_int), intent(out) :: t_ex(7)
    integer :: f_t_ex(7)
    call get_types(f_t_ex)
    t_ex = f_t_ex
  end subroutine get_types_c


  subroutine get_charges(c_ex) &
      & bind(c,name="ol_f_get_charges_eeeemma_ew_eeexexmmxa_1")
    ! Return the type of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: c_ex(7)
    integer        :: i
    real(DREALKIND) :: c_ex_orig(7)
    ! External particle masses for in the identity permutation
    c_ex_orig = [-1,-1,1,1,-1,1,0]/1._/**/REALKIND
    do i = 1, 7
      c_ex(i) = c_ex_orig(external_perm_eeeemma_ew_eeexexmmxa_1(i))
    end do
  end subroutine get_charges


  subroutine get_charges_c(c_ex) &
      & bind(c,name="ol_get_charge_eeeemma_ew_eeexexmmxa_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: c_ex(7)
    real(DREALKIND) :: f_c_ex(7)
    call get_charges(f_c_ex)
    c_ex = f_c_ex
  end subroutine get_charges_c



  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_eeeemma_ew_eeexexmmxa_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,7)
    real(DREALKIND) :: m_ex(7)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_eeeemma_ew_eeexexmmxa_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,7)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,7)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:,  1) = [ -1, -1, -1, -1, -1, -1, -1 ]
  H(:,  2) = [ -1, -1, -1, -1, -1, -1,  1 ]
  H(:,  3) = [ -1, -1, -1, -1, -1,  1, -1 ]
  H(:,  4) = [ -1, -1, -1, -1, -1,  1,  1 ]
  H(:,  5) = [ -1, -1, -1, -1,  1, -1, -1 ]
  H(:,  6) = [ -1, -1, -1, -1,  1, -1,  1 ]
  H(:,  7) = [ -1, -1, -1, -1,  1,  1, -1 ]
  H(:,  8) = [ -1, -1, -1, -1,  1,  1,  1 ]
  H(:,  9) = [ -1, -1, -1,  1, -1, -1, -1 ]
  H(:, 10) = [ -1, -1, -1,  1, -1, -1,  1 ]
  H(:, 11) = [ -1, -1, -1,  1, -1,  1, -1 ]
  H(:, 12) = [ -1, -1, -1,  1, -1,  1,  1 ]
  H(:, 13) = [ -1, -1, -1,  1,  1, -1, -1 ]
  H(:, 14) = [ -1, -1, -1,  1,  1, -1,  1 ]
  H(:, 15) = [ -1, -1, -1,  1,  1,  1, -1 ]
  H(:, 16) = [ -1, -1, -1,  1,  1,  1,  1 ]
  H(:, 17) = [ -1, -1,  1, -1, -1, -1, -1 ]
  H(:, 18) = [ -1, -1,  1, -1, -1, -1,  1 ]
  H(:, 19) = [ -1, -1,  1, -1, -1,  1, -1 ]
  H(:, 20) = [ -1, -1,  1, -1, -1,  1,  1 ]
  H(:, 21) = [ -1, -1,  1, -1,  1, -1, -1 ]
  H(:, 22) = [ -1, -1,  1, -1,  1, -1,  1 ]
  H(:, 23) = [ -1, -1,  1, -1,  1,  1, -1 ]
  H(:, 24) = [ -1, -1,  1, -1,  1,  1,  1 ]
  H(:, 25) = [ -1, -1,  1,  1, -1, -1, -1 ]
  H(:, 26) = [ -1, -1,  1,  1, -1, -1,  1 ]
  H(:, 27) = [ -1, -1,  1,  1, -1,  1, -1 ]
  H(:, 28) = [ -1, -1,  1,  1, -1,  1,  1 ]
  H(:, 29) = [ -1, -1,  1,  1,  1, -1, -1 ]
  H(:, 30) = [ -1, -1,  1,  1,  1, -1,  1 ]
  H(:, 31) = [ -1, -1,  1,  1,  1,  1, -1 ]
  H(:, 32) = [ -1, -1,  1,  1,  1,  1,  1 ]
  H(:, 33) = [ -1,  1, -1, -1, -1, -1, -1 ]
  H(:, 34) = [ -1,  1, -1, -1, -1, -1,  1 ]
  H(:, 35) = [ -1,  1, -1, -1, -1,  1, -1 ]
  H(:, 36) = [ -1,  1, -1, -1, -1,  1,  1 ]
  H(:, 37) = [ -1,  1, -1, -1,  1, -1, -1 ]
  H(:, 38) = [ -1,  1, -1, -1,  1, -1,  1 ]
  H(:, 39) = [ -1,  1, -1, -1,  1,  1, -1 ]
  H(:, 40) = [ -1,  1, -1, -1,  1,  1,  1 ]
  H(:, 41) = [ -1,  1, -1,  1, -1, -1, -1 ]
  H(:, 42) = [ -1,  1, -1,  1, -1, -1,  1 ]
  H(:, 43) = [ -1,  1, -1,  1, -1,  1, -1 ]
  H(:, 44) = [ -1,  1, -1,  1, -1,  1,  1 ]
  H(:, 45) = [ -1,  1, -1,  1,  1, -1, -1 ]
  H(:, 46) = [ -1,  1, -1,  1,  1, -1,  1 ]
  H(:, 47) = [ -1,  1, -1,  1,  1,  1, -1 ]
  H(:, 48) = [ -1,  1, -1,  1,  1,  1,  1 ]
  H(:, 49) = [ -1,  1,  1, -1, -1, -1, -1 ]
  H(:, 50) = [ -1,  1,  1, -1, -1, -1,  1 ]
  H(:, 51) = [ -1,  1,  1, -1, -1,  1, -1 ]
  H(:, 52) = [ -1,  1,  1, -1, -1,  1,  1 ]
  H(:, 53) = [ -1,  1,  1, -1,  1, -1, -1 ]
  H(:, 54) = [ -1,  1,  1, -1,  1, -1,  1 ]
  H(:, 55) = [ -1,  1,  1, -1,  1,  1, -1 ]
  H(:, 56) = [ -1,  1,  1, -1,  1,  1,  1 ]
  H(:, 57) = [ -1,  1,  1,  1, -1, -1, -1 ]
  H(:, 58) = [ -1,  1,  1,  1, -1, -1,  1 ]
  H(:, 59) = [ -1,  1,  1,  1, -1,  1, -1 ]
  H(:, 60) = [ -1,  1,  1,  1, -1,  1,  1 ]
  H(:, 61) = [ -1,  1,  1,  1,  1, -1, -1 ]
  H(:, 62) = [ -1,  1,  1,  1,  1, -1,  1 ]
  H(:, 63) = [ -1,  1,  1,  1,  1,  1, -1 ]
  H(:, 64) = [ -1,  1,  1,  1,  1,  1,  1 ]
  H(:, 65) = [  1, -1, -1, -1, -1, -1, -1 ]
  H(:, 66) = [  1, -1, -1, -1, -1, -1,  1 ]
  H(:, 67) = [  1, -1, -1, -1, -1,  1, -1 ]
  H(:, 68) = [  1, -1, -1, -1, -1,  1,  1 ]
  H(:, 69) = [  1, -1, -1, -1,  1, -1, -1 ]
  H(:, 70) = [  1, -1, -1, -1,  1, -1,  1 ]
  H(:, 71) = [  1, -1, -1, -1,  1,  1, -1 ]
  H(:, 72) = [  1, -1, -1, -1,  1,  1,  1 ]
  H(:, 73) = [  1, -1, -1,  1, -1, -1, -1 ]
  H(:, 74) = [  1, -1, -1,  1, -1, -1,  1 ]
  H(:, 75) = [  1, -1, -1,  1, -1,  1, -1 ]
  H(:, 76) = [  1, -1, -1,  1, -1,  1,  1 ]
  H(:, 77) = [  1, -1, -1,  1,  1, -1, -1 ]
  H(:, 78) = [  1, -1, -1,  1,  1, -1,  1 ]
  H(:, 79) = [  1, -1, -1,  1,  1,  1, -1 ]
  H(:, 80) = [  1, -1, -1,  1,  1,  1,  1 ]
  H(:, 81) = [  1, -1,  1, -1, -1, -1, -1 ]
  H(:, 82) = [  1, -1,  1, -1, -1, -1,  1 ]
  H(:, 83) = [  1, -1,  1, -1, -1,  1, -1 ]
  H(:, 84) = [  1, -1,  1, -1, -1,  1,  1 ]
  H(:, 85) = [  1, -1,  1, -1,  1, -1, -1 ]
  H(:, 86) = [  1, -1,  1, -1,  1, -1,  1 ]
  H(:, 87) = [  1, -1,  1, -1,  1,  1, -1 ]
  H(:, 88) = [  1, -1,  1, -1,  1,  1,  1 ]
  H(:, 89) = [  1, -1,  1,  1, -1, -1, -1 ]
  H(:, 90) = [  1, -1,  1,  1, -1, -1,  1 ]
  H(:, 91) = [  1, -1,  1,  1, -1,  1, -1 ]
  H(:, 92) = [  1, -1,  1,  1, -1,  1,  1 ]
  H(:, 93) = [  1, -1,  1,  1,  1, -1, -1 ]
  H(:, 94) = [  1, -1,  1,  1,  1, -1,  1 ]
  H(:, 95) = [  1, -1,  1,  1,  1,  1, -1 ]
  H(:, 96) = [  1, -1,  1,  1,  1,  1,  1 ]
  H(:, 97) = [  1,  1, -1, -1, -1, -1, -1 ]
  H(:, 98) = [  1,  1, -1, -1, -1, -1,  1 ]
  H(:, 99) = [  1,  1, -1, -1, -1,  1, -1 ]
  H(:,100) = [  1,  1, -1, -1, -1,  1,  1 ]
  H(:,101) = [  1,  1, -1, -1,  1, -1, -1 ]
  H(:,102) = [  1,  1, -1, -1,  1, -1,  1 ]
  H(:,103) = [  1,  1, -1, -1,  1,  1, -1 ]
  H(:,104) = [  1,  1, -1, -1,  1,  1,  1 ]
  H(:,105) = [  1,  1, -1,  1, -1, -1, -1 ]
  H(:,106) = [  1,  1, -1,  1, -1, -1,  1 ]
  H(:,107) = [  1,  1, -1,  1, -1,  1, -1 ]
  H(:,108) = [  1,  1, -1,  1, -1,  1,  1 ]
  H(:,109) = [  1,  1, -1,  1,  1, -1, -1 ]
  H(:,110) = [  1,  1, -1,  1,  1, -1,  1 ]
  H(:,111) = [  1,  1, -1,  1,  1,  1, -1 ]
  H(:,112) = [  1,  1, -1,  1,  1,  1,  1 ]
  H(:,113) = [  1,  1,  1, -1, -1, -1, -1 ]
  H(:,114) = [  1,  1,  1, -1, -1, -1,  1 ]
  H(:,115) = [  1,  1,  1, -1, -1,  1, -1 ]
  H(:,116) = [  1,  1,  1, -1, -1,  1,  1 ]
  H(:,117) = [  1,  1,  1, -1,  1, -1, -1 ]
  H(:,118) = [  1,  1,  1, -1,  1, -1,  1 ]
  H(:,119) = [  1,  1,  1, -1,  1,  1, -1 ]
  H(:,120) = [  1,  1,  1, -1,  1,  1,  1 ]
  H(:,121) = [  1,  1,  1,  1, -1, -1, -1 ]
  H(:,122) = [  1,  1,  1,  1, -1, -1,  1 ]
  H(:,123) = [  1,  1,  1,  1, -1,  1, -1 ]
  H(:,124) = [  1,  1,  1,  1, -1,  1,  1 ]
  H(:,125) = [  1,  1,  1,  1,  1, -1, -1 ]
  H(:,126) = [  1,  1,  1,  1,  1, -1,  1 ]
  H(:,127) = [  1,  1,  1,  1,  1,  1, -1 ]
  H(:,128) = [  1,  1,  1,  1,  1,  1,  1 ]

  H_HC(:,7) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 128/1/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_eeeemma_ew_eeexexmmxa_1")
    implicit none
    integer, intent(in) :: pol(7)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_eeeemma_ew_eeexexmmxa_1")
    implicit none
    integer, intent(in) :: photon_id(7)
    photonid_eeeemma_ew_eeexexmmxa_1 = photon_id
  end subroutine set_photons




end module ol_external_eeeemma_ew_eeexexmmxa_1


module ol_settings_eeeemma_ew_eeexexmmxa_1
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.
  ! Calculate loop correlators
    logical, save :: loopcc = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_eeeemma_ew_eeexexmmxa_1")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

  subroutine set_loopcc(set,was) &
      & bind(c,name="ol_loopcc_eeeemma_ew_eeexexmmxa_1")
    implicit none
    logical, intent(in) :: set
    logical :: was
    was = loopcc
    loopcc = set
  end subroutine set_loopcc

end module ol_settings_eeeemma_ew_eeexexmmxa_1

module colour_basis_eeeemma_ew_eeexexmmxa_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(7) = [0,0,0,0,0,0,0]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_eeeemma_ew_eeexexmmxa_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(7)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 1
    ncoupl = 1
    maxpows = 1
    nhel = 128
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_eeeemma_ew_eeexexmmxa_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,1)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([0], [1,1])
#endif
#if 1 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,1,0], &
      [3,1])
#endif
  end subroutine tree_colbasis


  pure subroutine loop_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_loop_colbasis_dim_eeeemma_ew_eeexexmmxa_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(7)
    ! number of loop colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 1
    ncoupl = 1
    maxpows = 1
    nhel = 128
  end subroutine loop_colbasis_dim

  subroutine loop_colbasis(basis, powers) &
    & bind(c, name="ol_loop_colbasis_eeeemma_ew_eeexexmmxa_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,1)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([0], [1,1])
#endif
#if 1 > 0
    basis = 0 ! TODO
    ! loop colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
!    basis = reshape( &
!<\*colourbasis\*>, &
!      [3,1])
#endif
  end subroutine loop_colbasis


end module colour_basis_eeeemma_ew_eeexexmmxa_1

! **********************************************************************
module ol_heltables_OLR_eeeemma_ew_eeexexmmxa_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(2322), n3(3,28467), n4(4,28)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x4(2,4,52), t3x8(2,8,625), t3x16(2,16,2778), t3x32(2,32,4470), t3x128(2,128,20542), t4x32(3,32,28)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([2,2,4], n3(:,2), t3x4(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,3))
  n2(1) = 4
  call heltable([4,2,8], n3(:,4), t3x8(:,:,1))
  call heltable([4,4,16], n3(:,5), t3x16(:,:,1))
  n2(2) = 8
  call heltable([2,2,4], n3(:,6), t3x4(:,:,4))
  call heltable([4,4,16], n3(:,7), t3x16(:,:,2))
  call heltable([2,2,4], n3(:,8), t3x4(:,:,5))
  call heltable([4,2,8], n3(:,9), t3x8(:,:,2))
  n2(3) = 8
  call heltable([2,2,4], n3(:,10), t3x4(:,:,6))
  call heltable([4,4,16], n3(:,11), t3x16(:,:,3))
  call heltable([2,2,4], n3(:,12), t3x4(:,:,7))
  call heltable([4,4,16], n3(:,13), t3x16(:,:,4))
  call heltable([2,2,4], n3(:,14), t3x4(:,:,8))
  call heltable([2,4,8], n3(:,15), t3x8(:,:,3))
  n2(4) = 8
  call heltable([2,2,4], n3(:,16), t3x4(:,:,9))
  call heltable([2,4,8], n3(:,17), t3x8(:,:,4))
  n2(5) = 8
  call heltable([4,2,8], n3(:,18), t3x8(:,:,5))
  call heltable([4,4,16], n3(:,19), t3x16(:,:,5))
  n2(6) = 8
  call heltable([4,2,8], n3(:,20), t3x8(:,:,6))
  n2(7) = 8
  call heltable([4,4,16], n3(:,21), t3x16(:,:,6))
  call heltable([2,4,8], n3(:,22), t3x8(:,:,7))
  n2(8) = 8
  call heltable([2,4,8], n3(:,23), t3x8(:,:,8))
  n2(9) = 8
  call heltable([4,4,16], n3(:,24), t3x16(:,:,7))
  call heltable([4,4,16], n3(:,25), t3x16(:,:,8))
  call heltable([2,4,8], n3(:,26), t3x8(:,:,9))
  call heltable([4,4,16], n3(:,27), t3x16(:,:,9))
  call heltable([2,4,8], n3(:,28), t3x8(:,:,10))
  call heltable([4,4,16], n3(:,29), t3x16(:,:,10))
  call heltable([4,4,16], n3(:,30), t3x16(:,:,11))
  call heltable([4,4,16], n3(:,31), t3x16(:,:,12))
  call heltable([4,2,8], n3(:,32), t3x8(:,:,11))
  call heltable([4,4,16], n3(:,33), t3x16(:,:,13))
  call heltable([4,4,16], n3(:,34), t3x16(:,:,14))
  call heltable([4,4,16], n3(:,35), t3x16(:,:,15))
  call heltable([4,4,16], n3(:,36), t3x16(:,:,16))
  call heltable([4,4,16], n3(:,37), t3x16(:,:,17))
  call heltable([4,4,16], n3(:,38), t3x16(:,:,18))
  call heltable([4,4,16], n3(:,39), t3x16(:,:,19))
  call heltable([4,4,16], n3(:,40), t3x16(:,:,20))
  call heltable([4,4,16], n3(:,41), t3x16(:,:,21))
  call heltable([2,2,4], n3(:,42), t3x4(:,:,10))
  n2(10) = 4
  call heltable([2,4,8], n3(:,43), t3x8(:,:,12))
  call heltable([4,4,16], n3(:,44), t3x16(:,:,22))
  n2(11) = 8
  call heltable([4,4,16], n3(:,45), t3x16(:,:,23))
  call heltable([2,4,8], n3(:,46), t3x8(:,:,13))
  n2(12) = 8
  call heltable([4,4,16], n3(:,47), t3x16(:,:,24))
  call heltable([4,4,16], n3(:,48), t3x16(:,:,25))
  call heltable([4,2,8], n3(:,49), t3x8(:,:,14))
  n2(13) = 8
  call heltable([4,2,8], n3(:,50), t3x8(:,:,15))
  n2(14) = 8
  call heltable([2,4,8], n3(:,51), t3x8(:,:,16))
  call heltable([4,4,16], n3(:,52), t3x16(:,:,26))
  n2(15) = 8
  call heltable([2,4,8], n3(:,53), t3x8(:,:,17))
  n2(16) = 8
  call heltable([4,4,16], n3(:,54), t3x16(:,:,27))
  call heltable([4,2,8], n3(:,55), t3x8(:,:,18))
  n2(17) = 8
  call heltable([4,2,8], n3(:,56), t3x8(:,:,19))
  n2(18) = 8
  call heltable([4,4,16], n3(:,57), t3x16(:,:,28))
  call heltable([4,4,16], n3(:,58), t3x16(:,:,29))
  call heltable([4,2,8], n3(:,59), t3x8(:,:,20))
  call heltable([4,2,8], n3(:,60), t3x8(:,:,21))
  call heltable([2,4,8], n3(:,61), t3x8(:,:,22))
  call heltable([2,8,16], n3(:,62), t3x16(:,:,30))
  call heltable([2,8,16], n3(:,63), t3x16(:,:,31))
  call heltable([2,8,16], n3(:,64), t3x16(:,:,32))
  call heltable([2,8,16], n3(:,65), t3x16(:,:,33))
  call heltable([2,8,16], n3(:,66), t3x16(:,:,34))
  call heltable([2,8,16], n3(:,67), t3x16(:,:,35))
  call heltable([2,8,16], n3(:,68), t3x16(:,:,36))
  call heltable([2,8,16], n3(:,69), t3x16(:,:,37))
  call heltable([2,2,4], n3(:,70), t3x4(:,:,11))
  call heltable([2,2,4], n3(:,71), t3x4(:,:,12))
  n2(19) = 4
  call heltable([4,2,8], n3(:,72), t3x8(:,:,23))
  call heltable([4,4,16], n3(:,73), t3x16(:,:,38))
  n2(20) = 8
  call heltable([2,2,4], n3(:,74), t3x4(:,:,13))
  call heltable([4,4,16], n3(:,75), t3x16(:,:,39))
  call heltable([4,2,8], n3(:,76), t3x8(:,:,24))
  n2(21) = 8
  call heltable([2,2,4], n3(:,77), t3x4(:,:,14))
  call heltable([4,4,16], n3(:,78), t3x16(:,:,40))
  call heltable([2,2,4], n3(:,79), t3x4(:,:,15))
  call heltable([4,4,16], n3(:,80), t3x16(:,:,41))
  call heltable([2,4,8], n3(:,81), t3x8(:,:,25))
  n2(22) = 8
  call heltable([2,4,8], n3(:,82), t3x8(:,:,26))
  n2(23) = 8
  call heltable([2,4,8], n3(:,83), t3x8(:,:,27))
  call heltable([4,4,16], n3(:,84), t3x16(:,:,42))
  call heltable([2,4,8], n3(:,85), t3x8(:,:,28))
  call heltable([4,4,16], n3(:,86), t3x16(:,:,43))
  call heltable([4,4,16], n3(:,87), t3x16(:,:,44))
  call heltable([4,4,16], n3(:,88), t3x16(:,:,45))
  call heltable([4,4,16], n3(:,89), t3x16(:,:,46))
  call heltable([4,4,16], n3(:,90), t3x16(:,:,47))
  call heltable([4,2,8], n3(:,91), t3x8(:,:,29))
  call heltable([4,4,16], n3(:,92), t3x16(:,:,48))
  call heltable([4,4,16], n3(:,93), t3x16(:,:,49))
  call heltable([4,4,16], n3(:,94), t3x16(:,:,50))
  call heltable([4,4,16], n3(:,95), t3x16(:,:,51))
  call heltable([4,4,16], n3(:,96), t3x16(:,:,52))
  call heltable([4,4,16], n3(:,97), t3x16(:,:,53))
  call heltable([4,4,16], n3(:,98), t3x16(:,:,54))
  call heltable([4,2,8], n3(:,99), t3x8(:,:,30))
  call heltable([4,4,16], n3(:,100), t3x16(:,:,55))
  n2(24) = 8
  call heltable([4,2,8], n3(:,101), t3x8(:,:,31))
  n2(25) = 8
  call heltable([4,4,16], n3(:,102), t3x16(:,:,56))
  call heltable([2,4,8], n3(:,103), t3x8(:,:,32))
  n2(26) = 8
  call heltable([2,4,8], n3(:,104), t3x8(:,:,33))
  n2(27) = 8
  call heltable([4,4,16], n3(:,105), t3x16(:,:,57))
  call heltable([4,4,16], n3(:,106), t3x16(:,:,58))
  call heltable([2,2,4], n3(:,107), t3x4(:,:,16))
  n2(28) = 4
  call heltable([2,4,8], n3(:,108), t3x8(:,:,34))
  call heltable([4,4,16], n3(:,109), t3x16(:,:,59))
  n2(29) = 8
  call heltable([4,4,16], n3(:,110), t3x16(:,:,60))
  call heltable([2,4,8], n3(:,111), t3x8(:,:,35))
  n2(30) = 8
  call heltable([4,4,16], n3(:,112), t3x16(:,:,61))
  call heltable([4,4,16], n3(:,113), t3x16(:,:,62))
  call heltable([4,2,8], n3(:,114), t3x8(:,:,36))
  n2(31) = 8
  call heltable([4,2,8], n3(:,115), t3x8(:,:,37))
  n2(32) = 8
  call heltable([4,2,8], n3(:,116), t3x8(:,:,38))
  call heltable([4,2,8], n3(:,117), t3x8(:,:,39))
  call heltable([2,4,8], n3(:,118), t3x8(:,:,40))
  call heltable([2,4,8], n3(:,119), t3x8(:,:,41))
  call heltable([4,4,16], n3(:,120), t3x16(:,:,63))
  n2(33) = 8
  call heltable([2,4,8], n3(:,121), t3x8(:,:,42))
  n2(34) = 8
  call heltable([4,4,16], n3(:,122), t3x16(:,:,64))
  call heltable([4,2,8], n3(:,123), t3x8(:,:,43))
  n2(35) = 8
  call heltable([4,2,8], n3(:,124), t3x8(:,:,44))
  n2(36) = 8
  call heltable([4,4,16], n3(:,125), t3x16(:,:,65))
  call heltable([4,4,16], n3(:,126), t3x16(:,:,66))
  call heltable([2,8,16], n3(:,127), t3x16(:,:,67))
  call heltable([2,8,16], n3(:,128), t3x16(:,:,68))
  call heltable([2,8,16], n3(:,129), t3x16(:,:,69))
  call heltable([2,8,16], n3(:,130), t3x16(:,:,70))
  call heltable([2,8,16], n3(:,131), t3x16(:,:,71))
  call heltable([2,8,16], n3(:,132), t3x16(:,:,72))
  call heltable([2,8,16], n3(:,133), t3x16(:,:,73))
  call heltable([2,8,16], n3(:,134), t3x16(:,:,74))
  call heltable([8,2,16], n3(:,135), t3x16(:,:,75))
  call heltable([8,2,16], n3(:,136), t3x16(:,:,76))
  call heltable([4,2,8], n3(:,137), t3x8(:,:,45))
  call heltable([2,8,16], n3(:,138), t3x16(:,:,77))
  call heltable([2,8,16], n3(:,139), t3x16(:,:,78))
  call heltable([2,8,16], n3(:,140), t3x16(:,:,79))
  call heltable([2,8,16], n3(:,141), t3x16(:,:,80))
  call heltable([8,2,16], n3(:,142), t3x16(:,:,81))
  call heltable([8,2,16], n3(:,143), t3x16(:,:,82))
  call heltable([8,2,16], n3(:,144), t3x16(:,:,83))
  call heltable([8,2,16], n3(:,145), t3x16(:,:,84))
  call heltable([2,4,8], n3(:,146), t3x8(:,:,46))
  call heltable([2,8,16], n3(:,147), t3x16(:,:,85))
  call heltable([2,8,16], n3(:,148), t3x16(:,:,86))
  call heltable([2,8,16], n3(:,149), t3x16(:,:,87))
  call heltable([2,8,16], n3(:,150), t3x16(:,:,88))
  call heltable([8,2,16], n3(:,151), t3x16(:,:,89))
  call heltable([8,2,16], n3(:,152), t3x16(:,:,90))
  call heltable([2,8,16], n3(:,153), t3x16(:,:,91))
  call heltable([2,8,16], n3(:,154), t3x16(:,:,92))
  call heltable([2,8,16], n3(:,155), t3x16(:,:,93))
  call heltable([2,8,16], n3(:,156), t3x16(:,:,94))
  call heltable([4,2,8], n3(:,157), t3x8(:,:,47))
  call heltable([8,2,16], n3(:,158), t3x16(:,:,95))
  call heltable([8,2,16], n3(:,159), t3x16(:,:,96))
  call heltable([8,2,16], n3(:,160), t3x16(:,:,97))
  call heltable([8,2,16], n3(:,161), t3x16(:,:,98))
  call heltable([2,8,16], n3(:,162), t3x16(:,:,99))
  call heltable([2,8,16], n3(:,163), t3x16(:,:,100))
  call heltable([2,8,16], n3(:,164), t3x16(:,:,101))
  call heltable([2,8,16], n3(:,165), t3x16(:,:,102))
  call heltable([8,2,16], n3(:,166), t3x16(:,:,103))
  call heltable([8,2,16], n3(:,167), t3x16(:,:,104))
  call heltable([8,2,16], n3(:,168), t3x16(:,:,105))
  call heltable([8,2,16], n3(:,169), t3x16(:,:,106))
  call heltable([8,2,16], n3(:,170), t3x16(:,:,107))
  call heltable([8,2,16], n3(:,171), t3x16(:,:,108))
  call heltable([8,2,16], n3(:,172), t3x16(:,:,109))
  call heltable([8,2,16], n3(:,173), t3x16(:,:,110))
  call heltable([2,8,16], n3(:,174), t3x16(:,:,111))
  call heltable([2,8,16], n3(:,175), t3x16(:,:,112))
  call heltable([2,8,16], n3(:,176), t3x16(:,:,113))
  call heltable([2,8,16], n3(:,177), t3x16(:,:,114))
  call heltable([8,2,16], n3(:,178), t3x16(:,:,115))
  call heltable([8,2,16], n3(:,179), t3x16(:,:,116))
  call heltable([8,2,16], n3(:,180), t3x16(:,:,117))
  call heltable([8,2,16], n3(:,181), t3x16(:,:,118))
  call heltable([2,8,16], n3(:,182), t3x16(:,:,119))
  call heltable([2,8,16], n3(:,183), t3x16(:,:,120))
  call heltable([2,8,16], n3(:,184), t3x16(:,:,121))
  call heltable([2,8,16], n3(:,185), t3x16(:,:,122))
  call heltable([2,4,8], n3(:,186), t3x8(:,:,48))
  call heltable([2,2,4], n3(:,187), t3x4(:,:,17))
  call heltable([2,2,4], n3(:,188), t3x4(:,:,18))
  call heltable([4,2,8], n3(:,189), t3x8(:,:,49))
  call heltable([4,4,16], n3(:,190), t3x16(:,:,123))
  n2(37) = 8
  call heltable([2,2,4], n3(:,191), t3x4(:,:,19))
  call heltable([4,4,16], n3(:,192), t3x16(:,:,124))
  call heltable([2,2,4], n3(:,193), t3x4(:,:,20))
  call heltable([4,2,8], n3(:,194), t3x8(:,:,50))
  n2(38) = 8
  call heltable([2,2,4], n3(:,195), t3x4(:,:,21))
  call heltable([4,4,16], n3(:,196), t3x16(:,:,125))
  call heltable([2,2,4], n3(:,197), t3x4(:,:,22))
  call heltable([4,4,16], n3(:,198), t3x16(:,:,126))
  call heltable([2,2,4], n3(:,199), t3x4(:,:,23))
  call heltable([2,4,8], n3(:,200), t3x8(:,:,51))
  n2(39) = 8
  call heltable([2,2,4], n3(:,201), t3x4(:,:,24))
  call heltable([2,4,8], n3(:,202), t3x8(:,:,52))
  n2(40) = 8
  call heltable([4,2,8], n3(:,203), t3x8(:,:,53))
  call heltable([4,4,16], n3(:,204), t3x16(:,:,127))
  n2(41) = 8
  call heltable([4,2,8], n3(:,205), t3x8(:,:,54))
  n2(42) = 8
  call heltable([4,4,16], n3(:,206), t3x16(:,:,128))
  call heltable([2,4,8], n3(:,207), t3x8(:,:,55))
  n2(43) = 8
  call heltable([2,4,8], n3(:,208), t3x8(:,:,56))
  n2(44) = 8
  call heltable([4,4,16], n3(:,209), t3x16(:,:,129))
  call heltable([4,4,16], n3(:,210), t3x16(:,:,130))
  call heltable([4,4,16], n3(:,211), t3x16(:,:,131))
  call heltable([4,4,16], n3(:,212), t3x16(:,:,132))
  call heltable([4,4,16], n3(:,213), t3x16(:,:,133))
  call heltable([4,4,16], n3(:,214), t3x16(:,:,134))
  call heltable([4,4,16], n3(:,215), t3x16(:,:,135))
  call heltable([4,4,16], n3(:,216), t3x16(:,:,136))
  call heltable([4,4,16], n3(:,217), t3x16(:,:,137))
  call heltable([4,4,16], n3(:,218), t3x16(:,:,138))
  call heltable([4,4,16], n3(:,219), t3x16(:,:,139))
  call heltable([4,4,16], n3(:,220), t3x16(:,:,140))
  call heltable([4,4,16], n3(:,221), t3x16(:,:,141))
  call heltable([4,4,16], n3(:,222), t3x16(:,:,142))
  call heltable([4,4,16], n3(:,223), t3x16(:,:,143))
  call heltable([2,4,8], n3(:,224), t3x8(:,:,57))
  call heltable([4,4,16], n3(:,225), t3x16(:,:,144))
  n2(45) = 8
  call heltable([4,4,16], n3(:,226), t3x16(:,:,145))
  call heltable([2,4,8], n3(:,227), t3x8(:,:,58))
  n2(46) = 8
  call heltable([4,4,16], n3(:,228), t3x16(:,:,146))
  call heltable([4,4,16], n3(:,229), t3x16(:,:,147))
  call heltable([4,2,8], n3(:,230), t3x8(:,:,59))
  n2(47) = 8
  call heltable([4,2,8], n3(:,231), t3x8(:,:,60))
  n2(48) = 8
  call heltable([2,4,8], n3(:,232), t3x8(:,:,61))
  call heltable([4,4,16], n3(:,233), t3x16(:,:,148))
  n2(49) = 8
  call heltable([2,4,8], n3(:,234), t3x8(:,:,62))
  n2(50) = 8
  call heltable([4,4,16], n3(:,235), t3x16(:,:,149))
  call heltable([4,2,8], n3(:,236), t3x8(:,:,63))
  n2(51) = 8
  call heltable([4,2,8], n3(:,237), t3x8(:,:,64))
  n2(52) = 8
  call heltable([4,4,16], n3(:,238), t3x16(:,:,150))
  call heltable([4,4,16], n3(:,239), t3x16(:,:,151))
  call heltable([2,8,16], n3(:,240), t3x16(:,:,152))
  call heltable([2,8,16], n3(:,241), t3x16(:,:,153))
  call heltable([2,8,16], n3(:,242), t3x16(:,:,154))
  call heltable([2,8,16], n3(:,243), t3x16(:,:,155))
  call heltable([2,8,16], n3(:,244), t3x16(:,:,156))
  call heltable([2,8,16], n3(:,245), t3x16(:,:,157))
  call heltable([2,8,16], n3(:,246), t3x16(:,:,158))
  call heltable([2,8,16], n3(:,247), t3x16(:,:,159))
  call heltable([2,2,4], n3(:,248), t3x4(:,:,25))
  n2(53) = 4
  call heltable([2,4,8], n3(:,249), t3x8(:,:,65))
  call heltable([4,4,16], n3(:,250), t3x16(:,:,160))
  call heltable([2,4,8], n3(:,251), t3x8(:,:,66))
  call heltable([4,4,16], n3(:,252), t3x16(:,:,161))
  call heltable([4,4,16], n3(:,253), t3x16(:,:,162))
  call heltable([4,4,16], n3(:,254), t3x16(:,:,163))
  call heltable([4,4,16], n3(:,255), t3x16(:,:,164))
  call heltable([4,4,16], n3(:,256), t3x16(:,:,165))
  call heltable([4,2,8], n3(:,257), t3x8(:,:,67))
  call heltable([4,4,16], n3(:,258), t3x16(:,:,166))
  call heltable([4,4,16], n3(:,259), t3x16(:,:,167))
  call heltable([4,4,16], n3(:,260), t3x16(:,:,168))
  call heltable([4,4,16], n3(:,261), t3x16(:,:,169))
  call heltable([4,4,16], n3(:,262), t3x16(:,:,170))
  call heltable([4,4,16], n3(:,263), t3x16(:,:,171))
  call heltable([4,4,16], n3(:,264), t3x16(:,:,172))
  call heltable([4,2,8], n3(:,265), t3x8(:,:,68))
  call heltable([4,4,16], n3(:,266), t3x16(:,:,173))
  n2(54) = 8
  call heltable([4,4,16], n3(:,267), t3x16(:,:,174))
  call heltable([4,2,8], n3(:,268), t3x8(:,:,69))
  n2(55) = 8
  call heltable([4,4,16], n3(:,269), t3x16(:,:,175))
  call heltable([4,4,16], n3(:,270), t3x16(:,:,176))
  call heltable([2,4,8], n3(:,271), t3x8(:,:,70))
  n2(56) = 8
  call heltable([2,4,8], n3(:,272), t3x8(:,:,71))
  n2(57) = 8
  call heltable([4,4,16], n3(:,273), t3x16(:,:,177))
  call heltable([4,4,16], n3(:,274), t3x16(:,:,178))
  call heltable([4,4,16], n3(:,275), t3x16(:,:,179))
  call heltable([4,4,16], n3(:,276), t3x16(:,:,180))
  call heltable([2,4,8], n3(:,277), t3x8(:,:,72))
  n2(58) = 8
  call heltable([2,4,8], n3(:,278), t3x8(:,:,73))
  n2(59) = 8
  call heltable([4,2,8], n3(:,279), t3x8(:,:,74))
  n2(60) = 8
  call heltable([4,2,8], n3(:,280), t3x8(:,:,75))
  n2(61) = 8
  call heltable([4,2,8], n3(:,281), t3x8(:,:,76))
  call heltable([4,2,8], n3(:,282), t3x8(:,:,77))
  call heltable([2,4,8], n3(:,283), t3x8(:,:,78))
  call heltable([2,4,8], n3(:,284), t3x8(:,:,79))
  call heltable([4,4,16], n3(:,285), t3x16(:,:,181))
  n2(62) = 8
  call heltable([4,4,16], n3(:,286), t3x16(:,:,182))
  call heltable([2,4,8], n3(:,287), t3x8(:,:,80))
  n2(63) = 8
  call heltable([4,4,16], n3(:,288), t3x16(:,:,183))
  call heltable([4,4,16], n3(:,289), t3x16(:,:,184))
  call heltable([4,2,8], n3(:,290), t3x8(:,:,81))
  n2(64) = 8
  call heltable([4,2,8], n3(:,291), t3x8(:,:,82))
  n2(65) = 8
  call heltable([2,8,16], n3(:,292), t3x16(:,:,185))
  call heltable([2,8,16], n3(:,293), t3x16(:,:,186))
  call heltable([2,8,16], n3(:,294), t3x16(:,:,187))
  call heltable([2,8,16], n3(:,295), t3x16(:,:,188))
  call heltable([2,8,16], n3(:,296), t3x16(:,:,189))
  call heltable([2,8,16], n3(:,297), t3x16(:,:,190))
  call heltable([2,8,16], n3(:,298), t3x16(:,:,191))
  call heltable([2,8,16], n3(:,299), t3x16(:,:,192))
  call heltable([8,2,16], n3(:,300), t3x16(:,:,193))
  call heltable([8,2,16], n3(:,301), t3x16(:,:,194))
  call heltable([4,2,8], n3(:,302), t3x8(:,:,83))
  call heltable([2,8,16], n3(:,303), t3x16(:,:,195))
  call heltable([2,8,16], n3(:,304), t3x16(:,:,196))
  call heltable([2,8,16], n3(:,305), t3x16(:,:,197))
  call heltable([2,8,16], n3(:,306), t3x16(:,:,198))
  call heltable([8,2,16], n3(:,307), t3x16(:,:,199))
  call heltable([8,2,16], n3(:,308), t3x16(:,:,200))
  call heltable([2,8,16], n3(:,309), t3x16(:,:,201))
  call heltable([2,8,16], n3(:,310), t3x16(:,:,202))
  call heltable([2,4,8], n3(:,311), t3x8(:,:,84))
  call heltable([8,2,16], n3(:,312), t3x16(:,:,203))
  call heltable([8,2,16], n3(:,313), t3x16(:,:,204))
  call heltable([8,2,16], n3(:,314), t3x16(:,:,205))
  call heltable([8,2,16], n3(:,315), t3x16(:,:,206))
  call heltable([2,8,16], n3(:,316), t3x16(:,:,207))
  call heltable([2,8,16], n3(:,317), t3x16(:,:,208))
  call heltable([2,8,16], n3(:,318), t3x16(:,:,209))
  call heltable([2,8,16], n3(:,319), t3x16(:,:,210))
  call heltable([2,8,16], n3(:,320), t3x16(:,:,211))
  call heltable([2,8,16], n3(:,321), t3x16(:,:,212))
  call heltable([8,2,16], n3(:,322), t3x16(:,:,213))
  call heltable([8,2,16], n3(:,323), t3x16(:,:,214))
  call heltable([8,2,16], n3(:,324), t3x16(:,:,215))
  call heltable([8,2,16], n3(:,325), t3x16(:,:,216))
  call heltable([2,8,16], n3(:,326), t3x16(:,:,217))
  call heltable([2,8,16], n3(:,327), t3x16(:,:,218))
  call heltable([2,8,16], n3(:,328), t3x16(:,:,219))
  call heltable([2,8,16], n3(:,329), t3x16(:,:,220))
  call heltable([8,2,16], n3(:,330), t3x16(:,:,221))
  call heltable([8,2,16], n3(:,331), t3x16(:,:,222))
  call heltable([8,2,16], n3(:,332), t3x16(:,:,223))
  call heltable([8,2,16], n3(:,333), t3x16(:,:,224))
  call heltable([8,2,16], n3(:,334), t3x16(:,:,225))
  call heltable([8,2,16], n3(:,335), t3x16(:,:,226))
  call heltable([8,2,16], n3(:,336), t3x16(:,:,227))
  call heltable([8,2,16], n3(:,337), t3x16(:,:,228))
  call heltable([8,2,16], n3(:,338), t3x16(:,:,229))
  call heltable([8,2,16], n3(:,339), t3x16(:,:,230))
  call heltable([8,2,16], n3(:,340), t3x16(:,:,231))
  call heltable([8,2,16], n3(:,341), t3x16(:,:,232))
  call heltable([2,8,16], n3(:,342), t3x16(:,:,233))
  call heltable([2,8,16], n3(:,343), t3x16(:,:,234))
  call heltable([2,8,16], n3(:,344), t3x16(:,:,235))
  call heltable([2,8,16], n3(:,345), t3x16(:,:,236))
  call heltable([2,8,16], n3(:,346), t3x16(:,:,237))
  call heltable([2,8,16], n3(:,347), t3x16(:,:,238))
  call heltable([2,8,16], n3(:,348), t3x16(:,:,239))
  call heltable([2,8,16], n3(:,349), t3x16(:,:,240))
  call heltable([4,2,8], n3(:,350), t3x8(:,:,85))
  n2(66) = 8
  call heltable([4,2,8], n3(:,351), t3x8(:,:,86))
  n2(67) = 8
  call heltable([2,4,8], n3(:,352), t3x8(:,:,87))
  n2(68) = 8
  call heltable([2,4,8], n3(:,353), t3x8(:,:,88))
  n2(69) = 8
  call heltable([2,4,8], n3(:,354), t3x8(:,:,89))
  call heltable([4,4,16], n3(:,355), t3x16(:,:,241))
  call heltable([2,4,8], n3(:,356), t3x8(:,:,90))
  call heltable([4,4,16], n3(:,357), t3x16(:,:,242))
  call heltable([4,4,16], n3(:,358), t3x16(:,:,243))
  call heltable([4,4,16], n3(:,359), t3x16(:,:,244))
  call heltable([4,4,16], n3(:,360), t3x16(:,:,245))
  call heltable([4,4,16], n3(:,361), t3x16(:,:,246))
  call heltable([4,2,8], n3(:,362), t3x8(:,:,91))
  call heltable([4,4,16], n3(:,363), t3x16(:,:,247))
  call heltable([4,4,16], n3(:,364), t3x16(:,:,248))
  call heltable([4,4,16], n3(:,365), t3x16(:,:,249))
  call heltable([4,4,16], n3(:,366), t3x16(:,:,250))
  call heltable([4,4,16], n3(:,367), t3x16(:,:,251))
  call heltable([4,4,16], n3(:,368), t3x16(:,:,252))
  call heltable([4,4,16], n3(:,369), t3x16(:,:,253))
  call heltable([4,2,8], n3(:,370), t3x8(:,:,92))
  call heltable([4,4,16], n3(:,371), t3x16(:,:,254))
  n2(70) = 8
  call heltable([4,2,8], n3(:,372), t3x8(:,:,93))
  n2(71) = 8
  call heltable([4,4,16], n3(:,373), t3x16(:,:,255))
  call heltable([2,4,8], n3(:,374), t3x8(:,:,94))
  n2(72) = 8
  call heltable([2,4,8], n3(:,375), t3x8(:,:,95))
  n2(73) = 8
  call heltable([4,4,16], n3(:,376), t3x16(:,:,256))
  call heltable([4,4,16], n3(:,377), t3x16(:,:,257))
  call heltable([2,2,4], n3(:,378), t3x4(:,:,26))
  n2(74) = 4
  call heltable([2,4,8], n3(:,379), t3x8(:,:,96))
  call heltable([4,4,16], n3(:,380), t3x16(:,:,258))
  n2(75) = 8
  call heltable([4,4,16], n3(:,381), t3x16(:,:,259))
  call heltable([2,4,8], n3(:,382), t3x8(:,:,97))
  n2(76) = 8
  call heltable([4,4,16], n3(:,383), t3x16(:,:,260))
  call heltable([4,4,16], n3(:,384), t3x16(:,:,261))
  call heltable([4,2,8], n3(:,385), t3x8(:,:,98))
  n2(77) = 8
  call heltable([4,2,8], n3(:,386), t3x8(:,:,99))
  n2(78) = 8
  call heltable([4,2,8], n3(:,387), t3x8(:,:,100))
  call heltable([4,2,8], n3(:,388), t3x8(:,:,101))
  call heltable([2,4,8], n3(:,389), t3x8(:,:,102))
  call heltable([4,4,16], n3(:,390), t3x16(:,:,262))
  call heltable([4,4,16], n3(:,391), t3x16(:,:,263))
  call heltable([4,4,16], n3(:,392), t3x16(:,:,264))
  call heltable([4,4,16], n3(:,393), t3x16(:,:,265))
  call heltable([2,8,16], n3(:,394), t3x16(:,:,266))
  call heltable([2,8,16], n3(:,395), t3x16(:,:,267))
  call heltable([2,8,16], n3(:,396), t3x16(:,:,268))
  call heltable([2,8,16], n3(:,397), t3x16(:,:,269))
  call heltable([8,2,16], n3(:,398), t3x16(:,:,270))
  call heltable([8,2,16], n3(:,399), t3x16(:,:,271))
  call heltable([4,2,8], n3(:,400), t3x8(:,:,103))
  call heltable([2,8,16], n3(:,401), t3x16(:,:,272))
  call heltable([2,8,16], n3(:,402), t3x16(:,:,273))
  call heltable([2,8,16], n3(:,403), t3x16(:,:,274))
  call heltable([2,8,16], n3(:,404), t3x16(:,:,275))
  call heltable([8,2,16], n3(:,405), t3x16(:,:,276))
  call heltable([8,2,16], n3(:,406), t3x16(:,:,277))
  call heltable([8,2,16], n3(:,407), t3x16(:,:,278))
  call heltable([8,2,16], n3(:,408), t3x16(:,:,279))
  call heltable([2,4,8], n3(:,409), t3x8(:,:,104))
  call heltable([2,8,16], n3(:,410), t3x16(:,:,280))
  call heltable([2,8,16], n3(:,411), t3x16(:,:,281))
  call heltable([2,8,16], n3(:,412), t3x16(:,:,282))
  call heltable([2,8,16], n3(:,413), t3x16(:,:,283))
  call heltable([8,2,16], n3(:,414), t3x16(:,:,284))
  call heltable([8,2,16], n3(:,415), t3x16(:,:,285))
  call heltable([2,8,16], n3(:,416), t3x16(:,:,286))
  call heltable([2,8,16], n3(:,417), t3x16(:,:,287))
  call heltable([2,8,16], n3(:,418), t3x16(:,:,288))
  call heltable([2,8,16], n3(:,419), t3x16(:,:,289))
  call heltable([8,2,16], n3(:,420), t3x16(:,:,290))
  call heltable([8,2,16], n3(:,421), t3x16(:,:,291))
  call heltable([8,2,16], n3(:,422), t3x16(:,:,292))
  call heltable([8,2,16], n3(:,423), t3x16(:,:,293))
  call heltable([2,8,16], n3(:,424), t3x16(:,:,294))
  call heltable([2,8,16], n3(:,425), t3x16(:,:,295))
  call heltable([2,8,16], n3(:,426), t3x16(:,:,296))
  call heltable([2,8,16], n3(:,427), t3x16(:,:,297))
  call heltable([8,2,16], n3(:,428), t3x16(:,:,298))
  call heltable([8,2,16], n3(:,429), t3x16(:,:,299))
  call heltable([8,2,16], n3(:,430), t3x16(:,:,300))
  call heltable([8,2,16], n3(:,431), t3x16(:,:,301))
  call heltable([8,2,16], n3(:,432), t3x16(:,:,302))
  call heltable([8,2,16], n3(:,433), t3x16(:,:,303))
  call heltable([8,2,16], n3(:,434), t3x16(:,:,304))
  call heltable([8,2,16], n3(:,435), t3x16(:,:,305))
  call heltable([2,8,16], n3(:,436), t3x16(:,:,306))
  call heltable([2,8,16], n3(:,437), t3x16(:,:,307))
  call heltable([2,8,16], n3(:,438), t3x16(:,:,308))
  call heltable([2,8,16], n3(:,439), t3x16(:,:,309))
  call heltable([8,2,16], n3(:,440), t3x16(:,:,310))
  call heltable([8,2,16], n3(:,441), t3x16(:,:,311))
  call heltable([8,2,16], n3(:,442), t3x16(:,:,312))
  call heltable([8,2,16], n3(:,443), t3x16(:,:,313))
  call heltable([2,8,16], n3(:,444), t3x16(:,:,314))
  call heltable([2,8,16], n3(:,445), t3x16(:,:,315))
  call heltable([2,8,16], n3(:,446), t3x16(:,:,316))
  call heltable([2,8,16], n3(:,447), t3x16(:,:,317))
  call heltable([2,4,8], n3(:,448), t3x8(:,:,105))
  call heltable([4,4,16], n3(:,449), t3x16(:,:,318))
  call heltable([2,4,8], n3(:,450), t3x8(:,:,106))
  call heltable([4,4,16], n3(:,451), t3x16(:,:,319))
  call heltable([4,4,16], n3(:,452), t3x16(:,:,320))
  call heltable([4,4,16], n3(:,453), t3x16(:,:,321))
  call heltable([4,4,16], n3(:,454), t3x16(:,:,322))
  call heltable([4,4,16], n3(:,455), t3x16(:,:,323))
  call heltable([4,2,8], n3(:,456), t3x8(:,:,107))
  call heltable([4,4,16], n3(:,457), t3x16(:,:,324))
  call heltable([4,4,16], n3(:,458), t3x16(:,:,325))
  call heltable([4,4,16], n3(:,459), t3x16(:,:,326))
  call heltable([4,4,16], n3(:,460), t3x16(:,:,327))
  call heltable([4,4,16], n3(:,461), t3x16(:,:,328))
  call heltable([4,4,16], n3(:,462), t3x16(:,:,329))
  call heltable([4,4,16], n3(:,463), t3x16(:,:,330))
  call heltable([4,2,8], n3(:,464), t3x8(:,:,108))
  n2(79) = 8
  call heltable([4,2,8], n3(:,465), t3x8(:,:,109))
  n2(80) = 8
  call heltable([2,4,8], n3(:,466), t3x8(:,:,110))
  n2(81) = 8
  call heltable([2,4,8], n3(:,467), t3x8(:,:,111))
  n2(82) = 8
  call heltable([4,4,16], n3(:,468), t3x16(:,:,331))
  call heltable([4,4,16], n3(:,469), t3x16(:,:,332))
  call heltable([4,4,16], n3(:,470), t3x16(:,:,333))
  call heltable([4,4,16], n3(:,471), t3x16(:,:,334))
  call heltable([2,4,8], n3(:,472), t3x8(:,:,112))
  n2(83) = 8
  call heltable([2,4,8], n3(:,473), t3x8(:,:,113))
  n2(84) = 8
  call heltable([4,2,8], n3(:,474), t3x8(:,:,114))
  n2(85) = 8
  call heltable([4,2,8], n3(:,475), t3x8(:,:,115))
  n2(86) = 8
  call heltable([4,2,8], n3(:,476), t3x8(:,:,116))
  call heltable([4,2,8], n3(:,477), t3x8(:,:,117))
  call heltable([2,4,8], n3(:,478), t3x8(:,:,118))
  call heltable([4,4,16], n3(:,479), t3x16(:,:,335))
  call heltable([4,4,16], n3(:,480), t3x16(:,:,336))
  call heltable([4,4,16], n3(:,481), t3x16(:,:,337))
  call heltable([4,4,16], n3(:,482), t3x16(:,:,338))
  call heltable([2,8,16], n3(:,483), t3x16(:,:,339))
  call heltable([2,8,16], n3(:,484), t3x16(:,:,340))
  call heltable([2,8,16], n3(:,485), t3x16(:,:,341))
  call heltable([2,8,16], n3(:,486), t3x16(:,:,342))
  call heltable([8,2,16], n3(:,487), t3x16(:,:,343))
  call heltable([8,2,16], n3(:,488), t3x16(:,:,344))
  call heltable([4,2,8], n3(:,489), t3x8(:,:,119))
  call heltable([2,8,16], n3(:,490), t3x16(:,:,345))
  call heltable([2,8,16], n3(:,491), t3x16(:,:,346))
  call heltable([2,8,16], n3(:,492), t3x16(:,:,347))
  call heltable([2,8,16], n3(:,493), t3x16(:,:,348))
  call heltable([8,2,16], n3(:,494), t3x16(:,:,349))
  call heltable([8,2,16], n3(:,495), t3x16(:,:,350))
  call heltable([2,8,16], n3(:,496), t3x16(:,:,351))
  call heltable([2,8,16], n3(:,497), t3x16(:,:,352))
  call heltable([2,4,8], n3(:,498), t3x8(:,:,120))
  call heltable([8,2,16], n3(:,499), t3x16(:,:,353))
  call heltable([8,2,16], n3(:,500), t3x16(:,:,354))
  call heltable([8,2,16], n3(:,501), t3x16(:,:,355))
  call heltable([8,2,16], n3(:,502), t3x16(:,:,356))
  call heltable([2,8,16], n3(:,503), t3x16(:,:,357))
  call heltable([2,8,16], n3(:,504), t3x16(:,:,358))
  call heltable([2,8,16], n3(:,505), t3x16(:,:,359))
  call heltable([2,8,16], n3(:,506), t3x16(:,:,360))
  call heltable([2,8,16], n3(:,507), t3x16(:,:,361))
  call heltable([2,8,16], n3(:,508), t3x16(:,:,362))
  call heltable([8,2,16], n3(:,509), t3x16(:,:,363))
  call heltable([8,2,16], n3(:,510), t3x16(:,:,364))
  call heltable([8,2,16], n3(:,511), t3x16(:,:,365))
  call heltable([8,2,16], n3(:,512), t3x16(:,:,366))
  call heltable([2,8,16], n3(:,513), t3x16(:,:,367))
  call heltable([2,8,16], n3(:,514), t3x16(:,:,368))
  call heltable([2,8,16], n3(:,515), t3x16(:,:,369))
  call heltable([2,8,16], n3(:,516), t3x16(:,:,370))
  call heltable([8,2,16], n3(:,517), t3x16(:,:,371))
  call heltable([8,2,16], n3(:,518), t3x16(:,:,372))
  call heltable([8,2,16], n3(:,519), t3x16(:,:,373))
  call heltable([8,2,16], n3(:,520), t3x16(:,:,374))
  call heltable([8,2,16], n3(:,521), t3x16(:,:,375))
  call heltable([8,2,16], n3(:,522), t3x16(:,:,376))
  call heltable([8,2,16], n3(:,523), t3x16(:,:,377))
  call heltable([8,2,16], n3(:,524), t3x16(:,:,378))
  call heltable([8,2,16], n3(:,525), t3x16(:,:,379))
  call heltable([8,2,16], n3(:,526), t3x16(:,:,380))
  call heltable([8,2,16], n3(:,527), t3x16(:,:,381))
  call heltable([8,2,16], n3(:,528), t3x16(:,:,382))
  call heltable([2,8,16], n3(:,529), t3x16(:,:,383))
  call heltable([2,8,16], n3(:,530), t3x16(:,:,384))
  call heltable([2,8,16], n3(:,531), t3x16(:,:,385))
  call heltable([2,8,16], n3(:,532), t3x16(:,:,386))
  call heltable([2,8,16], n3(:,533), t3x16(:,:,387))
  call heltable([2,8,16], n3(:,534), t3x16(:,:,388))
  call heltable([2,8,16], n3(:,535), t3x16(:,:,389))
  call heltable([2,8,16], n3(:,536), t3x16(:,:,390))
  call heltable([2,8,16], n3(:,537), t3x16(:,:,391))
  call heltable([2,8,16], n3(:,538), t3x16(:,:,392))
  call heltable([8,2,16], n3(:,539), t3x16(:,:,393))
  call heltable([8,2,16], n3(:,540), t3x16(:,:,394))
  call heltable([2,8,16], n3(:,541), t3x16(:,:,395))
  call heltable([2,8,16], n3(:,542), t3x16(:,:,396))
  call heltable([2,8,16], n3(:,543), t3x16(:,:,397))
  call heltable([2,8,16], n3(:,544), t3x16(:,:,398))
  call heltable([8,2,16], n3(:,545), t3x16(:,:,399))
  call heltable([8,2,16], n3(:,546), t3x16(:,:,400))
  call heltable([8,2,16], n3(:,547), t3x16(:,:,401))
  call heltable([8,2,16], n3(:,548), t3x16(:,:,402))
  call heltable([2,8,16], n3(:,549), t3x16(:,:,403))
  call heltable([2,8,16], n3(:,550), t3x16(:,:,404))
  call heltable([2,8,16], n3(:,551), t3x16(:,:,405))
  call heltable([2,8,16], n3(:,552), t3x16(:,:,406))
  call heltable([8,2,16], n3(:,553), t3x16(:,:,407))
  call heltable([8,2,16], n3(:,554), t3x16(:,:,408))
  call heltable([8,2,16], n3(:,555), t3x16(:,:,409))
  call heltable([8,2,16], n3(:,556), t3x16(:,:,410))
  call heltable([8,2,16], n3(:,557), t3x16(:,:,411))
  call heltable([8,2,16], n3(:,558), t3x16(:,:,412))
  call heltable([8,2,16], n3(:,559), t3x16(:,:,413))
  call heltable([8,2,16], n3(:,560), t3x16(:,:,414))
  call heltable([8,2,16], n3(:,561), t3x16(:,:,415))
  call heltable([8,2,16], n3(:,562), t3x16(:,:,416))
  call heltable([8,2,16], n3(:,563), t3x16(:,:,417))
  call heltable([8,2,16], n3(:,564), t3x16(:,:,418))
  call heltable([2,8,16], n3(:,565), t3x16(:,:,419))
  call heltable([2,8,16], n3(:,566), t3x16(:,:,420))
  call heltable([2,8,16], n3(:,567), t3x16(:,:,421))
  call heltable([2,8,16], n3(:,568), t3x16(:,:,422))
  call heltable([2,8,16], n3(:,569), t3x16(:,:,423))
  call heltable([2,8,16], n3(:,570), t3x16(:,:,424))
  call heltable([2,8,16], n3(:,571), t3x16(:,:,425))
  call heltable([2,8,16], n3(:,572), t3x16(:,:,426))
  call heltable([2,8,16], n3(:,573), t3x16(:,:,427))
  call heltable([2,8,16], n3(:,574), t3x16(:,:,428))
  call heltable([2,8,16], n3(:,575), t3x16(:,:,429))
  call heltable([2,8,16], n3(:,576), t3x16(:,:,430))
  call heltable([8,2,16], n3(:,577), t3x16(:,:,431))
  call heltable([8,2,16], n3(:,578), t3x16(:,:,432))
  call heltable([8,2,16], n3(:,579), t3x16(:,:,433))
  call heltable([8,2,16], n3(:,580), t3x16(:,:,434))
  call heltable([2,8,16], n3(:,581), t3x16(:,:,435))
  call heltable([2,8,16], n3(:,582), t3x16(:,:,436))
  call heltable([2,8,16], n3(:,583), t3x16(:,:,437))
  call heltable([2,8,16], n3(:,584), t3x16(:,:,438))
  call heltable([8,2,16], n3(:,585), t3x16(:,:,439))
  call heltable([8,2,16], n3(:,586), t3x16(:,:,440))
  call heltable([8,2,16], n3(:,587), t3x16(:,:,441))
  call heltable([8,2,16], n3(:,588), t3x16(:,:,442))
  call heltable([2,8,16], n3(:,589), t3x16(:,:,443))
  call heltable([2,8,16], n3(:,590), t3x16(:,:,444))
  call heltable([8,2,16], n3(:,591), t3x16(:,:,445))
  call heltable([8,2,16], n3(:,592), t3x16(:,:,446))
  call heltable([8,2,16], n3(:,593), t3x16(:,:,447))
  call heltable([8,2,16], n3(:,594), t3x16(:,:,448))
  call heltable([8,2,16], n3(:,595), t3x16(:,:,449))
  call heltable([8,2,16], n3(:,596), t3x16(:,:,450))
  call heltable([8,2,16], n3(:,597), t3x16(:,:,451))
  call heltable([8,2,16], n3(:,598), t3x16(:,:,452))
  call heltable([8,2,16], n3(:,599), t3x16(:,:,453))
  call heltable([8,2,16], n3(:,600), t3x16(:,:,454))
  call heltable([2,8,16], n3(:,601), t3x16(:,:,455))
  call heltable([2,8,16], n3(:,602), t3x16(:,:,456))
  call heltable([2,8,16], n3(:,603), t3x16(:,:,457))
  call heltable([2,8,16], n3(:,604), t3x16(:,:,458))
  call heltable([2,8,16], n3(:,605), t3x16(:,:,459))
  call heltable([2,8,16], n3(:,606), t3x16(:,:,460))
  call heltable([2,8,16], n3(:,607), t3x16(:,:,461))
  call heltable([2,8,16], n3(:,608), t3x16(:,:,462))
  call heltable([2,8,16], n3(:,609), t3x16(:,:,463))
  call heltable([2,8,16], n3(:,610), t3x16(:,:,464))
  call heltable([2,8,16], n3(:,611), t3x16(:,:,465))
  call heltable([2,8,16], n3(:,612), t3x16(:,:,466))
  call heltable([8,2,16], n3(:,613), t3x16(:,:,467))
  call heltable([8,2,16], n3(:,614), t3x16(:,:,468))
  call heltable([8,2,16], n3(:,615), t3x16(:,:,469))
  call heltable([8,2,16], n3(:,616), t3x16(:,:,470))
  call heltable([2,8,16], n3(:,617), t3x16(:,:,471))
  call heltable([2,8,16], n3(:,618), t3x16(:,:,472))
  call heltable([2,8,16], n3(:,619), t3x16(:,:,473))
  call heltable([2,8,16], n3(:,620), t3x16(:,:,474))
  call heltable([8,2,16], n3(:,621), t3x16(:,:,475))
  call heltable([8,2,16], n3(:,622), t3x16(:,:,476))
  call heltable([8,2,16], n3(:,623), t3x16(:,:,477))
  call heltable([8,2,16], n3(:,624), t3x16(:,:,478))
  call heltable([2,8,16], n3(:,625), t3x16(:,:,479))
  call heltable([2,8,16], n3(:,626), t3x16(:,:,480))
  call heltable([2,8,16], n3(:,627), t3x16(:,:,481))
  call heltable([2,8,16], n3(:,628), t3x16(:,:,482))
  call heltable([8,2,16], n3(:,629), t3x16(:,:,483))
  call heltable([8,2,16], n3(:,630), t3x16(:,:,484))
  call heltable([8,2,16], n3(:,631), t3x16(:,:,485))
  call heltable([8,2,16], n3(:,632), t3x16(:,:,486))
  call heltable([2,8,16], n3(:,633), t3x16(:,:,487))
  call heltable([2,8,16], n3(:,634), t3x16(:,:,488))
  call heltable([2,8,16], n3(:,635), t3x16(:,:,489))
  call heltable([2,8,16], n3(:,636), t3x16(:,:,490))
  call heltable([8,2,16], n3(:,637), t3x16(:,:,491))
  call heltable([8,2,16], n3(:,638), t3x16(:,:,492))
  call heltable([8,2,16], n3(:,639), t3x16(:,:,493))
  call heltable([8,2,16], n3(:,640), t3x16(:,:,494))
  call heltable([2,8,16], n3(:,641), t3x16(:,:,495))
  call heltable([2,8,16], n3(:,642), t3x16(:,:,496))
  call heltable([8,2,16], n3(:,643), t3x16(:,:,497))
  call heltable([8,2,16], n3(:,644), t3x16(:,:,498))
  call heltable([2,8,16], n3(:,645), t3x16(:,:,499))
  call heltable([2,8,16], n3(:,646), t3x16(:,:,500))
  call heltable([8,2,16], n3(:,647), t3x16(:,:,501))
  call heltable([8,2,16], n3(:,648), t3x16(:,:,502))
  call heltable([8,2,16], n3(:,649), t3x16(:,:,503))
  call heltable([8,2,16], n3(:,650), t3x16(:,:,504))
  call heltable([2,8,16], n3(:,651), t3x16(:,:,505))
  call heltable([2,8,16], n3(:,652), t3x16(:,:,506))
  call heltable([2,8,16], n3(:,653), t3x16(:,:,507))
  call heltable([2,8,16], n3(:,654), t3x16(:,:,508))
  call heltable([8,2,16], n3(:,655), t3x16(:,:,509))
  call heltable([8,2,16], n3(:,656), t3x16(:,:,510))
  call heltable([2,8,16], n3(:,657), t3x16(:,:,511))
  call heltable([2,8,16], n3(:,658), t3x16(:,:,512))
  call heltable([8,2,16], n3(:,659), t3x16(:,:,513))
  call heltable([8,2,16], n3(:,660), t3x16(:,:,514))
  call heltable([8,2,16], n3(:,661), t3x16(:,:,515))
  call heltable([8,2,16], n3(:,662), t3x16(:,:,516))
  call heltable([2,8,16], n3(:,663), t3x16(:,:,517))
  call heltable([2,8,16], n3(:,664), t3x16(:,:,518))
  call heltable([4,4,2,32], n4(:,1), t4x32(:,:,1))
  call heltable([4,4,2,32], n4(:,2), t4x32(:,:,2))
  call heltable([4,2,4,32], n4(:,3), t4x32(:,:,3))
  call heltable([4,2,4,32], n4(:,4), t4x32(:,:,4))
  call heltable([4,2,4,32], n4(:,5), t4x32(:,:,5))
  call heltable([4,2,4,32], n4(:,6), t4x32(:,:,6))
  call heltable([4,2,4,32], n4(:,7), t4x32(:,:,7))
  call heltable([4,2,4,32], n4(:,8), t4x32(:,:,8))
  call heltable([4,2,4,32], n4(:,9), t4x32(:,:,9))
  call heltable([4,2,4,32], n4(:,10), t4x32(:,:,10))
  call heltable([4,4,2,32], n4(:,11), t4x32(:,:,11))
  call heltable([4,4,2,32], n4(:,12), t4x32(:,:,12))
  call heltable([4,4,2,32], n4(:,13), t4x32(:,:,13))
  call heltable([4,4,2,32], n4(:,14), t4x32(:,:,14))
  call heltable([4,4,2,32], n4(:,15), t4x32(:,:,15))
  call heltable([4,4,2,32], n4(:,16), t4x32(:,:,16))
  call heltable([4,2,4,32], n4(:,17), t4x32(:,:,17))
  call heltable([4,2,4,32], n4(:,18), t4x32(:,:,18))
  call heltable([4,2,4,32], n4(:,19), t4x32(:,:,19))
  call heltable([4,2,4,32], n4(:,20), t4x32(:,:,20))
  call heltable([4,2,4,32], n4(:,21), t4x32(:,:,21))
  call heltable([4,2,4,32], n4(:,22), t4x32(:,:,22))
  call heltable([4,2,4,32], n4(:,23), t4x32(:,:,23))
  call heltable([4,2,4,32], n4(:,24), t4x32(:,:,24))
  call heltable([4,4,2,32], n4(:,25), t4x32(:,:,25))
  call heltable([4,4,2,32], n4(:,26), t4x32(:,:,26))
  call heltable([4,4,2,32], n4(:,27), t4x32(:,:,27))
  call heltable([4,4,2,32], n4(:,28), t4x32(:,:,28))
  call heltable([2,4,8], n3(:,665), t3x8(:,:,121))
  call heltable([4,2,8], n3(:,666), t3x8(:,:,122))
  call heltable([4,2,8], n3(:,667), t3x8(:,:,123))
  call heltable([4,2,8], n3(:,668), t3x8(:,:,124))
  call heltable([4,2,8], n3(:,669), t3x8(:,:,125))
  call heltable([4,2,8], n3(:,670), t3x8(:,:,126))
  call heltable([2,4,8], n3(:,671), t3x8(:,:,127))
  call heltable([4,2,8], n3(:,672), t3x8(:,:,128))
  call heltable([4,2,8], n3(:,673), t3x8(:,:,129))
  call heltable([4,2,8], n3(:,674), t3x8(:,:,130))
  call heltable([4,2,8], n3(:,675), t3x8(:,:,131))
  call heltable([2,4,8], n3(:,676), t3x8(:,:,132))
  call heltable([4,2,8], n3(:,677), t3x8(:,:,133))
  call heltable([4,2,8], n3(:,678), t3x8(:,:,134))
  call heltable([4,2,8], n3(:,679), t3x8(:,:,135))
  call heltable([4,4,16], n3(:,680), t3x16(:,:,519))
  call heltable([4,4,16], n3(:,681), t3x16(:,:,520))
  call heltable([4,4,16], n3(:,682), t3x16(:,:,521))
  call heltable([4,4,16], n3(:,683), t3x16(:,:,522))
  call heltable([4,4,16], n3(:,684), t3x16(:,:,523))
  call heltable([4,4,16], n3(:,685), t3x16(:,:,524))
  call heltable([4,4,16], n3(:,686), t3x16(:,:,525))
  call heltable([4,4,16], n3(:,687), t3x16(:,:,526))
  call heltable([4,4,16], n3(:,688), t3x16(:,:,527))
  call heltable([4,4,16], n3(:,689), t3x16(:,:,528))
  call heltable([4,4,16], n3(:,690), t3x16(:,:,529))
  call heltable([4,4,16], n3(:,691), t3x16(:,:,530))
  call heltable([4,4,16], n3(:,692), t3x16(:,:,531))
  call heltable([4,4,16], n3(:,693), t3x16(:,:,532))
  call heltable([4,4,16], n3(:,694), t3x16(:,:,533))
  call heltable([4,4,16], n3(:,695), t3x16(:,:,534))
  call heltable([4,4,16], n3(:,696), t3x16(:,:,535))
  call heltable([4,4,16], n3(:,697), t3x16(:,:,536))
  call heltable([4,4,16], n3(:,698), t3x16(:,:,537))
  call heltable([4,4,16], n3(:,699), t3x16(:,:,538))
  call heltable([4,4,16], n3(:,700), t3x16(:,:,539))
  call heltable([4,4,16], n3(:,701), t3x16(:,:,540))
  call heltable([4,4,16], n3(:,702), t3x16(:,:,541))
  call heltable([4,4,16], n3(:,703), t3x16(:,:,542))
  call heltable([4,4,16], n3(:,704), t3x16(:,:,543))
  call heltable([4,4,16], n3(:,705), t3x16(:,:,544))
  call heltable([4,4,16], n3(:,706), t3x16(:,:,545))
  call heltable([4,4,16], n3(:,707), t3x16(:,:,546))
  call heltable([4,4,16], n3(:,708), t3x16(:,:,547))
  call heltable([4,4,16], n3(:,709), t3x16(:,:,548))
  call heltable([4,4,16], n3(:,710), t3x16(:,:,549))
  call heltable([4,4,16], n3(:,711), t3x16(:,:,550))
  call heltable([4,4,16], n3(:,712), t3x16(:,:,551))
  call heltable([4,4,16], n3(:,713), t3x16(:,:,552))
  call heltable([4,4,16], n3(:,714), t3x16(:,:,553))
  call heltable([4,4,16], n3(:,715), t3x16(:,:,554))
  call heltable([4,4,16], n3(:,716), t3x16(:,:,555))
  call heltable([4,4,16], n3(:,717), t3x16(:,:,556))
  call heltable([2,8,16], n3(:,718), t3x16(:,:,557))
  call heltable([2,8,16], n3(:,719), t3x16(:,:,558))
  call heltable([2,8,16], n3(:,720), t3x16(:,:,559))
  call heltable([2,8,16], n3(:,721), t3x16(:,:,560))
  call heltable([2,8,16], n3(:,722), t3x16(:,:,561))
  call heltable([2,8,16], n3(:,723), t3x16(:,:,562))
  call heltable([2,8,16], n3(:,724), t3x16(:,:,563))
  call heltable([2,8,16], n3(:,725), t3x16(:,:,564))
  call heltable([8,2,16], n3(:,726), t3x16(:,:,565))
  call heltable([8,2,16], n3(:,727), t3x16(:,:,566))
  call heltable([8,2,16], n3(:,728), t3x16(:,:,567))
  call heltable([8,2,16], n3(:,729), t3x16(:,:,568))
  call heltable([2,8,16], n3(:,730), t3x16(:,:,569))
  call heltable([2,8,16], n3(:,731), t3x16(:,:,570))
  call heltable([2,8,16], n3(:,732), t3x16(:,:,571))
  call heltable([2,8,16], n3(:,733), t3x16(:,:,572))
  call heltable([8,2,16], n3(:,734), t3x16(:,:,573))
  call heltable([8,2,16], n3(:,735), t3x16(:,:,574))
  call heltable([8,2,16], n3(:,736), t3x16(:,:,575))
  call heltable([8,2,16], n3(:,737), t3x16(:,:,576))
  call heltable([2,8,16], n3(:,738), t3x16(:,:,577))
  call heltable([2,8,16], n3(:,739), t3x16(:,:,578))
  call heltable([2,8,16], n3(:,740), t3x16(:,:,579))
  call heltable([2,8,16], n3(:,741), t3x16(:,:,580))
  call heltable([8,2,16], n3(:,742), t3x16(:,:,581))
  call heltable([8,2,16], n3(:,743), t3x16(:,:,582))
  call heltable([8,2,16], n3(:,744), t3x16(:,:,583))
  call heltable([8,2,16], n3(:,745), t3x16(:,:,584))
  call heltable([2,8,16], n3(:,746), t3x16(:,:,585))
  call heltable([2,8,16], n3(:,747), t3x16(:,:,586))
  call heltable([2,8,16], n3(:,748), t3x16(:,:,587))
  call heltable([2,8,16], n3(:,749), t3x16(:,:,588))
  call heltable([8,2,16], n3(:,750), t3x16(:,:,589))
  call heltable([8,2,16], n3(:,751), t3x16(:,:,590))
  call heltable([8,2,16], n3(:,752), t3x16(:,:,591))
  call heltable([8,2,16], n3(:,753), t3x16(:,:,592))
  call heltable([2,8,16], n3(:,754), t3x16(:,:,593))
  call heltable([2,8,16], n3(:,755), t3x16(:,:,594))
  call heltable([2,8,16], n3(:,756), t3x16(:,:,595))
  call heltable([2,8,16], n3(:,757), t3x16(:,:,596))
  call heltable([2,8,16], n3(:,758), t3x16(:,:,597))
  call heltable([2,8,16], n3(:,759), t3x16(:,:,598))
  call heltable([2,8,16], n3(:,760), t3x16(:,:,599))
  call heltable([2,8,16], n3(:,761), t3x16(:,:,600))
  call heltable([8,2,16], n3(:,762), t3x16(:,:,601))
  call heltable([8,2,16], n3(:,763), t3x16(:,:,602))
  call heltable([8,2,16], n3(:,764), t3x16(:,:,603))
  call heltable([8,2,16], n3(:,765), t3x16(:,:,604))
  call heltable([2,8,16], n3(:,766), t3x16(:,:,605))
  call heltable([2,8,16], n3(:,767), t3x16(:,:,606))
  call heltable([2,8,16], n3(:,768), t3x16(:,:,607))
  call heltable([2,8,16], n3(:,769), t3x16(:,:,608))
  call heltable([8,2,16], n3(:,770), t3x16(:,:,609))
  call heltable([8,2,16], n3(:,771), t3x16(:,:,610))
  call heltable([8,2,16], n3(:,772), t3x16(:,:,611))
  call heltable([8,2,16], n3(:,773), t3x16(:,:,612))
  call heltable([8,2,16], n3(:,774), t3x16(:,:,613))
  call heltable([8,2,16], n3(:,775), t3x16(:,:,614))
  call heltable([8,2,16], n3(:,776), t3x16(:,:,615))
  call heltable([8,2,16], n3(:,777), t3x16(:,:,616))
  call heltable([2,8,16], n3(:,778), t3x16(:,:,617))
  call heltable([2,8,16], n3(:,779), t3x16(:,:,618))
  call heltable([2,8,16], n3(:,780), t3x16(:,:,619))
  call heltable([2,8,16], n3(:,781), t3x16(:,:,620))
  call heltable([8,2,16], n3(:,782), t3x16(:,:,621))
  call heltable([8,2,16], n3(:,783), t3x16(:,:,622))
  call heltable([8,2,16], n3(:,784), t3x16(:,:,623))
  call heltable([8,2,16], n3(:,785), t3x16(:,:,624))
  call heltable([2,8,16], n3(:,786), t3x16(:,:,625))
  call heltable([2,8,16], n3(:,787), t3x16(:,:,626))
  call heltable([2,8,16], n3(:,788), t3x16(:,:,627))
  call heltable([2,8,16], n3(:,789), t3x16(:,:,628))
  call heltable([2,4,8], n3(:,790), t3x8(:,:,136))
  call heltable([2,4,8], n3(:,791), t3x8(:,:,137))
  call heltable([4,2,8], n3(:,792), t3x8(:,:,138))
  call heltable([4,2,8], n3(:,793), t3x8(:,:,139))
  n2(87) = 16
  call heltable([4,2,8], n3(:,794), t3x8(:,:,140))
  n2(88) = 16
  call heltable([2,4,8], n3(:,795), t3x8(:,:,141))
  call heltable([2,4,8], n3(:,796), t3x8(:,:,142))
  n2(89) = 16
  n2(90) = 16
  call heltable([4,2,8], n3(:,797), t3x8(:,:,143))
  n2(91) = 16
  n2(92) = 16
  call heltable([4,2,8], n3(:,798), t3x8(:,:,144))
  n2(93) = 16
  n2(94) = 16
  call heltable([2,4,8], n3(:,799), t3x8(:,:,145))
  call heltable([2,4,8], n3(:,800), t3x8(:,:,146))
  n2(95) = 8
  n2(96) = 8
  n2(97) = 8
  n2(98) = 8
  n2(99) = 8
  n2(100) = 8
  n2(101) = 8
  n2(102) = 8
  call heltable([2,2,4], n3(:,801), t3x4(:,:,27))
  n2(103) = 4
  call heltable([4,4,16], n3(:,802), t3x16(:,:,629))
  call heltable([4,4,16], n3(:,803), t3x16(:,:,630))
  call heltable([4,4,16], n3(:,804), t3x16(:,:,631))
  call heltable([4,4,16], n3(:,805), t3x16(:,:,632))
  call heltable([4,4,16], n3(:,806), t3x16(:,:,633))
  call heltable([4,4,16], n3(:,807), t3x16(:,:,634))
  call heltable([4,4,16], n3(:,808), t3x16(:,:,635))
  call heltable([4,4,16], n3(:,809), t3x16(:,:,636))
  call heltable([4,2,8], n3(:,810), t3x8(:,:,147))
  call heltable([4,2,8], n3(:,811), t3x8(:,:,148))
  call heltable([2,4,8], n3(:,812), t3x8(:,:,149))
  call heltable([4,2,8], n3(:,813), t3x8(:,:,150))
  call heltable([4,2,8], n3(:,814), t3x8(:,:,151))
  call heltable([2,4,8], n3(:,815), t3x8(:,:,152))
  call heltable([2,4,8], n3(:,816), t3x8(:,:,153))
  n2(104) = 16
  call heltable([2,4,8], n3(:,817), t3x8(:,:,154))
  n2(105) = 16
  call heltable([4,2,8], n3(:,818), t3x8(:,:,155))
  call heltable([4,2,8], n3(:,819), t3x8(:,:,156))
  n2(106) = 16
  n2(107) = 16
  call heltable([2,4,8], n3(:,820), t3x8(:,:,157))
  n2(108) = 16
  n2(109) = 16
  call heltable([2,4,8], n3(:,821), t3x8(:,:,158))
  n2(110) = 16
  n2(111) = 16
  call heltable([4,2,8], n3(:,822), t3x8(:,:,159))
  call heltable([4,2,8], n3(:,823), t3x8(:,:,160))
  n2(112) = 8
  call heltable([2,8,16], n3(:,824), t3x16(:,:,637))
  n2(113) = 8
  call heltable([2,8,16], n3(:,825), t3x16(:,:,638))
  n2(114) = 8
  call heltable([2,8,16], n3(:,826), t3x16(:,:,639))
  n2(115) = 8
  call heltable([2,8,16], n3(:,827), t3x16(:,:,640))
  n2(116) = 8
  call heltable([2,8,16], n3(:,828), t3x16(:,:,641))
  n2(117) = 8
  call heltable([2,8,16], n3(:,829), t3x16(:,:,642))
  n2(118) = 8
  call heltable([2,8,16], n3(:,830), t3x16(:,:,643))
  n2(119) = 8
  call heltable([2,8,16], n3(:,831), t3x16(:,:,644))
  call heltable([2,2,4], n3(:,832), t3x4(:,:,28))
  n2(120) = 4
  call heltable([4,4,16], n3(:,833), t3x16(:,:,645))
  call heltable([4,4,16], n3(:,834), t3x16(:,:,646))
  call heltable([4,4,16], n3(:,835), t3x16(:,:,647))
  call heltable([4,4,16], n3(:,836), t3x16(:,:,648))
  call heltable([4,4,16], n3(:,837), t3x16(:,:,649))
  call heltable([4,4,16], n3(:,838), t3x16(:,:,650))
  call heltable([4,4,16], n3(:,839), t3x16(:,:,651))
  call heltable([4,4,16], n3(:,840), t3x16(:,:,652))
  call heltable([2,4,8], n3(:,841), t3x8(:,:,161))
  call heltable([2,4,8], n3(:,842), t3x8(:,:,162))
  call heltable([4,2,8], n3(:,843), t3x8(:,:,163))
  call heltable([4,4,16], n3(:,844), t3x16(:,:,653))
  call heltable([4,4,16], n3(:,845), t3x16(:,:,654))
  call heltable([4,4,16], n3(:,846), t3x16(:,:,655))
  call heltable([4,4,16], n3(:,847), t3x16(:,:,656))
  call heltable([4,4,16], n3(:,848), t3x16(:,:,657))
  call heltable([4,4,16], n3(:,849), t3x16(:,:,658))
  call heltable([4,4,16], n3(:,850), t3x16(:,:,659))
  call heltable([4,4,16], n3(:,851), t3x16(:,:,660))
  call heltable([4,4,16], n3(:,852), t3x16(:,:,661))
  call heltable([4,4,16], n3(:,853), t3x16(:,:,662))
  call heltable([4,4,16], n3(:,854), t3x16(:,:,663))
  call heltable([4,4,16], n3(:,855), t3x16(:,:,664))
  call heltable([4,4,16], n3(:,856), t3x16(:,:,665))
  call heltable([4,4,16], n3(:,857), t3x16(:,:,666))
  call heltable([4,4,16], n3(:,858), t3x16(:,:,667))
  call heltable([4,4,16], n3(:,859), t3x16(:,:,668))
  call heltable([4,4,16], n3(:,860), t3x16(:,:,669))
  call heltable([4,4,16], n3(:,861), t3x16(:,:,670))
  call heltable([4,4,16], n3(:,862), t3x16(:,:,671))
  call heltable([4,4,16], n3(:,863), t3x16(:,:,672))
  call heltable([4,4,16], n3(:,864), t3x16(:,:,673))
  call heltable([4,4,16], n3(:,865), t3x16(:,:,674))
  call heltable([4,4,16], n3(:,866), t3x16(:,:,675))
  call heltable([4,4,16], n3(:,867), t3x16(:,:,676))
  call heltable([4,4,16], n3(:,868), t3x16(:,:,677))
  call heltable([4,4,16], n3(:,869), t3x16(:,:,678))
  call heltable([4,4,16], n3(:,870), t3x16(:,:,679))
  call heltable([4,4,16], n3(:,871), t3x16(:,:,680))
  call heltable([4,4,16], n3(:,872), t3x16(:,:,681))
  call heltable([4,4,16], n3(:,873), t3x16(:,:,682))
  call heltable([4,4,16], n3(:,874), t3x16(:,:,683))
  call heltable([4,4,16], n3(:,875), t3x16(:,:,684))
  call heltable([4,4,16], n3(:,876), t3x16(:,:,685))
  call heltable([4,4,16], n3(:,877), t3x16(:,:,686))
  call heltable([4,4,16], n3(:,878), t3x16(:,:,687))
  call heltable([4,4,16], n3(:,879), t3x16(:,:,688))
  call heltable([4,4,16], n3(:,880), t3x16(:,:,689))
  call heltable([4,4,16], n3(:,881), t3x16(:,:,690))
  call heltable([2,8,16], n3(:,882), t3x16(:,:,691))
  call heltable([2,8,16], n3(:,883), t3x16(:,:,692))
  call heltable([2,8,16], n3(:,884), t3x16(:,:,693))
  call heltable([2,8,16], n3(:,885), t3x16(:,:,694))
  call heltable([2,8,16], n3(:,886), t3x16(:,:,695))
  call heltable([2,8,16], n3(:,887), t3x16(:,:,696))
  call heltable([2,8,16], n3(:,888), t3x16(:,:,697))
  call heltable([2,8,16], n3(:,889), t3x16(:,:,698))
  call heltable([8,2,16], n3(:,890), t3x16(:,:,699))
  call heltable([8,2,16], n3(:,891), t3x16(:,:,700))
  call heltable([8,2,16], n3(:,892), t3x16(:,:,701))
  call heltable([8,2,16], n3(:,893), t3x16(:,:,702))
  call heltable([8,2,16], n3(:,894), t3x16(:,:,703))
  call heltable([8,2,16], n3(:,895), t3x16(:,:,704))
  call heltable([8,2,16], n3(:,896), t3x16(:,:,705))
  call heltable([8,2,16], n3(:,897), t3x16(:,:,706))
  call heltable([2,8,16], n3(:,898), t3x16(:,:,707))
  call heltable([2,8,16], n3(:,899), t3x16(:,:,708))
  call heltable([2,8,16], n3(:,900), t3x16(:,:,709))
  call heltable([2,8,16], n3(:,901), t3x16(:,:,710))
  call heltable([2,8,16], n3(:,902), t3x16(:,:,711))
  call heltable([2,8,16], n3(:,903), t3x16(:,:,712))
  call heltable([2,8,16], n3(:,904), t3x16(:,:,713))
  call heltable([2,8,16], n3(:,905), t3x16(:,:,714))
  call heltable([8,2,16], n3(:,906), t3x16(:,:,715))
  call heltable([8,2,16], n3(:,907), t3x16(:,:,716))
  call heltable([2,8,16], n3(:,908), t3x16(:,:,717))
  call heltable([2,8,16], n3(:,909), t3x16(:,:,718))
  call heltable([8,2,16], n3(:,910), t3x16(:,:,719))
  call heltable([8,2,16], n3(:,911), t3x16(:,:,720))
  call heltable([2,8,16], n3(:,912), t3x16(:,:,721))
  call heltable([2,8,16], n3(:,913), t3x16(:,:,722))
  call heltable([4,2,8], n3(:,914), t3x8(:,:,164))
  call heltable([2,4,8], n3(:,915), t3x8(:,:,165))
  call heltable([2,8,16], n3(:,916), t3x16(:,:,723))
  call heltable([2,8,16], n3(:,917), t3x16(:,:,724))
  call heltable([8,2,16], n3(:,918), t3x16(:,:,725))
  call heltable([8,2,16], n3(:,919), t3x16(:,:,726))
  call heltable([2,8,16], n3(:,920), t3x16(:,:,727))
  call heltable([2,8,16], n3(:,921), t3x16(:,:,728))
  call heltable([8,2,16], n3(:,922), t3x16(:,:,729))
  call heltable([8,2,16], n3(:,923), t3x16(:,:,730))
  call heltable([2,4,8], n3(:,924), t3x8(:,:,166))
  call heltable([4,2,8], n3(:,925), t3x8(:,:,167))
  call heltable([2,2,4], n3(:,926), t3x4(:,:,29))
  call heltable([4,4,16], n3(:,927), t3x16(:,:,731))
  call heltable([2,2,4], n3(:,928), t3x4(:,:,30))
  call heltable([4,4,16], n3(:,929), t3x16(:,:,732))
  call heltable([2,2,4], n3(:,930), t3x4(:,:,31))
  call heltable([4,4,16], n3(:,931), t3x16(:,:,733))
  call heltable([2,2,4], n3(:,932), t3x4(:,:,32))
  call heltable([4,4,16], n3(:,933), t3x16(:,:,734))
  call heltable([4,4,16], n3(:,934), t3x16(:,:,735))
  call heltable([4,4,16], n3(:,935), t3x16(:,:,736))
  call heltable([4,4,16], n3(:,936), t3x16(:,:,737))
  call heltable([4,4,16], n3(:,937), t3x16(:,:,738))
  call heltable([4,4,16], n3(:,938), t3x16(:,:,739))
  call heltable([4,4,16], n3(:,939), t3x16(:,:,740))
  call heltable([4,4,16], n3(:,940), t3x16(:,:,741))
  call heltable([4,4,16], n3(:,941), t3x16(:,:,742))
  call heltable([4,4,16], n3(:,942), t3x16(:,:,743))
  call heltable([4,4,16], n3(:,943), t3x16(:,:,744))
  call heltable([4,4,16], n3(:,944), t3x16(:,:,745))
  call heltable([4,4,16], n3(:,945), t3x16(:,:,746))
  call heltable([4,4,16], n3(:,946), t3x16(:,:,747))
  call heltable([4,2,8], n3(:,947), t3x8(:,:,168))
  n2(121) = 8
  call heltable([4,2,8], n3(:,948), t3x8(:,:,169))
  n2(122) = 8
  call heltable([2,4,8], n3(:,949), t3x8(:,:,170))
  n2(123) = 8
  call heltable([2,4,8], n3(:,950), t3x8(:,:,171))
  n2(124) = 8
  call heltable([4,4,16], n3(:,951), t3x16(:,:,748))
  call heltable([4,4,16], n3(:,952), t3x16(:,:,749))
  call heltable([4,4,16], n3(:,953), t3x16(:,:,750))
  call heltable([4,4,16], n3(:,954), t3x16(:,:,751))
  call heltable([2,4,8], n3(:,955), t3x8(:,:,172))
  n2(125) = 8
  call heltable([2,4,8], n3(:,956), t3x8(:,:,173))
  n2(126) = 8
  call heltable([4,2,8], n3(:,957), t3x8(:,:,174))
  n2(127) = 8
  call heltable([4,2,8], n3(:,958), t3x8(:,:,175))
  n2(128) = 8
  call heltable([2,8,16], n3(:,959), t3x16(:,:,752))
  call heltable([2,8,16], n3(:,960), t3x16(:,:,753))
  call heltable([2,8,16], n3(:,961), t3x16(:,:,754))
  call heltable([2,8,16], n3(:,962), t3x16(:,:,755))
  call heltable([4,2,8], n3(:,963), t3x8(:,:,176))
  n2(129) = 16
  call heltable([4,2,8], n3(:,964), t3x8(:,:,177))
  n2(130) = 16
  call heltable([2,4,8], n3(:,965), t3x8(:,:,178))
  call heltable([2,4,8], n3(:,966), t3x8(:,:,179))
  n2(131) = 16
  n2(132) = 16
  call heltable([2,4,8], n3(:,967), t3x8(:,:,180))
  call heltable([2,4,8], n3(:,968), t3x8(:,:,181))
  call heltable([4,2,8], n3(:,969), t3x8(:,:,182))
  call heltable([4,2,8], n3(:,970), t3x8(:,:,183))
  n2(133) = 16
  n2(134) = 16
  call heltable([4,2,8], n3(:,971), t3x8(:,:,184))
  n2(135) = 16
  n2(136) = 16
  call heltable([2,4,8], n3(:,972), t3x8(:,:,185))
  call heltable([2,4,8], n3(:,973), t3x8(:,:,186))
  n2(137) = 8
  n2(138) = 8
  n2(139) = 8
  n2(140) = 8
  n2(141) = 8
  n2(142) = 8
  n2(143) = 8
  n2(144) = 8
  call heltable([2,2,4], n3(:,974), t3x4(:,:,33))
  n2(145) = 4
  call heltable([4,4,16], n3(:,975), t3x16(:,:,756))
  call heltable([4,4,16], n3(:,976), t3x16(:,:,757))
  call heltable([4,4,16], n3(:,977), t3x16(:,:,758))
  call heltable([4,4,16], n3(:,978), t3x16(:,:,759))
  call heltable([4,4,16], n3(:,979), t3x16(:,:,760))
  call heltable([4,4,16], n3(:,980), t3x16(:,:,761))
  call heltable([4,4,16], n3(:,981), t3x16(:,:,762))
  call heltable([4,4,16], n3(:,982), t3x16(:,:,763))
  call heltable([4,2,8], n3(:,983), t3x8(:,:,187))
  call heltable([4,2,8], n3(:,984), t3x8(:,:,188))
  call heltable([2,4,8], n3(:,985), t3x8(:,:,189))
  call heltable([8,2,16], n3(:,986), t3x16(:,:,764))
  call heltable([8,2,16], n3(:,987), t3x16(:,:,765))
  call heltable([4,2,8], n3(:,988), t3x8(:,:,190))
  call heltable([2,8,16], n3(:,989), t3x16(:,:,766))
  call heltable([2,8,16], n3(:,990), t3x16(:,:,767))
  call heltable([2,8,16], n3(:,991), t3x16(:,:,768))
  call heltable([2,8,16], n3(:,992), t3x16(:,:,769))
  call heltable([8,2,16], n3(:,993), t3x16(:,:,770))
  call heltable([8,2,16], n3(:,994), t3x16(:,:,771))
  call heltable([2,8,16], n3(:,995), t3x16(:,:,772))
  call heltable([2,8,16], n3(:,996), t3x16(:,:,773))
  call heltable([2,8,16], n3(:,997), t3x16(:,:,774))
  call heltable([2,8,16], n3(:,998), t3x16(:,:,775))
  call heltable([8,2,16], n3(:,999), t3x16(:,:,776))
  call heltable([8,2,16], n3(:,1000), t3x16(:,:,777))
  call heltable([8,2,16], n3(:,1001), t3x16(:,:,778))
  call heltable([8,2,16], n3(:,1002), t3x16(:,:,779))
  call heltable([2,8,16], n3(:,1003), t3x16(:,:,780))
  call heltable([2,8,16], n3(:,1004), t3x16(:,:,781))
  call heltable([2,8,16], n3(:,1005), t3x16(:,:,782))
  call heltable([2,8,16], n3(:,1006), t3x16(:,:,783))
  call heltable([8,2,16], n3(:,1007), t3x16(:,:,784))
  call heltable([8,2,16], n3(:,1008), t3x16(:,:,785))
  call heltable([8,2,16], n3(:,1009), t3x16(:,:,786))
  call heltable([8,2,16], n3(:,1010), t3x16(:,:,787))
  call heltable([8,2,16], n3(:,1011), t3x16(:,:,788))
  call heltable([8,2,16], n3(:,1012), t3x16(:,:,789))
  call heltable([8,2,16], n3(:,1013), t3x16(:,:,790))
  call heltable([8,2,16], n3(:,1014), t3x16(:,:,791))
  call heltable([2,8,16], n3(:,1015), t3x16(:,:,792))
  call heltable([2,8,16], n3(:,1016), t3x16(:,:,793))
  call heltable([2,8,16], n3(:,1017), t3x16(:,:,794))
  call heltable([2,8,16], n3(:,1018), t3x16(:,:,795))
  call heltable([8,2,16], n3(:,1019), t3x16(:,:,796))
  call heltable([8,2,16], n3(:,1020), t3x16(:,:,797))
  call heltable([8,2,16], n3(:,1021), t3x16(:,:,798))
  call heltable([8,2,16], n3(:,1022), t3x16(:,:,799))
  call heltable([2,8,16], n3(:,1023), t3x16(:,:,800))
  call heltable([2,8,16], n3(:,1024), t3x16(:,:,801))
  call heltable([2,8,16], n3(:,1025), t3x16(:,:,802))
  call heltable([2,8,16], n3(:,1026), t3x16(:,:,803))
  call heltable([8,2,16], n3(:,1027), t3x16(:,:,804))
  call heltable([8,2,16], n3(:,1028), t3x16(:,:,805))
  call heltable([2,4,8], n3(:,1029), t3x8(:,:,191))
  call heltable([2,8,16], n3(:,1030), t3x16(:,:,806))
  call heltable([2,8,16], n3(:,1031), t3x16(:,:,807))
  call heltable([2,8,16], n3(:,1032), t3x16(:,:,808))
  call heltable([2,8,16], n3(:,1033), t3x16(:,:,809))
  call heltable([8,2,16], n3(:,1034), t3x16(:,:,810))
  call heltable([8,2,16], n3(:,1035), t3x16(:,:,811))
  call heltable([4,2,8], n3(:,1036), t3x8(:,:,192))
  call heltable([2,4,8], n3(:,1037), t3x8(:,:,193))
  call heltable([4,2,8], n3(:,1038), t3x8(:,:,194))
  call heltable([4,2,8], n3(:,1039), t3x8(:,:,195))
  call heltable([4,2,8], n3(:,1040), t3x8(:,:,196))
  call heltable([4,2,8], n3(:,1041), t3x8(:,:,197))
  call heltable([2,4,8], n3(:,1042), t3x8(:,:,198))
  call heltable([4,2,8], n3(:,1043), t3x8(:,:,199))
  call heltable([4,2,8], n3(:,1044), t3x8(:,:,200))
  call heltable([4,2,8], n3(:,1045), t3x8(:,:,201))
  call heltable([4,4,16], n3(:,1046), t3x16(:,:,812))
  call heltable([4,4,16], n3(:,1047), t3x16(:,:,813))
  call heltable([4,4,16], n3(:,1048), t3x16(:,:,814))
  call heltable([4,4,16], n3(:,1049), t3x16(:,:,815))
  call heltable([4,4,16], n3(:,1050), t3x16(:,:,816))
  call heltable([4,4,16], n3(:,1051), t3x16(:,:,817))
  call heltable([4,4,16], n3(:,1052), t3x16(:,:,818))
  call heltable([4,4,16], n3(:,1053), t3x16(:,:,819))
  call heltable([4,4,16], n3(:,1054), t3x16(:,:,820))
  call heltable([4,4,16], n3(:,1055), t3x16(:,:,821))
  call heltable([4,4,16], n3(:,1056), t3x16(:,:,822))
  call heltable([4,4,16], n3(:,1057), t3x16(:,:,823))
  call heltable([4,4,16], n3(:,1058), t3x16(:,:,824))
  call heltable([4,4,16], n3(:,1059), t3x16(:,:,825))
  call heltable([4,4,16], n3(:,1060), t3x16(:,:,826))
  call heltable([4,4,16], n3(:,1061), t3x16(:,:,827))
  call heltable([4,4,16], n3(:,1062), t3x16(:,:,828))
  call heltable([4,4,16], n3(:,1063), t3x16(:,:,829))
  call heltable([4,4,16], n3(:,1064), t3x16(:,:,830))
  call heltable([4,4,16], n3(:,1065), t3x16(:,:,831))
  call heltable([4,4,16], n3(:,1066), t3x16(:,:,832))
  call heltable([4,4,16], n3(:,1067), t3x16(:,:,833))
  call heltable([4,4,16], n3(:,1068), t3x16(:,:,834))
  call heltable([4,4,16], n3(:,1069), t3x16(:,:,835))
  call heltable([4,4,16], n3(:,1070), t3x16(:,:,836))
  call heltable([4,4,16], n3(:,1071), t3x16(:,:,837))
  call heltable([4,4,16], n3(:,1072), t3x16(:,:,838))
  call heltable([4,4,16], n3(:,1073), t3x16(:,:,839))
  call heltable([4,4,16], n3(:,1074), t3x16(:,:,840))
  call heltable([4,4,16], n3(:,1075), t3x16(:,:,841))
  call heltable([4,4,16], n3(:,1076), t3x16(:,:,842))
  call heltable([4,4,16], n3(:,1077), t3x16(:,:,843))
  call heltable([4,4,16], n3(:,1078), t3x16(:,:,844))
  call heltable([4,4,16], n3(:,1079), t3x16(:,:,845))
  call heltable([4,4,16], n3(:,1080), t3x16(:,:,846))
  call heltable([4,4,16], n3(:,1081), t3x16(:,:,847))
  call heltable([4,4,16], n3(:,1082), t3x16(:,:,848))
  call heltable([4,4,16], n3(:,1083), t3x16(:,:,849))
  call heltable([2,8,16], n3(:,1084), t3x16(:,:,850))
  call heltable([2,8,16], n3(:,1085), t3x16(:,:,851))
  call heltable([2,8,16], n3(:,1086), t3x16(:,:,852))
  call heltable([2,8,16], n3(:,1087), t3x16(:,:,853))
  call heltable([2,8,16], n3(:,1088), t3x16(:,:,854))
  call heltable([2,8,16], n3(:,1089), t3x16(:,:,855))
  call heltable([2,8,16], n3(:,1090), t3x16(:,:,856))
  call heltable([2,8,16], n3(:,1091), t3x16(:,:,857))
  call heltable([8,2,16], n3(:,1092), t3x16(:,:,858))
  call heltable([8,2,16], n3(:,1093), t3x16(:,:,859))
  call heltable([8,2,16], n3(:,1094), t3x16(:,:,860))
  call heltable([8,2,16], n3(:,1095), t3x16(:,:,861))
  call heltable([2,8,16], n3(:,1096), t3x16(:,:,862))
  call heltable([2,8,16], n3(:,1097), t3x16(:,:,863))
  call heltable([2,8,16], n3(:,1098), t3x16(:,:,864))
  call heltable([2,8,16], n3(:,1099), t3x16(:,:,865))
  call heltable([8,2,16], n3(:,1100), t3x16(:,:,866))
  call heltable([8,2,16], n3(:,1101), t3x16(:,:,867))
  call heltable([8,2,16], n3(:,1102), t3x16(:,:,868))
  call heltable([8,2,16], n3(:,1103), t3x16(:,:,869))
  call heltable([2,8,16], n3(:,1104), t3x16(:,:,870))
  call heltable([2,8,16], n3(:,1105), t3x16(:,:,871))
  call heltable([2,8,16], n3(:,1106), t3x16(:,:,872))
  call heltable([2,8,16], n3(:,1107), t3x16(:,:,873))
  call heltable([8,2,16], n3(:,1108), t3x16(:,:,874))
  call heltable([8,2,16], n3(:,1109), t3x16(:,:,875))
  call heltable([8,2,16], n3(:,1110), t3x16(:,:,876))
  call heltable([8,2,16], n3(:,1111), t3x16(:,:,877))
  call heltable([2,8,16], n3(:,1112), t3x16(:,:,878))
  call heltable([2,8,16], n3(:,1113), t3x16(:,:,879))
  call heltable([2,8,16], n3(:,1114), t3x16(:,:,880))
  call heltable([2,8,16], n3(:,1115), t3x16(:,:,881))
  call heltable([8,2,16], n3(:,1116), t3x16(:,:,882))
  call heltable([8,2,16], n3(:,1117), t3x16(:,:,883))
  call heltable([8,2,16], n3(:,1118), t3x16(:,:,884))
  call heltable([8,2,16], n3(:,1119), t3x16(:,:,885))
  call heltable([2,8,16], n3(:,1120), t3x16(:,:,886))
  call heltable([2,8,16], n3(:,1121), t3x16(:,:,887))
  call heltable([2,8,16], n3(:,1122), t3x16(:,:,888))
  call heltable([2,8,16], n3(:,1123), t3x16(:,:,889))
  call heltable([2,8,16], n3(:,1124), t3x16(:,:,890))
  call heltable([2,8,16], n3(:,1125), t3x16(:,:,891))
  call heltable([2,8,16], n3(:,1126), t3x16(:,:,892))
  call heltable([2,8,16], n3(:,1127), t3x16(:,:,893))
  call heltable([8,2,16], n3(:,1128), t3x16(:,:,894))
  call heltable([8,2,16], n3(:,1129), t3x16(:,:,895))
  call heltable([8,2,16], n3(:,1130), t3x16(:,:,896))
  call heltable([8,2,16], n3(:,1131), t3x16(:,:,897))
  call heltable([2,8,16], n3(:,1132), t3x16(:,:,898))
  call heltable([2,8,16], n3(:,1133), t3x16(:,:,899))
  call heltable([2,8,16], n3(:,1134), t3x16(:,:,900))
  call heltable([2,8,16], n3(:,1135), t3x16(:,:,901))
  call heltable([8,2,16], n3(:,1136), t3x16(:,:,902))
  call heltable([8,2,16], n3(:,1137), t3x16(:,:,903))
  call heltable([8,2,16], n3(:,1138), t3x16(:,:,904))
  call heltable([8,2,16], n3(:,1139), t3x16(:,:,905))
  call heltable([8,2,16], n3(:,1140), t3x16(:,:,906))
  call heltable([8,2,16], n3(:,1141), t3x16(:,:,907))
  call heltable([8,2,16], n3(:,1142), t3x16(:,:,908))
  call heltable([8,2,16], n3(:,1143), t3x16(:,:,909))
  call heltable([2,8,16], n3(:,1144), t3x16(:,:,910))
  call heltable([2,8,16], n3(:,1145), t3x16(:,:,911))
  call heltable([2,8,16], n3(:,1146), t3x16(:,:,912))
  call heltable([2,8,16], n3(:,1147), t3x16(:,:,913))
  call heltable([8,2,16], n3(:,1148), t3x16(:,:,914))
  call heltable([8,2,16], n3(:,1149), t3x16(:,:,915))
  call heltable([8,2,16], n3(:,1150), t3x16(:,:,916))
  call heltable([8,2,16], n3(:,1151), t3x16(:,:,917))
  call heltable([2,8,16], n3(:,1152), t3x16(:,:,918))
  call heltable([2,8,16], n3(:,1153), t3x16(:,:,919))
  call heltable([2,8,16], n3(:,1154), t3x16(:,:,920))
  call heltable([2,8,16], n3(:,1155), t3x16(:,:,921))
  call heltable([4,2,8], n3(:,1156), t3x8(:,:,202))
  n2(146) = 16
  call heltable([4,2,8], n3(:,1157), t3x8(:,:,203))
  n2(147) = 16
  call heltable([2,4,8], n3(:,1158), t3x8(:,:,204))
  call heltable([2,4,8], n3(:,1159), t3x8(:,:,205))
  n2(148) = 16
  n2(149) = 16
  call heltable([4,2,8], n3(:,1160), t3x8(:,:,206))
  n2(150) = 16
  n2(151) = 16
  call heltable([4,2,8], n3(:,1161), t3x8(:,:,207))
  n2(152) = 16
  n2(153) = 16
  call heltable([2,4,8], n3(:,1162), t3x8(:,:,208))
  call heltable([2,4,8], n3(:,1163), t3x8(:,:,209))
  n2(154) = 8
  n2(155) = 8
  n2(156) = 8
  n2(157) = 8
  n2(158) = 8
  n2(159) = 8
  n2(160) = 8
  n2(161) = 8
  call heltable([4,4,16], n3(:,1164), t3x16(:,:,922))
  call heltable([4,4,16], n3(:,1165), t3x16(:,:,923))
  call heltable([4,4,16], n3(:,1166), t3x16(:,:,924))
  call heltable([4,4,16], n3(:,1167), t3x16(:,:,925))
  call heltable([4,4,16], n3(:,1168), t3x16(:,:,926))
  call heltable([4,4,16], n3(:,1169), t3x16(:,:,927))
  call heltable([4,4,16], n3(:,1170), t3x16(:,:,928))
  call heltable([4,4,16], n3(:,1171), t3x16(:,:,929))
  call heltable([2,4,8], n3(:,1172), t3x8(:,:,210))
  n2(162) = 16
  call heltable([2,4,8], n3(:,1173), t3x8(:,:,211))
  n2(163) = 16
  call heltable([4,2,8], n3(:,1174), t3x8(:,:,212))
  call heltable([4,2,8], n3(:,1175), t3x8(:,:,213))
  n2(164) = 16
  n2(165) = 16
  call heltable([2,4,8], n3(:,1176), t3x8(:,:,214))
  n2(166) = 16
  n2(167) = 16
  call heltable([2,4,8], n3(:,1177), t3x8(:,:,215))
  n2(168) = 16
  n2(169) = 16
  call heltable([4,2,8], n3(:,1178), t3x8(:,:,216))
  call heltable([4,2,8], n3(:,1179), t3x8(:,:,217))
  n2(170) = 8
  call heltable([2,8,16], n3(:,1180), t3x16(:,:,930))
  n2(171) = 8
  call heltable([2,8,16], n3(:,1181), t3x16(:,:,931))
  n2(172) = 8
  call heltable([2,8,16], n3(:,1182), t3x16(:,:,932))
  n2(173) = 8
  call heltable([2,8,16], n3(:,1183), t3x16(:,:,933))
  n2(174) = 8
  call heltable([2,8,16], n3(:,1184), t3x16(:,:,934))
  n2(175) = 8
  call heltable([2,8,16], n3(:,1185), t3x16(:,:,935))
  n2(176) = 8
  call heltable([2,8,16], n3(:,1186), t3x16(:,:,936))
  n2(177) = 8
  call heltable([2,8,16], n3(:,1187), t3x16(:,:,937))
  call heltable([4,4,16], n3(:,1188), t3x16(:,:,938))
  call heltable([4,4,16], n3(:,1189), t3x16(:,:,939))
  call heltable([4,4,16], n3(:,1190), t3x16(:,:,940))
  call heltable([4,4,16], n3(:,1191), t3x16(:,:,941))
  call heltable([4,4,16], n3(:,1192), t3x16(:,:,942))
  call heltable([4,4,16], n3(:,1193), t3x16(:,:,943))
  call heltable([4,4,16], n3(:,1194), t3x16(:,:,944))
  call heltable([4,4,16], n3(:,1195), t3x16(:,:,945))
  call heltable([4,4,16], n3(:,1196), t3x16(:,:,946))
  call heltable([4,4,16], n3(:,1197), t3x16(:,:,947))
  call heltable([4,4,16], n3(:,1198), t3x16(:,:,948))
  call heltable([4,4,16], n3(:,1199), t3x16(:,:,949))
  call heltable([4,4,16], n3(:,1200), t3x16(:,:,950))
  call heltable([4,4,16], n3(:,1201), t3x16(:,:,951))
  call heltable([4,4,16], n3(:,1202), t3x16(:,:,952))
  call heltable([4,4,16], n3(:,1203), t3x16(:,:,953))
  call heltable([4,4,16], n3(:,1204), t3x16(:,:,954))
  call heltable([4,4,16], n3(:,1205), t3x16(:,:,955))
  call heltable([4,4,16], n3(:,1206), t3x16(:,:,956))
  call heltable([4,4,16], n3(:,1207), t3x16(:,:,957))
  call heltable([4,4,16], n3(:,1208), t3x16(:,:,958))
  call heltable([4,4,16], n3(:,1209), t3x16(:,:,959))
  call heltable([4,4,16], n3(:,1210), t3x16(:,:,960))
  call heltable([4,4,16], n3(:,1211), t3x16(:,:,961))
  call heltable([4,4,16], n3(:,1212), t3x16(:,:,962))
  call heltable([4,4,16], n3(:,1213), t3x16(:,:,963))
  call heltable([4,4,16], n3(:,1214), t3x16(:,:,964))
  call heltable([4,4,16], n3(:,1215), t3x16(:,:,965))
  call heltable([4,4,16], n3(:,1216), t3x16(:,:,966))
  call heltable([4,4,16], n3(:,1217), t3x16(:,:,967))
  call heltable([4,4,16], n3(:,1218), t3x16(:,:,968))
  call heltable([4,4,16], n3(:,1219), t3x16(:,:,969))
  call heltable([4,4,16], n3(:,1220), t3x16(:,:,970))
  call heltable([4,4,16], n3(:,1221), t3x16(:,:,971))
  call heltable([4,4,16], n3(:,1222), t3x16(:,:,972))
  call heltable([4,4,16], n3(:,1223), t3x16(:,:,973))
  call heltable([4,4,16], n3(:,1224), t3x16(:,:,974))
  call heltable([4,4,16], n3(:,1225), t3x16(:,:,975))
  call heltable([4,4,16], n3(:,1226), t3x16(:,:,976))
  call heltable([4,4,16], n3(:,1227), t3x16(:,:,977))
  call heltable([4,4,16], n3(:,1228), t3x16(:,:,978))
  call heltable([4,4,16], n3(:,1229), t3x16(:,:,979))
  call heltable([2,8,16], n3(:,1230), t3x16(:,:,980))
  call heltable([2,8,16], n3(:,1231), t3x16(:,:,981))
  call heltable([2,8,16], n3(:,1232), t3x16(:,:,982))
  call heltable([2,8,16], n3(:,1233), t3x16(:,:,983))
  call heltable([8,2,16], n3(:,1234), t3x16(:,:,984))
  call heltable([8,2,16], n3(:,1235), t3x16(:,:,985))
  call heltable([8,2,16], n3(:,1236), t3x16(:,:,986))
  call heltable([8,2,16], n3(:,1237), t3x16(:,:,987))
  call heltable([8,2,16], n3(:,1238), t3x16(:,:,988))
  call heltable([8,2,16], n3(:,1239), t3x16(:,:,989))
  call heltable([8,2,16], n3(:,1240), t3x16(:,:,990))
  call heltable([8,2,16], n3(:,1241), t3x16(:,:,991))
  call heltable([2,8,16], n3(:,1242), t3x16(:,:,992))
  call heltable([2,8,16], n3(:,1243), t3x16(:,:,993))
  call heltable([2,8,16], n3(:,1244), t3x16(:,:,994))
  call heltable([2,8,16], n3(:,1245), t3x16(:,:,995))
  call heltable([2,8,16], n3(:,1246), t3x16(:,:,996))
  call heltable([2,8,16], n3(:,1247), t3x16(:,:,997))
  call heltable([2,8,16], n3(:,1248), t3x16(:,:,998))
  call heltable([2,8,16], n3(:,1249), t3x16(:,:,999))
  call heltable([2,8,16], n3(:,1250), t3x16(:,:,1000))
  call heltable([2,8,16], n3(:,1251), t3x16(:,:,1001))
  call heltable([2,8,16], n3(:,1252), t3x16(:,:,1002))
  call heltable([2,8,16], n3(:,1253), t3x16(:,:,1003))
  call heltable([8,2,16], n3(:,1254), t3x16(:,:,1004))
  call heltable([8,2,16], n3(:,1255), t3x16(:,:,1005))
  call heltable([2,8,16], n3(:,1256), t3x16(:,:,1006))
  call heltable([2,8,16], n3(:,1257), t3x16(:,:,1007))
  call heltable([8,2,16], n3(:,1258), t3x16(:,:,1008))
  call heltable([8,2,16], n3(:,1259), t3x16(:,:,1009))
  call heltable([2,8,16], n3(:,1260), t3x16(:,:,1010))
  call heltable([2,8,16], n3(:,1261), t3x16(:,:,1011))
  call heltable([2,8,16], n3(:,1262), t3x16(:,:,1012))
  call heltable([2,8,16], n3(:,1263), t3x16(:,:,1013))
  call heltable([8,2,16], n3(:,1264), t3x16(:,:,1014))
  call heltable([8,2,16], n3(:,1265), t3x16(:,:,1015))
  call heltable([2,8,16], n3(:,1266), t3x16(:,:,1016))
  call heltable([2,8,16], n3(:,1267), t3x16(:,:,1017))
  call heltable([8,2,16], n3(:,1268), t3x16(:,:,1018))
  call heltable([8,2,16], n3(:,1269), t3x16(:,:,1019))
  call heltable([4,4,16], n3(:,1270), t3x16(:,:,1020))
  call heltable([4,4,16], n3(:,1271), t3x16(:,:,1021))
  call heltable([4,4,16], n3(:,1272), t3x16(:,:,1022))
  call heltable([4,4,16], n3(:,1273), t3x16(:,:,1023))
  call heltable([4,4,16], n3(:,1274), t3x16(:,:,1024))
  call heltable([4,4,16], n3(:,1275), t3x16(:,:,1025))
  call heltable([4,4,16], n3(:,1276), t3x16(:,:,1026))
  call heltable([4,4,16], n3(:,1277), t3x16(:,:,1027))
  call heltable([4,4,16], n3(:,1278), t3x16(:,:,1028))
  call heltable([4,4,16], n3(:,1279), t3x16(:,:,1029))
  call heltable([4,4,16], n3(:,1280), t3x16(:,:,1030))
  call heltable([4,4,16], n3(:,1281), t3x16(:,:,1031))
  call heltable([4,4,16], n3(:,1282), t3x16(:,:,1032))
  call heltable([4,4,16], n3(:,1283), t3x16(:,:,1033))
  call heltable([4,4,16], n3(:,1284), t3x16(:,:,1034))
  call heltable([4,4,16], n3(:,1285), t3x16(:,:,1035))
  call heltable([4,4,16], n3(:,1286), t3x16(:,:,1036))
  call heltable([2,4,8], n3(:,1287), t3x8(:,:,218))
  n2(178) = 8
  call heltable([2,4,8], n3(:,1288), t3x8(:,:,219))
  n2(179) = 8
  call heltable([4,2,8], n3(:,1289), t3x8(:,:,220))
  n2(180) = 8
  call heltable([4,2,8], n3(:,1290), t3x8(:,:,221))
  n2(181) = 8
  call heltable([2,8,16], n3(:,1291), t3x16(:,:,1037))
  call heltable([2,8,16], n3(:,1292), t3x16(:,:,1038))
  call heltable([2,8,16], n3(:,1293), t3x16(:,:,1039))
  call heltable([2,8,16], n3(:,1294), t3x16(:,:,1040))
  n2(182) = 16
  n2(183) = 16
  n2(184) = 16
  n2(185) = 16
  call heltable([4,2,8], n3(:,1295), t3x8(:,:,222))
  n2(186) = 16
  n2(187) = 16
  call heltable([4,2,8], n3(:,1296), t3x8(:,:,223))
  n2(188) = 16
  n2(189) = 16
  call heltable([2,4,8], n3(:,1297), t3x8(:,:,224))
  call heltable([2,4,8], n3(:,1298), t3x8(:,:,225))
  call heltable([2,4,8], n3(:,1299), t3x8(:,:,226))
  call heltable([2,4,8], n3(:,1300), t3x8(:,:,227))
  call heltable([4,2,8], n3(:,1301), t3x8(:,:,228))
  n2(190) = 8
  n2(191) = 8
  n2(192) = 8
  n2(193) = 8
  call heltable([4,4,16], n3(:,1302), t3x16(:,:,1041))
  call heltable([4,4,16], n3(:,1303), t3x16(:,:,1042))
  call heltable([4,4,16], n3(:,1304), t3x16(:,:,1043))
  call heltable([4,4,16], n3(:,1305), t3x16(:,:,1044))
  call heltable([4,2,8], n3(:,1306), t3x8(:,:,229))
  call heltable([4,2,8], n3(:,1307), t3x8(:,:,230))
  call heltable([2,4,8], n3(:,1308), t3x8(:,:,231))
  call heltable([8,2,16], n3(:,1309), t3x16(:,:,1045))
  call heltable([8,2,16], n3(:,1310), t3x16(:,:,1046))
  call heltable([4,2,8], n3(:,1311), t3x8(:,:,232))
  call heltable([2,8,16], n3(:,1312), t3x16(:,:,1047))
  call heltable([2,8,16], n3(:,1313), t3x16(:,:,1048))
  call heltable([2,8,16], n3(:,1314), t3x16(:,:,1049))
  call heltable([2,8,16], n3(:,1315), t3x16(:,:,1050))
  call heltable([8,2,16], n3(:,1316), t3x16(:,:,1051))
  call heltable([8,2,16], n3(:,1317), t3x16(:,:,1052))
  call heltable([2,8,16], n3(:,1318), t3x16(:,:,1053))
  call heltable([2,8,16], n3(:,1319), t3x16(:,:,1054))
  call heltable([2,8,16], n3(:,1320), t3x16(:,:,1055))
  call heltable([2,8,16], n3(:,1321), t3x16(:,:,1056))
  call heltable([8,2,16], n3(:,1322), t3x16(:,:,1057))
  call heltable([8,2,16], n3(:,1323), t3x16(:,:,1058))
  call heltable([8,2,16], n3(:,1324), t3x16(:,:,1059))
  call heltable([8,2,16], n3(:,1325), t3x16(:,:,1060))
  call heltable([2,8,16], n3(:,1326), t3x16(:,:,1061))
  call heltable([2,8,16], n3(:,1327), t3x16(:,:,1062))
  call heltable([2,8,16], n3(:,1328), t3x16(:,:,1063))
  call heltable([2,8,16], n3(:,1329), t3x16(:,:,1064))
  call heltable([8,2,16], n3(:,1330), t3x16(:,:,1065))
  call heltable([8,2,16], n3(:,1331), t3x16(:,:,1066))
  call heltable([8,2,16], n3(:,1332), t3x16(:,:,1067))
  call heltable([8,2,16], n3(:,1333), t3x16(:,:,1068))
  call heltable([8,2,16], n3(:,1334), t3x16(:,:,1069))
  call heltable([8,2,16], n3(:,1335), t3x16(:,:,1070))
  call heltable([8,2,16], n3(:,1336), t3x16(:,:,1071))
  call heltable([8,2,16], n3(:,1337), t3x16(:,:,1072))
  call heltable([8,2,16], n3(:,1338), t3x16(:,:,1073))
  call heltable([8,2,16], n3(:,1339), t3x16(:,:,1074))
  call heltable([8,2,16], n3(:,1340), t3x16(:,:,1075))
  call heltable([8,2,16], n3(:,1341), t3x16(:,:,1076))
  call heltable([2,8,16], n3(:,1342), t3x16(:,:,1077))
  call heltable([2,8,16], n3(:,1343), t3x16(:,:,1078))
  call heltable([2,8,16], n3(:,1344), t3x16(:,:,1079))
  call heltable([2,8,16], n3(:,1345), t3x16(:,:,1080))
  call heltable([2,8,16], n3(:,1346), t3x16(:,:,1081))
  call heltable([2,8,16], n3(:,1347), t3x16(:,:,1082))
  call heltable([2,8,16], n3(:,1348), t3x16(:,:,1083))
  call heltable([2,8,16], n3(:,1349), t3x16(:,:,1084))
  call heltable([2,8,16], n3(:,1350), t3x16(:,:,1085))
  call heltable([2,8,16], n3(:,1351), t3x16(:,:,1086))
  call heltable([2,4,8], n3(:,1352), t3x8(:,:,233))
  call heltable([8,2,16], n3(:,1353), t3x16(:,:,1087))
  call heltable([8,2,16], n3(:,1354), t3x16(:,:,1088))
  call heltable([8,2,16], n3(:,1355), t3x16(:,:,1089))
  call heltable([8,2,16], n3(:,1356), t3x16(:,:,1090))
  call heltable([2,8,16], n3(:,1357), t3x16(:,:,1091))
  call heltable([2,8,16], n3(:,1358), t3x16(:,:,1092))
  call heltable([4,4,16], n3(:,1359), t3x16(:,:,1093))
  call heltable([4,4,16], n3(:,1360), t3x16(:,:,1094))
  call heltable([4,4,16], n3(:,1361), t3x16(:,:,1095))
  call heltable([4,4,16], n3(:,1362), t3x16(:,:,1096))
  call heltable([4,4,16], n3(:,1363), t3x16(:,:,1097))
  call heltable([4,4,16], n3(:,1364), t3x16(:,:,1098))
  call heltable([4,4,16], n3(:,1365), t3x16(:,:,1099))
  call heltable([4,4,16], n3(:,1366), t3x16(:,:,1100))
  call heltable([4,4,16], n3(:,1367), t3x16(:,:,1101))
  call heltable([4,4,16], n3(:,1368), t3x16(:,:,1102))
  call heltable([4,4,16], n3(:,1369), t3x16(:,:,1103))
  call heltable([4,4,16], n3(:,1370), t3x16(:,:,1104))
  call heltable([4,4,16], n3(:,1371), t3x16(:,:,1105))
  call heltable([4,4,16], n3(:,1372), t3x16(:,:,1106))
  call heltable([4,4,16], n3(:,1373), t3x16(:,:,1107))
  call heltable([4,4,16], n3(:,1374), t3x16(:,:,1108))
  call heltable([4,4,16], n3(:,1375), t3x16(:,:,1109))
  call heltable([4,4,16], n3(:,1376), t3x16(:,:,1110))
  call heltable([4,4,16], n3(:,1377), t3x16(:,:,1111))
  call heltable([4,4,16], n3(:,1378), t3x16(:,:,1112))
  call heltable([4,4,16], n3(:,1379), t3x16(:,:,1113))
  call heltable([4,4,16], n3(:,1380), t3x16(:,:,1114))
  call heltable([4,4,16], n3(:,1381), t3x16(:,:,1115))
  call heltable([4,4,16], n3(:,1382), t3x16(:,:,1116))
  call heltable([4,4,16], n3(:,1383), t3x16(:,:,1117))
  call heltable([4,4,16], n3(:,1384), t3x16(:,:,1118))
  call heltable([4,4,16], n3(:,1385), t3x16(:,:,1119))
  call heltable([4,4,16], n3(:,1386), t3x16(:,:,1120))
  call heltable([4,4,16], n3(:,1387), t3x16(:,:,1121))
  call heltable([4,4,16], n3(:,1388), t3x16(:,:,1122))
  call heltable([4,4,16], n3(:,1389), t3x16(:,:,1123))
  call heltable([4,4,16], n3(:,1390), t3x16(:,:,1124))
  call heltable([4,4,16], n3(:,1391), t3x16(:,:,1125))
  call heltable([4,4,16], n3(:,1392), t3x16(:,:,1126))
  call heltable([2,8,16], n3(:,1393), t3x16(:,:,1127))
  call heltable([2,8,16], n3(:,1394), t3x16(:,:,1128))
  call heltable([2,8,16], n3(:,1395), t3x16(:,:,1129))
  call heltable([2,8,16], n3(:,1396), t3x16(:,:,1130))
  call heltable([8,2,16], n3(:,1397), t3x16(:,:,1131))
  call heltable([8,2,16], n3(:,1398), t3x16(:,:,1132))
  call heltable([2,8,16], n3(:,1399), t3x16(:,:,1133))
  call heltable([2,8,16], n3(:,1400), t3x16(:,:,1134))
  call heltable([8,2,16], n3(:,1401), t3x16(:,:,1135))
  call heltable([8,2,16], n3(:,1402), t3x16(:,:,1136))
  call heltable([2,8,16], n3(:,1403), t3x16(:,:,1137))
  call heltable([2,8,16], n3(:,1404), t3x16(:,:,1138))
  call heltable([2,8,16], n3(:,1405), t3x16(:,:,1139))
  call heltable([2,8,16], n3(:,1406), t3x16(:,:,1140))
  call heltable([8,2,16], n3(:,1407), t3x16(:,:,1141))
  call heltable([8,2,16], n3(:,1408), t3x16(:,:,1142))
  call heltable([2,8,16], n3(:,1409), t3x16(:,:,1143))
  call heltable([2,8,16], n3(:,1410), t3x16(:,:,1144))
  call heltable([8,2,16], n3(:,1411), t3x16(:,:,1145))
  call heltable([8,2,16], n3(:,1412), t3x16(:,:,1146))
  call heltable([4,4,16], n3(:,1413), t3x16(:,:,1147))
  call heltable([4,4,16], n3(:,1414), t3x16(:,:,1148))
  call heltable([4,4,16], n3(:,1415), t3x16(:,:,1149))
  call heltable([4,4,16], n3(:,1416), t3x16(:,:,1150))
  call heltable([4,4,16], n3(:,1417), t3x16(:,:,1151))
  call heltable([4,4,16], n3(:,1418), t3x16(:,:,1152))
  call heltable([4,4,16], n3(:,1419), t3x16(:,:,1153))
  call heltable([4,4,16], n3(:,1420), t3x16(:,:,1154))
  call heltable([4,4,16], n3(:,1421), t3x16(:,:,1155))
  call heltable([4,4,16], n3(:,1422), t3x16(:,:,1156))
  call heltable([4,4,16], n3(:,1423), t3x16(:,:,1157))
  call heltable([4,4,16], n3(:,1424), t3x16(:,:,1158))
  call heltable([4,4,16], n3(:,1425), t3x16(:,:,1159))
  call heltable([4,2,8], n3(:,1426), t3x8(:,:,234))
  n2(194) = 8
  call heltable([4,2,8], n3(:,1427), t3x8(:,:,235))
  n2(195) = 8
  call heltable([2,4,8], n3(:,1428), t3x8(:,:,236))
  n2(196) = 8
  call heltable([2,4,8], n3(:,1429), t3x8(:,:,237))
  n2(197) = 8
  call heltable([4,4,16], n3(:,1430), t3x16(:,:,1160))
  call heltable([4,4,16], n3(:,1431), t3x16(:,:,1161))
  call heltable([4,4,16], n3(:,1432), t3x16(:,:,1162))
  call heltable([4,4,16], n3(:,1433), t3x16(:,:,1163))
  call heltable([4,4,16], n3(:,1434), t3x16(:,:,1164))
  call heltable([4,4,16], n3(:,1435), t3x16(:,:,1165))
  call heltable([4,4,16], n3(:,1436), t3x16(:,:,1166))
  call heltable([4,4,16], n3(:,1437), t3x16(:,:,1167))
  call heltable([4,4,16], n3(:,1438), t3x16(:,:,1168))
  call heltable([4,4,16], n3(:,1439), t3x16(:,:,1169))
  call heltable([4,4,16], n3(:,1440), t3x16(:,:,1170))
  call heltable([4,4,16], n3(:,1441), t3x16(:,:,1171))
  call heltable([4,4,16], n3(:,1442), t3x16(:,:,1172))
  call heltable([4,4,16], n3(:,1443), t3x16(:,:,1173))
  call heltable([4,4,16], n3(:,1444), t3x16(:,:,1174))
  call heltable([4,4,16], n3(:,1445), t3x16(:,:,1175))
  call heltable([4,4,16], n3(:,1446), t3x16(:,:,1176))
  call heltable([4,4,16], n3(:,1447), t3x16(:,:,1177))
  call heltable([4,4,16], n3(:,1448), t3x16(:,:,1178))
  call heltable([4,4,16], n3(:,1449), t3x16(:,:,1179))
  call heltable([4,4,16], n3(:,1450), t3x16(:,:,1180))
  call heltable([4,4,16], n3(:,1451), t3x16(:,:,1181))
  call heltable([4,4,16], n3(:,1452), t3x16(:,:,1182))
  call heltable([4,4,16], n3(:,1453), t3x16(:,:,1183))
  call heltable([4,4,16], n3(:,1454), t3x16(:,:,1184))
  call heltable([4,4,16], n3(:,1455), t3x16(:,:,1185))
  call heltable([4,4,16], n3(:,1456), t3x16(:,:,1186))
  call heltable([4,4,16], n3(:,1457), t3x16(:,:,1187))
  call heltable([4,4,16], n3(:,1458), t3x16(:,:,1188))
  call heltable([4,4,16], n3(:,1459), t3x16(:,:,1189))
  call heltable([4,4,16], n3(:,1460), t3x16(:,:,1190))
  call heltable([4,4,16], n3(:,1461), t3x16(:,:,1191))
  call heltable([4,4,16], n3(:,1462), t3x16(:,:,1192))
  call heltable([4,4,16], n3(:,1463), t3x16(:,:,1193))
  call heltable([2,8,16], n3(:,1464), t3x16(:,:,1194))
  call heltable([2,8,16], n3(:,1465), t3x16(:,:,1195))
  call heltable([2,8,16], n3(:,1466), t3x16(:,:,1196))
  call heltable([2,8,16], n3(:,1467), t3x16(:,:,1197))
  call heltable([8,2,16], n3(:,1468), t3x16(:,:,1198))
  call heltable([8,2,16], n3(:,1469), t3x16(:,:,1199))
  call heltable([2,8,16], n3(:,1470), t3x16(:,:,1200))
  call heltable([2,8,16], n3(:,1471), t3x16(:,:,1201))
  call heltable([8,2,16], n3(:,1472), t3x16(:,:,1202))
  call heltable([8,2,16], n3(:,1473), t3x16(:,:,1203))
  call heltable([2,8,16], n3(:,1474), t3x16(:,:,1204))
  call heltable([2,8,16], n3(:,1475), t3x16(:,:,1205))
  call heltable([2,8,16], n3(:,1476), t3x16(:,:,1206))
  call heltable([2,8,16], n3(:,1477), t3x16(:,:,1207))
  call heltable([8,2,16], n3(:,1478), t3x16(:,:,1208))
  call heltable([8,2,16], n3(:,1479), t3x16(:,:,1209))
  call heltable([2,8,16], n3(:,1480), t3x16(:,:,1210))
  call heltable([2,8,16], n3(:,1481), t3x16(:,:,1211))
  call heltable([8,2,16], n3(:,1482), t3x16(:,:,1212))
  call heltable([8,2,16], n3(:,1483), t3x16(:,:,1213))
  call heltable([4,4,16], n3(:,1484), t3x16(:,:,1214))
  call heltable([4,4,16], n3(:,1485), t3x16(:,:,1215))
  call heltable([4,4,16], n3(:,1486), t3x16(:,:,1216))
  call heltable([4,4,16], n3(:,1487), t3x16(:,:,1217))
  call heltable([4,4,16], n3(:,1488), t3x16(:,:,1218))
  call heltable([4,4,16], n3(:,1489), t3x16(:,:,1219))
  call heltable([4,4,16], n3(:,1490), t3x16(:,:,1220))
  call heltable([4,4,16], n3(:,1491), t3x16(:,:,1221))
  call heltable([4,4,16], n3(:,1492), t3x16(:,:,1222))
  call heltable([4,4,16], n3(:,1493), t3x16(:,:,1223))
  call heltable([4,4,16], n3(:,1494), t3x16(:,:,1224))
  call heltable([4,4,16], n3(:,1495), t3x16(:,:,1225))
  call heltable([4,4,16], n3(:,1496), t3x16(:,:,1226))
  call heltable([2,8,16], n3(:,1497), t3x16(:,:,1227))
  call heltable([2,8,16], n3(:,1498), t3x16(:,:,1228))
  call heltable([2,8,16], n3(:,1499), t3x16(:,:,1229))
  call heltable([2,8,16], n3(:,1500), t3x16(:,:,1230))
  call heltable([8,2,16], n3(:,1501), t3x16(:,:,1231))
  call heltable([8,2,16], n3(:,1502), t3x16(:,:,1232))
  call heltable([8,2,16], n3(:,1503), t3x16(:,:,1233))
  call heltable([8,2,16], n3(:,1504), t3x16(:,:,1234))
  call heltable([2,8,16], n3(:,1505), t3x16(:,:,1235))
  call heltable([2,8,16], n3(:,1506), t3x16(:,:,1236))
  call heltable([2,8,16], n3(:,1507), t3x16(:,:,1237))
  call heltable([2,8,16], n3(:,1508), t3x16(:,:,1238))
  call heltable([8,2,16], n3(:,1509), t3x16(:,:,1239))
  call heltable([8,2,16], n3(:,1510), t3x16(:,:,1240))
  call heltable([8,2,16], n3(:,1511), t3x16(:,:,1241))
  call heltable([8,2,16], n3(:,1512), t3x16(:,:,1242))
  call heltable([8,2,16], n3(:,1513), t3x16(:,:,1243))
  call heltable([8,2,16], n3(:,1514), t3x16(:,:,1244))
  call heltable([8,2,16], n3(:,1515), t3x16(:,:,1245))
  call heltable([8,2,16], n3(:,1516), t3x16(:,:,1246))
  call heltable([8,2,16], n3(:,1517), t3x16(:,:,1247))
  call heltable([8,2,16], n3(:,1518), t3x16(:,:,1248))
  call heltable([8,2,16], n3(:,1519), t3x16(:,:,1249))
  call heltable([8,2,16], n3(:,1520), t3x16(:,:,1250))
  call heltable([2,8,16], n3(:,1521), t3x16(:,:,1251))
  call heltable([2,8,16], n3(:,1522), t3x16(:,:,1252))
  call heltable([2,8,16], n3(:,1523), t3x16(:,:,1253))
  call heltable([2,8,16], n3(:,1524), t3x16(:,:,1254))
  call heltable([2,8,16], n3(:,1525), t3x16(:,:,1255))
  call heltable([2,8,16], n3(:,1526), t3x16(:,:,1256))
  call heltable([2,8,16], n3(:,1527), t3x16(:,:,1257))
  call heltable([2,8,16], n3(:,1528), t3x16(:,:,1258))
  call heltable([2,8,16], n3(:,1529), t3x16(:,:,1259))
  call heltable([2,8,16], n3(:,1530), t3x16(:,:,1260))
  call heltable([2,8,16], n3(:,1531), t3x16(:,:,1261))
  call heltable([2,8,16], n3(:,1532), t3x16(:,:,1262))
  call heltable([8,2,16], n3(:,1533), t3x16(:,:,1263))
  call heltable([8,2,16], n3(:,1534), t3x16(:,:,1264))
  call heltable([8,2,16], n3(:,1535), t3x16(:,:,1265))
  call heltable([8,2,16], n3(:,1536), t3x16(:,:,1266))
  call heltable([2,8,16], n3(:,1537), t3x16(:,:,1267))
  call heltable([2,8,16], n3(:,1538), t3x16(:,:,1268))
  call heltable([2,8,16], n3(:,1539), t3x16(:,:,1269))
  call heltable([2,8,16], n3(:,1540), t3x16(:,:,1270))
  call heltable([8,2,16], n3(:,1541), t3x16(:,:,1271))
  call heltable([8,2,16], n3(:,1542), t3x16(:,:,1272))
  call heltable([8,2,16], n3(:,1543), t3x16(:,:,1273))
  call heltable([8,2,16], n3(:,1544), t3x16(:,:,1274))
  call heltable([8,2,16], n3(:,1545), t3x16(:,:,1275))
  call heltable([8,2,16], n3(:,1546), t3x16(:,:,1276))
  call heltable([8,2,16], n3(:,1547), t3x16(:,:,1277))
  call heltable([8,2,16], n3(:,1548), t3x16(:,:,1278))
  call heltable([8,2,16], n3(:,1549), t3x16(:,:,1279))
  call heltable([8,2,16], n3(:,1550), t3x16(:,:,1280))
  call heltable([8,2,16], n3(:,1551), t3x16(:,:,1281))
  call heltable([8,2,16], n3(:,1552), t3x16(:,:,1282))
  call heltable([2,8,16], n3(:,1553), t3x16(:,:,1283))
  call heltable([2,8,16], n3(:,1554), t3x16(:,:,1284))
  call heltable([2,8,16], n3(:,1555), t3x16(:,:,1285))
  call heltable([2,8,16], n3(:,1556), t3x16(:,:,1286))
  call heltable([2,8,16], n3(:,1557), t3x16(:,:,1287))
  call heltable([2,8,16], n3(:,1558), t3x16(:,:,1288))
  call heltable([2,8,16], n3(:,1559), t3x16(:,:,1289))
  call heltable([2,8,16], n3(:,1560), t3x16(:,:,1290))
  call heltable([2,8,16], n3(:,1561), t3x16(:,:,1291))
  call heltable([2,8,16], n3(:,1562), t3x16(:,:,1292))
  call heltable([2,8,16], n3(:,1563), t3x16(:,:,1293))
  call heltable([2,8,16], n3(:,1564), t3x16(:,:,1294))
  call heltable([8,2,16], n3(:,1565), t3x16(:,:,1295))
  call heltable([8,2,16], n3(:,1566), t3x16(:,:,1296))
  call heltable([8,2,16], n3(:,1567), t3x16(:,:,1297))
  call heltable([8,2,16], n3(:,1568), t3x16(:,:,1298))
  call heltable([2,8,16], n3(:,1569), t3x16(:,:,1299))
  call heltable([2,8,16], n3(:,1570), t3x16(:,:,1300))
  call heltable([2,8,16], n3(:,1571), t3x16(:,:,1301))
  call heltable([2,8,16], n3(:,1572), t3x16(:,:,1302))
  call heltable([8,2,16], n3(:,1573), t3x16(:,:,1303))
  call heltable([8,2,16], n3(:,1574), t3x16(:,:,1304))
  call heltable([8,2,16], n3(:,1575), t3x16(:,:,1305))
  call heltable([8,2,16], n3(:,1576), t3x16(:,:,1306))
  call heltable([2,8,16], n3(:,1577), t3x16(:,:,1307))
  call heltable([2,8,16], n3(:,1578), t3x16(:,:,1308))
  call heltable([2,8,16], n3(:,1579), t3x16(:,:,1309))
  call heltable([2,8,16], n3(:,1580), t3x16(:,:,1310))
  call heltable([8,2,16], n3(:,1581), t3x16(:,:,1311))
  call heltable([8,2,16], n3(:,1582), t3x16(:,:,1312))
  call heltable([8,2,16], n3(:,1583), t3x16(:,:,1313))
  call heltable([8,2,16], n3(:,1584), t3x16(:,:,1314))
  call heltable([2,8,16], n3(:,1585), t3x16(:,:,1315))
  call heltable([2,8,16], n3(:,1586), t3x16(:,:,1316))
  call heltable([2,8,16], n3(:,1587), t3x16(:,:,1317))
  call heltable([2,8,16], n3(:,1588), t3x16(:,:,1318))
  call heltable([8,2,16], n3(:,1589), t3x16(:,:,1319))
  call heltable([8,2,16], n3(:,1590), t3x16(:,:,1320))
  call heltable([8,2,16], n3(:,1591), t3x16(:,:,1321))
  call heltable([8,2,16], n3(:,1592), t3x16(:,:,1322))
  call heltable([2,8,16], n3(:,1593), t3x16(:,:,1323))
  call heltable([2,8,16], n3(:,1594), t3x16(:,:,1324))
  call heltable([2,8,16], n3(:,1595), t3x16(:,:,1325))
  call heltable([2,8,16], n3(:,1596), t3x16(:,:,1326))
  call heltable([8,2,16], n3(:,1597), t3x16(:,:,1327))
  call heltable([8,2,16], n3(:,1598), t3x16(:,:,1328))
  call heltable([8,2,16], n3(:,1599), t3x16(:,:,1329))
  call heltable([8,2,16], n3(:,1600), t3x16(:,:,1330))
  call heltable([2,8,16], n3(:,1601), t3x16(:,:,1331))
  call heltable([2,8,16], n3(:,1602), t3x16(:,:,1332))
  call heltable([2,8,16], n3(:,1603), t3x16(:,:,1333))
  call heltable([2,8,16], n3(:,1604), t3x16(:,:,1334))
  call heltable([8,2,16], n3(:,1605), t3x16(:,:,1335))
  call heltable([8,2,16], n3(:,1606), t3x16(:,:,1336))
  call heltable([8,2,16], n3(:,1607), t3x16(:,:,1337))
  call heltable([8,2,16], n3(:,1608), t3x16(:,:,1338))
  call heltable([2,8,16], n3(:,1609), t3x16(:,:,1339))
  call heltable([2,8,16], n3(:,1610), t3x16(:,:,1340))
  call heltable([2,8,16], n3(:,1611), t3x16(:,:,1341))
  call heltable([2,8,16], n3(:,1612), t3x16(:,:,1342))
  call heltable([8,2,16], n3(:,1613), t3x16(:,:,1343))
  call heltable([8,2,16], n3(:,1614), t3x16(:,:,1344))
  call heltable([8,2,16], n3(:,1615), t3x16(:,:,1345))
  call heltable([8,2,16], n3(:,1616), t3x16(:,:,1346))
  call heltable([2,8,16], n3(:,1617), t3x16(:,:,1347))
  call heltable([2,8,16], n3(:,1618), t3x16(:,:,1348))
  call heltable([2,8,16], n3(:,1619), t3x16(:,:,1349))
  call heltable([2,8,16], n3(:,1620), t3x16(:,:,1350))
  call heltable([8,2,16], n3(:,1621), t3x16(:,:,1351))
  call heltable([8,2,16], n3(:,1622), t3x16(:,:,1352))
  call heltable([8,2,16], n3(:,1623), t3x16(:,:,1353))
  call heltable([8,2,16], n3(:,1624), t3x16(:,:,1354))
  call heltable([8,2,16], n3(:,1625), t3x16(:,:,1355))
  call heltable([8,2,16], n3(:,1626), t3x16(:,:,1356))
  call heltable([2,8,16], n3(:,1627), t3x16(:,:,1357))
  call heltable([2,8,16], n3(:,1628), t3x16(:,:,1358))
  call heltable([2,8,16], n3(:,1629), t3x16(:,:,1359))
  call heltable([2,8,16], n3(:,1630), t3x16(:,:,1360))
  call heltable([8,2,16], n3(:,1631), t3x16(:,:,1361))
  call heltable([8,2,16], n3(:,1632), t3x16(:,:,1362))
  call heltable([2,8,16], n3(:,1633), t3x16(:,:,1363))
  call heltable([2,8,16], n3(:,1634), t3x16(:,:,1364))
  call heltable([8,2,16], n3(:,1635), t3x16(:,:,1365))
  call heltable([8,2,16], n3(:,1636), t3x16(:,:,1366))
  call heltable([8,2,16], n3(:,1637), t3x16(:,:,1367))
  call heltable([8,2,16], n3(:,1638), t3x16(:,:,1368))
  call heltable([2,8,16], n3(:,1639), t3x16(:,:,1369))
  call heltable([2,8,16], n3(:,1640), t3x16(:,:,1370))
  call heltable([4,2,8], n3(:,1641), t3x8(:,:,238))
  n2(198) = 16
  call heltable([4,2,8], n3(:,1642), t3x8(:,:,239))
  n2(199) = 16
  call heltable([2,4,8], n3(:,1643), t3x8(:,:,240))
  call heltable([2,4,8], n3(:,1644), t3x8(:,:,241))
  n2(200) = 16
  n2(201) = 16
  call heltable([2,4,8], n3(:,1645), t3x8(:,:,242))
  call heltable([2,4,8], n3(:,1646), t3x8(:,:,243))
  call heltable([4,2,8], n3(:,1647), t3x8(:,:,244))
  call heltable([4,2,8], n3(:,1648), t3x8(:,:,245))
  call heltable([4,2,8], n3(:,1649), t3x8(:,:,246))
  call heltable([2,4,8], n3(:,1650), t3x8(:,:,247))
  call heltable([2,4,8], n3(:,1651), t3x8(:,:,248))
  n2(202) = 8
  n2(203) = 8
  n2(204) = 8
  n2(205) = 8
  n2(206) = 8
  n2(207) = 8
  n2(208) = 8
  n2(209) = 8
  call heltable([2,2,4], n3(:,1652), t3x4(:,:,34))
  n2(210) = 4
  call heltable([4,4,16], n3(:,1653), t3x16(:,:,1371))
  call heltable([4,4,16], n3(:,1654), t3x16(:,:,1372))
  call heltable([4,4,16], n3(:,1655), t3x16(:,:,1373))
  call heltable([4,4,16], n3(:,1656), t3x16(:,:,1374))
  call heltable([4,4,16], n3(:,1657), t3x16(:,:,1375))
  call heltable([4,4,16], n3(:,1658), t3x16(:,:,1376))
  call heltable([4,4,16], n3(:,1659), t3x16(:,:,1377))
  call heltable([4,4,16], n3(:,1660), t3x16(:,:,1378))
  call heltable([4,2,8], n3(:,1661), t3x8(:,:,249))
  call heltable([4,2,8], n3(:,1662), t3x8(:,:,250))
  call heltable([2,4,8], n3(:,1663), t3x8(:,:,251))
  call heltable([8,2,16], n3(:,1664), t3x16(:,:,1379))
  call heltable([8,2,16], n3(:,1665), t3x16(:,:,1380))
  call heltable([4,2,8], n3(:,1666), t3x8(:,:,252))
  call heltable([2,8,16], n3(:,1667), t3x16(:,:,1381))
  call heltable([2,8,16], n3(:,1668), t3x16(:,:,1382))
  call heltable([2,8,16], n3(:,1669), t3x16(:,:,1383))
  call heltable([2,8,16], n3(:,1670), t3x16(:,:,1384))
  call heltable([8,2,16], n3(:,1671), t3x16(:,:,1385))
  call heltable([8,2,16], n3(:,1672), t3x16(:,:,1386))
  call heltable([2,8,16], n3(:,1673), t3x16(:,:,1387))
  call heltable([2,8,16], n3(:,1674), t3x16(:,:,1388))
  call heltable([2,8,16], n3(:,1675), t3x16(:,:,1389))
  call heltable([2,8,16], n3(:,1676), t3x16(:,:,1390))
  call heltable([8,2,16], n3(:,1677), t3x16(:,:,1391))
  call heltable([8,2,16], n3(:,1678), t3x16(:,:,1392))
  call heltable([8,2,16], n3(:,1679), t3x16(:,:,1393))
  call heltable([8,2,16], n3(:,1680), t3x16(:,:,1394))
  call heltable([2,8,16], n3(:,1681), t3x16(:,:,1395))
  call heltable([2,8,16], n3(:,1682), t3x16(:,:,1396))
  call heltable([2,8,16], n3(:,1683), t3x16(:,:,1397))
  call heltable([2,8,16], n3(:,1684), t3x16(:,:,1398))
  call heltable([8,2,16], n3(:,1685), t3x16(:,:,1399))
  call heltable([8,2,16], n3(:,1686), t3x16(:,:,1400))
  call heltable([8,2,16], n3(:,1687), t3x16(:,:,1401))
  call heltable([8,2,16], n3(:,1688), t3x16(:,:,1402))
  call heltable([8,2,16], n3(:,1689), t3x16(:,:,1403))
  call heltable([8,2,16], n3(:,1690), t3x16(:,:,1404))
  call heltable([8,2,16], n3(:,1691), t3x16(:,:,1405))
  call heltable([8,2,16], n3(:,1692), t3x16(:,:,1406))
  call heltable([2,8,16], n3(:,1693), t3x16(:,:,1407))
  call heltable([2,8,16], n3(:,1694), t3x16(:,:,1408))
  call heltable([2,8,16], n3(:,1695), t3x16(:,:,1409))
  call heltable([2,8,16], n3(:,1696), t3x16(:,:,1410))
  call heltable([8,2,16], n3(:,1697), t3x16(:,:,1411))
  call heltable([8,2,16], n3(:,1698), t3x16(:,:,1412))
  call heltable([8,2,16], n3(:,1699), t3x16(:,:,1413))
  call heltable([8,2,16], n3(:,1700), t3x16(:,:,1414))
  call heltable([2,8,16], n3(:,1701), t3x16(:,:,1415))
  call heltable([2,8,16], n3(:,1702), t3x16(:,:,1416))
  call heltable([2,8,16], n3(:,1703), t3x16(:,:,1417))
  call heltable([2,8,16], n3(:,1704), t3x16(:,:,1418))
  call heltable([8,2,16], n3(:,1705), t3x16(:,:,1419))
  call heltable([8,2,16], n3(:,1706), t3x16(:,:,1420))
  call heltable([2,4,8], n3(:,1707), t3x8(:,:,253))
  call heltable([2,8,16], n3(:,1708), t3x16(:,:,1421))
  call heltable([2,8,16], n3(:,1709), t3x16(:,:,1422))
  call heltable([2,8,16], n3(:,1710), t3x16(:,:,1423))
  call heltable([2,8,16], n3(:,1711), t3x16(:,:,1424))
  call heltable([8,2,16], n3(:,1712), t3x16(:,:,1425))
  call heltable([8,2,16], n3(:,1713), t3x16(:,:,1426))
  n2(211) = 16
  n2(212) = 16
  n2(213) = 16
  n2(214) = 16
  call heltable([4,2,8], n3(:,1714), t3x8(:,:,254))
  call heltable([4,2,8], n3(:,1715), t3x8(:,:,255))
  call heltable([2,4,8], n3(:,1716), t3x8(:,:,256))
  call heltable([2,4,8], n3(:,1717), t3x8(:,:,257))
  call heltable([2,4,8], n3(:,1718), t3x8(:,:,258))
  call heltable([2,4,8], n3(:,1719), t3x8(:,:,259))
  call heltable([4,2,8], n3(:,1720), t3x8(:,:,260))
  n2(215) = 8
  n2(216) = 8
  n2(217) = 8
  n2(218) = 8
  call heltable([4,4,16], n3(:,1721), t3x16(:,:,1427))
  call heltable([4,4,16], n3(:,1722), t3x16(:,:,1428))
  call heltable([4,4,16], n3(:,1723), t3x16(:,:,1429))
  call heltable([4,4,16], n3(:,1724), t3x16(:,:,1430))
  call heltable([4,2,8], n3(:,1725), t3x8(:,:,261))
  call heltable([4,2,8], n3(:,1726), t3x8(:,:,262))
  call heltable([2,4,8], n3(:,1727), t3x8(:,:,263))
  call heltable([8,2,16], n3(:,1728), t3x16(:,:,1431))
  call heltable([8,2,16], n3(:,1729), t3x16(:,:,1432))
  call heltable([4,2,8], n3(:,1730), t3x8(:,:,264))
  call heltable([2,8,16], n3(:,1731), t3x16(:,:,1433))
  call heltable([2,8,16], n3(:,1732), t3x16(:,:,1434))
  call heltable([2,8,16], n3(:,1733), t3x16(:,:,1435))
  call heltable([2,8,16], n3(:,1734), t3x16(:,:,1436))
  call heltable([8,2,16], n3(:,1735), t3x16(:,:,1437))
  call heltable([8,2,16], n3(:,1736), t3x16(:,:,1438))
  call heltable([2,8,16], n3(:,1737), t3x16(:,:,1439))
  call heltable([2,8,16], n3(:,1738), t3x16(:,:,1440))
  call heltable([2,8,16], n3(:,1739), t3x16(:,:,1441))
  call heltable([2,8,16], n3(:,1740), t3x16(:,:,1442))
  call heltable([8,2,16], n3(:,1741), t3x16(:,:,1443))
  call heltable([8,2,16], n3(:,1742), t3x16(:,:,1444))
  call heltable([8,2,16], n3(:,1743), t3x16(:,:,1445))
  call heltable([8,2,16], n3(:,1744), t3x16(:,:,1446))
  call heltable([2,8,16], n3(:,1745), t3x16(:,:,1447))
  call heltable([2,8,16], n3(:,1746), t3x16(:,:,1448))
  call heltable([2,8,16], n3(:,1747), t3x16(:,:,1449))
  call heltable([2,8,16], n3(:,1748), t3x16(:,:,1450))
  call heltable([8,2,16], n3(:,1749), t3x16(:,:,1451))
  call heltable([8,2,16], n3(:,1750), t3x16(:,:,1452))
  call heltable([8,2,16], n3(:,1751), t3x16(:,:,1453))
  call heltable([8,2,16], n3(:,1752), t3x16(:,:,1454))
  call heltable([8,2,16], n3(:,1753), t3x16(:,:,1455))
  call heltable([8,2,16], n3(:,1754), t3x16(:,:,1456))
  call heltable([8,2,16], n3(:,1755), t3x16(:,:,1457))
  call heltable([8,2,16], n3(:,1756), t3x16(:,:,1458))
  call heltable([8,2,16], n3(:,1757), t3x16(:,:,1459))
  call heltable([8,2,16], n3(:,1758), t3x16(:,:,1460))
  call heltable([8,2,16], n3(:,1759), t3x16(:,:,1461))
  call heltable([8,2,16], n3(:,1760), t3x16(:,:,1462))
  call heltable([2,8,16], n3(:,1761), t3x16(:,:,1463))
  call heltable([2,8,16], n3(:,1762), t3x16(:,:,1464))
  call heltable([2,8,16], n3(:,1763), t3x16(:,:,1465))
  call heltable([2,8,16], n3(:,1764), t3x16(:,:,1466))
  call heltable([2,8,16], n3(:,1765), t3x16(:,:,1467))
  call heltable([2,8,16], n3(:,1766), t3x16(:,:,1468))
  call heltable([2,8,16], n3(:,1767), t3x16(:,:,1469))
  call heltable([2,8,16], n3(:,1768), t3x16(:,:,1470))
  call heltable([2,8,16], n3(:,1769), t3x16(:,:,1471))
  call heltable([2,8,16], n3(:,1770), t3x16(:,:,1472))
  call heltable([2,4,8], n3(:,1771), t3x8(:,:,265))
  call heltable([8,2,16], n3(:,1772), t3x16(:,:,1473))
  call heltable([8,2,16], n3(:,1773), t3x16(:,:,1474))
  call heltable([8,2,16], n3(:,1774), t3x16(:,:,1475))
  call heltable([8,2,16], n3(:,1775), t3x16(:,:,1476))
  call heltable([2,8,16], n3(:,1776), t3x16(:,:,1477))
  call heltable([2,8,16], n3(:,1777), t3x16(:,:,1478))
  call heltable([8,2,16], n3(:,1778), t3x16(:,:,1479))
  call heltable([8,2,16], n3(:,1779), t3x16(:,:,1480))
  call heltable([8,2,16], n3(:,1780), t3x16(:,:,1481))
  call heltable([8,2,16], n3(:,1781), t3x16(:,:,1482))
  call heltable([8,2,16], n3(:,1782), t3x16(:,:,1483))
  call heltable([8,2,16], n3(:,1783), t3x16(:,:,1484))
  call heltable([8,2,16], n3(:,1784), t3x16(:,:,1485))
  call heltable([8,2,16], n3(:,1785), t3x16(:,:,1486))
  call heltable([2,8,16], n3(:,1786), t3x16(:,:,1487))
  call heltable([2,8,16], n3(:,1787), t3x16(:,:,1488))
  call heltable([2,8,16], n3(:,1788), t3x16(:,:,1489))
  call heltable([2,8,16], n3(:,1789), t3x16(:,:,1490))
  call heltable([2,8,16], n3(:,1790), t3x16(:,:,1491))
  call heltable([2,8,16], n3(:,1791), t3x16(:,:,1492))
  call heltable([2,8,16], n3(:,1792), t3x16(:,:,1493))
  call heltable([2,8,16], n3(:,1793), t3x16(:,:,1494))
  call heltable([2,8,16], n3(:,1794), t3x16(:,:,1495))
  call heltable([2,8,16], n3(:,1795), t3x16(:,:,1496))
  call heltable([2,8,16], n3(:,1796), t3x16(:,:,1497))
  call heltable([2,8,16], n3(:,1797), t3x16(:,:,1498))
  call heltable([8,2,16], n3(:,1798), t3x16(:,:,1499))
  call heltable([8,2,16], n3(:,1799), t3x16(:,:,1500))
  call heltable([8,2,16], n3(:,1800), t3x16(:,:,1501))
  call heltable([8,2,16], n3(:,1801), t3x16(:,:,1502))
  call heltable([2,8,16], n3(:,1802), t3x16(:,:,1503))
  call heltable([2,8,16], n3(:,1803), t3x16(:,:,1504))
  call heltable([2,8,16], n3(:,1804), t3x16(:,:,1505))
  call heltable([2,8,16], n3(:,1805), t3x16(:,:,1506))
  call heltable([8,2,16], n3(:,1806), t3x16(:,:,1507))
  call heltable([8,2,16], n3(:,1807), t3x16(:,:,1508))
  call heltable([8,2,16], n3(:,1808), t3x16(:,:,1509))
  call heltable([8,2,16], n3(:,1809), t3x16(:,:,1510))
  call heltable([2,8,16], n3(:,1810), t3x16(:,:,1511))
  call heltable([2,8,16], n3(:,1811), t3x16(:,:,1512))
  call heltable([8,2,16], n3(:,1812), t3x16(:,:,1513))
  call heltable([8,2,16], n3(:,1813), t3x16(:,:,1514))
  call heltable([8,2,16], n3(:,1814), t3x16(:,:,1515))
  call heltable([8,2,16], n3(:,1815), t3x16(:,:,1516))
  call heltable([8,2,16], n3(:,1816), t3x16(:,:,1517))
  call heltable([8,2,16], n3(:,1817), t3x16(:,:,1518))
  call heltable([8,2,16], n3(:,1818), t3x16(:,:,1519))
  call heltable([8,2,16], n3(:,1819), t3x16(:,:,1520))
  call heltable([8,2,16], n3(:,1820), t3x16(:,:,1521))
  call heltable([8,2,16], n3(:,1821), t3x16(:,:,1522))
  call heltable([2,8,16], n3(:,1822), t3x16(:,:,1523))
  call heltable([2,8,16], n3(:,1823), t3x16(:,:,1524))
  call heltable([2,8,16], n3(:,1824), t3x16(:,:,1525))
  call heltable([2,8,16], n3(:,1825), t3x16(:,:,1526))
  call heltable([2,8,16], n3(:,1826), t3x16(:,:,1527))
  call heltable([2,8,16], n3(:,1827), t3x16(:,:,1528))
  call heltable([2,8,16], n3(:,1828), t3x16(:,:,1529))
  call heltable([2,8,16], n3(:,1829), t3x16(:,:,1530))
  call heltable([2,8,16], n3(:,1830), t3x16(:,:,1531))
  call heltable([2,8,16], n3(:,1831), t3x16(:,:,1532))
  call heltable([8,2,16], n3(:,1832), t3x16(:,:,1533))
  call heltable([8,2,16], n3(:,1833), t3x16(:,:,1534))
  call heltable([2,8,16], n3(:,1834), t3x16(:,:,1535))
  call heltable([2,8,16], n3(:,1835), t3x16(:,:,1536))
  call heltable([2,8,16], n3(:,1836), t3x16(:,:,1537))
  call heltable([2,8,16], n3(:,1837), t3x16(:,:,1538))
  call heltable([8,2,16], n3(:,1838), t3x16(:,:,1539))
  call heltable([8,2,16], n3(:,1839), t3x16(:,:,1540))
  call heltable([8,2,16], n3(:,1840), t3x16(:,:,1541))
  call heltable([8,2,16], n3(:,1841), t3x16(:,:,1542))
  call heltable([2,8,16], n3(:,1842), t3x16(:,:,1543))
  call heltable([2,8,16], n3(:,1843), t3x16(:,:,1544))
  call heltable([2,8,16], n3(:,1844), t3x16(:,:,1545))
  call heltable([2,8,16], n3(:,1845), t3x16(:,:,1546))
  call heltable([8,2,16], n3(:,1846), t3x16(:,:,1547))
  call heltable([8,2,16], n3(:,1847), t3x16(:,:,1548))
  call heltable([8,2,16], n3(:,1848), t3x16(:,:,1549))
  call heltable([8,2,16], n3(:,1849), t3x16(:,:,1550))
  call heltable([8,2,16], n3(:,1850), t3x16(:,:,1551))
  call heltable([8,2,16], n3(:,1851), t3x16(:,:,1552))
  call heltable([2,8,16], n3(:,1852), t3x16(:,:,1553))
  call heltable([2,8,16], n3(:,1853), t3x16(:,:,1554))
  call heltable([2,8,16], n3(:,1854), t3x16(:,:,1555))
  call heltable([2,8,16], n3(:,1855), t3x16(:,:,1556))
  call heltable([8,2,16], n3(:,1856), t3x16(:,:,1557))
  call heltable([8,2,16], n3(:,1857), t3x16(:,:,1558))
  call heltable([2,8,16], n3(:,1858), t3x16(:,:,1559))
  call heltable([2,8,16], n3(:,1859), t3x16(:,:,1560))
  call heltable([8,2,16], n3(:,1860), t3x16(:,:,1561))
  call heltable([8,2,16], n3(:,1861), t3x16(:,:,1562))
  call heltable([8,2,16], n3(:,1862), t3x16(:,:,1563))
  call heltable([8,2,16], n3(:,1863), t3x16(:,:,1564))
  call heltable([2,8,16], n3(:,1864), t3x16(:,:,1565))
  call heltable([2,8,16], n3(:,1865), t3x16(:,:,1566))
  call heltable([4,2,8], n3(:,1866), t3x8(:,:,266))
  call heltable([4,2,8], n3(:,1867), t3x8(:,:,267))
  call heltable([2,4,8], n3(:,1868), t3x8(:,:,268))
  call heltable([2,4,8], n3(:,1869), t3x8(:,:,269))
  n2(219) = 16
  call heltable([2,4,8], n3(:,1870), t3x8(:,:,270))
  n2(220) = 16
  call heltable([4,2,8], n3(:,1871), t3x8(:,:,271))
  call heltable([4,2,8], n3(:,1872), t3x8(:,:,272))
  n2(221) = 16
  n2(222) = 16
  call heltable([2,4,8], n3(:,1873), t3x8(:,:,273))
  n2(223) = 16
  n2(224) = 16
  call heltable([2,4,8], n3(:,1874), t3x8(:,:,274))
  n2(225) = 16
  n2(226) = 16
  call heltable([4,2,8], n3(:,1875), t3x8(:,:,275))
  call heltable([4,2,8], n3(:,1876), t3x8(:,:,276))
  n2(227) = 8
  call heltable([2,8,16], n3(:,1877), t3x16(:,:,1567))
  n2(228) = 8
  call heltable([2,8,16], n3(:,1878), t3x16(:,:,1568))
  n2(229) = 8
  call heltable([2,8,16], n3(:,1879), t3x16(:,:,1569))
  n2(230) = 8
  call heltable([2,8,16], n3(:,1880), t3x16(:,:,1570))
  n2(231) = 8
  call heltable([2,8,16], n3(:,1881), t3x16(:,:,1571))
  n2(232) = 8
  call heltable([2,8,16], n3(:,1882), t3x16(:,:,1572))
  n2(233) = 8
  call heltable([2,8,16], n3(:,1883), t3x16(:,:,1573))
  n2(234) = 8
  call heltable([2,8,16], n3(:,1884), t3x16(:,:,1574))
  call heltable([2,2,4], n3(:,1885), t3x4(:,:,35))
  n2(235) = 4
  call heltable([4,4,16], n3(:,1886), t3x16(:,:,1575))
  call heltable([4,4,16], n3(:,1887), t3x16(:,:,1576))
  call heltable([4,4,16], n3(:,1888), t3x16(:,:,1577))
  call heltable([4,4,16], n3(:,1889), t3x16(:,:,1578))
  call heltable([2,4,8], n3(:,1890), t3x8(:,:,277))
  call heltable([2,4,8], n3(:,1891), t3x8(:,:,278))
  call heltable([4,2,8], n3(:,1892), t3x8(:,:,279))
  call heltable([4,4,16], n3(:,1893), t3x16(:,:,1579))
  call heltable([4,4,16], n3(:,1894), t3x16(:,:,1580))
  call heltable([4,4,16], n3(:,1895), t3x16(:,:,1581))
  call heltable([4,4,16], n3(:,1896), t3x16(:,:,1582))
  call heltable([8,2,16], n3(:,1897), t3x16(:,:,1583))
  call heltable([8,2,16], n3(:,1898), t3x16(:,:,1584))
  call heltable([2,4,8], n3(:,1899), t3x8(:,:,280))
  call heltable([2,8,16], n3(:,1900), t3x16(:,:,1585))
  call heltable([2,8,16], n3(:,1901), t3x16(:,:,1586))
  call heltable([2,8,16], n3(:,1902), t3x16(:,:,1587))
  call heltable([2,8,16], n3(:,1903), t3x16(:,:,1588))
  call heltable([8,2,16], n3(:,1904), t3x16(:,:,1589))
  call heltable([8,2,16], n3(:,1905), t3x16(:,:,1590))
  call heltable([8,2,16], n3(:,1906), t3x16(:,:,1591))
  call heltable([8,2,16], n3(:,1907), t3x16(:,:,1592))
  call heltable([8,2,16], n3(:,1908), t3x16(:,:,1593))
  call heltable([8,2,16], n3(:,1909), t3x16(:,:,1594))
  call heltable([2,8,16], n3(:,1910), t3x16(:,:,1595))
  call heltable([2,8,16], n3(:,1911), t3x16(:,:,1596))
  call heltable([2,8,16], n3(:,1912), t3x16(:,:,1597))
  call heltable([2,8,16], n3(:,1913), t3x16(:,:,1598))
  call heltable([8,2,16], n3(:,1914), t3x16(:,:,1599))
  call heltable([8,2,16], n3(:,1915), t3x16(:,:,1600))
  call heltable([8,2,16], n3(:,1916), t3x16(:,:,1601))
  call heltable([8,2,16], n3(:,1917), t3x16(:,:,1602))
  call heltable([2,8,16], n3(:,1918), t3x16(:,:,1603))
  call heltable([2,8,16], n3(:,1919), t3x16(:,:,1604))
  call heltable([2,8,16], n3(:,1920), t3x16(:,:,1605))
  call heltable([2,8,16], n3(:,1921), t3x16(:,:,1606))
  call heltable([2,8,16], n3(:,1922), t3x16(:,:,1607))
  call heltable([2,8,16], n3(:,1923), t3x16(:,:,1608))
  call heltable([2,8,16], n3(:,1924), t3x16(:,:,1609))
  call heltable([2,8,16], n3(:,1925), t3x16(:,:,1610))
  call heltable([8,2,16], n3(:,1926), t3x16(:,:,1611))
  call heltable([8,2,16], n3(:,1927), t3x16(:,:,1612))
  call heltable([8,2,16], n3(:,1928), t3x16(:,:,1613))
  call heltable([8,2,16], n3(:,1929), t3x16(:,:,1614))
  call heltable([2,8,16], n3(:,1930), t3x16(:,:,1615))
  call heltable([2,8,16], n3(:,1931), t3x16(:,:,1616))
  call heltable([2,8,16], n3(:,1932), t3x16(:,:,1617))
  call heltable([2,8,16], n3(:,1933), t3x16(:,:,1618))
  call heltable([8,2,16], n3(:,1934), t3x16(:,:,1619))
  call heltable([8,2,16], n3(:,1935), t3x16(:,:,1620))
  call heltable([8,2,16], n3(:,1936), t3x16(:,:,1621))
  call heltable([8,2,16], n3(:,1937), t3x16(:,:,1622))
  call heltable([8,2,16], n3(:,1938), t3x16(:,:,1623))
  call heltable([8,2,16], n3(:,1939), t3x16(:,:,1624))
  call heltable([4,2,8], n3(:,1940), t3x8(:,:,281))
  call heltable([2,8,16], n3(:,1941), t3x16(:,:,1625))
  call heltable([2,8,16], n3(:,1942), t3x16(:,:,1626))
  call heltable([2,8,16], n3(:,1943), t3x16(:,:,1627))
  call heltable([2,8,16], n3(:,1944), t3x16(:,:,1628))
  call heltable([8,2,16], n3(:,1945), t3x16(:,:,1629))
  call heltable([8,2,16], n3(:,1946), t3x16(:,:,1630))
  call heltable([2,2,4], n3(:,1947), t3x4(:,:,36))
  call heltable([4,4,16], n3(:,1948), t3x16(:,:,1631))
  call heltable([2,2,4], n3(:,1949), t3x4(:,:,37))
  call heltable([4,4,16], n3(:,1950), t3x16(:,:,1632))
  call heltable([2,2,4], n3(:,1951), t3x4(:,:,38))
  call heltable([4,4,16], n3(:,1952), t3x16(:,:,1633))
  call heltable([2,2,4], n3(:,1953), t3x4(:,:,39))
  call heltable([4,4,16], n3(:,1954), t3x16(:,:,1634))
  call heltable([4,2,8], n3(:,1955), t3x8(:,:,282))
  n2(236) = 8
  call heltable([4,2,8], n3(:,1956), t3x8(:,:,283))
  n2(237) = 8
  call heltable([2,4,8], n3(:,1957), t3x8(:,:,284))
  n2(238) = 8
  call heltable([2,4,8], n3(:,1958), t3x8(:,:,285))
  n2(239) = 8
  call heltable([4,4,16], n3(:,1959), t3x16(:,:,1635))
  call heltable([4,4,16], n3(:,1960), t3x16(:,:,1636))
  call heltable([4,4,16], n3(:,1961), t3x16(:,:,1637))
  call heltable([4,4,16], n3(:,1962), t3x16(:,:,1638))
  call heltable([4,4,16], n3(:,1963), t3x16(:,:,1639))
  call heltable([4,4,16], n3(:,1964), t3x16(:,:,1640))
  call heltable([4,4,16], n3(:,1965), t3x16(:,:,1641))
  call heltable([4,4,16], n3(:,1966), t3x16(:,:,1642))
  call heltable([4,4,16], n3(:,1967), t3x16(:,:,1643))
  call heltable([4,4,16], n3(:,1968), t3x16(:,:,1644))
  call heltable([4,4,16], n3(:,1969), t3x16(:,:,1645))
  call heltable([4,4,16], n3(:,1970), t3x16(:,:,1646))
  call heltable([4,4,16], n3(:,1971), t3x16(:,:,1647))
  call heltable([4,4,16], n3(:,1972), t3x16(:,:,1648))
  call heltable([4,4,16], n3(:,1973), t3x16(:,:,1649))
  call heltable([4,4,16], n3(:,1974), t3x16(:,:,1650))
  call heltable([4,4,16], n3(:,1975), t3x16(:,:,1651))
  call heltable([2,4,8], n3(:,1976), t3x8(:,:,286))
  n2(240) = 8
  call heltable([2,4,8], n3(:,1977), t3x8(:,:,287))
  n2(241) = 8
  call heltable([4,2,8], n3(:,1978), t3x8(:,:,288))
  n2(242) = 8
  call heltable([4,2,8], n3(:,1979), t3x8(:,:,289))
  n2(243) = 8
  call heltable([2,8,16], n3(:,1980), t3x16(:,:,1652))
  call heltable([2,8,16], n3(:,1981), t3x16(:,:,1653))
  call heltable([2,8,16], n3(:,1982), t3x16(:,:,1654))
  call heltable([2,8,16], n3(:,1983), t3x16(:,:,1655))
  call heltable([4,2,8], n3(:,1984), t3x8(:,:,290))
  call heltable([4,2,8], n3(:,1985), t3x8(:,:,291))
  call heltable([2,4,8], n3(:,1986), t3x8(:,:,292))
  n2(244) = 16
  n2(245) = 16
  n2(246) = 16
  n2(247) = 16
  call heltable([2,4,8], n3(:,1987), t3x8(:,:,293))
  n2(248) = 16
  n2(249) = 16
  call heltable([2,4,8], n3(:,1988), t3x8(:,:,294))
  n2(250) = 16
  n2(251) = 16
  call heltable([4,2,8], n3(:,1989), t3x8(:,:,295))
  call heltable([4,2,8], n3(:,1990), t3x8(:,:,296))
  n2(252) = 8
  call heltable([2,8,16], n3(:,1991), t3x16(:,:,1656))
  n2(253) = 8
  call heltable([2,8,16], n3(:,1992), t3x16(:,:,1657))
  n2(254) = 8
  call heltable([2,8,16], n3(:,1993), t3x16(:,:,1658))
  n2(255) = 8
  call heltable([2,8,16], n3(:,1994), t3x16(:,:,1659))
  call heltable([2,4,8], n3(:,1995), t3x8(:,:,297))
  call heltable([2,4,8], n3(:,1996), t3x8(:,:,298))
  call heltable([4,2,8], n3(:,1997), t3x8(:,:,299))
  call heltable([4,4,16], n3(:,1998), t3x16(:,:,1660))
  call heltable([4,4,16], n3(:,1999), t3x16(:,:,1661))
  call heltable([4,4,16], n3(:,2000), t3x16(:,:,1662))
  call heltable([4,4,16], n3(:,2001), t3x16(:,:,1663))
  call heltable([8,2,16], n3(:,2002), t3x16(:,:,1664))
  call heltable([8,2,16], n3(:,2003), t3x16(:,:,1665))
  call heltable([2,4,8], n3(:,2004), t3x8(:,:,300))
  call heltable([2,8,16], n3(:,2005), t3x16(:,:,1666))
  call heltable([2,8,16], n3(:,2006), t3x16(:,:,1667))
  call heltable([2,8,16], n3(:,2007), t3x16(:,:,1668))
  call heltable([2,8,16], n3(:,2008), t3x16(:,:,1669))
  call heltable([8,2,16], n3(:,2009), t3x16(:,:,1670))
  call heltable([8,2,16], n3(:,2010), t3x16(:,:,1671))
  call heltable([8,2,16], n3(:,2011), t3x16(:,:,1672))
  call heltable([8,2,16], n3(:,2012), t3x16(:,:,1673))
  call heltable([8,2,16], n3(:,2013), t3x16(:,:,1674))
  call heltable([8,2,16], n3(:,2014), t3x16(:,:,1675))
  call heltable([2,8,16], n3(:,2015), t3x16(:,:,1676))
  call heltable([2,8,16], n3(:,2016), t3x16(:,:,1677))
  call heltable([2,8,16], n3(:,2017), t3x16(:,:,1678))
  call heltable([2,8,16], n3(:,2018), t3x16(:,:,1679))
  call heltable([8,2,16], n3(:,2019), t3x16(:,:,1680))
  call heltable([8,2,16], n3(:,2020), t3x16(:,:,1681))
  call heltable([8,2,16], n3(:,2021), t3x16(:,:,1682))
  call heltable([8,2,16], n3(:,2022), t3x16(:,:,1683))
  call heltable([2,8,16], n3(:,2023), t3x16(:,:,1684))
  call heltable([2,8,16], n3(:,2024), t3x16(:,:,1685))
  call heltable([2,8,16], n3(:,2025), t3x16(:,:,1686))
  call heltable([2,8,16], n3(:,2026), t3x16(:,:,1687))
  call heltable([2,8,16], n3(:,2027), t3x16(:,:,1688))
  call heltable([2,8,16], n3(:,2028), t3x16(:,:,1689))
  call heltable([2,8,16], n3(:,2029), t3x16(:,:,1690))
  call heltable([2,8,16], n3(:,2030), t3x16(:,:,1691))
  call heltable([8,2,16], n3(:,2031), t3x16(:,:,1692))
  call heltable([8,2,16], n3(:,2032), t3x16(:,:,1693))
  call heltable([8,2,16], n3(:,2033), t3x16(:,:,1694))
  call heltable([8,2,16], n3(:,2034), t3x16(:,:,1695))
  call heltable([2,8,16], n3(:,2035), t3x16(:,:,1696))
  call heltable([2,8,16], n3(:,2036), t3x16(:,:,1697))
  call heltable([2,8,16], n3(:,2037), t3x16(:,:,1698))
  call heltable([2,8,16], n3(:,2038), t3x16(:,:,1699))
  call heltable([8,2,16], n3(:,2039), t3x16(:,:,1700))
  call heltable([8,2,16], n3(:,2040), t3x16(:,:,1701))
  call heltable([8,2,16], n3(:,2041), t3x16(:,:,1702))
  call heltable([8,2,16], n3(:,2042), t3x16(:,:,1703))
  call heltable([8,2,16], n3(:,2043), t3x16(:,:,1704))
  call heltable([8,2,16], n3(:,2044), t3x16(:,:,1705))
  call heltable([4,2,8], n3(:,2045), t3x8(:,:,301))
  call heltable([2,8,16], n3(:,2046), t3x16(:,:,1706))
  call heltable([2,8,16], n3(:,2047), t3x16(:,:,1707))
  call heltable([2,8,16], n3(:,2048), t3x16(:,:,1708))
  call heltable([2,8,16], n3(:,2049), t3x16(:,:,1709))
  call heltable([8,2,16], n3(:,2050), t3x16(:,:,1710))
  call heltable([8,2,16], n3(:,2051), t3x16(:,:,1711))
  call heltable([2,8,16], n3(:,2052), t3x16(:,:,1712))
  call heltable([2,8,16], n3(:,2053), t3x16(:,:,1713))
  call heltable([8,2,16], n3(:,2054), t3x16(:,:,1714))
  call heltable([8,2,16], n3(:,2055), t3x16(:,:,1715))
  call heltable([2,8,16], n3(:,2056), t3x16(:,:,1716))
  call heltable([2,8,16], n3(:,2057), t3x16(:,:,1717))
  call heltable([2,8,16], n3(:,2058), t3x16(:,:,1718))
  call heltable([2,8,16], n3(:,2059), t3x16(:,:,1719))
  call heltable([8,2,16], n3(:,2060), t3x16(:,:,1720))
  call heltable([8,2,16], n3(:,2061), t3x16(:,:,1721))
  call heltable([8,2,16], n3(:,2062), t3x16(:,:,1722))
  call heltable([8,2,16], n3(:,2063), t3x16(:,:,1723))
  call heltable([2,8,16], n3(:,2064), t3x16(:,:,1724))
  call heltable([2,8,16], n3(:,2065), t3x16(:,:,1725))
  call heltable([2,8,16], n3(:,2066), t3x16(:,:,1726))
  call heltable([2,8,16], n3(:,2067), t3x16(:,:,1727))
  call heltable([8,2,16], n3(:,2068), t3x16(:,:,1728))
  call heltable([8,2,16], n3(:,2069), t3x16(:,:,1729))
  call heltable([8,2,16], n3(:,2070), t3x16(:,:,1730))
  call heltable([8,2,16], n3(:,2071), t3x16(:,:,1731))
  call heltable([8,2,16], n3(:,2072), t3x16(:,:,1732))
  call heltable([8,2,16], n3(:,2073), t3x16(:,:,1733))
  call heltable([8,2,16], n3(:,2074), t3x16(:,:,1734))
  call heltable([8,2,16], n3(:,2075), t3x16(:,:,1735))
  call heltable([8,2,16], n3(:,2076), t3x16(:,:,1736))
  call heltable([8,2,16], n3(:,2077), t3x16(:,:,1737))
  call heltable([8,2,16], n3(:,2078), t3x16(:,:,1738))
  call heltable([8,2,16], n3(:,2079), t3x16(:,:,1739))
  call heltable([2,8,16], n3(:,2080), t3x16(:,:,1740))
  call heltable([2,8,16], n3(:,2081), t3x16(:,:,1741))
  call heltable([2,8,16], n3(:,2082), t3x16(:,:,1742))
  call heltable([2,8,16], n3(:,2083), t3x16(:,:,1743))
  call heltable([2,8,16], n3(:,2084), t3x16(:,:,1744))
  call heltable([2,8,16], n3(:,2085), t3x16(:,:,1745))
  call heltable([2,8,16], n3(:,2086), t3x16(:,:,1746))
  call heltable([2,8,16], n3(:,2087), t3x16(:,:,1747))
  call heltable([2,8,16], n3(:,2088), t3x16(:,:,1748))
  call heltable([2,8,16], n3(:,2089), t3x16(:,:,1749))
  call heltable([2,8,16], n3(:,2090), t3x16(:,:,1750))
  call heltable([2,8,16], n3(:,2091), t3x16(:,:,1751))
  call heltable([8,2,16], n3(:,2092), t3x16(:,:,1752))
  call heltable([8,2,16], n3(:,2093), t3x16(:,:,1753))
  call heltable([8,2,16], n3(:,2094), t3x16(:,:,1754))
  call heltable([8,2,16], n3(:,2095), t3x16(:,:,1755))
  call heltable([2,8,16], n3(:,2096), t3x16(:,:,1756))
  call heltable([2,8,16], n3(:,2097), t3x16(:,:,1757))
  call heltable([2,8,16], n3(:,2098), t3x16(:,:,1758))
  call heltable([2,8,16], n3(:,2099), t3x16(:,:,1759))
  call heltable([8,2,16], n3(:,2100), t3x16(:,:,1760))
  call heltable([8,2,16], n3(:,2101), t3x16(:,:,1761))
  call heltable([8,2,16], n3(:,2102), t3x16(:,:,1762))
  call heltable([8,2,16], n3(:,2103), t3x16(:,:,1763))
  call heltable([2,8,16], n3(:,2104), t3x16(:,:,1764))
  call heltable([2,8,16], n3(:,2105), t3x16(:,:,1765))
  call heltable([8,2,16], n3(:,2106), t3x16(:,:,1766))
  call heltable([8,2,16], n3(:,2107), t3x16(:,:,1767))
  call heltable([2,8,16], n3(:,2108), t3x16(:,:,1768))
  call heltable([2,8,16], n3(:,2109), t3x16(:,:,1769))
  call heltable([8,2,16], n3(:,2110), t3x16(:,:,1770))
  call heltable([8,2,16], n3(:,2111), t3x16(:,:,1771))
  call heltable([2,8,16], n3(:,2112), t3x16(:,:,1772))
  call heltable([2,8,16], n3(:,2113), t3x16(:,:,1773))
  call heltable([8,2,16], n3(:,2114), t3x16(:,:,1774))
  call heltable([8,2,16], n3(:,2115), t3x16(:,:,1775))
  call heltable([2,8,16], n3(:,2116), t3x16(:,:,1776))
  call heltable([2,8,16], n3(:,2117), t3x16(:,:,1777))
  call heltable([8,2,16], n3(:,2118), t3x16(:,:,1778))
  call heltable([8,2,16], n3(:,2119), t3x16(:,:,1779))
  call heltable([2,8,16], n3(:,2120), t3x16(:,:,1780))
  call heltable([2,8,16], n3(:,2121), t3x16(:,:,1781))
  call heltable([8,2,16], n3(:,2122), t3x16(:,:,1782))
  call heltable([8,2,16], n3(:,2123), t3x16(:,:,1783))
  call heltable([4,4,16], n3(:,2124), t3x16(:,:,1784))
  call heltable([4,4,16], n3(:,2125), t3x16(:,:,1785))
  call heltable([4,4,16], n3(:,2126), t3x16(:,:,1786))
  call heltable([4,4,16], n3(:,2127), t3x16(:,:,1787))
  call heltable([4,4,16], n3(:,2128), t3x16(:,:,1788))
  call heltable([4,4,16], n3(:,2129), t3x16(:,:,1789))
  call heltable([4,4,16], n3(:,2130), t3x16(:,:,1790))
  call heltable([4,4,16], n3(:,2131), t3x16(:,:,1791))
  call heltable([4,4,16], n3(:,2132), t3x16(:,:,1792))
  call heltable([4,4,16], n3(:,2133), t3x16(:,:,1793))
  call heltable([4,4,16], n3(:,2134), t3x16(:,:,1794))
  call heltable([4,4,16], n3(:,2135), t3x16(:,:,1795))
  call heltable([4,4,16], n3(:,2136), t3x16(:,:,1796))
  call heltable([4,2,8], n3(:,2137), t3x8(:,:,302))
  n2(256) = 8
  call heltable([4,2,8], n3(:,2138), t3x8(:,:,303))
  n2(257) = 8
  call heltable([2,4,8], n3(:,2139), t3x8(:,:,304))
  n2(258) = 8
  call heltable([2,4,8], n3(:,2140), t3x8(:,:,305))
  n2(259) = 8
  call heltable([4,4,16], n3(:,2141), t3x16(:,:,1797))
  call heltable([4,4,16], n3(:,2142), t3x16(:,:,1798))
  call heltable([4,4,16], n3(:,2143), t3x16(:,:,1799))
  call heltable([4,4,16], n3(:,2144), t3x16(:,:,1800))
  call heltable([4,4,16], n3(:,2145), t3x16(:,:,1801))
  call heltable([4,4,16], n3(:,2146), t3x16(:,:,1802))
  call heltable([4,4,16], n3(:,2147), t3x16(:,:,1803))
  call heltable([4,4,16], n3(:,2148), t3x16(:,:,1804))
  call heltable([2,4,8], n3(:,2149), t3x8(:,:,306))
  n2(260) = 8
  call heltable([2,4,8], n3(:,2150), t3x8(:,:,307))
  n2(261) = 8
  call heltable([4,2,8], n3(:,2151), t3x8(:,:,308))
  n2(262) = 8
  call heltable([4,2,8], n3(:,2152), t3x8(:,:,309))
  n2(263) = 8
  call heltable([2,8,16], n3(:,2153), t3x16(:,:,1805))
  call heltable([2,8,16], n3(:,2154), t3x16(:,:,1806))
  call heltable([2,8,16], n3(:,2155), t3x16(:,:,1807))
  call heltable([2,8,16], n3(:,2156), t3x16(:,:,1808))
  call heltable([8,2,16], n3(:,2157), t3x16(:,:,1809))
  call heltable([8,2,16], n3(:,2158), t3x16(:,:,1810))
  call heltable([8,2,16], n3(:,2159), t3x16(:,:,1811))
  call heltable([8,2,16], n3(:,2160), t3x16(:,:,1812))
  call heltable([8,2,16], n3(:,2161), t3x16(:,:,1813))
  call heltable([8,2,16], n3(:,2162), t3x16(:,:,1814))
  call heltable([8,2,16], n3(:,2163), t3x16(:,:,1815))
  call heltable([8,2,16], n3(:,2164), t3x16(:,:,1816))
  call heltable([2,8,16], n3(:,2165), t3x16(:,:,1817))
  call heltable([2,8,16], n3(:,2166), t3x16(:,:,1818))
  call heltable([2,8,16], n3(:,2167), t3x16(:,:,1819))
  call heltable([2,8,16], n3(:,2168), t3x16(:,:,1820))
  call heltable([2,8,16], n3(:,2169), t3x16(:,:,1821))
  call heltable([2,8,16], n3(:,2170), t3x16(:,:,1822))
  call heltable([2,8,16], n3(:,2171), t3x16(:,:,1823))
  call heltable([2,8,16], n3(:,2172), t3x16(:,:,1824))
  call heltable([2,8,16], n3(:,2173), t3x16(:,:,1825))
  call heltable([2,8,16], n3(:,2174), t3x16(:,:,1826))
  call heltable([2,8,16], n3(:,2175), t3x16(:,:,1827))
  call heltable([2,8,16], n3(:,2176), t3x16(:,:,1828))
  call heltable([8,2,16], n3(:,2177), t3x16(:,:,1829))
  call heltable([8,2,16], n3(:,2178), t3x16(:,:,1830))
  call heltable([8,2,16], n3(:,2179), t3x16(:,:,1831))
  call heltable([8,2,16], n3(:,2180), t3x16(:,:,1832))
  call heltable([2,8,16], n3(:,2181), t3x16(:,:,1833))
  call heltable([2,8,16], n3(:,2182), t3x16(:,:,1834))
  call heltable([2,8,16], n3(:,2183), t3x16(:,:,1835))
  call heltable([2,8,16], n3(:,2184), t3x16(:,:,1836))
  call heltable([8,2,16], n3(:,2185), t3x16(:,:,1837))
  call heltable([8,2,16], n3(:,2186), t3x16(:,:,1838))
  call heltable([8,2,16], n3(:,2187), t3x16(:,:,1839))
  call heltable([8,2,16], n3(:,2188), t3x16(:,:,1840))
  call heltable([2,2,4], n3(:,2189), t3x4(:,:,40))
  call heltable([4,4,16], n3(:,2190), t3x16(:,:,1841))
  call heltable([2,2,4], n3(:,2191), t3x4(:,:,41))
  call heltable([4,4,16], n3(:,2192), t3x16(:,:,1842))
  call heltable([2,2,4], n3(:,2193), t3x4(:,:,42))
  call heltable([4,4,16], n3(:,2194), t3x16(:,:,1843))
  call heltable([2,2,4], n3(:,2195), t3x4(:,:,43))
  call heltable([4,4,16], n3(:,2196), t3x16(:,:,1844))
  call heltable([4,2,8], n3(:,2197), t3x8(:,:,310))
  n2(264) = 8
  call heltable([4,2,8], n3(:,2198), t3x8(:,:,311))
  n2(265) = 8
  call heltable([2,4,8], n3(:,2199), t3x8(:,:,312))
  n2(266) = 8
  call heltable([2,4,8], n3(:,2200), t3x8(:,:,313))
  n2(267) = 8
  call heltable([4,4,16], n3(:,2201), t3x16(:,:,1845))
  call heltable([4,4,16], n3(:,2202), t3x16(:,:,1846))
  call heltable([4,4,16], n3(:,2203), t3x16(:,:,1847))
  call heltable([4,4,16], n3(:,2204), t3x16(:,:,1848))
  call heltable([4,4,16], n3(:,2205), t3x16(:,:,1849))
  call heltable([4,4,16], n3(:,2206), t3x16(:,:,1850))
  call heltable([4,4,16], n3(:,2207), t3x16(:,:,1851))
  call heltable([4,4,16], n3(:,2208), t3x16(:,:,1852))
  call heltable([4,4,16], n3(:,2209), t3x16(:,:,1853))
  call heltable([4,4,16], n3(:,2210), t3x16(:,:,1854))
  call heltable([4,4,16], n3(:,2211), t3x16(:,:,1855))
  call heltable([4,4,16], n3(:,2212), t3x16(:,:,1856))
  call heltable([4,4,16], n3(:,2213), t3x16(:,:,1857))
  call heltable([4,4,16], n3(:,2214), t3x16(:,:,1858))
  call heltable([4,4,16], n3(:,2215), t3x16(:,:,1859))
  call heltable([4,4,16], n3(:,2216), t3x16(:,:,1860))
  call heltable([4,4,16], n3(:,2217), t3x16(:,:,1861))
  call heltable([2,4,8], n3(:,2218), t3x8(:,:,314))
  n2(268) = 8
  call heltable([2,4,8], n3(:,2219), t3x8(:,:,315))
  n2(269) = 8
  call heltable([4,2,8], n3(:,2220), t3x8(:,:,316))
  n2(270) = 8
  call heltable([4,2,8], n3(:,2221), t3x8(:,:,317))
  n2(271) = 8
  call heltable([2,8,16], n3(:,2222), t3x16(:,:,1862))
  call heltable([2,8,16], n3(:,2223), t3x16(:,:,1863))
  call heltable([2,8,16], n3(:,2224), t3x16(:,:,1864))
  call heltable([2,8,16], n3(:,2225), t3x16(:,:,1865))
  call heltable([4,4,16], n3(:,2226), t3x16(:,:,1866))
  call heltable([4,4,16], n3(:,2227), t3x16(:,:,1867))
  call heltable([4,4,16], n3(:,2228), t3x16(:,:,1868))
  call heltable([4,4,16], n3(:,2229), t3x16(:,:,1869))
  call heltable([4,4,16], n3(:,2230), t3x16(:,:,1870))
  call heltable([4,4,16], n3(:,2231), t3x16(:,:,1871))
  call heltable([4,4,16], n3(:,2232), t3x16(:,:,1872))
  call heltable([4,4,16], n3(:,2233), t3x16(:,:,1873))
  call heltable([4,4,16], n3(:,2234), t3x16(:,:,1874))
  call heltable([4,4,16], n3(:,2235), t3x16(:,:,1875))
  call heltable([4,4,16], n3(:,2236), t3x16(:,:,1876))
  call heltable([4,4,16], n3(:,2237), t3x16(:,:,1877))
  call heltable([4,4,16], n3(:,2238), t3x16(:,:,1878))
  call heltable([4,2,8], n3(:,2239), t3x8(:,:,318))
  n2(272) = 8
  call heltable([4,2,8], n3(:,2240), t3x8(:,:,319))
  n2(273) = 8
  call heltable([2,4,8], n3(:,2241), t3x8(:,:,320))
  n2(274) = 8
  call heltable([2,4,8], n3(:,2242), t3x8(:,:,321))
  n2(275) = 8
  call heltable([4,4,16], n3(:,2243), t3x16(:,:,1879))
  call heltable([4,4,16], n3(:,2244), t3x16(:,:,1880))
  call heltable([4,4,16], n3(:,2245), t3x16(:,:,1881))
  call heltable([4,4,16], n3(:,2246), t3x16(:,:,1882))
  call heltable([4,4,16], n3(:,2247), t3x16(:,:,1883))
  call heltable([4,4,16], n3(:,2248), t3x16(:,:,1884))
  call heltable([4,4,16], n3(:,2249), t3x16(:,:,1885))
  call heltable([4,4,16], n3(:,2250), t3x16(:,:,1886))
  call heltable([2,4,8], n3(:,2251), t3x8(:,:,322))
  n2(276) = 8
  call heltable([2,4,8], n3(:,2252), t3x8(:,:,323))
  n2(277) = 8
  call heltable([4,2,8], n3(:,2253), t3x8(:,:,324))
  n2(278) = 8
  call heltable([4,2,8], n3(:,2254), t3x8(:,:,325))
  n2(279) = 8
  call heltable([2,8,16], n3(:,2255), t3x16(:,:,1887))
  call heltable([2,8,16], n3(:,2256), t3x16(:,:,1888))
  call heltable([2,8,16], n3(:,2257), t3x16(:,:,1889))
  call heltable([2,8,16], n3(:,2258), t3x16(:,:,1890))
  call heltable([8,2,16], n3(:,2259), t3x16(:,:,1891))
  call heltable([8,2,16], n3(:,2260), t3x16(:,:,1892))
  call heltable([8,2,16], n3(:,2261), t3x16(:,:,1893))
  call heltable([8,2,16], n3(:,2262), t3x16(:,:,1894))
  call heltable([8,2,16], n3(:,2263), t3x16(:,:,1895))
  call heltable([8,2,16], n3(:,2264), t3x16(:,:,1896))
  call heltable([8,2,16], n3(:,2265), t3x16(:,:,1897))
  call heltable([8,2,16], n3(:,2266), t3x16(:,:,1898))
  call heltable([2,8,16], n3(:,2267), t3x16(:,:,1899))
  call heltable([2,8,16], n3(:,2268), t3x16(:,:,1900))
  call heltable([2,8,16], n3(:,2269), t3x16(:,:,1901))
  call heltable([2,8,16], n3(:,2270), t3x16(:,:,1902))
  call heltable([2,8,16], n3(:,2271), t3x16(:,:,1903))
  call heltable([2,8,16], n3(:,2272), t3x16(:,:,1904))
  call heltable([2,8,16], n3(:,2273), t3x16(:,:,1905))
  call heltable([2,8,16], n3(:,2274), t3x16(:,:,1906))
  call heltable([2,8,16], n3(:,2275), t3x16(:,:,1907))
  call heltable([2,8,16], n3(:,2276), t3x16(:,:,1908))
  call heltable([2,8,16], n3(:,2277), t3x16(:,:,1909))
  call heltable([2,8,16], n3(:,2278), t3x16(:,:,1910))
  call heltable([8,2,16], n3(:,2279), t3x16(:,:,1911))
  call heltable([8,2,16], n3(:,2280), t3x16(:,:,1912))
  call heltable([8,2,16], n3(:,2281), t3x16(:,:,1913))
  call heltable([8,2,16], n3(:,2282), t3x16(:,:,1914))
  call heltable([2,8,16], n3(:,2283), t3x16(:,:,1915))
  call heltable([2,8,16], n3(:,2284), t3x16(:,:,1916))
  call heltable([2,8,16], n3(:,2285), t3x16(:,:,1917))
  call heltable([2,8,16], n3(:,2286), t3x16(:,:,1918))
  call heltable([8,2,16], n3(:,2287), t3x16(:,:,1919))
  call heltable([8,2,16], n3(:,2288), t3x16(:,:,1920))
  call heltable([8,2,16], n3(:,2289), t3x16(:,:,1921))
  call heltable([8,2,16], n3(:,2290), t3x16(:,:,1922))
  call heltable([2,4,8], n3(:,2291), t3x8(:,:,326))
  call heltable([2,4,8], n3(:,2292), t3x8(:,:,327))
  call heltable([4,2,8], n3(:,2293), t3x8(:,:,328))
  call heltable([4,2,8], n3(:,2294), t3x8(:,:,329))
  call heltable([4,2,8], n3(:,2295), t3x8(:,:,330))
  call heltable([4,2,8], n3(:,2296), t3x8(:,:,331))
  call heltable([2,4,8], n3(:,2297), t3x8(:,:,332))
  call heltable([2,4,8], n3(:,2298), t3x8(:,:,333))
  n2(280) = 16
  n2(281) = 16
  call heltable([2,4,8], n3(:,2299), t3x8(:,:,334))
  n2(282) = 16
  n2(283) = 16
  call heltable([4,2,8], n3(:,2300), t3x8(:,:,335))
  call heltable([4,2,8], n3(:,2301), t3x8(:,:,336))
  n2(284) = 8
  call heltable([2,8,16], n3(:,2302), t3x16(:,:,1923))
  n2(285) = 8
  call heltable([2,8,16], n3(:,2303), t3x16(:,:,1924))
  n2(286) = 8
  call heltable([2,8,16], n3(:,2304), t3x16(:,:,1925))
  n2(287) = 8
  call heltable([2,8,16], n3(:,2305), t3x16(:,:,1926))
  n2(288) = 8
  call heltable([2,8,16], n3(:,2306), t3x16(:,:,1927))
  n2(289) = 8
  call heltable([2,8,16], n3(:,2307), t3x16(:,:,1928))
  n2(290) = 8
  call heltable([2,8,16], n3(:,2308), t3x16(:,:,1929))
  n2(291) = 8
  call heltable([2,8,16], n3(:,2309), t3x16(:,:,1930))
  call heltable([2,2,4], n3(:,2310), t3x4(:,:,44))
  n2(292) = 4
  call heltable([2,4,8], n3(:,2311), t3x8(:,:,337))
  call heltable([2,4,8], n3(:,2312), t3x8(:,:,338))
  call heltable([4,2,8], n3(:,2313), t3x8(:,:,339))
  call heltable([4,4,16], n3(:,2314), t3x16(:,:,1931))
  call heltable([4,4,16], n3(:,2315), t3x16(:,:,1932))
  call heltable([4,4,16], n3(:,2316), t3x16(:,:,1933))
  call heltable([4,4,16], n3(:,2317), t3x16(:,:,1934))
  call heltable([4,4,16], n3(:,2318), t3x16(:,:,1935))
  call heltable([4,4,16], n3(:,2319), t3x16(:,:,1936))
  call heltable([4,4,16], n3(:,2320), t3x16(:,:,1937))
  call heltable([4,4,16], n3(:,2321), t3x16(:,:,1938))
  call heltable([2,8,16], n3(:,2322), t3x16(:,:,1939))
  call heltable([2,8,16], n3(:,2323), t3x16(:,:,1940))
  call heltable([2,4,8], n3(:,2324), t3x8(:,:,340))
  call heltable([8,2,16], n3(:,2325), t3x16(:,:,1941))
  call heltable([8,2,16], n3(:,2326), t3x16(:,:,1942))
  call heltable([8,2,16], n3(:,2327), t3x16(:,:,1943))
  call heltable([8,2,16], n3(:,2328), t3x16(:,:,1944))
  call heltable([2,8,16], n3(:,2329), t3x16(:,:,1945))
  call heltable([2,8,16], n3(:,2330), t3x16(:,:,1946))
  call heltable([2,8,16], n3(:,2331), t3x16(:,:,1947))
  call heltable([2,8,16], n3(:,2332), t3x16(:,:,1948))
  call heltable([2,8,16], n3(:,2333), t3x16(:,:,1949))
  call heltable([2,8,16], n3(:,2334), t3x16(:,:,1950))
  call heltable([8,2,16], n3(:,2335), t3x16(:,:,1951))
  call heltable([8,2,16], n3(:,2336), t3x16(:,:,1952))
  call heltable([8,2,16], n3(:,2337), t3x16(:,:,1953))
  call heltable([8,2,16], n3(:,2338), t3x16(:,:,1954))
  call heltable([2,8,16], n3(:,2339), t3x16(:,:,1955))
  call heltable([2,8,16], n3(:,2340), t3x16(:,:,1956))
  call heltable([2,8,16], n3(:,2341), t3x16(:,:,1957))
  call heltable([2,8,16], n3(:,2342), t3x16(:,:,1958))
  call heltable([8,2,16], n3(:,2343), t3x16(:,:,1959))
  call heltable([8,2,16], n3(:,2344), t3x16(:,:,1960))
  call heltable([8,2,16], n3(:,2345), t3x16(:,:,1961))
  call heltable([8,2,16], n3(:,2346), t3x16(:,:,1962))
  call heltable([8,2,16], n3(:,2347), t3x16(:,:,1963))
  call heltable([8,2,16], n3(:,2348), t3x16(:,:,1964))
  call heltable([8,2,16], n3(:,2349), t3x16(:,:,1965))
  call heltable([8,2,16], n3(:,2350), t3x16(:,:,1966))
  call heltable([8,2,16], n3(:,2351), t3x16(:,:,1967))
  call heltable([8,2,16], n3(:,2352), t3x16(:,:,1968))
  call heltable([8,2,16], n3(:,2353), t3x16(:,:,1969))
  call heltable([8,2,16], n3(:,2354), t3x16(:,:,1970))
  call heltable([2,8,16], n3(:,2355), t3x16(:,:,1971))
  call heltable([2,8,16], n3(:,2356), t3x16(:,:,1972))
  call heltable([2,8,16], n3(:,2357), t3x16(:,:,1973))
  call heltable([2,8,16], n3(:,2358), t3x16(:,:,1974))
  call heltable([2,8,16], n3(:,2359), t3x16(:,:,1975))
  call heltable([2,8,16], n3(:,2360), t3x16(:,:,1976))
  call heltable([2,8,16], n3(:,2361), t3x16(:,:,1977))
  call heltable([2,8,16], n3(:,2362), t3x16(:,:,1978))
  call heltable([8,2,16], n3(:,2363), t3x16(:,:,1979))
  call heltable([8,2,16], n3(:,2364), t3x16(:,:,1980))
  call heltable([4,2,8], n3(:,2365), t3x8(:,:,341))
  call heltable([2,8,16], n3(:,2366), t3x16(:,:,1981))
  call heltable([2,8,16], n3(:,2367), t3x16(:,:,1982))
  call heltable([2,8,16], n3(:,2368), t3x16(:,:,1983))
  call heltable([2,8,16], n3(:,2369), t3x16(:,:,1984))
  call heltable([8,2,16], n3(:,2370), t3x16(:,:,1985))
  call heltable([8,2,16], n3(:,2371), t3x16(:,:,1986))
  call heltable([2,2,4], n3(:,2372), t3x4(:,:,45))
  call heltable([4,2,8], n3(:,2373), t3x8(:,:,342))
  n2(293) = 8
  call heltable([2,2,4], n3(:,2374), t3x4(:,:,46))
  call heltable([4,2,8], n3(:,2375), t3x8(:,:,343))
  n2(294) = 8
  call heltable([2,2,4], n3(:,2376), t3x4(:,:,47))
  call heltable([2,4,8], n3(:,2377), t3x8(:,:,344))
  n2(295) = 8
  call heltable([2,2,4], n3(:,2378), t3x4(:,:,48))
  call heltable([2,4,8], n3(:,2379), t3x8(:,:,345))
  n2(296) = 8
  call heltable([4,4,16], n3(:,2380), t3x16(:,:,1987))
  call heltable([4,4,16], n3(:,2381), t3x16(:,:,1988))
  call heltable([4,4,16], n3(:,2382), t3x16(:,:,1989))
  call heltable([4,4,16], n3(:,2383), t3x16(:,:,1990))
  call heltable([4,4,16], n3(:,2384), t3x16(:,:,1991))
  call heltable([4,4,16], n3(:,2385), t3x16(:,:,1992))
  call heltable([4,4,16], n3(:,2386), t3x16(:,:,1993))
  call heltable([4,4,16], n3(:,2387), t3x16(:,:,1994))
  call heltable([4,4,16], n3(:,2388), t3x16(:,:,1995))
  call heltable([4,4,16], n3(:,2389), t3x16(:,:,1996))
  call heltable([4,4,16], n3(:,2390), t3x16(:,:,1997))
  call heltable([4,4,16], n3(:,2391), t3x16(:,:,1998))
  call heltable([4,4,16], n3(:,2392), t3x16(:,:,1999))
  call heltable([4,4,16], n3(:,2393), t3x16(:,:,2000))
  call heltable([4,4,16], n3(:,2394), t3x16(:,:,2001))
  call heltable([4,4,16], n3(:,2395), t3x16(:,:,2002))
  call heltable([4,4,16], n3(:,2396), t3x16(:,:,2003))
  call heltable([2,4,8], n3(:,2397), t3x8(:,:,346))
  n2(297) = 8
  call heltable([2,4,8], n3(:,2398), t3x8(:,:,347))
  n2(298) = 8
  call heltable([4,2,8], n3(:,2399), t3x8(:,:,348))
  n2(299) = 8
  call heltable([4,2,8], n3(:,2400), t3x8(:,:,349))
  n2(300) = 8
  call heltable([4,4,16], n3(:,2401), t3x16(:,:,2004))
  call heltable([4,4,16], n3(:,2402), t3x16(:,:,2005))
  call heltable([4,4,16], n3(:,2403), t3x16(:,:,2006))
  call heltable([4,4,16], n3(:,2404), t3x16(:,:,2007))
  call heltable([2,8,16], n3(:,2405), t3x16(:,:,2008))
  call heltable([2,8,16], n3(:,2406), t3x16(:,:,2009))
  call heltable([2,8,16], n3(:,2407), t3x16(:,:,2010))
  call heltable([2,8,16], n3(:,2408), t3x16(:,:,2011))
  call heltable([2,4,8], n3(:,2409), t3x8(:,:,350))
  call heltable([2,4,8], n3(:,2410), t3x8(:,:,351))
  call heltable([4,2,8], n3(:,2411), t3x8(:,:,352))
  call heltable([4,2,8], n3(:,2412), t3x8(:,:,353))
  call heltable([4,2,8], n3(:,2413), t3x8(:,:,354))
  call heltable([4,2,8], n3(:,2414), t3x8(:,:,355))
  call heltable([2,4,8], n3(:,2415), t3x8(:,:,356))
  n2(301) = 16
  n2(302) = 16
  n2(303) = 16
  n2(304) = 16
  n2(305) = 8
  call heltable([2,8,16], n3(:,2416), t3x16(:,:,2012))
  n2(306) = 8
  call heltable([2,8,16], n3(:,2417), t3x16(:,:,2013))
  n2(307) = 8
  call heltable([2,8,16], n3(:,2418), t3x16(:,:,2014))
  n2(308) = 8
  call heltable([2,8,16], n3(:,2419), t3x16(:,:,2015))
  call heltable([2,4,8], n3(:,2420), t3x8(:,:,357))
  call heltable([2,4,8], n3(:,2421), t3x8(:,:,358))
  call heltable([4,2,8], n3(:,2422), t3x8(:,:,359))
  call heltable([4,4,16], n3(:,2423), t3x16(:,:,2016))
  call heltable([4,4,16], n3(:,2424), t3x16(:,:,2017))
  call heltable([4,4,16], n3(:,2425), t3x16(:,:,2018))
  call heltable([4,4,16], n3(:,2426), t3x16(:,:,2019))
  call heltable([2,8,16], n3(:,2427), t3x16(:,:,2020))
  call heltable([2,8,16], n3(:,2428), t3x16(:,:,2021))
  call heltable([2,4,8], n3(:,2429), t3x8(:,:,360))
  call heltable([8,2,16], n3(:,2430), t3x16(:,:,2022))
  call heltable([8,2,16], n3(:,2431), t3x16(:,:,2023))
  call heltable([8,2,16], n3(:,2432), t3x16(:,:,2024))
  call heltable([8,2,16], n3(:,2433), t3x16(:,:,2025))
  call heltable([2,8,16], n3(:,2434), t3x16(:,:,2026))
  call heltable([2,8,16], n3(:,2435), t3x16(:,:,2027))
  call heltable([2,8,16], n3(:,2436), t3x16(:,:,2028))
  call heltable([2,8,16], n3(:,2437), t3x16(:,:,2029))
  call heltable([2,8,16], n3(:,2438), t3x16(:,:,2030))
  call heltable([2,8,16], n3(:,2439), t3x16(:,:,2031))
  call heltable([8,2,16], n3(:,2440), t3x16(:,:,2032))
  call heltable([8,2,16], n3(:,2441), t3x16(:,:,2033))
  call heltable([8,2,16], n3(:,2442), t3x16(:,:,2034))
  call heltable([8,2,16], n3(:,2443), t3x16(:,:,2035))
  call heltable([2,8,16], n3(:,2444), t3x16(:,:,2036))
  call heltable([2,8,16], n3(:,2445), t3x16(:,:,2037))
  call heltable([2,8,16], n3(:,2446), t3x16(:,:,2038))
  call heltable([2,8,16], n3(:,2447), t3x16(:,:,2039))
  call heltable([8,2,16], n3(:,2448), t3x16(:,:,2040))
  call heltable([8,2,16], n3(:,2449), t3x16(:,:,2041))
  call heltable([8,2,16], n3(:,2450), t3x16(:,:,2042))
  call heltable([8,2,16], n3(:,2451), t3x16(:,:,2043))
  call heltable([8,2,16], n3(:,2452), t3x16(:,:,2044))
  call heltable([8,2,16], n3(:,2453), t3x16(:,:,2045))
  call heltable([8,2,16], n3(:,2454), t3x16(:,:,2046))
  call heltable([8,2,16], n3(:,2455), t3x16(:,:,2047))
  call heltable([8,2,16], n3(:,2456), t3x16(:,:,2048))
  call heltable([8,2,16], n3(:,2457), t3x16(:,:,2049))
  call heltable([8,2,16], n3(:,2458), t3x16(:,:,2050))
  call heltable([8,2,16], n3(:,2459), t3x16(:,:,2051))
  call heltable([2,8,16], n3(:,2460), t3x16(:,:,2052))
  call heltable([2,8,16], n3(:,2461), t3x16(:,:,2053))
  call heltable([2,8,16], n3(:,2462), t3x16(:,:,2054))
  call heltable([2,8,16], n3(:,2463), t3x16(:,:,2055))
  call heltable([2,8,16], n3(:,2464), t3x16(:,:,2056))
  call heltable([2,8,16], n3(:,2465), t3x16(:,:,2057))
  call heltable([2,8,16], n3(:,2466), t3x16(:,:,2058))
  call heltable([2,8,16], n3(:,2467), t3x16(:,:,2059))
  call heltable([8,2,16], n3(:,2468), t3x16(:,:,2060))
  call heltable([8,2,16], n3(:,2469), t3x16(:,:,2061))
  call heltable([4,2,8], n3(:,2470), t3x8(:,:,361))
  call heltable([2,8,16], n3(:,2471), t3x16(:,:,2062))
  call heltable([2,8,16], n3(:,2472), t3x16(:,:,2063))
  call heltable([2,8,16], n3(:,2473), t3x16(:,:,2064))
  call heltable([2,8,16], n3(:,2474), t3x16(:,:,2065))
  call heltable([8,2,16], n3(:,2475), t3x16(:,:,2066))
  call heltable([8,2,16], n3(:,2476), t3x16(:,:,2067))
  call heltable([2,8,16], n3(:,2477), t3x16(:,:,2068))
  call heltable([2,8,16], n3(:,2478), t3x16(:,:,2069))
  call heltable([8,2,16], n3(:,2479), t3x16(:,:,2070))
  call heltable([8,2,16], n3(:,2480), t3x16(:,:,2071))
  call heltable([8,2,16], n3(:,2481), t3x16(:,:,2072))
  call heltable([8,2,16], n3(:,2482), t3x16(:,:,2073))
  call heltable([8,2,16], n3(:,2483), t3x16(:,:,2074))
  call heltable([8,2,16], n3(:,2484), t3x16(:,:,2075))
  call heltable([8,2,16], n3(:,2485), t3x16(:,:,2076))
  call heltable([8,2,16], n3(:,2486), t3x16(:,:,2077))
  call heltable([8,2,16], n3(:,2487), t3x16(:,:,2078))
  call heltable([8,2,16], n3(:,2488), t3x16(:,:,2079))
  call heltable([2,8,16], n3(:,2489), t3x16(:,:,2080))
  call heltable([2,8,16], n3(:,2490), t3x16(:,:,2081))
  call heltable([2,8,16], n3(:,2491), t3x16(:,:,2082))
  call heltable([2,8,16], n3(:,2492), t3x16(:,:,2083))
  call heltable([2,8,16], n3(:,2493), t3x16(:,:,2084))
  call heltable([2,8,16], n3(:,2494), t3x16(:,:,2085))
  call heltable([2,8,16], n3(:,2495), t3x16(:,:,2086))
  call heltable([2,8,16], n3(:,2496), t3x16(:,:,2087))
  call heltable([2,8,16], n3(:,2497), t3x16(:,:,2088))
  call heltable([2,8,16], n3(:,2498), t3x16(:,:,2089))
  call heltable([2,8,16], n3(:,2499), t3x16(:,:,2090))
  call heltable([2,8,16], n3(:,2500), t3x16(:,:,2091))
  call heltable([8,2,16], n3(:,2501), t3x16(:,:,2092))
  call heltable([8,2,16], n3(:,2502), t3x16(:,:,2093))
  call heltable([8,2,16], n3(:,2503), t3x16(:,:,2094))
  call heltable([8,2,16], n3(:,2504), t3x16(:,:,2095))
  call heltable([2,8,16], n3(:,2505), t3x16(:,:,2096))
  call heltable([2,8,16], n3(:,2506), t3x16(:,:,2097))
  call heltable([2,8,16], n3(:,2507), t3x16(:,:,2098))
  call heltable([2,8,16], n3(:,2508), t3x16(:,:,2099))
  call heltable([8,2,16], n3(:,2509), t3x16(:,:,2100))
  call heltable([8,2,16], n3(:,2510), t3x16(:,:,2101))
  call heltable([8,2,16], n3(:,2511), t3x16(:,:,2102))
  call heltable([8,2,16], n3(:,2512), t3x16(:,:,2103))
  call heltable([2,8,16], n3(:,2513), t3x16(:,:,2104))
  call heltable([2,8,16], n3(:,2514), t3x16(:,:,2105))
  call heltable([2,8,16], n3(:,2515), t3x16(:,:,2106))
  call heltable([2,8,16], n3(:,2516), t3x16(:,:,2107))
  call heltable([8,2,16], n3(:,2517), t3x16(:,:,2108))
  call heltable([8,2,16], n3(:,2518), t3x16(:,:,2109))
  call heltable([8,2,16], n3(:,2519), t3x16(:,:,2110))
  call heltable([8,2,16], n3(:,2520), t3x16(:,:,2111))
  call heltable([2,8,16], n3(:,2521), t3x16(:,:,2112))
  call heltable([2,8,16], n3(:,2522), t3x16(:,:,2113))
  call heltable([2,8,16], n3(:,2523), t3x16(:,:,2114))
  call heltable([2,8,16], n3(:,2524), t3x16(:,:,2115))
  call heltable([8,2,16], n3(:,2525), t3x16(:,:,2116))
  call heltable([8,2,16], n3(:,2526), t3x16(:,:,2117))
  call heltable([8,2,16], n3(:,2527), t3x16(:,:,2118))
  call heltable([8,2,16], n3(:,2528), t3x16(:,:,2119))
  call heltable([2,8,16], n3(:,2529), t3x16(:,:,2120))
  call heltable([2,8,16], n3(:,2530), t3x16(:,:,2121))
  call heltable([8,2,16], n3(:,2531), t3x16(:,:,2122))
  call heltable([8,2,16], n3(:,2532), t3x16(:,:,2123))
  call heltable([2,8,16], n3(:,2533), t3x16(:,:,2124))
  call heltable([2,8,16], n3(:,2534), t3x16(:,:,2125))
  call heltable([8,2,16], n3(:,2535), t3x16(:,:,2126))
  call heltable([8,2,16], n3(:,2536), t3x16(:,:,2127))
  call heltable([8,2,16], n3(:,2537), t3x16(:,:,2128))
  call heltable([8,2,16], n3(:,2538), t3x16(:,:,2129))
  call heltable([2,8,16], n3(:,2539), t3x16(:,:,2130))
  call heltable([2,8,16], n3(:,2540), t3x16(:,:,2131))
  call heltable([2,8,16], n3(:,2541), t3x16(:,:,2132))
  call heltable([2,8,16], n3(:,2542), t3x16(:,:,2133))
  call heltable([8,2,16], n3(:,2543), t3x16(:,:,2134))
  call heltable([8,2,16], n3(:,2544), t3x16(:,:,2135))
  call heltable([2,8,16], n3(:,2545), t3x16(:,:,2136))
  call heltable([2,8,16], n3(:,2546), t3x16(:,:,2137))
  call heltable([8,2,16], n3(:,2547), t3x16(:,:,2138))
  call heltable([8,2,16], n3(:,2548), t3x16(:,:,2139))
  call heltable([8,2,16], n3(:,2549), t3x16(:,:,2140))
  call heltable([8,2,16], n3(:,2550), t3x16(:,:,2141))
  call heltable([2,8,16], n3(:,2551), t3x16(:,:,2142))
  call heltable([2,8,16], n3(:,2552), t3x16(:,:,2143))
  call heltable([2,8,16], n3(:,2553), t3x16(:,:,2144))
  call heltable([2,8,16], n3(:,2554), t3x16(:,:,2145))
  call heltable([8,2,16], n3(:,2555), t3x16(:,:,2146))
  call heltable([8,2,16], n3(:,2556), t3x16(:,:,2147))
  call heltable([4,2,8], n3(:,2557), t3x8(:,:,362))
  n2(309) = 8
  call heltable([4,2,8], n3(:,2558), t3x8(:,:,363))
  n2(310) = 8
  call heltable([2,4,8], n3(:,2559), t3x8(:,:,364))
  n2(311) = 8
  call heltable([2,4,8], n3(:,2560), t3x8(:,:,365))
  n2(312) = 8
  call heltable([4,4,16], n3(:,2561), t3x16(:,:,2148))
  call heltable([4,4,16], n3(:,2562), t3x16(:,:,2149))
  call heltable([4,4,16], n3(:,2563), t3x16(:,:,2150))
  call heltable([4,4,16], n3(:,2564), t3x16(:,:,2151))
  call heltable([4,4,16], n3(:,2565), t3x16(:,:,2152))
  call heltable([4,4,16], n3(:,2566), t3x16(:,:,2153))
  call heltable([4,4,16], n3(:,2567), t3x16(:,:,2154))
  call heltable([4,4,16], n3(:,2568), t3x16(:,:,2155))
  call heltable([4,4,16], n3(:,2569), t3x16(:,:,2156))
  call heltable([4,4,16], n3(:,2570), t3x16(:,:,2157))
  call heltable([4,4,16], n3(:,2571), t3x16(:,:,2158))
  call heltable([4,4,16], n3(:,2572), t3x16(:,:,2159))
  call heltable([4,4,16], n3(:,2573), t3x16(:,:,2160))
  call heltable([4,4,16], n3(:,2574), t3x16(:,:,2161))
  call heltable([4,4,16], n3(:,2575), t3x16(:,:,2162))
  call heltable([4,4,16], n3(:,2576), t3x16(:,:,2163))
  call heltable([4,4,16], n3(:,2577), t3x16(:,:,2164))
  call heltable([2,4,8], n3(:,2578), t3x8(:,:,366))
  n2(313) = 8
  call heltable([2,4,8], n3(:,2579), t3x8(:,:,367))
  n2(314) = 8
  call heltable([4,2,8], n3(:,2580), t3x8(:,:,368))
  n2(315) = 8
  call heltable([4,2,8], n3(:,2581), t3x8(:,:,369))
  n2(316) = 8
  call heltable([4,4,16], n3(:,2582), t3x16(:,:,2165))
  call heltable([4,4,16], n3(:,2583), t3x16(:,:,2166))
  call heltable([4,4,16], n3(:,2584), t3x16(:,:,2167))
  call heltable([4,4,16], n3(:,2585), t3x16(:,:,2168))
  call heltable([2,8,16], n3(:,2586), t3x16(:,:,2169))
  call heltable([2,8,16], n3(:,2587), t3x16(:,:,2170))
  call heltable([2,8,16], n3(:,2588), t3x16(:,:,2171))
  call heltable([2,8,16], n3(:,2589), t3x16(:,:,2172))
  call heltable([2,8,16], n3(:,2590), t3x16(:,:,2173))
  call heltable([2,8,16], n3(:,2591), t3x16(:,:,2174))
  call heltable([2,8,16], n3(:,2592), t3x16(:,:,2175))
  call heltable([2,8,16], n3(:,2593), t3x16(:,:,2176))
  call heltable([8,2,16], n3(:,2594), t3x16(:,:,2177))
  call heltable([8,2,16], n3(:,2595), t3x16(:,:,2178))
  call heltable([8,2,16], n3(:,2596), t3x16(:,:,2179))
  call heltable([8,2,16], n3(:,2597), t3x16(:,:,2180))
  call heltable([2,8,16], n3(:,2598), t3x16(:,:,2181))
  call heltable([2,8,16], n3(:,2599), t3x16(:,:,2182))
  call heltable([2,8,16], n3(:,2600), t3x16(:,:,2183))
  call heltable([2,8,16], n3(:,2601), t3x16(:,:,2184))
  call heltable([8,2,16], n3(:,2602), t3x16(:,:,2185))
  call heltable([8,2,16], n3(:,2603), t3x16(:,:,2186))
  call heltable([8,2,16], n3(:,2604), t3x16(:,:,2187))
  call heltable([8,2,16], n3(:,2605), t3x16(:,:,2188))
  call heltable([8,2,16], n3(:,2606), t3x16(:,:,2189))
  call heltable([8,2,16], n3(:,2607), t3x16(:,:,2190))
  call heltable([8,2,16], n3(:,2608), t3x16(:,:,2191))
  call heltable([8,2,16], n3(:,2609), t3x16(:,:,2192))
  call heltable([2,8,16], n3(:,2610), t3x16(:,:,2193))
  call heltable([2,8,16], n3(:,2611), t3x16(:,:,2194))
  call heltable([2,8,16], n3(:,2612), t3x16(:,:,2195))
  call heltable([2,8,16], n3(:,2613), t3x16(:,:,2196))
  call heltable([8,2,16], n3(:,2614), t3x16(:,:,2197))
  call heltable([8,2,16], n3(:,2615), t3x16(:,:,2198))
  call heltable([8,2,16], n3(:,2616), t3x16(:,:,2199))
  call heltable([8,2,16], n3(:,2617), t3x16(:,:,2200))
  call heltable([2,8,16], n3(:,2618), t3x16(:,:,2201))
  call heltable([2,8,16], n3(:,2619), t3x16(:,:,2202))
  call heltable([2,8,16], n3(:,2620), t3x16(:,:,2203))
  call heltable([2,8,16], n3(:,2621), t3x16(:,:,2204))
  call heltable([2,2,4], n3(:,2622), t3x4(:,:,49))
  call heltable([4,2,8], n3(:,2623), t3x8(:,:,370))
  n2(317) = 8
  call heltable([2,2,4], n3(:,2624), t3x4(:,:,50))
  call heltable([4,2,8], n3(:,2625), t3x8(:,:,371))
  n2(318) = 8
  call heltable([2,2,4], n3(:,2626), t3x4(:,:,51))
  call heltable([2,4,8], n3(:,2627), t3x8(:,:,372))
  n2(319) = 8
  call heltable([2,2,4], n3(:,2628), t3x4(:,:,52))
  call heltable([2,4,8], n3(:,2629), t3x8(:,:,373))
  n2(320) = 8
  call heltable([4,4,16], n3(:,2630), t3x16(:,:,2205))
  call heltable([4,4,16], n3(:,2631), t3x16(:,:,2206))
  call heltable([4,4,16], n3(:,2632), t3x16(:,:,2207))
  call heltable([4,4,16], n3(:,2633), t3x16(:,:,2208))
  call heltable([4,4,16], n3(:,2634), t3x16(:,:,2209))
  call heltable([4,4,16], n3(:,2635), t3x16(:,:,2210))
  call heltable([4,4,16], n3(:,2636), t3x16(:,:,2211))
  call heltable([4,4,16], n3(:,2637), t3x16(:,:,2212))
  call heltable([4,4,16], n3(:,2638), t3x16(:,:,2213))
  call heltable([4,4,16], n3(:,2639), t3x16(:,:,2214))
  call heltable([4,4,16], n3(:,2640), t3x16(:,:,2215))
  call heltable([4,4,16], n3(:,2641), t3x16(:,:,2216))
  call heltable([4,4,16], n3(:,2642), t3x16(:,:,2217))
  call heltable([4,4,16], n3(:,2643), t3x16(:,:,2218))
  call heltable([4,4,16], n3(:,2644), t3x16(:,:,2219))
  call heltable([4,4,16], n3(:,2645), t3x16(:,:,2220))
  call heltable([4,4,16], n3(:,2646), t3x16(:,:,2221))
  call heltable([2,4,8], n3(:,2647), t3x8(:,:,374))
  n2(321) = 8
  call heltable([2,4,8], n3(:,2648), t3x8(:,:,375))
  n2(322) = 8
  call heltable([4,2,8], n3(:,2649), t3x8(:,:,376))
  n2(323) = 8
  call heltable([4,2,8], n3(:,2650), t3x8(:,:,377))
  n2(324) = 8
  call heltable([4,4,16], n3(:,2651), t3x16(:,:,2222))
  call heltable([4,4,16], n3(:,2652), t3x16(:,:,2223))
  call heltable([4,4,16], n3(:,2653), t3x16(:,:,2224))
  call heltable([4,4,16], n3(:,2654), t3x16(:,:,2225))
  call heltable([2,8,16], n3(:,2655), t3x16(:,:,2226))
  call heltable([2,8,16], n3(:,2656), t3x16(:,:,2227))
  call heltable([2,8,16], n3(:,2657), t3x16(:,:,2228))
  call heltable([2,8,16], n3(:,2658), t3x16(:,:,2229))
  call heltable([4,2,8], n3(:,2659), t3x8(:,:,378))
  n2(325) = 8
  call heltable([4,2,8], n3(:,2660), t3x8(:,:,379))
  n2(326) = 8
  call heltable([2,4,8], n3(:,2661), t3x8(:,:,380))
  n2(327) = 8
  call heltable([2,4,8], n3(:,2662), t3x8(:,:,381))
  n2(328) = 8
  call heltable([4,4,16], n3(:,2663), t3x16(:,:,2230))
  call heltable([4,4,16], n3(:,2664), t3x16(:,:,2231))
  call heltable([4,4,16], n3(:,2665), t3x16(:,:,2232))
  call heltable([4,4,16], n3(:,2666), t3x16(:,:,2233))
  call heltable([4,4,16], n3(:,2667), t3x16(:,:,2234))
  call heltable([4,4,16], n3(:,2668), t3x16(:,:,2235))
  call heltable([4,4,16], n3(:,2669), t3x16(:,:,2236))
  call heltable([4,4,16], n3(:,2670), t3x16(:,:,2237))
  call heltable([4,4,16], n3(:,2671), t3x16(:,:,2238))
  call heltable([4,4,16], n3(:,2672), t3x16(:,:,2239))
  call heltable([4,4,16], n3(:,2673), t3x16(:,:,2240))
  call heltable([4,4,16], n3(:,2674), t3x16(:,:,2241))
  call heltable([4,4,16], n3(:,2675), t3x16(:,:,2242))
  call heltable([4,4,16], n3(:,2676), t3x16(:,:,2243))
  call heltable([4,4,16], n3(:,2677), t3x16(:,:,2244))
  call heltable([4,4,16], n3(:,2678), t3x16(:,:,2245))
  call heltable([4,4,16], n3(:,2679), t3x16(:,:,2246))
  call heltable([2,4,8], n3(:,2680), t3x8(:,:,382))
  n2(329) = 8
  call heltable([2,4,8], n3(:,2681), t3x8(:,:,383))
  n2(330) = 8
  call heltable([4,2,8], n3(:,2682), t3x8(:,:,384))
  n2(331) = 8
  call heltable([4,2,8], n3(:,2683), t3x8(:,:,385))
  n2(332) = 8
  call heltable([4,4,16], n3(:,2684), t3x16(:,:,2247))
  call heltable([4,4,16], n3(:,2685), t3x16(:,:,2248))
  call heltable([4,4,16], n3(:,2686), t3x16(:,:,2249))
  call heltable([4,4,16], n3(:,2687), t3x16(:,:,2250))
  call heltable([2,8,16], n3(:,2688), t3x16(:,:,2251))
  call heltable([2,8,16], n3(:,2689), t3x16(:,:,2252))
  call heltable([2,8,16], n3(:,2690), t3x16(:,:,2253))
  call heltable([2,8,16], n3(:,2691), t3x16(:,:,2254))
  call heltable([2,8,16], n3(:,2692), t3x16(:,:,2255))
  call heltable([2,8,16], n3(:,2693), t3x16(:,:,2256))
  call heltable([2,8,16], n3(:,2694), t3x16(:,:,2257))
  call heltable([2,8,16], n3(:,2695), t3x16(:,:,2258))
  call heltable([8,2,16], n3(:,2696), t3x16(:,:,2259))
  call heltable([8,2,16], n3(:,2697), t3x16(:,:,2260))
  call heltable([8,2,16], n3(:,2698), t3x16(:,:,2261))
  call heltable([8,2,16], n3(:,2699), t3x16(:,:,2262))
  call heltable([2,8,16], n3(:,2700), t3x16(:,:,2263))
  call heltable([2,8,16], n3(:,2701), t3x16(:,:,2264))
  call heltable([2,8,16], n3(:,2702), t3x16(:,:,2265))
  call heltable([2,8,16], n3(:,2703), t3x16(:,:,2266))
  call heltable([8,2,16], n3(:,2704), t3x16(:,:,2267))
  call heltable([8,2,16], n3(:,2705), t3x16(:,:,2268))
  call heltable([8,2,16], n3(:,2706), t3x16(:,:,2269))
  call heltable([8,2,16], n3(:,2707), t3x16(:,:,2270))
  call heltable([8,2,16], n3(:,2708), t3x16(:,:,2271))
  call heltable([8,2,16], n3(:,2709), t3x16(:,:,2272))
  call heltable([8,2,16], n3(:,2710), t3x16(:,:,2273))
  call heltable([8,2,16], n3(:,2711), t3x16(:,:,2274))
  call heltable([2,8,16], n3(:,2712), t3x16(:,:,2275))
  call heltable([2,8,16], n3(:,2713), t3x16(:,:,2276))
  call heltable([2,8,16], n3(:,2714), t3x16(:,:,2277))
  call heltable([2,8,16], n3(:,2715), t3x16(:,:,2278))
  call heltable([8,2,16], n3(:,2716), t3x16(:,:,2279))
  call heltable([8,2,16], n3(:,2717), t3x16(:,:,2280))
  call heltable([8,2,16], n3(:,2718), t3x16(:,:,2281))
  call heltable([8,2,16], n3(:,2719), t3x16(:,:,2282))
  call heltable([2,8,16], n3(:,2720), t3x16(:,:,2283))
  call heltable([2,8,16], n3(:,2721), t3x16(:,:,2284))
  call heltable([2,8,16], n3(:,2722), t3x16(:,:,2285))
  call heltable([2,8,16], n3(:,2723), t3x16(:,:,2286))
  n2(333) = 4
  call heltable([4,2,8], n3(:,2724), t3x8(:,:,386))
  n2(334) = 4
  call heltable([4,2,8], n3(:,2725), t3x8(:,:,387))
  n2(335) = 4
  call heltable([2,4,8], n3(:,2726), t3x8(:,:,388))
  n2(336) = 4
  call heltable([2,4,8], n3(:,2727), t3x8(:,:,389))
  n2(337) = 4
  call heltable([4,2,8], n3(:,2728), t3x8(:,:,390))
  n2(338) = 4
  call heltable([4,2,8], n3(:,2729), t3x8(:,:,391))
  n2(339) = 4
  call heltable([2,4,8], n3(:,2730), t3x8(:,:,392))
  n2(340) = 4
  call heltable([2,4,8], n3(:,2731), t3x8(:,:,393))
  n2(341) = 4
  call heltable([2,4,8], n3(:,2732), t3x8(:,:,394))
  n2(342) = 4
  call heltable([2,4,8], n3(:,2733), t3x8(:,:,395))
  call heltable([4,4,16], n3(:,2734), t3x16(:,:,2287))
  call heltable([4,4,16], n3(:,2735), t3x16(:,:,2288))
  call heltable([4,4,16], n3(:,2736), t3x16(:,:,2289))
  call heltable([4,4,16], n3(:,2737), t3x16(:,:,2290))
  call heltable([4,4,16], n3(:,2738), t3x16(:,:,2291))
  call heltable([4,4,16], n3(:,2739), t3x16(:,:,2292))
  call heltable([4,4,16], n3(:,2740), t3x16(:,:,2293))
  call heltable([4,4,16], n3(:,2741), t3x16(:,:,2294))
  call heltable([4,4,16], n3(:,2742), t3x16(:,:,2295))
  call heltable([4,4,16], n3(:,2743), t3x16(:,:,2296))
  call heltable([4,4,16], n3(:,2744), t3x16(:,:,2297))
  call heltable([4,4,16], n3(:,2745), t3x16(:,:,2298))
  call heltable([4,4,16], n3(:,2746), t3x16(:,:,2299))
  call heltable([4,4,16], n3(:,2747), t3x16(:,:,2300))
  call heltable([4,4,16], n3(:,2748), t3x16(:,:,2301))
  call heltable([4,4,16], n3(:,2749), t3x16(:,:,2302))
  call heltable([4,4,16], n3(:,2750), t3x16(:,:,2303))
  call heltable([4,4,16], n3(:,2751), t3x16(:,:,2304))
  call heltable([4,4,16], n3(:,2752), t3x16(:,:,2305))
  call heltable([4,4,16], n3(:,2753), t3x16(:,:,2306))
  call heltable([4,4,16], n3(:,2754), t3x16(:,:,2307))
  call heltable([4,4,16], n3(:,2755), t3x16(:,:,2308))
  call heltable([4,4,16], n3(:,2756), t3x16(:,:,2309))
  call heltable([4,4,16], n3(:,2757), t3x16(:,:,2310))
  call heltable([4,4,16], n3(:,2758), t3x16(:,:,2311))
  call heltable([4,4,16], n3(:,2759), t3x16(:,:,2312))
  call heltable([4,4,16], n3(:,2760), t3x16(:,:,2313))
  call heltable([4,4,16], n3(:,2761), t3x16(:,:,2314))
  call heltable([4,4,16], n3(:,2762), t3x16(:,:,2315))
  call heltable([4,4,16], n3(:,2763), t3x16(:,:,2316))
  call heltable([4,4,16], n3(:,2764), t3x16(:,:,2317))
  call heltable([4,4,16], n3(:,2765), t3x16(:,:,2318))
  call heltable([4,4,16], n3(:,2766), t3x16(:,:,2319))
  call heltable([4,4,16], n3(:,2767), t3x16(:,:,2320))
  call heltable([4,4,16], n3(:,2768), t3x16(:,:,2321))
  call heltable([4,4,16], n3(:,2769), t3x16(:,:,2322))
  call heltable([4,4,16], n3(:,2770), t3x16(:,:,2323))
  call heltable([4,4,16], n3(:,2771), t3x16(:,:,2324))
  call heltable([4,4,16], n3(:,2772), t3x16(:,:,2325))
  n2(343) = 4
  call heltable([4,2,8], n3(:,2773), t3x8(:,:,396))
  n2(344) = 4
  call heltable([4,2,8], n3(:,2774), t3x8(:,:,397))
  n2(345) = 4
  call heltable([2,4,8], n3(:,2775), t3x8(:,:,398))
  n2(346) = 4
  call heltable([2,4,8], n3(:,2776), t3x8(:,:,399))
  n2(347) = 4
  call heltable([4,2,8], n3(:,2777), t3x8(:,:,400))
  n2(348) = 4
  call heltable([4,2,8], n3(:,2778), t3x8(:,:,401))
  n2(349) = 4
  call heltable([2,4,8], n3(:,2779), t3x8(:,:,402))
  n2(350) = 4
  call heltable([2,4,8], n3(:,2780), t3x8(:,:,403))
  n2(351) = 4
  call heltable([2,4,8], n3(:,2781), t3x8(:,:,404))
  n2(352) = 4
  call heltable([2,4,8], n3(:,2782), t3x8(:,:,405))
  call heltable([4,4,16], n3(:,2783), t3x16(:,:,2326))
  call heltable([4,4,16], n3(:,2784), t3x16(:,:,2327))
  call heltable([4,4,16], n3(:,2785), t3x16(:,:,2328))
  call heltable([4,4,16], n3(:,2786), t3x16(:,:,2329))
  call heltable([4,4,16], n3(:,2787), t3x16(:,:,2330))
  call heltable([4,4,16], n3(:,2788), t3x16(:,:,2331))
  call heltable([4,4,16], n3(:,2789), t3x16(:,:,2332))
  call heltable([4,4,16], n3(:,2790), t3x16(:,:,2333))
  call heltable([4,4,16], n3(:,2791), t3x16(:,:,2334))
  call heltable([4,4,16], n3(:,2792), t3x16(:,:,2335))
  call heltable([4,4,16], n3(:,2793), t3x16(:,:,2336))
  call heltable([4,4,16], n3(:,2794), t3x16(:,:,2337))
  call heltable([4,4,16], n3(:,2795), t3x16(:,:,2338))
  call heltable([4,4,16], n3(:,2796), t3x16(:,:,2339))
  call heltable([4,4,16], n3(:,2797), t3x16(:,:,2340))
  call heltable([4,4,16], n3(:,2798), t3x16(:,:,2341))
  call heltable([4,4,16], n3(:,2799), t3x16(:,:,2342))
  call heltable([4,4,16], n3(:,2800), t3x16(:,:,2343))
  call heltable([4,4,16], n3(:,2801), t3x16(:,:,2344))
  call heltable([4,4,16], n3(:,2802), t3x16(:,:,2345))
  call heltable([4,4,16], n3(:,2803), t3x16(:,:,2346))
  call heltable([4,4,16], n3(:,2804), t3x16(:,:,2347))
  call heltable([4,4,16], n3(:,2805), t3x16(:,:,2348))
  call heltable([4,4,16], n3(:,2806), t3x16(:,:,2349))
  call heltable([4,4,16], n3(:,2807), t3x16(:,:,2350))
  call heltable([4,4,16], n3(:,2808), t3x16(:,:,2351))
  call heltable([4,4,16], n3(:,2809), t3x16(:,:,2352))
  call heltable([4,4,16], n3(:,2810), t3x16(:,:,2353))
  call heltable([4,4,16], n3(:,2811), t3x16(:,:,2354))
  call heltable([4,4,16], n3(:,2812), t3x16(:,:,2355))
  call heltable([4,4,16], n3(:,2813), t3x16(:,:,2356))
  call heltable([4,4,16], n3(:,2814), t3x16(:,:,2357))
  call heltable([4,4,16], n3(:,2815), t3x16(:,:,2358))
  call heltable([4,4,16], n3(:,2816), t3x16(:,:,2359))
  call heltable([4,4,16], n3(:,2817), t3x16(:,:,2360))
  call heltable([4,4,16], n3(:,2818), t3x16(:,:,2361))
  call heltable([4,4,16], n3(:,2819), t3x16(:,:,2362))
  call heltable([4,4,16], n3(:,2820), t3x16(:,:,2363))
  call heltable([4,4,16], n3(:,2821), t3x16(:,:,2364))
  n2(353) = 4
  n2(354) = 4
  call heltable([2,4,8], n3(:,2822), t3x8(:,:,406))
  call heltable([2,4,8], n3(:,2823), t3x8(:,:,407))
  call heltable([4,2,8], n3(:,2824), t3x8(:,:,408))
  call heltable([4,4,16], n3(:,2825), t3x16(:,:,2365))
  call heltable([4,4,16], n3(:,2826), t3x16(:,:,2366))
  call heltable([4,4,16], n3(:,2827), t3x16(:,:,2367))
  call heltable([4,4,16], n3(:,2828), t3x16(:,:,2368))
  call heltable([4,4,16], n3(:,2829), t3x16(:,:,2369))
  call heltable([4,4,16], n3(:,2830), t3x16(:,:,2370))
  call heltable([4,4,16], n3(:,2831), t3x16(:,:,2371))
  call heltable([4,4,16], n3(:,2832), t3x16(:,:,2372))
  n2(355) = 8
  n2(356) = 8
  n2(357) = 8
  n2(358) = 8
  n2(359) = 8
  n2(360) = 8
  n2(361) = 8
  n2(362) = 8
  n2(363) = 8
  n2(364) = 8
  n2(365) = 8
  n2(366) = 8
  n2(367) = 8
  n2(368) = 8
  n2(369) = 8
  call heltable([2,4,8], n3(:,2833), t3x8(:,:,409))
  call heltable([2,4,8], n3(:,2834), t3x8(:,:,410))
  call heltable([4,2,8], n3(:,2835), t3x8(:,:,411))
  call heltable([4,2,8], n3(:,2836), t3x8(:,:,412))
  call heltable([2,4,8], n3(:,2837), t3x8(:,:,413))
  call heltable([2,4,8], n3(:,2838), t3x8(:,:,414))
  call heltable([4,2,8], n3(:,2839), t3x8(:,:,415))
  call heltable([4,2,8], n3(:,2840), t3x8(:,:,416))
  call heltable([4,2,8], n3(:,2841), t3x8(:,:,417))
  call heltable([4,2,8], n3(:,2842), t3x8(:,:,418))
  call heltable([8,4,32], n3(:,2843), t3x32(:,:,1))
  call heltable([8,4,32], n3(:,2844), t3x32(:,:,2))
  call heltable([8,4,32], n3(:,2845), t3x32(:,:,3))
  call heltable([8,4,32], n3(:,2846), t3x32(:,:,4))
  call heltable([8,4,32], n3(:,2847), t3x32(:,:,5))
  call heltable([8,4,32], n3(:,2848), t3x32(:,:,6))
  call heltable([8,4,32], n3(:,2849), t3x32(:,:,7))
  call heltable([8,4,32], n3(:,2850), t3x32(:,:,8))
  call heltable([4,8,32], n3(:,2851), t3x32(:,:,9))
  call heltable([4,8,32], n3(:,2852), t3x32(:,:,10))
  call heltable([4,8,32], n3(:,2853), t3x32(:,:,11))
  call heltable([4,8,32], n3(:,2854), t3x32(:,:,12))
  call heltable([4,8,32], n3(:,2855), t3x32(:,:,13))
  call heltable([4,8,32], n3(:,2856), t3x32(:,:,14))
  call heltable([4,8,32], n3(:,2857), t3x32(:,:,15))
  call heltable([4,8,32], n3(:,2858), t3x32(:,:,16))
  call heltable([8,4,32], n3(:,2859), t3x32(:,:,17))
  call heltable([8,4,32], n3(:,2860), t3x32(:,:,18))
  call heltable([8,4,32], n3(:,2861), t3x32(:,:,19))
  call heltable([8,4,32], n3(:,2862), t3x32(:,:,20))
  call heltable([8,4,32], n3(:,2863), t3x32(:,:,21))
  call heltable([8,4,32], n3(:,2864), t3x32(:,:,22))
  call heltable([8,4,32], n3(:,2865), t3x32(:,:,23))
  call heltable([8,4,32], n3(:,2866), t3x32(:,:,24))
  call heltable([4,8,32], n3(:,2867), t3x32(:,:,25))
  call heltable([4,8,32], n3(:,2868), t3x32(:,:,26))
  call heltable([4,8,32], n3(:,2869), t3x32(:,:,27))
  call heltable([4,8,32], n3(:,2870), t3x32(:,:,28))
  call heltable([4,8,32], n3(:,2871), t3x32(:,:,29))
  call heltable([4,8,32], n3(:,2872), t3x32(:,:,30))
  call heltable([4,8,32], n3(:,2873), t3x32(:,:,31))
  call heltable([4,8,32], n3(:,2874), t3x32(:,:,32))
  call heltable([4,8,32], n3(:,2875), t3x32(:,:,33))
  call heltable([4,8,32], n3(:,2876), t3x32(:,:,34))
  call heltable([4,8,32], n3(:,2877), t3x32(:,:,35))
  call heltable([4,8,32], n3(:,2878), t3x32(:,:,36))
  call heltable([4,8,32], n3(:,2879), t3x32(:,:,37))
  call heltable([4,8,32], n3(:,2880), t3x32(:,:,38))
  call heltable([4,8,32], n3(:,2881), t3x32(:,:,39))
  call heltable([4,8,32], n3(:,2882), t3x32(:,:,40))
  call heltable([2,4,8], n3(:,2883), t3x8(:,:,419))
  call heltable([2,4,8], n3(:,2884), t3x8(:,:,420))
  call heltable([4,2,8], n3(:,2885), t3x8(:,:,421))
  call heltable([4,2,8], n3(:,2886), t3x8(:,:,422))
  call heltable([2,4,8], n3(:,2887), t3x8(:,:,423))
  call heltable([2,4,8], n3(:,2888), t3x8(:,:,424))
  call heltable([4,2,8], n3(:,2889), t3x8(:,:,425))
  call heltable([4,2,8], n3(:,2890), t3x8(:,:,426))
  call heltable([4,2,8], n3(:,2891), t3x8(:,:,427))
  call heltable([4,2,8], n3(:,2892), t3x8(:,:,428))
  call heltable([8,4,32], n3(:,2893), t3x32(:,:,41))
  call heltable([8,4,32], n3(:,2894), t3x32(:,:,42))
  call heltable([8,4,32], n3(:,2895), t3x32(:,:,43))
  call heltable([8,4,32], n3(:,2896), t3x32(:,:,44))
  call heltable([8,4,32], n3(:,2897), t3x32(:,:,45))
  call heltable([8,4,32], n3(:,2898), t3x32(:,:,46))
  call heltable([8,4,32], n3(:,2899), t3x32(:,:,47))
  call heltable([8,4,32], n3(:,2900), t3x32(:,:,48))
  call heltable([4,8,32], n3(:,2901), t3x32(:,:,49))
  call heltable([4,8,32], n3(:,2902), t3x32(:,:,50))
  call heltable([4,8,32], n3(:,2903), t3x32(:,:,51))
  call heltable([4,8,32], n3(:,2904), t3x32(:,:,52))
  call heltable([4,8,32], n3(:,2905), t3x32(:,:,53))
  call heltable([4,8,32], n3(:,2906), t3x32(:,:,54))
  call heltable([4,8,32], n3(:,2907), t3x32(:,:,55))
  call heltable([4,8,32], n3(:,2908), t3x32(:,:,56))
  call heltable([8,4,32], n3(:,2909), t3x32(:,:,57))
  call heltable([8,4,32], n3(:,2910), t3x32(:,:,58))
  call heltable([8,4,32], n3(:,2911), t3x32(:,:,59))
  call heltable([8,4,32], n3(:,2912), t3x32(:,:,60))
  call heltable([8,4,32], n3(:,2913), t3x32(:,:,61))
  call heltable([8,4,32], n3(:,2914), t3x32(:,:,62))
  call heltable([8,4,32], n3(:,2915), t3x32(:,:,63))
  call heltable([8,4,32], n3(:,2916), t3x32(:,:,64))
  call heltable([4,8,32], n3(:,2917), t3x32(:,:,65))
  call heltable([4,8,32], n3(:,2918), t3x32(:,:,66))
  call heltable([4,8,32], n3(:,2919), t3x32(:,:,67))
  call heltable([4,8,32], n3(:,2920), t3x32(:,:,68))
  call heltable([4,8,32], n3(:,2921), t3x32(:,:,69))
  call heltable([4,8,32], n3(:,2922), t3x32(:,:,70))
  call heltable([4,8,32], n3(:,2923), t3x32(:,:,71))
  call heltable([4,8,32], n3(:,2924), t3x32(:,:,72))
  call heltable([4,8,32], n3(:,2925), t3x32(:,:,73))
  call heltable([4,8,32], n3(:,2926), t3x32(:,:,74))
  call heltable([4,8,32], n3(:,2927), t3x32(:,:,75))
  call heltable([4,8,32], n3(:,2928), t3x32(:,:,76))
  call heltable([4,8,32], n3(:,2929), t3x32(:,:,77))
  call heltable([4,8,32], n3(:,2930), t3x32(:,:,78))
  call heltable([4,8,32], n3(:,2931), t3x32(:,:,79))
  call heltable([4,8,32], n3(:,2932), t3x32(:,:,80))
  n2(370) = 4
  n2(371) = 4
  call heltable([4,2,8], n3(:,2933), t3x8(:,:,429))
  call heltable([4,2,8], n3(:,2934), t3x8(:,:,430))
  call heltable([2,4,8], n3(:,2935), t3x8(:,:,431))
  n2(372) = 8
  n2(373) = 8
  n2(374) = 8
  n2(375) = 8
  n2(376) = 8
  n2(377) = 8
  n2(378) = 8
  n2(379) = 8
  n2(380) = 8
  n2(381) = 8
  n2(382) = 8
  n2(383) = 8
  n2(384) = 8
  n2(385) = 8
  n2(386) = 8
  call heltable([4,4,16], n3(:,2936), t3x16(:,:,2373))
  call heltable([4,4,16], n3(:,2937), t3x16(:,:,2374))
  call heltable([4,4,16], n3(:,2938), t3x16(:,:,2375))
  call heltable([4,4,16], n3(:,2939), t3x16(:,:,2376))
  call heltable([4,4,16], n3(:,2940), t3x16(:,:,2377))
  call heltable([4,4,16], n3(:,2941), t3x16(:,:,2378))
  call heltable([4,4,16], n3(:,2942), t3x16(:,:,2379))
  call heltable([4,4,16], n3(:,2943), t3x16(:,:,2380))
  call heltable([8,2,16], n3(:,2944), t3x16(:,:,2381))
  n2(387) = 8
  call heltable([8,2,16], n3(:,2945), t3x16(:,:,2382))
  n2(388) = 8
  call heltable([8,2,16], n3(:,2946), t3x16(:,:,2383))
  call heltable([8,2,16], n3(:,2947), t3x16(:,:,2384))
  n2(389) = 8
  n2(390) = 8
  n2(391) = 8
  n2(392) = 8
  n2(393) = 8
  n2(394) = 8
  n2(395) = 8
  n2(396) = 8
  n2(397) = 8
  n2(398) = 8
  n2(399) = 8
  n2(400) = 8
  n2(401) = 8
  n2(402) = 8
  n2(403) = 8
  n2(404) = 8
  n2(405) = 8
  n2(406) = 8
  call heltable([8,2,16], n3(:,2948), t3x16(:,:,2385))
  n2(407) = 8
  call heltable([8,2,16], n3(:,2949), t3x16(:,:,2386))
  n2(408) = 8
  call heltable([8,2,16], n3(:,2950), t3x16(:,:,2387))
  call heltable([8,2,16], n3(:,2951), t3x16(:,:,2388))
  n2(409) = 8
  n2(410) = 8
  n2(411) = 8
  n2(412) = 8
  n2(413) = 8
  n2(414) = 8
  n2(415) = 8
  n2(416) = 8
  n2(417) = 8
  n2(418) = 8
  n2(419) = 8
  n2(420) = 8
  n2(421) = 8
  n2(422) = 8
  n2(423) = 8
  n2(424) = 8
  n2(425) = 8
  n2(426) = 8
  n2(427) = 16
  n2(428) = 16
  n2(429) = 16
  n2(430) = 16
  n2(431) = 16
  n2(432) = 16
  n2(433) = 16
  n2(434) = 16
  n2(435) = 16
  n2(436) = 16
  n2(437) = 16
  n2(438) = 16
  n2(439) = 16
  n2(440) = 16
  n2(441) = 16
  n2(442) = 16
  call heltable([4,2,8], n3(:,2952), t3x8(:,:,432))
  call heltable([4,2,8], n3(:,2953), t3x8(:,:,433))
  call heltable([2,4,8], n3(:,2954), t3x8(:,:,434))
  call heltable([2,4,8], n3(:,2955), t3x8(:,:,435))
  call heltable([4,2,8], n3(:,2956), t3x8(:,:,436))
  call heltable([4,2,8], n3(:,2957), t3x8(:,:,437))
  call heltable([2,4,8], n3(:,2958), t3x8(:,:,438))
  call heltable([2,4,8], n3(:,2959), t3x8(:,:,439))
  call heltable([2,4,8], n3(:,2960), t3x8(:,:,440))
  call heltable([2,4,8], n3(:,2961), t3x8(:,:,441))
  call heltable([4,8,32], n3(:,2962), t3x32(:,:,81))
  call heltable([4,8,32], n3(:,2963), t3x32(:,:,82))
  call heltable([4,8,32], n3(:,2964), t3x32(:,:,83))
  call heltable([4,8,32], n3(:,2965), t3x32(:,:,84))
  call heltable([8,4,32], n3(:,2966), t3x32(:,:,85))
  call heltable([4,8,32], n3(:,2967), t3x32(:,:,86))
  call heltable([4,8,32], n3(:,2968), t3x32(:,:,87))
  call heltable([8,4,32], n3(:,2969), t3x32(:,:,88))
  call heltable([4,8,32], n3(:,2970), t3x32(:,:,89))
  call heltable([8,4,32], n3(:,2971), t3x32(:,:,90))
  call heltable([4,8,32], n3(:,2972), t3x32(:,:,91))
  call heltable([8,4,32], n3(:,2973), t3x32(:,:,92))
  call heltable([4,8,32], n3(:,2974), t3x32(:,:,93))
  call heltable([4,8,32], n3(:,2975), t3x32(:,:,94))
  call heltable([4,8,32], n3(:,2976), t3x32(:,:,95))
  call heltable([4,8,32], n3(:,2977), t3x32(:,:,96))
  call heltable([4,8,32], n3(:,2978), t3x32(:,:,97))
  call heltable([4,8,32], n3(:,2979), t3x32(:,:,98))
  call heltable([4,8,32], n3(:,2980), t3x32(:,:,99))
  call heltable([8,4,32], n3(:,2981), t3x32(:,:,100))
  call heltable([8,4,32], n3(:,2982), t3x32(:,:,101))
  call heltable([8,4,32], n3(:,2983), t3x32(:,:,102))
  call heltable([4,8,32], n3(:,2984), t3x32(:,:,103))
  call heltable([8,4,32], n3(:,2985), t3x32(:,:,104))
  call heltable([4,8,32], n3(:,2986), t3x32(:,:,105))
  call heltable([8,4,32], n3(:,2987), t3x32(:,:,106))
  call heltable([8,4,32], n3(:,2988), t3x32(:,:,107))
  call heltable([4,8,32], n3(:,2989), t3x32(:,:,108))
  call heltable([4,8,32], n3(:,2990), t3x32(:,:,109))
  call heltable([4,4,16], n3(:,2991), t3x16(:,:,2389))
  call heltable([4,4,16], n3(:,2992), t3x16(:,:,2390))
  call heltable([4,4,16], n3(:,2993), t3x16(:,:,2391))
  call heltable([4,4,16], n3(:,2994), t3x16(:,:,2392))
  call heltable([4,4,16], n3(:,2995), t3x16(:,:,2393))
  call heltable([4,4,16], n3(:,2996), t3x16(:,:,2394))
  call heltable([4,4,16], n3(:,2997), t3x16(:,:,2395))
  call heltable([4,4,16], n3(:,2998), t3x16(:,:,2396))
  call heltable([4,4,16], n3(:,2999), t3x16(:,:,2397))
  call heltable([4,4,16], n3(:,3000), t3x16(:,:,2398))
  n2(443) = 4
  n2(444) = 4
  call heltable([2,4,8], n3(:,3001), t3x8(:,:,442))
  call heltable([2,4,8], n3(:,3002), t3x8(:,:,443))
  call heltable([4,2,8], n3(:,3003), t3x8(:,:,444))
  call heltable([8,4,32], n3(:,3004), t3x32(:,:,110))
  call heltable([8,4,32], n3(:,3005), t3x32(:,:,111))
  call heltable([8,4,32], n3(:,3006), t3x32(:,:,112))
  call heltable([8,4,32], n3(:,3007), t3x32(:,:,113))
  call heltable([4,8,32], n3(:,3008), t3x32(:,:,114))
  call heltable([4,8,32], n3(:,3009), t3x32(:,:,115))
  call heltable([4,8,32], n3(:,3010), t3x32(:,:,116))
  call heltable([4,8,32], n3(:,3011), t3x32(:,:,117))
  call heltable([8,4,32], n3(:,3012), t3x32(:,:,118))
  call heltable([8,4,32], n3(:,3013), t3x32(:,:,119))
  call heltable([8,4,32], n3(:,3014), t3x32(:,:,120))
  call heltable([8,4,32], n3(:,3015), t3x32(:,:,121))
  call heltable([4,8,32], n3(:,3016), t3x32(:,:,122))
  call heltable([4,8,32], n3(:,3017), t3x32(:,:,123))
  call heltable([4,8,32], n3(:,3018), t3x32(:,:,124))
  call heltable([4,8,32], n3(:,3019), t3x32(:,:,125))
  call heltable([4,4,16], n3(:,3020), t3x16(:,:,2399))
  call heltable([4,4,16], n3(:,3021), t3x16(:,:,2400))
  call heltable([4,4,16], n3(:,3022), t3x16(:,:,2401))
  call heltable([4,4,16], n3(:,3023), t3x16(:,:,2402))
  n2(445) = 4
  call heltable([4,2,8], n3(:,3024), t3x8(:,:,445))
  n2(446) = 4
  call heltable([4,2,8], n3(:,3025), t3x8(:,:,446))
  n2(447) = 4
  call heltable([4,2,8], n3(:,3026), t3x8(:,:,447))
  n2(448) = 4
  call heltable([4,2,8], n3(:,3027), t3x8(:,:,448))
  n2(449) = 4
  call heltable([2,4,8], n3(:,3028), t3x8(:,:,449))
  n2(450) = 4
  call heltable([2,4,8], n3(:,3029), t3x8(:,:,450))
  n2(451) = 4
  call heltable([2,4,8], n3(:,3030), t3x8(:,:,451))
  n2(452) = 4
  call heltable([2,4,8], n3(:,3031), t3x8(:,:,452))
  n2(453) = 4
  call heltable([2,4,8], n3(:,3032), t3x8(:,:,453))
  n2(454) = 4
  call heltable([2,4,8], n3(:,3033), t3x8(:,:,454))
  n2(455) = 8
  n2(456) = 8
  n2(457) = 8
  n2(458) = 8
  n2(459) = 8
  n2(460) = 8
  n2(461) = 8
  n2(462) = 8
  n2(463) = 8
  n2(464) = 8
  n2(465) = 8
  n2(466) = 8
  n2(467) = 8
  n2(468) = 8
  n2(469) = 8
  call heltable([4,4,16], n3(:,3034), t3x16(:,:,2403))
  call heltable([4,4,16], n3(:,3035), t3x16(:,:,2404))
  call heltable([4,4,16], n3(:,3036), t3x16(:,:,2405))
  call heltable([4,4,16], n3(:,3037), t3x16(:,:,2406))
  call heltable([4,4,16], n3(:,3038), t3x16(:,:,2407))
  call heltable([4,4,16], n3(:,3039), t3x16(:,:,2408))
  call heltable([4,4,16], n3(:,3040), t3x16(:,:,2409))
  call heltable([4,4,16], n3(:,3041), t3x16(:,:,2410))
  call heltable([4,4,16], n3(:,3042), t3x16(:,:,2411))
  call heltable([4,4,16], n3(:,3043), t3x16(:,:,2412))
  call heltable([4,4,16], n3(:,3044), t3x16(:,:,2413))
  call heltable([4,4,16], n3(:,3045), t3x16(:,:,2414))
  call heltable([4,4,16], n3(:,3046), t3x16(:,:,2415))
  call heltable([4,4,16], n3(:,3047), t3x16(:,:,2416))
  call heltable([4,4,16], n3(:,3048), t3x16(:,:,2417))
  call heltable([4,4,16], n3(:,3049), t3x16(:,:,2418))
  call heltable([4,4,16], n3(:,3050), t3x16(:,:,2419))
  call heltable([4,4,16], n3(:,3051), t3x16(:,:,2420))
  call heltable([4,4,16], n3(:,3052), t3x16(:,:,2421))
  call heltable([4,4,16], n3(:,3053), t3x16(:,:,2422))
  call heltable([4,4,16], n3(:,3054), t3x16(:,:,2423))
  call heltable([4,4,16], n3(:,3055), t3x16(:,:,2424))
  call heltable([4,4,16], n3(:,3056), t3x16(:,:,2425))
  call heltable([4,4,16], n3(:,3057), t3x16(:,:,2426))
  call heltable([4,4,16], n3(:,3058), t3x16(:,:,2427))
  call heltable([4,4,16], n3(:,3059), t3x16(:,:,2428))
  call heltable([4,4,16], n3(:,3060), t3x16(:,:,2429))
  call heltable([4,4,16], n3(:,3061), t3x16(:,:,2430))
  call heltable([4,4,16], n3(:,3062), t3x16(:,:,2431))
  call heltable([4,4,16], n3(:,3063), t3x16(:,:,2432))
  call heltable([4,4,16], n3(:,3064), t3x16(:,:,2433))
  call heltable([4,4,16], n3(:,3065), t3x16(:,:,2434))
  call heltable([4,4,16], n3(:,3066), t3x16(:,:,2435))
  call heltable([4,4,16], n3(:,3067), t3x16(:,:,2436))
  call heltable([4,4,16], n3(:,3068), t3x16(:,:,2437))
  call heltable([4,4,16], n3(:,3069), t3x16(:,:,2438))
  call heltable([4,4,16], n3(:,3070), t3x16(:,:,2439))
  call heltable([4,4,16], n3(:,3071), t3x16(:,:,2440))
  call heltable([4,4,16], n3(:,3072), t3x16(:,:,2441))
  call heltable([2,4,8], n3(:,3073), t3x8(:,:,455))
  call heltable([2,4,8], n3(:,3074), t3x8(:,:,456))
  call heltable([4,2,8], n3(:,3075), t3x8(:,:,457))
  call heltable([4,2,8], n3(:,3076), t3x8(:,:,458))
  call heltable([2,4,8], n3(:,3077), t3x8(:,:,459))
  call heltable([2,4,8], n3(:,3078), t3x8(:,:,460))
  call heltable([4,2,8], n3(:,3079), t3x8(:,:,461))
  call heltable([4,2,8], n3(:,3080), t3x8(:,:,462))
  call heltable([4,2,8], n3(:,3081), t3x8(:,:,463))
  call heltable([4,2,8], n3(:,3082), t3x8(:,:,464))
  call heltable([4,8,32], n3(:,3083), t3x32(:,:,126))
  call heltable([4,8,32], n3(:,3084), t3x32(:,:,127))
  call heltable([4,8,32], n3(:,3085), t3x32(:,:,128))
  call heltable([4,8,32], n3(:,3086), t3x32(:,:,129))
  call heltable([8,4,32], n3(:,3087), t3x32(:,:,130))
  call heltable([4,8,32], n3(:,3088), t3x32(:,:,131))
  call heltable([4,8,32], n3(:,3089), t3x32(:,:,132))
  call heltable([8,4,32], n3(:,3090), t3x32(:,:,133))
  call heltable([4,8,32], n3(:,3091), t3x32(:,:,134))
  call heltable([8,4,32], n3(:,3092), t3x32(:,:,135))
  call heltable([4,8,32], n3(:,3093), t3x32(:,:,136))
  call heltable([8,4,32], n3(:,3094), t3x32(:,:,137))
  call heltable([4,8,32], n3(:,3095), t3x32(:,:,138))
  call heltable([4,8,32], n3(:,3096), t3x32(:,:,139))
  call heltable([4,8,32], n3(:,3097), t3x32(:,:,140))
  call heltable([4,8,32], n3(:,3098), t3x32(:,:,141))
  call heltable([4,8,32], n3(:,3099), t3x32(:,:,142))
  call heltable([4,8,32], n3(:,3100), t3x32(:,:,143))
  call heltable([4,8,32], n3(:,3101), t3x32(:,:,144))
  call heltable([8,4,32], n3(:,3102), t3x32(:,:,145))
  call heltable([8,4,32], n3(:,3103), t3x32(:,:,146))
  call heltable([8,4,32], n3(:,3104), t3x32(:,:,147))
  call heltable([4,8,32], n3(:,3105), t3x32(:,:,148))
  call heltable([8,4,32], n3(:,3106), t3x32(:,:,149))
  call heltable([4,8,32], n3(:,3107), t3x32(:,:,150))
  call heltable([8,4,32], n3(:,3108), t3x32(:,:,151))
  call heltable([8,4,32], n3(:,3109), t3x32(:,:,152))
  call heltable([4,8,32], n3(:,3110), t3x32(:,:,153))
  call heltable([4,8,32], n3(:,3111), t3x32(:,:,154))
  call heltable([8,4,32], n3(:,3112), t3x32(:,:,155))
  call heltable([8,4,32], n3(:,3113), t3x32(:,:,156))
  call heltable([8,4,32], n3(:,3114), t3x32(:,:,157))
  call heltable([8,4,32], n3(:,3115), t3x32(:,:,158))
  call heltable([8,4,32], n3(:,3116), t3x32(:,:,159))
  call heltable([8,4,32], n3(:,3117), t3x32(:,:,160))
  call heltable([8,4,32], n3(:,3118), t3x32(:,:,161))
  call heltable([8,4,32], n3(:,3119), t3x32(:,:,162))
  call heltable([4,8,32], n3(:,3120), t3x32(:,:,163))
  call heltable([4,8,32], n3(:,3121), t3x32(:,:,164))
  call heltable([4,8,32], n3(:,3122), t3x32(:,:,165))
  call heltable([4,8,32], n3(:,3123), t3x32(:,:,166))
  call heltable([4,8,32], n3(:,3124), t3x32(:,:,167))
  call heltable([4,8,32], n3(:,3125), t3x32(:,:,168))
  call heltable([4,8,32], n3(:,3126), t3x32(:,:,169))
  call heltable([4,8,32], n3(:,3127), t3x32(:,:,170))
  call heltable([8,4,32], n3(:,3128), t3x32(:,:,171))
  call heltable([8,4,32], n3(:,3129), t3x32(:,:,172))
  call heltable([8,4,32], n3(:,3130), t3x32(:,:,173))
  call heltable([8,4,32], n3(:,3131), t3x32(:,:,174))
  call heltable([8,4,32], n3(:,3132), t3x32(:,:,175))
  call heltable([8,4,32], n3(:,3133), t3x32(:,:,176))
  call heltable([8,4,32], n3(:,3134), t3x32(:,:,177))
  call heltable([8,4,32], n3(:,3135), t3x32(:,:,178))
  call heltable([4,8,32], n3(:,3136), t3x32(:,:,179))
  call heltable([4,8,32], n3(:,3137), t3x32(:,:,180))
  call heltable([4,8,32], n3(:,3138), t3x32(:,:,181))
  call heltable([4,8,32], n3(:,3139), t3x32(:,:,182))
  call heltable([4,8,32], n3(:,3140), t3x32(:,:,183))
  call heltable([4,8,32], n3(:,3141), t3x32(:,:,184))
  call heltable([4,8,32], n3(:,3142), t3x32(:,:,185))
  call heltable([4,8,32], n3(:,3143), t3x32(:,:,186))
  call heltable([4,8,32], n3(:,3144), t3x32(:,:,187))
  call heltable([4,8,32], n3(:,3145), t3x32(:,:,188))
  call heltable([4,8,32], n3(:,3146), t3x32(:,:,189))
  call heltable([4,8,32], n3(:,3147), t3x32(:,:,190))
  call heltable([4,8,32], n3(:,3148), t3x32(:,:,191))
  call heltable([4,8,32], n3(:,3149), t3x32(:,:,192))
  call heltable([4,8,32], n3(:,3150), t3x32(:,:,193))
  call heltable([4,8,32], n3(:,3151), t3x32(:,:,194))
  n2(470) = 4
  n2(471) = 4
  call heltable([4,2,8], n3(:,3152), t3x8(:,:,465))
  call heltable([4,2,8], n3(:,3153), t3x8(:,:,466))
  call heltable([2,4,8], n3(:,3154), t3x8(:,:,467))
  call heltable([2,4,8], n3(:,3155), t3x8(:,:,468))
  call heltable([2,4,8], n3(:,3156), t3x8(:,:,469))
  call heltable([2,4,8], n3(:,3157), t3x8(:,:,470))
  call heltable([2,4,8], n3(:,3158), t3x8(:,:,471))
  call heltable([4,2,8], n3(:,3159), t3x8(:,:,472))
  call heltable([4,2,8], n3(:,3160), t3x8(:,:,473))
  call heltable([4,2,8], n3(:,3161), t3x8(:,:,474))
  call heltable([4,2,8], n3(:,3162), t3x8(:,:,475))
  call heltable([4,2,8], n3(:,3163), t3x8(:,:,476))
  call heltable([4,2,8], n3(:,3164), t3x8(:,:,477))
  n2(472) = 8
  n2(473) = 8
  n2(474) = 8
  n2(475) = 8
  n2(476) = 8
  n2(477) = 8
  n2(478) = 8
  n2(479) = 8
  n2(480) = 8
  n2(481) = 8
  n2(482) = 8
  n2(483) = 8
  n2(484) = 8
  n2(485) = 8
  n2(486) = 8
  call heltable([4,8,32], n3(:,3165), t3x32(:,:,195))
  call heltable([4,8,32], n3(:,3166), t3x32(:,:,196))
  call heltable([4,8,32], n3(:,3167), t3x32(:,:,197))
  call heltable([4,8,32], n3(:,3168), t3x32(:,:,198))
  call heltable([8,4,32], n3(:,3169), t3x32(:,:,199))
  call heltable([8,4,32], n3(:,3170), t3x32(:,:,200))
  call heltable([8,4,32], n3(:,3171), t3x32(:,:,201))
  call heltable([8,4,32], n3(:,3172), t3x32(:,:,202))
  call heltable([4,8,32], n3(:,3173), t3x32(:,:,203))
  call heltable([4,8,32], n3(:,3174), t3x32(:,:,204))
  call heltable([4,8,32], n3(:,3175), t3x32(:,:,205))
  call heltable([4,8,32], n3(:,3176), t3x32(:,:,206))
  call heltable([8,4,32], n3(:,3177), t3x32(:,:,207))
  call heltable([8,4,32], n3(:,3178), t3x32(:,:,208))
  call heltable([8,4,32], n3(:,3179), t3x32(:,:,209))
  call heltable([8,4,32], n3(:,3180), t3x32(:,:,210))
  call heltable([4,4,16], n3(:,3181), t3x16(:,:,2442))
  call heltable([4,4,16], n3(:,3182), t3x16(:,:,2443))
  call heltable([4,4,16], n3(:,3183), t3x16(:,:,2444))
  call heltable([4,4,16], n3(:,3184), t3x16(:,:,2445))
  call heltable([8,4,32], n3(:,3185), t3x32(:,:,211))
  call heltable([8,4,32], n3(:,3186), t3x32(:,:,212))
  call heltable([8,4,32], n3(:,3187), t3x32(:,:,213))
  call heltable([8,4,32], n3(:,3188), t3x32(:,:,214))
  call heltable([8,4,32], n3(:,3189), t3x32(:,:,215))
  call heltable([8,4,32], n3(:,3190), t3x32(:,:,216))
  call heltable([8,4,32], n3(:,3191), t3x32(:,:,217))
  call heltable([8,4,32], n3(:,3192), t3x32(:,:,218))
  call heltable([4,8,32], n3(:,3193), t3x32(:,:,219))
  call heltable([4,8,32], n3(:,3194), t3x32(:,:,220))
  call heltable([4,8,32], n3(:,3195), t3x32(:,:,221))
  call heltable([4,8,32], n3(:,3196), t3x32(:,:,222))
  call heltable([4,8,32], n3(:,3197), t3x32(:,:,223))
  call heltable([4,8,32], n3(:,3198), t3x32(:,:,224))
  call heltable([4,8,32], n3(:,3199), t3x32(:,:,225))
  call heltable([4,8,32], n3(:,3200), t3x32(:,:,226))
  call heltable([8,4,32], n3(:,3201), t3x32(:,:,227))
  call heltable([8,4,32], n3(:,3202), t3x32(:,:,228))
  call heltable([8,4,32], n3(:,3203), t3x32(:,:,229))
  call heltable([8,4,32], n3(:,3204), t3x32(:,:,230))
  call heltable([8,4,32], n3(:,3205), t3x32(:,:,231))
  call heltable([8,4,32], n3(:,3206), t3x32(:,:,232))
  call heltable([8,4,32], n3(:,3207), t3x32(:,:,233))
  call heltable([8,4,32], n3(:,3208), t3x32(:,:,234))
  call heltable([4,8,32], n3(:,3209), t3x32(:,:,235))
  call heltable([4,8,32], n3(:,3210), t3x32(:,:,236))
  call heltable([4,8,32], n3(:,3211), t3x32(:,:,237))
  call heltable([4,8,32], n3(:,3212), t3x32(:,:,238))
  call heltable([4,8,32], n3(:,3213), t3x32(:,:,239))
  call heltable([4,8,32], n3(:,3214), t3x32(:,:,240))
  call heltable([4,8,32], n3(:,3215), t3x32(:,:,241))
  call heltable([4,8,32], n3(:,3216), t3x32(:,:,242))
  call heltable([4,8,32], n3(:,3217), t3x32(:,:,243))
  call heltable([4,8,32], n3(:,3218), t3x32(:,:,244))
  call heltable([4,8,32], n3(:,3219), t3x32(:,:,245))
  call heltable([4,8,32], n3(:,3220), t3x32(:,:,246))
  call heltable([4,8,32], n3(:,3221), t3x32(:,:,247))
  call heltable([4,8,32], n3(:,3222), t3x32(:,:,248))
  call heltable([4,8,32], n3(:,3223), t3x32(:,:,249))
  call heltable([4,8,32], n3(:,3224), t3x32(:,:,250))
  call heltable([8,2,16], n3(:,3225), t3x16(:,:,2446))
  n2(487) = 8
  call heltable([8,2,16], n3(:,3226), t3x16(:,:,2447))
  n2(488) = 8
  call heltable([8,2,16], n3(:,3227), t3x16(:,:,2448))
  call heltable([8,2,16], n3(:,3228), t3x16(:,:,2449))
  n2(489) = 8
  n2(490) = 8
  n2(491) = 8
  n2(492) = 8
  n2(493) = 8
  n2(494) = 8
  n2(495) = 8
  n2(496) = 8
  n2(497) = 8
  n2(498) = 8
  n2(499) = 8
  n2(500) = 8
  n2(501) = 8
  n2(502) = 8
  n2(503) = 8
  n2(504) = 8
  n2(505) = 8
  n2(506) = 8
  call heltable([8,2,16], n3(:,3229), t3x16(:,:,2450))
  n2(507) = 8
  call heltable([8,2,16], n3(:,3230), t3x16(:,:,2451))
  n2(508) = 8
  call heltable([8,2,16], n3(:,3231), t3x16(:,:,2452))
  call heltable([8,2,16], n3(:,3232), t3x16(:,:,2453))
  n2(509) = 8
  n2(510) = 8
  n2(511) = 8
  n2(512) = 8
  n2(513) = 8
  n2(514) = 8
  n2(515) = 8
  n2(516) = 8
  n2(517) = 16
  n2(518) = 16
  n2(519) = 16
  n2(520) = 16
  n2(521) = 16
  n2(522) = 16
  n2(523) = 16
  n2(524) = 16
  n2(525) = 8
  n2(526) = 8
  n2(527) = 8
  n2(528) = 8
  n2(529) = 8
  n2(530) = 8
  n2(531) = 8
  n2(532) = 8
  n2(533) = 8
  n2(534) = 8
  n2(535) = 16
  n2(536) = 16
  n2(537) = 16
  n2(538) = 16
  n2(539) = 16
  n2(540) = 16
  n2(541) = 16
  n2(542) = 16
  n2(543) = 16
  n2(544) = 16
  n2(545) = 16
  n2(546) = 16
  call heltable([4,2,8], n3(:,3233), t3x8(:,:,478))
  n2(547) = 8
  n2(548) = 8
  n2(549) = 8
  n2(550) = 16
  n2(551) = 16
  n2(552) = 16
  n2(553) = 16
  n2(554) = 16
  n2(555) = 16
  n2(556) = 16
  n2(557) = 16
  call heltable([2,4,8], n3(:,3234), t3x8(:,:,479))
  n2(558) = 8
  n2(559) = 8
  n2(560) = 8
  n2(561) = 16
  n2(562) = 16
  n2(563) = 16
  n2(564) = 16
  call heltable([8,2,16], n3(:,3235), t3x16(:,:,2454))
  call heltable([8,2,16], n3(:,3236), t3x16(:,:,2455))
  call heltable([2,8,16], n3(:,3237), t3x16(:,:,2456))
  call heltable([2,8,16], n3(:,3238), t3x16(:,:,2457))
  call heltable([2,8,16], n3(:,3239), t3x16(:,:,2458))
  n2(565) = 16
  call heltable([2,8,16], n3(:,3240), t3x16(:,:,2459))
  n2(566) = 16
  call heltable([8,2,16], n3(:,3241), t3x16(:,:,2460))
  n2(567) = 16
  call heltable([8,2,16], n3(:,3242), t3x16(:,:,2461))
  n2(568) = 16
  n2(569) = 16
  n2(570) = 16
  n2(571) = 16
  n2(572) = 16
  n2(573) = 8
  n2(574) = 8
  n2(575) = 8
  call heltable([4,2,8], n3(:,3243), t3x8(:,:,480))
  call heltable([8,2,16], n3(:,3244), t3x16(:,:,2462))
  call heltable([8,2,16], n3(:,3245), t3x16(:,:,2463))
  call heltable([2,8,16], n3(:,3246), t3x16(:,:,2464))
  call heltable([2,8,16], n3(:,3247), t3x16(:,:,2465))
  call heltable([2,8,16], n3(:,3248), t3x16(:,:,2466))
  n2(576) = 16
  call heltable([2,8,16], n3(:,3249), t3x16(:,:,2467))
  n2(577) = 16
  call heltable([8,2,16], n3(:,3250), t3x16(:,:,2468))
  n2(578) = 16
  call heltable([8,2,16], n3(:,3251), t3x16(:,:,2469))
  n2(579) = 16
  n2(580) = 16
  n2(581) = 16
  n2(582) = 16
  n2(583) = 16
  n2(584) = 8
  n2(585) = 8
  n2(586) = 8
  call heltable([2,4,8], n3(:,3252), t3x8(:,:,481))
  n2(587) = 4
  call heltable([4,2,8], n3(:,3253), t3x8(:,:,482))
  n2(588) = 4
  call heltable([4,2,8], n3(:,3254), t3x8(:,:,483))
  n2(589) = 4
  call heltable([2,4,8], n3(:,3255), t3x8(:,:,484))
  n2(590) = 4
  call heltable([2,4,8], n3(:,3256), t3x8(:,:,485))
  n2(591) = 4
  call heltable([4,2,8], n3(:,3257), t3x8(:,:,486))
  n2(592) = 4
  call heltable([4,2,8], n3(:,3258), t3x8(:,:,487))
  n2(593) = 4
  call heltable([2,4,8], n3(:,3259), t3x8(:,:,488))
  n2(594) = 4
  call heltable([2,4,8], n3(:,3260), t3x8(:,:,489))
  n2(595) = 4
  call heltable([2,4,8], n3(:,3261), t3x8(:,:,490))
  n2(596) = 4
  call heltable([2,4,8], n3(:,3262), t3x8(:,:,491))
  call heltable([4,4,16], n3(:,3263), t3x16(:,:,2470))
  call heltable([4,4,16], n3(:,3264), t3x16(:,:,2471))
  call heltable([4,4,16], n3(:,3265), t3x16(:,:,2472))
  call heltable([4,4,16], n3(:,3266), t3x16(:,:,2473))
  call heltable([4,4,16], n3(:,3267), t3x16(:,:,2474))
  call heltable([4,4,16], n3(:,3268), t3x16(:,:,2475))
  call heltable([4,4,16], n3(:,3269), t3x16(:,:,2476))
  call heltable([4,4,16], n3(:,3270), t3x16(:,:,2477))
  call heltable([4,4,16], n3(:,3271), t3x16(:,:,2478))
  call heltable([4,4,16], n3(:,3272), t3x16(:,:,2479))
  call heltable([4,4,16], n3(:,3273), t3x16(:,:,2480))
  call heltable([4,4,16], n3(:,3274), t3x16(:,:,2481))
  call heltable([4,4,16], n3(:,3275), t3x16(:,:,2482))
  call heltable([4,4,16], n3(:,3276), t3x16(:,:,2483))
  call heltable([4,4,16], n3(:,3277), t3x16(:,:,2484))
  call heltable([4,4,16], n3(:,3278), t3x16(:,:,2485))
  call heltable([4,4,16], n3(:,3279), t3x16(:,:,2486))
  call heltable([4,4,16], n3(:,3280), t3x16(:,:,2487))
  call heltable([4,4,16], n3(:,3281), t3x16(:,:,2488))
  call heltable([4,4,16], n3(:,3282), t3x16(:,:,2489))
  call heltable([4,4,16], n3(:,3283), t3x16(:,:,2490))
  call heltable([4,4,16], n3(:,3284), t3x16(:,:,2491))
  call heltable([4,4,16], n3(:,3285), t3x16(:,:,2492))
  call heltable([4,4,16], n3(:,3286), t3x16(:,:,2493))
  call heltable([4,4,16], n3(:,3287), t3x16(:,:,2494))
  call heltable([4,4,16], n3(:,3288), t3x16(:,:,2495))
  call heltable([4,4,16], n3(:,3289), t3x16(:,:,2496))
  call heltable([4,4,16], n3(:,3290), t3x16(:,:,2497))
  call heltable([4,4,16], n3(:,3291), t3x16(:,:,2498))
  call heltable([4,4,16], n3(:,3292), t3x16(:,:,2499))
  call heltable([4,4,16], n3(:,3293), t3x16(:,:,2500))
  call heltable([4,4,16], n3(:,3294), t3x16(:,:,2501))
  call heltable([4,4,16], n3(:,3295), t3x16(:,:,2502))
  call heltable([4,4,16], n3(:,3296), t3x16(:,:,2503))
  call heltable([4,4,16], n3(:,3297), t3x16(:,:,2504))
  call heltable([4,4,16], n3(:,3298), t3x16(:,:,2505))
  call heltable([4,4,16], n3(:,3299), t3x16(:,:,2506))
  call heltable([4,4,16], n3(:,3300), t3x16(:,:,2507))
  call heltable([4,4,16], n3(:,3301), t3x16(:,:,2508))
  n2(597) = 4
  call heltable([4,2,8], n3(:,3302), t3x8(:,:,492))
  n2(598) = 4
  call heltable([4,2,8], n3(:,3303), t3x8(:,:,493))
  n2(599) = 4
  call heltable([2,4,8], n3(:,3304), t3x8(:,:,494))
  n2(600) = 4
  call heltable([2,4,8], n3(:,3305), t3x8(:,:,495))
  n2(601) = 4
  call heltable([4,2,8], n3(:,3306), t3x8(:,:,496))
  n2(602) = 4
  call heltable([4,2,8], n3(:,3307), t3x8(:,:,497))
  n2(603) = 4
  call heltable([2,4,8], n3(:,3308), t3x8(:,:,498))
  n2(604) = 4
  call heltable([2,4,8], n3(:,3309), t3x8(:,:,499))
  n2(605) = 4
  call heltable([2,4,8], n3(:,3310), t3x8(:,:,500))
  n2(606) = 4
  call heltable([2,4,8], n3(:,3311), t3x8(:,:,501))
  call heltable([4,4,16], n3(:,3312), t3x16(:,:,2509))
  call heltable([4,4,16], n3(:,3313), t3x16(:,:,2510))
  call heltable([4,4,16], n3(:,3314), t3x16(:,:,2511))
  call heltable([4,4,16], n3(:,3315), t3x16(:,:,2512))
  call heltable([4,4,16], n3(:,3316), t3x16(:,:,2513))
  call heltable([4,4,16], n3(:,3317), t3x16(:,:,2514))
  call heltable([4,4,16], n3(:,3318), t3x16(:,:,2515))
  call heltable([4,4,16], n3(:,3319), t3x16(:,:,2516))
  call heltable([4,4,16], n3(:,3320), t3x16(:,:,2517))
  call heltable([4,4,16], n3(:,3321), t3x16(:,:,2518))
  call heltable([4,4,16], n3(:,3322), t3x16(:,:,2519))
  call heltable([4,4,16], n3(:,3323), t3x16(:,:,2520))
  call heltable([4,4,16], n3(:,3324), t3x16(:,:,2521))
  call heltable([4,4,16], n3(:,3325), t3x16(:,:,2522))
  call heltable([4,4,16], n3(:,3326), t3x16(:,:,2523))
  call heltable([4,4,16], n3(:,3327), t3x16(:,:,2524))
  call heltable([4,4,16], n3(:,3328), t3x16(:,:,2525))
  call heltable([4,4,16], n3(:,3329), t3x16(:,:,2526))
  call heltable([4,4,16], n3(:,3330), t3x16(:,:,2527))
  call heltable([4,4,16], n3(:,3331), t3x16(:,:,2528))
  call heltable([4,4,16], n3(:,3332), t3x16(:,:,2529))
  call heltable([4,4,16], n3(:,3333), t3x16(:,:,2530))
  call heltable([4,4,16], n3(:,3334), t3x16(:,:,2531))
  call heltable([4,4,16], n3(:,3335), t3x16(:,:,2532))
  call heltable([4,4,16], n3(:,3336), t3x16(:,:,2533))
  call heltable([4,4,16], n3(:,3337), t3x16(:,:,2534))
  call heltable([4,4,16], n3(:,3338), t3x16(:,:,2535))
  call heltable([4,4,16], n3(:,3339), t3x16(:,:,2536))
  call heltable([4,4,16], n3(:,3340), t3x16(:,:,2537))
  call heltable([4,4,16], n3(:,3341), t3x16(:,:,2538))
  call heltable([4,4,16], n3(:,3342), t3x16(:,:,2539))
  call heltable([4,4,16], n3(:,3343), t3x16(:,:,2540))
  call heltable([4,4,16], n3(:,3344), t3x16(:,:,2541))
  call heltable([4,4,16], n3(:,3345), t3x16(:,:,2542))
  call heltable([4,4,16], n3(:,3346), t3x16(:,:,2543))
  call heltable([4,4,16], n3(:,3347), t3x16(:,:,2544))
  call heltable([4,4,16], n3(:,3348), t3x16(:,:,2545))
  call heltable([4,4,16], n3(:,3349), t3x16(:,:,2546))
  call heltable([4,4,16], n3(:,3350), t3x16(:,:,2547))
  call heltable([4,4,16], n3(:,3351), t3x16(:,:,2548))
  call heltable([4,4,16], n3(:,3352), t3x16(:,:,2549))
  call heltable([4,4,16], n3(:,3353), t3x16(:,:,2550))
  call heltable([4,4,16], n3(:,3354), t3x16(:,:,2551))
  call heltable([4,4,16], n3(:,3355), t3x16(:,:,2552))
  call heltable([4,4,16], n3(:,3356), t3x16(:,:,2553))
  call heltable([4,4,16], n3(:,3357), t3x16(:,:,2554))
  call heltable([4,4,16], n3(:,3358), t3x16(:,:,2555))
  n2(607) = 8
  n2(608) = 8
  n2(609) = 8
  n2(610) = 8
  n2(611) = 8
  n2(612) = 8
  n2(613) = 8
  n2(614) = 8
  call heltable([2,4,8], n3(:,3359), t3x8(:,:,502))
  call heltable([2,4,8], n3(:,3360), t3x8(:,:,503))
  call heltable([4,2,8], n3(:,3361), t3x8(:,:,504))
  call heltable([4,2,8], n3(:,3362), t3x8(:,:,505))
  call heltable([2,4,8], n3(:,3363), t3x8(:,:,506))
  call heltable([2,4,8], n3(:,3364), t3x8(:,:,507))
  call heltable([4,2,8], n3(:,3365), t3x8(:,:,508))
  call heltable([4,2,8], n3(:,3366), t3x8(:,:,509))
  call heltable([4,2,8], n3(:,3367), t3x8(:,:,510))
  call heltable([4,2,8], n3(:,3368), t3x8(:,:,511))
  call heltable([8,4,32], n3(:,3369), t3x32(:,:,251))
  call heltable([8,4,32], n3(:,3370), t3x32(:,:,252))
  call heltable([8,4,32], n3(:,3371), t3x32(:,:,253))
  call heltable([8,4,32], n3(:,3372), t3x32(:,:,254))
  call heltable([8,4,32], n3(:,3373), t3x32(:,:,255))
  call heltable([8,4,32], n3(:,3374), t3x32(:,:,256))
  call heltable([8,4,32], n3(:,3375), t3x32(:,:,257))
  call heltable([8,4,32], n3(:,3376), t3x32(:,:,258))
  call heltable([4,8,32], n3(:,3377), t3x32(:,:,259))
  call heltable([4,8,32], n3(:,3378), t3x32(:,:,260))
  call heltable([4,8,32], n3(:,3379), t3x32(:,:,261))
  call heltable([4,8,32], n3(:,3380), t3x32(:,:,262))
  call heltable([4,8,32], n3(:,3381), t3x32(:,:,263))
  call heltable([4,8,32], n3(:,3382), t3x32(:,:,264))
  call heltable([4,8,32], n3(:,3383), t3x32(:,:,265))
  call heltable([4,8,32], n3(:,3384), t3x32(:,:,266))
  call heltable([8,4,32], n3(:,3385), t3x32(:,:,267))
  call heltable([8,4,32], n3(:,3386), t3x32(:,:,268))
  call heltable([8,4,32], n3(:,3387), t3x32(:,:,269))
  call heltable([8,4,32], n3(:,3388), t3x32(:,:,270))
  call heltable([8,4,32], n3(:,3389), t3x32(:,:,271))
  call heltable([8,4,32], n3(:,3390), t3x32(:,:,272))
  call heltable([8,4,32], n3(:,3391), t3x32(:,:,273))
  call heltable([8,4,32], n3(:,3392), t3x32(:,:,274))
  call heltable([4,8,32], n3(:,3393), t3x32(:,:,275))
  call heltable([4,8,32], n3(:,3394), t3x32(:,:,276))
  call heltable([4,8,32], n3(:,3395), t3x32(:,:,277))
  call heltable([4,8,32], n3(:,3396), t3x32(:,:,278))
  call heltable([4,8,32], n3(:,3397), t3x32(:,:,279))
  call heltable([4,8,32], n3(:,3398), t3x32(:,:,280))
  call heltable([4,8,32], n3(:,3399), t3x32(:,:,281))
  call heltable([4,8,32], n3(:,3400), t3x32(:,:,282))
  call heltable([4,8,32], n3(:,3401), t3x32(:,:,283))
  call heltable([4,8,32], n3(:,3402), t3x32(:,:,284))
  call heltable([4,8,32], n3(:,3403), t3x32(:,:,285))
  call heltable([4,8,32], n3(:,3404), t3x32(:,:,286))
  call heltable([4,8,32], n3(:,3405), t3x32(:,:,287))
  call heltable([4,8,32], n3(:,3406), t3x32(:,:,288))
  call heltable([4,8,32], n3(:,3407), t3x32(:,:,289))
  call heltable([4,8,32], n3(:,3408), t3x32(:,:,290))
  call heltable([2,4,8], n3(:,3409), t3x8(:,:,512))
  call heltable([2,4,8], n3(:,3410), t3x8(:,:,513))
  call heltable([4,2,8], n3(:,3411), t3x8(:,:,514))
  call heltable([4,2,8], n3(:,3412), t3x8(:,:,515))
  call heltable([2,4,8], n3(:,3413), t3x8(:,:,516))
  call heltable([2,4,8], n3(:,3414), t3x8(:,:,517))
  call heltable([4,2,8], n3(:,3415), t3x8(:,:,518))
  call heltable([4,2,8], n3(:,3416), t3x8(:,:,519))
  call heltable([4,2,8], n3(:,3417), t3x8(:,:,520))
  call heltable([4,2,8], n3(:,3418), t3x8(:,:,521))
  call heltable([8,4,32], n3(:,3419), t3x32(:,:,291))
  call heltable([8,4,32], n3(:,3420), t3x32(:,:,292))
  call heltable([8,4,32], n3(:,3421), t3x32(:,:,293))
  call heltable([8,4,32], n3(:,3422), t3x32(:,:,294))
  call heltable([8,4,32], n3(:,3423), t3x32(:,:,295))
  call heltable([8,4,32], n3(:,3424), t3x32(:,:,296))
  call heltable([8,4,32], n3(:,3425), t3x32(:,:,297))
  call heltable([8,4,32], n3(:,3426), t3x32(:,:,298))
  call heltable([4,8,32], n3(:,3427), t3x32(:,:,299))
  call heltable([4,8,32], n3(:,3428), t3x32(:,:,300))
  call heltable([4,8,32], n3(:,3429), t3x32(:,:,301))
  call heltable([4,8,32], n3(:,3430), t3x32(:,:,302))
  call heltable([4,8,32], n3(:,3431), t3x32(:,:,303))
  call heltable([4,8,32], n3(:,3432), t3x32(:,:,304))
  call heltable([4,8,32], n3(:,3433), t3x32(:,:,305))
  call heltable([4,8,32], n3(:,3434), t3x32(:,:,306))
  call heltable([8,4,32], n3(:,3435), t3x32(:,:,307))
  call heltable([8,4,32], n3(:,3436), t3x32(:,:,308))
  call heltable([8,4,32], n3(:,3437), t3x32(:,:,309))
  call heltable([8,4,32], n3(:,3438), t3x32(:,:,310))
  call heltable([8,4,32], n3(:,3439), t3x32(:,:,311))
  call heltable([8,4,32], n3(:,3440), t3x32(:,:,312))
  call heltable([8,4,32], n3(:,3441), t3x32(:,:,313))
  call heltable([8,4,32], n3(:,3442), t3x32(:,:,314))
  call heltable([4,8,32], n3(:,3443), t3x32(:,:,315))
  call heltable([4,8,32], n3(:,3444), t3x32(:,:,316))
  call heltable([4,8,32], n3(:,3445), t3x32(:,:,317))
  call heltable([4,8,32], n3(:,3446), t3x32(:,:,318))
  call heltable([4,8,32], n3(:,3447), t3x32(:,:,319))
  call heltable([4,8,32], n3(:,3448), t3x32(:,:,320))
  call heltable([4,8,32], n3(:,3449), t3x32(:,:,321))
  call heltable([4,8,32], n3(:,3450), t3x32(:,:,322))
  call heltable([4,8,32], n3(:,3451), t3x32(:,:,323))
  call heltable([4,8,32], n3(:,3452), t3x32(:,:,324))
  call heltable([4,8,32], n3(:,3453), t3x32(:,:,325))
  call heltable([4,8,32], n3(:,3454), t3x32(:,:,326))
  call heltable([4,8,32], n3(:,3455), t3x32(:,:,327))
  call heltable([4,8,32], n3(:,3456), t3x32(:,:,328))
  call heltable([4,8,32], n3(:,3457), t3x32(:,:,329))
  call heltable([4,8,32], n3(:,3458), t3x32(:,:,330))
  n2(615) = 8
  n2(616) = 8
  n2(617) = 8
  n2(618) = 8
  n2(619) = 8
  n2(620) = 8
  n2(621) = 8
  n2(622) = 8
  call heltable([4,4,16], n3(:,3459), t3x16(:,:,2556))
  call heltable([4,4,16], n3(:,3460), t3x16(:,:,2557))
  call heltable([4,4,16], n3(:,3461), t3x16(:,:,2558))
  call heltable([4,4,16], n3(:,3462), t3x16(:,:,2559))
  call heltable([4,4,16], n3(:,3463), t3x16(:,:,2560))
  call heltable([4,4,16], n3(:,3464), t3x16(:,:,2561))
  call heltable([4,4,16], n3(:,3465), t3x16(:,:,2562))
  call heltable([4,4,16], n3(:,3466), t3x16(:,:,2563))
  call heltable([8,2,16], n3(:,3467), t3x16(:,:,2564))
  n2(623) = 8
  call heltable([8,2,16], n3(:,3468), t3x16(:,:,2565))
  n2(624) = 8
  call heltable([8,2,16], n3(:,3469), t3x16(:,:,2566))
  call heltable([8,2,16], n3(:,3470), t3x16(:,:,2567))
  n2(625) = 8
  n2(626) = 8
  n2(627) = 8
  n2(628) = 8
  n2(629) = 8
  n2(630) = 8
  n2(631) = 8
  n2(632) = 8
  n2(633) = 8
  n2(634) = 8
  n2(635) = 8
  n2(636) = 8
  n2(637) = 8
  n2(638) = 8
  n2(639) = 8
  n2(640) = 8
  n2(641) = 8
  n2(642) = 8
  call heltable([8,2,16], n3(:,3471), t3x16(:,:,2568))
  n2(643) = 8
  call heltable([8,2,16], n3(:,3472), t3x16(:,:,2569))
  n2(644) = 8
  call heltable([8,2,16], n3(:,3473), t3x16(:,:,2570))
  call heltable([8,2,16], n3(:,3474), t3x16(:,:,2571))
  n2(645) = 8
  n2(646) = 8
  n2(647) = 8
  n2(648) = 8
  n2(649) = 8
  n2(650) = 8
  n2(651) = 8
  n2(652) = 8
  n2(653) = 8
  n2(654) = 8
  n2(655) = 8
  n2(656) = 8
  n2(657) = 8
  n2(658) = 8
  n2(659) = 8
  n2(660) = 8
  n2(661) = 8
  n2(662) = 8
  n2(663) = 16
  n2(664) = 16
  n2(665) = 16
  n2(666) = 16
  n2(667) = 16
  n2(668) = 16
  n2(669) = 16
  n2(670) = 16
  n2(671) = 16
  n2(672) = 16
  n2(673) = 16
  n2(674) = 16
  n2(675) = 16
  n2(676) = 16
  n2(677) = 16
  n2(678) = 16
  n2(679) = 4
  n2(680) = 4
  call heltable([2,4,8], n3(:,3475), t3x8(:,:,522))
  call heltable([2,4,8], n3(:,3476), t3x8(:,:,523))
  call heltable([4,2,8], n3(:,3477), t3x8(:,:,524))
  call heltable([8,4,32], n3(:,3478), t3x32(:,:,331))
  call heltable([8,4,32], n3(:,3479), t3x32(:,:,332))
  call heltable([8,4,32], n3(:,3480), t3x32(:,:,333))
  call heltable([8,4,32], n3(:,3481), t3x32(:,:,334))
  call heltable([4,8,32], n3(:,3482), t3x32(:,:,335))
  call heltable([4,8,32], n3(:,3483), t3x32(:,:,336))
  call heltable([4,8,32], n3(:,3484), t3x32(:,:,337))
  call heltable([4,8,32], n3(:,3485), t3x32(:,:,338))
  call heltable([8,4,32], n3(:,3486), t3x32(:,:,339))
  call heltable([8,4,32], n3(:,3487), t3x32(:,:,340))
  call heltable([8,4,32], n3(:,3488), t3x32(:,:,341))
  call heltable([8,4,32], n3(:,3489), t3x32(:,:,342))
  call heltable([4,8,32], n3(:,3490), t3x32(:,:,343))
  call heltable([4,8,32], n3(:,3491), t3x32(:,:,344))
  call heltable([4,8,32], n3(:,3492), t3x32(:,:,345))
  call heltable([4,8,32], n3(:,3493), t3x32(:,:,346))
  call heltable([4,4,16], n3(:,3494), t3x16(:,:,2572))
  call heltable([4,4,16], n3(:,3495), t3x16(:,:,2573))
  call heltable([4,4,16], n3(:,3496), t3x16(:,:,2574))
  call heltable([4,4,16], n3(:,3497), t3x16(:,:,2575))
  call heltable([4,2,8], n3(:,3498), t3x8(:,:,525))
  call heltable([4,2,8], n3(:,3499), t3x8(:,:,526))
  call heltable([2,4,8], n3(:,3500), t3x8(:,:,527))
  call heltable([2,4,8], n3(:,3501), t3x8(:,:,528))
  call heltable([4,2,8], n3(:,3502), t3x8(:,:,529))
  call heltable([4,2,8], n3(:,3503), t3x8(:,:,530))
  call heltable([2,4,8], n3(:,3504), t3x8(:,:,531))
  call heltable([2,4,8], n3(:,3505), t3x8(:,:,532))
  call heltable([2,4,8], n3(:,3506), t3x8(:,:,533))
  call heltable([2,4,8], n3(:,3507), t3x8(:,:,534))
  call heltable([4,8,32], n3(:,3508), t3x32(:,:,347))
  call heltable([4,8,32], n3(:,3509), t3x32(:,:,348))
  call heltable([4,8,32], n3(:,3510), t3x32(:,:,349))
  call heltable([4,8,32], n3(:,3511), t3x32(:,:,350))
  call heltable([8,4,32], n3(:,3512), t3x32(:,:,351))
  call heltable([4,8,32], n3(:,3513), t3x32(:,:,352))
  call heltable([4,8,32], n3(:,3514), t3x32(:,:,353))
  call heltable([8,4,32], n3(:,3515), t3x32(:,:,354))
  call heltable([4,8,32], n3(:,3516), t3x32(:,:,355))
  call heltable([8,4,32], n3(:,3517), t3x32(:,:,356))
  call heltable([4,8,32], n3(:,3518), t3x32(:,:,357))
  call heltable([8,4,32], n3(:,3519), t3x32(:,:,358))
  call heltable([4,8,32], n3(:,3520), t3x32(:,:,359))
  call heltable([4,8,32], n3(:,3521), t3x32(:,:,360))
  call heltable([4,8,32], n3(:,3522), t3x32(:,:,361))
  call heltable([4,8,32], n3(:,3523), t3x32(:,:,362))
  call heltable([4,8,32], n3(:,3524), t3x32(:,:,363))
  call heltable([4,8,32], n3(:,3525), t3x32(:,:,364))
  call heltable([4,8,32], n3(:,3526), t3x32(:,:,365))
  call heltable([8,4,32], n3(:,3527), t3x32(:,:,366))
  call heltable([8,4,32], n3(:,3528), t3x32(:,:,367))
  call heltable([8,4,32], n3(:,3529), t3x32(:,:,368))
  call heltable([4,8,32], n3(:,3530), t3x32(:,:,369))
  call heltable([8,4,32], n3(:,3531), t3x32(:,:,370))
  call heltable([4,8,32], n3(:,3532), t3x32(:,:,371))
  call heltable([8,4,32], n3(:,3533), t3x32(:,:,372))
  call heltable([8,4,32], n3(:,3534), t3x32(:,:,373))
  call heltable([4,8,32], n3(:,3535), t3x32(:,:,374))
  call heltable([4,8,32], n3(:,3536), t3x32(:,:,375))
  call heltable([4,4,16], n3(:,3537), t3x16(:,:,2576))
  call heltable([4,4,16], n3(:,3538), t3x16(:,:,2577))
  call heltable([4,4,16], n3(:,3539), t3x16(:,:,2578))
  call heltable([4,4,16], n3(:,3540), t3x16(:,:,2579))
  call heltable([4,4,16], n3(:,3541), t3x16(:,:,2580))
  call heltable([4,4,16], n3(:,3542), t3x16(:,:,2581))
  call heltable([4,4,16], n3(:,3543), t3x16(:,:,2582))
  call heltable([4,4,16], n3(:,3544), t3x16(:,:,2583))
  call heltable([4,4,16], n3(:,3545), t3x16(:,:,2584))
  call heltable([4,4,16], n3(:,3546), t3x16(:,:,2585))
  n2(681) = 8
  n2(682) = 8
  n2(683) = 8
  n2(684) = 8
  n2(685) = 8
  n2(686) = 8
  n2(687) = 8
  n2(688) = 8
  n2(689) = 8
  n2(690) = 8
  n2(691) = 8
  call heltable([4,4,16], n3(:,3547), t3x16(:,:,2586))
  call heltable([4,4,16], n3(:,3548), t3x16(:,:,2587))
  call heltable([4,4,16], n3(:,3549), t3x16(:,:,2588))
  call heltable([4,4,16], n3(:,3550), t3x16(:,:,2589))
  call heltable([4,4,16], n3(:,3551), t3x16(:,:,2590))
  call heltable([4,4,16], n3(:,3552), t3x16(:,:,2591))
  call heltable([4,4,16], n3(:,3553), t3x16(:,:,2592))
  call heltable([4,4,16], n3(:,3554), t3x16(:,:,2593))
  call heltable([4,4,16], n3(:,3555), t3x16(:,:,2594))
  call heltable([4,4,16], n3(:,3556), t3x16(:,:,2595))
  call heltable([4,4,16], n3(:,3557), t3x16(:,:,2596))
  call heltable([4,4,16], n3(:,3558), t3x16(:,:,2597))
  call heltable([4,4,16], n3(:,3559), t3x16(:,:,2598))
  call heltable([4,4,16], n3(:,3560), t3x16(:,:,2599))
  call heltable([4,4,16], n3(:,3561), t3x16(:,:,2600))
  call heltable([4,4,16], n3(:,3562), t3x16(:,:,2601))
  call heltable([4,4,16], n3(:,3563), t3x16(:,:,2602))
  call heltable([4,4,16], n3(:,3564), t3x16(:,:,2603))
  call heltable([4,4,16], n3(:,3565), t3x16(:,:,2604))
  call heltable([4,4,16], n3(:,3566), t3x16(:,:,2605))
  call heltable([4,4,16], n3(:,3567), t3x16(:,:,2606))
  call heltable([4,4,16], n3(:,3568), t3x16(:,:,2607))
  call heltable([4,4,16], n3(:,3569), t3x16(:,:,2608))
  call heltable([4,4,16], n3(:,3570), t3x16(:,:,2609))
  call heltable([4,4,16], n3(:,3571), t3x16(:,:,2610))
  call heltable([4,4,16], n3(:,3572), t3x16(:,:,2611))
  call heltable([4,4,16], n3(:,3573), t3x16(:,:,2612))
  call heltable([4,4,16], n3(:,3574), t3x16(:,:,2613))
  call heltable([4,4,16], n3(:,3575), t3x16(:,:,2614))
  call heltable([4,4,16], n3(:,3576), t3x16(:,:,2615))
  call heltable([4,4,16], n3(:,3577), t3x16(:,:,2616))
  call heltable([4,4,16], n3(:,3578), t3x16(:,:,2617))
  call heltable([4,4,16], n3(:,3579), t3x16(:,:,2618))
  call heltable([4,4,16], n3(:,3580), t3x16(:,:,2619))
  call heltable([4,4,16], n3(:,3581), t3x16(:,:,2620))
  call heltable([4,4,16], n3(:,3582), t3x16(:,:,2621))
  call heltable([4,4,16], n3(:,3583), t3x16(:,:,2622))
  call heltable([4,4,16], n3(:,3584), t3x16(:,:,2623))
  call heltable([4,4,16], n3(:,3585), t3x16(:,:,2624))
  call heltable([2,4,8], n3(:,3586), t3x8(:,:,535))
  call heltable([2,4,8], n3(:,3587), t3x8(:,:,536))
  call heltable([2,4,8], n3(:,3588), t3x8(:,:,537))
  call heltable([2,4,8], n3(:,3589), t3x8(:,:,538))
  call heltable([4,2,8], n3(:,3590), t3x8(:,:,539))
  call heltable([4,2,8], n3(:,3591), t3x8(:,:,540))
  call heltable([4,2,8], n3(:,3592), t3x8(:,:,541))
  call heltable([4,2,8], n3(:,3593), t3x8(:,:,542))
  call heltable([4,2,8], n3(:,3594), t3x8(:,:,543))
  call heltable([4,2,8], n3(:,3595), t3x8(:,:,544))
  call heltable([4,2,8], n3(:,3596), t3x8(:,:,545))
  call heltable([4,2,8], n3(:,3597), t3x8(:,:,546))
  call heltable([2,4,8], n3(:,3598), t3x8(:,:,547))
  call heltable([2,4,8], n3(:,3599), t3x8(:,:,548))
  call heltable([2,4,8], n3(:,3600), t3x8(:,:,549))
  call heltable([2,4,8], n3(:,3601), t3x8(:,:,550))
  call heltable([2,4,8], n3(:,3602), t3x8(:,:,551))
  call heltable([4,2,8], n3(:,3603), t3x8(:,:,552))
  call heltable([4,2,8], n3(:,3604), t3x8(:,:,553))
  call heltable([4,2,8], n3(:,3605), t3x8(:,:,554))
  call heltable([4,2,8], n3(:,3606), t3x8(:,:,555))
  call heltable([4,2,8], n3(:,3607), t3x8(:,:,556))
  call heltable([4,2,8], n3(:,3608), t3x8(:,:,557))
  n2(692) = 8
  n2(693) = 8
  n2(694) = 8
  n2(695) = 8
  n2(696) = 8
  n2(697) = 8
  n2(698) = 8
  n2(699) = 8
  n2(700) = 8
  n2(701) = 8
  n2(702) = 8
  n2(703) = 8
  n2(704) = 8
  n2(705) = 8
  n2(706) = 8
  call heltable([4,8,32], n3(:,3609), t3x32(:,:,376))
  call heltable([4,8,32], n3(:,3610), t3x32(:,:,377))
  call heltable([4,8,32], n3(:,3611), t3x32(:,:,378))
  call heltable([4,8,32], n3(:,3612), t3x32(:,:,379))
  call heltable([8,4,32], n3(:,3613), t3x32(:,:,380))
  call heltable([4,8,32], n3(:,3614), t3x32(:,:,381))
  call heltable([4,8,32], n3(:,3615), t3x32(:,:,382))
  call heltable([8,4,32], n3(:,3616), t3x32(:,:,383))
  call heltable([4,8,32], n3(:,3617), t3x32(:,:,384))
  call heltable([8,4,32], n3(:,3618), t3x32(:,:,385))
  call heltable([4,8,32], n3(:,3619), t3x32(:,:,386))
  call heltable([8,4,32], n3(:,3620), t3x32(:,:,387))
  call heltable([4,8,32], n3(:,3621), t3x32(:,:,388))
  call heltable([4,8,32], n3(:,3622), t3x32(:,:,389))
  call heltable([4,8,32], n3(:,3623), t3x32(:,:,390))
  call heltable([4,8,32], n3(:,3624), t3x32(:,:,391))
  call heltable([4,8,32], n3(:,3625), t3x32(:,:,392))
  call heltable([4,8,32], n3(:,3626), t3x32(:,:,393))
  call heltable([4,8,32], n3(:,3627), t3x32(:,:,394))
  call heltable([8,4,32], n3(:,3628), t3x32(:,:,395))
  call heltable([8,4,32], n3(:,3629), t3x32(:,:,396))
  call heltable([8,4,32], n3(:,3630), t3x32(:,:,397))
  call heltable([4,8,32], n3(:,3631), t3x32(:,:,398))
  call heltable([8,4,32], n3(:,3632), t3x32(:,:,399))
  call heltable([4,8,32], n3(:,3633), t3x32(:,:,400))
  call heltable([8,4,32], n3(:,3634), t3x32(:,:,401))
  call heltable([8,4,32], n3(:,3635), t3x32(:,:,402))
  call heltable([4,8,32], n3(:,3636), t3x32(:,:,403))
  call heltable([4,8,32], n3(:,3637), t3x32(:,:,404))
  call heltable([8,4,32], n3(:,3638), t3x32(:,:,405))
  call heltable([8,4,32], n3(:,3639), t3x32(:,:,406))
  call heltable([8,4,32], n3(:,3640), t3x32(:,:,407))
  call heltable([8,4,32], n3(:,3641), t3x32(:,:,408))
  call heltable([8,4,32], n3(:,3642), t3x32(:,:,409))
  call heltable([8,4,32], n3(:,3643), t3x32(:,:,410))
  call heltable([8,4,32], n3(:,3644), t3x32(:,:,411))
  call heltable([8,4,32], n3(:,3645), t3x32(:,:,412))
  call heltable([4,8,32], n3(:,3646), t3x32(:,:,413))
  call heltable([4,8,32], n3(:,3647), t3x32(:,:,414))
  call heltable([4,8,32], n3(:,3648), t3x32(:,:,415))
  call heltable([4,8,32], n3(:,3649), t3x32(:,:,416))
  call heltable([4,8,32], n3(:,3650), t3x32(:,:,417))
  call heltable([4,8,32], n3(:,3651), t3x32(:,:,418))
  call heltable([4,8,32], n3(:,3652), t3x32(:,:,419))
  call heltable([4,8,32], n3(:,3653), t3x32(:,:,420))
  call heltable([8,4,32], n3(:,3654), t3x32(:,:,421))
  call heltable([8,4,32], n3(:,3655), t3x32(:,:,422))
  call heltable([8,4,32], n3(:,3656), t3x32(:,:,423))
  call heltable([8,4,32], n3(:,3657), t3x32(:,:,424))
  call heltable([8,4,32], n3(:,3658), t3x32(:,:,425))
  call heltable([8,4,32], n3(:,3659), t3x32(:,:,426))
  call heltable([8,4,32], n3(:,3660), t3x32(:,:,427))
  call heltable([8,4,32], n3(:,3661), t3x32(:,:,428))
  call heltable([4,8,32], n3(:,3662), t3x32(:,:,429))
  call heltable([4,8,32], n3(:,3663), t3x32(:,:,430))
  call heltable([4,8,32], n3(:,3664), t3x32(:,:,431))
  call heltable([4,8,32], n3(:,3665), t3x32(:,:,432))
  call heltable([4,8,32], n3(:,3666), t3x32(:,:,433))
  call heltable([4,8,32], n3(:,3667), t3x32(:,:,434))
  call heltable([4,8,32], n3(:,3668), t3x32(:,:,435))
  call heltable([4,8,32], n3(:,3669), t3x32(:,:,436))
  call heltable([4,8,32], n3(:,3670), t3x32(:,:,437))
  call heltable([4,8,32], n3(:,3671), t3x32(:,:,438))
  call heltable([4,8,32], n3(:,3672), t3x32(:,:,439))
  call heltable([4,8,32], n3(:,3673), t3x32(:,:,440))
  call heltable([4,8,32], n3(:,3674), t3x32(:,:,441))
  call heltable([4,8,32], n3(:,3675), t3x32(:,:,442))
  call heltable([4,8,32], n3(:,3676), t3x32(:,:,443))
  call heltable([4,8,32], n3(:,3677), t3x32(:,:,444))
  call heltable([4,8,32], n3(:,3678), t3x32(:,:,445))
  call heltable([4,8,32], n3(:,3679), t3x32(:,:,446))
  call heltable([4,8,32], n3(:,3680), t3x32(:,:,447))
  call heltable([4,8,32], n3(:,3681), t3x32(:,:,448))
  call heltable([8,4,32], n3(:,3682), t3x32(:,:,449))
  call heltable([8,4,32], n3(:,3683), t3x32(:,:,450))
  call heltable([8,4,32], n3(:,3684), t3x32(:,:,451))
  call heltable([8,4,32], n3(:,3685), t3x32(:,:,452))
  call heltable([4,8,32], n3(:,3686), t3x32(:,:,453))
  call heltable([4,8,32], n3(:,3687), t3x32(:,:,454))
  call heltable([4,8,32], n3(:,3688), t3x32(:,:,455))
  call heltable([4,8,32], n3(:,3689), t3x32(:,:,456))
  call heltable([8,4,32], n3(:,3690), t3x32(:,:,457))
  call heltable([8,4,32], n3(:,3691), t3x32(:,:,458))
  call heltable([8,4,32], n3(:,3692), t3x32(:,:,459))
  call heltable([8,4,32], n3(:,3693), t3x32(:,:,460))
  call heltable([4,8,32], n3(:,3694), t3x32(:,:,461))
  call heltable([4,8,32], n3(:,3695), t3x32(:,:,462))
  call heltable([4,8,32], n3(:,3696), t3x32(:,:,463))
  call heltable([4,8,32], n3(:,3697), t3x32(:,:,464))
  call heltable([8,4,32], n3(:,3698), t3x32(:,:,465))
  call heltable([8,4,32], n3(:,3699), t3x32(:,:,466))
  call heltable([8,4,32], n3(:,3700), t3x32(:,:,467))
  call heltable([8,4,32], n3(:,3701), t3x32(:,:,468))
  call heltable([4,8,32], n3(:,3702), t3x32(:,:,469))
  call heltable([4,8,32], n3(:,3703), t3x32(:,:,470))
  call heltable([4,8,32], n3(:,3704), t3x32(:,:,471))
  call heltable([4,8,32], n3(:,3705), t3x32(:,:,472))
  call heltable([8,4,32], n3(:,3706), t3x32(:,:,473))
  call heltable([8,4,32], n3(:,3707), t3x32(:,:,474))
  call heltable([8,4,32], n3(:,3708), t3x32(:,:,475))
  call heltable([8,4,32], n3(:,3709), t3x32(:,:,476))
  call heltable([8,4,32], n3(:,3710), t3x32(:,:,477))
  call heltable([8,4,32], n3(:,3711), t3x32(:,:,478))
  call heltable([8,4,32], n3(:,3712), t3x32(:,:,479))
  call heltable([8,4,32], n3(:,3713), t3x32(:,:,480))
  call heltable([8,4,32], n3(:,3714), t3x32(:,:,481))
  call heltable([8,4,32], n3(:,3715), t3x32(:,:,482))
  call heltable([8,4,32], n3(:,3716), t3x32(:,:,483))
  call heltable([8,4,32], n3(:,3717), t3x32(:,:,484))
  call heltable([4,8,32], n3(:,3718), t3x32(:,:,485))
  call heltable([4,8,32], n3(:,3719), t3x32(:,:,486))
  call heltable([4,8,32], n3(:,3720), t3x32(:,:,487))
  call heltable([4,8,32], n3(:,3721), t3x32(:,:,488))
  call heltable([4,8,32], n3(:,3722), t3x32(:,:,489))
  call heltable([4,8,32], n3(:,3723), t3x32(:,:,490))
  call heltable([4,8,32], n3(:,3724), t3x32(:,:,491))
  call heltable([4,8,32], n3(:,3725), t3x32(:,:,492))
  call heltable([8,4,32], n3(:,3726), t3x32(:,:,493))
  call heltable([8,4,32], n3(:,3727), t3x32(:,:,494))
  call heltable([8,4,32], n3(:,3728), t3x32(:,:,495))
  call heltable([8,4,32], n3(:,3729), t3x32(:,:,496))
  call heltable([8,4,32], n3(:,3730), t3x32(:,:,497))
  call heltable([8,4,32], n3(:,3731), t3x32(:,:,498))
  call heltable([8,4,32], n3(:,3732), t3x32(:,:,499))
  call heltable([8,4,32], n3(:,3733), t3x32(:,:,500))
  call heltable([4,8,32], n3(:,3734), t3x32(:,:,501))
  call heltable([4,8,32], n3(:,3735), t3x32(:,:,502))
  call heltable([4,8,32], n3(:,3736), t3x32(:,:,503))
  call heltable([4,8,32], n3(:,3737), t3x32(:,:,504))
  call heltable([4,8,32], n3(:,3738), t3x32(:,:,505))
  call heltable([4,8,32], n3(:,3739), t3x32(:,:,506))
  call heltable([4,8,32], n3(:,3740), t3x32(:,:,507))
  call heltable([4,8,32], n3(:,3741), t3x32(:,:,508))
  call heltable([4,8,32], n3(:,3742), t3x32(:,:,509))
  call heltable([4,8,32], n3(:,3743), t3x32(:,:,510))
  call heltable([4,8,32], n3(:,3744), t3x32(:,:,511))
  call heltable([4,8,32], n3(:,3745), t3x32(:,:,512))
  call heltable([4,8,32], n3(:,3746), t3x32(:,:,513))
  call heltable([4,8,32], n3(:,3747), t3x32(:,:,514))
  call heltable([4,8,32], n3(:,3748), t3x32(:,:,515))
  call heltable([4,8,32], n3(:,3749), t3x32(:,:,516))
  call heltable([4,8,32], n3(:,3750), t3x32(:,:,517))
  call heltable([4,8,32], n3(:,3751), t3x32(:,:,518))
  call heltable([4,8,32], n3(:,3752), t3x32(:,:,519))
  call heltable([4,8,32], n3(:,3753), t3x32(:,:,520))
  call heltable([8,4,32], n3(:,3754), t3x32(:,:,521))
  call heltable([4,8,32], n3(:,3755), t3x32(:,:,522))
  call heltable([4,8,32], n3(:,3756), t3x32(:,:,523))
  call heltable([8,4,32], n3(:,3757), t3x32(:,:,524))
  call heltable([4,8,32], n3(:,3758), t3x32(:,:,525))
  call heltable([8,4,32], n3(:,3759), t3x32(:,:,526))
  call heltable([4,8,32], n3(:,3760), t3x32(:,:,527))
  call heltable([8,4,32], n3(:,3761), t3x32(:,:,528))
  call heltable([4,8,32], n3(:,3762), t3x32(:,:,529))
  call heltable([4,8,32], n3(:,3763), t3x32(:,:,530))
  call heltable([4,8,32], n3(:,3764), t3x32(:,:,531))
  call heltable([4,8,32], n3(:,3765), t3x32(:,:,532))
  call heltable([4,8,32], n3(:,3766), t3x32(:,:,533))
  call heltable([4,8,32], n3(:,3767), t3x32(:,:,534))
  call heltable([4,8,32], n3(:,3768), t3x32(:,:,535))
  call heltable([8,4,32], n3(:,3769), t3x32(:,:,536))
  call heltable([8,4,32], n3(:,3770), t3x32(:,:,537))
  call heltable([8,4,32], n3(:,3771), t3x32(:,:,538))
  call heltable([4,8,32], n3(:,3772), t3x32(:,:,539))
  call heltable([8,4,32], n3(:,3773), t3x32(:,:,540))
  call heltable([4,8,32], n3(:,3774), t3x32(:,:,541))
  call heltable([8,4,32], n3(:,3775), t3x32(:,:,542))
  call heltable([8,4,32], n3(:,3776), t3x32(:,:,543))
  call heltable([4,8,32], n3(:,3777), t3x32(:,:,544))
  call heltable([4,8,32], n3(:,3778), t3x32(:,:,545))
  n2(707) = 8
  n2(708) = 8
  n2(709) = 8
  n2(710) = 8
  n2(711) = 8
  n2(712) = 8
  n2(713) = 8
  n2(714) = 8
  n2(715) = 8
  n2(716) = 8
  call heltable([8,2,16], n3(:,3779), t3x16(:,:,2625))
  n2(717) = 8
  call heltable([8,2,16], n3(:,3780), t3x16(:,:,2626))
  n2(718) = 8
  call heltable([8,2,16], n3(:,3781), t3x16(:,:,2627))
  call heltable([8,2,16], n3(:,3782), t3x16(:,:,2628))
  n2(719) = 8
  n2(720) = 8
  n2(721) = 8
  n2(722) = 8
  n2(723) = 8
  n2(724) = 8
  n2(725) = 8
  n2(726) = 8
  n2(727) = 16
  n2(728) = 16
  n2(729) = 16
  n2(730) = 16
  n2(731) = 8
  n2(732) = 8
  n2(733) = 8
  n2(734) = 8
  n2(735) = 8
  n2(736) = 8
  n2(737) = 8
  n2(738) = 8
  n2(739) = 8
  n2(740) = 8
  n2(741) = 16
  n2(742) = 16
  n2(743) = 16
  n2(744) = 16
  n2(745) = 16
  n2(746) = 16
  n2(747) = 16
  n2(748) = 16
  call heltable([4,2,8], n3(:,3783), t3x8(:,:,558))
  n2(749) = 16
  n2(750) = 16
  n2(751) = 16
  n2(752) = 16
  n2(753) = 8
  n2(754) = 8
  n2(755) = 8
  n2(756) = 16
  n2(757) = 16
  n2(758) = 16
  n2(759) = 16
  call heltable([2,4,8], n3(:,3784), t3x8(:,:,559))
  n2(760) = 8
  n2(761) = 8
  n2(762) = 8
  n2(763) = 16
  n2(764) = 16
  n2(765) = 16
  n2(766) = 16
  n2(767) = 16
  n2(768) = 16
  n2(769) = 16
  n2(770) = 16
  call heltable([2,8,16], n3(:,3785), t3x16(:,:,2629))
  n2(771) = 16
  call heltable([2,8,16], n3(:,3786), t3x16(:,:,2630))
  n2(772) = 16
  call heltable([8,2,16], n3(:,3787), t3x16(:,:,2631))
  n2(773) = 16
  call heltable([8,2,16], n3(:,3788), t3x16(:,:,2632))
  n2(774) = 16
  call heltable([2,8,16], n3(:,3789), t3x16(:,:,2633))
  n2(775) = 16
  call heltable([2,8,16], n3(:,3790), t3x16(:,:,2634))
  n2(776) = 16
  call heltable([8,2,16], n3(:,3791), t3x16(:,:,2635))
  n2(777) = 16
  call heltable([8,2,16], n3(:,3792), t3x16(:,:,2636))
  n2(778) = 16
  call heltable([4,2,8], n3(:,3793), t3x8(:,:,560))
  call heltable([4,2,8], n3(:,3794), t3x8(:,:,561))
  call heltable([2,4,8], n3(:,3795), t3x8(:,:,562))
  call heltable([2,4,8], n3(:,3796), t3x8(:,:,563))
  call heltable([4,2,8], n3(:,3797), t3x8(:,:,564))
  call heltable([4,2,8], n3(:,3798), t3x8(:,:,565))
  call heltable([2,4,8], n3(:,3799), t3x8(:,:,566))
  call heltable([2,4,8], n3(:,3800), t3x8(:,:,567))
  call heltable([2,4,8], n3(:,3801), t3x8(:,:,568))
  call heltable([2,4,8], n3(:,3802), t3x8(:,:,569))
  call heltable([4,8,32], n3(:,3803), t3x32(:,:,546))
  call heltable([4,8,32], n3(:,3804), t3x32(:,:,547))
  call heltable([4,8,32], n3(:,3805), t3x32(:,:,548))
  call heltable([4,8,32], n3(:,3806), t3x32(:,:,549))
  call heltable([8,4,32], n3(:,3807), t3x32(:,:,550))
  call heltable([4,8,32], n3(:,3808), t3x32(:,:,551))
  call heltable([4,8,32], n3(:,3809), t3x32(:,:,552))
  call heltable([8,4,32], n3(:,3810), t3x32(:,:,553))
  call heltable([4,8,32], n3(:,3811), t3x32(:,:,554))
  call heltable([8,4,32], n3(:,3812), t3x32(:,:,555))
  call heltable([4,8,32], n3(:,3813), t3x32(:,:,556))
  call heltable([8,4,32], n3(:,3814), t3x32(:,:,557))
  call heltable([4,8,32], n3(:,3815), t3x32(:,:,558))
  call heltable([4,8,32], n3(:,3816), t3x32(:,:,559))
  call heltable([4,8,32], n3(:,3817), t3x32(:,:,560))
  call heltable([4,8,32], n3(:,3818), t3x32(:,:,561))
  call heltable([4,8,32], n3(:,3819), t3x32(:,:,562))
  call heltable([4,8,32], n3(:,3820), t3x32(:,:,563))
  call heltable([4,8,32], n3(:,3821), t3x32(:,:,564))
  call heltable([8,4,32], n3(:,3822), t3x32(:,:,565))
  call heltable([8,4,32], n3(:,3823), t3x32(:,:,566))
  call heltable([8,4,32], n3(:,3824), t3x32(:,:,567))
  call heltable([4,8,32], n3(:,3825), t3x32(:,:,568))
  call heltable([8,4,32], n3(:,3826), t3x32(:,:,569))
  call heltable([4,8,32], n3(:,3827), t3x32(:,:,570))
  call heltable([8,4,32], n3(:,3828), t3x32(:,:,571))
  call heltable([8,4,32], n3(:,3829), t3x32(:,:,572))
  call heltable([4,8,32], n3(:,3830), t3x32(:,:,573))
  call heltable([4,8,32], n3(:,3831), t3x32(:,:,574))
  call heltable([4,4,16], n3(:,3832), t3x16(:,:,2637))
  call heltable([4,4,16], n3(:,3833), t3x16(:,:,2638))
  call heltable([4,4,16], n3(:,3834), t3x16(:,:,2639))
  call heltable([4,4,16], n3(:,3835), t3x16(:,:,2640))
  call heltable([4,4,16], n3(:,3836), t3x16(:,:,2641))
  call heltable([4,4,16], n3(:,3837), t3x16(:,:,2642))
  call heltable([4,4,16], n3(:,3838), t3x16(:,:,2643))
  call heltable([4,4,16], n3(:,3839), t3x16(:,:,2644))
  call heltable([4,4,16], n3(:,3840), t3x16(:,:,2645))
  call heltable([4,4,16], n3(:,3841), t3x16(:,:,2646))
  call heltable([2,4,8], n3(:,3842), t3x8(:,:,570))
  call heltable([2,4,8], n3(:,3843), t3x8(:,:,571))
  call heltable([4,2,8], n3(:,3844), t3x8(:,:,572))
  call heltable([8,4,32], n3(:,3845), t3x32(:,:,575))
  call heltable([8,4,32], n3(:,3846), t3x32(:,:,576))
  call heltable([8,4,32], n3(:,3847), t3x32(:,:,577))
  call heltable([8,4,32], n3(:,3848), t3x32(:,:,578))
  call heltable([4,8,32], n3(:,3849), t3x32(:,:,579))
  call heltable([4,8,32], n3(:,3850), t3x32(:,:,580))
  call heltable([4,8,32], n3(:,3851), t3x32(:,:,581))
  call heltable([4,8,32], n3(:,3852), t3x32(:,:,582))
  call heltable([8,4,32], n3(:,3853), t3x32(:,:,583))
  call heltable([8,4,32], n3(:,3854), t3x32(:,:,584))
  call heltable([8,4,32], n3(:,3855), t3x32(:,:,585))
  call heltable([8,4,32], n3(:,3856), t3x32(:,:,586))
  call heltable([4,8,32], n3(:,3857), t3x32(:,:,587))
  call heltable([4,8,32], n3(:,3858), t3x32(:,:,588))
  call heltable([4,8,32], n3(:,3859), t3x32(:,:,589))
  call heltable([4,8,32], n3(:,3860), t3x32(:,:,590))
  call heltable([4,4,16], n3(:,3861), t3x16(:,:,2647))
  call heltable([4,4,16], n3(:,3862), t3x16(:,:,2648))
  call heltable([4,4,16], n3(:,3863), t3x16(:,:,2649))
  call heltable([4,4,16], n3(:,3864), t3x16(:,:,2650))
  call heltable([4,2,8], n3(:,3865), t3x8(:,:,573))
  call heltable([4,2,8], n3(:,3866), t3x8(:,:,574))
  call heltable([4,2,8], n3(:,3867), t3x8(:,:,575))
  call heltable([4,2,8], n3(:,3868), t3x8(:,:,576))
  call heltable([2,4,8], n3(:,3869), t3x8(:,:,577))
  call heltable([2,4,8], n3(:,3870), t3x8(:,:,578))
  call heltable([2,4,8], n3(:,3871), t3x8(:,:,579))
  call heltable([2,4,8], n3(:,3872), t3x8(:,:,580))
  call heltable([2,4,8], n3(:,3873), t3x8(:,:,581))
  call heltable([2,4,8], n3(:,3874), t3x8(:,:,582))
  n2(779) = 8
  n2(780) = 8
  n2(781) = 8
  n2(782) = 8
  n2(783) = 8
  n2(784) = 8
  n2(785) = 8
  n2(786) = 8
  n2(787) = 8
  n2(788) = 8
  n2(789) = 8
  n2(790) = 8
  n2(791) = 8
  n2(792) = 8
  n2(793) = 8
  call heltable([4,4,16], n3(:,3875), t3x16(:,:,2651))
  call heltable([4,4,16], n3(:,3876), t3x16(:,:,2652))
  call heltable([4,4,16], n3(:,3877), t3x16(:,:,2653))
  call heltable([4,4,16], n3(:,3878), t3x16(:,:,2654))
  call heltable([4,4,16], n3(:,3879), t3x16(:,:,2655))
  call heltable([4,4,16], n3(:,3880), t3x16(:,:,2656))
  call heltable([4,4,16], n3(:,3881), t3x16(:,:,2657))
  call heltable([4,4,16], n3(:,3882), t3x16(:,:,2658))
  call heltable([4,4,16], n3(:,3883), t3x16(:,:,2659))
  call heltable([4,4,16], n3(:,3884), t3x16(:,:,2660))
  call heltable([4,4,16], n3(:,3885), t3x16(:,:,2661))
  call heltable([4,4,16], n3(:,3886), t3x16(:,:,2662))
  call heltable([4,4,16], n3(:,3887), t3x16(:,:,2663))
  call heltable([4,4,16], n3(:,3888), t3x16(:,:,2664))
  call heltable([4,4,16], n3(:,3889), t3x16(:,:,2665))
  call heltable([4,4,16], n3(:,3890), t3x16(:,:,2666))
  call heltable([4,4,16], n3(:,3891), t3x16(:,:,2667))
  call heltable([4,4,16], n3(:,3892), t3x16(:,:,2668))
  call heltable([4,4,16], n3(:,3893), t3x16(:,:,2669))
  call heltable([4,4,16], n3(:,3894), t3x16(:,:,2670))
  call heltable([4,4,16], n3(:,3895), t3x16(:,:,2671))
  call heltable([4,4,16], n3(:,3896), t3x16(:,:,2672))
  call heltable([4,4,16], n3(:,3897), t3x16(:,:,2673))
  call heltable([4,4,16], n3(:,3898), t3x16(:,:,2674))
  call heltable([4,4,16], n3(:,3899), t3x16(:,:,2675))
  call heltable([4,4,16], n3(:,3900), t3x16(:,:,2676))
  call heltable([4,4,16], n3(:,3901), t3x16(:,:,2677))
  call heltable([4,4,16], n3(:,3902), t3x16(:,:,2678))
  call heltable([4,4,16], n3(:,3903), t3x16(:,:,2679))
  call heltable([2,4,8], n3(:,3904), t3x8(:,:,583))
  call heltable([2,4,8], n3(:,3905), t3x8(:,:,584))
  call heltable([4,2,8], n3(:,3906), t3x8(:,:,585))
  call heltable([4,2,8], n3(:,3907), t3x8(:,:,586))
  call heltable([2,4,8], n3(:,3908), t3x8(:,:,587))
  call heltable([2,4,8], n3(:,3909), t3x8(:,:,588))
  call heltable([4,2,8], n3(:,3910), t3x8(:,:,589))
  call heltable([4,2,8], n3(:,3911), t3x8(:,:,590))
  call heltable([4,2,8], n3(:,3912), t3x8(:,:,591))
  call heltable([4,2,8], n3(:,3913), t3x8(:,:,592))
  call heltable([4,8,32], n3(:,3914), t3x32(:,:,591))
  call heltable([4,8,32], n3(:,3915), t3x32(:,:,592))
  call heltable([4,8,32], n3(:,3916), t3x32(:,:,593))
  call heltable([4,8,32], n3(:,3917), t3x32(:,:,594))
  call heltable([8,4,32], n3(:,3918), t3x32(:,:,595))
  call heltable([4,8,32], n3(:,3919), t3x32(:,:,596))
  call heltable([4,8,32], n3(:,3920), t3x32(:,:,597))
  call heltable([8,4,32], n3(:,3921), t3x32(:,:,598))
  call heltable([4,8,32], n3(:,3922), t3x32(:,:,599))
  call heltable([8,4,32], n3(:,3923), t3x32(:,:,600))
  call heltable([4,8,32], n3(:,3924), t3x32(:,:,601))
  call heltable([8,4,32], n3(:,3925), t3x32(:,:,602))
  call heltable([4,8,32], n3(:,3926), t3x32(:,:,603))
  call heltable([4,8,32], n3(:,3927), t3x32(:,:,604))
  call heltable([4,8,32], n3(:,3928), t3x32(:,:,605))
  call heltable([4,8,32], n3(:,3929), t3x32(:,:,606))
  call heltable([4,8,32], n3(:,3930), t3x32(:,:,607))
  call heltable([4,8,32], n3(:,3931), t3x32(:,:,608))
  call heltable([4,8,32], n3(:,3932), t3x32(:,:,609))
  call heltable([8,4,32], n3(:,3933), t3x32(:,:,610))
  call heltable([8,4,32], n3(:,3934), t3x32(:,:,611))
  call heltable([8,4,32], n3(:,3935), t3x32(:,:,612))
  call heltable([4,8,32], n3(:,3936), t3x32(:,:,613))
  call heltable([8,4,32], n3(:,3937), t3x32(:,:,614))
  call heltable([4,8,32], n3(:,3938), t3x32(:,:,615))
  call heltable([8,4,32], n3(:,3939), t3x32(:,:,616))
  call heltable([8,4,32], n3(:,3940), t3x32(:,:,617))
  call heltable([4,8,32], n3(:,3941), t3x32(:,:,618))
  call heltable([4,8,32], n3(:,3942), t3x32(:,:,619))
  call heltable([8,4,32], n3(:,3943), t3x32(:,:,620))
  call heltable([8,4,32], n3(:,3944), t3x32(:,:,621))
  call heltable([8,4,32], n3(:,3945), t3x32(:,:,622))
  call heltable([8,4,32], n3(:,3946), t3x32(:,:,623))
  call heltable([8,4,32], n3(:,3947), t3x32(:,:,624))
  call heltable([8,4,32], n3(:,3948), t3x32(:,:,625))
  call heltable([8,4,32], n3(:,3949), t3x32(:,:,626))
  call heltable([8,4,32], n3(:,3950), t3x32(:,:,627))
  call heltable([4,8,32], n3(:,3951), t3x32(:,:,628))
  call heltable([4,8,32], n3(:,3952), t3x32(:,:,629))
  call heltable([4,8,32], n3(:,3953), t3x32(:,:,630))
  call heltable([4,8,32], n3(:,3954), t3x32(:,:,631))
  call heltable([4,8,32], n3(:,3955), t3x32(:,:,632))
  call heltable([4,8,32], n3(:,3956), t3x32(:,:,633))
  call heltable([4,8,32], n3(:,3957), t3x32(:,:,634))
  call heltable([4,8,32], n3(:,3958), t3x32(:,:,635))
  call heltable([8,4,32], n3(:,3959), t3x32(:,:,636))
  call heltable([8,4,32], n3(:,3960), t3x32(:,:,637))
  call heltable([8,4,32], n3(:,3961), t3x32(:,:,638))
  call heltable([8,4,32], n3(:,3962), t3x32(:,:,639))
  call heltable([8,4,32], n3(:,3963), t3x32(:,:,640))
  call heltable([8,4,32], n3(:,3964), t3x32(:,:,641))
  call heltable([8,4,32], n3(:,3965), t3x32(:,:,642))
  call heltable([8,4,32], n3(:,3966), t3x32(:,:,643))
  call heltable([4,8,32], n3(:,3967), t3x32(:,:,644))
  call heltable([4,8,32], n3(:,3968), t3x32(:,:,645))
  call heltable([4,8,32], n3(:,3969), t3x32(:,:,646))
  call heltable([4,8,32], n3(:,3970), t3x32(:,:,647))
  call heltable([4,8,32], n3(:,3971), t3x32(:,:,648))
  call heltable([4,8,32], n3(:,3972), t3x32(:,:,649))
  call heltable([4,8,32], n3(:,3973), t3x32(:,:,650))
  call heltable([4,8,32], n3(:,3974), t3x32(:,:,651))
  call heltable([4,8,32], n3(:,3975), t3x32(:,:,652))
  call heltable([4,8,32], n3(:,3976), t3x32(:,:,653))
  call heltable([4,8,32], n3(:,3977), t3x32(:,:,654))
  call heltable([4,8,32], n3(:,3978), t3x32(:,:,655))
  call heltable([4,8,32], n3(:,3979), t3x32(:,:,656))
  call heltable([4,8,32], n3(:,3980), t3x32(:,:,657))
  call heltable([4,8,32], n3(:,3981), t3x32(:,:,658))
  call heltable([4,8,32], n3(:,3982), t3x32(:,:,659))
  n2(794) = 4
  n2(795) = 4
  call heltable([4,2,8], n3(:,3983), t3x8(:,:,593))
  call heltable([4,2,8], n3(:,3984), t3x8(:,:,594))
  call heltable([2,4,8], n3(:,3985), t3x8(:,:,595))
  n2(796) = 8
  n2(797) = 8
  n2(798) = 8
  n2(799) = 8
  n2(800) = 8
  n2(801) = 8
  n2(802) = 8
  n2(803) = 8
  n2(804) = 8
  n2(805) = 8
  n2(806) = 8
  call heltable([4,8,32], n3(:,3986), t3x32(:,:,660))
  call heltable([4,8,32], n3(:,3987), t3x32(:,:,661))
  call heltable([4,8,32], n3(:,3988), t3x32(:,:,662))
  call heltable([4,8,32], n3(:,3989), t3x32(:,:,663))
  call heltable([8,4,32], n3(:,3990), t3x32(:,:,664))
  call heltable([8,4,32], n3(:,3991), t3x32(:,:,665))
  call heltable([8,4,32], n3(:,3992), t3x32(:,:,666))
  call heltable([8,4,32], n3(:,3993), t3x32(:,:,667))
  call heltable([4,8,32], n3(:,3994), t3x32(:,:,668))
  call heltable([4,8,32], n3(:,3995), t3x32(:,:,669))
  call heltable([4,8,32], n3(:,3996), t3x32(:,:,670))
  call heltable([4,8,32], n3(:,3997), t3x32(:,:,671))
  call heltable([8,4,32], n3(:,3998), t3x32(:,:,672))
  call heltable([8,4,32], n3(:,3999), t3x32(:,:,673))
  call heltable([8,4,32], n3(:,4000), t3x32(:,:,674))
  call heltable([8,4,32], n3(:,4001), t3x32(:,:,675))
  call heltable([4,4,16], n3(:,4002), t3x16(:,:,2680))
  call heltable([4,4,16], n3(:,4003), t3x16(:,:,2681))
  call heltable([4,4,16], n3(:,4004), t3x16(:,:,2682))
  call heltable([4,4,16], n3(:,4005), t3x16(:,:,2683))
  call heltable([8,4,32], n3(:,4006), t3x32(:,:,676))
  call heltable([8,4,32], n3(:,4007), t3x32(:,:,677))
  call heltable([8,4,32], n3(:,4008), t3x32(:,:,678))
  call heltable([8,4,32], n3(:,4009), t3x32(:,:,679))
  call heltable([8,4,32], n3(:,4010), t3x32(:,:,680))
  call heltable([8,4,32], n3(:,4011), t3x32(:,:,681))
  call heltable([8,4,32], n3(:,4012), t3x32(:,:,682))
  call heltable([8,4,32], n3(:,4013), t3x32(:,:,683))
  call heltable([4,8,32], n3(:,4014), t3x32(:,:,684))
  call heltable([4,8,32], n3(:,4015), t3x32(:,:,685))
  call heltable([4,8,32], n3(:,4016), t3x32(:,:,686))
  call heltable([4,8,32], n3(:,4017), t3x32(:,:,687))
  call heltable([4,8,32], n3(:,4018), t3x32(:,:,688))
  call heltable([4,8,32], n3(:,4019), t3x32(:,:,689))
  call heltable([4,8,32], n3(:,4020), t3x32(:,:,690))
  call heltable([4,8,32], n3(:,4021), t3x32(:,:,691))
  call heltable([8,4,32], n3(:,4022), t3x32(:,:,692))
  call heltable([8,4,32], n3(:,4023), t3x32(:,:,693))
  call heltable([8,4,32], n3(:,4024), t3x32(:,:,694))
  call heltable([8,4,32], n3(:,4025), t3x32(:,:,695))
  call heltable([8,4,32], n3(:,4026), t3x32(:,:,696))
  call heltable([8,4,32], n3(:,4027), t3x32(:,:,697))
  call heltable([8,4,32], n3(:,4028), t3x32(:,:,698))
  call heltable([8,4,32], n3(:,4029), t3x32(:,:,699))
  call heltable([4,8,32], n3(:,4030), t3x32(:,:,700))
  call heltable([4,8,32], n3(:,4031), t3x32(:,:,701))
  call heltable([4,8,32], n3(:,4032), t3x32(:,:,702))
  call heltable([4,8,32], n3(:,4033), t3x32(:,:,703))
  call heltable([4,8,32], n3(:,4034), t3x32(:,:,704))
  call heltable([4,8,32], n3(:,4035), t3x32(:,:,705))
  call heltable([4,8,32], n3(:,4036), t3x32(:,:,706))
  call heltable([4,8,32], n3(:,4037), t3x32(:,:,707))
  call heltable([4,8,32], n3(:,4038), t3x32(:,:,708))
  call heltable([4,8,32], n3(:,4039), t3x32(:,:,709))
  call heltable([4,8,32], n3(:,4040), t3x32(:,:,710))
  call heltable([4,8,32], n3(:,4041), t3x32(:,:,711))
  call heltable([4,8,32], n3(:,4042), t3x32(:,:,712))
  call heltable([4,8,32], n3(:,4043), t3x32(:,:,713))
  call heltable([4,8,32], n3(:,4044), t3x32(:,:,714))
  call heltable([4,8,32], n3(:,4045), t3x32(:,:,715))
  call heltable([8,2,16], n3(:,4046), t3x16(:,:,2684))
  n2(807) = 8
  call heltable([8,2,16], n3(:,4047), t3x16(:,:,2685))
  n2(808) = 8
  call heltable([8,2,16], n3(:,4048), t3x16(:,:,2686))
  call heltable([8,2,16], n3(:,4049), t3x16(:,:,2687))
  n2(809) = 8
  n2(810) = 8
  n2(811) = 8
  n2(812) = 8
  n2(813) = 8
  n2(814) = 8
  n2(815) = 8
  n2(816) = 8
  n2(817) = 8
  n2(818) = 8
  n2(819) = 8
  n2(820) = 8
  n2(821) = 8
  n2(822) = 8
  n2(823) = 8
  n2(824) = 8
  n2(825) = 8
  n2(826) = 8
  call heltable([8,2,16], n3(:,4050), t3x16(:,:,2688))
  call heltable([8,2,16], n3(:,4051), t3x16(:,:,2689))
  call heltable([8,2,16], n3(:,4052), t3x16(:,:,2690))
  call heltable([8,2,16], n3(:,4053), t3x16(:,:,2691))
  n2(827) = 16
  n2(828) = 16
  n2(829) = 16
  n2(830) = 16
  n2(831) = 16
  n2(832) = 16
  n2(833) = 16
  n2(834) = 16
  n2(835) = 8
  n2(836) = 8
  n2(837) = 8
  n2(838) = 8
  n2(839) = 8
  n2(840) = 8
  n2(841) = 8
  n2(842) = 8
  n2(843) = 8
  n2(844) = 8
  n2(845) = 16
  n2(846) = 16
  n2(847) = 16
  n2(848) = 16
  n2(849) = 16
  n2(850) = 16
  n2(851) = 16
  n2(852) = 16
  call heltable([4,2,8], n3(:,4054), t3x8(:,:,596))
  n2(853) = 8
  n2(854) = 8
  n2(855) = 8
  n2(856) = 16
  n2(857) = 16
  n2(858) = 16
  n2(859) = 16
  n2(860) = 16
  n2(861) = 16
  n2(862) = 16
  n2(863) = 16
  call heltable([2,4,8], n3(:,4055), t3x8(:,:,597))
  n2(864) = 8
  n2(865) = 8
  n2(866) = 8
  n2(867) = 16
  n2(868) = 16
  n2(869) = 16
  n2(870) = 16
  call heltable([8,2,16], n3(:,4056), t3x16(:,:,2692))
  call heltable([8,2,16], n3(:,4057), t3x16(:,:,2693))
  call heltable([2,8,16], n3(:,4058), t3x16(:,:,2694))
  call heltable([2,8,16], n3(:,4059), t3x16(:,:,2695))
  n2(871) = 16
  n2(872) = 16
  n2(873) = 16
  n2(874) = 16
  call heltable([8,2,16], n3(:,4060), t3x16(:,:,2696))
  call heltable([8,2,16], n3(:,4061), t3x16(:,:,2697))
  call heltable([2,8,16], n3(:,4062), t3x16(:,:,2698))
  call heltable([2,8,16], n3(:,4063), t3x16(:,:,2699))
  n2(875) = 16
  n2(876) = 16
  n2(877) = 16
  n2(878) = 16
  call heltable([2,4,8], n3(:,4064), t3x8(:,:,598))
  call heltable([2,4,8], n3(:,4065), t3x8(:,:,599))
  call heltable([4,2,8], n3(:,4066), t3x8(:,:,600))
  call heltable([8,4,32], n3(:,4067), t3x32(:,:,716))
  call heltable([8,4,32], n3(:,4068), t3x32(:,:,717))
  call heltable([8,4,32], n3(:,4069), t3x32(:,:,718))
  call heltable([8,4,32], n3(:,4070), t3x32(:,:,719))
  call heltable([4,8,32], n3(:,4071), t3x32(:,:,720))
  call heltable([4,8,32], n3(:,4072), t3x32(:,:,721))
  call heltable([4,8,32], n3(:,4073), t3x32(:,:,722))
  call heltable([4,8,32], n3(:,4074), t3x32(:,:,723))
  call heltable([8,4,32], n3(:,4075), t3x32(:,:,724))
  call heltable([8,4,32], n3(:,4076), t3x32(:,:,725))
  call heltable([8,4,32], n3(:,4077), t3x32(:,:,726))
  call heltable([8,4,32], n3(:,4078), t3x32(:,:,727))
  call heltable([4,8,32], n3(:,4079), t3x32(:,:,728))
  call heltable([4,8,32], n3(:,4080), t3x32(:,:,729))
  call heltable([4,8,32], n3(:,4081), t3x32(:,:,730))
  call heltable([4,8,32], n3(:,4082), t3x32(:,:,731))
  call heltable([4,4,16], n3(:,4083), t3x16(:,:,2700))
  call heltable([4,4,16], n3(:,4084), t3x16(:,:,2701))
  call heltable([4,4,16], n3(:,4085), t3x16(:,:,2702))
  call heltable([4,4,16], n3(:,4086), t3x16(:,:,2703))
  call heltable([4,2,8], n3(:,4087), t3x8(:,:,601))
  call heltable([4,2,8], n3(:,4088), t3x8(:,:,602))
  call heltable([2,4,8], n3(:,4089), t3x8(:,:,603))
  call heltable([2,4,8], n3(:,4090), t3x8(:,:,604))
  call heltable([4,2,8], n3(:,4091), t3x8(:,:,605))
  call heltable([4,2,8], n3(:,4092), t3x8(:,:,606))
  call heltable([2,4,8], n3(:,4093), t3x8(:,:,607))
  call heltable([2,4,8], n3(:,4094), t3x8(:,:,608))
  call heltable([2,4,8], n3(:,4095), t3x8(:,:,609))
  call heltable([2,4,8], n3(:,4096), t3x8(:,:,610))
  call heltable([4,8,32], n3(:,4097), t3x32(:,:,732))
  call heltable([4,8,32], n3(:,4098), t3x32(:,:,733))
  call heltable([4,8,32], n3(:,4099), t3x32(:,:,734))
  call heltable([4,8,32], n3(:,4100), t3x32(:,:,735))
  call heltable([8,4,32], n3(:,4101), t3x32(:,:,736))
  call heltable([4,8,32], n3(:,4102), t3x32(:,:,737))
  call heltable([4,8,32], n3(:,4103), t3x32(:,:,738))
  call heltable([8,4,32], n3(:,4104), t3x32(:,:,739))
  call heltable([4,8,32], n3(:,4105), t3x32(:,:,740))
  call heltable([8,4,32], n3(:,4106), t3x32(:,:,741))
  call heltable([4,8,32], n3(:,4107), t3x32(:,:,742))
  call heltable([8,4,32], n3(:,4108), t3x32(:,:,743))
  call heltable([4,8,32], n3(:,4109), t3x32(:,:,744))
  call heltable([4,8,32], n3(:,4110), t3x32(:,:,745))
  call heltable([4,8,32], n3(:,4111), t3x32(:,:,746))
  call heltable([4,8,32], n3(:,4112), t3x32(:,:,747))
  call heltable([4,8,32], n3(:,4113), t3x32(:,:,748))
  call heltable([4,8,32], n3(:,4114), t3x32(:,:,749))
  call heltable([4,8,32], n3(:,4115), t3x32(:,:,750))
  call heltable([8,4,32], n3(:,4116), t3x32(:,:,751))
  call heltable([8,4,32], n3(:,4117), t3x32(:,:,752))
  call heltable([8,4,32], n3(:,4118), t3x32(:,:,753))
  call heltable([4,8,32], n3(:,4119), t3x32(:,:,754))
  call heltable([8,4,32], n3(:,4120), t3x32(:,:,755))
  call heltable([4,8,32], n3(:,4121), t3x32(:,:,756))
  call heltable([8,4,32], n3(:,4122), t3x32(:,:,757))
  call heltable([8,4,32], n3(:,4123), t3x32(:,:,758))
  call heltable([4,8,32], n3(:,4124), t3x32(:,:,759))
  call heltable([4,8,32], n3(:,4125), t3x32(:,:,760))
  call heltable([4,4,16], n3(:,4126), t3x16(:,:,2704))
  call heltable([4,4,16], n3(:,4127), t3x16(:,:,2705))
  call heltable([4,4,16], n3(:,4128), t3x16(:,:,2706))
  call heltable([4,4,16], n3(:,4129), t3x16(:,:,2707))
  call heltable([4,4,16], n3(:,4130), t3x16(:,:,2708))
  call heltable([4,4,16], n3(:,4131), t3x16(:,:,2709))
  call heltable([4,4,16], n3(:,4132), t3x16(:,:,2710))
  call heltable([4,4,16], n3(:,4133), t3x16(:,:,2711))
  call heltable([4,4,16], n3(:,4134), t3x16(:,:,2712))
  call heltable([4,4,16], n3(:,4135), t3x16(:,:,2713))
  n2(879) = 8
  n2(880) = 8
  n2(881) = 8
  n2(882) = 8
  n2(883) = 8
  n2(884) = 8
  n2(885) = 8
  n2(886) = 8
  n2(887) = 8
  n2(888) = 8
  n2(889) = 8
  call heltable([4,4,16], n3(:,4136), t3x16(:,:,2714))
  call heltable([4,4,16], n3(:,4137), t3x16(:,:,2715))
  call heltable([4,4,16], n3(:,4138), t3x16(:,:,2716))
  call heltable([4,4,16], n3(:,4139), t3x16(:,:,2717))
  call heltable([4,4,16], n3(:,4140), t3x16(:,:,2718))
  call heltable([4,4,16], n3(:,4141), t3x16(:,:,2719))
  call heltable([4,4,16], n3(:,4142), t3x16(:,:,2720))
  call heltable([4,4,16], n3(:,4143), t3x16(:,:,2721))
  call heltable([4,4,16], n3(:,4144), t3x16(:,:,2722))
  call heltable([4,4,16], n3(:,4145), t3x16(:,:,2723))
  call heltable([4,4,16], n3(:,4146), t3x16(:,:,2724))
  call heltable([4,4,16], n3(:,4147), t3x16(:,:,2725))
  call heltable([4,4,16], n3(:,4148), t3x16(:,:,2726))
  call heltable([4,4,16], n3(:,4149), t3x16(:,:,2727))
  call heltable([4,4,16], n3(:,4150), t3x16(:,:,2728))
  call heltable([4,4,16], n3(:,4151), t3x16(:,:,2729))
  call heltable([4,4,16], n3(:,4152), t3x16(:,:,2730))
  call heltable([4,4,16], n3(:,4153), t3x16(:,:,2731))
  call heltable([4,4,16], n3(:,4154), t3x16(:,:,2732))
  call heltable([4,4,16], n3(:,4155), t3x16(:,:,2733))
  call heltable([4,4,16], n3(:,4156), t3x16(:,:,2734))
  call heltable([4,4,16], n3(:,4157), t3x16(:,:,2735))
  call heltable([4,4,16], n3(:,4158), t3x16(:,:,2736))
  call heltable([4,4,16], n3(:,4159), t3x16(:,:,2737))
  call heltable([4,4,16], n3(:,4160), t3x16(:,:,2738))
  call heltable([4,4,16], n3(:,4161), t3x16(:,:,2739))
  call heltable([4,4,16], n3(:,4162), t3x16(:,:,2740))
  call heltable([4,4,16], n3(:,4163), t3x16(:,:,2741))
  call heltable([4,4,16], n3(:,4164), t3x16(:,:,2742))
  call heltable([2,4,8], n3(:,4165), t3x8(:,:,611))
  call heltable([2,4,8], n3(:,4166), t3x8(:,:,612))
  call heltable([2,4,8], n3(:,4167), t3x8(:,:,613))
  call heltable([2,4,8], n3(:,4168), t3x8(:,:,614))
  call heltable([4,2,8], n3(:,4169), t3x8(:,:,615))
  call heltable([4,2,8], n3(:,4170), t3x8(:,:,616))
  call heltable([4,2,8], n3(:,4171), t3x8(:,:,617))
  call heltable([4,2,8], n3(:,4172), t3x8(:,:,618))
  call heltable([4,2,8], n3(:,4173), t3x8(:,:,619))
  call heltable([4,2,8], n3(:,4174), t3x8(:,:,620))
  call heltable([4,2,8], n3(:,4175), t3x8(:,:,621))
  call heltable([4,2,8], n3(:,4176), t3x8(:,:,622))
  call heltable([2,4,8], n3(:,4177), t3x8(:,:,623))
  n2(890) = 8
  n2(891) = 8
  n2(892) = 8
  n2(893) = 8
  n2(894) = 8
  n2(895) = 8
  n2(896) = 8
  n2(897) = 8
  n2(898) = 8
  n2(899) = 8
  n2(900) = 8
  call heltable([4,8,32], n3(:,4178), t3x32(:,:,761))
  call heltable([4,8,32], n3(:,4179), t3x32(:,:,762))
  call heltable([4,8,32], n3(:,4180), t3x32(:,:,763))
  call heltable([4,8,32], n3(:,4181), t3x32(:,:,764))
  call heltable([8,4,32], n3(:,4182), t3x32(:,:,765))
  call heltable([4,8,32], n3(:,4183), t3x32(:,:,766))
  call heltable([4,8,32], n3(:,4184), t3x32(:,:,767))
  call heltable([8,4,32], n3(:,4185), t3x32(:,:,768))
  call heltable([4,8,32], n3(:,4186), t3x32(:,:,769))
  call heltable([8,4,32], n3(:,4187), t3x32(:,:,770))
  call heltable([4,8,32], n3(:,4188), t3x32(:,:,771))
  call heltable([8,4,32], n3(:,4189), t3x32(:,:,772))
  call heltable([4,8,32], n3(:,4190), t3x32(:,:,773))
  call heltable([4,8,32], n3(:,4191), t3x32(:,:,774))
  call heltable([4,8,32], n3(:,4192), t3x32(:,:,775))
  call heltable([4,8,32], n3(:,4193), t3x32(:,:,776))
  call heltable([4,8,32], n3(:,4194), t3x32(:,:,777))
  call heltable([4,8,32], n3(:,4195), t3x32(:,:,778))
  call heltable([4,8,32], n3(:,4196), t3x32(:,:,779))
  call heltable([8,4,32], n3(:,4197), t3x32(:,:,780))
  call heltable([8,4,32], n3(:,4198), t3x32(:,:,781))
  call heltable([8,4,32], n3(:,4199), t3x32(:,:,782))
  call heltable([4,8,32], n3(:,4200), t3x32(:,:,783))
  call heltable([8,4,32], n3(:,4201), t3x32(:,:,784))
  call heltable([4,8,32], n3(:,4202), t3x32(:,:,785))
  call heltable([8,4,32], n3(:,4203), t3x32(:,:,786))
  call heltable([8,4,32], n3(:,4204), t3x32(:,:,787))
  call heltable([4,8,32], n3(:,4205), t3x32(:,:,788))
  call heltable([4,8,32], n3(:,4206), t3x32(:,:,789))
  call heltable([8,4,32], n3(:,4207), t3x32(:,:,790))
  call heltable([8,4,32], n3(:,4208), t3x32(:,:,791))
  call heltable([8,4,32], n3(:,4209), t3x32(:,:,792))
  call heltable([8,4,32], n3(:,4210), t3x32(:,:,793))
  call heltable([8,4,32], n3(:,4211), t3x32(:,:,794))
  call heltable([8,4,32], n3(:,4212), t3x32(:,:,795))
  call heltable([8,4,32], n3(:,4213), t3x32(:,:,796))
  call heltable([8,4,32], n3(:,4214), t3x32(:,:,797))
  call heltable([4,8,32], n3(:,4215), t3x32(:,:,798))
  call heltable([4,8,32], n3(:,4216), t3x32(:,:,799))
  call heltable([4,8,32], n3(:,4217), t3x32(:,:,800))
  call heltable([4,8,32], n3(:,4218), t3x32(:,:,801))
  call heltable([4,8,32], n3(:,4219), t3x32(:,:,802))
  call heltable([4,8,32], n3(:,4220), t3x32(:,:,803))
  call heltable([4,8,32], n3(:,4221), t3x32(:,:,804))
  call heltable([4,8,32], n3(:,4222), t3x32(:,:,805))
  call heltable([8,4,32], n3(:,4223), t3x32(:,:,806))
  call heltable([8,4,32], n3(:,4224), t3x32(:,:,807))
  call heltable([8,4,32], n3(:,4225), t3x32(:,:,808))
  call heltable([8,4,32], n3(:,4226), t3x32(:,:,809))
  call heltable([8,4,32], n3(:,4227), t3x32(:,:,810))
  call heltable([8,4,32], n3(:,4228), t3x32(:,:,811))
  call heltable([8,4,32], n3(:,4229), t3x32(:,:,812))
  call heltable([8,4,32], n3(:,4230), t3x32(:,:,813))
  call heltable([4,8,32], n3(:,4231), t3x32(:,:,814))
  call heltable([4,8,32], n3(:,4232), t3x32(:,:,815))
  call heltable([4,8,32], n3(:,4233), t3x32(:,:,816))
  call heltable([4,8,32], n3(:,4234), t3x32(:,:,817))
  call heltable([4,8,32], n3(:,4235), t3x32(:,:,818))
  call heltable([4,8,32], n3(:,4236), t3x32(:,:,819))
  call heltable([4,8,32], n3(:,4237), t3x32(:,:,820))
  call heltable([4,8,32], n3(:,4238), t3x32(:,:,821))
  call heltable([4,8,32], n3(:,4239), t3x32(:,:,822))
  call heltable([4,8,32], n3(:,4240), t3x32(:,:,823))
  call heltable([4,8,32], n3(:,4241), t3x32(:,:,824))
  call heltable([4,8,32], n3(:,4242), t3x32(:,:,825))
  call heltable([4,8,32], n3(:,4243), t3x32(:,:,826))
  call heltable([4,8,32], n3(:,4244), t3x32(:,:,827))
  call heltable([4,8,32], n3(:,4245), t3x32(:,:,828))
  call heltable([4,8,32], n3(:,4246), t3x32(:,:,829))
  call heltable([4,8,32], n3(:,4247), t3x32(:,:,830))
  call heltable([4,8,32], n3(:,4248), t3x32(:,:,831))
  call heltable([4,8,32], n3(:,4249), t3x32(:,:,832))
  call heltable([4,8,32], n3(:,4250), t3x32(:,:,833))
  call heltable([8,4,32], n3(:,4251), t3x32(:,:,834))
  call heltable([8,4,32], n3(:,4252), t3x32(:,:,835))
  call heltable([8,4,32], n3(:,4253), t3x32(:,:,836))
  call heltable([8,4,32], n3(:,4254), t3x32(:,:,837))
  call heltable([4,8,32], n3(:,4255), t3x32(:,:,838))
  call heltable([4,8,32], n3(:,4256), t3x32(:,:,839))
  call heltable([4,8,32], n3(:,4257), t3x32(:,:,840))
  call heltable([4,8,32], n3(:,4258), t3x32(:,:,841))
  call heltable([8,4,32], n3(:,4259), t3x32(:,:,842))
  call heltable([8,4,32], n3(:,4260), t3x32(:,:,843))
  call heltable([8,4,32], n3(:,4261), t3x32(:,:,844))
  call heltable([8,4,32], n3(:,4262), t3x32(:,:,845))
  call heltable([4,8,32], n3(:,4263), t3x32(:,:,846))
  call heltable([4,8,32], n3(:,4264), t3x32(:,:,847))
  call heltable([4,8,32], n3(:,4265), t3x32(:,:,848))
  call heltable([4,8,32], n3(:,4266), t3x32(:,:,849))
  call heltable([8,4,32], n3(:,4267), t3x32(:,:,850))
  call heltable([8,4,32], n3(:,4268), t3x32(:,:,851))
  call heltable([8,4,32], n3(:,4269), t3x32(:,:,852))
  call heltable([8,4,32], n3(:,4270), t3x32(:,:,853))
  call heltable([4,8,32], n3(:,4271), t3x32(:,:,854))
  call heltable([4,8,32], n3(:,4272), t3x32(:,:,855))
  call heltable([4,8,32], n3(:,4273), t3x32(:,:,856))
  call heltable([4,8,32], n3(:,4274), t3x32(:,:,857))
  call heltable([8,4,32], n3(:,4275), t3x32(:,:,858))
  call heltable([8,4,32], n3(:,4276), t3x32(:,:,859))
  call heltable([8,4,32], n3(:,4277), t3x32(:,:,860))
  call heltable([8,4,32], n3(:,4278), t3x32(:,:,861))
  call heltable([8,4,32], n3(:,4279), t3x32(:,:,862))
  call heltable([8,4,32], n3(:,4280), t3x32(:,:,863))
  call heltable([8,4,32], n3(:,4281), t3x32(:,:,864))
  call heltable([8,4,32], n3(:,4282), t3x32(:,:,865))
  call heltable([8,4,32], n3(:,4283), t3x32(:,:,866))
  call heltable([8,4,32], n3(:,4284), t3x32(:,:,867))
  call heltable([8,4,32], n3(:,4285), t3x32(:,:,868))
  call heltable([8,4,32], n3(:,4286), t3x32(:,:,869))
  call heltable([4,8,32], n3(:,4287), t3x32(:,:,870))
  call heltable([4,8,32], n3(:,4288), t3x32(:,:,871))
  call heltable([4,8,32], n3(:,4289), t3x32(:,:,872))
  call heltable([4,8,32], n3(:,4290), t3x32(:,:,873))
  call heltable([4,8,32], n3(:,4291), t3x32(:,:,874))
  call heltable([4,8,32], n3(:,4292), t3x32(:,:,875))
  call heltable([4,8,32], n3(:,4293), t3x32(:,:,876))
  call heltable([4,8,32], n3(:,4294), t3x32(:,:,877))
  call heltable([8,4,32], n3(:,4295), t3x32(:,:,878))
  call heltable([8,4,32], n3(:,4296), t3x32(:,:,879))
  call heltable([8,4,32], n3(:,4297), t3x32(:,:,880))
  call heltable([8,4,32], n3(:,4298), t3x32(:,:,881))
  call heltable([8,4,32], n3(:,4299), t3x32(:,:,882))
  call heltable([8,4,32], n3(:,4300), t3x32(:,:,883))
  call heltable([8,4,32], n3(:,4301), t3x32(:,:,884))
  call heltable([8,4,32], n3(:,4302), t3x32(:,:,885))
  call heltable([4,8,32], n3(:,4303), t3x32(:,:,886))
  call heltable([4,8,32], n3(:,4304), t3x32(:,:,887))
  call heltable([4,8,32], n3(:,4305), t3x32(:,:,888))
  call heltable([4,8,32], n3(:,4306), t3x32(:,:,889))
  call heltable([4,8,32], n3(:,4307), t3x32(:,:,890))
  call heltable([4,8,32], n3(:,4308), t3x32(:,:,891))
  call heltable([4,8,32], n3(:,4309), t3x32(:,:,892))
  call heltable([4,8,32], n3(:,4310), t3x32(:,:,893))
  call heltable([4,8,32], n3(:,4311), t3x32(:,:,894))
  call heltable([4,8,32], n3(:,4312), t3x32(:,:,895))
  call heltable([4,8,32], n3(:,4313), t3x32(:,:,896))
  call heltable([4,8,32], n3(:,4314), t3x32(:,:,897))
  call heltable([4,8,32], n3(:,4315), t3x32(:,:,898))
  call heltable([4,8,32], n3(:,4316), t3x32(:,:,899))
  call heltable([4,8,32], n3(:,4317), t3x32(:,:,900))
  call heltable([4,8,32], n3(:,4318), t3x32(:,:,901))
  call heltable([4,8,32], n3(:,4319), t3x32(:,:,902))
  call heltable([4,8,32], n3(:,4320), t3x32(:,:,903))
  call heltable([4,8,32], n3(:,4321), t3x32(:,:,904))
  call heltable([4,8,32], n3(:,4322), t3x32(:,:,905))
  call heltable([8,4,32], n3(:,4323), t3x32(:,:,906))
  call heltable([4,8,32], n3(:,4324), t3x32(:,:,907))
  call heltable([4,8,32], n3(:,4325), t3x32(:,:,908))
  call heltable([8,4,32], n3(:,4326), t3x32(:,:,909))
  call heltable([4,8,32], n3(:,4327), t3x32(:,:,910))
  call heltable([8,4,32], n3(:,4328), t3x32(:,:,911))
  call heltable([4,8,32], n3(:,4329), t3x32(:,:,912))
  call heltable([8,4,32], n3(:,4330), t3x32(:,:,913))
  call heltable([4,8,32], n3(:,4331), t3x32(:,:,914))
  call heltable([4,8,32], n3(:,4332), t3x32(:,:,915))
  call heltable([4,8,32], n3(:,4333), t3x32(:,:,916))
  call heltable([4,8,32], n3(:,4334), t3x32(:,:,917))
  call heltable([4,8,32], n3(:,4335), t3x32(:,:,918))
  call heltable([4,8,32], n3(:,4336), t3x32(:,:,919))
  call heltable([4,8,32], n3(:,4337), t3x32(:,:,920))
  call heltable([8,4,32], n3(:,4338), t3x32(:,:,921))
  call heltable([8,4,32], n3(:,4339), t3x32(:,:,922))
  call heltable([8,4,32], n3(:,4340), t3x32(:,:,923))
  call heltable([4,8,32], n3(:,4341), t3x32(:,:,924))
  call heltable([8,4,32], n3(:,4342), t3x32(:,:,925))
  call heltable([4,8,32], n3(:,4343), t3x32(:,:,926))
  call heltable([8,4,32], n3(:,4344), t3x32(:,:,927))
  call heltable([8,4,32], n3(:,4345), t3x32(:,:,928))
  call heltable([4,8,32], n3(:,4346), t3x32(:,:,929))
  call heltable([4,8,32], n3(:,4347), t3x32(:,:,930))
  n2(901) = 8
  n2(902) = 8
  n2(903) = 8
  n2(904) = 8
  n2(905) = 8
  n2(906) = 8
  n2(907) = 8
  n2(908) = 8
  n2(909) = 8
  n2(910) = 8
  call heltable([8,2,16], n3(:,4348), t3x16(:,:,2743))
  call heltable([8,2,16], n3(:,4349), t3x16(:,:,2744))
  call heltable([8,2,16], n3(:,4350), t3x16(:,:,2745))
  call heltable([8,2,16], n3(:,4351), t3x16(:,:,2746))
  n2(911) = 16
  n2(912) = 16
  n2(913) = 16
  n2(914) = 16
  n2(915) = 8
  n2(916) = 8
  n2(917) = 8
  n2(918) = 8
  n2(919) = 8
  n2(920) = 8
  n2(921) = 8
  n2(922) = 8
  n2(923) = 8
  n2(924) = 8
  n2(925) = 16
  n2(926) = 16
  n2(927) = 16
  n2(928) = 16
  call heltable([4,2,8], n3(:,4352), t3x8(:,:,624))
  n2(929) = 16
  n2(930) = 16
  n2(931) = 16
  n2(932) = 16
  n2(933) = 8
  n2(934) = 8
  n2(935) = 8
  n2(936) = 16
  n2(937) = 16
  n2(938) = 16
  n2(939) = 16
  call heltable([2,4,8], n3(:,4353), t3x8(:,:,625))
  n2(940) = 8
  n2(941) = 8
  n2(942) = 8
  n2(943) = 16
  n2(944) = 16
  n2(945) = 16
  n2(946) = 16
  n2(947) = 16
  n2(948) = 16
  n2(949) = 16
  n2(950) = 16
  call heltable([2,8,16], n3(:,4354), t3x16(:,:,2747))
  n2(951) = 16
  call heltable([2,8,16], n3(:,4355), t3x16(:,:,2748))
  n2(952) = 16
  call heltable([8,2,16], n3(:,4356), t3x16(:,:,2749))
  n2(953) = 16
  call heltable([8,2,16], n3(:,4357), t3x16(:,:,2750))
  n2(954) = 16
  call heltable([8,2,16], n3(:,4358), t3x16(:,:,2751))
  n2(955) = 16
  call heltable([8,2,16], n3(:,4359), t3x16(:,:,2752))
  n2(956) = 16
  call heltable([2,8,16], n3(:,4360), t3x16(:,:,2753))
  n2(957) = 16
  call heltable([2,8,16], n3(:,4361), t3x16(:,:,2754))
  n2(958) = 16
  n2(959) = 16
  n2(960) = 16
  n2(961) = 16
  n2(962) = 16
  call heltable([8,2,16], n3(:,4362), t3x16(:,:,2755))
  n2(963) = 16
  call heltable([8,2,16], n3(:,4363), t3x16(:,:,2756))
  n2(964) = 16
  call heltable([2,8,16], n3(:,4364), t3x16(:,:,2757))
  n2(965) = 16
  call heltable([2,8,16], n3(:,4365), t3x16(:,:,2758))
  n2(966) = 16
  call heltable([2,8,16], n3(:,4366), t3x16(:,:,2759))
  n2(967) = 16
  call heltable([2,8,16], n3(:,4367), t3x16(:,:,2760))
  n2(968) = 16
  call heltable([8,2,16], n3(:,4368), t3x16(:,:,2761))
  n2(969) = 16
  call heltable([8,2,16], n3(:,4369), t3x16(:,:,2762))
  n2(970) = 16
  call heltable([8,2,16], n3(:,4370), t3x16(:,:,2763))
  n2(971) = 16
  call heltable([8,2,16], n3(:,4371), t3x16(:,:,2764))
  n2(972) = 16
  call heltable([2,8,16], n3(:,4372), t3x16(:,:,2765))
  n2(973) = 16
  call heltable([2,8,16], n3(:,4373), t3x16(:,:,2766))
  n2(974) = 16
  n2(975) = 16
  n2(976) = 16
  n2(977) = 16
  n2(978) = 16
  call heltable([8,2,16], n3(:,4374), t3x16(:,:,2767))
  n2(979) = 16
  call heltable([8,2,16], n3(:,4375), t3x16(:,:,2768))
  n2(980) = 16
  call heltable([2,8,16], n3(:,4376), t3x16(:,:,2769))
  n2(981) = 16
  call heltable([2,8,16], n3(:,4377), t3x16(:,:,2770))
  n2(982) = 16
  n2(983) = 16
  n2(984) = 16
  n2(985) = 16
  n2(986) = 16
  call heltable([8,2,16], n3(:,4378), t3x16(:,:,2771))
  n2(987) = 16
  call heltable([8,2,16], n3(:,4379), t3x16(:,:,2772))
  n2(988) = 16
  call heltable([2,8,16], n3(:,4380), t3x16(:,:,2773))
  n2(989) = 16
  call heltable([2,8,16], n3(:,4381), t3x16(:,:,2774))
  n2(990) = 16
  n2(991) = 16
  n2(992) = 16
  n2(993) = 16
  n2(994) = 16
  n2(995) = 16
  n2(996) = 16
  n2(997) = 16
  n2(998) = 16
  n2(999) = 16
  n2(1000) = 16
  n2(1001) = 16
  n2(1002) = 16
  call heltable([8,2,16], n3(:,4382), t3x16(:,:,2775))
  n2(1003) = 16
  call heltable([8,2,16], n3(:,4383), t3x16(:,:,2776))
  n2(1004) = 16
  call heltable([2,8,16], n3(:,4384), t3x16(:,:,2777))
  n2(1005) = 16
  call heltable([2,8,16], n3(:,4385), t3x16(:,:,2778))
  n2(1006) = 16
  n2(1007) = 16
  n2(1008) = 16
  n2(1009) = 16
  n2(1010) = 16
  n2(1011) = 16
  n2(1012) = 16
  n2(1013) = 16
  n2(1014) = 16
  call heltable([8,4,32], n3(:,4386), t3x32(:,:,931))
  n2(1015) = 32
  call heltable([8,4,32], n3(:,4387), t3x32(:,:,932))
  n2(1016) = 32
  call heltable([8,4,32], n3(:,4388), t3x32(:,:,933))
  n2(1017) = 32
  call heltable([8,4,32], n3(:,4389), t3x32(:,:,934))
  n2(1018) = 32
  call heltable([4,8,32], n3(:,4390), t3x32(:,:,935))
  n2(1019) = 32
  call heltable([4,8,32], n3(:,4391), t3x32(:,:,936))
  n2(1020) = 32
  call heltable([4,8,32], n3(:,4392), t3x32(:,:,937))
  n2(1021) = 32
  call heltable([4,8,32], n3(:,4393), t3x32(:,:,938))
  n2(1022) = 32
  call heltable([8,4,32], n3(:,4394), t3x32(:,:,939))
  n2(1023) = 32
  call heltable([8,4,32], n3(:,4395), t3x32(:,:,940))
  n2(1024) = 32
  call heltable([8,4,32], n3(:,4396), t3x32(:,:,941))
  n2(1025) = 32
  call heltable([8,4,32], n3(:,4397), t3x32(:,:,942))
  n2(1026) = 32
  call heltable([4,8,32], n3(:,4398), t3x32(:,:,943))
  n2(1027) = 32
  call heltable([4,8,32], n3(:,4399), t3x32(:,:,944))
  n2(1028) = 32
  call heltable([4,8,32], n3(:,4400), t3x32(:,:,945))
  n2(1029) = 32
  call heltable([4,8,32], n3(:,4401), t3x32(:,:,946))
  n2(1030) = 32
  call heltable([4,8,32], n3(:,4402), t3x32(:,:,947))
  n2(1031) = 32
  call heltable([4,8,32], n3(:,4403), t3x32(:,:,948))
  n2(1032) = 32
  call heltable([4,8,32], n3(:,4404), t3x32(:,:,949))
  n2(1033) = 32
  call heltable([4,8,32], n3(:,4405), t3x32(:,:,950))
  n2(1034) = 32
  call heltable([8,4,32], n3(:,4406), t3x32(:,:,951))
  n2(1035) = 32
  call heltable([8,4,32], n3(:,4407), t3x32(:,:,952))
  n2(1036) = 32
  call heltable([8,4,32], n3(:,4408), t3x32(:,:,953))
  n2(1037) = 32
  call heltable([8,4,32], n3(:,4409), t3x32(:,:,954))
  n2(1038) = 32
  call heltable([4,8,32], n3(:,4410), t3x32(:,:,955))
  n2(1039) = 32
  call heltable([4,8,32], n3(:,4411), t3x32(:,:,956))
  n2(1040) = 32
  call heltable([4,8,32], n3(:,4412), t3x32(:,:,957))
  n2(1041) = 32
  call heltable([4,8,32], n3(:,4413), t3x32(:,:,958))
  n2(1042) = 32
  call heltable([8,4,32], n3(:,4414), t3x32(:,:,959))
  n2(1043) = 32
  call heltable([8,4,32], n3(:,4415), t3x32(:,:,960))
  n2(1044) = 32
  call heltable([8,4,32], n3(:,4416), t3x32(:,:,961))
  n2(1045) = 32
  call heltable([8,4,32], n3(:,4417), t3x32(:,:,962))
  n2(1046) = 32
  call heltable([8,4,32], n3(:,4418), t3x32(:,:,963))
  n2(1047) = 32
  call heltable([8,4,32], n3(:,4419), t3x32(:,:,964))
  n2(1048) = 32
  call heltable([8,4,32], n3(:,4420), t3x32(:,:,965))
  n2(1049) = 32
  call heltable([8,4,32], n3(:,4421), t3x32(:,:,966))
  n2(1050) = 32
  call heltable([8,4,32], n3(:,4422), t3x32(:,:,967))
  n2(1051) = 32
  call heltable([8,4,32], n3(:,4423), t3x32(:,:,968))
  n2(1052) = 32
  call heltable([8,4,32], n3(:,4424), t3x32(:,:,969))
  n2(1053) = 32
  call heltable([8,4,32], n3(:,4425), t3x32(:,:,970))
  n2(1054) = 32
  call heltable([4,8,32], n3(:,4426), t3x32(:,:,971))
  n2(1055) = 32
  call heltable([4,8,32], n3(:,4427), t3x32(:,:,972))
  n2(1056) = 32
  call heltable([4,8,32], n3(:,4428), t3x32(:,:,973))
  n2(1057) = 32
  call heltable([4,8,32], n3(:,4429), t3x32(:,:,974))
  n2(1058) = 32
  call heltable([4,8,32], n3(:,4430), t3x32(:,:,975))
  n2(1059) = 32
  call heltable([4,8,32], n3(:,4431), t3x32(:,:,976))
  n2(1060) = 32
  call heltable([4,8,32], n3(:,4432), t3x32(:,:,977))
  n2(1061) = 32
  call heltable([4,8,32], n3(:,4433), t3x32(:,:,978))
  n2(1062) = 32
  call heltable([4,8,32], n3(:,4434), t3x32(:,:,979))
  n2(1063) = 32
  call heltable([4,8,32], n3(:,4435), t3x32(:,:,980))
  n2(1064) = 32
  call heltable([4,8,32], n3(:,4436), t3x32(:,:,981))
  n2(1065) = 32
  call heltable([4,8,32], n3(:,4437), t3x32(:,:,982))
  n2(1066) = 32
  call heltable([4,8,32], n3(:,4438), t3x32(:,:,983))
  n2(1067) = 32
  call heltable([4,8,32], n3(:,4439), t3x32(:,:,984))
  n2(1068) = 32
  call heltable([4,8,32], n3(:,4440), t3x32(:,:,985))
  n2(1069) = 32
  call heltable([4,8,32], n3(:,4441), t3x32(:,:,986))
  n2(1070) = 32
  call heltable([8,4,32], n3(:,4442), t3x32(:,:,987))
  n2(1071) = 32
  call heltable([8,4,32], n3(:,4443), t3x32(:,:,988))
  n2(1072) = 32
  call heltable([8,4,32], n3(:,4444), t3x32(:,:,989))
  n2(1073) = 32
  call heltable([8,4,32], n3(:,4445), t3x32(:,:,990))
  n2(1074) = 32
  call heltable([8,4,32], n3(:,4446), t3x32(:,:,991))
  n2(1075) = 32
  call heltable([8,4,32], n3(:,4447), t3x32(:,:,992))
  n2(1076) = 32
  call heltable([8,4,32], n3(:,4448), t3x32(:,:,993))
  n2(1077) = 32
  call heltable([8,4,32], n3(:,4449), t3x32(:,:,994))
  n2(1078) = 32
  call heltable([2,16,32], n3(:,4450), t3x32(:,:,995))
  n2(1079) = 32
  call heltable([2,16,32], n3(:,4451), t3x32(:,:,996))
  n2(1080) = 32
  call heltable([2,16,32], n3(:,4452), t3x32(:,:,997))
  n2(1081) = 32
  call heltable([2,16,32], n3(:,4453), t3x32(:,:,998))
  n2(1082) = 32
  call heltable([16,2,32], n3(:,4454), t3x32(:,:,999))
  n2(1083) = 32
  call heltable([16,2,32], n3(:,4455), t3x32(:,:,1000))
  n2(1084) = 32
  call heltable([2,16,32], n3(:,4456), t3x32(:,:,1001))
  n2(1085) = 32
  call heltable([2,16,32], n3(:,4457), t3x32(:,:,1002))
  n2(1086) = 32
  call heltable([16,2,32], n3(:,4458), t3x32(:,:,1003))
  n2(1087) = 32
  call heltable([2,16,32], n3(:,4459), t3x32(:,:,1004))
  n2(1088) = 32
  call heltable([2,16,32], n3(:,4460), t3x32(:,:,1005))
  n2(1089) = 32
  call heltable([16,2,32], n3(:,4461), t3x32(:,:,1006))
  n2(1090) = 32
  call heltable([2,16,32], n3(:,4462), t3x32(:,:,1007))
  n2(1091) = 32
  call heltable([16,2,32], n3(:,4463), t3x32(:,:,1008))
  n2(1092) = 32
  call heltable([16,2,32], n3(:,4464), t3x32(:,:,1009))
  n2(1093) = 32
  call heltable([16,2,32], n3(:,4465), t3x32(:,:,1010))
  n2(1094) = 32
  call heltable([16,2,32], n3(:,4466), t3x32(:,:,1011))
  n2(1095) = 32
  call heltable([2,16,32], n3(:,4467), t3x32(:,:,1012))
  n2(1096) = 32
  call heltable([2,16,32], n3(:,4468), t3x32(:,:,1013))
  n2(1097) = 32
  call heltable([16,2,32], n3(:,4469), t3x32(:,:,1014))
  n2(1098) = 32
  call heltable([16,2,32], n3(:,4470), t3x32(:,:,1015))
  n2(1099) = 32
  call heltable([2,16,32], n3(:,4471), t3x32(:,:,1016))
  n2(1100) = 32
  call heltable([16,2,32], n3(:,4472), t3x32(:,:,1017))
  n2(1101) = 32
  call heltable([16,2,32], n3(:,4473), t3x32(:,:,1018))
  n2(1102) = 32
  call heltable([2,16,32], n3(:,4474), t3x32(:,:,1019))
  n2(1103) = 32
  call heltable([16,2,32], n3(:,4475), t3x32(:,:,1020))
  n2(1104) = 32
  call heltable([8,4,32], n3(:,4476), t3x32(:,:,1021))
  n2(1105) = 32
  call heltable([8,4,32], n3(:,4477), t3x32(:,:,1022))
  n2(1106) = 32
  call heltable([8,4,32], n3(:,4478), t3x32(:,:,1023))
  n2(1107) = 32
  call heltable([8,4,32], n3(:,4479), t3x32(:,:,1024))
  n2(1108) = 32
  call heltable([4,8,32], n3(:,4480), t3x32(:,:,1025))
  n2(1109) = 32
  call heltable([4,8,32], n3(:,4481), t3x32(:,:,1026))
  n2(1110) = 32
  call heltable([4,8,32], n3(:,4482), t3x32(:,:,1027))
  n2(1111) = 32
  call heltable([4,8,32], n3(:,4483), t3x32(:,:,1028))
  n2(1112) = 32
  call heltable([8,4,32], n3(:,4484), t3x32(:,:,1029))
  n2(1113) = 32
  call heltable([8,4,32], n3(:,4485), t3x32(:,:,1030))
  n2(1114) = 32
  call heltable([8,4,32], n3(:,4486), t3x32(:,:,1031))
  n2(1115) = 32
  call heltable([8,4,32], n3(:,4487), t3x32(:,:,1032))
  n2(1116) = 32
  call heltable([4,8,32], n3(:,4488), t3x32(:,:,1033))
  n2(1117) = 32
  call heltable([4,8,32], n3(:,4489), t3x32(:,:,1034))
  n2(1118) = 32
  call heltable([4,8,32], n3(:,4490), t3x32(:,:,1035))
  n2(1119) = 32
  call heltable([4,8,32], n3(:,4491), t3x32(:,:,1036))
  n2(1120) = 32
  call heltable([4,8,32], n3(:,4492), t3x32(:,:,1037))
  n2(1121) = 32
  call heltable([4,8,32], n3(:,4493), t3x32(:,:,1038))
  n2(1122) = 32
  call heltable([4,8,32], n3(:,4494), t3x32(:,:,1039))
  n2(1123) = 32
  call heltable([4,8,32], n3(:,4495), t3x32(:,:,1040))
  n2(1124) = 32
  call heltable([8,4,32], n3(:,4496), t3x32(:,:,1041))
  n2(1125) = 32
  call heltable([8,4,32], n3(:,4497), t3x32(:,:,1042))
  n2(1126) = 32
  call heltable([8,4,32], n3(:,4498), t3x32(:,:,1043))
  n2(1127) = 32
  call heltable([8,4,32], n3(:,4499), t3x32(:,:,1044))
  n2(1128) = 32
  call heltable([4,8,32], n3(:,4500), t3x32(:,:,1045))
  n2(1129) = 32
  call heltable([4,8,32], n3(:,4501), t3x32(:,:,1046))
  n2(1130) = 32
  call heltable([4,8,32], n3(:,4502), t3x32(:,:,1047))
  n2(1131) = 32
  call heltable([4,8,32], n3(:,4503), t3x32(:,:,1048))
  n2(1132) = 32
  call heltable([8,4,32], n3(:,4504), t3x32(:,:,1049))
  n2(1133) = 32
  call heltable([8,4,32], n3(:,4505), t3x32(:,:,1050))
  n2(1134) = 32
  call heltable([8,4,32], n3(:,4506), t3x32(:,:,1051))
  n2(1135) = 32
  call heltable([8,4,32], n3(:,4507), t3x32(:,:,1052))
  n2(1136) = 32
  call heltable([8,4,32], n3(:,4508), t3x32(:,:,1053))
  n2(1137) = 32
  call heltable([8,4,32], n3(:,4509), t3x32(:,:,1054))
  n2(1138) = 32
  call heltable([8,4,32], n3(:,4510), t3x32(:,:,1055))
  n2(1139) = 32
  call heltable([8,4,32], n3(:,4511), t3x32(:,:,1056))
  n2(1140) = 32
  call heltable([8,4,32], n3(:,4512), t3x32(:,:,1057))
  n2(1141) = 32
  call heltable([8,4,32], n3(:,4513), t3x32(:,:,1058))
  n2(1142) = 32
  call heltable([8,4,32], n3(:,4514), t3x32(:,:,1059))
  n2(1143) = 32
  call heltable([8,4,32], n3(:,4515), t3x32(:,:,1060))
  n2(1144) = 32
  call heltable([4,8,32], n3(:,4516), t3x32(:,:,1061))
  n2(1145) = 32
  call heltable([4,8,32], n3(:,4517), t3x32(:,:,1062))
  n2(1146) = 32
  call heltable([4,8,32], n3(:,4518), t3x32(:,:,1063))
  n2(1147) = 32
  call heltable([4,8,32], n3(:,4519), t3x32(:,:,1064))
  n2(1148) = 32
  call heltable([4,8,32], n3(:,4520), t3x32(:,:,1065))
  n2(1149) = 32
  call heltable([4,8,32], n3(:,4521), t3x32(:,:,1066))
  n2(1150) = 32
  call heltable([4,8,32], n3(:,4522), t3x32(:,:,1067))
  n2(1151) = 32
  call heltable([4,8,32], n3(:,4523), t3x32(:,:,1068))
  n2(1152) = 32
  call heltable([2,16,32], n3(:,4524), t3x32(:,:,1069))
  n2(1153) = 32
  call heltable([2,16,32], n3(:,4525), t3x32(:,:,1070))
  n2(1154) = 32
  call heltable([2,16,32], n3(:,4526), t3x32(:,:,1071))
  n2(1155) = 32
  call heltable([2,16,32], n3(:,4527), t3x32(:,:,1072))
  n2(1156) = 32
  call heltable([2,16,32], n3(:,4528), t3x32(:,:,1073))
  n2(1157) = 32
  call heltable([2,16,32], n3(:,4529), t3x32(:,:,1074))
  n2(1158) = 32
  call heltable([16,2,32], n3(:,4530), t3x32(:,:,1075))
  n2(1159) = 32
  call heltable([16,2,32], n3(:,4531), t3x32(:,:,1076))
  n2(1160) = 32
  call heltable([16,2,32], n3(:,4532), t3x32(:,:,1077))
  n2(1161) = 32
  call heltable([2,16,32], n3(:,4533), t3x32(:,:,1078))
  n2(1162) = 32
  call heltable([2,16,32], n3(:,4534), t3x32(:,:,1079))
  n2(1163) = 32
  call heltable([2,16,32], n3(:,4535), t3x32(:,:,1080))
  n2(1164) = 32
  call heltable([16,2,32], n3(:,4536), t3x32(:,:,1081))
  n2(1165) = 32
  call heltable([4,8,32], n3(:,4537), t3x32(:,:,1082))
  n2(1166) = 32
  call heltable([4,8,32], n3(:,4538), t3x32(:,:,1083))
  n2(1167) = 32
  call heltable([4,8,32], n3(:,4539), t3x32(:,:,1084))
  n2(1168) = 32
  call heltable([4,8,32], n3(:,4540), t3x32(:,:,1085))
  n2(1169) = 32
  call heltable([4,8,32], n3(:,4541), t3x32(:,:,1086))
  n2(1170) = 32
  call heltable([4,8,32], n3(:,4542), t3x32(:,:,1087))
  n2(1171) = 32
  call heltable([4,8,32], n3(:,4543), t3x32(:,:,1088))
  n2(1172) = 32
  call heltable([4,8,32], n3(:,4544), t3x32(:,:,1089))
  n2(1173) = 32
  call heltable([8,4,32], n3(:,4545), t3x32(:,:,1090))
  n2(1174) = 32
  call heltable([8,4,32], n3(:,4546), t3x32(:,:,1091))
  n2(1175) = 32
  call heltable([8,4,32], n3(:,4547), t3x32(:,:,1092))
  n2(1176) = 32
  call heltable([8,4,32], n3(:,4548), t3x32(:,:,1093))
  n2(1177) = 32
  call heltable([8,4,32], n3(:,4549), t3x32(:,:,1094))
  n2(1178) = 32
  call heltable([8,4,32], n3(:,4550), t3x32(:,:,1095))
  n2(1179) = 32
  call heltable([8,4,32], n3(:,4551), t3x32(:,:,1096))
  n2(1180) = 32
  call heltable([8,4,32], n3(:,4552), t3x32(:,:,1097))
  n2(1181) = 32
  call heltable([16,2,32], n3(:,4553), t3x32(:,:,1098))
  n2(1182) = 32
  call heltable([16,2,32], n3(:,4554), t3x32(:,:,1099))
  n2(1183) = 32
  call heltable([16,2,32], n3(:,4555), t3x32(:,:,1100))
  n2(1184) = 32
  call heltable([16,2,32], n3(:,4556), t3x32(:,:,1101))
  n2(1185) = 32
  call heltable([16,2,32], n3(:,4557), t3x32(:,:,1102))
  n2(1186) = 32
  call heltable([16,2,32], n3(:,4558), t3x32(:,:,1103))
  n2(1187) = 32
  call heltable([2,16,32], n3(:,4559), t3x32(:,:,1104))
  n2(1188) = 32
  call heltable([2,16,32], n3(:,4560), t3x32(:,:,1105))
  n2(1189) = 32
  call heltable([2,16,32], n3(:,4561), t3x32(:,:,1106))
  n2(1190) = 32
  call heltable([16,2,32], n3(:,4562), t3x32(:,:,1107))
  n2(1191) = 32
  call heltable([16,2,32], n3(:,4563), t3x32(:,:,1108))
  n2(1192) = 32
  call heltable([16,2,32], n3(:,4564), t3x32(:,:,1109))
  n2(1193) = 32
  call heltable([2,16,32], n3(:,4565), t3x32(:,:,1110))
  n2(1194) = 32
  call heltable([8,4,32], n3(:,4566), t3x32(:,:,1111))
  call heltable([8,4,32], n3(:,4567), t3x32(:,:,1112))
  call heltable([8,4,32], n3(:,4568), t3x32(:,:,1113))
  call heltable([8,4,32], n3(:,4569), t3x32(:,:,1114))
  call heltable([4,8,32], n3(:,4570), t3x32(:,:,1115))
  call heltable([4,8,32], n3(:,4571), t3x32(:,:,1116))
  call heltable([4,8,32], n3(:,4572), t3x32(:,:,1117))
  call heltable([4,8,32], n3(:,4573), t3x32(:,:,1118))
  call heltable([8,4,32], n3(:,4574), t3x32(:,:,1119))
  call heltable([8,4,32], n3(:,4575), t3x32(:,:,1120))
  call heltable([8,4,32], n3(:,4576), t3x32(:,:,1121))
  call heltable([8,4,32], n3(:,4577), t3x32(:,:,1122))
  call heltable([4,8,32], n3(:,4578), t3x32(:,:,1123))
  call heltable([4,8,32], n3(:,4579), t3x32(:,:,1124))
  call heltable([4,8,32], n3(:,4580), t3x32(:,:,1125))
  call heltable([4,8,32], n3(:,4581), t3x32(:,:,1126))
  call heltable([4,8,32], n3(:,4582), t3x32(:,:,1127))
  call heltable([4,8,32], n3(:,4583), t3x32(:,:,1128))
  call heltable([4,8,32], n3(:,4584), t3x32(:,:,1129))
  call heltable([4,8,32], n3(:,4585), t3x32(:,:,1130))
  call heltable([8,4,32], n3(:,4586), t3x32(:,:,1131))
  call heltable([4,8,32], n3(:,4587), t3x32(:,:,1132))
  call heltable([4,8,32], n3(:,4588), t3x32(:,:,1133))
  call heltable([8,4,32], n3(:,4589), t3x32(:,:,1134))
  call heltable([4,8,32], n3(:,4590), t3x32(:,:,1135))
  call heltable([8,4,32], n3(:,4591), t3x32(:,:,1136))
  call heltable([4,8,32], n3(:,4592), t3x32(:,:,1137))
  call heltable([8,4,32], n3(:,4593), t3x32(:,:,1138))
  call heltable([4,8,32], n3(:,4594), t3x32(:,:,1139))
  call heltable([2,16,32], n3(:,4595), t3x32(:,:,1140))
  call heltable([2,16,32], n3(:,4596), t3x32(:,:,1141))
  call heltable([2,16,32], n3(:,4597), t3x32(:,:,1142))
  call heltable([2,16,32], n3(:,4598), t3x32(:,:,1143))
  call heltable([16,2,32], n3(:,4599), t3x32(:,:,1144))
  call heltable([16,2,32], n3(:,4600), t3x32(:,:,1145))
  call heltable([16,2,32], n3(:,4601), t3x32(:,:,1146))
  call heltable([16,2,32], n3(:,4602), t3x32(:,:,1147))
  call heltable([2,16,32], n3(:,4603), t3x32(:,:,1148))
  call heltable([2,16,32], n3(:,4604), t3x32(:,:,1149))
  call heltable([2,16,32], n3(:,4605), t3x32(:,:,1150))
  call heltable([2,16,32], n3(:,4606), t3x32(:,:,1151))
  call heltable([16,2,32], n3(:,4607), t3x32(:,:,1152))
  call heltable([16,2,32], n3(:,4608), t3x32(:,:,1153))
  call heltable([16,2,32], n3(:,4609), t3x32(:,:,1154))
  call heltable([16,2,32], n3(:,4610), t3x32(:,:,1155))
  call heltable([4,8,32], n3(:,4611), t3x32(:,:,1156))
  call heltable([4,8,32], n3(:,4612), t3x32(:,:,1157))
  call heltable([4,8,32], n3(:,4613), t3x32(:,:,1158))
  call heltable([4,8,32], n3(:,4614), t3x32(:,:,1159))
  call heltable([8,4,32], n3(:,4615), t3x32(:,:,1160))
  call heltable([8,4,32], n3(:,4616), t3x32(:,:,1161))
  call heltable([8,4,32], n3(:,4617), t3x32(:,:,1162))
  call heltable([8,4,32], n3(:,4618), t3x32(:,:,1163))
  call heltable([4,8,32], n3(:,4619), t3x32(:,:,1164))
  call heltable([4,8,32], n3(:,4620), t3x32(:,:,1165))
  call heltable([4,8,32], n3(:,4621), t3x32(:,:,1166))
  call heltable([4,8,32], n3(:,4622), t3x32(:,:,1167))
  call heltable([8,4,32], n3(:,4623), t3x32(:,:,1168))
  call heltable([8,4,32], n3(:,4624), t3x32(:,:,1169))
  call heltable([8,4,32], n3(:,4625), t3x32(:,:,1170))
  call heltable([8,4,32], n3(:,4626), t3x32(:,:,1171))
  call heltable([4,8,32], n3(:,4627), t3x32(:,:,1172))
  call heltable([4,8,32], n3(:,4628), t3x32(:,:,1173))
  call heltable([4,8,32], n3(:,4629), t3x32(:,:,1174))
  call heltable([4,8,32], n3(:,4630), t3x32(:,:,1175))
  call heltable([8,4,32], n3(:,4631), t3x32(:,:,1176))
  call heltable([4,8,32], n3(:,4632), t3x32(:,:,1177))
  call heltable([4,8,32], n3(:,4633), t3x32(:,:,1178))
  call heltable([8,4,32], n3(:,4634), t3x32(:,:,1179))
  call heltable([4,8,32], n3(:,4635), t3x32(:,:,1180))
  call heltable([8,4,32], n3(:,4636), t3x32(:,:,1181))
  call heltable([4,8,32], n3(:,4637), t3x32(:,:,1182))
  call heltable([8,4,32], n3(:,4638), t3x32(:,:,1183))
  call heltable([4,8,32], n3(:,4639), t3x32(:,:,1184))
  call heltable([16,2,32], n3(:,4640), t3x32(:,:,1185))
  call heltable([16,2,32], n3(:,4641), t3x32(:,:,1186))
  call heltable([16,2,32], n3(:,4642), t3x32(:,:,1187))
  call heltable([16,2,32], n3(:,4643), t3x32(:,:,1188))
  call heltable([2,16,32], n3(:,4644), t3x32(:,:,1189))
  call heltable([2,16,32], n3(:,4645), t3x32(:,:,1190))
  call heltable([2,16,32], n3(:,4646), t3x32(:,:,1191))
  call heltable([2,16,32], n3(:,4647), t3x32(:,:,1192))
  call heltable([16,2,32], n3(:,4648), t3x32(:,:,1193))
  call heltable([16,2,32], n3(:,4649), t3x32(:,:,1194))
  call heltable([16,2,32], n3(:,4650), t3x32(:,:,1195))
  call heltable([16,2,32], n3(:,4651), t3x32(:,:,1196))
  call heltable([2,16,32], n3(:,4652), t3x32(:,:,1197))
  call heltable([2,16,32], n3(:,4653), t3x32(:,:,1198))
  call heltable([2,16,32], n3(:,4654), t3x32(:,:,1199))
  call heltable([2,16,32], n3(:,4655), t3x32(:,:,1200))
  call heltable([8,4,32], n3(:,4656), t3x32(:,:,1201))
  call heltable([8,4,32], n3(:,4657), t3x32(:,:,1202))
  call heltable([8,4,32], n3(:,4658), t3x32(:,:,1203))
  call heltable([8,4,32], n3(:,4659), t3x32(:,:,1204))
  call heltable([4,8,32], n3(:,4660), t3x32(:,:,1205))
  call heltable([4,8,32], n3(:,4661), t3x32(:,:,1206))
  call heltable([4,8,32], n3(:,4662), t3x32(:,:,1207))
  call heltable([4,8,32], n3(:,4663), t3x32(:,:,1208))
  call heltable([8,4,32], n3(:,4664), t3x32(:,:,1209))
  call heltable([8,4,32], n3(:,4665), t3x32(:,:,1210))
  call heltable([8,4,32], n3(:,4666), t3x32(:,:,1211))
  call heltable([8,4,32], n3(:,4667), t3x32(:,:,1212))
  call heltable([4,8,32], n3(:,4668), t3x32(:,:,1213))
  call heltable([4,8,32], n3(:,4669), t3x32(:,:,1214))
  call heltable([4,8,32], n3(:,4670), t3x32(:,:,1215))
  call heltable([4,8,32], n3(:,4671), t3x32(:,:,1216))
  call heltable([4,8,32], n3(:,4672), t3x32(:,:,1217))
  call heltable([4,8,32], n3(:,4673), t3x32(:,:,1218))
  call heltable([4,8,32], n3(:,4674), t3x32(:,:,1219))
  call heltable([4,8,32], n3(:,4675), t3x32(:,:,1220))
  call heltable([8,4,32], n3(:,4676), t3x32(:,:,1221))
  call heltable([4,8,32], n3(:,4677), t3x32(:,:,1222))
  call heltable([4,8,32], n3(:,4678), t3x32(:,:,1223))
  call heltable([8,4,32], n3(:,4679), t3x32(:,:,1224))
  call heltable([4,8,32], n3(:,4680), t3x32(:,:,1225))
  call heltable([8,4,32], n3(:,4681), t3x32(:,:,1226))
  call heltable([4,8,32], n3(:,4682), t3x32(:,:,1227))
  call heltable([8,4,32], n3(:,4683), t3x32(:,:,1228))
  call heltable([4,8,32], n3(:,4684), t3x32(:,:,1229))
  call heltable([2,16,32], n3(:,4685), t3x32(:,:,1230))
  call heltable([2,16,32], n3(:,4686), t3x32(:,:,1231))
  call heltable([2,16,32], n3(:,4687), t3x32(:,:,1232))
  call heltable([2,16,32], n3(:,4688), t3x32(:,:,1233))
  call heltable([16,2,32], n3(:,4689), t3x32(:,:,1234))
  call heltable([16,2,32], n3(:,4690), t3x32(:,:,1235))
  call heltable([16,2,32], n3(:,4691), t3x32(:,:,1236))
  call heltable([16,2,32], n3(:,4692), t3x32(:,:,1237))
  call heltable([2,16,32], n3(:,4693), t3x32(:,:,1238))
  call heltable([2,16,32], n3(:,4694), t3x32(:,:,1239))
  call heltable([2,16,32], n3(:,4695), t3x32(:,:,1240))
  call heltable([2,16,32], n3(:,4696), t3x32(:,:,1241))
  call heltable([16,2,32], n3(:,4697), t3x32(:,:,1242))
  call heltable([16,2,32], n3(:,4698), t3x32(:,:,1243))
  call heltable([16,2,32], n3(:,4699), t3x32(:,:,1244))
  call heltable([16,2,32], n3(:,4700), t3x32(:,:,1245))
  call heltable([4,8,32], n3(:,4701), t3x32(:,:,1246))
  call heltable([4,8,32], n3(:,4702), t3x32(:,:,1247))
  call heltable([4,8,32], n3(:,4703), t3x32(:,:,1248))
  call heltable([4,8,32], n3(:,4704), t3x32(:,:,1249))
  call heltable([8,4,32], n3(:,4705), t3x32(:,:,1250))
  call heltable([8,4,32], n3(:,4706), t3x32(:,:,1251))
  call heltable([8,4,32], n3(:,4707), t3x32(:,:,1252))
  call heltable([8,4,32], n3(:,4708), t3x32(:,:,1253))
  call heltable([4,8,32], n3(:,4709), t3x32(:,:,1254))
  call heltable([4,8,32], n3(:,4710), t3x32(:,:,1255))
  call heltable([4,8,32], n3(:,4711), t3x32(:,:,1256))
  call heltable([4,8,32], n3(:,4712), t3x32(:,:,1257))
  call heltable([8,4,32], n3(:,4713), t3x32(:,:,1258))
  call heltable([8,4,32], n3(:,4714), t3x32(:,:,1259))
  call heltable([8,4,32], n3(:,4715), t3x32(:,:,1260))
  call heltable([8,4,32], n3(:,4716), t3x32(:,:,1261))
  call heltable([4,8,32], n3(:,4717), t3x32(:,:,1262))
  call heltable([4,8,32], n3(:,4718), t3x32(:,:,1263))
  call heltable([4,8,32], n3(:,4719), t3x32(:,:,1264))
  call heltable([4,8,32], n3(:,4720), t3x32(:,:,1265))
  call heltable([8,4,32], n3(:,4721), t3x32(:,:,1266))
  call heltable([4,8,32], n3(:,4722), t3x32(:,:,1267))
  call heltable([4,8,32], n3(:,4723), t3x32(:,:,1268))
  call heltable([8,4,32], n3(:,4724), t3x32(:,:,1269))
  call heltable([4,8,32], n3(:,4725), t3x32(:,:,1270))
  call heltable([8,4,32], n3(:,4726), t3x32(:,:,1271))
  call heltable([4,8,32], n3(:,4727), t3x32(:,:,1272))
  call heltable([8,4,32], n3(:,4728), t3x32(:,:,1273))
  call heltable([4,8,32], n3(:,4729), t3x32(:,:,1274))
  call heltable([16,2,32], n3(:,4730), t3x32(:,:,1275))
  call heltable([16,2,32], n3(:,4731), t3x32(:,:,1276))
  call heltable([16,2,32], n3(:,4732), t3x32(:,:,1277))
  call heltable([16,2,32], n3(:,4733), t3x32(:,:,1278))
  call heltable([2,16,32], n3(:,4734), t3x32(:,:,1279))
  call heltable([2,16,32], n3(:,4735), t3x32(:,:,1280))
  call heltable([2,16,32], n3(:,4736), t3x32(:,:,1281))
  call heltable([2,16,32], n3(:,4737), t3x32(:,:,1282))
  call heltable([16,2,32], n3(:,4738), t3x32(:,:,1283))
  call heltable([16,2,32], n3(:,4739), t3x32(:,:,1284))
  call heltable([16,2,32], n3(:,4740), t3x32(:,:,1285))
  call heltable([16,2,32], n3(:,4741), t3x32(:,:,1286))
  call heltable([2,16,32], n3(:,4742), t3x32(:,:,1287))
  call heltable([2,16,32], n3(:,4743), t3x32(:,:,1288))
  call heltable([2,16,32], n3(:,4744), t3x32(:,:,1289))
  call heltable([2,16,32], n3(:,4745), t3x32(:,:,1290))
  call heltable([2,16,32], n3(:,4746), t3x32(:,:,1291))
  n2(1195) = 32
  call heltable([2,16,32], n3(:,4747), t3x32(:,:,1292))
  n2(1196) = 32
  call heltable([2,16,32], n3(:,4748), t3x32(:,:,1293))
  n2(1197) = 32
  call heltable([2,16,32], n3(:,4749), t3x32(:,:,1294))
  n2(1198) = 32
  call heltable([16,2,32], n3(:,4750), t3x32(:,:,1295))
  n2(1199) = 32
  call heltable([16,2,32], n3(:,4751), t3x32(:,:,1296))
  n2(1200) = 32
  call heltable([16,2,32], n3(:,4752), t3x32(:,:,1297))
  n2(1201) = 32
  call heltable([16,2,32], n3(:,4753), t3x32(:,:,1298))
  n2(1202) = 32
  call heltable([2,16,32], n3(:,4754), t3x32(:,:,1299))
  n2(1203) = 32
  call heltable([2,16,32], n3(:,4755), t3x32(:,:,1300))
  n2(1204) = 32
  call heltable([2,16,32], n3(:,4756), t3x32(:,:,1301))
  n2(1205) = 32
  call heltable([2,16,32], n3(:,4757), t3x32(:,:,1302))
  n2(1206) = 32
  call heltable([16,2,32], n3(:,4758), t3x32(:,:,1303))
  n2(1207) = 32
  call heltable([16,2,32], n3(:,4759), t3x32(:,:,1304))
  n2(1208) = 32
  call heltable([16,2,32], n3(:,4760), t3x32(:,:,1305))
  n2(1209) = 32
  call heltable([16,2,32], n3(:,4761), t3x32(:,:,1306))
  n2(1210) = 32
  call heltable([16,2,32], n3(:,4762), t3x32(:,:,1307))
  n2(1211) = 32
  call heltable([16,2,32], n3(:,4763), t3x32(:,:,1308))
  n2(1212) = 32
  call heltable([16,2,32], n3(:,4764), t3x32(:,:,1309))
  n2(1213) = 32
  call heltable([16,2,32], n3(:,4765), t3x32(:,:,1310))
  n2(1214) = 32
  call heltable([2,16,32], n3(:,4766), t3x32(:,:,1311))
  n2(1215) = 32
  call heltable([2,16,32], n3(:,4767), t3x32(:,:,1312))
  n2(1216) = 32
  call heltable([2,16,32], n3(:,4768), t3x32(:,:,1313))
  n2(1217) = 32
  call heltable([2,16,32], n3(:,4769), t3x32(:,:,1314))
  n2(1218) = 32
  call heltable([16,2,32], n3(:,4770), t3x32(:,:,1315))
  n2(1219) = 32
  call heltable([16,2,32], n3(:,4771), t3x32(:,:,1316))
  n2(1220) = 32
  call heltable([16,2,32], n3(:,4772), t3x32(:,:,1317))
  n2(1221) = 32
  call heltable([16,2,32], n3(:,4773), t3x32(:,:,1318))
  n2(1222) = 32
  call heltable([2,16,32], n3(:,4774), t3x32(:,:,1319))
  n2(1223) = 32
  call heltable([2,16,32], n3(:,4775), t3x32(:,:,1320))
  n2(1224) = 32
  call heltable([2,16,32], n3(:,4776), t3x32(:,:,1321))
  n2(1225) = 32
  call heltable([2,16,32], n3(:,4777), t3x32(:,:,1322))
  n2(1226) = 32
  call heltable([2,16,32], n3(:,4778), t3x32(:,:,1323))
  call heltable([2,16,32], n3(:,4779), t3x32(:,:,1324))
  call heltable([2,16,32], n3(:,4780), t3x32(:,:,1325))
  call heltable([2,16,32], n3(:,4781), t3x32(:,:,1326))
  call heltable([16,2,32], n3(:,4782), t3x32(:,:,1327))
  call heltable([16,2,32], n3(:,4783), t3x32(:,:,1328))
  call heltable([16,2,32], n3(:,4784), t3x32(:,:,1329))
  call heltable([16,2,32], n3(:,4785), t3x32(:,:,1330))
  call heltable([2,16,32], n3(:,4786), t3x32(:,:,1331))
  call heltable([2,16,32], n3(:,4787), t3x32(:,:,1332))
  call heltable([2,16,32], n3(:,4788), t3x32(:,:,1333))
  call heltable([2,16,32], n3(:,4789), t3x32(:,:,1334))
  call heltable([16,2,32], n3(:,4790), t3x32(:,:,1335))
  call heltable([16,2,32], n3(:,4791), t3x32(:,:,1336))
  call heltable([16,2,32], n3(:,4792), t3x32(:,:,1337))
  call heltable([16,2,32], n3(:,4793), t3x32(:,:,1338))
  call heltable([2,16,32], n3(:,4794), t3x32(:,:,1339))
  n2(1227) = 32
  call heltable([2,16,32], n3(:,4795), t3x32(:,:,1340))
  n2(1228) = 32
  call heltable([2,16,32], n3(:,4796), t3x32(:,:,1341))
  n2(1229) = 32
  call heltable([2,16,32], n3(:,4797), t3x32(:,:,1342))
  n2(1230) = 32
  call heltable([16,2,32], n3(:,4798), t3x32(:,:,1343))
  n2(1231) = 32
  call heltable([16,2,32], n3(:,4799), t3x32(:,:,1344))
  n2(1232) = 32
  call heltable([16,2,32], n3(:,4800), t3x32(:,:,1345))
  n2(1233) = 32
  call heltable([16,2,32], n3(:,4801), t3x32(:,:,1346))
  n2(1234) = 32
  call heltable([2,16,32], n3(:,4802), t3x32(:,:,1347))
  n2(1235) = 32
  call heltable([2,16,32], n3(:,4803), t3x32(:,:,1348))
  n2(1236) = 32
  call heltable([2,16,32], n3(:,4804), t3x32(:,:,1349))
  n2(1237) = 32
  call heltable([2,16,32], n3(:,4805), t3x32(:,:,1350))
  n2(1238) = 32
  call heltable([16,2,32], n3(:,4806), t3x32(:,:,1351))
  n2(1239) = 32
  call heltable([16,2,32], n3(:,4807), t3x32(:,:,1352))
  n2(1240) = 32
  call heltable([16,2,32], n3(:,4808), t3x32(:,:,1353))
  n2(1241) = 32
  call heltable([16,2,32], n3(:,4809), t3x32(:,:,1354))
  n2(1242) = 32
  call heltable([16,2,32], n3(:,4810), t3x32(:,:,1355))
  n2(1243) = 32
  call heltable([16,2,32], n3(:,4811), t3x32(:,:,1356))
  n2(1244) = 32
  call heltable([16,2,32], n3(:,4812), t3x32(:,:,1357))
  n2(1245) = 32
  call heltable([16,2,32], n3(:,4813), t3x32(:,:,1358))
  n2(1246) = 32
  call heltable([2,16,32], n3(:,4814), t3x32(:,:,1359))
  n2(1247) = 32
  call heltable([2,16,32], n3(:,4815), t3x32(:,:,1360))
  n2(1248) = 32
  call heltable([2,16,32], n3(:,4816), t3x32(:,:,1361))
  n2(1249) = 32
  call heltable([2,16,32], n3(:,4817), t3x32(:,:,1362))
  n2(1250) = 32
  call heltable([16,2,32], n3(:,4818), t3x32(:,:,1363))
  n2(1251) = 32
  call heltable([16,2,32], n3(:,4819), t3x32(:,:,1364))
  n2(1252) = 32
  call heltable([16,2,32], n3(:,4820), t3x32(:,:,1365))
  n2(1253) = 32
  call heltable([16,2,32], n3(:,4821), t3x32(:,:,1366))
  n2(1254) = 32
  call heltable([2,16,32], n3(:,4822), t3x32(:,:,1367))
  n2(1255) = 32
  call heltable([2,16,32], n3(:,4823), t3x32(:,:,1368))
  n2(1256) = 32
  call heltable([2,16,32], n3(:,4824), t3x32(:,:,1369))
  n2(1257) = 32
  call heltable([2,16,32], n3(:,4825), t3x32(:,:,1370))
  n2(1258) = 32
  call heltable([16,2,32], n3(:,4826), t3x32(:,:,1371))
  call heltable([16,2,32], n3(:,4827), t3x32(:,:,1372))
  call heltable([16,2,32], n3(:,4828), t3x32(:,:,1373))
  call heltable([16,2,32], n3(:,4829), t3x32(:,:,1374))
  call heltable([2,16,32], n3(:,4830), t3x32(:,:,1375))
  call heltable([2,16,32], n3(:,4831), t3x32(:,:,1376))
  call heltable([2,16,32], n3(:,4832), t3x32(:,:,1377))
  call heltable([2,16,32], n3(:,4833), t3x32(:,:,1378))
  call heltable([16,2,32], n3(:,4834), t3x32(:,:,1379))
  call heltable([16,2,32], n3(:,4835), t3x32(:,:,1380))
  call heltable([16,2,32], n3(:,4836), t3x32(:,:,1381))
  call heltable([16,2,32], n3(:,4837), t3x32(:,:,1382))
  call heltable([2,16,32], n3(:,4838), t3x32(:,:,1383))
  call heltable([2,16,32], n3(:,4839), t3x32(:,:,1384))
  call heltable([2,16,32], n3(:,4840), t3x32(:,:,1385))
  call heltable([2,16,32], n3(:,4841), t3x32(:,:,1386))
  call heltable([2,16,32], n3(:,4842), t3x32(:,:,1387))
  n2(1259) = 32
  call heltable([2,16,32], n3(:,4843), t3x32(:,:,1388))
  n2(1260) = 32
  call heltable([2,16,32], n3(:,4844), t3x32(:,:,1389))
  n2(1261) = 32
  call heltable([2,16,32], n3(:,4845), t3x32(:,:,1390))
  n2(1262) = 32
  call heltable([16,2,32], n3(:,4846), t3x32(:,:,1391))
  n2(1263) = 32
  call heltable([16,2,32], n3(:,4847), t3x32(:,:,1392))
  n2(1264) = 32
  call heltable([16,2,32], n3(:,4848), t3x32(:,:,1393))
  n2(1265) = 32
  call heltable([16,2,32], n3(:,4849), t3x32(:,:,1394))
  n2(1266) = 32
  call heltable([2,16,32], n3(:,4850), t3x32(:,:,1395))
  n2(1267) = 32
  call heltable([2,16,32], n3(:,4851), t3x32(:,:,1396))
  n2(1268) = 32
  call heltable([2,16,32], n3(:,4852), t3x32(:,:,1397))
  n2(1269) = 32
  call heltable([2,16,32], n3(:,4853), t3x32(:,:,1398))
  n2(1270) = 32
  call heltable([16,2,32], n3(:,4854), t3x32(:,:,1399))
  n2(1271) = 32
  call heltable([16,2,32], n3(:,4855), t3x32(:,:,1400))
  n2(1272) = 32
  call heltable([16,2,32], n3(:,4856), t3x32(:,:,1401))
  n2(1273) = 32
  call heltable([16,2,32], n3(:,4857), t3x32(:,:,1402))
  n2(1274) = 32
  call heltable([16,2,32], n3(:,4858), t3x32(:,:,1403))
  n2(1275) = 32
  call heltable([16,2,32], n3(:,4859), t3x32(:,:,1404))
  n2(1276) = 32
  call heltable([16,2,32], n3(:,4860), t3x32(:,:,1405))
  n2(1277) = 32
  call heltable([16,2,32], n3(:,4861), t3x32(:,:,1406))
  n2(1278) = 32
  call heltable([2,16,32], n3(:,4862), t3x32(:,:,1407))
  n2(1279) = 32
  call heltable([2,16,32], n3(:,4863), t3x32(:,:,1408))
  n2(1280) = 32
  call heltable([2,16,32], n3(:,4864), t3x32(:,:,1409))
  n2(1281) = 32
  call heltable([2,16,32], n3(:,4865), t3x32(:,:,1410))
  n2(1282) = 32
  call heltable([16,2,32], n3(:,4866), t3x32(:,:,1411))
  n2(1283) = 32
  call heltable([16,2,32], n3(:,4867), t3x32(:,:,1412))
  n2(1284) = 32
  call heltable([16,2,32], n3(:,4868), t3x32(:,:,1413))
  n2(1285) = 32
  call heltable([16,2,32], n3(:,4869), t3x32(:,:,1414))
  n2(1286) = 32
  call heltable([2,16,32], n3(:,4870), t3x32(:,:,1415))
  n2(1287) = 32
  call heltable([2,16,32], n3(:,4871), t3x32(:,:,1416))
  n2(1288) = 32
  call heltable([2,16,32], n3(:,4872), t3x32(:,:,1417))
  n2(1289) = 32
  call heltable([2,16,32], n3(:,4873), t3x32(:,:,1418))
  n2(1290) = 32
  call heltable([2,16,32], n3(:,4874), t3x32(:,:,1419))
  call heltable([2,16,32], n3(:,4875), t3x32(:,:,1420))
  call heltable([2,16,32], n3(:,4876), t3x32(:,:,1421))
  call heltable([2,16,32], n3(:,4877), t3x32(:,:,1422))
  call heltable([16,2,32], n3(:,4878), t3x32(:,:,1423))
  call heltable([16,2,32], n3(:,4879), t3x32(:,:,1424))
  call heltable([16,2,32], n3(:,4880), t3x32(:,:,1425))
  call heltable([16,2,32], n3(:,4881), t3x32(:,:,1426))
  call heltable([2,16,32], n3(:,4882), t3x32(:,:,1427))
  call heltable([2,16,32], n3(:,4883), t3x32(:,:,1428))
  call heltable([2,16,32], n3(:,4884), t3x32(:,:,1429))
  call heltable([2,16,32], n3(:,4885), t3x32(:,:,1430))
  call heltable([16,2,32], n3(:,4886), t3x32(:,:,1431))
  call heltable([16,2,32], n3(:,4887), t3x32(:,:,1432))
  call heltable([16,2,32], n3(:,4888), t3x32(:,:,1433))
  call heltable([16,2,32], n3(:,4889), t3x32(:,:,1434))
  call heltable([2,16,32], n3(:,4890), t3x32(:,:,1435))
  n2(1291) = 32
  call heltable([2,16,32], n3(:,4891), t3x32(:,:,1436))
  n2(1292) = 32
  call heltable([2,16,32], n3(:,4892), t3x32(:,:,1437))
  n2(1293) = 32
  call heltable([2,16,32], n3(:,4893), t3x32(:,:,1438))
  n2(1294) = 32
  call heltable([16,2,32], n3(:,4894), t3x32(:,:,1439))
  n2(1295) = 32
  call heltable([16,2,32], n3(:,4895), t3x32(:,:,1440))
  n2(1296) = 32
  call heltable([16,2,32], n3(:,4896), t3x32(:,:,1441))
  n2(1297) = 32
  call heltable([16,2,32], n3(:,4897), t3x32(:,:,1442))
  n2(1298) = 32
  call heltable([2,16,32], n3(:,4898), t3x32(:,:,1443))
  n2(1299) = 32
  call heltable([2,16,32], n3(:,4899), t3x32(:,:,1444))
  n2(1300) = 32
  call heltable([2,16,32], n3(:,4900), t3x32(:,:,1445))
  n2(1301) = 32
  call heltable([2,16,32], n3(:,4901), t3x32(:,:,1446))
  n2(1302) = 32
  call heltable([16,2,32], n3(:,4902), t3x32(:,:,1447))
  n2(1303) = 32
  call heltable([16,2,32], n3(:,4903), t3x32(:,:,1448))
  n2(1304) = 32
  call heltable([16,2,32], n3(:,4904), t3x32(:,:,1449))
  n2(1305) = 32
  call heltable([16,2,32], n3(:,4905), t3x32(:,:,1450))
  n2(1306) = 32
  call heltable([16,2,32], n3(:,4906), t3x32(:,:,1451))
  n2(1307) = 32
  call heltable([16,2,32], n3(:,4907), t3x32(:,:,1452))
  n2(1308) = 32
  call heltable([16,2,32], n3(:,4908), t3x32(:,:,1453))
  n2(1309) = 32
  call heltable([16,2,32], n3(:,4909), t3x32(:,:,1454))
  n2(1310) = 32
  call heltable([2,16,32], n3(:,4910), t3x32(:,:,1455))
  n2(1311) = 32
  call heltable([2,16,32], n3(:,4911), t3x32(:,:,1456))
  n2(1312) = 32
  call heltable([2,16,32], n3(:,4912), t3x32(:,:,1457))
  n2(1313) = 32
  call heltable([2,16,32], n3(:,4913), t3x32(:,:,1458))
  n2(1314) = 32
  call heltable([16,2,32], n3(:,4914), t3x32(:,:,1459))
  n2(1315) = 32
  call heltable([16,2,32], n3(:,4915), t3x32(:,:,1460))
  n2(1316) = 32
  call heltable([16,2,32], n3(:,4916), t3x32(:,:,1461))
  n2(1317) = 32
  call heltable([16,2,32], n3(:,4917), t3x32(:,:,1462))
  n2(1318) = 32
  call heltable([2,16,32], n3(:,4918), t3x32(:,:,1463))
  n2(1319) = 32
  call heltable([2,16,32], n3(:,4919), t3x32(:,:,1464))
  n2(1320) = 32
  call heltable([2,16,32], n3(:,4920), t3x32(:,:,1465))
  n2(1321) = 32
  call heltable([2,16,32], n3(:,4921), t3x32(:,:,1466))
  n2(1322) = 32
  call heltable([16,2,32], n3(:,4922), t3x32(:,:,1467))
  call heltable([16,2,32], n3(:,4923), t3x32(:,:,1468))
  call heltable([16,2,32], n3(:,4924), t3x32(:,:,1469))
  call heltable([16,2,32], n3(:,4925), t3x32(:,:,1470))
  call heltable([2,16,32], n3(:,4926), t3x32(:,:,1471))
  call heltable([2,16,32], n3(:,4927), t3x32(:,:,1472))
  call heltable([2,16,32], n3(:,4928), t3x32(:,:,1473))
  call heltable([2,16,32], n3(:,4929), t3x32(:,:,1474))
  call heltable([16,2,32], n3(:,4930), t3x32(:,:,1475))
  call heltable([16,2,32], n3(:,4931), t3x32(:,:,1476))
  call heltable([16,2,32], n3(:,4932), t3x32(:,:,1477))
  call heltable([16,2,32], n3(:,4933), t3x32(:,:,1478))
  call heltable([2,16,32], n3(:,4934), t3x32(:,:,1479))
  call heltable([2,16,32], n3(:,4935), t3x32(:,:,1480))
  call heltable([2,16,32], n3(:,4936), t3x32(:,:,1481))
  call heltable([2,16,32], n3(:,4937), t3x32(:,:,1482))
  call heltable([8,4,32], n3(:,4938), t3x32(:,:,1483))
  n2(1323) = 32
  call heltable([8,4,32], n3(:,4939), t3x32(:,:,1484))
  n2(1324) = 32
  call heltable([8,4,32], n3(:,4940), t3x32(:,:,1485))
  n2(1325) = 32
  call heltable([8,4,32], n3(:,4941), t3x32(:,:,1486))
  n2(1326) = 32
  call heltable([4,8,32], n3(:,4942), t3x32(:,:,1487))
  n2(1327) = 32
  call heltable([4,8,32], n3(:,4943), t3x32(:,:,1488))
  n2(1328) = 32
  call heltable([4,8,32], n3(:,4944), t3x32(:,:,1489))
  n2(1329) = 32
  call heltable([4,8,32], n3(:,4945), t3x32(:,:,1490))
  n2(1330) = 32
  call heltable([8,4,32], n3(:,4946), t3x32(:,:,1491))
  n2(1331) = 32
  call heltable([8,4,32], n3(:,4947), t3x32(:,:,1492))
  n2(1332) = 32
  call heltable([8,4,32], n3(:,4948), t3x32(:,:,1493))
  n2(1333) = 32
  call heltable([8,4,32], n3(:,4949), t3x32(:,:,1494))
  n2(1334) = 32
  call heltable([4,8,32], n3(:,4950), t3x32(:,:,1495))
  n2(1335) = 32
  call heltable([4,8,32], n3(:,4951), t3x32(:,:,1496))
  n2(1336) = 32
  call heltable([4,8,32], n3(:,4952), t3x32(:,:,1497))
  n2(1337) = 32
  call heltable([4,8,32], n3(:,4953), t3x32(:,:,1498))
  n2(1338) = 32
  call heltable([4,8,32], n3(:,4954), t3x32(:,:,1499))
  n2(1339) = 32
  call heltable([4,8,32], n3(:,4955), t3x32(:,:,1500))
  n2(1340) = 32
  call heltable([4,8,32], n3(:,4956), t3x32(:,:,1501))
  n2(1341) = 32
  call heltable([4,8,32], n3(:,4957), t3x32(:,:,1502))
  n2(1342) = 32
  call heltable([8,4,32], n3(:,4958), t3x32(:,:,1503))
  n2(1343) = 32
  call heltable([8,4,32], n3(:,4959), t3x32(:,:,1504))
  n2(1344) = 32
  call heltable([8,4,32], n3(:,4960), t3x32(:,:,1505))
  n2(1345) = 32
  call heltable([8,4,32], n3(:,4961), t3x32(:,:,1506))
  n2(1346) = 32
  call heltable([4,8,32], n3(:,4962), t3x32(:,:,1507))
  n2(1347) = 32
  call heltable([4,8,32], n3(:,4963), t3x32(:,:,1508))
  n2(1348) = 32
  call heltable([4,8,32], n3(:,4964), t3x32(:,:,1509))
  n2(1349) = 32
  call heltable([4,8,32], n3(:,4965), t3x32(:,:,1510))
  n2(1350) = 32
  call heltable([8,4,32], n3(:,4966), t3x32(:,:,1511))
  n2(1351) = 32
  call heltable([8,4,32], n3(:,4967), t3x32(:,:,1512))
  n2(1352) = 32
  call heltable([8,4,32], n3(:,4968), t3x32(:,:,1513))
  n2(1353) = 32
  call heltable([8,4,32], n3(:,4969), t3x32(:,:,1514))
  n2(1354) = 32
  call heltable([8,4,32], n3(:,4970), t3x32(:,:,1515))
  n2(1355) = 32
  call heltable([8,4,32], n3(:,4971), t3x32(:,:,1516))
  n2(1356) = 32
  call heltable([8,4,32], n3(:,4972), t3x32(:,:,1517))
  n2(1357) = 32
  call heltable([8,4,32], n3(:,4973), t3x32(:,:,1518))
  n2(1358) = 32
  call heltable([8,4,32], n3(:,4974), t3x32(:,:,1519))
  n2(1359) = 32
  call heltable([8,4,32], n3(:,4975), t3x32(:,:,1520))
  n2(1360) = 32
  call heltable([8,4,32], n3(:,4976), t3x32(:,:,1521))
  n2(1361) = 32
  call heltable([8,4,32], n3(:,4977), t3x32(:,:,1522))
  n2(1362) = 32
  call heltable([4,8,32], n3(:,4978), t3x32(:,:,1523))
  n2(1363) = 32
  call heltable([4,8,32], n3(:,4979), t3x32(:,:,1524))
  n2(1364) = 32
  call heltable([4,8,32], n3(:,4980), t3x32(:,:,1525))
  n2(1365) = 32
  call heltable([4,8,32], n3(:,4981), t3x32(:,:,1526))
  n2(1366) = 32
  call heltable([4,8,32], n3(:,4982), t3x32(:,:,1527))
  n2(1367) = 32
  call heltable([4,8,32], n3(:,4983), t3x32(:,:,1528))
  n2(1368) = 32
  call heltable([4,8,32], n3(:,4984), t3x32(:,:,1529))
  n2(1369) = 32
  call heltable([4,8,32], n3(:,4985), t3x32(:,:,1530))
  n2(1370) = 32
  call heltable([4,8,32], n3(:,4986), t3x32(:,:,1531))
  n2(1371) = 32
  call heltable([4,8,32], n3(:,4987), t3x32(:,:,1532))
  n2(1372) = 32
  call heltable([4,8,32], n3(:,4988), t3x32(:,:,1533))
  n2(1373) = 32
  call heltable([4,8,32], n3(:,4989), t3x32(:,:,1534))
  n2(1374) = 32
  call heltable([4,8,32], n3(:,4990), t3x32(:,:,1535))
  n2(1375) = 32
  call heltable([4,8,32], n3(:,4991), t3x32(:,:,1536))
  n2(1376) = 32
  call heltable([4,8,32], n3(:,4992), t3x32(:,:,1537))
  n2(1377) = 32
  call heltable([4,8,32], n3(:,4993), t3x32(:,:,1538))
  n2(1378) = 32
  call heltable([8,4,32], n3(:,4994), t3x32(:,:,1539))
  n2(1379) = 32
  call heltable([8,4,32], n3(:,4995), t3x32(:,:,1540))
  n2(1380) = 32
  call heltable([8,4,32], n3(:,4996), t3x32(:,:,1541))
  n2(1381) = 32
  call heltable([8,4,32], n3(:,4997), t3x32(:,:,1542))
  n2(1382) = 32
  call heltable([8,4,32], n3(:,4998), t3x32(:,:,1543))
  n2(1383) = 32
  call heltable([8,4,32], n3(:,4999), t3x32(:,:,1544))
  n2(1384) = 32
  call heltable([8,4,32], n3(:,5000), t3x32(:,:,1545))
  n2(1385) = 32
  call heltable([8,4,32], n3(:,5001), t3x32(:,:,1546))
  n2(1386) = 32
  call heltable([2,16,32], n3(:,5002), t3x32(:,:,1547))
  n2(1387) = 32
  call heltable([2,16,32], n3(:,5003), t3x32(:,:,1548))
  n2(1388) = 32
  call heltable([2,16,32], n3(:,5004), t3x32(:,:,1549))
  n2(1389) = 32
  call heltable([2,16,32], n3(:,5005), t3x32(:,:,1550))
  n2(1390) = 32
  call heltable([16,2,32], n3(:,5006), t3x32(:,:,1551))
  n2(1391) = 32
  call heltable([16,2,32], n3(:,5007), t3x32(:,:,1552))
  n2(1392) = 32
  call heltable([2,16,32], n3(:,5008), t3x32(:,:,1553))
  n2(1393) = 32
  call heltable([2,16,32], n3(:,5009), t3x32(:,:,1554))
  n2(1394) = 32
  call heltable([16,2,32], n3(:,5010), t3x32(:,:,1555))
  n2(1395) = 32
  call heltable([2,16,32], n3(:,5011), t3x32(:,:,1556))
  n2(1396) = 32
  call heltable([2,16,32], n3(:,5012), t3x32(:,:,1557))
  n2(1397) = 32
  call heltable([16,2,32], n3(:,5013), t3x32(:,:,1558))
  n2(1398) = 32
  call heltable([2,16,32], n3(:,5014), t3x32(:,:,1559))
  n2(1399) = 32
  call heltable([16,2,32], n3(:,5015), t3x32(:,:,1560))
  n2(1400) = 32
  call heltable([16,2,32], n3(:,5016), t3x32(:,:,1561))
  n2(1401) = 32
  call heltable([16,2,32], n3(:,5017), t3x32(:,:,1562))
  n2(1402) = 32
  call heltable([16,2,32], n3(:,5018), t3x32(:,:,1563))
  n2(1403) = 32
  call heltable([2,16,32], n3(:,5019), t3x32(:,:,1564))
  n2(1404) = 32
  call heltable([2,16,32], n3(:,5020), t3x32(:,:,1565))
  n2(1405) = 32
  call heltable([16,2,32], n3(:,5021), t3x32(:,:,1566))
  n2(1406) = 32
  call heltable([16,2,32], n3(:,5022), t3x32(:,:,1567))
  n2(1407) = 32
  call heltable([2,16,32], n3(:,5023), t3x32(:,:,1568))
  n2(1408) = 32
  call heltable([16,2,32], n3(:,5024), t3x32(:,:,1569))
  n2(1409) = 32
  call heltable([16,2,32], n3(:,5025), t3x32(:,:,1570))
  n2(1410) = 32
  call heltable([2,16,32], n3(:,5026), t3x32(:,:,1571))
  n2(1411) = 32
  call heltable([16,2,32], n3(:,5027), t3x32(:,:,1572))
  n2(1412) = 32
  call heltable([8,4,32], n3(:,5028), t3x32(:,:,1573))
  n2(1413) = 32
  call heltable([8,4,32], n3(:,5029), t3x32(:,:,1574))
  n2(1414) = 32
  call heltable([8,4,32], n3(:,5030), t3x32(:,:,1575))
  n2(1415) = 32
  call heltable([8,4,32], n3(:,5031), t3x32(:,:,1576))
  n2(1416) = 32
  call heltable([4,8,32], n3(:,5032), t3x32(:,:,1577))
  n2(1417) = 32
  call heltable([4,8,32], n3(:,5033), t3x32(:,:,1578))
  n2(1418) = 32
  call heltable([4,8,32], n3(:,5034), t3x32(:,:,1579))
  n2(1419) = 32
  call heltable([4,8,32], n3(:,5035), t3x32(:,:,1580))
  n2(1420) = 32
  call heltable([8,4,32], n3(:,5036), t3x32(:,:,1581))
  n2(1421) = 32
  call heltable([8,4,32], n3(:,5037), t3x32(:,:,1582))
  n2(1422) = 32
  call heltable([8,4,32], n3(:,5038), t3x32(:,:,1583))
  n2(1423) = 32
  call heltable([8,4,32], n3(:,5039), t3x32(:,:,1584))
  n2(1424) = 32
  call heltable([4,8,32], n3(:,5040), t3x32(:,:,1585))
  n2(1425) = 32
  call heltable([4,8,32], n3(:,5041), t3x32(:,:,1586))
  n2(1426) = 32
  call heltable([4,8,32], n3(:,5042), t3x32(:,:,1587))
  n2(1427) = 32
  call heltable([4,8,32], n3(:,5043), t3x32(:,:,1588))
  n2(1428) = 32
  call heltable([8,4,32], n3(:,5044), t3x32(:,:,1589))
  n2(1429) = 32
  call heltable([8,4,32], n3(:,5045), t3x32(:,:,1590))
  n2(1430) = 32
  call heltable([8,4,32], n3(:,5046), t3x32(:,:,1591))
  n2(1431) = 32
  call heltable([8,4,32], n3(:,5047), t3x32(:,:,1592))
  n2(1432) = 32
  call heltable([4,8,32], n3(:,5048), t3x32(:,:,1593))
  n2(1433) = 32
  call heltable([4,8,32], n3(:,5049), t3x32(:,:,1594))
  n2(1434) = 32
  call heltable([4,8,32], n3(:,5050), t3x32(:,:,1595))
  n2(1435) = 32
  call heltable([4,8,32], n3(:,5051), t3x32(:,:,1596))
  n2(1436) = 32
  call heltable([8,4,32], n3(:,5052), t3x32(:,:,1597))
  n2(1437) = 32
  call heltable([8,4,32], n3(:,5053), t3x32(:,:,1598))
  n2(1438) = 32
  call heltable([8,4,32], n3(:,5054), t3x32(:,:,1599))
  n2(1439) = 32
  call heltable([8,4,32], n3(:,5055), t3x32(:,:,1600))
  n2(1440) = 32
  call heltable([4,8,32], n3(:,5056), t3x32(:,:,1601))
  n2(1441) = 32
  call heltable([4,8,32], n3(:,5057), t3x32(:,:,1602))
  n2(1442) = 32
  call heltable([4,8,32], n3(:,5058), t3x32(:,:,1603))
  n2(1443) = 32
  call heltable([4,8,32], n3(:,5059), t3x32(:,:,1604))
  n2(1444) = 32
  call heltable([2,16,32], n3(:,5060), t3x32(:,:,1605))
  n2(1445) = 32
  call heltable([2,16,32], n3(:,5061), t3x32(:,:,1606))
  n2(1446) = 32
  call heltable([2,16,32], n3(:,5062), t3x32(:,:,1607))
  n2(1447) = 32
  call heltable([2,16,32], n3(:,5063), t3x32(:,:,1608))
  n2(1448) = 32
  call heltable([2,16,32], n3(:,5064), t3x32(:,:,1609))
  n2(1449) = 32
  call heltable([2,16,32], n3(:,5065), t3x32(:,:,1610))
  n2(1450) = 32
  call heltable([2,16,32], n3(:,5066), t3x32(:,:,1611))
  n2(1451) = 32
  call heltable([2,16,32], n3(:,5067), t3x32(:,:,1612))
  n2(1452) = 32
  call heltable([2,16,32], n3(:,5068), t3x32(:,:,1613))
  n2(1453) = 32
  call heltable([16,2,32], n3(:,5069), t3x32(:,:,1614))
  n2(1454) = 32
  call heltable([16,2,32], n3(:,5070), t3x32(:,:,1615))
  n2(1455) = 32
  call heltable([16,2,32], n3(:,5071), t3x32(:,:,1616))
  n2(1456) = 32
  call heltable([16,2,32], n3(:,5072), t3x32(:,:,1617))
  n2(1457) = 32
  call heltable([4,8,32], n3(:,5073), t3x32(:,:,1618))
  n2(1458) = 32
  call heltable([4,8,32], n3(:,5074), t3x32(:,:,1619))
  n2(1459) = 32
  call heltable([4,8,32], n3(:,5075), t3x32(:,:,1620))
  n2(1460) = 32
  call heltable([4,8,32], n3(:,5076), t3x32(:,:,1621))
  n2(1461) = 32
  call heltable([8,4,32], n3(:,5077), t3x32(:,:,1622))
  n2(1462) = 32
  call heltable([8,4,32], n3(:,5078), t3x32(:,:,1623))
  n2(1463) = 32
  call heltable([8,4,32], n3(:,5079), t3x32(:,:,1624))
  n2(1464) = 32
  call heltable([8,4,32], n3(:,5080), t3x32(:,:,1625))
  n2(1465) = 32
  call heltable([4,8,32], n3(:,5081), t3x32(:,:,1626))
  n2(1466) = 32
  call heltable([4,8,32], n3(:,5082), t3x32(:,:,1627))
  n2(1467) = 32
  call heltable([4,8,32], n3(:,5083), t3x32(:,:,1628))
  n2(1468) = 32
  call heltable([4,8,32], n3(:,5084), t3x32(:,:,1629))
  n2(1469) = 32
  call heltable([8,4,32], n3(:,5085), t3x32(:,:,1630))
  n2(1470) = 32
  call heltable([8,4,32], n3(:,5086), t3x32(:,:,1631))
  n2(1471) = 32
  call heltable([8,4,32], n3(:,5087), t3x32(:,:,1632))
  n2(1472) = 32
  call heltable([8,4,32], n3(:,5088), t3x32(:,:,1633))
  n2(1473) = 32
  call heltable([4,8,32], n3(:,5089), t3x32(:,:,1634))
  n2(1474) = 32
  call heltable([4,8,32], n3(:,5090), t3x32(:,:,1635))
  n2(1475) = 32
  call heltable([4,8,32], n3(:,5091), t3x32(:,:,1636))
  n2(1476) = 32
  call heltable([4,8,32], n3(:,5092), t3x32(:,:,1637))
  n2(1477) = 32
  call heltable([4,8,32], n3(:,5093), t3x32(:,:,1638))
  n2(1478) = 32
  call heltable([4,8,32], n3(:,5094), t3x32(:,:,1639))
  n2(1479) = 32
  call heltable([4,8,32], n3(:,5095), t3x32(:,:,1640))
  n2(1480) = 32
  call heltable([4,8,32], n3(:,5096), t3x32(:,:,1641))
  n2(1481) = 32
  call heltable([8,4,32], n3(:,5097), t3x32(:,:,1642))
  n2(1482) = 32
  call heltable([8,4,32], n3(:,5098), t3x32(:,:,1643))
  n2(1483) = 32
  call heltable([8,4,32], n3(:,5099), t3x32(:,:,1644))
  n2(1484) = 32
  call heltable([8,4,32], n3(:,5100), t3x32(:,:,1645))
  n2(1485) = 32
  call heltable([8,4,32], n3(:,5101), t3x32(:,:,1646))
  n2(1486) = 32
  call heltable([8,4,32], n3(:,5102), t3x32(:,:,1647))
  n2(1487) = 32
  call heltable([8,4,32], n3(:,5103), t3x32(:,:,1648))
  n2(1488) = 32
  call heltable([8,4,32], n3(:,5104), t3x32(:,:,1649))
  n2(1489) = 32
  call heltable([16,2,32], n3(:,5105), t3x32(:,:,1650))
  n2(1490) = 32
  call heltable([16,2,32], n3(:,5106), t3x32(:,:,1651))
  n2(1491) = 32
  call heltable([16,2,32], n3(:,5107), t3x32(:,:,1652))
  n2(1492) = 32
  call heltable([16,2,32], n3(:,5108), t3x32(:,:,1653))
  n2(1493) = 32
  call heltable([16,2,32], n3(:,5109), t3x32(:,:,1654))
  n2(1494) = 32
  call heltable([16,2,32], n3(:,5110), t3x32(:,:,1655))
  n2(1495) = 32
  call heltable([2,16,32], n3(:,5111), t3x32(:,:,1656))
  n2(1496) = 32
  call heltable([2,16,32], n3(:,5112), t3x32(:,:,1657))
  n2(1497) = 32
  call heltable([2,16,32], n3(:,5113), t3x32(:,:,1658))
  n2(1498) = 32
  call heltable([16,2,32], n3(:,5114), t3x32(:,:,1659))
  n2(1499) = 32
  call heltable([16,2,32], n3(:,5115), t3x32(:,:,1660))
  n2(1500) = 32
  call heltable([16,2,32], n3(:,5116), t3x32(:,:,1661))
  n2(1501) = 32
  call heltable([2,16,32], n3(:,5117), t3x32(:,:,1662))
  n2(1502) = 32
  call heltable([4,8,32], n3(:,5118), t3x32(:,:,1663))
  call heltable([4,8,32], n3(:,5119), t3x32(:,:,1664))
  call heltable([4,8,32], n3(:,5120), t3x32(:,:,1665))
  call heltable([4,8,32], n3(:,5121), t3x32(:,:,1666))
  call heltable([8,4,32], n3(:,5122), t3x32(:,:,1667))
  call heltable([4,8,32], n3(:,5123), t3x32(:,:,1668))
  call heltable([4,8,32], n3(:,5124), t3x32(:,:,1669))
  call heltable([8,4,32], n3(:,5125), t3x32(:,:,1670))
  call heltable([4,8,32], n3(:,5126), t3x32(:,:,1671))
  call heltable([8,4,32], n3(:,5127), t3x32(:,:,1672))
  call heltable([4,8,32], n3(:,5128), t3x32(:,:,1673))
  call heltable([8,4,32], n3(:,5129), t3x32(:,:,1674))
  call heltable([4,8,32], n3(:,5130), t3x32(:,:,1675))
  call heltable([8,4,32], n3(:,5131), t3x32(:,:,1676))
  call heltable([8,4,32], n3(:,5132), t3x32(:,:,1677))
  call heltable([8,4,32], n3(:,5133), t3x32(:,:,1678))
  call heltable([8,4,32], n3(:,5134), t3x32(:,:,1679))
  call heltable([4,8,32], n3(:,5135), t3x32(:,:,1680))
  call heltable([4,8,32], n3(:,5136), t3x32(:,:,1681))
  call heltable([4,8,32], n3(:,5137), t3x32(:,:,1682))
  call heltable([4,8,32], n3(:,5138), t3x32(:,:,1683))
  call heltable([8,4,32], n3(:,5139), t3x32(:,:,1684))
  call heltable([8,4,32], n3(:,5140), t3x32(:,:,1685))
  call heltable([8,4,32], n3(:,5141), t3x32(:,:,1686))
  call heltable([8,4,32], n3(:,5142), t3x32(:,:,1687))
  call heltable([4,8,32], n3(:,5143), t3x32(:,:,1688))
  call heltable([4,8,32], n3(:,5144), t3x32(:,:,1689))
  call heltable([4,8,32], n3(:,5145), t3x32(:,:,1690))
  call heltable([4,8,32], n3(:,5146), t3x32(:,:,1691))
  call heltable([2,16,32], n3(:,5147), t3x32(:,:,1692))
  call heltable([2,16,32], n3(:,5148), t3x32(:,:,1693))
  call heltable([2,16,32], n3(:,5149), t3x32(:,:,1694))
  call heltable([2,16,32], n3(:,5150), t3x32(:,:,1695))
  call heltable([16,2,32], n3(:,5151), t3x32(:,:,1696))
  call heltable([16,2,32], n3(:,5152), t3x32(:,:,1697))
  call heltable([16,2,32], n3(:,5153), t3x32(:,:,1698))
  call heltable([16,2,32], n3(:,5154), t3x32(:,:,1699))
  call heltable([2,16,32], n3(:,5155), t3x32(:,:,1700))
  call heltable([2,16,32], n3(:,5156), t3x32(:,:,1701))
  call heltable([2,16,32], n3(:,5157), t3x32(:,:,1702))
  call heltable([2,16,32], n3(:,5158), t3x32(:,:,1703))
  call heltable([16,2,32], n3(:,5159), t3x32(:,:,1704))
  call heltable([16,2,32], n3(:,5160), t3x32(:,:,1705))
  call heltable([16,2,32], n3(:,5161), t3x32(:,:,1706))
  call heltable([16,2,32], n3(:,5162), t3x32(:,:,1707))
  call heltable([4,8,32], n3(:,5163), t3x32(:,:,1708))
  call heltable([4,8,32], n3(:,5164), t3x32(:,:,1709))
  call heltable([4,8,32], n3(:,5165), t3x32(:,:,1710))
  call heltable([4,8,32], n3(:,5166), t3x32(:,:,1711))
  call heltable([8,4,32], n3(:,5167), t3x32(:,:,1712))
  call heltable([8,4,32], n3(:,5168), t3x32(:,:,1713))
  call heltable([8,4,32], n3(:,5169), t3x32(:,:,1714))
  call heltable([8,4,32], n3(:,5170), t3x32(:,:,1715))
  call heltable([4,8,32], n3(:,5171), t3x32(:,:,1716))
  call heltable([4,8,32], n3(:,5172), t3x32(:,:,1717))
  call heltable([4,8,32], n3(:,5173), t3x32(:,:,1718))
  call heltable([4,8,32], n3(:,5174), t3x32(:,:,1719))
  call heltable([8,4,32], n3(:,5175), t3x32(:,:,1720))
  call heltable([8,4,32], n3(:,5176), t3x32(:,:,1721))
  call heltable([8,4,32], n3(:,5177), t3x32(:,:,1722))
  call heltable([8,4,32], n3(:,5178), t3x32(:,:,1723))
  call heltable([4,8,32], n3(:,5179), t3x32(:,:,1724))
  call heltable([4,8,32], n3(:,5180), t3x32(:,:,1725))
  call heltable([4,8,32], n3(:,5181), t3x32(:,:,1726))
  call heltable([4,8,32], n3(:,5182), t3x32(:,:,1727))
  call heltable([4,8,32], n3(:,5183), t3x32(:,:,1728))
  call heltable([8,4,32], n3(:,5184), t3x32(:,:,1729))
  call heltable([8,4,32], n3(:,5185), t3x32(:,:,1730))
  call heltable([4,8,32], n3(:,5186), t3x32(:,:,1731))
  call heltable([8,4,32], n3(:,5187), t3x32(:,:,1732))
  call heltable([4,8,32], n3(:,5188), t3x32(:,:,1733))
  call heltable([8,4,32], n3(:,5189), t3x32(:,:,1734))
  call heltable([4,8,32], n3(:,5190), t3x32(:,:,1735))
  call heltable([4,8,32], n3(:,5191), t3x32(:,:,1736))
  call heltable([16,2,32], n3(:,5192), t3x32(:,:,1737))
  call heltable([16,2,32], n3(:,5193), t3x32(:,:,1738))
  call heltable([16,2,32], n3(:,5194), t3x32(:,:,1739))
  call heltable([16,2,32], n3(:,5195), t3x32(:,:,1740))
  call heltable([16,2,32], n3(:,5196), t3x32(:,:,1741))
  call heltable([16,2,32], n3(:,5197), t3x32(:,:,1742))
  call heltable([16,2,32], n3(:,5198), t3x32(:,:,1743))
  call heltable([16,2,32], n3(:,5199), t3x32(:,:,1744))
  call heltable([2,16,32], n3(:,5200), t3x32(:,:,1745))
  call heltable([2,16,32], n3(:,5201), t3x32(:,:,1746))
  call heltable([2,16,32], n3(:,5202), t3x32(:,:,1747))
  call heltable([2,16,32], n3(:,5203), t3x32(:,:,1748))
  call heltable([2,16,32], n3(:,5204), t3x32(:,:,1749))
  call heltable([2,16,32], n3(:,5205), t3x32(:,:,1750))
  call heltable([2,16,32], n3(:,5206), t3x32(:,:,1751))
  call heltable([2,16,32], n3(:,5207), t3x32(:,:,1752))
  call heltable([8,4,32], n3(:,5208), t3x32(:,:,1753))
  call heltable([8,4,32], n3(:,5209), t3x32(:,:,1754))
  call heltable([8,4,32], n3(:,5210), t3x32(:,:,1755))
  call heltable([8,4,32], n3(:,5211), t3x32(:,:,1756))
  call heltable([4,8,32], n3(:,5212), t3x32(:,:,1757))
  call heltable([4,8,32], n3(:,5213), t3x32(:,:,1758))
  call heltable([4,8,32], n3(:,5214), t3x32(:,:,1759))
  call heltable([4,8,32], n3(:,5215), t3x32(:,:,1760))
  call heltable([8,4,32], n3(:,5216), t3x32(:,:,1761))
  call heltable([8,4,32], n3(:,5217), t3x32(:,:,1762))
  call heltable([8,4,32], n3(:,5218), t3x32(:,:,1763))
  call heltable([8,4,32], n3(:,5219), t3x32(:,:,1764))
  call heltable([4,8,32], n3(:,5220), t3x32(:,:,1765))
  call heltable([4,8,32], n3(:,5221), t3x32(:,:,1766))
  call heltable([4,8,32], n3(:,5222), t3x32(:,:,1767))
  call heltable([4,8,32], n3(:,5223), t3x32(:,:,1768))
  call heltable([4,8,32], n3(:,5224), t3x32(:,:,1769))
  call heltable([4,8,32], n3(:,5225), t3x32(:,:,1770))
  call heltable([4,8,32], n3(:,5226), t3x32(:,:,1771))
  call heltable([4,8,32], n3(:,5227), t3x32(:,:,1772))
  call heltable([8,4,32], n3(:,5228), t3x32(:,:,1773))
  call heltable([4,8,32], n3(:,5229), t3x32(:,:,1774))
  call heltable([4,8,32], n3(:,5230), t3x32(:,:,1775))
  call heltable([8,4,32], n3(:,5231), t3x32(:,:,1776))
  call heltable([4,8,32], n3(:,5232), t3x32(:,:,1777))
  call heltable([8,4,32], n3(:,5233), t3x32(:,:,1778))
  call heltable([4,8,32], n3(:,5234), t3x32(:,:,1779))
  call heltable([8,4,32], n3(:,5235), t3x32(:,:,1780))
  call heltable([4,8,32], n3(:,5236), t3x32(:,:,1781))
  call heltable([2,16,32], n3(:,5237), t3x32(:,:,1782))
  call heltable([2,16,32], n3(:,5238), t3x32(:,:,1783))
  call heltable([2,16,32], n3(:,5239), t3x32(:,:,1784))
  call heltable([2,16,32], n3(:,5240), t3x32(:,:,1785))
  call heltable([16,2,32], n3(:,5241), t3x32(:,:,1786))
  call heltable([16,2,32], n3(:,5242), t3x32(:,:,1787))
  call heltable([16,2,32], n3(:,5243), t3x32(:,:,1788))
  call heltable([16,2,32], n3(:,5244), t3x32(:,:,1789))
  call heltable([2,16,32], n3(:,5245), t3x32(:,:,1790))
  call heltable([2,16,32], n3(:,5246), t3x32(:,:,1791))
  call heltable([2,16,32], n3(:,5247), t3x32(:,:,1792))
  call heltable([2,16,32], n3(:,5248), t3x32(:,:,1793))
  call heltable([16,2,32], n3(:,5249), t3x32(:,:,1794))
  call heltable([16,2,32], n3(:,5250), t3x32(:,:,1795))
  call heltable([16,2,32], n3(:,5251), t3x32(:,:,1796))
  call heltable([16,2,32], n3(:,5252), t3x32(:,:,1797))
  call heltable([4,8,32], n3(:,5253), t3x32(:,:,1798))
  call heltable([4,8,32], n3(:,5254), t3x32(:,:,1799))
  call heltable([4,8,32], n3(:,5255), t3x32(:,:,1800))
  call heltable([4,8,32], n3(:,5256), t3x32(:,:,1801))
  call heltable([8,4,32], n3(:,5257), t3x32(:,:,1802))
  call heltable([8,4,32], n3(:,5258), t3x32(:,:,1803))
  call heltable([8,4,32], n3(:,5259), t3x32(:,:,1804))
  call heltable([8,4,32], n3(:,5260), t3x32(:,:,1805))
  call heltable([4,8,32], n3(:,5261), t3x32(:,:,1806))
  call heltable([4,8,32], n3(:,5262), t3x32(:,:,1807))
  call heltable([4,8,32], n3(:,5263), t3x32(:,:,1808))
  call heltable([4,8,32], n3(:,5264), t3x32(:,:,1809))
  call heltable([8,4,32], n3(:,5265), t3x32(:,:,1810))
  call heltable([8,4,32], n3(:,5266), t3x32(:,:,1811))
  call heltable([8,4,32], n3(:,5267), t3x32(:,:,1812))
  call heltable([8,4,32], n3(:,5268), t3x32(:,:,1813))
  call heltable([4,8,32], n3(:,5269), t3x32(:,:,1814))
  call heltable([4,8,32], n3(:,5270), t3x32(:,:,1815))
  call heltable([4,8,32], n3(:,5271), t3x32(:,:,1816))
  call heltable([4,8,32], n3(:,5272), t3x32(:,:,1817))
  call heltable([8,4,32], n3(:,5273), t3x32(:,:,1818))
  call heltable([4,8,32], n3(:,5274), t3x32(:,:,1819))
  call heltable([4,8,32], n3(:,5275), t3x32(:,:,1820))
  call heltable([8,4,32], n3(:,5276), t3x32(:,:,1821))
  call heltable([4,8,32], n3(:,5277), t3x32(:,:,1822))
  call heltable([8,4,32], n3(:,5278), t3x32(:,:,1823))
  call heltable([4,8,32], n3(:,5279), t3x32(:,:,1824))
  call heltable([8,4,32], n3(:,5280), t3x32(:,:,1825))
  call heltable([4,8,32], n3(:,5281), t3x32(:,:,1826))
  call heltable([16,2,32], n3(:,5282), t3x32(:,:,1827))
  call heltable([16,2,32], n3(:,5283), t3x32(:,:,1828))
  call heltable([16,2,32], n3(:,5284), t3x32(:,:,1829))
  call heltable([16,2,32], n3(:,5285), t3x32(:,:,1830))
  call heltable([2,16,32], n3(:,5286), t3x32(:,:,1831))
  call heltable([2,16,32], n3(:,5287), t3x32(:,:,1832))
  call heltable([2,16,32], n3(:,5288), t3x32(:,:,1833))
  call heltable([2,16,32], n3(:,5289), t3x32(:,:,1834))
  call heltable([16,2,32], n3(:,5290), t3x32(:,:,1835))
  call heltable([16,2,32], n3(:,5291), t3x32(:,:,1836))
  call heltable([16,2,32], n3(:,5292), t3x32(:,:,1837))
  call heltable([16,2,32], n3(:,5293), t3x32(:,:,1838))
  call heltable([2,16,32], n3(:,5294), t3x32(:,:,1839))
  call heltable([2,16,32], n3(:,5295), t3x32(:,:,1840))
  call heltable([2,16,32], n3(:,5296), t3x32(:,:,1841))
  call heltable([2,16,32], n3(:,5297), t3x32(:,:,1842))
  call heltable([2,16,32], n3(:,5298), t3x32(:,:,1843))
  n2(1503) = 32
  call heltable([2,16,32], n3(:,5299), t3x32(:,:,1844))
  n2(1504) = 32
  call heltable([2,16,32], n3(:,5300), t3x32(:,:,1845))
  n2(1505) = 32
  call heltable([2,16,32], n3(:,5301), t3x32(:,:,1846))
  n2(1506) = 32
  call heltable([16,2,32], n3(:,5302), t3x32(:,:,1847))
  n2(1507) = 32
  call heltable([16,2,32], n3(:,5303), t3x32(:,:,1848))
  n2(1508) = 32
  call heltable([16,2,32], n3(:,5304), t3x32(:,:,1849))
  n2(1509) = 32
  call heltable([16,2,32], n3(:,5305), t3x32(:,:,1850))
  n2(1510) = 32
  call heltable([2,16,32], n3(:,5306), t3x32(:,:,1851))
  n2(1511) = 32
  call heltable([2,16,32], n3(:,5307), t3x32(:,:,1852))
  n2(1512) = 32
  call heltable([2,16,32], n3(:,5308), t3x32(:,:,1853))
  n2(1513) = 32
  call heltable([2,16,32], n3(:,5309), t3x32(:,:,1854))
  n2(1514) = 32
  call heltable([16,2,32], n3(:,5310), t3x32(:,:,1855))
  n2(1515) = 32
  call heltable([16,2,32], n3(:,5311), t3x32(:,:,1856))
  n2(1516) = 32
  call heltable([16,2,32], n3(:,5312), t3x32(:,:,1857))
  n2(1517) = 32
  call heltable([16,2,32], n3(:,5313), t3x32(:,:,1858))
  n2(1518) = 32
  call heltable([16,2,32], n3(:,5314), t3x32(:,:,1859))
  n2(1519) = 32
  call heltable([16,2,32], n3(:,5315), t3x32(:,:,1860))
  n2(1520) = 32
  call heltable([16,2,32], n3(:,5316), t3x32(:,:,1861))
  n2(1521) = 32
  call heltable([16,2,32], n3(:,5317), t3x32(:,:,1862))
  n2(1522) = 32
  call heltable([2,16,32], n3(:,5318), t3x32(:,:,1863))
  n2(1523) = 32
  call heltable([2,16,32], n3(:,5319), t3x32(:,:,1864))
  n2(1524) = 32
  call heltable([2,16,32], n3(:,5320), t3x32(:,:,1865))
  n2(1525) = 32
  call heltable([2,16,32], n3(:,5321), t3x32(:,:,1866))
  n2(1526) = 32
  call heltable([16,2,32], n3(:,5322), t3x32(:,:,1867))
  n2(1527) = 32
  call heltable([16,2,32], n3(:,5323), t3x32(:,:,1868))
  n2(1528) = 32
  call heltable([16,2,32], n3(:,5324), t3x32(:,:,1869))
  n2(1529) = 32
  call heltable([16,2,32], n3(:,5325), t3x32(:,:,1870))
  n2(1530) = 32
  call heltable([2,16,32], n3(:,5326), t3x32(:,:,1871))
  n2(1531) = 32
  call heltable([2,16,32], n3(:,5327), t3x32(:,:,1872))
  n2(1532) = 32
  call heltable([2,16,32], n3(:,5328), t3x32(:,:,1873))
  n2(1533) = 32
  call heltable([2,16,32], n3(:,5329), t3x32(:,:,1874))
  n2(1534) = 32
  call heltable([2,16,32], n3(:,5330), t3x32(:,:,1875))
  call heltable([2,16,32], n3(:,5331), t3x32(:,:,1876))
  call heltable([2,16,32], n3(:,5332), t3x32(:,:,1877))
  call heltable([2,16,32], n3(:,5333), t3x32(:,:,1878))
  call heltable([16,2,32], n3(:,5334), t3x32(:,:,1879))
  call heltable([16,2,32], n3(:,5335), t3x32(:,:,1880))
  call heltable([16,2,32], n3(:,5336), t3x32(:,:,1881))
  call heltable([16,2,32], n3(:,5337), t3x32(:,:,1882))
  call heltable([2,16,32], n3(:,5338), t3x32(:,:,1883))
  call heltable([2,16,32], n3(:,5339), t3x32(:,:,1884))
  call heltable([2,16,32], n3(:,5340), t3x32(:,:,1885))
  call heltable([2,16,32], n3(:,5341), t3x32(:,:,1886))
  call heltable([16,2,32], n3(:,5342), t3x32(:,:,1887))
  call heltable([16,2,32], n3(:,5343), t3x32(:,:,1888))
  call heltable([16,2,32], n3(:,5344), t3x32(:,:,1889))
  call heltable([16,2,32], n3(:,5345), t3x32(:,:,1890))
  call heltable([2,16,32], n3(:,5346), t3x32(:,:,1891))
  n2(1535) = 32
  call heltable([2,16,32], n3(:,5347), t3x32(:,:,1892))
  n2(1536) = 32
  call heltable([2,16,32], n3(:,5348), t3x32(:,:,1893))
  n2(1537) = 32
  call heltable([2,16,32], n3(:,5349), t3x32(:,:,1894))
  n2(1538) = 32
  call heltable([2,16,32], n3(:,5350), t3x32(:,:,1895))
  n2(1539) = 32
  call heltable([2,16,32], n3(:,5351), t3x32(:,:,1896))
  n2(1540) = 32
  call heltable([2,16,32], n3(:,5352), t3x32(:,:,1897))
  n2(1541) = 32
  call heltable([2,16,32], n3(:,5353), t3x32(:,:,1898))
  n2(1542) = 32
  call heltable([16,2,32], n3(:,5354), t3x32(:,:,1899))
  n2(1543) = 32
  call heltable([16,2,32], n3(:,5355), t3x32(:,:,1900))
  n2(1544) = 32
  call heltable([16,2,32], n3(:,5356), t3x32(:,:,1901))
  n2(1545) = 32
  call heltable([16,2,32], n3(:,5357), t3x32(:,:,1902))
  n2(1546) = 32
  call heltable([16,2,32], n3(:,5358), t3x32(:,:,1903))
  n2(1547) = 32
  call heltable([16,2,32], n3(:,5359), t3x32(:,:,1904))
  n2(1548) = 32
  call heltable([16,2,32], n3(:,5360), t3x32(:,:,1905))
  n2(1549) = 32
  call heltable([16,2,32], n3(:,5361), t3x32(:,:,1906))
  n2(1550) = 32
  call heltable([16,2,32], n3(:,5362), t3x32(:,:,1907))
  n2(1551) = 32
  call heltable([16,2,32], n3(:,5363), t3x32(:,:,1908))
  n2(1552) = 32
  call heltable([16,2,32], n3(:,5364), t3x32(:,:,1909))
  n2(1553) = 32
  call heltable([16,2,32], n3(:,5365), t3x32(:,:,1910))
  n2(1554) = 32
  call heltable([16,2,32], n3(:,5366), t3x32(:,:,1911))
  n2(1555) = 32
  call heltable([16,2,32], n3(:,5367), t3x32(:,:,1912))
  n2(1556) = 32
  call heltable([16,2,32], n3(:,5368), t3x32(:,:,1913))
  n2(1557) = 32
  call heltable([16,2,32], n3(:,5369), t3x32(:,:,1914))
  n2(1558) = 32
  call heltable([2,16,32], n3(:,5370), t3x32(:,:,1915))
  n2(1559) = 32
  call heltable([2,16,32], n3(:,5371), t3x32(:,:,1916))
  n2(1560) = 32
  call heltable([2,16,32], n3(:,5372), t3x32(:,:,1917))
  n2(1561) = 32
  call heltable([2,16,32], n3(:,5373), t3x32(:,:,1918))
  n2(1562) = 32
  call heltable([2,16,32], n3(:,5374), t3x32(:,:,1919))
  n2(1563) = 32
  call heltable([2,16,32], n3(:,5375), t3x32(:,:,1920))
  n2(1564) = 32
  call heltable([2,16,32], n3(:,5376), t3x32(:,:,1921))
  n2(1565) = 32
  call heltable([2,16,32], n3(:,5377), t3x32(:,:,1922))
  n2(1566) = 32
  call heltable([2,16,32], n3(:,5378), t3x32(:,:,1923))
  n2(1567) = 32
  call heltable([2,16,32], n3(:,5379), t3x32(:,:,1924))
  n2(1568) = 32
  call heltable([2,16,32], n3(:,5380), t3x32(:,:,1925))
  n2(1569) = 32
  call heltable([2,16,32], n3(:,5381), t3x32(:,:,1926))
  n2(1570) = 32
  call heltable([2,16,32], n3(:,5382), t3x32(:,:,1927))
  n2(1571) = 32
  call heltable([2,16,32], n3(:,5383), t3x32(:,:,1928))
  n2(1572) = 32
  call heltable([2,16,32], n3(:,5384), t3x32(:,:,1929))
  n2(1573) = 32
  call heltable([2,16,32], n3(:,5385), t3x32(:,:,1930))
  n2(1574) = 32
  call heltable([16,2,32], n3(:,5386), t3x32(:,:,1931))
  n2(1575) = 32
  call heltable([16,2,32], n3(:,5387), t3x32(:,:,1932))
  n2(1576) = 32
  call heltable([16,2,32], n3(:,5388), t3x32(:,:,1933))
  n2(1577) = 32
  call heltable([16,2,32], n3(:,5389), t3x32(:,:,1934))
  n2(1578) = 32
  call heltable([16,2,32], n3(:,5390), t3x32(:,:,1935))
  n2(1579) = 32
  call heltable([16,2,32], n3(:,5391), t3x32(:,:,1936))
  n2(1580) = 32
  call heltable([16,2,32], n3(:,5392), t3x32(:,:,1937))
  n2(1581) = 32
  call heltable([16,2,32], n3(:,5393), t3x32(:,:,1938))
  n2(1582) = 32
  call heltable([2,16,32], n3(:,5394), t3x32(:,:,1939))
  n2(1583) = 32
  call heltable([2,16,32], n3(:,5395), t3x32(:,:,1940))
  n2(1584) = 32
  call heltable([2,16,32], n3(:,5396), t3x32(:,:,1941))
  n2(1585) = 32
  call heltable([2,16,32], n3(:,5397), t3x32(:,:,1942))
  n2(1586) = 32
  call heltable([2,16,32], n3(:,5398), t3x32(:,:,1943))
  n2(1587) = 32
  call heltable([2,16,32], n3(:,5399), t3x32(:,:,1944))
  n2(1588) = 32
  call heltable([2,16,32], n3(:,5400), t3x32(:,:,1945))
  n2(1589) = 32
  call heltable([2,16,32], n3(:,5401), t3x32(:,:,1946))
  n2(1590) = 32
  call heltable([16,2,32], n3(:,5402), t3x32(:,:,1947))
  n2(1591) = 32
  call heltable([16,2,32], n3(:,5403), t3x32(:,:,1948))
  n2(1592) = 32
  call heltable([16,2,32], n3(:,5404), t3x32(:,:,1949))
  n2(1593) = 32
  call heltable([16,2,32], n3(:,5405), t3x32(:,:,1950))
  n2(1594) = 32
  call heltable([16,2,32], n3(:,5406), t3x32(:,:,1951))
  n2(1595) = 32
  call heltable([16,2,32], n3(:,5407), t3x32(:,:,1952))
  n2(1596) = 32
  call heltable([16,2,32], n3(:,5408), t3x32(:,:,1953))
  n2(1597) = 32
  call heltable([16,2,32], n3(:,5409), t3x32(:,:,1954))
  n2(1598) = 32
  call heltable([16,2,32], n3(:,5410), t3x32(:,:,1955))
  call heltable([16,2,32], n3(:,5411), t3x32(:,:,1956))
  call heltable([16,2,32], n3(:,5412), t3x32(:,:,1957))
  call heltable([16,2,32], n3(:,5413), t3x32(:,:,1958))
  call heltable([16,2,32], n3(:,5414), t3x32(:,:,1959))
  call heltable([16,2,32], n3(:,5415), t3x32(:,:,1960))
  call heltable([16,2,32], n3(:,5416), t3x32(:,:,1961))
  call heltable([16,2,32], n3(:,5417), t3x32(:,:,1962))
  call heltable([2,16,32], n3(:,5418), t3x32(:,:,1963))
  call heltable([2,16,32], n3(:,5419), t3x32(:,:,1964))
  call heltable([2,16,32], n3(:,5420), t3x32(:,:,1965))
  call heltable([2,16,32], n3(:,5421), t3x32(:,:,1966))
  call heltable([2,16,32], n3(:,5422), t3x32(:,:,1967))
  call heltable([2,16,32], n3(:,5423), t3x32(:,:,1968))
  call heltable([2,16,32], n3(:,5424), t3x32(:,:,1969))
  call heltable([2,16,32], n3(:,5425), t3x32(:,:,1970))
  call heltable([16,2,32], n3(:,5426), t3x32(:,:,1971))
  n2(1599) = 32
  call heltable([16,2,32], n3(:,5427), t3x32(:,:,1972))
  n2(1600) = 32
  call heltable([16,2,32], n3(:,5428), t3x32(:,:,1973))
  n2(1601) = 32
  call heltable([16,2,32], n3(:,5429), t3x32(:,:,1974))
  n2(1602) = 32
  call heltable([2,16,32], n3(:,5430), t3x32(:,:,1975))
  n2(1603) = 32
  call heltable([2,16,32], n3(:,5431), t3x32(:,:,1976))
  n2(1604) = 32
  call heltable([2,16,32], n3(:,5432), t3x32(:,:,1977))
  n2(1605) = 32
  call heltable([2,16,32], n3(:,5433), t3x32(:,:,1978))
  n2(1606) = 32
  call heltable([16,2,32], n3(:,5434), t3x32(:,:,1979))
  n2(1607) = 32
  call heltable([16,2,32], n3(:,5435), t3x32(:,:,1980))
  n2(1608) = 32
  call heltable([16,2,32], n3(:,5436), t3x32(:,:,1981))
  n2(1609) = 32
  call heltable([16,2,32], n3(:,5437), t3x32(:,:,1982))
  n2(1610) = 32
  call heltable([2,16,32], n3(:,5438), t3x32(:,:,1983))
  n2(1611) = 32
  call heltable([2,16,32], n3(:,5439), t3x32(:,:,1984))
  n2(1612) = 32
  call heltable([2,16,32], n3(:,5440), t3x32(:,:,1985))
  n2(1613) = 32
  call heltable([2,16,32], n3(:,5441), t3x32(:,:,1986))
  n2(1614) = 32
  call heltable([2,16,32], n3(:,5442), t3x32(:,:,1987))
  call heltable([2,16,32], n3(:,5443), t3x32(:,:,1988))
  call heltable([2,16,32], n3(:,5444), t3x32(:,:,1989))
  call heltable([2,16,32], n3(:,5445), t3x32(:,:,1990))
  call heltable([16,2,32], n3(:,5446), t3x32(:,:,1991))
  call heltable([16,2,32], n3(:,5447), t3x32(:,:,1992))
  call heltable([16,2,32], n3(:,5448), t3x32(:,:,1993))
  call heltable([16,2,32], n3(:,5449), t3x32(:,:,1994))
  call heltable([2,16,32], n3(:,5450), t3x32(:,:,1995))
  call heltable([2,16,32], n3(:,5451), t3x32(:,:,1996))
  call heltable([2,16,32], n3(:,5452), t3x32(:,:,1997))
  call heltable([2,16,32], n3(:,5453), t3x32(:,:,1998))
  call heltable([16,2,32], n3(:,5454), t3x32(:,:,1999))
  call heltable([16,2,32], n3(:,5455), t3x32(:,:,2000))
  call heltable([16,2,32], n3(:,5456), t3x32(:,:,2001))
  call heltable([16,2,32], n3(:,5457), t3x32(:,:,2002))
  call heltable([16,2,32], n3(:,5458), t3x32(:,:,2003))
  n2(1615) = 32
  call heltable([16,2,32], n3(:,5459), t3x32(:,:,2004))
  n2(1616) = 32
  call heltable([16,2,32], n3(:,5460), t3x32(:,:,2005))
  n2(1617) = 32
  call heltable([16,2,32], n3(:,5461), t3x32(:,:,2006))
  n2(1618) = 32
  call heltable([2,16,32], n3(:,5462), t3x32(:,:,2007))
  n2(1619) = 32
  call heltable([2,16,32], n3(:,5463), t3x32(:,:,2008))
  n2(1620) = 32
  call heltable([2,16,32], n3(:,5464), t3x32(:,:,2009))
  n2(1621) = 32
  call heltable([2,16,32], n3(:,5465), t3x32(:,:,2010))
  n2(1622) = 32
  call heltable([16,2,32], n3(:,5466), t3x32(:,:,2011))
  n2(1623) = 32
  call heltable([16,2,32], n3(:,5467), t3x32(:,:,2012))
  n2(1624) = 32
  call heltable([16,2,32], n3(:,5468), t3x32(:,:,2013))
  n2(1625) = 32
  call heltable([16,2,32], n3(:,5469), t3x32(:,:,2014))
  n2(1626) = 32
  call heltable([2,16,32], n3(:,5470), t3x32(:,:,2015))
  n2(1627) = 32
  call heltable([2,16,32], n3(:,5471), t3x32(:,:,2016))
  n2(1628) = 32
  call heltable([2,16,32], n3(:,5472), t3x32(:,:,2017))
  n2(1629) = 32
  call heltable([2,16,32], n3(:,5473), t3x32(:,:,2018))
  n2(1630) = 32
  call heltable([16,2,32], n3(:,5474), t3x32(:,:,2019))
  call heltable([16,2,32], n3(:,5475), t3x32(:,:,2020))
  call heltable([16,2,32], n3(:,5476), t3x32(:,:,2021))
  call heltable([16,2,32], n3(:,5477), t3x32(:,:,2022))
  call heltable([2,16,32], n3(:,5478), t3x32(:,:,2023))
  call heltable([2,16,32], n3(:,5479), t3x32(:,:,2024))
  call heltable([2,16,32], n3(:,5480), t3x32(:,:,2025))
  call heltable([2,16,32], n3(:,5481), t3x32(:,:,2026))
  call heltable([16,2,32], n3(:,5482), t3x32(:,:,2027))
  call heltable([16,2,32], n3(:,5483), t3x32(:,:,2028))
  call heltable([16,2,32], n3(:,5484), t3x32(:,:,2029))
  call heltable([16,2,32], n3(:,5485), t3x32(:,:,2030))
  call heltable([2,16,32], n3(:,5486), t3x32(:,:,2031))
  call heltable([2,16,32], n3(:,5487), t3x32(:,:,2032))
  call heltable([2,16,32], n3(:,5488), t3x32(:,:,2033))
  call heltable([2,16,32], n3(:,5489), t3x32(:,:,2034))
  call heltable([8,4,32], n3(:,5490), t3x32(:,:,2035))
  n2(1631) = 32
  call heltable([8,4,32], n3(:,5491), t3x32(:,:,2036))
  n2(1632) = 32
  call heltable([8,4,32], n3(:,5492), t3x32(:,:,2037))
  n2(1633) = 32
  call heltable([8,4,32], n3(:,5493), t3x32(:,:,2038))
  n2(1634) = 32
  call heltable([4,8,32], n3(:,5494), t3x32(:,:,2039))
  n2(1635) = 32
  call heltable([4,8,32], n3(:,5495), t3x32(:,:,2040))
  n2(1636) = 32
  call heltable([4,8,32], n3(:,5496), t3x32(:,:,2041))
  n2(1637) = 32
  call heltable([4,8,32], n3(:,5497), t3x32(:,:,2042))
  n2(1638) = 32
  call heltable([8,4,32], n3(:,5498), t3x32(:,:,2043))
  n2(1639) = 32
  call heltable([8,4,32], n3(:,5499), t3x32(:,:,2044))
  n2(1640) = 32
  call heltable([8,4,32], n3(:,5500), t3x32(:,:,2045))
  n2(1641) = 32
  call heltable([8,4,32], n3(:,5501), t3x32(:,:,2046))
  n2(1642) = 32
  call heltable([4,8,32], n3(:,5502), t3x32(:,:,2047))
  n2(1643) = 32
  call heltable([4,8,32], n3(:,5503), t3x32(:,:,2048))
  n2(1644) = 32
  call heltable([4,8,32], n3(:,5504), t3x32(:,:,2049))
  n2(1645) = 32
  call heltable([4,8,32], n3(:,5505), t3x32(:,:,2050))
  n2(1646) = 32
  call heltable([4,8,32], n3(:,5506), t3x32(:,:,2051))
  n2(1647) = 32
  call heltable([4,8,32], n3(:,5507), t3x32(:,:,2052))
  n2(1648) = 32
  call heltable([4,8,32], n3(:,5508), t3x32(:,:,2053))
  n2(1649) = 32
  call heltable([4,8,32], n3(:,5509), t3x32(:,:,2054))
  n2(1650) = 32
  call heltable([8,4,32], n3(:,5510), t3x32(:,:,2055))
  n2(1651) = 32
  call heltable([8,4,32], n3(:,5511), t3x32(:,:,2056))
  n2(1652) = 32
  call heltable([8,4,32], n3(:,5512), t3x32(:,:,2057))
  n2(1653) = 32
  call heltable([8,4,32], n3(:,5513), t3x32(:,:,2058))
  n2(1654) = 32
  call heltable([4,8,32], n3(:,5514), t3x32(:,:,2059))
  n2(1655) = 32
  call heltable([4,8,32], n3(:,5515), t3x32(:,:,2060))
  n2(1656) = 32
  call heltable([4,8,32], n3(:,5516), t3x32(:,:,2061))
  n2(1657) = 32
  call heltable([4,8,32], n3(:,5517), t3x32(:,:,2062))
  n2(1658) = 32
  call heltable([8,4,32], n3(:,5518), t3x32(:,:,2063))
  n2(1659) = 32
  call heltable([8,4,32], n3(:,5519), t3x32(:,:,2064))
  n2(1660) = 32
  call heltable([8,4,32], n3(:,5520), t3x32(:,:,2065))
  n2(1661) = 32
  call heltable([8,4,32], n3(:,5521), t3x32(:,:,2066))
  n2(1662) = 32
  call heltable([8,4,32], n3(:,5522), t3x32(:,:,2067))
  n2(1663) = 32
  call heltable([8,4,32], n3(:,5523), t3x32(:,:,2068))
  n2(1664) = 32
  call heltable([8,4,32], n3(:,5524), t3x32(:,:,2069))
  n2(1665) = 32
  call heltable([8,4,32], n3(:,5525), t3x32(:,:,2070))
  n2(1666) = 32
  call heltable([8,4,32], n3(:,5526), t3x32(:,:,2071))
  n2(1667) = 32
  call heltable([8,4,32], n3(:,5527), t3x32(:,:,2072))
  n2(1668) = 32
  call heltable([8,4,32], n3(:,5528), t3x32(:,:,2073))
  n2(1669) = 32
  call heltable([8,4,32], n3(:,5529), t3x32(:,:,2074))
  n2(1670) = 32
  call heltable([4,8,32], n3(:,5530), t3x32(:,:,2075))
  n2(1671) = 32
  call heltable([4,8,32], n3(:,5531), t3x32(:,:,2076))
  n2(1672) = 32
  call heltable([4,8,32], n3(:,5532), t3x32(:,:,2077))
  n2(1673) = 32
  call heltable([4,8,32], n3(:,5533), t3x32(:,:,2078))
  n2(1674) = 32
  call heltable([4,8,32], n3(:,5534), t3x32(:,:,2079))
  n2(1675) = 32
  call heltable([4,8,32], n3(:,5535), t3x32(:,:,2080))
  n2(1676) = 32
  call heltable([4,8,32], n3(:,5536), t3x32(:,:,2081))
  n2(1677) = 32
  call heltable([4,8,32], n3(:,5537), t3x32(:,:,2082))
  n2(1678) = 32
  call heltable([2,16,32], n3(:,5538), t3x32(:,:,2083))
  n2(1679) = 32
  call heltable([2,16,32], n3(:,5539), t3x32(:,:,2084))
  n2(1680) = 32
  call heltable([2,16,32], n3(:,5540), t3x32(:,:,2085))
  n2(1681) = 32
  call heltable([2,16,32], n3(:,5541), t3x32(:,:,2086))
  n2(1682) = 32
  call heltable([2,16,32], n3(:,5542), t3x32(:,:,2087))
  n2(1683) = 32
  call heltable([2,16,32], n3(:,5543), t3x32(:,:,2088))
  n2(1684) = 32
  call heltable([16,2,32], n3(:,5544), t3x32(:,:,2089))
  n2(1685) = 32
  call heltable([16,2,32], n3(:,5545), t3x32(:,:,2090))
  n2(1686) = 32
  call heltable([16,2,32], n3(:,5546), t3x32(:,:,2091))
  n2(1687) = 32
  call heltable([2,16,32], n3(:,5547), t3x32(:,:,2092))
  n2(1688) = 32
  call heltable([2,16,32], n3(:,5548), t3x32(:,:,2093))
  n2(1689) = 32
  call heltable([2,16,32], n3(:,5549), t3x32(:,:,2094))
  n2(1690) = 32
  call heltable([16,2,32], n3(:,5550), t3x32(:,:,2095))
  n2(1691) = 32
  call heltable([4,8,32], n3(:,5551), t3x32(:,:,2096))
  n2(1692) = 32
  call heltable([4,8,32], n3(:,5552), t3x32(:,:,2097))
  n2(1693) = 32
  call heltable([4,8,32], n3(:,5553), t3x32(:,:,2098))
  n2(1694) = 32
  call heltable([4,8,32], n3(:,5554), t3x32(:,:,2099))
  n2(1695) = 32
  call heltable([4,8,32], n3(:,5555), t3x32(:,:,2100))
  n2(1696) = 32
  call heltable([4,8,32], n3(:,5556), t3x32(:,:,2101))
  n2(1697) = 32
  call heltable([4,8,32], n3(:,5557), t3x32(:,:,2102))
  n2(1698) = 32
  call heltable([4,8,32], n3(:,5558), t3x32(:,:,2103))
  n2(1699) = 32
  call heltable([8,4,32], n3(:,5559), t3x32(:,:,2104))
  n2(1700) = 32
  call heltable([8,4,32], n3(:,5560), t3x32(:,:,2105))
  n2(1701) = 32
  call heltable([8,4,32], n3(:,5561), t3x32(:,:,2106))
  n2(1702) = 32
  call heltable([8,4,32], n3(:,5562), t3x32(:,:,2107))
  n2(1703) = 32
  call heltable([8,4,32], n3(:,5563), t3x32(:,:,2108))
  n2(1704) = 32
  call heltable([8,4,32], n3(:,5564), t3x32(:,:,2109))
  n2(1705) = 32
  call heltable([8,4,32], n3(:,5565), t3x32(:,:,2110))
  n2(1706) = 32
  call heltable([8,4,32], n3(:,5566), t3x32(:,:,2111))
  n2(1707) = 32
  call heltable([16,2,32], n3(:,5567), t3x32(:,:,2112))
  n2(1708) = 32
  call heltable([16,2,32], n3(:,5568), t3x32(:,:,2113))
  n2(1709) = 32
  call heltable([16,2,32], n3(:,5569), t3x32(:,:,2114))
  n2(1710) = 32
  call heltable([16,2,32], n3(:,5570), t3x32(:,:,2115))
  n2(1711) = 32
  call heltable([16,2,32], n3(:,5571), t3x32(:,:,2116))
  n2(1712) = 32
  call heltable([16,2,32], n3(:,5572), t3x32(:,:,2117))
  n2(1713) = 32
  call heltable([2,16,32], n3(:,5573), t3x32(:,:,2118))
  n2(1714) = 32
  call heltable([2,16,32], n3(:,5574), t3x32(:,:,2119))
  n2(1715) = 32
  call heltable([2,16,32], n3(:,5575), t3x32(:,:,2120))
  n2(1716) = 32
  call heltable([16,2,32], n3(:,5576), t3x32(:,:,2121))
  n2(1717) = 32
  call heltable([16,2,32], n3(:,5577), t3x32(:,:,2122))
  n2(1718) = 32
  call heltable([16,2,32], n3(:,5578), t3x32(:,:,2123))
  n2(1719) = 32
  call heltable([2,16,32], n3(:,5579), t3x32(:,:,2124))
  n2(1720) = 32
  call heltable([8,4,32], n3(:,5580), t3x32(:,:,2125))
  call heltable([8,4,32], n3(:,5581), t3x32(:,:,2126))
  call heltable([8,4,32], n3(:,5582), t3x32(:,:,2127))
  call heltable([8,4,32], n3(:,5583), t3x32(:,:,2128))
  call heltable([4,8,32], n3(:,5584), t3x32(:,:,2129))
  call heltable([4,8,32], n3(:,5585), t3x32(:,:,2130))
  call heltable([4,8,32], n3(:,5586), t3x32(:,:,2131))
  call heltable([4,8,32], n3(:,5587), t3x32(:,:,2132))
  call heltable([8,4,32], n3(:,5588), t3x32(:,:,2133))
  call heltable([8,4,32], n3(:,5589), t3x32(:,:,2134))
  call heltable([8,4,32], n3(:,5590), t3x32(:,:,2135))
  call heltable([8,4,32], n3(:,5591), t3x32(:,:,2136))
  call heltable([4,8,32], n3(:,5592), t3x32(:,:,2137))
  call heltable([4,8,32], n3(:,5593), t3x32(:,:,2138))
  call heltable([4,8,32], n3(:,5594), t3x32(:,:,2139))
  call heltable([4,8,32], n3(:,5595), t3x32(:,:,2140))
  call heltable([4,8,32], n3(:,5596), t3x32(:,:,2141))
  call heltable([4,8,32], n3(:,5597), t3x32(:,:,2142))
  call heltable([4,8,32], n3(:,5598), t3x32(:,:,2143))
  call heltable([4,8,32], n3(:,5599), t3x32(:,:,2144))
  call heltable([8,4,32], n3(:,5600), t3x32(:,:,2145))
  call heltable([4,8,32], n3(:,5601), t3x32(:,:,2146))
  call heltable([4,8,32], n3(:,5602), t3x32(:,:,2147))
  call heltable([8,4,32], n3(:,5603), t3x32(:,:,2148))
  call heltable([4,8,32], n3(:,5604), t3x32(:,:,2149))
  call heltable([8,4,32], n3(:,5605), t3x32(:,:,2150))
  call heltable([4,8,32], n3(:,5606), t3x32(:,:,2151))
  call heltable([8,4,32], n3(:,5607), t3x32(:,:,2152))
  call heltable([4,8,32], n3(:,5608), t3x32(:,:,2153))
  call heltable([2,16,32], n3(:,5609), t3x32(:,:,2154))
  call heltable([2,16,32], n3(:,5610), t3x32(:,:,2155))
  call heltable([2,16,32], n3(:,5611), t3x32(:,:,2156))
  call heltable([2,16,32], n3(:,5612), t3x32(:,:,2157))
  call heltable([16,2,32], n3(:,5613), t3x32(:,:,2158))
  call heltable([16,2,32], n3(:,5614), t3x32(:,:,2159))
  call heltable([16,2,32], n3(:,5615), t3x32(:,:,2160))
  call heltable([16,2,32], n3(:,5616), t3x32(:,:,2161))
  call heltable([2,16,32], n3(:,5617), t3x32(:,:,2162))
  call heltable([2,16,32], n3(:,5618), t3x32(:,:,2163))
  call heltable([2,16,32], n3(:,5619), t3x32(:,:,2164))
  call heltable([2,16,32], n3(:,5620), t3x32(:,:,2165))
  call heltable([16,2,32], n3(:,5621), t3x32(:,:,2166))
  call heltable([16,2,32], n3(:,5622), t3x32(:,:,2167))
  call heltable([16,2,32], n3(:,5623), t3x32(:,:,2168))
  call heltable([16,2,32], n3(:,5624), t3x32(:,:,2169))
  call heltable([4,8,32], n3(:,5625), t3x32(:,:,2170))
  call heltable([4,8,32], n3(:,5626), t3x32(:,:,2171))
  call heltable([4,8,32], n3(:,5627), t3x32(:,:,2172))
  call heltable([4,8,32], n3(:,5628), t3x32(:,:,2173))
  call heltable([8,4,32], n3(:,5629), t3x32(:,:,2174))
  call heltable([8,4,32], n3(:,5630), t3x32(:,:,2175))
  call heltable([8,4,32], n3(:,5631), t3x32(:,:,2176))
  call heltable([8,4,32], n3(:,5632), t3x32(:,:,2177))
  call heltable([4,8,32], n3(:,5633), t3x32(:,:,2178))
  call heltable([4,8,32], n3(:,5634), t3x32(:,:,2179))
  call heltable([4,8,32], n3(:,5635), t3x32(:,:,2180))
  call heltable([4,8,32], n3(:,5636), t3x32(:,:,2181))
  call heltable([8,4,32], n3(:,5637), t3x32(:,:,2182))
  call heltable([8,4,32], n3(:,5638), t3x32(:,:,2183))
  call heltable([8,4,32], n3(:,5639), t3x32(:,:,2184))
  call heltable([8,4,32], n3(:,5640), t3x32(:,:,2185))
  call heltable([4,8,32], n3(:,5641), t3x32(:,:,2186))
  call heltable([4,8,32], n3(:,5642), t3x32(:,:,2187))
  call heltable([4,8,32], n3(:,5643), t3x32(:,:,2188))
  call heltable([4,8,32], n3(:,5644), t3x32(:,:,2189))
  call heltable([8,4,32], n3(:,5645), t3x32(:,:,2190))
  call heltable([4,8,32], n3(:,5646), t3x32(:,:,2191))
  call heltable([4,8,32], n3(:,5647), t3x32(:,:,2192))
  call heltable([8,4,32], n3(:,5648), t3x32(:,:,2193))
  call heltable([4,8,32], n3(:,5649), t3x32(:,:,2194))
  call heltable([8,4,32], n3(:,5650), t3x32(:,:,2195))
  call heltable([4,8,32], n3(:,5651), t3x32(:,:,2196))
  call heltable([8,4,32], n3(:,5652), t3x32(:,:,2197))
  call heltable([4,8,32], n3(:,5653), t3x32(:,:,2198))
  call heltable([16,2,32], n3(:,5654), t3x32(:,:,2199))
  call heltable([16,2,32], n3(:,5655), t3x32(:,:,2200))
  call heltable([16,2,32], n3(:,5656), t3x32(:,:,2201))
  call heltable([16,2,32], n3(:,5657), t3x32(:,:,2202))
  call heltable([2,16,32], n3(:,5658), t3x32(:,:,2203))
  call heltable([2,16,32], n3(:,5659), t3x32(:,:,2204))
  call heltable([2,16,32], n3(:,5660), t3x32(:,:,2205))
  call heltable([2,16,32], n3(:,5661), t3x32(:,:,2206))
  call heltable([16,2,32], n3(:,5662), t3x32(:,:,2207))
  call heltable([16,2,32], n3(:,5663), t3x32(:,:,2208))
  call heltable([16,2,32], n3(:,5664), t3x32(:,:,2209))
  call heltable([16,2,32], n3(:,5665), t3x32(:,:,2210))
  call heltable([2,16,32], n3(:,5666), t3x32(:,:,2211))
  call heltable([2,16,32], n3(:,5667), t3x32(:,:,2212))
  call heltable([2,16,32], n3(:,5668), t3x32(:,:,2213))
  call heltable([2,16,32], n3(:,5669), t3x32(:,:,2214))
  call heltable([8,4,32], n3(:,5670), t3x32(:,:,2215))
  call heltable([8,4,32], n3(:,5671), t3x32(:,:,2216))
  call heltable([8,4,32], n3(:,5672), t3x32(:,:,2217))
  call heltable([8,4,32], n3(:,5673), t3x32(:,:,2218))
  call heltable([4,8,32], n3(:,5674), t3x32(:,:,2219))
  call heltable([4,8,32], n3(:,5675), t3x32(:,:,2220))
  call heltable([4,8,32], n3(:,5676), t3x32(:,:,2221))
  call heltable([4,8,32], n3(:,5677), t3x32(:,:,2222))
  call heltable([8,4,32], n3(:,5678), t3x32(:,:,2223))
  call heltable([8,4,32], n3(:,5679), t3x32(:,:,2224))
  call heltable([8,4,32], n3(:,5680), t3x32(:,:,2225))
  call heltable([8,4,32], n3(:,5681), t3x32(:,:,2226))
  call heltable([4,8,32], n3(:,5682), t3x32(:,:,2227))
  call heltable([4,8,32], n3(:,5683), t3x32(:,:,2228))
  call heltable([4,8,32], n3(:,5684), t3x32(:,:,2229))
  call heltable([4,8,32], n3(:,5685), t3x32(:,:,2230))
  call heltable([4,8,32], n3(:,5686), t3x32(:,:,2231))
  call heltable([4,8,32], n3(:,5687), t3x32(:,:,2232))
  call heltable([4,8,32], n3(:,5688), t3x32(:,:,2233))
  call heltable([4,8,32], n3(:,5689), t3x32(:,:,2234))
  call heltable([8,4,32], n3(:,5690), t3x32(:,:,2235))
  call heltable([4,8,32], n3(:,5691), t3x32(:,:,2236))
  call heltable([4,8,32], n3(:,5692), t3x32(:,:,2237))
  call heltable([8,4,32], n3(:,5693), t3x32(:,:,2238))
  call heltable([4,8,32], n3(:,5694), t3x32(:,:,2239))
  call heltable([8,4,32], n3(:,5695), t3x32(:,:,2240))
  call heltable([4,8,32], n3(:,5696), t3x32(:,:,2241))
  call heltable([8,4,32], n3(:,5697), t3x32(:,:,2242))
  call heltable([4,8,32], n3(:,5698), t3x32(:,:,2243))
  call heltable([2,16,32], n3(:,5699), t3x32(:,:,2244))
  call heltable([2,16,32], n3(:,5700), t3x32(:,:,2245))
  call heltable([2,16,32], n3(:,5701), t3x32(:,:,2246))
  call heltable([2,16,32], n3(:,5702), t3x32(:,:,2247))
  call heltable([16,2,32], n3(:,5703), t3x32(:,:,2248))
  call heltable([16,2,32], n3(:,5704), t3x32(:,:,2249))
  call heltable([16,2,32], n3(:,5705), t3x32(:,:,2250))
  call heltable([16,2,32], n3(:,5706), t3x32(:,:,2251))
  call heltable([2,16,32], n3(:,5707), t3x32(:,:,2252))
  call heltable([2,16,32], n3(:,5708), t3x32(:,:,2253))
  call heltable([2,16,32], n3(:,5709), t3x32(:,:,2254))
  call heltable([2,16,32], n3(:,5710), t3x32(:,:,2255))
  call heltable([16,2,32], n3(:,5711), t3x32(:,:,2256))
  call heltable([16,2,32], n3(:,5712), t3x32(:,:,2257))
  call heltable([16,2,32], n3(:,5713), t3x32(:,:,2258))
  call heltable([16,2,32], n3(:,5714), t3x32(:,:,2259))
  call heltable([4,8,32], n3(:,5715), t3x32(:,:,2260))
  call heltable([4,8,32], n3(:,5716), t3x32(:,:,2261))
  call heltable([4,8,32], n3(:,5717), t3x32(:,:,2262))
  call heltable([4,8,32], n3(:,5718), t3x32(:,:,2263))
  call heltable([8,4,32], n3(:,5719), t3x32(:,:,2264))
  call heltable([8,4,32], n3(:,5720), t3x32(:,:,2265))
  call heltable([8,4,32], n3(:,5721), t3x32(:,:,2266))
  call heltable([8,4,32], n3(:,5722), t3x32(:,:,2267))
  call heltable([4,8,32], n3(:,5723), t3x32(:,:,2268))
  call heltable([4,8,32], n3(:,5724), t3x32(:,:,2269))
  call heltable([4,8,32], n3(:,5725), t3x32(:,:,2270))
  call heltable([4,8,32], n3(:,5726), t3x32(:,:,2271))
  call heltable([8,4,32], n3(:,5727), t3x32(:,:,2272))
  call heltable([8,4,32], n3(:,5728), t3x32(:,:,2273))
  call heltable([8,4,32], n3(:,5729), t3x32(:,:,2274))
  call heltable([8,4,32], n3(:,5730), t3x32(:,:,2275))
  call heltable([4,8,32], n3(:,5731), t3x32(:,:,2276))
  call heltable([4,8,32], n3(:,5732), t3x32(:,:,2277))
  call heltable([4,8,32], n3(:,5733), t3x32(:,:,2278))
  call heltable([4,8,32], n3(:,5734), t3x32(:,:,2279))
  call heltable([8,4,32], n3(:,5735), t3x32(:,:,2280))
  call heltable([4,8,32], n3(:,5736), t3x32(:,:,2281))
  call heltable([4,8,32], n3(:,5737), t3x32(:,:,2282))
  call heltable([8,4,32], n3(:,5738), t3x32(:,:,2283))
  call heltable([4,8,32], n3(:,5739), t3x32(:,:,2284))
  call heltable([8,4,32], n3(:,5740), t3x32(:,:,2285))
  call heltable([4,8,32], n3(:,5741), t3x32(:,:,2286))
  call heltable([8,4,32], n3(:,5742), t3x32(:,:,2287))
  call heltable([4,8,32], n3(:,5743), t3x32(:,:,2288))
  call heltable([16,2,32], n3(:,5744), t3x32(:,:,2289))
  call heltable([16,2,32], n3(:,5745), t3x32(:,:,2290))
  call heltable([16,2,32], n3(:,5746), t3x32(:,:,2291))
  call heltable([16,2,32], n3(:,5747), t3x32(:,:,2292))
  call heltable([2,16,32], n3(:,5748), t3x32(:,:,2293))
  call heltable([2,16,32], n3(:,5749), t3x32(:,:,2294))
  call heltable([2,16,32], n3(:,5750), t3x32(:,:,2295))
  call heltable([2,16,32], n3(:,5751), t3x32(:,:,2296))
  call heltable([16,2,32], n3(:,5752), t3x32(:,:,2297))
  call heltable([16,2,32], n3(:,5753), t3x32(:,:,2298))
  call heltable([16,2,32], n3(:,5754), t3x32(:,:,2299))
  call heltable([16,2,32], n3(:,5755), t3x32(:,:,2300))
  call heltable([2,16,32], n3(:,5756), t3x32(:,:,2301))
  call heltable([2,16,32], n3(:,5757), t3x32(:,:,2302))
  call heltable([2,16,32], n3(:,5758), t3x32(:,:,2303))
  call heltable([2,16,32], n3(:,5759), t3x32(:,:,2304))
  call heltable([2,16,32], n3(:,5760), t3x32(:,:,2305))
  n2(1721) = 32
  call heltable([2,16,32], n3(:,5761), t3x32(:,:,2306))
  n2(1722) = 32
  call heltable([2,16,32], n3(:,5762), t3x32(:,:,2307))
  n2(1723) = 32
  call heltable([2,16,32], n3(:,5763), t3x32(:,:,2308))
  n2(1724) = 32
  call heltable([16,2,32], n3(:,5764), t3x32(:,:,2309))
  n2(1725) = 32
  call heltable([16,2,32], n3(:,5765), t3x32(:,:,2310))
  n2(1726) = 32
  call heltable([16,2,32], n3(:,5766), t3x32(:,:,2311))
  n2(1727) = 32
  call heltable([16,2,32], n3(:,5767), t3x32(:,:,2312))
  n2(1728) = 32
  call heltable([2,16,32], n3(:,5768), t3x32(:,:,2313))
  n2(1729) = 32
  call heltable([2,16,32], n3(:,5769), t3x32(:,:,2314))
  n2(1730) = 32
  call heltable([2,16,32], n3(:,5770), t3x32(:,:,2315))
  n2(1731) = 32
  call heltable([2,16,32], n3(:,5771), t3x32(:,:,2316))
  n2(1732) = 32
  call heltable([16,2,32], n3(:,5772), t3x32(:,:,2317))
  n2(1733) = 32
  call heltable([16,2,32], n3(:,5773), t3x32(:,:,2318))
  n2(1734) = 32
  call heltable([16,2,32], n3(:,5774), t3x32(:,:,2319))
  n2(1735) = 32
  call heltable([16,2,32], n3(:,5775), t3x32(:,:,2320))
  n2(1736) = 32
  call heltable([16,2,32], n3(:,5776), t3x32(:,:,2321))
  n2(1737) = 32
  call heltable([16,2,32], n3(:,5777), t3x32(:,:,2322))
  n2(1738) = 32
  call heltable([16,2,32], n3(:,5778), t3x32(:,:,2323))
  n2(1739) = 32
  call heltable([16,2,32], n3(:,5779), t3x32(:,:,2324))
  n2(1740) = 32
  call heltable([2,16,32], n3(:,5780), t3x32(:,:,2325))
  n2(1741) = 32
  call heltable([2,16,32], n3(:,5781), t3x32(:,:,2326))
  n2(1742) = 32
  call heltable([2,16,32], n3(:,5782), t3x32(:,:,2327))
  n2(1743) = 32
  call heltable([2,16,32], n3(:,5783), t3x32(:,:,2328))
  n2(1744) = 32
  call heltable([16,2,32], n3(:,5784), t3x32(:,:,2329))
  n2(1745) = 32
  call heltable([16,2,32], n3(:,5785), t3x32(:,:,2330))
  n2(1746) = 32
  call heltable([16,2,32], n3(:,5786), t3x32(:,:,2331))
  n2(1747) = 32
  call heltable([16,2,32], n3(:,5787), t3x32(:,:,2332))
  n2(1748) = 32
  call heltable([2,16,32], n3(:,5788), t3x32(:,:,2333))
  n2(1749) = 32
  call heltable([2,16,32], n3(:,5789), t3x32(:,:,2334))
  n2(1750) = 32
  call heltable([2,16,32], n3(:,5790), t3x32(:,:,2335))
  n2(1751) = 32
  call heltable([2,16,32], n3(:,5791), t3x32(:,:,2336))
  n2(1752) = 32
  call heltable([2,16,32], n3(:,5792), t3x32(:,:,2337))
  call heltable([2,16,32], n3(:,5793), t3x32(:,:,2338))
  call heltable([2,16,32], n3(:,5794), t3x32(:,:,2339))
  call heltable([2,16,32], n3(:,5795), t3x32(:,:,2340))
  call heltable([16,2,32], n3(:,5796), t3x32(:,:,2341))
  call heltable([16,2,32], n3(:,5797), t3x32(:,:,2342))
  call heltable([16,2,32], n3(:,5798), t3x32(:,:,2343))
  call heltable([16,2,32], n3(:,5799), t3x32(:,:,2344))
  call heltable([2,16,32], n3(:,5800), t3x32(:,:,2345))
  call heltable([2,16,32], n3(:,5801), t3x32(:,:,2346))
  call heltable([2,16,32], n3(:,5802), t3x32(:,:,2347))
  call heltable([2,16,32], n3(:,5803), t3x32(:,:,2348))
  call heltable([16,2,32], n3(:,5804), t3x32(:,:,2349))
  call heltable([16,2,32], n3(:,5805), t3x32(:,:,2350))
  call heltable([16,2,32], n3(:,5806), t3x32(:,:,2351))
  call heltable([16,2,32], n3(:,5807), t3x32(:,:,2352))
  call heltable([2,16,32], n3(:,5808), t3x32(:,:,2353))
  n2(1753) = 32
  call heltable([2,16,32], n3(:,5809), t3x32(:,:,2354))
  n2(1754) = 32
  call heltable([2,16,32], n3(:,5810), t3x32(:,:,2355))
  n2(1755) = 32
  call heltable([2,16,32], n3(:,5811), t3x32(:,:,2356))
  n2(1756) = 32
  call heltable([16,2,32], n3(:,5812), t3x32(:,:,2357))
  n2(1757) = 32
  call heltable([16,2,32], n3(:,5813), t3x32(:,:,2358))
  n2(1758) = 32
  call heltable([16,2,32], n3(:,5814), t3x32(:,:,2359))
  n2(1759) = 32
  call heltable([16,2,32], n3(:,5815), t3x32(:,:,2360))
  n2(1760) = 32
  call heltable([2,16,32], n3(:,5816), t3x32(:,:,2361))
  n2(1761) = 32
  call heltable([2,16,32], n3(:,5817), t3x32(:,:,2362))
  n2(1762) = 32
  call heltable([2,16,32], n3(:,5818), t3x32(:,:,2363))
  n2(1763) = 32
  call heltable([2,16,32], n3(:,5819), t3x32(:,:,2364))
  n2(1764) = 32
  call heltable([16,2,32], n3(:,5820), t3x32(:,:,2365))
  n2(1765) = 32
  call heltable([16,2,32], n3(:,5821), t3x32(:,:,2366))
  n2(1766) = 32
  call heltable([16,2,32], n3(:,5822), t3x32(:,:,2367))
  n2(1767) = 32
  call heltable([16,2,32], n3(:,5823), t3x32(:,:,2368))
  n2(1768) = 32
  call heltable([16,2,32], n3(:,5824), t3x32(:,:,2369))
  n2(1769) = 32
  call heltable([16,2,32], n3(:,5825), t3x32(:,:,2370))
  n2(1770) = 32
  call heltable([16,2,32], n3(:,5826), t3x32(:,:,2371))
  n2(1771) = 32
  call heltable([16,2,32], n3(:,5827), t3x32(:,:,2372))
  n2(1772) = 32
  call heltable([2,16,32], n3(:,5828), t3x32(:,:,2373))
  n2(1773) = 32
  call heltable([2,16,32], n3(:,5829), t3x32(:,:,2374))
  n2(1774) = 32
  call heltable([2,16,32], n3(:,5830), t3x32(:,:,2375))
  n2(1775) = 32
  call heltable([2,16,32], n3(:,5831), t3x32(:,:,2376))
  n2(1776) = 32
  call heltable([16,2,32], n3(:,5832), t3x32(:,:,2377))
  n2(1777) = 32
  call heltable([16,2,32], n3(:,5833), t3x32(:,:,2378))
  n2(1778) = 32
  call heltable([16,2,32], n3(:,5834), t3x32(:,:,2379))
  n2(1779) = 32
  call heltable([16,2,32], n3(:,5835), t3x32(:,:,2380))
  n2(1780) = 32
  call heltable([2,16,32], n3(:,5836), t3x32(:,:,2381))
  n2(1781) = 32
  call heltable([2,16,32], n3(:,5837), t3x32(:,:,2382))
  n2(1782) = 32
  call heltable([2,16,32], n3(:,5838), t3x32(:,:,2383))
  n2(1783) = 32
  call heltable([2,16,32], n3(:,5839), t3x32(:,:,2384))
  n2(1784) = 32
  call heltable([16,2,32], n3(:,5840), t3x32(:,:,2385))
  call heltable([16,2,32], n3(:,5841), t3x32(:,:,2386))
  call heltable([16,2,32], n3(:,5842), t3x32(:,:,2387))
  call heltable([16,2,32], n3(:,5843), t3x32(:,:,2388))
  call heltable([2,16,32], n3(:,5844), t3x32(:,:,2389))
  call heltable([2,16,32], n3(:,5845), t3x32(:,:,2390))
  call heltable([2,16,32], n3(:,5846), t3x32(:,:,2391))
  call heltable([2,16,32], n3(:,5847), t3x32(:,:,2392))
  call heltable([16,2,32], n3(:,5848), t3x32(:,:,2393))
  call heltable([16,2,32], n3(:,5849), t3x32(:,:,2394))
  call heltable([16,2,32], n3(:,5850), t3x32(:,:,2395))
  call heltable([16,2,32], n3(:,5851), t3x32(:,:,2396))
  call heltable([2,16,32], n3(:,5852), t3x32(:,:,2397))
  call heltable([2,16,32], n3(:,5853), t3x32(:,:,2398))
  call heltable([2,16,32], n3(:,5854), t3x32(:,:,2399))
  call heltable([2,16,32], n3(:,5855), t3x32(:,:,2400))
  call heltable([2,16,32], n3(:,5856), t3x32(:,:,2401))
  n2(1785) = 32
  call heltable([2,16,32], n3(:,5857), t3x32(:,:,2402))
  n2(1786) = 32
  call heltable([2,16,32], n3(:,5858), t3x32(:,:,2403))
  n2(1787) = 32
  call heltable([2,16,32], n3(:,5859), t3x32(:,:,2404))
  n2(1788) = 32
  call heltable([16,2,32], n3(:,5860), t3x32(:,:,2405))
  n2(1789) = 32
  call heltable([16,2,32], n3(:,5861), t3x32(:,:,2406))
  n2(1790) = 32
  call heltable([16,2,32], n3(:,5862), t3x32(:,:,2407))
  n2(1791) = 32
  call heltable([16,2,32], n3(:,5863), t3x32(:,:,2408))
  n2(1792) = 32
  call heltable([2,16,32], n3(:,5864), t3x32(:,:,2409))
  n2(1793) = 32
  call heltable([2,16,32], n3(:,5865), t3x32(:,:,2410))
  n2(1794) = 32
  call heltable([2,16,32], n3(:,5866), t3x32(:,:,2411))
  n2(1795) = 32
  call heltable([2,16,32], n3(:,5867), t3x32(:,:,2412))
  n2(1796) = 32
  call heltable([16,2,32], n3(:,5868), t3x32(:,:,2413))
  n2(1797) = 32
  call heltable([16,2,32], n3(:,5869), t3x32(:,:,2414))
  n2(1798) = 32
  call heltable([16,2,32], n3(:,5870), t3x32(:,:,2415))
  n2(1799) = 32
  call heltable([16,2,32], n3(:,5871), t3x32(:,:,2416))
  n2(1800) = 32
  call heltable([16,2,32], n3(:,5872), t3x32(:,:,2417))
  n2(1801) = 32
  call heltable([16,2,32], n3(:,5873), t3x32(:,:,2418))
  n2(1802) = 32
  call heltable([16,2,32], n3(:,5874), t3x32(:,:,2419))
  n2(1803) = 32
  call heltable([16,2,32], n3(:,5875), t3x32(:,:,2420))
  n2(1804) = 32
  call heltable([2,16,32], n3(:,5876), t3x32(:,:,2421))
  n2(1805) = 32
  call heltable([2,16,32], n3(:,5877), t3x32(:,:,2422))
  n2(1806) = 32
  call heltable([2,16,32], n3(:,5878), t3x32(:,:,2423))
  n2(1807) = 32
  call heltable([2,16,32], n3(:,5879), t3x32(:,:,2424))
  n2(1808) = 32
  call heltable([16,2,32], n3(:,5880), t3x32(:,:,2425))
  n2(1809) = 32
  call heltable([16,2,32], n3(:,5881), t3x32(:,:,2426))
  n2(1810) = 32
  call heltable([16,2,32], n3(:,5882), t3x32(:,:,2427))
  n2(1811) = 32
  call heltable([16,2,32], n3(:,5883), t3x32(:,:,2428))
  n2(1812) = 32
  call heltable([2,16,32], n3(:,5884), t3x32(:,:,2429))
  n2(1813) = 32
  call heltable([2,16,32], n3(:,5885), t3x32(:,:,2430))
  n2(1814) = 32
  call heltable([2,16,32], n3(:,5886), t3x32(:,:,2431))
  n2(1815) = 32
  call heltable([2,16,32], n3(:,5887), t3x32(:,:,2432))
  n2(1816) = 32
  call heltable([2,16,32], n3(:,5888), t3x32(:,:,2433))
  call heltable([2,16,32], n3(:,5889), t3x32(:,:,2434))
  call heltable([2,16,32], n3(:,5890), t3x32(:,:,2435))
  call heltable([2,16,32], n3(:,5891), t3x32(:,:,2436))
  call heltable([16,2,32], n3(:,5892), t3x32(:,:,2437))
  call heltable([16,2,32], n3(:,5893), t3x32(:,:,2438))
  call heltable([16,2,32], n3(:,5894), t3x32(:,:,2439))
  call heltable([16,2,32], n3(:,5895), t3x32(:,:,2440))
  call heltable([2,16,32], n3(:,5896), t3x32(:,:,2441))
  call heltable([2,16,32], n3(:,5897), t3x32(:,:,2442))
  call heltable([2,16,32], n3(:,5898), t3x32(:,:,2443))
  call heltable([2,16,32], n3(:,5899), t3x32(:,:,2444))
  call heltable([16,2,32], n3(:,5900), t3x32(:,:,2445))
  call heltable([16,2,32], n3(:,5901), t3x32(:,:,2446))
  call heltable([16,2,32], n3(:,5902), t3x32(:,:,2447))
  call heltable([16,2,32], n3(:,5903), t3x32(:,:,2448))
  call heltable([2,16,32], n3(:,5904), t3x32(:,:,2449))
  n2(1817) = 32
  call heltable([2,16,32], n3(:,5905), t3x32(:,:,2450))
  n2(1818) = 32
  call heltable([2,16,32], n3(:,5906), t3x32(:,:,2451))
  n2(1819) = 32
  call heltable([2,16,32], n3(:,5907), t3x32(:,:,2452))
  n2(1820) = 32
  call heltable([16,2,32], n3(:,5908), t3x32(:,:,2453))
  n2(1821) = 32
  call heltable([16,2,32], n3(:,5909), t3x32(:,:,2454))
  n2(1822) = 32
  call heltable([16,2,32], n3(:,5910), t3x32(:,:,2455))
  n2(1823) = 32
  call heltable([16,2,32], n3(:,5911), t3x32(:,:,2456))
  n2(1824) = 32
  call heltable([2,16,32], n3(:,5912), t3x32(:,:,2457))
  n2(1825) = 32
  call heltable([2,16,32], n3(:,5913), t3x32(:,:,2458))
  n2(1826) = 32
  call heltable([2,16,32], n3(:,5914), t3x32(:,:,2459))
  n2(1827) = 32
  call heltable([2,16,32], n3(:,5915), t3x32(:,:,2460))
  n2(1828) = 32
  call heltable([16,2,32], n3(:,5916), t3x32(:,:,2461))
  n2(1829) = 32
  call heltable([16,2,32], n3(:,5917), t3x32(:,:,2462))
  n2(1830) = 32
  call heltable([16,2,32], n3(:,5918), t3x32(:,:,2463))
  n2(1831) = 32
  call heltable([16,2,32], n3(:,5919), t3x32(:,:,2464))
  n2(1832) = 32
  call heltable([16,2,32], n3(:,5920), t3x32(:,:,2465))
  n2(1833) = 32
  call heltable([16,2,32], n3(:,5921), t3x32(:,:,2466))
  n2(1834) = 32
  call heltable([16,2,32], n3(:,5922), t3x32(:,:,2467))
  n2(1835) = 32
  call heltable([16,2,32], n3(:,5923), t3x32(:,:,2468))
  n2(1836) = 32
  call heltable([2,16,32], n3(:,5924), t3x32(:,:,2469))
  n2(1837) = 32
  call heltable([2,16,32], n3(:,5925), t3x32(:,:,2470))
  n2(1838) = 32
  call heltable([2,16,32], n3(:,5926), t3x32(:,:,2471))
  n2(1839) = 32
  call heltable([2,16,32], n3(:,5927), t3x32(:,:,2472))
  n2(1840) = 32
  call heltable([16,2,32], n3(:,5928), t3x32(:,:,2473))
  n2(1841) = 32
  call heltable([16,2,32], n3(:,5929), t3x32(:,:,2474))
  n2(1842) = 32
  call heltable([16,2,32], n3(:,5930), t3x32(:,:,2475))
  n2(1843) = 32
  call heltable([16,2,32], n3(:,5931), t3x32(:,:,2476))
  n2(1844) = 32
  call heltable([2,16,32], n3(:,5932), t3x32(:,:,2477))
  n2(1845) = 32
  call heltable([2,16,32], n3(:,5933), t3x32(:,:,2478))
  n2(1846) = 32
  call heltable([2,16,32], n3(:,5934), t3x32(:,:,2479))
  n2(1847) = 32
  call heltable([2,16,32], n3(:,5935), t3x32(:,:,2480))
  n2(1848) = 32
  call heltable([16,2,32], n3(:,5936), t3x32(:,:,2481))
  call heltable([16,2,32], n3(:,5937), t3x32(:,:,2482))
  call heltable([16,2,32], n3(:,5938), t3x32(:,:,2483))
  call heltable([16,2,32], n3(:,5939), t3x32(:,:,2484))
  call heltable([2,16,32], n3(:,5940), t3x32(:,:,2485))
  call heltable([2,16,32], n3(:,5941), t3x32(:,:,2486))
  call heltable([2,16,32], n3(:,5942), t3x32(:,:,2487))
  call heltable([2,16,32], n3(:,5943), t3x32(:,:,2488))
  call heltable([16,2,32], n3(:,5944), t3x32(:,:,2489))
  call heltable([16,2,32], n3(:,5945), t3x32(:,:,2490))
  call heltable([16,2,32], n3(:,5946), t3x32(:,:,2491))
  call heltable([16,2,32], n3(:,5947), t3x32(:,:,2492))
  call heltable([2,16,32], n3(:,5948), t3x32(:,:,2493))
  call heltable([2,16,32], n3(:,5949), t3x32(:,:,2494))
  call heltable([2,16,32], n3(:,5950), t3x32(:,:,2495))
  call heltable([2,16,32], n3(:,5951), t3x32(:,:,2496))
  call heltable([8,4,32], n3(:,5952), t3x32(:,:,2497))
  n2(1849) = 32
  call heltable([8,4,32], n3(:,5953), t3x32(:,:,2498))
  n2(1850) = 32
  call heltable([8,4,32], n3(:,5954), t3x32(:,:,2499))
  n2(1851) = 32
  call heltable([8,4,32], n3(:,5955), t3x32(:,:,2500))
  n2(1852) = 32
  call heltable([4,8,32], n3(:,5956), t3x32(:,:,2501))
  n2(1853) = 32
  call heltable([4,8,32], n3(:,5957), t3x32(:,:,2502))
  n2(1854) = 32
  call heltable([4,8,32], n3(:,5958), t3x32(:,:,2503))
  n2(1855) = 32
  call heltable([4,8,32], n3(:,5959), t3x32(:,:,2504))
  n2(1856) = 32
  call heltable([8,4,32], n3(:,5960), t3x32(:,:,2505))
  n2(1857) = 32
  call heltable([8,4,32], n3(:,5961), t3x32(:,:,2506))
  n2(1858) = 32
  call heltable([8,4,32], n3(:,5962), t3x32(:,:,2507))
  n2(1859) = 32
  call heltable([8,4,32], n3(:,5963), t3x32(:,:,2508))
  n2(1860) = 32
  call heltable([4,8,32], n3(:,5964), t3x32(:,:,2509))
  n2(1861) = 32
  call heltable([4,8,32], n3(:,5965), t3x32(:,:,2510))
  n2(1862) = 32
  call heltable([4,8,32], n3(:,5966), t3x32(:,:,2511))
  n2(1863) = 32
  call heltable([4,8,32], n3(:,5967), t3x32(:,:,2512))
  n2(1864) = 32
  call heltable([8,4,32], n3(:,5968), t3x32(:,:,2513))
  n2(1865) = 32
  call heltable([8,4,32], n3(:,5969), t3x32(:,:,2514))
  n2(1866) = 32
  call heltable([8,4,32], n3(:,5970), t3x32(:,:,2515))
  n2(1867) = 32
  call heltable([8,4,32], n3(:,5971), t3x32(:,:,2516))
  n2(1868) = 32
  call heltable([4,8,32], n3(:,5972), t3x32(:,:,2517))
  n2(1869) = 32
  call heltable([4,8,32], n3(:,5973), t3x32(:,:,2518))
  n2(1870) = 32
  call heltable([4,8,32], n3(:,5974), t3x32(:,:,2519))
  n2(1871) = 32
  call heltable([4,8,32], n3(:,5975), t3x32(:,:,2520))
  n2(1872) = 32
  call heltable([8,4,32], n3(:,5976), t3x32(:,:,2521))
  n2(1873) = 32
  call heltable([8,4,32], n3(:,5977), t3x32(:,:,2522))
  n2(1874) = 32
  call heltable([8,4,32], n3(:,5978), t3x32(:,:,2523))
  n2(1875) = 32
  call heltable([8,4,32], n3(:,5979), t3x32(:,:,2524))
  n2(1876) = 32
  call heltable([4,8,32], n3(:,5980), t3x32(:,:,2525))
  n2(1877) = 32
  call heltable([4,8,32], n3(:,5981), t3x32(:,:,2526))
  n2(1878) = 32
  call heltable([4,8,32], n3(:,5982), t3x32(:,:,2527))
  n2(1879) = 32
  call heltable([4,8,32], n3(:,5983), t3x32(:,:,2528))
  n2(1880) = 32
  call heltable([2,16,32], n3(:,5984), t3x32(:,:,2529))
  n2(1881) = 32
  call heltable([2,16,32], n3(:,5985), t3x32(:,:,2530))
  n2(1882) = 32
  call heltable([2,16,32], n3(:,5986), t3x32(:,:,2531))
  n2(1883) = 32
  call heltable([2,16,32], n3(:,5987), t3x32(:,:,2532))
  n2(1884) = 32
  call heltable([2,16,32], n3(:,5988), t3x32(:,:,2533))
  n2(1885) = 32
  call heltable([2,16,32], n3(:,5989), t3x32(:,:,2534))
  n2(1886) = 32
  call heltable([2,16,32], n3(:,5990), t3x32(:,:,2535))
  n2(1887) = 32
  call heltable([2,16,32], n3(:,5991), t3x32(:,:,2536))
  n2(1888) = 32
  call heltable([2,16,32], n3(:,5992), t3x32(:,:,2537))
  n2(1889) = 32
  call heltable([16,2,32], n3(:,5993), t3x32(:,:,2538))
  n2(1890) = 32
  call heltable([16,2,32], n3(:,5994), t3x32(:,:,2539))
  n2(1891) = 32
  call heltable([16,2,32], n3(:,5995), t3x32(:,:,2540))
  n2(1892) = 32
  call heltable([16,2,32], n3(:,5996), t3x32(:,:,2541))
  n2(1893) = 32
  call heltable([4,8,32], n3(:,5997), t3x32(:,:,2542))
  n2(1894) = 32
  call heltable([4,8,32], n3(:,5998), t3x32(:,:,2543))
  n2(1895) = 32
  call heltable([4,8,32], n3(:,5999), t3x32(:,:,2544))
  n2(1896) = 32
  call heltable([4,8,32], n3(:,6000), t3x32(:,:,2545))
  n2(1897) = 32
  call heltable([8,4,32], n3(:,6001), t3x32(:,:,2546))
  n2(1898) = 32
  call heltable([8,4,32], n3(:,6002), t3x32(:,:,2547))
  n2(1899) = 32
  call heltable([8,4,32], n3(:,6003), t3x32(:,:,2548))
  n2(1900) = 32
  call heltable([8,4,32], n3(:,6004), t3x32(:,:,2549))
  n2(1901) = 32
  call heltable([4,8,32], n3(:,6005), t3x32(:,:,2550))
  n2(1902) = 32
  call heltable([4,8,32], n3(:,6006), t3x32(:,:,2551))
  n2(1903) = 32
  call heltable([4,8,32], n3(:,6007), t3x32(:,:,2552))
  n2(1904) = 32
  call heltable([4,8,32], n3(:,6008), t3x32(:,:,2553))
  n2(1905) = 32
  call heltable([8,4,32], n3(:,6009), t3x32(:,:,2554))
  n2(1906) = 32
  call heltable([8,4,32], n3(:,6010), t3x32(:,:,2555))
  n2(1907) = 32
  call heltable([8,4,32], n3(:,6011), t3x32(:,:,2556))
  n2(1908) = 32
  call heltable([8,4,32], n3(:,6012), t3x32(:,:,2557))
  n2(1909) = 32
  call heltable([4,8,32], n3(:,6013), t3x32(:,:,2558))
  n2(1910) = 32
  call heltable([4,8,32], n3(:,6014), t3x32(:,:,2559))
  n2(1911) = 32
  call heltable([4,8,32], n3(:,6015), t3x32(:,:,2560))
  n2(1912) = 32
  call heltable([4,8,32], n3(:,6016), t3x32(:,:,2561))
  n2(1913) = 32
  call heltable([4,8,32], n3(:,6017), t3x32(:,:,2562))
  n2(1914) = 32
  call heltable([4,8,32], n3(:,6018), t3x32(:,:,2563))
  n2(1915) = 32
  call heltable([4,8,32], n3(:,6019), t3x32(:,:,2564))
  n2(1916) = 32
  call heltable([4,8,32], n3(:,6020), t3x32(:,:,2565))
  n2(1917) = 32
  call heltable([8,4,32], n3(:,6021), t3x32(:,:,2566))
  n2(1918) = 32
  call heltable([8,4,32], n3(:,6022), t3x32(:,:,2567))
  n2(1919) = 32
  call heltable([8,4,32], n3(:,6023), t3x32(:,:,2568))
  n2(1920) = 32
  call heltable([8,4,32], n3(:,6024), t3x32(:,:,2569))
  n2(1921) = 32
  call heltable([8,4,32], n3(:,6025), t3x32(:,:,2570))
  n2(1922) = 32
  call heltable([8,4,32], n3(:,6026), t3x32(:,:,2571))
  n2(1923) = 32
  call heltable([8,4,32], n3(:,6027), t3x32(:,:,2572))
  n2(1924) = 32
  call heltable([8,4,32], n3(:,6028), t3x32(:,:,2573))
  n2(1925) = 32
  call heltable([16,2,32], n3(:,6029), t3x32(:,:,2574))
  n2(1926) = 32
  call heltable([16,2,32], n3(:,6030), t3x32(:,:,2575))
  n2(1927) = 32
  call heltable([16,2,32], n3(:,6031), t3x32(:,:,2576))
  n2(1928) = 32
  call heltable([16,2,32], n3(:,6032), t3x32(:,:,2577))
  n2(1929) = 32
  call heltable([16,2,32], n3(:,6033), t3x32(:,:,2578))
  n2(1930) = 32
  call heltable([16,2,32], n3(:,6034), t3x32(:,:,2579))
  n2(1931) = 32
  call heltable([2,16,32], n3(:,6035), t3x32(:,:,2580))
  n2(1932) = 32
  call heltable([2,16,32], n3(:,6036), t3x32(:,:,2581))
  n2(1933) = 32
  call heltable([2,16,32], n3(:,6037), t3x32(:,:,2582))
  n2(1934) = 32
  call heltable([16,2,32], n3(:,6038), t3x32(:,:,2583))
  n2(1935) = 32
  call heltable([16,2,32], n3(:,6039), t3x32(:,:,2584))
  n2(1936) = 32
  call heltable([16,2,32], n3(:,6040), t3x32(:,:,2585))
  n2(1937) = 32
  call heltable([2,16,32], n3(:,6041), t3x32(:,:,2586))
  n2(1938) = 32
  call heltable([4,8,32], n3(:,6042), t3x32(:,:,2587))
  call heltable([4,8,32], n3(:,6043), t3x32(:,:,2588))
  call heltable([4,8,32], n3(:,6044), t3x32(:,:,2589))
  call heltable([4,8,32], n3(:,6045), t3x32(:,:,2590))
  call heltable([8,4,32], n3(:,6046), t3x32(:,:,2591))
  call heltable([4,8,32], n3(:,6047), t3x32(:,:,2592))
  call heltable([4,8,32], n3(:,6048), t3x32(:,:,2593))
  call heltable([8,4,32], n3(:,6049), t3x32(:,:,2594))
  call heltable([4,8,32], n3(:,6050), t3x32(:,:,2595))
  call heltable([8,4,32], n3(:,6051), t3x32(:,:,2596))
  call heltable([4,8,32], n3(:,6052), t3x32(:,:,2597))
  call heltable([8,4,32], n3(:,6053), t3x32(:,:,2598))
  call heltable([4,8,32], n3(:,6054), t3x32(:,:,2599))
  call heltable([8,4,32], n3(:,6055), t3x32(:,:,2600))
  call heltable([8,4,32], n3(:,6056), t3x32(:,:,2601))
  call heltable([8,4,32], n3(:,6057), t3x32(:,:,2602))
  call heltable([8,4,32], n3(:,6058), t3x32(:,:,2603))
  call heltable([4,8,32], n3(:,6059), t3x32(:,:,2604))
  call heltable([4,8,32], n3(:,6060), t3x32(:,:,2605))
  call heltable([4,8,32], n3(:,6061), t3x32(:,:,2606))
  call heltable([4,8,32], n3(:,6062), t3x32(:,:,2607))
  call heltable([8,4,32], n3(:,6063), t3x32(:,:,2608))
  call heltable([8,4,32], n3(:,6064), t3x32(:,:,2609))
  call heltable([8,4,32], n3(:,6065), t3x32(:,:,2610))
  call heltable([8,4,32], n3(:,6066), t3x32(:,:,2611))
  call heltable([4,8,32], n3(:,6067), t3x32(:,:,2612))
  call heltable([4,8,32], n3(:,6068), t3x32(:,:,2613))
  call heltable([4,8,32], n3(:,6069), t3x32(:,:,2614))
  call heltable([4,8,32], n3(:,6070), t3x32(:,:,2615))
  call heltable([2,16,32], n3(:,6071), t3x32(:,:,2616))
  call heltable([2,16,32], n3(:,6072), t3x32(:,:,2617))
  call heltable([2,16,32], n3(:,6073), t3x32(:,:,2618))
  call heltable([2,16,32], n3(:,6074), t3x32(:,:,2619))
  call heltable([16,2,32], n3(:,6075), t3x32(:,:,2620))
  call heltable([16,2,32], n3(:,6076), t3x32(:,:,2621))
  call heltable([16,2,32], n3(:,6077), t3x32(:,:,2622))
  call heltable([16,2,32], n3(:,6078), t3x32(:,:,2623))
  call heltable([2,16,32], n3(:,6079), t3x32(:,:,2624))
  call heltable([2,16,32], n3(:,6080), t3x32(:,:,2625))
  call heltable([2,16,32], n3(:,6081), t3x32(:,:,2626))
  call heltable([2,16,32], n3(:,6082), t3x32(:,:,2627))
  call heltable([16,2,32], n3(:,6083), t3x32(:,:,2628))
  call heltable([16,2,32], n3(:,6084), t3x32(:,:,2629))
  call heltable([16,2,32], n3(:,6085), t3x32(:,:,2630))
  call heltable([16,2,32], n3(:,6086), t3x32(:,:,2631))
  call heltable([4,8,32], n3(:,6087), t3x32(:,:,2632))
  call heltable([4,8,32], n3(:,6088), t3x32(:,:,2633))
  call heltable([4,8,32], n3(:,6089), t3x32(:,:,2634))
  call heltable([4,8,32], n3(:,6090), t3x32(:,:,2635))
  call heltable([8,4,32], n3(:,6091), t3x32(:,:,2636))
  call heltable([8,4,32], n3(:,6092), t3x32(:,:,2637))
  call heltable([8,4,32], n3(:,6093), t3x32(:,:,2638))
  call heltable([8,4,32], n3(:,6094), t3x32(:,:,2639))
  call heltable([4,8,32], n3(:,6095), t3x32(:,:,2640))
  call heltable([4,8,32], n3(:,6096), t3x32(:,:,2641))
  call heltable([4,8,32], n3(:,6097), t3x32(:,:,2642))
  call heltable([4,8,32], n3(:,6098), t3x32(:,:,2643))
  call heltable([8,4,32], n3(:,6099), t3x32(:,:,2644))
  call heltable([8,4,32], n3(:,6100), t3x32(:,:,2645))
  call heltable([8,4,32], n3(:,6101), t3x32(:,:,2646))
  call heltable([8,4,32], n3(:,6102), t3x32(:,:,2647))
  call heltable([4,8,32], n3(:,6103), t3x32(:,:,2648))
  call heltable([4,8,32], n3(:,6104), t3x32(:,:,2649))
  call heltable([4,8,32], n3(:,6105), t3x32(:,:,2650))
  call heltable([4,8,32], n3(:,6106), t3x32(:,:,2651))
  call heltable([4,8,32], n3(:,6107), t3x32(:,:,2652))
  call heltable([8,4,32], n3(:,6108), t3x32(:,:,2653))
  call heltable([8,4,32], n3(:,6109), t3x32(:,:,2654))
  call heltable([4,8,32], n3(:,6110), t3x32(:,:,2655))
  call heltable([8,4,32], n3(:,6111), t3x32(:,:,2656))
  call heltable([4,8,32], n3(:,6112), t3x32(:,:,2657))
  call heltable([8,4,32], n3(:,6113), t3x32(:,:,2658))
  call heltable([4,8,32], n3(:,6114), t3x32(:,:,2659))
  call heltable([4,8,32], n3(:,6115), t3x32(:,:,2660))
  call heltable([16,2,32], n3(:,6116), t3x32(:,:,2661))
  call heltable([16,2,32], n3(:,6117), t3x32(:,:,2662))
  call heltable([16,2,32], n3(:,6118), t3x32(:,:,2663))
  call heltable([16,2,32], n3(:,6119), t3x32(:,:,2664))
  call heltable([16,2,32], n3(:,6120), t3x32(:,:,2665))
  call heltable([16,2,32], n3(:,6121), t3x32(:,:,2666))
  call heltable([16,2,32], n3(:,6122), t3x32(:,:,2667))
  call heltable([16,2,32], n3(:,6123), t3x32(:,:,2668))
  call heltable([2,16,32], n3(:,6124), t3x32(:,:,2669))
  call heltable([2,16,32], n3(:,6125), t3x32(:,:,2670))
  call heltable([2,16,32], n3(:,6126), t3x32(:,:,2671))
  call heltable([2,16,32], n3(:,6127), t3x32(:,:,2672))
  call heltable([2,16,32], n3(:,6128), t3x32(:,:,2673))
  call heltable([2,16,32], n3(:,6129), t3x32(:,:,2674))
  call heltable([2,16,32], n3(:,6130), t3x32(:,:,2675))
  call heltable([2,16,32], n3(:,6131), t3x32(:,:,2676))
  call heltable([8,4,32], n3(:,6132), t3x32(:,:,2677))
  call heltable([8,4,32], n3(:,6133), t3x32(:,:,2678))
  call heltable([8,4,32], n3(:,6134), t3x32(:,:,2679))
  call heltable([8,4,32], n3(:,6135), t3x32(:,:,2680))
  call heltable([4,8,32], n3(:,6136), t3x32(:,:,2681))
  call heltable([4,8,32], n3(:,6137), t3x32(:,:,2682))
  call heltable([4,8,32], n3(:,6138), t3x32(:,:,2683))
  call heltable([4,8,32], n3(:,6139), t3x32(:,:,2684))
  call heltable([8,4,32], n3(:,6140), t3x32(:,:,2685))
  call heltable([8,4,32], n3(:,6141), t3x32(:,:,2686))
  call heltable([8,4,32], n3(:,6142), t3x32(:,:,2687))
  call heltable([8,4,32], n3(:,6143), t3x32(:,:,2688))
  call heltable([4,8,32], n3(:,6144), t3x32(:,:,2689))
  call heltable([4,8,32], n3(:,6145), t3x32(:,:,2690))
  call heltable([4,8,32], n3(:,6146), t3x32(:,:,2691))
  call heltable([4,8,32], n3(:,6147), t3x32(:,:,2692))
  call heltable([4,8,32], n3(:,6148), t3x32(:,:,2693))
  call heltable([4,8,32], n3(:,6149), t3x32(:,:,2694))
  call heltable([4,8,32], n3(:,6150), t3x32(:,:,2695))
  call heltable([4,8,32], n3(:,6151), t3x32(:,:,2696))
  call heltable([8,4,32], n3(:,6152), t3x32(:,:,2697))
  call heltable([4,8,32], n3(:,6153), t3x32(:,:,2698))
  call heltable([4,8,32], n3(:,6154), t3x32(:,:,2699))
  call heltable([8,4,32], n3(:,6155), t3x32(:,:,2700))
  call heltable([4,8,32], n3(:,6156), t3x32(:,:,2701))
  call heltable([8,4,32], n3(:,6157), t3x32(:,:,2702))
  call heltable([4,8,32], n3(:,6158), t3x32(:,:,2703))
  call heltable([8,4,32], n3(:,6159), t3x32(:,:,2704))
  call heltable([4,8,32], n3(:,6160), t3x32(:,:,2705))
  call heltable([2,16,32], n3(:,6161), t3x32(:,:,2706))
  call heltable([2,16,32], n3(:,6162), t3x32(:,:,2707))
  call heltable([2,16,32], n3(:,6163), t3x32(:,:,2708))
  call heltable([2,16,32], n3(:,6164), t3x32(:,:,2709))
  call heltable([16,2,32], n3(:,6165), t3x32(:,:,2710))
  call heltable([16,2,32], n3(:,6166), t3x32(:,:,2711))
  call heltable([16,2,32], n3(:,6167), t3x32(:,:,2712))
  call heltable([16,2,32], n3(:,6168), t3x32(:,:,2713))
  call heltable([2,16,32], n3(:,6169), t3x32(:,:,2714))
  call heltable([2,16,32], n3(:,6170), t3x32(:,:,2715))
  call heltable([2,16,32], n3(:,6171), t3x32(:,:,2716))
  call heltable([2,16,32], n3(:,6172), t3x32(:,:,2717))
  call heltable([16,2,32], n3(:,6173), t3x32(:,:,2718))
  call heltable([16,2,32], n3(:,6174), t3x32(:,:,2719))
  call heltable([16,2,32], n3(:,6175), t3x32(:,:,2720))
  call heltable([16,2,32], n3(:,6176), t3x32(:,:,2721))
  call heltable([4,8,32], n3(:,6177), t3x32(:,:,2722))
  call heltable([4,8,32], n3(:,6178), t3x32(:,:,2723))
  call heltable([4,8,32], n3(:,6179), t3x32(:,:,2724))
  call heltable([4,8,32], n3(:,6180), t3x32(:,:,2725))
  call heltable([8,4,32], n3(:,6181), t3x32(:,:,2726))
  call heltable([8,4,32], n3(:,6182), t3x32(:,:,2727))
  call heltable([8,4,32], n3(:,6183), t3x32(:,:,2728))
  call heltable([8,4,32], n3(:,6184), t3x32(:,:,2729))
  call heltable([4,8,32], n3(:,6185), t3x32(:,:,2730))
  call heltable([4,8,32], n3(:,6186), t3x32(:,:,2731))
  call heltable([4,8,32], n3(:,6187), t3x32(:,:,2732))
  call heltable([4,8,32], n3(:,6188), t3x32(:,:,2733))
  call heltable([8,4,32], n3(:,6189), t3x32(:,:,2734))
  call heltable([8,4,32], n3(:,6190), t3x32(:,:,2735))
  call heltable([8,4,32], n3(:,6191), t3x32(:,:,2736))
  call heltable([8,4,32], n3(:,6192), t3x32(:,:,2737))
  call heltable([4,8,32], n3(:,6193), t3x32(:,:,2738))
  call heltable([4,8,32], n3(:,6194), t3x32(:,:,2739))
  call heltable([4,8,32], n3(:,6195), t3x32(:,:,2740))
  call heltable([4,8,32], n3(:,6196), t3x32(:,:,2741))
  call heltable([8,4,32], n3(:,6197), t3x32(:,:,2742))
  call heltable([4,8,32], n3(:,6198), t3x32(:,:,2743))
  call heltable([4,8,32], n3(:,6199), t3x32(:,:,2744))
  call heltable([8,4,32], n3(:,6200), t3x32(:,:,2745))
  call heltable([4,8,32], n3(:,6201), t3x32(:,:,2746))
  call heltable([8,4,32], n3(:,6202), t3x32(:,:,2747))
  call heltable([4,8,32], n3(:,6203), t3x32(:,:,2748))
  call heltable([8,4,32], n3(:,6204), t3x32(:,:,2749))
  call heltable([4,8,32], n3(:,6205), t3x32(:,:,2750))
  call heltable([16,2,32], n3(:,6206), t3x32(:,:,2751))
  call heltable([16,2,32], n3(:,6207), t3x32(:,:,2752))
  call heltable([16,2,32], n3(:,6208), t3x32(:,:,2753))
  call heltable([16,2,32], n3(:,6209), t3x32(:,:,2754))
  call heltable([2,16,32], n3(:,6210), t3x32(:,:,2755))
  call heltable([2,16,32], n3(:,6211), t3x32(:,:,2756))
  call heltable([2,16,32], n3(:,6212), t3x32(:,:,2757))
  call heltable([2,16,32], n3(:,6213), t3x32(:,:,2758))
  call heltable([16,2,32], n3(:,6214), t3x32(:,:,2759))
  call heltable([16,2,32], n3(:,6215), t3x32(:,:,2760))
  call heltable([16,2,32], n3(:,6216), t3x32(:,:,2761))
  call heltable([16,2,32], n3(:,6217), t3x32(:,:,2762))
  call heltable([2,16,32], n3(:,6218), t3x32(:,:,2763))
  call heltable([2,16,32], n3(:,6219), t3x32(:,:,2764))
  call heltable([2,16,32], n3(:,6220), t3x32(:,:,2765))
  call heltable([2,16,32], n3(:,6221), t3x32(:,:,2766))
  call heltable([2,16,32], n3(:,6222), t3x32(:,:,2767))
  n2(1939) = 32
  call heltable([2,16,32], n3(:,6223), t3x32(:,:,2768))
  n2(1940) = 32
  call heltable([2,16,32], n3(:,6224), t3x32(:,:,2769))
  n2(1941) = 32
  call heltable([2,16,32], n3(:,6225), t3x32(:,:,2770))
  n2(1942) = 32
  call heltable([16,2,32], n3(:,6226), t3x32(:,:,2771))
  n2(1943) = 32
  call heltable([16,2,32], n3(:,6227), t3x32(:,:,2772))
  n2(1944) = 32
  call heltable([16,2,32], n3(:,6228), t3x32(:,:,2773))
  n2(1945) = 32
  call heltable([16,2,32], n3(:,6229), t3x32(:,:,2774))
  n2(1946) = 32
  call heltable([2,16,32], n3(:,6230), t3x32(:,:,2775))
  n2(1947) = 32
  call heltable([2,16,32], n3(:,6231), t3x32(:,:,2776))
  n2(1948) = 32
  call heltable([2,16,32], n3(:,6232), t3x32(:,:,2777))
  n2(1949) = 32
  call heltable([2,16,32], n3(:,6233), t3x32(:,:,2778))
  n2(1950) = 32
  call heltable([16,2,32], n3(:,6234), t3x32(:,:,2779))
  n2(1951) = 32
  call heltable([16,2,32], n3(:,6235), t3x32(:,:,2780))
  n2(1952) = 32
  call heltable([16,2,32], n3(:,6236), t3x32(:,:,2781))
  n2(1953) = 32
  call heltable([16,2,32], n3(:,6237), t3x32(:,:,2782))
  n2(1954) = 32
  call heltable([16,2,32], n3(:,6238), t3x32(:,:,2783))
  n2(1955) = 32
  call heltable([16,2,32], n3(:,6239), t3x32(:,:,2784))
  n2(1956) = 32
  call heltable([16,2,32], n3(:,6240), t3x32(:,:,2785))
  n2(1957) = 32
  call heltable([16,2,32], n3(:,6241), t3x32(:,:,2786))
  n2(1958) = 32
  call heltable([2,16,32], n3(:,6242), t3x32(:,:,2787))
  n2(1959) = 32
  call heltable([2,16,32], n3(:,6243), t3x32(:,:,2788))
  n2(1960) = 32
  call heltable([2,16,32], n3(:,6244), t3x32(:,:,2789))
  n2(1961) = 32
  call heltable([2,16,32], n3(:,6245), t3x32(:,:,2790))
  n2(1962) = 32
  call heltable([16,2,32], n3(:,6246), t3x32(:,:,2791))
  n2(1963) = 32
  call heltable([16,2,32], n3(:,6247), t3x32(:,:,2792))
  n2(1964) = 32
  call heltable([16,2,32], n3(:,6248), t3x32(:,:,2793))
  n2(1965) = 32
  call heltable([16,2,32], n3(:,6249), t3x32(:,:,2794))
  n2(1966) = 32
  call heltable([2,16,32], n3(:,6250), t3x32(:,:,2795))
  n2(1967) = 32
  call heltable([2,16,32], n3(:,6251), t3x32(:,:,2796))
  n2(1968) = 32
  call heltable([2,16,32], n3(:,6252), t3x32(:,:,2797))
  n2(1969) = 32
  call heltable([2,16,32], n3(:,6253), t3x32(:,:,2798))
  n2(1970) = 32
  call heltable([2,16,32], n3(:,6254), t3x32(:,:,2799))
  call heltable([2,16,32], n3(:,6255), t3x32(:,:,2800))
  call heltable([2,16,32], n3(:,6256), t3x32(:,:,2801))
  call heltable([2,16,32], n3(:,6257), t3x32(:,:,2802))
  call heltable([16,2,32], n3(:,6258), t3x32(:,:,2803))
  call heltable([16,2,32], n3(:,6259), t3x32(:,:,2804))
  call heltable([16,2,32], n3(:,6260), t3x32(:,:,2805))
  call heltable([16,2,32], n3(:,6261), t3x32(:,:,2806))
  call heltable([2,16,32], n3(:,6262), t3x32(:,:,2807))
  call heltable([2,16,32], n3(:,6263), t3x32(:,:,2808))
  call heltable([2,16,32], n3(:,6264), t3x32(:,:,2809))
  call heltable([2,16,32], n3(:,6265), t3x32(:,:,2810))
  call heltable([16,2,32], n3(:,6266), t3x32(:,:,2811))
  call heltable([16,2,32], n3(:,6267), t3x32(:,:,2812))
  call heltable([16,2,32], n3(:,6268), t3x32(:,:,2813))
  call heltable([16,2,32], n3(:,6269), t3x32(:,:,2814))
  call heltable([2,16,32], n3(:,6270), t3x32(:,:,2815))
  n2(1971) = 32
  call heltable([2,16,32], n3(:,6271), t3x32(:,:,2816))
  n2(1972) = 32
  call heltable([2,16,32], n3(:,6272), t3x32(:,:,2817))
  n2(1973) = 32
  call heltable([2,16,32], n3(:,6273), t3x32(:,:,2818))
  n2(1974) = 32
  call heltable([2,16,32], n3(:,6274), t3x32(:,:,2819))
  n2(1975) = 32
  call heltable([2,16,32], n3(:,6275), t3x32(:,:,2820))
  n2(1976) = 32
  call heltable([2,16,32], n3(:,6276), t3x32(:,:,2821))
  n2(1977) = 32
  call heltable([2,16,32], n3(:,6277), t3x32(:,:,2822))
  n2(1978) = 32
  call heltable([16,2,32], n3(:,6278), t3x32(:,:,2823))
  n2(1979) = 32
  call heltable([16,2,32], n3(:,6279), t3x32(:,:,2824))
  n2(1980) = 32
  call heltable([16,2,32], n3(:,6280), t3x32(:,:,2825))
  n2(1981) = 32
  call heltable([16,2,32], n3(:,6281), t3x32(:,:,2826))
  n2(1982) = 32
  call heltable([16,2,32], n3(:,6282), t3x32(:,:,2827))
  n2(1983) = 32
  call heltable([16,2,32], n3(:,6283), t3x32(:,:,2828))
  n2(1984) = 32
  call heltable([16,2,32], n3(:,6284), t3x32(:,:,2829))
  n2(1985) = 32
  call heltable([16,2,32], n3(:,6285), t3x32(:,:,2830))
  n2(1986) = 32
  call heltable([16,2,32], n3(:,6286), t3x32(:,:,2831))
  n2(1987) = 32
  call heltable([16,2,32], n3(:,6287), t3x32(:,:,2832))
  n2(1988) = 32
  call heltable([16,2,32], n3(:,6288), t3x32(:,:,2833))
  n2(1989) = 32
  call heltable([16,2,32], n3(:,6289), t3x32(:,:,2834))
  n2(1990) = 32
  call heltable([16,2,32], n3(:,6290), t3x32(:,:,2835))
  n2(1991) = 32
  call heltable([16,2,32], n3(:,6291), t3x32(:,:,2836))
  n2(1992) = 32
  call heltable([16,2,32], n3(:,6292), t3x32(:,:,2837))
  n2(1993) = 32
  call heltable([16,2,32], n3(:,6293), t3x32(:,:,2838))
  n2(1994) = 32
  call heltable([2,16,32], n3(:,6294), t3x32(:,:,2839))
  n2(1995) = 32
  call heltable([2,16,32], n3(:,6295), t3x32(:,:,2840))
  n2(1996) = 32
  call heltable([2,16,32], n3(:,6296), t3x32(:,:,2841))
  n2(1997) = 32
  call heltable([2,16,32], n3(:,6297), t3x32(:,:,2842))
  n2(1998) = 32
  call heltable([2,16,32], n3(:,6298), t3x32(:,:,2843))
  n2(1999) = 32
  call heltable([2,16,32], n3(:,6299), t3x32(:,:,2844))
  n2(2000) = 32
  call heltable([2,16,32], n3(:,6300), t3x32(:,:,2845))
  n2(2001) = 32
  call heltable([2,16,32], n3(:,6301), t3x32(:,:,2846))
  n2(2002) = 32
  call heltable([2,16,32], n3(:,6302), t3x32(:,:,2847))
  n2(2003) = 32
  call heltable([2,16,32], n3(:,6303), t3x32(:,:,2848))
  n2(2004) = 32
  call heltable([2,16,32], n3(:,6304), t3x32(:,:,2849))
  n2(2005) = 32
  call heltable([2,16,32], n3(:,6305), t3x32(:,:,2850))
  n2(2006) = 32
  call heltable([2,16,32], n3(:,6306), t3x32(:,:,2851))
  n2(2007) = 32
  call heltable([2,16,32], n3(:,6307), t3x32(:,:,2852))
  n2(2008) = 32
  call heltable([2,16,32], n3(:,6308), t3x32(:,:,2853))
  n2(2009) = 32
  call heltable([2,16,32], n3(:,6309), t3x32(:,:,2854))
  n2(2010) = 32
  call heltable([16,2,32], n3(:,6310), t3x32(:,:,2855))
  n2(2011) = 32
  call heltable([16,2,32], n3(:,6311), t3x32(:,:,2856))
  n2(2012) = 32
  call heltable([16,2,32], n3(:,6312), t3x32(:,:,2857))
  n2(2013) = 32
  call heltable([16,2,32], n3(:,6313), t3x32(:,:,2858))
  n2(2014) = 32
  call heltable([16,2,32], n3(:,6314), t3x32(:,:,2859))
  n2(2015) = 32
  call heltable([16,2,32], n3(:,6315), t3x32(:,:,2860))
  n2(2016) = 32
  call heltable([16,2,32], n3(:,6316), t3x32(:,:,2861))
  n2(2017) = 32
  call heltable([16,2,32], n3(:,6317), t3x32(:,:,2862))
  n2(2018) = 32
  call heltable([2,16,32], n3(:,6318), t3x32(:,:,2863))
  n2(2019) = 32
  call heltable([2,16,32], n3(:,6319), t3x32(:,:,2864))
  n2(2020) = 32
  call heltable([2,16,32], n3(:,6320), t3x32(:,:,2865))
  n2(2021) = 32
  call heltable([2,16,32], n3(:,6321), t3x32(:,:,2866))
  n2(2022) = 32
  call heltable([2,16,32], n3(:,6322), t3x32(:,:,2867))
  n2(2023) = 32
  call heltable([2,16,32], n3(:,6323), t3x32(:,:,2868))
  n2(2024) = 32
  call heltable([2,16,32], n3(:,6324), t3x32(:,:,2869))
  n2(2025) = 32
  call heltable([2,16,32], n3(:,6325), t3x32(:,:,2870))
  n2(2026) = 32
  call heltable([16,2,32], n3(:,6326), t3x32(:,:,2871))
  n2(2027) = 32
  call heltable([16,2,32], n3(:,6327), t3x32(:,:,2872))
  n2(2028) = 32
  call heltable([16,2,32], n3(:,6328), t3x32(:,:,2873))
  n2(2029) = 32
  call heltable([16,2,32], n3(:,6329), t3x32(:,:,2874))
  n2(2030) = 32
  call heltable([16,2,32], n3(:,6330), t3x32(:,:,2875))
  n2(2031) = 32
  call heltable([16,2,32], n3(:,6331), t3x32(:,:,2876))
  n2(2032) = 32
  call heltable([16,2,32], n3(:,6332), t3x32(:,:,2877))
  n2(2033) = 32
  call heltable([16,2,32], n3(:,6333), t3x32(:,:,2878))
  n2(2034) = 32
  call heltable([16,2,32], n3(:,6334), t3x32(:,:,2879))
  call heltable([16,2,32], n3(:,6335), t3x32(:,:,2880))
  call heltable([16,2,32], n3(:,6336), t3x32(:,:,2881))
  call heltable([16,2,32], n3(:,6337), t3x32(:,:,2882))
  call heltable([16,2,32], n3(:,6338), t3x32(:,:,2883))
  call heltable([16,2,32], n3(:,6339), t3x32(:,:,2884))
  call heltable([16,2,32], n3(:,6340), t3x32(:,:,2885))
  call heltable([16,2,32], n3(:,6341), t3x32(:,:,2886))
  call heltable([2,16,32], n3(:,6342), t3x32(:,:,2887))
  call heltable([2,16,32], n3(:,6343), t3x32(:,:,2888))
  call heltable([2,16,32], n3(:,6344), t3x32(:,:,2889))
  call heltable([2,16,32], n3(:,6345), t3x32(:,:,2890))
  call heltable([2,16,32], n3(:,6346), t3x32(:,:,2891))
  call heltable([2,16,32], n3(:,6347), t3x32(:,:,2892))
  call heltable([2,16,32], n3(:,6348), t3x32(:,:,2893))
  call heltable([2,16,32], n3(:,6349), t3x32(:,:,2894))
  call heltable([16,2,32], n3(:,6350), t3x32(:,:,2895))
  n2(2035) = 32
  call heltable([16,2,32], n3(:,6351), t3x32(:,:,2896))
  n2(2036) = 32
  call heltable([16,2,32], n3(:,6352), t3x32(:,:,2897))
  n2(2037) = 32
  call heltable([16,2,32], n3(:,6353), t3x32(:,:,2898))
  n2(2038) = 32
  call heltable([2,16,32], n3(:,6354), t3x32(:,:,2899))
  n2(2039) = 32
  call heltable([2,16,32], n3(:,6355), t3x32(:,:,2900))
  n2(2040) = 32
  call heltable([2,16,32], n3(:,6356), t3x32(:,:,2901))
  n2(2041) = 32
  call heltable([2,16,32], n3(:,6357), t3x32(:,:,2902))
  n2(2042) = 32
  call heltable([16,2,32], n3(:,6358), t3x32(:,:,2903))
  n2(2043) = 32
  call heltable([16,2,32], n3(:,6359), t3x32(:,:,2904))
  n2(2044) = 32
  call heltable([16,2,32], n3(:,6360), t3x32(:,:,2905))
  n2(2045) = 32
  call heltable([16,2,32], n3(:,6361), t3x32(:,:,2906))
  n2(2046) = 32
  call heltable([2,16,32], n3(:,6362), t3x32(:,:,2907))
  n2(2047) = 32
  call heltable([2,16,32], n3(:,6363), t3x32(:,:,2908))
  n2(2048) = 32
  call heltable([2,16,32], n3(:,6364), t3x32(:,:,2909))
  n2(2049) = 32
  call heltable([2,16,32], n3(:,6365), t3x32(:,:,2910))
  n2(2050) = 32
  call heltable([2,16,32], n3(:,6366), t3x32(:,:,2911))
  call heltable([2,16,32], n3(:,6367), t3x32(:,:,2912))
  call heltable([2,16,32], n3(:,6368), t3x32(:,:,2913))
  call heltable([2,16,32], n3(:,6369), t3x32(:,:,2914))
  call heltable([16,2,32], n3(:,6370), t3x32(:,:,2915))
  call heltable([16,2,32], n3(:,6371), t3x32(:,:,2916))
  call heltable([16,2,32], n3(:,6372), t3x32(:,:,2917))
  call heltable([16,2,32], n3(:,6373), t3x32(:,:,2918))
  call heltable([2,16,32], n3(:,6374), t3x32(:,:,2919))
  call heltable([2,16,32], n3(:,6375), t3x32(:,:,2920))
  call heltable([2,16,32], n3(:,6376), t3x32(:,:,2921))
  call heltable([2,16,32], n3(:,6377), t3x32(:,:,2922))
  call heltable([16,2,32], n3(:,6378), t3x32(:,:,2923))
  call heltable([16,2,32], n3(:,6379), t3x32(:,:,2924))
  call heltable([16,2,32], n3(:,6380), t3x32(:,:,2925))
  call heltable([16,2,32], n3(:,6381), t3x32(:,:,2926))
  call heltable([16,2,32], n3(:,6382), t3x32(:,:,2927))
  n2(2051) = 32
  call heltable([16,2,32], n3(:,6383), t3x32(:,:,2928))
  n2(2052) = 32
  call heltable([16,2,32], n3(:,6384), t3x32(:,:,2929))
  n2(2053) = 32
  call heltable([16,2,32], n3(:,6385), t3x32(:,:,2930))
  n2(2054) = 32
  call heltable([2,16,32], n3(:,6386), t3x32(:,:,2931))
  n2(2055) = 32
  call heltable([2,16,32], n3(:,6387), t3x32(:,:,2932))
  n2(2056) = 32
  call heltable([2,16,32], n3(:,6388), t3x32(:,:,2933))
  n2(2057) = 32
  call heltable([2,16,32], n3(:,6389), t3x32(:,:,2934))
  n2(2058) = 32
  call heltable([16,2,32], n3(:,6390), t3x32(:,:,2935))
  n2(2059) = 32
  call heltable([16,2,32], n3(:,6391), t3x32(:,:,2936))
  n2(2060) = 32
  call heltable([16,2,32], n3(:,6392), t3x32(:,:,2937))
  n2(2061) = 32
  call heltable([16,2,32], n3(:,6393), t3x32(:,:,2938))
  n2(2062) = 32
  call heltable([2,16,32], n3(:,6394), t3x32(:,:,2939))
  n2(2063) = 32
  call heltable([2,16,32], n3(:,6395), t3x32(:,:,2940))
  n2(2064) = 32
  call heltable([2,16,32], n3(:,6396), t3x32(:,:,2941))
  n2(2065) = 32
  call heltable([2,16,32], n3(:,6397), t3x32(:,:,2942))
  n2(2066) = 32
  call heltable([16,2,32], n3(:,6398), t3x32(:,:,2943))
  call heltable([16,2,32], n3(:,6399), t3x32(:,:,2944))
  call heltable([16,2,32], n3(:,6400), t3x32(:,:,2945))
  call heltable([16,2,32], n3(:,6401), t3x32(:,:,2946))
  call heltable([2,16,32], n3(:,6402), t3x32(:,:,2947))
  call heltable([2,16,32], n3(:,6403), t3x32(:,:,2948))
  call heltable([2,16,32], n3(:,6404), t3x32(:,:,2949))
  call heltable([2,16,32], n3(:,6405), t3x32(:,:,2950))
  call heltable([16,2,32], n3(:,6406), t3x32(:,:,2951))
  call heltable([16,2,32], n3(:,6407), t3x32(:,:,2952))
  call heltable([16,2,32], n3(:,6408), t3x32(:,:,2953))
  call heltable([16,2,32], n3(:,6409), t3x32(:,:,2954))
  call heltable([2,16,32], n3(:,6410), t3x32(:,:,2955))
  call heltable([2,16,32], n3(:,6411), t3x32(:,:,2956))
  call heltable([2,16,32], n3(:,6412), t3x32(:,:,2957))
  call heltable([2,16,32], n3(:,6413), t3x32(:,:,2958))
  call heltable([4,8,32], n3(:,6414), t3x32(:,:,2959))
  call heltable([4,8,32], n3(:,6415), t3x32(:,:,2960))
  call heltable([4,8,32], n3(:,6416), t3x32(:,:,2961))
  call heltable([4,8,32], n3(:,6417), t3x32(:,:,2962))
  call heltable([4,8,32], n3(:,6418), t3x32(:,:,2963))
  call heltable([8,4,32], n3(:,6419), t3x32(:,:,2964))
  call heltable([8,4,32], n3(:,6420), t3x32(:,:,2965))
  call heltable([4,8,32], n3(:,6421), t3x32(:,:,2966))
  call heltable([8,4,32], n3(:,6422), t3x32(:,:,2967))
  call heltable([4,8,32], n3(:,6423), t3x32(:,:,2968))
  call heltable([8,4,32], n3(:,6424), t3x32(:,:,2969))
  call heltable([4,8,32], n3(:,6425), t3x32(:,:,2970))
  call heltable([4,8,32], n3(:,6426), t3x32(:,:,2971))
  call heltable([4,8,32], n3(:,6427), t3x32(:,:,2972))
  call heltable([4,8,32], n3(:,6428), t3x32(:,:,2973))
  call heltable([4,8,32], n3(:,6429), t3x32(:,:,2974))
  call heltable([4,8,32], n3(:,6430), t3x32(:,:,2975))
  call heltable([4,8,32], n3(:,6431), t3x32(:,:,2976))
  call heltable([8,4,32], n3(:,6432), t3x32(:,:,2977))
  call heltable([8,4,32], n3(:,6433), t3x32(:,:,2978))
  call heltable([4,8,32], n3(:,6434), t3x32(:,:,2979))
  call heltable([8,4,32], n3(:,6435), t3x32(:,:,2980))
  call heltable([4,8,32], n3(:,6436), t3x32(:,:,2981))
  call heltable([8,4,32], n3(:,6437), t3x32(:,:,2982))
  call heltable([4,8,32], n3(:,6438), t3x32(:,:,2983))
  call heltable([4,8,32], n3(:,6439), t3x32(:,:,2984))
  call heltable([8,4,32], n3(:,6440), t3x32(:,:,2985))
  call heltable([8,4,32], n3(:,6441), t3x32(:,:,2986))
  call heltable([8,4,32], n3(:,6442), t3x32(:,:,2987))
  call heltable([8,4,32], n3(:,6443), t3x32(:,:,2988))
  call heltable([4,8,32], n3(:,6444), t3x32(:,:,2989))
  call heltable([4,8,32], n3(:,6445), t3x32(:,:,2990))
  call heltable([4,8,32], n3(:,6446), t3x32(:,:,2991))
  call heltable([4,8,32], n3(:,6447), t3x32(:,:,2992))
  call heltable([8,4,32], n3(:,6448), t3x32(:,:,2993))
  call heltable([8,4,32], n3(:,6449), t3x32(:,:,2994))
  call heltable([8,4,32], n3(:,6450), t3x32(:,:,2995))
  call heltable([8,4,32], n3(:,6451), t3x32(:,:,2996))
  call heltable([4,8,32], n3(:,6452), t3x32(:,:,2997))
  call heltable([4,8,32], n3(:,6453), t3x32(:,:,2998))
  call heltable([4,8,32], n3(:,6454), t3x32(:,:,2999))
  call heltable([4,8,32], n3(:,6455), t3x32(:,:,3000))
  call heltable([2,16,32], n3(:,6456), t3x32(:,:,3001))
  call heltable([2,16,32], n3(:,6457), t3x32(:,:,3002))
  call heltable([2,16,32], n3(:,6458), t3x32(:,:,3003))
  call heltable([2,16,32], n3(:,6459), t3x32(:,:,3004))
  call heltable([2,16,32], n3(:,6460), t3x32(:,:,3005))
  call heltable([2,16,32], n3(:,6461), t3x32(:,:,3006))
  call heltable([2,16,32], n3(:,6462), t3x32(:,:,3007))
  call heltable([2,16,32], n3(:,6463), t3x32(:,:,3008))
  call heltable([16,2,32], n3(:,6464), t3x32(:,:,3009))
  call heltable([16,2,32], n3(:,6465), t3x32(:,:,3010))
  call heltable([16,2,32], n3(:,6466), t3x32(:,:,3011))
  call heltable([16,2,32], n3(:,6467), t3x32(:,:,3012))
  call heltable([16,2,32], n3(:,6468), t3x32(:,:,3013))
  call heltable([16,2,32], n3(:,6469), t3x32(:,:,3014))
  call heltable([16,2,32], n3(:,6470), t3x32(:,:,3015))
  call heltable([16,2,32], n3(:,6471), t3x32(:,:,3016))
  call heltable([8,4,32], n3(:,6472), t3x32(:,:,3017))
  call heltable([8,4,32], n3(:,6473), t3x32(:,:,3018))
  call heltable([8,4,32], n3(:,6474), t3x32(:,:,3019))
  call heltable([8,4,32], n3(:,6475), t3x32(:,:,3020))
  call heltable([4,8,32], n3(:,6476), t3x32(:,:,3021))
  call heltable([4,8,32], n3(:,6477), t3x32(:,:,3022))
  call heltable([4,8,32], n3(:,6478), t3x32(:,:,3023))
  call heltable([4,8,32], n3(:,6479), t3x32(:,:,3024))
  call heltable([8,4,32], n3(:,6480), t3x32(:,:,3025))
  call heltable([8,4,32], n3(:,6481), t3x32(:,:,3026))
  call heltable([8,4,32], n3(:,6482), t3x32(:,:,3027))
  call heltable([8,4,32], n3(:,6483), t3x32(:,:,3028))
  call heltable([4,8,32], n3(:,6484), t3x32(:,:,3029))
  call heltable([4,8,32], n3(:,6485), t3x32(:,:,3030))
  call heltable([4,8,32], n3(:,6486), t3x32(:,:,3031))
  call heltable([4,8,32], n3(:,6487), t3x32(:,:,3032))
  call heltable([2,16,32], n3(:,6488), t3x32(:,:,3033))
  call heltable([2,16,32], n3(:,6489), t3x32(:,:,3034))
  call heltable([2,16,32], n3(:,6490), t3x32(:,:,3035))
  call heltable([2,16,32], n3(:,6491), t3x32(:,:,3036))
  call heltable([2,16,32], n3(:,6492), t3x32(:,:,3037))
  call heltable([2,16,32], n3(:,6493), t3x32(:,:,3038))
  call heltable([2,16,32], n3(:,6494), t3x32(:,:,3039))
  call heltable([2,16,32], n3(:,6495), t3x32(:,:,3040))
  call heltable([16,2,32], n3(:,6496), t3x32(:,:,3041))
  call heltable([16,2,32], n3(:,6497), t3x32(:,:,3042))
  call heltable([16,2,32], n3(:,6498), t3x32(:,:,3043))
  call heltable([16,2,32], n3(:,6499), t3x32(:,:,3044))
  call heltable([16,2,32], n3(:,6500), t3x32(:,:,3045))
  call heltable([16,2,32], n3(:,6501), t3x32(:,:,3046))
  call heltable([16,2,32], n3(:,6502), t3x32(:,:,3047))
  call heltable([16,2,32], n3(:,6503), t3x32(:,:,3048))
  call heltable([4,8,32], n3(:,6504), t3x32(:,:,3049))
  call heltable([4,8,32], n3(:,6505), t3x32(:,:,3050))
  call heltable([4,8,32], n3(:,6506), t3x32(:,:,3051))
  call heltable([4,8,32], n3(:,6507), t3x32(:,:,3052))
  call heltable([4,8,32], n3(:,6508), t3x32(:,:,3053))
  call heltable([8,4,32], n3(:,6509), t3x32(:,:,3054))
  call heltable([8,4,32], n3(:,6510), t3x32(:,:,3055))
  call heltable([4,8,32], n3(:,6511), t3x32(:,:,3056))
  call heltable([8,4,32], n3(:,6512), t3x32(:,:,3057))
  call heltable([4,8,32], n3(:,6513), t3x32(:,:,3058))
  call heltable([8,4,32], n3(:,6514), t3x32(:,:,3059))
  call heltable([4,8,32], n3(:,6515), t3x32(:,:,3060))
  call heltable([4,8,32], n3(:,6516), t3x32(:,:,3061))
  call heltable([4,8,32], n3(:,6517), t3x32(:,:,3062))
  call heltable([4,8,32], n3(:,6518), t3x32(:,:,3063))
  call heltable([4,8,32], n3(:,6519), t3x32(:,:,3064))
  call heltable([4,8,32], n3(:,6520), t3x32(:,:,3065))
  call heltable([4,8,32], n3(:,6521), t3x32(:,:,3066))
  call heltable([8,4,32], n3(:,6522), t3x32(:,:,3067))
  call heltable([8,4,32], n3(:,6523), t3x32(:,:,3068))
  call heltable([4,8,32], n3(:,6524), t3x32(:,:,3069))
  call heltable([8,4,32], n3(:,6525), t3x32(:,:,3070))
  call heltable([4,8,32], n3(:,6526), t3x32(:,:,3071))
  call heltable([8,4,32], n3(:,6527), t3x32(:,:,3072))
  call heltable([4,8,32], n3(:,6528), t3x32(:,:,3073))
  call heltable([4,8,32], n3(:,6529), t3x32(:,:,3074))
  call heltable([8,4,32], n3(:,6530), t3x32(:,:,3075))
  call heltable([8,4,32], n3(:,6531), t3x32(:,:,3076))
  call heltable([8,4,32], n3(:,6532), t3x32(:,:,3077))
  call heltable([8,4,32], n3(:,6533), t3x32(:,:,3078))
  call heltable([4,8,32], n3(:,6534), t3x32(:,:,3079))
  call heltable([4,8,32], n3(:,6535), t3x32(:,:,3080))
  call heltable([4,8,32], n3(:,6536), t3x32(:,:,3081))
  call heltable([4,8,32], n3(:,6537), t3x32(:,:,3082))
  call heltable([8,4,32], n3(:,6538), t3x32(:,:,3083))
  call heltable([8,4,32], n3(:,6539), t3x32(:,:,3084))
  call heltable([8,4,32], n3(:,6540), t3x32(:,:,3085))
  call heltable([8,4,32], n3(:,6541), t3x32(:,:,3086))
  call heltable([4,8,32], n3(:,6542), t3x32(:,:,3087))
  call heltable([4,8,32], n3(:,6543), t3x32(:,:,3088))
  call heltable([4,8,32], n3(:,6544), t3x32(:,:,3089))
  call heltable([4,8,32], n3(:,6545), t3x32(:,:,3090))
  call heltable([2,16,32], n3(:,6546), t3x32(:,:,3091))
  call heltable([2,16,32], n3(:,6547), t3x32(:,:,3092))
  call heltable([2,16,32], n3(:,6548), t3x32(:,:,3093))
  call heltable([2,16,32], n3(:,6549), t3x32(:,:,3094))
  call heltable([2,16,32], n3(:,6550), t3x32(:,:,3095))
  call heltable([2,16,32], n3(:,6551), t3x32(:,:,3096))
  call heltable([2,16,32], n3(:,6552), t3x32(:,:,3097))
  call heltable([2,16,32], n3(:,6553), t3x32(:,:,3098))
  call heltable([16,2,32], n3(:,6554), t3x32(:,:,3099))
  call heltable([16,2,32], n3(:,6555), t3x32(:,:,3100))
  call heltable([16,2,32], n3(:,6556), t3x32(:,:,3101))
  call heltable([16,2,32], n3(:,6557), t3x32(:,:,3102))
  call heltable([16,2,32], n3(:,6558), t3x32(:,:,3103))
  call heltable([16,2,32], n3(:,6559), t3x32(:,:,3104))
  call heltable([16,2,32], n3(:,6560), t3x32(:,:,3105))
  call heltable([16,2,32], n3(:,6561), t3x32(:,:,3106))
  call heltable([8,4,32], n3(:,6562), t3x32(:,:,3107))
  call heltable([8,4,32], n3(:,6563), t3x32(:,:,3108))
  call heltable([8,4,32], n3(:,6564), t3x32(:,:,3109))
  call heltable([8,4,32], n3(:,6565), t3x32(:,:,3110))
  call heltable([4,8,32], n3(:,6566), t3x32(:,:,3111))
  call heltable([4,8,32], n3(:,6567), t3x32(:,:,3112))
  call heltable([4,8,32], n3(:,6568), t3x32(:,:,3113))
  call heltable([4,8,32], n3(:,6569), t3x32(:,:,3114))
  call heltable([8,4,32], n3(:,6570), t3x32(:,:,3115))
  call heltable([8,4,32], n3(:,6571), t3x32(:,:,3116))
  call heltable([8,4,32], n3(:,6572), t3x32(:,:,3117))
  call heltable([8,4,32], n3(:,6573), t3x32(:,:,3118))
  call heltable([4,8,32], n3(:,6574), t3x32(:,:,3119))
  call heltable([4,8,32], n3(:,6575), t3x32(:,:,3120))
  call heltable([4,8,32], n3(:,6576), t3x32(:,:,3121))
  call heltable([4,8,32], n3(:,6577), t3x32(:,:,3122))
  call heltable([2,16,32], n3(:,6578), t3x32(:,:,3123))
  call heltable([2,16,32], n3(:,6579), t3x32(:,:,3124))
  call heltable([2,16,32], n3(:,6580), t3x32(:,:,3125))
  call heltable([2,16,32], n3(:,6581), t3x32(:,:,3126))
  call heltable([2,16,32], n3(:,6582), t3x32(:,:,3127))
  call heltable([2,16,32], n3(:,6583), t3x32(:,:,3128))
  call heltable([2,16,32], n3(:,6584), t3x32(:,:,3129))
  call heltable([2,16,32], n3(:,6585), t3x32(:,:,3130))
  call heltable([16,2,32], n3(:,6586), t3x32(:,:,3131))
  call heltable([16,2,32], n3(:,6587), t3x32(:,:,3132))
  call heltable([16,2,32], n3(:,6588), t3x32(:,:,3133))
  call heltable([16,2,32], n3(:,6589), t3x32(:,:,3134))
  call heltable([16,2,32], n3(:,6590), t3x32(:,:,3135))
  call heltable([16,2,32], n3(:,6591), t3x32(:,:,3136))
  call heltable([16,2,32], n3(:,6592), t3x32(:,:,3137))
  call heltable([16,2,32], n3(:,6593), t3x32(:,:,3138))
  call heltable([4,8,32], n3(:,6594), t3x32(:,:,3139))
  call heltable([4,8,32], n3(:,6595), t3x32(:,:,3140))
  call heltable([4,8,32], n3(:,6596), t3x32(:,:,3141))
  call heltable([4,8,32], n3(:,6597), t3x32(:,:,3142))
  call heltable([4,8,32], n3(:,6598), t3x32(:,:,3143))
  call heltable([8,4,32], n3(:,6599), t3x32(:,:,3144))
  call heltable([8,4,32], n3(:,6600), t3x32(:,:,3145))
  call heltable([4,8,32], n3(:,6601), t3x32(:,:,3146))
  call heltable([8,4,32], n3(:,6602), t3x32(:,:,3147))
  call heltable([4,8,32], n3(:,6603), t3x32(:,:,3148))
  call heltable([8,4,32], n3(:,6604), t3x32(:,:,3149))
  call heltable([4,8,32], n3(:,6605), t3x32(:,:,3150))
  call heltable([4,8,32], n3(:,6606), t3x32(:,:,3151))
  call heltable([4,8,32], n3(:,6607), t3x32(:,:,3152))
  call heltable([4,8,32], n3(:,6608), t3x32(:,:,3153))
  call heltable([4,8,32], n3(:,6609), t3x32(:,:,3154))
  call heltable([4,8,32], n3(:,6610), t3x32(:,:,3155))
  call heltable([8,4,32], n3(:,6611), t3x32(:,:,3156))
  call heltable([8,4,32], n3(:,6612), t3x32(:,:,3157))
  call heltable([8,4,32], n3(:,6613), t3x32(:,:,3158))
  call heltable([8,4,32], n3(:,6614), t3x32(:,:,3159))
  call heltable([4,8,32], n3(:,6615), t3x32(:,:,3160))
  call heltable([4,8,32], n3(:,6616), t3x32(:,:,3161))
  call heltable([4,8,32], n3(:,6617), t3x32(:,:,3162))
  call heltable([4,8,32], n3(:,6618), t3x32(:,:,3163))
  call heltable([8,4,32], n3(:,6619), t3x32(:,:,3164))
  call heltable([8,4,32], n3(:,6620), t3x32(:,:,3165))
  call heltable([8,4,32], n3(:,6621), t3x32(:,:,3166))
  call heltable([8,4,32], n3(:,6622), t3x32(:,:,3167))
  call heltable([16,2,32], n3(:,6623), t3x32(:,:,3168))
  call heltable([16,2,32], n3(:,6624), t3x32(:,:,3169))
  call heltable([16,2,32], n3(:,6625), t3x32(:,:,3170))
  call heltable([16,2,32], n3(:,6626), t3x32(:,:,3171))
  call heltable([16,2,32], n3(:,6627), t3x32(:,:,3172))
  call heltable([16,2,32], n3(:,6628), t3x32(:,:,3173))
  call heltable([16,2,32], n3(:,6629), t3x32(:,:,3174))
  call heltable([16,2,32], n3(:,6630), t3x32(:,:,3175))
  call heltable([2,16,32], n3(:,6631), t3x32(:,:,3176))
  call heltable([2,16,32], n3(:,6632), t3x32(:,:,3177))
  call heltable([2,16,32], n3(:,6633), t3x32(:,:,3178))
  call heltable([2,16,32], n3(:,6634), t3x32(:,:,3179))
  call heltable([2,16,32], n3(:,6635), t3x32(:,:,3180))
  call heltable([2,16,32], n3(:,6636), t3x32(:,:,3181))
  call heltable([2,16,32], n3(:,6637), t3x32(:,:,3182))
  call heltable([2,16,32], n3(:,6638), t3x32(:,:,3183))
  call heltable([4,8,32], n3(:,6639), t3x32(:,:,3184))
  call heltable([4,8,32], n3(:,6640), t3x32(:,:,3185))
  call heltable([4,8,32], n3(:,6641), t3x32(:,:,3186))
  call heltable([4,8,32], n3(:,6642), t3x32(:,:,3187))
  call heltable([4,8,32], n3(:,6643), t3x32(:,:,3188))
  call heltable([8,4,32], n3(:,6644), t3x32(:,:,3189))
  call heltable([8,4,32], n3(:,6645), t3x32(:,:,3190))
  call heltable([4,8,32], n3(:,6646), t3x32(:,:,3191))
  call heltable([8,4,32], n3(:,6647), t3x32(:,:,3192))
  call heltable([4,8,32], n3(:,6648), t3x32(:,:,3193))
  call heltable([8,4,32], n3(:,6649), t3x32(:,:,3194))
  call heltable([4,8,32], n3(:,6650), t3x32(:,:,3195))
  call heltable([4,8,32], n3(:,6651), t3x32(:,:,3196))
  call heltable([4,8,32], n3(:,6652), t3x32(:,:,3197))
  call heltable([4,8,32], n3(:,6653), t3x32(:,:,3198))
  call heltable([4,8,32], n3(:,6654), t3x32(:,:,3199))
  call heltable([4,8,32], n3(:,6655), t3x32(:,:,3200))
  call heltable([8,4,32], n3(:,6656), t3x32(:,:,3201))
  call heltable([8,4,32], n3(:,6657), t3x32(:,:,3202))
  call heltable([8,4,32], n3(:,6658), t3x32(:,:,3203))
  call heltable([8,4,32], n3(:,6659), t3x32(:,:,3204))
  call heltable([4,8,32], n3(:,6660), t3x32(:,:,3205))
  call heltable([4,8,32], n3(:,6661), t3x32(:,:,3206))
  call heltable([4,8,32], n3(:,6662), t3x32(:,:,3207))
  call heltable([4,8,32], n3(:,6663), t3x32(:,:,3208))
  call heltable([8,4,32], n3(:,6664), t3x32(:,:,3209))
  call heltable([8,4,32], n3(:,6665), t3x32(:,:,3210))
  call heltable([8,4,32], n3(:,6666), t3x32(:,:,3211))
  call heltable([8,4,32], n3(:,6667), t3x32(:,:,3212))
  call heltable([16,2,32], n3(:,6668), t3x32(:,:,3213))
  call heltable([16,2,32], n3(:,6669), t3x32(:,:,3214))
  call heltable([16,2,32], n3(:,6670), t3x32(:,:,3215))
  call heltable([16,2,32], n3(:,6671), t3x32(:,:,3216))
  call heltable([16,2,32], n3(:,6672), t3x32(:,:,3217))
  call heltable([16,2,32], n3(:,6673), t3x32(:,:,3218))
  call heltable([16,2,32], n3(:,6674), t3x32(:,:,3219))
  call heltable([16,2,32], n3(:,6675), t3x32(:,:,3220))
  call heltable([2,16,32], n3(:,6676), t3x32(:,:,3221))
  call heltable([2,16,32], n3(:,6677), t3x32(:,:,3222))
  call heltable([2,16,32], n3(:,6678), t3x32(:,:,3223))
  call heltable([2,16,32], n3(:,6679), t3x32(:,:,3224))
  call heltable([2,16,32], n3(:,6680), t3x32(:,:,3225))
  call heltable([2,16,32], n3(:,6681), t3x32(:,:,3226))
  call heltable([2,16,32], n3(:,6682), t3x32(:,:,3227))
  call heltable([2,16,32], n3(:,6683), t3x32(:,:,3228))
  call heltable([4,8,32], n3(:,6684), t3x32(:,:,3229))
  call heltable([4,8,32], n3(:,6685), t3x32(:,:,3230))
  call heltable([4,8,32], n3(:,6686), t3x32(:,:,3231))
  call heltable([4,8,32], n3(:,6687), t3x32(:,:,3232))
  call heltable([4,8,32], n3(:,6688), t3x32(:,:,3233))
  call heltable([8,4,32], n3(:,6689), t3x32(:,:,3234))
  call heltable([8,4,32], n3(:,6690), t3x32(:,:,3235))
  call heltable([4,8,32], n3(:,6691), t3x32(:,:,3236))
  call heltable([8,4,32], n3(:,6692), t3x32(:,:,3237))
  call heltable([4,8,32], n3(:,6693), t3x32(:,:,3238))
  call heltable([8,4,32], n3(:,6694), t3x32(:,:,3239))
  call heltable([4,8,32], n3(:,6695), t3x32(:,:,3240))
  call heltable([4,8,32], n3(:,6696), t3x32(:,:,3241))
  call heltable([4,8,32], n3(:,6697), t3x32(:,:,3242))
  call heltable([4,8,32], n3(:,6698), t3x32(:,:,3243))
  call heltable([4,8,32], n3(:,6699), t3x32(:,:,3244))
  call heltable([4,8,32], n3(:,6700), t3x32(:,:,3245))
  call heltable([8,4,32], n3(:,6701), t3x32(:,:,3246))
  call heltable([8,4,32], n3(:,6702), t3x32(:,:,3247))
  call heltable([8,4,32], n3(:,6703), t3x32(:,:,3248))
  call heltable([8,4,32], n3(:,6704), t3x32(:,:,3249))
  call heltable([4,8,32], n3(:,6705), t3x32(:,:,3250))
  call heltable([4,8,32], n3(:,6706), t3x32(:,:,3251))
  call heltable([4,8,32], n3(:,6707), t3x32(:,:,3252))
  call heltable([4,8,32], n3(:,6708), t3x32(:,:,3253))
  call heltable([8,4,32], n3(:,6709), t3x32(:,:,3254))
  call heltable([8,4,32], n3(:,6710), t3x32(:,:,3255))
  call heltable([8,4,32], n3(:,6711), t3x32(:,:,3256))
  call heltable([8,4,32], n3(:,6712), t3x32(:,:,3257))
  call heltable([16,2,32], n3(:,6713), t3x32(:,:,3258))
  call heltable([16,2,32], n3(:,6714), t3x32(:,:,3259))
  call heltable([16,2,32], n3(:,6715), t3x32(:,:,3260))
  call heltable([16,2,32], n3(:,6716), t3x32(:,:,3261))
  call heltable([16,2,32], n3(:,6717), t3x32(:,:,3262))
  call heltable([16,2,32], n3(:,6718), t3x32(:,:,3263))
  call heltable([16,2,32], n3(:,6719), t3x32(:,:,3264))
  call heltable([16,2,32], n3(:,6720), t3x32(:,:,3265))
  call heltable([2,16,32], n3(:,6721), t3x32(:,:,3266))
  call heltable([2,16,32], n3(:,6722), t3x32(:,:,3267))
  call heltable([2,16,32], n3(:,6723), t3x32(:,:,3268))
  call heltable([2,16,32], n3(:,6724), t3x32(:,:,3269))
  call heltable([2,16,32], n3(:,6725), t3x32(:,:,3270))
  call heltable([2,16,32], n3(:,6726), t3x32(:,:,3271))
  call heltable([2,16,32], n3(:,6727), t3x32(:,:,3272))
  call heltable([2,16,32], n3(:,6728), t3x32(:,:,3273))
  call heltable([4,8,32], n3(:,6729), t3x32(:,:,3274))
  call heltable([4,8,32], n3(:,6730), t3x32(:,:,3275))
  call heltable([4,8,32], n3(:,6731), t3x32(:,:,3276))
  call heltable([4,8,32], n3(:,6732), t3x32(:,:,3277))
  call heltable([4,8,32], n3(:,6733), t3x32(:,:,3278))
  call heltable([8,4,32], n3(:,6734), t3x32(:,:,3279))
  call heltable([8,4,32], n3(:,6735), t3x32(:,:,3280))
  call heltable([4,8,32], n3(:,6736), t3x32(:,:,3281))
  call heltable([8,4,32], n3(:,6737), t3x32(:,:,3282))
  call heltable([4,8,32], n3(:,6738), t3x32(:,:,3283))
  call heltable([8,4,32], n3(:,6739), t3x32(:,:,3284))
  call heltable([4,8,32], n3(:,6740), t3x32(:,:,3285))
  call heltable([4,8,32], n3(:,6741), t3x32(:,:,3286))
  call heltable([4,8,32], n3(:,6742), t3x32(:,:,3287))
  call heltable([4,8,32], n3(:,6743), t3x32(:,:,3288))
  call heltable([4,8,32], n3(:,6744), t3x32(:,:,3289))
  call heltable([4,8,32], n3(:,6745), t3x32(:,:,3290))
  call heltable([8,4,32], n3(:,6746), t3x32(:,:,3291))
  call heltable([8,4,32], n3(:,6747), t3x32(:,:,3292))
  call heltable([8,4,32], n3(:,6748), t3x32(:,:,3293))
  call heltable([8,4,32], n3(:,6749), t3x32(:,:,3294))
  call heltable([4,8,32], n3(:,6750), t3x32(:,:,3295))
  call heltable([4,8,32], n3(:,6751), t3x32(:,:,3296))
  call heltable([4,8,32], n3(:,6752), t3x32(:,:,3297))
  call heltable([4,8,32], n3(:,6753), t3x32(:,:,3298))
  call heltable([8,4,32], n3(:,6754), t3x32(:,:,3299))
  call heltable([8,4,32], n3(:,6755), t3x32(:,:,3300))
  call heltable([8,4,32], n3(:,6756), t3x32(:,:,3301))
  call heltable([8,4,32], n3(:,6757), t3x32(:,:,3302))
  call heltable([16,2,32], n3(:,6758), t3x32(:,:,3303))
  call heltable([16,2,32], n3(:,6759), t3x32(:,:,3304))
  call heltable([16,2,32], n3(:,6760), t3x32(:,:,3305))
  call heltable([16,2,32], n3(:,6761), t3x32(:,:,3306))
  call heltable([16,2,32], n3(:,6762), t3x32(:,:,3307))
  call heltable([16,2,32], n3(:,6763), t3x32(:,:,3308))
  call heltable([16,2,32], n3(:,6764), t3x32(:,:,3309))
  call heltable([16,2,32], n3(:,6765), t3x32(:,:,3310))
  call heltable([2,16,32], n3(:,6766), t3x32(:,:,3311))
  call heltable([2,16,32], n3(:,6767), t3x32(:,:,3312))
  call heltable([2,16,32], n3(:,6768), t3x32(:,:,3313))
  call heltable([2,16,32], n3(:,6769), t3x32(:,:,3314))
  call heltable([2,16,32], n3(:,6770), t3x32(:,:,3315))
  call heltable([2,16,32], n3(:,6771), t3x32(:,:,3316))
  call heltable([2,16,32], n3(:,6772), t3x32(:,:,3317))
  call heltable([2,16,32], n3(:,6773), t3x32(:,:,3318))
  call heltable([2,16,32], n3(:,6774), t3x32(:,:,3319))
  n2(2067) = 32
  call heltable([2,16,32], n3(:,6775), t3x32(:,:,3320))
  n2(2068) = 32
  call heltable([2,16,32], n3(:,6776), t3x32(:,:,3321))
  n2(2069) = 32
  call heltable([2,16,32], n3(:,6777), t3x32(:,:,3322))
  n2(2070) = 32
  call heltable([2,16,32], n3(:,6778), t3x32(:,:,3323))
  n2(2071) = 32
  call heltable([2,16,32], n3(:,6779), t3x32(:,:,3324))
  n2(2072) = 32
  call heltable([2,16,32], n3(:,6780), t3x32(:,:,3325))
  n2(2073) = 32
  call heltable([2,16,32], n3(:,6781), t3x32(:,:,3326))
  n2(2074) = 32
  call heltable([16,2,32], n3(:,6782), t3x32(:,:,3327))
  n2(2075) = 32
  call heltable([16,2,32], n3(:,6783), t3x32(:,:,3328))
  n2(2076) = 32
  call heltable([16,2,32], n3(:,6784), t3x32(:,:,3329))
  n2(2077) = 32
  call heltable([16,2,32], n3(:,6785), t3x32(:,:,3330))
  n2(2078) = 32
  call heltable([16,2,32], n3(:,6786), t3x32(:,:,3331))
  n2(2079) = 32
  call heltable([16,2,32], n3(:,6787), t3x32(:,:,3332))
  n2(2080) = 32
  call heltable([16,2,32], n3(:,6788), t3x32(:,:,3333))
  n2(2081) = 32
  call heltable([16,2,32], n3(:,6789), t3x32(:,:,3334))
  n2(2082) = 32
  call heltable([2,16,32], n3(:,6790), t3x32(:,:,3335))
  n2(2083) = 32
  call heltable([2,16,32], n3(:,6791), t3x32(:,:,3336))
  n2(2084) = 32
  call heltable([2,16,32], n3(:,6792), t3x32(:,:,3337))
  n2(2085) = 32
  call heltable([2,16,32], n3(:,6793), t3x32(:,:,3338))
  n2(2086) = 32
  call heltable([2,16,32], n3(:,6794), t3x32(:,:,3339))
  n2(2087) = 32
  call heltable([2,16,32], n3(:,6795), t3x32(:,:,3340))
  n2(2088) = 32
  call heltable([2,16,32], n3(:,6796), t3x32(:,:,3341))
  n2(2089) = 32
  call heltable([2,16,32], n3(:,6797), t3x32(:,:,3342))
  n2(2090) = 32
  call heltable([16,2,32], n3(:,6798), t3x32(:,:,3343))
  n2(2091) = 32
  call heltable([16,2,32], n3(:,6799), t3x32(:,:,3344))
  n2(2092) = 32
  call heltable([16,2,32], n3(:,6800), t3x32(:,:,3345))
  n2(2093) = 32
  call heltable([16,2,32], n3(:,6801), t3x32(:,:,3346))
  n2(2094) = 32
  call heltable([16,2,32], n3(:,6802), t3x32(:,:,3347))
  n2(2095) = 32
  call heltable([16,2,32], n3(:,6803), t3x32(:,:,3348))
  n2(2096) = 32
  call heltable([16,2,32], n3(:,6804), t3x32(:,:,3349))
  n2(2097) = 32
  call heltable([16,2,32], n3(:,6805), t3x32(:,:,3350))
  n2(2098) = 32
  call heltable([2,16,32], n3(:,6806), t3x32(:,:,3351))
  n2(2099) = 32
  call heltable([2,16,32], n3(:,6807), t3x32(:,:,3352))
  n2(2100) = 32
  call heltable([2,16,32], n3(:,6808), t3x32(:,:,3353))
  n2(2101) = 32
  call heltable([2,16,32], n3(:,6809), t3x32(:,:,3354))
  n2(2102) = 32
  call heltable([2,16,32], n3(:,6810), t3x32(:,:,3355))
  n2(2103) = 32
  call heltable([2,16,32], n3(:,6811), t3x32(:,:,3356))
  n2(2104) = 32
  call heltable([2,16,32], n3(:,6812), t3x32(:,:,3357))
  n2(2105) = 32
  call heltable([2,16,32], n3(:,6813), t3x32(:,:,3358))
  n2(2106) = 32
  call heltable([16,2,32], n3(:,6814), t3x32(:,:,3359))
  n2(2107) = 32
  call heltable([16,2,32], n3(:,6815), t3x32(:,:,3360))
  n2(2108) = 32
  call heltable([16,2,32], n3(:,6816), t3x32(:,:,3361))
  n2(2109) = 32
  call heltable([16,2,32], n3(:,6817), t3x32(:,:,3362))
  n2(2110) = 32
  call heltable([16,2,32], n3(:,6818), t3x32(:,:,3363))
  n2(2111) = 32
  call heltable([16,2,32], n3(:,6819), t3x32(:,:,3364))
  n2(2112) = 32
  call heltable([16,2,32], n3(:,6820), t3x32(:,:,3365))
  n2(2113) = 32
  call heltable([16,2,32], n3(:,6821), t3x32(:,:,3366))
  n2(2114) = 32
  call heltable([2,16,32], n3(:,6822), t3x32(:,:,3367))
  n2(2115) = 32
  call heltable([2,16,32], n3(:,6823), t3x32(:,:,3368))
  n2(2116) = 32
  call heltable([2,16,32], n3(:,6824), t3x32(:,:,3369))
  n2(2117) = 32
  call heltable([2,16,32], n3(:,6825), t3x32(:,:,3370))
  n2(2118) = 32
  call heltable([2,16,32], n3(:,6826), t3x32(:,:,3371))
  n2(2119) = 32
  call heltable([2,16,32], n3(:,6827), t3x32(:,:,3372))
  n2(2120) = 32
  call heltable([2,16,32], n3(:,6828), t3x32(:,:,3373))
  n2(2121) = 32
  call heltable([2,16,32], n3(:,6829), t3x32(:,:,3374))
  n2(2122) = 32
  call heltable([16,2,32], n3(:,6830), t3x32(:,:,3375))
  n2(2123) = 32
  call heltable([16,2,32], n3(:,6831), t3x32(:,:,3376))
  n2(2124) = 32
  call heltable([16,2,32], n3(:,6832), t3x32(:,:,3377))
  n2(2125) = 32
  call heltable([16,2,32], n3(:,6833), t3x32(:,:,3378))
  n2(2126) = 32
  call heltable([16,2,32], n3(:,6834), t3x32(:,:,3379))
  n2(2127) = 32
  call heltable([16,2,32], n3(:,6835), t3x32(:,:,3380))
  n2(2128) = 32
  call heltable([16,2,32], n3(:,6836), t3x32(:,:,3381))
  n2(2129) = 32
  call heltable([16,2,32], n3(:,6837), t3x32(:,:,3382))
  n2(2130) = 32
  call heltable([16,2,32], n3(:,6838), t3x32(:,:,3383))
  n2(2131) = 32
  call heltable([16,2,32], n3(:,6839), t3x32(:,:,3384))
  n2(2132) = 32
  call heltable([16,2,32], n3(:,6840), t3x32(:,:,3385))
  n2(2133) = 32
  call heltable([16,2,32], n3(:,6841), t3x32(:,:,3386))
  n2(2134) = 32
  call heltable([16,2,32], n3(:,6842), t3x32(:,:,3387))
  n2(2135) = 32
  call heltable([16,2,32], n3(:,6843), t3x32(:,:,3388))
  n2(2136) = 32
  call heltable([16,2,32], n3(:,6844), t3x32(:,:,3389))
  n2(2137) = 32
  call heltable([16,2,32], n3(:,6845), t3x32(:,:,3390))
  n2(2138) = 32
  call heltable([2,16,32], n3(:,6846), t3x32(:,:,3391))
  n2(2139) = 32
  call heltable([2,16,32], n3(:,6847), t3x32(:,:,3392))
  n2(2140) = 32
  call heltable([2,16,32], n3(:,6848), t3x32(:,:,3393))
  n2(2141) = 32
  call heltable([2,16,32], n3(:,6849), t3x32(:,:,3394))
  n2(2142) = 32
  call heltable([2,16,32], n3(:,6850), t3x32(:,:,3395))
  n2(2143) = 32
  call heltable([2,16,32], n3(:,6851), t3x32(:,:,3396))
  n2(2144) = 32
  call heltable([2,16,32], n3(:,6852), t3x32(:,:,3397))
  n2(2145) = 32
  call heltable([2,16,32], n3(:,6853), t3x32(:,:,3398))
  n2(2146) = 32
  call heltable([16,2,32], n3(:,6854), t3x32(:,:,3399))
  n2(2147) = 32
  call heltable([16,2,32], n3(:,6855), t3x32(:,:,3400))
  n2(2148) = 32
  call heltable([16,2,32], n3(:,6856), t3x32(:,:,3401))
  n2(2149) = 32
  call heltable([16,2,32], n3(:,6857), t3x32(:,:,3402))
  n2(2150) = 32
  call heltable([16,2,32], n3(:,6858), t3x32(:,:,3403))
  n2(2151) = 32
  call heltable([16,2,32], n3(:,6859), t3x32(:,:,3404))
  n2(2152) = 32
  call heltable([16,2,32], n3(:,6860), t3x32(:,:,3405))
  n2(2153) = 32
  call heltable([16,2,32], n3(:,6861), t3x32(:,:,3406))
  n2(2154) = 32
  call heltable([2,16,32], n3(:,6862), t3x32(:,:,3407))
  n2(2155) = 32
  call heltable([2,16,32], n3(:,6863), t3x32(:,:,3408))
  n2(2156) = 32
  call heltable([2,16,32], n3(:,6864), t3x32(:,:,3409))
  n2(2157) = 32
  call heltable([2,16,32], n3(:,6865), t3x32(:,:,3410))
  n2(2158) = 32
  call heltable([2,16,32], n3(:,6866), t3x32(:,:,3411))
  n2(2159) = 32
  call heltable([2,16,32], n3(:,6867), t3x32(:,:,3412))
  n2(2160) = 32
  call heltable([2,16,32], n3(:,6868), t3x32(:,:,3413))
  n2(2161) = 32
  call heltable([2,16,32], n3(:,6869), t3x32(:,:,3414))
  n2(2162) = 32
  call heltable([2,16,32], n3(:,6870), t3x32(:,:,3415))
  n2(2163) = 32
  call heltable([2,16,32], n3(:,6871), t3x32(:,:,3416))
  n2(2164) = 32
  call heltable([2,16,32], n3(:,6872), t3x32(:,:,3417))
  n2(2165) = 32
  call heltable([2,16,32], n3(:,6873), t3x32(:,:,3418))
  n2(2166) = 32
  call heltable([16,2,32], n3(:,6874), t3x32(:,:,3419))
  n2(2167) = 32
  call heltable([16,2,32], n3(:,6875), t3x32(:,:,3420))
  n2(2168) = 32
  call heltable([16,2,32], n3(:,6876), t3x32(:,:,3421))
  n2(2169) = 32
  call heltable([16,2,32], n3(:,6877), t3x32(:,:,3422))
  n2(2170) = 32
  call heltable([2,16,32], n3(:,6878), t3x32(:,:,3423))
  n2(2171) = 32
  call heltable([2,16,32], n3(:,6879), t3x32(:,:,3424))
  n2(2172) = 32
  call heltable([2,16,32], n3(:,6880), t3x32(:,:,3425))
  n2(2173) = 32
  call heltable([2,16,32], n3(:,6881), t3x32(:,:,3426))
  n2(2174) = 32
  call heltable([16,2,32], n3(:,6882), t3x32(:,:,3427))
  n2(2175) = 32
  call heltable([16,2,32], n3(:,6883), t3x32(:,:,3428))
  n2(2176) = 32
  call heltable([16,2,32], n3(:,6884), t3x32(:,:,3429))
  n2(2177) = 32
  call heltable([16,2,32], n3(:,6885), t3x32(:,:,3430))
  n2(2178) = 32
  call heltable([16,2,32], n3(:,6886), t3x32(:,:,3431))
  n2(2179) = 32
  call heltable([16,2,32], n3(:,6887), t3x32(:,:,3432))
  n2(2180) = 32
  call heltable([16,2,32], n3(:,6888), t3x32(:,:,3433))
  n2(2181) = 32
  call heltable([16,2,32], n3(:,6889), t3x32(:,:,3434))
  n2(2182) = 32
  call heltable([2,16,32], n3(:,6890), t3x32(:,:,3435))
  n2(2183) = 32
  call heltable([2,16,32], n3(:,6891), t3x32(:,:,3436))
  n2(2184) = 32
  call heltable([2,16,32], n3(:,6892), t3x32(:,:,3437))
  n2(2185) = 32
  call heltable([2,16,32], n3(:,6893), t3x32(:,:,3438))
  n2(2186) = 32
  call heltable([16,2,32], n3(:,6894), t3x32(:,:,3439))
  n2(2187) = 32
  call heltable([16,2,32], n3(:,6895), t3x32(:,:,3440))
  n2(2188) = 32
  call heltable([16,2,32], n3(:,6896), t3x32(:,:,3441))
  n2(2189) = 32
  call heltable([16,2,32], n3(:,6897), t3x32(:,:,3442))
  n2(2190) = 32
  call heltable([2,16,32], n3(:,6898), t3x32(:,:,3443))
  n2(2191) = 32
  call heltable([2,16,32], n3(:,6899), t3x32(:,:,3444))
  n2(2192) = 32
  call heltable([2,16,32], n3(:,6900), t3x32(:,:,3445))
  n2(2193) = 32
  call heltable([2,16,32], n3(:,6901), t3x32(:,:,3446))
  n2(2194) = 32
  call heltable([2,16,32], n3(:,6902), t3x32(:,:,3447))
  n2(2195) = 32
  call heltable([2,16,32], n3(:,6903), t3x32(:,:,3448))
  n2(2196) = 32
  call heltable([2,16,32], n3(:,6904), t3x32(:,:,3449))
  n2(2197) = 32
  call heltable([2,16,32], n3(:,6905), t3x32(:,:,3450))
  n2(2198) = 32
  call heltable([2,16,32], n3(:,6906), t3x32(:,:,3451))
  n2(2199) = 32
  call heltable([2,16,32], n3(:,6907), t3x32(:,:,3452))
  n2(2200) = 32
  call heltable([2,16,32], n3(:,6908), t3x32(:,:,3453))
  n2(2201) = 32
  call heltable([2,16,32], n3(:,6909), t3x32(:,:,3454))
  n2(2202) = 32
  call heltable([16,2,32], n3(:,6910), t3x32(:,:,3455))
  n2(2203) = 32
  call heltable([16,2,32], n3(:,6911), t3x32(:,:,3456))
  n2(2204) = 32
  call heltable([16,2,32], n3(:,6912), t3x32(:,:,3457))
  n2(2205) = 32
  call heltable([16,2,32], n3(:,6913), t3x32(:,:,3458))
  n2(2206) = 32
  call heltable([16,2,32], n3(:,6914), t3x32(:,:,3459))
  n2(2207) = 32
  call heltable([16,2,32], n3(:,6915), t3x32(:,:,3460))
  n2(2208) = 32
  call heltable([16,2,32], n3(:,6916), t3x32(:,:,3461))
  n2(2209) = 32
  call heltable([16,2,32], n3(:,6917), t3x32(:,:,3462))
  n2(2210) = 32
  call heltable([2,16,32], n3(:,6918), t3x32(:,:,3463))
  n2(2211) = 32
  call heltable([2,16,32], n3(:,6919), t3x32(:,:,3464))
  n2(2212) = 32
  call heltable([2,16,32], n3(:,6920), t3x32(:,:,3465))
  n2(2213) = 32
  call heltable([2,16,32], n3(:,6921), t3x32(:,:,3466))
  n2(2214) = 32
  call heltable([16,2,32], n3(:,6922), t3x32(:,:,3467))
  n2(2215) = 32
  call heltable([16,2,32], n3(:,6923), t3x32(:,:,3468))
  n2(2216) = 32
  call heltable([16,2,32], n3(:,6924), t3x32(:,:,3469))
  n2(2217) = 32
  call heltable([16,2,32], n3(:,6925), t3x32(:,:,3470))
  n2(2218) = 32
  call heltable([2,16,32], n3(:,6926), t3x32(:,:,3471))
  n2(2219) = 32
  call heltable([2,16,32], n3(:,6927), t3x32(:,:,3472))
  n2(2220) = 32
  call heltable([2,16,32], n3(:,6928), t3x32(:,:,3473))
  n2(2221) = 32
  call heltable([2,16,32], n3(:,6929), t3x32(:,:,3474))
  n2(2222) = 32
  call heltable([16,2,32], n3(:,6930), t3x32(:,:,3475))
  n2(2223) = 32
  call heltable([16,2,32], n3(:,6931), t3x32(:,:,3476))
  n2(2224) = 32
  call heltable([16,2,32], n3(:,6932), t3x32(:,:,3477))
  n2(2225) = 32
  call heltable([16,2,32], n3(:,6933), t3x32(:,:,3478))
  n2(2226) = 32
  call heltable([16,2,32], n3(:,6934), t3x32(:,:,3479))
  n2(2227) = 32
  call heltable([16,2,32], n3(:,6935), t3x32(:,:,3480))
  n2(2228) = 32
  call heltable([16,2,32], n3(:,6936), t3x32(:,:,3481))
  n2(2229) = 32
  call heltable([16,2,32], n3(:,6937), t3x32(:,:,3482))
  n2(2230) = 32
  call heltable([2,16,32], n3(:,6938), t3x32(:,:,3483))
  n2(2231) = 32
  call heltable([2,16,32], n3(:,6939), t3x32(:,:,3484))
  n2(2232) = 32
  call heltable([2,16,32], n3(:,6940), t3x32(:,:,3485))
  n2(2233) = 32
  call heltable([2,16,32], n3(:,6941), t3x32(:,:,3486))
  n2(2234) = 32
  call heltable([16,2,32], n3(:,6942), t3x32(:,:,3487))
  n2(2235) = 32
  call heltable([16,2,32], n3(:,6943), t3x32(:,:,3488))
  n2(2236) = 32
  call heltable([16,2,32], n3(:,6944), t3x32(:,:,3489))
  n2(2237) = 32
  call heltable([16,2,32], n3(:,6945), t3x32(:,:,3490))
  n2(2238) = 32
  call heltable([2,16,32], n3(:,6946), t3x32(:,:,3491))
  n2(2239) = 32
  call heltable([2,16,32], n3(:,6947), t3x32(:,:,3492))
  n2(2240) = 32
  call heltable([2,16,32], n3(:,6948), t3x32(:,:,3493))
  n2(2241) = 32
  call heltable([2,16,32], n3(:,6949), t3x32(:,:,3494))
  n2(2242) = 32
  call heltable([2,16,32], n3(:,6950), t3x32(:,:,3495))
  n2(2243) = 32
  call heltable([2,16,32], n3(:,6951), t3x32(:,:,3496))
  n2(2244) = 32
  call heltable([2,16,32], n3(:,6952), t3x32(:,:,3497))
  n2(2245) = 32
  call heltable([2,16,32], n3(:,6953), t3x32(:,:,3498))
  n2(2246) = 32
  call heltable([2,16,32], n3(:,6954), t3x32(:,:,3499))
  n2(2247) = 32
  call heltable([2,16,32], n3(:,6955), t3x32(:,:,3500))
  n2(2248) = 32
  call heltable([2,16,32], n3(:,6956), t3x32(:,:,3501))
  n2(2249) = 32
  call heltable([2,16,32], n3(:,6957), t3x32(:,:,3502))
  n2(2250) = 32
  call heltable([16,2,32], n3(:,6958), t3x32(:,:,3503))
  n2(2251) = 32
  call heltable([16,2,32], n3(:,6959), t3x32(:,:,3504))
  n2(2252) = 32
  call heltable([16,2,32], n3(:,6960), t3x32(:,:,3505))
  n2(2253) = 32
  call heltable([16,2,32], n3(:,6961), t3x32(:,:,3506))
  n2(2254) = 32
  call heltable([16,2,32], n3(:,6962), t3x32(:,:,3507))
  n2(2255) = 32
  call heltable([16,2,32], n3(:,6963), t3x32(:,:,3508))
  n2(2256) = 32
  call heltable([16,2,32], n3(:,6964), t3x32(:,:,3509))
  n2(2257) = 32
  call heltable([16,2,32], n3(:,6965), t3x32(:,:,3510))
  n2(2258) = 32
  call heltable([2,16,32], n3(:,6966), t3x32(:,:,3511))
  call heltable([2,16,32], n3(:,6967), t3x32(:,:,3512))
  call heltable([2,16,32], n3(:,6968), t3x32(:,:,3513))
  call heltable([2,16,32], n3(:,6969), t3x32(:,:,3514))
  call heltable([16,2,32], n3(:,6970), t3x32(:,:,3515))
  call heltable([16,2,32], n3(:,6971), t3x32(:,:,3516))
  call heltable([16,2,32], n3(:,6972), t3x32(:,:,3517))
  call heltable([16,2,32], n3(:,6973), t3x32(:,:,3518))
  call heltable([2,16,32], n3(:,6974), t3x32(:,:,3519))
  call heltable([2,16,32], n3(:,6975), t3x32(:,:,3520))
  call heltable([2,16,32], n3(:,6976), t3x32(:,:,3521))
  call heltable([2,16,32], n3(:,6977), t3x32(:,:,3522))
  call heltable([16,2,32], n3(:,6978), t3x32(:,:,3523))
  call heltable([16,2,32], n3(:,6979), t3x32(:,:,3524))
  call heltable([16,2,32], n3(:,6980), t3x32(:,:,3525))
  call heltable([16,2,32], n3(:,6981), t3x32(:,:,3526))
  call heltable([2,16,32], n3(:,6982), t3x32(:,:,3527))
  call heltable([2,16,32], n3(:,6983), t3x32(:,:,3528))
  call heltable([2,16,32], n3(:,6984), t3x32(:,:,3529))
  call heltable([2,16,32], n3(:,6985), t3x32(:,:,3530))
  call heltable([16,2,32], n3(:,6986), t3x32(:,:,3531))
  call heltable([16,2,32], n3(:,6987), t3x32(:,:,3532))
  call heltable([16,2,32], n3(:,6988), t3x32(:,:,3533))
  call heltable([16,2,32], n3(:,6989), t3x32(:,:,3534))
  call heltable([2,16,32], n3(:,6990), t3x32(:,:,3535))
  call heltable([2,16,32], n3(:,6991), t3x32(:,:,3536))
  call heltable([2,16,32], n3(:,6992), t3x32(:,:,3537))
  call heltable([2,16,32], n3(:,6993), t3x32(:,:,3538))
  call heltable([16,2,32], n3(:,6994), t3x32(:,:,3539))
  call heltable([16,2,32], n3(:,6995), t3x32(:,:,3540))
  call heltable([16,2,32], n3(:,6996), t3x32(:,:,3541))
  call heltable([16,2,32], n3(:,6997), t3x32(:,:,3542))
  call heltable([16,2,32], n3(:,6998), t3x32(:,:,3543))
  call heltable([16,2,32], n3(:,6999), t3x32(:,:,3544))
  call heltable([16,2,32], n3(:,7000), t3x32(:,:,3545))
  call heltable([16,2,32], n3(:,7001), t3x32(:,:,3546))
  call heltable([16,2,32], n3(:,7002), t3x32(:,:,3547))
  call heltable([16,2,32], n3(:,7003), t3x32(:,:,3548))
  call heltable([16,2,32], n3(:,7004), t3x32(:,:,3549))
  call heltable([16,2,32], n3(:,7005), t3x32(:,:,3550))
  call heltable([2,16,32], n3(:,7006), t3x32(:,:,3551))
  call heltable([2,16,32], n3(:,7007), t3x32(:,:,3552))
  call heltable([2,16,32], n3(:,7008), t3x32(:,:,3553))
  call heltable([2,16,32], n3(:,7009), t3x32(:,:,3554))
  call heltable([2,16,32], n3(:,7010), t3x32(:,:,3555))
  call heltable([2,16,32], n3(:,7011), t3x32(:,:,3556))
  call heltable([2,16,32], n3(:,7012), t3x32(:,:,3557))
  call heltable([2,16,32], n3(:,7013), t3x32(:,:,3558))
  call heltable([16,2,32], n3(:,7014), t3x32(:,:,3559))
  call heltable([16,2,32], n3(:,7015), t3x32(:,:,3560))
  call heltable([16,2,32], n3(:,7016), t3x32(:,:,3561))
  call heltable([16,2,32], n3(:,7017), t3x32(:,:,3562))
  call heltable([16,2,32], n3(:,7018), t3x32(:,:,3563))
  call heltable([16,2,32], n3(:,7019), t3x32(:,:,3564))
  call heltable([16,2,32], n3(:,7020), t3x32(:,:,3565))
  call heltable([16,2,32], n3(:,7021), t3x32(:,:,3566))
  call heltable([2,16,32], n3(:,7022), t3x32(:,:,3567))
  call heltable([2,16,32], n3(:,7023), t3x32(:,:,3568))
  call heltable([2,16,32], n3(:,7024), t3x32(:,:,3569))
  call heltable([2,16,32], n3(:,7025), t3x32(:,:,3570))
  call heltable([2,16,32], n3(:,7026), t3x32(:,:,3571))
  call heltable([2,16,32], n3(:,7027), t3x32(:,:,3572))
  call heltable([2,16,32], n3(:,7028), t3x32(:,:,3573))
  call heltable([2,16,32], n3(:,7029), t3x32(:,:,3574))
  call heltable([16,2,32], n3(:,7030), t3x32(:,:,3575))
  n2(2259) = 32
  call heltable([16,2,32], n3(:,7031), t3x32(:,:,3576))
  n2(2260) = 32
  call heltable([16,2,32], n3(:,7032), t3x32(:,:,3577))
  n2(2261) = 32
  call heltable([16,2,32], n3(:,7033), t3x32(:,:,3578))
  n2(2262) = 32
  call heltable([16,2,32], n3(:,7034), t3x32(:,:,3579))
  n2(2263) = 32
  call heltable([16,2,32], n3(:,7035), t3x32(:,:,3580))
  n2(2264) = 32
  call heltable([16,2,32], n3(:,7036), t3x32(:,:,3581))
  n2(2265) = 32
  call heltable([16,2,32], n3(:,7037), t3x32(:,:,3582))
  n2(2266) = 32
  call heltable([2,16,32], n3(:,7038), t3x32(:,:,3583))
  n2(2267) = 32
  call heltable([2,16,32], n3(:,7039), t3x32(:,:,3584))
  n2(2268) = 32
  call heltable([2,16,32], n3(:,7040), t3x32(:,:,3585))
  n2(2269) = 32
  call heltable([2,16,32], n3(:,7041), t3x32(:,:,3586))
  n2(2270) = 32
  call heltable([2,16,32], n3(:,7042), t3x32(:,:,3587))
  n2(2271) = 32
  call heltable([2,16,32], n3(:,7043), t3x32(:,:,3588))
  n2(2272) = 32
  call heltable([2,16,32], n3(:,7044), t3x32(:,:,3589))
  n2(2273) = 32
  call heltable([2,16,32], n3(:,7045), t3x32(:,:,3590))
  n2(2274) = 32
  call heltable([16,2,32], n3(:,7046), t3x32(:,:,3591))
  n2(2275) = 32
  call heltable([16,2,32], n3(:,7047), t3x32(:,:,3592))
  n2(2276) = 32
  call heltable([16,2,32], n3(:,7048), t3x32(:,:,3593))
  n2(2277) = 32
  call heltable([16,2,32], n3(:,7049), t3x32(:,:,3594))
  n2(2278) = 32
  call heltable([16,2,32], n3(:,7050), t3x32(:,:,3595))
  n2(2279) = 32
  call heltable([16,2,32], n3(:,7051), t3x32(:,:,3596))
  n2(2280) = 32
  call heltable([16,2,32], n3(:,7052), t3x32(:,:,3597))
  n2(2281) = 32
  call heltable([16,2,32], n3(:,7053), t3x32(:,:,3598))
  n2(2282) = 32
  call heltable([2,16,32], n3(:,7054), t3x32(:,:,3599))
  n2(2283) = 32
  call heltable([2,16,32], n3(:,7055), t3x32(:,:,3600))
  n2(2284) = 32
  call heltable([2,16,32], n3(:,7056), t3x32(:,:,3601))
  n2(2285) = 32
  call heltable([2,16,32], n3(:,7057), t3x32(:,:,3602))
  n2(2286) = 32
  call heltable([2,16,32], n3(:,7058), t3x32(:,:,3603))
  n2(2287) = 32
  call heltable([2,16,32], n3(:,7059), t3x32(:,:,3604))
  n2(2288) = 32
  call heltable([2,16,32], n3(:,7060), t3x32(:,:,3605))
  n2(2289) = 32
  call heltable([2,16,32], n3(:,7061), t3x32(:,:,3606))
  n2(2290) = 32
  call heltable([16,2,32], n3(:,7062), t3x32(:,:,3607))
  n2(2291) = 32
  call heltable([16,2,32], n3(:,7063), t3x32(:,:,3608))
  n2(2292) = 32
  call heltable([16,2,32], n3(:,7064), t3x32(:,:,3609))
  n2(2293) = 32
  call heltable([16,2,32], n3(:,7065), t3x32(:,:,3610))
  n2(2294) = 32
  call heltable([2,16,32], n3(:,7066), t3x32(:,:,3611))
  n2(2295) = 32
  call heltable([2,16,32], n3(:,7067), t3x32(:,:,3612))
  n2(2296) = 32
  call heltable([2,16,32], n3(:,7068), t3x32(:,:,3613))
  n2(2297) = 32
  call heltable([2,16,32], n3(:,7069), t3x32(:,:,3614))
  n2(2298) = 32
  call heltable([16,2,32], n3(:,7070), t3x32(:,:,3615))
  n2(2299) = 32
  call heltable([16,2,32], n3(:,7071), t3x32(:,:,3616))
  n2(2300) = 32
  call heltable([16,2,32], n3(:,7072), t3x32(:,:,3617))
  n2(2301) = 32
  call heltable([16,2,32], n3(:,7073), t3x32(:,:,3618))
  n2(2302) = 32
  call heltable([2,16,32], n3(:,7074), t3x32(:,:,3619))
  n2(2303) = 32
  call heltable([2,16,32], n3(:,7075), t3x32(:,:,3620))
  n2(2304) = 32
  call heltable([2,16,32], n3(:,7076), t3x32(:,:,3621))
  n2(2305) = 32
  call heltable([2,16,32], n3(:,7077), t3x32(:,:,3622))
  n2(2306) = 32
  call heltable([16,2,32], n3(:,7078), t3x32(:,:,3623))
  n2(2307) = 32
  call heltable([16,2,32], n3(:,7079), t3x32(:,:,3624))
  n2(2308) = 32
  call heltable([16,2,32], n3(:,7080), t3x32(:,:,3625))
  n2(2309) = 32
  call heltable([16,2,32], n3(:,7081), t3x32(:,:,3626))
  n2(2310) = 32
  call heltable([2,16,32], n3(:,7082), t3x32(:,:,3627))
  n2(2311) = 32
  call heltable([2,16,32], n3(:,7083), t3x32(:,:,3628))
  n2(2312) = 32
  call heltable([2,16,32], n3(:,7084), t3x32(:,:,3629))
  n2(2313) = 32
  call heltable([2,16,32], n3(:,7085), t3x32(:,:,3630))
  n2(2314) = 32
  call heltable([16,2,32], n3(:,7086), t3x32(:,:,3631))
  n2(2315) = 32
  call heltable([16,2,32], n3(:,7087), t3x32(:,:,3632))
  n2(2316) = 32
  call heltable([16,2,32], n3(:,7088), t3x32(:,:,3633))
  n2(2317) = 32
  call heltable([16,2,32], n3(:,7089), t3x32(:,:,3634))
  n2(2318) = 32
  call heltable([2,16,32], n3(:,7090), t3x32(:,:,3635))
  n2(2319) = 32
  call heltable([2,16,32], n3(:,7091), t3x32(:,:,3636))
  n2(2320) = 32
  call heltable([2,16,32], n3(:,7092), t3x32(:,:,3637))
  n2(2321) = 32
  call heltable([2,16,32], n3(:,7093), t3x32(:,:,3638))
  n2(2322) = 32
  call heltable([2,16,32], n3(:,7094), t3x32(:,:,3639))
  call heltable([2,16,32], n3(:,7095), t3x32(:,:,3640))
  call heltable([2,16,32], n3(:,7096), t3x32(:,:,3641))
  call heltable([2,16,32], n3(:,7097), t3x32(:,:,3642))
  call heltable([16,2,32], n3(:,7098), t3x32(:,:,3643))
  call heltable([16,2,32], n3(:,7099), t3x32(:,:,3644))
  call heltable([16,2,32], n3(:,7100), t3x32(:,:,3645))
  call heltable([16,2,32], n3(:,7101), t3x32(:,:,3646))
  call heltable([2,16,32], n3(:,7102), t3x32(:,:,3647))
  call heltable([2,16,32], n3(:,7103), t3x32(:,:,3648))
  call heltable([2,16,32], n3(:,7104), t3x32(:,:,3649))
  call heltable([2,16,32], n3(:,7105), t3x32(:,:,3650))
  call heltable([16,2,32], n3(:,7106), t3x32(:,:,3651))
  call heltable([16,2,32], n3(:,7107), t3x32(:,:,3652))
  call heltable([16,2,32], n3(:,7108), t3x32(:,:,3653))
  call heltable([16,2,32], n3(:,7109), t3x32(:,:,3654))
  call heltable([2,16,32], n3(:,7110), t3x32(:,:,3655))
  call heltable([2,16,32], n3(:,7111), t3x32(:,:,3656))
  call heltable([2,16,32], n3(:,7112), t3x32(:,:,3657))
  call heltable([2,16,32], n3(:,7113), t3x32(:,:,3658))
  call heltable([16,2,32], n3(:,7114), t3x32(:,:,3659))
  call heltable([16,2,32], n3(:,7115), t3x32(:,:,3660))
  call heltable([16,2,32], n3(:,7116), t3x32(:,:,3661))
  call heltable([16,2,32], n3(:,7117), t3x32(:,:,3662))
  call heltable([2,16,32], n3(:,7118), t3x32(:,:,3663))
  call heltable([2,16,32], n3(:,7119), t3x32(:,:,3664))
  call heltable([2,16,32], n3(:,7120), t3x32(:,:,3665))
  call heltable([2,16,32], n3(:,7121), t3x32(:,:,3666))
  call heltable([16,2,32], n3(:,7122), t3x32(:,:,3667))
  call heltable([16,2,32], n3(:,7123), t3x32(:,:,3668))
  call heltable([16,2,32], n3(:,7124), t3x32(:,:,3669))
  call heltable([16,2,32], n3(:,7125), t3x32(:,:,3670))
  call heltable([16,2,32], n3(:,7126), t3x32(:,:,3671))
  call heltable([16,2,32], n3(:,7127), t3x32(:,:,3672))
  call heltable([16,2,32], n3(:,7128), t3x32(:,:,3673))
  call heltable([16,2,32], n3(:,7129), t3x32(:,:,3674))
  call heltable([16,2,32], n3(:,7130), t3x32(:,:,3675))
  call heltable([16,2,32], n3(:,7131), t3x32(:,:,3676))
  call heltable([16,2,32], n3(:,7132), t3x32(:,:,3677))
  call heltable([16,2,32], n3(:,7133), t3x32(:,:,3678))
  call heltable([2,16,32], n3(:,7134), t3x32(:,:,3679))
  call heltable([2,16,32], n3(:,7135), t3x32(:,:,3680))
  call heltable([2,16,32], n3(:,7136), t3x32(:,:,3681))
  call heltable([2,16,32], n3(:,7137), t3x32(:,:,3682))
  call heltable([2,16,32], n3(:,7138), t3x32(:,:,3683))
  call heltable([2,16,32], n3(:,7139), t3x32(:,:,3684))
  call heltable([2,16,32], n3(:,7140), t3x32(:,:,3685))
  call heltable([2,16,32], n3(:,7141), t3x32(:,:,3686))
  call heltable([16,2,32], n3(:,7142), t3x32(:,:,3687))
  call heltable([16,2,32], n3(:,7143), t3x32(:,:,3688))
  call heltable([16,2,32], n3(:,7144), t3x32(:,:,3689))
  call heltable([16,2,32], n3(:,7145), t3x32(:,:,3690))
  call heltable([16,2,32], n3(:,7146), t3x32(:,:,3691))
  call heltable([16,2,32], n3(:,7147), t3x32(:,:,3692))
  call heltable([16,2,32], n3(:,7148), t3x32(:,:,3693))
  call heltable([16,2,32], n3(:,7149), t3x32(:,:,3694))
  call heltable([2,16,32], n3(:,7150), t3x32(:,:,3695))
  call heltable([2,16,32], n3(:,7151), t3x32(:,:,3696))
  call heltable([2,16,32], n3(:,7152), t3x32(:,:,3697))
  call heltable([2,16,32], n3(:,7153), t3x32(:,:,3698))
  call heltable([2,16,32], n3(:,7154), t3x32(:,:,3699))
  call heltable([2,16,32], n3(:,7155), t3x32(:,:,3700))
  call heltable([2,16,32], n3(:,7156), t3x32(:,:,3701))
  call heltable([2,16,32], n3(:,7157), t3x32(:,:,3702))
  call heltable([2,16,32], n3(:,7158), t3x32(:,:,3703))
  call heltable([2,16,32], n3(:,7159), t3x32(:,:,3704))
  call heltable([2,16,32], n3(:,7160), t3x32(:,:,3705))
  call heltable([2,16,32], n3(:,7161), t3x32(:,:,3706))
  call heltable([16,2,32], n3(:,7162), t3x32(:,:,3707))
  call heltable([16,2,32], n3(:,7163), t3x32(:,:,3708))
  call heltable([16,2,32], n3(:,7164), t3x32(:,:,3709))
  call heltable([16,2,32], n3(:,7165), t3x32(:,:,3710))
  call heltable([2,16,32], n3(:,7166), t3x32(:,:,3711))
  call heltable([2,16,32], n3(:,7167), t3x32(:,:,3712))
  call heltable([2,16,32], n3(:,7168), t3x32(:,:,3713))
  call heltable([2,16,32], n3(:,7169), t3x32(:,:,3714))
  call heltable([16,2,32], n3(:,7170), t3x32(:,:,3715))
  call heltable([16,2,32], n3(:,7171), t3x32(:,:,3716))
  call heltable([16,2,32], n3(:,7172), t3x32(:,:,3717))
  call heltable([16,2,32], n3(:,7173), t3x32(:,:,3718))
  call heltable([16,2,32], n3(:,7174), t3x32(:,:,3719))
  call heltable([16,2,32], n3(:,7175), t3x32(:,:,3720))
  call heltable([16,2,32], n3(:,7176), t3x32(:,:,3721))
  call heltable([16,2,32], n3(:,7177), t3x32(:,:,3722))
  call heltable([16,2,32], n3(:,7178), t3x32(:,:,3723))
  call heltable([16,2,32], n3(:,7179), t3x32(:,:,3724))
  call heltable([16,2,32], n3(:,7180), t3x32(:,:,3725))
  call heltable([16,2,32], n3(:,7181), t3x32(:,:,3726))
  call heltable([2,16,32], n3(:,7182), t3x32(:,:,3727))
  call heltable([2,16,32], n3(:,7183), t3x32(:,:,3728))
  call heltable([2,16,32], n3(:,7184), t3x32(:,:,3729))
  call heltable([2,16,32], n3(:,7185), t3x32(:,:,3730))
  call heltable([2,16,32], n3(:,7186), t3x32(:,:,3731))
  call heltable([2,16,32], n3(:,7187), t3x32(:,:,3732))
  call heltable([2,16,32], n3(:,7188), t3x32(:,:,3733))
  call heltable([2,16,32], n3(:,7189), t3x32(:,:,3734))
  call heltable([2,16,32], n3(:,7190), t3x32(:,:,3735))
  call heltable([2,16,32], n3(:,7191), t3x32(:,:,3736))
  call heltable([2,16,32], n3(:,7192), t3x32(:,:,3737))
  call heltable([2,16,32], n3(:,7193), t3x32(:,:,3738))
  call heltable([16,2,32], n3(:,7194), t3x32(:,:,3739))
  call heltable([16,2,32], n3(:,7195), t3x32(:,:,3740))
  call heltable([16,2,32], n3(:,7196), t3x32(:,:,3741))
  call heltable([16,2,32], n3(:,7197), t3x32(:,:,3742))
  call heltable([2,16,32], n3(:,7198), t3x32(:,:,3743))
  call heltable([2,16,32], n3(:,7199), t3x32(:,:,3744))
  call heltable([2,16,32], n3(:,7200), t3x32(:,:,3745))
  call heltable([2,16,32], n3(:,7201), t3x32(:,:,3746))
  call heltable([16,2,32], n3(:,7202), t3x32(:,:,3747))
  call heltable([16,2,32], n3(:,7203), t3x32(:,:,3748))
  call heltable([16,2,32], n3(:,7204), t3x32(:,:,3749))
  call heltable([16,2,32], n3(:,7205), t3x32(:,:,3750))
  call heltable([16,2,32], n3(:,7206), t3x32(:,:,3751))
  call heltable([16,2,32], n3(:,7207), t3x32(:,:,3752))
  call heltable([16,2,32], n3(:,7208), t3x32(:,:,3753))
  call heltable([16,2,32], n3(:,7209), t3x32(:,:,3754))
  call heltable([2,16,32], n3(:,7210), t3x32(:,:,3755))
  call heltable([2,16,32], n3(:,7211), t3x32(:,:,3756))
  call heltable([2,16,32], n3(:,7212), t3x32(:,:,3757))
  call heltable([2,16,32], n3(:,7213), t3x32(:,:,3758))
  call heltable([16,2,32], n3(:,7214), t3x32(:,:,3759))
  call heltable([16,2,32], n3(:,7215), t3x32(:,:,3760))
  call heltable([16,2,32], n3(:,7216), t3x32(:,:,3761))
  call heltable([16,2,32], n3(:,7217), t3x32(:,:,3762))
  call heltable([2,16,32], n3(:,7218), t3x32(:,:,3763))
  call heltable([2,16,32], n3(:,7219), t3x32(:,:,3764))
  call heltable([2,16,32], n3(:,7220), t3x32(:,:,3765))
  call heltable([2,16,32], n3(:,7221), t3x32(:,:,3766))
  call heltable([2,16,32], n3(:,7222), t3x32(:,:,3767))
  call heltable([2,16,32], n3(:,7223), t3x32(:,:,3768))
  call heltable([2,16,32], n3(:,7224), t3x32(:,:,3769))
  call heltable([2,16,32], n3(:,7225), t3x32(:,:,3770))
  call heltable([16,2,32], n3(:,7226), t3x32(:,:,3771))
  call heltable([16,2,32], n3(:,7227), t3x32(:,:,3772))
  call heltable([16,2,32], n3(:,7228), t3x32(:,:,3773))
  call heltable([16,2,32], n3(:,7229), t3x32(:,:,3774))
  call heltable([2,16,32], n3(:,7230), t3x32(:,:,3775))
  call heltable([2,16,32], n3(:,7231), t3x32(:,:,3776))
  call heltable([2,16,32], n3(:,7232), t3x32(:,:,3777))
  call heltable([2,16,32], n3(:,7233), t3x32(:,:,3778))
  call heltable([16,2,32], n3(:,7234), t3x32(:,:,3779))
  call heltable([16,2,32], n3(:,7235), t3x32(:,:,3780))
  call heltable([16,2,32], n3(:,7236), t3x32(:,:,3781))
  call heltable([16,2,32], n3(:,7237), t3x32(:,:,3782))
  call heltable([16,2,32], n3(:,7238), t3x32(:,:,3783))
  call heltable([16,2,32], n3(:,7239), t3x32(:,:,3784))
  call heltable([16,2,32], n3(:,7240), t3x32(:,:,3785))
  call heltable([16,2,32], n3(:,7241), t3x32(:,:,3786))
  call heltable([16,2,32], n3(:,7242), t3x32(:,:,3787))
  call heltable([16,2,32], n3(:,7243), t3x32(:,:,3788))
  call heltable([16,2,32], n3(:,7244), t3x32(:,:,3789))
  call heltable([16,2,32], n3(:,7245), t3x32(:,:,3790))
  call heltable([2,16,32], n3(:,7246), t3x32(:,:,3791))
  call heltable([2,16,32], n3(:,7247), t3x32(:,:,3792))
  call heltable([2,16,32], n3(:,7248), t3x32(:,:,3793))
  call heltable([2,16,32], n3(:,7249), t3x32(:,:,3794))
  call heltable([2,16,32], n3(:,7250), t3x32(:,:,3795))
  call heltable([2,16,32], n3(:,7251), t3x32(:,:,3796))
  call heltable([2,16,32], n3(:,7252), t3x32(:,:,3797))
  call heltable([2,16,32], n3(:,7253), t3x32(:,:,3798))
  call heltable([2,16,32], n3(:,7254), t3x32(:,:,3799))
  call heltable([2,16,32], n3(:,7255), t3x32(:,:,3800))
  call heltable([2,16,32], n3(:,7256), t3x32(:,:,3801))
  call heltable([2,16,32], n3(:,7257), t3x32(:,:,3802))
  call heltable([16,2,32], n3(:,7258), t3x32(:,:,3803))
  call heltable([16,2,32], n3(:,7259), t3x32(:,:,3804))
  call heltable([16,2,32], n3(:,7260), t3x32(:,:,3805))
  call heltable([16,2,32], n3(:,7261), t3x32(:,:,3806))
  call heltable([2,16,32], n3(:,7262), t3x32(:,:,3807))
  call heltable([2,16,32], n3(:,7263), t3x32(:,:,3808))
  call heltable([2,16,32], n3(:,7264), t3x32(:,:,3809))
  call heltable([2,16,32], n3(:,7265), t3x32(:,:,3810))
  call heltable([16,2,32], n3(:,7266), t3x32(:,:,3811))
  call heltable([16,2,32], n3(:,7267), t3x32(:,:,3812))
  call heltable([16,2,32], n3(:,7268), t3x32(:,:,3813))
  call heltable([16,2,32], n3(:,7269), t3x32(:,:,3814))
  call heltable([16,2,32], n3(:,7270), t3x32(:,:,3815))
  call heltable([16,2,32], n3(:,7271), t3x32(:,:,3816))
  call heltable([16,2,32], n3(:,7272), t3x32(:,:,3817))
  call heltable([16,2,32], n3(:,7273), t3x32(:,:,3818))
  call heltable([2,16,32], n3(:,7274), t3x32(:,:,3819))
  call heltable([2,16,32], n3(:,7275), t3x32(:,:,3820))
  call heltable([2,16,32], n3(:,7276), t3x32(:,:,3821))
  call heltable([2,16,32], n3(:,7277), t3x32(:,:,3822))
  call heltable([16,2,32], n3(:,7278), t3x32(:,:,3823))
  call heltable([16,2,32], n3(:,7279), t3x32(:,:,3824))
  call heltable([16,2,32], n3(:,7280), t3x32(:,:,3825))
  call heltable([16,2,32], n3(:,7281), t3x32(:,:,3826))
  call heltable([2,16,32], n3(:,7282), t3x32(:,:,3827))
  call heltable([2,16,32], n3(:,7283), t3x32(:,:,3828))
  call heltable([2,16,32], n3(:,7284), t3x32(:,:,3829))
  call heltable([2,16,32], n3(:,7285), t3x32(:,:,3830))
  call heltable([2,16,32], n3(:,7286), t3x32(:,:,3831))
  call heltable([2,16,32], n3(:,7287), t3x32(:,:,3832))
  call heltable([2,16,32], n3(:,7288), t3x32(:,:,3833))
  call heltable([2,16,32], n3(:,7289), t3x32(:,:,3834))
  call heltable([16,2,32], n3(:,7290), t3x32(:,:,3835))
  call heltable([16,2,32], n3(:,7291), t3x32(:,:,3836))
  call heltable([16,2,32], n3(:,7292), t3x32(:,:,3837))
  call heltable([16,2,32], n3(:,7293), t3x32(:,:,3838))
  call heltable([2,16,32], n3(:,7294), t3x32(:,:,3839))
  call heltable([2,16,32], n3(:,7295), t3x32(:,:,3840))
  call heltable([2,16,32], n3(:,7296), t3x32(:,:,3841))
  call heltable([2,16,32], n3(:,7297), t3x32(:,:,3842))
  call heltable([16,2,32], n3(:,7298), t3x32(:,:,3843))
  call heltable([16,2,32], n3(:,7299), t3x32(:,:,3844))
  call heltable([16,2,32], n3(:,7300), t3x32(:,:,3845))
  call heltable([16,2,32], n3(:,7301), t3x32(:,:,3846))
  call heltable([2,16,32], n3(:,7302), t3x32(:,:,3847))
  call heltable([2,16,32], n3(:,7303), t3x32(:,:,3848))
  call heltable([2,16,32], n3(:,7304), t3x32(:,:,3849))
  call heltable([2,16,32], n3(:,7305), t3x32(:,:,3850))
  call heltable([16,2,32], n3(:,7306), t3x32(:,:,3851))
  call heltable([16,2,32], n3(:,7307), t3x32(:,:,3852))
  call heltable([16,2,32], n3(:,7308), t3x32(:,:,3853))
  call heltable([16,2,32], n3(:,7309), t3x32(:,:,3854))
  call heltable([2,16,32], n3(:,7310), t3x32(:,:,3855))
  call heltable([2,16,32], n3(:,7311), t3x32(:,:,3856))
  call heltable([2,16,32], n3(:,7312), t3x32(:,:,3857))
  call heltable([2,16,32], n3(:,7313), t3x32(:,:,3858))
  call heltable([16,2,32], n3(:,7314), t3x32(:,:,3859))
  call heltable([16,2,32], n3(:,7315), t3x32(:,:,3860))
  call heltable([16,2,32], n3(:,7316), t3x32(:,:,3861))
  call heltable([16,2,32], n3(:,7317), t3x32(:,:,3862))
  call heltable([16,2,32], n3(:,7318), t3x32(:,:,3863))
  call heltable([16,2,32], n3(:,7319), t3x32(:,:,3864))
  call heltable([16,2,32], n3(:,7320), t3x32(:,:,3865))
  call heltable([16,2,32], n3(:,7321), t3x32(:,:,3866))
  call heltable([16,2,32], n3(:,7322), t3x32(:,:,3867))
  call heltable([16,2,32], n3(:,7323), t3x32(:,:,3868))
  call heltable([16,2,32], n3(:,7324), t3x32(:,:,3869))
  call heltable([16,2,32], n3(:,7325), t3x32(:,:,3870))
  call heltable([2,16,32], n3(:,7326), t3x32(:,:,3871))
  call heltable([2,16,32], n3(:,7327), t3x32(:,:,3872))
  call heltable([2,16,32], n3(:,7328), t3x32(:,:,3873))
  call heltable([2,16,32], n3(:,7329), t3x32(:,:,3874))
  call heltable([2,16,32], n3(:,7330), t3x32(:,:,3875))
  call heltable([2,16,32], n3(:,7331), t3x32(:,:,3876))
  call heltable([2,16,32], n3(:,7332), t3x32(:,:,3877))
  call heltable([2,16,32], n3(:,7333), t3x32(:,:,3878))
  call heltable([16,2,32], n3(:,7334), t3x32(:,:,3879))
  call heltable([16,2,32], n3(:,7335), t3x32(:,:,3880))
  call heltable([16,2,32], n3(:,7336), t3x32(:,:,3881))
  call heltable([16,2,32], n3(:,7337), t3x32(:,:,3882))
  call heltable([16,2,32], n3(:,7338), t3x32(:,:,3883))
  call heltable([16,2,32], n3(:,7339), t3x32(:,:,3884))
  call heltable([16,2,32], n3(:,7340), t3x32(:,:,3885))
  call heltable([16,2,32], n3(:,7341), t3x32(:,:,3886))
  call heltable([2,16,32], n3(:,7342), t3x32(:,:,3887))
  call heltable([2,16,32], n3(:,7343), t3x32(:,:,3888))
  call heltable([2,16,32], n3(:,7344), t3x32(:,:,3889))
  call heltable([2,16,32], n3(:,7345), t3x32(:,:,3890))
  call heltable([2,16,32], n3(:,7346), t3x32(:,:,3891))
  call heltable([2,16,32], n3(:,7347), t3x32(:,:,3892))
  call heltable([2,16,32], n3(:,7348), t3x32(:,:,3893))
  call heltable([2,16,32], n3(:,7349), t3x32(:,:,3894))
  call heltable([2,16,32], n3(:,7350), t3x32(:,:,3895))
  call heltable([2,16,32], n3(:,7351), t3x32(:,:,3896))
  call heltable([2,16,32], n3(:,7352), t3x32(:,:,3897))
  call heltable([2,16,32], n3(:,7353), t3x32(:,:,3898))
  call heltable([16,2,32], n3(:,7354), t3x32(:,:,3899))
  call heltable([16,2,32], n3(:,7355), t3x32(:,:,3900))
  call heltable([16,2,32], n3(:,7356), t3x32(:,:,3901))
  call heltable([16,2,32], n3(:,7357), t3x32(:,:,3902))
  call heltable([2,16,32], n3(:,7358), t3x32(:,:,3903))
  call heltable([2,16,32], n3(:,7359), t3x32(:,:,3904))
  call heltable([2,16,32], n3(:,7360), t3x32(:,:,3905))
  call heltable([2,16,32], n3(:,7361), t3x32(:,:,3906))
  call heltable([16,2,32], n3(:,7362), t3x32(:,:,3907))
  call heltable([16,2,32], n3(:,7363), t3x32(:,:,3908))
  call heltable([16,2,32], n3(:,7364), t3x32(:,:,3909))
  call heltable([16,2,32], n3(:,7365), t3x32(:,:,3910))
  call heltable([16,2,32], n3(:,7366), t3x32(:,:,3911))
  call heltable([16,2,32], n3(:,7367), t3x32(:,:,3912))
  call heltable([16,2,32], n3(:,7368), t3x32(:,:,3913))
  call heltable([16,2,32], n3(:,7369), t3x32(:,:,3914))
  call heltable([2,16,32], n3(:,7370), t3x32(:,:,3915))
  call heltable([2,16,32], n3(:,7371), t3x32(:,:,3916))
  call heltable([2,16,32], n3(:,7372), t3x32(:,:,3917))
  call heltable([2,16,32], n3(:,7373), t3x32(:,:,3918))
  call heltable([16,2,32], n3(:,7374), t3x32(:,:,3919))
  call heltable([16,2,32], n3(:,7375), t3x32(:,:,3920))
  call heltable([16,2,32], n3(:,7376), t3x32(:,:,3921))
  call heltable([16,2,32], n3(:,7377), t3x32(:,:,3922))
  call heltable([2,16,32], n3(:,7378), t3x32(:,:,3923))
  call heltable([2,16,32], n3(:,7379), t3x32(:,:,3924))
  call heltable([2,16,32], n3(:,7380), t3x32(:,:,3925))
  call heltable([2,16,32], n3(:,7381), t3x32(:,:,3926))
  call heltable([2,16,32], n3(:,7382), t3x32(:,:,3927))
  call heltable([2,16,32], n3(:,7383), t3x32(:,:,3928))
  call heltable([2,16,32], n3(:,7384), t3x32(:,:,3929))
  call heltable([2,16,32], n3(:,7385), t3x32(:,:,3930))
  call heltable([16,2,32], n3(:,7386), t3x32(:,:,3931))
  call heltable([16,2,32], n3(:,7387), t3x32(:,:,3932))
  call heltable([16,2,32], n3(:,7388), t3x32(:,:,3933))
  call heltable([16,2,32], n3(:,7389), t3x32(:,:,3934))
  call heltable([2,16,32], n3(:,7390), t3x32(:,:,3935))
  call heltable([2,16,32], n3(:,7391), t3x32(:,:,3936))
  call heltable([2,16,32], n3(:,7392), t3x32(:,:,3937))
  call heltable([2,16,32], n3(:,7393), t3x32(:,:,3938))
  call heltable([16,2,32], n3(:,7394), t3x32(:,:,3939))
  call heltable([16,2,32], n3(:,7395), t3x32(:,:,3940))
  call heltable([16,2,32], n3(:,7396), t3x32(:,:,3941))
  call heltable([16,2,32], n3(:,7397), t3x32(:,:,3942))
  call heltable([16,2,32], n3(:,7398), t3x32(:,:,3943))
  call heltable([16,2,32], n3(:,7399), t3x32(:,:,3944))
  call heltable([16,2,32], n3(:,7400), t3x32(:,:,3945))
  call heltable([16,2,32], n3(:,7401), t3x32(:,:,3946))
  call heltable([2,16,32], n3(:,7402), t3x32(:,:,3947))
  call heltable([2,16,32], n3(:,7403), t3x32(:,:,3948))
  call heltable([2,16,32], n3(:,7404), t3x32(:,:,3949))
  call heltable([2,16,32], n3(:,7405), t3x32(:,:,3950))
  call heltable([16,2,32], n3(:,7406), t3x32(:,:,3951))
  call heltable([16,2,32], n3(:,7407), t3x32(:,:,3952))
  call heltable([16,2,32], n3(:,7408), t3x32(:,:,3953))
  call heltable([16,2,32], n3(:,7409), t3x32(:,:,3954))
  call heltable([2,16,32], n3(:,7410), t3x32(:,:,3955))
  call heltable([2,16,32], n3(:,7411), t3x32(:,:,3956))
  call heltable([2,16,32], n3(:,7412), t3x32(:,:,3957))
  call heltable([2,16,32], n3(:,7413), t3x32(:,:,3958))
  call heltable([2,16,32], n3(:,7414), t3x32(:,:,3959))
  call heltable([2,16,32], n3(:,7415), t3x32(:,:,3960))
  call heltable([2,16,32], n3(:,7416), t3x32(:,:,3961))
  call heltable([2,16,32], n3(:,7417), t3x32(:,:,3962))
  call heltable([16,2,32], n3(:,7418), t3x32(:,:,3963))
  call heltable([16,2,32], n3(:,7419), t3x32(:,:,3964))
  call heltable([16,2,32], n3(:,7420), t3x32(:,:,3965))
  call heltable([16,2,32], n3(:,7421), t3x32(:,:,3966))
  call heltable([2,16,32], n3(:,7422), t3x32(:,:,3967))
  call heltable([2,16,32], n3(:,7423), t3x32(:,:,3968))
  call heltable([2,16,32], n3(:,7424), t3x32(:,:,3969))
  call heltable([2,16,32], n3(:,7425), t3x32(:,:,3970))
  call heltable([16,2,32], n3(:,7426), t3x32(:,:,3971))
  call heltable([16,2,32], n3(:,7427), t3x32(:,:,3972))
  call heltable([16,2,32], n3(:,7428), t3x32(:,:,3973))
  call heltable([16,2,32], n3(:,7429), t3x32(:,:,3974))
  call heltable([2,16,32], n3(:,7430), t3x32(:,:,3975))
  call heltable([2,16,32], n3(:,7431), t3x32(:,:,3976))
  call heltable([2,16,32], n3(:,7432), t3x32(:,:,3977))
  call heltable([2,16,32], n3(:,7433), t3x32(:,:,3978))
  call heltable([16,2,32], n3(:,7434), t3x32(:,:,3979))
  call heltable([16,2,32], n3(:,7435), t3x32(:,:,3980))
  call heltable([16,2,32], n3(:,7436), t3x32(:,:,3981))
  call heltable([16,2,32], n3(:,7437), t3x32(:,:,3982))
  call heltable([2,16,32], n3(:,7438), t3x32(:,:,3983))
  call heltable([2,16,32], n3(:,7439), t3x32(:,:,3984))
  call heltable([2,16,32], n3(:,7440), t3x32(:,:,3985))
  call heltable([2,16,32], n3(:,7441), t3x32(:,:,3986))
  call heltable([16,2,32], n3(:,7442), t3x32(:,:,3987))
  call heltable([16,2,32], n3(:,7443), t3x32(:,:,3988))
  call heltable([16,2,32], n3(:,7444), t3x32(:,:,3989))
  call heltable([16,2,32], n3(:,7445), t3x32(:,:,3990))
  call heltable([16,2,32], n3(:,7446), t3x32(:,:,3991))
  call heltable([16,2,32], n3(:,7447), t3x32(:,:,3992))
  call heltable([16,2,32], n3(:,7448), t3x32(:,:,3993))
  call heltable([16,2,32], n3(:,7449), t3x32(:,:,3994))
  call heltable([2,16,32], n3(:,7450), t3x32(:,:,3995))
  call heltable([2,16,32], n3(:,7451), t3x32(:,:,3996))
  call heltable([2,16,32], n3(:,7452), t3x32(:,:,3997))
  call heltable([2,16,32], n3(:,7453), t3x32(:,:,3998))
  call heltable([16,2,32], n3(:,7454), t3x32(:,:,3999))
  call heltable([16,2,32], n3(:,7455), t3x32(:,:,4000))
  call heltable([16,2,32], n3(:,7456), t3x32(:,:,4001))
  call heltable([16,2,32], n3(:,7457), t3x32(:,:,4002))
  call heltable([2,16,32], n3(:,7458), t3x32(:,:,4003))
  call heltable([2,16,32], n3(:,7459), t3x32(:,:,4004))
  call heltable([2,16,32], n3(:,7460), t3x32(:,:,4005))
  call heltable([2,16,32], n3(:,7461), t3x32(:,:,4006))
  call heltable([2,16,32], n3(:,7462), t3x32(:,:,4007))
  call heltable([2,16,32], n3(:,7463), t3x32(:,:,4008))
  call heltable([2,16,32], n3(:,7464), t3x32(:,:,4009))
  call heltable([2,16,32], n3(:,7465), t3x32(:,:,4010))
  call heltable([16,2,32], n3(:,7466), t3x32(:,:,4011))
  call heltable([16,2,32], n3(:,7467), t3x32(:,:,4012))
  call heltable([16,2,32], n3(:,7468), t3x32(:,:,4013))
  call heltable([16,2,32], n3(:,7469), t3x32(:,:,4014))
  call heltable([2,16,32], n3(:,7470), t3x32(:,:,4015))
  call heltable([2,16,32], n3(:,7471), t3x32(:,:,4016))
  call heltable([2,16,32], n3(:,7472), t3x32(:,:,4017))
  call heltable([2,16,32], n3(:,7473), t3x32(:,:,4018))
  call heltable([16,2,32], n3(:,7474), t3x32(:,:,4019))
  call heltable([16,2,32], n3(:,7475), t3x32(:,:,4020))
  call heltable([16,2,32], n3(:,7476), t3x32(:,:,4021))
  call heltable([16,2,32], n3(:,7477), t3x32(:,:,4022))
  call heltable([16,2,32], n3(:,7478), t3x32(:,:,4023))
  call heltable([16,2,32], n3(:,7479), t3x32(:,:,4024))
  call heltable([16,2,32], n3(:,7480), t3x32(:,:,4025))
  call heltable([16,2,32], n3(:,7481), t3x32(:,:,4026))
  call heltable([2,16,32], n3(:,7482), t3x32(:,:,4027))
  call heltable([2,16,32], n3(:,7483), t3x32(:,:,4028))
  call heltable([2,16,32], n3(:,7484), t3x32(:,:,4029))
  call heltable([2,16,32], n3(:,7485), t3x32(:,:,4030))
  call heltable([16,2,32], n3(:,7486), t3x32(:,:,4031))
  call heltable([16,2,32], n3(:,7487), t3x32(:,:,4032))
  call heltable([16,2,32], n3(:,7488), t3x32(:,:,4033))
  call heltable([16,2,32], n3(:,7489), t3x32(:,:,4034))
  call heltable([2,16,32], n3(:,7490), t3x32(:,:,4035))
  call heltable([2,16,32], n3(:,7491), t3x32(:,:,4036))
  call heltable([2,16,32], n3(:,7492), t3x32(:,:,4037))
  call heltable([2,16,32], n3(:,7493), t3x32(:,:,4038))
  call heltable([16,2,32], n3(:,7494), t3x32(:,:,4039))
  call heltable([16,2,32], n3(:,7495), t3x32(:,:,4040))
  call heltable([16,2,32], n3(:,7496), t3x32(:,:,4041))
  call heltable([16,2,32], n3(:,7497), t3x32(:,:,4042))
  call heltable([16,2,32], n3(:,7498), t3x32(:,:,4043))
  call heltable([16,2,32], n3(:,7499), t3x32(:,:,4044))
  call heltable([16,2,32], n3(:,7500), t3x32(:,:,4045))
  call heltable([16,2,32], n3(:,7501), t3x32(:,:,4046))
  call heltable([2,16,32], n3(:,7502), t3x32(:,:,4047))
  call heltable([2,16,32], n3(:,7503), t3x32(:,:,4048))
  call heltable([2,16,32], n3(:,7504), t3x32(:,:,4049))
  call heltable([2,16,32], n3(:,7505), t3x32(:,:,4050))
  call heltable([2,16,32], n3(:,7506), t3x32(:,:,4051))
  call heltable([2,16,32], n3(:,7507), t3x32(:,:,4052))
  call heltable([2,16,32], n3(:,7508), t3x32(:,:,4053))
  call heltable([2,16,32], n3(:,7509), t3x32(:,:,4054))
  call heltable([2,16,32], n3(:,7510), t3x32(:,:,4055))
  call heltable([2,16,32], n3(:,7511), t3x32(:,:,4056))
  call heltable([2,16,32], n3(:,7512), t3x32(:,:,4057))
  call heltable([2,16,32], n3(:,7513), t3x32(:,:,4058))
  call heltable([16,2,32], n3(:,7514), t3x32(:,:,4059))
  call heltable([16,2,32], n3(:,7515), t3x32(:,:,4060))
  call heltable([16,2,32], n3(:,7516), t3x32(:,:,4061))
  call heltable([16,2,32], n3(:,7517), t3x32(:,:,4062))
  call heltable([2,16,32], n3(:,7518), t3x32(:,:,4063))
  call heltable([2,16,32], n3(:,7519), t3x32(:,:,4064))
  call heltable([2,16,32], n3(:,7520), t3x32(:,:,4065))
  call heltable([2,16,32], n3(:,7521), t3x32(:,:,4066))
  call heltable([16,2,32], n3(:,7522), t3x32(:,:,4067))
  call heltable([16,2,32], n3(:,7523), t3x32(:,:,4068))
  call heltable([16,2,32], n3(:,7524), t3x32(:,:,4069))
  call heltable([16,2,32], n3(:,7525), t3x32(:,:,4070))
  call heltable([16,2,32], n3(:,7526), t3x32(:,:,4071))
  call heltable([16,2,32], n3(:,7527), t3x32(:,:,4072))
  call heltable([16,2,32], n3(:,7528), t3x32(:,:,4073))
  call heltable([16,2,32], n3(:,7529), t3x32(:,:,4074))
  call heltable([2,16,32], n3(:,7530), t3x32(:,:,4075))
  call heltable([2,16,32], n3(:,7531), t3x32(:,:,4076))
  call heltable([2,16,32], n3(:,7532), t3x32(:,:,4077))
  call heltable([2,16,32], n3(:,7533), t3x32(:,:,4078))
  call heltable([16,2,32], n3(:,7534), t3x32(:,:,4079))
  call heltable([16,2,32], n3(:,7535), t3x32(:,:,4080))
  call heltable([16,2,32], n3(:,7536), t3x32(:,:,4081))
  call heltable([16,2,32], n3(:,7537), t3x32(:,:,4082))
  call heltable([2,16,32], n3(:,7538), t3x32(:,:,4083))
  call heltable([2,16,32], n3(:,7539), t3x32(:,:,4084))
  call heltable([2,16,32], n3(:,7540), t3x32(:,:,4085))
  call heltable([2,16,32], n3(:,7541), t3x32(:,:,4086))
  call heltable([2,16,32], n3(:,7542), t3x32(:,:,4087))
  call heltable([2,16,32], n3(:,7543), t3x32(:,:,4088))
  call heltable([2,16,32], n3(:,7544), t3x32(:,:,4089))
  call heltable([2,16,32], n3(:,7545), t3x32(:,:,4090))
  call heltable([16,2,32], n3(:,7546), t3x32(:,:,4091))
  call heltable([16,2,32], n3(:,7547), t3x32(:,:,4092))
  call heltable([16,2,32], n3(:,7548), t3x32(:,:,4093))
  call heltable([16,2,32], n3(:,7549), t3x32(:,:,4094))
  call heltable([2,16,32], n3(:,7550), t3x32(:,:,4095))
  call heltable([2,16,32], n3(:,7551), t3x32(:,:,4096))
  call heltable([2,16,32], n3(:,7552), t3x32(:,:,4097))
  call heltable([2,16,32], n3(:,7553), t3x32(:,:,4098))
  call heltable([16,2,32], n3(:,7554), t3x32(:,:,4099))
  call heltable([16,2,32], n3(:,7555), t3x32(:,:,4100))
  call heltable([16,2,32], n3(:,7556), t3x32(:,:,4101))
  call heltable([16,2,32], n3(:,7557), t3x32(:,:,4102))
  call heltable([2,16,32], n3(:,7558), t3x32(:,:,4103))
  call heltable([2,16,32], n3(:,7559), t3x32(:,:,4104))
  call heltable([2,16,32], n3(:,7560), t3x32(:,:,4105))
  call heltable([2,16,32], n3(:,7561), t3x32(:,:,4106))
  call heltable([16,2,32], n3(:,7562), t3x32(:,:,4107))
  call heltable([16,2,32], n3(:,7563), t3x32(:,:,4108))
  call heltable([16,2,32], n3(:,7564), t3x32(:,:,4109))
  call heltable([16,2,32], n3(:,7565), t3x32(:,:,4110))
  call heltable([2,16,32], n3(:,7566), t3x32(:,:,4111))
  call heltable([2,16,32], n3(:,7567), t3x32(:,:,4112))
  call heltable([2,16,32], n3(:,7568), t3x32(:,:,4113))
  call heltable([2,16,32], n3(:,7569), t3x32(:,:,4114))
  call heltable([16,2,32], n3(:,7570), t3x32(:,:,4115))
  call heltable([16,2,32], n3(:,7571), t3x32(:,:,4116))
  call heltable([16,2,32], n3(:,7572), t3x32(:,:,4117))
  call heltable([16,2,32], n3(:,7573), t3x32(:,:,4118))
  call heltable([16,2,32], n3(:,7574), t3x32(:,:,4119))
  call heltable([16,2,32], n3(:,7575), t3x32(:,:,4120))
  call heltable([16,2,32], n3(:,7576), t3x32(:,:,4121))
  call heltable([16,2,32], n3(:,7577), t3x32(:,:,4122))
  call heltable([2,16,32], n3(:,7578), t3x32(:,:,4123))
  call heltable([2,16,32], n3(:,7579), t3x32(:,:,4124))
  call heltable([2,16,32], n3(:,7580), t3x32(:,:,4125))
  call heltable([2,16,32], n3(:,7581), t3x32(:,:,4126))
  call heltable([16,2,32], n3(:,7582), t3x32(:,:,4127))
  call heltable([16,2,32], n3(:,7583), t3x32(:,:,4128))
  call heltable([16,2,32], n3(:,7584), t3x32(:,:,4129))
  call heltable([16,2,32], n3(:,7585), t3x32(:,:,4130))
  call heltable([2,16,32], n3(:,7586), t3x32(:,:,4131))
  call heltable([2,16,32], n3(:,7587), t3x32(:,:,4132))
  call heltable([2,16,32], n3(:,7588), t3x32(:,:,4133))
  call heltable([2,16,32], n3(:,7589), t3x32(:,:,4134))
  call heltable([16,2,32], n3(:,7590), t3x32(:,:,4135))
  call heltable([16,2,32], n3(:,7591), t3x32(:,:,4136))
  call heltable([16,2,32], n3(:,7592), t3x32(:,:,4137))
  call heltable([16,2,32], n3(:,7593), t3x32(:,:,4138))
  call heltable([16,2,32], n3(:,7594), t3x32(:,:,4139))
  call heltable([16,2,32], n3(:,7595), t3x32(:,:,4140))
  call heltable([16,2,32], n3(:,7596), t3x32(:,:,4141))
  call heltable([16,2,32], n3(:,7597), t3x32(:,:,4142))
  call heltable([2,16,32], n3(:,7598), t3x32(:,:,4143))
  call heltable([2,16,32], n3(:,7599), t3x32(:,:,4144))
  call heltable([2,16,32], n3(:,7600), t3x32(:,:,4145))
  call heltable([2,16,32], n3(:,7601), t3x32(:,:,4146))
  call heltable([2,16,32], n3(:,7602), t3x32(:,:,4147))
  call heltable([2,16,32], n3(:,7603), t3x32(:,:,4148))
  call heltable([2,16,32], n3(:,7604), t3x32(:,:,4149))
  call heltable([2,16,32], n3(:,7605), t3x32(:,:,4150))
  call heltable([2,16,32], n3(:,7606), t3x32(:,:,4151))
  call heltable([2,16,32], n3(:,7607), t3x32(:,:,4152))
  call heltable([2,16,32], n3(:,7608), t3x32(:,:,4153))
  call heltable([2,16,32], n3(:,7609), t3x32(:,:,4154))
  call heltable([16,2,32], n3(:,7610), t3x32(:,:,4155))
  call heltable([16,2,32], n3(:,7611), t3x32(:,:,4156))
  call heltable([16,2,32], n3(:,7612), t3x32(:,:,4157))
  call heltable([16,2,32], n3(:,7613), t3x32(:,:,4158))
  call heltable([2,16,32], n3(:,7614), t3x32(:,:,4159))
  call heltable([2,16,32], n3(:,7615), t3x32(:,:,4160))
  call heltable([2,16,32], n3(:,7616), t3x32(:,:,4161))
  call heltable([2,16,32], n3(:,7617), t3x32(:,:,4162))
  call heltable([16,2,32], n3(:,7618), t3x32(:,:,4163))
  call heltable([16,2,32], n3(:,7619), t3x32(:,:,4164))
  call heltable([16,2,32], n3(:,7620), t3x32(:,:,4165))
  call heltable([16,2,32], n3(:,7621), t3x32(:,:,4166))
  call heltable([16,2,32], n3(:,7622), t3x32(:,:,4167))
  call heltable([16,2,32], n3(:,7623), t3x32(:,:,4168))
  call heltable([16,2,32], n3(:,7624), t3x32(:,:,4169))
  call heltable([16,2,32], n3(:,7625), t3x32(:,:,4170))
  call heltable([2,16,32], n3(:,7626), t3x32(:,:,4171))
  call heltable([2,16,32], n3(:,7627), t3x32(:,:,4172))
  call heltable([2,16,32], n3(:,7628), t3x32(:,:,4173))
  call heltable([2,16,32], n3(:,7629), t3x32(:,:,4174))
  call heltable([16,2,32], n3(:,7630), t3x32(:,:,4175))
  call heltable([16,2,32], n3(:,7631), t3x32(:,:,4176))
  call heltable([16,2,32], n3(:,7632), t3x32(:,:,4177))
  call heltable([16,2,32], n3(:,7633), t3x32(:,:,4178))
  call heltable([2,16,32], n3(:,7634), t3x32(:,:,4179))
  call heltable([2,16,32], n3(:,7635), t3x32(:,:,4180))
  call heltable([2,16,32], n3(:,7636), t3x32(:,:,4181))
  call heltable([2,16,32], n3(:,7637), t3x32(:,:,4182))
  call heltable([2,16,32], n3(:,7638), t3x32(:,:,4183))
  call heltable([2,16,32], n3(:,7639), t3x32(:,:,4184))
  call heltable([2,16,32], n3(:,7640), t3x32(:,:,4185))
  call heltable([2,16,32], n3(:,7641), t3x32(:,:,4186))
  call heltable([16,2,32], n3(:,7642), t3x32(:,:,4187))
  call heltable([16,2,32], n3(:,7643), t3x32(:,:,4188))
  call heltable([16,2,32], n3(:,7644), t3x32(:,:,4189))
  call heltable([16,2,32], n3(:,7645), t3x32(:,:,4190))
  call heltable([2,16,32], n3(:,7646), t3x32(:,:,4191))
  call heltable([2,16,32], n3(:,7647), t3x32(:,:,4192))
  call heltable([2,16,32], n3(:,7648), t3x32(:,:,4193))
  call heltable([2,16,32], n3(:,7649), t3x32(:,:,4194))
  call heltable([16,2,32], n3(:,7650), t3x32(:,:,4195))
  call heltable([16,2,32], n3(:,7651), t3x32(:,:,4196))
  call heltable([16,2,32], n3(:,7652), t3x32(:,:,4197))
  call heltable([16,2,32], n3(:,7653), t3x32(:,:,4198))
  call heltable([16,2,32], n3(:,7654), t3x32(:,:,4199))
  call heltable([16,2,32], n3(:,7655), t3x32(:,:,4200))
  call heltable([16,2,32], n3(:,7656), t3x32(:,:,4201))
  call heltable([16,2,32], n3(:,7657), t3x32(:,:,4202))
  call heltable([2,16,32], n3(:,7658), t3x32(:,:,4203))
  call heltable([2,16,32], n3(:,7659), t3x32(:,:,4204))
  call heltable([2,16,32], n3(:,7660), t3x32(:,:,4205))
  call heltable([2,16,32], n3(:,7661), t3x32(:,:,4206))
  call heltable([16,2,32], n3(:,7662), t3x32(:,:,4207))
  call heltable([16,2,32], n3(:,7663), t3x32(:,:,4208))
  call heltable([16,2,32], n3(:,7664), t3x32(:,:,4209))
  call heltable([16,2,32], n3(:,7665), t3x32(:,:,4210))
  call heltable([2,16,32], n3(:,7666), t3x32(:,:,4211))
  call heltable([2,16,32], n3(:,7667), t3x32(:,:,4212))
  call heltable([2,16,32], n3(:,7668), t3x32(:,:,4213))
  call heltable([2,16,32], n3(:,7669), t3x32(:,:,4214))
  call heltable([2,16,32], n3(:,7670), t3x32(:,:,4215))
  call heltable([2,16,32], n3(:,7671), t3x32(:,:,4216))
  call heltable([2,16,32], n3(:,7672), t3x32(:,:,4217))
  call heltable([2,16,32], n3(:,7673), t3x32(:,:,4218))
  call heltable([16,2,32], n3(:,7674), t3x32(:,:,4219))
  call heltable([16,2,32], n3(:,7675), t3x32(:,:,4220))
  call heltable([16,2,32], n3(:,7676), t3x32(:,:,4221))
  call heltable([16,2,32], n3(:,7677), t3x32(:,:,4222))
  call heltable([2,16,32], n3(:,7678), t3x32(:,:,4223))
  call heltable([2,16,32], n3(:,7679), t3x32(:,:,4224))
  call heltable([2,16,32], n3(:,7680), t3x32(:,:,4225))
  call heltable([2,16,32], n3(:,7681), t3x32(:,:,4226))
  call heltable([16,2,32], n3(:,7682), t3x32(:,:,4227))
  call heltable([16,2,32], n3(:,7683), t3x32(:,:,4228))
  call heltable([16,2,32], n3(:,7684), t3x32(:,:,4229))
  call heltable([16,2,32], n3(:,7685), t3x32(:,:,4230))
  call heltable([16,2,32], n3(:,7686), t3x32(:,:,4231))
  call heltable([16,2,32], n3(:,7687), t3x32(:,:,4232))
  call heltable([16,2,32], n3(:,7688), t3x32(:,:,4233))
  call heltable([16,2,32], n3(:,7689), t3x32(:,:,4234))
  call heltable([16,2,32], n3(:,7690), t3x32(:,:,4235))
  call heltable([16,2,32], n3(:,7691), t3x32(:,:,4236))
  call heltable([16,2,32], n3(:,7692), t3x32(:,:,4237))
  call heltable([16,2,32], n3(:,7693), t3x32(:,:,4238))
  call heltable([2,16,32], n3(:,7694), t3x32(:,:,4239))
  call heltable([2,16,32], n3(:,7695), t3x32(:,:,4240))
  call heltable([2,16,32], n3(:,7696), t3x32(:,:,4241))
  call heltable([2,16,32], n3(:,7697), t3x32(:,:,4242))
  call heltable([2,16,32], n3(:,7698), t3x32(:,:,4243))
  call heltable([2,16,32], n3(:,7699), t3x32(:,:,4244))
  call heltable([2,16,32], n3(:,7700), t3x32(:,:,4245))
  call heltable([2,16,32], n3(:,7701), t3x32(:,:,4246))
  call heltable([2,16,32], n3(:,7702), t3x32(:,:,4247))
  call heltable([2,16,32], n3(:,7703), t3x32(:,:,4248))
  call heltable([2,16,32], n3(:,7704), t3x32(:,:,4249))
  call heltable([2,16,32], n3(:,7705), t3x32(:,:,4250))
  call heltable([16,2,32], n3(:,7706), t3x32(:,:,4251))
  call heltable([16,2,32], n3(:,7707), t3x32(:,:,4252))
  call heltable([16,2,32], n3(:,7708), t3x32(:,:,4253))
  call heltable([16,2,32], n3(:,7709), t3x32(:,:,4254))
  call heltable([2,16,32], n3(:,7710), t3x32(:,:,4255))
  call heltable([2,16,32], n3(:,7711), t3x32(:,:,4256))
  call heltable([2,16,32], n3(:,7712), t3x32(:,:,4257))
  call heltable([2,16,32], n3(:,7713), t3x32(:,:,4258))
  call heltable([16,2,32], n3(:,7714), t3x32(:,:,4259))
  call heltable([16,2,32], n3(:,7715), t3x32(:,:,4260))
  call heltable([16,2,32], n3(:,7716), t3x32(:,:,4261))
  call heltable([16,2,32], n3(:,7717), t3x32(:,:,4262))
  call heltable([16,2,32], n3(:,7718), t3x32(:,:,4263))
  call heltable([16,2,32], n3(:,7719), t3x32(:,:,4264))
  call heltable([16,2,32], n3(:,7720), t3x32(:,:,4265))
  call heltable([16,2,32], n3(:,7721), t3x32(:,:,4266))
  call heltable([16,2,32], n3(:,7722), t3x32(:,:,4267))
  call heltable([16,2,32], n3(:,7723), t3x32(:,:,4268))
  call heltable([16,2,32], n3(:,7724), t3x32(:,:,4269))
  call heltable([16,2,32], n3(:,7725), t3x32(:,:,4270))
  call heltable([2,16,32], n3(:,7726), t3x32(:,:,4271))
  call heltable([2,16,32], n3(:,7727), t3x32(:,:,4272))
  call heltable([2,16,32], n3(:,7728), t3x32(:,:,4273))
  call heltable([2,16,32], n3(:,7729), t3x32(:,:,4274))
  call heltable([2,16,32], n3(:,7730), t3x32(:,:,4275))
  call heltable([2,16,32], n3(:,7731), t3x32(:,:,4276))
  call heltable([2,16,32], n3(:,7732), t3x32(:,:,4277))
  call heltable([2,16,32], n3(:,7733), t3x32(:,:,4278))
  call heltable([2,16,32], n3(:,7734), t3x32(:,:,4279))
  call heltable([2,16,32], n3(:,7735), t3x32(:,:,4280))
  call heltable([2,16,32], n3(:,7736), t3x32(:,:,4281))
  call heltable([2,16,32], n3(:,7737), t3x32(:,:,4282))
  call heltable([16,2,32], n3(:,7738), t3x32(:,:,4283))
  call heltable([16,2,32], n3(:,7739), t3x32(:,:,4284))
  call heltable([16,2,32], n3(:,7740), t3x32(:,:,4285))
  call heltable([16,2,32], n3(:,7741), t3x32(:,:,4286))
  call heltable([2,16,32], n3(:,7742), t3x32(:,:,4287))
  call heltable([2,16,32], n3(:,7743), t3x32(:,:,4288))
  call heltable([2,16,32], n3(:,7744), t3x32(:,:,4289))
  call heltable([2,16,32], n3(:,7745), t3x32(:,:,4290))
  call heltable([16,2,32], n3(:,7746), t3x32(:,:,4291))
  call heltable([16,2,32], n3(:,7747), t3x32(:,:,4292))
  call heltable([16,2,32], n3(:,7748), t3x32(:,:,4293))
  call heltable([16,2,32], n3(:,7749), t3x32(:,:,4294))
  call heltable([16,2,32], n3(:,7750), t3x32(:,:,4295))
  call heltable([16,2,32], n3(:,7751), t3x32(:,:,4296))
  call heltable([16,2,32], n3(:,7752), t3x32(:,:,4297))
  call heltable([16,2,32], n3(:,7753), t3x32(:,:,4298))
  call heltable([16,2,32], n3(:,7754), t3x32(:,:,4299))
  call heltable([16,2,32], n3(:,7755), t3x32(:,:,4300))
  call heltable([16,2,32], n3(:,7756), t3x32(:,:,4301))
  call heltable([16,2,32], n3(:,7757), t3x32(:,:,4302))
  call heltable([2,16,32], n3(:,7758), t3x32(:,:,4303))
  call heltable([2,16,32], n3(:,7759), t3x32(:,:,4304))
  call heltable([2,16,32], n3(:,7760), t3x32(:,:,4305))
  call heltable([2,16,32], n3(:,7761), t3x32(:,:,4306))
  call heltable([2,16,32], n3(:,7762), t3x32(:,:,4307))
  call heltable([2,16,32], n3(:,7763), t3x32(:,:,4308))
  call heltable([2,16,32], n3(:,7764), t3x32(:,:,4309))
  call heltable([2,16,32], n3(:,7765), t3x32(:,:,4310))
  call heltable([2,16,32], n3(:,7766), t3x32(:,:,4311))
  call heltable([2,16,32], n3(:,7767), t3x32(:,:,4312))
  call heltable([2,16,32], n3(:,7768), t3x32(:,:,4313))
  call heltable([2,16,32], n3(:,7769), t3x32(:,:,4314))
  call heltable([16,2,32], n3(:,7770), t3x32(:,:,4315))
  call heltable([16,2,32], n3(:,7771), t3x32(:,:,4316))
  call heltable([16,2,32], n3(:,7772), t3x32(:,:,4317))
  call heltable([16,2,32], n3(:,7773), t3x32(:,:,4318))
  call heltable([2,16,32], n3(:,7774), t3x32(:,:,4319))
  call heltable([2,16,32], n3(:,7775), t3x32(:,:,4320))
  call heltable([2,16,32], n3(:,7776), t3x32(:,:,4321))
  call heltable([2,16,32], n3(:,7777), t3x32(:,:,4322))
  call heltable([16,2,32], n3(:,7778), t3x32(:,:,4323))
  call heltable([16,2,32], n3(:,7779), t3x32(:,:,4324))
  call heltable([16,2,32], n3(:,7780), t3x32(:,:,4325))
  call heltable([16,2,32], n3(:,7781), t3x32(:,:,4326))
  call heltable([16,2,32], n3(:,7782), t3x32(:,:,4327))
  call heltable([16,2,32], n3(:,7783), t3x32(:,:,4328))
  call heltable([16,2,32], n3(:,7784), t3x32(:,:,4329))
  call heltable([16,2,32], n3(:,7785), t3x32(:,:,4330))
  call heltable([16,2,32], n3(:,7786), t3x32(:,:,4331))
  call heltable([16,2,32], n3(:,7787), t3x32(:,:,4332))
  call heltable([16,2,32], n3(:,7788), t3x32(:,:,4333))
  call heltable([16,2,32], n3(:,7789), t3x32(:,:,4334))
  call heltable([2,16,32], n3(:,7790), t3x32(:,:,4335))
  call heltable([2,16,32], n3(:,7791), t3x32(:,:,4336))
  call heltable([2,16,32], n3(:,7792), t3x32(:,:,4337))
  call heltable([2,16,32], n3(:,7793), t3x32(:,:,4338))
  call heltable([2,16,32], n3(:,7794), t3x32(:,:,4339))
  call heltable([2,16,32], n3(:,7795), t3x32(:,:,4340))
  call heltable([2,16,32], n3(:,7796), t3x32(:,:,4341))
  call heltable([2,16,32], n3(:,7797), t3x32(:,:,4342))
  call heltable([2,16,32], n3(:,7798), t3x32(:,:,4343))
  call heltable([2,16,32], n3(:,7799), t3x32(:,:,4344))
  call heltable([2,16,32], n3(:,7800), t3x32(:,:,4345))
  call heltable([2,16,32], n3(:,7801), t3x32(:,:,4346))
  call heltable([16,2,32], n3(:,7802), t3x32(:,:,4347))
  call heltable([16,2,32], n3(:,7803), t3x32(:,:,4348))
  call heltable([16,2,32], n3(:,7804), t3x32(:,:,4349))
  call heltable([16,2,32], n3(:,7805), t3x32(:,:,4350))
  call heltable([2,16,32], n3(:,7806), t3x32(:,:,4351))
  call heltable([2,16,32], n3(:,7807), t3x32(:,:,4352))
  call heltable([2,16,32], n3(:,7808), t3x32(:,:,4353))
  call heltable([2,16,32], n3(:,7809), t3x32(:,:,4354))
  call heltable([16,2,32], n3(:,7810), t3x32(:,:,4355))
  call heltable([16,2,32], n3(:,7811), t3x32(:,:,4356))
  call heltable([16,2,32], n3(:,7812), t3x32(:,:,4357))
  call heltable([16,2,32], n3(:,7813), t3x32(:,:,4358))
  call heltable([16,2,32], n3(:,7814), t3x32(:,:,4359))
  call heltable([16,2,32], n3(:,7815), t3x32(:,:,4360))
  call heltable([16,2,32], n3(:,7816), t3x32(:,:,4361))
  call heltable([16,2,32], n3(:,7817), t3x32(:,:,4362))
  call heltable([16,2,32], n3(:,7818), t3x32(:,:,4363))
  call heltable([16,2,32], n3(:,7819), t3x32(:,:,4364))
  call heltable([16,2,32], n3(:,7820), t3x32(:,:,4365))
  call heltable([16,2,32], n3(:,7821), t3x32(:,:,4366))
  call heltable([2,16,32], n3(:,7822), t3x32(:,:,4367))
  call heltable([2,16,32], n3(:,7823), t3x32(:,:,4368))
  call heltable([2,16,32], n3(:,7824), t3x32(:,:,4369))
  call heltable([2,16,32], n3(:,7825), t3x32(:,:,4370))
  call heltable([2,16,32], n3(:,7826), t3x32(:,:,4371))
  call heltable([2,16,32], n3(:,7827), t3x32(:,:,4372))
  call heltable([2,16,32], n3(:,7828), t3x32(:,:,4373))
  call heltable([2,16,32], n3(:,7829), t3x32(:,:,4374))
  call heltable([2,16,32], n3(:,7830), t3x32(:,:,4375))
  call heltable([2,16,32], n3(:,7831), t3x32(:,:,4376))
  call heltable([2,16,32], n3(:,7832), t3x32(:,:,4377))
  call heltable([2,16,32], n3(:,7833), t3x32(:,:,4378))
  call heltable([16,2,32], n3(:,7834), t3x32(:,:,4379))
  call heltable([16,2,32], n3(:,7835), t3x32(:,:,4380))
  call heltable([16,2,32], n3(:,7836), t3x32(:,:,4381))
  call heltable([16,2,32], n3(:,7837), t3x32(:,:,4382))
  call heltable([2,16,32], n3(:,7838), t3x32(:,:,4383))
  call heltable([2,16,32], n3(:,7839), t3x32(:,:,4384))
  call heltable([2,16,32], n3(:,7840), t3x32(:,:,4385))
  call heltable([2,16,32], n3(:,7841), t3x32(:,:,4386))
  call heltable([16,2,32], n3(:,7842), t3x32(:,:,4387))
  call heltable([16,2,32], n3(:,7843), t3x32(:,:,4388))
  call heltable([16,2,32], n3(:,7844), t3x32(:,:,4389))
  call heltable([16,2,32], n3(:,7845), t3x32(:,:,4390))
  call heltable([16,2,32], n3(:,7846), t3x32(:,:,4391))
  call heltable([16,2,32], n3(:,7847), t3x32(:,:,4392))
  call heltable([16,2,32], n3(:,7848), t3x32(:,:,4393))
  call heltable([16,2,32], n3(:,7849), t3x32(:,:,4394))
  call heltable([16,2,32], n3(:,7850), t3x32(:,:,4395))
  call heltable([16,2,32], n3(:,7851), t3x32(:,:,4396))
  call heltable([16,2,32], n3(:,7852), t3x32(:,:,4397))
  call heltable([16,2,32], n3(:,7853), t3x32(:,:,4398))
  call heltable([2,16,32], n3(:,7854), t3x32(:,:,4399))
  call heltable([2,16,32], n3(:,7855), t3x32(:,:,4400))
  call heltable([2,16,32], n3(:,7856), t3x32(:,:,4401))
  call heltable([2,16,32], n3(:,7857), t3x32(:,:,4402))
  call heltable([2,16,32], n3(:,7858), t3x32(:,:,4403))
  call heltable([2,16,32], n3(:,7859), t3x32(:,:,4404))
  call heltable([2,16,32], n3(:,7860), t3x32(:,:,4405))
  call heltable([2,16,32], n3(:,7861), t3x32(:,:,4406))
  call heltable([2,16,32], n3(:,7862), t3x32(:,:,4407))
  call heltable([2,16,32], n3(:,7863), t3x32(:,:,4408))
  call heltable([2,16,32], n3(:,7864), t3x32(:,:,4409))
  call heltable([2,16,32], n3(:,7865), t3x32(:,:,4410))
  call heltable([16,2,32], n3(:,7866), t3x32(:,:,4411))
  call heltable([16,2,32], n3(:,7867), t3x32(:,:,4412))
  call heltable([16,2,32], n3(:,7868), t3x32(:,:,4413))
  call heltable([16,2,32], n3(:,7869), t3x32(:,:,4414))
  call heltable([2,16,32], n3(:,7870), t3x32(:,:,4415))
  call heltable([2,16,32], n3(:,7871), t3x32(:,:,4416))
  call heltable([2,16,32], n3(:,7872), t3x32(:,:,4417))
  call heltable([2,16,32], n3(:,7873), t3x32(:,:,4418))
  call heltable([16,2,32], n3(:,7874), t3x32(:,:,4419))
  call heltable([16,2,32], n3(:,7875), t3x32(:,:,4420))
  call heltable([16,2,32], n3(:,7876), t3x32(:,:,4421))
  call heltable([16,2,32], n3(:,7877), t3x32(:,:,4422))
  call heltable([16,2,32], n3(:,7878), t3x32(:,:,4423))
  call heltable([16,2,32], n3(:,7879), t3x32(:,:,4424))
  call heltable([16,2,32], n3(:,7880), t3x32(:,:,4425))
  call heltable([16,2,32], n3(:,7881), t3x32(:,:,4426))
  call heltable([16,2,32], n3(:,7882), t3x32(:,:,4427))
  call heltable([16,2,32], n3(:,7883), t3x32(:,:,4428))
  call heltable([16,2,32], n3(:,7884), t3x32(:,:,4429))
  call heltable([16,2,32], n3(:,7885), t3x32(:,:,4430))
  call heltable([2,16,32], n3(:,7886), t3x32(:,:,4431))
  call heltable([2,16,32], n3(:,7887), t3x32(:,:,4432))
  call heltable([2,16,32], n3(:,7888), t3x32(:,:,4433))
  call heltable([2,16,32], n3(:,7889), t3x32(:,:,4434))
  call heltable([2,16,32], n3(:,7890), t3x32(:,:,4435))
  call heltable([2,16,32], n3(:,7891), t3x32(:,:,4436))
  call heltable([2,16,32], n3(:,7892), t3x32(:,:,4437))
  call heltable([2,16,32], n3(:,7893), t3x32(:,:,4438))
  call heltable([2,16,32], n3(:,7894), t3x32(:,:,4439))
  call heltable([2,16,32], n3(:,7895), t3x32(:,:,4440))
  call heltable([2,16,32], n3(:,7896), t3x32(:,:,4441))
  call heltable([2,16,32], n3(:,7897), t3x32(:,:,4442))
  call heltable([16,2,32], n3(:,7898), t3x32(:,:,4443))
  call heltable([16,2,32], n3(:,7899), t3x32(:,:,4444))
  call heltable([16,2,32], n3(:,7900), t3x32(:,:,4445))
  call heltable([16,2,32], n3(:,7901), t3x32(:,:,4446))
  call heltable([2,16,32], n3(:,7902), t3x32(:,:,4447))
  call heltable([2,16,32], n3(:,7903), t3x32(:,:,4448))
  call heltable([2,16,32], n3(:,7904), t3x32(:,:,4449))
  call heltable([2,16,32], n3(:,7905), t3x32(:,:,4450))
  call heltable([16,2,32], n3(:,7906), t3x32(:,:,4451))
  call heltable([16,2,32], n3(:,7907), t3x32(:,:,4452))
  call heltable([16,2,32], n3(:,7908), t3x32(:,:,4453))
  call heltable([16,2,32], n3(:,7909), t3x32(:,:,4454))
  call heltable([16,2,32], n3(:,7910), t3x32(:,:,4455))
  call heltable([16,2,32], n3(:,7911), t3x32(:,:,4456))
  call heltable([16,2,32], n3(:,7912), t3x32(:,:,4457))
  call heltable([16,2,32], n3(:,7913), t3x32(:,:,4458))
  call heltable([16,2,32], n3(:,7914), t3x32(:,:,4459))
  call heltable([16,2,32], n3(:,7915), t3x32(:,:,4460))
  call heltable([16,2,32], n3(:,7916), t3x32(:,:,4461))
  call heltable([16,2,32], n3(:,7917), t3x32(:,:,4462))
  call heltable([2,16,32], n3(:,7918), t3x32(:,:,4463))
  call heltable([2,16,32], n3(:,7919), t3x32(:,:,4464))
  call heltable([2,16,32], n3(:,7920), t3x32(:,:,4465))
  call heltable([2,16,32], n3(:,7921), t3x32(:,:,4466))
  call heltable([2,16,32], n3(:,7922), t3x32(:,:,4467))
  call heltable([2,16,32], n3(:,7923), t3x32(:,:,4468))
  call heltable([2,16,32], n3(:,7924), t3x32(:,:,4469))
  call heltable([2,16,32], n3(:,7925), t3x32(:,:,4470))
  call heltable([16,8,128], n3(:,7926), t3x128(:,:,1))
  call heltable([8,16,128], n3(:,7927), t3x128(:,:,2))
  call heltable([16,8,128], n3(:,7928), t3x128(:,:,3))
  call heltable([16,8,128], n3(:,7929), t3x128(:,:,4))
  call heltable([8,16,128], n3(:,7930), t3x128(:,:,5))
  call heltable([8,16,128], n3(:,7931), t3x128(:,:,6))
  call heltable([8,16,128], n3(:,7932), t3x128(:,:,7))
  call heltable([8,16,128], n3(:,7933), t3x128(:,:,8))
  call heltable([16,8,128], n3(:,7934), t3x128(:,:,9))
  call heltable([16,8,128], n3(:,7935), t3x128(:,:,10))
  call heltable([16,8,128], n3(:,7936), t3x128(:,:,11))
  call heltable([16,8,128], n3(:,7937), t3x128(:,:,12))
  call heltable([16,8,128], n3(:,7938), t3x128(:,:,13))
  call heltable([16,8,128], n3(:,7939), t3x128(:,:,14))
  call heltable([16,8,128], n3(:,7940), t3x128(:,:,15))
  call heltable([16,8,128], n3(:,7941), t3x128(:,:,16))
  call heltable([16,8,128], n3(:,7942), t3x128(:,:,17))
  call heltable([16,8,128], n3(:,7943), t3x128(:,:,18))
  call heltable([8,16,128], n3(:,7944), t3x128(:,:,19))
  call heltable([8,16,128], n3(:,7945), t3x128(:,:,20))
  call heltable([16,8,128], n3(:,7946), t3x128(:,:,21))
  call heltable([16,8,128], n3(:,7947), t3x128(:,:,22))
  call heltable([16,8,128], n3(:,7948), t3x128(:,:,23))
  call heltable([16,8,128], n3(:,7949), t3x128(:,:,24))
  call heltable([8,16,128], n3(:,7950), t3x128(:,:,25))
  call heltable([8,16,128], n3(:,7951), t3x128(:,:,26))
  call heltable([8,16,128], n3(:,7952), t3x128(:,:,27))
  call heltable([8,16,128], n3(:,7953), t3x128(:,:,28))
  call heltable([8,16,128], n3(:,7954), t3x128(:,:,29))
  call heltable([8,16,128], n3(:,7955), t3x128(:,:,30))
  call heltable([8,16,128], n3(:,7956), t3x128(:,:,31))
  call heltable([8,16,128], n3(:,7957), t3x128(:,:,32))
  call heltable([8,16,128], n3(:,7958), t3x128(:,:,33))
  call heltable([8,16,128], n3(:,7959), t3x128(:,:,34))
  call heltable([8,16,128], n3(:,7960), t3x128(:,:,35))
  call heltable([8,16,128], n3(:,7961), t3x128(:,:,36))
  call heltable([8,16,128], n3(:,7962), t3x128(:,:,37))
  call heltable([8,16,128], n3(:,7963), t3x128(:,:,38))
  call heltable([8,16,128], n3(:,7964), t3x128(:,:,39))
  call heltable([8,16,128], n3(:,7965), t3x128(:,:,40))
  call heltable([8,16,128], n3(:,7966), t3x128(:,:,41))
  call heltable([8,16,128], n3(:,7967), t3x128(:,:,42))
  call heltable([8,16,128], n3(:,7968), t3x128(:,:,43))
  call heltable([8,16,128], n3(:,7969), t3x128(:,:,44))
  call heltable([8,16,128], n3(:,7970), t3x128(:,:,45))
  call heltable([16,8,128], n3(:,7971), t3x128(:,:,46))
  call heltable([8,16,128], n3(:,7972), t3x128(:,:,47))
  call heltable([16,8,128], n3(:,7973), t3x128(:,:,48))
  call heltable([16,8,128], n3(:,7974), t3x128(:,:,49))
  call heltable([8,16,128], n3(:,7975), t3x128(:,:,50))
  call heltable([8,16,128], n3(:,7976), t3x128(:,:,51))
  call heltable([8,16,128], n3(:,7977), t3x128(:,:,52))
  call heltable([8,16,128], n3(:,7978), t3x128(:,:,53))
  call heltable([16,8,128], n3(:,7979), t3x128(:,:,54))
  call heltable([16,8,128], n3(:,7980), t3x128(:,:,55))
  call heltable([16,8,128], n3(:,7981), t3x128(:,:,56))
  call heltable([16,8,128], n3(:,7982), t3x128(:,:,57))
  call heltable([16,8,128], n3(:,7983), t3x128(:,:,58))
  call heltable([16,8,128], n3(:,7984), t3x128(:,:,59))
  call heltable([16,8,128], n3(:,7985), t3x128(:,:,60))
  call heltable([16,8,128], n3(:,7986), t3x128(:,:,61))
  call heltable([16,8,128], n3(:,7987), t3x128(:,:,62))
  call heltable([16,8,128], n3(:,7988), t3x128(:,:,63))
  call heltable([8,16,128], n3(:,7989), t3x128(:,:,64))
  call heltable([8,16,128], n3(:,7990), t3x128(:,:,65))
  call heltable([16,8,128], n3(:,7991), t3x128(:,:,66))
  call heltable([16,8,128], n3(:,7992), t3x128(:,:,67))
  call heltable([16,8,128], n3(:,7993), t3x128(:,:,68))
  call heltable([16,8,128], n3(:,7994), t3x128(:,:,69))
  call heltable([8,16,128], n3(:,7995), t3x128(:,:,70))
  call heltable([8,16,128], n3(:,7996), t3x128(:,:,71))
  call heltable([8,16,128], n3(:,7997), t3x128(:,:,72))
  call heltable([8,16,128], n3(:,7998), t3x128(:,:,73))
  call heltable([8,16,128], n3(:,7999), t3x128(:,:,74))
  call heltable([8,16,128], n3(:,8000), t3x128(:,:,75))
  call heltable([8,16,128], n3(:,8001), t3x128(:,:,76))
  call heltable([8,16,128], n3(:,8002), t3x128(:,:,77))
  call heltable([16,8,128], n3(:,8003), t3x128(:,:,78))
  call heltable([16,8,128], n3(:,8004), t3x128(:,:,79))
  call heltable([16,8,128], n3(:,8005), t3x128(:,:,80))
  call heltable([16,8,128], n3(:,8006), t3x128(:,:,81))
  call heltable([16,8,128], n3(:,8007), t3x128(:,:,82))
  call heltable([16,8,128], n3(:,8008), t3x128(:,:,83))
  call heltable([16,8,128], n3(:,8009), t3x128(:,:,84))
  call heltable([16,8,128], n3(:,8010), t3x128(:,:,85))
  call heltable([16,8,128], n3(:,8011), t3x128(:,:,86))
  call heltable([16,8,128], n3(:,8012), t3x128(:,:,87))
  call heltable([16,8,128], n3(:,8013), t3x128(:,:,88))
  call heltable([16,8,128], n3(:,8014), t3x128(:,:,89))
  call heltable([16,8,128], n3(:,8015), t3x128(:,:,90))
  call heltable([8,16,128], n3(:,8016), t3x128(:,:,91))
  call heltable([8,16,128], n3(:,8017), t3x128(:,:,92))
  call heltable([8,16,128], n3(:,8018), t3x128(:,:,93))
  call heltable([8,16,128], n3(:,8019), t3x128(:,:,94))
  call heltable([8,16,128], n3(:,8020), t3x128(:,:,95))
  call heltable([8,16,128], n3(:,8021), t3x128(:,:,96))
  call heltable([8,16,128], n3(:,8022), t3x128(:,:,97))
  call heltable([8,16,128], n3(:,8023), t3x128(:,:,98))
  call heltable([8,16,128], n3(:,8024), t3x128(:,:,99))
  call heltable([8,16,128], n3(:,8025), t3x128(:,:,100))
  call heltable([8,16,128], n3(:,8026), t3x128(:,:,101))
  call heltable([8,16,128], n3(:,8027), t3x128(:,:,102))
  call heltable([8,16,128], n3(:,8028), t3x128(:,:,103))
  call heltable([8,16,128], n3(:,8029), t3x128(:,:,104))
  call heltable([8,16,128], n3(:,8030), t3x128(:,:,105))
  call heltable([8,16,128], n3(:,8031), t3x128(:,:,106))
  call heltable([8,16,128], n3(:,8032), t3x128(:,:,107))
  call heltable([8,16,128], n3(:,8033), t3x128(:,:,108))
  call heltable([8,16,128], n3(:,8034), t3x128(:,:,109))
  call heltable([8,16,128], n3(:,8035), t3x128(:,:,110))
  call heltable([8,16,128], n3(:,8036), t3x128(:,:,111))
  call heltable([8,16,128], n3(:,8037), t3x128(:,:,112))
  call heltable([8,16,128], n3(:,8038), t3x128(:,:,113))
  call heltable([8,16,128], n3(:,8039), t3x128(:,:,114))
  call heltable([8,16,128], n3(:,8040), t3x128(:,:,115))
  call heltable([8,16,128], n3(:,8041), t3x128(:,:,116))
  call heltable([8,16,128], n3(:,8042), t3x128(:,:,117))
  call heltable([8,16,128], n3(:,8043), t3x128(:,:,118))
  call heltable([8,16,128], n3(:,8044), t3x128(:,:,119))
  call heltable([8,16,128], n3(:,8045), t3x128(:,:,120))
  call heltable([8,16,128], n3(:,8046), t3x128(:,:,121))
  call heltable([8,16,128], n3(:,8047), t3x128(:,:,122))
  call heltable([16,8,128], n3(:,8048), t3x128(:,:,123))
  call heltable([8,16,128], n3(:,8049), t3x128(:,:,124))
  call heltable([16,8,128], n3(:,8050), t3x128(:,:,125))
  call heltable([16,8,128], n3(:,8051), t3x128(:,:,126))
  call heltable([8,16,128], n3(:,8052), t3x128(:,:,127))
  call heltable([8,16,128], n3(:,8053), t3x128(:,:,128))
  call heltable([8,16,128], n3(:,8054), t3x128(:,:,129))
  call heltable([8,16,128], n3(:,8055), t3x128(:,:,130))
  call heltable([16,8,128], n3(:,8056), t3x128(:,:,131))
  call heltable([16,8,128], n3(:,8057), t3x128(:,:,132))
  call heltable([16,8,128], n3(:,8058), t3x128(:,:,133))
  call heltable([16,8,128], n3(:,8059), t3x128(:,:,134))
  call heltable([16,8,128], n3(:,8060), t3x128(:,:,135))
  call heltable([16,8,128], n3(:,8061), t3x128(:,:,136))
  call heltable([16,8,128], n3(:,8062), t3x128(:,:,137))
  call heltable([16,8,128], n3(:,8063), t3x128(:,:,138))
  call heltable([8,16,128], n3(:,8064), t3x128(:,:,139))
  call heltable([8,16,128], n3(:,8065), t3x128(:,:,140))
  call heltable([8,16,128], n3(:,8066), t3x128(:,:,141))
  call heltable([8,16,128], n3(:,8067), t3x128(:,:,142))
  call heltable([8,16,128], n3(:,8068), t3x128(:,:,143))
  call heltable([8,16,128], n3(:,8069), t3x128(:,:,144))
  call heltable([8,16,128], n3(:,8070), t3x128(:,:,145))
  call heltable([8,16,128], n3(:,8071), t3x128(:,:,146))
  call heltable([8,16,128], n3(:,8072), t3x128(:,:,147))
  call heltable([8,16,128], n3(:,8073), t3x128(:,:,148))
  call heltable([8,16,128], n3(:,8074), t3x128(:,:,149))
  call heltable([8,16,128], n3(:,8075), t3x128(:,:,150))
  call heltable([8,16,128], n3(:,8076), t3x128(:,:,151))
  call heltable([16,8,128], n3(:,8077), t3x128(:,:,152))
  call heltable([16,8,128], n3(:,8078), t3x128(:,:,153))
  call heltable([8,16,128], n3(:,8079), t3x128(:,:,154))
  call heltable([8,16,128], n3(:,8080), t3x128(:,:,155))
  call heltable([16,8,128], n3(:,8081), t3x128(:,:,156))
  call heltable([16,8,128], n3(:,8082), t3x128(:,:,157))
  call heltable([16,8,128], n3(:,8083), t3x128(:,:,158))
  call heltable([16,8,128], n3(:,8084), t3x128(:,:,159))
  call heltable([8,16,128], n3(:,8085), t3x128(:,:,160))
  call heltable([8,16,128], n3(:,8086), t3x128(:,:,161))
  call heltable([8,16,128], n3(:,8087), t3x128(:,:,162))
  call heltable([8,16,128], n3(:,8088), t3x128(:,:,163))
  call heltable([8,16,128], n3(:,8089), t3x128(:,:,164))
  call heltable([8,16,128], n3(:,8090), t3x128(:,:,165))
  call heltable([8,16,128], n3(:,8091), t3x128(:,:,166))
  call heltable([8,16,128], n3(:,8092), t3x128(:,:,167))
  call heltable([16,8,128], n3(:,8093), t3x128(:,:,168))
  call heltable([8,16,128], n3(:,8094), t3x128(:,:,169))
  call heltable([16,8,128], n3(:,8095), t3x128(:,:,170))
  call heltable([16,8,128], n3(:,8096), t3x128(:,:,171))
  call heltable([8,16,128], n3(:,8097), t3x128(:,:,172))
  call heltable([8,16,128], n3(:,8098), t3x128(:,:,173))
  call heltable([8,16,128], n3(:,8099), t3x128(:,:,174))
  call heltable([8,16,128], n3(:,8100), t3x128(:,:,175))
  call heltable([16,8,128], n3(:,8101), t3x128(:,:,176))
  call heltable([16,8,128], n3(:,8102), t3x128(:,:,177))
  call heltable([16,8,128], n3(:,8103), t3x128(:,:,178))
  call heltable([16,8,128], n3(:,8104), t3x128(:,:,179))
  call heltable([16,8,128], n3(:,8105), t3x128(:,:,180))
  call heltable([16,8,128], n3(:,8106), t3x128(:,:,181))
  call heltable([16,8,128], n3(:,8107), t3x128(:,:,182))
  call heltable([16,8,128], n3(:,8108), t3x128(:,:,183))
  call heltable([16,8,128], n3(:,8109), t3x128(:,:,184))
  call heltable([16,8,128], n3(:,8110), t3x128(:,:,185))
  call heltable([16,8,128], n3(:,8111), t3x128(:,:,186))
  call heltable([16,8,128], n3(:,8112), t3x128(:,:,187))
  call heltable([16,8,128], n3(:,8113), t3x128(:,:,188))
  call heltable([16,8,128], n3(:,8114), t3x128(:,:,189))
  call heltable([16,8,128], n3(:,8115), t3x128(:,:,190))
  call heltable([16,8,128], n3(:,8116), t3x128(:,:,191))
  call heltable([16,8,128], n3(:,8117), t3x128(:,:,192))
  call heltable([16,8,128], n3(:,8118), t3x128(:,:,193))
  call heltable([16,8,128], n3(:,8119), t3x128(:,:,194))
  call heltable([16,8,128], n3(:,8120), t3x128(:,:,195))
  call heltable([16,8,128], n3(:,8121), t3x128(:,:,196))
  call heltable([16,8,128], n3(:,8122), t3x128(:,:,197))
  call heltable([16,8,128], n3(:,8123), t3x128(:,:,198))
  call heltable([8,16,128], n3(:,8124), t3x128(:,:,199))
  call heltable([8,16,128], n3(:,8125), t3x128(:,:,200))
  call heltable([16,8,128], n3(:,8126), t3x128(:,:,201))
  call heltable([16,8,128], n3(:,8127), t3x128(:,:,202))
  call heltable([16,8,128], n3(:,8128), t3x128(:,:,203))
  call heltable([16,8,128], n3(:,8129), t3x128(:,:,204))
  call heltable([8,16,128], n3(:,8130), t3x128(:,:,205))
  call heltable([8,16,128], n3(:,8131), t3x128(:,:,206))
  call heltable([8,16,128], n3(:,8132), t3x128(:,:,207))
  call heltable([8,16,128], n3(:,8133), t3x128(:,:,208))
  call heltable([8,16,128], n3(:,8134), t3x128(:,:,209))
  call heltable([8,16,128], n3(:,8135), t3x128(:,:,210))
  call heltable([8,16,128], n3(:,8136), t3x128(:,:,211))
  call heltable([8,16,128], n3(:,8137), t3x128(:,:,212))
  call heltable([8,16,128], n3(:,8138), t3x128(:,:,213))
  call heltable([8,16,128], n3(:,8139), t3x128(:,:,214))
  call heltable([8,16,128], n3(:,8140), t3x128(:,:,215))
  call heltable([8,16,128], n3(:,8141), t3x128(:,:,216))
  call heltable([8,16,128], n3(:,8142), t3x128(:,:,217))
  call heltable([8,16,128], n3(:,8143), t3x128(:,:,218))
  call heltable([8,16,128], n3(:,8144), t3x128(:,:,219))
  call heltable([8,16,128], n3(:,8145), t3x128(:,:,220))
  call heltable([8,16,128], n3(:,8146), t3x128(:,:,221))
  call heltable([8,16,128], n3(:,8147), t3x128(:,:,222))
  call heltable([8,16,128], n3(:,8148), t3x128(:,:,223))
  call heltable([8,16,128], n3(:,8149), t3x128(:,:,224))
  call heltable([8,16,128], n3(:,8150), t3x128(:,:,225))
  call heltable([8,16,128], n3(:,8151), t3x128(:,:,226))
  call heltable([8,16,128], n3(:,8152), t3x128(:,:,227))
  call heltable([8,16,128], n3(:,8153), t3x128(:,:,228))
  call heltable([8,16,128], n3(:,8154), t3x128(:,:,229))
  call heltable([8,16,128], n3(:,8155), t3x128(:,:,230))
  call heltable([8,16,128], n3(:,8156), t3x128(:,:,231))
  call heltable([8,16,128], n3(:,8157), t3x128(:,:,232))
  call heltable([8,16,128], n3(:,8158), t3x128(:,:,233))
  call heltable([8,16,128], n3(:,8159), t3x128(:,:,234))
  call heltable([8,16,128], n3(:,8160), t3x128(:,:,235))
  call heltable([8,16,128], n3(:,8161), t3x128(:,:,236))
  call heltable([8,16,128], n3(:,8162), t3x128(:,:,237))
  call heltable([8,16,128], n3(:,8163), t3x128(:,:,238))
  call heltable([8,16,128], n3(:,8164), t3x128(:,:,239))
  call heltable([8,16,128], n3(:,8165), t3x128(:,:,240))
  call heltable([8,16,128], n3(:,8166), t3x128(:,:,241))
  call heltable([8,16,128], n3(:,8167), t3x128(:,:,242))
  call heltable([8,16,128], n3(:,8168), t3x128(:,:,243))
  call heltable([8,16,128], n3(:,8169), t3x128(:,:,244))
  call heltable([8,16,128], n3(:,8170), t3x128(:,:,245))
  call heltable([8,16,128], n3(:,8171), t3x128(:,:,246))
  call heltable([8,16,128], n3(:,8172), t3x128(:,:,247))
  call heltable([8,16,128], n3(:,8173), t3x128(:,:,248))
  call heltable([8,16,128], n3(:,8174), t3x128(:,:,249))
  call heltable([8,16,128], n3(:,8175), t3x128(:,:,250))
  call heltable([8,16,128], n3(:,8176), t3x128(:,:,251))
  call heltable([8,16,128], n3(:,8177), t3x128(:,:,252))
  call heltable([8,16,128], n3(:,8178), t3x128(:,:,253))
  call heltable([8,16,128], n3(:,8179), t3x128(:,:,254))
  call heltable([8,16,128], n3(:,8180), t3x128(:,:,255))
  call heltable([8,16,128], n3(:,8181), t3x128(:,:,256))
  call heltable([8,16,128], n3(:,8182), t3x128(:,:,257))
  call heltable([8,16,128], n3(:,8183), t3x128(:,:,258))
  call heltable([8,16,128], n3(:,8184), t3x128(:,:,259))
  call heltable([8,16,128], n3(:,8185), t3x128(:,:,260))
  call heltable([8,16,128], n3(:,8186), t3x128(:,:,261))
  call heltable([8,16,128], n3(:,8187), t3x128(:,:,262))
  call heltable([8,16,128], n3(:,8188), t3x128(:,:,263))
  call heltable([8,16,128], n3(:,8189), t3x128(:,:,264))
  call heltable([8,16,128], n3(:,8190), t3x128(:,:,265))
  call heltable([8,16,128], n3(:,8191), t3x128(:,:,266))
  call heltable([8,16,128], n3(:,8192), t3x128(:,:,267))
  call heltable([8,16,128], n3(:,8193), t3x128(:,:,268))
  call heltable([8,16,128], n3(:,8194), t3x128(:,:,269))
  call heltable([8,16,128], n3(:,8195), t3x128(:,:,270))
  call heltable([8,16,128], n3(:,8196), t3x128(:,:,271))
  call heltable([8,16,128], n3(:,8197), t3x128(:,:,272))
  call heltable([8,16,128], n3(:,8198), t3x128(:,:,273))
  call heltable([8,16,128], n3(:,8199), t3x128(:,:,274))
  call heltable([8,16,128], n3(:,8200), t3x128(:,:,275))
  call heltable([8,16,128], n3(:,8201), t3x128(:,:,276))
  call heltable([8,16,128], n3(:,8202), t3x128(:,:,277))
  call heltable([8,16,128], n3(:,8203), t3x128(:,:,278))
  call heltable([8,16,128], n3(:,8204), t3x128(:,:,279))
  call heltable([8,16,128], n3(:,8205), t3x128(:,:,280))
  call heltable([8,16,128], n3(:,8206), t3x128(:,:,281))
  call heltable([8,16,128], n3(:,8207), t3x128(:,:,282))
  call heltable([8,16,128], n3(:,8208), t3x128(:,:,283))
  call heltable([8,16,128], n3(:,8209), t3x128(:,:,284))
  call heltable([8,16,128], n3(:,8210), t3x128(:,:,285))
  call heltable([8,16,128], n3(:,8211), t3x128(:,:,286))
  call heltable([8,16,128], n3(:,8212), t3x128(:,:,287))
  call heltable([8,16,128], n3(:,8213), t3x128(:,:,288))
  call heltable([8,16,128], n3(:,8214), t3x128(:,:,289))
  call heltable([8,16,128], n3(:,8215), t3x128(:,:,290))
  call heltable([8,16,128], n3(:,8216), t3x128(:,:,291))
  call heltable([8,16,128], n3(:,8217), t3x128(:,:,292))
  call heltable([8,16,128], n3(:,8218), t3x128(:,:,293))
  call heltable([8,16,128], n3(:,8219), t3x128(:,:,294))
  call heltable([8,16,128], n3(:,8220), t3x128(:,:,295))
  call heltable([8,16,128], n3(:,8221), t3x128(:,:,296))
  call heltable([8,16,128], n3(:,8222), t3x128(:,:,297))
  call heltable([8,16,128], n3(:,8223), t3x128(:,:,298))
  call heltable([8,16,128], n3(:,8224), t3x128(:,:,299))
  call heltable([8,16,128], n3(:,8225), t3x128(:,:,300))
  call heltable([8,16,128], n3(:,8226), t3x128(:,:,301))
  call heltable([8,16,128], n3(:,8227), t3x128(:,:,302))
  call heltable([8,16,128], n3(:,8228), t3x128(:,:,303))
  call heltable([8,16,128], n3(:,8229), t3x128(:,:,304))
  call heltable([8,16,128], n3(:,8230), t3x128(:,:,305))
  call heltable([8,16,128], n3(:,8231), t3x128(:,:,306))
  call heltable([8,16,128], n3(:,8232), t3x128(:,:,307))
  call heltable([8,16,128], n3(:,8233), t3x128(:,:,308))
  call heltable([8,16,128], n3(:,8234), t3x128(:,:,309))
  call heltable([8,16,128], n3(:,8235), t3x128(:,:,310))
  call heltable([8,16,128], n3(:,8236), t3x128(:,:,311))
  call heltable([8,16,128], n3(:,8237), t3x128(:,:,312))
  call heltable([8,16,128], n3(:,8238), t3x128(:,:,313))
  call heltable([8,16,128], n3(:,8239), t3x128(:,:,314))
  call heltable([8,16,128], n3(:,8240), t3x128(:,:,315))
  call heltable([8,16,128], n3(:,8241), t3x128(:,:,316))
  call heltable([8,16,128], n3(:,8242), t3x128(:,:,317))
  call heltable([8,16,128], n3(:,8243), t3x128(:,:,318))
  call heltable([8,16,128], n3(:,8244), t3x128(:,:,319))
  call heltable([8,16,128], n3(:,8245), t3x128(:,:,320))
  call heltable([8,16,128], n3(:,8246), t3x128(:,:,321))
  call heltable([8,16,128], n3(:,8247), t3x128(:,:,322))
  call heltable([8,16,128], n3(:,8248), t3x128(:,:,323))
  call heltable([8,16,128], n3(:,8249), t3x128(:,:,324))
  call heltable([8,16,128], n3(:,8250), t3x128(:,:,325))
  call heltable([8,16,128], n3(:,8251), t3x128(:,:,326))
  call heltable([8,16,128], n3(:,8252), t3x128(:,:,327))
  call heltable([8,16,128], n3(:,8253), t3x128(:,:,328))
  call heltable([8,16,128], n3(:,8254), t3x128(:,:,329))
  call heltable([8,16,128], n3(:,8255), t3x128(:,:,330))
  call heltable([8,16,128], n3(:,8256), t3x128(:,:,331))
  call heltable([8,16,128], n3(:,8257), t3x128(:,:,332))
  call heltable([8,16,128], n3(:,8258), t3x128(:,:,333))
  call heltable([8,16,128], n3(:,8259), t3x128(:,:,334))
  call heltable([8,16,128], n3(:,8260), t3x128(:,:,335))
  call heltable([8,16,128], n3(:,8261), t3x128(:,:,336))
  call heltable([8,16,128], n3(:,8262), t3x128(:,:,337))
  call heltable([8,16,128], n3(:,8263), t3x128(:,:,338))
  call heltable([8,16,128], n3(:,8264), t3x128(:,:,339))
  call heltable([8,16,128], n3(:,8265), t3x128(:,:,340))
  call heltable([8,16,128], n3(:,8266), t3x128(:,:,341))
  call heltable([8,16,128], n3(:,8267), t3x128(:,:,342))
  call heltable([8,16,128], n3(:,8268), t3x128(:,:,343))
  call heltable([8,16,128], n3(:,8269), t3x128(:,:,344))
  call heltable([16,8,128], n3(:,8270), t3x128(:,:,345))
  call heltable([8,16,128], n3(:,8271), t3x128(:,:,346))
  call heltable([16,8,128], n3(:,8272), t3x128(:,:,347))
  call heltable([8,16,128], n3(:,8273), t3x128(:,:,348))
  call heltable([8,16,128], n3(:,8274), t3x128(:,:,349))
  call heltable([8,16,128], n3(:,8275), t3x128(:,:,350))
  call heltable([8,16,128], n3(:,8276), t3x128(:,:,351))
  call heltable([8,16,128], n3(:,8277), t3x128(:,:,352))
  call heltable([16,8,128], n3(:,8278), t3x128(:,:,353))
  call heltable([8,16,128], n3(:,8279), t3x128(:,:,354))
  call heltable([16,8,128], n3(:,8280), t3x128(:,:,355))
  call heltable([8,16,128], n3(:,8281), t3x128(:,:,356))
  call heltable([8,16,128], n3(:,8282), t3x128(:,:,357))
  call heltable([8,16,128], n3(:,8283), t3x128(:,:,358))
  call heltable([8,16,128], n3(:,8284), t3x128(:,:,359))
  call heltable([8,16,128], n3(:,8285), t3x128(:,:,360))
  call heltable([16,8,128], n3(:,8286), t3x128(:,:,361))
  call heltable([8,16,128], n3(:,8287), t3x128(:,:,362))
  call heltable([16,8,128], n3(:,8288), t3x128(:,:,363))
  call heltable([8,16,128], n3(:,8289), t3x128(:,:,364))
  call heltable([8,16,128], n3(:,8290), t3x128(:,:,365))
  call heltable([8,16,128], n3(:,8291), t3x128(:,:,366))
  call heltable([8,16,128], n3(:,8292), t3x128(:,:,367))
  call heltable([8,16,128], n3(:,8293), t3x128(:,:,368))
  call heltable([16,8,128], n3(:,8294), t3x128(:,:,369))
  call heltable([8,16,128], n3(:,8295), t3x128(:,:,370))
  call heltable([16,8,128], n3(:,8296), t3x128(:,:,371))
  call heltable([8,16,128], n3(:,8297), t3x128(:,:,372))
  call heltable([16,8,128], n3(:,8298), t3x128(:,:,373))
  call heltable([8,16,128], n3(:,8299), t3x128(:,:,374))
  call heltable([16,8,128], n3(:,8300), t3x128(:,:,375))
  call heltable([16,8,128], n3(:,8301), t3x128(:,:,376))
  call heltable([8,16,128], n3(:,8302), t3x128(:,:,377))
  call heltable([8,16,128], n3(:,8303), t3x128(:,:,378))
  call heltable([8,16,128], n3(:,8304), t3x128(:,:,379))
  call heltable([8,16,128], n3(:,8305), t3x128(:,:,380))
  call heltable([16,8,128], n3(:,8306), t3x128(:,:,381))
  call heltable([16,8,128], n3(:,8307), t3x128(:,:,382))
  call heltable([16,8,128], n3(:,8308), t3x128(:,:,383))
  call heltable([16,8,128], n3(:,8309), t3x128(:,:,384))
  call heltable([16,8,128], n3(:,8310), t3x128(:,:,385))
  call heltable([16,8,128], n3(:,8311), t3x128(:,:,386))
  call heltable([16,8,128], n3(:,8312), t3x128(:,:,387))
  call heltable([16,8,128], n3(:,8313), t3x128(:,:,388))
  call heltable([16,8,128], n3(:,8314), t3x128(:,:,389))
  call heltable([16,8,128], n3(:,8315), t3x128(:,:,390))
  call heltable([8,16,128], n3(:,8316), t3x128(:,:,391))
  call heltable([8,16,128], n3(:,8317), t3x128(:,:,392))
  call heltable([16,8,128], n3(:,8318), t3x128(:,:,393))
  call heltable([16,8,128], n3(:,8319), t3x128(:,:,394))
  call heltable([16,8,128], n3(:,8320), t3x128(:,:,395))
  call heltable([16,8,128], n3(:,8321), t3x128(:,:,396))
  call heltable([8,16,128], n3(:,8322), t3x128(:,:,397))
  call heltable([8,16,128], n3(:,8323), t3x128(:,:,398))
  call heltable([8,16,128], n3(:,8324), t3x128(:,:,399))
  call heltable([8,16,128], n3(:,8325), t3x128(:,:,400))
  call heltable([8,16,128], n3(:,8326), t3x128(:,:,401))
  call heltable([8,16,128], n3(:,8327), t3x128(:,:,402))
  call heltable([8,16,128], n3(:,8328), t3x128(:,:,403))
  call heltable([8,16,128], n3(:,8329), t3x128(:,:,404))
  call heltable([8,16,128], n3(:,8330), t3x128(:,:,405))
  call heltable([8,16,128], n3(:,8331), t3x128(:,:,406))
  call heltable([8,16,128], n3(:,8332), t3x128(:,:,407))
  call heltable([8,16,128], n3(:,8333), t3x128(:,:,408))
  call heltable([8,16,128], n3(:,8334), t3x128(:,:,409))
  call heltable([8,16,128], n3(:,8335), t3x128(:,:,410))
  call heltable([8,16,128], n3(:,8336), t3x128(:,:,411))
  call heltable([8,16,128], n3(:,8337), t3x128(:,:,412))
  call heltable([8,16,128], n3(:,8338), t3x128(:,:,413))
  call heltable([8,16,128], n3(:,8339), t3x128(:,:,414))
  call heltable([8,16,128], n3(:,8340), t3x128(:,:,415))
  call heltable([8,16,128], n3(:,8341), t3x128(:,:,416))
  call heltable([8,16,128], n3(:,8342), t3x128(:,:,417))
  call heltable([16,8,128], n3(:,8343), t3x128(:,:,418))
  call heltable([8,16,128], n3(:,8344), t3x128(:,:,419))
  call heltable([16,8,128], n3(:,8345), t3x128(:,:,420))
  call heltable([16,8,128], n3(:,8346), t3x128(:,:,421))
  call heltable([8,16,128], n3(:,8347), t3x128(:,:,422))
  call heltable([8,16,128], n3(:,8348), t3x128(:,:,423))
  call heltable([8,16,128], n3(:,8349), t3x128(:,:,424))
  call heltable([8,16,128], n3(:,8350), t3x128(:,:,425))
  call heltable([16,8,128], n3(:,8351), t3x128(:,:,426))
  call heltable([16,8,128], n3(:,8352), t3x128(:,:,427))
  call heltable([16,8,128], n3(:,8353), t3x128(:,:,428))
  call heltable([16,8,128], n3(:,8354), t3x128(:,:,429))
  call heltable([16,8,128], n3(:,8355), t3x128(:,:,430))
  call heltable([16,8,128], n3(:,8356), t3x128(:,:,431))
  call heltable([16,8,128], n3(:,8357), t3x128(:,:,432))
  call heltable([16,8,128], n3(:,8358), t3x128(:,:,433))
  call heltable([16,8,128], n3(:,8359), t3x128(:,:,434))
  call heltable([16,8,128], n3(:,8360), t3x128(:,:,435))
  call heltable([8,16,128], n3(:,8361), t3x128(:,:,436))
  call heltable([8,16,128], n3(:,8362), t3x128(:,:,437))
  call heltable([16,8,128], n3(:,8363), t3x128(:,:,438))
  call heltable([16,8,128], n3(:,8364), t3x128(:,:,439))
  call heltable([16,8,128], n3(:,8365), t3x128(:,:,440))
  call heltable([16,8,128], n3(:,8366), t3x128(:,:,441))
  call heltable([8,16,128], n3(:,8367), t3x128(:,:,442))
  call heltable([8,16,128], n3(:,8368), t3x128(:,:,443))
  call heltable([8,16,128], n3(:,8369), t3x128(:,:,444))
  call heltable([8,16,128], n3(:,8370), t3x128(:,:,445))
  call heltable([8,16,128], n3(:,8371), t3x128(:,:,446))
  call heltable([8,16,128], n3(:,8372), t3x128(:,:,447))
  call heltable([8,16,128], n3(:,8373), t3x128(:,:,448))
  call heltable([8,16,128], n3(:,8374), t3x128(:,:,449))
  call heltable([8,16,128], n3(:,8375), t3x128(:,:,450))
  call heltable([8,16,128], n3(:,8376), t3x128(:,:,451))
  call heltable([8,16,128], n3(:,8377), t3x128(:,:,452))
  call heltable([8,16,128], n3(:,8378), t3x128(:,:,453))
  call heltable([8,16,128], n3(:,8379), t3x128(:,:,454))
  call heltable([8,16,128], n3(:,8380), t3x128(:,:,455))
  call heltable([8,16,128], n3(:,8381), t3x128(:,:,456))
  call heltable([8,16,128], n3(:,8382), t3x128(:,:,457))
  call heltable([8,16,128], n3(:,8383), t3x128(:,:,458))
  call heltable([8,16,128], n3(:,8384), t3x128(:,:,459))
  call heltable([8,16,128], n3(:,8385), t3x128(:,:,460))
  call heltable([8,16,128], n3(:,8386), t3x128(:,:,461))
  call heltable([8,16,128], n3(:,8387), t3x128(:,:,462))
  call heltable([8,16,128], n3(:,8388), t3x128(:,:,463))
  call heltable([8,16,128], n3(:,8389), t3x128(:,:,464))
  call heltable([8,16,128], n3(:,8390), t3x128(:,:,465))
  call heltable([8,16,128], n3(:,8391), t3x128(:,:,466))
  call heltable([8,16,128], n3(:,8392), t3x128(:,:,467))
  call heltable([8,16,128], n3(:,8393), t3x128(:,:,468))
  call heltable([8,16,128], n3(:,8394), t3x128(:,:,469))
  call heltable([8,16,128], n3(:,8395), t3x128(:,:,470))
  call heltable([8,16,128], n3(:,8396), t3x128(:,:,471))
  call heltable([8,16,128], n3(:,8397), t3x128(:,:,472))
  call heltable([8,16,128], n3(:,8398), t3x128(:,:,473))
  call heltable([8,16,128], n3(:,8399), t3x128(:,:,474))
  call heltable([8,16,128], n3(:,8400), t3x128(:,:,475))
  call heltable([8,16,128], n3(:,8401), t3x128(:,:,476))
  call heltable([8,16,128], n3(:,8402), t3x128(:,:,477))
  call heltable([8,16,128], n3(:,8403), t3x128(:,:,478))
  call heltable([8,16,128], n3(:,8404), t3x128(:,:,479))
  call heltable([8,16,128], n3(:,8405), t3x128(:,:,480))
  call heltable([8,16,128], n3(:,8406), t3x128(:,:,481))
  call heltable([8,16,128], n3(:,8407), t3x128(:,:,482))
  call heltable([8,16,128], n3(:,8408), t3x128(:,:,483))
  call heltable([8,16,128], n3(:,8409), t3x128(:,:,484))
  call heltable([8,16,128], n3(:,8410), t3x128(:,:,485))
  call heltable([8,16,128], n3(:,8411), t3x128(:,:,486))
  call heltable([8,16,128], n3(:,8412), t3x128(:,:,487))
  call heltable([8,16,128], n3(:,8413), t3x128(:,:,488))
  call heltable([8,16,128], n3(:,8414), t3x128(:,:,489))
  call heltable([8,16,128], n3(:,8415), t3x128(:,:,490))
  call heltable([8,16,128], n3(:,8416), t3x128(:,:,491))
  call heltable([8,16,128], n3(:,8417), t3x128(:,:,492))
  call heltable([8,16,128], n3(:,8418), t3x128(:,:,493))
  call heltable([8,16,128], n3(:,8419), t3x128(:,:,494))
  call heltable([8,16,128], n3(:,8420), t3x128(:,:,495))
  call heltable([8,16,128], n3(:,8421), t3x128(:,:,496))
  call heltable([8,16,128], n3(:,8422), t3x128(:,:,497))
  call heltable([8,16,128], n3(:,8423), t3x128(:,:,498))
  call heltable([8,16,128], n3(:,8424), t3x128(:,:,499))
  call heltable([8,16,128], n3(:,8425), t3x128(:,:,500))
  call heltable([8,16,128], n3(:,8426), t3x128(:,:,501))
  call heltable([8,16,128], n3(:,8427), t3x128(:,:,502))
  call heltable([8,16,128], n3(:,8428), t3x128(:,:,503))
  call heltable([8,16,128], n3(:,8429), t3x128(:,:,504))
  call heltable([8,16,128], n3(:,8430), t3x128(:,:,505))
  call heltable([8,16,128], n3(:,8431), t3x128(:,:,506))
  call heltable([8,16,128], n3(:,8432), t3x128(:,:,507))
  call heltable([16,8,128], n3(:,8433), t3x128(:,:,508))
  call heltable([8,16,128], n3(:,8434), t3x128(:,:,509))
  call heltable([16,8,128], n3(:,8435), t3x128(:,:,510))
  call heltable([16,8,128], n3(:,8436), t3x128(:,:,511))
  call heltable([8,16,128], n3(:,8437), t3x128(:,:,512))
  call heltable([8,16,128], n3(:,8438), t3x128(:,:,513))
  call heltable([8,16,128], n3(:,8439), t3x128(:,:,514))
  call heltable([8,16,128], n3(:,8440), t3x128(:,:,515))
  call heltable([16,8,128], n3(:,8441), t3x128(:,:,516))
  call heltable([16,8,128], n3(:,8442), t3x128(:,:,517))
  call heltable([16,8,128], n3(:,8443), t3x128(:,:,518))
  call heltable([16,8,128], n3(:,8444), t3x128(:,:,519))
  call heltable([16,8,128], n3(:,8445), t3x128(:,:,520))
  call heltable([16,8,128], n3(:,8446), t3x128(:,:,521))
  call heltable([16,8,128], n3(:,8447), t3x128(:,:,522))
  call heltable([16,8,128], n3(:,8448), t3x128(:,:,523))
  call heltable([8,16,128], n3(:,8449), t3x128(:,:,524))
  call heltable([8,16,128], n3(:,8450), t3x128(:,:,525))
  call heltable([8,16,128], n3(:,8451), t3x128(:,:,526))
  call heltable([8,16,128], n3(:,8452), t3x128(:,:,527))
  call heltable([8,16,128], n3(:,8453), t3x128(:,:,528))
  call heltable([8,16,128], n3(:,8454), t3x128(:,:,529))
  call heltable([8,16,128], n3(:,8455), t3x128(:,:,530))
  call heltable([8,16,128], n3(:,8456), t3x128(:,:,531))
  call heltable([8,16,128], n3(:,8457), t3x128(:,:,532))
  call heltable([8,16,128], n3(:,8458), t3x128(:,:,533))
  call heltable([8,16,128], n3(:,8459), t3x128(:,:,534))
  call heltable([8,16,128], n3(:,8460), t3x128(:,:,535))
  call heltable([8,16,128], n3(:,8461), t3x128(:,:,536))
  call heltable([8,16,128], n3(:,8462), t3x128(:,:,537))
  call heltable([8,16,128], n3(:,8463), t3x128(:,:,538))
  call heltable([8,16,128], n3(:,8464), t3x128(:,:,539))
  call heltable([16,8,128], n3(:,8465), t3x128(:,:,540))
  call heltable([16,8,128], n3(:,8466), t3x128(:,:,541))
  call heltable([16,8,128], n3(:,8467), t3x128(:,:,542))
  call heltable([16,8,128], n3(:,8468), t3x128(:,:,543))
  call heltable([16,8,128], n3(:,8469), t3x128(:,:,544))
  call heltable([16,8,128], n3(:,8470), t3x128(:,:,545))
  call heltable([16,8,128], n3(:,8471), t3x128(:,:,546))
  call heltable([16,8,128], n3(:,8472), t3x128(:,:,547))
  call heltable([16,8,128], n3(:,8473), t3x128(:,:,548))
  call heltable([16,8,128], n3(:,8474), t3x128(:,:,549))
  call heltable([16,8,128], n3(:,8475), t3x128(:,:,550))
  call heltable([16,8,128], n3(:,8476), t3x128(:,:,551))
  call heltable([16,8,128], n3(:,8477), t3x128(:,:,552))
  call heltable([16,8,128], n3(:,8478), t3x128(:,:,553))
  call heltable([16,8,128], n3(:,8479), t3x128(:,:,554))
  call heltable([16,8,128], n3(:,8480), t3x128(:,:,555))
  call heltable([16,8,128], n3(:,8481), t3x128(:,:,556))
  call heltable([16,8,128], n3(:,8482), t3x128(:,:,557))
  call heltable([16,8,128], n3(:,8483), t3x128(:,:,558))
  call heltable([16,8,128], n3(:,8484), t3x128(:,:,559))
  call heltable([16,8,128], n3(:,8485), t3x128(:,:,560))
  call heltable([16,8,128], n3(:,8486), t3x128(:,:,561))
  call heltable([16,8,128], n3(:,8487), t3x128(:,:,562))
  call heltable([16,8,128], n3(:,8488), t3x128(:,:,563))
  call heltable([16,8,128], n3(:,8489), t3x128(:,:,564))
  call heltable([16,8,128], n3(:,8490), t3x128(:,:,565))
  call heltable([16,8,128], n3(:,8491), t3x128(:,:,566))
  call heltable([16,8,128], n3(:,8492), t3x128(:,:,567))
  call heltable([16,8,128], n3(:,8493), t3x128(:,:,568))
  call heltable([16,8,128], n3(:,8494), t3x128(:,:,569))
  call heltable([8,16,128], n3(:,8495), t3x128(:,:,570))
  call heltable([16,8,128], n3(:,8496), t3x128(:,:,571))
  call heltable([16,8,128], n3(:,8497), t3x128(:,:,572))
  call heltable([8,16,128], n3(:,8498), t3x128(:,:,573))
  call heltable([8,16,128], n3(:,8499), t3x128(:,:,574))
  call heltable([8,16,128], n3(:,8500), t3x128(:,:,575))
  call heltable([8,16,128], n3(:,8501), t3x128(:,:,576))
  call heltable([16,8,128], n3(:,8502), t3x128(:,:,577))
  call heltable([16,8,128], n3(:,8503), t3x128(:,:,578))
  call heltable([16,8,128], n3(:,8504), t3x128(:,:,579))
  call heltable([16,8,128], n3(:,8505), t3x128(:,:,580))
  call heltable([16,8,128], n3(:,8506), t3x128(:,:,581))
  call heltable([16,8,128], n3(:,8507), t3x128(:,:,582))
  call heltable([16,8,128], n3(:,8508), t3x128(:,:,583))
  call heltable([16,8,128], n3(:,8509), t3x128(:,:,584))
  call heltable([8,16,128], n3(:,8510), t3x128(:,:,585))
  call heltable([8,16,128], n3(:,8511), t3x128(:,:,586))
  call heltable([8,16,128], n3(:,8512), t3x128(:,:,587))
  call heltable([8,16,128], n3(:,8513), t3x128(:,:,588))
  call heltable([8,16,128], n3(:,8514), t3x128(:,:,589))
  call heltable([8,16,128], n3(:,8515), t3x128(:,:,590))
  call heltable([8,16,128], n3(:,8516), t3x128(:,:,591))
  call heltable([8,16,128], n3(:,8517), t3x128(:,:,592))
  call heltable([8,16,128], n3(:,8518), t3x128(:,:,593))
  call heltable([8,16,128], n3(:,8519), t3x128(:,:,594))
  call heltable([8,16,128], n3(:,8520), t3x128(:,:,595))
  call heltable([8,16,128], n3(:,8521), t3x128(:,:,596))
  call heltable([8,16,128], n3(:,8522), t3x128(:,:,597))
  call heltable([8,16,128], n3(:,8523), t3x128(:,:,598))
  call heltable([8,16,128], n3(:,8524), t3x128(:,:,599))
  call heltable([8,16,128], n3(:,8525), t3x128(:,:,600))
  call heltable([8,16,128], n3(:,8526), t3x128(:,:,601))
  call heltable([8,16,128], n3(:,8527), t3x128(:,:,602))
  call heltable([8,16,128], n3(:,8528), t3x128(:,:,603))
  call heltable([8,16,128], n3(:,8529), t3x128(:,:,604))
  call heltable([8,16,128], n3(:,8530), t3x128(:,:,605))
  call heltable([8,16,128], n3(:,8531), t3x128(:,:,606))
  call heltable([8,16,128], n3(:,8532), t3x128(:,:,607))
  call heltable([8,16,128], n3(:,8533), t3x128(:,:,608))
  call heltable([8,16,128], n3(:,8534), t3x128(:,:,609))
  call heltable([8,16,128], n3(:,8535), t3x128(:,:,610))
  call heltable([8,16,128], n3(:,8536), t3x128(:,:,611))
  call heltable([8,16,128], n3(:,8537), t3x128(:,:,612))
  call heltable([8,16,128], n3(:,8538), t3x128(:,:,613))
  call heltable([8,16,128], n3(:,8539), t3x128(:,:,614))
  call heltable([8,16,128], n3(:,8540), t3x128(:,:,615))
  call heltable([8,16,128], n3(:,8541), t3x128(:,:,616))
  call heltable([8,16,128], n3(:,8542), t3x128(:,:,617))
  call heltable([8,16,128], n3(:,8543), t3x128(:,:,618))
  call heltable([8,16,128], n3(:,8544), t3x128(:,:,619))
  call heltable([8,16,128], n3(:,8545), t3x128(:,:,620))
  call heltable([8,16,128], n3(:,8546), t3x128(:,:,621))
  call heltable([8,16,128], n3(:,8547), t3x128(:,:,622))
  call heltable([8,16,128], n3(:,8548), t3x128(:,:,623))
  call heltable([8,16,128], n3(:,8549), t3x128(:,:,624))
  call heltable([8,16,128], n3(:,8550), t3x128(:,:,625))
  call heltable([8,16,128], n3(:,8551), t3x128(:,:,626))
  call heltable([8,16,128], n3(:,8552), t3x128(:,:,627))
  call heltable([8,16,128], n3(:,8553), t3x128(:,:,628))
  call heltable([8,16,128], n3(:,8554), t3x128(:,:,629))
  call heltable([8,16,128], n3(:,8555), t3x128(:,:,630))
  call heltable([8,16,128], n3(:,8556), t3x128(:,:,631))
  call heltable([8,16,128], n3(:,8557), t3x128(:,:,632))
  call heltable([8,16,128], n3(:,8558), t3x128(:,:,633))
  call heltable([8,16,128], n3(:,8559), t3x128(:,:,634))
  call heltable([8,16,128], n3(:,8560), t3x128(:,:,635))
  call heltable([8,16,128], n3(:,8561), t3x128(:,:,636))
  call heltable([8,16,128], n3(:,8562), t3x128(:,:,637))
  call heltable([8,16,128], n3(:,8563), t3x128(:,:,638))
  call heltable([8,16,128], n3(:,8564), t3x128(:,:,639))
  call heltable([8,16,128], n3(:,8565), t3x128(:,:,640))
  call heltable([8,16,128], n3(:,8566), t3x128(:,:,641))
  call heltable([8,16,128], n3(:,8567), t3x128(:,:,642))
  call heltable([8,16,128], n3(:,8568), t3x128(:,:,643))
  call heltable([8,16,128], n3(:,8569), t3x128(:,:,644))
  call heltable([8,16,128], n3(:,8570), t3x128(:,:,645))
  call heltable([8,16,128], n3(:,8571), t3x128(:,:,646))
  call heltable([8,16,128], n3(:,8572), t3x128(:,:,647))
  call heltable([8,16,128], n3(:,8573), t3x128(:,:,648))
  call heltable([8,16,128], n3(:,8574), t3x128(:,:,649))
  call heltable([8,16,128], n3(:,8575), t3x128(:,:,650))
  call heltable([8,16,128], n3(:,8576), t3x128(:,:,651))
  call heltable([8,16,128], n3(:,8577), t3x128(:,:,652))
  call heltable([8,16,128], n3(:,8578), t3x128(:,:,653))
  call heltable([8,16,128], n3(:,8579), t3x128(:,:,654))
  call heltable([8,16,128], n3(:,8580), t3x128(:,:,655))
  call heltable([8,16,128], n3(:,8581), t3x128(:,:,656))
  call heltable([8,16,128], n3(:,8582), t3x128(:,:,657))
  call heltable([8,16,128], n3(:,8583), t3x128(:,:,658))
  call heltable([8,16,128], n3(:,8584), t3x128(:,:,659))
  call heltable([8,16,128], n3(:,8585), t3x128(:,:,660))
  call heltable([8,16,128], n3(:,8586), t3x128(:,:,661))
  call heltable([8,16,128], n3(:,8587), t3x128(:,:,662))
  call heltable([8,16,128], n3(:,8588), t3x128(:,:,663))
  call heltable([8,16,128], n3(:,8589), t3x128(:,:,664))
  call heltable([8,16,128], n3(:,8590), t3x128(:,:,665))
  call heltable([8,16,128], n3(:,8591), t3x128(:,:,666))
  call heltable([8,16,128], n3(:,8592), t3x128(:,:,667))
  call heltable([8,16,128], n3(:,8593), t3x128(:,:,668))
  call heltable([8,16,128], n3(:,8594), t3x128(:,:,669))
  call heltable([8,16,128], n3(:,8595), t3x128(:,:,670))
  call heltable([8,16,128], n3(:,8596), t3x128(:,:,671))
  call heltable([8,16,128], n3(:,8597), t3x128(:,:,672))
  call heltable([8,16,128], n3(:,8598), t3x128(:,:,673))
  call heltable([8,16,128], n3(:,8599), t3x128(:,:,674))
  call heltable([8,16,128], n3(:,8600), t3x128(:,:,675))
  call heltable([8,16,128], n3(:,8601), t3x128(:,:,676))
  call heltable([8,16,128], n3(:,8602), t3x128(:,:,677))
  call heltable([8,16,128], n3(:,8603), t3x128(:,:,678))
  call heltable([8,16,128], n3(:,8604), t3x128(:,:,679))
  call heltable([8,16,128], n3(:,8605), t3x128(:,:,680))
  call heltable([8,16,128], n3(:,8606), t3x128(:,:,681))
  call heltable([8,16,128], n3(:,8607), t3x128(:,:,682))
  call heltable([8,16,128], n3(:,8608), t3x128(:,:,683))
  call heltable([8,16,128], n3(:,8609), t3x128(:,:,684))
  call heltable([8,16,128], n3(:,8610), t3x128(:,:,685))
  call heltable([8,16,128], n3(:,8611), t3x128(:,:,686))
  call heltable([8,16,128], n3(:,8612), t3x128(:,:,687))
  call heltable([8,16,128], n3(:,8613), t3x128(:,:,688))
  call heltable([8,16,128], n3(:,8614), t3x128(:,:,689))
  call heltable([8,16,128], n3(:,8615), t3x128(:,:,690))
  call heltable([8,16,128], n3(:,8616), t3x128(:,:,691))
  call heltable([8,16,128], n3(:,8617), t3x128(:,:,692))
  call heltable([8,16,128], n3(:,8618), t3x128(:,:,693))
  call heltable([8,16,128], n3(:,8619), t3x128(:,:,694))
  call heltable([8,16,128], n3(:,8620), t3x128(:,:,695))
  call heltable([8,16,128], n3(:,8621), t3x128(:,:,696))
  call heltable([8,16,128], n3(:,8622), t3x128(:,:,697))
  call heltable([8,16,128], n3(:,8623), t3x128(:,:,698))
  call heltable([8,16,128], n3(:,8624), t3x128(:,:,699))
  call heltable([8,16,128], n3(:,8625), t3x128(:,:,700))
  call heltable([8,16,128], n3(:,8626), t3x128(:,:,701))
  call heltable([8,16,128], n3(:,8627), t3x128(:,:,702))
  call heltable([8,16,128], n3(:,8628), t3x128(:,:,703))
  call heltable([8,16,128], n3(:,8629), t3x128(:,:,704))
  call heltable([8,16,128], n3(:,8630), t3x128(:,:,705))
  call heltable([8,16,128], n3(:,8631), t3x128(:,:,706))
  call heltable([8,16,128], n3(:,8632), t3x128(:,:,707))
  call heltable([8,16,128], n3(:,8633), t3x128(:,:,708))
  call heltable([8,16,128], n3(:,8634), t3x128(:,:,709))
  call heltable([8,16,128], n3(:,8635), t3x128(:,:,710))
  call heltable([8,16,128], n3(:,8636), t3x128(:,:,711))
  call heltable([8,16,128], n3(:,8637), t3x128(:,:,712))
  call heltable([8,16,128], n3(:,8638), t3x128(:,:,713))
  call heltable([8,16,128], n3(:,8639), t3x128(:,:,714))
  call heltable([8,16,128], n3(:,8640), t3x128(:,:,715))
  call heltable([8,16,128], n3(:,8641), t3x128(:,:,716))
  call heltable([8,16,128], n3(:,8642), t3x128(:,:,717))
  call heltable([8,16,128], n3(:,8643), t3x128(:,:,718))
  call heltable([8,16,128], n3(:,8644), t3x128(:,:,719))
  call heltable([8,16,128], n3(:,8645), t3x128(:,:,720))
  call heltable([8,16,128], n3(:,8646), t3x128(:,:,721))
  call heltable([8,16,128], n3(:,8647), t3x128(:,:,722))
  call heltable([8,16,128], n3(:,8648), t3x128(:,:,723))
  call heltable([8,16,128], n3(:,8649), t3x128(:,:,724))
  call heltable([8,16,128], n3(:,8650), t3x128(:,:,725))
  call heltable([8,16,128], n3(:,8651), t3x128(:,:,726))
  call heltable([8,16,128], n3(:,8652), t3x128(:,:,727))
  call heltable([8,16,128], n3(:,8653), t3x128(:,:,728))
  call heltable([8,16,128], n3(:,8654), t3x128(:,:,729))
  call heltable([8,16,128], n3(:,8655), t3x128(:,:,730))
  call heltable([8,16,128], n3(:,8656), t3x128(:,:,731))
  call heltable([8,16,128], n3(:,8657), t3x128(:,:,732))
  call heltable([8,16,128], n3(:,8658), t3x128(:,:,733))
  call heltable([8,16,128], n3(:,8659), t3x128(:,:,734))
  call heltable([8,16,128], n3(:,8660), t3x128(:,:,735))
  call heltable([8,16,128], n3(:,8661), t3x128(:,:,736))
  call heltable([8,16,128], n3(:,8662), t3x128(:,:,737))
  call heltable([8,16,128], n3(:,8663), t3x128(:,:,738))
  call heltable([8,16,128], n3(:,8664), t3x128(:,:,739))
  call heltable([8,16,128], n3(:,8665), t3x128(:,:,740))
  call heltable([8,16,128], n3(:,8666), t3x128(:,:,741))
  call heltable([8,16,128], n3(:,8667), t3x128(:,:,742))
  call heltable([8,16,128], n3(:,8668), t3x128(:,:,743))
  call heltable([8,16,128], n3(:,8669), t3x128(:,:,744))
  call heltable([16,8,128], n3(:,8670), t3x128(:,:,745))
  call heltable([16,8,128], n3(:,8671), t3x128(:,:,746))
  call heltable([16,8,128], n3(:,8672), t3x128(:,:,747))
  call heltable([16,8,128], n3(:,8673), t3x128(:,:,748))
  call heltable([16,8,128], n3(:,8674), t3x128(:,:,749))
  call heltable([16,8,128], n3(:,8675), t3x128(:,:,750))
  call heltable([16,8,128], n3(:,8676), t3x128(:,:,751))
  call heltable([16,8,128], n3(:,8677), t3x128(:,:,752))
  call heltable([16,8,128], n3(:,8678), t3x128(:,:,753))
  call heltable([16,8,128], n3(:,8679), t3x128(:,:,754))
  call heltable([16,8,128], n3(:,8680), t3x128(:,:,755))
  call heltable([16,8,128], n3(:,8681), t3x128(:,:,756))
  call heltable([16,8,128], n3(:,8682), t3x128(:,:,757))
  call heltable([16,8,128], n3(:,8683), t3x128(:,:,758))
  call heltable([16,8,128], n3(:,8684), t3x128(:,:,759))
  call heltable([16,8,128], n3(:,8685), t3x128(:,:,760))
  call heltable([8,16,128], n3(:,8686), t3x128(:,:,761))
  call heltable([8,16,128], n3(:,8687), t3x128(:,:,762))
  call heltable([8,16,128], n3(:,8688), t3x128(:,:,763))
  call heltable([8,16,128], n3(:,8689), t3x128(:,:,764))
  call heltable([8,16,128], n3(:,8690), t3x128(:,:,765))
  call heltable([8,16,128], n3(:,8691), t3x128(:,:,766))
  call heltable([8,16,128], n3(:,8692), t3x128(:,:,767))
  call heltable([8,16,128], n3(:,8693), t3x128(:,:,768))
  call heltable([8,16,128], n3(:,8694), t3x128(:,:,769))
  call heltable([8,16,128], n3(:,8695), t3x128(:,:,770))
  call heltable([8,16,128], n3(:,8696), t3x128(:,:,771))
  call heltable([8,16,128], n3(:,8697), t3x128(:,:,772))
  call heltable([8,16,128], n3(:,8698), t3x128(:,:,773))
  call heltable([16,8,128], n3(:,8699), t3x128(:,:,774))
  call heltable([16,8,128], n3(:,8700), t3x128(:,:,775))
  call heltable([8,16,128], n3(:,8701), t3x128(:,:,776))
  call heltable([8,16,128], n3(:,8702), t3x128(:,:,777))
  call heltable([16,8,128], n3(:,8703), t3x128(:,:,778))
  call heltable([16,8,128], n3(:,8704), t3x128(:,:,779))
  call heltable([16,8,128], n3(:,8705), t3x128(:,:,780))
  call heltable([16,8,128], n3(:,8706), t3x128(:,:,781))
  call heltable([8,16,128], n3(:,8707), t3x128(:,:,782))
  call heltable([8,16,128], n3(:,8708), t3x128(:,:,783))
  call heltable([8,16,128], n3(:,8709), t3x128(:,:,784))
  call heltable([8,16,128], n3(:,8710), t3x128(:,:,785))
  call heltable([8,16,128], n3(:,8711), t3x128(:,:,786))
  call heltable([8,16,128], n3(:,8712), t3x128(:,:,787))
  call heltable([8,16,128], n3(:,8713), t3x128(:,:,788))
  call heltable([8,16,128], n3(:,8714), t3x128(:,:,789))
  call heltable([16,8,128], n3(:,8715), t3x128(:,:,790))
  call heltable([8,16,128], n3(:,8716), t3x128(:,:,791))
  call heltable([16,8,128], n3(:,8717), t3x128(:,:,792))
  call heltable([16,8,128], n3(:,8718), t3x128(:,:,793))
  call heltable([8,16,128], n3(:,8719), t3x128(:,:,794))
  call heltable([8,16,128], n3(:,8720), t3x128(:,:,795))
  call heltable([8,16,128], n3(:,8721), t3x128(:,:,796))
  call heltable([8,16,128], n3(:,8722), t3x128(:,:,797))
  call heltable([16,8,128], n3(:,8723), t3x128(:,:,798))
  call heltable([16,8,128], n3(:,8724), t3x128(:,:,799))
  call heltable([16,8,128], n3(:,8725), t3x128(:,:,800))
  call heltable([16,8,128], n3(:,8726), t3x128(:,:,801))
  call heltable([16,8,128], n3(:,8727), t3x128(:,:,802))
  call heltable([16,8,128], n3(:,8728), t3x128(:,:,803))
  call heltable([16,8,128], n3(:,8729), t3x128(:,:,804))
  call heltable([16,8,128], n3(:,8730), t3x128(:,:,805))
  call heltable([16,8,128], n3(:,8731), t3x128(:,:,806))
  call heltable([16,8,128], n3(:,8732), t3x128(:,:,807))
  call heltable([16,8,128], n3(:,8733), t3x128(:,:,808))
  call heltable([16,8,128], n3(:,8734), t3x128(:,:,809))
  call heltable([16,8,128], n3(:,8735), t3x128(:,:,810))
  call heltable([16,8,128], n3(:,8736), t3x128(:,:,811))
  call heltable([16,8,128], n3(:,8737), t3x128(:,:,812))
  call heltable([16,8,128], n3(:,8738), t3x128(:,:,813))
  call heltable([16,8,128], n3(:,8739), t3x128(:,:,814))
  call heltable([16,8,128], n3(:,8740), t3x128(:,:,815))
  call heltable([16,8,128], n3(:,8741), t3x128(:,:,816))
  call heltable([16,8,128], n3(:,8742), t3x128(:,:,817))
  call heltable([16,8,128], n3(:,8743), t3x128(:,:,818))
  call heltable([8,16,128], n3(:,8744), t3x128(:,:,819))
  call heltable([8,16,128], n3(:,8745), t3x128(:,:,820))
  call heltable([8,16,128], n3(:,8746), t3x128(:,:,821))
  call heltable([8,16,128], n3(:,8747), t3x128(:,:,822))
  call heltable([8,16,128], n3(:,8748), t3x128(:,:,823))
  call heltable([8,16,128], n3(:,8749), t3x128(:,:,824))
  call heltable([8,16,128], n3(:,8750), t3x128(:,:,825))
  call heltable([8,16,128], n3(:,8751), t3x128(:,:,826))
  call heltable([8,16,128], n3(:,8752), t3x128(:,:,827))
  call heltable([8,16,128], n3(:,8753), t3x128(:,:,828))
  call heltable([8,16,128], n3(:,8754), t3x128(:,:,829))
  call heltable([8,16,128], n3(:,8755), t3x128(:,:,830))
  call heltable([8,16,128], n3(:,8756), t3x128(:,:,831))
  call heltable([8,16,128], n3(:,8757), t3x128(:,:,832))
  call heltable([8,16,128], n3(:,8758), t3x128(:,:,833))
  call heltable([8,16,128], n3(:,8759), t3x128(:,:,834))
  call heltable([8,16,128], n3(:,8760), t3x128(:,:,835))
  call heltable([8,16,128], n3(:,8761), t3x128(:,:,836))
  call heltable([8,16,128], n3(:,8762), t3x128(:,:,837))
  call heltable([8,16,128], n3(:,8763), t3x128(:,:,838))
  call heltable([8,16,128], n3(:,8764), t3x128(:,:,839))
  call heltable([8,16,128], n3(:,8765), t3x128(:,:,840))
  call heltable([8,16,128], n3(:,8766), t3x128(:,:,841))
  call heltable([8,16,128], n3(:,8767), t3x128(:,:,842))
  call heltable([8,16,128], n3(:,8768), t3x128(:,:,843))
  call heltable([8,16,128], n3(:,8769), t3x128(:,:,844))
  call heltable([8,16,128], n3(:,8770), t3x128(:,:,845))
  call heltable([8,16,128], n3(:,8771), t3x128(:,:,846))
  call heltable([8,16,128], n3(:,8772), t3x128(:,:,847))
  call heltable([8,16,128], n3(:,8773), t3x128(:,:,848))
  call heltable([8,16,128], n3(:,8774), t3x128(:,:,849))
  call heltable([8,16,128], n3(:,8775), t3x128(:,:,850))
  call heltable([16,8,128], n3(:,8776), t3x128(:,:,851))
  call heltable([16,8,128], n3(:,8777), t3x128(:,:,852))
  call heltable([16,8,128], n3(:,8778), t3x128(:,:,853))
  call heltable([16,8,128], n3(:,8779), t3x128(:,:,854))
  call heltable([16,8,128], n3(:,8780), t3x128(:,:,855))
  call heltable([16,8,128], n3(:,8781), t3x128(:,:,856))
  call heltable([16,8,128], n3(:,8782), t3x128(:,:,857))
  call heltable([16,8,128], n3(:,8783), t3x128(:,:,858))
  call heltable([16,8,128], n3(:,8784), t3x128(:,:,859))
  call heltable([16,8,128], n3(:,8785), t3x128(:,:,860))
  call heltable([16,8,128], n3(:,8786), t3x128(:,:,861))
  call heltable([16,8,128], n3(:,8787), t3x128(:,:,862))
  call heltable([16,8,128], n3(:,8788), t3x128(:,:,863))
  call heltable([16,8,128], n3(:,8789), t3x128(:,:,864))
  call heltable([16,8,128], n3(:,8790), t3x128(:,:,865))
  call heltable([16,8,128], n3(:,8791), t3x128(:,:,866))
  call heltable([8,16,128], n3(:,8792), t3x128(:,:,867))
  call heltable([8,16,128], n3(:,8793), t3x128(:,:,868))
  call heltable([8,16,128], n3(:,8794), t3x128(:,:,869))
  call heltable([8,16,128], n3(:,8795), t3x128(:,:,870))
  call heltable([8,16,128], n3(:,8796), t3x128(:,:,871))
  call heltable([8,16,128], n3(:,8797), t3x128(:,:,872))
  call heltable([8,16,128], n3(:,8798), t3x128(:,:,873))
  call heltable([8,16,128], n3(:,8799), t3x128(:,:,874))
  call heltable([8,16,128], n3(:,8800), t3x128(:,:,875))
  call heltable([8,16,128], n3(:,8801), t3x128(:,:,876))
  call heltable([8,16,128], n3(:,8802), t3x128(:,:,877))
  call heltable([8,16,128], n3(:,8803), t3x128(:,:,878))
  call heltable([8,16,128], n3(:,8804), t3x128(:,:,879))
  call heltable([8,16,128], n3(:,8805), t3x128(:,:,880))
  call heltable([8,16,128], n3(:,8806), t3x128(:,:,881))
  call heltable([8,16,128], n3(:,8807), t3x128(:,:,882))
  call heltable([8,16,128], n3(:,8808), t3x128(:,:,883))
  call heltable([8,16,128], n3(:,8809), t3x128(:,:,884))
  call heltable([8,16,128], n3(:,8810), t3x128(:,:,885))
  call heltable([8,16,128], n3(:,8811), t3x128(:,:,886))
  call heltable([8,16,128], n3(:,8812), t3x128(:,:,887))
  call heltable([8,16,128], n3(:,8813), t3x128(:,:,888))
  call heltable([8,16,128], n3(:,8814), t3x128(:,:,889))
  call heltable([8,16,128], n3(:,8815), t3x128(:,:,890))
  call heltable([8,16,128], n3(:,8816), t3x128(:,:,891))
  call heltable([8,16,128], n3(:,8817), t3x128(:,:,892))
  call heltable([8,16,128], n3(:,8818), t3x128(:,:,893))
  call heltable([8,16,128], n3(:,8819), t3x128(:,:,894))
  call heltable([8,16,128], n3(:,8820), t3x128(:,:,895))
  call heltable([8,16,128], n3(:,8821), t3x128(:,:,896))
  call heltable([8,16,128], n3(:,8822), t3x128(:,:,897))
  call heltable([8,16,128], n3(:,8823), t3x128(:,:,898))
  call heltable([8,16,128], n3(:,8824), t3x128(:,:,899))
  call heltable([8,16,128], n3(:,8825), t3x128(:,:,900))
  call heltable([8,16,128], n3(:,8826), t3x128(:,:,901))
  call heltable([8,16,128], n3(:,8827), t3x128(:,:,902))
  call heltable([8,16,128], n3(:,8828), t3x128(:,:,903))
  call heltable([8,16,128], n3(:,8829), t3x128(:,:,904))
  call heltable([8,16,128], n3(:,8830), t3x128(:,:,905))
  call heltable([8,16,128], n3(:,8831), t3x128(:,:,906))
  call heltable([8,16,128], n3(:,8832), t3x128(:,:,907))
  call heltable([8,16,128], n3(:,8833), t3x128(:,:,908))
  call heltable([8,16,128], n3(:,8834), t3x128(:,:,909))
  call heltable([8,16,128], n3(:,8835), t3x128(:,:,910))
  call heltable([8,16,128], n3(:,8836), t3x128(:,:,911))
  call heltable([8,16,128], n3(:,8837), t3x128(:,:,912))
  call heltable([8,16,128], n3(:,8838), t3x128(:,:,913))
  call heltable([8,16,128], n3(:,8839), t3x128(:,:,914))
  call heltable([8,16,128], n3(:,8840), t3x128(:,:,915))
  call heltable([8,16,128], n3(:,8841), t3x128(:,:,916))
  call heltable([8,16,128], n3(:,8842), t3x128(:,:,917))
  call heltable([8,16,128], n3(:,8843), t3x128(:,:,918))
  call heltable([8,16,128], n3(:,8844), t3x128(:,:,919))
  call heltable([8,16,128], n3(:,8845), t3x128(:,:,920))
  call heltable([8,16,128], n3(:,8846), t3x128(:,:,921))
  call heltable([8,16,128], n3(:,8847), t3x128(:,:,922))
  call heltable([8,16,128], n3(:,8848), t3x128(:,:,923))
  call heltable([8,16,128], n3(:,8849), t3x128(:,:,924))
  call heltable([8,16,128], n3(:,8850), t3x128(:,:,925))
  call heltable([8,16,128], n3(:,8851), t3x128(:,:,926))
  call heltable([8,16,128], n3(:,8852), t3x128(:,:,927))
  call heltable([8,16,128], n3(:,8853), t3x128(:,:,928))
  call heltable([8,16,128], n3(:,8854), t3x128(:,:,929))
  call heltable([8,16,128], n3(:,8855), t3x128(:,:,930))
  call heltable([8,16,128], n3(:,8856), t3x128(:,:,931))
  call heltable([8,16,128], n3(:,8857), t3x128(:,:,932))
  call heltable([8,16,128], n3(:,8858), t3x128(:,:,933))
  call heltable([8,16,128], n3(:,8859), t3x128(:,:,934))
  call heltable([8,16,128], n3(:,8860), t3x128(:,:,935))
  call heltable([8,16,128], n3(:,8861), t3x128(:,:,936))
  call heltable([8,16,128], n3(:,8862), t3x128(:,:,937))
  call heltable([8,16,128], n3(:,8863), t3x128(:,:,938))
  call heltable([8,16,128], n3(:,8864), t3x128(:,:,939))
  call heltable([8,16,128], n3(:,8865), t3x128(:,:,940))
  call heltable([8,16,128], n3(:,8866), t3x128(:,:,941))
  call heltable([8,16,128], n3(:,8867), t3x128(:,:,942))
  call heltable([8,16,128], n3(:,8868), t3x128(:,:,943))
  call heltable([8,16,128], n3(:,8869), t3x128(:,:,944))
  call heltable([8,16,128], n3(:,8870), t3x128(:,:,945))
  call heltable([8,16,128], n3(:,8871), t3x128(:,:,946))
  call heltable([8,16,128], n3(:,8872), t3x128(:,:,947))
  call heltable([8,16,128], n3(:,8873), t3x128(:,:,948))
  call heltable([8,16,128], n3(:,8874), t3x128(:,:,949))
  call heltable([8,16,128], n3(:,8875), t3x128(:,:,950))
  call heltable([8,16,128], n3(:,8876), t3x128(:,:,951))
  call heltable([8,16,128], n3(:,8877), t3x128(:,:,952))
  call heltable([8,16,128], n3(:,8878), t3x128(:,:,953))
  call heltable([8,16,128], n3(:,8879), t3x128(:,:,954))
  call heltable([8,16,128], n3(:,8880), t3x128(:,:,955))
  call heltable([8,16,128], n3(:,8881), t3x128(:,:,956))
  call heltable([8,16,128], n3(:,8882), t3x128(:,:,957))
  call heltable([8,16,128], n3(:,8883), t3x128(:,:,958))
  call heltable([8,16,128], n3(:,8884), t3x128(:,:,959))
  call heltable([8,16,128], n3(:,8885), t3x128(:,:,960))
  call heltable([8,16,128], n3(:,8886), t3x128(:,:,961))
  call heltable([8,16,128], n3(:,8887), t3x128(:,:,962))
  call heltable([8,16,128], n3(:,8888), t3x128(:,:,963))
  call heltable([8,16,128], n3(:,8889), t3x128(:,:,964))
  call heltable([8,16,128], n3(:,8890), t3x128(:,:,965))
  call heltable([8,16,128], n3(:,8891), t3x128(:,:,966))
  call heltable([8,16,128], n3(:,8892), t3x128(:,:,967))
  call heltable([8,16,128], n3(:,8893), t3x128(:,:,968))
  call heltable([8,16,128], n3(:,8894), t3x128(:,:,969))
  call heltable([8,16,128], n3(:,8895), t3x128(:,:,970))
  call heltable([8,16,128], n3(:,8896), t3x128(:,:,971))
  call heltable([8,16,128], n3(:,8897), t3x128(:,:,972))
  call heltable([8,16,128], n3(:,8898), t3x128(:,:,973))
  call heltable([8,16,128], n3(:,8899), t3x128(:,:,974))
  call heltable([8,16,128], n3(:,8900), t3x128(:,:,975))
  call heltable([8,16,128], n3(:,8901), t3x128(:,:,976))
  call heltable([8,16,128], n3(:,8902), t3x128(:,:,977))
  call heltable([8,16,128], n3(:,8903), t3x128(:,:,978))
  call heltable([8,16,128], n3(:,8904), t3x128(:,:,979))
  call heltable([8,16,128], n3(:,8905), t3x128(:,:,980))
  call heltable([8,16,128], n3(:,8906), t3x128(:,:,981))
  call heltable([8,16,128], n3(:,8907), t3x128(:,:,982))
  call heltable([8,16,128], n3(:,8908), t3x128(:,:,983))
  call heltable([8,16,128], n3(:,8909), t3x128(:,:,984))
  call heltable([8,16,128], n3(:,8910), t3x128(:,:,985))
  call heltable([8,16,128], n3(:,8911), t3x128(:,:,986))
  call heltable([8,16,128], n3(:,8912), t3x128(:,:,987))
  call heltable([8,16,128], n3(:,8913), t3x128(:,:,988))
  call heltable([8,16,128], n3(:,8914), t3x128(:,:,989))
  call heltable([8,16,128], n3(:,8915), t3x128(:,:,990))
  call heltable([8,16,128], n3(:,8916), t3x128(:,:,991))
  call heltable([8,16,128], n3(:,8917), t3x128(:,:,992))
  call heltable([8,16,128], n3(:,8918), t3x128(:,:,993))
  call heltable([8,16,128], n3(:,8919), t3x128(:,:,994))
  call heltable([8,16,128], n3(:,8920), t3x128(:,:,995))
  call heltable([8,16,128], n3(:,8921), t3x128(:,:,996))
  call heltable([8,16,128], n3(:,8922), t3x128(:,:,997))
  call heltable([8,16,128], n3(:,8923), t3x128(:,:,998))
  call heltable([8,16,128], n3(:,8924), t3x128(:,:,999))
  call heltable([8,16,128], n3(:,8925), t3x128(:,:,1000))
  call heltable([8,16,128], n3(:,8926), t3x128(:,:,1001))
  call heltable([8,16,128], n3(:,8927), t3x128(:,:,1002))
  call heltable([8,16,128], n3(:,8928), t3x128(:,:,1003))
  call heltable([8,16,128], n3(:,8929), t3x128(:,:,1004))
  call heltable([8,16,128], n3(:,8930), t3x128(:,:,1005))
  call heltable([8,16,128], n3(:,8931), t3x128(:,:,1006))
  call heltable([8,16,128], n3(:,8932), t3x128(:,:,1007))
  call heltable([16,8,128], n3(:,8933), t3x128(:,:,1008))
  call heltable([16,8,128], n3(:,8934), t3x128(:,:,1009))
  call heltable([16,8,128], n3(:,8935), t3x128(:,:,1010))
  call heltable([16,8,128], n3(:,8936), t3x128(:,:,1011))
  call heltable([16,8,128], n3(:,8937), t3x128(:,:,1012))
  call heltable([16,8,128], n3(:,8938), t3x128(:,:,1013))
  call heltable([16,8,128], n3(:,8939), t3x128(:,:,1014))
  call heltable([16,8,128], n3(:,8940), t3x128(:,:,1015))
  call heltable([16,8,128], n3(:,8941), t3x128(:,:,1016))
  call heltable([16,8,128], n3(:,8942), t3x128(:,:,1017))
  call heltable([16,8,128], n3(:,8943), t3x128(:,:,1018))
  call heltable([16,8,128], n3(:,8944), t3x128(:,:,1019))
  call heltable([16,8,128], n3(:,8945), t3x128(:,:,1020))
  call heltable([16,8,128], n3(:,8946), t3x128(:,:,1021))
  call heltable([16,8,128], n3(:,8947), t3x128(:,:,1022))
  call heltable([16,8,128], n3(:,8948), t3x128(:,:,1023))
  call heltable([8,16,128], n3(:,8949), t3x128(:,:,1024))
  call heltable([8,16,128], n3(:,8950), t3x128(:,:,1025))
  call heltable([8,16,128], n3(:,8951), t3x128(:,:,1026))
  call heltable([8,16,128], n3(:,8952), t3x128(:,:,1027))
  call heltable([8,16,128], n3(:,8953), t3x128(:,:,1028))
  call heltable([8,16,128], n3(:,8954), t3x128(:,:,1029))
  call heltable([8,16,128], n3(:,8955), t3x128(:,:,1030))
  call heltable([8,16,128], n3(:,8956), t3x128(:,:,1031))
  call heltable([8,16,128], n3(:,8957), t3x128(:,:,1032))
  call heltable([8,16,128], n3(:,8958), t3x128(:,:,1033))
  call heltable([8,16,128], n3(:,8959), t3x128(:,:,1034))
  call heltable([8,16,128], n3(:,8960), t3x128(:,:,1035))
  call heltable([8,16,128], n3(:,8961), t3x128(:,:,1036))
  call heltable([8,16,128], n3(:,8962), t3x128(:,:,1037))
  call heltable([8,16,128], n3(:,8963), t3x128(:,:,1038))
  call heltable([8,16,128], n3(:,8964), t3x128(:,:,1039))
  call heltable([16,8,128], n3(:,8965), t3x128(:,:,1040))
  call heltable([16,8,128], n3(:,8966), t3x128(:,:,1041))
  call heltable([16,8,128], n3(:,8967), t3x128(:,:,1042))
  call heltable([16,8,128], n3(:,8968), t3x128(:,:,1043))
  call heltable([16,8,128], n3(:,8969), t3x128(:,:,1044))
  call heltable([16,8,128], n3(:,8970), t3x128(:,:,1045))
  call heltable([16,8,128], n3(:,8971), t3x128(:,:,1046))
  call heltable([16,8,128], n3(:,8972), t3x128(:,:,1047))
  call heltable([16,8,128], n3(:,8973), t3x128(:,:,1048))
  call heltable([16,8,128], n3(:,8974), t3x128(:,:,1049))
  call heltable([16,8,128], n3(:,8975), t3x128(:,:,1050))
  call heltable([16,8,128], n3(:,8976), t3x128(:,:,1051))
  call heltable([16,8,128], n3(:,8977), t3x128(:,:,1052))
  call heltable([16,8,128], n3(:,8978), t3x128(:,:,1053))
  call heltable([16,8,128], n3(:,8979), t3x128(:,:,1054))
  call heltable([16,8,128], n3(:,8980), t3x128(:,:,1055))
  call heltable([16,8,128], n3(:,8981), t3x128(:,:,1056))
  call heltable([16,8,128], n3(:,8982), t3x128(:,:,1057))
  call heltable([16,8,128], n3(:,8983), t3x128(:,:,1058))
  call heltable([16,8,128], n3(:,8984), t3x128(:,:,1059))
  call heltable([16,8,128], n3(:,8985), t3x128(:,:,1060))
  call heltable([16,8,128], n3(:,8986), t3x128(:,:,1061))
  call heltable([16,8,128], n3(:,8987), t3x128(:,:,1062))
  call heltable([16,8,128], n3(:,8988), t3x128(:,:,1063))
  call heltable([16,8,128], n3(:,8989), t3x128(:,:,1064))
  call heltable([16,8,128], n3(:,8990), t3x128(:,:,1065))
  call heltable([16,8,128], n3(:,8991), t3x128(:,:,1066))
  call heltable([16,8,128], n3(:,8992), t3x128(:,:,1067))
  call heltable([16,8,128], n3(:,8993), t3x128(:,:,1068))
  call heltable([8,16,128], n3(:,8994), t3x128(:,:,1069))
  call heltable([8,16,128], n3(:,8995), t3x128(:,:,1070))
  call heltable([8,16,128], n3(:,8996), t3x128(:,:,1071))
  call heltable([8,16,128], n3(:,8997), t3x128(:,:,1072))
  call heltable([8,16,128], n3(:,8998), t3x128(:,:,1073))
  call heltable([8,16,128], n3(:,8999), t3x128(:,:,1074))
  call heltable([8,16,128], n3(:,9000), t3x128(:,:,1075))
  call heltable([8,16,128], n3(:,9001), t3x128(:,:,1076))
  call heltable([8,16,128], n3(:,9002), t3x128(:,:,1077))
  call heltable([8,16,128], n3(:,9003), t3x128(:,:,1078))
  call heltable([8,16,128], n3(:,9004), t3x128(:,:,1079))
  call heltable([8,16,128], n3(:,9005), t3x128(:,:,1080))
  call heltable([8,16,128], n3(:,9006), t3x128(:,:,1081))
  call heltable([8,16,128], n3(:,9007), t3x128(:,:,1082))
  call heltable([8,16,128], n3(:,9008), t3x128(:,:,1083))
  call heltable([8,16,128], n3(:,9009), t3x128(:,:,1084))
  call heltable([8,16,128], n3(:,9010), t3x128(:,:,1085))
  call heltable([8,16,128], n3(:,9011), t3x128(:,:,1086))
  call heltable([8,16,128], n3(:,9012), t3x128(:,:,1087))
  call heltable([8,16,128], n3(:,9013), t3x128(:,:,1088))
  call heltable([8,16,128], n3(:,9014), t3x128(:,:,1089))
  call heltable([8,16,128], n3(:,9015), t3x128(:,:,1090))
  call heltable([8,16,128], n3(:,9016), t3x128(:,:,1091))
  call heltable([8,16,128], n3(:,9017), t3x128(:,:,1092))
  call heltable([8,16,128], n3(:,9018), t3x128(:,:,1093))
  call heltable([8,16,128], n3(:,9019), t3x128(:,:,1094))
  call heltable([8,16,128], n3(:,9020), t3x128(:,:,1095))
  call heltable([8,16,128], n3(:,9021), t3x128(:,:,1096))
  call heltable([8,16,128], n3(:,9022), t3x128(:,:,1097))
  call heltable([8,16,128], n3(:,9023), t3x128(:,:,1098))
  call heltable([8,16,128], n3(:,9024), t3x128(:,:,1099))
  call heltable([8,16,128], n3(:,9025), t3x128(:,:,1100))
  call heltable([16,8,128], n3(:,9026), t3x128(:,:,1101))
  call heltable([16,8,128], n3(:,9027), t3x128(:,:,1102))
  call heltable([16,8,128], n3(:,9028), t3x128(:,:,1103))
  call heltable([16,8,128], n3(:,9029), t3x128(:,:,1104))
  call heltable([16,8,128], n3(:,9030), t3x128(:,:,1105))
  call heltable([16,8,128], n3(:,9031), t3x128(:,:,1106))
  call heltable([16,8,128], n3(:,9032), t3x128(:,:,1107))
  call heltable([16,8,128], n3(:,9033), t3x128(:,:,1108))
  call heltable([16,8,128], n3(:,9034), t3x128(:,:,1109))
  call heltable([16,8,128], n3(:,9035), t3x128(:,:,1110))
  call heltable([16,8,128], n3(:,9036), t3x128(:,:,1111))
  call heltable([16,8,128], n3(:,9037), t3x128(:,:,1112))
  call heltable([16,8,128], n3(:,9038), t3x128(:,:,1113))
  call heltable([16,8,128], n3(:,9039), t3x128(:,:,1114))
  call heltable([16,8,128], n3(:,9040), t3x128(:,:,1115))
  call heltable([16,8,128], n3(:,9041), t3x128(:,:,1116))
  call heltable([8,16,128], n3(:,9042), t3x128(:,:,1117))
  call heltable([8,16,128], n3(:,9043), t3x128(:,:,1118))
  call heltable([8,16,128], n3(:,9044), t3x128(:,:,1119))
  call heltable([8,16,128], n3(:,9045), t3x128(:,:,1120))
  call heltable([8,16,128], n3(:,9046), t3x128(:,:,1121))
  call heltable([8,16,128], n3(:,9047), t3x128(:,:,1122))
  call heltable([8,16,128], n3(:,9048), t3x128(:,:,1123))
  call heltable([8,16,128], n3(:,9049), t3x128(:,:,1124))
  call heltable([8,16,128], n3(:,9050), t3x128(:,:,1125))
  call heltable([8,16,128], n3(:,9051), t3x128(:,:,1126))
  call heltable([8,16,128], n3(:,9052), t3x128(:,:,1127))
  call heltable([8,16,128], n3(:,9053), t3x128(:,:,1128))
  call heltable([8,16,128], n3(:,9054), t3x128(:,:,1129))
  call heltable([8,16,128], n3(:,9055), t3x128(:,:,1130))
  call heltable([8,16,128], n3(:,9056), t3x128(:,:,1131))
  call heltable([8,16,128], n3(:,9057), t3x128(:,:,1132))
  call heltable([8,16,128], n3(:,9058), t3x128(:,:,1133))
  call heltable([8,16,128], n3(:,9059), t3x128(:,:,1134))
  call heltable([8,16,128], n3(:,9060), t3x128(:,:,1135))
  call heltable([8,16,128], n3(:,9061), t3x128(:,:,1136))
  call heltable([8,16,128], n3(:,9062), t3x128(:,:,1137))
  call heltable([8,16,128], n3(:,9063), t3x128(:,:,1138))
  call heltable([8,16,128], n3(:,9064), t3x128(:,:,1139))
  call heltable([8,16,128], n3(:,9065), t3x128(:,:,1140))
  call heltable([8,16,128], n3(:,9066), t3x128(:,:,1141))
  call heltable([8,16,128], n3(:,9067), t3x128(:,:,1142))
  call heltable([8,16,128], n3(:,9068), t3x128(:,:,1143))
  call heltable([8,16,128], n3(:,9069), t3x128(:,:,1144))
  call heltable([8,16,128], n3(:,9070), t3x128(:,:,1145))
  call heltable([8,16,128], n3(:,9071), t3x128(:,:,1146))
  call heltable([8,16,128], n3(:,9072), t3x128(:,:,1147))
  call heltable([8,16,128], n3(:,9073), t3x128(:,:,1148))
  call heltable([8,16,128], n3(:,9074), t3x128(:,:,1149))
  call heltable([8,16,128], n3(:,9075), t3x128(:,:,1150))
  call heltable([8,16,128], n3(:,9076), t3x128(:,:,1151))
  call heltable([8,16,128], n3(:,9077), t3x128(:,:,1152))
  call heltable([8,16,128], n3(:,9078), t3x128(:,:,1153))
  call heltable([8,16,128], n3(:,9079), t3x128(:,:,1154))
  call heltable([8,16,128], n3(:,9080), t3x128(:,:,1155))
  call heltable([8,16,128], n3(:,9081), t3x128(:,:,1156))
  call heltable([8,16,128], n3(:,9082), t3x128(:,:,1157))
  call heltable([8,16,128], n3(:,9083), t3x128(:,:,1158))
  call heltable([8,16,128], n3(:,9084), t3x128(:,:,1159))
  call heltable([8,16,128], n3(:,9085), t3x128(:,:,1160))
  call heltable([8,16,128], n3(:,9086), t3x128(:,:,1161))
  call heltable([8,16,128], n3(:,9087), t3x128(:,:,1162))
  call heltable([8,16,128], n3(:,9088), t3x128(:,:,1163))
  call heltable([8,16,128], n3(:,9089), t3x128(:,:,1164))
  call heltable([8,16,128], n3(:,9090), t3x128(:,:,1165))
  call heltable([8,16,128], n3(:,9091), t3x128(:,:,1166))
  call heltable([8,16,128], n3(:,9092), t3x128(:,:,1167))
  call heltable([8,16,128], n3(:,9093), t3x128(:,:,1168))
  call heltable([8,16,128], n3(:,9094), t3x128(:,:,1169))
  call heltable([8,16,128], n3(:,9095), t3x128(:,:,1170))
  call heltable([8,16,128], n3(:,9096), t3x128(:,:,1171))
  call heltable([8,16,128], n3(:,9097), t3x128(:,:,1172))
  call heltable([8,16,128], n3(:,9098), t3x128(:,:,1173))
  call heltable([8,16,128], n3(:,9099), t3x128(:,:,1174))
  call heltable([8,16,128], n3(:,9100), t3x128(:,:,1175))
  call heltable([8,16,128], n3(:,9101), t3x128(:,:,1176))
  call heltable([8,16,128], n3(:,9102), t3x128(:,:,1177))
  call heltable([8,16,128], n3(:,9103), t3x128(:,:,1178))
  call heltable([8,16,128], n3(:,9104), t3x128(:,:,1179))
  call heltable([8,16,128], n3(:,9105), t3x128(:,:,1180))
  call heltable([8,16,128], n3(:,9106), t3x128(:,:,1181))
  call heltable([8,16,128], n3(:,9107), t3x128(:,:,1182))
  call heltable([8,16,128], n3(:,9108), t3x128(:,:,1183))
  call heltable([8,16,128], n3(:,9109), t3x128(:,:,1184))
  call heltable([8,16,128], n3(:,9110), t3x128(:,:,1185))
  call heltable([8,16,128], n3(:,9111), t3x128(:,:,1186))
  call heltable([8,16,128], n3(:,9112), t3x128(:,:,1187))
  call heltable([8,16,128], n3(:,9113), t3x128(:,:,1188))
  call heltable([8,16,128], n3(:,9114), t3x128(:,:,1189))
  call heltable([8,16,128], n3(:,9115), t3x128(:,:,1190))
  call heltable([8,16,128], n3(:,9116), t3x128(:,:,1191))
  call heltable([8,16,128], n3(:,9117), t3x128(:,:,1192))
  call heltable([8,16,128], n3(:,9118), t3x128(:,:,1193))
  call heltable([8,16,128], n3(:,9119), t3x128(:,:,1194))
  call heltable([8,16,128], n3(:,9120), t3x128(:,:,1195))
  call heltable([8,16,128], n3(:,9121), t3x128(:,:,1196))
  call heltable([8,16,128], n3(:,9122), t3x128(:,:,1197))
  call heltable([8,16,128], n3(:,9123), t3x128(:,:,1198))
  call heltable([8,16,128], n3(:,9124), t3x128(:,:,1199))
  call heltable([8,16,128], n3(:,9125), t3x128(:,:,1200))
  call heltable([8,16,128], n3(:,9126), t3x128(:,:,1201))
  call heltable([8,16,128], n3(:,9127), t3x128(:,:,1202))
  call heltable([8,16,128], n3(:,9128), t3x128(:,:,1203))
  call heltable([8,16,128], n3(:,9129), t3x128(:,:,1204))
  call heltable([8,16,128], n3(:,9130), t3x128(:,:,1205))
  call heltable([8,16,128], n3(:,9131), t3x128(:,:,1206))
  call heltable([8,16,128], n3(:,9132), t3x128(:,:,1207))
  call heltable([8,16,128], n3(:,9133), t3x128(:,:,1208))
  call heltable([8,16,128], n3(:,9134), t3x128(:,:,1209))
  call heltable([8,16,128], n3(:,9135), t3x128(:,:,1210))
  call heltable([8,16,128], n3(:,9136), t3x128(:,:,1211))
  call heltable([8,16,128], n3(:,9137), t3x128(:,:,1212))
  call heltable([8,16,128], n3(:,9138), t3x128(:,:,1213))
  call heltable([8,16,128], n3(:,9139), t3x128(:,:,1214))
  call heltable([8,16,128], n3(:,9140), t3x128(:,:,1215))
  call heltable([8,16,128], n3(:,9141), t3x128(:,:,1216))
  call heltable([8,16,128], n3(:,9142), t3x128(:,:,1217))
  call heltable([8,16,128], n3(:,9143), t3x128(:,:,1218))
  call heltable([8,16,128], n3(:,9144), t3x128(:,:,1219))
  call heltable([8,16,128], n3(:,9145), t3x128(:,:,1220))
  call heltable([8,16,128], n3(:,9146), t3x128(:,:,1221))
  call heltable([8,16,128], n3(:,9147), t3x128(:,:,1222))
  call heltable([8,16,128], n3(:,9148), t3x128(:,:,1223))
  call heltable([8,16,128], n3(:,9149), t3x128(:,:,1224))
  call heltable([8,16,128], n3(:,9150), t3x128(:,:,1225))
  call heltable([8,16,128], n3(:,9151), t3x128(:,:,1226))
  call heltable([8,16,128], n3(:,9152), t3x128(:,:,1227))
  call heltable([8,16,128], n3(:,9153), t3x128(:,:,1228))
  call heltable([8,16,128], n3(:,9154), t3x128(:,:,1229))
  call heltable([8,16,128], n3(:,9155), t3x128(:,:,1230))
  call heltable([8,16,128], n3(:,9156), t3x128(:,:,1231))
  call heltable([8,16,128], n3(:,9157), t3x128(:,:,1232))
  call heltable([8,16,128], n3(:,9158), t3x128(:,:,1233))
  call heltable([8,16,128], n3(:,9159), t3x128(:,:,1234))
  call heltable([8,16,128], n3(:,9160), t3x128(:,:,1235))
  call heltable([8,16,128], n3(:,9161), t3x128(:,:,1236))
  call heltable([8,16,128], n3(:,9162), t3x128(:,:,1237))
  call heltable([8,16,128], n3(:,9163), t3x128(:,:,1238))
  call heltable([8,16,128], n3(:,9164), t3x128(:,:,1239))
  call heltable([8,16,128], n3(:,9165), t3x128(:,:,1240))
  call heltable([8,16,128], n3(:,9166), t3x128(:,:,1241))
  call heltable([8,16,128], n3(:,9167), t3x128(:,:,1242))
  call heltable([8,16,128], n3(:,9168), t3x128(:,:,1243))
  call heltable([8,16,128], n3(:,9169), t3x128(:,:,1244))
  call heltable([8,16,128], n3(:,9170), t3x128(:,:,1245))
  call heltable([8,16,128], n3(:,9171), t3x128(:,:,1246))
  call heltable([8,16,128], n3(:,9172), t3x128(:,:,1247))
  call heltable([8,16,128], n3(:,9173), t3x128(:,:,1248))
  call heltable([8,16,128], n3(:,9174), t3x128(:,:,1249))
  call heltable([8,16,128], n3(:,9175), t3x128(:,:,1250))
  call heltable([8,16,128], n3(:,9176), t3x128(:,:,1251))
  call heltable([8,16,128], n3(:,9177), t3x128(:,:,1252))
  call heltable([8,16,128], n3(:,9178), t3x128(:,:,1253))
  call heltable([8,16,128], n3(:,9179), t3x128(:,:,1254))
  call heltable([8,16,128], n3(:,9180), t3x128(:,:,1255))
  call heltable([8,16,128], n3(:,9181), t3x128(:,:,1256))
  call heltable([8,16,128], n3(:,9182), t3x128(:,:,1257))
  call heltable([8,16,128], n3(:,9183), t3x128(:,:,1258))
  call heltable([8,16,128], n3(:,9184), t3x128(:,:,1259))
  call heltable([8,16,128], n3(:,9185), t3x128(:,:,1260))
  call heltable([8,16,128], n3(:,9186), t3x128(:,:,1261))
  call heltable([8,16,128], n3(:,9187), t3x128(:,:,1262))
  call heltable([8,16,128], n3(:,9188), t3x128(:,:,1263))
  call heltable([8,16,128], n3(:,9189), t3x128(:,:,1264))
  call heltable([8,16,128], n3(:,9190), t3x128(:,:,1265))
  call heltable([8,16,128], n3(:,9191), t3x128(:,:,1266))
  call heltable([8,16,128], n3(:,9192), t3x128(:,:,1267))
  call heltable([8,16,128], n3(:,9193), t3x128(:,:,1268))
  call heltable([8,16,128], n3(:,9194), t3x128(:,:,1269))
  call heltable([8,16,128], n3(:,9195), t3x128(:,:,1270))
  call heltable([8,16,128], n3(:,9196), t3x128(:,:,1271))
  call heltable([8,16,128], n3(:,9197), t3x128(:,:,1272))
  call heltable([8,16,128], n3(:,9198), t3x128(:,:,1273))
  call heltable([8,16,128], n3(:,9199), t3x128(:,:,1274))
  call heltable([8,16,128], n3(:,9200), t3x128(:,:,1275))
  call heltable([8,16,128], n3(:,9201), t3x128(:,:,1276))
  call heltable([8,16,128], n3(:,9202), t3x128(:,:,1277))
  call heltable([8,16,128], n3(:,9203), t3x128(:,:,1278))
  call heltable([8,16,128], n3(:,9204), t3x128(:,:,1279))
  call heltable([8,16,128], n3(:,9205), t3x128(:,:,1280))
  call heltable([8,16,128], n3(:,9206), t3x128(:,:,1281))
  call heltable([8,16,128], n3(:,9207), t3x128(:,:,1282))
  call heltable([8,16,128], n3(:,9208), t3x128(:,:,1283))
  call heltable([8,16,128], n3(:,9209), t3x128(:,:,1284))
  call heltable([8,16,128], n3(:,9210), t3x128(:,:,1285))
  call heltable([8,16,128], n3(:,9211), t3x128(:,:,1286))
  call heltable([8,16,128], n3(:,9212), t3x128(:,:,1287))
  call heltable([8,16,128], n3(:,9213), t3x128(:,:,1288))
  call heltable([8,16,128], n3(:,9214), t3x128(:,:,1289))
  call heltable([8,16,128], n3(:,9215), t3x128(:,:,1290))
  call heltable([8,16,128], n3(:,9216), t3x128(:,:,1291))
  call heltable([8,16,128], n3(:,9217), t3x128(:,:,1292))
  call heltable([8,16,128], n3(:,9218), t3x128(:,:,1293))
  call heltable([8,16,128], n3(:,9219), t3x128(:,:,1294))
  call heltable([8,16,128], n3(:,9220), t3x128(:,:,1295))
  call heltable([8,16,128], n3(:,9221), t3x128(:,:,1296))
  call heltable([8,16,128], n3(:,9222), t3x128(:,:,1297))
  call heltable([8,16,128], n3(:,9223), t3x128(:,:,1298))
  call heltable([8,16,128], n3(:,9224), t3x128(:,:,1299))
  call heltable([8,16,128], n3(:,9225), t3x128(:,:,1300))
  call heltable([8,16,128], n3(:,9226), t3x128(:,:,1301))
  call heltable([8,16,128], n3(:,9227), t3x128(:,:,1302))
  call heltable([8,16,128], n3(:,9228), t3x128(:,:,1303))
  call heltable([8,16,128], n3(:,9229), t3x128(:,:,1304))
  call heltable([8,16,128], n3(:,9230), t3x128(:,:,1305))
  call heltable([8,16,128], n3(:,9231), t3x128(:,:,1306))
  call heltable([8,16,128], n3(:,9232), t3x128(:,:,1307))
  call heltable([8,16,128], n3(:,9233), t3x128(:,:,1308))
  call heltable([8,16,128], n3(:,9234), t3x128(:,:,1309))
  call heltable([8,16,128], n3(:,9235), t3x128(:,:,1310))
  call heltable([8,16,128], n3(:,9236), t3x128(:,:,1311))
  call heltable([8,16,128], n3(:,9237), t3x128(:,:,1312))
  call heltable([8,16,128], n3(:,9238), t3x128(:,:,1313))
  call heltable([8,16,128], n3(:,9239), t3x128(:,:,1314))
  call heltable([8,16,128], n3(:,9240), t3x128(:,:,1315))
  call heltable([8,16,128], n3(:,9241), t3x128(:,:,1316))
  call heltable([8,16,128], n3(:,9242), t3x128(:,:,1317))
  call heltable([8,16,128], n3(:,9243), t3x128(:,:,1318))
  call heltable([8,16,128], n3(:,9244), t3x128(:,:,1319))
  call heltable([8,16,128], n3(:,9245), t3x128(:,:,1320))
  call heltable([8,16,128], n3(:,9246), t3x128(:,:,1321))
  call heltable([8,16,128], n3(:,9247), t3x128(:,:,1322))
  call heltable([8,16,128], n3(:,9248), t3x128(:,:,1323))
  call heltable([8,16,128], n3(:,9249), t3x128(:,:,1324))
  call heltable([8,16,128], n3(:,9250), t3x128(:,:,1325))
  call heltable([8,16,128], n3(:,9251), t3x128(:,:,1326))
  call heltable([8,16,128], n3(:,9252), t3x128(:,:,1327))
  call heltable([8,16,128], n3(:,9253), t3x128(:,:,1328))
  call heltable([8,16,128], n3(:,9254), t3x128(:,:,1329))
  call heltable([8,16,128], n3(:,9255), t3x128(:,:,1330))
  call heltable([8,16,128], n3(:,9256), t3x128(:,:,1331))
  call heltable([8,16,128], n3(:,9257), t3x128(:,:,1332))
  call heltable([8,16,128], n3(:,9258), t3x128(:,:,1333))
  call heltable([8,16,128], n3(:,9259), t3x128(:,:,1334))
  call heltable([8,16,128], n3(:,9260), t3x128(:,:,1335))
  call heltable([8,16,128], n3(:,9261), t3x128(:,:,1336))
  call heltable([8,16,128], n3(:,9262), t3x128(:,:,1337))
  call heltable([8,16,128], n3(:,9263), t3x128(:,:,1338))
  call heltable([8,16,128], n3(:,9264), t3x128(:,:,1339))
  call heltable([8,16,128], n3(:,9265), t3x128(:,:,1340))
  call heltable([8,16,128], n3(:,9266), t3x128(:,:,1341))
  call heltable([8,16,128], n3(:,9267), t3x128(:,:,1342))
  call heltable([8,16,128], n3(:,9268), t3x128(:,:,1343))
  call heltable([8,16,128], n3(:,9269), t3x128(:,:,1344))
  call heltable([8,16,128], n3(:,9270), t3x128(:,:,1345))
  call heltable([8,16,128], n3(:,9271), t3x128(:,:,1346))
  call heltable([8,16,128], n3(:,9272), t3x128(:,:,1347))
  call heltable([8,16,128], n3(:,9273), t3x128(:,:,1348))
  call heltable([8,16,128], n3(:,9274), t3x128(:,:,1349))
  call heltable([8,16,128], n3(:,9275), t3x128(:,:,1350))
  call heltable([8,16,128], n3(:,9276), t3x128(:,:,1351))
  call heltable([8,16,128], n3(:,9277), t3x128(:,:,1352))
  call heltable([8,16,128], n3(:,9278), t3x128(:,:,1353))
  call heltable([8,16,128], n3(:,9279), t3x128(:,:,1354))
  call heltable([8,16,128], n3(:,9280), t3x128(:,:,1355))
  call heltable([8,16,128], n3(:,9281), t3x128(:,:,1356))
  call heltable([8,16,128], n3(:,9282), t3x128(:,:,1357))
  call heltable([8,16,128], n3(:,9283), t3x128(:,:,1358))
  call heltable([8,16,128], n3(:,9284), t3x128(:,:,1359))
  call heltable([8,16,128], n3(:,9285), t3x128(:,:,1360))
  call heltable([8,16,128], n3(:,9286), t3x128(:,:,1361))
  call heltable([8,16,128], n3(:,9287), t3x128(:,:,1362))
  call heltable([8,16,128], n3(:,9288), t3x128(:,:,1363))
  call heltable([8,16,128], n3(:,9289), t3x128(:,:,1364))
  call heltable([8,16,128], n3(:,9290), t3x128(:,:,1365))
  call heltable([8,16,128], n3(:,9291), t3x128(:,:,1366))
  call heltable([8,16,128], n3(:,9292), t3x128(:,:,1367))
  call heltable([8,16,128], n3(:,9293), t3x128(:,:,1368))
  call heltable([8,16,128], n3(:,9294), t3x128(:,:,1369))
  call heltable([8,16,128], n3(:,9295), t3x128(:,:,1370))
  call heltable([8,16,128], n3(:,9296), t3x128(:,:,1371))
  call heltable([8,16,128], n3(:,9297), t3x128(:,:,1372))
  call heltable([8,16,128], n3(:,9298), t3x128(:,:,1373))
  call heltable([8,16,128], n3(:,9299), t3x128(:,:,1374))
  call heltable([8,16,128], n3(:,9300), t3x128(:,:,1375))
  call heltable([8,16,128], n3(:,9301), t3x128(:,:,1376))
  call heltable([8,16,128], n3(:,9302), t3x128(:,:,1377))
  call heltable([8,16,128], n3(:,9303), t3x128(:,:,1378))
  call heltable([8,16,128], n3(:,9304), t3x128(:,:,1379))
  call heltable([8,16,128], n3(:,9305), t3x128(:,:,1380))
  call heltable([8,16,128], n3(:,9306), t3x128(:,:,1381))
  call heltable([8,16,128], n3(:,9307), t3x128(:,:,1382))
  call heltable([8,16,128], n3(:,9308), t3x128(:,:,1383))
  call heltable([8,16,128], n3(:,9309), t3x128(:,:,1384))
  call heltable([8,16,128], n3(:,9310), t3x128(:,:,1385))
  call heltable([8,16,128], n3(:,9311), t3x128(:,:,1386))
  call heltable([8,16,128], n3(:,9312), t3x128(:,:,1387))
  call heltable([8,16,128], n3(:,9313), t3x128(:,:,1388))
  call heltable([8,16,128], n3(:,9314), t3x128(:,:,1389))
  call heltable([8,16,128], n3(:,9315), t3x128(:,:,1390))
  call heltable([8,16,128], n3(:,9316), t3x128(:,:,1391))
  call heltable([8,16,128], n3(:,9317), t3x128(:,:,1392))
  call heltable([8,16,128], n3(:,9318), t3x128(:,:,1393))
  call heltable([8,16,128], n3(:,9319), t3x128(:,:,1394))
  call heltable([8,16,128], n3(:,9320), t3x128(:,:,1395))
  call heltable([8,16,128], n3(:,9321), t3x128(:,:,1396))
  call heltable([8,16,128], n3(:,9322), t3x128(:,:,1397))
  call heltable([8,16,128], n3(:,9323), t3x128(:,:,1398))
  call heltable([8,16,128], n3(:,9324), t3x128(:,:,1399))
  call heltable([8,16,128], n3(:,9325), t3x128(:,:,1400))
  call heltable([8,16,128], n3(:,9326), t3x128(:,:,1401))
  call heltable([8,16,128], n3(:,9327), t3x128(:,:,1402))
  call heltable([8,16,128], n3(:,9328), t3x128(:,:,1403))
  call heltable([8,16,128], n3(:,9329), t3x128(:,:,1404))
  call heltable([8,16,128], n3(:,9330), t3x128(:,:,1405))
  call heltable([8,16,128], n3(:,9331), t3x128(:,:,1406))
  call heltable([8,16,128], n3(:,9332), t3x128(:,:,1407))
  call heltable([8,16,128], n3(:,9333), t3x128(:,:,1408))
  call heltable([8,16,128], n3(:,9334), t3x128(:,:,1409))
  call heltable([8,16,128], n3(:,9335), t3x128(:,:,1410))
  call heltable([8,16,128], n3(:,9336), t3x128(:,:,1411))
  call heltable([8,16,128], n3(:,9337), t3x128(:,:,1412))
  call heltable([8,16,128], n3(:,9338), t3x128(:,:,1413))
  call heltable([8,16,128], n3(:,9339), t3x128(:,:,1414))
  call heltable([8,16,128], n3(:,9340), t3x128(:,:,1415))
  call heltable([8,16,128], n3(:,9341), t3x128(:,:,1416))
  call heltable([8,16,128], n3(:,9342), t3x128(:,:,1417))
  call heltable([8,16,128], n3(:,9343), t3x128(:,:,1418))
  call heltable([8,16,128], n3(:,9344), t3x128(:,:,1419))
  call heltable([8,16,128], n3(:,9345), t3x128(:,:,1420))
  call heltable([8,16,128], n3(:,9346), t3x128(:,:,1421))
  call heltable([8,16,128], n3(:,9347), t3x128(:,:,1422))
  call heltable([8,16,128], n3(:,9348), t3x128(:,:,1423))
  call heltable([8,16,128], n3(:,9349), t3x128(:,:,1424))
  call heltable([8,16,128], n3(:,9350), t3x128(:,:,1425))
  call heltable([8,16,128], n3(:,9351), t3x128(:,:,1426))
  call heltable([8,16,128], n3(:,9352), t3x128(:,:,1427))
  call heltable([8,16,128], n3(:,9353), t3x128(:,:,1428))
  call heltable([8,16,128], n3(:,9354), t3x128(:,:,1429))
  call heltable([8,16,128], n3(:,9355), t3x128(:,:,1430))
  call heltable([8,16,128], n3(:,9356), t3x128(:,:,1431))
  call heltable([8,16,128], n3(:,9357), t3x128(:,:,1432))
  call heltable([8,16,128], n3(:,9358), t3x128(:,:,1433))
  call heltable([8,16,128], n3(:,9359), t3x128(:,:,1434))
  call heltable([8,16,128], n3(:,9360), t3x128(:,:,1435))
  call heltable([8,16,128], n3(:,9361), t3x128(:,:,1436))
  call heltable([8,16,128], n3(:,9362), t3x128(:,:,1437))
  call heltable([8,16,128], n3(:,9363), t3x128(:,:,1438))
  call heltable([8,16,128], n3(:,9364), t3x128(:,:,1439))
  call heltable([8,16,128], n3(:,9365), t3x128(:,:,1440))
  call heltable([8,16,128], n3(:,9366), t3x128(:,:,1441))
  call heltable([8,16,128], n3(:,9367), t3x128(:,:,1442))
  call heltable([8,16,128], n3(:,9368), t3x128(:,:,1443))
  call heltable([8,16,128], n3(:,9369), t3x128(:,:,1444))
  call heltable([8,16,128], n3(:,9370), t3x128(:,:,1445))
  call heltable([8,16,128], n3(:,9371), t3x128(:,:,1446))
  call heltable([8,16,128], n3(:,9372), t3x128(:,:,1447))
  call heltable([8,16,128], n3(:,9373), t3x128(:,:,1448))
  call heltable([8,16,128], n3(:,9374), t3x128(:,:,1449))
  call heltable([8,16,128], n3(:,9375), t3x128(:,:,1450))
  call heltable([8,16,128], n3(:,9376), t3x128(:,:,1451))
  call heltable([8,16,128], n3(:,9377), t3x128(:,:,1452))
  call heltable([8,16,128], n3(:,9378), t3x128(:,:,1453))
  call heltable([8,16,128], n3(:,9379), t3x128(:,:,1454))
  call heltable([8,16,128], n3(:,9380), t3x128(:,:,1455))
  call heltable([8,16,128], n3(:,9381), t3x128(:,:,1456))
  call heltable([8,16,128], n3(:,9382), t3x128(:,:,1457))
  call heltable([8,16,128], n3(:,9383), t3x128(:,:,1458))
  call heltable([8,16,128], n3(:,9384), t3x128(:,:,1459))
  call heltable([8,16,128], n3(:,9385), t3x128(:,:,1460))
  call heltable([8,16,128], n3(:,9386), t3x128(:,:,1461))
  call heltable([8,16,128], n3(:,9387), t3x128(:,:,1462))
  call heltable([8,16,128], n3(:,9388), t3x128(:,:,1463))
  call heltable([8,16,128], n3(:,9389), t3x128(:,:,1464))
  call heltable([8,16,128], n3(:,9390), t3x128(:,:,1465))
  call heltable([8,16,128], n3(:,9391), t3x128(:,:,1466))
  call heltable([8,16,128], n3(:,9392), t3x128(:,:,1467))
  call heltable([8,16,128], n3(:,9393), t3x128(:,:,1468))
  call heltable([8,16,128], n3(:,9394), t3x128(:,:,1469))
  call heltable([8,16,128], n3(:,9395), t3x128(:,:,1470))
  call heltable([8,16,128], n3(:,9396), t3x128(:,:,1471))
  call heltable([8,16,128], n3(:,9397), t3x128(:,:,1472))
  call heltable([8,16,128], n3(:,9398), t3x128(:,:,1473))
  call heltable([8,16,128], n3(:,9399), t3x128(:,:,1474))
  call heltable([8,16,128], n3(:,9400), t3x128(:,:,1475))
  call heltable([8,16,128], n3(:,9401), t3x128(:,:,1476))
  call heltable([8,16,128], n3(:,9402), t3x128(:,:,1477))
  call heltable([8,16,128], n3(:,9403), t3x128(:,:,1478))
  call heltable([8,16,128], n3(:,9404), t3x128(:,:,1479))
  call heltable([8,16,128], n3(:,9405), t3x128(:,:,1480))
  call heltable([8,16,128], n3(:,9406), t3x128(:,:,1481))
  call heltable([8,16,128], n3(:,9407), t3x128(:,:,1482))
  call heltable([8,16,128], n3(:,9408), t3x128(:,:,1483))
  call heltable([8,16,128], n3(:,9409), t3x128(:,:,1484))
  call heltable([8,16,128], n3(:,9410), t3x128(:,:,1485))
  call heltable([8,16,128], n3(:,9411), t3x128(:,:,1486))
  call heltable([8,16,128], n3(:,9412), t3x128(:,:,1487))
  call heltable([8,16,128], n3(:,9413), t3x128(:,:,1488))
  call heltable([8,16,128], n3(:,9414), t3x128(:,:,1489))
  call heltable([8,16,128], n3(:,9415), t3x128(:,:,1490))
  call heltable([8,16,128], n3(:,9416), t3x128(:,:,1491))
  call heltable([8,16,128], n3(:,9417), t3x128(:,:,1492))
  call heltable([8,16,128], n3(:,9418), t3x128(:,:,1493))
  call heltable([8,16,128], n3(:,9419), t3x128(:,:,1494))
  call heltable([8,16,128], n3(:,9420), t3x128(:,:,1495))
  call heltable([8,16,128], n3(:,9421), t3x128(:,:,1496))
  call heltable([8,16,128], n3(:,9422), t3x128(:,:,1497))
  call heltable([8,16,128], n3(:,9423), t3x128(:,:,1498))
  call heltable([8,16,128], n3(:,9424), t3x128(:,:,1499))
  call heltable([8,16,128], n3(:,9425), t3x128(:,:,1500))
  call heltable([4,32,128], n3(:,9426), t3x128(:,:,1501))
  call heltable([4,32,128], n3(:,9427), t3x128(:,:,1502))
  call heltable([4,32,128], n3(:,9428), t3x128(:,:,1503))
  call heltable([4,32,128], n3(:,9429), t3x128(:,:,1504))
  call heltable([4,32,128], n3(:,9430), t3x128(:,:,1505))
  call heltable([4,32,128], n3(:,9431), t3x128(:,:,1506))
  call heltable([4,32,128], n3(:,9432), t3x128(:,:,1507))
  call heltable([4,32,128], n3(:,9433), t3x128(:,:,1508))
  call heltable([4,32,128], n3(:,9434), t3x128(:,:,1509))
  call heltable([4,32,128], n3(:,9435), t3x128(:,:,1510))
  call heltable([4,32,128], n3(:,9436), t3x128(:,:,1511))
  call heltable([4,32,128], n3(:,9437), t3x128(:,:,1512))
  call heltable([4,32,128], n3(:,9438), t3x128(:,:,1513))
  call heltable([4,32,128], n3(:,9439), t3x128(:,:,1514))
  call heltable([4,32,128], n3(:,9440), t3x128(:,:,1515))
  call heltable([4,32,128], n3(:,9441), t3x128(:,:,1516))
  call heltable([4,32,128], n3(:,9442), t3x128(:,:,1517))
  call heltable([4,32,128], n3(:,9443), t3x128(:,:,1518))
  call heltable([4,32,128], n3(:,9444), t3x128(:,:,1519))
  call heltable([4,32,128], n3(:,9445), t3x128(:,:,1520))
  call heltable([4,32,128], n3(:,9446), t3x128(:,:,1521))
  call heltable([4,32,128], n3(:,9447), t3x128(:,:,1522))
  call heltable([4,32,128], n3(:,9448), t3x128(:,:,1523))
  call heltable([4,32,128], n3(:,9449), t3x128(:,:,1524))
  call heltable([4,32,128], n3(:,9450), t3x128(:,:,1525))
  call heltable([4,32,128], n3(:,9451), t3x128(:,:,1526))
  call heltable([4,32,128], n3(:,9452), t3x128(:,:,1527))
  call heltable([4,32,128], n3(:,9453), t3x128(:,:,1528))
  call heltable([4,32,128], n3(:,9454), t3x128(:,:,1529))
  call heltable([4,32,128], n3(:,9455), t3x128(:,:,1530))
  call heltable([4,32,128], n3(:,9456), t3x128(:,:,1531))
  call heltable([4,32,128], n3(:,9457), t3x128(:,:,1532))
  call heltable([4,32,128], n3(:,9458), t3x128(:,:,1533))
  call heltable([4,32,128], n3(:,9459), t3x128(:,:,1534))
  call heltable([4,32,128], n3(:,9460), t3x128(:,:,1535))
  call heltable([4,32,128], n3(:,9461), t3x128(:,:,1536))
  call heltable([4,32,128], n3(:,9462), t3x128(:,:,1537))
  call heltable([4,32,128], n3(:,9463), t3x128(:,:,1538))
  call heltable([4,32,128], n3(:,9464), t3x128(:,:,1539))
  call heltable([4,32,128], n3(:,9465), t3x128(:,:,1540))
  call heltable([16,8,128], n3(:,9466), t3x128(:,:,1541))
  call heltable([16,8,128], n3(:,9467), t3x128(:,:,1542))
  call heltable([16,8,128], n3(:,9468), t3x128(:,:,1543))
  call heltable([16,8,128], n3(:,9469), t3x128(:,:,1544))
  call heltable([16,8,128], n3(:,9470), t3x128(:,:,1545))
  call heltable([16,8,128], n3(:,9471), t3x128(:,:,1546))
  call heltable([16,8,128], n3(:,9472), t3x128(:,:,1547))
  call heltable([16,8,128], n3(:,9473), t3x128(:,:,1548))
  call heltable([16,8,128], n3(:,9474), t3x128(:,:,1549))
  call heltable([16,8,128], n3(:,9475), t3x128(:,:,1550))
  call heltable([16,8,128], n3(:,9476), t3x128(:,:,1551))
  call heltable([16,8,128], n3(:,9477), t3x128(:,:,1552))
  call heltable([16,8,128], n3(:,9478), t3x128(:,:,1553))
  call heltable([16,8,128], n3(:,9479), t3x128(:,:,1554))
  call heltable([16,8,128], n3(:,9480), t3x128(:,:,1555))
  call heltable([16,8,128], n3(:,9481), t3x128(:,:,1556))
  call heltable([16,8,128], n3(:,9482), t3x128(:,:,1557))
  call heltable([16,8,128], n3(:,9483), t3x128(:,:,1558))
  call heltable([16,8,128], n3(:,9484), t3x128(:,:,1559))
  call heltable([16,8,128], n3(:,9485), t3x128(:,:,1560))
  call heltable([16,8,128], n3(:,9486), t3x128(:,:,1561))
  call heltable([16,8,128], n3(:,9487), t3x128(:,:,1562))
  call heltable([16,8,128], n3(:,9488), t3x128(:,:,1563))
  call heltable([16,8,128], n3(:,9489), t3x128(:,:,1564))
  call heltable([16,8,128], n3(:,9490), t3x128(:,:,1565))
  call heltable([16,8,128], n3(:,9491), t3x128(:,:,1566))
  call heltable([16,8,128], n3(:,9492), t3x128(:,:,1567))
  call heltable([16,8,128], n3(:,9493), t3x128(:,:,1568))
  call heltable([16,8,128], n3(:,9494), t3x128(:,:,1569))
  call heltable([16,8,128], n3(:,9495), t3x128(:,:,1570))
  call heltable([16,8,128], n3(:,9496), t3x128(:,:,1571))
  call heltable([16,8,128], n3(:,9497), t3x128(:,:,1572))
  call heltable([16,8,128], n3(:,9498), t3x128(:,:,1573))
  call heltable([16,8,128], n3(:,9499), t3x128(:,:,1574))
  call heltable([16,8,128], n3(:,9500), t3x128(:,:,1575))
  call heltable([16,8,128], n3(:,9501), t3x128(:,:,1576))
  call heltable([16,8,128], n3(:,9502), t3x128(:,:,1577))
  call heltable([16,8,128], n3(:,9503), t3x128(:,:,1578))
  call heltable([16,8,128], n3(:,9504), t3x128(:,:,1579))
  call heltable([16,8,128], n3(:,9505), t3x128(:,:,1580))
  call heltable([16,8,128], n3(:,9506), t3x128(:,:,1581))
  call heltable([16,8,128], n3(:,9507), t3x128(:,:,1582))
  call heltable([16,8,128], n3(:,9508), t3x128(:,:,1583))
  call heltable([16,8,128], n3(:,9509), t3x128(:,:,1584))
  call heltable([16,8,128], n3(:,9510), t3x128(:,:,1585))
  call heltable([16,8,128], n3(:,9511), t3x128(:,:,1586))
  call heltable([16,8,128], n3(:,9512), t3x128(:,:,1587))
  call heltable([16,8,128], n3(:,9513), t3x128(:,:,1588))
  call heltable([16,8,128], n3(:,9514), t3x128(:,:,1589))
  call heltable([16,8,128], n3(:,9515), t3x128(:,:,1590))
  call heltable([16,8,128], n3(:,9516), t3x128(:,:,1591))
  call heltable([16,8,128], n3(:,9517), t3x128(:,:,1592))
  call heltable([16,8,128], n3(:,9518), t3x128(:,:,1593))
  call heltable([16,8,128], n3(:,9519), t3x128(:,:,1594))
  call heltable([16,8,128], n3(:,9520), t3x128(:,:,1595))
  call heltable([16,8,128], n3(:,9521), t3x128(:,:,1596))
  call heltable([16,8,128], n3(:,9522), t3x128(:,:,1597))
  call heltable([16,8,128], n3(:,9523), t3x128(:,:,1598))
  call heltable([16,8,128], n3(:,9524), t3x128(:,:,1599))
  call heltable([16,8,128], n3(:,9525), t3x128(:,:,1600))
  call heltable([16,8,128], n3(:,9526), t3x128(:,:,1601))
  call heltable([16,8,128], n3(:,9527), t3x128(:,:,1602))
  call heltable([16,8,128], n3(:,9528), t3x128(:,:,1603))
  call heltable([16,8,128], n3(:,9529), t3x128(:,:,1604))
  call heltable([16,8,128], n3(:,9530), t3x128(:,:,1605))
  call heltable([16,8,128], n3(:,9531), t3x128(:,:,1606))
  call heltable([16,8,128], n3(:,9532), t3x128(:,:,1607))
  call heltable([16,8,128], n3(:,9533), t3x128(:,:,1608))
  call heltable([16,8,128], n3(:,9534), t3x128(:,:,1609))
  call heltable([8,16,128], n3(:,9535), t3x128(:,:,1610))
  call heltable([8,16,128], n3(:,9536), t3x128(:,:,1611))
  call heltable([8,16,128], n3(:,9537), t3x128(:,:,1612))
  call heltable([8,16,128], n3(:,9538), t3x128(:,:,1613))
  call heltable([8,16,128], n3(:,9539), t3x128(:,:,1614))
  call heltable([8,16,128], n3(:,9540), t3x128(:,:,1615))
  call heltable([8,16,128], n3(:,9541), t3x128(:,:,1616))
  call heltable([8,16,128], n3(:,9542), t3x128(:,:,1617))
  call heltable([8,16,128], n3(:,9543), t3x128(:,:,1618))
  call heltable([8,16,128], n3(:,9544), t3x128(:,:,1619))
  call heltable([8,16,128], n3(:,9545), t3x128(:,:,1620))
  call heltable([8,16,128], n3(:,9546), t3x128(:,:,1621))
  call heltable([8,16,128], n3(:,9547), t3x128(:,:,1622))
  call heltable([8,16,128], n3(:,9548), t3x128(:,:,1623))
  call heltable([8,16,128], n3(:,9549), t3x128(:,:,1624))
  call heltable([8,16,128], n3(:,9550), t3x128(:,:,1625))
  call heltable([8,16,128], n3(:,9551), t3x128(:,:,1626))
  call heltable([8,16,128], n3(:,9552), t3x128(:,:,1627))
  call heltable([8,16,128], n3(:,9553), t3x128(:,:,1628))
  call heltable([8,16,128], n3(:,9554), t3x128(:,:,1629))
  call heltable([8,16,128], n3(:,9555), t3x128(:,:,1630))
  call heltable([8,16,128], n3(:,9556), t3x128(:,:,1631))
  call heltable([8,16,128], n3(:,9557), t3x128(:,:,1632))
  call heltable([8,16,128], n3(:,9558), t3x128(:,:,1633))
  call heltable([8,16,128], n3(:,9559), t3x128(:,:,1634))
  call heltable([8,16,128], n3(:,9560), t3x128(:,:,1635))
  call heltable([8,16,128], n3(:,9561), t3x128(:,:,1636))
  call heltable([8,16,128], n3(:,9562), t3x128(:,:,1637))
  call heltable([8,16,128], n3(:,9563), t3x128(:,:,1638))
  call heltable([8,16,128], n3(:,9564), t3x128(:,:,1639))
  call heltable([8,16,128], n3(:,9565), t3x128(:,:,1640))
  call heltable([8,16,128], n3(:,9566), t3x128(:,:,1641))
  call heltable([8,16,128], n3(:,9567), t3x128(:,:,1642))
  call heltable([8,16,128], n3(:,9568), t3x128(:,:,1643))
  call heltable([8,16,128], n3(:,9569), t3x128(:,:,1644))
  call heltable([8,16,128], n3(:,9570), t3x128(:,:,1645))
  call heltable([8,16,128], n3(:,9571), t3x128(:,:,1646))
  call heltable([8,16,128], n3(:,9572), t3x128(:,:,1647))
  call heltable([8,16,128], n3(:,9573), t3x128(:,:,1648))
  call heltable([8,16,128], n3(:,9574), t3x128(:,:,1649))
  call heltable([8,16,128], n3(:,9575), t3x128(:,:,1650))
  call heltable([8,16,128], n3(:,9576), t3x128(:,:,1651))
  call heltable([8,16,128], n3(:,9577), t3x128(:,:,1652))
  call heltable([8,16,128], n3(:,9578), t3x128(:,:,1653))
  call heltable([8,16,128], n3(:,9579), t3x128(:,:,1654))
  call heltable([8,16,128], n3(:,9580), t3x128(:,:,1655))
  call heltable([8,16,128], n3(:,9581), t3x128(:,:,1656))
  call heltable([8,16,128], n3(:,9582), t3x128(:,:,1657))
  call heltable([8,16,128], n3(:,9583), t3x128(:,:,1658))
  call heltable([8,16,128], n3(:,9584), t3x128(:,:,1659))
  call heltable([8,16,128], n3(:,9585), t3x128(:,:,1660))
  call heltable([8,16,128], n3(:,9586), t3x128(:,:,1661))
  call heltable([8,16,128], n3(:,9587), t3x128(:,:,1662))
  call heltable([8,16,128], n3(:,9588), t3x128(:,:,1663))
  call heltable([8,16,128], n3(:,9589), t3x128(:,:,1664))
  call heltable([8,16,128], n3(:,9590), t3x128(:,:,1665))
  call heltable([8,16,128], n3(:,9591), t3x128(:,:,1666))
  call heltable([8,16,128], n3(:,9592), t3x128(:,:,1667))
  call heltable([8,16,128], n3(:,9593), t3x128(:,:,1668))
  call heltable([8,16,128], n3(:,9594), t3x128(:,:,1669))
  call heltable([8,16,128], n3(:,9595), t3x128(:,:,1670))
  call heltable([8,16,128], n3(:,9596), t3x128(:,:,1671))
  call heltable([8,16,128], n3(:,9597), t3x128(:,:,1672))
  call heltable([8,16,128], n3(:,9598), t3x128(:,:,1673))
  call heltable([8,16,128], n3(:,9599), t3x128(:,:,1674))
  call heltable([8,16,128], n3(:,9600), t3x128(:,:,1675))
  call heltable([8,16,128], n3(:,9601), t3x128(:,:,1676))
  call heltable([8,16,128], n3(:,9602), t3x128(:,:,1677))
  call heltable([8,16,128], n3(:,9603), t3x128(:,:,1678))
  call heltable([8,16,128], n3(:,9604), t3x128(:,:,1679))
  call heltable([8,16,128], n3(:,9605), t3x128(:,:,1680))
  call heltable([8,16,128], n3(:,9606), t3x128(:,:,1681))
  call heltable([8,16,128], n3(:,9607), t3x128(:,:,1682))
  call heltable([8,16,128], n3(:,9608), t3x128(:,:,1683))
  call heltable([8,16,128], n3(:,9609), t3x128(:,:,1684))
  call heltable([8,16,128], n3(:,9610), t3x128(:,:,1685))
  call heltable([8,16,128], n3(:,9611), t3x128(:,:,1686))
  call heltable([8,16,128], n3(:,9612), t3x128(:,:,1687))
  call heltable([8,16,128], n3(:,9613), t3x128(:,:,1688))
  call heltable([8,16,128], n3(:,9614), t3x128(:,:,1689))
  call heltable([8,16,128], n3(:,9615), t3x128(:,:,1690))
  call heltable([8,16,128], n3(:,9616), t3x128(:,:,1691))
  call heltable([8,16,128], n3(:,9617), t3x128(:,:,1692))
  call heltable([8,16,128], n3(:,9618), t3x128(:,:,1693))
  call heltable([8,16,128], n3(:,9619), t3x128(:,:,1694))
  call heltable([8,16,128], n3(:,9620), t3x128(:,:,1695))
  call heltable([8,16,128], n3(:,9621), t3x128(:,:,1696))
  call heltable([8,16,128], n3(:,9622), t3x128(:,:,1697))
  call heltable([8,16,128], n3(:,9623), t3x128(:,:,1698))
  call heltable([8,16,128], n3(:,9624), t3x128(:,:,1699))
  call heltable([8,16,128], n3(:,9625), t3x128(:,:,1700))
  call heltable([8,16,128], n3(:,9626), t3x128(:,:,1701))
  call heltable([8,16,128], n3(:,9627), t3x128(:,:,1702))
  call heltable([8,16,128], n3(:,9628), t3x128(:,:,1703))
  call heltable([8,16,128], n3(:,9629), t3x128(:,:,1704))
  call heltable([8,16,128], n3(:,9630), t3x128(:,:,1705))
  call heltable([8,16,128], n3(:,9631), t3x128(:,:,1706))
  call heltable([8,16,128], n3(:,9632), t3x128(:,:,1707))
  call heltable([8,16,128], n3(:,9633), t3x128(:,:,1708))
  call heltable([8,16,128], n3(:,9634), t3x128(:,:,1709))
  call heltable([8,16,128], n3(:,9635), t3x128(:,:,1710))
  call heltable([8,16,128], n3(:,9636), t3x128(:,:,1711))
  call heltable([8,16,128], n3(:,9637), t3x128(:,:,1712))
  call heltable([8,16,128], n3(:,9638), t3x128(:,:,1713))
  call heltable([8,16,128], n3(:,9639), t3x128(:,:,1714))
  call heltable([8,16,128], n3(:,9640), t3x128(:,:,1715))
  call heltable([8,16,128], n3(:,9641), t3x128(:,:,1716))
  call heltable([8,16,128], n3(:,9642), t3x128(:,:,1717))
  call heltable([8,16,128], n3(:,9643), t3x128(:,:,1718))
  call heltable([8,16,128], n3(:,9644), t3x128(:,:,1719))
  call heltable([8,16,128], n3(:,9645), t3x128(:,:,1720))
  call heltable([8,16,128], n3(:,9646), t3x128(:,:,1721))
  call heltable([8,16,128], n3(:,9647), t3x128(:,:,1722))
  call heltable([8,16,128], n3(:,9648), t3x128(:,:,1723))
  call heltable([8,16,128], n3(:,9649), t3x128(:,:,1724))
  call heltable([8,16,128], n3(:,9650), t3x128(:,:,1725))
  call heltable([8,16,128], n3(:,9651), t3x128(:,:,1726))
  call heltable([8,16,128], n3(:,9652), t3x128(:,:,1727))
  call heltable([8,16,128], n3(:,9653), t3x128(:,:,1728))
  call heltable([8,16,128], n3(:,9654), t3x128(:,:,1729))
  call heltable([8,16,128], n3(:,9655), t3x128(:,:,1730))
  call heltable([8,16,128], n3(:,9656), t3x128(:,:,1731))
  call heltable([8,16,128], n3(:,9657), t3x128(:,:,1732))
  call heltable([8,16,128], n3(:,9658), t3x128(:,:,1733))
  call heltable([8,16,128], n3(:,9659), t3x128(:,:,1734))
  call heltable([8,16,128], n3(:,9660), t3x128(:,:,1735))
  call heltable([8,16,128], n3(:,9661), t3x128(:,:,1736))
  call heltable([8,16,128], n3(:,9662), t3x128(:,:,1737))
  call heltable([8,16,128], n3(:,9663), t3x128(:,:,1738))
  call heltable([8,16,128], n3(:,9664), t3x128(:,:,1739))
  call heltable([8,16,128], n3(:,9665), t3x128(:,:,1740))
  call heltable([8,16,128], n3(:,9666), t3x128(:,:,1741))
  call heltable([8,16,128], n3(:,9667), t3x128(:,:,1742))
  call heltable([8,16,128], n3(:,9668), t3x128(:,:,1743))
  call heltable([8,16,128], n3(:,9669), t3x128(:,:,1744))
  call heltable([8,16,128], n3(:,9670), t3x128(:,:,1745))
  call heltable([8,16,128], n3(:,9671), t3x128(:,:,1746))
  call heltable([8,16,128], n3(:,9672), t3x128(:,:,1747))
  call heltable([8,16,128], n3(:,9673), t3x128(:,:,1748))
  call heltable([8,16,128], n3(:,9674), t3x128(:,:,1749))
  call heltable([8,16,128], n3(:,9675), t3x128(:,:,1750))
  call heltable([8,16,128], n3(:,9676), t3x128(:,:,1751))
  call heltable([8,16,128], n3(:,9677), t3x128(:,:,1752))
  call heltable([8,16,128], n3(:,9678), t3x128(:,:,1753))
  call heltable([8,16,128], n3(:,9679), t3x128(:,:,1754))
  call heltable([8,16,128], n3(:,9680), t3x128(:,:,1755))
  call heltable([8,16,128], n3(:,9681), t3x128(:,:,1756))
  call heltable([8,16,128], n3(:,9682), t3x128(:,:,1757))
  call heltable([8,16,128], n3(:,9683), t3x128(:,:,1758))
  call heltable([8,16,128], n3(:,9684), t3x128(:,:,1759))
  call heltable([8,16,128], n3(:,9685), t3x128(:,:,1760))
  call heltable([8,16,128], n3(:,9686), t3x128(:,:,1761))
  call heltable([8,16,128], n3(:,9687), t3x128(:,:,1762))
  call heltable([8,16,128], n3(:,9688), t3x128(:,:,1763))
  call heltable([8,16,128], n3(:,9689), t3x128(:,:,1764))
  call heltable([8,16,128], n3(:,9690), t3x128(:,:,1765))
  call heltable([8,16,128], n3(:,9691), t3x128(:,:,1766))
  call heltable([8,16,128], n3(:,9692), t3x128(:,:,1767))
  call heltable([8,16,128], n3(:,9693), t3x128(:,:,1768))
  call heltable([8,16,128], n3(:,9694), t3x128(:,:,1769))
  call heltable([8,16,128], n3(:,9695), t3x128(:,:,1770))
  call heltable([8,16,128], n3(:,9696), t3x128(:,:,1771))
  call heltable([8,16,128], n3(:,9697), t3x128(:,:,1772))
  call heltable([8,16,128], n3(:,9698), t3x128(:,:,1773))
  call heltable([8,16,128], n3(:,9699), t3x128(:,:,1774))
  call heltable([8,16,128], n3(:,9700), t3x128(:,:,1775))
  call heltable([8,16,128], n3(:,9701), t3x128(:,:,1776))
  call heltable([8,16,128], n3(:,9702), t3x128(:,:,1777))
  call heltable([8,16,128], n3(:,9703), t3x128(:,:,1778))
  call heltable([8,16,128], n3(:,9704), t3x128(:,:,1779))
  call heltable([8,16,128], n3(:,9705), t3x128(:,:,1780))
  call heltable([8,16,128], n3(:,9706), t3x128(:,:,1781))
  call heltable([8,16,128], n3(:,9707), t3x128(:,:,1782))
  call heltable([8,16,128], n3(:,9708), t3x128(:,:,1783))
  call heltable([8,16,128], n3(:,9709), t3x128(:,:,1784))
  call heltable([8,16,128], n3(:,9710), t3x128(:,:,1785))
  call heltable([8,16,128], n3(:,9711), t3x128(:,:,1786))
  call heltable([8,16,128], n3(:,9712), t3x128(:,:,1787))
  call heltable([8,16,128], n3(:,9713), t3x128(:,:,1788))
  call heltable([8,16,128], n3(:,9714), t3x128(:,:,1789))
  call heltable([8,16,128], n3(:,9715), t3x128(:,:,1790))
  call heltable([8,16,128], n3(:,9716), t3x128(:,:,1791))
  call heltable([8,16,128], n3(:,9717), t3x128(:,:,1792))
  call heltable([8,16,128], n3(:,9718), t3x128(:,:,1793))
  call heltable([8,16,128], n3(:,9719), t3x128(:,:,1794))
  call heltable([8,16,128], n3(:,9720), t3x128(:,:,1795))
  call heltable([8,16,128], n3(:,9721), t3x128(:,:,1796))
  call heltable([8,16,128], n3(:,9722), t3x128(:,:,1797))
  call heltable([8,16,128], n3(:,9723), t3x128(:,:,1798))
  call heltable([8,16,128], n3(:,9724), t3x128(:,:,1799))
  call heltable([8,16,128], n3(:,9725), t3x128(:,:,1800))
  call heltable([8,16,128], n3(:,9726), t3x128(:,:,1801))
  call heltable([8,16,128], n3(:,9727), t3x128(:,:,1802))
  call heltable([8,16,128], n3(:,9728), t3x128(:,:,1803))
  call heltable([8,16,128], n3(:,9729), t3x128(:,:,1804))
  call heltable([8,16,128], n3(:,9730), t3x128(:,:,1805))
  call heltable([8,16,128], n3(:,9731), t3x128(:,:,1806))
  call heltable([8,16,128], n3(:,9732), t3x128(:,:,1807))
  call heltable([8,16,128], n3(:,9733), t3x128(:,:,1808))
  call heltable([8,16,128], n3(:,9734), t3x128(:,:,1809))
  call heltable([8,16,128], n3(:,9735), t3x128(:,:,1810))
  call heltable([8,16,128], n3(:,9736), t3x128(:,:,1811))
  call heltable([8,16,128], n3(:,9737), t3x128(:,:,1812))
  call heltable([8,16,128], n3(:,9738), t3x128(:,:,1813))
  call heltable([8,16,128], n3(:,9739), t3x128(:,:,1814))
  call heltable([8,16,128], n3(:,9740), t3x128(:,:,1815))
  call heltable([8,16,128], n3(:,9741), t3x128(:,:,1816))
  call heltable([8,16,128], n3(:,9742), t3x128(:,:,1817))
  call heltable([8,16,128], n3(:,9743), t3x128(:,:,1818))
  call heltable([8,16,128], n3(:,9744), t3x128(:,:,1819))
  call heltable([8,16,128], n3(:,9745), t3x128(:,:,1820))
  call heltable([8,16,128], n3(:,9746), t3x128(:,:,1821))
  call heltable([8,16,128], n3(:,9747), t3x128(:,:,1822))
  call heltable([8,16,128], n3(:,9748), t3x128(:,:,1823))
  call heltable([8,16,128], n3(:,9749), t3x128(:,:,1824))
  call heltable([8,16,128], n3(:,9750), t3x128(:,:,1825))
  call heltable([8,16,128], n3(:,9751), t3x128(:,:,1826))
  call heltable([8,16,128], n3(:,9752), t3x128(:,:,1827))
  call heltable([8,16,128], n3(:,9753), t3x128(:,:,1828))
  call heltable([8,16,128], n3(:,9754), t3x128(:,:,1829))
  call heltable([8,16,128], n3(:,9755), t3x128(:,:,1830))
  call heltable([8,16,128], n3(:,9756), t3x128(:,:,1831))
  call heltable([8,16,128], n3(:,9757), t3x128(:,:,1832))
  call heltable([8,16,128], n3(:,9758), t3x128(:,:,1833))
  call heltable([8,16,128], n3(:,9759), t3x128(:,:,1834))
  call heltable([8,16,128], n3(:,9760), t3x128(:,:,1835))
  call heltable([8,16,128], n3(:,9761), t3x128(:,:,1836))
  call heltable([8,16,128], n3(:,9762), t3x128(:,:,1837))
  call heltable([8,16,128], n3(:,9763), t3x128(:,:,1838))
  call heltable([8,16,128], n3(:,9764), t3x128(:,:,1839))
  call heltable([8,16,128], n3(:,9765), t3x128(:,:,1840))
  call heltable([8,16,128], n3(:,9766), t3x128(:,:,1841))
  call heltable([8,16,128], n3(:,9767), t3x128(:,:,1842))
  call heltable([8,16,128], n3(:,9768), t3x128(:,:,1843))
  call heltable([8,16,128], n3(:,9769), t3x128(:,:,1844))
  call heltable([8,16,128], n3(:,9770), t3x128(:,:,1845))
  call heltable([8,16,128], n3(:,9771), t3x128(:,:,1846))
  call heltable([8,16,128], n3(:,9772), t3x128(:,:,1847))
  call heltable([8,16,128], n3(:,9773), t3x128(:,:,1848))
  call heltable([8,16,128], n3(:,9774), t3x128(:,:,1849))
  call heltable([8,16,128], n3(:,9775), t3x128(:,:,1850))
  call heltable([8,16,128], n3(:,9776), t3x128(:,:,1851))
  call heltable([8,16,128], n3(:,9777), t3x128(:,:,1852))
  call heltable([8,16,128], n3(:,9778), t3x128(:,:,1853))
  call heltable([8,16,128], n3(:,9779), t3x128(:,:,1854))
  call heltable([8,16,128], n3(:,9780), t3x128(:,:,1855))
  call heltable([8,16,128], n3(:,9781), t3x128(:,:,1856))
  call heltable([8,16,128], n3(:,9782), t3x128(:,:,1857))
  call heltable([16,8,128], n3(:,9783), t3x128(:,:,1858))
  call heltable([16,8,128], n3(:,9784), t3x128(:,:,1859))
  call heltable([16,8,128], n3(:,9785), t3x128(:,:,1860))
  call heltable([16,8,128], n3(:,9786), t3x128(:,:,1861))
  call heltable([16,8,128], n3(:,9787), t3x128(:,:,1862))
  call heltable([16,8,128], n3(:,9788), t3x128(:,:,1863))
  call heltable([16,8,128], n3(:,9789), t3x128(:,:,1864))
  call heltable([16,8,128], n3(:,9790), t3x128(:,:,1865))
  call heltable([16,8,128], n3(:,9791), t3x128(:,:,1866))
  call heltable([16,8,128], n3(:,9792), t3x128(:,:,1867))
  call heltable([16,8,128], n3(:,9793), t3x128(:,:,1868))
  call heltable([16,8,128], n3(:,9794), t3x128(:,:,1869))
  call heltable([16,8,128], n3(:,9795), t3x128(:,:,1870))
  call heltable([8,16,128], n3(:,9796), t3x128(:,:,1871))
  call heltable([16,8,128], n3(:,9797), t3x128(:,:,1872))
  call heltable([8,16,128], n3(:,9798), t3x128(:,:,1873))
  call heltable([8,16,128], n3(:,9799), t3x128(:,:,1874))
  call heltable([16,8,128], n3(:,9800), t3x128(:,:,1875))
  call heltable([16,8,128], n3(:,9801), t3x128(:,:,1876))
  call heltable([16,8,128], n3(:,9802), t3x128(:,:,1877))
  call heltable([16,8,128], n3(:,9803), t3x128(:,:,1878))
  call heltable([8,16,128], n3(:,9804), t3x128(:,:,1879))
  call heltable([8,16,128], n3(:,9805), t3x128(:,:,1880))
  call heltable([8,16,128], n3(:,9806), t3x128(:,:,1881))
  call heltable([8,16,128], n3(:,9807), t3x128(:,:,1882))
  call heltable([8,16,128], n3(:,9808), t3x128(:,:,1883))
  call heltable([8,16,128], n3(:,9809), t3x128(:,:,1884))
  call heltable([8,16,128], n3(:,9810), t3x128(:,:,1885))
  call heltable([8,16,128], n3(:,9811), t3x128(:,:,1886))
  call heltable([8,16,128], n3(:,9812), t3x128(:,:,1887))
  call heltable([8,16,128], n3(:,9813), t3x128(:,:,1888))
  call heltable([16,8,128], n3(:,9814), t3x128(:,:,1889))
  call heltable([16,8,128], n3(:,9815), t3x128(:,:,1890))
  call heltable([8,16,128], n3(:,9816), t3x128(:,:,1891))
  call heltable([8,16,128], n3(:,9817), t3x128(:,:,1892))
  call heltable([8,16,128], n3(:,9818), t3x128(:,:,1893))
  call heltable([8,16,128], n3(:,9819), t3x128(:,:,1894))
  call heltable([16,8,128], n3(:,9820), t3x128(:,:,1895))
  call heltable([16,8,128], n3(:,9821), t3x128(:,:,1896))
  call heltable([16,8,128], n3(:,9822), t3x128(:,:,1897))
  call heltable([16,8,128], n3(:,9823), t3x128(:,:,1898))
  call heltable([16,8,128], n3(:,9824), t3x128(:,:,1899))
  call heltable([16,8,128], n3(:,9825), t3x128(:,:,1900))
  call heltable([16,8,128], n3(:,9826), t3x128(:,:,1901))
  call heltable([16,8,128], n3(:,9827), t3x128(:,:,1902))
  call heltable([16,8,128], n3(:,9828), t3x128(:,:,1903))
  call heltable([16,8,128], n3(:,9829), t3x128(:,:,1904))
  call heltable([16,8,128], n3(:,9830), t3x128(:,:,1905))
  call heltable([16,8,128], n3(:,9831), t3x128(:,:,1906))
  call heltable([16,8,128], n3(:,9832), t3x128(:,:,1907))
  call heltable([16,8,128], n3(:,9833), t3x128(:,:,1908))
  call heltable([16,8,128], n3(:,9834), t3x128(:,:,1909))
  call heltable([16,8,128], n3(:,9835), t3x128(:,:,1910))
  call heltable([16,8,128], n3(:,9836), t3x128(:,:,1911))
  call heltable([16,8,128], n3(:,9837), t3x128(:,:,1912))
  call heltable([16,8,128], n3(:,9838), t3x128(:,:,1913))
  call heltable([16,8,128], n3(:,9839), t3x128(:,:,1914))
  call heltable([16,8,128], n3(:,9840), t3x128(:,:,1915))
  call heltable([16,8,128], n3(:,9841), t3x128(:,:,1916))
  call heltable([16,8,128], n3(:,9842), t3x128(:,:,1917))
  call heltable([16,8,128], n3(:,9843), t3x128(:,:,1918))
  call heltable([16,8,128], n3(:,9844), t3x128(:,:,1919))
  call heltable([16,8,128], n3(:,9845), t3x128(:,:,1920))
  call heltable([16,8,128], n3(:,9846), t3x128(:,:,1921))
  call heltable([16,8,128], n3(:,9847), t3x128(:,:,1922))
  call heltable([16,8,128], n3(:,9848), t3x128(:,:,1923))
  call heltable([16,8,128], n3(:,9849), t3x128(:,:,1924))
  call heltable([16,8,128], n3(:,9850), t3x128(:,:,1925))
  call heltable([16,8,128], n3(:,9851), t3x128(:,:,1926))
  call heltable([16,8,128], n3(:,9852), t3x128(:,:,1927))
  call heltable([16,8,128], n3(:,9853), t3x128(:,:,1928))
  call heltable([16,8,128], n3(:,9854), t3x128(:,:,1929))
  call heltable([16,8,128], n3(:,9855), t3x128(:,:,1930))
  call heltable([16,8,128], n3(:,9856), t3x128(:,:,1931))
  call heltable([16,8,128], n3(:,9857), t3x128(:,:,1932))
  call heltable([16,8,128], n3(:,9858), t3x128(:,:,1933))
  call heltable([16,8,128], n3(:,9859), t3x128(:,:,1934))
  call heltable([8,16,128], n3(:,9860), t3x128(:,:,1935))
  call heltable([8,16,128], n3(:,9861), t3x128(:,:,1936))
  call heltable([8,16,128], n3(:,9862), t3x128(:,:,1937))
  call heltable([8,16,128], n3(:,9863), t3x128(:,:,1938))
  call heltable([8,16,128], n3(:,9864), t3x128(:,:,1939))
  call heltable([8,16,128], n3(:,9865), t3x128(:,:,1940))
  call heltable([8,16,128], n3(:,9866), t3x128(:,:,1941))
  call heltable([8,16,128], n3(:,9867), t3x128(:,:,1942))
  call heltable([8,16,128], n3(:,9868), t3x128(:,:,1943))
  call heltable([8,16,128], n3(:,9869), t3x128(:,:,1944))
  call heltable([8,16,128], n3(:,9870), t3x128(:,:,1945))
  call heltable([8,16,128], n3(:,9871), t3x128(:,:,1946))
  call heltable([8,16,128], n3(:,9872), t3x128(:,:,1947))
  call heltable([8,16,128], n3(:,9873), t3x128(:,:,1948))
  call heltable([8,16,128], n3(:,9874), t3x128(:,:,1949))
  call heltable([8,16,128], n3(:,9875), t3x128(:,:,1950))
  call heltable([8,16,128], n3(:,9876), t3x128(:,:,1951))
  call heltable([8,16,128], n3(:,9877), t3x128(:,:,1952))
  call heltable([8,16,128], n3(:,9878), t3x128(:,:,1953))
  call heltable([8,16,128], n3(:,9879), t3x128(:,:,1954))
  call heltable([8,16,128], n3(:,9880), t3x128(:,:,1955))
  call heltable([8,16,128], n3(:,9881), t3x128(:,:,1956))
  call heltable([8,16,128], n3(:,9882), t3x128(:,:,1957))
  call heltable([8,16,128], n3(:,9883), t3x128(:,:,1958))
  call heltable([8,16,128], n3(:,9884), t3x128(:,:,1959))
  call heltable([8,16,128], n3(:,9885), t3x128(:,:,1960))
  call heltable([8,16,128], n3(:,9886), t3x128(:,:,1961))
  call heltable([8,16,128], n3(:,9887), t3x128(:,:,1962))
  call heltable([8,16,128], n3(:,9888), t3x128(:,:,1963))
  call heltable([8,16,128], n3(:,9889), t3x128(:,:,1964))
  call heltable([8,16,128], n3(:,9890), t3x128(:,:,1965))
  call heltable([8,16,128], n3(:,9891), t3x128(:,:,1966))
  call heltable([16,8,128], n3(:,9892), t3x128(:,:,1967))
  call heltable([16,8,128], n3(:,9893), t3x128(:,:,1968))
  call heltable([16,8,128], n3(:,9894), t3x128(:,:,1969))
  call heltable([16,8,128], n3(:,9895), t3x128(:,:,1970))
  call heltable([16,8,128], n3(:,9896), t3x128(:,:,1971))
  call heltable([16,8,128], n3(:,9897), t3x128(:,:,1972))
  call heltable([16,8,128], n3(:,9898), t3x128(:,:,1973))
  call heltable([16,8,128], n3(:,9899), t3x128(:,:,1974))
  call heltable([16,8,128], n3(:,9900), t3x128(:,:,1975))
  call heltable([16,8,128], n3(:,9901), t3x128(:,:,1976))
  call heltable([16,8,128], n3(:,9902), t3x128(:,:,1977))
  call heltable([16,8,128], n3(:,9903), t3x128(:,:,1978))
  call heltable([16,8,128], n3(:,9904), t3x128(:,:,1979))
  call heltable([16,8,128], n3(:,9905), t3x128(:,:,1980))
  call heltable([16,8,128], n3(:,9906), t3x128(:,:,1981))
  call heltable([16,8,128], n3(:,9907), t3x128(:,:,1982))
  call heltable([16,8,128], n3(:,9908), t3x128(:,:,1983))
  call heltable([16,8,128], n3(:,9909), t3x128(:,:,1984))
  call heltable([16,8,128], n3(:,9910), t3x128(:,:,1985))
  call heltable([16,8,128], n3(:,9911), t3x128(:,:,1986))
  call heltable([16,8,128], n3(:,9912), t3x128(:,:,1987))
  call heltable([16,8,128], n3(:,9913), t3x128(:,:,1988))
  call heltable([16,8,128], n3(:,9914), t3x128(:,:,1989))
  call heltable([16,8,128], n3(:,9915), t3x128(:,:,1990))
  call heltable([16,8,128], n3(:,9916), t3x128(:,:,1991))
  call heltable([16,8,128], n3(:,9917), t3x128(:,:,1992))
  call heltable([8,16,128], n3(:,9918), t3x128(:,:,1993))
  call heltable([16,8,128], n3(:,9919), t3x128(:,:,1994))
  call heltable([8,16,128], n3(:,9920), t3x128(:,:,1995))
  call heltable([8,16,128], n3(:,9921), t3x128(:,:,1996))
  call heltable([16,8,128], n3(:,9922), t3x128(:,:,1997))
  call heltable([16,8,128], n3(:,9923), t3x128(:,:,1998))
  call heltable([16,8,128], n3(:,9924), t3x128(:,:,1999))
  call heltable([16,8,128], n3(:,9925), t3x128(:,:,2000))
  call heltable([8,16,128], n3(:,9926), t3x128(:,:,2001))
  call heltable([8,16,128], n3(:,9927), t3x128(:,:,2002))
  call heltable([8,16,128], n3(:,9928), t3x128(:,:,2003))
  call heltable([8,16,128], n3(:,9929), t3x128(:,:,2004))
  call heltable([8,16,128], n3(:,9930), t3x128(:,:,2005))
  call heltable([8,16,128], n3(:,9931), t3x128(:,:,2006))
  call heltable([8,16,128], n3(:,9932), t3x128(:,:,2007))
  call heltable([8,16,128], n3(:,9933), t3x128(:,:,2008))
  call heltable([8,16,128], n3(:,9934), t3x128(:,:,2009))
  call heltable([8,16,128], n3(:,9935), t3x128(:,:,2010))
  call heltable([16,8,128], n3(:,9936), t3x128(:,:,2011))
  call heltable([16,8,128], n3(:,9937), t3x128(:,:,2012))
  call heltable([8,16,128], n3(:,9938), t3x128(:,:,2013))
  call heltable([8,16,128], n3(:,9939), t3x128(:,:,2014))
  call heltable([8,16,128], n3(:,9940), t3x128(:,:,2015))
  call heltable([8,16,128], n3(:,9941), t3x128(:,:,2016))
  call heltable([16,8,128], n3(:,9942), t3x128(:,:,2017))
  call heltable([16,8,128], n3(:,9943), t3x128(:,:,2018))
  call heltable([16,8,128], n3(:,9944), t3x128(:,:,2019))
  call heltable([16,8,128], n3(:,9945), t3x128(:,:,2020))
  call heltable([16,8,128], n3(:,9946), t3x128(:,:,2021))
  call heltable([16,8,128], n3(:,9947), t3x128(:,:,2022))
  call heltable([16,8,128], n3(:,9948), t3x128(:,:,2023))
  call heltable([16,8,128], n3(:,9949), t3x128(:,:,2024))
  call heltable([8,16,128], n3(:,9950), t3x128(:,:,2025))
  call heltable([8,16,128], n3(:,9951), t3x128(:,:,2026))
  call heltable([8,16,128], n3(:,9952), t3x128(:,:,2027))
  call heltable([8,16,128], n3(:,9953), t3x128(:,:,2028))
  call heltable([8,16,128], n3(:,9954), t3x128(:,:,2029))
  call heltable([8,16,128], n3(:,9955), t3x128(:,:,2030))
  call heltable([8,16,128], n3(:,9956), t3x128(:,:,2031))
  call heltable([8,16,128], n3(:,9957), t3x128(:,:,2032))
  call heltable([8,16,128], n3(:,9958), t3x128(:,:,2033))
  call heltable([8,16,128], n3(:,9959), t3x128(:,:,2034))
  call heltable([8,16,128], n3(:,9960), t3x128(:,:,2035))
  call heltable([8,16,128], n3(:,9961), t3x128(:,:,2036))
  call heltable([8,16,128], n3(:,9962), t3x128(:,:,2037))
  call heltable([8,16,128], n3(:,9963), t3x128(:,:,2038))
  call heltable([8,16,128], n3(:,9964), t3x128(:,:,2039))
  call heltable([8,16,128], n3(:,9965), t3x128(:,:,2040))
  call heltable([8,16,128], n3(:,9966), t3x128(:,:,2041))
  call heltable([8,16,128], n3(:,9967), t3x128(:,:,2042))
  call heltable([8,16,128], n3(:,9968), t3x128(:,:,2043))
  call heltable([8,16,128], n3(:,9969), t3x128(:,:,2044))
  call heltable([8,16,128], n3(:,9970), t3x128(:,:,2045))
  call heltable([8,16,128], n3(:,9971), t3x128(:,:,2046))
  call heltable([8,16,128], n3(:,9972), t3x128(:,:,2047))
  call heltable([8,16,128], n3(:,9973), t3x128(:,:,2048))
  call heltable([8,16,128], n3(:,9974), t3x128(:,:,2049))
  call heltable([8,16,128], n3(:,9975), t3x128(:,:,2050))
  call heltable([8,16,128], n3(:,9976), t3x128(:,:,2051))
  call heltable([8,16,128], n3(:,9977), t3x128(:,:,2052))
  call heltable([8,16,128], n3(:,9978), t3x128(:,:,2053))
  call heltable([8,16,128], n3(:,9979), t3x128(:,:,2054))
  call heltable([8,16,128], n3(:,9980), t3x128(:,:,2055))
  call heltable([8,16,128], n3(:,9981), t3x128(:,:,2056))
  call heltable([8,16,128], n3(:,9982), t3x128(:,:,2057))
  call heltable([8,16,128], n3(:,9983), t3x128(:,:,2058))
  call heltable([8,16,128], n3(:,9984), t3x128(:,:,2059))
  call heltable([8,16,128], n3(:,9985), t3x128(:,:,2060))
  call heltable([8,16,128], n3(:,9986), t3x128(:,:,2061))
  call heltable([8,16,128], n3(:,9987), t3x128(:,:,2062))
  call heltable([8,16,128], n3(:,9988), t3x128(:,:,2063))
  call heltable([8,16,128], n3(:,9989), t3x128(:,:,2064))
  call heltable([8,16,128], n3(:,9990), t3x128(:,:,2065))
  call heltable([8,16,128], n3(:,9991), t3x128(:,:,2066))
  call heltable([8,16,128], n3(:,9992), t3x128(:,:,2067))
  call heltable([8,16,128], n3(:,9993), t3x128(:,:,2068))
  call heltable([8,16,128], n3(:,9994), t3x128(:,:,2069))
  call heltable([8,16,128], n3(:,9995), t3x128(:,:,2070))
  call heltable([8,16,128], n3(:,9996), t3x128(:,:,2071))
  call heltable([8,16,128], n3(:,9997), t3x128(:,:,2072))
  call heltable([8,16,128], n3(:,9998), t3x128(:,:,2073))
  call heltable([8,16,128], n3(:,9999), t3x128(:,:,2074))
  call heltable([8,16,128], n3(:,10000), t3x128(:,:,2075))
  call heltable([8,16,128], n3(:,10001), t3x128(:,:,2076))
  call heltable([8,16,128], n3(:,10002), t3x128(:,:,2077))
  call heltable([8,16,128], n3(:,10003), t3x128(:,:,2078))
  call heltable([8,16,128], n3(:,10004), t3x128(:,:,2079))
  call heltable([8,16,128], n3(:,10005), t3x128(:,:,2080))
  call heltable([8,16,128], n3(:,10006), t3x128(:,:,2081))
  call heltable([8,16,128], n3(:,10007), t3x128(:,:,2082))
  call heltable([8,16,128], n3(:,10008), t3x128(:,:,2083))
  call heltable([8,16,128], n3(:,10009), t3x128(:,:,2084))
  call heltable([8,16,128], n3(:,10010), t3x128(:,:,2085))
  call heltable([8,16,128], n3(:,10011), t3x128(:,:,2086))
  call heltable([8,16,128], n3(:,10012), t3x128(:,:,2087))
  call heltable([8,16,128], n3(:,10013), t3x128(:,:,2088))
  call heltable([16,8,128], n3(:,10014), t3x128(:,:,2089))
  call heltable([16,8,128], n3(:,10015), t3x128(:,:,2090))
  call heltable([16,8,128], n3(:,10016), t3x128(:,:,2091))
  call heltable([16,8,128], n3(:,10017), t3x128(:,:,2092))
  call heltable([16,8,128], n3(:,10018), t3x128(:,:,2093))
  call heltable([16,8,128], n3(:,10019), t3x128(:,:,2094))
  call heltable([16,8,128], n3(:,10020), t3x128(:,:,2095))
  call heltable([16,8,128], n3(:,10021), t3x128(:,:,2096))
  call heltable([16,8,128], n3(:,10022), t3x128(:,:,2097))
  call heltable([16,8,128], n3(:,10023), t3x128(:,:,2098))
  call heltable([16,8,128], n3(:,10024), t3x128(:,:,2099))
  call heltable([16,8,128], n3(:,10025), t3x128(:,:,2100))
  call heltable([16,8,128], n3(:,10026), t3x128(:,:,2101))
  call heltable([8,16,128], n3(:,10027), t3x128(:,:,2102))
  call heltable([8,16,128], n3(:,10028), t3x128(:,:,2103))
  call heltable([8,16,128], n3(:,10029), t3x128(:,:,2104))
  call heltable([8,16,128], n3(:,10030), t3x128(:,:,2105))
  call heltable([8,16,128], n3(:,10031), t3x128(:,:,2106))
  call heltable([8,16,128], n3(:,10032), t3x128(:,:,2107))
  call heltable([8,16,128], n3(:,10033), t3x128(:,:,2108))
  call heltable([8,16,128], n3(:,10034), t3x128(:,:,2109))
  call heltable([8,16,128], n3(:,10035), t3x128(:,:,2110))
  call heltable([8,16,128], n3(:,10036), t3x128(:,:,2111))
  call heltable([8,16,128], n3(:,10037), t3x128(:,:,2112))
  call heltable([8,16,128], n3(:,10038), t3x128(:,:,2113))
  call heltable([8,16,128], n3(:,10039), t3x128(:,:,2114))
  call heltable([8,16,128], n3(:,10040), t3x128(:,:,2115))
  call heltable([8,16,128], n3(:,10041), t3x128(:,:,2116))
  call heltable([8,16,128], n3(:,10042), t3x128(:,:,2117))
  call heltable([8,16,128], n3(:,10043), t3x128(:,:,2118))
  call heltable([8,16,128], n3(:,10044), t3x128(:,:,2119))
  call heltable([8,16,128], n3(:,10045), t3x128(:,:,2120))
  call heltable([8,16,128], n3(:,10046), t3x128(:,:,2121))
  call heltable([8,16,128], n3(:,10047), t3x128(:,:,2122))
  call heltable([8,16,128], n3(:,10048), t3x128(:,:,2123))
  call heltable([8,16,128], n3(:,10049), t3x128(:,:,2124))
  call heltable([8,16,128], n3(:,10050), t3x128(:,:,2125))
  call heltable([8,16,128], n3(:,10051), t3x128(:,:,2126))
  call heltable([8,16,128], n3(:,10052), t3x128(:,:,2127))
  call heltable([8,16,128], n3(:,10053), t3x128(:,:,2128))
  call heltable([8,16,128], n3(:,10054), t3x128(:,:,2129))
  call heltable([8,16,128], n3(:,10055), t3x128(:,:,2130))
  call heltable([8,16,128], n3(:,10056), t3x128(:,:,2131))
  call heltable([8,16,128], n3(:,10057), t3x128(:,:,2132))
  call heltable([8,16,128], n3(:,10058), t3x128(:,:,2133))
  call heltable([8,16,128], n3(:,10059), t3x128(:,:,2134))
  call heltable([8,16,128], n3(:,10060), t3x128(:,:,2135))
  call heltable([8,16,128], n3(:,10061), t3x128(:,:,2136))
  call heltable([8,16,128], n3(:,10062), t3x128(:,:,2137))
  call heltable([8,16,128], n3(:,10063), t3x128(:,:,2138))
  call heltable([8,16,128], n3(:,10064), t3x128(:,:,2139))
  call heltable([8,16,128], n3(:,10065), t3x128(:,:,2140))
  call heltable([8,16,128], n3(:,10066), t3x128(:,:,2141))
  call heltable([8,16,128], n3(:,10067), t3x128(:,:,2142))
  call heltable([8,16,128], n3(:,10068), t3x128(:,:,2143))
  call heltable([8,16,128], n3(:,10069), t3x128(:,:,2144))
  call heltable([8,16,128], n3(:,10070), t3x128(:,:,2145))
  call heltable([8,16,128], n3(:,10071), t3x128(:,:,2146))
  call heltable([8,16,128], n3(:,10072), t3x128(:,:,2147))
  call heltable([8,16,128], n3(:,10073), t3x128(:,:,2148))
  call heltable([8,16,128], n3(:,10074), t3x128(:,:,2149))
  call heltable([8,16,128], n3(:,10075), t3x128(:,:,2150))
  call heltable([8,16,128], n3(:,10076), t3x128(:,:,2151))
  call heltable([8,16,128], n3(:,10077), t3x128(:,:,2152))
  call heltable([8,16,128], n3(:,10078), t3x128(:,:,2153))
  call heltable([8,16,128], n3(:,10079), t3x128(:,:,2154))
  call heltable([8,16,128], n3(:,10080), t3x128(:,:,2155))
  call heltable([8,16,128], n3(:,10081), t3x128(:,:,2156))
  call heltable([8,16,128], n3(:,10082), t3x128(:,:,2157))
  call heltable([8,16,128], n3(:,10083), t3x128(:,:,2158))
  call heltable([8,16,128], n3(:,10084), t3x128(:,:,2159))
  call heltable([8,16,128], n3(:,10085), t3x128(:,:,2160))
  call heltable([8,16,128], n3(:,10086), t3x128(:,:,2161))
  call heltable([8,16,128], n3(:,10087), t3x128(:,:,2162))
  call heltable([8,16,128], n3(:,10088), t3x128(:,:,2163))
  call heltable([8,16,128], n3(:,10089), t3x128(:,:,2164))
  call heltable([8,16,128], n3(:,10090), t3x128(:,:,2165))
  call heltable([8,16,128], n3(:,10091), t3x128(:,:,2166))
  call heltable([8,16,128], n3(:,10092), t3x128(:,:,2167))
  call heltable([8,16,128], n3(:,10093), t3x128(:,:,2168))
  call heltable([8,16,128], n3(:,10094), t3x128(:,:,2169))
  call heltable([8,16,128], n3(:,10095), t3x128(:,:,2170))
  call heltable([8,16,128], n3(:,10096), t3x128(:,:,2171))
  call heltable([8,16,128], n3(:,10097), t3x128(:,:,2172))
  call heltable([8,16,128], n3(:,10098), t3x128(:,:,2173))
  call heltable([8,16,128], n3(:,10099), t3x128(:,:,2174))
  call heltable([8,16,128], n3(:,10100), t3x128(:,:,2175))
  call heltable([8,16,128], n3(:,10101), t3x128(:,:,2176))
  call heltable([8,16,128], n3(:,10102), t3x128(:,:,2177))
  call heltable([8,16,128], n3(:,10103), t3x128(:,:,2178))
  call heltable([8,16,128], n3(:,10104), t3x128(:,:,2179))
  call heltable([8,16,128], n3(:,10105), t3x128(:,:,2180))
  call heltable([8,16,128], n3(:,10106), t3x128(:,:,2181))
  call heltable([8,16,128], n3(:,10107), t3x128(:,:,2182))
  call heltable([8,16,128], n3(:,10108), t3x128(:,:,2183))
  call heltable([8,16,128], n3(:,10109), t3x128(:,:,2184))
  call heltable([8,16,128], n3(:,10110), t3x128(:,:,2185))
  call heltable([8,16,128], n3(:,10111), t3x128(:,:,2186))
  call heltable([8,16,128], n3(:,10112), t3x128(:,:,2187))
  call heltable([8,16,128], n3(:,10113), t3x128(:,:,2188))
  call heltable([8,16,128], n3(:,10114), t3x128(:,:,2189))
  call heltable([8,16,128], n3(:,10115), t3x128(:,:,2190))
  call heltable([8,16,128], n3(:,10116), t3x128(:,:,2191))
  call heltable([8,16,128], n3(:,10117), t3x128(:,:,2192))
  call heltable([8,16,128], n3(:,10118), t3x128(:,:,2193))
  call heltable([8,16,128], n3(:,10119), t3x128(:,:,2194))
  call heltable([8,16,128], n3(:,10120), t3x128(:,:,2195))
  call heltable([8,16,128], n3(:,10121), t3x128(:,:,2196))
  call heltable([8,16,128], n3(:,10122), t3x128(:,:,2197))
  call heltable([8,16,128], n3(:,10123), t3x128(:,:,2198))
  call heltable([8,16,128], n3(:,10124), t3x128(:,:,2199))
  call heltable([8,16,128], n3(:,10125), t3x128(:,:,2200))
  call heltable([8,16,128], n3(:,10126), t3x128(:,:,2201))
  call heltable([8,16,128], n3(:,10127), t3x128(:,:,2202))
  call heltable([8,16,128], n3(:,10128), t3x128(:,:,2203))
  call heltable([8,16,128], n3(:,10129), t3x128(:,:,2204))
  call heltable([8,16,128], n3(:,10130), t3x128(:,:,2205))
  call heltable([8,16,128], n3(:,10131), t3x128(:,:,2206))
  call heltable([8,16,128], n3(:,10132), t3x128(:,:,2207))
  call heltable([8,16,128], n3(:,10133), t3x128(:,:,2208))
  call heltable([8,16,128], n3(:,10134), t3x128(:,:,2209))
  call heltable([8,16,128], n3(:,10135), t3x128(:,:,2210))
  call heltable([8,16,128], n3(:,10136), t3x128(:,:,2211))
  call heltable([8,16,128], n3(:,10137), t3x128(:,:,2212))
  call heltable([8,16,128], n3(:,10138), t3x128(:,:,2213))
  call heltable([8,16,128], n3(:,10139), t3x128(:,:,2214))
  call heltable([8,16,128], n3(:,10140), t3x128(:,:,2215))
  call heltable([8,16,128], n3(:,10141), t3x128(:,:,2216))
  call heltable([8,16,128], n3(:,10142), t3x128(:,:,2217))
  call heltable([8,16,128], n3(:,10143), t3x128(:,:,2218))
  call heltable([8,16,128], n3(:,10144), t3x128(:,:,2219))
  call heltable([8,16,128], n3(:,10145), t3x128(:,:,2220))
  call heltable([8,16,128], n3(:,10146), t3x128(:,:,2221))
  call heltable([16,8,128], n3(:,10147), t3x128(:,:,2222))
  call heltable([16,8,128], n3(:,10148), t3x128(:,:,2223))
  call heltable([16,8,128], n3(:,10149), t3x128(:,:,2224))
  call heltable([16,8,128], n3(:,10150), t3x128(:,:,2225))
  call heltable([16,8,128], n3(:,10151), t3x128(:,:,2226))
  call heltable([16,8,128], n3(:,10152), t3x128(:,:,2227))
  call heltable([16,8,128], n3(:,10153), t3x128(:,:,2228))
  call heltable([16,8,128], n3(:,10154), t3x128(:,:,2229))
  call heltable([16,8,128], n3(:,10155), t3x128(:,:,2230))
  call heltable([16,8,128], n3(:,10156), t3x128(:,:,2231))
  call heltable([16,8,128], n3(:,10157), t3x128(:,:,2232))
  call heltable([16,8,128], n3(:,10158), t3x128(:,:,2233))
  call heltable([16,8,128], n3(:,10159), t3x128(:,:,2234))
  call heltable([16,8,128], n3(:,10160), t3x128(:,:,2235))
  call heltable([16,8,128], n3(:,10161), t3x128(:,:,2236))
  call heltable([16,8,128], n3(:,10162), t3x128(:,:,2237))
  call heltable([16,8,128], n3(:,10163), t3x128(:,:,2238))
  call heltable([16,8,128], n3(:,10164), t3x128(:,:,2239))
  call heltable([16,8,128], n3(:,10165), t3x128(:,:,2240))
  call heltable([16,8,128], n3(:,10166), t3x128(:,:,2241))
  call heltable([16,8,128], n3(:,10167), t3x128(:,:,2242))
  call heltable([16,8,128], n3(:,10168), t3x128(:,:,2243))
  call heltable([16,8,128], n3(:,10169), t3x128(:,:,2244))
  call heltable([16,8,128], n3(:,10170), t3x128(:,:,2245))
  call heltable([8,16,128], n3(:,10171), t3x128(:,:,2246))
  call heltable([8,16,128], n3(:,10172), t3x128(:,:,2247))
  call heltable([8,16,128], n3(:,10173), t3x128(:,:,2248))
  call heltable([8,16,128], n3(:,10174), t3x128(:,:,2249))
  call heltable([8,16,128], n3(:,10175), t3x128(:,:,2250))
  call heltable([8,16,128], n3(:,10176), t3x128(:,:,2251))
  call heltable([8,16,128], n3(:,10177), t3x128(:,:,2252))
  call heltable([8,16,128], n3(:,10178), t3x128(:,:,2253))
  call heltable([8,16,128], n3(:,10179), t3x128(:,:,2254))
  call heltable([8,16,128], n3(:,10180), t3x128(:,:,2255))
  call heltable([8,16,128], n3(:,10181), t3x128(:,:,2256))
  call heltable([8,16,128], n3(:,10182), t3x128(:,:,2257))
  call heltable([8,16,128], n3(:,10183), t3x128(:,:,2258))
  call heltable([8,16,128], n3(:,10184), t3x128(:,:,2259))
  call heltable([8,16,128], n3(:,10185), t3x128(:,:,2260))
  call heltable([8,16,128], n3(:,10186), t3x128(:,:,2261))
  call heltable([16,8,128], n3(:,10187), t3x128(:,:,2262))
  call heltable([16,8,128], n3(:,10188), t3x128(:,:,2263))
  call heltable([16,8,128], n3(:,10189), t3x128(:,:,2264))
  call heltable([16,8,128], n3(:,10190), t3x128(:,:,2265))
  call heltable([16,8,128], n3(:,10191), t3x128(:,:,2266))
  call heltable([16,8,128], n3(:,10192), t3x128(:,:,2267))
  call heltable([16,8,128], n3(:,10193), t3x128(:,:,2268))
  call heltable([16,8,128], n3(:,10194), t3x128(:,:,2269))
  call heltable([16,8,128], n3(:,10195), t3x128(:,:,2270))
  call heltable([16,8,128], n3(:,10196), t3x128(:,:,2271))
  call heltable([16,8,128], n3(:,10197), t3x128(:,:,2272))
  call heltable([16,8,128], n3(:,10198), t3x128(:,:,2273))
  call heltable([16,8,128], n3(:,10199), t3x128(:,:,2274))
  call heltable([16,8,128], n3(:,10200), t3x128(:,:,2275))
  call heltable([16,8,128], n3(:,10201), t3x128(:,:,2276))
  call heltable([16,8,128], n3(:,10202), t3x128(:,:,2277))
  call heltable([16,8,128], n3(:,10203), t3x128(:,:,2278))
  call heltable([16,8,128], n3(:,10204), t3x128(:,:,2279))
  call heltable([16,8,128], n3(:,10205), t3x128(:,:,2280))
  call heltable([16,8,128], n3(:,10206), t3x128(:,:,2281))
  call heltable([16,8,128], n3(:,10207), t3x128(:,:,2282))
  call heltable([16,8,128], n3(:,10208), t3x128(:,:,2283))
  call heltable([16,8,128], n3(:,10209), t3x128(:,:,2284))
  call heltable([16,8,128], n3(:,10210), t3x128(:,:,2285))
  call heltable([8,16,128], n3(:,10211), t3x128(:,:,2286))
  call heltable([8,16,128], n3(:,10212), t3x128(:,:,2287))
  call heltable([8,16,128], n3(:,10213), t3x128(:,:,2288))
  call heltable([8,16,128], n3(:,10214), t3x128(:,:,2289))
  call heltable([8,16,128], n3(:,10215), t3x128(:,:,2290))
  call heltable([8,16,128], n3(:,10216), t3x128(:,:,2291))
  call heltable([8,16,128], n3(:,10217), t3x128(:,:,2292))
  call heltable([8,16,128], n3(:,10218), t3x128(:,:,2293))
  call heltable([8,16,128], n3(:,10219), t3x128(:,:,2294))
  call heltable([8,16,128], n3(:,10220), t3x128(:,:,2295))
  call heltable([8,16,128], n3(:,10221), t3x128(:,:,2296))
  call heltable([8,16,128], n3(:,10222), t3x128(:,:,2297))
  call heltable([8,16,128], n3(:,10223), t3x128(:,:,2298))
  call heltable([8,16,128], n3(:,10224), t3x128(:,:,2299))
  call heltable([8,16,128], n3(:,10225), t3x128(:,:,2300))
  call heltable([8,16,128], n3(:,10226), t3x128(:,:,2301))
  call heltable([16,8,128], n3(:,10227), t3x128(:,:,2302))
  call heltable([16,8,128], n3(:,10228), t3x128(:,:,2303))
  call heltable([16,8,128], n3(:,10229), t3x128(:,:,2304))
  call heltable([16,8,128], n3(:,10230), t3x128(:,:,2305))
  call heltable([16,8,128], n3(:,10231), t3x128(:,:,2306))
  call heltable([16,8,128], n3(:,10232), t3x128(:,:,2307))
  call heltable([16,8,128], n3(:,10233), t3x128(:,:,2308))
  call heltable([16,8,128], n3(:,10234), t3x128(:,:,2309))
  call heltable([16,8,128], n3(:,10235), t3x128(:,:,2310))
  call heltable([16,8,128], n3(:,10236), t3x128(:,:,2311))
  call heltable([16,8,128], n3(:,10237), t3x128(:,:,2312))
  call heltable([16,8,128], n3(:,10238), t3x128(:,:,2313))
  call heltable([16,8,128], n3(:,10239), t3x128(:,:,2314))
  call heltable([16,8,128], n3(:,10240), t3x128(:,:,2315))
  call heltable([16,8,128], n3(:,10241), t3x128(:,:,2316))
  call heltable([16,8,128], n3(:,10242), t3x128(:,:,2317))
  call heltable([16,8,128], n3(:,10243), t3x128(:,:,2318))
  call heltable([16,8,128], n3(:,10244), t3x128(:,:,2319))
  call heltable([16,8,128], n3(:,10245), t3x128(:,:,2320))
  call heltable([16,8,128], n3(:,10246), t3x128(:,:,2321))
  call heltable([16,8,128], n3(:,10247), t3x128(:,:,2322))
  call heltable([16,8,128], n3(:,10248), t3x128(:,:,2323))
  call heltable([16,8,128], n3(:,10249), t3x128(:,:,2324))
  call heltable([16,8,128], n3(:,10250), t3x128(:,:,2325))
  call heltable([8,16,128], n3(:,10251), t3x128(:,:,2326))
  call heltable([8,16,128], n3(:,10252), t3x128(:,:,2327))
  call heltable([8,16,128], n3(:,10253), t3x128(:,:,2328))
  call heltable([8,16,128], n3(:,10254), t3x128(:,:,2329))
  call heltable([8,16,128], n3(:,10255), t3x128(:,:,2330))
  call heltable([8,16,128], n3(:,10256), t3x128(:,:,2331))
  call heltable([8,16,128], n3(:,10257), t3x128(:,:,2332))
  call heltable([8,16,128], n3(:,10258), t3x128(:,:,2333))
  call heltable([8,16,128], n3(:,10259), t3x128(:,:,2334))
  call heltable([8,16,128], n3(:,10260), t3x128(:,:,2335))
  call heltable([8,16,128], n3(:,10261), t3x128(:,:,2336))
  call heltable([8,16,128], n3(:,10262), t3x128(:,:,2337))
  call heltable([8,16,128], n3(:,10263), t3x128(:,:,2338))
  call heltable([8,16,128], n3(:,10264), t3x128(:,:,2339))
  call heltable([8,16,128], n3(:,10265), t3x128(:,:,2340))
  call heltable([8,16,128], n3(:,10266), t3x128(:,:,2341))
  call heltable([8,16,128], n3(:,10267), t3x128(:,:,2342))
  call heltable([8,16,128], n3(:,10268), t3x128(:,:,2343))
  call heltable([8,16,128], n3(:,10269), t3x128(:,:,2344))
  call heltable([8,16,128], n3(:,10270), t3x128(:,:,2345))
  call heltable([8,16,128], n3(:,10271), t3x128(:,:,2346))
  call heltable([8,16,128], n3(:,10272), t3x128(:,:,2347))
  call heltable([8,16,128], n3(:,10273), t3x128(:,:,2348))
  call heltable([8,16,128], n3(:,10274), t3x128(:,:,2349))
  call heltable([8,16,128], n3(:,10275), t3x128(:,:,2350))
  call heltable([8,16,128], n3(:,10276), t3x128(:,:,2351))
  call heltable([8,16,128], n3(:,10277), t3x128(:,:,2352))
  call heltable([8,16,128], n3(:,10278), t3x128(:,:,2353))
  call heltable([8,16,128], n3(:,10279), t3x128(:,:,2354))
  call heltable([8,16,128], n3(:,10280), t3x128(:,:,2355))
  call heltable([8,16,128], n3(:,10281), t3x128(:,:,2356))
  call heltable([8,16,128], n3(:,10282), t3x128(:,:,2357))
  call heltable([8,16,128], n3(:,10283), t3x128(:,:,2358))
  call heltable([8,16,128], n3(:,10284), t3x128(:,:,2359))
  call heltable([8,16,128], n3(:,10285), t3x128(:,:,2360))
  call heltable([8,16,128], n3(:,10286), t3x128(:,:,2361))
  call heltable([8,16,128], n3(:,10287), t3x128(:,:,2362))
  call heltable([8,16,128], n3(:,10288), t3x128(:,:,2363))
  call heltable([8,16,128], n3(:,10289), t3x128(:,:,2364))
  call heltable([8,16,128], n3(:,10290), t3x128(:,:,2365))
  call heltable([16,8,128], n3(:,10291), t3x128(:,:,2366))
  call heltable([16,8,128], n3(:,10292), t3x128(:,:,2367))
  call heltable([16,8,128], n3(:,10293), t3x128(:,:,2368))
  call heltable([16,8,128], n3(:,10294), t3x128(:,:,2369))
  call heltable([16,8,128], n3(:,10295), t3x128(:,:,2370))
  call heltable([16,8,128], n3(:,10296), t3x128(:,:,2371))
  call heltable([16,8,128], n3(:,10297), t3x128(:,:,2372))
  call heltable([16,8,128], n3(:,10298), t3x128(:,:,2373))
  call heltable([16,8,128], n3(:,10299), t3x128(:,:,2374))
  call heltable([16,8,128], n3(:,10300), t3x128(:,:,2375))
  call heltable([16,8,128], n3(:,10301), t3x128(:,:,2376))
  call heltable([16,8,128], n3(:,10302), t3x128(:,:,2377))
  call heltable([16,8,128], n3(:,10303), t3x128(:,:,2378))
  call heltable([16,8,128], n3(:,10304), t3x128(:,:,2379))
  call heltable([16,8,128], n3(:,10305), t3x128(:,:,2380))
  call heltable([16,8,128], n3(:,10306), t3x128(:,:,2381))
  call heltable([8,16,128], n3(:,10307), t3x128(:,:,2382))
  call heltable([8,16,128], n3(:,10308), t3x128(:,:,2383))
  call heltable([8,16,128], n3(:,10309), t3x128(:,:,2384))
  call heltable([8,16,128], n3(:,10310), t3x128(:,:,2385))
  call heltable([8,16,128], n3(:,10311), t3x128(:,:,2386))
  call heltable([8,16,128], n3(:,10312), t3x128(:,:,2387))
  call heltable([8,16,128], n3(:,10313), t3x128(:,:,2388))
  call heltable([8,16,128], n3(:,10314), t3x128(:,:,2389))
  call heltable([8,16,128], n3(:,10315), t3x128(:,:,2390))
  call heltable([8,16,128], n3(:,10316), t3x128(:,:,2391))
  call heltable([8,16,128], n3(:,10317), t3x128(:,:,2392))
  call heltable([8,16,128], n3(:,10318), t3x128(:,:,2393))
  call heltable([8,16,128], n3(:,10319), t3x128(:,:,2394))
  call heltable([8,16,128], n3(:,10320), t3x128(:,:,2395))
  call heltable([8,16,128], n3(:,10321), t3x128(:,:,2396))
  call heltable([8,16,128], n3(:,10322), t3x128(:,:,2397))
  call heltable([16,8,128], n3(:,10323), t3x128(:,:,2398))
  call heltable([16,8,128], n3(:,10324), t3x128(:,:,2399))
  call heltable([16,8,128], n3(:,10325), t3x128(:,:,2400))
  call heltable([16,8,128], n3(:,10326), t3x128(:,:,2401))
  call heltable([16,8,128], n3(:,10327), t3x128(:,:,2402))
  call heltable([16,8,128], n3(:,10328), t3x128(:,:,2403))
  call heltable([16,8,128], n3(:,10329), t3x128(:,:,2404))
  call heltable([16,8,128], n3(:,10330), t3x128(:,:,2405))
  call heltable([16,8,128], n3(:,10331), t3x128(:,:,2406))
  call heltable([16,8,128], n3(:,10332), t3x128(:,:,2407))
  call heltable([16,8,128], n3(:,10333), t3x128(:,:,2408))
  call heltable([16,8,128], n3(:,10334), t3x128(:,:,2409))
  call heltable([16,8,128], n3(:,10335), t3x128(:,:,2410))
  call heltable([16,8,128], n3(:,10336), t3x128(:,:,2411))
  call heltable([16,8,128], n3(:,10337), t3x128(:,:,2412))
  call heltable([16,8,128], n3(:,10338), t3x128(:,:,2413))
  call heltable([16,8,128], n3(:,10339), t3x128(:,:,2414))
  call heltable([16,8,128], n3(:,10340), t3x128(:,:,2415))
  call heltable([16,8,128], n3(:,10341), t3x128(:,:,2416))
  call heltable([16,8,128], n3(:,10342), t3x128(:,:,2417))
  call heltable([16,8,128], n3(:,10343), t3x128(:,:,2418))
  call heltable([16,8,128], n3(:,10344), t3x128(:,:,2419))
  call heltable([16,8,128], n3(:,10345), t3x128(:,:,2420))
  call heltable([16,8,128], n3(:,10346), t3x128(:,:,2421))
  call heltable([16,8,128], n3(:,10347), t3x128(:,:,2422))
  call heltable([16,8,128], n3(:,10348), t3x128(:,:,2423))
  call heltable([16,8,128], n3(:,10349), t3x128(:,:,2424))
  call heltable([16,8,128], n3(:,10350), t3x128(:,:,2425))
  call heltable([16,8,128], n3(:,10351), t3x128(:,:,2426))
  call heltable([16,8,128], n3(:,10352), t3x128(:,:,2427))
  call heltable([16,8,128], n3(:,10353), t3x128(:,:,2428))
  call heltable([16,8,128], n3(:,10354), t3x128(:,:,2429))
  call heltable([16,8,128], n3(:,10355), t3x128(:,:,2430))
  call heltable([16,8,128], n3(:,10356), t3x128(:,:,2431))
  call heltable([16,8,128], n3(:,10357), t3x128(:,:,2432))
  call heltable([16,8,128], n3(:,10358), t3x128(:,:,2433))
  call heltable([16,8,128], n3(:,10359), t3x128(:,:,2434))
  call heltable([16,8,128], n3(:,10360), t3x128(:,:,2435))
  call heltable([16,8,128], n3(:,10361), t3x128(:,:,2436))
  call heltable([16,8,128], n3(:,10362), t3x128(:,:,2437))
  call heltable([16,8,128], n3(:,10363), t3x128(:,:,2438))
  call heltable([16,8,128], n3(:,10364), t3x128(:,:,2439))
  call heltable([16,8,128], n3(:,10365), t3x128(:,:,2440))
  call heltable([16,8,128], n3(:,10366), t3x128(:,:,2441))
  call heltable([16,8,128], n3(:,10367), t3x128(:,:,2442))
  call heltable([16,8,128], n3(:,10368), t3x128(:,:,2443))
  call heltable([16,8,128], n3(:,10369), t3x128(:,:,2444))
  call heltable([16,8,128], n3(:,10370), t3x128(:,:,2445))
  call heltable([16,8,128], n3(:,10371), t3x128(:,:,2446))
  call heltable([16,8,128], n3(:,10372), t3x128(:,:,2447))
  call heltable([16,8,128], n3(:,10373), t3x128(:,:,2448))
  call heltable([16,8,128], n3(:,10374), t3x128(:,:,2449))
  call heltable([16,8,128], n3(:,10375), t3x128(:,:,2450))
  call heltable([16,8,128], n3(:,10376), t3x128(:,:,2451))
  call heltable([16,8,128], n3(:,10377), t3x128(:,:,2452))
  call heltable([16,8,128], n3(:,10378), t3x128(:,:,2453))
  call heltable([16,8,128], n3(:,10379), t3x128(:,:,2454))
  call heltable([16,8,128], n3(:,10380), t3x128(:,:,2455))
  call heltable([16,8,128], n3(:,10381), t3x128(:,:,2456))
  call heltable([16,8,128], n3(:,10382), t3x128(:,:,2457))
  call heltable([16,8,128], n3(:,10383), t3x128(:,:,2458))
  call heltable([16,8,128], n3(:,10384), t3x128(:,:,2459))
  call heltable([16,8,128], n3(:,10385), t3x128(:,:,2460))
  call heltable([16,8,128], n3(:,10386), t3x128(:,:,2461))
  call heltable([16,8,128], n3(:,10387), t3x128(:,:,2462))
  call heltable([16,8,128], n3(:,10388), t3x128(:,:,2463))
  call heltable([16,8,128], n3(:,10389), t3x128(:,:,2464))
  call heltable([16,8,128], n3(:,10390), t3x128(:,:,2465))
  call heltable([16,8,128], n3(:,10391), t3x128(:,:,2466))
  call heltable([16,8,128], n3(:,10392), t3x128(:,:,2467))
  call heltable([16,8,128], n3(:,10393), t3x128(:,:,2468))
  call heltable([16,8,128], n3(:,10394), t3x128(:,:,2469))
  call heltable([16,8,128], n3(:,10395), t3x128(:,:,2470))
  call heltable([16,8,128], n3(:,10396), t3x128(:,:,2471))
  call heltable([16,8,128], n3(:,10397), t3x128(:,:,2472))
  call heltable([16,8,128], n3(:,10398), t3x128(:,:,2473))
  call heltable([16,8,128], n3(:,10399), t3x128(:,:,2474))
  call heltable([16,8,128], n3(:,10400), t3x128(:,:,2475))
  call heltable([16,8,128], n3(:,10401), t3x128(:,:,2476))
  call heltable([16,8,128], n3(:,10402), t3x128(:,:,2477))
  call heltable([8,16,128], n3(:,10403), t3x128(:,:,2478))
  call heltable([8,16,128], n3(:,10404), t3x128(:,:,2479))
  call heltable([8,16,128], n3(:,10405), t3x128(:,:,2480))
  call heltable([8,16,128], n3(:,10406), t3x128(:,:,2481))
  call heltable([8,16,128], n3(:,10407), t3x128(:,:,2482))
  call heltable([8,16,128], n3(:,10408), t3x128(:,:,2483))
  call heltable([8,16,128], n3(:,10409), t3x128(:,:,2484))
  call heltable([8,16,128], n3(:,10410), t3x128(:,:,2485))
  call heltable([8,16,128], n3(:,10411), t3x128(:,:,2486))
  call heltable([8,16,128], n3(:,10412), t3x128(:,:,2487))
  call heltable([8,16,128], n3(:,10413), t3x128(:,:,2488))
  call heltable([8,16,128], n3(:,10414), t3x128(:,:,2489))
  call heltable([8,16,128], n3(:,10415), t3x128(:,:,2490))
  call heltable([8,16,128], n3(:,10416), t3x128(:,:,2491))
  call heltable([8,16,128], n3(:,10417), t3x128(:,:,2492))
  call heltable([8,16,128], n3(:,10418), t3x128(:,:,2493))
  call heltable([16,8,128], n3(:,10419), t3x128(:,:,2494))
  call heltable([16,8,128], n3(:,10420), t3x128(:,:,2495))
  call heltable([16,8,128], n3(:,10421), t3x128(:,:,2496))
  call heltable([16,8,128], n3(:,10422), t3x128(:,:,2497))
  call heltable([16,8,128], n3(:,10423), t3x128(:,:,2498))
  call heltable([16,8,128], n3(:,10424), t3x128(:,:,2499))
  call heltable([16,8,128], n3(:,10425), t3x128(:,:,2500))
  call heltable([16,8,128], n3(:,10426), t3x128(:,:,2501))
  call heltable([16,8,128], n3(:,10427), t3x128(:,:,2502))
  call heltable([16,8,128], n3(:,10428), t3x128(:,:,2503))
  call heltable([16,8,128], n3(:,10429), t3x128(:,:,2504))
  call heltable([16,8,128], n3(:,10430), t3x128(:,:,2505))
  call heltable([16,8,128], n3(:,10431), t3x128(:,:,2506))
  call heltable([16,8,128], n3(:,10432), t3x128(:,:,2507))
  call heltable([16,8,128], n3(:,10433), t3x128(:,:,2508))
  call heltable([16,8,128], n3(:,10434), t3x128(:,:,2509))
  call heltable([8,16,128], n3(:,10435), t3x128(:,:,2510))
  call heltable([8,16,128], n3(:,10436), t3x128(:,:,2511))
  call heltable([8,16,128], n3(:,10437), t3x128(:,:,2512))
  call heltable([8,16,128], n3(:,10438), t3x128(:,:,2513))
  call heltable([8,16,128], n3(:,10439), t3x128(:,:,2514))
  call heltable([8,16,128], n3(:,10440), t3x128(:,:,2515))
  call heltable([8,16,128], n3(:,10441), t3x128(:,:,2516))
  call heltable([8,16,128], n3(:,10442), t3x128(:,:,2517))
  call heltable([8,16,128], n3(:,10443), t3x128(:,:,2518))
  call heltable([8,16,128], n3(:,10444), t3x128(:,:,2519))
  call heltable([8,16,128], n3(:,10445), t3x128(:,:,2520))
  call heltable([8,16,128], n3(:,10446), t3x128(:,:,2521))
  call heltable([8,16,128], n3(:,10447), t3x128(:,:,2522))
  call heltable([8,16,128], n3(:,10448), t3x128(:,:,2523))
  call heltable([8,16,128], n3(:,10449), t3x128(:,:,2524))
  call heltable([8,16,128], n3(:,10450), t3x128(:,:,2525))
  call heltable([16,8,128], n3(:,10451), t3x128(:,:,2526))
  call heltable([16,8,128], n3(:,10452), t3x128(:,:,2527))
  call heltable([16,8,128], n3(:,10453), t3x128(:,:,2528))
  call heltable([16,8,128], n3(:,10454), t3x128(:,:,2529))
  call heltable([16,8,128], n3(:,10455), t3x128(:,:,2530))
  call heltable([16,8,128], n3(:,10456), t3x128(:,:,2531))
  call heltable([16,8,128], n3(:,10457), t3x128(:,:,2532))
  call heltable([16,8,128], n3(:,10458), t3x128(:,:,2533))
  call heltable([16,8,128], n3(:,10459), t3x128(:,:,2534))
  call heltable([16,8,128], n3(:,10460), t3x128(:,:,2535))
  call heltable([16,8,128], n3(:,10461), t3x128(:,:,2536))
  call heltable([16,8,128], n3(:,10462), t3x128(:,:,2537))
  call heltable([16,8,128], n3(:,10463), t3x128(:,:,2538))
  call heltable([16,8,128], n3(:,10464), t3x128(:,:,2539))
  call heltable([16,8,128], n3(:,10465), t3x128(:,:,2540))
  call heltable([16,8,128], n3(:,10466), t3x128(:,:,2541))
  call heltable([16,8,128], n3(:,10467), t3x128(:,:,2542))
  call heltable([16,8,128], n3(:,10468), t3x128(:,:,2543))
  call heltable([16,8,128], n3(:,10469), t3x128(:,:,2544))
  call heltable([16,8,128], n3(:,10470), t3x128(:,:,2545))
  call heltable([16,8,128], n3(:,10471), t3x128(:,:,2546))
  call heltable([16,8,128], n3(:,10472), t3x128(:,:,2547))
  call heltable([16,8,128], n3(:,10473), t3x128(:,:,2548))
  call heltable([16,8,128], n3(:,10474), t3x128(:,:,2549))
  call heltable([16,8,128], n3(:,10475), t3x128(:,:,2550))
  call heltable([16,8,128], n3(:,10476), t3x128(:,:,2551))
  call heltable([16,8,128], n3(:,10477), t3x128(:,:,2552))
  call heltable([16,8,128], n3(:,10478), t3x128(:,:,2553))
  call heltable([16,8,128], n3(:,10479), t3x128(:,:,2554))
  call heltable([16,8,128], n3(:,10480), t3x128(:,:,2555))
  call heltable([16,8,128], n3(:,10481), t3x128(:,:,2556))
  call heltable([16,8,128], n3(:,10482), t3x128(:,:,2557))
  call heltable([16,8,128], n3(:,10483), t3x128(:,:,2558))
  call heltable([16,8,128], n3(:,10484), t3x128(:,:,2559))
  call heltable([16,8,128], n3(:,10485), t3x128(:,:,2560))
  call heltable([16,8,128], n3(:,10486), t3x128(:,:,2561))
  call heltable([16,8,128], n3(:,10487), t3x128(:,:,2562))
  call heltable([16,8,128], n3(:,10488), t3x128(:,:,2563))
  call heltable([16,8,128], n3(:,10489), t3x128(:,:,2564))
  call heltable([16,8,128], n3(:,10490), t3x128(:,:,2565))
  call heltable([16,8,128], n3(:,10491), t3x128(:,:,2566))
  call heltable([16,8,128], n3(:,10492), t3x128(:,:,2567))
  call heltable([16,8,128], n3(:,10493), t3x128(:,:,2568))
  call heltable([16,8,128], n3(:,10494), t3x128(:,:,2569))
  call heltable([16,8,128], n3(:,10495), t3x128(:,:,2570))
  call heltable([16,8,128], n3(:,10496), t3x128(:,:,2571))
  call heltable([16,8,128], n3(:,10497), t3x128(:,:,2572))
  call heltable([16,8,128], n3(:,10498), t3x128(:,:,2573))
  call heltable([16,8,128], n3(:,10499), t3x128(:,:,2574))
  call heltable([16,8,128], n3(:,10500), t3x128(:,:,2575))
  call heltable([16,8,128], n3(:,10501), t3x128(:,:,2576))
  call heltable([16,8,128], n3(:,10502), t3x128(:,:,2577))
  call heltable([16,8,128], n3(:,10503), t3x128(:,:,2578))
  call heltable([16,8,128], n3(:,10504), t3x128(:,:,2579))
  call heltable([16,8,128], n3(:,10505), t3x128(:,:,2580))
  call heltable([16,8,128], n3(:,10506), t3x128(:,:,2581))
  call heltable([16,8,128], n3(:,10507), t3x128(:,:,2582))
  call heltable([16,8,128], n3(:,10508), t3x128(:,:,2583))
  call heltable([16,8,128], n3(:,10509), t3x128(:,:,2584))
  call heltable([16,8,128], n3(:,10510), t3x128(:,:,2585))
  call heltable([16,8,128], n3(:,10511), t3x128(:,:,2586))
  call heltable([16,8,128], n3(:,10512), t3x128(:,:,2587))
  call heltable([16,8,128], n3(:,10513), t3x128(:,:,2588))
  call heltable([16,8,128], n3(:,10514), t3x128(:,:,2589))
  call heltable([16,8,128], n3(:,10515), t3x128(:,:,2590))
  call heltable([16,8,128], n3(:,10516), t3x128(:,:,2591))
  call heltable([16,8,128], n3(:,10517), t3x128(:,:,2592))
  call heltable([16,8,128], n3(:,10518), t3x128(:,:,2593))
  call heltable([16,8,128], n3(:,10519), t3x128(:,:,2594))
  call heltable([16,8,128], n3(:,10520), t3x128(:,:,2595))
  call heltable([16,8,128], n3(:,10521), t3x128(:,:,2596))
  call heltable([16,8,128], n3(:,10522), t3x128(:,:,2597))
  call heltable([16,8,128], n3(:,10523), t3x128(:,:,2598))
  call heltable([16,8,128], n3(:,10524), t3x128(:,:,2599))
  call heltable([16,8,128], n3(:,10525), t3x128(:,:,2600))
  call heltable([16,8,128], n3(:,10526), t3x128(:,:,2601))
  call heltable([16,8,128], n3(:,10527), t3x128(:,:,2602))
  call heltable([16,8,128], n3(:,10528), t3x128(:,:,2603))
  call heltable([16,8,128], n3(:,10529), t3x128(:,:,2604))
  call heltable([16,8,128], n3(:,10530), t3x128(:,:,2605))
  call heltable([8,16,128], n3(:,10531), t3x128(:,:,2606))
  call heltable([8,16,128], n3(:,10532), t3x128(:,:,2607))
  call heltable([8,16,128], n3(:,10533), t3x128(:,:,2608))
  call heltable([8,16,128], n3(:,10534), t3x128(:,:,2609))
  call heltable([8,16,128], n3(:,10535), t3x128(:,:,2610))
  call heltable([8,16,128], n3(:,10536), t3x128(:,:,2611))
  call heltable([8,16,128], n3(:,10537), t3x128(:,:,2612))
  call heltable([8,16,128], n3(:,10538), t3x128(:,:,2613))
  call heltable([8,16,128], n3(:,10539), t3x128(:,:,2614))
  call heltable([8,16,128], n3(:,10540), t3x128(:,:,2615))
  call heltable([8,16,128], n3(:,10541), t3x128(:,:,2616))
  call heltable([8,16,128], n3(:,10542), t3x128(:,:,2617))
  call heltable([8,16,128], n3(:,10543), t3x128(:,:,2618))
  call heltable([8,16,128], n3(:,10544), t3x128(:,:,2619))
  call heltable([8,16,128], n3(:,10545), t3x128(:,:,2620))
  call heltable([8,16,128], n3(:,10546), t3x128(:,:,2621))
  call heltable([8,16,128], n3(:,10547), t3x128(:,:,2622))
  call heltable([8,16,128], n3(:,10548), t3x128(:,:,2623))
  call heltable([8,16,128], n3(:,10549), t3x128(:,:,2624))
  call heltable([8,16,128], n3(:,10550), t3x128(:,:,2625))
  call heltable([8,16,128], n3(:,10551), t3x128(:,:,2626))
  call heltable([8,16,128], n3(:,10552), t3x128(:,:,2627))
  call heltable([8,16,128], n3(:,10553), t3x128(:,:,2628))
  call heltable([8,16,128], n3(:,10554), t3x128(:,:,2629))
  call heltable([8,16,128], n3(:,10555), t3x128(:,:,2630))
  call heltable([8,16,128], n3(:,10556), t3x128(:,:,2631))
  call heltable([8,16,128], n3(:,10557), t3x128(:,:,2632))
  call heltable([8,16,128], n3(:,10558), t3x128(:,:,2633))
  call heltable([8,16,128], n3(:,10559), t3x128(:,:,2634))
  call heltable([16,8,128], n3(:,10560), t3x128(:,:,2635))
  call heltable([16,8,128], n3(:,10561), t3x128(:,:,2636))
  call heltable([16,8,128], n3(:,10562), t3x128(:,:,2637))
  call heltable([16,8,128], n3(:,10563), t3x128(:,:,2638))
  call heltable([16,8,128], n3(:,10564), t3x128(:,:,2639))
  call heltable([16,8,128], n3(:,10565), t3x128(:,:,2640))
  call heltable([16,8,128], n3(:,10566), t3x128(:,:,2641))
  call heltable([16,8,128], n3(:,10567), t3x128(:,:,2642))
  call heltable([16,8,128], n3(:,10568), t3x128(:,:,2643))
  call heltable([16,8,128], n3(:,10569), t3x128(:,:,2644))
  call heltable([16,8,128], n3(:,10570), t3x128(:,:,2645))
  call heltable([16,8,128], n3(:,10571), t3x128(:,:,2646))
  call heltable([16,8,128], n3(:,10572), t3x128(:,:,2647))
  call heltable([16,8,128], n3(:,10573), t3x128(:,:,2648))
  call heltable([16,8,128], n3(:,10574), t3x128(:,:,2649))
  call heltable([16,8,128], n3(:,10575), t3x128(:,:,2650))
  call heltable([8,16,128], n3(:,10576), t3x128(:,:,2651))
  call heltable([8,16,128], n3(:,10577), t3x128(:,:,2652))
  call heltable([8,16,128], n3(:,10578), t3x128(:,:,2653))
  call heltable([8,16,128], n3(:,10579), t3x128(:,:,2654))
  call heltable([8,16,128], n3(:,10580), t3x128(:,:,2655))
  call heltable([8,16,128], n3(:,10581), t3x128(:,:,2656))
  call heltable([8,16,128], n3(:,10582), t3x128(:,:,2657))
  call heltable([8,16,128], n3(:,10583), t3x128(:,:,2658))
  call heltable([8,16,128], n3(:,10584), t3x128(:,:,2659))
  call heltable([8,16,128], n3(:,10585), t3x128(:,:,2660))
  call heltable([8,16,128], n3(:,10586), t3x128(:,:,2661))
  call heltable([8,16,128], n3(:,10587), t3x128(:,:,2662))
  call heltable([8,16,128], n3(:,10588), t3x128(:,:,2663))
  call heltable([8,16,128], n3(:,10589), t3x128(:,:,2664))
  call heltable([8,16,128], n3(:,10590), t3x128(:,:,2665))
  call heltable([8,16,128], n3(:,10591), t3x128(:,:,2666))
  call heltable([8,16,128], n3(:,10592), t3x128(:,:,2667))
  call heltable([8,16,128], n3(:,10593), t3x128(:,:,2668))
  call heltable([8,16,128], n3(:,10594), t3x128(:,:,2669))
  call heltable([8,16,128], n3(:,10595), t3x128(:,:,2670))
  call heltable([8,16,128], n3(:,10596), t3x128(:,:,2671))
  call heltable([8,16,128], n3(:,10597), t3x128(:,:,2672))
  call heltable([8,16,128], n3(:,10598), t3x128(:,:,2673))
  call heltable([8,16,128], n3(:,10599), t3x128(:,:,2674))
  call heltable([8,16,128], n3(:,10600), t3x128(:,:,2675))
  call heltable([8,16,128], n3(:,10601), t3x128(:,:,2676))
  call heltable([8,16,128], n3(:,10602), t3x128(:,:,2677))
  call heltable([8,16,128], n3(:,10603), t3x128(:,:,2678))
  call heltable([8,16,128], n3(:,10604), t3x128(:,:,2679))
  call heltable([16,8,128], n3(:,10605), t3x128(:,:,2680))
  call heltable([16,8,128], n3(:,10606), t3x128(:,:,2681))
  call heltable([16,8,128], n3(:,10607), t3x128(:,:,2682))
  call heltable([16,8,128], n3(:,10608), t3x128(:,:,2683))
  call heltable([16,8,128], n3(:,10609), t3x128(:,:,2684))
  call heltable([16,8,128], n3(:,10610), t3x128(:,:,2685))
  call heltable([16,8,128], n3(:,10611), t3x128(:,:,2686))
  call heltable([16,8,128], n3(:,10612), t3x128(:,:,2687))
  call heltable([16,8,128], n3(:,10613), t3x128(:,:,2688))
  call heltable([16,8,128], n3(:,10614), t3x128(:,:,2689))
  call heltable([16,8,128], n3(:,10615), t3x128(:,:,2690))
  call heltable([16,8,128], n3(:,10616), t3x128(:,:,2691))
  call heltable([16,8,128], n3(:,10617), t3x128(:,:,2692))
  call heltable([16,8,128], n3(:,10618), t3x128(:,:,2693))
  call heltable([16,8,128], n3(:,10619), t3x128(:,:,2694))
  call heltable([16,8,128], n3(:,10620), t3x128(:,:,2695))
  call heltable([16,8,128], n3(:,10621), t3x128(:,:,2696))
  call heltable([16,8,128], n3(:,10622), t3x128(:,:,2697))
  call heltable([16,8,128], n3(:,10623), t3x128(:,:,2698))
  call heltable([16,8,128], n3(:,10624), t3x128(:,:,2699))
  call heltable([16,8,128], n3(:,10625), t3x128(:,:,2700))
  call heltable([16,8,128], n3(:,10626), t3x128(:,:,2701))
  call heltable([16,8,128], n3(:,10627), t3x128(:,:,2702))
  call heltable([16,8,128], n3(:,10628), t3x128(:,:,2703))
  call heltable([16,8,128], n3(:,10629), t3x128(:,:,2704))
  call heltable([16,8,128], n3(:,10630), t3x128(:,:,2705))
  call heltable([16,8,128], n3(:,10631), t3x128(:,:,2706))
  call heltable([16,8,128], n3(:,10632), t3x128(:,:,2707))
  call heltable([16,8,128], n3(:,10633), t3x128(:,:,2708))
  call heltable([16,8,128], n3(:,10634), t3x128(:,:,2709))
  call heltable([16,8,128], n3(:,10635), t3x128(:,:,2710))
  call heltable([16,8,128], n3(:,10636), t3x128(:,:,2711))
  call heltable([8,16,128], n3(:,10637), t3x128(:,:,2712))
  call heltable([8,16,128], n3(:,10638), t3x128(:,:,2713))
  call heltable([8,16,128], n3(:,10639), t3x128(:,:,2714))
  call heltable([8,16,128], n3(:,10640), t3x128(:,:,2715))
  call heltable([8,16,128], n3(:,10641), t3x128(:,:,2716))
  call heltable([8,16,128], n3(:,10642), t3x128(:,:,2717))
  call heltable([8,16,128], n3(:,10643), t3x128(:,:,2718))
  call heltable([8,16,128], n3(:,10644), t3x128(:,:,2719))
  call heltable([8,16,128], n3(:,10645), t3x128(:,:,2720))
  call heltable([8,16,128], n3(:,10646), t3x128(:,:,2721))
  call heltable([8,16,128], n3(:,10647), t3x128(:,:,2722))
  call heltable([8,16,128], n3(:,10648), t3x128(:,:,2723))
  call heltable([8,16,128], n3(:,10649), t3x128(:,:,2724))
  call heltable([8,16,128], n3(:,10650), t3x128(:,:,2725))
  call heltable([8,16,128], n3(:,10651), t3x128(:,:,2726))
  call heltable([8,16,128], n3(:,10652), t3x128(:,:,2727))
  call heltable([8,16,128], n3(:,10653), t3x128(:,:,2728))
  call heltable([16,8,128], n3(:,10654), t3x128(:,:,2729))
  call heltable([8,16,128], n3(:,10655), t3x128(:,:,2730))
  call heltable([8,16,128], n3(:,10656), t3x128(:,:,2731))
  call heltable([16,8,128], n3(:,10657), t3x128(:,:,2732))
  call heltable([16,8,128], n3(:,10658), t3x128(:,:,2733))
  call heltable([16,8,128], n3(:,10659), t3x128(:,:,2734))
  call heltable([16,8,128], n3(:,10660), t3x128(:,:,2735))
  call heltable([8,16,128], n3(:,10661), t3x128(:,:,2736))
  call heltable([8,16,128], n3(:,10662), t3x128(:,:,2737))
  call heltable([8,16,128], n3(:,10663), t3x128(:,:,2738))
  call heltable([8,16,128], n3(:,10664), t3x128(:,:,2739))
  call heltable([8,16,128], n3(:,10665), t3x128(:,:,2740))
  call heltable([8,16,128], n3(:,10666), t3x128(:,:,2741))
  call heltable([8,16,128], n3(:,10667), t3x128(:,:,2742))
  call heltable([8,16,128], n3(:,10668), t3x128(:,:,2743))
  call heltable([16,8,128], n3(:,10669), t3x128(:,:,2744))
  call heltable([16,8,128], n3(:,10670), t3x128(:,:,2745))
  call heltable([16,8,128], n3(:,10671), t3x128(:,:,2746))
  call heltable([16,8,128], n3(:,10672), t3x128(:,:,2747))
  call heltable([16,8,128], n3(:,10673), t3x128(:,:,2748))
  call heltable([16,8,128], n3(:,10674), t3x128(:,:,2749))
  call heltable([16,8,128], n3(:,10675), t3x128(:,:,2750))
  call heltable([16,8,128], n3(:,10676), t3x128(:,:,2751))
  call heltable([16,8,128], n3(:,10677), t3x128(:,:,2752))
  call heltable([16,8,128], n3(:,10678), t3x128(:,:,2753))
  call heltable([16,8,128], n3(:,10679), t3x128(:,:,2754))
  call heltable([16,8,128], n3(:,10680), t3x128(:,:,2755))
  call heltable([16,8,128], n3(:,10681), t3x128(:,:,2756))
  call heltable([8,16,128], n3(:,10682), t3x128(:,:,2757))
  call heltable([8,16,128], n3(:,10683), t3x128(:,:,2758))
  call heltable([16,8,128], n3(:,10684), t3x128(:,:,2759))
  call heltable([16,8,128], n3(:,10685), t3x128(:,:,2760))
  call heltable([8,16,128], n3(:,10686), t3x128(:,:,2761))
  call heltable([8,16,128], n3(:,10687), t3x128(:,:,2762))
  call heltable([8,16,128], n3(:,10688), t3x128(:,:,2763))
  call heltable([8,16,128], n3(:,10689), t3x128(:,:,2764))
  call heltable([16,8,128], n3(:,10690), t3x128(:,:,2765))
  call heltable([16,8,128], n3(:,10691), t3x128(:,:,2766))
  call heltable([16,8,128], n3(:,10692), t3x128(:,:,2767))
  call heltable([16,8,128], n3(:,10693), t3x128(:,:,2768))
  call heltable([16,8,128], n3(:,10694), t3x128(:,:,2769))
  call heltable([16,8,128], n3(:,10695), t3x128(:,:,2770))
  call heltable([16,8,128], n3(:,10696), t3x128(:,:,2771))
  call heltable([16,8,128], n3(:,10697), t3x128(:,:,2772))
  call heltable([16,8,128], n3(:,10698), t3x128(:,:,2773))
  call heltable([16,8,128], n3(:,10699), t3x128(:,:,2774))
  call heltable([16,8,128], n3(:,10700), t3x128(:,:,2775))
  call heltable([16,8,128], n3(:,10701), t3x128(:,:,2776))
  call heltable([16,8,128], n3(:,10702), t3x128(:,:,2777))
  call heltable([16,8,128], n3(:,10703), t3x128(:,:,2778))
  call heltable([16,8,128], n3(:,10704), t3x128(:,:,2779))
  call heltable([16,8,128], n3(:,10705), t3x128(:,:,2780))
  call heltable([16,8,128], n3(:,10706), t3x128(:,:,2781))
  call heltable([16,8,128], n3(:,10707), t3x128(:,:,2782))
  call heltable([16,8,128], n3(:,10708), t3x128(:,:,2783))
  call heltable([16,8,128], n3(:,10709), t3x128(:,:,2784))
  call heltable([16,8,128], n3(:,10710), t3x128(:,:,2785))
  call heltable([16,8,128], n3(:,10711), t3x128(:,:,2786))
  call heltable([16,8,128], n3(:,10712), t3x128(:,:,2787))
  call heltable([16,8,128], n3(:,10713), t3x128(:,:,2788))
  call heltable([16,8,128], n3(:,10714), t3x128(:,:,2789))
  call heltable([16,8,128], n3(:,10715), t3x128(:,:,2790))
  call heltable([16,8,128], n3(:,10716), t3x128(:,:,2791))
  call heltable([16,8,128], n3(:,10717), t3x128(:,:,2792))
  call heltable([16,8,128], n3(:,10718), t3x128(:,:,2793))
  call heltable([16,8,128], n3(:,10719), t3x128(:,:,2794))
  call heltable([16,8,128], n3(:,10720), t3x128(:,:,2795))
  call heltable([16,8,128], n3(:,10721), t3x128(:,:,2796))
  call heltable([16,8,128], n3(:,10722), t3x128(:,:,2797))
  call heltable([16,8,128], n3(:,10723), t3x128(:,:,2798))
  call heltable([16,8,128], n3(:,10724), t3x128(:,:,2799))
  call heltable([16,8,128], n3(:,10725), t3x128(:,:,2800))
  call heltable([16,8,128], n3(:,10726), t3x128(:,:,2801))
  call heltable([16,8,128], n3(:,10727), t3x128(:,:,2802))
  call heltable([16,8,128], n3(:,10728), t3x128(:,:,2803))
  call heltable([16,8,128], n3(:,10729), t3x128(:,:,2804))
  call heltable([8,16,128], n3(:,10730), t3x128(:,:,2805))
  call heltable([8,16,128], n3(:,10731), t3x128(:,:,2806))
  call heltable([8,16,128], n3(:,10732), t3x128(:,:,2807))
  call heltable([8,16,128], n3(:,10733), t3x128(:,:,2808))
  call heltable([8,16,128], n3(:,10734), t3x128(:,:,2809))
  call heltable([8,16,128], n3(:,10735), t3x128(:,:,2810))
  call heltable([8,16,128], n3(:,10736), t3x128(:,:,2811))
  call heltable([8,16,128], n3(:,10737), t3x128(:,:,2812))
  call heltable([8,16,128], n3(:,10738), t3x128(:,:,2813))
  call heltable([8,16,128], n3(:,10739), t3x128(:,:,2814))
  call heltable([8,16,128], n3(:,10740), t3x128(:,:,2815))
  call heltable([8,16,128], n3(:,10741), t3x128(:,:,2816))
  call heltable([8,16,128], n3(:,10742), t3x128(:,:,2817))
  call heltable([8,16,128], n3(:,10743), t3x128(:,:,2818))
  call heltable([8,16,128], n3(:,10744), t3x128(:,:,2819))
  call heltable([8,16,128], n3(:,10745), t3x128(:,:,2820))
  call heltable([8,16,128], n3(:,10746), t3x128(:,:,2821))
  call heltable([8,16,128], n3(:,10747), t3x128(:,:,2822))
  call heltable([8,16,128], n3(:,10748), t3x128(:,:,2823))
  call heltable([8,16,128], n3(:,10749), t3x128(:,:,2824))
  call heltable([8,16,128], n3(:,10750), t3x128(:,:,2825))
  call heltable([8,16,128], n3(:,10751), t3x128(:,:,2826))
  call heltable([8,16,128], n3(:,10752), t3x128(:,:,2827))
  call heltable([8,16,128], n3(:,10753), t3x128(:,:,2828))
  call heltable([8,16,128], n3(:,10754), t3x128(:,:,2829))
  call heltable([8,16,128], n3(:,10755), t3x128(:,:,2830))
  call heltable([8,16,128], n3(:,10756), t3x128(:,:,2831))
  call heltable([8,16,128], n3(:,10757), t3x128(:,:,2832))
  call heltable([8,16,128], n3(:,10758), t3x128(:,:,2833))
  call heltable([8,16,128], n3(:,10759), t3x128(:,:,2834))
  call heltable([8,16,128], n3(:,10760), t3x128(:,:,2835))
  call heltable([8,16,128], n3(:,10761), t3x128(:,:,2836))
  call heltable([16,8,128], n3(:,10762), t3x128(:,:,2837))
  call heltable([16,8,128], n3(:,10763), t3x128(:,:,2838))
  call heltable([16,8,128], n3(:,10764), t3x128(:,:,2839))
  call heltable([16,8,128], n3(:,10765), t3x128(:,:,2840))
  call heltable([16,8,128], n3(:,10766), t3x128(:,:,2841))
  call heltable([16,8,128], n3(:,10767), t3x128(:,:,2842))
  call heltable([16,8,128], n3(:,10768), t3x128(:,:,2843))
  call heltable([16,8,128], n3(:,10769), t3x128(:,:,2844))
  call heltable([16,8,128], n3(:,10770), t3x128(:,:,2845))
  call heltable([16,8,128], n3(:,10771), t3x128(:,:,2846))
  call heltable([16,8,128], n3(:,10772), t3x128(:,:,2847))
  call heltable([16,8,128], n3(:,10773), t3x128(:,:,2848))
  call heltable([16,8,128], n3(:,10774), t3x128(:,:,2849))
  call heltable([8,16,128], n3(:,10775), t3x128(:,:,2850))
  call heltable([8,16,128], n3(:,10776), t3x128(:,:,2851))
  call heltable([8,16,128], n3(:,10777), t3x128(:,:,2852))
  call heltable([8,16,128], n3(:,10778), t3x128(:,:,2853))
  call heltable([8,16,128], n3(:,10779), t3x128(:,:,2854))
  call heltable([8,16,128], n3(:,10780), t3x128(:,:,2855))
  call heltable([8,16,128], n3(:,10781), t3x128(:,:,2856))
  call heltable([8,16,128], n3(:,10782), t3x128(:,:,2857))
  call heltable([8,16,128], n3(:,10783), t3x128(:,:,2858))
  call heltable([8,16,128], n3(:,10784), t3x128(:,:,2859))
  call heltable([8,16,128], n3(:,10785), t3x128(:,:,2860))
  call heltable([8,16,128], n3(:,10786), t3x128(:,:,2861))
  call heltable([8,16,128], n3(:,10787), t3x128(:,:,2862))
  call heltable([8,16,128], n3(:,10788), t3x128(:,:,2863))
  call heltable([8,16,128], n3(:,10789), t3x128(:,:,2864))
  call heltable([8,16,128], n3(:,10790), t3x128(:,:,2865))
  call heltable([8,16,128], n3(:,10791), t3x128(:,:,2866))
  call heltable([8,16,128], n3(:,10792), t3x128(:,:,2867))
  call heltable([8,16,128], n3(:,10793), t3x128(:,:,2868))
  call heltable([8,16,128], n3(:,10794), t3x128(:,:,2869))
  call heltable([8,16,128], n3(:,10795), t3x128(:,:,2870))
  call heltable([8,16,128], n3(:,10796), t3x128(:,:,2871))
  call heltable([8,16,128], n3(:,10797), t3x128(:,:,2872))
  call heltable([8,16,128], n3(:,10798), t3x128(:,:,2873))
  call heltable([8,16,128], n3(:,10799), t3x128(:,:,2874))
  call heltable([8,16,128], n3(:,10800), t3x128(:,:,2875))
  call heltable([8,16,128], n3(:,10801), t3x128(:,:,2876))
  call heltable([8,16,128], n3(:,10802), t3x128(:,:,2877))
  call heltable([8,16,128], n3(:,10803), t3x128(:,:,2878))
  call heltable([8,16,128], n3(:,10804), t3x128(:,:,2879))
  call heltable([8,16,128], n3(:,10805), t3x128(:,:,2880))
  call heltable([8,16,128], n3(:,10806), t3x128(:,:,2881))
  call heltable([8,16,128], n3(:,10807), t3x128(:,:,2882))
  call heltable([8,16,128], n3(:,10808), t3x128(:,:,2883))
  call heltable([8,16,128], n3(:,10809), t3x128(:,:,2884))
  call heltable([8,16,128], n3(:,10810), t3x128(:,:,2885))
  call heltable([8,16,128], n3(:,10811), t3x128(:,:,2886))
  call heltable([8,16,128], n3(:,10812), t3x128(:,:,2887))
  call heltable([8,16,128], n3(:,10813), t3x128(:,:,2888))
  call heltable([8,16,128], n3(:,10814), t3x128(:,:,2889))
  call heltable([8,16,128], n3(:,10815), t3x128(:,:,2890))
  call heltable([8,16,128], n3(:,10816), t3x128(:,:,2891))
  call heltable([8,16,128], n3(:,10817), t3x128(:,:,2892))
  call heltable([8,16,128], n3(:,10818), t3x128(:,:,2893))
  call heltable([8,16,128], n3(:,10819), t3x128(:,:,2894))
  call heltable([8,16,128], n3(:,10820), t3x128(:,:,2895))
  call heltable([8,16,128], n3(:,10821), t3x128(:,:,2896))
  call heltable([8,16,128], n3(:,10822), t3x128(:,:,2897))
  call heltable([8,16,128], n3(:,10823), t3x128(:,:,2898))
  call heltable([8,16,128], n3(:,10824), t3x128(:,:,2899))
  call heltable([8,16,128], n3(:,10825), t3x128(:,:,2900))
  call heltable([8,16,128], n3(:,10826), t3x128(:,:,2901))
  call heltable([8,16,128], n3(:,10827), t3x128(:,:,2902))
  call heltable([8,16,128], n3(:,10828), t3x128(:,:,2903))
  call heltable([8,16,128], n3(:,10829), t3x128(:,:,2904))
  call heltable([8,16,128], n3(:,10830), t3x128(:,:,2905))
  call heltable([8,16,128], n3(:,10831), t3x128(:,:,2906))
  call heltable([8,16,128], n3(:,10832), t3x128(:,:,2907))
  call heltable([8,16,128], n3(:,10833), t3x128(:,:,2908))
  call heltable([8,16,128], n3(:,10834), t3x128(:,:,2909))
  call heltable([8,16,128], n3(:,10835), t3x128(:,:,2910))
  call heltable([8,16,128], n3(:,10836), t3x128(:,:,2911))
  call heltable([8,16,128], n3(:,10837), t3x128(:,:,2912))
  call heltable([8,16,128], n3(:,10838), t3x128(:,:,2913))
  call heltable([8,16,128], n3(:,10839), t3x128(:,:,2914))
  call heltable([8,16,128], n3(:,10840), t3x128(:,:,2915))
  call heltable([8,16,128], n3(:,10841), t3x128(:,:,2916))
  call heltable([8,16,128], n3(:,10842), t3x128(:,:,2917))
  call heltable([8,16,128], n3(:,10843), t3x128(:,:,2918))
  call heltable([8,16,128], n3(:,10844), t3x128(:,:,2919))
  call heltable([8,16,128], n3(:,10845), t3x128(:,:,2920))
  call heltable([8,16,128], n3(:,10846), t3x128(:,:,2921))
  call heltable([8,16,128], n3(:,10847), t3x128(:,:,2922))
  call heltable([8,16,128], n3(:,10848), t3x128(:,:,2923))
  call heltable([8,16,128], n3(:,10849), t3x128(:,:,2924))
  call heltable([8,16,128], n3(:,10850), t3x128(:,:,2925))
  call heltable([8,16,128], n3(:,10851), t3x128(:,:,2926))
  call heltable([8,16,128], n3(:,10852), t3x128(:,:,2927))
  call heltable([8,16,128], n3(:,10853), t3x128(:,:,2928))
  call heltable([8,16,128], n3(:,10854), t3x128(:,:,2929))
  call heltable([8,16,128], n3(:,10855), t3x128(:,:,2930))
  call heltable([8,16,128], n3(:,10856), t3x128(:,:,2931))
  call heltable([8,16,128], n3(:,10857), t3x128(:,:,2932))
  call heltable([8,16,128], n3(:,10858), t3x128(:,:,2933))
  call heltable([8,16,128], n3(:,10859), t3x128(:,:,2934))
  call heltable([8,16,128], n3(:,10860), t3x128(:,:,2935))
  call heltable([8,16,128], n3(:,10861), t3x128(:,:,2936))
  call heltable([8,16,128], n3(:,10862), t3x128(:,:,2937))
  call heltable([8,16,128], n3(:,10863), t3x128(:,:,2938))
  call heltable([8,16,128], n3(:,10864), t3x128(:,:,2939))
  call heltable([8,16,128], n3(:,10865), t3x128(:,:,2940))
  call heltable([8,16,128], n3(:,10866), t3x128(:,:,2941))
  call heltable([8,16,128], n3(:,10867), t3x128(:,:,2942))
  call heltable([8,16,128], n3(:,10868), t3x128(:,:,2943))
  call heltable([8,16,128], n3(:,10869), t3x128(:,:,2944))
  call heltable([8,16,128], n3(:,10870), t3x128(:,:,2945))
  call heltable([8,16,128], n3(:,10871), t3x128(:,:,2946))
  call heltable([8,16,128], n3(:,10872), t3x128(:,:,2947))
  call heltable([8,16,128], n3(:,10873), t3x128(:,:,2948))
  call heltable([8,16,128], n3(:,10874), t3x128(:,:,2949))
  call heltable([8,16,128], n3(:,10875), t3x128(:,:,2950))
  call heltable([8,16,128], n3(:,10876), t3x128(:,:,2951))
  call heltable([8,16,128], n3(:,10877), t3x128(:,:,2952))
  call heltable([8,16,128], n3(:,10878), t3x128(:,:,2953))
  call heltable([8,16,128], n3(:,10879), t3x128(:,:,2954))
  call heltable([8,16,128], n3(:,10880), t3x128(:,:,2955))
  call heltable([8,16,128], n3(:,10881), t3x128(:,:,2956))
  call heltable([8,16,128], n3(:,10882), t3x128(:,:,2957))
  call heltable([8,16,128], n3(:,10883), t3x128(:,:,2958))
  call heltable([8,16,128], n3(:,10884), t3x128(:,:,2959))
  call heltable([8,16,128], n3(:,10885), t3x128(:,:,2960))
  call heltable([8,16,128], n3(:,10886), t3x128(:,:,2961))
  call heltable([8,16,128], n3(:,10887), t3x128(:,:,2962))
  call heltable([8,16,128], n3(:,10888), t3x128(:,:,2963))
  call heltable([8,16,128], n3(:,10889), t3x128(:,:,2964))
  call heltable([8,16,128], n3(:,10890), t3x128(:,:,2965))
  call heltable([8,16,128], n3(:,10891), t3x128(:,:,2966))
  call heltable([8,16,128], n3(:,10892), t3x128(:,:,2967))
  call heltable([8,16,128], n3(:,10893), t3x128(:,:,2968))
  call heltable([8,16,128], n3(:,10894), t3x128(:,:,2969))
  call heltable([8,16,128], n3(:,10895), t3x128(:,:,2970))
  call heltable([8,16,128], n3(:,10896), t3x128(:,:,2971))
  call heltable([8,16,128], n3(:,10897), t3x128(:,:,2972))
  call heltable([8,16,128], n3(:,10898), t3x128(:,:,2973))
  call heltable([8,16,128], n3(:,10899), t3x128(:,:,2974))
  call heltable([8,16,128], n3(:,10900), t3x128(:,:,2975))
  call heltable([8,16,128], n3(:,10901), t3x128(:,:,2976))
  call heltable([8,16,128], n3(:,10902), t3x128(:,:,2977))
  call heltable([16,8,128], n3(:,10903), t3x128(:,:,2978))
  call heltable([16,8,128], n3(:,10904), t3x128(:,:,2979))
  call heltable([16,8,128], n3(:,10905), t3x128(:,:,2980))
  call heltable([16,8,128], n3(:,10906), t3x128(:,:,2981))
  call heltable([16,8,128], n3(:,10907), t3x128(:,:,2982))
  call heltable([16,8,128], n3(:,10908), t3x128(:,:,2983))
  call heltable([16,8,128], n3(:,10909), t3x128(:,:,2984))
  call heltable([16,8,128], n3(:,10910), t3x128(:,:,2985))
  call heltable([16,8,128], n3(:,10911), t3x128(:,:,2986))
  call heltable([16,8,128], n3(:,10912), t3x128(:,:,2987))
  call heltable([16,8,128], n3(:,10913), t3x128(:,:,2988))
  call heltable([16,8,128], n3(:,10914), t3x128(:,:,2989))
  call heltable([16,8,128], n3(:,10915), t3x128(:,:,2990))
  call heltable([16,8,128], n3(:,10916), t3x128(:,:,2991))
  call heltable([16,8,128], n3(:,10917), t3x128(:,:,2992))
  call heltable([16,8,128], n3(:,10918), t3x128(:,:,2993))
  call heltable([16,8,128], n3(:,10919), t3x128(:,:,2994))
  call heltable([16,8,128], n3(:,10920), t3x128(:,:,2995))
  call heltable([16,8,128], n3(:,10921), t3x128(:,:,2996))
  call heltable([16,8,128], n3(:,10922), t3x128(:,:,2997))
  call heltable([16,8,128], n3(:,10923), t3x128(:,:,2998))
  call heltable([16,8,128], n3(:,10924), t3x128(:,:,2999))
  call heltable([16,8,128], n3(:,10925), t3x128(:,:,3000))
  call heltable([16,8,128], n3(:,10926), t3x128(:,:,3001))
  call heltable([16,8,128], n3(:,10927), t3x128(:,:,3002))
  call heltable([16,8,128], n3(:,10928), t3x128(:,:,3003))
  call heltable([16,8,128], n3(:,10929), t3x128(:,:,3004))
  call heltable([16,8,128], n3(:,10930), t3x128(:,:,3005))
  call heltable([16,8,128], n3(:,10931), t3x128(:,:,3006))
  call heltable([16,8,128], n3(:,10932), t3x128(:,:,3007))
  call heltable([16,8,128], n3(:,10933), t3x128(:,:,3008))
  call heltable([16,8,128], n3(:,10934), t3x128(:,:,3009))
  call heltable([16,8,128], n3(:,10935), t3x128(:,:,3010))
  call heltable([16,8,128], n3(:,10936), t3x128(:,:,3011))
  call heltable([16,8,128], n3(:,10937), t3x128(:,:,3012))
  call heltable([16,8,128], n3(:,10938), t3x128(:,:,3013))
  call heltable([16,8,128], n3(:,10939), t3x128(:,:,3014))
  call heltable([16,8,128], n3(:,10940), t3x128(:,:,3015))
  call heltable([16,8,128], n3(:,10941), t3x128(:,:,3016))
  call heltable([16,8,128], n3(:,10942), t3x128(:,:,3017))
  call heltable([16,8,128], n3(:,10943), t3x128(:,:,3018))
  call heltable([16,8,128], n3(:,10944), t3x128(:,:,3019))
  call heltable([16,8,128], n3(:,10945), t3x128(:,:,3020))
  call heltable([16,8,128], n3(:,10946), t3x128(:,:,3021))
  call heltable([16,8,128], n3(:,10947), t3x128(:,:,3022))
  call heltable([16,8,128], n3(:,10948), t3x128(:,:,3023))
  call heltable([16,8,128], n3(:,10949), t3x128(:,:,3024))
  call heltable([16,8,128], n3(:,10950), t3x128(:,:,3025))
  call heltable([16,8,128], n3(:,10951), t3x128(:,:,3026))
  call heltable([16,8,128], n3(:,10952), t3x128(:,:,3027))
  call heltable([16,8,128], n3(:,10953), t3x128(:,:,3028))
  call heltable([16,8,128], n3(:,10954), t3x128(:,:,3029))
  call heltable([16,8,128], n3(:,10955), t3x128(:,:,3030))
  call heltable([16,8,128], n3(:,10956), t3x128(:,:,3031))
  call heltable([16,8,128], n3(:,10957), t3x128(:,:,3032))
  call heltable([16,8,128], n3(:,10958), t3x128(:,:,3033))
  call heltable([16,8,128], n3(:,10959), t3x128(:,:,3034))
  call heltable([16,8,128], n3(:,10960), t3x128(:,:,3035))
  call heltable([16,8,128], n3(:,10961), t3x128(:,:,3036))
  call heltable([16,8,128], n3(:,10962), t3x128(:,:,3037))
  call heltable([16,8,128], n3(:,10963), t3x128(:,:,3038))
  call heltable([16,8,128], n3(:,10964), t3x128(:,:,3039))
  call heltable([16,8,128], n3(:,10965), t3x128(:,:,3040))
  call heltable([16,8,128], n3(:,10966), t3x128(:,:,3041))
  call heltable([16,8,128], n3(:,10967), t3x128(:,:,3042))
  call heltable([16,8,128], n3(:,10968), t3x128(:,:,3043))
  call heltable([16,8,128], n3(:,10969), t3x128(:,:,3044))
  call heltable([16,8,128], n3(:,10970), t3x128(:,:,3045))
  call heltable([16,8,128], n3(:,10971), t3x128(:,:,3046))
  call heltable([8,16,128], n3(:,10972), t3x128(:,:,3047))
  call heltable([8,16,128], n3(:,10973), t3x128(:,:,3048))
  call heltable([8,16,128], n3(:,10974), t3x128(:,:,3049))
  call heltable([8,16,128], n3(:,10975), t3x128(:,:,3050))
  call heltable([8,16,128], n3(:,10976), t3x128(:,:,3051))
  call heltable([8,16,128], n3(:,10977), t3x128(:,:,3052))
  call heltable([8,16,128], n3(:,10978), t3x128(:,:,3053))
  call heltable([8,16,128], n3(:,10979), t3x128(:,:,3054))
  call heltable([8,16,128], n3(:,10980), t3x128(:,:,3055))
  call heltable([8,16,128], n3(:,10981), t3x128(:,:,3056))
  call heltable([8,16,128], n3(:,10982), t3x128(:,:,3057))
  call heltable([8,16,128], n3(:,10983), t3x128(:,:,3058))
  call heltable([8,16,128], n3(:,10984), t3x128(:,:,3059))
  call heltable([8,16,128], n3(:,10985), t3x128(:,:,3060))
  call heltable([8,16,128], n3(:,10986), t3x128(:,:,3061))
  call heltable([8,16,128], n3(:,10987), t3x128(:,:,3062))
  call heltable([8,16,128], n3(:,10988), t3x128(:,:,3063))
  call heltable([8,16,128], n3(:,10989), t3x128(:,:,3064))
  call heltable([8,16,128], n3(:,10990), t3x128(:,:,3065))
  call heltable([8,16,128], n3(:,10991), t3x128(:,:,3066))
  call heltable([8,16,128], n3(:,10992), t3x128(:,:,3067))
  call heltable([8,16,128], n3(:,10993), t3x128(:,:,3068))
  call heltable([8,16,128], n3(:,10994), t3x128(:,:,3069))
  call heltable([8,16,128], n3(:,10995), t3x128(:,:,3070))
  call heltable([8,16,128], n3(:,10996), t3x128(:,:,3071))
  call heltable([8,16,128], n3(:,10997), t3x128(:,:,3072))
  call heltable([8,16,128], n3(:,10998), t3x128(:,:,3073))
  call heltable([8,16,128], n3(:,10999), t3x128(:,:,3074))
  call heltable([8,16,128], n3(:,11000), t3x128(:,:,3075))
  call heltable([8,16,128], n3(:,11001), t3x128(:,:,3076))
  call heltable([8,16,128], n3(:,11002), t3x128(:,:,3077))
  call heltable([8,16,128], n3(:,11003), t3x128(:,:,3078))
  call heltable([8,16,128], n3(:,11004), t3x128(:,:,3079))
  call heltable([8,16,128], n3(:,11005), t3x128(:,:,3080))
  call heltable([8,16,128], n3(:,11006), t3x128(:,:,3081))
  call heltable([8,16,128], n3(:,11007), t3x128(:,:,3082))
  call heltable([8,16,128], n3(:,11008), t3x128(:,:,3083))
  call heltable([8,16,128], n3(:,11009), t3x128(:,:,3084))
  call heltable([8,16,128], n3(:,11010), t3x128(:,:,3085))
  call heltable([8,16,128], n3(:,11011), t3x128(:,:,3086))
  call heltable([8,16,128], n3(:,11012), t3x128(:,:,3087))
  call heltable([8,16,128], n3(:,11013), t3x128(:,:,3088))
  call heltable([8,16,128], n3(:,11014), t3x128(:,:,3089))
  call heltable([8,16,128], n3(:,11015), t3x128(:,:,3090))
  call heltable([8,16,128], n3(:,11016), t3x128(:,:,3091))
  call heltable([8,16,128], n3(:,11017), t3x128(:,:,3092))
  call heltable([8,16,128], n3(:,11018), t3x128(:,:,3093))
  call heltable([8,16,128], n3(:,11019), t3x128(:,:,3094))
  call heltable([8,16,128], n3(:,11020), t3x128(:,:,3095))
  call heltable([8,16,128], n3(:,11021), t3x128(:,:,3096))
  call heltable([8,16,128], n3(:,11022), t3x128(:,:,3097))
  call heltable([8,16,128], n3(:,11023), t3x128(:,:,3098))
  call heltable([8,16,128], n3(:,11024), t3x128(:,:,3099))
  call heltable([8,16,128], n3(:,11025), t3x128(:,:,3100))
  call heltable([8,16,128], n3(:,11026), t3x128(:,:,3101))
  call heltable([8,16,128], n3(:,11027), t3x128(:,:,3102))
  call heltable([8,16,128], n3(:,11028), t3x128(:,:,3103))
  call heltable([8,16,128], n3(:,11029), t3x128(:,:,3104))
  call heltable([8,16,128], n3(:,11030), t3x128(:,:,3105))
  call heltable([8,16,128], n3(:,11031), t3x128(:,:,3106))
  call heltable([8,16,128], n3(:,11032), t3x128(:,:,3107))
  call heltable([8,16,128], n3(:,11033), t3x128(:,:,3108))
  call heltable([8,16,128], n3(:,11034), t3x128(:,:,3109))
  call heltable([8,16,128], n3(:,11035), t3x128(:,:,3110))
  call heltable([8,16,128], n3(:,11036), t3x128(:,:,3111))
  call heltable([8,16,128], n3(:,11037), t3x128(:,:,3112))
  call heltable([8,16,128], n3(:,11038), t3x128(:,:,3113))
  call heltable([8,16,128], n3(:,11039), t3x128(:,:,3114))
  call heltable([8,16,128], n3(:,11040), t3x128(:,:,3115))
  call heltable([8,16,128], n3(:,11041), t3x128(:,:,3116))
  call heltable([8,16,128], n3(:,11042), t3x128(:,:,3117))
  call heltable([8,16,128], n3(:,11043), t3x128(:,:,3118))
  call heltable([8,16,128], n3(:,11044), t3x128(:,:,3119))
  call heltable([8,16,128], n3(:,11045), t3x128(:,:,3120))
  call heltable([8,16,128], n3(:,11046), t3x128(:,:,3121))
  call heltable([8,16,128], n3(:,11047), t3x128(:,:,3122))
  call heltable([8,16,128], n3(:,11048), t3x128(:,:,3123))
  call heltable([8,16,128], n3(:,11049), t3x128(:,:,3124))
  call heltable([8,16,128], n3(:,11050), t3x128(:,:,3125))
  call heltable([8,16,128], n3(:,11051), t3x128(:,:,3126))
  call heltable([8,16,128], n3(:,11052), t3x128(:,:,3127))
  call heltable([8,16,128], n3(:,11053), t3x128(:,:,3128))
  call heltable([8,16,128], n3(:,11054), t3x128(:,:,3129))
  call heltable([8,16,128], n3(:,11055), t3x128(:,:,3130))
  call heltable([8,16,128], n3(:,11056), t3x128(:,:,3131))
  call heltable([8,16,128], n3(:,11057), t3x128(:,:,3132))
  call heltable([8,16,128], n3(:,11058), t3x128(:,:,3133))
  call heltable([8,16,128], n3(:,11059), t3x128(:,:,3134))
  call heltable([8,16,128], n3(:,11060), t3x128(:,:,3135))
  call heltable([8,16,128], n3(:,11061), t3x128(:,:,3136))
  call heltable([8,16,128], n3(:,11062), t3x128(:,:,3137))
  call heltable([8,16,128], n3(:,11063), t3x128(:,:,3138))
  call heltable([8,16,128], n3(:,11064), t3x128(:,:,3139))
  call heltable([8,16,128], n3(:,11065), t3x128(:,:,3140))
  call heltable([8,16,128], n3(:,11066), t3x128(:,:,3141))
  call heltable([8,16,128], n3(:,11067), t3x128(:,:,3142))
  call heltable([8,16,128], n3(:,11068), t3x128(:,:,3143))
  call heltable([8,16,128], n3(:,11069), t3x128(:,:,3144))
  call heltable([8,16,128], n3(:,11070), t3x128(:,:,3145))
  call heltable([8,16,128], n3(:,11071), t3x128(:,:,3146))
  call heltable([8,16,128], n3(:,11072), t3x128(:,:,3147))
  call heltable([8,16,128], n3(:,11073), t3x128(:,:,3148))
  call heltable([8,16,128], n3(:,11074), t3x128(:,:,3149))
  call heltable([8,16,128], n3(:,11075), t3x128(:,:,3150))
  call heltable([8,16,128], n3(:,11076), t3x128(:,:,3151))
  call heltable([8,16,128], n3(:,11077), t3x128(:,:,3152))
  call heltable([8,16,128], n3(:,11078), t3x128(:,:,3153))
  call heltable([8,16,128], n3(:,11079), t3x128(:,:,3154))
  call heltable([8,16,128], n3(:,11080), t3x128(:,:,3155))
  call heltable([8,16,128], n3(:,11081), t3x128(:,:,3156))
  call heltable([8,16,128], n3(:,11082), t3x128(:,:,3157))
  call heltable([8,16,128], n3(:,11083), t3x128(:,:,3158))
  call heltable([8,16,128], n3(:,11084), t3x128(:,:,3159))
  call heltable([8,16,128], n3(:,11085), t3x128(:,:,3160))
  call heltable([8,16,128], n3(:,11086), t3x128(:,:,3161))
  call heltable([8,16,128], n3(:,11087), t3x128(:,:,3162))
  call heltable([8,16,128], n3(:,11088), t3x128(:,:,3163))
  call heltable([8,16,128], n3(:,11089), t3x128(:,:,3164))
  call heltable([8,16,128], n3(:,11090), t3x128(:,:,3165))
  call heltable([8,16,128], n3(:,11091), t3x128(:,:,3166))
  call heltable([8,16,128], n3(:,11092), t3x128(:,:,3167))
  call heltable([8,16,128], n3(:,11093), t3x128(:,:,3168))
  call heltable([8,16,128], n3(:,11094), t3x128(:,:,3169))
  call heltable([8,16,128], n3(:,11095), t3x128(:,:,3170))
  call heltable([8,16,128], n3(:,11096), t3x128(:,:,3171))
  call heltable([8,16,128], n3(:,11097), t3x128(:,:,3172))
  call heltable([8,16,128], n3(:,11098), t3x128(:,:,3173))
  call heltable([8,16,128], n3(:,11099), t3x128(:,:,3174))
  call heltable([8,16,128], n3(:,11100), t3x128(:,:,3175))
  call heltable([8,16,128], n3(:,11101), t3x128(:,:,3176))
  call heltable([8,16,128], n3(:,11102), t3x128(:,:,3177))
  call heltable([8,16,128], n3(:,11103), t3x128(:,:,3178))
  call heltable([8,16,128], n3(:,11104), t3x128(:,:,3179))
  call heltable([8,16,128], n3(:,11105), t3x128(:,:,3180))
  call heltable([8,16,128], n3(:,11106), t3x128(:,:,3181))
  call heltable([8,16,128], n3(:,11107), t3x128(:,:,3182))
  call heltable([8,16,128], n3(:,11108), t3x128(:,:,3183))
  call heltable([8,16,128], n3(:,11109), t3x128(:,:,3184))
  call heltable([8,16,128], n3(:,11110), t3x128(:,:,3185))
  call heltable([8,16,128], n3(:,11111), t3x128(:,:,3186))
  call heltable([8,16,128], n3(:,11112), t3x128(:,:,3187))
  call heltable([8,16,128], n3(:,11113), t3x128(:,:,3188))
  call heltable([8,16,128], n3(:,11114), t3x128(:,:,3189))
  call heltable([8,16,128], n3(:,11115), t3x128(:,:,3190))
  call heltable([8,16,128], n3(:,11116), t3x128(:,:,3191))
  call heltable([8,16,128], n3(:,11117), t3x128(:,:,3192))
  call heltable([8,16,128], n3(:,11118), t3x128(:,:,3193))
  call heltable([8,16,128], n3(:,11119), t3x128(:,:,3194))
  call heltable([8,16,128], n3(:,11120), t3x128(:,:,3195))
  call heltable([8,16,128], n3(:,11121), t3x128(:,:,3196))
  call heltable([8,16,128], n3(:,11122), t3x128(:,:,3197))
  call heltable([8,16,128], n3(:,11123), t3x128(:,:,3198))
  call heltable([8,16,128], n3(:,11124), t3x128(:,:,3199))
  call heltable([8,16,128], n3(:,11125), t3x128(:,:,3200))
  call heltable([8,16,128], n3(:,11126), t3x128(:,:,3201))
  call heltable([8,16,128], n3(:,11127), t3x128(:,:,3202))
  call heltable([8,16,128], n3(:,11128), t3x128(:,:,3203))
  call heltable([8,16,128], n3(:,11129), t3x128(:,:,3204))
  call heltable([8,16,128], n3(:,11130), t3x128(:,:,3205))
  call heltable([8,16,128], n3(:,11131), t3x128(:,:,3206))
  call heltable([8,16,128], n3(:,11132), t3x128(:,:,3207))
  call heltable([8,16,128], n3(:,11133), t3x128(:,:,3208))
  call heltable([8,16,128], n3(:,11134), t3x128(:,:,3209))
  call heltable([8,16,128], n3(:,11135), t3x128(:,:,3210))
  call heltable([8,16,128], n3(:,11136), t3x128(:,:,3211))
  call heltable([8,16,128], n3(:,11137), t3x128(:,:,3212))
  call heltable([8,16,128], n3(:,11138), t3x128(:,:,3213))
  call heltable([8,16,128], n3(:,11139), t3x128(:,:,3214))
  call heltable([8,16,128], n3(:,11140), t3x128(:,:,3215))
  call heltable([8,16,128], n3(:,11141), t3x128(:,:,3216))
  call heltable([8,16,128], n3(:,11142), t3x128(:,:,3217))
  call heltable([8,16,128], n3(:,11143), t3x128(:,:,3218))
  call heltable([8,16,128], n3(:,11144), t3x128(:,:,3219))
  call heltable([8,16,128], n3(:,11145), t3x128(:,:,3220))
  call heltable([8,16,128], n3(:,11146), t3x128(:,:,3221))
  call heltable([8,16,128], n3(:,11147), t3x128(:,:,3222))
  call heltable([8,16,128], n3(:,11148), t3x128(:,:,3223))
  call heltable([8,16,128], n3(:,11149), t3x128(:,:,3224))
  call heltable([8,16,128], n3(:,11150), t3x128(:,:,3225))
  call heltable([8,16,128], n3(:,11151), t3x128(:,:,3226))
  call heltable([8,16,128], n3(:,11152), t3x128(:,:,3227))
  call heltable([8,16,128], n3(:,11153), t3x128(:,:,3228))
  call heltable([8,16,128], n3(:,11154), t3x128(:,:,3229))
  call heltable([8,16,128], n3(:,11155), t3x128(:,:,3230))
  call heltable([8,16,128], n3(:,11156), t3x128(:,:,3231))
  call heltable([8,16,128], n3(:,11157), t3x128(:,:,3232))
  call heltable([8,16,128], n3(:,11158), t3x128(:,:,3233))
  call heltable([8,16,128], n3(:,11159), t3x128(:,:,3234))
  call heltable([8,16,128], n3(:,11160), t3x128(:,:,3235))
  call heltable([8,16,128], n3(:,11161), t3x128(:,:,3236))
  call heltable([8,16,128], n3(:,11162), t3x128(:,:,3237))
  call heltable([8,16,128], n3(:,11163), t3x128(:,:,3238))
  call heltable([8,16,128], n3(:,11164), t3x128(:,:,3239))
  call heltable([8,16,128], n3(:,11165), t3x128(:,:,3240))
  call heltable([8,16,128], n3(:,11166), t3x128(:,:,3241))
  call heltable([8,16,128], n3(:,11167), t3x128(:,:,3242))
  call heltable([8,16,128], n3(:,11168), t3x128(:,:,3243))
  call heltable([8,16,128], n3(:,11169), t3x128(:,:,3244))
  call heltable([8,16,128], n3(:,11170), t3x128(:,:,3245))
  call heltable([8,16,128], n3(:,11171), t3x128(:,:,3246))
  call heltable([8,16,128], n3(:,11172), t3x128(:,:,3247))
  call heltable([8,16,128], n3(:,11173), t3x128(:,:,3248))
  call heltable([8,16,128], n3(:,11174), t3x128(:,:,3249))
  call heltable([8,16,128], n3(:,11175), t3x128(:,:,3250))
  call heltable([8,16,128], n3(:,11176), t3x128(:,:,3251))
  call heltable([8,16,128], n3(:,11177), t3x128(:,:,3252))
  call heltable([8,16,128], n3(:,11178), t3x128(:,:,3253))
  call heltable([8,16,128], n3(:,11179), t3x128(:,:,3254))
  call heltable([8,16,128], n3(:,11180), t3x128(:,:,3255))
  call heltable([8,16,128], n3(:,11181), t3x128(:,:,3256))
  call heltable([8,16,128], n3(:,11182), t3x128(:,:,3257))
  call heltable([8,16,128], n3(:,11183), t3x128(:,:,3258))
  call heltable([8,16,128], n3(:,11184), t3x128(:,:,3259))
  call heltable([8,16,128], n3(:,11185), t3x128(:,:,3260))
  call heltable([8,16,128], n3(:,11186), t3x128(:,:,3261))
  call heltable([8,16,128], n3(:,11187), t3x128(:,:,3262))
  call heltable([8,16,128], n3(:,11188), t3x128(:,:,3263))
  call heltable([8,16,128], n3(:,11189), t3x128(:,:,3264))
  call heltable([8,16,128], n3(:,11190), t3x128(:,:,3265))
  call heltable([8,16,128], n3(:,11191), t3x128(:,:,3266))
  call heltable([8,16,128], n3(:,11192), t3x128(:,:,3267))
  call heltable([8,16,128], n3(:,11193), t3x128(:,:,3268))
  call heltable([8,16,128], n3(:,11194), t3x128(:,:,3269))
  call heltable([8,16,128], n3(:,11195), t3x128(:,:,3270))
  call heltable([8,16,128], n3(:,11196), t3x128(:,:,3271))
  call heltable([8,16,128], n3(:,11197), t3x128(:,:,3272))
  call heltable([8,16,128], n3(:,11198), t3x128(:,:,3273))
  call heltable([8,16,128], n3(:,11199), t3x128(:,:,3274))
  call heltable([8,16,128], n3(:,11200), t3x128(:,:,3275))
  call heltable([8,16,128], n3(:,11201), t3x128(:,:,3276))
  call heltable([8,16,128], n3(:,11202), t3x128(:,:,3277))
  call heltable([8,16,128], n3(:,11203), t3x128(:,:,3278))
  call heltable([8,16,128], n3(:,11204), t3x128(:,:,3279))
  call heltable([8,16,128], n3(:,11205), t3x128(:,:,3280))
  call heltable([8,16,128], n3(:,11206), t3x128(:,:,3281))
  call heltable([8,16,128], n3(:,11207), t3x128(:,:,3282))
  call heltable([8,16,128], n3(:,11208), t3x128(:,:,3283))
  call heltable([8,16,128], n3(:,11209), t3x128(:,:,3284))
  call heltable([8,16,128], n3(:,11210), t3x128(:,:,3285))
  call heltable([8,16,128], n3(:,11211), t3x128(:,:,3286))
  call heltable([8,16,128], n3(:,11212), t3x128(:,:,3287))
  call heltable([8,16,128], n3(:,11213), t3x128(:,:,3288))
  call heltable([8,16,128], n3(:,11214), t3x128(:,:,3289))
  call heltable([8,16,128], n3(:,11215), t3x128(:,:,3290))
  call heltable([8,16,128], n3(:,11216), t3x128(:,:,3291))
  call heltable([8,16,128], n3(:,11217), t3x128(:,:,3292))
  call heltable([8,16,128], n3(:,11218), t3x128(:,:,3293))
  call heltable([8,16,128], n3(:,11219), t3x128(:,:,3294))
  call heltable([16,8,128], n3(:,11220), t3x128(:,:,3295))
  call heltable([16,8,128], n3(:,11221), t3x128(:,:,3296))
  call heltable([16,8,128], n3(:,11222), t3x128(:,:,3297))
  call heltable([16,8,128], n3(:,11223), t3x128(:,:,3298))
  call heltable([16,8,128], n3(:,11224), t3x128(:,:,3299))
  call heltable([16,8,128], n3(:,11225), t3x128(:,:,3300))
  call heltable([16,8,128], n3(:,11226), t3x128(:,:,3301))
  call heltable([16,8,128], n3(:,11227), t3x128(:,:,3302))
  call heltable([16,8,128], n3(:,11228), t3x128(:,:,3303))
  call heltable([16,8,128], n3(:,11229), t3x128(:,:,3304))
  call heltable([16,8,128], n3(:,11230), t3x128(:,:,3305))
  call heltable([16,8,128], n3(:,11231), t3x128(:,:,3306))
  call heltable([16,8,128], n3(:,11232), t3x128(:,:,3307))
  call heltable([8,16,128], n3(:,11233), t3x128(:,:,3308))
  call heltable([16,8,128], n3(:,11234), t3x128(:,:,3309))
  call heltable([8,16,128], n3(:,11235), t3x128(:,:,3310))
  call heltable([8,16,128], n3(:,11236), t3x128(:,:,3311))
  call heltable([16,8,128], n3(:,11237), t3x128(:,:,3312))
  call heltable([16,8,128], n3(:,11238), t3x128(:,:,3313))
  call heltable([16,8,128], n3(:,11239), t3x128(:,:,3314))
  call heltable([16,8,128], n3(:,11240), t3x128(:,:,3315))
  call heltable([8,16,128], n3(:,11241), t3x128(:,:,3316))
  call heltable([8,16,128], n3(:,11242), t3x128(:,:,3317))
  call heltable([8,16,128], n3(:,11243), t3x128(:,:,3318))
  call heltable([8,16,128], n3(:,11244), t3x128(:,:,3319))
  call heltable([8,16,128], n3(:,11245), t3x128(:,:,3320))
  call heltable([8,16,128], n3(:,11246), t3x128(:,:,3321))
  call heltable([8,16,128], n3(:,11247), t3x128(:,:,3322))
  call heltable([8,16,128], n3(:,11248), t3x128(:,:,3323))
  call heltable([8,16,128], n3(:,11249), t3x128(:,:,3324))
  call heltable([8,16,128], n3(:,11250), t3x128(:,:,3325))
  call heltable([16,8,128], n3(:,11251), t3x128(:,:,3326))
  call heltable([16,8,128], n3(:,11252), t3x128(:,:,3327))
  call heltable([8,16,128], n3(:,11253), t3x128(:,:,3328))
  call heltable([8,16,128], n3(:,11254), t3x128(:,:,3329))
  call heltable([8,16,128], n3(:,11255), t3x128(:,:,3330))
  call heltable([8,16,128], n3(:,11256), t3x128(:,:,3331))
  call heltable([16,8,128], n3(:,11257), t3x128(:,:,3332))
  call heltable([16,8,128], n3(:,11258), t3x128(:,:,3333))
  call heltable([16,8,128], n3(:,11259), t3x128(:,:,3334))
  call heltable([16,8,128], n3(:,11260), t3x128(:,:,3335))
  call heltable([16,8,128], n3(:,11261), t3x128(:,:,3336))
  call heltable([16,8,128], n3(:,11262), t3x128(:,:,3337))
  call heltable([16,8,128], n3(:,11263), t3x128(:,:,3338))
  call heltable([16,8,128], n3(:,11264), t3x128(:,:,3339))
  call heltable([16,8,128], n3(:,11265), t3x128(:,:,3340))
  call heltable([16,8,128], n3(:,11266), t3x128(:,:,3341))
  call heltable([16,8,128], n3(:,11267), t3x128(:,:,3342))
  call heltable([16,8,128], n3(:,11268), t3x128(:,:,3343))
  call heltable([16,8,128], n3(:,11269), t3x128(:,:,3344))
  call heltable([16,8,128], n3(:,11270), t3x128(:,:,3345))
  call heltable([16,8,128], n3(:,11271), t3x128(:,:,3346))
  call heltable([16,8,128], n3(:,11272), t3x128(:,:,3347))
  call heltable([16,8,128], n3(:,11273), t3x128(:,:,3348))
  call heltable([16,8,128], n3(:,11274), t3x128(:,:,3349))
  call heltable([16,8,128], n3(:,11275), t3x128(:,:,3350))
  call heltable([16,8,128], n3(:,11276), t3x128(:,:,3351))
  call heltable([16,8,128], n3(:,11277), t3x128(:,:,3352))
  call heltable([16,8,128], n3(:,11278), t3x128(:,:,3353))
  call heltable([16,8,128], n3(:,11279), t3x128(:,:,3354))
  call heltable([16,8,128], n3(:,11280), t3x128(:,:,3355))
  call heltable([16,8,128], n3(:,11281), t3x128(:,:,3356))
  call heltable([16,8,128], n3(:,11282), t3x128(:,:,3357))
  call heltable([16,8,128], n3(:,11283), t3x128(:,:,3358))
  call heltable([16,8,128], n3(:,11284), t3x128(:,:,3359))
  call heltable([16,8,128], n3(:,11285), t3x128(:,:,3360))
  call heltable([16,8,128], n3(:,11286), t3x128(:,:,3361))
  call heltable([16,8,128], n3(:,11287), t3x128(:,:,3362))
  call heltable([16,8,128], n3(:,11288), t3x128(:,:,3363))
  call heltable([16,8,128], n3(:,11289), t3x128(:,:,3364))
  call heltable([16,8,128], n3(:,11290), t3x128(:,:,3365))
  call heltable([16,8,128], n3(:,11291), t3x128(:,:,3366))
  call heltable([16,8,128], n3(:,11292), t3x128(:,:,3367))
  call heltable([16,8,128], n3(:,11293), t3x128(:,:,3368))
  call heltable([16,8,128], n3(:,11294), t3x128(:,:,3369))
  call heltable([16,8,128], n3(:,11295), t3x128(:,:,3370))
  call heltable([16,8,128], n3(:,11296), t3x128(:,:,3371))
  call heltable([8,16,128], n3(:,11297), t3x128(:,:,3372))
  call heltable([8,16,128], n3(:,11298), t3x128(:,:,3373))
  call heltable([8,16,128], n3(:,11299), t3x128(:,:,3374))
  call heltable([8,16,128], n3(:,11300), t3x128(:,:,3375))
  call heltable([8,16,128], n3(:,11301), t3x128(:,:,3376))
  call heltable([8,16,128], n3(:,11302), t3x128(:,:,3377))
  call heltable([8,16,128], n3(:,11303), t3x128(:,:,3378))
  call heltable([8,16,128], n3(:,11304), t3x128(:,:,3379))
  call heltable([8,16,128], n3(:,11305), t3x128(:,:,3380))
  call heltable([8,16,128], n3(:,11306), t3x128(:,:,3381))
  call heltable([8,16,128], n3(:,11307), t3x128(:,:,3382))
  call heltable([8,16,128], n3(:,11308), t3x128(:,:,3383))
  call heltable([8,16,128], n3(:,11309), t3x128(:,:,3384))
  call heltable([8,16,128], n3(:,11310), t3x128(:,:,3385))
  call heltable([8,16,128], n3(:,11311), t3x128(:,:,3386))
  call heltable([8,16,128], n3(:,11312), t3x128(:,:,3387))
  call heltable([8,16,128], n3(:,11313), t3x128(:,:,3388))
  call heltable([8,16,128], n3(:,11314), t3x128(:,:,3389))
  call heltable([8,16,128], n3(:,11315), t3x128(:,:,3390))
  call heltable([8,16,128], n3(:,11316), t3x128(:,:,3391))
  call heltable([8,16,128], n3(:,11317), t3x128(:,:,3392))
  call heltable([8,16,128], n3(:,11318), t3x128(:,:,3393))
  call heltable([8,16,128], n3(:,11319), t3x128(:,:,3394))
  call heltable([8,16,128], n3(:,11320), t3x128(:,:,3395))
  call heltable([8,16,128], n3(:,11321), t3x128(:,:,3396))
  call heltable([8,16,128], n3(:,11322), t3x128(:,:,3397))
  call heltable([8,16,128], n3(:,11323), t3x128(:,:,3398))
  call heltable([8,16,128], n3(:,11324), t3x128(:,:,3399))
  call heltable([8,16,128], n3(:,11325), t3x128(:,:,3400))
  call heltable([8,16,128], n3(:,11326), t3x128(:,:,3401))
  call heltable([8,16,128], n3(:,11327), t3x128(:,:,3402))
  call heltable([8,16,128], n3(:,11328), t3x128(:,:,3403))
  call heltable([16,8,128], n3(:,11329), t3x128(:,:,3404))
  call heltable([16,8,128], n3(:,11330), t3x128(:,:,3405))
  call heltable([16,8,128], n3(:,11331), t3x128(:,:,3406))
  call heltable([16,8,128], n3(:,11332), t3x128(:,:,3407))
  call heltable([16,8,128], n3(:,11333), t3x128(:,:,3408))
  call heltable([16,8,128], n3(:,11334), t3x128(:,:,3409))
  call heltable([16,8,128], n3(:,11335), t3x128(:,:,3410))
  call heltable([16,8,128], n3(:,11336), t3x128(:,:,3411))
  call heltable([16,8,128], n3(:,11337), t3x128(:,:,3412))
  call heltable([16,8,128], n3(:,11338), t3x128(:,:,3413))
  call heltable([16,8,128], n3(:,11339), t3x128(:,:,3414))
  call heltable([16,8,128], n3(:,11340), t3x128(:,:,3415))
  call heltable([16,8,128], n3(:,11341), t3x128(:,:,3416))
  call heltable([16,8,128], n3(:,11342), t3x128(:,:,3417))
  call heltable([16,8,128], n3(:,11343), t3x128(:,:,3418))
  call heltable([16,8,128], n3(:,11344), t3x128(:,:,3419))
  call heltable([16,8,128], n3(:,11345), t3x128(:,:,3420))
  call heltable([16,8,128], n3(:,11346), t3x128(:,:,3421))
  call heltable([16,8,128], n3(:,11347), t3x128(:,:,3422))
  call heltable([16,8,128], n3(:,11348), t3x128(:,:,3423))
  call heltable([16,8,128], n3(:,11349), t3x128(:,:,3424))
  call heltable([16,8,128], n3(:,11350), t3x128(:,:,3425))
  call heltable([16,8,128], n3(:,11351), t3x128(:,:,3426))
  call heltable([16,8,128], n3(:,11352), t3x128(:,:,3427))
  call heltable([16,8,128], n3(:,11353), t3x128(:,:,3428))
  call heltable([16,8,128], n3(:,11354), t3x128(:,:,3429))
  call heltable([8,16,128], n3(:,11355), t3x128(:,:,3430))
  call heltable([16,8,128], n3(:,11356), t3x128(:,:,3431))
  call heltable([8,16,128], n3(:,11357), t3x128(:,:,3432))
  call heltable([8,16,128], n3(:,11358), t3x128(:,:,3433))
  call heltable([16,8,128], n3(:,11359), t3x128(:,:,3434))
  call heltable([16,8,128], n3(:,11360), t3x128(:,:,3435))
  call heltable([16,8,128], n3(:,11361), t3x128(:,:,3436))
  call heltable([16,8,128], n3(:,11362), t3x128(:,:,3437))
  call heltable([8,16,128], n3(:,11363), t3x128(:,:,3438))
  call heltable([8,16,128], n3(:,11364), t3x128(:,:,3439))
  call heltable([8,16,128], n3(:,11365), t3x128(:,:,3440))
  call heltable([8,16,128], n3(:,11366), t3x128(:,:,3441))
  call heltable([8,16,128], n3(:,11367), t3x128(:,:,3442))
  call heltable([8,16,128], n3(:,11368), t3x128(:,:,3443))
  call heltable([8,16,128], n3(:,11369), t3x128(:,:,3444))
  call heltable([8,16,128], n3(:,11370), t3x128(:,:,3445))
  call heltable([8,16,128], n3(:,11371), t3x128(:,:,3446))
  call heltable([8,16,128], n3(:,11372), t3x128(:,:,3447))
  call heltable([16,8,128], n3(:,11373), t3x128(:,:,3448))
  call heltable([16,8,128], n3(:,11374), t3x128(:,:,3449))
  call heltable([8,16,128], n3(:,11375), t3x128(:,:,3450))
  call heltable([8,16,128], n3(:,11376), t3x128(:,:,3451))
  call heltable([8,16,128], n3(:,11377), t3x128(:,:,3452))
  call heltable([8,16,128], n3(:,11378), t3x128(:,:,3453))
  call heltable([16,8,128], n3(:,11379), t3x128(:,:,3454))
  call heltable([16,8,128], n3(:,11380), t3x128(:,:,3455))
  call heltable([16,8,128], n3(:,11381), t3x128(:,:,3456))
  call heltable([16,8,128], n3(:,11382), t3x128(:,:,3457))
  call heltable([16,8,128], n3(:,11383), t3x128(:,:,3458))
  call heltable([16,8,128], n3(:,11384), t3x128(:,:,3459))
  call heltable([16,8,128], n3(:,11385), t3x128(:,:,3460))
  call heltable([16,8,128], n3(:,11386), t3x128(:,:,3461))
  call heltable([8,16,128], n3(:,11387), t3x128(:,:,3462))
  call heltable([8,16,128], n3(:,11388), t3x128(:,:,3463))
  call heltable([8,16,128], n3(:,11389), t3x128(:,:,3464))
  call heltable([8,16,128], n3(:,11390), t3x128(:,:,3465))
  call heltable([8,16,128], n3(:,11391), t3x128(:,:,3466))
  call heltable([8,16,128], n3(:,11392), t3x128(:,:,3467))
  call heltable([8,16,128], n3(:,11393), t3x128(:,:,3468))
  call heltable([8,16,128], n3(:,11394), t3x128(:,:,3469))
  call heltable([8,16,128], n3(:,11395), t3x128(:,:,3470))
  call heltable([8,16,128], n3(:,11396), t3x128(:,:,3471))
  call heltable([8,16,128], n3(:,11397), t3x128(:,:,3472))
  call heltable([8,16,128], n3(:,11398), t3x128(:,:,3473))
  call heltable([8,16,128], n3(:,11399), t3x128(:,:,3474))
  call heltable([8,16,128], n3(:,11400), t3x128(:,:,3475))
  call heltable([8,16,128], n3(:,11401), t3x128(:,:,3476))
  call heltable([8,16,128], n3(:,11402), t3x128(:,:,3477))
  call heltable([8,16,128], n3(:,11403), t3x128(:,:,3478))
  call heltable([8,16,128], n3(:,11404), t3x128(:,:,3479))
  call heltable([8,16,128], n3(:,11405), t3x128(:,:,3480))
  call heltable([8,16,128], n3(:,11406), t3x128(:,:,3481))
  call heltable([8,16,128], n3(:,11407), t3x128(:,:,3482))
  call heltable([8,16,128], n3(:,11408), t3x128(:,:,3483))
  call heltable([8,16,128], n3(:,11409), t3x128(:,:,3484))
  call heltable([8,16,128], n3(:,11410), t3x128(:,:,3485))
  call heltable([8,16,128], n3(:,11411), t3x128(:,:,3486))
  call heltable([8,16,128], n3(:,11412), t3x128(:,:,3487))
  call heltable([8,16,128], n3(:,11413), t3x128(:,:,3488))
  call heltable([8,16,128], n3(:,11414), t3x128(:,:,3489))
  call heltable([8,16,128], n3(:,11415), t3x128(:,:,3490))
  call heltable([8,16,128], n3(:,11416), t3x128(:,:,3491))
  call heltable([8,16,128], n3(:,11417), t3x128(:,:,3492))
  call heltable([8,16,128], n3(:,11418), t3x128(:,:,3493))
  call heltable([8,16,128], n3(:,11419), t3x128(:,:,3494))
  call heltable([8,16,128], n3(:,11420), t3x128(:,:,3495))
  call heltable([8,16,128], n3(:,11421), t3x128(:,:,3496))
  call heltable([8,16,128], n3(:,11422), t3x128(:,:,3497))
  call heltable([8,16,128], n3(:,11423), t3x128(:,:,3498))
  call heltable([8,16,128], n3(:,11424), t3x128(:,:,3499))
  call heltable([8,16,128], n3(:,11425), t3x128(:,:,3500))
  call heltable([8,16,128], n3(:,11426), t3x128(:,:,3501))
  call heltable([8,16,128], n3(:,11427), t3x128(:,:,3502))
  call heltable([8,16,128], n3(:,11428), t3x128(:,:,3503))
  call heltable([8,16,128], n3(:,11429), t3x128(:,:,3504))
  call heltable([8,16,128], n3(:,11430), t3x128(:,:,3505))
  call heltable([8,16,128], n3(:,11431), t3x128(:,:,3506))
  call heltable([8,16,128], n3(:,11432), t3x128(:,:,3507))
  call heltable([8,16,128], n3(:,11433), t3x128(:,:,3508))
  call heltable([8,16,128], n3(:,11434), t3x128(:,:,3509))
  call heltable([8,16,128], n3(:,11435), t3x128(:,:,3510))
  call heltable([8,16,128], n3(:,11436), t3x128(:,:,3511))
  call heltable([8,16,128], n3(:,11437), t3x128(:,:,3512))
  call heltable([8,16,128], n3(:,11438), t3x128(:,:,3513))
  call heltable([8,16,128], n3(:,11439), t3x128(:,:,3514))
  call heltable([8,16,128], n3(:,11440), t3x128(:,:,3515))
  call heltable([8,16,128], n3(:,11441), t3x128(:,:,3516))
  call heltable([8,16,128], n3(:,11442), t3x128(:,:,3517))
  call heltable([8,16,128], n3(:,11443), t3x128(:,:,3518))
  call heltable([8,16,128], n3(:,11444), t3x128(:,:,3519))
  call heltable([8,16,128], n3(:,11445), t3x128(:,:,3520))
  call heltable([8,16,128], n3(:,11446), t3x128(:,:,3521))
  call heltable([8,16,128], n3(:,11447), t3x128(:,:,3522))
  call heltable([8,16,128], n3(:,11448), t3x128(:,:,3523))
  call heltable([8,16,128], n3(:,11449), t3x128(:,:,3524))
  call heltable([8,16,128], n3(:,11450), t3x128(:,:,3525))
  call heltable([16,8,128], n3(:,11451), t3x128(:,:,3526))
  call heltable([16,8,128], n3(:,11452), t3x128(:,:,3527))
  call heltable([16,8,128], n3(:,11453), t3x128(:,:,3528))
  call heltable([16,8,128], n3(:,11454), t3x128(:,:,3529))
  call heltable([16,8,128], n3(:,11455), t3x128(:,:,3530))
  call heltable([16,8,128], n3(:,11456), t3x128(:,:,3531))
  call heltable([16,8,128], n3(:,11457), t3x128(:,:,3532))
  call heltable([16,8,128], n3(:,11458), t3x128(:,:,3533))
  call heltable([16,8,128], n3(:,11459), t3x128(:,:,3534))
  call heltable([16,8,128], n3(:,11460), t3x128(:,:,3535))
  call heltable([16,8,128], n3(:,11461), t3x128(:,:,3536))
  call heltable([16,8,128], n3(:,11462), t3x128(:,:,3537))
  call heltable([16,8,128], n3(:,11463), t3x128(:,:,3538))
  call heltable([8,16,128], n3(:,11464), t3x128(:,:,3539))
  call heltable([8,16,128], n3(:,11465), t3x128(:,:,3540))
  call heltable([8,16,128], n3(:,11466), t3x128(:,:,3541))
  call heltable([8,16,128], n3(:,11467), t3x128(:,:,3542))
  call heltable([8,16,128], n3(:,11468), t3x128(:,:,3543))
  call heltable([8,16,128], n3(:,11469), t3x128(:,:,3544))
  call heltable([8,16,128], n3(:,11470), t3x128(:,:,3545))
  call heltable([8,16,128], n3(:,11471), t3x128(:,:,3546))
  call heltable([8,16,128], n3(:,11472), t3x128(:,:,3547))
  call heltable([8,16,128], n3(:,11473), t3x128(:,:,3548))
  call heltable([8,16,128], n3(:,11474), t3x128(:,:,3549))
  call heltable([8,16,128], n3(:,11475), t3x128(:,:,3550))
  call heltable([8,16,128], n3(:,11476), t3x128(:,:,3551))
  call heltable([8,16,128], n3(:,11477), t3x128(:,:,3552))
  call heltable([8,16,128], n3(:,11478), t3x128(:,:,3553))
  call heltable([8,16,128], n3(:,11479), t3x128(:,:,3554))
  call heltable([8,16,128], n3(:,11480), t3x128(:,:,3555))
  call heltable([8,16,128], n3(:,11481), t3x128(:,:,3556))
  call heltable([8,16,128], n3(:,11482), t3x128(:,:,3557))
  call heltable([8,16,128], n3(:,11483), t3x128(:,:,3558))
  call heltable([8,16,128], n3(:,11484), t3x128(:,:,3559))
  call heltable([8,16,128], n3(:,11485), t3x128(:,:,3560))
  call heltable([8,16,128], n3(:,11486), t3x128(:,:,3561))
  call heltable([8,16,128], n3(:,11487), t3x128(:,:,3562))
  call heltable([8,16,128], n3(:,11488), t3x128(:,:,3563))
  call heltable([8,16,128], n3(:,11489), t3x128(:,:,3564))
  call heltable([8,16,128], n3(:,11490), t3x128(:,:,3565))
  call heltable([8,16,128], n3(:,11491), t3x128(:,:,3566))
  call heltable([8,16,128], n3(:,11492), t3x128(:,:,3567))
  call heltable([8,16,128], n3(:,11493), t3x128(:,:,3568))
  call heltable([8,16,128], n3(:,11494), t3x128(:,:,3569))
  call heltable([8,16,128], n3(:,11495), t3x128(:,:,3570))
  call heltable([8,16,128], n3(:,11496), t3x128(:,:,3571))
  call heltable([8,16,128], n3(:,11497), t3x128(:,:,3572))
  call heltable([8,16,128], n3(:,11498), t3x128(:,:,3573))
  call heltable([8,16,128], n3(:,11499), t3x128(:,:,3574))
  call heltable([8,16,128], n3(:,11500), t3x128(:,:,3575))
  call heltable([8,16,128], n3(:,11501), t3x128(:,:,3576))
  call heltable([8,16,128], n3(:,11502), t3x128(:,:,3577))
  call heltable([8,16,128], n3(:,11503), t3x128(:,:,3578))
  call heltable([8,16,128], n3(:,11504), t3x128(:,:,3579))
  call heltable([8,16,128], n3(:,11505), t3x128(:,:,3580))
  call heltable([8,16,128], n3(:,11506), t3x128(:,:,3581))
  call heltable([8,16,128], n3(:,11507), t3x128(:,:,3582))
  call heltable([8,16,128], n3(:,11508), t3x128(:,:,3583))
  call heltable([8,16,128], n3(:,11509), t3x128(:,:,3584))
  call heltable([8,16,128], n3(:,11510), t3x128(:,:,3585))
  call heltable([8,16,128], n3(:,11511), t3x128(:,:,3586))
  call heltable([8,16,128], n3(:,11512), t3x128(:,:,3587))
  call heltable([8,16,128], n3(:,11513), t3x128(:,:,3588))
  call heltable([8,16,128], n3(:,11514), t3x128(:,:,3589))
  call heltable([8,16,128], n3(:,11515), t3x128(:,:,3590))
  call heltable([8,16,128], n3(:,11516), t3x128(:,:,3591))
  call heltable([8,16,128], n3(:,11517), t3x128(:,:,3592))
  call heltable([8,16,128], n3(:,11518), t3x128(:,:,3593))
  call heltable([8,16,128], n3(:,11519), t3x128(:,:,3594))
  call heltable([8,16,128], n3(:,11520), t3x128(:,:,3595))
  call heltable([8,16,128], n3(:,11521), t3x128(:,:,3596))
  call heltable([8,16,128], n3(:,11522), t3x128(:,:,3597))
  call heltable([8,16,128], n3(:,11523), t3x128(:,:,3598))
  call heltable([8,16,128], n3(:,11524), t3x128(:,:,3599))
  call heltable([8,16,128], n3(:,11525), t3x128(:,:,3600))
  call heltable([8,16,128], n3(:,11526), t3x128(:,:,3601))
  call heltable([8,16,128], n3(:,11527), t3x128(:,:,3602))
  call heltable([8,16,128], n3(:,11528), t3x128(:,:,3603))
  call heltable([8,16,128], n3(:,11529), t3x128(:,:,3604))
  call heltable([8,16,128], n3(:,11530), t3x128(:,:,3605))
  call heltable([8,16,128], n3(:,11531), t3x128(:,:,3606))
  call heltable([8,16,128], n3(:,11532), t3x128(:,:,3607))
  call heltable([8,16,128], n3(:,11533), t3x128(:,:,3608))
  call heltable([8,16,128], n3(:,11534), t3x128(:,:,3609))
  call heltable([8,16,128], n3(:,11535), t3x128(:,:,3610))
  call heltable([8,16,128], n3(:,11536), t3x128(:,:,3611))
  call heltable([8,16,128], n3(:,11537), t3x128(:,:,3612))
  call heltable([8,16,128], n3(:,11538), t3x128(:,:,3613))
  call heltable([8,16,128], n3(:,11539), t3x128(:,:,3614))
  call heltable([8,16,128], n3(:,11540), t3x128(:,:,3615))
  call heltable([8,16,128], n3(:,11541), t3x128(:,:,3616))
  call heltable([8,16,128], n3(:,11542), t3x128(:,:,3617))
  call heltable([8,16,128], n3(:,11543), t3x128(:,:,3618))
  call heltable([8,16,128], n3(:,11544), t3x128(:,:,3619))
  call heltable([8,16,128], n3(:,11545), t3x128(:,:,3620))
  call heltable([8,16,128], n3(:,11546), t3x128(:,:,3621))
  call heltable([8,16,128], n3(:,11547), t3x128(:,:,3622))
  call heltable([8,16,128], n3(:,11548), t3x128(:,:,3623))
  call heltable([8,16,128], n3(:,11549), t3x128(:,:,3624))
  call heltable([8,16,128], n3(:,11550), t3x128(:,:,3625))
  call heltable([8,16,128], n3(:,11551), t3x128(:,:,3626))
  call heltable([8,16,128], n3(:,11552), t3x128(:,:,3627))
  call heltable([8,16,128], n3(:,11553), t3x128(:,:,3628))
  call heltable([8,16,128], n3(:,11554), t3x128(:,:,3629))
  call heltable([8,16,128], n3(:,11555), t3x128(:,:,3630))
  call heltable([8,16,128], n3(:,11556), t3x128(:,:,3631))
  call heltable([8,16,128], n3(:,11557), t3x128(:,:,3632))
  call heltable([8,16,128], n3(:,11558), t3x128(:,:,3633))
  call heltable([8,16,128], n3(:,11559), t3x128(:,:,3634))
  call heltable([8,16,128], n3(:,11560), t3x128(:,:,3635))
  call heltable([8,16,128], n3(:,11561), t3x128(:,:,3636))
  call heltable([8,16,128], n3(:,11562), t3x128(:,:,3637))
  call heltable([8,16,128], n3(:,11563), t3x128(:,:,3638))
  call heltable([8,16,128], n3(:,11564), t3x128(:,:,3639))
  call heltable([8,16,128], n3(:,11565), t3x128(:,:,3640))
  call heltable([8,16,128], n3(:,11566), t3x128(:,:,3641))
  call heltable([8,16,128], n3(:,11567), t3x128(:,:,3642))
  call heltable([8,16,128], n3(:,11568), t3x128(:,:,3643))
  call heltable([8,16,128], n3(:,11569), t3x128(:,:,3644))
  call heltable([8,16,128], n3(:,11570), t3x128(:,:,3645))
  call heltable([8,16,128], n3(:,11571), t3x128(:,:,3646))
  call heltable([8,16,128], n3(:,11572), t3x128(:,:,3647))
  call heltable([8,16,128], n3(:,11573), t3x128(:,:,3648))
  call heltable([8,16,128], n3(:,11574), t3x128(:,:,3649))
  call heltable([8,16,128], n3(:,11575), t3x128(:,:,3650))
  call heltable([8,16,128], n3(:,11576), t3x128(:,:,3651))
  call heltable([8,16,128], n3(:,11577), t3x128(:,:,3652))
  call heltable([8,16,128], n3(:,11578), t3x128(:,:,3653))
  call heltable([8,16,128], n3(:,11579), t3x128(:,:,3654))
  call heltable([8,16,128], n3(:,11580), t3x128(:,:,3655))
  call heltable([8,16,128], n3(:,11581), t3x128(:,:,3656))
  call heltable([8,16,128], n3(:,11582), t3x128(:,:,3657))
  call heltable([8,16,128], n3(:,11583), t3x128(:,:,3658))
  call heltable([16,8,128], n3(:,11584), t3x128(:,:,3659))
  call heltable([16,8,128], n3(:,11585), t3x128(:,:,3660))
  call heltable([16,8,128], n3(:,11586), t3x128(:,:,3661))
  call heltable([16,8,128], n3(:,11587), t3x128(:,:,3662))
  call heltable([16,8,128], n3(:,11588), t3x128(:,:,3663))
  call heltable([16,8,128], n3(:,11589), t3x128(:,:,3664))
  call heltable([16,8,128], n3(:,11590), t3x128(:,:,3665))
  call heltable([16,8,128], n3(:,11591), t3x128(:,:,3666))
  call heltable([16,8,128], n3(:,11592), t3x128(:,:,3667))
  call heltable([16,8,128], n3(:,11593), t3x128(:,:,3668))
  call heltable([16,8,128], n3(:,11594), t3x128(:,:,3669))
  call heltable([16,8,128], n3(:,11595), t3x128(:,:,3670))
  call heltable([16,8,128], n3(:,11596), t3x128(:,:,3671))
  call heltable([16,8,128], n3(:,11597), t3x128(:,:,3672))
  call heltable([16,8,128], n3(:,11598), t3x128(:,:,3673))
  call heltable([16,8,128], n3(:,11599), t3x128(:,:,3674))
  call heltable([16,8,128], n3(:,11600), t3x128(:,:,3675))
  call heltable([16,8,128], n3(:,11601), t3x128(:,:,3676))
  call heltable([16,8,128], n3(:,11602), t3x128(:,:,3677))
  call heltable([16,8,128], n3(:,11603), t3x128(:,:,3678))
  call heltable([16,8,128], n3(:,11604), t3x128(:,:,3679))
  call heltable([16,8,128], n3(:,11605), t3x128(:,:,3680))
  call heltable([16,8,128], n3(:,11606), t3x128(:,:,3681))
  call heltable([16,8,128], n3(:,11607), t3x128(:,:,3682))
  call heltable([8,16,128], n3(:,11608), t3x128(:,:,3683))
  call heltable([8,16,128], n3(:,11609), t3x128(:,:,3684))
  call heltable([8,16,128], n3(:,11610), t3x128(:,:,3685))
  call heltable([8,16,128], n3(:,11611), t3x128(:,:,3686))
  call heltable([8,16,128], n3(:,11612), t3x128(:,:,3687))
  call heltable([8,16,128], n3(:,11613), t3x128(:,:,3688))
  call heltable([8,16,128], n3(:,11614), t3x128(:,:,3689))
  call heltable([8,16,128], n3(:,11615), t3x128(:,:,3690))
  call heltable([8,16,128], n3(:,11616), t3x128(:,:,3691))
  call heltable([8,16,128], n3(:,11617), t3x128(:,:,3692))
  call heltable([8,16,128], n3(:,11618), t3x128(:,:,3693))
  call heltable([8,16,128], n3(:,11619), t3x128(:,:,3694))
  call heltable([8,16,128], n3(:,11620), t3x128(:,:,3695))
  call heltable([8,16,128], n3(:,11621), t3x128(:,:,3696))
  call heltable([8,16,128], n3(:,11622), t3x128(:,:,3697))
  call heltable([8,16,128], n3(:,11623), t3x128(:,:,3698))
  call heltable([16,8,128], n3(:,11624), t3x128(:,:,3699))
  call heltable([16,8,128], n3(:,11625), t3x128(:,:,3700))
  call heltable([16,8,128], n3(:,11626), t3x128(:,:,3701))
  call heltable([16,8,128], n3(:,11627), t3x128(:,:,3702))
  call heltable([16,8,128], n3(:,11628), t3x128(:,:,3703))
  call heltable([16,8,128], n3(:,11629), t3x128(:,:,3704))
  call heltable([16,8,128], n3(:,11630), t3x128(:,:,3705))
  call heltable([16,8,128], n3(:,11631), t3x128(:,:,3706))
  call heltable([16,8,128], n3(:,11632), t3x128(:,:,3707))
  call heltable([16,8,128], n3(:,11633), t3x128(:,:,3708))
  call heltable([16,8,128], n3(:,11634), t3x128(:,:,3709))
  call heltable([16,8,128], n3(:,11635), t3x128(:,:,3710))
  call heltable([16,8,128], n3(:,11636), t3x128(:,:,3711))
  call heltable([16,8,128], n3(:,11637), t3x128(:,:,3712))
  call heltable([16,8,128], n3(:,11638), t3x128(:,:,3713))
  call heltable([16,8,128], n3(:,11639), t3x128(:,:,3714))
  call heltable([16,8,128], n3(:,11640), t3x128(:,:,3715))
  call heltable([16,8,128], n3(:,11641), t3x128(:,:,3716))
  call heltable([16,8,128], n3(:,11642), t3x128(:,:,3717))
  call heltable([16,8,128], n3(:,11643), t3x128(:,:,3718))
  call heltable([16,8,128], n3(:,11644), t3x128(:,:,3719))
  call heltable([16,8,128], n3(:,11645), t3x128(:,:,3720))
  call heltable([16,8,128], n3(:,11646), t3x128(:,:,3721))
  call heltable([16,8,128], n3(:,11647), t3x128(:,:,3722))
  call heltable([16,8,128], n3(:,11648), t3x128(:,:,3723))
  call heltable([16,8,128], n3(:,11649), t3x128(:,:,3724))
  call heltable([16,8,128], n3(:,11650), t3x128(:,:,3725))
  call heltable([16,8,128], n3(:,11651), t3x128(:,:,3726))
  call heltable([16,8,128], n3(:,11652), t3x128(:,:,3727))
  call heltable([16,8,128], n3(:,11653), t3x128(:,:,3728))
  call heltable([16,8,128], n3(:,11654), t3x128(:,:,3729))
  call heltable([16,8,128], n3(:,11655), t3x128(:,:,3730))
  call heltable([16,8,128], n3(:,11656), t3x128(:,:,3731))
  call heltable([16,8,128], n3(:,11657), t3x128(:,:,3732))
  call heltable([16,8,128], n3(:,11658), t3x128(:,:,3733))
  call heltable([16,8,128], n3(:,11659), t3x128(:,:,3734))
  call heltable([16,8,128], n3(:,11660), t3x128(:,:,3735))
  call heltable([16,8,128], n3(:,11661), t3x128(:,:,3736))
  call heltable([16,8,128], n3(:,11662), t3x128(:,:,3737))
  call heltable([16,8,128], n3(:,11663), t3x128(:,:,3738))
  call heltable([16,8,128], n3(:,11664), t3x128(:,:,3739))
  call heltable([16,8,128], n3(:,11665), t3x128(:,:,3740))
  call heltable([16,8,128], n3(:,11666), t3x128(:,:,3741))
  call heltable([16,8,128], n3(:,11667), t3x128(:,:,3742))
  call heltable([16,8,128], n3(:,11668), t3x128(:,:,3743))
  call heltable([16,8,128], n3(:,11669), t3x128(:,:,3744))
  call heltable([16,8,128], n3(:,11670), t3x128(:,:,3745))
  call heltable([16,8,128], n3(:,11671), t3x128(:,:,3746))
  call heltable([8,16,128], n3(:,11672), t3x128(:,:,3747))
  call heltable([8,16,128], n3(:,11673), t3x128(:,:,3748))
  call heltable([8,16,128], n3(:,11674), t3x128(:,:,3749))
  call heltable([8,16,128], n3(:,11675), t3x128(:,:,3750))
  call heltable([8,16,128], n3(:,11676), t3x128(:,:,3751))
  call heltable([8,16,128], n3(:,11677), t3x128(:,:,3752))
  call heltable([8,16,128], n3(:,11678), t3x128(:,:,3753))
  call heltable([8,16,128], n3(:,11679), t3x128(:,:,3754))
  call heltable([8,16,128], n3(:,11680), t3x128(:,:,3755))
  call heltable([8,16,128], n3(:,11681), t3x128(:,:,3756))
  call heltable([8,16,128], n3(:,11682), t3x128(:,:,3757))
  call heltable([8,16,128], n3(:,11683), t3x128(:,:,3758))
  call heltable([8,16,128], n3(:,11684), t3x128(:,:,3759))
  call heltable([8,16,128], n3(:,11685), t3x128(:,:,3760))
  call heltable([8,16,128], n3(:,11686), t3x128(:,:,3761))
  call heltable([8,16,128], n3(:,11687), t3x128(:,:,3762))
  call heltable([8,16,128], n3(:,11688), t3x128(:,:,3763))
  call heltable([8,16,128], n3(:,11689), t3x128(:,:,3764))
  call heltable([8,16,128], n3(:,11690), t3x128(:,:,3765))
  call heltable([8,16,128], n3(:,11691), t3x128(:,:,3766))
  call heltable([8,16,128], n3(:,11692), t3x128(:,:,3767))
  call heltable([8,16,128], n3(:,11693), t3x128(:,:,3768))
  call heltable([8,16,128], n3(:,11694), t3x128(:,:,3769))
  call heltable([8,16,128], n3(:,11695), t3x128(:,:,3770))
  call heltable([8,16,128], n3(:,11696), t3x128(:,:,3771))
  call heltable([8,16,128], n3(:,11697), t3x128(:,:,3772))
  call heltable([8,16,128], n3(:,11698), t3x128(:,:,3773))
  call heltable([8,16,128], n3(:,11699), t3x128(:,:,3774))
  call heltable([8,16,128], n3(:,11700), t3x128(:,:,3775))
  call heltable([8,16,128], n3(:,11701), t3x128(:,:,3776))
  call heltable([8,16,128], n3(:,11702), t3x128(:,:,3777))
  call heltable([8,16,128], n3(:,11703), t3x128(:,:,3778))
  call heltable([8,16,128], n3(:,11704), t3x128(:,:,3779))
  call heltable([8,16,128], n3(:,11705), t3x128(:,:,3780))
  call heltable([8,16,128], n3(:,11706), t3x128(:,:,3781))
  call heltable([8,16,128], n3(:,11707), t3x128(:,:,3782))
  call heltable([8,16,128], n3(:,11708), t3x128(:,:,3783))
  call heltable([8,16,128], n3(:,11709), t3x128(:,:,3784))
  call heltable([8,16,128], n3(:,11710), t3x128(:,:,3785))
  call heltable([8,16,128], n3(:,11711), t3x128(:,:,3786))
  call heltable([8,16,128], n3(:,11712), t3x128(:,:,3787))
  call heltable([8,16,128], n3(:,11713), t3x128(:,:,3788))
  call heltable([8,16,128], n3(:,11714), t3x128(:,:,3789))
  call heltable([8,16,128], n3(:,11715), t3x128(:,:,3790))
  call heltable([8,16,128], n3(:,11716), t3x128(:,:,3791))
  call heltable([8,16,128], n3(:,11717), t3x128(:,:,3792))
  call heltable([8,16,128], n3(:,11718), t3x128(:,:,3793))
  call heltable([8,16,128], n3(:,11719), t3x128(:,:,3794))
  call heltable([8,16,128], n3(:,11720), t3x128(:,:,3795))
  call heltable([8,16,128], n3(:,11721), t3x128(:,:,3796))
  call heltable([8,16,128], n3(:,11722), t3x128(:,:,3797))
  call heltable([8,16,128], n3(:,11723), t3x128(:,:,3798))
  call heltable([8,16,128], n3(:,11724), t3x128(:,:,3799))
  call heltable([8,16,128], n3(:,11725), t3x128(:,:,3800))
  call heltable([8,16,128], n3(:,11726), t3x128(:,:,3801))
  call heltable([8,16,128], n3(:,11727), t3x128(:,:,3802))
  call heltable([16,8,128], n3(:,11728), t3x128(:,:,3803))
  call heltable([16,8,128], n3(:,11729), t3x128(:,:,3804))
  call heltable([16,8,128], n3(:,11730), t3x128(:,:,3805))
  call heltable([16,8,128], n3(:,11731), t3x128(:,:,3806))
  call heltable([16,8,128], n3(:,11732), t3x128(:,:,3807))
  call heltable([16,8,128], n3(:,11733), t3x128(:,:,3808))
  call heltable([16,8,128], n3(:,11734), t3x128(:,:,3809))
  call heltable([16,8,128], n3(:,11735), t3x128(:,:,3810))
  call heltable([16,8,128], n3(:,11736), t3x128(:,:,3811))
  call heltable([16,8,128], n3(:,11737), t3x128(:,:,3812))
  call heltable([16,8,128], n3(:,11738), t3x128(:,:,3813))
  call heltable([16,8,128], n3(:,11739), t3x128(:,:,3814))
  call heltable([16,8,128], n3(:,11740), t3x128(:,:,3815))
  call heltable([16,8,128], n3(:,11741), t3x128(:,:,3816))
  call heltable([16,8,128], n3(:,11742), t3x128(:,:,3817))
  call heltable([16,8,128], n3(:,11743), t3x128(:,:,3818))
  call heltable([16,8,128], n3(:,11744), t3x128(:,:,3819))
  call heltable([16,8,128], n3(:,11745), t3x128(:,:,3820))
  call heltable([16,8,128], n3(:,11746), t3x128(:,:,3821))
  call heltable([16,8,128], n3(:,11747), t3x128(:,:,3822))
  call heltable([16,8,128], n3(:,11748), t3x128(:,:,3823))
  call heltable([16,8,128], n3(:,11749), t3x128(:,:,3824))
  call heltable([16,8,128], n3(:,11750), t3x128(:,:,3825))
  call heltable([16,8,128], n3(:,11751), t3x128(:,:,3826))
  call heltable([16,8,128], n3(:,11752), t3x128(:,:,3827))
  call heltable([16,8,128], n3(:,11753), t3x128(:,:,3828))
  call heltable([16,8,128], n3(:,11754), t3x128(:,:,3829))
  call heltable([16,8,128], n3(:,11755), t3x128(:,:,3830))
  call heltable([16,8,128], n3(:,11756), t3x128(:,:,3831))
  call heltable([16,8,128], n3(:,11757), t3x128(:,:,3832))
  call heltable([16,8,128], n3(:,11758), t3x128(:,:,3833))
  call heltable([16,8,128], n3(:,11759), t3x128(:,:,3834))
  call heltable([8,16,128], n3(:,11760), t3x128(:,:,3835))
  call heltable([8,16,128], n3(:,11761), t3x128(:,:,3836))
  call heltable([8,16,128], n3(:,11762), t3x128(:,:,3837))
  call heltable([8,16,128], n3(:,11763), t3x128(:,:,3838))
  call heltable([8,16,128], n3(:,11764), t3x128(:,:,3839))
  call heltable([8,16,128], n3(:,11765), t3x128(:,:,3840))
  call heltable([8,16,128], n3(:,11766), t3x128(:,:,3841))
  call heltable([8,16,128], n3(:,11767), t3x128(:,:,3842))
  call heltable([8,16,128], n3(:,11768), t3x128(:,:,3843))
  call heltable([8,16,128], n3(:,11769), t3x128(:,:,3844))
  call heltable([8,16,128], n3(:,11770), t3x128(:,:,3845))
  call heltable([8,16,128], n3(:,11771), t3x128(:,:,3846))
  call heltable([8,16,128], n3(:,11772), t3x128(:,:,3847))
  call heltable([8,16,128], n3(:,11773), t3x128(:,:,3848))
  call heltable([8,16,128], n3(:,11774), t3x128(:,:,3849))
  call heltable([8,16,128], n3(:,11775), t3x128(:,:,3850))
  call heltable([16,8,128], n3(:,11776), t3x128(:,:,3851))
  call heltable([16,8,128], n3(:,11777), t3x128(:,:,3852))
  call heltable([16,8,128], n3(:,11778), t3x128(:,:,3853))
  call heltable([16,8,128], n3(:,11779), t3x128(:,:,3854))
  call heltable([16,8,128], n3(:,11780), t3x128(:,:,3855))
  call heltable([16,8,128], n3(:,11781), t3x128(:,:,3856))
  call heltable([16,8,128], n3(:,11782), t3x128(:,:,3857))
  call heltable([16,8,128], n3(:,11783), t3x128(:,:,3858))
  call heltable([16,8,128], n3(:,11784), t3x128(:,:,3859))
  call heltable([16,8,128], n3(:,11785), t3x128(:,:,3860))
  call heltable([16,8,128], n3(:,11786), t3x128(:,:,3861))
  call heltable([16,8,128], n3(:,11787), t3x128(:,:,3862))
  call heltable([16,8,128], n3(:,11788), t3x128(:,:,3863))
  call heltable([16,8,128], n3(:,11789), t3x128(:,:,3864))
  call heltable([16,8,128], n3(:,11790), t3x128(:,:,3865))
  call heltable([16,8,128], n3(:,11791), t3x128(:,:,3866))
  call heltable([16,8,128], n3(:,11792), t3x128(:,:,3867))
  call heltable([16,8,128], n3(:,11793), t3x128(:,:,3868))
  call heltable([16,8,128], n3(:,11794), t3x128(:,:,3869))
  call heltable([16,8,128], n3(:,11795), t3x128(:,:,3870))
  call heltable([16,8,128], n3(:,11796), t3x128(:,:,3871))
  call heltable([16,8,128], n3(:,11797), t3x128(:,:,3872))
  call heltable([16,8,128], n3(:,11798), t3x128(:,:,3873))
  call heltable([16,8,128], n3(:,11799), t3x128(:,:,3874))
  call heltable([16,8,128], n3(:,11800), t3x128(:,:,3875))
  call heltable([16,8,128], n3(:,11801), t3x128(:,:,3876))
  call heltable([16,8,128], n3(:,11802), t3x128(:,:,3877))
  call heltable([16,8,128], n3(:,11803), t3x128(:,:,3878))
  call heltable([16,8,128], n3(:,11804), t3x128(:,:,3879))
  call heltable([16,8,128], n3(:,11805), t3x128(:,:,3880))
  call heltable([16,8,128], n3(:,11806), t3x128(:,:,3881))
  call heltable([16,8,128], n3(:,11807), t3x128(:,:,3882))
  call heltable([16,8,128], n3(:,11808), t3x128(:,:,3883))
  call heltable([16,8,128], n3(:,11809), t3x128(:,:,3884))
  call heltable([16,8,128], n3(:,11810), t3x128(:,:,3885))
  call heltable([16,8,128], n3(:,11811), t3x128(:,:,3886))
  call heltable([16,8,128], n3(:,11812), t3x128(:,:,3887))
  call heltable([16,8,128], n3(:,11813), t3x128(:,:,3888))
  call heltable([16,8,128], n3(:,11814), t3x128(:,:,3889))
  call heltable([16,8,128], n3(:,11815), t3x128(:,:,3890))
  call heltable([16,8,128], n3(:,11816), t3x128(:,:,3891))
  call heltable([16,8,128], n3(:,11817), t3x128(:,:,3892))
  call heltable([16,8,128], n3(:,11818), t3x128(:,:,3893))
  call heltable([16,8,128], n3(:,11819), t3x128(:,:,3894))
  call heltable([16,8,128], n3(:,11820), t3x128(:,:,3895))
  call heltable([16,8,128], n3(:,11821), t3x128(:,:,3896))
  call heltable([16,8,128], n3(:,11822), t3x128(:,:,3897))
  call heltable([16,8,128], n3(:,11823), t3x128(:,:,3898))
  call heltable([16,8,128], n3(:,11824), t3x128(:,:,3899))
  call heltable([16,8,128], n3(:,11825), t3x128(:,:,3900))
  call heltable([16,8,128], n3(:,11826), t3x128(:,:,3901))
  call heltable([16,8,128], n3(:,11827), t3x128(:,:,3902))
  call heltable([16,8,128], n3(:,11828), t3x128(:,:,3903))
  call heltable([16,8,128], n3(:,11829), t3x128(:,:,3904))
  call heltable([16,8,128], n3(:,11830), t3x128(:,:,3905))
  call heltable([16,8,128], n3(:,11831), t3x128(:,:,3906))
  call heltable([16,8,128], n3(:,11832), t3x128(:,:,3907))
  call heltable([16,8,128], n3(:,11833), t3x128(:,:,3908))
  call heltable([16,8,128], n3(:,11834), t3x128(:,:,3909))
  call heltable([16,8,128], n3(:,11835), t3x128(:,:,3910))
  call heltable([16,8,128], n3(:,11836), t3x128(:,:,3911))
  call heltable([16,8,128], n3(:,11837), t3x128(:,:,3912))
  call heltable([16,8,128], n3(:,11838), t3x128(:,:,3913))
  call heltable([16,8,128], n3(:,11839), t3x128(:,:,3914))
  call heltable([8,16,128], n3(:,11840), t3x128(:,:,3915))
  call heltable([8,16,128], n3(:,11841), t3x128(:,:,3916))
  call heltable([8,16,128], n3(:,11842), t3x128(:,:,3917))
  call heltable([8,16,128], n3(:,11843), t3x128(:,:,3918))
  call heltable([8,16,128], n3(:,11844), t3x128(:,:,3919))
  call heltable([8,16,128], n3(:,11845), t3x128(:,:,3920))
  call heltable([8,16,128], n3(:,11846), t3x128(:,:,3921))
  call heltable([8,16,128], n3(:,11847), t3x128(:,:,3922))
  call heltable([8,16,128], n3(:,11848), t3x128(:,:,3923))
  call heltable([8,16,128], n3(:,11849), t3x128(:,:,3924))
  call heltable([8,16,128], n3(:,11850), t3x128(:,:,3925))
  call heltable([8,16,128], n3(:,11851), t3x128(:,:,3926))
  call heltable([8,16,128], n3(:,11852), t3x128(:,:,3927))
  call heltable([8,16,128], n3(:,11853), t3x128(:,:,3928))
  call heltable([8,16,128], n3(:,11854), t3x128(:,:,3929))
  call heltable([8,16,128], n3(:,11855), t3x128(:,:,3930))
  call heltable([16,8,128], n3(:,11856), t3x128(:,:,3931))
  call heltable([16,8,128], n3(:,11857), t3x128(:,:,3932))
  call heltable([16,8,128], n3(:,11858), t3x128(:,:,3933))
  call heltable([16,8,128], n3(:,11859), t3x128(:,:,3934))
  call heltable([16,8,128], n3(:,11860), t3x128(:,:,3935))
  call heltable([16,8,128], n3(:,11861), t3x128(:,:,3936))
  call heltable([16,8,128], n3(:,11862), t3x128(:,:,3937))
  call heltable([16,8,128], n3(:,11863), t3x128(:,:,3938))
  call heltable([16,8,128], n3(:,11864), t3x128(:,:,3939))
  call heltable([16,8,128], n3(:,11865), t3x128(:,:,3940))
  call heltable([16,8,128], n3(:,11866), t3x128(:,:,3941))
  call heltable([16,8,128], n3(:,11867), t3x128(:,:,3942))
  call heltable([16,8,128], n3(:,11868), t3x128(:,:,3943))
  call heltable([16,8,128], n3(:,11869), t3x128(:,:,3944))
  call heltable([16,8,128], n3(:,11870), t3x128(:,:,3945))
  call heltable([16,8,128], n3(:,11871), t3x128(:,:,3946))
  call heltable([16,8,128], n3(:,11872), t3x128(:,:,3947))
  call heltable([16,8,128], n3(:,11873), t3x128(:,:,3948))
  call heltable([16,8,128], n3(:,11874), t3x128(:,:,3949))
  call heltable([16,8,128], n3(:,11875), t3x128(:,:,3950))
  call heltable([16,8,128], n3(:,11876), t3x128(:,:,3951))
  call heltable([16,8,128], n3(:,11877), t3x128(:,:,3952))
  call heltable([16,8,128], n3(:,11878), t3x128(:,:,3953))
  call heltable([16,8,128], n3(:,11879), t3x128(:,:,3954))
  call heltable([16,8,128], n3(:,11880), t3x128(:,:,3955))
  call heltable([16,8,128], n3(:,11881), t3x128(:,:,3956))
  call heltable([16,8,128], n3(:,11882), t3x128(:,:,3957))
  call heltable([16,8,128], n3(:,11883), t3x128(:,:,3958))
  call heltable([16,8,128], n3(:,11884), t3x128(:,:,3959))
  call heltable([16,8,128], n3(:,11885), t3x128(:,:,3960))
  call heltable([16,8,128], n3(:,11886), t3x128(:,:,3961))
  call heltable([16,8,128], n3(:,11887), t3x128(:,:,3962))
  call heltable([8,16,128], n3(:,11888), t3x128(:,:,3963))
  call heltable([8,16,128], n3(:,11889), t3x128(:,:,3964))
  call heltable([8,16,128], n3(:,11890), t3x128(:,:,3965))
  call heltable([8,16,128], n3(:,11891), t3x128(:,:,3966))
  call heltable([8,16,128], n3(:,11892), t3x128(:,:,3967))
  call heltable([8,16,128], n3(:,11893), t3x128(:,:,3968))
  call heltable([8,16,128], n3(:,11894), t3x128(:,:,3969))
  call heltable([8,16,128], n3(:,11895), t3x128(:,:,3970))
  call heltable([8,16,128], n3(:,11896), t3x128(:,:,3971))
  call heltable([8,16,128], n3(:,11897), t3x128(:,:,3972))
  call heltable([8,16,128], n3(:,11898), t3x128(:,:,3973))
  call heltable([8,16,128], n3(:,11899), t3x128(:,:,3974))
  call heltable([8,16,128], n3(:,11900), t3x128(:,:,3975))
  call heltable([8,16,128], n3(:,11901), t3x128(:,:,3976))
  call heltable([8,16,128], n3(:,11902), t3x128(:,:,3977))
  call heltable([8,16,128], n3(:,11903), t3x128(:,:,3978))
  call heltable([16,8,128], n3(:,11904), t3x128(:,:,3979))
  call heltable([16,8,128], n3(:,11905), t3x128(:,:,3980))
  call heltable([16,8,128], n3(:,11906), t3x128(:,:,3981))
  call heltable([16,8,128], n3(:,11907), t3x128(:,:,3982))
  call heltable([16,8,128], n3(:,11908), t3x128(:,:,3983))
  call heltable([16,8,128], n3(:,11909), t3x128(:,:,3984))
  call heltable([16,8,128], n3(:,11910), t3x128(:,:,3985))
  call heltable([16,8,128], n3(:,11911), t3x128(:,:,3986))
  call heltable([16,8,128], n3(:,11912), t3x128(:,:,3987))
  call heltable([16,8,128], n3(:,11913), t3x128(:,:,3988))
  call heltable([16,8,128], n3(:,11914), t3x128(:,:,3989))
  call heltable([16,8,128], n3(:,11915), t3x128(:,:,3990))
  call heltable([16,8,128], n3(:,11916), t3x128(:,:,3991))
  call heltable([16,8,128], n3(:,11917), t3x128(:,:,3992))
  call heltable([16,8,128], n3(:,11918), t3x128(:,:,3993))
  call heltable([16,8,128], n3(:,11919), t3x128(:,:,3994))
  call heltable([16,8,128], n3(:,11920), t3x128(:,:,3995))
  call heltable([16,8,128], n3(:,11921), t3x128(:,:,3996))
  call heltable([16,8,128], n3(:,11922), t3x128(:,:,3997))
  call heltable([16,8,128], n3(:,11923), t3x128(:,:,3998))
  call heltable([16,8,128], n3(:,11924), t3x128(:,:,3999))
  call heltable([16,8,128], n3(:,11925), t3x128(:,:,4000))
  call heltable([16,8,128], n3(:,11926), t3x128(:,:,4001))
  call heltable([16,8,128], n3(:,11927), t3x128(:,:,4002))
  call heltable([16,8,128], n3(:,11928), t3x128(:,:,4003))
  call heltable([16,8,128], n3(:,11929), t3x128(:,:,4004))
  call heltable([16,8,128], n3(:,11930), t3x128(:,:,4005))
  call heltable([16,8,128], n3(:,11931), t3x128(:,:,4006))
  call heltable([16,8,128], n3(:,11932), t3x128(:,:,4007))
  call heltable([16,8,128], n3(:,11933), t3x128(:,:,4008))
  call heltable([16,8,128], n3(:,11934), t3x128(:,:,4009))
  call heltable([16,8,128], n3(:,11935), t3x128(:,:,4010))
  call heltable([16,8,128], n3(:,11936), t3x128(:,:,4011))
  call heltable([16,8,128], n3(:,11937), t3x128(:,:,4012))
  call heltable([16,8,128], n3(:,11938), t3x128(:,:,4013))
  call heltable([16,8,128], n3(:,11939), t3x128(:,:,4014))
  call heltable([16,8,128], n3(:,11940), t3x128(:,:,4015))
  call heltable([16,8,128], n3(:,11941), t3x128(:,:,4016))
  call heltable([16,8,128], n3(:,11942), t3x128(:,:,4017))
  call heltable([16,8,128], n3(:,11943), t3x128(:,:,4018))
  call heltable([16,8,128], n3(:,11944), t3x128(:,:,4019))
  call heltable([16,8,128], n3(:,11945), t3x128(:,:,4020))
  call heltable([16,8,128], n3(:,11946), t3x128(:,:,4021))
  call heltable([16,8,128], n3(:,11947), t3x128(:,:,4022))
  call heltable([16,8,128], n3(:,11948), t3x128(:,:,4023))
  call heltable([16,8,128], n3(:,11949), t3x128(:,:,4024))
  call heltable([16,8,128], n3(:,11950), t3x128(:,:,4025))
  call heltable([16,8,128], n3(:,11951), t3x128(:,:,4026))
  call heltable([16,8,128], n3(:,11952), t3x128(:,:,4027))
  call heltable([16,8,128], n3(:,11953), t3x128(:,:,4028))
  call heltable([16,8,128], n3(:,11954), t3x128(:,:,4029))
  call heltable([16,8,128], n3(:,11955), t3x128(:,:,4030))
  call heltable([16,8,128], n3(:,11956), t3x128(:,:,4031))
  call heltable([16,8,128], n3(:,11957), t3x128(:,:,4032))
  call heltable([16,8,128], n3(:,11958), t3x128(:,:,4033))
  call heltable([16,8,128], n3(:,11959), t3x128(:,:,4034))
  call heltable([16,8,128], n3(:,11960), t3x128(:,:,4035))
  call heltable([16,8,128], n3(:,11961), t3x128(:,:,4036))
  call heltable([16,8,128], n3(:,11962), t3x128(:,:,4037))
  call heltable([16,8,128], n3(:,11963), t3x128(:,:,4038))
  call heltable([16,8,128], n3(:,11964), t3x128(:,:,4039))
  call heltable([16,8,128], n3(:,11965), t3x128(:,:,4040))
  call heltable([16,8,128], n3(:,11966), t3x128(:,:,4041))
  call heltable([16,8,128], n3(:,11967), t3x128(:,:,4042))
  call heltable([8,16,128], n3(:,11968), t3x128(:,:,4043))
  call heltable([8,16,128], n3(:,11969), t3x128(:,:,4044))
  call heltable([8,16,128], n3(:,11970), t3x128(:,:,4045))
  call heltable([8,16,128], n3(:,11971), t3x128(:,:,4046))
  call heltable([8,16,128], n3(:,11972), t3x128(:,:,4047))
  call heltable([8,16,128], n3(:,11973), t3x128(:,:,4048))
  call heltable([8,16,128], n3(:,11974), t3x128(:,:,4049))
  call heltable([8,16,128], n3(:,11975), t3x128(:,:,4050))
  call heltable([8,16,128], n3(:,11976), t3x128(:,:,4051))
  call heltable([8,16,128], n3(:,11977), t3x128(:,:,4052))
  call heltable([8,16,128], n3(:,11978), t3x128(:,:,4053))
  call heltable([8,16,128], n3(:,11979), t3x128(:,:,4054))
  call heltable([8,16,128], n3(:,11980), t3x128(:,:,4055))
  call heltable([8,16,128], n3(:,11981), t3x128(:,:,4056))
  call heltable([8,16,128], n3(:,11982), t3x128(:,:,4057))
  call heltable([8,16,128], n3(:,11983), t3x128(:,:,4058))
  call heltable([8,16,128], n3(:,11984), t3x128(:,:,4059))
  call heltable([8,16,128], n3(:,11985), t3x128(:,:,4060))
  call heltable([8,16,128], n3(:,11986), t3x128(:,:,4061))
  call heltable([8,16,128], n3(:,11987), t3x128(:,:,4062))
  call heltable([8,16,128], n3(:,11988), t3x128(:,:,4063))
  call heltable([8,16,128], n3(:,11989), t3x128(:,:,4064))
  call heltable([8,16,128], n3(:,11990), t3x128(:,:,4065))
  call heltable([8,16,128], n3(:,11991), t3x128(:,:,4066))
  call heltable([8,16,128], n3(:,11992), t3x128(:,:,4067))
  call heltable([8,16,128], n3(:,11993), t3x128(:,:,4068))
  call heltable([8,16,128], n3(:,11994), t3x128(:,:,4069))
  call heltable([8,16,128], n3(:,11995), t3x128(:,:,4070))
  call heltable([8,16,128], n3(:,11996), t3x128(:,:,4071))
  call heltable([16,8,128], n3(:,11997), t3x128(:,:,4072))
  call heltable([16,8,128], n3(:,11998), t3x128(:,:,4073))
  call heltable([16,8,128], n3(:,11999), t3x128(:,:,4074))
  call heltable([16,8,128], n3(:,12000), t3x128(:,:,4075))
  call heltable([16,8,128], n3(:,12001), t3x128(:,:,4076))
  call heltable([16,8,128], n3(:,12002), t3x128(:,:,4077))
  call heltable([16,8,128], n3(:,12003), t3x128(:,:,4078))
  call heltable([16,8,128], n3(:,12004), t3x128(:,:,4079))
  call heltable([16,8,128], n3(:,12005), t3x128(:,:,4080))
  call heltable([16,8,128], n3(:,12006), t3x128(:,:,4081))
  call heltable([16,8,128], n3(:,12007), t3x128(:,:,4082))
  call heltable([16,8,128], n3(:,12008), t3x128(:,:,4083))
  call heltable([16,8,128], n3(:,12009), t3x128(:,:,4084))
  call heltable([16,8,128], n3(:,12010), t3x128(:,:,4085))
  call heltable([16,8,128], n3(:,12011), t3x128(:,:,4086))
  call heltable([16,8,128], n3(:,12012), t3x128(:,:,4087))
  call heltable([8,16,128], n3(:,12013), t3x128(:,:,4088))
  call heltable([8,16,128], n3(:,12014), t3x128(:,:,4089))
  call heltable([8,16,128], n3(:,12015), t3x128(:,:,4090))
  call heltable([8,16,128], n3(:,12016), t3x128(:,:,4091))
  call heltable([8,16,128], n3(:,12017), t3x128(:,:,4092))
  call heltable([8,16,128], n3(:,12018), t3x128(:,:,4093))
  call heltable([8,16,128], n3(:,12019), t3x128(:,:,4094))
  call heltable([8,16,128], n3(:,12020), t3x128(:,:,4095))
  call heltable([8,16,128], n3(:,12021), t3x128(:,:,4096))
  call heltable([8,16,128], n3(:,12022), t3x128(:,:,4097))
  call heltable([8,16,128], n3(:,12023), t3x128(:,:,4098))
  call heltable([8,16,128], n3(:,12024), t3x128(:,:,4099))
  call heltable([8,16,128], n3(:,12025), t3x128(:,:,4100))
  call heltable([8,16,128], n3(:,12026), t3x128(:,:,4101))
  call heltable([8,16,128], n3(:,12027), t3x128(:,:,4102))
  call heltable([8,16,128], n3(:,12028), t3x128(:,:,4103))
  call heltable([8,16,128], n3(:,12029), t3x128(:,:,4104))
  call heltable([8,16,128], n3(:,12030), t3x128(:,:,4105))
  call heltable([8,16,128], n3(:,12031), t3x128(:,:,4106))
  call heltable([8,16,128], n3(:,12032), t3x128(:,:,4107))
  call heltable([8,16,128], n3(:,12033), t3x128(:,:,4108))
  call heltable([8,16,128], n3(:,12034), t3x128(:,:,4109))
  call heltable([8,16,128], n3(:,12035), t3x128(:,:,4110))
  call heltable([8,16,128], n3(:,12036), t3x128(:,:,4111))
  call heltable([8,16,128], n3(:,12037), t3x128(:,:,4112))
  call heltable([8,16,128], n3(:,12038), t3x128(:,:,4113))
  call heltable([8,16,128], n3(:,12039), t3x128(:,:,4114))
  call heltable([8,16,128], n3(:,12040), t3x128(:,:,4115))
  call heltable([8,16,128], n3(:,12041), t3x128(:,:,4116))
  call heltable([16,8,128], n3(:,12042), t3x128(:,:,4117))
  call heltable([16,8,128], n3(:,12043), t3x128(:,:,4118))
  call heltable([16,8,128], n3(:,12044), t3x128(:,:,4119))
  call heltable([16,8,128], n3(:,12045), t3x128(:,:,4120))
  call heltable([16,8,128], n3(:,12046), t3x128(:,:,4121))
  call heltable([16,8,128], n3(:,12047), t3x128(:,:,4122))
  call heltable([16,8,128], n3(:,12048), t3x128(:,:,4123))
  call heltable([16,8,128], n3(:,12049), t3x128(:,:,4124))
  call heltable([16,8,128], n3(:,12050), t3x128(:,:,4125))
  call heltable([16,8,128], n3(:,12051), t3x128(:,:,4126))
  call heltable([16,8,128], n3(:,12052), t3x128(:,:,4127))
  call heltable([16,8,128], n3(:,12053), t3x128(:,:,4128))
  call heltable([16,8,128], n3(:,12054), t3x128(:,:,4129))
  call heltable([16,8,128], n3(:,12055), t3x128(:,:,4130))
  call heltable([16,8,128], n3(:,12056), t3x128(:,:,4131))
  call heltable([16,8,128], n3(:,12057), t3x128(:,:,4132))
  call heltable([16,8,128], n3(:,12058), t3x128(:,:,4133))
  call heltable([16,8,128], n3(:,12059), t3x128(:,:,4134))
  call heltable([16,8,128], n3(:,12060), t3x128(:,:,4135))
  call heltable([16,8,128], n3(:,12061), t3x128(:,:,4136))
  call heltable([16,8,128], n3(:,12062), t3x128(:,:,4137))
  call heltable([16,8,128], n3(:,12063), t3x128(:,:,4138))
  call heltable([16,8,128], n3(:,12064), t3x128(:,:,4139))
  call heltable([16,8,128], n3(:,12065), t3x128(:,:,4140))
  call heltable([16,8,128], n3(:,12066), t3x128(:,:,4141))
  call heltable([16,8,128], n3(:,12067), t3x128(:,:,4142))
  call heltable([16,8,128], n3(:,12068), t3x128(:,:,4143))
  call heltable([16,8,128], n3(:,12069), t3x128(:,:,4144))
  call heltable([16,8,128], n3(:,12070), t3x128(:,:,4145))
  call heltable([16,8,128], n3(:,12071), t3x128(:,:,4146))
  call heltable([16,8,128], n3(:,12072), t3x128(:,:,4147))
  call heltable([16,8,128], n3(:,12073), t3x128(:,:,4148))
  call heltable([8,16,128], n3(:,12074), t3x128(:,:,4149))
  call heltable([8,16,128], n3(:,12075), t3x128(:,:,4150))
  call heltable([8,16,128], n3(:,12076), t3x128(:,:,4151))
  call heltable([8,16,128], n3(:,12077), t3x128(:,:,4152))
  call heltable([8,16,128], n3(:,12078), t3x128(:,:,4153))
  call heltable([8,16,128], n3(:,12079), t3x128(:,:,4154))
  call heltable([8,16,128], n3(:,12080), t3x128(:,:,4155))
  call heltable([8,16,128], n3(:,12081), t3x128(:,:,4156))
  call heltable([8,16,128], n3(:,12082), t3x128(:,:,4157))
  call heltable([8,16,128], n3(:,12083), t3x128(:,:,4158))
  call heltable([8,16,128], n3(:,12084), t3x128(:,:,4159))
  call heltable([8,16,128], n3(:,12085), t3x128(:,:,4160))
  call heltable([8,16,128], n3(:,12086), t3x128(:,:,4161))
  call heltable([8,16,128], n3(:,12087), t3x128(:,:,4162))
  call heltable([8,16,128], n3(:,12088), t3x128(:,:,4163))
  call heltable([8,16,128], n3(:,12089), t3x128(:,:,4164))
  call heltable([8,16,128], n3(:,12090), t3x128(:,:,4165))
  call heltable([8,16,128], n3(:,12091), t3x128(:,:,4166))
  call heltable([8,16,128], n3(:,12092), t3x128(:,:,4167))
  call heltable([8,16,128], n3(:,12093), t3x128(:,:,4168))
  call heltable([8,16,128], n3(:,12094), t3x128(:,:,4169))
  call heltable([8,16,128], n3(:,12095), t3x128(:,:,4170))
  call heltable([8,16,128], n3(:,12096), t3x128(:,:,4171))
  call heltable([8,16,128], n3(:,12097), t3x128(:,:,4172))
  call heltable([8,16,128], n3(:,12098), t3x128(:,:,4173))
  call heltable([8,16,128], n3(:,12099), t3x128(:,:,4174))
  call heltable([8,16,128], n3(:,12100), t3x128(:,:,4175))
  call heltable([8,16,128], n3(:,12101), t3x128(:,:,4176))
  call heltable([8,16,128], n3(:,12102), t3x128(:,:,4177))
  call heltable([8,16,128], n3(:,12103), t3x128(:,:,4178))
  call heltable([8,16,128], n3(:,12104), t3x128(:,:,4179))
  call heltable([8,16,128], n3(:,12105), t3x128(:,:,4180))
  call heltable([8,16,128], n3(:,12106), t3x128(:,:,4181))
  call heltable([8,16,128], n3(:,12107), t3x128(:,:,4182))
  call heltable([16,8,128], n3(:,12108), t3x128(:,:,4183))
  call heltable([16,8,128], n3(:,12109), t3x128(:,:,4184))
  call heltable([8,16,128], n3(:,12110), t3x128(:,:,4185))
  call heltable([8,16,128], n3(:,12111), t3x128(:,:,4186))
  call heltable([8,16,128], n3(:,12112), t3x128(:,:,4187))
  call heltable([8,16,128], n3(:,12113), t3x128(:,:,4188))
  call heltable([16,8,128], n3(:,12114), t3x128(:,:,4189))
  call heltable([16,8,128], n3(:,12115), t3x128(:,:,4190))
  call heltable([16,8,128], n3(:,12116), t3x128(:,:,4191))
  call heltable([16,8,128], n3(:,12117), t3x128(:,:,4192))
  call heltable([16,8,128], n3(:,12118), t3x128(:,:,4193))
  call heltable([16,8,128], n3(:,12119), t3x128(:,:,4194))
  call heltable([16,8,128], n3(:,12120), t3x128(:,:,4195))
  call heltable([16,8,128], n3(:,12121), t3x128(:,:,4196))
  call heltable([16,8,128], n3(:,12122), t3x128(:,:,4197))
  call heltable([16,8,128], n3(:,12123), t3x128(:,:,4198))
  call heltable([16,8,128], n3(:,12124), t3x128(:,:,4199))
  call heltable([16,8,128], n3(:,12125), t3x128(:,:,4200))
  call heltable([16,8,128], n3(:,12126), t3x128(:,:,4201))
  call heltable([16,8,128], n3(:,12127), t3x128(:,:,4202))
  call heltable([16,8,128], n3(:,12128), t3x128(:,:,4203))
  call heltable([16,8,128], n3(:,12129), t3x128(:,:,4204))
  call heltable([16,8,128], n3(:,12130), t3x128(:,:,4205))
  call heltable([16,8,128], n3(:,12131), t3x128(:,:,4206))
  call heltable([16,8,128], n3(:,12132), t3x128(:,:,4207))
  call heltable([16,8,128], n3(:,12133), t3x128(:,:,4208))
  call heltable([16,8,128], n3(:,12134), t3x128(:,:,4209))
  call heltable([16,8,128], n3(:,12135), t3x128(:,:,4210))
  call heltable([16,8,128], n3(:,12136), t3x128(:,:,4211))
  call heltable([16,8,128], n3(:,12137), t3x128(:,:,4212))
  call heltable([16,8,128], n3(:,12138), t3x128(:,:,4213))
  call heltable([16,8,128], n3(:,12139), t3x128(:,:,4214))
  call heltable([16,8,128], n3(:,12140), t3x128(:,:,4215))
  call heltable([16,8,128], n3(:,12141), t3x128(:,:,4216))
  call heltable([16,8,128], n3(:,12142), t3x128(:,:,4217))
  call heltable([16,8,128], n3(:,12143), t3x128(:,:,4218))
  call heltable([16,8,128], n3(:,12144), t3x128(:,:,4219))
  call heltable([16,8,128], n3(:,12145), t3x128(:,:,4220))
  call heltable([16,8,128], n3(:,12146), t3x128(:,:,4221))
  call heltable([16,8,128], n3(:,12147), t3x128(:,:,4222))
  call heltable([16,8,128], n3(:,12148), t3x128(:,:,4223))
  call heltable([16,8,128], n3(:,12149), t3x128(:,:,4224))
  call heltable([16,8,128], n3(:,12150), t3x128(:,:,4225))
  call heltable([16,8,128], n3(:,12151), t3x128(:,:,4226))
  call heltable([16,8,128], n3(:,12152), t3x128(:,:,4227))
  call heltable([16,8,128], n3(:,12153), t3x128(:,:,4228))
  call heltable([16,8,128], n3(:,12154), t3x128(:,:,4229))
  call heltable([16,8,128], n3(:,12155), t3x128(:,:,4230))
  call heltable([16,8,128], n3(:,12156), t3x128(:,:,4231))
  call heltable([16,8,128], n3(:,12157), t3x128(:,:,4232))
  call heltable([16,8,128], n3(:,12158), t3x128(:,:,4233))
  call heltable([16,8,128], n3(:,12159), t3x128(:,:,4234))
  call heltable([16,8,128], n3(:,12160), t3x128(:,:,4235))
  call heltable([16,8,128], n3(:,12161), t3x128(:,:,4236))
  call heltable([16,8,128], n3(:,12162), t3x128(:,:,4237))
  call heltable([16,8,128], n3(:,12163), t3x128(:,:,4238))
  call heltable([16,8,128], n3(:,12164), t3x128(:,:,4239))
  call heltable([16,8,128], n3(:,12165), t3x128(:,:,4240))
  call heltable([16,8,128], n3(:,12166), t3x128(:,:,4241))
  call heltable([8,16,128], n3(:,12167), t3x128(:,:,4242))
  call heltable([8,16,128], n3(:,12168), t3x128(:,:,4243))
  call heltable([8,16,128], n3(:,12169), t3x128(:,:,4244))
  call heltable([8,16,128], n3(:,12170), t3x128(:,:,4245))
  call heltable([8,16,128], n3(:,12171), t3x128(:,:,4246))
  call heltable([8,16,128], n3(:,12172), t3x128(:,:,4247))
  call heltable([8,16,128], n3(:,12173), t3x128(:,:,4248))
  call heltable([8,16,128], n3(:,12174), t3x128(:,:,4249))
  call heltable([8,16,128], n3(:,12175), t3x128(:,:,4250))
  call heltable([8,16,128], n3(:,12176), t3x128(:,:,4251))
  call heltable([8,16,128], n3(:,12177), t3x128(:,:,4252))
  call heltable([8,16,128], n3(:,12178), t3x128(:,:,4253))
  call heltable([8,16,128], n3(:,12179), t3x128(:,:,4254))
  call heltable([8,16,128], n3(:,12180), t3x128(:,:,4255))
  call heltable([8,16,128], n3(:,12181), t3x128(:,:,4256))
  call heltable([8,16,128], n3(:,12182), t3x128(:,:,4257))
  call heltable([8,16,128], n3(:,12183), t3x128(:,:,4258))
  call heltable([8,16,128], n3(:,12184), t3x128(:,:,4259))
  call heltable([8,16,128], n3(:,12185), t3x128(:,:,4260))
  call heltable([8,16,128], n3(:,12186), t3x128(:,:,4261))
  call heltable([8,16,128], n3(:,12187), t3x128(:,:,4262))
  call heltable([8,16,128], n3(:,12188), t3x128(:,:,4263))
  call heltable([8,16,128], n3(:,12189), t3x128(:,:,4264))
  call heltable([8,16,128], n3(:,12190), t3x128(:,:,4265))
  call heltable([8,16,128], n3(:,12191), t3x128(:,:,4266))
  call heltable([8,16,128], n3(:,12192), t3x128(:,:,4267))
  call heltable([8,16,128], n3(:,12193), t3x128(:,:,4268))
  call heltable([8,16,128], n3(:,12194), t3x128(:,:,4269))
  call heltable([8,16,128], n3(:,12195), t3x128(:,:,4270))
  call heltable([8,16,128], n3(:,12196), t3x128(:,:,4271))
  call heltable([8,16,128], n3(:,12197), t3x128(:,:,4272))
  call heltable([8,16,128], n3(:,12198), t3x128(:,:,4273))
  call heltable([16,8,128], n3(:,12199), t3x128(:,:,4274))
  call heltable([16,8,128], n3(:,12200), t3x128(:,:,4275))
  call heltable([16,8,128], n3(:,12201), t3x128(:,:,4276))
  call heltable([16,8,128], n3(:,12202), t3x128(:,:,4277))
  call heltable([16,8,128], n3(:,12203), t3x128(:,:,4278))
  call heltable([16,8,128], n3(:,12204), t3x128(:,:,4279))
  call heltable([16,8,128], n3(:,12205), t3x128(:,:,4280))
  call heltable([16,8,128], n3(:,12206), t3x128(:,:,4281))
  call heltable([16,8,128], n3(:,12207), t3x128(:,:,4282))
  call heltable([16,8,128], n3(:,12208), t3x128(:,:,4283))
  call heltable([16,8,128], n3(:,12209), t3x128(:,:,4284))
  call heltable([16,8,128], n3(:,12210), t3x128(:,:,4285))
  call heltable([16,8,128], n3(:,12211), t3x128(:,:,4286))
  call heltable([8,16,128], n3(:,12212), t3x128(:,:,4287))
  call heltable([8,16,128], n3(:,12213), t3x128(:,:,4288))
  call heltable([8,16,128], n3(:,12214), t3x128(:,:,4289))
  call heltable([8,16,128], n3(:,12215), t3x128(:,:,4290))
  call heltable([8,16,128], n3(:,12216), t3x128(:,:,4291))
  call heltable([8,16,128], n3(:,12217), t3x128(:,:,4292))
  call heltable([8,16,128], n3(:,12218), t3x128(:,:,4293))
  call heltable([8,16,128], n3(:,12219), t3x128(:,:,4294))
  call heltable([8,16,128], n3(:,12220), t3x128(:,:,4295))
  call heltable([8,16,128], n3(:,12221), t3x128(:,:,4296))
  call heltable([8,16,128], n3(:,12222), t3x128(:,:,4297))
  call heltable([8,16,128], n3(:,12223), t3x128(:,:,4298))
  call heltable([8,16,128], n3(:,12224), t3x128(:,:,4299))
  call heltable([8,16,128], n3(:,12225), t3x128(:,:,4300))
  call heltable([8,16,128], n3(:,12226), t3x128(:,:,4301))
  call heltable([8,16,128], n3(:,12227), t3x128(:,:,4302))
  call heltable([8,16,128], n3(:,12228), t3x128(:,:,4303))
  call heltable([8,16,128], n3(:,12229), t3x128(:,:,4304))
  call heltable([8,16,128], n3(:,12230), t3x128(:,:,4305))
  call heltable([8,16,128], n3(:,12231), t3x128(:,:,4306))
  call heltable([8,16,128], n3(:,12232), t3x128(:,:,4307))
  call heltable([8,16,128], n3(:,12233), t3x128(:,:,4308))
  call heltable([8,16,128], n3(:,12234), t3x128(:,:,4309))
  call heltable([8,16,128], n3(:,12235), t3x128(:,:,4310))
  call heltable([8,16,128], n3(:,12236), t3x128(:,:,4311))
  call heltable([8,16,128], n3(:,12237), t3x128(:,:,4312))
  call heltable([8,16,128], n3(:,12238), t3x128(:,:,4313))
  call heltable([8,16,128], n3(:,12239), t3x128(:,:,4314))
  call heltable([8,16,128], n3(:,12240), t3x128(:,:,4315))
  call heltable([8,16,128], n3(:,12241), t3x128(:,:,4316))
  call heltable([8,16,128], n3(:,12242), t3x128(:,:,4317))
  call heltable([8,16,128], n3(:,12243), t3x128(:,:,4318))
  call heltable([8,16,128], n3(:,12244), t3x128(:,:,4319))
  call heltable([8,16,128], n3(:,12245), t3x128(:,:,4320))
  call heltable([8,16,128], n3(:,12246), t3x128(:,:,4321))
  call heltable([8,16,128], n3(:,12247), t3x128(:,:,4322))
  call heltable([8,16,128], n3(:,12248), t3x128(:,:,4323))
  call heltable([8,16,128], n3(:,12249), t3x128(:,:,4324))
  call heltable([8,16,128], n3(:,12250), t3x128(:,:,4325))
  call heltable([8,16,128], n3(:,12251), t3x128(:,:,4326))
  call heltable([8,16,128], n3(:,12252), t3x128(:,:,4327))
  call heltable([8,16,128], n3(:,12253), t3x128(:,:,4328))
  call heltable([8,16,128], n3(:,12254), t3x128(:,:,4329))
  call heltable([8,16,128], n3(:,12255), t3x128(:,:,4330))
  call heltable([8,16,128], n3(:,12256), t3x128(:,:,4331))
  call heltable([8,16,128], n3(:,12257), t3x128(:,:,4332))
  call heltable([8,16,128], n3(:,12258), t3x128(:,:,4333))
  call heltable([8,16,128], n3(:,12259), t3x128(:,:,4334))
  call heltable([8,16,128], n3(:,12260), t3x128(:,:,4335))
  call heltable([8,16,128], n3(:,12261), t3x128(:,:,4336))
  call heltable([8,16,128], n3(:,12262), t3x128(:,:,4337))
  call heltable([8,16,128], n3(:,12263), t3x128(:,:,4338))
  call heltable([8,16,128], n3(:,12264), t3x128(:,:,4339))
  call heltable([8,16,128], n3(:,12265), t3x128(:,:,4340))
  call heltable([8,16,128], n3(:,12266), t3x128(:,:,4341))
  call heltable([8,16,128], n3(:,12267), t3x128(:,:,4342))
  call heltable([8,16,128], n3(:,12268), t3x128(:,:,4343))
  call heltable([8,16,128], n3(:,12269), t3x128(:,:,4344))
  call heltable([8,16,128], n3(:,12270), t3x128(:,:,4345))
  call heltable([8,16,128], n3(:,12271), t3x128(:,:,4346))
  call heltable([8,16,128], n3(:,12272), t3x128(:,:,4347))
  call heltable([8,16,128], n3(:,12273), t3x128(:,:,4348))
  call heltable([8,16,128], n3(:,12274), t3x128(:,:,4349))
  call heltable([8,16,128], n3(:,12275), t3x128(:,:,4350))
  call heltable([8,16,128], n3(:,12276), t3x128(:,:,4351))
  call heltable([8,16,128], n3(:,12277), t3x128(:,:,4352))
  call heltable([8,16,128], n3(:,12278), t3x128(:,:,4353))
  call heltable([8,16,128], n3(:,12279), t3x128(:,:,4354))
  call heltable([8,16,128], n3(:,12280), t3x128(:,:,4355))
  call heltable([8,16,128], n3(:,12281), t3x128(:,:,4356))
  call heltable([8,16,128], n3(:,12282), t3x128(:,:,4357))
  call heltable([8,16,128], n3(:,12283), t3x128(:,:,4358))
  call heltable([8,16,128], n3(:,12284), t3x128(:,:,4359))
  call heltable([8,16,128], n3(:,12285), t3x128(:,:,4360))
  call heltable([8,16,128], n3(:,12286), t3x128(:,:,4361))
  call heltable([8,16,128], n3(:,12287), t3x128(:,:,4362))
  call heltable([8,16,128], n3(:,12288), t3x128(:,:,4363))
  call heltable([8,16,128], n3(:,12289), t3x128(:,:,4364))
  call heltable([8,16,128], n3(:,12290), t3x128(:,:,4365))
  call heltable([8,16,128], n3(:,12291), t3x128(:,:,4366))
  call heltable([8,16,128], n3(:,12292), t3x128(:,:,4367))
  call heltable([8,16,128], n3(:,12293), t3x128(:,:,4368))
  call heltable([8,16,128], n3(:,12294), t3x128(:,:,4369))
  call heltable([8,16,128], n3(:,12295), t3x128(:,:,4370))
  call heltable([8,16,128], n3(:,12296), t3x128(:,:,4371))
  call heltable([8,16,128], n3(:,12297), t3x128(:,:,4372))
  call heltable([8,16,128], n3(:,12298), t3x128(:,:,4373))
  call heltable([8,16,128], n3(:,12299), t3x128(:,:,4374))
  call heltable([8,16,128], n3(:,12300), t3x128(:,:,4375))
  call heltable([8,16,128], n3(:,12301), t3x128(:,:,4376))
  call heltable([8,16,128], n3(:,12302), t3x128(:,:,4377))
  call heltable([8,16,128], n3(:,12303), t3x128(:,:,4378))
  call heltable([8,16,128], n3(:,12304), t3x128(:,:,4379))
  call heltable([8,16,128], n3(:,12305), t3x128(:,:,4380))
  call heltable([8,16,128], n3(:,12306), t3x128(:,:,4381))
  call heltable([8,16,128], n3(:,12307), t3x128(:,:,4382))
  call heltable([8,16,128], n3(:,12308), t3x128(:,:,4383))
  call heltable([8,16,128], n3(:,12309), t3x128(:,:,4384))
  call heltable([8,16,128], n3(:,12310), t3x128(:,:,4385))
  call heltable([8,16,128], n3(:,12311), t3x128(:,:,4386))
  call heltable([8,16,128], n3(:,12312), t3x128(:,:,4387))
  call heltable([8,16,128], n3(:,12313), t3x128(:,:,4388))
  call heltable([8,16,128], n3(:,12314), t3x128(:,:,4389))
  call heltable([8,16,128], n3(:,12315), t3x128(:,:,4390))
  call heltable([8,16,128], n3(:,12316), t3x128(:,:,4391))
  call heltable([8,16,128], n3(:,12317), t3x128(:,:,4392))
  call heltable([8,16,128], n3(:,12318), t3x128(:,:,4393))
  call heltable([8,16,128], n3(:,12319), t3x128(:,:,4394))
  call heltable([8,16,128], n3(:,12320), t3x128(:,:,4395))
  call heltable([8,16,128], n3(:,12321), t3x128(:,:,4396))
  call heltable([8,16,128], n3(:,12322), t3x128(:,:,4397))
  call heltable([8,16,128], n3(:,12323), t3x128(:,:,4398))
  call heltable([8,16,128], n3(:,12324), t3x128(:,:,4399))
  call heltable([8,16,128], n3(:,12325), t3x128(:,:,4400))
  call heltable([8,16,128], n3(:,12326), t3x128(:,:,4401))
  call heltable([8,16,128], n3(:,12327), t3x128(:,:,4402))
  call heltable([8,16,128], n3(:,12328), t3x128(:,:,4403))
  call heltable([8,16,128], n3(:,12329), t3x128(:,:,4404))
  call heltable([8,16,128], n3(:,12330), t3x128(:,:,4405))
  call heltable([8,16,128], n3(:,12331), t3x128(:,:,4406))
  call heltable([8,16,128], n3(:,12332), t3x128(:,:,4407))
  call heltable([8,16,128], n3(:,12333), t3x128(:,:,4408))
  call heltable([8,16,128], n3(:,12334), t3x128(:,:,4409))
  call heltable([8,16,128], n3(:,12335), t3x128(:,:,4410))
  call heltable([8,16,128], n3(:,12336), t3x128(:,:,4411))
  call heltable([8,16,128], n3(:,12337), t3x128(:,:,4412))
  call heltable([8,16,128], n3(:,12338), t3x128(:,:,4413))
  call heltable([8,16,128], n3(:,12339), t3x128(:,:,4414))
  call heltable([8,16,128], n3(:,12340), t3x128(:,:,4415))
  call heltable([8,16,128], n3(:,12341), t3x128(:,:,4416))
  call heltable([8,16,128], n3(:,12342), t3x128(:,:,4417))
  call heltable([8,16,128], n3(:,12343), t3x128(:,:,4418))
  call heltable([8,16,128], n3(:,12344), t3x128(:,:,4419))
  call heltable([8,16,128], n3(:,12345), t3x128(:,:,4420))
  call heltable([8,16,128], n3(:,12346), t3x128(:,:,4421))
  call heltable([8,16,128], n3(:,12347), t3x128(:,:,4422))
  call heltable([8,16,128], n3(:,12348), t3x128(:,:,4423))
  call heltable([8,16,128], n3(:,12349), t3x128(:,:,4424))
  call heltable([8,16,128], n3(:,12350), t3x128(:,:,4425))
  call heltable([8,16,128], n3(:,12351), t3x128(:,:,4426))
  call heltable([8,16,128], n3(:,12352), t3x128(:,:,4427))
  call heltable([8,16,128], n3(:,12353), t3x128(:,:,4428))
  call heltable([8,16,128], n3(:,12354), t3x128(:,:,4429))
  call heltable([8,16,128], n3(:,12355), t3x128(:,:,4430))
  call heltable([8,16,128], n3(:,12356), t3x128(:,:,4431))
  call heltable([8,16,128], n3(:,12357), t3x128(:,:,4432))
  call heltable([8,16,128], n3(:,12358), t3x128(:,:,4433))
  call heltable([8,16,128], n3(:,12359), t3x128(:,:,4434))
  call heltable([8,16,128], n3(:,12360), t3x128(:,:,4435))
  call heltable([8,16,128], n3(:,12361), t3x128(:,:,4436))
  call heltable([8,16,128], n3(:,12362), t3x128(:,:,4437))
  call heltable([8,16,128], n3(:,12363), t3x128(:,:,4438))
  call heltable([8,16,128], n3(:,12364), t3x128(:,:,4439))
  call heltable([8,16,128], n3(:,12365), t3x128(:,:,4440))
  call heltable([8,16,128], n3(:,12366), t3x128(:,:,4441))
  call heltable([8,16,128], n3(:,12367), t3x128(:,:,4442))
  call heltable([8,16,128], n3(:,12368), t3x128(:,:,4443))
  call heltable([8,16,128], n3(:,12369), t3x128(:,:,4444))
  call heltable([8,16,128], n3(:,12370), t3x128(:,:,4445))
  call heltable([8,16,128], n3(:,12371), t3x128(:,:,4446))
  call heltable([8,16,128], n3(:,12372), t3x128(:,:,4447))
  call heltable([8,16,128], n3(:,12373), t3x128(:,:,4448))
  call heltable([8,16,128], n3(:,12374), t3x128(:,:,4449))
  call heltable([8,16,128], n3(:,12375), t3x128(:,:,4450))
  call heltable([8,16,128], n3(:,12376), t3x128(:,:,4451))
  call heltable([8,16,128], n3(:,12377), t3x128(:,:,4452))
  call heltable([8,16,128], n3(:,12378), t3x128(:,:,4453))
  call heltable([8,16,128], n3(:,12379), t3x128(:,:,4454))
  call heltable([8,16,128], n3(:,12380), t3x128(:,:,4455))
  call heltable([8,16,128], n3(:,12381), t3x128(:,:,4456))
  call heltable([8,16,128], n3(:,12382), t3x128(:,:,4457))
  call heltable([8,16,128], n3(:,12383), t3x128(:,:,4458))
  call heltable([8,16,128], n3(:,12384), t3x128(:,:,4459))
  call heltable([8,16,128], n3(:,12385), t3x128(:,:,4460))
  call heltable([8,16,128], n3(:,12386), t3x128(:,:,4461))
  call heltable([8,16,128], n3(:,12387), t3x128(:,:,4462))
  call heltable([8,16,128], n3(:,12388), t3x128(:,:,4463))
  call heltable([8,16,128], n3(:,12389), t3x128(:,:,4464))
  call heltable([8,16,128], n3(:,12390), t3x128(:,:,4465))
  call heltable([8,16,128], n3(:,12391), t3x128(:,:,4466))
  call heltable([8,16,128], n3(:,12392), t3x128(:,:,4467))
  call heltable([8,16,128], n3(:,12393), t3x128(:,:,4468))
  call heltable([8,16,128], n3(:,12394), t3x128(:,:,4469))
  call heltable([8,16,128], n3(:,12395), t3x128(:,:,4470))
  call heltable([8,16,128], n3(:,12396), t3x128(:,:,4471))
  call heltable([8,16,128], n3(:,12397), t3x128(:,:,4472))
  call heltable([8,16,128], n3(:,12398), t3x128(:,:,4473))
  call heltable([8,16,128], n3(:,12399), t3x128(:,:,4474))
  call heltable([8,16,128], n3(:,12400), t3x128(:,:,4475))
  call heltable([8,16,128], n3(:,12401), t3x128(:,:,4476))
  call heltable([8,16,128], n3(:,12402), t3x128(:,:,4477))
  call heltable([8,16,128], n3(:,12403), t3x128(:,:,4478))
  call heltable([8,16,128], n3(:,12404), t3x128(:,:,4479))
  call heltable([8,16,128], n3(:,12405), t3x128(:,:,4480))
  call heltable([8,16,128], n3(:,12406), t3x128(:,:,4481))
  call heltable([8,16,128], n3(:,12407), t3x128(:,:,4482))
  call heltable([8,16,128], n3(:,12408), t3x128(:,:,4483))
  call heltable([8,16,128], n3(:,12409), t3x128(:,:,4484))
  call heltable([8,16,128], n3(:,12410), t3x128(:,:,4485))
  call heltable([8,16,128], n3(:,12411), t3x128(:,:,4486))
  call heltable([8,16,128], n3(:,12412), t3x128(:,:,4487))
  call heltable([8,16,128], n3(:,12413), t3x128(:,:,4488))
  call heltable([8,16,128], n3(:,12414), t3x128(:,:,4489))
  call heltable([8,16,128], n3(:,12415), t3x128(:,:,4490))
  call heltable([8,16,128], n3(:,12416), t3x128(:,:,4491))
  call heltable([8,16,128], n3(:,12417), t3x128(:,:,4492))
  call heltable([8,16,128], n3(:,12418), t3x128(:,:,4493))
  call heltable([8,16,128], n3(:,12419), t3x128(:,:,4494))
  call heltable([8,16,128], n3(:,12420), t3x128(:,:,4495))
  call heltable([8,16,128], n3(:,12421), t3x128(:,:,4496))
  call heltable([8,16,128], n3(:,12422), t3x128(:,:,4497))
  call heltable([8,16,128], n3(:,12423), t3x128(:,:,4498))
  call heltable([8,16,128], n3(:,12424), t3x128(:,:,4499))
  call heltable([8,16,128], n3(:,12425), t3x128(:,:,4500))
  call heltable([8,16,128], n3(:,12426), t3x128(:,:,4501))
  call heltable([8,16,128], n3(:,12427), t3x128(:,:,4502))
  call heltable([8,16,128], n3(:,12428), t3x128(:,:,4503))
  call heltable([8,16,128], n3(:,12429), t3x128(:,:,4504))
  call heltable([8,16,128], n3(:,12430), t3x128(:,:,4505))
  call heltable([8,16,128], n3(:,12431), t3x128(:,:,4506))
  call heltable([8,16,128], n3(:,12432), t3x128(:,:,4507))
  call heltable([8,16,128], n3(:,12433), t3x128(:,:,4508))
  call heltable([8,16,128], n3(:,12434), t3x128(:,:,4509))
  call heltable([8,16,128], n3(:,12435), t3x128(:,:,4510))
  call heltable([8,16,128], n3(:,12436), t3x128(:,:,4511))
  call heltable([8,16,128], n3(:,12437), t3x128(:,:,4512))
  call heltable([8,16,128], n3(:,12438), t3x128(:,:,4513))
  call heltable([8,16,128], n3(:,12439), t3x128(:,:,4514))
  call heltable([8,16,128], n3(:,12440), t3x128(:,:,4515))
  call heltable([8,16,128], n3(:,12441), t3x128(:,:,4516))
  call heltable([8,16,128], n3(:,12442), t3x128(:,:,4517))
  call heltable([8,16,128], n3(:,12443), t3x128(:,:,4518))
  call heltable([8,16,128], n3(:,12444), t3x128(:,:,4519))
  call heltable([8,16,128], n3(:,12445), t3x128(:,:,4520))
  call heltable([8,16,128], n3(:,12446), t3x128(:,:,4521))
  call heltable([8,16,128], n3(:,12447), t3x128(:,:,4522))
  call heltable([8,16,128], n3(:,12448), t3x128(:,:,4523))
  call heltable([8,16,128], n3(:,12449), t3x128(:,:,4524))
  call heltable([8,16,128], n3(:,12450), t3x128(:,:,4525))
  call heltable([8,16,128], n3(:,12451), t3x128(:,:,4526))
  call heltable([8,16,128], n3(:,12452), t3x128(:,:,4527))
  call heltable([8,16,128], n3(:,12453), t3x128(:,:,4528))
  call heltable([8,16,128], n3(:,12454), t3x128(:,:,4529))
  call heltable([8,16,128], n3(:,12455), t3x128(:,:,4530))
  call heltable([8,16,128], n3(:,12456), t3x128(:,:,4531))
  call heltable([8,16,128], n3(:,12457), t3x128(:,:,4532))
  call heltable([8,16,128], n3(:,12458), t3x128(:,:,4533))
  call heltable([8,16,128], n3(:,12459), t3x128(:,:,4534))
  call heltable([16,8,128], n3(:,12460), t3x128(:,:,4535))
  call heltable([16,8,128], n3(:,12461), t3x128(:,:,4536))
  call heltable([16,8,128], n3(:,12462), t3x128(:,:,4537))
  call heltable([16,8,128], n3(:,12463), t3x128(:,:,4538))
  call heltable([16,8,128], n3(:,12464), t3x128(:,:,4539))
  call heltable([16,8,128], n3(:,12465), t3x128(:,:,4540))
  call heltable([16,8,128], n3(:,12466), t3x128(:,:,4541))
  call heltable([16,8,128], n3(:,12467), t3x128(:,:,4542))
  call heltable([16,8,128], n3(:,12468), t3x128(:,:,4543))
  call heltable([16,8,128], n3(:,12469), t3x128(:,:,4544))
  call heltable([16,8,128], n3(:,12470), t3x128(:,:,4545))
  call heltable([16,8,128], n3(:,12471), t3x128(:,:,4546))
  call heltable([16,8,128], n3(:,12472), t3x128(:,:,4547))
  call heltable([16,8,128], n3(:,12473), t3x128(:,:,4548))
  call heltable([16,8,128], n3(:,12474), t3x128(:,:,4549))
  call heltable([16,8,128], n3(:,12475), t3x128(:,:,4550))
  call heltable([16,8,128], n3(:,12476), t3x128(:,:,4551))
  call heltable([16,8,128], n3(:,12477), t3x128(:,:,4552))
  call heltable([16,8,128], n3(:,12478), t3x128(:,:,4553))
  call heltable([16,8,128], n3(:,12479), t3x128(:,:,4554))
  call heltable([16,8,128], n3(:,12480), t3x128(:,:,4555))
  call heltable([16,8,128], n3(:,12481), t3x128(:,:,4556))
  call heltable([16,8,128], n3(:,12482), t3x128(:,:,4557))
  call heltable([16,8,128], n3(:,12483), t3x128(:,:,4558))
  call heltable([8,16,128], n3(:,12484), t3x128(:,:,4559))
  call heltable([8,16,128], n3(:,12485), t3x128(:,:,4560))
  call heltable([8,16,128], n3(:,12486), t3x128(:,:,4561))
  call heltable([8,16,128], n3(:,12487), t3x128(:,:,4562))
  call heltable([8,16,128], n3(:,12488), t3x128(:,:,4563))
  call heltable([8,16,128], n3(:,12489), t3x128(:,:,4564))
  call heltable([8,16,128], n3(:,12490), t3x128(:,:,4565))
  call heltable([8,16,128], n3(:,12491), t3x128(:,:,4566))
  call heltable([8,16,128], n3(:,12492), t3x128(:,:,4567))
  call heltable([8,16,128], n3(:,12493), t3x128(:,:,4568))
  call heltable([8,16,128], n3(:,12494), t3x128(:,:,4569))
  call heltable([8,16,128], n3(:,12495), t3x128(:,:,4570))
  call heltable([8,16,128], n3(:,12496), t3x128(:,:,4571))
  call heltable([8,16,128], n3(:,12497), t3x128(:,:,4572))
  call heltable([8,16,128], n3(:,12498), t3x128(:,:,4573))
  call heltable([8,16,128], n3(:,12499), t3x128(:,:,4574))
  call heltable([16,8,128], n3(:,12500), t3x128(:,:,4575))
  call heltable([16,8,128], n3(:,12501), t3x128(:,:,4576))
  call heltable([16,8,128], n3(:,12502), t3x128(:,:,4577))
  call heltable([16,8,128], n3(:,12503), t3x128(:,:,4578))
  call heltable([16,8,128], n3(:,12504), t3x128(:,:,4579))
  call heltable([16,8,128], n3(:,12505), t3x128(:,:,4580))
  call heltable([16,8,128], n3(:,12506), t3x128(:,:,4581))
  call heltable([16,8,128], n3(:,12507), t3x128(:,:,4582))
  call heltable([16,8,128], n3(:,12508), t3x128(:,:,4583))
  call heltable([16,8,128], n3(:,12509), t3x128(:,:,4584))
  call heltable([16,8,128], n3(:,12510), t3x128(:,:,4585))
  call heltable([16,8,128], n3(:,12511), t3x128(:,:,4586))
  call heltable([16,8,128], n3(:,12512), t3x128(:,:,4587))
  call heltable([16,8,128], n3(:,12513), t3x128(:,:,4588))
  call heltable([16,8,128], n3(:,12514), t3x128(:,:,4589))
  call heltable([16,8,128], n3(:,12515), t3x128(:,:,4590))
  call heltable([16,8,128], n3(:,12516), t3x128(:,:,4591))
  call heltable([16,8,128], n3(:,12517), t3x128(:,:,4592))
  call heltable([16,8,128], n3(:,12518), t3x128(:,:,4593))
  call heltable([16,8,128], n3(:,12519), t3x128(:,:,4594))
  call heltable([16,8,128], n3(:,12520), t3x128(:,:,4595))
  call heltable([16,8,128], n3(:,12521), t3x128(:,:,4596))
  call heltable([16,8,128], n3(:,12522), t3x128(:,:,4597))
  call heltable([16,8,128], n3(:,12523), t3x128(:,:,4598))
  call heltable([8,16,128], n3(:,12524), t3x128(:,:,4599))
  call heltable([8,16,128], n3(:,12525), t3x128(:,:,4600))
  call heltable([8,16,128], n3(:,12526), t3x128(:,:,4601))
  call heltable([8,16,128], n3(:,12527), t3x128(:,:,4602))
  call heltable([8,16,128], n3(:,12528), t3x128(:,:,4603))
  call heltable([8,16,128], n3(:,12529), t3x128(:,:,4604))
  call heltable([8,16,128], n3(:,12530), t3x128(:,:,4605))
  call heltable([8,16,128], n3(:,12531), t3x128(:,:,4606))
  call heltable([8,16,128], n3(:,12532), t3x128(:,:,4607))
  call heltable([8,16,128], n3(:,12533), t3x128(:,:,4608))
  call heltable([8,16,128], n3(:,12534), t3x128(:,:,4609))
  call heltable([8,16,128], n3(:,12535), t3x128(:,:,4610))
  call heltable([8,16,128], n3(:,12536), t3x128(:,:,4611))
  call heltable([8,16,128], n3(:,12537), t3x128(:,:,4612))
  call heltable([8,16,128], n3(:,12538), t3x128(:,:,4613))
  call heltable([8,16,128], n3(:,12539), t3x128(:,:,4614))
  call heltable([16,8,128], n3(:,12540), t3x128(:,:,4615))
  call heltable([16,8,128], n3(:,12541), t3x128(:,:,4616))
  call heltable([16,8,128], n3(:,12542), t3x128(:,:,4617))
  call heltable([16,8,128], n3(:,12543), t3x128(:,:,4618))
  call heltable([16,8,128], n3(:,12544), t3x128(:,:,4619))
  call heltable([16,8,128], n3(:,12545), t3x128(:,:,4620))
  call heltable([16,8,128], n3(:,12546), t3x128(:,:,4621))
  call heltable([16,8,128], n3(:,12547), t3x128(:,:,4622))
  call heltable([16,8,128], n3(:,12548), t3x128(:,:,4623))
  call heltable([16,8,128], n3(:,12549), t3x128(:,:,4624))
  call heltable([16,8,128], n3(:,12550), t3x128(:,:,4625))
  call heltable([16,8,128], n3(:,12551), t3x128(:,:,4626))
  call heltable([16,8,128], n3(:,12552), t3x128(:,:,4627))
  call heltable([16,8,128], n3(:,12553), t3x128(:,:,4628))
  call heltable([16,8,128], n3(:,12554), t3x128(:,:,4629))
  call heltable([16,8,128], n3(:,12555), t3x128(:,:,4630))
  call heltable([16,8,128], n3(:,12556), t3x128(:,:,4631))
  call heltable([16,8,128], n3(:,12557), t3x128(:,:,4632))
  call heltable([16,8,128], n3(:,12558), t3x128(:,:,4633))
  call heltable([16,8,128], n3(:,12559), t3x128(:,:,4634))
  call heltable([16,8,128], n3(:,12560), t3x128(:,:,4635))
  call heltable([16,8,128], n3(:,12561), t3x128(:,:,4636))
  call heltable([16,8,128], n3(:,12562), t3x128(:,:,4637))
  call heltable([16,8,128], n3(:,12563), t3x128(:,:,4638))
  call heltable([16,8,128], n3(:,12564), t3x128(:,:,4639))
  call heltable([16,8,128], n3(:,12565), t3x128(:,:,4640))
  call heltable([16,8,128], n3(:,12566), t3x128(:,:,4641))
  call heltable([16,8,128], n3(:,12567), t3x128(:,:,4642))
  call heltable([16,8,128], n3(:,12568), t3x128(:,:,4643))
  call heltable([16,8,128], n3(:,12569), t3x128(:,:,4644))
  call heltable([16,8,128], n3(:,12570), t3x128(:,:,4645))
  call heltable([16,8,128], n3(:,12571), t3x128(:,:,4646))
  call heltable([16,8,128], n3(:,12572), t3x128(:,:,4647))
  call heltable([16,8,128], n3(:,12573), t3x128(:,:,4648))
  call heltable([16,8,128], n3(:,12574), t3x128(:,:,4649))
  call heltable([16,8,128], n3(:,12575), t3x128(:,:,4650))
  call heltable([16,8,128], n3(:,12576), t3x128(:,:,4651))
  call heltable([16,8,128], n3(:,12577), t3x128(:,:,4652))
  call heltable([16,8,128], n3(:,12578), t3x128(:,:,4653))
  call heltable([16,8,128], n3(:,12579), t3x128(:,:,4654))
  call heltable([16,8,128], n3(:,12580), t3x128(:,:,4655))
  call heltable([16,8,128], n3(:,12581), t3x128(:,:,4656))
  call heltable([16,8,128], n3(:,12582), t3x128(:,:,4657))
  call heltable([16,8,128], n3(:,12583), t3x128(:,:,4658))
  call heltable([16,8,128], n3(:,12584), t3x128(:,:,4659))
  call heltable([16,8,128], n3(:,12585), t3x128(:,:,4660))
  call heltable([16,8,128], n3(:,12586), t3x128(:,:,4661))
  call heltable([16,8,128], n3(:,12587), t3x128(:,:,4662))
  call heltable([8,16,128], n3(:,12588), t3x128(:,:,4663))
  call heltable([8,16,128], n3(:,12589), t3x128(:,:,4664))
  call heltable([8,16,128], n3(:,12590), t3x128(:,:,4665))
  call heltable([8,16,128], n3(:,12591), t3x128(:,:,4666))
  call heltable([8,16,128], n3(:,12592), t3x128(:,:,4667))
  call heltable([8,16,128], n3(:,12593), t3x128(:,:,4668))
  call heltable([8,16,128], n3(:,12594), t3x128(:,:,4669))
  call heltable([8,16,128], n3(:,12595), t3x128(:,:,4670))
  call heltable([8,16,128], n3(:,12596), t3x128(:,:,4671))
  call heltable([8,16,128], n3(:,12597), t3x128(:,:,4672))
  call heltable([8,16,128], n3(:,12598), t3x128(:,:,4673))
  call heltable([8,16,128], n3(:,12599), t3x128(:,:,4674))
  call heltable([8,16,128], n3(:,12600), t3x128(:,:,4675))
  call heltable([8,16,128], n3(:,12601), t3x128(:,:,4676))
  call heltable([8,16,128], n3(:,12602), t3x128(:,:,4677))
  call heltable([8,16,128], n3(:,12603), t3x128(:,:,4678))
  call heltable([16,8,128], n3(:,12604), t3x128(:,:,4679))
  call heltable([16,8,128], n3(:,12605), t3x128(:,:,4680))
  call heltable([16,8,128], n3(:,12606), t3x128(:,:,4681))
  call heltable([16,8,128], n3(:,12607), t3x128(:,:,4682))
  call heltable([16,8,128], n3(:,12608), t3x128(:,:,4683))
  call heltable([16,8,128], n3(:,12609), t3x128(:,:,4684))
  call heltable([16,8,128], n3(:,12610), t3x128(:,:,4685))
  call heltable([16,8,128], n3(:,12611), t3x128(:,:,4686))
  call heltable([16,8,128], n3(:,12612), t3x128(:,:,4687))
  call heltable([16,8,128], n3(:,12613), t3x128(:,:,4688))
  call heltable([16,8,128], n3(:,12614), t3x128(:,:,4689))
  call heltable([16,8,128], n3(:,12615), t3x128(:,:,4690))
  call heltable([16,8,128], n3(:,12616), t3x128(:,:,4691))
  call heltable([16,8,128], n3(:,12617), t3x128(:,:,4692))
  call heltable([16,8,128], n3(:,12618), t3x128(:,:,4693))
  call heltable([16,8,128], n3(:,12619), t3x128(:,:,4694))
  call heltable([8,16,128], n3(:,12620), t3x128(:,:,4695))
  call heltable([8,16,128], n3(:,12621), t3x128(:,:,4696))
  call heltable([8,16,128], n3(:,12622), t3x128(:,:,4697))
  call heltable([8,16,128], n3(:,12623), t3x128(:,:,4698))
  call heltable([8,16,128], n3(:,12624), t3x128(:,:,4699))
  call heltable([8,16,128], n3(:,12625), t3x128(:,:,4700))
  call heltable([8,16,128], n3(:,12626), t3x128(:,:,4701))
  call heltable([8,16,128], n3(:,12627), t3x128(:,:,4702))
  call heltable([8,16,128], n3(:,12628), t3x128(:,:,4703))
  call heltable([8,16,128], n3(:,12629), t3x128(:,:,4704))
  call heltable([8,16,128], n3(:,12630), t3x128(:,:,4705))
  call heltable([8,16,128], n3(:,12631), t3x128(:,:,4706))
  call heltable([8,16,128], n3(:,12632), t3x128(:,:,4707))
  call heltable([8,16,128], n3(:,12633), t3x128(:,:,4708))
  call heltable([8,16,128], n3(:,12634), t3x128(:,:,4709))
  call heltable([8,16,128], n3(:,12635), t3x128(:,:,4710))
  call heltable([16,8,128], n3(:,12636), t3x128(:,:,4711))
  call heltable([16,8,128], n3(:,12637), t3x128(:,:,4712))
  call heltable([16,8,128], n3(:,12638), t3x128(:,:,4713))
  call heltable([16,8,128], n3(:,12639), t3x128(:,:,4714))
  call heltable([16,8,128], n3(:,12640), t3x128(:,:,4715))
  call heltable([16,8,128], n3(:,12641), t3x128(:,:,4716))
  call heltable([16,8,128], n3(:,12642), t3x128(:,:,4717))
  call heltable([16,8,128], n3(:,12643), t3x128(:,:,4718))
  call heltable([16,8,128], n3(:,12644), t3x128(:,:,4719))
  call heltable([16,8,128], n3(:,12645), t3x128(:,:,4720))
  call heltable([16,8,128], n3(:,12646), t3x128(:,:,4721))
  call heltable([16,8,128], n3(:,12647), t3x128(:,:,4722))
  call heltable([16,8,128], n3(:,12648), t3x128(:,:,4723))
  call heltable([16,8,128], n3(:,12649), t3x128(:,:,4724))
  call heltable([16,8,128], n3(:,12650), t3x128(:,:,4725))
  call heltable([16,8,128], n3(:,12651), t3x128(:,:,4726))
  call heltable([16,8,128], n3(:,12652), t3x128(:,:,4727))
  call heltable([16,8,128], n3(:,12653), t3x128(:,:,4728))
  call heltable([16,8,128], n3(:,12654), t3x128(:,:,4729))
  call heltable([16,8,128], n3(:,12655), t3x128(:,:,4730))
  call heltable([16,8,128], n3(:,12656), t3x128(:,:,4731))
  call heltable([16,8,128], n3(:,12657), t3x128(:,:,4732))
  call heltable([16,8,128], n3(:,12658), t3x128(:,:,4733))
  call heltable([16,8,128], n3(:,12659), t3x128(:,:,4734))
  call heltable([16,8,128], n3(:,12660), t3x128(:,:,4735))
  call heltable([16,8,128], n3(:,12661), t3x128(:,:,4736))
  call heltable([16,8,128], n3(:,12662), t3x128(:,:,4737))
  call heltable([16,8,128], n3(:,12663), t3x128(:,:,4738))
  call heltable([16,8,128], n3(:,12664), t3x128(:,:,4739))
  call heltable([16,8,128], n3(:,12665), t3x128(:,:,4740))
  call heltable([16,8,128], n3(:,12666), t3x128(:,:,4741))
  call heltable([16,8,128], n3(:,12667), t3x128(:,:,4742))
  call heltable([16,8,128], n3(:,12668), t3x128(:,:,4743))
  call heltable([16,8,128], n3(:,12669), t3x128(:,:,4744))
  call heltable([16,8,128], n3(:,12670), t3x128(:,:,4745))
  call heltable([16,8,128], n3(:,12671), t3x128(:,:,4746))
  call heltable([16,8,128], n3(:,12672), t3x128(:,:,4747))
  call heltable([16,8,128], n3(:,12673), t3x128(:,:,4748))
  call heltable([16,8,128], n3(:,12674), t3x128(:,:,4749))
  call heltable([16,8,128], n3(:,12675), t3x128(:,:,4750))
  call heltable([16,8,128], n3(:,12676), t3x128(:,:,4751))
  call heltable([16,8,128], n3(:,12677), t3x128(:,:,4752))
  call heltable([16,8,128], n3(:,12678), t3x128(:,:,4753))
  call heltable([16,8,128], n3(:,12679), t3x128(:,:,4754))
  call heltable([16,8,128], n3(:,12680), t3x128(:,:,4755))
  call heltable([16,8,128], n3(:,12681), t3x128(:,:,4756))
  call heltable([16,8,128], n3(:,12682), t3x128(:,:,4757))
  call heltable([16,8,128], n3(:,12683), t3x128(:,:,4758))
  call heltable([16,8,128], n3(:,12684), t3x128(:,:,4759))
  call heltable([16,8,128], n3(:,12685), t3x128(:,:,4760))
  call heltable([16,8,128], n3(:,12686), t3x128(:,:,4761))
  call heltable([16,8,128], n3(:,12687), t3x128(:,:,4762))
  call heltable([16,8,128], n3(:,12688), t3x128(:,:,4763))
  call heltable([16,8,128], n3(:,12689), t3x128(:,:,4764))
  call heltable([16,8,128], n3(:,12690), t3x128(:,:,4765))
  call heltable([16,8,128], n3(:,12691), t3x128(:,:,4766))
  call heltable([16,8,128], n3(:,12692), t3x128(:,:,4767))
  call heltable([16,8,128], n3(:,12693), t3x128(:,:,4768))
  call heltable([16,8,128], n3(:,12694), t3x128(:,:,4769))
  call heltable([16,8,128], n3(:,12695), t3x128(:,:,4770))
  call heltable([16,8,128], n3(:,12696), t3x128(:,:,4771))
  call heltable([16,8,128], n3(:,12697), t3x128(:,:,4772))
  call heltable([16,8,128], n3(:,12698), t3x128(:,:,4773))
  call heltable([16,8,128], n3(:,12699), t3x128(:,:,4774))
  call heltable([16,8,128], n3(:,12700), t3x128(:,:,4775))
  call heltable([16,8,128], n3(:,12701), t3x128(:,:,4776))
  call heltable([16,8,128], n3(:,12702), t3x128(:,:,4777))
  call heltable([16,8,128], n3(:,12703), t3x128(:,:,4778))
  call heltable([16,8,128], n3(:,12704), t3x128(:,:,4779))
  call heltable([16,8,128], n3(:,12705), t3x128(:,:,4780))
  call heltable([16,8,128], n3(:,12706), t3x128(:,:,4781))
  call heltable([16,8,128], n3(:,12707), t3x128(:,:,4782))
  call heltable([16,8,128], n3(:,12708), t3x128(:,:,4783))
  call heltable([16,8,128], n3(:,12709), t3x128(:,:,4784))
  call heltable([16,8,128], n3(:,12710), t3x128(:,:,4785))
  call heltable([16,8,128], n3(:,12711), t3x128(:,:,4786))
  call heltable([16,8,128], n3(:,12712), t3x128(:,:,4787))
  call heltable([16,8,128], n3(:,12713), t3x128(:,:,4788))
  call heltable([16,8,128], n3(:,12714), t3x128(:,:,4789))
  call heltable([16,8,128], n3(:,12715), t3x128(:,:,4790))
  call heltable([8,16,128], n3(:,12716), t3x128(:,:,4791))
  call heltable([8,16,128], n3(:,12717), t3x128(:,:,4792))
  call heltable([8,16,128], n3(:,12718), t3x128(:,:,4793))
  call heltable([8,16,128], n3(:,12719), t3x128(:,:,4794))
  call heltable([8,16,128], n3(:,12720), t3x128(:,:,4795))
  call heltable([8,16,128], n3(:,12721), t3x128(:,:,4796))
  call heltable([8,16,128], n3(:,12722), t3x128(:,:,4797))
  call heltable([8,16,128], n3(:,12723), t3x128(:,:,4798))
  call heltable([8,16,128], n3(:,12724), t3x128(:,:,4799))
  call heltable([8,16,128], n3(:,12725), t3x128(:,:,4800))
  call heltable([8,16,128], n3(:,12726), t3x128(:,:,4801))
  call heltable([8,16,128], n3(:,12727), t3x128(:,:,4802))
  call heltable([8,16,128], n3(:,12728), t3x128(:,:,4803))
  call heltable([8,16,128], n3(:,12729), t3x128(:,:,4804))
  call heltable([8,16,128], n3(:,12730), t3x128(:,:,4805))
  call heltable([8,16,128], n3(:,12731), t3x128(:,:,4806))
  call heltable([16,8,128], n3(:,12732), t3x128(:,:,4807))
  call heltable([16,8,128], n3(:,12733), t3x128(:,:,4808))
  call heltable([16,8,128], n3(:,12734), t3x128(:,:,4809))
  call heltable([16,8,128], n3(:,12735), t3x128(:,:,4810))
  call heltable([16,8,128], n3(:,12736), t3x128(:,:,4811))
  call heltable([16,8,128], n3(:,12737), t3x128(:,:,4812))
  call heltable([16,8,128], n3(:,12738), t3x128(:,:,4813))
  call heltable([16,8,128], n3(:,12739), t3x128(:,:,4814))
  call heltable([16,8,128], n3(:,12740), t3x128(:,:,4815))
  call heltable([16,8,128], n3(:,12741), t3x128(:,:,4816))
  call heltable([16,8,128], n3(:,12742), t3x128(:,:,4817))
  call heltable([16,8,128], n3(:,12743), t3x128(:,:,4818))
  call heltable([16,8,128], n3(:,12744), t3x128(:,:,4819))
  call heltable([16,8,128], n3(:,12745), t3x128(:,:,4820))
  call heltable([16,8,128], n3(:,12746), t3x128(:,:,4821))
  call heltable([16,8,128], n3(:,12747), t3x128(:,:,4822))
  call heltable([8,16,128], n3(:,12748), t3x128(:,:,4823))
  call heltable([8,16,128], n3(:,12749), t3x128(:,:,4824))
  call heltable([8,16,128], n3(:,12750), t3x128(:,:,4825))
  call heltable([8,16,128], n3(:,12751), t3x128(:,:,4826))
  call heltable([8,16,128], n3(:,12752), t3x128(:,:,4827))
  call heltable([8,16,128], n3(:,12753), t3x128(:,:,4828))
  call heltable([8,16,128], n3(:,12754), t3x128(:,:,4829))
  call heltable([8,16,128], n3(:,12755), t3x128(:,:,4830))
  call heltable([8,16,128], n3(:,12756), t3x128(:,:,4831))
  call heltable([8,16,128], n3(:,12757), t3x128(:,:,4832))
  call heltable([8,16,128], n3(:,12758), t3x128(:,:,4833))
  call heltable([8,16,128], n3(:,12759), t3x128(:,:,4834))
  call heltable([8,16,128], n3(:,12760), t3x128(:,:,4835))
  call heltable([8,16,128], n3(:,12761), t3x128(:,:,4836))
  call heltable([8,16,128], n3(:,12762), t3x128(:,:,4837))
  call heltable([8,16,128], n3(:,12763), t3x128(:,:,4838))
  call heltable([16,8,128], n3(:,12764), t3x128(:,:,4839))
  call heltable([16,8,128], n3(:,12765), t3x128(:,:,4840))
  call heltable([16,8,128], n3(:,12766), t3x128(:,:,4841))
  call heltable([16,8,128], n3(:,12767), t3x128(:,:,4842))
  call heltable([16,8,128], n3(:,12768), t3x128(:,:,4843))
  call heltable([16,8,128], n3(:,12769), t3x128(:,:,4844))
  call heltable([16,8,128], n3(:,12770), t3x128(:,:,4845))
  call heltable([16,8,128], n3(:,12771), t3x128(:,:,4846))
  call heltable([16,8,128], n3(:,12772), t3x128(:,:,4847))
  call heltable([16,8,128], n3(:,12773), t3x128(:,:,4848))
  call heltable([16,8,128], n3(:,12774), t3x128(:,:,4849))
  call heltable([16,8,128], n3(:,12775), t3x128(:,:,4850))
  call heltable([16,8,128], n3(:,12776), t3x128(:,:,4851))
  call heltable([16,8,128], n3(:,12777), t3x128(:,:,4852))
  call heltable([16,8,128], n3(:,12778), t3x128(:,:,4853))
  call heltable([16,8,128], n3(:,12779), t3x128(:,:,4854))
  call heltable([16,8,128], n3(:,12780), t3x128(:,:,4855))
  call heltable([16,8,128], n3(:,12781), t3x128(:,:,4856))
  call heltable([16,8,128], n3(:,12782), t3x128(:,:,4857))
  call heltable([16,8,128], n3(:,12783), t3x128(:,:,4858))
  call heltable([16,8,128], n3(:,12784), t3x128(:,:,4859))
  call heltable([16,8,128], n3(:,12785), t3x128(:,:,4860))
  call heltable([16,8,128], n3(:,12786), t3x128(:,:,4861))
  call heltable([16,8,128], n3(:,12787), t3x128(:,:,4862))
  call heltable([16,8,128], n3(:,12788), t3x128(:,:,4863))
  call heltable([16,8,128], n3(:,12789), t3x128(:,:,4864))
  call heltable([16,8,128], n3(:,12790), t3x128(:,:,4865))
  call heltable([16,8,128], n3(:,12791), t3x128(:,:,4866))
  call heltable([16,8,128], n3(:,12792), t3x128(:,:,4867))
  call heltable([16,8,128], n3(:,12793), t3x128(:,:,4868))
  call heltable([16,8,128], n3(:,12794), t3x128(:,:,4869))
  call heltable([16,8,128], n3(:,12795), t3x128(:,:,4870))
  call heltable([16,8,128], n3(:,12796), t3x128(:,:,4871))
  call heltable([16,8,128], n3(:,12797), t3x128(:,:,4872))
  call heltable([16,8,128], n3(:,12798), t3x128(:,:,4873))
  call heltable([16,8,128], n3(:,12799), t3x128(:,:,4874))
  call heltable([16,8,128], n3(:,12800), t3x128(:,:,4875))
  call heltable([16,8,128], n3(:,12801), t3x128(:,:,4876))
  call heltable([16,8,128], n3(:,12802), t3x128(:,:,4877))
  call heltable([16,8,128], n3(:,12803), t3x128(:,:,4878))
  call heltable([16,8,128], n3(:,12804), t3x128(:,:,4879))
  call heltable([16,8,128], n3(:,12805), t3x128(:,:,4880))
  call heltable([16,8,128], n3(:,12806), t3x128(:,:,4881))
  call heltable([16,8,128], n3(:,12807), t3x128(:,:,4882))
  call heltable([16,8,128], n3(:,12808), t3x128(:,:,4883))
  call heltable([16,8,128], n3(:,12809), t3x128(:,:,4884))
  call heltable([16,8,128], n3(:,12810), t3x128(:,:,4885))
  call heltable([16,8,128], n3(:,12811), t3x128(:,:,4886))
  call heltable([16,8,128], n3(:,12812), t3x128(:,:,4887))
  call heltable([16,8,128], n3(:,12813), t3x128(:,:,4888))
  call heltable([16,8,128], n3(:,12814), t3x128(:,:,4889))
  call heltable([16,8,128], n3(:,12815), t3x128(:,:,4890))
  call heltable([16,8,128], n3(:,12816), t3x128(:,:,4891))
  call heltable([16,8,128], n3(:,12817), t3x128(:,:,4892))
  call heltable([16,8,128], n3(:,12818), t3x128(:,:,4893))
  call heltable([16,8,128], n3(:,12819), t3x128(:,:,4894))
  call heltable([16,8,128], n3(:,12820), t3x128(:,:,4895))
  call heltable([16,8,128], n3(:,12821), t3x128(:,:,4896))
  call heltable([16,8,128], n3(:,12822), t3x128(:,:,4897))
  call heltable([16,8,128], n3(:,12823), t3x128(:,:,4898))
  call heltable([16,8,128], n3(:,12824), t3x128(:,:,4899))
  call heltable([16,8,128], n3(:,12825), t3x128(:,:,4900))
  call heltable([16,8,128], n3(:,12826), t3x128(:,:,4901))
  call heltable([16,8,128], n3(:,12827), t3x128(:,:,4902))
  call heltable([16,8,128], n3(:,12828), t3x128(:,:,4903))
  call heltable([16,8,128], n3(:,12829), t3x128(:,:,4904))
  call heltable([16,8,128], n3(:,12830), t3x128(:,:,4905))
  call heltable([16,8,128], n3(:,12831), t3x128(:,:,4906))
  call heltable([16,8,128], n3(:,12832), t3x128(:,:,4907))
  call heltable([16,8,128], n3(:,12833), t3x128(:,:,4908))
  call heltable([16,8,128], n3(:,12834), t3x128(:,:,4909))
  call heltable([16,8,128], n3(:,12835), t3x128(:,:,4910))
  call heltable([16,8,128], n3(:,12836), t3x128(:,:,4911))
  call heltable([16,8,128], n3(:,12837), t3x128(:,:,4912))
  call heltable([16,8,128], n3(:,12838), t3x128(:,:,4913))
  call heltable([16,8,128], n3(:,12839), t3x128(:,:,4914))
  call heltable([16,8,128], n3(:,12840), t3x128(:,:,4915))
  call heltable([16,8,128], n3(:,12841), t3x128(:,:,4916))
  call heltable([16,8,128], n3(:,12842), t3x128(:,:,4917))
  call heltable([16,8,128], n3(:,12843), t3x128(:,:,4918))
  call heltable([8,16,128], n3(:,12844), t3x128(:,:,4919))
  call heltable([8,16,128], n3(:,12845), t3x128(:,:,4920))
  call heltable([8,16,128], n3(:,12846), t3x128(:,:,4921))
  call heltable([8,16,128], n3(:,12847), t3x128(:,:,4922))
  call heltable([8,16,128], n3(:,12848), t3x128(:,:,4923))
  call heltable([8,16,128], n3(:,12849), t3x128(:,:,4924))
  call heltable([8,16,128], n3(:,12850), t3x128(:,:,4925))
  call heltable([8,16,128], n3(:,12851), t3x128(:,:,4926))
  call heltable([8,16,128], n3(:,12852), t3x128(:,:,4927))
  call heltable([8,16,128], n3(:,12853), t3x128(:,:,4928))
  call heltable([8,16,128], n3(:,12854), t3x128(:,:,4929))
  call heltable([8,16,128], n3(:,12855), t3x128(:,:,4930))
  call heltable([8,16,128], n3(:,12856), t3x128(:,:,4931))
  call heltable([8,16,128], n3(:,12857), t3x128(:,:,4932))
  call heltable([8,16,128], n3(:,12858), t3x128(:,:,4933))
  call heltable([8,16,128], n3(:,12859), t3x128(:,:,4934))
  call heltable([8,16,128], n3(:,12860), t3x128(:,:,4935))
  call heltable([8,16,128], n3(:,12861), t3x128(:,:,4936))
  call heltable([8,16,128], n3(:,12862), t3x128(:,:,4937))
  call heltable([8,16,128], n3(:,12863), t3x128(:,:,4938))
  call heltable([8,16,128], n3(:,12864), t3x128(:,:,4939))
  call heltable([8,16,128], n3(:,12865), t3x128(:,:,4940))
  call heltable([8,16,128], n3(:,12866), t3x128(:,:,4941))
  call heltable([8,16,128], n3(:,12867), t3x128(:,:,4942))
  call heltable([8,16,128], n3(:,12868), t3x128(:,:,4943))
  call heltable([8,16,128], n3(:,12869), t3x128(:,:,4944))
  call heltable([8,16,128], n3(:,12870), t3x128(:,:,4945))
  call heltable([8,16,128], n3(:,12871), t3x128(:,:,4946))
  call heltable([8,16,128], n3(:,12872), t3x128(:,:,4947))
  call heltable([16,8,128], n3(:,12873), t3x128(:,:,4948))
  call heltable([16,8,128], n3(:,12874), t3x128(:,:,4949))
  call heltable([16,8,128], n3(:,12875), t3x128(:,:,4950))
  call heltable([16,8,128], n3(:,12876), t3x128(:,:,4951))
  call heltable([16,8,128], n3(:,12877), t3x128(:,:,4952))
  call heltable([16,8,128], n3(:,12878), t3x128(:,:,4953))
  call heltable([16,8,128], n3(:,12879), t3x128(:,:,4954))
  call heltable([16,8,128], n3(:,12880), t3x128(:,:,4955))
  call heltable([16,8,128], n3(:,12881), t3x128(:,:,4956))
  call heltable([16,8,128], n3(:,12882), t3x128(:,:,4957))
  call heltable([16,8,128], n3(:,12883), t3x128(:,:,4958))
  call heltable([16,8,128], n3(:,12884), t3x128(:,:,4959))
  call heltable([16,8,128], n3(:,12885), t3x128(:,:,4960))
  call heltable([16,8,128], n3(:,12886), t3x128(:,:,4961))
  call heltable([16,8,128], n3(:,12887), t3x128(:,:,4962))
  call heltable([16,8,128], n3(:,12888), t3x128(:,:,4963))
  call heltable([8,16,128], n3(:,12889), t3x128(:,:,4964))
  call heltable([8,16,128], n3(:,12890), t3x128(:,:,4965))
  call heltable([8,16,128], n3(:,12891), t3x128(:,:,4966))
  call heltable([8,16,128], n3(:,12892), t3x128(:,:,4967))
  call heltable([8,16,128], n3(:,12893), t3x128(:,:,4968))
  call heltable([8,16,128], n3(:,12894), t3x128(:,:,4969))
  call heltable([8,16,128], n3(:,12895), t3x128(:,:,4970))
  call heltable([8,16,128], n3(:,12896), t3x128(:,:,4971))
  call heltable([8,16,128], n3(:,12897), t3x128(:,:,4972))
  call heltable([8,16,128], n3(:,12898), t3x128(:,:,4973))
  call heltable([8,16,128], n3(:,12899), t3x128(:,:,4974))
  call heltable([8,16,128], n3(:,12900), t3x128(:,:,4975))
  call heltable([8,16,128], n3(:,12901), t3x128(:,:,4976))
  call heltable([8,16,128], n3(:,12902), t3x128(:,:,4977))
  call heltable([8,16,128], n3(:,12903), t3x128(:,:,4978))
  call heltable([8,16,128], n3(:,12904), t3x128(:,:,4979))
  call heltable([8,16,128], n3(:,12905), t3x128(:,:,4980))
  call heltable([8,16,128], n3(:,12906), t3x128(:,:,4981))
  call heltable([8,16,128], n3(:,12907), t3x128(:,:,4982))
  call heltable([8,16,128], n3(:,12908), t3x128(:,:,4983))
  call heltable([8,16,128], n3(:,12909), t3x128(:,:,4984))
  call heltable([8,16,128], n3(:,12910), t3x128(:,:,4985))
  call heltable([8,16,128], n3(:,12911), t3x128(:,:,4986))
  call heltable([8,16,128], n3(:,12912), t3x128(:,:,4987))
  call heltable([8,16,128], n3(:,12913), t3x128(:,:,4988))
  call heltable([8,16,128], n3(:,12914), t3x128(:,:,4989))
  call heltable([8,16,128], n3(:,12915), t3x128(:,:,4990))
  call heltable([8,16,128], n3(:,12916), t3x128(:,:,4991))
  call heltable([8,16,128], n3(:,12917), t3x128(:,:,4992))
  call heltable([16,8,128], n3(:,12918), t3x128(:,:,4993))
  call heltable([16,8,128], n3(:,12919), t3x128(:,:,4994))
  call heltable([16,8,128], n3(:,12920), t3x128(:,:,4995))
  call heltable([16,8,128], n3(:,12921), t3x128(:,:,4996))
  call heltable([16,8,128], n3(:,12922), t3x128(:,:,4997))
  call heltable([16,8,128], n3(:,12923), t3x128(:,:,4998))
  call heltable([16,8,128], n3(:,12924), t3x128(:,:,4999))
  call heltable([16,8,128], n3(:,12925), t3x128(:,:,5000))
  call heltable([16,8,128], n3(:,12926), t3x128(:,:,5001))
  call heltable([16,8,128], n3(:,12927), t3x128(:,:,5002))
  call heltable([16,8,128], n3(:,12928), t3x128(:,:,5003))
  call heltable([16,8,128], n3(:,12929), t3x128(:,:,5004))
  call heltable([16,8,128], n3(:,12930), t3x128(:,:,5005))
  call heltable([16,8,128], n3(:,12931), t3x128(:,:,5006))
  call heltable([16,8,128], n3(:,12932), t3x128(:,:,5007))
  call heltable([16,8,128], n3(:,12933), t3x128(:,:,5008))
  call heltable([16,8,128], n3(:,12934), t3x128(:,:,5009))
  call heltable([16,8,128], n3(:,12935), t3x128(:,:,5010))
  call heltable([16,8,128], n3(:,12936), t3x128(:,:,5011))
  call heltable([16,8,128], n3(:,12937), t3x128(:,:,5012))
  call heltable([16,8,128], n3(:,12938), t3x128(:,:,5013))
  call heltable([16,8,128], n3(:,12939), t3x128(:,:,5014))
  call heltable([16,8,128], n3(:,12940), t3x128(:,:,5015))
  call heltable([16,8,128], n3(:,12941), t3x128(:,:,5016))
  call heltable([16,8,128], n3(:,12942), t3x128(:,:,5017))
  call heltable([16,8,128], n3(:,12943), t3x128(:,:,5018))
  call heltable([16,8,128], n3(:,12944), t3x128(:,:,5019))
  call heltable([16,8,128], n3(:,12945), t3x128(:,:,5020))
  call heltable([16,8,128], n3(:,12946), t3x128(:,:,5021))
  call heltable([16,8,128], n3(:,12947), t3x128(:,:,5022))
  call heltable([16,8,128], n3(:,12948), t3x128(:,:,5023))
  call heltable([16,8,128], n3(:,12949), t3x128(:,:,5024))
  call heltable([8,16,128], n3(:,12950), t3x128(:,:,5025))
  call heltable([8,16,128], n3(:,12951), t3x128(:,:,5026))
  call heltable([8,16,128], n3(:,12952), t3x128(:,:,5027))
  call heltable([8,16,128], n3(:,12953), t3x128(:,:,5028))
  call heltable([8,16,128], n3(:,12954), t3x128(:,:,5029))
  call heltable([8,16,128], n3(:,12955), t3x128(:,:,5030))
  call heltable([8,16,128], n3(:,12956), t3x128(:,:,5031))
  call heltable([8,16,128], n3(:,12957), t3x128(:,:,5032))
  call heltable([8,16,128], n3(:,12958), t3x128(:,:,5033))
  call heltable([8,16,128], n3(:,12959), t3x128(:,:,5034))
  call heltable([8,16,128], n3(:,12960), t3x128(:,:,5035))
  call heltable([8,16,128], n3(:,12961), t3x128(:,:,5036))
  call heltable([8,16,128], n3(:,12962), t3x128(:,:,5037))
  call heltable([8,16,128], n3(:,12963), t3x128(:,:,5038))
  call heltable([8,16,128], n3(:,12964), t3x128(:,:,5039))
  call heltable([8,16,128], n3(:,12965), t3x128(:,:,5040))
  call heltable([8,16,128], n3(:,12966), t3x128(:,:,5041))
  call heltable([8,16,128], n3(:,12967), t3x128(:,:,5042))
  call heltable([8,16,128], n3(:,12968), t3x128(:,:,5043))
  call heltable([8,16,128], n3(:,12969), t3x128(:,:,5044))
  call heltable([8,16,128], n3(:,12970), t3x128(:,:,5045))
  call heltable([8,16,128], n3(:,12971), t3x128(:,:,5046))
  call heltable([8,16,128], n3(:,12972), t3x128(:,:,5047))
  call heltable([8,16,128], n3(:,12973), t3x128(:,:,5048))
  call heltable([8,16,128], n3(:,12974), t3x128(:,:,5049))
  call heltable([8,16,128], n3(:,12975), t3x128(:,:,5050))
  call heltable([8,16,128], n3(:,12976), t3x128(:,:,5051))
  call heltable([8,16,128], n3(:,12977), t3x128(:,:,5052))
  call heltable([8,16,128], n3(:,12978), t3x128(:,:,5053))
  call heltable([8,16,128], n3(:,12979), t3x128(:,:,5054))
  call heltable([8,16,128], n3(:,12980), t3x128(:,:,5055))
  call heltable([8,16,128], n3(:,12981), t3x128(:,:,5056))
  call heltable([8,16,128], n3(:,12982), t3x128(:,:,5057))
  call heltable([8,16,128], n3(:,12983), t3x128(:,:,5058))
  call heltable([8,16,128], n3(:,12984), t3x128(:,:,5059))
  call heltable([8,16,128], n3(:,12985), t3x128(:,:,5060))
  call heltable([8,16,128], n3(:,12986), t3x128(:,:,5061))
  call heltable([8,16,128], n3(:,12987), t3x128(:,:,5062))
  call heltable([8,16,128], n3(:,12988), t3x128(:,:,5063))
  call heltable([8,16,128], n3(:,12989), t3x128(:,:,5064))
  call heltable([8,16,128], n3(:,12990), t3x128(:,:,5065))
  call heltable([8,16,128], n3(:,12991), t3x128(:,:,5066))
  call heltable([8,16,128], n3(:,12992), t3x128(:,:,5067))
  call heltable([8,16,128], n3(:,12993), t3x128(:,:,5068))
  call heltable([8,16,128], n3(:,12994), t3x128(:,:,5069))
  call heltable([8,16,128], n3(:,12995), t3x128(:,:,5070))
  call heltable([8,16,128], n3(:,12996), t3x128(:,:,5071))
  call heltable([8,16,128], n3(:,12997), t3x128(:,:,5072))
  call heltable([8,16,128], n3(:,12998), t3x128(:,:,5073))
  call heltable([8,16,128], n3(:,12999), t3x128(:,:,5074))
  call heltable([8,16,128], n3(:,13000), t3x128(:,:,5075))
  call heltable([8,16,128], n3(:,13001), t3x128(:,:,5076))
  call heltable([8,16,128], n3(:,13002), t3x128(:,:,5077))
  call heltable([8,16,128], n3(:,13003), t3x128(:,:,5078))
  call heltable([8,16,128], n3(:,13004), t3x128(:,:,5079))
  call heltable([8,16,128], n3(:,13005), t3x128(:,:,5080))
  call heltable([8,16,128], n3(:,13006), t3x128(:,:,5081))
  call heltable([8,16,128], n3(:,13007), t3x128(:,:,5082))
  call heltable([8,16,128], n3(:,13008), t3x128(:,:,5083))
  call heltable([8,16,128], n3(:,13009), t3x128(:,:,5084))
  call heltable([8,16,128], n3(:,13010), t3x128(:,:,5085))
  call heltable([8,16,128], n3(:,13011), t3x128(:,:,5086))
  call heltable([8,16,128], n3(:,13012), t3x128(:,:,5087))
  call heltable([8,16,128], n3(:,13013), t3x128(:,:,5088))
  call heltable([8,16,128], n3(:,13014), t3x128(:,:,5089))
  call heltable([8,16,128], n3(:,13015), t3x128(:,:,5090))
  call heltable([8,16,128], n3(:,13016), t3x128(:,:,5091))
  call heltable([8,16,128], n3(:,13017), t3x128(:,:,5092))
  call heltable([8,16,128], n3(:,13018), t3x128(:,:,5093))
  call heltable([8,16,128], n3(:,13019), t3x128(:,:,5094))
  call heltable([8,16,128], n3(:,13020), t3x128(:,:,5095))
  call heltable([8,16,128], n3(:,13021), t3x128(:,:,5096))
  call heltable([8,16,128], n3(:,13022), t3x128(:,:,5097))
  call heltable([8,16,128], n3(:,13023), t3x128(:,:,5098))
  call heltable([8,16,128], n3(:,13024), t3x128(:,:,5099))
  call heltable([8,16,128], n3(:,13025), t3x128(:,:,5100))
  call heltable([8,16,128], n3(:,13026), t3x128(:,:,5101))
  call heltable([8,16,128], n3(:,13027), t3x128(:,:,5102))
  call heltable([8,16,128], n3(:,13028), t3x128(:,:,5103))
  call heltable([8,16,128], n3(:,13029), t3x128(:,:,5104))
  call heltable([8,16,128], n3(:,13030), t3x128(:,:,5105))
  call heltable([8,16,128], n3(:,13031), t3x128(:,:,5106))
  call heltable([8,16,128], n3(:,13032), t3x128(:,:,5107))
  call heltable([8,16,128], n3(:,13033), t3x128(:,:,5108))
  call heltable([8,16,128], n3(:,13034), t3x128(:,:,5109))
  call heltable([8,16,128], n3(:,13035), t3x128(:,:,5110))
  call heltable([8,16,128], n3(:,13036), t3x128(:,:,5111))
  call heltable([8,16,128], n3(:,13037), t3x128(:,:,5112))
  call heltable([8,16,128], n3(:,13038), t3x128(:,:,5113))
  call heltable([8,16,128], n3(:,13039), t3x128(:,:,5114))
  call heltable([8,16,128], n3(:,13040), t3x128(:,:,5115))
  call heltable([8,16,128], n3(:,13041), t3x128(:,:,5116))
  call heltable([8,16,128], n3(:,13042), t3x128(:,:,5117))
  call heltable([8,16,128], n3(:,13043), t3x128(:,:,5118))
  call heltable([8,16,128], n3(:,13044), t3x128(:,:,5119))
  call heltable([8,16,128], n3(:,13045), t3x128(:,:,5120))
  call heltable([8,16,128], n3(:,13046), t3x128(:,:,5121))
  call heltable([8,16,128], n3(:,13047), t3x128(:,:,5122))
  call heltable([8,16,128], n3(:,13048), t3x128(:,:,5123))
  call heltable([8,16,128], n3(:,13049), t3x128(:,:,5124))
  call heltable([8,16,128], n3(:,13050), t3x128(:,:,5125))
  call heltable([8,16,128], n3(:,13051), t3x128(:,:,5126))
  call heltable([8,16,128], n3(:,13052), t3x128(:,:,5127))
  call heltable([8,16,128], n3(:,13053), t3x128(:,:,5128))
  call heltable([8,16,128], n3(:,13054), t3x128(:,:,5129))
  call heltable([8,16,128], n3(:,13055), t3x128(:,:,5130))
  call heltable([8,16,128], n3(:,13056), t3x128(:,:,5131))
  call heltable([8,16,128], n3(:,13057), t3x128(:,:,5132))
  call heltable([8,16,128], n3(:,13058), t3x128(:,:,5133))
  call heltable([8,16,128], n3(:,13059), t3x128(:,:,5134))
  call heltable([8,16,128], n3(:,13060), t3x128(:,:,5135))
  call heltable([8,16,128], n3(:,13061), t3x128(:,:,5136))
  call heltable([8,16,128], n3(:,13062), t3x128(:,:,5137))
  call heltable([8,16,128], n3(:,13063), t3x128(:,:,5138))
  call heltable([8,16,128], n3(:,13064), t3x128(:,:,5139))
  call heltable([8,16,128], n3(:,13065), t3x128(:,:,5140))
  call heltable([8,16,128], n3(:,13066), t3x128(:,:,5141))
  call heltable([8,16,128], n3(:,13067), t3x128(:,:,5142))
  call heltable([8,16,128], n3(:,13068), t3x128(:,:,5143))
  call heltable([8,16,128], n3(:,13069), t3x128(:,:,5144))
  call heltable([8,16,128], n3(:,13070), t3x128(:,:,5145))
  call heltable([8,16,128], n3(:,13071), t3x128(:,:,5146))
  call heltable([8,16,128], n3(:,13072), t3x128(:,:,5147))
  call heltable([8,16,128], n3(:,13073), t3x128(:,:,5148))
  call heltable([8,16,128], n3(:,13074), t3x128(:,:,5149))
  call heltable([8,16,128], n3(:,13075), t3x128(:,:,5150))
  call heltable([8,16,128], n3(:,13076), t3x128(:,:,5151))
  call heltable([8,16,128], n3(:,13077), t3x128(:,:,5152))
  call heltable([8,16,128], n3(:,13078), t3x128(:,:,5153))
  call heltable([8,16,128], n3(:,13079), t3x128(:,:,5154))
  call heltable([8,16,128], n3(:,13080), t3x128(:,:,5155))
  call heltable([8,16,128], n3(:,13081), t3x128(:,:,5156))
  call heltable([8,16,128], n3(:,13082), t3x128(:,:,5157))
  call heltable([8,16,128], n3(:,13083), t3x128(:,:,5158))
  call heltable([8,16,128], n3(:,13084), t3x128(:,:,5159))
  call heltable([8,16,128], n3(:,13085), t3x128(:,:,5160))
  call heltable([16,8,128], n3(:,13086), t3x128(:,:,5161))
  call heltable([16,8,128], n3(:,13087), t3x128(:,:,5162))
  call heltable([16,8,128], n3(:,13088), t3x128(:,:,5163))
  call heltable([16,8,128], n3(:,13089), t3x128(:,:,5164))
  call heltable([16,8,128], n3(:,13090), t3x128(:,:,5165))
  call heltable([16,8,128], n3(:,13091), t3x128(:,:,5166))
  call heltable([16,8,128], n3(:,13092), t3x128(:,:,5167))
  call heltable([16,8,128], n3(:,13093), t3x128(:,:,5168))
  call heltable([16,8,128], n3(:,13094), t3x128(:,:,5169))
  call heltable([16,8,128], n3(:,13095), t3x128(:,:,5170))
  call heltable([16,8,128], n3(:,13096), t3x128(:,:,5171))
  call heltable([16,8,128], n3(:,13097), t3x128(:,:,5172))
  call heltable([16,8,128], n3(:,13098), t3x128(:,:,5173))
  call heltable([16,8,128], n3(:,13099), t3x128(:,:,5174))
  call heltable([16,8,128], n3(:,13100), t3x128(:,:,5175))
  call heltable([16,8,128], n3(:,13101), t3x128(:,:,5176))
  call heltable([16,8,128], n3(:,13102), t3x128(:,:,5177))
  call heltable([16,8,128], n3(:,13103), t3x128(:,:,5178))
  call heltable([16,8,128], n3(:,13104), t3x128(:,:,5179))
  call heltable([16,8,128], n3(:,13105), t3x128(:,:,5180))
  call heltable([16,8,128], n3(:,13106), t3x128(:,:,5181))
  call heltable([16,8,128], n3(:,13107), t3x128(:,:,5182))
  call heltable([16,8,128], n3(:,13108), t3x128(:,:,5183))
  call heltable([16,8,128], n3(:,13109), t3x128(:,:,5184))
  call heltable([8,16,128], n3(:,13110), t3x128(:,:,5185))
  call heltable([8,16,128], n3(:,13111), t3x128(:,:,5186))
  call heltable([8,16,128], n3(:,13112), t3x128(:,:,5187))
  call heltable([8,16,128], n3(:,13113), t3x128(:,:,5188))
  call heltable([8,16,128], n3(:,13114), t3x128(:,:,5189))
  call heltable([8,16,128], n3(:,13115), t3x128(:,:,5190))
  call heltable([8,16,128], n3(:,13116), t3x128(:,:,5191))
  call heltable([8,16,128], n3(:,13117), t3x128(:,:,5192))
  call heltable([8,16,128], n3(:,13118), t3x128(:,:,5193))
  call heltable([8,16,128], n3(:,13119), t3x128(:,:,5194))
  call heltable([8,16,128], n3(:,13120), t3x128(:,:,5195))
  call heltable([8,16,128], n3(:,13121), t3x128(:,:,5196))
  call heltable([8,16,128], n3(:,13122), t3x128(:,:,5197))
  call heltable([8,16,128], n3(:,13123), t3x128(:,:,5198))
  call heltable([8,16,128], n3(:,13124), t3x128(:,:,5199))
  call heltable([8,16,128], n3(:,13125), t3x128(:,:,5200))
  call heltable([16,8,128], n3(:,13126), t3x128(:,:,5201))
  call heltable([16,8,128], n3(:,13127), t3x128(:,:,5202))
  call heltable([16,8,128], n3(:,13128), t3x128(:,:,5203))
  call heltable([16,8,128], n3(:,13129), t3x128(:,:,5204))
  call heltable([16,8,128], n3(:,13130), t3x128(:,:,5205))
  call heltable([16,8,128], n3(:,13131), t3x128(:,:,5206))
  call heltable([16,8,128], n3(:,13132), t3x128(:,:,5207))
  call heltable([16,8,128], n3(:,13133), t3x128(:,:,5208))
  call heltable([16,8,128], n3(:,13134), t3x128(:,:,5209))
  call heltable([16,8,128], n3(:,13135), t3x128(:,:,5210))
  call heltable([16,8,128], n3(:,13136), t3x128(:,:,5211))
  call heltable([16,8,128], n3(:,13137), t3x128(:,:,5212))
  call heltable([16,8,128], n3(:,13138), t3x128(:,:,5213))
  call heltable([16,8,128], n3(:,13139), t3x128(:,:,5214))
  call heltable([16,8,128], n3(:,13140), t3x128(:,:,5215))
  call heltable([16,8,128], n3(:,13141), t3x128(:,:,5216))
  call heltable([16,8,128], n3(:,13142), t3x128(:,:,5217))
  call heltable([16,8,128], n3(:,13143), t3x128(:,:,5218))
  call heltable([16,8,128], n3(:,13144), t3x128(:,:,5219))
  call heltable([16,8,128], n3(:,13145), t3x128(:,:,5220))
  call heltable([16,8,128], n3(:,13146), t3x128(:,:,5221))
  call heltable([16,8,128], n3(:,13147), t3x128(:,:,5222))
  call heltable([16,8,128], n3(:,13148), t3x128(:,:,5223))
  call heltable([16,8,128], n3(:,13149), t3x128(:,:,5224))
  call heltable([16,8,128], n3(:,13150), t3x128(:,:,5225))
  call heltable([16,8,128], n3(:,13151), t3x128(:,:,5226))
  call heltable([16,8,128], n3(:,13152), t3x128(:,:,5227))
  call heltable([16,8,128], n3(:,13153), t3x128(:,:,5228))
  call heltable([16,8,128], n3(:,13154), t3x128(:,:,5229))
  call heltable([16,8,128], n3(:,13155), t3x128(:,:,5230))
  call heltable([16,8,128], n3(:,13156), t3x128(:,:,5231))
  call heltable([16,8,128], n3(:,13157), t3x128(:,:,5232))
  call heltable([16,8,128], n3(:,13158), t3x128(:,:,5233))
  call heltable([16,8,128], n3(:,13159), t3x128(:,:,5234))
  call heltable([16,8,128], n3(:,13160), t3x128(:,:,5235))
  call heltable([16,8,128], n3(:,13161), t3x128(:,:,5236))
  call heltable([16,8,128], n3(:,13162), t3x128(:,:,5237))
  call heltable([16,8,128], n3(:,13163), t3x128(:,:,5238))
  call heltable([16,8,128], n3(:,13164), t3x128(:,:,5239))
  call heltable([16,8,128], n3(:,13165), t3x128(:,:,5240))
  call heltable([16,8,128], n3(:,13166), t3x128(:,:,5241))
  call heltable([16,8,128], n3(:,13167), t3x128(:,:,5242))
  call heltable([16,8,128], n3(:,13168), t3x128(:,:,5243))
  call heltable([16,8,128], n3(:,13169), t3x128(:,:,5244))
  call heltable([16,8,128], n3(:,13170), t3x128(:,:,5245))
  call heltable([16,8,128], n3(:,13171), t3x128(:,:,5246))
  call heltable([16,8,128], n3(:,13172), t3x128(:,:,5247))
  call heltable([16,8,128], n3(:,13173), t3x128(:,:,5248))
  call heltable([16,8,128], n3(:,13174), t3x128(:,:,5249))
  call heltable([16,8,128], n3(:,13175), t3x128(:,:,5250))
  call heltable([16,8,128], n3(:,13176), t3x128(:,:,5251))
  call heltable([16,8,128], n3(:,13177), t3x128(:,:,5252))
  call heltable([16,8,128], n3(:,13178), t3x128(:,:,5253))
  call heltable([16,8,128], n3(:,13179), t3x128(:,:,5254))
  call heltable([16,8,128], n3(:,13180), t3x128(:,:,5255))
  call heltable([16,8,128], n3(:,13181), t3x128(:,:,5256))
  call heltable([16,8,128], n3(:,13182), t3x128(:,:,5257))
  call heltable([16,8,128], n3(:,13183), t3x128(:,:,5258))
  call heltable([16,8,128], n3(:,13184), t3x128(:,:,5259))
  call heltable([16,8,128], n3(:,13185), t3x128(:,:,5260))
  call heltable([16,8,128], n3(:,13186), t3x128(:,:,5261))
  call heltable([16,8,128], n3(:,13187), t3x128(:,:,5262))
  call heltable([16,8,128], n3(:,13188), t3x128(:,:,5263))
  call heltable([16,8,128], n3(:,13189), t3x128(:,:,5264))
  call heltable([16,8,128], n3(:,13190), t3x128(:,:,5265))
  call heltable([16,8,128], n3(:,13191), t3x128(:,:,5266))
  call heltable([16,8,128], n3(:,13192), t3x128(:,:,5267))
  call heltable([16,8,128], n3(:,13193), t3x128(:,:,5268))
  call heltable([16,8,128], n3(:,13194), t3x128(:,:,5269))
  call heltable([16,8,128], n3(:,13195), t3x128(:,:,5270))
  call heltable([16,8,128], n3(:,13196), t3x128(:,:,5271))
  call heltable([16,8,128], n3(:,13197), t3x128(:,:,5272))
  call heltable([8,16,128], n3(:,13198), t3x128(:,:,5273))
  call heltable([8,16,128], n3(:,13199), t3x128(:,:,5274))
  call heltable([8,16,128], n3(:,13200), t3x128(:,:,5275))
  call heltable([8,16,128], n3(:,13201), t3x128(:,:,5276))
  call heltable([8,16,128], n3(:,13202), t3x128(:,:,5277))
  call heltable([8,16,128], n3(:,13203), t3x128(:,:,5278))
  call heltable([8,16,128], n3(:,13204), t3x128(:,:,5279))
  call heltable([8,16,128], n3(:,13205), t3x128(:,:,5280))
  call heltable([8,16,128], n3(:,13206), t3x128(:,:,5281))
  call heltable([8,16,128], n3(:,13207), t3x128(:,:,5282))
  call heltable([8,16,128], n3(:,13208), t3x128(:,:,5283))
  call heltable([8,16,128], n3(:,13209), t3x128(:,:,5284))
  call heltable([8,16,128], n3(:,13210), t3x128(:,:,5285))
  call heltable([8,16,128], n3(:,13211), t3x128(:,:,5286))
  call heltable([8,16,128], n3(:,13212), t3x128(:,:,5287))
  call heltable([8,16,128], n3(:,13213), t3x128(:,:,5288))
  call heltable([8,16,128], n3(:,13214), t3x128(:,:,5289))
  call heltable([8,16,128], n3(:,13215), t3x128(:,:,5290))
  call heltable([8,16,128], n3(:,13216), t3x128(:,:,5291))
  call heltable([8,16,128], n3(:,13217), t3x128(:,:,5292))
  call heltable([8,16,128], n3(:,13218), t3x128(:,:,5293))
  call heltable([8,16,128], n3(:,13219), t3x128(:,:,5294))
  call heltable([8,16,128], n3(:,13220), t3x128(:,:,5295))
  call heltable([8,16,128], n3(:,13221), t3x128(:,:,5296))
  call heltable([8,16,128], n3(:,13222), t3x128(:,:,5297))
  call heltable([8,16,128], n3(:,13223), t3x128(:,:,5298))
  call heltable([8,16,128], n3(:,13224), t3x128(:,:,5299))
  call heltable([8,16,128], n3(:,13225), t3x128(:,:,5300))
  call heltable([8,16,128], n3(:,13226), t3x128(:,:,5301))
  call heltable([8,16,128], n3(:,13227), t3x128(:,:,5302))
  call heltable([8,16,128], n3(:,13228), t3x128(:,:,5303))
  call heltable([8,16,128], n3(:,13229), t3x128(:,:,5304))
  call heltable([16,8,128], n3(:,13230), t3x128(:,:,5305))
  call heltable([16,8,128], n3(:,13231), t3x128(:,:,5306))
  call heltable([16,8,128], n3(:,13232), t3x128(:,:,5307))
  call heltable([16,8,128], n3(:,13233), t3x128(:,:,5308))
  call heltable([16,8,128], n3(:,13234), t3x128(:,:,5309))
  call heltable([16,8,128], n3(:,13235), t3x128(:,:,5310))
  call heltable([16,8,128], n3(:,13236), t3x128(:,:,5311))
  call heltable([16,8,128], n3(:,13237), t3x128(:,:,5312))
  call heltable([16,8,128], n3(:,13238), t3x128(:,:,5313))
  call heltable([16,8,128], n3(:,13239), t3x128(:,:,5314))
  call heltable([16,8,128], n3(:,13240), t3x128(:,:,5315))
  call heltable([16,8,128], n3(:,13241), t3x128(:,:,5316))
  call heltable([16,8,128], n3(:,13242), t3x128(:,:,5317))
  call heltable([16,8,128], n3(:,13243), t3x128(:,:,5318))
  call heltable([16,8,128], n3(:,13244), t3x128(:,:,5319))
  call heltable([16,8,128], n3(:,13245), t3x128(:,:,5320))
  call heltable([16,8,128], n3(:,13246), t3x128(:,:,5321))
  call heltable([16,8,128], n3(:,13247), t3x128(:,:,5322))
  call heltable([16,8,128], n3(:,13248), t3x128(:,:,5323))
  call heltable([16,8,128], n3(:,13249), t3x128(:,:,5324))
  call heltable([16,8,128], n3(:,13250), t3x128(:,:,5325))
  call heltable([16,8,128], n3(:,13251), t3x128(:,:,5326))
  call heltable([16,8,128], n3(:,13252), t3x128(:,:,5327))
  call heltable([16,8,128], n3(:,13253), t3x128(:,:,5328))
  call heltable([16,8,128], n3(:,13254), t3x128(:,:,5329))
  call heltable([16,8,128], n3(:,13255), t3x128(:,:,5330))
  call heltable([16,8,128], n3(:,13256), t3x128(:,:,5331))
  call heltable([16,8,128], n3(:,13257), t3x128(:,:,5332))
  call heltable([16,8,128], n3(:,13258), t3x128(:,:,5333))
  call heltable([16,8,128], n3(:,13259), t3x128(:,:,5334))
  call heltable([16,8,128], n3(:,13260), t3x128(:,:,5335))
  call heltable([16,8,128], n3(:,13261), t3x128(:,:,5336))
  call heltable([8,16,128], n3(:,13262), t3x128(:,:,5337))
  call heltable([8,16,128], n3(:,13263), t3x128(:,:,5338))
  call heltable([8,16,128], n3(:,13264), t3x128(:,:,5339))
  call heltable([8,16,128], n3(:,13265), t3x128(:,:,5340))
  call heltable([8,16,128], n3(:,13266), t3x128(:,:,5341))
  call heltable([8,16,128], n3(:,13267), t3x128(:,:,5342))
  call heltable([8,16,128], n3(:,13268), t3x128(:,:,5343))
  call heltable([8,16,128], n3(:,13269), t3x128(:,:,5344))
  call heltable([8,16,128], n3(:,13270), t3x128(:,:,5345))
  call heltable([8,16,128], n3(:,13271), t3x128(:,:,5346))
  call heltable([8,16,128], n3(:,13272), t3x128(:,:,5347))
  call heltable([8,16,128], n3(:,13273), t3x128(:,:,5348))
  call heltable([8,16,128], n3(:,13274), t3x128(:,:,5349))
  call heltable([8,16,128], n3(:,13275), t3x128(:,:,5350))
  call heltable([8,16,128], n3(:,13276), t3x128(:,:,5351))
  call heltable([8,16,128], n3(:,13277), t3x128(:,:,5352))
  call heltable([16,8,128], n3(:,13278), t3x128(:,:,5353))
  call heltable([16,8,128], n3(:,13279), t3x128(:,:,5354))
  call heltable([16,8,128], n3(:,13280), t3x128(:,:,5355))
  call heltable([16,8,128], n3(:,13281), t3x128(:,:,5356))
  call heltable([16,8,128], n3(:,13282), t3x128(:,:,5357))
  call heltable([16,8,128], n3(:,13283), t3x128(:,:,5358))
  call heltable([16,8,128], n3(:,13284), t3x128(:,:,5359))
  call heltable([16,8,128], n3(:,13285), t3x128(:,:,5360))
  call heltable([16,8,128], n3(:,13286), t3x128(:,:,5361))
  call heltable([16,8,128], n3(:,13287), t3x128(:,:,5362))
  call heltable([16,8,128], n3(:,13288), t3x128(:,:,5363))
  call heltable([16,8,128], n3(:,13289), t3x128(:,:,5364))
  call heltable([16,8,128], n3(:,13290), t3x128(:,:,5365))
  call heltable([16,8,128], n3(:,13291), t3x128(:,:,5366))
  call heltable([16,8,128], n3(:,13292), t3x128(:,:,5367))
  call heltable([16,8,128], n3(:,13293), t3x128(:,:,5368))
  call heltable([16,8,128], n3(:,13294), t3x128(:,:,5369))
  call heltable([16,8,128], n3(:,13295), t3x128(:,:,5370))
  call heltable([16,8,128], n3(:,13296), t3x128(:,:,5371))
  call heltable([16,8,128], n3(:,13297), t3x128(:,:,5372))
  call heltable([16,8,128], n3(:,13298), t3x128(:,:,5373))
  call heltable([16,8,128], n3(:,13299), t3x128(:,:,5374))
  call heltable([16,8,128], n3(:,13300), t3x128(:,:,5375))
  call heltable([16,8,128], n3(:,13301), t3x128(:,:,5376))
  call heltable([16,8,128], n3(:,13302), t3x128(:,:,5377))
  call heltable([16,8,128], n3(:,13303), t3x128(:,:,5378))
  call heltable([16,8,128], n3(:,13304), t3x128(:,:,5379))
  call heltable([16,8,128], n3(:,13305), t3x128(:,:,5380))
  call heltable([16,8,128], n3(:,13306), t3x128(:,:,5381))
  call heltable([16,8,128], n3(:,13307), t3x128(:,:,5382))
  call heltable([16,8,128], n3(:,13308), t3x128(:,:,5383))
  call heltable([16,8,128], n3(:,13309), t3x128(:,:,5384))
  call heltable([16,8,128], n3(:,13310), t3x128(:,:,5385))
  call heltable([16,8,128], n3(:,13311), t3x128(:,:,5386))
  call heltable([16,8,128], n3(:,13312), t3x128(:,:,5387))
  call heltable([16,8,128], n3(:,13313), t3x128(:,:,5388))
  call heltable([16,8,128], n3(:,13314), t3x128(:,:,5389))
  call heltable([16,8,128], n3(:,13315), t3x128(:,:,5390))
  call heltable([16,8,128], n3(:,13316), t3x128(:,:,5391))
  call heltable([16,8,128], n3(:,13317), t3x128(:,:,5392))
  call heltable([16,8,128], n3(:,13318), t3x128(:,:,5393))
  call heltable([16,8,128], n3(:,13319), t3x128(:,:,5394))
  call heltable([16,8,128], n3(:,13320), t3x128(:,:,5395))
  call heltable([16,8,128], n3(:,13321), t3x128(:,:,5396))
  call heltable([16,8,128], n3(:,13322), t3x128(:,:,5397))
  call heltable([16,8,128], n3(:,13323), t3x128(:,:,5398))
  call heltable([16,8,128], n3(:,13324), t3x128(:,:,5399))
  call heltable([16,8,128], n3(:,13325), t3x128(:,:,5400))
  call heltable([16,8,128], n3(:,13326), t3x128(:,:,5401))
  call heltable([16,8,128], n3(:,13327), t3x128(:,:,5402))
  call heltable([16,8,128], n3(:,13328), t3x128(:,:,5403))
  call heltable([16,8,128], n3(:,13329), t3x128(:,:,5404))
  call heltable([16,8,128], n3(:,13330), t3x128(:,:,5405))
  call heltable([16,8,128], n3(:,13331), t3x128(:,:,5406))
  call heltable([16,8,128], n3(:,13332), t3x128(:,:,5407))
  call heltable([16,8,128], n3(:,13333), t3x128(:,:,5408))
  call heltable([16,8,128], n3(:,13334), t3x128(:,:,5409))
  call heltable([16,8,128], n3(:,13335), t3x128(:,:,5410))
  call heltable([16,8,128], n3(:,13336), t3x128(:,:,5411))
  call heltable([16,8,128], n3(:,13337), t3x128(:,:,5412))
  call heltable([16,8,128], n3(:,13338), t3x128(:,:,5413))
  call heltable([16,8,128], n3(:,13339), t3x128(:,:,5414))
  call heltable([16,8,128], n3(:,13340), t3x128(:,:,5415))
  call heltable([16,8,128], n3(:,13341), t3x128(:,:,5416))
  call heltable([8,16,128], n3(:,13342), t3x128(:,:,5417))
  call heltable([8,16,128], n3(:,13343), t3x128(:,:,5418))
  call heltable([8,16,128], n3(:,13344), t3x128(:,:,5419))
  call heltable([8,16,128], n3(:,13345), t3x128(:,:,5420))
  call heltable([8,16,128], n3(:,13346), t3x128(:,:,5421))
  call heltable([8,16,128], n3(:,13347), t3x128(:,:,5422))
  call heltable([8,16,128], n3(:,13348), t3x128(:,:,5423))
  call heltable([8,16,128], n3(:,13349), t3x128(:,:,5424))
  call heltable([8,16,128], n3(:,13350), t3x128(:,:,5425))
  call heltable([8,16,128], n3(:,13351), t3x128(:,:,5426))
  call heltable([8,16,128], n3(:,13352), t3x128(:,:,5427))
  call heltable([8,16,128], n3(:,13353), t3x128(:,:,5428))
  call heltable([8,16,128], n3(:,13354), t3x128(:,:,5429))
  call heltable([8,16,128], n3(:,13355), t3x128(:,:,5430))
  call heltable([8,16,128], n3(:,13356), t3x128(:,:,5431))
  call heltable([8,16,128], n3(:,13357), t3x128(:,:,5432))
  call heltable([16,8,128], n3(:,13358), t3x128(:,:,5433))
  call heltable([16,8,128], n3(:,13359), t3x128(:,:,5434))
  call heltable([16,8,128], n3(:,13360), t3x128(:,:,5435))
  call heltable([16,8,128], n3(:,13361), t3x128(:,:,5436))
  call heltable([16,8,128], n3(:,13362), t3x128(:,:,5437))
  call heltable([16,8,128], n3(:,13363), t3x128(:,:,5438))
  call heltable([16,8,128], n3(:,13364), t3x128(:,:,5439))
  call heltable([16,8,128], n3(:,13365), t3x128(:,:,5440))
  call heltable([16,8,128], n3(:,13366), t3x128(:,:,5441))
  call heltable([16,8,128], n3(:,13367), t3x128(:,:,5442))
  call heltable([16,8,128], n3(:,13368), t3x128(:,:,5443))
  call heltable([16,8,128], n3(:,13369), t3x128(:,:,5444))
  call heltable([16,8,128], n3(:,13370), t3x128(:,:,5445))
  call heltable([16,8,128], n3(:,13371), t3x128(:,:,5446))
  call heltable([16,8,128], n3(:,13372), t3x128(:,:,5447))
  call heltable([16,8,128], n3(:,13373), t3x128(:,:,5448))
  call heltable([16,8,128], n3(:,13374), t3x128(:,:,5449))
  call heltable([16,8,128], n3(:,13375), t3x128(:,:,5450))
  call heltable([16,8,128], n3(:,13376), t3x128(:,:,5451))
  call heltable([16,8,128], n3(:,13377), t3x128(:,:,5452))
  call heltable([16,8,128], n3(:,13378), t3x128(:,:,5453))
  call heltable([16,8,128], n3(:,13379), t3x128(:,:,5454))
  call heltable([16,8,128], n3(:,13380), t3x128(:,:,5455))
  call heltable([16,8,128], n3(:,13381), t3x128(:,:,5456))
  call heltable([16,8,128], n3(:,13382), t3x128(:,:,5457))
  call heltable([16,8,128], n3(:,13383), t3x128(:,:,5458))
  call heltable([16,8,128], n3(:,13384), t3x128(:,:,5459))
  call heltable([16,8,128], n3(:,13385), t3x128(:,:,5460))
  call heltable([16,8,128], n3(:,13386), t3x128(:,:,5461))
  call heltable([16,8,128], n3(:,13387), t3x128(:,:,5462))
  call heltable([16,8,128], n3(:,13388), t3x128(:,:,5463))
  call heltable([16,8,128], n3(:,13389), t3x128(:,:,5464))
  call heltable([8,16,128], n3(:,13390), t3x128(:,:,5465))
  call heltable([8,16,128], n3(:,13391), t3x128(:,:,5466))
  call heltable([8,16,128], n3(:,13392), t3x128(:,:,5467))
  call heltable([8,16,128], n3(:,13393), t3x128(:,:,5468))
  call heltable([8,16,128], n3(:,13394), t3x128(:,:,5469))
  call heltable([8,16,128], n3(:,13395), t3x128(:,:,5470))
  call heltable([8,16,128], n3(:,13396), t3x128(:,:,5471))
  call heltable([8,16,128], n3(:,13397), t3x128(:,:,5472))
  call heltable([8,16,128], n3(:,13398), t3x128(:,:,5473))
  call heltable([8,16,128], n3(:,13399), t3x128(:,:,5474))
  call heltable([8,16,128], n3(:,13400), t3x128(:,:,5475))
  call heltable([8,16,128], n3(:,13401), t3x128(:,:,5476))
  call heltable([8,16,128], n3(:,13402), t3x128(:,:,5477))
  call heltable([8,16,128], n3(:,13403), t3x128(:,:,5478))
  call heltable([8,16,128], n3(:,13404), t3x128(:,:,5479))
  call heltable([8,16,128], n3(:,13405), t3x128(:,:,5480))
  call heltable([16,8,128], n3(:,13406), t3x128(:,:,5481))
  call heltable([16,8,128], n3(:,13407), t3x128(:,:,5482))
  call heltable([16,8,128], n3(:,13408), t3x128(:,:,5483))
  call heltable([16,8,128], n3(:,13409), t3x128(:,:,5484))
  call heltable([16,8,128], n3(:,13410), t3x128(:,:,5485))
  call heltable([16,8,128], n3(:,13411), t3x128(:,:,5486))
  call heltable([16,8,128], n3(:,13412), t3x128(:,:,5487))
  call heltable([16,8,128], n3(:,13413), t3x128(:,:,5488))
  call heltable([16,8,128], n3(:,13414), t3x128(:,:,5489))
  call heltable([16,8,128], n3(:,13415), t3x128(:,:,5490))
  call heltable([16,8,128], n3(:,13416), t3x128(:,:,5491))
  call heltable([16,8,128], n3(:,13417), t3x128(:,:,5492))
  call heltable([16,8,128], n3(:,13418), t3x128(:,:,5493))
  call heltable([16,8,128], n3(:,13419), t3x128(:,:,5494))
  call heltable([16,8,128], n3(:,13420), t3x128(:,:,5495))
  call heltable([16,8,128], n3(:,13421), t3x128(:,:,5496))
  call heltable([16,8,128], n3(:,13422), t3x128(:,:,5497))
  call heltable([16,8,128], n3(:,13423), t3x128(:,:,5498))
  call heltable([16,8,128], n3(:,13424), t3x128(:,:,5499))
  call heltable([16,8,128], n3(:,13425), t3x128(:,:,5500))
  call heltable([16,8,128], n3(:,13426), t3x128(:,:,5501))
  call heltable([16,8,128], n3(:,13427), t3x128(:,:,5502))
  call heltable([16,8,128], n3(:,13428), t3x128(:,:,5503))
  call heltable([16,8,128], n3(:,13429), t3x128(:,:,5504))
  call heltable([16,8,128], n3(:,13430), t3x128(:,:,5505))
  call heltable([16,8,128], n3(:,13431), t3x128(:,:,5506))
  call heltable([16,8,128], n3(:,13432), t3x128(:,:,5507))
  call heltable([16,8,128], n3(:,13433), t3x128(:,:,5508))
  call heltable([16,8,128], n3(:,13434), t3x128(:,:,5509))
  call heltable([16,8,128], n3(:,13435), t3x128(:,:,5510))
  call heltable([16,8,128], n3(:,13436), t3x128(:,:,5511))
  call heltable([16,8,128], n3(:,13437), t3x128(:,:,5512))
  call heltable([16,8,128], n3(:,13438), t3x128(:,:,5513))
  call heltable([16,8,128], n3(:,13439), t3x128(:,:,5514))
  call heltable([16,8,128], n3(:,13440), t3x128(:,:,5515))
  call heltable([16,8,128], n3(:,13441), t3x128(:,:,5516))
  call heltable([16,8,128], n3(:,13442), t3x128(:,:,5517))
  call heltable([16,8,128], n3(:,13443), t3x128(:,:,5518))
  call heltable([16,8,128], n3(:,13444), t3x128(:,:,5519))
  call heltable([16,8,128], n3(:,13445), t3x128(:,:,5520))
  call heltable([16,8,128], n3(:,13446), t3x128(:,:,5521))
  call heltable([16,8,128], n3(:,13447), t3x128(:,:,5522))
  call heltable([16,8,128], n3(:,13448), t3x128(:,:,5523))
  call heltable([16,8,128], n3(:,13449), t3x128(:,:,5524))
  call heltable([16,8,128], n3(:,13450), t3x128(:,:,5525))
  call heltable([16,8,128], n3(:,13451), t3x128(:,:,5526))
  call heltable([16,8,128], n3(:,13452), t3x128(:,:,5527))
  call heltable([16,8,128], n3(:,13453), t3x128(:,:,5528))
  call heltable([16,8,128], n3(:,13454), t3x128(:,:,5529))
  call heltable([16,8,128], n3(:,13455), t3x128(:,:,5530))
  call heltable([16,8,128], n3(:,13456), t3x128(:,:,5531))
  call heltable([16,8,128], n3(:,13457), t3x128(:,:,5532))
  call heltable([16,8,128], n3(:,13458), t3x128(:,:,5533))
  call heltable([16,8,128], n3(:,13459), t3x128(:,:,5534))
  call heltable([16,8,128], n3(:,13460), t3x128(:,:,5535))
  call heltable([16,8,128], n3(:,13461), t3x128(:,:,5536))
  call heltable([16,8,128], n3(:,13462), t3x128(:,:,5537))
  call heltable([16,8,128], n3(:,13463), t3x128(:,:,5538))
  call heltable([16,8,128], n3(:,13464), t3x128(:,:,5539))
  call heltable([16,8,128], n3(:,13465), t3x128(:,:,5540))
  call heltable([16,8,128], n3(:,13466), t3x128(:,:,5541))
  call heltable([16,8,128], n3(:,13467), t3x128(:,:,5542))
  call heltable([16,8,128], n3(:,13468), t3x128(:,:,5543))
  call heltable([16,8,128], n3(:,13469), t3x128(:,:,5544))
  call heltable([8,16,128], n3(:,13470), t3x128(:,:,5545))
  call heltable([8,16,128], n3(:,13471), t3x128(:,:,5546))
  call heltable([8,16,128], n3(:,13472), t3x128(:,:,5547))
  call heltable([8,16,128], n3(:,13473), t3x128(:,:,5548))
  call heltable([8,16,128], n3(:,13474), t3x128(:,:,5549))
  call heltable([8,16,128], n3(:,13475), t3x128(:,:,5550))
  call heltable([8,16,128], n3(:,13476), t3x128(:,:,5551))
  call heltable([8,16,128], n3(:,13477), t3x128(:,:,5552))
  call heltable([8,16,128], n3(:,13478), t3x128(:,:,5553))
  call heltable([8,16,128], n3(:,13479), t3x128(:,:,5554))
  call heltable([8,16,128], n3(:,13480), t3x128(:,:,5555))
  call heltable([8,16,128], n3(:,13481), t3x128(:,:,5556))
  call heltable([8,16,128], n3(:,13482), t3x128(:,:,5557))
  call heltable([8,16,128], n3(:,13483), t3x128(:,:,5558))
  call heltable([8,16,128], n3(:,13484), t3x128(:,:,5559))
  call heltable([8,16,128], n3(:,13485), t3x128(:,:,5560))
  call heltable([8,16,128], n3(:,13486), t3x128(:,:,5561))
  call heltable([8,16,128], n3(:,13487), t3x128(:,:,5562))
  call heltable([8,16,128], n3(:,13488), t3x128(:,:,5563))
  call heltable([8,16,128], n3(:,13489), t3x128(:,:,5564))
  call heltable([8,16,128], n3(:,13490), t3x128(:,:,5565))
  call heltable([8,16,128], n3(:,13491), t3x128(:,:,5566))
  call heltable([8,16,128], n3(:,13492), t3x128(:,:,5567))
  call heltable([8,16,128], n3(:,13493), t3x128(:,:,5568))
  call heltable([8,16,128], n3(:,13494), t3x128(:,:,5569))
  call heltable([8,16,128], n3(:,13495), t3x128(:,:,5570))
  call heltable([8,16,128], n3(:,13496), t3x128(:,:,5571))
  call heltable([8,16,128], n3(:,13497), t3x128(:,:,5572))
  call heltable([8,16,128], n3(:,13498), t3x128(:,:,5573))
  call heltable([16,8,128], n3(:,13499), t3x128(:,:,5574))
  call heltable([16,8,128], n3(:,13500), t3x128(:,:,5575))
  call heltable([16,8,128], n3(:,13501), t3x128(:,:,5576))
  call heltable([16,8,128], n3(:,13502), t3x128(:,:,5577))
  call heltable([16,8,128], n3(:,13503), t3x128(:,:,5578))
  call heltable([16,8,128], n3(:,13504), t3x128(:,:,5579))
  call heltable([16,8,128], n3(:,13505), t3x128(:,:,5580))
  call heltable([16,8,128], n3(:,13506), t3x128(:,:,5581))
  call heltable([16,8,128], n3(:,13507), t3x128(:,:,5582))
  call heltable([16,8,128], n3(:,13508), t3x128(:,:,5583))
  call heltable([16,8,128], n3(:,13509), t3x128(:,:,5584))
  call heltable([16,8,128], n3(:,13510), t3x128(:,:,5585))
  call heltable([16,8,128], n3(:,13511), t3x128(:,:,5586))
  call heltable([16,8,128], n3(:,13512), t3x128(:,:,5587))
  call heltable([16,8,128], n3(:,13513), t3x128(:,:,5588))
  call heltable([16,8,128], n3(:,13514), t3x128(:,:,5589))
  call heltable([8,16,128], n3(:,13515), t3x128(:,:,5590))
  call heltable([8,16,128], n3(:,13516), t3x128(:,:,5591))
  call heltable([8,16,128], n3(:,13517), t3x128(:,:,5592))
  call heltable([8,16,128], n3(:,13518), t3x128(:,:,5593))
  call heltable([8,16,128], n3(:,13519), t3x128(:,:,5594))
  call heltable([8,16,128], n3(:,13520), t3x128(:,:,5595))
  call heltable([8,16,128], n3(:,13521), t3x128(:,:,5596))
  call heltable([8,16,128], n3(:,13522), t3x128(:,:,5597))
  call heltable([8,16,128], n3(:,13523), t3x128(:,:,5598))
  call heltable([8,16,128], n3(:,13524), t3x128(:,:,5599))
  call heltable([8,16,128], n3(:,13525), t3x128(:,:,5600))
  call heltable([8,16,128], n3(:,13526), t3x128(:,:,5601))
  call heltable([8,16,128], n3(:,13527), t3x128(:,:,5602))
  call heltable([8,16,128], n3(:,13528), t3x128(:,:,5603))
  call heltable([8,16,128], n3(:,13529), t3x128(:,:,5604))
  call heltable([8,16,128], n3(:,13530), t3x128(:,:,5605))
  call heltable([8,16,128], n3(:,13531), t3x128(:,:,5606))
  call heltable([8,16,128], n3(:,13532), t3x128(:,:,5607))
  call heltable([8,16,128], n3(:,13533), t3x128(:,:,5608))
  call heltable([8,16,128], n3(:,13534), t3x128(:,:,5609))
  call heltable([8,16,128], n3(:,13535), t3x128(:,:,5610))
  call heltable([8,16,128], n3(:,13536), t3x128(:,:,5611))
  call heltable([8,16,128], n3(:,13537), t3x128(:,:,5612))
  call heltable([8,16,128], n3(:,13538), t3x128(:,:,5613))
  call heltable([8,16,128], n3(:,13539), t3x128(:,:,5614))
  call heltable([8,16,128], n3(:,13540), t3x128(:,:,5615))
  call heltable([8,16,128], n3(:,13541), t3x128(:,:,5616))
  call heltable([8,16,128], n3(:,13542), t3x128(:,:,5617))
  call heltable([8,16,128], n3(:,13543), t3x128(:,:,5618))
  call heltable([16,8,128], n3(:,13544), t3x128(:,:,5619))
  call heltable([16,8,128], n3(:,13545), t3x128(:,:,5620))
  call heltable([16,8,128], n3(:,13546), t3x128(:,:,5621))
  call heltable([16,8,128], n3(:,13547), t3x128(:,:,5622))
  call heltable([16,8,128], n3(:,13548), t3x128(:,:,5623))
  call heltable([16,8,128], n3(:,13549), t3x128(:,:,5624))
  call heltable([16,8,128], n3(:,13550), t3x128(:,:,5625))
  call heltable([16,8,128], n3(:,13551), t3x128(:,:,5626))
  call heltable([16,8,128], n3(:,13552), t3x128(:,:,5627))
  call heltable([16,8,128], n3(:,13553), t3x128(:,:,5628))
  call heltable([16,8,128], n3(:,13554), t3x128(:,:,5629))
  call heltable([16,8,128], n3(:,13555), t3x128(:,:,5630))
  call heltable([16,8,128], n3(:,13556), t3x128(:,:,5631))
  call heltable([16,8,128], n3(:,13557), t3x128(:,:,5632))
  call heltable([16,8,128], n3(:,13558), t3x128(:,:,5633))
  call heltable([16,8,128], n3(:,13559), t3x128(:,:,5634))
  call heltable([16,8,128], n3(:,13560), t3x128(:,:,5635))
  call heltable([16,8,128], n3(:,13561), t3x128(:,:,5636))
  call heltable([16,8,128], n3(:,13562), t3x128(:,:,5637))
  call heltable([16,8,128], n3(:,13563), t3x128(:,:,5638))
  call heltable([16,8,128], n3(:,13564), t3x128(:,:,5639))
  call heltable([16,8,128], n3(:,13565), t3x128(:,:,5640))
  call heltable([16,8,128], n3(:,13566), t3x128(:,:,5641))
  call heltable([16,8,128], n3(:,13567), t3x128(:,:,5642))
  call heltable([16,8,128], n3(:,13568), t3x128(:,:,5643))
  call heltable([16,8,128], n3(:,13569), t3x128(:,:,5644))
  call heltable([16,8,128], n3(:,13570), t3x128(:,:,5645))
  call heltable([16,8,128], n3(:,13571), t3x128(:,:,5646))
  call heltable([16,8,128], n3(:,13572), t3x128(:,:,5647))
  call heltable([16,8,128], n3(:,13573), t3x128(:,:,5648))
  call heltable([16,8,128], n3(:,13574), t3x128(:,:,5649))
  call heltable([16,8,128], n3(:,13575), t3x128(:,:,5650))
  call heltable([8,16,128], n3(:,13576), t3x128(:,:,5651))
  call heltable([8,16,128], n3(:,13577), t3x128(:,:,5652))
  call heltable([8,16,128], n3(:,13578), t3x128(:,:,5653))
  call heltable([8,16,128], n3(:,13579), t3x128(:,:,5654))
  call heltable([8,16,128], n3(:,13580), t3x128(:,:,5655))
  call heltable([8,16,128], n3(:,13581), t3x128(:,:,5656))
  call heltable([8,16,128], n3(:,13582), t3x128(:,:,5657))
  call heltable([8,16,128], n3(:,13583), t3x128(:,:,5658))
  call heltable([8,16,128], n3(:,13584), t3x128(:,:,5659))
  call heltable([8,16,128], n3(:,13585), t3x128(:,:,5660))
  call heltable([8,16,128], n3(:,13586), t3x128(:,:,5661))
  call heltable([8,16,128], n3(:,13587), t3x128(:,:,5662))
  call heltable([8,16,128], n3(:,13588), t3x128(:,:,5663))
  call heltable([8,16,128], n3(:,13589), t3x128(:,:,5664))
  call heltable([8,16,128], n3(:,13590), t3x128(:,:,5665))
  call heltable([8,16,128], n3(:,13591), t3x128(:,:,5666))
  call heltable([16,8,128], n3(:,13592), t3x128(:,:,5667))
  call heltable([16,8,128], n3(:,13593), t3x128(:,:,5668))
  call heltable([16,8,128], n3(:,13594), t3x128(:,:,5669))
  call heltable([16,8,128], n3(:,13595), t3x128(:,:,5670))
  call heltable([16,8,128], n3(:,13596), t3x128(:,:,5671))
  call heltable([16,8,128], n3(:,13597), t3x128(:,:,5672))
  call heltable([16,8,128], n3(:,13598), t3x128(:,:,5673))
  call heltable([16,8,128], n3(:,13599), t3x128(:,:,5674))
  call heltable([16,8,128], n3(:,13600), t3x128(:,:,5675))
  call heltable([16,8,128], n3(:,13601), t3x128(:,:,5676))
  call heltable([16,8,128], n3(:,13602), t3x128(:,:,5677))
  call heltable([16,8,128], n3(:,13603), t3x128(:,:,5678))
  call heltable([16,8,128], n3(:,13604), t3x128(:,:,5679))
  call heltable([16,8,128], n3(:,13605), t3x128(:,:,5680))
  call heltable([16,8,128], n3(:,13606), t3x128(:,:,5681))
  call heltable([16,8,128], n3(:,13607), t3x128(:,:,5682))
  call heltable([8,16,128], n3(:,13608), t3x128(:,:,5683))
  call heltable([8,16,128], n3(:,13609), t3x128(:,:,5684))
  call heltable([8,16,128], n3(:,13610), t3x128(:,:,5685))
  call heltable([8,16,128], n3(:,13611), t3x128(:,:,5686))
  call heltable([8,16,128], n3(:,13612), t3x128(:,:,5687))
  call heltable([8,16,128], n3(:,13613), t3x128(:,:,5688))
  call heltable([8,16,128], n3(:,13614), t3x128(:,:,5689))
  call heltable([8,16,128], n3(:,13615), t3x128(:,:,5690))
  call heltable([8,16,128], n3(:,13616), t3x128(:,:,5691))
  call heltable([8,16,128], n3(:,13617), t3x128(:,:,5692))
  call heltable([8,16,128], n3(:,13618), t3x128(:,:,5693))
  call heltable([8,16,128], n3(:,13619), t3x128(:,:,5694))
  call heltable([8,16,128], n3(:,13620), t3x128(:,:,5695))
  call heltable([8,16,128], n3(:,13621), t3x128(:,:,5696))
  call heltable([8,16,128], n3(:,13622), t3x128(:,:,5697))
  call heltable([8,16,128], n3(:,13623), t3x128(:,:,5698))
  call heltable([8,16,128], n3(:,13624), t3x128(:,:,5699))
  call heltable([8,16,128], n3(:,13625), t3x128(:,:,5700))
  call heltable([8,16,128], n3(:,13626), t3x128(:,:,5701))
  call heltable([8,16,128], n3(:,13627), t3x128(:,:,5702))
  call heltable([8,16,128], n3(:,13628), t3x128(:,:,5703))
  call heltable([8,16,128], n3(:,13629), t3x128(:,:,5704))
  call heltable([8,16,128], n3(:,13630), t3x128(:,:,5705))
  call heltable([8,16,128], n3(:,13631), t3x128(:,:,5706))
  call heltable([8,16,128], n3(:,13632), t3x128(:,:,5707))
  call heltable([8,16,128], n3(:,13633), t3x128(:,:,5708))
  call heltable([8,16,128], n3(:,13634), t3x128(:,:,5709))
  call heltable([8,16,128], n3(:,13635), t3x128(:,:,5710))
  call heltable([8,16,128], n3(:,13636), t3x128(:,:,5711))
  call heltable([8,16,128], n3(:,13637), t3x128(:,:,5712))
  call heltable([8,16,128], n3(:,13638), t3x128(:,:,5713))
  call heltable([8,16,128], n3(:,13639), t3x128(:,:,5714))
  call heltable([8,16,128], n3(:,13640), t3x128(:,:,5715))
  call heltable([8,16,128], n3(:,13641), t3x128(:,:,5716))
  call heltable([8,16,128], n3(:,13642), t3x128(:,:,5717))
  call heltable([8,16,128], n3(:,13643), t3x128(:,:,5718))
  call heltable([8,16,128], n3(:,13644), t3x128(:,:,5719))
  call heltable([8,16,128], n3(:,13645), t3x128(:,:,5720))
  call heltable([8,16,128], n3(:,13646), t3x128(:,:,5721))
  call heltable([8,16,128], n3(:,13647), t3x128(:,:,5722))
  call heltable([8,16,128], n3(:,13648), t3x128(:,:,5723))
  call heltable([8,16,128], n3(:,13649), t3x128(:,:,5724))
  call heltable([8,16,128], n3(:,13650), t3x128(:,:,5725))
  call heltable([8,16,128], n3(:,13651), t3x128(:,:,5726))
  call heltable([8,16,128], n3(:,13652), t3x128(:,:,5727))
  call heltable([8,16,128], n3(:,13653), t3x128(:,:,5728))
  call heltable([8,16,128], n3(:,13654), t3x128(:,:,5729))
  call heltable([8,16,128], n3(:,13655), t3x128(:,:,5730))
  call heltable([16,8,128], n3(:,13656), t3x128(:,:,5731))
  call heltable([16,8,128], n3(:,13657), t3x128(:,:,5732))
  call heltable([16,8,128], n3(:,13658), t3x128(:,:,5733))
  call heltable([16,8,128], n3(:,13659), t3x128(:,:,5734))
  call heltable([16,8,128], n3(:,13660), t3x128(:,:,5735))
  call heltable([16,8,128], n3(:,13661), t3x128(:,:,5736))
  call heltable([16,8,128], n3(:,13662), t3x128(:,:,5737))
  call heltable([16,8,128], n3(:,13663), t3x128(:,:,5738))
  call heltable([16,8,128], n3(:,13664), t3x128(:,:,5739))
  call heltable([16,8,128], n3(:,13665), t3x128(:,:,5740))
  call heltable([16,8,128], n3(:,13666), t3x128(:,:,5741))
  call heltable([16,8,128], n3(:,13667), t3x128(:,:,5742))
  call heltable([16,8,128], n3(:,13668), t3x128(:,:,5743))
  call heltable([16,8,128], n3(:,13669), t3x128(:,:,5744))
  call heltable([16,8,128], n3(:,13670), t3x128(:,:,5745))
  call heltable([16,8,128], n3(:,13671), t3x128(:,:,5746))
  call heltable([8,16,128], n3(:,13672), t3x128(:,:,5747))
  call heltable([8,16,128], n3(:,13673), t3x128(:,:,5748))
  call heltable([8,16,128], n3(:,13674), t3x128(:,:,5749))
  call heltable([8,16,128], n3(:,13675), t3x128(:,:,5750))
  call heltable([8,16,128], n3(:,13676), t3x128(:,:,5751))
  call heltable([8,16,128], n3(:,13677), t3x128(:,:,5752))
  call heltable([8,16,128], n3(:,13678), t3x128(:,:,5753))
  call heltable([8,16,128], n3(:,13679), t3x128(:,:,5754))
  call heltable([8,16,128], n3(:,13680), t3x128(:,:,5755))
  call heltable([8,16,128], n3(:,13681), t3x128(:,:,5756))
  call heltable([8,16,128], n3(:,13682), t3x128(:,:,5757))
  call heltable([8,16,128], n3(:,13683), t3x128(:,:,5758))
  call heltable([8,16,128], n3(:,13684), t3x128(:,:,5759))
  call heltable([8,16,128], n3(:,13685), t3x128(:,:,5760))
  call heltable([8,16,128], n3(:,13686), t3x128(:,:,5761))
  call heltable([8,16,128], n3(:,13687), t3x128(:,:,5762))
  call heltable([8,16,128], n3(:,13688), t3x128(:,:,5763))
  call heltable([8,16,128], n3(:,13689), t3x128(:,:,5764))
  call heltable([8,16,128], n3(:,13690), t3x128(:,:,5765))
  call heltable([8,16,128], n3(:,13691), t3x128(:,:,5766))
  call heltable([8,16,128], n3(:,13692), t3x128(:,:,5767))
  call heltable([8,16,128], n3(:,13693), t3x128(:,:,5768))
  call heltable([8,16,128], n3(:,13694), t3x128(:,:,5769))
  call heltable([8,16,128], n3(:,13695), t3x128(:,:,5770))
  call heltable([8,16,128], n3(:,13696), t3x128(:,:,5771))
  call heltable([8,16,128], n3(:,13697), t3x128(:,:,5772))
  call heltable([8,16,128], n3(:,13698), t3x128(:,:,5773))
  call heltable([8,16,128], n3(:,13699), t3x128(:,:,5774))
  call heltable([8,16,128], n3(:,13700), t3x128(:,:,5775))
  call heltable([8,16,128], n3(:,13701), t3x128(:,:,5776))
  call heltable([8,16,128], n3(:,13702), t3x128(:,:,5777))
  call heltable([8,16,128], n3(:,13703), t3x128(:,:,5778))
  call heltable([8,16,128], n3(:,13704), t3x128(:,:,5779))
  call heltable([8,16,128], n3(:,13705), t3x128(:,:,5780))
  call heltable([8,16,128], n3(:,13706), t3x128(:,:,5781))
  call heltable([8,16,128], n3(:,13707), t3x128(:,:,5782))
  call heltable([8,16,128], n3(:,13708), t3x128(:,:,5783))
  call heltable([8,16,128], n3(:,13709), t3x128(:,:,5784))
  call heltable([8,16,128], n3(:,13710), t3x128(:,:,5785))
  call heltable([8,16,128], n3(:,13711), t3x128(:,:,5786))
  call heltable([8,16,128], n3(:,13712), t3x128(:,:,5787))
  call heltable([8,16,128], n3(:,13713), t3x128(:,:,5788))
  call heltable([8,16,128], n3(:,13714), t3x128(:,:,5789))
  call heltable([8,16,128], n3(:,13715), t3x128(:,:,5790))
  call heltable([8,16,128], n3(:,13716), t3x128(:,:,5791))
  call heltable([8,16,128], n3(:,13717), t3x128(:,:,5792))
  call heltable([8,16,128], n3(:,13718), t3x128(:,:,5793))
  call heltable([8,16,128], n3(:,13719), t3x128(:,:,5794))
  call heltable([16,8,128], n3(:,13720), t3x128(:,:,5795))
  call heltable([16,8,128], n3(:,13721), t3x128(:,:,5796))
  call heltable([16,8,128], n3(:,13722), t3x128(:,:,5797))
  call heltable([16,8,128], n3(:,13723), t3x128(:,:,5798))
  call heltable([16,8,128], n3(:,13724), t3x128(:,:,5799))
  call heltable([16,8,128], n3(:,13725), t3x128(:,:,5800))
  call heltable([16,8,128], n3(:,13726), t3x128(:,:,5801))
  call heltable([16,8,128], n3(:,13727), t3x128(:,:,5802))
  call heltable([16,8,128], n3(:,13728), t3x128(:,:,5803))
  call heltable([16,8,128], n3(:,13729), t3x128(:,:,5804))
  call heltable([16,8,128], n3(:,13730), t3x128(:,:,5805))
  call heltable([16,8,128], n3(:,13731), t3x128(:,:,5806))
  call heltable([16,8,128], n3(:,13732), t3x128(:,:,5807))
  call heltable([16,8,128], n3(:,13733), t3x128(:,:,5808))
  call heltable([16,8,128], n3(:,13734), t3x128(:,:,5809))
  call heltable([16,8,128], n3(:,13735), t3x128(:,:,5810))
  call heltable([16,8,128], n3(:,13736), t3x128(:,:,5811))
  call heltable([16,8,128], n3(:,13737), t3x128(:,:,5812))
  call heltable([16,8,128], n3(:,13738), t3x128(:,:,5813))
  call heltable([16,8,128], n3(:,13739), t3x128(:,:,5814))
  call heltable([16,8,128], n3(:,13740), t3x128(:,:,5815))
  call heltable([16,8,128], n3(:,13741), t3x128(:,:,5816))
  call heltable([16,8,128], n3(:,13742), t3x128(:,:,5817))
  call heltable([16,8,128], n3(:,13743), t3x128(:,:,5818))
  call heltable([16,8,128], n3(:,13744), t3x128(:,:,5819))
  call heltable([16,8,128], n3(:,13745), t3x128(:,:,5820))
  call heltable([16,8,128], n3(:,13746), t3x128(:,:,5821))
  call heltable([16,8,128], n3(:,13747), t3x128(:,:,5822))
  call heltable([16,8,128], n3(:,13748), t3x128(:,:,5823))
  call heltable([16,8,128], n3(:,13749), t3x128(:,:,5824))
  call heltable([16,8,128], n3(:,13750), t3x128(:,:,5825))
  call heltable([16,8,128], n3(:,13751), t3x128(:,:,5826))
  call heltable([16,8,128], n3(:,13752), t3x128(:,:,5827))
  call heltable([16,8,128], n3(:,13753), t3x128(:,:,5828))
  call heltable([16,8,128], n3(:,13754), t3x128(:,:,5829))
  call heltable([16,8,128], n3(:,13755), t3x128(:,:,5830))
  call heltable([16,8,128], n3(:,13756), t3x128(:,:,5831))
  call heltable([16,8,128], n3(:,13757), t3x128(:,:,5832))
  call heltable([16,8,128], n3(:,13758), t3x128(:,:,5833))
  call heltable([16,8,128], n3(:,13759), t3x128(:,:,5834))
  call heltable([16,8,128], n3(:,13760), t3x128(:,:,5835))
  call heltable([16,8,128], n3(:,13761), t3x128(:,:,5836))
  call heltable([16,8,128], n3(:,13762), t3x128(:,:,5837))
  call heltable([16,8,128], n3(:,13763), t3x128(:,:,5838))
  call heltable([16,8,128], n3(:,13764), t3x128(:,:,5839))
  call heltable([16,8,128], n3(:,13765), t3x128(:,:,5840))
  call heltable([16,8,128], n3(:,13766), t3x128(:,:,5841))
  call heltable([16,8,128], n3(:,13767), t3x128(:,:,5842))
  call heltable([8,16,128], n3(:,13768), t3x128(:,:,5843))
  call heltable([8,16,128], n3(:,13769), t3x128(:,:,5844))
  call heltable([8,16,128], n3(:,13770), t3x128(:,:,5845))
  call heltable([8,16,128], n3(:,13771), t3x128(:,:,5846))
  call heltable([8,16,128], n3(:,13772), t3x128(:,:,5847))
  call heltable([8,16,128], n3(:,13773), t3x128(:,:,5848))
  call heltable([8,16,128], n3(:,13774), t3x128(:,:,5849))
  call heltable([8,16,128], n3(:,13775), t3x128(:,:,5850))
  call heltable([8,16,128], n3(:,13776), t3x128(:,:,5851))
  call heltable([8,16,128], n3(:,13777), t3x128(:,:,5852))
  call heltable([8,16,128], n3(:,13778), t3x128(:,:,5853))
  call heltable([8,16,128], n3(:,13779), t3x128(:,:,5854))
  call heltable([8,16,128], n3(:,13780), t3x128(:,:,5855))
  call heltable([8,16,128], n3(:,13781), t3x128(:,:,5856))
  call heltable([8,16,128], n3(:,13782), t3x128(:,:,5857))
  call heltable([8,16,128], n3(:,13783), t3x128(:,:,5858))
  call heltable([16,8,128], n3(:,13784), t3x128(:,:,5859))
  call heltable([16,8,128], n3(:,13785), t3x128(:,:,5860))
  call heltable([16,8,128], n3(:,13786), t3x128(:,:,5861))
  call heltable([16,8,128], n3(:,13787), t3x128(:,:,5862))
  call heltable([16,8,128], n3(:,13788), t3x128(:,:,5863))
  call heltable([16,8,128], n3(:,13789), t3x128(:,:,5864))
  call heltable([16,8,128], n3(:,13790), t3x128(:,:,5865))
  call heltable([16,8,128], n3(:,13791), t3x128(:,:,5866))
  call heltable([16,8,128], n3(:,13792), t3x128(:,:,5867))
  call heltable([16,8,128], n3(:,13793), t3x128(:,:,5868))
  call heltable([16,8,128], n3(:,13794), t3x128(:,:,5869))
  call heltable([16,8,128], n3(:,13795), t3x128(:,:,5870))
  call heltable([16,8,128], n3(:,13796), t3x128(:,:,5871))
  call heltable([16,8,128], n3(:,13797), t3x128(:,:,5872))
  call heltable([16,8,128], n3(:,13798), t3x128(:,:,5873))
  call heltable([16,8,128], n3(:,13799), t3x128(:,:,5874))
  call heltable([16,8,128], n3(:,13800), t3x128(:,:,5875))
  call heltable([16,8,128], n3(:,13801), t3x128(:,:,5876))
  call heltable([16,8,128], n3(:,13802), t3x128(:,:,5877))
  call heltable([16,8,128], n3(:,13803), t3x128(:,:,5878))
  call heltable([16,8,128], n3(:,13804), t3x128(:,:,5879))
  call heltable([16,8,128], n3(:,13805), t3x128(:,:,5880))
  call heltable([16,8,128], n3(:,13806), t3x128(:,:,5881))
  call heltable([16,8,128], n3(:,13807), t3x128(:,:,5882))
  call heltable([16,8,128], n3(:,13808), t3x128(:,:,5883))
  call heltable([16,8,128], n3(:,13809), t3x128(:,:,5884))
  call heltable([16,8,128], n3(:,13810), t3x128(:,:,5885))
  call heltable([16,8,128], n3(:,13811), t3x128(:,:,5886))
  call heltable([16,8,128], n3(:,13812), t3x128(:,:,5887))
  call heltable([16,8,128], n3(:,13813), t3x128(:,:,5888))
  call heltable([16,8,128], n3(:,13814), t3x128(:,:,5889))
  call heltable([16,8,128], n3(:,13815), t3x128(:,:,5890))
  call heltable([16,8,128], n3(:,13816), t3x128(:,:,5891))
  call heltable([16,8,128], n3(:,13817), t3x128(:,:,5892))
  call heltable([16,8,128], n3(:,13818), t3x128(:,:,5893))
  call heltable([16,8,128], n3(:,13819), t3x128(:,:,5894))
  call heltable([16,8,128], n3(:,13820), t3x128(:,:,5895))
  call heltable([16,8,128], n3(:,13821), t3x128(:,:,5896))
  call heltable([16,8,128], n3(:,13822), t3x128(:,:,5897))
  call heltable([16,8,128], n3(:,13823), t3x128(:,:,5898))
  call heltable([16,8,128], n3(:,13824), t3x128(:,:,5899))
  call heltable([16,8,128], n3(:,13825), t3x128(:,:,5900))
  call heltable([16,8,128], n3(:,13826), t3x128(:,:,5901))
  call heltable([16,8,128], n3(:,13827), t3x128(:,:,5902))
  call heltable([16,8,128], n3(:,13828), t3x128(:,:,5903))
  call heltable([16,8,128], n3(:,13829), t3x128(:,:,5904))
  call heltable([16,8,128], n3(:,13830), t3x128(:,:,5905))
  call heltable([16,8,128], n3(:,13831), t3x128(:,:,5906))
  call heltable([8,16,128], n3(:,13832), t3x128(:,:,5907))
  call heltable([8,16,128], n3(:,13833), t3x128(:,:,5908))
  call heltable([8,16,128], n3(:,13834), t3x128(:,:,5909))
  call heltable([8,16,128], n3(:,13835), t3x128(:,:,5910))
  call heltable([8,16,128], n3(:,13836), t3x128(:,:,5911))
  call heltable([8,16,128], n3(:,13837), t3x128(:,:,5912))
  call heltable([8,16,128], n3(:,13838), t3x128(:,:,5913))
  call heltable([8,16,128], n3(:,13839), t3x128(:,:,5914))
  call heltable([8,16,128], n3(:,13840), t3x128(:,:,5915))
  call heltable([8,16,128], n3(:,13841), t3x128(:,:,5916))
  call heltable([8,16,128], n3(:,13842), t3x128(:,:,5917))
  call heltable([8,16,128], n3(:,13843), t3x128(:,:,5918))
  call heltable([8,16,128], n3(:,13844), t3x128(:,:,5919))
  call heltable([8,16,128], n3(:,13845), t3x128(:,:,5920))
  call heltable([8,16,128], n3(:,13846), t3x128(:,:,5921))
  call heltable([8,16,128], n3(:,13847), t3x128(:,:,5922))
  call heltable([16,8,128], n3(:,13848), t3x128(:,:,5923))
  call heltable([16,8,128], n3(:,13849), t3x128(:,:,5924))
  call heltable([16,8,128], n3(:,13850), t3x128(:,:,5925))
  call heltable([16,8,128], n3(:,13851), t3x128(:,:,5926))
  call heltable([16,8,128], n3(:,13852), t3x128(:,:,5927))
  call heltable([16,8,128], n3(:,13853), t3x128(:,:,5928))
  call heltable([16,8,128], n3(:,13854), t3x128(:,:,5929))
  call heltable([16,8,128], n3(:,13855), t3x128(:,:,5930))
  call heltable([16,8,128], n3(:,13856), t3x128(:,:,5931))
  call heltable([16,8,128], n3(:,13857), t3x128(:,:,5932))
  call heltable([16,8,128], n3(:,13858), t3x128(:,:,5933))
  call heltable([16,8,128], n3(:,13859), t3x128(:,:,5934))
  call heltable([16,8,128], n3(:,13860), t3x128(:,:,5935))
  call heltable([16,8,128], n3(:,13861), t3x128(:,:,5936))
  call heltable([16,8,128], n3(:,13862), t3x128(:,:,5937))
  call heltable([16,8,128], n3(:,13863), t3x128(:,:,5938))
  call heltable([8,16,128], n3(:,13864), t3x128(:,:,5939))
  call heltable([8,16,128], n3(:,13865), t3x128(:,:,5940))
  call heltable([8,16,128], n3(:,13866), t3x128(:,:,5941))
  call heltable([8,16,128], n3(:,13867), t3x128(:,:,5942))
  call heltable([8,16,128], n3(:,13868), t3x128(:,:,5943))
  call heltable([8,16,128], n3(:,13869), t3x128(:,:,5944))
  call heltable([8,16,128], n3(:,13870), t3x128(:,:,5945))
  call heltable([8,16,128], n3(:,13871), t3x128(:,:,5946))
  call heltable([8,16,128], n3(:,13872), t3x128(:,:,5947))
  call heltable([8,16,128], n3(:,13873), t3x128(:,:,5948))
  call heltable([8,16,128], n3(:,13874), t3x128(:,:,5949))
  call heltable([8,16,128], n3(:,13875), t3x128(:,:,5950))
  call heltable([8,16,128], n3(:,13876), t3x128(:,:,5951))
  call heltable([8,16,128], n3(:,13877), t3x128(:,:,5952))
  call heltable([8,16,128], n3(:,13878), t3x128(:,:,5953))
  call heltable([8,16,128], n3(:,13879), t3x128(:,:,5954))
  call heltable([16,8,128], n3(:,13880), t3x128(:,:,5955))
  call heltable([16,8,128], n3(:,13881), t3x128(:,:,5956))
  call heltable([16,8,128], n3(:,13882), t3x128(:,:,5957))
  call heltable([16,8,128], n3(:,13883), t3x128(:,:,5958))
  call heltable([16,8,128], n3(:,13884), t3x128(:,:,5959))
  call heltable([16,8,128], n3(:,13885), t3x128(:,:,5960))
  call heltable([16,8,128], n3(:,13886), t3x128(:,:,5961))
  call heltable([16,8,128], n3(:,13887), t3x128(:,:,5962))
  call heltable([16,8,128], n3(:,13888), t3x128(:,:,5963))
  call heltable([16,8,128], n3(:,13889), t3x128(:,:,5964))
  call heltable([16,8,128], n3(:,13890), t3x128(:,:,5965))
  call heltable([16,8,128], n3(:,13891), t3x128(:,:,5966))
  call heltable([16,8,128], n3(:,13892), t3x128(:,:,5967))
  call heltable([16,8,128], n3(:,13893), t3x128(:,:,5968))
  call heltable([16,8,128], n3(:,13894), t3x128(:,:,5969))
  call heltable([16,8,128], n3(:,13895), t3x128(:,:,5970))
  call heltable([16,8,128], n3(:,13896), t3x128(:,:,5971))
  call heltable([16,8,128], n3(:,13897), t3x128(:,:,5972))
  call heltable([16,8,128], n3(:,13898), t3x128(:,:,5973))
  call heltable([16,8,128], n3(:,13899), t3x128(:,:,5974))
  call heltable([16,8,128], n3(:,13900), t3x128(:,:,5975))
  call heltable([16,8,128], n3(:,13901), t3x128(:,:,5976))
  call heltable([16,8,128], n3(:,13902), t3x128(:,:,5977))
  call heltable([16,8,128], n3(:,13903), t3x128(:,:,5978))
  call heltable([16,8,128], n3(:,13904), t3x128(:,:,5979))
  call heltable([16,8,128], n3(:,13905), t3x128(:,:,5980))
  call heltable([16,8,128], n3(:,13906), t3x128(:,:,5981))
  call heltable([16,8,128], n3(:,13907), t3x128(:,:,5982))
  call heltable([16,8,128], n3(:,13908), t3x128(:,:,5983))
  call heltable([16,8,128], n3(:,13909), t3x128(:,:,5984))
  call heltable([16,8,128], n3(:,13910), t3x128(:,:,5985))
  call heltable([16,8,128], n3(:,13911), t3x128(:,:,5986))
  call heltable([16,8,128], n3(:,13912), t3x128(:,:,5987))
  call heltable([16,8,128], n3(:,13913), t3x128(:,:,5988))
  call heltable([16,8,128], n3(:,13914), t3x128(:,:,5989))
  call heltable([16,8,128], n3(:,13915), t3x128(:,:,5990))
  call heltable([16,8,128], n3(:,13916), t3x128(:,:,5991))
  call heltable([16,8,128], n3(:,13917), t3x128(:,:,5992))
  call heltable([16,8,128], n3(:,13918), t3x128(:,:,5993))
  call heltable([16,8,128], n3(:,13919), t3x128(:,:,5994))
  call heltable([16,8,128], n3(:,13920), t3x128(:,:,5995))
  call heltable([16,8,128], n3(:,13921), t3x128(:,:,5996))
  call heltable([16,8,128], n3(:,13922), t3x128(:,:,5997))
  call heltable([16,8,128], n3(:,13923), t3x128(:,:,5998))
  call heltable([16,8,128], n3(:,13924), t3x128(:,:,5999))
  call heltable([16,8,128], n3(:,13925), t3x128(:,:,6000))
  call heltable([16,8,128], n3(:,13926), t3x128(:,:,6001))
  call heltable([16,8,128], n3(:,13927), t3x128(:,:,6002))
  call heltable([16,8,128], n3(:,13928), t3x128(:,:,6003))
  call heltable([16,8,128], n3(:,13929), t3x128(:,:,6004))
  call heltable([16,8,128], n3(:,13930), t3x128(:,:,6005))
  call heltable([16,8,128], n3(:,13931), t3x128(:,:,6006))
  call heltable([16,8,128], n3(:,13932), t3x128(:,:,6007))
  call heltable([16,8,128], n3(:,13933), t3x128(:,:,6008))
  call heltable([16,8,128], n3(:,13934), t3x128(:,:,6009))
  call heltable([16,8,128], n3(:,13935), t3x128(:,:,6010))
  call heltable([16,8,128], n3(:,13936), t3x128(:,:,6011))
  call heltable([16,8,128], n3(:,13937), t3x128(:,:,6012))
  call heltable([16,8,128], n3(:,13938), t3x128(:,:,6013))
  call heltable([16,8,128], n3(:,13939), t3x128(:,:,6014))
  call heltable([16,8,128], n3(:,13940), t3x128(:,:,6015))
  call heltable([16,8,128], n3(:,13941), t3x128(:,:,6016))
  call heltable([16,8,128], n3(:,13942), t3x128(:,:,6017))
  call heltable([16,8,128], n3(:,13943), t3x128(:,:,6018))
  call heltable([16,8,128], n3(:,13944), t3x128(:,:,6019))
  call heltable([16,8,128], n3(:,13945), t3x128(:,:,6020))
  call heltable([16,8,128], n3(:,13946), t3x128(:,:,6021))
  call heltable([16,8,128], n3(:,13947), t3x128(:,:,6022))
  call heltable([16,8,128], n3(:,13948), t3x128(:,:,6023))
  call heltable([16,8,128], n3(:,13949), t3x128(:,:,6024))
  call heltable([16,8,128], n3(:,13950), t3x128(:,:,6025))
  call heltable([16,8,128], n3(:,13951), t3x128(:,:,6026))
  call heltable([16,8,128], n3(:,13952), t3x128(:,:,6027))
  call heltable([16,8,128], n3(:,13953), t3x128(:,:,6028))
  call heltable([16,8,128], n3(:,13954), t3x128(:,:,6029))
  call heltable([16,8,128], n3(:,13955), t3x128(:,:,6030))
  call heltable([16,8,128], n3(:,13956), t3x128(:,:,6031))
  call heltable([16,8,128], n3(:,13957), t3x128(:,:,6032))
  call heltable([16,8,128], n3(:,13958), t3x128(:,:,6033))
  call heltable([16,8,128], n3(:,13959), t3x128(:,:,6034))
  call heltable([8,16,128], n3(:,13960), t3x128(:,:,6035))
  call heltable([8,16,128], n3(:,13961), t3x128(:,:,6036))
  call heltable([8,16,128], n3(:,13962), t3x128(:,:,6037))
  call heltable([8,16,128], n3(:,13963), t3x128(:,:,6038))
  call heltable([8,16,128], n3(:,13964), t3x128(:,:,6039))
  call heltable([8,16,128], n3(:,13965), t3x128(:,:,6040))
  call heltable([8,16,128], n3(:,13966), t3x128(:,:,6041))
  call heltable([8,16,128], n3(:,13967), t3x128(:,:,6042))
  call heltable([8,16,128], n3(:,13968), t3x128(:,:,6043))
  call heltable([8,16,128], n3(:,13969), t3x128(:,:,6044))
  call heltable([8,16,128], n3(:,13970), t3x128(:,:,6045))
  call heltable([8,16,128], n3(:,13971), t3x128(:,:,6046))
  call heltable([8,16,128], n3(:,13972), t3x128(:,:,6047))
  call heltable([8,16,128], n3(:,13973), t3x128(:,:,6048))
  call heltable([8,16,128], n3(:,13974), t3x128(:,:,6049))
  call heltable([8,16,128], n3(:,13975), t3x128(:,:,6050))
  call heltable([16,8,128], n3(:,13976), t3x128(:,:,6051))
  call heltable([16,8,128], n3(:,13977), t3x128(:,:,6052))
  call heltable([16,8,128], n3(:,13978), t3x128(:,:,6053))
  call heltable([16,8,128], n3(:,13979), t3x128(:,:,6054))
  call heltable([16,8,128], n3(:,13980), t3x128(:,:,6055))
  call heltable([16,8,128], n3(:,13981), t3x128(:,:,6056))
  call heltable([16,8,128], n3(:,13982), t3x128(:,:,6057))
  call heltable([16,8,128], n3(:,13983), t3x128(:,:,6058))
  call heltable([16,8,128], n3(:,13984), t3x128(:,:,6059))
  call heltable([16,8,128], n3(:,13985), t3x128(:,:,6060))
  call heltable([16,8,128], n3(:,13986), t3x128(:,:,6061))
  call heltable([16,8,128], n3(:,13987), t3x128(:,:,6062))
  call heltable([16,8,128], n3(:,13988), t3x128(:,:,6063))
  call heltable([16,8,128], n3(:,13989), t3x128(:,:,6064))
  call heltable([16,8,128], n3(:,13990), t3x128(:,:,6065))
  call heltable([16,8,128], n3(:,13991), t3x128(:,:,6066))
  call heltable([16,8,128], n3(:,13992), t3x128(:,:,6067))
  call heltable([16,8,128], n3(:,13993), t3x128(:,:,6068))
  call heltable([16,8,128], n3(:,13994), t3x128(:,:,6069))
  call heltable([16,8,128], n3(:,13995), t3x128(:,:,6070))
  call heltable([16,8,128], n3(:,13996), t3x128(:,:,6071))
  call heltable([16,8,128], n3(:,13997), t3x128(:,:,6072))
  call heltable([16,8,128], n3(:,13998), t3x128(:,:,6073))
  call heltable([16,8,128], n3(:,13999), t3x128(:,:,6074))
  call heltable([16,8,128], n3(:,14000), t3x128(:,:,6075))
  call heltable([16,8,128], n3(:,14001), t3x128(:,:,6076))
  call heltable([16,8,128], n3(:,14002), t3x128(:,:,6077))
  call heltable([16,8,128], n3(:,14003), t3x128(:,:,6078))
  call heltable([16,8,128], n3(:,14004), t3x128(:,:,6079))
  call heltable([16,8,128], n3(:,14005), t3x128(:,:,6080))
  call heltable([16,8,128], n3(:,14006), t3x128(:,:,6081))
  call heltable([16,8,128], n3(:,14007), t3x128(:,:,6082))
  call heltable([8,16,128], n3(:,14008), t3x128(:,:,6083))
  call heltable([8,16,128], n3(:,14009), t3x128(:,:,6084))
  call heltable([8,16,128], n3(:,14010), t3x128(:,:,6085))
  call heltable([8,16,128], n3(:,14011), t3x128(:,:,6086))
  call heltable([8,16,128], n3(:,14012), t3x128(:,:,6087))
  call heltable([8,16,128], n3(:,14013), t3x128(:,:,6088))
  call heltable([8,16,128], n3(:,14014), t3x128(:,:,6089))
  call heltable([8,16,128], n3(:,14015), t3x128(:,:,6090))
  call heltable([8,16,128], n3(:,14016), t3x128(:,:,6091))
  call heltable([8,16,128], n3(:,14017), t3x128(:,:,6092))
  call heltable([8,16,128], n3(:,14018), t3x128(:,:,6093))
  call heltable([8,16,128], n3(:,14019), t3x128(:,:,6094))
  call heltable([8,16,128], n3(:,14020), t3x128(:,:,6095))
  call heltable([8,16,128], n3(:,14021), t3x128(:,:,6096))
  call heltable([8,16,128], n3(:,14022), t3x128(:,:,6097))
  call heltable([8,16,128], n3(:,14023), t3x128(:,:,6098))
  call heltable([8,16,128], n3(:,14024), t3x128(:,:,6099))
  call heltable([8,16,128], n3(:,14025), t3x128(:,:,6100))
  call heltable([8,16,128], n3(:,14026), t3x128(:,:,6101))
  call heltable([8,16,128], n3(:,14027), t3x128(:,:,6102))
  call heltable([8,16,128], n3(:,14028), t3x128(:,:,6103))
  call heltable([8,16,128], n3(:,14029), t3x128(:,:,6104))
  call heltable([8,16,128], n3(:,14030), t3x128(:,:,6105))
  call heltable([8,16,128], n3(:,14031), t3x128(:,:,6106))
  call heltable([8,16,128], n3(:,14032), t3x128(:,:,6107))
  call heltable([8,16,128], n3(:,14033), t3x128(:,:,6108))
  call heltable([8,16,128], n3(:,14034), t3x128(:,:,6109))
  call heltable([8,16,128], n3(:,14035), t3x128(:,:,6110))
  call heltable([8,16,128], n3(:,14036), t3x128(:,:,6111))
  call heltable([8,16,128], n3(:,14037), t3x128(:,:,6112))
  call heltable([8,16,128], n3(:,14038), t3x128(:,:,6113))
  call heltable([8,16,128], n3(:,14039), t3x128(:,:,6114))
  call heltable([8,16,128], n3(:,14040), t3x128(:,:,6115))
  call heltable([8,16,128], n3(:,14041), t3x128(:,:,6116))
  call heltable([8,16,128], n3(:,14042), t3x128(:,:,6117))
  call heltable([8,16,128], n3(:,14043), t3x128(:,:,6118))
  call heltable([8,16,128], n3(:,14044), t3x128(:,:,6119))
  call heltable([8,16,128], n3(:,14045), t3x128(:,:,6120))
  call heltable([8,16,128], n3(:,14046), t3x128(:,:,6121))
  call heltable([8,16,128], n3(:,14047), t3x128(:,:,6122))
  call heltable([8,16,128], n3(:,14048), t3x128(:,:,6123))
  call heltable([8,16,128], n3(:,14049), t3x128(:,:,6124))
  call heltable([8,16,128], n3(:,14050), t3x128(:,:,6125))
  call heltable([8,16,128], n3(:,14051), t3x128(:,:,6126))
  call heltable([8,16,128], n3(:,14052), t3x128(:,:,6127))
  call heltable([8,16,128], n3(:,14053), t3x128(:,:,6128))
  call heltable([8,16,128], n3(:,14054), t3x128(:,:,6129))
  call heltable([8,16,128], n3(:,14055), t3x128(:,:,6130))
  call heltable([8,16,128], n3(:,14056), t3x128(:,:,6131))
  call heltable([8,16,128], n3(:,14057), t3x128(:,:,6132))
  call heltable([8,16,128], n3(:,14058), t3x128(:,:,6133))
  call heltable([8,16,128], n3(:,14059), t3x128(:,:,6134))
  call heltable([8,16,128], n3(:,14060), t3x128(:,:,6135))
  call heltable([8,16,128], n3(:,14061), t3x128(:,:,6136))
  call heltable([8,16,128], n3(:,14062), t3x128(:,:,6137))
  call heltable([8,16,128], n3(:,14063), t3x128(:,:,6138))
  call heltable([8,16,128], n3(:,14064), t3x128(:,:,6139))
  call heltable([8,16,128], n3(:,14065), t3x128(:,:,6140))
  call heltable([8,16,128], n3(:,14066), t3x128(:,:,6141))
  call heltable([8,16,128], n3(:,14067), t3x128(:,:,6142))
  call heltable([8,16,128], n3(:,14068), t3x128(:,:,6143))
  call heltable([8,16,128], n3(:,14069), t3x128(:,:,6144))
  call heltable([8,16,128], n3(:,14070), t3x128(:,:,6145))
  call heltable([8,16,128], n3(:,14071), t3x128(:,:,6146))
  call heltable([16,8,128], n3(:,14072), t3x128(:,:,6147))
  call heltable([16,8,128], n3(:,14073), t3x128(:,:,6148))
  call heltable([16,8,128], n3(:,14074), t3x128(:,:,6149))
  call heltable([16,8,128], n3(:,14075), t3x128(:,:,6150))
  call heltable([16,8,128], n3(:,14076), t3x128(:,:,6151))
  call heltable([16,8,128], n3(:,14077), t3x128(:,:,6152))
  call heltable([16,8,128], n3(:,14078), t3x128(:,:,6153))
  call heltable([16,8,128], n3(:,14079), t3x128(:,:,6154))
  call heltable([16,8,128], n3(:,14080), t3x128(:,:,6155))
  call heltable([16,8,128], n3(:,14081), t3x128(:,:,6156))
  call heltable([16,8,128], n3(:,14082), t3x128(:,:,6157))
  call heltable([16,8,128], n3(:,14083), t3x128(:,:,6158))
  call heltable([16,8,128], n3(:,14084), t3x128(:,:,6159))
  call heltable([16,8,128], n3(:,14085), t3x128(:,:,6160))
  call heltable([16,8,128], n3(:,14086), t3x128(:,:,6161))
  call heltable([16,8,128], n3(:,14087), t3x128(:,:,6162))
  call heltable([8,16,128], n3(:,14088), t3x128(:,:,6163))
  call heltable([8,16,128], n3(:,14089), t3x128(:,:,6164))
  call heltable([8,16,128], n3(:,14090), t3x128(:,:,6165))
  call heltable([8,16,128], n3(:,14091), t3x128(:,:,6166))
  call heltable([8,16,128], n3(:,14092), t3x128(:,:,6167))
  call heltable([8,16,128], n3(:,14093), t3x128(:,:,6168))
  call heltable([8,16,128], n3(:,14094), t3x128(:,:,6169))
  call heltable([8,16,128], n3(:,14095), t3x128(:,:,6170))
  call heltable([8,16,128], n3(:,14096), t3x128(:,:,6171))
  call heltable([8,16,128], n3(:,14097), t3x128(:,:,6172))
  call heltable([8,16,128], n3(:,14098), t3x128(:,:,6173))
  call heltable([8,16,128], n3(:,14099), t3x128(:,:,6174))
  call heltable([8,16,128], n3(:,14100), t3x128(:,:,6175))
  call heltable([8,16,128], n3(:,14101), t3x128(:,:,6176))
  call heltable([8,16,128], n3(:,14102), t3x128(:,:,6177))
  call heltable([8,16,128], n3(:,14103), t3x128(:,:,6178))
  call heltable([8,16,128], n3(:,14104), t3x128(:,:,6179))
  call heltable([16,8,128], n3(:,14105), t3x128(:,:,6180))
  call heltable([8,16,128], n3(:,14106), t3x128(:,:,6181))
  call heltable([8,16,128], n3(:,14107), t3x128(:,:,6182))
  call heltable([16,8,128], n3(:,14108), t3x128(:,:,6183))
  call heltable([16,8,128], n3(:,14109), t3x128(:,:,6184))
  call heltable([16,8,128], n3(:,14110), t3x128(:,:,6185))
  call heltable([16,8,128], n3(:,14111), t3x128(:,:,6186))
  call heltable([8,16,128], n3(:,14112), t3x128(:,:,6187))
  call heltable([8,16,128], n3(:,14113), t3x128(:,:,6188))
  call heltable([8,16,128], n3(:,14114), t3x128(:,:,6189))
  call heltable([8,16,128], n3(:,14115), t3x128(:,:,6190))
  call heltable([8,16,128], n3(:,14116), t3x128(:,:,6191))
  call heltable([8,16,128], n3(:,14117), t3x128(:,:,6192))
  call heltable([8,16,128], n3(:,14118), t3x128(:,:,6193))
  call heltable([8,16,128], n3(:,14119), t3x128(:,:,6194))
  call heltable([16,8,128], n3(:,14120), t3x128(:,:,6195))
  call heltable([16,8,128], n3(:,14121), t3x128(:,:,6196))
  call heltable([16,8,128], n3(:,14122), t3x128(:,:,6197))
  call heltable([16,8,128], n3(:,14123), t3x128(:,:,6198))
  call heltable([16,8,128], n3(:,14124), t3x128(:,:,6199))
  call heltable([16,8,128], n3(:,14125), t3x128(:,:,6200))
  call heltable([16,8,128], n3(:,14126), t3x128(:,:,6201))
  call heltable([16,8,128], n3(:,14127), t3x128(:,:,6202))
  call heltable([16,8,128], n3(:,14128), t3x128(:,:,6203))
  call heltable([16,8,128], n3(:,14129), t3x128(:,:,6204))
  call heltable([16,8,128], n3(:,14130), t3x128(:,:,6205))
  call heltable([16,8,128], n3(:,14131), t3x128(:,:,6206))
  call heltable([16,8,128], n3(:,14132), t3x128(:,:,6207))
  call heltable([16,8,128], n3(:,14133), t3x128(:,:,6208))
  call heltable([16,8,128], n3(:,14134), t3x128(:,:,6209))
  call heltable([16,8,128], n3(:,14135), t3x128(:,:,6210))
  call heltable([16,8,128], n3(:,14136), t3x128(:,:,6211))
  call heltable([16,8,128], n3(:,14137), t3x128(:,:,6212))
  call heltable([16,8,128], n3(:,14138), t3x128(:,:,6213))
  call heltable([16,8,128], n3(:,14139), t3x128(:,:,6214))
  call heltable([16,8,128], n3(:,14140), t3x128(:,:,6215))
  call heltable([16,8,128], n3(:,14141), t3x128(:,:,6216))
  call heltable([16,8,128], n3(:,14142), t3x128(:,:,6217))
  call heltable([16,8,128], n3(:,14143), t3x128(:,:,6218))
  call heltable([16,8,128], n3(:,14144), t3x128(:,:,6219))
  call heltable([16,8,128], n3(:,14145), t3x128(:,:,6220))
  call heltable([16,8,128], n3(:,14146), t3x128(:,:,6221))
  call heltable([16,8,128], n3(:,14147), t3x128(:,:,6222))
  call heltable([16,8,128], n3(:,14148), t3x128(:,:,6223))
  call heltable([16,8,128], n3(:,14149), t3x128(:,:,6224))
  call heltable([16,8,128], n3(:,14150), t3x128(:,:,6225))
  call heltable([16,8,128], n3(:,14151), t3x128(:,:,6226))
  call heltable([16,8,128], n3(:,14152), t3x128(:,:,6227))
  call heltable([16,8,128], n3(:,14153), t3x128(:,:,6228))
  call heltable([16,8,128], n3(:,14154), t3x128(:,:,6229))
  call heltable([16,8,128], n3(:,14155), t3x128(:,:,6230))
  call heltable([16,8,128], n3(:,14156), t3x128(:,:,6231))
  call heltable([16,8,128], n3(:,14157), t3x128(:,:,6232))
  call heltable([16,8,128], n3(:,14158), t3x128(:,:,6233))
  call heltable([16,8,128], n3(:,14159), t3x128(:,:,6234))
  call heltable([16,8,128], n3(:,14160), t3x128(:,:,6235))
  call heltable([16,8,128], n3(:,14161), t3x128(:,:,6236))
  call heltable([16,8,128], n3(:,14162), t3x128(:,:,6237))
  call heltable([16,8,128], n3(:,14163), t3x128(:,:,6238))
  call heltable([16,8,128], n3(:,14164), t3x128(:,:,6239))
  call heltable([16,8,128], n3(:,14165), t3x128(:,:,6240))
  call heltable([16,8,128], n3(:,14166), t3x128(:,:,6241))
  call heltable([16,8,128], n3(:,14167), t3x128(:,:,6242))
  call heltable([16,8,128], n3(:,14168), t3x128(:,:,6243))
  call heltable([16,8,128], n3(:,14169), t3x128(:,:,6244))
  call heltable([16,8,128], n3(:,14170), t3x128(:,:,6245))
  call heltable([16,8,128], n3(:,14171), t3x128(:,:,6246))
  call heltable([16,8,128], n3(:,14172), t3x128(:,:,6247))
  call heltable([16,8,128], n3(:,14173), t3x128(:,:,6248))
  call heltable([16,8,128], n3(:,14174), t3x128(:,:,6249))
  call heltable([16,8,128], n3(:,14175), t3x128(:,:,6250))
  call heltable([16,8,128], n3(:,14176), t3x128(:,:,6251))
  call heltable([16,8,128], n3(:,14177), t3x128(:,:,6252))
  call heltable([16,8,128], n3(:,14178), t3x128(:,:,6253))
  call heltable([16,8,128], n3(:,14179), t3x128(:,:,6254))
  call heltable([16,8,128], n3(:,14180), t3x128(:,:,6255))
  call heltable([8,16,128], n3(:,14181), t3x128(:,:,6256))
  call heltable([8,16,128], n3(:,14182), t3x128(:,:,6257))
  call heltable([8,16,128], n3(:,14183), t3x128(:,:,6258))
  call heltable([8,16,128], n3(:,14184), t3x128(:,:,6259))
  call heltable([8,16,128], n3(:,14185), t3x128(:,:,6260))
  call heltable([8,16,128], n3(:,14186), t3x128(:,:,6261))
  call heltable([8,16,128], n3(:,14187), t3x128(:,:,6262))
  call heltable([8,16,128], n3(:,14188), t3x128(:,:,6263))
  call heltable([8,16,128], n3(:,14189), t3x128(:,:,6264))
  call heltable([8,16,128], n3(:,14190), t3x128(:,:,6265))
  call heltable([8,16,128], n3(:,14191), t3x128(:,:,6266))
  call heltable([8,16,128], n3(:,14192), t3x128(:,:,6267))
  call heltable([8,16,128], n3(:,14193), t3x128(:,:,6268))
  call heltable([8,16,128], n3(:,14194), t3x128(:,:,6269))
  call heltable([8,16,128], n3(:,14195), t3x128(:,:,6270))
  call heltable([8,16,128], n3(:,14196), t3x128(:,:,6271))
  call heltable([8,16,128], n3(:,14197), t3x128(:,:,6272))
  call heltable([8,16,128], n3(:,14198), t3x128(:,:,6273))
  call heltable([8,16,128], n3(:,14199), t3x128(:,:,6274))
  call heltable([8,16,128], n3(:,14200), t3x128(:,:,6275))
  call heltable([8,16,128], n3(:,14201), t3x128(:,:,6276))
  call heltable([8,16,128], n3(:,14202), t3x128(:,:,6277))
  call heltable([8,16,128], n3(:,14203), t3x128(:,:,6278))
  call heltable([8,16,128], n3(:,14204), t3x128(:,:,6279))
  call heltable([8,16,128], n3(:,14205), t3x128(:,:,6280))
  call heltable([8,16,128], n3(:,14206), t3x128(:,:,6281))
  call heltable([8,16,128], n3(:,14207), t3x128(:,:,6282))
  call heltable([8,16,128], n3(:,14208), t3x128(:,:,6283))
  call heltable([8,16,128], n3(:,14209), t3x128(:,:,6284))
  call heltable([8,16,128], n3(:,14210), t3x128(:,:,6285))
  call heltable([8,16,128], n3(:,14211), t3x128(:,:,6286))
  call heltable([8,16,128], n3(:,14212), t3x128(:,:,6287))
  call heltable([16,8,128], n3(:,14213), t3x128(:,:,6288))
  call heltable([16,8,128], n3(:,14214), t3x128(:,:,6289))
  call heltable([16,8,128], n3(:,14215), t3x128(:,:,6290))
  call heltable([16,8,128], n3(:,14216), t3x128(:,:,6291))
  call heltable([16,8,128], n3(:,14217), t3x128(:,:,6292))
  call heltable([16,8,128], n3(:,14218), t3x128(:,:,6293))
  call heltable([16,8,128], n3(:,14219), t3x128(:,:,6294))
  call heltable([16,8,128], n3(:,14220), t3x128(:,:,6295))
  call heltable([16,8,128], n3(:,14221), t3x128(:,:,6296))
  call heltable([16,8,128], n3(:,14222), t3x128(:,:,6297))
  call heltable([16,8,128], n3(:,14223), t3x128(:,:,6298))
  call heltable([16,8,128], n3(:,14224), t3x128(:,:,6299))
  call heltable([16,8,128], n3(:,14225), t3x128(:,:,6300))
  call heltable([8,16,128], n3(:,14226), t3x128(:,:,6301))
  call heltable([8,16,128], n3(:,14227), t3x128(:,:,6302))
  call heltable([8,16,128], n3(:,14228), t3x128(:,:,6303))
  call heltable([8,16,128], n3(:,14229), t3x128(:,:,6304))
  call heltable([8,16,128], n3(:,14230), t3x128(:,:,6305))
  call heltable([8,16,128], n3(:,14231), t3x128(:,:,6306))
  call heltable([8,16,128], n3(:,14232), t3x128(:,:,6307))
  call heltable([8,16,128], n3(:,14233), t3x128(:,:,6308))
  call heltable([8,16,128], n3(:,14234), t3x128(:,:,6309))
  call heltable([8,16,128], n3(:,14235), t3x128(:,:,6310))
  call heltable([8,16,128], n3(:,14236), t3x128(:,:,6311))
  call heltable([8,16,128], n3(:,14237), t3x128(:,:,6312))
  call heltable([8,16,128], n3(:,14238), t3x128(:,:,6313))
  call heltable([8,16,128], n3(:,14239), t3x128(:,:,6314))
  call heltable([8,16,128], n3(:,14240), t3x128(:,:,6315))
  call heltable([8,16,128], n3(:,14241), t3x128(:,:,6316))
  call heltable([8,16,128], n3(:,14242), t3x128(:,:,6317))
  call heltable([8,16,128], n3(:,14243), t3x128(:,:,6318))
  call heltable([8,16,128], n3(:,14244), t3x128(:,:,6319))
  call heltable([8,16,128], n3(:,14245), t3x128(:,:,6320))
  call heltable([8,16,128], n3(:,14246), t3x128(:,:,6321))
  call heltable([8,16,128], n3(:,14247), t3x128(:,:,6322))
  call heltable([8,16,128], n3(:,14248), t3x128(:,:,6323))
  call heltable([8,16,128], n3(:,14249), t3x128(:,:,6324))
  call heltable([8,16,128], n3(:,14250), t3x128(:,:,6325))
  call heltable([8,16,128], n3(:,14251), t3x128(:,:,6326))
  call heltable([8,16,128], n3(:,14252), t3x128(:,:,6327))
  call heltable([8,16,128], n3(:,14253), t3x128(:,:,6328))
  call heltable([8,16,128], n3(:,14254), t3x128(:,:,6329))
  call heltable([8,16,128], n3(:,14255), t3x128(:,:,6330))
  call heltable([8,16,128], n3(:,14256), t3x128(:,:,6331))
  call heltable([8,16,128], n3(:,14257), t3x128(:,:,6332))
  call heltable([8,16,128], n3(:,14258), t3x128(:,:,6333))
  call heltable([8,16,128], n3(:,14259), t3x128(:,:,6334))
  call heltable([8,16,128], n3(:,14260), t3x128(:,:,6335))
  call heltable([8,16,128], n3(:,14261), t3x128(:,:,6336))
  call heltable([8,16,128], n3(:,14262), t3x128(:,:,6337))
  call heltable([8,16,128], n3(:,14263), t3x128(:,:,6338))
  call heltable([8,16,128], n3(:,14264), t3x128(:,:,6339))
  call heltable([8,16,128], n3(:,14265), t3x128(:,:,6340))
  call heltable([8,16,128], n3(:,14266), t3x128(:,:,6341))
  call heltable([8,16,128], n3(:,14267), t3x128(:,:,6342))
  call heltable([8,16,128], n3(:,14268), t3x128(:,:,6343))
  call heltable([8,16,128], n3(:,14269), t3x128(:,:,6344))
  call heltable([8,16,128], n3(:,14270), t3x128(:,:,6345))
  call heltable([8,16,128], n3(:,14271), t3x128(:,:,6346))
  call heltable([8,16,128], n3(:,14272), t3x128(:,:,6347))
  call heltable([8,16,128], n3(:,14273), t3x128(:,:,6348))
  call heltable([8,16,128], n3(:,14274), t3x128(:,:,6349))
  call heltable([8,16,128], n3(:,14275), t3x128(:,:,6350))
  call heltable([8,16,128], n3(:,14276), t3x128(:,:,6351))
  call heltable([8,16,128], n3(:,14277), t3x128(:,:,6352))
  call heltable([8,16,128], n3(:,14278), t3x128(:,:,6353))
  call heltable([8,16,128], n3(:,14279), t3x128(:,:,6354))
  call heltable([8,16,128], n3(:,14280), t3x128(:,:,6355))
  call heltable([8,16,128], n3(:,14281), t3x128(:,:,6356))
  call heltable([8,16,128], n3(:,14282), t3x128(:,:,6357))
  call heltable([8,16,128], n3(:,14283), t3x128(:,:,6358))
  call heltable([8,16,128], n3(:,14284), t3x128(:,:,6359))
  call heltable([8,16,128], n3(:,14285), t3x128(:,:,6360))
  call heltable([8,16,128], n3(:,14286), t3x128(:,:,6361))
  call heltable([8,16,128], n3(:,14287), t3x128(:,:,6362))
  call heltable([8,16,128], n3(:,14288), t3x128(:,:,6363))
  call heltable([8,16,128], n3(:,14289), t3x128(:,:,6364))
  call heltable([8,16,128], n3(:,14290), t3x128(:,:,6365))
  call heltable([8,16,128], n3(:,14291), t3x128(:,:,6366))
  call heltable([8,16,128], n3(:,14292), t3x128(:,:,6367))
  call heltable([8,16,128], n3(:,14293), t3x128(:,:,6368))
  call heltable([8,16,128], n3(:,14294), t3x128(:,:,6369))
  call heltable([8,16,128], n3(:,14295), t3x128(:,:,6370))
  call heltable([8,16,128], n3(:,14296), t3x128(:,:,6371))
  call heltable([8,16,128], n3(:,14297), t3x128(:,:,6372))
  call heltable([8,16,128], n3(:,14298), t3x128(:,:,6373))
  call heltable([8,16,128], n3(:,14299), t3x128(:,:,6374))
  call heltable([8,16,128], n3(:,14300), t3x128(:,:,6375))
  call heltable([8,16,128], n3(:,14301), t3x128(:,:,6376))
  call heltable([8,16,128], n3(:,14302), t3x128(:,:,6377))
  call heltable([8,16,128], n3(:,14303), t3x128(:,:,6378))
  call heltable([8,16,128], n3(:,14304), t3x128(:,:,6379))
  call heltable([8,16,128], n3(:,14305), t3x128(:,:,6380))
  call heltable([8,16,128], n3(:,14306), t3x128(:,:,6381))
  call heltable([8,16,128], n3(:,14307), t3x128(:,:,6382))
  call heltable([8,16,128], n3(:,14308), t3x128(:,:,6383))
  call heltable([8,16,128], n3(:,14309), t3x128(:,:,6384))
  call heltable([8,16,128], n3(:,14310), t3x128(:,:,6385))
  call heltable([8,16,128], n3(:,14311), t3x128(:,:,6386))
  call heltable([8,16,128], n3(:,14312), t3x128(:,:,6387))
  call heltable([8,16,128], n3(:,14313), t3x128(:,:,6388))
  call heltable([8,16,128], n3(:,14314), t3x128(:,:,6389))
  call heltable([8,16,128], n3(:,14315), t3x128(:,:,6390))
  call heltable([8,16,128], n3(:,14316), t3x128(:,:,6391))
  call heltable([8,16,128], n3(:,14317), t3x128(:,:,6392))
  call heltable([8,16,128], n3(:,14318), t3x128(:,:,6393))
  call heltable([8,16,128], n3(:,14319), t3x128(:,:,6394))
  call heltable([8,16,128], n3(:,14320), t3x128(:,:,6395))
  call heltable([8,16,128], n3(:,14321), t3x128(:,:,6396))
  call heltable([8,16,128], n3(:,14322), t3x128(:,:,6397))
  call heltable([8,16,128], n3(:,14323), t3x128(:,:,6398))
  call heltable([8,16,128], n3(:,14324), t3x128(:,:,6399))
  call heltable([8,16,128], n3(:,14325), t3x128(:,:,6400))
  call heltable([8,16,128], n3(:,14326), t3x128(:,:,6401))
  call heltable([8,16,128], n3(:,14327), t3x128(:,:,6402))
  call heltable([8,16,128], n3(:,14328), t3x128(:,:,6403))
  call heltable([8,16,128], n3(:,14329), t3x128(:,:,6404))
  call heltable([8,16,128], n3(:,14330), t3x128(:,:,6405))
  call heltable([8,16,128], n3(:,14331), t3x128(:,:,6406))
  call heltable([8,16,128], n3(:,14332), t3x128(:,:,6407))
  call heltable([8,16,128], n3(:,14333), t3x128(:,:,6408))
  call heltable([8,16,128], n3(:,14334), t3x128(:,:,6409))
  call heltable([8,16,128], n3(:,14335), t3x128(:,:,6410))
  call heltable([8,16,128], n3(:,14336), t3x128(:,:,6411))
  call heltable([8,16,128], n3(:,14337), t3x128(:,:,6412))
  call heltable([8,16,128], n3(:,14338), t3x128(:,:,6413))
  call heltable([8,16,128], n3(:,14339), t3x128(:,:,6414))
  call heltable([8,16,128], n3(:,14340), t3x128(:,:,6415))
  call heltable([8,16,128], n3(:,14341), t3x128(:,:,6416))
  call heltable([8,16,128], n3(:,14342), t3x128(:,:,6417))
  call heltable([8,16,128], n3(:,14343), t3x128(:,:,6418))
  call heltable([8,16,128], n3(:,14344), t3x128(:,:,6419))
  call heltable([8,16,128], n3(:,14345), t3x128(:,:,6420))
  call heltable([8,16,128], n3(:,14346), t3x128(:,:,6421))
  call heltable([8,16,128], n3(:,14347), t3x128(:,:,6422))
  call heltable([8,16,128], n3(:,14348), t3x128(:,:,6423))
  call heltable([8,16,128], n3(:,14349), t3x128(:,:,6424))
  call heltable([8,16,128], n3(:,14350), t3x128(:,:,6425))
  call heltable([8,16,128], n3(:,14351), t3x128(:,:,6426))
  call heltable([8,16,128], n3(:,14352), t3x128(:,:,6427))
  call heltable([8,16,128], n3(:,14353), t3x128(:,:,6428))
  call heltable([8,16,128], n3(:,14354), t3x128(:,:,6429))
  call heltable([8,16,128], n3(:,14355), t3x128(:,:,6430))
  call heltable([8,16,128], n3(:,14356), t3x128(:,:,6431))
  call heltable([8,16,128], n3(:,14357), t3x128(:,:,6432))
  call heltable([8,16,128], n3(:,14358), t3x128(:,:,6433))
  call heltable([8,16,128], n3(:,14359), t3x128(:,:,6434))
  call heltable([8,16,128], n3(:,14360), t3x128(:,:,6435))
  call heltable([8,16,128], n3(:,14361), t3x128(:,:,6436))
  call heltable([8,16,128], n3(:,14362), t3x128(:,:,6437))
  call heltable([8,16,128], n3(:,14363), t3x128(:,:,6438))
  call heltable([8,16,128], n3(:,14364), t3x128(:,:,6439))
  call heltable([8,16,128], n3(:,14365), t3x128(:,:,6440))
  call heltable([8,16,128], n3(:,14366), t3x128(:,:,6441))
  call heltable([8,16,128], n3(:,14367), t3x128(:,:,6442))
  call heltable([8,16,128], n3(:,14368), t3x128(:,:,6443))
  call heltable([8,16,128], n3(:,14369), t3x128(:,:,6444))
  call heltable([16,8,128], n3(:,14370), t3x128(:,:,6445))
  call heltable([16,8,128], n3(:,14371), t3x128(:,:,6446))
  call heltable([16,8,128], n3(:,14372), t3x128(:,:,6447))
  call heltable([16,8,128], n3(:,14373), t3x128(:,:,6448))
  call heltable([16,8,128], n3(:,14374), t3x128(:,:,6449))
  call heltable([16,8,128], n3(:,14375), t3x128(:,:,6450))
  call heltable([16,8,128], n3(:,14376), t3x128(:,:,6451))
  call heltable([16,8,128], n3(:,14377), t3x128(:,:,6452))
  call heltable([16,8,128], n3(:,14378), t3x128(:,:,6453))
  call heltable([16,8,128], n3(:,14379), t3x128(:,:,6454))
  call heltable([16,8,128], n3(:,14380), t3x128(:,:,6455))
  call heltable([16,8,128], n3(:,14381), t3x128(:,:,6456))
  call heltable([16,8,128], n3(:,14382), t3x128(:,:,6457))
  call heltable([16,8,128], n3(:,14383), t3x128(:,:,6458))
  call heltable([16,8,128], n3(:,14384), t3x128(:,:,6459))
  call heltable([16,8,128], n3(:,14385), t3x128(:,:,6460))
  call heltable([16,8,128], n3(:,14386), t3x128(:,:,6461))
  call heltable([16,8,128], n3(:,14387), t3x128(:,:,6462))
  call heltable([16,8,128], n3(:,14388), t3x128(:,:,6463))
  call heltable([16,8,128], n3(:,14389), t3x128(:,:,6464))
  call heltable([16,8,128], n3(:,14390), t3x128(:,:,6465))
  call heltable([16,8,128], n3(:,14391), t3x128(:,:,6466))
  call heltable([16,8,128], n3(:,14392), t3x128(:,:,6467))
  call heltable([16,8,128], n3(:,14393), t3x128(:,:,6468))
  call heltable([16,8,128], n3(:,14394), t3x128(:,:,6469))
  call heltable([16,8,128], n3(:,14395), t3x128(:,:,6470))
  call heltable([16,8,128], n3(:,14396), t3x128(:,:,6471))
  call heltable([16,8,128], n3(:,14397), t3x128(:,:,6472))
  call heltable([16,8,128], n3(:,14398), t3x128(:,:,6473))
  call heltable([16,8,128], n3(:,14399), t3x128(:,:,6474))
  call heltable([16,8,128], n3(:,14400), t3x128(:,:,6475))
  call heltable([16,8,128], n3(:,14401), t3x128(:,:,6476))
  call heltable([16,8,128], n3(:,14402), t3x128(:,:,6477))
  call heltable([16,8,128], n3(:,14403), t3x128(:,:,6478))
  call heltable([16,8,128], n3(:,14404), t3x128(:,:,6479))
  call heltable([16,8,128], n3(:,14405), t3x128(:,:,6480))
  call heltable([16,8,128], n3(:,14406), t3x128(:,:,6481))
  call heltable([16,8,128], n3(:,14407), t3x128(:,:,6482))
  call heltable([16,8,128], n3(:,14408), t3x128(:,:,6483))
  call heltable([16,8,128], n3(:,14409), t3x128(:,:,6484))
  call heltable([16,8,128], n3(:,14410), t3x128(:,:,6485))
  call heltable([16,8,128], n3(:,14411), t3x128(:,:,6486))
  call heltable([16,8,128], n3(:,14412), t3x128(:,:,6487))
  call heltable([16,8,128], n3(:,14413), t3x128(:,:,6488))
  call heltable([16,8,128], n3(:,14414), t3x128(:,:,6489))
  call heltable([16,8,128], n3(:,14415), t3x128(:,:,6490))
  call heltable([16,8,128], n3(:,14416), t3x128(:,:,6491))
  call heltable([16,8,128], n3(:,14417), t3x128(:,:,6492))
  call heltable([16,8,128], n3(:,14418), t3x128(:,:,6493))
  call heltable([16,8,128], n3(:,14419), t3x128(:,:,6494))
  call heltable([16,8,128], n3(:,14420), t3x128(:,:,6495))
  call heltable([16,8,128], n3(:,14421), t3x128(:,:,6496))
  call heltable([16,8,128], n3(:,14422), t3x128(:,:,6497))
  call heltable([16,8,128], n3(:,14423), t3x128(:,:,6498))
  call heltable([16,8,128], n3(:,14424), t3x128(:,:,6499))
  call heltable([16,8,128], n3(:,14425), t3x128(:,:,6500))
  call heltable([16,8,128], n3(:,14426), t3x128(:,:,6501))
  call heltable([16,8,128], n3(:,14427), t3x128(:,:,6502))
  call heltable([16,8,128], n3(:,14428), t3x128(:,:,6503))
  call heltable([16,8,128], n3(:,14429), t3x128(:,:,6504))
  call heltable([16,8,128], n3(:,14430), t3x128(:,:,6505))
  call heltable([8,16,128], n3(:,14431), t3x128(:,:,6506))
  call heltable([8,16,128], n3(:,14432), t3x128(:,:,6507))
  call heltable([8,16,128], n3(:,14433), t3x128(:,:,6508))
  call heltable([8,16,128], n3(:,14434), t3x128(:,:,6509))
  call heltable([8,16,128], n3(:,14435), t3x128(:,:,6510))
  call heltable([8,16,128], n3(:,14436), t3x128(:,:,6511))
  call heltable([8,16,128], n3(:,14437), t3x128(:,:,6512))
  call heltable([8,16,128], n3(:,14438), t3x128(:,:,6513))
  call heltable([8,16,128], n3(:,14439), t3x128(:,:,6514))
  call heltable([8,16,128], n3(:,14440), t3x128(:,:,6515))
  call heltable([8,16,128], n3(:,14441), t3x128(:,:,6516))
  call heltable([8,16,128], n3(:,14442), t3x128(:,:,6517))
  call heltable([8,16,128], n3(:,14443), t3x128(:,:,6518))
  call heltable([8,16,128], n3(:,14444), t3x128(:,:,6519))
  call heltable([8,16,128], n3(:,14445), t3x128(:,:,6520))
  call heltable([8,16,128], n3(:,14446), t3x128(:,:,6521))
  call heltable([8,16,128], n3(:,14447), t3x128(:,:,6522))
  call heltable([8,16,128], n3(:,14448), t3x128(:,:,6523))
  call heltable([8,16,128], n3(:,14449), t3x128(:,:,6524))
  call heltable([8,16,128], n3(:,14450), t3x128(:,:,6525))
  call heltable([8,16,128], n3(:,14451), t3x128(:,:,6526))
  call heltable([8,16,128], n3(:,14452), t3x128(:,:,6527))
  call heltable([8,16,128], n3(:,14453), t3x128(:,:,6528))
  call heltable([8,16,128], n3(:,14454), t3x128(:,:,6529))
  call heltable([8,16,128], n3(:,14455), t3x128(:,:,6530))
  call heltable([8,16,128], n3(:,14456), t3x128(:,:,6531))
  call heltable([8,16,128], n3(:,14457), t3x128(:,:,6532))
  call heltable([8,16,128], n3(:,14458), t3x128(:,:,6533))
  call heltable([8,16,128], n3(:,14459), t3x128(:,:,6534))
  call heltable([8,16,128], n3(:,14460), t3x128(:,:,6535))
  call heltable([8,16,128], n3(:,14461), t3x128(:,:,6536))
  call heltable([8,16,128], n3(:,14462), t3x128(:,:,6537))
  call heltable([16,8,128], n3(:,14463), t3x128(:,:,6538))
  call heltable([16,8,128], n3(:,14464), t3x128(:,:,6539))
  call heltable([16,8,128], n3(:,14465), t3x128(:,:,6540))
  call heltable([16,8,128], n3(:,14466), t3x128(:,:,6541))
  call heltable([16,8,128], n3(:,14467), t3x128(:,:,6542))
  call heltable([16,8,128], n3(:,14468), t3x128(:,:,6543))
  call heltable([16,8,128], n3(:,14469), t3x128(:,:,6544))
  call heltable([16,8,128], n3(:,14470), t3x128(:,:,6545))
  call heltable([16,8,128], n3(:,14471), t3x128(:,:,6546))
  call heltable([16,8,128], n3(:,14472), t3x128(:,:,6547))
  call heltable([16,8,128], n3(:,14473), t3x128(:,:,6548))
  call heltable([16,8,128], n3(:,14474), t3x128(:,:,6549))
  call heltable([16,8,128], n3(:,14475), t3x128(:,:,6550))
  call heltable([8,16,128], n3(:,14476), t3x128(:,:,6551))
  call heltable([8,16,128], n3(:,14477), t3x128(:,:,6552))
  call heltable([8,16,128], n3(:,14478), t3x128(:,:,6553))
  call heltable([8,16,128], n3(:,14479), t3x128(:,:,6554))
  call heltable([8,16,128], n3(:,14480), t3x128(:,:,6555))
  call heltable([8,16,128], n3(:,14481), t3x128(:,:,6556))
  call heltable([8,16,128], n3(:,14482), t3x128(:,:,6557))
  call heltable([8,16,128], n3(:,14483), t3x128(:,:,6558))
  call heltable([8,16,128], n3(:,14484), t3x128(:,:,6559))
  call heltable([8,16,128], n3(:,14485), t3x128(:,:,6560))
  call heltable([8,16,128], n3(:,14486), t3x128(:,:,6561))
  call heltable([8,16,128], n3(:,14487), t3x128(:,:,6562))
  call heltable([8,16,128], n3(:,14488), t3x128(:,:,6563))
  call heltable([8,16,128], n3(:,14489), t3x128(:,:,6564))
  call heltable([8,16,128], n3(:,14490), t3x128(:,:,6565))
  call heltable([8,16,128], n3(:,14491), t3x128(:,:,6566))
  call heltable([8,16,128], n3(:,14492), t3x128(:,:,6567))
  call heltable([8,16,128], n3(:,14493), t3x128(:,:,6568))
  call heltable([8,16,128], n3(:,14494), t3x128(:,:,6569))
  call heltable([8,16,128], n3(:,14495), t3x128(:,:,6570))
  call heltable([8,16,128], n3(:,14496), t3x128(:,:,6571))
  call heltable([8,16,128], n3(:,14497), t3x128(:,:,6572))
  call heltable([8,16,128], n3(:,14498), t3x128(:,:,6573))
  call heltable([8,16,128], n3(:,14499), t3x128(:,:,6574))
  call heltable([8,16,128], n3(:,14500), t3x128(:,:,6575))
  call heltable([8,16,128], n3(:,14501), t3x128(:,:,6576))
  call heltable([8,16,128], n3(:,14502), t3x128(:,:,6577))
  call heltable([8,16,128], n3(:,14503), t3x128(:,:,6578))
  call heltable([8,16,128], n3(:,14504), t3x128(:,:,6579))
  call heltable([8,16,128], n3(:,14505), t3x128(:,:,6580))
  call heltable([8,16,128], n3(:,14506), t3x128(:,:,6581))
  call heltable([8,16,128], n3(:,14507), t3x128(:,:,6582))
  call heltable([8,16,128], n3(:,14508), t3x128(:,:,6583))
  call heltable([8,16,128], n3(:,14509), t3x128(:,:,6584))
  call heltable([8,16,128], n3(:,14510), t3x128(:,:,6585))
  call heltable([8,16,128], n3(:,14511), t3x128(:,:,6586))
  call heltable([8,16,128], n3(:,14512), t3x128(:,:,6587))
  call heltable([8,16,128], n3(:,14513), t3x128(:,:,6588))
  call heltable([8,16,128], n3(:,14514), t3x128(:,:,6589))
  call heltable([8,16,128], n3(:,14515), t3x128(:,:,6590))
  call heltable([8,16,128], n3(:,14516), t3x128(:,:,6591))
  call heltable([8,16,128], n3(:,14517), t3x128(:,:,6592))
  call heltable([8,16,128], n3(:,14518), t3x128(:,:,6593))
  call heltable([8,16,128], n3(:,14519), t3x128(:,:,6594))
  call heltable([8,16,128], n3(:,14520), t3x128(:,:,6595))
  call heltable([8,16,128], n3(:,14521), t3x128(:,:,6596))
  call heltable([8,16,128], n3(:,14522), t3x128(:,:,6597))
  call heltable([8,16,128], n3(:,14523), t3x128(:,:,6598))
  call heltable([8,16,128], n3(:,14524), t3x128(:,:,6599))
  call heltable([8,16,128], n3(:,14525), t3x128(:,:,6600))
  call heltable([8,16,128], n3(:,14526), t3x128(:,:,6601))
  call heltable([8,16,128], n3(:,14527), t3x128(:,:,6602))
  call heltable([8,16,128], n3(:,14528), t3x128(:,:,6603))
  call heltable([8,16,128], n3(:,14529), t3x128(:,:,6604))
  call heltable([8,16,128], n3(:,14530), t3x128(:,:,6605))
  call heltable([8,16,128], n3(:,14531), t3x128(:,:,6606))
  call heltable([8,16,128], n3(:,14532), t3x128(:,:,6607))
  call heltable([8,16,128], n3(:,14533), t3x128(:,:,6608))
  call heltable([8,16,128], n3(:,14534), t3x128(:,:,6609))
  call heltable([8,16,128], n3(:,14535), t3x128(:,:,6610))
  call heltable([8,16,128], n3(:,14536), t3x128(:,:,6611))
  call heltable([8,16,128], n3(:,14537), t3x128(:,:,6612))
  call heltable([8,16,128], n3(:,14538), t3x128(:,:,6613))
  call heltable([8,16,128], n3(:,14539), t3x128(:,:,6614))
  call heltable([8,16,128], n3(:,14540), t3x128(:,:,6615))
  call heltable([8,16,128], n3(:,14541), t3x128(:,:,6616))
  call heltable([8,16,128], n3(:,14542), t3x128(:,:,6617))
  call heltable([8,16,128], n3(:,14543), t3x128(:,:,6618))
  call heltable([8,16,128], n3(:,14544), t3x128(:,:,6619))
  call heltable([8,16,128], n3(:,14545), t3x128(:,:,6620))
  call heltable([8,16,128], n3(:,14546), t3x128(:,:,6621))
  call heltable([8,16,128], n3(:,14547), t3x128(:,:,6622))
  call heltable([8,16,128], n3(:,14548), t3x128(:,:,6623))
  call heltable([8,16,128], n3(:,14549), t3x128(:,:,6624))
  call heltable([8,16,128], n3(:,14550), t3x128(:,:,6625))
  call heltable([8,16,128], n3(:,14551), t3x128(:,:,6626))
  call heltable([8,16,128], n3(:,14552), t3x128(:,:,6627))
  call heltable([8,16,128], n3(:,14553), t3x128(:,:,6628))
  call heltable([8,16,128], n3(:,14554), t3x128(:,:,6629))
  call heltable([8,16,128], n3(:,14555), t3x128(:,:,6630))
  call heltable([8,16,128], n3(:,14556), t3x128(:,:,6631))
  call heltable([8,16,128], n3(:,14557), t3x128(:,:,6632))
  call heltable([8,16,128], n3(:,14558), t3x128(:,:,6633))
  call heltable([8,16,128], n3(:,14559), t3x128(:,:,6634))
  call heltable([8,16,128], n3(:,14560), t3x128(:,:,6635))
  call heltable([8,16,128], n3(:,14561), t3x128(:,:,6636))
  call heltable([8,16,128], n3(:,14562), t3x128(:,:,6637))
  call heltable([8,16,128], n3(:,14563), t3x128(:,:,6638))
  call heltable([8,16,128], n3(:,14564), t3x128(:,:,6639))
  call heltable([8,16,128], n3(:,14565), t3x128(:,:,6640))
  call heltable([8,16,128], n3(:,14566), t3x128(:,:,6641))
  call heltable([8,16,128], n3(:,14567), t3x128(:,:,6642))
  call heltable([8,16,128], n3(:,14568), t3x128(:,:,6643))
  call heltable([8,16,128], n3(:,14569), t3x128(:,:,6644))
  call heltable([8,16,128], n3(:,14570), t3x128(:,:,6645))
  call heltable([8,16,128], n3(:,14571), t3x128(:,:,6646))
  call heltable([8,16,128], n3(:,14572), t3x128(:,:,6647))
  call heltable([8,16,128], n3(:,14573), t3x128(:,:,6648))
  call heltable([8,16,128], n3(:,14574), t3x128(:,:,6649))
  call heltable([8,16,128], n3(:,14575), t3x128(:,:,6650))
  call heltable([8,16,128], n3(:,14576), t3x128(:,:,6651))
  call heltable([8,16,128], n3(:,14577), t3x128(:,:,6652))
  call heltable([8,16,128], n3(:,14578), t3x128(:,:,6653))
  call heltable([8,16,128], n3(:,14579), t3x128(:,:,6654))
  call heltable([8,16,128], n3(:,14580), t3x128(:,:,6655))
  call heltable([8,16,128], n3(:,14581), t3x128(:,:,6656))
  call heltable([8,16,128], n3(:,14582), t3x128(:,:,6657))
  call heltable([8,16,128], n3(:,14583), t3x128(:,:,6658))
  call heltable([8,16,128], n3(:,14584), t3x128(:,:,6659))
  call heltable([8,16,128], n3(:,14585), t3x128(:,:,6660))
  call heltable([8,16,128], n3(:,14586), t3x128(:,:,6661))
  call heltable([8,16,128], n3(:,14587), t3x128(:,:,6662))
  call heltable([8,16,128], n3(:,14588), t3x128(:,:,6663))
  call heltable([8,16,128], n3(:,14589), t3x128(:,:,6664))
  call heltable([8,16,128], n3(:,14590), t3x128(:,:,6665))
  call heltable([8,16,128], n3(:,14591), t3x128(:,:,6666))
  call heltable([8,16,128], n3(:,14592), t3x128(:,:,6667))
  call heltable([8,16,128], n3(:,14593), t3x128(:,:,6668))
  call heltable([8,16,128], n3(:,14594), t3x128(:,:,6669))
  call heltable([8,16,128], n3(:,14595), t3x128(:,:,6670))
  call heltable([8,16,128], n3(:,14596), t3x128(:,:,6671))
  call heltable([8,16,128], n3(:,14597), t3x128(:,:,6672))
  call heltable([8,16,128], n3(:,14598), t3x128(:,:,6673))
  call heltable([8,16,128], n3(:,14599), t3x128(:,:,6674))
  call heltable([8,16,128], n3(:,14600), t3x128(:,:,6675))
  call heltable([8,16,128], n3(:,14601), t3x128(:,:,6676))
  call heltable([8,16,128], n3(:,14602), t3x128(:,:,6677))
  call heltable([8,16,128], n3(:,14603), t3x128(:,:,6678))
  call heltable([8,16,128], n3(:,14604), t3x128(:,:,6679))
  call heltable([8,16,128], n3(:,14605), t3x128(:,:,6680))
  call heltable([8,16,128], n3(:,14606), t3x128(:,:,6681))
  call heltable([8,16,128], n3(:,14607), t3x128(:,:,6682))
  call heltable([8,16,128], n3(:,14608), t3x128(:,:,6683))
  call heltable([8,16,128], n3(:,14609), t3x128(:,:,6684))
  call heltable([8,16,128], n3(:,14610), t3x128(:,:,6685))
  call heltable([8,16,128], n3(:,14611), t3x128(:,:,6686))
  call heltable([8,16,128], n3(:,14612), t3x128(:,:,6687))
  call heltable([8,16,128], n3(:,14613), t3x128(:,:,6688))
  call heltable([8,16,128], n3(:,14614), t3x128(:,:,6689))
  call heltable([8,16,128], n3(:,14615), t3x128(:,:,6690))
  call heltable([8,16,128], n3(:,14616), t3x128(:,:,6691))
  call heltable([8,16,128], n3(:,14617), t3x128(:,:,6692))
  call heltable([8,16,128], n3(:,14618), t3x128(:,:,6693))
  call heltable([8,16,128], n3(:,14619), t3x128(:,:,6694))
  call heltable([8,16,128], n3(:,14620), t3x128(:,:,6695))
  call heltable([8,16,128], n3(:,14621), t3x128(:,:,6696))
  call heltable([8,16,128], n3(:,14622), t3x128(:,:,6697))
  call heltable([8,16,128], n3(:,14623), t3x128(:,:,6698))
  call heltable([8,16,128], n3(:,14624), t3x128(:,:,6699))
  call heltable([8,16,128], n3(:,14625), t3x128(:,:,6700))
  call heltable([8,16,128], n3(:,14626), t3x128(:,:,6701))
  call heltable([8,16,128], n3(:,14627), t3x128(:,:,6702))
  call heltable([8,16,128], n3(:,14628), t3x128(:,:,6703))
  call heltable([8,16,128], n3(:,14629), t3x128(:,:,6704))
  call heltable([8,16,128], n3(:,14630), t3x128(:,:,6705))
  call heltable([8,16,128], n3(:,14631), t3x128(:,:,6706))
  call heltable([8,16,128], n3(:,14632), t3x128(:,:,6707))
  call heltable([8,16,128], n3(:,14633), t3x128(:,:,6708))
  call heltable([8,16,128], n3(:,14634), t3x128(:,:,6709))
  call heltable([8,16,128], n3(:,14635), t3x128(:,:,6710))
  call heltable([16,8,128], n3(:,14636), t3x128(:,:,6711))
  call heltable([16,8,128], n3(:,14637), t3x128(:,:,6712))
  call heltable([16,8,128], n3(:,14638), t3x128(:,:,6713))
  call heltable([16,8,128], n3(:,14639), t3x128(:,:,6714))
  call heltable([16,8,128], n3(:,14640), t3x128(:,:,6715))
  call heltable([16,8,128], n3(:,14641), t3x128(:,:,6716))
  call heltable([16,8,128], n3(:,14642), t3x128(:,:,6717))
  call heltable([16,8,128], n3(:,14643), t3x128(:,:,6718))
  call heltable([16,8,128], n3(:,14644), t3x128(:,:,6719))
  call heltable([16,8,128], n3(:,14645), t3x128(:,:,6720))
  call heltable([16,8,128], n3(:,14646), t3x128(:,:,6721))
  call heltable([16,8,128], n3(:,14647), t3x128(:,:,6722))
  call heltable([16,8,128], n3(:,14648), t3x128(:,:,6723))
  call heltable([16,8,128], n3(:,14649), t3x128(:,:,6724))
  call heltable([16,8,128], n3(:,14650), t3x128(:,:,6725))
  call heltable([16,8,128], n3(:,14651), t3x128(:,:,6726))
  call heltable([8,16,128], n3(:,14652), t3x128(:,:,6727))
  call heltable([8,16,128], n3(:,14653), t3x128(:,:,6728))
  call heltable([8,16,128], n3(:,14654), t3x128(:,:,6729))
  call heltable([8,16,128], n3(:,14655), t3x128(:,:,6730))
  call heltable([8,16,128], n3(:,14656), t3x128(:,:,6731))
  call heltable([8,16,128], n3(:,14657), t3x128(:,:,6732))
  call heltable([8,16,128], n3(:,14658), t3x128(:,:,6733))
  call heltable([8,16,128], n3(:,14659), t3x128(:,:,6734))
  call heltable([8,16,128], n3(:,14660), t3x128(:,:,6735))
  call heltable([8,16,128], n3(:,14661), t3x128(:,:,6736))
  call heltable([8,16,128], n3(:,14662), t3x128(:,:,6737))
  call heltable([8,16,128], n3(:,14663), t3x128(:,:,6738))
  call heltable([8,16,128], n3(:,14664), t3x128(:,:,6739))
  call heltable([8,16,128], n3(:,14665), t3x128(:,:,6740))
  call heltable([8,16,128], n3(:,14666), t3x128(:,:,6741))
  call heltable([8,16,128], n3(:,14667), t3x128(:,:,6742))
  call heltable([16,8,128], n3(:,14668), t3x128(:,:,6743))
  call heltable([16,8,128], n3(:,14669), t3x128(:,:,6744))
  call heltable([16,8,128], n3(:,14670), t3x128(:,:,6745))
  call heltable([16,8,128], n3(:,14671), t3x128(:,:,6746))
  call heltable([16,8,128], n3(:,14672), t3x128(:,:,6747))
  call heltable([16,8,128], n3(:,14673), t3x128(:,:,6748))
  call heltable([16,8,128], n3(:,14674), t3x128(:,:,6749))
  call heltable([16,8,128], n3(:,14675), t3x128(:,:,6750))
  call heltable([16,8,128], n3(:,14676), t3x128(:,:,6751))
  call heltable([16,8,128], n3(:,14677), t3x128(:,:,6752))
  call heltable([16,8,128], n3(:,14678), t3x128(:,:,6753))
  call heltable([16,8,128], n3(:,14679), t3x128(:,:,6754))
  call heltable([16,8,128], n3(:,14680), t3x128(:,:,6755))
  call heltable([16,8,128], n3(:,14681), t3x128(:,:,6756))
  call heltable([16,8,128], n3(:,14682), t3x128(:,:,6757))
  call heltable([16,8,128], n3(:,14683), t3x128(:,:,6758))
  call heltable([8,16,128], n3(:,14684), t3x128(:,:,6759))
  call heltable([8,16,128], n3(:,14685), t3x128(:,:,6760))
  call heltable([8,16,128], n3(:,14686), t3x128(:,:,6761))
  call heltable([8,16,128], n3(:,14687), t3x128(:,:,6762))
  call heltable([8,16,128], n3(:,14688), t3x128(:,:,6763))
  call heltable([8,16,128], n3(:,14689), t3x128(:,:,6764))
  call heltable([8,16,128], n3(:,14690), t3x128(:,:,6765))
  call heltable([8,16,128], n3(:,14691), t3x128(:,:,6766))
  call heltable([8,16,128], n3(:,14692), t3x128(:,:,6767))
  call heltable([8,16,128], n3(:,14693), t3x128(:,:,6768))
  call heltable([8,16,128], n3(:,14694), t3x128(:,:,6769))
  call heltable([8,16,128], n3(:,14695), t3x128(:,:,6770))
  call heltable([8,16,128], n3(:,14696), t3x128(:,:,6771))
  call heltable([8,16,128], n3(:,14697), t3x128(:,:,6772))
  call heltable([8,16,128], n3(:,14698), t3x128(:,:,6773))
  call heltable([8,16,128], n3(:,14699), t3x128(:,:,6774))
  call heltable([8,16,128], n3(:,14700), t3x128(:,:,6775))
  call heltable([8,16,128], n3(:,14701), t3x128(:,:,6776))
  call heltable([8,16,128], n3(:,14702), t3x128(:,:,6777))
  call heltable([8,16,128], n3(:,14703), t3x128(:,:,6778))
  call heltable([8,16,128], n3(:,14704), t3x128(:,:,6779))
  call heltable([8,16,128], n3(:,14705), t3x128(:,:,6780))
  call heltable([8,16,128], n3(:,14706), t3x128(:,:,6781))
  call heltable([8,16,128], n3(:,14707), t3x128(:,:,6782))
  call heltable([8,16,128], n3(:,14708), t3x128(:,:,6783))
  call heltable([8,16,128], n3(:,14709), t3x128(:,:,6784))
  call heltable([8,16,128], n3(:,14710), t3x128(:,:,6785))
  call heltable([8,16,128], n3(:,14711), t3x128(:,:,6786))
  call heltable([8,16,128], n3(:,14712), t3x128(:,:,6787))
  call heltable([8,16,128], n3(:,14713), t3x128(:,:,6788))
  call heltable([8,16,128], n3(:,14714), t3x128(:,:,6789))
  call heltable([8,16,128], n3(:,14715), t3x128(:,:,6790))
  call heltable([8,16,128], n3(:,14716), t3x128(:,:,6791))
  call heltable([8,16,128], n3(:,14717), t3x128(:,:,6792))
  call heltable([8,16,128], n3(:,14718), t3x128(:,:,6793))
  call heltable([8,16,128], n3(:,14719), t3x128(:,:,6794))
  call heltable([8,16,128], n3(:,14720), t3x128(:,:,6795))
  call heltable([8,16,128], n3(:,14721), t3x128(:,:,6796))
  call heltable([8,16,128], n3(:,14722), t3x128(:,:,6797))
  call heltable([8,16,128], n3(:,14723), t3x128(:,:,6798))
  call heltable([8,16,128], n3(:,14724), t3x128(:,:,6799))
  call heltable([8,16,128], n3(:,14725), t3x128(:,:,6800))
  call heltable([8,16,128], n3(:,14726), t3x128(:,:,6801))
  call heltable([8,16,128], n3(:,14727), t3x128(:,:,6802))
  call heltable([8,16,128], n3(:,14728), t3x128(:,:,6803))
  call heltable([8,16,128], n3(:,14729), t3x128(:,:,6804))
  call heltable([8,16,128], n3(:,14730), t3x128(:,:,6805))
  call heltable([8,16,128], n3(:,14731), t3x128(:,:,6806))
  call heltable([16,8,128], n3(:,14732), t3x128(:,:,6807))
  call heltable([16,8,128], n3(:,14733), t3x128(:,:,6808))
  call heltable([16,8,128], n3(:,14734), t3x128(:,:,6809))
  call heltable([16,8,128], n3(:,14735), t3x128(:,:,6810))
  call heltable([16,8,128], n3(:,14736), t3x128(:,:,6811))
  call heltable([16,8,128], n3(:,14737), t3x128(:,:,6812))
  call heltable([16,8,128], n3(:,14738), t3x128(:,:,6813))
  call heltable([16,8,128], n3(:,14739), t3x128(:,:,6814))
  call heltable([16,8,128], n3(:,14740), t3x128(:,:,6815))
  call heltable([16,8,128], n3(:,14741), t3x128(:,:,6816))
  call heltable([16,8,128], n3(:,14742), t3x128(:,:,6817))
  call heltable([16,8,128], n3(:,14743), t3x128(:,:,6818))
  call heltable([16,8,128], n3(:,14744), t3x128(:,:,6819))
  call heltable([16,8,128], n3(:,14745), t3x128(:,:,6820))
  call heltable([16,8,128], n3(:,14746), t3x128(:,:,6821))
  call heltable([16,8,128], n3(:,14747), t3x128(:,:,6822))
  call heltable([16,8,128], n3(:,14748), t3x128(:,:,6823))
  call heltable([16,8,128], n3(:,14749), t3x128(:,:,6824))
  call heltable([16,8,128], n3(:,14750), t3x128(:,:,6825))
  call heltable([16,8,128], n3(:,14751), t3x128(:,:,6826))
  call heltable([16,8,128], n3(:,14752), t3x128(:,:,6827))
  call heltable([16,8,128], n3(:,14753), t3x128(:,:,6828))
  call heltable([16,8,128], n3(:,14754), t3x128(:,:,6829))
  call heltable([16,8,128], n3(:,14755), t3x128(:,:,6830))
  call heltable([16,8,128], n3(:,14756), t3x128(:,:,6831))
  call heltable([16,8,128], n3(:,14757), t3x128(:,:,6832))
  call heltable([16,8,128], n3(:,14758), t3x128(:,:,6833))
  call heltable([16,8,128], n3(:,14759), t3x128(:,:,6834))
  call heltable([16,8,128], n3(:,14760), t3x128(:,:,6835))
  call heltable([16,8,128], n3(:,14761), t3x128(:,:,6836))
  call heltable([16,8,128], n3(:,14762), t3x128(:,:,6837))
  call heltable([16,8,128], n3(:,14763), t3x128(:,:,6838))
  call heltable([8,16,128], n3(:,14764), t3x128(:,:,6839))
  call heltable([8,16,128], n3(:,14765), t3x128(:,:,6840))
  call heltable([8,16,128], n3(:,14766), t3x128(:,:,6841))
  call heltable([8,16,128], n3(:,14767), t3x128(:,:,6842))
  call heltable([8,16,128], n3(:,14768), t3x128(:,:,6843))
  call heltable([8,16,128], n3(:,14769), t3x128(:,:,6844))
  call heltable([8,16,128], n3(:,14770), t3x128(:,:,6845))
  call heltable([8,16,128], n3(:,14771), t3x128(:,:,6846))
  call heltable([8,16,128], n3(:,14772), t3x128(:,:,6847))
  call heltable([8,16,128], n3(:,14773), t3x128(:,:,6848))
  call heltable([8,16,128], n3(:,14774), t3x128(:,:,6849))
  call heltable([8,16,128], n3(:,14775), t3x128(:,:,6850))
  call heltable([8,16,128], n3(:,14776), t3x128(:,:,6851))
  call heltable([8,16,128], n3(:,14777), t3x128(:,:,6852))
  call heltable([8,16,128], n3(:,14778), t3x128(:,:,6853))
  call heltable([8,16,128], n3(:,14779), t3x128(:,:,6854))
  call heltable([8,16,128], n3(:,14780), t3x128(:,:,6855))
  call heltable([8,16,128], n3(:,14781), t3x128(:,:,6856))
  call heltable([8,16,128], n3(:,14782), t3x128(:,:,6857))
  call heltable([8,16,128], n3(:,14783), t3x128(:,:,6858))
  call heltable([8,16,128], n3(:,14784), t3x128(:,:,6859))
  call heltable([8,16,128], n3(:,14785), t3x128(:,:,6860))
  call heltable([8,16,128], n3(:,14786), t3x128(:,:,6861))
  call heltable([8,16,128], n3(:,14787), t3x128(:,:,6862))
  call heltable([8,16,128], n3(:,14788), t3x128(:,:,6863))
  call heltable([8,16,128], n3(:,14789), t3x128(:,:,6864))
  call heltable([8,16,128], n3(:,14790), t3x128(:,:,6865))
  call heltable([8,16,128], n3(:,14791), t3x128(:,:,6866))
  call heltable([8,16,128], n3(:,14792), t3x128(:,:,6867))
  call heltable([8,16,128], n3(:,14793), t3x128(:,:,6868))
  call heltable([8,16,128], n3(:,14794), t3x128(:,:,6869))
  call heltable([8,16,128], n3(:,14795), t3x128(:,:,6870))
  call heltable([8,16,128], n3(:,14796), t3x128(:,:,6871))
  call heltable([8,16,128], n3(:,14797), t3x128(:,:,6872))
  call heltable([8,16,128], n3(:,14798), t3x128(:,:,6873))
  call heltable([8,16,128], n3(:,14799), t3x128(:,:,6874))
  call heltable([8,16,128], n3(:,14800), t3x128(:,:,6875))
  call heltable([8,16,128], n3(:,14801), t3x128(:,:,6876))
  call heltable([8,16,128], n3(:,14802), t3x128(:,:,6877))
  call heltable([8,16,128], n3(:,14803), t3x128(:,:,6878))
  call heltable([8,16,128], n3(:,14804), t3x128(:,:,6879))
  call heltable([8,16,128], n3(:,14805), t3x128(:,:,6880))
  call heltable([8,16,128], n3(:,14806), t3x128(:,:,6881))
  call heltable([8,16,128], n3(:,14807), t3x128(:,:,6882))
  call heltable([8,16,128], n3(:,14808), t3x128(:,:,6883))
  call heltable([8,16,128], n3(:,14809), t3x128(:,:,6884))
  call heltable([8,16,128], n3(:,14810), t3x128(:,:,6885))
  call heltable([8,16,128], n3(:,14811), t3x128(:,:,6886))
  call heltable([8,16,128], n3(:,14812), t3x128(:,:,6887))
  call heltable([8,16,128], n3(:,14813), t3x128(:,:,6888))
  call heltable([8,16,128], n3(:,14814), t3x128(:,:,6889))
  call heltable([8,16,128], n3(:,14815), t3x128(:,:,6890))
  call heltable([8,16,128], n3(:,14816), t3x128(:,:,6891))
  call heltable([8,16,128], n3(:,14817), t3x128(:,:,6892))
  call heltable([8,16,128], n3(:,14818), t3x128(:,:,6893))
  call heltable([8,16,128], n3(:,14819), t3x128(:,:,6894))
  call heltable([8,16,128], n3(:,14820), t3x128(:,:,6895))
  call heltable([8,16,128], n3(:,14821), t3x128(:,:,6896))
  call heltable([8,16,128], n3(:,14822), t3x128(:,:,6897))
  call heltable([8,16,128], n3(:,14823), t3x128(:,:,6898))
  call heltable([8,16,128], n3(:,14824), t3x128(:,:,6899))
  call heltable([8,16,128], n3(:,14825), t3x128(:,:,6900))
  call heltable([8,16,128], n3(:,14826), t3x128(:,:,6901))
  call heltable([8,16,128], n3(:,14827), t3x128(:,:,6902))
  call heltable([16,8,128], n3(:,14828), t3x128(:,:,6903))
  call heltable([16,8,128], n3(:,14829), t3x128(:,:,6904))
  call heltable([16,8,128], n3(:,14830), t3x128(:,:,6905))
  call heltable([16,8,128], n3(:,14831), t3x128(:,:,6906))
  call heltable([16,8,128], n3(:,14832), t3x128(:,:,6907))
  call heltable([16,8,128], n3(:,14833), t3x128(:,:,6908))
  call heltable([16,8,128], n3(:,14834), t3x128(:,:,6909))
  call heltable([16,8,128], n3(:,14835), t3x128(:,:,6910))
  call heltable([16,8,128], n3(:,14836), t3x128(:,:,6911))
  call heltable([16,8,128], n3(:,14837), t3x128(:,:,6912))
  call heltable([16,8,128], n3(:,14838), t3x128(:,:,6913))
  call heltable([16,8,128], n3(:,14839), t3x128(:,:,6914))
  call heltable([16,8,128], n3(:,14840), t3x128(:,:,6915))
  call heltable([16,8,128], n3(:,14841), t3x128(:,:,6916))
  call heltable([16,8,128], n3(:,14842), t3x128(:,:,6917))
  call heltable([16,8,128], n3(:,14843), t3x128(:,:,6918))
  call heltable([8,16,128], n3(:,14844), t3x128(:,:,6919))
  call heltable([8,16,128], n3(:,14845), t3x128(:,:,6920))
  call heltable([8,16,128], n3(:,14846), t3x128(:,:,6921))
  call heltable([8,16,128], n3(:,14847), t3x128(:,:,6922))
  call heltable([8,16,128], n3(:,14848), t3x128(:,:,6923))
  call heltable([8,16,128], n3(:,14849), t3x128(:,:,6924))
  call heltable([8,16,128], n3(:,14850), t3x128(:,:,6925))
  call heltable([8,16,128], n3(:,14851), t3x128(:,:,6926))
  call heltable([8,16,128], n3(:,14852), t3x128(:,:,6927))
  call heltable([8,16,128], n3(:,14853), t3x128(:,:,6928))
  call heltable([8,16,128], n3(:,14854), t3x128(:,:,6929))
  call heltable([8,16,128], n3(:,14855), t3x128(:,:,6930))
  call heltable([8,16,128], n3(:,14856), t3x128(:,:,6931))
  call heltable([8,16,128], n3(:,14857), t3x128(:,:,6932))
  call heltable([8,16,128], n3(:,14858), t3x128(:,:,6933))
  call heltable([8,16,128], n3(:,14859), t3x128(:,:,6934))
  call heltable([16,8,128], n3(:,14860), t3x128(:,:,6935))
  call heltable([16,8,128], n3(:,14861), t3x128(:,:,6936))
  call heltable([16,8,128], n3(:,14862), t3x128(:,:,6937))
  call heltable([16,8,128], n3(:,14863), t3x128(:,:,6938))
  call heltable([16,8,128], n3(:,14864), t3x128(:,:,6939))
  call heltable([16,8,128], n3(:,14865), t3x128(:,:,6940))
  call heltable([16,8,128], n3(:,14866), t3x128(:,:,6941))
  call heltable([16,8,128], n3(:,14867), t3x128(:,:,6942))
  call heltable([16,8,128], n3(:,14868), t3x128(:,:,6943))
  call heltable([16,8,128], n3(:,14869), t3x128(:,:,6944))
  call heltable([16,8,128], n3(:,14870), t3x128(:,:,6945))
  call heltable([16,8,128], n3(:,14871), t3x128(:,:,6946))
  call heltable([16,8,128], n3(:,14872), t3x128(:,:,6947))
  call heltable([8,16,128], n3(:,14873), t3x128(:,:,6948))
  call heltable([16,8,128], n3(:,14874), t3x128(:,:,6949))
  call heltable([8,16,128], n3(:,14875), t3x128(:,:,6950))
  call heltable([8,16,128], n3(:,14876), t3x128(:,:,6951))
  call heltable([16,8,128], n3(:,14877), t3x128(:,:,6952))
  call heltable([16,8,128], n3(:,14878), t3x128(:,:,6953))
  call heltable([16,8,128], n3(:,14879), t3x128(:,:,6954))
  call heltable([16,8,128], n3(:,14880), t3x128(:,:,6955))
  call heltable([8,16,128], n3(:,14881), t3x128(:,:,6956))
  call heltable([8,16,128], n3(:,14882), t3x128(:,:,6957))
  call heltable([8,16,128], n3(:,14883), t3x128(:,:,6958))
  call heltable([8,16,128], n3(:,14884), t3x128(:,:,6959))
  call heltable([8,16,128], n3(:,14885), t3x128(:,:,6960))
  call heltable([8,16,128], n3(:,14886), t3x128(:,:,6961))
  call heltable([8,16,128], n3(:,14887), t3x128(:,:,6962))
  call heltable([8,16,128], n3(:,14888), t3x128(:,:,6963))
  call heltable([8,16,128], n3(:,14889), t3x128(:,:,6964))
  call heltable([8,16,128], n3(:,14890), t3x128(:,:,6965))
  call heltable([16,8,128], n3(:,14891), t3x128(:,:,6966))
  call heltable([16,8,128], n3(:,14892), t3x128(:,:,6967))
  call heltable([8,16,128], n3(:,14893), t3x128(:,:,6968))
  call heltable([8,16,128], n3(:,14894), t3x128(:,:,6969))
  call heltable([8,16,128], n3(:,14895), t3x128(:,:,6970))
  call heltable([8,16,128], n3(:,14896), t3x128(:,:,6971))
  call heltable([16,8,128], n3(:,14897), t3x128(:,:,6972))
  call heltable([16,8,128], n3(:,14898), t3x128(:,:,6973))
  call heltable([16,8,128], n3(:,14899), t3x128(:,:,6974))
  call heltable([16,8,128], n3(:,14900), t3x128(:,:,6975))
  call heltable([16,8,128], n3(:,14901), t3x128(:,:,6976))
  call heltable([16,8,128], n3(:,14902), t3x128(:,:,6977))
  call heltable([16,8,128], n3(:,14903), t3x128(:,:,6978))
  call heltable([16,8,128], n3(:,14904), t3x128(:,:,6979))
  call heltable([8,16,128], n3(:,14905), t3x128(:,:,6980))
  call heltable([8,16,128], n3(:,14906), t3x128(:,:,6981))
  call heltable([8,16,128], n3(:,14907), t3x128(:,:,6982))
  call heltable([8,16,128], n3(:,14908), t3x128(:,:,6983))
  call heltable([8,16,128], n3(:,14909), t3x128(:,:,6984))
  call heltable([8,16,128], n3(:,14910), t3x128(:,:,6985))
  call heltable([8,16,128], n3(:,14911), t3x128(:,:,6986))
  call heltable([8,16,128], n3(:,14912), t3x128(:,:,6987))
  call heltable([8,16,128], n3(:,14913), t3x128(:,:,6988))
  call heltable([8,16,128], n3(:,14914), t3x128(:,:,6989))
  call heltable([8,16,128], n3(:,14915), t3x128(:,:,6990))
  call heltable([8,16,128], n3(:,14916), t3x128(:,:,6991))
  call heltable([8,16,128], n3(:,14917), t3x128(:,:,6992))
  call heltable([8,16,128], n3(:,14918), t3x128(:,:,6993))
  call heltable([8,16,128], n3(:,14919), t3x128(:,:,6994))
  call heltable([8,16,128], n3(:,14920), t3x128(:,:,6995))
  call heltable([8,16,128], n3(:,14921), t3x128(:,:,6996))
  call heltable([8,16,128], n3(:,14922), t3x128(:,:,6997))
  call heltable([8,16,128], n3(:,14923), t3x128(:,:,6998))
  call heltable([8,16,128], n3(:,14924), t3x128(:,:,6999))
  call heltable([8,16,128], n3(:,14925), t3x128(:,:,7000))
  call heltable([8,16,128], n3(:,14926), t3x128(:,:,7001))
  call heltable([8,16,128], n3(:,14927), t3x128(:,:,7002))
  call heltable([8,16,128], n3(:,14928), t3x128(:,:,7003))
  call heltable([8,16,128], n3(:,14929), t3x128(:,:,7004))
  call heltable([8,16,128], n3(:,14930), t3x128(:,:,7005))
  call heltable([8,16,128], n3(:,14931), t3x128(:,:,7006))
  call heltable([8,16,128], n3(:,14932), t3x128(:,:,7007))
  call heltable([8,16,128], n3(:,14933), t3x128(:,:,7008))
  call heltable([8,16,128], n3(:,14934), t3x128(:,:,7009))
  call heltable([8,16,128], n3(:,14935), t3x128(:,:,7010))
  call heltable([8,16,128], n3(:,14936), t3x128(:,:,7011))
  call heltable([8,16,128], n3(:,14937), t3x128(:,:,7012))
  call heltable([8,16,128], n3(:,14938), t3x128(:,:,7013))
  call heltable([8,16,128], n3(:,14939), t3x128(:,:,7014))
  call heltable([8,16,128], n3(:,14940), t3x128(:,:,7015))
  call heltable([8,16,128], n3(:,14941), t3x128(:,:,7016))
  call heltable([8,16,128], n3(:,14942), t3x128(:,:,7017))
  call heltable([8,16,128], n3(:,14943), t3x128(:,:,7018))
  call heltable([8,16,128], n3(:,14944), t3x128(:,:,7019))
  call heltable([8,16,128], n3(:,14945), t3x128(:,:,7020))
  call heltable([8,16,128], n3(:,14946), t3x128(:,:,7021))
  call heltable([8,16,128], n3(:,14947), t3x128(:,:,7022))
  call heltable([8,16,128], n3(:,14948), t3x128(:,:,7023))
  call heltable([8,16,128], n3(:,14949), t3x128(:,:,7024))
  call heltable([8,16,128], n3(:,14950), t3x128(:,:,7025))
  call heltable([8,16,128], n3(:,14951), t3x128(:,:,7026))
  call heltable([8,16,128], n3(:,14952), t3x128(:,:,7027))
  call heltable([16,8,128], n3(:,14953), t3x128(:,:,7028))
  call heltable([16,8,128], n3(:,14954), t3x128(:,:,7029))
  call heltable([16,8,128], n3(:,14955), t3x128(:,:,7030))
  call heltable([16,8,128], n3(:,14956), t3x128(:,:,7031))
  call heltable([16,8,128], n3(:,14957), t3x128(:,:,7032))
  call heltable([16,8,128], n3(:,14958), t3x128(:,:,7033))
  call heltable([16,8,128], n3(:,14959), t3x128(:,:,7034))
  call heltable([16,8,128], n3(:,14960), t3x128(:,:,7035))
  call heltable([16,8,128], n3(:,14961), t3x128(:,:,7036))
  call heltable([16,8,128], n3(:,14962), t3x128(:,:,7037))
  call heltable([16,8,128], n3(:,14963), t3x128(:,:,7038))
  call heltable([16,8,128], n3(:,14964), t3x128(:,:,7039))
  call heltable([16,8,128], n3(:,14965), t3x128(:,:,7040))
  call heltable([8,16,128], n3(:,14966), t3x128(:,:,7041))
  call heltable([8,16,128], n3(:,14967), t3x128(:,:,7042))
  call heltable([8,16,128], n3(:,14968), t3x128(:,:,7043))
  call heltable([8,16,128], n3(:,14969), t3x128(:,:,7044))
  call heltable([8,16,128], n3(:,14970), t3x128(:,:,7045))
  call heltable([8,16,128], n3(:,14971), t3x128(:,:,7046))
  call heltable([8,16,128], n3(:,14972), t3x128(:,:,7047))
  call heltable([8,16,128], n3(:,14973), t3x128(:,:,7048))
  call heltable([8,16,128], n3(:,14974), t3x128(:,:,7049))
  call heltable([8,16,128], n3(:,14975), t3x128(:,:,7050))
  call heltable([8,16,128], n3(:,14976), t3x128(:,:,7051))
  call heltable([8,16,128], n3(:,14977), t3x128(:,:,7052))
  call heltable([8,16,128], n3(:,14978), t3x128(:,:,7053))
  call heltable([8,16,128], n3(:,14979), t3x128(:,:,7054))
  call heltable([8,16,128], n3(:,14980), t3x128(:,:,7055))
  call heltable([8,16,128], n3(:,14981), t3x128(:,:,7056))
  call heltable([8,16,128], n3(:,14982), t3x128(:,:,7057))
  call heltable([8,16,128], n3(:,14983), t3x128(:,:,7058))
  call heltable([8,16,128], n3(:,14984), t3x128(:,:,7059))
  call heltable([8,16,128], n3(:,14985), t3x128(:,:,7060))
  call heltable([8,16,128], n3(:,14986), t3x128(:,:,7061))
  call heltable([8,16,128], n3(:,14987), t3x128(:,:,7062))
  call heltable([8,16,128], n3(:,14988), t3x128(:,:,7063))
  call heltable([8,16,128], n3(:,14989), t3x128(:,:,7064))
  call heltable([8,16,128], n3(:,14990), t3x128(:,:,7065))
  call heltable([8,16,128], n3(:,14991), t3x128(:,:,7066))
  call heltable([8,16,128], n3(:,14992), t3x128(:,:,7067))
  call heltable([8,16,128], n3(:,14993), t3x128(:,:,7068))
  call heltable([8,16,128], n3(:,14994), t3x128(:,:,7069))
  call heltable([8,16,128], n3(:,14995), t3x128(:,:,7070))
  call heltable([8,16,128], n3(:,14996), t3x128(:,:,7071))
  call heltable([8,16,128], n3(:,14997), t3x128(:,:,7072))
  call heltable([8,16,128], n3(:,14998), t3x128(:,:,7073))
  call heltable([8,16,128], n3(:,14999), t3x128(:,:,7074))
  call heltable([8,16,128], n3(:,15000), t3x128(:,:,7075))
  call heltable([8,16,128], n3(:,15001), t3x128(:,:,7076))
  call heltable([8,16,128], n3(:,15002), t3x128(:,:,7077))
  call heltable([8,16,128], n3(:,15003), t3x128(:,:,7078))
  call heltable([8,16,128], n3(:,15004), t3x128(:,:,7079))
  call heltable([8,16,128], n3(:,15005), t3x128(:,:,7080))
  call heltable([8,16,128], n3(:,15006), t3x128(:,:,7081))
  call heltable([8,16,128], n3(:,15007), t3x128(:,:,7082))
  call heltable([8,16,128], n3(:,15008), t3x128(:,:,7083))
  call heltable([8,16,128], n3(:,15009), t3x128(:,:,7084))
  call heltable([8,16,128], n3(:,15010), t3x128(:,:,7085))
  call heltable([8,16,128], n3(:,15011), t3x128(:,:,7086))
  call heltable([8,16,128], n3(:,15012), t3x128(:,:,7087))
  call heltable([8,16,128], n3(:,15013), t3x128(:,:,7088))
  call heltable([8,16,128], n3(:,15014), t3x128(:,:,7089))
  call heltable([8,16,128], n3(:,15015), t3x128(:,:,7090))
  call heltable([8,16,128], n3(:,15016), t3x128(:,:,7091))
  call heltable([8,16,128], n3(:,15017), t3x128(:,:,7092))
  call heltable([8,16,128], n3(:,15018), t3x128(:,:,7093))
  call heltable([8,16,128], n3(:,15019), t3x128(:,:,7094))
  call heltable([8,16,128], n3(:,15020), t3x128(:,:,7095))
  call heltable([8,16,128], n3(:,15021), t3x128(:,:,7096))
  call heltable([8,16,128], n3(:,15022), t3x128(:,:,7097))
  call heltable([8,16,128], n3(:,15023), t3x128(:,:,7098))
  call heltable([8,16,128], n3(:,15024), t3x128(:,:,7099))
  call heltable([8,16,128], n3(:,15025), t3x128(:,:,7100))
  call heltable([8,16,128], n3(:,15026), t3x128(:,:,7101))
  call heltable([8,16,128], n3(:,15027), t3x128(:,:,7102))
  call heltable([8,16,128], n3(:,15028), t3x128(:,:,7103))
  call heltable([8,16,128], n3(:,15029), t3x128(:,:,7104))
  call heltable([8,16,128], n3(:,15030), t3x128(:,:,7105))
  call heltable([8,16,128], n3(:,15031), t3x128(:,:,7106))
  call heltable([8,16,128], n3(:,15032), t3x128(:,:,7107))
  call heltable([8,16,128], n3(:,15033), t3x128(:,:,7108))
  call heltable([8,16,128], n3(:,15034), t3x128(:,:,7109))
  call heltable([8,16,128], n3(:,15035), t3x128(:,:,7110))
  call heltable([8,16,128], n3(:,15036), t3x128(:,:,7111))
  call heltable([8,16,128], n3(:,15037), t3x128(:,:,7112))
  call heltable([8,16,128], n3(:,15038), t3x128(:,:,7113))
  call heltable([8,16,128], n3(:,15039), t3x128(:,:,7114))
  call heltable([8,16,128], n3(:,15040), t3x128(:,:,7115))
  call heltable([8,16,128], n3(:,15041), t3x128(:,:,7116))
  call heltable([8,16,128], n3(:,15042), t3x128(:,:,7117))
  call heltable([8,16,128], n3(:,15043), t3x128(:,:,7118))
  call heltable([8,16,128], n3(:,15044), t3x128(:,:,7119))
  call heltable([8,16,128], n3(:,15045), t3x128(:,:,7120))
  call heltable([8,16,128], n3(:,15046), t3x128(:,:,7121))
  call heltable([8,16,128], n3(:,15047), t3x128(:,:,7122))
  call heltable([8,16,128], n3(:,15048), t3x128(:,:,7123))
  call heltable([8,16,128], n3(:,15049), t3x128(:,:,7124))
  call heltable([8,16,128], n3(:,15050), t3x128(:,:,7125))
  call heltable([8,16,128], n3(:,15051), t3x128(:,:,7126))
  call heltable([8,16,128], n3(:,15052), t3x128(:,:,7127))
  call heltable([8,16,128], n3(:,15053), t3x128(:,:,7128))
  call heltable([8,16,128], n3(:,15054), t3x128(:,:,7129))
  call heltable([8,16,128], n3(:,15055), t3x128(:,:,7130))
  call heltable([8,16,128], n3(:,15056), t3x128(:,:,7131))
  call heltable([8,16,128], n3(:,15057), t3x128(:,:,7132))
  call heltable([8,16,128], n3(:,15058), t3x128(:,:,7133))
  call heltable([8,16,128], n3(:,15059), t3x128(:,:,7134))
  call heltable([8,16,128], n3(:,15060), t3x128(:,:,7135))
  call heltable([8,16,128], n3(:,15061), t3x128(:,:,7136))
  call heltable([8,16,128], n3(:,15062), t3x128(:,:,7137))
  call heltable([8,16,128], n3(:,15063), t3x128(:,:,7138))
  call heltable([8,16,128], n3(:,15064), t3x128(:,:,7139))
  call heltable([8,16,128], n3(:,15065), t3x128(:,:,7140))
  call heltable([8,16,128], n3(:,15066), t3x128(:,:,7141))
  call heltable([8,16,128], n3(:,15067), t3x128(:,:,7142))
  call heltable([8,16,128], n3(:,15068), t3x128(:,:,7143))
  call heltable([8,16,128], n3(:,15069), t3x128(:,:,7144))
  call heltable([8,16,128], n3(:,15070), t3x128(:,:,7145))
  call heltable([8,16,128], n3(:,15071), t3x128(:,:,7146))
  call heltable([8,16,128], n3(:,15072), t3x128(:,:,7147))
  call heltable([8,16,128], n3(:,15073), t3x128(:,:,7148))
  call heltable([8,16,128], n3(:,15074), t3x128(:,:,7149))
  call heltable([8,16,128], n3(:,15075), t3x128(:,:,7150))
  call heltable([8,16,128], n3(:,15076), t3x128(:,:,7151))
  call heltable([8,16,128], n3(:,15077), t3x128(:,:,7152))
  call heltable([8,16,128], n3(:,15078), t3x128(:,:,7153))
  call heltable([8,16,128], n3(:,15079), t3x128(:,:,7154))
  call heltable([8,16,128], n3(:,15080), t3x128(:,:,7155))
  call heltable([8,16,128], n3(:,15081), t3x128(:,:,7156))
  call heltable([8,16,128], n3(:,15082), t3x128(:,:,7157))
  call heltable([8,16,128], n3(:,15083), t3x128(:,:,7158))
  call heltable([8,16,128], n3(:,15084), t3x128(:,:,7159))
  call heltable([8,16,128], n3(:,15085), t3x128(:,:,7160))
  call heltable([8,16,128], n3(:,15086), t3x128(:,:,7161))
  call heltable([8,16,128], n3(:,15087), t3x128(:,:,7162))
  call heltable([8,16,128], n3(:,15088), t3x128(:,:,7163))
  call heltable([8,16,128], n3(:,15089), t3x128(:,:,7164))
  call heltable([8,16,128], n3(:,15090), t3x128(:,:,7165))
  call heltable([8,16,128], n3(:,15091), t3x128(:,:,7166))
  call heltable([8,16,128], n3(:,15092), t3x128(:,:,7167))
  call heltable([8,16,128], n3(:,15093), t3x128(:,:,7168))
  call heltable([8,16,128], n3(:,15094), t3x128(:,:,7169))
  call heltable([8,16,128], n3(:,15095), t3x128(:,:,7170))
  call heltable([8,16,128], n3(:,15096), t3x128(:,:,7171))
  call heltable([8,16,128], n3(:,15097), t3x128(:,:,7172))
  call heltable([8,16,128], n3(:,15098), t3x128(:,:,7173))
  call heltable([8,16,128], n3(:,15099), t3x128(:,:,7174))
  call heltable([8,16,128], n3(:,15100), t3x128(:,:,7175))
  call heltable([8,16,128], n3(:,15101), t3x128(:,:,7176))
  call heltable([8,16,128], n3(:,15102), t3x128(:,:,7177))
  call heltable([8,16,128], n3(:,15103), t3x128(:,:,7178))
  call heltable([8,16,128], n3(:,15104), t3x128(:,:,7179))
  call heltable([8,16,128], n3(:,15105), t3x128(:,:,7180))
  call heltable([8,16,128], n3(:,15106), t3x128(:,:,7181))
  call heltable([8,16,128], n3(:,15107), t3x128(:,:,7182))
  call heltable([8,16,128], n3(:,15108), t3x128(:,:,7183))
  call heltable([8,16,128], n3(:,15109), t3x128(:,:,7184))
  call heltable([8,16,128], n3(:,15110), t3x128(:,:,7185))
  call heltable([8,16,128], n3(:,15111), t3x128(:,:,7186))
  call heltable([8,16,128], n3(:,15112), t3x128(:,:,7187))
  call heltable([8,16,128], n3(:,15113), t3x128(:,:,7188))
  call heltable([8,16,128], n3(:,15114), t3x128(:,:,7189))
  call heltable([8,16,128], n3(:,15115), t3x128(:,:,7190))
  call heltable([8,16,128], n3(:,15116), t3x128(:,:,7191))
  call heltable([8,16,128], n3(:,15117), t3x128(:,:,7192))
  call heltable([8,16,128], n3(:,15118), t3x128(:,:,7193))
  call heltable([8,16,128], n3(:,15119), t3x128(:,:,7194))
  call heltable([8,16,128], n3(:,15120), t3x128(:,:,7195))
  call heltable([8,16,128], n3(:,15121), t3x128(:,:,7196))
  call heltable([8,16,128], n3(:,15122), t3x128(:,:,7197))
  call heltable([8,16,128], n3(:,15123), t3x128(:,:,7198))
  call heltable([8,16,128], n3(:,15124), t3x128(:,:,7199))
  call heltable([8,16,128], n3(:,15125), t3x128(:,:,7200))
  call heltable([16,8,128], n3(:,15126), t3x128(:,:,7201))
  call heltable([16,8,128], n3(:,15127), t3x128(:,:,7202))
  call heltable([16,8,128], n3(:,15128), t3x128(:,:,7203))
  call heltable([16,8,128], n3(:,15129), t3x128(:,:,7204))
  call heltable([16,8,128], n3(:,15130), t3x128(:,:,7205))
  call heltable([16,8,128], n3(:,15131), t3x128(:,:,7206))
  call heltable([16,8,128], n3(:,15132), t3x128(:,:,7207))
  call heltable([16,8,128], n3(:,15133), t3x128(:,:,7208))
  call heltable([16,8,128], n3(:,15134), t3x128(:,:,7209))
  call heltable([16,8,128], n3(:,15135), t3x128(:,:,7210))
  call heltable([16,8,128], n3(:,15136), t3x128(:,:,7211))
  call heltable([16,8,128], n3(:,15137), t3x128(:,:,7212))
  call heltable([16,8,128], n3(:,15138), t3x128(:,:,7213))
  call heltable([16,8,128], n3(:,15139), t3x128(:,:,7214))
  call heltable([16,8,128], n3(:,15140), t3x128(:,:,7215))
  call heltable([16,8,128], n3(:,15141), t3x128(:,:,7216))
  call heltable([8,16,128], n3(:,15142), t3x128(:,:,7217))
  call heltable([8,16,128], n3(:,15143), t3x128(:,:,7218))
  call heltable([8,16,128], n3(:,15144), t3x128(:,:,7219))
  call heltable([8,16,128], n3(:,15145), t3x128(:,:,7220))
  call heltable([8,16,128], n3(:,15146), t3x128(:,:,7221))
  call heltable([8,16,128], n3(:,15147), t3x128(:,:,7222))
  call heltable([8,16,128], n3(:,15148), t3x128(:,:,7223))
  call heltable([8,16,128], n3(:,15149), t3x128(:,:,7224))
  call heltable([8,16,128], n3(:,15150), t3x128(:,:,7225))
  call heltable([8,16,128], n3(:,15151), t3x128(:,:,7226))
  call heltable([8,16,128], n3(:,15152), t3x128(:,:,7227))
  call heltable([8,16,128], n3(:,15153), t3x128(:,:,7228))
  call heltable([8,16,128], n3(:,15154), t3x128(:,:,7229))
  call heltable([8,16,128], n3(:,15155), t3x128(:,:,7230))
  call heltable([8,16,128], n3(:,15156), t3x128(:,:,7231))
  call heltable([8,16,128], n3(:,15157), t3x128(:,:,7232))
  call heltable([8,16,128], n3(:,15158), t3x128(:,:,7233))
  call heltable([8,16,128], n3(:,15159), t3x128(:,:,7234))
  call heltable([8,16,128], n3(:,15160), t3x128(:,:,7235))
  call heltable([8,16,128], n3(:,15161), t3x128(:,:,7236))
  call heltable([8,16,128], n3(:,15162), t3x128(:,:,7237))
  call heltable([8,16,128], n3(:,15163), t3x128(:,:,7238))
  call heltable([8,16,128], n3(:,15164), t3x128(:,:,7239))
  call heltable([8,16,128], n3(:,15165), t3x128(:,:,7240))
  call heltable([8,16,128], n3(:,15166), t3x128(:,:,7241))
  call heltable([8,16,128], n3(:,15167), t3x128(:,:,7242))
  call heltable([8,16,128], n3(:,15168), t3x128(:,:,7243))
  call heltable([8,16,128], n3(:,15169), t3x128(:,:,7244))
  call heltable([8,16,128], n3(:,15170), t3x128(:,:,7245))
  call heltable([16,8,128], n3(:,15171), t3x128(:,:,7246))
  call heltable([16,8,128], n3(:,15172), t3x128(:,:,7247))
  call heltable([16,8,128], n3(:,15173), t3x128(:,:,7248))
  call heltable([16,8,128], n3(:,15174), t3x128(:,:,7249))
  call heltable([16,8,128], n3(:,15175), t3x128(:,:,7250))
  call heltable([16,8,128], n3(:,15176), t3x128(:,:,7251))
  call heltable([16,8,128], n3(:,15177), t3x128(:,:,7252))
  call heltable([16,8,128], n3(:,15178), t3x128(:,:,7253))
  call heltable([16,8,128], n3(:,15179), t3x128(:,:,7254))
  call heltable([16,8,128], n3(:,15180), t3x128(:,:,7255))
  call heltable([16,8,128], n3(:,15181), t3x128(:,:,7256))
  call heltable([16,8,128], n3(:,15182), t3x128(:,:,7257))
  call heltable([16,8,128], n3(:,15183), t3x128(:,:,7258))
  call heltable([16,8,128], n3(:,15184), t3x128(:,:,7259))
  call heltable([16,8,128], n3(:,15185), t3x128(:,:,7260))
  call heltable([16,8,128], n3(:,15186), t3x128(:,:,7261))
  call heltable([8,16,128], n3(:,15187), t3x128(:,:,7262))
  call heltable([8,16,128], n3(:,15188), t3x128(:,:,7263))
  call heltable([8,16,128], n3(:,15189), t3x128(:,:,7264))
  call heltable([8,16,128], n3(:,15190), t3x128(:,:,7265))
  call heltable([8,16,128], n3(:,15191), t3x128(:,:,7266))
  call heltable([8,16,128], n3(:,15192), t3x128(:,:,7267))
  call heltable([8,16,128], n3(:,15193), t3x128(:,:,7268))
  call heltable([8,16,128], n3(:,15194), t3x128(:,:,7269))
  call heltable([8,16,128], n3(:,15195), t3x128(:,:,7270))
  call heltable([8,16,128], n3(:,15196), t3x128(:,:,7271))
  call heltable([8,16,128], n3(:,15197), t3x128(:,:,7272))
  call heltable([8,16,128], n3(:,15198), t3x128(:,:,7273))
  call heltable([8,16,128], n3(:,15199), t3x128(:,:,7274))
  call heltable([16,8,128], n3(:,15200), t3x128(:,:,7275))
  call heltable([16,8,128], n3(:,15201), t3x128(:,:,7276))
  call heltable([16,8,128], n3(:,15202), t3x128(:,:,7277))
  call heltable([16,8,128], n3(:,15203), t3x128(:,:,7278))
  call heltable([16,8,128], n3(:,15204), t3x128(:,:,7279))
  call heltable([16,8,128], n3(:,15205), t3x128(:,:,7280))
  call heltable([16,8,128], n3(:,15206), t3x128(:,:,7281))
  call heltable([16,8,128], n3(:,15207), t3x128(:,:,7282))
  call heltable([16,8,128], n3(:,15208), t3x128(:,:,7283))
  call heltable([16,8,128], n3(:,15209), t3x128(:,:,7284))
  call heltable([16,8,128], n3(:,15210), t3x128(:,:,7285))
  call heltable([16,8,128], n3(:,15211), t3x128(:,:,7286))
  call heltable([16,8,128], n3(:,15212), t3x128(:,:,7287))
  call heltable([16,8,128], n3(:,15213), t3x128(:,:,7288))
  call heltable([16,8,128], n3(:,15214), t3x128(:,:,7289))
  call heltable([16,8,128], n3(:,15215), t3x128(:,:,7290))
  call heltable([8,16,128], n3(:,15216), t3x128(:,:,7291))
  call heltable([8,16,128], n3(:,15217), t3x128(:,:,7292))
  call heltable([8,16,128], n3(:,15218), t3x128(:,:,7293))
  call heltable([8,16,128], n3(:,15219), t3x128(:,:,7294))
  call heltable([8,16,128], n3(:,15220), t3x128(:,:,7295))
  call heltable([8,16,128], n3(:,15221), t3x128(:,:,7296))
  call heltable([8,16,128], n3(:,15222), t3x128(:,:,7297))
  call heltable([8,16,128], n3(:,15223), t3x128(:,:,7298))
  call heltable([8,16,128], n3(:,15224), t3x128(:,:,7299))
  call heltable([8,16,128], n3(:,15225), t3x128(:,:,7300))
  call heltable([8,16,128], n3(:,15226), t3x128(:,:,7301))
  call heltable([8,16,128], n3(:,15227), t3x128(:,:,7302))
  call heltable([8,16,128], n3(:,15228), t3x128(:,:,7303))
  call heltable([8,16,128], n3(:,15229), t3x128(:,:,7304))
  call heltable([8,16,128], n3(:,15230), t3x128(:,:,7305))
  call heltable([8,16,128], n3(:,15231), t3x128(:,:,7306))
  call heltable([16,8,128], n3(:,15232), t3x128(:,:,7307))
  call heltable([16,8,128], n3(:,15233), t3x128(:,:,7308))
  call heltable([16,8,128], n3(:,15234), t3x128(:,:,7309))
  call heltable([16,8,128], n3(:,15235), t3x128(:,:,7310))
  call heltable([16,8,128], n3(:,15236), t3x128(:,:,7311))
  call heltable([16,8,128], n3(:,15237), t3x128(:,:,7312))
  call heltable([16,8,128], n3(:,15238), t3x128(:,:,7313))
  call heltable([16,8,128], n3(:,15239), t3x128(:,:,7314))
  call heltable([16,8,128], n3(:,15240), t3x128(:,:,7315))
  call heltable([16,8,128], n3(:,15241), t3x128(:,:,7316))
  call heltable([16,8,128], n3(:,15242), t3x128(:,:,7317))
  call heltable([16,8,128], n3(:,15243), t3x128(:,:,7318))
  call heltable([16,8,128], n3(:,15244), t3x128(:,:,7319))
  call heltable([8,16,128], n3(:,15245), t3x128(:,:,7320))
  call heltable([8,16,128], n3(:,15246), t3x128(:,:,7321))
  call heltable([8,16,128], n3(:,15247), t3x128(:,:,7322))
  call heltable([8,16,128], n3(:,15248), t3x128(:,:,7323))
  call heltable([8,16,128], n3(:,15249), t3x128(:,:,7324))
  call heltable([8,16,128], n3(:,15250), t3x128(:,:,7325))
  call heltable([8,16,128], n3(:,15251), t3x128(:,:,7326))
  call heltable([8,16,128], n3(:,15252), t3x128(:,:,7327))
  call heltable([8,16,128], n3(:,15253), t3x128(:,:,7328))
  call heltable([8,16,128], n3(:,15254), t3x128(:,:,7329))
  call heltable([8,16,128], n3(:,15255), t3x128(:,:,7330))
  call heltable([8,16,128], n3(:,15256), t3x128(:,:,7331))
  call heltable([8,16,128], n3(:,15257), t3x128(:,:,7332))
  call heltable([8,16,128], n3(:,15258), t3x128(:,:,7333))
  call heltable([8,16,128], n3(:,15259), t3x128(:,:,7334))
  call heltable([8,16,128], n3(:,15260), t3x128(:,:,7335))
  call heltable([8,16,128], n3(:,15261), t3x128(:,:,7336))
  call heltable([8,16,128], n3(:,15262), t3x128(:,:,7337))
  call heltable([16,8,128], n3(:,15263), t3x128(:,:,7338))
  call heltable([16,8,128], n3(:,15264), t3x128(:,:,7339))
  call heltable([8,16,128], n3(:,15265), t3x128(:,:,7340))
  call heltable([8,16,128], n3(:,15266), t3x128(:,:,7341))
  call heltable([8,16,128], n3(:,15267), t3x128(:,:,7342))
  call heltable([8,16,128], n3(:,15268), t3x128(:,:,7343))
  call heltable([16,8,128], n3(:,15269), t3x128(:,:,7344))
  call heltable([16,8,128], n3(:,15270), t3x128(:,:,7345))
  call heltable([16,8,128], n3(:,15271), t3x128(:,:,7346))
  call heltable([16,8,128], n3(:,15272), t3x128(:,:,7347))
  call heltable([16,8,128], n3(:,15273), t3x128(:,:,7348))
  call heltable([16,8,128], n3(:,15274), t3x128(:,:,7349))
  call heltable([16,8,128], n3(:,15275), t3x128(:,:,7350))
  call heltable([16,8,128], n3(:,15276), t3x128(:,:,7351))
  call heltable([8,16,128], n3(:,15277), t3x128(:,:,7352))
  call heltable([8,16,128], n3(:,15278), t3x128(:,:,7353))
  call heltable([8,16,128], n3(:,15279), t3x128(:,:,7354))
  call heltable([8,16,128], n3(:,15280), t3x128(:,:,7355))
  call heltable([8,16,128], n3(:,15281), t3x128(:,:,7356))
  call heltable([8,16,128], n3(:,15282), t3x128(:,:,7357))
  call heltable([8,16,128], n3(:,15283), t3x128(:,:,7358))
  call heltable([8,16,128], n3(:,15284), t3x128(:,:,7359))
  call heltable([8,16,128], n3(:,15285), t3x128(:,:,7360))
  call heltable([8,16,128], n3(:,15286), t3x128(:,:,7361))
  call heltable([8,16,128], n3(:,15287), t3x128(:,:,7362))
  call heltable([8,16,128], n3(:,15288), t3x128(:,:,7363))
  call heltable([8,16,128], n3(:,15289), t3x128(:,:,7364))
  call heltable([8,16,128], n3(:,15290), t3x128(:,:,7365))
  call heltable([8,16,128], n3(:,15291), t3x128(:,:,7366))
  call heltable([8,16,128], n3(:,15292), t3x128(:,:,7367))
  call heltable([8,16,128], n3(:,15293), t3x128(:,:,7368))
  call heltable([8,16,128], n3(:,15294), t3x128(:,:,7369))
  call heltable([8,16,128], n3(:,15295), t3x128(:,:,7370))
  call heltable([8,16,128], n3(:,15296), t3x128(:,:,7371))
  call heltable([8,16,128], n3(:,15297), t3x128(:,:,7372))
  call heltable([8,16,128], n3(:,15298), t3x128(:,:,7373))
  call heltable([8,16,128], n3(:,15299), t3x128(:,:,7374))
  call heltable([8,16,128], n3(:,15300), t3x128(:,:,7375))
  call heltable([8,16,128], n3(:,15301), t3x128(:,:,7376))
  call heltable([8,16,128], n3(:,15302), t3x128(:,:,7377))
  call heltable([8,16,128], n3(:,15303), t3x128(:,:,7378))
  call heltable([8,16,128], n3(:,15304), t3x128(:,:,7379))
  call heltable([8,16,128], n3(:,15305), t3x128(:,:,7380))
  call heltable([8,16,128], n3(:,15306), t3x128(:,:,7381))
  call heltable([8,16,128], n3(:,15307), t3x128(:,:,7382))
  call heltable([8,16,128], n3(:,15308), t3x128(:,:,7383))
  call heltable([8,16,128], n3(:,15309), t3x128(:,:,7384))
  call heltable([8,16,128], n3(:,15310), t3x128(:,:,7385))
  call heltable([8,16,128], n3(:,15311), t3x128(:,:,7386))
  call heltable([8,16,128], n3(:,15312), t3x128(:,:,7387))
  call heltable([8,16,128], n3(:,15313), t3x128(:,:,7388))
  call heltable([8,16,128], n3(:,15314), t3x128(:,:,7389))
  call heltable([8,16,128], n3(:,15315), t3x128(:,:,7390))
  call heltable([8,16,128], n3(:,15316), t3x128(:,:,7391))
  call heltable([8,16,128], n3(:,15317), t3x128(:,:,7392))
  call heltable([8,16,128], n3(:,15318), t3x128(:,:,7393))
  call heltable([8,16,128], n3(:,15319), t3x128(:,:,7394))
  call heltable([8,16,128], n3(:,15320), t3x128(:,:,7395))
  call heltable([8,16,128], n3(:,15321), t3x128(:,:,7396))
  call heltable([8,16,128], n3(:,15322), t3x128(:,:,7397))
  call heltable([8,16,128], n3(:,15323), t3x128(:,:,7398))
  call heltable([8,16,128], n3(:,15324), t3x128(:,:,7399))
  call heltable([16,8,128], n3(:,15325), t3x128(:,:,7400))
  call heltable([16,8,128], n3(:,15326), t3x128(:,:,7401))
  call heltable([16,8,128], n3(:,15327), t3x128(:,:,7402))
  call heltable([16,8,128], n3(:,15328), t3x128(:,:,7403))
  call heltable([16,8,128], n3(:,15329), t3x128(:,:,7404))
  call heltable([16,8,128], n3(:,15330), t3x128(:,:,7405))
  call heltable([16,8,128], n3(:,15331), t3x128(:,:,7406))
  call heltable([16,8,128], n3(:,15332), t3x128(:,:,7407))
  call heltable([16,8,128], n3(:,15333), t3x128(:,:,7408))
  call heltable([16,8,128], n3(:,15334), t3x128(:,:,7409))
  call heltable([16,8,128], n3(:,15335), t3x128(:,:,7410))
  call heltable([16,8,128], n3(:,15336), t3x128(:,:,7411))
  call heltable([16,8,128], n3(:,15337), t3x128(:,:,7412))
  call heltable([8,16,128], n3(:,15338), t3x128(:,:,7413))
  call heltable([8,16,128], n3(:,15339), t3x128(:,:,7414))
  call heltable([8,16,128], n3(:,15340), t3x128(:,:,7415))
  call heltable([8,16,128], n3(:,15341), t3x128(:,:,7416))
  call heltable([8,16,128], n3(:,15342), t3x128(:,:,7417))
  call heltable([8,16,128], n3(:,15343), t3x128(:,:,7418))
  call heltable([8,16,128], n3(:,15344), t3x128(:,:,7419))
  call heltable([8,16,128], n3(:,15345), t3x128(:,:,7420))
  call heltable([8,16,128], n3(:,15346), t3x128(:,:,7421))
  call heltable([8,16,128], n3(:,15347), t3x128(:,:,7422))
  call heltable([8,16,128], n3(:,15348), t3x128(:,:,7423))
  call heltable([8,16,128], n3(:,15349), t3x128(:,:,7424))
  call heltable([8,16,128], n3(:,15350), t3x128(:,:,7425))
  call heltable([8,16,128], n3(:,15351), t3x128(:,:,7426))
  call heltable([8,16,128], n3(:,15352), t3x128(:,:,7427))
  call heltable([8,16,128], n3(:,15353), t3x128(:,:,7428))
  call heltable([8,16,128], n3(:,15354), t3x128(:,:,7429))
  call heltable([8,16,128], n3(:,15355), t3x128(:,:,7430))
  call heltable([8,16,128], n3(:,15356), t3x128(:,:,7431))
  call heltable([8,16,128], n3(:,15357), t3x128(:,:,7432))
  call heltable([8,16,128], n3(:,15358), t3x128(:,:,7433))
  call heltable([8,16,128], n3(:,15359), t3x128(:,:,7434))
  call heltable([8,16,128], n3(:,15360), t3x128(:,:,7435))
  call heltable([8,16,128], n3(:,15361), t3x128(:,:,7436))
  call heltable([8,16,128], n3(:,15362), t3x128(:,:,7437))
  call heltable([8,16,128], n3(:,15363), t3x128(:,:,7438))
  call heltable([8,16,128], n3(:,15364), t3x128(:,:,7439))
  call heltable([8,16,128], n3(:,15365), t3x128(:,:,7440))
  call heltable([8,16,128], n3(:,15366), t3x128(:,:,7441))
  call heltable([8,16,128], n3(:,15367), t3x128(:,:,7442))
  call heltable([8,16,128], n3(:,15368), t3x128(:,:,7443))
  call heltable([8,16,128], n3(:,15369), t3x128(:,:,7444))
  call heltable([8,16,128], n3(:,15370), t3x128(:,:,7445))
  call heltable([8,16,128], n3(:,15371), t3x128(:,:,7446))
  call heltable([8,16,128], n3(:,15372), t3x128(:,:,7447))
  call heltable([8,16,128], n3(:,15373), t3x128(:,:,7448))
  call heltable([8,16,128], n3(:,15374), t3x128(:,:,7449))
  call heltable([8,16,128], n3(:,15375), t3x128(:,:,7450))
  call heltable([8,16,128], n3(:,15376), t3x128(:,:,7451))
  call heltable([8,16,128], n3(:,15377), t3x128(:,:,7452))
  call heltable([8,16,128], n3(:,15378), t3x128(:,:,7453))
  call heltable([8,16,128], n3(:,15379), t3x128(:,:,7454))
  call heltable([8,16,128], n3(:,15380), t3x128(:,:,7455))
  call heltable([8,16,128], n3(:,15381), t3x128(:,:,7456))
  call heltable([8,16,128], n3(:,15382), t3x128(:,:,7457))
  call heltable([8,16,128], n3(:,15383), t3x128(:,:,7458))
  call heltable([8,16,128], n3(:,15384), t3x128(:,:,7459))
  call heltable([8,16,128], n3(:,15385), t3x128(:,:,7460))
  call heltable([8,16,128], n3(:,15386), t3x128(:,:,7461))
  call heltable([8,16,128], n3(:,15387), t3x128(:,:,7462))
  call heltable([8,16,128], n3(:,15388), t3x128(:,:,7463))
  call heltable([8,16,128], n3(:,15389), t3x128(:,:,7464))
  call heltable([8,16,128], n3(:,15390), t3x128(:,:,7465))
  call heltable([8,16,128], n3(:,15391), t3x128(:,:,7466))
  call heltable([8,16,128], n3(:,15392), t3x128(:,:,7467))
  call heltable([8,16,128], n3(:,15393), t3x128(:,:,7468))
  call heltable([8,16,128], n3(:,15394), t3x128(:,:,7469))
  call heltable([8,16,128], n3(:,15395), t3x128(:,:,7470))
  call heltable([8,16,128], n3(:,15396), t3x128(:,:,7471))
  call heltable([8,16,128], n3(:,15397), t3x128(:,:,7472))
  call heltable([8,16,128], n3(:,15398), t3x128(:,:,7473))
  call heltable([8,16,128], n3(:,15399), t3x128(:,:,7474))
  call heltable([8,16,128], n3(:,15400), t3x128(:,:,7475))
  call heltable([8,16,128], n3(:,15401), t3x128(:,:,7476))
  call heltable([8,16,128], n3(:,15402), t3x128(:,:,7477))
  call heltable([8,16,128], n3(:,15403), t3x128(:,:,7478))
  call heltable([8,16,128], n3(:,15404), t3x128(:,:,7479))
  call heltable([8,16,128], n3(:,15405), t3x128(:,:,7480))
  call heltable([8,16,128], n3(:,15406), t3x128(:,:,7481))
  call heltable([8,16,128], n3(:,15407), t3x128(:,:,7482))
  call heltable([8,16,128], n3(:,15408), t3x128(:,:,7483))
  call heltable([8,16,128], n3(:,15409), t3x128(:,:,7484))
  call heltable([8,16,128], n3(:,15410), t3x128(:,:,7485))
  call heltable([8,16,128], n3(:,15411), t3x128(:,:,7486))
  call heltable([8,16,128], n3(:,15412), t3x128(:,:,7487))
  call heltable([8,16,128], n3(:,15413), t3x128(:,:,7488))
  call heltable([8,16,128], n3(:,15414), t3x128(:,:,7489))
  call heltable([8,16,128], n3(:,15415), t3x128(:,:,7490))
  call heltable([8,16,128], n3(:,15416), t3x128(:,:,7491))
  call heltable([8,16,128], n3(:,15417), t3x128(:,:,7492))
  call heltable([8,16,128], n3(:,15418), t3x128(:,:,7493))
  call heltable([8,16,128], n3(:,15419), t3x128(:,:,7494))
  call heltable([8,16,128], n3(:,15420), t3x128(:,:,7495))
  call heltable([8,16,128], n3(:,15421), t3x128(:,:,7496))
  call heltable([8,16,128], n3(:,15422), t3x128(:,:,7497))
  call heltable([8,16,128], n3(:,15423), t3x128(:,:,7498))
  call heltable([8,16,128], n3(:,15424), t3x128(:,:,7499))
  call heltable([8,16,128], n3(:,15425), t3x128(:,:,7500))
  call heltable([8,16,128], n3(:,15426), t3x128(:,:,7501))
  call heltable([8,16,128], n3(:,15427), t3x128(:,:,7502))
  call heltable([8,16,128], n3(:,15428), t3x128(:,:,7503))
  call heltable([8,16,128], n3(:,15429), t3x128(:,:,7504))
  call heltable([8,16,128], n3(:,15430), t3x128(:,:,7505))
  call heltable([8,16,128], n3(:,15431), t3x128(:,:,7506))
  call heltable([8,16,128], n3(:,15432), t3x128(:,:,7507))
  call heltable([8,16,128], n3(:,15433), t3x128(:,:,7508))
  call heltable([8,16,128], n3(:,15434), t3x128(:,:,7509))
  call heltable([8,16,128], n3(:,15435), t3x128(:,:,7510))
  call heltable([8,16,128], n3(:,15436), t3x128(:,:,7511))
  call heltable([8,16,128], n3(:,15437), t3x128(:,:,7512))
  call heltable([8,16,128], n3(:,15438), t3x128(:,:,7513))
  call heltable([8,16,128], n3(:,15439), t3x128(:,:,7514))
  call heltable([8,16,128], n3(:,15440), t3x128(:,:,7515))
  call heltable([8,16,128], n3(:,15441), t3x128(:,:,7516))
  call heltable([8,16,128], n3(:,15442), t3x128(:,:,7517))
  call heltable([8,16,128], n3(:,15443), t3x128(:,:,7518))
  call heltable([8,16,128], n3(:,15444), t3x128(:,:,7519))
  call heltable([8,16,128], n3(:,15445), t3x128(:,:,7520))
  call heltable([8,16,128], n3(:,15446), t3x128(:,:,7521))
  call heltable([8,16,128], n3(:,15447), t3x128(:,:,7522))
  call heltable([8,16,128], n3(:,15448), t3x128(:,:,7523))
  call heltable([8,16,128], n3(:,15449), t3x128(:,:,7524))
  call heltable([8,16,128], n3(:,15450), t3x128(:,:,7525))
  call heltable([8,16,128], n3(:,15451), t3x128(:,:,7526))
  call heltable([8,16,128], n3(:,15452), t3x128(:,:,7527))
  call heltable([8,16,128], n3(:,15453), t3x128(:,:,7528))
  call heltable([8,16,128], n3(:,15454), t3x128(:,:,7529))
  call heltable([8,16,128], n3(:,15455), t3x128(:,:,7530))
  call heltable([8,16,128], n3(:,15456), t3x128(:,:,7531))
  call heltable([8,16,128], n3(:,15457), t3x128(:,:,7532))
  call heltable([8,16,128], n3(:,15458), t3x128(:,:,7533))
  call heltable([8,16,128], n3(:,15459), t3x128(:,:,7534))
  call heltable([8,16,128], n3(:,15460), t3x128(:,:,7535))
  call heltable([8,16,128], n3(:,15461), t3x128(:,:,7536))
  call heltable([8,16,128], n3(:,15462), t3x128(:,:,7537))
  call heltable([8,16,128], n3(:,15463), t3x128(:,:,7538))
  call heltable([8,16,128], n3(:,15464), t3x128(:,:,7539))
  call heltable([8,16,128], n3(:,15465), t3x128(:,:,7540))
  call heltable([8,16,128], n3(:,15466), t3x128(:,:,7541))
  call heltable([8,16,128], n3(:,15467), t3x128(:,:,7542))
  call heltable([8,16,128], n3(:,15468), t3x128(:,:,7543))
  call heltable([8,16,128], n3(:,15469), t3x128(:,:,7544))
  call heltable([8,16,128], n3(:,15470), t3x128(:,:,7545))
  call heltable([8,16,128], n3(:,15471), t3x128(:,:,7546))
  call heltable([8,16,128], n3(:,15472), t3x128(:,:,7547))
  call heltable([8,16,128], n3(:,15473), t3x128(:,:,7548))
  call heltable([8,16,128], n3(:,15474), t3x128(:,:,7549))
  call heltable([8,16,128], n3(:,15475), t3x128(:,:,7550))
  call heltable([8,16,128], n3(:,15476), t3x128(:,:,7551))
  call heltable([8,16,128], n3(:,15477), t3x128(:,:,7552))
  call heltable([8,16,128], n3(:,15478), t3x128(:,:,7553))
  call heltable([8,16,128], n3(:,15479), t3x128(:,:,7554))
  call heltable([8,16,128], n3(:,15480), t3x128(:,:,7555))
  call heltable([8,16,128], n3(:,15481), t3x128(:,:,7556))
  call heltable([8,16,128], n3(:,15482), t3x128(:,:,7557))
  call heltable([8,16,128], n3(:,15483), t3x128(:,:,7558))
  call heltable([8,16,128], n3(:,15484), t3x128(:,:,7559))
  call heltable([8,16,128], n3(:,15485), t3x128(:,:,7560))
  call heltable([8,16,128], n3(:,15486), t3x128(:,:,7561))
  call heltable([8,16,128], n3(:,15487), t3x128(:,:,7562))
  call heltable([8,16,128], n3(:,15488), t3x128(:,:,7563))
  call heltable([8,16,128], n3(:,15489), t3x128(:,:,7564))
  call heltable([8,16,128], n3(:,15490), t3x128(:,:,7565))
  call heltable([8,16,128], n3(:,15491), t3x128(:,:,7566))
  call heltable([8,16,128], n3(:,15492), t3x128(:,:,7567))
  call heltable([8,16,128], n3(:,15493), t3x128(:,:,7568))
  call heltable([8,16,128], n3(:,15494), t3x128(:,:,7569))
  call heltable([8,16,128], n3(:,15495), t3x128(:,:,7570))
  call heltable([8,16,128], n3(:,15496), t3x128(:,:,7571))
  call heltable([8,16,128], n3(:,15497), t3x128(:,:,7572))
  call heltable([8,16,128], n3(:,15498), t3x128(:,:,7573))
  call heltable([8,16,128], n3(:,15499), t3x128(:,:,7574))
  call heltable([8,16,128], n3(:,15500), t3x128(:,:,7575))
  call heltable([8,16,128], n3(:,15501), t3x128(:,:,7576))
  call heltable([8,16,128], n3(:,15502), t3x128(:,:,7577))
  call heltable([8,16,128], n3(:,15503), t3x128(:,:,7578))
  call heltable([8,16,128], n3(:,15504), t3x128(:,:,7579))
  call heltable([8,16,128], n3(:,15505), t3x128(:,:,7580))
  call heltable([8,16,128], n3(:,15506), t3x128(:,:,7581))
  call heltable([8,16,128], n3(:,15507), t3x128(:,:,7582))
  call heltable([8,16,128], n3(:,15508), t3x128(:,:,7583))
  call heltable([8,16,128], n3(:,15509), t3x128(:,:,7584))
  call heltable([8,16,128], n3(:,15510), t3x128(:,:,7585))
  call heltable([8,16,128], n3(:,15511), t3x128(:,:,7586))
  call heltable([8,16,128], n3(:,15512), t3x128(:,:,7587))
  call heltable([8,16,128], n3(:,15513), t3x128(:,:,7588))
  call heltable([8,16,128], n3(:,15514), t3x128(:,:,7589))
  call heltable([8,16,128], n3(:,15515), t3x128(:,:,7590))
  call heltable([8,16,128], n3(:,15516), t3x128(:,:,7591))
  call heltable([8,16,128], n3(:,15517), t3x128(:,:,7592))
  call heltable([8,16,128], n3(:,15518), t3x128(:,:,7593))
  call heltable([8,16,128], n3(:,15519), t3x128(:,:,7594))
  call heltable([8,16,128], n3(:,15520), t3x128(:,:,7595))
  call heltable([8,16,128], n3(:,15521), t3x128(:,:,7596))
  call heltable([8,16,128], n3(:,15522), t3x128(:,:,7597))
  call heltable([8,16,128], n3(:,15523), t3x128(:,:,7598))
  call heltable([8,16,128], n3(:,15524), t3x128(:,:,7599))
  call heltable([8,16,128], n3(:,15525), t3x128(:,:,7600))
  call heltable([8,16,128], n3(:,15526), t3x128(:,:,7601))
  call heltable([8,16,128], n3(:,15527), t3x128(:,:,7602))
  call heltable([8,16,128], n3(:,15528), t3x128(:,:,7603))
  call heltable([8,16,128], n3(:,15529), t3x128(:,:,7604))
  call heltable([8,16,128], n3(:,15530), t3x128(:,:,7605))
  call heltable([8,16,128], n3(:,15531), t3x128(:,:,7606))
  call heltable([8,16,128], n3(:,15532), t3x128(:,:,7607))
  call heltable([8,16,128], n3(:,15533), t3x128(:,:,7608))
  call heltable([8,16,128], n3(:,15534), t3x128(:,:,7609))
  call heltable([8,16,128], n3(:,15535), t3x128(:,:,7610))
  call heltable([8,16,128], n3(:,15536), t3x128(:,:,7611))
  call heltable([8,16,128], n3(:,15537), t3x128(:,:,7612))
  call heltable([8,16,128], n3(:,15538), t3x128(:,:,7613))
  call heltable([8,16,128], n3(:,15539), t3x128(:,:,7614))
  call heltable([8,16,128], n3(:,15540), t3x128(:,:,7615))
  call heltable([8,16,128], n3(:,15541), t3x128(:,:,7616))
  call heltable([8,16,128], n3(:,15542), t3x128(:,:,7617))
  call heltable([8,16,128], n3(:,15543), t3x128(:,:,7618))
  call heltable([8,16,128], n3(:,15544), t3x128(:,:,7619))
  call heltable([8,16,128], n3(:,15545), t3x128(:,:,7620))
  call heltable([16,8,128], n3(:,15546), t3x128(:,:,7621))
  call heltable([16,8,128], n3(:,15547), t3x128(:,:,7622))
  call heltable([16,8,128], n3(:,15548), t3x128(:,:,7623))
  call heltable([16,8,128], n3(:,15549), t3x128(:,:,7624))
  call heltable([16,8,128], n3(:,15550), t3x128(:,:,7625))
  call heltable([16,8,128], n3(:,15551), t3x128(:,:,7626))
  call heltable([16,8,128], n3(:,15552), t3x128(:,:,7627))
  call heltable([16,8,128], n3(:,15553), t3x128(:,:,7628))
  call heltable([16,8,128], n3(:,15554), t3x128(:,:,7629))
  call heltable([16,8,128], n3(:,15555), t3x128(:,:,7630))
  call heltable([16,8,128], n3(:,15556), t3x128(:,:,7631))
  call heltable([16,8,128], n3(:,15557), t3x128(:,:,7632))
  call heltable([16,8,128], n3(:,15558), t3x128(:,:,7633))
  call heltable([16,8,128], n3(:,15559), t3x128(:,:,7634))
  call heltable([16,8,128], n3(:,15560), t3x128(:,:,7635))
  call heltable([16,8,128], n3(:,15561), t3x128(:,:,7636))
  call heltable([16,8,128], n3(:,15562), t3x128(:,:,7637))
  call heltable([16,8,128], n3(:,15563), t3x128(:,:,7638))
  call heltable([16,8,128], n3(:,15564), t3x128(:,:,7639))
  call heltable([16,8,128], n3(:,15565), t3x128(:,:,7640))
  call heltable([16,8,128], n3(:,15566), t3x128(:,:,7641))
  call heltable([16,8,128], n3(:,15567), t3x128(:,:,7642))
  call heltable([16,8,128], n3(:,15568), t3x128(:,:,7643))
  call heltable([16,8,128], n3(:,15569), t3x128(:,:,7644))
  call heltable([16,8,128], n3(:,15570), t3x128(:,:,7645))
  call heltable([16,8,128], n3(:,15571), t3x128(:,:,7646))
  call heltable([16,8,128], n3(:,15572), t3x128(:,:,7647))
  call heltable([16,8,128], n3(:,15573), t3x128(:,:,7648))
  call heltable([16,8,128], n3(:,15574), t3x128(:,:,7649))
  call heltable([16,8,128], n3(:,15575), t3x128(:,:,7650))
  call heltable([16,8,128], n3(:,15576), t3x128(:,:,7651))
  call heltable([16,8,128], n3(:,15577), t3x128(:,:,7652))
  call heltable([8,16,128], n3(:,15578), t3x128(:,:,7653))
  call heltable([8,16,128], n3(:,15579), t3x128(:,:,7654))
  call heltable([8,16,128], n3(:,15580), t3x128(:,:,7655))
  call heltable([8,16,128], n3(:,15581), t3x128(:,:,7656))
  call heltable([8,16,128], n3(:,15582), t3x128(:,:,7657))
  call heltable([8,16,128], n3(:,15583), t3x128(:,:,7658))
  call heltable([8,16,128], n3(:,15584), t3x128(:,:,7659))
  call heltable([8,16,128], n3(:,15585), t3x128(:,:,7660))
  call heltable([8,16,128], n3(:,15586), t3x128(:,:,7661))
  call heltable([8,16,128], n3(:,15587), t3x128(:,:,7662))
  call heltable([8,16,128], n3(:,15588), t3x128(:,:,7663))
  call heltable([8,16,128], n3(:,15589), t3x128(:,:,7664))
  call heltable([8,16,128], n3(:,15590), t3x128(:,:,7665))
  call heltable([8,16,128], n3(:,15591), t3x128(:,:,7666))
  call heltable([8,16,128], n3(:,15592), t3x128(:,:,7667))
  call heltable([8,16,128], n3(:,15593), t3x128(:,:,7668))
  call heltable([8,16,128], n3(:,15594), t3x128(:,:,7669))
  call heltable([8,16,128], n3(:,15595), t3x128(:,:,7670))
  call heltable([8,16,128], n3(:,15596), t3x128(:,:,7671))
  call heltable([8,16,128], n3(:,15597), t3x128(:,:,7672))
  call heltable([8,16,128], n3(:,15598), t3x128(:,:,7673))
  call heltable([8,16,128], n3(:,15599), t3x128(:,:,7674))
  call heltable([8,16,128], n3(:,15600), t3x128(:,:,7675))
  call heltable([8,16,128], n3(:,15601), t3x128(:,:,7676))
  call heltable([8,16,128], n3(:,15602), t3x128(:,:,7677))
  call heltable([8,16,128], n3(:,15603), t3x128(:,:,7678))
  call heltable([8,16,128], n3(:,15604), t3x128(:,:,7679))
  call heltable([8,16,128], n3(:,15605), t3x128(:,:,7680))
  call heltable([8,16,128], n3(:,15606), t3x128(:,:,7681))
  call heltable([8,16,128], n3(:,15607), t3x128(:,:,7682))
  call heltable([8,16,128], n3(:,15608), t3x128(:,:,7683))
  call heltable([8,16,128], n3(:,15609), t3x128(:,:,7684))
  call heltable([16,8,128], n3(:,15610), t3x128(:,:,7685))
  call heltable([16,8,128], n3(:,15611), t3x128(:,:,7686))
  call heltable([16,8,128], n3(:,15612), t3x128(:,:,7687))
  call heltable([16,8,128], n3(:,15613), t3x128(:,:,7688))
  call heltable([16,8,128], n3(:,15614), t3x128(:,:,7689))
  call heltable([16,8,128], n3(:,15615), t3x128(:,:,7690))
  call heltable([16,8,128], n3(:,15616), t3x128(:,:,7691))
  call heltable([16,8,128], n3(:,15617), t3x128(:,:,7692))
  call heltable([16,8,128], n3(:,15618), t3x128(:,:,7693))
  call heltable([16,8,128], n3(:,15619), t3x128(:,:,7694))
  call heltable([16,8,128], n3(:,15620), t3x128(:,:,7695))
  call heltable([16,8,128], n3(:,15621), t3x128(:,:,7696))
  call heltable([16,8,128], n3(:,15622), t3x128(:,:,7697))
  call heltable([16,8,128], n3(:,15623), t3x128(:,:,7698))
  call heltable([16,8,128], n3(:,15624), t3x128(:,:,7699))
  call heltable([16,8,128], n3(:,15625), t3x128(:,:,7700))
  call heltable([16,8,128], n3(:,15626), t3x128(:,:,7701))
  call heltable([16,8,128], n3(:,15627), t3x128(:,:,7702))
  call heltable([16,8,128], n3(:,15628), t3x128(:,:,7703))
  call heltable([16,8,128], n3(:,15629), t3x128(:,:,7704))
  call heltable([16,8,128], n3(:,15630), t3x128(:,:,7705))
  call heltable([16,8,128], n3(:,15631), t3x128(:,:,7706))
  call heltable([16,8,128], n3(:,15632), t3x128(:,:,7707))
  call heltable([16,8,128], n3(:,15633), t3x128(:,:,7708))
  call heltable([16,8,128], n3(:,15634), t3x128(:,:,7709))
  call heltable([16,8,128], n3(:,15635), t3x128(:,:,7710))
  call heltable([16,8,128], n3(:,15636), t3x128(:,:,7711))
  call heltable([16,8,128], n3(:,15637), t3x128(:,:,7712))
  call heltable([16,8,128], n3(:,15638), t3x128(:,:,7713))
  call heltable([16,8,128], n3(:,15639), t3x128(:,:,7714))
  call heltable([16,8,128], n3(:,15640), t3x128(:,:,7715))
  call heltable([16,8,128], n3(:,15641), t3x128(:,:,7716))
  call heltable([8,16,128], n3(:,15642), t3x128(:,:,7717))
  call heltable([8,16,128], n3(:,15643), t3x128(:,:,7718))
  call heltable([8,16,128], n3(:,15644), t3x128(:,:,7719))
  call heltable([8,16,128], n3(:,15645), t3x128(:,:,7720))
  call heltable([8,16,128], n3(:,15646), t3x128(:,:,7721))
  call heltable([8,16,128], n3(:,15647), t3x128(:,:,7722))
  call heltable([8,16,128], n3(:,15648), t3x128(:,:,7723))
  call heltable([8,16,128], n3(:,15649), t3x128(:,:,7724))
  call heltable([8,16,128], n3(:,15650), t3x128(:,:,7725))
  call heltable([8,16,128], n3(:,15651), t3x128(:,:,7726))
  call heltable([8,16,128], n3(:,15652), t3x128(:,:,7727))
  call heltable([8,16,128], n3(:,15653), t3x128(:,:,7728))
  call heltable([8,16,128], n3(:,15654), t3x128(:,:,7729))
  call heltable([8,16,128], n3(:,15655), t3x128(:,:,7730))
  call heltable([8,16,128], n3(:,15656), t3x128(:,:,7731))
  call heltable([8,16,128], n3(:,15657), t3x128(:,:,7732))
  call heltable([8,16,128], n3(:,15658), t3x128(:,:,7733))
  call heltable([8,16,128], n3(:,15659), t3x128(:,:,7734))
  call heltable([8,16,128], n3(:,15660), t3x128(:,:,7735))
  call heltable([8,16,128], n3(:,15661), t3x128(:,:,7736))
  call heltable([8,16,128], n3(:,15662), t3x128(:,:,7737))
  call heltable([8,16,128], n3(:,15663), t3x128(:,:,7738))
  call heltable([8,16,128], n3(:,15664), t3x128(:,:,7739))
  call heltable([8,16,128], n3(:,15665), t3x128(:,:,7740))
  call heltable([8,16,128], n3(:,15666), t3x128(:,:,7741))
  call heltable([8,16,128], n3(:,15667), t3x128(:,:,7742))
  call heltable([8,16,128], n3(:,15668), t3x128(:,:,7743))
  call heltable([8,16,128], n3(:,15669), t3x128(:,:,7744))
  call heltable([8,16,128], n3(:,15670), t3x128(:,:,7745))
  call heltable([8,16,128], n3(:,15671), t3x128(:,:,7746))
  call heltable([8,16,128], n3(:,15672), t3x128(:,:,7747))
  call heltable([8,16,128], n3(:,15673), t3x128(:,:,7748))
  call heltable([8,16,128], n3(:,15674), t3x128(:,:,7749))
  call heltable([8,16,128], n3(:,15675), t3x128(:,:,7750))
  call heltable([8,16,128], n3(:,15676), t3x128(:,:,7751))
  call heltable([8,16,128], n3(:,15677), t3x128(:,:,7752))
  call heltable([8,16,128], n3(:,15678), t3x128(:,:,7753))
  call heltable([8,16,128], n3(:,15679), t3x128(:,:,7754))
  call heltable([8,16,128], n3(:,15680), t3x128(:,:,7755))
  call heltable([8,16,128], n3(:,15681), t3x128(:,:,7756))
  call heltable([8,16,128], n3(:,15682), t3x128(:,:,7757))
  call heltable([8,16,128], n3(:,15683), t3x128(:,:,7758))
  call heltable([8,16,128], n3(:,15684), t3x128(:,:,7759))
  call heltable([8,16,128], n3(:,15685), t3x128(:,:,7760))
  call heltable([8,16,128], n3(:,15686), t3x128(:,:,7761))
  call heltable([8,16,128], n3(:,15687), t3x128(:,:,7762))
  call heltable([8,16,128], n3(:,15688), t3x128(:,:,7763))
  call heltable([8,16,128], n3(:,15689), t3x128(:,:,7764))
  call heltable([16,8,128], n3(:,15690), t3x128(:,:,7765))
  call heltable([16,8,128], n3(:,15691), t3x128(:,:,7766))
  call heltable([16,8,128], n3(:,15692), t3x128(:,:,7767))
  call heltable([16,8,128], n3(:,15693), t3x128(:,:,7768))
  call heltable([16,8,128], n3(:,15694), t3x128(:,:,7769))
  call heltable([16,8,128], n3(:,15695), t3x128(:,:,7770))
  call heltable([16,8,128], n3(:,15696), t3x128(:,:,7771))
  call heltable([16,8,128], n3(:,15697), t3x128(:,:,7772))
  call heltable([16,8,128], n3(:,15698), t3x128(:,:,7773))
  call heltable([16,8,128], n3(:,15699), t3x128(:,:,7774))
  call heltable([16,8,128], n3(:,15700), t3x128(:,:,7775))
  call heltable([16,8,128], n3(:,15701), t3x128(:,:,7776))
  call heltable([16,8,128], n3(:,15702), t3x128(:,:,7777))
  call heltable([16,8,128], n3(:,15703), t3x128(:,:,7778))
  call heltable([16,8,128], n3(:,15704), t3x128(:,:,7779))
  call heltable([16,8,128], n3(:,15705), t3x128(:,:,7780))
  call heltable([16,8,128], n3(:,15706), t3x128(:,:,7781))
  call heltable([16,8,128], n3(:,15707), t3x128(:,:,7782))
  call heltable([16,8,128], n3(:,15708), t3x128(:,:,7783))
  call heltable([16,8,128], n3(:,15709), t3x128(:,:,7784))
  call heltable([16,8,128], n3(:,15710), t3x128(:,:,7785))
  call heltable([16,8,128], n3(:,15711), t3x128(:,:,7786))
  call heltable([16,8,128], n3(:,15712), t3x128(:,:,7787))
  call heltable([16,8,128], n3(:,15713), t3x128(:,:,7788))
  call heltable([16,8,128], n3(:,15714), t3x128(:,:,7789))
  call heltable([16,8,128], n3(:,15715), t3x128(:,:,7790))
  call heltable([16,8,128], n3(:,15716), t3x128(:,:,7791))
  call heltable([16,8,128], n3(:,15717), t3x128(:,:,7792))
  call heltable([16,8,128], n3(:,15718), t3x128(:,:,7793))
  call heltable([16,8,128], n3(:,15719), t3x128(:,:,7794))
  call heltable([16,8,128], n3(:,15720), t3x128(:,:,7795))
  call heltable([16,8,128], n3(:,15721), t3x128(:,:,7796))
  call heltable([16,8,128], n3(:,15722), t3x128(:,:,7797))
  call heltable([16,8,128], n3(:,15723), t3x128(:,:,7798))
  call heltable([16,8,128], n3(:,15724), t3x128(:,:,7799))
  call heltable([16,8,128], n3(:,15725), t3x128(:,:,7800))
  call heltable([16,8,128], n3(:,15726), t3x128(:,:,7801))
  call heltable([16,8,128], n3(:,15727), t3x128(:,:,7802))
  call heltable([16,8,128], n3(:,15728), t3x128(:,:,7803))
  call heltable([16,8,128], n3(:,15729), t3x128(:,:,7804))
  call heltable([16,8,128], n3(:,15730), t3x128(:,:,7805))
  call heltable([16,8,128], n3(:,15731), t3x128(:,:,7806))
  call heltable([16,8,128], n3(:,15732), t3x128(:,:,7807))
  call heltable([16,8,128], n3(:,15733), t3x128(:,:,7808))
  call heltable([16,8,128], n3(:,15734), t3x128(:,:,7809))
  call heltable([16,8,128], n3(:,15735), t3x128(:,:,7810))
  call heltable([16,8,128], n3(:,15736), t3x128(:,:,7811))
  call heltable([16,8,128], n3(:,15737), t3x128(:,:,7812))
  call heltable([8,16,128], n3(:,15738), t3x128(:,:,7813))
  call heltable([8,16,128], n3(:,15739), t3x128(:,:,7814))
  call heltable([8,16,128], n3(:,15740), t3x128(:,:,7815))
  call heltable([8,16,128], n3(:,15741), t3x128(:,:,7816))
  call heltable([8,16,128], n3(:,15742), t3x128(:,:,7817))
  call heltable([8,16,128], n3(:,15743), t3x128(:,:,7818))
  call heltable([8,16,128], n3(:,15744), t3x128(:,:,7819))
  call heltable([8,16,128], n3(:,15745), t3x128(:,:,7820))
  call heltable([8,16,128], n3(:,15746), t3x128(:,:,7821))
  call heltable([8,16,128], n3(:,15747), t3x128(:,:,7822))
  call heltable([8,16,128], n3(:,15748), t3x128(:,:,7823))
  call heltable([8,16,128], n3(:,15749), t3x128(:,:,7824))
  call heltable([8,16,128], n3(:,15750), t3x128(:,:,7825))
  call heltable([16,8,128], n3(:,15751), t3x128(:,:,7826))
  call heltable([16,8,128], n3(:,15752), t3x128(:,:,7827))
  call heltable([16,8,128], n3(:,15753), t3x128(:,:,7828))
  call heltable([16,8,128], n3(:,15754), t3x128(:,:,7829))
  call heltable([16,8,128], n3(:,15755), t3x128(:,:,7830))
  call heltable([16,8,128], n3(:,15756), t3x128(:,:,7831))
  call heltable([16,8,128], n3(:,15757), t3x128(:,:,7832))
  call heltable([16,8,128], n3(:,15758), t3x128(:,:,7833))
  call heltable([16,8,128], n3(:,15759), t3x128(:,:,7834))
  call heltable([16,8,128], n3(:,15760), t3x128(:,:,7835))
  call heltable([16,8,128], n3(:,15761), t3x128(:,:,7836))
  call heltable([16,8,128], n3(:,15762), t3x128(:,:,7837))
  call heltable([16,8,128], n3(:,15763), t3x128(:,:,7838))
  call heltable([16,8,128], n3(:,15764), t3x128(:,:,7839))
  call heltable([16,8,128], n3(:,15765), t3x128(:,:,7840))
  call heltable([16,8,128], n3(:,15766), t3x128(:,:,7841))
  call heltable([8,16,128], n3(:,15767), t3x128(:,:,7842))
  call heltable([8,16,128], n3(:,15768), t3x128(:,:,7843))
  call heltable([8,16,128], n3(:,15769), t3x128(:,:,7844))
  call heltable([8,16,128], n3(:,15770), t3x128(:,:,7845))
  call heltable([8,16,128], n3(:,15771), t3x128(:,:,7846))
  call heltable([8,16,128], n3(:,15772), t3x128(:,:,7847))
  call heltable([8,16,128], n3(:,15773), t3x128(:,:,7848))
  call heltable([8,16,128], n3(:,15774), t3x128(:,:,7849))
  call heltable([8,16,128], n3(:,15775), t3x128(:,:,7850))
  call heltable([8,16,128], n3(:,15776), t3x128(:,:,7851))
  call heltable([8,16,128], n3(:,15777), t3x128(:,:,7852))
  call heltable([8,16,128], n3(:,15778), t3x128(:,:,7853))
  call heltable([8,16,128], n3(:,15779), t3x128(:,:,7854))
  call heltable([8,16,128], n3(:,15780), t3x128(:,:,7855))
  call heltable([8,16,128], n3(:,15781), t3x128(:,:,7856))
  call heltable([8,16,128], n3(:,15782), t3x128(:,:,7857))
  call heltable([8,16,128], n3(:,15783), t3x128(:,:,7858))
  call heltable([8,16,128], n3(:,15784), t3x128(:,:,7859))
  call heltable([8,16,128], n3(:,15785), t3x128(:,:,7860))
  call heltable([8,16,128], n3(:,15786), t3x128(:,:,7861))
  call heltable([8,16,128], n3(:,15787), t3x128(:,:,7862))
  call heltable([8,16,128], n3(:,15788), t3x128(:,:,7863))
  call heltable([8,16,128], n3(:,15789), t3x128(:,:,7864))
  call heltable([8,16,128], n3(:,15790), t3x128(:,:,7865))
  call heltable([8,16,128], n3(:,15791), t3x128(:,:,7866))
  call heltable([8,16,128], n3(:,15792), t3x128(:,:,7867))
  call heltable([8,16,128], n3(:,15793), t3x128(:,:,7868))
  call heltable([8,16,128], n3(:,15794), t3x128(:,:,7869))
  call heltable([8,16,128], n3(:,15795), t3x128(:,:,7870))
  call heltable([8,16,128], n3(:,15796), t3x128(:,:,7871))
  call heltable([8,16,128], n3(:,15797), t3x128(:,:,7872))
  call heltable([8,16,128], n3(:,15798), t3x128(:,:,7873))
  call heltable([8,16,128], n3(:,15799), t3x128(:,:,7874))
  call heltable([8,16,128], n3(:,15800), t3x128(:,:,7875))
  call heltable([8,16,128], n3(:,15801), t3x128(:,:,7876))
  call heltable([8,16,128], n3(:,15802), t3x128(:,:,7877))
  call heltable([8,16,128], n3(:,15803), t3x128(:,:,7878))
  call heltable([8,16,128], n3(:,15804), t3x128(:,:,7879))
  call heltable([8,16,128], n3(:,15805), t3x128(:,:,7880))
  call heltable([8,16,128], n3(:,15806), t3x128(:,:,7881))
  call heltable([8,16,128], n3(:,15807), t3x128(:,:,7882))
  call heltable([8,16,128], n3(:,15808), t3x128(:,:,7883))
  call heltable([8,16,128], n3(:,15809), t3x128(:,:,7884))
  call heltable([8,16,128], n3(:,15810), t3x128(:,:,7885))
  call heltable([8,16,128], n3(:,15811), t3x128(:,:,7886))
  call heltable([16,8,128], n3(:,15812), t3x128(:,:,7887))
  call heltable([16,8,128], n3(:,15813), t3x128(:,:,7888))
  call heltable([16,8,128], n3(:,15814), t3x128(:,:,7889))
  call heltable([16,8,128], n3(:,15815), t3x128(:,:,7890))
  call heltable([16,8,128], n3(:,15816), t3x128(:,:,7891))
  call heltable([16,8,128], n3(:,15817), t3x128(:,:,7892))
  call heltable([16,8,128], n3(:,15818), t3x128(:,:,7893))
  call heltable([16,8,128], n3(:,15819), t3x128(:,:,7894))
  call heltable([16,8,128], n3(:,15820), t3x128(:,:,7895))
  call heltable([16,8,128], n3(:,15821), t3x128(:,:,7896))
  call heltable([16,8,128], n3(:,15822), t3x128(:,:,7897))
  call heltable([16,8,128], n3(:,15823), t3x128(:,:,7898))
  call heltable([16,8,128], n3(:,15824), t3x128(:,:,7899))
  call heltable([16,8,128], n3(:,15825), t3x128(:,:,7900))
  call heltable([16,8,128], n3(:,15826), t3x128(:,:,7901))
  call heltable([16,8,128], n3(:,15827), t3x128(:,:,7902))
  call heltable([16,8,128], n3(:,15828), t3x128(:,:,7903))
  call heltable([16,8,128], n3(:,15829), t3x128(:,:,7904))
  call heltable([16,8,128], n3(:,15830), t3x128(:,:,7905))
  call heltable([16,8,128], n3(:,15831), t3x128(:,:,7906))
  call heltable([16,8,128], n3(:,15832), t3x128(:,:,7907))
  call heltable([16,8,128], n3(:,15833), t3x128(:,:,7908))
  call heltable([16,8,128], n3(:,15834), t3x128(:,:,7909))
  call heltable([16,8,128], n3(:,15835), t3x128(:,:,7910))
  call heltable([16,8,128], n3(:,15836), t3x128(:,:,7911))
  call heltable([16,8,128], n3(:,15837), t3x128(:,:,7912))
  call heltable([16,8,128], n3(:,15838), t3x128(:,:,7913))
  call heltable([16,8,128], n3(:,15839), t3x128(:,:,7914))
  call heltable([16,8,128], n3(:,15840), t3x128(:,:,7915))
  call heltable([16,8,128], n3(:,15841), t3x128(:,:,7916))
  call heltable([16,8,128], n3(:,15842), t3x128(:,:,7917))
  call heltable([16,8,128], n3(:,15843), t3x128(:,:,7918))
  call heltable([8,16,128], n3(:,15844), t3x128(:,:,7919))
  call heltable([8,16,128], n3(:,15845), t3x128(:,:,7920))
  call heltable([8,16,128], n3(:,15846), t3x128(:,:,7921))
  call heltable([8,16,128], n3(:,15847), t3x128(:,:,7922))
  call heltable([8,16,128], n3(:,15848), t3x128(:,:,7923))
  call heltable([8,16,128], n3(:,15849), t3x128(:,:,7924))
  call heltable([8,16,128], n3(:,15850), t3x128(:,:,7925))
  call heltable([8,16,128], n3(:,15851), t3x128(:,:,7926))
  call heltable([8,16,128], n3(:,15852), t3x128(:,:,7927))
  call heltable([8,16,128], n3(:,15853), t3x128(:,:,7928))
  call heltable([8,16,128], n3(:,15854), t3x128(:,:,7929))
  call heltable([8,16,128], n3(:,15855), t3x128(:,:,7930))
  call heltable([8,16,128], n3(:,15856), t3x128(:,:,7931))
  call heltable([8,16,128], n3(:,15857), t3x128(:,:,7932))
  call heltable([8,16,128], n3(:,15858), t3x128(:,:,7933))
  call heltable([8,16,128], n3(:,15859), t3x128(:,:,7934))
  call heltable([16,8,128], n3(:,15860), t3x128(:,:,7935))
  call heltable([16,8,128], n3(:,15861), t3x128(:,:,7936))
  call heltable([16,8,128], n3(:,15862), t3x128(:,:,7937))
  call heltable([16,8,128], n3(:,15863), t3x128(:,:,7938))
  call heltable([16,8,128], n3(:,15864), t3x128(:,:,7939))
  call heltable([16,8,128], n3(:,15865), t3x128(:,:,7940))
  call heltable([16,8,128], n3(:,15866), t3x128(:,:,7941))
  call heltable([16,8,128], n3(:,15867), t3x128(:,:,7942))
  call heltable([16,8,128], n3(:,15868), t3x128(:,:,7943))
  call heltable([16,8,128], n3(:,15869), t3x128(:,:,7944))
  call heltable([16,8,128], n3(:,15870), t3x128(:,:,7945))
  call heltable([16,8,128], n3(:,15871), t3x128(:,:,7946))
  call heltable([16,8,128], n3(:,15872), t3x128(:,:,7947))
  call heltable([16,8,128], n3(:,15873), t3x128(:,:,7948))
  call heltable([16,8,128], n3(:,15874), t3x128(:,:,7949))
  call heltable([16,8,128], n3(:,15875), t3x128(:,:,7950))
  call heltable([16,8,128], n3(:,15876), t3x128(:,:,7951))
  call heltable([16,8,128], n3(:,15877), t3x128(:,:,7952))
  call heltable([16,8,128], n3(:,15878), t3x128(:,:,7953))
  call heltable([16,8,128], n3(:,15879), t3x128(:,:,7954))
  call heltable([16,8,128], n3(:,15880), t3x128(:,:,7955))
  call heltable([16,8,128], n3(:,15881), t3x128(:,:,7956))
  call heltable([16,8,128], n3(:,15882), t3x128(:,:,7957))
  call heltable([16,8,128], n3(:,15883), t3x128(:,:,7958))
  call heltable([16,8,128], n3(:,15884), t3x128(:,:,7959))
  call heltable([16,8,128], n3(:,15885), t3x128(:,:,7960))
  call heltable([16,8,128], n3(:,15886), t3x128(:,:,7961))
  call heltable([16,8,128], n3(:,15887), t3x128(:,:,7962))
  call heltable([16,8,128], n3(:,15888), t3x128(:,:,7963))
  call heltable([16,8,128], n3(:,15889), t3x128(:,:,7964))
  call heltable([16,8,128], n3(:,15890), t3x128(:,:,7965))
  call heltable([16,8,128], n3(:,15891), t3x128(:,:,7966))
  call heltable([16,8,128], n3(:,15892), t3x128(:,:,7967))
  call heltable([16,8,128], n3(:,15893), t3x128(:,:,7968))
  call heltable([16,8,128], n3(:,15894), t3x128(:,:,7969))
  call heltable([16,8,128], n3(:,15895), t3x128(:,:,7970))
  call heltable([16,8,128], n3(:,15896), t3x128(:,:,7971))
  call heltable([16,8,128], n3(:,15897), t3x128(:,:,7972))
  call heltable([16,8,128], n3(:,15898), t3x128(:,:,7973))
  call heltable([16,8,128], n3(:,15899), t3x128(:,:,7974))
  call heltable([16,8,128], n3(:,15900), t3x128(:,:,7975))
  call heltable([16,8,128], n3(:,15901), t3x128(:,:,7976))
  call heltable([16,8,128], n3(:,15902), t3x128(:,:,7977))
  call heltable([16,8,128], n3(:,15903), t3x128(:,:,7978))
  call heltable([16,8,128], n3(:,15904), t3x128(:,:,7979))
  call heltable([16,8,128], n3(:,15905), t3x128(:,:,7980))
  call heltable([16,8,128], n3(:,15906), t3x128(:,:,7981))
  call heltable([16,8,128], n3(:,15907), t3x128(:,:,7982))
  call heltable([16,8,128], n3(:,15908), t3x128(:,:,7983))
  call heltable([16,8,128], n3(:,15909), t3x128(:,:,7984))
  call heltable([16,8,128], n3(:,15910), t3x128(:,:,7985))
  call heltable([16,8,128], n3(:,15911), t3x128(:,:,7986))
  call heltable([16,8,128], n3(:,15912), t3x128(:,:,7987))
  call heltable([16,8,128], n3(:,15913), t3x128(:,:,7988))
  call heltable([16,8,128], n3(:,15914), t3x128(:,:,7989))
  call heltable([16,8,128], n3(:,15915), t3x128(:,:,7990))
  call heltable([16,8,128], n3(:,15916), t3x128(:,:,7991))
  call heltable([16,8,128], n3(:,15917), t3x128(:,:,7992))
  call heltable([16,8,128], n3(:,15918), t3x128(:,:,7993))
  call heltable([16,8,128], n3(:,15919), t3x128(:,:,7994))
  call heltable([16,8,128], n3(:,15920), t3x128(:,:,7995))
  call heltable([16,8,128], n3(:,15921), t3x128(:,:,7996))
  call heltable([16,8,128], n3(:,15922), t3x128(:,:,7997))
  call heltable([16,8,128], n3(:,15923), t3x128(:,:,7998))
  call heltable([8,16,128], n3(:,15924), t3x128(:,:,7999))
  call heltable([8,16,128], n3(:,15925), t3x128(:,:,8000))
  call heltable([8,16,128], n3(:,15926), t3x128(:,:,8001))
  call heltable([8,16,128], n3(:,15927), t3x128(:,:,8002))
  call heltable([8,16,128], n3(:,15928), t3x128(:,:,8003))
  call heltable([8,16,128], n3(:,15929), t3x128(:,:,8004))
  call heltable([8,16,128], n3(:,15930), t3x128(:,:,8005))
  call heltable([8,16,128], n3(:,15931), t3x128(:,:,8006))
  call heltable([8,16,128], n3(:,15932), t3x128(:,:,8007))
  call heltable([8,16,128], n3(:,15933), t3x128(:,:,8008))
  call heltable([8,16,128], n3(:,15934), t3x128(:,:,8009))
  call heltable([8,16,128], n3(:,15935), t3x128(:,:,8010))
  call heltable([8,16,128], n3(:,15936), t3x128(:,:,8011))
  call heltable([8,16,128], n3(:,15937), t3x128(:,:,8012))
  call heltable([8,16,128], n3(:,15938), t3x128(:,:,8013))
  call heltable([8,16,128], n3(:,15939), t3x128(:,:,8014))
  call heltable([8,16,128], n3(:,15940), t3x128(:,:,8015))
  call heltable([8,16,128], n3(:,15941), t3x128(:,:,8016))
  call heltable([8,16,128], n3(:,15942), t3x128(:,:,8017))
  call heltable([8,16,128], n3(:,15943), t3x128(:,:,8018))
  call heltable([8,16,128], n3(:,15944), t3x128(:,:,8019))
  call heltable([8,16,128], n3(:,15945), t3x128(:,:,8020))
  call heltable([8,16,128], n3(:,15946), t3x128(:,:,8021))
  call heltable([8,16,128], n3(:,15947), t3x128(:,:,8022))
  call heltable([8,16,128], n3(:,15948), t3x128(:,:,8023))
  call heltable([8,16,128], n3(:,15949), t3x128(:,:,8024))
  call heltable([8,16,128], n3(:,15950), t3x128(:,:,8025))
  call heltable([8,16,128], n3(:,15951), t3x128(:,:,8026))
  call heltable([8,16,128], n3(:,15952), t3x128(:,:,8027))
  call heltable([8,16,128], n3(:,15953), t3x128(:,:,8028))
  call heltable([8,16,128], n3(:,15954), t3x128(:,:,8029))
  call heltable([8,16,128], n3(:,15955), t3x128(:,:,8030))
  call heltable([8,16,128], n3(:,15956), t3x128(:,:,8031))
  call heltable([8,16,128], n3(:,15957), t3x128(:,:,8032))
  call heltable([8,16,128], n3(:,15958), t3x128(:,:,8033))
  call heltable([8,16,128], n3(:,15959), t3x128(:,:,8034))
  call heltable([8,16,128], n3(:,15960), t3x128(:,:,8035))
  call heltable([8,16,128], n3(:,15961), t3x128(:,:,8036))
  call heltable([8,16,128], n3(:,15962), t3x128(:,:,8037))
  call heltable([8,16,128], n3(:,15963), t3x128(:,:,8038))
  call heltable([8,16,128], n3(:,15964), t3x128(:,:,8039))
  call heltable([8,16,128], n3(:,15965), t3x128(:,:,8040))
  call heltable([8,16,128], n3(:,15966), t3x128(:,:,8041))
  call heltable([8,16,128], n3(:,15967), t3x128(:,:,8042))
  call heltable([8,16,128], n3(:,15968), t3x128(:,:,8043))
  call heltable([8,16,128], n3(:,15969), t3x128(:,:,8044))
  call heltable([8,16,128], n3(:,15970), t3x128(:,:,8045))
  call heltable([8,16,128], n3(:,15971), t3x128(:,:,8046))
  call heltable([8,16,128], n3(:,15972), t3x128(:,:,8047))
  call heltable([8,16,128], n3(:,15973), t3x128(:,:,8048))
  call heltable([8,16,128], n3(:,15974), t3x128(:,:,8049))
  call heltable([8,16,128], n3(:,15975), t3x128(:,:,8050))
  call heltable([8,16,128], n3(:,15976), t3x128(:,:,8051))
  call heltable([8,16,128], n3(:,15977), t3x128(:,:,8052))
  call heltable([8,16,128], n3(:,15978), t3x128(:,:,8053))
  call heltable([8,16,128], n3(:,15979), t3x128(:,:,8054))
  call heltable([8,16,128], n3(:,15980), t3x128(:,:,8055))
  call heltable([8,16,128], n3(:,15981), t3x128(:,:,8056))
  call heltable([8,16,128], n3(:,15982), t3x128(:,:,8057))
  call heltable([8,16,128], n3(:,15983), t3x128(:,:,8058))
  call heltable([8,16,128], n3(:,15984), t3x128(:,:,8059))
  call heltable([8,16,128], n3(:,15985), t3x128(:,:,8060))
  call heltable([8,16,128], n3(:,15986), t3x128(:,:,8061))
  call heltable([8,16,128], n3(:,15987), t3x128(:,:,8062))
  call heltable([8,16,128], n3(:,15988), t3x128(:,:,8063))
  call heltable([8,16,128], n3(:,15989), t3x128(:,:,8064))
  call heltable([8,16,128], n3(:,15990), t3x128(:,:,8065))
  call heltable([8,16,128], n3(:,15991), t3x128(:,:,8066))
  call heltable([8,16,128], n3(:,15992), t3x128(:,:,8067))
  call heltable([8,16,128], n3(:,15993), t3x128(:,:,8068))
  call heltable([8,16,128], n3(:,15994), t3x128(:,:,8069))
  call heltable([8,16,128], n3(:,15995), t3x128(:,:,8070))
  call heltable([8,16,128], n3(:,15996), t3x128(:,:,8071))
  call heltable([8,16,128], n3(:,15997), t3x128(:,:,8072))
  call heltable([8,16,128], n3(:,15998), t3x128(:,:,8073))
  call heltable([8,16,128], n3(:,15999), t3x128(:,:,8074))
  call heltable([8,16,128], n3(:,16000), t3x128(:,:,8075))
  call heltable([8,16,128], n3(:,16001), t3x128(:,:,8076))
  call heltable([8,16,128], n3(:,16002), t3x128(:,:,8077))
  call heltable([8,16,128], n3(:,16003), t3x128(:,:,8078))
  call heltable([16,8,128], n3(:,16004), t3x128(:,:,8079))
  call heltable([16,8,128], n3(:,16005), t3x128(:,:,8080))
  call heltable([16,8,128], n3(:,16006), t3x128(:,:,8081))
  call heltable([16,8,128], n3(:,16007), t3x128(:,:,8082))
  call heltable([16,8,128], n3(:,16008), t3x128(:,:,8083))
  call heltable([16,8,128], n3(:,16009), t3x128(:,:,8084))
  call heltable([16,8,128], n3(:,16010), t3x128(:,:,8085))
  call heltable([16,8,128], n3(:,16011), t3x128(:,:,8086))
  call heltable([16,8,128], n3(:,16012), t3x128(:,:,8087))
  call heltable([16,8,128], n3(:,16013), t3x128(:,:,8088))
  call heltable([16,8,128], n3(:,16014), t3x128(:,:,8089))
  call heltable([16,8,128], n3(:,16015), t3x128(:,:,8090))
  call heltable([16,8,128], n3(:,16016), t3x128(:,:,8091))
  call heltable([16,8,128], n3(:,16017), t3x128(:,:,8092))
  call heltable([16,8,128], n3(:,16018), t3x128(:,:,8093))
  call heltable([16,8,128], n3(:,16019), t3x128(:,:,8094))
  call heltable([8,16,128], n3(:,16020), t3x128(:,:,8095))
  call heltable([8,16,128], n3(:,16021), t3x128(:,:,8096))
  call heltable([8,16,128], n3(:,16022), t3x128(:,:,8097))
  call heltable([8,16,128], n3(:,16023), t3x128(:,:,8098))
  call heltable([8,16,128], n3(:,16024), t3x128(:,:,8099))
  call heltable([8,16,128], n3(:,16025), t3x128(:,:,8100))
  call heltable([8,16,128], n3(:,16026), t3x128(:,:,8101))
  call heltable([8,16,128], n3(:,16027), t3x128(:,:,8102))
  call heltable([8,16,128], n3(:,16028), t3x128(:,:,8103))
  call heltable([8,16,128], n3(:,16029), t3x128(:,:,8104))
  call heltable([8,16,128], n3(:,16030), t3x128(:,:,8105))
  call heltable([8,16,128], n3(:,16031), t3x128(:,:,8106))
  call heltable([8,16,128], n3(:,16032), t3x128(:,:,8107))
  call heltable([8,16,128], n3(:,16033), t3x128(:,:,8108))
  call heltable([8,16,128], n3(:,16034), t3x128(:,:,8109))
  call heltable([8,16,128], n3(:,16035), t3x128(:,:,8110))
  call heltable([8,16,128], n3(:,16036), t3x128(:,:,8111))
  call heltable([8,16,128], n3(:,16037), t3x128(:,:,8112))
  call heltable([8,16,128], n3(:,16038), t3x128(:,:,8113))
  call heltable([8,16,128], n3(:,16039), t3x128(:,:,8114))
  call heltable([8,16,128], n3(:,16040), t3x128(:,:,8115))
  call heltable([8,16,128], n3(:,16041), t3x128(:,:,8116))
  call heltable([8,16,128], n3(:,16042), t3x128(:,:,8117))
  call heltable([8,16,128], n3(:,16043), t3x128(:,:,8118))
  call heltable([8,16,128], n3(:,16044), t3x128(:,:,8119))
  call heltable([8,16,128], n3(:,16045), t3x128(:,:,8120))
  call heltable([8,16,128], n3(:,16046), t3x128(:,:,8121))
  call heltable([8,16,128], n3(:,16047), t3x128(:,:,8122))
  call heltable([8,16,128], n3(:,16048), t3x128(:,:,8123))
  call heltable([16,8,128], n3(:,16049), t3x128(:,:,8124))
  call heltable([16,8,128], n3(:,16050), t3x128(:,:,8125))
  call heltable([16,8,128], n3(:,16051), t3x128(:,:,8126))
  call heltable([16,8,128], n3(:,16052), t3x128(:,:,8127))
  call heltable([16,8,128], n3(:,16053), t3x128(:,:,8128))
  call heltable([16,8,128], n3(:,16054), t3x128(:,:,8129))
  call heltable([16,8,128], n3(:,16055), t3x128(:,:,8130))
  call heltable([16,8,128], n3(:,16056), t3x128(:,:,8131))
  call heltable([16,8,128], n3(:,16057), t3x128(:,:,8132))
  call heltable([16,8,128], n3(:,16058), t3x128(:,:,8133))
  call heltable([16,8,128], n3(:,16059), t3x128(:,:,8134))
  call heltable([16,8,128], n3(:,16060), t3x128(:,:,8135))
  call heltable([16,8,128], n3(:,16061), t3x128(:,:,8136))
  call heltable([16,8,128], n3(:,16062), t3x128(:,:,8137))
  call heltable([16,8,128], n3(:,16063), t3x128(:,:,8138))
  call heltable([16,8,128], n3(:,16064), t3x128(:,:,8139))
  call heltable([8,16,128], n3(:,16065), t3x128(:,:,8140))
  call heltable([8,16,128], n3(:,16066), t3x128(:,:,8141))
  call heltable([8,16,128], n3(:,16067), t3x128(:,:,8142))
  call heltable([8,16,128], n3(:,16068), t3x128(:,:,8143))
  call heltable([8,16,128], n3(:,16069), t3x128(:,:,8144))
  call heltable([8,16,128], n3(:,16070), t3x128(:,:,8145))
  call heltable([8,16,128], n3(:,16071), t3x128(:,:,8146))
  call heltable([8,16,128], n3(:,16072), t3x128(:,:,8147))
  call heltable([8,16,128], n3(:,16073), t3x128(:,:,8148))
  call heltable([8,16,128], n3(:,16074), t3x128(:,:,8149))
  call heltable([8,16,128], n3(:,16075), t3x128(:,:,8150))
  call heltable([8,16,128], n3(:,16076), t3x128(:,:,8151))
  call heltable([8,16,128], n3(:,16077), t3x128(:,:,8152))
  call heltable([16,8,128], n3(:,16078), t3x128(:,:,8153))
  call heltable([16,8,128], n3(:,16079), t3x128(:,:,8154))
  call heltable([16,8,128], n3(:,16080), t3x128(:,:,8155))
  call heltable([16,8,128], n3(:,16081), t3x128(:,:,8156))
  call heltable([16,8,128], n3(:,16082), t3x128(:,:,8157))
  call heltable([16,8,128], n3(:,16083), t3x128(:,:,8158))
  call heltable([16,8,128], n3(:,16084), t3x128(:,:,8159))
  call heltable([16,8,128], n3(:,16085), t3x128(:,:,8160))
  call heltable([16,8,128], n3(:,16086), t3x128(:,:,8161))
  call heltable([16,8,128], n3(:,16087), t3x128(:,:,8162))
  call heltable([16,8,128], n3(:,16088), t3x128(:,:,8163))
  call heltable([16,8,128], n3(:,16089), t3x128(:,:,8164))
  call heltable([16,8,128], n3(:,16090), t3x128(:,:,8165))
  call heltable([16,8,128], n3(:,16091), t3x128(:,:,8166))
  call heltable([16,8,128], n3(:,16092), t3x128(:,:,8167))
  call heltable([16,8,128], n3(:,16093), t3x128(:,:,8168))
  call heltable([8,16,128], n3(:,16094), t3x128(:,:,8169))
  call heltable([8,16,128], n3(:,16095), t3x128(:,:,8170))
  call heltable([8,16,128], n3(:,16096), t3x128(:,:,8171))
  call heltable([8,16,128], n3(:,16097), t3x128(:,:,8172))
  call heltable([8,16,128], n3(:,16098), t3x128(:,:,8173))
  call heltable([8,16,128], n3(:,16099), t3x128(:,:,8174))
  call heltable([8,16,128], n3(:,16100), t3x128(:,:,8175))
  call heltable([8,16,128], n3(:,16101), t3x128(:,:,8176))
  call heltable([8,16,128], n3(:,16102), t3x128(:,:,8177))
  call heltable([8,16,128], n3(:,16103), t3x128(:,:,8178))
  call heltable([8,16,128], n3(:,16104), t3x128(:,:,8179))
  call heltable([8,16,128], n3(:,16105), t3x128(:,:,8180))
  call heltable([8,16,128], n3(:,16106), t3x128(:,:,8181))
  call heltable([8,16,128], n3(:,16107), t3x128(:,:,8182))
  call heltable([8,16,128], n3(:,16108), t3x128(:,:,8183))
  call heltable([8,16,128], n3(:,16109), t3x128(:,:,8184))
  call heltable([8,16,128], n3(:,16110), t3x128(:,:,8185))
  call heltable([8,16,128], n3(:,16111), t3x128(:,:,8186))
  call heltable([8,16,128], n3(:,16112), t3x128(:,:,8187))
  call heltable([8,16,128], n3(:,16113), t3x128(:,:,8188))
  call heltable([8,16,128], n3(:,16114), t3x128(:,:,8189))
  call heltable([8,16,128], n3(:,16115), t3x128(:,:,8190))
  call heltable([8,16,128], n3(:,16116), t3x128(:,:,8191))
  call heltable([8,16,128], n3(:,16117), t3x128(:,:,8192))
  call heltable([8,16,128], n3(:,16118), t3x128(:,:,8193))
  call heltable([8,16,128], n3(:,16119), t3x128(:,:,8194))
  call heltable([8,16,128], n3(:,16120), t3x128(:,:,8195))
  call heltable([8,16,128], n3(:,16121), t3x128(:,:,8196))
  call heltable([8,16,128], n3(:,16122), t3x128(:,:,8197))
  call heltable([16,8,128], n3(:,16123), t3x128(:,:,8198))
  call heltable([16,8,128], n3(:,16124), t3x128(:,:,8199))
  call heltable([16,8,128], n3(:,16125), t3x128(:,:,8200))
  call heltable([16,8,128], n3(:,16126), t3x128(:,:,8201))
  call heltable([16,8,128], n3(:,16127), t3x128(:,:,8202))
  call heltable([16,8,128], n3(:,16128), t3x128(:,:,8203))
  call heltable([16,8,128], n3(:,16129), t3x128(:,:,8204))
  call heltable([16,8,128], n3(:,16130), t3x128(:,:,8205))
  call heltable([16,8,128], n3(:,16131), t3x128(:,:,8206))
  call heltable([16,8,128], n3(:,16132), t3x128(:,:,8207))
  call heltable([16,8,128], n3(:,16133), t3x128(:,:,8208))
  call heltable([16,8,128], n3(:,16134), t3x128(:,:,8209))
  call heltable([16,8,128], n3(:,16135), t3x128(:,:,8210))
  call heltable([16,8,128], n3(:,16136), t3x128(:,:,8211))
  call heltable([16,8,128], n3(:,16137), t3x128(:,:,8212))
  call heltable([16,8,128], n3(:,16138), t3x128(:,:,8213))
  call heltable([8,16,128], n3(:,16139), t3x128(:,:,8214))
  call heltable([8,16,128], n3(:,16140), t3x128(:,:,8215))
  call heltable([8,16,128], n3(:,16141), t3x128(:,:,8216))
  call heltable([8,16,128], n3(:,16142), t3x128(:,:,8217))
  call heltable([8,16,128], n3(:,16143), t3x128(:,:,8218))
  call heltable([8,16,128], n3(:,16144), t3x128(:,:,8219))
  call heltable([8,16,128], n3(:,16145), t3x128(:,:,8220))
  call heltable([8,16,128], n3(:,16146), t3x128(:,:,8221))
  call heltable([8,16,128], n3(:,16147), t3x128(:,:,8222))
  call heltable([8,16,128], n3(:,16148), t3x128(:,:,8223))
  call heltable([8,16,128], n3(:,16149), t3x128(:,:,8224))
  call heltable([8,16,128], n3(:,16150), t3x128(:,:,8225))
  call heltable([8,16,128], n3(:,16151), t3x128(:,:,8226))
  call heltable([8,16,128], n3(:,16152), t3x128(:,:,8227))
  call heltable([8,16,128], n3(:,16153), t3x128(:,:,8228))
  call heltable([8,16,128], n3(:,16154), t3x128(:,:,8229))
  call heltable([8,16,128], n3(:,16155), t3x128(:,:,8230))
  call heltable([8,16,128], n3(:,16156), t3x128(:,:,8231))
  call heltable([8,16,128], n3(:,16157), t3x128(:,:,8232))
  call heltable([8,16,128], n3(:,16158), t3x128(:,:,8233))
  call heltable([8,16,128], n3(:,16159), t3x128(:,:,8234))
  call heltable([8,16,128], n3(:,16160), t3x128(:,:,8235))
  call heltable([8,16,128], n3(:,16161), t3x128(:,:,8236))
  call heltable([8,16,128], n3(:,16162), t3x128(:,:,8237))
  call heltable([8,16,128], n3(:,16163), t3x128(:,:,8238))
  call heltable([8,16,128], n3(:,16164), t3x128(:,:,8239))
  call heltable([8,16,128], n3(:,16165), t3x128(:,:,8240))
  call heltable([8,16,128], n3(:,16166), t3x128(:,:,8241))
  call heltable([8,16,128], n3(:,16167), t3x128(:,:,8242))
  call heltable([8,16,128], n3(:,16168), t3x128(:,:,8243))
  call heltable([8,16,128], n3(:,16169), t3x128(:,:,8244))
  call heltable([8,16,128], n3(:,16170), t3x128(:,:,8245))
  call heltable([8,16,128], n3(:,16171), t3x128(:,:,8246))
  call heltable([8,16,128], n3(:,16172), t3x128(:,:,8247))
  call heltable([8,16,128], n3(:,16173), t3x128(:,:,8248))
  call heltable([8,16,128], n3(:,16174), t3x128(:,:,8249))
  call heltable([8,16,128], n3(:,16175), t3x128(:,:,8250))
  call heltable([8,16,128], n3(:,16176), t3x128(:,:,8251))
  call heltable([8,16,128], n3(:,16177), t3x128(:,:,8252))
  call heltable([8,16,128], n3(:,16178), t3x128(:,:,8253))
  call heltable([8,16,128], n3(:,16179), t3x128(:,:,8254))
  call heltable([8,16,128], n3(:,16180), t3x128(:,:,8255))
  call heltable([8,16,128], n3(:,16181), t3x128(:,:,8256))
  call heltable([8,16,128], n3(:,16182), t3x128(:,:,8257))
  call heltable([8,16,128], n3(:,16183), t3x128(:,:,8258))
  call heltable([16,8,128], n3(:,16184), t3x128(:,:,8259))
  call heltable([16,8,128], n3(:,16185), t3x128(:,:,8260))
  call heltable([16,8,128], n3(:,16186), t3x128(:,:,8261))
  call heltable([16,8,128], n3(:,16187), t3x128(:,:,8262))
  call heltable([16,8,128], n3(:,16188), t3x128(:,:,8263))
  call heltable([16,8,128], n3(:,16189), t3x128(:,:,8264))
  call heltable([16,8,128], n3(:,16190), t3x128(:,:,8265))
  call heltable([16,8,128], n3(:,16191), t3x128(:,:,8266))
  call heltable([16,8,128], n3(:,16192), t3x128(:,:,8267))
  call heltable([16,8,128], n3(:,16193), t3x128(:,:,8268))
  call heltable([16,8,128], n3(:,16194), t3x128(:,:,8269))
  call heltable([16,8,128], n3(:,16195), t3x128(:,:,8270))
  call heltable([16,8,128], n3(:,16196), t3x128(:,:,8271))
  call heltable([16,8,128], n3(:,16197), t3x128(:,:,8272))
  call heltable([16,8,128], n3(:,16198), t3x128(:,:,8273))
  call heltable([16,8,128], n3(:,16199), t3x128(:,:,8274))
  call heltable([16,8,128], n3(:,16200), t3x128(:,:,8275))
  call heltable([16,8,128], n3(:,16201), t3x128(:,:,8276))
  call heltable([16,8,128], n3(:,16202), t3x128(:,:,8277))
  call heltable([16,8,128], n3(:,16203), t3x128(:,:,8278))
  call heltable([16,8,128], n3(:,16204), t3x128(:,:,8279))
  call heltable([16,8,128], n3(:,16205), t3x128(:,:,8280))
  call heltable([16,8,128], n3(:,16206), t3x128(:,:,8281))
  call heltable([16,8,128], n3(:,16207), t3x128(:,:,8282))
  call heltable([16,8,128], n3(:,16208), t3x128(:,:,8283))
  call heltable([16,8,128], n3(:,16209), t3x128(:,:,8284))
  call heltable([16,8,128], n3(:,16210), t3x128(:,:,8285))
  call heltable([16,8,128], n3(:,16211), t3x128(:,:,8286))
  call heltable([16,8,128], n3(:,16212), t3x128(:,:,8287))
  call heltable([16,8,128], n3(:,16213), t3x128(:,:,8288))
  call heltable([16,8,128], n3(:,16214), t3x128(:,:,8289))
  call heltable([16,8,128], n3(:,16215), t3x128(:,:,8290))
  call heltable([8,16,128], n3(:,16216), t3x128(:,:,8291))
  call heltable([8,16,128], n3(:,16217), t3x128(:,:,8292))
  call heltable([8,16,128], n3(:,16218), t3x128(:,:,8293))
  call heltable([8,16,128], n3(:,16219), t3x128(:,:,8294))
  call heltable([8,16,128], n3(:,16220), t3x128(:,:,8295))
  call heltable([8,16,128], n3(:,16221), t3x128(:,:,8296))
  call heltable([8,16,128], n3(:,16222), t3x128(:,:,8297))
  call heltable([8,16,128], n3(:,16223), t3x128(:,:,8298))
  call heltable([8,16,128], n3(:,16224), t3x128(:,:,8299))
  call heltable([8,16,128], n3(:,16225), t3x128(:,:,8300))
  call heltable([8,16,128], n3(:,16226), t3x128(:,:,8301))
  call heltable([8,16,128], n3(:,16227), t3x128(:,:,8302))
  call heltable([8,16,128], n3(:,16228), t3x128(:,:,8303))
  call heltable([8,16,128], n3(:,16229), t3x128(:,:,8304))
  call heltable([8,16,128], n3(:,16230), t3x128(:,:,8305))
  call heltable([8,16,128], n3(:,16231), t3x128(:,:,8306))
  call heltable([16,8,128], n3(:,16232), t3x128(:,:,8307))
  call heltable([16,8,128], n3(:,16233), t3x128(:,:,8308))
  call heltable([16,8,128], n3(:,16234), t3x128(:,:,8309))
  call heltable([16,8,128], n3(:,16235), t3x128(:,:,8310))
  call heltable([16,8,128], n3(:,16236), t3x128(:,:,8311))
  call heltable([16,8,128], n3(:,16237), t3x128(:,:,8312))
  call heltable([16,8,128], n3(:,16238), t3x128(:,:,8313))
  call heltable([16,8,128], n3(:,16239), t3x128(:,:,8314))
  call heltable([16,8,128], n3(:,16240), t3x128(:,:,8315))
  call heltable([16,8,128], n3(:,16241), t3x128(:,:,8316))
  call heltable([16,8,128], n3(:,16242), t3x128(:,:,8317))
  call heltable([16,8,128], n3(:,16243), t3x128(:,:,8318))
  call heltable([16,8,128], n3(:,16244), t3x128(:,:,8319))
  call heltable([16,8,128], n3(:,16245), t3x128(:,:,8320))
  call heltable([16,8,128], n3(:,16246), t3x128(:,:,8321))
  call heltable([16,8,128], n3(:,16247), t3x128(:,:,8322))
  call heltable([16,8,128], n3(:,16248), t3x128(:,:,8323))
  call heltable([16,8,128], n3(:,16249), t3x128(:,:,8324))
  call heltable([16,8,128], n3(:,16250), t3x128(:,:,8325))
  call heltable([16,8,128], n3(:,16251), t3x128(:,:,8326))
  call heltable([16,8,128], n3(:,16252), t3x128(:,:,8327))
  call heltable([16,8,128], n3(:,16253), t3x128(:,:,8328))
  call heltable([16,8,128], n3(:,16254), t3x128(:,:,8329))
  call heltable([16,8,128], n3(:,16255), t3x128(:,:,8330))
  call heltable([16,8,128], n3(:,16256), t3x128(:,:,8331))
  call heltable([16,8,128], n3(:,16257), t3x128(:,:,8332))
  call heltable([16,8,128], n3(:,16258), t3x128(:,:,8333))
  call heltable([16,8,128], n3(:,16259), t3x128(:,:,8334))
  call heltable([16,8,128], n3(:,16260), t3x128(:,:,8335))
  call heltable([16,8,128], n3(:,16261), t3x128(:,:,8336))
  call heltable([16,8,128], n3(:,16262), t3x128(:,:,8337))
  call heltable([16,8,128], n3(:,16263), t3x128(:,:,8338))
  call heltable([16,8,128], n3(:,16264), t3x128(:,:,8339))
  call heltable([16,8,128], n3(:,16265), t3x128(:,:,8340))
  call heltable([16,8,128], n3(:,16266), t3x128(:,:,8341))
  call heltable([16,8,128], n3(:,16267), t3x128(:,:,8342))
  call heltable([16,8,128], n3(:,16268), t3x128(:,:,8343))
  call heltable([16,8,128], n3(:,16269), t3x128(:,:,8344))
  call heltable([16,8,128], n3(:,16270), t3x128(:,:,8345))
  call heltable([16,8,128], n3(:,16271), t3x128(:,:,8346))
  call heltable([16,8,128], n3(:,16272), t3x128(:,:,8347))
  call heltable([16,8,128], n3(:,16273), t3x128(:,:,8348))
  call heltable([16,8,128], n3(:,16274), t3x128(:,:,8349))
  call heltable([16,8,128], n3(:,16275), t3x128(:,:,8350))
  call heltable([16,8,128], n3(:,16276), t3x128(:,:,8351))
  call heltable([16,8,128], n3(:,16277), t3x128(:,:,8352))
  call heltable([16,8,128], n3(:,16278), t3x128(:,:,8353))
  call heltable([16,8,128], n3(:,16279), t3x128(:,:,8354))
  call heltable([16,8,128], n3(:,16280), t3x128(:,:,8355))
  call heltable([16,8,128], n3(:,16281), t3x128(:,:,8356))
  call heltable([16,8,128], n3(:,16282), t3x128(:,:,8357))
  call heltable([16,8,128], n3(:,16283), t3x128(:,:,8358))
  call heltable([16,8,128], n3(:,16284), t3x128(:,:,8359))
  call heltable([16,8,128], n3(:,16285), t3x128(:,:,8360))
  call heltable([16,8,128], n3(:,16286), t3x128(:,:,8361))
  call heltable([16,8,128], n3(:,16287), t3x128(:,:,8362))
  call heltable([16,8,128], n3(:,16288), t3x128(:,:,8363))
  call heltable([16,8,128], n3(:,16289), t3x128(:,:,8364))
  call heltable([16,8,128], n3(:,16290), t3x128(:,:,8365))
  call heltable([16,8,128], n3(:,16291), t3x128(:,:,8366))
  call heltable([16,8,128], n3(:,16292), t3x128(:,:,8367))
  call heltable([16,8,128], n3(:,16293), t3x128(:,:,8368))
  call heltable([16,8,128], n3(:,16294), t3x128(:,:,8369))
  call heltable([16,8,128], n3(:,16295), t3x128(:,:,8370))
  call heltable([8,16,128], n3(:,16296), t3x128(:,:,8371))
  call heltable([8,16,128], n3(:,16297), t3x128(:,:,8372))
  call heltable([8,16,128], n3(:,16298), t3x128(:,:,8373))
  call heltable([8,16,128], n3(:,16299), t3x128(:,:,8374))
  call heltable([8,16,128], n3(:,16300), t3x128(:,:,8375))
  call heltable([8,16,128], n3(:,16301), t3x128(:,:,8376))
  call heltable([8,16,128], n3(:,16302), t3x128(:,:,8377))
  call heltable([8,16,128], n3(:,16303), t3x128(:,:,8378))
  call heltable([8,16,128], n3(:,16304), t3x128(:,:,8379))
  call heltable([8,16,128], n3(:,16305), t3x128(:,:,8380))
  call heltable([8,16,128], n3(:,16306), t3x128(:,:,8381))
  call heltable([8,16,128], n3(:,16307), t3x128(:,:,8382))
  call heltable([8,16,128], n3(:,16308), t3x128(:,:,8383))
  call heltable([8,16,128], n3(:,16309), t3x128(:,:,8384))
  call heltable([8,16,128], n3(:,16310), t3x128(:,:,8385))
  call heltable([8,16,128], n3(:,16311), t3x128(:,:,8386))
  call heltable([8,16,128], n3(:,16312), t3x128(:,:,8387))
  call heltable([8,16,128], n3(:,16313), t3x128(:,:,8388))
  call heltable([8,16,128], n3(:,16314), t3x128(:,:,8389))
  call heltable([8,16,128], n3(:,16315), t3x128(:,:,8390))
  call heltable([8,16,128], n3(:,16316), t3x128(:,:,8391))
  call heltable([8,16,128], n3(:,16317), t3x128(:,:,8392))
  call heltable([8,16,128], n3(:,16318), t3x128(:,:,8393))
  call heltable([8,16,128], n3(:,16319), t3x128(:,:,8394))
  call heltable([8,16,128], n3(:,16320), t3x128(:,:,8395))
  call heltable([8,16,128], n3(:,16321), t3x128(:,:,8396))
  call heltable([8,16,128], n3(:,16322), t3x128(:,:,8397))
  call heltable([8,16,128], n3(:,16323), t3x128(:,:,8398))
  call heltable([8,16,128], n3(:,16324), t3x128(:,:,8399))
  call heltable([8,16,128], n3(:,16325), t3x128(:,:,8400))
  call heltable([8,16,128], n3(:,16326), t3x128(:,:,8401))
  call heltable([8,16,128], n3(:,16327), t3x128(:,:,8402))
  call heltable([8,16,128], n3(:,16328), t3x128(:,:,8403))
  call heltable([8,16,128], n3(:,16329), t3x128(:,:,8404))
  call heltable([8,16,128], n3(:,16330), t3x128(:,:,8405))
  call heltable([8,16,128], n3(:,16331), t3x128(:,:,8406))
  call heltable([8,16,128], n3(:,16332), t3x128(:,:,8407))
  call heltable([8,16,128], n3(:,16333), t3x128(:,:,8408))
  call heltable([8,16,128], n3(:,16334), t3x128(:,:,8409))
  call heltable([8,16,128], n3(:,16335), t3x128(:,:,8410))
  call heltable([8,16,128], n3(:,16336), t3x128(:,:,8411))
  call heltable([8,16,128], n3(:,16337), t3x128(:,:,8412))
  call heltable([8,16,128], n3(:,16338), t3x128(:,:,8413))
  call heltable([8,16,128], n3(:,16339), t3x128(:,:,8414))
  call heltable([8,16,128], n3(:,16340), t3x128(:,:,8415))
  call heltable([8,16,128], n3(:,16341), t3x128(:,:,8416))
  call heltable([8,16,128], n3(:,16342), t3x128(:,:,8417))
  call heltable([8,16,128], n3(:,16343), t3x128(:,:,8418))
  call heltable([8,16,128], n3(:,16344), t3x128(:,:,8419))
  call heltable([8,16,128], n3(:,16345), t3x128(:,:,8420))
  call heltable([8,16,128], n3(:,16346), t3x128(:,:,8421))
  call heltable([8,16,128], n3(:,16347), t3x128(:,:,8422))
  call heltable([8,16,128], n3(:,16348), t3x128(:,:,8423))
  call heltable([8,16,128], n3(:,16349), t3x128(:,:,8424))
  call heltable([8,16,128], n3(:,16350), t3x128(:,:,8425))
  call heltable([8,16,128], n3(:,16351), t3x128(:,:,8426))
  call heltable([8,16,128], n3(:,16352), t3x128(:,:,8427))
  call heltable([8,16,128], n3(:,16353), t3x128(:,:,8428))
  call heltable([8,16,128], n3(:,16354), t3x128(:,:,8429))
  call heltable([8,16,128], n3(:,16355), t3x128(:,:,8430))
  call heltable([8,16,128], n3(:,16356), t3x128(:,:,8431))
  call heltable([8,16,128], n3(:,16357), t3x128(:,:,8432))
  call heltable([8,16,128], n3(:,16358), t3x128(:,:,8433))
  call heltable([8,16,128], n3(:,16359), t3x128(:,:,8434))
  call heltable([16,8,128], n3(:,16360), t3x128(:,:,8435))
  call heltable([16,8,128], n3(:,16361), t3x128(:,:,8436))
  call heltable([16,8,128], n3(:,16362), t3x128(:,:,8437))
  call heltable([16,8,128], n3(:,16363), t3x128(:,:,8438))
  call heltable([16,8,128], n3(:,16364), t3x128(:,:,8439))
  call heltable([16,8,128], n3(:,16365), t3x128(:,:,8440))
  call heltable([16,8,128], n3(:,16366), t3x128(:,:,8441))
  call heltable([16,8,128], n3(:,16367), t3x128(:,:,8442))
  call heltable([16,8,128], n3(:,16368), t3x128(:,:,8443))
  call heltable([16,8,128], n3(:,16369), t3x128(:,:,8444))
  call heltable([16,8,128], n3(:,16370), t3x128(:,:,8445))
  call heltable([16,8,128], n3(:,16371), t3x128(:,:,8446))
  call heltable([16,8,128], n3(:,16372), t3x128(:,:,8447))
  call heltable([16,8,128], n3(:,16373), t3x128(:,:,8448))
  call heltable([16,8,128], n3(:,16374), t3x128(:,:,8449))
  call heltable([16,8,128], n3(:,16375), t3x128(:,:,8450))
  call heltable([16,8,128], n3(:,16376), t3x128(:,:,8451))
  call heltable([16,8,128], n3(:,16377), t3x128(:,:,8452))
  call heltable([16,8,128], n3(:,16378), t3x128(:,:,8453))
  call heltable([16,8,128], n3(:,16379), t3x128(:,:,8454))
  call heltable([16,8,128], n3(:,16380), t3x128(:,:,8455))
  call heltable([16,8,128], n3(:,16381), t3x128(:,:,8456))
  call heltable([16,8,128], n3(:,16382), t3x128(:,:,8457))
  call heltable([16,8,128], n3(:,16383), t3x128(:,:,8458))
  call heltable([16,8,128], n3(:,16384), t3x128(:,:,8459))
  call heltable([16,8,128], n3(:,16385), t3x128(:,:,8460))
  call heltable([16,8,128], n3(:,16386), t3x128(:,:,8461))
  call heltable([16,8,128], n3(:,16387), t3x128(:,:,8462))
  call heltable([16,8,128], n3(:,16388), t3x128(:,:,8463))
  call heltable([8,16,128], n3(:,16389), t3x128(:,:,8464))
  call heltable([8,16,128], n3(:,16390), t3x128(:,:,8465))
  call heltable([16,8,128], n3(:,16391), t3x128(:,:,8466))
  call heltable([16,8,128], n3(:,16392), t3x128(:,:,8467))
  call heltable([8,16,128], n3(:,16393), t3x128(:,:,8468))
  call heltable([8,16,128], n3(:,16394), t3x128(:,:,8469))
  call heltable([8,16,128], n3(:,16395), t3x128(:,:,8470))
  call heltable([8,16,128], n3(:,16396), t3x128(:,:,8471))
  call heltable([16,8,128], n3(:,16397), t3x128(:,:,8472))
  call heltable([16,8,128], n3(:,16398), t3x128(:,:,8473))
  call heltable([16,8,128], n3(:,16399), t3x128(:,:,8474))
  call heltable([16,8,128], n3(:,16400), t3x128(:,:,8475))
  call heltable([16,8,128], n3(:,16401), t3x128(:,:,8476))
  call heltable([16,8,128], n3(:,16402), t3x128(:,:,8477))
  call heltable([16,8,128], n3(:,16403), t3x128(:,:,8478))
  call heltable([16,8,128], n3(:,16404), t3x128(:,:,8479))
  call heltable([8,16,128], n3(:,16405), t3x128(:,:,8480))
  call heltable([8,16,128], n3(:,16406), t3x128(:,:,8481))
  call heltable([8,16,128], n3(:,16407), t3x128(:,:,8482))
  call heltable([8,16,128], n3(:,16408), t3x128(:,:,8483))
  call heltable([8,16,128], n3(:,16409), t3x128(:,:,8484))
  call heltable([8,16,128], n3(:,16410), t3x128(:,:,8485))
  call heltable([8,16,128], n3(:,16411), t3x128(:,:,8486))
  call heltable([8,16,128], n3(:,16412), t3x128(:,:,8487))
  call heltable([8,16,128], n3(:,16413), t3x128(:,:,8488))
  call heltable([8,16,128], n3(:,16414), t3x128(:,:,8489))
  call heltable([8,16,128], n3(:,16415), t3x128(:,:,8490))
  call heltable([8,16,128], n3(:,16416), t3x128(:,:,8491))
  call heltable([8,16,128], n3(:,16417), t3x128(:,:,8492))
  call heltable([8,16,128], n3(:,16418), t3x128(:,:,8493))
  call heltable([8,16,128], n3(:,16419), t3x128(:,:,8494))
  call heltable([8,16,128], n3(:,16420), t3x128(:,:,8495))
  call heltable([8,16,128], n3(:,16421), t3x128(:,:,8496))
  call heltable([8,16,128], n3(:,16422), t3x128(:,:,8497))
  call heltable([8,16,128], n3(:,16423), t3x128(:,:,8498))
  call heltable([8,16,128], n3(:,16424), t3x128(:,:,8499))
  call heltable([8,16,128], n3(:,16425), t3x128(:,:,8500))
  call heltable([8,16,128], n3(:,16426), t3x128(:,:,8501))
  call heltable([8,16,128], n3(:,16427), t3x128(:,:,8502))
  call heltable([8,16,128], n3(:,16428), t3x128(:,:,8503))
  call heltable([8,16,128], n3(:,16429), t3x128(:,:,8504))
  call heltable([8,16,128], n3(:,16430), t3x128(:,:,8505))
  call heltable([8,16,128], n3(:,16431), t3x128(:,:,8506))
  call heltable([8,16,128], n3(:,16432), t3x128(:,:,8507))
  call heltable([8,16,128], n3(:,16433), t3x128(:,:,8508))
  call heltable([8,16,128], n3(:,16434), t3x128(:,:,8509))
  call heltable([8,16,128], n3(:,16435), t3x128(:,:,8510))
  call heltable([8,16,128], n3(:,16436), t3x128(:,:,8511))
  call heltable([16,8,128], n3(:,16437), t3x128(:,:,8512))
  call heltable([16,8,128], n3(:,16438), t3x128(:,:,8513))
  call heltable([16,8,128], n3(:,16439), t3x128(:,:,8514))
  call heltable([16,8,128], n3(:,16440), t3x128(:,:,8515))
  call heltable([16,8,128], n3(:,16441), t3x128(:,:,8516))
  call heltable([16,8,128], n3(:,16442), t3x128(:,:,8517))
  call heltable([16,8,128], n3(:,16443), t3x128(:,:,8518))
  call heltable([16,8,128], n3(:,16444), t3x128(:,:,8519))
  call heltable([16,8,128], n3(:,16445), t3x128(:,:,8520))
  call heltable([16,8,128], n3(:,16446), t3x128(:,:,8521))
  call heltable([16,8,128], n3(:,16447), t3x128(:,:,8522))
  call heltable([16,8,128], n3(:,16448), t3x128(:,:,8523))
  call heltable([16,8,128], n3(:,16449), t3x128(:,:,8524))
  call heltable([8,16,128], n3(:,16450), t3x128(:,:,8525))
  call heltable([8,16,128], n3(:,16451), t3x128(:,:,8526))
  call heltable([8,16,128], n3(:,16452), t3x128(:,:,8527))
  call heltable([8,16,128], n3(:,16453), t3x128(:,:,8528))
  call heltable([8,16,128], n3(:,16454), t3x128(:,:,8529))
  call heltable([8,16,128], n3(:,16455), t3x128(:,:,8530))
  call heltable([8,16,128], n3(:,16456), t3x128(:,:,8531))
  call heltable([8,16,128], n3(:,16457), t3x128(:,:,8532))
  call heltable([8,16,128], n3(:,16458), t3x128(:,:,8533))
  call heltable([8,16,128], n3(:,16459), t3x128(:,:,8534))
  call heltable([8,16,128], n3(:,16460), t3x128(:,:,8535))
  call heltable([8,16,128], n3(:,16461), t3x128(:,:,8536))
  call heltable([8,16,128], n3(:,16462), t3x128(:,:,8537))
  call heltable([8,16,128], n3(:,16463), t3x128(:,:,8538))
  call heltable([8,16,128], n3(:,16464), t3x128(:,:,8539))
  call heltable([8,16,128], n3(:,16465), t3x128(:,:,8540))
  call heltable([8,16,128], n3(:,16466), t3x128(:,:,8541))
  call heltable([8,16,128], n3(:,16467), t3x128(:,:,8542))
  call heltable([8,16,128], n3(:,16468), t3x128(:,:,8543))
  call heltable([8,16,128], n3(:,16469), t3x128(:,:,8544))
  call heltable([8,16,128], n3(:,16470), t3x128(:,:,8545))
  call heltable([8,16,128], n3(:,16471), t3x128(:,:,8546))
  call heltable([8,16,128], n3(:,16472), t3x128(:,:,8547))
  call heltable([8,16,128], n3(:,16473), t3x128(:,:,8548))
  call heltable([8,16,128], n3(:,16474), t3x128(:,:,8549))
  call heltable([8,16,128], n3(:,16475), t3x128(:,:,8550))
  call heltable([8,16,128], n3(:,16476), t3x128(:,:,8551))
  call heltable([8,16,128], n3(:,16477), t3x128(:,:,8552))
  call heltable([8,16,128], n3(:,16478), t3x128(:,:,8553))
  call heltable([8,16,128], n3(:,16479), t3x128(:,:,8554))
  call heltable([8,16,128], n3(:,16480), t3x128(:,:,8555))
  call heltable([8,16,128], n3(:,16481), t3x128(:,:,8556))
  call heltable([8,16,128], n3(:,16482), t3x128(:,:,8557))
  call heltable([8,16,128], n3(:,16483), t3x128(:,:,8558))
  call heltable([8,16,128], n3(:,16484), t3x128(:,:,8559))
  call heltable([8,16,128], n3(:,16485), t3x128(:,:,8560))
  call heltable([8,16,128], n3(:,16486), t3x128(:,:,8561))
  call heltable([8,16,128], n3(:,16487), t3x128(:,:,8562))
  call heltable([8,16,128], n3(:,16488), t3x128(:,:,8563))
  call heltable([8,16,128], n3(:,16489), t3x128(:,:,8564))
  call heltable([8,16,128], n3(:,16490), t3x128(:,:,8565))
  call heltable([8,16,128], n3(:,16491), t3x128(:,:,8566))
  call heltable([8,16,128], n3(:,16492), t3x128(:,:,8567))
  call heltable([8,16,128], n3(:,16493), t3x128(:,:,8568))
  call heltable([8,16,128], n3(:,16494), t3x128(:,:,8569))
  call heltable([8,16,128], n3(:,16495), t3x128(:,:,8570))
  call heltable([8,16,128], n3(:,16496), t3x128(:,:,8571))
  call heltable([8,16,128], n3(:,16497), t3x128(:,:,8572))
  call heltable([8,16,128], n3(:,16498), t3x128(:,:,8573))
  call heltable([8,16,128], n3(:,16499), t3x128(:,:,8574))
  call heltable([8,16,128], n3(:,16500), t3x128(:,:,8575))
  call heltable([8,16,128], n3(:,16501), t3x128(:,:,8576))
  call heltable([8,16,128], n3(:,16502), t3x128(:,:,8577))
  call heltable([8,16,128], n3(:,16503), t3x128(:,:,8578))
  call heltable([8,16,128], n3(:,16504), t3x128(:,:,8579))
  call heltable([8,16,128], n3(:,16505), t3x128(:,:,8580))
  call heltable([8,16,128], n3(:,16506), t3x128(:,:,8581))
  call heltable([8,16,128], n3(:,16507), t3x128(:,:,8582))
  call heltable([8,16,128], n3(:,16508), t3x128(:,:,8583))
  call heltable([8,16,128], n3(:,16509), t3x128(:,:,8584))
  call heltable([8,16,128], n3(:,16510), t3x128(:,:,8585))
  call heltable([8,16,128], n3(:,16511), t3x128(:,:,8586))
  call heltable([8,16,128], n3(:,16512), t3x128(:,:,8587))
  call heltable([8,16,128], n3(:,16513), t3x128(:,:,8588))
  call heltable([8,16,128], n3(:,16514), t3x128(:,:,8589))
  call heltable([8,16,128], n3(:,16515), t3x128(:,:,8590))
  call heltable([8,16,128], n3(:,16516), t3x128(:,:,8591))
  call heltable([8,16,128], n3(:,16517), t3x128(:,:,8592))
  call heltable([8,16,128], n3(:,16518), t3x128(:,:,8593))
  call heltable([8,16,128], n3(:,16519), t3x128(:,:,8594))
  call heltable([8,16,128], n3(:,16520), t3x128(:,:,8595))
  call heltable([8,16,128], n3(:,16521), t3x128(:,:,8596))
  call heltable([8,16,128], n3(:,16522), t3x128(:,:,8597))
  call heltable([8,16,128], n3(:,16523), t3x128(:,:,8598))
  call heltable([8,16,128], n3(:,16524), t3x128(:,:,8599))
  call heltable([8,16,128], n3(:,16525), t3x128(:,:,8600))
  call heltable([8,16,128], n3(:,16526), t3x128(:,:,8601))
  call heltable([8,16,128], n3(:,16527), t3x128(:,:,8602))
  call heltable([8,16,128], n3(:,16528), t3x128(:,:,8603))
  call heltable([8,16,128], n3(:,16529), t3x128(:,:,8604))
  call heltable([8,16,128], n3(:,16530), t3x128(:,:,8605))
  call heltable([8,16,128], n3(:,16531), t3x128(:,:,8606))
  call heltable([8,16,128], n3(:,16532), t3x128(:,:,8607))
  call heltable([8,16,128], n3(:,16533), t3x128(:,:,8608))
  call heltable([8,16,128], n3(:,16534), t3x128(:,:,8609))
  call heltable([8,16,128], n3(:,16535), t3x128(:,:,8610))
  call heltable([8,16,128], n3(:,16536), t3x128(:,:,8611))
  call heltable([8,16,128], n3(:,16537), t3x128(:,:,8612))
  call heltable([8,16,128], n3(:,16538), t3x128(:,:,8613))
  call heltable([8,16,128], n3(:,16539), t3x128(:,:,8614))
  call heltable([8,16,128], n3(:,16540), t3x128(:,:,8615))
  call heltable([8,16,128], n3(:,16541), t3x128(:,:,8616))
  call heltable([8,16,128], n3(:,16542), t3x128(:,:,8617))
  call heltable([8,16,128], n3(:,16543), t3x128(:,:,8618))
  call heltable([8,16,128], n3(:,16544), t3x128(:,:,8619))
  call heltable([8,16,128], n3(:,16545), t3x128(:,:,8620))
  call heltable([8,16,128], n3(:,16546), t3x128(:,:,8621))
  call heltable([8,16,128], n3(:,16547), t3x128(:,:,8622))
  call heltable([8,16,128], n3(:,16548), t3x128(:,:,8623))
  call heltable([8,16,128], n3(:,16549), t3x128(:,:,8624))
  call heltable([8,16,128], n3(:,16550), t3x128(:,:,8625))
  call heltable([8,16,128], n3(:,16551), t3x128(:,:,8626))
  call heltable([8,16,128], n3(:,16552), t3x128(:,:,8627))
  call heltable([8,16,128], n3(:,16553), t3x128(:,:,8628))
  call heltable([8,16,128], n3(:,16554), t3x128(:,:,8629))
  call heltable([8,16,128], n3(:,16555), t3x128(:,:,8630))
  call heltable([8,16,128], n3(:,16556), t3x128(:,:,8631))
  call heltable([8,16,128], n3(:,16557), t3x128(:,:,8632))
  call heltable([8,16,128], n3(:,16558), t3x128(:,:,8633))
  call heltable([8,16,128], n3(:,16559), t3x128(:,:,8634))
  call heltable([8,16,128], n3(:,16560), t3x128(:,:,8635))
  call heltable([8,16,128], n3(:,16561), t3x128(:,:,8636))
  call heltable([8,16,128], n3(:,16562), t3x128(:,:,8637))
  call heltable([8,16,128], n3(:,16563), t3x128(:,:,8638))
  call heltable([8,16,128], n3(:,16564), t3x128(:,:,8639))
  call heltable([8,16,128], n3(:,16565), t3x128(:,:,8640))
  call heltable([8,16,128], n3(:,16566), t3x128(:,:,8641))
  call heltable([8,16,128], n3(:,16567), t3x128(:,:,8642))
  call heltable([8,16,128], n3(:,16568), t3x128(:,:,8643))
  call heltable([8,16,128], n3(:,16569), t3x128(:,:,8644))
  call heltable([8,16,128], n3(:,16570), t3x128(:,:,8645))
  call heltable([8,16,128], n3(:,16571), t3x128(:,:,8646))
  call heltable([8,16,128], n3(:,16572), t3x128(:,:,8647))
  call heltable([8,16,128], n3(:,16573), t3x128(:,:,8648))
  call heltable([8,16,128], n3(:,16574), t3x128(:,:,8649))
  call heltable([8,16,128], n3(:,16575), t3x128(:,:,8650))
  call heltable([8,16,128], n3(:,16576), t3x128(:,:,8651))
  call heltable([8,16,128], n3(:,16577), t3x128(:,:,8652))
  call heltable([8,16,128], n3(:,16578), t3x128(:,:,8653))
  call heltable([8,16,128], n3(:,16579), t3x128(:,:,8654))
  call heltable([8,16,128], n3(:,16580), t3x128(:,:,8655))
  call heltable([8,16,128], n3(:,16581), t3x128(:,:,8656))
  call heltable([8,16,128], n3(:,16582), t3x128(:,:,8657))
  call heltable([8,16,128], n3(:,16583), t3x128(:,:,8658))
  call heltable([8,16,128], n3(:,16584), t3x128(:,:,8659))
  call heltable([8,16,128], n3(:,16585), t3x128(:,:,8660))
  call heltable([8,16,128], n3(:,16586), t3x128(:,:,8661))
  call heltable([8,16,128], n3(:,16587), t3x128(:,:,8662))
  call heltable([8,16,128], n3(:,16588), t3x128(:,:,8663))
  call heltable([8,16,128], n3(:,16589), t3x128(:,:,8664))
  call heltable([8,16,128], n3(:,16590), t3x128(:,:,8665))
  call heltable([8,16,128], n3(:,16591), t3x128(:,:,8666))
  call heltable([8,16,128], n3(:,16592), t3x128(:,:,8667))
  call heltable([8,16,128], n3(:,16593), t3x128(:,:,8668))
  call heltable([8,16,128], n3(:,16594), t3x128(:,:,8669))
  call heltable([8,16,128], n3(:,16595), t3x128(:,:,8670))
  call heltable([8,16,128], n3(:,16596), t3x128(:,:,8671))
  call heltable([8,16,128], n3(:,16597), t3x128(:,:,8672))
  call heltable([8,16,128], n3(:,16598), t3x128(:,:,8673))
  call heltable([8,16,128], n3(:,16599), t3x128(:,:,8674))
  call heltable([8,16,128], n3(:,16600), t3x128(:,:,8675))
  call heltable([8,16,128], n3(:,16601), t3x128(:,:,8676))
  call heltable([8,16,128], n3(:,16602), t3x128(:,:,8677))
  call heltable([8,16,128], n3(:,16603), t3x128(:,:,8678))
  call heltable([8,16,128], n3(:,16604), t3x128(:,:,8679))
  call heltable([8,16,128], n3(:,16605), t3x128(:,:,8680))
  call heltable([8,16,128], n3(:,16606), t3x128(:,:,8681))
  call heltable([8,16,128], n3(:,16607), t3x128(:,:,8682))
  call heltable([8,16,128], n3(:,16608), t3x128(:,:,8683))
  call heltable([8,16,128], n3(:,16609), t3x128(:,:,8684))
  call heltable([16,8,128], n3(:,16610), t3x128(:,:,8685))
  call heltable([16,8,128], n3(:,16611), t3x128(:,:,8686))
  call heltable([16,8,128], n3(:,16612), t3x128(:,:,8687))
  call heltable([16,8,128], n3(:,16613), t3x128(:,:,8688))
  call heltable([16,8,128], n3(:,16614), t3x128(:,:,8689))
  call heltable([16,8,128], n3(:,16615), t3x128(:,:,8690))
  call heltable([16,8,128], n3(:,16616), t3x128(:,:,8691))
  call heltable([16,8,128], n3(:,16617), t3x128(:,:,8692))
  call heltable([16,8,128], n3(:,16618), t3x128(:,:,8693))
  call heltable([16,8,128], n3(:,16619), t3x128(:,:,8694))
  call heltable([16,8,128], n3(:,16620), t3x128(:,:,8695))
  call heltable([16,8,128], n3(:,16621), t3x128(:,:,8696))
  call heltable([16,8,128], n3(:,16622), t3x128(:,:,8697))
  call heltable([16,8,128], n3(:,16623), t3x128(:,:,8698))
  call heltable([16,8,128], n3(:,16624), t3x128(:,:,8699))
  call heltable([16,8,128], n3(:,16625), t3x128(:,:,8700))
  call heltable([8,16,128], n3(:,16626), t3x128(:,:,8701))
  call heltable([8,16,128], n3(:,16627), t3x128(:,:,8702))
  call heltable([8,16,128], n3(:,16628), t3x128(:,:,8703))
  call heltable([8,16,12