
module ol_vamp_6_aahhh2_hhhaa_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G0tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_6(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_aahhh2_hhhaa_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_aahhh2_hhhaa_3.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_aahhh2_hhhaa_3_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_aahhh2_hhhaa_3_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,26) :: G0
  complex(REALKIND), dimension(4,5,4,44) :: G1
  complex(REALKIND), dimension(4,15,4,88) :: G2
  complex(REALKIND), dimension(4,35,4,96) :: G3
  complex(REALKIND), dimension(4,70,4,96) :: G4
  complex(REALKIND), pointer :: G0tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G0tensorhel(1,28,4))
    allocate(G2tensorhel(15,12,4))
    allocate(G5tensorhel(126,48,4))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G0tensor => G0tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AS_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2),gH)
  call loop_A_Q(G0(:,:,:,2),Q(:,2),ML,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,10),ML,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-4),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,26),ML,G3(:,:,:,1))
  call loop_AS_Q(G3(:,:,:,1),wf(:,-2),G3(:,:,:,2),gH)
  call loop_A_Q(G3(:,:,:,2),Q(:,30),ML,G4(:,:,:,1))
  call loop_AS_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),ML,G5tensor(:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,3),gH)
  call loop_A_Q(G2(:,:,:,3),Q(:,14),ML,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-4),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,30),ML,G4(:,:,:,3))
  call loop_AS_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),ML,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,18),ML,G2(:,:,:,4))
  call loop_AV_Q(G2(:,:,:,4),wf(:,-3),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,26),ML,G3(:,:,:,5))
  call loop_AS_Q(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6),gH)
  call loop_A_Q(G3(:,:,:,6),Q(:,30),ML,G4(:,:,:,5))
  call loop_AS_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),ML,G5tensor(:,3))
  call loop_AS_Q(G2(:,:,:,4),wf(:,-2),G2(:,:,:,6),gH)
  call loop_A_Q(G2(:,:,:,6),Q(:,22),ML,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-3),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,30),ML,G4(:,:,:,7))
  call loop_AS_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),ML,G5tensor(:,4))
  call loop_AS_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,4),gH)
  call loop_A_Q(G1(:,:,:,4),Q(:,6),ML,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-4),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,22),ML,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,-3),G3(:,:,:,10))
  call loop_A_Q(G3(:,:,:,10),Q(:,30),ML,G4(:,:,:,9))
  call loop_AS_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,31),ML,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-3),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,14),ML,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-4),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,30),ML,G4(:,:,:,11))
  call loop_AS_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,31),ML,G5tensor(:,6))
  call loop_QS_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,3),gH)
  call loop_Q_A(G0(:,:,:,3),Q(:,2),ME,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,-3),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,10),ME,G2(:,:,:,10))
  call loop_QV_A(G2(:,:,:,10),wf(:,-4),G2(:,:,:,11))
  call loop_Q_A(G2(:,:,:,11),Q(:,26),ME,G3(:,:,:,13))
  call loop_QS_A(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14),gH)
  call loop_Q_A(G3(:,:,:,14),Q(:,30),ME,G4(:,:,:,13))
  call loop_QS_A(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,31),ME,G5tensor(:,7))
  call loop_QS_A(G2(:,:,:,10),wf(:,-2),G2(:,:,:,12),gH)
  call loop_Q_A(G2(:,:,:,12),Q(:,14),ME,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_Q_A(G3(:,:,:,16),Q(:,30),ME,G4(:,:,:,15))
  call loop_QS_A(G4(:,:,:,15),wf(:,0),G4(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,31),ME,G5tensor(:,8))
  call loop_QV_A(G1(:,:,:,5),wf(:,-4),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,18),ME,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,-3),G2(:,:,:,14))
  call loop_Q_A(G2(:,:,:,14),Q(:,26),ME,G3(:,:,:,17))
  call loop_QS_A(G3(:,:,:,17),wf(:,-2),G3(:,:,:,18),gH)
  call loop_Q_A(G3(:,:,:,18),Q(:,30),ME,G4(:,:,:,17))
  call loop_QS_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,31),ME,G5tensor(:,9))
  call loop_QS_A(G2(:,:,:,13),wf(:,-2),G2(:,:,:,15),gH)
  call loop_Q_A(G2(:,:,:,15),Q(:,22),ME,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,-3),G3(:,:,:,20))
  call loop_Q_A(G3(:,:,:,20),Q(:,30),ME,G4(:,:,:,19))
  call loop_QS_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,31),ME,G5tensor(:,10))
  call loop_QS_A(G1(:,:,:,5),wf(:,-2),G1(:,:,:,8),gH)
  call loop_Q_A(G1(:,:,:,8),Q(:,6),ME,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,-4),G2(:,:,:,17))
  call loop_Q_A(G2(:,:,:,17),Q(:,22),ME,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,-3),G3(:,:,:,22))
  call loop_Q_A(G3(:,:,:,22),Q(:,30),ME,G4(:,:,:,21))
  call loop_QS_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,31),ME,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,16),wf(:,-3),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,14),ME,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,30),ME,G4(:,:,:,23))
  call loop_QS_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,31),ME,G5tensor(:,12))
  call loop_QS_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,4),gH)
  call loop_Q_A(G0(:,:,:,4),Q(:,2),MM,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-3),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,10),MM,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-4),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,26),MM,G3(:,:,:,25))
  call loop_QS_A(G3(:,:,:,25),wf(:,-2),G3(:,:,:,26),gH)
  call loop_Q_A(G3(:,:,:,26),Q(:,30),MM,G4(:,:,:,25))
  call loop_QS_A(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,31),MM,G5tensor(:,13))
  call loop_QS_A(G2(:,:,:,19),wf(:,-2),G2(:,:,:,21),gH)
  call loop_Q_A(G2(:,:,:,21),Q(:,14),MM,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,-4),G3(:,:,:,28))
  call loop_Q_A(G3(:,:,:,28),Q(:,30),MM,G4(:,:,:,27))
  call loop_QS_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,31),MM,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,9),wf(:,-4),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,18),MM,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,-3),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,26),MM,G3(:,:,:,29))
  call loop_QS_A(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30),gH)
  call loop_Q_A(G3(:,:,:,30),Q(:,30),MM,G4(:,:,:,29))
  call loop_QS_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,31),MM,G5tensor(:,15))
  call loop_QS_A(G2(:,:,:,22),wf(:,-2),G2(:,:,:,24),gH)
  call loop_Q_A(G2(:,:,:,24),Q(:,22),MM,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,30),MM,G4(:,:,:,31))
  call loop_QS_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,31),MM,G5tensor(:,16))
  call loop_QS_A(G1(:,:,:,9),wf(:,-2),G1(:,:,:,12),gH)
  call loop_Q_A(G1(:,:,:,12),Q(:,6),MM,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,-4),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,22),MM,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,-3),G3(:,:,:,34))
  call loop_Q_A(G3(:,:,:,34),Q(:,30),MM,G4(:,:,:,33))
  call loop_QS_A(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,31),MM,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,25),wf(:,-3),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,14),MM,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,-4),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,30),MM,G4(:,:,:,35))
  call loop_QS_A(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,31),MM,G5tensor(:,18))
  call loop_QS_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,5),gH)
  call loop_Q_A(G0(:,:,:,5),Q(:,2),ML,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-3),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,10),ML,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-4),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,26),ML,G3(:,:,:,37))
  call loop_QS_A(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38),gH)
  call loop_Q_A(G3(:,:,:,38),Q(:,30),ML,G4(:,:,:,37))
  call loop_QS_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,31),ML,G5tensor(:,19))
  call loop_QS_A(G2(:,:,:,28),wf(:,-2),G2(:,:,:,30),gH)
  call loop_Q_A(G2(:,:,:,30),Q(:,14),ML,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,30),ML,G4(:,:,:,39))
  call loop_QS_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,31),ML,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,13),wf(:,-4),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,18),ML,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-3),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,26),ML,G3(:,:,:,41))
  call loop_QS_A(G3(:,:,:,41),wf(:,-2),G3(:,:,:,42),gH)
  call loop_Q_A(G3(:,:,:,42),Q(:,30),ML,G4(:,:,:,41))
  call loop_QS_A(G4(:,:,:,41),wf(:,0),G4(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,31),ML,G5tensor(:,21))
  call loop_QS_A(G2(:,:,:,31),wf(:,-2),G2(:,:,:,33),gH)
  call loop_Q_A(G2(:,:,:,33),Q(:,22),ML,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,-3),G3(:,:,:,44))
  call loop_Q_A(G3(:,:,:,44),Q(:,30),ML,G4(:,:,:,43))
  call loop_QS_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,31),ML,G5tensor(:,22))
  call loop_QS_A(G1(:,:,:,13),wf(:,-2),G1(:,:,:,16),gH)
  call loop_Q_A(G1(:,:,:,16),Q(:,6),ML,G2(:,:,:,34))
  call loop_QV_A(G2(:,:,:,34),wf(:,-4),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,22),ML,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-3),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,30),ML,G4(:,:,:,45))
  call loop_QS_A(G4(:,:,:,45),wf(:,0),G4(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,31),ML,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,34),wf(:,-3),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,14),ML,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,30),ML,G4(:,:,:,47))
  call loop_QS_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,31),ML,G5tensor(:,24))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,6),gH)
  call loop_A_Q(G0(:,:,:,6),Q(:,2),MT,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-3),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,10),MT,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,26),MT,G3(:,:,:,49))
  call loop_AS_Q(G3(:,:,:,49),wf(:,-2),G3(:,:,:,50),gH)
  call loop_A_Q(G3(:,:,:,50),Q(:,30),MT,G4(:,:,:,49))
  call loop_AS_Q(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,31),MT,G5tensor(:,25))
  call loop_AS_Q(G2(:,:,:,37),wf(:,-2),G2(:,:,:,39),gH)
  call loop_A_Q(G2(:,:,:,39),Q(:,14),MT,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_A_Q(G3(:,:,:,52),Q(:,30),MT,G4(:,:,:,51))
  call loop_AS_Q(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,31),MT,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-4),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,18),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-3),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,26),MT,G3(:,:,:,53))
  call loop_AS_Q(G3(:,:,:,53),wf(:,-2),G3(:,:,:,54),gH)
  call loop_A_Q(G3(:,:,:,54),Q(:,30),MT,G4(:,:,:,53))
  call loop_AS_Q(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,31),MT,G5tensor(:,27))
  call loop_AS_Q(G2(:,:,:,40),wf(:,-2),G2(:,:,:,42),gH)
  call loop_A_Q(G2(:,:,:,42),Q(:,22),MT,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-3),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,30),MT,G4(:,:,:,55))
  call loop_AS_Q(G4(:,:,:,55),wf(:,0),G4(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,31),MT,G5tensor(:,28))
  call loop_AS_Q(G1(:,:,:,17),wf(:,-2),G1(:,:,:,20),gH)
  call loop_A_Q(G1(:,:,:,20),Q(:,6),MT,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-4),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,22),MT,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-3),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,30),MT,G4(:,:,:,57))
  call loop_AS_Q(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,31),MT,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-3),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,14),MT,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-4),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,30),MT,G4(:,:,:,59))
  call loop_AS_Q(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,31),MT,G5tensor(:,30))
  call loop_QS_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,7),gH)
  call loop_Q_A(G0(:,:,:,7),Q(:,2),MT,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,-3),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,10),MT,G2(:,:,:,46))
  call loop_QV_A(G2(:,:,:,46),wf(:,-4),G2(:,:,:,47))
  call loop_Q_A(G2(:,:,:,47),Q(:,26),MT,G3(:,:,:,61))
  call loop_QS_A(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62),gH)
  call loop_Q_A(G3(:,:,:,62),Q(:,30),MT,G4(:,:,:,61))
  call loop_QS_A(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,31),MT,G5tensor(:,31))
  call loop_QS_A(G2(:,:,:,46),wf(:,-2),G2(:,:,:,48),gH)
  call loop_Q_A(G2(:,:,:,48),Q(:,14),MT,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-4),G3(:,:,:,64))
  call loop_Q_A(G3(:,:,:,64),Q(:,30),MT,G4(:,:,:,63))
  call loop_QS_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,31),MT,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,21),wf(:,-4),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,18),MT,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-3),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,26),MT,G3(:,:,:,65))
  call loop_QS_A(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66),gH)
  call loop_Q_A(G3(:,:,:,66),Q(:,30),MT,G4(:,:,:,65))
  call loop_QS_A(G4(:,:,:,65),wf(:,0),G4(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,31),MT,G5tensor(:,33))
  call loop_QS_A(G2(:,:,:,49),wf(:,-2),G2(:,:,:,51),gH)
  call loop_Q_A(G2(:,:,:,51),Q(:,22),MT,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-3),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,30),MT,G4(:,:,:,67))
  call loop_QS_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,31),MT,G5tensor(:,34))
  call loop_QS_A(G1(:,:,:,21),wf(:,-2),G1(:,:,:,24),gH)
  call loop_Q_A(G1(:,:,:,24),Q(:,6),MT,G2(:,:,:,52))
  call loop_QV_A(G2(:,:,:,52),wf(:,-4),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,22),MT,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-3),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,30),MT,G4(:,:,:,69))
  call loop_QS_A(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,31),MT,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,52),wf(:,-3),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,14),MT,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,30),MT,G4(:,:,:,71))
  call loop_QS_A(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,31),MT,G5tensor(:,36))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,8),gH)
  call loop_A_Q(G0(:,:,:,8),Q(:,2),MB,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-3),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,10),MB,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-4),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,26),MB,G3(:,:,:,73))
  call loop_AS_Q(G3(:,:,:,73),wf(:,-2),G3(:,:,:,74),gH)
  call loop_A_Q(G3(:,:,:,74),Q(:,30),MB,G4(:,:,:,73))
  call loop_AS_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,31),MB,G5tensor(:,37))
  call loop_AS_Q(G2(:,:,:,55),wf(:,-2),G2(:,:,:,57),gH)
  call loop_A_Q(G2(:,:,:,57),Q(:,14),MB,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-4),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,30),MB,G4(:,:,:,75))
  call loop_AS_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,31),MB,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,18),MB,G2(:,:,:,58))
  call loop_AV_Q(G2(:,:,:,58),wf(:,-3),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,26),MB,G3(:,:,:,77))
  call loop_AS_Q(G3(:,:,:,77),wf(:,-2),G3(:,:,:,78),gH)
  call loop_A_Q(G3(:,:,:,78),Q(:,30),MB,G4(:,:,:,77))
  call loop_AS_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,31),MB,G5tensor(:,39))
  call loop_AS_Q(G2(:,:,:,58),wf(:,-2),G2(:,:,:,60),gH)
  call loop_A_Q(G2(:,:,:,60),Q(:,22),MB,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-3),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,30),MB,G4(:,:,:,79))
  call loop_AS_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,31),MB,G5tensor(:,40))
  call loop_AS_Q(G1(:,:,:,25),wf(:,-2),G1(:,:,:,28),gH)
  call loop_A_Q(G1(:,:,:,28),Q(:,6),MB,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,22),MB,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,-3),G3(:,:,:,82))
  call loop_A_Q(G3(:,:,:,82),Q(:,30),MB,G4(:,:,:,81))
  call loop_AS_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,31),MB,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-3),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,14),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-4),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,30),MB,G4(:,:,:,83))
  call loop_AS_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,31),MB,G5tensor(:,42))
  call loop_QS_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,9),gH)
  call loop_Q_A(G0(:,:,:,9),Q(:,2),MB,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,-3),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,10),MB,G2(:,:,:,64))
  call loop_QV_A(G2(:,:,:,64),wf(:,-4),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,26),MB,G3(:,:,:,85))
  call loop_QS_A(G3(:,:,:,85),wf(:,-2),G3(:,:,:,86),gH)
  call loop_Q_A(G3(:,:,:,86),Q(:,30),MB,G4(:,:,:,85))
  call loop_QS_A(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,31),MB,G5tensor(:,43))
  call loop_QS_A(G2(:,:,:,64),wf(:,-2),G2(:,:,:,66),gH)
  call loop_Q_A(G2(:,:,:,66),Q(:,14),MB,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,30),MB,G4(:,:,:,87))
  call loop_QS_A(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,31),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,18),MB,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-3),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,26),MB,G3(:,:,:,89))
  call loop_QS_A(G3(:,:,:,89),wf(:,-2),G3(:,:,:,90),gH)
  call loop_Q_A(G3(:,:,:,90),Q(:,30),MB,G4(:,:,:,89))
  call loop_QS_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,31),MB,G5tensor(:,45))
  call loop_QS_A(G2(:,:,:,67),wf(:,-2),G2(:,:,:,69),gH)
  call loop_Q_A(G2(:,:,:,69),Q(:,22),MB,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,-3),G3(:,:,:,92))
  call loop_Q_A(G3(:,:,:,92),Q(:,30),MB,G4(:,:,:,91))
  call loop_QS_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,31),MB,G5tensor(:,46))
  call loop_QS_A(G1(:,:,:,29),wf(:,-2),G1(:,:,:,32),gH)
  call loop_Q_A(G1(:,:,:,32),Q(:,6),MB,G2(:,:,:,70))
  call loop_QV_A(G2(:,:,:,70),wf(:,-4),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,22),MB,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-3),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,30),MB,G4(:,:,:,93))
  call loop_QS_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,31),MB,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,70),wf(:,-3),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,14),MB,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,30),MB,G4(:,:,:,95))
  call loop_QS_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,31),MB,G5tensor(:,48))
  call loop_SS_S(G0(:,:,:,1),wf(:,-1),G0(:,:,:,10))
  call loop_DV_C(G0(:,:,:,10),Q(:,2),wf(:,-3),G1(:,:,:,33))
  call loop_DV_C(G1(:,:,:,33),Q(:,10),wf(:,-4),G2(:,:,:,73))
  call loop_SS_S(G2(:,:,:,73),wf(:,-2),G2(:,:,:,74))
  call check_last_SS_S(l_switch,G2(:,:,:,74),wf(:,0),G2tensor(:,1))
  call loop_SS_S(G1(:,:,:,33),wf(:,-2),G1(:,:,:,34))
  call loop_DV_C(G1(:,:,:,34),Q(:,14),wf(:,-4),G2(:,:,:,75))
  call check_last_SS_S(l_switch,G2(:,:,:,75),wf(:,0),G2tensor(:,2))
  call loop_DV_C(G0(:,:,:,10),Q(:,2),wf(:,-4),G1(:,:,:,35))
  call loop_DV_C(G1(:,:,:,35),Q(:,18),wf(:,-3),G2(:,:,:,76))
  call loop_SS_S(G2(:,:,:,76),wf(:,-2),G2(:,:,:,77))
  call check_last_SS_S(l_switch,G2(:,:,:,77),wf(:,0),G2tensor(:,3))
  call loop_SS_S(G1(:,:,:,35),wf(:,-2),G1(:,:,:,36))
  call loop_DV_C(G1(:,:,:,36),Q(:,22),wf(:,-3),G2(:,:,:,78))
  call check_last_SS_S(l_switch,G2(:,:,:,78),wf(:,0),G2tensor(:,4))
  call loop_SS_S(G0(:,:,:,10),wf(:,-2),G0(:,:,:,11))
  call loop_DV_C(G0(:,:,:,11),Q(:,6),wf(:,-4),G1(:,:,:,37))
  call loop_DV_C(G1(:,:,:,37),Q(:,22),wf(:,-3),G2(:,:,:,79))
  call check_last_SS_S(l_switch,G2(:,:,:,79),wf(:,0),G2tensor(:,5))
  call loop_DV_C(G0(:,:,:,11),Q(:,6),wf(:,-3),G1(:,:,:,38))
  call loop_DV_C(G1(:,:,:,38),Q(:,14),wf(:,-4),G2(:,:,:,80))
  call check_last_SS_S(l_switch,G2(:,:,:,80),wf(:,0),G2tensor(:,6))
  call loop_SS_S(G0(:,:,:,1),wf(:,-1),G0(:,:,:,12))
  call loop_CV_D(G0(:,:,:,12),Q(:,2),wf(:,-3),Q(:,8),G1(:,:,:,39))
  call loop_CV_D(G1(:,:,:,39),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,81))
  call loop_SS_S(G2(:,:,:,81),wf(:,-2),G2(:,:,:,82))
  call check_last_SS_S(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,7))
  call loop_SS_S(G1(:,:,:,39),wf(:,-2),G1(:,:,:,40))
  call loop_CV_D(G1(:,:,:,40),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,83))
  call check_last_SS_S(l_switch,G2(:,:,:,83),wf(:,0),G2tensor(:,8))
  call loop_CV_D(G0(:,:,:,12),Q(:,2),wf(:,-4),Q(:,16),G1(:,:,:,41))
  call loop_CV_D(G1(:,:,:,41),Q(:,18),wf(:,-3),Q(:,8),G2(:,:,:,84))
  call loop_SS_S(G2(:,:,:,84),wf(:,-2),G2(:,:,:,85))
  call check_last_SS_S(l_switch,G2(:,:,:,85),wf(:,0),G2tensor(:,9))
  call loop_SS_S(G1(:,:,:,41),wf(:,-2),G1(:,:,:,42))
  call loop_CV_D(G1(:,:,:,42),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,86))
  call check_last_SS_S(l_switch,G2(:,:,:,86),wf(:,0),G2tensor(:,10))
  call loop_SS_S(G0(:,:,:,12),wf(:,-2),G0(:,:,:,13))
  call loop_CV_D(G0(:,:,:,13),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,43))
  call loop_CV_D(G1(:,:,:,43),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,87))
  call check_last_SS_S(l_switch,G2(:,:,:,87),wf(:,0),G2tensor(:,11))
  call loop_CV_D(G0(:,:,:,13),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,44))
  call loop_CV_D(G1(:,:,:,44),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,88))
  call check_last_SS_S(l_switch,G2(:,:,:,88),wf(:,0),G2tensor(:,12))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,14))
  call check_last_SSV_V(l_switch,G0(:,:,:,14),wf(:,-2),wf(:,-3),G0tensor(:,1))
  call loop_SSV_V(G0(:,:,:,1),wf(:,-2),wf(:,-4),G0(:,:,:,15))
  call check_last_VVS_S(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,1),G0tensor(:,2))
  call loop_SVV_S(G0(:,:,:,1),wf(:,-4),wf(:,-3),G0(:,:,:,16))
  call check_last_SSS_S(l_switch,G0(:,:,:,16),wf(:,-2),wf(:,1),G0tensor(:,3))
  call check_last_SSS_S(l_switch,G0(:,:,:,16),wf(:,-1),wf(:,3),G0tensor(:,4))
  call check_last_SSS_S(l_switch,G0(:,:,:,16),wf(:,0),wf(:,7),G0tensor(:,5))
  call check_last_SS_S(l_switch,G0(:,:,:,16),wf(:,5),G0tensor(:,6))
  call check_last_SS_S(l_switch,G0(:,:,:,16),wf(:,9),G0tensor(:,7))
  call check_last_SS_S(l_switch,G0(:,:,:,16),wf(:,10),G0tensor(:,8))
  call check_last_SS_S(l_switch,G0(:,:,:,16),wf(:,11),G0tensor(:,9))
  call loop_VWW_V(G0(:,:,:,1),wf(:,-4),wf(:,-3),G0(:,:,:,17))
  call check_last_VSS_V(l_switch,G0(:,:,:,17),wf(:,-2),wf(:,1),G0tensor(:,10))
  call check_last_VSS_V(l_switch,G0(:,:,:,17),wf(:,-1),wf(:,3),G0tensor(:,11))
  call check_last_VSS_V(l_switch,G0(:,:,:,17),wf(:,0),wf(:,7),G0tensor(:,12))
  call check_last_VS_V(l_switch,G0(:,:,:,17),wf(:,5),G0tensor(:,13))
  call check_last_VS_V(l_switch,G0(:,:,:,17),wf(:,9),G0tensor(:,14))
  call check_last_VS_V(l_switch,G0(:,:,:,17),wf(:,10),G0tensor(:,15))
  call check_last_VS_V(l_switch,G0(:,:,:,17),wf(:,11),G0tensor(:,16))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-4),wf(:,3),G0(:,:,:,18))
  call check_last_SSV_V(l_switch,G0(:,:,:,18),wf(:,-1),wf(:,-3),G0tensor(:,17))
  call loop_SSV_V(G0(:,:,:,1),wf(:,-1),wf(:,-4),G0(:,:,:,19))
  call check_last_VVS_S(l_switch,G0(:,:,:,19),wf(:,-3),wf(:,3),G0tensor(:,18))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-4),wf(:,7),G0(:,:,:,20))
  call check_last_SSV_V(l_switch,G0(:,:,:,20),wf(:,0),wf(:,-3),G0tensor(:,19))
  call loop_SSV_V(G0(:,:,:,1),wf(:,0),wf(:,-4),G0(:,:,:,21))
  call check_last_VVS_S(l_switch,G0(:,:,:,21),wf(:,-3),wf(:,7),G0tensor(:,20))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-4),wf(:,5),G0(:,:,:,22))
  call check_last_SV_V(l_switch,G0(:,:,:,22),wf(:,-3),G0tensor(:,21))
  call loop_SV_V(G0(:,:,:,1),wf(:,-4),G0(:,:,:,23))
  call check_last_VVS_S(l_switch,G0(:,:,:,23),wf(:,-3),wf(:,5),G0tensor(:,22))
  call check_last_VVS_S(l_switch,G0(:,:,:,23),wf(:,-3),wf(:,9),G0tensor(:,23))
  call check_last_VVS_S(l_switch,G0(:,:,:,23),wf(:,-3),wf(:,10),G0tensor(:,24))
  call check_last_VVS_S(l_switch,G0(:,:,:,23),wf(:,-3),wf(:,11),G0tensor(:,25))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-4),wf(:,9),G0(:,:,:,24))
  call check_last_SV_V(l_switch,G0(:,:,:,24),wf(:,-3),G0tensor(:,26))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-4),wf(:,10),G0(:,:,:,25))
  call check_last_SV_V(l_switch,G0(:,:,:,25),wf(:,-3),G0tensor(:,27))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-4),wf(:,11),G0(:,:,:,26))
  call check_last_SV_V(l_switch,G0(:,:,:,26),wf(:,-3),G0tensor(:,28))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_65,masses2_16,G5tensor(:,1),T5sum(1:126,3))
  M(2) = M(2) + (-f(60)) * TI2_call(5,momenta_65,masses2_15,G5tensor(:,7),T5sum(1:126,1))
  M(2) = M(2) + (-f(68)) * TI2_call(5,momenta_65,masses2_17,G5tensor(:,13),T5sum(1:126,2))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_65,masses2_16,G5tensor(:,19),T5sum(1:126,3))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_65,masses2_18,G5tensor(:,25),T5sum(1:126,4))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_65,masses2_18,G5tensor(:,31),T5sum(1:126,4))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_65,masses2_14,G5tensor(:,37),T5sum(1:126,5))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_65,masses2_14,G5tensor(:,43),T5sum(1:126,5))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,1),T4sum(1:15,55))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,7),T4sum(1:15,55))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,1),T4sum(1:15,55))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,7),T4sum(1:15,55))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_67,masses2_16,G5tensor(:,3),T5sum(1:126,8))
  M(2) = M(2) + (-f(60)) * TI2_call(5,momenta_67,masses2_15,G5tensor(:,9),T5sum(1:126,6))
  M(2) = M(2) + (-f(68)) * TI2_call(5,momenta_67,masses2_17,G5tensor(:,15),T5sum(1:126,7))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_67,masses2_16,G5tensor(:,21),T5sum(1:126,8))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_67,masses2_18,G5tensor(:,27),T5sum(1:126,9))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_67,masses2_18,G5tensor(:,33),T5sum(1:126,9))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_67,masses2_14,G5tensor(:,39),T5sum(1:126,10))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_67,masses2_14,G5tensor(:,45),T5sum(1:126,10))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,3),T4sum(1:15,56))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,9),T4sum(1:15,56))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,3),T4sum(1:15,56))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,9),T4sum(1:15,56))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_63,masses2_16,G5tensor(:,5),T5sum(1:126,13))
  M(2) = M(2) + (-f(60)) * TI2_call(5,momenta_63,masses2_15,G5tensor(:,11),T5sum(1:126,11))
  M(2) = M(2) + (-f(68)) * TI2_call(5,momenta_63,masses2_17,G5tensor(:,17),T5sum(1:126,12))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_63,masses2_16,G5tensor(:,23),T5sum(1:126,13))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_63,masses2_18,G5tensor(:,29),T5sum(1:126,14))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_63,masses2_18,G5tensor(:,35),T5sum(1:126,14))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_63,masses2_14,G5tensor(:,41),T5sum(1:126,15))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_63,masses2_14,G5tensor(:,47),T5sum(1:126,15))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,5),T4sum(1:15,57))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,11),T4sum(1:15,57))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,5),T4sum(1:15,57))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,11),T4sum(1:15,57))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_66,masses2_16,G5tensor(:,4),T5sum(1:126,18))
  M(2) = M(2) + (-f(60)) * TI2_call(5,momenta_66,masses2_15,G5tensor(:,10),T5sum(1:126,16))
  M(2) = M(2) + (-f(68)) * TI2_call(5,momenta_66,masses2_17,G5tensor(:,16),T5sum(1:126,17))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_66,masses2_16,G5tensor(:,22),T5sum(1:126,18))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_66,masses2_18,G5tensor(:,28),T5sum(1:126,19))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_66,masses2_18,G5tensor(:,34),T5sum(1:126,19))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_66,masses2_14,G5tensor(:,40),T5sum(1:126,20))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_66,masses2_14,G5tensor(:,46),T5sum(1:126,20))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,4),T4sum(1:15,58))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,10),T4sum(1:15,58))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,4),T4sum(1:15,58))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,10),T4sum(1:15,58))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_62,masses2_16,G5tensor(:,6),T5sum(1:126,23))
  M(2) = M(2) + (-f(60)) * TI2_call(5,momenta_62,masses2_15,G5tensor(:,12),T5sum(1:126,21))
  M(2) = M(2) + (-f(68)) * TI2_call(5,momenta_62,masses2_17,G5tensor(:,18),T5sum(1:126,22))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_62,masses2_16,G5tensor(:,24),T5sum(1:126,23))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_62,masses2_18,G5tensor(:,30),T5sum(1:126,24))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_62,masses2_18,G5tensor(:,36),T5sum(1:126,24))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_62,masses2_14,G5tensor(:,42),T5sum(1:126,25))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_62,masses2_14,G5tensor(:,48),T5sum(1:126,25))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,6),T4sum(1:15,59))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,12),T4sum(1:15,59))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,6),T4sum(1:15,59))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,12),T4sum(1:15,59))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_64,masses2_16,G5tensor(:,2),T5sum(1:126,28))
  M(2) = M(2) + (-f(60)) * TI2_call(5,momenta_64,masses2_15,G5tensor(:,8),T5sum(1:126,26))
  M(2) = M(2) + (-f(68)) * TI2_call(5,momenta_64,masses2_17,G5tensor(:,14),T5sum(1:126,27))
  M(2) = M(2) + (-f(64)) * TI2_call(5,momenta_64,masses2_16,G5tensor(:,20),T5sum(1:126,28))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_64,masses2_18,G5tensor(:,26),T5sum(1:126,29))
  M(2) = M(2) + (-3*f(72)) * TI2_call(5,momenta_64,masses2_18,G5tensor(:,32),T5sum(1:126,29))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_64,masses2_14,G5tensor(:,38),T5sum(1:126,30))
  M(2) = M(2) + (-3*f(56)) * TI2_call(5,momenta_64,masses2_14,G5tensor(:,44),T5sum(1:126,30))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,2),T4sum(1:15,60))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,8),T4sum(1:15,60))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,2),T4sum(1:15,60))
  M(2) = M(2) + (-f(45)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,8),T4sum(1:15,60))
  M(2) = M(2) + (-f(18) * den(1)) * TI2_call(0,momenta_4,masses2_1,G0tensor(:,1),T0sum(1:1,7))
  M(2) = M(2) + (-f(18) * den(1)) * TI2_call(0,momenta_4,masses2_1,G0tensor(:,1),T0sum(1:1,7))
  M(2) = M(2) + (-f(18) * den(1)) * TI2_call(0,momenta_5,masses2_1,G0tensor(:,2),T0sum(1:1,8))
  M(2) = M(2) + (-f(18) * den(1)) * TI2_call(0,momenta_5,masses2_1,G0tensor(:,2),T0sum(1:1,8))
  M(2) = M(2) + (-f(7) * den(1)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,3),T0sum(1:1,9))
  M(2) = M(2) + (-f(19) * den(1)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,10),T0sum(1:1,9))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(0,momenta_6,masses2_1,G0tensor(:,17),T0sum(1:1,10))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(0,momenta_6,masses2_1,G0tensor(:,17),T0sum(1:1,10))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(0,momenta_3,masses2_1,G0tensor(:,18),T0sum(1:1,11))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(0,momenta_3,masses2_1,G0tensor(:,18),T0sum(1:1,11))
  M(2) = M(2) + (-f(7) * den(2)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,4),T0sum(1:1,9))
  M(2) = M(2) + (-f(19) * den(2)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,11),T0sum(1:1,9))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(0,momenta_7,masses2_1,G0tensor(:,19),T0sum(1:1,12))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(0,momenta_7,masses2_1,G0tensor(:,19),T0sum(1:1,12))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(0,momenta_2,masses2_1,G0tensor(:,20),T0sum(1:1,13))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(0,momenta_2,masses2_1,G0tensor(:,20),T0sum(1:1,13))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,5),T0sum(1:1,9))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,12),T0sum(1:1,9))
  M(1) = M(1) + (-f(20) * den(3)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,21),T0sum(1:1,14))
  M(1) = M(1) + (-f(20) * den(3)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,21),T0sum(1:1,14))
  M(1) = M(1) + (-f(20) * den(3)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,22),T0sum(1:1,15))
  M(1) = M(1) + (-f(20) * den(3)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,22),T0sum(1:1,15))
  M(1) = M(1) + (-f(9) * den(3)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,6),T0sum(1:1,9))
  M(1) = M(1) + (-f(21) * den(3)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,13),T0sum(1:1,9))
  M(2) = M(2) + (-f(24) * den(9)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,26),T0sum(1:1,14))
  M(2) = M(2) + (-f(24) * den(9)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,26),T0sum(1:1,14))
  M(2) = M(2) + (-f(24) * den(9)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,23),T0sum(1:1,15))
  M(2) = M(2) + (-f(24) * den(9)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,23),T0sum(1:1,15))
  M(2) = M(2) + (-f(15) * den(9)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,7),T0sum(1:1,9))
  M(2) = M(2) + (-f(26) * den(9)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,14),T0sum(1:1,9))
  M(2) = M(2) + (-f(24) * den(10)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,27),T0sum(1:1,14))
  M(2) = M(2) + (-f(24) * den(10)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,27),T0sum(1:1,14))
  M(2) = M(2) + (-f(24) * den(10)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,24),T0sum(1:1,15))
  M(2) = M(2) + (-f(24) * den(10)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,24),T0sum(1:1,15))
  M(2) = M(2) + (-f(15) * den(10)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,8),T0sum(1:1,9))
  M(2) = M(2) + (-f(26) * den(10)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,15),T0sum(1:1,9))
  M(2) = M(2) + (-f(24) * den(11)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,28),T0sum(1:1,14))
  M(2) = M(2) + (-f(24) * den(11)) * TI2_call(0,momenta_8,masses2_1,G0tensor(:,28),T0sum(1:1,14))
  M(2) = M(2) + (-f(24) * den(11)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,25),T0sum(1:1,15))
  M(2) = M(2) + (-f(24) * den(11)) * TI2_call(0,momenta_1,masses2_1,G0tensor(:,25),T0sum(1:1,15))
  M(2) = M(2) + (-f(15) * den(11)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,9),T0sum(1:1,9))
  M(2) = M(2) + (-f(26) * den(11)) * TI2_call(0,momenta_9,masses2_1,G0tensor(:,16),T0sum(1:1,9))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_6

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G0tensorhel)
  deallocate(G2tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_6_aahhh2_hhhaa_3_/**/REALKIND
