
module ol_vamp_4_aahhh2_hhhaa_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G0tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_4(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_aahhh2_hhhaa_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_aahhh2_hhhaa_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_aahhh2_hhhaa_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_aahhh2_hhhaa_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,51) :: G0
  complex(REALKIND), dimension(4,5,4,155) :: G1
  complex(REALKIND), dimension(4,15,4,161) :: G2
  complex(REALKIND), dimension(4,35,4,72) :: G3
  complex(REALKIND), dimension(4,70,4,12) :: G4
  complex(REALKIND), pointer :: G0tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G0tensorhel(1,24,4))
    allocate(G2tensorhel(15,204,4))
    allocate(G4tensorhel(70,72,4))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G0tensor => G0tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_SS_S(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_SVV_S(G0(:,:,:,2),wf(:,-4),wf(:,-3),G0(:,:,:,3))
  call loop_SS_S(G0(:,:,:,3),wf(:,-2),G0(:,:,:,4))
  call check_last_SS_S(l_switch,G0(:,:,:,4),wf(:,0),G0tensor(:,1))
  call loop_ST_V(G0(:,:,:,3),Q(:,26),wf(:,-2),Q(:,4),G1(:,:,:,1))
  call check_last_VT_S(l_switch,G1(:,:,:,1),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,1))
  call loop_SS_S(G0(:,:,:,2),wf(:,-2),G0(:,:,:,5))
  call loop_SVV_S(G0(:,:,:,5),wf(:,-4),wf(:,-3),G0(:,:,:,6))
  call check_last_SS_S(l_switch,G0(:,:,:,6),wf(:,0),G0tensor(:,2))
  call loop_SV_T(G0(:,:,:,5),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,2))
  call loop_SV_T(G1(:,:,:,2),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,1))
  call check_last_SS_S(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,2))
  call loop_SV_V(G1(:,:,:,2),wf(:,-3),G1(:,:,:,3))
  call check_last_VT_S(l_switch,G1(:,:,:,3),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,3))
  call loop_TV_S(G0(:,:,:,5),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,4))
  call loop_TV_S(G1(:,:,:,4),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,2))
  call check_last_SS_S(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,4))
  call loop_SV_V(G1(:,:,:,4),wf(:,-3),G1(:,:,:,5))
  call check_last_VT_S(l_switch,G1(:,:,:,5),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,5))
  call loop_SV_V(G0(:,:,:,5),wf(:,-4),G0(:,:,:,7))
  call loop_VV_S(G0(:,:,:,7),wf(:,-3),G0(:,:,:,8))
  call check_last_SS_S(l_switch,G0(:,:,:,8),wf(:,0),G0tensor(:,3))
  call loop_UW_V(G0(:,:,:,7),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,6))
  call check_last_VT_S(l_switch,G1(:,:,:,6),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,6))
  call loop_UV_W(G0(:,:,:,7),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,7))
  call check_last_VT_S(l_switch,G1(:,:,:,7),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,7))
  call loop_SV_T(G0(:,:,:,5),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,8))
  call loop_SV_T(G1(:,:,:,8),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,3))
  call check_last_SS_S(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,8))
  call loop_SV_V(G1(:,:,:,8),wf(:,-4),G1(:,:,:,9))
  call check_last_VT_S(l_switch,G1(:,:,:,9),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,9))
  call loop_TV_S(G0(:,:,:,5),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,10))
  call loop_TV_S(G1(:,:,:,10),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,4))
  call check_last_SS_S(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,10))
  call loop_SV_V(G1(:,:,:,10),wf(:,-4),G1(:,:,:,11))
  call check_last_VT_S(l_switch,G1(:,:,:,11),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,11))
  call loop_SV_V(G0(:,:,:,5),wf(:,-3),G0(:,:,:,9))
  call loop_VV_S(G0(:,:,:,9),wf(:,-4),G0(:,:,:,10))
  call check_last_SS_S(l_switch,G0(:,:,:,10),wf(:,0),G0tensor(:,4))
  call loop_UW_V(G0(:,:,:,9),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,12))
  call check_last_VT_S(l_switch,G1(:,:,:,12),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,12))
  call loop_UV_W(G0(:,:,:,9),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,13))
  call check_last_VT_S(l_switch,G1(:,:,:,13),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,13))
  call loop_ST_V(G0(:,:,:,2),Q(:,2),wf(:,-2),Q(:,4),G1(:,:,:,14))
  call loop_VWW_V(G1(:,:,:,14),wf(:,-4),wf(:,-3),G1(:,:,:,15))
  call check_last_VT_S(l_switch,G1(:,:,:,15),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,14))
  call loop_VV_S(G1(:,:,:,14),wf(:,-4),G1(:,:,:,16))
  call loop_SV_T(G1(:,:,:,16),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,5))
  call check_last_SS_S(l_switch,G2(:,:,:,5),wf(:,0),G2tensor(:,15))
  call loop_TV_S(G1(:,:,:,16),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,6))
  call check_last_SS_S(l_switch,G2(:,:,:,6),wf(:,0),G2tensor(:,16))
  call loop_SV_V(G1(:,:,:,16),wf(:,-3),G1(:,:,:,17))
  call check_last_VT_S(l_switch,G1(:,:,:,17),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,17))
  call loop_UW_V(G1(:,:,:,14),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,7))
  call loop_VV_S(G2(:,:,:,7),wf(:,-3),G2(:,:,:,8))
  call check_last_SS_S(l_switch,G2(:,:,:,8),wf(:,0),G2tensor(:,18))
  call loop_UW_V(G2(:,:,:,7),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,1))
  call check_last_VT_S(l_switch,G3(:,:,:,1),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,1))
  call loop_UV_W(G1(:,:,:,14),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,9))
  call loop_VV_S(G2(:,:,:,9),wf(:,-3),G2(:,:,:,10))
  call check_last_SS_S(l_switch,G2(:,:,:,10),wf(:,0),G2tensor(:,19))
  call loop_UV_W(G2(:,:,:,9),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,2))
  call check_last_VT_S(l_switch,G3(:,:,:,2),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,2))
  call loop_VV_S(G1(:,:,:,14),wf(:,-3),G1(:,:,:,18))
  call loop_SV_T(G1(:,:,:,18),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,11))
  call check_last_SS_S(l_switch,G2(:,:,:,11),wf(:,0),G2tensor(:,20))
  call loop_TV_S(G1(:,:,:,18),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,12))
  call check_last_SS_S(l_switch,G2(:,:,:,12),wf(:,0),G2tensor(:,21))
  call loop_SV_V(G1(:,:,:,18),wf(:,-4),G1(:,:,:,19))
  call check_last_VT_S(l_switch,G1(:,:,:,19),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,22))
  call loop_UW_V(G1(:,:,:,14),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,13))
  call loop_VV_S(G2(:,:,:,13),wf(:,-4),G2(:,:,:,14))
  call check_last_SS_S(l_switch,G2(:,:,:,14),wf(:,0),G2tensor(:,23))
  call loop_UW_V(G2(:,:,:,13),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,3))
  call check_last_VT_S(l_switch,G3(:,:,:,3),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,3))
  call loop_UV_W(G1(:,:,:,14),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,15))
  call loop_VV_S(G2(:,:,:,15),wf(:,-4),G2(:,:,:,16))
  call check_last_SS_S(l_switch,G2(:,:,:,16),wf(:,0),G2tensor(:,24))
  call loop_UV_W(G2(:,:,:,15),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,4))
  call check_last_VT_S(l_switch,G3(:,:,:,4),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,4))
  call loop_SSV_V(G0(:,:,:,2),wf(:,-2),wf(:,-4),G0(:,:,:,11))
  call loop_VV_S(G0(:,:,:,11),wf(:,-3),G0(:,:,:,12))
  call check_last_SS_S(l_switch,G0(:,:,:,12),wf(:,0),G0tensor(:,5))
  call loop_UW_V(G0(:,:,:,11),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,20))
  call check_last_VT_S(l_switch,G1(:,:,:,20),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,25))
  call loop_UV_W(G0(:,:,:,11),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,21))
  call check_last_VT_S(l_switch,G1(:,:,:,21),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,26))
  call loop_SV_V(G0(:,:,:,2),wf(:,-3),G0(:,:,:,13))
  call loop_VVS_S(G0(:,:,:,13),wf(:,-4),wf(:,-2),G0(:,:,:,14))
  call check_last_SS_S(l_switch,G0(:,:,:,14),wf(:,0),G0tensor(:,6))
  call loop_VV_S(G0(:,:,:,13),wf(:,-4),G0(:,:,:,15))
  call loop_SS_S(G0(:,:,:,15),wf(:,-2),G0(:,:,:,16))
  call check_last_SS_S(l_switch,G0(:,:,:,16),wf(:,0),G0tensor(:,7))
  call loop_ST_V(G0(:,:,:,15),Q(:,26),wf(:,-2),Q(:,4),G1(:,:,:,22))
  call check_last_VT_S(l_switch,G1(:,:,:,22),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,27))
  call loop_UW_V(G0(:,:,:,13),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,23))
  call loop_VT_S(G1(:,:,:,23),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,17))
  call check_last_SS_S(l_switch,G2(:,:,:,17),wf(:,0),G2tensor(:,28))
  call loop_VS_V(G1(:,:,:,23),wf(:,-2),G1(:,:,:,24))
  call check_last_VT_S(l_switch,G1(:,:,:,24),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,29))
  call loop_UV_W(G0(:,:,:,13),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,25))
  call loop_VT_S(G1(:,:,:,25),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,18))
  call check_last_SS_S(l_switch,G2(:,:,:,18),wf(:,0),G2tensor(:,30))
  call loop_VS_V(G1(:,:,:,25),wf(:,-2),G1(:,:,:,26))
  call check_last_VT_S(l_switch,G1(:,:,:,26),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,31))
  call loop_VT_S(G0(:,:,:,13),Q(:,10),wf(:,-2),Q(:,4),G1(:,:,:,27))
  call loop_SV_T(G1(:,:,:,27),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,19))
  call check_last_SS_S(l_switch,G2(:,:,:,19),wf(:,0),G2tensor(:,32))
  call loop_TV_S(G1(:,:,:,27),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,20))
  call check_last_SS_S(l_switch,G2(:,:,:,20),wf(:,0),G2tensor(:,33))
  call loop_SV_V(G1(:,:,:,27),wf(:,-4),G1(:,:,:,28))
  call check_last_VT_S(l_switch,G1(:,:,:,28),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,34))
  call loop_VS_V(G0(:,:,:,13),wf(:,-2),G0(:,:,:,17))
  call loop_VV_S(G0(:,:,:,17),wf(:,-4),G0(:,:,:,18))
  call check_last_SS_S(l_switch,G0(:,:,:,18),wf(:,0),G0tensor(:,8))
  call loop_UW_V(G0(:,:,:,17),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,29))
  call check_last_VT_S(l_switch,G1(:,:,:,29),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,35))
  call loop_UV_W(G0(:,:,:,17),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,30))
  call check_last_VT_S(l_switch,G1(:,:,:,30),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,36))
  call loop_SV_T(G0(:,:,:,2),Q(:,2),wf(:,-3),Q(:,8),G1(:,:,:,31))
  call loop_SSV_V(G1(:,:,:,31),wf(:,-2),wf(:,-4),G1(:,:,:,32))
  call check_last_VT_S(l_switch,G1(:,:,:,32),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,37))
  call loop_SV_T(G1(:,:,:,31),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,21))
  call loop_SS_S(G2(:,:,:,21),wf(:,-2),G2(:,:,:,22))
  call check_last_SS_S(l_switch,G2(:,:,:,22),wf(:,0),G2tensor(:,38))
  call loop_ST_V(G2(:,:,:,21),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,5))
  call check_last_VT_S(l_switch,G3(:,:,:,5),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,5))
  call loop_SV_V(G1(:,:,:,31),wf(:,-4),G1(:,:,:,33))
  call loop_VT_S(G1(:,:,:,33),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,23))
  call check_last_SS_S(l_switch,G2(:,:,:,23),wf(:,0),G2tensor(:,39))
  call loop_VS_V(G1(:,:,:,33),wf(:,-2),G1(:,:,:,34))
  call check_last_VT_S(l_switch,G1(:,:,:,34),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,40))
  call loop_SS_S(G1(:,:,:,31),wf(:,-2),G1(:,:,:,35))
  call loop_SV_T(G1(:,:,:,35),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,24))
  call check_last_SS_S(l_switch,G2(:,:,:,24),wf(:,0),G2tensor(:,41))
  call loop_SV_V(G1(:,:,:,35),wf(:,-4),G1(:,:,:,36))
  call check_last_VT_S(l_switch,G1(:,:,:,36),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,42))
  call loop_ST_V(G1(:,:,:,31),Q(:,10),wf(:,-2),Q(:,4),G2(:,:,:,25))
  call loop_VV_S(G2(:,:,:,25),wf(:,-4),G2(:,:,:,26))
  call check_last_SS_S(l_switch,G2(:,:,:,26),wf(:,0),G2tensor(:,43))
  call loop_UW_V(G2(:,:,:,25),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,6))
  call check_last_VT_S(l_switch,G3(:,:,:,6),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,6))
  call loop_TV_S(G0(:,:,:,2),Q(:,2),wf(:,-3),Q(:,8),G1(:,:,:,37))
  call loop_SSV_V(G1(:,:,:,37),wf(:,-2),wf(:,-4),G1(:,:,:,38))
  call check_last_VT_S(l_switch,G1(:,:,:,38),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,44))
  call loop_TV_S(G1(:,:,:,37),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,27))
  call loop_SS_S(G2(:,:,:,27),wf(:,-2),G2(:,:,:,28))
  call check_last_SS_S(l_switch,G2(:,:,:,28),wf(:,0),G2tensor(:,45))
  call loop_ST_V(G2(:,:,:,27),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,7))
  call check_last_VT_S(l_switch,G3(:,:,:,7),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,7))
  call loop_SV_V(G1(:,:,:,37),wf(:,-4),G1(:,:,:,39))
  call loop_VT_S(G1(:,:,:,39),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,29))
  call check_last_SS_S(l_switch,G2(:,:,:,29),wf(:,0),G2tensor(:,46))
  call loop_VS_V(G1(:,:,:,39),wf(:,-2),G1(:,:,:,40))
  call check_last_VT_S(l_switch,G1(:,:,:,40),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,47))
  call loop_SS_S(G1(:,:,:,37),wf(:,-2),G1(:,:,:,41))
  call loop_TV_S(G1(:,:,:,41),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,30))
  call check_last_SS_S(l_switch,G2(:,:,:,30),wf(:,0),G2tensor(:,48))
  call loop_SV_V(G1(:,:,:,41),wf(:,-4),G1(:,:,:,42))
  call check_last_VT_S(l_switch,G1(:,:,:,42),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,49))
  call loop_ST_V(G1(:,:,:,37),Q(:,10),wf(:,-2),Q(:,4),G2(:,:,:,31))
  call loop_VV_S(G2(:,:,:,31),wf(:,-4),G2(:,:,:,32))
  call check_last_SS_S(l_switch,G2(:,:,:,32),wf(:,0),G2tensor(:,50))
  call loop_UV_W(G2(:,:,:,31),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,8))
  call check_last_VT_S(l_switch,G3(:,:,:,8),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,8))
  call loop_SSV_V(G0(:,:,:,2),wf(:,-2),wf(:,-3),G0(:,:,:,19))
  call loop_VV_S(G0(:,:,:,19),wf(:,-4),G0(:,:,:,20))
  call check_last_SS_S(l_switch,G0(:,:,:,20),wf(:,0),G0tensor(:,9))
  call loop_UW_V(G0(:,:,:,19),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,43))
  call check_last_VT_S(l_switch,G1(:,:,:,43),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,51))
  call loop_UV_W(G0(:,:,:,19),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,44))
  call check_last_VT_S(l_switch,G1(:,:,:,44),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,52))
  call loop_SV_V(G0(:,:,:,2),wf(:,-4),G0(:,:,:,21))
  call loop_VVS_S(G0(:,:,:,21),wf(:,-3),wf(:,-2),G0(:,:,:,22))
  call check_last_SS_S(l_switch,G0(:,:,:,22),wf(:,0),G0tensor(:,10))
  call loop_VV_S(G0(:,:,:,21),wf(:,-3),G0(:,:,:,23))
  call loop_SS_S(G0(:,:,:,23),wf(:,-2),G0(:,:,:,24))
  call check_last_SS_S(l_switch,G0(:,:,:,24),wf(:,0),G0tensor(:,11))
  call loop_ST_V(G0(:,:,:,23),Q(:,26),wf(:,-2),Q(:,4),G1(:,:,:,45))
  call check_last_VT_S(l_switch,G1(:,:,:,45),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,53))
  call loop_UW_V(G0(:,:,:,21),Q(:,18),wf(:,-3),Q(:,8),G1(:,:,:,46))
  call loop_VT_S(G1(:,:,:,46),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,33))
  call check_last_SS_S(l_switch,G2(:,:,:,33),wf(:,0),G2tensor(:,54))
  call loop_VS_V(G1(:,:,:,46),wf(:,-2),G1(:,:,:,47))
  call check_last_VT_S(l_switch,G1(:,:,:,47),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,55))
  call loop_UV_W(G0(:,:,:,21),Q(:,18),wf(:,-3),Q(:,8),G1(:,:,:,48))
  call loop_VT_S(G1(:,:,:,48),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,34))
  call check_last_SS_S(l_switch,G2(:,:,:,34),wf(:,0),G2tensor(:,56))
  call loop_VS_V(G1(:,:,:,48),wf(:,-2),G1(:,:,:,49))
  call check_last_VT_S(l_switch,G1(:,:,:,49),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,57))
  call loop_VT_S(G0(:,:,:,21),Q(:,18),wf(:,-2),Q(:,4),G1(:,:,:,50))
  call loop_SV_T(G1(:,:,:,50),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,35))
  call check_last_SS_S(l_switch,G2(:,:,:,35),wf(:,0),G2tensor(:,58))
  call loop_TV_S(G1(:,:,:,50),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,36))
  call check_last_SS_S(l_switch,G2(:,:,:,36),wf(:,0),G2tensor(:,59))
  call loop_SV_V(G1(:,:,:,50),wf(:,-3),G1(:,:,:,51))
  call check_last_VT_S(l_switch,G1(:,:,:,51),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,60))
  call loop_VS_V(G0(:,:,:,21),wf(:,-2),G0(:,:,:,25))
  call loop_VV_S(G0(:,:,:,25),wf(:,-3),G0(:,:,:,26))
  call check_last_SS_S(l_switch,G0(:,:,:,26),wf(:,0),G0tensor(:,12))
  call loop_UW_V(G0(:,:,:,25),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,52))
  call check_last_VT_S(l_switch,G1(:,:,:,52),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,61))
  call loop_UV_W(G0(:,:,:,25),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,53))
  call check_last_VT_S(l_switch,G1(:,:,:,53),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,62))
  call loop_SV_T(G0(:,:,:,2),Q(:,2),wf(:,-4),Q(:,16),G1(:,:,:,54))
  call loop_SSV_V(G1(:,:,:,54),wf(:,-2),wf(:,-3),G1(:,:,:,55))
  call check_last_VT_S(l_switch,G1(:,:,:,55),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,63))
  call loop_SV_T(G1(:,:,:,54),Q(:,18),wf(:,-3),Q(:,8),G2(:,:,:,37))
  call loop_SS_S(G2(:,:,:,37),wf(:,-2),G2(:,:,:,38))
  call check_last_SS_S(l_switch,G2(:,:,:,38),wf(:,0),G2tensor(:,64))
  call loop_ST_V(G2(:,:,:,37),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,9))
  call check_last_VT_S(l_switch,G3(:,:,:,9),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,9))
  call loop_SV_V(G1(:,:,:,54),wf(:,-3),G1(:,:,:,56))
  call loop_VT_S(G1(:,:,:,56),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,39))
  call check_last_SS_S(l_switch,G2(:,:,:,39),wf(:,0),G2tensor(:,65))
  call loop_VS_V(G1(:,:,:,56),wf(:,-2),G1(:,:,:,57))
  call check_last_VT_S(l_switch,G1(:,:,:,57),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,66))
  call loop_SS_S(G1(:,:,:,54),wf(:,-2),G1(:,:,:,58))
  call loop_SV_T(G1(:,:,:,58),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,40))
  call check_last_SS_S(l_switch,G2(:,:,:,40),wf(:,0),G2tensor(:,67))
  call loop_SV_V(G1(:,:,:,58),wf(:,-3),G1(:,:,:,59))
  call check_last_VT_S(l_switch,G1(:,:,:,59),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,68))
  call loop_ST_V(G1(:,:,:,54),Q(:,18),wf(:,-2),Q(:,4),G2(:,:,:,41))
  call loop_VV_S(G2(:,:,:,41),wf(:,-3),G2(:,:,:,42))
  call check_last_SS_S(l_switch,G2(:,:,:,42),wf(:,0),G2tensor(:,69))
  call loop_UW_V(G2(:,:,:,41),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,10))
  call check_last_VT_S(l_switch,G3(:,:,:,10),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,10))
  call loop_TV_S(G0(:,:,:,2),Q(:,2),wf(:,-4),Q(:,16),G1(:,:,:,60))
  call loop_SSV_V(G1(:,:,:,60),wf(:,-2),wf(:,-3),G1(:,:,:,61))
  call check_last_VT_S(l_switch,G1(:,:,:,61),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,70))
  call loop_TV_S(G1(:,:,:,60),Q(:,18),wf(:,-3),Q(:,8),G2(:,:,:,43))
  call loop_SS_S(G2(:,:,:,43),wf(:,-2),G2(:,:,:,44))
  call check_last_SS_S(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,71))
  call loop_ST_V(G2(:,:,:,43),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,11))
  call check_last_VT_S(l_switch,G3(:,:,:,11),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,11))
  call loop_SV_V(G1(:,:,:,60),wf(:,-3),G1(:,:,:,62))
  call loop_VT_S(G1(:,:,:,62),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,45))
  call check_last_SS_S(l_switch,G2(:,:,:,45),wf(:,0),G2tensor(:,72))
  call loop_VS_V(G1(:,:,:,62),wf(:,-2),G1(:,:,:,63))
  call check_last_VT_S(l_switch,G1(:,:,:,63),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,73))
  call loop_SS_S(G1(:,:,:,60),wf(:,-2),G1(:,:,:,64))
  call loop_TV_S(G1(:,:,:,64),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,46))
  call check_last_SS_S(l_switch,G2(:,:,:,46),wf(:,0),G2tensor(:,74))
  call loop_SV_V(G1(:,:,:,64),wf(:,-3),G1(:,:,:,65))
  call check_last_VT_S(l_switch,G1(:,:,:,65),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,75))
  call loop_ST_V(G1(:,:,:,60),Q(:,18),wf(:,-2),Q(:,4),G2(:,:,:,47))
  call loop_VV_S(G2(:,:,:,47),wf(:,-3),G2(:,:,:,48))
  call check_last_SS_S(l_switch,G2(:,:,:,48),wf(:,0),G2tensor(:,76))
  call loop_UV_W(G2(:,:,:,47),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,12))
  call check_last_VT_S(l_switch,G3(:,:,:,12),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,12))
  call loop_VS_V(G0(:,:,:,1),wf(:,-1),G0(:,:,:,27))
  call loop_VWW_V(G0(:,:,:,27),wf(:,-4),wf(:,-3),G0(:,:,:,28))
  call loop_VS_V(G0(:,:,:,28),wf(:,-2),G0(:,:,:,29))
  call check_last_VS_V(l_switch,G0(:,:,:,29),wf(:,0),G0tensor(:,13))
  call loop_VT_S(G0(:,:,:,28),Q(:,26),wf(:,-2),Q(:,4),G1(:,:,:,66))
  call check_last_ST_V(l_switch,G1(:,:,:,66),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,77))
  call loop_VS_V(G0(:,:,:,27),wf(:,-2),G0(:,:,:,30))
  call loop_VWW_V(G0(:,:,:,30),wf(:,-4),wf(:,-3),G0(:,:,:,31))
  call check_last_VS_V(l_switch,G0(:,:,:,31),wf(:,0),G0tensor(:,14))
  call loop_UW_V(G0(:,:,:,30),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,67))
  call loop_UW_V(G1(:,:,:,67),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,49))
  call check_last_VS_V(l_switch,G2(:,:,:,49),wf(:,0),G2tensor(:,78))
  call loop_VV_S(G1(:,:,:,67),wf(:,-3),G1(:,:,:,68))
  call check_last_ST_V(l_switch,G1(:,:,:,68),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,79))
  call loop_UV_W(G0(:,:,:,30),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,69))
  call loop_UV_W(G1(:,:,:,69),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,50))
  call check_last_VS_V(l_switch,G2(:,:,:,50),wf(:,0),G2tensor(:,80))
  call loop_VV_S(G1(:,:,:,69),wf(:,-3),G1(:,:,:,70))
  call check_last_ST_V(l_switch,G1(:,:,:,70),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,81))
  call loop_VV_S(G0(:,:,:,30),wf(:,-4),G0(:,:,:,32))
  call loop_SV_T(G0(:,:,:,32),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,71))
  call check_last_ST_V(l_switch,G1(:,:,:,71),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,82))
  call loop_TV_S(G0(:,:,:,32),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,72))
  call check_last_ST_V(l_switch,G1(:,:,:,72),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,83))
  call loop_SV_V(G0(:,:,:,32),wf(:,-3),G0(:,:,:,33))
  call check_last_VS_V(l_switch,G0(:,:,:,33),wf(:,0),G0tensor(:,15))
  call loop_UW_V(G0(:,:,:,30),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,73))
  call loop_UW_V(G1(:,:,:,73),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,51))
  call check_last_VS_V(l_switch,G2(:,:,:,51),wf(:,0),G2tensor(:,84))
  call loop_VV_S(G1(:,:,:,73),wf(:,-4),G1(:,:,:,74))
  call check_last_ST_V(l_switch,G1(:,:,:,74),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,85))
  call loop_UV_W(G0(:,:,:,30),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,75))
  call loop_UV_W(G1(:,:,:,75),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,52))
  call check_last_VS_V(l_switch,G2(:,:,:,52),wf(:,0),G2tensor(:,86))
  call loop_VV_S(G1(:,:,:,75),wf(:,-4),G1(:,:,:,76))
  call check_last_ST_V(l_switch,G1(:,:,:,76),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,87))
  call loop_VV_S(G0(:,:,:,30),wf(:,-3),G0(:,:,:,34))
  call loop_SV_T(G0(:,:,:,34),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,77))
  call check_last_ST_V(l_switch,G1(:,:,:,77),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,88))
  call loop_TV_S(G0(:,:,:,34),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,78))
  call check_last_ST_V(l_switch,G1(:,:,:,78),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,89))
  call loop_SV_V(G0(:,:,:,34),wf(:,-4),G0(:,:,:,35))
  call check_last_VS_V(l_switch,G0(:,:,:,35),wf(:,0),G0tensor(:,16))
  call loop_VT_S(G0(:,:,:,27),Q(:,2),wf(:,-2),Q(:,4),G1(:,:,:,79))
  call loop_SVV_S(G1(:,:,:,79),wf(:,-4),wf(:,-3),G1(:,:,:,80))
  call check_last_ST_V(l_switch,G1(:,:,:,80),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,90))
  call loop_SV_T(G1(:,:,:,79),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,53))
  call loop_SV_T(G2(:,:,:,53),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,13))
  call check_last_ST_V(l_switch,G3(:,:,:,13),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,13))
  call loop_SV_V(G2(:,:,:,53),wf(:,-3),G2(:,:,:,54))
  call check_last_VS_V(l_switch,G2(:,:,:,54),wf(:,0),G2tensor(:,91))
  call loop_TV_S(G1(:,:,:,79),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,55))
  call loop_TV_S(G2(:,:,:,55),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,14))
  call check_last_ST_V(l_switch,G3(:,:,:,14),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,14))
  call loop_SV_V(G2(:,:,:,55),wf(:,-3),G2(:,:,:,56))
  call check_last_VS_V(l_switch,G2(:,:,:,56),wf(:,0),G2tensor(:,92))
  call loop_SV_V(G1(:,:,:,79),wf(:,-4),G1(:,:,:,81))
  call loop_VV_S(G1(:,:,:,81),wf(:,-3),G1(:,:,:,82))
  call check_last_ST_V(l_switch,G1(:,:,:,82),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,93))
  call loop_UW_V(G1(:,:,:,81),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,57))
  call check_last_VS_V(l_switch,G2(:,:,:,57),wf(:,0),G2tensor(:,94))
  call loop_UV_W(G1(:,:,:,81),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,58))
  call check_last_VS_V(l_switch,G2(:,:,:,58),wf(:,0),G2tensor(:,95))
  call loop_SV_T(G1(:,:,:,79),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,59))
  call loop_SV_T(G2(:,:,:,59),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,15))
  call check_last_ST_V(l_switch,G3(:,:,:,15),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,15))
  call loop_SV_V(G2(:,:,:,59),wf(:,-4),G2(:,:,:,60))
  call check_last_VS_V(l_switch,G2(:,:,:,60),wf(:,0),G2tensor(:,96))
  call loop_TV_S(G1(:,:,:,79),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,61))
  call loop_TV_S(G2(:,:,:,61),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,16))
  call check_last_ST_V(l_switch,G3(:,:,:,16),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,16))
  call loop_SV_V(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call check_last_VS_V(l_switch,G2(:,:,:,62),wf(:,0),G2tensor(:,97))
  call loop_SV_V(G1(:,:,:,79),wf(:,-3),G1(:,:,:,83))
  call loop_VV_S(G1(:,:,:,83),wf(:,-4),G1(:,:,:,84))
  call check_last_ST_V(l_switch,G1(:,:,:,84),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,98))
  call loop_UW_V(G1(:,:,:,83),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,63))
  call check_last_VS_V(l_switch,G2(:,:,:,63),wf(:,0),G2tensor(:,99))
  call loop_UV_W(G1(:,:,:,83),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,64))
  call check_last_VS_V(l_switch,G2(:,:,:,64),wf(:,0),G2tensor(:,100))
  call loop_VVS_S(G0(:,:,:,27),wf(:,-4),wf(:,-2),G0(:,:,:,36))
  call loop_SV_T(G0(:,:,:,36),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,85))
  call check_last_ST_V(l_switch,G1(:,:,:,85),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,101))
  call loop_TV_S(G0(:,:,:,36),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,86))
  call check_last_ST_V(l_switch,G1(:,:,:,86),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,102))
  call loop_SV_V(G0(:,:,:,36),wf(:,-3),G0(:,:,:,37))
  call check_last_VS_V(l_switch,G0(:,:,:,37),wf(:,0),G0tensor(:,17))
  call loop_UW_V(G0(:,:,:,27),Q(:,2),wf(:,-3),Q(:,8),G1(:,:,:,87))
  call loop_VVS_S(G1(:,:,:,87),wf(:,-4),wf(:,-2),G1(:,:,:,88))
  call check_last_ST_V(l_switch,G1(:,:,:,88),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,103))
  call loop_UW_V(G1(:,:,:,87),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,65))
  call loop_VS_V(G2(:,:,:,65),wf(:,-2),G2(:,:,:,66))
  call check_last_VS_V(l_switch,G2(:,:,:,66),wf(:,0),G2tensor(:,104))
  call loop_VT_S(G2(:,:,:,65),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,17))
  call check_last_ST_V(l_switch,G3(:,:,:,17),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,17))
  call loop_VV_S(G1(:,:,:,87),wf(:,-4),G1(:,:,:,89))
  call loop_SS_S(G1(:,:,:,89),wf(:,-2),G1(:,:,:,90))
  call check_last_ST_V(l_switch,G1(:,:,:,90),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,105))
  call loop_ST_V(G1(:,:,:,89),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,67))
  call check_last_VS_V(l_switch,G2(:,:,:,67),wf(:,0),G2tensor(:,106))
  call loop_VS_V(G1(:,:,:,87),wf(:,-2),G1(:,:,:,91))
  call loop_UW_V(G1(:,:,:,91),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,68))
  call check_last_VS_V(l_switch,G2(:,:,:,68),wf(:,0),G2tensor(:,107))
  call loop_VV_S(G1(:,:,:,91),wf(:,-4),G1(:,:,:,92))
  call check_last_ST_V(l_switch,G1(:,:,:,92),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,108))
  call loop_VT_S(G1(:,:,:,87),Q(:,10),wf(:,-2),Q(:,4),G2(:,:,:,69))
  call loop_SV_T(G2(:,:,:,69),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,18))
  call check_last_ST_V(l_switch,G3(:,:,:,18),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,18))
  call loop_SV_V(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call check_last_VS_V(l_switch,G2(:,:,:,70),wf(:,0),G2tensor(:,109))
  call loop_UV_W(G0(:,:,:,27),Q(:,2),wf(:,-3),Q(:,8),G1(:,:,:,93))
  call loop_VVS_S(G1(:,:,:,93),wf(:,-4),wf(:,-2),G1(:,:,:,94))
  call check_last_ST_V(l_switch,G1(:,:,:,94),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,110))
  call loop_UV_W(G1(:,:,:,93),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,71))
  call loop_VS_V(G2(:,:,:,71),wf(:,-2),G2(:,:,:,72))
  call check_last_VS_V(l_switch,G2(:,:,:,72),wf(:,0),G2tensor(:,111))
  call loop_VT_S(G2(:,:,:,71),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,19))
  call check_last_ST_V(l_switch,G3(:,:,:,19),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,19))
  call loop_VV_S(G1(:,:,:,93),wf(:,-4),G1(:,:,:,95))
  call loop_SS_S(G1(:,:,:,95),wf(:,-2),G1(:,:,:,96))
  call check_last_ST_V(l_switch,G1(:,:,:,96),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,112))
  call loop_ST_V(G1(:,:,:,95),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,73))
  call check_last_VS_V(l_switch,G2(:,:,:,73),wf(:,0),G2tensor(:,113))
  call loop_VS_V(G1(:,:,:,93),wf(:,-2),G1(:,:,:,97))
  call loop_UV_W(G1(:,:,:,97),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,74))
  call check_last_VS_V(l_switch,G2(:,:,:,74),wf(:,0),G2tensor(:,114))
  call loop_VV_S(G1(:,:,:,97),wf(:,-4),G1(:,:,:,98))
  call check_last_ST_V(l_switch,G1(:,:,:,98),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,115))
  call loop_VT_S(G1(:,:,:,93),Q(:,10),wf(:,-2),Q(:,4),G2(:,:,:,75))
  call loop_TV_S(G2(:,:,:,75),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,20))
  call check_last_ST_V(l_switch,G3(:,:,:,20),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,20))
  call loop_SV_V(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76))
  call check_last_VS_V(l_switch,G2(:,:,:,76),wf(:,0),G2tensor(:,116))
  call loop_VV_S(G0(:,:,:,27),wf(:,-3),G0(:,:,:,38))
  call loop_SSV_V(G0(:,:,:,38),wf(:,-2),wf(:,-4),G0(:,:,:,39))
  call check_last_VS_V(l_switch,G0(:,:,:,39),wf(:,0),G0tensor(:,18))
  call loop_SV_T(G0(:,:,:,38),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,99))
  call loop_SS_S(G1(:,:,:,99),wf(:,-2),G1(:,:,:,100))
  call check_last_ST_V(l_switch,G1(:,:,:,100),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,117))
  call loop_ST_V(G1(:,:,:,99),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,77))
  call check_last_VS_V(l_switch,G2(:,:,:,77),wf(:,0),G2tensor(:,118))
  call loop_TV_S(G0(:,:,:,38),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,101))
  call loop_SS_S(G1(:,:,:,101),wf(:,-2),G1(:,:,:,102))
  call check_last_ST_V(l_switch,G1(:,:,:,102),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,119))
  call loop_ST_V(G1(:,:,:,101),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,78))
  call check_last_VS_V(l_switch,G2(:,:,:,78),wf(:,0),G2tensor(:,120))
  call loop_SV_V(G0(:,:,:,38),wf(:,-4),G0(:,:,:,40))
  call loop_VT_S(G0(:,:,:,40),Q(:,26),wf(:,-2),Q(:,4),G1(:,:,:,103))
  call check_last_ST_V(l_switch,G1(:,:,:,103),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,121))
  call loop_VS_V(G0(:,:,:,40),wf(:,-2),G0(:,:,:,41))
  call check_last_VS_V(l_switch,G0(:,:,:,41),wf(:,0),G0tensor(:,19))
  call loop_SS_S(G0(:,:,:,38),wf(:,-2),G0(:,:,:,42))
  call loop_SV_T(G0(:,:,:,42),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,104))
  call check_last_ST_V(l_switch,G1(:,:,:,104),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,122))
  call loop_TV_S(G0(:,:,:,42),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,105))
  call check_last_ST_V(l_switch,G1(:,:,:,105),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,123))
  call loop_SV_V(G0(:,:,:,42),wf(:,-4),G0(:,:,:,43))
  call check_last_VS_V(l_switch,G0(:,:,:,43),wf(:,0),G0tensor(:,20))
  call loop_ST_V(G0(:,:,:,38),Q(:,10),wf(:,-2),Q(:,4),G1(:,:,:,106))
  call loop_VV_S(G1(:,:,:,106),wf(:,-4),G1(:,:,:,107))
  call check_last_ST_V(l_switch,G1(:,:,:,107),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,124))
  call loop_UW_V(G1(:,:,:,106),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,79))
  call check_last_VS_V(l_switch,G2(:,:,:,79),wf(:,0),G2tensor(:,125))
  call loop_UV_W(G1(:,:,:,106),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,80))
  call check_last_VS_V(l_switch,G2(:,:,:,80),wf(:,0),G2tensor(:,126))
  call loop_VVS_S(G0(:,:,:,27),wf(:,-3),wf(:,-2),G0(:,:,:,44))
  call loop_SV_T(G0(:,:,:,44),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,108))
  call check_last_ST_V(l_switch,G1(:,:,:,108),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,127))
  call loop_TV_S(G0(:,:,:,44),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,109))
  call check_last_ST_V(l_switch,G1(:,:,:,109),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,128))
  call loop_SV_V(G0(:,:,:,44),wf(:,-4),G0(:,:,:,45))
  call check_last_VS_V(l_switch,G0(:,:,:,45),wf(:,0),G0tensor(:,21))
  call loop_UW_V(G0(:,:,:,27),Q(:,2),wf(:,-4),Q(:,16),G1(:,:,:,110))
  call loop_VVS_S(G1(:,:,:,110),wf(:,-3),wf(:,-2),G1(:,:,:,111))
  call check_last_ST_V(l_switch,G1(:,:,:,111),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,129))
  call loop_UW_V(G1(:,:,:,110),Q(:,18),wf(:,-3),Q(:,8),G2(:,:,:,81))
  call loop_VS_V(G2(:,:,:,81),wf(:,-2),G2(:,:,:,82))
  call check_last_VS_V(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,130))
  call loop_VT_S(G2(:,:,:,81),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,21))
  call check_last_ST_V(l_switch,G3(:,:,:,21),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,21))
  call loop_VV_S(G1(:,:,:,110),wf(:,-3),G1(:,:,:,112))
  call loop_SS_S(G1(:,:,:,112),wf(:,-2),G1(:,:,:,113))
  call check_last_ST_V(l_switch,G1(:,:,:,113),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,131))
  call loop_ST_V(G1(:,:,:,112),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,83))
  call check_last_VS_V(l_switch,G2(:,:,:,83),wf(:,0),G2tensor(:,132))
  call loop_VS_V(G1(:,:,:,110),wf(:,-2),G1(:,:,:,114))
  call loop_UW_V(G1(:,:,:,114),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,84))
  call check_last_VS_V(l_switch,G2(:,:,:,84),wf(:,0),G2tensor(:,133))
  call loop_VV_S(G1(:,:,:,114),wf(:,-3),G1(:,:,:,115))
  call check_last_ST_V(l_switch,G1(:,:,:,115),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,134))
  call loop_VT_S(G1(:,:,:,110),Q(:,18),wf(:,-2),Q(:,4),G2(:,:,:,85))
  call loop_SV_T(G2(:,:,:,85),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,22))
  call check_last_ST_V(l_switch,G3(:,:,:,22),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,22))
  call loop_SV_V(G2(:,:,:,85),wf(:,-3),G2(:,:,:,86))
  call check_last_VS_V(l_switch,G2(:,:,:,86),wf(:,0),G2tensor(:,135))
  call loop_UV_W(G0(:,:,:,27),Q(:,2),wf(:,-4),Q(:,16),G1(:,:,:,116))
  call loop_VVS_S(G1(:,:,:,116),wf(:,-3),wf(:,-2),G1(:,:,:,117))
  call check_last_ST_V(l_switch,G1(:,:,:,117),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,136))
  call loop_UV_W(G1(:,:,:,116),Q(:,18),wf(:,-3),Q(:,8),G2(:,:,:,87))
  call loop_VS_V(G2(:,:,:,87),wf(:,-2),G2(:,:,:,88))
  call check_last_VS_V(l_switch,G2(:,:,:,88),wf(:,0),G2tensor(:,137))
  call loop_VT_S(G2(:,:,:,87),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,23))
  call check_last_ST_V(l_switch,G3(:,:,:,23),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,23))
  call loop_VV_S(G1(:,:,:,116),wf(:,-3),G1(:,:,:,118))
  call loop_SS_S(G1(:,:,:,118),wf(:,-2),G1(:,:,:,119))
  call check_last_ST_V(l_switch,G1(:,:,:,119),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,138))
  call loop_ST_V(G1(:,:,:,118),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,89))
  call check_last_VS_V(l_switch,G2(:,:,:,89),wf(:,0),G2tensor(:,139))
  call loop_VS_V(G1(:,:,:,116),wf(:,-2),G1(:,:,:,120))
  call loop_UV_W(G1(:,:,:,120),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,90))
  call check_last_VS_V(l_switch,G2(:,:,:,90),wf(:,0),G2tensor(:,140))
  call loop_VV_S(G1(:,:,:,120),wf(:,-3),G1(:,:,:,121))
  call check_last_ST_V(l_switch,G1(:,:,:,121),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,141))
  call loop_VT_S(G1(:,:,:,116),Q(:,18),wf(:,-2),Q(:,4),G2(:,:,:,91))
  call loop_TV_S(G2(:,:,:,91),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,24))
  call check_last_ST_V(l_switch,G3(:,:,:,24),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,24))
  call loop_SV_V(G2(:,:,:,91),wf(:,-3),G2(:,:,:,92))
  call check_last_VS_V(l_switch,G2(:,:,:,92),wf(:,0),G2tensor(:,142))
  call loop_VV_S(G0(:,:,:,27),wf(:,-4),G0(:,:,:,46))
  call loop_SSV_V(G0(:,:,:,46),wf(:,-2),wf(:,-3),G0(:,:,:,47))
  call check_last_VS_V(l_switch,G0(:,:,:,47),wf(:,0),G0tensor(:,22))
  call loop_SV_T(G0(:,:,:,46),Q(:,18),wf(:,-3),Q(:,8),G1(:,:,:,122))
  call loop_SS_S(G1(:,:,:,122),wf(:,-2),G1(:,:,:,123))
  call check_last_ST_V(l_switch,G1(:,:,:,123),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,143))
  call loop_ST_V(G1(:,:,:,122),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,93))
  call check_last_VS_V(l_switch,G2(:,:,:,93),wf(:,0),G2tensor(:,144))
  call loop_TV_S(G0(:,:,:,46),Q(:,18),wf(:,-3),Q(:,8),G1(:,:,:,124))
  call loop_SS_S(G1(:,:,:,124),wf(:,-2),G1(:,:,:,125))
  call check_last_ST_V(l_switch,G1(:,:,:,125),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,145))
  call loop_ST_V(G1(:,:,:,124),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,94))
  call check_last_VS_V(l_switch,G2(:,:,:,94),wf(:,0),G2tensor(:,146))
  call loop_SV_V(G0(:,:,:,46),wf(:,-3),G0(:,:,:,48))
  call loop_VT_S(G0(:,:,:,48),Q(:,26),wf(:,-2),Q(:,4),G1(:,:,:,126))
  call check_last_ST_V(l_switch,G1(:,:,:,126),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,147))
  call loop_VS_V(G0(:,:,:,48),wf(:,-2),G0(:,:,:,49))
  call check_last_VS_V(l_switch,G0(:,:,:,49),wf(:,0),G0tensor(:,23))
  call loop_SS_S(G0(:,:,:,46),wf(:,-2),G0(:,:,:,50))
  call loop_SV_T(G0(:,:,:,50),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,127))
  call check_last_ST_V(l_switch,G1(:,:,:,127),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,148))
  call loop_TV_S(G0(:,:,:,50),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,128))
  call check_last_ST_V(l_switch,G1(:,:,:,128),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,149))
  call loop_SV_V(G0(:,:,:,50),wf(:,-3),G0(:,:,:,51))
  call check_last_VS_V(l_switch,G0(:,:,:,51),wf(:,0),G0tensor(:,24))
  call loop_ST_V(G0(:,:,:,46),Q(:,18),wf(:,-2),Q(:,4),G1(:,:,:,129))
  call loop_VV_S(G1(:,:,:,129),wf(:,-3),G1(:,:,:,130))
  call check_last_ST_V(l_switch,G1(:,:,:,130),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,150))
  call loop_UW_V(G1(:,:,:,129),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,95))
  call check_last_VS_V(l_switch,G2(:,:,:,95),wf(:,0),G2tensor(:,151))
  call loop_UV_W(G1(:,:,:,129),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,96))
  call check_last_VS_V(l_switch,G2(:,:,:,96),wf(:,0),G2tensor(:,152))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,-1),Q(:,2),G1(:,:,:,131))
  call loop_SVV_S(G1(:,:,:,131),wf(:,-4),wf(:,-3),G1(:,:,:,132))
  call loop_SS_S(G1(:,:,:,132),wf(:,-2),G1(:,:,:,133))
  call check_last_ST_V(l_switch,G1(:,:,:,133),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,153))
  call loop_ST_V(G1(:,:,:,132),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,97))
  call check_last_VS_V(l_switch,G2(:,:,:,97),wf(:,0),G2tensor(:,154))
  call loop_SS_S(G1(:,:,:,131),wf(:,-2),G1(:,:,:,134))
  call loop_SVV_S(G1(:,:,:,134),wf(:,-4),wf(:,-3),G1(:,:,:,135))
  call check_last_ST_V(l_switch,G1(:,:,:,135),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,155))
  call loop_SV_T(G1(:,:,:,134),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,98))
  call loop_SV_T(G2(:,:,:,98),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,25))
  call check_last_ST_V(l_switch,G3(:,:,:,25),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,25))
  call loop_SV_V(G2(:,:,:,98),wf(:,-3),G2(:,:,:,99))
  call check_last_VS_V(l_switch,G2(:,:,:,99),wf(:,0),G2tensor(:,156))
  call loop_TV_S(G1(:,:,:,134),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,100))
  call loop_TV_S(G2(:,:,:,100),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,26))
  call check_last_ST_V(l_switch,G3(:,:,:,26),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,26))
  call loop_SV_V(G2(:,:,:,100),wf(:,-3),G2(:,:,:,101))
  call check_last_VS_V(l_switch,G2(:,:,:,101),wf(:,0),G2tensor(:,157))
  call loop_SV_V(G1(:,:,:,134),wf(:,-4),G1(:,:,:,136))
  call loop_VV_S(G1(:,:,:,136),wf(:,-3),G1(:,:,:,137))
  call check_last_ST_V(l_switch,G1(:,:,:,137),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,158))
  call loop_UW_V(G1(:,:,:,136),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,102))
  call check_last_VS_V(l_switch,G2(:,:,:,102),wf(:,0),G2tensor(:,159))
  call loop_UV_W(G1(:,:,:,136),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,103))
  call check_last_VS_V(l_switch,G2(:,:,:,103),wf(:,0),G2tensor(:,160))
  call loop_SV_T(G1(:,:,:,134),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,104))
  call loop_SV_T(G2(:,:,:,104),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,27))
  call check_last_ST_V(l_switch,G3(:,:,:,27),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,27))
  call loop_SV_V(G2(:,:,:,104),wf(:,-4),G2(:,:,:,105))
  call check_last_VS_V(l_switch,G2(:,:,:,105),wf(:,0),G2tensor(:,161))
  call loop_TV_S(G1(:,:,:,134),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,106))
  call loop_TV_S(G2(:,:,:,106),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,28))
  call check_last_ST_V(l_switch,G3(:,:,:,28),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,28))
  call loop_SV_V(G2(:,:,:,106),wf(:,-4),G2(:,:,:,107))
  call check_last_VS_V(l_switch,G2(:,:,:,107),wf(:,0),G2tensor(:,162))
  call loop_SV_V(G1(:,:,:,134),wf(:,-3),G1(:,:,:,138))
  call loop_VV_S(G1(:,:,:,138),wf(:,-4),G1(:,:,:,139))
  call check_last_ST_V(l_switch,G1(:,:,:,139),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,163))
  call loop_UW_V(G1(:,:,:,138),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,108))
  call check_last_VS_V(l_switch,G2(:,:,:,108),wf(:,0),G2tensor(:,164))
  call loop_UV_W(G1(:,:,:,138),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,109))
  call check_last_VS_V(l_switch,G2(:,:,:,109),wf(:,0),G2tensor(:,165))
  call loop_ST_V(G1(:,:,:,131),Q(:,2),wf(:,-2),Q(:,4),G2(:,:,:,110))
  call loop_VWW_V(G2(:,:,:,110),wf(:,-4),wf(:,-3),G2(:,:,:,111))
  call check_last_VS_V(l_switch,G2(:,:,:,111),wf(:,0),G2tensor(:,166))
  call loop_VV_S(G2(:,:,:,110),wf(:,-4),G2(:,:,:,112))
  call loop_SV_T(G2(:,:,:,112),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,29))
  call check_last_ST_V(l_switch,G3(:,:,:,29),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,29))
  call loop_TV_S(G2(:,:,:,112),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,30))
  call check_last_ST_V(l_switch,G3(:,:,:,30),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,30))
  call loop_SV_V(G2(:,:,:,112),wf(:,-3),G2(:,:,:,113))
  call check_last_VS_V(l_switch,G2(:,:,:,113),wf(:,0),G2tensor(:,167))
  call loop_UW_V(G2(:,:,:,110),Q(:,6),wf(:,-4),Q(:,16),G3(:,:,:,31))
  call loop_VV_S(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call check_last_ST_V(l_switch,G3(:,:,:,32),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,31))
  call loop_UW_V(G3(:,:,:,31),Q(:,22),wf(:,-3),Q(:,8),G4(:,:,:,1))
  call check_last_VS_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,32))
  call loop_UV_W(G2(:,:,:,110),Q(:,6),wf(:,-4),Q(:,16),G3(:,:,:,33))
  call loop_VV_S(G3(:,:,:,33),wf(:,-3),G3(:,:,:,34))
  call check_last_ST_V(l_switch,G3(:,:,:,34),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,33))
  call loop_UV_W(G3(:,:,:,33),Q(:,22),wf(:,-3),Q(:,8),G4(:,:,:,2))
  call check_last_VS_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,34))
  call loop_VV_S(G2(:,:,:,110),wf(:,-3),G2(:,:,:,114))
  call loop_SV_T(G2(:,:,:,114),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,35))
  call check_last_ST_V(l_switch,G3(:,:,:,35),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,35))
  call loop_TV_S(G2(:,:,:,114),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,36))
  call check_last_ST_V(l_switch,G3(:,:,:,36),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,36))
  call loop_SV_V(G2(:,:,:,114),wf(:,-4),G2(:,:,:,115))
  call check_last_VS_V(l_switch,G2(:,:,:,115),wf(:,0),G2tensor(:,168))
  call loop_UW_V(G2(:,:,:,110),Q(:,6),wf(:,-3),Q(:,8),G3(:,:,:,37))
  call loop_VV_S(G3(:,:,:,37),wf(:,-4),G3(:,:,:,38))
  call check_last_ST_V(l_switch,G3(:,:,:,38),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,37))
  call loop_UW_V(G3(:,:,:,37),Q(:,14),wf(:,-4),Q(:,16),G4(:,:,:,3))
  call check_last_VS_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,38))
  call loop_UV_W(G2(:,:,:,110),Q(:,6),wf(:,-3),Q(:,8),G3(:,:,:,39))
  call loop_VV_S(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call check_last_ST_V(l_switch,G3(:,:,:,40),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,39))
  call loop_UV_W(G3(:,:,:,39),Q(:,14),wf(:,-4),Q(:,16),G4(:,:,:,4))
  call check_last_VS_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,40))
  call loop_SSV_V(G1(:,:,:,131),wf(:,-2),wf(:,-4),G1(:,:,:,140))
  call loop_VV_S(G1(:,:,:,140),wf(:,-3),G1(:,:,:,141))
  call check_last_ST_V(l_switch,G1(:,:,:,141),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,169))
  call loop_UW_V(G1(:,:,:,140),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,116))
  call check_last_VS_V(l_switch,G2(:,:,:,116),wf(:,0),G2tensor(:,170))
  call loop_UV_W(G1(:,:,:,140),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,117))
  call check_last_VS_V(l_switch,G2(:,:,:,117),wf(:,0),G2tensor(:,171))
  call loop_SV_V(G1(:,:,:,131),wf(:,-3),G1(:,:,:,142))
  call loop_VVS_S(G1(:,:,:,142),wf(:,-4),wf(:,-2),G1(:,:,:,143))
  call check_last_ST_V(l_switch,G1(:,:,:,143),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,172))
  call loop_VV_S(G1(:,:,:,142),wf(:,-4),G1(:,:,:,144))
  call loop_SS_S(G1(:,:,:,144),wf(:,-2),G1(:,:,:,145))
  call check_last_ST_V(l_switch,G1(:,:,:,145),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,173))
  call loop_ST_V(G1(:,:,:,144),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,118))
  call check_last_VS_V(l_switch,G2(:,:,:,118),wf(:,0),G2tensor(:,174))
  call loop_UW_V(G1(:,:,:,142),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,119))
  call loop_VT_S(G2(:,:,:,119),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,41))
  call check_last_ST_V(l_switch,G3(:,:,:,41),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,41))
  call loop_VS_V(G2(:,:,:,119),wf(:,-2),G2(:,:,:,120))
  call check_last_VS_V(l_switch,G2(:,:,:,120),wf(:,0),G2tensor(:,175))
  call loop_UV_W(G1(:,:,:,142),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,121))
  call loop_VT_S(G2(:,:,:,121),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,42))
  call check_last_ST_V(l_switch,G3(:,:,:,42),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,42))
  call loop_VS_V(G2(:,:,:,121),wf(:,-2),G2(:,:,:,122))
  call check_last_VS_V(l_switch,G2(:,:,:,122),wf(:,0),G2tensor(:,176))
  call loop_VT_S(G1(:,:,:,142),Q(:,10),wf(:,-2),Q(:,4),G2(:,:,:,123))
  call loop_SV_T(G2(:,:,:,123),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,43))
  call check_last_ST_V(l_switch,G3(:,:,:,43),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,43))
  call loop_TV_S(G2(:,:,:,123),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,44))
  call check_last_ST_V(l_switch,G3(:,:,:,44),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,44))
  call loop_SV_V(G2(:,:,:,123),wf(:,-4),G2(:,:,:,124))
  call check_last_VS_V(l_switch,G2(:,:,:,124),wf(:,0),G2tensor(:,177))
  call loop_VS_V(G1(:,:,:,142),wf(:,-2),G1(:,:,:,146))
  call loop_VV_S(G1(:,:,:,146),wf(:,-4),G1(:,:,:,147))
  call check_last_ST_V(l_switch,G1(:,:,:,147),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,178))
  call loop_UW_V(G1(:,:,:,146),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,125))
  call check_last_VS_V(l_switch,G2(:,:,:,125),wf(:,0),G2tensor(:,179))
  call loop_UV_W(G1(:,:,:,146),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,126))
  call check_last_VS_V(l_switch,G2(:,:,:,126),wf(:,0),G2tensor(:,180))
  call loop_SV_T(G1(:,:,:,131),Q(:,2),wf(:,-3),Q(:,8),G2(:,:,:,127))
  call loop_SSV_V(G2(:,:,:,127),wf(:,-2),wf(:,-4),G2(:,:,:,128))
  call check_last_VS_V(l_switch,G2(:,:,:,128),wf(:,0),G2tensor(:,181))
  call loop_SV_T(G2(:,:,:,127),Q(:,10),wf(:,-4),Q(:,16),G3(:,:,:,45))
  call loop_SS_S(G3(:,:,:,45),wf(:,-2),G3(:,:,:,46))
  call check_last_ST_V(l_switch,G3(:,:,:,46),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,45))
  call loop_ST_V(G3(:,:,:,45),Q(:,26),wf(:,-2),Q(:,4),G4(:,:,:,5))
  call check_last_VS_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,46))
  call loop_SV_V(G2(:,:,:,127),wf(:,-4),G2(:,:,:,129))
  call loop_VT_S(G2(:,:,:,129),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,47))
  call check_last_ST_V(l_switch,G3(:,:,:,47),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,47))
  call loop_VS_V(G2(:,:,:,129),wf(:,-2),G2(:,:,:,130))
  call check_last_VS_V(l_switch,G2(:,:,:,130),wf(:,0),G2tensor(:,182))
  call loop_SS_S(G2(:,:,:,127),wf(:,-2),G2(:,:,:,131))
  call loop_SV_T(G2(:,:,:,131),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,48))
  call check_last_ST_V(l_switch,G3(:,:,:,48),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,48))
  call loop_SV_V(G2(:,:,:,131),wf(:,-4),G2(:,:,:,132))
  call check_last_VS_V(l_switch,G2(:,:,:,132),wf(:,0),G2tensor(:,183))
  call loop_ST_V(G2(:,:,:,127),Q(:,10),wf(:,-2),Q(:,4),G3(:,:,:,49))
  call loop_VV_S(G3(:,:,:,49),wf(:,-4),G3(:,:,:,50))
  call check_last_ST_V(l_switch,G3(:,:,:,50),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,49))
  call loop_UW_V(G3(:,:,:,49),Q(:,14),wf(:,-4),Q(:,16),G4(:,:,:,6))
  call check_last_VS_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,50))
  call loop_TV_S(G1(:,:,:,131),Q(:,2),wf(:,-3),Q(:,8),G2(:,:,:,133))
  call loop_SSV_V(G2(:,:,:,133),wf(:,-2),wf(:,-4),G2(:,:,:,134))
  call check_last_VS_V(l_switch,G2(:,:,:,134),wf(:,0),G2tensor(:,184))
  call loop_TV_S(G2(:,:,:,133),Q(:,10),wf(:,-4),Q(:,16),G3(:,:,:,51))
  call loop_SS_S(G3(:,:,:,51),wf(:,-2),G3(:,:,:,52))
  call check_last_ST_V(l_switch,G3(:,:,:,52),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,51))
  call loop_ST_V(G3(:,:,:,51),Q(:,26),wf(:,-2),Q(:,4),G4(:,:,:,7))
  call check_last_VS_V(l_switch,G4(:,:,:,7),wf(:,0),G4tensor(:,52))
  call loop_SV_V(G2(:,:,:,133),wf(:,-4),G2(:,:,:,135))
  call loop_VT_S(G2(:,:,:,135),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,53))
  call check_last_ST_V(l_switch,G3(:,:,:,53),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,53))
  call loop_VS_V(G2(:,:,:,135),wf(:,-2),G2(:,:,:,136))
  call check_last_VS_V(l_switch,G2(:,:,:,136),wf(:,0),G2tensor(:,185))
  call loop_SS_S(G2(:,:,:,133),wf(:,-2),G2(:,:,:,137))
  call loop_TV_S(G2(:,:,:,137),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,54))
  call check_last_ST_V(l_switch,G3(:,:,:,54),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,54))
  call loop_SV_V(G2(:,:,:,137),wf(:,-4),G2(:,:,:,138))
  call check_last_VS_V(l_switch,G2(:,:,:,138),wf(:,0),G2tensor(:,186))
  call loop_ST_V(G2(:,:,:,133),Q(:,10),wf(:,-2),Q(:,4),G3(:,:,:,55))
  call loop_VV_S(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call check_last_ST_V(l_switch,G3(:,:,:,56),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,55))
  call loop_UV_W(G3(:,:,:,55),Q(:,14),wf(:,-4),Q(:,16),G4(:,:,:,8))
  call check_last_VS_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,56))
  call loop_SSV_V(G1(:,:,:,131),wf(:,-2),wf(:,-3),G1(:,:,:,148))
  call loop_VV_S(G1(:,:,:,148),wf(:,-4),G1(:,:,:,149))
  call check_last_ST_V(l_switch,G1(:,:,:,149),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,187))
  call loop_UW_V(G1(:,:,:,148),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,139))
  call check_last_VS_V(l_switch,G2(:,:,:,139),wf(:,0),G2tensor(:,188))
  call loop_UV_W(G1(:,:,:,148),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,140))
  call check_last_VS_V(l_switch,G2(:,:,:,140),wf(:,0),G2tensor(:,189))
  call loop_SV_V(G1(:,:,:,131),wf(:,-4),G1(:,:,:,150))
  call loop_VVS_S(G1(:,:,:,150),wf(:,-3),wf(:,-2),G1(:,:,:,151))
  call check_last_ST_V(l_switch,G1(:,:,:,151),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,190))
  call loop_VV_S(G1(:,:,:,150),wf(:,-3),G1(:,:,:,152))
  call loop_SS_S(G1(:,:,:,152),wf(:,-2),G1(:,:,:,153))
  call check_last_ST_V(l_switch,G1(:,:,:,153),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,191))
  call loop_ST_V(G1(:,:,:,152),Q(:,26),wf(:,-2),Q(:,4),G2(:,:,:,141))
  call check_last_VS_V(l_switch,G2(:,:,:,141),wf(:,0),G2tensor(:,192))
  call loop_UW_V(G1(:,:,:,150),Q(:,18),wf(:,-3),Q(:,8),G2(:,:,:,142))
  call loop_VT_S(G2(:,:,:,142),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,57))
  call check_last_ST_V(l_switch,G3(:,:,:,57),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,57))
  call loop_VS_V(G2(:,:,:,142),wf(:,-2),G2(:,:,:,143))
  call check_last_VS_V(l_switch,G2(:,:,:,143),wf(:,0),G2tensor(:,193))
  call loop_UV_W(G1(:,:,:,150),Q(:,18),wf(:,-3),Q(:,8),G2(:,:,:,144))
  call loop_VT_S(G2(:,:,:,144),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,58))
  call check_last_ST_V(l_switch,G3(:,:,:,58),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,58))
  call loop_VS_V(G2(:,:,:,144),wf(:,-2),G2(:,:,:,145))
  call check_last_VS_V(l_switch,G2(:,:,:,145),wf(:,0),G2tensor(:,194))
  call loop_VT_S(G1(:,:,:,150),Q(:,18),wf(:,-2),Q(:,4),G2(:,:,:,146))
  call loop_SV_T(G2(:,:,:,146),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,59))
  call check_last_ST_V(l_switch,G3(:,:,:,59),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,59))
  call loop_TV_S(G2(:,:,:,146),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,60))
  call check_last_ST_V(l_switch,G3(:,:,:,60),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,60))
  call loop_SV_V(G2(:,:,:,146),wf(:,-3),G2(:,:,:,147))
  call check_last_VS_V(l_switch,G2(:,:,:,147),wf(:,0),G2tensor(:,195))
  call loop_VS_V(G1(:,:,:,150),wf(:,-2),G1(:,:,:,154))
  call loop_VV_S(G1(:,:,:,154),wf(:,-3),G1(:,:,:,155))
  call check_last_ST_V(l_switch,G1(:,:,:,155),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,196))
  call loop_UW_V(G1(:,:,:,154),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,148))
  call check_last_VS_V(l_switch,G2(:,:,:,148),wf(:,0),G2tensor(:,197))
  call loop_UV_W(G1(:,:,:,154),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,149))
  call check_last_VS_V(l_switch,G2(:,:,:,149),wf(:,0),G2tensor(:,198))
  call loop_SV_T(G1(:,:,:,131),Q(:,2),wf(:,-4),Q(:,16),G2(:,:,:,150))
  call loop_SSV_V(G2(:,:,:,150),wf(:,-2),wf(:,-3),G2(:,:,:,151))
  call check_last_VS_V(l_switch,G2(:,:,:,151),wf(:,0),G2tensor(:,199))
  call loop_SV_T(G2(:,:,:,150),Q(:,18),wf(:,-3),Q(:,8),G3(:,:,:,61))
  call loop_SS_S(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62))
  call check_last_ST_V(l_switch,G3(:,:,:,62),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,61))
  call loop_ST_V(G3(:,:,:,61),Q(:,26),wf(:,-2),Q(:,4),G4(:,:,:,9))
  call check_last_VS_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,62))
  call loop_SV_V(G2(:,:,:,150),wf(:,-3),G2(:,:,:,152))
  call loop_VT_S(G2(:,:,:,152),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,63))
  call check_last_ST_V(l_switch,G3(:,:,:,63),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,63))
  call loop_VS_V(G2(:,:,:,152),wf(:,-2),G2(:,:,:,153))
  call check_last_VS_V(l_switch,G2(:,:,:,153),wf(:,0),G2tensor(:,200))
  call loop_SS_S(G2(:,:,:,150),wf(:,-2),G2(:,:,:,154))
  call loop_SV_T(G2(:,:,:,154),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,64))
  call check_last_ST_V(l_switch,G3(:,:,:,64),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,64))
  call loop_SV_V(G2(:,:,:,154),wf(:,-3),G2(:,:,:,155))
  call check_last_VS_V(l_switch,G2(:,:,:,155),wf(:,0),G2tensor(:,201))
  call loop_ST_V(G2(:,:,:,150),Q(:,18),wf(:,-2),Q(:,4),G3(:,:,:,65))
  call loop_VV_S(G3(:,:,:,65),wf(:,-3),G3(:,:,:,66))
  call check_last_ST_V(l_switch,G3(:,:,:,66),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,65))
  call loop_UW_V(G3(:,:,:,65),Q(:,22),wf(:,-3),Q(:,8),G4(:,:,:,10))
  call check_last_VS_V(l_switch,G4(:,:,:,10),wf(:,0),G4tensor(:,66))
  call loop_TV_S(G1(:,:,:,131),Q(:,2),wf(:,-4),Q(:,16),G2(:,:,:,156))
  call loop_SSV_V(G2(:,:,:,156),wf(:,-2),wf(:,-3),G2(:,:,:,157))
  call check_last_VS_V(l_switch,G2(:,:,:,157),wf(:,0),G2tensor(:,202))
  call loop_TV_S(G2(:,:,:,156),Q(:,18),wf(:,-3),Q(:,8),G3(:,:,:,67))
  call loop_SS_S(G3(:,:,:,67),wf(:,-2),G3(:,:,:,68))
  call check_last_ST_V(l_switch,G3(:,:,:,68),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,67))
  call loop_ST_V(G3(:,:,:,67),Q(:,26),wf(:,-2),Q(:,4),G4(:,:,:,11))
  call check_last_VS_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,68))
  call loop_SV_V(G2(:,:,:,156),wf(:,-3),G2(:,:,:,158))
  call loop_VT_S(G2(:,:,:,158),Q(:,26),wf(:,-2),Q(:,4),G3(:,:,:,69))
  call check_last_ST_V(l_switch,G3(:,:,:,69),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,69))
  call loop_VS_V(G2(:,:,:,158),wf(:,-2),G2(:,:,:,159))
  call check_last_VS_V(l_switch,G2(:,:,:,159),wf(:,0),G2tensor(:,203))
  call loop_SS_S(G2(:,:,:,156),wf(:,-2),G2(:,:,:,160))
  call loop_TV_S(G2(:,:,:,160),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,70))
  call check_last_ST_V(l_switch,G3(:,:,:,70),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,70))
  call loop_SV_V(G2(:,:,:,160),wf(:,-3),G2(:,:,:,161))
  call check_last_VS_V(l_switch,G2(:,:,:,161),wf(:,0),G2tensor(:,204))
  call loop_ST_V(G2(:,:,:,156),Q(:,18),wf(:,-2),Q(:,4),G3(:,:,:,71))
  call loop_VV_S(G3(:,:,:,71),wf(:,-3),G3(:,:,:,72))
  call check_last_ST_V(l_switch,G3(:,:,:,72),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,71))
  call loop_UV_W(G3(:,:,:,71),Q(:,22),wf(:,-3),Q(:,8),G4(:,:,:,12))
  call check_last_VS_V(l_switch,G4(:,:,:,12),wf(:,0),G4tensor(:,72))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(11)) * TI2_call(0,momenta_37,masses2_13,G0tensor(:,1),T2sum(1:1,17))
  M(1) = M(1) + (-f(11)) * TI2_call(0,momenta_37,masses2_13,G0tensor(:,1),T2sum(1:1,17))
  M(1) = M(1) + (-f(49)) * TI2_call(0,momenta_37,masses2_13,G0tensor(:,13),T2sum(1:1,17))
  M(1) = M(1) + (-f(49)) * TI2_call(0,momenta_37,masses2_13,G0tensor(:,13),T2sum(1:1,17))
  M(1) = M(1) + (-f(17)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,1),T2sum(1:15,17))
  M(1) = M(1) + (-f(17)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,1),T2sum(1:15,17))
  M(1) = M(1) + (-f(17)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,153),T2sum(1:15,17))
  M(1) = M(1) + (-f(17)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,153),T2sum(1:15,17))
  M(1) = M(1) + (-f(33)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,154),T2sum(1:15,17))
  M(1) = M(1) + (-f(33)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,154),T2sum(1:15,17))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,77),T2sum(1:15,17))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_37,masses2_13,G2tensor(:,77),T2sum(1:15,17))
  M(1) = M(1) + (-f(11)) * TI2_call(0,momenta_32,masses2_13,G0tensor(:,2),T2sum(1:1,18))
  M(1) = M(1) + (-f(11)) * TI2_call(0,momenta_32,masses2_13,G0tensor(:,2),T2sum(1:1,18))
  M(1) = M(1) + (-f(49)) * TI2_call(0,momenta_32,masses2_13,G0tensor(:,14),T2sum(1:1,18))
  M(1) = M(1) + (-f(49)) * TI2_call(0,momenta_32,masses2_13,G0tensor(:,14),T2sum(1:1,18))
  M(1) = M(1) + (-f(17)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,155),T2sum(1:15,18))
  M(1) = M(1) + (-f(17)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,155),T2sum(1:15,18))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,14),T2sum(1:15,18))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,14),T2sum(1:15,18))
  M(1) = M(1) + (-f(33)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,90),T2sum(1:15,18))
  M(1) = M(1) + (-f(33)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,90),T2sum(1:15,18))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,166),T2sum(1:15,18))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_32,masses2_13,G2tensor(:,166),T2sum(1:15,18))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_36,masses2_13,G0tensor(:,5),T2sum(1:1,20))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_36,masses2_13,G0tensor(:,5),T2sum(1:1,20))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,25),T2sum(1:15,20))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,26),T2sum(1:15,20))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,169),T2sum(1:15,20))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,169),T2sum(1:15,20))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,101),T2sum(1:15,20))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,102),T2sum(1:15,20))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,170),T2sum(1:15,20))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_36,masses2_13,G2tensor(:,171),T2sum(1:15,20))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_36,masses2_13,G0tensor(:,17),T2sum(1:1,20))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_36,masses2_13,G0tensor(:,17),T2sum(1:1,20))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_33,masses2_13,G0tensor(:,6),T2sum(1:1,21))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_33,masses2_13,G0tensor(:,6),T2sum(1:1,21))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,37),T2sum(1:15,21))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,44),T2sum(1:15,21))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,172),T2sum(1:15,21))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,172),T2sum(1:15,21))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,181),T2sum(1:15,21))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,184),T2sum(1:15,21))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,103),T2sum(1:15,21))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_33,masses2_13,G2tensor(:,110),T2sum(1:15,21))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_33,masses2_13,G0tensor(:,18),T2sum(1:1,21))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_33,masses2_13,G0tensor(:,18),T2sum(1:1,21))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_34,masses2_13,G0tensor(:,9),T2sum(1:1,23))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_34,masses2_13,G0tensor(:,9),T2sum(1:1,23))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,51),T2sum(1:15,23))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,52),T2sum(1:15,23))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,187),T2sum(1:15,23))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,187),T2sum(1:15,23))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,127),T2sum(1:15,23))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,128),T2sum(1:15,23))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,188),T2sum(1:15,23))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_34,masses2_13,G2tensor(:,189),T2sum(1:15,23))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_34,masses2_13,G0tensor(:,21),T2sum(1:1,23))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_34,masses2_13,G0tensor(:,21),T2sum(1:1,23))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_35,masses2_13,G0tensor(:,10),T2sum(1:1,24))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_35,masses2_13,G0tensor(:,10),T2sum(1:1,24))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,63),T2sum(1:15,24))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,70),T2sum(1:15,24))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,190),T2sum(1:15,24))
  M(1) = M(1) + (-f(30)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,190),T2sum(1:15,24))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,199),T2sum(1:15,24))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,202),T2sum(1:15,24))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,129),T2sum(1:15,24))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_35,masses2_13,G2tensor(:,136),T2sum(1:15,24))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_35,masses2_13,G0tensor(:,22),T2sum(1:1,24))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_35,masses2_13,G0tensor(:,22),T2sum(1:1,24))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,38),T4sum(1:15,55))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,45),T4sum(1:15,55))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,104),T4sum(1:15,55))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,111),T4sum(1:15,55))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_65,masses2_19,G0tensor(:,7),T4sum(1:1,55))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_65,masses2_19,G0tensor(:,7),T4sum(1:1,55))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,39),T4sum(1:15,55))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,46),T4sum(1:15,55))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,5),T4sum(1:70,55))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,7),T4sum(1:70,55))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,45),T4sum(1:70,55))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,51),T4sum(1:70,55))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,28),T4sum(1:15,55))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,30),T4sum(1:15,55))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,27),T4sum(1:15,55))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,27),T4sum(1:15,55))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,40),T4sum(1:15,55))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,47),T4sum(1:15,55))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,173),T4sum(1:15,55))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,173),T4sum(1:15,55))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,47),T4sum(1:70,55))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,53),T4sum(1:70,55))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,117),T4sum(1:15,55))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,119),T4sum(1:15,55))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,46),T4sum(1:70,55))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,52),T4sum(1:70,55))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,29),T4sum(1:15,55))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,31),T4sum(1:15,55))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,41),T4sum(1:70,55))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,42),T4sum(1:70,55))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,105),T4sum(1:15,55))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,112),T4sum(1:15,55))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,121),T4sum(1:15,55))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,121),T4sum(1:15,55))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,174),T4sum(1:15,55))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,174),T4sum(1:15,55))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,182),T4sum(1:15,55))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,185),T4sum(1:15,55))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,118),T4sum(1:15,55))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,120),T4sum(1:15,55))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,17),T4sum(1:70,55))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_65,masses2_19,G4tensor(:,19),T4sum(1:70,55))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,175),T4sum(1:15,55))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,176),T4sum(1:15,55))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,106),T4sum(1:15,55))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_65,masses2_19,G2tensor(:,113),T4sum(1:15,55))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_65,masses2_19,G0tensor(:,19),T4sum(1:1,55))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_65,masses2_19,G0tensor(:,19),T4sum(1:1,55))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,64),T4sum(1:15,56))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,71),T4sum(1:15,56))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,130),T4sum(1:15,56))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,137),T4sum(1:15,56))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_67,masses2_19,G0tensor(:,11),T4sum(1:1,56))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_67,masses2_19,G0tensor(:,11),T4sum(1:1,56))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,65),T4sum(1:15,56))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,72),T4sum(1:15,56))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,9),T4sum(1:70,56))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,11),T4sum(1:70,56))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,61),T4sum(1:70,56))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,67),T4sum(1:70,56))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,54),T4sum(1:15,56))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,56),T4sum(1:15,56))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,53),T4sum(1:15,56))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,53),T4sum(1:15,56))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,66),T4sum(1:15,56))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,73),T4sum(1:15,56))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,191),T4sum(1:15,56))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,191),T4sum(1:15,56))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,63),T4sum(1:70,56))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,69),T4sum(1:70,56))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,143),T4sum(1:15,56))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,145),T4sum(1:15,56))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,62),T4sum(1:70,56))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,68),T4sum(1:70,56))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,55),T4sum(1:15,56))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,57),T4sum(1:15,56))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,57),T4sum(1:70,56))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,58),T4sum(1:70,56))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,131),T4sum(1:15,56))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,138),T4sum(1:15,56))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,147),T4sum(1:15,56))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,147),T4sum(1:15,56))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,192),T4sum(1:15,56))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,192),T4sum(1:15,56))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,200),T4sum(1:15,56))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,203),T4sum(1:15,56))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,144),T4sum(1:15,56))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,146),T4sum(1:15,56))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,21),T4sum(1:70,56))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_67,masses2_19,G4tensor(:,23),T4sum(1:70,56))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,193),T4sum(1:15,56))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,194),T4sum(1:15,56))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,132),T4sum(1:15,56))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_67,masses2_19,G2tensor(:,139),T4sum(1:15,56))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_67,masses2_19,G0tensor(:,23),T4sum(1:1,56))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_67,masses2_19,G0tensor(:,23),T4sum(1:1,56))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,2),T4sum(1:15,57))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,4),T4sum(1:15,57))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,78),T4sum(1:15,57))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,80),T4sum(1:15,57))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_63,masses2_19,G0tensor(:,3),T4sum(1:1,57))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_63,masses2_19,G0tensor(:,3),T4sum(1:1,57))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,15),T4sum(1:15,57))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,16),T4sum(1:15,57))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,3),T4sum(1:15,57))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,5),T4sum(1:15,57))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,25),T4sum(1:70,57))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,26),T4sum(1:70,57))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,18),T4sum(1:15,57))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,19),T4sum(1:15,57))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,6),T4sum(1:15,57))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,7),T4sum(1:15,57))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,17),T4sum(1:15,57))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,17),T4sum(1:15,57))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,158),T4sum(1:15,57))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,158),T4sum(1:15,57))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,29),T4sum(1:70,57))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,30),T4sum(1:70,57))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,13),T4sum(1:70,57))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,14),T4sum(1:70,57))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,156),T4sum(1:15,57))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,157),T4sum(1:15,57))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,1),T4sum(1:70,57))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,2),T4sum(1:70,57))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,31),T4sum(1:70,57))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,33),T4sum(1:70,57))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,93),T4sum(1:15,57))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,93),T4sum(1:15,57))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,82),T4sum(1:15,57))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,83),T4sum(1:15,57))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,159),T4sum(1:15,57))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,160),T4sum(1:15,57))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,167),T4sum(1:15,57))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,167),T4sum(1:15,57))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,91),T4sum(1:15,57))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,92),T4sum(1:15,57))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,79),T4sum(1:15,57))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,81),T4sum(1:15,57))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,32),T4sum(1:70,57))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_63,masses2_19,G4tensor(:,34),T4sum(1:70,57))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,94),T4sum(1:15,57))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_63,masses2_19,G2tensor(:,95),T4sum(1:15,57))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_63,masses2_19,G0tensor(:,15),T4sum(1:1,57))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_63,masses2_19,G0tensor(:,15),T4sum(1:1,57))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,67),T4sum(1:15,58))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,74),T4sum(1:15,58))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,133),T4sum(1:15,58))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,140),T4sum(1:15,58))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,58),T4sum(1:15,58))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,59),T4sum(1:15,58))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,69),T4sum(1:15,58))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,76),T4sum(1:15,58))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,68),T4sum(1:15,58))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,75),T4sum(1:15,58))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,64),T4sum(1:70,58))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,70),T4sum(1:70,58))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_66,masses2_19,G0tensor(:,12),T4sum(1:1,58))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_66,masses2_19,G0tensor(:,12),T4sum(1:1,58))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,60),T4sum(1:15,58))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,60),T4sum(1:15,58))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,10),T4sum(1:70,58))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,12),T4sum(1:70,58))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,59),T4sum(1:70,58))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,60),T4sum(1:70,58))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,65),T4sum(1:70,58))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,71),T4sum(1:70,58))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,148),T4sum(1:15,58))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,149),T4sum(1:15,58))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,201),T4sum(1:15,58))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,204),T4sum(1:15,58))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,61),T4sum(1:15,58))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,62),T4sum(1:15,58))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,196),T4sum(1:15,58))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,196),T4sum(1:15,58))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,22),T4sum(1:70,58))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,24),T4sum(1:70,58))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,150),T4sum(1:15,58))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,150),T4sum(1:15,58))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,195),T4sum(1:15,58))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,195),T4sum(1:15,58))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,66),T4sum(1:70,58))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_66,masses2_19,G4tensor(:,72),T4sum(1:70,58))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_66,masses2_19,G0tensor(:,24),T4sum(1:1,58))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_66,masses2_19,G0tensor(:,24),T4sum(1:1,58))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,134),T4sum(1:15,58))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,141),T4sum(1:15,58))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,197),T4sum(1:15,58))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,198),T4sum(1:15,58))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,135),T4sum(1:15,58))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,142),T4sum(1:15,58))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,151),T4sum(1:15,58))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_66,masses2_19,G2tensor(:,152),T4sum(1:15,58))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,8),T4sum(1:15,59))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,10),T4sum(1:15,59))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,84),T4sum(1:15,59))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,86),T4sum(1:15,59))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_62,masses2_19,G0tensor(:,4),T4sum(1:1,59))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_62,masses2_19,G0tensor(:,4),T4sum(1:1,59))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,20),T4sum(1:15,59))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,21),T4sum(1:15,59))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,9),T4sum(1:15,59))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,11),T4sum(1:15,59))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,27),T4sum(1:70,59))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,28),T4sum(1:70,59))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,23),T4sum(1:15,59))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,24),T4sum(1:15,59))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,12),T4sum(1:15,59))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,13),T4sum(1:15,59))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,22),T4sum(1:15,59))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,22),T4sum(1:15,59))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,163),T4sum(1:15,59))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,163),T4sum(1:15,59))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,35),T4sum(1:70,59))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,36),T4sum(1:70,59))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,15),T4sum(1:70,59))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,16),T4sum(1:70,59))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,161),T4sum(1:15,59))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,162),T4sum(1:15,59))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,3),T4sum(1:70,59))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,4),T4sum(1:70,59))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,37),T4sum(1:70,59))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,39),T4sum(1:70,59))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,98),T4sum(1:15,59))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,98),T4sum(1:15,59))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,88),T4sum(1:15,59))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,89),T4sum(1:15,59))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,164),T4sum(1:15,59))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,165),T4sum(1:15,59))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,168),T4sum(1:15,59))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,168),T4sum(1:15,59))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,96),T4sum(1:15,59))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,97),T4sum(1:15,59))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,85),T4sum(1:15,59))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,87),T4sum(1:15,59))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,38),T4sum(1:70,59))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_62,masses2_19,G4tensor(:,40),T4sum(1:70,59))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,99),T4sum(1:15,59))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_62,masses2_19,G2tensor(:,100),T4sum(1:15,59))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_62,masses2_19,G0tensor(:,16),T4sum(1:1,59))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_62,masses2_19,G0tensor(:,16),T4sum(1:1,59))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,41),T4sum(1:15,60))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,48),T4sum(1:15,60))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,107),T4sum(1:15,60))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,114),T4sum(1:15,60))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,43),T4sum(1:15,60))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,50),T4sum(1:15,60))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,32),T4sum(1:15,60))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,33),T4sum(1:15,60))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,42),T4sum(1:15,60))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,49),T4sum(1:15,60))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,48),T4sum(1:70,60))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,54),T4sum(1:70,60))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_64,masses2_19,G0tensor(:,8),T4sum(1:1,60))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_64,masses2_19,G0tensor(:,8),T4sum(1:1,60))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,6),T4sum(1:70,60))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,8),T4sum(1:70,60))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,34),T4sum(1:15,60))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,34),T4sum(1:15,60))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,49),T4sum(1:70,60))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,55),T4sum(1:70,60))
  M(1) = M(1) + (-f(30)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,43),T4sum(1:70,60))
  M(1) = M(1) + (f(30)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,44),T4sum(1:70,60))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,122),T4sum(1:15,60))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,123),T4sum(1:15,60))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,183),T4sum(1:15,60))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,186),T4sum(1:15,60))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,35),T4sum(1:15,60))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,36),T4sum(1:15,60))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,178),T4sum(1:15,60))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,178),T4sum(1:15,60))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,124),T4sum(1:15,60))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,124),T4sum(1:15,60))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,18),T4sum(1:70,60))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,20),T4sum(1:70,60))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,50),T4sum(1:70,60))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_64,masses2_19,G4tensor(:,56),T4sum(1:70,60))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,177),T4sum(1:15,60))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,177),T4sum(1:15,60))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_64,masses2_19,G0tensor(:,20),T4sum(1:1,60))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_64,masses2_19,G0tensor(:,20),T4sum(1:1,60))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,108),T4sum(1:15,60))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,115),T4sum(1:15,60))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,179),T4sum(1:15,60))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,180),T4sum(1:15,60))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,125),T4sum(1:15,60))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,126),T4sum(1:15,60))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,109),T4sum(1:15,60))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_64,masses2_19,G2tensor(:,116),T4sum(1:15,60))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_4

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G0tensorhel)
  deallocate(G2tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_4_aahhh2_hhhaa_2_/**/REALKIND
