
module ol_vamp_1_aahhh2_hhhaa_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G0tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_aahhh2_hhhaa_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_aahhh2_hhhaa_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_aahhh2_hhhaa_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_aahhh2_hhhaa_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,117) :: G0
  complex(REALKIND), dimension(4,5,4,208) :: G1
  complex(REALKIND), dimension(4,15,4,100) :: G2
  complex(REALKIND), dimension(4,35,4,16) :: G3
  complex(REALKIND), pointer :: G0tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G0tensorhel(1,80,4))
    allocate(G2tensorhel(15,244,4))
    allocate(G4tensorhel(70,16,4))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G0tensor => G0tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_SSS_S(G0(:,:,:,1),wf(:,-2),wf(:,-1),G0(:,:,:,2))
  call loop_SVV_S(G0(:,:,:,2),wf(:,-4),wf(:,-3),G0(:,:,:,3))
  call check_last_SS_S(l_switch,G0(:,:,:,3),wf(:,0),G0tensor(:,1))
  call loop_TV_S(G0(:,:,:,2),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,1))
  call loop_TV_S(G1(:,:,:,1),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,1))
  call check_last_SS_S(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,1))
  call loop_SV_V(G1(:,:,:,1),wf(:,-3),G1(:,:,:,2))
  call check_last_VT_S(l_switch,G1(:,:,:,2),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,2))
  call loop_SV_T(G0(:,:,:,2),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,3))
  call loop_SV_T(G1(:,:,:,3),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,2))
  call check_last_SS_S(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,3))
  call loop_SV_V(G1(:,:,:,3),wf(:,-3),G1(:,:,:,4))
  call check_last_VT_S(l_switch,G1(:,:,:,4),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,4))
  call loop_SV_V(G0(:,:,:,2),wf(:,-4),G0(:,:,:,4))
  call loop_VV_S(G0(:,:,:,4),wf(:,-3),G0(:,:,:,5))
  call check_last_SS_S(l_switch,G0(:,:,:,5),wf(:,0),G0tensor(:,2))
  call loop_UV_W(G0(:,:,:,4),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,5))
  call check_last_VT_S(l_switch,G1(:,:,:,5),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,5))
  call loop_UW_V(G0(:,:,:,4),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,6))
  call check_last_VT_S(l_switch,G1(:,:,:,6),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,6))
  call loop_TV_S(G0(:,:,:,2),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,7))
  call loop_TV_S(G1(:,:,:,7),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,3))
  call check_last_SS_S(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,7))
  call loop_SV_V(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call check_last_VT_S(l_switch,G1(:,:,:,8),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,8))
  call loop_SV_T(G0(:,:,:,2),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,9))
  call loop_SV_T(G1(:,:,:,9),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,4))
  call check_last_SS_S(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,9))
  call loop_SV_V(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10))
  call check_last_VT_S(l_switch,G1(:,:,:,10),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,10))
  call loop_SV_V(G0(:,:,:,2),wf(:,-3),G0(:,:,:,6))
  call loop_VV_S(G0(:,:,:,6),wf(:,-4),G0(:,:,:,7))
  call check_last_SS_S(l_switch,G0(:,:,:,7),wf(:,0),G0tensor(:,3))
  call loop_UV_W(G0(:,:,:,6),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,11))
  call check_last_VT_S(l_switch,G1(:,:,:,11),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,11))
  call loop_UW_V(G0(:,:,:,6),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,12))
  call check_last_VT_S(l_switch,G1(:,:,:,12),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,12))
  call loop_VSS_V(G0(:,:,:,1),wf(:,-2),wf(:,-1),G0(:,:,:,8))
  call loop_VWW_V(G0(:,:,:,8),wf(:,-4),wf(:,-3),G0(:,:,:,9))
  call check_last_VS_V(l_switch,G0(:,:,:,9),wf(:,0),G0tensor(:,4))
  call loop_UV_W(G0(:,:,:,8),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,13))
  call loop_UV_W(G1(:,:,:,13),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,5))
  call check_last_VS_V(l_switch,G2(:,:,:,5),wf(:,0),G2tensor(:,13))
  call loop_VV_S(G1(:,:,:,13),wf(:,-3),G1(:,:,:,14))
  call check_last_ST_V(l_switch,G1(:,:,:,14),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,14))
  call loop_UW_V(G0(:,:,:,8),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,15))
  call loop_UW_V(G1(:,:,:,15),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,6))
  call check_last_VS_V(l_switch,G2(:,:,:,6),wf(:,0),G2tensor(:,15))
  call loop_VV_S(G1(:,:,:,15),wf(:,-3),G1(:,:,:,16))
  call check_last_ST_V(l_switch,G1(:,:,:,16),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,16))
  call loop_VV_S(G0(:,:,:,8),wf(:,-4),G0(:,:,:,10))
  call loop_TV_S(G0(:,:,:,10),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,17))
  call check_last_ST_V(l_switch,G1(:,:,:,17),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,17))
  call loop_SV_T(G0(:,:,:,10),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,18))
  call check_last_ST_V(l_switch,G1(:,:,:,18),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,18))
  call loop_SV_V(G0(:,:,:,10),wf(:,-3),G0(:,:,:,11))
  call check_last_VS_V(l_switch,G0(:,:,:,11),wf(:,0),G0tensor(:,5))
  call loop_UV_W(G0(:,:,:,8),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,19))
  call loop_UV_W(G1(:,:,:,19),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,7))
  call check_last_VS_V(l_switch,G2(:,:,:,7),wf(:,0),G2tensor(:,19))
  call loop_VV_S(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20))
  call check_last_ST_V(l_switch,G1(:,:,:,20),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,20))
  call loop_UW_V(G0(:,:,:,8),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,21))
  call loop_UW_V(G1(:,:,:,21),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,8))
  call check_last_VS_V(l_switch,G2(:,:,:,8),wf(:,0),G2tensor(:,21))
  call loop_VV_S(G1(:,:,:,21),wf(:,-4),G1(:,:,:,22))
  call check_last_ST_V(l_switch,G1(:,:,:,22),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,22))
  call loop_VV_S(G0(:,:,:,8),wf(:,-3),G0(:,:,:,12))
  call loop_TV_S(G0(:,:,:,12),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,23))
  call check_last_ST_V(l_switch,G1(:,:,:,23),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,23))
  call loop_SV_T(G0(:,:,:,12),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,24))
  call check_last_ST_V(l_switch,G1(:,:,:,24),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,24))
  call loop_SV_V(G0(:,:,:,12),wf(:,-4),G0(:,:,:,13))
  call check_last_VS_V(l_switch,G0(:,:,:,13),wf(:,0),G0tensor(:,6))
  call loop_SSV_V(G0(:,:,:,1),wf(:,-1),wf(:,-3),G0(:,:,:,14))
  call loop_VVS_S(G0(:,:,:,14),wf(:,-4),wf(:,-2),G0(:,:,:,15))
  call check_last_SS_S(l_switch,G0(:,:,:,15),wf(:,0),G0tensor(:,7))
  call loop_VVS_S(G0(:,:,:,14),wf(:,-4),wf(:,0),G0(:,:,:,16))
  call check_last_SS_S(l_switch,G0(:,:,:,16),wf(:,-2),G0tensor(:,8))
  call loop_VV_S(G0(:,:,:,14),wf(:,-4),G0(:,:,:,17))
  call check_last_SSS_S(l_switch,G0(:,:,:,17),wf(:,-2),wf(:,0),G0tensor(:,9))
  call check_last_SS_S(l_switch,G0(:,:,:,17),wf(:,3),G0tensor(:,10))
  call loop_UW_V(G0(:,:,:,14),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,25))
  call check_last_VT_S(l_switch,G1(:,:,:,25),Q(:,26),wf(:,3),Q(:,5),G2tensor(:,25))
  call loop_UV_W(G0(:,:,:,14),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,26))
  call check_last_VT_S(l_switch,G1(:,:,:,26),Q(:,26),wf(:,3),Q(:,5),G2tensor(:,26))
  call loop_VT_S(G0(:,:,:,14),Q(:,10),wf(:,-2),Q(:,4),G1(:,:,:,27))
  call loop_TV_S(G1(:,:,:,27),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,9))
  call check_last_SS_S(l_switch,G2(:,:,:,9),wf(:,0),G2tensor(:,27))
  call loop_SV_T(G1(:,:,:,27),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,10))
  call check_last_SS_S(l_switch,G2(:,:,:,10),wf(:,0),G2tensor(:,28))
  call loop_SV_V(G1(:,:,:,27),wf(:,-4),G1(:,:,:,28))
  call check_last_VT_S(l_switch,G1(:,:,:,28),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,29))
  call loop_VS_V(G0(:,:,:,14),wf(:,-2),G0(:,:,:,18))
  call loop_VV_S(G0(:,:,:,18),wf(:,-4),G0(:,:,:,19))
  call check_last_SS_S(l_switch,G0(:,:,:,19),wf(:,0),G0tensor(:,11))
  call loop_UV_W(G0(:,:,:,18),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,29))
  call check_last_VT_S(l_switch,G1(:,:,:,29),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,30))
  call loop_UW_V(G0(:,:,:,18),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,30))
  call check_last_VT_S(l_switch,G1(:,:,:,30),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,31))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-3),wf(:,-1),G0(:,:,:,20))
  call loop_SSV_V(G0(:,:,:,20),wf(:,-2),wf(:,-4),G0(:,:,:,21))
  call check_last_VS_V(l_switch,G0(:,:,:,21),wf(:,0),G0tensor(:,12))
  call loop_SSV_V(G0(:,:,:,20),wf(:,0),wf(:,-4),G0(:,:,:,22))
  call check_last_VS_V(l_switch,G0(:,:,:,22),wf(:,-2),G0tensor(:,13))
  call loop_SV_V(G0(:,:,:,20),wf(:,-4),G0(:,:,:,23))
  call check_last_VSS_V(l_switch,G0(:,:,:,23),wf(:,-2),wf(:,0),G0tensor(:,14))
  call check_last_VS_V(l_switch,G0(:,:,:,23),wf(:,3),G0tensor(:,15))
  call loop_SV_T(G0(:,:,:,20),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,31))
  call check_last_ST_V(l_switch,G1(:,:,:,31),Q(:,26),wf(:,3),Q(:,5),G2tensor(:,32))
  call loop_TV_S(G0(:,:,:,20),Q(:,10),wf(:,-4),Q(:,16),G1(:,:,:,32))
  call check_last_ST_V(l_switch,G1(:,:,:,32),Q(:,26),wf(:,3),Q(:,5),G2tensor(:,33))
  call loop_SS_S(G0(:,:,:,20),wf(:,-2),G0(:,:,:,24))
  call loop_TV_S(G0(:,:,:,24),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,33))
  call check_last_ST_V(l_switch,G1(:,:,:,33),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,34))
  call loop_SV_T(G0(:,:,:,24),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,34))
  call check_last_ST_V(l_switch,G1(:,:,:,34),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,35))
  call loop_SV_V(G0(:,:,:,24),wf(:,-4),G0(:,:,:,25))
  call check_last_VS_V(l_switch,G0(:,:,:,25),wf(:,0),G0tensor(:,16))
  call loop_ST_V(G0(:,:,:,20),Q(:,10),wf(:,-2),Q(:,4),G1(:,:,:,35))
  call loop_VV_S(G1(:,:,:,35),wf(:,-4),G1(:,:,:,36))
  call check_last_ST_V(l_switch,G1(:,:,:,36),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,36))
  call loop_UV_W(G1(:,:,:,35),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,11))
  call check_last_VS_V(l_switch,G2(:,:,:,11),wf(:,0),G2tensor(:,37))
  call loop_UW_V(G1(:,:,:,35),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,12))
  call check_last_VS_V(l_switch,G2(:,:,:,12),wf(:,0),G2tensor(:,38))
  call loop_SSV_V(G0(:,:,:,1),wf(:,-2),wf(:,-3),G0(:,:,:,26))
  call loop_VVS_S(G0(:,:,:,26),wf(:,-4),wf(:,-1),G0(:,:,:,27))
  call check_last_SS_S(l_switch,G0(:,:,:,27),wf(:,0),G0tensor(:,17))
  call loop_VVS_S(G0(:,:,:,26),wf(:,-4),wf(:,0),G0(:,:,:,28))
  call check_last_SS_S(l_switch,G0(:,:,:,28),wf(:,-1),G0tensor(:,18))
  call loop_VV_S(G0(:,:,:,26),wf(:,-4),G0(:,:,:,29))
  call check_last_SSS_S(l_switch,G0(:,:,:,29),wf(:,-1),wf(:,0),G0tensor(:,19))
  call check_last_SS_S(l_switch,G0(:,:,:,29),wf(:,1),G0tensor(:,20))
  call loop_UW_V(G0(:,:,:,26),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,37))
  call check_last_VT_S(l_switch,G1(:,:,:,37),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,39))
  call loop_UV_W(G0(:,:,:,26),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,38))
  call check_last_VT_S(l_switch,G1(:,:,:,38),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,40))
  call loop_VT_S(G0(:,:,:,26),Q(:,12),wf(:,-1),Q(:,2),G1(:,:,:,39))
  call loop_TV_S(G1(:,:,:,39),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,13))
  call check_last_SS_S(l_switch,G2(:,:,:,13),wf(:,0),G2tensor(:,41))
  call loop_SV_T(G1(:,:,:,39),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,14))
  call check_last_SS_S(l_switch,G2(:,:,:,14),wf(:,0),G2tensor(:,42))
  call loop_SV_V(G1(:,:,:,39),wf(:,-4),G1(:,:,:,40))
  call check_last_VT_S(l_switch,G1(:,:,:,40),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,43))
  call loop_VS_V(G0(:,:,:,26),wf(:,-1),G0(:,:,:,30))
  call loop_VV_S(G0(:,:,:,30),wf(:,-4),G0(:,:,:,31))
  call check_last_SS_S(l_switch,G0(:,:,:,31),wf(:,0),G0tensor(:,21))
  call loop_UV_W(G0(:,:,:,30),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,41))
  call check_last_VT_S(l_switch,G1(:,:,:,41),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,44))
  call loop_UW_V(G0(:,:,:,30),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,42))
  call check_last_VT_S(l_switch,G1(:,:,:,42),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,45))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-3),wf(:,-2),G0(:,:,:,32))
  call loop_SSV_V(G0(:,:,:,32),wf(:,-1),wf(:,-4),G0(:,:,:,33))
  call check_last_VS_V(l_switch,G0(:,:,:,33),wf(:,0),G0tensor(:,22))
  call loop_SSV_V(G0(:,:,:,32),wf(:,0),wf(:,-4),G0(:,:,:,34))
  call check_last_VS_V(l_switch,G0(:,:,:,34),wf(:,-1),G0tensor(:,23))
  call loop_SV_V(G0(:,:,:,32),wf(:,-4),G0(:,:,:,35))
  call check_last_VSS_V(l_switch,G0(:,:,:,35),wf(:,-1),wf(:,0),G0tensor(:,24))
  call check_last_VS_V(l_switch,G0(:,:,:,35),wf(:,1),G0tensor(:,25))
  call loop_SV_T(G0(:,:,:,32),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,43))
  call check_last_ST_V(l_switch,G1(:,:,:,43),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,46))
  call loop_TV_S(G0(:,:,:,32),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,44))
  call check_last_ST_V(l_switch,G1(:,:,:,44),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,47))
  call loop_SS_S(G0(:,:,:,32),wf(:,-1),G0(:,:,:,36))
  call loop_TV_S(G0(:,:,:,36),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,45))
  call check_last_ST_V(l_switch,G1(:,:,:,45),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,48))
  call loop_SV_T(G0(:,:,:,36),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,46))
  call check_last_ST_V(l_switch,G1(:,:,:,46),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,49))
  call loop_SV_V(G0(:,:,:,36),wf(:,-4),G0(:,:,:,37))
  call check_last_VS_V(l_switch,G0(:,:,:,37),wf(:,0),G0tensor(:,26))
  call loop_ST_V(G0(:,:,:,32),Q(:,12),wf(:,-1),Q(:,2),G1(:,:,:,47))
  call loop_VV_S(G1(:,:,:,47),wf(:,-4),G1(:,:,:,48))
  call check_last_ST_V(l_switch,G1(:,:,:,48),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,50))
  call loop_UV_W(G1(:,:,:,47),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,15))
  call check_last_VS_V(l_switch,G2(:,:,:,15),wf(:,0),G2tensor(:,51))
  call loop_UW_V(G1(:,:,:,47),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,16))
  call check_last_VS_V(l_switch,G2(:,:,:,16),wf(:,0),G2tensor(:,52))
  call loop_SSS_S(G0(:,:,:,1),wf(:,-2),wf(:,0),G0(:,:,:,38))
  call loop_SVV_S(G0(:,:,:,38),wf(:,-4),wf(:,-3),G0(:,:,:,39))
  call check_last_SS_S(l_switch,G0(:,:,:,39),wf(:,-1),G0tensor(:,27))
  call loop_TV_S(G0(:,:,:,38),Q(:,5),wf(:,-4),Q(:,16),G1(:,:,:,49))
  call loop_TV_S(G1(:,:,:,49),Q(:,21),wf(:,-3),Q(:,8),G2(:,:,:,17))
  call check_last_SS_S(l_switch,G2(:,:,:,17),wf(:,-1),G2tensor(:,53))
  call loop_SV_V(G1(:,:,:,49),wf(:,-3),G1(:,:,:,50))
  call check_last_VT_S(l_switch,G1(:,:,:,50),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,54))
  call loop_SV_T(G0(:,:,:,38),Q(:,5),wf(:,-4),Q(:,16),G1(:,:,:,51))
  call loop_SV_T(G1(:,:,:,51),Q(:,21),wf(:,-3),Q(:,8),G2(:,:,:,18))
  call check_last_SS_S(l_switch,G2(:,:,:,18),wf(:,-1),G2tensor(:,55))
  call loop_SV_V(G1(:,:,:,51),wf(:,-3),G1(:,:,:,52))
  call check_last_VT_S(l_switch,G1(:,:,:,52),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,56))
  call loop_SV_V(G0(:,:,:,38),wf(:,-4),G0(:,:,:,40))
  call loop_VV_S(G0(:,:,:,40),wf(:,-3),G0(:,:,:,41))
  call check_last_SS_S(l_switch,G0(:,:,:,41),wf(:,-1),G0tensor(:,28))
  call loop_UV_W(G0(:,:,:,40),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,53))
  call check_last_VT_S(l_switch,G1(:,:,:,53),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,57))
  call loop_UW_V(G0(:,:,:,40),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,54))
  call check_last_VT_S(l_switch,G1(:,:,:,54),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,58))
  call loop_TV_S(G0(:,:,:,38),Q(:,5),wf(:,-3),Q(:,8),G1(:,:,:,55))
  call loop_TV_S(G1(:,:,:,55),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,19))
  call check_last_SS_S(l_switch,G2(:,:,:,19),wf(:,-1),G2tensor(:,59))
  call loop_SV_V(G1(:,:,:,55),wf(:,-4),G1(:,:,:,56))
  call check_last_VT_S(l_switch,G1(:,:,:,56),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,60))
  call loop_SV_T(G0(:,:,:,38),Q(:,5),wf(:,-3),Q(:,8),G1(:,:,:,57))
  call loop_SV_T(G1(:,:,:,57),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,20))
  call check_last_SS_S(l_switch,G2(:,:,:,20),wf(:,-1),G2tensor(:,61))
  call loop_SV_V(G1(:,:,:,57),wf(:,-4),G1(:,:,:,58))
  call check_last_VT_S(l_switch,G1(:,:,:,58),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,62))
  call loop_SV_V(G0(:,:,:,38),wf(:,-3),G0(:,:,:,42))
  call loop_VV_S(G0(:,:,:,42),wf(:,-4),G0(:,:,:,43))
  call check_last_SS_S(l_switch,G0(:,:,:,43),wf(:,-1),G0tensor(:,29))
  call loop_UV_W(G0(:,:,:,42),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,59))
  call check_last_VT_S(l_switch,G1(:,:,:,59),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,63))
  call loop_UW_V(G0(:,:,:,42),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,60))
  call check_last_VT_S(l_switch,G1(:,:,:,60),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,64))
  call loop_VSS_V(G0(:,:,:,1),wf(:,-2),wf(:,0),G0(:,:,:,44))
  call loop_VWW_V(G0(:,:,:,44),wf(:,-4),wf(:,-3),G0(:,:,:,45))
  call check_last_VS_V(l_switch,G0(:,:,:,45),wf(:,-1),G0tensor(:,30))
  call loop_UV_W(G0(:,:,:,44),Q(:,5),wf(:,-4),Q(:,16),G1(:,:,:,61))
  call loop_UV_W(G1(:,:,:,61),Q(:,21),wf(:,-3),Q(:,8),G2(:,:,:,21))
  call check_last_VS_V(l_switch,G2(:,:,:,21),wf(:,-1),G2tensor(:,65))
  call loop_VV_S(G1(:,:,:,61),wf(:,-3),G1(:,:,:,62))
  call check_last_ST_V(l_switch,G1(:,:,:,62),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,66))
  call loop_UW_V(G0(:,:,:,44),Q(:,5),wf(:,-4),Q(:,16),G1(:,:,:,63))
  call loop_UW_V(G1(:,:,:,63),Q(:,21),wf(:,-3),Q(:,8),G2(:,:,:,22))
  call check_last_VS_V(l_switch,G2(:,:,:,22),wf(:,-1),G2tensor(:,67))
  call loop_VV_S(G1(:,:,:,63),wf(:,-3),G1(:,:,:,64))
  call check_last_ST_V(l_switch,G1(:,:,:,64),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,68))
  call loop_VV_S(G0(:,:,:,44),wf(:,-4),G0(:,:,:,46))
  call loop_TV_S(G0(:,:,:,46),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,65))
  call check_last_ST_V(l_switch,G1(:,:,:,65),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,69))
  call loop_SV_T(G0(:,:,:,46),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,66))
  call check_last_ST_V(l_switch,G1(:,:,:,66),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,70))
  call loop_SV_V(G0(:,:,:,46),wf(:,-3),G0(:,:,:,47))
  call check_last_VS_V(l_switch,G0(:,:,:,47),wf(:,-1),G0tensor(:,31))
  call loop_UV_W(G0(:,:,:,44),Q(:,5),wf(:,-3),Q(:,8),G1(:,:,:,67))
  call loop_UV_W(G1(:,:,:,67),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,23))
  call check_last_VS_V(l_switch,G2(:,:,:,23),wf(:,-1),G2tensor(:,71))
  call loop_VV_S(G1(:,:,:,67),wf(:,-4),G1(:,:,:,68))
  call check_last_ST_V(l_switch,G1(:,:,:,68),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,72))
  call loop_UW_V(G0(:,:,:,44),Q(:,5),wf(:,-3),Q(:,8),G1(:,:,:,69))
  call loop_UW_V(G1(:,:,:,69),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,24))
  call check_last_VS_V(l_switch,G2(:,:,:,24),wf(:,-1),G2tensor(:,73))
  call loop_VV_S(G1(:,:,:,69),wf(:,-4),G1(:,:,:,70))
  call check_last_ST_V(l_switch,G1(:,:,:,70),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,74))
  call loop_VV_S(G0(:,:,:,44),wf(:,-3),G0(:,:,:,48))
  call loop_TV_S(G0(:,:,:,48),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,71))
  call check_last_ST_V(l_switch,G1(:,:,:,71),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,75))
  call loop_SV_T(G0(:,:,:,48),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,72))
  call check_last_ST_V(l_switch,G1(:,:,:,72),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,76))
  call loop_SV_V(G0(:,:,:,48),wf(:,-4),G0(:,:,:,49))
  call check_last_VS_V(l_switch,G0(:,:,:,49),wf(:,-1),G0tensor(:,32))
  call loop_SSV_V(G0(:,:,:,1),wf(:,0),wf(:,-3),G0(:,:,:,50))
  call loop_VVS_S(G0(:,:,:,50),wf(:,-4),wf(:,-2),G0(:,:,:,51))
  call check_last_SS_S(l_switch,G0(:,:,:,51),wf(:,-1),G0tensor(:,33))
  call loop_VVS_S(G0(:,:,:,50),wf(:,-4),wf(:,-1),G0(:,:,:,52))
  call check_last_SS_S(l_switch,G0(:,:,:,52),wf(:,-2),G0tensor(:,34))
  call loop_VV_S(G0(:,:,:,50),wf(:,-4),G0(:,:,:,53))
  call check_last_SSS_S(l_switch,G0(:,:,:,53),wf(:,-2),wf(:,-1),G0tensor(:,35))
  call check_last_SS_S(l_switch,G0(:,:,:,53),wf(:,7),G0tensor(:,36))
  call loop_UW_V(G0(:,:,:,50),Q(:,9),wf(:,-4),Q(:,16),G1(:,:,:,73))
  call check_last_VT_S(l_switch,G1(:,:,:,73),Q(:,25),wf(:,7),Q(:,6),G2tensor(:,77))
  call loop_UV_W(G0(:,:,:,50),Q(:,9),wf(:,-4),Q(:,16),G1(:,:,:,74))
  call check_last_VT_S(l_switch,G1(:,:,:,74),Q(:,25),wf(:,7),Q(:,6),G2tensor(:,78))
  call loop_VT_S(G0(:,:,:,50),Q(:,9),wf(:,-2),Q(:,4),G1(:,:,:,75))
  call loop_TV_S(G1(:,:,:,75),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,25))
  call check_last_SS_S(l_switch,G2(:,:,:,25),wf(:,-1),G2tensor(:,79))
  call loop_SV_T(G1(:,:,:,75),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,26))
  call check_last_SS_S(l_switch,G2(:,:,:,26),wf(:,-1),G2tensor(:,80))
  call loop_SV_V(G1(:,:,:,75),wf(:,-4),G1(:,:,:,76))
  call check_last_VT_S(l_switch,G1(:,:,:,76),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,81))
  call loop_VS_V(G0(:,:,:,50),wf(:,-2),G0(:,:,:,54))
  call loop_VV_S(G0(:,:,:,54),wf(:,-4),G0(:,:,:,55))
  call check_last_SS_S(l_switch,G0(:,:,:,55),wf(:,-1),G0tensor(:,37))
  call loop_UV_W(G0(:,:,:,54),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,77))
  call check_last_VT_S(l_switch,G1(:,:,:,77),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,82))
  call loop_UW_V(G0(:,:,:,54),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,78))
  call check_last_VT_S(l_switch,G1(:,:,:,78),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,83))
  call loop_VVS_S(G0(:,:,:,1),wf(:,-3),wf(:,0),G0(:,:,:,56))
  call loop_SSV_V(G0(:,:,:,56),wf(:,-2),wf(:,-4),G0(:,:,:,57))
  call check_last_VS_V(l_switch,G0(:,:,:,57),wf(:,-1),G0tensor(:,38))
  call loop_SSV_V(G0(:,:,:,56),wf(:,-1),wf(:,-4),G0(:,:,:,58))
  call check_last_VS_V(l_switch,G0(:,:,:,58),wf(:,-2),G0tensor(:,39))
  call loop_SV_V(G0(:,:,:,56),wf(:,-4),G0(:,:,:,59))
  call check_last_VSS_V(l_switch,G0(:,:,:,59),wf(:,-2),wf(:,-1),G0tensor(:,40))
  call check_last_VS_V(l_switch,G0(:,:,:,59),wf(:,7),G0tensor(:,41))
  call loop_SV_T(G0(:,:,:,56),Q(:,9),wf(:,-4),Q(:,16),G1(:,:,:,79))
  call check_last_ST_V(l_switch,G1(:,:,:,79),Q(:,25),wf(:,7),Q(:,6),G2tensor(:,84))
  call loop_TV_S(G0(:,:,:,56),Q(:,9),wf(:,-4),Q(:,16),G1(:,:,:,80))
  call check_last_ST_V(l_switch,G1(:,:,:,80),Q(:,25),wf(:,7),Q(:,6),G2tensor(:,85))
  call loop_SS_S(G0(:,:,:,56),wf(:,-2),G0(:,:,:,60))
  call loop_TV_S(G0(:,:,:,60),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,81))
  call check_last_ST_V(l_switch,G1(:,:,:,81),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,86))
  call loop_SV_T(G0(:,:,:,60),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,82))
  call check_last_ST_V(l_switch,G1(:,:,:,82),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,87))
  call loop_SV_V(G0(:,:,:,60),wf(:,-4),G0(:,:,:,61))
  call check_last_VS_V(l_switch,G0(:,:,:,61),wf(:,-1),G0tensor(:,42))
  call loop_ST_V(G0(:,:,:,56),Q(:,9),wf(:,-2),Q(:,4),G1(:,:,:,83))
  call loop_VV_S(G1(:,:,:,83),wf(:,-4),G1(:,:,:,84))
  call check_last_ST_V(l_switch,G1(:,:,:,84),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,88))
  call loop_UV_W(G1(:,:,:,83),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,27))
  call check_last_VS_V(l_switch,G2(:,:,:,27),wf(:,-1),G2tensor(:,89))
  call loop_UW_V(G1(:,:,:,83),Q(:,13),wf(:,-4),Q(:,16),G2(:,:,:,28))
  call check_last_VS_V(l_switch,G2(:,:,:,28),wf(:,-1),G2tensor(:,90))
  call loop_SS_S(G0(:,:,:,1),wf(:,-2),G0(:,:,:,62))
  call loop_SVV_S(G0(:,:,:,62),wf(:,-4),wf(:,-3),G0(:,:,:,63))
  call check_last_SSS_S(l_switch,G0(:,:,:,63),wf(:,-1),wf(:,0),G0tensor(:,43))
  call check_last_SS_S(l_switch,G0(:,:,:,63),wf(:,1),G0tensor(:,44))
  call loop_SS_S(G0(:,:,:,62),wf(:,-1),G0(:,:,:,64))
  call loop_SVV_S(G0(:,:,:,64),wf(:,-4),wf(:,-3),G0(:,:,:,65))
  call check_last_SS_S(l_switch,G0(:,:,:,65),wf(:,0),G0tensor(:,45))
  call loop_SV_T(G0(:,:,:,64),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,85))
  call loop_SV_T(G1(:,:,:,85),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,29))
  call check_last_SS_S(l_switch,G2(:,:,:,29),wf(:,0),G2tensor(:,91))
  call loop_SV_V(G1(:,:,:,85),wf(:,-3),G1(:,:,:,86))
  call check_last_VT_S(l_switch,G1(:,:,:,86),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,92))
  call loop_TV_S(G0(:,:,:,64),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,87))
  call loop_TV_S(G1(:,:,:,87),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,30))
  call check_last_SS_S(l_switch,G2(:,:,:,30),wf(:,0),G2tensor(:,93))
  call loop_SV_V(G1(:,:,:,87),wf(:,-3),G1(:,:,:,88))
  call check_last_VT_S(l_switch,G1(:,:,:,88),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,94))
  call loop_SV_V(G0(:,:,:,64),wf(:,-4),G0(:,:,:,66))
  call loop_VV_S(G0(:,:,:,66),wf(:,-3),G0(:,:,:,67))
  call check_last_SS_S(l_switch,G0(:,:,:,67),wf(:,0),G0tensor(:,46))
  call loop_UW_V(G0(:,:,:,66),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,89))
  call check_last_VT_S(l_switch,G1(:,:,:,89),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,95))
  call loop_UV_W(G0(:,:,:,66),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,90))
  call check_last_VT_S(l_switch,G1(:,:,:,90),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,96))
  call loop_SV_T(G0(:,:,:,64),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,91))
  call loop_SV_T(G1(:,:,:,91),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,31))
  call check_last_SS_S(l_switch,G2(:,:,:,31),wf(:,0),G2tensor(:,97))
  call loop_SV_V(G1(:,:,:,91),wf(:,-4),G1(:,:,:,92))
  call check_last_VT_S(l_switch,G1(:,:,:,92),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,98))
  call loop_TV_S(G0(:,:,:,64),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,93))
  call loop_TV_S(G1(:,:,:,93),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,32))
  call check_last_SS_S(l_switch,G2(:,:,:,32),wf(:,0),G2tensor(:,99))
  call loop_SV_V(G1(:,:,:,93),wf(:,-4),G1(:,:,:,94))
  call check_last_VT_S(l_switch,G1(:,:,:,94),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,100))
  call loop_SV_V(G0(:,:,:,64),wf(:,-3),G0(:,:,:,68))
  call loop_VV_S(G0(:,:,:,68),wf(:,-4),G0(:,:,:,69))
  call check_last_SS_S(l_switch,G0(:,:,:,69),wf(:,0),G0tensor(:,47))
  call loop_UW_V(G0(:,:,:,68),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,95))
  call check_last_VT_S(l_switch,G1(:,:,:,95),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,101))
  call loop_UV_W(G0(:,:,:,68),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,96))
  call check_last_VT_S(l_switch,G1(:,:,:,96),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,102))
  call loop_ST_V(G0(:,:,:,62),Q(:,4),wf(:,-1),Q(:,2),G1(:,:,:,97))
  call loop_VWW_V(G1(:,:,:,97),wf(:,-4),wf(:,-3),G1(:,:,:,98))
  call check_last_VT_S(l_switch,G1(:,:,:,98),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,103))
  call loop_VV_S(G1(:,:,:,97),wf(:,-4),G1(:,:,:,99))
  call loop_SV_T(G1(:,:,:,99),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,33))
  call check_last_SS_S(l_switch,G2(:,:,:,33),wf(:,0),G2tensor(:,104))
  call loop_TV_S(G1(:,:,:,99),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,34))
  call check_last_SS_S(l_switch,G2(:,:,:,34),wf(:,0),G2tensor(:,105))
  call loop_SV_V(G1(:,:,:,99),wf(:,-3),G1(:,:,:,100))
  call check_last_VT_S(l_switch,G1(:,:,:,100),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,106))
  call loop_UW_V(G1(:,:,:,97),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,35))
  call loop_VV_S(G2(:,:,:,35),wf(:,-3),G2(:,:,:,36))
  call check_last_SS_S(l_switch,G2(:,:,:,36),wf(:,0),G2tensor(:,107))
  call loop_UW_V(G2(:,:,:,35),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,1))
  call check_last_VT_S(l_switch,G3(:,:,:,1),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,1))
  call loop_UV_W(G1(:,:,:,97),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,37))
  call loop_VV_S(G2(:,:,:,37),wf(:,-3),G2(:,:,:,38))
  call check_last_SS_S(l_switch,G2(:,:,:,38),wf(:,0),G2tensor(:,108))
  call loop_UV_W(G2(:,:,:,37),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,2))
  call check_last_VT_S(l_switch,G3(:,:,:,2),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,2))
  call loop_VV_S(G1(:,:,:,97),wf(:,-3),G1(:,:,:,101))
  call loop_SV_T(G1(:,:,:,101),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,39))
  call check_last_SS_S(l_switch,G2(:,:,:,39),wf(:,0),G2tensor(:,109))
  call loop_TV_S(G1(:,:,:,101),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,40))
  call check_last_SS_S(l_switch,G2(:,:,:,40),wf(:,0),G2tensor(:,110))
  call loop_SV_V(G1(:,:,:,101),wf(:,-4),G1(:,:,:,102))
  call check_last_VT_S(l_switch,G1(:,:,:,102),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,111))
  call loop_UW_V(G1(:,:,:,97),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,41))
  call loop_VV_S(G2(:,:,:,41),wf(:,-4),G2(:,:,:,42))
  call check_last_SS_S(l_switch,G2(:,:,:,42),wf(:,0),G2tensor(:,112))
  call loop_UW_V(G2(:,:,:,41),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,3))
  call check_last_VT_S(l_switch,G3(:,:,:,3),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,3))
  call loop_UV_W(G1(:,:,:,97),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,43))
  call loop_VV_S(G2(:,:,:,43),wf(:,-4),G2(:,:,:,44))
  call check_last_SS_S(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,113))
  call loop_UV_W(G2(:,:,:,43),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,4))
  call check_last_VT_S(l_switch,G3(:,:,:,4),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,4))
  call loop_SSV_V(G0(:,:,:,62),wf(:,-1),wf(:,-4),G0(:,:,:,70))
  call loop_VV_S(G0(:,:,:,70),wf(:,-3),G0(:,:,:,71))
  call check_last_SS_S(l_switch,G0(:,:,:,71),wf(:,0),G0tensor(:,48))
  call loop_UW_V(G0(:,:,:,70),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,103))
  call check_last_VT_S(l_switch,G1(:,:,:,103),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,114))
  call loop_UV_W(G0(:,:,:,70),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,104))
  call check_last_VT_S(l_switch,G1(:,:,:,104),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,115))
  call loop_SV_V(G0(:,:,:,62),wf(:,-3),G0(:,:,:,72))
  call loop_VVS_S(G0(:,:,:,72),wf(:,-4),wf(:,-1),G0(:,:,:,73))
  call check_last_SS_S(l_switch,G0(:,:,:,73),wf(:,0),G0tensor(:,49))
  call loop_VVS_S(G0(:,:,:,72),wf(:,-4),wf(:,0),G0(:,:,:,74))
  call check_last_SS_S(l_switch,G0(:,:,:,74),wf(:,-1),G0tensor(:,50))
  call loop_VV_S(G0(:,:,:,72),wf(:,-4),G0(:,:,:,75))
  call check_last_SSS_S(l_switch,G0(:,:,:,75),wf(:,-1),wf(:,0),G0tensor(:,51))
  call check_last_SS_S(l_switch,G0(:,:,:,75),wf(:,1),G0tensor(:,52))
  call loop_UW_V(G0(:,:,:,72),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,105))
  call check_last_VT_S(l_switch,G1(:,:,:,105),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,116))
  call loop_UV_W(G0(:,:,:,72),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,106))
  call check_last_VT_S(l_switch,G1(:,:,:,106),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,117))
  call loop_VT_S(G0(:,:,:,72),Q(:,12),wf(:,-1),Q(:,2),G1(:,:,:,107))
  call loop_SV_T(G1(:,:,:,107),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,45))
  call check_last_SS_S(l_switch,G2(:,:,:,45),wf(:,0),G2tensor(:,118))
  call loop_TV_S(G1(:,:,:,107),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,46))
  call check_last_SS_S(l_switch,G2(:,:,:,46),wf(:,0),G2tensor(:,119))
  call loop_SV_V(G1(:,:,:,107),wf(:,-4),G1(:,:,:,108))
  call check_last_VT_S(l_switch,G1(:,:,:,108),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,120))
  call loop_VS_V(G0(:,:,:,72),wf(:,-1),G0(:,:,:,76))
  call loop_VV_S(G0(:,:,:,76),wf(:,-4),G0(:,:,:,77))
  call check_last_SS_S(l_switch,G0(:,:,:,77),wf(:,0),G0tensor(:,53))
  call loop_UW_V(G0(:,:,:,76),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,109))
  call check_last_VT_S(l_switch,G1(:,:,:,109),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,121))
  call loop_UV_W(G0(:,:,:,76),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,110))
  call check_last_VT_S(l_switch,G1(:,:,:,110),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,122))
  call loop_SV_T(G0(:,:,:,62),Q(:,4),wf(:,-3),Q(:,8),G1(:,:,:,111))
  call loop_SSV_V(G1(:,:,:,111),wf(:,-1),wf(:,-4),G1(:,:,:,112))
  call check_last_VT_S(l_switch,G1(:,:,:,112),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,123))
  call loop_SSV_V(G1(:,:,:,111),wf(:,0),wf(:,-4),G1(:,:,:,113))
  call check_last_VT_S(l_switch,G1(:,:,:,113),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,124))
  call loop_SV_T(G1(:,:,:,111),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,47))
  call check_last_SSS_S(l_switch,G2(:,:,:,47),wf(:,-1),wf(:,0),G2tensor(:,125))
  call check_last_SS_S(l_switch,G2(:,:,:,47),wf(:,1),G2tensor(:,126))
  call loop_SV_V(G1(:,:,:,111),wf(:,-4),G1(:,:,:,114))
  call check_last_VT_S(l_switch,G1(:,:,:,114),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,127))
  call loop_SS_S(G1(:,:,:,111),wf(:,-1),G1(:,:,:,115))
  call loop_SV_T(G1(:,:,:,115),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,48))
  call check_last_SS_S(l_switch,G2(:,:,:,48),wf(:,0),G2tensor(:,128))
  call loop_SV_V(G1(:,:,:,115),wf(:,-4),G1(:,:,:,116))
  call check_last_VT_S(l_switch,G1(:,:,:,116),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,129))
  call loop_ST_V(G1(:,:,:,111),Q(:,12),wf(:,-1),Q(:,2),G2(:,:,:,49))
  call loop_VV_S(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call check_last_SS_S(l_switch,G2(:,:,:,50),wf(:,0),G2tensor(:,130))
  call loop_UW_V(G2(:,:,:,49),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,5))
  call check_last_VT_S(l_switch,G3(:,:,:,5),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,5))
  call loop_TV_S(G0(:,:,:,62),Q(:,4),wf(:,-3),Q(:,8),G1(:,:,:,117))
  call loop_SSV_V(G1(:,:,:,117),wf(:,-1),wf(:,-4),G1(:,:,:,118))
  call check_last_VT_S(l_switch,G1(:,:,:,118),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,131))
  call loop_SSV_V(G1(:,:,:,117),wf(:,0),wf(:,-4),G1(:,:,:,119))
  call check_last_VT_S(l_switch,G1(:,:,:,119),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,132))
  call loop_TV_S(G1(:,:,:,117),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,51))
  call check_last_SSS_S(l_switch,G2(:,:,:,51),wf(:,-1),wf(:,0),G2tensor(:,133))
  call check_last_SS_S(l_switch,G2(:,:,:,51),wf(:,1),G2tensor(:,134))
  call loop_SV_V(G1(:,:,:,117),wf(:,-4),G1(:,:,:,120))
  call check_last_VT_S(l_switch,G1(:,:,:,120),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,135))
  call loop_SS_S(G1(:,:,:,117),wf(:,-1),G1(:,:,:,121))
  call loop_TV_S(G1(:,:,:,121),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,52))
  call check_last_SS_S(l_switch,G2(:,:,:,52),wf(:,0),G2tensor(:,136))
  call loop_SV_V(G1(:,:,:,121),wf(:,-4),G1(:,:,:,122))
  call check_last_VT_S(l_switch,G1(:,:,:,122),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,137))
  call loop_ST_V(G1(:,:,:,117),Q(:,12),wf(:,-1),Q(:,2),G2(:,:,:,53))
  call loop_VV_S(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call check_last_SS_S(l_switch,G2(:,:,:,54),wf(:,0),G2tensor(:,138))
  call loop_UV_W(G2(:,:,:,53),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,6))
  call check_last_VT_S(l_switch,G3(:,:,:,6),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,6))
  call loop_SSV_V(G0(:,:,:,62),wf(:,-1),wf(:,-3),G0(:,:,:,78))
  call loop_VV_S(G0(:,:,:,78),wf(:,-4),G0(:,:,:,79))
  call check_last_SS_S(l_switch,G0(:,:,:,79),wf(:,0),G0tensor(:,54))
  call loop_UW_V(G0(:,:,:,78),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,123))
  call check_last_VT_S(l_switch,G1(:,:,:,123),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,139))
  call loop_UV_W(G0(:,:,:,78),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,124))
  call check_last_VT_S(l_switch,G1(:,:,:,124),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,140))
  call loop_SV_V(G0(:,:,:,62),wf(:,-4),G0(:,:,:,80))
  call loop_VVS_S(G0(:,:,:,80),wf(:,-3),wf(:,-1),G0(:,:,:,81))
  call check_last_SS_S(l_switch,G0(:,:,:,81),wf(:,0),G0tensor(:,55))
  call loop_VVS_S(G0(:,:,:,80),wf(:,-3),wf(:,0),G0(:,:,:,82))
  call check_last_SS_S(l_switch,G0(:,:,:,82),wf(:,-1),G0tensor(:,56))
  call loop_VV_S(G0(:,:,:,80),wf(:,-3),G0(:,:,:,83))
  call check_last_SSS_S(l_switch,G0(:,:,:,83),wf(:,-1),wf(:,0),G0tensor(:,57))
  call check_last_SS_S(l_switch,G0(:,:,:,83),wf(:,1),G0tensor(:,58))
  call loop_UW_V(G0(:,:,:,80),Q(:,20),wf(:,-3),Q(:,8),G1(:,:,:,125))
  call check_last_VT_S(l_switch,G1(:,:,:,125),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,141))
  call loop_UV_W(G0(:,:,:,80),Q(:,20),wf(:,-3),Q(:,8),G1(:,:,:,126))
  call check_last_VT_S(l_switch,G1(:,:,:,126),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,142))
  call loop_VT_S(G0(:,:,:,80),Q(:,20),wf(:,-1),Q(:,2),G1(:,:,:,127))
  call loop_SV_T(G1(:,:,:,127),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,55))
  call check_last_SS_S(l_switch,G2(:,:,:,55),wf(:,0),G2tensor(:,143))
  call loop_TV_S(G1(:,:,:,127),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,56))
  call check_last_SS_S(l_switch,G2(:,:,:,56),wf(:,0),G2tensor(:,144))
  call loop_SV_V(G1(:,:,:,127),wf(:,-3),G1(:,:,:,128))
  call check_last_VT_S(l_switch,G1(:,:,:,128),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,145))
  call loop_VS_V(G0(:,:,:,80),wf(:,-1),G0(:,:,:,84))
  call loop_VV_S(G0(:,:,:,84),wf(:,-3),G0(:,:,:,85))
  call check_last_SS_S(l_switch,G0(:,:,:,85),wf(:,0),G0tensor(:,59))
  call loop_UW_V(G0(:,:,:,84),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,129))
  call check_last_VT_S(l_switch,G1(:,:,:,129),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,146))
  call loop_UV_W(G0(:,:,:,84),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,130))
  call check_last_VT_S(l_switch,G1(:,:,:,130),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,147))
  call loop_SV_T(G0(:,:,:,62),Q(:,4),wf(:,-4),Q(:,16),G1(:,:,:,131))
  call loop_SSV_V(G1(:,:,:,131),wf(:,-1),wf(:,-3),G1(:,:,:,132))
  call check_last_VT_S(l_switch,G1(:,:,:,132),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,148))
  call loop_SSV_V(G1(:,:,:,131),wf(:,0),wf(:,-3),G1(:,:,:,133))
  call check_last_VT_S(l_switch,G1(:,:,:,133),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,149))
  call loop_SV_T(G1(:,:,:,131),Q(:,20),wf(:,-3),Q(:,8),G2(:,:,:,57))
  call check_last_SSS_S(l_switch,G2(:,:,:,57),wf(:,-1),wf(:,0),G2tensor(:,150))
  call check_last_SS_S(l_switch,G2(:,:,:,57),wf(:,1),G2tensor(:,151))
  call loop_SV_V(G1(:,:,:,131),wf(:,-3),G1(:,:,:,134))
  call check_last_VT_S(l_switch,G1(:,:,:,134),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,152))
  call loop_SS_S(G1(:,:,:,131),wf(:,-1),G1(:,:,:,135))
  call loop_SV_T(G1(:,:,:,135),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,58))
  call check_last_SS_S(l_switch,G2(:,:,:,58),wf(:,0),G2tensor(:,153))
  call loop_SV_V(G1(:,:,:,135),wf(:,-3),G1(:,:,:,136))
  call check_last_VT_S(l_switch,G1(:,:,:,136),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,154))
  call loop_ST_V(G1(:,:,:,131),Q(:,20),wf(:,-1),Q(:,2),G2(:,:,:,59))
  call loop_VV_S(G2(:,:,:,59),wf(:,-3),G2(:,:,:,60))
  call check_last_SS_S(l_switch,G2(:,:,:,60),wf(:,0),G2tensor(:,155))
  call loop_UW_V(G2(:,:,:,59),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,7))
  call check_last_VT_S(l_switch,G3(:,:,:,7),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,7))
  call loop_TV_S(G0(:,:,:,62),Q(:,4),wf(:,-4),Q(:,16),G1(:,:,:,137))
  call loop_SSV_V(G1(:,:,:,137),wf(:,-1),wf(:,-3),G1(:,:,:,138))
  call check_last_VT_S(l_switch,G1(:,:,:,138),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,156))
  call loop_SSV_V(G1(:,:,:,137),wf(:,0),wf(:,-3),G1(:,:,:,139))
  call check_last_VT_S(l_switch,G1(:,:,:,139),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,157))
  call loop_TV_S(G1(:,:,:,137),Q(:,20),wf(:,-3),Q(:,8),G2(:,:,:,61))
  call check_last_SSS_S(l_switch,G2(:,:,:,61),wf(:,-1),wf(:,0),G2tensor(:,158))
  call check_last_SS_S(l_switch,G2(:,:,:,61),wf(:,1),G2tensor(:,159))
  call loop_SV_V(G1(:,:,:,137),wf(:,-3),G1(:,:,:,140))
  call check_last_VT_S(l_switch,G1(:,:,:,140),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,160))
  call loop_SS_S(G1(:,:,:,137),wf(:,-1),G1(:,:,:,141))
  call loop_TV_S(G1(:,:,:,141),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,62))
  call check_last_SS_S(l_switch,G2(:,:,:,62),wf(:,0),G2tensor(:,161))
  call loop_SV_V(G1(:,:,:,141),wf(:,-3),G1(:,:,:,142))
  call check_last_VT_S(l_switch,G1(:,:,:,142),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,162))
  call loop_ST_V(G1(:,:,:,137),Q(:,20),wf(:,-1),Q(:,2),G2(:,:,:,63))
  call loop_VV_S(G2(:,:,:,63),wf(:,-3),G2(:,:,:,64))
  call check_last_SS_S(l_switch,G2(:,:,:,64),wf(:,0),G2tensor(:,163))
  call loop_UV_W(G2(:,:,:,63),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,8))
  call check_last_VT_S(l_switch,G3(:,:,:,8),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,8))
  call loop_SSV_V(G0(:,:,:,62),wf(:,0),wf(:,-4),G0(:,:,:,86))
  call loop_VV_S(G0(:,:,:,86),wf(:,-3),G0(:,:,:,87))
  call check_last_SS_S(l_switch,G0(:,:,:,87),wf(:,-1),G0tensor(:,60))
  call loop_UW_V(G0(:,:,:,86),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,143))
  call check_last_VT_S(l_switch,G1(:,:,:,143),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,164))
  call loop_UV_W(G0(:,:,:,86),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,144))
  call check_last_VT_S(l_switch,G1(:,:,:,144),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,165))
  call loop_SSV_V(G0(:,:,:,62),wf(:,0),wf(:,-3),G0(:,:,:,88))
  call loop_VV_S(G0(:,:,:,88),wf(:,-4),G0(:,:,:,89))
  call check_last_SS_S(l_switch,G0(:,:,:,89),wf(:,-1),G0tensor(:,61))
  call loop_UW_V(G0(:,:,:,88),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,145))
  call check_last_VT_S(l_switch,G1(:,:,:,145),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,166))
  call loop_UV_W(G0(:,:,:,88),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,146))
  call check_last_VT_S(l_switch,G1(:,:,:,146),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,167))
  call loop_VS_V(G0(:,:,:,1),wf(:,-2),G0(:,:,:,90))
  call loop_VWW_V(G0(:,:,:,90),wf(:,-4),wf(:,-3),G0(:,:,:,91))
  call check_last_VSS_V(l_switch,G0(:,:,:,91),wf(:,-1),wf(:,0),G0tensor(:,62))
  call check_last_VS_V(l_switch,G0(:,:,:,91),wf(:,1),G0tensor(:,63))
  call loop_VS_V(G0(:,:,:,90),wf(:,-1),G0(:,:,:,92))
  call loop_VWW_V(G0(:,:,:,92),wf(:,-4),wf(:,-3),G0(:,:,:,93))
  call check_last_VS_V(l_switch,G0(:,:,:,93),wf(:,0),G0tensor(:,64))
  call loop_UW_V(G0(:,:,:,92),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,147))
  call loop_UW_V(G1(:,:,:,147),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,65))
  call check_last_VS_V(l_switch,G2(:,:,:,65),wf(:,0),G2tensor(:,168))
  call loop_VV_S(G1(:,:,:,147),wf(:,-3),G1(:,:,:,148))
  call check_last_ST_V(l_switch,G1(:,:,:,148),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,169))
  call loop_UV_W(G0(:,:,:,92),Q(:,6),wf(:,-4),Q(:,16),G1(:,:,:,149))
  call loop_UV_W(G1(:,:,:,149),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,66))
  call check_last_VS_V(l_switch,G2(:,:,:,66),wf(:,0),G2tensor(:,170))
  call loop_VV_S(G1(:,:,:,149),wf(:,-3),G1(:,:,:,150))
  call check_last_ST_V(l_switch,G1(:,:,:,150),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,171))
  call loop_VV_S(G0(:,:,:,92),wf(:,-4),G0(:,:,:,94))
  call loop_SV_T(G0(:,:,:,94),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,151))
  call check_last_ST_V(l_switch,G1(:,:,:,151),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,172))
  call loop_TV_S(G0(:,:,:,94),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,152))
  call check_last_ST_V(l_switch,G1(:,:,:,152),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,173))
  call loop_SV_V(G0(:,:,:,94),wf(:,-3),G0(:,:,:,95))
  call check_last_VS_V(l_switch,G0(:,:,:,95),wf(:,0),G0tensor(:,65))
  call loop_UW_V(G0(:,:,:,92),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,153))
  call loop_UW_V(G1(:,:,:,153),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,67))
  call check_last_VS_V(l_switch,G2(:,:,:,67),wf(:,0),G2tensor(:,174))
  call loop_VV_S(G1(:,:,:,153),wf(:,-4),G1(:,:,:,154))
  call check_last_ST_V(l_switch,G1(:,:,:,154),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,175))
  call loop_UV_W(G0(:,:,:,92),Q(:,6),wf(:,-3),Q(:,8),G1(:,:,:,155))
  call loop_UV_W(G1(:,:,:,155),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,68))
  call check_last_VS_V(l_switch,G2(:,:,:,68),wf(:,0),G2tensor(:,176))
  call loop_VV_S(G1(:,:,:,155),wf(:,-4),G1(:,:,:,156))
  call check_last_ST_V(l_switch,G1(:,:,:,156),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,177))
  call loop_VV_S(G0(:,:,:,92),wf(:,-3),G0(:,:,:,96))
  call loop_SV_T(G0(:,:,:,96),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,157))
  call check_last_ST_V(l_switch,G1(:,:,:,157),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,178))
  call loop_TV_S(G0(:,:,:,96),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,158))
  call check_last_ST_V(l_switch,G1(:,:,:,158),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,179))
  call loop_SV_V(G0(:,:,:,96),wf(:,-4),G0(:,:,:,97))
  call check_last_VS_V(l_switch,G0(:,:,:,97),wf(:,0),G0tensor(:,66))
  call loop_VT_S(G0(:,:,:,90),Q(:,4),wf(:,-1),Q(:,2),G1(:,:,:,159))
  call loop_SVV_S(G1(:,:,:,159),wf(:,-4),wf(:,-3),G1(:,:,:,160))
  call check_last_ST_V(l_switch,G1(:,:,:,160),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,180))
  call loop_SV_T(G1(:,:,:,159),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,69))
  call loop_SV_T(G2(:,:,:,69),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,9))
  call check_last_ST_V(l_switch,G3(:,:,:,9),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,9))
  call loop_SV_V(G2(:,:,:,69),wf(:,-3),G2(:,:,:,70))
  call check_last_VS_V(l_switch,G2(:,:,:,70),wf(:,0),G2tensor(:,181))
  call loop_TV_S(G1(:,:,:,159),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,71))
  call loop_TV_S(G2(:,:,:,71),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,10))
  call check_last_ST_V(l_switch,G3(:,:,:,10),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,10))
  call loop_SV_V(G2(:,:,:,71),wf(:,-3),G2(:,:,:,72))
  call check_last_VS_V(l_switch,G2(:,:,:,72),wf(:,0),G2tensor(:,182))
  call loop_SV_V(G1(:,:,:,159),wf(:,-4),G1(:,:,:,161))
  call loop_VV_S(G1(:,:,:,161),wf(:,-3),G1(:,:,:,162))
  call check_last_ST_V(l_switch,G1(:,:,:,162),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,183))
  call loop_UW_V(G1(:,:,:,161),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,73))
  call check_last_VS_V(l_switch,G2(:,:,:,73),wf(:,0),G2tensor(:,184))
  call loop_UV_W(G1(:,:,:,161),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,74))
  call check_last_VS_V(l_switch,G2(:,:,:,74),wf(:,0),G2tensor(:,185))
  call loop_SV_T(G1(:,:,:,159),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,75))
  call loop_SV_T(G2(:,:,:,75),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,11))
  call check_last_ST_V(l_switch,G3(:,:,:,11),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,11))
  call loop_SV_V(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76))
  call check_last_VS_V(l_switch,G2(:,:,:,76),wf(:,0),G2tensor(:,186))
  call loop_TV_S(G1(:,:,:,159),Q(:,6),wf(:,-3),Q(:,8),G2(:,:,:,77))
  call loop_TV_S(G2(:,:,:,77),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,12))
  call check_last_ST_V(l_switch,G3(:,:,:,12),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,12))
  call loop_SV_V(G2(:,:,:,77),wf(:,-4),G2(:,:,:,78))
  call check_last_VS_V(l_switch,G2(:,:,:,78),wf(:,0),G2tensor(:,187))
  call loop_SV_V(G1(:,:,:,159),wf(:,-3),G1(:,:,:,163))
  call loop_VV_S(G1(:,:,:,163),wf(:,-4),G1(:,:,:,164))
  call check_last_ST_V(l_switch,G1(:,:,:,164),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,188))
  call loop_UW_V(G1(:,:,:,163),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,79))
  call check_last_VS_V(l_switch,G2(:,:,:,79),wf(:,0),G2tensor(:,189))
  call loop_UV_W(G1(:,:,:,163),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,80))
  call check_last_VS_V(l_switch,G2(:,:,:,80),wf(:,0),G2tensor(:,190))
  call loop_VVS_S(G0(:,:,:,90),wf(:,-4),wf(:,-1),G0(:,:,:,98))
  call loop_SV_T(G0(:,:,:,98),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,165))
  call check_last_ST_V(l_switch,G1(:,:,:,165),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,191))
  call loop_TV_S(G0(:,:,:,98),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,166))
  call check_last_ST_V(l_switch,G1(:,:,:,166),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,192))
  call loop_SV_V(G0(:,:,:,98),wf(:,-3),G0(:,:,:,99))
  call check_last_VS_V(l_switch,G0(:,:,:,99),wf(:,0),G0tensor(:,67))
  call loop_UW_V(G0(:,:,:,90),Q(:,4),wf(:,-3),Q(:,8),G1(:,:,:,167))
  call loop_VVS_S(G1(:,:,:,167),wf(:,-4),wf(:,-1),G1(:,:,:,168))
  call check_last_ST_V(l_switch,G1(:,:,:,168),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,193))
  call loop_VVS_S(G1(:,:,:,167),wf(:,-4),wf(:,0),G1(:,:,:,169))
  call check_last_ST_V(l_switch,G1(:,:,:,169),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,194))
  call loop_UW_V(G1(:,:,:,167),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,81))
  call check_last_VSS_V(l_switch,G2(:,:,:,81),wf(:,-1),wf(:,0),G2tensor(:,195))
  call check_last_VS_V(l_switch,G2(:,:,:,81),wf(:,1),G2tensor(:,196))
  call loop_VV_S(G1(:,:,:,167),wf(:,-4),G1(:,:,:,170))
  call check_last_ST_V(l_switch,G1(:,:,:,170),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,197))
  call loop_VS_V(G1(:,:,:,167),wf(:,-1),G1(:,:,:,171))
  call loop_UW_V(G1(:,:,:,171),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,82))
  call check_last_VS_V(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,198))
  call loop_VV_S(G1(:,:,:,171),wf(:,-4),G1(:,:,:,172))
  call check_last_ST_V(l_switch,G1(:,:,:,172),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,199))
  call loop_VT_S(G1(:,:,:,167),Q(:,12),wf(:,-1),Q(:,2),G2(:,:,:,83))
  call loop_SV_T(G2(:,:,:,83),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,13))
  call check_last_ST_V(l_switch,G3(:,:,:,13),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,13))
  call loop_SV_V(G2(:,:,:,83),wf(:,-4),G2(:,:,:,84))
  call check_last_VS_V(l_switch,G2(:,:,:,84),wf(:,0),G2tensor(:,200))
  call loop_UV_W(G0(:,:,:,90),Q(:,4),wf(:,-3),Q(:,8),G1(:,:,:,173))
  call loop_VVS_S(G1(:,:,:,173),wf(:,-4),wf(:,-1),G1(:,:,:,174))
  call check_last_ST_V(l_switch,G1(:,:,:,174),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,201))
  call loop_VVS_S(G1(:,:,:,173),wf(:,-4),wf(:,0),G1(:,:,:,175))
  call check_last_ST_V(l_switch,G1(:,:,:,175),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,202))
  call loop_UV_W(G1(:,:,:,173),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,85))
  call check_last_VSS_V(l_switch,G2(:,:,:,85),wf(:,-1),wf(:,0),G2tensor(:,203))
  call check_last_VS_V(l_switch,G2(:,:,:,85),wf(:,1),G2tensor(:,204))
  call loop_VV_S(G1(:,:,:,173),wf(:,-4),G1(:,:,:,176))
  call check_last_ST_V(l_switch,G1(:,:,:,176),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,205))
  call loop_VS_V(G1(:,:,:,173),wf(:,-1),G1(:,:,:,177))
  call loop_UV_W(G1(:,:,:,177),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,86))
  call check_last_VS_V(l_switch,G2(:,:,:,86),wf(:,0),G2tensor(:,206))
  call loop_VV_S(G1(:,:,:,177),wf(:,-4),G1(:,:,:,178))
  call check_last_ST_V(l_switch,G1(:,:,:,178),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,207))
  call loop_VT_S(G1(:,:,:,173),Q(:,12),wf(:,-1),Q(:,2),G2(:,:,:,87))
  call loop_TV_S(G2(:,:,:,87),Q(:,14),wf(:,-4),Q(:,16),G3(:,:,:,14))
  call check_last_ST_V(l_switch,G3(:,:,:,14),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,14))
  call loop_SV_V(G2(:,:,:,87),wf(:,-4),G2(:,:,:,88))
  call check_last_VS_V(l_switch,G2(:,:,:,88),wf(:,0),G2tensor(:,208))
  call loop_VV_S(G0(:,:,:,90),wf(:,-3),G0(:,:,:,100))
  call loop_SSV_V(G0(:,:,:,100),wf(:,-1),wf(:,-4),G0(:,:,:,101))
  call check_last_VS_V(l_switch,G0(:,:,:,101),wf(:,0),G0tensor(:,68))
  call loop_SSV_V(G0(:,:,:,100),wf(:,0),wf(:,-4),G0(:,:,:,102))
  call check_last_VS_V(l_switch,G0(:,:,:,102),wf(:,-1),G0tensor(:,69))
  call loop_SV_V(G0(:,:,:,100),wf(:,-4),G0(:,:,:,103))
  call check_last_VSS_V(l_switch,G0(:,:,:,103),wf(:,-1),wf(:,0),G0tensor(:,70))
  call check_last_VS_V(l_switch,G0(:,:,:,103),wf(:,1),G0tensor(:,71))
  call loop_SV_T(G0(:,:,:,100),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,179))
  call check_last_ST_V(l_switch,G1(:,:,:,179),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,209))
  call loop_TV_S(G0(:,:,:,100),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,180))
  call check_last_ST_V(l_switch,G1(:,:,:,180),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,210))
  call loop_SS_S(G0(:,:,:,100),wf(:,-1),G0(:,:,:,104))
  call loop_SV_T(G0(:,:,:,104),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,181))
  call check_last_ST_V(l_switch,G1(:,:,:,181),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,211))
  call loop_TV_S(G0(:,:,:,104),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,182))
  call check_last_ST_V(l_switch,G1(:,:,:,182),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,212))
  call loop_SV_V(G0(:,:,:,104),wf(:,-4),G0(:,:,:,105))
  call check_last_VS_V(l_switch,G0(:,:,:,105),wf(:,0),G0tensor(:,72))
  call loop_ST_V(G0(:,:,:,100),Q(:,12),wf(:,-1),Q(:,2),G1(:,:,:,183))
  call loop_VV_S(G1(:,:,:,183),wf(:,-4),G1(:,:,:,184))
  call check_last_ST_V(l_switch,G1(:,:,:,184),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,213))
  call loop_UW_V(G1(:,:,:,183),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,89))
  call check_last_VS_V(l_switch,G2(:,:,:,89),wf(:,0),G2tensor(:,214))
  call loop_UV_W(G1(:,:,:,183),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,90))
  call check_last_VS_V(l_switch,G2(:,:,:,90),wf(:,0),G2tensor(:,215))
  call loop_VVS_S(G0(:,:,:,90),wf(:,-3),wf(:,-1),G0(:,:,:,106))
  call loop_SV_T(G0(:,:,:,106),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,185))
  call check_last_ST_V(l_switch,G1(:,:,:,185),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,216))
  call loop_TV_S(G0(:,:,:,106),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,186))
  call check_last_ST_V(l_switch,G1(:,:,:,186),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,217))
  call loop_SV_V(G0(:,:,:,106),wf(:,-4),G0(:,:,:,107))
  call check_last_VS_V(l_switch,G0(:,:,:,107),wf(:,0),G0tensor(:,73))
  call loop_UW_V(G0(:,:,:,90),Q(:,4),wf(:,-4),Q(:,16),G1(:,:,:,187))
  call loop_VVS_S(G1(:,:,:,187),wf(:,-3),wf(:,-1),G1(:,:,:,188))
  call check_last_ST_V(l_switch,G1(:,:,:,188),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,218))
  call loop_VVS_S(G1(:,:,:,187),wf(:,-3),wf(:,0),G1(:,:,:,189))
  call check_last_ST_V(l_switch,G1(:,:,:,189),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,219))
  call loop_UW_V(G1(:,:,:,187),Q(:,20),wf(:,-3),Q(:,8),G2(:,:,:,91))
  call check_last_VSS_V(l_switch,G2(:,:,:,91),wf(:,-1),wf(:,0),G2tensor(:,220))
  call check_last_VS_V(l_switch,G2(:,:,:,91),wf(:,1),G2tensor(:,221))
  call loop_VV_S(G1(:,:,:,187),wf(:,-3),G1(:,:,:,190))
  call check_last_ST_V(l_switch,G1(:,:,:,190),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,222))
  call loop_VS_V(G1(:,:,:,187),wf(:,-1),G1(:,:,:,191))
  call loop_UW_V(G1(:,:,:,191),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,92))
  call check_last_VS_V(l_switch,G2(:,:,:,92),wf(:,0),G2tensor(:,223))
  call loop_VV_S(G1(:,:,:,191),wf(:,-3),G1(:,:,:,192))
  call check_last_ST_V(l_switch,G1(:,:,:,192),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,224))
  call loop_VT_S(G1(:,:,:,187),Q(:,20),wf(:,-1),Q(:,2),G2(:,:,:,93))
  call loop_SV_T(G2(:,:,:,93),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,15))
  call check_last_ST_V(l_switch,G3(:,:,:,15),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,15))
  call loop_SV_V(G2(:,:,:,93),wf(:,-3),G2(:,:,:,94))
  call check_last_VS_V(l_switch,G2(:,:,:,94),wf(:,0),G2tensor(:,225))
  call loop_UV_W(G0(:,:,:,90),Q(:,4),wf(:,-4),Q(:,16),G1(:,:,:,193))
  call loop_VVS_S(G1(:,:,:,193),wf(:,-3),wf(:,-1),G1(:,:,:,194))
  call check_last_ST_V(l_switch,G1(:,:,:,194),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,226))
  call loop_VVS_S(G1(:,:,:,193),wf(:,-3),wf(:,0),G1(:,:,:,195))
  call check_last_ST_V(l_switch,G1(:,:,:,195),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,227))
  call loop_UV_W(G1(:,:,:,193),Q(:,20),wf(:,-3),Q(:,8),G2(:,:,:,95))
  call check_last_VSS_V(l_switch,G2(:,:,:,95),wf(:,-1),wf(:,0),G2tensor(:,228))
  call check_last_VS_V(l_switch,G2(:,:,:,95),wf(:,1),G2tensor(:,229))
  call loop_VV_S(G1(:,:,:,193),wf(:,-3),G1(:,:,:,196))
  call check_last_ST_V(l_switch,G1(:,:,:,196),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,230))
  call loop_VS_V(G1(:,:,:,193),wf(:,-1),G1(:,:,:,197))
  call loop_UV_W(G1(:,:,:,197),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,96))
  call check_last_VS_V(l_switch,G2(:,:,:,96),wf(:,0),G2tensor(:,231))
  call loop_VV_S(G1(:,:,:,197),wf(:,-3),G1(:,:,:,198))
  call check_last_ST_V(l_switch,G1(:,:,:,198),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,232))
  call loop_VT_S(G1(:,:,:,193),Q(:,20),wf(:,-1),Q(:,2),G2(:,:,:,97))
  call loop_TV_S(G2(:,:,:,97),Q(:,22),wf(:,-3),Q(:,8),G3(:,:,:,16))
  call check_last_ST_V(l_switch,G3(:,:,:,16),Q(:,30),wf(:,0),Q(:,1),G4tensor(:,16))
  call loop_SV_V(G2(:,:,:,97),wf(:,-3),G2(:,:,:,98))
  call check_last_VS_V(l_switch,G2(:,:,:,98),wf(:,0),G2tensor(:,233))
  call loop_VV_S(G0(:,:,:,90),wf(:,-4),G0(:,:,:,108))
  call loop_SSV_V(G0(:,:,:,108),wf(:,-1),wf(:,-3),G0(:,:,:,109))
  call check_last_VS_V(l_switch,G0(:,:,:,109),wf(:,0),G0tensor(:,74))
  call loop_SSV_V(G0(:,:,:,108),wf(:,0),wf(:,-3),G0(:,:,:,110))
  call check_last_VS_V(l_switch,G0(:,:,:,110),wf(:,-1),G0tensor(:,75))
  call loop_SV_V(G0(:,:,:,108),wf(:,-3),G0(:,:,:,111))
  call check_last_VSS_V(l_switch,G0(:,:,:,111),wf(:,-1),wf(:,0),G0tensor(:,76))
  call check_last_VS_V(l_switch,G0(:,:,:,111),wf(:,1),G0tensor(:,77))
  call loop_SV_T(G0(:,:,:,108),Q(:,20),wf(:,-3),Q(:,8),G1(:,:,:,199))
  call check_last_ST_V(l_switch,G1(:,:,:,199),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,234))
  call loop_TV_S(G0(:,:,:,108),Q(:,20),wf(:,-3),Q(:,8),G1(:,:,:,200))
  call check_last_ST_V(l_switch,G1(:,:,:,200),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,235))
  call loop_SS_S(G0(:,:,:,108),wf(:,-1),G0(:,:,:,112))
  call loop_SV_T(G0(:,:,:,112),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,201))
  call check_last_ST_V(l_switch,G1(:,:,:,201),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,236))
  call loop_TV_S(G0(:,:,:,112),Q(:,22),wf(:,-3),Q(:,8),G1(:,:,:,202))
  call check_last_ST_V(l_switch,G1(:,:,:,202),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,237))
  call loop_SV_V(G0(:,:,:,112),wf(:,-3),G0(:,:,:,113))
  call check_last_VS_V(l_switch,G0(:,:,:,113),wf(:,0),G0tensor(:,78))
  call loop_ST_V(G0(:,:,:,108),Q(:,20),wf(:,-1),Q(:,2),G1(:,:,:,203))
  call loop_VV_S(G1(:,:,:,203),wf(:,-3),G1(:,:,:,204))
  call check_last_ST_V(l_switch,G1(:,:,:,204),Q(:,30),wf(:,0),Q(:,1),G2tensor(:,238))
  call loop_UW_V(G1(:,:,:,203),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,99))
  call check_last_VS_V(l_switch,G2(:,:,:,99),wf(:,0),G2tensor(:,239))
  call loop_UV_W(G1(:,:,:,203),Q(:,22),wf(:,-3),Q(:,8),G2(:,:,:,100))
  call check_last_VS_V(l_switch,G2(:,:,:,100),wf(:,0),G2tensor(:,240))
  call loop_VVS_S(G0(:,:,:,90),wf(:,-4),wf(:,0),G0(:,:,:,114))
  call loop_SV_T(G0(:,:,:,114),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,205))
  call check_last_ST_V(l_switch,G1(:,:,:,205),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,241))
  call loop_TV_S(G0(:,:,:,114),Q(:,21),wf(:,-3),Q(:,8),G1(:,:,:,206))
  call check_last_ST_V(l_switch,G1(:,:,:,206),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,242))
  call loop_SV_V(G0(:,:,:,114),wf(:,-3),G0(:,:,:,115))
  call check_last_VS_V(l_switch,G0(:,:,:,115),wf(:,-1),G0tensor(:,79))
  call loop_VVS_S(G0(:,:,:,90),wf(:,-3),wf(:,0),G0(:,:,:,116))
  call loop_SV_T(G0(:,:,:,116),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,207))
  call check_last_ST_V(l_switch,G1(:,:,:,207),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,243))
  call loop_TV_S(G0(:,:,:,116),Q(:,13),wf(:,-4),Q(:,16),G1(:,:,:,208))
  call check_last_ST_V(l_switch,G1(:,:,:,208),Q(:,29),wf(:,-1),Q(:,2),G2tensor(:,244))
  call loop_SV_V(G0(:,:,:,116),wf(:,-4),G0(:,:,:,117))
  call check_last_VS_V(l_switch,G0(:,:,:,117),wf(:,-1),G0tensor(:,80))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-f(5)) * TI2_call(0,momenta_12,masses2_7,G0tensor(:,1),T2sum(1:1,1))
  M(1) = M(1) + (-f(5)) * TI2_call(0,momenta_12,masses2_7,G0tensor(:,1),T2sum(1:1,1))
  M(1) = M(1) + (-f(33)) * TI2_call(0,momenta_12,masses2_7,G0tensor(:,4),T2sum(1:1,1))
  M(1) = M(1) + (-f(33)) * TI2_call(0,momenta_12,masses2_7,G0tensor(:,4),T2sum(1:1,1))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_25,masses2_7,G0tensor(:,7),T0sum(1:1,1))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_25,masses2_7,G0tensor(:,7),T0sum(1:1,1))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_25,masses2_7,G0tensor(:,12),T0sum(1:1,1))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_25,masses2_7,G0tensor(:,12),T0sum(1:1,1))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_29,masses2_7,G0tensor(:,17),T0sum(1:1,2))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_29,masses2_7,G0tensor(:,17),T0sum(1:1,2))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_29,masses2_7,G0tensor(:,22),T0sum(1:1,2))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_29,masses2_7,G0tensor(:,22),T0sum(1:1,2))
  M(1) = M(1) + (-f(5)) * TI2_call(0,momenta_11,masses2_7,G0tensor(:,27),T2sum(1:1,2))
  M(1) = M(1) + (-f(5)) * TI2_call(0,momenta_11,masses2_7,G0tensor(:,27),T2sum(1:1,2))
  M(1) = M(1) + (-f(33)) * TI2_call(0,momenta_11,masses2_7,G0tensor(:,30),T2sum(1:1,2))
  M(1) = M(1) + (-f(33)) * TI2_call(0,momenta_11,masses2_7,G0tensor(:,30),T2sum(1:1,2))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_22,masses2_7,G0tensor(:,33),T0sum(1:1,3))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_22,masses2_7,G0tensor(:,33),T0sum(1:1,3))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_22,masses2_7,G0tensor(:,38),T0sum(1:1,3))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_22,masses2_7,G0tensor(:,38),T0sum(1:1,3))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_28,masses2_7,G0tensor(:,18),T0sum(1:1,4))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_28,masses2_7,G0tensor(:,18),T0sum(1:1,4))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_28,masses2_7,G0tensor(:,23),T0sum(1:1,4))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_28,masses2_7,G0tensor(:,23),T0sum(1:1,4))
  M(1) = M(1) + (-f(5)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,43),T2sum(1:1,3))
  M(1) = M(1) + (-f(5)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,43),T2sum(1:1,3))
  M(1) = M(1) + (-f(33)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,62),T2sum(1:1,3))
  M(1) = M(1) + (-f(33)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,62),T2sum(1:1,3))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,19),T2sum(1:1,5))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,19),T2sum(1:1,5))
  M(1) = M(1) + (-f(31)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,24),T2sum(1:1,5))
  M(1) = M(1) + (-f(31)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,24),T2sum(1:1,5))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_21,masses2_7,G0tensor(:,34),T0sum(1:1,5))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_21,masses2_7,G0tensor(:,34),T0sum(1:1,5))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_21,masses2_7,G0tensor(:,39),T0sum(1:1,5))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_21,masses2_7,G0tensor(:,39),T0sum(1:1,5))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_24,masses2_7,G0tensor(:,8),T0sum(1:1,6))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_24,masses2_7,G0tensor(:,8),T0sum(1:1,6))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_24,masses2_7,G0tensor(:,13),T0sum(1:1,6))
  M(1) = M(1) + (-f(32)) * TI2_call(0,momenta_24,masses2_7,G0tensor(:,13),T0sum(1:1,6))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,9),T2sum(1:1,7))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,9),T2sum(1:1,7))
  M(1) = M(1) + (-f(31)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,14),T2sum(1:1,7))
  M(1) = M(1) + (-f(31)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,14),T2sum(1:1,7))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,35),T2sum(1:1,9))
  M(1) = M(1) + (-f(16)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,35),T2sum(1:1,9))
  M(1) = M(1) + (-f(31)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,40),T2sum(1:1,9))
  M(1) = M(1) + (-f(31)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,40),T2sum(1:1,9))
  M(2) = M(2) + (-f(13) * den(1)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,44),T2sum(1:1,3))
  M(2) = M(2) + (-f(13) * den(1)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,44),T2sum(1:1,3))
  M(2) = M(2) + (-f(41) * den(1)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,63),T2sum(1:1,3))
  M(2) = M(2) + (-f(41) * den(1)) * TI2_call(0,momenta_10,masses2_7,G0tensor(:,63),T2sum(1:1,3))
  M(2) = M(2) + (f(18) * den(1)) * TI2_call(2,momenta_27,masses2_7,G2tensor(:,46),T2sum(1:15,5))
  M(2) = M(2) + (-f(18) * den(1)) * TI2_call(2,momenta_27,masses2_7,G2tensor(:,47),T2sum(1:15,5))
  M(2) = M(2) + (-f(23) * den(1)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,20),T2sum(1:1,5))
  M(2) = M(2) + (-f(23) * den(1)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,20),T2sum(1:1,5))
  M(2) = M(2) + (-f(39) * den(1)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,25),T2sum(1:1,5))
  M(2) = M(2) + (-f(39) * den(1)) * TI2_call(0,momenta_27,masses2_7,G0tensor(:,25),T2sum(1:1,5))
  M(2) = M(2) + (-f(18) * den(1)) * TI2_call(2,momenta_27,masses2_7,G2tensor(:,39),T2sum(1:15,5))
  M(2) = M(2) + (f(18) * den(1)) * TI2_call(2,momenta_27,masses2_7,G2tensor(:,40),T2sum(1:15,5))
  M(1) = M(1) + (-f(11)) * TI2_call(0,momenta_38,masses2_13,G0tensor(:,45),T2sum(1:1,19))
  M(1) = M(1) + (-f(11)) * TI2_call(0,momenta_38,masses2_13,G0tensor(:,45),T2sum(1:1,19))
  M(1) = M(1) + (-f(49)) * TI2_call(0,momenta_38,masses2_13,G0tensor(:,64),T2sum(1:1,19))
  M(1) = M(1) + (-f(49)) * TI2_call(0,momenta_38,masses2_13,G0tensor(:,64),T2sum(1:1,19))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_38,masses2_13,G2tensor(:,103),T2sum(1:15,19))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_38,masses2_13,G2tensor(:,103),T2sum(1:15,19))
  M(1) = M(1) + (-f(33)) * TI2_call(2,momenta_38,masses2_13,G2tensor(:,180),T2sum(1:15,19))
  M(1) = M(1) + (-f(33)) * TI2_call(2,momenta_38,masses2_13,G2tensor(:,180),T2sum(1:15,19))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,41),T2sum(1:15,25))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,42),T2sum(1:15,25))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,48),T2sum(1:15,25))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,49),T2sum(1:15,25))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_61,masses2_13,G0tensor(:,21),T2sum(1:1,25))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_61,masses2_13,G0tensor(:,21),T2sum(1:1,25))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,50),T2sum(1:15,25))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,50),T2sum(1:15,25))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,43),T2sum(1:15,25))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,43),T2sum(1:15,25))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_61,masses2_13,G0tensor(:,26),T2sum(1:1,25))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_61,masses2_13,G0tensor(:,26),T2sum(1:1,25))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,44),T2sum(1:15,25))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,45),T2sum(1:15,25))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,51),T2sum(1:15,25))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_61,masses2_13,G2tensor(:,52),T2sum(1:15,25))
  M(2) = M(2) + (f(18) * den(2)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,32),T2sum(1:15,7))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,33),T2sum(1:15,7))
  M(2) = M(2) + (-f(23) * den(2)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,10),T2sum(1:1,7))
  M(2) = M(2) + (-f(23) * den(2)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,10),T2sum(1:1,7))
  M(2) = M(2) + (-f(39) * den(2)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,15),T2sum(1:1,7))
  M(2) = M(2) + (-f(39) * den(2)) * TI2_call(0,momenta_23,masses2_7,G0tensor(:,15),T2sum(1:1,7))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,25),T2sum(1:15,7))
  M(2) = M(2) + (f(18) * den(2)) * TI2_call(2,momenta_23,masses2_7,G2tensor(:,26),T2sum(1:15,7))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_48,masses2_13,G0tensor(:,48),T2sum(1:1,26))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_48,masses2_13,G0tensor(:,48),T2sum(1:1,26))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_48,masses2_13,G2tensor(:,114),T2sum(1:15,26))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_48,masses2_13,G2tensor(:,115),T2sum(1:15,26))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_48,masses2_13,G2tensor(:,191),T2sum(1:15,26))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_48,masses2_13,G2tensor(:,192),T2sum(1:15,26))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_48,masses2_13,G0tensor(:,67),T2sum(1:1,26))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_48,masses2_13,G0tensor(:,67),T2sum(1:1,26))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_41,masses2_13,G0tensor(:,49),T2sum(1:1,27))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_41,masses2_13,G0tensor(:,49),T2sum(1:1,27))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_41,masses2_13,G2tensor(:,123),T2sum(1:15,27))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_41,masses2_13,G2tensor(:,131),T2sum(1:15,27))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_41,masses2_13,G2tensor(:,193),T2sum(1:15,27))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_41,masses2_13,G2tensor(:,201),T2sum(1:15,27))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_41,masses2_13,G0tensor(:,68),T2sum(1:1,27))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_41,masses2_13,G0tensor(:,68),T2sum(1:1,27))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_43,masses2_13,G0tensor(:,54),T2sum(1:1,29))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_43,masses2_13,G0tensor(:,54),T2sum(1:1,29))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_43,masses2_13,G2tensor(:,139),T2sum(1:15,29))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_43,masses2_13,G2tensor(:,140),T2sum(1:15,29))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_43,masses2_13,G2tensor(:,216),T2sum(1:15,29))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_43,masses2_13,G2tensor(:,217),T2sum(1:15,29))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_43,masses2_13,G0tensor(:,73),T2sum(1:1,29))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_43,masses2_13,G0tensor(:,73),T2sum(1:1,29))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_46,masses2_13,G0tensor(:,55),T2sum(1:1,30))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_46,masses2_13,G0tensor(:,55),T2sum(1:1,30))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_46,masses2_13,G2tensor(:,148),T2sum(1:15,30))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_46,masses2_13,G2tensor(:,156),T2sum(1:15,30))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_46,masses2_13,G2tensor(:,218),T2sum(1:15,30))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_46,masses2_13,G2tensor(:,226),T2sum(1:15,30))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_46,masses2_13,G0tensor(:,74),T2sum(1:1,30))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_46,masses2_13,G0tensor(:,74),T2sum(1:1,30))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,27),T2sum(1:15,31))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,28),T2sum(1:15,31))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,34),T2sum(1:15,31))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,35),T2sum(1:15,31))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_60,masses2_13,G0tensor(:,11),T2sum(1:1,31))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_60,masses2_13,G0tensor(:,11),T2sum(1:1,31))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,36),T2sum(1:15,31))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,36),T2sum(1:15,31))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,29),T2sum(1:15,31))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,29),T2sum(1:15,31))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_60,masses2_13,G0tensor(:,16),T2sum(1:1,31))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_60,masses2_13,G0tensor(:,16),T2sum(1:1,31))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,30),T2sum(1:15,31))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,31),T2sum(1:15,31))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,37),T2sum(1:15,31))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_60,masses2_13,G2tensor(:,38),T2sum(1:15,31))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,1),T4sum(1:15,2))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,3),T4sum(1:15,2))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,13),T4sum(1:15,2))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,15),T4sum(1:15,2))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_52,masses2_13,G0tensor(:,2),T4sum(1:1,2))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_52,masses2_13,G0tensor(:,2),T4sum(1:1,2))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,2),T4sum(1:15,2))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,4),T4sum(1:15,2))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,17),T4sum(1:15,2))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,18),T4sum(1:15,2))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,5),T4sum(1:15,2))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,6),T4sum(1:15,2))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,14),T4sum(1:15,2))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_52,masses2_13,G2tensor(:,16),T4sum(1:15,2))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_52,masses2_13,G0tensor(:,5),T4sum(1:1,2))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_52,masses2_13,G0tensor(:,5),T4sum(1:1,2))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,7),T4sum(1:15,3))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,9),T4sum(1:15,3))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,19),T4sum(1:15,3))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,21),T4sum(1:15,3))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_51,masses2_13,G0tensor(:,3),T4sum(1:1,3))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_51,masses2_13,G0tensor(:,3),T4sum(1:1,3))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,8),T4sum(1:15,3))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,10),T4sum(1:15,3))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,23),T4sum(1:15,3))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,24),T4sum(1:15,3))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,11),T4sum(1:15,3))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,12),T4sum(1:15,3))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,20),T4sum(1:15,3))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_51,masses2_13,G2tensor(:,22),T4sum(1:15,3))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_51,masses2_13,G0tensor(:,6),T4sum(1:1,3))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_51,masses2_13,G0tensor(:,6),T4sum(1:1,3))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,84),T2sum(1:15,9))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,85),T2sum(1:15,9))
  M(2) = M(2) + (-f(23) * den(4)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,36),T2sum(1:1,9))
  M(2) = M(2) + (-f(23) * den(4)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,36),T2sum(1:1,9))
  M(2) = M(2) + (-f(39) * den(4)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,41),T2sum(1:1,9))
  M(2) = M(2) + (-f(39) * den(4)) * TI2_call(0,momenta_20,masses2_7,G0tensor(:,41),T2sum(1:1,9))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,77),T2sum(1:15,9))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(2,momenta_20,masses2_7,G2tensor(:,78),T2sum(1:15,9))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_47,masses2_13,G0tensor(:,60),T2sum(1:1,32))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_47,masses2_13,G0tensor(:,60),T2sum(1:1,32))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_47,masses2_13,G2tensor(:,164),T2sum(1:15,32))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_47,masses2_13,G2tensor(:,165),T2sum(1:15,32))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_47,masses2_13,G2tensor(:,241),T2sum(1:15,32))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_47,masses2_13,G2tensor(:,242),T2sum(1:15,32))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_47,masses2_13,G0tensor(:,79),T2sum(1:1,32))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_47,masses2_13,G0tensor(:,79),T2sum(1:1,32))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_40,masses2_13,G0tensor(:,50),T2sum(1:1,33))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_40,masses2_13,G0tensor(:,50),T2sum(1:1,33))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_40,masses2_13,G2tensor(:,124),T2sum(1:15,33))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_40,masses2_13,G2tensor(:,132),T2sum(1:15,33))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_40,masses2_13,G2tensor(:,194),T2sum(1:15,33))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_40,masses2_13,G2tensor(:,202),T2sum(1:15,33))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_40,masses2_13,G0tensor(:,69),T2sum(1:1,33))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_40,masses2_13,G0tensor(:,69),T2sum(1:1,33))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_42,masses2_13,G0tensor(:,61),T2sum(1:1,35))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_42,masses2_13,G0tensor(:,61),T2sum(1:1,35))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_42,masses2_13,G2tensor(:,166),T2sum(1:15,35))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_42,masses2_13,G2tensor(:,167),T2sum(1:15,35))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_42,masses2_13,G2tensor(:,243),T2sum(1:15,35))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_42,masses2_13,G2tensor(:,244),T2sum(1:15,35))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_42,masses2_13,G0tensor(:,80),T2sum(1:1,35))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_42,masses2_13,G0tensor(:,80),T2sum(1:1,35))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_45,masses2_13,G0tensor(:,56),T2sum(1:1,36))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_45,masses2_13,G0tensor(:,56),T2sum(1:1,36))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_45,masses2_13,G2tensor(:,149),T2sum(1:15,36))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_45,masses2_13,G2tensor(:,157),T2sum(1:15,36))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_45,masses2_13,G2tensor(:,219),T2sum(1:15,36))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_45,masses2_13,G2tensor(:,227),T2sum(1:15,36))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_45,masses2_13,G0tensor(:,75),T2sum(1:1,36))
  M(1) = M(1) + (-f(48)) * TI2_call(0,momenta_45,masses2_13,G0tensor(:,75),T2sum(1:1,36))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,79),T2sum(1:15,37))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,80),T2sum(1:15,37))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,86),T2sum(1:15,37))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,87),T2sum(1:15,37))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_59,masses2_13,G0tensor(:,37),T2sum(1:1,37))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_59,masses2_13,G0tensor(:,37),T2sum(1:1,37))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,88),T2sum(1:15,37))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,88),T2sum(1:15,37))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,81),T2sum(1:15,37))
  M(1) = M(1) + (f(30)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,81),T2sum(1:15,37))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_59,masses2_13,G0tensor(:,42),T2sum(1:1,37))
  M(1) = M(1) + (-f(38)) * TI2_call(0,momenta_59,masses2_13,G0tensor(:,42),T2sum(1:1,37))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,82),T2sum(1:15,37))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,83),T2sum(1:15,37))
  M(1) = M(1) + (-f(32)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,89),T2sum(1:15,37))
  M(1) = M(1) + (f(32)) * TI2_call(2,momenta_59,masses2_13,G2tensor(:,90),T2sum(1:15,37))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,53),T4sum(1:15,5))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,55),T4sum(1:15,5))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,65),T4sum(1:15,5))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,67),T4sum(1:15,5))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_50,masses2_13,G0tensor(:,28),T4sum(1:1,5))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_50,masses2_13,G0tensor(:,28),T4sum(1:1,5))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,54),T4sum(1:15,5))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,56),T4sum(1:15,5))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,69),T4sum(1:15,5))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,70),T4sum(1:15,5))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,57),T4sum(1:15,5))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,58),T4sum(1:15,5))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,66),T4sum(1:15,5))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_50,masses2_13,G2tensor(:,68),T4sum(1:15,5))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_50,masses2_13,G0tensor(:,31),T4sum(1:1,5))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_50,masses2_13,G0tensor(:,31),T4sum(1:1,5))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,59),T4sum(1:15,6))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,61),T4sum(1:15,6))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,71),T4sum(1:15,6))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,73),T4sum(1:15,6))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_49,masses2_13,G0tensor(:,29),T4sum(1:1,6))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_49,masses2_13,G0tensor(:,29),T4sum(1:1,6))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,60),T4sum(1:15,6))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,62),T4sum(1:15,6))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,75),T4sum(1:15,6))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,76),T4sum(1:15,6))
  M(1) = M(1) + (f(16)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,63),T4sum(1:15,6))
  M(1) = M(1) + (-f(16)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,64),T4sum(1:15,6))
  M(1) = M(1) + (-f(31)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,72),T4sum(1:15,6))
  M(1) = M(1) + (f(31)) * TI2_call(2,momenta_49,masses2_13,G2tensor(:,74),T4sum(1:15,6))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_49,masses2_13,G0tensor(:,32),T4sum(1:1,6))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_49,masses2_13,G0tensor(:,32),T4sum(1:1,6))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,125),T4sum(1:15,8))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,133),T4sum(1:15,8))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,195),T4sum(1:15,8))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,203),T4sum(1:15,8))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,51),T4sum(1:1,8))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,51),T4sum(1:1,8))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,70),T4sum(1:1,8))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,70),T4sum(1:1,8))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,150),T4sum(1:15,9))
  M(1) = M(1) + (f(4)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,158),T4sum(1:15,9))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,220),T4sum(1:15,9))
  M(1) = M(1) + (f(33)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,228),T4sum(1:15,9))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,57),T4sum(1:1,9))
  M(1) = M(1) + (-f(22)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,57),T4sum(1:1,9))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,76),T4sum(1:1,9))
  M(1) = M(1) + (-f(47)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,76),T4sum(1:1,9))
  M(2) = M(2) + (f(12) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,126),T4sum(1:15,8))
  M(2) = M(2) + (f(12) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,134),T4sum(1:15,8))
  M(2) = M(2) + (f(41) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,196),T4sum(1:15,8))
  M(2) = M(2) + (f(41) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,204),T4sum(1:15,8))
  M(2) = M(2) + (-f(23) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,127),T4sum(1:15,8))
  M(2) = M(2) + (f(23) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,135),T4sum(1:15,8))
  M(2) = M(2) + (-f(28) * den(1)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,52),T4sum(1:1,8))
  M(2) = M(2) + (-f(28) * den(1)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,52),T4sum(1:1,8))
  M(2) = M(2) + (-f(23) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,116),T4sum(1:15,8))
  M(2) = M(2) + (f(23) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,117),T4sum(1:15,8))
  M(2) = M(2) + (f(39) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,209),T4sum(1:15,8))
  M(2) = M(2) + (-f(39) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,210),T4sum(1:15,8))
  M(2) = M(2) + (-f(51) * den(1)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,71),T4sum(1:1,8))
  M(2) = M(2) + (-f(51) * den(1)) * TI2_call(0,momenta_39,masses2_13,G0tensor(:,71),T4sum(1:1,8))
  M(2) = M(2) + (f(39) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,197),T4sum(1:15,8))
  M(2) = M(2) + (-f(39) * den(1)) * TI2_call(2,momenta_39,masses2_13,G2tensor(:,205),T4sum(1:15,8))
  M(2) = M(2) + (f(12) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,151),T4sum(1:15,9))
  M(2) = M(2) + (f(12) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,159),T4sum(1:15,9))
  M(2) = M(2) + (f(41) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,221),T4sum(1:15,9))
  M(2) = M(2) + (f(41) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,229),T4sum(1:15,9))
  M(2) = M(2) + (-f(23) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,152),T4sum(1:15,9))
  M(2) = M(2) + (f(23) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,160),T4sum(1:15,9))
  M(2) = M(2) + (-f(28) * den(1)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,58),T4sum(1:1,9))
  M(2) = M(2) + (-f(28) * den(1)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,58),T4sum(1:1,9))
  M(2) = M(2) + (-f(23) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,141),T4sum(1:15,9))
  M(2) = M(2) + (f(23) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,142),T4sum(1:15,9))
  M(2) = M(2) + (f(39) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,234),T4sum(1:15,9))
  M(2) = M(2) + (-f(39) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,235),T4sum(1:15,9))
  M(2) = M(2) + (-f(51) * den(1)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,77),T4sum(1:1,9))
  M(2) = M(2) + (-f(51) * den(1)) * TI2_call(0,momenta_44,masses2_13,G0tensor(:,77),T4sum(1:1,9))
  M(2) = M(2) + (f(39) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,222),T4sum(1:15,9))
  M(2) = M(2) + (-f(39) * den(1)) * TI2_call(2,momenta_44,masses2_13,G2tensor(:,230),T4sum(1:15,9))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,91),T4sum(1:15,61))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,93),T4sum(1:15,61))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,168),T4sum(1:15,61))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,170),T4sum(1:15,61))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_69,masses2_19,G0tensor(:,46),T4sum(1:1,61))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_69,masses2_19,G0tensor(:,46),T4sum(1:1,61))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,104),T4sum(1:15,61))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,105),T4sum(1:15,61))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,92),T4sum(1:15,61))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,94),T4sum(1:15,61))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,107),T4sum(1:15,61))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,108),T4sum(1:15,61))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,95),T4sum(1:15,61))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,96),T4sum(1:15,61))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,106),T4sum(1:15,61))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,106),T4sum(1:15,61))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_69,masses2_19,G4tensor(:,9),T4sum(1:70,61))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_69,masses2_19,G4tensor(:,10),T4sum(1:70,61))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_69,masses2_19,G4tensor(:,1),T4sum(1:70,61))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_69,masses2_19,G4tensor(:,2),T4sum(1:70,61))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,183),T4sum(1:15,61))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,183),T4sum(1:15,61))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,172),T4sum(1:15,61))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,173),T4sum(1:15,61))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,181),T4sum(1:15,61))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,182),T4sum(1:15,61))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,169),T4sum(1:15,61))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,171),T4sum(1:15,61))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,184),T4sum(1:15,61))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_69,masses2_19,G2tensor(:,185),T4sum(1:15,61))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_69,masses2_19,G0tensor(:,65),T4sum(1:1,61))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_69,masses2_19,G0tensor(:,65),T4sum(1:1,61))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,153),T4sum(1:15,62))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,161),T4sum(1:15,62))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,223),T4sum(1:15,62))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,231),T4sum(1:15,62))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,143),T4sum(1:15,62))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,144),T4sum(1:15,62))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,155),T4sum(1:15,62))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,163),T4sum(1:15,62))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,154),T4sum(1:15,62))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,162),T4sum(1:15,62))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_71,masses2_19,G0tensor(:,59),T4sum(1:1,62))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_71,masses2_19,G0tensor(:,59),T4sum(1:1,62))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,145),T4sum(1:15,62))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,145),T4sum(1:15,62))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_71,masses2_19,G4tensor(:,7),T4sum(1:70,62))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_71,masses2_19,G4tensor(:,8),T4sum(1:70,62))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,236),T4sum(1:15,62))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,237),T4sum(1:15,62))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,146),T4sum(1:15,62))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,147),T4sum(1:15,62))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_71,masses2_19,G4tensor(:,15),T4sum(1:70,62))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_71,masses2_19,G4tensor(:,16),T4sum(1:70,62))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,238),T4sum(1:15,62))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,238),T4sum(1:15,62))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_71,masses2_19,G0tensor(:,78),T4sum(1:1,62))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_71,masses2_19,G0tensor(:,78),T4sum(1:1,62))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,224),T4sum(1:15,62))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,232),T4sum(1:15,62))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,225),T4sum(1:15,62))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,233),T4sum(1:15,62))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,239),T4sum(1:15,62))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_71,masses2_19,G2tensor(:,240),T4sum(1:15,62))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,97),T4sum(1:15,63))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,99),T4sum(1:15,63))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,174),T4sum(1:15,63))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,176),T4sum(1:15,63))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_68,masses2_19,G0tensor(:,47),T4sum(1:1,63))
  M(1) = M(1) + (-f(27)) * TI2_call(0,momenta_68,masses2_19,G0tensor(:,47),T4sum(1:1,63))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,109),T4sum(1:15,63))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,110),T4sum(1:15,63))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,98),T4sum(1:15,63))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,100),T4sum(1:15,63))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,112),T4sum(1:15,63))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,113),T4sum(1:15,63))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,101),T4sum(1:15,63))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,102),T4sum(1:15,63))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,111),T4sum(1:15,63))
  M(1) = M(1) + (-f(34)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,111),T4sum(1:15,63))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_68,masses2_19,G4tensor(:,11),T4sum(1:70,63))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_68,masses2_19,G4tensor(:,12),T4sum(1:70,63))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_68,masses2_19,G4tensor(:,3),T4sum(1:70,63))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_68,masses2_19,G4tensor(:,4),T4sum(1:70,63))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,188),T4sum(1:15,63))
  M(1) = M(1) + (-f(46)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,188),T4sum(1:15,63))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,178),T4sum(1:15,63))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,179),T4sum(1:15,63))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,186),T4sum(1:15,63))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,187),T4sum(1:15,63))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,175),T4sum(1:15,63))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,177),T4sum(1:15,63))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,189),T4sum(1:15,63))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_68,masses2_19,G2tensor(:,190),T4sum(1:15,63))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_68,masses2_19,G0tensor(:,66),T4sum(1:1,63))
  M(1) = M(1) + (-f(52)) * TI2_call(0,momenta_68,masses2_19,G0tensor(:,66),T4sum(1:1,63))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,128),T4sum(1:15,64))
  M(1) = M(1) + (f(10)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,136),T4sum(1:15,64))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,198),T4sum(1:15,64))
  M(1) = M(1) + (f(49)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,206),T4sum(1:15,64))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,130),T4sum(1:15,64))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,138),T4sum(1:15,64))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,118),T4sum(1:15,64))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,119),T4sum(1:15,64))
  M(1) = M(1) + (-f(22)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,129),T4sum(1:15,64))
  M(1) = M(1) + (f(22)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,137),T4sum(1:15,64))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_70,masses2_19,G0tensor(:,53),T4sum(1:1,64))
  M(1) = M(1) + (-f(42)) * TI2_call(0,momenta_70,masses2_19,G0tensor(:,53),T4sum(1:1,64))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_70,masses2_19,G4tensor(:,5),T4sum(1:70,64))
  M(1) = M(1) + (f(16)) * TI2_call(4,momenta_70,masses2_19,G4tensor(:,6),T4sum(1:70,64))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,120),T4sum(1:15,64))
  M(1) = M(1) + (f(34)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,120),T4sum(1:15,64))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,211),T4sum(1:15,64))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,212),T4sum(1:15,64))
  M(1) = M(1) + (-f(38)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,121),T4sum(1:15,64))
  M(1) = M(1) + (f(38)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,122),T4sum(1:15,64))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,213),T4sum(1:15,64))
  M(1) = M(1) + (f(46)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,213),T4sum(1:15,64))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_70,masses2_19,G4tensor(:,13),T4sum(1:70,64))
  M(1) = M(1) + (f(32)) * TI2_call(4,momenta_70,masses2_19,G4tensor(:,14),T4sum(1:70,64))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_70,masses2_19,G0tensor(:,72),T4sum(1:1,64))
  M(1) = M(1) + (-f(50)) * TI2_call(0,momenta_70,masses2_19,G0tensor(:,72),T4sum(1:1,64))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,199),T4sum(1:15,64))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,207),T4sum(1:15,64))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,214),T4sum(1:15,64))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,215),T4sum(1:15,64))
  M(1) = M(1) + (-f(48)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,200),T4sum(1:15,64))
  M(1) = M(1) + (f(48)) * TI2_call(2,momenta_70,masses2_19,G2tensor(:,208),T4sum(1:15,64))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G0tensorhel)
  deallocate(G2tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_aahhh2_hhhaa_2_/**/REALKIND
