
module ol_vamp_1_ppwwj_ddxwwxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwwj_ddxwwxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwwj_ddxwwxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppwwj_ddxwwxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppwwj_ddxwwxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,42) :: G0
  complex(REALKIND), dimension(4,5,4,105) :: G1
  complex(REALKIND), dimension(4,15,4,111) :: G2
  complex(REALKIND), dimension(4,35,4,46) :: G3
  complex(REALKIND), dimension(4,70,4,4) :: G4
  complex(REALKIND), dimension(5,10) :: G1tensor
  complex(REALKIND), dimension(15,24) :: G2tensor
  complex(REALKIND), dimension(35,32) :: G3tensor
  complex(REALKIND), dimension(70,16) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AS_Q(G0(:,:,:,1),wf(:,20),G0(:,:,:,2),gH)
  call loop_A_Q(G0(:,:,:,2),Q(:,12),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),MT,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,18),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),MT,G3tensor(:,1))
  call loop_QS_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,3),gH)
  call loop_Q_A(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,28),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,18),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,31),MT,G3tensor(:,2))
  call loop_AS_Q(G0(:,:,:,1),wf(:,20),G0(:,:,:,4),gH)
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MB,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,28),MB,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,18),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),MB,G3tensor(:,3))
  call loop_QS_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,5),gH)
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MB,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,18),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),MB,G3tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,12),ZERO,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,28),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,18),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,31),ZERO,G3tensor(:,5))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,12),MT,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,28),MT,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,18),G2(:,:,:,12))
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,31),MT,G3tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-4),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,28),ZERO,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,18),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,31),ZERO,G3tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,28),MT,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,18),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,31),MT,G3tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,12),MB,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-4),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,28),MB,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,18),G2(:,:,:,18))
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,31),MB,G3tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MB,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,28),MB,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,18),G2(:,:,:,20))
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,31),MB,G3tensor(:,10))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,12),gZu)
  call loop_A_Q(G0(:,:,:,12),Q(:,12),ZERO,G1(:,:,:,21))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,28),ZERO,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,18),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,31),ZERO,G3tensor(:,11))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,13),gZu)
  call loop_A_Q(G0(:,:,:,13),Q(:,12),MT,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,28),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,18),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,31),MT,G3tensor(:,12))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,14),gZu)
  call loop_Q_A(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,-4),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,28),ZERO,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,18),G2(:,:,:,26))
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,31),ZERO,G3tensor(:,13))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,15),gZu)
  call loop_Q_A(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,-4),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,28),MT,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,18),G2(:,:,:,28))
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,31),MT,G3tensor(:,14))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,16),gZd)
  call loop_A_Q(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-4),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,28),ZERO,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,18),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,31),ZERO,G3tensor(:,15))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,17),gZd)
  call loop_A_Q(G0(:,:,:,17),Q(:,12),MB,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,28),MB,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,18),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,31),MB,G3tensor(:,16))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,18),gZd)
  call loop_Q_A(G0(:,:,:,18),Q(:,12),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,-4),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,28),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,18),G2(:,:,:,34))
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,31),ZERO,G3tensor(:,17))
  call loop_QZ_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,19),gZd)
  call loop_Q_A(G0(:,:,:,19),Q(:,12),MB,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,28),MB,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,18),G2(:,:,:,36))
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,31),MB,G3tensor(:,18))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,8),ZERO,G1(:,:,:,37))
  call loop_AW_Q(G1(:,:,:,37),wf(:,-2),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,12),ZERO,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,18),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,8),MB,G1(:,:,:,39))
  call loop_AW_Q(G1(:,:,:,39),wf(:,-2),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,12),MT,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,28),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,18),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,31),MT,G4tensor(:,2))
  call loop_QW_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,8),ZERO,G1(:,:,:,41))
  call loop_QW_A(G1(:,:,:,41),wf(:,-2),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,12),ZERO,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,-4),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,28),ZERO,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,18),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,31),ZERO,G4tensor(:,3))
  call loop_QW_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,8),MT,G1(:,:,:,43))
  call loop_QW_A(G1(:,:,:,43),wf(:,-2),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,12),MB,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-4),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,28),MB,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,18),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,31),MB,G4tensor(:,4))
  call loop_QW_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,4),ZERO,G1(:,:,:,45))
  call loop_QW_A(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,12),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,28),ZERO,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,18),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,31),ZERO,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,45),wf(:,-4),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,20),ZERO,G2(:,:,:,47))
  call loop_QW_A(G2(:,:,:,47),wf(:,-3),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,28),ZERO,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,18),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,31),ZERO,G4tensor(:,6))
  call loop_QW_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,4),MB,G1(:,:,:,48))
  call loop_QW_A(G1(:,:,:,48),wf(:,-3),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,12),MT,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,28),MT,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,18),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,31),MT,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,48),wf(:,-4),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,20),MB,G2(:,:,:,51))
  call loop_QW_A(G2(:,:,:,51),wf(:,-3),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,28),MT,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,18),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,31),MT,G4tensor(:,8))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,4),ZERO,G1(:,:,:,51))
  call loop_AW_Q(G1(:,:,:,51),wf(:,-3),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,12),ZERO,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,28),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,18),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,31),ZERO,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-4),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,20),ZERO,G2(:,:,:,55))
  call loop_AW_Q(G2(:,:,:,55),wf(:,-3),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,28),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,18),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,31),ZERO,G4tensor(:,10))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,4),MT,G1(:,:,:,54))
  call loop_AW_Q(G1(:,:,:,54),wf(:,-3),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,12),MB,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,28),MB,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,18),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,31),MB,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,54),wf(:,-4),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,20),MT,G2(:,:,:,59))
  call loop_AW_Q(G2(:,:,:,59),wf(:,-3),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,28),MB,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,18),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,31),MB,G4tensor(:,12))
  call loop_VQ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,9),ZERO,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,-4),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,25),ZERO,G2(:,:,:,61))
  call check_last_QA_V(l_switch,G2(:,:,:,61),wf(:,4),G2tensor(:,1))
  call loop_QW_A(G2(:,:,:,61),wf(:,-2),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,29),ZERO,G3(:,:,:,25))
  call check_last_QA_V(l_switch,G3(:,:,:,25),wf(:,-1),G3tensor(:,19))
  call loop_QW_A(G1(:,:,:,57),wf(:,-2),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,13),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,29),ZERO,G3(:,:,:,26))
  call check_last_QA_V(l_switch,G3(:,:,:,26),wf(:,-1),G3tensor(:,20))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,60))
  call loop_VQ_A(G1(:,:,:,60),wf(:,3),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,25),ZERO,G2(:,:,:,65))
  call check_last_QA_V(l_switch,G2(:,:,:,65),wf(:,4),G2tensor(:,2))
  call loop_QW_A(G2(:,:,:,65),wf(:,-2),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,29),ZERO,G3(:,:,:,27))
  call check_last_QA_V(l_switch,G3(:,:,:,27),wf(:,-1),G3tensor(:,21))
  call loop_VA_Q(G1(:,:,:,60),wf(:,52),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,30),ZERO,G2(:,:,:,67))
  call check_last_AQ_V(l_switch,G2(:,:,:,67),wf(:,0),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,60),wf(:,4),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,22),ZERO,G2(:,:,:,68))
  call loop_AW_Q(G2(:,:,:,68),wf(:,-3),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,30),ZERO,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,22))
  call loop_VQ_A(G1(:,:,:,60),wf(:,57),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,29),ZERO,G2(:,:,:,70))
  call check_last_QA_V(l_switch,G2(:,:,:,70),wf(:,-1),G2tensor(:,4))
  call loop_VQ_A(G1(:,:,:,60),wf(:,63),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,29),ZERO,G2(:,:,:,71))
  call check_last_QA_V(l_switch,G2(:,:,:,71),wf(:,-1),G2tensor(:,5))
  call loop_VQ_A(G1(:,:,:,60),wf(:,65),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,29),ZERO,G2(:,:,:,72))
  call check_last_QA_V(l_switch,G2(:,:,:,72),wf(:,-1),G2tensor(:,6))
  call loop_VA_Q(G1(:,:,:,60),wf(:,59),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,30),ZERO,G2(:,:,:,73))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,0),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,60),wf(:,61),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,30),ZERO,G2(:,:,:,74))
  call check_last_AQ_V(l_switch,G2(:,:,:,74),wf(:,0),G2tensor(:,8))
  call loop_VA_Q(G1(:,:,:,60),wf(:,-1),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,18),ZERO,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,12),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,30),ZERO,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,75),wf(:,14),G2(:,:,:,77),gZd)
  call loop_A_Q(G2(:,:,:,77),Q(:,30),ZERO,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,0),G3tensor(:,24))
  call loop_AW_Q(G2(:,:,:,75),wf(:,-2),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,22),ZERO,G3(:,:,:,31))
  call loop_AW_Q(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call loop_A_Q(G3(:,:,:,32),Q(:,30),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,13))
  call loop_VQ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,17),ZERO,G1(:,:,:,70))
  call loop_QW_A(G1(:,:,:,70),wf(:,-3),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,25),ZERO,G2(:,:,:,79))
  call check_last_QA_V(l_switch,G2(:,:,:,79),wf(:,4),G2tensor(:,9))
  call loop_QW_A(G2(:,:,:,79),wf(:,-2),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,29),ZERO,G3(:,:,:,33))
  call check_last_QA_V(l_switch,G3(:,:,:,33),wf(:,-1),G3tensor(:,25))
  call loop_QV_A(G1(:,:,:,70),wf(:,12),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,29),ZERO,G2(:,:,:,81))
  call check_last_QA_V(l_switch,G2(:,:,:,81),wf(:,-1),G2tensor(:,10))
  call loop_QZ_A(G1(:,:,:,70),wf(:,14),G1(:,:,:,73),gZd)
  call loop_Q_A(G1(:,:,:,73),Q(:,29),ZERO,G2(:,:,:,82))
  call check_last_QA_V(l_switch,G2(:,:,:,82),wf(:,-1),G2tensor(:,11))
  call check_last_QA_V(l_switch,G1(:,:,:,70),wf(:,52),G1tensor(:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,70),wf(:,59),G1tensor(:,2))
  call check_last_QA_V(l_switch,G1(:,:,:,70),wf(:,61),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,14),ZERO,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-4),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,30),ZERO,G2(:,:,:,83))
  call check_last_AQ_V(l_switch,G2(:,:,:,83),wf(:,0),G2tensor(:,12))
  call loop_VA_Q(G0(:,:,:,1),wf(:,47),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,22),ZERO,G1(:,:,:,76))
  call loop_AW_Q(G1(:,:,:,76),wf(:,-3),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,30),ZERO,G2(:,:,:,84))
  call check_last_AQ_V(l_switch,G2(:,:,:,84),wf(:,0),G2tensor(:,13))
  call check_last_AQ_V(l_switch,G1(:,:,:,76),wf(:,3),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,6),ZERO,G1(:,:,:,78))
  call loop_AV_Q(G1(:,:,:,78),wf(:,-4),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,22),ZERO,G2(:,:,:,85))
  call loop_AW_Q(G2(:,:,:,85),wf(:,-3),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,30),ZERO,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,0),G3tensor(:,26))
  call loop_AW_Q(G1(:,:,:,78),wf(:,-3),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,14),ZERO,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-4),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,30),ZERO,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,0),G3tensor(:,27))
  call loop_VA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,18),ZERO,G1(:,:,:,81))
  call loop_AW_Q(G1(:,:,:,81),wf(:,-2),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,22),ZERO,G2(:,:,:,89))
  call check_last_AQ_V(l_switch,G2(:,:,:,89),wf(:,3),G2tensor(:,14))
  call loop_AW_Q(G2(:,:,:,89),wf(:,-3),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,30),ZERO,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,0),G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,81),wf(:,12),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,30),ZERO,G2(:,:,:,91))
  call check_last_AQ_V(l_switch,G2(:,:,:,91),wf(:,0),G2tensor(:,15))
  call loop_AZ_Q(G1(:,:,:,81),wf(:,14),G1(:,:,:,84),gZd)
  call loop_A_Q(G1(:,:,:,84),Q(:,30),ZERO,G2(:,:,:,92))
  call check_last_AQ_V(l_switch,G2(:,:,:,92),wf(:,0),G2tensor(:,16))
  call check_last_AQ_V(l_switch,G1(:,:,:,81),wf(:,57),G1tensor(:,5))
  call check_last_AQ_V(l_switch,G1(:,:,:,81),wf(:,63),G1tensor(:,6))
  call check_last_AQ_V(l_switch,G1(:,:,:,81),wf(:,65),G1tensor(:,7))
  call loop_VQ_A(G0(:,:,:,1),wf(:,57),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,13),ZERO,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,-4),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,29),ZERO,G2(:,:,:,93))
  call check_last_QA_V(l_switch,G2(:,:,:,93),wf(:,-1),G2tensor(:,17))
  call loop_VQ_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,25),ZERO,G1(:,:,:,87))
  call loop_QW_A(G1(:,:,:,87),wf(:,-2),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,29),ZERO,G2(:,:,:,94))
  call check_last_QA_V(l_switch,G2(:,:,:,94),wf(:,-1),G2tensor(:,18))
  call check_last_QA_V(l_switch,G1(:,:,:,87),wf(:,4),G1tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,63),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,13),ZERO,G1(:,:,:,89))
  call loop_QV_A(G1(:,:,:,89),wf(:,-4),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,29),ZERO,G2(:,:,:,95))
  call check_last_QA_V(l_switch,G2(:,:,:,95),wf(:,-1),G2tensor(:,19))
  call loop_VQ_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,13),ZERO,G1(:,:,:,91))
  call loop_QV_A(G1(:,:,:,91),wf(:,-4),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,29),ZERO,G2(:,:,:,96))
  call check_last_QA_V(l_switch,G2(:,:,:,96),wf(:,-1),G2tensor(:,20))
  call loop_VA_Q(G0(:,:,:,1),wf(:,59),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,14),ZERO,G1(:,:,:,93))
  call loop_AV_Q(G1(:,:,:,93),wf(:,-4),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,30),ZERO,G2(:,:,:,97))
  call check_last_AQ_V(l_switch,G2(:,:,:,97),wf(:,0),G2tensor(:,21))
  call loop_VA_Q(G0(:,:,:,1),wf(:,61),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,14),ZERO,G1(:,:,:,95))
  call loop_AV_Q(G1(:,:,:,95),wf(:,-4),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,30),ZERO,G2(:,:,:,98))
  call check_last_AQ_V(l_switch,G2(:,:,:,98),wf(:,0),G2tensor(:,22))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,2),ZERO,G1(:,:,:,97))
  call loop_AV_Q(G1(:,:,:,97),wf(:,12),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,14),ZERO,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-4),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,30),ZERO,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,0),G3tensor(:,29))
  call loop_AZ_Q(G1(:,:,:,97),wf(:,14),G1(:,:,:,99),gZd)
  call loop_A_Q(G1(:,:,:,99),Q(:,14),ZERO,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-4),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,30),ZERO,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,0),G3tensor(:,30))
  call loop_AV_Q(G1(:,:,:,97),wf(:,-4),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,18),ZERO,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,12),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,30),ZERO,G3(:,:,:,39))
  call check_last_AQ_V(l_switch,G3(:,:,:,39),wf(:,0),G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,103),wf(:,14),G2(:,:,:,105),gZd)
  call loop_A_Q(G2(:,:,:,105),Q(:,30),ZERO,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,32))
  call loop_AW_Q(G2(:,:,:,103),wf(:,-2),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,22),ZERO,G3(:,:,:,41))
  call loop_AW_Q(G3(:,:,:,41),wf(:,-3),G3(:,:,:,42))
  call loop_A_Q(G3(:,:,:,42),Q(:,30),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,14))
  call loop_AW_Q(G1(:,:,:,97),wf(:,-2),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,6),ZERO,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,22),ZERO,G3(:,:,:,43))
  call loop_AW_Q(G3(:,:,:,43),wf(:,-3),G3(:,:,:,44))
  call loop_A_Q(G3(:,:,:,44),Q(:,30),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,15))
  call loop_AW_Q(G2(:,:,:,107),wf(:,-3),G2(:,:,:,109))
  call loop_A_Q(G2(:,:,:,109),Q(:,14),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-4),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,30),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,16))
  call loop_VQ_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,25),ZERO,G1(:,:,:,102))
  call loop_QW_A(G1(:,:,:,102),wf(:,-2),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,29),ZERO,G2(:,:,:,110))
  call check_last_QA_V(l_switch,G2(:,:,:,110),wf(:,-1),G2tensor(:,23))
  call check_last_QA_V(l_switch,G1(:,:,:,102),wf(:,4),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,1),wf(:,55),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,22),ZERO,G1(:,:,:,104))
  call loop_AW_Q(G1(:,:,:,104),wf(:,-3),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,30),ZERO,G2(:,:,:,111))
  call check_last_AQ_V(l_switch,G2(:,:,:,111),wf(:,0),G2tensor(:,24))
  call check_last_AQ_V(l_switch,G1(:,:,:,104),wf(:,3),G1tensor(:,10))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(16)*M(1)) * den(16)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(16)*M(1)) * den(16)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(15)*M(1)) * den(16)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(15)*M(1)) * den(16)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(12)*M(1))) * den(42)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(11)*M(1))) * den(42)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(12)*M(1))) * den(42)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(11)*M(1))) * den(42)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(11)*M(1)) * den(42)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(10)*M(1)) * den(42)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(11)*M(1)) * den(42)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(10)*M(1)) * den(42)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(18)*M(1))) * den(17)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(17)*M(1))) * den(17)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(18)*M(1))) * den(17)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(17)*M(1))) * den(17)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(18)*M(1))) * den(17)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(17)*M(1))) * den(17)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,16)
  Gcoeff = (-(c(18)*M(1))) * den(17)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(17)*M(1))) * den(17)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,18)
  Gcoeff = (-(c(14)*M(1))) * den(14)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(13)*M(1))) * den(14)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(14)*M(1))) * den(14)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(13)*M(1))) * den(14)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(14)*M(1))) * den(14)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,5)
  Gcoeff = (-(c(13)*M(1))) * den(14)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,7)
  Gcoeff = (-(c(14)*M(1))) * den(14)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,9)
  Gcoeff = (-(c(13)*M(1))) * den(14)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,11)
  Gcoeff = (-(c(14)*M(1))) * den(14)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,10)
  Gcoeff = (-(c(13)*M(1))) * den(14)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,12)
  Gcoeff = (-(c(14)*M(1))) * den(14)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(13)*M(1))) * den(14)
  T4sum(1:70,9) = T4sum(1:70,9) + Gcoeff * G4tensor(:,8)
  Gcoeff = (-(c(5)*M(1))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(4)*M(1))) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(6)*M(1)) * den(5)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(5)*M(1))) * den(25)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(4)*M(1)) * den(25)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(6)*M(1)) * den(19)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(4)*M(1)) * den(2)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,22)
  Gcoeff = (-(c(5)*M(1))) * den(2)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(5)*M(1))) * den(2)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(6)*M(1)) * den(7)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(5)*M(1))) * den(32)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(4)*M(1))) * den(32)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(6)*M(1)) * den(22)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(4)*M(1))) * den(1)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(5)*M(1))) * den(1)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,19)
  Gcoeff = (-(c(5)*M(1))) * den(1)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(3)*M(1))) * den(9)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(9)*M(1)) * den(11)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(3)*M(1))) * den(12)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(9)*M(1)) * den(13)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(2)*M(1)) * den(38)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(8)*M(1))) * den(40)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(1)*M(1)) * den(38)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(7)*M(1))) * den(40)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(2)*M(1)) * den(34)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(8)*M(1))) * den(36)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(1)*M(1))) * den(34)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(7)*M(1)) * den(36)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(2)*M(1)) * den(8)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,29)
  Gcoeff = (-(c(8)*M(1))) * den(10)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(2)*M(1)) * den(8)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(8)*M(1))) * den(10)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,32)
  Gcoeff = (-(c(1)*M(1))) * den(8)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(7)*M(1)) * den(10)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(6)*M(1)) * den(27)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(6)*M(1)) * den(4)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(6)*M(1)) * den(29)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(6)*M(1)) * den(6)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,28)
  Gcoeff = (-(c(5)*M(1)))
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,15)
  Gcoeff = (-(c(5)*M(1)))
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,14)
  Gcoeff = (-(c(5)*M(1)))
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(4)*M(1))
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(6)*M(1)) * den(23)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(6)*M(1)) * den(20)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(6)*M(1)) * den(28)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(6)*M(1)) * den(26)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(6)*M(1)) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(6)*M(1)) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(3)*M(1))) * den(35)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(9)*M(1)) * den(37)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(3)*M(1))) * den(39)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(9)*M(1)) * den(41)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,7)

end subroutine vamp_1

end module ol_vamp_1_ppwwj_ddxwwxg_1_/**/REALKIND
